/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGViewElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGStringList.h"
#include "SVGStringList.h"
#include "SVGViewElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGViewElementTableEntries[] =
{
    { "externalResourcesRequired", JSSVGViewElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, &JSSVGViewElementTableEntries[5] },
    { "zoomAndPan", JSSVGViewElement::ZoomAndPanAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "viewTarget", JSSVGViewElement::ViewTargetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "viewBox", JSSVGViewElement::ViewBoxAttrNum, DontDelete|ReadOnly, 0, &JSSVGViewElementTableEntries[6] },
    { "preserveAspectRatio", JSSVGViewElement::PreserveAspectRatioAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGViewElementTable = 
{
    2, 7, JSSVGViewElementTableEntries, 5
};

/* Hash table for prototype */

static const HashEntry JSSVGViewElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "SVG_ZOOMANDPAN_UNKNOWN", SVGViewElement::SVG_ZOOMANDPAN_UNKNOWN, DontDelete|ReadOnly, 0, 0 },
    { "SVG_ZOOMANDPAN_DISABLE", SVGViewElement::SVG_ZOOMANDPAN_DISABLE, DontDelete|ReadOnly, 0, &JSSVGViewElementPrototypeTableEntries[3] },
    { "SVG_ZOOMANDPAN_MAGNIFY", SVGViewElement::SVG_ZOOMANDPAN_MAGNIFY, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGViewElementPrototypeTable = 
{
    2, 4, JSSVGViewElementPrototypeTableEntries, 3
};

const ClassInfo JSSVGViewElementPrototype::info = { "SVGViewElementPrototype", 0, &JSSVGViewElementPrototypeTable, 0 };

JSObject* JSSVGViewElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGViewElementPrototype>(exec, "[[JSSVGViewElement.prototype]]");
}

bool JSSVGViewElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGViewElementPrototype, JSObject>(exec, &JSSVGViewElementPrototypeTable, this, propertyName, slot);
}

JSValue* JSSVGViewElementPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSSVGViewElement::info = { "SVGViewElement", &JSSVGElement::info, &JSSVGViewElementTable, 0 };

JSSVGViewElement::JSSVGViewElement(ExecState* exec, SVGViewElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGViewElementPrototype::self(exec));
}

bool JSSVGViewElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGViewElement, JSSVGElement>(exec, &JSSVGViewElementTable, this, propertyName, slot);
}

JSValue* JSSVGViewElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ViewTargetAttrNum: {
        SVGViewElement* imp = static_cast<SVGViewElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->viewTarget()));
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGViewElement* imp = static_cast<SVGViewElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ViewBoxAttrNum: {
        SVGViewElement* imp = static_cast<SVGViewElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedRect> obj = imp->viewBoxAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedRect>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedRect>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedRect>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case PreserveAspectRatioAttrNum: {
        SVGViewElement* imp = static_cast<SVGViewElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedPreserveAspectRatio>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedPreserveAspectRatio>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedPreserveAspectRatio>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ZoomAndPanAttrNum: {
        SVGViewElement* imp = static_cast<SVGViewElement*>(impl());

        return jsNumber(imp->zoomAndPan());
    }
    }
    return 0;
}

void JSSVGViewElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGViewElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGViewElementTable, this);
}

void JSSVGViewElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ZoomAndPanAttrNum: {
        SVGViewElement* imp = static_cast<SVGViewElement*>(impl());

        imp->setZoomAndPan(value->toInt32(exec));
        break;
    }
    }
}


}

#endif // ENABLE(SVG)
