/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLHRElement.h"

#include <wtf/GetPtr.h>

#include "HTMLHRElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLHRElementTableEntries[] =
{
    { "align", JSHTMLHRElement::AlignAttrNum, DontDelete, 0, 0 },
    { "width", JSHTMLHRElement::WidthAttrNum, DontDelete, 0, 0 },
    { "constructor", JSHTMLHRElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 },
    { "size", JSHTMLHRElement::SizeAttrNum, DontDelete, 0, 0 },
    { "noShade", JSHTMLHRElement::NoShadeAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSHTMLHRElementTable = 
{
    2, 5, JSHTMLHRElementTableEntries, 5
};

/* Hash table for constructor */

static const HashEntry JSHTMLHRElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLHRElementConstructorTable = 
{
    2, 1, JSHTMLHRElementConstructorTableEntries, 1
};

class JSHTMLHRElementConstructor : public DOMObject {
public:
    JSHTMLHRElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLHRElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLHRElementConstructor::info = { "HTMLHRElementConstructor", 0, &JSHTMLHRElementConstructorTable, 0 };

bool JSHTMLHRElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHRElementConstructor, DOMObject>(exec, &JSHTMLHRElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLHRElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLHRElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLHRElementPrototypeTable = 
{
    2, 1, JSHTMLHRElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLHRElementPrototype::info = { "HTMLHRElementPrototype", 0, &JSHTMLHRElementPrototypeTable, 0 };

JSObject* JSHTMLHRElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLHRElementPrototype>(exec, "[[JSHTMLHRElement.prototype]]");
}

const ClassInfo JSHTMLHRElement::info = { "HTMLHRElement", &JSHTMLElement::info, &JSHTMLHRElementTable, 0 };

JSHTMLHRElement::JSHTMLHRElement(ExecState* exec, HTMLHRElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLHRElementPrototype::self(exec));
}

bool JSHTMLHRElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHRElement, JSHTMLElement>(exec, &JSHTMLHRElementTable, this, propertyName, slot);
}

JSValue* JSHTMLHRElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLHRElement* imp = static_cast<HTMLHRElement*>(impl());

        return jsString(imp->align());
    }
    case NoShadeAttrNum: {
        HTMLHRElement* imp = static_cast<HTMLHRElement*>(impl());

        return jsBoolean(imp->noShade());
    }
    case SizeAttrNum: {
        HTMLHRElement* imp = static_cast<HTMLHRElement*>(impl());

        return jsString(imp->size());
    }
    case WidthAttrNum: {
        HTMLHRElement* imp = static_cast<HTMLHRElement*>(impl());

        return jsString(imp->width());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLHRElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLHRElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLHRElementTable, this);
}

void JSHTMLHRElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLHRElement* imp = static_cast<HTMLHRElement*>(impl());

        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NoShadeAttrNum: {
        HTMLHRElement* imp = static_cast<HTMLHRElement*>(impl());

        imp->setNoShade(value->toBoolean(exec));
        break;
    }
    case SizeAttrNum: {
        HTMLHRElement* imp = static_cast<HTMLHRElement*>(impl());

        imp->setSize(valueToStringWithNullCheck(exec, value));
        break;
    }
    case WidthAttrNum: {
        HTMLHRElement* imp = static_cast<HTMLHRElement*>(impl());

        imp->setWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLHRElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLHRElementConstructor>(exec, "[[HTMLHRElement.constructor]]");
}

}
