/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGNumberList.h"

#include <wtf/GetPtr.h>

#include "ExceptionCode.h"
#include "JSSVGNumber.h"
#include "SVGNumberList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGNumberListTableEntries[] =
{
    { "numberOfItems", JSSVGNumberList::NumberOfItemsAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGNumberListTable = 
{
    2, 1, JSSVGNumberListTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSSVGNumberListPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "clear", JSSVGNumberList::ClearFuncNum, DontDelete|Function, 0, &JSSVGNumberListPrototypeTableEntries[9] },
    { "getItem", JSSVGNumberList::GetItemFuncNum, DontDelete|Function, 1, &JSSVGNumberListPrototypeTableEntries[7] },
    { "insertItemBefore", JSSVGNumberList::InsertItemBeforeFuncNum, DontDelete|Function, 2, &JSSVGNumberListPrototypeTableEntries[8] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "initialize", JSSVGNumberList::InitializeFuncNum, DontDelete|Function, 1, 0 },
    { "replaceItem", JSSVGNumberList::ReplaceItemFuncNum, DontDelete|Function, 2, 0 },
    { "removeItem", JSSVGNumberList::RemoveItemFuncNum, DontDelete|Function, 1, 0 },
    { "appendItem", JSSVGNumberList::AppendItemFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGNumberListPrototypeTable = 
{
    2, 10, JSSVGNumberListPrototypeTableEntries, 7
};

const ClassInfo JSSVGNumberListPrototype::info = { "SVGNumberListPrototype", 0, &JSSVGNumberListPrototypeTable, 0 };

JSObject* JSSVGNumberListPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGNumberListPrototype>(exec, "[[JSSVGNumberList.prototype]]");
}

bool JSSVGNumberListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGNumberListPrototypeFunction, JSObject>(exec, &JSSVGNumberListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGNumberList::info = { "SVGNumberList", 0, &JSSVGNumberListTable, 0 };

JSSVGNumberList::JSSVGNumberList(ExecState* exec, SVGNumberList* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGNumberListPrototype::self(exec));
}

JSSVGNumberList::~JSSVGNumberList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGNumberList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGNumberList, KJS::DOMObject>(exec, &JSSVGNumberListTable, this, propertyName, slot);
}

JSValue* JSSVGNumberList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case NumberOfItemsAttrNum: {
        SVGNumberList* imp = static_cast<SVGNumberList*>(impl());

        return jsNumber(imp->numberOfItems());
    }
    }
    return 0;
}

JSValue* JSSVGNumberListPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGNumberList::info))
      return throwError(exec, TypeError);

    SVGNumberList* imp = static_cast<SVGNumberList*>(static_cast<JSSVGNumberList*>(thisObj)->impl());

    switch (id) {
    case JSSVGNumberList::ClearFuncNum: {
        ExceptionCode ec = 0;

        imp->clear(ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSSVGNumberList::InitializeFuncNum: {
        ExceptionCode ec = 0;
        double item = args[0]->toNumber(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<double>(imp->initialize(item, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGNumberList::GetItemFuncNum: {
        ExceptionCode ec = 0;
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<double>(imp->getItem(index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGNumberList::InsertItemBeforeFuncNum: {
        ExceptionCode ec = 0;
        double item = args[0]->toNumber(exec);
        bool indexOk;
        unsigned index = args[1]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<double>(imp->insertItemBefore(item, index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGNumberList::ReplaceItemFuncNum: {
        ExceptionCode ec = 0;
        double item = args[0]->toNumber(exec);
        bool indexOk;
        unsigned index = args[1]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<double>(imp->replaceItem(item, index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGNumberList::RemoveItemFuncNum: {
        ExceptionCode ec = 0;
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<double>(imp->removeItem(index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGNumberList::AppendItemFuncNum: {
        ExceptionCode ec = 0;
        double item = args[0]->toNumber(exec);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<double>(imp->appendItem(item, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, SVGNumberList* obj)
{
    return KJS::cacheDOMObject<SVGNumberList, JSSVGNumberList>(exec, obj);
}
SVGNumberList* toSVGNumberList(KJS::JSValue* val)
{
    return val->isObject(&JSSVGNumberList::info) ? static_cast<JSSVGNumberList*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
