/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGMarkerElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAngle.h"
#include "JSSVGAnimatedAngle.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "PlatformString.h"
#include "SVGMarkerElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGMarkerElementTableEntries[] =
{
    { "xmlspace", JSSVGMarkerElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "markerWidth", JSSVGMarkerElement::MarkerWidthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "style", JSSVGMarkerElement::StyleAttrNum, DontDelete|ReadOnly, 0, &JSSVGMarkerElementTableEntries[15] },
    { "refX", JSSVGMarkerElement::RefXAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "markerUnits", JSSVGMarkerElement::MarkerUnitsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "xmllang", JSSVGMarkerElement::XmllangAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "className", JSSVGMarkerElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "orientAngle", JSSVGMarkerElement::OrientAngleAttrNum, DontDelete|ReadOnly, 0, &JSSVGMarkerElementTableEntries[14] },
    { "refY", JSSVGMarkerElement::RefYAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "orientType", JSSVGMarkerElement::OrientTypeAttrNum, DontDelete|ReadOnly, 0, &JSSVGMarkerElementTableEntries[16] },
    { "markerHeight", JSSVGMarkerElement::MarkerHeightAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGMarkerElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "viewBox", JSSVGMarkerElement::ViewBoxAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "preserveAspectRatio", JSSVGMarkerElement::PreserveAspectRatioAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGMarkerElementTable = 
{
    2, 17, JSSVGMarkerElementTableEntries, 14
};

/* Hash table for prototype */

static const HashEntry JSSVGMarkerElementPrototypeTableEntries[] =
{
    { "SVG_MARKERUNITS_STROKEWIDTH", SVGMarkerElement::SVG_MARKERUNITS_STROKEWIDTH, DontDelete|ReadOnly, 0, 0 },
    { "SVG_MARKERUNITS_USERSPACEONUSE", SVGMarkerElement::SVG_MARKERUNITS_USERSPACEONUSE, DontDelete|ReadOnly, 0, &JSSVGMarkerElementPrototypeTableEntries[8] },
    { "SVG_MARKERUNITS_UNKNOWN", SVGMarkerElement::SVG_MARKERUNITS_UNKNOWN, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "SVG_MARKER_ORIENT_UNKNOWN", SVGMarkerElement::SVG_MARKER_ORIENT_UNKNOWN, DontDelete|ReadOnly, 0, &JSSVGMarkerElementPrototypeTableEntries[9] },
    { "SVG_MARKER_ORIENT_AUTO", SVGMarkerElement::SVG_MARKER_ORIENT_AUTO, DontDelete|ReadOnly, 0, &JSSVGMarkerElementPrototypeTableEntries[10] },
    { 0, 0, 0, 0, 0 },
    { "SVG_MARKER_ORIENT_ANGLE", SVGMarkerElement::SVG_MARKER_ORIENT_ANGLE, DontDelete|ReadOnly, 0, 0 },
    { "setOrientToAuto", JSSVGMarkerElement::SetOrientToAutoFuncNum, DontDelete|Function, 0, 0 },
    { "setOrientToAngle", JSSVGMarkerElement::SetOrientToAngleFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGMarkerElementPrototypeTable = 
{
    2, 11, JSSVGMarkerElementPrototypeTableEntries, 8
};

const ClassInfo JSSVGMarkerElementPrototype::info = { "SVGMarkerElementPrototype", 0, &JSSVGMarkerElementPrototypeTable, 0 };

JSObject* JSSVGMarkerElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGMarkerElementPrototype>(exec, "[[JSSVGMarkerElement.prototype]]");
}

bool JSSVGMarkerElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGMarkerElementPrototypeFunction, JSSVGMarkerElementPrototype, JSObject>(exec, &JSSVGMarkerElementPrototypeTable, this, propertyName, slot);
}

JSValue* JSSVGMarkerElementPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSSVGMarkerElement::info = { "SVGMarkerElement", &JSSVGElement::info, &JSSVGMarkerElementTable, 0 };

JSSVGMarkerElement::JSSVGMarkerElement(ExecState* exec, SVGMarkerElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGMarkerElementPrototype::self(exec));
}

bool JSSVGMarkerElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMarkerElement, JSSVGElement>(exec, &JSSVGMarkerElementTable, this, propertyName, slot);
}

JSValue* JSSVGMarkerElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RefXAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->refXAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RefYAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->refYAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case MarkerUnitsAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedEnumeration> obj = imp->markerUnitsAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedEnumeration>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedEnumeration>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedEnumeration>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case MarkerWidthAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->markerWidthAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case MarkerHeightAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->markerHeightAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case OrientTypeAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedEnumeration> obj = imp->orientTypeAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedEnumeration>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedEnumeration>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedEnumeration>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case OrientAngleAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedAngle> obj = imp->orientAngleAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedAngle>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedAngle>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedAngle>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case XmllangAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case ViewBoxAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedRect> obj = imp->viewBoxAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedRect>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedRect>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedRect>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case PreserveAspectRatioAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedPreserveAspectRatio>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedPreserveAspectRatio>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedPreserveAspectRatio>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    }
    return 0;
}

void JSSVGMarkerElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGMarkerElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGMarkerElementTable, this);
}

void JSSVGMarkerElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGMarkerElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGMarkerElement::info))
      return throwError(exec, TypeError);

    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGMarkerElement::SetOrientToAutoFuncNum: {

        imp->setOrientToAuto();
        return jsUndefined();
    }
    case JSSVGMarkerElement::SetOrientToAngleFuncNum: {
        SVGAngle* angle = toSVGAngle(args[0]);

        imp->setOrientToAngle(angle);
        return jsUndefined();
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
