/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGDefsElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGDefsElement.h"
#include "SVGElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGDefsElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "farthestViewportElement", JSSVGDefsElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "systemLanguage", JSSVGDefsElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, &JSSVGDefsElementTableEntries[11] },
    { 0, 0, 0, 0, 0 },
    { "xmlspace", JSSVGDefsElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "requiredExtensions", JSSVGDefsElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, &JSSVGDefsElementTableEntries[12] },
    { "nearestViewportElement", JSSVGDefsElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "style", JSSVGDefsElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "requiredFeatures", JSSVGDefsElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "xmllang", JSSVGDefsElement::XmllangAttrNum, DontDelete, 0, &JSSVGDefsElementTableEntries[14] },
    { "externalResourcesRequired", JSSVGDefsElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, &JSSVGDefsElementTableEntries[13] },
    { "className", JSSVGDefsElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "transform", JSSVGDefsElement::TransformAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGDefsElementTable = 
{
    2, 15, JSSVGDefsElementTableEntries, 11
};

/* Hash table for prototype */

static const HashEntry JSSVGDefsElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGDefsElement::HasExtensionFuncNum, DontDelete|Function, 1, &JSSVGDefsElementPrototypeTableEntries[6] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getBBox", JSSVGDefsElement::GetBBoxFuncNum, DontDelete|Function, 0, &JSSVGDefsElementPrototypeTableEntries[5] },
    { "getTransformToElement", JSSVGDefsElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getCTM", JSSVGDefsElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getScreenCTM", JSSVGDefsElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSSVGDefsElementPrototypeTable = 
{
    2, 7, JSSVGDefsElementPrototypeTableEntries, 5
};

const ClassInfo JSSVGDefsElementPrototype::info = { "SVGDefsElementPrototype", 0, &JSSVGDefsElementPrototypeTable, 0 };

JSObject* JSSVGDefsElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGDefsElementPrototype>(exec, "[[JSSVGDefsElement.prototype]]");
}

bool JSSVGDefsElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGDefsElementPrototypeFunction, JSObject>(exec, &JSSVGDefsElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGDefsElement::info = { "SVGDefsElement", &JSSVGElement::info, &JSSVGDefsElementTable, 0 };

JSSVGDefsElement::JSSVGDefsElement(ExecState* exec, SVGDefsElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGDefsElementPrototype::self(exec));
}

bool JSSVGDefsElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGDefsElement, JSSVGElement>(exec, &JSSVGDefsElementTable, this, propertyName, slot);
}

JSValue* JSSVGDefsElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RequiredFeaturesAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case TransformAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    }
    return 0;
}

void JSSVGDefsElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGDefsElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGDefsElementTable, this);
}

void JSSVGDefsElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGDefsElement* imp = static_cast<SVGDefsElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGDefsElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGDefsElement::info))
      return throwError(exec, TypeError);

    SVGDefsElement* imp = static_cast<SVGDefsElement*>(static_cast<JSSVGDefsElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGDefsElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGDefsElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGDefsElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGDefsElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGDefsElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
