/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLDirectoryElement.h"

#include <wtf/GetPtr.h>

#include "HTMLDirectoryElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLDirectoryElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "compact", JSHTMLDirectoryElement::CompactAttrNum, DontDelete, 0, &JSHTMLDirectoryElementTableEntries[2] },
    { "constructor", JSHTMLDirectoryElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementTable = 
{
    2, 3, JSHTMLDirectoryElementTableEntries, 2
};

/* Hash table for constructor */

static const HashEntry JSHTMLDirectoryElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementConstructorTable = 
{
    2, 1, JSHTMLDirectoryElementConstructorTableEntries, 1
};

class JSHTMLDirectoryElementConstructor : public DOMObject {
public:
    JSHTMLDirectoryElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLDirectoryElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLDirectoryElementConstructor::info = { "HTMLDirectoryElementConstructor", 0, &JSHTMLDirectoryElementConstructorTable, 0 };

bool JSHTMLDirectoryElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDirectoryElementConstructor, DOMObject>(exec, &JSHTMLDirectoryElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLDirectoryElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLDirectoryElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementPrototypeTable = 
{
    2, 1, JSHTMLDirectoryElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLDirectoryElementPrototype::info = { "HTMLDirectoryElementPrototype", 0, &JSHTMLDirectoryElementPrototypeTable, 0 };

JSObject* JSHTMLDirectoryElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLDirectoryElementPrototype>(exec, "[[JSHTMLDirectoryElement.prototype]]");
}

const ClassInfo JSHTMLDirectoryElement::info = { "HTMLDirectoryElement", &JSHTMLElement::info, &JSHTMLDirectoryElementTable, 0 };

JSHTMLDirectoryElement::JSHTMLDirectoryElement(ExecState* exec, HTMLDirectoryElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLDirectoryElementPrototype::self(exec));
}

bool JSHTMLDirectoryElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDirectoryElement, JSHTMLElement>(exec, &JSHTMLDirectoryElementTable, this, propertyName, slot);
}

JSValue* JSHTMLDirectoryElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CompactAttrNum: {
        HTMLDirectoryElement* imp = static_cast<HTMLDirectoryElement*>(impl());

        return jsBoolean(imp->compact());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLDirectoryElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLDirectoryElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLDirectoryElementTable, this);
}

void JSHTMLDirectoryElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case CompactAttrNum: {
        HTMLDirectoryElement* imp = static_cast<HTMLDirectoryElement*>(impl());

        imp->setCompact(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSHTMLDirectoryElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLDirectoryElementConstructor>(exec, "[[HTMLDirectoryElement.constructor]]");
}

}
