/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLQuoteElement.h"

#include <wtf/GetPtr.h>

#include "HTMLQuoteElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLQuoteElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "cite", JSHTMLQuoteElement::CiteAttrNum, DontDelete, 0, &JSHTMLQuoteElementTableEntries[2] },
    { "constructor", JSHTMLQuoteElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLQuoteElementTable = 
{
    2, 3, JSHTMLQuoteElementTableEntries, 2
};

/* Hash table for constructor */

static const HashEntry JSHTMLQuoteElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementConstructorTable = 
{
    2, 1, JSHTMLQuoteElementConstructorTableEntries, 1
};

class JSHTMLQuoteElementConstructor : public DOMObject {
public:
    JSHTMLQuoteElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLQuoteElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLQuoteElementConstructor::info = { "HTMLQuoteElementConstructor", 0, &JSHTMLQuoteElementConstructorTable, 0 };

bool JSHTMLQuoteElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLQuoteElementConstructor, DOMObject>(exec, &JSHTMLQuoteElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLQuoteElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLQuoteElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementPrototypeTable = 
{
    2, 1, JSHTMLQuoteElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLQuoteElementPrototype::info = { "HTMLQuoteElementPrototype", 0, &JSHTMLQuoteElementPrototypeTable, 0 };

JSObject* JSHTMLQuoteElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLQuoteElementPrototype>(exec, "[[JSHTMLQuoteElement.prototype]]");
}

const ClassInfo JSHTMLQuoteElement::info = { "HTMLQuoteElement", &JSHTMLElement::info, &JSHTMLQuoteElementTable, 0 };

JSHTMLQuoteElement::JSHTMLQuoteElement(ExecState* exec, HTMLQuoteElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLQuoteElementPrototype::self(exec));
}

bool JSHTMLQuoteElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLQuoteElement, JSHTMLElement>(exec, &JSHTMLQuoteElementTable, this, propertyName, slot);
}

JSValue* JSHTMLQuoteElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CiteAttrNum: {
        HTMLQuoteElement* imp = static_cast<HTMLQuoteElement*>(impl());

        return jsString(imp->cite());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLQuoteElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLQuoteElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLQuoteElementTable, this);
}

void JSHTMLQuoteElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case CiteAttrNum: {
        HTMLQuoteElement* imp = static_cast<HTMLQuoteElement*>(impl());

        imp->setCite(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLQuoteElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLQuoteElementConstructor>(exec, "[[HTMLQuoteElement.constructor]]");
}

}
