/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGStyleElement.h"

#include <wtf/GetPtr.h>

#include "PlatformString.h"
#include "SVGStyleElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGStyleElementTableEntries[] =
{
    { "xmlspace", JSSVGStyleElement::XmlspaceAttrNum, DontDelete, 0, &JSSVGStyleElementTableEntries[4] },
    { "media", JSSVGStyleElement::MediaAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "type", JSSVGStyleElement::TypeAttrNum, DontDelete, 0, 0 },
    { "title", JSSVGStyleElement::TitleAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSSVGStyleElementTable = 
{
    2, 5, JSSVGStyleElementTableEntries, 4
};

/* Hash table for prototype */

static const HashEntry JSSVGStyleElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGStyleElementPrototypeTable = 
{
    2, 1, JSSVGStyleElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGStyleElementPrototype::info = { "SVGStyleElementPrototype", 0, &JSSVGStyleElementPrototypeTable, 0 };

JSObject* JSSVGStyleElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGStyleElementPrototype>(exec, "[[JSSVGStyleElement.prototype]]");
}

const ClassInfo JSSVGStyleElement::info = { "SVGStyleElement", &JSSVGElement::info, &JSSVGStyleElementTable, 0 };

JSSVGStyleElement::JSSVGStyleElement(ExecState* exec, SVGStyleElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGStyleElementPrototype::self(exec));
}

bool JSSVGStyleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStyleElement, JSSVGElement>(exec, &JSSVGStyleElementTable, this, propertyName, slot);
}

JSValue* JSSVGStyleElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XmlspaceAttrNum: {
        SVGStyleElement* imp = static_cast<SVGStyleElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case TypeAttrNum: {
        SVGStyleElement* imp = static_cast<SVGStyleElement*>(impl());

        return jsString(imp->type());
    }
    case MediaAttrNum: {
        SVGStyleElement* imp = static_cast<SVGStyleElement*>(impl());

        return jsString(imp->media());
    }
    case TitleAttrNum: {
        SVGStyleElement* imp = static_cast<SVGStyleElement*>(impl());

        return jsString(imp->title());
    }
    }
    return 0;
}

void JSSVGStyleElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGStyleElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGStyleElementTable, this);
}

void JSSVGStyleElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmlspaceAttrNum: {
        SVGStyleElement* imp = static_cast<SVGStyleElement*>(impl());

        ExceptionCode ec = 0;
        imp->setXmlspace(value->toString(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case TypeAttrNum: {
        SVGStyleElement* imp = static_cast<SVGStyleElement*>(impl());

        ExceptionCode ec = 0;
        imp->setType(value->toString(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case MediaAttrNum: {
        SVGStyleElement* imp = static_cast<SVGStyleElement*>(impl());

        ExceptionCode ec = 0;
        imp->setMedia(value->toString(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case TitleAttrNum: {
        SVGStyleElement* imp = static_cast<SVGStyleElement*>(impl());

        ExceptionCode ec = 0;
        imp->setTitle(value->toString(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}


}

#endif // ENABLE(SVG)
