/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGTextContentElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "ExceptionCode.h"
#include "FloatPoint.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGStringList.h"
#include "SVGTextContentElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGTextContentElementTableEntries[] =
{
    { "xmllang", JSSVGTextContentElement::XmllangAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "xmlspace", JSSVGTextContentElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "requiredExtensions", JSSVGTextContentElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "systemLanguage", JSSVGTextContentElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "lengthAdjust", JSSVGTextContentElement::LengthAdjustAttrNum, DontDelete|ReadOnly, 0, &JSSVGTextContentElementTableEntries[10] },
    { "className", JSSVGTextContentElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, &JSSVGTextContentElementTableEntries[11] },
    { 0, 0, 0, 0, 0 },
    { "textLength", JSSVGTextContentElement::TextLengthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredFeatures", JSSVGTextContentElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGTextContentElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "style", JSSVGTextContentElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGTextContentElementTable = 
{
    2, 12, JSSVGTextContentElementTableEntries, 10
};

/* Hash table for prototype */

static const HashEntry JSSVGTextContentElementPrototypeTableEntries[] =
{
    { "getNumberOfChars", JSSVGTextContentElement::GetNumberOfCharsFuncNum, DontDelete|Function, 0, &JSSVGTextContentElementPrototypeTableEntries[15] },
    { "getExtentOfChar", JSSVGTextContentElement::GetExtentOfCharFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getRotationOfChar", JSSVGTextContentElement::GetRotationOfCharFuncNum, DontDelete|Function, 1, 0 },
    { "getStartPositionOfChar", JSSVGTextContentElement::GetStartPositionOfCharFuncNum, DontDelete|Function, 1, 0 },
    { "getComputedTextLength", JSSVGTextContentElement::GetComputedTextLengthFuncNum, DontDelete|Function, 0, &JSSVGTextContentElementPrototypeTableEntries[14] },
    { 0, 0, 0, 0, 0 },
    { "getEndPositionOfChar", JSSVGTextContentElement::GetEndPositionOfCharFuncNum, DontDelete|Function, 1, 0 },
    { "hasExtension", JSSVGTextContentElement::HasExtensionFuncNum, DontDelete|Function, 1, 0 },
    { "LENGTHADJUST_SPACING", SVGTextContentElement::LENGTHADJUST_SPACING, DontDelete|ReadOnly, 0, &JSSVGTextContentElementPrototypeTableEntries[13] },
    { 0, 0, 0, 0, 0 },
    { "LENGTHADJUST_UNKNOWN", SVGTextContentElement::LENGTHADJUST_UNKNOWN, DontDelete|ReadOnly, 0, 0 },
    { "LENGTHADJUST_SPACINGANDGLYPHS", SVGTextContentElement::LENGTHADJUST_SPACINGANDGLYPHS, DontDelete|ReadOnly, 0, &JSSVGTextContentElementPrototypeTableEntries[16] },
    { "getSubStringLength", JSSVGTextContentElement::GetSubStringLengthFuncNum, DontDelete|Function, 2, 0 },
    { "getCharNumAtPosition", JSSVGTextContentElement::GetCharNumAtPositionFuncNum, DontDelete|Function, 1, 0 },
    { "selectSubString", JSSVGTextContentElement::SelectSubStringFuncNum, DontDelete|Function, 2, 0 }
};

static const HashTable JSSVGTextContentElementPrototypeTable = 
{
    2, 17, JSSVGTextContentElementPrototypeTableEntries, 13
};

const ClassInfo JSSVGTextContentElementPrototype::info = { "SVGTextContentElementPrototype", 0, &JSSVGTextContentElementPrototypeTable, 0 };

JSObject* JSSVGTextContentElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGTextContentElementPrototype>(exec, "[[JSSVGTextContentElement.prototype]]");
}

bool JSSVGTextContentElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGTextContentElementPrototypeFunction, JSSVGTextContentElementPrototype, JSObject>(exec, &JSSVGTextContentElementPrototypeTable, this, propertyName, slot);
}

JSValue* JSSVGTextContentElementPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSSVGTextContentElement::info = { "SVGTextContentElement", &JSSVGElement::info, &JSSVGTextContentElementTable, 0 };

JSSVGTextContentElement::JSSVGTextContentElement(ExecState* exec, SVGTextContentElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGTextContentElementPrototype::self(exec));
}

bool JSSVGTextContentElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextContentElement, JSSVGElement>(exec, &JSSVGTextContentElementTable, this, propertyName, slot);
}

JSValue* JSSVGTextContentElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TextLengthAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->textLengthAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case LengthAdjustAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedEnumeration> obj = imp->lengthAdjustAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedEnumeration>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedEnumeration>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedEnumeration>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RequiredFeaturesAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    }
    return 0;
}

void JSSVGTextContentElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGTextContentElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGTextContentElementTable, this);
}

void JSSVGTextContentElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGTextContentElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGTextContentElement::info))
      return throwError(exec, TypeError);

    SVGTextContentElement* imp = static_cast<SVGTextContentElement*>(static_cast<JSSVGTextContentElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGTextContentElement::GetNumberOfCharsFuncNum: {


        KJS::JSValue* result = jsNumber(imp->getNumberOfChars());
        return result;
    }
    case JSSVGTextContentElement::GetComputedTextLengthFuncNum: {


        KJS::JSValue* result = jsNumber(imp->getComputedTextLength());
        return result;
    }
    case JSSVGTextContentElement::GetSubStringLengthFuncNum: {
        ExceptionCode ec = 0;
        bool offsetOk;
        unsigned offset = args[0]->toInt32(exec, offsetOk);
        if (!offsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        bool lengthOk;
        unsigned length = args[1]->toInt32(exec, lengthOk);
        if (!lengthOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = jsNumber(imp->getSubStringLength(offset, length, ec));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGTextContentElement::GetStartPositionOfCharFuncNum: {
        ExceptionCode ec = 0;
        bool offsetOk;
        unsigned offset = args[0]->toInt32(exec, offsetOk);
        if (!offsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatPoint>(imp->getStartPositionOfChar(offset, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGTextContentElement::GetEndPositionOfCharFuncNum: {
        ExceptionCode ec = 0;
        bool offsetOk;
        unsigned offset = args[0]->toInt32(exec, offsetOk);
        if (!offsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatPoint>(imp->getEndPositionOfChar(offset, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGTextContentElement::GetExtentOfCharFuncNum: {
        ExceptionCode ec = 0;
        bool offsetOk;
        unsigned offset = args[0]->toInt32(exec, offsetOk);
        if (!offsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getExtentOfChar(offset, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGTextContentElement::GetRotationOfCharFuncNum: {
        ExceptionCode ec = 0;
        bool offsetOk;
        unsigned offset = args[0]->toInt32(exec, offsetOk);
        if (!offsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = jsNumber(imp->getRotationOfChar(offset, ec));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGTextContentElement::GetCharNumAtPositionFuncNum: {
        FloatPoint point = toSVGPoint(args[0]);


        KJS::JSValue* result = jsNumber(imp->getCharNumAtPosition(point));
        return result;
    }
    case JSSVGTextContentElement::SelectSubStringFuncNum: {
        ExceptionCode ec = 0;
        bool offsetOk;
        unsigned offset = args[0]->toInt32(exec, offsetOk);
        if (!offsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        bool lengthOk;
        unsigned length = args[1]->toInt32(exec, lengthOk);
        if (!lengthOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->selectSubString(offset, length, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSSVGTextContentElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
