/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSElement.h"

#include <wtf/GetPtr.h>

#include "Attr.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "JSAttr.h"
#include "JSCSSStyleDeclaration.h"
#include "JSElement.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeList.h"
#include "PlatformString.h"
#include "kjs_dom.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "clientLeft", JSElement::ClientLeftAttrNum, DontDelete|ReadOnly, 0, &JSElementTableEntries[20] },
    { 0, 0, 0, 0, 0 },
    { "tagName", JSElement::TagNameAttrNum, DontDelete|ReadOnly, 0, &JSElementTableEntries[16] },
    { 0, 0, 0, 0, 0 },
    { "offsetWidth", JSElement::OffsetWidthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "offsetParent", JSElement::OffsetParentAttrNum, DontDelete|ReadOnly, 0, &JSElementTableEntries[18] },
    { 0, 0, 0, 0, 0 },
    { "scrollWidth", JSElement::ScrollWidthAttrNum, DontDelete|ReadOnly, 0, &JSElementTableEntries[22] },
    { "offsetTop", JSElement::OffsetTopAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "offsetLeft", JSElement::OffsetLeftAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "style", JSElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "scrollLeft", JSElement::ScrollLeftAttrNum, DontDelete, 0, 0 },
    { "offsetHeight", JSElement::OffsetHeightAttrNum, DontDelete|ReadOnly, 0, &JSElementTableEntries[17] },
    { "clientTop", JSElement::ClientTopAttrNum, DontDelete|ReadOnly, 0, &JSElementTableEntries[21] },
    { "clientWidth", JSElement::ClientWidthAttrNum, DontDelete|ReadOnly, 0, &JSElementTableEntries[19] },
    { "clientHeight", JSElement::ClientHeightAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "scrollTop", JSElement::ScrollTopAttrNum, DontDelete, 0, 0 },
    { "scrollHeight", JSElement::ScrollHeightAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSElementTable = 
{
    2, 23, JSElementTableEntries, 16
};

/* Hash table for constructor */

static const HashEntry JSElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSElementConstructorTable = 
{
    2, 1, JSElementConstructorTableEntries, 1
};

class JSElementConstructor : public DOMObject {
public:
    JSElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSElementConstructor::info = { "ElementConstructor", 0, &JSElementConstructorTable, 0 };

bool JSElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSElementConstructor, DOMObject>(exec, &JSElementConstructorTable, this, propertyName, slot);
}

JSValue* JSElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSElementPrototypeTableEntries[] =
{
    { "removeAttributeNode", JSElement::RemoveAttributeNodeFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "removeAttribute", JSElement::RemoveAttributeFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "getAttributeNode", JSElement::GetAttributeNodeFuncNum, DontDelete|Function, 1, &JSElementPrototypeTableEntries[27] },
    { "getAttributeNodeNS", JSElement::GetAttributeNodeNSFuncNum, DontDelete|Function, 2, 0 },
    { 0, 0, 0, 0, 0 },
    { "getElementsByTagName", JSElement::GetElementsByTagNameFuncNum, DontDelete|Function, 1, 0 },
    { "getElementsByTagNameNS", JSElement::GetElementsByTagNameNSFuncNum, DontDelete|Function, 2, &JSElementPrototypeTableEntries[24] },
    { "getAttributeNS", JSElement::GetAttributeNSFuncNum, DontDelete|Function, 2, &JSElementPrototypeTableEntries[25] },
    { "setAttributeNode", JSElement::SetAttributeNodeFuncNum, DontDelete|Function, 1, &JSElementPrototypeTableEntries[26] },
    { "scrollByLines", JSElement::ScrollByLinesFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "setAttribute", JSElement::SetAttributeFuncNum, DontDelete|Function, 2, 0 },
    { 0, 0, 0, 0, 0 },
    { "scrollByPages", JSElement::ScrollByPagesFuncNum, DontDelete|Function, 1, 0 },
    { "removeAttributeNS", JSElement::RemoveAttributeNSFuncNum, DontDelete|Function, 2, 0 },
    { "setAttributeNS", JSElement::SetAttributeNSFuncNum, DontDelete|Function, 3, 0 },
    { 0, 0, 0, 0, 0 },
    { "setAttributeNodeNS", JSElement::SetAttributeNodeNSFuncNum, DontDelete|Function, 1, &JSElementPrototypeTableEntries[29] },
    { "getAttribute", JSElement::GetAttributeFuncNum, DontDelete|Function, 1, &JSElementPrototypeTableEntries[23] },
    { "scrollIntoView", JSElement::ScrollIntoViewFuncNum, DontDelete|Function, 1, 0 },
    { "hasAttribute", JSElement::HasAttributeFuncNum, DontDelete|Function, 1, 0 },
    { "hasAttributeNS", JSElement::HasAttributeNSFuncNum, DontDelete|Function, 2, 0 },
    { "focus", JSElement::FocusFuncNum, DontDelete|Function, 0, &JSElementPrototypeTableEntries[28] },
    { "blur", JSElement::BlurFuncNum, DontDelete|Function, 0, 0 },
    { "insertAdjacentElement", JSElement::InsertAdjacentElementFuncNum, DontDelete|Function, 2, 0 },
    { "contains", JSElement::ContainsFuncNum, DontDelete|Function, 1, 0 },
    { "scrollIntoViewIfNeeded", JSElement::ScrollIntoViewIfNeededFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSElementPrototypeTable = 
{
    2, 30, JSElementPrototypeTableEntries, 23
};

const ClassInfo JSElementPrototype::info = { "ElementPrototype", 0, &JSElementPrototypeTable, 0 };

JSObject* JSElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSElementPrototype>(exec, "[[JSElement.prototype]]");
}

bool JSElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSElementPrototypeFunction, JSObject>(exec, &JSElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSElement::info = { "Element", &JSEventTargetNode::info, &JSElementTable, 0 };

JSElement::JSElement(ExecState* exec, Element* impl)
    : JSEventTargetNode(exec, impl)
{
    setPrototype(JSElementPrototype::self(exec));
}

bool JSElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSElement, JSEventTargetNode>(exec, &JSElementTable, this, propertyName, slot);
}

JSValue* JSElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TagNameAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsStringOrNull(imp->tagName());
    }
    case StyleAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case OffsetLeftAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->offsetLeft());
    }
    case OffsetTopAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->offsetTop());
    }
    case OffsetWidthAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->offsetWidth());
    }
    case OffsetHeightAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->offsetHeight());
    }
    case OffsetParentAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return toJS(exec, WTF::getPtr(imp->offsetParent()));
    }
    case ClientLeftAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->clientLeft());
    }
    case ClientTopAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->clientTop());
    }
    case ClientWidthAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->clientWidth());
    }
    case ClientHeightAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->clientHeight());
    }
    case ScrollLeftAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->scrollLeft());
    }
    case ScrollTopAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->scrollTop());
    }
    case ScrollWidthAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->scrollWidth());
    }
    case ScrollHeightAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        return jsNumber(imp->scrollHeight());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSElement, JSEventTargetNode>(exec, propertyName, value, attr, &JSElementTable, this);
}

void JSElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ScrollLeftAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        imp->setScrollLeft(value->toInt32(exec));
        break;
    }
    case ScrollTopAttrNum: {
        Element* imp = static_cast<Element*>(impl());

        imp->setScrollTop(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSElementConstructor>(exec, "[[Element.constructor]]");
}
JSValue* JSElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
      return throwError(exec, TypeError);

    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObj)->impl());

    switch (id) {
    case JSElement::GetAttributeFuncNum: {
        String name = args[0]->toString(exec);


        KJS::JSValue* result = jsStringOrNull(imp->getAttribute(name));
        return result;
    }
    case JSElement::SetAttributeFuncNum: {
        return static_cast<JSElement*>(thisObj)->setAttribute(exec, args);
    }
    case JSElement::RemoveAttributeFuncNum: {
        ExceptionCode ec = 0;
        String name = args[0]->toString(exec);

        imp->removeAttribute(name, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSElement::GetAttributeNodeFuncNum: {
        String name = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getAttributeNode(name)));
        return result;
    }
    case JSElement::SetAttributeNodeFuncNum: {
        return static_cast<JSElement*>(thisObj)->setAttributeNode(exec, args);
    }
    case JSElement::RemoveAttributeNodeFuncNum: {
        ExceptionCode ec = 0;
        bool oldAttrOk;
        Attr* oldAttr = toAttr(args[0], oldAttrOk);
        if (!oldAttrOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->removeAttributeNode(oldAttr, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSElement::GetElementsByTagNameFuncNum: {
        String name = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByTagName(name)));
        return result;
    }
    case JSElement::GetAttributeNSFuncNum: {
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String localName = args[1]->toString(exec);


        KJS::JSValue* result = jsString(imp->getAttributeNS(namespaceURI, localName));
        return result;
    }
    case JSElement::SetAttributeNSFuncNum: {
        return static_cast<JSElement*>(thisObj)->setAttributeNS(exec, args);
    }
    case JSElement::RemoveAttributeNSFuncNum: {
        ExceptionCode ec = 0;
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String localName = args[1]->toString(exec);

        imp->removeAttributeNS(namespaceURI, localName, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSElement::GetElementsByTagNameNSFuncNum: {
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String localName = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByTagNameNS(namespaceURI, localName)));
        return result;
    }
    case JSElement::GetAttributeNodeNSFuncNum: {
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String localName = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getAttributeNodeNS(namespaceURI, localName)));
        return result;
    }
    case JSElement::SetAttributeNodeNSFuncNum: {
        return static_cast<JSElement*>(thisObj)->setAttributeNodeNS(exec, args);
    }
    case JSElement::HasAttributeFuncNum: {
        String name = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasAttribute(name));
        return result;
    }
    case JSElement::HasAttributeNSFuncNum: {
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String localName = args[1]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasAttributeNS(namespaceURI, localName));
        return result;
    }
    case JSElement::FocusFuncNum: {

        imp->focus();
        return jsUndefined();
    }
    case JSElement::BlurFuncNum: {

        imp->blur();
        return jsUndefined();
    }
    case JSElement::ScrollIntoViewFuncNum: {

        int argsCount = args.size();
        if (argsCount < 1) {
            imp->scrollIntoView();
            return jsUndefined();
        }

        bool alignWithTop = args[0]->toBoolean(exec);

        imp->scrollIntoView(alignWithTop);
        return jsUndefined();
    }
    case JSElement::InsertAdjacentElementFuncNum: {
        ExceptionCode ec = 0;
        String position = args[0]->toString(exec);
        Node* element = toNode(args[1]);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->insertAdjacentElement(position, element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSElement::ContainsFuncNum: {
        Element* element = toElement(args[0]);


        KJS::JSValue* result = jsBoolean(imp->contains(element));
        return result;
    }
    case JSElement::ScrollIntoViewIfNeededFuncNum: {

        int argsCount = args.size();
        if (argsCount < 1) {
            imp->scrollIntoViewIfNeeded();
            return jsUndefined();
        }

        bool centerIfNeeded = args[0]->toBoolean(exec);

        imp->scrollIntoViewIfNeeded(centerIfNeeded);
        return jsUndefined();
    }
    case JSElement::ScrollByLinesFuncNum: {
        bool linesOk;
        int lines = args[0]->toInt32(exec, linesOk);
        if (!linesOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->scrollByLines(lines);
        return jsUndefined();
    }
    case JSElement::ScrollByPagesFuncNum: {
        bool pagesOk;
        int pages = args[0]->toInt32(exec, pagesOk);
        if (!pagesOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->scrollByPages(pages);
        return jsUndefined();
    }
    }
    return 0;
}
Element* toElement(KJS::JSValue* val)
{
    return val->isObject(&JSElement::info) ? static_cast<JSElement*>(val)->impl() : 0;
}

Element* JSElement::impl() const
{
    return static_cast<Element*>(JSEventTargetNode::impl());
}

}
