/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLAreaElement.h"

#include <wtf/GetPtr.h>

#include "HTMLAreaElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLAreaElementTableEntries[] =
{
    { "hostname", JSHTMLAreaElement::HostnameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "target", JSHTMLAreaElement::TargetAttrNum, DontDelete, 0, 0 },
    { "hash", JSHTMLAreaElement::HashAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "href", JSHTMLAreaElement::HrefAttrNum, DontDelete, 0, &JSHTMLAreaElementTableEntries[17] },
    { "alt", JSHTMLAreaElement::AltAttrNum, DontDelete, 0, &JSHTMLAreaElementTableEntries[18] },
    { 0, 0, 0, 0, 0 },
    { "port", JSHTMLAreaElement::PortAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "shape", JSHTMLAreaElement::ShapeAttrNum, DontDelete, 0, 0 },
    { "coords", JSHTMLAreaElement::CoordsAttrNum, DontDelete, 0, &JSHTMLAreaElementTableEntries[16] },
    { "accessKey", JSHTMLAreaElement::AccessKeyAttrNum, DontDelete, 0, 0 },
    { "noHref", JSHTMLAreaElement::NoHrefAttrNum, DontDelete, 0, 0 },
    { "tabIndex", JSHTMLAreaElement::TabIndexAttrNum, DontDelete, 0, 0 },
    { "host", JSHTMLAreaElement::HostAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "pathname", JSHTMLAreaElement::PathnameAttrNum, DontDelete|ReadOnly, 0, &JSHTMLAreaElementTableEntries[19] },
    { "protocol", JSHTMLAreaElement::ProtocolAttrNum, DontDelete|ReadOnly, 0, &JSHTMLAreaElementTableEntries[20] },
    { "search", JSHTMLAreaElement::SearchAttrNum, DontDelete|ReadOnly, 0, &JSHTMLAreaElementTableEntries[21] },
    { "constructor", JSHTMLAreaElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLAreaElementTable = 
{
    2, 22, JSHTMLAreaElementTableEntries, 16
};

/* Hash table for constructor */

static const HashEntry JSHTMLAreaElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLAreaElementConstructorTable = 
{
    2, 1, JSHTMLAreaElementConstructorTableEntries, 1
};

class JSHTMLAreaElementConstructor : public DOMObject {
public:
    JSHTMLAreaElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLAreaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLAreaElementConstructor::info = { "HTMLAreaElementConstructor", 0, &JSHTMLAreaElementConstructorTable, 0 };

bool JSHTMLAreaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAreaElementConstructor, DOMObject>(exec, &JSHTMLAreaElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLAreaElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLAreaElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLAreaElementPrototypeTable = 
{
    2, 1, JSHTMLAreaElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLAreaElementPrototype::info = { "HTMLAreaElementPrototype", 0, &JSHTMLAreaElementPrototypeTable, 0 };

JSObject* JSHTMLAreaElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLAreaElementPrototype>(exec, "[[JSHTMLAreaElement.prototype]]");
}

const ClassInfo JSHTMLAreaElement::info = { "HTMLAreaElement", &JSHTMLElement::info, &JSHTMLAreaElementTable, 0 };

JSHTMLAreaElement::JSHTMLAreaElement(ExecState* exec, HTMLAreaElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLAreaElementPrototype::self(exec));
}

bool JSHTMLAreaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAreaElement, JSHTMLElement>(exec, &JSHTMLAreaElementTable, this, propertyName, slot);
}

JSValue* JSHTMLAreaElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->accessKey());
    }
    case AltAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->alt());
    }
    case CoordsAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->coords());
    }
    case HrefAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->href());
    }
    case NoHrefAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsBoolean(imp->noHref());
    }
    case ShapeAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->shape());
    }
    case TabIndexAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsNumber(imp->tabIndex());
    }
    case TargetAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->target());
    }
    case HashAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->hash());
    }
    case HostAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->host());
    }
    case HostnameAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->hostname());
    }
    case PathnameAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->pathname());
    }
    case PortAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->port());
    }
    case ProtocolAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->protocol());
    }
    case SearchAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        return jsString(imp->search());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLAreaElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLAreaElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLAreaElementTable, this);
}

void JSHTMLAreaElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AltAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        imp->setAlt(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CoordsAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        imp->setCoords(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HrefAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        imp->setHref(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NoHrefAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        imp->setNoHref(value->toBoolean(exec));
        break;
    }
    case ShapeAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        imp->setShape(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TabIndexAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        imp->setTabIndex(value->toInt32(exec));
        break;
    }
    case TargetAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());

        imp->setTarget(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLAreaElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLAreaElementConstructor>(exec, "[[HTMLAreaElement.constructor]]");
}

}
