/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description: 
 *   EAP String definitions for UI
 *
 */

#ifndef EAPWIZARDUISTRINGS_H
#define EAPWIZARDUISTRINGS_H

// System includes
#include <QString>

// User includes

// Forward declarations

// External data types

// Constants

/*!
   @addtogroup group_eap_wizard
   @{
 */

//! Namespace for EAP UI String in the context of EapWizard
namespace EapWizardUiStrings
{
    //! String for EAP-AKA
    static const QString EapAka       = "EAP-AKA";
    //! String for EAP-FAST
    static const QString EapFast      = "EAP-FAST";
    //! String for EAP-GTC
    static const QString EapGtc       = "EAP-GTC";
    //! String for EAP-MSCHAPv2
    static const QString EapMschapv2  = "EAP-MSCHAPv2";
    //! String for EAP-SIM
    static const QString EapSim       = "EAP-SIM";
    //! String for EAP-TLS
    static const QString EapTls       = "EAP-TLS";
    //! String for EAP-TTLS
    static const QString EapTtls      = "EAP-TTLS";
    //! String for LEAP
    static const QString Leap         = "LEAP";
    //! String for Plain-MSCHAPv2
    static const QString Mschapv2     = "MSCHAPv2";
    //! String for PAP
    static const QString Pap          = "PAP";
    //! String for PEAP
    static const QString Peap         = "PEAP";
}

/*! @} */

#endif /* EAPWIZARDUISTRINGS_H */
