// Copyright (c) 1999-2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Central place for nice debug-type macros & functions
// 
//

#ifndef BT_DEBUG_H
#define BT_DEBUG_H

#ifdef __USING_POLICING_ESOCK__
#undef __USING_POLICING_ESOCK__
#endif
//#define __USING_POLICING_ESOCK__

#include <e32std.h>
#include <f32file.h>
#include <comms-infras/commsdebugutility.h>

// Borrowed from comms-framework - experimental ASSERT variants that
// breakpt at the scene of the crime.
#ifdef _DEBUG
#if defined (__WINS__)
#undef __ASSERT_DEBUG
inline void About_To_Panic_Thread() { __DEBUGGER() }
#define __ASSERT_DEBUG(c,p) (void)((c)||(About_To_Panic_Thread(),p,0))
#undef __ASSERT_ALWAYS
#define __ASSERT_ALWAYS(c,p) (void)((c)||(About_To_Panic_Thread(),p,0))
#endif
#endif


class CDeltaTimer;
class CDebugControlInterface;
class CAvdtpLogEngine;
class CAvctpLogEngine;

struct SBtTls
	{
public:
	CDeltaTimer*			iTimer;	// always needed: not owned
	TUint					iPort;	// the serial port we are on - for logging only
	CDebugControlInterface* iDebugCtrlIF;
	CAvdtpLogEngine*		iAvdtpLogEngine;
	CAvctpLogEngine*		iAvctpLogEngine;	
	};

#define BTTLS static_cast<SBtTls*>(Dll::Tls())

#ifdef __USING_POLICING_ESOCK__
#else
enum TCapabilityRequestType 
 	{
	//Socket Capability
 	ESetOptCheck,
 	EGetOptCheck,
 	EIoctlCheck,
 	EBindCheck,
	EListenCheck,
 	EConnectionCheck,
	EWriteCheck,
 	EReceiveCheck,
	EGetLocalNameCheck,
	EGetRemoteNameCheck,

	//HostResolver
	EHRGetByNameCheck,
	EHRGetByAddressCheck,
	EHRSetHostNameCheck,
	EHRGetHostNameCheck,

	// NetDataBase
	ENDQueryCheck,
	ENDAddCheck,
	ENDRemoveCheck,

	// ServiceResolver
	ESRGetByNameCheck,
	ESRGetByNumberCheck,
	ESRRegisterServiceCheck,
	ESRRemoveServiceCheck,

	//Cconnection
 	EReadCommdbCheck,
	EControlCheck
 	};

#endif


static const TInt KL2CAPDebugOptionMask = 0xFFFF; //< SetOpt for debugging modes in L2CAP
static const TUint KL2CAPDebugSendRequestsTwice = 1; //< Send L2CAP requests twice
static const TUint KL2CAPDebugInvalidL2CAPLengthInConnect= 3; //< Set the L2CAP length wrong
static const TUint KL2CAPDebugInvalidL2CAPLengthInData=4;//< Set the L2CAP length wrong

#ifndef LOGGER_H

inline void __BTDEBUGGER()
// needed to call __DEBUGGER inside an __ASSERT
	{
	__DEBUGGER()
	}

#endif // LOGGER_H


#define __PANIC_UNEXPECTED_CALL __ASSERT_DEBUG(NULL, User::Invariant());

#endif // __BT_DEBUG_H__
