// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <e32base.h>
#include <e32std.h>
#include <e32test.h>
#include <bt_subscribe.h>
#include <bt_sock.h>
#include "BTProperties.h"

_LIT(KNumLinks, "Number of links:");
_LIT(KConnecting, "Connecting...");
_LIT(KRegistry, "Registry changed.");
_LIT(KLimited, "Limited discoverable:");
_LIT(KScanning, "Scans:"); // could resolve this into discoverable/connectable
_LIT(KDeviceClass, "DeviceClass:");
_LIT(KDeviceName, "DeviceName:");
_LIT(KCorruptRegistry, "Registry reset at this point:");
_LIT(KDiscovering, "Discovering...");

GLDEF_D RTest test(_L("Bluetooth P&S Subscription Tests"));

void ShowAddress()
/**
	Shows the example of using a synchronous Get to retrieve local BTAddr

*/
	{
	RProperty property;
	TBuf8<6> addr;

	TInt err = property.Get(KPropertyUidBluetoothCategory,
					KPropertyKeyBluetoothGetLocalDeviceAddress, addr);

	if (err)
		test.Printf(_L("P&S: ERROR retrieving local address\n"));
	else
		{
		TBTDevAddr localAddress(addr);
		TBuf<20> dispBuf;
		localAddress.GetReadable(dispBuf);
		test.Printf(_L("Local address = 0x%S\n"),&dispBuf);
		}
	}

void TestL()
	{
	// first do a sync test
	ShowAddress();

	RPointerArray<CSubscriber> subscribers;

	//ignoring errors!
	subscribers.Append(CSubscriber::NewL(test, KPropertyKeyBluetoothGetPHYCount, KNumLinks));
	subscribers.Append(CSubscriber::NewL(test, KPropertyKeyBluetoothGetRegistryTableChange, KRegistry));
	subscribers.Append(CSubscriber::NewL(test, KPropertyKeyBluetoothGetConnectingStatus, KConnecting));
	subscribers.Append(CSubscriber::NewL(test, KPropertyKeyBluetoothGetScanningStatus, KScanning));
	subscribers.Append(CSubscriber::NewL(test, KPropertyKeyBluetoothGetLimitedDiscoverableStatus, KLimited));
	subscribers.Append(CSubscriber::NewL(test, KPropertyKeyBluetoothGetDeviceClass, KDeviceClass));
	subscribers.Append(CSubscriber::NewL(test, KPropertyKeyBluetoothGetCorruptRegistryResetIndication, KCorruptRegistry));
	subscribers.Append(CDeviceNameSubscriber::NewL(test, KPropertyKeyBluetoothGetDeviceName, KDeviceName));
 	subscribers.Append(CSubscriber::NewL(test, KPropertyKeyBluetoothHostResolverActive, KDiscovering));

	test.Printf(_L("%d Subscribers\n"), subscribers.Count());

	for (TInt i=0; i<subscribers.Count(); i++)
		subscribers[i]->Start();

	CActiveScheduler::Start();
	subscribers.ResetAndDestroy();
	}


CSubscriber* CSubscriber::NewL(RTest& aTest, TUint aKey, const TDesC& aString)
	{
	CSubscriber* s = new(ELeave) CSubscriber(aTest, aString);
	CleanupStack::PushL(s);
	s->ConstructL(aKey);
	CleanupStack::Pop(s);
	return s;
	}

CSubscriber::CSubscriber(RTest& aTest, const TDesC& aString)
: CActive(EPriorityStandard), iTest(aTest), iString(aString)
	{
	CActiveScheduler::Add(this);
	}

CSubscriber::~CSubscriber()
	{
	Cancel();
	}

void CSubscriber::ConstructL(TUint aKey)
	{
	User::LeaveIfError(iProperty.Attach(KPropertyUidBluetoothCategory, aKey));
	}

void CSubscriber::Start()
	{
	iProperty.Subscribe(iStatus);
	SetActive();
	}

void CSubscriber::RunL()
	{
	Start();
	TInt val;
	iProperty.Get(val);

	iTest.Printf(_L("%S = %d\n"), &iString, val);
	}

void CSubscriber::DoCancel()
	{
	iProperty.Cancel();
	}

/*************************************************************************/
//
// CDeviceNameSubscriber Implementation
// 
CDeviceNameSubscriber* CDeviceNameSubscriber::NewL(RTest& aTest, TUint aKey, const TDesC& aString)
	{
	CDeviceNameSubscriber* s = new(ELeave) CDeviceNameSubscriber(aTest, aString);
	CleanupStack::PushL(s);
	s->ConstructL(aKey);
	CleanupStack::Pop(s);
	return s;
	}

CDeviceNameSubscriber::CDeviceNameSubscriber(RTest& aTest, const TDesC& aString)
: CSubscriber(aTest,aString)
	{
	}

CDeviceNameSubscriber::~CDeviceNameSubscriber()
	{
	// No need to cancel since it's done in the base class
	}

void CDeviceNameSubscriber::RunL()
	{
	Start();
	
	TBuf16<KHCILocalDeviceNameMaxLength> val;
	iProperty.Get(val);

	iTest.Printf(_L("%S = %S\n"), &iString, &val);
	}


TInt E32Main()
	{
	CTrapCleanup* cleanupStack=CTrapCleanup::New();
	CActiveScheduler::Install(new CActiveScheduler);

	TRAPD(err,TestL());	//	Ignore err

	if (err != KErrNone)
		{
		test.Printf(_L("Error %d"), err);
		test.Getch();
		}

	delete cleanupStack;
	return err;
	}
