/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.dom.NodeSortRecord;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xml.utils.ObjectFactory;

public class NodeSortRecordFactory {
    private static int DESCENDING = "descending".length();
    private static int NUMBER = "number".length();
    private final DOM _dom;
    private final String _className;
    private Class _class;
    private int[] _order;
    private int[] _type;
    private final AbstractTranslet _translet;

    public NodeSortRecordFactory(DOM dom, String className, Translet translet, String[] order, String[] type) throws TransletException {
        try {
            this._dom = dom;
            this._className = className;
            this._class = translet.getAuxiliaryClass(className);
            if (this._class == null) {
                this._class = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
            }
            this._translet = (AbstractTranslet)translet;
            int levels = order.length;
            this._order = new int[levels];
            this._type = new int[levels];
            int i = 0;
            while (i < levels) {
                if (order[i].length() == DESCENDING) {
                    this._order[i] = NodeSortRecord.COMPARE_DESCENDING;
                }
                if (type[i].length() == NUMBER) {
                    this._type[i] = NodeSortRecord.COMPARE_NUMERIC;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            throw new TransletException(e);
        }
    }

    public NodeSortRecord makeNodeSortRecord(int node, int last) throws ExceptionInInitializerError, LinkageError, IllegalAccessException, InstantiationException, SecurityException, TransletException {
        NodeSortRecord sortRecord = (NodeSortRecord)this._class.newInstance();
        sortRecord.initialize(node, last, this._dom, this._translet, this._order, this._type, this);
        return sortRecord;
    }

    public String getClassName() {
        return this._className;
    }
}

