# Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
# All rights reserved.
# This component and the accompanying materials are made available
# under the terms of "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
# Initial Contributors:
# Nokia Corporation - initial contribution.
#
# Contributors:
#
# Description:
# Copy SQLITE3 test files
# 
#

TMPROOT:=$(subst \,/,$(EPOCROOT))
EPOCROOT:=$(patsubst %/,%,$(TMPROOT))/

include $(EPOCROOT)epoc32/tools/shell/$(notdir $(basename $(SHELL))).mk

ifeq ($(findstring WINS,$(PLATFORM)),WINS)
	TARGETDIR=$(EPOCROOT)epoc32/release/$(PLATFORM_PATH)/$(CFG_PATH)/z/private/10285A82
else
	TARGETDIR=$(EPOCROOT)epoc32/data/z/private/10285A82
endif

SOURCEDIR = $(EXTENSION_ROOT)/../TEST/TCLSCRIPT

TARGET_FILES = \
	$(TARGETDIR)/speed1p.explain \
	$(TARGETDIR)/speed4p.explain \
	$(TARGETDIR)/fuzz_common.tcl \
	$(TARGETDIR)/malloc_common.tcl \
	$(TARGETDIR)/tester.tcl \
	$(TARGETDIR)/thread_common.tcl \
	$(TARGETDIR)/trans2.test.gz \
	$(TARGETDIR)/aggerror.test \
	$(TARGETDIR)/alias.test \
	$(TARGETDIR)/all.test \
	$(TARGETDIR)/alter.test \
	$(TARGETDIR)/alter2.test \
	$(TARGETDIR)/alter3.test \
	$(TARGETDIR)/altermalloc.test \
	$(TARGETDIR)/analyze.test \
	$(TARGETDIR)/async.test \
	$(TARGETDIR)/async2.test \
	$(TARGETDIR)/async3.test \
	$(TARGETDIR)/attach.test \
	$(TARGETDIR)/attach2.test \
	$(TARGETDIR)/attach3.test \
	$(TARGETDIR)/attachmalloc.test \
	$(TARGETDIR)/auth.test \
	$(TARGETDIR)/auth2.test \
	$(TARGETDIR)/autoinc.test \
	$(TARGETDIR)/autovacuum.test \
	$(TARGETDIR)/autovacuum_ioerr2.test \
	$(TARGETDIR)/avtrans.test \
	$(TARGETDIR)/badutf.test \
	$(TARGETDIR)/between.test \
	$(TARGETDIR)/bigfile.test \
	$(TARGETDIR)/bigrow.test \
	$(TARGETDIR)/bind.test \
	$(TARGETDIR)/bindxfer.test \
	$(TARGETDIR)/bitvec.test \
	$(TARGETDIR)/blob.test \
	$(TARGETDIR)/busy.test \
	$(TARGETDIR)/cache.test \
	$(TARGETDIR)/capi2.test \
	$(TARGETDIR)/capi3.test \
	$(TARGETDIR)/capi3b.test \
	$(TARGETDIR)/capi3c.test \
	$(TARGETDIR)/capi3d.test \
	$(TARGETDIR)/cast.test \
	$(TARGETDIR)/check.test \
	$(TARGETDIR)/collate1.test \
	$(TARGETDIR)/collate2.test \
	$(TARGETDIR)/collate3.test \
	$(TARGETDIR)/collate4.test \
	$(TARGETDIR)/collate5.test \
	$(TARGETDIR)/collate6.test \
	$(TARGETDIR)/collate7.test \
	$(TARGETDIR)/collate8.test \
	$(TARGETDIR)/collate9.test \
	$(TARGETDIR)/collateA.test \
	$(TARGETDIR)/colmeta.test \
	$(TARGETDIR)/colname.test \
	$(TARGETDIR)/conflict.test \
	$(TARGETDIR)/corrupt.test \
	$(TARGETDIR)/corrupt2.test \
	$(TARGETDIR)/corrupt3.test \
	$(TARGETDIR)/corrupt4.test \
	$(TARGETDIR)/corrupt5.test \
	$(TARGETDIR)/corrupt6.test \
	$(TARGETDIR)/corrupt7.test \
	$(TARGETDIR)/corrupt8.test \
	$(TARGETDIR)/corrupt9.test \
	$(TARGETDIR)/corruptA.test \
	$(TARGETDIR)/crash.test \
	$(TARGETDIR)/crash2.test \
	$(TARGETDIR)/crash3.test \
	$(TARGETDIR)/crash4.test \
	$(TARGETDIR)/crash5.test \
	$(TARGETDIR)/crash6.test \
	$(TARGETDIR)/crash7.test \
	$(TARGETDIR)/createtab.test \
	$(TARGETDIR)/cse.test \
	$(TARGETDIR)/date.test \
	$(TARGETDIR)/default.test \
	$(TARGETDIR)/delete.test \
	$(TARGETDIR)/delete2.test \
	$(TARGETDIR)/delete3.test \
	$(TARGETDIR)/descidx1.test \
	$(TARGETDIR)/descidx2.test \
	$(TARGETDIR)/descidx3.test \
	$(TARGETDIR)/diskfull.test \
	$(TARGETDIR)/distinctagg.test \
	$(TARGETDIR)/enc.test \
	$(TARGETDIR)/enc2.test \
	$(TARGETDIR)/enc3.test \
	$(TARGETDIR)/eval.test \
	$(TARGETDIR)/exclusive.test \
	$(TARGETDIR)/exclusive2.test \
	$(TARGETDIR)/exec.test \
	$(TARGETDIR)/expr.test \
	$(TARGETDIR)/filectrl.test \
	$(TARGETDIR)/filefmt.test \
	$(TARGETDIR)/fkey1.test \
	$(TARGETDIR)/format4.test \
	$(TARGETDIR)/fts1a.test \
	$(TARGETDIR)/fts1b.test \
	$(TARGETDIR)/fts1c.test \
	$(TARGETDIR)/fts1d.test \
	$(TARGETDIR)/fts1e.test \
	$(TARGETDIR)/fts1f.test \
	$(TARGETDIR)/fts1i.test \
	$(TARGETDIR)/fts1j.test \
	$(TARGETDIR)/fts1k.test \
	$(TARGETDIR)/fts1l.test \
	$(TARGETDIR)/fts1m.test \
	$(TARGETDIR)/fts1n.test \
	$(TARGETDIR)/fts1o.test \
	$(TARGETDIR)/fts1porter.test \
	$(TARGETDIR)/fts2.test \
	$(TARGETDIR)/fts2a.test \
	$(TARGETDIR)/fts2b.test \
	$(TARGETDIR)/fts2c.test \
	$(TARGETDIR)/fts2d.test \
	$(TARGETDIR)/fts2e.test \
	$(TARGETDIR)/fts2f.test \
	$(TARGETDIR)/fts2g.test \
	$(TARGETDIR)/fts2h.test \
	$(TARGETDIR)/fts2i.test \
	$(TARGETDIR)/fts2j.test \
	$(TARGETDIR)/fts2k.test \
	$(TARGETDIR)/fts2l.test \
	$(TARGETDIR)/fts2m.test \
	$(TARGETDIR)/fts2n.test \
	$(TARGETDIR)/fts2o.test \
	$(TARGETDIR)/fts2p.test \
	$(TARGETDIR)/fts2q.test \
	$(TARGETDIR)/fts2r.test \
	$(TARGETDIR)/fts2token.test \
	$(TARGETDIR)/fts3.test \
	$(TARGETDIR)/fts3aa.test \
	$(TARGETDIR)/fts3ab.test \
	$(TARGETDIR)/fts3ac.test \
	$(TARGETDIR)/fts3ad.test \
	$(TARGETDIR)/fts3ae.test \
	$(TARGETDIR)/fts3af.test \
	$(TARGETDIR)/fts3ag.test \
	$(TARGETDIR)/fts3ah.test \
	$(TARGETDIR)/fts3ai.test \
	$(TARGETDIR)/fts3aj.test \
	$(TARGETDIR)/fts3ak.test \
	$(TARGETDIR)/fts3al.test \
	$(TARGETDIR)/fts3am.test \
	$(TARGETDIR)/fts3an.test \
	$(TARGETDIR)/fts3ao.test \
	$(TARGETDIR)/fts3atoken.test \
	$(TARGETDIR)/fts3b.test \
	$(TARGETDIR)/fts3c.test \
	$(TARGETDIR)/fts3d.test \
	$(TARGETDIR)/fts3e.test \
	$(TARGETDIR)/fts3near.test \
	$(TARGETDIR)/func.test \
	$(TARGETDIR)/fuzz.test \
	$(TARGETDIR)/fuzz2.test \
	$(TARGETDIR)/fuzz_malloc.test \
	$(TARGETDIR)/hook.test \
	$(TARGETDIR)/icu.test \
	$(TARGETDIR)/in.test \
	$(TARGETDIR)/in2.test \
	$(TARGETDIR)/in3.test \
	$(TARGETDIR)/incrblob.test \
	$(TARGETDIR)/incrblob2.test \
	$(TARGETDIR)/incrblob_err.test \
	$(TARGETDIR)/incrvacuum.test \
	$(TARGETDIR)/incrvacuum2.test \
	$(TARGETDIR)/incrvacuum_ioerr.test \
	$(TARGETDIR)/index.test \
	$(TARGETDIR)/index2.test \
	$(TARGETDIR)/index3.test \
	$(TARGETDIR)/insert.test \
	$(TARGETDIR)/insert2.test \
	$(TARGETDIR)/insert3.test \
	$(TARGETDIR)/insert4.test \
	$(TARGETDIR)/insert5.test \
	$(TARGETDIR)/interrupt.test \
	$(TARGETDIR)/intpkey.test \
	$(TARGETDIR)/io.test \
	$(TARGETDIR)/ioerr.test \
	$(TARGETDIR)/ioerr2.test \
	$(TARGETDIR)/ioerr3.test \
	$(TARGETDIR)/ioerr4.test \
	$(TARGETDIR)/ioerr5.test \
	$(TARGETDIR)/join.test \
	$(TARGETDIR)/join2.test \
	$(TARGETDIR)/join3.test \
	$(TARGETDIR)/join4.test \
	$(TARGETDIR)/join5.test \
	$(TARGETDIR)/journal1.test \
	$(TARGETDIR)/jrnlmode.test \
	$(TARGETDIR)/lastinsert.test \
	$(TARGETDIR)/laststmtchanges.test \
	$(TARGETDIR)/like.test \
	$(TARGETDIR)/like2.test \
	$(TARGETDIR)/limit.test \
	$(TARGETDIR)/loadext.test \
	$(TARGETDIR)/loadext2.test \
	$(TARGETDIR)/lock.test \
	$(TARGETDIR)/lock2.test \
	$(TARGETDIR)/lock3.test \
	$(TARGETDIR)/lock4.test \
	$(TARGETDIR)/lock5.test \
	$(TARGETDIR)/lookaside.test \
	$(TARGETDIR)/main.test \
	$(TARGETDIR)/malloc.test \
	$(TARGETDIR)/malloc3.test \
	$(TARGETDIR)/malloc4.test \
	$(TARGETDIR)/malloc5.test \
	$(TARGETDIR)/malloc6.test \
	$(TARGETDIR)/malloc7.test \
	$(TARGETDIR)/malloc8.test \
	$(TARGETDIR)/malloc9.test \
	$(TARGETDIR)/mallocA.test \
	$(TARGETDIR)/mallocAll.test \
	$(TARGETDIR)/mallocB.test \
	$(TARGETDIR)/mallocC.test \
	$(TARGETDIR)/mallocD.test \
	$(TARGETDIR)/mallocE.test \
	$(TARGETDIR)/mallocF.test \
	$(TARGETDIR)/mallocG.test \
	$(TARGETDIR)/mallocH.test \
	$(TARGETDIR)/mallocI.test \
	$(TARGETDIR)/manydb.test \
	$(TARGETDIR)/memdb.test \
	$(TARGETDIR)/memleak.test \
	$(TARGETDIR)/memsubsys1.test \
	$(TARGETDIR)/memsubsys2.test \
	$(TARGETDIR)/minmax.test \
	$(TARGETDIR)/minmax2.test \
	$(TARGETDIR)/minmax3.test \
	$(TARGETDIR)/misc1.test \
	$(TARGETDIR)/misc2.test \
	$(TARGETDIR)/misc3.test \
	$(TARGETDIR)/misc4.test \
	$(TARGETDIR)/misc5.test \
	$(TARGETDIR)/misc6.test \
	$(TARGETDIR)/misc7.test \
	$(TARGETDIR)/misuse.test \
	$(TARGETDIR)/mutex1.test \
	$(TARGETDIR)/mutex2.test \
	$(TARGETDIR)/nan.test \
	$(TARGETDIR)/notnull.test \
	$(TARGETDIR)/null.test \
	$(TARGETDIR)/openv2.test \
	$(TARGETDIR)/pager.test \
	$(TARGETDIR)/pager2.test \
	$(TARGETDIR)/pager3.test \
	$(TARGETDIR)/pageropt.test \
	$(TARGETDIR)/pagesize.test \
	$(TARGETDIR)/pcache.test \
	$(TARGETDIR)/permutations.test \
	$(TARGETDIR)/pragma.test \
	$(TARGETDIR)/pragma2.test \
	$(TARGETDIR)/printf.test \
	$(TARGETDIR)/progress.test \
	$(TARGETDIR)/ptrchng.test \
	$(TARGETDIR)/quick.test \
	$(TARGETDIR)/quote.test \
	$(TARGETDIR)/rdonly.test \
	$(TARGETDIR)/reindex.test \
	$(TARGETDIR)/rollback.test \
	$(TARGETDIR)/rowid.test \
	$(TARGETDIR)/rtree.test \
	$(TARGETDIR)/safety.test \
	$(TARGETDIR)/schema.test \
	$(TARGETDIR)/schema2.test \
	$(TARGETDIR)/select1.test \
	$(TARGETDIR)/select2.test \
	$(TARGETDIR)/select3.test \
	$(TARGETDIR)/select4.test \
	$(TARGETDIR)/select5.test \
	$(TARGETDIR)/select6.test \
	$(TARGETDIR)/select7.test \
	$(TARGETDIR)/select8.test \
	$(TARGETDIR)/select9.test \
	$(TARGETDIR)/selectA.test \
	$(TARGETDIR)/selectB.test \
	$(TARGETDIR)/server1.test \
	$(TARGETDIR)/shared.test \
	$(TARGETDIR)/shared2.test \
	$(TARGETDIR)/shared3.test \
	$(TARGETDIR)/shared4.test \
	$(TARGETDIR)/shared_err.test \
	$(TARGETDIR)/shortread1.test \
	$(TARGETDIR)/sidedelete.test \
	$(TARGETDIR)/soak.test \
	$(TARGETDIR)/softheap1.test \
	$(TARGETDIR)/sort.test \
	$(TARGETDIR)/speed1.test \
	$(TARGETDIR)/speed1p.test \
	$(TARGETDIR)/speed2.test \
	$(TARGETDIR)/speed3.test \
	$(TARGETDIR)/speed4.test \
	$(TARGETDIR)/speed4p.test \
	$(TARGETDIR)/sqllimits1.test \
	$(TARGETDIR)/subquery.test \
	$(TARGETDIR)/subselect.test \
	$(TARGETDIR)/substr.test \
	$(TARGETDIR)/sync.test \
	$(TARGETDIR)/table.test \
	$(TARGETDIR)/tableapi.test \
	$(TARGETDIR)/tclsqlite.test \
	$(TARGETDIR)/tempdb.test \
	$(TARGETDIR)/temptable.test \
	$(TARGETDIR)/thread001.test \
	$(TARGETDIR)/thread002.test \
	$(TARGETDIR)/thread003.test \
	$(TARGETDIR)/thread1.test \
	$(TARGETDIR)/thread2.test \
	$(TARGETDIR)/tkt1435.test \
	$(TARGETDIR)/tkt1443.test \
	$(TARGETDIR)/tkt1444.test \
	$(TARGETDIR)/tkt1449.test \
	$(TARGETDIR)/tkt1473.test \
	$(TARGETDIR)/tkt1501.test \
	$(TARGETDIR)/tkt1512.test \
	$(TARGETDIR)/tkt1514.test \
	$(TARGETDIR)/tkt1536.test \
	$(TARGETDIR)/tkt1537.test \
	$(TARGETDIR)/tkt1567.test \
	$(TARGETDIR)/tkt1644.test \
	$(TARGETDIR)/tkt1667.test \
	$(TARGETDIR)/tkt1873.test \
	$(TARGETDIR)/tkt2141.test \
	$(TARGETDIR)/tkt2192.test \
	$(TARGETDIR)/tkt2213.test \
	$(TARGETDIR)/tkt2251.test \
	$(TARGETDIR)/tkt2285.test \
	$(TARGETDIR)/tkt2332.test \
	$(TARGETDIR)/tkt2339.test \
	$(TARGETDIR)/tkt2391.test \
	$(TARGETDIR)/tkt2409.test \
	$(TARGETDIR)/tkt2450.test \
	$(TARGETDIR)/tkt2640.test \
	$(TARGETDIR)/tkt2643.test \
	$(TARGETDIR)/tkt2686.test \
	$(TARGETDIR)/tkt2767.test \
	$(TARGETDIR)/tkt2817.test \
	$(TARGETDIR)/tkt2820.test \
	$(TARGETDIR)/tkt2822.test \
	$(TARGETDIR)/tkt2832.test \
	$(TARGETDIR)/tkt2854.test \
	$(TARGETDIR)/tkt2920.test \
	$(TARGETDIR)/tkt2927.test \
	$(TARGETDIR)/tkt2942.test \
	$(TARGETDIR)/tkt3080.test \
	$(TARGETDIR)/tkt3093.test \
	$(TARGETDIR)/tkt3121.test \
	$(TARGETDIR)/tkt3201.test \
	$(TARGETDIR)/tkt3292.test \
	$(TARGETDIR)/tkt3298.test \
	$(TARGETDIR)/tkt3334.test \
	$(TARGETDIR)/tokenize.test \
	$(TARGETDIR)/trace.test \
	$(TARGETDIR)/trans.test \
	$(TARGETDIR)/trans2.test \
	$(TARGETDIR)/trigger1.test \
	$(TARGETDIR)/trigger2.test \
	$(TARGETDIR)/trigger3.test \
	$(TARGETDIR)/trigger4.test \
	$(TARGETDIR)/trigger5.test \
	$(TARGETDIR)/trigger6.test \
	$(TARGETDIR)/trigger7.test \
	$(TARGETDIR)/trigger8.test \
	$(TARGETDIR)/trigger9.test \
	$(TARGETDIR)/triggerA.test \
	$(TARGETDIR)/triggerB.test \
	$(TARGETDIR)/types.test \
	$(TARGETDIR)/types2.test \
	$(TARGETDIR)/types3.test \
	$(TARGETDIR)/unique.test \
	$(TARGETDIR)/update.test \
	$(TARGETDIR)/utf16align.test \
	$(TARGETDIR)/vacuum.test \
	$(TARGETDIR)/vacuum2.test \
	$(TARGETDIR)/vacuum3.test \
	$(TARGETDIR)/varint.test \
	$(TARGETDIR)/veryquick.test \
	$(TARGETDIR)/view.test \
	$(TARGETDIR)/vtab1.test \
	$(TARGETDIR)/vtab2.test \
	$(TARGETDIR)/vtab3.test \
	$(TARGETDIR)/vtab4.test \
	$(TARGETDIR)/vtab5.test \
	$(TARGETDIR)/vtab6.test \
	$(TARGETDIR)/vtab7.test \
	$(TARGETDIR)/vtab8.test \
	$(TARGETDIR)/vtab9.test \
	$(TARGETDIR)/vtabA.test \
	$(TARGETDIR)/vtabB.test \
	$(TARGETDIR)/vtabC.test \
	$(TARGETDIR)/vtab_alter.test \
	$(TARGETDIR)/vtab_err.test \
	$(TARGETDIR)/vtab_shared.test \
	$(TARGETDIR)/where.test \
	$(TARGETDIR)/where2.test \
	$(TARGETDIR)/where3.test \
	$(TARGETDIR)/where4.test \
	$(TARGETDIR)/where5.test \
	$(TARGETDIR)/where6.test \
	$(TARGETDIR)/zeroblob.test


$(TARGETDIR):
	$(call createdir, "$@")
	
COPYFILES :
	$(call forcecopy,$(SOURCEDIR)/speed1p.explain,$(TARGETDIR)/speed1p.explain)
	$(call forcecopy,$(SOURCEDIR)/speed4p.explain,$(TARGETDIR)/speed4p.explain)
	$(call forcecopy,$(SOURCEDIR)/fuzz_common.tcl,$(TARGETDIR)/fuzz_common.tcl)
	$(call forcecopy,$(SOURCEDIR)/malloc_common.tcl,$(TARGETDIR)/malloc_common.tcl)
	$(call forcecopy,$(SOURCEDIR)/tester.tcl,$(TARGETDIR)/tester.tcl)
	$(call forcecopy,$(SOURCEDIR)/thread_common.tcl,$(TARGETDIR)/thread_common.tcl)
	$(call forcecopy,$(SOURCEDIR)/trans2.test.gz,$(TARGETDIR)/trans2.test.gz)
	$(call forcecopy,$(SOURCEDIR)/aggerror.test,$(TARGETDIR)/aggerror.test)
	$(call forcecopy,$(SOURCEDIR)/alias.test,$(TARGETDIR)/alias.test)
	$(call forcecopy,$(SOURCEDIR)/all.test,$(TARGETDIR)/all.test)
	$(call forcecopy,$(SOURCEDIR)/alter.test,$(TARGETDIR)/alter.test)
	$(call forcecopy,$(SOURCEDIR)/alter2.test,$(TARGETDIR)/alter2.test)
	$(call forcecopy,$(SOURCEDIR)/alter3.test,$(TARGETDIR)/alter3.test)
	$(call forcecopy,$(SOURCEDIR)/altermalloc.test,$(TARGETDIR)/altermalloc.test)
	$(call forcecopy,$(SOURCEDIR)/analyze.test,$(TARGETDIR)/analyze.test)
	$(call forcecopy,$(SOURCEDIR)/async.test,$(TARGETDIR)/async.test)
	$(call forcecopy,$(SOURCEDIR)/async2.test,$(TARGETDIR)/async2.test)
	$(call forcecopy,$(SOURCEDIR)/async3.test,$(TARGETDIR)/async3.test)
	$(call forcecopy,$(SOURCEDIR)/attach.test,$(TARGETDIR)/attach.test)
	$(call forcecopy,$(SOURCEDIR)/attach2.test,$(TARGETDIR)/attach2.test)
	$(call forcecopy,$(SOURCEDIR)/attach3.test,$(TARGETDIR)/attach3.test)
	$(call forcecopy,$(SOURCEDIR)/attachmalloc.test,$(TARGETDIR)/attachmalloc.test)
	$(call forcecopy,$(SOURCEDIR)/auth.test,$(TARGETDIR)/auth.test)
	$(call forcecopy,$(SOURCEDIR)/auth2.test,$(TARGETDIR)/auth2.test)
	$(call forcecopy,$(SOURCEDIR)/autoinc.test,$(TARGETDIR)/autoinc.test)
	$(call forcecopy,$(SOURCEDIR)/autovacuum.test,$(TARGETDIR)/autovacuum.test)
	$(call forcecopy,$(SOURCEDIR)/autovacuum_ioerr2.test,$(TARGETDIR)/autovacuum_ioerr2.test)
	$(call forcecopy,$(SOURCEDIR)/avtrans.test,$(TARGETDIR)/avtrans.test)
	$(call forcecopy,$(SOURCEDIR)/badutf.test,$(TARGETDIR)/badutf.test)
	$(call forcecopy,$(SOURCEDIR)/between.test,$(TARGETDIR)/between.test)
	$(call forcecopy,$(SOURCEDIR)/bigfile.test,$(TARGETDIR)/bigfile.test)
	$(call forcecopy,$(SOURCEDIR)/bigrow.test,$(TARGETDIR)/bigrow.test)
	$(call forcecopy,$(SOURCEDIR)/bind.test,$(TARGETDIR)/bind.test)
	$(call forcecopy,$(SOURCEDIR)/bindxfer.test,$(TARGETDIR)/bindxfer.test)
	$(call forcecopy,$(SOURCEDIR)/bitvec.test,$(TARGETDIR)/bitvec.test)
	$(call forcecopy,$(SOURCEDIR)/blob.test,$(TARGETDIR)/blob.test)
	$(call forcecopy,$(SOURCEDIR)/busy.test,$(TARGETDIR)/busy.test)
	$(call forcecopy,$(SOURCEDIR)/cache.test,$(TARGETDIR)/cache.test)
	$(call forcecopy,$(SOURCEDIR)/capi2.test,$(TARGETDIR)/capi2.test)
	$(call forcecopy,$(SOURCEDIR)/capi3.test,$(TARGETDIR)/capi3.test)
	$(call forcecopy,$(SOURCEDIR)/capi3b.test,$(TARGETDIR)/capi3b.test)
	$(call forcecopy,$(SOURCEDIR)/capi3c.test,$(TARGETDIR)/capi3c.test)
	$(call forcecopy,$(SOURCEDIR)/capi3d.test,$(TARGETDIR)/capi3d.test)
	$(call forcecopy,$(SOURCEDIR)/cast.test,$(TARGETDIR)/cast.test)
	$(call forcecopy,$(SOURCEDIR)/check.test,$(TARGETDIR)/check.test)
	$(call forcecopy,$(SOURCEDIR)/collate1.test,$(TARGETDIR)/collate1.test)
	$(call forcecopy,$(SOURCEDIR)/collate2.test,$(TARGETDIR)/collate2.test)
	$(call forcecopy,$(SOURCEDIR)/collate3.test,$(TARGETDIR)/collate3.test)
	$(call forcecopy,$(SOURCEDIR)/collate4.test,$(TARGETDIR)/collate4.test)
	$(call forcecopy,$(SOURCEDIR)/collate5.test,$(TARGETDIR)/collate5.test)
	$(call forcecopy,$(SOURCEDIR)/collate6.test,$(TARGETDIR)/collate6.test)
	$(call forcecopy,$(SOURCEDIR)/collate7.test,$(TARGETDIR)/collate7.test)
	$(call forcecopy,$(SOURCEDIR)/collate8.test,$(TARGETDIR)/collate8.test)
	$(call forcecopy,$(SOURCEDIR)/collate9.test,$(TARGETDIR)/collate9.test)
	$(call forcecopy,$(SOURCEDIR)/collateA.test,$(TARGETDIR)/collateA.test)
	$(call forcecopy,$(SOURCEDIR)/colmeta.test,$(TARGETDIR)/colmeta.test)
	$(call forcecopy,$(SOURCEDIR)/colname.test,$(TARGETDIR)/colname.test)
	$(call forcecopy,$(SOURCEDIR)/conflict.test,$(TARGETDIR)/conflict.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt.test,$(TARGETDIR)/corrupt.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt2.test,$(TARGETDIR)/corrupt2.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt3.test,$(TARGETDIR)/corrupt3.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt4.test,$(TARGETDIR)/corrupt4.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt5.test,$(TARGETDIR)/corrupt5.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt6.test,$(TARGETDIR)/corrupt6.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt7.test,$(TARGETDIR)/corrupt7.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt8.test,$(TARGETDIR)/corrupt8.test)
	$(call forcecopy,$(SOURCEDIR)/corrupt9.test,$(TARGETDIR)/corrupt9.test)
	$(call forcecopy,$(SOURCEDIR)/corruptA.test,$(TARGETDIR)/corruptA.test)
	$(call forcecopy,$(SOURCEDIR)/crash.test,$(TARGETDIR)/crash.test)
	$(call forcecopy,$(SOURCEDIR)/crash2.test,$(TARGETDIR)/crash2.test)
	$(call forcecopy,$(SOURCEDIR)/crash3.test,$(TARGETDIR)/crash3.test)
	$(call forcecopy,$(SOURCEDIR)/crash4.test,$(TARGETDIR)/crash4.test)
	$(call forcecopy,$(SOURCEDIR)/crash5.test,$(TARGETDIR)/crash5.test)
	$(call forcecopy,$(SOURCEDIR)/crash6.test,$(TARGETDIR)/crash6.test)
	$(call forcecopy,$(SOURCEDIR)/crash7.test,$(TARGETDIR)/crash7.test)
	$(call forcecopy,$(SOURCEDIR)/createtab.test,$(TARGETDIR)/createtab.test)
	$(call forcecopy,$(SOURCEDIR)/cse.test,$(TARGETDIR)/cse.test)
	$(call forcecopy,$(SOURCEDIR)/date.test,$(TARGETDIR)/date.test)
	$(call forcecopy,$(SOURCEDIR)/default.test,$(TARGETDIR)/default.test)
	$(call forcecopy,$(SOURCEDIR)/delete.test,$(TARGETDIR)/delete.test)
	$(call forcecopy,$(SOURCEDIR)/delete2.test,$(TARGETDIR)/delete2.test)
	$(call forcecopy,$(SOURCEDIR)/delete3.test,$(TARGETDIR)/delete3.test)
	$(call forcecopy,$(SOURCEDIR)/descidx1.test,$(TARGETDIR)/descidx1.test)
	$(call forcecopy,$(SOURCEDIR)/descidx2.test,$(TARGETDIR)/descidx2.test)
	$(call forcecopy,$(SOURCEDIR)/descidx3.test,$(TARGETDIR)/descidx3.test)
	$(call forcecopy,$(SOURCEDIR)/diskfull.test,$(TARGETDIR)/diskfull.test)
	$(call forcecopy,$(SOURCEDIR)/distinctagg.test,$(TARGETDIR)/distinctagg.test)
	$(call forcecopy,$(SOURCEDIR)/enc.test,$(TARGETDIR)/enc.test)
	$(call forcecopy,$(SOURCEDIR)/enc2.test,$(TARGETDIR)/enc2.test)
	$(call forcecopy,$(SOURCEDIR)/enc3.test,$(TARGETDIR)/enc3.test)
	$(call forcecopy,$(SOURCEDIR)/eval.test,$(TARGETDIR)/eval.test)
	$(call forcecopy,$(SOURCEDIR)/exclusive.test,$(TARGETDIR)/exclusive.test)
	$(call forcecopy,$(SOURCEDIR)/exclusive2.test,$(TARGETDIR)/exclusive2.test)
	$(call forcecopy,$(SOURCEDIR)/exec.test,$(TARGETDIR)/exec.test)
	$(call forcecopy,$(SOURCEDIR)/expr.test,$(TARGETDIR)/expr.test)
	$(call forcecopy,$(SOURCEDIR)/filectrl.test,$(TARGETDIR)/filectrl.test)
	$(call forcecopy,$(SOURCEDIR)/filefmt.test,$(TARGETDIR)/filefmt.test)
	$(call forcecopy,$(SOURCEDIR)/fkey1.test,$(TARGETDIR)/fkey1.test)
	$(call forcecopy,$(SOURCEDIR)/format4.test,$(TARGETDIR)/format4.test)
	$(call forcecopy,$(SOURCEDIR)/fts1a.test,$(TARGETDIR)/fts1a.test)
	$(call forcecopy,$(SOURCEDIR)/fts1b.test,$(TARGETDIR)/fts1b.test)
	$(call forcecopy,$(SOURCEDIR)/fts1c.test,$(TARGETDIR)/fts1c.test)
	$(call forcecopy,$(SOURCEDIR)/fts1d.test,$(TARGETDIR)/fts1d.test)
	$(call forcecopy,$(SOURCEDIR)/fts1e.test,$(TARGETDIR)/fts1e.test)
	$(call forcecopy,$(SOURCEDIR)/fts1f.test,$(TARGETDIR)/fts1f.test)
	$(call forcecopy,$(SOURCEDIR)/fts1i.test,$(TARGETDIR)/fts1i.test)
	$(call forcecopy,$(SOURCEDIR)/fts1j.test,$(TARGETDIR)/fts1j.test)
	$(call forcecopy,$(SOURCEDIR)/fts1k.test,$(TARGETDIR)/fts1k.test)
	$(call forcecopy,$(SOURCEDIR)/fts1l.test,$(TARGETDIR)/fts1l.test)
	$(call forcecopy,$(SOURCEDIR)/fts1m.test,$(TARGETDIR)/fts1m.test)
	$(call forcecopy,$(SOURCEDIR)/fts1n.test,$(TARGETDIR)/fts1n.test)
	$(call forcecopy,$(SOURCEDIR)/fts1o.test,$(TARGETDIR)/fts1o.test)
	$(call forcecopy,$(SOURCEDIR)/fts1porter.test,$(TARGETDIR)/fts1porter.test)
	$(call forcecopy,$(SOURCEDIR)/fts2.test,$(TARGETDIR)/fts2.test)
	$(call forcecopy,$(SOURCEDIR)/fts2a.test,$(TARGETDIR)/fts2a.test)
	$(call forcecopy,$(SOURCEDIR)/fts2b.test,$(TARGETDIR)/fts2b.test)
	$(call forcecopy,$(SOURCEDIR)/fts2c.test,$(TARGETDIR)/fts2c.test)
	$(call forcecopy,$(SOURCEDIR)/fts2d.test,$(TARGETDIR)/fts2d.test)
	$(call forcecopy,$(SOURCEDIR)/fts2e.test,$(TARGETDIR)/fts2e.test)
	$(call forcecopy,$(SOURCEDIR)/fts2f.test,$(TARGETDIR)/fts2f.test)
	$(call forcecopy,$(SOURCEDIR)/fts2g.test,$(TARGETDIR)/fts2g.test)
	$(call forcecopy,$(SOURCEDIR)/fts2h.test,$(TARGETDIR)/fts2h.test)
	$(call forcecopy,$(SOURCEDIR)/fts2i.test,$(TARGETDIR)/fts2i.test)
	$(call forcecopy,$(SOURCEDIR)/fts2j.test,$(TARGETDIR)/fts2j.test)
	$(call forcecopy,$(SOURCEDIR)/fts2k.test,$(TARGETDIR)/fts2k.test)
	$(call forcecopy,$(SOURCEDIR)/fts2l.test,$(TARGETDIR)/fts2l.test)
	$(call forcecopy,$(SOURCEDIR)/fts2m.test,$(TARGETDIR)/fts2m.test)
	$(call forcecopy,$(SOURCEDIR)/fts2n.test,$(TARGETDIR)/fts2n.test)
	$(call forcecopy,$(SOURCEDIR)/fts2o.test,$(TARGETDIR)/fts2o.test)
	$(call forcecopy,$(SOURCEDIR)/fts2p.test,$(TARGETDIR)/fts2p.test)
	$(call forcecopy,$(SOURCEDIR)/fts2q.test,$(TARGETDIR)/fts2q.test)
	$(call forcecopy,$(SOURCEDIR)/fts2r.test,$(TARGETDIR)/fts2r.test)
	$(call forcecopy,$(SOURCEDIR)/fts2token.test,$(TARGETDIR)/fts2token.test)
	$(call forcecopy,$(SOURCEDIR)/fts3.test,$(TARGETDIR)/fts3.test)
	$(call forcecopy,$(SOURCEDIR)/fts3aa.test,$(TARGETDIR)/fts3aa.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ab.test,$(TARGETDIR)/fts3ab.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ac.test,$(TARGETDIR)/fts3ac.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ad.test,$(TARGETDIR)/fts3ad.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ae.test,$(TARGETDIR)/fts3ae.test)
	$(call forcecopy,$(SOURCEDIR)/fts3af.test,$(TARGETDIR)/fts3af.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ag.test,$(TARGETDIR)/fts3ag.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ah.test,$(TARGETDIR)/fts3ah.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ai.test,$(TARGETDIR)/fts3ai.test)
	$(call forcecopy,$(SOURCEDIR)/fts3aj.test,$(TARGETDIR)/fts3aj.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ak.test,$(TARGETDIR)/fts3ak.test)
	$(call forcecopy,$(SOURCEDIR)/fts3al.test,$(TARGETDIR)/fts3al.test)
	$(call forcecopy,$(SOURCEDIR)/fts3am.test,$(TARGETDIR)/fts3am.test)
	$(call forcecopy,$(SOURCEDIR)/fts3an.test,$(TARGETDIR)/fts3an.test)
	$(call forcecopy,$(SOURCEDIR)/fts3ao.test,$(TARGETDIR)/fts3ao.test)
	$(call forcecopy,$(SOURCEDIR)/fts3atoken.test,$(TARGETDIR)/fts3atoken.test)
	$(call forcecopy,$(SOURCEDIR)/fts3b.test,$(TARGETDIR)/fts3b.test)
	$(call forcecopy,$(SOURCEDIR)/fts3c.test,$(TARGETDIR)/fts3c.test)
	$(call forcecopy,$(SOURCEDIR)/fts3d.test,$(TARGETDIR)/fts3d.test)
	$(call forcecopy,$(SOURCEDIR)/fts3e.test,$(TARGETDIR)/fts3e.test)
	$(call forcecopy,$(SOURCEDIR)/fts3near.test,$(TARGETDIR)/fts3near.test)
	$(call forcecopy,$(SOURCEDIR)/func.test,$(TARGETDIR)/func.test)
	$(call forcecopy,$(SOURCEDIR)/fuzz.test,$(TARGETDIR)/fuzz.test)
	$(call forcecopy,$(SOURCEDIR)/fuzz2.test,$(TARGETDIR)/fuzz2.test)
	$(call forcecopy,$(SOURCEDIR)/fuzz_malloc.test,$(TARGETDIR)/fuzz_malloc.test)
	$(call forcecopy,$(SOURCEDIR)/hook.test,$(TARGETDIR)/hook.test)
	$(call forcecopy,$(SOURCEDIR)/icu.test,$(TARGETDIR)/icu.test)
	$(call forcecopy,$(SOURCEDIR)/in.test,$(TARGETDIR)/in.test)
	$(call forcecopy,$(SOURCEDIR)/in2.test,$(TARGETDIR)/in2.test)
	$(call forcecopy,$(SOURCEDIR)/in3.test,$(TARGETDIR)/in3.test)
	$(call forcecopy,$(SOURCEDIR)/incrblob.test,$(TARGETDIR)/incrblob.test)
	$(call forcecopy,$(SOURCEDIR)/incrblob2.test,$(TARGETDIR)/incrblob2.test)
	$(call forcecopy,$(SOURCEDIR)/incrblob_err.test,$(TARGETDIR)/incrblob_err.test)
	$(call forcecopy,$(SOURCEDIR)/incrvacuum.test,$(TARGETDIR)/incrvacuum.test)
	$(call forcecopy,$(SOURCEDIR)/incrvacuum2.test,$(TARGETDIR)/incrvacuum2.test)
	$(call forcecopy,$(SOURCEDIR)/incrvacuum_ioerr.test,$(TARGETDIR)/incrvacuum_ioerr.test)
	$(call forcecopy,$(SOURCEDIR)/index.test,$(TARGETDIR)/index.test)
	$(call forcecopy,$(SOURCEDIR)/index2.test,$(TARGETDIR)/index2.test)
	$(call forcecopy,$(SOURCEDIR)/index3.test,$(TARGETDIR)/index3.test)
	$(call forcecopy,$(SOURCEDIR)/insert.test,$(TARGETDIR)/insert.test)
	$(call forcecopy,$(SOURCEDIR)/insert2.test,$(TARGETDIR)/insert2.test)
	$(call forcecopy,$(SOURCEDIR)/insert3.test,$(TARGETDIR)/insert3.test)
	$(call forcecopy,$(SOURCEDIR)/insert4.test,$(TARGETDIR)/insert4.test)
	$(call forcecopy,$(SOURCEDIR)/insert5.test,$(TARGETDIR)/insert5.test)
	$(call forcecopy,$(SOURCEDIR)/interrupt.test,$(TARGETDIR)/interrupt.test)
	$(call forcecopy,$(SOURCEDIR)/intpkey.test,$(TARGETDIR)/intpkey.test)
	$(call forcecopy,$(SOURCEDIR)/io.test,$(TARGETDIR)/io.test)
	$(call forcecopy,$(SOURCEDIR)/ioerr.test,$(TARGETDIR)/ioerr.test)
	$(call forcecopy,$(SOURCEDIR)/ioerr2.test,$(TARGETDIR)/ioerr2.test)
	$(call forcecopy,$(SOURCEDIR)/ioerr3.test,$(TARGETDIR)/ioerr3.test)
	$(call forcecopy,$(SOURCEDIR)/ioerr4.test,$(TARGETDIR)/ioerr4.test)
	$(call forcecopy,$(SOURCEDIR)/ioerr5.test,$(TARGETDIR)/ioerr5.test)
	$(call forcecopy,$(SOURCEDIR)/join.test,$(TARGETDIR)/join.test)
	$(call forcecopy,$(SOURCEDIR)/join2.test,$(TARGETDIR)/join2.test)
	$(call forcecopy,$(SOURCEDIR)/join3.test,$(TARGETDIR)/join3.test)
	$(call forcecopy,$(SOURCEDIR)/join4.test,$(TARGETDIR)/join4.test)
	$(call forcecopy,$(SOURCEDIR)/join5.test,$(TARGETDIR)/join5.test)
	$(call forcecopy,$(SOURCEDIR)/journal1.test,$(TARGETDIR)/journal1.test)
	$(call forcecopy,$(SOURCEDIR)/jrnlmode.test,$(TARGETDIR)/jrnlmode.test)
	$(call forcecopy,$(SOURCEDIR)/lastinsert.test,$(TARGETDIR)/lastinsert.test)
	$(call forcecopy,$(SOURCEDIR)/laststmtchanges.test,$(TARGETDIR)/laststmtchanges.test)
	$(call forcecopy,$(SOURCEDIR)/like.test,$(TARGETDIR)/like.test)
	$(call forcecopy,$(SOURCEDIR)/like2.test,$(TARGETDIR)/like2.test)
	$(call forcecopy,$(SOURCEDIR)/limit.test,$(TARGETDIR)/limit.test)
	$(call forcecopy,$(SOURCEDIR)/loadext.test,$(TARGETDIR)/loadext.test)
	$(call forcecopy,$(SOURCEDIR)/loadext2.test,$(TARGETDIR)/loadext2.test)
	$(call forcecopy,$(SOURCEDIR)/lock.test,$(TARGETDIR)/lock.test)
	$(call forcecopy,$(SOURCEDIR)/lock2.test,$(TARGETDIR)/lock2.test)
	$(call forcecopy,$(SOURCEDIR)/lock3.test,$(TARGETDIR)/lock3.test)
	$(call forcecopy,$(SOURCEDIR)/lock4.test,$(TARGETDIR)/lock4.test)
	$(call forcecopy,$(SOURCEDIR)/lock5.test,$(TARGETDIR)/lock5.test)
	$(call forcecopy,$(SOURCEDIR)/lookaside.test,$(TARGETDIR)/lookaside.test)
	$(call forcecopy,$(SOURCEDIR)/main.test,$(TARGETDIR)/main.test)
	$(call forcecopy,$(SOURCEDIR)/malloc.test,$(TARGETDIR)/malloc.test)
	$(call forcecopy,$(SOURCEDIR)/malloc3.test,$(TARGETDIR)/malloc3.test)
	$(call forcecopy,$(SOURCEDIR)/malloc4.test,$(TARGETDIR)/malloc4.test)
	$(call forcecopy,$(SOURCEDIR)/malloc5.test,$(TARGETDIR)/malloc5.test)
	$(call forcecopy,$(SOURCEDIR)/malloc6.test,$(TARGETDIR)/malloc6.test)
	$(call forcecopy,$(SOURCEDIR)/malloc7.test,$(TARGETDIR)/malloc7.test)
	$(call forcecopy,$(SOURCEDIR)/malloc8.test,$(TARGETDIR)/malloc8.test)
	$(call forcecopy,$(SOURCEDIR)/malloc9.test,$(TARGETDIR)/malloc9.test)
	$(call forcecopy,$(SOURCEDIR)/mallocA.test,$(TARGETDIR)/mallocA.test)
	$(call forcecopy,$(SOURCEDIR)/mallocAll.test,$(TARGETDIR)/mallocAll.test)
	$(call forcecopy,$(SOURCEDIR)/mallocB.test,$(TARGETDIR)/mallocB.test)
	$(call forcecopy,$(SOURCEDIR)/mallocC.test,$(TARGETDIR)/mallocC.test)
	$(call forcecopy,$(SOURCEDIR)/mallocD.test,$(TARGETDIR)/mallocD.test)
	$(call forcecopy,$(SOURCEDIR)/mallocE.test,$(TARGETDIR)/mallocE.test)
	$(call forcecopy,$(SOURCEDIR)/mallocF.test,$(TARGETDIR)/mallocF.test)
	$(call forcecopy,$(SOURCEDIR)/mallocG.test,$(TARGETDIR)/mallocG.test)
	$(call forcecopy,$(SOURCEDIR)/mallocH.test,$(TARGETDIR)/mallocH.test)
	$(call forcecopy,$(SOURCEDIR)/mallocI.test,$(TARGETDIR)/mallocI.test)
	$(call forcecopy,$(SOURCEDIR)/manydb.test,$(TARGETDIR)/manydb.test)
	$(call forcecopy,$(SOURCEDIR)/memdb.test,$(TARGETDIR)/memdb.test)
	$(call forcecopy,$(SOURCEDIR)/memleak.test,$(TARGETDIR)/memleak.test)
	$(call forcecopy,$(SOURCEDIR)/memsubsys1.test,$(TARGETDIR)/memsubsys1.test)
	$(call forcecopy,$(SOURCEDIR)/memsubsys2.test,$(TARGETDIR)/memsubsys2.test)
	$(call forcecopy,$(SOURCEDIR)/minmax.test,$(TARGETDIR)/minmax.test)
	$(call forcecopy,$(SOURCEDIR)/minmax2.test,$(TARGETDIR)/minmax2.test)
	$(call forcecopy,$(SOURCEDIR)/minmax3.test,$(TARGETDIR)/minmax3.test)
	$(call forcecopy,$(SOURCEDIR)/misc1.test,$(TARGETDIR)/misc1.test)
	$(call forcecopy,$(SOURCEDIR)/misc2.test,$(TARGETDIR)/misc2.test)
	$(call forcecopy,$(SOURCEDIR)/misc3.test,$(TARGETDIR)/misc3.test)
	$(call forcecopy,$(SOURCEDIR)/misc4.test,$(TARGETDIR)/misc4.test)
	$(call forcecopy,$(SOURCEDIR)/misc5.test,$(TARGETDIR)/misc5.test)
	$(call forcecopy,$(SOURCEDIR)/misc6.test,$(TARGETDIR)/misc6.test)
	$(call forcecopy,$(SOURCEDIR)/misc7.test,$(TARGETDIR)/misc7.test)
	$(call forcecopy,$(SOURCEDIR)/misuse.test,$(TARGETDIR)/misuse.test)
	$(call forcecopy,$(SOURCEDIR)/mutex1.test,$(TARGETDIR)/mutex1.test)
	$(call forcecopy,$(SOURCEDIR)/mutex2.test,$(TARGETDIR)/mutex2.test)
	$(call forcecopy,$(SOURCEDIR)/nan.test,$(TARGETDIR)/nan.test)
	$(call forcecopy,$(SOURCEDIR)/notnull.test,$(TARGETDIR)/notnull.test)
	$(call forcecopy,$(SOURCEDIR)/null.test,$(TARGETDIR)/null.test)
	$(call forcecopy,$(SOURCEDIR)/openv2.test,$(TARGETDIR)/openv2.test)
	$(call forcecopy,$(SOURCEDIR)/pager.test,$(TARGETDIR)/pager.test)
	$(call forcecopy,$(SOURCEDIR)/pager2.test,$(TARGETDIR)/pager2.test)
	$(call forcecopy,$(SOURCEDIR)/pager3.test,$(TARGETDIR)/pager3.test)
	$(call forcecopy,$(SOURCEDIR)/pageropt.test,$(TARGETDIR)/pageropt.test)
	$(call forcecopy,$(SOURCEDIR)/pagesize.test,$(TARGETDIR)/pagesize.test)
	$(call forcecopy,$(SOURCEDIR)/pcache.test,$(TARGETDIR)/pcache.test)
	$(call forcecopy,$(SOURCEDIR)/permutations.test,$(TARGETDIR)/permutations.test)
	$(call forcecopy,$(SOURCEDIR)/pragma.test,$(TARGETDIR)/pragma.test)
	$(call forcecopy,$(SOURCEDIR)/pragma2.test,$(TARGETDIR)/pragma2.test)
	$(call forcecopy,$(SOURCEDIR)/printf.test,$(TARGETDIR)/printf.test)
	$(call forcecopy,$(SOURCEDIR)/progress.test,$(TARGETDIR)/progress.test)
	$(call forcecopy,$(SOURCEDIR)/ptrchng.test,$(TARGETDIR)/ptrchng.test)
	$(call forcecopy,$(SOURCEDIR)/quick.test,$(TARGETDIR)/quick.test)
	$(call forcecopy,$(SOURCEDIR)/quote.test,$(TARGETDIR)/quote.test)
	$(call forcecopy,$(SOURCEDIR)/rdonly.test,$(TARGETDIR)/rdonly.test)
	$(call forcecopy,$(SOURCEDIR)/reindex.test,$(TARGETDIR)/reindex.test)
	$(call forcecopy,$(SOURCEDIR)/rollback.test,$(TARGETDIR)/rollback.test)
	$(call forcecopy,$(SOURCEDIR)/rowid.test,$(TARGETDIR)/rowid.test)
	$(call forcecopy,$(SOURCEDIR)/rtree.test,$(TARGETDIR)/rtree.test)
	$(call forcecopy,$(SOURCEDIR)/safety.test,$(TARGETDIR)/safety.test)
	$(call forcecopy,$(SOURCEDIR)/schema.test,$(TARGETDIR)/schema.test)
	$(call forcecopy,$(SOURCEDIR)/schema2.test,$(TARGETDIR)/schema2.test)
	$(call forcecopy,$(SOURCEDIR)/select1.test,$(TARGETDIR)/select1.test)
	$(call forcecopy,$(SOURCEDIR)/select2.test,$(TARGETDIR)/select2.test)
	$(call forcecopy,$(SOURCEDIR)/select3.test,$(TARGETDIR)/select3.test)
	$(call forcecopy,$(SOURCEDIR)/select4.test,$(TARGETDIR)/select4.test)
	$(call forcecopy,$(SOURCEDIR)/select5.test,$(TARGETDIR)/select5.test)
	$(call forcecopy,$(SOURCEDIR)/select6.test,$(TARGETDIR)/select6.test)
	$(call forcecopy,$(SOURCEDIR)/select7.test,$(TARGETDIR)/select7.test)
	$(call forcecopy,$(SOURCEDIR)/select8.test,$(TARGETDIR)/select8.test)
	$(call forcecopy,$(SOURCEDIR)/select9.test,$(TARGETDIR)/select9.test)
	$(call forcecopy,$(SOURCEDIR)/selectA.test,$(TARGETDIR)/selectA.test)
	$(call forcecopy,$(SOURCEDIR)/selectB.test,$(TARGETDIR)/selectB.test)
	$(call forcecopy,$(SOURCEDIR)/server1.test,$(TARGETDIR)/server1.test)
	$(call forcecopy,$(SOURCEDIR)/shared.test,$(TARGETDIR)/shared.test)
	$(call forcecopy,$(SOURCEDIR)/shared2.test,$(TARGETDIR)/shared2.test)
	$(call forcecopy,$(SOURCEDIR)/shared3.test,$(TARGETDIR)/shared3.test)
	$(call forcecopy,$(SOURCEDIR)/shared4.test,$(TARGETDIR)/shared4.test)
	$(call forcecopy,$(SOURCEDIR)/shared_err.test,$(TARGETDIR)/shared_err.test)
	$(call forcecopy,$(SOURCEDIR)/shortread1.test,$(TARGETDIR)/shortread1.test)
	$(call forcecopy,$(SOURCEDIR)/sidedelete.test,$(TARGETDIR)/sidedelete.test)
	$(call forcecopy,$(SOURCEDIR)/soak.test,$(TARGETDIR)/soak.test)
	$(call forcecopy,$(SOURCEDIR)/softheap1.test,$(TARGETDIR)/softheap1.test)
	$(call forcecopy,$(SOURCEDIR)/sort.test,$(TARGETDIR)/sort.test)
	$(call forcecopy,$(SOURCEDIR)/speed1.test,$(TARGETDIR)/speed1.test)
	$(call forcecopy,$(SOURCEDIR)/speed1p.test,$(TARGETDIR)/speed1p.test)
	$(call forcecopy,$(SOURCEDIR)/speed2.test,$(TARGETDIR)/speed2.test)
	$(call forcecopy,$(SOURCEDIR)/speed3.test,$(TARGETDIR)/speed3.test)
	$(call forcecopy,$(SOURCEDIR)/speed4.test,$(TARGETDIR)/speed4.test)
	$(call forcecopy,$(SOURCEDIR)/speed4p.test,$(TARGETDIR)/speed4p.test)
	$(call forcecopy,$(SOURCEDIR)/sqllimits1.test,$(TARGETDIR)/sqllimits1.test)
	$(call forcecopy,$(SOURCEDIR)/subquery.test,$(TARGETDIR)/subquery.test)
	$(call forcecopy,$(SOURCEDIR)/subselect.test,$(TARGETDIR)/subselect.test)
	$(call forcecopy,$(SOURCEDIR)/substr.test,$(TARGETDIR)/substr.test)
	$(call forcecopy,$(SOURCEDIR)/sync.test,$(TARGETDIR)/sync.test)
	$(call forcecopy,$(SOURCEDIR)/table.test,$(TARGETDIR)/table.test)
	$(call forcecopy,$(SOURCEDIR)/tableapi.test,$(TARGETDIR)/tableapi.test)
	$(call forcecopy,$(SOURCEDIR)/tclsqlite.test,$(TARGETDIR)/tclsqlite.test)
	$(call forcecopy,$(SOURCEDIR)/tempdb.test,$(TARGETDIR)/tempdb.test)
	$(call forcecopy,$(SOURCEDIR)/temptable.test,$(TARGETDIR)/temptable.test)
	$(call forcecopy,$(SOURCEDIR)/thread001.test,$(TARGETDIR)/thread001.test)
	$(call forcecopy,$(SOURCEDIR)/thread002.test,$(TARGETDIR)/thread002.test)
	$(call forcecopy,$(SOURCEDIR)/thread003.test,$(TARGETDIR)/thread003.test)
	$(call forcecopy,$(SOURCEDIR)/thread1.test,$(TARGETDIR)/thread1.test)
	$(call forcecopy,$(SOURCEDIR)/thread2.test,$(TARGETDIR)/thread2.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1435.test,$(TARGETDIR)/tkt1435.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1443.test,$(TARGETDIR)/tkt1443.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1444.test,$(TARGETDIR)/tkt1444.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1449.test,$(TARGETDIR)/tkt1449.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1473.test,$(TARGETDIR)/tkt1473.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1501.test,$(TARGETDIR)/tkt1501.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1512.test,$(TARGETDIR)/tkt1512.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1514.test,$(TARGETDIR)/tkt1514.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1536.test,$(TARGETDIR)/tkt1536.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1537.test,$(TARGETDIR)/tkt1537.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1567.test,$(TARGETDIR)/tkt1567.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1644.test,$(TARGETDIR)/tkt1644.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1667.test,$(TARGETDIR)/tkt1667.test)
	$(call forcecopy,$(SOURCEDIR)/tkt1873.test,$(TARGETDIR)/tkt1873.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2141.test,$(TARGETDIR)/tkt2141.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2192.test,$(TARGETDIR)/tkt2192.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2213.test,$(TARGETDIR)/tkt2213.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2251.test,$(TARGETDIR)/tkt2251.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2285.test,$(TARGETDIR)/tkt2285.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2332.test,$(TARGETDIR)/tkt2332.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2339.test,$(TARGETDIR)/tkt2339.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2391.test,$(TARGETDIR)/tkt2391.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2409.test,$(TARGETDIR)/tkt2409.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2450.test,$(TARGETDIR)/tkt2450.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2640.test,$(TARGETDIR)/tkt2640.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2643.test,$(TARGETDIR)/tkt2643.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2686.test,$(TARGETDIR)/tkt2686.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2767.test,$(TARGETDIR)/tkt2767.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2817.test,$(TARGETDIR)/tkt2817.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2820.test,$(TARGETDIR)/tkt2820.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2822.test,$(TARGETDIR)/tkt2822.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2832.test,$(TARGETDIR)/tkt2832.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2854.test,$(TARGETDIR)/tkt2854.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2920.test,$(TARGETDIR)/tkt2920.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2927.test,$(TARGETDIR)/tkt2927.test)
	$(call forcecopy,$(SOURCEDIR)/tkt2942.test,$(TARGETDIR)/tkt2942.test)
	$(call forcecopy,$(SOURCEDIR)/tkt3080.test,$(TARGETDIR)/tkt3080.test)
	$(call forcecopy,$(SOURCEDIR)/tkt3093.test,$(TARGETDIR)/tkt3093.test)
	$(call forcecopy,$(SOURCEDIR)/tkt3121.test,$(TARGETDIR)/tkt3121.test)
	$(call forcecopy,$(SOURCEDIR)/tkt3201.test,$(TARGETDIR)/tkt3201.test)
	$(call forcecopy,$(SOURCEDIR)/tkt3292.test,$(TARGETDIR)/tkt3292.test)
	$(call forcecopy,$(SOURCEDIR)/tkt3298.test,$(TARGETDIR)/tkt3298.test)
	$(call forcecopy,$(SOURCEDIR)/tkt3334.test,$(TARGETDIR)/tkt3334.test)
	$(call forcecopy,$(SOURCEDIR)/tokenize.test,$(TARGETDIR)/tokenize.test)
	$(call forcecopy,$(SOURCEDIR)/trace.test,$(TARGETDIR)/trace.test)
	$(call forcecopy,$(SOURCEDIR)/trans.test,$(TARGETDIR)/trans.test)
	$(call forcecopy,$(SOURCEDIR)/trans2.test,$(TARGETDIR)/trans2.test)
	$(call forcecopy,$(SOURCEDIR)/trigger1.test,$(TARGETDIR)/trigger1.test)
	$(call forcecopy,$(SOURCEDIR)/trigger2.test,$(TARGETDIR)/trigger2.test)
	$(call forcecopy,$(SOURCEDIR)/trigger3.test,$(TARGETDIR)/trigger3.test)
	$(call forcecopy,$(SOURCEDIR)/trigger4.test,$(TARGETDIR)/trigger4.test)
	$(call forcecopy,$(SOURCEDIR)/trigger5.test,$(TARGETDIR)/trigger5.test)
	$(call forcecopy,$(SOURCEDIR)/trigger6.test,$(TARGETDIR)/trigger6.test)
	$(call forcecopy,$(SOURCEDIR)/trigger7.test,$(TARGETDIR)/trigger7.test)
	$(call forcecopy,$(SOURCEDIR)/trigger8.test,$(TARGETDIR)/trigger8.test)
	$(call forcecopy,$(SOURCEDIR)/trigger9.test,$(TARGETDIR)/trigger9.test)
	$(call forcecopy,$(SOURCEDIR)/triggerA.test,$(TARGETDIR)/triggerA.test)
	$(call forcecopy,$(SOURCEDIR)/triggerB.test,$(TARGETDIR)/triggerB.test)
	$(call forcecopy,$(SOURCEDIR)/types.test,$(TARGETDIR)/types.test)
	$(call forcecopy,$(SOURCEDIR)/types2.test,$(TARGETDIR)/types2.test)
	$(call forcecopy,$(SOURCEDIR)/types3.test,$(TARGETDIR)/types3.test)
	$(call forcecopy,$(SOURCEDIR)/unique.test,$(TARGETDIR)/unique.test)
	$(call forcecopy,$(SOURCEDIR)/update.test,$(TARGETDIR)/update.test)
	$(call forcecopy,$(SOURCEDIR)/utf16align.test,$(TARGETDIR)/utf16align.test)
	$(call forcecopy,$(SOURCEDIR)/vacuum.test,$(TARGETDIR)/vacuum.test)
	$(call forcecopy,$(SOURCEDIR)/vacuum2.test,$(TARGETDIR)/vacuum2.test)
	$(call forcecopy,$(SOURCEDIR)/vacuum3.test,$(TARGETDIR)/vacuum3.test)
	$(call forcecopy,$(SOURCEDIR)/varint.test,$(TARGETDIR)/varint.test)
	$(call forcecopy,$(SOURCEDIR)/veryquick.test,$(TARGETDIR)/veryquick.test)
	$(call forcecopy,$(SOURCEDIR)/view.test,$(TARGETDIR)/view.test)
	$(call forcecopy,$(SOURCEDIR)/vtab1.test,$(TARGETDIR)/vtab1.test)
	$(call forcecopy,$(SOURCEDIR)/vtab2.test,$(TARGETDIR)/vtab2.test)
	$(call forcecopy,$(SOURCEDIR)/vtab3.test,$(TARGETDIR)/vtab3.test)
	$(call forcecopy,$(SOURCEDIR)/vtab4.test,$(TARGETDIR)/vtab4.test)
	$(call forcecopy,$(SOURCEDIR)/vtab5.test,$(TARGETDIR)/vtab5.test)
	$(call forcecopy,$(SOURCEDIR)/vtab6.test,$(TARGETDIR)/vtab6.test)
	$(call forcecopy,$(SOURCEDIR)/vtab7.test,$(TARGETDIR)/vtab7.test)
	$(call forcecopy,$(SOURCEDIR)/vtab8.test,$(TARGETDIR)/vtab8.test)
	$(call forcecopy,$(SOURCEDIR)/vtab9.test,$(TARGETDIR)/vtab9.test)
	$(call forcecopy,$(SOURCEDIR)/vtabA.test,$(TARGETDIR)/vtabA.test)
	$(call forcecopy,$(SOURCEDIR)/vtabB.test,$(TARGETDIR)/vtabB.test)
	$(call forcecopy,$(SOURCEDIR)/vtabC.test,$(TARGETDIR)/vtabC.test)
	$(call forcecopy,$(SOURCEDIR)/vtab_alter.test,$(TARGETDIR)/vtab_alter.test)
	$(call forcecopy,$(SOURCEDIR)/vtab_err.test,$(TARGETDIR)/vtab_err.test)
	$(call forcecopy,$(SOURCEDIR)/vtab_shared.test,$(TARGETDIR)/vtab_shared.test)
	$(call forcecopy,$(SOURCEDIR)/where.test,$(TARGETDIR)/where.test)
	$(call forcecopy,$(SOURCEDIR)/where2.test,$(TARGETDIR)/where2.test)
	$(call forcecopy,$(SOURCEDIR)/where3.test,$(TARGETDIR)/where3.test)
	$(call forcecopy,$(SOURCEDIR)/where4.test,$(TARGETDIR)/where4.test)
	$(call forcecopy,$(SOURCEDIR)/where5.test,$(TARGETDIR)/where5.test)
	$(call forcecopy,$(SOURCEDIR)/where6.test,$(TARGETDIR)/where6.test)
	$(call forcecopy,$(SOURCEDIR)/zeroblob.test,$(TARGETDIR)/zeroblob.test)
	
DO_NOTHING :
	@echo do nothing

#
# The targets invoked by bld...
#

MAKMAKE : DO_NOTHING

BLD : $(TARGETDIR) COPYFILES

CLEAN : 
	$(call forceremove,$(TARGET_FILES))
	
SAVESPACE : DO_NOTHING

RESOURCE : DO_NOTHING

FREEZE : DO_NOTHING

LIB : DO_NOTHING

CLEANLIB : DO_NOTHING

FINAL : DO_NOTHING

RELEASABLES : 
	@echo $(TARGETDIR)/speed1p.explain
	@echo $(TARGETDIR)/speed4p.explain
	@echo $(TARGETDIR)/fuzz_common.tcl
	@echo $(TARGETDIR)/malloc_common.tcl
	@echo $(TARGETDIR)/tester.tcl
	@echo $(TARGETDIR)/thread_common.tcl
	@echo $(TARGETDIR)/trans2.test.gz
	@echo $(TARGETDIR)/aggerror.test
	@echo $(TARGETDIR)/alias.test
	@echo $(TARGETDIR)/all.test
	@echo $(TARGETDIR)/alter.test
	@echo $(TARGETDIR)/alter2.test
	@echo $(TARGETDIR)/alter3.test
	@echo $(TARGETDIR)/altermalloc.test
	@echo $(TARGETDIR)/analyze.test
	@echo $(TARGETDIR)/async.test
	@echo $(TARGETDIR)/async2.test
	@echo $(TARGETDIR)/async3.test
	@echo $(TARGETDIR)/attach.test
	@echo $(TARGETDIR)/attach2.test
	@echo $(TARGETDIR)/attach3.test
	@echo $(TARGETDIR)/attachmalloc.test
	@echo $(TARGETDIR)/auth.test
	@echo $(TARGETDIR)/auth2.test
	@echo $(TARGETDIR)/autoinc.test
	@echo $(TARGETDIR)/autovacuum.test
	@echo $(TARGETDIR)/autovacuum_ioerr2.test
	@echo $(TARGETDIR)/avtrans.test
	@echo $(TARGETDIR)/badutf.test
	@echo $(TARGETDIR)/between.test
	@echo $(TARGETDIR)/bigfile.test
	@echo $(TARGETDIR)/bigrow.test
	@echo $(TARGETDIR)/bind.test
	@echo $(TARGETDIR)/bindxfer.test
	@echo $(TARGETDIR)/bitvec.test
	@echo $(TARGETDIR)/blob.test
	@echo $(TARGETDIR)/busy.test
	@echo $(TARGETDIR)/cache.test
	@echo $(TARGETDIR)/capi2.test
	@echo $(TARGETDIR)/capi3.test
	@echo $(TARGETDIR)/capi3b.test
	@echo $(TARGETDIR)/capi3c.test
	@echo $(TARGETDIR)/capi3d.test
	@echo $(TARGETDIR)/cast.test
	@echo $(TARGETDIR)/check.test
	@echo $(TARGETDIR)/collate1.test
	@echo $(TARGETDIR)/collate2.test
	@echo $(TARGETDIR)/collate3.test
	@echo $(TARGETDIR)/collate4.test
	@echo $(TARGETDIR)/collate5.test
	@echo $(TARGETDIR)/collate6.test
	@echo $(TARGETDIR)/collate7.test
	@echo $(TARGETDIR)/collate8.test
	@echo $(TARGETDIR)/collate9.test
	@echo $(TARGETDIR)/collateA.test
	@echo $(TARGETDIR)/colmeta.test
	@echo $(TARGETDIR)/colname.test
	@echo $(TARGETDIR)/conflict.test
	@echo $(TARGETDIR)/corrupt.test
	@echo $(TARGETDIR)/corrupt2.test
	@echo $(TARGETDIR)/corrupt3.test
	@echo $(TARGETDIR)/corrupt4.test
	@echo $(TARGETDIR)/corrupt5.test
	@echo $(TARGETDIR)/corrupt6.test
	@echo $(TARGETDIR)/corrupt7.test
	@echo $(TARGETDIR)/corrupt8.test
	@echo $(TARGETDIR)/corrupt9.test
	@echo $(TARGETDIR)/corruptA.test
	@echo $(TARGETDIR)/crash.test
	@echo $(TARGETDIR)/crash2.test
	@echo $(TARGETDIR)/crash3.test
	@echo $(TARGETDIR)/crash4.test
	@echo $(TARGETDIR)/crash5.test
	@echo $(TARGETDIR)/crash6.test
	@echo $(TARGETDIR)/crash7.test
	@echo $(TARGETDIR)/createtab.test
	@echo $(TARGETDIR)/cse.test
	@echo $(TARGETDIR)/date.test
	@echo $(TARGETDIR)/default.test
	@echo $(TARGETDIR)/delete.test
	@echo $(TARGETDIR)/delete2.test
	@echo $(TARGETDIR)/delete3.test
	@echo $(TARGETDIR)/descidx1.test
	@echo $(TARGETDIR)/descidx2.test
	@echo $(TARGETDIR)/descidx3.test
	@echo $(TARGETDIR)/diskfull.test
	@echo $(TARGETDIR)/distinctagg.test
	@echo $(TARGETDIR)/enc.test
	@echo $(TARGETDIR)/enc2.test
	@echo $(TARGETDIR)/enc3.test
	@echo $(TARGETDIR)/eval.test
	@echo $(TARGETDIR)/exclusive.test
	@echo $(TARGETDIR)/exclusive2.test
	@echo $(TARGETDIR)/exec.test
	@echo $(TARGETDIR)/expr.test
	@echo $(TARGETDIR)/filectrl.test
	@echo $(TARGETDIR)/filefmt.test
	@echo $(TARGETDIR)/fkey1.test
	@echo $(TARGETDIR)/format4.test
	@echo $(TARGETDIR)/fts1a.test
	@echo $(TARGETDIR)/fts1b.test
	@echo $(TARGETDIR)/fts1c.test
	@echo $(TARGETDIR)/fts1d.test
	@echo $(TARGETDIR)/fts1e.test
	@echo $(TARGETDIR)/fts1f.test
	@echo $(TARGETDIR)/fts1i.test
	@echo $(TARGETDIR)/fts1j.test
	@echo $(TARGETDIR)/fts1k.test
	@echo $(TARGETDIR)/fts1l.test
	@echo $(TARGETDIR)/fts1m.test
	@echo $(TARGETDIR)/fts1n.test
	@echo $(TARGETDIR)/fts1o.test
	@echo $(TARGETDIR)/fts1porter.test
	@echo $(TARGETDIR)/fts2.test
	@echo $(TARGETDIR)/fts2a.test
	@echo $(TARGETDIR)/fts2b.test
	@echo $(TARGETDIR)/fts2c.test
	@echo $(TARGETDIR)/fts2d.test
	@echo $(TARGETDIR)/fts2e.test
	@echo $(TARGETDIR)/fts2f.test
	@echo $(TARGETDIR)/fts2g.test
	@echo $(TARGETDIR)/fts2h.test
	@echo $(TARGETDIR)/fts2i.test
	@echo $(TARGETDIR)/fts2j.test
	@echo $(TARGETDIR)/fts2k.test
	@echo $(TARGETDIR)/fts2l.test
	@echo $(TARGETDIR)/fts2m.test
	@echo $(TARGETDIR)/fts2n.test
	@echo $(TARGETDIR)/fts2o.test
	@echo $(TARGETDIR)/fts2p.test
	@echo $(TARGETDIR)/fts2q.test
	@echo $(TARGETDIR)/fts2r.test
	@echo $(TARGETDIR)/fts2token.test
	@echo $(TARGETDIR)/fts3.test
	@echo $(TARGETDIR)/fts3aa.test
	@echo $(TARGETDIR)/fts3ab.test
	@echo $(TARGETDIR)/fts3ac.test
	@echo $(TARGETDIR)/fts3ad.test
	@echo $(TARGETDIR)/fts3ae.test
	@echo $(TARGETDIR)/fts3af.test
	@echo $(TARGETDIR)/fts3ag.test
	@echo $(TARGETDIR)/fts3ah.test
	@echo $(TARGETDIR)/fts3ai.test
	@echo $(TARGETDIR)/fts3aj.test
	@echo $(TARGETDIR)/fts3ak.test
	@echo $(TARGETDIR)/fts3al.test
	@echo $(TARGETDIR)/fts3am.test
	@echo $(TARGETDIR)/fts3an.test
	@echo $(TARGETDIR)/fts3ao.test
	@echo $(TARGETDIR)/fts3atoken.test
	@echo $(TARGETDIR)/fts3b.test
	@echo $(TARGETDIR)/fts3c.test
	@echo $(TARGETDIR)/fts3d.test
	@echo $(TARGETDIR)/fts3e.test
	@echo $(TARGETDIR)/fts3near.test
	@echo $(TARGETDIR)/func.test
	@echo $(TARGETDIR)/fuzz.test
	@echo $(TARGETDIR)/fuzz2.test
	@echo $(TARGETDIR)/fuzz_malloc.test
	@echo $(TARGETDIR)/hook.test
	@echo $(TARGETDIR)/icu.test
	@echo $(TARGETDIR)/in.test
	@echo $(TARGETDIR)/in2.test
	@echo $(TARGETDIR)/in3.test
	@echo $(TARGETDIR)/incrblob.test
	@echo $(TARGETDIR)/incrblob2.test
	@echo $(TARGETDIR)/incrblob_err.test
	@echo $(TARGETDIR)/incrvacuum.test
	@echo $(TARGETDIR)/incrvacuum2.test
	@echo $(TARGETDIR)/incrvacuum_ioerr.test
	@echo $(TARGETDIR)/index.test
	@echo $(TARGETDIR)/index2.test
	@echo $(TARGETDIR)/index3.test
	@echo $(TARGETDIR)/insert.test
	@echo $(TARGETDIR)/insert2.test
	@echo $(TARGETDIR)/insert3.test
	@echo $(TARGETDIR)/insert4.test
	@echo $(TARGETDIR)/insert5.test
	@echo $(TARGETDIR)/interrupt.test
	@echo $(TARGETDIR)/intpkey.test
	@echo $(TARGETDIR)/io.test
	@echo $(TARGETDIR)/ioerr.test
	@echo $(TARGETDIR)/ioerr2.test
	@echo $(TARGETDIR)/ioerr3.test
	@echo $(TARGETDIR)/ioerr4.test
	@echo $(TARGETDIR)/ioerr5.test
	@echo $(TARGETDIR)/join.test
	@echo $(TARGETDIR)/join2.test
	@echo $(TARGETDIR)/join3.test
	@echo $(TARGETDIR)/join4.test
	@echo $(TARGETDIR)/join5.test
	@echo $(TARGETDIR)/journal1.test
	@echo $(TARGETDIR)/jrnlmode.test
	@echo $(TARGETDIR)/lastinsert.test
	@echo $(TARGETDIR)/laststmtchanges.test
	@echo $(TARGETDIR)/like.test
	@echo $(TARGETDIR)/like2.test
	@echo $(TARGETDIR)/limit.test
	@echo $(TARGETDIR)/loadext.test
	@echo $(TARGETDIR)/loadext2.test
	@echo $(TARGETDIR)/lock.test
	@echo $(TARGETDIR)/lock2.test
	@echo $(TARGETDIR)/lock3.test
	@echo $(TARGETDIR)/lock4.test
	@echo $(TARGETDIR)/lock5.test
	@echo $(TARGETDIR)/lookaside.test
	@echo $(TARGETDIR)/main.test
	@echo $(TARGETDIR)/malloc.test
	@echo $(TARGETDIR)/malloc3.test
	@echo $(TARGETDIR)/malloc4.test
	@echo $(TARGETDIR)/malloc5.test
	@echo $(TARGETDIR)/malloc6.test
	@echo $(TARGETDIR)/malloc7.test
	@echo $(TARGETDIR)/malloc8.test
	@echo $(TARGETDIR)/malloc9.test
	@echo $(TARGETDIR)/mallocA.test
	@echo $(TARGETDIR)/mallocAll.test
	@echo $(TARGETDIR)/mallocB.test
	@echo $(TARGETDIR)/mallocC.test
	@echo $(TARGETDIR)/mallocD.test
	@echo $(TARGETDIR)/mallocE.test
	@echo $(TARGETDIR)/mallocF.test
	@echo $(TARGETDIR)/mallocG.test
	@echo $(TARGETDIR)/mallocH.test
	@echo $(TARGETDIR)/mallocI.test
	@echo $(TARGETDIR)/manydb.test
	@echo $(TARGETDIR)/memdb.test
	@echo $(TARGETDIR)/memleak.test
	@echo $(TARGETDIR)/memsubsys1.test
	@echo $(TARGETDIR)/memsubsys2.test
	@echo $(TARGETDIR)/minmax.test
	@echo $(TARGETDIR)/minmax2.test
	@echo $(TARGETDIR)/minmax3.test
	@echo $(TARGETDIR)/misc1.test
	@echo $(TARGETDIR)/misc2.test
	@echo $(TARGETDIR)/misc3.test
	@echo $(TARGETDIR)/misc4.test
	@echo $(TARGETDIR)/misc5.test
	@echo $(TARGETDIR)/misc6.test
	@echo $(TARGETDIR)/misc7.test
	@echo $(TARGETDIR)/misuse.test
	@echo $(TARGETDIR)/mutex1.test
	@echo $(TARGETDIR)/mutex2.test
	@echo $(TARGETDIR)/nan.test
	@echo $(TARGETDIR)/notnull.test
	@echo $(TARGETDIR)/null.test
	@echo $(TARGETDIR)/openv2.test
	@echo $(TARGETDIR)/pager.test
	@echo $(TARGETDIR)/pager2.test
	@echo $(TARGETDIR)/pager3.test
	@echo $(TARGETDIR)/pageropt.test
	@echo $(TARGETDIR)/pagesize.test
	@echo $(TARGETDIR)/pcache.test
	@echo $(TARGETDIR)/permutations.test
	@echo $(TARGETDIR)/pragma.test
	@echo $(TARGETDIR)/pragma2.test
	@echo $(TARGETDIR)/printf.test
	@echo $(TARGETDIR)/progress.test
	@echo $(TARGETDIR)/ptrchng.test
	@echo $(TARGETDIR)/quick.test
	@echo $(TARGETDIR)/quote.test
	@echo $(TARGETDIR)/rdonly.test
	@echo $(TARGETDIR)/reindex.test
	@echo $(TARGETDIR)/rollback.test
	@echo $(TARGETDIR)/rowid.test
	@echo $(TARGETDIR)/rtree.test
	@echo $(TARGETDIR)/safety.test
	@echo $(TARGETDIR)/schema.test
	@echo $(TARGETDIR)/schema2.test
	@echo $(TARGETDIR)/select1.test
	@echo $(TARGETDIR)/select2.test
	@echo $(TARGETDIR)/select3.test
	@echo $(TARGETDIR)/select4.test
	@echo $(TARGETDIR)/select5.test
	@echo $(TARGETDIR)/select6.test
	@echo $(TARGETDIR)/select7.test
	@echo $(TARGETDIR)/select8.test
	@echo $(TARGETDIR)/select9.test
	@echo $(TARGETDIR)/selectA.test
	@echo $(TARGETDIR)/selectB.test
	@echo $(TARGETDIR)/server1.test
	@echo $(TARGETDIR)/shared.test
	@echo $(TARGETDIR)/shared2.test
	@echo $(TARGETDIR)/shared3.test
	@echo $(TARGETDIR)/shared4.test
	@echo $(TARGETDIR)/shared_err.test
	@echo $(TARGETDIR)/shortread1.test
	@echo $(TARGETDIR)/sidedelete.test
	@echo $(TARGETDIR)/soak.test
	@echo $(TARGETDIR)/softheap1.test
	@echo $(TARGETDIR)/sort.test
	@echo $(TARGETDIR)/speed1.test
	@echo $(TARGETDIR)/speed1p.test
	@echo $(TARGETDIR)/speed2.test
	@echo $(TARGETDIR)/speed3.test
	@echo $(TARGETDIR)/speed4.test
	@echo $(TARGETDIR)/speed4p.test
	@echo $(TARGETDIR)/sqllimits1.test
	@echo $(TARGETDIR)/subquery.test
	@echo $(TARGETDIR)/subselect.test
	@echo $(TARGETDIR)/substr.test
	@echo $(TARGETDIR)/sync.test
	@echo $(TARGETDIR)/table.test
	@echo $(TARGETDIR)/tableapi.test
	@echo $(TARGETDIR)/tclsqlite.test
	@echo $(TARGETDIR)/tempdb.test
	@echo $(TARGETDIR)/temptable.test
	@echo $(TARGETDIR)/thread001.test
	@echo $(TARGETDIR)/thread002.test
	@echo $(TARGETDIR)/thread003.test
	@echo $(TARGETDIR)/thread1.test
	@echo $(TARGETDIR)/thread2.test
	@echo $(TARGETDIR)/tkt1435.test
	@echo $(TARGETDIR)/tkt1443.test
	@echo $(TARGETDIR)/tkt1444.test
	@echo $(TARGETDIR)/tkt1449.test
	@echo $(TARGETDIR)/tkt1473.test
	@echo $(TARGETDIR)/tkt1501.test
	@echo $(TARGETDIR)/tkt1512.test
	@echo $(TARGETDIR)/tkt1514.test
	@echo $(TARGETDIR)/tkt1536.test
	@echo $(TARGETDIR)/tkt1537.test
	@echo $(TARGETDIR)/tkt1567.test
	@echo $(TARGETDIR)/tkt1644.test
	@echo $(TARGETDIR)/tkt1667.test
	@echo $(TARGETDIR)/tkt1873.test
	@echo $(TARGETDIR)/tkt2141.test
	@echo $(TARGETDIR)/tkt2192.test
	@echo $(TARGETDIR)/tkt2213.test
	@echo $(TARGETDIR)/tkt2251.test
	@echo $(TARGETDIR)/tkt2285.test
	@echo $(TARGETDIR)/tkt2332.test
	@echo $(TARGETDIR)/tkt2339.test
	@echo $(TARGETDIR)/tkt2391.test
	@echo $(TARGETDIR)/tkt2409.test
	@echo $(TARGETDIR)/tkt2450.test
	@echo $(TARGETDIR)/tkt2640.test
	@echo $(TARGETDIR)/tkt2643.test
	@echo $(TARGETDIR)/tkt2686.test
	@echo $(TARGETDIR)/tkt2767.test
	@echo $(TARGETDIR)/tkt2817.test
	@echo $(TARGETDIR)/tkt2820.test
	@echo $(TARGETDIR)/tkt2822.test
	@echo $(TARGETDIR)/tkt2832.test
	@echo $(TARGETDIR)/tkt2854.test
	@echo $(TARGETDIR)/tkt2920.test
	@echo $(TARGETDIR)/tkt2927.test
	@echo $(TARGETDIR)/tkt2942.test
	@echo $(TARGETDIR)/tkt3080.test
	@echo $(TARGETDIR)/tkt3093.test
	@echo $(TARGETDIR)/tkt3121.test
	@echo $(TARGETDIR)/tkt3201.test
	@echo $(TARGETDIR)/tkt3292.test
	@echo $(TARGETDIR)/tkt3298.test
	@echo $(TARGETDIR)/tkt3334.test
	@echo $(TARGETDIR)/tokenize.test
	@echo $(TARGETDIR)/trace.test
	@echo $(TARGETDIR)/trans.test
	@echo $(TARGETDIR)/trans2.test
	@echo $(TARGETDIR)/trigger1.test
	@echo $(TARGETDIR)/trigger2.test
	@echo $(TARGETDIR)/trigger3.test
	@echo $(TARGETDIR)/trigger4.test
	@echo $(TARGETDIR)/trigger5.test
	@echo $(TARGETDIR)/trigger6.test
	@echo $(TARGETDIR)/trigger7.test
	@echo $(TARGETDIR)/trigger8.test
	@echo $(TARGETDIR)/trigger9.test
	@echo $(TARGETDIR)/triggerA.test
	@echo $(TARGETDIR)/triggerB.test
	@echo $(TARGETDIR)/types.test
	@echo $(TARGETDIR)/types2.test
	@echo $(TARGETDIR)/types3.test
	@echo $(TARGETDIR)/unique.test
	@echo $(TARGETDIR)/update.test
	@echo $(TARGETDIR)/utf16align.test
	@echo $(TARGETDIR)/vacuum.test
	@echo $(TARGETDIR)/vacuum2.test
	@echo $(TARGETDIR)/vacuum3.test
	@echo $(TARGETDIR)/varint.test
	@echo $(TARGETDIR)/veryquick.test
	@echo $(TARGETDIR)/view.test
	@echo $(TARGETDIR)/vtab1.test
	@echo $(TARGETDIR)/vtab2.test
	@echo $(TARGETDIR)/vtab3.test
	@echo $(TARGETDIR)/vtab4.test
	@echo $(TARGETDIR)/vtab5.test
	@echo $(TARGETDIR)/vtab6.test
	@echo $(TARGETDIR)/vtab7.test
	@echo $(TARGETDIR)/vtab8.test
	@echo $(TARGETDIR)/vtab9.test
	@echo $(TARGETDIR)/vtabA.test
	@echo $(TARGETDIR)/vtabB.test
	@echo $(TARGETDIR)/vtabC.test
	@echo $(TARGETDIR)/vtab_alter.test
	@echo $(TARGETDIR)/vtab_err.test
	@echo $(TARGETDIR)/vtab_shared.test
	@echo $(TARGETDIR)/where.test
	@echo $(TARGETDIR)/where2.test
	@echo $(TARGETDIR)/where3.test
	@echo $(TARGETDIR)/where4.test
	@echo $(TARGETDIR)/where5.test
	@echo $(TARGETDIR)/where6.test
	@echo $(TARGETDIR)/zeroblob.test
