// Copyright (c) 2001-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Class declaration for CMobileSmsMessaging.
// This class declaration is intended to be public (ie. exported to \epoc32\include).
// 
//

/**
 @file
 @internalAll 
*/


#ifndef __MSMSMESS_H__
#define __MSMSMESS_H__

#include <et_phone.h>
#include "Matstd.h"
#include "mPHONE.H"
#include "mSMSCSCA.H"

_LIT8(KSmsEnterPduModeResponse, "> ");	// NB. Must use partial matching with this string


// Forward class declarations
class CATIO;
class CATInit;
class CATSmsMessagingSend;
class CATSmsMessagingRead; 
class CATSmsMemoryStorage;
class CATSmsGetSCAddress;
class CATSmsSetSCAddress;
class CATSetPhoneToCMTMode;
class CATSetPhoneToCMTIMode;
class CReceiveSmsQueue;
class CATSmsWaitForAndHandleCMTIStored;
class CATSmsWaitForAndHandleCMTUnstored;


class CMobileSmsMessaging : public CSubSessionExtBase
/**
 * This class deals with the processing of the Multimode SMS Messaging IPC requests 
 * generated by a client of Etel.
 */
	{
public:
	// Class construction
	static CMobileSmsMessaging* NewL(CATIO* aATIO,CATInit* aInit, CPhoneGlobals* aPhoneGlobals);
	CMobileSmsMessaging(CATIO* aATIO,CATInit* aInit, CPhoneGlobals* aPhoneGlobals);

	// Class destruction
	~CMobileSmsMessaging();

	// from MSubSessionExtBaseTSY
	virtual TInt ExtFunc(const TTsyReqHandle aTsyReqHandle,const TInt aIpc,const TDataPackage& aPackage);
	
	// from MTelObjectTSY which have to be implemented
	virtual void Init();
	virtual CTelObject* OpenNewObjectByNameL(const TDesC&);
	virtual CTelObject* OpenNewObjectL(TDes& aNewName);
	virtual TInt RegisterNotification(const TInt aIpc);
	virtual TInt DeregisterNotification(const TInt aIpc);

	// from MTelObjectTSY needed as we've implemented extensions
	virtual CTelObject::TReqMode ReqModeL(const TInt aIPC);
	virtual TInt NumberOfSlotsL(const TInt aIpc);
	virtual TInt CancelService(const TInt aIpc, const TTsyReqHandle aTsyReqHandle);

	// Callback function for CATSmsGetSCAddress to signal 2-phase list cancel completion
	TInt CompleteSmspListCancel(const TTsyReqHandle aTsyReqHandle);

private:
	// Class construction
	void ConstructL();

	// Extension IPC handlers (with 1 argument)
	TInt GetCaps(const TTsyReqHandle aTsyReqHandle,TDes8* aParam1);
	TInt StoreSmspList(const TTsyReqHandle aTsyReqHandle, TDes8* aBuffer);
	TInt SetReceiveMode(const TTsyReqHandle aTsyReqHandle,TDes8* aParam1);
	TInt GetReceiveMode(const TTsyReqHandle aTsyReqHandle,TDes8* aParam1);
	TInt EnumerateMessageStores(const TTsyReqHandle aTsyReqHandle,TDes8* aParam1);

	// Extension IPC handlers (with 2 arguments)
	TInt SendMessage(const TTsyReqHandle aTsyReqHandle,TDes8* aParam1,TDes8* aParam2);
	TInt ReceiveMessage(const TTsyReqHandle aTsyReqHandle,TDes8* aSmsPdu,TDes8* aAttrib);
	void CancelReceiveMessage();
	TInt GetSmspListPhase1(const TTsyReqHandle aTsyReqHandle,TDes8* aParam1,TDes8* aParam2);
	void GetSmspListPhase1L(TTsyReqHandle aTsyReqHandle,RMobilePhone::TClientId& aClient,TInt& aBufSize);
	TInt GetSmspListPhase2(const TTsyReqHandle aTsyReqHandle,TDes8* aParam1,TDes8* aParam2);
	TInt ProcessStoreSmspListL(const TTsyReqHandle aTsyReqHandle, TDes8* aBuffer);
	TInt GetMessageStoreInfo(const TTsyReqHandle aTsyReqHandle, TDes8* aParam1, TDes8* aParam2);

	// Utility 
	TBool IsSupportedIPC(const TInt aIpc) const;

private:
	// AT command objects
	CATIO*						iIo;
	CATInit*					iInit;
	CATSmsMessagingSend*		iATSmsMessagingSend;
	CATSmsMemoryStorage*		iATSmsMemoryStorage;
	CATSmsGetSCAddress*			iATSmsGetSCAddress;
	CATSmsSetSCAddress*			iATSmsSetSCAddress;
	CATSetPhoneToCMTIMode*		iATSetPhoneToCMTIMode;
	CATSetPhoneToCMTMode*		iATSetPhoneToCMTMode;
	
	// SMS Receiving objects
	CReceiveSmsQueue*					iReceiveSmsQueue;
	CATSmsWaitForAndHandleCMTIStored*	iWaitForCMTIStored;
	CATSmsWaitForAndHandleCMTUnstored*	iWaitForCMTUnstored;

	// Structure of phone capabilities populated by CATInit
	CPhoneGlobals* iGlobals;		// This object not owned by this class 

	// Store current receive mode of phone
	RMobileSmsMessaging::TMobileSmsReceiveMode iCurrentRxMode;
	
	CArrayPtrFlat<CListReadAllAttempt>* iGetSmspList;

	CATSmsGetSCAddress::TTsySmsp iSmspListInfo;

	RMobileSmsMessaging::TMobileSmspEntryV1 iSCEntry;
	};

#endif
