//
// * Copyright 2004 Neusoft America Inc.
// * All rights reserved.
// * This component and the accompanying materials are made available
// * under the terms of the Eclipse Public License v1.0
// * which accompanies this distribution, and is available
// * at the URL "http://www.eclipse.org/legal/epl-v10.html".
// *
// * Contributors:
// * Keith Collins (Neusoft America Inc.)  original software development and additional code and modifications.
// * Thomas Gahagen (Neusoft America Inc.)  additional code and modifications.
// * Zhen Yuan (Neusoft America Inc.)  additional code and modifications.
// *
// * Description:  This file defines CActiveTimeouter, a very simple timeout class. 
// *               It is an active timeout-class used by clients to get asynchronous timeouts.
// *               The observer derives from the MTimeoutObserver class	and calls the Start 
// *               function to start the timer. When and if the timeout occurs the TimedOut 
// *               function on the observer will be called.
// *               MTimeoutObserver is an abstract mixin class implemented by a class that is 
// *               interested in timeouts generated by CActiveTimeouter.
//

// timeouter.h

/** @file timeouter.h
 *
 */

#ifndef TIMEOUTER_H__
#define TIMEOUTER_H__

#include <e32base.h>
#include "etools.h"


class MTimeoutObserver
	{
public:
	// called by CActiveTimeouter when the timeout happens
	virtual void TimedOut() = 0;
	};

/** @class CActiveTimeouter Timeouter.h "Timeouter.h"
 *  @brief  Class CActiveTimeouter is an active object that is used
 *  to detect and report a timeout condition.
 */
class CActiveTimeouter : public CTimer
	{
public:
	static CActiveTimeouter* NewL(MTimeoutObserver& aObserver);
	~CActiveTimeouter();
	void Start(const TTimeIntervalMicroSeconds32& aTimeIntervalMicroSeconds32);
	void Stop();

private:
	CActiveTimeouter(MTimeoutObserver& aObserver);

private: // from CTimer
	void RunL();

private: // owned
	CLASSNAMEDECL(CActiveTimeouter)          

private: // unowned
	MTimeoutObserver& iTheTimeoutObserver;    
	};

#endif // TIMEOUTER_H__
