// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Telephony Fax Test base header file.
// 
//

/**
 @file
 @internalComponent
*/

#ifndef _TE_FAXBASE_H_
#define _TE_FAXBASE_H_

#include <testconfigfileparser.h>
#include <test/testexecuteserverbase.h>


//
// Test macros
//
#define TESTCHECKL(a, b) \
    { \
    if((a)!=(b)) \
	    { \
	    INFO_PRINTF3(_L("Failed: Got %d while expecting %d."),a,b); \
        SetTestStepResult(EFail); \
        User::Leave(EFail); \
        } \
    }

#define TESTCHECKCONDITIONL(a) \
    { \
    if (!(a)) \
	    { \
	    INFO_PRINTF1(_L("Failed: Condition was false.")); \
        SetTestStepResult(EFail); \
        User::Leave(EFail); \
        } \
    }
    
#define TESTCHECKSTRL(a, b) \
    { \
    if((a)!=(b)) \
	    { \
	    TBuf<255> temp = a ; \
	    INFO_PRINTF3(_L("Failed: Got \"%S\" while expecting \"%S\"."), &temp,&(b)); \
        SetTestStepResult(EFail); \
        User::Leave(EFail); \
        } \
    }
    
#define TESTCHECK(a, b) \
    { \
    if((a)!=(b)) \
	    { \
	    INFO_PRINTF3(_L("Failed: Got %d while expecting %d."),a,b); \
        SetTestStepResult(EFail); \
        } \
    }

#define TESTCHECKCONDITION(a) \
    { \
    if (!(a)) \
	    { \
	    INFO_PRINTF1(_L("Failed: Condition was false.")); \
        SetTestStepResult(EFail); \
        } \
    }
    
#define TESTCHECKSTR(a, b) \
    { \
    if((a)!=(b)) \
	    { \
	    INFO_PRINTF3(_L("Failed: Got \"%S\" while expecting \"%S\"."), &(a),&(b)); \
        SetTestStepResult(EFail); \
        } \
    }


//
// Test font data containing an 8 bit wide font, a 16 bit wide font and a 24 bit wide font
// for testing out header digitization.
//
// 8x16 256 font table for generating fax headers.
// The only characters included are those from 32 to 128.
//
const TUint8 font8x16[][16] =
   {
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // ' '
   {0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},    // '!'
   {0x00, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // '"'
   {0x00, 0x42, 0x42, 0x42, 0xFF, 0x42, 0x42, 0x42, 0xFF, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00},    // '#'
   {0x00, 0x10, 0x7E, 0x90, 0x90, 0x90, 0x7C, 0x12, 0x12, 0x12, 0xFC, 0x10, 0x00, 0x00, 0x00, 0x00},    // '$'
   {0x00, 0x00, 0x61, 0x91, 0x92, 0x64, 0x08, 0x10, 0x26, 0x49, 0x89, 0x86, 0x00, 0x00, 0x00, 0x00},    // '%'
   {0x00, 0x70, 0x88, 0x88, 0x88, 0x50, 0x60, 0x91, 0x8A, 0x84, 0x4A, 0x31, 0x00, 0x00, 0x00, 0x00},    // '&'
   {0x00, 0x18, 0x18, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // '''
   {0x00, 0x06, 0x18, 0x20, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00},    // '('
   {0x00, 0x60, 0x18, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},    // ')'
   {0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0xFE, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},    // '*'
   {0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xFE, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // '+'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x10, 0x20, 0x00, 0x00},    // ','
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // '-'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},    // '.'
   {0x00, 0x00, 0x01, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00},    // '/'
   {0x00, 0x3C, 0x42, 0x83, 0x85, 0x89, 0x91, 0xA1, 0xC1, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // '0'
   {0x00, 0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00, 0x00, 0x00},    // '1'
   {0x00, 0x3C, 0x42, 0x81, 0x01, 0x02, 0x3C, 0x40, 0x80, 0x80, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00},    // '2'
   {0x00, 0x3C, 0x42, 0x81, 0x01, 0x02, 0x3C, 0x02, 0x01, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // '3'
   {0x00, 0x02, 0x06, 0x0A, 0x12, 0x22, 0x42, 0x82, 0xFF, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00},    // '4'
   {0x00, 0xFF, 0x80, 0x80, 0x80, 0xFC, 0x02, 0x01, 0x01, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // '5'
   {0x00, 0x3C, 0x42, 0x81, 0x80, 0xBC, 0xC2, 0x81, 0x81, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // '6'
   {0x00, 0xFF, 0x81, 0x01, 0x02, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},    // '7'
   {0x00, 0x3C, 0x42, 0x81, 0x81, 0x42, 0x3C, 0x42, 0x81, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // '8'
   {0x00, 0x3C, 0x42, 0x81, 0x81, 0x43, 0x3D, 0x01, 0x01, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // '9'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},    // ':'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x10, 0x20, 0x00, 0x00},    // ';'
   {0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00},    // '<'
   {0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // '='
   {0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00},    // '>'
   {0x00, 0x38, 0x44, 0x82, 0x82, 0x04, 0x08, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},    // '?'
   {0x00, 0x3C, 0x42, 0x81, 0x99, 0xA5, 0xA5, 0xA5, 0x9E, 0x80, 0x41, 0x3E, 0x00, 0x00, 0x00, 0x00},    // '@'
   {0x00, 0x18, 0x24, 0x42, 0x81, 0x81, 0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'A'
   {0x00, 0xFC, 0x42, 0x41, 0x41, 0x42, 0x7C, 0x42, 0x41, 0x41, 0x42, 0xFC, 0x00, 0x00, 0x00, 0x00},    // 'B'
   {0x00, 0x3C, 0x42, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // 'C'
   {0x00, 0xFC, 0x42, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x42, 0xFC, 0x00, 0x00, 0x00, 0x00},    // 'D'
   {0x00, 0xFF, 0x80, 0x80, 0x80, 0x80, 0xFC, 0x80, 0x80, 0x80, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00},    // 'E'
   {0x00, 0xFF, 0x80, 0x80, 0x80, 0x80, 0xFC, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00},    // 'F'
   {0x00, 0x3C, 0x42, 0x81, 0x81, 0x80, 0x9F, 0x81, 0x81, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // 'G'
   {0x00, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'H'
   {0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00},    // 'I'
   {0x00, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00},    // 'J'
   {0x00, 0x81, 0x82, 0x84, 0x88, 0x90, 0xE0, 0x90, 0x88, 0x84, 0x82, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'K'
   {0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00},    // 'L'
   {0x00, 0x81, 0xC3, 0xA5, 0x99, 0x99, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'M'
   {0x00, 0x81, 0xC1, 0xA1, 0x91, 0x89, 0x85, 0x83, 0x81, 0x81, 0x81, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'N'
   {0x00, 0x3C, 0x42, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // 'O'
   {0x00, 0xFC, 0x82, 0x81, 0x81, 0x82, 0xFC, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00},    // 'P'
   {0x00, 0x3C, 0x42, 0x81, 0x81, 0x81, 0x81, 0x81, 0x89, 0x85, 0x42, 0x3D, 0x00, 0x00, 0x00, 0x00},    // 'Q'
   {0x00, 0xFC, 0x82, 0x81, 0x81, 0x82, 0xFC, 0x90, 0x88, 0x84, 0x82, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'R'
   {0x00, 0x3C, 0x42, 0x81, 0x80, 0x40, 0x3C, 0x02, 0x01, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // 'S'
   {0x00, 0xFE, 0x92, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},    // 'T'
   {0x00, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // 'U'
   {0x00, 0x81, 0x81, 0x81, 0x81, 0x81, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},    // 'V'
   {0x00, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x99, 0x99, 0xA5, 0xA5, 0x42, 0x00, 0x00, 0x00, 0x00},    // 'W'
   {0x00, 0x81, 0x81, 0x81, 0x42, 0x24, 0x18, 0x24, 0x42, 0x81, 0x81, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'X'
   {0x00, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},    // 'Y'
   {0x00, 0xFF, 0x01, 0x01, 0x02, 0x04, 0x18, 0x20, 0x40, 0x80, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00},    // 'Z'
   {0x00, 0x7E, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7E, 0x00, 0x00, 0x00, 0x00},    // '['
   {0x00, 0x00, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00},    // '\'
   {0x00, 0x7E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7E, 0x00, 0x00, 0x00, 0x00},    // ']'
   {0x00, 0x18, 0x24, 0x42, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // '^'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00},    // '_'
   {0x00, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // '`'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x02, 0x02, 0x7E, 0x82, 0x82, 0x7D, 0x00, 0x00, 0x00, 0x00},    // 'a'
   {0x00, 0x80, 0x80, 0x80, 0x80, 0xBC, 0xC2, 0x81, 0x81, 0x81, 0xC2, 0xBC, 0x00, 0x00, 0x00, 0x00},    // 'b'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x42, 0x80, 0x80, 0x80, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // 'c'
   {0x00, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x43, 0x81, 0x81, 0x81, 0x43, 0x3D, 0x00, 0x00, 0x00, 0x00},    // 'd'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x42, 0x81, 0xFF, 0x80, 0x40, 0x3E, 0x00, 0x00, 0x00, 0x00},    // 'e'
   {0x00, 0x0E, 0x11, 0x10, 0x10, 0xFE, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},    // 'f'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x43, 0x81, 0x81, 0x43, 0x3D, 0x01, 0x02, 0x7C, 0x00, 0x00},    // 'g'
   {0x00, 0x80, 0x80, 0x80, 0x80, 0xBC, 0xC2, 0x81, 0x81, 0x81, 0x81, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'h'
   {0x00, 0x00, 0x08, 0x08, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3E, 0x00, 0x00, 0x00, 0x00},    // 'i'
   {0x00, 0x00, 0x02, 0x02, 0x00, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x82, 0x44, 0x38, 0x00, 0x00},    // 'j'
   {0x00, 0x80, 0x80, 0x80, 0x80, 0x82, 0x84, 0x88, 0x90, 0xA8, 0xC4, 0x82, 0x00, 0x00, 0x00, 0x00},    // 'k'
   {0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3E, 0x00, 0x00, 0x00, 0x00},    // 'l'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00},    // 'm'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0xB8, 0xC4, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00},    // 'n'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x42, 0x81, 0x81, 0x81, 0x42, 0x3C, 0x00, 0x00, 0x00, 0x00},    // 'o'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0xBC, 0xC2, 0x81, 0x81, 0x81, 0xC2, 0xBC, 0x80, 0x80, 0x00, 0x00},    // 'p'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x43, 0x81, 0x81, 0x81, 0x43, 0x3D, 0x01, 0x01, 0x00, 0x00},    // 'q'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0xBE, 0xC1, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00},    // 'r'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x81, 0x80, 0x7E, 0x01, 0x81, 0x7E, 0x00, 0x00, 0x00, 0x00},    // 's'
   {0x10, 0x10, 0x10, 0x10, 0x10, 0xFE, 0x10, 0x10, 0x10, 0x10, 0x11, 0x0E, 0x00, 0x00, 0x00, 0x00},    // 't'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x81, 0x81, 0x81, 0x81, 0x43, 0x3D, 0x00, 0x00, 0x00, 0x00},    // 'u'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x81, 0x81, 0x81, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00},    // 'v'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x92, 0x92, 0x92, 0xAA, 0x44, 0x00, 0x00, 0x00, 0x00},    // 'w'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x42, 0x24, 0x18, 0x24, 0x42, 0x81, 0x00, 0x00, 0x00, 0x00},    // 'x'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x81, 0x81, 0x81, 0x43, 0x3D, 0x01, 0x02, 0x7C, 0x00, 0x00},    // 'y'
   {0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x02, 0x04, 0x18, 0x20, 0x40, 0xFF, 0x00, 0x00, 0x00, 0x00},    // 'z'
   {0x00, 0x04, 0x08, 0x10, 0x10, 0x10, 0x20, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00},    // '{'
   {0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},    // '|'
   {0x00, 0x40, 0x20, 0x10, 0x10, 0x10, 0x08, 0x10, 0x10, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00},    // '}'
   {0x00, 0x00, 0x70, 0x99, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},    // '~'
   {0x00, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x36, 0x63, 0x63, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}     // 128
   };

const TUint8 font16x16[][32] =
   {
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ' '
	{0x00,0x00,0x00,0x00,0x03,0xc0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '!'
	{0x00,0x00,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '"'
	{0x00,0x00,0x00,0x00,0x0f,0x3c,0x0f,0x3c,0x3f,0xff,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x3f,0xff,0x0f,0x3c,0x0f,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '#'
	{0x00,0xf0,0x00,0xf0,0x0f,0xfc,0x3c,0x0f,0x3c,0x03,0x3c,0x00,0x0f,0xfc,0x00,0x0f,0x30,0x0f,0x3c,0x0f,0x0f,0xfc,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00},    // '$'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x03,0x3c,0x0f,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x0f,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '%'
	{0x00,0x00,0x00,0x00,0x03,0xf0,0x0f,0x3c,0x0f,0x3c,0x03,0xf0,0x0f,0xcf,0x3c,0xfc,0x3c,0x3c,0x3c,0x3c,0x0f,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '&'
	{0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '''
	{0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xc0,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x03,0xc0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '('
	{0x00,0x00,0x00,0x00,0x03,0xc0,0x00,0xf0,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ')'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x3c,0x0f,0xf0,0xff,0xff,0x0f,0xf0,0x3c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '*'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x03,0xc0,0xff,0xff,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '+'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ','
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '-'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '.'
	{0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x0f,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x0f,0x00,0x3c,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '/'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x3f,0x3c,0xff,0x3f,0xcf,0x3f,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '0'
	{0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0xf0,0x0f,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '1'
	{0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x0f,0x00,0x3c,0x00,0x3f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '2'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x03,0xfc,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '3'
	{0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0xfc,0x03,0xfc,0x0f,0x3c,0x3c,0x3c,0x3f,0xff,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '4'
	{0x00,0x00,0x00,0x00,0x3f,0xff,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3f,0xfc,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '5'
	{0x00,0x00,0x00,0x00,0x03,0xf0,0x0f,0x00,0x3c,0x00,0x3c,0x00,0x3f,0xfc,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '6'
	{0x00,0x00,0x00,0x00,0x3f,0xff,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '7'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0xfc,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '8'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0xff,0x00,0x0f,0x00,0x0f,0x00,0x3c,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '9'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ':'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ';'
	{0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x0f,0x00,0x3c,0x00,0x0f,0x00,0x03,0xc0,0x00,0xf0,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '<'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '='
	{0x00,0x00,0x00,0x00,0x3c,0x00,0x0f,0x00,0x03,0xc0,0x00,0xf0,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x0f,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '>'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x0f,0x00,0x3c,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '?'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x0f,0x3c,0xff,0x3c,0xff,0x3c,0xff,0x3c,0xfc,0x3c,0x00,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '@'
	{0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xf0,0x0f,0x3c,0x3c,0x0f,0x3c,0x0f,0x3f,0xff,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'A'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'B'
	{0x00,0x00,0x00,0x00,0x03,0xfc,0x0f,0x0f,0x3c,0x03,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x03,0x0f,0x0f,0x03,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'C'
	{0x00,0x00,0x00,0x00,0x0f,0xf0,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x3c,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'D'
	{0x00,0x00,0x00,0x00,0x0f,0xff,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'E'
	{0x00,0x00,0x00,0x00,0x0f,0xff,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'F'
	{0x00,0x00,0x00,0x00,0x03,0xfc,0x0f,0x0f,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0xff,0x3c,0x0f,0x0f,0x0f,0x03,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'G'
	{0x00,0x00,0x00,0x00,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3f,0xff,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'H'
	{0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'I'
	{0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'J'
	{0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x3c,0x0f,0x3c,0x0f,0xf0,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'K'
	{0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'L'
	{0x00,0x00,0x00,0x00,0xf0,0x0f,0xfc,0x3f,0xff,0xff,0xf3,0xcf,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'M'
	{0x00,0x00,0x00,0x00,0x3c,0x0f,0x3f,0x0f,0x3f,0xcf,0x3f,0xff,0x3c,0xff,0x3c,0x3f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'N'
	{0x00,0x00,0x00,0x00,0x03,0xf0,0x0f,0x3c,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0x3c,0x03,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'O'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'P'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0xff,0x0f,0xfc,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'Q'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'R'
	{0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x0f,0x0f,0x00,0x03,0xf0,0x00,0x3c,0x3c,0x0f,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'S'
	{0x00,0x00,0x00,0x00,0xff,0xff,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'T'
	{0x00,0x00,0x00,0x00,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'U'
	{0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x0f,0xf0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'V'
	{0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf3,0xcf,0xff,0xff,0x3c,0x3c,0x3c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'W'
	{0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x0f,0xf0,0x03,0xc0,0x0f,0xf0,0x3c,0x3c,0xf0,0x0f,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'X'
	{0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x0f,0xf0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'Y'
	{0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x0f,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x0f,0x00,0x3c,0x00,0xf0,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'Z'
	{0x00,0x00,0x00,0x00,0x0f,0xf0,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '['
	{0x00,0x00,0x00,0x00,0x30,0x00,0x3c,0x00,0x3f,0x00,0x0f,0xc0,0x03,0xf0,0x00,0xfc,0x00,0x3f,0x00,0x0f,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '\'
	{0x00,0x00,0x00,0x00,0x0f,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ']'
	{0x00,0xc0,0x03,0xf0,0x0f,0x3c,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '^'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00},    // '_'
	{0x03,0xc0,0x03,0xc0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '`'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xf0,0x00,0x3c,0x0f,0xfc,0x3c,0x3c,0x3c,0x3c,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'a'
	{0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0xf0,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x3c,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'b'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x00,0x3c,0x00,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'c'
	{0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x03,0xfc,0x0f,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'd'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3f,0xff,0x3c,0x00,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'e'
	{0x00,0x00,0x00,0x00,0x03,0xf0,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x3f,0xf0,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'f'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xcf,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0xfc,0x00,0x3c,0x00,0x3c,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00},    // 'g'
	{0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x3c,0x0f,0xcf,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'h'
	{0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'i'
	{0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'j'
	{0x00,0x00,0x00,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x0f,0x0f,0x0f,0x3c,0x0f,0xf0,0x0f,0x3c,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'k'
	{0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'l'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3c,0xf3,0xcf,0xf3,0xcf,0xf3,0xcf,0xf3,0xcf,0xf3,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'm'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'n'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'o'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xfc,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'p'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xcf,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0xfc,0x00,0x3c,0x00,0x3c,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00},    // 'q'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xfc,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'r'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xfc,0x3c,0x0f,0x0f,0xc0,0x00,0xfc,0x3c,0x0f,0x0f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 's'
	{0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x3f,0xfc,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 't'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x0f,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'u'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0x3c,0x3c,0x0f,0xf0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'v'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0xf0,0x0f,0xf3,0xcf,0xf3,0xcf,0x3f,0xfc,0x3c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'w'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x0f,0x0f,0x3c,0x03,0xf0,0x03,0xf0,0x0f,0x3c,0x3c,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'x'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x3c,0x0f,0x0f,0xff,0x00,0x0f,0x00,0x3c,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x00},    // 'y'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xff,0x00,0x3c,0x00,0xf0,0x03,0xc0,0x0f,0x00,0x3f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'z'
	{0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x3f,0x00,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '{'
	{0x00,0x00,0x00,0x00,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '|'
	{0x00,0x00,0x00,0x00,0x3f,0x00,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x03,0xfc,0x03,0xc0,0x03,0xc0,0x03,0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '}'
	{0x00,0x00,0x00,0x00,0x0f,0xcf,0x3c,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '~'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0xf0,0x0f,0x3c,0x3c,0x0f,0x3c,0x0f,0x3f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 128
   };

const TUint8 font24x16[][48] =
   {
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ' '
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '!'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xf1,0xff,0x1f,0x81,0xf8,0xfc,0x0f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '"'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x8f,0xc0,0x1f,0x8f,0xc0,0xff,0xff,0xf8,0x1f,0x8f,0xc0,0x1f,0x8f,0xc0,0x1f,0x8f,0xc0,0xff,0xff,0xf8,0x1f,0x8f,0xc0,0x1f,0x8f,0xc0,0x1f,0x8f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '#'
	{0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x1f,0xff,0xc0,0xfc,0x71,0xf8,0xfc,0x70,0x00,0xfc,0x70,0x00,0x1f,0xff,0xc0,0x00,0x71,0xf8,0x00,0x71,0xf8,0xfc,0x71,0xf8,0x1f,0xff,0xc0,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '$'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xc0,0x00,0x0f,0xc0,0x00,0x0e,0x00,0x00,0x7e,0x00,0x03,0xf0,0x00,0x03,0x80,0x00,0x1f,0x80,0x00,0x1c,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '%'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xfe,0x00,0x1f,0x8f,0xc0,0x1f,0x8f,0xc0,0x03,0xfe,0x00,0x1f,0xf1,0xf8,0xfc,0x7f,0xc0,0xfc,0x0f,0xc0,0xfc,0x0f,0xc0,0xfc,0x0f,0xc0,0x1f,0xf1,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '&'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '''
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x00,0x7e,0x00,0x00,0x0f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '('
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xf0,0x00,0x00,0x7e,0x00,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ')'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x81,0xf8,0x03,0xff,0xc0,0xff,0xff,0xff,0x03,0xff,0xc0,0x1f,0x81,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '*'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x1f,0xff,0xf8,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '+'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ','
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '-'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '.'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xf8,0x00,0x01,0xc0,0x00,0x0f,0xc0,0x00,0x0e,0x00,0x00,0x7e,0x00,0x00,0x70,0x00,0x03,0xf0,0x00,0x03,0x80,0x00,0x1f,0x80,0x00,0x1c,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '/'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x71,0xf8,0xfc,0x71,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '0'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x03,0xfe,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x1f,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '1'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x1f,0x80,0x00,0xfc,0x00,0x00,0xff,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '2'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x03,0xff,0xc0,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '3'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xc0,0x00,0x7f,0xc0,0x03,0xff,0xc0,0x1f,0x8f,0xc0,0xfc,0x0f,0xc0,0xff,0xff,0xf8,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '4'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xf8,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xc0,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '5'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xff,0xc0,0x1f,0x80,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '6'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '7'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '8'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x0f,0xc0,0x1f,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '9'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ':'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x03,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ';'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xf8,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x1f,0x80,0x00,0x1f,0x80,0x00,0x03,0xf0,0x00,0x00,0x7e,0x00,0x00,0x0f,0xc0,0x00,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '<'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '='
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x80,0x00,0x03,0xf0,0x00,0x00,0x7e,0x00,0x00,0x0f,0xc0,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x1f,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '>'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0x00,0x01,0xf8,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '?'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x7f,0xf8,0xfc,0x7f,0xf8,0xfc,0x7f,0xf8,0xfc,0x7f,0xf8,0xfc,0x7f,0xc0,0xfc,0x00,0x00,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '@'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x03,0xfe,0x00,0x1f,0x8f,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'A'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'B'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xff,0xc0,0x1f,0x81,0xf8,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0x1f,0x81,0xf8,0x03,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'C'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xfe,0x00,0xfc,0x0f,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x0f,0xc0,0xff,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'D'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xf8,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xc0,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'E'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xf8,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xc0,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'F'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xff,0xc0,0x1f,0x81,0xf8,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x0f,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0x81,0xf8,0x03,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'G'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'H'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xff,0xc0,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x03,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'I'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xf8,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0xfc,0x0f,0xc0,0xfc,0x0f,0xc0,0x1f,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'J'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x0f,0xc0,0xfc,0x7e,0x00,0xff,0xf0,0x00,0xff,0x80,0x00,0xff,0x80,0x00,0xff,0xf0,0x00,0xfc,0x7e,0x00,0xfc,0x0f,0xc0,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'K'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'L'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xff,0x8f,0xf8,0xff,0xff,0xf8,0xff,0xff,0xf8,0xfc,0x71,0xf8,0xfc,0x71,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'M'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xff,0x81,0xf8,0xff,0xf1,0xf8,0xff,0xff,0xf8,0xfc,0x7f,0xf8,0xfc,0x0f,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'N'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'O'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xc0,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'P'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xf1,0xf8,0xfc,0x7f,0xf8,0x1f,0xff,0xc0,0x00,0x0f,0xc0,0x00,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00},    // 'Q'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xc0,0xfc,0x7e,0x00,0xfc,0x0f,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'R'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x00,0x00,0x1f,0x80,0x00,0x03,0xfe,0x00,0x00,0x0f,0xc0,0x00,0x01,0xf8,0x00,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'S'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xf8,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'T'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'U'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0x8f,0xc0,0x03,0xfe,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'V'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x71,0xf8,0xfc,0x71,0xf8,0xff,0xff,0xf8,0xff,0x8f,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'W'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0x8f,0xc0,0x1f,0x8f,0xc0,0x03,0xfe,0x00,0x03,0xfe,0x00,0x1f,0x8f,0xc0,0x1f,0x8f,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'X'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x81,0xf8,0x1f,0x81,0xf8,0x1f,0x81,0xf8,0x1f,0x81,0xf8,0x03,0xff,0xc0,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'Y'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x1f,0x80,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'Z'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xff,0xc0,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '['
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x1c,0x00,0x00,0x1f,0x80,0x00,0x03,0x80,0x00,0x03,0xf0,0x00,0x00,0x70,0x00,0x00,0x7e,0x00,0x00,0x0e,0x00,0x00,0x0f,0xc0,0x00,0x01,0xc0,0x00,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '\'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xff,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x00,0x0f,0xc0,0x03,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // ']'
	{0x00,0x00,0x00,0x00,0x70,0x00,0x03,0xfe,0x00,0x1f,0x8f,0xc0,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '^'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00},    // '_'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xf0,0x00,0x03,0xf0,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '`'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0x00,0x01,0xf8,0x1f,0xff,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'a'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'b'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'c'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x1f,0xff,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'd'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xff,0xff,0xf8,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'e'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xff,0xc0,0x1f,0x81,0xf8,0x1f,0x80,0x00,0x1f,0x80,0x00,0xff,0xf0,0x00,0x1f,0x80,0x00,0x1f,0x80,0x00,0x1f,0x80,0x00,0x1f,0x80,0x00,0x1f,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'f'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00},    // 'g'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'h'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'i'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x00,0x00,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x1f,0x81,0xf8,0x03,0xff,0xc0,0x00,0x00,0x00},    // 'j'
	{0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x0f,0xc0,0xfc,0x7e,0x00,0xff,0xf0,0x00,0xfc,0x7e,0x00,0xfc,0x0f,0xc0,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'k'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xfe,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x03,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'l'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x8f,0xc0,0xfc,0x71,0xf8,0xfc,0x71,0xf8,0xfc,0x71,0xf8,0xfc,0x71,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'm'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'n'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'o'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xc0,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00},    // 'p'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x00,0x00},    // 'q'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xc0,0xfc,0x01,0xf8,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'r'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xc0,0xfc,0x00,0x00,0x1f,0xf0,0x00,0x00,0x7f,0xc0,0x00,0x01,0xf8,0x00,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 's'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0xff,0xff,0xc0,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x03,0xf0,0x00,0x00,0x7f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 't'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'u'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0x8f,0xc0,0x03,0xfe,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'v'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x71,0xf8,0xfc,0x71,0xf8,0xff,0xff,0xf8,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'w'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0x1f,0x8f,0xc0,0x03,0xfe,0x00,0x03,0xfe,0x00,0x03,0xfe,0x00,0x1f,0x8f,0xc0,0xfc,0x01,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'x'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0x1f,0xff,0xf8,0x00,0x01,0xf8,0x00,0x01,0xf8,0x1f,0xff,0xc0,0x00,0x00,0x00},    // 'y'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xf8,0x00,0x01,0xf8,0x00,0x0f,0xc0,0x00,0x7e,0x00,0x03,0xf0,0x00,0x1f,0x80,0x00,0xff,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // 'z'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xf8,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x1f,0x80,0x00,0x1f,0x80,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x0f,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '{'
	{0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '|'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xf0,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x01,0xf8,0x00,0x01,0xf8,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x1f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '}'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xf1,0xf8,0xfc,0x7f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},    // '~'
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x03,0xfe,0x00,0x1f,0x8f,0xc0,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xfc,0x01,0xf8,0xff,0xff,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}     // 128
   };


class CFaxTestStep : public CTestStep
{
public:
	CFaxTestStep();
	~CFaxTestStep();
 	virtual TVerdict doTestStepPreambleL();
	virtual TVerdict doTestStepPostambleL();

protected:
	void ReadDestPhoneNumberFromIniFileL(TDes8& aPhoneNumber);
	void ReadFaxCommDBSettingsL(TFaxSettings& aFaxSettings);
	TInt BeginFaxTransfer(CFaxTransfer* aFaxSession);
	void GenerateHeaderFileL(TFaxSettings& aFaxSettings, const TUint8* aFont,
							 TInt aWidth, TInt aHeight);

protected:
	CActiveScheduler*  iScheduler;
	TBuf<32>   iPortDriverName;
	TBuf<32>   iCommPortName;
	TBuf8<32>  iModemInitString;
	TBuf8<32>  iFaxInitString;
};


#endif // __TE_FAXBASE_H__
