// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// ipclookup.h   
// 
//

#ifndef __IPCLOOKUP_H__
#define __IPCLOOKUP_H__

#include "replaytypes.h"

const TIpcToName TIpcLookup[] = 
	{
		// ETel
		{0, _L8("EEtelOpenFromSession")},
		{1, _L8("EEtelOpenFromSubSession")},
		{2, _L8("EEtelOpenByNameFromSession")},
		{3, _L8("EEtelOpenByNameFromSubSession")},
		{4, _L8("EEtelClose")},
		{5, _L8("EEtelCancelSubSession")},
		{6, _L8("EETelLineCapsChangeNotification")},
		{7, _L8("EETelLineCapsChangeNotificationCancel")},
		{8, _L8("EETelPhoneCapsChangeNotification")},
		{9, _L8("EETelPhoneCapsChangeNotificationCancel")},
		{10, _L8("EEtelCallCapsChangeNotification")},
		{11, _L8("EEtelCallCapsChangeNotificationCancel")},
		{12, _L8("EEtelCallGetBearerServiceInfo")},
		{13, _L8("EEtelCallGetCallDuration")},
		{14, _L8("EEtelCallGetCallParams")},
		{15, _L8("EEtelCallGetCaps")},
		{16, _L8("EEtelCallGetFaxSettings")},
		{17, _L8("EEtelCallGetInfo")},
		{18, _L8("EEtelCallGetOwnershipStatus")},
		{19, _L8("EEtelCallGetStatus")},
		{20, _L8("EEtelCallNotifyDurationChange")},
		{21, _L8("EEtelCallNotifyDurationChangeCancel")},
		{22, _L8("EEtelCallNotifyHookChange")},
		{23, _L8("EEtelCallNotifyHookChangeCancel")},
		{24, _L8("EEtelCallNotifyStatusChange")},
		{25, _L8("EEtelCallNotifyStatusChangeCancel")},
		{26, _L8("EEtelCallReferenceCount")},
		{27, _L8("EEtelDbgCheckHeap")},
		{28, _L8("EEtelDbgDoDumpDebugInfo")},
		{29, _L8("EEtelDbgFailNext")},
		{30, _L8("EEtelDbgMarkEnd")},
		{31, _L8("EEtelDbgMarkHeap")},
		{32, _L8("EEtelDbgSetDebugPrintMask")},
		{33, _L8("EEtelFaxWaitForEndOfPage")},
		{34, _L8("EEtelLineEnumerateCall")},
		{35, _L8("EEtelLineGetCallInfo")},
		{36, _L8("EEtelLineGetCaps")},
		{37, _L8("EEtelLineGetHookStatus")},
		{38, _L8("EEtelLineGetInfo")},
		{39, _L8("EEtelLineGetStatus")},
		{40, _L8("EEtelLineNotifyCallAdded")},
		{41, _L8("EEtelLineNotifyCallAddedCancel")},
		{42, _L8("EEtelLineNotifyHookChange")},
		{43, _L8("EEtelLineNotifyHookChangeCancel")},
		{44, _L8("EEtelLineNotifyStatusChange")},
		{45, _L8("EEtelLineNotifyStatusChangeCancel")},
		{46, _L8("EEtelPhoneEnumerateLines")},
		{47, _L8("EEtelPhoneGetCaps")},
		{48, _L8("EEtelPhoneGetInfo")},
		{49, _L8("EEtelPhoneGetLineInfo")},
		{50, _L8("EEtelPhoneGetStatus")},
		{51, _L8("EEtelPhoneNotifyModemDetected")},
		{52, _L8("EEtelPhoneNotifyModemDetectedCancel")},
		{53, _L8("EEtelServerClosePhoneModule")},
		{54, _L8("EEtelServerEnumeratePhones")},
		{55, _L8("EEtelServerGetTsyName")},
		{56, _L8("EEtelServerGetTsyVersionNo")},
		{57, _L8("EEtelServerLoadPhoneModule")},
		{58, _L8("EEtelServerOpen")},
		{59, _L8("EEtelServerPhoneInfoByIndex")},
		{60, _L8("EEtelServerQueryTsyFunctionality")},
		{61, _L8("EEtelServerSetExtendedErrorGranularity")},
		{62, _L8("EEtelAdoptFaxSharedHeaderFile")},
		{63, _L8("EEtelCallAcquireOwnership")},
		{64, _L8("EEtelCallAcquireOwnershipCancel")},
		{65, _L8("EEtelCallConnect")},
		{66, _L8("EEtelCallConnectCancel")},
		{67, _L8("EEtelCallHangUp")},
		{68, _L8("EEtelCallHangUpCancel")},
		{69, _L8("EEtelCallTransferOwnership")},
		{70, _L8("EEtelFaxTerminateFaxSession")},
		{71, _L8("EEtelLineNotifyIncomingCall")},
		{72, _L8("EEtelLineNotifyIncomingCallCancel")},
		{73, _L8("EEtelCallSetFaxSettings")},
		{74, _L8("EEtelGlobalKernelObjectHandle")},
		{75, _L8("EEtelPhoneInitialise")},
		{76, _L8("EEtelPhoneInitialiseCancel")},
		{77, _L8("EEtelServerSetPriorityClient")},
		{78, _L8("EEtelCallAnswer")},
		{79, _L8("EEtelCallAnswerCancel")},
		{80, _L8("EEtelCallDial")},
		{81, _L8("EEtelCallDialCancel")},
		{82, _L8("EEtelCallLoanDataPort")},
		{83, _L8("EEtelCallLoanDataPortCancel")},
		{84, _L8("EEtelCallRecoverDataPort")},
		{85, _L8("EEtelFaxRead")},
		{86, _L8("EEtelFaxWrite")},
		{87, _L8("EEtelDbgFailNextAvail")},
		{88, _L8("EETelPhoneSetEmergencyClient")},
		{89, _L8("EEtelOpenFromSubSessionLcs")},
		{90, _L8("EEtelServerSetPriorityClientV2")},
        {91, _L8("EMobileCallDialCallControl")},
		
		{591, _L8("EMobileCallDialCallControlCancel")},
		
		// ETelMM
		{20000, _L8("EMobileBroadcastMessagingGetCaps")},
		{20001, _L8("EMobileBroadcastMessagingNotifyIdListChange")},
		{20002, _L8("EMobileBroadcastMessagingReceiveMessage")},
		{20003, _L8("EMobileCallGetCurrentHscsdInfo")},
		{20004, _L8("EMobileCallGetMobileCallCaps")},
		{20005, _L8("EMobileCallGetMobileCallStatus")},
		{20006, _L8("EMobileCallGetMobileDataCallCaps")},
		{20007, _L8("EMobileCallGetUUSCaps")},
		{20008, _L8("EMobileCallNotifyAlternatingCallSwitch")},
		{20009, _L8("EMobileCallNotifyAudioToneEvent")},
		{20010, _L8("EMobileCallNotifyCallEvent")},
		{20011, _L8("EMobileCallNotifyHscsdInfoChange")},
		{20012, _L8("EMobileCallNotifyMobileCallCapsChange")},
		{20013, _L8("EMobileCallNotifyMobileCallStatusChange")},
		{20014, _L8("EMobileCallNotifyMobileDataCallCapsChange")},
		{20015, _L8("EMobileCallNotifyUUSCapsChange")},
		{20016, _L8("EMobileCallNotifyVoiceFallback")},
		{20017, _L8("EMobileConferenceCallEnumerateCalls")},
		{20018, _L8("EMobileConferenceCallGetCaps")},
		{20019, _L8("EMobileConferenceCallGetConferenceStatus")},
		{20020, _L8("EMobileConferenceCallNotifyCapsChange")},
		{20021, _L8("EMobileConferenceCallNotifyConferenceEvent")},
		{20022, _L8("EMobileConferenceCallNotifyConferenceStatusChange")},
		{20023, _L8("EMobileLineGetMobileLineStatus")},
		{20024, _L8("EMobileLineNotifyMobileLineStatusChange")},
		{20025, _L8("EMobilePhoneEnumerateUSimApplications")},
		{20026, _L8("EMobilePhoneGetALSLine")},
		{20027, _L8("EMobilePhoneGetAlternatingCallCaps")},
		{20028, _L8("EMobilePhoneGetAlternatingCallMode")},
		{20029, _L8("EMobilePhoneGetBatteryCaps")},
		{20030, _L8("EMobilePhoneGetBatteryInfo")},
		{20031, _L8("EMobilePhoneGetCCBSStatus")},
		{20032, _L8("EMobilePhoneGetCallForwardingIndicator")},
		{20033, _L8("EMobilePhoneGetCallServiceCaps")},
		{20034, _L8("EMobilePhoneGetCipheringIndicatorStatus")},
		{20035, _L8("EMobilePhoneGetCompMethodName")},
		{20036, _L8("EMobilePhoneGetCostCaps")},
		{20037, _L8("EMobilePhoneGetCurrentMode")},
		{20038, _L8("EMobilePhoneGetCustomerServiceProfile")},
		{20039, _L8("EMobilePhoneGetDTMFCaps")},
		{20040, _L8("EMobilePhoneGetFdnStatus")},
		{20041, _L8("EMobilePhoneGetHomeNetworkSearchPeriod")},
		{20042, _L8("EMobilePhoneGetIccAccessCaps")},
		{20043, _L8("EMobilePhoneGetIdentityCaps")},
		{20044, _L8("EMobilePhoneGetIdentityServiceStatus")},
		{20045, _L8("EMobilePhoneGetIncomingCallType")},
		{20046, _L8("EMobilePhoneGetIndicator")},
		{20047, _L8("EMobilePhoneGetIndicatorCaps")},
		{20048, _L8("EMobilePhoneGetLastUsedAccessTechnology")},
		{20049, _L8("EMobilePhoneGetMulticallParams")},
		{20050, _L8("EMobilePhoneGetMultimediaCallPreference")},
		{20051, _L8("EMobilePhoneGetMultimodeCaps")},
		{20052, _L8("EMobilePhoneGetNetworkCaps")},
		{20053, _L8("EMobilePhoneGetNetworkInvScanSetting")},
		{20054, _L8("EMobilePhoneGetNetworkRegistrationStatus")},
		{20055, _L8("EMobilePhoneGetNetworkSecurityLevel")},
		{20056, _L8("EMobilePhoneGetPersonalisationCaps")},
		{20057, _L8("EMobilePhoneGetSecurityCaps")},
		{20058, _L8("EMobilePhoneGetServiceTable")},
		{20059, _L8("EMobilePhoneGetSignalCaps")},
		{20060, _L8("EMobilePhoneGetSignalStrength")},
		{20061, _L8("EMobilePhoneGetUSimApplicationsInfo")},
		{20062, _L8("EMobilePhoneGetUSimAppsSelectionMode")},
		{20063, _L8("EMobilePhoneGetUUSSetting")},
		{20064, _L8("EMobilePhoneNotifyALSLineChange")},
		{20065, _L8("EMobilePhoneNotifyAlternatingCallCapsChange")},
		{20066, _L8("EMobilePhoneNotifyAlternatingCallModeChange")},
		{20067, _L8("EMobilePhoneNotifyBatteryInfoChange")},
		{20068, _L8("EMobilePhoneNotifyCCBSRecall")},
		{20069, _L8("EMobilePhoneNotifyCCBSStatusChange")},
		{20070, _L8("EMobilePhoneNotifyCallBarringStatusChange")},
		{20071, _L8("EMobilePhoneNotifyCallForwardingActive")},
		{20072, _L8("EMobilePhoneNotifyCallForwardingStatusChange")},
		{20073, _L8("EMobilePhoneNotifyCallServiceCapsChange")},
		{20074, _L8("EMobilePhoneNotifyCallWaitingStatusChange")},
		{20075, _L8("EMobilePhoneNotifyCipheringIndicatorStatus")},
		{20076, _L8("EMobilePhoneNotifyCostCapsChange")},
		{20077, _L8("EMobilePhoneNotifyDTMFCapsChange")},
		{20078, _L8("EMobilePhoneNotifyDTMFEvent")},
		{20079, _L8("EMobilePhoneNotifyFdnStatusChange")},
		{20080, _L8("EMobilePhoneNotifyIccAccessCapsChange")},
		{20081, _L8("EMobilePhoneNotifyIdentityServiceStatus")},
		{20082, _L8("EMobilePhoneNotifyIdentitySuppressionRejected")},
		{20083, _L8("EMobilePhoneNotifyIncomingCallTypeChange")},
		{20084, _L8("EMobilePhoneNotifyIndicatorChange")},
		{20085, _L8("EMobilePhoneNotifyMessageWaiting")},
		{20086, _L8("EMobilePhoneNotifyModeChange")},
		{20087, _L8("EMobilePhoneNotifyMulticallIndicatorChange")},
		{20088, _L8("EMobilePhoneNotifyMulticallParamsChange")},
		{20089, _L8("EMobilePhoneNotifyMultimediaCallPreferenceChange")},
		{20090, _L8("EMobilePhoneNotifyNetworkInvScanChange")},
		{20091, _L8("EMobilePhoneNotifyNetworkInvScanEvent")},
		{20092, _L8("EMobilePhoneNotifyNetworkRegistrationStatusChange")},
		{20093, _L8("EMobilePhoneNotifyNetworkSecurityLevelChange")},
		{20094, _L8("EMobilePhoneNotifySecurityCapsChange")},
		{20095, _L8("EMobilePhoneNotifySecurityEvent")},
		{20096, _L8("EMobilePhoneNotifySendNetworkServiceRequest")},
		{20097, _L8("EMobilePhoneNotifySignalStrengthChange")},
		{20098, _L8("EMobilePhoneNotifyStorePreferredNetworksListChange")},
		{20099, _L8("EMobilePhoneNotifyUSimApplicationsInfoChange")},
		{20100, _L8("EMobilePhoneNotifyUSimAppsSelectionModeChange")},
		{20101, _L8("EMobilePhoneNotifyUUSSettingChange")},
		{20102, _L8("EMobileSmsMessagingEnumerateMessageStores")},
		{20103, _L8("EMobileSmsMessagingGetCaps")},
		{20104, _L8("EMobileSmsMessagingGetMessageStoreInfo")},
		{20105, _L8("EMobileSmsMessagingGetMoSmsBearer")},
		{20106, _L8("EMobileSmsMessagingGetReceiveMode")},
		{20107, _L8("EMobileSmsMessagingNotifyMoSmsBearerChange")},
		{20108, _L8("EMobileSmsMessagingNotifyReceiveModeChange")},
		{20109, _L8("EMobileSmsMessagingNotifySmspListChange")},
		{20110, _L8("EMobileUssdMessagingGetCaps")},
		{20111, _L8("EMobileUssdMessagingNotifyNetworkRelease")},
		{20112, _L8("EMobilePhoneNotifyImsAuthorizationInfoChanged")},
		{20113, _L8("EMobilePhoneEnumerateSmartCardApplications")},
		{20114, _L8("EMobilePhoneGetSmartCardApplicationInfo")},
		{20115, _L8("EMobilePhoneNotifySmartCardApplicationInfoChange")},
		{20116, _L8("EMobilePhoneGetCurrentActiveUSimApplication")},
		{20117, _L8("EMobilePhoneNotifyAllSendNetworkServiceRequest")},
		{20118, _L8("EMobilePhoneNotifyPreferredWlanSIDListChange")},
		{20501, _L8("EMobileBroadcastMessagingNotifyIdListChangeCancel")},
		{20502, _L8("EMobileBroadcastMessagingReceiveMessageCancel")},
		{20508, _L8("EMobileCallNotifyAlternatingCallSwitchCancel")},
		{20509, _L8("EMobileCallNotifyAudioToneEventCancel")},
		{20510, _L8("EMobileCallNotifyCallEventCancel")},
		{20511, _L8("EMobileCallNotifyHscsdInfoChangeCancel")},
		{20512, _L8("EMobileCallNotifyMobileCallCapsChangeCancel")},
		{20513, _L8("EMobileCallNotifyMobileCallStatusChangeCancel")},
		{20514, _L8("EMobileCallNotifyMobileDataCallCapsChangeCancel")},
		{20515, _L8("EMobileCallNotifyUUSCapsChangeCancel")},
		{20516, _L8("EMobileCallNotifyVoiceFallbackCancel")},
		{20520, _L8("EMobileConferenceCallNotifyCapsChangeCancel")},
		{20521, _L8("EMobileConferenceCallNotifyConferenceEventCancel")},
		{20522, _L8("EMobileConferenceCallNotifyConferenceStatusChangeCancel")},
		{20524, _L8("EMobileLineNotifyMobileLineStatusChangeCancel")},
		{20525, _L8("EMobilePhoneEnumerateUSimApplicationsCancel")},
		{20530, _L8("EMobilePhoneGetBatteryInfoCancel")},
		{20531, _L8("EMobilePhoneGetCCBSStatusCancel")},
		{20532, _L8("EMobilePhoneGetCallForwardingIndicatorCancel")},
		{20534, _L8("EMobilePhoneGetCipheringIndicatorStatusCancel")},
		{20535, _L8("EMobilePhoneGetCompMethodNameCancel")},
		{20538, _L8("EMobilePhoneGetCustomerServiceProfileCancel")},
		{20540, _L8("EMobilePhoneGetFdnStatusCancel")},
		{20541, _L8("EMobilePhoneGetHomeNetworkSearchPeriodCancel")},
		{20544, _L8("EMobilePhoneGetIdentityServiceStatusCancel")},
		{20545, _L8("EMobilePhoneGetIncomingCallTypeCancel")},
		{20546, _L8("EMobilePhoneGetIndicatorCancel")},
		{20548, _L8("EMobilePhoneGetLastUsedAccessTechnologyCancel")},
		{20549, _L8("EMobilePhoneGetMulticallParamsCancel")},
		{20550, _L8("EMobilePhoneGetMultimediaCallPreferenceCancel")},
		{20554, _L8("EMobilePhoneGetNetworkRegistrationStatusCancel")},
		{20555, _L8("EMobilePhoneGetNetworkSecurityLevelCancel")},
		{20556, _L8("EMobilePhoneGetPersonalisationCapsCancel")},
		{20558, _L8("EMobilePhoneGetServiceTableCancel")},
		{20560, _L8("EMobilePhoneGetSignalStrengthCancel")},
		{20561, _L8("EMobilePhoneGetUSimApplicationsInfoCancel")},
		{20562, _L8("EMobilePhoneGetUSimAppsSelectionModeCancel")},
		{20563, _L8("EMobilePhoneGetUUSSettingCancel")},
		{20564, _L8("EMobilePhoneNotifyALSLineChangeCancel")},
		{20565, _L8("EMobilePhoneNotifyAlternatingCallCapsChangeCancel")},
		{20566, _L8("EMobilePhoneNotifyAlternatingCallModeChangeCancel")},
		{20567, _L8("EMobilePhoneNotifyBatteryInfoChangeCancel")},
		{20568, _L8("EMobilePhoneNotifyCCBSRecallCancel")},
		{20569, _L8("EMobilePhoneNotifyCCBSStatusChangeCancel")},
		{20570, _L8("EMobilePhoneNotifyCallBarringStatusChangeCancel")},
		{20571, _L8("EMobilePhoneNotifyCallForwardingActiveCancel")},
		{20572, _L8("EMobilePhoneNotifyCallForwardingStatusChangeCancel")},
		{20573, _L8("EMobilePhoneNotifyCallServiceCapsChangeCancel")},
		{20574, _L8("EMobilePhoneNotifyCallWaitingStatusChangeCancel")},
		{20575, _L8("EMobilePhoneNotifyCipheringIndicatorStatusCancel")},
		{20576, _L8("EMobilePhoneNotifyCostCapsChangeCancel")},
		{20577, _L8("EMobilePhoneNotifyDTMFCapsChangeCancel")},
		{20578, _L8("EMobilePhoneNotifyDTMFEventCancel")},
		{20579, _L8("EMobilePhoneNotifyFdnStatusChangeCancel")},
		{20580, _L8("EMobilePhoneNotifyIccAccessCapsChangeCancel")},
		{20581, _L8("EMobilePhoneNotifyIdentityServiceStatusCancel")},
		{20582, _L8("EMobilePhoneNotifyIdentitySuppressionRejectedCancel")},
		{20583, _L8("EMobilePhoneNotifyIncomingCallTypeChangeCancel")},
		{20584, _L8("EMobilePhoneNotifyIndicatorChangeCancel")},
		{20585, _L8("EMobilePhoneNotifyMessageWaitingCancel")},
		{20586, _L8("EMobilePhoneNotifyModeChangeCancel")},
		{20587, _L8("EMobilePhoneNotifyMulticallIndicatorChangeCancel")},
		{20588, _L8("EMobilePhoneNotifyMulticallParamsChangeCancel")},
		{20589, _L8("EMobilePhoneNotifyMultimediaCallPreferenceChangeCancel")},
		{20590, _L8("EMobilePhoneNotifyNetworkInvScanChangeCancel")},
		{20591, _L8("EMobilePhoneNotifyNetworkInvScanEventCancel")},
		{20592, _L8("EMobilePhoneNotifyNetworkRegistrationStatusChangeCancel")},
		{20593, _L8("EMobilePhoneNotifyNetworkSecurityLevelChangeCancel")},
		{20594, _L8("EMobilePhoneNotifySecurityCapsChangeCancel")},
		{20595, _L8("EMobilePhoneNotifySecurityEventCancel")},
		{20596, _L8("EMobilePhoneNotifySendNetworkServiceRequestCancel")},
		{20597, _L8("EMobilePhoneNotifySignalStrengthChangeCancel")},
		{20598, _L8("EMobilePhoneNotifyStorePreferredNetworksListChangeCancel")},
		{20599, _L8("EMobilePhoneNotifyUSimApplicationsInfoChangeCancel")},
		{20600, _L8("EMobilePhoneNotifyUSimAppsSelectionModeChangeCancel")},
		{20601, _L8("EMobilePhoneNotifyUUSSettingChangeCancel")},
		{20604, _L8("EMobileSmsMessagingGetMessageStoreInfoCancel")},
		{20607, _L8("EMobileSmsMessagingNotifyMoSmsBearerChangeCancel")},
		{20608, _L8("EMobileSmsMessagingNotifyReceiveModeChangeCancel")},
		{20609, _L8("EMobileSmsMessagingNotifySmspListChangeCancel")},
		{20611, _L8("EMobileUssdMessagingNotifyNetworkReleaseCancel")},
		{20612, _L8("EMobilePhoneNotifyImsAuthorizationInfoChangedCancel")},
		{20613, _L8("EMobilePhoneEnumerateSmartCardApplicationsCancel")},
		{20614, _L8("EMobilePhoneGetSmartCardApplicationInfoCancel")},
		{20615, _L8("EMobilePhoneNotifySmartCardApplicationInfoChangeCancel")},
		{20616, _L8("EMobilePhoneGetCurrentActiveUSimApplicationCancel")},
		{20617, _L8("EMobilePhoneNotifyAllSendNetworkServiceRequestCancel")},
		{20618, _L8("EMobilePhoneNotifyPreferredWlanSIDListChangeCancel")},
		{21000, _L8("EMobileCallActivateCCBS")},
		{21001, _L8("EMobileCallAnswerISV")},
		{21002, _L8("EMobileCallAnswerMultimediaCallAsVoice")},
		{21003, _L8("EMobileCallDeflect")},
		{21004, _L8("EMobileCallDialISV")},
		{21005, _L8("EMobileCallGoOneToOne")},
		{21006, _L8("EMobileCallHold")},
		{21007, _L8("EMobileCallNotifyPrivacyConfirmation")},
		{21008, _L8("EMobileCallNotifyTrafficChannelConfirmation")},
		{21009, _L8("EMobileCallRejectCCBS")},
		{21010, _L8("EMobileCallResume")},
		{21011, _L8("EMobileCallSetDynamicHscsdParams")},
		{21012, _L8("EMobileCallSetPrivacy")},
		{21013, _L8("EMobileCallSetTrafficChannel")},
		{21014, _L8("EMobileCallSwap")},
		{21015, _L8("EMobileCallSwitchAlternatingCall")},
		{21016, _L8("EMobileCallTransfer")},
		{21017, _L8("EMobileConferenceCallAddCall")},
		{21018, _L8("EMobileConferenceCallCreateConference")},
		{21019, _L8("EMobileConferenceCallHangUp")},
		{21020, _L8("EMobileConferenceCallSwap")},
		{21021, _L8("EMobilePhoneAcceptCCBSRecall")},
		{21022, _L8("EMobilePhoneContinueDTMFStringSending")},
		{21023, _L8("EMobilePhoneNotifyStopInDTMFString")},
		{21024, _L8("EMobilePhoneReadDTMFTones")},
		{21025, _L8("EMobilePhoneRefuseCCBSRecall")},
		{21026, _L8("EMobilePhoneSendDTMFTones")},
		{21027, _L8("EMobilePhoneStartDTMFTone")},
		{21028, _L8("EMobilePhoneStopDTMFTone")},
		{21029, _L8("EMobilePhoneTerminateAllCalls")},
		{21030, _L8("EMobilePhoneTerminateActiveCalls")},
		{21500, _L8("EMobileCallActivateCCBSCancel")},
		{21501, _L8("EMobileCallAnswerISVCancel")},
		{21502, _L8("EMobileCallAnswerMultimediaCallAsVoiceCancel")},
		{21503, _L8("EMobileCallDeflectCancel")},
		{21504, _L8("EMobileCallDialISVCancel")},
		{21505, _L8("EMobileCallGoOneToOneCancel")},
		{21506, _L8("EMobileCallHoldCancel")},
		{21507, _L8("EMobileCallNotifyPrivacyConfirmationCancel")},
		{21508, _L8("EMobileCallNotifyTrafficChannelConfirmationCancel")},
		{21510, _L8("EMobileCallResumeCancel")},
		{21511, _L8("EMobileCallSetDynamicHscsdParamsCancel")},
		{21514, _L8("EMobileCallSwapCancel")},
		{21515, _L8("EMobileCallSwitchAlternatingCallCancel")},
		{21516, _L8("EMobileCallTransferCancel")},
		{21517, _L8("EMobileConferenceCallAddCallCancel")},
		{21518, _L8("EMobileConferenceCallCreateConferenceCancel")},
		{21519, _L8("EMobileConferenceCallHangUpCancel")},
		{21520, _L8("EMobileConferenceCallSwapCancel")},
		{21521, _L8("EMobilePhoneAcceptCCBSRecallCancel")},
		{21523, _L8("EMobilePhoneNotifyStopInDTMFStringCancel")},
		{21524, _L8("EMobilePhoneReadDTMFTonesCancel")},
		{21526, _L8("EMobilePhoneSendDTMFTonesCancel")},
		{21529, _L8("EMobilePhoneTerminateAllCallsCancel")},
		{21530, _L8("EMobilePhoneTerminateActiveCallsCancel")},
		{22000, _L8("EMobileConferenceCallGetMobileCallInfo")},
		{22001, _L8("EMobilePhoneEnumerateAPNEntries")},
		{22002, _L8("EMobilePhoneGetAPNname")},
		{22003, _L8("EMobilePhoneGetFeatureCode")},
		{22004, _L8("EMobilePhoneGetHomeNetwork")},
		{22005, _L8("EMobilePhoneGetIccMessageWaitingIndicators")},
		{22006, _L8("EMobilePhoneGetLockInfo")},
		{22007, _L8("EMobilePhoneGetMmsConfig")},
		{22008, _L8("EMobilePhoneGetNITZInfo")},
		{22009, _L8("EMobilePhoneGetNetworkName")},
		{22010, _L8("EMobilePhoneGetNetworkSelectionSetting")},
		{22011, _L8("EMobilePhoneGetPersonalisationStatus")},
		{22012, _L8("EMobilePhoneGetPhoneId")},
		{22013, _L8("EMobilePhoneGetPhoneStoreInfo")},
		{22014, _L8("EMobilePhoneGetPreferredNetworksPhase1")},
		{22015, _L8("EMobilePhoneGetPreferredNetworksPhase2")},
		{22016, _L8("EMobilePhoneGetServiceProviderName")},
		{22017, _L8("EMobilePhoneGetSubscriberId")},
		{22018, _L8("EMobilePhoneNotifyIccMessageWaitingIndicatorsChange")},
		{22019, _L8("EMobilePhoneNotifyLockInfoChange")},
		{22020, _L8("EMobilePhoneNotifyMmsConfig")},
		{22021, _L8("EMobilePhoneNotifyMmsUpdate")},
		{22022, _L8("EMobilePhoneNotifyNITZInfoChange")},
		{22023, _L8("EMobilePhoneNotifyNetworkSelectionSettingChange")},
		{22024, _L8("EMobilePhoneStoreReadAllPhase1")},
		{22025, _L8("EMobilePhoneStoreReadAllPhase2")},
		{22026, _L8("EMobilePhoneStoreReadAllV4Phase1")},
		{22027, _L8("EMobilePhoneStoreReadAllV4Phase2")},
		{22028, _L8("EMobileSmsMessagingGetSmspListPhase1")},
		{22029, _L8("EMobileSmsMessagingGetSmspListPhase2")},
		{22030, _L8("EMobilePhoneAuthorizationInfoPhase1")},
		{22031, _L8("EMobilePhoneAuthorizationInfoPhase2")},
		{22032, _L8("EMobilePhoneIMSAuthenticate")},
		{22033, _L8("EMobilePhoneGetScFileInfo")},
		{22034, _L8("EMobilePhoneReadScFile")},
		{22035, _L8("EMobilePhoneGetIccIdentity")},
		{22036, _L8("EMobilePhoneGetSecurityCodeInfo")},
		{22037, _L8("EMobilePhoneNotifySecurityCodeInfoChange")},
		{22038, _L8("EMobilePhoneSmartCardAuthenticate")},
		{22039, _L8("EMobileSmartCardEapGetAuthenticationStatus")},
		{22040, _L8("EMobileSmartCardEapGetUserIdentity")},
		{22041, _L8("EMobileSmartCardEapGetEapKey")},
		{22042, _L8("EMobileSmartCardEapNotifyEapMethodAccessStatusChange")},
		{22043, _L8("EMobileSmartCardEapAuthenticationPhase1")},
		{22044, _L8("EMobileSmartCardEapAuthenticationPhase2")},
		{22045, _L8("EMobileSmartCardEapReleaseEapMethod")},
		{22046, _L8("EMobileSmartCardEapGetEapMethodAccessStatus")},
		{22047, _L8("EMobilePhoneNotifyAPNListChanged")},
		{22048, _L8("EMobilePhoneGetAPNControlListServiceStatus")},
		{22049, _L8("EMobilePhoneNotifyAPNControlListServiceStatusChange")},
		{22050, _L8("EMobilePhoneGetAuthenticationParams")},
		{22051, _L8("EMobilePhoneNotifyAuthenticateDataChange")},
		{22052, _L8("EMobilePhoneAuthenticationListPhase1")},
		{22053, _L8("EMobilePhoneAuthenticationListPhase2")},
		{22054, _L8("EMobilePhoneNotifyWlanDataChange")},
		{22055, _L8("EMobilePhoneGetWlanData")},
		{22056, _L8("EMobilePhoneGetPreferredWlanSIDsPhase1")},
		{22057, _L8("EMobilePhoneGetPreferredWlanSIDsPhase2")},
		{22501, _L8("EMobilePhoneEnumerateAPNEntriesCancel")},
		{22502, _L8("EMobilePhoneGetAPNnameCancel")},
		{22503, _L8("EMobilePhoneGetFeatureCodeCancel")},
		{22504, _L8("EMobilePhoneGetHomeNetworkCancel")},
		{22505, _L8("EMobilePhoneGetIccMessageWaitingIndicatorsCancel")},
		{22506, _L8("EMobilePhoneGetLockInfoCancel")},
		{22507, _L8("EMobilePhoneGetMmsConfigCancel")},
		{22509, _L8("EMobilePhoneGetNetworkNameCancel")},
		{22511, _L8("EMobilePhoneGetPersonalisationStatusCancel")},
		{22512, _L8("EMobilePhoneGetPhoneIdCancel")},
		{22513, _L8("EMobilePhoneGetPhoneStoreInfoCancel")},
		{22514, _L8("EMobilePhoneGetPreferredNetworksCancel")},
		{22516, _L8("EMobilePhoneGetServiceProviderNameCancel")},
		{22517, _L8("EMobilePhoneGetSubscriberIdCancel")},
		{22518, _L8("EMobilePhoneNotifyIccMessageWaitingIndicatorsChangeCancel")},
		{22519, _L8("EMobilePhoneNotifyLockInfoChangeCancel")},
		{22520, _L8("EMobilePhoneNotifyMmsConfigCancel")},
		{22521, _L8("EMobilePhoneNotifyMmsUpdateCancel")},
		{22522, _L8("EMobilePhoneNotifyNITZInfoChangeCancel")},
		{22523, _L8("EMobilePhoneNotifyNetworkSelectionSettingChangeCancel")},
		{22524, _L8("EMobilePhoneStoreReadAllCancel")},
		{22526, _L8("EMobilePhoneStoreReadAllV4Cancel")},
		{22528, _L8("EMobileSmsMessagingGetSmspListCancel")},
		{22530, _L8("EMobilePhoneAuthorizationInfoCancel")},
		{22532, _L8("EMobilePhoneIMSAuthenticateCancel")},
		{22533, _L8("EMobilePhoneGetScFileInfoCancel")},
		{22534, _L8("EMobilePhoneReadScFileCancel")},
		{22535, _L8("EMobilePhoneGetIccIdentityCancel")},
		{22536, _L8("EMobilePhoneGetSecurityCodeInfoCancel")},
		{22537, _L8("EMobilePhoneNotifySecurityCodeInfoChangeCancel")},
		{22538, _L8("EMobilePhoneSmartCardAuthenticateCancel")},
		{22539, _L8("EMobileSmartCardEapGetAuthenticationStatusCancel")},
		{22540, _L8("EMobileSmartCardEapGetUserIdentityCancel")},
		{22541, _L8("EMobileSmartCardEapGetEapKeyCancel")},
		{22542, _L8("EMobileSmartCardEapNotifyEapMethodAccessStatusChangeCancel")},
		{22543, _L8("EMobileSmartCardEapAuthenticationCancel")},
		{22547, _L8("EMobilePhoneNotifyAPNListChangedCancel")},
		{22548, _L8("EMobilePhoneGetAPNControlListServiceStatusCancel")},
		{22549, _L8("EMobilePhoneNotifyAPNControlListServiceStatusChangeCancel")},
		{22550, _L8("EMobilePhoneGetAuthenticationParamsCancel")},
		{22551, _L8("EMobilePhoneNotifyAuthenticateDataChangeCancel")},
		{22552, _L8("EMobilePhoneAuthenticationListCancel ")},
		{22554, _L8("EMobilePhoneNotifyWlanDataChangeCancel")},
		{22555, _L8("EMobilePhoneGetWlanDataCancel")},
		{22556, _L8("EMobilePhoneGetPreferredWlanSIDsCancel")},
		{23000, _L8("EMobileNamStoreSetActiveNam = EEtelMMIpcOffset3")},
		{23001, _L8("EMobileNamStoreStoreAll")},
		{23002, _L8("EMobileNamStoreStoreAllV4")},
		{23003, _L8("EMobilePhoneAbortSecurityCode")},
		{23004, _L8("EMobilePhoneChangeSecurityCode")},
		{23005, _L8("EMobilePhoneClearBlacklist")},
		{23006, _L8("EMobilePhoneClearCostMeter")},
		{23007, _L8("EMobilePhoneProgramFeatureCode")},
		{23008, _L8("EMobilePhoneSetALSLine")},
		{23009, _L8("EMobilePhoneSetAlternatingCallMode")},
		{23010, _L8("EMobilePhoneSetFdnSetting")},
		{23011, _L8("EMobilePhoneSetIccMessageWaitingIndicators")},
		{23012, _L8("EMobilePhoneSetIdentityServiceStatus")},
		{23013, _L8("EMobilePhoneSetIncomingCallType")},
		{23014, _L8("EMobilePhoneSetLockSetting")},
		{23015, _L8("EMobilePhoneSetMaxCostMeter")},
		{23016, _L8("EMobilePhoneSetMmsUserConnParams")},
		{23017, _L8("EMobilePhoneSetMmsUserPreferences")},
		{23018, _L8("EMobilePhoneSetMulticallParams")},
		{23019, _L8("EMobilePhoneSetMultimediaCallPreference")},
		{23020, _L8("EMobilePhoneSetNetworkSelectionSetting")},
		{23021, _L8("EMobilePhoneSetPuct")},
		{23022, _L8("EMobilePhoneSetUSimApplicationStatus")},
		{23023, _L8("EMobilePhoneSetUSimAppsSelectionMode")},
		{23024, _L8("EMobilePhoneStorePreferredNetworksList")},
		{23025, _L8("EMobilePhoneVerifySecurityCode")},
		{23026, _L8("EMobileSmsMessagingSetMoSmsBearer")},
		{23027, _L8("EMobileSmsMessagingSetReceiveMode")},
		{23028, _L8("EMobileSmsMessagingStoreSmspList")},
		{23029, _L8("EMobilePhoneSetSmartCardApplicationStatus")},
		{23030, _L8("EMobilePhoneUpdateScFile")},
		{23031, _L8("EMobilePhoneAppendAPNName")},
		{23032, _L8("EMobilePhoneDeleteAPNName")},
		{23033, _L8("EMobilePhoneSetGbaBootstrapParams")},
		{23034, _L8("EMobilePhoneSetWlanData")},
		{23035, _L8("EMobilePhoneStorePreferredWlanSIDList")},
		{23500, _L8("EMobileNamStoreSetActiveNamCancel")},
		{23501, _L8("EMobileNamStoreStoreAllCancel")},
		{23502, _L8("EMobileNamStoreStoreAllV4Cancel")},
		{23504, _L8("EMobilePhoneChangeSecurityCodeCancel")},
		{23505, _L8("EMobilePhoneClearBlacklistCancel")},
		{23506, _L8("EMobilePhoneClearCostMeterCancel")},
		{23507, _L8("EMobilePhoneProgramFeatureCodeCancel")},
		{23508, _L8("EMobilePhoneSetALSLineCancel")},
		{23509, _L8("EMobilePhoneSetAlternatingCallModeCancel")},
		{23510, _L8("EMobilePhoneSetFdnSettingCancel")},
		{23511, _L8("EMobilePhoneSetIccMessageWaitingIndicatorsCancel")},
		{23512, _L8("EMobilePhoneSetIdentityServiceStatusCancel")},
		{23513, _L8("EMobilePhoneSetIncomingCallTypeCancel")},
		{23514, _L8("EMobilePhoneSetLockSettingCancel")},
		{23515, _L8("EMobilePhoneSetMaxCostMeterCancel")},
		{23516, _L8("EMobilePhoneSetMmsUserConnParamsCancel")},
		{23517, _L8("EMobilePhoneSetMmsUserPreferencesCancel")},
		{23518, _L8("EMobilePhoneSetMulticallParamsCancel")},
		{23519, _L8("EMobilePhoneSetMultimediaCallPreferenceCancel")},
		{23520, _L8("EMobilePhoneSetNetworkSelectionSettingCancel")},
		{23521, _L8("EMobilePhoneSetPuctCancel")},
		{23522, _L8("EMobilePhoneSetUSimApplicationStatusCancel")},
		{23523, _L8("EMobilePhoneSetUSimAppsSelectionModeCancel")},
		{23524, _L8("EMobilePhoneStorePreferredNetworksListCancel")},
		{23525, _L8("EMobilePhoneVerifySecurityCodeCancel")},
		{23526, _L8("EMobileSmsMessagingSetMoSmsBearerCancel")},
		{23527, _L8("EMobileSmsMessagingSetReceiveModeCancel")},
		{23528, _L8("EMobileSmsMessagingStoreSmspListCancel")},
		{23529, _L8("EMobilePhoneSetSmartCardApplicationStatusCancel")},
		{23530, _L8("EMobilePhoneUpdateScFileCancel")},
		{23531, _L8("EMobilePhoneAppendAPNNameCancel")},
		{23532, _L8("EMobilePhoneDeleteAPNNameCancel")},
		{23533, _L8("EMobilePhoneSetGbaBootstrapParamsCancel")},
		{23534, _L8("EMobilePhoneSetWlanDataCancel")},
		{23535, _L8("EMobilePhoneStorePreferredWlanSIDListCancel")},
		{24000, _L8("EMobileBroadcastMessagingGetFilterSetting")},
		{24001, _L8("EMobileBroadcastMessagingGetIdListPhase1")},
		{24002, _L8("EMobileBroadcastMessagingGetIdListPhase2")},
		{24003, _L8("EMobileBroadcastMessagingGetLanguageFilter")},
		{24004, _L8("EMobileBroadcastMessagingNotifyFilterSettingChange")},
		{24005, _L8("EMobileBroadcastMessagingNotifyLanguageFilterChange")},
		{24006, _L8("EMobileCallGetMobileCallInfo")},
		{24007, _L8("EMobileCallNotifyRemotePartyInfoChange")},
		{24008, _L8("EMobilePhoneBookStoreRead")},
		{24009, _L8("EMobilePhoneGetAirTimeDuration")},
		{24010, _L8("EMobilePhoneGetCostInfo")},
		{24011, _L8("EMobilePhoneGetCurrentNetworkNoLocation")},
		{24012, _L8("EMobilePhoneGetMailboxNumbers")},
		{24013, _L8("EMobilePhoneNotifyAirTimeDurationChange")},
		{24014, _L8("EMobilePhoneNotifyCostInfoChange")},
		{24015, _L8("EMobilePhoneNotifyCurrentNetworkNoLocationChange")},
		{24016, _L8("EMobilePhoneNotifyMailboxNumbersChange")},
		{24017, _L8("EMobilePhoneStoreGetInfo")},
		{24018, _L8("EMobilePhoneStoreNotifyStoreEvent")},
		{24019, _L8("EMobilePhoneStoreRead")},
		{24501, _L8("EMobileBroadcastMessagingGetIdListCancel")},
		{24503, _L8("EMobileBroadcastMessagingGetLanguageFilterCancel")},
		{24504, _L8("EMobileBroadcastMessagingNotifyFilterSettingChangeCancel")},
		{24505, _L8("EMobileBroadcastMessagingNotifyLanguageFilterChangeCancel")},
		{24506, _L8("EMobileCallGetMobileCallInfoCancel")},
		{24507, _L8("EMobileCallNotifyRemotePartyInfoChangeCancel")},
		{24508, _L8("EMobilePhoneBookStoreReadCancel")},
		{24510, _L8("EMobilePhoneGetCostInfoCancel")},
		{24511, _L8("EMobilePhoneGetCurrentNetworkNoLocationCancel")},
		{24512, _L8("EMobilePhoneGetMailboxNumbersCancel")},
		{24513, _L8("EMobilePhoneNotifyAirTimeDurationChangeCancel")},
		{24514, _L8("EMobilePhoneNotifyCostInfoChangeCancel")},
		{24515, _L8("EMobilePhoneNotifyCurrentNetworkNoLocationChangeCancel")},
		{24516, _L8("EMobilePhoneNotifyMailboxNumbersChangeCancel")},
		{24517, _L8("EMobilePhoneStoreGetInfoCancel")},
		{24518, _L8("EMobilePhoneStoreNotifyStoreEventCancel")},
		{24519, _L8("EMobilePhoneStoreReadCancel")},
		{25000, _L8("EMobileBroadcastMessagingSetFilterSetting")},
		{25001, _L8("EMobileBroadcastMessagingSetLanguageFilter")},
		{25002, _L8("EMobileBroadcastMessagingStoreIdList")},
		{25003, _L8("EMobileONStoreStoreAll")},
		{25004, _L8("EMobilePhoneBookStoreWrite")},
		{25005, _L8("EMobilePhoneStoreDelete")},
		{25006, _L8("EMobilePhoneStoreDeleteAll")},
		{25007, _L8("EMobilePhoneStoreWrite")},
		{25500, _L8("EMobileBroadcastMessagingSetFilterSettingCancel")},
		{25501, _L8("EMobileBroadcastMessagingSetLanguageFilterCancel")},
		{25502, _L8("EMobileBroadcastMessagingStoreIdListCancel")},
		{25503, _L8("EMobileONStoreStoreAllCancel")},
		{25504, _L8("EMobilePhoneBookStoreWriteCancel")},
		{25506, _L8("EMobilePhoneStoreDeleteAllCancel")},
		{25505, _L8("EMobilePhoneStoreDeleteCancel")},
		{25507, _L8("EMobilePhoneStoreWriteCancel")},
		{26000, _L8("EMobilePhoneGetCurrentNetwork")},
		{26001, _L8("EMobilePhoneNotifyCurrentNetworkChange")},
		{26002, _L8("EMobilePhoneGetCellInfo")},
		{26003, _L8("EMobilePhoneNotifyCellInfoChange")},		
		{26500, _L8("EMobilePhoneGetCurrentNetworkCancel")},
		{26501, _L8("EMobilePhoneNotifyCurrentNetworkChangeCancel")},
		{26502, _L8("EMobilePhoneGetCellInfoCancel")},
		{26503, _L8("EMobilePhoneNotifyCellInfoChangeCancel")},				
		{27000, _L8("EMobileCallDialEmergencyCall")},
		{27001, _L8("EMobileCallDialNoFdnCheck")},
		{27002, _L8("EMobileSmsMessagingAckSmsStored")},
		{27003, _L8("EMobileSmsMessagingNackSmsStored")},
		{27004, _L8("EMobileSmsMessagingResumeSmsReception")},
		{27005, _L8("EMobileSmsMessagingSendMessageNoFdnCheck")},
		{27006, _L8("EMobileUssdMessagingSendRelease")},
		{27500, _L8("EMobileCallDialEmergencyCallCancel")},
		{27501, _L8("EMobileCallDialNoFdnCheckCancel")},
		{27502, _L8("EMobileSmsMessagingAckSmsStoredCancel")},
		{27503, _L8("EMobileSmsMessagingNackSmsStoredCancel")},
		{27504, _L8("EMobileSmsMessagingResumeSmsReceptionCancel")},
		{27505, _L8("EMobileSmsMessagingSendMessageNoFdnCheckCancel")},
		{27506, _L8("EMobileUssdMessagingSendReleaseCancel")},
		{28000, _L8("EMobilePhoneSendNetworkServiceRequestNoFdnCheck")},
		{28001, _L8("EMobileUssdMessagingSendMessage")},
		{28002, _L8("EMobileUssdMessagingSendMessageNoFdnCheck")},
		{28500, _L8("EMobilePhoneSendNetworkServiceRequestNoFdnCheckCancel")},
		{28501, _L8("EMobileUssdMessagingSendMessageCancel")},
		{28502, _L8("EMobileUssdMessagingSendMessageNoFdnCheckCancel")},
		{29000, _L8("EMobileCallGetMobileDataCallRLPRange")},
		{29001, _L8("EMobilePhoneGetDefaultPrivacy")},
		{29002, _L8("EMobilePhoneNotifyDefaultPrivacyChange")},
		{29003, _L8("EMobileUssdMessagingReceiveMessage")},
		{29004, _L8("EMobileSmartCardEapInitialiseEapMethod")},
		{29500, _L8("EMobileCallGetMobileDataCallRLPRangeCancel")},
		{29502, _L8("EMobilePhoneNotifyDefaultPrivacyChangeCancel")},
		{29503, _L8("EMobileUssdMessagingReceiveMessageCancel")},
		{29504, _L8("EMobileSmartCardEapInitialiseEapMethodCancel")},
		{30000, _L8("EMobilePhoneMMInitialise")},
		{30001, _L8("EMobilePhoneSetDefaultPrivacy")},
		{30002, _L8("EMobilePhoneSetPersonalisationStatus")},
		{30500, _L8("EMobilePhoneMMInitialiseCancel")},
		{30501, _L8("EMobilePhoneSetDefaultPrivacyCancel")},
		{30502, _L8("EMobilePhoneSetPersonalisationStatusCancel")},
		{31000, _L8("EMobilePhoneGetBarringStatusPhase1")},
		{31001, _L8("EMobilePhoneGetBarringStatusPhase2")},
		{31002, _L8("EMobilePhoneGetCallForwardingStatusPhase1")},
		{31003, _L8("EMobilePhoneGetCallForwardingStatusPhase2")},
		{31004, _L8("EMobilePhoneGetCompletionRequestsPhase1")},
		{31005, _L8("EMobilePhoneGetCompletionRequestsPhase2")},
		{31006, _L8("EMobilePhoneGetDetectedNetworksPhase1")},
		{31007, _L8("EMobilePhoneGetDetectedNetworksPhase2")},
		{31008, _L8("EMobilePhoneGetDetectedNetworksV2Phase1")},
		{31009, _L8("EMobilePhoneGetDetectedNetworksV2Phase2")},
		{31010, _L8("EMobilePhoneGetWaitingStatusPhase1")},
		{31011, _L8("EMobilePhoneGetWaitingStatusPhase2")},
		{31012, _L8("EMobilePhoneGetDetectedNetworksV5Phase1")},
		{31013, _L8("EMobilePhoneGetDetectedNetworksV5Phase2")},
		{31500, _L8("EMobilePhoneGetBarringStatusCancel")},
		{31502, _L8("EMobilePhoneGetCallForwardingStatusCancel")},
		{31504, _L8("EMobilePhoneGetCompletionRequestsCancel")},
		{31506, _L8("EMobilePhoneGetDetectedNetworksCancel")},
		{31508, _L8("EMobilePhoneGetDetectedNetworksV2Cancel")},
		{31510, _L8("EMobilePhoneGetWaitingStatusCancel")},
		{31511, _L8("EMobilePhoneGetDetectedNetworksV5Cancel")},
		{32000, _L8("EMobileCallReceiveUUI")},
		{32001, _L8("EMobileSmsMessagingReceiveMessage")},
		{32500, _L8("EMobileCallReceiveUUICancel")},
		{32501, _L8("EMobileSmsMessagingReceiveMessageCancel")},
		{33000, _L8("EMobileCallActivateUUS")},
		{33001, _L8("EMobilePhoneDeactivateCCBS")},
		{33002, _L8("EMobilePhoneSelectNetwork")},
		{33003, _L8("EMobilePhoneSendNetworkServiceRequest")},
		{33004, _L8("EMobilePhoneSetCallBarringPassword")},
		{33005, _L8("EMobilePhoneSetCallBarringStatus")},
		{33006, _L8("EMobilePhoneSetCallForwardingStatus")},
		{33007, _L8("EMobilePhoneSetCallWaitingStatus")},
		{33008, _L8("EMobilePhoneSetSSPassword")},
		{33009, _L8("EMobilePhoneSetUUSSetting")},
		{33010, _L8("EMobilePhoneSetAPNControlListServiceStatus")},
		{33500, _L8("EMobileCallActivateUUSCancel")},
		{33501, _L8("EMobilePhoneDeactivateCCBSCancel")},
		{33502, _L8("EMobilePhoneSelectNetworkCancel")},
		{33503, _L8("EMobilePhoneSendNetworkServiceRequestCancel")},
		{33504, _L8("EMobilePhoneSetCallBarringPasswordCancel")},
		{33505, _L8("EMobilePhoneSetCallBarringStatusCancel")},
		{33506, _L8("EMobilePhoneSetCallForwardingStatusCancel")},
		{33507, _L8("EMobilePhoneSetCallWaitingStatusCancel")},
		{33508, _L8("EMobilePhoneSetSSPasswordCancel")},
		{33509, _L8("EMobilePhoneSetUUSSettingCancel")},
		{33510, _L8("EMobilePhoneSetAPNControlListServiceStatusCancel")},
		{34000, _L8("EMobileCallAnswerWithUUI")},
		{34001, _L8("EMobileCallHangupWithUUI")},
		{34002, _L8("EMobileCallSendUUI")},
		{34003, _L8("EMobileSmsMessagingSendMessage")},
		{34500, _L8("EMobileCallAnswerWithUUICancel")},
		{34501, _L8("EMobileCallHangupWithUUICancel")},
		{34502, _L8("EMobileCallSendUUICancel")},
		{34503, _L8("EMobileSmsMessagingSendMessageCancel")},
		{35000, _L8("EMobileLocationServicesNotifyMtlr")},
		{35001, _L8("EMobileLocationServicesNotifyMeasurementControl")},
		{35002, _L8("EMobileLocationServicesSendMolr")},
		{35003, _L8("EMobileLocationServicesSendMtlrResponse")},
		{35004, _L8("EMobileLocationServicesSendMtlrError")},
		{35005, _L8("EMobileLocationServicesRejectMtlr")},
		{35006, _L8("EMobileLocationServicesSendMeasurementReport")},
		{35007, _L8("EMobileLocationServicesSendMeasurementControlFailure")},
		{35008, _L8("EMobileLocationServicesSetLcsDomain")},
		{35009, _L8("EMobileLocationServicesNotifyResetUePositioningInformation")},
		{35500, _L8("EMobileLocationServicesNotifyMtlrCancel")},
		{35501, _L8("EMobileLocationServicesNotifyMeasurementControlCancel")},
		{35502, _L8("EMobileLocationServicesSendMolrCancel")},
		{35503, _L8("EMobileLocationServicesSendMtlrResponseCancel")},
		{35504, _L8("EMobileLocationServicesSendMtlrErrorCancel")},
		{35505, _L8("EMobileLocationServicesRejectMtlrCancel")},
		{35506, _L8("EMobileLocationServicesSendMeasurementReportCancel")},
		{35507, _L8("EMobileLocationServicesSendMeasurementControlFailureCancel")},
		{35509, _L8("EMobileLocationServicesNotifyResetUePositioningInformationCancel")},
		
		// ETelPckt
		{40000, _L8("EPacketContextGetConnectionSpeed")},
		{40001, _L8("EPacketContextGetLastErrorCause")},
		{40002, _L8("EPacketContextGetProfileName")},
		{40003, _L8("EPacketContextGetStatus")},
		{40004, _L8("EPacketContextNotifyConnectionSpeedChange")},
		{40005, _L8("EPacketContextNotifyStatusChange")},
		{40006, _L8("EPacketEnumerateContexts")},
		{40007, _L8("EPacketEnumerateNifs")},
		{40008, _L8("EPacketGetAttachMode")},
		{40009, _L8("EPacketGetContextInfo")},
		{40010, _L8("EPacketGetCurrentReleaseMode")},
		{40011, _L8("EPacketGetDynamicCaps")},
		{40012, _L8("EPacketGetMSClass")},
		{40013, _L8("EPacketGetNtwkRegStatus")},
		{40014, _L8("EPacketGetPrefBearer")},
		{40015, _L8("EPacketGetStaticCaps")},
		{40016, _L8("EPacketGetStatus")},
		{40017, _L8("EPacketNotifyAttachModeChange")},
		{40018, _L8("EPacketNotifyChangeOfNtwkRegStatus")},
		{40019, _L8("EPacketNotifyContextActivationRequested")},
		{40020, _L8("EPacketNotifyContextAdded")},
		{40021, _L8("EPacketNotifyDynamicCapsChange")},
		{40022, _L8("EPacketNotifyMSClassChange")},
		{40023, _L8("EPacketNotifyReleaseModeChange")},
		{40024, _L8("EPacketNotifyStatusChange")},
		{40025, _L8("EPacketPrepareOpenSecondary")},
		{40026, _L8("EPacketQoSGetProfileCaps")},
		{40027, _L8("EPacketNotifyMbmsServiceAvailabilityChange")},
#ifdef SYMBIAN_ADAPTIVE_TCP_RECEIVE_WINDOW
		{40028, _L8("EPacketContextGetConnectionInfo")},
		{40029, _L8("EPacketContextNotifyConnectionInfoChange")},		
#endif // SYMBIAN_ADAPTIVE_TCP_RECEIVE_WINDOW
		{40500, _L8("EPacketContextGetConnectionSpeedCancel")},
		{40504, _L8("EPacketContextNotifyConnectionSpeedChangeCancel")}, 
		{40505, _L8("EPacketContextNotifyStatusChangeCancel")},
		{40506, _L8("EPacketEnumerateContextsCancel")},
		{40507, _L8("EPacketEnumerateNifsCancel")}, 
		{40508, _L8("EPacketGetAttachModeCancel")}, 
		{40509, _L8("EPacketGetContextInfoCancel")},
		{40510, _L8("EPacketGetCurrentReleaseModeCancel")},
		{40512, _L8("EPacketGetMSClassCancel")},
		{40513, _L8("EPacketGetNtwkRegStatusCancel")},
		{40514, _L8("EPacketGetPrefBearerCancel")},
		{40517, _L8("EPacketNotifyAttachModeChangeCancel")},
		{40518, _L8("EPacketNotifyChangeOfNtwkRegStatusCancel")},
		{40519, _L8("EPacketNotifyContextActivationRequestedCancel")},
		{40520, _L8("EPacketNotifyContextAddedCancel")},
		{40521, _L8("EPacketNotifyDynamicCapsChangeCancel")},
		{40522, _L8("EPacketNotifyMSClassChangeCancel")},
		{40523, _L8("EPacketNotifyReleaseModeChangeCancel")},
		{40524, _L8("EPacketNotifyStatusChangeCancel")},
		{40526, _L8("EPacketQoSGetProfileCapsCancel")},
		{40527, _L8("EPacketNotifyMbmsServiceAvailabilityChangeCancel")},
#ifdef SYMBIAN_ADAPTIVE_TCP_RECEIVE_WINDOW
		{40528, _L8("EPacketContextGetConnectionInfoCancel")},
		{40529, _L8("EPacketContextNotifyConnectionInfoChangeCancel")},		
#endif // SYMBIAN_ADAPTIVE_TCP_RECEIVE_WINDOW
		{41000, _L8("EPacketAttach")},
		{41001, _L8("EPacketContextActivate")},
		{41002, _L8("EPacketContextCreateNewTFT")},
		{41003, _L8("EPacketContextDeactivate")},
		{41004, _L8("EPacketContextDeleteTFT")},
		{41005, _L8("EPacketContextInitialiseContext")},
		{41006, _L8("EPacketContextLoanCommPort")},
		{41007, _L8("EPacketContextModifyActiveContext")},
		{41008, _L8("EPacketContextRecoverCommPort")},
		{41009, _L8("EPacketDeactivateNIF")},
		{41010, _L8("EPacketDetach")},
		{41011, _L8("EPacketRejectActivationRequest")},
		{41500, _L8("EPacketAttachCancel")},
		{41501, _L8("EPacketContextActivateCancel")}, 
		{41502, _L8("EPacketContextCreateNewTFTCancel")},
		{41503, _L8("EPacketContextDeactivateCancel")},
		{41504, _L8("EPacketContextDeleteTFTCancel")}, 
		{41505, _L8("EPacketContextInitialiseContextCancel")}, 
		{41506, _L8("EPacketContextLoanCommPortCancel")},
		{41507, _L8("EPacketContextModifyActiveContextCancel")},
		{41508, _L8("EPacketContextRecoverCommPortCancel")},
		{41509, _L8("EPacketDeactivateNIFCancel")},
		{41510, _L8("EPacketDetachCancel")},
		{41511, _L8("EPacketRejectActivationRequestCancel")},
		{42000, _L8("EPacketContextEnumeratePacketFilters")},
		{42001, _L8("EPacketContextGetConfig")},
		{42002, _L8("EPacketContextGetDNSInfo")},
		{42003, _L8("EPacketContextNotifyConfigChanged")},
		{42004, _L8("EPacketEnumerateContextsInNif")},
		{42005, _L8("EPacketGetContextNameInNif")},
		{42006, _L8("EPacketGetDefaultContextParams")},
		{42007, _L8("EPacketGetNifInfo")},
		{42008, _L8("EPacketQoSGetProfileParams")},
		{42009, _L8("EPacketQoSNotifyProfileChanged")},
		{42010, _L8("EPacketNotifyMbmsNetworkServiceStatusChange")},
		{42011, _L8("EPacketGetMbmsMonitoredServicesPhase1")},
		{42012, _L8("EPacketGetMbmsMonitoredServicesPhase2")},
		{42013, _L8("EPacketEnumerateMbmsMonitorServiceList")},
		{42014, _L8("EPacketEnumerateMbmsActiveServiceList")},
		{42015, _L8("EPacketGetMbmsSessionListPhase1")},
		{42016, _L8("EPacketGetMbmsSessionListPhase2")},
		{42500, _L8("EPacketContextEnumeratePacketFiltersCancel")},
		{42501, _L8("EPacketContextGetConfigCancel")},
		{42502, _L8("EPacketContextGetDNSInfoCancel")},
		{42503, _L8("EPacketContextNotifyConfigChangedCancel")},
		{42504, _L8("EPacketEnumerateContextsInNifCancel")},
		{42505, _L8("EPacketGetContextNameInNifCancel")},
		{42506, _L8("EPacketGetDefaultContextParamsCancel")},
		{42507, _L8("EPacketGetNifInfoCancel")},
		{42508, _L8("EPacketQoSGetProfileParamsCancel")},
		{42509, _L8("EPacketQoSNotifyProfileChangedCancel")},
		{42510, _L8("EPacketNotifyMbmsNetworkServiceStatusChangeCancel")},
		{42511, _L8("EPacketGetMbmsMonitoredServicesCancel")},
		{42513, _L8("EPacketEnumerateMbmsMonitorServiceListCancel")},
		{42514, _L8("EPacketEnumerateMbmsActiveServiceListCancel")},
		{42515, _L8("EPacketGetMbmsSessionListCancel")},
		{43000, _L8("EPacketContextDelete")},
		{43001, _L8("EPacketContextSetConfig")},
		{43002, _L8("EPacketSetAttachMode")},
		{43003, _L8("EPacketSetDefaultContextParams")},
		{43004, _L8("EPacketContextUpdateMbmsSessionList")},
		{43005, _L8("EPacketUpdateMbmsMonitorServiceList")},
		{43500, _L8("EPacketContextDeleteCancel")},
		{43501, _L8("EPacketContextSetConfigCancel")},
		{43502, _L8("EPacketSetAttachModeCancel")},
		{43503, _L8("EPacketSetDefaultContextParamsCancel")},
		{43504, _L8("EPacketContextUpdateMbmsSessionListCancel")},
		{43505, _L8("EPacketUpdateMbmsMonitorServiceListCancel")},
		{44000, _L8("EPacketContextGetDataVolumeTransferred")},
		{44001, _L8("EPacketContextNotifyDataTransferred")},		
		{44500, _L8("EPacketContextGetDataVolumeTransferredCancel")},
		{44501, _L8("EPacketContextNotifyDataTransferredCancel")},
	  	{45000, _L8("EPacketContextGetPacketFilterInfo")},
		{45001, _L8("EPacketGetMbmsNetworkServiceStatus")},
	  	{45500, _L8("EPacketContextGetPacketFilterInfoCancel")},
		{45501, _L8("EPacketGetMbmsNetworkServiceStatusCancel")},
		{46000, _L8("EPacketContextAddPacketFilter")},
		{46001, _L8("EPacketContextRemovePacketFilter")},
		{46002, _L8("EPacketQoSSetProfileParams")},
		{46003, _L8("EPacketSetMSClass")},
		{46004, _L8("EPacketSetPrefBearer")},
		{46005, _L8("EPacketAddMediaAuthorization")},
		{46006, _L8("EPacketRemoveMediaAuthorization")},		
		{46500, _L8("EPacketContextAddPacketFilterCancel")},
		{46501, _L8("EPacketContextRemovePacketFilterCancel")},
		{46502, _L8("EPacketQoSSetProfileParamsCancel")},
		{46503, _L8("EPacketSetMSClassCancel")},
		{46504, _L8("EPacketSetPrefBearerCancel")},
		{46505, _L8("EPacketAddMediaAuthorizationCancel")},
		{46506, _L8("EPacketRemoveMediaAuthorizationCancel")},
		
		// ETelSat
		{60000, _L8("ESatGetClut")},
		{60001, _L8("ESatGetIcon")},
		{60002, _L8("ESatGetImageInstance")},
		{60003, _L8("ESatGetMeSideSatProfile")},
		{60004, _L8("ESatNotifyCloseChannelPCmd")},
		{60005, _L8("ESatNotifyGetChannelStatusPCmd")},
		{60006, _L8("ESatNotifyGetInkeyPCmd")},
		{60007, _L8("ESatNotifyGetInputPCmd")},
		{60008, _L8("ESatNotifyGetReaderStatusPCmd")},
		{60009, _L8("ESatNotifyLanguageNotificationPCmd")},
		{60010, _L8("ESatNotifyPlayTonePCmd")},
		{60011, _L8("ESatNotifyPollingIntervalPCmd")},
		{60012, _L8("ESatNotifyPollingOffPCmd")},
		{60013, _L8("ESatNotifyPowerOffCardPCmd")},
		{60014, _L8("ESatNotifyPowerOnCardPCmd")},
		{60015, _L8("ESatNotifyProactiveSimSessionEnd")},
		{60016, _L8("ESatNotifyProactiveSimSessionStart")},
		{60017, _L8("ESatNotifyReceiveDataPCmd")},
		{60018, _L8("ESatNotifyRefreshPCmd")},
		{60019, _L8("ESatNotifyRefreshRequired")},
		{60020, _L8("ESatNotifySelectItemPCmd")},
		{60021, _L8("ESatNotifySetUpEventListPCmd")},
		{60022, _L8("ESatNotifySetUpMenuPCmd")},
		{60023, _L8("ESatNotifyTimerExpiration")},
		{60024, _L8("ESatNotifyTimerMgmtPCmd")},
		{60025, _L8("ESatNotifyTsyStateUpdated")},
		{60026, _L8("ESatNotifyRefreshRequiredParam")},	
		{60027, _L8("ESatNotifyGetFramesStatusPCmd")},	
		{60500, _L8("ESatGetClutCancel")},
		{60501, _L8("ESatGetIconCancel")},
		{60502, _L8("ESatGetImageInstanceCancel")},
		{60503, _L8("ESatGetMeSideSatProfileCancel")},
		{60504, _L8("ESatNotifyCloseChannelPCmdCancel")},
		{60505, _L8("ESatNotifyGetChannelStatusPCmdCancel")},
		{60506, _L8("ESatNotifyGetInkeyPCmdCancel")},
		{60507, _L8("ESatNotifyGetInputPCmdCancel")},
		{60508, _L8("ESatNotifyGetReaderStatusPCmdCancel")},
		{60509, _L8("ESatNotifyLanguageNotificationPCmdCancel")},
		{60510, _L8("ESatNotifyPlayTonePCmdCancel")},
		{60511, _L8("ESatNotifyPollingIntervalPCmdCancel")},
		{60512, _L8("ESatNotifyPollingOffPCmdCancel")},
		{60513, _L8("ESatNotifyPowerOffCardPCmdCancel")},
		{60514, _L8("ESatNotifyPowerOnCardPCmdCancel")},
		{60515, _L8("ESatNotifyProactiveSimSessionEndCancel")},
		{60516, _L8("ESatNotifyProactiveSimSessionStartCancel")},
		{60517, _L8("ESatNotifyReceiveDataPCmdCancel")},
		{60518, _L8("ESatNotifyRefreshPCmdCancel")},
		{60519, _L8("ESatNotifyRefreshRequiredCancel")},
		{60520, _L8("ESatNotifySelectItemPCmdCancel")},
		{60521, _L8("ESatNotifySetUpEventListPCmdCancel")},
		{60522, _L8("ESatNotifySetUpMenuPCmdCancel")},
		{60523, _L8("ESatNotifyTimerExpirationCancel")},
		{60524, _L8("ESatNotifyTimerMgmtPCmdCancel")},
		{60525, _L8("ESatNotifyTsyStateUpdatedCancel")},
		{60526, _L8("ESatNotifyRefreshRequiredParamCancel")},
		{60527, _L8("ESatNotifyGetFramesStatusPCmdCancel")},
		{61000, _L8("ESatGetProvisioningRefFile")},
		{61001, _L8("ESatNotifyDeclareServicePCmd")},
		{61002, _L8("ESatNotifyDisplayTextPCmd")},
		{61003, _L8("ESatNotifyGetServiceInfoPCmd")},
		{61004, _L8("ESatNotifyLaunchBrowserPCmd")},
		{61005, _L8("ESatNotifyLocalInfoPCmd")},
		{61006, _L8("ESatNotifyOpenChannelPCmd")},
		{61007, _L8("ESatNotifyPerformCardApduPCmd")},
		{61008, _L8("ESatNotifyRunAtCommandPCmd")},
		{61009, _L8("ESatNotifySendDataPCmd")},
		{61010, _L8("ESatNotifySendDtmfPCmd")},
		{61011, _L8("ESatNotifySendSmPCmd")},
		{61012, _L8("ESatNotifySendSsPCmd")},
		{61013, _L8("ESatNotifySendUssdPCmd")},
		{61014, _L8("ESatNotifyServiceSearchPCmd")},
		{61015, _L8("ESatNotifySetUpCallPCmd")},
		{61016, _L8("ESatNotifySetUpIdleModeTextPCmd")},
    	{61017, _L8("ESatGetOpenChannelPCmd")},  
    	{61018, _L8("ESatNotifyRetrieveMultimediaMsgPCmd")}, 
    	{61019, _L8("ESatNotifySubmitMultimediaMsgPCmd")},
    	{61020, _L8("ESatNotifyDisplayMultimediaMsgPCmd")},
    	{61021, _L8("ESatNotifySetFramesPCmd")},
    	{61500, _L8("ESatGetProvisioningRefFileCancel")},
		{61501, _L8("ESatNotifyDeclareServicePCmdCancel")},
		{61502, _L8("ESatNotifyDisplayTextPCmdCancel")},
		{61503, _L8("ESatNotifyGetServiceInfoPCmdCancel")},
		{61504, _L8("ESatNotifyLaunchBrowserPCmdCancel")},
		{61505, _L8("ESatNotifyLocalInfoPCmdCancel")},
		{61506, _L8("ESatNotifyOpenChannelPCmdCancel")},
		{61507, _L8("ESatNotifyPerformCardApduPCmdCancel")},
		{61508, _L8("ESatNotifyRunAtCommandPCmdCancel")},
		{61509, _L8("ESatNotifySendDataPCmdCancel")},
		{61510, _L8("ESatNotifySendDtmfPCmdCancel")},
		{61511, _L8("ESatNotifySendSmPCmdCancel")},
		{61512, _L8("ESatNotifySendSsPCmdCancel")},
		{61513, _L8("ESatNotifySendUssdPCmdCancel")},
		{61514, _L8("ESatNotifyServiceSearchPCmdCancel")},
		{61515, _L8("ESatNotifySetUpCallPCmdCancel")},
		{61516, _L8("ESatNotifySetUpIdleModeTextPCmdCancel")},
	    {61517, _L8("ESatGetOpenChannelPCmdCancel")}, 
	    {61518, _L8("ESatNotifyRetrieveMultimediaMsgPCmdCancel")}, 
	    {61519, _L8("ESatNotifySubmitMultimediaMsgPCmdCancel")}, 
	    {61520, _L8("ESatNotifyDisplayMultimediaMsgPCmdCancel")}, 
	    {61521, _L8("ESatNotifySetFramesPCmdCancel")},
	    {62000, _L8("ESatRefreshAllowed")},  
	    {62500, _L8("ESatRefreshAllowedCancel")},     	
	    {63000, _L8("ESatTerminalRsp")},  
	    {63001, _L8("ESatUsatClientReadyIndication")},   
	    {63500, _L8("ESatTerminalRspCancel")},  
	   	{64000, _L8("ESatMenuSelection")},
		{64001, _L8("ESatNotifyCallControlRequest")},
		{64002, _L8("ESatNotifyCbDownload")},
		{64003, _L8("ESatNotifyMoSmControlRequest")},
		{64004, _L8("ESatNotifySmsPpDownload")}, 
		{64005, _L8("ESatNotifyUssdDataDownload")},
		{64006, _L8("ESatNotifyMmsNotificationDownload")},
    	{64500, _L8("ESatMenuSelectionCancel")},
		{64501, _L8("ESatNotifyCallControlRequestCancel")},
		{64502, _L8("ESatNotifyCbDownloadCancel")},
		{64503, _L8("ESatNotifyMoSmControlRequestCancel")},
		{64504, _L8("ESatNotifySmsPpDownloadCancel")},
		{64505, _L8("ESatNotifyUssdDataDownloadCancel")},
		{64506, _L8("ESatNotifyMmsNotificationDownloadCancel")},
  		{65000, _L8("ESatClientSatProfileIndication")},
		{65001, _L8("ESatEventDownload")},
		{65002, _L8("ESatMmsNotificationDownload")},
		{65003, _L8("ESatMmsTransferStatus")},
  		{65004, _L8("ESatUssdDataDownload")},
  		{65501, _L8("ESatEventDownloadCancel")},
  		{65502, _L8("ESatMmsNotificationDownloadCancel")},
  		{65503, _L8("ESatMmsTransferStatusCancel")},
  		{65504, _L8("ESatUssdDataDownloadCancel")},
 	  	{66000, _L8("ESatSendMessageNoLogging")},
  		{66500, _L8("ESatSendMessageNoLoggingCancel")}
		
		
	};
	

#endif
