// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Multimode ETel API v1.0
// Header file contains extended error code constants for Multimode network & phone errors
// 
//

/**
 @file
 @publishedPartner
 @released
*/

#ifndef __ETELMMERR_H__
#define __ETELMMERR_H__
/**
Base offset used for error codes that will be generated by TSY. 
*/
const TInt KErrEtelMMBase = -3200;

/**
Multimode specific errors that will be generated by TSY
*/

/** Client has requested a mode-specific API service and the phone is currently 
in the wrong mode for this request. */
const TInt KErrMMEtelWrongMode = KErrEtelMMBase-1;
/** Error code to cater for requests that fail because the mode changes mid-way 
during servicing that request - e.g.. client tries to send a CDMA SMS but 
by the time the TSY goes to service that request the mode has changed to GSM. */
const TInt KErrMMEtelFailedDueToModeChange = KErrEtelMMBase-2;
/** Remote user (or network) has terminated an ongoing call. */
const TInt KErrMMEtelRemoteEndTermination = KErrEtelMMBase-3;
/** Client requested a message format that is not supported by TSY and/or phone. */
const TInt KErrMMEtelSmsFormatNotSupported = KErrEtelMMBase-4;
/** Client requests a service whose feature code has not been programmed e.g. Call
Forwarding. */
const TInt KErrMMEtelFeatureCodeNotSet = KErrEtelMMBase-5;
/** Network has failed to respond to an MS initiated request e.g. "flash info"
sent by MS - but network did not reply with "flash info ack". */
const TInt KErrMMEtelNetworkNotResponding = KErrEtelMMBase-6;
/** Client requests a call to a destination that is forbidden - because FDN, BDN
or other call barring/screening services forbid the call. */
const TInt KErrMMEtelCallForbidden = KErrEtelMMBase-7;
/** The maximum number of entries in a store has been reached. */
const TInt KErrMMEtelMaxReached = KErrEtelMMBase-8;
/** Remote user (or network) has terminated an ongoing call. */
const TInt KErrMMEtelCallTerminated = KErrEtelMMBase-9;
/** The client requested a message format that is not supported by TSY and/or phone. */
const TInt KErrMMEtelFormatNotSupported = KErrEtelMMBase-10;
/** The phonebook entry is hidden. This is a USIM phonebook specific error. */
const TInt KErrMMEtelHiddenEntry = KErrEtelMMBase-11;
/** The request to answer a multimedia call has failed because the network can
now only support voice. */
const TInt KErrMMEtelFallbacktoVoice = KErrEtelMMBase-12;
//
/** Autn derived MAC does not match locally calculated MAC*/
const TInt KErrMMEtelMacVerificationFailed=KErrEtelMMBase-13;

/** Autn derived SQN value is not in the expected range*/
const TInt KErrMMEtelSqnVerificationFailed=KErrEtelMMBase-14;

/** Authenticate command failed*/
const TInt KErrMMEtelAuthenticateFailed=KErrEtelMMBase-15;


//Error codes for use with Smart card application APIs.  They are based on error codes defined in TS 102.221 section 10.2.1.

/** Application cannot be activated as maximum number of applications already active.  An application must be terminated before further applications can be activated.*/
const TInt KErrMMEtelScMaxApplicationsActive = KErrEtelMMBase-16;	
/** No information given, the state of the non-volatile memory is unchanged.*/
const TInt KErrMMEtelScNoInfoNonVolatileMemoryUnchanged = KErrEtelMMBase-17;
/** No information given, the state of the non-volatile memory is changed.*/
const TInt KErrMMEtelScNoInfoNonVolatileMemoryChanged = KErrEtelMMBase-18;	
/** Part of the returned data may be corrupt.*/
const TInt KErrMMEtelScReturnedDataCorrupt = KErrEtelMMBase-19;	
/** End of file reached before reading requested number of bytes or records have been read. */
const TInt KErrMMEtelScEofReached = KErrEtelMMBase-20;	
/** Selected file is invalidated.*/
const TInt KErrMMEtelScFileInvalidated = KErrEtelMMBase-21;	
/** The smart card had a memory problem when executing the command. */
const TInt KErrMMEtelScNoMemory = KErrEtelMMBase-22;	
/** Wrong length */
const TInt KErrMMEtelScWrongLength = KErrEtelMMBase-23;	
/** Technical problem, no precise diagnosis */
const TInt KErrMMEtelScGeneral = KErrEtelMMBase-24;	
/** Command incompatible with file structure */
const TInt KErrMMEtelScIncompatibleFileStructure = KErrEtelMMBase-25;	
/** Referenced data invalidated */
const TInt KErrMMEtelScReferencedDataInvalidated = KErrEtelMMBase-26;	
/** Function not supported */
const TInt KErrMMEtelScFunctionNotSupported = KErrEtelMMBase-27;	
/** File not found */
const TInt KErrMMEtelScFileNotFound = KErrEtelMMBase-28;	
/** Record not found */
const TInt KErrMMEtelScRecordNotFound = KErrEtelMMBase-29;	
/** Referenced data not found */
const TInt KErrMMEtelScReferencedDataNotFound = KErrEtelMMBase-30;
/** Application not activate.*/
const TInt KErrMMEtelScApplicationNotActive = KErrEtelMMBase-31;

// Error codes for use with APN control list application APIs.  They are based on error codes defined in 3GPP TS 31.102 V7.4.1

/** The EF_ACL file cannot be found on the USIM. */
const TInt KErrMMEtelAPNNameACLNotFound = KErrEtelMMBase-32;
/** The supplied APN name to append is invalid. */
const TInt KErrMMEtelAPNNameInvalidAPNName  = KErrEtelMMBase-33;
/** The APN entry cannot be added to the list because the APN control list is full or there is no space left for an additional entry. */
const TInt KErrMMEtelAPNNameAPNListFull = KErrEtelMMBase-34;
/** The client has supplied an invalid index of an entry in the APN control list. */
const TInt KErrMMEtelAPNNameInvalidIndex = KErrEtelMMBase-35;
/** If the EF_EST file could not be found on the USIM. */
const TInt KErrMMEtelAPNEnabledServicesTableNotFound = KErrEtelMMBase-36;

// Error codes for use with SAT-based Call Control

/** PDP context activation is blocked by Call Control and there is no text string shown to the user (by the SAT application) */
const TInt KErrMMEtelActivationBlockedByCallControlNoText = KErrEtelMMBase-37;
/** PDP context activation is blocked by Call Control and there is a text string shown to the user (by the SAT application) */
const TInt KErrMMEtelActivationBlockedByCallControlWithText = KErrEtelMMBase-38;

//Error Codes for use with USIM R6 Authentication Data(GBA,MBMS)

/** If sequence number is found to be invalid, this is considered as a synchronisation failure */
const TInt KErrMMEtelAuthVerificationFailure = KErrEtelMMBase-39;

/** If XMAC does not match with the previously computed MAC - applicable to GBA Boostrapping, MSK Update and MTK Generation procedures */
const TInt KErrMMEtelAuthMacInvalid = KErrEtelMMBase-40;

/** Key was not found */
const TInt KErrMMEtelAuthKeyNotFound = KErrEtelMMBase-41;

/** Key is invalid  */
const TInt KErrMMEtelAuthKeyInvalid = KErrEtelMMBase-42;
#endif

