/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.commdb.data;

import com.symbian.commdb.data.DatabaseException;
import com.symbian.commdb.data.Table;
import com.symbian.commdb.data.TableEntry;
import com.symbian.commdb.data.TableTemplate;
import com.symbian.commdb.xml.XMLUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JProgressBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Database {
    private Vector m_tables = new Vector();
    protected String m_schemaDirectory;
    private Vector m_fileNames = new Vector();
    private Vector m_tableTemplateNames;
    private Vector m_tableNames = new Vector();
    private Vector m_enumerationFilenames;
    private String m_commdbType;

    public Database(String string) {
        this.m_tableTemplateNames = new Vector();
        this.m_enumerationFilenames = new Vector();
        this.m_commdbType = new String("Unspecified");
        this.m_schemaDirectory = new String(string);
    }

    public String GetXMLSchemaDirectory() {
        return new String(this.m_schemaDirectory);
    }

    public String GetDatabaseType() {
        return new String(this.m_commdbType);
    }

    public int GetNumberOfTableTemplates() {
        return this.m_tableTemplateNames.size();
    }

    public int GetNumberOfTables() {
        return this.m_tables.size();
    }

    public int GetNumberOfTableEntries() {
        int n = 0;
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Table table = (Table)this.m_tables.elementAt(i);
            n += table.GetNumberOfTableEntries();
        }
        return n;
    }

    public String GetXMLSchemaFilename(int n) {
        return new String((String)this.m_fileNames.elementAt(n));
    }

    public String GetEnumerationFilename(int n) {
        return new String((String)this.m_enumerationFilenames.elementAt(n));
    }

    public String GetTableTemplateName(int n) {
        return new String((String)this.m_tableTemplateNames.elementAt(n));
    }

    public String GetTableName(int n) {
        return new String((String)this.m_tableNames.elementAt(n));
    }

    public Table GetTable(int n) {
        return (Table)this.m_tables.elementAt(n);
    }

    public Table GetTable(String string) {
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Table table = (Table)this.m_tables.elementAt(i);
            if (!table.GetTableName().equals(string)) continue;
            return table;
        }
        return null;
    }

    public String GetXMLSchemaFilename(String string) {
        int n = this.m_tableTemplateNames.indexOf(string);
        if (n == -1) {
            return new String("");
        }
        return this.GetXMLSchemaFilename(n);
    }

    public String GetEnumerationFilename(String string) {
        int n = this.m_tableTemplateNames.indexOf(string);
        if (n == -1) {
            return new String("");
        }
        return this.GetEnumerationFilename(n);
    }

    public String GetTableTemplateName(String string) {
        int n = this.m_fileNames.indexOf(string);
        if (n == -1) {
            return new String("");
        }
        return this.GetTableTemplateName(n);
    }

    public void SetXMLSchemaDirectory(String string) {
        this.m_schemaDirectory = new String(string);
    }

    public boolean AddXMLSchemaFileName(String string, String string2, String string3, String string4) {
        if (string.equals("") || string2.equals("") || string3.equals("") || string4.equals("")) {
            return false;
        }
        this.m_fileNames.add(new String(string));
        this.m_tableTemplateNames.add(new String(string2));
        this.m_tableNames.add(new String(string3));
        this.m_enumerationFilenames.add(new String(string4));
        return true;
    }

    public void BuildTableTemplates(JProgressBar jProgressBar) throws DatabaseException {
        int n = 0;
        int n2 = 2 * this.m_fileNames.size();
        jProgressBar.setMinimum(0);
        jProgressBar.setMaximum(n2);
        jProgressBar.setValue(0);
        jProgressBar.repaint();
        for (int i = 0; i < this.m_fileNames.size(); ++i) {
            TableTemplate tableTemplate = new TableTemplate();
            String string = this.m_schemaDirectory + (String)this.m_fileNames.elementAt(i);
            String string2 = (String)this.m_tableTemplateNames.elementAt(i);
            String string3 = this.m_schemaDirectory + (String)this.m_enumerationFilenames.elementAt(i);
            try {
                tableTemplate.ImportParameters(string, string2);
                jProgressBar.setValue(++n);
                tableTemplate.ImportEnumerations(string3);
                jProgressBar.setValue(++n);
            }
            catch (DatabaseException databaseException) {
                this.m_tables.clear();
                throw databaseException;
            }
            Table table = new Table(tableTemplate);
            table.SetTableName((String)this.m_tableNames.elementAt(i));
            this.m_tables.add(table);
        }
    }

    public void ImportDatabase(String string) throws DatabaseException {
        Vector vector;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DatabaseException("com.symbian.commdb.data.Database.ImportDatabase()", "Creation of an XML DOM parser", parserConfigurationException.getMessage());
        }
        File file = new File(string);
        Document document = null;
        try {
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            throw new DatabaseException("com.symbian.commdb.data.Database.ImportDatabase()", "Parser exception during parsing file " + string, sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new DatabaseException("com.symbian.commdb.data.Database.ImportDatabase()", "I/O exception during parsing file " + string, iOException.getMessage());
        }
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Table table = (Table)this.m_tables.elementAt(i);
            table.RemoveAllTableEntries();
        }
        Vector vector2 = new Vector();
        XMLUtility.VectoriseChildrenNodes(document.getDocumentElement(), vector2);
        block6: for (int i = 0; i < vector2.size(); ++i) {
            vector = (Node)vector2.elementAt(i);
            if (vector.getNodeType() != 1) continue;
            String string2 = vector.getNodeName();
            for (int j = 0; j < this.m_tableTemplateNames.size(); ++j) {
                Node node;
                int n;
                Object object;
                String string3 = (String)this.m_tableTemplateNames.elementAt(j);
                if (!string3.equals(string2)) continue;
                Table table = (Table)this.m_tables.elementAt(j);
                TableEntry tableEntry = table.CreateTableEntry();
                if (vector.hasAttributes()) {
                    object = vector.getAttributes();
                    for (n = 0; n < object.getLength(); ++n) {
                        node = object.item(n);
                        if (!node.getNodeName().equals("operation")) continue;
                        tableEntry.SetOperation(node.getNodeValue());
                        break;
                    }
                }
                object = new Vector();
                XMLUtility.VectoriseChildrenNodes((Node)((Object)vector), (Vector)object);
                block9: for (n = 0; n < ((Vector)object).size(); ++n) {
                    node = (Node)((Vector)object).elementAt(n);
                    if (node.getNodeType() != 1) continue;
                    String string4 = node.getNodeName();
                    int n2 = tableEntry.GetNumberOfParameters();
                    for (int k = 0; k < n2; ++k) {
                        String string5 = tableEntry.GetParameterName(k);
                        if (!string5.equals(string4)) continue;
                        Node node2 = (Node)((Vector)object).elementAt(n + 1);
                        String string6 = node2.getNodeValue();
                        tableEntry.SetParameterValue(k, string6);
                        continue block9;
                    }
                }
                continue block6;
            }
        }
        Vector vector3 = new Vector();
        vector = new Vector();
        boolean bl = this.FindBrokenTableEntryLinks(vector3, vector);
        if (!bl) {
            throw new DatabaseException("com.symbian.commdb.data.Database.ImportDatabase()", "Resolving table entry references in file " + string, "Unresolved table link references");
        }
    }

    public void ImportOldDatabase(String string) throws DatabaseException {
        int n;
        String string2;
        Object object;
        String string3;
        Object object2;
        Object object3;
        block49: {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            vector.add("IAP");
            vector2.add("IAPService");
            vector3.add("+IAPServiceType");
            vector4.add("IAPService");
            vector.add("IAP");
            vector2.add("IAPBearer");
            vector3.add("+IAPBearerType");
            vector4.add("IAPBearer");
            vector.add("IAP");
            vector2.add("IAPNetwork");
            vector3.add("-Network");
            vector4.add("IAPNetwork");
            vector.add("IAP");
            vector2.add("Location");
            vector3.add("-Location");
            vector4.add("LocationRef");
            vector.add("IAP");
            vector2.add("Chargecard");
            vector3.add("-Chargecard");
            vector4.add("ChargecardRef");
            vector.add("Proxy");
            vector2.add("ISP");
            vector3.add("+ProxyServiceType");
            vector4.add("ISPRef");
            vector.add("WAPIPBearer");
            vector2.add("AccessPointId");
            vector3.add("-WAPAccessPoint");
            vector4.add("AccessPoint");
            vector.add("WAPIPBearer");
            vector2.add("IAP");
            vector3.add("-IAP");
            vector4.add("IAPRef");
            vector.add("WAPSMSBearer");
            vector2.add("AccessPointId");
            vector3.add("-WAPAccessPoint");
            vector4.add("AccessPoint");
            vector.add("VpnService");
            vector2.add("HomeIAP");
            vector3.add("-IAP");
            vector4.add("HomeIAP");
            vector.add("VpnService");
            vector2.add("HomeNetwork");
            vector3.add("-Network");
            vector4.add("HomeNetwork");
            vector.add("ConnectionPreferences");
            vector2.add("IAP");
            vector3.add("-IAP");
            vector4.add("IAPRef");
            vector.add("GlobalSettings");
            vector2.add("WAPAccessPoint");
            vector3.add("-WAPAccessPoint");
            vector4.add("WAPAccess");
            vector.add("GlobalSettings");
            vector2.add("DefaultNetwork");
            vector3.add("-Network");
            vector4.add("DefaultNetwork");
            vector.add("GlobalSettings");
            vector2.add("ModemForDataAndFax");
            vector3.add("*ModemBearer");
            vector4.add("ModemForDataAndFax");
            vector.add("GlobalSettings");
            vector2.add("ModemForPhoneServicesAndSMS");
            vector3.add("*ModemBearer");
            vector4.add("ModemForPhoneServicesAndSMS");
            vector.add("GlobalSettings");
            vector2.add("LocationForDataAndFax");
            vector3.add("-Location");
            vector4.add("LocationForDataAndFax");
            vector.add("GlobalSettings");
            vector2.add("LocationForPhoneServicesAndSMS");
            vector3.add("-Location");
            vector4.add("LocationForPhoneServicesAndSMS");
            File file = new File(string);
            try {
                FileReader fileReader = new FileReader(file);
                object3 = new BufferedReader(fileReader);
                block18: while (true) {
                    String string4 = null;
                    string4 = ((BufferedReader)object3).readLine();
                    if (string4 == null) break;
                    if (string4.length() == 0 || string4.charAt(0) == '#' || string4.charAt(0) != '[') continue;
                    int n2 = string4.indexOf(93);
                    object2 = null;
                    try {
                        object2 = string4.substring(1, n2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        continue;
                    }
                    try {
                        if (((String)object2).equals("Proxies")) {
                            object2 = "Proxy";
                        } else if (((String)object2).equals("DefaultCDMA2000SettingsTable")) {
                            object2 = "DefaultCDMA2000Table";
                        } else {
                            int n3 = ((String)object2).length();
                            if (((String)object2).substring(n3 - 5, n3).equals("Table")) {
                                object2 = ((String)object2).substring(0, n3 - 5);
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    int n4 = 0;
                    while (true) {
                        if (n4 >= this.m_tableTemplateNames.size()) continue block18;
                        string3 = (String)this.m_tableTemplateNames.elementAt(n4);
                        if (string3.equals(object2)) {
                            Table table = (Table)this.m_tables.elementAt(n4);
                            int n5 = 0;
                            TableEntry tableEntry = null;
                            block20: while (true) {
                                String string5;
                                int n6;
                                ((BufferedReader)object3).mark(80);
                                string4 = ((BufferedReader)object3).readLine();
                                if (string4 == null) break block49;
                                if (string4.length() == 0 || string4.charAt(0) == '#') continue;
                                if (string4.charAt(0) == '[') {
                                    ((BufferedReader)object3).reset();
                                    continue block18;
                                }
                                object = null;
                                try {
                                    object = string4.substring(0, 4);
                                }
                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                    object = "";
                                }
                                if (((String)object).equals("ADD_")) {
                                    tableEntry = table.CreateTableEntry();
                                    tableEntry.SetID(++n5);
                                    try {
                                        if (string4.substring(0, 11).equals("ADD_SECTION")) {
                                            tableEntry.SetOperation("add");
                                            continue;
                                        }
                                        if (!string4.substring(0, 12).equals("ADD_TEMPLATE")) continue;
                                        tableEntry.SetOperation("template");
                                    }
                                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                                    continue;
                                }
                                int n7 = string4.indexOf(61);
                                if (n7 == -1) continue;
                                try {
                                    object = string4.substring(1, 7);
                                }
                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                    object = "";
                                }
                                if (((String)object).equals("FIELD_")) continue;
                                string2 = null;
                                String string6 = null;
                                try {
                                    string2 = string4.substring(1, n7);
                                    string6 = string4.substring(n7 + 1);
                                }
                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                    continue;
                                }
                                if (string2.equals("Name")) {
                                    tableEntry.SetParameterValue("Name", string6);
                                    continue;
                                }
                                boolean bl = false;
                                for (n6 = 0; n6 < vector.size(); ++n6) {
                                    String string7;
                                    String string8;
                                    String string9 = (String)vector.elementAt(n6);
                                    if (!string3.equals(string9)) continue;
                                    string5 = (String)vector2.elementAt(n6);
                                    if (string2.equals(string5)) {
                                        String string10;
                                        int n8 = Integer.parseInt(string6);
                                        string6 = new Integer(--n8).toString();
                                        string8 = (String)vector4.elementAt(n6);
                                        string7 = (String)vector3.elementAt(n6);
                                        char c = string7.charAt(0);
                                        if (c == '-') {
                                            string10 = string7.substring(1) + "." + string6;
                                            tableEntry.SetParameterValue(string8, string10);
                                        } else if (c == '*') {
                                            string10 = string6;
                                            tableEntry.SetParameterValue(string8, string10);
                                        } else {
                                            string10 = tableEntry.GetParameterValue(string8) + string6;
                                            tableEntry.SetParameterValue(string8, string10);
                                        }
                                        bl = true;
                                        break;
                                    }
                                    String string11 = (String)vector3.elementAt(n6);
                                    if (!string2.equals(string11 = string11.substring(1))) continue;
                                    try {
                                        if (string6.equals("Proxies")) {
                                            string6 = "Proxy";
                                        } else if (((String)object2).equals("DefaultCDMA2000SettingsTable")) {
                                            object2 = "DefaultCDMA2000Table";
                                        } else {
                                            int n9 = string6.length();
                                            if (string6.substring(n9 - 5, n9).equals("Table")) {
                                                string6 = string6.substring(0, n9 - 5);
                                            }
                                        }
                                    }
                                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    string8 = (String)vector4.elementAt(n6);
                                    string7 = string6 + "." + tableEntry.GetParameterValue(string8);
                                    tableEntry.SetParameterValue(string8, string7);
                                    bl = true;
                                    break;
                                }
                                if (bl) continue;
                                n6 = table.GetTableTemplate().GetNumberOfParameters();
                                int n10 = 0;
                                while (true) {
                                    if (n10 >= n6) continue block20;
                                    string5 = tableEntry.GetParameterName(n10);
                                    if (string5.equals(string2)) {
                                        tableEntry.SetParameterValue(n10, string6);
                                        continue block20;
                                    }
                                    ++n10;
                                }
                                break;
                            }
                        }
                        ++n4;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new DatabaseException("com.symbian.commdb.data.Database.ImportOldDatabase()", "I/O exception during parsing file " + string, iOException.getMessage());
            }
        }
        for (n = 0; n < this.m_tables.size(); ++n) {
            object3 = (Table)this.m_tables.elementAt(n);
            for (int i = 0; i < ((Table)object3).GetNumberOfTableEntries(); ++i) {
                TableEntry tableEntry = ((Table)object3).GetTableEntry(i);
                object2 = new Integer(tableEntry.GetID());
                String string12 = tableEntry.GetParameterValue("Name");
                if (!string12.equals("")) continue;
                string12 = ((Table)object3).GetTableName() + ((Integer)object2).toString();
                tableEntry.SetParameterValue("Name", string12);
            }
        }
        for (n = 0; n < this.m_tables.size(); ++n) {
            object3 = (Table)this.m_tables.elementAt(n);
            TableTemplate tableTemplate = ((Table)object3).GetTableTemplate();
            for (int i = 0; i < ((Table)object3).GetNumberOfTableEntries(); ++i) {
                object2 = ((Table)object3).GetTableEntry(i);
                for (int j = 0; j < ((TableEntry)object2).GetNumberOfParameters(); ++j) {
                    TableEntry tableEntry;
                    int n11;
                    int n12;
                    if (!tableTemplate.GetIsTableEntryLink(j) || (n12 = (string3 = ((TableEntry)object2).GetParameterValue(j)).indexOf(".")) <= 0) continue;
                    String string13 = string3.substring(0, n12) + "Table";
                    try {
                        n11 = Integer.parseInt(string3.substring(n12 + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    object = this.GetTable(string13);
                    if (object == null || n11 < 0 || (tableEntry = ((Table)object).GetTableEntry(n11)) == null) continue;
                    string2 = tableEntry.GetQualifiedName();
                    ((TableEntry)object2).SetParameterValue(j, string2);
                }
            }
        }
    }

    public void ExportDatabase(File file) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string = string + "<!--\n";
        string = string + "        CommDB Settings File\n";
        string = string + "        Copyright (c) 2003-2004, Symbian Ltd.\n";
        string = string + "        All Rights Reserved\n";
        string = string + "-->\n";
        string = string + "<CommDB:Config xmlns=\"SymbianOS.Generic.Comms-Infras.CommDB\"\n";
        string = string + "               xmlns:CommDB=\"SymbianOS.Generic.Comms-Infras.CommDB\"\n";
        string = string + "               xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n";
        string = string + "               xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        string = string + "               xsi:schemaLocation=\"SymbianOS.Generic.Comms-Infras.CommDB CommDB.xsd\">\n\n";
        fileOutputStream.write(string.getBytes());
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Table table = (Table)this.m_tables.elementAt(i);
            String string2 = table.toXML();
            fileOutputStream.write(string2.getBytes());
        }
        fileOutputStream.write(new String("\n</CommDB:Config>\n").getBytes());
        fileOutputStream.close();
    }

    public void OutputDatabaseContents() {
        System.out.println("Database Structure");
        System.out.println("==================");
        System.out.println("Number of tables = " + this.m_tables.size());
        System.out.println("The database is:\n");
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Table table = (Table)this.m_tables.elementAt(i);
            System.out.print(table.toXML());
        }
    }

    public void EraseDatabase() {
        this.m_tables.clear();
        this.m_fileNames.clear();
        this.m_tableNames.clear();
        this.m_tableTemplateNames.clear();
        this.m_enumerationFilenames.clear();
        this.m_schemaDirectory = "";
    }

    public void EraseTableEntries() {
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Table table = (Table)this.m_tables.elementAt(i);
            table.RemoveAllTableEntries();
        }
    }

    public void ReadContents() throws DatabaseException {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DatabaseException("com.symbian.commdb.data.Settings.ReadContents()", "Creation of an XML DOM parser", parserConfigurationException.getMessage());
        }
        File file = new File(this.m_schemaDirectory + "Contents.xml");
        Document document = null;
        try {
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            throw new DatabaseException("com.symbian.commdb.data.Settings.ReadContents()", "Parser exception during parsing file Contents.xml", sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new DatabaseException("com.symbian.commdb.data.Settings.ReadContents()", "I/O exception during parsing file Contents.xml", iOException.getMessage());
        }
        Vector vector = new Vector();
        XMLUtility.VectoriseChildrenNodes(document.getDocumentElement(), vector);
        for (int i = 0; i < vector.size(); ++i) {
            object = (Node)vector.elementAt(i);
            if (!object.getNodeName().equals("commdb")) continue;
            this.m_commdbType = XMLUtility.LocateNodeAttribute((Node)object, "type").getNodeValue();
            break;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            if (!node.getNodeName().equals("table")) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("file");
            Node node3 = namedNodeMap.getNamedItem("name");
            Node node4 = namedNodeMap.getNamedItem("entry");
            Node node5 = namedNodeMap.getNamedItem("enum");
            if (node3 == null || node2 == null || node4 == null || node5 == null) {
                throw new DatabaseException("com.symbian.commdb.data.Settings.ReadContents()", "Contents.xml not properly formatted", "One or more attributes for a table not specified");
            }
            String string = new String(node2.getNodeValue());
            object = new String(node3.getNodeValue());
            String string2 = new String(node4.getNodeValue());
            String string3 = new String(node5.getNodeValue());
            this.AddXMLSchemaFileName(string, string2, (String)object, string3);
        }
    }

    public void TableEntryQualifiedNames(Vector vector, Vector vector2) {
        vector.clear();
        vector2.clear();
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Table table = (Table)this.m_tables.elementAt(i);
            for (int j = 0; j < table.GetNumberOfTableEntries(); ++j) {
                TableEntry tableEntry = table.GetTableEntry(j);
                String string = tableEntry.GetQualifiedName();
                vector.add(string);
                vector2.add(tableEntry);
            }
        }
    }

    public boolean FindBrokenTableEntryLinks(Vector vector, Vector vector2) {
        boolean bl = true;
        vector.clear();
        vector2.clear();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.TableEntryQualifiedNames(vector3, vector4);
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Table table = (Table)this.m_tables.elementAt(i);
            TableTemplate tableTemplate = table.GetTableTemplate();
            for (int j = 0; j < table.GetNumberOfTableEntries(); ++j) {
                TableEntry tableEntry = table.GetTableEntry(j);
                for (int k = 0; k < tableEntry.GetNumberOfParameters(); ++k) {
                    String string;
                    if (!tableTemplate.GetIsTableEntryLink(k) || (string = tableEntry.GetParameterValue(k)).indexOf(".") == -1) continue;
                    if (string.endsWith(".-1")) {
                        if (tableEntry.GetOperation().equals("template")) continue;
                        vector.add(tableEntry.GetQualifiedParameterName(k));
                        vector2.add(string);
                        bl = false;
                        continue;
                    }
                    int n = vector3.indexOf(string);
                    if (n != -1) continue;
                    vector.add(tableEntry.GetQualifiedParameterName(k));
                    vector2.add(string);
                    bl = false;
                }
            }
        }
        return bl;
    }
}

