/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.commdb.data;

import com.symbian.commdb.data.TableTemplate;
import java.util.Vector;

public class TableEntry {
    private Vector m_tableEntryValues;
    private TableTemplate m_tableTemplate;
    private String m_operation;
    private int m_id;

    public TableEntry(TableTemplate tableTemplate) {
        this.m_tableTemplate = tableTemplate;
        int n = tableTemplate.GetNumberOfParameters();
        this.m_tableEntryValues = new Vector(n);
        this.m_id = 1;
        for (int i = 0; i < n; ++i) {
            this.m_tableEntryValues.add("");
        }
        this.m_operation = new String("add");
    }

    public String GetQualifiedName() {
        String string = this.m_tableTemplate.GetTableTemplateName();
        String string2 = this.GetParameterValue("Name");
        if (string2.equals("FAILED")) {
            string2 = "NoName";
        }
        return string + "." + string2;
    }

    public int GetID() {
        return this.m_id;
    }

    public TableTemplate GetTableTemplate() {
        return this.m_tableTemplate;
    }

    public int GetNumberOfParameters() {
        return this.m_tableTemplate.GetNumberOfParameters();
    }

    public String GetQualifiedParameterName(int n) {
        return this.GetQualifiedName() + "." + this.m_tableTemplate.GetParameter(n);
    }

    public String GetParameterValue(int n) {
        String string = (String)this.m_tableEntryValues.elementAt(n);
        return new String(string);
    }

    public String GetParameterValue(String string) {
        int n = this.m_tableTemplate.GetParameterIndex(string);
        if (n != -1) {
            return new String((String)this.m_tableEntryValues.elementAt(n));
        }
        return new String("FAILED");
    }

    public String GetParameterName(int n) {
        String string = this.m_tableTemplate.GetParameter(n);
        return new String(string);
    }

    public String GetParameterType(int n) {
        String string = this.m_tableTemplate.GetParameterType(n);
        return new String(string);
    }

    public String GetOperation() {
        return new String(this.m_operation);
    }

    public boolean MandatoryParametersValid() {
        for (int i = 0; i < this.m_tableEntryValues.size(); ++i) {
            String string;
            if (!this.m_tableTemplate.GetParameterMustExist(i) || !(string = (String)this.m_tableEntryValues.elementAt(i)).equals("")) continue;
            return false;
        }
        return true;
    }

    public String toXML() {
        String string = this.m_tableTemplate.GetTableTemplateName();
        String string2 = "    <" + string + " operation=\"" + this.m_operation + "\"" + ">\n";
        for (int i = 0; i < this.m_tableEntryValues.size(); ++i) {
            String string3 = this.m_tableTemplate.GetParameter(i);
            String string4 = "        <" + string3 + ">";
            String string5 = (String)this.m_tableEntryValues.elementAt(i);
            if (string5.equals("") || string5.indexOf(13) != -1 || string5.indexOf(10) != -1) continue;
            string5 = string5.replaceAll("&", "&amp;");
            string5 = string5.replaceAll("\"", "&quot;");
            string5 = string5.replaceAll(">", "&gt;");
            string5 = string5.replaceAll("<", "&lt;");
            string5 = string5.replaceAll("'", "&apos;");
            String string6 = "</" + string3 + ">\n";
            string2 = string2 + string4 + string5 + string6;
        }
        return string2 + "    </" + string + ">\n";
    }

    public boolean SetParameterValue(int n, String string) {
        if (n >= this.m_tableEntryValues.size()) {
            return false;
        }
        this.m_tableEntryValues.set(n, new String(string));
        return true;
    }

    public void SetID(int n) {
        this.m_id = n;
    }

    public void SetOperation(String string) {
        this.m_operation = new String(string);
    }

    public boolean SetParameterTableEntryLink(int n, TableEntry tableEntry) {
        if (n >= this.m_tableEntryValues.size() || n < 0) {
            return false;
        }
        if (!this.m_tableTemplate.GetIsTableEntryLink(n)) {
            return false;
        }
        if (tableEntry == null) {
            this.m_tableEntryValues.set(n, "");
        } else {
            this.m_tableEntryValues.set(n, tableEntry.GetQualifiedName());
        }
        return true;
    }

    public boolean SetParameterValue(String string, String string2) {
        int n = this.m_tableTemplate.GetParameterIndex(string);
        if (n != -1) {
            return this.SetParameterValue(n, string2);
        }
        return false;
    }

    public boolean SetParameterTableEntryLink(String string, TableEntry tableEntry) {
        int n = this.m_tableTemplate.GetParameterIndex(string);
        if (n != -1) {
            return this.SetParameterTableEntryLink(n, tableEntry);
        }
        return false;
    }
}

