/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.commdb.ui;

import com.symbian.commdb.data.Database;
import com.symbian.commdb.ui.InformationTableModel;
import com.symbian.commdb.ui.MainMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

public class InformationTable
extends JFrame {
    private JScrollPane ui_scrollingPanel;
    private JTable ui_informationTable;
    private JLabel ui_symbianLogoIcon;
    private JTextField ui_title;
    private JButton ui_closeButton;
    private Database m_commdb;
    private MainMenu m_menu;
    private final Color ui_bkgColor = new Color(220, 220, 220);
    private final Color ui_lightColor = new Color(230, 230, 230);

    public InformationTable(Database database, MainMenu mainMenu) {
        this.m_commdb = database;
        this.m_menu = mainMenu;
        this.initComponents();
        this.m_menu.DisableInformationDisplayMenuItem();
    }

    private void initComponents() {
        this.ui_symbianLogoIcon = new JLabel();
        this.ui_title = new JTextField();
        this.ui_closeButton = new JButton();
        this.ui_scrollingPanel = new JScrollPane();
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(this.ui_lightColor);
        this.setDefaultCloseOperation(2);
        this.setTitle("CommDB Information");
        this.setBackground(this.ui_bkgColor);
        this.setFont(new Font("Arial", 0, 12));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                InformationTable.this.exitForm(windowEvent);
            }
        });
        this.ui_scrollingPanel.setBackground(this.ui_bkgColor);
        this.ui_scrollingPanel.setViewportBorder(new BevelBorder(1));
        this.ui_scrollingPanel.setFont(new Font("Arial", 0, 12));
        this.getContentPane().add((Component)this.ui_scrollingPanel, "Center");
        this.ui_scrollingPanel.setBounds(10, 20, 600, 430);
        this.ui_symbianLogoIcon.setFont(new Font("Arial", 0, 12));
        this.ui_symbianLogoIcon.setIcon(new ImageIcon(this.getClass().getResource("/com/symbian/commdb/various/SymbianLogo.gif")));
        this.getContentPane().add(this.ui_symbianLogoIcon);
        this.ui_symbianLogoIcon.setBounds(480, 460, 120, 45);
        this.ui_title.setBackground(this.ui_lightColor);
        this.ui_title.setFont(new Font("Arial", 1, 14));
        this.ui_title.setHorizontalAlignment(0);
        this.ui_title.setText("CommDB Information");
        this.ui_title.setBorder(new CompoundBorder());
        this.getContentPane().add(this.ui_title);
        this.ui_title.setBounds(450, 510, 160, 30);
        this.ui_closeButton.setFont(new Font("Arial", 1, 12));
        this.ui_closeButton.setBackground(this.ui_lightColor);
        this.ui_closeButton.setMnemonic('C');
        this.ui_closeButton.setText("Close");
        this.ui_closeButton.setToolTipText("Close this window");
        this.ui_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InformationTable.this.CloseButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_closeButton);
        this.ui_closeButton.setBounds(10, 480, 70, 30);
        this.CreateInformation();
        this.pack();
    }

    public void CreateInformation() {
        this.ui_informationTable = new JTable();
        this.ui_informationTable.setModel(new InformationTableModel(this.m_commdb));
        this.ui_informationTable.setBackground(new Color(250, 250, 250));
        this.ui_informationTable.setForeground(new Color(0, 0, 150));
        this.ui_informationTable.setGridColor(new Color(0, 0, 0));
        this.ui_informationTable.setFont(new Font("Arial", 1, 12));
        this.ui_informationTable.getTableHeader().setFont(new Font("Arial", 1, 12));
        this.ui_informationTable.setShowGrid(true);
        this.ui_informationTable.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.ui_informationTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.ui_scrollingPanel.setViewportView(this.ui_informationTable);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.m_menu.EnableInformationDisplayMenuItem();
        this.dispose();
    }

    private void CloseButtonActionPerformed(ActionEvent actionEvent) {
        this.m_menu.EnableInformationDisplayMenuItem();
        this.dispose();
    }
}

