/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.commdb.ui;

import com.symbian.commdb.data.Database;
import com.symbian.commdb.data.DatabaseException;
import com.symbian.commdb.data.Table;
import com.symbian.commdb.data.TableEntry;
import com.symbian.commdb.data.Version;
import com.symbian.commdb.ui.BrokenLinks;
import com.symbian.commdb.ui.ExtensionFilter;
import com.symbian.commdb.ui.InformationTable;
import com.symbian.commdb.ui.TableEditor;
import com.symbian.commdb.ui.Usage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class MainMenu
extends JFrame {
    private JMenuItem ui_aboutMenuItem;
    private JMenu ui_actionsMenu;
    private JMenuItem ui_clearDatabaseMenuItem;
    private JMenuItem ui_displayInformationMenuItem;
    private JMenuItem ui_quitMenuItem;
    private JMenuItem ui_exportMenuItem;
    private JMenu ui_helpMenu;
    private JMenuItem ui_importXMLMenuItem;
    private JMenuItem ui_importCFGMenuItem;
    private JPanel ui_internalPanel;
    private JSeparator ui_separator1MenuItem;
    private JSeparator ui_separator2MenuItem;
    private JMenuItem ui_setCommDBXMLSchemaMenuItem;
    private JMenuItem ui_usageMenuItem;
    private JMenuItem ui_referencesMenuItem;
    private JMenu ui_tables;
    private JMenuBar ui_menuBar;
    private JLabel ui_symbianLogoIcon;
    private JTextField ui_title;
    private JLabel ui_numberOfTablesLabel;
    private JTextField ui_numberOfTablesTextField;
    private JLabel ui_commdbTypeLabel;
    private JTextField ui_commdbTypeTextField;
    private JLabel ui_numberOfEntriesLabel;
    private JTextField ui_numberOfEntriesTextField;
    private JProgressBar ui_progressBar;
    private InformationTable ui_infoTable;
    private Usage ui_usage;
    private BrokenLinks ui_brokenLinks;
    private Database m_commdb;
    private boolean m_canEditTables;
    private final Color ui_bkgColor = new Color(220, 220, 220);
    private final Color ui_lightColor = new Color(230, 230, 230);

    public MainMenu(Database database) {
        this.m_commdb = database;
        this.initComponents();
        this.ui_tables.setEnabled(false);
        this.ui_importXMLMenuItem.setEnabled(false);
        this.ui_importCFGMenuItem.setEnabled(false);
        this.ui_exportMenuItem.setEnabled(false);
        this.ui_clearDatabaseMenuItem.setEnabled(false);
        this.ui_displayInformationMenuItem.setEnabled(false);
        this.ui_referencesMenuItem.setEnabled(false);
        this.m_canEditTables = false;
    }

    private void initComponents() {
        this.ui_internalPanel = new JPanel();
        this.ui_symbianLogoIcon = new JLabel();
        this.ui_title = new JTextField();
        this.ui_menuBar = new JMenuBar();
        this.ui_actionsMenu = new JMenu();
        this.ui_displayInformationMenuItem = new JMenuItem();
        this.ui_importXMLMenuItem = new JMenuItem();
        this.ui_importCFGMenuItem = new JMenuItem();
        this.ui_exportMenuItem = new JMenuItem();
        this.ui_referencesMenuItem = new JMenuItem();
        this.ui_separator1MenuItem = new JSeparator();
        this.ui_clearDatabaseMenuItem = new JMenuItem();
        this.ui_setCommDBXMLSchemaMenuItem = new JMenuItem();
        this.ui_separator2MenuItem = new JSeparator();
        this.ui_quitMenuItem = new JMenuItem();
        this.ui_tables = new JMenu();
        this.ui_helpMenu = new JMenu();
        this.ui_aboutMenuItem = new JMenuItem();
        this.ui_usageMenuItem = new JMenuItem();
        this.ui_numberOfTablesLabel = new JLabel();
        this.ui_numberOfTablesTextField = new JTextField();
        this.ui_numberOfEntriesLabel = new JLabel();
        this.ui_numberOfEntriesTextField = new JTextField();
        this.ui_progressBar = new JProgressBar();
        this.ui_commdbTypeLabel = new JLabel();
        this.ui_commdbTypeTextField = new JTextField();
        this.setTitle("Symbian CommDB Editor");
        this.setBackground(this.ui_lightColor);
        this.setFont(new Font("Arial", 0, 12));
        this.setName("Editor");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainMenu.this.exitForm(windowEvent);
            }
        });
        this.ui_internalPanel.setLayout(null);
        this.ui_internalPanel.setBackground(this.ui_lightColor);
        this.ui_symbianLogoIcon.setFont(new Font("Arial", 0, 12));
        this.ui_symbianLogoIcon.setIcon(new ImageIcon(this.getClass().getResource("/com/symbian/commdb/various/SymbianLogo.gif")));
        this.ui_internalPanel.add(this.ui_symbianLogoIcon);
        this.ui_symbianLogoIcon.setBounds(360, 110, 120, 50);
        this.ui_title.setBackground(this.ui_lightColor);
        this.ui_title.setEditable(false);
        this.ui_title.setFont(new Font("Arial", 1, 14));
        this.ui_title.setHorizontalAlignment(0);
        this.ui_title.setText("CommDB Editor");
        this.ui_title.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.ui_internalPanel.add(this.ui_title);
        this.ui_title.setBounds(365, 160, 120, 30);
        this.ui_commdbTypeLabel.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_commdbTypeLabel.setText("CommDB Type");
        this.ui_commdbTypeLabel.setToolTipText("The type of this database");
        this.ui_internalPanel.add(this.ui_commdbTypeLabel);
        this.ui_commdbTypeLabel.setBounds(10, 30, 110, 20);
        this.ui_commdbTypeTextField.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_commdbTypeTextField.setBackground(this.ui_bkgColor);
        this.ui_commdbTypeTextField.setBorder(new BevelBorder(1));
        this.ui_commdbTypeTextField.setEditable(false);
        this.ui_commdbTypeTextField.setText("Unspecified");
        this.ui_commdbTypeTextField.setHorizontalAlignment(4);
        this.ui_internalPanel.add(this.ui_commdbTypeTextField);
        this.ui_commdbTypeTextField.setBounds(130, 30, 140, 20);
        this.ui_numberOfTablesLabel.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_numberOfTablesLabel.setText("Number of Tables");
        this.ui_numberOfTablesLabel.setToolTipText("Total number of tables in the database");
        this.ui_internalPanel.add(this.ui_numberOfTablesLabel);
        this.ui_numberOfTablesLabel.setBounds(10, 65, 110, 20);
        this.ui_numberOfTablesTextField.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_numberOfTablesTextField.setBackground(this.ui_bkgColor);
        this.ui_numberOfTablesTextField.setBorder(new BevelBorder(1));
        this.ui_numberOfTablesTextField.setEditable(false);
        this.ui_numberOfTablesTextField.setText("0");
        this.ui_numberOfTablesTextField.setHorizontalAlignment(4);
        this.ui_internalPanel.add(this.ui_numberOfTablesTextField);
        this.ui_numberOfTablesTextField.setBounds(130, 65, 140, 20);
        this.ui_numberOfEntriesLabel.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_numberOfEntriesLabel.setText("Number of Entries");
        this.ui_numberOfEntriesLabel.setToolTipText("Total number of table entries in the database");
        this.ui_internalPanel.add(this.ui_numberOfEntriesLabel);
        this.ui_numberOfEntriesLabel.setBounds(10, 100, 110, 20);
        this.ui_numberOfEntriesTextField.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_numberOfEntriesTextField.setBackground(this.ui_bkgColor);
        this.ui_numberOfEntriesTextField.setBorder(new BevelBorder(1));
        this.ui_numberOfEntriesTextField.setEditable(false);
        this.ui_numberOfEntriesTextField.setText("0");
        this.ui_numberOfEntriesTextField.setHorizontalAlignment(4);
        this.ui_internalPanel.add(this.ui_numberOfEntriesTextField);
        this.ui_numberOfEntriesTextField.setBounds(130, 100, 140, 20);
        this.ui_progressBar.setBounds(10, 200, 480, 10);
        this.ui_internalPanel.add(this.ui_progressBar);
        this.getContentPane().add((Component)this.ui_internalPanel, "Center");
        this.ui_menuBar.setBorder(new BevelBorder(0));
        this.ui_menuBar.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_menuBar.setMaximumSize(new Dimension(1000, 2));
        this.ui_menuBar.setMinimumSize(new Dimension(1000, 2));
        this.ui_actionsMenu.setMnemonic('A');
        this.ui_actionsMenu.setText("Actions");
        this.ui_actionsMenu.setToolTipText("Perform various actions");
        this.ui_actionsMenu.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_importXMLMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.ui_importXMLMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_importXMLMenuItem.setMnemonic('I');
        this.ui_importXMLMenuItem.setText("Import XML File...");
        this.ui_importXMLMenuItem.setToolTipText("Import an existing CommDB XML settings file");
        this.ui_importXMLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.ImportMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_actionsMenu.add(this.ui_importXMLMenuItem);
        this.ui_importCFGMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.ui_importCFGMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_importCFGMenuItem.setMnemonic('O');
        this.ui_importCFGMenuItem.setText("Import CFG File...");
        this.ui_importCFGMenuItem.setToolTipText("Import an existing CommDB settings file in the CFG format");
        this.ui_importCFGMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.ImportOldMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_actionsMenu.add(this.ui_importCFGMenuItem);
        this.ui_exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.ui_exportMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_exportMenuItem.setMnemonic('E');
        this.ui_exportMenuItem.setText("Export XML File...");
        this.ui_exportMenuItem.setToolTipText("Export the database to a CommDB XML settings file");
        this.ui_exportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.ExportMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_actionsMenu.add(this.ui_exportMenuItem);
        this.ui_actionsMenu.add(this.ui_separator1MenuItem);
        this.ui_displayInformationMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.ui_displayInformationMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_displayInformationMenuItem.setMnemonic('D');
        this.ui_displayInformationMenuItem.setText("Display Information");
        this.ui_displayInformationMenuItem.setToolTipText("Displays database information");
        this.ui_displayInformationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.DisplayInformationMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_actionsMenu.add(this.ui_displayInformationMenuItem);
        this.ui_referencesMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.ui_referencesMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_referencesMenuItem.setMnemonic('R');
        this.ui_referencesMenuItem.setText("Check Table Entry References");
        this.ui_referencesMenuItem.setToolTipText("Checks validity of table entry references");
        this.ui_referencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.CheckReferencesMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_actionsMenu.add(this.ui_referencesMenuItem);
        this.ui_clearDatabaseMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.ui_clearDatabaseMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_clearDatabaseMenuItem.setMnemonic('l');
        this.ui_clearDatabaseMenuItem.setText("Clear Database");
        this.ui_clearDatabaseMenuItem.setToolTipText("Clear all table entries of the database");
        this.ui_clearDatabaseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.ClearDatabaseMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_actionsMenu.add(this.ui_clearDatabaseMenuItem);
        this.ui_setCommDBXMLSchemaMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.ui_setCommDBXMLSchemaMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_setCommDBXMLSchemaMenuItem.setMnemonic('S');
        this.ui_setCommDBXMLSchemaMenuItem.setText("Set CommDB XML Schema");
        this.ui_setCommDBXMLSchemaMenuItem.setToolTipText("Specify a specific structure for the CommDB tables by reading an XML Schema set of files");
        this.ui_setCommDBXMLSchemaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.SetCommDBXMLSchemaMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_actionsMenu.add(this.ui_setCommDBXMLSchemaMenuItem);
        this.ui_actionsMenu.add(this.ui_separator2MenuItem);
        this.ui_quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.ui_quitMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_quitMenuItem.setMnemonic('Q');
        this.ui_quitMenuItem.setText("Quit");
        this.ui_quitMenuItem.setToolTipText("Exit the CommDB Editor");
        this.ui_quitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.QuitMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_actionsMenu.add(this.ui_quitMenuItem);
        this.ui_menuBar.add(this.ui_actionsMenu);
        this.ui_tables.setMnemonic('T');
        this.ui_tables.setText("Tables");
        this.ui_tables.setToolTipText("Edit the CommDB settings tables");
        this.ui_tables.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_menuBar.add(this.ui_tables);
        this.ui_helpMenu.setMnemonic('H');
        this.ui_helpMenu.setText("Help");
        this.ui_helpMenu.setToolTipText("Editor Help and Information");
        this.ui_helpMenu.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_aboutMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.ui_aboutMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_aboutMenuItem.setMnemonic('b');
        this.ui_aboutMenuItem.setText("About");
        this.ui_aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.AboutMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_helpMenu.add(this.ui_aboutMenuItem);
        this.ui_usageMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.ui_usageMenuItem.setFont(new Font("Arial Narrow", 1, 14));
        this.ui_usageMenuItem.setMnemonic('U');
        this.ui_usageMenuItem.setText("Usage");
        this.ui_usageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.UsageMenuItemActionPerformed(actionEvent);
            }
        });
        this.ui_helpMenu.add(this.ui_usageMenuItem);
        this.ui_menuBar.add(this.ui_helpMenu);
        this.setJMenuBar(this.ui_menuBar);
        this.pack();
    }

    public Database GetDatabase() {
        return this.m_commdb;
    }

    public void RefreshInformation() {
        if (this.ui_infoTable != null) {
            this.ui_infoTable.CreateInformation();
        }
        this.ui_numberOfTablesTextField.setText(new Integer(this.m_commdb.GetNumberOfTables()).toString());
        this.ui_numberOfEntriesTextField.setText(new Integer(this.m_commdb.GetNumberOfTableEntries()).toString());
    }

    private void DisplayInformationMenuItemActionPerformed(ActionEvent actionEvent) {
        this.ui_infoTable = new InformationTable(this.m_commdb, this);
        this.ui_infoTable.setBounds(300, 150, 620, 580);
        this.ui_infoTable.show();
    }

    private void UsageMenuItemActionPerformed(ActionEvent actionEvent) {
        this.ui_usage = new Usage(this);
        this.ui_usage.setBounds(300, 150, 620, 580);
        this.ui_usage.show();
    }

    private void CheckReferencesMenuItemActionPerformed(ActionEvent actionEvent) {
        this.ui_brokenLinks = new BrokenLinks(this);
        this.ui_brokenLinks.setBounds(300, 150, 620, 580);
        this.ui_brokenLinks.show();
    }

    private void SetCommDBXMLSchemaMenuItemActionPerformed(ActionEvent actionEvent) {
        File file;
        this.ui_progressBar.setValue(0);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.rescanCurrentDirectory();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Set the directory with the CommDB XML files");
        jFileChooser.setFont(new Font("Arial Narrow", 1, 14));
        int n = jFileChooser.showDialog(this, "Select");
        File file2 = file = n == 0 ? jFileChooser.getSelectedFile() : null;
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath() + "/";
        this.m_commdb = new Database(string);
        try {
            this.m_commdb.ReadContents();
        }
        catch (DatabaseException databaseException) {
            JOptionPane.showMessageDialog(this, databaseException.GetErrorMessage(), "Database Error", 0);
            return;
        }
        this.ui_tables.removeAll();
        for (int i = 0; i < this.m_commdb.GetNumberOfTableTemplates(); ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setFont(new Font("Arial Narrow", 1, 14));
            final String string2 = this.m_commdb.GetTableName(i);
            jMenuItem.setText(string2);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainMenu.this.OpenTableEditor(string2);
                }
            });
            this.ui_tables.add(jMenuItem);
        }
        try {
            this.m_commdb.BuildTableTemplates(this.ui_progressBar);
        }
        catch (DatabaseException databaseException) {
            JOptionPane.showMessageDialog(this, databaseException.GetErrorMessage(), "Database Error", 0);
            return;
        }
        this.RefreshInformation();
        this.ui_tables.setEnabled(true);
        this.ui_importXMLMenuItem.setEnabled(true);
        this.ui_importCFGMenuItem.setEnabled(true);
        this.ui_exportMenuItem.setEnabled(true);
        this.ui_clearDatabaseMenuItem.setEnabled(true);
        this.ui_displayInformationMenuItem.setEnabled(true);
        this.ui_referencesMenuItem.setEnabled(true);
        this.m_canEditTables = true;
        this.ui_commdbTypeTextField.setText(this.m_commdb.GetDatabaseType());
    }

    private void ClearDatabaseMenuItemActionPerformed(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this, "This action will erase all database entries!\nDo you want to continue?", "Clear Database Confirmation", 0);
        if (n == 0) {
            this.m_commdb.EraseTableEntries();
            this.RefreshInformation();
        }
    }

    private void ExportMenuItemActionPerformed(ActionEvent actionEvent) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        boolean bl = this.m_commdb.FindBrokenTableEntryLinks(vector, vector2);
        if (!bl) {
            JOptionPane.showMessageDialog(this, "Invalid table entry references have been encountered\n", "Notification", 0);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        ExtensionFilter extensionFilter = new ExtensionFilter(".xml", "XML Files (*.xml)");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(extensionFilter);
        jFileChooser.rescanCurrentDirectory();
        jFileChooser.setFileFilter(extensionFilter);
        jFileChooser.setDialogTitle("Export CommDB Settings File");
        jFileChooser.setFont(new Font("Arial Narrow", 1, 14));
        String string = "CommDB.xml";
        File file = new File(jFileChooser.getCurrentDirectory(), string);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showDialog(this, "Select");
        File file2 = file = n == 0 ? jFileChooser.getSelectedFile() : null;
        if (file != null) {
            try {
                this.m_commdb.ExportDatabase(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, "The CommDB XML file was not properly exported\n" + fileNotFoundException.getMessage(), "Notification", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "The CommDB XML file was not properly exported\n" + iOException.getMessage(), "Notification", 0);
            }
        }
    }

    private void QuitMenuItemActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void ImportMenuItemActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        ExtensionFilter extensionFilter = new ExtensionFilter(".xml", "XML Files (*.xml)");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(extensionFilter);
        jFileChooser.rescanCurrentDirectory();
        jFileChooser.setFileFilter(extensionFilter);
        jFileChooser.setDialogTitle("Import CommDB XML Settings File");
        jFileChooser.setFont(new Font("Arial Narrow", 1, 14));
        int n = jFileChooser.showDialog(this, "Select");
        File file2 = file = n == 0 ? jFileChooser.getSelectedFile() : null;
        if (file != null) {
            try {
                this.m_commdb.ImportDatabase(file.getAbsolutePath());
                this.RefreshInformation();
            }
            catch (DatabaseException databaseException) {
                JOptionPane.showMessageDialog(this, "The CommDB XML file was not properly imported\n" + databaseException.getMessage(), "Notification", 0);
            }
        }
    }

    private void ImportOldMenuItemActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        ExtensionFilter extensionFilter = new ExtensionFilter(".cfg", "CFG Files (*.cfg)");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(extensionFilter);
        jFileChooser.rescanCurrentDirectory();
        jFileChooser.setFileFilter(extensionFilter);
        jFileChooser.setDialogTitle("Import CommDB CFG Settings File");
        jFileChooser.setFont(new Font("Arial Narrow", 1, 14));
        int n = jFileChooser.showDialog(this, "Select");
        File file2 = file = n == 0 ? jFileChooser.getSelectedFile() : null;
        if (file != null) {
            try {
                this.m_commdb.ImportOldDatabase(file.getAbsolutePath());
                this.RefreshInformation();
            }
            catch (DatabaseException databaseException) {
                JOptionPane.showMessageDialog(this, "The CommDB CFG file was not properly imported\n" + databaseException.GetErrorMessage(), "Notification", 0);
            }
        }
    }

    private void AboutMenuItemActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "Symbian CommDB Editor\nVersion " + Version.GetVersion() + "\n" + "Copyright \u00a9 2003, Symbian Ltd.\n" + "All Rights Reserved.", "About Symbian CommDB Editor", 1, new ImageIcon(this.getClass().getResource("/com/symbian/commdb/various/SymbianLogo.gif")));
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    private void OpenTableEditor(String string) {
        if (!this.m_canEditTables) {
            return;
        }
        Table table = this.m_commdb.GetTable(string);
        TableEditor tableEditor = new TableEditor(this, table);
        TableEntry tableEntry = null;
        if (table.GetNumberOfTableEntries() > 0) {
            tableEntry = table.GetTableEntry(0);
        }
        tableEditor.SetEditedTableEntry(tableEntry);
        tableEditor.EditCurrentTableEntry();
        tableEditor.setBounds(100, 150, 715, 580);
        tableEditor.show();
        this.DisableMenuItemsDuringEditing();
    }

    public void DisableMenuItemsDuringEditing() {
        this.ui_clearDatabaseMenuItem.setEnabled(false);
        this.ui_importXMLMenuItem.setEnabled(false);
        this.ui_importCFGMenuItem.setEnabled(false);
        this.ui_exportMenuItem.setEnabled(false);
        this.ui_setCommDBXMLSchemaMenuItem.setEnabled(false);
    }

    public void DisableUsageMenuItem() {
        this.ui_usageMenuItem.setEnabled(false);
    }

    public void DisableInformationDisplayMenuItem() {
        this.ui_displayInformationMenuItem.setEnabled(false);
    }

    public void DisableCheckReferencesMenuItem() {
        this.ui_referencesMenuItem.setEnabled(false);
    }

    public void DisableCheckReferencesnDisplayMenuItem() {
        this.ui_referencesMenuItem.setEnabled(false);
    }

    public void DisableTableMenuItem(String string) {
        int n = this.ui_tables.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = this.ui_tables.getItem(i);
            if (jMenuItem == null || !jMenuItem.getText().equals(string)) continue;
            jMenuItem.setEnabled(false);
            break;
        }
    }

    public void EnableTableMenuItem(String string) {
        int n = this.ui_tables.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = this.ui_tables.getItem(i);
            if (jMenuItem == null || !jMenuItem.getText().equals(string)) continue;
            jMenuItem.setEnabled(true);
            break;
        }
    }

    public void EnableInformationDisplayMenuItem() {
        this.ui_displayInformationMenuItem.setEnabled(true);
    }

    public void EnableCheckReferencesMenuItem() {
        this.ui_referencesMenuItem.setEnabled(true);
    }

    public void EnableUsageMenuItem() {
        this.ui_usageMenuItem.setEnabled(true);
    }

    public void EnableMenuItemsAfterEditing() {
        this.ui_clearDatabaseMenuItem.setEnabled(true);
        this.ui_importXMLMenuItem.setEnabled(true);
        this.ui_importCFGMenuItem.setEnabled(true);
        this.ui_exportMenuItem.setEnabled(true);
        this.ui_setCommDBXMLSchemaMenuItem.setEnabled(true);
    }
}

