/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.commdb.ui;

import com.symbian.commdb.data.Table;
import com.symbian.commdb.data.TableEntry;
import com.symbian.commdb.data.TableTemplate;
import com.symbian.commdb.ui.MainMenu;
import com.symbian.commdb.ui.PropertiesCellEditor;
import com.symbian.commdb.ui.PropertiesCellRenderer;
import com.symbian.commdb.ui.PropertiesTableModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableColumn;

public class TableEditor
extends JFrame {
    private JButton ui_addButton;
    private JButton ui_closeButton;
    private JButton ui_deleteButton;
    private JButton ui_deleteAllButton;
    private JButton ui_nextButton;
    private JButton ui_previousButton;
    private JButton ui_firstButton;
    private JButton ui_lastButton;
    private JScrollPane ui_propertiesList;
    private JLabel ui_symbianLogoIcon;
    private JTextField ui_tableEntryCounter;
    private JTextField ui_tableTypeTextField;
    private JTextField ui_title;
    private JComboBox ui_tableEntryOperation;
    private JTable ui_props;
    private JTextField ui_tableEntryOperationTextField;
    private MainMenu m_menu;
    private Table m_table;
    private TableEntry m_entry;
    private int m_maxEntriesAllowed;
    private static int s_activeTableEditors = 0;
    private final Color ui_bkgColor = new Color(220, 220, 220);
    private final Color ui_lightColor = new Color(230, 230, 230);

    public TableEditor(MainMenu mainMenu, Table table) {
        this.initComponents();
        this.m_menu = mainMenu;
        this.m_table = table;
        this.ui_props = new JTable();
        this.m_entry = null;
        this.m_maxEntriesAllowed = this.m_table.GetTableTemplate().GetMaxNumberOfEntriesAllowed();
        ++s_activeTableEditors;
        String string = this.m_table.GetTableName();
        this.ui_tableTypeTextField.setText(string);
        this.m_menu.DisableTableMenuItem(string);
        if (this.m_maxEntriesAllowed == 1 && this.m_table.GetNumberOfTableEntries() >= 1) {
            this.ui_previousButton.setEnabled(false);
            this.ui_nextButton.setEnabled(false);
            this.ui_addButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.ui_propertiesList = new JScrollPane();
        this.ui_previousButton = new JButton();
        this.ui_nextButton = new JButton();
        this.ui_addButton = new JButton();
        this.ui_deleteButton = new JButton();
        this.ui_deleteAllButton = new JButton();
        this.ui_tableTypeTextField = new JTextField();
        this.ui_closeButton = new JButton();
        this.ui_symbianLogoIcon = new JLabel();
        this.ui_tableEntryCounter = new JTextField();
        this.ui_title = new JTextField();
        this.ui_firstButton = new JButton();
        this.ui_lastButton = new JButton();
        this.ui_tableEntryOperation = new JComboBox();
        this.ui_tableEntryOperationTextField = new JTextField();
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(this.ui_lightColor);
        this.setDefaultCloseOperation(0);
        this.setTitle("Table Editor");
        this.setBackground(this.ui_bkgColor);
        this.setFont(new Font("Arial", 0, 12));
        this.setName("TableEditorFrame");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TableEditor.this.exitForm(windowEvent);
            }
        });
        this.ui_propertiesList.setBackground(this.ui_bkgColor);
        this.ui_propertiesList.setFont(new Font("Arial", 0, 12));
        this.getContentPane().add(this.ui_propertiesList);
        this.ui_propertiesList.setBounds(10, 80, 690, 370);
        this.ui_previousButton.setFont(new Font("Arial", 1, 12));
        this.ui_previousButton.setBackground(this.ui_lightColor);
        this.ui_previousButton.setMnemonic('P');
        this.ui_previousButton.setText("Previous");
        this.ui_previousButton.setToolTipText("Go to the previous table entry");
        this.ui_previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.PreviousButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_previousButton);
        this.ui_previousButton.setBounds(10, 5, 85, 30);
        this.ui_firstButton.setFont(new Font("Arial", 1, 12));
        this.ui_firstButton.setBackground(this.ui_lightColor);
        this.ui_firstButton.setMnemonic('F');
        this.ui_firstButton.setText("First");
        this.ui_firstButton.setToolTipText("Go to the first table entry");
        this.ui_firstButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.FirstButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_firstButton);
        this.ui_firstButton.setBounds(10, 40, 85, 30);
        this.ui_nextButton.setFont(new Font("Arial", 1, 12));
        this.ui_nextButton.setBackground(this.ui_lightColor);
        this.ui_nextButton.setMnemonic('N');
        this.ui_nextButton.setText("Next");
        this.ui_nextButton.setToolTipText("Go to the next table entry");
        this.ui_nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.NextButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_nextButton);
        this.ui_nextButton.setBounds(640, 5, 60, 30);
        this.ui_addButton.setFont(new Font("Arial", 1, 12));
        this.ui_addButton.setBackground(this.ui_lightColor);
        this.ui_addButton.setMnemonic('A');
        this.ui_addButton.setText("Add");
        this.ui_addButton.setToolTipText("Add a new table entry");
        this.ui_addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.AddButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_addButton);
        this.ui_addButton.setBounds(560, 5, 60, 30);
        this.ui_lastButton.setFont(new Font("Arial", 1, 12));
        this.ui_lastButton.setBackground(this.ui_lightColor);
        this.ui_lastButton.setMnemonic('L');
        this.ui_lastButton.setText("Last");
        this.ui_lastButton.setToolTipText("Go to the last table entry");
        this.ui_lastButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.LastButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_lastButton);
        this.ui_lastButton.setBounds(640, 40, 60, 30);
        this.ui_deleteButton.setFont(new Font("Arial", 1, 12));
        this.ui_deleteButton.setBackground(this.ui_lightColor);
        this.ui_deleteButton.setMnemonic('D');
        this.ui_deleteButton.setText("Delete");
        this.ui_deleteButton.setToolTipText("Delete this entry");
        this.ui_deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.DeleteButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_deleteButton);
        this.ui_deleteButton.setBounds(100, 5, 70, 30);
        this.ui_closeButton.setFont(new Font("Arial", 1, 12));
        this.ui_closeButton.setBackground(this.ui_lightColor);
        this.ui_closeButton.setMnemonic('C');
        this.ui_closeButton.setText("Close");
        this.ui_closeButton.setToolTipText("Close and save this table");
        this.ui_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.CloseButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_closeButton);
        this.ui_closeButton.setBounds(10, 480, 70, 30);
        this.ui_deleteAllButton.setFont(new Font("Arial", 1, 12));
        this.ui_deleteAllButton.setBackground(this.ui_lightColor);
        this.ui_deleteAllButton.setMnemonic('t');
        this.ui_deleteAllButton.setText("Delete All");
        this.ui_deleteAllButton.setToolTipText("Delete all table entries and close this form");
        this.ui_deleteAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.DeleteAllButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_deleteAllButton);
        this.ui_deleteAllButton.setBounds(95, 480, 90, 30);
        this.ui_tableEntryOperation.setFont(new Font("Arial", 1, 12));
        this.ui_tableEntryOperation.setBackground(this.ui_lightColor);
        this.ui_tableEntryOperation.setEditable(false);
        this.ui_tableEntryOperation.setEnabled(true);
        this.ui_tableEntryOperation.addItem("add");
        this.ui_tableEntryOperation.addItem("template");
        this.ui_tableEntryOperation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableEditor.this.TableEntryOperationActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ui_tableEntryOperation);
        this.ui_tableEntryOperation.setBounds(300, 485, 90, 24);
        this.ui_tableEntryOperationTextField.setFont(new Font("Arial", 1, 12));
        this.ui_tableEntryOperationTextField.setBackground(this.ui_lightColor);
        this.ui_tableEntryOperationTextField.setEditable(false);
        this.ui_tableEntryOperationTextField.setEnabled(true);
        this.ui_tableEntryOperationTextField.setText("DBMS Writing Operation");
        this.ui_tableEntryOperationTextField.setToolTipText("The type of DBMS writing operation to use");
        this.getContentPane().add(this.ui_tableEntryOperationTextField);
        this.ui_tableEntryOperationTextField.setBounds(300, 460, 145, 22);
        this.ui_tableTypeTextField.setBackground(new Color(242, 230, 230));
        this.ui_tableTypeTextField.setEditable(false);
        this.ui_tableTypeTextField.setFont(new Font("Arial", 1, 12));
        this.ui_tableTypeTextField.setHorizontalAlignment(0);
        this.ui_tableTypeTextField.setText("Unknown");
        this.ui_tableTypeTextField.setToolTipText("The name of this CommDB table");
        this.ui_tableTypeTextField.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.ui_tableTypeTextField);
        this.ui_tableTypeTextField.setBounds(180, 10, 370, 30);
        this.ui_symbianLogoIcon.setFont(new Font("Arial", 0, 12));
        this.ui_symbianLogoIcon.setIcon(new ImageIcon(this.getClass().getResource("/com/symbian/commdb/various/SymbianLogo.gif")));
        this.getContentPane().add(this.ui_symbianLogoIcon);
        this.ui_symbianLogoIcon.setBounds(580, 460, 120, 45);
        this.ui_title.setBackground(this.ui_lightColor);
        this.ui_title.setFont(new Font("Arial", 1, 14));
        this.ui_title.setHorizontalAlignment(0);
        this.ui_title.setText("CommDB Table Editor");
        this.ui_title.setBorder(new CompoundBorder());
        this.getContentPane().add(this.ui_title);
        this.ui_title.setBounds(545, 510, 160, 30);
        this.ui_tableEntryCounter.setBackground(new Color(242, 230, 230));
        this.ui_tableEntryCounter.setEditable(false);
        this.ui_tableEntryCounter.setFont(new Font("Arial", 1, 12));
        this.ui_tableEntryCounter.setHorizontalAlignment(0);
        this.ui_tableEntryCounter.setText("0 / 0");
        this.ui_tableEntryCounter.setToolTipText("Current table entry index / Total number of table entries");
        this.ui_tableEntryCounter.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.ui_tableEntryCounter);
        this.ui_tableEntryCounter.setBounds(280, 50, 180, 19);
        this.pack();
    }

    public void SetEditedTableEntry(TableEntry tableEntry) {
        this.m_entry = tableEntry;
    }

    private void PreviousButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_entry == null) {
            return;
        }
        if (!this.MandatoryParametersValidation()) {
            return;
        }
        int n = this.m_table.GetTableEntryIndex(this.m_entry);
        this.m_entry = this.m_table.GetTableEntry(n - 1);
        this.EditCurrentTableEntry();
    }

    private void FirstButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_entry == null) {
            return;
        }
        if (!this.MandatoryParametersValidation()) {
            return;
        }
        this.m_entry = this.m_table.GetTableEntry(0);
        this.EditCurrentTableEntry();
    }

    private void LastButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_entry == null) {
            return;
        }
        if (!this.MandatoryParametersValidation()) {
            return;
        }
        this.m_entry = this.m_table.GetTableEntry(this.m_table.GetNumberOfTableEntries() - 1);
        this.EditCurrentTableEntry();
    }

    private void AddButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.MandatoryParametersValidation()) {
            return;
        }
        this.m_entry = this.m_table.CreateTableEntry();
        this.EditCurrentTableEntry();
    }

    private void NextButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_entry == null) {
            return;
        }
        if (!this.MandatoryParametersValidation()) {
            return;
        }
        int n = this.m_table.GetTableEntryIndex(this.m_entry);
        this.m_entry = this.m_table.GetTableEntry(n + 1);
        this.EditCurrentTableEntry();
    }

    private void CloseButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_entry != null) {
            if (!this.MandatoryParametersValidation()) {
                return;
            }
            this.m_menu.RefreshInformation();
        }
        if (s_activeTableEditors == 1) {
            this.m_menu.EnableMenuItemsAfterEditing();
        }
        --s_activeTableEditors;
        String string = this.m_table.GetTableName();
        this.m_menu.EnableTableMenuItem(string);
        this.dispose();
    }

    private void DeleteAllButtonActionPerformed(ActionEvent actionEvent) {
        this.m_table.RemoveAllTableEntries();
        this.m_menu.RefreshInformation();
        if (s_activeTableEditors == 1) {
            this.m_menu.EnableMenuItemsAfterEditing();
        }
        --s_activeTableEditors;
        String string = this.m_table.GetTableName();
        this.m_menu.EnableTableMenuItem(string);
        this.dispose();
    }

    private void DeleteButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_entry == null) {
            return;
        }
        int n = this.m_table.GetTableEntryIndex(this.m_entry);
        this.m_table.RemoveTableEntry(n);
        int n2 = this.m_table.GetNumberOfTableEntries();
        if (n2 == 0) {
            this.m_menu.RefreshInformation();
            if (s_activeTableEditors == 1) {
                this.m_menu.EnableMenuItemsAfterEditing();
            }
            --s_activeTableEditors;
            String string = this.m_table.GetTableName();
            this.m_menu.EnableTableMenuItem(string);
            this.dispose();
        } else {
            if (n == n2) {
                --n;
            }
            this.m_entry = this.m_table.GetTableEntry(n);
            this.EditCurrentTableEntry();
        }
    }

    private void TableEntryOperationActionPerformed(ActionEvent actionEvent) {
        this.m_entry.SetOperation((String)this.ui_tableEntryOperation.getSelectedItem());
    }

    private void exitForm(WindowEvent windowEvent) {
        if (!this.MandatoryParametersValidation()) {
            return;
        }
        this.m_menu.RefreshInformation();
        if (s_activeTableEditors == 1) {
            this.m_menu.EnableMenuItemsAfterEditing();
        }
        --s_activeTableEditors;
        String string = this.m_table.GetTableName();
        this.m_menu.EnableTableMenuItem(string);
        this.dispose();
    }

    public void EditCurrentTableEntry() {
        if (this.m_entry == null) {
            return;
        }
        int n = this.m_table.GetTableEntryIndex(this.m_entry) + 1;
        int n2 = this.m_table.GetNumberOfTableEntries();
        if (n2 == this.m_maxEntriesAllowed) {
            this.ui_addButton.setEnabled(false);
        } else {
            this.ui_addButton.setEnabled(true);
        }
        if (n == n2) {
            this.ui_nextButton.setEnabled(false);
        } else {
            this.ui_nextButton.setEnabled(true);
        }
        if (n == 1) {
            this.ui_previousButton.setEnabled(false);
        } else {
            this.ui_previousButton.setEnabled(true);
        }
        this.ui_props = new JTable();
        PropertiesTableModel propertiesTableModel = new PropertiesTableModel(this.m_entry);
        this.ui_props.setModel(propertiesTableModel);
        TableTemplate tableTemplate = this.m_entry.GetTableTemplate();
        PropertiesCellEditor propertiesCellEditor = new PropertiesCellEditor(this.m_menu.GetDatabase(), tableTemplate);
        this.ui_props.getColumnModel().getColumn(1).setCellEditor(propertiesCellEditor);
        TableColumn tableColumn = this.ui_props.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new PropertiesCellRenderer(tableTemplate));
        this.ui_props.setBackground(new Color(250, 250, 250));
        this.ui_props.setForeground(new Color(0, 0, 150));
        this.ui_props.setGridColor(new Color(0, 0, 0));
        this.ui_props.setFont(new Font("Arial", 1, 12));
        this.ui_props.getTableHeader().setFont(new Font("Arial", 1, 12));
        this.ui_props.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.ui_props.setShowGrid(true);
        this.ui_props.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.ui_props.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.ui_props.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.ui_propertiesList.setViewportView(this.ui_props);
        this.ui_propertiesList.setHorizontalScrollBarPolicy(30);
        this.ui_propertiesList.setVerticalScrollBarPolicy(20);
        this.ui_tableEntryCounter.setText(n + " / " + n2);
        this.ui_tableEntryOperation.setSelectedItem(this.m_entry.GetOperation());
    }

    private boolean MandatoryParametersValidation() {
        if (this.m_entry == null) {
            return true;
        }
        boolean bl = this.m_entry.MandatoryParametersValid();
        if (bl) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "Some mandatory parameters have no values\nFurther editing of this table entry is required", "Mandatory Parameters Missing Error", 2);
        return false;
    }
}

