/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.commdb.convert;

import com.symbian.commdb.data.Database;
import com.symbian.commdb.data.DatabaseException;
import com.symbian.commdb.data.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JProgressBar;

public class cfg2xml {
    private static Database commdb;
    private static boolean fileMode;

    public static void main(String[] stringArray) {
        Serializable serializable;
        cfg2xml.PrintTitle();
        if (stringArray.length < 3) {
            System.out.println("ERROR: Missing arguments");
            cfg2xml.ShowOptions();
            System.exit(-2);
        }
        if (stringArray[0].equals("-mode:file")) {
            fileMode = true;
            System.out.println("- Operating in file mode");
        } else if (stringArray[0].equals("-mode:dir")) {
            fileMode = false;
            System.out.println("- Operating in directory mode");
        } else {
            System.out.println("ERROR: Missing or wrong -mode option specified");
            System.exit(-1);
        }
        String string = stringArray[2];
        String string2 = null;
        if (fileMode) {
            int n = string.toUpperCase().indexOf(".CFG");
            if (n != -1) {
                if (stringArray.length == 3) {
                    string2 = string.substring(0, n) + ".xml";
                    System.out.println("- The output XML file will be named: " + string2);
                } else {
                    string2 = stringArray[3];
                    n = string2.toUpperCase().indexOf(".XML");
                    if (n == -1) {
                        System.out.println("ERROR: Output file is not a .xml file");
                        System.exit(-1);
                    }
                }
            } else {
                System.out.println("ERROR: Input file is not a .cfg file");
                System.exit(-1);
            }
        }
        commdb = new Database(stringArray[1]);
        try {
            System.out.println("- Reading CommDB contents");
            commdb.ReadContents();
        }
        catch (DatabaseException databaseException) {
            System.out.println("ERROR: CommDB Database Creation Error");
            System.out.println("MESSAGE: " + databaseException.GetErrorMessage());
            System.exit(-3);
        }
        try {
            System.out.println("- Reading CommDB XML Schema files");
            serializable = new JProgressBar();
            commdb.BuildTableTemplates((JProgressBar)serializable);
        }
        catch (DatabaseException databaseException) {
            System.out.println("ERROR: Import CommDB Database Error");
            System.out.println("MESSAGE: " + databaseException.GetErrorMessage());
            System.exit(-4);
        }
        if (fileMode) {
            try {
                System.out.println("- Performing conversion");
                cfg2xml.ConvertFile(string, string2);
            }
            catch (Exception exception) {
                System.exit(-5);
            }
        } else {
            serializable = new File(stringArray[2]);
            if (serializable == null) {
                System.out.println("ERROR: Cannot open the input directory");
                System.exit(-1);
            }
            if (!((File)serializable).isDirectory()) {
                System.out.println("ERROR: The specified input directory is not a directory");
                System.exit(-1);
            }
            cfg2xml.ConvertDirectory((File)serializable);
        }
        System.out.println("- Succesfull termination");
        System.exit(0);
    }

    private static void PrintTitle() {
        System.out.println();
        System.out.println("CommDB Configuration File Conversion Utility");
        System.out.println("Version 1.2 [Release] Build 20031126");
        System.out.println("using the CommDB Editor XML Processing Engine");
        System.out.println("Version " + Version.GetVersion());
        System.out.println("Copyright (C) 2003, Symbian Ltd. All Rights Reserved.");
        System.out.println();
    }

    private static void ShowOptions() {
        System.out.println();
        System.out.println("The purpose of this utility is to convert one or more CommDB");
        System.out.println("settings files of the CFG format (*.cfg) to the XML format (*.xml)");
        System.out.println("The utility should be executed as:");
        System.out.println();
        System.out.println("java -jar cfg2xml.jar -mode:[file|dir] schema-dir in [out]");
        System.out.println();
        System.out.println("where:");
        System.out.println();
        System.out.println("-mode:[file|dir] - specifies whether the utility should process");
        System.out.println("                   a single file (-mode:file) or a directory with");
        System.out.println("                   a number of .cfg files (-mode:dir)");
        System.out.println("schema-dir       - the directory which contains the XML Schema");
        System.out.println("                   files which define the version of CommDB");
        System.out.println("                   appropriate for the settings file to convert");
        System.out.println("in               - The file in the pre-XML format (*.cfg) to convert,");
        System.out.println("                   if -mode:file is specified, else the directory");
        System.out.println("                   which contains .cfg files to convert. When operating");
        System.out.println("                   in directory mode this utility will also process all");
        System.out.println("                   subdirectories and their contents for .cfg files");
        System.out.println("out              - The XML settings file (.xml) to generate as the result");
        System.out.println("                   of the conversion process. This parameter can be");
        System.out.println("                   supplied only if the utility operates in file mode");
        System.out.println("                   (-mode:file). If not specified, the converted file");
        System.out.println("                   has the same name as the original .cfg one");
        System.out.println();
    }

    private static void ConvertFile(String string, String string2) throws DatabaseException, FileNotFoundException, IOException {
        try {
            commdb.EraseTableEntries();
            commdb.ImportOldDatabase(string);
        }
        catch (DatabaseException databaseException) {
            System.out.println("ERROR: Import CFG File Error");
            System.out.println("MESSAGE: " + databaseException.GetErrorMessage());
        }
        File file = new File(string2);
        try {
            commdb.ExportDatabase(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: Export to XML Error");
            System.out.println("MESSAGE: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("ERROR: Export to XML Error");
            System.out.println("MESSAGE: " + iOException.getMessage());
        }
    }

    private static void ConvertDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile()) {
                String string = null;
                try {
                    string = file2.getCanonicalFile().toString();
                }
                catch (IOException iOException) {
                    continue;
                }
                int n = string.toUpperCase().indexOf(".CFG");
                if (n == -1) continue;
                String string2 = string.substring(0, n) + ".xml";
                System.out.println("- Converting file: " + string + " to file: " + string2);
                try {
                    cfg2xml.ConvertFile(string, string2);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!file2.isDirectory()) continue;
            cfg2xml.ConvertDirectory(file2);
        }
    }
}

