/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 */
 
#ifndef VIDEOTIMINGS_H
#define VIDEOTIMINGS_H

// INCLUDES

#include <e32std.h>
#include <tvoutconfigdef.h>

// DATA TYPES

/** Output mode types */
enum TTimingModeType
    {
    ETimingModeCEA = 0,
    ETimingModeDMT,
    };
    
/** Sync polarity */
enum TSyncPolarity
    {
    ESyncPolarityNegative = 0,
    ESyncPolarityPositive,
    };

/** Timing item */
struct TTimingItem
    {
    TUint8  iTimingType;      // Timing mode type
    TUint16 iTimingId;        // Timing mode id
    const TText* const iTimingName; // Timing mode name
    TBool   iInterlaced;    // Interlaced or progressive
    TUint16 iWidth;         // Resolution, width
    TUint16 iHeight;        // Resolution, height
    TUint16 iDotClock;      // Pixel clock [kHz]
    TUint8  iPixelRepeat;   // Pixel repeat
    TUint16 iLineRate;      // Line rate [kHz]
    TUint16 iFrameRate;     // Frame rate [Hz]
    TUint16 iFieldRate;     // Field rate [Hz]
    TTvSettings::TAspectRatio iAspectRatio; // Aspect ratio [4d3 or 16d9]
    TUint16 iPixelAspectRatioNumerator;  //PAR Numerator
    TUint16 iPixelAspectRatioDenominator;  //PAR Denominator
    TUint16 iHorizontalFrontPorch; // Horizontal front porch
    TUint16 iHorizontalSync; // Horizontal sync
    TUint16 iHorizontalBackPorch; // Horizontal back porch
    TUint16 iHorizontalBlanking; // Horizontal blanking
    TUint16 iHorizontalActive; // Horizontal active pixels
    TUint16 iHorizontalTotal; // Horizontal total pixels
    TUint16 iVertical1stFrontPorch; // Vertical1st front porch
    TUint16 iVertical1stSync; // Vertical1st sync
    TUint16 iVertical1stBackPorch; // Vertical1st back porch
    TUint16 iVertical1stBlanking; // Vertical1st blanking
    TUint16 iVertical1stActive; // Vertical1st active lines
    TUint16 iVertical1stTotal; // Vertical1st total lines
    TUint16 iVertical2ndFrontPorch; // Vertical2nd front porch
    TUint16 iVertical2ndSync; // Vertical2nd sync
    TUint16 iVertical2ndBackPorch; // Vertical2nd back porch
    TUint16 iVertical2ndBlanking; // Vertical2nd blanking
    TUint16 iVertical2ndActive; // Vertical2nd active lines
    TUint16 iVertical2ndTotal; // Vertical2nd total lines
    TUint16 iFrameTimingBlanking; // Frame timing blanking
    TUint16 iFrameTimingActive; // Frame timing active lines
    TUint16 iFrameTimingTotal; // Frame timing total lines
    TSyncPolarity iHorizontalSyncPolarity; // Horizontal sync polarity
    TSyncPolarity iVerticalSyncPolarity; // Vertical sync polarity
    };

/** CEA timings */
const TTimingItem KCEATimings[] =
    {
	// Timing for CEA mode: 1
		{
		ETimingModeCEA,
		1,
		_S( "640x480p @ 59.94 Hz" ),
		EFalse,
		640,
		480,
		25175,
		1,
		31,
		60,
		60,
		TTvSettings::E4d3,
		1,
		1,
		16,
		96,
		48,
		160,
		640,
		800,
		100,
		2,
		330,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 2
		{
		ETimingModeCEA,
		2,
		_S( "720x480p @ 59.94 Hz" ),
		EFalse,
		720,
		480,
		27000,
		1,
		31,
		60,
		60,
		TTvSettings::E4d3,
		8,
		9,
		16,
		62,
		60,
		138,
		720,
		858,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 3
		{
		ETimingModeCEA,
		3,
		_S( "720x480p @ 59.94 Hz" ),
		EFalse,
		720,
		480,
		27000,
		1,
		31,
		60,
		60,
		TTvSettings::E16d9,
		32,
		27,
		16,
		62,
		60,
		138,
		720,
		858,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 4
		{
		ETimingModeCEA,
		4,
		_S( "1280x720p @ 60.00 Hz" ),
		EFalse,
		1280,
		720,
		74250,
		1,
		45,
		60,
		60,
		TTvSettings::E16d9,
		1,
		1,
		110,
		40,
		220,
		370,
		1280,
		1650,
		50,
		5,
		200,
		30,
		720,
		750,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		720,
		750,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 5
		{
		ETimingModeCEA,
		5,
		_S( "1920x1080i @ 60.00 Hz" ),
		ETrue,
		1920,
		1080,
		74250,
		1,
		34,
		30,
		60,
		TTvSettings::E16d9,
		1,
		1,
		88,
		44,
		148,
		280,
		1920,
		2200,
		20,
		5,
		150,
		22,
		540,
		562,
		25,
		5,
		155,
		23,
		540,
		563,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 6
		{
		ETimingModeCEA,
		6,
		_S( "720(1440)x480i @ 59.94 Hz" ),
		ETrue,
		720,
		480,
		27000,
		2,
		16,
		30,
		60,
		TTvSettings::E4d3,
		8,
		9,
		38,
		124,
		114,
		276,
		1440,
		1716,
		40,
		3,
		150,
		22,
		240,
		262,
		45,
		3,
		155,
		23,
		240,
		263,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 7
		{
		ETimingModeCEA,
		7,
		_S( "720(1440)x480i @ 59.94 Hz" ),
		ETrue,
		720,
		480,
		27000,
		2,
		16,
		30,
		60,
		TTvSettings::E16d9,
		32,
		27,
		38,
		124,
		114,
		276,
		1440,
		1716,
		40,
		3,
		150,
		22,
		240,
		262,
		45,
		3,
		155,
		23,
		240,
		263,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 8
		{
		ETimingModeCEA,
		8,
		_S( "720(1440)x240p @ 60.05 Hz" ),
		EFalse,
		720,
		240,
		27000,
		2,
		16,
		60,
		60,
		TTvSettings::E4d3,
		8,
		9,
		38,
		124,
		114,
		276,
		1440,
		1716,
		40,
		3,
		150,
		22,
		240,
		262,
		0,
		0,
		0,
		0,
		0,
		0,
		22,
		240,
		262,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 9
		{
		ETimingModeCEA,
		9,
		_S( "720(1440)x240p @ 60.05 Hz" ),
		EFalse,
		720,
		240,
		27000,
		2,
		16,
		60,
		60,
		TTvSettings::E16d9,
		32,
		27,
		38,
		124,
		114,
		276,
		1440,
		1716,
		40,
		3,
		150,
		22,
		240,
		262,
		0,
		0,
		0,
		0,
		0,
		0,
		22,
		240,
		262,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 10
		{
		ETimingModeCEA,
		10,
		_S( "720(2880)x480i @ 59.94 Hz" ),
		ETrue,
		720,
		480,
		54000,
		4,
		16,
		30,
		60,
		TTvSettings::E4d3,
		8,
		9,
		76,
		248,
		228,
		552,
		2880,
		3432,
		40,
		3,
		150,
		22,
		240,
		262,
		45,
		3,
		155,
		23,
		240,
		263,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 11
		{
		ETimingModeCEA,
		11,
		_S( "720(2880)x480i @ 59.94 Hz" ),
		ETrue,
		720,
		480,
		54000,
		4,
		16,
		30,
		60,
		TTvSettings::E16d9,
		32,
		27,
		76,
		248,
		228,
		552,
		2880,
		3432,
		40,
		3,
		150,
		22,
		240,
		262,
		45,
		3,
		155,
		23,
		240,
		263,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 12
		{
		ETimingModeCEA,
		12,
		_S( "720(2880)x240p @ 60.05 Hz" ),
		EFalse,
		720,
		240,
		54000,
		4,
		16,
		60,
		60,
		TTvSettings::E4d3,
		4,
		9,
		76,
		248,
		228,
		552,
		2880,
		3432,
		40,
		3,
		150,
		22,
		240,
		262,
		0,
		0,
		0,
		0,
		0,
		0,
		22,
		240,
		262,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 13
		{
		ETimingModeCEA,
		13,
		_S( "720(2880)x240p @ 60.05 Hz" ),
		EFalse,
		720,
		240,
		54000,
		4,
		16,
		60,
		60,
		TTvSettings::E16d9,
		16,
		27,
		76,
		248,
		228,
		552,
		2880,
		3432,
		40,
		3,
		150,
		22,
		240,
		262,
		0,
		0,
		0,
		0,
		0,
		0,
		22,
		240,
		262,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 14
		{
		ETimingModeCEA,
		14,
		_S( "720(1440)x480p @ 59.94 Hz" ),
		EFalse,
		720,
		480,
		54000,
		2,
		31,
		60,
		60,
		TTvSettings::E4d3,
		8,
		9,
		32,
		124,
		120,
		276,
		1440,
		1716,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 15
		{
		ETimingModeCEA,
		15,
		_S( "720(1440)x480p @ 59.94 Hz" ),
		EFalse,
		720,
		480,
		54000,
		2,
		31,
		60,
		60,
		TTvSettings::E16d9,
		32,
		27,
		32,
		124,
		120,
		276,
		1440,
		1716,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 16
		{
		ETimingModeCEA,
		16,
		_S( "1920x1080p @ 60.00 Hz" ),
		EFalse,
		1920,
		1080,
		148500,
		1,
		68,
		60,
		60,
		TTvSettings::E16d9,
		1,
		1,
		88,
		44,
		148,
		280,
		1920,
		2200,
		40,
		5,
		360,
		45,
		1080,
		1125,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 17
		{
		ETimingModeCEA,
		17,
		_S( "720x576p @ 50.00 Hz" ),
		EFalse,
		720,
		576,
		27000,
		1,
		31,
		50,
		50,
		TTvSettings::E4d3,
		16,
		15,
		12,
		64,
		68,
		144,
		720,
		864,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 18
		{
		ETimingModeCEA,
		18,
		_S( "720x576p @ 50.00 Hz" ),
		EFalse,
		720,
		576,
		27000,
		1,
		31,
		50,
		50,
		TTvSettings::E16d9,
		64,
		45,
		12,
		64,
		68,
		144,
		720,
		864,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 19
		{
		ETimingModeCEA,
		19,
		_S( "1280x720p @ 50.00 Hz" ),
		EFalse,
		1280,
		720,
		74250,
		1,
		38,
		50,
		50,
		TTvSettings::E16d9,
		1,
		1,
		440,
		40,
		220,
		700,
		1280,
		1980,
		50,
		5,
		200,
		30,
		720,
		750,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		720,
		750,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 20
		{
		ETimingModeCEA,
		20,
		_S( "1920x1080i @ 50.00 Hz" ),
		ETrue,
		1920,
		1080,
		74250,
		1,
		28,
		25,
		50,
		TTvSettings::E16d9,
		1,
		1,
		528,
		44,
		148,
		720,
		1920,
		2640,
		20,
		5,
		150,
		22,
		540,
		562,
		25,
		5,
		155,
		23,
		540,
		563,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 21
		{
		ETimingModeCEA,
		21,
		_S( "720(1440)x576i @ 50.00 Hz" ),
		ETrue,
		720,
		576,
		27000,
		2,
		16,
		25,
		50,
		TTvSettings::E4d3,
		16,
		15,
		24,
		126,
		138,
		288,
		1440,
		1728,
		20,
		3,
		190,
		24,
		288,
		312,
		25,
		3,
		195,
		25,
		288,
		313,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 22
		{
		ETimingModeCEA,
		22,
		_S( "720(1440)x576i @ 50.00 Hz" ),
		ETrue,
		720,
		576,
		27000,
		2,
		16,
		25,
		50,
		TTvSettings::E16d9,
		64,
		45,
		24,
		126,
		138,
		288,
		1440,
		1728,
		20,
		3,
		190,
		24,
		288,
		312,
		25,
		3,
		195,
		25,
		288,
		313,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 23
		{
		ETimingModeCEA,
		23,
		_S( "720(1440)x288p @ 50.08 Hz" ),
		EFalse,
		720,
		288,
		27000,
		2,
		16,
		50,
		50,
		TTvSettings::E4d3,
		8,
		15,
		24,
		126,
		138,
		288,
		1440,
		1728,
		20,
		3,
		190,
		24,
		288,
		312,
		0,
		0,
		0,
		0,
		0,
		0,
		24,
		288,
		312,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 24
		{
		ETimingModeCEA,
		24,
		_S( "720(1440)x288p @ 50.08 Hz" ),
		EFalse,
		720,
		288,
		27000,
		2,
		16,
		50,
		50,
		TTvSettings::E16d9,
		32,
		45,
		24,
		126,
		138,
		288,
		1440,
		1728,
		20,
		3,
		190,
		24,
		288,
		312,
		0,
		0,
		0,
		0,
		0,
		0,
		24,
		288,
		312,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 25
		{
		ETimingModeCEA,
		25,
		_S( "720(2880)x576i @ 50.00 Hz" ),
		ETrue,
		720,
		576,
		54000,
		4,
		16,
		25,
		50,
		TTvSettings::E4d3,
		16,
		15,
		48,
		252,
		276,
		576,
		2880,
		3456,
		20,
		3,
		190,
		24,
		288,
		312,
		25,
		3,
		195,
		25,
		288,
		313,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 26
		{
		ETimingModeCEA,
		26,
		_S( "720(2880)x576i @ 50.00 Hz" ),
		ETrue,
		720,
		576,
		54000,
		4,
		16,
		25,
		50,
		TTvSettings::E16d9,
		64,
		45,
		48,
		252,
		276,
		576,
		2880,
		3456,
		20,
		3,
		190,
		24,
		288,
		312,
		25,
		3,
		195,
		25,
		288,
		313,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 27
		{
		ETimingModeCEA,
		27,
		_S( "720(2880)x288p @ 50.08 Hz" ),
		EFalse,
		720,
		288,
		54000,
		4,
		16,
		50,
		50,
		TTvSettings::E4d3,
		8,
		15,
		48,
		252,
		276,
		576,
		2880,
		3456,
		20,
		3,
		190,
		24,
		288,
		312,
		0,
		0,
		0,
		0,
		0,
		0,
		24,
		288,
		312,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 28
		{
		ETimingModeCEA,
		28,
		_S( "720(2880)x288p @ 50.08 Hz" ),
		EFalse,
		720,
		288,
		54000,
		4,
		16,
		50,
		50,
		TTvSettings::E16d9,
		32,
		45,
		48,
		252,
		276,
		576,
		2880,
		3456,
		20,
		3,
		190,
		24,
		288,
		312,
		0,
		0,
		0,
		0,
		0,
		0,
		24,
		288,
		312,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 29
		{
		ETimingModeCEA,
		29,
		_S( "720(1440)x576p @ 50.00 Hz" ),
		EFalse,
		720,
		576,
		54000,
		2,
		31,
		50,
		50,
		TTvSettings::E4d3,
		16,
		15,
		24,
		128,
		136,
		288,
		1440,
		1728,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 30
		{
		ETimingModeCEA,
		30,
		_S( "720(1440)x576p @ 50.00 Hz" ),
		EFalse,
		720,
		576,
		54000,
		2,
		31,
		50,
		50,
		TTvSettings::E16d9,
		64,
		45,
		24,
		128,
		136,
		288,
		1440,
		1728,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 31
		{
		ETimingModeCEA,
		31,
		_S( "1920x1080p @ 50.00 Hz" ),
		EFalse,
		1920,
		1080,
		148500,
		1,
		56,
		50,
		50,
		TTvSettings::E16d9,
		1,
		1,
		528,
		44,
		148,
		720,
		1920,
		2640,
		40,
		5,
		360,
		45,
		1080,
		1125,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 32
		{
		ETimingModeCEA,
		32,
		_S( "1920x1080p @ 24.00 Hz" ),
		EFalse,
		1920,
		1080,
		74250,
		1,
		27,
		24,
		24,
		TTvSettings::E16d9,
		1,
		1,
		638,
		44,
		148,
		830,
		1920,
		2750,
		40,
		5,
		360,
		45,
		1080,
		1125,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 33
		{
		ETimingModeCEA,
		33,
		_S( "1920x1080p @ 25.00 Hz" ),
		EFalse,
		1920,
		1080,
		74250,
		1,
		28,
		25,
		25,
		TTvSettings::E16d9,
		1,
		1,
		528,
		44,
		148,
		720,
		1920,
		2640,
		40,
		5,
		360,
		45,
		1080,
		1125,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 34
		{
		ETimingModeCEA,
		34,
		_S( "1920x1080p @ 30.00 Hz" ),
		EFalse,
		1920,
		1080,
		74250,
		1,
		34,
		30,
		30,
		TTvSettings::E16d9,
		1,
		1,
		88,
		44,
		148,
		280,
		1920,
		2200,
		40,
		5,
		360,
		45,
		1080,
		1125,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 35
		{
		ETimingModeCEA,
		35,
		_S( "720(2880)x480p @ 59.94 Hz" ),
		EFalse,
		720,
		480,
		108000,
		4,
		31,
		60,
		60,
		TTvSettings::E4d3,
		8,
		9,
		64,
		248,
		240,
		552,
		2880,
		3432,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 36
		{
		ETimingModeCEA,
		36,
		_S( "720(2880)x480p @ 59.94 Hz" ),
		EFalse,
		720,
		480,
		108000,
		4,
		31,
		60,
		60,
		TTvSettings::E16d9,
		32,
		27,
		64,
		248,
		240,
		552,
		2880,
		3432,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 37
		{
		ETimingModeCEA,
		37,
		_S( "720(2880)x576p @ 50.00 Hz" ),
		EFalse,
		720,
		576,
		108000,
		4,
		31,
		50,
		50,
		TTvSettings::E4d3,
		16,
		15,
		48,
		256,
		272,
		576,
		2880,
		3456,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 38
		{
		ETimingModeCEA,
		38,
		_S( "720(2880)x576p @ 50.00 Hz" ),
		EFalse,
		720,
		576,
		108000,
		4,
		31,
		50,
		50,
		TTvSettings::E16d9,
		64,
		45,
		48,
		256,
		272,
		576,
		2880,
		3456,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 39
		{
		ETimingModeCEA,
		39,
		_S( "1920x1080i @ 50.00 Hz" ),
		ETrue,
		1920,
		1080,
		72000,
		1,
		31,
		25,
		50,
		TTvSettings::E16d9,
		1,
		1,
		32,
		168,
		184,
		384,
		1920,
		2304,
		230,
		5,
		570,
		85,
		540,
		625,
		230,
		5,
		570,
		85,
		540,
		625,
		170,
		1080,
		1250,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 40
		{
		ETimingModeCEA,
		40,
		_S( "1920x1080i @ 100.00 Hz" ),
		ETrue,
		1920,
		1080,
		148500,
		1,
		56,
		50,
		100,
		TTvSettings::E16d9,
		1,
		1,
		528,
		44,
		148,
		720,
		1920,
		2640,
		20,
		5,
		150,
		22,
		540,
		562,
		25,
		5,
		155,
		23,
		540,
		563,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 41
		{
		ETimingModeCEA,
		41,
		_S( "1280x720p @ 100.00 Hz" ),
		EFalse,
		1280,
		720,
		148500,
		1,
		75,
		100,
		100,
		TTvSettings::E16d9,
		1,
		1,
		440,
		40,
		220,
		700,
		1280,
		1980,
		50,
		5,
		200,
		30,
		720,
		750,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		720,
		750,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 42
		{
		ETimingModeCEA,
		42,
		_S( "720x576p @ 100.00 Hz" ),
		EFalse,
		720,
		576,
		54000,
		1,
		63,
		100,
		100,
		TTvSettings::E4d3,
		16,
		15,
		12,
		64,
		68,
		144,
		720,
		864,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 43
		{
		ETimingModeCEA,
		43,
		_S( "720x576p @ 100.00 Hz" ),
		EFalse,
		720,
		576,
		54000,
		1,
		63,
		100,
		100,
		TTvSettings::E16d9,
		64,
		45,
		12,
		64,
		68,
		144,
		720,
		864,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 44
		{
		ETimingModeCEA,
		44,
		_S( "720(1440)x576i @ 100.00 Hz" ),
		ETrue,
		720,
		576,
		54000,
		2,
		31,
		50,
		100,
		TTvSettings::E4d3,
		16,
		15,
		24,
		126,
		138,
		288,
		1440,
		1728,
		20,
		3,
		190,
		24,
		288,
		312,
		25,
		3,
		195,
		25,
		288,
		313,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 45
		{
		ETimingModeCEA,
		45,
		_S( "720(1440)x576i @ 100.00 Hz" ),
		ETrue,
		720,
		576,
		54000,
		2,
		31,
		50,
		100,
		TTvSettings::E16d9,
		64,
		45,
		24,
		126,
		138,
		288,
		1440,
		1728,
		20,
		3,
		190,
		24,
		288,
		312,
		25,
		3,
		195,
		25,
		288,
		313,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 46
		{
		ETimingModeCEA,
		46,
		_S( "1920x1080i @ 120.00 Hz" ),
		ETrue,
		1920,
		1080,
		148500,
		1,
		68,
		60,
		120,
		TTvSettings::E16d9,
		1,
		1,
		88,
		44,
		148,
		280,
		1920,
		2200,
		20,
		5,
		150,
		22,
		540,
		562,
		25,
		5,
		155,
		23,
		540,
		563,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 47
		{
		ETimingModeCEA,
		47,
		_S( "1280x720p @ 120.00 Hz" ),
		EFalse,
		1280,
		720,
		148500,
		1,
		90,
		120,
		120,
		TTvSettings::E16d9,
		1,
		1,
		110,
		40,
		220,
		370,
		1280,
		1650,
		50,
		5,
		200,
		30,
		720,
		750,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		720,
		750,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 48
		{
		ETimingModeCEA,
		48,
		_S( "720x480p @ 119.88 Hz" ),
		EFalse,
		720,
		480,
		54000,
		1,
		63,
		120,
		120,
		TTvSettings::E4d3,
		8,
		9,
		16,
		62,
		60,
		138,
		720,
		858,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 49
		{
		ETimingModeCEA,
		49,
		_S( "720x480p @ 119.88 Hz" ),
		EFalse,
		720,
		480,
		54000,
		1,
		63,
		120,
		120,
		TTvSettings::E16d9,
		32,
		27,
		16,
		62,
		60,
		138,
		720,
		858,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 50
		{
		ETimingModeCEA,
		50,
		_S( "720(1440)x480i @ 119.88 Hz" ),
		ETrue,
		720,
		480,
		54000,
		2,
		31,
		60,
		120,
		TTvSettings::E4d3,
		8,
		9,
		38,
		124,
		114,
		276,
		1440,
		1716,
		40,
		3,
		150,
		22,
		240,
		262,
		45,
		3,
		155,
		23,
		240,
		263,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 51
		{
		ETimingModeCEA,
		51,
		_S( "720(1440)x480i @ 119.88 Hz" ),
		ETrue,
		720,
		480,
		54000,
		2,
		31,
		60,
		120,
		TTvSettings::E16d9,
		32,
		27,
		38,
		124,
		114,
		276,
		1440,
		1716,
		40,
		3,
		150,
		22,
		240,
		262,
		45,
		3,
		155,
		23,
		240,
		263,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 52
		{
		ETimingModeCEA,
		52,
		_S( "720X576p @ 200.00 Hz" ),
		EFalse,
		720,
		576,
		108000,
		1,
		125,
		200,
		200,
		TTvSettings::E4d3,
		16,
		15,
		12,
		64,
		68,
		144,
		720,
		864,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 53
		{
		ETimingModeCEA,
		53,
		_S( "720X576p @ 200.00 Hz" ),
		EFalse,
		720,
		576,
		108000,
		1,
		125,
		200,
		200,
		TTvSettings::E16d9,
		64,
		45,
		12,
		64,
		68,
		144,
		720,
		864,
		50,
		5,
		390,
		49,
		576,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 54
		{
		ETimingModeCEA,
		54,
		_S( "720(1440)x576i @ 200.00 Hz" ),
		ETrue,
		720,
		576,
		108000,
		2,
		63,
		100,
		200,
		TTvSettings::E4d3,
		16,
		15,
		24,
		126,
		138,
		288,
		1440,
		1728,
		20,
		3,
		190,
		24,
		288,
		312,
		25,
		3,
		195,
		25,
		288,
		313,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 55
		{
		ETimingModeCEA,
		55,
		_S( "720(1440)x576i @ 200.00 Hz" ),
		ETrue,
		720,
		576,
		108000,
		2,
		63,
		100,
		200,
		TTvSettings::E16d9,
		64,
		45,
		24,
		126,
		138,
		288,
		1440,
		1728,
		20,
		3,
		190,
		24,
		288,
		312,
		25,
		3,
		195,
		25,
		288,
		313,
		49,
		576,
		625,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 56
		{
		ETimingModeCEA,
		56,
		_S( "720x480p @ 239.76 Hz" ),
		EFalse,
		720,
		480,
		108000,
		1,
		126,
		240,
		240,
		TTvSettings::E4d3,
		8,
		9,
		16,
		62,
		60,
		138,
		720,
		858,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 57
		{
		ETimingModeCEA,
		57,
		_S( "720x480p @ 239.76 Hz" ),
		EFalse,
		720,
		480,
		108000,
		1,
		126,
		240,
		240,
		TTvSettings::E16d9,
		32,
		27,
		16,
		62,
		60,
		138,
		720,
		858,
		90,
		6,
		300,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 58
		{
		ETimingModeCEA,
		58,
		_S( "720(1440)x480i @ 239.76 Hz" ),
		ETrue,
		720,
		480,
		108000,
		2,
		63,
		120,
		240,
		TTvSettings::E4d3,
		8,
		9,
		38,
		124,
		114,
		276,
		1440,
		1716,
		40,
		3,
		150,
		22,
		240,
		262,
		45,
		3,
		155,
		23,
		240,
		263,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 59
		{
		ETimingModeCEA,
		59,
		_S( "720(1440)x480i @ 239.76 Hz" ),
		ETrue,
		720,
		480,
		108000,
		2,
		63,
		120,
		240,
		TTvSettings::E16d9,
		32,
		27,
		38,
		124,
		114,
		276,
		1440,
		1716,
		40,
		3,
		150,
		22,
		240,
		262,
		45,
		3,
		155,
		23,
		240,
		263,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for CEA mode: 60
		{
		ETimingModeCEA,
		60,
		_S( "1280x720p @ 24.00 Hz" ),
		EFalse,
		1280,
		720,
		59400,
		1,
		18,
		24,
		24,
		TTvSettings::E16d9,
		1,
		1,
		1760,
		40,
		220,
		2020,
		1280,
		3300,
		50,
		5,
		200,
		30,
		720,
		750,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		720,
		750,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 61
		{
		ETimingModeCEA,
		61,
		_S( "1280x720p @ 25.00 Hz" ),
		EFalse,
		1280,
		720,
		74250,
		1,
		19,
		25,
		25,
		TTvSettings::E16d9,
		1,
		1,
		2420,
		40,
		220,
		2680,
		1280,
		3960,
		50,
		5,
		200,
		30,
		720,
		750,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		720,
		750,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 62
		{
		ETimingModeCEA,
		62,
		_S( "1280x720p @ 30.00 Hz" ),
		EFalse,
		1280,
		720,
		74250,
		1,
		23,
		30,
		30,
		TTvSettings::E16d9,
		1,
		1,
		1760,
		40,
		220,
		2020,
		1280,
		3300,
		50,
		5,
		200,
		30,
		720,
		750,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		720,
		750,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 63
		{
		ETimingModeCEA,
		63,
		_S( "1920x1080p @ 120.00 Hz" ),
		EFalse,
		1920,
		1080,
		297000,
		1,
		135,
		120,
		120,
		TTvSettings::E16d9,
		1,
		1,
		88,
		44,
		148,
		280,
		1920,
		2200,
		40,
		5,
		360,
		45,
		1080,
		1125,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for CEA mode: 64
		{
		ETimingModeCEA,
		64,
		_S( "1920x1080p @ 100.00 Hz" ),
		EFalse,
		1920,
		1080,
		297000,
		1,
		113,
		100,
		100,
		TTvSettings::E16d9,
		1,
		1,
		528,
		44,
		148,
		720,
		1920,
		2640,
		40,
		5,
		360,
		45,
		1080,
		1125,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
    };

/** CEA timings list count */
const TInt KCEATimingCount = sizeof( KCEATimings ) / sizeof( KCEATimings[0] );

/** DMT timings */
const TTimingItem KDMTTimings[] =
    {
	// Timing for DMT mode: 1
		{
		ETimingModeDMT,
		1,
		_S( "640x350p @ 85.08 Hz" ),
		EFalse,
		640,
		350,
		31500,
		1,
		38,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		32,
		64,
		96,
		192,
		640,
		832,
		320,
		3,
		600,
		95,
		350,
		445,
		0,
		0,
		0,
		0,
		0,
		0,
		95,
		350,
		445,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 2
		{
		ETimingModeDMT,
		2,
		_S( "640x400p @ 85.08 Hz" ),
		EFalse,
		640,
		400,
		31500,
		1,
		38,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		32,
		64,
		96,
		192,
		640,
		832,
		10,
		3,
		410,
		45,
		400,
		445,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		400,
		445,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 3
		{
		ETimingModeDMT,
		3,
		_S( "720x400p @ 85.04 Hz" ),
		EFalse,
		720,
		400,
		35500,
		1,
		38,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		36,
		72,
		108,
		216,
		720,
		936,
		10,
		3,
		420,
		46,
		400,
		446,
		0,
		0,
		0,
		0,
		0,
		0,
		46,
		400,
		446,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 4
		{
		ETimingModeDMT,
		4,
		_S( "640x480p @ 59.94 Hz" ),
		EFalse,
		640,
		480,
		25175,
		1,
		31,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		16,
		96,
		48,
		160,
		640,
		800,
		100,
		2,
		330,
		45,
		480,
		525,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		480,
		525,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 5
		{
		ETimingModeDMT,
		5,
		_S( "640x480p @ 72.81 Hz" ),
		EFalse,
		640,
		480,
		31500,
		1,
		38,
		73,
		73,
		TTvSettings::EUndefRatio,
		1,
		1,
		24,
		40,
		128,
		192,
		640,
		832,
		90,
		3,
		280,
		40,
		480,
		520,
		0,
		0,
		0,
		0,
		0,
		0,
		40,
		480,
		520,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 6
		{
		ETimingModeDMT,
		6,
		_S( "640x480p @ 75.00 Hz" ),
		EFalse,
		640,
		480,
		31500,
		1,
		38,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		16,
		64,
		120,
		200,
		640,
		840,
		10,
		3,
		160,
		20,
		480,
		500,
		0,
		0,
		0,
		0,
		0,
		0,
		20,
		480,
		500,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 7
		{
		ETimingModeDMT,
		7,
		_S( "640x480p @ 85.01 Hz" ),
		EFalse,
		640,
		480,
		36000,
		1,
		43,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		56,
		56,
		80,
		192,
		640,
		832,
		10,
		3,
		250,
		29,
		480,
		509,
		0,
		0,
		0,
		0,
		0,
		0,
		29,
		480,
		509,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 8
		{
		ETimingModeDMT,
		8,
		_S( "800x600p @ 56.25 Hz" ),
		EFalse,
		800,
		600,
		36000,
		1,
		35,
		56,
		56,
		TTvSettings::EUndefRatio,
		1,
		1,
		24,
		72,
		128,
		224,
		800,
		1024,
		10,
		2,
		220,
		25,
		600,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		25,
		600,
		625,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 9
		{
		ETimingModeDMT,
		9,
		_S( "800x600p @ 60.32 Hz" ),
		EFalse,
		800,
		600,
		40000,
		1,
		38,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		40,
		128,
		88,
		256,
		800,
		1056,
		10,
		4,
		230,
		28,
		600,
		628,
		0,
		0,
		0,
		0,
		0,
		0,
		28,
		600,
		628,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 10
		{
		ETimingModeDMT,
		10,
		_S( "800x600p @ 72.19 Hz" ),
		EFalse,
		800,
		600,
		50000,
		1,
		48,
		72,
		72,
		TTvSettings::EUndefRatio,
		1,
		1,
		56,
		120,
		64,
		240,
		800,
		1040,
		370,
		6,
		230,
		66,
		600,
		666,
		0,
		0,
		0,
		0,
		0,
		0,
		66,
		600,
		666,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 11
		{
		ETimingModeDMT,
		11,
		_S( "800x600p @ 75.00 Hz" ),
		EFalse,
		800,
		600,
		49500,
		1,
		47,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		16,
		80,
		160,
		256,
		800,
		1056,
		10,
		3,
		210,
		25,
		600,
		625,
		0,
		0,
		0,
		0,
		0,
		0,
		25,
		600,
		625,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 12
		{
		ETimingModeDMT,
		12,
		_S( "800x600p @ 85.06 Hz" ),
		EFalse,
		800,
		600,
		56250,
		1,
		54,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		32,
		64,
		152,
		248,
		800,
		1048,
		10,
		3,
		270,
		31,
		600,
		631,
		0,
		0,
		0,
		0,
		0,
		0,
		31,
		600,
		631,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 13
		{
		ETimingModeDMT,
		13,
		_S( "800x600p @ 119.97 Hz" ),
		EFalse,
		800,
		600,
		73250,
		1,
		76,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		800,
		960,
		30,
		4,
		290,
		36,
		600,
		636,
		0,
		0,
		0,
		0,
		0,
		0,
		36,
		600,
		636,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 14
		{
		ETimingModeDMT,
		14,
		_S( "848x480p @ 60.00 Hz" ),
		EFalse,
		848,
		480,
		33750,
		1,
		31,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		16,
		112,
		112,
		240,
		848,
		1088,
		60,
		8,
		230,
		37,
		480,
		517,
		0,
		0,
		0,
		0,
		0,
		0,
		37,
		480,
		517,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 15
		{
		ETimingModeDMT,
		15,
		_S( "1024x768i @ 86.96 Hz" ),
		ETrue,
		1024,
		768,
		44900,
		1,
		36,
		43,
		87,
		TTvSettings::EUndefRatio,
		1,
		1,
		8,
		176,
		56,
		240,
		1024,
		1264,
		0,
		4,
		200,
		24,
		384,
		408,
		10,
		4,
		200,
		25,
		384,
		409,
		49,
		768,
		817,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 16
		{
		ETimingModeDMT,
		16,
		_S( "1024x768p @ 60.00 Hz" ),
		EFalse,
		1024,
		768,
		65000,
		1,
		48,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		24,
		136,
		160,
		320,
		1024,
		1344,
		30,
		6,
		290,
		38,
		768,
		806,
		0,
		0,
		0,
		0,
		0,
		0,
		38,
		768,
		806,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 17
		{
		ETimingModeDMT,
		17,
		_S( "1024x768p @ 70.07 Hz" ),
		EFalse,
		1024,
		768,
		75000,
		1,
		56,
		70,
		70,
		TTvSettings::EUndefRatio,
		1,
		1,
		24,
		136,
		144,
		304,
		1024,
		1328,
		30,
		6,
		290,
		38,
		768,
		806,
		0,
		0,
		0,
		0,
		0,
		0,
		38,
		768,
		806,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 18
		{
		ETimingModeDMT,
		18,
		_S( "1024x768p @ 75.03 Hz" ),
		EFalse,
		1024,
		768,
		78750,
		1,
		60,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		16,
		96,
		176,
		288,
		1024,
		1312,
		10,
		3,
		280,
		32,
		768,
		800,
		0,
		0,
		0,
		0,
		0,
		0,
		32,
		768,
		800,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 19
		{
		ETimingModeDMT,
		19,
		_S( "1024x768p @ 85.00 Hz" ),
		EFalse,
		1024,
		768,
		94500,
		1,
		69,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		96,
		208,
		352,
		1024,
		1376,
		10,
		3,
		360,
		40,
		768,
		808,
		0,
		0,
		0,
		0,
		0,
		0,
		40,
		768,
		808,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 20
		{
		ETimingModeDMT,
		20,
		_S( "1024x768p @ 119.99 Hz" ),
		EFalse,
		1024,
		768,
		115500,
		1,
		98,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1024,
		1184,
		30,
		4,
		380,
		45,
		768,
		813,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		768,
		813,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 21
		{
		ETimingModeDMT,
		21,
		_S( "1152x864p @ 75.00 Hz" ),
		EFalse,
		1152,
		864,
		108000,
		1,
		68,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		128,
		256,
		448,
		1152,
		1600,
		10,
		3,
		320,
		36,
		864,
		900,
		0,
		0,
		0,
		0,
		0,
		0,
		36,
		864,
		900,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 22
		{
		ETimingModeDMT,
		22,
		_S( "1280x768p @ 59.99 Hz" ),
		EFalse,
		1280,
		768,
		68250,
		1,
		47,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1280,
		1440,
		30,
		7,
		120,
		22,
		768,
		790,
		0,
		0,
		0,
		0,
		0,
		0,
		22,
		768,
		790,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 23
		{
		ETimingModeDMT,
		23,
		_S( "1280x768p @ 59.87 Hz" ),
		EFalse,
		1280,
		768,
		79500,
		1,
		48,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		128,
		192,
		384,
		1280,
		1664,
		30,
		7,
		200,
		30,
		768,
		798,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		768,
		798,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 24
		{
		ETimingModeDMT,
		24,
		_S( "1280x768p @ 74.89 Hz" ),
		EFalse,
		1280,
		768,
		102250,
		1,
		60,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		80,
		128,
		208,
		416,
		1280,
		1696,
		30,
		7,
		270,
		37,
		768,
		805,
		0,
		0,
		0,
		0,
		0,
		0,
		37,
		768,
		805,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 25
		{
		ETimingModeDMT,
		25,
		_S( "1280x768p @ 84.84 Hz" ),
		EFalse,
		1280,
		768,
		117500,
		1,
		69,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		80,
		136,
		216,
		432,
		1280,
		1712,
		30,
		7,
		310,
		41,
		768,
		809,
		0,
		0,
		0,
		0,
		0,
		0,
		41,
		768,
		809,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 26
		{
		ETimingModeDMT,
		26,
		_S( "1280x768p @ 119.80 Hz" ),
		EFalse,
		1280,
		768,
		140250,
		1,
		97,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1280,
		1440,
		30,
		7,
		350,
		45,
		768,
		813,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		768,
		813,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 27
		{
		ETimingModeDMT,
		27,
		_S( "1280x800p @ 59.91 Hz" ),
		EFalse,
		1280,
		800,
		71000,
		1,
		49,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1280,
		1440,
		30,
		6,
		140,
		23,
		800,
		823,
		0,
		0,
		0,
		0,
		0,
		0,
		23,
		800,
		823,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 28
		{
		ETimingModeDMT,
		28,
		_S( "1280x800p @ 59.81 Hz" ),
		EFalse,
		1280,
		800,
		83500,
		1,
		50,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		72,
		128,
		200,
		400,
		1280,
		1680,
		30,
		6,
		220,
		31,
		800,
		831,
		0,
		0,
		0,
		0,
		0,
		0,
		31,
		800,
		831,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 29
		{
		ETimingModeDMT,
		29,
		_S( "1280x800p @ 74.93 Hz" ),
		EFalse,
		1280,
		800,
		106500,
		1,
		63,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		80,
		128,
		208,
		416,
		1280,
		1696,
		30,
		6,
		290,
		38,
		800,
		838,
		0,
		0,
		0,
		0,
		0,
		0,
		38,
		800,
		838,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 30
		{
		ETimingModeDMT,
		30,
		_S( "1280x800p @ 84.88 Hz" ),
		EFalse,
		1280,
		800,
		122500,
		1,
		72,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		80,
		136,
		216,
		432,
		1280,
		1712,
		30,
		6,
		340,
		43,
		800,
		843,
		0,
		0,
		0,
		0,
		0,
		0,
		43,
		800,
		843,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 31
		{
		ETimingModeDMT,
		31,
		_S( "1280x800p @ 119.91 Hz" ),
		EFalse,
		1280,
		800,
		146250,
		1,
		102,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1280,
		1440,
		30,
		6,
		380,
		47,
		800,
		847,
		0,
		0,
		0,
		0,
		0,
		0,
		47,
		800,
		847,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 32
		{
		ETimingModeDMT,
		32,
		_S( "1280x960p @ 60.00 Hz" ),
		EFalse,
		1280,
		960,
		108000,
		1,
		60,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		96,
		112,
		312,
		520,
		1280,
		1800,
		10,
		3,
		360,
		40,
		960,
		1000,
		0,
		0,
		0,
		0,
		0,
		0,
		40,
		960,
		1000,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 33
		{
		ETimingModeDMT,
		33,
		_S( "1280x960p @ 85.00 Hz" ),
		EFalse,
		1280,
		960,
		148500,
		1,
		86,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		160,
		224,
		448,
		1280,
		1728,
		10,
		3,
		470,
		51,
		960,
		1011,
		0,
		0,
		0,
		0,
		0,
		0,
		51,
		960,
		1011,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 34
		{
		ETimingModeDMT,
		34,
		_S( "1280x960p @ 119.84 Hz" ),
		EFalse,
		1280,
		960,
		175500,
		1,
		122,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1280,
		1440,
		30,
		4,
		500,
		57,
		960,
		1017,
		0,
		0,
		0,
		0,
		0,
		0,
		57,
		960,
		1017,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 35
		{
		ETimingModeDMT,
		35,
		_S( "1280x1024p @ 60.02 Hz" ),
		EFalse,
		1280,
		1024,
		108000,
		1,
		64,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		112,
		248,
		408,
		1280,
		1688,
		10,
		3,
		380,
		42,
		1024,
		1066,
		0,
		0,
		0,
		0,
		0,
		0,
		42,
		1024,
		1066,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 36
		{
		ETimingModeDMT,
		36,
		_S( "1280x1024p @ 75.02 Hz" ),
		EFalse,
		1280,
		1024,
		135000,
		1,
		80,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		16,
		144,
		248,
		408,
		1280,
		1688,
		10,
		3,
		380,
		42,
		1024,
		1066,
		0,
		0,
		0,
		0,
		0,
		0,
		42,
		1024,
		1066,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 37
		{
		ETimingModeDMT,
		37,
		_S( "1280x1024p @ 85.02 Hz" ),
		EFalse,
		1280,
		1024,
		157500,
		1,
		91,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		160,
		224,
		448,
		1280,
		1728,
		10,
		3,
		440,
		48,
		1024,
		1072,
		0,
		0,
		0,
		0,
		0,
		0,
		48,
		1024,
		1072,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 38
		{
		ETimingModeDMT,
		38,
		_S( "1280x1024p @ 119.96 Hz" ),
		EFalse,
		1280,
		1024,
		187250,
		1,
		130,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1280,
		1440,
		30,
		7,
		500,
		60,
		1024,
		1084,
		0,
		0,
		0,
		0,
		0,
		0,
		60,
		1024,
		1084,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 39
		{
		ETimingModeDMT,
		39,
		_S( "1360x768p @ 60.02 Hz" ),
		EFalse,
		1360,
		768,
		85500,
		1,
		48,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		112,
		256,
		432,
		1360,
		1792,
		30,
		6,
		180,
		27,
		768,
		795,
		0,
		0,
		0,
		0,
		0,
		0,
		27,
		768,
		795,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 40
		{
		ETimingModeDMT,
		40,
		_S( "1360x768p @ 119.97 Hz" ),
		EFalse,
		1360,
		768,
		148250,
		1,
		98,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1360,
		1520,
		30,
		5,
		370,
		45,
		768,
		813,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		768,
		813,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 41
		{
		ETimingModeDMT,
		41,
		_S( "1400x1050p @ 59.95 Hz" ),
		EFalse,
		1400,
		1050,
		101000,
		1,
		65,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1400,
		1560,
		30,
		4,
		230,
		30,
		1050,
		1080,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		1050,
		1080,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 42
		{
		ETimingModeDMT,
		42,
		_S( "1400x1050p @ 59.98 Hz" ),
		EFalse,
		1400,
		1050,
		121750,
		1,
		65,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		88,
		144,
		232,
		464,
		1400,
		1864,
		30,
		4,
		320,
		39,
		1050,
		1089,
		0,
		0,
		0,
		0,
		0,
		0,
		39,
		1050,
		1089,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 43
		{
		ETimingModeDMT,
		43,
		_S( "1400x1050p @ 74.87 Hz" ),
		EFalse,
		1400,
		1050,
		156000,
		1,
		82,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		104,
		144,
		248,
		496,
		1400,
		1896,
		30,
		4,
		420,
		49,
		1050,
		1099,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		1050,
		1099,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 44
		{
		ETimingModeDMT,
		44,
		_S( "1400x1050p @ 84.96 Hz" ),
		EFalse,
		1400,
		1050,
		179500,
		1,
		94,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		104,
		152,
		256,
		512,
		1400,
		1912,
		30,
		4,
		480,
		55,
		1050,
		1105,
		0,
		0,
		0,
		0,
		0,
		0,
		55,
		1050,
		1105,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 45
		{
		ETimingModeDMT,
		45,
		_S( "1400x1050p @ 119.90 Hz" ),
		EFalse,
		1400,
		1050,
		208000,
		1,
		133,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1400,
		1560,
		30,
		4,
		550,
		62,
		1050,
		1112,
		0,
		0,
		0,
		0,
		0,
		0,
		62,
		1050,
		1112,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 46
		{
		ETimingModeDMT,
		46,
		_S( "1440x900p @ 59.90 Hz" ),
		EFalse,
		1440,
		900,
		88750,
		1,
		55,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1440,
		1600,
		30,
		6,
		170,
		26,
		900,
		926,
		0,
		0,
		0,
		0,
		0,
		0,
		26,
		900,
		926,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 47
		{
		ETimingModeDMT,
		47,
		_S( "1440x900p @ 59.89 Hz" ),
		EFalse,
		1440,
		900,
		106500,
		1,
		56,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		80,
		152,
		232,
		464,
		1440,
		1904,
		30,
		6,
		250,
		34,
		900,
		934,
		0,
		0,
		0,
		0,
		0,
		0,
		34,
		900,
		934,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 48
		{
		ETimingModeDMT,
		48,
		_S( "1440x900p @ 74.98 Hz" ),
		EFalse,
		1440,
		900,
		136750,
		1,
		71,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		96,
		152,
		248,
		496,
		1440,
		1936,
		30,
		6,
		330,
		42,
		900,
		942,
		0,
		0,
		0,
		0,
		0,
		0,
		42,
		900,
		942,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 49
		{
		ETimingModeDMT,
		49,
		_S( "1440x900p @ 84.84 Hz" ),
		EFalse,
		1440,
		900,
		157000,
		1,
		80,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		104,
		152,
		256,
		512,
		1440,
		1952,
		30,
		6,
		390,
		48,
		900,
		948,
		0,
		0,
		0,
		0,
		0,
		0,
		48,
		900,
		948,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 50
		{
		ETimingModeDMT,
		50,
		_S( "1440x900p @ 119.85 Hz" ),
		EFalse,
		1440,
		900,
		182750,
		1,
		114,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1440,
		1600,
		30,
		6,
		440,
		53,
		900,
		953,
		0,
		0,
		0,
		0,
		0,
		0,
		53,
		900,
		953,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 51
		{
		ETimingModeDMT,
		51,
		_S( "1600x1200p @ 60.00 Hz" ),
		EFalse,
		1600,
		1200,
		162000,
		1,
		75,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		192,
		304,
		560,
		1600,
		2160,
		10,
		3,
		460,
		50,
		1200,
		1250,
		0,
		0,
		0,
		0,
		0,
		0,
		50,
		1200,
		1250,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 52
		{
		ETimingModeDMT,
		52,
		_S( "1600x1200p @ 65.00 Hz" ),
		EFalse,
		1600,
		1200,
		175500,
		1,
		81,
		65,
		65,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		192,
		304,
		560,
		1600,
		2160,
		10,
		3,
		460,
		50,
		1200,
		1250,
		0,
		0,
		0,
		0,
		0,
		0,
		50,
		1200,
		1250,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 53
		{
		ETimingModeDMT,
		53,
		_S( "1600x1200p @ 70.00 Hz" ),
		EFalse,
		1600,
		1200,
		189000,
		1,
		88,
		70,
		70,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		192,
		304,
		560,
		1600,
		2160,
		10,
		3,
		460,
		50,
		1200,
		1250,
		0,
		0,
		0,
		0,
		0,
		0,
		50,
		1200,
		1250,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 54
		{
		ETimingModeDMT,
		54,
		_S( "1600x1200p @ 75.00 Hz" ),
		EFalse,
		1600,
		1200,
		202500,
		1,
		94,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		192,
		304,
		560,
		1600,
		2160,
		10,
		3,
		460,
		50,
		1200,
		1250,
		0,
		0,
		0,
		0,
		0,
		0,
		50,
		1200,
		1250,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 55
		{
		ETimingModeDMT,
		55,
		_S( "1600x1200p @ 85.00 Hz" ),
		EFalse,
		1600,
		1200,
		229500,
		1,
		106,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		64,
		192,
		304,
		560,
		1600,
		2160,
		10,
		3,
		460,
		50,
		1200,
		1250,
		0,
		0,
		0,
		0,
		0,
		0,
		50,
		1200,
		1250,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 56
		{
		ETimingModeDMT,
		56,
		_S( "1600x1200p @ 119.92 Hz" ),
		EFalse,
		1600,
		1200,
		268250,
		1,
		152,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1600,
		1760,
		30,
		4,
		640,
		71,
		1200,
		1271,
		0,
		0,
		0,
		0,
		0,
		0,
		71,
		1200,
		1271,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 57
		{
		ETimingModeDMT,
		57,
		_S( "1680x1050p @ 59.88 Hz" ),
		EFalse,
		1680,
		1050,
		119000,
		1,
		65,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1680,
		1840,
		30,
		6,
		210,
		30,
		1050,
		1080,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		1050,
		1080,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 58
		{
		ETimingModeDMT,
		58,
		_S( "1680x1050p @ 59.95 Hz" ),
		EFalse,
		1680,
		1050,
		146250,
		1,
		65,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		104,
		176,
		280,
		560,
		1680,
		2240,
		30,
		6,
		300,
		39,
		1050,
		1089,
		0,
		0,
		0,
		0,
		0,
		0,
		39,
		1050,
		1089,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 59
		{
		ETimingModeDMT,
		59,
		_S( "1680x1050p @ 74.89 Hz" ),
		EFalse,
		1680,
		1050,
		187000,
		1,
		82,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		120,
		176,
		296,
		592,
		1680,
		2272,
		30,
		6,
		400,
		49,
		1050,
		1099,
		0,
		0,
		0,
		0,
		0,
		0,
		49,
		1050,
		1099,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 60
		{
		ETimingModeDMT,
		60,
		_S( "1680x1050p @ 84.94 Hz" ),
		EFalse,
		1680,
		1050,
		214750,
		1,
		94,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		128,
		176,
		304,
		608,
		1680,
		2288,
		30,
		6,
		460,
		55,
		1050,
		1105,
		0,
		0,
		0,
		0,
		0,
		0,
		55,
		1050,
		1105,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 61
		{
		ETimingModeDMT,
		61,
		_S( "1680x1050p @ 119.99 Hz" ),
		EFalse,
		1680,
		1050,
		245500,
		1,
		133,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1680,
		1840,
		30,
		6,
		530,
		62,
		1050,
		1112,
		0,
		0,
		0,
		0,
		0,
		0,
		62,
		1050,
		1112,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 62
		{
		ETimingModeDMT,
		62,
		_S( "1792x1344p @ 60.00 Hz" ),
		EFalse,
		1792,
		1344,
		204750,
		1,
		84,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		128,
		200,
		328,
		656,
		1792,
		2448,
		10,
		3,
		460,
		50,
		1344,
		1394,
		0,
		0,
		0,
		0,
		0,
		0,
		50,
		1344,
		1394,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 63
		{
		ETimingModeDMT,
		63,
		_S( "1792x1344p @ 75.00 Hz" ),
		EFalse,
		1792,
		1344,
		261000,
		1,
		106,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		96,
		216,
		352,
		664,
		1792,
		2456,
		10,
		3,
		690,
		73,
		1344,
		1417,
		0,
		0,
		0,
		0,
		0,
		0,
		73,
		1344,
		1417,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 64
		{
		ETimingModeDMT,
		64,
		_S( "1792x1344p @ 119.97 Hz" ),
		EFalse,
		1792,
		1344,
		333250,
		1,
		171,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1792,
		1952,
		30,
		4,
		720,
		79,
		1344,
		1423,
		0,
		0,
		0,
		0,
		0,
		0,
		79,
		1344,
		1423,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 65
		{
		ETimingModeDMT,
		65,
		_S( "1856x1392p @ 60.00 Hz" ),
		EFalse,
		1856,
		1392,
		218250,
		1,
		86,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		96,
		224,
		352,
		672,
		1856,
		2528,
		10,
		3,
		430,
		47,
		1392,
		1439,
		0,
		0,
		0,
		0,
		0,
		0,
		47,
		1392,
		1439,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 66
		{
		ETimingModeDMT,
		66,
		_S( "1856x1392p @ 75.00 Hz" ),
		EFalse,
		1856,
		1392,
		288000,
		1,
		113,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		128,
		224,
		352,
		704,
		1856,
		2560,
		10,
		3,
		1040,
		108,
		1392,
		1500,
		0,
		0,
		0,
		0,
		0,
		0,
		108,
		1392,
		1500,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 67
		{
		ETimingModeDMT,
		67,
		_S( "1856x1392p @ 119.97 Hz" ),
		EFalse,
		1856,
		1392,
		356500,
		1,
		177,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1856,
		2016,
		30,
		4,
		750,
		82,
		1392,
		1474,
		0,
		0,
		0,
		0,
		0,
		0,
		82,
		1392,
		1474,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 68
		{
		ETimingModeDMT,
		68,
		_S( "1920x1200p @ 59.95 Hz" ),
		EFalse,
		1920,
		1200,
		154000,
		1,
		74,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1920,
		2080,
		30,
		6,
		260,
		35,
		1200,
		1235,
		0,
		0,
		0,
		0,
		0,
		0,
		35,
		1200,
		1235,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 69
		{
		ETimingModeDMT,
		69,
		_S( "1920x1200p @ 59.88 Hz" ),
		EFalse,
		1920,
		1200,
		193250,
		1,
		75,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		136,
		200,
		336,
		672,
		1920,
		2592,
		30,
		6,
		360,
		45,
		1200,
		1245,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1200,
		1245,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 70
		{
		ETimingModeDMT,
		70,
		_S( "1920x1200p @ 74.93 Hz" ),
		EFalse,
		1920,
		1200,
		245250,
		1,
		94,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		136,
		208,
		344,
		688,
		1920,
		2608,
		30,
		6,
		460,
		55,
		1200,
		1255,
		0,
		0,
		0,
		0,
		0,
		0,
		55,
		1200,
		1255,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 71
		{
		ETimingModeDMT,
		71,
		_S( "1920x1200p @ 84.93 Hz" ),
		EFalse,
		1920,
		1200,
		281250,
		1,
		107,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		144,
		208,
		352,
		704,
		1920,
		2624,
		30,
		6,
		530,
		62,
		1200,
		1262,
		0,
		0,
		0,
		0,
		0,
		0,
		62,
		1200,
		1262,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 72
		{
		ETimingModeDMT,
		72,
		_S( "1920x1200p @ 119.91 Hz" ),
		EFalse,
		1920,
		1200,
		317000,
		1,
		152,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1920,
		2080,
		30,
		6,
		620,
		71,
		1200,
		1271,
		0,
		0,
		0,
		0,
		0,
		0,
		71,
		1200,
		1271,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 73
		{
		ETimingModeDMT,
		73,
		_S( "1920x1440p @ 60.00 Hz" ),
		EFalse,
		1920,
		1440,
		234000,
		1,
		90,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		128,
		208,
		344,
		680,
		1920,
		2600,
		10,
		3,
		560,
		60,
		1440,
		1500,
		0,
		0,
		0,
		0,
		0,
		0,
		60,
		1440,
		1500,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 74
		{
		ETimingModeDMT,
		74,
		_S( "1920x1440p @ 75.00 Hz" ),
		EFalse,
		1920,
		1440,
		297000,
		1,
		113,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		144,
		224,
		352,
		720,
		1920,
		2640,
		10,
		3,
		560,
		60,
		1440,
		1500,
		0,
		0,
		0,
		0,
		0,
		0,
		60,
		1440,
		1500,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 75
		{
		ETimingModeDMT,
		75,
		_S( "1920x1440p @ 119.96 Hz" ),
		EFalse,
		1920,
		1440,
		380500,
		1,
		183,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		1920,
		2080,
		30,
		4,
		780,
		85,
		1440,
		1525,
		0,
		0,
		0,
		0,
		0,
		0,
		85,
		1440,
		1525,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 76
		{
		ETimingModeDMT,
		76,
		_S( "2560x1600p @ 59.97 Hz" ),
		EFalse,
		2560,
		1600,
		268500,
		1,
		99,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		2560,
		2720,
		30,
		6,
		370,
		46,
		1600,
		1646,
		0,
		0,
		0,
		0,
		0,
		0,
		46,
		1600,
		1646,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 77
		{
		ETimingModeDMT,
		77,
		_S( "2560x1600p @ 59.99 Hz" ),
		EFalse,
		2560,
		1600,
		348500,
		1,
		99,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		192,
		280,
		472,
		944,
		2560,
		3504,
		30,
		6,
		490,
		58,
		1600,
		1658,
		0,
		0,
		0,
		0,
		0,
		0,
		58,
		1600,
		1658,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 78
		{
		ETimingModeDMT,
		78,
		_S( "2560x1600p @ 74.97 Hz" ),
		EFalse,
		2560,
		1600,
		443250,
		1,
		125,
		75,
		75,
		TTvSettings::EUndefRatio,
		1,
		1,
		208,
		280,
		488,
		976,
		2560,
		3536,
		30,
		6,
		630,
		72,
		1600,
		1672,
		0,
		0,
		0,
		0,
		0,
		0,
		72,
		1600,
		1672,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 79
		{
		ETimingModeDMT,
		79,
		_S( "2560x1600p @ 84.95 Hz" ),
		EFalse,
		2560,
		1600,
		505250,
		1,
		143,
		85,
		85,
		TTvSettings::EUndefRatio,
		1,
		1,
		208,
		280,
		488,
		976,
		2560,
		3536,
		30,
		6,
		730,
		82,
		1600,
		1682,
		0,
		0,
		0,
		0,
		0,
		0,
		82,
		1600,
		1682,
		ESyncPolarityNegative,
		ESyncPolarityNegative,
		},
	// Timing for DMT mode: 80
		{
		ETimingModeDMT,
		80,
		_S( "2560x1600p @ 119.96 Hz" ),
		EFalse,
		2560,
		1600,
		552750,
		1,
		203,
		120,
		120,
		TTvSettings::EUndefRatio,
		1,
		1,
		48,
		32,
		80,
		160,
		2560,
		2720,
		30,
		6,
		850,
		94,
		1600,
		1694,
		0,
		0,
		0,
		0,
		0,
		0,
		94,
		1600,
		1694,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 81
		{
		ETimingModeDMT,
		81,
		_S( "1366x768p @ 59.79 Hz" ),
		EFalse,
		1366,
		768,
		85500,
		1,
		48,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		70,
		143,
		213,
		426,
		1366,
		1792,
		30,
		3,
		240,
		30,
		768,
		798,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		768,
		798,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 82
		{
		ETimingModeDMT,
		82,
		_S( "1920x1080p @ 60.00 Hz" ),
		EFalse,
		1920,
		1080,
		148500,
		1,
		68,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		88,
		44,
		148,
		280,
		1920,
		2200,
		40,
		5,
		360,
		45,
		1080,
		1125,
		0,
		0,
		0,
		0,
		0,
		0,
		45,
		1080,
		1125,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 83
		{
		ETimingModeDMT,
		83,
		_S( "1600x900p @ 60.00 Hz" ),
		EFalse,
		1600,
		900,
		108000,
		1,
		60,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		24,
		80,
		96,
		200,
		1600,
		1800,
		10,
		3,
		960,
		100,
		900,
		1000,
		0,
		0,
		0,
		0,
		0,
		0,
		100,
		900,
		1000,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 84
		{
		ETimingModeDMT,
		84,
		_S( "2048x1152p @ 60.00 Hz" ),
		EFalse,
		2048,
		1152,
		162000,
		1,
		72,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		26,
		80,
		96,
		202,
		2048,
		2250,
		10,
		3,
		440,
		48,
		1152,
		1200,
		0,
		0,
		0,
		0,
		0,
		0,
		48,
		1152,
		1200,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 85
		{
		ETimingModeDMT,
		85,
		_S( "1280x720p @ 60.00 Hz" ),
		EFalse,
		1280,
		720,
		74250,
		1,
		45,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		110,
		40,
		220,
		370,
		1280,
		1650,
		50,
		5,
		200,
		30,
		720,
		750,
		0,
		0,
		0,
		0,
		0,
		0,
		30,
		720,
		750,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
	// Timing for DMT mode: 86
		{
		ETimingModeDMT,
		86,
		_S( "1366x768p @ 60.00 Hz" ),
		EFalse,
		1366,
		768,
		72000,
		1,
		48,
		60,
		60,
		TTvSettings::EUndefRatio,
		1,
		1,
		14,
		56,
		64,
		134,
		1366,
		1500,
		10,
		3,
		280,
		32,
		768,
		800,
		0,
		0,
		0,
		0,
		0,
		0,
		32,
		768,
		800,
		ESyncPolarityPositive,
		ESyncPolarityPositive,
		},
    };

/** DMT timings list count */
const TInt KDMTTimingCount = sizeof( KDMTTimings ) / sizeof( KDMTTimings[0] );

#endif//VIDEOTIMINGS_H
