// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#if !defined (__SSMDOMAINDEFS_H__) 
#define __SSMDOMAINDEFS_H__ 
 
#include <domainpolicy.h>

/**
@publishedPartner
@released

The first domain in the HAL level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2HALDomain1 = 10;

/**
@publishedPartner
@released

The second domain in the HAL level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2HALDomain2 = 20;


/**
@publishedPartner
@released

The third domain in the HAL level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2HALDomain3 = 30;

/**
@publishedPartner
@released

The fourth domain in the HAL level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2HALDomain4 = 40;

/**
@publishedPartner
@released

The fifth domain in the HAL level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2HALDomain5 = 50;

/**
@publishedPartner
@released

The first domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2KernelServicesDomain1 = 60;

/**
@publishedPartner
@released

The second domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2KernelServicesDomain2 = 70;

/**
@publishedPartner
@released

The third domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2KernelServicesDomain3 = 80;

/**
@publishedPartner
@released

The fourth domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2KernelServicesDomain4 = 90;

/**
@publishedPartner
@released

The fifth domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2KernelServicesDomain5 = 100;

/**
@publishedPartner
@released

The first domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2OSServicesDomain1 = 110;

/**
@publishedPartner
@released

The second domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2OSServicesDomain2 = 120;

/**
@publishedPartner
@released

The third domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2OSServicesDomain3 = 130;

/**
@publishedPartner
@released

The fourth domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2OSServicesDomain4 = 140;

/**
@publishedPartner
@released

The fifth domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2OSServicesDomain5 = 150;

/**
@publishedPartner
@released

The first domain in the Generic Middleware level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2GenMiddlewareDomain1 = 160;

/**
@publishedPartner
@released

The second domain in the Generic Middleware level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2GenMiddlewareDomain2 = 170;


/**
@publishedPartner
@released

The third domain in the Generic Middleware level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2GenMiddlewareDomain3 = 180;


/**
@publishedPartner
@released

The fourth domain in the Generic Middleware level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2GenMiddlewareDomain4 = 190;

/**
@publishedPartner
@released

The fifth domain in the Generic Middleware level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2GenMiddlewareDomain5 = 200;

/**
@publishedPartner
@released

The first domain in the Application Service level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2AppServicesDomain1 = 210;

/**
@publishedPartner
@released

The second domain in the Application Service level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2AppServicesDomain2 = 220;

/**
@publishedPartner
@released

The third domain in the Application Service level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2AppServicesDomain3 = 230;

/**
@publishedPartner
@released

The fourth domain in the Application Service level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2AppServicesDomain4 = 240;


/**
@publishedPartner
@released

The fifth domain in the Application Service level of the Startup Domain Hierarchy
**/
static const TDmDomainId KSM2AppServicesDomain5 = 250;


/**
@publishedPartner
@released

The first domain in the UI Service level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiServicesDomain1 = 260;

/**
@publishedPartner
@released

The second domain in the UI Service level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiServicesDomain2 = 270;


/**
@publishedPartner
@released

The third domain in the UI Service level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiServicesDomain3 = 280;


/**
@publishedPartner
@released

The fourth domain in the UI Service level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiServicesDomain4 = 290;


/**
@publishedPartner
@released

The fifth domain in the UI Service level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiServicesDomain5 = 300;

/**
@publishedPartner
@released

The first domain in the UI Application level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiApplicationDomain1 = 310;

/**
@publishedPartner
@released

The second domain in the UI Application level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiApplicationDomain2 = 320;

/**
@publishedPartner
@released

The third domain in the UI Application level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiApplicationDomain3 = 330;

/**
@publishedPartner
@released

The fourth domain in the UI Application level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiApplicationDomain4 = 340;

/**
@publishedPartner
@released

The fifth domain in the UI Application level of the Startup Domain Hierarchy.
Used by the Licensees mainly.
**/
static const TDmDomainId KSM2UiApplicationDomain5 = 350;


//
//  Existing ones taken from  StartupDomainDefs.h
//
/**
@publishedPartner
@deprecated

The first domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KKernelServicesDomain1 = KSM2KernelServicesDomain1;

/**
@publishedPartner
@deprecated

The second domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KKernelServicesDomain2 = KSM2KernelServicesDomain2;

/**
@publishedPartner
@deprecated

The third domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KKernelServicesDomain3 = KSM2KernelServicesDomain3;

/**
@publishedPartner
@deprecated

The fourth domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KKernelServicesDomain4 = KSM2KernelServicesDomain4;

/**
@publishedPartner
@deprecated

The fifth domain in the Kernel Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KKernelServicesDomain5 = KSM2KernelServicesDomain5;

/**
@publishedPartner
@deprecated

The first domain in the Base Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KBaseServicesDomain1 = KSM2OSServicesDomain1;

/**
@publishedPartner
@deprecated

The second domain in the Base Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KBaseServicesDomain2 = KSM2OSServicesDomain2;

/**
@publishedPartner
@deprecated

The third domain in the Base Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KBaseServicesDomain3 = KSM2OSServicesDomain3;

/**
@publishedPartner
@deprecated

The fourth domain in the Base Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KBaseServicesDomain4 = KSM2OSServicesDomain4;

/**
@publishedPartner
@deprecated

The fifth domain in the Base Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KBaseServicesDomain5 = KSM2OSServicesDomain5;

/**
@publishedPartner
@deprecated

The first domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KOSServicesDomain1 = KSM2GenMiddlewareDomain1;

/**
@publishedPartner
@deprecated

The second domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KOSServicesDomain2 = KSM2GenMiddlewareDomain2;

/**
@publishedPartner
@deprecated

The third domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KOSServicesDomain3 = KSM2GenMiddlewareDomain3;

/**
@publishedPartner
@deprecated

The fourth domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KOSServicesDomain4 = KSM2GenMiddlewareDomain4;

/**
@publishedPartner
@deprecated

The fifth domain in the OS Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KOSServicesDomain5 = KSM2GenMiddlewareDomain5;

/**
@publishedPartner
@deprecated

The first domain in the AppServices Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KAppServicesDomain1 = KSM2AppServicesDomain1;

/**
@publishedPartner
@deprecated

The second domain in the AppServices Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KAppServicesDomain2 = KSM2AppServicesDomain2;

/**
@publishedPartner
@deprecated

The third domain in the AppServices Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KAppServicesDomain3 = KSM2AppServicesDomain3;

/**
@publishedPartner
@deprecated

The fourth domain in the AppServices Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KAppServicesDomain4 = KSM2AppServicesDomain4;

/**
@publishedPartner
@deprecated

The fifth domain in the AppServices Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KAppServicesDomain5 = KSM2AppServicesDomain5;

/**
@publishedPartner
@deprecated

The first domain in the UIFrameworkDomain Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KUIFrameworkDomain1 = KSM2UiServicesDomain1;

/**
@publishedPartner
@deprecated

The second domain in the UIFrameworkDomain Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KUIFrameworkDomain2 = KSM2UiServicesDomain2;

/**
@publishedPartner
@deprecated

The third domain in the UIFrameworkDomain Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KUIFrameworkDomain3 = KSM2UiServicesDomain3;

/**
@publishedPartner
@deprecated

The fourth domain in the UIFrameworkDomain Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KUIFrameworkDomain4 = KSM2UiServicesDomain4;

/**
@publishedPartner
@deprecated

The fifth domain in the UIFrameworkDomain Services level of the Startup Domain Hierarchy
**/
static const TDmDomainId KUIFrameworkDomain5 = KSM2UiServicesDomain5;

#endif  // __SSMDOMAINDEFS_H__

