// Copyright (c) 2003-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include "BidiCompact.h"
#include "BidiVisual.h"
#include <s32mem.h>
#include <biditext.h>
#include <linebreak.h>
#include "TGraphicsContext.h"
#include "TBiDi.h"

//
// Constants
//
static const TInt KBufferSize = 1024;
static const TInt KHalfBufferSize = KBufferSize/2;
static const TInt KQuarterBufferSize = KBufferSize/4;
static const TInt KThreeQuarterBufferSize = KQuarterBufferSize*3;
static const TInt KUnicodeNoSuchCharacter = 0xFFFF;
static const TInt KUnicodeLeftToRightMark = 0x200E;
static const TInt KUnicodeRightToLeftMark = 0x200F;
static const TInt KUnicodeLeftToRightEmbedding = 0x202A;
static const TInt KUnicodeRightToLeftEmbedding = 0x202B;
static const TInt KUnicodePopDirectionFormat = 0x202C;
static const TInt KUnicodeLeftToRightOverride = 0x202D;
static const TInt KUnicodeRightToLeftOverride = 0x202E;
static const TInt KUnicodeZeroWidthJoiner = 0x200D;
static const TInt KUnicodeSpace = 0x0020;
static const TInt KUnicodeLinebreak = 0x2028;

const TText16 KAlef = 0x627;
//const TText16 KBeh = 0x628;
//const TText16  KTehMarbuta = 0x629;
const TText16  KTeh = 0x62A;
//const TText16  KTheh = 0x62B;
//const TText16  KJeem = 0x62C;
//const TText16  KHah = 0x62D;
//const TText16  KKhah = 0x62E;
//const TText16  KDal = 0x62F;
//const TText16  KThal = 0x630;
const TText16  KReh = 0x631;
//const TText16  KZain = 0x632;
//const TText16  KSeen = 0x633;
//const TText16  KSheen = 0x634;
//const TText16  KSad = 0x635;
//const TText16  KDad = 0x636;
//const TText16  KTah = 0x637;
//const TText16  KZah = 0x638;
//const TText16  KAin = 0x639;
//const TText16  KGhain = 0x63A;
const TText16  KFeh = 0x641;
//const TText16  KQaf = 0x642;
const TText16  KKaf = 0x643;
//const TText16  KLam = 0x644;
//const TText16  KMeem = 0x645;
const TText16  KNoon = 0x646;
//const TText16  KHeh = 0x647;
//const TText16  KWaw = 0x648;
//const TText16  KAlefMaksura = 0x649;
const TText16  KYeh = 0x64A;
const TText16 KEllipsis = 0x2026;

// List of all glyphs that have mirrors as per Unicode 3.0.1

_LIT(KMirrors,"\x28\x29\x3C\x3E\x5B\x5D\x7B\x7D\xAB\xBB\x2039\x203A\x2045\x2046"
L"\x207D\x207E\x208D\x208E\x2208\x2209\x220A\x220B\x220C\x220D\x223C\x223D\x2243"
L"\x2252\x2253\x2254\x2255\x2264\x2265\x2266\x2267\x2268\x2269\x226A\x226B\x226E"
L"\x226F\x2270\x2271\x2272\x2273\x2274\x2275\x2276\x2277\x2278\x2279\x227A\x227B"
L"\x227C\x227D\x227E\x227F\x2280\x2281\x2282\x2283\x2284\x2285\x2286\x2287\x2288"
L"\x2289\x228A\x228B\x228F\x2290\x2291\x2292\x22A2\x22A3\x22B0\x22B1\x22B2\x22B3"
L"\x22B4\x22B5\x22B6\x22B7\x22C9\x22CA\x22CB\x22CC\x22CD\x22D0\x22D1\x22D6\x22D7"
L"\x22D8\x22D9\x22DA\x22DB\x22DC\x22DD\x22DE\x22DF\x22E0\x22E1\x22E2\x22E3\x22E4"
L"\x22E5\x22E6\x22E7\x22E8\x22E9\x22EA\x22EB\x22EC\x22ED\x22F0\x22F1\x2308\x2309"
L"\x230A\x230B\x2329\x232A\x3008\x3009\x300A\x300B\x300C\x300D\x300E\x300F\x3010"
L"\x3011\x3014\x3015\x3016\x3017\x3018\x3019\x301A\x301B");

// KMirrord()[Pos] is the mirror of KMirrors()[Pos]

_LIT(KMirrord,"\x29\x28\x3E\x3C\x5D\x5B\x7D\x7B\xBB\xAB\x203A\x2039\x2046\x2045"
L"\x207E\x207D\x208E\x208D\x220B\x220C\x220D\x2208\x2209\x220A\x223D\x223C\x22CD"
L"\x2253\x2252\x2255\x2254\x2265\x2264\x2267\x2266\x2269\x2268\x226B\x226A\x226F"
L"\x226E\x2271\x2270\x2273\x2272\x2275\x2274\x2277\x2276\x2279\x2278\x227B\x227A"
L"\x227D\x227C\x227F\x227E\x2281\x2280\x2283\x2282\x2285\x2284\x2287\x2286\x2289"
L"\x2288\x228B\x228A\x2290\x228F\x2292\x2291\x22A3\x22A2\x22B1\x22B0\x22B3\x22B2"
L"\x22B5\x22B4\x22B7\x22B6\x22CA\x22C9\x22CC\x22CB\x2243\x22D1\x22D0\x22D7\x22D6"
L"\x22D9\x22D8\x22DB\x22DA\x22DD\x22DC\x22DF\x22DE\x22E1\x22E0\x22E3\x22E2\x22E5"
L"\x22E4\x22E7\x22E6\x22E9\x22E8\x22EB\x22EA\x22ED\x22EC\x22F1\x22F0\x2309\x2308"
L"\x230B\x230A\x232A\x2329\x3009\x3008\x300B\x300A\x300D\x300C\x300F\x300E\x3011"
L"\x3010\x3015\x3014\x3017\x3016\x3019\x3018\x301B\x301A");

// This constant defines the Unicode characters in the "LeftToRight" (L) category.
// A conventional _LIT cannot be used here because of the Microsoft limit of 
// 2048 bytes for literal strings.
// Note: Remove all "mark" from this array, i.e, category = Mn, Mc or Me. That's
//       because a "mark" always follow its base character. This feature will
//       lead RLOLeftToRightTest() to fail.
// Note: Remove all unpaired surrogate.
static const TUint16 KLeftToRight[] = 
	{
	0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,
	0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,
	0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x0061,0x0062,0x0063,0x0064,
	0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
	0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,
	0x0079,0x007a,0x00aa,0x00b5,0x00ba,0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,
	0x00c5,0x00c6,0x00c7,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,
	0x00cf,0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d8,0x00d9,
	0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,0x00e0,0x00e1,0x00e2,0x00e3,
	0x00e4,0x00e5,0x00e6,0x00e7,0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,
	0x00ee,0x00ef,0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f8,
	0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x00ff,0x0100,0x0101,0x0102,
	0x0103,0x0104,0x0105,0x0106,0x0107,0x0108,0x0109,0x010a,0x010b,0x010c,
	0x010d,0x010e,0x010f,0x0110,0x0111,0x0112,0x0113,0x0114,0x0115,0x0116,
	0x0117,0x0118,0x0119,0x011a,0x011b,0x011c,0x011d,0x011e,0x011f,0x0120,
	0x0121,0x0122,0x0123,0x0124,0x0125,0x0126,0x0127,0x0128,0x0129,0x012a,
	0x012b,0x012c,0x012d,0x012e,0x012f,0x0130,0x0131,0x0132,0x0133,0x0134,
	0x0135,0x0136,0x0137,0x0138,0x0139,0x013a,0x013b,0x013c,0x013d,0x013e,
	0x013f,0x0140,0x0141,0x0142,0x0143,0x0144,0x0145,0x0146,0x0147,0x0148,
	0x0149,0x014a,0x014b,0x014c,0x014d,0x014e,0x014f,0x0150,0x0151,0x0152,
	0x0153,0x0154,0x0155,0x0156,0x0157,0x0158,0x0159,0x015a,0x015b,0x015c,
	0x015d,0x015e,0x015f,0x0160,0x0161,0x0162,0x0163,0x0164,0x0165,0x0166,
	0x0167,0x0168,0x0169,0x016a,0x016b,0x016c,0x016d,0x016e,0x016f,0x0170,
	0x0171,0x0172,0x0173,0x0174,0x0175,0x0176,0x0177,0x0178,0x0179,0x017a,
	0x017b,0x017c,0x017d,0x017e,0x017f,0x0180,0x0181,0x0182,0x0183,0x0184,
	0x0185,0x0186,0x0187,0x0188,0x0189,0x018a,0x018b,0x018c,0x018d,0x018e,
	0x018f,0x0190,0x0191,0x0192,0x0193,0x0194,0x0195,0x0196,0x0197,0x0198,
	0x0199,0x019a,0x019b,0x019c,0x019d,0x019e,0x019f,0x01a0,0x01a1,0x01a2,
	0x01a3,0x01a4,0x01a5,0x01a6,0x01a7,0x01a8,0x01a9,0x01aa,0x01ab,0x01ac,
	0x01ad,0x01ae,0x01af,0x01b0,0x01b1,0x01b2,0x01b3,0x01b4,0x01b5,0x01b6,
	0x01b7,0x01b8,0x01b9,0x01ba,0x01bb,0x01bc,0x01bd,0x01be,0x01bf,0x01c0,
	0x01c1,0x01c2,0x01c3,0x01c4,0x01c5,0x01c6,0x01c7,0x01c8,0x01c9,0x01ca,
	0x01cb,0x01cc,0x01cd,0x01ce,0x01cf,0x01d0,0x01d1,0x01d2,0x01d3,0x01d4,
	0x01d5,0x01d6,0x01d7,0x01d8,0x01d9,0x01da,0x01db,0x01dc,0x01dd,0x01de,
	0x01df,0x01e0,0x01e1,0x01e2,0x01e3,0x01e4,0x01e5,0x01e6,0x01e7,0x01e8,
	0x01e9,0x01ea,0x01eb,0x01ec,0x01ed,0x01ee,0x01ef,0x01f0,0x01f1,0x01f2,
	0x01f3,0x01f4,0x01f5,0x01f6,0x01f7,0x01f8,0x01f9,0x01fa,0x01fb,0x01fc,
	0x01fd,0x01fe,0x01ff,0x0200,0x0201,0x0202,0x0203,0x0204,0x0205,0x0206,
	0x0207,0x0208,0x0209,0x020a,0x020b,0x020c,0x020d,0x020e,0x020f,0x0210,
	0x0211,0x0212,0x0213,0x0214,0x0215,0x0216,0x0217,0x0218,0x0219,0x021a,
	0x021b,0x021c,0x021d,0x021e,0x021f,0x0220,0x0221,0x0222,0x0223,0x0224,
	0x0225,0x0226,0x0227,0x0228,0x0229,0x022a,0x022b,0x022c,0x022d,0x022e,
	0x022f,0x0230,0x0231,0x0232,0x0233,0x0234,0x0235,0x0236,0x0237,0x0238,
	0x0239,0x023a,0x023b,0x023c,0x023d,0x023e,0x023f,0x0240,0x0241,0x0242,
	0x0243,0x0244,0x0245,0x0246,0x0247,0x0248,0x0249,0x024a,0x024b,0x024c,
	0x024d,0x024e,0x024f,0x0250,0x0251,0x0252,0x0253,0x0254,0x0255,0x0256,
	0x0257,0x0258,0x0259,0x025a,0x025b,0x025c,0x025d,0x025e,0x025f,0x0260,
	0x0261,0x0262,0x0263,0x0264,0x0265,0x0266,0x0267,0x0268,0x0269,0x026a,
	0x026b,0x026c,0x026d,0x026e,0x026f,0x0270,0x0271,0x0272,0x0273,0x0274,
	0x0275,0x0276,0x0277,0x0278,0x0279,0x027a,0x027b,0x027c,0x027d,0x027e,
	0x027f,0x0280,0x0281,0x0282,0x0283,0x0284,0x0285,0x0286,0x0287,0x0288,
	0x0289,0x028a,0x028b,0x028c,0x028d,0x028e,0x028f,0x0290,0x0291,0x0292,
	0x0293,0x0294,0x0295,0x0296,0x0297,0x0298,0x0299,0x029a,0x029b,0x029c,
	0x029d,0x029e,0x029f,0x02a0,0x02a1,0x02a2,0x02a3,0x02a4,0x02a5,0x02a6,
	0x02a7,0x02a8,0x02a9,0x02aa,0x02ab,0x02ac,0x02ad,0x02ae,0x02af,0x02b0,
	0x02b1,0x02b2,0x02b3,0x02b4,0x02b5,0x02b6,0x02b7,0x02b8,0x02bb,0x02bc,
	0x02bd,0x02be,0x02bf,0x02c0,0x02c1,0x02d0,0x02d1,0x02e0,0x02e1,0x02e2,
	0x02e3,0x02e4,0x02ee,0x037a,0x037b,0x037c,0x037d,0x0386,0x0388,0x0389,
	0x038a,0x038c,0x038e,0x038f,0x0390,0x0391,0x0392,0x0393,0x0394,0x0395,
	0x0396,0x0397,0x0398,0x0399,0x039a,0x039b,0x039c,0x039d,0x039e,0x039f,
	0x03a0,0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x03aa,
	0x03ab,0x03ac,0x03ad,0x03ae,0x03af,0x03b0,0x03b1,0x03b2,0x03b3,0x03b4,
	0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,
	0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,
	0x03c9,0x03ca,0x03cb,0x03cc,0x03cd,0x03ce,0x03d0,0x03d1,0x03d2,0x03d3,
	0x03d4,0x03d5,0x03d6,0x03d7,0x03d8,0x03d9,0x03da,0x03db,0x03dc,0x03dd,
	0x03de,0x03df,0x03e0,0x03e1,0x03e2,0x03e3,0x03e4,0x03e5,0x03e6,0x03e7,
	0x03e8,0x03e9,0x03ea,0x03eb,0x03ec,0x03ed,0x03ee,0x03ef,0x03f0,0x03f1,
	0x03f2,0x03f3,0x03f4,0x03f5,0x03f7,0x03f8,0x03f9,0x03fa,0x03fb,0x03fc,
	0x03fd,0x03fe,0x03ff,0x0400,0x0401,0x0402,0x0403,0x0404,0x0405,0x0406,
	0x0407,0x0408,0x0409,0x040a,0x040b,0x040c,0x040d,0x040e,0x040f,0x0410,
	0x0411,0x0412,0x0413,0x0414,0x0415,0x0416,0x0417,0x0418,0x0419,0x041a,
	0x041b,0x041c,0x041d,0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,0x0424,
	0x0425,0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e,
	0x042f,0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0436,0x0437,0x0438,
	0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,0x0440,0x0441,0x0442,
	0x0443,0x0444,0x0445,0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,
	0x044d,0x044e,0x044f,0x0450,0x0451,0x0452,0x0453,0x0454,0x0455,0x0456,
	0x0457,0x0458,0x0459,0x045a,0x045b,0x045c,0x045d,0x045e,0x045f,0x0460,
	0x0461,0x0462,0x0463,0x0464,0x0465,0x0466,0x0467,0x0468,0x0469,0x046a,
	0x046b,0x046c,0x046d,0x046e,0x046f,0x0470,0x0471,0x0472,0x0473,0x0474,
	0x0475,0x0476,0x0477,0x0478,0x0479,0x047a,0x047b,0x047c,0x047d,0x047e,
	0x047f,0x0480,0x0481,0x0482,0x048a,0x048b,0x048c,0x048d,0x048e,0x048f,
	0x0490,0x0491,0x0492,0x0493,0x0494,0x0495,0x0496,0x0497,0x0498,0x0499,
	0x049a,0x049b,0x049c,0x049d,0x049e,0x049f,0x04a0,0x04a1,0x04a2,0x04a3,
	0x04a4,0x04a5,0x04a6,0x04a7,0x04a8,0x04a9,0x04aa,0x04ab,0x04ac,0x04ad,
	0x04ae,0x04af,0x04b0,0x04b1,0x04b2,0x04b3,0x04b4,0x04b5,0x04b6,0x04b7,
	0x04b8,0x04b9,0x04ba,0x04bb,0x04bc,0x04bd,0x04be,0x04bf,0x04c0,0x04c1,
	0x04c2,0x04c3,0x04c4,0x04c5,0x04c6,0x04c7,0x04c8,0x04c9,0x04ca,0x04cb,
	0x04cc,0x04cd,0x04ce,0x04cf,0x04d0,0x04d1,0x04d2,0x04d3,0x04d4,0x04d5,
	0x04d6,0x04d7,0x04d8,0x04d9,0x04da,0x04db,0x04dc,0x04dd,0x04de,0x04df,
	0x04e0,0x04e1,0x04e2,0x04e3,0x04e4,0x04e5,0x04e6,0x04e7,0x04e8,0x04e9,
	0x04ea,0x04eb,0x04ec,0x04ed,0x04ee,0x04ef,0x04f0,0x04f1,0x04f2,0x04f3,
	0x04f4,0x04f5,0x04f6,0x04f7,0x04f8,0x04f9,0x04fa,0x04fb,0x04fc,0x04fd,
	0x04fe,0x04ff,0x0500,0x0501,0x0502,0x0503,0x0504,0x0505,0x0506,0x0507,
	0x0508,0x0509,0x050a,0x050b,0x050c,0x050d,0x050e,0x050f,0x0510,0x0511,
	0x0512,0x0513,0x0531,0x0532,0x0533,0x0534,0x0535,0x0536,0x0537,0x0538,
	0x0539,0x053a,0x053b,0x053c,0x053d,0x053e,0x053f,0x0540,0x0541,0x0542,
	0x0543,0x0544,0x0545,0x0546,0x0547,0x0548,0x0549,0x054a,0x054b,0x054c,
	0x054d,0x054e,0x054f,0x0550,0x0551,0x0552,0x0553,0x0554,0x0555,0x0556,
	0x0559,0x055a,0x055b,0x055c,0x055d,0x055e,0x055f,0x0561,0x0562,0x0563,
	0x0564,0x0565,0x0566,0x0567,0x0568,0x0569,0x056a,0x056b,0x056c,0x056d,
	0x056e,0x056f,0x0570,0x0571,0x0572,0x0573,0x0574,0x0575,0x0576,0x0577,
	0x0578,0x0579,0x057a,0x057b,0x057c,0x057d,0x057e,0x057f,0x0580,0x0581,
	0x0582,0x0583,0x0584,0x0585,0x0586,0x0587,0x0589,0x0904,0x0905,0x0906,
	0x0907,0x0908,0x0909,0x090a,0x090b,0x090c,0x090d,0x090e,0x090f,0x0910,
	0x0911,0x0912,0x0913,0x0914,0x0915,0x0916,0x0917,0x0918,0x0919,0x091a,
	0x091b,0x091c,0x091d,0x091e,0x091f,0x0920,0x0921,0x0922,0x0923,0x0924,
	0x0925,0x0926,0x0927,0x0928,0x0929,0x092a,0x092b,0x092c,0x092d,0x092e,
	0x092f,0x0930,0x0931,0x0932,0x0933,0x0934,0x0935,0x0936,0x0937,0x0938,
	0x0939,0x093d,0x0950,0x0958,0x0959,0x095a,0x095b,0x095c,0x095d,0x095e,
	0x095f,0x0960,0x0961,0x0964,0x0965,0x0966,0x0967,0x0968,0x0969,0x096a,
	0x096b,0x096c,0x096d,0x096e,0x096f,0x0970,0x097b,0x097c,0x097d,0x097e,
	0x097f,0x0985,0x0986,0x0987,0x0988,0x0989,0x098a,0x098b,0x098c,0x098f,
	0x0990,0x0993,0x0994,0x0995,0x0996,0x0997,0x0998,0x0999,0x099a,0x099b,
	0x099c,0x099d,0x099e,0x099f,0x09a0,0x09a1,0x09a2,0x09a3,0x09a4,0x09a5,
	0x09a6,0x09a7,0x09a8,0x09aa,0x09ab,0x09ac,0x09ad,0x09ae,0x09af,0x09b0,
	0x09b2,0x09b6,0x09b7,0x09b8,0x09b9,0x09bd,0x09ce,0x09dc,0x09dd,0x09df,
	0x09e0,0x09e1,0x09e6,0x09e7,0x09e8,0x09e9,0x09ea,0x09eb,0x09ec,0x09ed,
	0x09ee,0x09ef,0x09f0,0x09f1,0x09f4,0x09f5,0x09f6,0x09f7,0x09f8,0x09f9,
	0x09fa,0x0a05,0x0a06,0x0a07,0x0a08,0x0a09,0x0a0a,0x0a0f,0x0a10,0x0a13,
	0x0a14,0x0a15,0x0a16,0x0a17,0x0a18,0x0a19,0x0a1a,0x0a1b,0x0a1c,0x0a1d,
	0x0a1e,0x0a1f,0x0a20,0x0a21,0x0a22,0x0a23,0x0a24,0x0a25,0x0a26,0x0a27,
	0x0a28,0x0a2a,0x0a2b,0x0a2c,0x0a2d,0x0a2e,0x0a2f,0x0a30,0x0a32,0x0a33,
	0x0a35,0x0a36,0x0a38,0x0a39,0x0a59,0x0a5a,0x0a5b,0x0a5c,0x0a5e,0x0a66,
	0x0a67,0x0a68,0x0a69,0x0a6a,0x0a6b,0x0a6c,0x0a6d,0x0a6e,0x0a6f,0x0a72,
	0x0a73,0x0a74,0x0a85,0x0a86,0x0a87,0x0a88,0x0a89,0x0a8a,0x0a8b,0x0a8c,
	0x0a8d,0x0a8f,0x0a90,0x0a91,0x0a93,0x0a94,0x0a95,0x0a96,0x0a97,0x0a98,
	0x0a99,0x0a9a,0x0a9b,0x0a9c,0x0a9d,0x0a9e,0x0a9f,0x0aa0,0x0aa1,0x0aa2,
	0x0aa3,0x0aa4,0x0aa5,0x0aa6,0x0aa7,0x0aa8,0x0aaa,0x0aab,0x0aac,0x0aad,
	0x0aae,0x0aaf,0x0ab0,0x0ab2,0x0ab3,0x0ab5,0x0ab6,0x0ab7,0x0ab8,0x0ab9,
	0x0abd,0x0ad0,0x0ae0,0x0ae1,0x0ae6,0x0ae7,0x0ae8,0x0ae9,0x0aea,0x0aeb,
	0x0aec,0x0aed,0x0aee,0x0aef,0x0b05,0x0b06,0x0b07,0x0b08,0x0b09,0x0b0a,
	0x0b0b,0x0b0c,0x0b0f,0x0b10,0x0b13,0x0b14,0x0b15,0x0b16,0x0b17,0x0b18,
	0x0b19,0x0b1a,0x0b1b,0x0b1c,0x0b1d,0x0b1e,0x0b1f,0x0b20,0x0b21,0x0b22,
	0x0b23,0x0b24,0x0b25,0x0b26,0x0b27,0x0b28,0x0b2a,0x0b2b,0x0b2c,0x0b2d,
	0x0b2e,0x0b2f,0x0b30,0x0b32,0x0b33,0x0b35,0x0b36,0x0b37,0x0b38,0x0b39,
	0x0b3d,0x0b5c,0x0b5d,0x0b5f,0x0b60,0x0b61,0x0b66,0x0b67,0x0b68,0x0b69,
	0x0b6a,0x0b6b,0x0b6c,0x0b6d,0x0b6e,0x0b6f,0x0b70,0x0b71,0x0b83,0x0b85,
	0x0b86,0x0b87,0x0b88,0x0b89,0x0b8a,0x0b8e,0x0b8f,0x0b90,0x0b92,0x0b93,
	0x0b94,0x0b95,0x0b99,0x0b9a,0x0b9c,0x0b9e,0x0b9f,0x0ba3,0x0ba4,0x0ba8,
	0x0ba9,0x0baa,0x0bae,0x0baf,0x0bb0,0x0bb1,0x0bb2,0x0bb3,0x0bb4,0x0bb5,
	0x0bb6,0x0bb7,0x0bb8,0x0bb9,0x0be6,0x0be7,0x0be8,0x0be9,0x0bea,0x0beb,
	0x0bec,0x0bed,0x0bee,0x0bef,0x0bf0,0x0bf1,0x0bf2,0x0c05,0x0c06,0x0c07,
	0x0c08,0x0c09,0x0c0a,0x0c0b,0x0c0c,0x0c0e,0x0c0f,0x0c10,0x0c12,0x0c13,
	0x0c14,0x0c15,0x0c16,0x0c17,0x0c18,0x0c19,0x0c1a,0x0c1b,0x0c1c,0x0c1d,
	0x0c1e,0x0c1f,0x0c20,0x0c21,0x0c22,0x0c23,0x0c24,0x0c25,0x0c26,0x0c27,
	0x0c28,0x0c2a,0x0c2b,0x0c2c,0x0c2d,0x0c2e,0x0c2f,0x0c30,0x0c31,0x0c32,
	0x0c33,0x0c35,0x0c36,0x0c37,0x0c38,0x0c39,0x0c60,0x0c61,0x0c66,0x0c67,
	0x0c68,0x0c69,0x0c6a,0x0c6b,0x0c6c,0x0c6d,0x0c6e,0x0c6f,0x0c85,0x0c86,
	0x0c87,0x0c88,0x0c89,0x0c8a,0x0c8b,0x0c8c,0x0c8e,0x0c8f,0x0c90,0x0c92,
	0x0c93,0x0c94,0x0c95,0x0c96,0x0c97,0x0c98,0x0c99,0x0c9a,0x0c9b,0x0c9c,
	0x0c9d,0x0c9e,0x0c9f,0x0ca0,0x0ca1,0x0ca2,0x0ca3,0x0ca4,0x0ca5,0x0ca6,
	0x0ca7,0x0ca8,0x0caa,0x0cab,0x0cac,0x0cad,0x0cae,0x0caf,0x0cb0,0x0cb1,
	0x0cb2,0x0cb3,0x0cb5,0x0cb6,0x0cb7,0x0cb8,0x0cb9,0x0cbd,0x0cde,0x0ce0,
	0x0ce1,0x0ce6,0x0ce7,0x0ce8,0x0ce9,0x0cea,0x0ceb,0x0cec,0x0ced,0x0cee,
	0x0cef,0x0d05,0x0d06,0x0d07,0x0d08,0x0d09,0x0d0a,0x0d0b,0x0d0c,0x0d0e,
	0x0d0f,0x0d10,0x0d12,0x0d13,0x0d14,0x0d15,0x0d16,0x0d17,0x0d18,0x0d19,
	0x0d1a,0x0d1b,0x0d1c,0x0d1d,0x0d1e,0x0d1f,0x0d20,0x0d21,0x0d22,0x0d23,
	0x0d24,0x0d25,0x0d26,0x0d27,0x0d28,0x0d2a,0x0d2b,0x0d2c,0x0d2d,0x0d2e,
	0x0d2f,0x0d30,0x0d31,0x0d32,0x0d33,0x0d34,0x0d35,0x0d36,0x0d37,0x0d38,
	0x0d39,0x0d60,0x0d61,0x0d66,0x0d67,0x0d68,0x0d69,0x0d6a,0x0d6b,0x0d6c,
	0x0d6d,0x0d6e,0x0d6f,0x0d85,0x0d86,0x0d87,0x0d88,0x0d89,0x0d8a,0x0d8b,
	0x0d8c,0x0d8d,0x0d8e,0x0d8f,0x0d90,0x0d91,0x0d92,0x0d93,0x0d94,0x0d95,
	0x0d96,0x0d9a,0x0d9b,0x0d9c,0x0d9d,0x0d9e,0x0d9f,0x0da0,0x0da1,0x0da2,
	0x0da3,0x0da4,0x0da5,0x0da6,0x0da7,0x0da8,0x0da9,0x0daa,0x0dab,0x0dac,
	0x0dad,0x0dae,0x0daf,0x0db0,0x0db1,0x0db3,0x0db4,0x0db5,0x0db6,0x0db7,
	0x0db8,0x0db9,0x0dba,0x0dbb,0x0dbd,0x0dc0,0x0dc1,0x0dc2,0x0dc3,0x0dc4,
	0x0dc5,0x0dc6,0x0df4,0x0e01,0x0e02,0x0e03,0x0e04,0x0e05,0x0e06,0x0e07,
	0x0e08,0x0e09,0x0e0a,0x0e0b,0x0e0c,0x0e0d,0x0e0e,0x0e0f,0x0e10,0x0e11,
	0x0e12,0x0e13,0x0e14,0x0e15,0x0e16,0x0e17,0x0e18,0x0e19,0x0e1a,0x0e1b,
	0x0e1c,0x0e1d,0x0e1e,0x0e1f,0x0e20,0x0e21,0x0e22,0x0e23,0x0e24,0x0e25,
	0x0e26,0x0e27,0x0e28,0x0e29,0x0e2a,0x0e2b,0x0e2c,0x0e2d,0x0e2e,0x0e2f,
	0x0e30,0x0e32,0x0e33,0x0e40,0x0e41,0x0e42,0x0e43,0x0e44,0x0e45,0x0e46,
	0x0e4f,0x0e50,0x0e51,0x0e52,0x0e53,0x0e54,0x0e55,0x0e56,0x0e57,0x0e58,
	0x0e59,0x0e5a,0x0e5b,0x0e81,0x0e82,0x0e84,0x0e87,0x0e88,0x0e8a,0x0e8d,
	0x0e94,0x0e95,0x0e96,0x0e97,0x0e99,0x0e9a,0x0e9b,0x0e9c,0x0e9d,0x0e9e,
	0x0e9f,0x0ea1,0x0ea2,0x0ea3,0x0ea5,0x0ea7,0x0eaa,0x0eab,0x0ead,0x0eae,
	0x0eaf,0x0eb0,0x0eb2,0x0eb3,0x0ebd,0x0ec0,0x0ec1,0x0ec2,0x0ec3,0x0ec4,
	0x0ec6,0x0ed0,0x0ed1,0x0ed2,0x0ed3,0x0ed4,0x0ed5,0x0ed6,0x0ed7,0x0ed8,
	0x0ed9,0x0edc,0x0edd,0x0f00,0x0f01,0x0f02,0x0f03,0x0f04,0x0f05,0x0f06,
	0x0f07,0x0f08,0x0f09,0x0f0a,0x0f0b,0x0f0c,0x0f0d,0x0f0e,0x0f0f,0x0f10,
	0x0f11,0x0f12,0x0f13,0x0f14,0x0f15,0x0f16,0x0f17,0x0f1a,0x0f1b,0x0f1c,
	0x0f1d,0x0f1e,0x0f1f,0x0f20,0x0f21,0x0f22,0x0f23,0x0f24,0x0f25,0x0f26,
	0x0f27,0x0f28,0x0f29,0x0f2a,0x0f2b,0x0f2c,0x0f2d,0x0f2e,0x0f2f,0x0f30,
	0x0f31,0x0f32,0x0f33,0x0f34,0x0f36,0x0f38,0x0f40,0x0f41,0x0f42,0x0f43,
	0x0f44,0x0f45,0x0f46,0x0f47,0x0f49,0x0f4a,0x0f4b,0x0f4c,0x0f4d,0x0f4e,
	0x0f4f,0x0f50,0x0f51,0x0f52,0x0f53,0x0f54,0x0f55,0x0f56,0x0f57,0x0f58,
	0x0f59,0x0f5a,0x0f5b,0x0f5c,0x0f5d,0x0f5e,0x0f5f,0x0f60,0x0f61,0x0f62,
	0x0f63,0x0f64,0x0f65,0x0f66,0x0f67,0x0f68,0x0f69,0x0f6a,0x0f85,0x0f88,
	0x0f89,0x0f8a,0x0f8b,0x0fbe,0x0fbf,0x0fc0,0x0fc1,0x0fc2,0x0fc3,0x0fc4,
	0x0fc5,0x0fc7,0x0fc8,0x0fc9,0x0fca,0x0fcb,0x0fcc,0x0fcf,0x0fd0,0x0fd1,
	0x1000,0x1001,0x1002,0x1003,0x1004,0x1005,0x1006,0x1007,0x1008,0x1009,
	0x100a,0x100b,0x100c,0x100d,0x100e,0x100f,0x1010,0x1011,0x1012,0x1013,
	0x1014,0x1015,0x1016,0x1017,0x1018,0x1019,0x101a,0x101b,0x101c,0x101d,
	0x101e,0x101f,0x1020,0x1021,0x1023,0x1024,0x1025,0x1026,0x1027,0x1029,
	0x102a,0x1040,0x1041,0x1042,0x1043,0x1044,0x1045,0x1046,0x1047,0x1048,
	0x1049,0x104a,0x104b,0x104c,0x104d,0x104e,0x104f,0x1050,0x1051,0x1052,
	0x1053,0x1054,0x1055,0x10a0,0x10a1,0x10a2,0x10a3,0x10a4,0x10a5,0x10a6,
	0x10a7,0x10a8,0x10a9,0x10aa,0x10ab,0x10ac,0x10ad,0x10ae,0x10af,0x10b0,
	0x10b1,0x10b2,0x10b3,0x10b4,0x10b5,0x10b6,0x10b7,0x10b8,0x10b9,0x10ba,
	0x10bb,0x10bc,0x10bd,0x10be,0x10bf,0x10c0,0x10c1,0x10c2,0x10c3,0x10c4,
	0x10c5,0x10d0,0x10d1,0x10d2,0x10d3,0x10d4,0x10d5,0x10d6,0x10d7,0x10d8,
	0x10d9,0x10da,0x10db,0x10dc,0x10dd,0x10de,0x10df,0x10e0,0x10e1,0x10e2,
	0x10e3,0x10e4,0x10e5,0x10e6,0x10e7,0x10e8,0x10e9,0x10ea,0x10eb,0x10ec,
	0x10ed,0x10ee,0x10ef,0x10f0,0x10f1,0x10f2,0x10f3,0x10f4,0x10f5,0x10f6,
	0x10f7,0x10f8,0x10f9,0x10fa,0x10fb,0x10fc,0x1100,0x1101,0x1102,0x1103,
	0x1104,0x1105,0x1106,0x1107,0x1108,0x1109,0x110a,0x110b,0x110c,0x110d,
	0x110e,0x110f,0x1110,0x1111,0x1112,0x1113,0x1114,0x1115,0x1116,0x1117,
	0x1118,0x1119,0x111a,0x111b,0x111c,0x111d,0x111e,0x111f,0x1120,0x1121,
	0x1122,0x1123,0x1124,0x1125,0x1126,0x1127,0x1128,0x1129,0x112a,0x112b,
	0x112c,0x112d,0x112e,0x112f,0x1130,0x1131,0x1132,0x1133,0x1134,0x1135,
	0x1136,0x1137,0x1138,0x1139,0x113a,0x113b,0x113c,0x113d,0x113e,0x113f,
	0x1140,0x1141,0x1142,0x1143,0x1144,0x1145,0x1146,0x1147,0x1148,0x1149,
	0x114a,0x114b,0x114c,0x114d,0x114e,0x114f,0x1150,0x1151,0x1152,0x1153,
	0x1154,0x1155,0x1156,0x1157,0x1158,0x1159,0x115f,0x1160,0x1161,0x1162,
	0x1163,0x1164,0x1165,0x1166,0x1167,0x1168,0x1169,0x116a,0x116b,0x116c,
	0x116d,0x116e,0x116f,0x1170,0x1171,0x1172,0x1173,0x1174,0x1175,0x1176,
	0x1177,0x1178,0x1179,0x117a,0x117b,0x117c,0x117d,0x117e,0x117f,0x1180,
	0x1181,0x1182,0x1183,0x1184,0x1185,0x1186,0x1187,0x1188,0x1189,0x118a,
	0x118b,0x118c,0x118d,0x118e,0x118f,0x1190,0x1191,0x1192,0x1193,0x1194,
	0x1195,0x1196,0x1197,0x1198,0x1199,0x119a,0x119b,0x119c,0x119d,0x119e,
	0x119f,0x11a0,0x11a1,0x11a2,0x11a8,0x11a9,0x11aa,0x11ab,0x11ac,0x11ad,
	0x11ae,0x11af,0x11b0,0x11b1,0x11b2,0x11b3,0x11b4,0x11b5,0x11b6,0x11b7,
	0x11b8,0x11b9,0x11ba,0x11bb,0x11bc,0x11bd,0x11be,0x11bf,0x11c0,0x11c1,
	0x11c2,0x11c3,0x11c4,0x11c5,0x11c6,0x11c7,0x11c8,0x11c9,0x11ca,0x11cb,
	0x11cc,0x11cd,0x11ce,0x11cf,0x11d0,0x11d1,0x11d2,0x11d3,0x11d4,0x11d5,
	0x11d6,0x11d7,0x11d8,0x11d9,0x11da,0x11db,0x11dc,0x11dd,0x11de,0x11df,
	0x11e0,0x11e1,0x11e2,0x11e3,0x11e4,0x11e5,0x11e6,0x11e7,0x11e8,0x11e9,
	0x11ea,0x11eb,0x11ec,0x11ed,0x11ee,0x11ef,0x11f0,0x11f1,0x11f2,0x11f3,
	0x11f4,0x11f5,0x11f6,0x11f7,0x11f8,0x11f9,0x1200,0x1201,0x1202,0x1203,
	0x1204,0x1205,0x1206,0x1207,0x1208,0x1209,0x120a,0x120b,0x120c,0x120d,
	0x120e,0x120f,0x1210,0x1211,0x1212,0x1213,0x1214,0x1215,0x1216,0x1217,
	0x1218,0x1219,0x121a,0x121b,0x121c,0x121d,0x121e,0x121f,0x1220,0x1221,
	0x1222,0x1223,0x1224,0x1225,0x1226,0x1227,0x1228,0x1229,0x122a,0x122b,
	0x122c,0x122d,0x122e,0x122f,0x1230,0x1231,0x1232,0x1233,0x1234,0x1235,
	0x1236,0x1237,0x1238,0x1239,0x123a,0x123b,0x123c,0x123d,0x123e,0x123f,
	0x1240,0x1241,0x1242,0x1243,0x1244,0x1245,0x1246,0x1247,0x1248,0x124a,
	0x124b,0x124c,0x124d,0x1250,0x1251,0x1252,0x1253,0x1254,0x1255,0x1256,
	0x1258,0x125a,0x125b,0x125c,0x125d,0x1260,0x1261,0x1262,0x1263,0x1264,
	0x1265,0x1266,0x1267,0x1268,0x1269,0x126a,0x126b,0x126c,0x126d,0x126e,
	0x126f,0x1270,0x1271,0x1272,0x1273,0x1274,0x1275,0x1276,0x1277,0x1278,
	0x1279,0x127a,0x127b,0x127c,0x127d,0x127e,0x127f,0x1280,0x1281,0x1282,
	0x1283,0x1284,0x1285,0x1286,0x1287,0x1288,0x128a,0x128b,0x128c,0x128d,
	0x1290,0x1291,0x1292,0x1293,0x1294,0x1295,0x1296,0x1297,0x1298,0x1299,
	0x129a,0x129b,0x129c,0x129d,0x129e,0x129f,0x12a0,0x12a1,0x12a2,0x12a3,
	0x12a4,0x12a5,0x12a6,0x12a7,0x12a8,0x12a9,0x12aa,0x12ab,0x12ac,0x12ad,
	0x12ae,0x12af,0x12b0,0x12b2,0x12b3,0x12b4,0x12b5,0x12b8,0x12b9,0x12ba,
	0x12bb,0x12bc,0x12bd,0x12be,0x12c0,0x12c2,0x12c3,0x12c4,0x12c5,0x12c8,
	0x12c9,0x12ca,0x12cb,0x12cc,0x12cd,0x12ce,0x12cf,0x12d0,0x12d1,0x12d2,
	0x12d3,0x12d4,0x12d5,0x12d6,0x12d8,0x12d9,0x12da,0x12db,0x12dc,0x12dd,
	0x12de,0x12df,0x12e0,0x12e1,0x12e2,0x12e3,0x12e4,0x12e5,0x12e6,0x12e7,
	0x12e8,0x12e9,0x12ea,0x12eb,0x12ec,0x12ed,0x12ee,0x12ef,0x12f0,0x12f1,
	0x12f2,0x12f3,0x12f4,0x12f5,0x12f6,0x12f7,0x12f8,0x12f9,0x12fa,0x12fb,
	0x12fc,0x12fd,0x12fe,0x12ff,0x1300,0x1301,0x1302,0x1303,0x1304,0x1305,
	0x1306,0x1307,0x1308,0x1309,0x130a,0x130b,0x130c,0x130d,0x130e,0x130f,
	0x1310,0x1312,0x1313,0x1314,0x1315,0x1318,0x1319,0x131a,0x131b,0x131c,
	0x131d,0x131e,0x131f,0x1320,0x1321,0x1322,0x1323,0x1324,0x1325,0x1326,
	0x1327,0x1328,0x1329,0x132a,0x132b,0x132c,0x132d,0x132e,0x132f,0x1330,
	0x1331,0x1332,0x1333,0x1334,0x1335,0x1336,0x1337,0x1338,0x1339,0x133a,
	0x133b,0x133c,0x133d,0x133e,0x133f,0x1340,0x1341,0x1342,0x1343,0x1344,
	0x1345,0x1346,0x1347,0x1348,0x1349,0x134a,0x134b,0x134c,0x134d,0x134e,
	0x134f,0x1350,0x1351,0x1352,0x1353,0x1354,0x1355,0x1356,0x1357,0x1358,
	0x1359,0x135a,0x1360,0x1361,0x1362,0x1363,0x1364,0x1365,0x1366,0x1367,
	0x1368,0x1369,0x136a,0x136b,0x136c,0x136d,0x136e,0x136f,0x1370,0x1371,
	0x1372,0x1373,0x1374,0x1375,0x1376,0x1377,0x1378,0x1379,0x137a,0x137b,
	0x137c,0x1380,0x1381,0x1382,0x1383,0x1384,0x1385,0x1386,0x1387,0x1388,
	0x1389,0x138a,0x138b,0x138c,0x138d,0x138e,0x138f,0x13a0,0x13a1,0x13a2,
	0x13a3,0x13a4,0x13a5,0x13a6,0x13a7,0x13a8,0x13a9,0x13aa,0x13ab,0x13ac,
	0x13ad,0x13ae,0x13af,0x13b0,0x13b1,0x13b2,0x13b3,0x13b4,0x13b5,0x13b6,
	0x13b7,0x13b8,0x13b9,0x13ba,0x13bb,0x13bc,0x13bd,0x13be,0x13bf,0x13c0,
	0x13c1,0x13c2,0x13c3,0x13c4,0x13c5,0x13c6,0x13c7,0x13c8,0x13c9,0x13ca,
	0x13cb,0x13cc,0x13cd,0x13ce,0x13cf,0x13d0,0x13d1,0x13d2,0x13d3,0x13d4,
	0x13d5,0x13d6,0x13d7,0x13d8,0x13d9,0x13da,0x13db,0x13dc,0x13dd,0x13de,
	0x13df,0x13e0,0x13e1,0x13e2,0x13e3,0x13e4,0x13e5,0x13e6,0x13e7,0x13e8,
	0x13e9,0x13ea,0x13eb,0x13ec,0x13ed,0x13ee,0x13ef,0x13f0,0x13f1,0x13f2,
	0x13f3,0x13f4,0x1401,0x1402,0x1403,0x1404,0x1405,0x1406,0x1407,0x1408,
	0x1409,0x140a,0x140b,0x140c,0x140d,0x140e,0x140f,0x1410,0x1411,0x1412,
	0x1413,0x1414,0x1415,0x1416,0x1417,0x1418,0x1419,0x141a,0x141b,0x141c,
	0x141d,0x141e,0x141f,0x1420,0x1421,0x1422,0x1423,0x1424,0x1425,0x1426,
	0x1427,0x1428,0x1429,0x142a,0x142b,0x142c,0x142d,0x142e,0x142f,0x1430,
	0x1431,0x1432,0x1433,0x1434,0x1435,0x1436,0x1437,0x1438,0x1439,0x143a,
	0x143b,0x143c,0x143d,0x143e,0x143f,0x1440,0x1441,0x1442,0x1443,0x1444,
	0x1445,0x1446,0x1447,0x1448,0x1449,0x144a,0x144b,0x144c,0x144d,0x144e,
	0x144f,0x1450,0x1451,0x1452,0x1453,0x1454,0x1455,0x1456,0x1457,0x1458,
	0x1459,0x145a,0x145b,0x145c,0x145d,0x145e,0x145f,0x1460,0x1461,0x1462,
	0x1463,0x1464,0x1465,0x1466,0x1467,0x1468,0x1469,0x146a,0x146b,0x146c,
	0x146d,0x146e,0x146f,0x1470,0x1471,0x1472,0x1473,0x1474,0x1475,0x1476,
	0x1477,0x1478,0x1479,0x147a,0x147b,0x147c,0x147d,0x147e,0x147f,0x1480,
	0x1481,0x1482,0x1483,0x1484,0x1485,0x1486,0x1487,0x1488,0x1489,0x148a,
	0x148b,0x148c,0x148d,0x148e,0x148f,0x1490,0x1491,0x1492,0x1493,0x1494,
	0x1495,0x1496,0x1497,0x1498,0x1499,0x149a,0x149b,0x149c,0x149d,0x149e,
	0x149f,0x14a0,0x14a1,0x14a2,0x14a3,0x14a4,0x14a5,0x14a6,0x14a7,0x14a8,
	0x14a9,0x14aa,0x14ab,0x14ac,0x14ad,0x14ae,0x14af,0x14b0,0x14b1,0x14b2,
	0x14b3,0x14b4,0x14b5,0x14b6,0x14b7,0x14b8,0x14b9,0x14ba,0x14bb,0x14bc,
	0x14bd,0x14be,0x14bf,0x14c0,0x14c1,0x14c2,0x14c3,0x14c4,0x14c5,0x14c6,
	0x14c7,0x14c8,0x14c9,0x14ca,0x14cb,0x14cc,0x14cd,0x14ce,0x14cf,0x14d0,
	0x14d1,0x14d2,0x14d3,0x14d4,0x14d5,0x14d6,0x14d7,0x14d8,0x14d9,0x14da,
	0x14db,0x14dc,0x14dd,0x14de,0x14df,0x14e0,0x14e1,0x14e2,0x14e3,0x14e4,
	0x14e5,0x14e6,0x14e7,0x14e8,0x14e9,0x14ea,0x14eb,0x14ec,0x14ed,0x14ee,
	0x14ef,0x14f0,0x14f1,0x14f2,0x14f3,0x14f4,0x14f5,0x14f6,0x14f7,0x14f8,
	0x14f9,0x14fa,0x14fb,0x14fc,0x14fd,0x14fe,0x14ff,0x1500,0x1501,0x1502,
	0x1503,0x1504,0x1505,0x1506,0x1507,0x1508,0x1509,0x150a,0x150b,0x150c,
	0x150d,0x150e,0x150f,0x1510,0x1511,0x1512,0x1513,0x1514,0x1515,0x1516,
	0x1517,0x1518,0x1519,0x151a,0x151b,0x151c,0x151d,0x151e,0x151f,0x1520,
	0x1521,0x1522,0x1523,0x1524,0x1525,0x1526,0x1527,0x1528,0x1529,0x152a,
	0x152b,0x152c,0x152d,0x152e,0x152f,0x1530,0x1531,0x1532,0x1533,0x1534,
	0x1535,0x1536,0x1537,0x1538,0x1539,0x153a,0x153b,0x153c,0x153d,0x153e,
	0x153f,0x1540,0x1541,0x1542,0x1543,0x1544,0x1545,0x1546,0x1547,0x1548,
	0x1549,0x154a,0x154b,0x154c,0x154d,0x154e,0x154f,0x1550,0x1551,0x1552,
	0x1553,0x1554,0x1555,0x1556,0x1557,0x1558,0x1559,0x155a,0x155b,0x155c,
	0x155d,0x155e,0x155f,0x1560,0x1561,0x1562,0x1563,0x1564,0x1565,0x1566,
	0x1567,0x1568,0x1569,0x156a,0x156b,0x156c,0x156d,0x156e,0x156f,0x1570,
	0x1571,0x1572,0x1573,0x1574,0x1575,0x1576,0x1577,0x1578,0x1579,0x157a,
	0x157b,0x157c,0x157d,0x157e,0x157f,0x1580,0x1581,0x1582,0x1583,0x1584,
	0x1585,0x1586,0x1587,0x1588,0x1589,0x158a,0x158b,0x158c,0x158d,0x158e,
	0x158f,0x1590,0x1591,0x1592,0x1593,0x1594,0x1595,0x1596,0x1597,0x1598,
	0x1599,0x159a,0x159b,0x159c,0x159d,0x159e,0x159f,0x15a0,0x15a1,0x15a2,
	0x15a3,0x15a4,0x15a5,0x15a6,0x15a7,0x15a8,0x15a9,0x15aa,0x15ab,0x15ac,
	0x15ad,0x15ae,0x15af,0x15b0,0x15b1,0x15b2,0x15b3,0x15b4,0x15b5,0x15b6,
	0x15b7,0x15b8,0x15b9,0x15ba,0x15bb,0x15bc,0x15bd,0x15be,0x15bf,0x15c0,
	0x15c1,0x15c2,0x15c3,0x15c4,0x15c5,0x15c6,0x15c7,0x15c8,0x15c9,0x15ca,
	0x15cb,0x15cc,0x15cd,0x15ce,0x15cf,0x15d0,0x15d1,0x15d2,0x15d3,0x15d4,
	0x15d5,0x15d6,0x15d7,0x15d8,0x15d9,0x15da,0x15db,0x15dc,0x15dd,0x15de,
	0x15df,0x15e0,0x15e1,0x15e2,0x15e3,0x15e4,0x15e5,0x15e6,0x15e7,0x15e8,
	0x15e9,0x15ea,0x15eb,0x15ec,0x15ed,0x15ee,0x15ef,0x15f0,0x15f1,0x15f2,
	0x15f3,0x15f4,0x15f5,0x15f6,0x15f7,0x15f8,0x15f9,0x15fa,0x15fb,0x15fc,
	0x15fd,0x15fe,0x15ff,0x1600,0x1601,0x1602,0x1603,0x1604,0x1605,0x1606,
	0x1607,0x1608,0x1609,0x160a,0x160b,0x160c,0x160d,0x160e,0x160f,0x1610,
	0x1611,0x1612,0x1613,0x1614,0x1615,0x1616,0x1617,0x1618,0x1619,0x161a,
	0x161b,0x161c,0x161d,0x161e,0x161f,0x1620,0x1621,0x1622,0x1623,0x1624,
	0x1625,0x1626,0x1627,0x1628,0x1629,0x162a,0x162b,0x162c,0x162d,0x162e,
	0x162f,0x1630,0x1631,0x1632,0x1633,0x1634,0x1635,0x1636,0x1637,0x1638,
	0x1639,0x163a,0x163b,0x163c,0x163d,0x163e,0x163f,0x1640,0x1641,0x1642,
	0x1643,0x1644,0x1645,0x1646,0x1647,0x1648,0x1649,0x164a,0x164b,0x164c,
	0x164d,0x164e,0x164f,0x1650,0x1651,0x1652,0x1653,0x1654,0x1655,0x1656,
	0x1657,0x1658,0x1659,0x165a,0x165b,0x165c,0x165d,0x165e,0x165f,0x1660,
	0x1661,0x1662,0x1663,0x1664,0x1665,0x1666,0x1667,0x1668,0x1669,0x166a,
	0x166b,0x166c,0x166d,0x166e,0x166f,0x1670,0x1671,0x1672,0x1673,0x1674,
	0x1675,0x1676,0x1681,0x1682,0x1683,0x1684,0x1685,0x1686,0x1687,0x1688,
	0x1689,0x168a,0x168b,0x168c,0x168d,0x168e,0x168f,0x1690,0x1691,0x1692,
	0x1693,0x1694,0x1695,0x1696,0x1697,0x1698,0x1699,0x169a,0x16a0,0x16a1,
	0x16a2,0x16a3,0x16a4,0x16a5,0x16a6,0x16a7,0x16a8,0x16a9,0x16aa,0x16ab,
	0x16ac,0x16ad,0x16ae,0x16af,0x16b0,0x16b1,0x16b2,0x16b3,0x16b4,0x16b5,
	0x16b6,0x16b7,0x16b8,0x16b9,0x16ba,0x16bb,0x16bc,0x16bd,0x16be,0x16bf,
	0x16c0,0x16c1,0x16c2,0x16c3,0x16c4,0x16c5,0x16c6,0x16c7,0x16c8,0x16c9,
	0x16ca,0x16cb,0x16cc,0x16cd,0x16ce,0x16cf,0x16d0,0x16d1,0x16d2,0x16d3,
	0x16d4,0x16d5,0x16d6,0x16d7,0x16d8,0x16d9,0x16da,0x16db,0x16dc,0x16dd,
	0x16de,0x16df,0x16e0,0x16e1,0x16e2,0x16e3,0x16e4,0x16e5,0x16e6,0x16e7,
	0x16e8,0x16e9,0x16ea,0x16eb,0x16ec,0x16ed,0x16ee,0x16ef,0x16f0,0x1700,
	0x1701,0x1702,0x1703,0x1704,0x1705,0x1706,0x1707,0x1708,0x1709,0x170a,
	0x170b,0x170c,0x170e,0x170f,0x1710,0x1711,0x1720,0x1721,0x1722,0x1723,
	0x1724,0x1725,0x1726,0x1727,0x1728,0x1729,0x172a,0x172b,0x172c,0x172d,
	0x172e,0x172f,0x1730,0x1731,0x1735,0x1736,0x1740,0x1741,0x1742,0x1743,
	0x1744,0x1745,0x1746,0x1747,0x1748,0x1749,0x174a,0x174b,0x174c,0x174d,
	0x174e,0x174f,0x1750,0x1751,0x1760,0x1761,0x1762,0x1763,0x1764,0x1765,
	0x1766,0x1767,0x1768,0x1769,0x176a,0x176b,0x176c,0x176e,0x176f,0x1770,
	0x1780,0x1781,0x1782,0x1783,0x1784,0x1785,0x1786,0x1787,0x1788,0x1789,
	0x178a,0x178b,0x178c,0x178d,0x178e,0x178f,0x1790,0x1791,0x1792,0x1793,
	0x1794,0x1795,0x1796,0x1797,0x1798,0x1799,0x179a,0x179b,0x179c,0x179d,
	0x179e,0x179f,0x17a0,0x17a1,0x17a2,0x17a3,0x17a4,0x17a5,0x17a6,0x17a7,
	0x17a8,0x17a9,0x17aa,0x17ab,0x17ac,0x17ad,0x17ae,0x17af,0x17b0,0x17b1,
	0x17b2,0x17b3,0x17b4,0x17b5,0x17d4,0x17d5,0x17d6,0x17d7,0x17d8,0x17d9,
	0x17da,0x17dc,0x17e0,0x17e1,0x17e2,0x17e3,0x17e4,0x17e5,0x17e6,0x17e7,
	0x17e8,0x17e9,0x1810,0x1811,0x1812,0x1813,0x1814,0x1815,0x1816,0x1817,
	0x1818,0x1819,0x1820,0x1821,0x1822,0x1823,0x1824,0x1825,0x1826,0x1827,
	0x1828,0x1829,0x182a,0x182b,0x182c,0x182d,0x182e,0x182f,0x1830,0x1831,
	0x1832,0x1833,0x1834,0x1835,0x1836,0x1837,0x1838,0x1839,0x183a,0x183b,
	0x183c,0x183d,0x183e,0x183f,0x1840,0x1841,0x1842,0x1843,0x1844,0x1845,
	0x1846,0x1847,0x1848,0x1849,0x184a,0x184b,0x184c,0x184d,0x184e,0x184f,
	0x1850,0x1851,0x1852,0x1853,0x1854,0x1855,0x1856,0x1857,0x1858,0x1859,
	0x185a,0x185b,0x185c,0x185d,0x185e,0x185f,0x1860,0x1861,0x1862,0x1863,
	0x1864,0x1865,0x1866,0x1867,0x1868,0x1869,0x186a,0x186b,0x186c,0x186d,
	0x186e,0x186f,0x1870,0x1871,0x1872,0x1873,0x1874,0x1875,0x1876,0x1877,
	0x1880,0x1881,0x1882,0x1883,0x1884,0x1885,0x1886,0x1887,0x1888,0x1889,
	0x188a,0x188b,0x188c,0x188d,0x188e,0x188f,0x1890,0x1891,0x1892,0x1893,
	0x1894,0x1895,0x1896,0x1897,0x1898,0x1899,0x189a,0x189b,0x189c,0x189d,
	0x189e,0x189f,0x18a0,0x18a1,0x18a2,0x18a3,0x18a4,0x18a5,0x18a6,0x18a7,
	0x18a8,0x1900,0x1901,0x1902,0x1903,0x1904,0x1905,0x1906,0x1907,0x1908,
	0x1909,0x190a,0x190b,0x190c,0x190d,0x190e,0x190f,0x1910,0x1911,0x1912,
	0x1913,0x1914,0x1915,0x1916,0x1917,0x1918,0x1919,0x191a,0x191b,0x191c,
	0x1946,0x1947,0x1948,0x1949,0x194a,0x194b,0x194c,0x194d,0x194e,0x194f,
	0x1950,0x1951,0x1952,0x1953,0x1954,0x1955,0x1956,0x1957,0x1958,0x1959,
	0x195a,0x195b,0x195c,0x195d,0x195e,0x195f,0x1960,0x1961,0x1962,0x1963,
	0x1964,0x1965,0x1966,0x1967,0x1968,0x1969,0x196a,0x196b,0x196c,0x196d,
	0x1970,0x1971,0x1972,0x1973,0x1974,0x1980,0x1981,0x1982,0x1983,0x1984,
	0x1985,0x1986,0x1987,0x1988,0x1989,0x198a,0x198b,0x198c,0x198d,0x198e,
	0x198f,0x1990,0x1991,0x1992,0x1993,0x1994,0x1995,0x1996,0x1997,0x1998,
	0x1999,0x199a,0x199b,0x199c,0x199d,0x199e,0x199f,0x19a0,0x19a1,0x19a2,
	0x19a3,0x19a4,0x19a5,0x19a6,0x19a7,0x19a8,0x19a9,0x19c1,0x19c2,0x19c3,
	0x19c4,0x19c5,0x19c6,0x19c7,0x19d0,0x19d1,0x19d2,0x19d3,0x19d4,0x19d5,
	0x19d6,0x19d7,0x19d8,0x19d9,0x1a00,0x1a01,0x1a02,0x1a03,0x1a04,0x1a05,
	0x1a06,0x1a07,0x1a08,0x1a09,0x1a0a,0x1a0b,0x1a0c,0x1a0d,0x1a0e,0x1a0f,
	0x1a10,0x1a11,0x1a12,0x1a13,0x1a14,0x1a15,0x1a16,0x1a1e,0x1a1f,0x1b05,
	0x1b06,0x1b07,0x1b08,0x1b09,0x1b0a,0x1b0b,0x1b0c,0x1b0d,0x1b0e,0x1b0f,
	0x1b10,0x1b11,0x1b12,0x1b13,0x1b14,0x1b15,0x1b16,0x1b17,0x1b18,0x1b19,
	0x1b1a,0x1b1b,0x1b1c,0x1b1d,0x1b1e,0x1b1f,0x1b20,0x1b21,0x1b22,0x1b23,
	0x1b24,0x1b25,0x1b26,0x1b27,0x1b28,0x1b29,0x1b2a,0x1b2b,0x1b2c,0x1b2d,
	0x1b2e,0x1b2f,0x1b30,0x1b31,0x1b32,0x1b33,0x1b45,0x1b46,0x1b47,0x1b48,
	0x1b49,0x1b4a,0x1b4b,0x1b50,0x1b51,0x1b52,0x1b53,0x1b54,0x1b55,0x1b56,
	0x1b57,0x1b58,0x1b59,0x1b5a,0x1b5b,0x1b5c,0x1b5d,0x1b5e,0x1b5f,0x1b60,
	0x1b61,0x1b62,0x1b63,0x1b64,0x1b65,0x1b66,0x1b67,0x1b68,0x1b69,0x1b6a,
	0x1b74,0x1b75,0x1b76,0x1b77,0x1b78,0x1b79,0x1b7a,0x1b7b,0x1b7c,0x1d00,
	0x1d01,0x1d02,0x1d03,0x1d04,0x1d05,0x1d06,0x1d07,0x1d08,0x1d09,0x1d0a,
	0x1d0b,0x1d0c,0x1d0d,0x1d0e,0x1d0f,0x1d10,0x1d11,0x1d12,0x1d13,0x1d14,
	0x1d15,0x1d16,0x1d17,0x1d18,0x1d19,0x1d1a,0x1d1b,0x1d1c,0x1d1d,0x1d1e,
	0x1d1f,0x1d20,0x1d21,0x1d22,0x1d23,0x1d24,0x1d25,0x1d26,0x1d27,0x1d28,
	0x1d29,0x1d2a,0x1d2b,0x1d2c,0x1d2d,0x1d2e,0x1d2f,0x1d30,0x1d31,0x1d32,
	0x1d33,0x1d34,0x1d35,0x1d36,0x1d37,0x1d38,0x1d39,0x1d3a,0x1d3b,0x1d3c,
	0x1d3d,0x1d3e,0x1d3f,0x1d40,0x1d41,0x1d42,0x1d43,0x1d44,0x1d45,0x1d46,
	0x1d47,0x1d48,0x1d49,0x1d4a,0x1d4b,0x1d4c,0x1d4d,0x1d4e,0x1d4f,0x1d50,
	0x1d51,0x1d52,0x1d53,0x1d54,0x1d55,0x1d56,0x1d57,0x1d58,0x1d59,0x1d5a,
	0x1d5b,0x1d5c,0x1d5d,0x1d5e,0x1d5f,0x1d60,0x1d61,0x1d62,0x1d63,0x1d64,
	0x1d65,0x1d66,0x1d67,0x1d68,0x1d69,0x1d6a,0x1d6b,0x1d6c,0x1d6d,0x1d6e,
	0x1d6f,0x1d70,0x1d71,0x1d72,0x1d73,0x1d74,0x1d75,0x1d76,0x1d77,0x1d78,
	0x1d79,0x1d7a,0x1d7b,0x1d7c,0x1d7d,0x1d7e,0x1d7f,0x1d80,0x1d81,0x1d82,
	0x1d83,0x1d84,0x1d85,0x1d86,0x1d87,0x1d88,0x1d89,0x1d8a,0x1d8b,0x1d8c,
	0x1d8d,0x1d8e,0x1d8f,0x1d90,0x1d91,0x1d92,0x1d93,0x1d94,0x1d95,0x1d96,
	0x1d97,0x1d98,0x1d99,0x1d9a,0x1d9b,0x1d9c,0x1d9d,0x1d9e,0x1d9f,0x1da0,
	0x1da1,0x1da2,0x1da3,0x1da4,0x1da5,0x1da6,0x1da7,0x1da8,0x1da9,0x1daa,
	0x1dab,0x1dac,0x1dad,0x1dae,0x1daf,0x1db0,0x1db1,0x1db2,0x1db3,0x1db4,
	0x1db5,0x1db6,0x1db7,0x1db8,0x1db9,0x1dba,0x1dbb,0x1dbc,0x1dbd,0x1dbe,
	0x1dbf,0x1e00,0x1e01,0x1e02,0x1e03,0x1e04,0x1e05,0x1e06,0x1e07,0x1e08,
	0x1e09,0x1e0a,0x1e0b,0x1e0c,0x1e0d,0x1e0e,0x1e0f,0x1e10,0x1e11,0x1e12,
	0x1e13,0x1e14,0x1e15,0x1e16,0x1e17,0x1e18,0x1e19,0x1e1a,0x1e1b,0x1e1c,
	0x1e1d,0x1e1e,0x1e1f,0x1e20,0x1e21,0x1e22,0x1e23,0x1e24,0x1e25,0x1e26,
	0x1e27,0x1e28,0x1e29,0x1e2a,0x1e2b,0x1e2c,0x1e2d,0x1e2e,0x1e2f,0x1e30,
	0x1e31,0x1e32,0x1e33,0x1e34,0x1e35,0x1e36,0x1e37,0x1e38,0x1e39,0x1e3a,
	0x1e3b,0x1e3c,0x1e3d,0x1e3e,0x1e3f,0x1e40,0x1e41,0x1e42,0x1e43,0x1e44,
	0x1e45,0x1e46,0x1e47,0x1e48,0x1e49,0x1e4a,0x1e4b,0x1e4c,0x1e4d,0x1e4e,
	0x1e4f,0x1e50,0x1e51,0x1e52,0x1e53,0x1e54,0x1e55,0x1e56,0x1e57,0x1e58,
	0x1e59,0x1e5a,0x1e5b,0x1e5c,0x1e5d,0x1e5e,0x1e5f,0x1e60,0x1e61,0x1e62,
	0x1e63,0x1e64,0x1e65,0x1e66,0x1e67,0x1e68,0x1e69,0x1e6a,0x1e6b,0x1e6c,
	0x1e6d,0x1e6e,0x1e6f,0x1e70,0x1e71,0x1e72,0x1e73,0x1e74,0x1e75,0x1e76,
	0x1e77,0x1e78,0x1e79,0x1e7a,0x1e7b,0x1e7c,0x1e7d,0x1e7e,0x1e7f,0x1e80,
	0x1e81,0x1e82,0x1e83,0x1e84,0x1e85,0x1e86,0x1e87,0x1e88,0x1e89,0x1e8a,
	0x1e8b,0x1e8c,0x1e8d,0x1e8e,0x1e8f,0x1e90,0x1e91,0x1e92,0x1e93,0x1e94,
	0x1e95,0x1e96,0x1e97,0x1e98,0x1e99,0x1e9a,0x1e9b,0x1ea0,0x1ea1,0x1ea2,
	0x1ea3,0x1ea4,0x1ea5,0x1ea6,0x1ea7,0x1ea8,0x1ea9,0x1eaa,0x1eab,0x1eac,
	0x1ead,0x1eae,0x1eaf,0x1eb0,0x1eb1,0x1eb2,0x1eb3,0x1eb4,0x1eb5,0x1eb6,
	0x1eb7,0x1eb8,0x1eb9,0x1eba,0x1ebb,0x1ebc,0x1ebd,0x1ebe,0x1ebf,0x1ec0,
	0x1ec1,0x1ec2,0x1ec3,0x1ec4,0x1ec5,0x1ec6,0x1ec7,0x1ec8,0x1ec9,0x1eca,
	0x1ecb,0x1ecc,0x1ecd,0x1ece,0x1ecf,0x1ed0,0x1ed1,0x1ed2,0x1ed3,0x1ed4,
	0x1ed5,0x1ed6,0x1ed7,0x1ed8,0x1ed9,0x1eda,0x1edb,0x1edc,0x1edd,0x1ede,
	0x1edf,0x1ee0,0x1ee1,0x1ee2,0x1ee3,0x1ee4,0x1ee5,0x1ee6,0x1ee7,0x1ee8,
	0x1ee9,0x1eea,0x1eeb,0x1eec,0x1eed,0x1eee,0x1eef,0x1ef0,0x1ef1,0x1ef2,
	0x1ef3,0x1ef4,0x1ef5,0x1ef6,0x1ef7,0x1ef8,0x1ef9,0x1f00,0x1f01,0x1f02,
	0x1f03,0x1f04,0x1f05,0x1f06,0x1f07,0x1f08,0x1f09,0x1f0a,0x1f0b,0x1f0c,
	0x1f0d,0x1f0e,0x1f0f,0x1f10,0x1f11,0x1f12,0x1f13,0x1f14,0x1f15,0x1f18,
	0x1f19,0x1f1a,0x1f1b,0x1f1c,0x1f1d,0x1f20,0x1f21,0x1f22,0x1f23,0x1f24,
	0x1f25,0x1f26,0x1f27,0x1f28,0x1f29,0x1f2a,0x1f2b,0x1f2c,0x1f2d,0x1f2e,
	0x1f2f,0x1f30,0x1f31,0x1f32,0x1f33,0x1f34,0x1f35,0x1f36,0x1f37,0x1f38,
	0x1f39,0x1f3a,0x1f3b,0x1f3c,0x1f3d,0x1f3e,0x1f3f,0x1f40,0x1f41,0x1f42,
	0x1f43,0x1f44,0x1f45,0x1f48,0x1f49,0x1f4a,0x1f4b,0x1f4c,0x1f4d,0x1f50,
	0x1f51,0x1f52,0x1f53,0x1f54,0x1f55,0x1f56,0x1f57,0x1f59,0x1f5b,0x1f5d,
	0x1f5f,0x1f60,0x1f61,0x1f62,0x1f63,0x1f64,0x1f65,0x1f66,0x1f67,0x1f68,
	0x1f69,0x1f6a,0x1f6b,0x1f6c,0x1f6d,0x1f6e,0x1f6f,0x1f70,0x1f71,0x1f72,
	0x1f73,0x1f74,0x1f75,0x1f76,0x1f77,0x1f78,0x1f79,0x1f7a,0x1f7b,0x1f7c,
	0x1f7d,0x1f80,0x1f81,0x1f82,0x1f83,0x1f84,0x1f85,0x1f86,0x1f87,0x1f88,
	0x1f89,0x1f8a,0x1f8b,0x1f8c,0x1f8d,0x1f8e,0x1f8f,0x1f90,0x1f91,0x1f92,
	0x1f93,0x1f94,0x1f95,0x1f96,0x1f97,0x1f98,0x1f99,0x1f9a,0x1f9b,0x1f9c,
	0x1f9d,0x1f9e,0x1f9f,0x1fa0,0x1fa1,0x1fa2,0x1fa3,0x1fa4,0x1fa5,0x1fa6,
	0x1fa7,0x1fa8,0x1fa9,0x1faa,0x1fab,0x1fac,0x1fad,0x1fae,0x1faf,0x1fb0,
	0x1fb1,0x1fb2,0x1fb3,0x1fb4,0x1fb6,0x1fb7,0x1fb8,0x1fb9,0x1fba,0x1fbb,
	0x1fbc,0x1fbe,0x1fc2,0x1fc3,0x1fc4,0x1fc6,0x1fc7,0x1fc8,0x1fc9,0x1fca,
	0x1fcb,0x1fcc,0x1fd0,0x1fd1,0x1fd2,0x1fd3,0x1fd6,0x1fd7,0x1fd8,0x1fd9,
	0x1fda,0x1fdb,0x1fe0,0x1fe1,0x1fe2,0x1fe3,0x1fe4,0x1fe5,0x1fe6,0x1fe7,
	0x1fe8,0x1fe9,0x1fea,0x1feb,0x1fec,0x1ff2,0x1ff3,0x1ff4,0x1ff6,0x1ff7,
	0x1ff8,0x1ff9,0x1ffa,0x1ffb,0x1ffc,0x200e,0x2071,0x207f,0x2090,0x2091,
	0x2092,0x2093,0x2094,0x2102,0x2107,0x210a,0x210b,0x210c,0x210d,0x210e,
	0x210f,0x2110,0x2111,0x2112,0x2113,0x2115,0x2119,0x211a,0x211b,0x211c,
	0x211d,0x2124,0x2126,0x2128,0x212a,0x212b,0x212c,0x212d,0x212f,0x2130,
	0x2131,0x2132,0x2133,0x2134,0x2135,0x2136,0x2137,0x2138,0x2139,0x213c,
	0x213d,0x213e,0x213f,0x2145,0x2146,0x2147,0x2148,0x2149,0x214e,0x2160,
	0x2161,0x2162,0x2163,0x2164,0x2165,0x2166,0x2167,0x2168,0x2169,0x216a,
	0x216b,0x216c,0x216d,0x216e,0x216f,0x2170,0x2171,0x2172,0x2173,0x2174,
	0x2175,0x2176,0x2177,0x2178,0x2179,0x217a,0x217b,0x217c,0x217d,0x217e,
	0x217f,0x2180,0x2181,0x2182,0x2183,0x2184,0x2336,0x2337,0x2338,0x2339,
	0x233a,0x233b,0x233c,0x233d,0x233e,0x233f,0x2340,0x2341,0x2342,0x2343,
	0x2344,0x2345,0x2346,0x2347,0x2348,0x2349,0x234a,0x234b,0x234c,0x234d,
	0x234e,0x234f,0x2350,0x2351,0x2352,0x2353,0x2354,0x2355,0x2356,0x2357,
	0x2358,0x2359,0x235a,0x235b,0x235c,0x235d,0x235e,0x235f,0x2360,0x2361,
	0x2362,0x2363,0x2364,0x2365,0x2366,0x2367,0x2368,0x2369,0x236a,0x236b,
	0x236c,0x236d,0x236e,0x236f,0x2370,0x2371,0x2372,0x2373,0x2374,0x2375,
	0x2376,0x2377,0x2378,0x2379,0x237a,0x2395,0x249c,0x249d,0x249e,0x249f,
	0x24a0,0x24a1,0x24a2,0x24a3,0x24a4,0x24a5,0x24a6,0x24a7,0x24a8,0x24a9,
	0x24aa,0x24ab,0x24ac,0x24ad,0x24ae,0x24af,0x24b0,0x24b1,0x24b2,0x24b3,
	0x24b4,0x24b5,0x24b6,0x24b7,0x24b8,0x24b9,0x24ba,0x24bb,0x24bc,0x24bd,
	0x24be,0x24bf,0x24c0,0x24c1,0x24c2,0x24c3,0x24c4,0x24c5,0x24c6,0x24c7,
	0x24c8,0x24c9,0x24ca,0x24cb,0x24cc,0x24cd,0x24ce,0x24cf,0x24d0,0x24d1,
	0x24d2,0x24d3,0x24d4,0x24d5,0x24d6,0x24d7,0x24d8,0x24d9,0x24da,0x24db,
	0x24dc,0x24dd,0x24de,0x24df,0x24e0,0x24e1,0x24e2,0x24e3,0x24e4,0x24e5,
	0x24e6,0x24e7,0x24e8,0x24e9,0x26ac,0x2800,0x2801,0x2802,0x2803,0x2804,
	0x2805,0x2806,0x2807,0x2808,0x2809,0x280a,0x280b,0x280c,0x280d,0x280e,
	0x280f,0x2810,0x2811,0x2812,0x2813,0x2814,0x2815,0x2816,0x2817,0x2818,
	0x2819,0x281a,0x281b,0x281c,0x281d,0x281e,0x281f,0x2820,0x2821,0x2822,
	0x2823,0x2824,0x2825,0x2826,0x2827,0x2828,0x2829,0x282a,0x282b,0x282c,
	0x282d,0x282e,0x282f,0x2830,0x2831,0x2832,0x2833,0x2834,0x2835,0x2836,
	0x2837,0x2838,0x2839,0x283a,0x283b,0x283c,0x283d,0x283e,0x283f,0x2840,
	0x2841,0x2842,0x2843,0x2844,0x2845,0x2846,0x2847,0x2848,0x2849,0x284a,
	0x284b,0x284c,0x284d,0x284e,0x284f,0x2850,0x2851,0x2852,0x2853,0x2854,
	0x2855,0x2856,0x2857,0x2858,0x2859,0x285a,0x285b,0x285c,0x285d,0x285e,
	0x285f,0x2860,0x2861,0x2862,0x2863,0x2864,0x2865,0x2866,0x2867,0x2868,
	0x2869,0x286a,0x286b,0x286c,0x286d,0x286e,0x286f,0x2870,0x2871,0x2872,
	0x2873,0x2874,0x2875,0x2876,0x2877,0x2878,0x2879,0x287a,0x287b,0x287c,
	0x287d,0x287e,0x287f,0x2880,0x2881,0x2882,0x2883,0x2884,0x2885,0x2886,
	0x2887,0x2888,0x2889,0x288a,0x288b,0x288c,0x288d,0x288e,0x288f,0x2890,
	0x2891,0x2892,0x2893,0x2894,0x2895,0x2896,0x2897,0x2898,0x2899,0x289a,
	0x289b,0x289c,0x289d,0x289e,0x289f,0x28a0,0x28a1,0x28a2,0x28a3,0x28a4,
	0x28a5,0x28a6,0x28a7,0x28a8,0x28a9,0x28aa,0x28ab,0x28ac,0x28ad,0x28ae,
	0x28af,0x28b0,0x28b1,0x28b2,0x28b3,0x28b4,0x28b5,0x28b6,0x28b7,0x28b8,
	0x28b9,0x28ba,0x28bb,0x28bc,0x28bd,0x28be,0x28bf,0x28c0,0x28c1,0x28c2,
	0x28c3,0x28c4,0x28c5,0x28c6,0x28c7,0x28c8,0x28c9,0x28ca,0x28cb,0x28cc,
	0x28cd,0x28ce,0x28cf,0x28d0,0x28d1,0x28d2,0x28d3,0x28d4,0x28d5,0x28d6,
	0x28d7,0x28d8,0x28d9,0x28da,0x28db,0x28dc,0x28dd,0x28de,0x28df,0x28e0,
	0x28e1,0x28e2,0x28e3,0x28e4,0x28e5,0x28e6,0x28e7,0x28e8,0x28e9,0x28ea,
	0x28eb,0x28ec,0x28ed,0x28ee,0x28ef,0x28f0,0x28f1,0x28f2,0x28f3,0x28f4,
	0x28f5,0x28f6,0x28f7,0x28f8,0x28f9,0x28fa,0x28fb,0x28fc,0x28fd,0x28fe,
	0x28ff,0x2c00,0x2c01,0x2c02,0x2c03,0x2c04,0x2c05,0x2c06,0x2c07,0x2c08,
	0x2c09,0x2c0a,0x2c0b,0x2c0c,0x2c0d,0x2c0e,0x2c0f,0x2c10,0x2c11,0x2c12,
	0x2c13,0x2c14,0x2c15,0x2c16,0x2c17,0x2c18,0x2c19,0x2c1a,0x2c1b,0x2c1c,
	0x2c1d,0x2c1e,0x2c1f,0x2c20,0x2c21,0x2c22,0x2c23,0x2c24,0x2c25,0x2c26,
	0x2c27,0x2c28,0x2c29,0x2c2a,0x2c2b,0x2c2c,0x2c2d,0x2c2e,0x2c30,0x2c31,
	0x2c32,0x2c33,0x2c34,0x2c35,0x2c36,0x2c37,0x2c38,0x2c39,0x2c3a,0x2c3b,
	0x2c3c,0x2c3d,0x2c3e,0x2c3f,0x2c40,0x2c41,0x2c42,0x2c43,0x2c44,0x2c45,
	0x2c46,0x2c47,0x2c48,0x2c49,0x2c4a,0x2c4b,0x2c4c,0x2c4d,0x2c4e,0x2c4f,
	0x2c50,0x2c51,0x2c52,0x2c53,0x2c54,0x2c55,0x2c56,0x2c57,0x2c58,0x2c59,
	0x2c5a,0x2c5b,0x2c5c,0x2c5d,0x2c5e,0x2c60,0x2c61,0x2c62,0x2c63,0x2c64,
	0x2c65,0x2c66,0x2c67,0x2c68,0x2c69,0x2c6a,0x2c6b,0x2c6c,0x2c74,0x2c75,
	0x2c76,0x2c77,0x2c80,0x2c81,0x2c82,0x2c83,0x2c84,0x2c85,0x2c86,0x2c87,
	0x2c88,0x2c89,0x2c8a,0x2c8b,0x2c8c,0x2c8d,0x2c8e,0x2c8f,0x2c90,0x2c91,
	0x2c92,0x2c93,0x2c94,0x2c95,0x2c96,0x2c97,0x2c98,0x2c99,0x2c9a,0x2c9b,
	0x2c9c,0x2c9d,0x2c9e,0x2c9f,0x2ca0,0x2ca1,0x2ca2,0x2ca3,0x2ca4,0x2ca5,
	0x2ca6,0x2ca7,0x2ca8,0x2ca9,0x2caa,0x2cab,0x2cac,0x2cad,0x2cae,0x2caf,
	0x2cb0,0x2cb1,0x2cb2,0x2cb3,0x2cb4,0x2cb5,0x2cb6,0x2cb7,0x2cb8,0x2cb9,
	0x2cba,0x2cbb,0x2cbc,0x2cbd,0x2cbe,0x2cbf,0x2cc0,0x2cc1,0x2cc2,0x2cc3,
	0x2cc4,0x2cc5,0x2cc6,0x2cc7,0x2cc8,0x2cc9,0x2cca,0x2ccb,0x2ccc,0x2ccd,
	0x2cce,0x2ccf,0x2cd0,0x2cd1,0x2cd2,0x2cd3,0x2cd4,0x2cd5,0x2cd6,0x2cd7,
	0x2cd8,0x2cd9,0x2cda,0x2cdb,0x2cdc,0x2cdd,0x2cde,0x2cdf,0x2ce0,0x2ce1,
	0x2ce2,0x2ce3,0x2ce4,0x2d00,0x2d01,0x2d02,0x2d03,0x2d04,0x2d05,0x2d06,
	0x2d07,0x2d08,0x2d09,0x2d0a,0x2d0b,0x2d0c,0x2d0d,0x2d0e,0x2d0f,0x2d10,
	0x2d11,0x2d12,0x2d13,0x2d14,0x2d15,0x2d16,0x2d17,0x2d18,0x2d19,0x2d1a,
	0x2d1b,0x2d1c,0x2d1d,0x2d1e,0x2d1f,0x2d20,0x2d21,0x2d22,0x2d23,0x2d24,
	0x2d25,0x2d30,0x2d31,0x2d32,0x2d33,0x2d34,0x2d35,0x2d36,0x2d37,0x2d38,
	0x2d39,0x2d3a,0x2d3b,0x2d3c,0x2d3d,0x2d3e,0x2d3f,0x2d40,0x2d41,0x2d42,
	0x2d43,0x2d44,0x2d45,0x2d46,0x2d47,0x2d48,0x2d49,0x2d4a,0x2d4b,0x2d4c,
	0x2d4d,0x2d4e,0x2d4f,0x2d50,0x2d51,0x2d52,0x2d53,0x2d54,0x2d55,0x2d56,
	0x2d57,0x2d58,0x2d59,0x2d5a,0x2d5b,0x2d5c,0x2d5d,0x2d5e,0x2d5f,0x2d60,
	0x2d61,0x2d62,0x2d63,0x2d64,0x2d65,0x2d6f,0x2d80,0x2d81,0x2d82,0x2d83,
	0x2d84,0x2d85,0x2d86,0x2d87,0x2d88,0x2d89,0x2d8a,0x2d8b,0x2d8c,0x2d8d,
	0x2d8e,0x2d8f,0x2d90,0x2d91,0x2d92,0x2d93,0x2d94,0x2d95,0x2d96,0x2da0,
	0x2da1,0x2da2,0x2da3,0x2da4,0x2da5,0x2da6,0x2da8,0x2da9,0x2daa,0x2dab,
	0x2dac,0x2dad,0x2dae,0x2db0,0x2db1,0x2db2,0x2db3,0x2db4,0x2db5,0x2db6,
	0x2db8,0x2db9,0x2dba,0x2dbb,0x2dbc,0x2dbd,0x2dbe,0x2dc0,0x2dc1,0x2dc2,
	0x2dc3,0x2dc4,0x2dc5,0x2dc6,0x2dc8,0x2dc9,0x2dca,0x2dcb,0x2dcc,0x2dcd,
	0x2dce,0x2dd0,0x2dd1,0x2dd2,0x2dd3,0x2dd4,0x2dd5,0x2dd6,0x2dd8,0x2dd9,
	0x2dda,0x2ddb,0x2ddc,0x2ddd,0x2dde,0x3005,0x3006,0x3007,0x3021,0x3022,
	0x3023,0x3024,0x3025,0x3026,0x3027,0x3028,0x3029,0x3031,0x3032,0x3033,
	0x3034,0x3035,0x3038,0x3039,0x303a,0x303b,0x303c,0x3041,0x3042,0x3043,
	0x3044,0x3045,0x3046,0x3047,0x3048,0x3049,0x304a,0x304b,0x304c,0x304d,
	0x304e,0x304f,0x3050,0x3051,0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,
	0x3058,0x3059,0x305a,0x305b,0x305c,0x305d,0x305e,0x305f,0x3060,0x3061,
	0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,0x3068,0x3069,0x306a,0x306b,
	0x306c,0x306d,0x306e,0x306f,0x3070,0x3071,0x3072,0x3073,0x3074,0x3075,
	0x3076,0x3077,0x3078,0x3079,0x307a,0x307b,0x307c,0x307d,0x307e,0x307f,
	0x3080,0x3081,0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,0x3088,0x3089,
	0x308a,0x308b,0x308c,0x308d,0x308e,0x308f,0x3090,0x3091,0x3092,0x3093,
	0x3094,0x3095,0x3096,0x309d,0x309e,0x309f,0x30a1,0x30a2,0x30a3,0x30a4,
	0x30a5,0x30a6,0x30a7,0x30a8,0x30a9,0x30aa,0x30ab,0x30ac,0x30ad,0x30ae,
	0x30af,0x30b0,0x30b1,0x30b2,0x30b3,0x30b4,0x30b5,0x30b6,0x30b7,0x30b8,
	0x30b9,0x30ba,0x30bb,0x30bc,0x30bd,0x30be,0x30bf,0x30c0,0x30c1,0x30c2,
	0x30c3,0x30c4,0x30c5,0x30c6,0x30c7,0x30c8,0x30c9,0x30ca,0x30cb,0x30cc,
	0x30cd,0x30ce,0x30cf,0x30d0,0x30d1,0x30d2,0x30d3,0x30d4,0x30d5,0x30d6,
	0x30d7,0x30d8,0x30d9,0x30da,0x30db,0x30dc,0x30dd,0x30de,0x30df,0x30e0,
	0x30e1,0x30e2,0x30e3,0x30e4,0x30e5,0x30e6,0x30e7,0x30e8,0x30e9,0x30ea,
	0x30eb,0x30ec,0x30ed,0x30ee,0x30ef,0x30f0,0x30f1,0x30f2,0x30f3,0x30f4,
	0x30f5,0x30f6,0x30f7,0x30f8,0x30f9,0x30fa,0x30fc,0x30fd,0x30fe,0x30ff,
	0x3105,0x3106,0x3107,0x3108,0x3109,0x310a,0x310b,0x310c,0x310d,0x310e,
	0x310f,0x3110,0x3111,0x3112,0x3113,0x3114,0x3115,0x3116,0x3117,0x3118,
	0x3119,0x311a,0x311b,0x311c,0x311d,0x311e,0x311f,0x3120,0x3121,0x3122,
	0x3123,0x3124,0x3125,0x3126,0x3127,0x3128,0x3129,0x312a,0x312b,0x312c,
	0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137,0x3138,0x3139,0x313a,
	0x313b,0x313c,0x313d,0x313e,0x313f,0x3140,0x3141,0x3142,0x3143,0x3144,
	0x3145,0x3146,0x3147,0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,
	0x314f,0x3150,0x3151,0x3152,0x3153,0x3154,0x3155,0x3156,0x3157,0x3158,
	0x3159,0x315a,0x315b,0x315c,0x315d,0x315e,0x315f,0x3160,0x3161,0x3162,
	0x3163,0x3164,0x3165,0x3166,0x3167,0x3168,0x3169,0x316a,0x316b,0x316c,
	0x316d,0x316e,0x316f,0x3170,0x3171,0x3172,0x3173,0x3174,0x3175,0x3176,
	0x3177,0x3178,0x3179,0x317a,0x317b,0x317c,0x317d,0x317e,0x317f,0x3180,
	0x3181,0x3182,0x3183,0x3184,0x3185,0x3186,0x3187,0x3188,0x3189,0x318a,
	0x318b,0x318c,0x318d,0x318e,0x3190,0x3191,0x3192,0x3193,0x3194,0x3195,
	0x3196,0x3197,0x3198,0x3199,0x319a,0x319b,0x319c,0x319d,0x319e,0x319f,
	0x31a0,0x31a1,0x31a2,0x31a3,0x31a4,0x31a5,0x31a6,0x31a7,0x31a8,0x31a9,
	0x31aa,0x31ab,0x31ac,0x31ad,0x31ae,0x31af,0x31b0,0x31b1,0x31b2,0x31b3,
	0x31b4,0x31b5,0x31b6,0x31b7,0x31f0,0x31f1,0x31f2,0x31f3,0x31f4,0x31f5,
	0x31f6,0x31f7,0x31f8,0x31f9,0x31fa,0x31fb,0x31fc,0x31fd,0x31fe,0x31ff,
	0x3200,0x3201,0x3202,0x3203,0x3204,0x3205,0x3206,0x3207,0x3208,0x3209,
	0x320a,0x320b,0x320c,0x320d,0x320e,0x320f,0x3210,0x3211,0x3212,0x3213,
	0x3214,0x3215,0x3216,0x3217,0x3218,0x3219,0x321a,0x321b,0x321c,0x3220,
	0x3221,0x3222,0x3223,0x3224,0x3225,0x3226,0x3227,0x3228,0x3229,0x322a,
	0x322b,0x322c,0x322d,0x322e,0x322f,0x3230,0x3231,0x3232,0x3233,0x3234,
	0x3235,0x3236,0x3237,0x3238,0x3239,0x323a,0x323b,0x323c,0x323d,0x323e,
	0x323f,0x3240,0x3241,0x3242,0x3243,0x3260,0x3261,0x3262,0x3263,0x3264,
	0x3265,0x3266,0x3267,0x3268,0x3269,0x326a,0x326b,0x326c,0x326d,0x326e,
	0x326f,0x3270,0x3271,0x3272,0x3273,0x3274,0x3275,0x3276,0x3277,0x3278,
	0x3279,0x327a,0x327b,0x327f,0x3280,0x3281,0x3282,0x3283,0x3284,0x3285,
	0x3286,0x3287,0x3288,0x3289,0x328a,0x328b,0x328c,0x328d,0x328e,0x328f,
	0x3290,0x3291,0x3292,0x3293,0x3294,0x3295,0x3296,0x3297,0x3298,0x3299,
	0x329a,0x329b,0x329c,0x329d,0x329e,0x329f,0x32a0,0x32a1,0x32a2,0x32a3,
	0x32a4,0x32a5,0x32a6,0x32a7,0x32a8,0x32a9,0x32aa,0x32ab,0x32ac,0x32ad,
	0x32ae,0x32af,0x32b0,0x32c0,0x32c1,0x32c2,0x32c3,0x32c4,0x32c5,0x32c6,
	0x32c7,0x32c8,0x32c9,0x32ca,0x32cb,0x32d0,0x32d1,0x32d2,0x32d3,0x32d4,
	0x32d5,0x32d6,0x32d7,0x32d8,0x32d9,0x32da,0x32db,0x32dc,0x32dd,0x32de,
	0x32df,0x32e0,0x32e1,0x32e2,0x32e3,0x32e4,0x32e5,0x32e6,0x32e7,0x32e8,
	0x32e9,0x32ea,0x32eb,0x32ec,0x32ed,0x32ee,0x32ef,0x32f0,0x32f1,0x32f2,
	0x32f3,0x32f4,0x32f5,0x32f6,0x32f7,0x32f8,0x32f9,0x32fa,0x32fb,0x32fc,
	0x32fd,0x32fe,0x3300,0x3301,0x3302,0x3303,0x3304,0x3305,0x3306,0x3307,
	0x3308,0x3309,0x330a,0x330b,0x330c,0x330d,0x330e,0x330f,0x3310,0x3311,
	0x3312,0x3313,0x3314,0x3315,0x3316,0x3317,0x3318,0x3319,0x331a,0x331b,
	0x331c,0x331d,0x331e,0x331f,0x3320,0x3321,0x3322,0x3323,0x3324,0x3325,
	0x3326,0x3327,0x3328,0x3329,0x332a,0x332b,0x332c,0x332d,0x332e,0x332f,
	0x3330,0x3331,0x3332,0x3333,0x3334,0x3335,0x3336,0x3337,0x3338,0x3339,
	0x333a,0x333b,0x333c,0x333d,0x333e,0x333f,0x3340,0x3341,0x3342,0x3343,
	0x3344,0x3345,0x3346,0x3347,0x3348,0x3349,0x334a,0x334b,0x334c,0x334d,
	0x334e,0x334f,0x3350,0x3351,0x3352,0x3353,0x3354,0x3355,0x3356,0x3357,
	0x3358,0x3359,0x335a,0x335b,0x335c,0x335d,0x335e,0x335f,0x3360,0x3361,
	0x3362,0x3363,0x3364,0x3365,0x3366,0x3367,0x3368,0x3369,0x336a,0x336b,
	0x336c,0x336d,0x336e,0x336f,0x3370,0x3371,0x3372,0x3373,0x3374,0x3375,
	0x3376,0x337b,0x337c,0x337d,0x337e,0x337f,0x3380,0x3381,0x3382,0x3383,
	0x3384,0x3385,0x3386,0x3387,0x3388,0x3389,0x338a,0x338b,0x338c,0x338d,
	0x338e,0x338f,0x3390,0x3391,0x3392,0x3393,0x3394,0x3395,0x3396,0x3397,
	0x3398,0x3399,0x339a,0x339b,0x339c,0x339d,0x339e,0x339f,0x33a0,0x33a1,
	0x33a2,0x33a3,0x33a4,0x33a5,0x33a6,0x33a7,0x33a8,0x33a9,0x33aa,0x33ab,
	0x33ac,0x33ad,0x33ae,0x33af,0x33b0,0x33b1,0x33b2,0x33b3,0x33b4,0x33b5,
	0x33b6,0x33b7,0x33b8,0x33b9,0x33ba,0x33bb,0x33bc,0x33bd,0x33be,0x33bf,
	0x33c0,0x33c1,0x33c2,0x33c3,0x33c4,0x33c5,0x33c6,0x33c7,0x33c8,0x33c9,
	0x33ca,0x33cb,0x33cc,0x33cd,0x33ce,0x33cf,0x33d0,0x33d1,0x33d2,0x33d3,
	0x33d4,0x33d5,0x33d6,0x33d7,0x33d8,0x33d9,0x33da,0x33db,0x33dc,0x33dd,
	0x33e0,0x33e1,0x33e2,0x33e3,0x33e4,0x33e5,0x33e6,0x33e7,0x33e8,0x33e9,
	0x33ea,0x33eb,0x33ec,0x33ed,0x33ee,0x33ef,0x33f0,0x33f1,0x33f2,0x33f3,
	0x33f4,0x33f5,0x33f6,0x33f7,0x33f8,0x33f9,0x33fa,0x33fb,0x33fc,0x33fd,
	0x33fe,0x3400,0x4db5,0x4e00,0x9fbb,0xa000,0xa001,0xa002,0xa003,0xa004,
	0xa005,0xa006,0xa007,0xa008,0xa009,0xa00a,0xa00b,0xa00c,0xa00d,0xa00e,
	0xa00f,0xa010,0xa011,0xa012,0xa013,0xa014,0xa015,0xa016,0xa017,0xa018,
	0xa019,0xa01a,0xa01b,0xa01c,0xa01d,0xa01e,0xa01f,0xa020,0xa021,0xa022,
	0xa023,0xa024,0xa025,0xa026,0xa027,0xa028,0xa029,0xa02a,0xa02b,0xa02c,
	0xa02d,0xa02e,0xa02f,0xa030,0xa031,0xa032,0xa033,0xa034,0xa035,0xa036,
	0xa037,0xa038,0xa039,0xa03a,0xa03b,0xa03c,0xa03d,0xa03e,0xa03f,0xa040,
	0xa041,0xa042,0xa043,0xa044,0xa045,0xa046,0xa047,0xa048,0xa049,0xa04a,
	0xa04b,0xa04c,0xa04d,0xa04e,0xa04f,0xa050,0xa051,0xa052,0xa053,0xa054,
	0xa055,0xa056,0xa057,0xa058,0xa059,0xa05a,0xa05b,0xa05c,0xa05d,0xa05e,
	0xa05f,0xa060,0xa061,0xa062,0xa063,0xa064,0xa065,0xa066,0xa067,0xa068,
	0xa069,0xa06a,0xa06b,0xa06c,0xa06d,0xa06e,0xa06f,0xa070,0xa071,0xa072,
	0xa073,0xa074,0xa075,0xa076,0xa077,0xa078,0xa079,0xa07a,0xa07b,0xa07c,
	0xa07d,0xa07e,0xa07f,0xa080,0xa081,0xa082,0xa083,0xa084,0xa085,0xa086,
	0xa087,0xa088,0xa089,0xa08a,0xa08b,0xa08c,0xa08d,0xa08e,0xa08f,0xa090,
	0xa091,0xa092,0xa093,0xa094,0xa095,0xa096,0xa097,0xa098,0xa099,0xa09a,
	0xa09b,0xa09c,0xa09d,0xa09e,0xa09f,0xa0a0,0xa0a1,0xa0a2,0xa0a3,0xa0a4,
	0xa0a5,0xa0a6,0xa0a7,0xa0a8,0xa0a9,0xa0aa,0xa0ab,0xa0ac,0xa0ad,0xa0ae,
	0xa0af,0xa0b0,0xa0b1,0xa0b2,0xa0b3,0xa0b4,0xa0b5,0xa0b6,0xa0b7,0xa0b8,
	0xa0b9,0xa0ba,0xa0bb,0xa0bc,0xa0bd,0xa0be,0xa0bf,0xa0c0,0xa0c1,0xa0c2,
	0xa0c3,0xa0c4,0xa0c5,0xa0c6,0xa0c7,0xa0c8,0xa0c9,0xa0ca,0xa0cb,0xa0cc,
	0xa0cd,0xa0ce,0xa0cf,0xa0d0,0xa0d1,0xa0d2,0xa0d3,0xa0d4,0xa0d5,0xa0d6,
	0xa0d7,0xa0d8,0xa0d9,0xa0da,0xa0db,0xa0dc,0xa0dd,0xa0de,0xa0df,0xa0e0,
	0xa0e1,0xa0e2,0xa0e3,0xa0e4,0xa0e5,0xa0e6,0xa0e7,0xa0e8,0xa0e9,0xa0ea,
	0xa0eb,0xa0ec,0xa0ed,0xa0ee,0xa0ef,0xa0f0,0xa0f1,0xa0f2,0xa0f3,0xa0f4,
	0xa0f5,0xa0f6,0xa0f7,0xa0f8,0xa0f9,0xa0fa,0xa0fb,0xa0fc,0xa0fd,0xa0fe,
	0xa0ff,0xa100,0xa101,0xa102,0xa103,0xa104,0xa105,0xa106,0xa107,0xa108,
	0xa109,0xa10a,0xa10b,0xa10c,0xa10d,0xa10e,0xa10f,0xa110,0xa111,0xa112,
	0xa113,0xa114,0xa115,0xa116,0xa117,0xa118,0xa119,0xa11a,0xa11b,0xa11c,
	0xa11d,0xa11e,0xa11f,0xa120,0xa121,0xa122,0xa123,0xa124,0xa125,0xa126,
	0xa127,0xa128,0xa129,0xa12a,0xa12b,0xa12c,0xa12d,0xa12e,0xa12f,0xa130,
	0xa131,0xa132,0xa133,0xa134,0xa135,0xa136,0xa137,0xa138,0xa139,0xa13a,
	0xa13b,0xa13c,0xa13d,0xa13e,0xa13f,0xa140,0xa141,0xa142,0xa143,0xa144,
	0xa145,0xa146,0xa147,0xa148,0xa149,0xa14a,0xa14b,0xa14c,0xa14d,0xa14e,
	0xa14f,0xa150,0xa151,0xa152,0xa153,0xa154,0xa155,0xa156,0xa157,0xa158,
	0xa159,0xa15a,0xa15b,0xa15c,0xa15d,0xa15e,0xa15f,0xa160,0xa161,0xa162,
	0xa163,0xa164,0xa165,0xa166,0xa167,0xa168,0xa169,0xa16a,0xa16b,0xa16c,
	0xa16d,0xa16e,0xa16f,0xa170,0xa171,0xa172,0xa173,0xa174,0xa175,0xa176,
	0xa177,0xa178,0xa179,0xa17a,0xa17b,0xa17c,0xa17d,0xa17e,0xa17f,0xa180,
	0xa181,0xa182,0xa183,0xa184,0xa185,0xa186,0xa187,0xa188,0xa189,0xa18a,
	0xa18b,0xa18c,0xa18d,0xa18e,0xa18f,0xa190,0xa191,0xa192,0xa193,0xa194,
	0xa195,0xa196,0xa197,0xa198,0xa199,0xa19a,0xa19b,0xa19c,0xa19d,0xa19e,
	0xa19f,0xa1a0,0xa1a1,0xa1a2,0xa1a3,0xa1a4,0xa1a5,0xa1a6,0xa1a7,0xa1a8,
	0xa1a9,0xa1aa,0xa1ab,0xa1ac,0xa1ad,0xa1ae,0xa1af,0xa1b0,0xa1b1,0xa1b2,
	0xa1b3,0xa1b4,0xa1b5,0xa1b6,0xa1b7,0xa1b8,0xa1b9,0xa1ba,0xa1bb,0xa1bc,
	0xa1bd,0xa1be,0xa1bf,0xa1c0,0xa1c1,0xa1c2,0xa1c3,0xa1c4,0xa1c5,0xa1c6,
	0xa1c7,0xa1c8,0xa1c9,0xa1ca,0xa1cb,0xa1cc,0xa1cd,0xa1ce,0xa1cf,0xa1d0,
	0xa1d1,0xa1d2,0xa1d3,0xa1d4,0xa1d5,0xa1d6,0xa1d7,0xa1d8,0xa1d9,0xa1da,
	0xa1db,0xa1dc,0xa1dd,0xa1de,0xa1df,0xa1e0,0xa1e1,0xa1e2,0xa1e3,0xa1e4,
	0xa1e5,0xa1e6,0xa1e7,0xa1e8,0xa1e9,0xa1ea,0xa1eb,0xa1ec,0xa1ed,0xa1ee,
	0xa1ef,0xa1f0,0xa1f1,0xa1f2,0xa1f3,0xa1f4,0xa1f5,0xa1f6,0xa1f7,0xa1f8,
	0xa1f9,0xa1fa,0xa1fb,0xa1fc,0xa1fd,0xa1fe,0xa1ff,0xa200,0xa201,0xa202,
	0xa203,0xa204,0xa205,0xa206,0xa207,0xa208,0xa209,0xa20a,0xa20b,0xa20c,
	0xa20d,0xa20e,0xa20f,0xa210,0xa211,0xa212,0xa213,0xa214,0xa215,0xa216,
	0xa217,0xa218,0xa219,0xa21a,0xa21b,0xa21c,0xa21d,0xa21e,0xa21f,0xa220,
	0xa221,0xa222,0xa223,0xa224,0xa225,0xa226,0xa227,0xa228,0xa229,0xa22a,
	0xa22b,0xa22c,0xa22d,0xa22e,0xa22f,0xa230,0xa231,0xa232,0xa233,0xa234,
	0xa235,0xa236,0xa237,0xa238,0xa239,0xa23a,0xa23b,0xa23c,0xa23d,0xa23e,
	0xa23f,0xa240,0xa241,0xa242,0xa243,0xa244,0xa245,0xa246,0xa247,0xa248,
	0xa249,0xa24a,0xa24b,0xa24c,0xa24d,0xa24e,0xa24f,0xa250,0xa251,0xa252,
	0xa253,0xa254,0xa255,0xa256,0xa257,0xa258,0xa259,0xa25a,0xa25b,0xa25c,
	0xa25d,0xa25e,0xa25f,0xa260,0xa261,0xa262,0xa263,0xa264,0xa265,0xa266,
	0xa267,0xa268,0xa269,0xa26a,0xa26b,0xa26c,0xa26d,0xa26e,0xa26f,0xa270,
	0xa271,0xa272,0xa273,0xa274,0xa275,0xa276,0xa277,0xa278,0xa279,0xa27a,
	0xa27b,0xa27c,0xa27d,0xa27e,0xa27f,0xa280,0xa281,0xa282,0xa283,0xa284,
	0xa285,0xa286,0xa287,0xa288,0xa289,0xa28a,0xa28b,0xa28c,0xa28d,0xa28e,
	0xa28f,0xa290,0xa291,0xa292,0xa293,0xa294,0xa295,0xa296,0xa297,0xa298,
	0xa299,0xa29a,0xa29b,0xa29c,0xa29d,0xa29e,0xa29f,0xa2a0,0xa2a1,0xa2a2,
	0xa2a3,0xa2a4,0xa2a5,0xa2a6,0xa2a7,0xa2a8,0xa2a9,0xa2aa,0xa2ab,0xa2ac,
	0xa2ad,0xa2ae,0xa2af,0xa2b0,0xa2b1,0xa2b2,0xa2b3,0xa2b4,0xa2b5,0xa2b6,
	0xa2b7,0xa2b8,0xa2b9,0xa2ba,0xa2bb,0xa2bc,0xa2bd,0xa2be,0xa2bf,0xa2c0,
	0xa2c1,0xa2c2,0xa2c3,0xa2c4,0xa2c5,0xa2c6,0xa2c7,0xa2c8,0xa2c9,0xa2ca,
	0xa2cb,0xa2cc,0xa2cd,0xa2ce,0xa2cf,0xa2d0,0xa2d1,0xa2d2,0xa2d3,0xa2d4,
	0xa2d5,0xa2d6,0xa2d7,0xa2d8,0xa2d9,0xa2da,0xa2db,0xa2dc,0xa2dd,0xa2de,
	0xa2df,0xa2e0,0xa2e1,0xa2e2,0xa2e3,0xa2e4,0xa2e5,0xa2e6,0xa2e7,0xa2e8,
	0xa2e9,0xa2ea,0xa2eb,0xa2ec,0xa2ed,0xa2ee,0xa2ef,0xa2f0,0xa2f1,0xa2f2,
	0xa2f3,0xa2f4,0xa2f5,0xa2f6,0xa2f7,0xa2f8,0xa2f9,0xa2fa,0xa2fb,0xa2fc,
	0xa2fd,0xa2fe,0xa2ff,0xa300,0xa301,0xa302,0xa303,0xa304,0xa305,0xa306,
	0xa307,0xa308,0xa309,0xa30a,0xa30b,0xa30c,0xa30d,0xa30e,0xa30f,0xa310,
	0xa311,0xa312,0xa313,0xa314,0xa315,0xa316,0xa317,0xa318,0xa319,0xa31a,
	0xa31b,0xa31c,0xa31d,0xa31e,0xa31f,0xa320,0xa321,0xa322,0xa323,0xa324,
	0xa325,0xa326,0xa327,0xa328,0xa329,0xa32a,0xa32b,0xa32c,0xa32d,0xa32e,
	0xa32f,0xa330,0xa331,0xa332,0xa333,0xa334,0xa335,0xa336,0xa337,0xa338,
	0xa339,0xa33a,0xa33b,0xa33c,0xa33d,0xa33e,0xa33f,0xa340,0xa341,0xa342,
	0xa343,0xa344,0xa345,0xa346,0xa347,0xa348,0xa349,0xa34a,0xa34b,0xa34c,
	0xa34d,0xa34e,0xa34f,0xa350,0xa351,0xa352,0xa353,0xa354,0xa355,0xa356,
	0xa357,0xa358,0xa359,0xa35a,0xa35b,0xa35c,0xa35d,0xa35e,0xa35f,0xa360,
	0xa361,0xa362,0xa363,0xa364,0xa365,0xa366,0xa367,0xa368,0xa369,0xa36a,
	0xa36b,0xa36c,0xa36d,0xa36e,0xa36f,0xa370,0xa371,0xa372,0xa373,0xa374,
	0xa375,0xa376,0xa377,0xa378,0xa379,0xa37a,0xa37b,0xa37c,0xa37d,0xa37e,
	0xa37f,0xa380,0xa381,0xa382,0xa383,0xa384,0xa385,0xa386,0xa387,0xa388,
	0xa389,0xa38a,0xa38b,0xa38c,0xa38d,0xa38e,0xa38f,0xa390,0xa391,0xa392,
	0xa393,0xa394,0xa395,0xa396,0xa397,0xa398,0xa399,0xa39a,0xa39b,0xa39c,
	0xa39d,0xa39e,0xa39f,0xa3a0,0xa3a1,0xa3a2,0xa3a3,0xa3a4,0xa3a5,0xa3a6,
	0xa3a7,0xa3a8,0xa3a9,0xa3aa,0xa3ab,0xa3ac,0xa3ad,0xa3ae,0xa3af,0xa3b0,
	0xa3b1,0xa3b2,0xa3b3,0xa3b4,0xa3b5,0xa3b6,0xa3b7,0xa3b8,0xa3b9,0xa3ba,
	0xa3bb,0xa3bc,0xa3bd,0xa3be,0xa3bf,0xa3c0,0xa3c1,0xa3c2,0xa3c3,0xa3c4,
	0xa3c5,0xa3c6,0xa3c7,0xa3c8,0xa3c9,0xa3ca,0xa3cb,0xa3cc,0xa3cd,0xa3ce,
	0xa3cf,0xa3d0,0xa3d1,0xa3d2,0xa3d3,0xa3d4,0xa3d5,0xa3d6,0xa3d7,0xa3d8,
	0xa3d9,0xa3da,0xa3db,0xa3dc,0xa3dd,0xa3de,0xa3df,0xa3e0,0xa3e1,0xa3e2,
	0xa3e3,0xa3e4,0xa3e5,0xa3e6,0xa3e7,0xa3e8,0xa3e9,0xa3ea,0xa3eb,0xa3ec,
	0xa3ed,0xa3ee,0xa3ef,0xa3f0,0xa3f1,0xa3f2,0xa3f3,0xa3f4,0xa3f5,0xa3f6,
	0xa3f7,0xa3f8,0xa3f9,0xa3fa,0xa3fb,0xa3fc,0xa3fd,0xa3fe,0xa3ff,0xa400,
	0xa401,0xa402,0xa403,0xa404,0xa405,0xa406,0xa407,0xa408,0xa409,0xa40a,
	0xa40b,0xa40c,0xa40d,0xa40e,0xa40f,0xa410,0xa411,0xa412,0xa413,0xa414,
	0xa415,0xa416,0xa417,0xa418,0xa419,0xa41a,0xa41b,0xa41c,0xa41d,0xa41e,
	0xa41f,0xa420,0xa421,0xa422,0xa423,0xa424,0xa425,0xa426,0xa427,0xa428,
	0xa429,0xa42a,0xa42b,0xa42c,0xa42d,0xa42e,0xa42f,0xa430,0xa431,0xa432,
	0xa433,0xa434,0xa435,0xa436,0xa437,0xa438,0xa439,0xa43a,0xa43b,0xa43c,
	0xa43d,0xa43e,0xa43f,0xa440,0xa441,0xa442,0xa443,0xa444,0xa445,0xa446,
	0xa447,0xa448,0xa449,0xa44a,0xa44b,0xa44c,0xa44d,0xa44e,0xa44f,0xa450,
	0xa451,0xa452,0xa453,0xa454,0xa455,0xa456,0xa457,0xa458,0xa459,0xa45a,
	0xa45b,0xa45c,0xa45d,0xa45e,0xa45f,0xa460,0xa461,0xa462,0xa463,0xa464,
	0xa465,0xa466,0xa467,0xa468,0xa469,0xa46a,0xa46b,0xa46c,0xa46d,0xa46e,
	0xa46f,0xa470,0xa471,0xa472,0xa473,0xa474,0xa475,0xa476,0xa477,0xa478,
	0xa479,0xa47a,0xa47b,0xa47c,0xa47d,0xa47e,0xa47f,0xa480,0xa481,0xa482,
	0xa483,0xa484,0xa485,0xa486,0xa487,0xa488,0xa489,0xa48a,0xa48b,0xa48c,
	0xa800,0xa801,0xa803,0xa804,0xa805,0xa807,0xa808,0xa809,0xa80a,0xa80c,
	0xa80d,0xa80e,0xa80f,0xa810,0xa811,0xa812,0xa813,0xa814,0xa815,0xa816,
	0xa817,0xa818,0xa819,0xa81a,0xa81b,0xa81c,0xa81d,0xa81e,0xa81f,0xa820,
	0xa821,0xa822,0xa840,0xa841,0xa842,0xa843,0xa844,0xa845,0xa846,0xa847,
	0xa848,0xa849,0xa84a,0xa84b,0xa84c,0xa84d,0xa84e,0xa84f,0xa850,0xa851,
	0xa852,0xa853,0xa854,0xa855,0xa856,0xa857,0xa858,0xa859,0xa85a,0xa85b,
	0xa85c,0xa85d,0xa85e,0xa85f,0xa860,0xa861,0xa862,0xa863,0xa864,0xa865,
	0xa866,0xa867,0xa868,0xa869,0xa86a,0xa86b,0xa86c,0xa86d,0xa86e,0xa86f,
	0xa870,0xa871,0xa872,0xa873,0xac00,0xd7a3,0xe000,0xf8ff,0xf900,0xf901,
	0xf902,0xf903,0xf904,0xf905,0xf906,0xf907,0xf908,0xf909,0xf90a,0xf90b,
	0xf90c,0xf90d,0xf90e,0xf90f,0xf910,0xf911,0xf912,0xf913,0xf914,0xf915,
	0xf916,0xf917,0xf918,0xf919,0xf91a,0xf91b,0xf91c,0xf91d,0xf91e,0xf91f,
	0xf920,0xf921,0xf922,0xf923,0xf924,0xf925,0xf926,0xf927,0xf928,0xf929,
	0xf92a,0xf92b,0xf92c,0xf92d,0xf92e,0xf92f,0xf930,0xf931,0xf932,0xf933,
	0xf934,0xf935,0xf936,0xf937,0xf938,0xf939,0xf93a,0xf93b,0xf93c,0xf93d,
	0xf93e,0xf93f,0xf940,0xf941,0xf942,0xf943,0xf944,0xf945,0xf946,0xf947,
	0xf948,0xf949,0xf94a,0xf94b,0xf94c,0xf94d,0xf94e,0xf94f,0xf950,0xf951,
	0xf952,0xf953,0xf954,0xf955,0xf956,0xf957,0xf958,0xf959,0xf95a,0xf95b,
	0xf95c,0xf95d,0xf95e,0xf95f,0xf960,0xf961,0xf962,0xf963,0xf964,0xf965,
	0xf966,0xf967,0xf968,0xf969,0xf96a,0xf96b,0xf96c,0xf96d,0xf96e,0xf96f,
	0xf970,0xf971,0xf972,0xf973,0xf974,0xf975,0xf976,0xf977,0xf978,0xf979,
	0xf97a,0xf97b,0xf97c,0xf97d,0xf97e,0xf97f,0xf980,0xf981,0xf982,0xf983,
	0xf984,0xf985,0xf986,0xf987,0xf988,0xf989,0xf98a,0xf98b,0xf98c,0xf98d,
	0xf98e,0xf98f,0xf990,0xf991,0xf992,0xf993,0xf994,0xf995,0xf996,0xf997,
	0xf998,0xf999,0xf99a,0xf99b,0xf99c,0xf99d,0xf99e,0xf99f,0xf9a0,0xf9a1,
	0xf9a2,0xf9a3,0xf9a4,0xf9a5,0xf9a6,0xf9a7,0xf9a8,0xf9a9,0xf9aa,0xf9ab,
	0xf9ac,0xf9ad,0xf9ae,0xf9af,0xf9b0,0xf9b1,0xf9b2,0xf9b3,0xf9b4,0xf9b5,
	0xf9b6,0xf9b7,0xf9b8,0xf9b9,0xf9ba,0xf9bb,0xf9bc,0xf9bd,0xf9be,0xf9bf,
	0xf9c0,0xf9c1,0xf9c2,0xf9c3,0xf9c4,0xf9c5,0xf9c6,0xf9c7,0xf9c8,0xf9c9,
	0xf9ca,0xf9cb,0xf9cc,0xf9cd,0xf9ce,0xf9cf,0xf9d0,0xf9d1,0xf9d2,0xf9d3,
	0xf9d4,0xf9d5,0xf9d6,0xf9d7,0xf9d8,0xf9d9,0xf9da,0xf9db,0xf9dc,0xf9dd,
	0xf9de,0xf9df,0xf9e0,0xf9e1,0xf9e2,0xf9e3,0xf9e4,0xf9e5,0xf9e6,0xf9e7,
	0xf9e8,0xf9e9,0xf9ea,0xf9eb,0xf9ec,0xf9ed,0xf9ee,0xf9ef,0xf9f0,0xf9f1,
	0xf9f2,0xf9f3,0xf9f4,0xf9f5,0xf9f6,0xf9f7,0xf9f8,0xf9f9,0xf9fa,0xf9fb,
	0xf9fc,0xf9fd,0xf9fe,0xf9ff,0xfa00,0xfa01,0xfa02,0xfa03,0xfa04,0xfa05,
	0xfa06,0xfa07,0xfa08,0xfa09,0xfa0a,0xfa0b,0xfa0c,0xfa0d,0xfa0e,0xfa0f,
	0xfa10,0xfa11,0xfa12,0xfa13,0xfa14,0xfa15,0xfa16,0xfa17,0xfa18,0xfa19,
	0xfa1a,0xfa1b,0xfa1c,0xfa1d,0xfa1e,0xfa1f,0xfa20,0xfa21,0xfa22,0xfa23,
	0xfa24,0xfa25,0xfa26,0xfa27,0xfa28,0xfa29,0xfa2a,0xfa2b,0xfa2c,0xfa2d,
	0xfa30,0xfa31,0xfa32,0xfa33,0xfa34,0xfa35,0xfa36,0xfa37,0xfa38,0xfa39,
	0xfa3a,0xfa3b,0xfa3c,0xfa3d,0xfa3e,0xfa3f,0xfa40,0xfa41,0xfa42,0xfa43,
	0xfa44,0xfa45,0xfa46,0xfa47,0xfa48,0xfa49,0xfa4a,0xfa4b,0xfa4c,0xfa4d,
	0xfa4e,0xfa4f,0xfa50,0xfa51,0xfa52,0xfa53,0xfa54,0xfa55,0xfa56,0xfa57,
	0xfa58,0xfa59,0xfa5a,0xfa5b,0xfa5c,0xfa5d,0xfa5e,0xfa5f,0xfa60,0xfa61,
	0xfa62,0xfa63,0xfa64,0xfa65,0xfa66,0xfa67,0xfa68,0xfa69,0xfa6a,0xfa70,
	0xfa71,0xfa72,0xfa73,0xfa74,0xfa75,0xfa76,0xfa77,0xfa78,0xfa79,0xfa7a,
	0xfa7b,0xfa7c,0xfa7d,0xfa7e,0xfa7f,0xfa80,0xfa81,0xfa82,0xfa83,0xfa84,
	0xfa85,0xfa86,0xfa87,0xfa88,0xfa89,0xfa8a,0xfa8b,0xfa8c,0xfa8d,0xfa8e,
	0xfa8f,0xfa90,0xfa91,0xfa92,0xfa93,0xfa94,0xfa95,0xfa96,0xfa97,0xfa98,
	0xfa99,0xfa9a,0xfa9b,0xfa9c,0xfa9d,0xfa9e,0xfa9f,0xfaa0,0xfaa1,0xfaa2,
	0xfaa3,0xfaa4,0xfaa5,0xfaa6,0xfaa7,0xfaa8,0xfaa9,0xfaaa,0xfaab,0xfaac,
	0xfaad,0xfaae,0xfaaf,0xfab0,0xfab1,0xfab2,0xfab3,0xfab4,0xfab5,0xfab6,
	0xfab7,0xfab8,0xfab9,0xfaba,0xfabb,0xfabc,0xfabd,0xfabe,0xfabf,0xfac0,
	0xfac1,0xfac2,0xfac3,0xfac4,0xfac5,0xfac6,0xfac7,0xfac8,0xfac9,0xfaca,
	0xfacb,0xfacc,0xfacd,0xface,0xfacf,0xfad0,0xfad1,0xfad2,0xfad3,0xfad4,
	0xfad5,0xfad6,0xfad7,0xfad8,0xfad9,0xfb00,0xfb01,0xfb02,0xfb03,0xfb04,
	0xfb05,0xfb06,0xfb13,0xfb14,0xfb15,0xfb16,0xfb17,0xff21,0xff22,0xff23,
	0xff24,0xff25,0xff26,0xff27,0xff28,0xff29,0xff2a,0xff2b,0xff2c,0xff2d,
	0xff2e,0xff2f,0xff30,0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37,
	0xff38,0xff39,0xff3a,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47,
	0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f,0xff50,0xff51,
	0xff52,0xff53,0xff54,0xff55,0xff56,0xff57,0xff58,0xff59,0xff5a,0xff66,
	0xff67,0xff68,0xff69,0xff6a,0xff6b,0xff6c,0xff6d,0xff6e,0xff6f,0xff70,
	0xff71,0xff72,0xff73,0xff74,0xff75,0xff76,0xff77,0xff78,0xff79,0xff7a,
	0xff7b,0xff7c,0xff7d,0xff7e,0xff7f,0xff80,0xff81,0xff82,0xff83,0xff84,
	0xff85,0xff86,0xff87,0xff88,0xff89,0xff8a,0xff8b,0xff8c,0xff8d,0xff8e,
	0xff8f,0xff90,0xff91,0xff92,0xff93,0xff94,0xff95,0xff96,0xff97,0xff98,
	0xff99,0xff9a,0xff9b,0xff9c,0xff9d,0xff9e,0xff9f,0xffa0,0xffa1,0xffa2,
	0xffa3,0xffa4,0xffa5,0xffa6,0xffa7,0xffa8,0xffa9,0xffaa,0xffab,0xffac,
	0xffad,0xffae,0xffaf,0xffb0,0xffb1,0xffb2,0xffb3,0xffb4,0xffb5,0xffb6,
	0xffb7,0xffb8,0xffb9,0xffba,0xffbb,0xffbc,0xffbd,0xffbe,0xffc2,0xffc3,
	0xffc4,0xffc5,0xffc6,0xffc7,0xffca,0xffcb,0xffcc,0xffcd,0xffce,0xffcf,
	0xffd2,0xffd3,0xffd4,0xffd5,0xffd6,0xffd7,0xffda,0xffdb,0xffdc,
	0xd800,0xdc00,0xd800,0xdc01,0xd800,0xdc02,0xd800,0xdc03,0xd800,0xdc04,
	0xd800,0xdc05,0xd800,0xdc06,0xd800,0xdc07,0xd800,0xdc08,0xd800,0xdc09,
	0xd800,0xdc0a,0xd800,0xdc0b,0xd800,0xdc0d,0xd800,0xdc0e,0xd800,0xdc0f,
	0xd800,0xdc10,0xd800,0xdc11,0xd800,0xdc12,0xd800,0xdc13,0xd800,0xdc14,
	0xd800,0xdc15,0xd800,0xdc16,0xd800,0xdc17,0xd800,0xdc18,0xd800,0xdc19,
	0xd800,0xdc1a,0xd800,0xdc1b,0xd800,0xdc1c,0xd800,0xdc1d,0xd800,0xdc1e,
	0xd800,0xdc1f,0xd800,0xdc20,0xd800,0xdc21,0xd800,0xdc22,0xd800,0xdc23,
	0xd800,0xdc24,0xd800,0xdc25,0xd800,0xdc26,0xd800,0xdc28,0xd800,0xdc29,
	0xd800,0xdc2a,0xd800,0xdc2b,0xd800,0xdc2c,0xd800,0xdc2d,0xd800,0xdc2e,
	0xd800,0xdc2f,0xd800,0xdc30,0xd800,0xdc31,0xd800,0xdc32,0xd800,0xdc33,
	0xd800,0xdc34,0xd800,0xdc35,0xd800,0xdc36,0xd800,0xdc37,0xd800,0xdc38,
	0xd800,0xdc39,0xd800,0xdc3a,0xd800,0xdc3c,0xd800,0xdc3d,0xd800,0xdc3f,
	0xd800,0xdc40,0xd800,0xdc41,0xd800,0xdc42,0xd800,0xdc43,0xd800,0xdc44,
	0xd800,0xdc45,0xd800,0xdc46,0xd800,0xdc47,0xd800,0xdc48,0xd800,0xdc49,
	0xd800,0xdc4a,0xd800,0xdc4b,0xd800,0xdc4c,0xd800,0xdc4d,0xd800,0xdc50,
	0xd800,0xdc51,0xd800,0xdc52,0xd800,0xdc53,0xd800,0xdc54,0xd800,0xdc55,
	0xd800,0xdc56,0xd800,0xdc57,0xd800,0xdc58,0xd800,0xdc59,0xd800,0xdc5a,
	0xd800,0xdc5b,0xd800,0xdc5c,0xd800,0xdc5d,0xd800,0xdc80,0xd800,0xdc81,
	0xd800,0xdc82,0xd800,0xdc83,0xd800,0xdc84,0xd800,0xdc85,0xd800,0xdc86,
	0xd800,0xdc87,0xd800,0xdc88,0xd800,0xdc89,0xd800,0xdc8a,0xd800,0xdc8b,
	0xd800,0xdc8c,0xd800,0xdc8d,0xd800,0xdc8e,0xd800,0xdc8f,0xd800,0xdc90,
	0xd800,0xdc91,0xd800,0xdc92,0xd800,0xdc93,0xd800,0xdc94,0xd800,0xdc95,
	0xd800,0xdc96,0xd800,0xdc97,0xd800,0xdc98,0xd800,0xdc99,0xd800,0xdc9a,
	0xd800,0xdc9b,0xd800,0xdc9c,0xd800,0xdc9d,0xd800,0xdc9e,0xd800,0xdc9f,
	0xd800,0xdca0,0xd800,0xdca1,0xd800,0xdca2,0xd800,0xdca3,0xd800,0xdca4,
	0xd800,0xdca5,0xd800,0xdca6,0xd800,0xdca7,0xd800,0xdca8,0xd800,0xdca9,
	0xd800,0xdcaa,0xd800,0xdcab,0xd800,0xdcac,0xd800,0xdcad,0xd800,0xdcae,
	0xd800,0xdcaf,0xd800,0xdcb0,0xd800,0xdcb1,0xd800,0xdcb2,0xd800,0xdcb3,
	0xd800,0xdcb4,0xd800,0xdcb5,0xd800,0xdcb6,0xd800,0xdcb7,0xd800,0xdcb8,
	0xd800,0xdcb9,0xd800,0xdcba,0xd800,0xdcbb,0xd800,0xdcbc,0xd800,0xdcbd,
	0xd800,0xdcbe,0xd800,0xdcbf,0xd800,0xdcc0,0xd800,0xdcc1,0xd800,0xdcc2,
	0xd800,0xdcc3,0xd800,0xdcc4,0xd800,0xdcc5,0xd800,0xdcc6,0xd800,0xdcc7,
	0xd800,0xdcc8,0xd800,0xdcc9,0xd800,0xdcca,0xd800,0xdccb,0xd800,0xdccc,
	0xd800,0xdccd,0xd800,0xdcce,0xd800,0xdccf,0xd800,0xdcd0,0xd800,0xdcd1,
	0xd800,0xdcd2,0xd800,0xdcd3,0xd800,0xdcd4,0xd800,0xdcd5,0xd800,0xdcd6,
	0xd800,0xdcd7,0xd800,0xdcd8,0xd800,0xdcd9,0xd800,0xdcda,0xd800,0xdcdb,
	0xd800,0xdcdc,0xd800,0xdcdd,0xd800,0xdcde,0xd800,0xdcdf,0xd800,0xdce0,
	0xd800,0xdce1,0xd800,0xdce2,0xd800,0xdce3,0xd800,0xdce4,0xd800,0xdce5,
	0xd800,0xdce6,0xd800,0xdce7,0xd800,0xdce8,0xd800,0xdce9,0xd800,0xdcea,
	0xd800,0xdceb,0xd800,0xdcec,0xd800,0xdced,0xd800,0xdcee,0xd800,0xdcef,
	0xd800,0xdcf0,0xd800,0xdcf1,0xd800,0xdcf2,0xd800,0xdcf3,0xd800,0xdcf4,
	0xd800,0xdcf5,0xd800,0xdcf6,0xd800,0xdcf7,0xd800,0xdcf8,0xd800,0xdcf9,
	0xd800,0xdcfa,0xd800,0xdd00,0xd800,0xdd02,0xd800,0xdd07,0xd800,0xdd08,
	0xd800,0xdd09,0xd800,0xdd0a,0xd800,0xdd0b,0xd800,0xdd0c,0xd800,0xdd0d,
	0xd800,0xdd0e,0xd800,0xdd0f,0xd800,0xdd10,0xd800,0xdd11,0xd800,0xdd12,
	0xd800,0xdd13,0xd800,0xdd14,0xd800,0xdd15,0xd800,0xdd16,0xd800,0xdd17,
	0xd800,0xdd18,0xd800,0xdd19,0xd800,0xdd1a,0xd800,0xdd1b,0xd800,0xdd1c,
	0xd800,0xdd1d,0xd800,0xdd1e,0xd800,0xdd1f,0xd800,0xdd20,0xd800,0xdd21,
	0xd800,0xdd22,0xd800,0xdd23,0xd800,0xdd24,0xd800,0xdd25,0xd800,0xdd26,
	0xd800,0xdd27,0xd800,0xdd28,0xd800,0xdd29,0xd800,0xdd2a,0xd800,0xdd2b,
	0xd800,0xdd2c,0xd800,0xdd2d,0xd800,0xdd2e,0xd800,0xdd2f,0xd800,0xdd30,
	0xd800,0xdd31,0xd800,0xdd32,0xd800,0xdd33,0xd800,0xdd37,0xd800,0xdd38,
	0xd800,0xdd39,0xd800,0xdd3a,0xd800,0xdd3b,0xd800,0xdd3c,0xd800,0xdd3d,
	0xd800,0xdd3e,0xd800,0xdd3f,0xd800,0xdf00,0xd800,0xdf01,0xd800,0xdf02,
	0xd800,0xdf03,0xd800,0xdf04,0xd800,0xdf05,0xd800,0xdf06,0xd800,0xdf07,
	0xd800,0xdf08,0xd800,0xdf09,0xd800,0xdf0a,0xd800,0xdf0b,0xd800,0xdf0c,
	0xd800,0xdf0d,0xd800,0xdf0e,0xd800,0xdf0f,0xd800,0xdf10,0xd800,0xdf11,
	0xd800,0xdf12,0xd800,0xdf13,0xd800,0xdf14,0xd800,0xdf15,0xd800,0xdf16,
	0xd800,0xdf17,0xd800,0xdf18,0xd800,0xdf19,0xd800,0xdf1a,0xd800,0xdf1b,
	0xd800,0xdf1c,0xd800,0xdf1d,0xd800,0xdf1e,0xd800,0xdf20,0xd800,0xdf21,
	0xd800,0xdf22,0xd800,0xdf23,0xd800,0xdf30,0xd800,0xdf31,0xd800,0xdf32,
	0xd800,0xdf33,0xd800,0xdf34,0xd800,0xdf35,0xd800,0xdf36,0xd800,0xdf37,
	0xd800,0xdf38,0xd800,0xdf39,0xd800,0xdf3a,0xd800,0xdf3b,0xd800,0xdf3c,
	0xd800,0xdf3d,0xd800,0xdf3e,0xd800,0xdf3f,0xd800,0xdf40,0xd800,0xdf41,
	0xd800,0xdf42,0xd800,0xdf43,0xd800,0xdf44,0xd800,0xdf45,0xd800,0xdf46,
	0xd800,0xdf47,0xd800,0xdf48,0xd800,0xdf49,0xd800,0xdf4a,0xd800,0xdf80,
	0xd800,0xdf81,0xd800,0xdf82,0xd800,0xdf83,0xd800,0xdf84,0xd800,0xdf85,
	0xd800,0xdf86,0xd800,0xdf87,0xd800,0xdf88,0xd800,0xdf89,0xd800,0xdf8a,
	0xd800,0xdf8b,0xd800,0xdf8c,0xd800,0xdf8d,0xd800,0xdf8e,0xd800,0xdf8f,
	0xd800,0xdf90,0xd800,0xdf91,0xd800,0xdf92,0xd800,0xdf93,0xd800,0xdf94,
	0xd800,0xdf95,0xd800,0xdf96,0xd800,0xdf97,0xd800,0xdf98,0xd800,0xdf99,
	0xd800,0xdf9a,0xd800,0xdf9b,0xd800,0xdf9c,0xd800,0xdf9d,0xd800,0xdf9f,
	0xd800,0xdfa0,0xd800,0xdfa1,0xd800,0xdfa2,0xd800,0xdfa3,0xd800,0xdfa4,
	0xd800,0xdfa5,0xd800,0xdfa6,0xd800,0xdfa7,0xd800,0xdfa8,0xd800,0xdfa9,
	0xd800,0xdfaa,0xd800,0xdfab,0xd800,0xdfac,0xd800,0xdfad,0xd800,0xdfae,
	0xd800,0xdfaf,0xd800,0xdfb0,0xd800,0xdfb1,0xd800,0xdfb2,0xd800,0xdfb3,
	0xd800,0xdfb4,0xd800,0xdfb5,0xd800,0xdfb6,0xd800,0xdfb7,0xd800,0xdfb8,
	0xd800,0xdfb9,0xd800,0xdfba,0xd800,0xdfbb,0xd800,0xdfbc,0xd800,0xdfbd,
	0xd800,0xdfbe,0xd800,0xdfbf,0xd800,0xdfc0,0xd800,0xdfc1,0xd800,0xdfc2,
	0xd800,0xdfc3,0xd800,0xdfc8,0xd800,0xdfc9,0xd800,0xdfca,0xd800,0xdfcb,
	0xd800,0xdfcc,0xd800,0xdfcd,0xd800,0xdfce,0xd800,0xdfcf,0xd800,0xdfd0,
	0xd800,0xdfd1,0xd800,0xdfd2,0xd800,0xdfd3,0xd800,0xdfd4,0xd800,0xdfd5,
	0xd801,0xdc00,0xd801,0xdc01,0xd801,0xdc02,0xd801,0xdc03,0xd801,0xdc04,
	0xd801,0xdc05,0xd801,0xdc06,0xd801,0xdc07,0xd801,0xdc08,0xd801,0xdc09,
	0xd801,0xdc0a,0xd801,0xdc0b,0xd801,0xdc0c,0xd801,0xdc0d,0xd801,0xdc0e,
	0xd801,0xdc0f,0xd801,0xdc10,0xd801,0xdc11,0xd801,0xdc12,0xd801,0xdc13,
	0xd801,0xdc14,0xd801,0xdc15,0xd801,0xdc16,0xd801,0xdc17,0xd801,0xdc18,
	0xd801,0xdc19,0xd801,0xdc1a,0xd801,0xdc1b,0xd801,0xdc1c,0xd801,0xdc1d,
	0xd801,0xdc1e,0xd801,0xdc1f,0xd801,0xdc20,0xd801,0xdc21,0xd801,0xdc22,
	0xd801,0xdc23,0xd801,0xdc24,0xd801,0xdc25,0xd801,0xdc26,0xd801,0xdc27,
	0xd801,0xdc28,0xd801,0xdc29,0xd801,0xdc2a,0xd801,0xdc2b,0xd801,0xdc2c,
	0xd801,0xdc2d,0xd801,0xdc2e,0xd801,0xdc2f,0xd801,0xdc30,0xd801,0xdc31,
	0xd801,0xdc32,0xd801,0xdc33,0xd801,0xdc34,0xd801,0xdc35,0xd801,0xdc36,
	0xd801,0xdc37,0xd801,0xdc38,0xd801,0xdc39,0xd801,0xdc3a,0xd801,0xdc3b,
	0xd801,0xdc3c,0xd801,0xdc3d,0xd801,0xdc3e,0xd801,0xdc3f,0xd801,0xdc40,
	0xd801,0xdc41,0xd801,0xdc42,0xd801,0xdc43,0xd801,0xdc44,0xd801,0xdc45,
	0xd801,0xdc46,0xd801,0xdc47,0xd801,0xdc48,0xd801,0xdc49,0xd801,0xdc4a,
	0xd801,0xdc4b,0xd801,0xdc4c,0xd801,0xdc4d,0xd801,0xdc4e,0xd801,0xdc4f,
	0xd801,0xdc50,0xd801,0xdc51,0xd801,0xdc52,0xd801,0xdc53,0xd801,0xdc54,
	0xd801,0xdc55,0xd801,0xdc56,0xd801,0xdc57,0xd801,0xdc58,0xd801,0xdc59,
	0xd801,0xdc5a,0xd801,0xdc5b,0xd801,0xdc5c,0xd801,0xdc5d,0xd801,0xdc5e,
	0xd801,0xdc5f,0xd801,0xdc60,0xd801,0xdc61,0xd801,0xdc62,0xd801,0xdc63,
	0xd801,0xdc64,0xd801,0xdc65,0xd801,0xdc66,0xd801,0xdc67,0xd801,0xdc68,
	0xd801,0xdc69,0xd801,0xdc6a,0xd801,0xdc6b,0xd801,0xdc6c,0xd801,0xdc6d,
	0xd801,0xdc6e,0xd801,0xdc6f,0xd801,0xdc70,0xd801,0xdc71,0xd801,0xdc72,
	0xd801,0xdc73,0xd801,0xdc74,0xd801,0xdc75,0xd801,0xdc76,0xd801,0xdc77,
	0xd801,0xdc78,0xd801,0xdc79,0xd801,0xdc7a,0xd801,0xdc7b,0xd801,0xdc7c,
	0xd801,0xdc7d,0xd801,0xdc7e,0xd801,0xdc7f,0xd801,0xdc80,0xd801,0xdc81,
	0xd801,0xdc82,0xd801,0xdc83,0xd801,0xdc84,0xd801,0xdc85,0xd801,0xdc86,
	0xd801,0xdc87,0xd801,0xdc88,0xd801,0xdc89,0xd801,0xdc8a,0xd801,0xdc8b,
	0xd801,0xdc8c,0xd801,0xdc8d,0xd801,0xdc8e,0xd801,0xdc8f,0xd801,0xdc90,
	0xd801,0xdc91,0xd801,0xdc92,0xd801,0xdc93,0xd801,0xdc94,0xd801,0xdc95,
	0xd801,0xdc96,0xd801,0xdc97,0xd801,0xdc98,0xd801,0xdc99,0xd801,0xdc9a,
	0xd801,0xdc9b,0xd801,0xdc9c,0xd801,0xdc9d,0xd801,0xdca0,0xd801,0xdca1,
	0xd801,0xdca2,0xd801,0xdca3,0xd801,0xdca4,0xd801,0xdca5,0xd801,0xdca6,
	0xd801,0xdca7,0xd801,0xdca8,0xd801,0xdca9,0xd808,0xdc00,0xd808,0xdc01,
	0xd808,0xdc02,0xd808,0xdc03,0xd808,0xdc04,0xd808,0xdc05,0xd808,0xdc06,
	0xd808,0xdc07,0xd808,0xdc08,0xd808,0xdc09,0xd808,0xdc0a,0xd808,0xdc0b,
	0xd808,0xdc0c,0xd808,0xdc0d,0xd808,0xdc0e,0xd808,0xdc0f,0xd808,0xdc10,
	0xd808,0xdc11,0xd808,0xdc12,0xd808,0xdc13,0xd808,0xdc14,0xd808,0xdc15,
	0xd808,0xdc16,0xd808,0xdc17,0xd808,0xdc18,0xd808,0xdc19,0xd808,0xdc1a,
	0xd808,0xdc1b,0xd808,0xdc1c,0xd808,0xdc1d,0xd808,0xdc1e,0xd808,0xdc1f,
	0xd808,0xdc20,0xd808,0xdc21,0xd808,0xdc22,0xd808,0xdc23,0xd808,0xdc24,
	0xd808,0xdc25,0xd808,0xdc26,0xd808,0xdc27,0xd808,0xdc28,0xd808,0xdc29,
	0xd808,0xdc2a,0xd808,0xdc2b,0xd808,0xdc2c,0xd808,0xdc2d,0xd808,0xdc2e,
	0xd808,0xdc2f,0xd808,0xdc30,0xd808,0xdc31,0xd808,0xdc32,0xd808,0xdc33,
	0xd808,0xdc34,0xd808,0xdc35,0xd808,0xdc36,0xd808,0xdc37,0xd808,0xdc38,
	0xd808,0xdc39,0xd808,0xdc3a,0xd808,0xdc3b,0xd808,0xdc3c,0xd808,0xdc3d,
	0xd808,0xdc3e,0xd808,0xdc3f,0xd808,0xdc40,0xd808,0xdc41,0xd808,0xdc42,
	0xd808,0xdc43,0xd808,0xdc44,0xd808,0xdc45,0xd808,0xdc46,0xd808,0xdc47,
	0xd808,0xdc48,0xd808,0xdc49,0xd808,0xdc4a,0xd808,0xdc4b,0xd808,0xdc4c,
	0xd808,0xdc4d,0xd808,0xdc4e,0xd808,0xdc4f,0xd808,0xdc50,0xd808,0xdc51,
	0xd808,0xdc52,0xd808,0xdc53,0xd808,0xdc54,0xd808,0xdc55,0xd808,0xdc56,
	0xd808,0xdc57,0xd808,0xdc58,0xd808,0xdc59,0xd808,0xdc5a,0xd808,0xdc5b,
	0xd808,0xdc5c,0xd808,0xdc5d,0xd808,0xdc5e,0xd808,0xdc5f,0xd808,0xdc60,
	0xd808,0xdc61,0xd808,0xdc62,0xd808,0xdc63,0xd808,0xdc64,0xd808,0xdc65,
	0xd808,0xdc66,0xd808,0xdc67,0xd808,0xdc68,0xd808,0xdc69,0xd808,0xdc6a,
	0xd808,0xdc6b,0xd808,0xdc6c,0xd808,0xdc6d,0xd808,0xdc6e,0xd808,0xdc6f,
	0xd808,0xdc70,0xd808,0xdc71,0xd808,0xdc72,0xd808,0xdc73,0xd808,0xdc74,
	0xd808,0xdc75,0xd808,0xdc76,0xd808,0xdc77,0xd808,0xdc78,0xd808,0xdc79,
	0xd808,0xdc7a,0xd808,0xdc7b,0xd808,0xdc7c,0xd808,0xdc7d,0xd808,0xdc7e,
	0xd808,0xdc7f,0xd808,0xdc80,0xd808,0xdc81,0xd808,0xdc82,0xd808,0xdc83,
	0xd808,0xdc84,0xd808,0xdc85,0xd808,0xdc86,0xd808,0xdc87,0xd808,0xdc88,
	0xd808,0xdc89,0xd808,0xdc8a,0xd808,0xdc8b,0xd808,0xdc8c,0xd808,0xdc8d,
	0xd808,0xdc8e,0xd808,0xdc8f,0xd808,0xdc90,0xd808,0xdc91,0xd808,0xdc92,
	0xd808,0xdc93,0xd808,0xdc94,0xd808,0xdc95,0xd808,0xdc96,0xd808,0xdc97,
	0xd808,0xdc98,0xd808,0xdc99,0xd808,0xdc9a,0xd808,0xdc9b,0xd808,0xdc9c,
	0xd808,0xdc9d,0xd808,0xdc9e,0xd808,0xdc9f,0xd808,0xdca0,0xd808,0xdca1,
	0xd808,0xdca2,0xd808,0xdca3,0xd808,0xdca4,0xd808,0xdca5,0xd808,0xdca6,
	0xd808,0xdca7,0xd808,0xdca8,0xd808,0xdca9,0xd808,0xdcaa,0xd808,0xdcab,
	0xd808,0xdcac,0xd808,0xdcad,0xd808,0xdcae,0xd808,0xdcaf,0xd808,0xdcb0,
	0xd808,0xdcb1,0xd808,0xdcb2,0xd808,0xdcb3,0xd808,0xdcb4,0xd808,0xdcb5,
	0xd808,0xdcb6,0xd808,0xdcb7,0xd808,0xdcb8,0xd808,0xdcb9,0xd808,0xdcba,
	0xd808,0xdcbb,0xd808,0xdcbc,0xd808,0xdcbd,0xd808,0xdcbe,0xd808,0xdcbf,
	0xd808,0xdcc0,0xd808,0xdcc1,0xd808,0xdcc2,0xd808,0xdcc3,0xd808,0xdcc4,
	0xd808,0xdcc5,0xd808,0xdcc6,0xd808,0xdcc7,0xd808,0xdcc8,0xd808,0xdcc9,
	0xd808,0xdcca,0xd808,0xdccb,0xd808,0xdccc,0xd808,0xdccd,0xd808,0xdcce,
	0xd808,0xdccf,0xd808,0xdcd0,0xd808,0xdcd1,0xd808,0xdcd2,0xd808,0xdcd3,
	0xd808,0xdcd4,0xd808,0xdcd5,0xd808,0xdcd6,0xd808,0xdcd7,0xd808,0xdcd8,
	0xd808,0xdcd9,0xd808,0xdcda,0xd808,0xdcdb,0xd808,0xdcdc,0xd808,0xdcdd,
	0xd808,0xdcde,0xd808,0xdcdf,0xd808,0xdce0,0xd808,0xdce1,0xd808,0xdce2,
	0xd808,0xdce3,0xd808,0xdce4,0xd808,0xdce5,0xd808,0xdce6,0xd808,0xdce7,
	0xd808,0xdce8,0xd808,0xdce9,0xd808,0xdcea,0xd808,0xdceb,0xd808,0xdcec,
	0xd808,0xdced,0xd808,0xdcee,0xd808,0xdcef,0xd808,0xdcf0,0xd808,0xdcf1,
	0xd808,0xdcf2,0xd808,0xdcf3,0xd808,0xdcf4,0xd808,0xdcf5,0xd808,0xdcf6,
	0xd808,0xdcf7,0xd808,0xdcf8,0xd808,0xdcf9,0xd808,0xdcfa,0xd808,0xdcfb,
	0xd808,0xdcfc,0xd808,0xdcfd,0xd808,0xdcfe,0xd808,0xdcff,0xd808,0xdd00,
	0xd808,0xdd01,0xd808,0xdd02,0xd808,0xdd03,0xd808,0xdd04,0xd808,0xdd05,
	0xd808,0xdd06,0xd808,0xdd07,0xd808,0xdd08,0xd808,0xdd09,0xd808,0xdd0a,
	0xd808,0xdd0b,0xd808,0xdd0c,0xd808,0xdd0d,0xd808,0xdd0e,0xd808,0xdd0f,
	0xd808,0xdd10,0xd808,0xdd11,0xd808,0xdd12,0xd808,0xdd13,0xd808,0xdd14,
	0xd808,0xdd15,0xd808,0xdd16,0xd808,0xdd17,0xd808,0xdd18,0xd808,0xdd19,
	0xd808,0xdd1a,0xd808,0xdd1b,0xd808,0xdd1c,0xd808,0xdd1d,0xd808,0xdd1e,
	0xd808,0xdd1f,0xd808,0xdd20,0xd808,0xdd21,0xd808,0xdd22,0xd808,0xdd23,
	0xd808,0xdd24,0xd808,0xdd25,0xd808,0xdd26,0xd808,0xdd27,0xd808,0xdd28,
	0xd808,0xdd29,0xd808,0xdd2a,0xd808,0xdd2b,0xd808,0xdd2c,0xd808,0xdd2d,
	0xd808,0xdd2e,0xd808,0xdd2f,0xd808,0xdd30,0xd808,0xdd31,0xd808,0xdd32,
	0xd808,0xdd33,0xd808,0xdd34,0xd808,0xdd35,0xd808,0xdd36,0xd808,0xdd37,
	0xd808,0xdd38,0xd808,0xdd39,0xd808,0xdd3a,0xd808,0xdd3b,0xd808,0xdd3c,
	0xd808,0xdd3d,0xd808,0xdd3e,0xd808,0xdd3f,0xd808,0xdd40,0xd808,0xdd41,
	0xd808,0xdd42,0xd808,0xdd43,0xd808,0xdd44,0xd808,0xdd45,0xd808,0xdd46,
	0xd808,0xdd47,0xd808,0xdd48,0xd808,0xdd49,0xd808,0xdd4a,0xd808,0xdd4b,
	0xd808,0xdd4c,0xd808,0xdd4d,0xd808,0xdd4e,0xd808,0xdd4f,0xd808,0xdd50,
	0xd808,0xdd51,0xd808,0xdd52,0xd808,0xdd53,0xd808,0xdd54,0xd808,0xdd55,
	0xd808,0xdd56,0xd808,0xdd57,0xd808,0xdd58,0xd808,0xdd59,0xd808,0xdd5a,
	0xd808,0xdd5b,0xd808,0xdd5c,0xd808,0xdd5d,0xd808,0xdd5e,0xd808,0xdd5f,
	0xd808,0xdd60,0xd808,0xdd61,0xd808,0xdd62,0xd808,0xdd63,0xd808,0xdd64,
	0xd808,0xdd65,0xd808,0xdd66,0xd808,0xdd67,0xd808,0xdd68,0xd808,0xdd69,
	0xd808,0xdd6a,0xd808,0xdd6b,0xd808,0xdd6c,0xd808,0xdd6d,0xd808,0xdd6e,
	0xd808,0xdd6f,0xd808,0xdd70,0xd808,0xdd71,0xd808,0xdd72,0xd808,0xdd73,
	0xd808,0xdd74,0xd808,0xdd75,0xd808,0xdd76,0xd808,0xdd77,0xd808,0xdd78,
	0xd808,0xdd79,0xd808,0xdd7a,0xd808,0xdd7b,0xd808,0xdd7c,0xd808,0xdd7d,
	0xd808,0xdd7e,0xd808,0xdd7f,0xd808,0xdd80,0xd808,0xdd81,0xd808,0xdd82,
	0xd808,0xdd83,0xd808,0xdd84,0xd808,0xdd85,0xd808,0xdd86,0xd808,0xdd87,
	0xd808,0xdd88,0xd808,0xdd89,0xd808,0xdd8a,0xd808,0xdd8b,0xd808,0xdd8c,
	0xd808,0xdd8d,0xd808,0xdd8e,0xd808,0xdd8f,0xd808,0xdd90,0xd808,0xdd91,
	0xd808,0xdd92,0xd808,0xdd93,0xd808,0xdd94,0xd808,0xdd95,0xd808,0xdd96,
	0xd808,0xdd97,0xd808,0xdd98,0xd808,0xdd99,0xd808,0xdd9a,0xd808,0xdd9b,
	0xd808,0xdd9c,0xd808,0xdd9d,0xd808,0xdd9e,0xd808,0xdd9f,0xd808,0xdda0,
	0xd808,0xdda1,0xd808,0xdda2,0xd808,0xdda3,0xd808,0xdda4,0xd808,0xdda5,
	0xd808,0xdda6,0xd808,0xdda7,0xd808,0xdda8,0xd808,0xdda9,0xd808,0xddaa,
	0xd808,0xddab,0xd808,0xddac,0xd808,0xddad,0xd808,0xddae,0xd808,0xddaf,
	0xd808,0xddb0,0xd808,0xddb1,0xd808,0xddb2,0xd808,0xddb3,0xd808,0xddb4,
	0xd808,0xddb5,0xd808,0xddb6,0xd808,0xddb7,0xd808,0xddb8,0xd808,0xddb9,
	0xd808,0xddba,0xd808,0xddbb,0xd808,0xddbc,0xd808,0xddbd,0xd808,0xddbe,
	0xd808,0xddbf,0xd808,0xddc0,0xd808,0xddc1,0xd808,0xddc2,0xd808,0xddc3,
	0xd808,0xddc4,0xd808,0xddc5,0xd808,0xddc6,0xd808,0xddc7,0xd808,0xddc8,
	0xd808,0xddc9,0xd808,0xddca,0xd808,0xddcb,0xd808,0xddcc,0xd808,0xddcd,
	0xd808,0xddce,0xd808,0xddcf,0xd808,0xddd0,0xd808,0xddd1,0xd808,0xddd2,
	0xd808,0xddd3,0xd808,0xddd4,0xd808,0xddd5,0xd808,0xddd6,0xd808,0xddd7,
	0xd808,0xddd8,0xd808,0xddd9,0xd808,0xddda,0xd808,0xdddb,0xd808,0xdddc,
	0xd808,0xdddd,0xd808,0xddde,0xd808,0xdddf,0xd808,0xdde0,0xd808,0xdde1,
	0xd808,0xdde2,0xd808,0xdde3,0xd808,0xdde4,0xd808,0xdde5,0xd808,0xdde6,
	0xd808,0xdde7,0xd808,0xdde8,0xd808,0xdde9,0xd808,0xddea,0xd808,0xddeb,
	0xd808,0xddec,0xd808,0xdded,0xd808,0xddee,0xd808,0xddef,0xd808,0xddf0,
	0xd808,0xddf1,0xd808,0xddf2,0xd808,0xddf3,0xd808,0xddf4,0xd808,0xddf5,
	0xd808,0xddf6,0xd808,0xddf7,0xd808,0xddf8,0xd808,0xddf9,0xd808,0xddfa,
	0xd808,0xddfb,0xd808,0xddfc,0xd808,0xddfd,0xd808,0xddfe,0xd808,0xddff,
	0xd808,0xde00,0xd808,0xde01,0xd808,0xde02,0xd808,0xde03,0xd808,0xde04,
	0xd808,0xde05,0xd808,0xde06,0xd808,0xde07,0xd808,0xde08,0xd808,0xde09,
	0xd808,0xde0a,0xd808,0xde0b,0xd808,0xde0c,0xd808,0xde0d,0xd808,0xde0e,
	0xd808,0xde0f,0xd808,0xde10,0xd808,0xde11,0xd808,0xde12,0xd808,0xde13,
	0xd808,0xde14,0xd808,0xde15,0xd808,0xde16,0xd808,0xde17,0xd808,0xde18,
	0xd808,0xde19,0xd808,0xde1a,0xd808,0xde1b,0xd808,0xde1c,0xd808,0xde1d,
	0xd808,0xde1e,0xd808,0xde1f,0xd808,0xde20,0xd808,0xde21,0xd808,0xde22,
	0xd808,0xde23,0xd808,0xde24,0xd808,0xde25,0xd808,0xde26,0xd808,0xde27,
	0xd808,0xde28,0xd808,0xde29,0xd808,0xde2a,0xd808,0xde2b,0xd808,0xde2c,
	0xd808,0xde2d,0xd808,0xde2e,0xd808,0xde2f,0xd808,0xde30,0xd808,0xde31,
	0xd808,0xde32,0xd808,0xde33,0xd808,0xde34,0xd808,0xde35,0xd808,0xde36,
	0xd808,0xde37,0xd808,0xde38,0xd808,0xde39,0xd808,0xde3a,0xd808,0xde3b,
	0xd808,0xde3c,0xd808,0xde3d,0xd808,0xde3e,0xd808,0xde3f,0xd808,0xde40,
	0xd808,0xde41,0xd808,0xde42,0xd808,0xde43,0xd808,0xde44,0xd808,0xde45,
	0xd808,0xde46,0xd808,0xde47,0xd808,0xde48,0xd808,0xde49,0xd808,0xde4a,
	0xd808,0xde4b,0xd808,0xde4c,0xd808,0xde4d,0xd808,0xde4e,0xd808,0xde4f,
	0xd808,0xde50,0xd808,0xde51,0xd808,0xde52,0xd808,0xde53,0xd808,0xde54,
	0xd808,0xde55,0xd808,0xde56,0xd808,0xde57,0xd808,0xde58,0xd808,0xde59,
	0xd808,0xde5a,0xd808,0xde5b,0xd808,0xde5c,0xd808,0xde5d,0xd808,0xde5e,
	0xd808,0xde5f,0xd808,0xde60,0xd808,0xde61,0xd808,0xde62,0xd808,0xde63,
	0xd808,0xde64,0xd808,0xde65,0xd808,0xde66,0xd808,0xde67,0xd808,0xde68,
	0xd808,0xde69,0xd808,0xde6a,0xd808,0xde6b,0xd808,0xde6c,0xd808,0xde6d,
	0xd808,0xde6e,0xd808,0xde6f,0xd808,0xde70,0xd808,0xde71,0xd808,0xde72,
	0xd808,0xde73,0xd808,0xde74,0xd808,0xde75,0xd808,0xde76,0xd808,0xde77,
	0xd808,0xde78,0xd808,0xde79,0xd808,0xde7a,0xd808,0xde7b,0xd808,0xde7c,
	0xd808,0xde7d,0xd808,0xde7e,0xd808,0xde7f,0xd808,0xde80,0xd808,0xde81,
	0xd808,0xde82,0xd808,0xde83,0xd808,0xde84,0xd808,0xde85,0xd808,0xde86,
	0xd808,0xde87,0xd808,0xde88,0xd808,0xde89,0xd808,0xde8a,0xd808,0xde8b,
	0xd808,0xde8c,0xd808,0xde8d,0xd808,0xde8e,0xd808,0xde8f,0xd808,0xde90,
	0xd808,0xde91,0xd808,0xde92,0xd808,0xde93,0xd808,0xde94,0xd808,0xde95,
	0xd808,0xde96,0xd808,0xde97,0xd808,0xde98,0xd808,0xde99,0xd808,0xde9a,
	0xd808,0xde9b,0xd808,0xde9c,0xd808,0xde9d,0xd808,0xde9e,0xd808,0xde9f,
	0xd808,0xdea0,0xd808,0xdea1,0xd808,0xdea2,0xd808,0xdea3,0xd808,0xdea4,
	0xd808,0xdea5,0xd808,0xdea6,0xd808,0xdea7,0xd808,0xdea8,0xd808,0xdea9,
	0xd808,0xdeaa,0xd808,0xdeab,0xd808,0xdeac,0xd808,0xdead,0xd808,0xdeae,
	0xd808,0xdeaf,0xd808,0xdeb0,0xd808,0xdeb1,0xd808,0xdeb2,0xd808,0xdeb3,
	0xd808,0xdeb4,0xd808,0xdeb5,0xd808,0xdeb6,0xd808,0xdeb7,0xd808,0xdeb8,
	0xd808,0xdeb9,0xd808,0xdeba,0xd808,0xdebb,0xd808,0xdebc,0xd808,0xdebd,
	0xd808,0xdebe,0xd808,0xdebf,0xd808,0xdec0,0xd808,0xdec1,0xd808,0xdec2,
	0xd808,0xdec3,0xd808,0xdec4,0xd808,0xdec5,0xd808,0xdec6,0xd808,0xdec7,
	0xd808,0xdec8,0xd808,0xdec9,0xd808,0xdeca,0xd808,0xdecb,0xd808,0xdecc,
	0xd808,0xdecd,0xd808,0xdece,0xd808,0xdecf,0xd808,0xded0,0xd808,0xded1,
	0xd808,0xded2,0xd808,0xded3,0xd808,0xded4,0xd808,0xded5,0xd808,0xded6,
	0xd808,0xded7,0xd808,0xded8,0xd808,0xded9,0xd808,0xdeda,0xd808,0xdedb,
	0xd808,0xdedc,0xd808,0xdedd,0xd808,0xdede,0xd808,0xdedf,0xd808,0xdee0,
	0xd808,0xdee1,0xd808,0xdee2,0xd808,0xdee3,0xd808,0xdee4,0xd808,0xdee5,
	0xd808,0xdee6,0xd808,0xdee7,0xd808,0xdee8,0xd808,0xdee9,0xd808,0xdeea,
	0xd808,0xdeeb,0xd808,0xdeec,0xd808,0xdeed,0xd808,0xdeee,0xd808,0xdeef,
	0xd808,0xdef0,0xd808,0xdef1,0xd808,0xdef2,0xd808,0xdef3,0xd808,0xdef4,
	0xd808,0xdef5,0xd808,0xdef6,0xd808,0xdef7,0xd808,0xdef8,0xd808,0xdef9,
	0xd808,0xdefa,0xd808,0xdefb,0xd808,0xdefc,0xd808,0xdefd,0xd808,0xdefe,
	0xd808,0xdeff,0xd808,0xdf00,0xd808,0xdf01,0xd808,0xdf02,0xd808,0xdf03,
	0xd808,0xdf04,0xd808,0xdf05,0xd808,0xdf06,0xd808,0xdf07,0xd808,0xdf08,
	0xd808,0xdf09,0xd808,0xdf0a,0xd808,0xdf0b,0xd808,0xdf0c,0xd808,0xdf0d,
	0xd808,0xdf0e,0xd808,0xdf0f,0xd808,0xdf10,0xd808,0xdf11,0xd808,0xdf12,
	0xd808,0xdf13,0xd808,0xdf14,0xd808,0xdf15,0xd808,0xdf16,0xd808,0xdf17,
	0xd808,0xdf18,0xd808,0xdf19,0xd808,0xdf1a,0xd808,0xdf1b,0xd808,0xdf1c,
	0xd808,0xdf1d,0xd808,0xdf1e,0xd808,0xdf1f,0xd808,0xdf20,0xd808,0xdf21,
	0xd808,0xdf22,0xd808,0xdf23,0xd808,0xdf24,0xd808,0xdf25,0xd808,0xdf26,
	0xd808,0xdf27,0xd808,0xdf28,0xd808,0xdf29,0xd808,0xdf2a,0xd808,0xdf2b,
	0xd808,0xdf2c,0xd808,0xdf2d,0xd808,0xdf2e,0xd808,0xdf2f,0xd808,0xdf30,
	0xd808,0xdf31,0xd808,0xdf32,0xd808,0xdf33,0xd808,0xdf34,0xd808,0xdf35,
	0xd808,0xdf36,0xd808,0xdf37,0xd808,0xdf38,0xd808,0xdf39,0xd808,0xdf3a,
	0xd808,0xdf3b,0xd808,0xdf3c,0xd808,0xdf3d,0xd808,0xdf3e,0xd808,0xdf3f,
	0xd808,0xdf40,0xd808,0xdf41,0xd808,0xdf42,0xd808,0xdf43,0xd808,0xdf44,
	0xd808,0xdf45,0xd808,0xdf46,0xd808,0xdf47,0xd808,0xdf48,0xd808,0xdf49,
	0xd808,0xdf4a,0xd808,0xdf4b,0xd808,0xdf4c,0xd808,0xdf4d,0xd808,0xdf4e,
	0xd808,0xdf4f,0xd808,0xdf50,0xd808,0xdf51,0xd808,0xdf52,0xd808,0xdf53,
	0xd808,0xdf54,0xd808,0xdf55,0xd808,0xdf56,0xd808,0xdf57,0xd808,0xdf58,
	0xd808,0xdf59,0xd808,0xdf5a,0xd808,0xdf5b,0xd808,0xdf5c,0xd808,0xdf5d,
	0xd808,0xdf5e,0xd808,0xdf5f,0xd808,0xdf60,0xd808,0xdf61,0xd808,0xdf62,
	0xd808,0xdf63,0xd808,0xdf64,0xd808,0xdf65,0xd808,0xdf66,0xd808,0xdf67,
	0xd808,0xdf68,0xd808,0xdf69,0xd808,0xdf6a,0xd808,0xdf6b,0xd808,0xdf6c,
	0xd808,0xdf6d,0xd808,0xdf6e,0xd809,0xdc00,0xd809,0xdc01,0xd809,0xdc02,
	0xd809,0xdc03,0xd809,0xdc04,0xd809,0xdc05,0xd809,0xdc06,0xd809,0xdc07,
	0xd809,0xdc08,0xd809,0xdc09,0xd809,0xdc0a,0xd809,0xdc0b,0xd809,0xdc0c,
	0xd809,0xdc0d,0xd809,0xdc0e,0xd809,0xdc0f,0xd809,0xdc10,0xd809,0xdc11,
	0xd809,0xdc12,0xd809,0xdc13,0xd809,0xdc14,0xd809,0xdc15,0xd809,0xdc16,
	0xd809,0xdc17,0xd809,0xdc18,0xd809,0xdc19,0xd809,0xdc1a,0xd809,0xdc1b,
	0xd809,0xdc1c,0xd809,0xdc1d,0xd809,0xdc1e,0xd809,0xdc1f,0xd809,0xdc20,
	0xd809,0xdc21,0xd809,0xdc22,0xd809,0xdc23,0xd809,0xdc24,0xd809,0xdc25,
	0xd809,0xdc26,0xd809,0xdc27,0xd809,0xdc28,0xd809,0xdc29,0xd809,0xdc2a,
	0xd809,0xdc2b,0xd809,0xdc2c,0xd809,0xdc2d,0xd809,0xdc2e,0xd809,0xdc2f,
	0xd809,0xdc30,0xd809,0xdc31,0xd809,0xdc32,0xd809,0xdc33,0xd809,0xdc34,
	0xd809,0xdc35,0xd809,0xdc36,0xd809,0xdc37,0xd809,0xdc38,0xd809,0xdc39,
	0xd809,0xdc3a,0xd809,0xdc3b,0xd809,0xdc3c,0xd809,0xdc3d,0xd809,0xdc3e,
	0xd809,0xdc3f,0xd809,0xdc40,0xd809,0xdc41,0xd809,0xdc42,0xd809,0xdc43,
	0xd809,0xdc44,0xd809,0xdc45,0xd809,0xdc46,0xd809,0xdc47,0xd809,0xdc48,
	0xd809,0xdc49,0xd809,0xdc4a,0xd809,0xdc4b,0xd809,0xdc4c,0xd809,0xdc4d,
	0xd809,0xdc4e,0xd809,0xdc4f,0xd809,0xdc50,0xd809,0xdc51,0xd809,0xdc52,
	0xd809,0xdc53,0xd809,0xdc54,0xd809,0xdc55,0xd809,0xdc56,0xd809,0xdc57,
	0xd809,0xdc58,0xd809,0xdc59,0xd809,0xdc5a,0xd809,0xdc5b,0xd809,0xdc5c,
	0xd809,0xdc5d,0xd809,0xdc5e,0xd809,0xdc5f,0xd809,0xdc60,0xd809,0xdc61,
	0xd809,0xdc62,0xd809,0xdc70,0xd809,0xdc71,0xd809,0xdc72,0xd809,0xdc73,
	0xd834,0xdc00,0xd834,0xdc01,0xd834,0xdc02,0xd834,0xdc03,0xd834,0xdc04,
	0xd834,0xdc05,0xd834,0xdc06,0xd834,0xdc07,0xd834,0xdc08,0xd834,0xdc09,
	0xd834,0xdc0a,0xd834,0xdc0b,0xd834,0xdc0c,0xd834,0xdc0d,0xd834,0xdc0e,
	0xd834,0xdc0f,0xd834,0xdc10,0xd834,0xdc11,0xd834,0xdc12,0xd834,0xdc13,
	0xd834,0xdc14,0xd834,0xdc15,0xd834,0xdc16,0xd834,0xdc17,0xd834,0xdc18,
	0xd834,0xdc19,0xd834,0xdc1a,0xd834,0xdc1b,0xd834,0xdc1c,0xd834,0xdc1d,
	0xd834,0xdc1e,0xd834,0xdc1f,0xd834,0xdc20,0xd834,0xdc21,0xd834,0xdc22,
	0xd834,0xdc23,0xd834,0xdc24,0xd834,0xdc25,0xd834,0xdc26,0xd834,0xdc27,
	0xd834,0xdc28,0xd834,0xdc29,0xd834,0xdc2a,0xd834,0xdc2b,0xd834,0xdc2c,
	0xd834,0xdc2d,0xd834,0xdc2e,0xd834,0xdc2f,0xd834,0xdc30,0xd834,0xdc31,
	0xd834,0xdc32,0xd834,0xdc33,0xd834,0xdc34,0xd834,0xdc35,0xd834,0xdc36,
	0xd834,0xdc37,0xd834,0xdc38,0xd834,0xdc39,0xd834,0xdc3a,0xd834,0xdc3b,
	0xd834,0xdc3c,0xd834,0xdc3d,0xd834,0xdc3e,0xd834,0xdc3f,0xd834,0xdc40,
	0xd834,0xdc41,0xd834,0xdc42,0xd834,0xdc43,0xd834,0xdc44,0xd834,0xdc45,
	0xd834,0xdc46,0xd834,0xdc47,0xd834,0xdc48,0xd834,0xdc49,0xd834,0xdc4a,
	0xd834,0xdc4b,0xd834,0xdc4c,0xd834,0xdc4d,0xd834,0xdc4e,0xd834,0xdc4f,
	0xd834,0xdc50,0xd834,0xdc51,0xd834,0xdc52,0xd834,0xdc53,0xd834,0xdc54,
	0xd834,0xdc55,0xd834,0xdc56,0xd834,0xdc57,0xd834,0xdc58,0xd834,0xdc59,
	0xd834,0xdc5a,0xd834,0xdc5b,0xd834,0xdc5c,0xd834,0xdc5d,0xd834,0xdc5e,
	0xd834,0xdc5f,0xd834,0xdc60,0xd834,0xdc61,0xd834,0xdc62,0xd834,0xdc63,
	0xd834,0xdc64,0xd834,0xdc65,0xd834,0xdc66,0xd834,0xdc67,0xd834,0xdc68,
	0xd834,0xdc69,0xd834,0xdc6a,0xd834,0xdc6b,0xd834,0xdc6c,0xd834,0xdc6d,
	0xd834,0xdc6e,0xd834,0xdc6f,0xd834,0xdc70,0xd834,0xdc71,0xd834,0xdc72,
	0xd834,0xdc73,0xd834,0xdc74,0xd834,0xdc75,0xd834,0xdc76,0xd834,0xdc77,
	0xd834,0xdc78,0xd834,0xdc79,0xd834,0xdc7a,0xd834,0xdc7b,0xd834,0xdc7c,
	0xd834,0xdc7d,0xd834,0xdc7e,0xd834,0xdc7f,0xd834,0xdc80,0xd834,0xdc81,
	0xd834,0xdc82,0xd834,0xdc83,0xd834,0xdc84,0xd834,0xdc85,0xd834,0xdc86,
	0xd834,0xdc87,0xd834,0xdc88,0xd834,0xdc89,0xd834,0xdc8a,0xd834,0xdc8b,
	0xd834,0xdc8c,0xd834,0xdc8d,0xd834,0xdc8e,0xd834,0xdc8f,0xd834,0xdc90,
	0xd834,0xdc91,0xd834,0xdc92,0xd834,0xdc93,0xd834,0xdc94,0xd834,0xdc95,
	0xd834,0xdc96,0xd834,0xdc97,0xd834,0xdc98,0xd834,0xdc99,0xd834,0xdc9a,
	0xd834,0xdc9b,0xd834,0xdc9c,0xd834,0xdc9d,0xd834,0xdc9e,0xd834,0xdc9f,
	0xd834,0xdca0,0xd834,0xdca1,0xd834,0xdca2,0xd834,0xdca3,0xd834,0xdca4,
	0xd834,0xdca5,0xd834,0xdca6,0xd834,0xdca7,0xd834,0xdca8,0xd834,0xdca9,
	0xd834,0xdcaa,0xd834,0xdcab,0xd834,0xdcac,0xd834,0xdcad,0xd834,0xdcae,
	0xd834,0xdcaf,0xd834,0xdcb0,0xd834,0xdcb1,0xd834,0xdcb2,0xd834,0xdcb3,
	0xd834,0xdcb4,0xd834,0xdcb5,0xd834,0xdcb6,0xd834,0xdcb7,0xd834,0xdcb8,
	0xd834,0xdcb9,0xd834,0xdcba,0xd834,0xdcbb,0xd834,0xdcbc,0xd834,0xdcbd,
	0xd834,0xdcbe,0xd834,0xdcbf,0xd834,0xdcc0,0xd834,0xdcc1,0xd834,0xdcc2,
	0xd834,0xdcc3,0xd834,0xdcc4,0xd834,0xdcc5,0xd834,0xdcc6,0xd834,0xdcc7,
	0xd834,0xdcc8,0xd834,0xdcc9,0xd834,0xdcca,0xd834,0xdccb,0xd834,0xdccc,
	0xd834,0xdccd,0xd834,0xdcce,0xd834,0xdccf,0xd834,0xdcd0,0xd834,0xdcd1,
	0xd834,0xdcd2,0xd834,0xdcd3,0xd834,0xdcd4,0xd834,0xdcd5,0xd834,0xdcd6,
	0xd834,0xdcd7,0xd834,0xdcd8,0xd834,0xdcd9,0xd834,0xdcda,0xd834,0xdcdb,
	0xd834,0xdcdc,0xd834,0xdcdd,0xd834,0xdcde,0xd834,0xdcdf,0xd834,0xdce0,
	0xd834,0xdce1,0xd834,0xdce2,0xd834,0xdce3,0xd834,0xdce4,0xd834,0xdce5,
	0xd834,0xdce6,0xd834,0xdce7,0xd834,0xdce8,0xd834,0xdce9,0xd834,0xdcea,
	0xd834,0xdceb,0xd834,0xdcec,0xd834,0xdced,0xd834,0xdcee,0xd834,0xdcef,
	0xd834,0xdcf0,0xd834,0xdcf1,0xd834,0xdcf2,0xd834,0xdcf3,0xd834,0xdcf4,
	0xd834,0xdcf5,0xd834,0xdd00,0xd834,0xdd01,0xd834,0xdd02,0xd834,0xdd03,
	0xd834,0xdd04,0xd834,0xdd05,0xd834,0xdd06,0xd834,0xdd07,0xd834,0xdd08,
	0xd834,0xdd09,0xd834,0xdd0a,0xd834,0xdd0b,0xd834,0xdd0c,0xd834,0xdd0d,
	0xd834,0xdd0e,0xd834,0xdd0f,0xd834,0xdd10,0xd834,0xdd11,0xd834,0xdd12,
	0xd834,0xdd13,0xd834,0xdd14,0xd834,0xdd15,0xd834,0xdd16,0xd834,0xdd17,
	0xd834,0xdd18,0xd834,0xdd19,0xd834,0xdd1a,0xd834,0xdd1b,0xd834,0xdd1c,
	0xd834,0xdd1d,0xd834,0xdd1e,0xd834,0xdd1f,0xd834,0xdd20,0xd834,0xdd21,
	0xd834,0xdd22,0xd834,0xdd23,0xd834,0xdd24,0xd834,0xdd25,0xd834,0xdd26,
	0xd834,0xdd2a,0xd834,0xdd2b,0xd834,0xdd2c,0xd834,0xdd2d,0xd834,0xdd2e,
	0xd834,0xdd2f,0xd834,0xdd30,0xd834,0xdd31,0xd834,0xdd32,0xd834,0xdd33,
	0xd834,0xdd34,0xd834,0xdd35,0xd834,0xdd36,0xd834,0xdd37,0xd834,0xdd38,
	0xd834,0xdd39,0xd834,0xdd3a,0xd834,0xdd3b,0xd834,0xdd3c,0xd834,0xdd3d,
	0xd834,0xdd3e,0xd834,0xdd3f,0xd834,0xdd40,0xd834,0xdd41,0xd834,0xdd42,
	0xd834,0xdd43,0xd834,0xdd44,0xd834,0xdd45,0xd834,0xdd46,0xd834,0xdd47,
	0xd834,0xdd48,0xd834,0xdd49,0xd834,0xdd4a,0xd834,0xdd4b,0xd834,0xdd4c,
	0xd834,0xdd4d,0xd834,0xdd4e,0xd834,0xdd4f,0xd834,0xdd50,0xd834,0xdd51,
	0xd834,0xdd52,0xd834,0xdd53,0xd834,0xdd54,0xd834,0xdd55,0xd834,0xdd56,
	0xd834,0xdd57,0xd834,0xdd58,0xd834,0xdd59,0xd834,0xdd5a,0xd834,0xdd5b,
	0xd834,0xdd5c,0xd834,0xdd5d,0xd834,0xdd5e,0xd834,0xdd5f,0xd834,0xdd60,
	0xd834,0xdd61,0xd834,0xdd62,0xd834,0xdd63,0xd834,0xdd64,0xd834,0xdd6a,
	0xd834,0xdd6b,0xd834,0xdd6c,0xd834,0xdd83,0xd834,0xdd84,0xd834,0xdd8c,
	0xd834,0xdd8d,0xd834,0xdd8e,0xd834,0xdd8f,0xd834,0xdd90,0xd834,0xdd91,
	0xd834,0xdd92,0xd834,0xdd93,0xd834,0xdd94,0xd834,0xdd95,0xd834,0xdd96,
	0xd834,0xdd97,0xd834,0xdd98,0xd834,0xdd99,0xd834,0xdd9a,0xd834,0xdd9b,
	0xd834,0xdd9c,0xd834,0xdd9d,0xd834,0xdd9e,0xd834,0xdd9f,0xd834,0xdda0,
	0xd834,0xdda1,0xd834,0xdda2,0xd834,0xdda3,0xd834,0xdda4,0xd834,0xdda5,
	0xd834,0xdda6,0xd834,0xdda7,0xd834,0xdda8,0xd834,0xdda9,0xd834,0xddae,
	0xd834,0xddaf,0xd834,0xddb0,0xd834,0xddb1,0xd834,0xddb2,0xd834,0xddb3,
	0xd834,0xddb4,0xd834,0xddb5,0xd834,0xddb6,0xd834,0xddb7,0xd834,0xddb8,
	0xd834,0xddb9,0xd834,0xddba,0xd834,0xddbb,0xd834,0xddbc,0xd834,0xddbd,
	0xd834,0xddbe,0xd834,0xddbf,0xd834,0xddc0,0xd834,0xddc1,0xd834,0xddc2,
	0xd834,0xddc3,0xd834,0xddc4,0xd834,0xddc5,0xd834,0xddc6,0xd834,0xddc7,
	0xd834,0xddc8,0xd834,0xddc9,0xd834,0xddca,0xd834,0xddcb,0xd834,0xddcc,
	0xd834,0xddcd,0xd834,0xddce,0xd834,0xddcf,0xd834,0xddd0,0xd834,0xddd1,
	0xd834,0xddd2,0xd834,0xddd3,0xd834,0xddd4,0xd834,0xddd5,0xd834,0xddd6,
	0xd834,0xddd7,0xd834,0xddd8,0xd834,0xddd9,0xd834,0xddda,0xd834,0xdddb,
	0xd834,0xdddc,0xd834,0xdddd,0xd834,0xdf60,0xd834,0xdf61,0xd834,0xdf62,
	0xd834,0xdf63,0xd834,0xdf64,0xd834,0xdf65,0xd834,0xdf66,0xd834,0xdf67,
	0xd834,0xdf68,0xd834,0xdf69,0xd834,0xdf6a,0xd834,0xdf6b,0xd834,0xdf6c,
	0xd834,0xdf6d,0xd834,0xdf6e,0xd834,0xdf6f,0xd834,0xdf70,0xd834,0xdf71,
	0xd835,0xdc00,0xd835,0xdc01,0xd835,0xdc02,0xd835,0xdc03,0xd835,0xdc04,
	0xd835,0xdc05,0xd835,0xdc06,0xd835,0xdc07,0xd835,0xdc08,0xd835,0xdc09,
	0xd835,0xdc0a,0xd835,0xdc0b,0xd835,0xdc0c,0xd835,0xdc0d,0xd835,0xdc0e,
	0xd835,0xdc0f,0xd835,0xdc10,0xd835,0xdc11,0xd835,0xdc12,0xd835,0xdc13,
	0xd835,0xdc14,0xd835,0xdc15,0xd835,0xdc16,0xd835,0xdc17,0xd835,0xdc18,
	0xd835,0xdc19,0xd835,0xdc1a,0xd835,0xdc1b,0xd835,0xdc1c,0xd835,0xdc1d,
	0xd835,0xdc1e,0xd835,0xdc1f,0xd835,0xdc20,0xd835,0xdc21,0xd835,0xdc22,
	0xd835,0xdc23,0xd835,0xdc24,0xd835,0xdc25,0xd835,0xdc26,0xd835,0xdc27,
	0xd835,0xdc28,0xd835,0xdc29,0xd835,0xdc2a,0xd835,0xdc2b,0xd835,0xdc2c,
	0xd835,0xdc2d,0xd835,0xdc2e,0xd835,0xdc2f,0xd835,0xdc30,0xd835,0xdc31,
	0xd835,0xdc32,0xd835,0xdc33,0xd835,0xdc34,0xd835,0xdc35,0xd835,0xdc36,
	0xd835,0xdc37,0xd835,0xdc38,0xd835,0xdc39,0xd835,0xdc3a,0xd835,0xdc3b,
	0xd835,0xdc3c,0xd835,0xdc3d,0xd835,0xdc3e,0xd835,0xdc3f,0xd835,0xdc40,
	0xd835,0xdc41,0xd835,0xdc42,0xd835,0xdc43,0xd835,0xdc44,0xd835,0xdc45,
	0xd835,0xdc46,0xd835,0xdc47,0xd835,0xdc48,0xd835,0xdc49,0xd835,0xdc4a,
	0xd835,0xdc4b,0xd835,0xdc4c,0xd835,0xdc4d,0xd835,0xdc4e,0xd835,0xdc4f,
	0xd835,0xdc50,0xd835,0xdc51,0xd835,0xdc52,0xd835,0xdc53,0xd835,0xdc54,
	0xd835,0xdc56,0xd835,0xdc57,0xd835,0xdc58,0xd835,0xdc59,0xd835,0xdc5a,
	0xd835,0xdc5b,0xd835,0xdc5c,0xd835,0xdc5d,0xd835,0xdc5e,0xd835,0xdc5f,
	0xd835,0xdc60,0xd835,0xdc61,0xd835,0xdc62,0xd835,0xdc63,0xd835,0xdc64,
	0xd835,0xdc65,0xd835,0xdc66,0xd835,0xdc67,0xd835,0xdc68,0xd835,0xdc69,
	0xd835,0xdc6a,0xd835,0xdc6b,0xd835,0xdc6c,0xd835,0xdc6d,0xd835,0xdc6e,
	0xd835,0xdc6f,0xd835,0xdc70,0xd835,0xdc71,0xd835,0xdc72,0xd835,0xdc73,
	0xd835,0xdc74,0xd835,0xdc75,0xd835,0xdc76,0xd835,0xdc77,0xd835,0xdc78,
	0xd835,0xdc79,0xd835,0xdc7a,0xd835,0xdc7b,0xd835,0xdc7c,0xd835,0xdc7d,
	0xd835,0xdc7e,0xd835,0xdc7f,0xd835,0xdc80,0xd835,0xdc81,0xd835,0xdc82,
	0xd835,0xdc83,0xd835,0xdc84,0xd835,0xdc85,0xd835,0xdc86,0xd835,0xdc87,
	0xd835,0xdc88,0xd835,0xdc89,0xd835,0xdc8a,0xd835,0xdc8b,0xd835,0xdc8c,
	0xd835,0xdc8d,0xd835,0xdc8e,0xd835,0xdc8f,0xd835,0xdc90,0xd835,0xdc91,
	0xd835,0xdc92,0xd835,0xdc93,0xd835,0xdc94,0xd835,0xdc95,0xd835,0xdc96,
	0xd835,0xdc97,0xd835,0xdc98,0xd835,0xdc99,0xd835,0xdc9a,0xd835,0xdc9b,
	0xd835,0xdc9c,0xd835,0xdc9e,0xd835,0xdc9f,0xd835,0xdca2,0xd835,0xdca5,
	0xd835,0xdca6,0xd835,0xdca9,0xd835,0xdcaa,0xd835,0xdcab,0xd835,0xdcac,
	0xd835,0xdcae,0xd835,0xdcaf,0xd835,0xdcb0,0xd835,0xdcb1,0xd835,0xdcb2,
	0xd835,0xdcb3,0xd835,0xdcb4,0xd835,0xdcb5,0xd835,0xdcb6,0xd835,0xdcb7,
	0xd835,0xdcb8,0xd835,0xdcb9,0xd835,0xdcbb,0xd835,0xdcbd,0xd835,0xdcbe,
	0xd835,0xdcbf,0xd835,0xdcc0,0xd835,0xdcc1,0xd835,0xdcc2,0xd835,0xdcc3,
	0xd835,0xdcc5,0xd835,0xdcc6,0xd835,0xdcc7,0xd835,0xdcc8,0xd835,0xdcc9,
	0xd835,0xdcca,0xd835,0xdccb,0xd835,0xdccc,0xd835,0xdccd,0xd835,0xdcce,
	0xd835,0xdccf,0xd835,0xdcd0,0xd835,0xdcd1,0xd835,0xdcd2,0xd835,0xdcd3,
	0xd835,0xdcd4,0xd835,0xdcd5,0xd835,0xdcd6,0xd835,0xdcd7,0xd835,0xdcd8,
	0xd835,0xdcd9,0xd835,0xdcda,0xd835,0xdcdb,0xd835,0xdcdc,0xd835,0xdcdd,
	0xd835,0xdcde,0xd835,0xdcdf,0xd835,0xdce0,0xd835,0xdce1,0xd835,0xdce2,
	0xd835,0xdce3,0xd835,0xdce4,0xd835,0xdce5,0xd835,0xdce6,0xd835,0xdce7,
	0xd835,0xdce8,0xd835,0xdce9,0xd835,0xdcea,0xd835,0xdceb,0xd835,0xdcec,
	0xd835,0xdced,0xd835,0xdcee,0xd835,0xdcef,0xd835,0xdcf0,0xd835,0xdcf1,
	0xd835,0xdcf2,0xd835,0xdcf3,0xd835,0xdcf4,0xd835,0xdcf5,0xd835,0xdcf6,
	0xd835,0xdcf7,0xd835,0xdcf8,0xd835,0xdcf9,0xd835,0xdcfa,0xd835,0xdcfb,
	0xd835,0xdcfc,0xd835,0xdcfd,0xd835,0xdcfe,0xd835,0xdcff,0xd835,0xdd00,
	0xd835,0xdd01,0xd835,0xdd02,0xd835,0xdd03,0xd835,0xdd04,0xd835,0xdd05,
	0xd835,0xdd07,0xd835,0xdd08,0xd835,0xdd09,0xd835,0xdd0a,0xd835,0xdd0d,
	0xd835,0xdd0e,0xd835,0xdd0f,0xd835,0xdd10,0xd835,0xdd11,0xd835,0xdd12,
	0xd835,0xdd13,0xd835,0xdd14,0xd835,0xdd16,0xd835,0xdd17,0xd835,0xdd18,
	0xd835,0xdd19,0xd835,0xdd1a,0xd835,0xdd1b,0xd835,0xdd1c,0xd835,0xdd1e,
	0xd835,0xdd1f,0xd835,0xdd20,0xd835,0xdd21,0xd835,0xdd22,0xd835,0xdd23,
	0xd835,0xdd24,0xd835,0xdd25,0xd835,0xdd26,0xd835,0xdd27,0xd835,0xdd28,
	0xd835,0xdd29,0xd835,0xdd2a,0xd835,0xdd2b,0xd835,0xdd2c,0xd835,0xdd2d,
	0xd835,0xdd2e,0xd835,0xdd2f,0xd835,0xdd30,0xd835,0xdd31,0xd835,0xdd32,
	0xd835,0xdd33,0xd835,0xdd34,0xd835,0xdd35,0xd835,0xdd36,0xd835,0xdd37,
	0xd835,0xdd38,0xd835,0xdd39,0xd835,0xdd3b,0xd835,0xdd3c,0xd835,0xdd3d,
	0xd835,0xdd3e,0xd835,0xdd40,0xd835,0xdd41,0xd835,0xdd42,0xd835,0xdd43,
	0xd835,0xdd44,0xd835,0xdd46,0xd835,0xdd4a,0xd835,0xdd4b,0xd835,0xdd4c,
	0xd835,0xdd4d,0xd835,0xdd4e,0xd835,0xdd4f,0xd835,0xdd50,0xd835,0xdd52,
	0xd835,0xdd53,0xd835,0xdd54,0xd835,0xdd55,0xd835,0xdd56,0xd835,0xdd57,
	0xd835,0xdd58,0xd835,0xdd59,0xd835,0xdd5a,0xd835,0xdd5b,0xd835,0xdd5c,
	0xd835,0xdd5d,0xd835,0xdd5e,0xd835,0xdd5f,0xd835,0xdd60,0xd835,0xdd61,
	0xd835,0xdd62,0xd835,0xdd63,0xd835,0xdd64,0xd835,0xdd65,0xd835,0xdd66,
	0xd835,0xdd67,0xd835,0xdd68,0xd835,0xdd69,0xd835,0xdd6a,0xd835,0xdd6b,
	0xd835,0xdd6c,0xd835,0xdd6d,0xd835,0xdd6e,0xd835,0xdd6f,0xd835,0xdd70,
	0xd835,0xdd71,0xd835,0xdd72,0xd835,0xdd73,0xd835,0xdd74,0xd835,0xdd75,
	0xd835,0xdd76,0xd835,0xdd77,0xd835,0xdd78,0xd835,0xdd79,0xd835,0xdd7a,
	0xd835,0xdd7b,0xd835,0xdd7c,0xd835,0xdd7d,0xd835,0xdd7e,0xd835,0xdd7f,
	0xd835,0xdd80,0xd835,0xdd81,0xd835,0xdd82,0xd835,0xdd83,0xd835,0xdd84,
	0xd835,0xdd85,0xd835,0xdd86,0xd835,0xdd87,0xd835,0xdd88,0xd835,0xdd89,
	0xd835,0xdd8a,0xd835,0xdd8b,0xd835,0xdd8c,0xd835,0xdd8d,0xd835,0xdd8e,
	0xd835,0xdd8f,0xd835,0xdd90,0xd835,0xdd91,0xd835,0xdd92,0xd835,0xdd93,
	0xd835,0xdd94,0xd835,0xdd95,0xd835,0xdd96,0xd835,0xdd97,0xd835,0xdd98,
	0xd835,0xdd99,0xd835,0xdd9a,0xd835,0xdd9b,0xd835,0xdd9c,0xd835,0xdd9d,
	0xd835,0xdd9e,0xd835,0xdd9f,0xd835,0xdda0,0xd835,0xdda1,0xd835,0xdda2,
	0xd835,0xdda3,0xd835,0xdda4,0xd835,0xdda5,0xd835,0xdda6,0xd835,0xdda7,
	0xd835,0xdda8,0xd835,0xdda9,0xd835,0xddaa,0xd835,0xddab,0xd835,0xddac,
	0xd835,0xddad,0xd835,0xddae,0xd835,0xddaf,0xd835,0xddb0,0xd835,0xddb1,
	0xd835,0xddb2,0xd835,0xddb3,0xd835,0xddb4,0xd835,0xddb5,0xd835,0xddb6,
	0xd835,0xddb7,0xd835,0xddb8,0xd835,0xddb9,0xd835,0xddba,0xd835,0xddbb,
	0xd835,0xddbc,0xd835,0xddbd,0xd835,0xddbe,0xd835,0xddbf,0xd835,0xddc0,
	0xd835,0xddc1,0xd835,0xddc2,0xd835,0xddc3,0xd835,0xddc4,0xd835,0xddc5,
	0xd835,0xddc6,0xd835,0xddc7,0xd835,0xddc8,0xd835,0xddc9,0xd835,0xddca,
	0xd835,0xddcb,0xd835,0xddcc,0xd835,0xddcd,0xd835,0xddce,0xd835,0xddcf,
	0xd835,0xddd0,0xd835,0xddd1,0xd835,0xddd2,0xd835,0xddd3,0xd835,0xddd4,
	0xd835,0xddd5,0xd835,0xddd6,0xd835,0xddd7,0xd835,0xddd8,0xd835,0xddd9,
	0xd835,0xddda,0xd835,0xdddb,0xd835,0xdddc,0xd835,0xdddd,0xd835,0xddde,
	0xd835,0xdddf,0xd835,0xdde0,0xd835,0xdde1,0xd835,0xdde2,0xd835,0xdde3,
	0xd835,0xdde4,0xd835,0xdde5,0xd835,0xdde6,0xd835,0xdde7,0xd835,0xdde8,
	0xd835,0xdde9,0xd835,0xddea,0xd835,0xddeb,0xd835,0xddec,0xd835,0xdded,
	0xd835,0xddee,0xd835,0xddef,0xd835,0xddf0,0xd835,0xddf1,0xd835,0xddf2,
	0xd835,0xddf3,0xd835,0xddf4,0xd835,0xddf5,0xd835,0xddf6,0xd835,0xddf7,
	0xd835,0xddf8,0xd835,0xddf9,0xd835,0xddfa,0xd835,0xddfb,0xd835,0xddfc,
	0xd835,0xddfd,0xd835,0xddfe,0xd835,0xddff,0xd835,0xde00,0xd835,0xde01,
	0xd835,0xde02,0xd835,0xde03,0xd835,0xde04,0xd835,0xde05,0xd835,0xde06,
	0xd835,0xde07,0xd835,0xde08,0xd835,0xde09,0xd835,0xde0a,0xd835,0xde0b,
	0xd835,0xde0c,0xd835,0xde0d,0xd835,0xde0e,0xd835,0xde0f,0xd835,0xde10,
	0xd835,0xde11,0xd835,0xde12,0xd835,0xde13,0xd835,0xde14,0xd835,0xde15,
	0xd835,0xde16,0xd835,0xde17,0xd835,0xde18,0xd835,0xde19,0xd835,0xde1a,
	0xd835,0xde1b,0xd835,0xde1c,0xd835,0xde1d,0xd835,0xde1e,0xd835,0xde1f,
	0xd835,0xde20,0xd835,0xde21,0xd835,0xde22,0xd835,0xde23,0xd835,0xde24,
	0xd835,0xde25,0xd835,0xde26,0xd835,0xde27,0xd835,0xde28,0xd835,0xde29,
	0xd835,0xde2a,0xd835,0xde2b,0xd835,0xde2c,0xd835,0xde2d,0xd835,0xde2e,
	0xd835,0xde2f,0xd835,0xde30,0xd835,0xde31,0xd835,0xde32,0xd835,0xde33,
	0xd835,0xde34,0xd835,0xde35,0xd835,0xde36,0xd835,0xde37,0xd835,0xde38,
	0xd835,0xde39,0xd835,0xde3a,0xd835,0xde3b,0xd835,0xde3c,0xd835,0xde3d,
	0xd835,0xde3e,0xd835,0xde3f,0xd835,0xde40,0xd835,0xde41,0xd835,0xde42,
	0xd835,0xde43,0xd835,0xde44,0xd835,0xde45,0xd835,0xde46,0xd835,0xde47,
	0xd835,0xde48,0xd835,0xde49,0xd835,0xde4a,0xd835,0xde4b,0xd835,0xde4c,
	0xd835,0xde4d,0xd835,0xde4e,0xd835,0xde4f,0xd835,0xde50,0xd835,0xde51,
	0xd835,0xde52,0xd835,0xde53,0xd835,0xde54,0xd835,0xde55,0xd835,0xde56,
	0xd835,0xde57,0xd835,0xde58,0xd835,0xde59,0xd835,0xde5a,0xd835,0xde5b,
	0xd835,0xde5c,0xd835,0xde5d,0xd835,0xde5e,0xd835,0xde5f,0xd835,0xde60,
	0xd835,0xde61,0xd835,0xde62,0xd835,0xde63,0xd835,0xde64,0xd835,0xde65,
	0xd835,0xde66,0xd835,0xde67,0xd835,0xde68,0xd835,0xde69,0xd835,0xde6a,
	0xd835,0xde6b,0xd835,0xde6c,0xd835,0xde6d,0xd835,0xde6e,0xd835,0xde6f,
	0xd835,0xde70,0xd835,0xde71,0xd835,0xde72,0xd835,0xde73,0xd835,0xde74,
	0xd835,0xde75,0xd835,0xde76,0xd835,0xde77,0xd835,0xde78,0xd835,0xde79,
	0xd835,0xde7a,0xd835,0xde7b,0xd835,0xde7c,0xd835,0xde7d,0xd835,0xde7e,
	0xd835,0xde7f,0xd835,0xde80,0xd835,0xde81,0xd835,0xde82,0xd835,0xde83,
	0xd835,0xde84,0xd835,0xde85,0xd835,0xde86,0xd835,0xde87,0xd835,0xde88,
	0xd835,0xde89,0xd835,0xde8a,0xd835,0xde8b,0xd835,0xde8c,0xd835,0xde8d,
	0xd835,0xde8e,0xd835,0xde8f,0xd835,0xde90,0xd835,0xde91,0xd835,0xde92,
	0xd835,0xde93,0xd835,0xde94,0xd835,0xde95,0xd835,0xde96,0xd835,0xde97,
	0xd835,0xde98,0xd835,0xde99,0xd835,0xde9a,0xd835,0xde9b,0xd835,0xde9c,
	0xd835,0xde9d,0xd835,0xde9e,0xd835,0xde9f,0xd835,0xdea0,0xd835,0xdea1,
	0xd835,0xdea2,0xd835,0xdea3,0xd835,0xdea4,0xd835,0xdea5,0xd835,0xdea8,
	0xd835,0xdea9,0xd835,0xdeaa,0xd835,0xdeab,0xd835,0xdeac,0xd835,0xdead,
	0xd835,0xdeae,0xd835,0xdeaf,0xd835,0xdeb0,0xd835,0xdeb1,0xd835,0xdeb2,
	0xd835,0xdeb3,0xd835,0xdeb4,0xd835,0xdeb5,0xd835,0xdeb6,0xd835,0xdeb7,
	0xd835,0xdeb8,0xd835,0xdeb9,0xd835,0xdeba,0xd835,0xdebb,0xd835,0xdebc,
	0xd835,0xdebd,0xd835,0xdebe,0xd835,0xdebf,0xd835,0xdec0,0xd835,0xdec1,
	0xd835,0xdec2,0xd835,0xdec3,0xd835,0xdec4,0xd835,0xdec5,0xd835,0xdec6,
	0xd835,0xdec7,0xd835,0xdec8,0xd835,0xdec9,0xd835,0xdeca,0xd835,0xdecb,
	0xd835,0xdecc,0xd835,0xdecd,0xd835,0xdece,0xd835,0xdecf,0xd835,0xded0,
	0xd835,0xded1,0xd835,0xded2,0xd835,0xded3,0xd835,0xded4,0xd835,0xded5,
	0xd835,0xded6,0xd835,0xded7,0xd835,0xded8,0xd835,0xded9,0xd835,0xdeda,
	0xd835,0xdedb,0xd835,0xdedc,0xd835,0xdedd,0xd835,0xdede,0xd835,0xdedf,
	0xd835,0xdee0,0xd835,0xdee1,0xd835,0xdee2,0xd835,0xdee3,0xd835,0xdee4,
	0xd835,0xdee5,0xd835,0xdee6,0xd835,0xdee7,0xd835,0xdee8,0xd835,0xdee9,
	0xd835,0xdeea,0xd835,0xdeeb,0xd835,0xdeec,0xd835,0xdeed,0xd835,0xdeee,
	0xd835,0xdeef,0xd835,0xdef0,0xd835,0xdef1,0xd835,0xdef2,0xd835,0xdef3,
	0xd835,0xdef4,0xd835,0xdef5,0xd835,0xdef6,0xd835,0xdef7,0xd835,0xdef8,
	0xd835,0xdef9,0xd835,0xdefa,0xd835,0xdefb,0xd835,0xdefc,0xd835,0xdefd,
	0xd835,0xdefe,0xd835,0xdeff,0xd835,0xdf00,0xd835,0xdf01,0xd835,0xdf02,
	0xd835,0xdf03,0xd835,0xdf04,0xd835,0xdf05,0xd835,0xdf06,0xd835,0xdf07,
	0xd835,0xdf08,0xd835,0xdf09,0xd835,0xdf0a,0xd835,0xdf0b,0xd835,0xdf0c,
	0xd835,0xdf0d,0xd835,0xdf0e,0xd835,0xdf0f,0xd835,0xdf10,0xd835,0xdf11,
	0xd835,0xdf12,0xd835,0xdf13,0xd835,0xdf14,0xd835,0xdf15,0xd835,0xdf16,
	0xd835,0xdf17,0xd835,0xdf18,0xd835,0xdf19,0xd835,0xdf1a,0xd835,0xdf1b,
	0xd835,0xdf1c,0xd835,0xdf1d,0xd835,0xdf1e,0xd835,0xdf1f,0xd835,0xdf20,
	0xd835,0xdf21,0xd835,0xdf22,0xd835,0xdf23,0xd835,0xdf24,0xd835,0xdf25,
	0xd835,0xdf26,0xd835,0xdf27,0xd835,0xdf28,0xd835,0xdf29,0xd835,0xdf2a,
	0xd835,0xdf2b,0xd835,0xdf2c,0xd835,0xdf2d,0xd835,0xdf2e,0xd835,0xdf2f,
	0xd835,0xdf30,0xd835,0xdf31,0xd835,0xdf32,0xd835,0xdf33,0xd835,0xdf34,
	0xd835,0xdf35,0xd835,0xdf36,0xd835,0xdf37,0xd835,0xdf38,0xd835,0xdf39,
	0xd835,0xdf3a,0xd835,0xdf3b,0xd835,0xdf3c,0xd835,0xdf3d,0xd835,0xdf3e,
	0xd835,0xdf3f,0xd835,0xdf40,0xd835,0xdf41,0xd835,0xdf42,0xd835,0xdf43,
	0xd835,0xdf44,0xd835,0xdf45,0xd835,0xdf46,0xd835,0xdf47,0xd835,0xdf48,
	0xd835,0xdf49,0xd835,0xdf4a,0xd835,0xdf4b,0xd835,0xdf4c,0xd835,0xdf4d,
	0xd835,0xdf4e,0xd835,0xdf4f,0xd835,0xdf50,0xd835,0xdf51,0xd835,0xdf52,
	0xd835,0xdf53,0xd835,0xdf54,0xd835,0xdf55,0xd835,0xdf56,0xd835,0xdf57,
	0xd835,0xdf58,0xd835,0xdf59,0xd835,0xdf5a,0xd835,0xdf5b,0xd835,0xdf5c,
	0xd835,0xdf5d,0xd835,0xdf5e,0xd835,0xdf5f,0xd835,0xdf60,0xd835,0xdf61,
	0xd835,0xdf62,0xd835,0xdf63,0xd835,0xdf64,0xd835,0xdf65,0xd835,0xdf66,
	0xd835,0xdf67,0xd835,0xdf68,0xd835,0xdf69,0xd835,0xdf6a,0xd835,0xdf6b,
	0xd835,0xdf6c,0xd835,0xdf6d,0xd835,0xdf6e,0xd835,0xdf6f,0xd835,0xdf70,
	0xd835,0xdf71,0xd835,0xdf72,0xd835,0xdf73,0xd835,0xdf74,0xd835,0xdf75,
	0xd835,0xdf76,0xd835,0xdf77,0xd835,0xdf78,0xd835,0xdf79,0xd835,0xdf7a,
	0xd835,0xdf7b,0xd835,0xdf7c,0xd835,0xdf7d,0xd835,0xdf7e,0xd835,0xdf7f,
	0xd835,0xdf80,0xd835,0xdf81,0xd835,0xdf82,0xd835,0xdf83,0xd835,0xdf84,
	0xd835,0xdf85,0xd835,0xdf86,0xd835,0xdf87,0xd835,0xdf88,0xd835,0xdf89,
	0xd835,0xdf8a,0xd835,0xdf8b,0xd835,0xdf8c,0xd835,0xdf8d,0xd835,0xdf8e,
	0xd835,0xdf8f,0xd835,0xdf90,0xd835,0xdf91,0xd835,0xdf92,0xd835,0xdf93,
	0xd835,0xdf94,0xd835,0xdf95,0xd835,0xdf96,0xd835,0xdf97,0xd835,0xdf98,
	0xd835,0xdf99,0xd835,0xdf9a,0xd835,0xdf9b,0xd835,0xdf9c,0xd835,0xdf9d,
	0xd835,0xdf9e,0xd835,0xdf9f,0xd835,0xdfa0,0xd835,0xdfa1,0xd835,0xdfa2,
	0xd835,0xdfa3,0xd835,0xdfa4,0xd835,0xdfa5,0xd835,0xdfa6,0xd835,0xdfa7,
	0xd835,0xdfa8,0xd835,0xdfa9,0xd835,0xdfaa,0xd835,0xdfab,0xd835,0xdfac,
	0xd835,0xdfad,0xd835,0xdfae,0xd835,0xdfaf,0xd835,0xdfb0,0xd835,0xdfb1,
	0xd835,0xdfb2,0xd835,0xdfb3,0xd835,0xdfb4,0xd835,0xdfb5,0xd835,0xdfb6,
	0xd835,0xdfb7,0xd835,0xdfb8,0xd835,0xdfb9,0xd835,0xdfba,0xd835,0xdfbb,
	0xd835,0xdfbc,0xd835,0xdfbd,0xd835,0xdfbe,0xd835,0xdfbf,0xd835,0xdfc0,
	0xd835,0xdfc1,0xd835,0xdfc2,0xd835,0xdfc3,0xd835,0xdfc4,0xd835,0xdfc5,
	0xd835,0xdfc6,0xd835,0xdfc7,0xd835,0xdfc8,0xd835,0xdfc9,0xd835,0xdfca,
	0xd835,0xdfcb,0xd840,0xdc00,0xd869,0xded6,0xd87e,0xdc00,0xd87e,0xdc01,
	0xd87e,0xdc02,0xd87e,0xdc03,0xd87e,0xdc04,0xd87e,0xdc05,0xd87e,0xdc06,
	0xd87e,0xdc07,0xd87e,0xdc08,0xd87e,0xdc09,0xd87e,0xdc0a,0xd87e,0xdc0b,
	0xd87e,0xdc0c,0xd87e,0xdc0d,0xd87e,0xdc0e,0xd87e,0xdc0f,0xd87e,0xdc10,
	0xd87e,0xdc11,0xd87e,0xdc12,0xd87e,0xdc13,0xd87e,0xdc14,0xd87e,0xdc15,
	0xd87e,0xdc16,0xd87e,0xdc17,0xd87e,0xdc18,0xd87e,0xdc19,0xd87e,0xdc1a,
	0xd87e,0xdc1b,0xd87e,0xdc1c,0xd87e,0xdc1d,0xd87e,0xdc1e,0xd87e,0xdc1f,
	0xd87e,0xdc20,0xd87e,0xdc21,0xd87e,0xdc22,0xd87e,0xdc23,0xd87e,0xdc24,
	0xd87e,0xdc25,0xd87e,0xdc26,0xd87e,0xdc27,0xd87e,0xdc28,0xd87e,0xdc29,
	0xd87e,0xdc2a,0xd87e,0xdc2b,0xd87e,0xdc2c,0xd87e,0xdc2d,0xd87e,0xdc2e,
	0xd87e,0xdc2f,0xd87e,0xdc30,0xd87e,0xdc31,0xd87e,0xdc32,0xd87e,0xdc33,
	0xd87e,0xdc34,0xd87e,0xdc35,0xd87e,0xdc36,0xd87e,0xdc37,0xd87e,0xdc38,
	0xd87e,0xdc39,0xd87e,0xdc3a,0xd87e,0xdc3b,0xd87e,0xdc3c,0xd87e,0xdc3d,
	0xd87e,0xdc3e,0xd87e,0xdc3f,0xd87e,0xdc40,0xd87e,0xdc41,0xd87e,0xdc42,
	0xd87e,0xdc43,0xd87e,0xdc44,0xd87e,0xdc45,0xd87e,0xdc46,0xd87e,0xdc47,
	0xd87e,0xdc48,0xd87e,0xdc49,0xd87e,0xdc4a,0xd87e,0xdc4b,0xd87e,0xdc4c,
	0xd87e,0xdc4d,0xd87e,0xdc4e,0xd87e,0xdc4f,0xd87e,0xdc50,0xd87e,0xdc51,
	0xd87e,0xdc52,0xd87e,0xdc53,0xd87e,0xdc54,0xd87e,0xdc55,0xd87e,0xdc56,
	0xd87e,0xdc57,0xd87e,0xdc58,0xd87e,0xdc59,0xd87e,0xdc5a,0xd87e,0xdc5b,
	0xd87e,0xdc5c,0xd87e,0xdc5d,0xd87e,0xdc5e,0xd87e,0xdc5f,0xd87e,0xdc60,
	0xd87e,0xdc61,0xd87e,0xdc62,0xd87e,0xdc63,0xd87e,0xdc64,0xd87e,0xdc65,
	0xd87e,0xdc66,0xd87e,0xdc67,0xd87e,0xdc68,0xd87e,0xdc69,0xd87e,0xdc6a,
	0xd87e,0xdc6b,0xd87e,0xdc6c,0xd87e,0xdc6d,0xd87e,0xdc6e,0xd87e,0xdc6f,
	0xd87e,0xdc70,0xd87e,0xdc71,0xd87e,0xdc72,0xd87e,0xdc73,0xd87e,0xdc74,
	0xd87e,0xdc75,0xd87e,0xdc76,0xd87e,0xdc77,0xd87e,0xdc78,0xd87e,0xdc79,
	0xd87e,0xdc7a,0xd87e,0xdc7b,0xd87e,0xdc7c,0xd87e,0xdc7d,0xd87e,0xdc7e,
	0xd87e,0xdc7f,0xd87e,0xdc80,0xd87e,0xdc81,0xd87e,0xdc82,0xd87e,0xdc83,
	0xd87e,0xdc84,0xd87e,0xdc85,0xd87e,0xdc86,0xd87e,0xdc87,0xd87e,0xdc88,
	0xd87e,0xdc89,0xd87e,0xdc8a,0xd87e,0xdc8b,0xd87e,0xdc8c,0xd87e,0xdc8d,
	0xd87e,0xdc8e,0xd87e,0xdc8f,0xd87e,0xdc90,0xd87e,0xdc91,0xd87e,0xdc92,
	0xd87e,0xdc93,0xd87e,0xdc94,0xd87e,0xdc95,0xd87e,0xdc96,0xd87e,0xdc97,
	0xd87e,0xdc98,0xd87e,0xdc99,0xd87e,0xdc9a,0xd87e,0xdc9b,0xd87e,0xdc9c,
	0xd87e,0xdc9d,0xd87e,0xdc9e,0xd87e,0xdc9f,0xd87e,0xdca0,0xd87e,0xdca1,
	0xd87e,0xdca2,0xd87e,0xdca3,0xd87e,0xdca4,0xd87e,0xdca5,0xd87e,0xdca6,
	0xd87e,0xdca7,0xd87e,0xdca8,0xd87e,0xdca9,0xd87e,0xdcaa,0xd87e,0xdcab,
	0xd87e,0xdcac,0xd87e,0xdcad,0xd87e,0xdcae,0xd87e,0xdcaf,0xd87e,0xdcb0,
	0xd87e,0xdcb1,0xd87e,0xdcb2,0xd87e,0xdcb3,0xd87e,0xdcb4,0xd87e,0xdcb5,
	0xd87e,0xdcb6,0xd87e,0xdcb7,0xd87e,0xdcb8,0xd87e,0xdcb9,0xd87e,0xdcba,
	0xd87e,0xdcbb,0xd87e,0xdcbc,0xd87e,0xdcbd,0xd87e,0xdcbe,0xd87e,0xdcbf,
	0xd87e,0xdcc0,0xd87e,0xdcc1,0xd87e,0xdcc2,0xd87e,0xdcc3,0xd87e,0xdcc4,
	0xd87e,0xdcc5,0xd87e,0xdcc6,0xd87e,0xdcc7,0xd87e,0xdcc8,0xd87e,0xdcc9,
	0xd87e,0xdcca,0xd87e,0xdccb,0xd87e,0xdccc,0xd87e,0xdccd,0xd87e,0xdcce,
	0xd87e,0xdccf,0xd87e,0xdcd0,0xd87e,0xdcd1,0xd87e,0xdcd2,0xd87e,0xdcd3,
	0xd87e,0xdcd4,0xd87e,0xdcd5,0xd87e,0xdcd6,0xd87e,0xdcd7,0xd87e,0xdcd8,
	0xd87e,0xdcd9,0xd87e,0xdcda,0xd87e,0xdcdb,0xd87e,0xdcdc,0xd87e,0xdcdd,
	0xd87e,0xdcde,0xd87e,0xdcdf,0xd87e,0xdce0,0xd87e,0xdce1,0xd87e,0xdce2,
	0xd87e,0xdce3,0xd87e,0xdce4,0xd87e,0xdce5,0xd87e,0xdce6,0xd87e,0xdce7,
	0xd87e,0xdce8,0xd87e,0xdce9,0xd87e,0xdcea,0xd87e,0xdceb,0xd87e,0xdcec,
	0xd87e,0xdced,0xd87e,0xdcee,0xd87e,0xdcef,0xd87e,0xdcf0,0xd87e,0xdcf1,
	0xd87e,0xdcf2,0xd87e,0xdcf3,0xd87e,0xdcf4,0xd87e,0xdcf5,0xd87e,0xdcf6,
	0xd87e,0xdcf7,0xd87e,0xdcf8,0xd87e,0xdcf9,0xd87e,0xdcfa,0xd87e,0xdcfb,
	0xd87e,0xdcfc,0xd87e,0xdcfd,0xd87e,0xdcfe,0xd87e,0xdcff,0xd87e,0xdd00,
	0xd87e,0xdd01,0xd87e,0xdd02,0xd87e,0xdd03,0xd87e,0xdd04,0xd87e,0xdd05,
	0xd87e,0xdd06,0xd87e,0xdd07,0xd87e,0xdd08,0xd87e,0xdd09,0xd87e,0xdd0a,
	0xd87e,0xdd0b,0xd87e,0xdd0c,0xd87e,0xdd0d,0xd87e,0xdd0e,0xd87e,0xdd0f,
	0xd87e,0xdd10,0xd87e,0xdd11,0xd87e,0xdd12,0xd87e,0xdd13,0xd87e,0xdd14,
	0xd87e,0xdd15,0xd87e,0xdd16,0xd87e,0xdd17,0xd87e,0xdd18,0xd87e,0xdd19,
	0xd87e,0xdd1a,0xd87e,0xdd1b,0xd87e,0xdd1c,0xd87e,0xdd1d,0xd87e,0xdd1e,
	0xd87e,0xdd1f,0xd87e,0xdd20,0xd87e,0xdd21,0xd87e,0xdd22,0xd87e,0xdd23,
	0xd87e,0xdd24,0xd87e,0xdd25,0xd87e,0xdd26,0xd87e,0xdd27,0xd87e,0xdd28,
	0xd87e,0xdd29,0xd87e,0xdd2a,0xd87e,0xdd2b,0xd87e,0xdd2c,0xd87e,0xdd2d,
	0xd87e,0xdd2e,0xd87e,0xdd2f,0xd87e,0xdd30,0xd87e,0xdd31,0xd87e,0xdd32,
	0xd87e,0xdd33,0xd87e,0xdd34,0xd87e,0xdd35,0xd87e,0xdd36,0xd87e,0xdd37,
	0xd87e,0xdd38,0xd87e,0xdd39,0xd87e,0xdd3a,0xd87e,0xdd3b,0xd87e,0xdd3c,
	0xd87e,0xdd3d,0xd87e,0xdd3e,0xd87e,0xdd3f,0xd87e,0xdd40,0xd87e,0xdd41,
	0xd87e,0xdd42,0xd87e,0xdd43,0xd87e,0xdd44,0xd87e,0xdd45,0xd87e,0xdd46,
	0xd87e,0xdd47,0xd87e,0xdd48,0xd87e,0xdd49,0xd87e,0xdd4a,0xd87e,0xdd4b,
	0xd87e,0xdd4c,0xd87e,0xdd4d,0xd87e,0xdd4e,0xd87e,0xdd4f,0xd87e,0xdd50,
	0xd87e,0xdd51,0xd87e,0xdd52,0xd87e,0xdd53,0xd87e,0xdd54,0xd87e,0xdd55,
	0xd87e,0xdd56,0xd87e,0xdd57,0xd87e,0xdd58,0xd87e,0xdd59,0xd87e,0xdd5a,
	0xd87e,0xdd5b,0xd87e,0xdd5c,0xd87e,0xdd5d,0xd87e,0xdd5e,0xd87e,0xdd5f,
	0xd87e,0xdd60,0xd87e,0xdd61,0xd87e,0xdd62,0xd87e,0xdd63,0xd87e,0xdd64,
	0xd87e,0xdd65,0xd87e,0xdd66,0xd87e,0xdd67,0xd87e,0xdd68,0xd87e,0xdd69,
	0xd87e,0xdd6a,0xd87e,0xdd6b,0xd87e,0xdd6c,0xd87e,0xdd6d,0xd87e,0xdd6e,
	0xd87e,0xdd6f,0xd87e,0xdd70,0xd87e,0xdd71,0xd87e,0xdd72,0xd87e,0xdd73,
	0xd87e,0xdd74,0xd87e,0xdd75,0xd87e,0xdd76,0xd87e,0xdd77,0xd87e,0xdd78,
	0xd87e,0xdd79,0xd87e,0xdd7a,0xd87e,0xdd7b,0xd87e,0xdd7c,0xd87e,0xdd7d,
	0xd87e,0xdd7e,0xd87e,0xdd7f,0xd87e,0xdd80,0xd87e,0xdd81,0xd87e,0xdd82,
	0xd87e,0xdd83,0xd87e,0xdd84,0xd87e,0xdd85,0xd87e,0xdd86,0xd87e,0xdd87,
	0xd87e,0xdd88,0xd87e,0xdd89,0xd87e,0xdd8a,0xd87e,0xdd8b,0xd87e,0xdd8c,
	0xd87e,0xdd8d,0xd87e,0xdd8e,0xd87e,0xdd8f,0xd87e,0xdd90,0xd87e,0xdd91,
	0xd87e,0xdd92,0xd87e,0xdd93,0xd87e,0xdd94,0xd87e,0xdd95,0xd87e,0xdd96,
	0xd87e,0xdd97,0xd87e,0xdd98,0xd87e,0xdd99,0xd87e,0xdd9a,0xd87e,0xdd9b,
	0xd87e,0xdd9c,0xd87e,0xdd9d,0xd87e,0xdd9e,0xd87e,0xdd9f,0xd87e,0xdda0,
	0xd87e,0xdda1,0xd87e,0xdda2,0xd87e,0xdda3,0xd87e,0xdda4,0xd87e,0xdda5,
	0xd87e,0xdda6,0xd87e,0xdda7,0xd87e,0xdda8,0xd87e,0xdda9,0xd87e,0xddaa,
	0xd87e,0xddab,0xd87e,0xddac,0xd87e,0xddad,0xd87e,0xddae,0xd87e,0xddaf,
	0xd87e,0xddb0,0xd87e,0xddb1,0xd87e,0xddb2,0xd87e,0xddb3,0xd87e,0xddb4,
	0xd87e,0xddb5,0xd87e,0xddb6,0xd87e,0xddb7,0xd87e,0xddb8,0xd87e,0xddb9,
	0xd87e,0xddba,0xd87e,0xddbb,0xd87e,0xddbc,0xd87e,0xddbd,0xd87e,0xddbe,
	0xd87e,0xddbf,0xd87e,0xddc0,0xd87e,0xddc1,0xd87e,0xddc2,0xd87e,0xddc3,
	0xd87e,0xddc4,0xd87e,0xddc5,0xd87e,0xddc6,0xd87e,0xddc7,0xd87e,0xddc8,
	0xd87e,0xddc9,0xd87e,0xddca,0xd87e,0xddcb,0xd87e,0xddcc,0xd87e,0xddcd,
	0xd87e,0xddce,0xd87e,0xddcf,0xd87e,0xddd0,0xd87e,0xddd1,0xd87e,0xddd2,
	0xd87e,0xddd3,0xd87e,0xddd4,0xd87e,0xddd5,0xd87e,0xddd6,0xd87e,0xddd7,
	0xd87e,0xddd8,0xd87e,0xddd9,0xd87e,0xddda,0xd87e,0xdddb,0xd87e,0xdddc,
	0xd87e,0xdddd,0xd87e,0xddde,0xd87e,0xdddf,0xd87e,0xdde0,0xd87e,0xdde1,
	0xd87e,0xdde2,0xd87e,0xdde3,0xd87e,0xdde4,0xd87e,0xdde5,0xd87e,0xdde6,
	0xd87e,0xdde7,0xd87e,0xdde8,0xd87e,0xdde9,0xd87e,0xddea,0xd87e,0xddeb,
	0xd87e,0xddec,0xd87e,0xdded,0xd87e,0xddee,0xd87e,0xddef,0xd87e,0xddf0,
	0xd87e,0xddf1,0xd87e,0xddf2,0xd87e,0xddf3,0xd87e,0xddf4,0xd87e,0xddf5,
	0xd87e,0xddf6,0xd87e,0xddf7,0xd87e,0xddf8,0xd87e,0xddf9,0xd87e,0xddfa,
	0xd87e,0xddfb,0xd87e,0xddfc,0xd87e,0xddfd,0xd87e,0xddfe,0xd87e,0xddff,
	0xd87e,0xde00,0xd87e,0xde01,0xd87e,0xde02,0xd87e,0xde03,0xd87e,0xde04,
	0xd87e,0xde05,0xd87e,0xde06,0xd87e,0xde07,0xd87e,0xde08,0xd87e,0xde09,
	0xd87e,0xde0a,0xd87e,0xde0b,0xd87e,0xde0c,0xd87e,0xde0d,0xd87e,0xde0e,
	0xd87e,0xde0f,0xd87e,0xde10,0xd87e,0xde11,0xd87e,0xde12,0xd87e,0xde13,
	0xd87e,0xde14,0xd87e,0xde15,0xd87e,0xde16,0xd87e,0xde17,0xd87e,0xde18,
	0xd87e,0xde19,0xd87e,0xde1a,0xd87e,0xde1b,0xd87e,0xde1c,0xd87e,0xde1d,
	0xdb80,0xdc00,0xdbbf,0xdffd,0xdbc0,0xdc00,0xdbff,0xdffd,
};
static const TUint KLeftToRightLength = 8309 + 6998;

// This constant defines the Unicode characters in the "LeftToRightOverride" (LRO) category.
static const TUint16 KLeftToRightOverride[] = 
	{
	0x202d
	};

// This constant defines the Unicode characters in the "RightToLeft" (R) category.
static const TUint16 KRightToLeft[] = 
	{
	0x05be,0x05c0,0x05c3,0x05c6,0x05d0,0x05d1,0x05d2,0x05d3,0x05d4,0x05d5,
	0x05d6,0x05d7,0x05d8,0x05d9,0x05da,0x05db,0x05dc,0x05dd,0x05de,0x05df,
	0x05e0,0x05e1,0x05e2,0x05e3,0x05e4,0x05e5,0x05e6,0x05e7,0x05e8,0x05e9,
	0x05ea,0x05f0,0x05f1,0x05f2,0x05f3,0x05f4,0x07c0,0x07c1,0x07c2,0x07c3,
	0x07c4,0x07c5,0x07c6,0x07c7,0x07c8,0x07c9,0x07ca,0x07cb,0x07cc,0x07cd,
	0x07ce,0x07cf,0x07d0,0x07d1,0x07d2,0x07d3,0x07d4,0x07d5,0x07d6,0x07d7,
	0x07d8,0x07d9,0x07da,0x07db,0x07dc,0x07dd,0x07de,0x07df,0x07e0,0x07e1,
	0x07e2,0x07e3,0x07e4,0x07e5,0x07e6,0x07e7,0x07e8,0x07e9,0x07ea,0x07f4,
	0x07f5,0x07fa,0x200f,0xfb1d,0xfb1f,0xfb20,0xfb21,0xfb22,0xfb23,0xfb24,
	0xfb25,0xfb26,0xfb27,0xfb28,0xfb2a,0xfb2b,0xfb2c,0xfb2d,0xfb2e,0xfb2f,
	0xfb30,0xfb31,0xfb32,0xfb33,0xfb34,0xfb35,0xfb36,0xfb38,0xfb39,0xfb3a,
	0xfb3b,0xfb3c,0xfb3e,0xfb40,0xfb41,0xfb43,0xfb44,0xfb46,0xfb47,0xfb48,
	0xfb49,0xfb4a,0xfb4b,0xfb4c,0xfb4d,0xfb4e,0xfb4f,0xd802,0xdc00,
	0xd802,0xdc01,0xd802,0xdc02,0xd802,0xdc03,0xd802,0xdc04,0xd802,0xdc05,
	0xd802,0xdc08,0xd802,0xdc0a,0xd802,0xdc0b,0xd802,0xdc0c,0xd802,0xdc0d,
	0xd802,0xdc0e,0xd802,0xdc0f,0xd802,0xdc10,0xd802,0xdc11,0xd802,0xdc12,
	0xd802,0xdc13,0xd802,0xdc14,0xd802,0xdc15,0xd802,0xdc16,0xd802,0xdc17,
	0xd802,0xdc18,0xd802,0xdc19,0xd802,0xdc1a,0xd802,0xdc1b,0xd802,0xdc1c,
	0xd802,0xdc1d,0xd802,0xdc1e,0xd802,0xdc1f,0xd802,0xdc20,0xd802,0xdc21,
	0xd802,0xdc22,0xd802,0xdc23,0xd802,0xdc24,0xd802,0xdc25,0xd802,0xdc26,
	0xd802,0xdc27,0xd802,0xdc28,0xd802,0xdc29,0xd802,0xdc2a,0xd802,0xdc2b,
	0xd802,0xdc2c,0xd802,0xdc2d,0xd802,0xdc2e,0xd802,0xdc2f,0xd802,0xdc30,
	0xd802,0xdc31,0xd802,0xdc32,0xd802,0xdc33,0xd802,0xdc34,0xd802,0xdc35,
	0xd802,0xdc37,0xd802,0xdc38,0xd802,0xdc3c,0xd802,0xdc3f,0xd802,0xdd00,
	0xd802,0xdd01,0xd802,0xdd02,0xd802,0xdd03,0xd802,0xdd04,0xd802,0xdd05,
	0xd802,0xdd06,0xd802,0xdd07,0xd802,0xdd08,0xd802,0xdd09,0xd802,0xdd0a,
	0xd802,0xdd0b,0xd802,0xdd0c,0xd802,0xdd0d,0xd802,0xdd0e,0xd802,0xdd0f,
	0xd802,0xdd10,0xd802,0xdd11,0xd802,0xdd12,0xd802,0xdd13,0xd802,0xdd14,
	0xd802,0xdd15,0xd802,0xdd16,0xd802,0xdd17,0xd802,0xdd18,0xd802,0xdd19,
	0xd802,0xde00,0xd802,0xde10,0xd802,0xde11,0xd802,0xde12,0xd802,0xde13,
	0xd802,0xde15,0xd802,0xde16,0xd802,0xde17,0xd802,0xde19,0xd802,0xde1a,
	0xd802,0xde1b,0xd802,0xde1c,0xd802,0xde1d,0xd802,0xde1e,0xd802,0xde1f,
	0xd802,0xde20,0xd802,0xde21,0xd802,0xde22,0xd802,0xde23,0xd802,0xde24,
	0xd802,0xde25,0xd802,0xde26,0xd802,0xde27,0xd802,0xde28,0xd802,0xde29,
	0xd802,0xde2a,0xd802,0xde2b,0xd802,0xde2c,0xd802,0xde2d,0xd802,0xde2e,
	0xd802,0xde2f,0xd802,0xde30,0xd802,0xde31,0xd802,0xde32,0xd802,0xde33,
	0xd802,0xde40,0xd802,0xde41,0xd802,0xde42,0xd802,0xde43,0xd802,0xde44,
	0xd802,0xde45,0xd802,0xde46,0xd802,0xde47,0xd802,0xde50,0xd802,0xde51,
	0xd802,0xde52,0xd802,0xde53,0xd802,0xde54,0xd802,0xde55,0xd802,0xde56,
	0xd802,0xde57,0xd802,0xde58,
	};
static const TUint KRightToLeftLength = 127 + 266;

// This constant defines the Unicode characters in the "RightToLeftArabic" (AL) category.
static const TUint16 KRightToLeftArabic[] = 
	{
	0x0600,0x0601,0x0602,0x0603,0x060b,0x060d,0x061b,0x061e,0x061f,0x0621,
	0x0622,0x0623,0x0624,0x0625,0x0626,0x0627,0x0628,0x0629,0x062a,0x062b,
	0x062c,0x062d,0x062e,0x062f,0x0630,0x0631,0x0632,0x0633,0x0634,0x0635,
	0x0636,0x0637,0x0638,0x0639,0x063a,0x0640,0x0641,0x0642,0x0643,0x0644,
	0x0645,0x0646,0x0647,0x0648,0x0649,0x064a,0x066d,0x066e,0x066f,0x0671,
	0x0672,0x0673,0x0674,0x0675,0x0676,0x0677,0x0678,0x0679,0x067a,0x067b,
	0x067c,0x067d,0x067e,0x067f,0x0680,0x0681,0x0682,0x0683,0x0684,0x0685,
	0x0686,0x0687,0x0688,0x0689,0x068a,0x068b,0x068c,0x068d,0x068e,0x068f,
	0x0690,0x0691,0x0692,0x0693,0x0694,0x0695,0x0696,0x0697,0x0698,0x0699,
	0x069a,0x069b,0x069c,0x069d,0x069e,0x069f,0x06a0,0x06a1,0x06a2,0x06a3,
	0x06a4,0x06a5,0x06a6,0x06a7,0x06a8,0x06a9,0x06aa,0x06ab,0x06ac,0x06ad,
	0x06ae,0x06af,0x06b0,0x06b1,0x06b2,0x06b3,0x06b4,0x06b5,0x06b6,0x06b7,
	0x06b8,0x06b9,0x06ba,0x06bb,0x06bc,0x06bd,0x06be,0x06bf,0x06c0,0x06c1,
	0x06c2,0x06c3,0x06c4,0x06c5,0x06c6,0x06c7,0x06c8,0x06c9,0x06ca,0x06cb,
	0x06cc,0x06cd,0x06ce,0x06cf,0x06d0,0x06d1,0x06d2,0x06d3,0x06d4,0x06d5,
	0x06dd,0x06e5,0x06e6,0x06ee,0x06ef,0x06fa,0x06fb,0x06fc,0x06fd,0x06fe,
	0x06ff,0x0700,0x0701,0x0702,0x0703,0x0704,0x0705,0x0706,0x0707,0x0708,
	0x0709,0x070a,0x070b,0x070c,0x070d,0x0710,0x0712,0x0713,0x0714,0x0715,
	0x0716,0x0717,0x0718,0x0719,0x071a,0x071b,0x071c,0x071d,0x071e,0x071f,
	0x0720,0x0721,0x0722,0x0723,0x0724,0x0725,0x0726,0x0727,0x0728,0x0729,
	0x072a,0x072b,0x072c,0x072d,0x072e,0x072f,0x074d,0x074e,0x074f,0x0750,
	0x0751,0x0752,0x0753,0x0754,0x0755,0x0756,0x0757,0x0758,0x0759,0x075a,
	0x075b,0x075c,0x075d,0x075e,0x075f,0x0760,0x0761,0x0762,0x0763,0x0764,
	0x0765,0x0766,0x0767,0x0768,0x0769,0x076a,0x076b,0x076c,0x076d,0x0780,
	0x0781,0x0782,0x0783,0x0784,0x0785,0x0786,0x0787,0x0788,0x0789,0x078a,
	0x078b,0x078c,0x078d,0x078e,0x078f,0x0790,0x0791,0x0792,0x0793,0x0794,
	0x0795,0x0796,0x0797,0x0798,0x0799,0x079a,0x079b,0x079c,0x079d,0x079e,
	0x079f,0x07a0,0x07a1,0x07a2,0x07a3,0x07a4,0x07a5,0x07b1,0xfb50,0xfb51,
	0xfb52,0xfb53,0xfb54,0xfb55,0xfb56,0xfb57,0xfb58,0xfb59,0xfb5a,0xfb5b,
	0xfb5c,0xfb5d,0xfb5e,0xfb5f,0xfb60,0xfb61,0xfb62,0xfb63,0xfb64,0xfb65,
	0xfb66,0xfb67,0xfb68,0xfb69,0xfb6a,0xfb6b,0xfb6c,0xfb6d,0xfb6e,0xfb6f,
	0xfb70,0xfb71,0xfb72,0xfb73,0xfb74,0xfb75,0xfb76,0xfb77,0xfb78,0xfb79,
	0xfb7a,0xfb7b,0xfb7c,0xfb7d,0xfb7e,0xfb7f,0xfb80,0xfb81,0xfb82,0xfb83,
	0xfb84,0xfb85,0xfb86,0xfb87,0xfb88,0xfb89,0xfb8a,0xfb8b,0xfb8c,0xfb8d,
	0xfb8e,0xfb8f,0xfb90,0xfb91,0xfb92,0xfb93,0xfb94,0xfb95,0xfb96,0xfb97,
	0xfb98,0xfb99,0xfb9a,0xfb9b,0xfb9c,0xfb9d,0xfb9e,0xfb9f,0xfba0,0xfba1,
	0xfba2,0xfba3,0xfba4,0xfba5,0xfba6,0xfba7,0xfba8,0xfba9,0xfbaa,0xfbab,
	0xfbac,0xfbad,0xfbae,0xfbaf,0xfbb0,0xfbb1,0xfbd3,0xfbd4,0xfbd5,0xfbd6,
	0xfbd7,0xfbd8,0xfbd9,0xfbda,0xfbdb,0xfbdc,0xfbdd,0xfbde,0xfbdf,0xfbe0,
	0xfbe1,0xfbe2,0xfbe3,0xfbe4,0xfbe5,0xfbe6,0xfbe7,0xfbe8,0xfbe9,0xfbea,
	0xfbeb,0xfbec,0xfbed,0xfbee,0xfbef,0xfbf0,0xfbf1,0xfbf2,0xfbf3,0xfbf4,
	0xfbf5,0xfbf6,0xfbf7,0xfbf8,0xfbf9,0xfbfa,0xfbfb,0xfbfc,0xfbfd,0xfbfe,
	0xfbff,0xfc00,0xfc01,0xfc02,0xfc03,0xfc04,0xfc05,0xfc06,0xfc07,0xfc08,
	0xfc09,0xfc0a,0xfc0b,0xfc0c,0xfc0d,0xfc0e,0xfc0f,0xfc10,0xfc11,0xfc12,
	0xfc13,0xfc14,0xfc15,0xfc16,0xfc17,0xfc18,0xfc19,0xfc1a,0xfc1b,0xfc1c,
	0xfc1d,0xfc1e,0xfc1f,0xfc20,0xfc21,0xfc22,0xfc23,0xfc24,0xfc25,0xfc26,
	0xfc27,0xfc28,0xfc29,0xfc2a,0xfc2b,0xfc2c,0xfc2d,0xfc2e,0xfc2f,0xfc30,
	0xfc31,0xfc32,0xfc33,0xfc34,0xfc35,0xfc36,0xfc37,0xfc38,0xfc39,0xfc3a,
	0xfc3b,0xfc3c,0xfc3d,0xfc3e,0xfc3f,0xfc40,0xfc41,0xfc42,0xfc43,0xfc44,
	0xfc45,0xfc46,0xfc47,0xfc48,0xfc49,0xfc4a,0xfc4b,0xfc4c,0xfc4d,0xfc4e,
	0xfc4f,0xfc50,0xfc51,0xfc52,0xfc53,0xfc54,0xfc55,0xfc56,0xfc57,0xfc58,
	0xfc59,0xfc5a,0xfc5b,0xfc5c,0xfc5d,0xfc5e,0xfc5f,0xfc60,0xfc61,0xfc62,
	0xfc63,0xfc64,0xfc65,0xfc66,0xfc67,0xfc68,0xfc69,0xfc6a,0xfc6b,0xfc6c,
	0xfc6d,0xfc6e,0xfc6f,0xfc70,0xfc71,0xfc72,0xfc73,0xfc74,0xfc75,0xfc76,
	0xfc77,0xfc78,0xfc79,0xfc7a,0xfc7b,0xfc7c,0xfc7d,0xfc7e,0xfc7f,0xfc80,
	0xfc81,0xfc82,0xfc83,0xfc84,0xfc85,0xfc86,0xfc87,0xfc88,0xfc89,0xfc8a,
	0xfc8b,0xfc8c,0xfc8d,0xfc8e,0xfc8f,0xfc90,0xfc91,0xfc92,0xfc93,0xfc94,
	0xfc95,0xfc96,0xfc97,0xfc98,0xfc99,0xfc9a,0xfc9b,0xfc9c,0xfc9d,0xfc9e,
	0xfc9f,0xfca0,0xfca1,0xfca2,0xfca3,0xfca4,0xfca5,0xfca6,0xfca7,0xfca8,
	0xfca9,0xfcaa,0xfcab,0xfcac,0xfcad,0xfcae,0xfcaf,0xfcb0,0xfcb1,0xfcb2,
	0xfcb3,0xfcb4,0xfcb5,0xfcb6,0xfcb7,0xfcb8,0xfcb9,0xfcba,0xfcbb,0xfcbc,
	0xfcbd,0xfcbe,0xfcbf,0xfcc0,0xfcc1,0xfcc2,0xfcc3,0xfcc4,0xfcc5,0xfcc6,
	0xfcc7,0xfcc8,0xfcc9,0xfcca,0xfccb,0xfccc,0xfccd,0xfcce,0xfccf,0xfcd0,
	0xfcd1,0xfcd2,0xfcd3,0xfcd4,0xfcd5,0xfcd6,0xfcd7,0xfcd8,0xfcd9,0xfcda,
	0xfcdb,0xfcdc,0xfcdd,0xfcde,0xfcdf,0xfce0,0xfce1,0xfce2,0xfce3,0xfce4,
	0xfce5,0xfce6,0xfce7,0xfce8,0xfce9,0xfcea,0xfceb,0xfcec,0xfced,0xfcee,
	0xfcef,0xfcf0,0xfcf1,0xfcf2,0xfcf3,0xfcf4,0xfcf5,0xfcf6,0xfcf7,0xfcf8,
	0xfcf9,0xfcfa,0xfcfb,0xfcfc,0xfcfd,0xfcfe,0xfcff,0xfd00,0xfd01,0xfd02,
	0xfd03,0xfd04,0xfd05,0xfd06,0xfd07,0xfd08,0xfd09,0xfd0a,0xfd0b,0xfd0c,
	0xfd0d,0xfd0e,0xfd0f,0xfd10,0xfd11,0xfd12,0xfd13,0xfd14,0xfd15,0xfd16,
	0xfd17,0xfd18,0xfd19,0xfd1a,0xfd1b,0xfd1c,0xfd1d,0xfd1e,0xfd1f,0xfd20,
	0xfd21,0xfd22,0xfd23,0xfd24,0xfd25,0xfd26,0xfd27,0xfd28,0xfd29,0xfd2a,
	0xfd2b,0xfd2c,0xfd2d,0xfd2e,0xfd2f,0xfd30,0xfd31,0xfd32,0xfd33,0xfd34,
	0xfd35,0xfd36,0xfd37,0xfd38,0xfd39,0xfd3a,0xfd3b,0xfd3c,0xfd3d,0xfd50,
	0xfd51,0xfd52,0xfd53,0xfd54,0xfd55,0xfd56,0xfd57,0xfd58,0xfd59,0xfd5a,
	0xfd5b,0xfd5c,0xfd5d,0xfd5e,0xfd5f,0xfd60,0xfd61,0xfd62,0xfd63,0xfd64,
	0xfd65,0xfd66,0xfd67,0xfd68,0xfd69,0xfd6a,0xfd6b,0xfd6c,0xfd6d,0xfd6e,
	0xfd6f,0xfd70,0xfd71,0xfd72,0xfd73,0xfd74,0xfd75,0xfd76,0xfd77,0xfd78,
	0xfd79,0xfd7a,0xfd7b,0xfd7c,0xfd7d,0xfd7e,0xfd7f,0xfd80,0xfd81,0xfd82,
	0xfd83,0xfd84,0xfd85,0xfd86,0xfd87,0xfd88,0xfd89,0xfd8a,0xfd8b,0xfd8c,
	0xfd8d,0xfd8e,0xfd8f,0xfd92,0xfd93,0xfd94,0xfd95,0xfd96,0xfd97,0xfd98,
	0xfd99,0xfd9a,0xfd9b,0xfd9c,0xfd9d,0xfd9e,0xfd9f,0xfda0,0xfda1,0xfda2,
	0xfda3,0xfda4,0xfda5,0xfda6,0xfda7,0xfda8,0xfda9,0xfdaa,0xfdab,0xfdac,
	0xfdad,0xfdae,0xfdaf,0xfdb0,0xfdb1,0xfdb2,0xfdb3,0xfdb4,0xfdb5,0xfdb6,
	0xfdb7,0xfdb8,0xfdb9,0xfdba,0xfdbb,0xfdbc,0xfdbd,0xfdbe,0xfdbf,0xfdc0,
	0xfdc1,0xfdc2,0xfdc3,0xfdc4,0xfdc5,0xfdc6,0xfdc7,0xfdf0,0xfdf1,0xfdf2,
	0xfdf3,0xfdf4,0xfdf5,0xfdf6,0xfdf7,0xfdf8,0xfdf9,0xfdfa,0xfdfb,0xfdfc,
	0xfe70,0xfe71,0xfe72,0xfe73,0xfe74,0xfe76,0xfe77,0xfe78,0xfe79,0xfe7a,
	0xfe7b,0xfe7c,0xfe7d,0xfe7e,0xfe7f,0xfe80,0xfe81,0xfe82,0xfe83,0xfe84,
	0xfe85,0xfe86,0xfe87,0xfe88,0xfe89,0xfe8a,0xfe8b,0xfe8c,0xfe8d,0xfe8e,
	0xfe8f,0xfe90,0xfe91,0xfe92,0xfe93,0xfe94,0xfe95,0xfe96,0xfe97,0xfe98,
	0xfe99,0xfe9a,0xfe9b,0xfe9c,0xfe9d,0xfe9e,0xfe9f,0xfea0,0xfea1,0xfea2,
	0xfea3,0xfea4,0xfea5,0xfea6,0xfea7,0xfea8,0xfea9,0xfeaa,0xfeab,0xfeac,
	0xfead,0xfeae,0xfeaf,0xfeb0,0xfeb1,0xfeb2,0xfeb3,0xfeb4,0xfeb5,0xfeb6,
	0xfeb7,0xfeb8,0xfeb9,0xfeba,0xfebb,0xfebc,0xfebd,0xfebe,0xfebf,0xfec0,
	0xfec1,0xfec2,0xfec3,0xfec4,0xfec5,0xfec6,0xfec7,0xfec8,0xfec9,0xfeca,
	0xfecb,0xfecc,0xfecd,0xfece,0xfecf,0xfed0,0xfed1,0xfed2,0xfed3,0xfed4,
	0xfed5,0xfed6,0xfed7,0xfed8,0xfed9,0xfeda,0xfedb,0xfedc,0xfedd,0xfede,
	0xfedf,0xfee0,0xfee1,0xfee2,0xfee3,0xfee4,0xfee5,0xfee6,0xfee7,0xfee8,
	0xfee9,0xfeea,0xfeeb,0xfeec,0xfeed,0xfeee,0xfeef,0xfef0,0xfef1,0xfef2,
	0xfef3,0xfef4,0xfef5,0xfef6,0xfef7,0xfef8,0xfef9,0xfefa,0xfefb,0xfefc,
	};
static const TUint KRightToLeftArabicLength = 1010;

// This constant defines the Unicode characters in the "RightToLeftOverride" (RLO) category.
static const TUint16 KRightToLeftOverride[] = 
	{
	0x202e
	};

// This constant defines the Unicode characters in the "PopDirectionalFormat" (PDF) category.
static const TUint16 KPopDirectionalFormat[] = 
	{
	0x202c
	};

// This constant defines the Unicode characters in the "EuropeanNumber" (EN) category.
static const TUint16 KEuropeanNumber[] = 
	{
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,
	0x00b2,0x00b3,0x00b9,0x06f0,0x06f1,0x06f2,0x06f3,0x06f4,0x06f5,0x06f6,
	0x06f7,0x06f8,0x06f9,0x2070,0x2074,0x2075,0x2076,0x2077,0x2078,0x2079,
	0x2080,0x2081,0x2082,0x2083,0x2084,0x2085,0x2086,0x2087,0x2088,0x2089,
	0x2488,0x2489,0x248a,0x248b,0x248c,0x248d,0x248e,0x248f,0x2490,0x2491,
	0x2492,0x2493,0x2494,0x2495,0x2496,0x2497,0x2498,0x2499,0x249a,0x249b,
	0xff10,0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17,0xff18,0xff19,
	0xd835,0xdfce,0xd835,0xdfcf,0xd835,0xdfd0,0xd835,0xdfd1,0xd835,0xdfd2,
	0xd835,0xdfd3,0xd835,0xdfd4,0xd835,0xdfd5,0xd835,0xdfd6,0xd835,0xdfd7,
	0xd835,0xdfd8,0xd835,0xdfd9,0xd835,0xdfda,0xd835,0xdfdb,0xd835,0xdfdc,
	0xd835,0xdfdd,0xd835,0xdfde,0xd835,0xdfdf,0xd835,0xdfe0,0xd835,0xdfe1,
	0xd835,0xdfe2,0xd835,0xdfe3,0xd835,0xdfe4,0xd835,0xdfe5,0xd835,0xdfe6,
	0xd835,0xdfe7,0xd835,0xdfe8,0xd835,0xdfe9,0xd835,0xdfea,0xd835,0xdfeb,
	0xd835,0xdfec,0xd835,0xdfed,0xd835,0xdfee,0xd835,0xdfef,0xd835,0xdff0,
	0xd835,0xdff1,0xd835,0xdff2,0xd835,0xdff3,0xd835,0xdff4,0xd835,0xdff5,
	0xd835,0xdff6,0xd835,0xdff7,0xd835,0xdff8,0xd835,0xdff9,0xd835,0xdffa,
	0xd835,0xdffb,0xd835,0xdffc,0xd835,0xdffd,0xd835,0xdffe,0xd835,0xdfff,
	};
static const TUint KEuropeanNumberLength = 70 + 100;

// This constant defines the Unicode characters in the "EuropeanNumberTerminator" (ET) category.
static const TUint16 KEuropeanNumberTerminator[] = 
	{
	0x0023,0x0024,0x0025,0x00a2,0x00a3,0x00a4,0x00a5,0x00b0,0x00b1,0x066a,
	0x09f2,0x09f3,0x0af1,0x0bf9,0x0e3f,0x17db,0x2030,0x2031,0x2032,0x2033,
	0x2034,0x20a0,0x20a1,0x20a2,0x20a3,0x20a4,0x20a5,0x20a6,0x20a7,0x20a8,
	0x20a9,0x20aa,0x20ab,0x20ac,0x20ad,0x20ae,0x20af,0x20b0,0x20b1,0x20b2,
	0x20b3,0x20b4,0x20b5,0x212e,0x2213,0xfe5f,0xfe69,0xfe6a,0xff03,0xff04,
	0xff05,0xffe0,0xffe1,0xffe5,0xffe6,
	};
static const TUint KEuropeanNumberTerminatorLength = 55;


// This constant defines the Unicode characters in the "ArabicNumber" (AN) category.
static const TUint16 KArabicNumber[] = 
	{
	0x0660,0x0661,0x0662,0x0663,0x0664,0x0665,0x0666,0x0667,0x0668,0x0669,
	0x066b,0x066c,
	};

static const TUint KArabicNumberLength = 12;

// This constant defines the Unicode characters in the "OtherNeutrals" category.
// A conventional _LIT cannot be used here because of the Microsoft limit of 
// 2048 bytes for literal strings.
static const TUint16 KOtherNeutrals[] = 
	{
	0x0021,0x0022,0x0026,0x0027,0x0028,0x0029,0x002a,0x003b,0x003c,0x003d,
	0x003e,0x003f,0x0040,0x005b,0x005c,0x005d,0x005e,0x005f,0x0060,0x007b,
	0x007c,0x007d,0x007e,0x00a1,0x00a6,0x00a7,0x00a8,0x00a9,0x00ab,0x00ac,
	0x00ae,0x00af,0x00b4,0x00b6,0x00b7,0x00b8,0x00bb,0x00bc,0x00bd,0x00be,
	0x00bf,0x00d7,0x00f7,0x02b9,0x02ba,0x02c2,0x02c3,0x02c4,0x02c5,0x02c6,
	0x02c7,0x02c8,0x02c9,0x02ca,0x02cb,0x02cc,0x02cd,0x02ce,0x02cf,0x02d2,
	0x02d3,0x02d4,0x02d5,0x02d6,0x02d7,0x02d8,0x02d9,0x02da,0x02db,0x02dc,
	0x02dd,0x02de,0x02df,0x02e5,0x02e6,0x02e7,0x02e8,0x02e9,0x02ea,0x02eb,
	0x02ec,0x02ed,0x02ef,0x02f0,0x02f1,0x02f2,0x02f3,0x02f4,0x02f5,0x02f6,
	0x02f7,0x02f8,0x02f9,0x02fa,0x02fb,0x02fc,0x02fd,0x02fe,0x02ff,0x0374,
	0x0375,0x037e,0x0384,0x0385,0x0387,0x03f6,0x058a,0x060e,0x060f,0x06e9,
	0x07f6,0x07f7,0x07f8,0x07f9,0x0bf3,0x0bf4,0x0bf5,0x0bf6,0x0bf7,0x0bf8,
	0x0bfa,0x0cf1,0x0cf2,0x0f3a,0x0f3b,0x0f3c,0x0f3d,0x1390,0x1391,0x1392,
	0x1393,0x1394,0x1395,0x1396,0x1397,0x1398,0x1399,0x169b,0x169c,0x17f0,
	0x17f1,0x17f2,0x17f3,0x17f4,0x17f5,0x17f6,0x17f7,0x17f8,0x17f9,0x1800,
	0x1801,0x1802,0x1803,0x1804,0x1805,0x1806,0x1807,0x1808,0x1809,0x180a,
	0x1940,0x1944,0x1945,0x19de,0x19df,0x19e0,0x19e1,0x19e2,0x19e3,0x19e4,
	0x19e5,0x19e6,0x19e7,0x19e8,0x19e9,0x19ea,0x19eb,0x19ec,0x19ed,0x19ee,
	0x19ef,0x19f0,0x19f1,0x19f2,0x19f3,0x19f4,0x19f5,0x19f6,0x19f7,0x19f8,
	0x19f9,0x19fa,0x19fb,0x19fc,0x19fd,0x19fe,0x19ff,0x1fbd,0x1fbf,0x1fc0,
	0x1fc1,0x1fcd,0x1fce,0x1fcf,0x1fdd,0x1fde,0x1fdf,0x1fed,0x1fee,0x1fef,
	0x1ffd,0x1ffe,0x2010,0x2011,0x2012,0x2013,0x2014,0x2015,0x2016,0x2017,
	0x2018,0x2019,0x201a,0x201b,0x201c,0x201d,0x201e,0x201f,0x2020,0x2021,
	0x2022,0x2023,0x2024,0x2025,0x2026,0x2027,0x2035,0x2036,0x2037,0x2038,
	0x2039,0x203a,0x203b,0x203c,0x203d,0x203e,0x203f,0x2040,0x2041,0x2042,
	0x2043,0x2045,0x2046,0x2047,0x2048,0x2049,0x204a,0x204b,0x204c,0x204d,
	0x204e,0x204f,0x2050,0x2051,0x2052,0x2053,0x2054,0x2055,0x2056,0x2057,
	0x2058,0x2059,0x205a,0x205b,0x205c,0x205d,0x205e,0x207c,0x207d,0x207e,
	0x208c,0x208d,0x208e,0x2100,0x2101,0x2103,0x2104,0x2105,0x2106,0x2108,
	0x2109,0x2114,0x2116,0x2117,0x2118,0x211e,0x211f,0x2120,0x2121,0x2122,
	0x2123,0x2125,0x2127,0x2129,0x213a,0x213b,0x2140,0x2141,0x2142,0x2143,
	0x2144,0x214a,0x214b,0x214c,0x214d,0x2153,0x2154,0x2155,0x2156,0x2157,
	0x2158,0x2159,0x215a,0x215b,0x215c,0x215d,0x215e,0x215f,0x2190,0x2191,
	0x2192,0x2193,0x2194,0x2195,0x2196,0x2197,0x2198,0x2199,0x219a,0x219b,
	0x219c,0x219d,0x219e,0x219f,0x21a0,0x21a1,0x21a2,0x21a3,0x21a4,0x21a5,
	0x21a6,0x21a7,0x21a8,0x21a9,0x21aa,0x21ab,0x21ac,0x21ad,0x21ae,0x21af,
	0x21b0,0x21b1,0x21b2,0x21b3,0x21b4,0x21b5,0x21b6,0x21b7,0x21b8,0x21b9,
	0x21ba,0x21bb,0x21bc,0x21bd,0x21be,0x21bf,0x21c0,0x21c1,0x21c2,0x21c3,
	0x21c4,0x21c5,0x21c6,0x21c7,0x21c8,0x21c9,0x21ca,0x21cb,0x21cc,0x21cd,
	0x21ce,0x21cf,0x21d0,0x21d1,0x21d2,0x21d3,0x21d4,0x21d5,0x21d6,0x21d7,
	0x21d8,0x21d9,0x21da,0x21db,0x21dc,0x21dd,0x21de,0x21df,0x21e0,0x21e1,
	0x21e2,0x21e3,0x21e4,0x21e5,0x21e6,0x21e7,0x21e8,0x21e9,0x21ea,0x21eb,
	0x21ec,0x21ed,0x21ee,0x21ef,0x21f0,0x21f1,0x21f2,0x21f3,0x21f4,0x21f5,
	0x21f6,0x21f7,0x21f8,0x21f9,0x21fa,0x21fb,0x21fc,0x21fd,0x21fe,0x21ff,
	0x2200,0x2201,0x2202,0x2203,0x2204,0x2205,0x2206,0x2207,0x2208,0x2209,
	0x220a,0x220b,0x220c,0x220d,0x220e,0x220f,0x2210,0x2211,0x2214,0x2215,
	0x2216,0x2217,0x2218,0x2219,0x221a,0x221b,0x221c,0x221d,0x221e,0x221f,
	0x2220,0x2221,0x2222,0x2223,0x2224,0x2225,0x2226,0x2227,0x2228,0x2229,
	0x222a,0x222b,0x222c,0x222d,0x222e,0x222f,0x2230,0x2231,0x2232,0x2233,
	0x2234,0x2235,0x2236,0x2237,0x2238,0x2239,0x223a,0x223b,0x223c,0x223d,
	0x223e,0x223f,0x2240,0x2241,0x2242,0x2243,0x2244,0x2245,0x2246,0x2247,
	0x2248,0x2249,0x224a,0x224b,0x224c,0x224d,0x224e,0x224f,0x2250,0x2251,
	0x2252,0x2253,0x2254,0x2255,0x2256,0x2257,0x2258,0x2259,0x225a,0x225b,
	0x225c,0x225d,0x225e,0x225f,0x2260,0x2261,0x2262,0x2263,0x2264,0x2265,
	0x2266,0x2267,0x2268,0x2269,0x226a,0x226b,0x226c,0x226d,0x226e,0x226f,
	0x2270,0x2271,0x2272,0x2273,0x2274,0x2275,0x2276,0x2277,0x2278,0x2279,
	0x227a,0x227b,0x227c,0x227d,0x227e,0x227f,0x2280,0x2281,0x2282,0x2283,
	0x2284,0x2285,0x2286,0x2287,0x2288,0x2289,0x228a,0x228b,0x228c,0x228d,
	0x228e,0x228f,0x2290,0x2291,0x2292,0x2293,0x2294,0x2295,0x2296,0x2297,
	0x2298,0x2299,0x229a,0x229b,0x229c,0x229d,0x229e,0x229f,0x22a0,0x22a1,
	0x22a2,0x22a3,0x22a4,0x22a5,0x22a6,0x22a7,0x22a8,0x22a9,0x22aa,0x22ab,
	0x22ac,0x22ad,0x22ae,0x22af,0x22b0,0x22b1,0x22b2,0x22b3,0x22b4,0x22b5,
	0x22b6,0x22b7,0x22b8,0x22b9,0x22ba,0x22bb,0x22bc,0x22bd,0x22be,0x22bf,
	0x22c0,0x22c1,0x22c2,0x22c3,0x22c4,0x22c5,0x22c6,0x22c7,0x22c8,0x22c9,
	0x22ca,0x22cb,0x22cc,0x22cd,0x22ce,0x22cf,0x22d0,0x22d1,0x22d2,0x22d3,
	0x22d4,0x22d5,0x22d6,0x22d7,0x22d8,0x22d9,0x22da,0x22db,0x22dc,0x22dd,
	0x22de,0x22df,0x22e0,0x22e1,0x22e2,0x22e3,0x22e4,0x22e5,0x22e6,0x22e7,
	0x22e8,0x22e9,0x22ea,0x22eb,0x22ec,0x22ed,0x22ee,0x22ef,0x22f0,0x22f1,
	0x22f2,0x22f3,0x22f4,0x22f5,0x22f6,0x22f7,0x22f8,0x22f9,0x22fa,0x22fb,
	0x22fc,0x22fd,0x22fe,0x22ff,0x2300,0x2301,0x2302,0x2303,0x2304,0x2305,
	0x2306,0x2307,0x2308,0x2309,0x230a,0x230b,0x230c,0x230d,0x230e,0x230f,
	0x2310,0x2311,0x2312,0x2313,0x2314,0x2315,0x2316,0x2317,0x2318,0x2319,
	0x231a,0x231b,0x231c,0x231d,0x231e,0x231f,0x2320,0x2321,0x2322,0x2323,
	0x2324,0x2325,0x2326,0x2327,0x2328,0x2329,0x232a,0x232b,0x232c,0x232d,
	0x232e,0x232f,0x2330,0x2331,0x2332,0x2333,0x2334,0x2335,0x237b,0x237c,
	0x237d,0x237e,0x237f,0x2380,0x2381,0x2382,0x2383,0x2384,0x2385,0x2386,
	0x2387,0x2388,0x2389,0x238a,0x238b,0x238c,0x238d,0x238e,0x238f,0x2390,
	0x2391,0x2392,0x2393,0x2394,0x2396,0x2397,0x2398,0x2399,0x239a,0x239b,
	0x239c,0x239d,0x239e,0x239f,0x23a0,0x23a1,0x23a2,0x23a3,0x23a4,0x23a5,
	0x23a6,0x23a7,0x23a8,0x23a9,0x23aa,0x23ab,0x23ac,0x23ad,0x23ae,0x23af,
	0x23b0,0x23b1,0x23b2,0x23b3,0x23b4,0x23b5,0x23b6,0x23b7,0x23b8,0x23b9,
	0x23ba,0x23bb,0x23bc,0x23bd,0x23be,0x23bf,0x23c0,0x23c1,0x23c2,0x23c3,
	0x23c4,0x23c5,0x23c6,0x23c7,0x23c8,0x23c9,0x23ca,0x23cb,0x23cc,0x23cd,
	0x23ce,0x23cf,0x23d0,0x23d1,0x23d2,0x23d3,0x23d4,0x23d5,0x23d6,0x23d7,
	0x23d8,0x23d9,0x23da,0x23db,0x23dc,0x23dd,0x23de,0x23df,0x23e0,0x23e1,
	0x23e2,0x23e3,0x23e4,0x23e5,0x23e6,0x23e7,0x2400,0x2401,0x2402,0x2403,
	0x2404,0x2405,0x2406,0x2407,0x2408,0x2409,0x240a,0x240b,0x240c,0x240d,
	0x240e,0x240f,0x2410,0x2411,0x2412,0x2413,0x2414,0x2415,0x2416,0x2417,
	0x2418,0x2419,0x241a,0x241b,0x241c,0x241d,0x241e,0x241f,0x2420,0x2421,
	0x2422,0x2423,0x2424,0x2425,0x2426,0x2440,0x2441,0x2442,0x2443,0x2444,
	0x2445,0x2446,0x2447,0x2448,0x2449,0x244a,0x2460,0x2461,0x2462,0x2463,
	0x2464,0x2465,0x2466,0x2467,0x2468,0x2469,0x246a,0x246b,0x246c,0x246d,
	0x246e,0x246f,0x2470,0x2471,0x2472,0x2473,0x2474,0x2475,0x2476,0x2477,
	0x2478,0x2479,0x247a,0x247b,0x247c,0x247d,0x247e,0x247f,0x2480,0x2481,
	0x2482,0x2483,0x2484,0x2485,0x2486,0x2487,0x24ea,0x24eb,0x24ec,0x24ed,
	0x24ee,0x24ef,0x24f0,0x24f1,0x24f2,0x24f3,0x24f4,0x24f5,0x24f6,0x24f7,
	0x24f8,0x24f9,0x24fa,0x24fb,0x24fc,0x24fd,0x24fe,0x24ff,0x2500,0x2501,
	0x2502,0x2503,0x2504,0x2505,0x2506,0x2507,0x2508,0x2509,0x250a,0x250b,
	0x250c,0x250d,0x250e,0x250f,0x2510,0x2511,0x2512,0x2513,0x2514,0x2515,
	0x2516,0x2517,0x2518,0x2519,0x251a,0x251b,0x251c,0x251d,0x251e,0x251f,
	0x2520,0x2521,0x2522,0x2523,0x2524,0x2525,0x2526,0x2527,0x2528,0x2529,
	0x252a,0x252b,0x252c,0x252d,0x252e,0x252f,0x2530,0x2531,0x2532,0x2533,
	0x2534,0x2535,0x2536,0x2537,0x2538,0x2539,0x253a,0x253b,0x253c,0x253d,
	0x253e,0x253f,0x2540,0x2541,0x2542,0x2543,0x2544,0x2545,0x2546,0x2547,
	0x2548,0x2549,0x254a,0x254b,0x254c,0x254d,0x254e,0x254f,0x2550,0x2551,
	0x2552,0x2553,0x2554,0x2555,0x2556,0x2557,0x2558,0x2559,0x255a,0x255b,
	0x255c,0x255d,0x255e,0x255f,0x2560,0x2561,0x2562,0x2563,0x2564,0x2565,
	0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,0x256d,0x256e,0x256f,
	0x2570,0x2571,0x2572,0x2573,0x2574,0x2575,0x2576,0x2577,0x2578,0x2579,
	0x257a,0x257b,0x257c,0x257d,0x257e,0x257f,0x2580,0x2581,0x2582,0x2583,
	0x2584,0x2585,0x2586,0x2587,0x2588,0x2589,0x258a,0x258b,0x258c,0x258d,
	0x258e,0x258f,0x2590,0x2591,0x2592,0x2593,0x2594,0x2595,0x2596,0x2597,
	0x2598,0x2599,0x259a,0x259b,0x259c,0x259d,0x259e,0x259f,0x25a0,0x25a1,
	0x25a2,0x25a3,0x25a4,0x25a5,0x25a6,0x25a7,0x25a8,0x25a9,0x25aa,0x25ab,
	0x25ac,0x25ad,0x25ae,0x25af,0x25b0,0x25b1,0x25b2,0x25b3,0x25b4,0x25b5,
	0x25b6,0x25b7,0x25b8,0x25b9,0x25ba,0x25bb,0x25bc,0x25bd,0x25be,0x25bf,
	0x25c0,0x25c1,0x25c2,0x25c3,0x25c4,0x25c5,0x25c6,0x25c7,0x25c8,0x25c9,
	0x25ca,0x25cb,0x25cc,0x25cd,0x25ce,0x25cf,0x25d0,0x25d1,0x25d2,0x25d3,
	0x25d4,0x25d5,0x25d6,0x25d7,0x25d8,0x25d9,0x25da,0x25db,0x25dc,0x25dd,
	0x25de,0x25df,0x25e0,0x25e1,0x25e2,0x25e3,0x25e4,0x25e5,0x25e6,0x25e7,
	0x25e8,0x25e9,0x25ea,0x25eb,0x25ec,0x25ed,0x25ee,0x25ef,0x25f0,0x25f1,
	0x25f2,0x25f3,0x25f4,0x25f5,0x25f6,0x25f7,0x25f8,0x25f9,0x25fa,0x25fb,
	0x25fc,0x25fd,0x25fe,0x25ff,0x2600,0x2601,0x2602,0x2603,0x2604,0x2605,
	0x2606,0x2607,0x2608,0x2609,0x260a,0x260b,0x260c,0x260d,0x260e,0x260f,
	0x2610,0x2611,0x2612,0x2613,0x2614,0x2615,0x2616,0x2617,0x2618,0x2619,
	0x261a,0x261b,0x261c,0x261d,0x261e,0x261f,0x2620,0x2621,0x2622,0x2623,
	0x2624,0x2625,0x2626,0x2627,0x2628,0x2629,0x262a,0x262b,0x262c,0x262d,
	0x262e,0x262f,0x2630,0x2631,0x2632,0x2633,0x2634,0x2635,0x2636,0x2637,
	0x2638,0x2639,0x263a,0x263b,0x263c,0x263d,0x263e,0x263f,0x2640,0x2641,
	0x2642,0x2643,0x2644,0x2645,0x2646,0x2647,0x2648,0x2649,0x264a,0x264b,
	0x264c,0x264d,0x264e,0x264f,0x2650,0x2651,0x2652,0x2653,0x2654,0x2655,
	0x2656,0x2657,0x2658,0x2659,0x265a,0x265b,0x265c,0x265d,0x265e,0x265f,
	0x2660,0x2661,0x2662,0x2663,0x2664,0x2665,0x2666,0x2667,0x2668,0x2669,
	0x266a,0x266b,0x266c,0x266d,0x266e,0x266f,0x2670,0x2671,0x2672,0x2673,
	0x2674,0x2675,0x2676,0x2677,0x2678,0x2679,0x267a,0x267b,0x267c,0x267d,
	0x267e,0x267f,0x2680,0x2681,0x2682,0x2683,0x2684,0x2685,0x2686,0x2687,
	0x2688,0x2689,0x268a,0x268b,0x268c,0x268d,0x268e,0x268f,0x2690,0x2691,
	0x2692,0x2693,0x2694,0x2695,0x2696,0x2697,0x2698,0x2699,0x269a,0x269b,
	0x269c,0x26a0,0x26a1,0x26a2,0x26a3,0x26a4,0x26a5,0x26a6,0x26a7,0x26a8,
	0x26a9,0x26aa,0x26ab,0x26ad,0x26ae,0x26af,0x26b0,0x26b1,0x26b2,0x2701,
	0x2702,0x2703,0x2704,0x2706,0x2707,0x2708,0x2709,0x270c,0x270d,0x270e,
	0x270f,0x2710,0x2711,0x2712,0x2713,0x2714,0x2715,0x2716,0x2717,0x2718,
	0x2719,0x271a,0x271b,0x271c,0x271d,0x271e,0x271f,0x2720,0x2721,0x2722,
	0x2723,0x2724,0x2725,0x2726,0x2727,0x2729,0x272a,0x272b,0x272c,0x272d,
	0x272e,0x272f,0x2730,0x2731,0x2732,0x2733,0x2734,0x2735,0x2736,0x2737,
	0x2738,0x2739,0x273a,0x273b,0x273c,0x273d,0x273e,0x273f,0x2740,0x2741,
	0x2742,0x2743,0x2744,0x2745,0x2746,0x2747,0x2748,0x2749,0x274a,0x274b,
	0x274d,0x274f,0x2750,0x2751,0x2752,0x2756,0x2758,0x2759,0x275a,0x275b,
	0x275c,0x275d,0x275e,0x2761,0x2762,0x2763,0x2764,0x2765,0x2766,0x2767,
	0x2768,0x2769,0x276a,0x276b,0x276c,0x276d,0x276e,0x276f,0x2770,0x2771,
	0x2772,0x2773,0x2774,0x2775,0x2776,0x2777,0x2778,0x2779,0x277a,0x277b,
	0x277c,0x277d,0x277e,0x277f,0x2780,0x2781,0x2782,0x2783,0x2784,0x2785,
	0x2786,0x2787,0x2788,0x2789,0x278a,0x278b,0x278c,0x278d,0x278e,0x278f,
	0x2790,0x2791,0x2792,0x2793,0x2794,0x2798,0x2799,0x279a,0x279b,0x279c,
	0x279d,0x279e,0x279f,0x27a0,0x27a1,0x27a2,0x27a3,0x27a4,0x27a5,0x27a6,
	0x27a7,0x27a8,0x27a9,0x27aa,0x27ab,0x27ac,0x27ad,0x27ae,0x27af,0x27b1,
	0x27b2,0x27b3,0x27b4,0x27b5,0x27b6,0x27b7,0x27b8,0x27b9,0x27ba,0x27bb,
	0x27bc,0x27bd,0x27be,0x27c0,0x27c1,0x27c2,0x27c3,0x27c4,0x27c5,0x27c6,
	0x27c7,0x27c8,0x27c9,0x27ca,0x27d0,0x27d1,0x27d2,0x27d3,0x27d4,0x27d5,
	0x27d6,0x27d7,0x27d8,0x27d9,0x27da,0x27db,0x27dc,0x27dd,0x27de,0x27df,
	0x27e0,0x27e1,0x27e2,0x27e3,0x27e4,0x27e5,0x27e6,0x27e7,0x27e8,0x27e9,
	0x27ea,0x27eb,0x27f0,0x27f1,0x27f2,0x27f3,0x27f4,0x27f5,0x27f6,0x27f7,
	0x27f8,0x27f9,0x27fa,0x27fb,0x27fc,0x27fd,0x27fe,0x27ff,0x2900,0x2901,
	0x2902,0x2903,0x2904,0x2905,0x2906,0x2907,0x2908,0x2909,0x290a,0x290b,
	0x290c,0x290d,0x290e,0x290f,0x2910,0x2911,0x2912,0x2913,0x2914,0x2915,
	0x2916,0x2917,0x2918,0x2919,0x291a,0x291b,0x291c,0x291d,0x291e,0x291f,
	0x2920,0x2921,0x2922,0x2923,0x2924,0x2925,0x2926,0x2927,0x2928,0x2929,
	0x292a,0x292b,0x292c,0x292d,0x292e,0x292f,0x2930,0x2931,0x2932,0x2933,
	0x2934,0x2935,0x2936,0x2937,0x2938,0x2939,0x293a,0x293b,0x293c,0x293d,
	0x293e,0x293f,0x2940,0x2941,0x2942,0x2943,0x2944,0x2945,0x2946,0x2947,
	0x2948,0x2949,0x294a,0x294b,0x294c,0x294d,0x294e,0x294f,0x2950,0x2951,
	0x2952,0x2953,0x2954,0x2955,0x2956,0x2957,0x2958,0x2959,0x295a,0x295b,
	0x295c,0x295d,0x295e,0x295f,0x2960,0x2961,0x2962,0x2963,0x2964,0x2965,
	0x2966,0x2967,0x2968,0x2969,0x296a,0x296b,0x296c,0x296d,0x296e,0x296f,
	0x2970,0x2971,0x2972,0x2973,0x2974,0x2975,0x2976,0x2977,0x2978,0x2979,
	0x297a,0x297b,0x297c,0x297d,0x297e,0x297f,0x2980,0x2981,0x2982,0x2983,
	0x2984,0x2985,0x2986,0x2987,0x2988,0x2989,0x298a,0x298b,0x298c,0x298d,
	0x298e,0x298f,0x2990,0x2991,0x2992,0x2993,0x2994,0x2995,0x2996,0x2997,
	0x2998,0x2999,0x299a,0x299b,0x299c,0x299d,0x299e,0x299f,0x29a0,0x29a1,
	0x29a2,0x29a3,0x29a4,0x29a5,0x29a6,0x29a7,0x29a8,0x29a9,0x29aa,0x29ab,
	0x29ac,0x29ad,0x29ae,0x29af,0x29b0,0x29b1,0x29b2,0x29b3,0x29b4,0x29b5,
	0x29b6,0x29b7,0x29b8,0x29b9,0x29ba,0x29bb,0x29bc,0x29bd,0x29be,0x29bf,
	0x29c0,0x29c1,0x29c2,0x29c3,0x29c4,0x29c5,0x29c6,0x29c7,0x29c8,0x29c9,
	0x29ca,0x29cb,0x29cc,0x29cd,0x29ce,0x29cf,0x29d0,0x29d1,0x29d2,0x29d3,
	0x29d4,0x29d5,0x29d6,0x29d7,0x29d8,0x29d9,0x29da,0x29db,0x29dc,0x29dd,
	0x29de,0x29df,0x29e0,0x29e1,0x29e2,0x29e3,0x29e4,0x29e5,0x29e6,0x29e7,
	0x29e8,0x29e9,0x29ea,0x29eb,0x29ec,0x29ed,0x29ee,0x29ef,0x29f0,0x29f1,
	0x29f2,0x29f3,0x29f4,0x29f5,0x29f6,0x29f7,0x29f8,0x29f9,0x29fa,0x29fb,
	0x29fc,0x29fd,0x29fe,0x29ff,0x2a00,0x2a01,0x2a02,0x2a03,0x2a04,0x2a05,
	0x2a06,0x2a07,0x2a08,0x2a09,0x2a0a,0x2a0b,0x2a0c,0x2a0d,0x2a0e,0x2a0f,
	0x2a10,0x2a11,0x2a12,0x2a13,0x2a14,0x2a15,0x2a16,0x2a17,0x2a18,0x2a19,
	0x2a1a,0x2a1b,0x2a1c,0x2a1d,0x2a1e,0x2a1f,0x2a20,0x2a21,0x2a22,0x2a23,
	0x2a24,0x2a25,0x2a26,0x2a27,0x2a28,0x2a29,0x2a2a,0x2a2b,0x2a2c,0x2a2d,
	0x2a2e,0x2a2f,0x2a30,0x2a31,0x2a32,0x2a33,0x2a34,0x2a35,0x2a36,0x2a37,
	0x2a38,0x2a39,0x2a3a,0x2a3b,0x2a3c,0x2a3d,0x2a3e,0x2a3f,0x2a40,0x2a41,
	0x2a42,0x2a43,0x2a44,0x2a45,0x2a46,0x2a47,0x2a48,0x2a49,0x2a4a,0x2a4b,
	0x2a4c,0x2a4d,0x2a4e,0x2a4f,0x2a50,0x2a51,0x2a52,0x2a53,0x2a54,0x2a55,
	0x2a56,0x2a57,0x2a58,0x2a59,0x2a5a,0x2a5b,0x2a5c,0x2a5d,0x2a5e,0x2a5f,
	0x2a60,0x2a61,0x2a62,0x2a63,0x2a64,0x2a65,0x2a66,0x2a67,0x2a68,0x2a69,
	0x2a6a,0x2a6b,0x2a6c,0x2a6d,0x2a6e,0x2a6f,0x2a70,0x2a71,0x2a72,0x2a73,
	0x2a74,0x2a75,0x2a76,0x2a77,0x2a78,0x2a79,0x2a7a,0x2a7b,0x2a7c,0x2a7d,
	0x2a7e,0x2a7f,0x2a80,0x2a81,0x2a82,0x2a83,0x2a84,0x2a85,0x2a86,0x2a87,
	0x2a88,0x2a89,0x2a8a,0x2a8b,0x2a8c,0x2a8d,0x2a8e,0x2a8f,0x2a90,0x2a91,
	0x2a92,0x2a93,0x2a94,0x2a95,0x2a96,0x2a97,0x2a98,0x2a99,0x2a9a,0x2a9b,
	0x2a9c,0x2a9d,0x2a9e,0x2a9f,0x2aa0,0x2aa1,0x2aa2,0x2aa3,0x2aa4,0x2aa5,
	0x2aa6,0x2aa7,0x2aa8,0x2aa9,0x2aaa,0x2aab,0x2aac,0x2aad,0x2aae,0x2aaf,
	0x2ab0,0x2ab1,0x2ab2,0x2ab3,0x2ab4,0x2ab5,0x2ab6,0x2ab7,0x2ab8,0x2ab9,
	0x2aba,0x2abb,0x2abc,0x2abd,0x2abe,0x2abf,0x2ac0,0x2ac1,0x2ac2,0x2ac3,
	0x2ac4,0x2ac5,0x2ac6,0x2ac7,0x2ac8,0x2ac9,0x2aca,0x2acb,0x2acc,0x2acd,
	0x2ace,0x2acf,0x2ad0,0x2ad1,0x2ad2,0x2ad3,0x2ad4,0x2ad5,0x2ad6,0x2ad7,
	0x2ad8,0x2ad9,0x2ada,0x2adb,0x2adc,0x2add,0x2ade,0x2adf,0x2ae0,0x2ae1,
	0x2ae2,0x2ae3,0x2ae4,0x2ae5,0x2ae6,0x2ae7,0x2ae8,0x2ae9,0x2aea,0x2aeb,
	0x2aec,0x2aed,0x2aee,0x2aef,0x2af0,0x2af1,0x2af2,0x2af3,0x2af4,0x2af5,
	0x2af6,0x2af7,0x2af8,0x2af9,0x2afa,0x2afb,0x2afc,0x2afd,0x2afe,0x2aff,
	0x2b00,0x2b01,0x2b02,0x2b03,0x2b04,0x2b05,0x2b06,0x2b07,0x2b08,0x2b09,
	0x2b0a,0x2b0b,0x2b0c,0x2b0d,0x2b0e,0x2b0f,0x2b10,0x2b11,0x2b12,0x2b13,
	0x2b14,0x2b15,0x2b16,0x2b17,0x2b18,0x2b19,0x2b1a,0x2b20,0x2b21,0x2b22,
	0x2b23,0x2ce5,0x2ce6,0x2ce7,0x2ce8,0x2ce9,0x2cea,0x2cf9,0x2cfa,0x2cfb,
	0x2cfc,0x2cfd,0x2cfe,0x2cff,0x2e00,0x2e01,0x2e02,0x2e03,0x2e04,0x2e05,
	0x2e06,0x2e07,0x2e08,0x2e09,0x2e0a,0x2e0b,0x2e0c,0x2e0d,0x2e0e,0x2e0f,
	0x2e10,0x2e11,0x2e12,0x2e13,0x2e14,0x2e15,0x2e16,0x2e17,0x2e1c,0x2e1d,
	0x2e80,0x2e81,0x2e82,0x2e83,0x2e84,0x2e85,0x2e86,0x2e87,0x2e88,0x2e89,
	0x2e8a,0x2e8b,0x2e8c,0x2e8d,0x2e8e,0x2e8f,0x2e90,0x2e91,0x2e92,0x2e93,
	0x2e94,0x2e95,0x2e96,0x2e97,0x2e98,0x2e99,0x2e9b,0x2e9c,0x2e9d,0x2e9e,
	0x2e9f,0x2ea0,0x2ea1,0x2ea2,0x2ea3,0x2ea4,0x2ea5,0x2ea6,0x2ea7,0x2ea8,
	0x2ea9,0x2eaa,0x2eab,0x2eac,0x2ead,0x2eae,0x2eaf,0x2eb0,0x2eb1,0x2eb2,
	0x2eb3,0x2eb4,0x2eb5,0x2eb6,0x2eb7,0x2eb8,0x2eb9,0x2eba,0x2ebb,0x2ebc,
	0x2ebd,0x2ebe,0x2ebf,0x2ec0,0x2ec1,0x2ec2,0x2ec3,0x2ec4,0x2ec5,0x2ec6,
	0x2ec7,0x2ec8,0x2ec9,0x2eca,0x2ecb,0x2ecc,0x2ecd,0x2ece,0x2ecf,0x2ed0,
	0x2ed1,0x2ed2,0x2ed3,0x2ed4,0x2ed5,0x2ed6,0x2ed7,0x2ed8,0x2ed9,0x2eda,
	0x2edb,0x2edc,0x2edd,0x2ede,0x2edf,0x2ee0,0x2ee1,0x2ee2,0x2ee3,0x2ee4,
	0x2ee5,0x2ee6,0x2ee7,0x2ee8,0x2ee9,0x2eea,0x2eeb,0x2eec,0x2eed,0x2eee,
	0x2eef,0x2ef0,0x2ef1,0x2ef2,0x2ef3,0x2f00,0x2f01,0x2f02,0x2f03,0x2f04,
	0x2f05,0x2f06,0x2f07,0x2f08,0x2f09,0x2f0a,0x2f0b,0x2f0c,0x2f0d,0x2f0e,
	0x2f0f,0x2f10,0x2f11,0x2f12,0x2f13,0x2f14,0x2f15,0x2f16,0x2f17,0x2f18,
	0x2f19,0x2f1a,0x2f1b,0x2f1c,0x2f1d,0x2f1e,0x2f1f,0x2f20,0x2f21,0x2f22,
	0x2f23,0x2f24,0x2f25,0x2f26,0x2f27,0x2f28,0x2f29,0x2f2a,0x2f2b,0x2f2c,
	0x2f2d,0x2f2e,0x2f2f,0x2f30,0x2f31,0x2f32,0x2f33,0x2f34,0x2f35,0x2f36,
	0x2f37,0x2f38,0x2f39,0x2f3a,0x2f3b,0x2f3c,0x2f3d,0x2f3e,0x2f3f,0x2f40,
	0x2f41,0x2f42,0x2f43,0x2f44,0x2f45,0x2f46,0x2f47,0x2f48,0x2f49,0x2f4a,
	0x2f4b,0x2f4c,0x2f4d,0x2f4e,0x2f4f,0x2f50,0x2f51,0x2f52,0x2f53,0x2f54,
	0x2f55,0x2f56,0x2f57,0x2f58,0x2f59,0x2f5a,0x2f5b,0x2f5c,0x2f5d,0x2f5e,
	0x2f5f,0x2f60,0x2f61,0x2f62,0x2f63,0x2f64,0x2f65,0x2f66,0x2f67,0x2f68,
	0x2f69,0x2f6a,0x2f6b,0x2f6c,0x2f6d,0x2f6e,0x2f6f,0x2f70,0x2f71,0x2f72,
	0x2f73,0x2f74,0x2f75,0x2f76,0x2f77,0x2f78,0x2f79,0x2f7a,0x2f7b,0x2f7c,
	0x2f7d,0x2f7e,0x2f7f,0x2f80,0x2f81,0x2f82,0x2f83,0x2f84,0x2f85,0x2f86,
	0x2f87,0x2f88,0x2f89,0x2f8a,0x2f8b,0x2f8c,0x2f8d,0x2f8e,0x2f8f,0x2f90,
	0x2f91,0x2f92,0x2f93,0x2f94,0x2f95,0x2f96,0x2f97,0x2f98,0x2f99,0x2f9a,
	0x2f9b,0x2f9c,0x2f9d,0x2f9e,0x2f9f,0x2fa0,0x2fa1,0x2fa2,0x2fa3,0x2fa4,
	0x2fa5,0x2fa6,0x2fa7,0x2fa8,0x2fa9,0x2faa,0x2fab,0x2fac,0x2fad,0x2fae,
	0x2faf,0x2fb0,0x2fb1,0x2fb2,0x2fb3,0x2fb4,0x2fb5,0x2fb6,0x2fb7,0x2fb8,
	0x2fb9,0x2fba,0x2fbb,0x2fbc,0x2fbd,0x2fbe,0x2fbf,0x2fc0,0x2fc1,0x2fc2,
	0x2fc3,0x2fc4,0x2fc5,0x2fc6,0x2fc7,0x2fc8,0x2fc9,0x2fca,0x2fcb,0x2fcc,
	0x2fcd,0x2fce,0x2fcf,0x2fd0,0x2fd1,0x2fd2,0x2fd3,0x2fd4,0x2fd5,0x2ff0,
	0x2ff1,0x2ff2,0x2ff3,0x2ff4,0x2ff5,0x2ff6,0x2ff7,0x2ff8,0x2ff9,0x2ffa,
	0x2ffb,0x3001,0x3002,0x3003,0x3004,0x3008,0x3009,0x300a,0x300b,0x300c,
	0x300d,0x300e,0x300f,0x3010,0x3011,0x3012,0x3013,0x3014,0x3015,0x3016,
	0x3017,0x3018,0x3019,0x301a,0x301b,0x301c,0x301d,0x301e,0x301f,0x3020,
	0x3030,0x3036,0x3037,0x303d,0x303e,0x303f,0x309b,0x309c,0x30a0,0x30fb,
	0x31c0,0x31c1,0x31c2,0x31c3,0x31c4,0x31c5,0x31c6,0x31c7,0x31c8,0x31c9,
	0x31ca,0x31cb,0x31cc,0x31cd,0x31ce,0x31cf,0x321d,0x321e,0x3250,0x3251,
	0x3252,0x3253,0x3254,0x3255,0x3256,0x3257,0x3258,0x3259,0x325a,0x325b,
	0x325c,0x325d,0x325e,0x325f,0x327c,0x327d,0x327e,0x32b1,0x32b2,0x32b3,
	0x32b4,0x32b5,0x32b6,0x32b7,0x32b8,0x32b9,0x32ba,0x32bb,0x32bc,0x32bd,
	0x32be,0x32bf,0x32cc,0x32cd,0x32ce,0x32cf,0x3377,0x3378,0x3379,0x337a,
	0x33de,0x33df,0x33ff,0x4dc0,0x4dc1,0x4dc2,0x4dc3,0x4dc4,0x4dc5,0x4dc6,
	0x4dc7,0x4dc8,0x4dc9,0x4dca,0x4dcb,0x4dcc,0x4dcd,0x4dce,0x4dcf,0x4dd0,
	0x4dd1,0x4dd2,0x4dd3,0x4dd4,0x4dd5,0x4dd6,0x4dd7,0x4dd8,0x4dd9,0x4dda,
	0x4ddb,0x4ddc,0x4ddd,0x4dde,0x4ddf,0x4de0,0x4de1,0x4de2,0x4de3,0x4de4,
	0x4de5,0x4de6,0x4de7,0x4de8,0x4de9,0x4dea,0x4deb,0x4dec,0x4ded,0x4dee,
	0x4def,0x4df0,0x4df1,0x4df2,0x4df3,0x4df4,0x4df5,0x4df6,0x4df7,0x4df8,
	0x4df9,0x4dfa,0x4dfb,0x4dfc,0x4dfd,0x4dfe,0x4dff,0xa490,0xa491,0xa492,
	0xa493,0xa494,0xa495,0xa496,0xa497,0xa498,0xa499,0xa49a,0xa49b,0xa49c,
	0xa49d,0xa49e,0xa49f,0xa4a0,0xa4a1,0xa4a2,0xa4a3,0xa4a4,0xa4a5,0xa4a6,
	0xa4a7,0xa4a8,0xa4a9,0xa4aa,0xa4ab,0xa4ac,0xa4ad,0xa4ae,0xa4af,0xa4b0,
	0xa4b1,0xa4b2,0xa4b3,0xa4b4,0xa4b5,0xa4b6,0xa4b7,0xa4b8,0xa4b9,0xa4ba,
	0xa4bb,0xa4bc,0xa4bd,0xa4be,0xa4bf,0xa4c0,0xa4c1,0xa4c2,0xa4c3,0xa4c4,
	0xa4c5,0xa4c6,0xa700,0xa701,0xa702,0xa703,0xa704,0xa705,0xa706,0xa707,
	0xa708,0xa709,0xa70a,0xa70b,0xa70c,0xa70d,0xa70e,0xa70f,0xa710,0xa711,
	0xa712,0xa713,0xa714,0xa715,0xa716,0xa717,0xa718,0xa719,0xa71a,0xa720,
	0xa721,0xa828,0xa829,0xa82a,0xa82b,0xa874,0xa875,0xa876,0xa877,0xfd3e,
	0xfd3f,0xfdfd,0xfe10,0xfe11,0xfe12,0xfe13,0xfe14,0xfe15,0xfe16,0xfe17,
	0xfe18,0xfe19,0xfe30,0xfe31,0xfe32,0xfe33,0xfe34,0xfe35,0xfe36,0xfe37,
	0xfe38,0xfe39,0xfe3a,0xfe3b,0xfe3c,0xfe3d,0xfe3e,0xfe3f,0xfe40,0xfe41,
	0xfe42,0xfe43,0xfe44,0xfe45,0xfe46,0xfe47,0xfe48,0xfe49,0xfe4a,0xfe4b,
	0xfe4c,0xfe4d,0xfe4e,0xfe4f,0xfe51,0xfe54,0xfe56,0xfe57,0xfe58,0xfe59,
	0xfe5a,0xfe5b,0xfe5c,0xfe5d,0xfe5e,0xfe60,0xfe61,0xfe64,0xfe65,0xfe66,
	0xfe68,0xfe6b,0xff01,0xff02,0xff06,0xff07,0xff08,0xff09,0xff0a,0xff1b,
	0xff1c,0xff1d,0xff1e,0xff1f,0xff20,0xff3b,0xff3c,0xff3d,0xff3e,0xff3f,
	0xff40,0xff5b,0xff5c,0xff5d,0xff5e,0xff5f,0xff60,0xff61,0xff62,0xff63,
	0xff64,0xff65,0xffe2,0xffe3,0xffe4,0xffe8,0xffe9,0xffea,0xffeb,0xffec,
	0xffed,0xffee,0xfff9,0xfffa,0xfffb,0xfffc,0xfffd,0xd800,0xdd01,
	0xd800,0xdd40,0xd800,0xdd41,0xd800,0xdd42,0xd800,0xdd43,0xd800,0xdd44,
	0xd800,0xdd45,0xd800,0xdd46,0xd800,0xdd47,0xd800,0xdd48,0xd800,0xdd49,
	0xd800,0xdd4a,0xd800,0xdd4b,0xd800,0xdd4c,0xd800,0xdd4d,0xd800,0xdd4e,
	0xd800,0xdd4f,0xd800,0xdd50,0xd800,0xdd51,0xd800,0xdd52,0xd800,0xdd53,
	0xd800,0xdd54,0xd800,0xdd55,0xd800,0xdd56,0xd800,0xdd57,0xd800,0xdd58,
	0xd800,0xdd59,0xd800,0xdd5a,0xd800,0xdd5b,0xd800,0xdd5c,0xd800,0xdd5d,
	0xd800,0xdd5e,0xd800,0xdd5f,0xd800,0xdd60,0xd800,0xdd61,0xd800,0xdd62,
	0xd800,0xdd63,0xd800,0xdd64,0xd800,0xdd65,0xd800,0xdd66,0xd800,0xdd67,
	0xd800,0xdd68,0xd800,0xdd69,0xd800,0xdd6a,0xd800,0xdd6b,0xd800,0xdd6c,
	0xd800,0xdd6d,0xd800,0xdd6e,0xd800,0xdd6f,0xd800,0xdd70,0xd800,0xdd71,
	0xd800,0xdd72,0xd800,0xdd73,0xd800,0xdd74,0xd800,0xdd75,0xd800,0xdd76,
	0xd800,0xdd77,0xd800,0xdd78,0xd800,0xdd79,0xd800,0xdd7a,0xd800,0xdd7b,
	0xd800,0xdd7c,0xd800,0xdd7d,0xd800,0xdd7e,0xd800,0xdd7f,0xd800,0xdd80,
	0xd800,0xdd81,0xd800,0xdd82,0xd800,0xdd83,0xd800,0xdd84,0xd800,0xdd85,
	0xd800,0xdd86,0xd800,0xdd87,0xd800,0xdd88,0xd800,0xdd89,0xd800,0xdd8a,
	0xd802,0xdd1f,0xd834,0xde00,0xd834,0xde01,0xd834,0xde02,0xd834,0xde03,
	0xd834,0xde04,0xd834,0xde05,0xd834,0xde06,0xd834,0xde07,0xd834,0xde08,
	0xd834,0xde09,0xd834,0xde0a,0xd834,0xde0b,0xd834,0xde0c,0xd834,0xde0d,
	0xd834,0xde0e,0xd834,0xde0f,0xd834,0xde10,0xd834,0xde11,0xd834,0xde12,
	0xd834,0xde13,0xd834,0xde14,0xd834,0xde15,0xd834,0xde16,0xd834,0xde17,
	0xd834,0xde18,0xd834,0xde19,0xd834,0xde1a,0xd834,0xde1b,0xd834,0xde1c,
	0xd834,0xde1d,0xd834,0xde1e,0xd834,0xde1f,0xd834,0xde20,0xd834,0xde21,
	0xd834,0xde22,0xd834,0xde23,0xd834,0xde24,0xd834,0xde25,0xd834,0xde26,
	0xd834,0xde27,0xd834,0xde28,0xd834,0xde29,0xd834,0xde2a,0xd834,0xde2b,
	0xd834,0xde2c,0xd834,0xde2d,0xd834,0xde2e,0xd834,0xde2f,0xd834,0xde30,
	0xd834,0xde31,0xd834,0xde32,0xd834,0xde33,0xd834,0xde34,0xd834,0xde35,
	0xd834,0xde36,0xd834,0xde37,0xd834,0xde38,0xd834,0xde39,0xd834,0xde3a,
	0xd834,0xde3b,0xd834,0xde3c,0xd834,0xde3d,0xd834,0xde3e,0xd834,0xde3f,
	0xd834,0xde40,0xd834,0xde41,0xd834,0xde45,0xd834,0xdf00,0xd834,0xdf01,
	0xd834,0xdf02,0xd834,0xdf03,0xd834,0xdf04,0xd834,0xdf05,0xd834,0xdf06,
	0xd834,0xdf07,0xd834,0xdf08,0xd834,0xdf09,0xd834,0xdf0a,0xd834,0xdf0b,
	0xd834,0xdf0c,0xd834,0xdf0d,0xd834,0xdf0e,0xd834,0xdf0f,0xd834,0xdf10,
	0xd834,0xdf11,0xd834,0xdf12,0xd834,0xdf13,0xd834,0xdf14,0xd834,0xdf15,
	0xd834,0xdf16,0xd834,0xdf17,0xd834,0xdf18,0xd834,0xdf19,0xd834,0xdf1a,
	0xd834,0xdf1b,0xd834,0xdf1c,0xd834,0xdf1d,0xd834,0xdf1e,0xd834,0xdf1f,
	0xd834,0xdf20,0xd834,0xdf21,0xd834,0xdf22,0xd834,0xdf23,0xd834,0xdf24,
	0xd834,0xdf25,0xd834,0xdf26,0xd834,0xdf27,0xd834,0xdf28,0xd834,0xdf29,
	0xd834,0xdf2a,0xd834,0xdf2b,0xd834,0xdf2c,0xd834,0xdf2d,0xd834,0xdf2e,
	0xd834,0xdf2f,0xd834,0xdf30,0xd834,0xdf31,0xd834,0xdf32,0xd834,0xdf33,
	0xd834,0xdf34,0xd834,0xdf35,0xd834,0xdf36,0xd834,0xdf37,0xd834,0xdf38,
	0xd834,0xdf39,0xd834,0xdf3a,0xd834,0xdf3b,0xd834,0xdf3c,0xd834,0xdf3d,
	0xd834,0xdf3e,0xd834,0xdf3f,0xd834,0xdf40,0xd834,0xdf41,0xd834,0xdf42,
	0xd834,0xdf43,0xd834,0xdf44,0xd834,0xdf45,0xd834,0xdf46,0xd834,0xdf47,
	0xd834,0xdf48,0xd834,0xdf49,0xd834,0xdf4a,0xd834,0xdf4b,0xd834,0xdf4c,
	0xd834,0xdf4d,0xd834,0xdf4e,0xd834,0xdf4f,0xd834,0xdf50,0xd834,0xdf51,
	0xd834,0xdf52,0xd834,0xdf53,0xd834,0xdf54,0xd834,0xdf55,0xd834,0xdf56,
	};
static const TUint KOtherNeutralsLength = 2917 + 462;

//This test data is an extract from the Project Gutenberg version of 
//The War Of The Worlds by H G Wells

static const TUint16 KArab1Data[] = 
	{
	0xfeff, 0x0623, 0x0633, 0x0627, 0x0633, 0x064b, 0x0627, 0x060c,
	0x0020, 0x000d, 0x000a, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x062a, 0x062a, 0x0639, 0x0627, 0x0645, 0x0644, 0x0020,
	0x0627, 0x0644, 0x062d, 0x0648, 0x0627, 0x0633, 0x064a, 0x0628,
	0x0020, 0x0641, 0x0642, 0x0637, 0x0020, 0x0645, 0x0639, 0x0020,
	0x0627, 0x0644, 0x0623, 0x0631, 0x0642, 0x0627, 0x0645, 0x060c,
	0x0020, 0x0648, 0x062a, 0x0642, 0x0648, 0x0645, 0x0020, 0x0628,
	0x062a, 0x062e, 0x0632, 0x064a, 0x0646, 0x0020, 0x0627, 0x0644,
	0x0623, 0x062d, 0x0631, 0x0641, 0x0020, 0x0648, 0x0627, 0x0644,
	0x0645, 0x062d, 0x0627, 0x0631, 0x0641, 0x0020, 0x000d, 0x000a,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0627, 0x0644,
	0x0623, 0x062e, 0x0631, 0x0649, 0x0020, 0x0628, 0x0639, 0x062f,
	0x0020, 0x0623, 0x0646, 0x0020, 0x062a, 0x064f, 0x0639, 0x0637,
	0x064a, 0x0020, 0x0631, 0x0642, 0x0645, 0x0627, 0x0020, 0x0645,
	0x0639, 0x064a, 0x0646, 0x0627, 0x0020, 0x0644, 0x0643, 0x0644,
	0x0020, 0x0648, 0x0627, 0x062d, 0x062f, 0x0020, 0x0645, 0x0646,
	0x0647, 0x0627, 0x002e, 0x0020, 0x0648, 0x0642, 0x0628, 0x0644,
	0x0020, 0x0627, 0x062e, 0x062a, 0x0631, 0x0627, 0x0639, 0x0020,
	0x000d, 0x000a, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0022, 0x064a, 0x0648, 0x0646, 0x0650, 0x0643, 0x0648, 0x062f,
	0x0022, 0x060c, 0x0020, 0x0643, 0x0627, 0x0646, 0x0020, 0x0647,
	0x0646, 0x0627, 0x0643, 0x0020, 0x0645, 0x0626, 0x0627, 0x062a,
	0x0020, 0x0627, 0x0644, 0x0623, 0x0646, 0x0638, 0x0645, 0x0629,
	0x0020, 0x0644, 0x0644, 0x062a, 0x0634, 0x0641, 0x064a, 0x0631,
	0x0020, 0x0648, 0x062a, 0x062e, 0x0635, 0x064a, 0x0635, 0x0020,
	0x0647, 0x0630, 0x0647, 0x0020, 0x0627, 0x0644, 0x0623, 0x0631,
	0x0642, 0x0627, 0x0645, 0x0020, 0x000d, 0x000a, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0644, 0x0644, 0x0645, 0x062d,
	0x0627, 0x0631, 0x0641, 0x060c, 0x0020, 0x0648, 0x0644, 0x0645,
	0x0020, 0x064a, 0x0648, 0x062c, 0x062f, 0x0020, 0x0646, 0x0638,
	0x0627, 0x0645, 0x0020, 0x062a, 0x0634, 0x0641, 0x064a, 0x0631,
	0x0020, 0x0648, 0x0627, 0x062d, 0x062f, 0x0020, 0x064a, 0x062d,
	0x062a, 0x0648, 0x064a, 0x0020, 0x0639, 0x0644, 0x0649, 0x0020,
	0x062c, 0x0645, 0x064a, 0x0639, 0x0020, 0x0627, 0x0644, 0x0645,
	0x062d, 0x0627, 0x0631, 0x0641, 0x0020, 0x0627, 0x0644, 0x0636,
	0x0631, 0x0648, 0x0631, 0x064a, 0x0629, 0x002e, 0x0020, 0x000d,
	0x000a, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0648,
	0x0639, 0x0644, 0x0649, 0x0020, 0x0633, 0x0628, 0x064a, 0x0644,
	0x0020, 0x0627, 0x0644, 0x0645, 0x062b, 0x0627, 0x0644, 0x060c,
	0x0020, 0x0641, 0x0625, 0x0646, 0x0020, 0x0627, 0x0644, 0x0627,
	0x062a, 0x062d, 0x0627, 0x062f, 0x0020, 0x0627, 0x0644, 0x0623,
	0x0648, 0x0631, 0x0648, 0x0628, 0x064a, 0x0020, 0x0644, 0x0648,
	0x062d, 0x062f, 0x0647, 0x060c, 0x0020, 0x0627, 0x062d, 0x062a,
	0x0648, 0x0649, 0x0020, 0x0627, 0x0644, 0x0639, 0x062f, 0x064a,
	0x062f, 0x0020, 0x0645, 0x0646, 0x0020, 0x000d, 0x000a, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0627, 0x0644, 0x0634,
	0x0641, 0x0631, 0x0627, 0x062a, 0x0020, 0x0627, 0x0644, 0x0645,
	0x062e, 0x062a, 0x0644, 0x0641, 0x0629, 0x0020, 0x0644, 0x064a,
	0x063a, 0x0637, 0x064a, 0x0020, 0x062c, 0x0645, 0x064a, 0x0639,
	0x0020, 0x0627, 0x0644, 0x0644, 0x063a, 0x0627, 0x062a, 0x0020,
	0x0627, 0x0644, 0x0645, 0x0633, 0x062a, 0x062e, 0x062f, 0x0645,
	0x0629, 0x0020, 0x0641, 0x064a, 0x0020, 0x0627, 0x0644, 0x0627,
	0x062a, 0x062d, 0x0627, 0x062f, 0x002e, 0x0020, 0x0648, 0x062d,
	0x062a, 0x0649, 0x0020, 0x0644, 0x0648, 0x0020, 0x000d, 0x000a,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0627, 0x0639,
	0x062a, 0x0628, 0x0631, 0x0646, 0x0627, 0x0020, 0x0644, 0x063a,
	0x0629, 0x0020, 0x0648, 0x0627, 0x062d, 0x062f, 0x0629, 0x060c,
	0x0020, 0x0643, 0x0627, 0x0644, 0x0644, 0x063a, 0x0629, 0x0020,
	0x0627, 0x0644, 0x0625, 0x0646, 0x062c, 0x0644, 0x064a, 0x0632,
	0x064a, 0x0629, 0x060c, 0x0020, 0x0641, 0x0625, 0x0646, 0x0020,
	0x062c, 0x062f, 0x0648, 0x0644, 0x0020, 0x0634, 0x0641, 0x0631,
	0x0629, 0x0020, 0x0648, 0x0627, 0x062d, 0x062f, 0x0020, 0x0644,
	0x0645, 0x0020, 0x064a, 0x0643, 0x0641, 0x0020, 0x000d, 0x000a,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0644, 0x0627,
	0x0633, 0x062a, 0x064a, 0x0639, 0x0627, 0x0628, 0x0020, 0x062c,
	0x0645, 0x064a, 0x0639, 0x0020, 0x0627, 0x0644, 0x0623, 0x062d,
	0x0631, 0x0641, 0x0020, 0x0648, 0x0639, 0x0644, 0x0627, 0x0645,
	0x0627, 0x062a, 0x0020, 0x0627, 0x0644, 0x062a, 0x0631, 0x0642,
	0x064a, 0x0645, 0x0020, 0x0648, 0x0627, 0x0644, 0x0631, 0x0645,
	0x0648, 0x0632, 0x0020, 0x0627, 0x0644, 0x0641, 0x0646, 0x064a,
	0x0629, 0x0020, 0x0648, 0x0627, 0x0644, 0x0639, 0x0644, 0x0645,
	0x064a, 0x0629, 0x0020, 0x000d, 0x000a, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
	0x0020, 0x0020, 0x0020, 0x0627, 0x0644, 0x0634, 0x0627, 0x0626,
	0x0639, 0x0629, 0x0020, 0x0627, 0x0644, 0x0627, 0x0633, 0x062a,
	0x0639, 0x0645, 0x0627
	};

static const TInt KArab1Length = sizeof(KArab1Data)/sizeof(TUint16);

static const TPtrC KArab1(KArab1Data, KArab1Length);

//Test data for Arabic Illegal Linebreaking

static const TUint16 KArabicDualJoiningLettersData[] = 
	{
	0x0626, 0x0628, 0x062a, 0x062b, 0x062c, 0x062e, 0x0633, 0x0634, 0x0637, 0x0638, 0x0639, 0x063a,
	0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0647, 0x0648, 0x0649, 0x064a, 0x0678, 0x0679, 0x067a, 
	0x067b, 0x067c, 0x067d, 0x067e, 0x067f, 0x0680, 0x0681, 0x0682, 0x0683, 0x0684, 0x0685, 0x0686,
	0x0687, 0x069a, 0x069b, 0x069c, 0x069d, 0x069e, 0x069f, 0x06a0, 0x06a1, 0x06a2, 0x06a3, 0x06a4,
	0x06a5, 0x06a6, 0x06a7, 0x06a9, 0x06aa, 0x06ab, 0x06ac, 0x06ad, 0x06ae, 0x06af, 0x06b0, 0x06b1,
	0x06b2, 0x06b3, 0x06b4, 0x06b5, 0x06b6, 0x06b7, 0x06b8, 0x06b9, 0x06ba, 0x06bb, 0x06bc, 0x06bd,
	0x06be, 0x06bf, 0x06c1, 0x06cc, 0x06ce, 0x06d0, 0x06d1, 0x06fa, 0x06fb, 0x06fc
	};

static const TInt KArabicDualJoiningLettersLength = sizeof(KArabicDualJoiningLettersData)/sizeof(TUint16);

static const TPtrC KArabicDualJoiningLetters(KArabicDualJoiningLettersData, KArabicDualJoiningLettersLength);

static const TUint16 KArabicRightJoiningLettersData[] = 
	{
	0x0622, 0x0623, 0x0624, 0x0625, 0x0627, 0x0629, 0x062f, 0x0630, 0x0631, 0x0632, 0x0648, 0x0671,
	0x0672, 0x0673, 0x0675, 0x0676, 0x0677, 0x0688, 0x0689, 0x068a, 0x068b, 0x068c, 0x068d, 0x068e,
	0x068f, 0x0690, 0x0691, 0x0692, 0x0693, 0x0694, 0x0695, 0x0696, 0x0697, 0x0698, 0x0699, 0x06c0,
	0x06c2, 0x06c3, 0x06c4, 0x06c5, 0x06c6, 0x06c7, 0x06c8, 0x06c9, 0x06ca, 0x06cb, 0x06cd, 0x06cf,
	0x06d2, 0x06d3
	};

static const TInt KArabicRightJoiningLettersLength = sizeof(KArabicRightJoiningLettersData)/sizeof(TUint16);

static const TPtrC KArabicRightJoiningLetters(KArabicRightJoiningLettersData, KArabicRightJoiningLettersLength);

static const TUint16 KArabicNonJoiningLettersData[] = 
	{
	0x0640, 0x0674, 0x06D5
	};

static const TInt KArabicNonJoiningLettersLength = sizeof(KArabicNonJoiningLettersData)/sizeof(TUint16);

static const TPtrC KArabicNonJoiningLetters(KArabicNonJoiningLettersData, KArabicNonJoiningLettersLength);

static const TUint16 KAlefJoiningGroupData[] = 
	{
	0x0622, 0x0623, 0x0625, 0x0671, 0x0672, 0x0673, 0x0675
	};

static const TInt KAlefJoiningGroupLength = sizeof(KAlefJoiningGroupData)/sizeof(TUint16);

static const TPtrC KAlefJoiningGroup(KAlefJoiningGroupData, KAlefJoiningGroupLength);

static const TUint16 KWawJoiningGroupData[] = 
	{
	0x0624, 0x0648, 0x0676, 0x0677, 0x06c4, 0x06c5, 0x06c6, 0x06c7, 0x06c8, 0x06c9, 0x06ca, 0x06cb,
	0x06cf
	};

static const TInt KWawJoiningGroupLength = sizeof(KWawJoiningGroupData)/sizeof(TUint16);

static const TPtrC KWawJoiningGroup(KWawJoiningGroupData, KWawJoiningGroupLength);


static const TUint16 KYehJoiningGroupData[] = 
	{
	0x0626, 0x0649, 0x064a, 0x0678, 0x06cc, 0x06ce, 0x06d0, 0x06d1
	};


static const TInt KYehJoiningGroupLength = sizeof(KYehJoiningGroupData)/sizeof(TUint16);

static const TPtrC KYehJoiningGroup(KYehJoiningGroupData, KYehJoiningGroupLength);

static const TUint16 KBehJoiningGroupData[] = 
	{
	0x0628, 0x062a, 0x062b, 0x0679, 0x067a, 0x067b, 0x067c, 0x067d, 0x067e, 0x067f, 0x0680 
	};

static const TInt KBehJoiningGroupLength = sizeof(KBehJoiningGroupData)/sizeof(TUint16);

static const TPtrC KBehJoiningGroup(KBehJoiningGroupData, KBehJoiningGroupLength);

static const TUint16 KTehMarbutaJoiningGroupData[] = 
	{
	0x0629, 0x06c0
	};

static const TInt KTehMarbutaJoiningGroupLength = sizeof(KTehMarbutaJoiningGroupData)/sizeof(TUint16);

static const TPtrC KTehMarbutaJoiningGroup(KTehMarbutaJoiningGroupData, KTehMarbutaJoiningGroupLength);

static const TUint16 KHahJoiningGroupData[] = 
	{
	0x062c, 0x062d, 0x062e, 0x0681, 0x0682, 0x0683, 0x0684, 0x0685, 0x0686, 0x0687
	};

static const TInt KHahJoiningGroupLength = sizeof(KHahJoiningGroupData)/sizeof(TUint16);

static const TPtrC KHahJoiningGroup(KHahJoiningGroupData, KHahJoiningGroupLength);

static const TUint16 KDalJoiningGroupData[] = 
	{
	0x062f, 0x0688, 0x0689, 0x068a, 0x068b, 0x068c, 0x068d, 0x068e, 0x068f, 0x0690
	};

static const TInt KDalJoiningGroupLength = sizeof(KDalJoiningGroupData)/sizeof(TUint16);

static const TPtrC KDalJoiningGroup(KDalJoiningGroupData, KDalJoiningGroupLength);


static const TUint16 KRehJoiningGroupData[] = 
	{
	0x0631, 0x0632, 0x0691, 0x0692, 0x0693, 0x0694, 0x0695, 0x0696, 0x0697, 0x0698, 0x0699
	};

static const TInt KRehJoiningGroupLength = sizeof(KRehJoiningGroupData)/sizeof(TUint16);

static const TPtrC KRehJoiningGroup(KRehJoiningGroupData, KRehJoiningGroupLength);

static const TUint16 KSeenJoiningGroupData[] = 
	{
	0x0633, 0x0634, 0x069a, 0x069b, 0x069c, 0x06fa
	};

static const TInt KSeenJoiningGroupLength = sizeof(KSeenJoiningGroupData)/sizeof(TUint16);

static const TPtrC KSeenJoiningGroup(KSeenJoiningGroupData, KSeenJoiningGroupLength);

static const TUint16 KSadJoiningGroupData[] = 
	{
	0x0635, 0x0636, 0x069d, 0x069e, 0x06fb
	};

static const TInt KSadJoiningGroupLength = sizeof(KSadJoiningGroupData)/sizeof(TUint16);

static const TPtrC KSadJoiningGroup(KSadJoiningGroupData, KSadJoiningGroupLength);

static const TUint16 KTahJoiningGroupData[] = 
	{
	0x0637, 0x0638, 0x069f
	};

static const TInt KTahJoiningGroupLength = sizeof(KTahJoiningGroupData)/sizeof(TUint16);

static const TPtrC KTahJoiningGroup(KTahJoiningGroupData, KTahJoiningGroupLength);

static const TUint16 KAinJoiningGroupData[] = 
	{
	0x0639, 0x063a, 0x6a0, 0x06fc
	};

static const TInt KAinJoiningGroupLength = sizeof(KAinJoiningGroupData)/sizeof(TUint16);

static const TPtrC KAinJoiningGroup(KAinJoiningGroupData, KAinJoiningGroupLength);

static const TUint16 KFehJoiningGroupData[] = 
	{
	0x0641, 0x06a1, 0x06a2, 0x06a3, 0x06a4, 0x06a5, 0x06a6
	};


static const TInt KFehJoiningGroupLength = sizeof(KFehJoiningGroupData)/sizeof(TUint16);

static const TPtrC KFehJoiningGroup(KFehJoiningGroupData, KFehJoiningGroupLength);

static const TUint16 KQafJoiningGroupData[] = 
	{
	0x0642, 0x06a7, 0x06a8
	};

static const TInt KQafJoiningGroupLength = sizeof(KQafJoiningGroupData)/sizeof(TUint16);

static const TPtrC KQafJoiningGroup(KQafJoiningGroupData, KQafJoiningGroupLength);

static const TUint16 KKafJoiningGroupData[] = 
	{
	0x0643, 0x06aa, 0x06ac, 0x06ad, 0x06ae
	};

static const TInt KKafJoiningGroupLength = sizeof(KKafJoiningGroupData)/sizeof(TUint16);

static const TPtrC KKafJoiningGroup(KKafJoiningGroupData, KKafJoiningGroupLength);

static const TUint16 KLamJoiningGroupData[] = 
	{
	0x0644, 0x06b5, 0x06b6, 0x06b7, 0x06b8
	};

static const TInt KLamJoiningGroupLength = sizeof(KLamJoiningGroupData)/sizeof(TUint16);

static const TPtrC KLamJoiningGroup(KLamJoiningGroupData, KLamJoiningGroupLength);

static const TUint16 KMeemJoiningGroupData[] = 
	{
	0x0645
	};

static const TInt KMeemJoiningGroupLength = sizeof(KMeemJoiningGroupData)/sizeof(TUint16);

static const TPtrC KMeemJoiningGroup(KMeemJoiningGroupData, KMeemJoiningGroupLength);

static const TUint16 KNoonJoiningGroupData[] = 
	{
	0x0646, 0x06b9, 0x06ba, 0x06bb, 0x06bc, 0x06bd
	};

static const TInt KNoonJoiningGroupLength = sizeof(KNoonJoiningGroupData)/sizeof(TUint16);

static const TPtrC KNoonJoiningGroup(KNoonJoiningGroupData, KNoonJoiningGroupLength);

static const TUint16 KHehJoiningGroupData[] = 
	{
	0x0647
	};

static const TInt KHehJoiningGroupLength = sizeof(KHehJoiningGroupData)/sizeof(TUint16);

static const TPtrC KHehJoiningGroup(KHehJoiningGroupData, KHehJoiningGroupLength);

static const TUint16 KGafJoiningGroupData[] = 
	{
	0x06a9, 0x06ab, 0x06af, 0x06b0, 0x06b1, 0x06b2, 0x06b3, 0x06b4 
	};

static const TInt KGafJoiningGroupLength = sizeof(KGafJoiningGroupData)/sizeof(TUint16);

static const TPtrC KGafJoiningGroup(KGafJoiningGroupData, KGafJoiningGroupLength);

static const TUint16 KKnottedHehJoiningGroupData[] = 
	{
	0x06be
	};

static const TInt KKnottedHehJoiningGroupLength = sizeof(KKnottedHehJoiningGroupData)/sizeof(TUint16);

static const TPtrC KKnottedHehJoiningGroup(KKnottedHehJoiningGroupData, KKnottedHehJoiningGroupLength);

static const TUint16 KHehGoalJoiningGroupData[] = 
	{
	0x06c1
	};

static const TInt KHehGoalJoiningGroupLength = sizeof(KHehGoalJoiningGroupData)/sizeof(TUint16);

static const TPtrC KHehGoalJoiningGroup(KHehGoalJoiningGroupData, KHehGoalJoiningGroupLength);

static const TUint16 KHamzaOnHehGoalJoiningGroupData[] = 
	{
	0x06c2, 0x06c3
	};

static const TInt KHamzaOnHehGoalJoiningGroupLength = sizeof(KHamzaOnHehGoalJoiningGroupData)/sizeof(TUint16);

static const TPtrC KHamzaOnHehGoalJoiningGroup(KHamzaOnHehGoalJoiningGroupData, KHamzaOnHehGoalJoiningGroupLength);

static const TUint16 KYehWithTailJoiningGroupData[] = 
	{
	0x06cd
	};

static const TInt KYehWithTailJoiningGroupLength = sizeof(KYehWithTailJoiningGroupData)/sizeof(TUint16);

static const TPtrC KYehWithTailJoiningGroup(KYehWithTailJoiningGroupData, KYehWithTailJoiningGroupLength);

static const TUint16 KYehBarreeJoiningGroupData[] = 
	{
	0x06d2, 0x06d3
	};

static const TInt KYehBarreeJoiningGroupLength = sizeof(KYehBarreeJoiningGroupData)/sizeof(TUint16);

static const TPtrC KYehBarreeJoiningGroup(KYehBarreeJoiningGroupData, KYehBarreeJoiningGroupLength);

enum JoiningGroupType
	{
	EAlefJoiningGroup,
	EWawJoiningGroup,
	EYehJoiningGroup,
	EBehJoiningGroup,
	ETehMarbutaJoiningGroup,
	EHahJoiningGroup,
	EDalJoiningGroup,
	ERehJoiningGroup,
	ESeenJoiningGroup,
	ESadJoiningGroup,
	ETahJoiningGroup,
	EAinJoiningGroup,
	EFehJoiningGroup,
	EQafJoiningGroup,
	EKafJoiningGroup,
	ELamJoiningGroup,
	EMeemJoiningGroup,
	ENoonJoiningGroup,
	EHehJoiningGroup,
	EGafJoiningGroup,
	EKnottedHehJoiningGroup,
	EHehGoalJoiningGroup,
	EHamzaOnHehGoalJoiningGroup,
	EYehWithTailJoiningGroup,
	EYehBarreeJoiningGroup
	};

struct JoiningGroupListData 
	{
	TInt iGroupType;
	const TPtrC* iGroup;
	};

// Structure to hold basic shape glyph values

struct ArabicLetterShapes
	{
	TUint16 iCode;	//base Unicode value for character
	TUint16 iIsolated;
	TUint16 iFinal;
	TUint16 iInitial;
	TUint16 iMedial;
	};

static const ArabicLetterShapes KArabicShapeList[] =
	{
	{ 0x0622, 0xfe81, 0xfe82, 0x0622, 0x0622 },
	{ 0x0623, 0xfe83, 0xfe84, 0x0623, 0x0623 },
	{ 0x0624, 0xfe85, 0xfe86, 0x0624, 0x0624 },
	{ 0x0625, 0xfe87, 0xfe88, 0x0625, 0x0625 },
	{ 0x0626, 0xfe89, 0xfe8a, 0xfe8b, 0xfe8c },
	{ 0x0627, 0xfe8d, 0xfe8e, 0x0627, 0x0627 },
	{ 0x0628, 0xfe8f, 0xfe90, 0xfe91, 0xfe92 },
	{ 0x0629, 0xfe93, 0xfe94, 0x0629, 0x0629 },
	{ 0x062a, 0xfe95, 0xfe96, 0xfe97, 0xfe98 },
	{ 0x062b, 0xfe99, 0xfe9a, 0xfe9b, 0xfe9c },
	{ 0x062c, 0xfe9d, 0xfe9e, 0xfe9f, 0xfea0 },
	{ 0x062d, 0xfea1, 0xfea2, 0xfea3, 0xfea4 },
	{ 0x062e, 0xfea5, 0xfea6, 0xfea7, 0xfea8 },
	{ 0x062f, 0xfea9, 0xfeaa, 0x062f, 0x062f },
	{ 0x0630, 0xfeab, 0xfeac, 0x0630, 0x0630 },
	{ 0x0631, 0xfead, 0xfeae, 0x0631, 0x0631 },
	{ 0x0632, 0xfeaf, 0xfeb0, 0x0632, 0x0632 },
	{ 0x0633, 0xfeb1, 0xfeb2, 0xfeb3, 0xfeb4 },
	{ 0x0634, 0xfeb5, 0xfeb6, 0xfeb7, 0xfeb8 },
	{ 0x0635, 0xfeb9, 0xfeba, 0xfebb, 0xfebc },
	{ 0x0636, 0xfebd, 0xfebe, 0xfebf, 0xfec0 },
	{ 0x0637, 0xfec1, 0xfec2, 0xfec3, 0xfec4 },
	{ 0x0638, 0xfec5, 0xfec6, 0xfec7, 0xfec8 },
	{ 0x0639, 0xfec9, 0xfeca, 0xfecb, 0xfecc },
	{ 0x063a, 0xfecd, 0xfece, 0xfecf, 0xfed0 },
	{ 0x0641, 0xfed1, 0xfed2, 0xfed3, 0xfed4 },
	{ 0x0642, 0xfed5, 0xfed6, 0xfed7, 0xfed8 },
	{ 0x0643, 0xfed9, 0xfeda, 0xfedb, 0xfedc },
	{ 0x0644, 0xfedd, 0xfede, 0xfedf, 0xfee0 },
	{ 0x0645, 0xfee1, 0xfee2, 0xfee3, 0xfee4 },
	{ 0x0646, 0xfee5, 0xfee6, 0xfee7, 0xfee8 },
	{ 0x0647, 0xfee9, 0xfeea, 0xfeeb, 0xfeec },
	{ 0x0648, 0xfeed, 0xfeee, 0x0648, 0x0648 },
	{ 0x0649, 0xfeef, 0xfef0, 0xfbe8, 0xfbe9 },
	{ 0x064a, 0xfef1, 0xfef2, 0xfef3, 0xfef4 },
	{ 0x0671, 0xfb50, 0xfb51, 0x0671, 0x0671 },
	{ 0x0677, 0xfbdd, 0x0677, 0x0677, 0x0677 },
	{ 0x0679, 0xfb66, 0xfb67, 0xfb68, 0xfb69 },
	{ 0x067a, 0xfb5e, 0xfb5f, 0xfb60, 0xfb61 },
	{ 0x067b, 0xfb52, 0xfb53, 0xfb54, 0xfb55 },
	{ 0x067e, 0xfb56, 0xfb57, 0xfb58, 0xfb59 },
	{ 0x067f, 0xfb62, 0xfb63, 0xfb64, 0xfb65 },
	{ 0x0680, 0xfb5a, 0xfb5b, 0xfb5c, 0xfb5d },
	{ 0x0683, 0xfb76, 0xfb77, 0xfb78, 0xfb79 },
	{ 0x0684, 0xfb72, 0xfb73, 0xfb74, 0xfb75 },
	{ 0x0686, 0xfb7a, 0xfb7b, 0xfb7c, 0xfb7d },
	{ 0x0687, 0xfb7e, 0xfb7f, 0xfb80, 0xfb81 },
	{ 0x0688, 0xfb88, 0xfb89, 0x0688, 0x0688 },
	{ 0x068c, 0xfb84, 0xfb85, 0x068c, 0x068c },
	{ 0x068d, 0xfb82, 0xfb83, 0x068d, 0x068d },
	{ 0x068e, 0xfb86, 0xfb87, 0x068e, 0x068e },
	{ 0x0691, 0xfb8c, 0xfb8d, 0x0691, 0x0691 },
	{ 0x0698, 0xfb8a, 0xfb8b, 0x0698, 0x0698 },
	{ 0x06a4, 0xfb6a, 0xfb6b, 0xfb6c, 0xfb6d },
	{ 0x06a6, 0xfb6e, 0xfb6f, 0xfb70, 0xfb71 },
	{ 0x06a9, 0xfb8e, 0xfb8f, 0xfb90, 0xfb91 },
	{ 0x06ad, 0xfbd3, 0xfbd4, 0xfbd5, 0xfbd6 },
	{ 0x06af, 0xfb92, 0xfb93, 0xfb94, 0xfb95 },
	{ 0x06b1, 0xfb9a, 0xfb9b, 0xfb9c, 0xfb9d },
	{ 0x06b3, 0xfb96, 0xfb97, 0xfb98, 0xfb99 },
	{ 0x06ba, 0xfb9e, 0xfb9f, 0x06ba, 0x06ba },
	{ 0x06bb, 0xfba0, 0xfba1, 0xfba2, 0xfba3 },
	{ 0x06be, 0xfbaa, 0xfbab, 0xfbac, 0xfbad },
	{ 0x06c0, 0xfba4, 0xfba5, 0x06c0, 0x06c0 },
	{ 0x06c1, 0xfba6, 0xfba7, 0xfba8, 0xfba9 },
	{ 0x06c5, 0xfbe0, 0xfbe1, 0x06c5, 0x06c5 },
	{ 0x06c6, 0xfbd9, 0xfbda, 0x06c6, 0x06c6 },
	{ 0x06c7, 0xfbd7, 0xfbd8, 0x06c7, 0x06c7 },
	{ 0x06c8, 0xfbdb, 0xfbdc, 0x06c8, 0x06c8 },
	{ 0x06c9, 0xfbe2, 0xfbe3, 0x06c9, 0x06c9 },
	{ 0x06cb, 0xfbde, 0xfbdf, 0x06cb, 0x06cb },
	{ 0x06cc, 0xfbfc, 0xfbfd, 0xfbfe, 0xfbff },
	{ 0x06d0, 0xfbe4, 0xfbe5, 0xfbe6, 0xfbe7 },
	{ 0x06d2, 0xfbae, 0xfbaf, 0x06d2, 0x06d2 },
	{ 0x06d3, 0xfbb0, 0xfbb1, 0x06d3, 0x06d3 }
	};

static const TInt KArabicShapeListLength = sizeof(KArabicShapeList) / sizeof (ArabicLetterShapes);

LOCAL_C TInt GetArabicShapeDataIndex(const TUint16 aCode )
	{
	for (TInt i = 0 ; i < KArabicShapeListLength ; ++i)
		{
		if (aCode == KArabicShapeList[i].iCode)
			{
			return i;
			}
		}
	return -1;//not found
	}

#ifdef USE_ISOLATED
LOCAL_C TUint16 GetIsolatedForm(const TUint16 aCode)
	{
	TInt index = GetArabicShapeDataIndex(aCode);
	return (index >= 0) ? KArabicShapeList[index].iIsolated : aCode;
	}
#endif /* USE_ISOLATED */

LOCAL_C TUint16 GetFinalForm(const TUint16 aCode)
	{
	TInt index = GetArabicShapeDataIndex(aCode);
	return (index >= 0) ? KArabicShapeList[index].iFinal : aCode;
	}

LOCAL_C TUint16 GetInitialForm(const TUint16 aCode)
	{
	TInt index = GetArabicShapeDataIndex(aCode);
	return (index >= 0) ? KArabicShapeList[index].iInitial : aCode;
	}

LOCAL_C TUint16 GetMedialForm(const TUint16 aCode)
	{
	TInt index = GetArabicShapeDataIndex(aCode);
	return (index >= 0) ? KArabicShapeList[index].iMedial : aCode;
	}

// Utility functions to show contents of test data using aTest->INFO_PRINTF1

_LIT(KAddressMarker, "> ");
_LIT(KSpace, " ");
_LIT(KLength, ", Length of Data = %d 16-bit words\r\n");
_LIT(KSpaces, "                                                                      ");
_LIT(KPeriod, ".");
_LIT(KSingleString, "%s\r\n");
_LIT(KDoubleString, "%s <%s>\r\n");



class MOOMTest
	{
public:
	virtual TInt ConsecutivePassesRequired() const { return 1; }
	virtual void SetUpL() = 0;
	virtual void ManipulateL() = 0;
	virtual void TestLeftCleanlyL(CTGraphicsBase* /*aTest*/) {};
	virtual void TestIfPassedL(CTGraphicsBase* /*aTest*/) {};
	virtual void TearDown() = 0;
	};

// Test the internals of the algorithm for Unicode compliance.
class TBdLevelTest
	{
public:
	TChar::TBdCategory iCat;
	TInt iLevel;	// or -1 for "no test"
	TChar::TBdCategory iChangedCat;
	};

class CTBiDi : public CTGraphicsBase
	{
public:
	CTBiDi(CTestStep* aStep);

	void DoTestTextDrawPanic();
	TInt DoTestPanicSetTextL();
	TInt DoTestPanicMinimumSizeLineGap();
	TInt DoTestPanicMinimumSizeMaxLines();
	TInt DoTestPanicMinimumSizeWidth();
	TInt DoTestPanicMinimumNumberOfLinesL();
	static void FillRunArray(const TBdLevelTest* aTests, TBidirectionalState::TRunInfo* aRuns, TInt aArraySize, TBidirectionalState::TReorderContext& aContext);
	static void SetContext(TBidirectionalState::TReorderContext& aContext, TChar::TBdCategory aCat);
protected:
//from 	CTGraphicsStep
	virtual void RunTestCaseL(TInt aCurTestCase);
private:
	void PrintTestData (const TDesC& aTitle , const TDesC16& aData);
	void PrintTestData(const TDesC& aTitle, const TText16* aDataBuffer, const TInt aSize);
	void TestReorderTextL();
	void TestOOML(MOOMTest& aOOMTest);
	void PrintRunCategories(const TBidirectionalState::TRunInfo* aRunArray, const TInt aRuns, const TText* aText, const TBool aInternal);
	void PrintRunArray(const TBidirectionalState::TRunInfo* aRunArray, const TInt aRuns, const TText*  aText);
	void DoTestRRunInfoArrayInternalsL();
	void DoTestTBidiTextNewL();
	void DoTestTBidiTextSetTextL();
	void DoTestTBidiTextMinimumSizeL();
	void DoTestTBidiTextMinimumSizePanics();
	void TestCrApos69qd7nL();
	void TUnicodeExampleTestL();
	void NoLineBreakDrawTestL();
	void RightToLeftArabicDrawTestL();
	void TRunInfoCompactReorderTest();
	void TBidiLogicalToVisualGetVisualLineTest();
	void TestScriptDirectionality();
	void LeftToRightDrawTestL();
	TBool GlyphTestL(const TDesC16& aTitle, const TDesC16& aOriginal, const TDesC16& aDesired, const TInt aWrapWidth);
	void LigatureTestsL();
	void ArabicIllegalLinebreakTestsL();
	TInt TestPanic(TThreadFunction aFunction);
	void DEF043323L();
	void DEF052191L();
	void TestBidiTextClassL();
	void TestBidiLogicalToVisualClassL();
	void TestCatToNumber(TInt aIn, TInt aOut);
	void CheckRunResults(const TBdLevelTest* aTests, TBidirectionalState::TRunInfo* aRuns,
		TInt aArraySize);
	void TestTBidirectionalStateInternalsL();
	void DoXTests(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns);
	void DoKW123TestsLeft(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns) ;
	void DoKW123TestsRight(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns);
	void DoKW456Tests(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns);
	void DoKW7TestsLeft(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns);
	void DoKW7TestsRight(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns) ;
	void DoKN12TestsLeft(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns) ;
	void DoKN12TestsRight(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns) ;
	void DoKN12TestsRRL(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns) ;
	void DoKN12TestsLRR(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns) ;
	void DoKN12TestsLRP(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns) ;
	void DoKN12TestsRLP(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns) ;
	void DoCarryOverTest1(TBidirectionalState& aState,
		TBidirectionalState::TReorderContext& aContext,
		TBidirectionalState::TRunInfo* aRuns);
	void INC086135TestL();
	
	TInt iTestThreadCounter;
	};

void CTBiDi::PrintTestData (const TDesC& aTitle , const TDesC16& aData)
	{
	TInt i;
	TInt j;
	TInt end;

	TInt length = aData.Length();

	TBuf<80> buffer;

	buffer.Zero();
	buffer.Append(aTitle);
	buffer.Append(KLength);

	INFO_PRINTF2(buffer, length);

	for (i = 0 ; i < length ; i += 8)
		{
		buffer.Zero();
		buffer.AppendNumFixedWidth(i, EHex, 8);
		buffer += KAddressMarker;

		end = ((length-i) >= 8) ? i+8 : length;

		for (j = i ; j < end ; ++j)
			{
			buffer.AppendNumFixedWidth(aData[j], EHex, 4);
			buffer += KSpace;
			}
		buffer += TPtrC(KSpaces().Ptr(), ((8-(j-i))*5)+4);

		for (j = i ; j < end ; ++j)
			{
			if (aData[j] >= 32) 
				{
				buffer.Append(aData[j]);
				}
			else
				{
				buffer += KPeriod;
				}
			}
		buffer.ZeroTerminate();
		INFO_PRINTF2(KSingleString, buffer.Ptr());
		}
			
	}

void CTBiDi::PrintTestData(const TDesC& aTitle, const TText16* aDataBuffer, const TInt aSize)
	{
	PrintTestData(aTitle, TPtrC16(aDataBuffer, aSize));
	}

_LIT(KArabicFontName, ""); //any name will do

//This replicates the definition in TBidirectionalState
//because TCategory is declared as private there 
enum TCategory
	{
	ELeftToRight = 1 << TChar::ELeftToRight, 
	ELeftToRightEmbedding = 1 << TChar::ELeftToRightEmbedding,
	ELeftToRightOverride = 1 << TChar::ELeftToRightOverride,
	ERightToLeft = 1 << TChar::ERightToLeft,
	ERightToLeftArabic = 1 << TChar::ERightToLeftArabic,
	ERightToLeftEmbedding = 1 << TChar::ERightToLeftEmbedding, 
	ERightToLeftOverride = 1 << TChar::ERightToLeftOverride,
	EPopDirectionalFormat = 1 << TChar::EPopDirectionalFormat, 
	EEuropeanNumber = 1 << TChar::EEuropeanNumber, 
	EEuropeanNumberSeparator = 1 << TChar::EEuropeanNumberSeparator, 
	EEuropeanNumberTerminator = 1 << TChar::EEuropeanNumberTerminator, 
	EArabicNumber = 1 << TChar::EArabicNumber,
	ECommonNumberSeparator = 1 << TChar::ECommonNumberSeparator, 
	ENonSpacingMark = 1 << TChar::ENonSpacingMark, 
	EBoundaryNeutral = 1 << TChar::EBoundaryNeutral, 
	EParagraphSeparator = 1 << TChar::EParagraphSeparator, 
	ESegmentSeparator = 1 << TChar::ESegmentSeparator, 
	EWhitespace = 1 << TChar::EWhitespace, 
	EOtherNeutral = 1 << TChar::EOtherNeutral,

	// categories used internally by the bidirectional algorithm
	EStartOfParagraph = 1 << (TChar::EOtherNeutral + 1),
	EEndOfParagraph = 1 << (TChar::EOtherNeutral + 2),

	// useful groups
	EBdControlsGroup = ELeftToRightEmbedding | ERightToLeftEmbedding |
					   ELeftToRightOverride | ERightToLeftOverride | EPopDirectionalFormat,
	ELeftToRightGroup = ELeftToRight | EEuropeanNumber | ELeftToRightOverride | ELeftToRightEmbedding,
	ERightToLeftGroup = ERightToLeft | EArabicNumber | ERightToLeftArabic | ERightToLeftOverride |
						ERightToLeftEmbedding,
	};

// Helper function
void AppendCharacter(HBufC *aDes, TUint aChar)
	{
	if (IsSupplementary(aChar))
		{
		TText16 high = GetHighSurrogate(aChar);
		TText16 low = GetLowSurrogate(aChar);
		aDes->Des().Append(high);
		aDes->Des().Append(low);
		}
	else
		{
		aDes->Des().Append(aChar);
		}
	}

void AppendCharacter(TBuf<24> *aDes, TUint aChar)
	{
	if (IsSupplementary(aChar))
		{
		TText16 high = GetHighSurrogate(aChar);
		TText16 low = GetLowSurrogate(aChar);
		aDes->Append(high);
		aDes->Append(low);
		}
	else
		{
		aDes->Append(aChar);
		}
	}

//Class to store the start and end of a run of characters
class TTestDataRun
	{
public:
	TInt iStart;
	TInt iLength;
	};


class TestTBidirectionalState
	{
public:
	enum 
		{
		EParaLToR = EFalse,
		EParaRToL = ETrue
		};

/**
 *
 * Checks that two blocks of 16-bit text contain the same characters in the same order
 * NOT a collating function!.
 *
 *
 * @param     "const TText* aOldText"
 *            Pointer to block of text
 * @param     "const TText* aNewText"
 *            Pointer to block of text. 
 *			  This may point to the same buffer as oldText.
 * @param     "const TUint aSize"
 *            Unsigned integer representing size of text blocks.
 *
 * @return    ETrue: test succeeded EFalse: test failed.
 *
 */
	static TBool TextInSameOrder (const TText* aOldText , const TText* aNewText, const TUint aSize)
		{

		__ASSERT_ALWAYS(aOldText, User::Invariant());
		__ASSERT_ALWAYS(aNewText, User::Invariant());
		__ASSERT_ALWAYS(0 < aSize, User::Invariant());

		if (aOldText == aNewText)
			{
			//By definition, if both point to the same buffer, it's identical!
			return ETrue;
			}

		for (TUint i = 0 ; i < aSize ; ++i)
			{
			if (aOldText[i] != aNewText[i])
				{
				return EFalse;
				}
			}

		return ETrue;
		}

/**
 *
 * Checks that two blocks of 16-bit text contain the same characters but in reverse order
 * NOT a collating function.
 *
 *
 * @param     "const TText* aOldText"
 *            Pointer to block of text
 * @param     "const TText* aNewText"
 *            Pointer to block of text. 
 *			  This may point to the same buffer as oldText.
 * @param     "const TUint aSize"
 *            The size of the text blocks.
 *
 * @return    ETrue: test succeeded EFalse: test failed.
 *
 */
	static TBool TextInReverseOrder (const TText* aOldText , const TText* aNewText, const TUint aSize, CTGraphicsBase* aTest=NULL)
		{
		__ASSERT_ALWAYS(aOldText, User::Invariant());
		__ASSERT_ALWAYS(aNewText, User::Invariant());
		__ASSERT_ALWAYS(0 < aSize, User::Invariant());

		TUint i = 0;			// index into aOldText
		TUint j = aSize - 1;	// index into aNewText
		while (i < aSize)
			{
			if (IsHighSurrogate(aOldText[i]))
				{
				if (aOldText[i] != aNewText[j-1] || aOldText[i+1] != aNewText[j])
					{
					if (aTest)
						{
						_LIT(KMismatchFormat, "TextInReverseOrder report mismatch: aOldText[%d]=%04X != aNewText[%d]=%04X || aOldText[%d]=%04X != aNewText[%d]=%04X\r\n");
						aTest->Logger().LogExtra(((TText8*)__FILE__), __LINE__, ESevrWarn, KMismatchFormat,
								i, aOldText[i], j-1, aNewText[j-1], i+1, aOldText[i+1], j, aNewText[j]); 
						}
					return EFalse;
					}
				i += 2;
				j -= 2;
				}
			else
				{
				if (aOldText[i] != aNewText[j])
					{
					if (aTest)
						{
						_LIT(KMismatchFormat, "TextInReverseOrder report mismatch: aOldText[%d]=%04X != aNewText[%d]=%04X\r\n");
						aTest->INFO_PRINTF5(KMismatchFormat, i, aOldText[i], j, aNewText[j]);
						}
					return EFalse;
					}
				i++;
				j--;
				}
			}

		return ETrue;
		}

/**
 *
 * Checks that two blocks of 16-bit text contain the same characters but in
 * reverse order, skipping any zero-width joiners in aNewText.
 *
 * @param     "const TText* aOldText"
 *            Pointer to block of text
 * @param     "const TText* aNewText"
 *            Pointer to block of text. 
 *			  This may point to the same buffer as oldText.
 * @param     "const TUint aSize"
 *            The size of aOldText.
 *
 * @return
 *		0 if the text did not match, or a pointer one past the end of aNewText's
 *		match if it did.
 *
 */
	static const TText* TextInReverseOrderIgnoringJoiners(
		const TText* aOldText , const TText* aNewText, const TUint aSize)
		{
		__ASSERT_ALWAYS(aOldText, User::Invariant());
		__ASSERT_ALWAYS(aNewText, User::Invariant());
		__ASSERT_ALWAYS(0 < aSize, User::Invariant());

		const TText* newText = aNewText;
		for (const TText* old = aOldText + aSize - 1;
			aOldText <= old;
			--old, ++newText)
			{
			while (*newText == KUnicodeZeroWidthJoiner)
				++newText;
			if (*newText != *old)
				return 0;
			}

		while (*newText == KUnicodeZeroWidthJoiner)
			++newText;
		return newText;
		}

/**
 *
 * Compares two pointers. 
 * If the second pointer does not point to the same place as the first, the
 * block of memory it points to is deleted as an array.
 *
 *
 * @param     "const TText* aOldText"
 *            Pointer to block of text
 * @param     "TText*& aNewText"
 *            Pointer to block of text. 
 *			  This may point to the same buffer as aOldText.
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 */	
	
    static void DeleteText( const TText* aOldText, TText*& aNewText, CTGraphicsBase* aTest)
		{
			if (aNewText != aOldText)
				{
				TInt diff;
				if (aNewText > aOldText)
					{
					diff = aNewText-aOldText;
					}
				else
					{
					diff = aOldText-aNewText;
					}
				if (diff < KBufferSize)
					{
					aTest->INFO_PRINTF2(_L("Bad free detected - diff %d\r\n"), diff);
					aTest->TEST(EFalse);
					}

				delete[] aNewText;
				aNewText = 0;
				}
		}
/**
 *
 * Test Internalization and Externalization of TBidirectionalState class. 
 *
 *
 * @param     "TBidirectionalState& aState"
 *            Reference to a TBidirectionalState object. 
 *            The state object is assumed not to be newly created, i.e. it has
 *            non-default internal state.
 *            
 * @param     "TBidirectionalState& aState2"
 *            Reference to a TBidirectionalState object. 
 *            The state object is assumed not to be newly created, i.e. it has
 *            non-default internal state. This state is also assumed to be
 *            different to that of aState
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 */	
	static void TestInternalizeL(TBidirectionalState& aState, TBidirectionalState& aState2, CTGraphicsBase* aTest)
		{
		//Now test internalization and externalization functions

		//Create memory-based streams to externalize into
		
		CBufStore* rStore = CBufStore::NewLC(KBufferSize);
		CBufStore* lStore = CBufStore::NewLC(KBufferSize);

		RStoreWriteStream lWStream;
		RStoreWriteStream rWStream;

		TStreamId lStreamID = lWStream.CreateLC(*lStore);
		TStreamId rStreamID = rWStream.CreateLC(*rStore);

		//Now externalize the states.

		aState.ExternalizeL(lWStream);
		aState2.ExternalizeL(rWStream);

		lWStream.Close();
		rWStream.Close();

		//Now read the externalised streams into two new state objects

		TBidirectionalState newLState;
		TBidirectionalState newRState;

		RStoreReadStream rRStream;
		RStoreReadStream lRStream;

		lRStream.OpenLC(*lStore, lStreamID);
		rRStream.OpenLC(*rStore, rStreamID);

		newLState.InternalizeL(lRStream);
		newRState.InternalizeL(rRStream);

		//Now establish that the internalization has changed the state

		aTest->TEST(!newLState.IsDefault());
		aTest->TEST(!newRState.IsDefault());

		//Make sure that two distinct sets of data exist

		aTest->TEST(!(newLState == newRState));

		//check that the new state objects are equivalent to the old ones

		aTest->TEST(newLState == aState);
		aTest->TEST(newRState == aState2);

		//Now check that the externalization / internalization has
		//produced true copies, i.e. that there are no shared buffers
		//anywhere

		aState.Reset();
		aTest->TEST (aState.IsDefault());
		aTest->TEST (!(aState2 == aState));
		aTest->TEST (!(aState == aState2));
		aTest->TEST (!(aState == newLState));
		aTest->TEST(!newLState.IsDefault());
		aTest->TEST(!newRState.IsDefault()); 

		aState2.Reset();
		aTest->TEST (aState2.IsDefault());
		aTest->TEST (aState == aState2);
		aTest->TEST (aState2 == aState);
		aTest->TEST (!(aState2 == newRState));
		aTest->TEST(!newLState.IsDefault());
		aTest->TEST(!newRState.IsDefault()); 

		//End of tests - deal with cleanup stack

		CleanupStack::PopAndDestroy(6);
		}

/**
 *
 * Test API of TBidirectionalState class. 
 *
 *  with the exception of BidirectionalState::ReorderText
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object
 *
 */
	static void TestAPIL(CTGraphicsBase* aTest)
		{
		 TInt run;
		 TInt i;

		//General tests for the DLL API to TBidirectionalState

		aTest->INFO_PRINTF1(_L("TBidirectionalState general exported API test\r\n"));

#ifdef PRINT_RUNS
		_LIT(KRunTitle, "Populating aOldText buffer with embedded runs of characters as follows:\r\n");
		_LIT(KRunFormat, "Run %d begins with %04x\r\n");
		_LIT(KEndRunFormat, "End of Run %d begins with %04x\r\n");
		
#endif // PRINT_RUNS 
	
		const TInt KRuns = 64;
		const TInt KRunSize = ((KBufferSize/KRuns)/2 );
		
		//Create buffer to hold test data

		HBufC* oldTextBufPtr = HBufC::NewLC(KBufferSize);

		for (i = 0 ; i < KBufferSize ; ++i)
			{
			oldTextBufPtr->Des().Append(0);
			}

		TPtr oldText(oldTextBufPtr->Des());
		

		TBidirectionalState::TRunInfo* lRunInfoArray = new(ELeave) TBidirectionalState::TRunInfo[KRuns];
		CleanupArrayDeletePushL(lRunInfoArray);
		TBidirectionalState::TRunInfo* rRunInfoArray = new(ELeave) TBidirectionalState::TRunInfo[KRuns];
		CleanupArrayDeletePushL(rRunInfoArray);


		//Build up a lot of levels of L-R and R-L text

		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);

		 //Loop through all available test data
		 //There are more Left-To-Right characters than Right-To-Left, so
		 //use ltorIterator as the guide

		 while (!ltorIterator.Wrapped())
			{
			//Build up runs
			 TInt index = 0;
	#ifdef PRINT_RUNS
			 aTest->INFO_PRINTF1(KRunTitle);
	#endif // PRINT_RUNS
			 for (run = 0 ; run < KRuns ; run++) 
				{
				TUint first; 
				lRunInfoArray[run].iStart = rRunInfoArray[run].iStart = index;
				lRunInfoArray[run].iIndex = rRunInfoArray[run].iIndex = 0;
				lRunInfoArray[run].iEmbeddingLevel = rRunInfoArray[run].iEmbeddingLevel = 0;

				if ((run & 1) == 0)
					{
					//Odd values of Run use R-L, even use L-R

					first = ltorIterator.NextChar();
	#ifdef PRINT_RUNS
					aTest->INFO_PRINTF3(KRunFormat, run, first);
	#endif // PRINT_RUNS
					ltorIterator.NextCharInto(oldText, index, -1, ETrue, EFalse);
					for (i = 1; i < KRunSize ; ++i)
						{
						if (!ltorIterator.NextCharInto(oldText, index))
							break;
						}
					lRunInfoArray[run].iDirection = rRunInfoArray[run].iDirection = 0;
	#ifdef PRINT_RUNS
					aTest->INFO_PRINTF4(KRunFormat, run, (first & 0xffff), 0);
	#endif // PRINT_RUN
						
					}
				else
					{
					first = rtolIterator.NextChar();
					oldText[index++] = first;
					for (i = 1; i < KRunSize ; ++i)
						{
						oldText[index++] = rtolIterator.NextChar();
						}
					lRunInfoArray[run].iDirection = rRunInfoArray[run].iDirection = 1;
					}
	#ifdef PRINT_RUNS
					aTest->INFO_PRINTF4(KRunFormat, run, (first & 0xffff) , 1);
	#endif // PRINT_RUNS
				lRunInfoArray[run].iCategory = rRunInfoArray[run].iCategory = TChar(first).GetBdCategory();
				lRunInfoArray[run].iLength = rRunInfoArray[run].iLength = KRunSize;
				}
					
#ifdef PRINT_ARRAYS
			 _LIT(KArrayData, "Data\r\n");
			 PrintTestData(KArrayData, oldText.Ptr(), KBufferSize);
#endif // PRINT_ARRAYS

			TBidirectionalState lState;
			TBidirectionalState rState;

			//Check that newly created state objects match IsDefault
			aTest->TEST (lState.IsDefault());
			aTest->TEST (rState.IsDefault());

			//Check that default state objects work with operator==
			aTest->TEST (lState == rState);
			aTest->TEST (rState == lState);

			//Call ReorderLine to both populate lRunInfoArray and change 
			//the internal state of lState
			lState.ReorderLine(lRunInfoArray, KRuns, ETrue, ETrue, EParaLToR,
				TChar::EOtherNeutral, TChar::EOtherNeutral);

			//Check that the state object is no longer in default state
			aTest->TEST (!lState.IsDefault());

			//Check that operator== can detect that
			aTest->TEST (!(lState == rState));

			//Call ReorderLine to both populate rRunInfoArray and change 
			//the internal state of RState
			rState.ReorderLine(rRunInfoArray, KRuns, ETrue, ETrue, EParaRToL,
				TChar::EOtherNeutral, TChar::EOtherNeutral);

			//now rState should not be in default state
			aTest->TEST(!rState.IsDefault());

			//Test that lSTate and rState are not the same.
			//Make sure that lState.operator== and rState.operator== give
			//the same answer.

			aTest->TEST (!(lState == rState));
			aTest->TEST (!(rState == lState));


#ifdef PRINT_RUNS
			//Print the contents of kRunInfo in epocwind.out
			_LIT(KRunInfo1, "run             Category                 Embedding Level Direction       Index           Start           Length\r\n");
			_LIT(KRunInfo2, "       %d               %d                      %d             %d               %d              %d              %d\r\n");

			//Temp - print contents of arrays
			aTest->INFO_PRINTF1(_L("Left-To-Right Paragraph\r\n"));
			aTest->INFO_PRINTF1(KRunInfo1);	
			for (run = 0 ; run < KRuns ; ++run)
				{
				aTest->Logger().LogExtra(((TText8*)__FILE__), __LINE__, ESevrInfo,
					KRunInfo2, run, lRunInfoArray[run].iCategory, 
					lRunInfoArray[run].iEmbeddingLevel, lRunInfoArray[run].iDirection, 
					lRunInfoArray[run].iIndex, lRunInfoArray[run].iStart, lRunInfoArray[run].iLength);	
				}
			aTest->INFO_PRINTF1(_L("Right-to-Left Paragraph\r\n"));
			aTest->INFO_PRINTF1(KRunInfo1);	
			for (run = 0 ; run < KRuns ; ++run)
				{
				aTest->Logger().LogExtra(((TText8*)__FILE__), __LINE__, ESevrInfo,
					KRunInfo2, run, rRunInfoArray[run].iCategory, 
					rRunInfoArray[run].iEmbeddingLevel, rRunInfoArray[run].iDirection, 
					rRunInfoArray[run].iIndex, rRunInfoArray[run].iStart, rRunInfoArray[run].iLength);	
				}

#endif // PRINT_RUNS

			//With the test data presented, there should be 64 runs in ascending order
			//when processed in a left-to-right context and in descending order when processed
			//as right-to-left, corresponding to each run being printed in entry order in
			//the former case and in reverse order in the latter case.

			for (run = 0 ; run < KRuns ; ++run)
				{
				aTest->TEST(lRunInfoArray[run].iIndex == run);
				aTest->TEST(rRunInfoArray[KRuns - run - 1].iIndex == run);
				}

		
			TestInternalizeL(lState,rState, aTest);			
			}


		CleanupStack::PopAndDestroy(rRunInfoArray);
		CleanupStack::PopAndDestroy(lRunInfoArray);
		CleanupStack::PopAndDestroy();
		}

/**
 *
 * Tests that the Bidirectional Algorithm leaves left to right text alone.
 *
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LeftToRightReorderTest(TDes& aOldText, CTGraphicsBase* aTest)
		{//LeftToRight test - are left-to-right character strings preserved?
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;

		TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);

		aTest->TEST(aOldText.Length() >= KBufferSize);
		while (!ltorIterator.Wrapped())
			{
			for (TInt i = 0 ; i < KBufferSize; )
				{
				if (!ltorIterator.NextCharInto(aOldText, i))
					break;
				}

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaRToL, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			//LtoR characters should remain unchanged in either paragraph direction
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, KBufferSize));
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), rText, KBufferSize));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			}
		}
/**
 *
 * Tests that the Bidirectional Algorithm leaves european numbers alone
 *
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void SimpleEuropeanNumberTest(TDes& aOldText, CTGraphicsBase* aTest)
		{//European number test - are left-to-right character strings preserved?

		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;

		
		TextIterator numIterator(KEuropeanNumber, KEuropeanNumberLength);
		aTest->TEST(aOldText.Length() >= KBufferSize);

		while (!numIterator.Wrapped())
			{
			for (TInt i = 0 ; i < KBufferSize; ++i)
				{
				aOldText[i] = numIterator.NextChar();
				}

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaRToL, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, KBufferSize));
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), rText, KBufferSize));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			}

		}
/**
 *
 * Tests that the Bidirectional Algorithm reverses right-to-left text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void SimpleRightToLeftTest(TDes& aOldText, CTGraphicsBase* aTest)
		{// Basic Right-to-Left test

		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);

		aTest->TEST(aOldText.Length() >= KBufferSize);

		while (!rtolIterator.Wrapped())
			{
			TInt i = 0;
			rtolIterator.FillInto(aOldText, i, KBufferSize);
			aOldText.SetLength(i);

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
		
			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			//RightToLeft characters should be reversed in order
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), rText, i));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			aOldText.SetLength(oldTextLength);
			}
		}		

/**
 *
 * Tests that the Bidirectional Algorithm reverses right-to-left Arabic text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void SimpleRightToLeftArabicTest(TDes& aOldText, CTGraphicsBase* aTest)
		{// Basic Right-to-Left Arabic test

		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;

		 // Basic Right-to-Left Arabic test

		TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);

		aTest->TEST(aOldText.Length() >= KBufferSize);

		while (!rtolIterator.Wrapped())
			{
			for (TInt i = 0 ; i < KBufferSize; ++i)
				{
				aOldText[i] = rtolIterator.NextChar();
				}

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaRToL, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			//RightToLeftArabic characters should be reversed
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), lText, KBufferSize));
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), rText, KBufferSize));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			
			}
		 }

/**
 *
 * Tests that characters that have mirrors are replaced by their mirrors
 * when right-to-left Arabic text is reversed.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void MirroredCharacterTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;

		 // Mirrored Characters Test

		 //Some Arabic test is interspersed with characters that have Mirror versions.

		 //After reordering the text should be reversed and the mirror characters substituted
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);
		 TextIterator mirrorsIterator(KMirrors().Ptr(), KMirrors().Length());
		 TextIterator mirrordIterator(KMirrord().Ptr(), KMirrord().Length());

		 while (!rtolIterator.Wrapped())
			{
			TInt i;
			TInt j;
			for (i = 0 ; i < (KBufferSize-3); i+=4)
				{
				aOldText[i] = rtolIterator.NextChar();
				aOldText[i+1] = mirrorsIterator.NextChar();
				aOldText[i+2] = mirrorsIterator.NextChar();
				aOldText[i+3] = rtolIterator.NextChar();
				}

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaRToL, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
		
			for (i = 0 ; i < (KBufferSize-3) ; i+=4)
				{
				j = KBufferSize - i - 1;
				aTest->TEST(aOldText[i] == lText[j]);
				aTest->TEST(aOldText[i] == rText[j]);
				aTest->TEST(aOldText[i+3] == lText[j-3]);
				aTest->TEST(aOldText[i+3] == rText[j-3]);

				TText16 nextMirror = mirrordIterator.NextChar();

				aTest->TEST(nextMirror == lText[j-1]);
				aTest->TEST(nextMirror == rText[j-1]);

				nextMirror = mirrordIterator.NextChar();

				aTest->TEST(nextMirror == lText[j-2]);
				aTest->TEST(nextMirror == rText[j-2]);
				}


			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

	
			}
		}
/**
 *
 * Tests the effect of LeftToRightOverride on left-to-right text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LROLeftToRightTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* newText = 0;
		TInt retval = KErrNone;

		aTest->TEST(aOldText.Length() >= KBufferSize);
		//LRO test - are left-to-right character strings preserved?
	 
		TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		while (ltorIterator.Wrapped())
			{
			aOldText[0] = KLeftToRightOverride[0];
			for (TInt i = 1 ; i < (KBufferSize-1); ++i)
				{
				aOldText[i] = ltorIterator.NextChar();
				}

			aOldText[KBufferSize-1] = KPopDirectionalFormat[0];
			retval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaLToR, newText);

			aTest->TEST(retval == KErrNone); 

			aTest->TEST(TextInSameOrder(aOldText.Ptr(), newText, KBufferSize));
		
			DeleteText(aOldText.Ptr(), newText, aTest);

			}
		}

/**
 *
 * Tests the effect of LeftToRightOverride on right-to-left text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LRORightToLeftTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* newText = 0;
		TInt retval = KErrNone;


		//LRO test - are right-to-left character strings overidden?
		TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);

		aTest->TEST(aOldText.Length() >= KBufferSize);
		while (!rtolIterator.Wrapped())
			{
			aOldText[0] = KLeftToRightOverride[0];
			for (TInt i = 1 ; i < (KBufferSize-1); ++i)
				{
				aOldText[i] = rtolIterator.NextChar();
				}
			
			aOldText[KBufferSize-1] = KPopDirectionalFormat[0];
			retval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaLToR, newText);

			aTest->TEST(retval == KErrNone); 

			aTest->TEST(TextInSameOrder(aOldText.Ptr(), newText, KBufferSize));

			DeleteText(aOldText.Ptr(),newText, aTest);
			}
		}

/**
 *
 * Tests the effect of RightToLeftOverride on right-to-left text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RLORightToLeftTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* newText = 0;
		TInt retval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		 // RLO Test - are right-to-left characters unaffected?
		TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 
		aTest->TEST(aOldText.Length() >= KBufferSize);

		while (!rtolIterator.Wrapped())
			{
			aOldText[0] = KRightToLeftOverride[0];

			TInt i = 1;
			rtolIterator.FillInto(aOldText, i, KBufferSize-1);
			aOldText[i++] = KPopDirectionalFormat[0];
			aOldText.SetLength(i);

			retval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, newText);

			aTest->TEST(retval == KErrNone); 

			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), newText, i));
		
			DeleteText(aOldText.Ptr(), newText, aTest);
			aOldText.SetLength(oldTextLength);
			}
		}

/**
 *
 * Tests the effect of RightToLeftOverride on right-to-left Arabic text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */	
	static void RLORightToLeftArabicTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* newText = 0;
		TInt retval = KErrNone;

		// RLO Test - are right-to-left Arabic characters unaffected?
		TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);

		aTest->TEST(aOldText.Length() >= KBufferSize);

		while (!rtolIterator.Wrapped())
			{
			aOldText[0] = KRightToLeftOverride[0];

			for (TInt i = 1 ; i < (KBufferSize-1); ++i)
				{
				aOldText[i] = rtolIterator.NextChar();
				}
			
			aOldText[KBufferSize-1] = KPopDirectionalFormat[0];
		 
			retval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaRToL, newText);

			aTest->TEST(retval == KErrNone); 

			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), newText, KBufferSize));

			DeleteText(aOldText.Ptr(), newText, aTest);

			}
		}

/**
 *
 * Tests the effect of RightToLeftOverride on left-to-right text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RLOLeftToRightTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* newText = 0;
		TInt retval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		// RLO Test - are left-to-right characters overriden?
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			aOldText[0] = KRightToLeftOverride[0];

			TInt i;
			for (i = 1 ; i < (KBufferSize-1); )
				{
				if (!ltorIterator.NextCharInto(aOldText, i, KBufferSize-1))
					break;
				}

			aOldText[i] = KPopDirectionalFormat[0];
			TInt newLength = i + 1;
			aOldText.SetLength(newLength);
		 
			retval = TBidirectionalState::ReorderText(aOldText.Ptr(), newLength, EParaRToL, newText);

			aTest->TEST(retval == KErrNone); 

			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), newText, newLength, aTest));
		
			DeleteText(aOldText.Ptr(), newText, aTest);
			aOldText.SetLength(oldTextLength);
			}
		}

/**
 *
 * Tests the effect of putting Left To Right text by Right To Left text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenRToLTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		// Mixing L-R & R-L without embed codes - L-R at start, R-L at end
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i = 0;
			ltorIterator.FillInto(aOldText, i, KHalfBufferSize);
			TInt realSize1 = i;

			rtolIterator.FillInto(aOldText, i, KBufferSize);
			TInt realSize2 = i - realSize1;
			aOldText.SetLength(i);

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, realSize1));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize1], &lText[realSize1], realSize2));
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), rText, realSize1));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize1], &rText[realSize1], realSize2));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			aOldText.SetLength(oldTextLength);
			}
		}

/**
 *
 * Tests the effect of putting Left To Right text by Right To Left Arabic text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenRToLATest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);
		 while (!ltorIterator.Wrapped())
			{
			TInt i;

			for (i = 0 ; i < KHalfBufferSize; )
				{
				if (!ltorIterator.NextCharInto(aOldText, i, KHalfBufferSize))
					break;
				}
			TInt realSize1 = i;

			for (; i < KBufferSize; ++i)
				{
				aOldText[i] = rtolIterator.NextChar();
				}
			TInt realSize2 = i - realSize1;
			aOldText.SetLength(i);

 
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, realSize1));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize1], &lText[realSize1], realSize2));
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), rText, realSize1));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize1], &rText[realSize1], realSize2));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			aOldText.SetLength(oldTextLength);
			}
		}
/**
 *
 * Tests the effect of putting Right To Left Arabic by Left To Right text.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLAThenLToRTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		 // Mixing L-R & R-LA without embed codes - R-LA at start, L-R at end
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i = 0;

			rtolIterator.FillInto(aOldText, i, KHalfBufferSize);
			TInt realSize1 = i;

			ltorIterator.FillInto(aOldText, i, KBufferSize);
			TInt realSize2 = i - realSize1;
			aOldText.SetLength(i);
 
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), lText, realSize1));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize1], &lText[realSize1] , realSize2));

			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), &rText[realSize2], realSize1));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize1], rText, realSize2));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			aOldText.SetLength(oldTextLength);
			}
		}

/**
 *
 * Tests the effect of interspersing right to left and left to right text
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenRToLThenLToRThenRToLTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		 // Mixing L-R & R-L without embed codes - quarter buffers L-R R-L L-R R-L 
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i = 0;

			ltorIterator.FillInto(aOldText, i, KQuarterBufferSize);
			TInt realSize1 = i;
			
			rtolIterator.FillInto(aOldText, i, KHalfBufferSize);
			TInt realSize2 = i - realSize1;
			TInt realSize12 = i;
			
			ltorIterator.FillInto(aOldText, i, KThreeQuarterBufferSize);
			TInt realSize3 = i - realSize12;
			TInt realSize123 = i;
			
			rtolIterator.FillInto(aOldText, i, KBufferSize);
			TInt realSize4 = i - realSize123;
			TInt realSize34 = i - realSize12;
			TInt realSize234 = i - realSize1;

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);
	    	rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			// source:		L1 R2 L3 R4
			// l should be:	L1 L2 L3 L4
			// r should be: R4 R3 R2 R1
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, realSize1));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize1], &lText[realSize1], realSize2));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize12], &lText[realSize12], realSize3));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize123], &lText[realSize123], realSize4));

			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize123], rText, realSize4));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize12], &rText[realSize4], realSize3));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize1], &rText[realSize34], realSize2));
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), &rText[realSize234], realSize1));
		
			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			aOldText.SetLength(oldTextLength);
			}
		}

/**
 *
 * Tests the effect of interspersing right to left and left to right text
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLThenLToRThenRToLThenLToRTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		 // Mixing L-R & R-L without embed codes - quarter buffers R-L L-R R-L L-R
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i = 0;

	    	rtolIterator.FillInto(aOldText, i, KQuarterBufferSize);
			TInt realSize1 = i;
			
			ltorIterator.FillInto(aOldText, i, KHalfBufferSize);
			TInt realSize2 = i - realSize1;
			TInt realSize12 = i;
			
			rtolIterator.FillInto(aOldText, i, KThreeQuarterBufferSize);
			TInt realSize3 = i - realSize12;
			TInt realSize123 = i;
			
			ltorIterator.FillInto(aOldText, i, KBufferSize);
			TInt realSize4 = i - realSize123;
			TInt realSize34 = i - realSize12;
			TInt realSize234 = i - realSize1;

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);
	    	rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			// source:		R1 L2 R3 L4
			// l should be:	L1 L2 L3 L4
			// r should be: L4 L3 L2 L1
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), lText, realSize1));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize1], &lText[realSize1], realSize2));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize12], &lText[realSize12], realSize3));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize123], &lText[realSize123], realSize4));
		
			aTest->TEST( TextInSameOrder(&aOldText.Ptr()[realSize123], rText, realSize4));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[realSize12], &rText[realSize4], realSize3));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize1], &rText[realSize34], realSize2));
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), &rText[realSize234], realSize1));
		
			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			
			aOldText.SetLength(oldTextLength);
			}
		}

/**
 *
 * Tests the effect of mixing blocks of right to left text, left to right text, 
 * European numbers and Arabic numbers
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void SimpleNumberTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		// Now mix in some numbers
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i = 0;
	    	rtolIterator.FillInto(aOldText, i, KQuarterBufferSize);
			TInt realSize1 = i;
			
			ltorIterator.FillInto(aOldText, i, KHalfBufferSize);
			TInt realSize2 = i - realSize1;
			TInt realSize12 = i;
			
			euronIterator.FillInto(aOldText, i, KThreeQuarterBufferSize);
			TInt realSize3 = i - realSize12;
			TInt realSize123 = i;
			TInt realSize23 = realSize123 - realSize1;
			
			arabnIterator.FillInto(aOldText, i, KBufferSize);
			TInt realSize4 = i - realSize123;
			TInt realSize234 = i - realSize1;

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			// source:		 1  2  3  4
			// l should be:	 2  3  4 -1
			// r should be: -1  2  3  4
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize1], rText, realSize2));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize12], &rText[realSize2], realSize3));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize123], &rText[realSize23], realSize4));
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), &rText[realSize234], realSize1));

			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), lText, realSize1));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize1], &lText[realSize1], realSize2));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize12], &lText[realSize12], realSize3));
			aTest->TEST(TextInSameOrder(&aOldText.Ptr()[realSize123], &lText[realSize123], realSize4));
		
			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			}
		}

/**
 *
 * Tests what happens when Arabic and European numbers are surrounded by Arabic letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLAThenANThenENThenRToLATest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);

		 while (!rtolIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch3);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				AppendCharacter(rResult, ch3);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA

			_LIT(KOTitle, "Original");
			_LIT(KLTitle, "Left-to-Right"); 
			_LIT(KRTitle, "Right-to-Left");
			

			PrintTestData(KOTitle, aOldText);
			PrintTestData(KLTitle, lText, KBufferSize);
			PrintTestData(KRTitle, rText, KBufferSize);

#endif
			aTest->TEST(TextInReverseOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}
/**
 *
 * Tests what happens when Arabic and European numbers are surrounded by Arabic letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLAThenENThenANThenRToLATest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);

		 while (!rtolIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch3);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				AppendCharacter(rResult, ch3);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA

			_LIT(KOTitle, "Original");
			_LIT(KLTitle, "Left-to-Right"); 
			_LIT(KRTitle, "Right-to-Left");
			

			PrintTestData(KOTitle, aOldText);
			PrintTestData(KLTitle, lText, KBufferSize);
			PrintTestData(KRTitle, rText, KBufferSize);

#endif
			aTest->TEST(TextInReverseOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}
/**
 *
 * Tests what happens when Arabic and European numbers are surrounded by right-to-left letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLThenANThenENThenRToLTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);

		 while (!rtolIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch3);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				AppendCharacter(rResult, ch3);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

#ifdef PRINT_DATA

			_LIT(KOTitle, "Original");
			_LIT(KLTitle, "Left-to-Right"); 
			_LIT(KRTitle, "Right-to-Left");
			

			PrintTestData(KOTitle, aOldText);
			PrintTestData(KLTitle, lText, KBufferSize);
			PrintTestData(KRTitle, rText, KBufferSize);

#endif
			aTest->TEST(TextInReverseOrder(lResult->Ptr(), lText, i, aTest));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}

/**
 *
 * Tests what happens when Arabic and European numbers are surrounded by right-to-left letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLThenENThenANThenRToLTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);

		 while (!rtolIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch3);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				AppendCharacter(rResult, ch3);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA

			_LIT(KOTitle, "Original");
			_LIT(KLTitle, "Left-to-Right"); 
			_LIT(KRTitle, "Right-to-Left");
			

			PrintTestData(KOTitle, aOldText);
			PrintTestData(KLTitle, lText, KBufferSize);
			PrintTestData(KRTitle, rText, KBufferSize);

#endif

			aTest->TEST(TextInReverseOrder(lResult->Ptr(), lText, i, aTest));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}
/**
 *
 * Tests what happens when Arabic and European numbers are surrounded by Left to Right letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenANThenENThenLToRTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		// Now mix in some numbers
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);
		 while (!ltorIterator.Wrapped())
			{
			TInt i;

			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!ltorIterator.NextCharInto(aOldText, i))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i))
					break;
				if (!euronIterator.NextCharInto(aOldText, i))
					break;
				if (!ltorIterator.NextCharInto(aOldText, i))
					break;
				}
			aOldText.SetLength(i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA

			_LIT(KOTitle, "Original");
			_LIT(KLTitle, "Left-to-Right"); 
			_LIT(KRTitle, "Right-to-Left");
			

			PrintTestData(KOTitle, aOldText);
			PrintTestData(KLTitle, lText, KBufferSize);
			PrintTestData(KRTitle, rText, KBufferSize);

#endif
		
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, i));
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), rText, i));


			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			}
		}
		
/**
 *
 * Tests what happens when Arabic and European numbers are surrounded by Left To Right letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenENThenANThenLToRTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		// Now mix in some numbers
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;

			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!ltorIterator.NextCharInto(aOldText, i))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i))
					break;
				if (!euronIterator.NextCharInto(aOldText, i))
					break;
				if (!ltorIterator.NextCharInto(aOldText, i))
					break;
				}
			aOldText.SetLength(i);


			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);


			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

#ifdef PRINT_DATA

			_LIT(KOTitle, "Original");
			_LIT(KLTitle, "Left-to-Right"); 
			_LIT(KRTitle, "Right-to-Left");
			

			PrintTestData(KOTitle, aOldText);
			PrintTestData(KLTitle, lText, KBufferSize);
			PrintTestData(KRTitle, rText, KBufferSize);

#endif
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, i));
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), rText, i));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			
			aOldText.SetLength(oldTextLength);
			}
		}

/**
 *
 * Tests what happens when Arabic and European numbers are preceded by Left To Right 
 * and succeeded by Right To Left letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenANThenENThenRToLTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		// Now mix in some numbers
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!ltorIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				lasti = i;
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

#ifdef PRINT_DATA

			_LIT(KOTitle, "Original");
			_LIT(KLTitle, "Left-to-Right"); 
			_LIT(KRTitle, "Right-to-Left");
			

			PrintTestData(KOTitle, aOldText);
			PrintTestData(KLTitle, lText, KBufferSize);
			PrintTestData(KRTitle, rText, KBufferSize);

#endif
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			
			aOldText.SetLength(oldTextLength);
			rResult->Des().SetLength(0);
			}
		 CleanupStack::PopAndDestroy(rResult);
		}

/**
 *
 * Tests what happens when Arabic and European numbers are preceded by Left To Right 
 * and succeeded by Right To Left letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenENThenANThenRToLTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		// Now mix in some numbers
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!ltorIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch3);
				AppendCharacter(lResult, ch2);
				
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);
			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

#ifdef PRINT_DATA

			_LIT(KOTitle, "Original");
			_LIT(KLTitle, "Left-to-Right"); 
			_LIT(KRTitle, "Right-to-Left");
			

			PrintTestData(KOTitle, aOldText);
			PrintTestData(KLTitle, lText, KBufferSize);
			PrintTestData(KRTitle, rText, KBufferSize);

#endif
			aTest->TEST(TextInSameOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}
/**
 *
 * Tests what happens when Arabic and European numbers are preceded by Left To Right 
 * and succeeded by Right To Left Arabic letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenANThenENThenRToLATest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		// Now mix in some numbers
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;

			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!ltorIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(rResult->Des().Length() == i);


			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

#ifdef PRINT_DATA

			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
		
			aOldText.SetLength(oldTextLength);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		}
/**
 *
 * Tests what happens when Arabic and European numbers are preceded by Left To Right 
 * and succeeded by Right To Left Arabic letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void LToRThenENThenANThenRToLATest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		// Now mix in some numbers
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!ltorIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch3);
				AppendCharacter(lResult, ch2);
				
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
			aTest->TEST(TextInSameOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			
			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}
/**
 *
 * Tests what happens when Arabic and European numbers are preceded by Right to Left
 * and succeeded by Left To Right letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLThenANThenENThenLToRTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		aTest->INFO_PRINTF1(_L("TBidirectionalState test - R-L AN EN L-R test\r\n"));
		
		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!ltorIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch3);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);
			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
		
			aTest->TEST(TextInSameOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}

/**
 *
 * Tests what happens when Arabic and European numbers are preceded by Right to Left
 * and succeeded by Left To Right letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLThenENThenANThenLToRTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		aTest->INFO_PRINTF1(_L("TBidirectionalState test - R-L EN AN L-R test\r\n"));
		
		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!ltorIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch3);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);


			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
		
			aTest->TEST(TextInSameOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}
/**
 *
 * Tests what happens when Arabic and European numbers are preceded by Right to Left Arabic
 * and succeeded by Left To Right letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLAThenANThenENThenLToRTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		aTest->INFO_PRINTF1(_L("TBidirectionalState test - R-LA AN EN L-R test\r\n"));
		
		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!ltorIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch3);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
		
			aTest->TEST(TextInSameOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}

/**
 *
 * Tests what happens when Arabic and European numbers are preceded by Right to Left Arabic
 * and succeeded by Left To Right letters
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLAThenENThenANThenLToRTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		aTest->INFO_PRINTF1(_L("TBidirectionalState test - R-LA EN AN L-R test\r\n"));
		
		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!ltorIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch1);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch3);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
		
			aTest->TEST(TextInSameOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}

/**
 *
 * Tests what happens to European Terminators in a pair of European Numbers 
 * when the first character is a Right To Left letter
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLThenENThenETThenENTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();
		HBufC *lResult = HBufC::NewLC(KBufferSize);
		HBufC *rResult = HBufC::NewLC(KBufferSize);

		aTest->INFO_PRINTF1(_L("TBidirectionalState test - R-L EN ET EN test\r\n"));
		
		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator eurotIterator(KEuropeanNumberTerminator, KEuropeanNumberTerminatorLength);

		 while(!rtolIterator.Wrapped())
			{
			TInt i;
			TInt lasti = 0;
			TUint ch0, ch1, ch2, ch3;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch0))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch1))
					break;
				if (!eurotIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch2))
					break;
				if (!euronIterator.NextCharInto(aOldText, i, -1, ETrue, ETrue, &ch3))
					break;
				
				lasti = i;
				AppendCharacter(lResult, ch0);
				AppendCharacter(lResult, ch3);
				AppendCharacter(lResult, ch2);
				AppendCharacter(lResult, ch1);
				
				AppendCharacter(rResult, ch0);
				AppendCharacter(rResult, ch3);
				AppendCharacter(rResult, ch2);
				AppendCharacter(rResult, ch1);
				}
			i = lasti;
			aOldText.SetLength(i);
			ASSERT(lResult->Des().Length() == i);
			ASSERT(rResult->Des().Length() == i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
			aTest->TEST(TextInReverseOrder(lResult->Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(rResult->Ptr(), rText, i, aTest));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			lResult->Des().SetLength(0);
			rResult->Des().SetLength(0);
			}
		CleanupStack::PopAndDestroy(rResult);
		CleanupStack::PopAndDestroy(lResult);
		}
/**
 *
 * Tests what happens to European Terminators in a pair of Arabic Numbers 
 * when the first character is a Right To Left letter
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLThenANThenETThenANTest(TDes& aOldText, CTGraphicsBase *aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		aTest->INFO_PRINTF1(_L("TBidirectionalState test - R-L AN ET AN test\r\n"));
		
		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator eurotIterator(KEuropeanNumberTerminator, KEuropeanNumberTerminatorLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while(!rtolIterator.Wrapped())
			{
			TInt i;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i))
					break;
				if (!eurotIterator.NextCharInto(aOldText, i))
					break;
				if (!arabnIterator.NextCharInto(aOldText, i))
					break;
				}
			aOldText.SetLength(i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), rText, i));
		

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			}
		}
/**
 *
 * Tests what happens to European Terminators in a pair of European Numbers 
 * when the first character is a Right To Left Arabic letter
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLAThenENThenETThenENTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

		aTest->INFO_PRINTF1(_L("TBidirectionalState test - R-LA EN ET EN test\r\n"));
		
		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);
		 TextIterator euronIterator(KEuropeanNumber, KEuropeanNumberLength);
		 TextIterator eurotIterator(KEuropeanNumberTerminator, KEuropeanNumberTerminatorLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while(!rtolIterator.Wrapped())
			{
			TInt i;

			TInt lasti = 0;
			for (i = 0 ; i < KBufferSize-3; )
				{
				if (!rtolIterator.NextCharInto(aOldText, i))
					break;
				if (!euronIterator.NextCharInto(aOldText, i))
					break;
				if (!eurotIterator.NextCharInto(aOldText, i))
					break;
				if (!euronIterator.NextCharInto(aOldText, i))
					break;
				lasti = i;
				}
			i = lasti;
			aOldText.SetLength(i);

			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), i, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
		
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), lText, i));
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), rText, i));

			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			aOldText.SetLength(oldTextLength);
			}
		}
/**
 *
 * Tests what happens to European Terminators in a pair of Arabic Numbers 
 * when the first character is a Right To Left Arabic letter
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void RToLAThenANThenETThenANTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;

		aTest->INFO_PRINTF1(_L("TBidirectionalState test - R-LA AN ET AN test\r\n"));
		
		// Now mix in some numbers
		 TextIterator rtolIterator(KRightToLeftArabic, KRightToLeftArabicLength);
		 TextIterator arabnIterator(KArabicNumber, KArabicNumberLength);
		 TextIterator eurotIterator(KEuropeanNumberTerminator, KEuropeanNumberTerminatorLength);

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while(!rtolIterator.Wrapped())
			{
			TInt i;

			for (i = 0 ; i < (KBufferSize-3) ; i+=4)
				{
				aOldText[i] = rtolIterator.NextChar();
				aOldText[i+1] = arabnIterator.NextChar();
				aOldText[i+2] = eurotIterator.NextChar();
				aOldText[i+3] = arabnIterator.NextChar();
				}
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaRToL, rText);
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaLToR, lText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
#ifdef PRINT_DATA
			_LIT(KOTitleT, "Original (Top)");
			_LIT(KLTitleT, "Left-to-Right (Top)"); 
			_LIT(KRTitleT, "Right-to-Left (Top)");
			_LIT(KOTitleB, "Original (Bottom)");
			_LIT(KLTitleB, "Left-to-Right (Bottom)"); 
			_LIT(KRTitleB, "Right-to-Left (Bottom)");
			

			PrintTestData(KOTitleT, aOldText.Ptr(), 32);
			PrintTestData(KOTitleB, aOldText.Ptr()+KBufferSize-32, 32);

			PrintTestData(KLTitleT, lText, 32);
			PrintTestData(KLTitleB, lText+KBufferSize-32, 32);

			PrintTestData(KRTitleT, rText, 32);
			PrintTestData(KRTitleB, rText+KBufferSize-32, 32);

#endif
		
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), lText, KBufferSize));
			aTest->TEST(TextInReverseOrder(aOldText.Ptr(), rText, KBufferSize));
		
			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);

			
			}
		}


/**
 *
 * Tests what happens to Other Neutrals when mixed into Left To Right and Right To Left text
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
	static void InterspersedNeutralsTest(TDes& aOldText, CTGraphicsBase* aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		aTest->INFO_PRINTF1(_L("TBidirectionalState test - L-R R-L with interspersed Neutrals test\r\n"));
		TInt oldTextLength = aOldText.Length();

		// Neutrals Test

		 // These should go left-to-right when with left-to-right text
		 // and right-to-left with right-to-left text.

		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 TextIterator neutIterator(KOtherNeutrals, KOtherNeutralsLength);
		 TUint16 neut;

		 aTest->TEST(aOldText.Length() >= KBufferSize);

		 while (!ltorIterator.Wrapped())
			{
			TInt i;
			for (i = 0 ; i < KHalfBufferSize; i+=2)
				{
				aOldText[i] = ltorIterator.NextChar();
				//Skip any characters that are mirrored for simplicity of checking
				while(KMirrors().Locate(neut = neutIterator.NextChar()) != KErrNotFound)
					{
					}
				
				aOldText[i+1] = neut;
				}	

			for (i = KHalfBufferSize ; i < KBufferSize; i+=2)
				{
				aOldText[i] = rtolIterator.NextChar();
				//Skip any characters that are mirrored for simplicity of checking
				while(KMirrors().Locate(neut = neutIterator.NextChar()) != KErrNotFound)
					{
					}
				aOldText[i+1] = neut;
				}
			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), KBufferSize, EParaRToL, rText);
		
			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 

			/*
				Note - the tests are made more complex because of the behaviour of the last
				neutral in the first half of the buffer.

				Because the sequence goes <LtoR> <Neutral> <RtoL>, the way that last
				neutral is interpreted depends upon the paragraph direction instead of
				the direction of the adjacent text.

			*/

			aTest->TEST(TextInSameOrder(aOldText.Ptr(), lText, KHalfBufferSize));
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[KHalfBufferSize], &lText[KHalfBufferSize], KHalfBufferSize-1));
			aTest->TEST((aOldText.Ptr()[KBufferSize-1] == lText[KBufferSize-1])); //Last neutral obeys L-R hence stays where it was
			aTest->TEST(TextInReverseOrder(&aOldText.Ptr()[KHalfBufferSize], rText, KHalfBufferSize));
			aTest->TEST((aOldText.Ptr()[KHalfBufferSize-1] == rText[KHalfBufferSize])); //First neutral stays RtoL and stays at the front
			aTest->TEST(TextInSameOrder(aOldText.Ptr(), &rText[KHalfBufferSize+1], KHalfBufferSize-1));


			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			}
		}

/**
 *
 * Tests that the behaviour shown in small numbers of runs also occurs when lots of 
 * left to right and right to left text is intermixed.
 *
 * @param	  "TDes& aOldText"
 *			  Descriptor that points to a buffer at least KBufferSize 16-bit characters long
 *
 * @param     "CTGraphicsBase* aTest"
 *            Pointer to the test object 
 *
 */
static void ComplexTextTest(TDes& aOldText, CTGraphicsBase *aTest)
		{
		TText* lText = 0;
		TText* rText = 0;
		TInt lretval = KErrNone;
		TInt rretval = KErrNone;
		TInt oldTextLength = aOldText.Length();

#ifdef PRINT_RUNS
		_LIT(KRunTitle, "Populating aOldText buffer with embedded runs of characters as follows:\r\n");
		_LIT(KRunFormat, "Run %d begins with %04x\r\n");
		_LIT(KEndRunFormat, "End of Run %d begins with %04x\r\n");
		
#endif // PRINT_RUNS
	
		
		aTest->INFO_PRINTF1(_L("TBidirectionalState test - Complex text test\r\n"));

		aTest->TEST(aOldText.Length() >= KBufferSize);


		 //Build up a lot of levels of L-R and R-L text

		 TextIterator ltorIterator(KLeftToRight, KLeftToRightLength);
		 TextIterator rtolIterator(KRightToLeft, KRightToLeftLength);
		 const TInt KRuns = 64;
		 const TInt KRunSize = ((KBufferSize/KRuns)/2 ); 
		 TInt runStart[KRuns];
		 TInt runEnd[KRuns];
		 TInt runStartSize[KRuns];
		 TInt runEndSize[KRuns];
		 while (!ltorIterator.Wrapped())
			{
			//Build up start of runs
			 TInt index = 0;
			 TInt run;
#ifdef PRINT_RUNS
			 aTest->INFO_PRINTF1(KRunTitle);
#endif // PRINT_RUNS 
			 for (run = 0 ; run < KRuns ; run++) 
				{
				runStart[run]=index;
				if ((run & 1) == 0)
					{
					ltorIterator.FillInto(aOldText, index, KRunSize*(run+1));
					}
				else
					{
					rtolIterator.FillInto(aOldText, index, KRunSize*(run+1));
					}
				runStartSize[run] = index - runStart[run];
				}
			//Now fill in the ends
			for (TInt brun = KRuns ; brun > 0 ; --brun) 
				{
				run = brun - 1;
				runEnd[run] = index;
				if ((run & 1) == 0)
					{
					ltorIterator.FillInto(aOldText, index, KRunSize*(KRuns*2-run));
					}
				else
					{
					rtolIterator.FillInto(aOldText, index, KRunSize*(KRuns*2-run));
					}
				runEndSize[run] = index - runEnd[run];
				}
			aOldText.SetLength(index);

			lretval = TBidirectionalState::ReorderText(aOldText.Ptr(), index, EParaLToR, lText);
			rretval = TBidirectionalState::ReorderText(aOldText.Ptr(), index, EParaRToL, rText);

			aTest->TEST(lretval == KErrNone); 
			aTest->TEST(rretval == KErrNone); 
			
		
#ifdef PRINT_ARRAYS
			_LIT(KHexTitleo, "Contents of aOldText");
			_LIT(KHexTitlel, "Contents of lText");
			_LIT(KHexTitler, "Contents of rText");

			PrintTestData(KHexTitleo, aOldText);
			PrintTestData(KHexTitlel, lText, KBufferSize);
			PrintTestData(KHexTitler, rText, KBufferSize);

#endif // PRINT_ARRAYS
			//LeftToRight Paragraph test - all but last run should be in-place,
			//but the right-to-left text is reversed.

			for (run = 0 ; run < (KRuns-1) ; ++run)
				{

				aTest->TEST( (KRunSize <= aOldText.Length() - runStart[run]) && (KRunSize <= KBufferSize - runStart[run]));
				aTest->TEST( (KRunSize <= aOldText.Length() - runEnd[run]) && (KRunSize <= KBufferSize - runEnd[run]));
				if ((run & 1) == 0)
					{
					aTest->TEST(TextInSameOrder (&aOldText.Ptr()[runStart[run]], &lText[runStart[run]], runStartSize[run]));
					aTest->TEST(TextInSameOrder (&aOldText.Ptr()[runEnd[run]], &lText[runEnd[run]], runEndSize[run]));
					}
				else
					{
					aTest->TEST(TextInReverseOrder (&aOldText.Ptr()[runStart[run]], &lText[runStart[run]], runStartSize[run]));
					aTest->TEST(TextInReverseOrder (&aOldText.Ptr()[runEnd[run]], &lText[runEnd[run]], runEndSize[run]));
					}
				}

			run = KRuns-1; //now do last run, which is double-sized 

			aTest->TEST( (KRunSize*2 <= aOldText.Length() - runStart[run]) && (KRunSize*2 <= KBufferSize - runStart[run]));
			if ((run & 1) == 0)
				{
				aTest->TEST(TextInSameOrder (&aOldText.Ptr()[runStart[run]], &lText[runStart[run]], runStartSize[run]+runEndSize[run]));
				}
			else
				{
				aTest->TEST(TextInReverseOrder (&aOldText.Ptr()[runStart[run]], &lText[runStart[run]], runStartSize[run]+runEndSize[run]));
				}

			//Right-To-Left Paragraph test - all runs are exchanged about the centre,
			//so the last end run is swapped with the first run and so on
			//and the right-to-left text is reversed.
			for (run = 0 ; run < (KRuns-1) ; ++run)
				{

				aTest->TEST( (KRunSize <= aOldText.Length() - runStart[run]) && (KRunSize <= KBufferSize - runEnd[run]));
				aTest->TEST( (KRunSize <= aOldText.Length() - runEnd[run]) && (KRunSize <= KBufferSize - runStart[run]));
				if ((run & 1) == 0)
					{
					aTest->TEST(TextInSameOrder (&aOldText.Ptr()[runStart[run]], &rText[index-runStart[run+1]], runStartSize[run]));
					aTest->TEST(TextInSameOrder (&aOldText.Ptr()[runEnd[run]], &rText[index-runEnd[run]-runEndSize[run]], runEndSize[run]));
					}
				else
					{
					aTest->TEST(TextInReverseOrder (&aOldText.Ptr()[runStart[run]], &rText[index-runStart[run+1]], runStartSize[run]));
					aTest->TEST(TextInReverseOrder (&aOldText.Ptr()[runEnd[run]], &rText[index-runEnd[run]-runEndSize[run]], runEndSize[run]));
					}
				}

			run = KRuns-1; //now do last run, which is double-sized 

			aTest->TEST( (KRunSize*2 <= aOldText.Length() - runStart[run]) && (KRunSize*2 <= KBufferSize - runStart[run]));

			if ((run & 1) == 0)
				{

				aTest->TEST(TextInSameOrder (&aOldText.Ptr()[runStart[run]], &rText[index-runEnd[run-1]], runStartSize[run]+runEndSize[run]));
				}
			else
				{
				aTest->TEST(TextInReverseOrder (&aOldText.Ptr()[runStart[run]], &rText[index-runEnd[run-1]], runStartSize[run]+runEndSize[run]));
				}
			DeleteText(aOldText.Ptr(), lText, aTest);
			DeleteText(aOldText.Ptr(), rText, aTest);
			aOldText.SetLength(oldTextLength);
			}
		}

/**
   @SYMTestCaseID          	GRAPHICS-GDI-BiDi-0003

   @SYMDEF					DEF105603

   @SYMTestCaseDesc			Test TBidirectionalState functionality (Unicode Bidirectional Algorithm impmentation withing SymbianOS)

   @SYMTestPriority			High

   @SYMTestStatus       	Implemented

   @SYMTestActions      	Test reordering text based on various combinations of formatting codes & characters

   @SYMTestExpectedResults	Confirmation the implementation conforms to the Unicode Birdirection Algorithm standard
*/
static void TestReorderTextL(CTGraphicsBase* aTest)
		{
		//Create buffer to hold test data

		HBufC* oldTextBufPtr = HBufC::NewLC(KBufferSize);

		//Force buffer to desired aSize
		for (int i = 0 ; i < KBufferSize ; ++i)
			{
			oldTextBufPtr->Des().Append(0);
			}

		TPtr oldText(oldTextBufPtr->Des()); 
		
		aTest->INFO_PRINTF1(_L("TBidirectionalState::ReorderText"));

		LeftToRightReorderTest(oldText, aTest);
		SimpleEuropeanNumberTest(oldText, aTest);
		SimpleRightToLeftTest(oldText, aTest);
		SimpleRightToLeftArabicTest(oldText, aTest);

		MirroredCharacterTest(oldText, aTest);

		LROLeftToRightTest(oldText, aTest);
		LRORightToLeftTest(oldText, aTest);
		RLORightToLeftTest(oldText, aTest);
		RLORightToLeftArabicTest(oldText, aTest);
		RLOLeftToRightTest(oldText, aTest);

		LToRThenRToLTest(oldText, aTest);
		LToRThenRToLATest(oldText, aTest);
		RToLAThenLToRTest(oldText, aTest);

		LToRThenRToLThenLToRThenRToLTest(oldText, aTest);
		RToLThenLToRThenRToLThenLToRTest(oldText, aTest);

		SimpleNumberTest(oldText, aTest);

		RToLAThenANThenENThenRToLATest(oldText, aTest);
		RToLAThenENThenANThenRToLATest(oldText, aTest);
		RToLThenANThenENThenRToLTest(oldText, aTest);
		RToLThenENThenANThenRToLTest(oldText, aTest);
		LToRThenANThenENThenLToRTest(oldText, aTest);
		LToRThenENThenANThenLToRTest(oldText, aTest);
		LToRThenANThenENThenRToLTest(oldText, aTest);
		LToRThenENThenANThenRToLTest(oldText, aTest);
		LToRThenANThenENThenRToLATest(oldText, aTest);
		LToRThenENThenANThenRToLATest(oldText, aTest);
		RToLThenANThenENThenLToRTest(oldText, aTest);
		RToLThenENThenANThenLToRTest(oldText, aTest);
		RToLAThenANThenENThenLToRTest(oldText, aTest);
		RToLAThenENThenANThenLToRTest(oldText, aTest);
		RToLThenENThenETThenENTest(oldText, aTest);
		RToLThenANThenETThenANTest(oldText, aTest);
		RToLAThenENThenETThenENTest(oldText, aTest);
		RToLAThenANThenETThenANTest(oldText, aTest);

		ComplexTextTest(oldText, aTest);

		aTest->INFO_PRINTF1(_L("TBidirectionalState::ReorderText tests complete\r\n"));

		CleanupStack::PopAndDestroy();
		}
	};

/**
 * Test behaviour of text reordering under normal & OOM conditions
 *
 * @param	"MOOMTest& aOOMTest" 
 *			Reference to the BD test object 
*/
void CTBiDi::TestOOML(MOOMTest& aOOMTest)
	{
	aOOMTest.SetUpL();
	aOOMTest.ManipulateL();
	aOOMTest.TearDown();
	TInt successesRequired = aOOMTest.ConsecutivePassesRequired();
	__ASSERT_DEBUG(0 < successesRequired, User::Panic(_L("TBiDi"), KErrGeneral));
	TInt consecutiveSuccesses = 0;
	for (TInt i = 1; consecutiveSuccesses != successesRequired; ++i)
		{
		TInt pHCountStart;
		TInt tHCountStart;
		RThread().HandleCount(pHCountStart,tHCountStart);
		__UHEAP_MARK;

		aOOMTest.SetUpL();
		__UHEAP_SETFAIL(RHeap::EDeterministic, i);
		TRAPD(err, aOOMTest.ManipulateL());
		if (err == KErrNone)
			{
			aOOMTest.TestIfPassedL(this);
			++consecutiveSuccesses;
			}
		else
			{
			aOOMTest.TestLeftCleanlyL(this);
			consecutiveSuccesses = 0;
			}
		aOOMTest.TearDown();
		__UHEAP_SETFAIL(RHeap::ENone, 0);

		// test no memory or handles leaked
		__UHEAP_MARKENDC(0);
		TInt pHCountEnd;
		TInt tHCountEnd;
		RThread().HandleCount(pHCountEnd,tHCountEnd);
		TEST(pHCountStart == pHCountEnd);
		TEST(tHCountStart == tHCountEnd);
  		}
	}

class TReorderTextOOMTest : public MOOMTest
	{
	const TDesC* iText;
	TBool iRightToLeft;
	const TDesC* iReorderedText;
	TText* iBuffer;
	TInt iReturnValue;
public:
	TReorderTextOOMTest(const TDesC& aText, TBool aRightToLeft,	const TDesC& aReorderedText) 
		: iText(&aText), iRightToLeft(aRightToLeft), iReorderedText(&aReorderedText),
		iBuffer(0), iReturnValue(0) 
		{}
	virtual ~TReorderTextOOMTest() { TearDown(); }
	void Initialize(const TDesC& aText, TBool aRightToLeft,
		const TDesC& aReorderedText)
		{
		TearDown();
		iText = &aText;
		iRightToLeft = aRightToLeft;
		iReorderedText = &aReorderedText;
		}
	void SetUpL()
		{
		iBuffer = 0;
		iReturnValue = 0;
		}
	void ManipulateL()
		{
		iReturnValue = TBidirectionalState::ReorderText(iText->Ptr(),
			iText->Length(), iRightToLeft, iBuffer);
		User::LeaveIfError(iReturnValue);
		}
	static TBool IsIgnorable(TText a)
		{
		if (a == 0xFFFF)
			return ETrue;
		if (a < 0x202A || 0x202E < a)
			return EFalse;
		return ETrue;
		}
	static TBool StringsMatch(const TText* a1, TInt a1Len,
		const TText* a2, TInt a2Len)
		{
		const TText* a1End = a1 + a1Len;
		const TText* a2End = a2 + a2Len;
		for (;;)
			{
			while (a1 != a1End && IsIgnorable(*a1))
				++a1;
			while (a2 != a2End && IsIgnorable(*a2))
				++a2;
			if (a1 == a1End)
				return a2 == a2End;
			else if (a2 == a2End)
				return EFalse;
			if (*a1 != *a2)
				return EFalse;
			++a1;
			++a2;
			}
		}

	void TestIfPassedL(CTGraphicsBase* aTest)
		{
		// test the reordered text was returned in iBuffer (as per SDK documentation for TBidirectionalState::ReorderText)
		aTest->TEST(iBuffer != 0);
		aTest->TEST( StringsMatch(iBuffer, iText->Length(), iReorderedText->Ptr(), iReorderedText->Length()) );
		}

	void TestLeftCleanlyL(CTGraphicsBase* aTest)
		{
		// test the original text was returned in iBuffer (as per SDK documentation for TBidirectionalState::ReorderText)
		aTest->TEST(iBuffer != 0);
		aTest->TEST( StringsMatch(iBuffer, iText->Length(), iText->Ptr(), iText->Length()) );
		}

	void TearDown()
		{
		if (iBuffer != iText->Ptr())
			delete[] iBuffer;
		iBuffer = 0;
		}
	};

/**
 *
 * Prints some details about an array of TBidirectionalState::TRunInfo objects to the test console.
 * This function prints each character of text with category code and Bidirectional category
 *
 *
 *  @param		"const TBidirectionalState::TRunInfo* aRunArray"
 *				Points to the array of run info objects
 *
 *  @param		"const TInt aRuns"
 *				Number of objects in the array
 *
 *  @param		"const TText* aText"
 *              The text which after being analysed by the Bidirectional Algorithm resulted in
 *				the array of run info objects.
 * 
 *  @param		"const TBool aInternal"
 *              The iCategory element of a run info object may be encoded in two ways, either
 *              the codes used by TChar or those used by TBidirectionalState. If this flag is ETrue
 *				the value is interpreted as a TBidirectionalState code.
 *
 */
void CTBiDi::PrintRunCategories(const TBidirectionalState::TRunInfo* aRunArray, const TInt aRuns, const TText* aText, const TBool aInternal)
	{
		TBuf16<100> line2;
		TBuf16<100> line3;
		TBuf16<100> line4;
		TBuf16<100> line5;
		line2.Fill(' ',100);
		line3.Fill(' ',100);
		line4.Fill(' ',100);
		line5.Fill(' ',100);
		for (int ii = 0 ; ii < aRuns ; ++ii)
			{
			TUint cat = aRunArray[ii].iCategory;
			if (aInternal)
				{
				cat = 1 << cat; //translate from the form used by TChar to that used internally
								//in TBidirectionalText.
				}
			for (int jj = aRunArray[ii].iStart ;
					(jj < aRunArray[ii].iStart+aRunArray[ii].iLength) ; ++jj)
				{
				line2[jj] = aText[jj];
				switch(cat)
					{
					
					case ELeftToRight:
						line3[jj] = 'L';
						line4[jj] = ' ';
						line5[jj] = ' ';
						break;
					case ELeftToRightEmbedding:
						line3[jj] = 'L';
						line4[jj] = 'R';
						line5[jj] = 'E';
						break;
					case ELeftToRightOverride:
						line3[jj] = 'L';
						line4[jj] = 'R';
						line5[jj] = 'O';
						break;
					case ERightToLeft:
						line3[jj] = 'R';
						line4[jj] = ' ';
						line5[jj] = ' ';
						break;
					case ERightToLeftArabic:
						line3[jj] = 'A';
						line4[jj] = 'L';
						line5[jj] = ' ';
						break;
					case ERightToLeftEmbedding:
						line3[jj] = 'R';
						line4[jj] = 'L';
						line5[jj] = 'E';
						break;
					case ERightToLeftOverride:
						line3[jj] = 'R';
						line4[jj] = 'L';
						line5[jj] = 'O';
						break;
					case EPopDirectionalFormat:
						line3[jj] = 'P';
						line4[jj] = 'D';
						line5[jj] = 'F';
						break;
					case EEuropeanNumber:
						line3[jj] = 'E';
						line4[jj] = 'N';
						line5[jj] = ' ';
						break;
					case EEuropeanNumberSeparator:
						line3[jj] = 'E';
						line4[jj] = 'S';
						line5[jj] = ' ';
						break;
					case EEuropeanNumberTerminator:
						line3[jj] = 'E';
						line4[jj] = 'T';
						line5[jj] = ' ';
						break;
					case EArabicNumber:
						line3[jj] = 'A';
						line4[jj] = 'N';
						line5[jj] = ' ';
						break;
					case ECommonNumberSeparator:
						line3[jj] = 'C';
						line4[jj] = 'S';
						line5[jj] = ' ';
						break;
					case ENonSpacingMark:
						line3[jj] = 'N';
						line4[jj] = 'S';
						line5[jj] = 'M';
						break;
					case EBoundaryNeutral:
						line3[jj] = 'B';
						line4[jj] = 'N';
						line5[jj] = ' ';
						break;
					case EParagraphSeparator:
						line3[jj] = 'B';
						line4[jj] = ' ';
						line5[jj] = ' ';
						break;
					case ESegmentSeparator:
						line3[jj] = 'S';
						line4[jj] = ' ';
						line5[jj] = ' ';
						break;
					case EWhitespace:
						line3[jj] = 'W';
						line4[jj] = 'S';
						line5[jj] = ' ';
						break;
					case EOtherNeutral:
						line3[jj] = 'O';
						line4[jj] = 'N';
						line5[jj] = ' ';
						break;
					case EStartOfParagraph:
						line3[jj] = 'S';
						line4[jj] = 'O';
						line5[jj] = 'P';
						break;
					case EEndOfParagraph:
						line3[jj] = 'E';
						line4[jj] = 'O';
						line5[jj] = 'P';
						break;
					default:
						line3[jj] = '?';
						line4[jj] = ' ';
						line5[jj] = ' ';
						break;
				}
			}
		}
		line2.TrimRight();
		line3.TrimRight();
		line4.TrimRight();
		line5.TrimRight();
		line2.ZeroTerminate();
		line3.ZeroTerminate();
		line4.ZeroTerminate();
		line5.ZeroTerminate();
		INFO_PRINTF2(KSingleString, line2.Ptr());
		INFO_PRINTF2(KSingleString, line3.Ptr());
		INFO_PRINTF2(KSingleString, line4.Ptr());
		INFO_PRINTF2(KSingleString, line5.Ptr());
	}

/**
 *
 * Prints some details about an array of TBidirectionalState::TRunInfo objects to the test console.
 * This function prints each character of text with the embedding level and Bidirectional category
 *
 *
 *  @param		"const TBidirectionalState::TRunInfo* aRunArray"
 *				Points to the array of run info objects
 *
 *  @param		"const TInt aRuns"
 *				Number of objects in the array
 *
 *  @param		"const TText* aText"
 *              The text which after being analysed by the Bidirectional Algorithm resulted in
 *				the array of run info objects.
 * 
*
 */
void CTBiDi::PrintRunArray(const TBidirectionalState::TRunInfo* aRunArray, const TInt aRuns, const TText*  aText)
	{
	if (aRunArray)
		{
#ifdef PRINT_RUN_DETAILS
		_LIT(KRunFmt, "Run %d - Category %d Level %d Direction %d Index %d Start %d Length %d");
#endif // PRINT_RUN_DETAILS

		TBuf16<100> line1;
		TBuf16<100> line2;
		TBuf16<100> line3;
		TBuf16<100> line4;
		TBuf16<100> line5;
		line1.Zero();
		line2.Zero();
		line3.Zero();
		line4.Zero();
		line5.Zero();
		for (int ii = 0 ; ii < aRuns ; ++ii)
			{
#ifdef PRINT_RUN_DETAILS
			aTest->INFO_PRINTF1(KRunFmt, ii, aRunArray[ii].iCategory,
				aRunArray[ii].iEmbeddingLevel,
				aRunArray[ii].iDirection,
				aRunArray[ii].iIndex,
				aRunArray[ii].iStart,
				aRunArray[ii].iLength);
#endif // PRINT_RUN_DETAILS
			//mark up each character slot with embedding level.
			//Only works well for small values of the embedding level!
			for (int jj = aRunArray[ii].iStart ;
					(jj < aRunArray[ii].iStart+aRunArray[ii].iLength) ; ++jj)
				{
				line1.Append(aText[jj]);
				line2.Append(static_cast<TUint16>(aRunArray[ii].iEmbeddingLevel + '0'));
				switch(aRunArray[ii].iCategory)
					{
					
					case ELeftToRight:
						line3.Append('L');
						line4.Append(' ');
						line5.Append(' ');
						break;
					case ELeftToRightEmbedding:
						line3.Append('L');
						line4.Append('R');
						line5.Append('E');
						break;
					case ELeftToRightOverride:
						line3.Append('L');
						line4.Append('R');
						line5.Append('O');
						break;
					case ERightToLeft:
						line3.Append('R');
						line4.Append(' ');
						line5.Append(' ');
						break;
					case ERightToLeftArabic:
						line3.Append('A');
						line4.Append('L');
						line5.Append(' ');
						break;
					case ERightToLeftEmbedding:
						line3.Append('R');
						line4.Append('L');
						line5.Append('E');
						break;
					case ERightToLeftOverride:
						line3.Append('R');
						line4.Append('L');
						line5.Append('O');
						break;
					case EPopDirectionalFormat:
						line3.Append('P');
						line4.Append('D');
						line5.Append('F');
						break;
					case EEuropeanNumber:
						line3.Append('E');
						line4.Append('N');
						line5.Append(' ');
						break;
					case EEuropeanNumberSeparator:
						line3.Append('E');
						line4.Append('S');
						line5.Append(' ');
						break;
					case EEuropeanNumberTerminator:
						line3.Append('E');
						line4.Append('T');
						line5.Append(' ');
						break;
					case EArabicNumber:
						line3.Append('A');
						line4.Append('N');
						line5.Append(' ');
						break;
					case ECommonNumberSeparator:
						line3.Append('C');
						line4.Append('S');
						line5.Append(' ');
						break;
					case ENonSpacingMark:
						line3.Append('N');
						line4.Append('S');
						line5.Append('M');
						break;
					case EBoundaryNeutral:
						line3.Append('B');
						line4.Append('N');
						line5.Append(' ');
						break;
					case EParagraphSeparator:
						line3.Append('B');
						line4.Append(' ');
						line5.Append(' ');
						break;
					case ESegmentSeparator:
						line3.Append('S');
						line4.Append(' ');
						line5.Append(' ');
						break;
					case EWhitespace:
						line3.Append('W');
						line4.Append('S');
						line5.Append(' ');
						break;
					case EOtherNeutral:
						line3.Append('O');
						line4.Append('N');
						line5.Append(' ');
						break;
					case EStartOfParagraph:
						line3.Append('S');
						line4.Append('O');
						line5.Append('P');
						break;
					case EEndOfParagraph:
						line3.Append('E');
						line4.Append('O');
						line5.Append('P');
						break;
					default:
						line3.Append('?');
						line4.Append(' ');
						line5.Append(' ');
						break;
				} 
			}
		}

		line1.ZeroTerminate();
		line2.ZeroTerminate();
		line3.ZeroTerminate();
		line4.ZeroTerminate();
		line5.ZeroTerminate();
		INFO_PRINTF2(KSingleString, line1.Ptr());
		INFO_PRINTF2(KSingleString, line2.Ptr()); 
		INFO_PRINTF2(KSingleString, line3.Ptr());
		INFO_PRINTF2(KSingleString, line4.Ptr());
		INFO_PRINTF2(KSingleString, line5.Ptr());
	} 

}


#define TEST_BUF_LEN 80

/**
The Unicode Example test class

This class contains functions that support tests based on the examples given by 
Unicode Standard Annexe 9

Those examples use UPPER CASE latin letters to represent Arabic letters and quotes
to represent embedding levels.

The functions of this class allow the example to be transcoded using real Arabic letters and
LRE and RLE embedding codes before applying the bidirectional algorithm.

*/
class TUnicodeExampleOOMTest : public MOOMTest
	{
	TBuf<TEST_BUF_LEN> iText;
	TBuf<TEST_BUF_LEN> iOriginalText;
	TBuf<TEST_BUF_LEN> iPrintData;
	TBool iRightToLeft;
	TBuf<TEST_BUF_LEN> iReorderedText;
	TText* iBuffer;
	TInt iReturnValue;
	TInt iAlef; 
	TPtrC iArabicChars;
	TBool iFirst;
	enum {
		EAlef = 0x627
		};

public:
	TUnicodeExampleOOMTest(const TDesC& aText, TBool aRightToLeft,
		const TDesC& aReorderedText, CTGraphicsBase* aTest)
		: iOriginalText(aText),
		iRightToLeft(aRightToLeft),
		iBuffer(0),
		iReturnValue(0),
		iArabicChars(KRightToLeftArabic, KRightToLeftArabicLength)
		{
		//Find position of arabic letters in table
		iAlef = iArabicChars.Locate(EAlef);
		iText.SetLength(iText.MaxLength()); //set buffer to max size to begin with ensuring first copy fills whole buffer
		iReorderedText.SetLength(iReorderedText.MaxLength());  //set buffer to max size to begin with
		CopyAndMapToArabic(iText, aText, aTest);
		CopyAndMapToArabic(iReorderedText, aReorderedText, aTest);
		}
	virtual ~TUnicodeExampleOOMTest() { TearDown(); }
	void Initialize(const TDesC& aText, TBool aRightToLeft,
		const TDesC& aReorderedText, CTGraphicsBase* aTest)
		{
		TearDown();
		iOriginalText = aText;
		CopyAndMapToArabic(iText, aText, aTest);
		iRightToLeft = aRightToLeft;
		CopyAndMapToArabic(iReorderedText, aReorderedText, aTest);
		}
	void SetUpL()
		{
		iBuffer = 0;
		iReturnValue = 0;
		}
	void ManipulateL()
		{
		iReturnValue = TBidirectionalState::ReorderText(iText.Ptr(),
			iText.Length(), iRightToLeft, iBuffer);
		User::LeaveIfError(iReturnValue);
		}

	TUint MapToArabic(TUint aChar)
		{
		TUint newChar = aChar;
		if (TChar(aChar).IsUpper())
			{
			newChar = KRightToLeftArabic[aChar-'A'+iAlef]; //Note this isn't a linguistic transliteration.
			};
		return newChar;
		}
	TUint MapFromArabic(TUint aChar)
		{
		TInt pos = iArabicChars.Locate(aChar) - iAlef;
		TUint newChar = aChar;
		if ((pos >= 0) && (pos < 26))
			{
			newChar = 'A'+pos;
			};
		return newChar;

		}

	void CopyAndMapToArabic(TDes& aBuffer, const TDesC& aDes, CTGraphicsBase* aTest)
		{
		TInt quoteLevel = 0;
		TChar lastQuote = 0;
		aTest->TEST(aDes.Length() <= aBuffer.MaxLength());

		aBuffer.Fill(0xFFFF); //fill old contents to help debugging if new string is shorter

		aBuffer.Zero();

		for (TInt i = 0 ; i < aDes.Length() ; ++i)
			{
			TUint newChar = MapToArabic(aDes[i]);
			if ((newChar == '\'') || (newChar == '"'))
				{
				//Quote handling
				if (newChar == lastQuote)
					{
					//match so drop a level if there is a level to drop
					if (quoteLevel > 0)
						{
						aBuffer.Append(0x202c); //emit a PLD
						aBuffer.Append(newChar);
						--quoteLevel;
						lastQuote = ((lastQuote == '"') ? '\'' : '"' );
						}
					}
				else
					{
					//start new level
					aBuffer.Append(newChar);
					if (newChar == '\'')
						{
						aBuffer.Append(0x202a); //emit LRE
						}
					else
						{
						aBuffer.Append(0x202b); //emit RLE
						}
					++quoteLevel;
					lastQuote = newChar;
					}
				}
			else
				{
				aBuffer.Append(newChar);
				}
			}
		
		}
	void PrintMappedData(const TDesC& aTitle, const TDesC& aBuffer, CTGraphicsBase* aTest)
		{
		iPrintData.Zero();
		for (TInt i = 0 ; i < aBuffer.Length() ; ++i)
			{
			TText a = aBuffer[i];

			if (!IsIgnorable(a))
				{
				iPrintData.Append(MapFromArabic(a));
				}
			}
		iPrintData.ZeroTerminate();
		aTest->INFO_PRINTF3(KDoubleString, aTitle.Ptr(), iPrintData.Ptr());
		}
	static TBool IsIgnorable(TText a)
		{
		TBool ignorable = EFalse;
		switch(a) {
			case KUnicodeNoSuchCharacter:
			case KUnicodeLeftToRightMark:
			case KUnicodeRightToLeftMark:
			case KUnicodeLeftToRightEmbedding:
			case KUnicodeRightToLeftEmbedding:
			case KUnicodePopDirectionFormat:
			case KUnicodeLeftToRightOverride:
			case KUnicodeRightToLeftOverride:
				ignorable = ETrue;
				break;
			default:
				break;
			}
		return ignorable;
		}
	static TBool StringsMatch(const TText* a1, TInt a1Len,
		const TText* a2, TInt a2Len)
		{
		const TText* a1End = a1 + a1Len;
		const TText* a2End = a2 + a2Len;
		for (;;)
			{
			while (a1 != a1End && IsIgnorable(*a1))
				++a1;
			while (a2 != a2End && IsIgnorable(*a2))
				++a2;
			if (a1 == a1End)
				return a2 == a2End;
			else if (a2 == a2End)
				return EFalse;
			if (*a1 != *a2)
				return EFalse;
			++a1;
			++a2;
			}
		}
	void TestIfPassedL(CTGraphicsBase* aTest)
		{
#ifdef PRINT_EXAMPLE
		_LIT(KTestPassR, "Test Passed - result");
		_LIT(KTestFailE, "Test Failed - expected");
		_LIT(KTestFailR, "Test Failed - result");
#endif // PRINT_EXAMPLE
		aTest->TEST(iBuffer != 0);
		TBool match = StringsMatch(iBuffer, iText.Length(), iReorderedText.Ptr(), iReorderedText.Length());

		if (match)
			{
#ifdef PRINT_EXAMPLE
			PrintMappedData(KTestPassR, TPtrC(iBuffer, iText.Length()));
#endif // PRINT_EXAMPLE
			}
		else
			{
#ifdef PRINT_EXAMPLE
			PrintMappedData(KTestFailE, iReorderedText);
			PrintMappedData(KTestFailR, TPtrC(iBuffer, iText.Length()));
#endif // PRINT_EXAMPLE
			aTest->TEST(EFalse);
			}

		}
	void TearDown()
		{
		if (iBuffer != iText.Ptr())
			delete[] iBuffer;
		iBuffer = 0;
		}
	};



//Unicode Spec sample data
// This uses UPPER CASE english to represent right to left Arabic characters
// A straight mapping to tabularly equivalent Arabic letters is done during the 
// tests using this data. KxxS is the "Storage" value, KxxD is the "Display" value.
// Also all the values like <RLE> are ignored in the comparison, so aren't included in the D value 
// Embedding codes:
// <RLE> \x202b <LRE> \0x202a <PDF> \0x202c <RLO> \x202e <LRO> \x202d <RLM> \0x200f <LRM> \0x200e

_LIT(KU1S, "he said \"THE VALUES ARE 123, 456, 789, OK\".");
_LIT(KU1D, "he said \"KO ,789 ,456 ,123 ERA SEULAV EHT\".");
_LIT(KU2S, "he said \"IT IS A bmw 500, OK.\"");
_LIT(KU2D, "he said \".KO ,bmw 500 A SI TI\"");
_LIT(KU3S, "car means CAR.");
_LIT(KU3D, "car means RAC.");
_LIT(KU4S, "car MEANS CAR.");
_LIT(KU4D, ".RAC SNAEM car");
//_LIT(KU5S, "he said \"car MEANS CAR.\"");
//_LIT(KU5D, "he said \"RAC SNAEM car.\"");
_LIT(KU6S, "DID YOU SAY 'he said \"car MEANS CAR\"'?");
_LIT(KU6D, "?'he said \"RAC SNAEM car\"' YAS UOY DID");
_LIT(KU7S, "he said `I NEED WATER!`, and expired.");
_LIT(KU7D, "he said `RETAW DEEN I!`, and expired.");
_LIT(KU8S, "he said `\x202bI NEED WATER!\x202c`, and expired.");
_LIT(KU8D, "he said `!RETAW DEEN I`, and expired.");
_LIT(KU9S, "he said `I NEED WATER!\x200f`, and expired.");
_LIT(KU9D, "he said `!RETAW DEEN I`, and expired.");
_LIT(KU10S,"DID YOU SAY '\x202ahe said \"I NEED WATER!\x200f\", and expired.\x202c'?");
_LIT(KU10D,"?'he said \"!RETAW DEEN I\", and expired.' YAS UOY DID");

/**
   @SYMTestCaseID          	GRAPHICS-GDI-BiDi-0005

   @SYMDEF					DEF105603

   @SYMTestCaseDesc			Test TBidirectionalState functionality (Unicode Bidirectional Algorithm impmentation withing SymbianOS)

   @SYMTestPriority			High

   @SYMTestStatus       	Implemented

   @SYMTestActions      	Test behaviour of text-reordering under normal & OOM conditions using examples derived from Unicode Standard Annex 9

   @SYMTestExpectedResults	Confirmation the implementation conforms to the Unicode Birdirection Algorithm standard
*/
void CTBiDi::TUnicodeExampleTestL()
	{
	TUnicodeExampleOOMTest toom(KU1S, EFalse, KU1D, this);
	TestOOML(toom);
	toom.Initialize(KU2S, EFalse, KU2D, this);
	TestOOML(toom);
	toom.Initialize(KU3S, EFalse, KU3D, this);
	TestOOML(toom);
	toom.Initialize(KU4S, ETrue, KU4D, this);
	TestOOML(toom);
//  This test commented out because there seems to be no way to persuade a computer 
//  to reproduce this example, it only makes sense to human beings.
//	toom.Initialize(KU5S, EFalse, KU5D);
//	TestOOML(toom);
	toom.Initialize(KU6S, ETrue, KU6D, this);
	TestOOML(toom);
	toom.Initialize(KU7S, EFalse, KU7D, this);
	TestOOML(toom);
	toom.Initialize(KU8S, EFalse, KU8D, this);
	TestOOML(toom);
	toom.Initialize(KU9S, EFalse, KU9D, this);
	TestOOML(toom);
	toom.Initialize(KU10S, ETrue, KU10D, this);
	TestOOML(toom);

	}


_LIT(KHalalL, "\x62D\x644\x627\x644");
_LIT(KHalalD, "\x644\x627\x644\x62D");
_LIT(KHello, "Hello");
_LIT(KHttL, "\x62D\x644\x627\x644 12:30 \x644\x633");
_LIT(KHttD, "\x633\x644 12:30 \x644\x627\x644\x62D");
_LIT(KHttsL, "\x62D\x644\x627\x644 12, 30 \x644\x633");
_LIT(KHttsD, "\x633\x644 30 ,12 \x644\x627\x644\x62D");
_LIT(KEmbedL,"he said \x202B\x644 some text 12 nos \x627 \x202A=Hah is \x62D\x202C \x633\x202C perhaps");
_LIT(KEmbedD,"he said \x633 =Hah is \x62D \x627 some text 12 nos \x644 perhaps");
_LIT(KMixedL, "\x644\x627 ab");
_LIT(KMixedD, "ab \x627\x644");
_LIT(KMixedDL, "\x627\x644 ab");
_LIT(KRLOverrideL, "\x202Ewxyz\x202Cijkl");
_LIT(KRLOverrideD, "zyxwijkl");

/**
   @SYMTestCaseID          	GRAPHICS-GDI-BiDi-0004

   @SYMDEF					DEF105603

   @SYMTestCaseDesc			Test TBidirectionalState functionality (Unicode Bidirectional Algorithm impmentation withing SymbianOS)

   @SYMTestPriority			High

   @SYMTestStatus       	Implemented

   @SYMTestActions      	Test reordering under normal & OOM conditions, using custom strings mixing text with formatting codes

   @SYMTestExpectedResults	Confirmation the implementation conforms to the Unicode Birdirection Algorithm standard
*/
void CTBiDi::TestReorderTextL()
	{
	TReorderTextOOMTest toom(KHalalL, EFalse, KHalalD);
	TestOOML(toom);
	toom.Initialize(KHalalL, ETrue, KHalalD);
	TestOOML(toom);
	toom.Initialize(KHello, ETrue, KHello);
	TestOOML(toom);
	toom.Initialize(KHello, EFalse, KHello);
	TestOOML(toom);
	toom.Initialize(KHttL, ETrue, KHttD);
	TestOOML(toom);
	toom.Initialize(KHttL, EFalse, KHttD);
	TestOOML(toom);
	toom.Initialize(KHttsL, ETrue, KHttsD);
	TestOOML(toom);
	toom.Initialize(KHttsL, EFalse, KHttsD);
	TestOOML(toom);
	toom.Initialize(KMixedL, ETrue, KMixedD);
	TestOOML(toom);
	toom.Initialize(KMixedL, EFalse, KMixedDL);
	TestOOML(toom);
	toom.Initialize(KRLOverrideL, EFalse, KRLOverrideD);
	TestOOML(toom);
	toom.Initialize(KEmbedL, EFalse, KEmbedD);
//	TestOOML(toom);
	}

/**
TBidiTextOOMTest

This class contains functions that support tests based on the examples given by 
Unicode Standard Annexe 9

The class contains methods for creating text with different directionality (left-to-right, right-to-left)
and test functions to determine directionality
*/
class TBidiTextOOMTest : public MOOMTest
	{
public:
/** Overall directionality of the text. */
/** Text reading begins on the left. */
/** Text reading begins on the right. */
	enum TDirectionality { ELeftToRight, ERightToLeft, EAutomatic };
	TBidiTextOOMTest(CTGraphicsBase *aTest) : iInputText(0), iBidi(0), iTest(aTest) {}
	void Initialize(const TDesC& aInput,
		TDirectionality aDirectionality, TInt aMaxLines)
		{
		iInputText = &aInput;
		iDirectionality = aDirectionality;
		iMaxLines = aMaxLines;
		delete iBidi;
		iBidi = 0;
		}

	void SetUpL() {}

	void ManipulateL()
		{
		switch(iDirectionality) {
			case EAutomatic:
				iBidi = TBidiText::NewL(*iInputText, iMaxLines);
				break;
			case ELeftToRight:
				iBidi = TBidiText::NewL(*iInputText, iMaxLines, TBidiText::ELeftToRight);
				break;
			case ERightToLeft:
				iBidi = TBidiText::NewL(*iInputText, iMaxLines, TBidiText::ERightToLeft);
				break;
			default:
				iTest->TEST(EFalse); //Invalid value for iDirectionality
			}
		}

	void TearDown()
		{
		delete iBidi;
		iBidi = 0;
		}

	void TestIfPassedL(CTGraphicsBase* aTest)
		{
		aTest->TEST(iBidi != NULL);
		const TFileName a(iBidi->Text());
		aTest->TEST(a == *iInputText); 
		// tests on the actual display text are run in a separate test case
		}

	void TestLeftCleanlyL(CTGraphicsBase* aTest)
		{
		aTest->TEST(iBidi == NULL);
		}
private:
	const TDesC* iInputText;
	TDirectionality iDirectionality;
	TInt iMaxLines;
	TBidiText* iBidi;
	CTGraphicsBase *iTest;
	};

/**
   @SYMTestCaseID			GRAPHICS-GDI-BiDi-0006

   @SYMDEF					DEF105603

   @SYMTestCaseDesc			Test TBidirectionalState functionality (Unicode Bidirectional Algorithm impmentation withing SymbianOS)

   @SYMTestPriority			High

   @SYMTestStatus       	Implemented

   @SYMTestActions      	Test detection of 'overall' directionality of a given language/script

   @SYMTestExpectedResults	Confirmation the implementation conforms to the Unicode Birdirection Algorithm standard
*/
void CTBiDi::TestScriptDirectionality()
	{
	for (TInt i = 0; i != 100; ++i)
		{
		TBidiText::TDirectionality dir = TBidiText::ScriptDirectionality(
			static_cast<TLanguage>(i));
		TEST(i == ELangArabic || i == ELangHebrew || i == ELangFarsi || i == ELangUrdu?
			dir==TBidiText::ERightToLeft : dir == TBidiText::ELeftToRight);
		}
	}

_LIT(KMultiLine, "Many\x644\x633 runs\xD\xAwith\xDmany\xAtypes\x2028of\x2029\x633\x633 Linebreaks");
_LIT(KLineSep, "\x2028");

/**
 *
 * void CTBiDi::NoLineBreakDrawTestL
 *
 * Test for TBidiText::DrawText
 * 
 * Some Arabic text is drawn without any line break opportunities.
 *
 * The result should still be broken into screenwidths and drawn.
 *
 *
 */
void CTBiDi::NoLineBreakDrawTestL()
	{
	INFO_PRINTF1(_L("TBidiText test - RightToLeftArabic draw test without line break opportunities\r\n"));

	TSize windowSize(400,200);

	RArray<TTestDataRun> runsArray(16);
	CleanupClosePushL(runsArray);
	
	CFont* testFont = new(ELeave) CTestFont;
	CleanupStack::PushL(testFont);


	CTestGraphicsDevice* testDevice = CTestGraphicsDevice::NewL(windowSize);

	CleanupStack::PushL(testDevice);

	CGraphicsContext* tContext = NULL;
	
	TEST(testDevice->CreateContext(tContext) == KErrNone);
	//note - no cleanupstack entry as the context is owned by the device

	CTestGraphicsContext* testContext = static_cast<CTestGraphicsContext*>(tContext);


	//Create buffer to hold test data
	HBufC* oldTextBufPtr = HBufC::NewLC(KBufferSize);

	TPtrC original;
	TPtrC wrapped;

	TextIterator rIterator(KRightToLeftArabic, KRightToLeftArabicLength);

	TInt i;
	TInt length;
	TInt end;
	MLineBreaker breaker;

	//Fill buffer with data
	for (i = 0 ; i < KBufferSize ; ++i)
		{
		TUint s, e;
		TText16 ch = rIterator.NextChar();
		if (breaker.LineBreakClass(ch, s, e) == MLineBreaker::EAlLineBreakClass)
			oldTextBufPtr->Des().Append(ch);
		}

	TPtr oldText(oldTextBufPtr->Des());

	TBidiText* bidi = TBidiText::NewL(oldText, 50);

	CleanupStack::PushL(bidi);

	TInt comparedLength = (oldText.Length() < KBufferSize )? oldText.Length(): KBufferSize;

	TEST(oldText.Length() == bidi->Text().Length());

	TEST(TestTBidirectionalState::TextInSameOrder(oldText.Ptr(), bidi->Text().Ptr(), comparedLength));

	bidi->WrapText(400 , *testFont, 0);

	TEST(bidi->WrappingWidth() == 400);

	original.Set(bidi->Text());

	wrapped.Set(bidi->DisplayText());

#ifdef PRINT_ARRAYS
	_LIT(KOriginalTitle, "Original: \r\n"); 
	_LIT(KDisplayTitle, "Display: \r\n"); 

	PrintTestData(KOriginalTitle, original);
	PrintTestData(KDisplayTitle, wrapped);

#endif // PRINT_ARRAYS
	
	//Using a font where every character is 10 pixels wide and wrapping to 400 pixels width,
	//every 40 characters should be a Linebreak character, and each of those lines should be reversed.

	length = oldText.Length();
	end = wrapped.Length();

	TEST(original.Length() == length);
	TEST(end  >= length);

	const TText* currentWrapped = wrapped.Ptr();
	const TText* wrappedEnd = currentWrapped + wrapped.Length();
	for (i = 0; i < length ; i += 40)
		{
		end = ((length-i) >= 40) ? i+40 : length;

		TTestDataRun runData;

		runData.iStart = i;
		runData.iLength = end-i;

		runsArray.Append(runData); 

		TEST( ( end-i <= oldText.Length() - i) && ( end-i <= wrappedEnd - currentWrapped));
		const TText* endLine = TestTBidirectionalState::TextInReverseOrderIgnoringJoiners(
			oldText.Ptr() + i, currentWrapped, end-i);
		if (!endLine)
			{
			INFO_PRINTF3(_L("TBidiText test - wrapped - reverse order check failed for index %d out-index %d"),
				i, currentWrapped - wrapped.Ptr());
			TEST(EFalse);
			}
		
		if (wrappedEnd <= endLine)
			break;

		if (*endLine != 0x02028)
			{
			INFO_PRINTF3(_L("TBidiText test - wrapped - line terminator check failed for index %d out-index %d"),
				i, currentWrapped - wrapped.Ptr());
			TEST(EFalse);
			}
		currentWrapped = endLine + 1;
		}

	TPoint origin(0,0);
	TInt baseline_offset = testFont->BaselineOffsetInPixels();
	bidi->DrawText(*testContext, origin, baseline_offset);

	//now check that DrawText passed the right data
	for (i = 0 ; i < runsArray.Count() ; i++)
		{
		TPtrC spec(testContext->DisplayLine(i).LineData());
		TEST( ( runsArray[i].iLength <= oldText.Length() - runsArray[i].iStart) && ( runsArray[i].iLength <= spec.Length()));
		TEST(0 != TestTBidirectionalState::TextInReverseOrderIgnoringJoiners(
			oldText.Ptr() + runsArray[i].iStart , spec.Ptr(), runsArray[i].iLength));
		};

	INFO_PRINTF1(_L("TBidiText test - wrapped - display text test passed\r\n"));

	CleanupStack::PopAndDestroy(bidi);
	CleanupStack::PopAndDestroy(oldTextBufPtr); //whatever is pushed by HBufC::NewLC
	delete testContext;
	CleanupStack::PopAndDestroy(testDevice);

	CleanupStack::PopAndDestroy(testFont);
	CleanupStack::PopAndDestroy();  //closes runsArray
	}

/**
 *
 * void CTBiDi::RightToLeftArabicDrawTestL()
 * 
 * Test for TBidiText::DrawText
 * 
 * Some Arabic text is drawn with line break opportunities, but the resulting lines
 * are still longer than the declared screen width. So every line becomes two lines.
 *
 */
void CTBiDi::RightToLeftArabicDrawTestL()
	{
	INFO_PRINTF1(_L("TBidiText test - RightToLeftArabic draw test with linebreak opportunities\r\n"));

	TSize windowSize(400,200);

	RArray<TTestDataRun> runsArray(16);
	CleanupClosePushL(runsArray);
	
	CFont* testFont = new(ELeave) CTestFont;
	CleanupStack::PushL(testFont);

	CTestGraphicsDevice* testDevice = CTestGraphicsDevice::NewL(windowSize);

	CleanupStack::PushL(testDevice);

	CGraphicsContext* tContext;
	
	TEST(testDevice->CreateContext(tContext) == KErrNone);
	//note - no cleanupstack entry as the context is owned by the device

	CTestGraphicsContext* testContext = static_cast<CTestGraphicsContext*>(tContext);


	//Create buffer to hold test data
	HBufC* oldTextBufPtr = HBufC::NewLC(KBufferSize);

	TPtrC original;
	TPtrC wrapped;

	TextIterator rIterator(KRightToLeftArabic, KRightToLeftArabicLength);

	TInt i;
	TInt length;
	TInt end;

	//Fill buffer with groups of 16 characters separated by single spaces
	//Avoid a trailing space
	for (i = 0 ; i < (KBufferSize-1) ; ++i)
		{
			if ( (i & 15) == 15) 
				{
					oldTextBufPtr->Des().Append(0x020);
				}
			else
				{
					oldTextBufPtr->Des().Append(rIterator.NextChar());
				}
		}

	oldTextBufPtr->Des().Append(rIterator.NextChar()); //final character in buffer should not be a space


	TPtr oldText(oldTextBufPtr->Des());

	TBidiText* bidi = TBidiText::NewL(oldText, 50);

	CleanupStack::PushL(bidi);

	TEST( (oldText.Length() == bidi->Text().Length() ) && (oldText.Length() == KBufferSize) );
	TEST(TestTBidirectionalState::TextInSameOrder(oldText.Ptr(), bidi->Text().Ptr(), KBufferSize));

	bidi->WrapText(400 , *testFont, 0);

	TEST(bidi->WrappingWidth() == 400);

	original.Set(bidi->Text());

	wrapped.Set(bidi->DisplayText());

#ifdef PRINT_ARRAYS
	_LIT(KOriginalTitle, "Original: \r\n"); 
	_LIT(KDisplayTitle, "Display: \r\n"); 

	PrintTestData(KOriginalTitle, original);
	PrintTestData(KDisplayTitle, wrapped);

#endif // PRINT_ARRAYS
	
	//Using a font where every character is 10 pixels wide and wrapping to 400 pixels width,
	// The space every 32 characters should be replaced by a linebreak character

	length = oldText.Length();
	end = wrapped.Length();

	TEST(original.Length() == length);

	for (i = 0; i < length ; i += 32)
		{
		TInt left = length-i;
		TTestDataRun runData;
		runData.iStart = i;

		if (left <= 33)
			{
			end = length;
			runData.iLength = end - i;
			}
		else
			{
			end = i+32;
			runData.iLength = 31;
			};

		runsArray.Append(runData); 

		TEST( (runData.iLength <= oldText.Length() - runData.iStart) && (runData.iLength <= wrapped.Length() - runData.iStart) );

		if (!TestTBidirectionalState::TextInReverseOrder(oldText.Ptr() + runData.iStart , wrapped.Ptr() + runData.iStart, runData.iLength))
			{
			INFO_PRINTF2(_L("TBidiText test - wrapped - reverse order check failed for index %d\r\n"), i);
			TEST(EFalse);
			}

		if (length-end < 32)
			{
			break; //don't expect an end of line on the last line
			}

		if (wrapped[i+31] != 0x02028)
			{
			INFO_PRINTF2(_L("TBidiText test - wrapped - line terminator check failed for index %d\r\n"), i);
			TEST(EFalse);
			}
			
		}

	TPoint origin(0,0);
	TInt baseline_offset = testFont->BaselineOffsetInPixels();
	bidi->DrawText(*testContext, origin, baseline_offset);

	//now check that DrawText passed the right data
	for (i = 0 ; i < runsArray.Count() ; i++)
		{
		TPtrC16 spec(testContext->DisplayLine(i).LineData());
		TEST(spec.Length() == runsArray[i].iLength);
		TEST( spec.Length() <= (oldText.Length() - runsArray[i].iStart) );
		TEST(TestTBidirectionalState::TextInReverseOrder(oldText.Ptr() + runsArray[i].iStart , spec.Ptr(), spec.Length()));
		};

	INFO_PRINTF1(_L("TBidiText test - wrapped - display text test passed\r\n"));

	CleanupStack::PopAndDestroy(bidi);
	CleanupStack::PopAndDestroy(); //whatever is pushed by HBufC::NewLC
	delete testContext;
	CleanupStack::PopAndDestroy(testDevice);
	CleanupStack::PopAndDestroy(testFont);
	CleanupStack::PopAndDestroy(); //closes runsArray

	}

/**
 *
 * void CTBiDi::LeftToRightDrawTestL()
 *
 * Test for TBidiText::DrawText
 * 
 * Some Latin text is drawn with line breaks
 *
 */
void CTBiDi::LeftToRightDrawTestL()
	{//as well as left to right text, this uses a variety of break opportunities.
	INFO_PRINTF1(_L("TBidiText test - LeftToRight draw test\r\n"));

	TSize windowSize(100,400);

	RArray<TTestDataRun> runsArray(16);
	CleanupClosePushL(runsArray);
	
	CFont* testFont = new(ELeave) CTestFont;
	CleanupStack::PushL(testFont);


	CTestGraphicsDevice* testDevice = CTestGraphicsDevice::NewL(windowSize);

	CleanupStack::PushL(testDevice);

	CGraphicsContext* tContext;
	
	TEST(testDevice->CreateContext(tContext) == KErrNone);
	//note - no cleanupstack entry as the context is owned by the device

	CTestGraphicsContext* testContext = static_cast<CTestGraphicsContext*>(tContext);


	//Create buffer to hold test data
	HBufC* oldTextBufPtr = HBufC::NewLC(KBufferSize);

	TPtrC original;
	TPtrC wrapped;

	TextIterator lIterator(KLeftToRight, KLeftToRightLength);

	TInt i;
	TInt j;
	TInt length;
	TInt endOfWrapped;

	//Fill buffer with groups of 16 characters separated by single spaces
	for (i = 0 ; i < KBufferSize ; ++i)
		{
		if ( (i & 15) == 15) 
			{
			oldTextBufPtr->Des().Append(0x020);
			}
		else
			{
			oldTextBufPtr->Des().Append(lIterator.NextChar());
			}
		}

	TPtr oldText(oldTextBufPtr->Des());

	TBidiText* bidi = TBidiText::NewL(oldText, 200);

	CleanupStack::PushL(bidi);

	TEST( (oldText.Length() == bidi->Text().Length() ) && (oldText.Length() == KBufferSize) );

	TEST(TestTBidirectionalState::TextInSameOrder(oldText.Ptr(), bidi->Text().Ptr(), KBufferSize));

	bidi->WrapText(100 , *testFont, 0);

	TEST(bidi->WrappingWidth() == 100);

	original.Set(bidi->Text());

	wrapped.Set(bidi->DisplayText());

#ifdef PRINT_ARRAYS
	_LIT(KOriginalTitle, "Original: \r\n"); 
	_LIT(KDisplayTitle, "Display: \r\n"); 

	PrintTestData(KOriginalTitle, original);
	PrintTestData(KDisplayTitle, wrapped);

#endif // PRINT_ARRAYS
	
	//Using a font where every character is 10 pixels wide and wrapping to 100 pixels width,
	//after 10 characters should be a linebreak, then the next space is replaced by another linebreak and so on.

	length = oldText.Length();
	endOfWrapped = wrapped.Length();

	TEST(original.Length() == length);
	TEST(endOfWrapped  >= length);

	TInt increment = 10;

	i = 0;
	j = 0;

	for(i=0,j=0; i < length; i += increment, (increment = (increment == 5) ? 10 : 5))
		{ 
		
		TTestDataRun runData;

		TInt endOfRun = ((length-i) > increment) ? i+increment : length;

		runData.iStart = i;
		runData.iLength = endOfRun-i;

		runsArray.Append(runData); 

		//make sure the array is not overread
		TEST( (runData.iLength <= oldText.Length() - i) && (runData.iLength <= wrapped.Length() - j) );

		if (!TestTBidirectionalState::TextInSameOrder(oldText.Ptr() + i , wrapped.Ptr() + j, runData.iLength))
			{
			INFO_PRINTF3(_L("TBidiText test - wrapped - same order check failed for index %d out-index %d\r\n"), i, j);
			TEST(EFalse);
			}

		j += increment;

		if (j >= (endOfWrapped-1))
			{
			break;
			}
		
		if (wrapped[j++] != 0x02028)
			{
			INFO_PRINTF3(_L("TBidiText test - wrapped - line terminator check failed for index %d out-index %d\r\n"), i, j-1);
			TEST(EFalse);
			}
		if (increment == 5) 
			{
			i++; //skip space at end of every 15 characters
			};
		

		}

	TPoint origin(0,0);
	TInt baseline_offset = testFont->BaselineOffsetInPixels();
	bidi->DrawText(*testContext, origin, baseline_offset);

	//now check that DrawText passed the right data
	for (i = 0 ; i < (runsArray.Count()-1) ; i++)
		{
		TPoint line_origin(testContext->DisplayLine(i).Position());
		TEST (line_origin.iY == (origin.iY + (i * baseline_offset)));
		TPtrC16 spec(testContext->DisplayLine(i).LineData());
		TTestDataRun run = runsArray[i];
		TEST(spec.Length() == run.iLength);
		//make sure the array is not overread
		TEST(spec.Length() <= oldText.Length() - run.iStart);
		TEST(TestTBidirectionalState::TextInSameOrder(oldText.Ptr() + run.iStart , spec.Ptr(), spec.Length()));
		};

	INFO_PRINTF1(_L("TBidiText test - wrapped - display text test passed\r\n"));

	CleanupStack::PopAndDestroy(bidi);
	CleanupStack::PopAndDestroy(); //whatever is pushed by HBufC::NewLC
	delete testContext;
	CleanupStack::PopAndDestroy(testDevice);
	CleanupStack::PopAndDestroy(testFont);
	CleanupStack::PopAndDestroy(); //closes runsArray

	}

/**
 *
 * TBool CTBiDi::GlyphTestL
 *
 * Test function for glyph substitution
 *
 * @param     "const TDesC16& aTitle"
 *            Reference to literal string used for logging. Id's the particular test
 *
 * @param     "const TDesC16& aOriginal"
 *            Reference text
 *
 * @param     "const TDesC16& aDesired"
 *            Reference to expected result following call to DisplayText
 *
 * @param     "const TInt aWrapWidth"
 *            The maximum width of the text (in pixels)
 *
 */
TBool CTBiDi::GlyphTestL(const TDesC16& aTitle, const TDesC16& aOriginal, const TDesC16& aDesired, const TInt aWrapWidth)
	{
	TBool pass = ETrue;
	INFO_PRINTF1(aTitle);

	TSize windowSize(400,200);

	CTestGraphicsDevice* testDevice = CTestGraphicsDevice::NewL(windowSize);
	CleanupStack::PushL(testDevice);

	CFont* testFont;
	CGraphicsContext* tContext;
	
	User::LeaveIfError(testDevice->CreateContext(tContext));
	CleanupStack::PushL(tContext);

	User::LeaveIfError(testDevice->GetNearestFontToDesignHeightInPixels(testFont,TFontSpec(KArabicFontName,16)));

	TPtrC original;
	TPtrC wrapped;
	TPtrC desired(aDesired);
	TInt desiredIndex = 0;
	TInt desiredLength = desired.Length();

	TBidiText* bidi = TBidiText::NewL(aOriginal, 50);

	CleanupStack::PushL(bidi);

	bidi->WrapText(aWrapWidth , *testFont, 0);

	TEST(bidi->WrappingWidth() == aWrapWidth);

	original.Set(bidi->Text());

	wrapped.Set(bidi->DisplayText());

	
	CFont::TPositionParam param;
	param.iDirection = CFont::EHorizontal;
	param.iText.Set(bidi->DisplayText());

	param.iPosInText = 0;
	TInt end_char = wrapped.Length();

	pass = ETrue;

	while (param.iPosInText < end_char)
		{
		if (testFont->GetCharacterPosition(param)) //turn character(s) into glyphs
			{
			//some glyphs have been output
			TInt i;
			for (i = 0 ; i < param.iOutputGlyphs ; ++i)
				{
				pass = pass && (desiredIndex < desiredLength); //see if more glyphs generated than expected

				while (desired[desiredIndex] == KUnicodeNoSuchCharacter)
					{
					++desiredIndex; //skip any padding
					}

				pass = pass && (desired[desiredIndex] == param.iOutput[i].iCode);

				++desiredIndex;
				}
			}
		}
	_LIT(KPassed, " passed\r\n");
	_LIT(KFailed, " FAILED\r\n");

	if (pass)
		{
		INFO_PRINTF1(KPassed);
		}
	else
		{
		INFO_PRINTF1(KFailed);
		_LIT(KOriginalTitle, "Original: \r\n"); 
		_LIT(KDisplayTitle, "Display: \r\n"); 
		_LIT(KDesiredTitle, "Desired: \r\n");
		PrintTestData(KOriginalTitle, original);
		PrintTestData(KDisplayTitle, wrapped);
		PrintTestData(KDesiredTitle, desired);

		}

	CleanupStack::PopAndDestroy(bidi);
	CleanupStack::PopAndDestroy(tContext);
	CleanupStack::PopAndDestroy(testDevice);
	delete 	((CTestFont*)testFont); //this is to avoid compilation warnings as CFont desructor is private

	return pass;
	}

_LIT(KLamAlefIsolateTitle, "Lam-Alef Ligature Test (Alef-Lam in logical order) ");
_LIT(KLamAlefIsolate, " \x644\x627 ");
_LIT(KLamAlefIsolateDesired, " \xfefb "); 
_LIT(KLamAlefTahTtitle, "Lam-Alef Tah Ligature Test (Tah Alef Lam in logical order) ");
_LIT(KLamAlefTah, " \x637\x644\x627 ");
_LIT(KLamAlefTahDesired, " \xfefc\xfec3 "); 
_LIT(KTaaTaaTaaTitle, "Taa Taa Taa Shaping test  ");
_LIT(KTaaTaaTaa, " \x637\x637\x637 ");
_LIT(KTaaTaaTaaDesired, " \xfec2\xfec4\xfec3 ");  


/**
 *
 * TBool CTBiDi::LigatureTextsL
 *
 * Test function of glyphs using ligatures
 *
 */
void CTBiDi::LigatureTestsL()
	{
	TInt passed = 0;
	TInt wrapWidth = 400;
	//set the wrapping width very large - we don't want these tests to linewrap.

	if (GlyphTestL(KLamAlefIsolateTitle, KLamAlefIsolate, KLamAlefIsolateDesired, wrapWidth))
		{
		++passed;
		}
	if (GlyphTestL(KLamAlefTahTtitle, KLamAlefTah, KLamAlefTahDesired, wrapWidth))
		{
		++passed;
		}
	if (GlyphTestL(KTaaTaaTaaTitle, KTaaTaaTaa, KTaaTaaTaaDesired, wrapWidth))
		{
		++passed;
		}
	TEST(passed == 3);
	}

_LIT(KIllegalBreakTitle, "Arabic Illegal Linebreak Test");

/**
*
* void CTBiDi::ArabicIllegalLinebreakTestsL
*
* Tests that when rendering a long Arabic "word" that needs to be broken up part-way
* due to screen width, that the characters inside the word are still rendered as their 
* medial form rather than incorrectly making them initial final or isolated.
*/
void CTBiDi::ArabicIllegalLinebreakTestsL()
	{
	static const TInt KWrappingWidth = 100; //in pixels
	static const TInt KLineWidth = 10;       //not including linebreak
	static const TInt KInputLength = 150;
	static const TInt KOutputLength = ((KInputLength/(KLineWidth-1))+1)*KLineWidth; //allow for linebreak characters

	TBuf<KInputLength> iBuffer;        //holds input data
	TBuf<KOutputLength> oBuffer;        //holds expected glyphs that the input will be turned into

	TextIterator iterator(KArabicDualJoiningLettersData, KArabicDualJoiningLettersLength);

	while (!iterator.Wrapped())
		{
		TInt i;
		TInt j;
		TInt startOfLine;
		iBuffer.Zero();
		oBuffer.FillZ(oBuffer.MaxLength());
		TUint16 ch = iterator.NextChar();
		TUint16 medial_ch;

		startOfLine = 0;
		j = KLineWidth; 
		iBuffer.Append(KUnicodeSpace);
		oBuffer[j--] = KUnicodeLinebreak;
		oBuffer[j--] = KUnicodeSpace;
		iBuffer.Append(ch);
		oBuffer[j--] = GetInitialForm(ch);

		//Now compose a very long nonsense word in Arabic.
		//At the same time insert the corresponding 
		for (i = 1; i < (iBuffer.MaxLength()-3) ; ++i)
			{
			do 
				{
				ch = iterator.NextChar();
				medial_ch = GetMedialForm(ch);
				}
			while (medial_ch == ch); //skip characters without medial form
			iBuffer.Append(ch);
			oBuffer[j--] = medial_ch;;
			if (j < startOfLine)
				{
				startOfLine += KLineWidth+1;
				j = startOfLine + KLineWidth;
				oBuffer[j--] = KUnicodeLinebreak;
				}
			}
		ch = iterator.NextChar();
		iBuffer.Append(ch);
		oBuffer[j--] = GetFinalForm(ch);
		iBuffer.Append(KUnicodeSpace);	
		oBuffer[j--] = KUnicodeSpace;	//Trailing spaces are not supressed, hence add space to test output
		for (; j >= startOfLine ; --j)
			{
				oBuffer[j] = KUnicodeNoSuchCharacter;
			}

		//You might be expecting to see some zero-width joiners in the output.
		//In fact these are suppressed by the font object used by GlyphTestL 
		//so we never see them on the outside.

		TBool passed = GlyphTestL(KIllegalBreakTitle, iBuffer, oBuffer, KWrappingWidth);
		if (!passed) 
			{
			TEST(EFalse);
			}
		}
	}

/**
 *
 * void CTBiDi::DoTestTextDrawPanic() 
 *
 * Panic Test for TBidiText::DrawText
 * 
 * This attempts to call DrawText without first calling WrapText and consequently is expected to panic.
 *
 */
void CTBiDi::DoTestTextDrawPanic() 
	{
	TSize windowSize(100,100);

	CTestGraphicsDevice* testDevice = CTestGraphicsDevice::NewL(windowSize);

	CleanupStack::PushL(testDevice);

	CGraphicsContext* testContext;
	
	TEST(testDevice->CreateContext(testContext) == KErrNone);
	//note - no cleanupstack entry as the context is owned by the device

	_LIT(KBidiText, "This is just a random lump of text");

	TBidiText* bidi = TBidiText::NewL(KBidiText, 50);

	CleanupStack::PushL(bidi);

	TPoint centre(50,50);

	bidi->DrawText(*testContext, centre);

	CleanupStack::PopAndDestroy(bidi);
	CleanupStack::PopAndDestroy(testDevice);
	}

/**
 *
 * static TInt TestDrawTextPanicThread
 *
 * Panic Test for TBidiText::DrawText
 * 
 * This calls DoTestDrawTextPanic within its own cleanup stack and TRAPD as it is in 
 * a separate thread.
 *
 */
static TInt TestDrawTextPanicThread(TAny* aData)
	{
	//Tests that BidiText::DrawText panics if called without first calling
	//BidiText::WrapText.
	
	CTBiDi* theTest = static_cast<CTBiDi*> (aData);
	CTrapCleanup* tc = CTrapCleanup::New();
	if (!tc)
		return KErrNoMemory;

	TRAPD(err, theTest->DoTestTextDrawPanic());

	delete tc;

	return err;
	}

/**
 *
 * TInt CTBiDi::TestPanic
 *
 * Panic Test for TBidiText
 * 
 * This creates a separate thread to run the test in as normally a panic
 * will stop the test process.
 *
 */
TInt CTBiDi::TestPanic(TThreadFunction aFunction)
		{
		// Increment the test thread counter to create threads with different names and thus avoid conflict of kernel resources
		++iTestThreadCounter;
		_LIT(KThreadNameFormat, "DeliberatePanicPleaseIgnore%d");
		TBuf<256> threadNameBuf;
		threadNameBuf.Format(KThreadNameFormat, iTestThreadCounter);
	
		TInt KHeapSize = 8192;
		RThread thread;
		TRequestStatus threadstat;
		TBool jit = User::JustInTime();
		User::SetJustInTime(EFalse);
		TInt ret = thread.Create(threadNameBuf, aFunction, KDefaultStackSize, KHeapSize, KHeapSize, this);
		TEST(KErrNone == ret);
		thread.Logon(threadstat);
		thread.Resume();
		User::WaitForRequest(threadstat);
		TEST (thread.ExitType() == EExitPanic);
		TInt reason = thread.ExitReason();
		thread.Close();
		User::SetJustInTime(jit);
		return reason;
		}

/**
 *
 * void CTBiDi::TRunInfoCompactReorderTest
 *
 * Tests functionality contained within TRunInfoCompact
 *
 */
void CTBiDi::TRunInfoCompactReorderTest()
	{
	_LIT(KLetters, "XYZjklmnPQR");
	static const struct {
		TBool iJoinsAtStart;
		TBool iJoinsAtEnd;
		TBool iTruncated;
		TInt iStart;
		TInt iEnd;
		const TText* iExpected;} testData[] =
		{
			{EFalse, EFalse, EFalse, 4, 7, _S("klm")},
			{EFalse, EFalse, EFalse, 3, 7, _S("jklm")},
			{EFalse, EFalse, EFalse, 4, 8, _S("klmn")},
			{EFalse, EFalse, EFalse, 2, 9, _S("jklmn")},
			{ETrue, ETrue, EFalse, 2, 9, _S("\x200Djklmn\x200D")},
			{EFalse, ETrue, EFalse, 2, 9, _S("jklmn\x200D")},
			{ETrue, EFalse, EFalse, 2, 9, _S("\x200Djklmn")},
			{EFalse, EFalse, ETrue, 4, 8, _S("klmn")},
			{EFalse, EFalse, ETrue, 2, 9, _S("jklmn\x2029")},
			{ETrue, ETrue, ETrue, 2, 9, _S("\x200Djklmn\x200D\x2029")},
			{EFalse, ETrue, ETrue, 2, 9, _S("jklmn\x200D\x2029")},
			{ETrue, EFalse, ETrue, 2, 9, _S("\x200Djklmn\x2029")},
			{ETrue, ETrue, ETrue, 8, 9, _S("\x200D\x2029")},
			{ETrue, ETrue, ETrue, 8, 8, _S("")},
			{ETrue, ETrue, ETrue, 9, 9, _S("")},
			{ETrue, ETrue, ETrue, 4, 4, _S("")},
			{ETrue, ETrue, ETrue, 4, 5, _S("k")},
			{EFalse, EFalse, EFalse, 7, 4, _S("mlk")},
			{EFalse, EFalse, EFalse, 7, 3, _S("mlkj")},
			{EFalse, EFalse, EFalse, 8, 4, _S("nmlk")},
			{EFalse, EFalse, EFalse, 9, 2, _S("nmlkj")},
			{ETrue, ETrue, EFalse, 9, 2, _S("\x200Dnmlkj\x200D")},
			{EFalse, ETrue, EFalse, 9, 2, _S("\x200Dnmlkj")},
			{ETrue, EFalse, EFalse, 9, 2, _S("nmlkj\x200D")},
			{EFalse, EFalse, ETrue, 8, 4, _S("nmlk")},
			{EFalse, EFalse, ETrue, 9, 2, _S("\x2029nmlkj")},
			{ETrue, ETrue, ETrue, 9, 2, _S("\x2029\x200Dnmlkj\x200D")},
			{EFalse, ETrue, ETrue, 9, 2, _S("\x2029\x200Dnmlkj")},
			{ETrue, EFalse, ETrue, 9, 2, _S("\x2029nmlkj\x200D")},
			{ETrue, ETrue, ETrue, 9, 8, _S("\x2029\x200D")},
			{ETrue, ETrue, ETrue, 5, 4, _S("k")},
		};
	INFO_PRINTF1(_L("TRunInfoCompact::Reorder test\r\n"));
	TRunInfoCompact::TReorderingContext context;
	context.iSource = KLetters().Ptr();
	context.iStart = 3;
	context.iEnd = 8;
	TText buffer[20];
	TInt numTestCases = sizeof(testData)/sizeof(testData[0]);
	TBool allTestsPassed = ETrue;
	for (TInt i = 0; i != numTestCases; ++i)
		{
		TInt start = testData[i].iStart;
		TInt end = testData[i].iEnd;
		TBool reverse = EFalse;
		if (end < start)
			{
			reverse = ETrue;
			start = testData[i].iEnd;
			end = testData[i].iStart;
			}
		TInt length = end - start;
		TRunInfoCompact run(start, length, reverse);
		context.iJoinsAtStart = testData[i].iJoinsAtStart;
		context.iJoinsAtEnd = testData[i].iJoinsAtEnd;
		context.iTruncation = testData[i].iTruncated ? 0x2029 : 0xFFFF;
		TText* resultEnd = buffer;
		TRAPD(err, resultEnd = run.Reorder(buffer, context));
		TEST(err == KErrNone);
		TPtrC result(buffer, resultEnd - buffer);
		TPtrC expected(testData[i].iExpected);
		if(result.Compare(expected) != 0)
			{
			INFO_PRINTF2(_L("TRunInfoCompactReorderTest %d Failed\r\n"), i+1);
			PrintTestData(_L("Result "), result);
			PrintTestData(_L("Expected "), expected);
			allTestsPassed = EFalse;
			};
			
		}
		TEST(allTestsPassed);
	}

/**
 *
 * void CTBiDi::TBidiLogicalToVisualGetVisualLineTest
 *
 * Tests functionality contained within TBidiLogicalToVisual
 *
 */
void CTBiDi::TBidiLogicalToVisualGetVisualLineTest()
	{
	TBidirectionalState::TRunInfo runArray[4];
	// only iStart, iLength and iDirection are important
	// logical: 0>0>0>0>0>3<3<3<1<1<1<1<2>2>2>2>2>2>
	// visual: 01234BA98CDEFGH765
	// This text would never really be re-ordered in this way.
	// Joiners are between 5 and 6, and 9 and 10.
	_LIT(KBidi, "GHIJK\x0643\x0631\x0644\x0621\x0645\x0627\x0639LMNOPQ");
	runArray[0].iStart = 0;
	runArray[0].iLength = 5;
	runArray[0].iDirection = 0;
	runArray[1].iStart = 8;
	runArray[1].iLength = 4;
	runArray[1].iDirection = 1;
	runArray[2].iStart = 12;
	runArray[2].iLength = 6;
	runArray[2].iDirection = 0;
	runArray[3].iStart = 5;
	runArray[3].iLength = 3;
	runArray[3].iDirection = 1;

	TBidiLogicalToVisual conv(KBidi, EFalse, runArray, 4);
	// We won't call TBidiLogicalToVisual::Reorder(), because we are using the
	// data as-is as test data.
	static const struct {
		TInt iStart;
		TInt iEnd;
		TBool iTruncated;
		const TText* iExpected;
		}
		testData[] =
		{
			{0, 18, EFalse, _S("GHIJK\x0639\x0627\x0645\x0621LMNOPQ\x0644\x0631\x0643")},
			{0, 17, ETrue, _S("GHIJK\x0639\x0627\x0645\x0621LMNOP\x2026\x0644\x0631\x0643")},
			{0, 13, ETrue, _S("GHIJK\x0639\x0627\x0645\x0621L\x2026\x0644\x0631\x0643")},
			{0, 12, ETrue, _S("GHIJK\x0639\x0627\x0645\x0621\x2026\x0644\x0631\x0643")},
			{0, 11, ETrue, _S("GHIJK\x2026\x0627\x0645\x0621\x0644\x0631\x0643")},
			{0, 10, ETrue, _S("GHIJK\x2026\x200D\x0645\x0621\x0644\x0631\x0643")},
			{4, 10, EFalse, _S("K\x200D\x0645\x0621\x0644\x0631\x0643")},
			{5, 10, ETrue, _S("\x2026\x200D\x0645\x0621\x0644\x0631\x0643")},
			{6, 10, ETrue, _S("\x2026\x200D\x0645\x0621\x0644\x0631\x200D")},
			{7, 10, ETrue, _S("\x2026\x200D\x0645\x0621\x0644")},
			{8, 10, ETrue, _S("\x2026\x200D\x0645\x0621")},
			{8, 9, ETrue, _S("\x2026\x0621")},
			{8, 9, EFalse, _S("\x0621")},
			{9, 9, ETrue, _S("\x2026")},
		};

	TBuf<100> result;
	TInt numTestCases = sizeof(testData)/sizeof(testData[0]);
	for (TInt i = 0; i != numTestCases; ++i)
		{
		conv.GetVisualLine(result,
			testData[i].iStart, testData[i].iEnd,
			testData[i].iTruncated? 0x2026 : 0xFFFF);
		TPtrC expected(testData[i].iExpected);
		TEST(0 == result.Compare(expected));
		}
	}

/**
TBidiLogicalToVisualOOMTest

This class contains functions that support tests based on the examples given by 
Unicode Standard Annexe 9

The class contains methods for comparing an example text's logical order with it's display order

*/
class TBidiLogicalToVisualOOMTest : public MOOMTest
	{
	const TDesC* iText;
	TInt iStart;
	TInt iEnd;
	TBool iRightToLeft;
	const TDesC* iReorderedText;
	TInt iReturnValue;
	TBidirectionalState::TRunInfo* iRunInfoArray;
	TInt iRunInfoLength;
	TBuf<80> iLine;
	CTBiDi* iTest;
public:
	TBidiLogicalToVisualOOMTest(
		const TDesC& aText, 
		const TInt aStart,
		const TInt aEnd,
		const TBool aRightToLeft,
		const TDesC& aReorderedText,
		TBidirectionalState::TRunInfo* aRunInfoArray, 
		TInt aRunInfoLength,
		CTBiDi* aTest )
		:	iText(&aText), 
			iStart(aStart),
			iEnd(aEnd),
			iRightToLeft(aRightToLeft), 
			iReorderedText(&aReorderedText),
			iReturnValue(0) , 
			iRunInfoArray(aRunInfoArray),
			iRunInfoLength(aRunInfoLength),
			iTest(aTest)
		{
		}
	virtual ~TBidiLogicalToVisualOOMTest() { TearDown(); }
	void Initialize(const TDesC& aText, TInt aStart, TInt aEnd, TBool aRightToLeft,
		const TDesC& aReorderedText)
		{
		TearDown();
		iText = &aText;
		iStart = aStart;
		iEnd = aEnd;
		iRightToLeft = aRightToLeft;
		iReorderedText = &aReorderedText;
		}
	void SetUpL()
		{
		iLine.Zero();
		iReturnValue = 0;
		}
	void ManipulateL()
		{
		TBidiLogicalToVisual ltv(*iText, iRightToLeft, iRunInfoArray, iRunInfoLength);
		ltv.Reorder();	//map text to visual order
		ltv.GetVisualLine(iLine, iStart, iEnd, 0xFFFF);
		iTest->TEST(StringsMatch(iReorderedText->Ptr(), iReorderedText->Length(), iLine.Ptr(), iReorderedText->Length()));
		//Because this is an OOM test the contents of Line are the results of repeated calls, so the
		//length of iLine is greater than that of iReorderedText. However comparing the first copy suffices.
		//This won't detect the algorithm supplying more characters than expected, but other tests in the suite
		//will detect that.
		User::LeaveIfError(iReturnValue);
		}
	static TBool IsIgnorable(TText a)
		{
		TBool ignorable = EFalse;
		switch(a) {
			case KUnicodeNoSuchCharacter:
			case KUnicodeLeftToRightMark:
			case KUnicodeRightToLeftMark:
			case KUnicodeLeftToRightEmbedding:
			case KUnicodeRightToLeftEmbedding:
			case KUnicodePopDirectionFormat:
			case KUnicodeLeftToRightOverride:
			case KUnicodeRightToLeftOverride:
				ignorable = ETrue;
				break;
			default:
				break;
			}
		return ignorable;
		}
	static TBool StringsMatch(const TText* a1, TInt a1Len,
		const TText* a2, TInt a2Len)
		{
		const TText* a1End = a1 + a1Len;
		const TText* a2End = a2 + a2Len;
		for (;;)
			{
			while (a1 != a1End && IsIgnorable(*a1))
				++a1;
			while (a2 != a2End && IsIgnorable(*a2))
				++a2;
			if (a1 == a1End)
				return a2 == a2End;
			else if (a2 == a2End)
				return EFalse;
			if (*a1 != *a2)
				return EFalse;
			++a1;
			++a2;
			}
		}
	void TearDown()
		{
		iLine.Zero();
		}
	};

void CTBiDi::DEF043323L()
	{
	const TUint16 KArabicPhrase[] =
		{
		KKaf, KAlef, KFeh, KYeh, KTeh, KYeh, KReh, KYeh, KAlef, KUnicodeSpace,
		KNoon, KAlef, KNoon, KAlef
		};
	const TUint16 KReversedArabicPhrase[] =
		{
		KAlef, KNoon, KAlef, KNoon,
		KUnicodeSpace, KAlef, KYeh, KReh, KYeh, KTeh, KYeh, KFeh, KAlef, KKaf,
		KEllipsis
		};
	TPtrC16 phrase(KArabicPhrase, sizeof(KArabicPhrase)/sizeof(KArabicPhrase[0]));
	TBidiText* text = TBidiText::NewL(phrase, 3);
	CleanupStack::PushL(text);
	CFont* font = new (ELeave) CTestFont;
	CleanupStack::PushL(font);
	// wrap to 3 lines, lengths 50/40/40, no truncation character
	text->WrapText(50, *font, 0);
	TEST(text->NumberOfLinesInDisplayText() == 3);
	TInt width;
	TPtrC16 line = text->LineOfDisplayText(0, width);
	TPtrC16 expectedLine(KReversedArabicPhrase + 9, 5);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 50);
	line.Set( text->LineOfDisplayText(1, width));
	expectedLine.Set(KReversedArabicPhrase + 5, 4);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 40);
	line.Set(text->LineOfDisplayText(2, width));
	expectedLine.Set(KReversedArabicPhrase, 4);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 40);
	// wrap to 2 lines, lengths 90/40, no truncation character
	text->WrapText(90, *font, 0, 2);
	TEST(text->NumberOfLinesInDisplayText() == 2);
	text->WrapText(90, *font, 0, 3);
	TEST(text->NumberOfLinesInDisplayText() == 2);
	line.Set(text->LineOfDisplayText(0, width));
	expectedLine.Set(KReversedArabicPhrase + 5, 9);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 90);
	line.Set(text->LineOfDisplayText(1, width));
	expectedLine.Set(KReversedArabicPhrase, 4);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 40);
	// wrap to 2 lines, lengths 20/20, truncation character
	text->WrapText(20, *font, 0, 2);
	TEST(text->NumberOfLinesInDisplayText() == 2);
	line.Set(text->LineOfDisplayText(0, width));
	expectedLine.Set(KReversedArabicPhrase + 12, 2);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 20);
	line.Set(text->LineOfDisplayText(1, width));
	TEST(width == 20);
	expectedLine.Set(KReversedArabicPhrase + 11, 1);
	TEST(line.Find(expectedLine) != KErrNotFound);
	expectedLine.Set(KReversedArabicPhrase + 14, 1);
	TEST(line.Find(expectedLine) != KErrNotFound);
	// lengths 30/30, truncation character
	text->WrapText(30, *font, 0, 2);
	TEST(text->NumberOfLinesInDisplayText() == 2);
	line.Set(text->LineOfDisplayText(0, width));
	expectedLine.Set(KReversedArabicPhrase + 11, 3);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 30);
	line.Set(text->LineOfDisplayText(1, width));
	TEST(width == 30);
	expectedLine.Set(KReversedArabicPhrase + 9, 2);
	TEST(line.Find(expectedLine) != KErrNotFound);
	expectedLine.Set(KReversedArabicPhrase + 14, 1);
	TEST(line.Find(expectedLine) != KErrNotFound);
	// lengths 40/40, truncation character
	text->WrapText(40, *font, 0, 2);
	TEST(text->NumberOfLinesInDisplayText() == 2);
	line.Set(text->LineOfDisplayText(0, width));
	expectedLine.Set(KReversedArabicPhrase + 10, 4);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 40);
	line.Set(text->LineOfDisplayText(1, width));
	TEST(width == 40);
	expectedLine.Set(KReversedArabicPhrase + 7, 3);
	TEST(line.Find(expectedLine) != KErrNotFound);
	expectedLine.Set(KReversedArabicPhrase + 14, 1);
	TEST(line.Find(expectedLine) != KErrNotFound);
	// lengths 50/50, truncation character
	text->WrapText(50, *font, 0, 2);
	TEST(text->NumberOfLinesInDisplayText() == 2);
	line.Set(text->LineOfDisplayText(0, width));
	expectedLine.Set(KReversedArabicPhrase + 9, 5);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 50);
	line.Set(text->LineOfDisplayText(1, width));
	TEST(width == 50);
	expectedLine.Set(KReversedArabicPhrase + 5, 4);
	TEST(line.Find(expectedLine) != KErrNotFound);
	expectedLine.Set(KReversedArabicPhrase + 14, 1);
	TEST(line.Find(expectedLine) != KErrNotFound);
	// length 100, truncation character
	text->WrapText(100, *font, 0, 1);
	TEST(text->NumberOfLinesInDisplayText() == 1);
	line.Set(text->LineOfDisplayText(0, width));
	expectedLine.Set(KReversedArabicPhrase + 5, 9);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 100);
	expectedLine.Set(KReversedArabicPhrase + 14, 1);
	TEST(line.Find(expectedLine) != KErrNotFound);
	// length 120, truncation character: this caught the defect
	text->WrapText(110, *font, 0, 1);
	TEST(text->NumberOfLinesInDisplayText() == 1);
	line.Set(text->LineOfDisplayText(0, width));
	// the space should not be present, so only 100 width
	expectedLine.Set(KReversedArabicPhrase + 5, 9);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 100);
	expectedLine.Set(KReversedArabicPhrase + 14, 1);
	TEST(line.Find(expectedLine) != KErrNotFound);
	// length 120, truncation character
	text->WrapText(120, *font, 0, 1);
	TEST(text->NumberOfLinesInDisplayText() == 1);
	line.Set(text->LineOfDisplayText(0, width));
	expectedLine.Set(KReversedArabicPhrase + 3, 11);
	TEST(line.Find(expectedLine) != KErrNotFound);
	TEST(width == 120);
	expectedLine.Set(KReversedArabicPhrase + 14, 1);
	TEST(line.Find(expectedLine) != KErrNotFound);
	CleanupStack::PopAndDestroy(font);
	CleanupStack::PopAndDestroy(text);
	}
	
void CTBiDi::DEF052191L()
	{
	_LIT(KTwoLines, "First line.\nSecond line.");
	CFont* font = new (ELeave) CTestFont;
	CleanupStack::PushL(font);
	TBidiText* text = TBidiText::NewL(KTwoLines, 16);
	CleanupStack::PushL(text);
	text->WrapText(240, *font, NULL);
	TEST(text->NumberOfLinesInDisplayText() == 2);	//before the fix this used to return 3
	CleanupStack::PopAndDestroy(2); //font and text
	}

/**
   @SYMTestCaseID			GRAPHICS-GDI-BiDi-0007

   @SYMDEF					DEF105603

   @SYMTestCaseDesc			Test TBidirectionalState functionality (Unicode Bidirectional Algorithm impmentation withing SymbianOS)

   @SYMTestPriority			High

   @SYMTestStatus       	Implemented

   @SYMTestActions      	Test detection of 'overall' directionality of a given language/script under normal & OOM conditions

   @SYMTestExpectedResults	Confirmation the implementation conforms to the Unicode Birdirection Algorithm standard
*/
void CTBiDi::TestBidiTextClassL()
	{
	INFO_PRINTF1(_L("Out of Memory Tests"));
	TBidiTextOOMTest toom(this);
	toom.Initialize(KHttsD, TBidiTextOOMTest::ELeftToRight, 1);
	TestOOML(toom);
	toom.Initialize(KHttsD, TBidiTextOOMTest::ERightToLeft, 1);
	TestOOML(toom);
	toom.Initialize(KHttsD, TBidiTextOOMTest::EAutomatic, 1);
	TestOOML(toom);
	toom.Initialize(KHttsD, TBidiTextOOMTest::ELeftToRight, 100);
	TestOOML(toom);
	toom.Initialize(KHttsD, TBidiTextOOMTest::ERightToLeft, 100);
	TestOOML(toom);
	toom.Initialize(KHttsD, TBidiTextOOMTest::EAutomatic, 100);
	TestOOML(toom);
	toom.Initialize(KMultiLine, TBidiTextOOMTest::ELeftToRight, 1);
	TestOOML(toom);
	toom.Initialize(KLineSep, TBidiTextOOMTest::ERightToLeft, 1);
	TestOOML(toom);

	INFO_PRINTF1(_L("Panic"));
	INFO_PRINTF1(_L("Testing DrawText panic\r\n"));
	TEST (EBidiPanic_InvalidVisualOrderedTextLength == TestPanic(TestDrawTextPanicThread));
	INFO_PRINTF1(_L("Arabic with no line break opportunities"));
	NoLineBreakDrawTestL();
	INFO_PRINTF1(_L("Arabic with rare line break opportunities"));
	RightToLeftArabicDrawTestL();
	INFO_PRINTF1(_L("Latin"));
	LeftToRightDrawTestL();
	INFO_PRINTF1(_L("Glyph tests"));
	LigatureTestsL();

	INFO_PRINTF1(_L("TRunInfoCompactReorder"));
	TRunInfoCompactReorderTest();
	// Need to test the rest of the TRunInfoCompact API as well.

	INFO_PRINTF1(_L("Arabic Illegal Line breaks"));
	ArabicIllegalLinebreakTestsL();

	INFO_PRINTF1(_L("DEF043323 - Alignment of TBidiText::DrawText() doesn't take the truncation char into account"));
	DEF043323L();
	INFO_PRINTF1(_L("DEF042191 - Problems with wraping in TBidiText"));
	DEF052191L();
	}

/**
   @SYMTestCaseID			GRAPHICS-GDI-BiDi-0008

   @SYMDEF					DEF105603

   @SYMTestCaseDesc			Test TBidirectionalState functionality (Unicode Bidirectional Algorithm impmentation withing SymbianOS)

   @SYMTestPriority			High

   @SYMTestStatus       	Implemented

   @SYMTestActions      	Test detection of 'overall' directionality of a given language/script

   @SYMTestExpectedResults	Confirmation the implementation conforms to the Unicode Birdirection Algorithm standard
*/
void CTBiDi::TestBidiLogicalToVisualClassL()
	{
	static const TInt KRunInfoLength = 50;
	TBidirectionalState::TRunInfo runInfo[KRunInfoLength];
	INFO_PRINTF1(_L("TBidiVisual test - Out of Memory Tests\r\n"));
	TBidiLogicalToVisualOOMTest toom(KHttsL, 0, 14, ETrue, KHttsD, runInfo, KRunInfoLength, this);
	TestOOML(toom);
	toom.Initialize(KHttL, 0, 13, ETrue, KHttD);
	TestOOML(toom);
	toom.Initialize(KHttL, 0, 13, EFalse, KHttD);
	TestOOML(toom);
	toom.Initialize(KMixedL, 0, 5, ETrue, KMixedD);
	TestOOML(toom);
	toom.Initialize(KMixedL, 0, 5, EFalse, KMixedDL);
	TestOOML(toom);
	toom.Initialize(KHello, 0, 5, ETrue, KHello);
	TestOOML(toom);
	toom.Initialize(KHello, 0, 5, EFalse, KHello);
	TestOOML(toom);
	toom.Initialize(KHalalL, 0, 4, EFalse, KHalalD);
	TestOOML(toom);
	toom.Initialize(KHalalL, 0, 4, ETrue, KHalalD);
	TestOOML(toom);

	TBidiLogicalToVisualGetVisualLineTest();
	}

/**
 *
 * void CTBiDi::TestCatToNumber
 * 
 * Convert TBidirectionalState::TCategory into it's equivalent TChar::TBdCategory
 *
 */
 void CTBiDi::TestCatToNumber(TInt aIn, TInt aOut)
	{
	TEST(TBidirectionalState::CatToNumber(aIn) == aOut);
	}


#define FILL_RUN_ARRAY(aTestArray, aRunArray, aContext) \
	CTBiDi::FillRunArray((aTestArray), (aRunArray), \
	sizeof((aTestArray))/sizeof((aTestArray)[0]), (aContext))

void CTBiDi::FillRunArray(const TBdLevelTest* aTests, TBidirectionalState::TRunInfo* aRuns,
	TInt aArraySize, TBidirectionalState::TReorderContext& aContext)
	{
	aContext.iCategories = 0;
	aContext.iRuns = aArraySize;
	for (TInt i = 0; i != aArraySize; ++i)
		{
		TUint category = 1 << static_cast<TUint>(aTests[i].iCat);
		aContext.iCategories |= category;
		aRuns[i].iCategory = category;
		aRuns[i].iIndex = i;
		}
	}

#define CHECK_RUN_RESULTS(aTestArray, aRunArray) \
	CheckRunResults((aTestArray), (aRunArray), \
	sizeof((aTestArray))/sizeof((aTestArray)[0]))

void CTBiDi::CheckRunResults(const TBdLevelTest* aTests, TBidirectionalState::TRunInfo* aRuns,
	TInt aArraySize)
	{
	for (TInt i = 0; i != aArraySize; ++i)
		{
		const TBdLevelTest* currentTestData = aTests + i;
		TBidirectionalState::TRunInfo* currentRun = aRuns + i;
		if (currentTestData->iLevel != -1)
			{
			TUint category = 1 << static_cast<TUint>(currentTestData->iChangedCat);
			TEST(currentTestData->iLevel == currentRun->iEmbeddingLevel);
			TEST(category == currentRun->iCategory);
			}
		}
	}

void CTBiDi::SetContext(TBidirectionalState::TReorderContext& aContext,
	TChar::TBdCategory aCat)
	{
	TInt cat = 1 << static_cast<TInt>(aCat);
	// big axe
	TInt* p = reinterpret_cast<TInt*> (&(aContext.iNextStrongCategory));
	*p = cat;
	p = reinterpret_cast<TInt*> (&(aContext.iNextCategory));
	*p = cat;
	}

//test data for TestTBidirectionalStateInternalsL

// test X1, X2, X3, X4, X5, X6, X7
// (X8 does not apply to ReorderLine: should not contain multiple paragraphs)
// (X9 and X10 should not be tested explicitly at this level)
static const TBdLevelTest KXTests[] =
	{

	{TChar::ERightToLeftEmbedding, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 1, TChar::EOtherNeutral},
	{TChar::ELeftToRightEmbedding, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 2, TChar::EOtherNeutral},
	{TChar::ELeftToRightEmbedding, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 4, TChar::EOtherNeutral},
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 6, TChar::ELeftToRight},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 7, TChar::ERightToLeft},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 9, TChar::ERightToLeft},
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 10, TChar::ELeftToRight},
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 12, TChar::ELeftToRight},
	{TChar::ERightToLeftEmbedding, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 13, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 13, TChar::EOtherNeutral},
	{TChar::ERightToLeftEmbedding, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 15, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 35, TChar::ERightToLeft},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 55, TChar::ERightToLeft},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeftOverride, -1, TChar::EOtherNeutral},
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 60, TChar::ELeftToRight},
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},	// should not alter directionality
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},	// should not alter directionality
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},	// should not alter directionality
	{TChar::EOtherNeutral, 60, TChar::ELeftToRight},
	{TChar::ERightToLeftEmbedding, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 61, TChar::EOtherNeutral},
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},	// should not alter directionality
	{TChar::ELeftToRightOverride, -1, TChar::EOtherNeutral},	// should not alter directionality
	{TChar::EOtherNeutral, 61, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},	// matches ignored code
	{TChar::EOtherNeutral, 61, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},	// matches ignored code
	{TChar::EOtherNeutral, 61, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 60, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},	// matches ignored code
	{TChar::EOtherNeutral, 60, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},	// matches ignored code
	{TChar::EOtherNeutral, 60, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},	// matches ignored code
	{TChar::EOtherNeutral, 60, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 55, TChar::ERightToLeft},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 35, TChar::ERightToLeft},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 15, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 13, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 12, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 10, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 9, TChar::ERightToLeft},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 7, TChar::ERightToLeft},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 6, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 4, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 2, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 1, TChar::EOtherNeutral},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral}
	};

static const TBdLevelTest KW123TestsL[] =
	{
	{TChar::ENonSpacingMark, 0, TChar::ELeftToRight},
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::ERightToLeftEmbedding, -1, TChar::EOtherNeutral},
	{TChar::ENonSpacingMark, 1, TChar::ERightToLeft},
	{TChar::ELeftToRight, -1, TChar::EOtherNeutral},
	{TChar::ENonSpacingMark, 1, TChar::ELeftToRight},
	{TChar::EEuropeanNumber, 1, TChar::EEuropeanNumber},
	{TChar::ERightToLeftArabic, 1, TChar::ERightToLeft},
	{TChar::ENonSpacingMark, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, -1, TChar::EOtherNeutral},
	{TChar::ENonSpacingMark, 1, TChar::EOtherNeutral},
	{TChar::EEuropeanNumber, 1, TChar::EArabicNumber}
	};

static const TBdLevelTest KW123TestsR[] =
	{
	{TChar::ENonSpacingMark, 1, TChar::ERightToLeft},
	{TChar::EEuropeanNumber, 1, TChar::EEuropeanNumber},
	{TChar::ENonSpacingMark, 1, TChar::EEuropeanNumber},
	{TChar::ELeftToRightEmbedding, -1, TChar::EOtherNeutral},
	{TChar::ENonSpacingMark, 2, TChar::ELeftToRight},
	{TChar::ELeftToRight, -1, TChar::EOtherNeutral},
	{TChar::ENonSpacingMark, 2, TChar::ELeftToRight},
	{TChar::EWhitespace, -1, TChar::EOtherNeutral},
	{TChar::ENonSpacingMark, 2, TChar::EWhitespace},
	{TChar::EOtherNeutral, -1, TChar::EOtherNeutral},
	{TChar::ENonSpacingMark, 2, TChar::EOtherNeutral}
	};


static const TBdLevelTest KW456Tests[] =
	{
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EEuropeanNumberSeparator, 0, TChar::EEuropeanNumber},	// W4
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::ECommonNumberSeparator, 0, TChar::EEuropeanNumber},	// W4
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::ECommonNumberSeparator, 0, TChar::EArabicNumber},	// W4
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EEuropeanNumberTerminator, 0, TChar::EEuropeanNumber},	// W5
	{TChar::EEuropeanNumberTerminator, 0, TChar::EEuropeanNumber},	// W5
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EEuropeanNumberTerminator, 0, TChar::EEuropeanNumber},	// W5
	{TChar::EEuropeanNumberTerminator, 0, TChar::EEuropeanNumber},	// W5
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::EEuropeanNumberTerminator, 0, TChar::EEuropeanNumber},	// W5
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EEuropeanNumberSeparator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EEuropeanNumberSeparator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::EEuropeanNumberTerminator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::ELeftToRight, 0, TChar::ELeftToRight},
	{TChar::EEuropeanNumberSeparator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::ELeftToRight, 0, TChar::ELeftToRight},
	{TChar::EEuropeanNumberSeparator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EEuropeanNumberSeparator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EEuropeanNumberSeparator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EEuropeanNumberSeparator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::EEuropeanNumberTerminator, 0, TChar::EOtherNeutral},	// W6
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	};


static const TBdLevelTest KW7TestsL[] =
	{
	{TChar::EEuropeanNumber, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::ELeftToRight, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EEuropeanNumber, 0, TChar::ELeftToRight},
	{TChar::ERightToLeft, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EOtherNeutral, 0, TChar::EOtherNeutral},
	{TChar::ERightToLeftEmbedding, -1, TChar::EOtherNeutral},
	{TChar::EEuropeanNumber, 1, TChar::EEuropeanNumber},
	{TChar::ELeftToRightEmbedding, -1, TChar::EOtherNeutral},
	{TChar::EEuropeanNumber, 2, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EEuropeanNumber, 1, TChar::ELeftToRight},
	{TChar::EPopDirectionalFormat, -1, TChar::EOtherNeutral},
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	};

static const TBdLevelTest KW7TestsR[] =
	{
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	};

static const TBdLevelTest KN12TestsL[] =
	{
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::ELeftToRight, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::ELeftToRight, 0, TChar::ELeftToRight},
	{TChar::ERightToLeft, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::ERightToLeft, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::ERightToLeft, 0, TChar::ERightToLeft},
	{TChar::ERightToLeft, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::ERightToLeft, 0, TChar::ERightToLeft},
	{TChar::EEuropeanNumber, 0, TChar::EEuropeanNumber},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::ELeftToRight, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::ERightToLeft, 0, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::ELeftToRight, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::EArabicNumber, 0, TChar::EArabicNumber},
	{TChar::ELeftToRight, 0, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 0, TChar::ELeftToRight},
	};

static const TBdLevelTest KN12TestsR[] =
	{
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ELeftToRight, 1, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 1, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 1, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 1, TChar::ELeftToRight},
	{TChar::ELeftToRight, 1, TChar::ELeftToRight},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EArabicNumber, 1, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EEuropeanNumber, 1, TChar::EEuropeanNumber},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EEuropeanNumber, 1, TChar::EEuropeanNumber},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EArabicNumber, 1, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EArabicNumber, 1, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ELeftToRight, 1, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ELeftToRight, 1, TChar::ELeftToRight},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	};

static const TBdLevelTest KN12TestsRRL[] =
	{
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ELeftToRight, 1, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 1, TChar::ELeftToRight}
	};

static const TBdLevelTest KN12TestsLRR[] =
	{
	{TChar::EOtherNeutral, 1, TChar::ELeftToRight},
	{TChar::ELeftToRight, 1, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft}
	};

// Test that pop directional format as the final context does the
// right thing, and that embedded directionalities are taken
// into account.
static const TBdLevelTest KN12TestsLRP[] =
	{
	{TChar::EOtherNeutral, 1, TChar::ELeftToRight},
	{TChar::ELeftToRightEmbedding, -1, TChar::EOtherNeutral},
	{TChar::ERightToLeft, 2, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 2, TChar::ELeftToRight},
	{TChar::ELeftToRight, 2, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 2, TChar::ELeftToRight}
	};

static const TBdLevelTest KN12TestsRLP[] =
	{
	{TChar::EOtherNeutral, 0, TChar::ERightToLeft},
	{TChar::ERightToLeftEmbedding, -1, TChar::EOtherNeutral},
	{TChar::ELeftToRight, 1, TChar::ELeftToRight},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::ERightToLeft, 1, TChar::ERightToLeft},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft}
	};

static const TBdLevelTest KPreviousCarryOver1Line1[] =
	{
	{TChar::ERightToLeftArabic, 1, TChar::ERightToLeft},
	};
static const TBdLevelTest KPreviousCarryOver1Line2[] =
	{
	{TChar::EEuropeanNumber, 2, TChar::EArabicNumber},
	{TChar::EOtherNeutral, 1, TChar::ERightToLeft},
	{TChar::EEuropeanNumber, 2, TChar::EArabicNumber},
	};

void CTBiDi::DoXTests(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	FILL_RUN_ARRAY(KXTests, aRuns, aContext);
	aState.HandleBdControls(aContext);
	CHECK_RUN_RESULTS(KXTests, aRuns);
	}

void CTBiDi::DoKW123TestsLeft(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ELeftToRight, TChar::ELeftToRight, EFalse);
	FILL_RUN_ARRAY(KW123TestsL, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	CHECK_RUN_RESULTS(KW123TestsL, aRuns);
	}

void CTBiDi::DoKW123TestsRight(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ERightToLeft, TChar::ERightToLeft, ETrue);
	FILL_RUN_ARRAY(KW123TestsR, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	CHECK_RUN_RESULTS(KW123TestsR, aRuns);
	}

void CTBiDi::DoKW456Tests(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ELeftToRight, TChar::ELeftToRight, EFalse);
	FILL_RUN_ARRAY(KW456Tests, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	CHECK_RUN_RESULTS(KW456Tests, aRuns);

	}


void CTBiDi::DoKW7TestsLeft(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{

	aState = TBidirectionalState(TChar::ELeftToRight, TChar::ELeftToRight, EFalse);
	FILL_RUN_ARRAY(KW7TestsL, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	CHECK_RUN_RESULTS(KW7TestsL, aRuns);

	}

void CTBiDi::DoKW7TestsRight(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ERightToLeft, TChar::ERightToLeft, EFalse);
	FILL_RUN_ARRAY(KW7TestsR, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	CHECK_RUN_RESULTS(KW7TestsR, aRuns);
	}

void CTBiDi::DoKN12TestsLeft(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ERightToLeft, TChar::ERightToLeft, EFalse);
	SetContext(aContext, TChar::ERightToLeft);
	FILL_RUN_ARRAY(KN12TestsL, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	aState.ResolveNeutralTypes(aContext);
	CHECK_RUN_RESULTS(KN12TestsL, aRuns);

	}

void CTBiDi::DoKN12TestsRight(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ERightToLeft, TChar::ERightToLeft, ETrue);
	SetContext(aContext, TChar::ERightToLeft);
	FILL_RUN_ARRAY(KN12TestsR, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	aState.ResolveNeutralTypes(aContext);
	CHECK_RUN_RESULTS(KN12TestsR, aRuns);
	}

void CTBiDi::DoKN12TestsRRL(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ERightToLeft, TChar::ERightToLeft, ETrue);
	SetContext(aContext, TChar::ELeftToRight);
	FILL_RUN_ARRAY(KN12TestsRRL, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	aState.ResolveNeutralTypes(aContext);
	CHECK_RUN_RESULTS(KN12TestsRRL, aRuns);
	}

void CTBiDi::DoKN12TestsLRR(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ELeftToRight, TChar::ELeftToRight, ETrue);
	SetContext(aContext, TChar::ERightToLeft);
	FILL_RUN_ARRAY(KN12TestsLRR, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	aState.ResolveNeutralTypes(aContext);
	CHECK_RUN_RESULTS(KN12TestsLRR, aRuns);
	}

void CTBiDi::DoKN12TestsLRP(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ELeftToRight, TChar::ELeftToRight, ETrue);
	SetContext(aContext, TChar::EPopDirectionalFormat);
	FILL_RUN_ARRAY(KN12TestsLRP, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	aState.ResolveNeutralTypes(aContext);
	CHECK_RUN_RESULTS(KN12TestsLRP, aRuns);
	}

void CTBiDi::DoKN12TestsRLP(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns) 
	{
	aState = TBidirectionalState(TChar::ERightToLeft, TChar::ERightToLeft, EFalse);
	SetContext(aContext, TChar::EPopDirectionalFormat);
	FILL_RUN_ARRAY(KN12TestsRLP, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	aState.ResolveNeutralTypes(aContext);
	CHECK_RUN_RESULTS(KN12TestsRLP, aRuns);
	}

void CTBiDi::DoCarryOverTest1(TBidirectionalState& aState,
	TBidirectionalState::TReorderContext& aContext,
	TBidirectionalState::TRunInfo* aRuns)
	{
	aState = TBidirectionalState(TChar::ERightToLeft, TChar::ERightToLeft, EFalse);
	SetContext(aContext, TChar::EOtherNeutral);
	FILL_RUN_ARRAY(KPreviousCarryOver1Line1, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	aState.ResolveNeutralTypes(aContext);
	aState.ResolveImplicitLevels(aContext);
	aState.PrepareForNextLine(aContext);
	CHECK_RUN_RESULTS(KPreviousCarryOver1Line1, aRuns);
	FILL_RUN_ARRAY(KPreviousCarryOver1Line2, aRuns, aContext);
	aState.HandleBdControls(aContext);
	aState.ResolveWeakTypesW1W2W3(aContext);
	aState.ResolveWeakTypesW4W5W6(aContext);
	aState.ResolveWeakTypesW7(aContext);
	aState.ResolveNeutralTypes(aContext);
	aState.ResolveImplicitLevels(aContext);
	aState.PrepareForNextLine(aContext);
	CHECK_RUN_RESULTS(KPreviousCarryOver1Line2, aRuns);
	}

/**
   @SYMTestCaseID			GRAPHICS-GDI-BiDi-0001

   @SYMDEF					DEF105603

   @SYMTestCaseDesc			Test TBidirectionalState functionality (Unicode Bidirectional Algorithm impmentation withing SymbianOS)

   @SYMTestPriority			High

   @SYMTestStatus       	Implemented

   @SYMTestActions      	Test conversion of a TBidirectional::TCategory value into it's equivalent TChar::TBdCategory
							Test the various phases of the Bidirectional Algorithm implementation (Resolving explicit levels and directions, weak types & neutral types) 

   @SYMTestExpectedResults	Confirmation the implementation conforms to the Unicode Birdirection Algorithm standard
*/
void CTBiDi::TestTBidirectionalStateInternalsL()
	{
	INFO_PRINTF1(_L("TBidirectionalState internals"));
	TestCatToNumber(1, 0);
	TestCatToNumber(2, 1);
	TestCatToNumber(3, 1);
	TestCatToNumber(4, 2);
	TestCatToNumber(6, 2);
	TestCatToNumber(8, 3);
	TestCatToNumber(9, 3);
	TestCatToNumber(0x10, 4);
	TestCatToNumber(0x20, 5);
	TestCatToNumber(0x40, 6);
	TestCatToNumber(0x7F, 6);
	TestCatToNumber(0x80, 7);
	TestCatToNumber(0x100, 8);
	TestCatToNumber(0x200, 9);
	TestCatToNumber(0x400, 10);
	TestCatToNumber(0x800, 11);
	TestCatToNumber(0x1000, 12);
	TestCatToNumber(0x2000, 13);
	TestCatToNumber(0x4000, 14);
	TestCatToNumber(0x8000, 15);
	TestCatToNumber(0xFFFF, 15);
	TestCatToNumber(0x10000, 16);
	TestCatToNumber(0x20000, 17);
	TestCatToNumber(0x40000, 18);
	TestCatToNumber(0x80000, 19);
	TestCatToNumber(0x100000, 20);
	TestCatToNumber(0x200000, 21);
	TestCatToNumber(0x400000, 22);
	TestCatToNumber(0x800000, 23);
	TestCatToNumber(0x1000000, 24);
	TestCatToNumber(0x2000000, 25);
	TestCatToNumber(0x4000000, 26);
	TestCatToNumber(0x8000000, 27);
	TestCatToNumber(0x10000000, 28);
	TestCatToNumber(0x20000000, 29);
	TestCatToNumber(0x40000000, 30);
	TestCatToNumber(0x7FFFFFFF, 30);

	TBidirectionalState::TRunInfo* runs = new(ELeave) TBidirectionalState::TRunInfo[200];
	CleanupArrayDeletePushL(runs);
	TBidirectionalState state(TChar::EOtherNeutral, TChar::EOtherNeutral, EFalse);
	TBidirectionalState::TReorderContext context;
	context.iRunInfo = runs;
	DoXTests(state, context, runs);
	DoKW123TestsLeft(state, context, runs);
	DoKW123TestsRight(state, context, runs);
	DoKW456Tests(state, context, runs);
	DoKW7TestsLeft(state, context, runs);
	DoKW7TestsRight(state, context, runs);
	DoKN12TestsLeft(state, context, runs);
	DoKN12TestsRight(state, context, runs);
	DoKN12TestsRRL(state, context, runs);
	DoKN12TestsLRR(state, context, runs);
	DoKN12TestsLRP(state, context, runs);
	DoKN12TestsRLP(state, context, runs);

	// Should test "Resolve implicit levels" as well.
	//...

	DoCarryOverTest1(state, context, runs);

	CleanupStack::PopAndDestroy(runs);
	}


/**
 * @SYMTestCaseID			GRAPHICS-SYSLIB-GDI-CT-0217
 * @SYMTestCaseDesc			Test the operation of the run array scratch area
 * @SYMTestPriority			low
 * @SYMTestActions			Step 1: Verify that the scratch area is created and destroyed correctly
 *									and that no memory is leaked.
 *                			Step 2: Verify that the reference counting mechanism operates correctly
 *                			Step 3: Verify that a call to OpenL() will leave correctly if there is 
 * 									not enough memory available.
 * @SYMTestExpectedResults	The test must pass
 * @SYMREQ					APOS-69QD7N - Change TBidiText to make it useable and easier to port 
 *							code to it
 * @SYMDevelopedForRelease	Mike
 * @SYMTestType				CT
 * 
 */
void CTBiDi::DoTestRRunInfoArrayInternalsL()
	{
	INFO_PRINTF1(_L("RRunInfoArray Internals..."));
	

#ifdef _DEBUG
	const TInt KExpectedHeapCells = 2;
#endif


	// Step 1: Verify that the scratch area is created and
	//         destroyed correctly
		{
		INFO_PRINTF1(_L("    Create/destroy run info scratch area..."));
		
		__UHEAP_MARK;
		RRunInfoArray runInfoArray;
		runInfoArray.OpenL();
		__UHEAP_CHECK(KExpectedHeapCells);
		runInfoArray.Close();
		__UHEAP_MARKEND;
		}


	// Step 2: Multiple calls to OpenL() and Close()
	//
		{
		INFO_PRINTF1(_L("    Multiple calls to RRunInfoArray::OpenL()..."));
		
		__UHEAP_MARK;
		RRunInfoArray runInfoArray;
		runInfoArray.OpenL();
		__UHEAP_CHECK(KExpectedHeapCells);

		// Second call on the same object gets ignored.
		runInfoArray.OpenL();
		__UHEAP_CHECK(KExpectedHeapCells);


		// Creating another one reuses the singleton we created
		// earlier. No additional storage gets allocated
		RRunInfoArray runInfoArray2;
		runInfoArray2.OpenL();
		__UHEAP_CHECK(KExpectedHeapCells);


		// Shut down can be done in any order -  It is the last one 
		// that should actually free the memory
		INFO_PRINTF1(_L("    Multiple calls to RRunInfoArray::Close()..."));
		runInfoArray.Close();
		__UHEAP_CHECK(KExpectedHeapCells);
		runInfoArray2.Close();
		__UHEAP_CHECK(0);
		
		
		// Try to break it by calling Close() again
		runInfoArray.Close();
		__UHEAP_CHECK(0);

		
		__UHEAP_MARKEND;
		}
		
	
	// Step 3: Check that OpenL() really does leave if not enough
	//         memory - only valid for debug builds
#ifdef _DEBUG
		{
		INFO_PRINTF1(_L("    RRunInfoArray::OpenL() fails for OOM..."));
		RRunInfoArray runInfoArray;

		// OOM loop - must successfully allocate for 10 consecutive alloc sizes
		TInt allocSuccess = 0;
		TInt failAlloc = 1;
		do 
			{
			__UHEAP_FAILNEXT(failAlloc);
			TRAPD(err, runInfoArray.OpenL());
			__UHEAP_RESET;

			if (err == KErrNone)
				{
				++allocSuccess;
				runInfoArray.Close();
				}
			else
				{
				TEST(KErrNoMemory == err);
				allocSuccess = 0;
				}
			++failAlloc;
			}
			while (allocSuccess < 10);
		}
#endif
	}


/**
 *
 * Check that TBidiText will panic if the NewL call contains
 * an invalid max length value.
 *
 * Note: This function will generate a panic and should therefore
 * be called from within a separate worker thread.
 *
 */
static TInt TestPanicMaxLengthInvalidL(TAny*)
	{
	// A max length of 0 or less is invalid. Should cause a panic.
	TBidiText* bidi = TBidiText::NewL(-1, 3);


	return (KErrNone);
	}


/**
 *
 * Check that TBidiText will panic if the NewL call contains
 * an invalid max lines value
 *
 * Note: This function will generate a panic and should therefore
 * be called from within a separate worker thread.
 *
 */
static TInt TestPanicMaxLinesInvalidL(TAny*)
	{
	// The max number of lines should be 1 or more. Should cause a
	// panic.
	TBidiText* bidi = TBidiText::NewL(100, -1);
	
	
	return (KErrNone);
	}


/**
 *
 * @SYMTestCaseID			GRAPHICS-SYSLIB-GDI-CT-0218
 * @SYMTestCaseDesc			Test the creation of an empty TBidiText object
 * @SYMTestPriority			low
 * @SYMTestActions			Step 1: Verify object creation
 *                			Step 2: Verify that object destruction does not leak memory
 *                			Step 3: Verify that the correct panics are generated if an
 *									invalid parameter is specified
 * @SYMTestExpectedResults	The test must pass
 * @SYMREQ					APOS-69QD7N - Change TBidiText to make it useable and easier to port 
 *							code to it
 * @SYMDevelopedForRelease	Mike
 * @SYMTestType				CT
 *
 */
void CTBiDi::DoTestTBidiTextNewL()
	{
	INFO_PRINTF1(_L("TBidiText::NewL()..."));
	const TInt KMaxLength         = 100;
	const TInt KMaxLines          =   3;
#ifdef _DEBUG
	const TInt KExpectedHeapCells =   1;
#endif
			
	TBidiText* bidiText = 0;

	// First we're going to test the successful creation. This
	// should (hopefully) be how the client app will use the class)
	INFO_PRINTF1(_L("    Create an empty object..."));
	__UHEAP_MARK;
	TRAPD(err, bidiText = TBidiText::NewL(KMaxLength, KMaxLines));
	TEST(KErrNone == err);
	__UHEAP_CHECK(KExpectedHeapCells);
	
		
	// Free up the memory and make sure we haven't leaked anything
	INFO_PRINTF1(_L("    Delete object..."));
	delete bidiText;
	bidiText = 0;
	__UHEAP_CHECK(0);
	__UHEAP_MARKEND;
			

	// Now for the invalid parameters. These will generate a panic
	// so must be tested in a separate thread.
	INFO_PRINTF1(_L("    Invalid max length (will panic!)"));
	TEST(EBidiPanic_InvalidReservedMaxLength == TestPanic(TestPanicMaxLengthInvalidL));
	INFO_PRINTF1(_L("    Invalid max lines (will panic!)"));
	TEST(EBidiPanic_InvalidMaxline == TestPanic(TestPanicMaxLinesInvalidL));
	}


/**
 *
 * Check that TBidiText will panic if the SetText call is made
 * before RRunInfoArray::OpenL();
 *
 * Note: This function will generate a panic and should therefore
 * be called from within a separate worker thread.
 *
 */
TInt CTBiDi::DoTestPanicSetTextL()
	{
	const TInt KMaxLength = 100;
	const TInt KMaxLines  =   3;
	_LIT(KHello, "Hello World");
	
	TBidiText* bidiText   = TBidiText::NewL(KMaxLength, KMaxLines);
	CleanupStack::PushL(bidiText);

	
	// Will cause a KErrDisconnected panic because we have not
	// called RRunInfoArray::OpenL()
	RRunInfoArray runArray;
	bidiText->SetText(KHello, runArray);


	CleanupStack::PopAndDestroy(bidiText);
	return KErrNone;
	}
	

/**
 *
 * Entry point for the DoTestPanicSetTextL test's worker thread
 *
 * Provides cleanup stack for the test function
 *
 */
TInt TestPanicSetTextL(TAny* aData)
	{
	CTBiDi* theTest = static_cast<CTBiDi*> (aData);
	CTrapCleanup* trap = CTrapCleanup::New();
	if (!trap)
		return KErrNoMemory;
	
	
	TRAP_IGNORE(theTest->DoTestPanicSetTextL());	


	delete trap;
	return KErrNone;
	}


/**
 *
 * @SYMTestCaseID			GRAPHICS-SYSLIB-GDI-CT-0219
 * @SYMTestCaseDesc			Test the operation of TBidiText::SetText()
 * @SYMTestPriority			low
 * @SYMTestActions			Step 1: Verify that RRunInfoArray will panic if OpenL() 
 *									has not been called
 *                			Step 2: Verify that SetText() does change the text and
 *									string length
 *                			Step 3: Verify that SetText() will return the number of
 *									characters truncated if the string is too big for
 *									the object.
 *                 			Step 4: Also checks that the text is changed and the
 *									length is updated.
 *                			Step 5: Verify that RRunInfoArray will panic if it's
 *									buffer overflows
 * @SYMTestExpectedResults	The test must pass
 * @SYMREQ					APOS-69QD7N - Change TBidiText to make it useable and easier to port 
 *							code to it
 * @SYMDevelopedForRelease	Mike
 * @SYMTestType				CT
 *
 */
void CTBiDi::DoTestTBidiTextSetTextL()
	{
	INFO_PRINTF1(_L("TBidiText::SetText()..."));


	INFO_PRINTF1(_L("    Run Array not initialised (will panic!)"));
	TEST(EBidiPanic_RunArrayNull == TestPanic(TestPanicSetTextL));
	
	
	// Rest of the tests will make use of these resources
	_LIT(KLine1,    "Mary had a little lamb");
	_LIT(KLine2,    "and she had a bear");
	_LIT(KLine3,    "I've often seen her little lamb");
	const TInt KExpectedDiff = KLine3.iTypeLength - KLine1.iTypeLength;


	RRunInfoArray runArray;
	runArray.OpenL();
	

	INFO_PRINTF1(_L("    Change text..."));
	TBidiText* bidiText = TBidiText::NewL(KLine1, 1);
	CleanupStack::PushL(bidiText);
	TEST(KLine1.iTypeLength == bidiText->Text().Length());
	

	// Will fit. Expect an overflow of 0 characters.	
	TInt overFlow = bidiText->SetText(KLine2, runArray);
	TEST(0 == overFlow);
	TEST(KLine2.iTypeLength == bidiText->Text().Length());
	TEST(!bidiText->Text().Compare(KLine2));
	
	
	// Too long. Expect an overflow for this string. The number of
	// characters we have exceeded the buffer by is determined from
	// the lengths of the two strings: KLine1 (used to set the initial
	// length of the buffer) and KLine3 (used to change the text in the 
	// buffer
	INFO_PRINTF1(_L("    Text overflow..."));
	overFlow = bidiText->SetText(KLine3, runArray);
	TEST(KExpectedDiff == overFlow);
	TEST(KLine1.iTypeLength == bidiText->Text().Length());
	TPtrC line3(KLine3);
	TEST(!bidiText->Text().Compare(line3.Left(KLine1.iTypeLength)));
	
	
	// If the Run Info Array is too small, the text will be truncated
	// and the excess characters returned to the client application as
	// a negative integer. (i.e. can be distinguished from simple
	// truncation)
	TBidiText* bidiText2 = TBidiText::NewL(512, 1);
	CleanupStack::PushL(bidiText2);
	
	// KManyRuns is too long for RRunArray
	_LIT(KManyRuns, "1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a1a");
	TInt excessChars = bidiText2->SetText(KManyRuns, runArray);
	TEST (52 == excessChars);
	

	// Tidy up
	CleanupStack::PopAndDestroy(bidiText2);
	CleanupStack::PopAndDestroy(bidiText);
	runArray.Close();
	}
	

/**
 *
 * @SYMTestCaseID			GRAPHICS-SYSLIB-GDI-CT-0220
 * @SYMTestCaseDesc			Test the operation of TBidiText::MinimumSize()
 * @SYMTestPriority			low
 * @SYMTestActions			Step 1: Verify that MinimumSize() returns the correct
 *									size in pixels both with and without the aMaxLines
 *									parameter specified
 *                          Step 2: Verify that MinimumSize() will panic if an invalid
 *									parameter is specified.
 * @SYMTestExpectedResults	The test must pass
 * @SYMREQ					APOS-69QD7N - Change TBidiText to make it useable and easier to port 
 *							code to it
 * @SYMDevelopedForRelease	Mike
 * @SYMTestType				CT
 *
 */
void CTBiDi::DoTestTBidiTextMinimumSizeL()
	{
	INFO_PRINTF1(_L("TBidiText::MinimumSize()..."));
	
	
	CFont* testFont = new (ELeave) CTestFont;
	CleanupStack::PushL(testFont);
	

	// Create and populate the buffer that holds the test data
	// for this test. 
	HBufC* oldTextBufPtr = HBufC::NewLC(KBufferSize);
	TextIterator rIterator(KRightToLeftArabic, KRightToLeftArabicLength);
	MLineBreaker breaker;
	for (TInt i = 0; i < KBufferSize; ++i)
		{
		TUint s, e;
		TText16 ch = rIterator.NextChar();
		if (breaker.LineBreakClass(ch, s, e) == MLineBreaker::EAlLineBreakClass)
			oldTextBufPtr->Des().Append(ch);
		}
	TPtr oldText(oldTextBufPtr->Des());
	
	
	TBidiText* bidiText = TBidiText::NewL(oldText, 50);
	CleanupStack::PushL(bidiText);
	

	const TUint KWrapWidth      = 400;
	const TUint KLineGap        =   2;
	TSize result = bidiText->MinimumSize(KWrapWidth, *testFont, KLineGap);


	// For a fixed width font where each character is 10 pixels wide, we
	// should expect that we will have 40 characters per line for a wrapping
	// width of 400. 
	const TUint KExpectedWidth = KWrapWidth;
	const TUint KExpectedCharsPerLine = KWrapWidth/testFont->CharWidthInPixels('a');
	const TUint KExpectedLines = (oldText.Length() + KExpectedCharsPerLine - 1)/KExpectedCharsPerLine;
	const TUint KExpectedHeight = (testFont->HeightInPixels() + KLineGap) * KExpectedLines - KLineGap;
	TEST(KExpectedWidth == result.iWidth);
	TEST(KExpectedHeight == result.iHeight);
	

	// Repeat the above, but this time specify the maximum number of lines
	// we're interested in.
	const TUint KMaxLines =  14;
	result = bidiText->MinimumSize(KWrapWidth, *testFont, KLineGap, KMaxLines);
	const TUint KExpectedHeight2      = (testFont->HeightInPixels() + KLineGap) * KMaxLines - KLineGap;;
	TEST(KExpectedWidth   == result.iWidth);
	TEST(KExpectedHeight2 == result.iHeight);


	CleanupStack::PopAndDestroy(bidiText);
	CleanupStack::PopAndDestroy(oldTextBufPtr);
	CleanupStack::PopAndDestroy(testFont);
	}


/**
 *
 * Check that TBidiText will panic if MinimumSize is called
 * with an invalid wrapping width
 *
 * Note: This function will generate a panic and should therefore
 * be called from within a separate worker thread.
 *
 */
TInt CTBiDi::DoTestPanicMinimumSizeWidth()
	{
	CFont* testFont = new (ELeave) CTestFont;
	CleanupStack::PushL(testFont);

	_LIT(KDummyText, "Hello World");
	const TInt KMaxLines  = 50;
	TBidiText* bidiText   = TBidiText::NewL(KDummyText, KMaxLines);
	CleanupStack::PushL(bidiText);
	
	
	RRunInfoArray runArray;
	runArray.OpenL();


	// Should panic - KWrappingWidth is negative
	const TInt  KWrappingWidth = -1;
	const TUint KLineGap       =  1;
	bidiText->MinimumSize(KWrappingWidth, *testFont, KLineGap);


	CleanupStack::PopAndDestroy(bidiText);
	CleanupStack::PopAndDestroy(testFont);
	
	
	return KErrNone;
	}


/**
 *
 * Entry point for the DoTestPanicMinimumSizeWidth test's worker 
 * thread
 *
 * Provides cleanup stack for the test function
 *
 */
static TInt TestPanicMinimumSizeWidth(TAny* aData)
	{
	CTBiDi* theTest = static_cast<CTBiDi*> (aData);
	CTrapCleanup* trap = CTrapCleanup::New();
	if (!trap)
		return KErrNoMemory;
	
	TInt result = KErrNone;
	TRAP_IGNORE(result = theTest->DoTestPanicMinimumSizeWidth());
	
	delete trap;
	return result;
	}


/**
 *
 * Check that TBidiText will panic if MinimumSize is called
 * with an invalid line gap
 *
 * Note: This function will generate a panic and should therefore
 * be called from within a separate worker thread.
 *
 */
TInt CTBiDi::DoTestPanicMinimumSizeLineGap()
	{
	CFont* testFont = new (ELeave) CTestFont;
	CleanupStack::PushL(testFont);

	_LIT(KDummyText, "Hello World");
	const TInt KMaxLines  = 50;
	TBidiText* bidiText   = TBidiText::NewL(KDummyText, KMaxLines);
	CleanupStack::PushL(bidiText);
	
	
	RRunInfoArray runArray;
	runArray.OpenL();


	// Should panic - KLineGap is negative
	const TUint KWrappingWidth = 400;
	const TInt  KLineGap       =  -1;
	bidiText->MinimumSize(KWrappingWidth, *testFont, KLineGap);


	CleanupStack::PopAndDestroy(bidiText);
	CleanupStack::PopAndDestroy(testFont);
	
	
	return KErrNone;
	}


/**
 *
 * Entry point for the DoTestPanicMinimumSizeLineGap test's worker 
 * thread
 *
 * Provides cleanup stack for the test function
 *
 */
static TInt TestPanicMinimumSizeLineGap(TAny* aData)
	{
	CTBiDi* theTest = static_cast <CTBiDi*> (aData);
	CTrapCleanup* trap = CTrapCleanup::New();
	if (!trap)
		return KErrNoMemory;
	
	TInt result = KErrNone;;
	TRAP_IGNORE(result = theTest->DoTestPanicMinimumSizeLineGap());
	
	delete trap;
	return result;
	}


/**
 *
 * Check that TBidiText will panic if MinimumSize is called
 * with an invalid maximum number of lines
 *
 * Note: This function will generate a panic and should therefore
 * be called from within a separate worker thread.
 *
 */
TInt CTBiDi::DoTestPanicMinimumSizeMaxLines()
	{
	CFont* testFont = new (ELeave) CTestFont;
	CleanupStack::PushL(testFont);

	_LIT(KDummyText, "Hello World");
	TBidiText* bidiText   = TBidiText::NewL(KDummyText, 50);
	CleanupStack::PushL(bidiText);
	
	
	RRunInfoArray runArray;
	runArray.OpenL();


	// Should panic - KMaxLines is invalid
	const TUint KWrappingWidth = 400;
	const TUint KLineGap       =   1;
	const TInt  KMaxLines      =  -2;
	bidiText->MinimumSize(KWrappingWidth, *testFont, KLineGap, KMaxLines);


	CleanupStack::PopAndDestroy(bidiText);
	CleanupStack::PopAndDestroy(testFont);
	
	
	return KErrNone;
	}


/**
 *
 * Entry point for the DoTestPanicMinimumSizeMaxLines test's worker 
 * thread
 *
 * Provides cleanup stack for the test function
 *
 */
static TInt TestPanicMinimumSizeMaxLines(TAny* aData)
	{
	CTBiDi* theTest = static_cast <CTBiDi*> (aData);
	CTrapCleanup* trap = CTrapCleanup::New();
	if (!trap)
		return KErrNoMemory;
	
	TInt result = KErrNone;;
	TRAP_IGNORE(result = theTest->DoTestPanicMinimumSizeMaxLines());
	
	delete trap;
	return result;
	}


/**
 *
 * Check that TBidiText will panic if LineOfDisplayText is called
 * with an invalid number of lines.
 *
 * Note: This function will generate a panic and should therefore
 * be called from within a separate worker thread.
 *
 */
TInt CTBiDi::DoTestPanicMinimumNumberOfLinesL()
	{
	CFont* testFont = new (ELeave) CTestFont;
	CleanupStack::PushL(testFont);

	_LIT(KDummyText, "Hello World");
	TBidiText* bidiText   = TBidiText::NewL(KDummyText, 50);
	CleanupStack::PushL(bidiText);
	
	TInt width = 400;
	bidiText->LineOfDisplayText(-2, width);

	CleanupStack::PopAndDestroy(2,testFont);
	
	return KErrNone;
	}
/**
 *
 * Entry point for the DoTestPanicMinimumNumberOfLinesL test's worker 
 * thread
 *
 * Provides cleanup stack for the test function
 *
 */
static TInt TestPanicMinimumNumberOfLines(TAny* aData)
	{
	CTBiDi* theTest = static_cast <CTBiDi*> (aData);
	CTrapCleanup* trap = CTrapCleanup::New();
	if (!trap)
		{
		return KErrNoMemory;
		}
	TRAP_IGNORE(theTest->DoTestPanicMinimumNumberOfLinesL());
	
	delete trap;
	return KErrNone;
	}

/**
 *
 * Test that TBidiText::MinimumSize() will panic in the following
 * circumstances:
 *
 *    o Wrapping width is invalid (i.e. <= 0)
 *    o Line gap is invalid (i.e. < 0)
 *    o Max. lines is invalid (i.e. < -1)
 *
 */
void CTBiDi::DoTestTBidiTextMinimumSizePanics()
	{
	INFO_PRINTF1(_L("    Invalid wrapping width (will panic!)"));
	TEST(EBidiPanic_InvalidWrappingWidth == TestPanic(TestPanicMinimumSizeWidth));

	INFO_PRINTF1(_L("    Invalid line gap (will panic!)"));
	TEST(EBidiPanic_InvalidLineGap == TestPanic(TestPanicMinimumSizeLineGap));

	INFO_PRINTF1(_L("    Invalid max lines (will panic!)"));
	TEST(EBidiPanic_InvalidMaxline == TestPanic(TestPanicMinimumSizeMaxLines));
	
	INFO_PRINTF1(_L("    Invalid minimum number of lines (will panic!)"));
	TEST(EBidiPanic_InvalidVisualOrderedTextLength == TestPanic(TestPanicMinimumNumberOfLines));
	}
	
	
/**
   @SYMTestCaseID			GRAPHICS-GDI-BiDi-0009

   @SYMDEF					Change Request APOS-69QD7N

   @SYMTestCaseDesc			Test TBidirectionalState functionality (Unicode Bidirectional Algorithm impmentation withing SymbianOS)

   @SYMTestPriority			High

   @SYMTestStatus       	Implemented

   @SYMTestActions      	Test detection of 'overall' directionality of a given language/script

   @SYMTestExpectedResults	Confirmation the implementation conforms to the Unicode Birdirection Algorithm standard
*/
void CTBiDi::TestCrApos69qd7nL()
	{
	INFO_PRINTF1(_L("CR APOS-69QD7N - TBidiText"));
	((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CT-0217"));
	DoTestRRunInfoArrayInternalsL();
	((CTBiDiStep*)iStep)->RecordTestResultL();
	((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CT-0218"));
	DoTestTBidiTextNewL();
	((CTBiDiStep*)iStep)->RecordTestResultL();
	((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CT-0219"));
	DoTestTBidiTextSetTextL();
	((CTBiDiStep*)iStep)->RecordTestResultL();
	((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-SYSLIB-GDI-CT-0220"));
	DoTestTBidiTextMinimumSizeL();
	((CTBiDiStep*)iStep)->RecordTestResultL();
	((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0009"));
	DoTestTBidiTextMinimumSizePanics();
	}
	
/**
 *
 * Test for English Strings inserted into Arabic text with brackets interspersed.
 *
 */
 
void CTBiDi::INC086135TestL()
	{	
	// originalText: "<ALEF><LAM> ([h]o{m}e(r)):"
	const TText* originalText = _S("\x627\x644 ([h]o{m}e(r)):");
	// expected text: ":((h]o{m}e(r]) <LAM><ALEF>
	const TText* expectedText = _S(":((h]o{m}e(r]) \x644\x627");
	
	TPtrC ptrOriginal(originalText);
	TPtrC ptrExpected(expectedText);

	// Construct the bidirectional text
	TBidiText* bidiText = TBidiText::NewL(ptrOriginal, 16);
	CleanupStack::PushL(bidiText);
	
	// Call wrap text to prepare the text
	CFont* testFont = new(ELeave) CTestFont;
	CleanupStack::PushL(testFont);
	const TInt KLineLength = 192;
	const TInt KNumLines = 1;
	bidiText->WrapText(KLineLength , *testFont, NULL, KNumLines);
	
	// Return the text that would be displayed
	TPtrC displayText = bidiText->DisplayText();
	
	// Check the result
	if(displayText.Compare(ptrExpected) != 0)
		{
		INFO_PRINTF1(_L("INC086135Test Failed\r\n"));
		PrintTestData(_L("Result "), displayText);
		PrintTestData(_L("Expected "), ptrExpected);
		TEST(EFalse);
		}
	else
		{
		INFO_PRINTF1(_L("INC086135Test Passed\r\n"));
		}
	CleanupStack::PopAndDestroy(2, bidiText);
	}


CTBiDi::CTBiDi(CTestStep* aStep) :
	CTGraphicsBase(aStep)
	{
	 iTestThreadCounter = 0;
	INFO_PRINTF1(_L("TBidirectionalState::ReorderText"));
	}


void CTBiDi::RunTestCaseL(TInt aCurTestCase)
	{
	((CTBiDiStep*)iStep)->SetTestStepID(KUnknownSYMTestCaseIDName);
	switch(aCurTestCase)
		{
	case 1:
		((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0001"));
		TRAPD(err, TestTBidirectionalStateInternalsL());
		TEST(err == KErrNone);
		break;
	case 2:
/**
@SYMTestCaseID GRAPHICS-GDI-BiDi-0002
*/
        	((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0002"));
		TRAP(err, TestTBidirectionalState::TestAPIL(this));
		TEST(err == KErrNone);
		break;
	case 3:
		((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0003"));
		TRAP(err, TestTBidirectionalState::TestReorderTextL(this));
		TEST(err == KErrNone);
		break;
	case 4:
		((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0004"));
		TRAP(err, TestReorderTextL());
		TEST(err == KErrNone);
		break;
	case 5:
		((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0005"));
		TRAP(err, TUnicodeExampleTestL());
		TEST(err == KErrNone);
		break;
	case 6:
		((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0006"));
		INFO_PRINTF1(_L("Script directionality"));
		TestScriptDirectionality();
		break;
	case 7:
		{
		((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0007"));
		INFO_PRINTF1(_L("TBidiText"));
		TRAPD(err, TestBidiTextClassL());
		TEST(err == KErrNone);
		}
		break;
	case 8:
		{
		((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0008"));
		INFO_PRINTF1(_L("TBidiLogicalToVisual"));
		TRAPD(err, TestBidiLogicalToVisualClassL());
		TEST(err == KErrNone);
		}
		break;
	case 9:
		{
	__UHEAP_MARK;
		((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0009"));
		TRAPD(err, TestCrApos69qd7nL());
		TEST(err == KErrNone);
		((CTBiDiStep*)iStep)->CloseTMSGraphicsStep();	
	__UHEAP_MARKEND;
		}
		break;
	case 10:
		{
/**
@SYMTestCaseID GRAPHICS-GDI-BiDi-0010
*/
        	((CTBiDiStep*)iStep)->SetTestStepID(_L("GRAPHICS-GDI-BiDi-0010"));
		INFO_PRINTF1(_L("INC086135Test"));
		TRAPD(err, INC086135TestL());
		TEST(err == KErrNone);
		break;	
		}
	case 11:
        	((CTBiDiStep*)iStep)->SetTestStepID(KNotATestSYMTestCaseIDName);
		((CTBiDiStep*)iStep)->CloseTMSGraphicsStep();
		TestComplete();
		break;
		}
	((CTBiDiStep*)iStep)->RecordTestResultL();
	}

//--------------
__CONSTRUCT_STEP__(BiDi)
