// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

/**
 @file
 @test
 @internalComponent - Internal Symbian test code 
*/

#ifndef TRENDERORIENTATION_H
#define TRENDERORIENTATION_H

#include <e32property.h>
#include "te_graphicsperformanceSuiteStepBase.h"

class CWindowStuff : public CBase
    {
public:
    ~CWindowStuff();
    void ConstructL();
    void Destroy();

    inline RWsSession&     Session()
        {return iWs;};
    inline RWindowGroup&   WindowGroup()
        {return iWindowGroup;};

private:
    RWsSession      iWs;
    RWindowGroup    iWindowGroup;
    RWindow         iChildWindow;    
    };

class CTRenderOrientation : public CTe_graphicsperformanceSuiteStepBase
    {
public:
    CTRenderOrientation();
    ~CTRenderOrientation();

    // From CTestStep
    virtual TVerdict doTestStepPreambleL();
    virtual TVerdict doTestStepPostambleL();
    
    virtual TVerdict doTestStepL();

private:
    enum TWindowThing
        {
        // One per orientation
        EFirstWindowThing,
        ESecondWindowThing,
        EThirdWindowThing,
        EFourthWindowThing,
        
        ENumWindowThings
        };
    
    enum TTestPhase
        {
        EIndicatedOrientationChange,
        EWindowOrdinalChange,
        EThemeOrientationChange,
        
        ENumTestPhases
        };    
    
    void TestOrientationChangeL(const TDesC& aStepName, TTestPhase aTestPhase);
    
    TRenderOrientation  GetRenderOrientationL();
    TRenderOrientation  GetThemeOrientationL();
    TRenderOrientation  GetOrientationL(RProperty& aProperty);
    void                ThemeServerProperty(const TDesC& aCmd);
    
private:    
    CWindowStuff    iWindowStuff[ENumWindowThings];
    RProperty       iWsRenderOrientationProperty;
    RProperty       iThemeOrientationProperty;
    
    RTimer          iTimeoutTimer;
    TRequestStatus  iTimeoutStatus;
    TRequestStatus  iRenderOrientationStatus;
    TInt            iTimingsTaken;
    };

_LIT(KTRenderOrientation,"trenderorientation");

#endif /* TRENDERORIENTATION_H */
