// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Reference implementation of Key Event Routing plug-in

/**
@file
@internalTechnology
@prototype
*/

#ifndef KEYROUTERIMPL_H
#define KEYROUTERIMPL_H

#include <graphics/wskeyrouter.h>

#ifdef KEYROUTER_TEST
/** Key Capture Translation Table entry */
struct TTranslationEntry
	{
	TUint	iRequestScanCode;
	TUint	iCaptureScanCode;
	TUint	iRequestKeyCode;
	TUint	iCaptureKeyCode;
	};

/** Entry for Restricted Key and Priority Application tables */
struct TAppKeyEntry
	{
	TUint			iCode;
	TKeyCaptureType	iType;
	TInt			iAppUidValue;
	};

/** Blocked Key Table entry */
struct TBlockedKeyEntry
	{
	TUint			iCode;
	TKeyCaptureType	iType;
	};

#define TABLE_SIZE(table) (sizeof(table) / sizeof((table)[0]))

#endif // KEYROUTER_TEST

/**
Key Event Router implementation class
*/
NONSHARABLE_CLASS(CKeyEventRouterImpl) : public CKeyEventRouter
	{
public:
	CKeyEventRouterImpl();
	~CKeyEventRouterImpl();

	// From CKeyEventRouter
	void AddCaptureKeyL(const TKeyCaptureRequest& aRequest);
	void UpdateCaptureKeyL(const TKeyCaptureRequest& aRequest);
	void CancelCaptureKey(TKeyCaptureType aType, TAny* aHandle);
	void RouteKey(const TKeyEventRouterInput& aInput,
				  TKeyEventRouterOutput& aOutput);
private:
	void CheckCaptureKeyL(const TKeyCaptureRequest& aRequest);
#ifdef KEYROUTER_TEST
	TBool IsRestrictedKey(const TKeyCaptureRequest& aRequest);
	TBool IsKeyBlocked(TKeyCaptureType aType, TUint aCode);
	TInt PriorityAppUid(TKeyCaptureType aType, TUint aCode);
	void TranslateCaptureKey(TKeyCaptureType aType, TUint& aCode);
#endif

private:
	RArray<TKeyCaptureRequest>	iCaptureKeys;
	};

#endif // KEYROUTERIMPL_H
