// Copyright (c) 1998-2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <f32file.h>
#include <s32file.h>
#include "TTYPES.H"


RFs fs;
CDirectFileStore* writestore=NULL;
CDirectFileStore* readstore=NULL;
RStoreWriteStream writestrm;
RStoreReadStream readstrm;
//-----------
TestPageSpec::TestPageSpec(TPageSpec::TPageOrientation aOrientation,const TSize& aSize, CTTypes* aTest):
	iPortraitPageSize(aSize),
	iOrientation(aOrientation),
	iTest(aTest)
	{}

/**
	TestPageSpec::Test
	Tests functionality contained within the TPageSpec class.
	a TPageSpec object is streamed to & from a file store (via CDirectFileStore) & the results are compared. 
	Attributes such as Orientaton, Page Size are also tested
*/
void TestPageSpec::Test()
	{
	TPageSpec tps(iOrientation,iPortraitPageSize);
	iTest->TEST(tps.iOrientation==iOrientation);
	iTest->TEST(tps.iPortraitPageSize==iPortraitPageSize);
	if(iOrientation==TPageSpec::EPortrait)
		iTest->TEST(tps.OrientedPageSize()==iPortraitPageSize);
	else
		iTest->TEST(tps.OrientedPageSize()==TSize(iPortraitPageSize.iHeight,iPortraitPageSize.iWidth));
	TestStream();
	}

void TestPageSpec::TestStream()
	{
	TPageSpec tps(iOrientation,iPortraitPageSize);
	iTest->InitialiseWriteStream();
	TRAPD(ret,tps.ExternalizeL(writestrm));
	iTest->TEST2(ret, KErrNone);
	iTest->ResetWriteStream();
	TPageSpec tps2;
	iTest->InitialiseReadStream();
	TRAP(ret,tps2.InternalizeL(readstrm));
	iTest->TEST2(ret, KErrNone);
	iTest->ResetReadStream();
	TPageSpec::TPageOrientation tpo=tps.iOrientation;
	TPageSpec::TPageOrientation tpo2=tps2.iOrientation;
	iTest->TEST(tpo==tpo2);
	TSize tpss=tps.iPortraitPageSize;
	TSize tpss2=tps2.iPortraitPageSize;
	iTest->TEST(tpss==tpss2);
	}


TestRgb::TestRgb(TUint8 r1,TUint8 g1,TUint8 b1, CTTypes* aTest):
	iR(r1),
	iG(g1),
	iB(b1),
	iTest(aTest)
	{}

/**
	TestRgb::Test
	Tests functionality contained within the TRgb class.
	Attributes such as base colours are set/retrieved & the result verified
*/
void TestRgb::Test()
	{
	TestSet();
	TestGet();
	TestComp();
	TestStream();
	}

void TestRgb::TestSet()
	{
	TRgb c1;
	TRgb c2(128,128,128);
	TRgb c3(500,500,500);
	TRgb c4(iR,iG,iB);
	TRgb c5(500,600,700);
	iTest->TEST(c2.Red()==128);
	iTest->TEST(c2.Green()==128);
	iTest->TEST(c2.Blue()==128);
	iTest->TEST(c3.Red()<256);
	iTest->TEST(c3.Green()<256);
	iTest->TEST(c3.Blue()<256);
	iTest->TEST(c4.Red()==iR && c4.Green()==iG && c4.Blue()==iB);
	iTest->TEST(c5.Red()<256);
	iTest->TEST(c5.Green()<256);
	iTest->TEST(c5.Blue()<256);
	c1=c4;
	iTest->TEST(c1.Red()==iR && c1.Green()==iG && c1.Blue()==iB);
	c1=TRgb(64,128,192);
	iTest->TEST(c1.Red()==64);
	iTest->TEST(c1.Green()==128);
	iTest->TEST(c1.Blue()==192);
	c1=c5;
	iTest->TEST(c1.Red()<256);
	iTest->TEST(c1.Green()<256);
	iTest->TEST(c1.Blue()<256);
	c1=TRgb::Gray4(3);
	iTest->TEST(c1.Red()==255 && c1.Green()==255 && c1.Blue()==255);
	c1=TRgb::Gray16(15);
	iTest->TEST(c1.Red()==255 && c1.Green()==255 && c1.Blue()==255);
	c1=TRgb::Gray256(255);
	iTest->TEST(c1.Red()==255 && c1.Green()==255 && c1.Blue()==255);
	c1=TRgb::Gray4(4);
	iTest->TEST(c1.Red()<256 && c1.Green()<256 && c1.Blue()<256);
	c1=TRgb::Gray16(16);
	iTest->TEST(c1.Red()<256 && c1.Green()<256 && c1.Blue()<256);
	c1=TRgb::Gray256(256);
	iTest->TEST(c1.Red()<256 && c1.Green()<256 && c1.Blue()<256);
	iTest->TEST(c4.Red()==iR && c4.Green()==iG && c4.Blue()==iB);
	}

/**
	TRgb::TestGet
	Tests mapping of the TRgb value to various gray-scale displaymodes
*/
void TestRgb::TestGet()
	{
	TRgb c1(iR,iG,iB);
	iTest->TEST(c1.Gray4()==(2*iR+5*iG+iB)/512);
	iTest->TEST(c1.Gray16()==(2*iR+5*iG+iB)/128);
	iTest->TEST(c1.Gray256()==(2*iR+5*iG+iB)/8);
	iTest->TEST(c1.Internal()==*((TUint32*)&c1));
	TRgb c2;
	c2=TRgb(*((TUint32*)&c1), 0xff);
	iTest->TEST(c2==TRgb(iR,iG,iB));
	}

/**
	TestRgb::TestComp
	Test operator overrides for TRgb class
*/
void TestRgb::TestComp()
	{
	TRgb c1(iR,iG,iB);
	TRgb c2(iR,iG,iB);
	TRgb c3(255-iR,iG,iB);
	iTest->TEST(c1==c2);
	iTest->TEST(c1!=c3);
	iTest->TEST(c2!=c3);
	iTest->TEST(c1==c2);
	c1&=c3;
	iTest->TEST(c1==TRgb(0,iG,iB));
	c2|=c3;
	iTest->TEST(c2==TRgb(255,iG,iB));
	c1^=c2;
	iTest->TEST(c1==TRgb(255,0,0));
	}

/**
	TestRgb::TestStream
	Streams a TRgb object to & from a file store (via CDirectFileStore calls) & copmares results
*/
void TestRgb::TestStream()
	{
	TRgb rgb(iR,iG,iB);
	iTest->InitialiseWriteStream();
	TRAPD(ret,rgb.ExternalizeL(writestrm));
	iTest->TEST2(ret, KErrNone);
	iTest->ResetWriteStream();
	TRgb rgb2;
	iTest->InitialiseReadStream();
	TRAP(ret,rgb2.InternalizeL(readstrm));
	iTest->TEST2(ret, KErrNone);
	iTest->ResetReadStream();
	iTest->TEST(rgb==rgb2);
	}

TestZoomFactor::TestZoomFactor(CTTypes* aTest, TInt aZoomFactor):
	iZoomFactor(aZoomFactor),
	iTest(aTest)
	{}

/**
	TestZoomFactor::Test
	Tests attributes associated with TZoomFactor for mapping twips to pixels/device-specifc units
*/
void TestZoomFactor::Test()
	{
	TZoomFactor zf((MGraphicsDeviceMap*)NULL);
	zf.SetZoomFactor(iZoomFactor);
	iTest->TEST(zf.ZoomFactor()==iZoomFactor);
	zf.SetZoomFactor(iZoomFactor*10);
	iTest->TEST(zf.ZoomFactor()==iZoomFactor*10);
	zf.SetZoomFactor(iZoomFactor/10);
	iTest->TEST(zf.ZoomFactor()==iZoomFactor/10);
	zf.SetGraphicsDeviceMap(NULL);
	}

/**
	TestDisplayModeUtils::Test
	Test attributes associated with TDisplayModeUtils
*/
void TestDisplayModeUtils::Test()
	{
	const TInt KNumTestModes = 12;
	TDisplayMode mode[] = {	ENone, EGray2, EGray4, EGray16, EGray256,
							EColor16, EColor256, EColor4K, EColor64K, EColor16M, ERgb, EColor16MU, EColor16MA, EColor16MAP};
	TInt numColors[] = { 0, 2, 4, 16, 256, 16, 256, 4096, 65536, 16777216, 0 ,16777216, 16777216, 16777216};
	TBool isColor[] = {	EFalse, EFalse, EFalse, EFalse, EFalse,
						ETrue, ETrue, ETrue, ETrue, ETrue, ETrue, ETrue, ETrue, ETrue};

	for (TInt count = 0; count < KNumTestModes; count++)
		{
		iTest->TEST(TDisplayModeUtils::NumDisplayModeColors(mode[count]) == numColors[count]);
		iTest->TEST((TDisplayModeUtils::IsDisplayModeColor(mode[count]) && isColor[count]) || 
				(!TDisplayModeUtils::IsDisplayModeColor(mode[count]) && !isColor[count]));
		}
	}

CTTypes::CTTypes(CTestStep* aStep):
	CTGraphicsBase(aStep)
	{
	INFO_PRINTF1(_L("Testing T classes in GDI.H:"));
	}

CTTypes::~CTTypes()
	{
	fs.Delete(_L("c:\\ttypes.str"));
	}
	
void CTTypes::ConstructL()
	{
	User::LeaveIfError(fs.Connect());
	}
	
void CTTypes::RunTestCaseL(TInt aCurTestCase)
	{
	switch(aCurTestCase)
		{
	case 1:
		{
		__UHEAP_MARK;
		TestRgb tr1(0,0,0, this);
		TestRgb tr2(100,100,100, this);
		TestRgb tr3(10,20,30, this);
		TestRgb tr4(110,160,210, this);
		TestRgb tr5(255,255,255, this);
		INFO_PRINTF1(_L("TRgb"));
		tr1.Test();
		tr2.Test();
		tr3.Test();
		tr4.Test();
		tr5.Test();
		((CTTypesStep*)iStep)->CloseTMSGraphicsStep();
		__UHEAP_MARKEND;
		}
		break;
	case 2:
		{
		INFO_PRINTF1(_L("TTypeface is moved to TextBase"));
		}
		break;
	case 3:
		{
		INFO_PRINTF1(_L("TMargins is moved to TextBase"));
		}
		break;
	case 4:
		{
		TestPageSpec tps1(TPageSpec::EPortrait,TSize(0,0), this);
		TestPageSpec tps2(TPageSpec::ELandscape,TSize(0,0), this);
		TestPageSpec tps3(TPageSpec::EPortrait,TSize(10,-5), this);
		TestPageSpec tps4(TPageSpec::ELandscape,TSize(15,-20), this);
		TestPageSpec tps5(TPageSpec::EPortrait,TSize(1000,1500), this);
		TestPageSpec tps6(TPageSpec::ELandscape,TSize(2000,500), this);
		INFO_PRINTF1(_L("TPageSpec"));
		tps1.Test();
		tps2.Test();
		tps3.Test();
		tps4.Test();
		tps5.Test();
		tps6.Test();
		}
		break;
	case 5:
		{
		INFO_PRINTF1(_L("FontEffect is moved to TextBase"));
		}
		break;
	case 6:
		{
		INFO_PRINTF1(_L("TFontSyle is moved to TextBase"));
		}
		break;
	case 7:
		{
		INFO_PRINTF1(_L("TFontSpec is moved to TextBase"));
		}
		break;
	case 8:
		{
		TestLine tl1(TPoint(10,10),TPoint(90,90), this);
		TestLine tl2(TPoint(100,150),TPoint(50,-50), this);
		TestLine tl3(TPoint(-50,50),TPoint(60,-40), this);
		TestLine tl4(TPoint(-100,0),TPoint(0,200), this);
		TestLine tl5(TPoint(150,-50),TPoint(50,75), this);
		TestLine tl6(TPoint(0,-100),TPoint(-50,-150), this);
		TestLine tl7(TPoint(-1000,-1000),TPoint(1000,1000), this);
		TestLine tl8(TPoint(1000,-1000),TPoint(-1000,1000), this);
		TestLine tl9(TPoint(500,-1000),TPoint(-500,1000), this);
		TestLine tl10(TPoint(-500,-1000),TPoint(500,1000), this);
		TestLine tl11(TPoint(1000,-500),TPoint(-1000,500), this);
		TestLine tl12(TPoint(1000,500),TPoint(-1000,-500), this);
		INFO_PRINTF1(_L("TLinearDDA"));
		tl1.Test();
		tl2.Test();
		tl3.Test();
		tl4.Test();
		tl5.Test();
		tl6.Test();
		tl7.Test();
		tl8.Test();
		tl9.Test();
		tl10.Test();
		tl11.Test();
		tl12.Test();
		}
		break;
	case 9:
		{
		INFO_PRINTF1(_L("CTypefaceStore  is moved to TextBase"));
		}
		break;
	case 10:
		{
		INFO_PRINTF1(_L("CFontCache is moved to TextBase"));
		}
		break;
	case 11:
		{
		INFO_PRINTF1(_L("CScaleCropPicture"));
		TestPicture tp(this);
		tp.Test();
		}
		break;
	case 12:
		{
		INFO_PRINTF1(_L("CPalette"));
		TestPalette tpal(this);
		tpal.Test();
		}
		break;
	case 13:
		{
		INFO_PRINTF1(_L("TDisplayModeUtils"));
		TestDisplayModeUtils tdmu(this);
		tdmu.Test();
		}
		break;
	case 14:
        	((CTTypesStep*)iStep)->SetOverallTestStepID(_L("GRAPHICS-GDI-0001"));
		((CTTypesStep*)iStep)->RecordTestResultL();
		((CTTypesStep*)iStep)->CloseTMSGraphicsStep();
		TestComplete();		
		break;
		}
	}
	
void CTTypes::InitialiseWriteStream()
	{
	TRAPD(ret,writestore=CDirectFileStore::ReplaceL(fs,_L("c:\\ttypes.str"),EFileStream|EFileWrite));
	TEST2(ret, KErrNone);
	TRAP(ret,writestore->SetTypeL(KDirectFileStoreLayoutUid));
	TEST2(ret, KErrNone);
	TStreamId headerid(0);      //To stop a warning
	TRAP(ret,headerid=writestrm.CreateL(*writestore));
	TEST2(ret, KErrNone);
	TRAP(ret,writestore->SetRootL(headerid));
	TEST2(ret, KErrNone);
	}

void CTTypes::ResetWriteStream()
	{
	writestrm.Close();
	delete writestore;
	}

void CTTypes::InitialiseReadStream()
	{
	TRAPD(ret,readstore=CDirectFileStore::OpenL(fs,_L("c:\\ttypes.str"),EFileStream|EFileRead)); //* --Geert
	TEST2(ret, KErrNone);
	TStreamId headerid=readstore->Root();
	TRAP(ret,readstrm.OpenL(*readstore,headerid));
	TEST2(ret, KErrNone);
	}

void CTTypes::ResetReadStream()
	{
	readstrm.Close();
	delete readstore;
	}
	
//--------------
__CONSTRUCT_STEP__(Types)

