// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Key code and scan code aliases for platform specific keys.
// The definitions are as per S60 <mw/eikon.hrh> with the addition of the
// full set of scan codes.

/**
@file
@internalTechnology
@prototype
*/

#include <e32keys.h>

/**
TStdScanCode aliases
*/
#define EStdKeyPhoneSend		EStdKeyYes
#define EStdKeyPhoneEnd			EStdKeyNo
#define EStdKeyCBA1				EStdKeyDevice0
#define EStdKeyCBA2				EStdKeyDevice1
#define EStdKeyPowerOff			EStdKeyDevice2
#define EStdKeyOK				EStdKeyDevice3
#define EStdKeyGripOpen			EStdKeyDevice4
#define EStdKeyGripClose		EStdKeyDevice5
#define EStdKeySide				EStdKeyDevice6	// Voice key
#define EStdKeyCamera			EStdKeyDevice7
#define EStdKeyTwistOpen		EStdKeyDevice8
#define EStdKeyTwistClose		EStdKeyDevice9
#define EStdKeyFlipOpen			EStdKeyDeviceA
#define EStdKeyFlipClose		EStdKeyDeviceB
#define EStdKeyLock				EStdKeyDeviceF
#define EStdKeyLeftUpArrow		EStdKeyDevice10	// Diagonal arrow event
#define EStdKeyRightUpArrow		EStdKeyDevice11	// Diagonal arrow event
#define EStdKeyRightDownArrow	EStdKeyDevice12	// Diagonal arrow event
#define EStdKeyLeftDownArrow	EStdKeyDevice13	// Diagonal arrow event
#define EStdKeyVolumeUp			EStdKeyIncVolume
#define EStdKeyVolumeDown		EStdKeyDecVolume
#define EStdKeyApplication		EStdKeyApplication0
#define EStdKeyPoC				EStdKeyApplication1
#define EStdKeyPlay				EStdKeyApplication2
#define EStdKeyStop				EStdKeyApplication3
#define EStdKeyForward			EStdKeyApplication4
#define EStdKeyRewind			EStdKeyApplication5
#define EStdKeyOperator			EStdKeyApplication6
#define EStdKeyQwertyOn			EStdKeyApplication7
#define EStdKeyQwertyOff		EStdKeyApplication8
#define EStdKeyNext				EStdKeyApplication9
#define EStdKeyPrevious			EStdKeyApplicationA
#define EStdKeyHoldSwitch		EStdKeyApplicationB
#define EStdKeyZoomIn			EStdKeyApplicationC
#define EStdKeyZoomOut			EStdKeyApplicationD
#define EStdKey4x10QwertyOn		EStdKeyApplicationE
#define EStdKey3x11QwertyOn		EStdKeyApplication10
#define EStdKeyHalfQwertyOn		EStdKeyApplication11
#define EStdKeyCustomKeyboardOn	EStdKeyApplication12

/**
TKeyCode aliases
*/
#define EKeyPhoneSend			EKeyYes
#define EKeyPhoneEnd			EKeyNo
#define EKeyCBA1				EKeyDevice0
#define EKeyCBA2				EKeyDevice1
#define EKeyPowerOff			EKeyDevice2
#define EKeyOK					EKeyDevice3
#define EKeyGripOpen			EKeyDevice4
#define EKeyGripClose			EKeyDevice5
#define EKeySide				EKeyDevice6		// Voice key
#define EKeyCamera				EKeyDevice7
#define EKeyTwistOpen			EKeyDevice8
#define EKeyTwistClose			EKeyDevice9
#define EKeyFlipOpen			EKeyDeviceA
#define EKeyFlipClose			EKeyDeviceB
#define EKeyLock				EKeyDeviceF
#define EKeyLeftUpArrow			EKeyDevice10	// Diagonal arrow event
#define EKeyRightUpArrow		EKeyDevice11	// Diagonal arrow event
#define EKeyRightDownArrow		EKeyDevice12	// Diagonal arrow event
#define EKeyLeftDownArrow		EKeyDevice13	// Diagonal arrow event
#define EKeyVolumeUp			EKeyIncVolume
#define EKeyVolumeDown			EKeyDecVolume
#define EKeyApplication 		EKeyApplication0
#define EKeyPoC					EKeyApplication1
#define EKeyPlay				EKeyApplication2
#define EKeyStop				EKeyApplication3
#define EKeyForward				EKeyApplication4
#define EKeyRewind				EKeyApplication5
#define EKeyOperator			EKeyApplication6
#define EKeyQwertyOn			EKeyApplication7
#define EKeyQwertyOff			EKeyApplication8
#define EKeyNext				EKeyApplication9
#define EKeyPrevious			EKeyApplicationA
#define EKeyHoldSwitch			EKeyApplicationB
#define EKeyZoomIn				EKeyApplicationC
#define EKeyZoomOut				EKeyApplicationD
#define EKey4x10QwertyOn		EKeyApplicationE
#define EKey3x11QwertyOn		EKeyApplication10
#define EKeyHalfQwertyOn		EKeyApplication11
#define EKeyCustomKeyboardOn	EKeyApplication12
