// Copyright (c) 2003-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// This is a lookup table for 12->16 bit bitmap conversion used in the font & bitmap server.
// The table below was generated from the following code :-
//

// #include <iostream>
// #include <iomanip>
// using namespace std;
// int Color4K(int aColor4K)
// int value = (aColor4K & 0xf00) >> 8;
// value |= (aColor4K & 0x0f0) << 4;
// value |= (aColor4K & 0x00f) << 16;
// return value | (value << 4);
// int Color64K(int iValue)
// int color64K = (iValue & 0x0000f8) << 8;
// color64K |= (iValue & 0x00fc00) >> 5;
// color64K |= (iValue & 0xf80000) >> 19;
// return color64K;
// int main(int argc, char* argv[])
// for (int i=0; i<4096; i++)
// cout << "\t0x" << setw(4) << setfill('0') << hex << Color64K(Color4K(i)) << "," << endl;
//

/**
 @internalComponent
*/
static const TUint16 K12to16LUT[] =
{
	0x0000,
	0x0002,
	0x0004,
	0x0006,
	0x0008,
	0x000a,
	0x000c,
	0x000e,
	0x0011,
	0x0013,
	0x0015,
	0x0017,
	0x0019,
	0x001b,
	0x001d,
	0x001f,
	0x0080,
	0x0082,
	0x0084,
	0x0086,
	0x0088,
	0x008a,
	0x008c,
	0x008e,
	0x0091,
	0x0093,
	0x0095,
	0x0097,
	0x0099,
	0x009b,
	0x009d,
	0x009f,
	0x0100,
	0x0102,
	0x0104,
	0x0106,
	0x0108,
	0x010a,
	0x010c,
	0x010e,
	0x0111,
	0x0113,
	0x0115,
	0x0117,
	0x0119,
	0x011b,
	0x011d,
	0x011f,
	0x0180,
	0x0182,
	0x0184,
	0x0186,
	0x0188,
	0x018a,
	0x018c,
	0x018e,
	0x0191,
	0x0193,
	0x0195,
	0x0197,
	0x0199,
	0x019b,
	0x019d,
	0x019f,
	0x0220,
	0x0222,
	0x0224,
	0x0226,
	0x0228,
	0x022a,
	0x022c,
	0x022e,
	0x0231,
	0x0233,
	0x0235,
	0x0237,
	0x0239,
	0x023b,
	0x023d,
	0x023f,
	0x02a0,
	0x02a2,
	0x02a4,
	0x02a6,
	0x02a8,
	0x02aa,
	0x02ac,
	0x02ae,
	0x02b1,
	0x02b3,
	0x02b5,
	0x02b7,
	0x02b9,
	0x02bb,
	0x02bd,
	0x02bf,
	0x0320,
	0x0322,
	0x0324,
	0x0326,
	0x0328,
	0x032a,
	0x032c,
	0x032e,
	0x0331,
	0x0333,
	0x0335,
	0x0337,
	0x0339,
	0x033b,
	0x033d,
	0x033f,
	0x03a0,
	0x03a2,
	0x03a4,
	0x03a6,
	0x03a8,
	0x03aa,
	0x03ac,
	0x03ae,
	0x03b1,
	0x03b3,
	0x03b5,
	0x03b7,
	0x03b9,
	0x03bb,
	0x03bd,
	0x03bf,
	0x0440,
	0x0442,
	0x0444,
	0x0446,
	0x0448,
	0x044a,
	0x044c,
	0x044e,
	0x0451,
	0x0453,
	0x0455,
	0x0457,
	0x0459,
	0x045b,
	0x045d,
	0x045f,
	0x04c0,
	0x04c2,
	0x04c4,
	0x04c6,
	0x04c8,
	0x04ca,
	0x04cc,
	0x04ce,
	0x04d1,
	0x04d3,
	0x04d5,
	0x04d7,
	0x04d9,
	0x04db,
	0x04dd,
	0x04df,
	0x0540,
	0x0542,
	0x0544,
	0x0546,
	0x0548,
	0x054a,
	0x054c,
	0x054e,
	0x0551,
	0x0553,
	0x0555,
	0x0557,
	0x0559,
	0x055b,
	0x055d,
	0x055f,
	0x05c0,
	0x05c2,
	0x05c4,
	0x05c6,
	0x05c8,
	0x05ca,
	0x05cc,
	0x05ce,
	0x05d1,
	0x05d3,
	0x05d5,
	0x05d7,
	0x05d9,
	0x05db,
	0x05dd,
	0x05df,
	0x0660,
	0x0662,
	0x0664,
	0x0666,
	0x0668,
	0x066a,
	0x066c,
	0x066e,
	0x0671,
	0x0673,
	0x0675,
	0x0677,
	0x0679,
	0x067b,
	0x067d,
	0x067f,
	0x06e0,
	0x06e2,
	0x06e4,
	0x06e6,
	0x06e8,
	0x06ea,
	0x06ec,
	0x06ee,
	0x06f1,
	0x06f3,
	0x06f5,
	0x06f7,
	0x06f9,
	0x06fb,
	0x06fd,
	0x06ff,
	0x0760,
	0x0762,
	0x0764,
	0x0766,
	0x0768,
	0x076a,
	0x076c,
	0x076e,
	0x0771,
	0x0773,
	0x0775,
	0x0777,
	0x0779,
	0x077b,
	0x077d,
	0x077f,
	0x07e0,
	0x07e2,
	0x07e4,
	0x07e6,
	0x07e8,
	0x07ea,
	0x07ec,
	0x07ee,
	0x07f1,
	0x07f3,
	0x07f5,
	0x07f7,
	0x07f9,
	0x07fb,
	0x07fd,
	0x07ff,
	0x1000,
	0x1002,
	0x1004,
	0x1006,
	0x1008,
	0x100a,
	0x100c,
	0x100e,
	0x1011,
	0x1013,
	0x1015,
	0x1017,
	0x1019,
	0x101b,
	0x101d,
	0x101f,
	0x1080,
	0x1082,
	0x1084,
	0x1086,
	0x1088,
	0x108a,
	0x108c,
	0x108e,
	0x1091,
	0x1093,
	0x1095,
	0x1097,
	0x1099,
	0x109b,
	0x109d,
	0x109f,
	0x1100,
	0x1102,
	0x1104,
	0x1106,
	0x1108,
	0x110a,
	0x110c,
	0x110e,
	0x1111,
	0x1113,
	0x1115,
	0x1117,
	0x1119,
	0x111b,
	0x111d,
	0x111f,
	0x1180,
	0x1182,
	0x1184,
	0x1186,
	0x1188,
	0x118a,
	0x118c,
	0x118e,
	0x1191,
	0x1193,
	0x1195,
	0x1197,
	0x1199,
	0x119b,
	0x119d,
	0x119f,
	0x1220,
	0x1222,
	0x1224,
	0x1226,
	0x1228,
	0x122a,
	0x122c,
	0x122e,
	0x1231,
	0x1233,
	0x1235,
	0x1237,
	0x1239,
	0x123b,
	0x123d,
	0x123f,
	0x12a0,
	0x12a2,
	0x12a4,
	0x12a6,
	0x12a8,
	0x12aa,
	0x12ac,
	0x12ae,
	0x12b1,
	0x12b3,
	0x12b5,
	0x12b7,
	0x12b9,
	0x12bb,
	0x12bd,
	0x12bf,
	0x1320,
	0x1322,
	0x1324,
	0x1326,
	0x1328,
	0x132a,
	0x132c,
	0x132e,
	0x1331,
	0x1333,
	0x1335,
	0x1337,
	0x1339,
	0x133b,
	0x133d,
	0x133f,
	0x13a0,
	0x13a2,
	0x13a4,
	0x13a6,
	0x13a8,
	0x13aa,
	0x13ac,
	0x13ae,
	0x13b1,
	0x13b3,
	0x13b5,
	0x13b7,
	0x13b9,
	0x13bb,
	0x13bd,
	0x13bf,
	0x1440,
	0x1442,
	0x1444,
	0x1446,
	0x1448,
	0x144a,
	0x144c,
	0x144e,
	0x1451,
	0x1453,
	0x1455,
	0x1457,
	0x1459,
	0x145b,
	0x145d,
	0x145f,
	0x14c0,
	0x14c2,
	0x14c4,
	0x14c6,
	0x14c8,
	0x14ca,
	0x14cc,
	0x14ce,
	0x14d1,
	0x14d3,
	0x14d5,
	0x14d7,
	0x14d9,
	0x14db,
	0x14dd,
	0x14df,
	0x1540,
	0x1542,
	0x1544,
	0x1546,
	0x1548,
	0x154a,
	0x154c,
	0x154e,
	0x1551,
	0x1553,
	0x1555,
	0x1557,
	0x1559,
	0x155b,
	0x155d,
	0x155f,
	0x15c0,
	0x15c2,
	0x15c4,
	0x15c6,
	0x15c8,
	0x15ca,
	0x15cc,
	0x15ce,
	0x15d1,
	0x15d3,
	0x15d5,
	0x15d7,
	0x15d9,
	0x15db,
	0x15dd,
	0x15df,
	0x1660,
	0x1662,
	0x1664,
	0x1666,
	0x1668,
	0x166a,
	0x166c,
	0x166e,
	0x1671,
	0x1673,
	0x1675,
	0x1677,
	0x1679,
	0x167b,
	0x167d,
	0x167f,
	0x16e0,
	0x16e2,
	0x16e4,
	0x16e6,
	0x16e8,
	0x16ea,
	0x16ec,
	0x16ee,
	0x16f1,
	0x16f3,
	0x16f5,
	0x16f7,
	0x16f9,
	0x16fb,
	0x16fd,
	0x16ff,
	0x1760,
	0x1762,
	0x1764,
	0x1766,
	0x1768,
	0x176a,
	0x176c,
	0x176e,
	0x1771,
	0x1773,
	0x1775,
	0x1777,
	0x1779,
	0x177b,
	0x177d,
	0x177f,
	0x17e0,
	0x17e2,
	0x17e4,
	0x17e6,
	0x17e8,
	0x17ea,
	0x17ec,
	0x17ee,
	0x17f1,
	0x17f3,
	0x17f5,
	0x17f7,
	0x17f9,
	0x17fb,
	0x17fd,
	0x17ff,
	0x2000,
	0x2002,
	0x2004,
	0x2006,
	0x2008,
	0x200a,
	0x200c,
	0x200e,
	0x2011,
	0x2013,
	0x2015,
	0x2017,
	0x2019,
	0x201b,
	0x201d,
	0x201f,
	0x2080,
	0x2082,
	0x2084,
	0x2086,
	0x2088,
	0x208a,
	0x208c,
	0x208e,
	0x2091,
	0x2093,
	0x2095,
	0x2097,
	0x2099,
	0x209b,
	0x209d,
	0x209f,
	0x2100,
	0x2102,
	0x2104,
	0x2106,
	0x2108,
	0x210a,
	0x210c,
	0x210e,
	0x2111,
	0x2113,
	0x2115,
	0x2117,
	0x2119,
	0x211b,
	0x211d,
	0x211f,
	0x2180,
	0x2182,
	0x2184,
	0x2186,
	0x2188,
	0x218a,
	0x218c,
	0x218e,
	0x2191,
	0x2193,
	0x2195,
	0x2197,
	0x2199,
	0x219b,
	0x219d,
	0x219f,
	0x2220,
	0x2222,
	0x2224,
	0x2226,
	0x2228,
	0x222a,
	0x222c,
	0x222e,
	0x2231,
	0x2233,
	0x2235,
	0x2237,
	0x2239,
	0x223b,
	0x223d,
	0x223f,
	0x22a0,
	0x22a2,
	0x22a4,
	0x22a6,
	0x22a8,
	0x22aa,
	0x22ac,
	0x22ae,
	0x22b1,
	0x22b3,
	0x22b5,
	0x22b7,
	0x22b9,
	0x22bb,
	0x22bd,
	0x22bf,
	0x2320,
	0x2322,
	0x2324,
	0x2326,
	0x2328,
	0x232a,
	0x232c,
	0x232e,
	0x2331,
	0x2333,
	0x2335,
	0x2337,
	0x2339,
	0x233b,
	0x233d,
	0x233f,
	0x23a0,
	0x23a2,
	0x23a4,
	0x23a6,
	0x23a8,
	0x23aa,
	0x23ac,
	0x23ae,
	0x23b1,
	0x23b3,
	0x23b5,
	0x23b7,
	0x23b9,
	0x23bb,
	0x23bd,
	0x23bf,
	0x2440,
	0x2442,
	0x2444,
	0x2446,
	0x2448,
	0x244a,
	0x244c,
	0x244e,
	0x2451,
	0x2453,
	0x2455,
	0x2457,
	0x2459,
	0x245b,
	0x245d,
	0x245f,
	0x24c0,
	0x24c2,
	0x24c4,
	0x24c6,
	0x24c8,
	0x24ca,
	0x24cc,
	0x24ce,
	0x24d1,
	0x24d3,
	0x24d5,
	0x24d7,
	0x24d9,
	0x24db,
	0x24dd,
	0x24df,
	0x2540,
	0x2542,
	0x2544,
	0x2546,
	0x2548,
	0x254a,
	0x254c,
	0x254e,
	0x2551,
	0x2553,
	0x2555,
	0x2557,
	0x2559,
	0x255b,
	0x255d,
	0x255f,
	0x25c0,
	0x25c2,
	0x25c4,
	0x25c6,
	0x25c8,
	0x25ca,
	0x25cc,
	0x25ce,
	0x25d1,
	0x25d3,
	0x25d5,
	0x25d7,
	0x25d9,
	0x25db,
	0x25dd,
	0x25df,
	0x2660,
	0x2662,
	0x2664,
	0x2666,
	0x2668,
	0x266a,
	0x266c,
	0x266e,
	0x2671,
	0x2673,
	0x2675,
	0x2677,
	0x2679,
	0x267b,
	0x267d,
	0x267f,
	0x26e0,
	0x26e2,
	0x26e4,
	0x26e6,
	0x26e8,
	0x26ea,
	0x26ec,
	0x26ee,
	0x26f1,
	0x26f3,
	0x26f5,
	0x26f7,
	0x26f9,
	0x26fb,
	0x26fd,
	0x26ff,
	0x2760,
	0x2762,
	0x2764,
	0x2766,
	0x2768,
	0x276a,
	0x276c,
	0x276e,
	0x2771,
	0x2773,
	0x2775,
	0x2777,
	0x2779,
	0x277b,
	0x277d,
	0x277f,
	0x27e0,
	0x27e2,
	0x27e4,
	0x27e6,
	0x27e8,
	0x27ea,
	0x27ec,
	0x27ee,
	0x27f1,
	0x27f3,
	0x27f5,
	0x27f7,
	0x27f9,
	0x27fb,
	0x27fd,
	0x27ff,
	0x3000,
	0x3002,
	0x3004,
	0x3006,
	0x3008,
	0x300a,
	0x300c,
	0x300e,
	0x3011,
	0x3013,
	0x3015,
	0x3017,
	0x3019,
	0x301b,
	0x301d,
	0x301f,
	0x3080,
	0x3082,
	0x3084,
	0x3086,
	0x3088,
	0x308a,
	0x308c,
	0x308e,
	0x3091,
	0x3093,
	0x3095,
	0x3097,
	0x3099,
	0x309b,
	0x309d,
	0x309f,
	0x3100,
	0x3102,
	0x3104,
	0x3106,
	0x3108,
	0x310a,
	0x310c,
	0x310e,
	0x3111,
	0x3113,
	0x3115,
	0x3117,
	0x3119,
	0x311b,
	0x311d,
	0x311f,
	0x3180,
	0x3182,
	0x3184,
	0x3186,
	0x3188,
	0x318a,
	0x318c,
	0x318e,
	0x3191,
	0x3193,
	0x3195,
	0x3197,
	0x3199,
	0x319b,
	0x319d,
	0x319f,
	0x3220,
	0x3222,
	0x3224,
	0x3226,
	0x3228,
	0x322a,
	0x322c,
	0x322e,
	0x3231,
	0x3233,
	0x3235,
	0x3237,
	0x3239,
	0x323b,
	0x323d,
	0x323f,
	0x32a0,
	0x32a2,
	0x32a4,
	0x32a6,
	0x32a8,
	0x32aa,
	0x32ac,
	0x32ae,
	0x32b1,
	0x32b3,
	0x32b5,
	0x32b7,
	0x32b9,
	0x32bb,
	0x32bd,
	0x32bf,
	0x3320,
	0x3322,
	0x3324,
	0x3326,
	0x3328,
	0x332a,
	0x332c,
	0x332e,
	0x3331,
	0x3333,
	0x3335,
	0x3337,
	0x3339,
	0x333b,
	0x333d,
	0x333f,
	0x33a0,
	0x33a2,
	0x33a4,
	0x33a6,
	0x33a8,
	0x33aa,
	0x33ac,
	0x33ae,
	0x33b1,
	0x33b3,
	0x33b5,
	0x33b7,
	0x33b9,
	0x33bb,
	0x33bd,
	0x33bf,
	0x3440,
	0x3442,
	0x3444,
	0x3446,
	0x3448,
	0x344a,
	0x344c,
	0x344e,
	0x3451,
	0x3453,
	0x3455,
	0x3457,
	0x3459,
	0x345b,
	0x345d,
	0x345f,
	0x34c0,
	0x34c2,
	0x34c4,
	0x34c6,
	0x34c8,
	0x34ca,
	0x34cc,
	0x34ce,
	0x34d1,
	0x34d3,
	0x34d5,
	0x34d7,
	0x34d9,
	0x34db,
	0x34dd,
	0x34df,
	0x3540,
	0x3542,
	0x3544,
	0x3546,
	0x3548,
	0x354a,
	0x354c,
	0x354e,
	0x3551,
	0x3553,
	0x3555,
	0x3557,
	0x3559,
	0x355b,
	0x355d,
	0x355f,
	0x35c0,
	0x35c2,
	0x35c4,
	0x35c6,
	0x35c8,
	0x35ca,
	0x35cc,
	0x35ce,
	0x35d1,
	0x35d3,
	0x35d5,
	0x35d7,
	0x35d9,
	0x35db,
	0x35dd,
	0x35df,
	0x3660,
	0x3662,
	0x3664,
	0x3666,
	0x3668,
	0x366a,
	0x366c,
	0x366e,
	0x3671,
	0x3673,
	0x3675,
	0x3677,
	0x3679,
	0x367b,
	0x367d,
	0x367f,
	0x36e0,
	0x36e2,
	0x36e4,
	0x36e6,
	0x36e8,
	0x36ea,
	0x36ec,
	0x36ee,
	0x36f1,
	0x36f3,
	0x36f5,
	0x36f7,
	0x36f9,
	0x36fb,
	0x36fd,
	0x36ff,
	0x3760,
	0x3762,
	0x3764,
	0x3766,
	0x3768,
	0x376a,
	0x376c,
	0x376e,
	0x3771,
	0x3773,
	0x3775,
	0x3777,
	0x3779,
	0x377b,
	0x377d,
	0x377f,
	0x37e0,
	0x37e2,
	0x37e4,
	0x37e6,
	0x37e8,
	0x37ea,
	0x37ec,
	0x37ee,
	0x37f1,
	0x37f3,
	0x37f5,
	0x37f7,
	0x37f9,
	0x37fb,
	0x37fd,
	0x37ff,
	0x4000,
	0x4002,
	0x4004,
	0x4006,
	0x4008,
	0x400a,
	0x400c,
	0x400e,
	0x4011,
	0x4013,
	0x4015,
	0x4017,
	0x4019,
	0x401b,
	0x401d,
	0x401f,
	0x4080,
	0x4082,
	0x4084,
	0x4086,
	0x4088,
	0x408a,
	0x408c,
	0x408e,
	0x4091,
	0x4093,
	0x4095,
	0x4097,
	0x4099,
	0x409b,
	0x409d,
	0x409f,
	0x4100,
	0x4102,
	0x4104,
	0x4106,
	0x4108,
	0x410a,
	0x410c,
	0x410e,
	0x4111,
	0x4113,
	0x4115,
	0x4117,
	0x4119,
	0x411b,
	0x411d,
	0x411f,
	0x4180,
	0x4182,
	0x4184,
	0x4186,
	0x4188,
	0x418a,
	0x418c,
	0x418e,
	0x4191,
	0x4193,
	0x4195,
	0x4197,
	0x4199,
	0x419b,
	0x419d,
	0x419f,
	0x4220,
	0x4222,
	0x4224,
	0x4226,
	0x4228,
	0x422a,
	0x422c,
	0x422e,
	0x4231,
	0x4233,
	0x4235,
	0x4237,
	0x4239,
	0x423b,
	0x423d,
	0x423f,
	0x42a0,
	0x42a2,
	0x42a4,
	0x42a6,
	0x42a8,
	0x42aa,
	0x42ac,
	0x42ae,
	0x42b1,
	0x42b3,
	0x42b5,
	0x42b7,
	0x42b9,
	0x42bb,
	0x42bd,
	0x42bf,
	0x4320,
	0x4322,
	0x4324,
	0x4326,
	0x4328,
	0x432a,
	0x432c,
	0x432e,
	0x4331,
	0x4333,
	0x4335,
	0x4337,
	0x4339,
	0x433b,
	0x433d,
	0x433f,
	0x43a0,
	0x43a2,
	0x43a4,
	0x43a6,
	0x43a8,
	0x43aa,
	0x43ac,
	0x43ae,
	0x43b1,
	0x43b3,
	0x43b5,
	0x43b7,
	0x43b9,
	0x43bb,
	0x43bd,
	0x43bf,
	0x4440,
	0x4442,
	0x4444,
	0x4446,
	0x4448,
	0x444a,
	0x444c,
	0x444e,
	0x4451,
	0x4453,
	0x4455,
	0x4457,
	0x4459,
	0x445b,
	0x445d,
	0x445f,
	0x44c0,
	0x44c2,
	0x44c4,
	0x44c6,
	0x44c8,
	0x44ca,
	0x44cc,
	0x44ce,
	0x44d1,
	0x44d3,
	0x44d5,
	0x44d7,
	0x44d9,
	0x44db,
	0x44dd,
	0x44df,
	0x4540,
	0x4542,
	0x4544,
	0x4546,
	0x4548,
	0x454a,
	0x454c,
	0x454e,
	0x4551,
	0x4553,
	0x4555,
	0x4557,
	0x4559,
	0x455b,
	0x455d,
	0x455f,
	0x45c0,
	0x45c2,
	0x45c4,
	0x45c6,
	0x45c8,
	0x45ca,
	0x45cc,
	0x45ce,
	0x45d1,
	0x45d3,
	0x45d5,
	0x45d7,
	0x45d9,
	0x45db,
	0x45dd,
	0x45df,
	0x4660,
	0x4662,
	0x4664,
	0x4666,
	0x4668,
	0x466a,
	0x466c,
	0x466e,
	0x4671,
	0x4673,
	0x4675,
	0x4677,
	0x4679,
	0x467b,
	0x467d,
	0x467f,
	0x46e0,
	0x46e2,
	0x46e4,
	0x46e6,
	0x46e8,
	0x46ea,
	0x46ec,
	0x46ee,
	0x46f1,
	0x46f3,
	0x46f5,
	0x46f7,
	0x46f9,
	0x46fb,
	0x46fd,
	0x46ff,
	0x4760,
	0x4762,
	0x4764,
	0x4766,
	0x4768,
	0x476a,
	0x476c,
	0x476e,
	0x4771,
	0x4773,
	0x4775,
	0x4777,
	0x4779,
	0x477b,
	0x477d,
	0x477f,
	0x47e0,
	0x47e2,
	0x47e4,
	0x47e6,
	0x47e8,
	0x47ea,
	0x47ec,
	0x47ee,
	0x47f1,
	0x47f3,
	0x47f5,
	0x47f7,
	0x47f9,
	0x47fb,
	0x47fd,
	0x47ff,
	0x5000,
	0x5002,
	0x5004,
	0x5006,
	0x5008,
	0x500a,
	0x500c,
	0x500e,
	0x5011,
	0x5013,
	0x5015,
	0x5017,
	0x5019,
	0x501b,
	0x501d,
	0x501f,
	0x5080,
	0x5082,
	0x5084,
	0x5086,
	0x5088,
	0x508a,
	0x508c,
	0x508e,
	0x5091,
	0x5093,
	0x5095,
	0x5097,
	0x5099,
	0x509b,
	0x509d,
	0x509f,
	0x5100,
	0x5102,
	0x5104,
	0x5106,
	0x5108,
	0x510a,
	0x510c,
	0x510e,
	0x5111,
	0x5113,
	0x5115,
	0x5117,
	0x5119,
	0x511b,
	0x511d,
	0x511f,
	0x5180,
	0x5182,
	0x5184,
	0x5186,
	0x5188,
	0x518a,
	0x518c,
	0x518e,
	0x5191,
	0x5193,
	0x5195,
	0x5197,
	0x5199,
	0x519b,
	0x519d,
	0x519f,
	0x5220,
	0x5222,
	0x5224,
	0x5226,
	0x5228,
	0x522a,
	0x522c,
	0x522e,
	0x5231,
	0x5233,
	0x5235,
	0x5237,
	0x5239,
	0x523b,
	0x523d,
	0x523f,
	0x52a0,
	0x52a2,
	0x52a4,
	0x52a6,
	0x52a8,
	0x52aa,
	0x52ac,
	0x52ae,
	0x52b1,
	0x52b3,
	0x52b5,
	0x52b7,
	0x52b9,
	0x52bb,
	0x52bd,
	0x52bf,
	0x5320,
	0x5322,
	0x5324,
	0x5326,
	0x5328,
	0x532a,
	0x532c,
	0x532e,
	0x5331,
	0x5333,
	0x5335,
	0x5337,
	0x5339,
	0x533b,
	0x533d,
	0x533f,
	0x53a0,
	0x53a2,
	0x53a4,
	0x53a6,
	0x53a8,
	0x53aa,
	0x53ac,
	0x53ae,
	0x53b1,
	0x53b3,
	0x53b5,
	0x53b7,
	0x53b9,
	0x53bb,
	0x53bd,
	0x53bf,
	0x5440,
	0x5442,
	0x5444,
	0x5446,
	0x5448,
	0x544a,
	0x544c,
	0x544e,
	0x5451,
	0x5453,
	0x5455,
	0x5457,
	0x5459,
	0x545b,
	0x545d,
	0x545f,
	0x54c0,
	0x54c2,
	0x54c4,
	0x54c6,
	0x54c8,
	0x54ca,
	0x54cc,
	0x54ce,
	0x54d1,
	0x54d3,
	0x54d5,
	0x54d7,
	0x54d9,
	0x54db,
	0x54dd,
	0x54df,
	0x5540,
	0x5542,
	0x5544,
	0x5546,
	0x5548,
	0x554a,
	0x554c,
	0x554e,
	0x5551,
	0x5553,
	0x5555,
	0x5557,
	0x5559,
	0x555b,
	0x555d,
	0x555f,
	0x55c0,
	0x55c2,
	0x55c4,
	0x55c6,
	0x55c8,
	0x55ca,
	0x55cc,
	0x55ce,
	0x55d1,
	0x55d3,
	0x55d5,
	0x55d7,
	0x55d9,
	0x55db,
	0x55dd,
	0x55df,
	0x5660,
	0x5662,
	0x5664,
	0x5666,
	0x5668,
	0x566a,
	0x566c,
	0x566e,
	0x5671,
	0x5673,
	0x5675,
	0x5677,
	0x5679,
	0x567b,
	0x567d,
	0x567f,
	0x56e0,
	0x56e2,
	0x56e4,
	0x56e6,
	0x56e8,
	0x56ea,
	0x56ec,
	0x56ee,
	0x56f1,
	0x56f3,
	0x56f5,
	0x56f7,
	0x56f9,
	0x56fb,
	0x56fd,
	0x56ff,
	0x5760,
	0x5762,
	0x5764,
	0x5766,
	0x5768,
	0x576a,
	0x576c,
	0x576e,
	0x5771,
	0x5773,
	0x5775,
	0x5777,
	0x5779,
	0x577b,
	0x577d,
	0x577f,
	0x57e0,
	0x57e2,
	0x57e4,
	0x57e6,
	0x57e8,
	0x57ea,
	0x57ec,
	0x57ee,
	0x57f1,
	0x57f3,
	0x57f5,
	0x57f7,
	0x57f9,
	0x57fb,
	0x57fd,
	0x57ff,
	0x6000,
	0x6002,
	0x6004,
	0x6006,
	0x6008,
	0x600a,
	0x600c,
	0x600e,
	0x6011,
	0x6013,
	0x6015,
	0x6017,
	0x6019,
	0x601b,
	0x601d,
	0x601f,
	0x6080,
	0x6082,
	0x6084,
	0x6086,
	0x6088,
	0x608a,
	0x608c,
	0x608e,
	0x6091,
	0x6093,
	0x6095,
	0x6097,
	0x6099,
	0x609b,
	0x609d,
	0x609f,
	0x6100,
	0x6102,
	0x6104,
	0x6106,
	0x6108,
	0x610a,
	0x610c,
	0x610e,
	0x6111,
	0x6113,
	0x6115,
	0x6117,
	0x6119,
	0x611b,
	0x611d,
	0x611f,
	0x6180,
	0x6182,
	0x6184,
	0x6186,
	0x6188,
	0x618a,
	0x618c,
	0x618e,
	0x6191,
	0x6193,
	0x6195,
	0x6197,
	0x6199,
	0x619b,
	0x619d,
	0x619f,
	0x6220,
	0x6222,
	0x6224,
	0x6226,
	0x6228,
	0x622a,
	0x622c,
	0x622e,
	0x6231,
	0x6233,
	0x6235,
	0x6237,
	0x6239,
	0x623b,
	0x623d,
	0x623f,
	0x62a0,
	0x62a2,
	0x62a4,
	0x62a6,
	0x62a8,
	0x62aa,
	0x62ac,
	0x62ae,
	0x62b1,
	0x62b3,
	0x62b5,
	0x62b7,
	0x62b9,
	0x62bb,
	0x62bd,
	0x62bf,
	0x6320,
	0x6322,
	0x6324,
	0x6326,
	0x6328,
	0x632a,
	0x632c,
	0x632e,
	0x6331,
	0x6333,
	0x6335,
	0x6337,
	0x6339,
	0x633b,
	0x633d,
	0x633f,
	0x63a0,
	0x63a2,
	0x63a4,
	0x63a6,
	0x63a8,
	0x63aa,
	0x63ac,
	0x63ae,
	0x63b1,
	0x63b3,
	0x63b5,
	0x63b7,
	0x63b9,
	0x63bb,
	0x63bd,
	0x63bf,
	0x6440,
	0x6442,
	0x6444,
	0x6446,
	0x6448,
	0x644a,
	0x644c,
	0x644e,
	0x6451,
	0x6453,
	0x6455,
	0x6457,
	0x6459,
	0x645b,
	0x645d,
	0x645f,
	0x64c0,
	0x64c2,
	0x64c4,
	0x64c6,
	0x64c8,
	0x64ca,
	0x64cc,
	0x64ce,
	0x64d1,
	0x64d3,
	0x64d5,
	0x64d7,
	0x64d9,
	0x64db,
	0x64dd,
	0x64df,
	0x6540,
	0x6542,
	0x6544,
	0x6546,
	0x6548,
	0x654a,
	0x654c,
	0x654e,
	0x6551,
	0x6553,
	0x6555,
	0x6557,
	0x6559,
	0x655b,
	0x655d,
	0x655f,
	0x65c0,
	0x65c2,
	0x65c4,
	0x65c6,
	0x65c8,
	0x65ca,
	0x65cc,
	0x65ce,
	0x65d1,
	0x65d3,
	0x65d5,
	0x65d7,
	0x65d9,
	0x65db,
	0x65dd,
	0x65df,
	0x6660,
	0x6662,
	0x6664,
	0x6666,
	0x6668,
	0x666a,
	0x666c,
	0x666e,
	0x6671,
	0x6673,
	0x6675,
	0x6677,
	0x6679,
	0x667b,
	0x667d,
	0x667f,
	0x66e0,
	0x66e2,
	0x66e4,
	0x66e6,
	0x66e8,
	0x66ea,
	0x66ec,
	0x66ee,
	0x66f1,
	0x66f3,
	0x66f5,
	0x66f7,
	0x66f9,
	0x66fb,
	0x66fd,
	0x66ff,
	0x6760,
	0x6762,
	0x6764,
	0x6766,
	0x6768,
	0x676a,
	0x676c,
	0x676e,
	0x6771,
	0x6773,
	0x6775,
	0x6777,
	0x6779,
	0x677b,
	0x677d,
	0x677f,
	0x67e0,
	0x67e2,
	0x67e4,
	0x67e6,
	0x67e8,
	0x67ea,
	0x67ec,
	0x67ee,
	0x67f1,
	0x67f3,
	0x67f5,
	0x67f7,
	0x67f9,
	0x67fb,
	0x67fd,
	0x67ff,
	0x7000,
	0x7002,
	0x7004,
	0x7006,
	0x7008,
	0x700a,
	0x700c,
	0x700e,
	0x7011,
	0x7013,
	0x7015,
	0x7017,
	0x7019,
	0x701b,
	0x701d,
	0x701f,
	0x7080,
	0x7082,
	0x7084,
	0x7086,
	0x7088,
	0x708a,
	0x708c,
	0x708e,
	0x7091,
	0x7093,
	0x7095,
	0x7097,
	0x7099,
	0x709b,
	0x709d,
	0x709f,
	0x7100,
	0x7102,
	0x7104,
	0x7106,
	0x7108,
	0x710a,
	0x710c,
	0x710e,
	0x7111,
	0x7113,
	0x7115,
	0x7117,
	0x7119,
	0x711b,
	0x711d,
	0x711f,
	0x7180,
	0x7182,
	0x7184,
	0x7186,
	0x7188,
	0x718a,
	0x718c,
	0x718e,
	0x7191,
	0x7193,
	0x7195,
	0x7197,
	0x7199,
	0x719b,
	0x719d,
	0x719f,
	0x7220,
	0x7222,
	0x7224,
	0x7226,
	0x7228,
	0x722a,
	0x722c,
	0x722e,
	0x7231,
	0x7233,
	0x7235,
	0x7237,
	0x7239,
	0x723b,
	0x723d,
	0x723f,
	0x72a0,
	0x72a2,
	0x72a4,
	0x72a6,
	0x72a8,
	0x72aa,
	0x72ac,
	0x72ae,
	0x72b1,
	0x72b3,
	0x72b5,
	0x72b7,
	0x72b9,
	0x72bb,
	0x72bd,
	0x72bf,
	0x7320,
	0x7322,
	0x7324,
	0x7326,
	0x7328,
	0x732a,
	0x732c,
	0x732e,
	0x7331,
	0x7333,
	0x7335,
	0x7337,
	0x7339,
	0x733b,
	0x733d,
	0x733f,
	0x73a0,
	0x73a2,
	0x73a4,
	0x73a6,
	0x73a8,
	0x73aa,
	0x73ac,
	0x73ae,
	0x73b1,
	0x73b3,
	0x73b5,
	0x73b7,
	0x73b9,
	0x73bb,
	0x73bd,
	0x73bf,
	0x7440,
	0x7442,
	0x7444,
	0x7446,
	0x7448,
	0x744a,
	0x744c,
	0x744e,
	0x7451,
	0x7453,
	0x7455,
	0x7457,
	0x7459,
	0x745b,
	0x745d,
	0x745f,
	0x74c0,
	0x74c2,
	0x74c4,
	0x74c6,
	0x74c8,
	0x74ca,
	0x74cc,
	0x74ce,
	0x74d1,
	0x74d3,
	0x74d5,
	0x74d7,
	0x74d9,
	0x74db,
	0x74dd,
	0x74df,
	0x7540,
	0x7542,
	0x7544,
	0x7546,
	0x7548,
	0x754a,
	0x754c,
	0x754e,
	0x7551,
	0x7553,
	0x7555,
	0x7557,
	0x7559,
	0x755b,
	0x755d,
	0x755f,
	0x75c0,
	0x75c2,
	0x75c4,
	0x75c6,
	0x75c8,
	0x75ca,
	0x75cc,
	0x75ce,
	0x75d1,
	0x75d3,
	0x75d5,
	0x75d7,
	0x75d9,
	0x75db,
	0x75dd,
	0x75df,
	0x7660,
	0x7662,
	0x7664,
	0x7666,
	0x7668,
	0x766a,
	0x766c,
	0x766e,
	0x7671,
	0x7673,
	0x7675,
	0x7677,
	0x7679,
	0x767b,
	0x767d,
	0x767f,
	0x76e0,
	0x76e2,
	0x76e4,
	0x76e6,
	0x76e8,
	0x76ea,
	0x76ec,
	0x76ee,
	0x76f1,
	0x76f3,
	0x76f5,
	0x76f7,
	0x76f9,
	0x76fb,
	0x76fd,
	0x76ff,
	0x7760,
	0x7762,
	0x7764,
	0x7766,
	0x7768,
	0x776a,
	0x776c,
	0x776e,
	0x7771,
	0x7773,
	0x7775,
	0x7777,
	0x7779,
	0x777b,
	0x777d,
	0x777f,
	0x77e0,
	0x77e2,
	0x77e4,
	0x77e6,
	0x77e8,
	0x77ea,
	0x77ec,
	0x77ee,
	0x77f1,
	0x77f3,
	0x77f5,
	0x77f7,
	0x77f9,
	0x77fb,
	0x77fd,
	0x77ff,
	0x8800,
	0x8802,
	0x8804,
	0x8806,
	0x8808,
	0x880a,
	0x880c,
	0x880e,
	0x8811,
	0x8813,
	0x8815,
	0x8817,
	0x8819,
	0x881b,
	0x881d,
	0x881f,
	0x8880,
	0x8882,
	0x8884,
	0x8886,
	0x8888,
	0x888a,
	0x888c,
	0x888e,
	0x8891,
	0x8893,
	0x8895,
	0x8897,
	0x8899,
	0x889b,
	0x889d,
	0x889f,
	0x8900,
	0x8902,
	0x8904,
	0x8906,
	0x8908,
	0x890a,
	0x890c,
	0x890e,
	0x8911,
	0x8913,
	0x8915,
	0x8917,
	0x8919,
	0x891b,
	0x891d,
	0x891f,
	0x8980,
	0x8982,
	0x8984,
	0x8986,
	0x8988,
	0x898a,
	0x898c,
	0x898e,
	0x8991,
	0x8993,
	0x8995,
	0x8997,
	0x8999,
	0x899b,
	0x899d,
	0x899f,
	0x8a20,
	0x8a22,
	0x8a24,
	0x8a26,
	0x8a28,
	0x8a2a,
	0x8a2c,
	0x8a2e,
	0x8a31,
	0x8a33,
	0x8a35,
	0x8a37,
	0x8a39,
	0x8a3b,
	0x8a3d,
	0x8a3f,
	0x8aa0,
	0x8aa2,
	0x8aa4,
	0x8aa6,
	0x8aa8,
	0x8aaa,
	0x8aac,
	0x8aae,
	0x8ab1,
	0x8ab3,
	0x8ab5,
	0x8ab7,
	0x8ab9,
	0x8abb,
	0x8abd,
	0x8abf,
	0x8b20,
	0x8b22,
	0x8b24,
	0x8b26,
	0x8b28,
	0x8b2a,
	0x8b2c,
	0x8b2e,
	0x8b31,
	0x8b33,
	0x8b35,
	0x8b37,
	0x8b39,
	0x8b3b,
	0x8b3d,
	0x8b3f,
	0x8ba0,
	0x8ba2,
	0x8ba4,
	0x8ba6,
	0x8ba8,
	0x8baa,
	0x8bac,
	0x8bae,
	0x8bb1,
	0x8bb3,
	0x8bb5,
	0x8bb7,
	0x8bb9,
	0x8bbb,
	0x8bbd,
	0x8bbf,
	0x8c40,
	0x8c42,
	0x8c44,
	0x8c46,
	0x8c48,
	0x8c4a,
	0x8c4c,
	0x8c4e,
	0x8c51,
	0x8c53,
	0x8c55,
	0x8c57,
	0x8c59,
	0x8c5b,
	0x8c5d,
	0x8c5f,
	0x8cc0,
	0x8cc2,
	0x8cc4,
	0x8cc6,
	0x8cc8,
	0x8cca,
	0x8ccc,
	0x8cce,
	0x8cd1,
	0x8cd3,
	0x8cd5,
	0x8cd7,
	0x8cd9,
	0x8cdb,
	0x8cdd,
	0x8cdf,
	0x8d40,
	0x8d42,
	0x8d44,
	0x8d46,
	0x8d48,
	0x8d4a,
	0x8d4c,
	0x8d4e,
	0x8d51,
	0x8d53,
	0x8d55,
	0x8d57,
	0x8d59,
	0x8d5b,
	0x8d5d,
	0x8d5f,
	0x8dc0,
	0x8dc2,
	0x8dc4,
	0x8dc6,
	0x8dc8,
	0x8dca,
	0x8dcc,
	0x8dce,
	0x8dd1,
	0x8dd3,
	0x8dd5,
	0x8dd7,
	0x8dd9,
	0x8ddb,
	0x8ddd,
	0x8ddf,
	0x8e60,
	0x8e62,
	0x8e64,
	0x8e66,
	0x8e68,
	0x8e6a,
	0x8e6c,
	0x8e6e,
	0x8e71,
	0x8e73,
	0x8e75,
	0x8e77,
	0x8e79,
	0x8e7b,
	0x8e7d,
	0x8e7f,
	0x8ee0,
	0x8ee2,
	0x8ee4,
	0x8ee6,
	0x8ee8,
	0x8eea,
	0x8eec,
	0x8eee,
	0x8ef1,
	0x8ef3,
	0x8ef5,
	0x8ef7,
	0x8ef9,
	0x8efb,
	0x8efd,
	0x8eff,
	0x8f60,
	0x8f62,
	0x8f64,
	0x8f66,
	0x8f68,
	0x8f6a,
	0x8f6c,
	0x8f6e,
	0x8f71,
	0x8f73,
	0x8f75,
	0x8f77,
	0x8f79,
	0x8f7b,
	0x8f7d,
	0x8f7f,
	0x8fe0,
	0x8fe2,
	0x8fe4,
	0x8fe6,
	0x8fe8,
	0x8fea,
	0x8fec,
	0x8fee,
	0x8ff1,
	0x8ff3,
	0x8ff5,
	0x8ff7,
	0x8ff9,
	0x8ffb,
	0x8ffd,
	0x8fff,
	0x9800,
	0x9802,
	0x9804,
	0x9806,
	0x9808,
	0x980a,
	0x980c,
	0x980e,
	0x9811,
	0x9813,
	0x9815,
	0x9817,
	0x9819,
	0x981b,
	0x981d,
	0x981f,
	0x9880,
	0x9882,
	0x9884,
	0x9886,
	0x9888,
	0x988a,
	0x988c,
	0x988e,
	0x9891,
	0x9893,
	0x9895,
	0x9897,
	0x9899,
	0x989b,
	0x989d,
	0x989f,
	0x9900,
	0x9902,
	0x9904,
	0x9906,
	0x9908,
	0x990a,
	0x990c,
	0x990e,
	0x9911,
	0x9913,
	0x9915,
	0x9917,
	0x9919,
	0x991b,
	0x991d,
	0x991f,
	0x9980,
	0x9982,
	0x9984,
	0x9986,
	0x9988,
	0x998a,
	0x998c,
	0x998e,
	0x9991,
	0x9993,
	0x9995,
	0x9997,
	0x9999,
	0x999b,
	0x999d,
	0x999f,
	0x9a20,
	0x9a22,
	0x9a24,
	0x9a26,
	0x9a28,
	0x9a2a,
	0x9a2c,
	0x9a2e,
	0x9a31,
	0x9a33,
	0x9a35,
	0x9a37,
	0x9a39,
	0x9a3b,
	0x9a3d,
	0x9a3f,
	0x9aa0,
	0x9aa2,
	0x9aa4,
	0x9aa6,
	0x9aa8,
	0x9aaa,
	0x9aac,
	0x9aae,
	0x9ab1,
	0x9ab3,
	0x9ab5,
	0x9ab7,
	0x9ab9,
	0x9abb,
	0x9abd,
	0x9abf,
	0x9b20,
	0x9b22,
	0x9b24,
	0x9b26,
	0x9b28,
	0x9b2a,
	0x9b2c,
	0x9b2e,
	0x9b31,
	0x9b33,
	0x9b35,
	0x9b37,
	0x9b39,
	0x9b3b,
	0x9b3d,
	0x9b3f,
	0x9ba0,
	0x9ba2,
	0x9ba4,
	0x9ba6,
	0x9ba8,
	0x9baa,
	0x9bac,
	0x9bae,
	0x9bb1,
	0x9bb3,
	0x9bb5,
	0x9bb7,
	0x9bb9,
	0x9bbb,
	0x9bbd,
	0x9bbf,
	0x9c40,
	0x9c42,
	0x9c44,
	0x9c46,
	0x9c48,
	0x9c4a,
	0x9c4c,
	0x9c4e,
	0x9c51,
	0x9c53,
	0x9c55,
	0x9c57,
	0x9c59,
	0x9c5b,
	0x9c5d,
	0x9c5f,
	0x9cc0,
	0x9cc2,
	0x9cc4,
	0x9cc6,
	0x9cc8,
	0x9cca,
	0x9ccc,
	0x9cce,
	0x9cd1,
	0x9cd3,
	0x9cd5,
	0x9cd7,
	0x9cd9,
	0x9cdb,
	0x9cdd,
	0x9cdf,
	0x9d40,
	0x9d42,
	0x9d44,
	0x9d46,
	0x9d48,
	0x9d4a,
	0x9d4c,
	0x9d4e,
	0x9d51,
	0x9d53,
	0x9d55,
	0x9d57,
	0x9d59,
	0x9d5b,
	0x9d5d,
	0x9d5f,
	0x9dc0,
	0x9dc2,
	0x9dc4,
	0x9dc6,
	0x9dc8,
	0x9dca,
	0x9dcc,
	0x9dce,
	0x9dd1,
	0x9dd3,
	0x9dd5,
	0x9dd7,
	0x9dd9,
	0x9ddb,
	0x9ddd,
	0x9ddf,
	0x9e60,
	0x9e62,
	0x9e64,
	0x9e66,
	0x9e68,
	0x9e6a,
	0x9e6c,
	0x9e6e,
	0x9e71,
	0x9e73,
	0x9e75,
	0x9e77,
	0x9e79,
	0x9e7b,
	0x9e7d,
	0x9e7f,
	0x9ee0,
	0x9ee2,
	0x9ee4,
	0x9ee6,
	0x9ee8,
	0x9eea,
	0x9eec,
	0x9eee,
	0x9ef1,
	0x9ef3,
	0x9ef5,
	0x9ef7,
	0x9ef9,
	0x9efb,
	0x9efd,
	0x9eff,
	0x9f60,
	0x9f62,
	0x9f64,
	0x9f66,
	0x9f68,
	0x9f6a,
	0x9f6c,
	0x9f6e,
	0x9f71,
	0x9f73,
	0x9f75,
	0x9f77,
	0x9f79,
	0x9f7b,
	0x9f7d,
	0x9f7f,
	0x9fe0,
	0x9fe2,
	0x9fe4,
	0x9fe6,
	0x9fe8,
	0x9fea,
	0x9fec,
	0x9fee,
	0x9ff1,
	0x9ff3,
	0x9ff5,
	0x9ff7,
	0x9ff9,
	0x9ffb,
	0x9ffd,
	0x9fff,
	0xa800,
	0xa802,
	0xa804,
	0xa806,
	0xa808,
	0xa80a,
	0xa80c,
	0xa80e,
	0xa811,
	0xa813,
	0xa815,
	0xa817,
	0xa819,
	0xa81b,
	0xa81d,
	0xa81f,
	0xa880,
	0xa882,
	0xa884,
	0xa886,
	0xa888,
	0xa88a,
	0xa88c,
	0xa88e,
	0xa891,
	0xa893,
	0xa895,
	0xa897,
	0xa899,
	0xa89b,
	0xa89d,
	0xa89f,
	0xa900,
	0xa902,
	0xa904,
	0xa906,
	0xa908,
	0xa90a,
	0xa90c,
	0xa90e,
	0xa911,
	0xa913,
	0xa915,
	0xa917,
	0xa919,
	0xa91b,
	0xa91d,
	0xa91f,
	0xa980,
	0xa982,
	0xa984,
	0xa986,
	0xa988,
	0xa98a,
	0xa98c,
	0xa98e,
	0xa991,
	0xa993,
	0xa995,
	0xa997,
	0xa999,
	0xa99b,
	0xa99d,
	0xa99f,
	0xaa20,
	0xaa22,
	0xaa24,
	0xaa26,
	0xaa28,
	0xaa2a,
	0xaa2c,
	0xaa2e,
	0xaa31,
	0xaa33,
	0xaa35,
	0xaa37,
	0xaa39,
	0xaa3b,
	0xaa3d,
	0xaa3f,
	0xaaa0,
	0xaaa2,
	0xaaa4,
	0xaaa6,
	0xaaa8,
	0xaaaa,
	0xaaac,
	0xaaae,
	0xaab1,
	0xaab3,
	0xaab5,
	0xaab7,
	0xaab9,
	0xaabb,
	0xaabd,
	0xaabf,
	0xab20,
	0xab22,
	0xab24,
	0xab26,
	0xab28,
	0xab2a,
	0xab2c,
	0xab2e,
	0xab31,
	0xab33,
	0xab35,
	0xab37,
	0xab39,
	0xab3b,
	0xab3d,
	0xab3f,
	0xaba0,
	0xaba2,
	0xaba4,
	0xaba6,
	0xaba8,
	0xabaa,
	0xabac,
	0xabae,
	0xabb1,
	0xabb3,
	0xabb5,
	0xabb7,
	0xabb9,
	0xabbb,
	0xabbd,
	0xabbf,
	0xac40,
	0xac42,
	0xac44,
	0xac46,
	0xac48,
	0xac4a,
	0xac4c,
	0xac4e,
	0xac51,
	0xac53,
	0xac55,
	0xac57,
	0xac59,
	0xac5b,
	0xac5d,
	0xac5f,
	0xacc0,
	0xacc2,
	0xacc4,
	0xacc6,
	0xacc8,
	0xacca,
	0xaccc,
	0xacce,
	0xacd1,
	0xacd3,
	0xacd5,
	0xacd7,
	0xacd9,
	0xacdb,
	0xacdd,
	0xacdf,
	0xad40,
	0xad42,
	0xad44,
	0xad46,
	0xad48,
	0xad4a,
	0xad4c,
	0xad4e,
	0xad51,
	0xad53,
	0xad55,
	0xad57,
	0xad59,
	0xad5b,
	0xad5d,
	0xad5f,
	0xadc0,
	0xadc2,
	0xadc4,
	0xadc6,
	0xadc8,
	0xadca,
	0xadcc,
	0xadce,
	0xadd1,
	0xadd3,
	0xadd5,
	0xadd7,
	0xadd9,
	0xaddb,
	0xaddd,
	0xaddf,
	0xae60,
	0xae62,
	0xae64,
	0xae66,
	0xae68,
	0xae6a,
	0xae6c,
	0xae6e,
	0xae71,
	0xae73,
	0xae75,
	0xae77,
	0xae79,
	0xae7b,
	0xae7d,
	0xae7f,
	0xaee0,
	0xaee2,
	0xaee4,
	0xaee6,
	0xaee8,
	0xaeea,
	0xaeec,
	0xaeee,
	0xaef1,
	0xaef3,
	0xaef5,
	0xaef7,
	0xaef9,
	0xaefb,
	0xaefd,
	0xaeff,
	0xaf60,
	0xaf62,
	0xaf64,
	0xaf66,
	0xaf68,
	0xaf6a,
	0xaf6c,
	0xaf6e,
	0xaf71,
	0xaf73,
	0xaf75,
	0xaf77,
	0xaf79,
	0xaf7b,
	0xaf7d,
	0xaf7f,
	0xafe0,
	0xafe2,
	0xafe4,
	0xafe6,
	0xafe8,
	0xafea,
	0xafec,
	0xafee,
	0xaff1,
	0xaff3,
	0xaff5,
	0xaff7,
	0xaff9,
	0xaffb,
	0xaffd,
	0xafff,
	0xb800,
	0xb802,
	0xb804,
	0xb806,
	0xb808,
	0xb80a,
	0xb80c,
	0xb80e,
	0xb811,
	0xb813,
	0xb815,
	0xb817,
	0xb819,
	0xb81b,
	0xb81d,
	0xb81f,
	0xb880,
	0xb882,
	0xb884,
	0xb886,
	0xb888,
	0xb88a,
	0xb88c,
	0xb88e,
	0xb891,
	0xb893,
	0xb895,
	0xb897,
	0xb899,
	0xb89b,
	0xb89d,
	0xb89f,
	0xb900,
	0xb902,
	0xb904,
	0xb906,
	0xb908,
	0xb90a,
	0xb90c,
	0xb90e,
	0xb911,
	0xb913,
	0xb915,
	0xb917,
	0xb919,
	0xb91b,
	0xb91d,
	0xb91f,
	0xb980,
	0xb982,
	0xb984,
	0xb986,
	0xb988,
	0xb98a,
	0xb98c,
	0xb98e,
	0xb991,
	0xb993,
	0xb995,
	0xb997,
	0xb999,
	0xb99b,
	0xb99d,
	0xb99f,
	0xba20,
	0xba22,
	0xba24,
	0xba26,
	0xba28,
	0xba2a,
	0xba2c,
	0xba2e,
	0xba31,
	0xba33,
	0xba35,
	0xba37,
	0xba39,
	0xba3b,
	0xba3d,
	0xba3f,
	0xbaa0,
	0xbaa2,
	0xbaa4,
	0xbaa6,
	0xbaa8,
	0xbaaa,
	0xbaac,
	0xbaae,
	0xbab1,
	0xbab3,
	0xbab5,
	0xbab7,
	0xbab9,
	0xbabb,
	0xbabd,
	0xbabf,
	0xbb20,
	0xbb22,
	0xbb24,
	0xbb26,
	0xbb28,
	0xbb2a,
	0xbb2c,
	0xbb2e,
	0xbb31,
	0xbb33,
	0xbb35,
	0xbb37,
	0xbb39,
	0xbb3b,
	0xbb3d,
	0xbb3f,
	0xbba0,
	0xbba2,
	0xbba4,
	0xbba6,
	0xbba8,
	0xbbaa,
	0xbbac,
	0xbbae,
	0xbbb1,
	0xbbb3,
	0xbbb5,
	0xbbb7,
	0xbbb9,
	0xbbbb,
	0xbbbd,
	0xbbbf,
	0xbc40,
	0xbc42,
	0xbc44,
	0xbc46,
	0xbc48,
	0xbc4a,
	0xbc4c,
	0xbc4e,
	0xbc51,
	0xbc53,
	0xbc55,
	0xbc57,
	0xbc59,
	0xbc5b,
	0xbc5d,
	0xbc5f,
	0xbcc0,
	0xbcc2,
	0xbcc4,
	0xbcc6,
	0xbcc8,
	0xbcca,
	0xbccc,
	0xbcce,
	0xbcd1,
	0xbcd3,
	0xbcd5,
	0xbcd7,
	0xbcd9,
	0xbcdb,
	0xbcdd,
	0xbcdf,
	0xbd40,
	0xbd42,
	0xbd44,
	0xbd46,
	0xbd48,
	0xbd4a,
	0xbd4c,
	0xbd4e,
	0xbd51,
	0xbd53,
	0xbd55,
	0xbd57,
	0xbd59,
	0xbd5b,
	0xbd5d,
	0xbd5f,
	0xbdc0,
	0xbdc2,
	0xbdc4,
	0xbdc6,
	0xbdc8,
	0xbdca,
	0xbdcc,
	0xbdce,
	0xbdd1,
	0xbdd3,
	0xbdd5,
	0xbdd7,
	0xbdd9,
	0xbddb,
	0xbddd,
	0xbddf,
	0xbe60,
	0xbe62,
	0xbe64,
	0xbe66,
	0xbe68,
	0xbe6a,
	0xbe6c,
	0xbe6e,
	0xbe71,
	0xbe73,
	0xbe75,
	0xbe77,
	0xbe79,
	0xbe7b,
	0xbe7d,
	0xbe7f,
	0xbee0,
	0xbee2,
	0xbee4,
	0xbee6,
	0xbee8,
	0xbeea,
	0xbeec,
	0xbeee,
	0xbef1,
	0xbef3,
	0xbef5,
	0xbef7,
	0xbef9,
	0xbefb,
	0xbefd,
	0xbeff,
	0xbf60,
	0xbf62,
	0xbf64,
	0xbf66,
	0xbf68,
	0xbf6a,
	0xbf6c,
	0xbf6e,
	0xbf71,
	0xbf73,
	0xbf75,
	0xbf77,
	0xbf79,
	0xbf7b,
	0xbf7d,
	0xbf7f,
	0xbfe0,
	0xbfe2,
	0xbfe4,
	0xbfe6,
	0xbfe8,
	0xbfea,
	0xbfec,
	0xbfee,
	0xbff1,
	0xbff3,
	0xbff5,
	0xbff7,
	0xbff9,
	0xbffb,
	0xbffd,
	0xbfff,
	0xc800,
	0xc802,
	0xc804,
	0xc806,
	0xc808,
	0xc80a,
	0xc80c,
	0xc80e,
	0xc811,
	0xc813,
	0xc815,
	0xc817,
	0xc819,
	0xc81b,
	0xc81d,
	0xc81f,
	0xc880,
	0xc882,
	0xc884,
	0xc886,
	0xc888,
	0xc88a,
	0xc88c,
	0xc88e,
	0xc891,
	0xc893,
	0xc895,
	0xc897,
	0xc899,
	0xc89b,
	0xc89d,
	0xc89f,
	0xc900,
	0xc902,
	0xc904,
	0xc906,
	0xc908,
	0xc90a,
	0xc90c,
	0xc90e,
	0xc911,
	0xc913,
	0xc915,
	0xc917,
	0xc919,
	0xc91b,
	0xc91d,
	0xc91f,
	0xc980,
	0xc982,
	0xc984,
	0xc986,
	0xc988,
	0xc98a,
	0xc98c,
	0xc98e,
	0xc991,
	0xc993,
	0xc995,
	0xc997,
	0xc999,
	0xc99b,
	0xc99d,
	0xc99f,
	0xca20,
	0xca22,
	0xca24,
	0xca26,
	0xca28,
	0xca2a,
	0xca2c,
	0xca2e,
	0xca31,
	0xca33,
	0xca35,
	0xca37,
	0xca39,
	0xca3b,
	0xca3d,
	0xca3f,
	0xcaa0,
	0xcaa2,
	0xcaa4,
	0xcaa6,
	0xcaa8,
	0xcaaa,
	0xcaac,
	0xcaae,
	0xcab1,
	0xcab3,
	0xcab5,
	0xcab7,
	0xcab9,
	0xcabb,
	0xcabd,
	0xcabf,
	0xcb20,
	0xcb22,
	0xcb24,
	0xcb26,
	0xcb28,
	0xcb2a,
	0xcb2c,
	0xcb2e,
	0xcb31,
	0xcb33,
	0xcb35,
	0xcb37,
	0xcb39,
	0xcb3b,
	0xcb3d,
	0xcb3f,
	0xcba0,
	0xcba2,
	0xcba4,
	0xcba6,
	0xcba8,
	0xcbaa,
	0xcbac,
	0xcbae,
	0xcbb1,
	0xcbb3,
	0xcbb5,
	0xcbb7,
	0xcbb9,
	0xcbbb,
	0xcbbd,
	0xcbbf,
	0xcc40,
	0xcc42,
	0xcc44,
	0xcc46,
	0xcc48,
	0xcc4a,
	0xcc4c,
	0xcc4e,
	0xcc51,
	0xcc53,
	0xcc55,
	0xcc57,
	0xcc59,
	0xcc5b,
	0xcc5d,
	0xcc5f,
	0xccc0,
	0xccc2,
	0xccc4,
	0xccc6,
	0xccc8,
	0xccca,
	0xcccc,
	0xccce,
	0xccd1,
	0xccd3,
	0xccd5,
	0xccd7,
	0xccd9,
	0xccdb,
	0xccdd,
	0xccdf,
	0xcd40,
	0xcd42,
	0xcd44,
	0xcd46,
	0xcd48,
	0xcd4a,
	0xcd4c,
	0xcd4e,
	0xcd51,
	0xcd53,
	0xcd55,
	0xcd57,
	0xcd59,
	0xcd5b,
	0xcd5d,
	0xcd5f,
	0xcdc0,
	0xcdc2,
	0xcdc4,
	0xcdc6,
	0xcdc8,
	0xcdca,
	0xcdcc,
	0xcdce,
	0xcdd1,
	0xcdd3,
	0xcdd5,
	0xcdd7,
	0xcdd9,
	0xcddb,
	0xcddd,
	0xcddf,
	0xce60,
	0xce62,
	0xce64,
	0xce66,
	0xce68,
	0xce6a,
	0xce6c,
	0xce6e,
	0xce71,
	0xce73,
	0xce75,
	0xce77,
	0xce79,
	0xce7b,
	0xce7d,
	0xce7f,
	0xcee0,
	0xcee2,
	0xcee4,
	0xcee6,
	0xcee8,
	0xceea,
	0xceec,
	0xceee,
	0xcef1,
	0xcef3,
	0xcef5,
	0xcef7,
	0xcef9,
	0xcefb,
	0xcefd,
	0xceff,
	0xcf60,
	0xcf62,
	0xcf64,
	0xcf66,
	0xcf68,
	0xcf6a,
	0xcf6c,
	0xcf6e,
	0xcf71,
	0xcf73,
	0xcf75,
	0xcf77,
	0xcf79,
	0xcf7b,
	0xcf7d,
	0xcf7f,
	0xcfe0,
	0xcfe2,
	0xcfe4,
	0xcfe6,
	0xcfe8,
	0xcfea,
	0xcfec,
	0xcfee,
	0xcff1,
	0xcff3,
	0xcff5,
	0xcff7,
	0xcff9,
	0xcffb,
	0xcffd,
	0xcfff,
	0xd800,
	0xd802,
	0xd804,
	0xd806,
	0xd808,
	0xd80a,
	0xd80c,
	0xd80e,
	0xd811,
	0xd813,
	0xd815,
	0xd817,
	0xd819,
	0xd81b,
	0xd81d,
	0xd81f,
	0xd880,
	0xd882,
	0xd884,
	0xd886,
	0xd888,
	0xd88a,
	0xd88c,
	0xd88e,
	0xd891,
	0xd893,
	0xd895,
	0xd897,
	0xd899,
	0xd89b,
	0xd89d,
	0xd89f,
	0xd900,
	0xd902,
	0xd904,
	0xd906,
	0xd908,
	0xd90a,
	0xd90c,
	0xd90e,
	0xd911,
	0xd913,
	0xd915,
	0xd917,
	0xd919,
	0xd91b,
	0xd91d,
	0xd91f,
	0xd980,
	0xd982,
	0xd984,
	0xd986,
	0xd988,
	0xd98a,
	0xd98c,
	0xd98e,
	0xd991,
	0xd993,
	0xd995,
	0xd997,
	0xd999,
	0xd99b,
	0xd99d,
	0xd99f,
	0xda20,
	0xda22,
	0xda24,
	0xda26,
	0xda28,
	0xda2a,
	0xda2c,
	0xda2e,
	0xda31,
	0xda33,
	0xda35,
	0xda37,
	0xda39,
	0xda3b,
	0xda3d,
	0xda3f,
	0xdaa0,
	0xdaa2,
	0xdaa4,
	0xdaa6,
	0xdaa8,
	0xdaaa,
	0xdaac,
	0xdaae,
	0xdab1,
	0xdab3,
	0xdab5,
	0xdab7,
	0xdab9,
	0xdabb,
	0xdabd,
	0xdabf,
	0xdb20,
	0xdb22,
	0xdb24,
	0xdb26,
	0xdb28,
	0xdb2a,
	0xdb2c,
	0xdb2e,
	0xdb31,
	0xdb33,
	0xdb35,
	0xdb37,
	0xdb39,
	0xdb3b,
	0xdb3d,
	0xdb3f,
	0xdba0,
	0xdba2,
	0xdba4,
	0xdba6,
	0xdba8,
	0xdbaa,
	0xdbac,
	0xdbae,
	0xdbb1,
	0xdbb3,
	0xdbb5,
	0xdbb7,
	0xdbb9,
	0xdbbb,
	0xdbbd,
	0xdbbf,
	0xdc40,
	0xdc42,
	0xdc44,
	0xdc46,
	0xdc48,
	0xdc4a,
	0xdc4c,
	0xdc4e,
	0xdc51,
	0xdc53,
	0xdc55,
	0xdc57,
	0xdc59,
	0xdc5b,
	0xdc5d,
	0xdc5f,
	0xdcc0,
	0xdcc2,
	0xdcc4,
	0xdcc6,
	0xdcc8,
	0xdcca,
	0xdccc,
	0xdcce,
	0xdcd1,
	0xdcd3,
	0xdcd5,
	0xdcd7,
	0xdcd9,
	0xdcdb,
	0xdcdd,
	0xdcdf,
	0xdd40,
	0xdd42,
	0xdd44,
	0xdd46,
	0xdd48,
	0xdd4a,
	0xdd4c,
	0xdd4e,
	0xdd51,
	0xdd53,
	0xdd55,
	0xdd57,
	0xdd59,
	0xdd5b,
	0xdd5d,
	0xdd5f,
	0xddc0,
	0xddc2,
	0xddc4,
	0xddc6,
	0xddc8,
	0xddca,
	0xddcc,
	0xddce,
	0xddd1,
	0xddd3,
	0xddd5,
	0xddd7,
	0xddd9,
	0xdddb,
	0xdddd,
	0xdddf,
	0xde60,
	0xde62,
	0xde64,
	0xde66,
	0xde68,
	0xde6a,
	0xde6c,
	0xde6e,
	0xde71,
	0xde73,
	0xde75,
	0xde77,
	0xde79,
	0xde7b,
	0xde7d,
	0xde7f,
	0xdee0,
	0xdee2,
	0xdee4,
	0xdee6,
	0xdee8,
	0xdeea,
	0xdeec,
	0xdeee,
	0xdef1,
	0xdef3,
	0xdef5,
	0xdef7,
	0xdef9,
	0xdefb,
	0xdefd,
	0xdeff,
	0xdf60,
	0xdf62,
	0xdf64,
	0xdf66,
	0xdf68,
	0xdf6a,
	0xdf6c,
	0xdf6e,
	0xdf71,
	0xdf73,
	0xdf75,
	0xdf77,
	0xdf79,
	0xdf7b,
	0xdf7d,
	0xdf7f,
	0xdfe0,
	0xdfe2,
	0xdfe4,
	0xdfe6,
	0xdfe8,
	0xdfea,
	0xdfec,
	0xdfee,
	0xdff1,
	0xdff3,
	0xdff5,
	0xdff7,
	0xdff9,
	0xdffb,
	0xdffd,
	0xdfff,
	0xe800,
	0xe802,
	0xe804,
	0xe806,
	0xe808,
	0xe80a,
	0xe80c,
	0xe80e,
	0xe811,
	0xe813,
	0xe815,
	0xe817,
	0xe819,
	0xe81b,
	0xe81d,
	0xe81f,
	0xe880,
	0xe882,
	0xe884,
	0xe886,
	0xe888,
	0xe88a,
	0xe88c,
	0xe88e,
	0xe891,
	0xe893,
	0xe895,
	0xe897,
	0xe899,
	0xe89b,
	0xe89d,
	0xe89f,
	0xe900,
	0xe902,
	0xe904,
	0xe906,
	0xe908,
	0xe90a,
	0xe90c,
	0xe90e,
	0xe911,
	0xe913,
	0xe915,
	0xe917,
	0xe919,
	0xe91b,
	0xe91d,
	0xe91f,
	0xe980,
	0xe982,
	0xe984,
	0xe986,
	0xe988,
	0xe98a,
	0xe98c,
	0xe98e,
	0xe991,
	0xe993,
	0xe995,
	0xe997,
	0xe999,
	0xe99b,
	0xe99d,
	0xe99f,
	0xea20,
	0xea22,
	0xea24,
	0xea26,
	0xea28,
	0xea2a,
	0xea2c,
	0xea2e,
	0xea31,
	0xea33,
	0xea35,
	0xea37,
	0xea39,
	0xea3b,
	0xea3d,
	0xea3f,
	0xeaa0,
	0xeaa2,
	0xeaa4,
	0xeaa6,
	0xeaa8,
	0xeaaa,
	0xeaac,
	0xeaae,
	0xeab1,
	0xeab3,
	0xeab5,
	0xeab7,
	0xeab9,
	0xeabb,
	0xeabd,
	0xeabf,
	0xeb20,
	0xeb22,
	0xeb24,
	0xeb26,
	0xeb28,
	0xeb2a,
	0xeb2c,
	0xeb2e,
	0xeb31,
	0xeb33,
	0xeb35,
	0xeb37,
	0xeb39,
	0xeb3b,
	0xeb3d,
	0xeb3f,
	0xeba0,
	0xeba2,
	0xeba4,
	0xeba6,
	0xeba8,
	0xebaa,
	0xebac,
	0xebae,
	0xebb1,
	0xebb3,
	0xebb5,
	0xebb7,
	0xebb9,
	0xebbb,
	0xebbd,
	0xebbf,
	0xec40,
	0xec42,
	0xec44,
	0xec46,
	0xec48,
	0xec4a,
	0xec4c,
	0xec4e,
	0xec51,
	0xec53,
	0xec55,
	0xec57,
	0xec59,
	0xec5b,
	0xec5d,
	0xec5f,
	0xecc0,
	0xecc2,
	0xecc4,
	0xecc6,
	0xecc8,
	0xecca,
	0xeccc,
	0xecce,
	0xecd1,
	0xecd3,
	0xecd5,
	0xecd7,
	0xecd9,
	0xecdb,
	0xecdd,
	0xecdf,
	0xed40,
	0xed42,
	0xed44,
	0xed46,
	0xed48,
	0xed4a,
	0xed4c,
	0xed4e,
	0xed51,
	0xed53,
	0xed55,
	0xed57,
	0xed59,
	0xed5b,
	0xed5d,
	0xed5f,
	0xedc0,
	0xedc2,
	0xedc4,
	0xedc6,
	0xedc8,
	0xedca,
	0xedcc,
	0xedce,
	0xedd1,
	0xedd3,
	0xedd5,
	0xedd7,
	0xedd9,
	0xeddb,
	0xeddd,
	0xeddf,
	0xee60,
	0xee62,
	0xee64,
	0xee66,
	0xee68,
	0xee6a,
	0xee6c,
	0xee6e,
	0xee71,
	0xee73,
	0xee75,
	0xee77,
	0xee79,
	0xee7b,
	0xee7d,
	0xee7f,
	0xeee0,
	0xeee2,
	0xeee4,
	0xeee6,
	0xeee8,
	0xeeea,
	0xeeec,
	0xeeee,
	0xeef1,
	0xeef3,
	0xeef5,
	0xeef7,
	0xeef9,
	0xeefb,
	0xeefd,
	0xeeff,
	0xef60,
	0xef62,
	0xef64,
	0xef66,
	0xef68,
	0xef6a,
	0xef6c,
	0xef6e,
	0xef71,
	0xef73,
	0xef75,
	0xef77,
	0xef79,
	0xef7b,
	0xef7d,
	0xef7f,
	0xefe0,
	0xefe2,
	0xefe4,
	0xefe6,
	0xefe8,
	0xefea,
	0xefec,
	0xefee,
	0xeff1,
	0xeff3,
	0xeff5,
	0xeff7,
	0xeff9,
	0xeffb,
	0xeffd,
	0xefff,
	0xf800,
	0xf802,
	0xf804,
	0xf806,
	0xf808,
	0xf80a,
	0xf80c,
	0xf80e,
	0xf811,
	0xf813,
	0xf815,
	0xf817,
	0xf819,
	0xf81b,
	0xf81d,
	0xf81f,
	0xf880,
	0xf882,
	0xf884,
	0xf886,
	0xf888,
	0xf88a,
	0xf88c,
	0xf88e,
	0xf891,
	0xf893,
	0xf895,
	0xf897,
	0xf899,
	0xf89b,
	0xf89d,
	0xf89f,
	0xf900,
	0xf902,
	0xf904,
	0xf906,
	0xf908,
	0xf90a,
	0xf90c,
	0xf90e,
	0xf911,
	0xf913,
	0xf915,
	0xf917,
	0xf919,
	0xf91b,
	0xf91d,
	0xf91f,
	0xf980,
	0xf982,
	0xf984,
	0xf986,
	0xf988,
	0xf98a,
	0xf98c,
	0xf98e,
	0xf991,
	0xf993,
	0xf995,
	0xf997,
	0xf999,
	0xf99b,
	0xf99d,
	0xf99f,
	0xfa20,
	0xfa22,
	0xfa24,
	0xfa26,
	0xfa28,
	0xfa2a,
	0xfa2c,
	0xfa2e,
	0xfa31,
	0xfa33,
	0xfa35,
	0xfa37,
	0xfa39,
	0xfa3b,
	0xfa3d,
	0xfa3f,
	0xfaa0,
	0xfaa2,
	0xfaa4,
	0xfaa6,
	0xfaa8,
	0xfaaa,
	0xfaac,
	0xfaae,
	0xfab1,
	0xfab3,
	0xfab5,
	0xfab7,
	0xfab9,
	0xfabb,
	0xfabd,
	0xfabf,
	0xfb20,
	0xfb22,
	0xfb24,
	0xfb26,
	0xfb28,
	0xfb2a,
	0xfb2c,
	0xfb2e,
	0xfb31,
	0xfb33,
	0xfb35,
	0xfb37,
	0xfb39,
	0xfb3b,
	0xfb3d,
	0xfb3f,
	0xfba0,
	0xfba2,
	0xfba4,
	0xfba6,
	0xfba8,
	0xfbaa,
	0xfbac,
	0xfbae,
	0xfbb1,
	0xfbb3,
	0xfbb5,
	0xfbb7,
	0xfbb9,
	0xfbbb,
	0xfbbd,
	0xfbbf,
	0xfc40,
	0xfc42,
	0xfc44,
	0xfc46,
	0xfc48,
	0xfc4a,
	0xfc4c,
	0xfc4e,
	0xfc51,
	0xfc53,
	0xfc55,
	0xfc57,
	0xfc59,
	0xfc5b,
	0xfc5d,
	0xfc5f,
	0xfcc0,
	0xfcc2,
	0xfcc4,
	0xfcc6,
	0xfcc8,
	0xfcca,
	0xfccc,
	0xfcce,
	0xfcd1,
	0xfcd3,
	0xfcd5,
	0xfcd7,
	0xfcd9,
	0xfcdb,
	0xfcdd,
	0xfcdf,
	0xfd40,
	0xfd42,
	0xfd44,
	0xfd46,
	0xfd48,
	0xfd4a,
	0xfd4c,
	0xfd4e,
	0xfd51,
	0xfd53,
	0xfd55,
	0xfd57,
	0xfd59,
	0xfd5b,
	0xfd5d,
	0xfd5f,
	0xfdc0,
	0xfdc2,
	0xfdc4,
	0xfdc6,
	0xfdc8,
	0xfdca,
	0xfdcc,
	0xfdce,
	0xfdd1,
	0xfdd3,
	0xfdd5,
	0xfdd7,
	0xfdd9,
	0xfddb,
	0xfddd,
	0xfddf,
	0xfe60,
	0xfe62,
	0xfe64,
	0xfe66,
	0xfe68,
	0xfe6a,
	0xfe6c,
	0xfe6e,
	0xfe71,
	0xfe73,
	0xfe75,
	0xfe77,
	0xfe79,
	0xfe7b,
	0xfe7d,
	0xfe7f,
	0xfee0,
	0xfee2,
	0xfee4,
	0xfee6,
	0xfee8,
	0xfeea,
	0xfeec,
	0xfeee,
	0xfef1,
	0xfef3,
	0xfef5,
	0xfef7,
	0xfef9,
	0xfefb,
	0xfefd,
	0xfeff,
	0xff60,
	0xff62,
	0xff64,
	0xff66,
	0xff68,
	0xff6a,
	0xff6c,
	0xff6e,
	0xff71,
	0xff73,
	0xff75,
	0xff77,
	0xff79,
	0xff7b,
	0xff7d,
	0xff7f,
	0xffe0,
	0xffe2,
	0xffe4,
	0xffe6,
	0xffe8,
	0xffea,
	0xffec,
	0xffee,
	0xfff1,
	0xfff3,
	0xfff5,
	0xfff7,
	0xfff9,
	0xfffb,
	0xfffd,
	0xffff
};


