// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <e32std.h>

extern const TUint32 wordlutab[256]=
	{	0x0000,	0x0003,	0x000c,	0x000f,	0x0030,	0x0033,	0x003c,	0x003f,
		0x00c0,	0x00c3,	0x00cc,	0x00cf,	0x00f0,	0x00f3,	0x00fc,	0x00ff,
		0x0300,	0x0303,	0x030c,	0x030f,	0x0330,	0x0333,	0x033c,	0x033f,
		0x03c0,	0x03c3,	0x03cc,	0x03cf,	0x03f0,	0x03f3,	0x03fc,	0x03ff,
		0x0c00,	0x0c03,	0x0c0c,	0x0c0f,	0x0c30,	0x0c33,	0x0c3c,	0x0c3f,
		0x0cc0,	0x0cc3,	0x0ccc,	0x0ccf,	0x0cf0,	0x0cf3,	0x0cfc,	0x0cff,
		0x0f00,	0x0f03,	0x0f0c,	0x0f0f,	0x0f30,	0x0f33,	0x0f3c,	0x0f3f,
		0x0fc0,	0x0fc3,	0x0fcc,	0x0fcf,	0x0ff0,	0x0ff3,	0x0ffc,	0x0fff,
		0x3000,	0x3003,	0x300c,	0x300f,	0x3030,	0x3033,	0x303c,	0x303f,
		0x30c0,	0x30c3,	0x30cc,	0x30cf,	0x30f0,	0x30f3,	0x30fc,	0x30ff,
		0x3300,	0x3303,	0x330c,	0x330f,	0x3330,	0x3333,	0x333c,	0x333f,
		0x33c0,	0x33c3,	0x33cc,	0x33cf,	0x33f0,	0x33f3,	0x33fc,	0x33ff,
		0x3c00,	0x3c03,	0x3c0c,	0x3c0f,	0x3c30,	0x3c33,	0x3c3c,	0x3c3f,
		0x3cc0,	0x3cc3,	0x3ccc,	0x3ccf,	0x3cf0,	0x3cf3,	0x3cfc,	0x3cff,
		0x3f00,	0x3f03,	0x3f0c,	0x3f0f,	0x3f30,	0x3f33,	0x3f3c,	0x3f3f,
		0x3fc0,	0x3fc3,	0x3fcc,	0x3fcf,	0x3ff0,	0x3ff3,	0x3ffc,	0x3fff,
		0xc000,	0xc003,	0xc00c,	0xc00f,	0xc030,	0xc033,	0xc03c,	0xc03f,
		0xc0c0,	0xc0c3,	0xc0cc,	0xc0cf,	0xc0f0,	0xc0f3,	0xc0fc,	0xc0ff,
		0xc300,	0xc303,	0xc30c,	0xc30f,	0xc330,	0xc333,	0xc33c,	0xc33f,
		0xc3c0,	0xc3c3,	0xc3cc,	0xc3cf,	0xc3f0,	0xc3f3,	0xc3fc,	0xc3ff,
		0xcc00,	0xcc03,	0xcc0c,	0xcc0f,	0xcc30,	0xcc33,	0xcc3c,	0xcc3f,
		0xccc0,	0xccc3,	0xcccc,	0xcccf,	0xccf0,	0xccf3,	0xccfc,	0xccff,
		0xcf00,	0xcf03,	0xcf0c,	0xcf0f,	0xcf30,	0xcf33,	0xcf3c,	0xcf3f,
		0xcfc0,	0xcfc3,	0xcfcc,	0xcfcf,	0xcff0,	0xcff3,	0xcffc,	0xcfff,
		0xf000,	0xf003,	0xf00c,	0xf00f,	0xf030,	0xf033,	0xf03c,	0xf03f,
		0xf0c0,	0xf0c3,	0xf0cc,	0xf0cf,	0xf0f0,	0xf0f3,	0xf0fc,	0xf0ff,
		0xf300,	0xf303,	0xf30c,	0xf30f,	0xf330,	0xf333,	0xf33c,	0xf33f,
		0xf3c0,	0xf3c3,	0xf3cc,	0xf3cf,	0xf3f0,	0xf3f3,	0xf3fc,	0xf3ff,
		0xfc00,	0xfc03,	0xfc0c,	0xfc0f,	0xfc30,	0xfc33,	0xfc3c,	0xfc3f,
		0xfcc0,	0xfcc3,	0xfccc,	0xfccf,	0xfcf0,	0xfcf3,	0xfcfc,	0xfcff,
		0xff00,	0xff03,	0xff0c,	0xff0f,	0xff30,	0xff33,	0xff3c,	0xff3f,
		0xffc0,	0xffc3,	0xffcc,	0xffcf,	0xfff0,	0xfff3,	0xfffc,	0xffff	};

extern const TUint32 modelutab[256]=
	{	0x0000,	0x0005,	0x000a,	0x000f,	0x0050,	0x0055,	0x005a,	0x005f,
		0x00a0,	0x00a5,	0x00aa,	0x00af,	0x00f0,	0x00f5,	0x00fa,	0x00ff,
		0x0500,	0x0505,	0x050a,	0x050f,	0x0550,	0x0555,	0x055a,	0x055f,
		0x05a0,	0x05a5,	0x05aa,	0x05af,	0x05f0,	0x05f5,	0x05fa,	0x05ff,
		0x0a00,	0x0a05,	0x0a0a,	0x0a0f,	0x0a50,	0x0a55,	0x0a5a,	0x0a5f,
		0x0aa0,	0x0aa5,	0x0aaa,	0x0aaf,	0x0af0,	0x0af5,	0x0afa,	0x0aff,
		0x0f00,	0x0f05,	0x0f0a,	0x0f0f,	0x0f50,	0x0f55,	0x0f5a,	0x0f5f,
		0x0fa0,	0x0fa5,	0x0faa,	0x0faf,	0x0ff0,	0x0ff5,	0x0ffa,	0x0fff,
		0x5000,	0x5005,	0x500a,	0x500f,	0x5050,	0x5055,	0x505a,	0x505f,
		0x50a0,	0x50a5,	0x50aa,	0x50af,	0x50f0,	0x50f5,	0x50fa,	0x50ff,
		0x5500,	0x5505,	0x550a,	0x550f,	0x5550,	0x5555,	0x555a,	0x555f,
		0x55a0,	0x55a5,	0x55aa,	0x55af,	0x55f0,	0x55f5,	0x55fa,	0x55ff,
		0x5a00,	0x5a05,	0x5a0a,	0x5a0f,	0x5a50,	0x5a55,	0x5a5a,	0x5a5f,
		0x5aa0,	0x5aa5,	0x5aaa,	0x5aaf,	0x5af0,	0x5af5,	0x5afa,	0x5aff,
		0x5f00,	0x5f05,	0x5f0a,	0x5f0f,	0x5f50,	0x5f55,	0x5f5a,	0x5f5f,
		0x5fa0,	0x5fa5,	0x5faa,	0x5faf,	0x5ff0,	0x5ff5,	0x5ffa,	0x5fff,
		0xa000,	0xa005,	0xa00a,	0xa00f,	0xa050,	0xa055,	0xa05a,	0xa05f,
		0xa0a0,	0xa0a5,	0xa0aa,	0xa0af,	0xa0f0,	0xa0f5,	0xa0fa,	0xa0ff,
		0xa500,	0xa505,	0xa50a,	0xa50f,	0xa550,	0xa555,	0xa55a,	0xa55f,
		0xa5a0,	0xa5a5,	0xa5aa,	0xa5af,	0xa5f0,	0xa5f5,	0xa5fa,	0xa5ff,
		0xaa00,	0xaa05,	0xaa0a,	0xaa0f,	0xaa50,	0xaa55,	0xaa5a,	0xaa5f,
		0xaaa0,	0xaaa5,	0xaaaa,	0xaaaf,	0xaaf0,	0xaaf5,	0xaafa,	0xaaff,
		0xaf00,	0xaf05,	0xaf0a,	0xaf0f,	0xaf50,	0xaf55,	0xaf5a,	0xaf5f,
		0xafa0,	0xafa5,	0xafaa,	0xafaf,	0xaff0,	0xaff5,	0xaffa,	0xafff,
		0xf000,	0xf005,	0xf00a,	0xf00f,	0xf050,	0xf055,	0xf05a,	0xf05f,
		0xf0a0,	0xf0a5,	0xf0aa,	0xf0af,	0xf0f0,	0xf0f5,	0xf0fa,	0xf0ff,
		0xf500,	0xf505,	0xf50a,	0xf50f,	0xf550,	0xf555,	0xf55a,	0xf55f,
		0xf5a0,	0xf5a5,	0xf5aa,	0xf5af,	0xf5f0,	0xf5f5,	0xf5fa,	0xf5ff,
		0xfa00,	0xfa05,	0xfa0a,	0xfa0f,	0xfa50,	0xfa55,	0xfa5a,	0xfa5f,
		0xfaa0,	0xfaa5,	0xfaaa,	0xfaaf,	0xfaf0,	0xfaf5,	0xfafa,	0xfaff,
		0xff00,	0xff05,	0xff0a,	0xff0f,	0xff50,	0xff55,	0xff5a,	0xff5f,
		0xffa0,	0xffa5,	0xffaa,	0xffaf,	0xfff0,	0xfff5,	0xfffa,	0xffff	};

extern const TUint8 ditherlutab[16][4]=
	{{	0x0,	0x0,	0x0,	0x0,	},
	{	0x5,	0x0,	0x0,	0x0,	},
	{	0x5,	0x0,	0x0,	0x5,	},
	{	0x5,	0x0,	0x0,	0x5,	},
	{	0x5,	0x0,	0x5,	0x5,	},
	{	0x5,	0x5,	0x5,	0x5,	},
	{	0xa,	0x5,	0x5,	0x5,	},
	{	0xa,	0x5,	0x5,	0xa,	},
	{	0xa,	0x5,	0x5,	0xa,	},
	{	0xa,	0x5,	0xa,	0xa,	},
	{	0xa,	0xa,	0xa,	0xa,	},
	{	0xf,	0xa,	0xa,	0xa,	},
	{	0xf,	0xa,	0xa,	0xf,	},
	{	0xf,	0xa,	0xa,	0xf,	},
	{	0xf,	0xa,	0xf,	0xf,	},
	{	0xf,	0xf,	0xf,	0xf		}};

extern const TUint8 shadowlutab[256]=
	{	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x01,	0x02,
		0x03,	0x04,	0x05,	0x06,	0x07,	0x08,	0x09,	0x0a,
		0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x01,	0x02,
		0x03,	0x04,	0x05,	0x06,	0x07,	0x08,	0x09,	0x0a,
		0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x01,	0x02,
		0x03,	0x04,	0x05,	0x06,	0x07,	0x08,	0x09,	0x0a,
		0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x01,	0x02,
		0x03,	0x04,	0x05,	0x06,	0x07,	0x08,	0x09,	0x0a,
		0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x01,	0x02,
		0x03,	0x04,	0x05,	0x06,	0x07,	0x08,	0x09,	0x0a,
		0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x01,	0x02,
		0x03,	0x04,	0x05,	0x06,	0x07,	0x08,	0x09,	0x0a,
		0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x11,	0x12,
		0x13,	0x14,	0x15,	0x16,	0x17,	0x18,	0x19,	0x1a,
		0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x21,	0x22,
		0x23,	0x24,	0x25,	0x26,	0x27,	0x28,	0x29,	0x2a,
		0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x31,	0x32,
		0x33,	0x34,	0x35,	0x36,	0x37,	0x38,	0x39,	0x3a,
		0x40,	0x40,	0x40,	0x40,	0x40,	0x40,	0x41,	0x42,
		0x43,	0x44,	0x45,	0x46,	0x47,	0x48,	0x49,	0x4a,
		0x50,	0x50,	0x50,	0x50,	0x50,	0x50,	0x51,	0x52,
		0x53,	0x54,	0x55,	0x56,	0x57,	0x58,	0x59,	0x5a,
		0x60,	0x60,	0x60,	0x60,	0x60,	0x60,	0x61,	0x62,
		0x63,	0x64,	0x65,	0x66,	0x67,	0x68,	0x69,	0x6a,
		0x70,	0x70,	0x70,	0x70,	0x70,	0x70,	0x71,	0x72,
		0x73,	0x74,	0x75,	0x76,	0x77,	0x78,	0x79,	0x7a,
		0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x81,	0x82,
		0x83,	0x84,	0x85,	0x86,	0x87,	0x88,	0x89,	0x8a,
		0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x91,	0x92,
		0x93,	0x94,	0x95,	0x96,	0x97,	0x98,	0x99,	0x9a,
		0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa1,	0xa2,
		0xa3,	0xa4,	0xa5,	0xa6,	0xa7,	0xa8,	0xa9,	0xaa	};

extern const TUint8 color256shadowlutab[256] = {
	0,	0,	1,	2,	3,	4,
	0,	0,	1,	2,	3,	4,
	6,	6,	7,	8,	9,	10,
	12,	12,	13,	14,	15,	16,
	18,	18,	19,	20,	21,	22,
	24,	24,	25,	26,	27,	28,

	0,	0,	1,	2,	3,	4,
	0,	0,	1,	2,	3,	4,
	6,	6,	7,	8,	9,	10,
	12,	12,	13,	14,	15,	16,
	18,	18,	19,	20,	21,	22,
	24,	24,	25,	26,	27,	28,

	36,	36,	37,	38,	39,	40,
	36,	36,	37,	38,	39,	40,
	42,	42,	43,	44,	45,	46,
	48,	48,	49,	50,	51,	52,
	54,	54,	55,	56,	57,	58,
	60,	60,	61,	62,	63,	64,

	0, 0, 108, 109, 110,
	0, 0, 113, 114, 115,
	0, 0, 118, 119, 120,
	0, 0, 123, 124, 125,

	126, 127, 128, 129, 130,
	121, 122, 133, 134, 135,
	116, 117, 138, 139, 140,
	111, 112, 143, 144, 145,

	72,	72,	73,	74,	75,	76,
	72,	72,	73,	74,	75,	76,
	78,	78,	79,	80,	81,	82,
	84,	84,	85,	86,	87,	88,
	90,	90,	91,	92,	93,	94,
	96,	96,	97,	98,	99,	100,

	148, 148, 149, 150, 151, 152,
	148, 148, 149, 150, 151, 152,
	154, 154, 155, 156, 157, 158,
	160, 160, 161, 162, 163, 164,
	166, 166, 167, 168, 169, 170,
	172, 172, 173, 174, 175, 176,

	184, 184, 185, 186, 187, 188,
	184, 184, 185, 186, 187, 188,
	190, 190, 191, 192, 193, 194,
	196, 196, 197, 198, 199, 200,
	202, 202, 203, 204, 205, 206,
	208, 208, 209, 210, 211, 212
	};
	
/**
This lookup table is used for outline and shadow fonts. Four entries of this table represents
% of Outline, Shadow, Fill and Background colour to be used to get the final colour to be 
displayed on screen.

While doing the blending of four colours it would use the following formula,

blendedXXXColor = (XXXOutlinePenColor * FourColorBlendLookup[index][KOutlineColorIndex] + 
			   		XXXShadowColor * FourColorBlendLookup[index][KShadowColorIndex] +
			  		XXXFillColor * FourColorBlendLookup[index][KFillColorIndex] + 
			  		backgroundColor.XXX() * FourColorBlendLookup[index][KBackgroundColorIndex]) >> 8;
where XXX can be Red, Green or Blue
and index is the 8-bit value which will be provided by the rasterizer to decide which 
entry of lookup table should be used. Right shift by eight will divide the calculated value in % with 
256 to get the actual colour.

This table is provided by Monotype and MUST NOT be changed.
*/
extern const TInt FourColorBlendLookup[256][4] = {
	{ 0, 0, 0, 255 },
	{ 0, 0, 17, 238 },
	{ 0, 0, 34, 221 },
	{ 0, 0, 51, 204 },
	{ 0, 0, 68, 187 },
	{ 0, 0, 85, 170 },
	{ 0, 0, 102, 153 },
	{ 0, 0, 119, 136 },
	{ 0, 0, 136, 119 },
	{ 0, 0, 153, 102 },
	{ 0, 0, 170, 85 },
	{ 0, 0, 187, 68 },
	{ 0, 0, 204, 51 },
	{ 0, 0, 221, 34 },
	{ 0, 0, 238, 17 },
	{ 0, 0, 255, 0 },
	{ 0, 17, 0, 238 },
	{ 0, 34, 0, 221 },
	{ 0, 51, 0, 204 },
	{ 0, 68, 0, 187 },
	{ 0, 85, 0, 170 },
	{ 0, 102, 0, 153 },
	{ 0, 119, 0, 136 },
	{ 0, 136, 0, 119 },
	{ 0, 153, 0, 102 },
	{ 0, 170, 0, 85 },
	{ 0, 187, 0, 68 },
	{ 0, 204, 0, 51 },
	{ 0, 221, 0, 34 },
	{ 0, 238, 0, 17 },
	{ 0, 255, 0, 0 },
	{ 17, 0, 0, 238 },
	{ 34, 0, 0, 221 },
	{ 51, 0, 0, 204 },
	{ 68, 0, 0, 187 },
	{ 85, 0, 0, 170 },
	{ 102, 0, 0, 153 },
	{ 119, 0, 0, 136 },
	{ 136, 0, 0, 119 },
	{ 153, 0, 0, 102 },
	{ 170, 0, 0, 85 },
	{ 187, 0, 0, 68 },
	{ 204, 0, 0, 51 },
	{ 221, 0, 0, 34 },
	{ 238, 0, 0, 17 },
	{ 255, 0, 0, 0 },
	{ 0, 17, 238, 0 },
	{ 0, 34, 221, 0 },
	{ 0, 51, 204, 0 },
	{ 0, 68, 187, 0 },
	{ 0, 85, 170, 0 },
	{ 0, 102, 153, 0 },
	{ 0, 119, 136, 0 },
	{ 0, 136, 119, 0 },
	{ 0, 153, 102, 0 },
	{ 0, 170, 85 ,0 },
	{ 0, 187, 68 ,0 },
	{ 0, 204, 51, 0 },
	{ 0, 221, 34, 0 },
	{ 0, 238, 17, 0 },
	{ 238, 17, 0, 0 },
	{ 221, 34, 0, 0 },
	{ 204, 51, 0, 0 },
	{ 187, 68, 0, 0 },
	{ 170, 85, 0, 0 },
	{ 153, 102, 0, 0 },
	{ 136, 119, 0, 0 },
	{ 119, 136, 0, 0 },
	{ 102, 153, 0, 0 },
	{ 85, 170, 0, 0 },
	{ 68, 187, 0, 0 },
	{ 51, 204, 0, 0 },
	{ 34, 221, 0, 0 },
	{ 17, 238, 0, 0 },
	{ 238, 0, 17, 0 },
	{ 221, 0, 34, 0 }, 
	{ 204, 0, 51, 0 },
	{ 187, 0, 68, 0 },
	{ 170, 0, 85, 0 },
	{ 153, 0, 102, 0 },
	{ 136, 0, 119, 0 },
	{ 119, 0, 136, 0 }, 
	{ 102, 0, 153, 0 }, 
	{ 85, 0, 170, 0 } ,
	{ 68, 0, 187, 0 },
	{ 51, 0, 204, 0 }, 
	{ 34, 0, 221, 0 }, 
	{ 17, 0, 238, 0 }, 
	{ 210, 23, 0, 22 }, 
	{ 179, 60, 0, 16 }, 
	{ 145, 94, 0, 16 }, 
	{ 119, 119, 0, 17 }, 
	{ 94, 145, 0, 16 }, 
	{ 60, 179, 0, 16 }, 
	{ 23, 210, 0, 22 }, 
	{ 176, 40, 0, 39 }, 
	{ 142, 74, 0, 39 }, 
	{ 113, 96, 0, 46 }, 
	{ 91, 125, 0, 39 }, 
	{ 62, 147, 0, 46 }, 
	{ 40, 176, 0, 39 }, 
	{ 179, 17, 0, 59 },
	{ 147, 45, 0, 63 },
	{ 17, 179, 0, 59 },
	{ 145, 17, 0, 93 },
	{ 125, 40, 0, 90 },
	{ 108, 74, 0, 73 },
	{ 74, 108, 0, 73 },
	{ 85, 85, 0, 85 },
	{ 40, 142, 0, 73 },
	{ 119, 17, 0, 119 },
	{ 96, 45, 0, 114 },
	{ 74, 74, 0, 107 },
	{ 45, 113, 0, 97 },
	{ 17, 145, 0, 93 },
	{ 94, 17, 0, 144 },
	{ 74, 40, 0, 141 },
	{ 45, 62, 0, 148 },
	{ 40, 91, 0, 124 },
	{ 17, 119, 0, 119 },
	{ 17, 94, 0, 144 }, 
	{ 60, 17, 0, 178 }, 
	{ 40, 40, 0, 175 }, 
	{ 17, 60, 0, 178 }, 
	{ 23, 23, 0, 209 }, 
	{ 0, 210, 23, 22 },
	{ 0, 179, 60, 16 },
	{ 0, 145, 94, 16 },
	{ 0, 119, 119, 17 },
	{ 0, 94 ,145, 16 },
	{ 0, 60 ,179, 16 },
	{ 0, 23, 210, 22 },
	{ 0, 176, 40, 39 },
	{ 0, 142, 74, 39 },
	{ 0, 113, 96, 46 },
	{ 0, 91, 125, 39 },
	{ 0, 62, 147, 46 },
	{ 0, 40, 176, 39 },
	{ 0, 179, 17, 59 },
	{ 0, 147, 45, 63 },
	{ 0, 17, 179, 59 },
	{ 0, 145, 17, 93 },
	{ 0, 125, 40, 90 },
	{ 0, 108, 74, 73 },
	{ 0, 74, 108, 73 },
	{ 0, 85, 85, 85 },
	{ 0, 40, 142, 73 }, 
	{ 0, 119, 17, 119 },
	{ 0, 96, 45, 114 },
	{ 0, 74, 74, 107 },
	{ 0, 45, 113, 97 },
	{ 0, 17, 145, 93 },
	{ 0, 94, 17, 144 },
	{ 0, 74, 40, 141 },
	{ 0, 45, 62, 148 },
	{ 0, 40, 91, 124 },
	{ 0, 17, 119, 119 },
	{ 0, 17, 94, 144 },
	{ 0, 60, 17, 178 },
	{ 0, 40, 40, 175 },
	{ 0, 17, 60, 178 },
	{ 0, 23, 23, 209 },
	{ 23, 0, 210, 22 },
	{ 60, 0, 179, 16 },
	{ 94, 0, 145, 16 },
	{ 119, 0, 119, 17 },
	{ 145, 0, 94, 16 },
	{ 179, 0, 60, 16 },
	{ 210, 0, 23, 22 },
	{ 40, 0, 176, 39 },
	{ 74, 0, 142, 39 },
	{ 96, 0, 113, 46 },
	{ 125, 0, 91, 39 },
	{ 147, 0, 62, 46 },
	{ 176, 0, 40, 39 },
	{ 17, 0, 179, 59 },
	{ 45, 0, 147, 63 },
	{ 179, 0, 17, 59 },
	{ 17, 0, 145, 93 },
	{ 40, 0, 125, 90 },
	{ 74, 0, 108, 73 },
	{ 108, 0, 74, 73 },
	{ 85, 0, 85, 85 },
	{ 142, 0, 40, 73 },
	{ 17, 0, 119, 119 },
	{ 45, 0, 96, 114 },
	{ 74, 0, 74, 107 },
	{ 113, 0, 45, 97 },
	{ 145, 0, 17, 93 },
	{ 17, 0, 94, 144 },
	{ 40, 0, 74, 141 },
	{ 62, 0, 45, 148 },
	{ 91, 0, 40, 124 },
	{ 119, 0, 17, 119 },
	{ 94, 0, 17, 144 },
	{ 17, 0, 60, 178 },
	{ 40, 0, 40, 175 },
	{ 60, 0, 17, 178 },
	{ 23, 0, 23, 209 },
	{ 209, 23, 23, 0 },
	{ 178, 17, 60, 0 },
	{ 144, 17, 94, 0 },
	{ 119, 17, 119, 0 },
	{ 93, 17, 145, 0 },
	{ 59, 17, 179, 0 },
	{ 22, 23, 210, 0 },
	{ 175, 40, 40, 0 },
	{ 141, 40, 74, 0 },
	{ 114, 45, 96, 0 },
	{ 90, 40, 125, 0 },
	{ 63, 45, 147, 0 },
	{ 39, 40, 176, 0 },
	{ 178, 60, 17, 0 },
	{ 148, 62, 45, 0 },
	{ 16, 60, 179, 0 },
	{ 144, 94, 17, 0 },
	{ 124, 91, 40, 0 },
	{ 107, 74, 74, 0 },
	{ 73, 74, 108, 0 },
	{ 85, 85, 85, 0 },
	{ 39, 74, 142, 0 }, 
	{ 119, 119, 17, 0 },
	{ 97, 113, 45, 0 },
	{ 73, 108, 74, 0 },
	{ 46, 96, 113, 0 },
	{ 16, 94, 145, 0 },
	{ 93, 145, 17, 0 },
	{ 73, 142, 40, 0 },
	{ 46, 147, 62, 0 },
	{ 39, 125, 91, 0 },
	{ 17, 119, 119, 0 },
	{ 16, 145, 94, 0 },
	{ 59, 179, 17, 0 },
	{ 39, 176, 40, 0 },
	{ 16, 179, 60, 0 },
	{ 22, 210, 23, 0 },
	{ 32, 32 ,32, 159 },
	{ 32, 32 ,74, 117 },
	{ 32, 32 ,116, 75 },
	{ 32, 32 ,158, 33 },
	{ 74, 32, 32, 117 },
	{ 74, 32, 74, 75 }, 
	{ 74, 32, 116, 33 },
	{ 116, 32, 32, 75 },
	{ 116, 32, 74, 33 },
	{ 158, 32, 32, 33 },
	{ 32, 74, 32, 117 },
	{ 32, 74, 74, 75 },
	{ 32, 74, 116, 33 },
	{ 74, 74, 32, 75 },
	{ 74, 74, 74, 33 },
	{ 116, 74, 32, 33 },
	{ 32, 116, 32, 75 },
	{ 32, 116, 74, 33 },
	{ 74, 116, 32, 33 },
	{ 32, 158, 32, 33 },
	};
