// Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include "lookuptable.h"

/**
@internalComponent
*/
// Lookup table low word for converting from 16bpp to 32bpp display modes
const TUint16 KBlt16to32Low[256] =
    {
    0x0000,
    0x0008,
    0x0010,
    0x0018,
    0x0021,
    0x0029,
    0x0031,
    0x0039,
    0x0042,
    0x004a,
    0x0052,
    0x005a,
    0x0063,
    0x006b,
    0x0073,
    0x007b,
    0x0084,
    0x008c,
    0x0094,
    0x009c,
    0x00a5,
    0x00ad,
    0x00b5,
    0x00bd,
    0x00c6,
    0x00ce,
    0x00d6,
    0x00de,
    0x00e7,
    0x00ef,
    0x00f7,
    0x00ff,
    0x0400,
    0x0408,
    0x0410,
    0x0418,
    0x0421,
    0x0429,
    0x0431,
    0x0439,
    0x0442,
    0x044a,
    0x0452,
    0x045a,
    0x0463,
    0x046b,
    0x0473,
    0x047b,
    0x0484,
    0x048c,
    0x0494,
    0x049c,
    0x04a5,
    0x04ad,
    0x04b5,
    0x04bd,
    0x04c6,
    0x04ce,
    0x04d6,
    0x04de,
    0x04e7,
    0x04ef,
    0x04f7,
    0x04ff,
    0x0800,
    0x0808,
    0x0810,
    0x0818,
    0x0821,
    0x0829,
    0x0831,
    0x0839,
    0x0842,
    0x084a,
    0x0852,
    0x085a,
    0x0863,
    0x086b,
    0x0873,
    0x087b,
    0x0884,
    0x088c,
    0x0894,
    0x089c,
    0x08a5,
    0x08ad,
    0x08b5,
    0x08bd,
    0x08c6,
    0x08ce,
    0x08d6,
    0x08de,
    0x08e7,
    0x08ef,
    0x08f7,
    0x08ff,
    0x0c00,
    0x0c08,
    0x0c10,
    0x0c18,
    0x0c21,
    0x0c29,
    0x0c31,
    0x0c39,
    0x0c42,
    0x0c4a,
    0x0c52,
    0x0c5a,
    0x0c63,
    0x0c6b,
    0x0c73,
    0x0c7b,
    0x0c84,
    0x0c8c,
    0x0c94,
    0x0c9c,
    0x0ca5,
    0x0cad,
    0x0cb5,
    0x0cbd,
    0x0cc6,
    0x0cce,
    0x0cd6,
    0x0cde,
    0x0ce7,
    0x0cef,
    0x0cf7,
    0x0cff,
    0x1000,
    0x1008,
    0x1010,
    0x1018,
    0x1021,
    0x1029,
    0x1031,
    0x1039,
    0x1042,
    0x104a,
    0x1052,
    0x105a,
    0x1063,
    0x106b,
    0x1073,
    0x107b,
    0x1084,
    0x108c,
    0x1094,
    0x109c,
    0x10a5,
    0x10ad,
    0x10b5,
    0x10bd,
    0x10c6,
    0x10ce,
    0x10d6,
    0x10de,
    0x10e7,
    0x10ef,
    0x10f7,
    0x10ff,
    0x1400,
    0x1408,
    0x1410,
    0x1418,
    0x1421,
    0x1429,
    0x1431,
    0x1439,
    0x1442,
    0x144a,
    0x1452,
    0x145a,
    0x1463,
    0x146b,
    0x1473,
    0x147b,
    0x1484,
    0x148c,
    0x1494,
    0x149c,
    0x14a5,
    0x14ad,
    0x14b5,
    0x14bd,
    0x14c6,
    0x14ce,
    0x14d6,
    0x14de,
    0x14e7,
    0x14ef,
    0x14f7,
    0x14ff,
    0x1800,
    0x1808,
    0x1810,
    0x1818,
    0x1821,
    0x1829,
    0x1831,
    0x1839,
    0x1842,
    0x184a,
    0x1852,
    0x185a,
    0x1863,
    0x186b,
    0x1873,
    0x187b,
    0x1884,
    0x188c,
    0x1894,
    0x189c,
    0x18a5,
    0x18ad,
    0x18b5,
    0x18bd,
    0x18c6,
    0x18ce,
    0x18d6,
    0x18de,
    0x18e7,
    0x18ef,
    0x18f7,
    0x18ff,
    0x1c00,
    0x1c08,
    0x1c10,
    0x1c18,
    0x1c21,
    0x1c29,
    0x1c31,
    0x1c39,
    0x1c42,
    0x1c4a,
    0x1c52,
    0x1c5a,
    0x1c63,
    0x1c6b,
    0x1c73,
    0x1c7b,
    0x1c84,
    0x1c8c,
    0x1c94,
    0x1c9c,
    0x1ca5,
    0x1cad,
    0x1cb5,
    0x1cbd,
    0x1cc6,
    0x1cce,
    0x1cd6,
    0x1cde,
    0x1ce7,
    0x1cef,
    0x1cf7,
    0x1cff
    };

/**
@internalComponent
*/
// Lookup table high long word for converting from 16bpp to 32bpp display modes
const TUint32 KBlt16to32High[256] =
    {
    0xff000000,
    0xff002000,
    0xff004100,
    0xff006100,
    0xff008200,
    0xff00a200,
    0xff00c300,
    0xff00e300,
    0xff080000,
    0xff082000,
    0xff084100,
    0xff086100,
    0xff088200,
    0xff08a200,
    0xff08c300,
    0xff08e300,
    0xff100000,
    0xff102000,
    0xff104100,
    0xff106100,
    0xff108200,
    0xff10a200,
    0xff10c300,
    0xff10e300,
    0xff180000,
    0xff182000,
    0xff184100,
    0xff186100,
    0xff188200,
    0xff18a200,
    0xff18c300,
    0xff18e300,
    0xff210000,
    0xff212000,
    0xff214100,
    0xff216100,
    0xff218200,
    0xff21a200,
    0xff21c300,
    0xff21e300,
    0xff290000,
    0xff292000,
    0xff294100,
    0xff296100,
    0xff298200,
    0xff29a200,
    0xff29c300,
    0xff29e300,
    0xff310000,
    0xff312000,
    0xff314100,
    0xff316100,
    0xff318200,
    0xff31a200,
    0xff31c300,
    0xff31e300,
    0xff390000,
    0xff392000,
    0xff394100,
    0xff396100,
    0xff398200,
    0xff39a200,
    0xff39c300,
    0xff39e300,
    0xff420000,
    0xff422000,
    0xff424100,
    0xff426100,
    0xff428200,
    0xff42a200,
    0xff42c300,
    0xff42e300,
    0xff4a0000,
    0xff4a2000,
    0xff4a4100,
    0xff4a6100,
    0xff4a8200,
    0xff4aa200,
    0xff4ac300,
    0xff4ae300,
    0xff520000,
    0xff522000,
    0xff524100,
    0xff526100,
    0xff528200,
    0xff52a200,
    0xff52c300,
    0xff52e300,
    0xff5a0000,
    0xff5a2000,
    0xff5a4100,
    0xff5a6100,
    0xff5a8200,
    0xff5aa200,
    0xff5ac300,
    0xff5ae300,
    0xff630000,
    0xff632000,
    0xff634100,
    0xff636100,
    0xff638200,
    0xff63a200,
    0xff63c300,
    0xff63e300,
    0xff6b0000,
    0xff6b2000,
    0xff6b4100,
    0xff6b6100,
    0xff6b8200,
    0xff6ba200,
    0xff6bc300,
    0xff6be300,
    0xff730000,
    0xff732000,
    0xff734100,
    0xff736100,
    0xff738200,
    0xff73a200,
    0xff73c300,
    0xff73e300,
    0xff7b0000,
    0xff7b2000,
    0xff7b4100,
    0xff7b6100,
    0xff7b8200,
    0xff7ba200,
    0xff7bc300,
    0xff7be300,
    0xff840000,
    0xff842000,
    0xff844100,
    0xff846100,
    0xff848200,
    0xff84a200,
    0xff84c300,
    0xff84e300,
    0xff8c0000,
    0xff8c2000,
    0xff8c4100,
    0xff8c6100,
    0xff8c8200,
    0xff8ca200,
    0xff8cc300,
    0xff8ce300,
    0xff940000,
    0xff942000,
    0xff944100,
    0xff946100,
    0xff948200,
    0xff94a200,
    0xff94c300,
    0xff94e300,
    0xff9c0000,
    0xff9c2000,
    0xff9c4100,
    0xff9c6100,
    0xff9c8200,
    0xff9ca200,
    0xff9cc300,
    0xff9ce300,
    0xffa50000,
    0xffa52000,
    0xffa54100,
    0xffa56100,
    0xffa58200,
    0xffa5a200,
    0xffa5c300,
    0xffa5e300,
    0xffad0000,
    0xffad2000,
    0xffad4100,
    0xffad6100,
    0xffad8200,
    0xffada200,
    0xffadc300,
    0xffade300,
    0xffb50000,
    0xffb52000,
    0xffb54100,
    0xffb56100,
    0xffb58200,
    0xffb5a200,
    0xffb5c300,
    0xffb5e300,
    0xffbd0000,
    0xffbd2000,
    0xffbd4100,
    0xffbd6100,
    0xffbd8200,
    0xffbda200,
    0xffbdc300,
    0xffbde300,
    0xffc60000,
    0xffc62000,
    0xffc64100,
    0xffc66100,
    0xffc68200,
    0xffc6a200,
    0xffc6c300,
    0xffc6e300,
    0xffce0000,
    0xffce2000,
    0xffce4100,
    0xffce6100,
    0xffce8200,
    0xffcea200,
    0xffcec300,
    0xffcee300,
    0xffd60000,
    0xffd62000,
    0xffd64100,
    0xffd66100,
    0xffd68200,
    0xffd6a200,
    0xffd6c300,
    0xffd6e300,
    0xffde0000,
    0xffde2000,
    0xffde4100,
    0xffde6100,
    0xffde8200,
    0xffdea200,
    0xffdec300,
    0xffdee300,
    0xffe70000,
    0xffe72000,
    0xffe74100,
    0xffe76100,
    0xffe78200,
    0xffe7a200,
    0xffe7c300,
    0xffe7e300,
    0xffef0000,
    0xffef2000,
    0xffef4100,
    0xffef6100,
    0xffef8200,
    0xffefa200,
    0xffefc300,
    0xffefe300,
    0xfff70000,
    0xfff72000,
    0xfff74100,
    0xfff76100,
    0xfff78200,
    0xfff7a200,
    0xfff7c300,
    0xfff7e300,
    0xffff0000,
    0xffff2000,
    0xffff4100,
    0xffff6100,
    0xffff8200,
    0xffffa200,
    0xffffc300,
    0xffffe300
    };
    
    
const TUint16 NormalisationTable16Bit[256] = {
	0,65280,32640,21760,16320,13056,10880,9326,8160,7254,6528,
	5935,5440,5022,4663,4352,4080,3840,3627,3436,3264,
	3109,2968,2839,2720,2612,2511,2418,2332,2252,2176,
	2106,2040,1979,1920,1866,1814,1765,1718,1674,1632,
	1593,1555,1519,1484,1451,1420,1389,1360,1333,1306,
	1280,1256,1232,1209,1187,1166,1146,1126,1107,1088,
	1071,1053,1037,1020,1005,990,975,960,947,933,
	920,907,895,883,871,859,848,837,827,816,
	806,797,787,778,768,760,751,742,734,726,
	718,710,702,695,688,680,673,667,660,653,
	647,640,634,628,622,616,611,605,599,594,
	589,583,578,573,568,563,558,554,549,544,
	540,536,531,527,523,519,515,510,507,503,
	499,495,491,488,484,480,477,474,470,467,
	463,460,457,454,451,448,445,442,439,436,
	433,430,427,424,422,419,416,414,411,408,
	406,403,401,399,396,394,391,389,387,384,
	382,380,378,376,374,371,369,367,365,363,
	361,359,357,355,353,351,350,348,346,344,
	342,340,339,337,335,334,332,330,329,327,
	325,324,322,320,319,317,316,314,313,311,
	310,308,307,306,304,303,301,300,299,297,
	296,295,293,292,291,289,288,287,286,284,
	283,282,281,279,278,277,276,275,274,272,
	271,270,269,268,267,266,265,264,263,262,
	261,260,259,258,256,
};


/**
This function will return value of converted 16bpp to 32bpp display modes. This lookup table is 
used to improve performance.
@internalComponent
*/

 EXPORT_C const TUint16* Convert16to32bppLow()
 	{
 	return KBlt16to32Low;
 	}
 
 EXPORT_C const TUint32* Convert16to32bppHigh()
 	{
 	return KBlt16to32High;
 	}

/**
Returns the pointer to the table of 16-bit normalisation table.
The table is currently used for performing un-multiplying Premultiplied Alpha color channels.
This lookup table for normalised alpha is compluted using this equation: Table[index] = (255*256) / index (where index is an 8 bit value)
Use: Let x be c * a/255, and y = c, then y = (x/a)*255, where a is in 0-255 range.
		To use this table, use y = (x * Table[a])>>8. i.e, the inaccurate division is converted 
		to more accurate multiplication and shift.
		
@return pointer to the normalisation table.
@internalTechnology
*/
EXPORT_C const TUint16* PtrTo16BitNormalisationTable()
	{
	return &NormalisationTable16Bit[0];
	}

