// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


/**
 @file
 @publishedPartner
 @prototype
*/


#ifndef __EGLWINDOWCOMMON_H__
#define __EGLWINDOWCOMMON_H__


#include <e32std.h>
#include <graphics/surfaceconfiguration.h>
#include <graphics/suerror.h>


/**
EGL Window panic codes, panic function and assert macro.
*/
enum TEglWindowPanicCode
    {
    EEglWindowPanicInvalidSurface = 0,
    EEglWindowPanicInvalidScreenNumber = 1,
    EEglWindowPanicSizeInPixelsIsNegative = 2,
    EEglWindowPanicSizeInTwipsIsNegative = 3,
    EEglWindowPanicREglStandAloneWindowNotCreated = 4,
    EEglWindowPanicRWindowHasNoSession = 5,
    };


static inline void EglWindowPanic(TEglWindowPanicCode aPanicCode)
    {
    _LIT(KPanicCategory, "EglWindow");
    User::Panic(KPanicCategory, aPanicCode);
    }


#define EGL_WINDOW_ASSERT_DEBUG(aAssert, aPanicCode) __ASSERT_DEBUG(aAssert, EglWindowPanic(aPanicCode))
#define EGL_WINDOW_ASSERT_ALWAYS(aAssert, aPanicCode) __ASSERT_ALWAYS(aAssert, EglWindowPanic(aPanicCode))


#endif
