/*****************************************************************************/
/*                                                                           */
/* COMPONENT   : eXtended Sector Remapper                                    */
/* MODULE      : OS Adaptation Module                                        */
/* FILE        : OAM.h                                                       */
/* PURPOSE     : This file contains the definition and protypes of exported  */
/*              functions for OS Adaptation Module.                          */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005, SAMSUNG ELECTRONICS CO., LTD.               */
/*                          ALL RIGHTS RESERVED                              */
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing NAND/OneNAND based on Samsung              */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representations or warranties    */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */ 
/*                                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/* REVISION HISTORY                                                          */
/*                                                                           */
/*   24-JUL-2003 [SongHo Yoon]  : first writing                              */
/*   28-JUL-2003 [SongHo Yoon]  : added OAM_Memcmp()                         */
/*   13-AUG-2003 [SongHo Yoon]  : added NULL definition                      */
/*   03-SEP-2003 [HyoJun Kim]   : added OAM_ResetTimer()                     */
/*                                added OAM_GetTime()                        */
/*   17-DEC-2003 [SongHo Yoon]  : reorganization                             */
/*   17-DEC-2003 [SongHo Yoon]  : added OAM_WaitNMSec()                      */
/*   27-JAN-2004 [SongHo Yoon]  : added OAM_RTLMSG_DISABLE                   */
/*                                removed OAM_RTLMSG_ENABLE                  */
/*   12-FEB-2004 [SongHo Yoon]  : changed TEXT macro                         */
/*                                #define   TEXT(x)  (VOID *) (x)            */
/*   22-OCT-2004 [Jihyun In]    : Interrupt related functions are modified   */
/*	 15-DEC-2005 [Byoung Young Ahn]	: added OAM_Idle(), OAM_GetROLockFlag()	 */
/*                                                                           */
/*****************************************************************************/

/*****************************************************************************/
/* Note                                                                      */
/*                                                                           */
/*
* Copyright (c) 1996-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
* File modified as follows:												 
* Just configure for EKA2                                                   
* Addition of support for use of timeout while waiting on interrupt         
* Emulator support (marked (SYMOS_OAM_EMUL)								 
* 
*
*/



#ifndef _XSR_OAM_H_
#define	_XSR_OAM_H_

/*****************************************************************************/
/* OS Selection                                                              */
/* DO NOT DEFINE WINCE_OAM or SYMOS_OAM or in This Header File               */
/*   WINCE_OAM  : the definition for WindowsCE                               */
/*   SYMOS_OAM  : the definition for SymbianOS                               */
/*                                                                           */
/*****************************************************************************/

#if defined(WINCE_OAM)

	#include <windows.h>

	#define	XSR_RTL_PRINT(x)		RETAILMSG(1, x)

	#if defined(OAM_DBGMSG_ENABLE)
	#define	XSR_DBG_PRINT(x)		RETAILMSG(1, x)
	#endif /* OAM_DBGMSG_ENABLE */

#elif defined(SYMOS_OAM) || defined(SYMOS_OAM_EMUL)

	#include <locmedia.h>
	#include <platform.h>

#if defined(OAM_DBGMSG_ENABLE)
		#define	XSR_RTL_PRINT(x)		Kern::Printf x
#else
		#define	XSR_RTL_PRINT(x)
#endif

#if defined(OAM_DBGMSG_ENABLE)
  		#define	XSR_DBG_PRINT(x)		Kern::Printf x
#else
  		#define	XSR_DBG_PRINT(x)
#endif


#if defined(SYMOS_OAM_EMUL) 
	#define TEXT(x)					((char *)x) // redefine WINS version of macro
#else
   	#define	TEXT(x)					(x)
#endif

	#define __NAND_ASSERT(aCond) \
					__ASSERT_DEBUG( (aCond), ( \
						Kern::Printf("Assertion '" #aCond "' failed;\nFile: '" \
						__FILE__ "' Line: %d\n", __LINE__), \
						Kern::Fault("NAND", 0)) )

#else /* other case */

	#if defined(OAM_RTLMSG_DISABLE)
	#define	XSR_RTL_PRINT(x)
	#else
	#define	XSR_RTL_PRINT(x)		OAM_Debug x
	#endif /* OAM_RTLMSG_DISABLE */

	#if defined(OAM_DBGMSG_ENABLE)
	#define	XSR_DBG_PRINT(x)		OAM_Debug x
	#else
	#define	XSR_DBG_PRINT(x)
	#endif /* OAM_DBGMSG_ENABLE */

	#undef	TEXT
	#define	TEXT(x)					(VOID *) (x)

#endif

/*****************************************************************************/
/* NULL #defines                                                             */
/*   If Each OAM header file defines NULL, following define is not used.     */
/*****************************************************************************/
#ifndef		NULL
#ifdef		__cplusplus
#define		NULL				0
#else
#define		NULL				((void *)0)
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*****************************************************************************/
/* exported function prototype of OAM                                        */
/*****************************************************************************/
#ifdef ASYNC_MODE
VOID	 OAM_InitInt   (UINT32 nLogIntId);
VOID	 OAM_BindInt   (UINT32 nLogIntId, UINT32 nPhyIntId); 
VOID	 OAM_EnableInt (UINT32 nLogIntId, UINT32 nPhyIntId); 
VOID	 OAM_DisableInt(UINT32 nLogIntId, UINT32 nPhyIntId); 
VOID	 OAM_ClearInt  (UINT32 nLogIntId, UINT32 nPhyIntId);
#endif

VOID    *OAM_Malloc    (UINT32 nSize);
VOID     OAM_Free      (VOID  *pMem);
VOID     OAM_Memcpy    (VOID  *pDst, VOID  *pSrc,   UINT32 nLen);
VOID     OAM_Memset    (VOID  *pDst, UINT8  nData,  UINT32 nLen);
INT32    OAM_Memcmp    (VOID  *pCmp1,VOID  *pCmp2,  UINT32 nLen);

BOOL32   OAM_CreateSM  (SM32  *pHandle);
BOOL32   OAM_DestroySM (SM32   nHandle);
BOOL32   OAM_AcquireSM (SM32   nHandle);
BOOL32   OAM_ReleaseSM (SM32   nHandle);
UINT32   OAM_Pa2Va     (UINT32 nPAddr);
UINT32   OAM_Pa2VaS    (UINT32 nPAddr, UINT32 nSize);

VOID     OAM_Debug     (VOID *pStr, ...);

VOID 	 OAM_ResetTimer(VOID);
UINT32   OAM_GetTime   (VOID);
VOID     OAM_WaitNMSec (UINT32 nNMSec);

VOID	OAM_AsyncTimeout(INT32 /*aVol*/, UINT32 aMsTimeout, UINT8 aCmd);

BOOL32 	 OAM_GetROLockFlag	(VOID);
VOID	 OAM_Idle	   		(VOID);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* _XSR_OAM_H_ */
