/*
* Copyright (c) 1994-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* CP850 Western European Alphabetic Conversions etc (excludes Scandinavia).
*
*/


#include "ls_std.h"

// The character type conversion table
const TUint8 LAlphabet::TypeTable[KMaxTranslateTable] =
	{
	(__C),      // 0x00 - NUL
	(__C),      // 0x01 - SOH
	(__C),      // 0x02 - STX
	(__C),      // 0x03 - ETX
	(__C),      // 0x04 - EOT
	(__C),      // 0x05 - ENQ
	(__C),      // 0x06 - ACK
	(__C),      // 0x07 - BEL
	(__C),      // 0x08 - BS 
	(__C|__S),  // 0x09 - HT 
	(__C|__S),  // 0x0a - NL 
	(__C|__S),  // 0x0b - VT 
	(__C|__S),  // 0x0c - FF 
	(__C|__S),  // 0x0d - CR 
	(__C),      // 0x0e - SO 
	(__C),      // 0x0f - SI 
	(__C),      // 0x10 - DLE
	(__C),      // 0x11 - DC1
	(__C),      // 0x12 - DC2
	(__C),      // 0x13 - DC3
	(__C),      // 0x14 - DC4
	(__C),      // 0x15 - NAK
	(__C),      // 0x16 - SYN
	(__C),      // 0x17 - ETB
	(__C),      // 0x18 - CAN
	(__C),      // 0x19 - EM 
	(__C),      // 0x1a - SUB
	(__C),      // 0x1b - ESC
	(__C),      // 0x1c - FS 
	(__C),      // 0x1d - GS 
	(__C),      // 0x1e - RS 
	(__C),      // 0x1f - US 
	(__S|__B),  // 0x20 - ' '
	(__P),      // 0x21 - '!'
	(__P),      // 0x22 - '"'
	(__P),      // 0x23 - '#'
	(__P),      // 0x24 - '$'
	(__P),      // 0x25 - '%'
	(__P),      // 0x26 - '&'
	(__P),      // 0x27 - '''
	(__P),      // 0x28 - '('
	(__P),      // 0x29 - ')'
	(__P),      // 0x2a - '*'
	(__P),      // 0x2b - '+'
	(__P),      // 0x2c - ','
	(__P),      // 0x2d - '-'
	(__P),      // 0x2e - '.'
	(__P),      // 0x2f - '/'
	(__D|__X),  // 0x30 - '0'
	(__D|__X),  // 0x31 - '1'
	(__D|__X),  // 0x32 - '2'
	(__D|__X),  // 0x33 - '3'
	(__D|__X),  // 0x34 - '4'
	(__D|__X),  // 0x35 - '5'
	(__D|__X),  // 0x36 - '6'
	(__D|__X),  // 0x37 - '7'
	(__D|__X),  // 0x38 - '8'
	(__D|__X),  // 0x39 - '9'
	(__P),      // 0x3a - ':'
	(__P),      // 0x3b - ';'
	(__P),      // 0x3c - '<'
	(__P),      // 0x3d - '='
	(__P),      // 0x3e - '>'
	(__P),      // 0x3f - '?'
	(__P),      // 0x40 - '@'
	(__U|__X),  // 0x41 - 'A'
	(__U|__X),  // 0x42 - 'B'
	(__U|__X),  // 0x43 - 'C'
	(__U|__X),  // 0x44 - 'D'
	(__U|__X),  // 0x45 - 'E'
	(__U|__X),  // 0x46 - 'F'
	(__U),      // 0x47 - 'G'
	(__U),      // 0x48 - 'H'
	(__U),      // 0x49 - 'I'
	(__U),      // 0x4a - 'J'
	(__U),      // 0x4b - 'K'
	(__U),      // 0x4c - 'L'
	(__U),      // 0x4d - 'M'
	(__U),      // 0x4e - 'N'
	(__U),      // 0x4f - 'O'
	(__U),      // 0x50 - 'P'
	(__U),      // 0x51 - 'Q'
	(__U),      // 0x52 - 'R'
	(__U),      // 0x53 - 'S'
	(__U),      // 0x54 - 'T'
	(__U),      // 0x55 - 'U'
	(__U),      // 0x56 - 'V'
	(__U),      // 0x57 - 'W'
	(__U),      // 0x58 - 'X'
	(__U),      // 0x59 - 'Y'
	(__U),      // 0x5a - 'Z'
	(__P),      // 0x5b - '['
	(__P),      // 0x5c - '\'
	(__P),      // 0x5d - ']'
	(__P),      // 0x5e - '^'
	(__P),      // 0x5f - '_'
	(__P),      // 0x60 - '`'
	(__L|__X),  // 0x61 - 'a'
	(__L|__X),  // 0x62 - 'b'
	(__L|__X),  // 0x63 - 'c'
	(__L|__X),  // 0x64 - 'd'
	(__L|__X),  // 0x65 - 'e'
	(__L|__X),  // 0x66 - 'f'
	(__L),      // 0x67 - 'g'
	(__L),      // 0x68 - 'h'
	(__L),      // 0x69 - 'i'
	(__L),      // 0x6a - 'j'
	(__L),      // 0x6b - 'k'
	(__L),      // 0x6c - 'l'
	(__L),      // 0x6d - 'm'
	(__L),      // 0x6e - 'n'
	(__L),      // 0x6f - 'o'
	(__L),      // 0x70 - 'p'
	(__L),      // 0x71 - 'q'
	(__L),      // 0x72 - 'r'
	(__L),      // 0x73 - 's'
	(__L),      // 0x74 - 't'
	(__L),      // 0x75 - 'u'
	(__L),      // 0x76 - 'v'
	(__L),      // 0x77 - 'w'
	(__L),      // 0x78 - 'x'
	(__L),      // 0x79 - 'y'
	(__L),      // 0x7a - 'z'
	(__P),      // 0x7b - '{'
	(__P),      // 0x7c - '|'
	(__P),      // 0x7d - '}'
	(__P),      // 0x7e - '~'
	(__C),      // 0x7f - DEL
	(__U),      // 0x80 - C cedilla
    (__L),      // 0x81 - u umlaut
	(__L),      // 0x82 - e acute
	(__L),      // 0x83 - a circumflex
	(__L),      // 0x84 - a umlaut
	(__L),      // 0x85 - a grave
	(__L),      // 0x86 - a ring
	(__L),      // 0x87 - c cedilla
	(__L),      // 0x88 - e circumflex
	(__L),      // 0x89 - e umlaut
	(__L),      // 0x8a - e grave
	(__L),      // 0x8b - i umlaut
	(__L),      // 0x8c - i circumflex
	(__L),      // 0x8d - i grave
	(__U),      // 0x8e - A umlaut
	(__U),      // 0x8f - A ring
	(__U),      // 0x90 - E acute
	(__L),      // 0x91 - ae
	(__U),      // 0x92 - AE
	(__L),      // 0x93 - o circumflex
	(__L),      // 0x94 - o umlaut
	(__L),      // 0x95 - o grave
	(__L),      // 0x96 - u circumflex
	(__L),      // 0x97 - u grave
	(__L),      // 0x98 - y umlaut
	(__U),      // 0x99 - O umlaut
	(__U),      // 0x9a - U umlaut
	(__L),      // 0x9b - o slash
	(__P),      // 0x9c - sterling
	(__U),      // 0x9d - O slash
	(__P),      // 0x9e - multiply
	(__P),      // 0x9f - florin
	(__L),      // 0xa0 - a acute
	(__L),      // 0xa1 - i acute
	(__L),      // 0xa2 - o acute
	(__L),      // 0xa3 - u acute
	(__L),      // 0xa4 - n tilde
	(__U),      // 0xa5 - N tilde
	(__P),      // 0xa6 - ordfeminine
	(__P),      // 0xa7 - ordmasculine
	(__P),      // 0xa8 - inverted ?
	(__P),      // 0xa9 - registered
	(__P),      // 0xaa - logical not
	(__P),      // 0xab - 1/2
	(__P),      // 0xac - 1/4
	(__P),      // 0xad - inverted !
	(__P),      // 0xae - guillemotleft
	(__P),      // 0xaf - guillemotright
	(0),        // 0xb0 - 1/4 grey
	(0),        // 0xb1 - 1/2 grey
	(0),        // 0xb2 - 3/4 grey
	(0),        // 0xb3 - vertical line
	(0),        // 0xb4 - -|
	(__U),      // 0xb5 - A acute
	(__U),      // 0xb6 - A circumflex
	(__U),      // 0xb7 - A grave
	(__P),      // 0xb8 - copyright
	(0),        // 0xb9 - -| double
	(0),        // 0xba - | double
	(0),        // 0xbb - top right double
	(0),        // 0xbc - bottom right double
	(__P),      // 0xbd - cent
	(__P),      // 0xbe - Yen
	(0),        // 0xbf - top right
	(0),        // 0xc0 - bottom left
	(0),        // 0xc1 - bottom middle
	(0),        // 0xc2 - top middle
	(0),        // 0xc3 - left middle
	(0),        // 0xc4 - --
	(0),        // 0xc5 - middle
	(__L),      // 0xc6 - a tilde
	(__U),      // 0xc7 - A tilde
	(0),        // 0xc8 - bottom left double
	(0),        // 0xc9 - top left double
	(0),        // 0xca - bottom middle double
	(0),        // 0xcb - top middle double
	(0),        // 0xcc - left middle double
	(0),        // 0xcd - ==
	(0),        // 0xce - middle double
	(__P),      // 0xcf - currency
	(__L),      // 0xd0 - eth
	(__U),      // 0xd1 - Eth
	(__U),      // 0xd2 - E circumflex
	(__U),      // 0xd3 - E dieresis
	(__U),      // 0xd4 - E grave
	(__L),      // 0xd5 - dotlessi
	(__U),      // 0xd6 - I acute
	(__U),      // 0xd7 - I circumflex
	(__U),      // 0xd8 - I umlaut
	(0),        // 0xd9 - bottom right
	(0),        // 0xda - top left
	(0),        // 0xdb - black square
	(0),        // 0xdc - lower half of black square
	(__P),      // 0xdd - brokenbar
	(__U),      // 0xde - I grave
	(0),        // 0xdf - upper half of black square
	(__U),      // 0xe0 - O acute
	(__L),      // 0xe1 - germandbls
	(__U),      // 0xe2 - O circumflex
	(__U),      // 0xe3 - O grave
	(__L),      // 0xe4 - o tilde
	(__U),      // 0xe5 - O tilde
	(__L),      // 0xe6 - mu
	(__L),      // 0xe7 - thorn
	(__U),      // 0xe8 - Thorn
	(__U),      // 0xe9 - U acute
	(__U),      // 0xea - U circumflex
	(__U),      // 0xeb - U grave
	(__L),      // 0xec - y acute
	(__U),      // 0xed - Y acute
	(__P),      // 0xee - macron (overscore)
	(__P),      // 0xef - acute
	(__P),      // 0xf0 - minus
	(__P),      // 0xf1 - plusminus
	(__P),      // 0xf2 - double underscore
	(__P),      // 0xf3 - 3/4
	(__P),      // 0xf4 - paragraph
	(__P),      // 0xf5 - section
	(__P),      // 0xf6 - divide
	(__P),      // 0xf7 - cedilla
	(__P),      // 0xf8 - degree
	(__P),      // 0xf9 - dieresis
	(__P),      // 0xfa - decimal point
	(__P),      // 0xfb - superscript 1
	(__P),      // 0xfc - superscript 2
	(__P),      // 0xfd - superscript 3
	(__P),      // 0xfe - bullet
	(__S|__B)   // 0xff - another space
	};

// The uppercase table
const TText LAlphabet::UpperTable[KMaxTranslateTable] =
	{
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07, // 0x00
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17, // 0x10
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27, // 0x20
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, // 0x30
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47, // 0x40
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57, // 0x50
	0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47, // 0x60
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57, // 0x70
	0x58,0x59,0x5a,0x7b,0x7c,0x7d,0x7e,0x7f,
	0x80,0x9a,0x90,0xb6,0x8e,0xb7,0x8f,0x80, // 0x80
	0xd2,0xd3,0xd4,0xd8,0xd7,0xde,0x8e,0x8f,
	0x90,0x92,0x92,0xe2,0x99,0xe3,0xea,0xeb, // 0x90
	0x59,0x99,0x9a,0x9d,0x9c,0x9d,0x9e,0x9f,
	0xb5,0xd6,0xe0,0xe9,0xa5,0xa5,0xa6,0xa7, // 0xa0 
	0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
	0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7, // 0xb0
	0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc7,0xc7, // 0xc0
	0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
	0xd1,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7, // 0xd0
	0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
	0xe0,0xe1,0xe2,0xe3,0xe5,0xe5,0xe6,0xe8, // 0xe0
	0xe8,0xe9,0xea,0xeb,0xed,0xed,0xee,0xef,
	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7, // 0xf0
	0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff
	};

// The lowercase table
const TText LAlphabet::LowerTable[KMaxTranslateTable] =
	{
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07, // 0x00
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17, // 0x10
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27, // 0x20
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, // 0x30
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67, // 0x40
	0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77, // 0x50
	0x78,0x79,0x7a,0x5b,0x5c,0x5d,0x5e,0x5f,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67, // 0x60
	0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77, // 0x70
	0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
	0x87,0x81,0x82,0x83,0x84,0x85,0x86,0x87, // 0x80
	0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x84,0x86,
	0x82,0x91,0x91,0x93,0x94,0x95,0x96,0x97, // 0x90
	0x98,0x94,0x81,0x9b,0x9c,0x9b,0x9e,0x9f,
	0xa0,0xa1,0xa2,0xa3,0xa4,0xa4,0xa6,0xa7, // 0xa0
	0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
	0xb0,0xb1,0xb2,0xb3,0xb4,0xa0,0x83,0x85, // 0xb0
	0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc6, // 0xc0
	0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
	0xd0,0xd0,0x88,0x89,0x8a,0xd5,0xa1,0x8c, // 0xd0
	0x8b,0xd9,0xda,0xdb,0xdc,0xdd,0x8d,0xdf,
	0xa2,0xe1,0x93,0x95,0xe4,0xe4,0xe6,0xe7, // 0xe0
	0xe7,0xa3,0x96,0x97,0xec,0xec,0xee,0xef,
	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7, // 0xf0
	0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff
	};

// The fold table
const TText LAlphabet::FoldTable[KMaxTranslateTable] =
	{
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07, // 0x00
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17, // 0x10
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27, // 0x20
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, // 0x30
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47, // 0x40
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57, // 0x50
	0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,	
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47, // 0x60
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57, // 0x70
	0x58,0x59,0x5a,0x7b,0x7c,0x7d,0x7e,0x7f,
	0x43,0x55,0x45,0x41,0x41,0x41,0x8f,0x43, // 0x80
	0x45,0x45,0x45,0x49,0x49,0x49,0x41,0x8f,
	0x45,0x92,0x92,0x4f,0x4f,0x4f,0x55,0x55, // 0x90
	0x59,0x4f,0x55,0x9d,0x9c,0x9d,0x9e,0x9f,
	0x41,0x49,0x4f,0x55,0x4e,0x4e,0xa6,0xa7, // 0xa0
	0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
	0xb0,0xb1,0xb2,0xb3,0xb4,0x41,0x41,0x41, // 0xb0
	0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0x41,0x41, // 0xc0
	0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
	0xd1,0xd1,0x45,0x45,0x45,0xd5,0x49,0x49, // 0xd0
	0x49,0xd9,0xda,0xdb,0xdc,0xdd,0x49,0xdf,			
	0x4f,0xe1,0x4f,0x4f,0x4f,0x4f,0xe6,0xe8, // 0xe0
	0xe8,0x55,0x55,0x55,0x59,0x59,0xee,0xef,
	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7, // 0xf0
	0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff
    };

// The collate table
const TText LAlphabet::CollTable[KMaxTranslateTable] =
	{
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07, // 0x00
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17, // 0x10
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27, // 0x20
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, // 0x30
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47, // 0x40
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57, // 0x50 
	0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f, 
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47, // 0x60
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57, // 0x70
	0x58,0x59,0x5a,0x7b,0x7c,0x7d,0x7e,0x7f,
	0x43,0x55,0x45,0x41,0x41,0x41,0x8f,0x43, // 0x80
	0x45,0x45,0x45,0x49,0x49,0x49,0x41,0x8f,
	0x45,0x92,0x92,0x4f,0x4f,0x4f,0x55,0x55, // 0x90
	0x59,0x4f,0x55,0x9d,0x9c,0x9d,0x9e,0x9f,
	0x41,0x49,0x4f,0x55,0x4e,0x4e,0xa6,0xa7, // 0xa0
	0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
	0xb0,0xb1,0xb2,0xb3,0xb4,0x41,0x41,0x41, // 0xb0
	0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0x41,0x41, // 0xc0
	0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
	0xd1,0xd1,0x45,0x45,0x45,0xd5,0x49,0x49, // 0xd0
	0x49,0xd9,0xda,0xdb,0xdc,0xdd,0x49,0xdf, 		
	0x4f,0xe1,0x4f,0x4f,0x4f,0x4f,0xe6,0xe8, // 0xe0
	0xe8,0x55,0x55,0x55,0x59,0x59,0xee,0xef,
	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7, // 0xf0
	0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff
	};
