; Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
; All rights reserved.
; This component and the accompanying materials are made available
; under the terms of the License "Symbian Foundation License v1.0"
; which accompanies this distribution, and is available
; at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
;
; Initial Contributors:
; Nokia Corporation - initial contribution.
;
; Contributors:
;
; Description:
; e32utils\nandboot\coreldr\coreldrmmu.s
; File converted to GNU as format by armasm2as PERL script 
;

	INCLUDE config.inc
	INCLUDE armcpudefs.inc
	IMPORT	loadmain

	IMPORT	GetRomTargetAddress
	IMPORT	GetPageTableBaseAddress
	IMPORT	GetMemoryBankArrayBase
	IMPORT	GetNumberOfMemoryBankAddresses

	IMPORT	clearRestartTimer



	IF :DEF: RUNS_WITH_SMP
		IMPORT  RestartAuxiliaryCores
	ENDIF

	IF WRITE_TIMINGS
		IMPORT	getTime
		IMPORT	getFreq
	ENDIF

	IF WRITE_TIMINGS :LOR: DUMP_PAGE_TABLES
		IMPORT	WriteW
		IMPORT	WriteCrLf
	ENDIF

	EXPORT	SetNANDReadTime

	EXPORT 	bootos
	EXPORT	setupMMU
; define linker area for placement of .text section (LINKBASE)
; also use PRESERVE8 to indicate (to linker) stack 8B alignment 

	PRESERVE8
	AREA	|Boot$$Code|, CODE, READONLY, ALIGN=6

;===================================================================================
;
; The variant must provide at least 4 functions so that the MMU can be correctly initialised
;
; All registers must be preserved, except when a value is returned, which is always in r0
;
;===================================================================================
;	GetPageTableBaseAddress()
;
;	This provides the physical address, at least 16KB aligned, where the page table should be written, this region should be 16KB long
;	Although this is specific to the implementation, possible locations are
;		1) The frame buffer
;		2) On top of the coreloader image itself
;
;	returns r0 = page table target address
;
;===================================================================================
;	GetMemoryBankArrayBase
;
; Format of table is, for each mapping region
; virtual address, physical address, length of region	(each these must be megabyte aligned)
; the PDEs created will be for 1MB sections and so will cover 1MB above the VA+length
; A table with 3 rows would look like this:
;
; memoryTable DCD virtual_address1, physical_address1, length1
;             DCD virtual_address2, physical_address2, length2
;             DCD virtual_address3, physical_address3, length3
;
;	returns r0 = memoryTable address
;
;===================================================================================
;	GetNumberOfMemoryBankAddresses()
;
; This is the number of rows that should be read from memoryTable
;
;	returns r0 = number of rows
;
;===================================================================================
;	GetRomTargetAddress()
;
; The address for the jump into the OS after the coreimage load. Existing implementations will provide this function
; whether or not they use the MMU code
;
;	returns r0 = ROM target address
;
;===================================================================================
;	void clearRestartTimer()
;
;	Initialises the timer resets it
;
;===================================================================================
; Optional functions provided by the variant
;
; if WRITE_TIMINGS = TRUE
;
;		
;	TUint32 getTime()
;	Reads the current clock value in ticks
;	returns r0 = current clock value
;
;	TUint32 getFreq()
;	Gets the clock frequency ticks/s
;	returns r0 = clock frequency
;
; if WRITE_TIMINGS  = TRUE or DUMP_PAGE_TABLES  = TRUE
;	void WriteW(TUint32 val)
;		writes val in hex, no crlf
;		r0=val
;
;	void WriteCrLf()
;		writes CR then LF
;
;===================================================================================
	IF	CFG_ARMV6
KTEXbit	EQU 0x1000		; Allocate-on-write caching for ARMv6
	ELSE
KTEXbit	EQU 0
	ENDIF	; CFG_ARMV6

PDE_RW EQU 3<<PDE_AP_SH

KCoreLdrNumPDEminus1UCUB	EQU 4095			; will be writing 4096 entries
KCoreLdrSectionEntryDefUCUB EQU PDE_SECTION+PDE_RW
KDefaultDomainAccess		EQU 0x55555555			; DACR setting
KCoreLdrSectionEntryDefCB	EQU KTEXbit+PDE_RW+PDE_C+PDE_B+PDE_SECTION


savedMMUCR		DCD	0x50276

	IF WRITE_TIMINGS
timerStart		DCD	0
timerPDE		DCD	0
timerMMU		DCD	0
timerNANDRead	DCD	0
timerFinish		DCD	0
	ENDIF	; WRITE_TIMINGS



setupMMU
	
	bl	clearRestartTimer	; start the timer. This is used to time the entire coreload & boot

	IF WRITE_TIMINGS
		bl	getTime				; read start value
		STR		r0,timerStart
		bl	WriteW
	ENDIF	; WRITE_TIMINGS
	
		MRC		p15, 0, r0, c1, c0, 0
		CPWAIT		
		STR		r0,savedMMUCR		; store away the MMUCR, we will restore this just before we jump to the OS


;
; Initialise the MMU
; 1) Setup page directory entries
;	Identity mapping, only use domain 0 with full permissions
;	Initially make everything uncached & unbuffered so that periperals still work

; setup UCUB PDE
		BL		GetPageTableBaseAddress				; Find where variant wants to place page tables r0 = page table base
		LDR		r1,=0xffff8000
		AND		r7,r0,r1							; make sure we are at least 16KB aligned
		CMP		r7,r0
		ADDNE	r7,r7,#0x00004000						; round to 16KB

		LDR		r1,=KCoreLdrSectionEntryDefUCUB		; These are the bits excluding the va
		LDR		r2,=KCoreLdrNumPDEminus1UCUB		; r2 number of PDEs to write - 1 (these the uncached/unbuffered sections)

pdeloopUCUB
		MOV		r4,r2, LSL #20						; shift va into place
		ADD		r3,r1,r4							; form PDE, add other bits to va
		STR		r3,[r0,r2, LSL #2]					; store PDE
		SUBS	r2,r2,#1
		BPL		pdeloopUCUB

; then
;	write section entries covering the SRAM and SDRAM areas with caching and buffering
;	on H2 this region is 0x10000000 to 0x20003ffff so this can be a contiguous set of entries

		bl		GetNumberOfMemoryBankAddresses
		MOV		r6,r0

		bl		GetMemoryBankArrayBase
		MOV		r5,r0
		ANDS	r6,r6,r6
		BEQ		initMMU	

mapRAMRegion
		LDR		r3,=0xfff00000						; megabyte mask
; calculate offset of start PDE
		LDR		r2,[r5]								; pick up virtual address
		AND		r2,r2,r3
		ADD		r5,r5,#4							; move on to physical address
		MOV		r2,r2,LSR #18						; r2 >>18 = (r2 >>20 ) <<2
		ADD		r0,r7,r2							; this is where the first PDE in the range is

; form PDE using base VA for region
		LDR		r4,=KCoreLdrSectionEntryDefCB		; add in other section entry bits for C&B etc
		LDR		r1,[r5]								; pick up physical address
		AND		r1,r1,r3							; round down to megabyte
		ADD		r5,r5,#4							; move on to length
		ADD		r1,r1,r4							; add in other section entry bits for C&B etc

; number of PDEs to write -1
		LDR		r2,[r5]								; pickup length of region
		MOV		r2,r2,LSR #20						; Calculate number of PDEs-1
		ADD		r5,r5,#4							; move on to next record

; write in the C&B regions corresponding to SRAM & SDRAM
pdeloopCB
		MOV		r4,r2, LSL #20						; shift physical address into place
		ADD		r3,r1,r4							; form PDE, add other bits to physical address
		STR		r3,[r0,r2, LSL #2]					; store PDE
		SUBS	r2,r2,#1
		BPL		pdeloopCB

		SUBS	r6,r6,#1
		BNE		mapRAMRegion

initMMU
	IF WRITE_TIMINGS
		bl	getTime				; read PDE write time
		STR		r0,timerPDE
	ENDIF	; WRITE_TIMINGS

; PDE is now setup with identity mapping over most of the VA space, some platforms may have some regions mapped somewhere else
	IF DUMP_PAGE_TABLES
		MOV		r1,r7			; PDE lives here
		bl dumpPageTables
	ENDIF	; DUMP_PAGE_TABLES

;*******************************************************************************
; Enable the MMU
;*******************************************************************************

; coreldrEnableMmu
		MCR		p15, 0, r7, c2, c0, 0			; set TTBR0, don't bother with the armv6 page walk caching bits

	IF	CFG_ARMV6
		MOV		r1,#0
		MCR		p15, 0, r1, c2, c0, 2			; set TTCR for ARMv6, don't use ttbr1
	ENDIF	; CFG_ARMV6

		MRC		p15, 0, r2, c1, c0, 0			; r2 = MMU control register
		BIC		r1, r2, #MMUCR_I				; clear ICache enable
		MCR		p15, 0, r1, c1, c0, 0			; disable ICache
		MOV		r1, #0
		PURGE_IDCACHE r1						; purge all caches
		DRAIN_WB r1
		CPWAIT	r1

; set DACR
		LDR		r0,=KDefaultDomainAccess		; client in all domains, but we will only use domain 0 anyway
		MCR		p15, 0, r0, c3, c0, 0
		CPWAIT	r1

;*******************************************************************************
; MMUCR definition
;
; M(bit[0]) This bit is the enable/disable bit for the MMU
; 0 = MMU disabled
; 1 = MMU enabled
; A(bit[1]) This bit is the enable/disable bit for alignment fault checking
; 0 = Alignment fault checking disabled
; 1 = Alignment fault checking enabled
; W(bit[3]) This is the enable/disable bit for the write buffer.
; 0 = write buffer disabled
; 1 = write buffer enabled
; Implementations may choose not to include the W bit. If this case this bit reads as 1 and ignores writes.
; S(bit[8]) System protection bit. Only supported for hardware translation walks.
; R(bit[9]) ROM protection bit. Only supported for hardware translation walks.
; XP(bit[23]) Extended page table configure. This bit configures the hardware page table translation mechanism.
; 0 = VMSAv5 compatible page table format.
; 1 = VMSAv6 page table format.
;         X      DLR             
;         P      T4RVIZFRSBLDPWCAM
; 10987654321098765432109876543210
;  3222222222211111111110000000000
;*******************************************************************************

		MRC		p15, 0, r1, c1, c0, 0		
		CPWAIT	r2
		LDR		r3,=(MMUCR_M | MMUCR_C | MMUCR_W | MMUCR_I |MMUCR_RR)
		ORR		r1, r1, r3	;
		MCR		p15, 0, r1, c1, c0, 0			; enable MMU,
		CPWAIT	r2
		NOP										; skips this
		NOP										; skips this
		NOP										; skips this
		NOP										; skips this
		NOP										; skips this
		NOP										; skips this

	IF WRITE_TIMINGS
		bl	getTime				; read PDE write time
		STR		r0,timerMMU
	ENDIF	; WRITE_TIMINGS

		B 		loadmain			; jump to C code - not coming back!

;***************************************************************************************
; Close down MMU
;	Preserves all registers
;***************************************************************************************
; This cleans the DCache & drains the WB buffer, then disables the MMU
closeDownMMU
		STMFD  	sp!, {r0-r2, lr}      

		BL cleanandFlushDICache


		MOV		r1,#0
		DRAIN_WB r1
		CPWAIT	r2


		LDR		r1,savedMMUCR
		MCR		p15, 0, r1, c1, c0, 0		; MMU off
		CPWAIT	r2
		NOP										; skips this
		NOP										; skips this
		NOP										; skips this
		NOP										; skips this

		mov		r0,#0
		mcr		p15, 0, r0, c7, c7, 0	; invalidate the caches
		CPWAIT	r2

		mcr		p15, 0, r0, c8, c7, 0	; invalidate TLBs
		CPWAIT	r2

		LDMFD  	sp!, {r0-r2, pc}     
	
;*******************************************************************************
;	bootos
; Shuts down the MMU and jumps off to the OS
; MMU/caching enabled flush TLBs/caches here
;
;	on entry
;	 r0=address to jump to after MMU close down
;
;*******************************************************************************
bootos
		BL		closeDownMMU

	IF WRITE_TIMINGS
		mov		r2,r0
		bl	getTime					; read NAND read time
		STR		r0,timerFinish
		bl	printTime				; print out elapsed time
		mov		r0,r2
	ENDIF	; WRITE_TIMINGS

	IF :DEF: RUNS_WITH_SMP
		BL RestartAuxiliaryCores
	ENDIF

	; run the OS image
	MOV		pc, r0				; jump off to OS
 

;*******************************************************************************
;	dumpPageTables
;	r1	= PDE base address
;
;*******************************************************************************
	IF DUMP_PAGE_TABLES
dumpPageTables
		STMFD  	sp!, {r0-r2, lr}      
		bl	WriteCrLf
		ldr		r0,=0xffffffff
		bl	WriteW
		bl	WriteCrLf
		LDR		r2,=KCoreLdrNumPDEminus1UCUB		; r2 number of PDEs to write - 1 (these the uncached/unbuffered sections)
prntloop
		mov		r0,r1
		bl	WriteW
		LDR		r0,[r1]					; store PDE
		bl	WriteW
		bl	WriteCrLf
		add		r1,r1,#4
		SUBS	r2,r2,#1
		BPL		prntloop

		ldr		r0,=0xffffffff
		bl	WriteW
		bl	WriteCrLf
		LDMFD  	sp!, {r0-r2, pc}      
	ENDIF	; DUMP_PAGE_TABLES

;***************************************************************************************
; Clean & Flush I&D cache
;***************************************************************************************
cleanandFlushDICache
		MOV		r0,#0

	IF :DEF: CFG_CPU_ARM926J
cleanandFlushDICacheLoop
		MRC		p15, 0, pc, c7, c14, 3		; test/cleanflush D-cline
		BNE		cleanandFlushDICacheLoop
	ELSE
		MCR		p15, 0, r0, c7, c14, 0		; clean and invalidate entire D-cache
	ENDIF	; CFG_CPU_ARM926J
		MCR		p15, 0, r0, c7, c5, 0		; flush I-cache
		__JUMP	lr


;***************************************************************************************
;	Prints the elapsed time & clock freq in hex
;	Preserves all registers
;***************************************************************************************
SetNANDReadTime
		STMFD  	sp!, {r0, lr} 
	IF WRITE_TIMINGS
		bl	getTime				; read NAND read time
		STR		r0,timerNANDRead
	ENDIF	; WRITE_TIMINGS
		LDMFD  	sp!, {r0, pc}      

;***************************************************************************************
;	Prints the elapsed time & clock freq in hex
;	Preserves all registers
;***************************************************************************************
	IF WRITE_TIMINGS
printTime
		STMFD  	sp!, {r0-r3, lr} 
; start clock time & freq
		bl	WriteCrLf

		LDR	r0,timerStart
		mov	r1,r0
		bl	WriteW
		bl	getFreq
		bl	WriteW
		bl	WriteCrLf

; time to write page table
		LDR	r2,timerPDE
		SUB	r0,r2,r1
		bl	WriteW
		bl	WriteCrLf

; time to program MMU
		LDR	r3,timerMMU
		SUB	r0,r3,r2
		MOV	r2,r3
		bl	WriteW
		bl	WriteCrLf

; time to read NAND core image into memory
		LDR	r3,timerNANDRead
		SUB	r0,r3,r2
		MOV	r2,r3
		bl	WriteW
		bl	WriteCrLf

; time to decompress NAND core image into memory
		LDR	r3,timerFinish
		SUB	r0,r3,r2
		bl	WriteW
		bl	WriteCrLf

; total coreloader time
		SUB	r0,r3,r1
		bl	WriteW
		bl	WriteCrLf

		LDMFD  	sp!, {r0-r3, pc} 
	ENDIF	; WRITE_TIMINGS



	END
