// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// e32test\math\trealxd1.cpp
// TREALXD1.CPP - Test data for TRealX
// 
//


#include "t_realxd.h"

const STwoOpTest BinaryOpNaNTests[] =
	{
		STwoOpTest(
			SRealX(0xffff0000,0xc0000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0xffff0000,0xc0000000,0x00000000), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xc0000000,0x00000000), SRealX(0x7fff0000,0xb504f333,0xf9de6484),
			SRealX(0xffff0000,0xc0000000,0x00000000), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xc0000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0xc0000000,0x00000000), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xadf85458,0xa2bb4a9a), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0xffff0000,0xedf85458,0xa2bb4a9a), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xadf85458,0xa2bb4a9a), SRealX(0x7fff0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0xedf85458,0xa2bb4a9a), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xadf85458,0xa2bb4a9a), SRealX(0xffff0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0xedf85458,0xa2bb4a9a), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xddb3d742,0xc265539e), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0xffff0000,0xddb3d742,0xc265539e), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xddb3d742,0xc265539e), SRealX(0x7fff0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0xddb3d742,0xc265539e), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xddb3d742,0xc265539e), SRealX(0xffff0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0xddb3d742,0xc265539e), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xddb3d742,0xc265539e), SRealX(0xffff0000,0xc0000000,0x00000000),
			SRealX(0xffff0000,0xddb3d742,0xc265539e), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xddb3d742,0xc265539e), SRealX(0xffff0000,0xddb3d742,0xc265539f),
			SRealX(0xffff0000,0xddb3d742,0xc265539f), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xadf85458,0xa2bb4a9a), SRealX(0xffff0000,0x80000000,0x00000001),
			SRealX(0xffff0000,0xedf85458,0xa2bb4a9a), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xadf85458,0xa2bb4a9a), SRealX(0xffff0000,0xadf85458,0xa2bb4a9b),
			SRealX(0xffff0000,0xedf85458,0xa2bb4a9b), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000001), SRealX(0xffff0000,0x80000000,0x00000002),
			SRealX(0xffff0000,0xc0000000,0x00000002), KErrArgument
		),
		STwoOpTest(
			SRealX(0xffff0000,0xadf85458,0xa2bb4a9a), SRealX(0xffff0000,0xddb3d742,0xc265539e),
			SRealX(0xffff0000,0xddb3d742,0xc265539e), KErrArgument
		)
	};

const STwoOpTest AdditionTests[] =
	{
		STwoOpTest(
			SRealX(0x00300000,0x80000000,0x00000000), SRealX(0x00300001,0x80000000,0x00008000),
			SRealX(0x00000001,0x00000000,0x00000000), KErrUnderflow
		),
		STwoOpTest(
			SRealX(0x00000000,0x00000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00000001,0x00000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0x00000001,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00000000,0x00000000,0x00000000), SRealX(0x7fff0000,0xb504f333,0xf9de6484),
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), KErrNone
		),
		STwoOpTest(
			SRealX(0x00000001,0x00000000,0x00000000), SRealX(0x7fff0000,0xb504f333,0xf9de6484),
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000),
			SRealX(0x80000000,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000000,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000),
			SRealX(0x80000000,0xc0000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fdf0000,0xb504f333,0xf9de6484),
			SRealX(0x7fff0200,0x80000000,0xb504f334), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fdb0000,0xb504f333,0xf9de6484),
			SRealX(0x7fff0100,0x80000000,0x0b504f33), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fe30000,0xb504f333,0xf9de6484),
			SRealX(0x7fff0200,0x8000000b,0x504f3340), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fef0000,0xb504f333,0xf9de6484),
			SRealX(0x7fff0100,0x8000b504,0xf333f9de), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de0000), SRealX(0x7fef0000,0x80000001,0x64840000),
			SRealX(0x7fff0000,0xb5057333,0xf9df6484), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fc00000,0x80000000,0x00000000),
			SRealX(0x7fff0000,0x80000000,0x00000001), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fbf0000,0x80000000,0x00000000),
			SRealX(0x7fff0100,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fbf0000,0x80000000,0x00000001),
			SRealX(0x7fff0200,0x80000000,0x00000001), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fc00000,0xc0000000,0x00000000),
			SRealX(0x7fff0200,0x80000000,0x00000002), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fc00000,0xbfffffff,0xffffffff),
			SRealX(0x7fff0100,0x80000000,0x00000001), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fbe0000,0xffffffff,0xffffffff),
			SRealX(0x7fff0100,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x7fbe0000,0xffffffff,0xffffffff),
			SRealX(0x7fff0201,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x80050000,0xc8000000,0x00000000),
			SRealX(0x80050000,0xc6000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fff0001,0x8d04f333,0xf9de6484),
			SRealX(0x7ffb0001,0xd04f333f,0x9de64840), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x80000000),
			SRealX(0x7fdf0000,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000001),
			SRealX(0x7fc00000,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00300001,0x80000000,0x00000000), SRealX(0x00300000,0x80000000,0x00000000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00200001,0x80000000,0x00000000), SRealX(0x00200000,0x80000000,0x00000000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00100001,0x80000000,0x00000000), SRealX(0x00100000,0x80000000,0x00000000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00300001,0x80000000,0x00000000), SRealX(0x00300000,0x80000000,0x80000000),
			SRealX(0x00100000,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00300001,0x80000000,0x00000000), SRealX(0x00300000,0x80000000,0x00010000),
			SRealX(0x00010000,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00300001,0x80000000,0x00000000), SRealX(0x00300000,0x80000000,0x00008000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrUnderflow
		),
		STwoOpTest(
			SRealX(0xfffe0000,0x80000000,0x00000000), SRealX(0xfffe0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xfffe0000,0xb504f333,0xf9de6484), SRealX(0xfffe0000,0xddb3d742,0xc265539e),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xfffe0000,0x80000000,0x00000000), SRealX(0xfffd0000,0xffffffff,0xf0000000),
			SRealX(0xfffe0000,0xffffffff,0xf8000000), KErrNone
		),
		STwoOpTest(
			SRealX(0xfffe0000,0x80000000,0x00000000), SRealX(0xfffd0000,0xffffffff,0xfffffffe),
			SRealX(0xfffe0000,0xffffffff,0xffffffff), KErrNone
		),
		STwoOpTest(
			SRealX(0xfffe0000,0x80000000,0x00000000), SRealX(0xfffd0000,0xffffffff,0xffffffff),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xfffe0000,0xf0000000,0x00000000), SRealX(0xfffa0000,0xffffffff,0xfffffff0),
			SRealX(0xfffe0000,0xffffffff,0xffffffff), KErrNone
		),
		STwoOpTest(
			SRealX(0xfffe0000,0xf0000000,0x00000000), SRealX(0xfffa0000,0xffffffff,0xfffffff7),
			SRealX(0xfffe0100,0xffffffff,0xffffffff), KErrNone
		),
		STwoOpTest(
			SRealX(0xfffe0000,0xf0000000,0x00000000), SRealX(0xfffa0000,0xffffffff,0xfffffff8),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xfffe0001,0xf0000000,0x00000000), SRealX(0xfffa0001,0xffffffff,0xfffffff0),
			SRealX(0xfffe0001,0xffffffff,0xffffffff), KErrNone
		),
		STwoOpTest(
			SRealX(0xfffe0001,0xf0000000,0x00000000), SRealX(0xfffa0001,0xffffffff,0xfffffff7),
			SRealX(0xfffe0101,0xffffffff,0xffffffff), KErrNone
		),
		STwoOpTest(
			SRealX(0xfffe0001,0xf0000000,0x00000000), SRealX(0xfffa0001,0xffffffff,0xfffffff8),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xfffe0001,0xffffffff,0xffffffff),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xfffe0000,0xffffffff,0xffffffff),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000),
			SRealX(0xffff0001,0xc0000000,0x00000000), KErrArgument
		)
	};

const STwoOpTest MultiplicationTests[] =
	{
		STwoOpTest(
			SRealX(0x00000000,0x00000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00000000,0x00000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0x00000001,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x00000001,0x00000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0x00000001,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0001,0xb504f333,0xf9de6484), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0x00000000,0x00000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), SRealX(0x7fff0000,0xb504f333,0xf9de6484),
			SRealX(0x7fff0100,0xffffffff,0xffffffff), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xffffffff,0x00000000), SRealX(0x7fff0000,0xffffffff,0x00000000),
			SRealX(0x80000000,0xfffffffe,0x00000001), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xffffffff,0xf0000000), SRealX(0x7fff0000,0xffffffff,0xf0000000),
			SRealX(0x80000100,0xffffffff,0xe0000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xcccccccc,0xcccccccd), SRealX(0x7fff0000,0xcccccccc,0xcccccccd),
			SRealX(0x80000200,0xa3d70a3d,0x70a3d70b), KErrNone
		),
		STwoOpTest(
			SRealX(0x7ffe0000,0xcccccccc,0xcccccccd), SRealX(0x80010000,0xa0000000,0x00000000),
			SRealX(0x80010100,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000000,0xadf85458,0xa2bb4a9a), SRealX(0x7ffd0000,0xbc5ab1b1,0x6779be36),
			SRealX(0x7fff0200,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000001,0xadf85458,0xa2bb4a9a), SRealX(0x7ffd0000,0xbc5ab1b1,0x6779be36),
			SRealX(0x7fff0201,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000001,0xadf85458,0xa2bb4a9a), SRealX(0x7ffd0001,0xbc5ab1b1,0x6779be36),
			SRealX(0x7fff0200,0x80000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000000,0xadf85458,0xa2bb4a9a), SRealX(0x80000000,0xc90fdaa2,0x2168c235),
			SRealX(0x80020200,0x88a2c05a,0x2ea3a4f3), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xc0000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000002),
			SRealX(0x7fff0000,0xc0000000,0x00000003), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xc0000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000001),
			SRealX(0x7fff0200,0xc0000000,0x00000002), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xa0000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000004),
			SRealX(0x7fff0000,0xa0000000,0x00000005), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0xa0000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000002),
			SRealX(0x7fff0100,0xa0000000,0x00000002), KErrNone
		),
		STwoOpTest(
			SRealX(0x65630000,0xb504f333,0xf9de6485), SRealX(0x1a9c0000,0xb504f333,0xf9de6485),
			SRealX(0x00010200,0x80000000,0x00000001), KErrNone
		),
		STwoOpTest(
			SRealX(0x65630000,0xb504f333,0xf9de6484), SRealX(0x1a9c0000,0xb504f333,0xf9de6484),
			SRealX(0x00000000,0x00000000,0x00000000), KErrUnderflow
		),
		STwoOpTest(
			SRealX(0x65630000,0xb504f333,0xf9de6484), SRealX(0x1a9b0000,0xc90fdaa2,0x2168c235),
			SRealX(0x00000000,0x00000000,0x00000000), KErrUnderflow
		),
		STwoOpTest(
			SRealX(0x00010000,0xb504f333,0xf9de6484), SRealX(0x00010000,0xc90fdaa2,0x2168c235),
			SRealX(0x00000000,0x00000000,0x00000000), KErrUnderflow
		),
		STwoOpTest(
			SRealX(0xaf6a0000,0xb504f333,0xf9de6484), SRealX(0xd0930000,0xb504f333,0xf9de6484),
			SRealX(0xfffe0100,0xffffffff,0xffffffff), KErrNone
		),
		STwoOpTest(
			SRealX(0xaf6a0000,0xb504f333,0xf9de6485), SRealX(0xd0930000,0xb504f333,0xf9de6485),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xaf6a0000,0xb504f333,0xf9de6484), SRealX(0xd0940000,0xc90fdaa2,0x2168c235),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xfffe0000,0xb504f333,0xf9de6484), SRealX(0xfffd0000,0xc90fdaa2,0x2168c235),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0x00010000,0x80000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0xffff0001,0xc0000000,0x00000000), KErrArgument
		)
	};

const STwoOpTest DivisionTests[] =
	{
		STwoOpTest(
			SRealX(0x80050000,0xc8000000,0x00000000), SRealX(0x80010000,0xa0000000,0x00000000),
			SRealX(0x80030000,0xa0000000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x80190000,0xbebc2000,0x00000000), SRealX(0x80050000,0xc8000000,0x00000000),
			SRealX(0x80120000,0xf4240000,0x00000000), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x80000000,0xc0000000,0x00000000),
			SRealX(0x7ffd0200,0xaaaaaaaa,0xaaaaaaab), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x80010000,0xa0000000,0x00000000),
			SRealX(0x7ffc0200,0xcccccccc,0xcccccccd), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x80050000,0xc8000000,0x00000000),
			SRealX(0x7ff80100,0xa3d70a3d,0x70a3d70a), KErrNone
		),
		STwoOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fff0000,0xb504f333,0xf9de6484),
			SRealX(0x7ffe0200,0xb504f333,0xf9de6485), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000000,0xc90fdaa2,0x2168c235), SRealX(0x80000000,0xadf85458,0xa2bb4a9a),
			SRealX(0x7fff0200,0x93eedfb1,0x38edef80), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000001,0xc90fdaa2,0x2168c235), SRealX(0x80000000,0xadf85458,0xa2bb4a9a),
			SRealX(0x7fff0201,0x93eedfb1,0x38edef80), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000001,0xc90fdaa2,0x2168c235), SRealX(0x80000001,0xadf85458,0xa2bb4a9a),
			SRealX(0x7fff0200,0x93eedfb1,0x38edef80), KErrNone
		),
		STwoOpTest(
			SRealX(0x80000001,0xc90fdaa2,0x2168c235), SRealX(0x80000000,0x80000000,0x00000000),
			SRealX(0x7fff0001,0xc90fdaa2,0x2168c235), KErrNone
		),
		STwoOpTest(
			SRealX(0xc0000000,0xc90fdaa2,0x2168c235), SRealX(0x40010000,0x80000000,0x00000000),
			SRealX(0xfffe0000,0xc90fdaa2,0x2168c235), KErrNone
		),
		STwoOpTest(
			SRealX(0xc0000000,0xc90fdaa2,0x2168c235), SRealX(0x40000000,0x80000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xfffe0000,0xffffffff,0xffffffff),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		STwoOpTest(
			SRealX(0x00010000,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrDivideByZero
		),
		STwoOpTest(
			SRealX(0x00010001,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrDivideByZero
		),
		STwoOpTest(
			SRealX(0x00010000,0x80000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0xffff0001,0x80000000,0x00000000), KErrDivideByZero
		),
		STwoOpTest(
			SRealX(0x00010001,0x80000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000),
			SRealX(0xffff0000,0x80000000,0x00000000), KErrDivideByZero
		),
		STwoOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000),
			SRealX(0xffff0001,0xc0000000,0x00000000), KErrArgument
		)
	};


const SCompareTest ComparisonTests[] =
	{
		SCompareTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000), 2
		),
		SCompareTest(
			SRealX(0x80050000,0xc8000000,0x00000000), SRealX(0x80010000,0xa0000000,0x00000000), 4
		),
		SCompareTest(
			SRealX(0x80050001,0xc8000000,0x00000000), SRealX(0x80010001,0xa0000000,0x00000000), 1
		),
		SCompareTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x7fff0001,0x80000000,0x00000000), 2
		),
		SCompareTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fff0001,0x80000000,0x00000000), 4
		),
		SCompareTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000), 1
		),
		SCompareTest(
			SRealX(0x00000000,0x00000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000), 2
		),
		SCompareTest(
			SRealX(0x00000000,0x00000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000), 2
		),
		SCompareTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), SRealX(0x7fff0000,0xb504f333,0xf9de6484), 2
		),
		SCompareTest(
			SRealX(0x7fff0001,0xb504f333,0xf9de6484), SRealX(0x7fff0001,0xb504f333,0xf9de6484), 2
		),
		SCompareTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6485), SRealX(0x7fff0000,0xb504f333,0xf9de6484), 4
		),
		SCompareTest(
			SRealX(0x7fff0001,0xb504f333,0xf9de6485), SRealX(0x7fff0001,0xb504f333,0xf9de6484), 1
		),
		SCompareTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), SRealX(0x7fff0000,0xb504f333,0xf9de6485), 1
		),
		SCompareTest(
			SRealX(0x7fff0001,0xb504f333,0xf9de6484), SRealX(0x7fff0001,0xb504f333,0xf9de6485), 4
		),
		SCompareTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), SRealX(0x7ffe0000,0xb504f333,0xf9de6484), 4
		),
		SCompareTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), SRealX(0x80000000,0xb504f333,0xf9de6484), 1
		),
		SCompareTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xfffe0000,0xffffffff,0xffffffff), 4
		),
		SCompareTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000), 4
		),
		SCompareTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000), 4
		),
		SCompareTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000), 4
		),
		SCompareTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xfffe0001,0xffffffff,0xffffffff), 1
		),
		SCompareTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000), 1
		),
		SCompareTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000), 1
		),
		SCompareTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000), 1
		),
		SCompareTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000), 2
		),
		SCompareTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000), 2
		),
		SCompareTest(
			SRealX(0xffff0001,0xc0000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000), 8
		),
		SCompareTest(
			SRealX(0xffff0001,0xc0000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000), 8
		),
		SCompareTest(
			SRealX(0xffff0000,0x80000000,0x00000001), SRealX(0x7fff0001,0x80000000,0x00000000), 8
		),
		SCompareTest(
			SRealX(0xffff0000,0x80000000,0x00000001), SRealX(0xffff0001,0xddb3d742,0xc265539e), 8
		),
		SCompareTest(
			SRealX(0x00000000,0x00000000,0x00000000), SRealX(0xffff0001,0xddb3d742,0xc265539e), 8
		),
		SCompareTest(
			SRealX(0xffee0000,0x80005000,0x40000000), SRealX(0xffff0001,0xddb3d742,0xc265539e), 8
		),
		SCompareTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xffff0001,0xddb3d742,0xc265539e), 8
		)
	};

const SOneOpTest UnaryPlusTests[] =
	{
		SOneOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000), 0
		),
		SOneOpTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), SRealX(0x7fff0000,0xb504f333,0xf9de6484), 0
		),
		SOneOpTest(
			SRealX(0xffff0001,0xb504f333,0xf9de6484), SRealX(0xffff0001,0xb504f333,0xf9de6484), 0
		),
	};

const SOneOpTest UnaryMinusTests[] =
	{
		SOneOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x7fff0001,0x80000000,0x00000000), 0
		),
		SOneOpTest(
			SRealX(0x7fff0000,0xb504f333,0xf9de6484), SRealX(0x7fff0001,0xb504f333,0xf9de6484), 0
		),
		SOneOpTest(
			SRealX(0xffff0000,0xb504f333,0xf9de6484), SRealX(0xffff0001,0xb504f333,0xf9de6484), 0
		),
		SOneOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000), 0
		),
		SOneOpTest(
			SRealX(0x00000000,0x00000000,0x00000000), SRealX(0x00000001,0x00000000,0x00000000), 0
		),
	};

const SOneOpTest IncTests[] =
	{
		SOneOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x80000000,0x80000000,0x00000000), 0
		),
		SOneOpTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000), 0
		),
		SOneOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		SOneOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		SOneOpTest(
			SRealX(0xffff0000,0xb504f333,0xf9de6484), SRealX(0xffff0000,0xf504f333,0xf9de6484), KErrArgument
		),
		SOneOpTest(
			SRealX(0x00000001,0x00000000,0x00000000), SRealX(0x7fff0000,0x80000000,0x00000000), KErrNone
		),
		SOneOpTest(
			SRealX(0x803e0000,0xddb3d742,0xffffffff), SRealX(0x803e0000,0xddb3d743,0x00000000), KErrNone
		)
	};

const SOneOpTest DecTests[] =
	{
		SOneOpTest(
			SRealX(0x7fff0000,0x80000000,0x00000000), SRealX(0x00000000,0x00000000,0x00000000), 0
		),
		SOneOpTest(
			SRealX(0x7fff0001,0x80000000,0x00000000), SRealX(0x80000001,0x80000000,0x00000000), 0
		),
		SOneOpTest(
			SRealX(0xffff0000,0x80000000,0x00000000), SRealX(0xffff0000,0x80000000,0x00000000), KErrOverflow
		),
		SOneOpTest(
			SRealX(0xffff0001,0x80000000,0x00000000), SRealX(0xffff0001,0x80000000,0x00000000), KErrOverflow
		),
		SOneOpTest(
			SRealX(0xffff0000,0xb504f333,0xf9de6484), SRealX(0xffff0000,0xf504f333,0xf9de6484), KErrArgument
		),
		SOneOpTest(
			SRealX(0x00000001,0x00000000,0x00000000), SRealX(0x7fff0001,0x80000000,0x00000000), KErrNone
		),
		SOneOpTest(
			SRealX(0x803e0000,0xddb3d743,0x00000000), SRealX(0x803e0000,0xddb3d742,0xffffffff), KErrNone
		)
	};

GLDEF_D const TInt NumBinaryOpNaNTests=sizeof(BinaryOpNaNTests)/sizeof(STwoOpTest);
GLDEF_D const TInt NumAdditionTests=sizeof(AdditionTests)/sizeof(STwoOpTest);
GLDEF_D const TInt NumMultiplicationTests=sizeof(MultiplicationTests)/sizeof(STwoOpTest);
GLDEF_D const TInt NumDivisionTests=sizeof(DivisionTests)/sizeof(STwoOpTest);
GLDEF_D const TInt NumComparisonTests=sizeof(ComparisonTests)/sizeof(SCompareTest);
GLDEF_D const TInt NumUnaryPlusTests=sizeof(UnaryPlusTests)/sizeof(SOneOpTest);
GLDEF_D const TInt NumUnaryMinusTests=sizeof(UnaryMinusTests)/sizeof(SOneOpTest);
GLDEF_D const TInt NumIncTests=sizeof(IncTests)/sizeof(SOneOpTest);
GLDEF_D const TInt NumDecTests=sizeof(DecTests)/sizeof(SOneOpTest);
