# Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
# All rights reserved.
# This component and the accompanying materials are made available
# under the terms of the License "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
# Initial Contributors:
# Nokia Corporation - initial contribution.
#
# Contributors:
#
# Description:
# See line 99 of this file.
#

if (@ARGV != 2 && @ARGV != 3)
	{
	print <<EOD;
Usage: cp54936_allbmp_fromunicode.pl cp54936_2byte.txt cp54936_4byte.txt cp54936_allbmp_fromunicode.cpp
EOD
	exit(1);
	}

my $root = "cp54936_allbmp_fromunicode.cpp";
if (@ARGV == 3)
	{
	$root = $ARGV[3];
	}


my %lines;	# the hash table to hold all characters with key=unicode(dec) and value=foreign(string)


# read 2 byte input file
open (IN2, "<$ARGV[0]") or die ("Error: $ARGV[0] $!");
my $lineNumber = 0;
my $acceptLineNumber = 0;
while (!eof(IN2))
	{
	my $line = <IN2>;
	$lineNumber++;
	if ($line =~ /^(0[xX][\da-fA-F]{1,4})\s*(0[xX][\da-fA-F]{1,4}).*/)
		{
		$acceptLineNumber++;
		my $foreign = $1;
		my $unicode = hex($2);
		if (exists ($lines{$unicode}))
			{
			print "ERROR: Unicode $unicode is reused by $lines{$unicode} and $foreign.\n";
			exit(1);
			}
		$lines{$unicode} = $foreign;
		}
	else
		{
		#print "Ignore line: $line";
		}
	}
close IN2;
print "\nRead $ARGV[0] done.\n";
print "$acceptLineNumber of $lineNumber lines accepted.\n\n";


# read 4 byte input file
open (IN4, "<$ARGV[1]") or die ("Error: $ARGV[1] $!");
$lineNumber = 0;
$acceptLineNumber = 0;
while (!eof(IN4))
	{
	my $line = <IN4>;
	$lineNumber++;
	if ($line =~ /^(0[xX]8[1-4]3\d[\da-fA-F]{2}3\d)\s*(0[xX][\da-fA-F]{4}).*/)
		{
		$acceptLineNumber++;
		my $foreign = $1;
		my $unicode = hex($2);
		if (exists ($lines{$unicode}))
			{
			print "ERROR: Unicode $unicode is reused by $lines{$unicode} and $foreign.\n";
			exit(1);
			}
		$lines{$unicode} = $foreign;
		}
	else
		{
		#print "Ignore line: $line";
		}
	}
close IN4;
print "Read $ARGV[1] done.\n";
print "$acceptLineNumber of $lineNumber lines accepted.\n\n";


# write to output file
print "Write to $root...\n";
open (CPP, ">$root") or die ("Error: Can't open cpp file");
print CPP <<EOD;
// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//
// Generated by the cp54936_allbmp_fromunicode.pl tool - Do not edit!!!
// Generated with \"perl -w ..\\group\\cp54936_allbmp_fromunicode.pl cp54936_2byte.txt cp54936_4byte.txt\".
//

#include <e32std.h>
#include <e32def.h>
#include "cp54936.h"

const TUint8 KForeignReplacement = 0x5F;

EOD
print CPP "const TUint32 KMappingTableUnicodeBmp2CP54936\[65536\] = \n";
print CPP "\t\{\n\t";

my $bytecount = 0;
my $expectUnicode = 0;
while ($expectUnicode <= 0xFFFF)
	{
	if (exists ($lines{$expectUnicode}))
		{
		print CPP "$lines{$expectUnicode}, ";
		}
	else
		{
		print CPP "KForeignReplacement, ";
		}
	$bytecount += 4;
	$expectUnicode++;
	if (($expectUnicode % 16) == 0)
		{
		print CPP sprintf("// %04X - %04X\n\t", $expectUnicode-16, $expectUnicode-1);
		}
	}
print CPP "};\t";

$bytecount += 8;
print CPP "// total byte count = $bytecount\n";
print "\nTotal byte count: $bytecount.\n";
close CPP;

print "\nDone.";
