// Copyright (c) 1995-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// e32test\mediext\nfe.h
// 
//

#ifndef __NFE_H__
#define __NFE_H__

#include <d32locd.h>



// The following is stolen from the genuine NDE driver interface from nfe_interface.h
// >>>>>nfe_interface.h
enum TNfeCommands
    {
    ENfeDiskStatus   = 0, // No longer used, preserved for SC/BC.
    ENfeEncryptDisk  = 1,
    ENfeDecryptDisk  = 2,
    ENfeWipeDisk     = 3,
    // Debug commands below, enabled only in RnD compiled extension
    ENfePause        = 128,
    ENfeContinue     = 129,
    };

enum TNfeDiskStatus
    {
    ENfeUnmounted  = 0,
    ENfeDecrypted  = 8,
    ENfeDecrypting = 9,
    ENfeEncrypted  = 10,
    ENfeEncrypting = 11,
    ENfeWiping     = 12,
    ENfeCorrupted  = 13,
    };



// The keys under the KNfeUID category are generated by combining the constants
// below with drive number by using the NFE_KEY macro below.
const TUint KNfeToThreadKey     = 1;
const TUint KNfeToUiKey         = 2;
const TUint KNfeToExtKey        = 3; // No longer used, preserved for SC/BC.
const TUint KNfeProgressToUiKey = 4;
const TUint KNfeStatusToUiKey   = 5; // Replaces ENfeDiskStatus command.

//- Macros ------------------------------------------------------------------
// Calculates pub&sub key for given drive and id. Top 8 bits are used for the
// drives. Bottom 8 bits are used for the ids. The rest of the bits are
// reserved and use zero value. The key layout:
//          dddddddd0000000000000000kkkkkkkk
//          ^bit 31                        ^bit 0
#define NFE_KEY(drive, id) (((drive) << 24) | (0xFF & (id)))
// <<<<nfe_interface.h 




// copy of TPartitionEntry from locmedia.h
#ifndef __KERNEL_MODE__
class TPartitionEntry
	{
public:
	Int64 iPartitionBaseAddr;
	Int64 iPartitionLen;
	TUint16 iBootIndicator;
	TUint16 iPartitionType;
	};
#endif

enum
	{
	EQueryNfeDeviceInfo = RLocalDrive::EQuerySymbianNfeTestFirst+0,
	};

class TNfeDriveInfo
	{
public:
	inline TBool IsUDADrive() 
		{return PartitionIsFAT(iEntry.iPartitionType) || PartitionIsFAT32(iEntry.iPartitionType); }

#ifdef __KERNEL_MODE__
	void SetStatus(TNfeDiskStatus aStatus);
#endif
	inline TNfeDiskStatus Status() { return iStatus; }

private:
	TNfeDiskStatus iStatus;			// @see TNfeDiskStatus

public:
	TInt iLocalDriveNum;
	TInt iDriveLetter;
	TPartitionEntry iEntry;
	Int64 iCompositeSize;

	/** 
	position of first encrypted byte - normally the same as 
	iEntry.iPartitionBaseAddr unless the MBR has been changed
	*/
	TInt64 iEncryptStartPos;

	/** 
	position of the last encrypted byte +1 - normally the same as 
	iEntry.iPartitionBaseAddr+iEntry.iPartitionLen if the drive is fully
	encrypted
	*/
	TInt64 iEncryptEndPos;

	TInt iReadRequestCount;
	TInt iWriteRequestCount;
	TInt iCodePagingRequesCount;
	TInt iDataPagingReadRequestCount;
	TInt iDataPagingWriteRequestCount;

	TAny* iStatusToUiProperty;
	TAny* iToUiProperty;
	TAny* iProgressToUiProperty;
	TUint32 iUniqueID;		// FAT volume ID
	TBool iDriveFinalised;
	};

/**
NFE media details - for testing purposes only
This is a structure used to communicate NFE-related information
from the NFE media driver to a test application

@internalTechnology
@prototype
*/
class TNfeDeviceInfo
	{
public:
	enum {ENfeMaxPartitionEntries = 2};
	TNfeDriveInfo iDrives[ENfeMaxPartitionEntries];

	TInt iDriveCount;

	TInt64 iMediaSizeInBytes;
	};

typedef TPckgBuf<TNfeDeviceInfo> TNfeDeviceInfoBuf;


// Publish & Subscribe is used to initiate an encryption pass - to emulate the behaviour of the genuine NFE UI & driver
//const TUid KNfeUID = TUid::Uid(0xA000E7C5);	// UID of NFE test mdia driver (D_NFE.MMP)
const TUid KNfeUID = {0x100039e3};




#endif
