/*
* Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/


#include <e32std.h>
#include <e32std_private.h>
#include "dplargedll.h"

// These are used in Read2() and Read4()
// Outer = 1024 and Inner = 16 are the values that will exercise the demand
// paging mechanism the most
#define TEST_OUTER_LOOP 64
#define TEST_INNER_LOOP 256

// 256 pages of data
const TUint32 data0[] = {
	0xda7393b9,0xb221ea9b,0xaef11e07,0x0c55bf1d,0x1c975609,0x19f5cbcf,0x5243ac45,0x120751c7,
	0x5a4f18c9,0x470129c3,0xba1d5c91,0x029150d5,0x6c1d336d,0x8febe985,0x7c579e67,0xfc8b197b,
	0x0f6feeaf,0x9783aba9,0x1c31b903,0xb739def1,0x9f975993,0xcdbb494f,0x9353306d,0x53833779,
	0x6ed33e65,0x90b57117,0x7acf4a75,0xccfbc95b,0xbf4737b5,0xedb76433,0xd41bb3b3,0x0add17e9,
	0x5c01e563,0x022fd357,0x72194483,0x910b707d,0xd1f1418d,0xfcb1dbbf,0x020fe611,0xd10df777,
	0x48f715a3,0xbdfd2431,0xb4b19747,0x1b19d541,0xfcd58f55,0x19fb19f9,0x871391e1,0x2f07834b,
	0x5639f5a1,0xb8b74def,0x2bb98f5b,0x6d593911,0xa3b77dc9,0x9767f16f,0x93892dfd,0xa83b7911,
	0x72c94057,0x2969735f,0x16d375d9,0x947dbdd5,0x88d54e1f,0x19453d29,0x3e517dc1,0xda9b46f1,
	0x7c29e53d,0xa9a98fc7,0x2c233059,0xc7b705fb,0xecf5c613,0xb66b80b1,0xa4cf3105,0x9e9bab95,
	0x5e59a84d,0x558916f1,0xb847e0f7,0x88b7d469,0xaf59cfdf,0x18298813,0x0ae38423,0x27295627,
	0x33dfc203,0xeb999529,0xbe65864b,0xc3b1ac8b,0x6dbf1a3d,0x9a4f07d5,0xfaf1dff7,0x21bb8653,
	0x65b97f59,0xeceb4f39,0x181b9b73,0xef57724b,0xa46db869,0x6b333d05,0x65db79d9,0xd641ac43,
	0xcb6be1c7,0xbd13e26b,0x958fb805,0x2cd90a13,0xce25c219,0xaba38d29,0xc301f3a3,0x472d089f,
	0xcaf73f49,0xc223e487,0x1d61301d,0x67ebf8cd,0x8425f389,0x8ef5264f,0x3045fbaf,0x51714c91,
	0x78dde257,0x84a983d9,0xccb1b455,0x76bf03e3,0x9e334d73,0x7af79eff,0x920decd7,0xcc8139c3,
	0xb823a9eb,0xcfbd2729,0x1725f1c7,0x3a07d13d,0x5291b513,0x27ff9643,0xb3356e77,0xaa4d4261,
	0x5a47a983,0xd0eb0dc3,0xe6dd320b,0xbcf38749,0x55fd941f,0xc0db53a7,0x65251467,0x17472915,
	0x3f4fc913,0x384bef71,0xbc7bfb3d,0x55376ced,0xfbbd78d3,0x02df6731,0x9fbbff03,0x9a61a105,
	0x75b9651b,0x58699c7d,0xcf21aff7,0xc3058997,0x5593b5eb,0x5ddd496f,0xa1597b21,0x350dede1,
	0x5a87ee8f,0x465b9daf,0x2c732f53,0x510d452d,0x53bd029d,0x1429fb67,0x0ee3a21f,0x833f83cd,
	0xb93f8aed,0xf9b3d451,0xd88f74e9,0xf483081b,0xe5011aa5,0x5a91a6a7,0x13bbf9d5,0xdb65a777,
	0xebe1b42f,0x6c811a2f,0xee1938d5,0x6d19db4b,0x169f5e3f,0x78693d37,0x81c1149f,0x6e750e07,
	0xfaedd8cf,0xbb57e193,0xbe358fb1,0x64ff0827,0x345b7221,0xe78319a1,0xf1593155,0x67e17d29,
	0xbd67fbc3,0x4549d547,0xf0818a97,0x90e9b899,0xe875df89,0x74319ef1,0xe165db4f,0x0d976b05,
	0xf8d1548b,0xcbe77893,0xa323d71f,0xd0099709,0x5bafb42d,0x5d45d8ad,0xd7458a6d,0xe00d9e47,
	0x812def1b,0x9345c743,0x8abb5f65,0x4c116e65,0x554d2249,0x74111ae3,0x7edb4303,0xba31ce15,
	0x58fb4bf3,0x81f5d5a1,0x1269ea03,0x9931ca13,0x5b0f2099,0x3c67a219,0xca8b35ef,0xf179421f,
	0xd1410009,0x41057075,0x7bd3ba13,0xd61d9601,0xd1370a53,0x0c97335d,0x13376089,0x75d77289,
	0xa97d54d7,0x5c0bbd0b,0xff192f2f,0xcc07be95,0x1a893f35,0x2d77bc37,0x38412cab,0xf1b9a801,
	0x2fb3e859,0x6119d92b,0xeadd656f,0x0e9fd0bb,0xb845c375,0xfa57f2b1,0xbf8710b1,0xea159bb1,
	0x60654d07,0x00bf7b21,0xc441d56f,0x1c1999dd,0x6a2ddfd1,0x0109f557,0xf5712f73,0xde591741,
	0x0695a9dd,0x2e1191b7,0x66e7f449,0x7d27c7e5,0x4e83c17f,0x21ddeb2f,0x0cddf84b,0x687b94db,
	0xdbc55a55,0x3e9fe435,0x24f1d395,0xe4fb893d,0x020b1a3d,0xafa9a3c7,0x3f2fc713,0x5ceddf29,
	0xa7f58e67,0x0a7bb267,0xe703c171,0x51452ccd,0xc005c043,0x8fbb3725,0xec478427,0xea9db157,
	0x61a9ea8d,0x0c395497,0x4c3be873,0x2a39c203,0x82354e49,0x59e9a5d7,0xba89445f,0xbb01570f,
	0x4de327c3,0x80e9db8d,0xca3fefb7,0x6287b8c5,0x20dbc38d,0x788178e5,0xb6d5e915,0x12074c79,
	0x2025b381,0x881fb095,0xcd2d9ad7,0x97658181,0x72b923c5,0x485961d9,0x748fc023,0xee27de3f,
	0x1a714fc3,0x43eb3577,0xd7ab69eb,0x30812d1d,0x6d13172f,0x38bfdabd,0x2d9723e5,0x284dc98b,
	0x2d49b303,0xf8e16481,0xa2d7398f,0x800d0d05,0x43a98a83,0xeb87c61d,0xe2531b33,0x93eddc09,
	0x17ad2839,0x2e117077,0x3e57e2dd,0xe2bf5323,0x88bd4ef9,0x55030eff,0x799ff967,0x1efb93e3,
	0x87212ee1,0xcd0f64a9,0x304bdb6f,0xdfc5b1e1,0x4d11ba4f,0xdc0748f1,0xe0e3fe5b,0xf1e7bfbf,
	0x37a71af3,0x41ebc4dd,0x9555d55d,0x48d3fc29,0x3fe946bd,0x79e14ffb,0x2bfbf66b,0x8fa31ecb,
	0x13c1b4e9,0x9b372d5f,0x40975f43,0x5a19c563,0xcf0532fb,0xda65e8a7,0xb54fda6f,0xf5a100b1,
	0x5471d9bf,0xaa07f2f7,0xdbb3843b,0xda4b017d,0x46a92247,0x7be55fff,0x3dbd6fc1,0xbbd3e599,
	0xa1391aef,0x21ebc2f1,0x06cb6bdf,0x3a9ba4dd,0xf195bc59,0xcf332b8d,0x0ca7e83d,0x34ad1e2d,
	0x30195e71,0xb8f74317,0x7881fa49,0xb6bb4471,0x390b4d6b,0x57a1895b,0x0ff1823b,0x8d1f6b99,
	0xe5957ec1,0x47bdb1b1,0x1df97011,0x74dbb59f,0xc4cd6637,0xcb011ff5,0xfbfd2895,0xec9b9f85,
	0x74afead7,0xe94b858b,0x3ad10a53,0xa5afae53,0x9b1f7bf5,0x31a59e61,0x6bad12a5,0x95133c1b,
	0x7ee9462f,0x1b390def,0x892fa2a9,0xa46964f7,0x40c18863,0x065d5c2d,0x005f6447,0x02fb1407,
	0xb44508c1,0xdd9312a5,0x59b14f2d,0x16b93075,0xd8f7a9b9,0x567ff961,0x81fbcdd3,0x0d41ea71,
	0xf3431f07,0xd2ef73f9,0xb37d0277,0x0cd52837,0x4581c2b1,0xe1dbfe87,0xfedf2c23,0x055b1305,
	0x68e989ff,0x605fcab3,0x74312ba3,0x2169c427,0x46a11a85,0x3ac37ca9,0xebef2891,0xd73911eb,
	0xb0b5ff1d,0xcd73081f,0x6ff3564b,0x99ad7cad,0x9b19fcef,0xe607ad53,0x448bd8f9,0x294f3bcf,
	0xf4ab8861,0x643f1607,0x9163ca89,0x854f6ab7,0x202d5a27,0x7afd928b,0xaa955fb3,0x7c8b55d7,
	0x0d4d243f,0x915176b5,0xf9a32cf5,0xde83e7ab,0xf19d66eb,0xc37396df,0x86738b99,0x4c6335b3,
	0xa19b65b7,0x03c1e4f1,0x20551eab,0xa9fb2d75,0x89ab3c73,0xdbbf2d57,0x27037805,0x2ec76187,
	0x471b143f,0xcd1df405,0xf39bdd45,0x16e7f681,0xe11b7879,0x52af717d,0xe1a72cd3,0xf429b001,
	0xa1cbcbd1,0x8177afbf,0xf817e2dd,0x9efb1db5,0x8f2ddd37,0x4999c75b,0x32433e5b,0xc77be84b,
	0x842f9ce9,0x57633c65,0x68ed860d,0x26693e7d,0xe9a5f167,0x944b7b7b,0xdb396d77,0x4e31620b,
	0x0f49ac7f,0x47f176c1,0x57bb99ed,0x1be354c1,0x24c1a043,0xd91962e7,0x05694783,0xc839a56f,
	0xd29bd40f,0x2eb59421,0xcca50e19,0x98995cef,0x7349d985,0xb0d77b2b,0x6037c657,0x30090b21,
	0xec274191,0xe9bfc24b,0xe64f8eab,0x803ff3ef,0x26793167,0xc6d38a4d,0x4185f04d,0x5a915c49,
	0x286d1781,0x79a1c789,0xf9d7243b,0xa105f729,0xce1780a3,0xf8e1bedb,0xc5b1783f,0x17457291,
	0x22710cd9,0x216fa2a7,0xb2e3d3e5,0xd39f248b,0x58638473,0x77534fdd,0xefa35d87,0x5013d825,
	0x63b50d0f,0x86bb2aef,0x33933f45,0x1b3fba7b,0x321f7e91,0xe4fb1cdd,0xc8b98c01,0x297167ad,
	0x843bd823,0xd195b02b,0x3489446f,0xc59717e5,0x668fd537,0x772b4de5,0x80d77c05,0x224fec55,
	0x4a85a28b,0xcc8f9aa3,0x24e59e03,0x8ad95c33,0xbf73b31f,0x15b5f37f,0x8e5dd26f,0x341fc1c3,
	0xcb95b541,0x04bd0b23,0x4a4d8317,0xadb5074f,0xe50da783,0x7aeba6b7,0xce2f0095,0xf2d37427,
	0x8aeb0dc1,0xe9af7af3,0xe0e14749,0x1b5d99a3,0x7e21461f,0x539f2915,0xa3afe455,0xacdf6025,
	0x9a8bfe05,0xed795bdf,0x3b45faad,0x8b873419,0x4fefc729,0x5f2304a1,0x18bd6809,0x8b3152eb,
	0xbaf7cc85,0xa4abb831,0xe29709e3,0xa0613819,0x5e39a75d,0x8f492be9,0xfdbb2287,0xb13f2a23,
	0x7b31543b,0xe659d2b1,0xb67bde03,0x069fe791,0x0b4347f5,0x286199f5,0x098df72d,0x5cf973f5,
	0x58bba4a3,0xec13c6ab,0x0d137ca5,0x957304e7,0x37cd8eab,0xe141f24f,0xf995b5d3,0x06d30f0b,
	0xdf97a1b7,0x71eb27e9,0xd30327e5,0x6e8d7309,0x631b85b9,0x03392103,0xb1b3bad3,0x81bbca91,
	0xca45a3ef,0xd675a2b3,0xab69fe5d,0x1e21d55d,0xcaebfbdb,0x8a19fa97,0x5c4b8f07,0x1b27062f,
	0x21c91847,0x3ac39bd5,0x0feb9b25,0xbae12fcf,0x8b832447,0x4437dc19,0x8a3f87cb,0xbb07520f,
	0x5da52037,0xa265d097,0x70a7b5d9,0x05fd86c9,0xbfa536b9,0xf2614b0f,0x52ef66f7,0x03cd0edd,
	0x83db31b9,0x136df6c7,0x5443c293,0x8b297f35,0xa08f0f6b,0x67ed9587,0x743ffae5,0x726d0dc1,
	0x48edb74b,0xb66f5ca9,0x77df91ed,0xc097fe7b,0xa607cf19,0xaaa97209,0x728fbe71,0x7e553067,
	0x2fdbafe1,0xf67b890d,0xef1df101,0x26f9ca89,0xa64f7af9,0x12eb9f9f,0xb8c378f3,0xb97b08f5,
	0xaa2b4ef9,0xa125db39,0x441f4967,0x697f29c7,0xf6259cc7,0x6b8185d5,0xb83bde45,0xf04f7a1b,
	0x37db9c8d,0x067d2af9,0x9787413b,0x7ddd831d,0x88cfe2bf,0x11bfd4b1,0x08db2ec1,0x49c356ff,
	0x876f1515,0x19176895,0xc0775b17,0xc443fdf7,0x100dbf97,0x157724c1,0x8903d743,0x6749034b,
	0x95e9498d,0x8e033cd9,0x6c919615,0x2767223f,0x1c230a8b,0x58fd970b,0x7d991123,0x84d51329,
	0xcec97f6d,0xfcd3a90f,0x3ff90dcd,0x3c777861,0x3bd19f57,0xb11f751d,0xb1f9823b,0x98d7eb45,
	0x2c1550b1,0xff9ba6ff,0xf54d9a5b,0x63272943,0x1c59fe31,0x0531d0ff,0x980bdce5,0x744160c7,
	0x564b4bd1,0x52edc8f5,0x7db17059,0xe5a79e4f,0xa97febd5,0x6f05253b,0x682b7ffd,0xe285595b,
	0xc46f93c9,0xf5d9d9b9,0x20c9c0e1,0x18ab2173,0x2d83117f,0x5aedf4dd,0x414116db,0xc9956b29,
	0xdc038011,0x49f17c99,0x9cb3598b,0x7b657d17,0x71279ce5,0xa7bb6b6b,0x48ab3959,0x49e57cdd,
	0x11093ca5,0x3349cd5b,0x46154475,0xd7879c23,0xdbafe045,0xc6c1fcf3,0xca4b0bd3,0xde65659f,
	0x060369ff,0x38710049,0x280f6835,0x61412a05,0x92dbf255,0xdbd105fb,0x5887df21,0x7c878d19,
	0xabf1bd15,0xa27d022f,0x244327e5,0xd74732a3,0x9aed4e53,0xdd3b6b91,0xec3bd09d,0xb43d8b77,
	0x62599f67,0x9cfd1857,0x12d30323,0xa2cbc269,0xf6a973f5,0xb3d53b3d,0x04cf6a21,0xcff9c961,
	0x1739ceeb,0x56038089,0xe2613605,0xf77d8643,0xc74d8779,0x5aef4b09,0xc8214207,0xf4af2001,
	0x6715fe1b,0x1e251111,0xb80f5927,0xf3916b97,0x6ca1f195,0x005bd981,0x22939b2b,0x41cf7903,
	0xbced73f3,0x886fd8b9,0x0f7f01a3,0xbfb9404f,0xa4e1ff87,0x24692dab,0xe70904e5,0xf14b6e8f,
	0x7247abeb,0x8a77bec9,0xdad36113,0xaf2552d9,0xacd38305,0xb9ef3713,0xeee5fb11,0x7795eb51,
	0xef23f5ff,0x9c4d230d,0xa2ade58f,0x5f8b121d,0x5fb7724d,0x463b2dc5,0x3a078605,0xa39fca71,
	0xca0116a9,0xd8857dcf,0xa631d9b3,0xd917ad83,0x57518817,0x01233249,0x0ed3da9f,0xbedd7799,
	0xe7e5e6e1,0x1c31ffd7,0xfafd0499,0xae81b4f9,0x0be1e39b,0xf4f5eda9,0x1a29fa37,0xad3f8ef5,
	0x9c51f421,0x26df3271,0xad3749db,0x1cf7b8e5,0xf429a897,0x1e87316f,0x8f6d52a9,0x0d377d2d,
	0xc9472065,0xbaa79767,0xdf7d4991,0x2c2dea35,0xa56d9f41,0x8d2797a5,0x48815e4b,0x57b71f6d,
	0xff474227,0xbc154901,0xeaf50057,0xce55ba4f,0xf36bd457,0x82a922d7,0xe5c543fb,0x0031635b,
	0x9d57c45f,0x52419a0b,0x7f3f6747,0x001f7b1f,0x106b3911,0x935fde0b,0xee1b7711,0x9499e727,
	0xf0f54687,0x06b7b5cd,0xc27d13fb,0xe8c1ff0f,0xad294327,0xc61d7ccf,0xeee95769,0xdd5f9977,
	0x56253c9b,0xe58d4013,0x7151d88b,0xf9e73907,0x18eb8cd7,0xb431fb2b,0x9c0bd15b,0xfd755975,
	0x57698f15,0x9d55f527,0xfedd6395,0x0fc9dc75,0x617174d9,0xa96f3da9,0xefe9fdc1,0x924d96cb,
	0xcdc13aed,0x9f1f49d3,0xb4c3e02f,0x9115fd41,0x72ffbe67,0xc429b153,0x4b61c1f5,0xd3dbf1a5,
	0x00b3f19f,0x3e7d0b5f,0xd32595f3,0x8effafd3,0x38553139,0x1531ebb3,0x95d56fd1,0xb48ddaab,
	0xc63db923,0xd183ff95,0xb0a588ff,0xe539a917,0xbab5398d,0xbfd94ad3,0x5d2b65b1,0x01593309,
	0xa2e58bf5,0xd0c184c3,0xda6519e9,0x59f3de79,0x41e1881b,0x19f3953f,0xf5bfae6d,0x81afec67,
	0xe9a9f90d,0xf74b31af,0x3409a5cd,0xbde125df,0x741db21d,0xcbd199fd,0x9a79a161,0x1781a8f1,
	0xdc0bc3e5,0x62b175a3,0x17af2645,0x0c35d5b5,0x7629d14b,0xf045d09b,0x8cb78263,0xdf435b4d,
	0xca11847b,0xb307386b,0x75fdd16b,0x8a9f64e5,0x0b4923e3,0x349ff921,0x345b21d1,0x4fe5e6ab,
	0x323b4743,0x2add7a51,0xf611b9d7,0xe9530ad9,0xb53bac9d,0xf8b5bc19,0x3fc97c83,0x5ad7beaf,
	0xe1892d3b,0xcf47f41f,0x15916ea5,0x63035f79,0xd447d2b3,0x6ed74a8d,0xc3e35bd5,0x8c118787,
	0x137f0bdd,0x87d5b71d,0x489d9b6f,0xdce1fb33,0xc72901df,0xbbd5fe09,0x5c09f59d,0x29ffb5dd,
	0x921f0d21,0x3e99cd17,0x19d7a84f,0x069d16ed,0x0b274a5b,0x1705f893,0x4a1f8c39,0x55952ed9,
	0xd5eb4f83,0x0027d855,0x4a6159dd,0x7a6b2c15,0x5c0100e1,0xea35c4b9,0x96850e81,0x2a47e825,
	0x25e585fd,0x1b8fb3a3,0xf1dd7135,0xdcfd9491,0xd3f95eab,0xf1bbf583,0x301fb7d1,0xde0587eb,
	0xb78d9805,0x4265124b,0x9e6d4bf1,0xfd832acd,0x0bd32171,0x5c65c67b,0x0c4db001,0xe14104d7,
	0xcee7419b,0xa8bb2015,0x74b3842b,0xf5b1e9b3,0x3acf2b71,0xeb89bbab,0x46f5ab6b,0xfeed4613,
	0xde77b333,0x251f214d,0x4fd1907d,0x49b98cad,0x56b12363,0x12f5419d,0x42738ae9,0x7c7dc345,
	0xa73b31cd,0x50a712bd,0xe16b63ff,0x084b2fa5,0x33b71481,0x18fd4d5b,0xc7adfbd5,0x39df249d,
	0x58b5b6df,0xa6e549ad,0xd19f0e4d,0xea9bef05,0xa4a70e85,0x3675fc71,0x2605180b,0xd189e2bf,
	0xb0eb9063,0xa5e913e9,0xdf115b81,0x745b87b5,0x9ac3c5a9,0xb6ab34e5,0x535d05e3,0xb86be6d9,
	0x1c5b00d5,0xee4757bb,0xfee57433,0x13bdf723,0x45cb32a7,0x17734545,0x0c159837,0x5df92a93,
	0xd60bdf2d,0x630f33eb,0x7cbb7d81,0x41711b35,0x340132b9,0x291f8499,0xf30fee63,0x4c215819,
	0x077936e7,0x49d39fc5,0x1ab33901,0xa0ab5259,0x7227279b,0x2e81f26b,0xb1af143f,0x47596a13,
	0xe8a9e7fd,0x6aa70b11,0x3173a4cd,0x1f1d1b75,0xab819783,0xfcebd6c5,0x17d7a225,0x6e914bad,
	0xe01b46e7,0x301dfe1b,0xd01b9b83,0x14f7b5f5,0x49cfcd2d,0x1c2f6231,0x3be75cef,0x5b3b788f,
	0xa2d5bc9f,0xc743b9ad,0xdc4d7439,0x64edc1c3,0x955377d3,0xe69f4dbb,0x9ac3d5f9,0x41499ce3,
	0x545766a1,0x3fb1d70f,0x322ba28d,0x9c31df49,0xd4d14b2f,0xa90d7ae9,0x37cd0b1b,0x0f2f3555,
	0xa6a1b6e7,0xab73e80f,0xc4575695,0x12754f6f,0x6d899f7b,0xc2cb93c9,0xbce506af,0x8ddd2f0d,
	0xfa3713e9,0x3f2116f1,0xbbf31ceb,0x09e993a3,0x033d1171,0xc5abaae3,0x9a6d7f91,0x80c587b5,
	0x7e1b78a1,0x71c7c685,0x98a37ead,0xcf410dcd,0x9831224b,0x95fddb41,0x27497917,0xc5d9ed79,
	0x4fcd148b,0x1cfb3211,0x5085a171,0xd9ada055,0xad25d7c5,0x8a97e86d,0xc0dbe31f,0x758b5f01,
	0x9b53eba1,0x9ccf0d5f,0x703de753,0xeae34e27,0x615b5c15,0x8cc9de73,0xeb053a01,0x02cfcb79,
	0xbb2b765b,0xefd324bb,0x3aef8eed,0x2f11daad,0x92979df7,0x3863b1d9,0x70252699,0x5b13b289,
	0x585b41b5,0xd719fcef,0xca395357,0x5ce969d1,0xfd19f0a5,0xfbbbdfad,0x81231e3f,0x064dc45b,
	0x8a618f27,0xf6357345,0x2e410c2d,0xd5a11ffd,0x5ba3abd9,0x379f0d75,0xd55d02cd,0x46ed819b,
	0xf741f4ab,0xf3395d85,0x8da74d89,0xc4e7c21b,0x8779cbcf,0x5f65a93f,0xcab7c29d,0x39e7db71,
	0xf37bfcbd,0x96b329fb,0x458d0805,0x40ef5595,0x985b913d,0x18db8993,0x8591f88b,0xf6a9d389,
	0xa215c657,0xebbb7f6f,0x099528bb,0x6a69c055,0x048b215f,0x5c578d7b,0x10cf8bed,0xaf291c0b,
	0x148da4f1,0x5fdddd2d,0x03e13943,0x8c8b68c3,0xc0cd25f1,0x94a73c83,0x7dd150a3,0xcfd7b7a1,
	0x6ae7c087,0xe3313aff,0xf513ffb9,0x3d03d5cd,0x60616d29,0xbf1f66b1,0x047ba701,0x1fa59977,
	0xf3a5b591,0x0843a92d,0x544d1eb7,0x7c034ed9,0x350989c3,0x8b93c493,0x232f1be5,0xe0074535,
	0x4bc9350b,0x2429f083,0x6f31b557,0xd4417bd3,0x6f0972fb,0x7c51972f,0xbecd08a5,0xeceb6f05,
	0x7ed5a46d,0x6e75324b,0x89e1ff31,0x7aeb0525,0x3d212487,0x062d4813,0x42b73321,0xdcc79b93,
	0x26c9bdb3,0x2137884d,0xff01f461,0x6fb333b9,0xec933ea3,0xb0790947,0xc0d36dad,0x208bc009,
	0x8c2b2f55,0x9901a4d5,0x5fafe981,0x9ccf90f9,0x0923a60b,0x35077555,0x117f3727,0x23a9e20d,
	0xc5f93c4f,0x74e772ad,0x93912fab,0xf6ed86cf,0x7d1123f5,0xa0292f49,0xf39d5ae7,0x6c15b7cd,
	0xd9b75c19,0xb679b51d,0xf8c5b477,0x9d41ffa5,0xb11f061f,0x70b182a9,0x2c9190c7,0xba3d47f3,
	0xdb67daaf,0xe1cba7f1,0x83f1a203,0xf97b0663,0xac91bebf,0xb7f10383,0xa83d1d21,0x291789a7,
	0x0d897889,0x1d6f9f71,0xe035fee5,0xdfd16677,0x35278493,0x39bb2e5d,0x990170d1,0x4e130493,
	0x01230aa3,0x5273a86b,0x8f314e37,0xaef14bc7,0xef23f2d1,0x8c5f0845,0x97c1c92f,0x592370e3,
	0xb5b31a77,0x4c6d2823,0x090b2f97,0x700de2bf,0x7d47a937,0x38b3bec3,0xc3ddd015,0x34bb573f,
	0xb93d85fb,0xd96f7c69,0xdc63ff1b,0xf6dbf849,0xa0d7ebfb,0xda0747e1,0xe3393bdf,0xa5c9b0d1,
	0x48431faf,0xea099b83,0xce5b755f,0x018999cf,0x599543db,0x3e2d0229,0x82356f65,0x6bc38745,
	0x6dc74e89,0xb14fb43d,0xfa95477d,0x58cbb53b,0x05bf1e0d,0x857554a7,0x13b51a01,0x609994c3,
	0x2349ae03,0xc4d1cddf,0xf335c70f,0xefd1b8f7,0x821b6c4f,0x42b54ee1,0x111bd78d,0x98bde3f7,
	0x70cfae19,0x3ca16835,0xe0d9822d,0x044f33ed,0x49e944d7,0x9b3b48e5,0x1a47d065,0x83237009,
	0x8cd73345,0xd3531b89,0xa2a5e373,0x3e777585,0x96ed8263,0x66dd833b,0x159d5961,0x0939c4a3,
	0xfc65367f,0x05f738a3,0xee3dd1fb,0xd0fb2dad,0x81676429,0x4fe9c6ed,0x4ffd93db,0xaef59df1,
	0xb2fb6541,0x342168cf,0x6fbf515f,0x990b0ccb,0x20192de7,0xf3350585,0x9ccb0dad,0xb2c7889b,
	0x329bc187,0xbfe14dd5,0xe9d121b7,0x3e5b63cb,0xa845c7d5,0x000ff90d,0x75e96133,0x2da181cd,
	0xabc741cb,0x2dcb2201,0x55935f9f,0x531dc417,0x8daf5eab,0x584bc411,0x1bb7d545,0x32f7972f,
	0x1d7f7105,0x44ef581d,0x02a52431,0x74019f99,0xa29903a7,0x303b9197,0xb519fd3d,0xf0b786eb,
	0x75470eaf,0x2ee13b73,0xb72d2507,0x683be8bb,0x37c14c81,0x2eb3352d,0x6f6f58f5,0xcf575fad,
	0xaf21aec5,0x97b18fcb,0xcfcb5439,0x417db267,0x3c6df371,0x8d01cadb,0x9e9df4c9,0x91c7209d,
	0xf58f59c1,0xcdf13171,0x5fa18065,0x7bf9d007,0x5e5d7735,0x36f9572b,0xdd030991,0x75795965,
	0xc1932c9b,0xe2b5b52d,0x5051f4a1,0x1e5f7583,0x29d5bb05,0xeaed6727,0x2b859ca9,0x5261ca31,
	0xfaadf8cf,0xc98f084b,0x81fd1887,0xd9e3d749,0x2993a69b,0x59afb059,0x11851fe7,0xbaef03ab,
	0x16e3e455,0x788d1095,0xeb491035,0x2a35ca3f,0x06dfc62f,0x4691b0cb,0xbce311a9,0x1c1306f9,
	0x3ab309a7,0x08474c53,0xb9535c41,0x758b63d1,0xa975ea7f,0xa7654f09,0x22019cc7,0xdd43e5c9,
	0x592117c3,0xd3c97251,0x6fbf79c7,0x2c9399eb,0x579bc8c3,0xc47d7a19,0x1bc5389b,0x80716245,
	0x53aff21d,0x98ab11d9,0x08b18261,0xea81e2f3,0xd6119ab5,0x58abc989,0x8b8d4901,0xc20b8f15,
	0x1a5f50b3,0x96f932b3,0x14c7cc29,0x9505d5d5,0x8819be8f,0xb13f1d61,0x793bbe51,0xb9076f63,
	0xcbb15fff,0xb149f52b,0xdb2789b7,0x7c53c9f9,0x8f775709,0xce0f3e2b,0x3333b565,0xf6d596db,
	0xd4a960f9,0x8cad3209,0x79716a27,0x7b1d774d,0xec6beb61,0x816b7cf1,0x6e571797,0xa767c9a5,
	0x10cb491d,0xb0b51a99,0x03c73913,0x16959639,0x9db9074f,0x9023533f,0x66073ac3,0xb12f9c6b,
	0xea156263,0xa775d8a5,0xa4c97e95,0x9e6b7fa5,0xc0a1db0d,0xd18d031b,0xfc278141,0xd5211459,
	0x7909eb47,0x1d7d2e77,0xbd9d1f45,0x4cd3ccff,0xb0e5db55,0x4f773713,0xd917f9eb,0xceab4717,
	0xa4adb6c1,0x01df16d7,0x05e3fc3f,0x667df82d,0x28c76161,0x6637a22f,0x8bbb001b,0x73c3fad1,
	0x4281cc4d,0xa62f650f,0xabbd931d,0x5a9ffb9b,0x610b4aeb,0xe49b9ff9,0xa975dbad,0xd4d9462f,
	0x368507e3,0xde7d64ed,0x73cf9df9,0xe2e7f233,0x30f19a2d,0x2bf9d47b,0xee2560f9,0x5ce1305b,
	0x933db9ff,0x215d7ab7,0xd937b36d,0x2389b75f,0x2e3d15e1,0x501fcc3f,0x5c2d90d9,0xf1495101,
	0xb9ab479b,0xa7dfc337,0x2d99e691,0xcb358709,0xcd2de941,0x37619c4f,0x5c7338a9,0x12077049,
	0x7951ca2f,0x8d97b3bb,0xb9196701,0x331f9d99,0x80874407,0xba938237,0xde539241,0xf98b26dd,
	0x302fafb5,0xf095ba09,0xda5520d7,0x7ef9d7fd,0xd98dfa6d,0xc50383fd,0x77b5e3fb,0xbcc77de9,
	0xeacb5aa9,0x116bdc6b,0x26735cab,0xbcf5539d,0xa7ff252d,0x7485102f,0x84f720b1,0x6b2d8f17,
	0x8423c203,0x732d59ad,0x89115f9b,0x05c30e61,0x1a1fc181,0x396b9dd5,0x48fb87bf,0x2eb1248d,
	0xc5bb113f,0xfb6d4919,0x64550b3d,0x9c9786b5,0xdcaf5123,0xf6874c79,0x0d2544fb,0x6bc158f9,
	0x87954857,0x123b3a79,0xb0df7dad,0x0f235b83,0x3af37a4d,0x212b8425,0x415710c5,0xe1533785,
	0xd033dbc3,0xc229d615,0x1dd1b183,0x5597ec37,0x3eaba7b9,0xe1299563,0x9bf1cff1,0xc8d75bd9,
	0xf495547d,0xd84b7cb9,0x30cd1ddd,0xf2a7f8b5,0xd019a8a1,0x30d3593f,0x39d733dd,0xf641921f,
	0xb841f001,0x0431e7ad,0x65f55651,0x1385416d,0xd60150bf,0xfcfbd13f,0xbe6b5a5f,0xf7ff7703,
	0x6d354049,0xf7efc8bd,0x4febaafb,0xafe12747,0x55a3184d,0x44f3c771,0x738d6dd7,0x370717ad,
	0x13f5cbcd,0x88156a33,0xb7d1c873,0xa9f14bad,0x92c1bc07,0x3a8d6e5d,0x699f4519,0x16c991c7,
	0x7b83ad87,0xcbb74ed7,0xbd4957d7,0xee633087,0x2f9fdd23,0x6219010d,0x97870383,0x1537b37d,
	0x616134f3,0x3c65d1f5,0xf6779ebd,0x9469d843,0x4cfda15d,0xb26d630b,0xfaa1b8ed,0xeac39b77,
	0x918f860b,0xd631c757,0x8ff91f41,0xfdb765c7,0xaa1d52ef,0xb4d9c063,0xb6d501b1,0xaa6158e1,
	0x06933947,0x37af1b45,0x6cf537fd,0xf681bc7f,0xc4c30093,0xa52d2d9b,0x3681a6ab,0xe1818b63,
	0x096bfba1,0xc1f1728b,0x4709c409,0xd5732055,0xf92f1d85,0x91bf47c1,0x4a873d31,0xb8150327,
	0x519b2e95,0xb887ca71,0xce5bbb01,0x9bc5d5b3,0xa223217b,0x7b5dd45b,0x4a4bc721,0x108f60d9,
	0x2525881d,0x618318c3,0xc989d0ff,0x1525c183,0x38e328b1,0x755d6177,0x33af52d5,0xa7e1b5a1,
	0x788bb2b1,0x2579ebcb,0x35b9169d,0xf7c7092f,0x752f93e1,0xc58de59d,0xcb139b23,0x357f232b,
	0x0ecded4d,0xaf790a53,0x668b98f5,0x045bb29f,0x6d49a847,0x04435fd7,0xbb5ba769,0x8b577b9f,
	0x9971ab69,0x0d1713a3,0x2621019f,0x26154441,0xb5f52f99,0x3c4d77b1,0xb5e76b7f,0xb5dfe1a7,
	0xd8753501,0xce631f87,0xd51d36b7,0x92a764fb,0x82731813,0x0aff1d31,0x929b67bf,0x1c09686f,
	0xba5d468d,0x25f15e47,0x8aa1fad7,0xea437c3b,0xc4851471,0xc02d28e5,0x6fd94905,0x9f43b39f,
	0x7c2bb109,0x08d1b8af,0x34518d19,0x579951e7,0x4c6f3be9,0x7e25fbd3,0xd28188a9,0xbb819763,
	0xc95ff9ed,0x4e957009,0xb64b4915,0xafddae6b,0xe8f1aa37,0x59bb1f89,0xc5f70c85,0xa737b863,
	0xdbfffb35,0xd151be1d,0x0b3346e7,0x92c1fab1,0x874d1f97,0x7a41e60f,0xfc1bc6f5,0x73552bc9,
	0x9c898359,0x8d977537,0x642dfb29,0x8a77e023,0x5347a0bf,0x398909ef,0xed5156cf,0x2b4d1741,
	0xc201f555,0xc277a01f,0x48d7d6f5,0x2bafe8ab,0xd71f16ed,0x43e54e35,0xf879a771,0xf51350f3,
	0xf1e9e8a1,0x11832223,0xb757e7e3,0x359d1eb1,0x1b97efd7,0xb8271e67,0x82f790b3,0x3115ff89,
	0xe043c939,0x9ecf5707,0x444b7811,0xb1f1ad23,0xc7f3bdb9,0x47a12e93,0x18ad76f1,0x9a493a2f,
	0x6f917795,0x30ebb31b,0x3ad9ae15,0x14df7f67,0x41f1d74f,0x56251b3f,0x8bfbeb03,0x661fa88d,
	0xd0d3e8b1,0x50eb6325,0xbca12d09,0x5d19e16b,0xcdd9f7cf,0x1a030979,0x15c54a43,0x648922cf,
	0xa38dc605,0x6a5fec71,0xe1c5b48b,0x33d11f95,0xae67def7,0xbc1146c9,0x756b5e8b,0x1ffb519d,
	0x15c30d8d,0xeb5bccc7,0xd8e7c0b1,0x0cb726d1,0x44e1f0fd,0x779fe939,0x10d1fe37,0xfd634e21,
	0x03f1b1c3,0x646f1a73,0x07292a17,0x46012489,0x3107d69f,0xba7f6f53,0x1457ac1d,0x5c374207,
	0x191f399f,0xa8ad243f,0x282dc5d7,0x485b26a7,0x711d1d13,0x45016023,0x92e1379b,0xb6670777,
	0xeecd609b,0xeda91173,0x6e15058b,0xa6fdbb95,0x81e3d617,0x49fbeb2f,0xa5d15c8b,0xc065c91d,
	0x2cfbb6b3,0xeb7381db,0xa185974b,0x3f95923b,0x7e9b37e3,0x8ebb8885,0x8d076343,0x8925a221,
	0xaa2f405f,0xfc9f2dc1,0x419b05b3,0x5a571a07,0x41093d2f,0x8b1798ad,0xcee7c0a1,0x9a153e2d,
	0x8b67169b,0x3e3f85ed,0xa3fb57dd,0xc9f522df,0x816d4539,0x895d04b1,0x5851b5fd,0x172b796d,
	0x642706e1,0xafe153ab,0x14c9b163,0x0b9f7d31,0xf689b3b7,0xc663de1b,0x9ca9f133,0xded70089,
	0x566f3329,0x539d58c5,0xf6a5f25d,0x670999e3,0x759f90e7,0x9177fef5,0xb5d12c99,0xaa0df0ad,
	0x32c5b1ed,0x4dffef83,0xe2af5767,0x0e652a61,0x12732981,0x6c6da9cb,0x8429cf0d,0x2c3b7781,
	0x98272e29,0x061faab1,0xc88d199b,0x3e63c095,0x3f45aebd,0x2b9729a3,0xce958be9,0x3357732f,
	0x141b8757,0x4589f597,0x0e5f0e93,0x5e376ee9,0xecd9d659,0x15c9720b,0x62750303,0xc7cf1263,
	0x429f716f,0x5853b401,0xb0c74867,0x1f936847,0xaa6f7a8d,0x0451bf0b,0x33ad60b9,0x4c997445,
	0xee3514ed,0x2d0fe239,0x62e7b5b5,0x9ea7a017,0xc5c93a11,0x8303352b,0x7c9dfde3,0x9f274881,
	0x2fe3aec9,0x74cd3507,0xae61c193,0x82296a47,0x6b291823,0xf031817b,0xde29ffdb,0x37676f3d,
	0x8f29307d,0xc31fb9b7,0x1357f39b,0x1b471b3f,0xc5531c7b,0x9cad797f,0x7fb3f87d,0x47cf9929,
	0x2207e007,0xae197613,0x286b8feb,0x85b3a7e7,0x1d87f353,0xebc9bb43,0x2f1b861f,0xdd4fe769,
	0xad01f7db,0xee4b0863,0xbac13719,0xc7a345ab,0xfb898d65,0x73574d53,0x80c5f39f,0xff598bad,
	0xc31946f7,0x7ec94773,0xedf78641,0xf1c50a75,0x4599bfe9,0x1ba93eb5,0xef91d857,0xcfdf6819,
	0xe5d1d0d5,0xbd23e28d,0x5c31b6fd,0x3f4b8caf,0x6079e49d,0x3f9146f7,0xfce3b81d,0xab53af5b,
	0xa52b6d6d,0x896d0179,0x36133f67,0x35eb8343,0x4f6b79b9,0xcc5f6621,0x509ba34f,0x48a9849b,
	0xbfa7693b,0x6637e483,0x62bd7217,0xc5d3659b,0xd433c1f7,0x61e984bd,0xd91dd6c5,0xd9519b85,
	0x424b2537,0x98958475,0x9fcf1e29,0x69b70ba1,0x8f116491,0x727f13d5,0xeb4b5bdb,0x293dd841,
	0xa895b6dd,0x48173297,0xa16f2f37,0x46c74dbd,0x1ec90d41,0x62f1acf5,0x6285a867,0xbedfef79,
	0xfc898825,0x9ecf38b5,0x323d4d5b,0x4cb9a4dd,0x409b0c3f,0xaa95b223,0xc0af3ec7,0xfb2b0659,
	0xf6a9f78b,0xe9517917,0x535b7d2d,0x55b9ca67,0xf049f649,0xf339eded,0x4e294dd5,0x39915289,
	0x1df5f807,0xb6ad0e89,0x5c6bbfcb,0x467f5847,0x88154497,0x3933335b,0x39d750e7,0xf001ba35,
	0xe7f3b115,0xf877ec55,0x1b8fb2cb,0x2e3b68e9,0xe0c3f4e3,0xeb51fdf5,0xb91bafdb,0xcef37405,
	0xd8a11ead,0x22c17e43,0xf5693047,0x669d3733,0x71932967,0x0ae911cb,0x27d55f09,0xe153a723,
	0xa283b14b,0x4c19489f,0x051deedd,0xb3d7be91,0x7047c8dd,0x4bc91b61,0x28677f4b,0xac950b3b,
	0x469bede7,0x4d978833,0x3c4921a3,0x649f5aeb,0xf1231e7f,0x34454fc3,0xc3b7fdfb,0x50ad8875,
	0x346b0dfd,0xe2c7d247,0x83111835,0x722368af,0x06e77a07,0x3d310c7d,0x892334f5,0xa80bd77d,
	0x69f59f87,0xc9bfb4a7,0xd819dead,0xa017e4c5,0xe2d7cfaf,0xf1db7795,0xae8d8a91,0x67a1217b,
	0x93b924fd,0xe311559d,0x707fdda3,0x9cab0c95,0xf4b15831,0x10171f99,0x305911ab,0x3ee1a019,
	0x2cbbb559,0x51cd13f1,0xd7e97a35,0x2095fe0d,0x0abb30c7,0xa8379b91,0xf1672999,0xf7bf3d83,
	0x9e7f9c17,0x9b8526ef,0x1077b5f9,0x0f035793,0x71b7fb2b,0x3d0d2b07,0xdb1d1e39,0x96ab3461,
	0x6103f92f,0xc84d3e5f,0xb2c9cf0b,0x95a7d813,0x14e57d97,0xe3eb5605,0xfd57c7e3,0x7a95afdd,
	0x1ac9611d,0x82b7228d,0x0e05e003,0x4cb7fef7,0x9e0742c5,0x64a38d15,0xae7d2b73,0x7cf56ba3,
	0xc0d77cdb,0x37d15443,0x47cb7fff,0x56e1ac29,0x955f39ef,0x5987c943,0xab6b1a3f,0x11b753db,
	0xb6aba9e1,0x3733acc9,0x7c3d6295,0x8159c013,0x81b156d1,0x4f692c15,0x3789d225,0x674f2531,
	0xee4b9a29,0xd2e9fdeb,0xddfdf7e1,0x63cfbb9f,0x083d31a1,0xe59b9f99,0x3cb59d7d,0x86b10ccd,
	0x0835f42f,0x7f8bb1f3,0xd62f0c7b,0x80776035,0x0cc5a71b,0xedef7657,0x6b537323,0x734d4859,
	0x736df2ed,0xf4256ba9,0x24716981,0x64034fc3,0xd18d7879,0x8cb50b59,0x5a43966d,0x4b15c601,
	0x8d7305db,0x4a4da659,0xfee77489,0xc5a5acaf,0x1755eb75,0x58c36229,0xa6e93739,0x667dc46f,
	0xc24d70f5,0x1e1555cd,0x3235cfaf,0xa70db9e7,0x3d5f6a49,0x7b69c6d3,0x152511e1,0x787372c9,
	0xac79ecb3,0xae0d864d,0x4179f98d,0x746f7ad1,0x616f23b1,0xd0776ddd,0xaf5b0f3b,0xae6d90bd,
	0x34fb460f,0xfb47fca5,0x8659ed3b,0x247d5359,0x7fc5aae3,0x06431455,0xe66be4a5,0xd05b0e75,
	0xb355fe85,0xe957d61f,0x50f3c257,0x5867a7e9,0x9323979b,0xbd9b9fc1,0xb1b9b3f7,0x60afac97,
	0x0d89ec0f,0x5e4f2883,0x07ed4cf7,0x7be37d6b,0xb4cd2613,0xa9d5be2f,0xaf27ab8b,0xbc5b9c53,
	0xd819d925,0x62bda21d,0x4867bdb5,0xe51d1947,0x3c83d707,0xb0bf8627,0x4315a63d,0x3ad31f4d,
	0x760724c3,0x41b929b5,0x060341af,0xf4cda16b,0xe0870fad,0x0aaf16b3,0xb867cb65,0x4e0727b3,
	0x38d36261,0xa8cf7e97,0xaae3a27b,0x3621bc3f,0xd59db9c1,0x6273375f,0x607d2edd,0xa269f82d,
	0x8081f9fb,0xc817d88d,0x37a9e635,0x7ecd30ab,0xef05e37f,0xf55ff831,0xb33b70ff,0x3eebc3e7,
	0xdb93c809,0x721d87df,0x6377ef77,0x0f03861b,0xbe815f9d,0xb34751b7,0x6f035ea7,0xa4ff4e89,
	0x270bbd87,0x3bf79559,0xbbef1d5b,0xb173a47b,0xb4556557,0x5e79c4f7,0xb8b5912d,0xf0998c3f,
	0xae6b7fed,0x9d376245,0xc533eb79,0xdb517431,0x3f413069,0xabc9fb7f,0x3bb50e6b,0xf82941b1,
	0x4bb30937,0x0fed486b,0x19e791ed,0xcc4f7e29,0xec87a109,0x62896757,0x49e3e8bb,0x6c9fa409,
	0x876747dd,0x30ab3a17,0x8b29a551,0xae9d8bcd,0x87ebdbf3,0x7c8be309,0xfba3def9,0xf973f8f3,
	0xb88bbedb,0xde856213,0x409fb6bf,0xb6f14705,0x3badea63,0x462151a1,0x4fd5fc7d,0x64913697,
	0x249d25a9,0x5b0dc3a7,0xd867f3d1,0x4477da3f,0xb08f5a0f,0x7e1d3ea5,0x4bdd3921,0xae6fa39f,
	0x1f9f0843,0x6a51da9f,0x8727c69f,0x00e79063,0x2dd3dd35,0x75d17e23,0x1b9d193f,0x31fb7737,
	0x2c176721,0x72e93b43,0x37ff75c5,0x006f74d9,0xb93dea8b,0x310fcca1,0x31754db3,0xc4ab7907,
	0x1b05573f,0x9de13261,0xac91c45d,0xe1c3f38d,0x370f5d4f,0x86276f2d,0x664953d5,0xd671a13b,
	0x2be9a215,0xf6cf653d,0x9cff91ff,0xee1578eb,0x8a071537,0x3defd34f,0x19791581,0x91bbb87b,
	0x2cc7659f,0x8bc571a7,0xd7eb7ac7,0x391511d9,0xb36b9681,0x33b72f11,0x50e9890d,0xfb7ff7f3,
	0x9a21b457,0x8d538de5,0x6277774f,0xc0f70bc3,0xf2fba9e3,0x755120fd,0xd8f95157,0x132ba949,
	0xbef93533,0x6e8d28c3,0x98457cb1,0x8e6d9493,0xe6fbfc9b,0x630d501f,0x648f5db7,0xf2b5c6ad,
	0xd4cfc3b3,0x05038989,0x4b771c87,0xd4a95ab1,0xac2bc05f,0xcfc10bfd,0xad078a07,0xee8f9ac3,
	0x23a90fcd,0xa8c77003,0xe4af24e9,0x115b2d0b,0xfdcd4b6d,0x20bbeca5,0x92473ea3,0xb5a760b9,
	0x22053dfb,0x546db479,0x83114073,0x2cb79b09,0x55a5b87d,0x6dd1729f,0x3ab11063,0x7173e439,
	0x94e78739,0xc505e7b9,0x1c3b963f,0x996d9493,0x0bf186c7,0xa151a6f5,0x332760a1,0xe5e32169,
	0xafd1d901,0x9a23f309,0x9c5369e7,0x74b30a15,0x77793a09,0x9811bb31,0x8f09fd37,0x9169e4f9,
	0x34c5754b,0x75d7b833,0x05f7bb83,0xa6378c7b,0x0d79fa79,0x415fa95d,0x0839c081,0xccf76c0d,
	0x94439291,0x1cb5b183,0x924de7af,0x002bed2b,0x81b734d5,0xbf0fd405,0x1f1b3157,0xebff0453,
	0x0d51fbcf,0x95cd91c3,0xd0f54785,0x5f45de11,0xe6733a55,0x8573a62f,0x3a912313,0x5c75abf3,
	0xcd6db07f,0x4ab3e43d,0xc811d09f,0xcab39197,0xcc71e0b1,0x7b5f3369,0xc7fb5591,0xc6c9b199,
	0x109b8499,0x2777acb9,0x1441b517,0x94295aa5,0x62f12227,0x1a21d7b9,0x5b3d1527,0x2ded546d,
	0x415dc099,0xbaab0783,0x08ab0385,0x77d74ca9,0x97b5bd6f,0x8d8dd7ad,0xceb7dab3,0x0f53641b,
	0x18b5c177,0x5563c963,0xcef14705,0xbc71db8b,0x36ffd5c3,0xd3f5004f,0x634deb8f,0x82ede0cb,
	0xbe2398ad,0x2b311fa5,0x87312731,0x53297bb3,0x0b9392db,0xde2b4725,0xe061f991,0x5b2f9b27,
	0xe7adac37,0x72233013,0x680f0821,0xf7b1420f,0xfeb1c0f5,0xaf816a3b,0xb3d3c317,0x4509d45b,
	0xf9d1568f,0x82d1b8f5,0xdeadaa71,0x50398405,0x381d70c9,0x7dc9901d,0x1207b2f9,0xe7edde0f,
	0x279386ad,0xf847b117,0xaeafcb3b,0x0d757781,0x3e179791,0xd155e7d1,0x15dd8091,0x05cdba6d,
	0x9275600d,0xd01de7c1,0x1233c419,0x0a97d2ed,0x1561af05,0xa4f748e5,0xe0b9cfbb,0x9b1dbc21,
	0x6a77daa7,0x8a5fa4c1,0xd9df2b25,0x6d4f6d33,0x613d5563,0x85ffd361,0xba7bd0cf,0xfecb2653,
	0x0e1f62f7,0x49a5485d,0x8cd172f7,0xc5d3ddbd,0x836fed63,0xb4438fcf,0x3187e0a7,0x024dccaf,
	0x2a6b79f5,0xf2fbeb5f,0x88af8aab,0x2ecf1c73,0xbc373e3f,0x42130f39,0x3abf289d,0x1193b35d,
	0xdadf551d,0x4df7ff13,0x21997ddb,0x6d7b21c3,0x4a5913b1,0x343f0b2b,0x51833e8d,0x5311af07,
	0xc97d7e67,0x24abed43,0xc23114a1,0x11858695,0x8b13ddf3,0xa21d05ab,0x97b7c4cf,0xc7b504d9,
	0x4ec7744f,0x63a7b837,0x0b997395,0x95212451,0x1a2d51bf,0xd57be947,0xf5bb0a3d,0x6af50a7b,
	0x91bf49cd,0x39fd9abd,0xf573bbd5,0x7d01b4e3,0xf1e3084f,0x6aafa907,0x3a73aa33,0x52c1c619,
	0xa7e5465d,0x3941a819,0xede1aaf7,0x785572b5,0x8afb1f5b,0x7087e073,0x3b412c87,0xcf8b8e5b,
	0xb53f85f7,0x75836c1b,0xf9853b15,0x80d1b8b1,0xfcb5d921,0x88597399,0xf405a597,0x8c45aa6b,
	0x0c4b9917,0xa5578b09,0xd38142cd,0xfaa7a241,0x1cd33c59,0x05f32f03,0xa723563d,0xae63f1f5,
	0x4e0d24b5,0x41cd61ad,0x0d771535,0xd489ab4f,0x9f99b43d,0x0fa967b7,0xfd7b4bcf,0xf5d36d21,
	0x8a07824d,0xa679a555,0x2f8b21e9,0xa7a75045,0x37c7b087,0xbe4f9b41,0x2671002b,0xdd0bf49b,
	0x5e395fd9,0x316b03c5,0xd85b9503,0xd7b5ae0d,0xb6a14571,0x3d330fad,0xf7e5f9a9,0xb8fbd18b,
	0x17295fcf,0x6335c34d,0xdd0df71b,0xb2e3220f,0x2be5cbb5,0xea297383,0x0e3b6b23,0xd9175d9b,
	0xcfd5b92f,0xfeeb62b3,0x6941cd4f,0x91e5ea37,0x05d9808d,0x75837dcd,0xec55d3f5,0xa74da2f7,
	0x91c1d76f,0x2a1f3943,0x1f173935,0xf7edc4f1,0x313f25b5,0x02138e15,0x1b939ff7,0xc813fc47,
	0x74effa89,0x8ce116c7,0x373598e9,0xb2ad9123,0x3955a163,0x452b4c65,0x4bd7c783,0x3a59b4b5,
	0xbfe1d6f9,0x71c3e387,0xa0bb2703,0xfa57ee39,0x67e39e53,0xa69d4947,0x73876f73,0x7791a7ed,
	0x079735b9,0xe5d9404d,0x214b9aa1,0x919bdc1d,0xe5252bbf,0x60bb9dc7,0xef818923,0x93ade219,
	0x4f979441,0xd8b32667,0x7507c759,0xe5ab5b39,0xd7e15d61,0xa0578b6b,0xa327726b,0x5d213fdf,
	0x29dfc48b,0x3c65879b,0x6e913d47,0x2e3d0c75,0x8557eb73,0xa4c31c41,0x185d95a5,0x7cdb0e6d,
	0xd6f38d13,0x257fee35,0x170be903,0x8d7fd13f,0x7149d2af,0xdfd1c2d1,0x9f8509ab,0x9651ab6d,
	0x65d548d3,0xeb151cfd,0xce19b3ab,0x30256b7f,0x7dfbf44f,0x15d1fa25,0x6f7f31d9,0x67752507,
	0xd4078743,0x46b7af3f,0x69d922d5,0x6d611d9d,0x0c2db60f,0x7d99e5c7,0xc5af5e07,0xe8b5d9e5,
	0x2d89ac5d,0x7477b8c3,0x56eff89d,0xe6e34a85,0x1b21a225,0xe079f1c1,0x05f56a8f,0x6d051931,
	0xace1909d,0x52e965d7,0xb87fd39d,0xa8df15a3,0x689b074d,0xba41729f,0xdab5604d,0xc1d9c297,
	0xdb0d20fd,0x831f9b41,0x8827ceed,0x4a0702dd,0x90db98c1,0x59474567,0x54cf1497,0x4f21e641,
	0xaf91fef5,0x88a9964b,0xb60d222b,0x0b8b969f,0x2ea30e3b,0xfe596fa7,0x0ba7c94b,0x374f64d7,
	0xb06f2081,0xe9998cc1,0x48d1c16d,0xf91ff5d1,0xfb37c3f7,0xfccdbf67,0x3d1fccc3,0x77578f83,
	0x12277019,0x4e834ced,0x7d95fd4d,0x08f585e1,0xee575aab,0xda716b31,0xed9719d5,0x06a7c7ef,
	0xd7bf6cb9,0xa277dd99,0xe7f922e9,0x3bbf8cb7,0x5e455793,0x6f9bb20f,0x07f3f7df,0xf7352047,
	0xf2b5c9d9,0x33091e0d,0x92231bd7,0xbcadd0bb,0x1fc5c46b,0x07197b8d,0x7d959ab9,0x9571fb35,
	0x630d0f73,0xd0496613,0x1cb50e33,0x017338db,0xa617cf69,0x7e3ff7b1,0x665bc2bf,0x884dabdf,
	0x574b3a05,0xeccb25f9,0xdecdfc97,0xea436c7d,0x22fd6b49,0x64e13f09,0x20ad5cc7,0xf13b15f5,
	0x4c6b5a83,0xbd9f8685,0x060f661d,0xe1cd738d,0xa6bbef47,0x1d4df29b,0x7169222f,0x8c2f4d9b,
	0x2df5366d,0x5a570901,0xb69de65d,0xfd455675,0x4011b719,0xfc57dbf5,0xa3f338cf,0xcf99377f,
	0x75e9e7b7,0xdd07273b,0x2b19d575,0x1c5dbe1f,0x1c41c2fb,0x69518d1f,0xaa2bd303,0x0c6b28c9,
	0x4cc77ce1,0x8241f379,0xd4a7e7f9,0x094593f5,0xa70f57a9,0xfe0d00a3,0x3c75cfa1,0x8e178725,
	0xa99398df,0xc915b885,0x7ae5cf09,0x98b1a1e1,0xaab99e59,0xa6dd398b,0xf9b15a07,0xba8f68bb,
	0x71cf1331,0x931599ab,0x5bf9d83d,0xc9d3324d,0x700744c9,0xc293e363,0x87438a0f,0x32473437,
	0x997d97cd,0x445532b5,0x4c838dad,0xe65db021,0xde351d2f,0x4281f231,0xb10d040f,0xf02f40bf,
	0x431d472d,0xe36537ed,0xd7a355f5,0xa27f46cb,0x9b09be49,0xca794283,0x896f98e5,0x69b97603,
	0xdfb5564d,0x3959161b,0x5eff142f,0x3ced8231,0x2ac5234d,0xd0cb3961,0x894de5e9,0xaed7ec27,
	0x4ec3aea5,0xf1c1928b,0x3ab7c7f3,0x9ed9eebf,0x10274bf9,0xbe4d6455,0xb007f4f5,0x89fb8bd9,
	0xfe4b8e31,0xbab16b05,0xd96d2d5d,0x7bf3b95f,0xec75dc83,0x0e4f1969,0xa381dc65,0xa019ae43,
	0x0acf2769,0x64b9f5d5,0xe0435d07,0x726f4f7b,0x9f6fbda9,0x6ea31727,0xd01d5f0f,0x90a1bd0d,
	0x5f514149,0x02ebc1c5,0x4adb6c0b,0x2afffefd,0x6759bca1,0xdf99249b,0x88bb8c53,0x1585d261,
	0xd553d74b,0x0adb361d,0x8b590c03,0x78d3964f,0x00f32b29,0xd407b14b,0x26bd6005,0x233758e9,
	0x54d5b967,0x749b32a9,0xaa5b2b07,0x79a1045b,0xc77f7f77,0x513b7545,0x2a096283,0x08a9abd1,
	0xf45b2c17,0xdab9afb3,0x670593b3,0xb595f889,0xd4bff449,0x0f0b1111,0x58fb48a3,0x8f4fb6c3,
	0x18e78857,0x9a4d5e03,0x56fb8d21,0x3f6782c7,0x20f728d5,0x97c5adb9,0xe07b93c5,0x1b1995e7,
	0x95fbdba1,0xf2e546e5,0x065b7aeb,0xd445b37b,0xa2e9c0d9,0x683f9cc7,0x73e731bd,0xca7935e7,
	0xcd9987ed,0x26936c23,0x17cb7d29,0xfbe33b91,0x6fd3048d,0x0fc7f845,0x6d211ce9,0x9661f3ed,
	0xd043e3b5,0x99e96805,0x646b1077,0x28730c73,0xdb7b80a9,0x503142bd,0xec8dfc21,0x72433da5,
	0x7cf9d9f5,0xf3fd0d57,0x1bdbadef,0xd6a5f80b,0x9821a66b,0x3dcf073b,0xf90dc2bf,0x6c133139,
	0xa13f8a27,0x3e5b0761,0xe4416b2b,0xadaf50c3,0xd6896b8b,0x5f757947,0xa001509d,0xcc413d4f,
	0x1917e843,0x051979ef,0xfa3d9a45,0x9f3d8985,0x65f3ea41,0xce7114e9,0x154d1217,0x35bfc115,
	0xef035cc3,0x76c9a14b,0x50f169d5,0x0787d5bb,0xd421014b,0x56973eaf,0xd351a005,0xc5ffac35,
	0x7c0564a3,0x847b723d,0xb1ff84f7,0xcd3bc94d,0x8d55f3e1,0x9639e3a1,0xbaf15fc1,0x34f51ed7,
	0x879f315d,0x01c13a11,0xdd89b345,0x818df8a9,0xfc5309bd,0x1e29194b,0x338f2327,0xf50f09a5,
	0x67d148e9,0xc4af3e91,0xaa3378d7,0x802f98b5,0xaa5b2f17,0x91b9bdb3,0x4b0bc88f,0x5343cdcb,
	0x211f25c3,0xc5d55e05,0x251bb64b,0x0f511edf,0x5f3194ad,0xc6bb1767,0xd5c9dad3,0x9701dcf1,
	0x868bd6e3,0x4047af39,0xb1e548b7,0x7fa7e10d,0x41154fb7,0xe581756d,0x8ea9314d,0x223d5941,
	0x59979fc5,0xd1952177,0x2ab5a9b5,0x4c63b5ab,0xf4c9f9ef,0x88ddcf53,0x370f8fd9,0x9165b567,
	0x6a459861,0x99d31c87,0x00298f63,0x3b3593a3,0xbd8f518f,0xde1f6521,0xb6dd46cd,0xdb6f548b,
	0xb7154d33,0x5b9120b5,0x59678c57,0x7c51325d,0x9d2bd94f,0xc51d5f61,0x3c73d309,0x71cb2a59,
	0x8d0d5f33,0x9be366cb,0x340fafaf,0xca69a9c7,0x73dd786d,0xf0276f1d,0x5cb37de1,0x606b5af9,
	0xa7ab23dd,0xc2598011,0x844124ff,0x8aaf1249,0x20691aa1,0x040d6de1,0x3301fd33,0x6dc1db17,
	0x50f34529,0x3905f651,0x54a3d467,0xecd324cb,0xa00d5025,0xb825fdb3,0x813f1357,0x3abf0fd9,
	0x81676193,0x8c7bebd9,0xe655027f,0x0b09dabb,0x2e8fedb3,0xf63f2921,0xcfcf2f27,0x62d96eef,
	0x0007ac13,0x8bcbbb6f,0xd0f9f05f,0x0a030dff,0x6631ac85,0xfaab0331,0x8d8f0bfd,0x9bff1e7d,
	0x82598c25,0x6889985f,0x22b17ba3,0x38f11903,0x5fb3ca55,0x743d4771,0x2fe751b5,0xd6a39531,
	0xcc5b3dc1,0xd6c72e71,0x8021be63,0x318776b1,0xd257a95d,0xa449f9e9,0x52b534a7,0x5db73a35,
	0xd0917163,0x2d1341f1,0x4467af3d,0xf7f76273,0x33df7057,0x7e9d0725,0xd85d15ad,0xf6af052f,
	0xcffdec03,0x84854fa9,0xa127c147,0x1af17833,0xd88faa7d,0xc98fe42b,0x09bf2223,0x017b1e4d,
	0x7a21271d,0xd8a92ce1,0xbe85841d,0xd3ab545b,0x1327e789,0x3ded2e87,0xb63ff3df,0x988b7e39,
	0x0cfff0a9,0x2795a765,0xdb1f43d9,0x25d133d3,0x54e95bb5,0xa70b4c45,0x53bd313f,0xb0d78e1b,
	0x75170b23,0x91db257d,0x6c1ba915,0xff9b9409,0x4d997fbb,0x02bb0bed,0x1e9d2d1d,0x39cbc79d,
	0x6d6dcd85,0x7a8b45f7,0x3d1758e9,0x59b7d2e3,0x0b77b0d5,0xa14f4489,0x39c186cf,0x3d5b54eb,
	0x9f83c347,0xa7378019,0x903994f1,0x5759cecd,0x1b47d0bd,0x459975a3,0xce89ca33,0xfffbb0ad,
	0xc35b4c63,0x5ff3c3ad,0x3e21db47,0x663386b3,0xa847e5ad,0x44eb6745,0x2cd90fa1,0x209b460f,
	0xbf773d55,0x8f5118ff,0xd5f18683,0x5e75b9fb,0x9c3dba5f,0xa717c9f9,0xeb119bf5,0xb8ad10b7,
	0xc8d97f15,0xe25f40d9,0xbd4b6dc3,0xa2d38891,0xbf6b7e0d,0x466fd6cb,0x06158085,0x7c233cd5,
	0x8301af1f,0xe8b55483,0x5051849d,0x407f12dd,0xd8916471,0xefc5ef41,0x01453b2f,0xd971c70d,
	0x1ff3bf6d,0x345f65c9,0x01a57b2d,0x0f2b19cd,0xccf145c5,0x826b3d69,0x0685564b,0x19871c8d,
	0x80319677,0x79f51ef5,0x7a695e0d,0xd1079ec9,0xc04d3ec5,0x103353cb,0x063708b5,0x7fd7baff,
	0x52bdaf39,0xb08362cf,0xba3f3655,0x52c783b9,0x34e950a7,0xfd6fcd71,0xd73bd5c5,0x6a53d08b,
	0x3519b92b,0x319feca3,0x374ba9a1,0x8b9b2b0b,0x2b850127,0x20efede5,0x56f52d55,0x716ddbdb,
	0xd3473847,0xd95bf03b,0xfe2b9a0b,0xbd3917a5,0x4363fa7f,0xe4094131,0x89450bbf,0x88194c1b,
	0x07c72509,0x2647b9df,0xd203c62d,0x93cf8cf3,0xda47ab69,0x628b3be1,0xb88f99dd,0x1bc520f3,
	0xfb9d8c6b,0x59754e5b,0x4c77691f,0x46112edf,0x2c71e721,0x8acbdafb,0x95b5cd0b,0x34678a8d,
	0x464b2fe5,0x96790af9,0xfda7da7f,0xb52fa1d3,0x74a3855d,0x3d99440d,0x58170721,0x946f8995,
	0x0dd32573,0x03654581,0x8c332e63,0x8cdd2ab9,0x0c210259,0x6e45651f,0xdd97b679,0xd8d18f33,
	0x26b7778d,0xe8c7ec3f,0xd541d567,0x634d4efb,0x8aab1ecf,0x42a394bb,0xca99f5ef,0x98fb1d13,
	0x33f7c52d,0xd1b725fb,0x0c713ca3,0xd92f7483,0xe6837ffb,0x330731eb,0xa9ff2cdb,0x86e3655b,
	0xc719e1d1,0xabc1f201,0xdbe56db3,0xb9b981b9,0x946d4f93,0x2a3f4439,0x0d2baf17,0x8ef9eabb,
	0x801b756d,0xe6fdc81b,0x843faeb3,0x1a997d89,0xa7a9dbd3,0xa59f1bb1,0xabfd5cfd,0xf82f2059,
	0x2d819c7f,0x95f73891,0xfca12237,0x7c012f5f,0xf1f93777,0xd4fbf0d9,0x84d74369,0x83f909df,
	0xec4d8801,0x8dc58c2f,0x12ad675f,0xe8a7bf21,0x23a1d9b5,0xbaa184bf,0xfc9d3bb3,0x8e45db77,
	0x47ff1d6b,0x85f9643f,0x8a8739c1,0x15b9553b,0xeb5f3e49,0x4b65c0eb,0xfeb18bb5,0x2d8999cd,
	0x5a9d96b9,0x38a35a89,0x3ecd117b,0x82e9ba97,0x167b856f,0x8e995767,0x1cf385c9,0x52b5ba09,
	0xeca52263,0x8255a159,0x40a5c323,0x9a6df89f,0xb0b113dd,0xbe0f62bd,0xafc728cb,0xe93bc1d7,
	0x951b8365,0x8223a379,0xf7ad1fd3,0xd0f3f93d,0x244732d1,0x661905f7,0xf60fc013,0xf70fe75f,
	0xd981b139,0xb99fa431,0x420b9529,0xc5af26d9,0x59ffb001,0x85890ca1,0x352b837b,0xbc9fb14d,
	0x4dd977d5,0x2cd75f4d,0x945dcd3b,0x62510c61,0xd9177da9,0xadb18ac1,0xd8fd375f,0xd4e196c9,
	0xb4a517b9,0x8263a915,0x19c94ea5,0xfb0ff53b,0xe7555285,0x22637ce5,0x93e9cc95,0x55459f7d,
	0x1ee5e5db,0x234f0e55,0xd3ef1c81,0x6e978d55,0xa8f949cb,0xf9f16815,0x7ed1007b,0xedbd0395,
	0x0c1febb5,0x5b317457,0xbaf15667,0x461b8115,0x40c78339,0x3d2bf9db,0x3915fceb,0x08bdcbb9,
	0x8a518743,0x781bb8e5,0xdd71d875,0xd5511d67,0xefffc305,0x0767a841,0x0899f83b,0xeb337113,
	0x55ff0afd,0xea9d5247,0x8091db41,0x5a67efb5,0x366311ed,0xa67551d1,0xf9bfd549,0xd4957d4f,
	0xfa295ddf,0x65cbef47,0x3ff393e5,0x1e1165e9,0xf2375d27,0xbaa5dd97,0xff67c36d,0x1ed32a95,
	0xf0559b63,0xff351733,0x2db9d3ff,0x937f6e6d,0x803b1671,0x56cddb19,0x12f3de81,0x5e5f0391,
	0xc081b37f,0x4eedc9d1,0xf287a9a5,0x78651829,0xdbb1d403,0x203b2265,0x5449cee1,0x822d836b,
	0x21330ab3,0x8f871f6b,0xed7bff73,0xf4f5328b,0xbe5bf095,0x6ec57403,0x29c56965,0xf3abb5cd,
	0x176919f5,0xbe13e8cf,0x54393c83,0xbbe1ed79,0xc07d2b65,0x6cb918fd,0x604f4f67,0xb6cfd6e3,
	0x16a70ebf,0xba254f43,0x52e5e46f,0x2a597961,0x78d74829,0x36ed82dd,0x4b458ec3,0x8a09f355,
	0x20ef6b0d,0x65cd7491,0x2c1f374f,0x6811a729,0x9cadaf1f,0xfcafebad,0xe48941cf,0x064b884f,
	0xe6c1a559,0xc59f1305,0x5907d1c1,0x873b883d,0x1fbf0cff,0x1fd3f5f7,0xec7f2f69,0xbf092377,
	0xe721c89b,0x20ab1d69,0xa9434cdb,0xa4870e87,0x544ff301,0x54ad4cc7,0x0a096ae9,0x623102fd,
	0x8f93144f,0x20855f07,0x62f3de37,0x0729ac71,0x0b2176e3,0xc20b43a5,0xea87f42b,0xd839b587,
	0x5c159c6d,0xf13d1ba7,0x62b9f7f3,0x40d3f4e5,0xb373d2dd,0x21417699,0x61dd5787,0x6411ba3f,
	0xf72be96f,0x6165af93,0x3bb7e8a5,0x4db73b4d,0x7b0d05a7,0xde216a31,0x8a6d4dd7,0xc32d20cf,
	0x59d59851,0x02112f99,0x578f7b69,0xb4853391,0x6e2b727f,0x36fd2b75,0xe5175c75,0x4d7b2963,
	0xeb99fa8d,0x46d308ff,0x166397d9,0xa671921f,0x9793811d,0x5ca7eff1,0x793d753b,0x1571e4a3,
	0xa275b61b,0xa5b9a191,0xeed5e20d,0x1f2babdd,0x20853dbb,0x9271b5ab,0xf4c39685,0x07fdd3bb,
	0x22ef6577,0xb75bf797,0x8e095aa3,0x04e91637,0x70c5f911,0x4e2de331,0xcc0b6b2b,0x0c978853,
	0xe0053799,0x56c741dd,0xf79dfeb1,0x48594717,0x4e91e85d,0x582de789,0x59f5ea89,0x252b4497,
	0x3b398ffb,0xc18f8fab,0xa5b567d1,0x04af34e7,0xfeb1c557,0xeb43da41,0xffe5f875,0x8e2d9b2d,
	0xa491a69b,0xb7c568cf,0xa8f56c21,0x9f9bf691,0x64616e39,0xd4bf1b61,0x45bd054d,0xde910f45,
	0xba8d27ed,0x9bff6d8d,0xc87dbe37,0xe951637f,0x216785bd,0x9477f373,0xf9ddade9,0x27c7b483,
	0x6a2dd4f1,0x9349f6b5,0xa1ed8d31,0x3c83b39b,0xb603131d,0x7cbb3381,0x51275ba5,0x15c1cf15,
	0x0ef5231b,0xa539b58d,0xc96b24a3,0x9e631f4d,0xa0f72211,0xd25bd517,0x0701e457,0x0ef173a5,
	0x92e7dc6b,0xdbe153e1,0xe9978cad,0xdea17f83,0x7f8762d7,0xecad9a3b,0x7d472a5d,0x544b275b,
	0x8e85bf55,0x63d113f9,0xe39329e7,0xb771eda3,0x2d73ca27,0x5581ad7b,0xdc61bc8f,0x213d7fe1,
	0x68d11ed9,0xac1b70a1,0xef015d69,0xed83639b,0xe4ff313b,0xe92741dd,0x332d7649,0xcbbdc361,
	0x774b826b,0x8653bd23,0xba0324cf,0x700d5bd1,0x5eebf5cd,0xf67332ef,0x970d1f61,0xe43b8887,
	0x1df7460b,0x4689c549,0x893bba31,0x78bd7131,0xf2799a17,0x5eb9a4b9,0x43e50c35,0x55ab567d,
	0xef593a2f,0xe3516d5b,0x57cb342d,0xabc7ff25,0xb56b64d3,0xb5c7a3c7,0xbc17bd9f,0x857b44e9,
	0xcc6d43d1,0x15bb5223,0xf75725d9,0x37dbc197,0x9c05013b,0x61f3c51f,0xe88380f5,0x73a19bfb,
	0x04bbfc6d,0x795b68ed,0x2ffd3ed1,0xf62d74ef,0x99071f09,0xbc0bc64d,0x388d1015,0xda8d7457,
	0x764351fb,0xac419f83,0xe063eb2f,0x8a6f761b,0xbdb31277,0x2f632d5d,0xc2153157,0x4f31572b,
	0xad8526f7,0x6eff7c2f,0x1da7f38d,0x82d36281,0x59cd743f,0x59cde8d7,0x617f5795,0x60ffde1f,
	0x0587f25b,0xc4a9bdb9,0x536f1d03,0x7809b80f,0x1b95c19b,0x2b9befc5,0xd9ad422b,0xb9eb535f,
	0xc7c75f9d,0x12d1fb6d,0x63dbc92d,0x2d45752b,0x2fcffc45,0x079fe1b1,0xf3ff9cf1,0x3e635193,
	0x4c49eebd,0x41874513,0xc78b9625,0xb039b8c1,0x61b94a77,0xe32ba6a5,0xa059a041,0x2d5d63e7,
	0x198d9431,0xdb5dc2f9,0xada5fe83,0x7915623b,0x3b1996eb,0x66110f2b,0x151bb0f5,0x4049a603,
	0x049958f3,0x2d6755e3,0x1bc9f965,0x8a8db183,0x243130db,0x0aa3744f,0xef290069,0xcb1b6411,
	0x50ebfa7f,0x67353721,0x0e199a61,0x91d3e703,0x83bf6c03,0x3db35797,0x51e32c75,0xdc41babd,
	0xd0898acf,0xbadb9879,0x9737b193,0x0699e3a5,0xdf094099,0x7e930311,0x072ddf73,0x5cb1372f,
	0x03f1105b,0x7ce94435,0x00476b95,0x4b0fc8d3,0xf9d1eb59,0x7f152945,0x9f69703d,0x2fdb7711,
	0x3a27261d,0x44733d23,0xe8e7f17f,0xcbe99875,0xf6578d7d,0x438b853d,0x9177822f,0x53b1c88f,
	0xb0ab9b91,0x0b095e89,0x673b08ed,0x2057d4f7,0x755dccbf,0x42c57a83,0x5abba521,0x00a5ca51,
	0xb38314b1,0x4cbdfc31,0x27e7b3f9,0x2a0f2145,0xb6257359,0x8619b521,0x9f15f56d,0xc9ab0b83,
	0xbd2da9f5,0x28238269,0x8e09d13d,0x353fe0c5,0xb6731007,0xc955c9a3,0x48e9bbef,0xbc33abcd,
	0x96af8859,0x7e4d15f7,0xd347bbd1,0x1899d763,0x528795ff,0x9acfd50f,0xa9190dff,0x802ffb59,
	0x77879155,0x12cb3425,0x27bfeb53,0x5553c989,0x6523fcfd,0x7b571cf3,0x97056d77,0x78111ad3,
	0x25b9fae3,0xabaf52bf,0xd21793d9,0x371b1c21,0xe78be13b,0xfe3daf57,0x908f68b1,0xe0cb9b63,
	0x15c5ef81,0x318d800f,0x4f6f45ff,0xf4257495,0x117f2375,0xe95502c5,0xda1d3a87,0xf1d11eb5,
	0x8ab12e23,0xcf7502dd,0x73698edd,0xcd2158cd,0x794188e1,0x54f39647,0x9e8b6a55,0xfd11f6f1,
	0xb5fbaa47,0x12fbfa77,0x88279811,0x2d43cf37,0x33955b3b,0xcbe59167,0x0f416bf3,0x8f01c6c1,
	0xd7a72be7,0x0c2ffea1,0x6e4bc7b1,0xca3dfeb9,0xf3b908bf,0x6b7f6431,0x841d3fbd,0x8e932151,
	0x5e37ef7b,0x6da5bfab,0xbcf76057,0xc441cec1,0x2b75c423,0x0395672b,0x9b811289,0x5d352a49,
	0x06ad45ff,0xac6da65b,0xe1cd2121,0xc5ff8735,0x2b0524a3,0x36757b63,0x5a51ddb5,0xf6dd35d3,
	0xfc8b34eb,0x201973fb,0x40efe5a7,0x24ab7081,0x412fc5fb,0x98f3aa61,0x4bef0719,0x11f9689b,
	0xf9d1163b,0x22bde259,0x55014601,0xfff7738f,0xdb35e861,0xd261c62f,0xa23b0111,0x3f7f57cb,
	0x67053867,0x30eb43bb,0xcf2136cb,0x6215b9c9,0xa4d51091,0xbc910957,0x5599ea75,0x0adfa909,
	0x7b257e6b,0x09b322eb,0xb6f5a91d,0x5fb54d17,0xa855a7c7,0x83d5b6e3,0x44eb2e9f,0x1a0db283,
	0x5bb5ffbf,0xcea7e335,0x8a9b2a95,0x380bb7e7,0x6e779bb9,0xc6ffba5f,0x55912569,0x4d771ae3,
	0x3cb7a85f,0x23db6063,0x5eb98549,0x74c7a521,0x1e79fea5,0xb76147d1,0x936db32d,0xe0137951,
	0x80abd8c5,0x4fdf8ebf,0xfe6f5fd5,0x0a1f802d,0x9e21a741,0x38cd7bc7,0x50e3e8c7,0x8751f577,
	0xd89705e7,0x5bc71b11,0x0b5fdd53,0x76bf14f7,0xb1afd0cb,0x0195fb49,0x46d5a38f,0x9323e781,
	0x63f95945,0x33230aa5,0x1da93d5b,0xe3df2feb,0x1be7baf9,0xba8993e1,0xb4a52d5f,0x0dfd7817,
	0xd0d550d5,0xc4075b43,0xe3f37c0b,0x452f3def,0xbe094a09,0x1effdb99,0x8031dc93,0xdccd4063,
	0x7bad5f11,0x1f03a337,0x435ff1f9,0x78dfec6f,0xb7d7a6b1,0x1cc7d0fb,0x55e1b403,0xdf09ea11,
	0x8f838af5,0x9729b14b,0x778bf43f,0x67a1c955,0x8795de2f,0xf4317b13,0xc8930309,0x0ea1cf49,
	0x25d70ff9,0xe20d2cc7,0x329b747b,0x24abe309,0x2a018239,0x58138967,0x71ab057f,0xa0079ab7,
	0x66affe19,0x37c13577,0xbd31a0c3,0x0dab6879,0x3a63490d,0x8dbbf405,0x110983c1,0x222fe783,
	0xa889d9cf,0x72d303a5,0x167183b5,0xead5490d,0x1277ad63,0x8cff9b75,0xad1172a7,0x9e89e157,
	0x90693c13,0x305b8819,0x13f9a465,0x0edbd4ad,0xea838e73,0x202de8c1,0xb2a3938b,0xb905e45f,
	0x31d1725f,0xefe70c1f,0x81efa673,0x76ed5bc5,0xf947cffb,0x041b6d73,0x15231447,0xd0191d43,
	0x2ec31eaf,0x3389d181,0x42f1e9f5,0xeabfcf41,0x9407fa31,0x08178395,0x6e712f37,0x1cb7292f,
	0xd7bfd77d,0x9fd3b287,0x70252b89,0x1c836087,0x4e83d9d3,0x2df5edb1,0x1ef3cb33,0xd24db5cb,
	0x4bcbc7c1,0x1bdbc1fd,0x792b2445,0xc8e92183,0x1afd2019,0xca0976d3,0x6d851b95,0x3ed12141,
	0x98654ef5,0xf12deb2b,0x442329c3,0xd725a49f,0x6a3702bb,0xa3219283,0xa78d4037,0xeab31a3d,
	0xd991a115,0xebdf91dd,0x4db3ce21,0x78e99cc5,0x4b75dbf7,0x1291fcc9,0x40ede575,0xb8e53fe7,
	0x59d1669b,0x7a83325d,0xc8fb7ff5,0x4a657d5d,0x8c79ca85,0x242b5a33,0xf407e427,0x06d9c1e9,
	0xb2275c7f,0xce290173,0xbf9d2a5b,0x724f1a55,0xd981519f,0xb641d7c9,0xe1bbe1a7,0xcc81006f,
	0xea13f43d,0xfa638c6b,0x31bdd4ed,0xc1d54813,0xdd53f8fd,0x99a5cb17,0xb16befd1,0xbc512c23,
	0x979bf3cd,0x1545590f,0x35f943c3,0xd4a97b85,0x612fecdd,0xb1a95223,0xb0fb2cfd,0x6339e62b,
	0xff3d15a9,0x575f85a7,0x1975977b,0x31016a11,0x6cd79df7,0x141ff379,0xf4cd6405,0x48abe035,
	0x33fda8cf,0x3bc568ff,0x7fd5ed2b,0x678ba9a3,0x668f6185,0x29593e25,0x77c3ac43,0x0e997c6b,
	0x375d30b3,0xa0073261,0x8337fe6f,0x337950a5,0x3317113f,0xcc2969af,0x3b3b0993,0x91776d75,
	0x195d0555,0xe4398995,0xd441c15f,0x9a819601,0x55b3ab63,0x69dff621,0x671d0c4d,0x0833567d,
	0x1883f329,0x0aeb2ee7,0xda110899,0x0cd17121,0x1023f2a9,0x22514c05,0x69c7714b,0x24436b2f,
	0xc1cddb2d,0xd9319b1f,0xd24d2333,0x851d39ef,0x82a90e4b,0xe7cf5c65,0x181dc1e7,0x31970fb3,
	0x10bf52db,0xf69b9f8b,0xf1157cc9,0xa89548d3,0xcc072a03,0x9f2940cb,0xcd7ff3fd,0x36a178b3,
	0x8f5b442b,0x0d3b05ef,0x810b3d73,0xe6ef96bb,0x2981160b,0x3fb5db43,0x8bcf09e5,0x14554b5b,
	0x76238d99,0xe9a5309b,0x0351e9cf,0x9a595d0d,0x16d7e71d,0xf3437655,0x1b73b279,0xa6233d53,
	0xcc19a21f,0x9ae9ba55,0x4f8902f3,0x2785b5b5,0x6e4d9673,0x36236509,0x2b49e913,0xe1fbb4c7,
	0x86bd2933,0x929b1669,0xb3d5a67b,0x1da93b1d,0x88a1a1c5,0xf729a2ed,0x70b3958f,0xf855685f,
	0xaa159ed5,0xc4cd309f,0x14d72e81,0x5673a831,0x5d1bab51,0xb7a97409,0xc7952c45,0x741dff45,
	0x689ff379,0xc80d0d43,0x0db1d19d,0x16157855,0xa17719cf,0xab7104e9,0x52514e0f,0x5ac7b125,
	0x435f2c1f,0xf573691f,0x100542eb,0x2b458779,0xe9fbb879,0xd8d70a93,0x99c76849,0x4c47e627,
	0x29d7023d,0x888b597b,0x83f75205,0x0f31b205,0xc9675709,0x38a96293,0xad5b54cb,0xa30dd6f5,
	0x9a0783cd,0xbf6bec23,0xe8258b05,0x058d74e3,0xf0fd69b9,0xd63bb2f5,0x42eff9ef,0x940b2cbb,
	0xc075b34b,0xfaa5c75f,0xf1b5d685,0x3c8b8d7b,0x5081a943,0xef5f0a41,0xd6e1ea8f,0x4eb3a123,
	0x981f27af,0xdd49c9fd,0xac45199d,0xecdb99bb,0x3633b2e1,0x14677f81,0xcc190607,0x1cf99e53,
	0x0a89ac75,0x6ce9ab41,0x99fbd5e9,0x79b1b809,0x6ed5a84f,0x4825d23f,0x8bf5182d,0x834ddef9,
	0x0fb5e197,0x31999afb,0xd377c983,0x90bd2751,0x65abcfc3,0x1feb0a85,0xa659795f,0x60a10e3f,
	0xce25db8d,0x55ebe171,0x27db8f05,0x4a35e6fd,0x447533f9,0xe38b18dd,0xf1a5ae77,0x0e6767cd,
	0xbad9c351,0xc6ef7f6f,0x3cc93d87,0x48c756f7,0x1377442b,0xad577653,0xaabd08cb,0x809157cd,
	0xb957765f,0x5437ce3d,0xae6308a5,0xd9a7d7a9,0xd96f7413,0x8a21c46d,0x95014639,0x65911aeb,
	0x3b9d26b1,0xcfd71fa7,0x2f4be079,0x148569fd,0xbba3dbeb,0x993b6d39,0x1a57311b,0x465b5e4f,
	0x622ffabf,0x2e5f5df7,0xa8a3119d,0xfb954f5b,0x1dd5d86d,0x2c77433f,0x6b1b4047,0xa65fdfa3,
	0x1c0fad83,0xa6e1abf5,0x5a0de529,0x9b89a9b1,0xc243aad3,0xe8272189,0x9e33371b,0x238f0d13,
	0x46bf2e79,0xd2f104ed,0xf9ad40b9,0x2b931b65,0xe9b318d9,0xe31b8ba1,0xd101c56f,0x965fa547,
	0xce3f419b,0xcea1dca9,0xd4214667,0x2d636763,0x73670cb5,0xc6a94d91,0x4765279d,0x31bd576b,
	0xcd151f61,0x5881bf71,0xec8ff4cd,0x8d2d1117,0xfd1d3523,0xee9f1be5,0x8bc3c67f,0xa31f6327,
	0xac3f14c7,0xf1a3f211,0x1c95c705,0xc1a3fc67,0x031ba55d,0x895333a3,0x8efdd771,0x327538a5,
	0x43412345,0xfd9b11d3,0x345954a7,0xebf50dbf,0x0023751d,0xb795fa59,0xc873fc4b,0xe2311891,
	0xf81da0d5,0xe27bb47f,0x1a7bf1cf,0xf7d9ca09,0x8d73609f,0xacb59e0f,0x5609e369,0x8f45b413,
	0xdf55d7f3,0x28d3085f,0xec1d4f17,0xbb7bf6ad,0x82d16899,0xce87b54f,0x1c1fe7a1,0x1125ccd7,
	0xdbe9a799,0x9bb57441,0x1cdf1997,0x17933999,0x167f7247,0xd55fdf23,0xe599b051,0x59c1d505,
	0xbf5d233f,0x68b5376b,0x96e79aed,0x174fb933,0xfd3be765,0xec0b6315,0x83d7d151,0x958b8f47,
	0x69b532e1,0x3fe309a9,0xdad5592f,0x1063bc69,0x8a4b5629,0xcfdfd131,0xeebd6afb,0x4b75aec9,
	0xe96f32f7,0x73d1bb43,0x1fcdb6f9,0xc3014aa1,0xcf71114f,0xf0afa1fd,0x64abca2b,0x7cf17733,
	0x9b8f947d,0x1993d505,0x736d9363,0x79d9cbc7,0xbcebd013,0x90c9d687,0x8a870839,0xc5f35cb1,
	0x4b957ceb,0x28bb3839,0xd9d9ea0b,0x2a1fa847,0x417f4e2b,0xe5019857,0x8badaaff,0x7ceba3eb,
	0x5387663d,0x9b59bea7,0x6db37307,0x9385e907,0x6a6febd3,0x34a9d977,0x3a0544d7,0xd2cb020b,
	0xbbe3beeb,0x8dffda9b,0x801f42f3,0x603bd771,0x83794dc7,0xf993f471,0x2deb149d,0xf3053cbd,
	0x5bad89f1,0x5fc136df,0xb8bb6ae7,0x44f79d73,0x36e3fd3d,0x00114c4f,0xe647a5a9,0x238bca29,
	0xf867fec7,0xd23156bb,0x35ad9881,0x20e5e575,0xad6d07f3,0x86f5ec9d,0xe8776fd5,0xe4d170f9,
	0x66132969,0x295d35fb,0xab95b5d7,0x1dbd7a5f,0xae5ba01f,0x5f912961,0xe05d777d,0x11c5e859,
	0xa7338a4f,0x4bdde8e7,0x85938985,0xcfade79f,0xbf6dbc7f,0x0db73f29,0xc05fed79,0xffdd77f1,
	0x0cc7b675,0xe2bd3c4b,0x054d56a5,0x5569191b,0x44e5b849,0xe7b9f2fd,0xe159cf23,0x9f0b97ed,
	0x5653f755,0x79935571,0x62e37ccf,0x7823fb3f,0xa187f33b,0x36673267,0x22b38655,0x99bd90f5,
	0xd1d9eae5,0x9e715223,0xecf71821,0xcb8b1af5,0x5693718b,0x5517b371,0x0a4b8969,0x74e91c33,
	0x7bdb23a5,0x01e7e8a9,0x28aba131,0xcdd545a7,0x23cb7bf7,0xd19994a5,0xe483fb3b,0xafff0353,
	0x1f5bc88b,0x970907cd,0xf1a18d1b,0x07b3293f,0x27713fb5,0x8c3dfd0f,0xe43f4b23,0xe4f1c07d,
	0x75db3511,0xb36776dd,0x99fded77,0x2c57f427,0xfe496e83,0xd7d9bc35,0x42e1d4fd,0xe8311e5d,
	0x475b9933,0x2f13759f,0x0a5d1061,0x3971f549,0xe395de97,0x99bbea25,0x6049811f,0xe8b1d81b,
	0x8a61996b,0x84a15c5d,0xe1e52075,0x97353c0d,0xd1132aaf,0x69b98767,0xe2db6467,0x8fe53961,
	0x83ebeeb1,0xf1213be5,0x9639c4c7,0x38533861,0x9f095201,0xb2211d05,0xd777602d,0x21bdbe5b,
	0xe77d067f,0x94277d7b,0x9377c0f7,0xba015aab,0x2437584b,0xcfc95c89,0xd181c24d,0x9cabb3b1,
	0xf717a2d1,0x8fc382ef,0x5c45951d,0x83edb3d7,0x55e1e5c5,0x31ffbffd,0x0adbe51d,0xd9a1d68f,
	0xa33f7a21,0x28894687,0xa9c31dd1,0xe8499551,0x67c7e727,0x7a9729eb,0x83e5cf7b,0xac11f49d,
	0xaaf3d767,0xe589fb0f,0x8b91342f,0x43cb30ff,0xec2b2daf,0x9de5855f,0x2381d4bf,0x01ef8c05,
	0xbbb93a1d,0xb057abcf,0x87d54dcf,0x1da1394b,0xf3cf0f15,0x02b765e1,0xd71534c5,0x03ab6b73,
	0x918ff63f,0xf503dc95,0xbb2f1ccf,0x477f8123,0x2df70591,0xa261a779,0xb27dbbe5,0x3437520f,
	0x16f7d447,0xc21f29a5,0xf8c12fc5,0xfd959bef,0x08634fe1,0x28b50eb5,0x102162f9,0x91058f85,
	0x84f7b12d,0xe8bfe7cf,0xea2d91cd,0x06977d99,0xcf57913d,0x1405e89d,0xb0dfef5b,0xb209a3fb,
	0x830f1e6d,0x1c75c459,0x2f956a81,0xd3b71a89,0xcd93715f,0xd523aabd,0xdc1992e7,0xe9b1e021,
	0x473f01ff,0x134f650d,0x7f9d9df9,0xa0a707ab,0x6c593c7f,0xef61931b,0x7fb58bf3,0x64f3051b,
	0xb60b365d,0xa5e50839,0xc7636cd3,0x93971a6b,0x536b835b,0x18914843,0x500fc55d,0x4b3fe499,
	0x82752a83,0xef4524a3,0x4a8b1425,0xdd3b08af,0x890dbb2b,0x59057941,0xe80f767f,0xde8700bf,
	0x4dff81eb,0x6d010995,0xc3396d8b,0xd8c508e3,0x91ffdda9,0x2b8f7d9d,0xe913c32f,0x9b3f2c3b,
	0xc8abb48d,0x1f2b7edd,0x820b8f1d,0x2be771f1,0x9185090f,0x9d7ff561,0x1afd5bcb,0x58552a35,
	0xd0f9aee5,0xa85964bf,0x8e276b79,0xe6d15b43,0x695f2015,0x6eab6917,0x8c311d2b,0x673f4e59,
	0x93ef71eb,0x6d97540b,0xc52d71b5,0xa4373cc1,0xd9cf69f9,0x3163e9c9,0xb191b0ab,0xb3ed1ccf,
	0xad0bb31b,0xb67b3e07,0xfb3d2d6d,0xa9498ed9,0xa1973273,0x6a77b101,0x867d2c21,0xe4d3ea41,
	0x46517c6d,0xcd170c7f,0x1afde6b9,0x05bb6a71,0x9dfb69bd,0xb13dc0cb,0xacd9b1eb,0x7adf7bdb,
	0x3843cc5d,0x1dfb41bb,0x458d4237,0xb3bf28f7,0xeabb4491,0xcf8583af,0x8d0510e1,0xf187a745,
	0x29e135e3,0x58399887,0xf28fe0fd,0xb8070451,0x021bdc29,0xe19f6cb5,0x75e5645f,0xdebbf2ab,
	0xb0b1807b,0x8d65a42d,0x102500a7,0x41c3b6eb,0xdcd9ce3f,0x765f976b,0xbcd9b43d,0x12ed34b5,
	0x70b1481d,0x518f7075,0x22f11b4f,0xcaa71baf,0x123bdd0d,0xaf1967d9,0xddc794d5,0xb90f348d,
	0x3c659d45,0xdb4b21ab,0x6617878d,0x36e5ce07,0xf8038f4d,0x5f9b2a89,0x9b0bc701,0x769549df,
	0x34cfa4ed,0x23a99499,0xeb35187d,0xf52fc9dd,0xc271d039,0x2e3bb487,0x1d8bd81b,0x8b6dfcd3,
	0xe971388b,0x063dfe87,0xba6fbdb9,0x1eb50b9b,0xa4478f8b,0xb3c70359,0x14a9c1ff,0xf20da615,
	0x784d861f,0x61178d41,0xf269235b,0x972b3029,0xeec7617d,0x9b93dd0d,0xd6478b05,0x7f650ecd,
	0xade3b01f,0x34c90711,0xe84151fd,0x2cc114f5,0x31b51ec9,0xc371702b,0x7ec5e609,0x02e910a5,
	0x25376d85,0xc4676abf,0x479d4eb7,0xb82d77e5,0x5b5184a9,0x5bb3f3bd,0x1105d261,0x668735c9,
	0x67cda9cd,0xb5838f97,0x329dbb25,0x3c9d9765,0xd85dd4d7,0x072b474d,0x966b3beb,0xceb558e1,
	0x0da124f1,0x302dc561,0x61e37561,0x07c3d261,0xb41d758d,0xfb2b92e5,0x3ed99aff,0xba634517,
	0xdd3b1369,0xfef77469,0x44913805,0xd1d5483f,0xb8519185,0x1f85e70f,0x80af9477,0x23035617,
	0xeb9bbe2f,0xaef5bd79,0x20473a29,0xdd8178eb,0x8d3bb7f9,0x2e8bdcd7,0x38d199af,0x9c871809,
	0xbc4122bf,0xafb719db,0x312dcf69,0x17fbe4cf,0xd99f7ca3,0xd50f35c3,0xcaa1887f,0x7563e799,
	0x61319311,0x7351fb57,0xc9df07df,0x38f3acd3,0x62bd17bd,0xd2637be1,0x3fff4b41,0xd68591ef,
	0x9aef55a1,0x8e536c37,0x73815025,0xe29d3265,0x2c590603,0x1859a1b9,0x694d78d1,0xe363f4b5,
	0xf8774569,0xd7d1af49,0x0db51153,0xc1abb76b,0x98b1a8ab,0xeb43a255,0xfd6ff485,0xd9ef9e17,
	0xf75171e1,0x895bdfd3,0xee9d5105,0xad4ffe53,0x888be571,0x01f1213f,0xb9c78e3b,0x32976cbf,
	0x237dbf05,0x5f05919f,0x02dd5155,0xc739ea03,0x7b29c68f,0xa5b90a81,0x8237a24b,0xc04f2fd3,
	0x377b854d,0xb75f70fb,0xed9330dd,0x9b9d1de7,0xae491abf,0xd26932a7,0x811db991,0xd08b4701,
	0x3c4f31b3,0xb37be2ab,0x28658ab7,0x412d9de9,0x3e31153d,0x5657f6b7,0x47612965,0x4b3b4273,
	0xa97be5b3,0x56eda3ff,0x2373167b,0x79196e73,0x45a3edbf,0xf253dc3f,0xec61b3a1,0xd2d182cf,
	0x85011747,0xa7c56abd,0x655d4845,0xcf15346f,0xfddd8081,0x79ad3147,0x2e01269f,0xe441d945,
	0x836330e7,0xce978531,0xab49f0af,0xb953d547,0xdea5ee3d,0xf239ac59,0x90a1fd3b,0xf6f92779,
	0x27a3318f,0x36737a23,0x08d7dcd1,0xb88516e5,0xbe3d3c2f,0xb44b0c7f,0x7f25fecb,0x9cefff99,
	0xe3414cb7,0xaceda8df,0x08297649,0x77db3fb1,0xf163f40d,0x8ab1b943,0x6aeddf2f,0xa293444d,
	0x36418a5b,0x8215e92f,0xc9e1632d,0xed09b699,0x6b5dc413,0xd2bf62b1,0xebdddebb,0x2ed7c8c1,
	0xcf2566f3,0xa87f2b5d,0x25212619,0x7841a303,0xdded1efd,0x9c49a14f,0xe0576a4d,0xe32df09d,
	0xaaef737b,0xd53b1831,0xc78bbe25,0x04338cdb,0xd951dc01,0xc99d962b,0x8d3bbb3b,0xfb89500d,
	0x3521f56b,0x9fdbb0f5,0x554346ef,0x2613fc8b,0xec4fd6db,0x2f8f8acd,0xbdeb7765,0x6e5b4bb9,
	0x67bb86bf,0xa273ef77,0x88e7988d,0x3d931afd,0xc4278fc7,0xb571913f,0xe44d511f,0x0c95b8cb,
	0xeb41b5ef,0x999565fd,0x539be79b,0x94e3519b,0x4c9dcb7b,0x7515240b,0x38bfa747,0xa1a97cef,
	0x36b7a5f7,0x8451df51,0xfd036531,0x80b7ea4f,0xcff13335,0xdacdc63b,0xda232535,0x13892e4d,
	0xaf9bae4f,0xc439febf,0x433fdeed,0x8041af83,0x16e5f4ab,0xc56ba35b,0xeddd62c3,0x82a9b38f,
	0xc9effaf3,0x3d61e011,0x7aef5ee5,0x5d338c1f,0x88bd6219,0xa6412f71,0xbfcf844b,0x69f9e3e1,
	0x28392c5b,0x7659b791,0xaf39cbb5,0x4bbd2b91,0x4b39923b,0xa121c70b,0xe259daa9,0xbeeb26eb,
	0xbb77f783,0xb8357207,0xc1bd8877,0x0a9399bf,0x629b0047,0xac5d4f31,0x4e5d8335,0x117114d9,
	0xe32fc5e3,0x2e8554bf,0x8a9d14c3,0x02e7e315,0xd1a72bfb,0xb0c5d56d,0x834107c9,0xabfd1653,
	0x8d5f5577,0x075d9d81,0xf87bacb7,0x6869b47d,0xb99d398d,0xa9af2fc9,0xa6e3fec1,0xb3830485,
	0x568b58b9,0x934d2299,0x3079e8e9,0x594dfb61,0x7a3f91bb,0xc4eb9ccf,0xa5a5aaf5,0x4773c915,
	0xa9b516a1,0x6567f2d1,0xae395e75,0xfe4585ab,0xd1cf81bb,0x82c9638b,0x526b9bbf,0xa1bffe33,
	0xe05d0aa9,0x733ff571,0x63dd3ef3,0xaa81a1c5,0xfd11db4b,0xd61f7383,0x86974cf9,0x36d98e83,
	0x628984cd,0x34e78a45,0xda07f881,0xfbb7be99,0xd74594a3,0x443b04c5,0x4209c6ff,0xd5b35533,
	0xc6b74985,0xc4ed2997,0x4fdbd5b5,0xfa150b8f,0xfa2f687b,0x04f337d9,0xcb253ea9,0xc7c1bded,
	0xf1eb31cd,0x0069042f,0xdaf79dab,0x384d1895,0xde0f7611,0x2295b5c9,0xcecbb551,0xf0f364d7,
	0x37a7cb1f,0xa6e9a359,0x878133fb,0xf3937611,0xf9a7e11b,0x99f7501f,0x805f98d1,0xefbbb6a1,
	0x79edf773,0x7a7f88dd,0x781738c3,0x339954ef,0xe23b71d7,0x7a67a0e5,0xb9c36385,0x3d0b906f,
	0x493d8d43,0x5fbdcf09,0x05dfa899,0xea912699,0x6b8b34fd,0x05b9aaa5,0x1b573c45,0x4c57dfef,
	0x049df78b,0x7db9c8a1,0xe0797c99,0x152d3cf9,0xc7d91bc5,0xd041786b,0x2bff966b,0xab8d4349,
	0xf98bd5c5,0x5dffa0f5,0x2e074a5b,0xda9d6a79,0xa7e79bed,0xe0cdbdbd,0x791bd1d3,0x2323a929,
	0x840b9be9,0x0ca5fbcb,0xab2be3fd,0xac93a203,0x5af94fad,0xd0b176a9,0xb68fdad3,0xd609f0b7,
	0x2e9f3273,0x383d956f,0xcb07f815,0x67459701,0xeecf95bd,0xebbf87b7,0xdebbca49,0x61b1899f,
	0xd249965b,0x51d7e2a9,0xd73db1bf,0x71615d5b,0x4fad315b,0x50495df1,0x5283858f,0xfe0f1409,
	0xb689791b,0xad05b0c5,0x0fef5895,0xdc1b097f,0x6853ea3f,0x0f218ee3,0xf9495e7b,0x9d91009f,
	0xb163e0af,0x9fdbc58d,0xcbbff0b1,0x83255053,0x42032ca3,0x4b997893,0x60edb36b,0x0d2d308d,
	0x475bc791,0xa2e97f49,0x97cfdaab,0x2caf2743,0x247fa93f,0x5b83e18d,0xddd18f37,0x1453957b,
	0xcb6fbcb9,0x714374c5,0x57c3739f,0xa96d6439,0xb60bf551,0xe73198dd,0xaadb4939,0x94f7d193,
	0x7f2383a3,0x2879154b,0x65b9b527,0xf4915da1,0x1b672a91,0x0975160b,0x0969254d,0xab87d781,
	0xb277b447,0x689f48a3,0xb257d55b,0x53cb8a5f,0x17d78739,0x6f9f1921,0x615df3cb,0xcef98a6d,
	0xe3f15b21,0x74450f19,0xe4bde6d9,0x774f21e3,0x2d1b0e03,0x79854aa9,0x611bb18d,0xf0bd5e03,
	0xe08f9929,0x507f2175,0x7a8b78b7,0x99cfbc15,0xbb752629,0x5977dbad,0x1d8527ed,0x9cc5f66b,
	0xe3d543db,0xe4dd9105,0xe7e73691,0xa07df15f,0x21a73b63,0x344525b7,0x31fb8cc7,0x1983c84f,
	0xb7c5852f,0x1b71678d,0xb771887f,0x3b09faa9,0xdcf55def,0x41454ad3,0xe0612273,0x87e9b8db,
	0xd4e17ba1,0x00cf475d,0xaa4b331f,0x03a7515f,0xa91fe285,0xea47d589,0x3117d7cb,0x036bbdb7,
	0x822bda29,0xe4090b3b,0xd817f787,0x9f094f6d,0xa067025f,0xeb9b58e1,0x1301e829,0xc1f97d0f,
	0xf5238843,0x76ad6673,0xcef73353,0xdc5fcf39,0x5b917b37,0x74171069,0x7b817b69,0x3405ed8b,
	0x71cf41e7,0xecd384cd,0xb38d809d,0xd55dcbaf,0x11dd2f47,0x45098029,0x867745e3,0x2481f655,
	0x6aad3791,0x1d07aa95,0x60fb55fd,0x0e350039,0xb90fc549,0xd24514ab,0x96452871,0xd8e10f19,
	0xa0c1ae39,0xa061d495,0x88e5a68f,0x959788c1,0x25674877,0x621fc2fb,0x73d1d06f,0x3115dfff,
	0x438b9f5b,0xf26d5815,0xd36981ed,0x24b981af,0x29a7c88b,0x2d65a89f,0x6e7757b5,0xc78de1b3,
	0x111158f1,0x914182e1,0xff2db431,0x3f47a7f1,0xb711f9bf,0x7f6baba5,0x7c1fe49d,0x1141fd5d,
	0x75d31d73,0x1d6f3b41,0x014f65f5,0x5379f8ef,0xfd69d4cd,0xd6031a95,0x59274a01,0x7d9d2ca7,
	0xacd1c3db,0x7a07a001,0x2575bc51,0xd9fd5291,0x8aef36ef,0x017f4c79,0xa871a73d,0x969519bd,
	0xdf8f57a5,0xec9ba86b,0x2dbf78e1,0x76071343,0x6c6581df,0x44b140db,0x13610829,0x209dbf47,
	0x460fb8c9,0x3d3fc449,0x72cd99bf,0x1549b9ef,0x4d0f3bd7,0x74eb3fc5,0x69d9051f,0x3aa5086f,
	0x46d33bc3,0xd6857be3,0x03c5f985,0x0ff385ff,0x96adaf91,0x19ff79c1,0xc23962f9,0x7e1f70e1,
	0x96db498d,0xe57d1005,0xc647ef4b,0x48bb175d,0x91818c47,0x8e3fa7db,0x9965b313,0x1effa4c7,
	0x59adff9f,0x79b919f7,0x9675eead,0x4ccd0e73,0x844f85b5,0x1e7dab99,0xf2bff345,0x0bb320c7,
	0x4147cff3,0xa54d2b85,0x66f127c5,0x73e1ac2b,0xd457f411,0x2a0b2f09,0x78272de9,0x0d31d20f,
	0xae2d2105,0x9cc96ef9,0x60dd272d,0x002571ef,0x255b7417,0x42bb44b3,0x99ff19d9,0xe6e9b649,
	0xcf61edcf,0xd73f471b,0x03dd75fd,0x3e4dc1a7,0x799f8701,0x4cdf07a1,0xaf2dba71,0x76cd7b9d,
	0xc26565c9,0x2e43ef37,0x460f39d3,0xa58b7dc1,0x51e33289,0x9f473b5d,0x150dff89,0xd54f20b5,
	0xb3398ced,0xfde71b17,0xb419d4c3,0xf78fa923,0xcd6ba0e9,0x2349ebf1,0x4f87657b,0x756394bb,
	0xfc63dbb9,0x44bb9703,0x9119856d,0x608d0739,0xc9f5c0dd,0x74b50de9,0x28f99523,0x4477575b,
	0x46e1df21,0xc3d1e7c7,0xf6b506e9,0x9737bbed,0x03c7e59b,0x01db1e4b,0xd24503d7,0xca8118bf,
	0xaa37d8a3,0x1ebdeaab,0xf50b30cf,0xfcbdeba9,0x35a366df,0x2b91c2a5,0x02cf9375,0x49f3598f,
	0xcc675e39,0xfb91757d,0xb2c1973b,0xbcd35b57,0x38c740e3,0x652568ff,0x18793257,0xdfbb0af5,
	0x01f1fa5b,0x22ddf681,0x8cf72ac7,0xedab1061,0x24f9b463,0x546be7e3,0x37a37b53,0xa34d2e9b,
	0x6ddbcc05,0x9fb31487,0x374fd88b,0xaff7f0af,0x707be695,0xf1b71e5b,0x6b3155c7,0xc69d76ad,
	0x21a326af,0xdfa74ed5,0xdbeb2a25,0x4ee762af,0x100b8135,0xa7d793f1,0xc483958b,0xb61be5d5,
	0x3d4d3255,0xd2c99d37,0x3b6de5ab,0x602fed47,0x96ef527f,0x741f18b1,0x7b7d9afb,0x38b96f39,
	0x0f5b8b6f,0x0bab0ff5,0xccf7adb9,0xe3ffd7e5,0x56e7ed29,0x06636521,0x0e81f2ed,0x8feb9689,
	0x34cfe2f9,0xdf616fdb,0xde2ba167,0x650dca6f,0x8037486f,0xe0f1ba4f,0x626ff6bf,0x979f0fe9,
	0xb92b9e6b,0x857dde33,0xb32bfc53,0x18876d51,0x419f600d,0x789d81c3,0xe2ab6c49,0xe64b6007,
	0x366f77c1,0x380f74c5,0xa69bb693,0xfe1f0975,0xe861d439,0x54b9ed87,0xa11525e7,0xecdf7c0b,
	0xf5211d73,0x53a9e5dd,0x499924c3,0x000b2845,0x004189af,0x2f179825,0x7611a26f,0x16cd69a1,
	0x0c3fd27d,0x775f1c45,0x83cb97fd,0x12f933ab,0x737f49ab,0x140924a7,0x207fad3f,0xea09def1,
	0x814d0e57,0xa4c3db45,0xb34ffdd9,0x561d160f,0xaadd61e3,0x8261de99,0x65c3fe2f,0x2701e2a7,
	0x684d1cfd,0x5fe35ea9,0xcccb8073,0x3329da5f,0xad9f4495,0x8b715a01,0x31bfd99b,0xe8ab6be9,
	0x03bfbee7,0xcf57fab9,0x7b5f2665,0x7e4d4c01,0x41852877,0xf30b136d,0xb6d3b05b,0xc4770267,
	0xe4a9c911,0xdc2bbc41,0x40ab72c9,0x963d96e3,0x0ad1a8c7,0x4f810fe5,0x8de3bfc9,0xea575e45,
	0x0a89c4f3,0x51f7088b,0x94d50539,0x8429e76b,0xac47653b,0x29a37cf3,0xd64fb1bf,0x44bf0831,
	0x03639089,0xfec73d5f,0x067d39cd,0x1bc70a85,0xe725a211,0x1cc750a1,0x55fb3c99,0x989df955,
	0x0bb9fe4d,0xd331510b,0x5ac5c921,0x1b450d9b,0xbb33e7ff,0xf6bde979,0x9947c32d,0xa5673b59,
	0x2e8d7535,0x02477253,0xad51684f,0x4b57de97,0x86ada443,0xd7d5ae85,0x1317f4d9,0x450d8867,
	0x656190c1,0x2199a887,0x903f68ef,0x9f2debe3,0x2659c893,0x52e5af51,0x3ccd6d77,0x8c01eb29,
	0xb835c0e7,0x4939736d,0x2c33591f,0x547bc467,0x15776b2d,0x8d3b43e5,0xb649555d,0xe9375ecb,
	0x5d8dea21,0x33bb6b4f,0x604fa375,0x1373b791,0x8dcb66c7,0x5eadaccb,0x65ef0169,0x461d6ef7,
	0xda6b056b,0x5e2fe0f9,0xe2372f0d,0x0ec77547,0xa795fa9f,0x7189b30b,0x989f92f3,0x26a9d7d5,
	0x2251c03f,0x28297db5,0x5e09ff7f,0x23a7adf7,0x79976a6d,0x62a54835,0x21bd97d7,0xc94b260f,
	0xb7411c95,0xf3b9e34d,0x966bd4e9,0xf9c7b287,0x39159e69,0xe14f264d,0x7b2baa6d,0x46f556cf,
	0xc9bd10e7,0x45734c09,0x847dcbe1,0x23591463,0x59cdc351,0xcf5b6fdf,0xe549118d,0xb31b77c1,
	0x58c52831,0xe4672ab5,0x77e1fd83,0x3d0d4575,0xae07ea5d,0x611d4ff7,0x86fb6097,0x3bab470f,
	0x51dd21ed,0xfa29ca99,0x36b71f69,0x0e173827,0x867fa945,0x3d639a1b,0x8da1175f,0x491bd35f,
	0xb1079213,0x32c9ef81,0x1da523ab,0xa829ff63,0xd27bba47,0x9d816a59,0x4d1f4243,0x9e5b1bdf,
	0xa0c5811d,0xdcd975b7,0x3fcbd8e5,0x87756e91,0x3fbb9c1b,0x6d49c539,0x5fd51a1b,0x78dfb039,
	0x9a190c09,0x096df205,0x86cb8a31,0xb2abb99f,0x5a8331fb,0x6b0d37c5,0xc6a7a441,0xb0955095,
	0x8483044b,0xac1751b3,0xd2c99f29,0xdaff14f3,0xad93639f,0x479f7787,0x08f75291,0xd7f38d9d,
	0xd6098fe1,0xbae77a8b,0x1a633be7,0x7c23557b,0xe22dbd45,0xc651028b,0x54a5a361,0x5be9687d,
	0xb329c945,0x4e6feadb,0x8abde103,0xfc47909d,0xe0130fa5,0xdcf5bf57,0x9e15c191,0xa3e9f2dd,
	0x0ee75f6f,0xc1c35969,0xa77b0b99,0xcc1fbc45,0xed890ff9,0xd3dd9cf9,0xc0272475,0x31e5eee7,
	0xcac535db,0xd273557f,0x6abbd543,0x86dd4edd,0xcf4ff7f9,0x65db32f9,0x9c3f2fe9,0xc24f6f47,
	0xd6c50481,0xc091e6e9,0x65239419,0x1231df4f,0xe8a925e3,0xe03f6161,0x3a3dd449,0x6c1b7727,
	0x5167f7dd,0x6eb32df1,0xddd17ab9,0xbe4fc505,0x5b55bc6f,0x42dff0bb,0xe8852e6d,0xc0b99a2d,
	0xa7af50e7,0x81e50361,0xf26b3839,0x65e9b7e9,0x279b42d7,0x600b3211,0x5bf927b1,0xec1b9c87,
	0xb521051b,0x81bd9881,0xb7119835,0x8e317063,0x4c3744d5,0xfc939eed,0xcff915eb,0xd4b312df,
	0xe3bb5e71,0xf84d171d,0x566522c5,0x86d74761,0xe66ff2a3,0xefcd795b,0x26695b79,0x3b75025b,
	0x4bff9b65,0x9225417d,0x3187bc87,0x8a0fd649,0x5203c0fb,0x43896be1,0x07a90735,0xdbcf80ab,
	0xd4f38eef,0x3e57126d,0x001d4691,0xdc899707,0x49350917,0x5417298d,0x029d7475,0x8bb753f3,
	0x5417408b,0x4e775d37,0xf0493e7f,0xed7b8407,0x04c9a8af,0xf04d0de7,0xaca7eb17,0x5b9d92e1,
	0xad6b8c31,0x96956da3,0xc6a95e6b,0x7693b82f,0x5bffa201,0x7979bcf9,0xc1a73f73,0xb675449f,
	0xf373c25d,0x8d45a7fd,0xfe613ced,0x9c050eeb,0xe49bbbc5,0x036fc34d,0x43ff7263,0x81ad00d3,
	0x87314807,0x6b97290f,0xe913ed23,0x0c81c423,0x12db2135,0x748335ef,0x9c955143,0x3d3b8fab,
	0x382736ab,0x4d1f6621,0xcee39ea3,0x213b1445,0x5985020b,0xa5835265,0xbac715e9,0x238f89d1,
	0x6455fc43,0x4fedccff,0x0e6f3d87,0xfde5dc39,0x49db3281,0x81c31ebd,0x347706b3,0x499bf86d,
	0x1841fb45,0xb49363f3,0x3cdd126d,0xb0b13967,0xb39dcb51,0x2715097f,0x6609167b,0xbed1f529,
	0x2ee92ab1,0xfe2569c5,0x45cb626b,0x524f29bd,0xc50dc9b5,0x05cb89b3,0x925d8497,0xad254a31,
	0x71d1b5fd,0x1235f5c1,0x8b5f0f1d,0x25f32ba1,0x2aedaf67,0x00b7bee9,0x02d97ce5,0x7905122d,
	0xb8fb9d23,0x58d397af,0x0639369d,0xb94fddff,0x308122a3,0x8d2b1125,0x2759b7bd,0xe1675849,
	0x0ae9549f,0xdc91f7db,0x657bd385,0x0493a041,0xdf898e1f,0xd2f9d0f3,0xb64519fb,0x1fbbb82b,
	0xbc9d656b,0x6a83770f,0x2ec75ced,0x8a733251,0x2047c117,0xcc73d75d,0xcc7954f5,0x07f5fe03,
	0x91970cff,0xb239ce95,0xde3f6671,0x78215499,0xd97f8f45,0x666b25ef,0x0d5d8689,0x2883c675,
	0xdbdbdd55,0x65c7b035,0x0685402b,0xc54f6803,0x107170e3,0xa03386b1,0xc2cfd90f,0xea5b1eaf,
	0x9beb5ce9,0x59bd6639,0x70bb96b5,0x542d0df7,0x08df22ab,0xab9d2c2d,0xfd332363,0xb0ed245b,
	0xa0c9a6b5,0xa52f736f,0x3c831327,0x116fc863,0x650d45d7,0x0cfb516d,0xb36988db,0xfa2ba5a1,
	0xa7f70a31,0xc1ad331d,0x0001fb1f,0x144599ad,0x45bb0023,0xbb1dd9fb,0xe2d31955,0x7e87c12b,
	0x7d77ab57,0xab4b790d,0xe7d3d0b3,0xbe65a4c3,0x6a2b9bc5,0x3f59f1e1,0xaf57712b,0x50f58625,
	0x1bc922a3,0x0099318b,0xd71ff27d,0xdbfdcd0b,0x50212779,0xd57fadab,0x83535933,0xfee59437,
	0xcbf11d0f,0x22a90161,0x87833b9b,0xc3bf5671,0x53dd1679,0x8bdfaa5f,0x2fa966cb,0xb049bb8b,
	0x4571fc13,0x550fe5d9,0xa925a3a3,0x76e1855f,0xd021e07f,0x634fad8b,0x0bbd9bcb,0x47939ccd,
	0xce4b75ab,0xdddbd4bb,0x02a5deb1,0xc1113ebf,0x3e31a1c7,0x6f1d4537,0x1571068d,0x81b54925,
	0x5b01344f,0x25a15c53,0x9123fd5f,0x5883a7f9,0x55cdbb07,0xf51d67ed,0x112561ed,0x1623e23f,
	0xae9376fb,0xd7714369,0xa8450cc7,0xfde7c6fb,0x2d37717b,0x8da314b7,0xa9bdb543,0xd6cd3a43,
	0x7a87b127,0x00df2949,0x122bb681,0x9c73222d,0x59338edf,0x437df31f,0x9099f469,0xd02373db,
	0x7edb2acd,0x31fb25bd,0x2f77e0a9,0x69d36077,0x0d010169,0xb3fff331,0x9d9d9fb9,0x691da233,
	0xaa13a06b,0x9d59690f,0x174b4dd9,0x063fe945,0x3a637bd5,0x2efded73,0xef2b640f,0x832768f3,
	0x3931e2f5,0x3809dc07,0xb74b3d29,0x9c658483,0xb19d155f,0xd6c542f3,0x0a23bac3,0x9a379c45,
	0xd7b577eb,0xd99dbfef,0xf3950a37,0x017bfa97,0x416fe9bd,0xc02b7d39,0xf9e989af,0xe4bbe0d5,
	0xbfa53941,0x5c294e93,0xc6cdcd19,0xd52db46d,0xd71bb92b,0x1281ee4f,0x705dc32d,0x73a94bcd,
	0xd97ff577,0xbc3f5a3d,0x6217fa6b,0xa1b35b6d,0x9e658865,0x279950bf,0xe5e30619,0x527302d3,
	0xdc470f81,0x38efedb7,0x4d110347,0xfbbb7985,0x218d40a1,0xabc56793,0xb95b3dcb,0xa707dc15,
	0x6d7f1edf,0x73cbec49,0x85e1f545,0xa279191d,0x69554f9d,0xbdd79e57,0x5029421d,0xd1dbfe3d,
	0x41298f87,0x90e7b1bf,0xa1271a81,0x9f9d651d,0x1d01478f,0x0f21a911,0x362f776b,0x8ddd8073,
	0x39c741f3,0x56d3b263,0xea039995,0x675d48f3,0xa2517f35,0x0375244f,0x3dcd6e8b,0x10830a61,
	0x88592b1f,0x4ea31afd,0x821b159b,0xf8671085,0x3d87b1c5,0xd1253519,0x9fe784db,0x29bd7433,
	0xcc65f483,0xe3e770d7,0x818f4e2d,0xfbed083f,0x31659efd,0xa10128f9,0x1bdd8435,0x63ff6691,
	0x33e99c1b,0x84b331bf,0x1701bf63,0xe5a51d0d,0xdf2fab13,0xae5f15f9,0x179342ef,0x2437faa5,
	0x9b69145f,0xc19773fb,0xa79341d9,0x13bd7c55,0xe6a77ec5,0x670f7aa3,0xbf6943e7,0xc9db5a1b,
	0xade5e44b,0x6da58657,0xeee7aaa9,0xeee73401,0x460ba749,0x8b61de01,0x26455675,0xcedb5f1b,
	0x04e3c759,0xbe71901b,0x1f1f6b6b,0x0a59d27f,0x7a21365d,0x4e2b6f9f,0x65833673,0xe7ab3451,
	0x48614d81,0x6c0d3113,0x00df323d,0x43c106b7,0x9e296237,0x74bba785,0xbd092c3d,0x2339f4e5,
	0x4ee57b3d,0xd1072189,0x134589b5,0xe3534011,0x8be72595,0x76e7e63b,0xb339acab,0x0afb4c81,
	0x3d6d6989,0x0a77d245,0xabf778ef,0xbbc14e7b,0xfb9bdfad,0x9efd14cf,0x34f5f917,0xc2df1751,
	0xa77de5df,0x17eb0c93,0x17132383,0x4a3b025b,0xa407f43d,0x29d344cb,0xb59bbf5b,0x295b01fd,
	0xaf151237,0xfb75923b,0xb73f698f,0xd675cc9f,0x5a6d6b7d,0x66b75035,0x4f13b9d3,0xf76129b1,
	0x24bb050b,0xd9a9bd8b,0x259987a9,0x92a15ead,0x32919225,0xd77d7999,0xe1bb4f57,0xe05fbc15,
	0xa76d6957,0x19972147,0x51c7b6ed,0xbb6f4a71,0x9eb59973,0x50790c03,0x34773341,0xb24b9753,
	0xc4b11e95,0x84d128bf,0xa1e9ccf5,0xb813a255,0x8f97371f,0x1879faf9,0x14a7056d,0x7595ea17,
	0x1885d8bd,0x676bb7b9,0x12a1dbd9,0x3a3f9941,0x947d4561,0x08d18289,0x762ff231,0x8d2fd389,
	0x6d6dc049,0xaff7ca81,0x5711d235,0x5e2522a3,0xfb2762f7,0xad53c73b,0x936f526b,0xd68b0353,
	0xdc691235,0x0f8515df,0xf8db1b23,0xca759263,0xefd99319,0x64517619,0x0d4b4b75,0xc99b59a1,
	0xecffbffb,0x19a7a71f,0x78213e3d,0xd0633ce9,0x9d51dd81,0x7e9d64ad,0x0b256f25,0x98d3871b,
	0xb52d0f93,0x6471840b,0x6b857f9d,0x8b9f1723,0x4cd7ee67,0x5f893103,0x5add5bd9,0x5123aced,
	0xf9773b79,0xa8734aeb,0xa02b7fdb,0x025f5677,0x8627b689,0x9ce7e1a1,0x90d75c69,0xf9fdfcbf,
	0x4cdf12a5,0xe0c1d28b,0x39b1dc13,0x455110d1,0x2f870b1f,0x1f098595,0x27f3082f,0xb55358bd,
	0x30e79893,0x6aebca35,0xd23dcddf,0x8fa7dc9b,0xadb745e3,0x40c1d467,0xa195e307,0xdf99f38d,
	0x3591a53b,0x270559b1,0x9a6dcb57,0x671770bf,0x03fbe50f,0xef5fce21,0xa59dfd49,0x2fbdf05f,
	0x195f8519,0x979fc14b,0x79672719,0xbbcf44a7,0xf4112b5b,0xcab95b4d,0x226f93cf,0xd73502d7,
	0xe9519925,0x01cdf9cb,0x2ccbb03b,0x0883303b,0x1e3fc005,0x451fecf5,0x6cedaff3,0xa1f10f23,
	0x20ebf6db,0x8d1f547d,0x68b95259,0x72630be9,0x21474ec5,0xc3611ca3,0x6077c791,0x1663c9ed,
	0xca2f0833,0x63a71b2b,0xf7d7b58d,0xe9255097,0xba6927d5,0xbcd54c63,0x7ef15d01,0x957f585d,
	0x9d9f2ba9,0xd1f9301f,0xdb45de6f,0x46f7b7b3,0xe567dfef,0xdb4b46bb,0x10bb9f1d,0x7ab5f01d,
	0x223d5435,0x6727ae21,0x6aa5ce1b,0x708bdb23,0xfc83f04d,0x1b13deb9,0x44b90941,0x3bf77757,
	0xcd89a953,0x14bf887b,0x7419222b,0x7517d553,0xd88156a9,0xeb038fe5,0x504d0343,0x89b724b7,
	0x238726fb,0x4ed92afb,0x5c43b4b9,0xae49e12d,0xf0a1353d,0x4c691e49,0x8f578181,0x6ee71f67,
	0xd6b93da9,0x2c0119e7,0x3e473c5d,0xe053fa1b,0x7aa772c3,0xf319366f,0xa43ba4d5,0x70f91f0f,
	0xe8217255,0x854f9209,0x0bc3ec35,0x59eb7c07,0x8ad15a75,0x65670d63,0x97d95a95,0xafe10bd9,
	0xc741fe7b,0x164f28af,0xacdb13d7,0x143fc35b,0x33e53c0d,0x1c2100ab,0xf995fc9f,0x060f9e6f,
	0x721b7013,0x9d176b9f,0x2033bf5d,0xd303ccff,0xa7250bc5,0xa29b3655,0xff4ff14b,0x2875fffd,
	0x952f4999,0xfa398123,0x9ae95765,0x4469d661,0x54510257,0xb6a73ce9,0xa56b4b73,0xc6856a2b,
	0xab83a207,0x50c5c807,0xa8a34105,0x2121fd67,0x09ab3cfd,0x6897ab6f,0xcecb6a73,0xaa33c725,
	0x1e95c4d5,0x264d7795,0x4b817dd9,0x4c5fe07f,0x13f55d71,0x3b3dc175,0x64cf9a23,0xd7ef5193,
	0x6669d1fd,0x82e53f97,0x1c254bfb,0xf3d53e8f,0x5e7329ed,0x43eb0705,0x7759b2dd,0xaeab34a1,
	0x297f5dfb,0x111fe855,0x69afc605,0xafb39703,0x92e52d2b,0x4a73eca5,0x5ccfb97b,0x07d92bf7,
	0x5cdd11c7,0x3e0bf29b,0x59c5830f,0xa2adc9c5,0x398d5665,0xe9276b61,0xd20f7f59,0x576b23bf,
	0x64014add,0x593b37b1,0x088736b5,0x99f5b73f,0xd92f9955,0xacd9a4c5,0x1a7b424f,0xcbd5d8a5,
	0x30f1bb37,0xb4c38963,0xa8995111,0x2d3be059,0x170b8e35,0x34db82d9,0x1ff74cb7,0x6e0577d1,
	0x642b094d,0xc53351fb,0xa3199ebd,0xdeb50681,0xd6e311bf,0x52ff5827,0x92e5956b,0x41713eed,
	0x6cb3701b,0x419d3441,0xb7abe8d1,0x3b0fcb9f,0x5afbe52f,0x2b977fb9,0x0a255fc7,0x64091c25,
	0xa8095f19,0x4397ab81,0x1c7194eb,0xf981521b,0x64134e3b,0x5573fd19,0x231bdba3,0x2e414e21,
	0x82331a41,0x672dab85,0x9e0f4521,0x1bb9dce1,0x516db71f,0xf9e91c51,0xa1a7c559,0x5307040d,
	0x95af5a0f,0xeaf54095,0xbfa3780d,0x0deb6f5b,0x40cd4e95,0xf4c911ed,0x902d05c5,0xffd1fd91,
	0xcb83eb7d,0xd0012f7d,0xdad328cd,0xc6c96d75,0x2e73a7d9,0xf4639af3,0x5f8d523d,0xfc8f2ad7,
	0x7b2d5003,0xf9df9585,0x3fbf6ef7,0xe7853b93,0x15215aa1,0x998d9cf1,0x072bcca1,0xcbb34c8b,
	0x8aaf5d9d,0x4ea78879,0x55071ea7,0xdbcfdea5,0x0e1ba329,0x9795c5ef,0x24e9a345,0xca2f93d5,
	0x8e8fdec3,0xd6e7b6a3,0xb7d16877,0xf9db9c13,0x7121022b,0xd44f2c77,0x1d27b105,0x4f774261,
	0xe9cd326f,0xddb106cd,0x5bbd7981,0xa25999c7,0xf475dce3,0x880fef93,0x3ac91d3d,0xcd7b4a57,
	0xede9ec1f,0x1099383f,0xaaed1b5d,0x607d7e29,0xccdb1d07,0x5da3d6cd,0xcf31fbc5,0xf0adee61,
	0xfae773c7,0x9faf82c5,0xa6035427,0x09f91027,0xcd93d0d3,0x925ff231,0x523decf9,0xbfff61ab,
	0x9f49a5e5,0x5d8536a7,0x04210679,0xdeffd727,0x885fcb03,0x16173a45,0x8255bdaf,0xbce367dd,
	0xb8117373,0xdf2f5cb1,0x52e9916d,0xaa3fbb15,0x6d8342cd,0xab193017,0x84570745,0x034df521,
	0x90c181e9,0x9c3f562d,0x167f709b,0xe0eda45b,0xebbf73ed,0x06397d2f,0x03a7cf93,0x69adce23,
	0x0359cb43,0x0ec57ce3,0xe981dc1f,0xc2bb1be3,0x90553e9f,0xeec99397,0x522528f5,0xa0f5280d,
	0x985f3df9,0xd353c31f,0x9d136893,0x79d9eb17,0x2709c799,0x5e9b4dd9,0x8835d241,0x54974885,
	0xa6d15d07,0xc8fd53a9,0x58d9a711,0x3afdbbe1,0xda1b1819,0xa2018eff,0xa4b7d6d5,0x4a8525b9,
	0x7433dfe7,0x315531cf,0xbaf3c531,0x6555b8ab,0x524dbdd5,0x77cde295,0xad0f2e8b,0x83330653,
	0x5487528f,0xd069d957,0xf8012d0f,0xa2932c5d,0xd6e36b09,0x31511ca1,0xcd1f5db9,0x5991217b,
	0xca4db57f,0x0cd1de8b,0xfb292545,0x06eb2265,0x6d9b9671,0xd25ff9b1,0x7747153d,0xa3113edb,
	0xa68b1dad,0x0f998e37,0x860b70ed,0x310f06a9,0xfabd1b43,0x3149becd,0x846bd26f,0xcfa5569f,
	0x28bf5493,0xe4598da5,0x50c9efa1,0x6a314595,0x6105d93d,0x16dfd97f,0x53eb7f29,0x09bf316f,
	0x1eed782d,0x991d7a9d,0x2a053d79,0xc601ec13,0xa1b95495,0x5e777fd1,0xebab11c7,0x56530875,
	0x05979af3,0x5e7b8b6b,0x16e15311,0x42b3478d,0xfc995609,0x15e1504d,0x180d2d21,0xb4d1255d,
	0x27bf63e1,0xa7852ed9,0x72ff2583,0xe8f985ed,0x0fe98acf,0x9d6df1fd,0x8bf1c091,0x3f2b824f,
	0xbee5ae71,0x49cbac2f,0x10814667,0xec05559d,0xf86924a5,0xc7f1b46d,0x00b9a7f1,0x49d369f7,
	0x130f2a99,0x9d5fc339,0x580983db,0xc9878587,0x715b79c3,0xfabb2fa5,0x564b4b9d,0x83bb177d,
	0x9abbfcd9,0x9cd54c41,0x68bb8875,0x69b3a513,0xf483a4e1,0x4da1e42d,0xb303406b,0x1657568b,
	0x1aed5e27,0x053dd80f,0x38357b51,0x3f39a42f,0xda21253d,0xaaf1db13,0xa3c9e7bb,0xc597234d,
	0xc7273bfd,0x762b4fef,0xb29da007,0x674f7341,0x78f77e8d,0xef8145e1,0x3bfb0f61,0x0fed4a6b,
	0x616bd857,0x91af95ab,0xda91f6b5,0xc9a3a335,0x4647d90f,0x0a9f1e9d,0x357b91bb,0x4e4b0911,
	0x5a3969af,0x1c5d238b,0xe937dbf1,0x38670575,0xf5d5a17b,0x1e1fc7d3,0x10adf5a1,0xd423ace7,
	0xf097bafd,0x1d45ac5b,0x6e2fa8d7,0x90514beb,0x99e12909,0x9e55ac8f,0x34730e6d,0x0f693417,
	0x5203cbbb,0xfdfbbb63,0x6f9b5301,0xd88fa901,0xc32f4577,0x720fe057,0x0e2d9bf9,0xa88ded4d,
	0xba816fe7,0xaa8f546f,0x8a1d0c87,0x62d56fa1,0xa0fff0fd,0x12a1bf39,0x31bfeaa1,0xa28117b1,
	0x9493eff5,0xb19393c9,0x10d7e405,0xeb53b335,0x2113ea53,0xabdd8dbd,0x7989733d,0x7ab782ed,
	0x993ba8e3,0x641b4e3b,0x2d6b6495,0xb8bfe7a5,0x0fad54b7,0x3c1518ed,0x266f7b27,0x49232f2d,
	0xeff9ac2b,0xf5b9b10d,0xfffb35d1,0xbc45815f,0x379157e1,0xb41b5653,0xffd3b43b,0xe033ed1b,
	0x4ed35fc5,0x9c7de209,0xbf29bbd3,0xb19d9549,0x81ffc00b,0x174103fb,0x7395dcd1,0xecddfddd,
	0x1a471e2d,0xb0f99f7d,0xd817b733,0x3ef578cf,0x16bb9ded,0x9b59486b,0xb6195fc3,0x1691b321,
	0x8559d65b,0xce41e02d,0x0e69e50d,0x150161dd,0x7c05e6c5,0xc8b552b1,0xe23ff46b,0x1f410f11,
	0xb18babc9,0xf1e57369,0x9c3d9efb,0x0ef306d9,0xb69f144b,0x9a27fa55,0x196b3ea5,0x03616455,
	0xcedd9675,0x9bf9a0f7,0x52397b17,0x527d3eaf,0x69cbc4b9,0x9cff5f61,0xa37f6ec7,0x19e1f617,
	0x3bd502d3,0xef0dc923,0xb77bebf9,0x6fcfa0c7,0xf74d5ac9,0x11138a5f,0x0edbe1b1,0x34319803,
	0xa57171e3,0xd03304b7,0x29a9e0bd,0x819d250f,0x9f659db5,0x08b30c59,0x5061c0b7,0xbe474e41,
	0x27351919,0x06ffc4fb,0xfce364fd,0x4d17c3ef,0xa0d75935,0x88af9ed9,0xe375a1b7,0xde95ed7b,
	0x6b238275,0x5d8373bb,0x9bcb40d3,0x61f1164f,0x58e3fd87,0xa85dc3eb,0xe9f92709,0x9609badd,
	0xc9bd2c6b,0xc04f133f,0xa78398d7,0x3a5df59d,0x634b3f63,0xb18d6615,0x4c4f9f87,0xe0190c0f,
	0x6a0529fb,0x5e75de53,0x17ad8e25,0x5b0d1bbf,0xba51b803,0x408f7865,0xd955a68b,0xd2b5e73d,
	0x617bc299,0xc989e841,0x5a6bde57,0x7331c321,0xd6b98521,0x64399663,0x6673c3f1,0xbe4fa30f,
	0xd4251245,0x159bbcd1,0x745f8387,0x7c7d46ad,0xcfc3e8f7,0xbdd9a419,0xef870c11,0x4dd986af,
	0x1481a975,0xf93f004f,0x20ab544d,0xdb23c1cd,0x7b31ea3f,0xa1436e11,0xb6f5bfc5,0xa6c769c9,
	0xc3932d23,0xed850f85,0xf0f3a3c7,0x7dd5b06b,0x8d47f433,0x34cb4957,0x659dec69,0x89075485,
	0xf0ddf6cb,0x4e019fbb,0x6d55e18b,0xfdc38ef1,0xb8c5768d,0x913fb371,0x2ae30bd3,0x6f0f1f8d,
	0x3a5fb465,0x78c35ebd,0x347539b5,0xbea17a47,0xceef8587,0xe1f3f26d,0xdca7a463,0xadcf140d,
	0xec9f086d,0xee5d92d5,0x1b7734dd,0x0e9fcfdb,0xdf8379db,0x84b9b4d1,0x174de8ed,0x94bb8baf,
	0x229b29db,0x71e3bacb,0x4dfb581f,0x4673cd93,0x58c790c3,0x29e3b1ab,0x5db758cd,0x8dc19099,
	0xe5d7842b,0x28e72deb,0x6e21c515,0xe94b31db,0x277d8bf9,0xf4434883,0x39455fdf,0x3d577d79,
	0x4e555757,0xbb79bbfd,0xb48fd9d9,0xc4d9db9d,0xd6e551b7,0x992b2165,0x59dbf67b,0xa26d9d79,
	0xa29757d7,0x742b4d4d,0x1065d105,0x11536a45,0xb0c18cb7,0x806dccd7,0xb5d9417d,0x3675cc41,
	0x779d4ea5,0x601182a5,0x474561b1,0x9167ddb9,0xdd534c33,0xe45b63e5,0xaa23323b,0x0d6115fb,
	0xd0edb93d,0x6ebb554d,0x15515f79,0xb2493663,0x835fa3e7,0xf1c7281b,0x1a192693,0xf5a55753,
	0x40856999,0x923db713,0x4d2b5a77,0xaba91531,0xe8254c09,0xe8032381,0x8f9f88dd,0x9831dd71,
	0x06e92631,0xdf27323b,0xf7f53f45,0x9fbb5b8b,0x8f674155,0x38e1c8a1,0x5b176ff5,0x987505ff,
	0x331b49ff,0xac8d8995,0x7553f6fd,0xbb31cb59,0x5b696505,0xa8b39285,0xb3613f33,0xb469df29,
	0xc29d647f,0xb3ff5867,0x9b630737,0x553da709,0xaceb1cd3,0x6e49a4b7,0xd5e14671,0xe479c797,
	0xc16fd9ab,0x3191b27b,0xd6c9320f,0x0f8f5181,0x832ff2f9,0x52f96b41,0x26776209,0x7b9b0e75,
	0x6a1781fb,0x03d3c41d,0x4aa9161d,0xf65bee2d,0x9bf93633,0xd2933aaf,0x4f879ad5,0x473d936b,
	0x45934a6b,0xcbd77217,0xf0a3ce7f,0xa05300f7,0x938999b7,0x3b67f007,0x61f3c631,0xaf5566a3,
	0x4b67d473,0x0d31f9b3,0xb8d792cb,0x4ea70e49,0x04a1d541,0xce4b90d7,0xf51b25f5,0xd65368c9,
	0x0195160d,0x4df190b9,0xa9eb571d,0x0d0b3b0d,0xa885450b,0xde8deb27,0x46e1087b,0xb92beb05,
	0x9c9ff9b7,0x36ab0575,0x00ff6c0f,0xd1b1ecad,0x76f589d1,0xf2013581,0x5ba9689f,0x4f4b4f03,
	0x1f85fe65,0xb26f5eaf,0x51b51ebb,0x9d4b6911,0xc63328c9,0xe0fbaeef,0x1e558db9,0xaaa9a6eb,
	0x7bcbd795,0x0ed17bb3,0xa62f58b9,0x9b0976a7,0x6b032baf,0xf6493efb,0x8047aba3,0x17b55567,
	0xb1750d41,0x1be1b44b,0x9f0f4025,0x409ffc55,0xd8a5c0bf,0x0f3f15b1,0x995f82b7,0x3d61ada3,
	0xef019be1,0x4c3378bf,0x9377d799,0x6e3fa189,0x40dbdaaf,0xbbb14b97,0xc7ffffd1,0x3d219347,
	0xb1719471,0xd4d7f1db,0xb1099e2f,0x8e996e29,0xb3e9d0bb,0x5ded81bb,0xd10bdc49,0xd2e31a7f,
	0xe44bbc69,0xcd61a0e9,0x1be72f7f,0xb6e16aa1,0x408ffe9f,0x4ac781a5,0xffe53df9,0x751d27f3,
	0x018f2dc5,0x4fdfffb1,0x0eb5e3a5,0xc6c93fdb,0x140f6491,0xe991dd5f,0x466d573b,0x74bf10cd,
	0x31bdf6fd,0x98e9207f,0xfa916f3b,0x8881d741,0x9a2d474d,0xd41d8f73,0x5d0706eb,0x1d3b3ab9,
	0x6bd9bb0d,0x278d4e1d,0xa721835b,0xd0bdfabd,0x9d29d00f,0xf6bd9aeb,0xe2957861,0xd483bbdf,
	0x9565516d,0xdd5dabd3,0x52836d9d,0x9eaff4b7,0x65c5ac8d,0xb043ab53,0x7c77c377,0x3b0bfae9,
	0xa2636619,0x1e6dd56d,0xd15db81d,0x3c09301d,0xdb43af05,0xf201b4b1,0xf68f8c89,0x4bc34f03,
	0xb555198b,0xf14d7f33,0xaecfc975,0x5cfbd855,0xa3676e2d,0x5fc99393,0x6341a46d,0x7c1d9fd5,
	0x3f3ba0b9,0x1f1115f3,0x4c7984bf,0x4039794d,0x4273e543,0x6fedad01,0x3b6fa881,0xdc0b058b,
	0x1f99e523,0x53495ef1,0x0281e995,0xcef59f6b,0x3b2513fd,0x8b3d8e85,0x7e79a29f,0x35ff68cd,
	0xc47124bf,0x3c0917fd,0x3f87b40f,0xbcdf779b,0x2ec39e99,0x2d0f8e29,0xd243a91d,0x2eed22c5,
	0x4a459207,0xa9e1975d,0xa8adfcc9,0xa82b6f47,0xfd0d6dcd,0x03336a77,0xa32f7ed9,0x66459d1f,
	0x9c17f3f7,0xafe36bdd,0x3997d8dd,0x398bd459,0xe4474ed7,0x0df9ea79,0x441d332b,0x95f9f203,
	0x93694607,0xc3a3fcc5,0x6463f9e5,0x442f753b,0xa131936d,0xc0377dbb,0x0e6fc1ef,0xb27b8c1d,
	0x183b5833,0xdd3329e1,0x31b54df9,0xe5cd40d5,0x8f0db1cd,0x1f3bdc45,0x820bb37b,0x0abdc695,
	0x41116ef5,0x9723eb7b,0x60af9fb5,0xa693e695,0xc79fe4ad,0xe2dba69f,0x654dbcad,0x68338d15,
	0x72efe345,0x4e85f25b,0x86f53633,0x99337661,0x4325cb4b,0x956505d7,0xe51d5edd,0x2ecdfbc9,
	0x8151c29d,0x42ed47cd,0x30a5750d,0x7ae100a7,0xf867095f,0xb3af4b75,0xb4d987e7,0x7cfdff59,
	0xce3f6ef9,0xb66bed99,0x00657c5b,0xd34f364d,0xfca1e721,0xcd079185,0x2e633221,0x4bb5f4f1,
	0x6a393ed3,0x0d937e0b,0xcf55c8b9,0x14af08bf,0xa399f14f,0xa3415a8d,0x721f0469,0x8e694a39,
	0x343f1d23,0xef75cbed,0xcd15d341,0xbbb349e7,0x9f8f9921,0x4ab1319b,0x86eff217,0x53071d5b,
	0xf9d52963,0x65a38289,0x9fcbb18d,0x6f8b4c2f,0x2147d44f,0x4a254a35,0x7a33db07,0xe205dd03,
	0x96ff578f,0xfc31c5a7,0x8417b5b5,0x21eb8281,0xf801bd17,0xbaf12069,0x7fcf2b91,0xde53e859,
	0x16391021,0xe1b1d193,0x6d1b0e55,0x2f032045,0xb17f3231,0x68e718bf,0x12257c8f,0x65632f09,
	0xd08bd011,0x07339b15,0x24796689,0x7d87b969,0xba0376d5,0xf2592041,0x1215335b,0x2f29d13b,
	0x8d75c8db,0x40496f79,0x6a5385e5,0x9ea9e255,0x7c51d2c1,0xe8194c79,0xe70121cf,0xae13bf99,
	0xa2f78077,0x63079489,0x154df089,0xee1bcff1,0x81a9322d,0xed797b73,0x9ecd2647,0x2f175b4d,
	0x1595715f,0x67fde88d,0x3285870b,0xb20df7a9,0x91cfc5d3,0xd84bf3b5,0x0ddbcb9b,0xf9a51605,
	0xb851aa91,0x8a3f8251,0x259f2687,0x3b33af67,0xd303a2ed,0xd0e1044d,0xef0be927,0x6fb111e5,
	0x4cad6f81,0x675d511f,0xc8bf4897,0x04bfcd95,0xea076333,0x720da4c3,0x03c142c1,0x2da9c19b,
	0xa2abd82d,0x1f6bbcbf,0x8c83a355,0xd461491d,0x1a1dc4e3,0xe91f1521,0x33df28c7,0x2a83884f,
	0xb8cb710f,0x74f9457d,0x9811c959,0xda4fd969,0x65094ab5,0x15ed7df1,0xadc51811,0xd7af59ad,
	0xdc13db1f,0xed1b2421,0xe909c9bf,0xd1359663,0xab0bdbe3,0xaac7903d,0x065559fb,0x411f59dd,
	0xc8016bd9,0xef61e9f7,0x738dd021,0x1e4b9873,0xcae76427,0x4c7f258f,0x58f5a45b,0x2d457d89,
	0xc699cd35,0xe5dd20c9,0x423dc499,0xf13f9887,0xc1db73bb,0xb265dff3,0x6781b98f,0x3d1529dd,
	0xd05d9daf,0x5d23eae1,0x963febbf,0x64459005,0xcbafdf59,0xc64fc9ef,0xba61086f,0x0bfdd481,
	0xac4d103f,0x2445a307,0x073386af,0x9c0f58db,0x829f6039,0xc48bf691,0xc0734c57,0x4ff3a3a1,
	0x0fef8c61,0x6cd17c85,0xa33b7303,0xe7cd4d6f,0xff713419,0x5bef2161,0xef192d1f,0xf9670de5,
	0xbf414e0f,0xeadf2329,0x0efbcad5,0xe133e8ad,0xf965bd31,0xcdc94e69,0xe237df1f,0x534b7a77,
	0xacc705bf,0xf4fb5b39,0xa59184bf,0x8c7365ff,0xe63d223b,0x0ded6a33,0x7c2fc337,0x2313e103,
	0x19837871,0xa43da17f,0x98a113d9,0x783d614d,0x1a3dee71,0xe2afe9cb,0x05e106bb,0xc8af69b1,
	0xb4f71f9b,0xf431cb49,0x104f07bf,0xddc77705,0xe825b18d,0x04dd6ab7,0x4eb14389,0x5e910d2d,
	0xbd25c937,0xe2eda65d,0x4b39ac8b,0xc0bfe40f,0xc1399fc9,0x3fcb5305,0xcc7f1ff9,0xd9ab349f,
	0x1e8d37c1,0x91039905,0xbe85aad5,0x0f5725d3,0x553731df,0x914b713b,0xbbafeee5,0x296f59b1,
	0x9433c231,0x6183420d,0x35d1a7b9,0xc2439a3f,0xb265c509,0x49af9c67,0x3f234fa9,0x57cfa68f,
	0xc799f403,0x19ff18bf,0xf343e4d3,0xfcb51fb9,0x65853b01,0x2bc95411,0x803bce1d,0xa93f95e1,
	0x70c12d31,0x028b0ce5,0xcf7be037,0x2c5fb52d,0x99d79a03,0x8ceb6045,0xcedb829b,0xbcaf92d1,
	0x762d4233,0x05b926c7,0x599bf485,0x29711a05,0x391dacc5,0x74e77189,0xc163b1fd,0xab91990b,
	0x0cdf1c03,0xd0992731,0xf745f8d3,0x56a16e2b,0x0b99a283,0xbe0fc0e9,0x54b76d9f,0x29d9d4b7,
	0xd857581d,0xf2bd276b,0x049be0bf,0xc11bd209,0xd80faef7,0x3535aff1,0x0c373359,0xa5f54281,
	0x0a99e87b,0xfe393941,0xf43f5c5d,0x40970689,0x83bfaa5b,0xb9ab68a9,0x11c78d85,0x68db4f91,
	0x8429b395,0xa79d06fd,0x6f53784d,0x97430d13,0x326bb169,0x5d437d9b,0x55c9b2fd,0xb5fb7993,
	0xf4033465,0xe5fb7367,0x75793da7,0x91d3c795,0x6657c55b,0x844f89d1,0xaf1d271d,0xeb47eead,
	0xf7af1a67,0x12e939cb,0x7cd55203,0x27799875,0x20436bed,0x059fd0d5,0xfb2759bd,0xa1312d8f,
	0x3b2de995,0x0a738df3,0x9205977d,0x99e502a1,0xff714f55,0x4a89deb1,0x3dc74737,0xcaada55d,
	0x98fd9a67,0x4b2fbc27,0x782fccaf,0x954b497f,0x61a5de4f,0x6edd27ef,0xc1611867,0xd52b55c5,
	0x3a2339d7,0x162fc933,0xc8f12cb1,0x505d10fb,0x831fec15,0x60eba99b,0x36d7c2a5,0xc89b6ef1,
	0xb6218963,0x8f01125f,0x14710f1f,0xac4bfd7f,0x9ea15061,0x0189893d,0xd589a7cb,0x6775f187,
	0x32f99eff,0xdbbded77,0x014f8813,0x54c953f5,0x0d6f876f,0x4405b4df,0x7b593633,0x4ea54eb7,
	0x852d8529,0x44f148c5,0x6cab0827,0xe00999c7,0x674951f5,0x4e35830b,0xccad88b9,0x15a10825,
	0x4fbddadb,0x55af4b13,0x8a2bfc75,0xeebd34dd,0xa271552f,0x986752cb,0x546106b3,0x6e574fff,
	0x242f738d,0xfb8bf3a9,0x03ef6e95,0x4c150ba5,0x33abbad9,0x0d6f2ba9,0xa3dd03ff,0x453da8ed,
	0xa281f73b,0xa695ba51,0x1a99a4a3,0x0dc52505,0x2e37d129,0x2a9f5db1,0x72ff60f7,0xe143861b,
	0x9937825d,0x695f2f59,0xc54bc139,0xb3fd4869,0x63d7aadb,0x1fcb2169,0xc0292a71,0x03ddeb31,
	0x255345ef,0x18fd9b87,0xd1a96371,0x49739dbd,0x84cfbf2b,0xef4137df,0xf03f39cb,0x08f90c5b,
	0xd2572769,0x6d01a027,0x03d146e3,0x83554d67,0x3fdf89cf,0x8dd58a9b,0xeea3d4df,0x070dee41,
	0xba4360c7,0x1f7bd701,0x3667e3ab,0xe1572053,0x62492b03,0x02d9cba7,0x4d354e03,0xef09060d,
	0xa59b2081,0x0cfd7261,0x7a8f0e63,0xcda91feb,0xf7d10783,0x881f158d,0x6459a415,0xac5fd96b,
	0x2b632993,0x549bdd0f,0x37e79825,0xbcff3617,0x6ab56885,0xa9f98b57,0x72f1226d,0x45039e83,
	0xd1177375,0x77e75a59,0x4c95ee89,0x4e8bcd45,0xa3bd1bc7,0x6739f88f,0xbe5d00e5,0xf963dbff,
	0x2abfca23,0x7aefa603,0x2d37bbad,0x6bff705d,0x2a25137f,0x51317141,0xb27f03d7,0x6475090b,
	0xfadb6e15,0x044b945d,0x04f38627,0x698b6ac7,0x43b3066b,0xabb3f1f5,0x01bb1c1f,0x9ba92d51,
	0x526bb447,0x7d07b22d,0xd5695111,0x25e3686f,0x14a90fc1,0x8d11ffb5,0xc4f30715,0x4ef180f7,
	0xb0f5a633,0x30bbe4bf,0x96bb3c09,0x2a3915c1,0xbfc54f3d,0xfe1b480b,0x9b89ee93,0xe8c10cab,
	0x2477a1cf,0x6d7309db,0x578b2325,0xca3dbfa3,0x864d891b,0x1a274101,0xcb5b08f5,0xae074997,
	0x6975f99b,0xa3c597cd,0x5cfb3f01,0x4423f381,0xe801c613,0x2f05c921,0x60d13913,0xde39c161,
	0x0af1948d,0x86c33d5f,0x42adc4b7,0xe09d1f45,0xc325f35d,0xdd05c775,0x4ec9ae47,0xd347ae39,
	0x826b8e1f,0x2bfd81d9,0x1ac385e1,0x12db3157,0x747982b7,0x36fdcb89,0x8ea7846b,0x21a39ac3,
	0x57e9d64d,0x2b856507,0x8de19097,0x989138a5,0xf73f0a57,0xe23bad65,0x404b63db,0xb841022d,
	0x41e9d191,0xbfefff33,0xfb25cf75,0x99f10497,0x053be4fb,0x36952d91,0xca19216f,0x008ff021,
	0x456ff8e3,0xe64b2125,0x9835a995,0xc9adc515,0x36abd1d9,0x5e59951b,0xf8f15e81,0xfe83a0c5,
	0xd5fd79bd,0x7e2df429,0x912fa291,0x84f5aa8b,0x225794af,0x765d558b,0x203728eb,0x708d20c9,
	0xf595d61b,0x69a59a09,0x28b9fa81,0xf37d85e5,0x7d7b95b5,0xadefa8ed,0x39cb9b09,0xef9fed51,
	0x54b78477,0xad47cd0d,0xd7f14e01,0x27776889,0x3bdd81a3,0x66e331c7,0x06137bb3,0x0f2d940b,
	0x72698fc9,0x90238001,0x6e7d362b,0x3d934463,0xafbde9b7,0x558d9b27,0x2bebde43,0x7d27531f,
	0xbc29378b,0xbbcd7e2d,0x327de899,0x7d058bdd,0xa9dfe3a9,0xa0bb3893,0x58b9c293,0x21fdb939,
	0xadfb8fb9,0x5c550b5d,0x0093d763,0x777fd1e1,0x9983a9b1,0x01c1a619,0x605fb4ff,0x40a54581,
	0xf26120cd,0x404d83db,0x6be15127,0x293369d7,0xac6b3a8d,0xe4716841,0x5d3f6e5f,0x969107a3,
	0x825d87bf,0xf8c9fc6f,0xde0920fb,0x18d107ad,0xeed9f975,0x871d8c15,0xd039740d,0x7baf3fc7,
	0xc56f160b,0xf95be265,0xb72d2e79,0x778d5fc9,0x6b914e23,0x1a97471f,0xc0afb7e5,0x0275fe97,
	0xb19b71a9,0xb8139b87,0x6def1dbf,0x4119c719,0x4bd344cf,0xe231976b,0xdc85383f,0x17d3c53f,
	0xeb653513,0xcd83261d,0xaf73ef63,0x5ba5d303,0xf7632e37,0x53bde37f,0x981d9ff5,0xa33b2567,
	0xe5cb8f45,0x14bfb8f3,0x7f57a081,0xb7e5f973,0x34813f93,0x378d9a69,0x4e57e661,0xa69f6139,
	0x0251e3b9,0xcb576353,0x57c1cab3,0x710b30d3,0x47ef329d,0xc873d3b1,0x6097ef5f,0x5e710b61,
	0xb0f76a67,0xb15fad05,0x494f4413,0xecc7900d,0x14efe58f,0xd3bfef61,0x56bf2b47,0x61a5a707,
	0x9043cfcb,0x29673655,0x1b27bf39,0xfb4dee8b,0x3d45fb21,0xd9473603,0xff2f36f3,0xc1ab47d7,
	0x8d33d4dd,0x5881580d,0x6ae76b41,0xf74f8435,0x41317a91,0x2b5b78a1,0x8ec97bbd,0x2a7531f9,
	0x034bef19,0x4641c375,0xccb593c5,0xe5ff8979,0x9f776f97,0x0ecdb0c5,0xc0f3cf81,0x02757a17,
	0xdc8de877,0xfcb92259,0xeb3140df,0x970dd73f,0xf5558a6d,0xdaeda07b,0xf7891497,0x8a9fa55d,
	0xb17b7f73,0xa879b701,0xa77dd727,0xc4ad86ef,0x1e91bfcd,0x19917249,0x5af3d9d9,0xfe614973,
	0xe9170705,0xb893fc39,0x393bb7b9,0x33919275,0x556de8f1,0xa707593d,0xfa0ffaa1,0xb3b1ac85,
	0xd8e106a9,0xfe9b454b,0x4e8de02f,0xd2e9743b,0x52a96393,0xd22530df,0xea3f3ecb,0x3aff653b,
	0xe4dfda57,0xcea15dff,0x2c158aa3,0xdc69c72b,0x6d87b1ed,0x7c391d39,0x6767faaf,0x7f3ffabf,
	0x9f8f528b,0x1f392aa1,0xccf7cdaf,0xf443e6af,0xbbc91ab9,0x39172ad5,0xf3e9af27,0xe5df84bd,
	0xe9f5543f,0xa97347fb,0x02d13c6b,0x49278eb1,0x31b34931,0x6f13eebf,0x78a5a98f,0x6ed54b5d,
	0x139178e9,0x08e3ab55,0x95c78673,0xb4497b9b,0xc205ed0f,0x76fb267d,0x64ffa3bf,0xd491674b,
	0xfa69ae89,0xdb99427b,0x647d17e1,0xd95b0a57,0x7e015a8d,0xbc23581d,0xced76411,0xac0561af,
	0x2afbd795,0xe22993b7,0x8411b94d,0x468fd84d,0xb56b2a65,0xdc5d7225,0x92915d5f,0x84a3d433,
	0x004d6b07,0x1fa35dd1,0x60292fd5,0x94956369,0x1683d9d1,0xc7fb6ba3,0x730f4f05,0x085f0903,
	0xc3dd145b,0xf9993815,0xdae5dd0f,0x86a1aa17,0xce0d6a8b,0xe1cfe41f,0x39b1e4d9,0x1ba79ac7,
	0xcdaf538b,0x581f324b,0x6ce75f15,0x2a65cb3d,0xa74702cd,0x1f2bc3a5,0xd65b573b,0xfd7114a9,
	0xa4451d0d,0xc5c574bf,0x454f3085,0xf811a647,0x2bf78d51,0x27e1dabb,0x7f6d0aff,0x672f9255,
	0x1c9f79e1,0x8f9fe03b,0x69c34875,0xf2597b1f,0xc45f5951,0x7643826d,0xd1cb3183,0xaccf5ff5,
	0x7a43277d,0xe53dae07,0xd663ba83,0xc66f8a2f,0xd73fba87,0x77233c47,0xf0d5689d,0xdcc59a2f,
	0x8f2f37db,0xf8b30fef,0x9dd156c5,0xec05b45f,0xe9d9a92d,0xa9d35251,0xa6715aad,0xe005ce31,
	0xdbe7b177,0x1e91d03d,0x093149d5,0xc54b1b1d,0xbfef61fd,0xc0257715,0x82fb5e87,0x99ff99a5,
	0xaf6d2f4b,0xedebf1b9,0xb821bcd1,0xbef5c051,0x7bc50633,0xbe6b659d,0xfd591789,0x08a54ab3,
	0x474380cf,0x60514faf,0xc0c5754f,0x70332663,0xbe1b3b85,0x1b758173,0x92ed158b,0x64698005,
	0xef6949ff,0xf1d73de9,0xcfc1756b,0xbabbf03f,0xc633cc2f,0xe09976a1,0xe79774e7,0x403fc8c5,
	0x2263a353,0xc10d28af,0x48339bbf,0xeabb8151,0x91d146eb,0xc9a7d9b1,0xe5bb7e77,0xa997449f,
	0xa935b9c5,0xaf0534cd,0x63c14363,0xd6e59d7f,0xfd359ef3,0x64efc7af,0xde3b4797,0x486343bd,
	0xbb5d6ed1,0x7f53df8d,0x5289e3f3,0x006f0935,0xe321cc03,0x33478623,0xa877521f,0x7f15e6c7,
	0x1edff871,0xf8079eb7,0x5b31b189,0xb307295b,0x3cd96a51,0xc7fd2317,0xc2532c6b,0x8a9fbee7,
	0x483b811d,0x01b58097,0xfad93cbf,0x24e1a35f,0x421d5a99,0xe8e71515,0x702f1151,0xa2756dc7,
	0x7a77c7d1,0xc76dcbf5,0x052312af,0x96adfd29,0x892f6217,0xae53db27,0xdcef882f,0x18874593,
	0xe711c005,0xd6c3a01d,0xc4315cf1,0x73a13d21,0x26d3ca81,0xa3159cd7,0x39f304dd,0x7947e8f5,
	0xce0d31b5,0x3fc794d9,0x18a581a1,0x716b8a35,0xce490213,0xe47fca2f,0xdf1f87b5,0xaba7eb13,
	0x9ded5959,0xb50d5a71,0x99a1c359,0xb03dcbcb,0xf1533b89,0x4265bbbb,0x6ad33d93,0x11196f9d,
	0x13b387ed,0xaba559b1,0xb4c7e133,0xdacd49cf,0xe0350e19,0x5f155283,0xe1f51fcf,0xa591cab7,
	0x5ae1c2e9,0x7b2353e3,0xce3bb6c7,0x46494cab,0xe9af157f,0xcf639811,0xcfe19443,0x1f7d210f,
	0x2d776449,0x7d9702cf,0x609bdc31,0x1263bd49,0x7b0391f7,0x3aa15e6f,0x667f0d4b,0x0fd307cd,
	0xf3fbba85,0x2f93b8c1,0x1d0b460b,0x4951c513,0x3ff30837,0x7aa1e027,0x9e2ba9bd,0x0205249d,
	0xe56ba899,0x502b0083,0x0b2fe56f,0xffc16df3,0x42c3e17b,0xbbb56043,0x55cdd4f7,0x9c01cda7,
	0x274b45fd,0x00ef3d5d,0xa92547f5,0x74e74253,0x0c350b7f,0x9cafca4d,0x72c3e6d1,0xbe3da997,
	0xed9d7ead,0xe5f34b1b,0x0b9337bb,0x3273ed1b,0xc3879879,0x4ee15251,0x00efc3a7,0xa3a74f93,
	0x9ae1b321,0x45c71e05,0xfd995b57,0x2c9bd9b9,0x4e7f5f27,0xb61d14d7,0x52b77c51,0x01b5e74b,
	0xe01d5855,0x297f62e9,0x20d9d5e3,0xe20dd413,0x715d9abf,0x88b5b6e9,0x20f7ee29,0x2859c8e3,
	0xdccf97c1,0x7cab1f0b,0x0d75e6fd,0x7bfba895,0xeee58aff,0x6f79060f,0xab176309,0x22011d09,
	0x3efbef61,0x2d5f503b,0x720f8abb,0xee1bc429,0xa857141d,0x25bf9859,0xd6f5314b,0xd3a37ce7,
	0x6323d1af,0x4c2b8cbf,0x33c919b9,0x169bd439,0xbd755ed7,0x99576c4b,0x50f35bcb,0x1cad9225,
	0x744945a3,0x2c21a361,0x8e45e911,0xde2f66af,0xac837863,0x0a9188f1,0xabf531e1,0xf715b6ed,
	0x8bef86b7,0x82d53b6f,0x33a5ea5d,0x580789f5,0x7241f27f,0x2c439dd7,0x815def69,0x974d95e9,
	0xd215a4e7,0x885974af,0x6c8b4bb5,0xe1d76cf5,0xa9f18363,0x43bba303,0x910b5cb9,0x8c43ca45,
	0x9d3f24ab,0x173d876b,0x381b17b5,0x43d1ff17,0xad55a5c7,0x48cf7903,0xe1636eaf,0xdf6d7fab,
	0x926f9eff,0xcc936471,0x6bf3d577,0xd0a79049,0xb4b138e9,0x05cd88df,0xdf45e6a3,0x34b91243,
	0xc527615d,0x27ef5507,0xd4392895,0x858970f1,0xf6c5207f,0x378b6421,0x7e15f271,0xea9daeb7,
	0xd7690dbd,0xab619af7,0x538b7127,0x2a2b91fb,0xc8d5e4c7,0xad5764d5,0x57b5cc6f,0x3a0bf231,
	0x19b73a99,0xfb7d108d,0x030f6bc9,0x70bf24d1,0xbea15279,0x69054d81,0xcc855b7b,0x56718a5d,
	0xab1112ed,0xff53c893,0x5265d195,0x15f53b5d,0xca6b1acd,0xbee9e933,0x2367d2ef,0x8dc5d565,
	0x98fbf633,0x0075ae53,0x27aff825,0x01016809,0x5cf77381,0x75d1ab71,0xa9c152a1,0x687781ef,
	0xff771863,0xcaf72595,0xff8f7191,0x63955dbf,0x8583b6cd,0xe7115049,0xd36f86ef,0xc9792f2b,
	0x290721f9,0xcd6baaa3,0x0d27ac77,0xd9e38fe9,0x11d70369,0x1e7b7c43,0x5ad948b1,0x0e3d0cbd,
	0xaeadcfed,0x38e1724b,0x5a1993ed,0x8a9bd26f,0xae2fdc93,0xfa615c69,0x60dd3d41,0x2eb57ad3,
	0x97e993b9,0x20eb09d3,0xe6872f8d,0x46f1f9bf,0x0551ca03,0x4b954645,0x8cdd767b,0xdd55aa15,
	0x7ac13359,0x9b9df707,0xc9134375,0xaa957abf,0xe07df7f3,0xf56957e3,0x2cbf12b5,0xa70d3baf,
	0x9bb36947,0xe187582f,0x4edff03b,0x3bbd0add,0x4777d71b,0x0daf17c9,0x54dfdccd,0x134fe149,
	0x0dc3847b,0x6dbd8417,0x1b8f52fb,0x8b173fff,0xa07dbcb9,0xfcb91505,0x0025ec1d,0xc40dfd0d,
	0xd2730871,0x1dcfaa07,0x4941254f,0x53d53091,0xd0578285,0x9d59871f,0x2fef447b,0x95bb41a7,
	0xf9c54d21,0x51d171cd,0x889b5d51,0x9bad137d,0x5a4126b9,0x5cdfee1f,0x0c1f7645,0xbf475241,
	0xc2391f07,0x0c539baf,0x40bbcd99,0xd2cde02b,0x80016c0f,0x5b21b295,0x03193e53,0xf2276281,
	0xb8d35f1b,0x1269a077,0xaf47c543,0xf3e9ee89,0x61d779c1,0x8a6fc585,0xe9bf2601,0x7a4bd695,
	0xd917a2d9,0x0ba35171,0x085fafe9,0xa43196ff,0x1e857b87,0xcf9b407b,0x1b712325,0x5e27e327,
	0xad03d439,0xa2137867,0x96a5b5a5,0x535bd275,0xf34f419f,0x21f50583,0x9a13381d,0x7ea92d5d,
	0x6d19d1b7,0xa24d77a1,0xdb3b5b0f,0x5b95da59,0x5bf5e0c1,0xab535f23,0x2e0513c1,0xb7476ae7,
	0x205f0e4b,0x1b63e9ed,0xadc32143,0x2191c891,0x32bb5227,0xe803a069,0x862bb16d,0xfdf101e9,
	0xbc553171,0x7ee3428f,0x5c5f25db,0x34853789,0xd061138b,0xc6dbc4dd,0x57e5f8f9,0x8319a911,
	0x44fbb721,0xc0e56d57,0xcbb1c2f1,0x6e1fe22b,0x2c29c727,0xc9291089,0x7f175ebf,0xd1b10789,
	0xecd58fd7,0x77f56e8b,0x96db2f1f,0x129343e1,0xfbd5d3b5,0x22c1aff7,0x1e238399,0xef2b54f7,
	0x34e5c08b,0xfd2b02f5,0x2f811d7d,0xf0913895,0xd3a9046f,0xd9f75831,0xbde9d4e1,0x7b7bf989,
	0x0cad02b9,0x8c133fe3,0xfdc15da7,0x814d9cb1,0x4665290f,0xe799e6c3,0x6dcd2c73,0xd1112de9,
	0xf22d645b,0x62c33319,0x803f7bb7,0x0879ed1d,0x054bb5cf,0x56fb01b5,0xe3b170a7,0x24df9b3f,
	0x11ebe7e9,0xe1cd82e7,0x6c1f6045,0xb447e747,0x001f6369,0x65efb78f,0x9bf53459,0xa659fb35,
	0x66e5245d,0xac410e13,0xcd01f06f,0xbd672915,0x8521cf17,0xa4c71f5f,0xf97b56df,0x9f6db7f7,
	0xda9fe533,0xc7b38be9,0x2505adcb,0x870dd0f3,0x61151a93,0x1655f8ad,0x65a7a417,0x94918c2d,
	0x651bca63,0xbc312c33,0x8cd15675,0xbeeb1dcd,0xff398c17,0x4fed4b83,0x705b7459,0x64b52303,
	0x2cdbe869,0xb4533739,0xd3858505,0x7d310f09,0x89532e5d,0x995b086d,0xeff74c7f,0x694bb81f,
	0xa6e1683f,0x9d27adc5,0x9ec35099,0x64930493,0x07a5709f,0x0cf7a871,0x215f7de5,0x9645b7b1,
	0xb6ad275d,0x463fe925,0x8aadecc7,0xc2435ed3,0x80edc699,0xb791cd1d,0xc7f5c663,0x9a175e5d,
	0xce4357bd,0x81af3b1f,0x49e549ab,0xadf11eb7,0x1a714881,0xb87be079,0x4d99f053,0xfdaf5951,
	0x0e251fdb,0x44078dff,0xc58db3dd,0x29d385a7,0x37f35313,0x6187b50d,0xe2ad7291,0x44836637,
	0x65553ab1,0xc459048d,0x3d49747b,0x4297b58b,0x9bb32789,0x570725e7,0x9e151073,0x0c83f337,
	0xb15597b7,0x9c3b9a15,0x6737711b,0x2f6f50d1,0x86738b9d,0xafcbb691,0x9d3379d7,0x2e23befb,
	0xde25fae7,0xe7b9c25f,0x8ffbcbd9,0x720f1a5f,0xd7756989,0x15293311,0x23e9eb17,0xdc5178af,
	0x064b9cbf,0x656909b9,0xbab9834f,0xf6a995a1,0x2c7d7009,0xe2f14ff3,0xbc95cd09,0xc4835ffb,
	0x92c5ca33,0x965db4e9,0xc10f1295,0x33efa681,0x01cbb253,0x47734a43,0x581f550b,0x2ea9e509,
	0x5b1784c1,0xde236139,0x73231147,0x4b133169,0xd2214823,0x63858789,0x6de524f5,0x1d354885,
	0xc5432263,0xa2d3a475,0xb795d381,0x27c5bb43,0x36c3edb3,0x6a7535cf,0x1bcbeb21,0x6d1b3b97,
	0xe5cbed91,0x6cfbace7,0xab8709d7,0xa0390979,0x0771a3bf,0xc219eb9f,0x4631026b,0xf5c97feb,
	0x9fafc547,0x07ade159,0xc29b6169,0x951fc1f5,0x7a6d4f7d,0x22bf4803,0xb7fb122b,0xa93587a9,
	0xc475bcfd,0xa07d8113,0xe6f323cd,0x11ab0b1f,0x447b5aa9,0xb73b9285,0x4289ae3b,0xb3cf157b,
	0x341bbcaf,0xe77b43df,0x9931d71f,0x6b8f2be5,0xb8db537f,0x3ce15b2f,0xddbff6f5,0x9c89dc8d,
	0xfd2520d5,0x2f39fa0b,0x1077ddf9,0x62fd2bad,0xe94f8cb5,0x237f1a8d,0xc7ff3935,0x64d52087,
	0x7c955a69,0x8ccd2c5d,0x5a671775,0x42a57263,0xc619bd87,0xad69d1a7,0xa6298e53,0xa8a75593,
	0x7deb8ee9,0xf7c3bc1f,0x7b237f2b,0xffbb6871,0x3dfda1b1,0x0f71aa07,0xa39f7c29,0xbe6fc05d,
	0x5b2d3849,0x6a31831f,0x8d4fcd37,0x59f116c1,0x5e3d9969,0x90e995b7,0x92479511,0xd71f160f,
	0x1cd9c509,0x00a7f3a3,0xe2091633,0xfb79c6bd,0x7297496b,0xaba3ef41,0x0a7f17e7,0x1e291c4f,
	0x99f3381f,0x1a39b875,0x20f56b39,0x9903a24f,0x25513af3,0x2bf119af,0x8b299003,0xd97f494b,
	0x97fdc905,0x787954e1,0x683779e1,0x11c353df,0x9f2d7bb7,0x50a5208b,0x99a9753f,0x899563ad,
	0xeaf983b7,0x5f77c4b1,0x6c6f2c49,0x8f69a65b,0xa7693df5,0xeb1157e1,0xe1e1cbf5,0x095b229d,
	0x9569e8ad,0xb5c51c2f,0x98bf4907,0xa6292529,0xc3cb7863,0x7f07fc39,0x5631c501,0xae43cdc5,
	0xe84d8ce3,0x24752823,0x2ec71335,0x74b5bc37,0x5893863f,0x62d9d29b,0x4f7b5dbb,0x683fdd51,
	0xa329b9d1,0x371d0dd9,0x66adea71,0xc43f57eb,0xc885c73f,0xdf57c895,0xad25fffd,0xe1c199e9,
	0x14010d73,0x7bc9eb19,0x8f11ead1,0x28778531,0x94e13fa1,0x4fd79431,0xf50d2223,0x9fbdbcb7,
	0x37531a41,0xa30f762f,0x2d158cf1,0x1f931173,0x7d69381b,0x422953f5,0x7395e705,0x21a30f67,
	0xd8210737,0xa0019de5,0x1c5b45eb,0x323faa9b,0xa061ddeb,0x969d2eed,0x5ba1bdfd,0x01650c21,
	0xaff12fcf,0xc82f2983,0xaf072759,0x13b37f13,0x9a89e2c7,0xa009f4a5,0xe69302e5,0x13757d91,
	0x86c1c401,0xf3ab58d5,0xcdb77f53,0xc19dddc3,0xa7231ced,0x43bdbd23,0x744b9e19,0x86c51edf,
	0x53176847,0x9d098425,0x178f7875,0xa431d619,0xbff12713,0x198988f5,0xab2da471,0x04c93bb5,
	0x59f1d59d,0x0159bc3b,0x0233b9d9,0xae1fd7fb,0xbd370077,0x8bc1e123,0x9819f747,0xd171503f,
	0x4ed3797d,0x402f6a63,0xf9c10719,0x7c9d53d7,0x75b5acd1,0xf7397737,0xce73e475,0xeb2fa925,
	0x73bd15df,0x7b9bf067,0x80dfe04d,0x77595a93,0xdeafd459,0xcb3fc53d,0x881dc657,0x2af50393,
	0xb935613d,0xf831488f,0x50ad2211,0xf0853d9b,0x2be563cd,0xa9a7adbb,0xc577a3c5,0x64352d31,
	0xde39a693,0x3d01a5a7,0x78cba57f,0x44d72ed9,0xef992c65,0x86c51bbd,0x6d65d019,0x84e3a429,
	0x904f655b,0x339f12f7,0x7f5fe031,0xfb7de0b7,0x3a8d83d9,0xc967a2cf,0x6d478b2f,0xb56f3727,
	0x8b75f18d,0x481b144b,0x8109843f,0xe62b261f,0xbc05e467,0x6ae11ef9,0xd901a15d,0x78cba553,
	0xba2f13a3,0x890745ed,0x50eb2047,0x4111927b,0xe1c38cc7,0x170554c5,0x0af30b81,0xcc693e57,
	0x557da89b,0xc777fca5,0x98a7bf5f,0xd2e519b3,0xf8052031,0x4c25913d,0xc4018ef5,0x483d825f,
	0x04e541e9,0xb6fde5bf,0xf85f8923,0x0cd3b035,0x49914663,0x7b1349eb,0x4b8d5d8f,0x3eb5c213,
	0xfe65c58b,0x0da9a705,0x26b761ab,0x2a93eae7,0x3fa74b95,0x2721bcdb,0x8f77b5ad,0xdcc7be9f,
	0x26810dfb,0xa40d7ebf,0x10cd8993,0x52539f35,0x820bc081,0x06219093,0x44218227,0x49e349ab,
	0x303b8a31,0x953de3b9,0xfa453df5,0xb4c78309,0x16fb1a61,0x20657421,0x0471fa57,0xc7fbe563,
	0xbd15dda9,0x5ec9253d,0x9d43586b,0xad21cccd,0x833d52ed,0xf0bfbf0b,0x71c54219,0xd383646d,
	0x7d11805b,0x00c50b13,0x4a65ef0f,0xe113d36b,0xea138863,0x8481115f,0x53ff09c5,0x436b89f9,
	0x4eb15ec3,0x1dc17587,0x08d1f479,0x60cdae4d,0x2d3d9d7b,0x9b7bf3a5,0xb9832e35,0x6923a9ab,
	0x5ef579d9,0x1acffd63,0xb627d7c5,0xc703d55d,0x0cfdd96f,0xc80376e9,0x173358c3,0x30a347b1,
	0x49618719,0x3f8393ef,0x2687248d,0x58e5c103,0x481587f9,0x8ee9d4b1,0x686f9f4b,0x4057b8b5,
	0x37f7907b,0xd5ef22f5,0x449722eb,0x26278a2d,0xbbc99953,0x877d0f0b,0x4f1b2425,0x1933c1df,
	0x0339947b,0x4aa32cc3,0x31777777,0x28fb8a41,0x83d94237,0x7b95907d,0x3397b62b,0x36ab38d9,
	0x52272611,0x4cb16c1f,0x64c9c34f,0x6613fb2d,0x1a899bdd,0x877fcc15,0x64c770b9,0x2eafa3cd,
	0xba470cb9,0xedad7455,0xccaf4409,0x0c9f9757,0x78974403,0x3a11dd5b,0x380d5ba5,0xd1b1d967,
	0xdf97e46b,0xc1a7512d,0xedcd73bf,0x965539ab,0x354bfce1,0xb4992859,0x29490b4d,0x4aa3a0d1,
	0x949bbda3,0xff3326f3,0x0341a90f,0xe7617d93,0xa6614d31,0xcaebf999,0xfadd4089,0x3ef951b3,
	0xfa55bd59,0x9f61d271,0x1eafb70f,0x6e7b5ef9,0x001f202d,0x235b2625,0xd5af88b5,0xeea17437,
	0xa047bd09,0x7dc588ef,0x483b8d5b,0x44d1da45,0x7545658f,0x56b7ab89,0x691bdda9,0x54116107,
	0xa473eaad,0x786f7839,0x9e83d80d,0x4e178c65,0x5715b191,0x10534fcd,0x0b0945bf,0x4439e14f,
	0xd35968bb,0x8ff36697,0x76ad9fbd,0x587d52bf,0x3553dced,0x2e014179,0xd7d773d1,0x8e8dceb7,
	0xc7ffee33,0x076152d7,0x7c57e989,0x3cb9eb41,0xfe3fa4dd,0xe013b79b,0xd267673b,0x1cfbb36b,
	0x0be3668b,0x844b143f,0xd1a75707,0xfdf99451,0x1e9b4b1b,0xc95b91bb,0x041d0bd5,0x13f96a13,
	0x370991bd,0x2ec5fa99,0x2f3dc653,0xe9efacdb,0xa1ab35e3,0x1f2df7e3,0x9cdbd9f9,0xf277bddb,
	0x0ff1a445,0xd15f6e31,0x043bf205,0xb8d15449,0x512f8feb,0xc955fa9f,0x13017681,0xb1e70a6b,
	0xaba1e71d,0xf92d8fd1,0x9643113b,0xad4d0a85,0xd56be86f,0x822b32f5,0x437352c9,0xe63bdbed,
	0x8d9757bd,0x15bfd8c1,0x2177778b,0xb4974ff9,0xd51dd329,0xf67f6273,0x91934ca9,0xdde78f0d,
	0xc7d9481f,0x9929bacd,0xf8793511,0x865f458f,0x158b8853,0xe5a31321,0x07414e7b,0xc1dbf0f3,
	0x1ae5febf,0x17fb403f,0xa46bb665,0xc4d94cb1,0x9a7784a7,0x41693787,0x74dfef19,0xb589df49,
	0x15bf5697,0x6949abdf,0x04ef64a5,0x1cb7a747,0xc61f295f,0x4e23cab3,0x915311df,0xf6e3e83b,
	0x35e75f1f,0xc6a318f9,0x70294567,0x652b17bd,0x79495c35,0xc2a1702f,0x19f986a5,0xfe5bea71,
	0x0763fc51,0xec1d1b57,0xd2b79ac7,0xbfe580ff,0x33372765,0xe8391401,0xf2b9a9c5,0x9ee5b517,
	0x44b186a9,0x38475f41,0xcfbd835f,0xb9198673,0x31a759a5,0xbabb8ab5,0x45f1041b,0x25efa7d5,
	0xf6d56b21,0xcc334983,0xe0df9a47,0x67792c05,0x90df2631,0x08773157,0xa483eafd,0x7b6f52d5,
	0x9553cb31,0xab759767,0x763d971d,0x8c35761f,0x6ba1c4c3,0x92438d6f,0x25d32049,0x41d516c3,
	0x26271cd5,0xdc1dfeb5,0x1677edf7,0xb30309ab,0xfb2b1197,0x2b6ded07,0x87c37259,0xf615c4c7,
	0x5dd9ca85,0x86bfcdb9,0x7eb36f6f,0x520fcc13,0xb7432d63,0xd9cb06a9,0x4eb35c03,0x0f9d3e8d,
	0xbf69d33d,0x166b8b3b,0xc291e8a3,0xea11833f,0x762b1d63,0xf5ab995f,0xe587a4a5,0x2063163d,
	0xbc576a75,0x58b59687,0x6c33c329,0x2637759d,0x8ca16b53,0x49e10cb3,0xbd9f0017,0xf4d72e81,
	0xd4a79827,0x9dadc767,0x9c3ba51d,0xfc350a13,0xedebc569,0x33c110af,0x6edfaeb5,0xb3eb5a85,
	0xb6dbd8d1,0xd7e70e23,0x29cb1119,0xcc3d680f,0x4bcb9e61,0xc3193ddf,0xd7a91d55,0xff13fdf1,
	0x5ff5bd67,0xbc731387,0xc2870637,0x80ff1777,0x367fcd77,0xda3db54b,0x3cdd8555,0x123dacef,
	0x3b778b69,0xe2e5d8dd,0x0a8da00f,0xafafa0b7,0x3ccd2e61,0x4dffc07d,0x69df8c8d,0xe3dfcc2b,
	0x4361dccb,0xe54d57ed,0xbc81b6bd,0xb7ff2cb9,0x0bf7415b,0x05b1717f,0xd08fe559,0x44e930cf,
	0x2039400d,0x803d2303,0xc9877edb,0xe41f24e7,0x8fbbcb21,0x1b2542db,0xa951ee8f,0x00cdc081,
	0x48fdd823,0xb2c904e9,0x793d2983,0x88c3d329,0x125f74e9,0xfaadb79b,0x1305538d,0xfd7f1171,
	0x2331fc8d,0xde81a0e7,0x89c9844f,0x251d01ed,0x5ca36c71,0x831bfb49,0x330fac2d,0x5b6d0a43,
	0x22d5d93f,0xe77912c9,0x4fc99957,0x82df9c1b,0xd5cb03ef,0x25c181f1,0x55511cc5,0x958d8225,
	0xea6f0eb9,0x54418ed7,0xd6634f37,0xd6394d1b,0xa397521f,0x0671a81b,0x0c2bf633,0xa14fe0bf,
	0x6aff51f1,0x6ded01dd,0xff370909,0xdddf20d9,0xca49d23d,0x1b7d52cf,0x508155cf,0x0ea5be3d,
	0x04050c61,0x600db125,0xa2674665,0x030323c1,0x4ca503ff,0x4db58f9b,0xa1b3c573,0x28018347,
	0xa385fc05,0x58b5da79,0xae954367,0x795502b9,0x4beb0ba3,0x986f3489,0x25a5db7b,0x12570907,
	0xe601d355,0xa8755421,0x48e398a9,0x5f09ab2d,0x27dd51e1,0x297b801f,0xc8b7dabd,0xed173929,
	0x367bd94d,0xe25f2ce7,0xecf3db45,0xdcd1eb07,0x9ebd23f1,0x8129b969,0x5dcd5299,0xf233add5,
	0xee738967,0xfc074c19,0x8ce73cd5,0x45df10af,0xed4f5391,0x924fcff3,0xbe49bee3,0x961d51b7,
	0x75ef339b,0x6d7f117d,0xb1632b71,0x37e38b13,0xeed5d6f7,0xe23dfbc3,0xea0b27f7,0xa7c9fff7,
	0x636d9c63,0x5157f55d,0x9985f1b5,0xbb11899b,0x3d0d68e1,0xa8c35d67,0x2777c2b1,0x70a5243f,
	0x9bf19cbb,0x84a12887,0x5af156bb,0x62199c2f,0x503d2885,0xf0359de7,0x236d9069,0xd4a75abb,
	0x72fdc21d,0xc6f13441,0x01cb3e1d,0x6a31533d,0x9f2539a1,0xb5678ecd,0x1151fefb,0x723f1013,
	0xca93ee81,0xda579a55,0xb0b347f3,0xdb07dfab,0xbf09646d,0x07a7ca25,0xcb0588bf,0xc25f2173,
	0x3333f861,0xa367750f,0xc0c970d9,0xa6cdb2e5,0x83a9b5a1,0x28c95275,0xf0e9548d,0x387b7c83,
	0x0be34ab9,0x49311739,0xe1b3b1e9,0xca391ed5,0x1f471e7b,0xad2132c9,0x09e1d5c5,0x6281bf6d,
	0xa2218503,0x5547ac1d,0x3991a0bd,0x6c79f5e5,0x42a514b3,0x9b7d1ead,0xa34d6c3b,0x08e7d8dd,
	0x51f11b37,0xd3bdd783,0x85050f6f,0xff412aff,0x3d073281,0x8d311229,0x7111044d,0x4e9da7fb,
	0xa5d5f5cf,0x732555b5,0x3731ac97,0x5ec1718b,0x1c2dd6a3,0xce0ff1c7,0x6d8db6d3,0xd1159c71,
	0x76cf11c7,0xa48f9b81,0x99b7a351,0xf1addd77,0xcc5bc451,0x7c692a91,0xf9a56927,0xc843566b,
	0x0c5f2099,0xbb8d762d,0xecb93b37,0xc9378329,0x3851c345,0xa9115211,0xfcbb6d25,0x26974693,
	0x3c8b283d,0x0e33ab83,0x86d97861,0xc111178f,0x69513fb7,0x7759c653,0x04af2125,0xb9014e0f,
	0x8bd1232f,0x151199d1,0xf53bbb6b,0x9f6b900f,0xa71dea65,0x3d134ddd,0x65e59001,0x46f75e8d,
	0x4d35a067,0x8b3bd7dd,0x1b7d6171,0x34f9c295,0x97f95887,0xa291b7bd,0x5b3d1113,0xb26b1a37,
	0xc2396361,0x8e41d4f1,0x53c36407,0x7ced058b,0x60a5a3d7,0xc2a57b79,0x261be835,0x17cb73b5,
	0x3add0415,0xbe3778db,0x8eb1f94d,0xbcf7cfdb,0xc4650a8f,0x4aa1591f,0x2e5fe5c3,0xee0d4e31,
	0x35a78eff,0x5dadc3df,0x736733d9,0xa54d58ef,0x44f98f67,0x9a55f937,0x226d0695,0x26a11d57,
	0x7f952517,0x71b76ecd,0x7f85a2c7,0x709b38b1,0x42a3999d,0xe4178ccd,0x17271407,0x4d79854f,
	0x542b9bd7,0xe1e58aeb,0x2731f1b1,0x04190789,0x1c2594e9,0x4cb76d67,0xa7ed43f1,0xa907fac3,
	0x7d6b1d3d,0x98492205,0xf50b88b1,0x0f75fe65,0x4ec39185,0x0b85bd11,0x16a3d8ab,0x5a3f62df,
	0x73d7c7bd,0xa177d663,0xaa352c5f,0x2ce396ab,0x963de42b,0x8a570657,0x6ba9c115,0x7c8fb34b,
	0x7e714e57,0x4c8182d1,0x5e519dd9,0x01152a47,0x0cd7c615,0x857bdc41,0x95e33883,0x45ed9233,
	0xd2b99881,0x4af5da99,0x9f813ab5,0x5b3b93a3,0x4b4ff4fd,0x2bc77a59,0x8ab366d3,0x26c9f63f,
	0xb4b56235,0xd0eb0985,0x92679d0d,0x5509cdab,0x88eb531d,0x3e8964a9,0x65f9005d,0xea17c699,
	0x96e3dbef,0xb4f153dd,0x12253b7f,0x72b193c3,0xbb6d872f,0x319507bb,0x8a17e5fb,0xd5457aed,
	0x3a474aa7,0x9019b66b,0xd05f0921,0xc2e501db,0xb7159c6d,0x4b3f5899,0xbff3c509,0xc849bb63,
	0xce63a7d9,0xddf5867b,0x7533158f,0xfed5345b,0x4ea5a291,0xc45574cf,0x56ebb75d,0x5d9300a5,
	0x1137417d,0x1c9911d7,0xbf472ce3,0xaa35e82d,0x735f4dd5,0xe82b4263,0x44e1e355,0x0a1533df,
	0x6f495a0f,0xec973ec9,0xa3b977b5,0x33351ab9,0x550796f3,0x34930fe3,0x46391bcb,0x3d414ebb,
	0x2397c889,0x30ff2c19,0x6e2f1b23,0x1289a9ed,0x81dd5b25,0x79df3457,0xfdd38015,0x810bfb5f,
	0x57a59863,0x2f65d113,0xe0c9d8c3,0xeb63f42f,0x06a3fc25,0xfae3af49,0x15151c11,0x99e13479,
	0x4375a997,0xafd79d7f,0x5427aeb1,0xab75786b,0x8e9d002d,0x8cedc8c3,0x5bdb8817,0xa6b9e533,
	0x4d8950a1,0x1ced19ab,0xd76f7785,0xaaf1760b,0x838bb1f7,0xb7d1b151,0xe88d8903,0x41038935,
	0x2ae1f679,0xa3b5865b,0x50418a5d,0xcc878cf9,0x2db1c0bd,0xd5df21f9,0x3807b02b,0x9cb3cca9,
	0xff03b89b,0x53c17cdf,0x9abf5acf,0x9d695d9f,0xd3cde039,0x33edfc49,0x4db1fb6d,0xa8372c3b,
	0x7bed0901,0x3f258efd,0xa98b18f7,0x754d28e7,0xdb2568a5,0x314bea47,0xd3697521,0x2c859513,
	0x02234e23,0x9a71e6ff,0xa5c9516d,0x96617039,0xe77bf6bb,0x5fcbfe81,0x3993d423,0xed0d04db,
	0xc0a782fb,0xdcb9e7b3,0x0f178d4f,0x4d599583,0xfb0d0bb7,0xa3bf53ff,0xd70f1bc9,0xc7c129bf,
	0xd4fbd707,0xdf8dcc5f,0xdb99f233,0x11677b2b,0x96a1ad4f,0x53f7ae4d,0x093f3bf1,0xd5130267,
	0x6b1f4e3b,0xfeff48cd,0x97f3e235,0xa43b241d,0xd97905bf,0x59c91971,0x5409b0f5,0x87f77dff,
	0xdd996115,0x39a3294b,0x87439bef,0x320953c5,0xa15303c1,0x510589f7,0x81cb23ab,0xcddd1c2f,
	0xd5679c8f,0x508bf29f,0xc32fda79,0x71832e09,0xaa75fa8f,0xa7fb7ceb,0xc3670971,0x2eb78d21,
	0x6a0d4221,0xe7478213,0x5bd57571,0xc3d9d755,0xafa141e5,0xbf8197d5,0xd041441f,0xecf75181,
	0x418de7c7,0xa3e9ad73,0x77db00ed,0x54bf1493,0x8a15d5f9,0x0ae548bd,0x063bc20f,0x258f5a77,
	0xb06917f9,0x4f05e309,0x74616d87,0x3a67eb2b,0x5197f787,0x2ffd6631,0x89b51e1d,0xeff3a9af,
	0xd9a1f1b1,0xf3abc99d,0x0509a85d,0x9583410b,0x7c69cbcb,0x2717cf3b,0x65933fa1,0x7e11f151,
	0xceb9c86d,0xff6fe07d,0x53f53b05,0xb1437c9b,0xff49fc7b,0x5b070b61,0xab35fa75,0x3c5f3407,
	0xafb5c421,0x62611f6d,0x21c7eb9b,0x235b24c3,0x6d7d57d3,0xc921eaaf,0x927faef3,0xf1cd64fd,
	0xcb13814b,0xaf1396bd,0xe5a15cb9,0xebfb80ef,0x18c7708f,0x213325b1,0x99d3e9f7,0xdfcf07db,
	0xbdd5b0e5,0x3a9b0f33,0xed25ad79,0x95d93909,0x31653de5,0xe591fd6f,0xa61104d9,0xe253d0cd,
	0x9381b867,0x3c85aa19,0x7c751973,0x5623f57d,0xe61dbb91,0x8b0ddb71,0x229dc573,0x8fcf447b,
	0xe61751cd,0xeee7813d,0xee3598c5,0x2c8dff31,0x842f89cf,0x98f9f1c5,0x2157fe1f,0x5933580f,
	0xfe172b8f,0xae5346e5,0xd3838003,0x0347df8f,0x975f8d55,0xc927daf5,0x7aa32db9,0xa9f11135,
	0xf28588a9,0x19d7e5db,0x1405204d,0xcf050085,0x09ed8f5f,0x27e93a07,0xed611f99,0x07fd2615,
	0xc8e3e093,0x330b216b,0x0dd9673b,0xaef94c7b,0x449bdda9,0x34115a87,0x3ef58b99,0x33c59d59,
	0x95337f49,0x7dfd355f,0xb5a57ee5,0x0cd5ce59,0x4eadea69,0xfef1d081,0x5b41b615,0x483f6e2d,
	0x99f72545,0x213f7601,0xb6896de7,0xbcc9518d,0xede3ec5d,0x4c5b187d,0x74a50fe3,0xdadb2039,
	0x682fa77d,0x05e3f019,0x9227b75b,0x1d8901fd,0xc67f7ebb,0xb2a13783,0x2405d661,0x1b8b6ba9,
	0xff5f8f71,0xf77f08f3,0xc0a1fad9,0x38470c15,0x7b454141,0xba935b21,0x88c1b369,0xf4c3d925,
	0xed89bb17,0xc41f1e57,0xd099947d,0xe0b33cbf,0xcd757825,0xff87795f,0x68bd5d51,0x2b7161d7,
	0x6f2ffce9,0x5c592691,0x87313ce1,0xd501a167,0xbcd1ac25,0x4f4df0c9,0x505936f7,0x7f0b0f6b,
	0x8f53bbe3,0xf33f506b,0x000ba91f,0xdde327f1,0xa79b4a77,0xca352865,0xb27befb3,0xc9819c09,
	0x4777937d,0x1e61a32d,0xcd492ad1,0xee893ecd,0x6a9744d9,0x03152fc1,0x087f235f,0x1f45125d,
	0x9f9bf3b3,0xf5d19ea3,0x178d500f,0x44a974e3,0x8107b183,0x1f3d5ee3,0xf24bfa57,0xef4b6d8f,
	0xce43c0ff,0x3423db17,0xbdfb8375,0x886f199b,0x24a96b2d,0xf67df659,0x5641c973,0x23013949,
	0x5873f459,0x5667a951,0x7631ac1d,0xec93dce3,0x6dc3b115,0x3329bf2b,0x8143b20d,0x3e5d31b7,
	0x31a73b3b,0xbc31b29d,0xec55cda1,0x4e436f21,0x7315c6f1,0x7215aae3,0x46af41ff,0x7fcfe381,
	0xdbe797a1,0xc79198c5,0xe305a819,0x55332141,0x69e394ff,0x628f738b,0x206d13a5,0x004b4bd3,
	0x87b30005,0xfd1b9611,0x53675823,0x939584af,0xc5ed47f7,0xe66b3baf,0x4edb6dd7,0xd33f7855,
	0x340bff5f,0x23df1d4d,0x8d1bf6d3,0xa6190b51,0x5975f111,0x31fd2e55,0xf8dde3ef,0x26a12731,
	0xce735529,0x657179c1,0x564339c9,0x53f5a793,0x753d260b,0xec131f0b,0x4bd3f5c9,0x62df6713,
	0x52ed9561,0x6de16f39,0x0b7f131d,0xaed56c5d,0x0889a11d,0x4e0129d9,0x9ba1afbb,0x4aef3723,
	0xebfbc87b,0x8bc1d9ff,0xbff55167,0x32f12d1d,0xc119e0ff,0x43995349,0x82a74aa3,0x1c43270d,
	0x129f0b75,0xd0254edb,0x5d473fc3,0xe6f71dbb,0x2b31c8ef,0x8b2d2865,0x01c9cbdb,0xaec9f6f9,
	0xae5b2fc9,0x2e9fbb19,0xc39345cb,0x7c1b729f,0xd19140a5,0xd58f5eb7,0xa069a539,0x94f73791,
	0x352f5b6f,0x9d3f0483,0xe97d8797,0x6e0f00b5,0x5d7bd45b,0xe6117449,0x8c67551b,0x3bbdea01,
	0xcb9fa8e3,0x3497a961,0xfc2785c5,0x2303dd69,0xb6b154c9,0xb2854fa7,0xba270659,0x0a8d1ff1,
	0x64adc71d,0x4fbb607f,0x7f35bd6b,0x0babfea1,0x2377772d,0x833ddfd9,0x0489304d,0x83599b8b,
	0xe1db9997,0xac3bb927,0x6cc54823,0xc339dac9,0x688d753f,0x130bbc67,0x4cf136d3,0x62936f7b,
	0x332bd84f,0x8a2bbb21,0x557d7c0b,0x2f5d08cb,0xe937ad39,0xaf41c55f,0x9b3f0a43,0xbf2f9ee9,
	0x771dafb9,0xcc1b86b9,0x807b8bb9,0xa04be011,0xc73541d5,0x57afc349,0x3dd7c777,0x2a9dbd81,
	0x1ab760d5,0x171df4b7,0x0b65264b,0xf0b51883,0x02c9ba4d,0xdeab0731,0xe99b57c9,0xd0cf8f6b,
	0xf977e117,0xf2c53669,0x0a5b1755,0xa5cd6a8f,0x9ab5a259,0x09050a9d,0xd9eb1115,0x9837a951,
	0x7d617a7f,0xe9257593,0xa7ffe6f7,0x0f432f1b,0xac3d2a37,0xae0d0f99,0xf0ab55b3,0x41c9105f,
	0xbef76b81,0xa6cd7485,0x457379c9,0x674bff95,0x9321c69f,0xd799c0b1,0xd63b347d,0x88f5da3d,
	0xa539871d,0x1acf2e05,0x9a59b0e3,0xf29755e3,0x09a3d0cb,0xe1f7d0ed,0x197f08cf,0x43abcd17,
	0x05add4c7,0x96bf755f,0xd4d309e1,0x20572c71,0x48872675,0x9bfd9bd7,0x4fd91a7f,0x8261ff95,
	0xc451307f,0xeead965b,0xb9833edb,0xaa3f9e29,0x270dc9d7,0x66f9c579,0x35293deb,0xb00978e1,
	0xf3a9eabb,0x992df545,0xc38be66f,0xb4818675,0x3af981ab,0x56bfda5d,0xcbd373ed,0xb211d0a7,
	0xf4b76875,0xcf4faee7,0x448d13b3,0xedcd213f,0xf88b792b,0x51a3ef8d,0x7cb789db,0x086fcf0f,
	0x96fdc329,0xaca73889,0x84adf643,0xaf57aaf1,0xd285e011,0x30734295,0x3739b993,0xed930cc5,
	0x387d68cf,0x4f45fff7,0xe2897a39,0x1cd10073,0x5a298a97,0xde83d97b,0x9139496d,0x766f92f1,
	0xe5b7bbe3,0xf7bd0b79,0xf347e82f,0x446d3f33,0x5f3b9177,0x79a522cd,0xe71b2c43,0xb2757b3d,
	0x79afb35d,0x291f99dd,0xa287853d,0x3edb6517,0x0ffbf1eb,0x722b9593,0x7bc1a171,0xcb998fd5,
	0xbde77ab9,0xc8fdc267,0x526932ff,0x4f4ff08d,0x192b2dad,0xaae95157,0x988bd4cf,0x264beb61,
	0x8a6111f1,0x3f6b14e7,0xfb930f8f,0x037b807b,0xc60feaf7,0x992dbe23,0xad5b7eb7,0x817b990b,
	0xe59fed7d,0x96f939a3,0x4d251585,0x538f744d,0x20679483,0x64cb2c83,0x70978403,0x16a1347f,
	0x24a39657,0x9cbb9167,0xccc1bbff,0xc23f8bed,0x1075f98b,0x0813757d,0xff1d960f,0xb9a989e5,
	0x0aed49fb,0x0041d57b,0xf6899693,0x7cbd87c5,0x7cfdedcb,0x6fdb9a9f,0xfc4fd2b3,0xf90735e9,
	0xea819a63,0x739fb7ab,0x5d1ff55d,0x7abbc8bd,0x6b3fe979,0x9b7365ef,0xb2116449,0x3daf45b3,
	0xc3e10e07,0xcb658241,0xc9a584f7,0x9e69f043,0x1effa951,0xbcad09fb,0x30c521ab,0xeb11d6ef,
	0x660fbfe1,0x1ea7b805,0x5bbfee79,0xd47b803d,0x3a7bce8d,0x57dbc1cb,0x6f4b2e35,0x7f1fb7c3,
	0x8e8dff6d,0xe6f5b443,0xa98b777f,0x34217b19,0xde797ee7,0x63cd70eb,0x6b0799bf,0xb24d06df,
	0x095df0a5,0x20634ac5,0xdfada223,0x1f1103bd,0xca3b0499,0x69d94361,0x47d900a3,0x9789d367,
	0xd0ff2c01,0x698167d3,0xe149ccff,0x6179fd95,0x7b7f6e5f,0xa5cf4db9,0x70252bbd,0xbc49bd09,
	0x2e775e7d,0x2361b039,0x67fdd32b,0x520bac8b,0x4e8b2f6f,0x25ff2cff,0xb4cbb065,0x487d93ef,
	0xd947e991,0x9197213f,0x23efac45,0xf1fd5509,0x9e21bf85,0xeb3fa6bb,0x6d2f9075,0x1e97f8bf,
	0x17718337,0xfa33b0b3,0xdbbf0c63,0x0cfddbf9,0xe37f3adb,0x08dd48f5,0x9733da47,0xfb89fca9,
	0xdd77d5ed,0xc5c9ecd9,0x8c8f0421,0x593f66c5,0xd66b022d,0xc4af0a3b,0xf73748b5,0x96c7c151,
	0xee5920a7,0x9f699c81,0x89ffa097,0x9773fb57,0x8d275ab1,0xb703e997,0x381fe31b,0xc24118e5,
	0xfb9dd6e3,0x94a75ef1,0x9e358b61,0xb2cf2017,0x9c710e23,0xeaad8e8f,0x0b4d9d51,0x8a69260d,
	0xc541409b,0x35934bf5,0x29d1aa9b,0xe1017bf3,0x378f0abf,0xfd01e92f,0x489ff7b3,0x5631fbf5,
	0x39c91a47,0xb4c193d5,0x43f7c0d9,0xc23b7651,0x5041033b,0x3dcdd203,0x0e7d9f17,0x070b3e45,
	0x963734e3,0x07411f5d,0xda450d3b,0x8133d71d,0xb6cb0ed3,0xcf65aa13,0xe1c50cdb,0x18ebc129,
	0x860b15e7,0x04a72fd7,0xd0dfeb57,0xf31766c1,0x39ed4943,0xc69bfae7,0xcddb26d7,0xc23f2949,
	0x434b974f,0x8703ff0b,0x2267734b,0xb7998e27,0xc6e972c1,0x4ac1168d,0x849fdf67,0x13fd8bcf,
	0xb6758793,0x8ae75f45,0x000119ad,0x58eff6b9,0x89839009,0xb5a9b78f,0x7e75d563,0x19970e67,
	0x968d49af,0x4f675b4f,0xf14b4f97,0x6bc72a61,0x0bfb8a57,0xb3a5a0f3,0x1a3df423,0xf8fb8739,
	0x8915751b,0x7613d671,0xf46b22a7,0xaf553389,0x5713cf61,0x63873e45,0xbd5b1387,0x129f1cef,
	0x420f75d3,0x22ff2c77,0x9e01dcf3,0x2d493d19,0x120ff165,0x76a14391,0xf3b197e3,0x2171e6b5,
	0xa3fd2c4f,0x1cbbd1a9,0x392da517,0x59d9327f,0xa2af4719,0x50c54d5d,0x8f9f1215,0x5ae78c35,
	0xdfdf8d8b,0xec5bf2d3,0xe7951e2d,0x33b35fa1,0x4d358bbb,0x284580b7,0xca09df75,0x8ef3e595,
	0x953b4301,0xfd6f153f,0xc15907cd,0x640910eb,0x54657f01,0x25f12b27,0x624fc9dd,0x48039b83,
	0xf20f4aa9,0xbe0bb6b7,0xf51bde15,0x5e913347,0x197d8529,0x851f62b7,0xbe55a7a9,0xeb0dc729,
	0xd2df96fd,0xbebfed83,0xe7fd799b,0x8179f41f,0x3c4546e9,0xb39fa5f3,0x0a7dfbb1,0xd77f922d,
	0xe2adaef9,0xd29d086d,0x55a1af79,0x3575615d,0xbaf9517f,0x71c17be1,0x59a7954f,0x874fd6bf,
	0xbaf94e15,0x2f392ec3,0x702bf14d,0x0db5096b,0x125fb6a1,0xf25b140f,0xc535305d,0xaeefbf83,
	0x03c9044d,0x8ca5004b,0x0039ed2d,0xe7ed9b33,0x5db7ac8d,0xfabde683,0x8d0d1537,0x5d4d67a7,
	0x939bd61b,0x4571354f,0x84ef2db5,0x0c4f861d,0x76c52df9,0x02b753cb,0x378bb8b3,0x1bdf7ad5,
	0x8f73dc77,0x76af3e9d,0x53f1b9ff,0x4d8d9a17,0x15c99a23,0x549d44ef,0xb1975c31,0x0e95d533,
	0x8ad3e4db,0x1ff3e579,0xb95db5a5,0x28d7a787,0xf18554c3,0x2d43cb79,0x6e8fad85,0x13e12371,
	0xa7bd1143,0x434debb3,0x17d900bf,0xe5e11f59,0xdf3d6611,0xdbf7c173,0x8855670d,0xe4b582b3,
	0xb6b17829,0x0551ab91,0x0885d7eb,0xb6ddb2f7,0xf2af1acb,0xe28d6969,0xdf4defa1,0x348320a7,
	0x56b5c485,0xcd0fb7df,0x7b01743f,0xd87bf44b,0x9e23a429,0x15590e61,0x3a59fa9b,0xd13fdb75,
	0x1547d5d1,0x64197be5,0xd573ab55,0xb1eff5bf,0xd255b7e3,0xbb29a3e9,0x66d927d5,0xc359e1c9,
	0x8e6b6009,0x1683db71,0x147b8f4b,0xf4ebea3d,0x1e8b3037,0xad516609,0x58b1a3ab,0x6dc352cb,
	0x8ca38ba7,0xd2dfd2c7,0xeb3b0eb7,0xbda1c52f,0xd085abdd,0x77a3794b,0x4a41c6f5,0xadefde27,
	0x28ef95a3,0x4a3d16b7,0xe35594b5,0xb2c1da7d,0x14872e0d,0x78718ab9,0xdc6db70d,0xfbcf6405,
	0xead56f79,0x102fb487,0x7ceba8df,0x257f7e95,0x1551be85,0x008d6fdd,0x369705cf,0x89d7950f,
	0xe8535f21,0xbac9b201,0x4ea18f4d,0x318ba65d,0x1c25097d,0x7349c6c1,0x269f5193,0x64f79271,
	0xe5ef9f15,0x029bad73,0x2595e89d,0xdd1b8741,0xb0c5ffaf,0x667795f1,0x40e9e533,0x94a18dd3,
	0x76a7fe53,0xe2b97da3,0x256b51e5,0x38dd372d,0xb9757655,0xc269ec75,0x00555809,0x3ac7695f,
	0x1bfd804f,0xb8b3d1db,0xe84704c1,0x80054c87,0x9af5c727,0xe1f181d5,0xe6472df1,0xb3dd57c1,
	0x65f7fd07,0x649dd1e7,0x9ec77749,0x38437e39,0x58897063,0xb261561f,0x9aa17743,0xb6d17c21,
	0x1315c0f5,0x6907be11,0x3011fc19,0x51cb43b1,0xb3efb4c1,0xd38951db,0x0bc370d9,0x75198a2b,
	0x30572d11,0x0b058f23,0x59c5624d,0x474f74d7,0x4d6f3b7b,0xb7bfe615,0x8e8f240d,0xbaa56607,
	0x394156d7,0x72279665,0xd003957b,0x3e01ea15,0xc3c5b04b,0xc3d3ac53,0xfe6906bb,0x0de9c45f,
	0x37d5a83f,0xc87f1da3,0x5d713dbd,0x25911c53,0xd437636b,0x6f1506a1,0xdd339b3b,0xcfd3ca5f,
	0xe4957fc5,0x5aa10725,0x032f5fb1,0xd833c4fd,0x7a85e995,0x635bbf8b,0x734f1067,0x5bd9adaf,
	0xc683d061,0xb79f6db7,0x18dffc6d,0x3a977dff,0x10f1bc01,0x9cf3aa19,0xef9be199,0x27eb547b,
	0x531fc18f,0xd10944a3,0x6ca3b18d,0x5bf361bf,0x703fd86d,0x8ab341d5,0x877f76ad,0xe47bf56b,
	0x0e6d4f49,0x1af1f7b1,0x631f5929,0x95f5ab29,0x0faf6111,0x2de94ac9,0x96d9c3fb,0x9c7bb7a9,
	0xaaf1ea05,0xabeb0b2d,0x1771a9df,0xacd155a7,0x25053ca7,0x3a69717f,0xc00dea5d,0xd55f52e1,
	0x29a916c3,0x5d07bbe1,0x7b3dd6c5,0xef37bd23,0xc47fb669,0x3687eb01,0x0bfbd72f,0xaf15af3b,
	0xfa170ef9,0xe9d79f15,0x76a52f77,0x565b3e05,0x00e51e11,0x9b1114db,0x0a07e449,0x04138563,
	0x1a4160a1,0x10714295,0x084dc00f,0xa5efd53b,0x0b7367d9,0xf35b1513,0xf0117805,0x8949fe81,
	0x36a58e37,0xb161ccab,0x6555f127,0x8c25c02d,0x53efcc7b,0xfd377a37,0xba7da53d,0xee2b543f,
	0xca49aeb3,0xefbd9c1f,0x195d27d7,0xc1ad1cc3,0xa8996931,0xc8f7db4f,0x4c2dcb4b,0xfca770c9,
	0x3eab0d91,0x5117e83d,0x268b65bb,0x29bb8969,0x5633dfb5,0xd96f77e5,0x8e81360b,0xb9338ec7,
	0x0bcfcacb,0xdd7d60cd,0x257fe8ed,0xf201c509,0x4801f643,0x43edd803,0x915dbdd5,0x82bfd963,
	0xd8377ad9,0x3f87ce1b,0x655bcc05,0xb2af4f0d,0x27c33791,0xd0456c35,0xab216785,0x32bd0c49,
	0x98e3c6b5,0xe443b0f1,0x0bc1a621,0x8e79075f,0x7dbb92db,0x18c72d81,0x98b10471,0x3d1f13a3,
	0xb1590bdb,0x1b43e299,0x34d32ad7,0x5291ce69,0xd0adfbdb,0xaa493d75,0x9d6dd277,0xd059ac17,
	0x1397fc45,0x369b34db,0x1333ca43,0x96a72515,0xc5d90acb,0x241b8617,0xa3391bf1,0xf55902d3,
	0x60213e6b,0xaadb1201,0x100350ff,0xdcf1cccd,0x41019c65,0x580f59f5,0x5a77d7b5,0xaf955581,
	0x05f90d47,0x2f171cd9,0xeae58823,0xb21d6779,0x846971e3,0x6a771417,0x5a074921,0x1cfd9249,
	0x629fd855,0xdcdfd0a9,0xd9fbd54b,0xcd5d1787,0x50d1d0ff,0xf223b807,0x3f4da00d,0x9605f7d5,
	0xe219e38f,0x5045213b,0xa9e9da91,0x30671fdd,0x057b23f5,0x186991d1,0xce2998d3,0xcd9bb54f,
	0x1ee5e76d,0xc7dd1add,0xddcd168f,0x476983e7,0xc02b997b,0xb919d5fb,0x10ff1c4d,0xf1358a63,
	0x0209b0e9,0x44b98253,0xcf4d845f,0x0915a78f,0x7d21c4cd,0x82834193,0x78b1dfd7,0xc8c3673b,
	0xe303c181,0xaa6974ed,0xce893b99,0x16a1ef3f,0x371f3da5,0x157dba21,0xfc9f0549,0xd6b70c7f,
	0xa7d7ef29,0xdeff0871,0x42211059,0xdbbb5fe1,0x0769403f,0x2555edad,0x3aabbafd,0x7805ab59,
	0xe505045f,0xeb0feb2b,0xc73b3339,0xae973edf,0x45bf4d51,0x97e1f2c5,0x9739dbcf,0x041b8573,
	0xfd93601d,0x19a903e3,0x5177d151,0xefe5b221,0xa863ca17,0xa56fe873,0x5d2b8f17,0xecef8cf9,
	0x42ff95db,0x186111e5,0x4af7b43f,0x2ad96015,0x6419a04d,0xf8d3963d,0xdde3e8af,0xdef10495,
	0x154d0d95,0x17474cfb,0xb45de219,0x35250fa1,0x4c21de29,0xcf610c2f,0x914188f1,0xe1131f6d,
	0x02ffa3c3,0xe8ed056f,0x44cb3d7b,0x4efb4833,0xf23d5667,0x18e742d5,0x35a73cb9,0x74c7a131,
	0xe9174961,0x22694409,0x89e3257d,0x430bf1b1,0xc6b14043,0x97b9bb37,0xeff99d5f,0xb6017e05,
	0x1317a3e7,0x3b476a13,0x07c915bd,0x8689f487,0x383dd773,0x00a91edd,0x6b99b0bd,0x7b317a97,
	0x5affad51,0xad9dd15b,0x591b4651,0x5927d99f,0xd423fc33,0x1b09dfd5,0xfa67892d,0x7549cc0f,
	0x49555417,0x15fd6c25,0x4eff4bd5,0xe5176a63,0x6627d33f,0xe0abd8a9,0xb4c7e58b,0x4fbbb819,
	0x35171b35,0x53756541,0x1113b761,0x5f0950bd,0x188965cd,0x9de1ec5f,0x999bd12f,0xd07934dd,
	0x63c9ba23,0xa79dbff5,0x3d7db693,0x2631b715,0x940b419b,0x117da683,0xae4343f3,0xf7f78907,
	0x296dbcdd,0xd683f80d,0x08dbb381,0xe43fe859,0x1ff118df,0x8cd1db21,0x1ea1c233,0x2125ebbd,
	0x088323db,0x46b9a1d3,0x5e53f4c7,0xad67efef,0xc1fb6255,0x13af46bf,0x5d19fcc5,0x217524af,
	0xd2110419,0x21530a0f,0xff853d7f,0x205b39c5,0x5e6bf939,0x7c692e6b,0x428d7109,0x68d92c01,
	0xc5952711,0x71e1d60d,0xa4936d41,0x864d3241,0xd803bd41,0x8fcfffad,0x2e5d08d3,0x21c3ca61,
	0xb113aab9,0x4675a395,0x1c1f202b,0xf2ede64f,0x300732ab,0x2937f08f,0x266dba7f,0x512738f9,
	0x110da191,0xcfa3a8f3,0x6b4b4ed3,0x6471a359,0xa639222d,0x56719f9d,0xf71f28e9,0xf675c171,
	0x3085b28f,0x807d54f1,0xedb9ee53,0xe3859749,0xd8d73905,0x77cdb3dd,0x53534369,0x2b9f5df3,
	0x48fdb92d,0x2e93eed7,0x758b9049,0xa3617089,0xe4a7a8eb,0x60217cdd,0xf46be5db,0x45175929,
	0xa2756567,0x31f73671,0x6b6502cb,0x21b3fe01,0x84e9c817,0x74bd92a3,0xba4d7895,0xf1cfee3f,
	0xb371dbb7,0x853d0409,0xee65f077,0x46afcf1f,0x3361b147,0xcd7175bd,0xcb559075,0x5b3be8df,
	0x40f35515,0xe575e867,0xf42f8061,0x8507d3c9,0x484fe3b1,0x54912f33,0xb46b8ed3,0x454b4531,
	0x7e7dbefb,0xf233ccd7,0x68e7f629,0xf9ebfc6d,0x1a75e313,0xe6f1f08f,0x88ed418b,0x2e71cfdf,
	0x2e115b65,0x4d879321,0x4f2d51e5,0x8d0fd9f1,0x1f15d7a5,0x73dfb3db,0x02bd82f3,0x6f9fc613,
	0xc03160cd,0xbc05b593,0xe021f033,0x10a53dc1,0x09f32e1f,0x1d2fdba3,0xa23fd9e9,0x5c477579,
	0x73dd9a2b,0x44bde6f1,0xab692a29,0x615dd9c7,0xed5137bf,0x5735d2ed,0xce5519c5,0x625ddc3b,
	0x769906f9,0x5143b28b,0xb725f561,0x866be06d,0x59edca3d,0x08bfad47,0xf45f0263,0x2a5148ff,
	0x04677b33,0xcda71c27,0x9ff783f9,0xd181a49d,0x7f0ddfd1,0xab21c6b9,0xa841e01b,0xb715faf5,
	0x87c93f53,0x487b4011,0xb901e487,0xfecf39bf,0x4a713739,0x6a2d63cd,0xc45d2bc7,0x861bc1c1,
	0xb9c1b051,0x12d3f311,0x2be5a227,0x550b13c1,0x885df3ad,0x4435518d,0x89932ac1,0xaf579d91,
	0xc1cfdfa7,0x60416273,0x18c56473,0xc563a709,0x038f3ce7,0x2a0b8583,0xbf458ee3,0x05375f0d,
	0x55f93353,0x66d5b401,0xb6438f83,0x0b890885,0xa54fdf1f,0x1f01bdb9,0xd3571689,0x34b14761,
	0xdabd05c9,0x7f21a603,0x7183e3f5,0xcdb38d9b,0x9559eb13,0x58e920bb,0xfa2b2c8b,0xe535a835,
	0x831f4607,0x44392f45,0x0e231edf,0xbc8f6c37,0x59f355fb,0x6015dd91,0x4ea18845,0xd8b783b3,
	0x70a11787,0xb3ad1f11,0xc64799dd,0xb34f5ac3,0xf7dd9991,0x2f57cbc3,0xf21dcd8d,0x0ba52c87,
	0xd3457241,0x4d91bd2f,0x6a93eb07,0xd7a93029,0x125b540f,0x54010b5f,0x2c812cc1,0xd4f5e5db,
	0x098bc2b1,0x347569eb,0x822784fb,0xb9cb83d3,0x0b2be82d,0x0de3a4ed,0x8c2d02b9,0x06178355,
	0xc07789cf,0x4d6b3e0d,0x6aa356cf,0x74694dab,0x22931d29,0x6f532979,0x060378d1,0x0afd0923,
	0x138dfd17,0x6007aae1,0x782d6c1f,0xccb38619,0x9755bebb,0x7d215289,0x156924df,0x0a194bef,
	0xaccba681,0x365b1a31,0x15658d03,0x525fc60b,0xc6b13d1d,0x4e9da229,0xdc3ba941,0x045d90df,
	0xe4b30489,0xbcf78e47,0xe36dde19,0x7f99e6e7,0x4c694d09,0x2d9d02e5,0x42e154cf,0xf53d2da3,
	0xe24b2a27,0x22ed41eb,0xd9e78077,0xd919a299,0x22bf87b9,0xb66f67c5,0x1839c2e5,0xf2a9285f,
	0xbb135ed7,0xf9d14869,0x66f531b9,0x0e0f338d,0xc2770ae7,0xf7e96c53,0x31a57b5b,0x4d13d7c1,
	0x930bbe91,0x55b32d89,0x8f39ebf9,0x182bf4a9,0x42d118cd,0x9359f499,0x8b09928b,0xaf6d82f3,
	0xbcb7d9d1,0xed279597,0x0dd585cf,0x5b9f0159,0x7991b825,0xdc93cd21,0x66c7494f,0x3f2b019b,
	0xd9195591,0x393ddd5d,0x746d5257,0xc721d585,0x1af55429,0xf9eb4af5,0x6dbfad01,0xbc3d5be7,
	0xf7b38b47,0x9589ba23,0x4b1fc12b,0xf3dfed9b,0xd9c35c93,0x042feba1,0xcf55377d,0xa1136a81,
	0xb68528f3,0x601bd9b5,0x3091fe65,0x458d6683,0x873de59d,0x26b3f52b,0x61696f1b,0x42a57691,
	0x6215d10b,0x1987825b,0xf9e1929f,0x0a5b9da5,0x33234801,0xbf491621,0xc05f86b5,0xf05fd9c1,
	0x1561ba89,0x84dd32e1,0xd2b502f1,0x9affd0ef,0x4bb7c0f9,0x7e43058b,0x6f19fda7,0x14359e3d,
	0xd9ed50e9,0xc7af4291,0x5d2d70f7,0x7aa7bec7,0xbdbb123f,0x867522f3,0xf6f73fc9,0x529b1ead,
	0xc7bbd423,0x8a118135,0xd1e93acb,0x77054619,0x1473220d,0x8d2d1663,0x07dd4575,0xaa81a63d,
	0x254df8b3,0x1693d715,0x200f9b07,0xc84f064f,0x999f9b1d,0xfa3f7067,0x982b3385,0x95591093,
	0x87a58793,0x7a49e4fd,0x0d3f48c3,0x3133ff53,0x75818ca9,0x07fb4a05,0x04c5fb55,0x271569df,
	0xf243fe3b,0xa4c3a435,0x559b179b,0x1ee5318f,0xcedd0a6b,0xe337e4cb,0x310bfabd,0x2e298ec5,
	0xf72b2ea5,0x88150689,0xcbc597a9,0xc9153ded,0xeaf3cc9d,0xcb434abf,0xa6e19c17,0x5385cc73,
	0xd6dfdf4d,0x38cf9643,0x78e1b587,0x51f705d5,0x4d85cff9,0x31f1ee6f,0xb6a9f63f,0x3a9b8093,
	0xa0616b2d,0x0e05162b,0xbc8d5a4d,0xe63d4b35,0xd8d7f5bb,0xdb934ae3,0x97436c8b,0xa15db94d,
	0x513361bd,0xc147218d,0x6ced0b97,0xdd195073,0xeda9a399,0xfef983a5,0x86134ed9,0x803dd54b,
	0xf55526f9,0x8ea9cc33,0xf6a58b7f,0xd83b787d,0x8b3d63cf,0x657904c1,0xe6f97981,0x2a2f23b9,
	0xc74d9359,0x54bb4265,0x7cd3789f,0xe3d7e6b9,0x6f578517,0x8ae322bd,0x6459f55f,0x6ca1843f,
	0x501993d7,0xb48f68ef,0xf91dee11,0x969f1f13,0x3637baab,0xbd87baa7,0x0f1597cb,0xaf890707,
	0x873dc9ef,0x31b97d19,0x5ba1236d,0x31c3a5f5,0x7a9fbc47,0x3e3bd205,0x7e8da29f,0x15578cbd,
	0xf2bb2b9b,0x5249b4b1,0xab050ccf,0xc0f9a049,0xf5d3e621,0x604d36e5,0xf0a36435,0x9aff6689,
	0xc715a353,0xbed3ddfb,0x2469fad1,0x3a6d7377,0x9f93d8f5,0xa9931fcf,0x69bdd769,0x37eff617,
	0x074bb013,0x6267ffc7,0x5b6f3a8b,0x9ed7656d,0xce2119ff,0xf25bcbcd,0xd4b74391,0xfe1d4d8f,
	0xa4e30553,0x8a99f95b,0x5a39b59b,0x19653c93,0x5641b2f5,0x8579226b,0x22f9dc8d,0x39f9cf9b,
	0x9fdb2b0f,0x07792283,0xc1699217,0x1fcbdfd1,0xab33d213,0x404153af,0x6c6162b1,0x9275cf67,
	0x26b71dbf,0x4b9beb87,0xe821d29b,0x923bf693,0xfeb96a15,0xb2817827,0x0f51c2db,0x2905309b,
	0xb679ee5f,0x8c0f7d33,0xfc03f63f,0xdb6588c5,0x6117d231,0x3e8d30d9,0xd0adb661,0xb9970761,
	0x3aa16267,0xe06958d1,0x213198a1,0x107d9ecd,0xe10d6623,0x39374753,0xfbd76323,0xbaa13865,
	0x2d3593d3,0x62b9f829,0x924f11d7,0x1135e197,0xabdd2627,0x09d14d9d,0x82affb75,0x7d1318d1,
	0xb6b3911b,0x4f916d87,0xc07b167d,0xa7bd3a8d,0x2d4b56f3,0x4a2d3e41,0x1d995e35,0x4c5f0e4b,
	0xce1ffd3b,0x260503b5,0x735b57ab,0xa8cb7397,0x2f9721c3,0xe69d1c4b,0x6b77b6bb,0x8e792f01,
	0x58fbafab,0xc7a5ddfb,0xe90d22ff,0x138bd723,0xfb833453,0x3df39341,0x11a91ce1,0xe3cfe19d,
	0x4b495467,0x98859825,0xf637028f,0x31b5d019,0x785360d9,0x41819731,0xdc113501,0x47577d47,
	0xc78b0be7,0x9f35e67b,0x25f95cf7,0xb77789e1,0x4bc73e13,0x951904a1,0xdd13cff7,0x2e81e9a9,
	0x3ec10b27,0xa4c935c9,0xd9f51551,0xe3859067,0xfa21c737,0xaf0d409f,0x8d918b1b,0xa93f3eef,
	0x906f3b9f,0x54d14b59,0x6a4b2b35,0x9f117015,0x0623fc03,0xf82fd8b3,0xeceb7047,0x820565c1,
	0x2a99db4b,0x5d61e4f3,0x45a15ac1,0x9dcb55d7,0x111180ad,0xebcf22e7,0xa10595d7,0x5dc1b749,
	0x29bd1ca5,0x8f0958e5,0x1119bc8b,0x7de7af13,0xfaab3df3,0x37c3ddc7,0x1641bea3,0xdbe99d33,
	0x78ddc6a5,0xfcdb35f3,0xc85165af,0xe817c9b5,0x0135010b,0xdc59d059,0x9f7ffa05,0xb66d31a7,
	0xf17fd4c5,0x1c6be36d,0xdd6d07c5,0xaf8d7425,0xe16f1bb3,0x4c676a2b,0x962343d7,0xe1bfdf51,
	0x7ba11701,0xe5cb4119,0x590f90e9,0xf1f99d51,0xf69b0423,0x8d3d6343,0x7a0d2475,0xacd30159,
	0x2dc9d1d1,0xf38b4741,0xfa5bcbb7,0x378ff4a1,0x5a7df513,0x56ab5c2f,0x11a150b7,0xe1178369,
	0x6cf55e31,0xa2bda6b1,0x56efff43,0x92ff89fd,0x05558dc1,0x33057df7,0x89bf49f7,0xe28181ad,
	0x0ca9c99b,0x32f568b3,0xfaf18f2d,0xc17f6dd1,0xede571e3,0x9f1f1a25,0x95cbfe0f,0xcf81e8cd,
	0x6ee57607,0xe6438f11,0x88ff9b8d,0x4abd5109,0x296fe9b7,0x2a474ac3,0x8fa5675b,0xa10915f5,
	0xa42fb9ef,0x213bb413,0xda3fa0fb,0xa0eb250b,0x0bb781f5,0x9653925d,0x97b32cb3,0x4a8d76cd,
	0x8b85804f,0x8aedaa85,0x1e511893,0x40bfbbc3,0x46fdabd5,0xf7917bf9,0xb4d14171,0xd9fb297f,
	0xf26de8a1,0x2ceb1daf,0xfb5517ed,0xd167679b,0x0c055d15,0xd4d53b25,0xf465856f,0x97c99cb7,
	0xb4e5e6dd,0x9349315d,0xadf1f127,0x44979b7b,0x2a0fafed,0x47714be9,0x8a516509,0x26e72f9d,
	0xdd71e37f,0xec9921d9,0x2945d2d7,0xf67f8ad1,0x2edd8315,0x1b3712cf,0xf0f77917,0xa4c9d1db,
	0xc5115b7f,0x29ebe3ed,0x36f36819,0xcdd3c985,0x86b119cb,0xee797ce1,0x093726f3,0xc95da39d,
	0x334b8057,0x1ed1c4e1,0x971f7887,0x5bc5ebff,0x9c4fbbc7,0x52099fa9,0x3a734079,0x0719958b,
	0x7e1dd803,0xa15f0a7f,0x20678839,0xfc07272d,0xf8f75543,0xe9395931,0x928fa401,0xaaeb08d1,
	0xaa0bdcfd,0xaa259315,0xdfef77cd,0xf4c9f075,0x646d16f7,0x89dbf005,0xe5eddc65,0xfc4b6f17,
	0x8a179e3d,0x74377569,0x395b2459,0x96bf9dc3,0x04f11621,0x5c41b32b,0xef6dc0ff,0x5d25ea89,
	0xdfc35f3f,0x9d25a0c5,0x06c90779,0x5d1b0581,0x7f45ec79,0xfb3d9a31,0x707315ab,0x69ededcf,
	0x7b1137fb,0x45037cf5,0xb8dfd745,0x0d8f1e99,0x16ab5839,0x9421e51f,0x50e12ac1,0x1997dc13,
	0x5a81b4ed,0x2e618a43,0x76bb265b,0xd84ba075,0xcce7dc1b,0x06bdbc7f,0xbf177d1b,0xdd93a8ff,
	0xcb19770d,0xde530179,0x3e0303d1,0x7801a2fd,0x82395f59,0x0567d15b,0x4ff75613,0xc1d378bf,
	0x8857d3d7,0xbc6973df,0x02d79b43,0x51e73e9f,0x1565cdab,0x34effd3f,0x1ee76b85,0x8cc93ffd,
	0xdc3f7543,0x32b56b41,0xcfd9d4c9,0x95ab2c41,0x83abb74f,0x4ca5e231,0xedc37fc9,0xdf6963e1,
	0xbf53f9cd,0xcdcb09e7,0xe629f501,0x5d816551,0x08cdf0fd,0x365f8abf,0x44f301b9,0x55215a15,
	0xf893946d,0x5cbdaa9d,0xdd6f3d01,0xce1bc3b5,0x3f0d33ef,0x2e6b09f1,0x9355acaf,0xa3e748c3,
	0x3d85ac9f,0x111b80ad,0xc3c78a65,0x36a9a1d9,0x3f2fbddf,0xe39f1b51,0x4e4b2887,0xbc2ba697,
	0x52277e5b,0x9ef737df,0x3dd5f747,0x30df7aa7,0xc073f107,0x9749c2e9,0x11b9a999,0xe8e1dabb,
	0x28fdba1d,0x5ce5947f,0xa6bb7a3f,0xc0ef8989,0x389bf421,0x3d3ded43,0xc00190bf,0xef77dcd7,
	0x030924dd,0x63f51357,0x301b8669,0x758b6a69,0xfbeb5267,0x9bcf0f69,0xa2030b55,0x2fe3d515,
	0x8fcd3817,0xafb989af,0x0219ab5f,0x87e3b9b1,0x5d239b93,0x6bcdc6e7,0x8723b333,0xc495bc1f,
	0x0d4bc1c5,0x3e47c553,0x5b53353b,0xfbabb449,0xcd8703df,0x788b79c3,0xe5412eb3,0xa27ffb21,
	0x6803845f,0x302b2c8d,0xb0efcc97,0xbf13d79f,0xfcd50405,0xbfdbf68b,0xf8c1d0af,0xb9130bc3,
	0x5af9d6df,0xe87b5e25,0xce8b168b,0xcad18199,0xf955f93f,0x92111447,0xe4853883,0x12451831,
	0x8fb144c1,0x2cc9d167,0xf64d54b3,0x421390a5,0x4fc3c547,0xb1fb5281,0xd1edf205,0xf2839b13,
	0xbe292dfd,0x4525761b,0x00d50529,0x928b03a9,0x2b656e57,0x74ed7943,0x10dd1595,0xf8c3ff95,
	0xcce3670f,0x1c21548d,0x7d458287,0x946f9a11,0x75fbbf29,0xe2b93917,0x37b5e807,0x3e75415f,
	0xf0e5d8f1,0x5ed12d87,0xd13fa3e5,0xaa6d73c7,0xf7c7e6f7,0xd5b1cb09,0x43597ab9,0x778d8c9b,
	0xcdad211b,0x9cc51a53,0x58e55cdf,0xe1b7b135,0x778d197b,0x1aa590a1,0xb7294b81,0x1279ddf5,
	0x95413187,0x68112cb9,0x86d95d8f,0x12031343,0xda8d2ef1,0x90ebb3e7,0xbd09e4bf,0x582fa295,
	0x281ff0b1,0x75450f03,0x043db28f,0xfd7f9b5f,0x4489440f,0x4a53c769,0x455b7d47,0x8c1f5825,
	0x354bd993,0xbb75a3ff,0xd0b364f7,0x70df2b71,0x37c55a11,0xab2f662f,0x26ff9877,0x0c3b2cd1,
	0x5a459ba5,0x9431a6f3,0x625f1a63,0x635525e1,0xb501f6b1,0x8a4fd3c3,0x3f59a627,0x70f59f41,
	0x4313bae1,0xdb8b4ba9,0xc5dfb4ed,0x16910d9b,0x5b7fc429,0x51099c31,0x9249a2b1,0xad411ea1,
	0xca332fc5,0x1017de6d,0xbe59f32f,0x36c72609,0x89033135,0x1b2d33ff,0x6a33b6f1,0x2e8faa99,
	0x18a90745,0x72e76409,0xe56b1043,0xfaa91317,0x79cd110b,0xd70b983b,0x77f9d83d,0xfcd17353,
	0xc5f702df,0x278b39c7,0xcb3b63c1,0x4367792b,0x689f3b67,0x6579ee6b,0xf2fb6873,0xda79797b,
	0xf81f388d,0x5415b56f,0x166901c5,0xbcb59d2f,0xaebd2c83,0xb9c5249d,0xb91dd5ed,0x64792e39,
	0x83a3b2c7,0x4119c54d,0xa4155ae9,0xfcc50491,0xe3e7a51b,0xf9c59159,0x6ebf3b81,0x32451339,
	0x0b851089,0x79a79029,0xa7e5dc45,0xa4491539,0xfe5f4a65,0x9dc793a9,0x9ec5008d,0xf5cb5aa3,
	0x2145254b,0xeb53154f,0xcbf98f77,0x7e71b58f,0x72e9461d,0x909f3319,0xda8f78e9,0x9b818721,
	0x64e79909,0x062dcc89,0x50f3ba95,0xa0f1ec81,0x54c5e67f,0x4fa1bfaf,0xda0184ef,0x6a590bdf,
	0xa4ed883b,0xdcc9461f,0x2df7803b,0x8bfb8175,0x75b53e41,0x0a9b71f9,0x9b7b317b,0x23c1ec85,
	0xfe5923db,0x4437cadf,0x30a37f81,0x4a3f9c57,0x85fdc49f,0xc3e10afd,0x83e357e5,0x23af5d3f,
	0xfcad5167,0xf409fc0d,0x1d1b7405,0x90f16591,0x345df555,0x70457449,0x7e953e07,0x809162b3,
	0xb9e94ad3,0xa6537377,0xce01d5dd,0xdfc3a60d,0x4e17f099,0x17195fe5,0x1d79363d,0x2b5d7211,
	0xfe913e9f,0x37a76367,0x547979a5,0xa0e56735,0xdeef1b27,0xf22fe85b,0xb8eb3f5d,0x0f8310fd,
	0x61a9efc1,0xc71336a7,0x18213075,0x490b92f3,0x5125be3b,0x8dd930b7,0x8fd3a4c5,0x32f775a7,
	0x68af55b3,0xd62f307f,0xf71f67eb,0x776793b1,0x8d7ba78b,0xe8e9047f,0xe78f9e4d,0xd62726b3,
	0xa7a53c71,0x69090cbb,0x6613ca1d,0x15abf457,0x1b33c955,0x94b177c1,0x2c01f051,0x94099b4f,
	0xe111e473,0x26339fa5,0x901ddda7,0x78070053,0x4011da4f,0xd5038703,0x0f8f8ba9,0x820ddb23,
	0x25f3a2b5,0x76c17605,0x76e3a5a3,0x7d2f638b,0x2057f5b7,0xc031b753,0xab152daf,0x50251e5b,
	0xf5cb80af,0xa6437525,0x128541a9,0xae55ca6b,0xdec33b43,0x5f0db639,0x9dfb003d,0x68c56d9f,
	0x5e9ddc5d,0x02cb7ad3,0x71a58dd7,0x5f2981dd,0xbc9b6f31,0xcce7f9bf,0x2e1f39ad,0x10db4219,
	0x1ceb0837,0xfcedfd55,0xd965c2c3,0xcddf174b,0x399f9a37,0x57956071,0x67e3bcdb,0x87dd2575,
	0xbbb7eb39,0x47bbab77,0xe5671589,0x4329f89f,0x3413a993,0x9f67d155,0x3e2bb91f,0x27bb51db,
	0xb481a0dd,0xf8c50c81,0xa7cf57c1,0x32371443,0x08b70efb,0xb72ddbf7,0xaa594a55,0x84e751f7,
	0x8f4f191b,0xa81d203f,0xc93b9789,0x58bf7921,0xb2cd60ad,0x443d5863,0xcc4d18d3,0x8e55a0f1,
	0x029fb86d,0x9057fefb,0xa8cfbf77,0xdeedf6a1,0xec19f95f,0x9e650721,0x0a6bf977,0xad734a73,
	0x1375f7cf,0xae83797d,0x7c2f36a7,0x7779bcb1,0x4cdb984f,0xeffb313b,0x31938d99,0xe6378aa9,
	0x355304bb,0xe235b911,0x6f7980b1,0x7f91fbb7,0x6bd50135,0x55cd483b,0x9529e315,0xf7116e3b,
	0x6a3b6129,0x0d7fdf7f,0xc553ddb3,0x1ee9849f,0xfe499c49,0xff2f862b,0x2f0f1441,0x78f57255,
	0x62ad8393,0x34efa715,0xf6dbea43,0x67b368d3,0xf7fb1649,0x4df58d97,0xbfa5e7fb,0xff51249f,
	0x9daf76f5,0x9f9b0297,0xd3b73f7d,0x769f9a3d,0xab2b006d,0xf66d0985,0xedcd719d,0x381bc343,
	0x88bf7ac9,0xf715bd55,0xa20712f9,0x92e38b47,0xe89d706d,0x1f6b4d83,0x66edb0fd,0x0bc1dced,
	0x9fe1a307,0x676d1b15,0x3e6dd6d5,0x4e2bcedb,0x1f91a087,0x8241f599,0xfee13279,0xbd3bf0c5,
	0x8d977829,0xbf357823,0x3c0bd9a7,0xa4afb863,0x7dc98f73,0x8ac18651,0xd011aee9,0x09f50e75,
	0x4ae3972d,0x8f81e947,0x0483e68b,0x1d1dfbc7,0x0f87a069,0x773d0cb5,0x5b5baba7,0x49e37629,
	0x3f455187,0x4be3dbcd,0xf7f7e51b,0xe8a94d75,0xdf8f3b27,0x7887be4f,0xa8211a8f,0x8f79388b,
	0x60c34d35,0x6a6bb57f,0x8d097971,0x03050253,0x17216be5,0xd1f19929,0x6449f9f7,0xc7a7d6c1,
	0x53db24b1,0x83ab74a5,0x70dda425,0x5261afcd,0x1e01835d,0xf94d03cf,0x042ff4bd,0xd9dfe279,
	0x8b9106f3,0x72b7500b,0xa7116253,0xc771cbcf,0xba6fb6c9,0xb6ed6d47,0xe2bb023b,0xc8139ddd,
	0x69675777,0x751f56fb,0xa9cb4d95,0x7d674cbf,0x312dbfe1,0x45a3ed1f,0x61490647,0xceb79b95,
	0x5d5d4e35,0x4af7113d,0x89a93c03,0xd9f34989,0x657d7ce3,0x72c1e35f,0x07c1713f,0x84b95ecb,
	0x05f997a9,0x56cf1f1d,0x0dd1e03b,0xad499995,0xf9239087,0xbe179891,0xa481dffb,0xfb8ffb2b,
	0x5039f4cb,0xbdb9d963,0xd3e36953,0x521b74d1,0x6c5f0207,0x79fbddbf,0x6c6dbbd7,0xdf29b4dd,
	0x97a1db17,0x8749f15b,0x6fff22e7,0xcd9b13a5,0x3df5dd1d,0xeb3dac75,0x1ae5daa9,0x95f9a08b,
	0xc6331485,0xbd9110cf,0x8ccb150f,0xef794ef9,0x0b23d203,0x692dc6b9,0x11cd1ecf,0x60f34361,
	0x74715f91,0x8d217a09,0x0b67a469,0x71e9403b,0xafb1d573,0x7da15719,0x79851723,0x7b873307,
	0x095d0f33,0x650ba7d1,0x2375320b,0x199de151,0x65dbc0a5,0x04e7909d,0x60f19efb,0x3ba5b5a9,
	0xda77aae7,0x16e3ed71,0x8317bb91,0xd5c5aca7,0xe667f157,0x4dd54ecf,0xdd717e35,0x31c561ef,
	0x4bc58ea5,0xf6b916b7,0x6eef7b15,0xe0153d27,0x8895e9c1,0x39b9b5b9,0x2ae90929,0x48d3bf03,
	0xefc58ae9,0xfb2107e9,0xe221872f,0xdcbfee3b,0x6227f09d,0x5c67d1e5,0xcbbbc0b1,0xe643e491,
	0xa77b84ab,0xdd2b5dd1,0xae4b72fb,0xfa737bcd,0x6761b125,0x1c33385d,0xa8c7f227,0x0a091ac1,
	0xc2691567,0x386b0dbd,0x9b91ee15,0x1267a247,0x8b03db13,0xd1eba6ad,0x31715767,0x6e957a3d,
	0x1e8f2b15,0xaaf10573,0x88976491,0xc847be91,0xde51c2a1,0xe8e3a2db,0x7b9bb6c9,0xa8d98c31,
	0x4873a831,0xf551cb3d,0x8a7b9f0f,0xaa4b6e19,0xb1090089,0xfeed1b75,0x63a58329,0x4847ea47,
	0x9b1303b5,0x1a9b1de7,0x0ce362a5,0x51212ec5,0xb1711205,0x045d0783,0xac717bdd,0xf6d3dea5,
	0x5ff3e919,0x806194bb,0xf1ef10ef,0x7ffdff01,0x0c4bf8cf,0x5c01068f,0x1f634cc3,0x98ed03fb,
	0xef15d857,0x0eb73f83,0xb2414807,0x4491fdb9,0x8cd7db21,0xfb2d00a3,0xac5d2e33,0x6d87e56d,
	0xcefbc5eb,0x502d4687,0x7cfb8287,0x170d0a53,0xbcd7a3b7,0x89b3c649,0x89bf8509,0x2e139ea9,
	0xd4a5bacf,0x91d78a93,0x57bdb787,0xfa2564bb,0x048da1c7,0x81e5b08d,0x546d829b,0x2e837bd7,
	0x4399747b,0x034744ef,0x3eadfaa3,0x9b0b4d59,0xcabd290d,0x509340f7,0x2fc9c4c7,0x7d4999a3,
	0xedd504e9,0xd68ba767,0x446d1bf5,0x7171a51b,0x94a731c3,0x7513c18f,0xe5b3f5e5,0x03598535,
	0x53dd7295,0x60397c45,0xb21b4817,0xdf878d69,0x260df8a3,0xa135e4e3,0x068d6cd1,0xa423dc37,
	0xc4b35879,0x3763c651,0x275ba821,0x5201082b,0xa1339ee7,0xd94b65fb,0x093bcce1,0x5d99ecd5,
	0x7dd9860d,0x559960d7,0xba4f01b1,0x600f97cf,0xa6d9ca49,0x9425a861,0x6b1fa5f3,0x682f55b7,
	0xcb4f9f4b,0x36ef9fa1,0x179b56db,0xeb67df3b,0x76414505,0xdb195821,0xd01b1461,0x56d3a609,
	0x279bbcaf,0xf9f5eef7,0xa25d863f,0x403741db,0x0d2f9dd1,0x69f709c1,0x228d6101,0x36fbfd73,
	0x5bbb0b33,0x7fbd73a5,0x943beaf5,0x35338399,0x47e3c7e9,0xcf0fda4f,0xb35da131,0xb097ac1f,
	0x9f336c4f,0x8bdbaaf3,0x1d55fc95,0x4b8b68df,0x011fbb07,0x8b370f51,0x59e956c9,0x2619d2b9,
	0xb80515ff,0xe45f0aad,0x844bef3b,0xcef35697,0x32271367,0x31bdb6d5,0x94151023,0xd4730269,
	0x1ab132bb,0x71dda11d,0x46435381,0xf59df22b,0x12bbb1bf,0x88774763,0xa641081b,0xf319dcdb,
	0x0a3d817d,0x5f67b50d,0x36ddb67f,0x0039c183,0x391d5b4b,0xa7b34005,0xbb51c609,0xd3fbb437,
	0xb827f5c3,0x3a8b65c5,0xa03b41d3,0x59fdcb0d,0xba1159c7,0x1a45c847,0x04a5bdc7,0x038b2b27,
	0x64755781,0x135f4b11,0x62ff5b93,0xb89735af,0x48d71b69,0xfd81502f,0xda21efaf,0x68bbd4d7,
	0x7da5e337,0x9c751539,0x164b465b,0x3c39e8d7,0x5731d2ed,0x2135304b,0xda27889d,0x64fdd4ef,
	0xc0b9e9d9,0x4add2d09,0x27c1c143,0x8f992c6b,0x3563178f,0x27b549a1,0x099781e9,0xf4457f9b,
	0x593770e7,0x762b53cb,0xfb85a7e9,0x07e548d7,0x322d8505,0xa5d3a5bf,0xf3d3416d,0xcd03f983,
	0x011fd255,0x786f4347,0x0c359263,0xc4cf2705,0xbad15b8b,0x42e116ad,0xcac13983,0x8029d7d1,
	0x20f15ca3,0xce3b4dc9,0x0af5754d,0xd08df05f,0x7b131fdd,0xd8b1d6f5,0x86bf8907,0x9929c031,
	0xefb1f2c5,0x36a3fe19,0xff6941c1,0x3fcdaecf,0x7d313b31,0x939529a3,0x06af9b51,0xbdf508cb,
	0x92e1ac3b,0xd337b785,0x67b18557,0x51c3ecbd,0x49f39b45,0x125ffa3d,0x2ff5c83b,0xcf015849,
	0x3e8374f9,0x480b55d3,0x586d0a2b,0x901f5517,0x0895524f,0x86617cd1,0x0e73f41f,0x073b45d7,
	0x5517ad7f,0xdbafcd4d,0x9cc376d7,0xef175343,0x9edd370b,0xd36dcde5,0xf4892fd9,0x1c19f91d,
	0x87a3cac3,0x9737cabf,0xd653ee75,0xed59b32f,0xd10d84b5,0xafd59287,0x9b1958c1,0x5d8dca47,
	0xf5a5f63f,0x66335373,0x9d3fb09f,0xb4174141,0x61e37b03,0xc46b983f,0x4189b8b3,0xd605e1fd,
	0x4d21adef,0x36b76531,0xa029b96d,0x37076a65,0x32a5fe33,0xcc7f7517,0xcdb7a605,0x6a77d969,
	0xea99644b,0x19539645,0xc433617b,0x5457dc05,0x631336fb,0xb5e72799,0xec052395,0xfa515a37,
	0xf90f204f,0x6119b579,0x44fffde3,0xf4bb240b,0x71713299,0xc0f3b6d1,0x2f5780bb,0x7f8bbe91,
	0x92051d75,0xc39d6a15,0xd4af803d,0x2b6350e1,0x5a7f82c5,0xa073d245,0x310ff951,0x2e91b11d,
	0xdd7b6bb5,0x78f1d3e5,0xbbe516a7,0x5603916f,0xb97fddb7,0x99bd7203,0xb10d55b3,0x9657cd09,
	0x31f58f89,0x5ba52b33,0xf9c5cbb7,0x3ccdd523,0xe835be2d,0xa49f7693,0xb5b58ab9,0xc0513dfd,
	0x347521ed,0x08cb60c7,0x63ed2689,0x32736be3,0x1edf035d,0x8b6f48ff,0xabe759bd,0x506f6025,
	0xf87d7059,0xfff7bded,0xc683cab5,0x3425a61d,0x94459105,0x0afb7ad1,0x8707f099,0xa5236029,
	0x200f1cc9,0xc339846f,0x04251859,0x099774b7,0x9da3ef5d,0xf2976613,0xe0f789a9,0xf75fdb35,
	0xfbadbdb7,0xf7258e95,0x35f9cc0b,0x64fb091d,0xcebfeb1d,0x4417cd51,0x1a170bc5,0x7a957ef1,
	0xaa577e1b,0x82cbef2b,0xcb9f9ee7,0x03017539,0x19d93583,0x53c97b91,0x7949aa47,0x7cb9a987,
	0x3991bd71,0xafbd9179,0xab39e687,0xcadd4b75,0xefb50447,0xe881e461,0x4bf3850b,0x863b09a3,
	0xc55dafb1,0x4a0fd94b,0x51693503,0xee413ebb,0x5f93b1a1,0x5b91c3c9,0x05f34867,0x7a0d3e6d,
	0x983dfd55,0xc05342eb,0xf151f8f7,0x095fc275,0x37355c4f,0xb8cbbe53,0x61abcd39,0xb5a17791,
	0x4b336359,0x43990323,0x94931d7d,0x42e7aa8b,0x22dd8789,0xde810109,0x7fffb8db,0x30e91537,
	0xe5c15337,0xe773a73b,0x3b51aa2f,0x6c0dcb6b,0xcd4fbb09,0x9d85e175,0x08511d23,0x9e594809,
	0xfde792e7,0xc1f5b4fd,0xfc2d6327,0x208199fb,0xffcb2307,0xd9297da1,0x4881186f,0x8ae1b133,
	0xd829dce5,0x0bb14ab7,0x244968fd,0xe679cba7,0xc2153041,0xa73f5c19,0x54f17597,0x7df3025d,
	0x87898029,0x3fb5bf2d,0x5749d8cd,0x4ea3f659,0x7a6d37ef,0x70190be3,0x28874bf5,0x19819db1,
	0x0d89002f,0x3b9941af,0xaf4b6c31,0x1433307b,0x0d9513cb,0x0e89c48d,0xc4a19f65,0x39ff35db,
	0x7a2bb4ef,0x5f697a03,0xdcf51941,0x3cd9b0f7,0xfecfc20d,0xefe1061f,0x5121003f,0x165b6e03,
	0x0bef6ae3,0xadbb2875,0x4765b29b,0x38c96f37,0x8fdf0573,0x33f13923,0x3c6b2b5d,0x600b79d5,
	0x4fdb0309,0xeba1c5cf,0x2c418755,0x02b5c325,0xe1050535,0xcd0f4ea3,0x5b61aa19,0x62ffbd79,
	0x416d12d5,0xc0ab2359,0xbfa9030b,0x3fcf0529,0x1105ed0d,0xa00b602b,0x0963724f,0x25ab6d99,
	0x6aa98447,0xd6eb0adf,0x4c3f4dd5,0x5fc72e31,0x5d1d8d35,0xa4354fc1,0x48558657,0x88fd2f61,
	0x041135d3,0xfaf5dea9,0x5325ec51,0xbcd177a3,0x4113fa67,0x036367f3,0xe097950b,0x686bb879,
	0x14a59a79,0x3bdb3983,0xabfd5f95,0xbb9dfb6d,0x97292ddd,0x39e3fbc9,0x810d99c7,0xb9e56f0d,
	0x91eb59af,0x0b2d8eb7,0xa4e9c53d,0xeb6153f5,0xb81fa551,0x368b06cd,0xdf197c61,0xaddd09c5,
	0x7fe1ef6f,0x5cfdca0d,0x228b7763,0x25cb3c27,0x9b3702fd,0x7aa9cd09,0xd69bb137,0xcf452fcb,
	0x110b4c35,0xc7dfefd1,0xc005ac9f,0xaf0f2f6d,0xf633ad9b,0x3a117b07,0x89f5d923,0x239118cb,
	0xc66b74f9,0xa4e3bccd,0xeefb180f,0x55dd09b1,0x5d577065,0x7b17c5d1,0x820d617b,0x4aaf2ced,
	0x8f832337,0x2f9b4649,0x178b8949,0x9369a75b,0x63631b15,0x36898af3,0xce3f241d,0x9f15a4dd,
	0xea5564e7,0xa61d9a11,0xb85b8c67,0xab658559,0xb99921e5,0x77bb7073,0x24730761,0x55b329c3,
	0x03613c85,0x68f55e6f,0x86890a07,0xcc036111,0x4fbd3d8f,0x7c7f84df,0x01079e21,0x9dfd7549,
	0xd5ab410b,0x1b39722b,0x8dbbe73f,0x2df3d871,0x740f0b4d,0xd529df3f,0xc6ddc7b9,0xc1e1f19b,
	0x4ab53df1,0xc27b8c91,0x500fa5ab,0x346909df,0xf353acd9,0x84873f1d,0xdf595001,0x45d55961,
	0x5a81d331,0xe6cbdd69,0xe62b0365,0x8d173447,0x38c7686d,0x1fedac83,0xda5d8f53,0x08c957c5,
	0x2b911547,0xb2bbacff,0x1f2f9b07,0x502d5713,0x6e3148c3,0xef2d17fb,0x8e490a89,0x642f2873,
	0x32e72d2b,0x135ffc1d,0xa0bd83a9,0x205fd22d,0x9bd3bd15,0x0c99fa91,0x380112ff,0x4bf93793,
	0x5403f859,0xd847240b,0x06f7f0e7,0x4adf05ff,0xc86d391d,0x8501f5cb,0x9ae7668d,0x6e9bc1d1,
	0x00e9a8cb,0xd3877697,0x047fd2db,0xe75ff373,0x1941d515,0x77bb73b7,0x20dbcf8d,0x55037455,
	0x5a1b64f9,0xf9afde05,0x8277761f,0xf80fdbf1,0xf211edb7,0x369746dd,0xfa3fc4d9,0x82a70ccb,
	0x4e9be7dd,0x81d37d25,0xc08323cb,0x89a3e167,0x1521c43f,0x65e74a47,0x3df909cd,0x9579f959,
	0xbbeb20f5,0x05834f3b,0x74c1c17d,0xd34ba63b,0xc3311e63,0x1c7b017f,0x09654e41,0x65e7f8af,
	0x8e0dd435,0xa0d1c817,0xebd5714b,0x56bded5b,0xdb83e65f,0x03a93891,0xa06bce8f,0x26e5b9f1,
	0xdf813a1b,0x125173ff,0x28e331cf,0x00273a2d,0xfbdbcaed,0x7741a403,0x8d69f393,0x85e77ccd,
	0x194b9fa1,0xdb1597bf,0x058b7e27,0x463b709d,0xa079df47,0xa59380e3,0xc141f2a3,0xcaddb16d,
	0x12ed063f,0x5eadd0a1,0x51edede9,0x4a2f7515,0x441f3b29,0xaf7534b7,0xb3576d9d,0xf8399877,
	0x3269c3f1,0x032bb46d,0xf4afd531,0xf7b1cc7f,0x80119ac9,0xc835ed8d,0x818d12db,0xeaefe31b,
	0x8c41232f,0x5123716f,0x0af1e499,0x24f53c45,0x2c0ffee3,0x55a941ed,0x10433d33,0x7a6d52fd,
	0x037502f3,0x13a56e6f,0x0855c93b,0xb2ab6a4f,0x7e5b4cb3,0x101fd0e1,0x2a5d9403,0x98a95a4b,
	0x698b76b9,0x7845eab9,0xd6fdccaf,0xac077d0b,0x2bb9edef,0x226be1f5,0xa13bab23,0x7213bbaf,
	0x9e81667b,0x2f139e17,0xf78b7511,0x66bbbb5f,0x876970d3,0x49e1052f,0x6cc1a2ef,0x8d9d2a4f,
	0xb0db2eb1,0x8aa358d1,0xa12124fb,0xa2f92cb7,0xa32d2819,0xf64fb31d,0xcb51c83d,0xecb9e9d9,
	0xfd9b4057,0xa005a3b3,0xe161bb85,0xab7138ff,0x6f49cafd,0x6a09ecc5,0x61cb346b,0x2b5b6e77,
	0x5041c0e5,0x66cb6007,0xbc6d344d,0x7557489d,0xda7d1535,0xd9e1dbb5,0x5b936d51,0x9ff3fcd1,
	0x02d32a57,0xd9096795,0x4ce94769,0xc05d647d,0xf20b66ff,0x8d2971f5,0x8a89054b,0x7b734a11,
	0x1dcfeb25,0x13512ca9,0xe3f30975,0x36b5d609,0x01b56511,0xfdb30a0f,0x87113b2f,0xe94d1be3,
	0x7839064b,0x74b15a0d,0x29318b8b,0x8d0fc729,0xb3bf98a7,0xf7d1070f,0xd00b9a5b,0x2f73e86f,
	0xd793b341,0xbec17309,0x3ac17b43,0xa29fe24b,0x30eb0f7d,0xba55747b,0xeadb9aa9,0xce59765f,
	0x0fdffe03,0x358f7369,0xcd49c2b9,0xa115f257,0x4077fbc9,0x1691a661,0x8363406f,0xa0ef7cdf,
	0x239f670b,0xbfad6f75,0x4be92887,0x1ca782b5,0x68295449,0x9057d947,0x8c03bc8b,0xfca74399,
	0x63d3834f,0x062f33fb,0xf841efc7,0x34037f51,0x0c417433,0x7df9d23b,0x5d9f0c55,0xd17342b3,
	0x90019c4f,0x94a5e63f,0x0a777813,0xb05bd497,0x8f83bb45,0x28497ec5,0xd79799a7,0xc9c5c2db,
	0xf6275001,0xf921a411,0xd12bdd83,0x25650f6d,0x732f2db5,0xea9794ef,0x7fcfdadd,0x6a917d3b,
	0x92c930df,0xe43723b7,0xd17f98b3,0x114ffd3f,0x77071441,0x52b93343,0xa2a7f2cd,0x33473b79,
	0x30e765e5,0x48f953fd,0xe7171ebd,0xfccb4bf7,0xb94f9c1f,0x40ff80cd,0x730350d7,0xbdd977c5,
	0x8a074a8b,0x7cf7fc2b,0x64118139,0x9b0f29fd,0xd6c7770d,0x08394d13,0x2a4550cf,0xdeb9fcc3,
	0x66290ecd,0x58435c0d,0x31110e45,0xe9c9e63f,0x0ab17b41,0x8dbdb023,0x284ddb13,0xc4d985a1,
	0xbbcd5725,0x5571cbed,0xed39f077,0x512d9025,0x4ecf4379,0x6959aa85,0x137f0479,0x19ad5e09,
	0xcff7dc8b,0xb1935c93,0x0e2dceeb,0xc3ed9797,0x7b65ceed,0x0563c543,0xf8bbae61,0x21250221,
	0x56290c79,0x8c37774b,0x000b6d39,0xdf396d01,0x67332155,0xbea9b1e7,0x6b65269f,0xd9b3be99,
	0x9065a8eb,0x07757ddd,0x45794b7f,0x0ac5214f,0x077de2ef,0x047fea7b,0xa55fc791,0x1c495095,
	0x6f2b685b,0x67d96a95,0x97974653,0x98c305e7,0x90030073,0x78b9518b,0xa709980f,0xbc5b85c3,
	0xb18195c1,0x3479703d,0x060736d1,0xe5e34cb5,0x93074b19,0x0fa5d21d,0x5747eb73,0xa7d7dc4b,
	0x04e5b097,0x56e79a1f,0x16e99293,0x7959a823,0x214d189f,0x3017ffbf,0xa3790197,0x073322d9,
	0x255b0cd9,0x3b336c03,0xe6e30bb1,0x24d7eb1b,0xea13e33d,0xd361b679,0x9f83a6d7,0x5d5f1895,
	0xfd657301,0xeff18235,0x491530c7,0x248da905,0x5b21e9ab,0xa555bad3,0xa5c5d40b,0xa7cd0d2b,
	0xc603c007,0x462f317d,0xe7210cef,0x3f31d5cf,0xc0b3cf27,0x244559dd,0x77234e8d,0x7e7180c3,
	0x26bb8567,0xf1852727,0x612bc7c3,0xe5f165df,0x658f3b69,0xc103091b,0x5aff4839,0x33b9c407,
	0x558ba919,0xa80108fd,0x6dd1455d,0x547fee23,0xb2f57aab,0xfee10699,0x3f39ff67,0xf49b9823,
	0x36f90599,0x42351547,0xfa37c655,0xb1114401,0x50a91da5,0x93b1f8e3,0xd8355ef1,0xe887cebf,
	0x7e0309df,0xdb35c2d1,0x49ff87c7,0x2c551d65,0x44e99995,0x87c58eff,0xc0d39e31,0x5171ea05,
	0xcc2b5965,0xf09160e5,0x174d634d,0x217db0b9,0x147de833,0x55ef207b,0x9a77e103,0xabc7bca1,
	0xd1776c29,0x825db74b,0xb2bf6eff,0x363f54e7,0xe2a127b9,0x0b814d5f,0x2d01d7bd,0xce7f09bb,
	0x6c672e9f,0x3329a64f,0x237b9d7b,0x7ac92159,0x911b3ae1,0x684b9e35,0x86d55f3f,0x0b0924ff,
	0xc9fba1c7,0x6807c6b9,0x47215dd7,0x89cf8df9,0xe02b68e5,0xfea32407,0x1cd520dd,0x4d579295,
	0x85b77b15,0x688b09d5,0xf1d33baf,0xa881132f,0x8e93fd7d,0x53591861,0xea613275,0x3bdba727,
	0xc99dc489,0x7ec7596d,0x0e317f1d,0xe695c9e9,0x7997e8e7,0xfdbd7d49,0x915db65d,0x578727e1,
	0x6e2f7c97,0x174b37cb,0xbd61ccb9,0x3e390b8d,0xbcf75fdb,0xc7a5bd4d,0x7a297b75,0x1bcfea6b,
	0x1a6f363f,0xe1295fb7,0x7703c59f,0xb41f1207,0xd2f77b93,0xcd5f4b75,0xf3a99d11,0x1ea374f1,
	0x63ddb8f5,0xedf5647b,0x293ba769,0x777d97c1,0xb457d9c9,0x9dc14349,0x533f230f,0x30759e1b,
	0xee7da0b9,0xd1bf51e5,0x58a7ec31,0x020177a5,0xf8593cb7,0x5a1908d9,0x14cba1c7,0x7c372d13,
	0x8cd3fe01,0xc31b4c3b,0x406bea8f,0x37dd4d1d,0xf4bf2b17,0xd63be8a9,0xfaafda13,0xa75d7985,
	0x5fddf5c7,0xbb193047,0xf22975a1,0x87c71413,0xddcd9023,0xb87bb7c5,0x2dd1594f,0xf1d70b99,
	0xf71d6187,0x954d3357,0x76057cfd,0x0aedc8f1,0xe6435b95,0x99a773b9,0x5d8d1951,0x56153bfb,
	0x70996f39,0x2fc78331,0xea9dacbd,0xa50308a1,0x5f6321a7,0x2513e28b,0xdfcb2077,0xa90fd3d3,
	0x98cf4159,0x8b1be61f,0xa5170d7f,0x243bb08b,0xd8f1bb13,0x389132c9,0xd0e9219b,0xba31accb,
	0x0ac58edf,0xea595aed,0x5111a459,0x61457e9b,0x412de513,0x04759b7b,0x33c91c13,0x736f510f,
	0x4ff94347,0xf313b8e5,0x10b112e7,0x5f55b13d,0x04dbe161,0x2b8dfc2b,0x11d1fbbd,0xf93d9b47,
	0x006f1e8b,0xcd5d4fd1,0x9c973743,0x6c1ba757,0x2f391637,0xe32d7ce3,0x9add38f1,0xca8b569d,
	0xe2a75523,0x43c787f9,0x63e5cc07,0x3fcd8055,0x8a0dae4f,0x13272e2d,0x4555788b,0xe0cbdebd,
	0x0ba73009,0xe3658229,0xac3d084b,0x1d19bc21,0xbd9938e3,0x75cda915,0xee152be1,0xcfefbfd1,
	0xfeedacb9,0x1bc9b7a9,0xb1c13fab,0xf133db25,0x709b49ad,0xb7efaf21,0xf88530d1,0xe66b567f,
	0xce7f1d2d,0x5f019a45,0xc7138241,0x73cbfe4b,0x685918e9,0x98e3ca5f,0x6e8371b3,0x4d2f6ff5,
	0x3adbc7dd,0x41a33447,0x75553ca7,0x471586fb,0xa895234d,0x0a79ed57,0x20738563,0x27ade9dd,
	0xd30587c3,0x9ac1c877,0x9c29d7f5,0x17c3b723,0x938fca15,0x51031313,0xc5354f39,0xb3d7525f,
	0x147d6c5b,0xa3eb7221,0x91b359c9,0xbd075129,0x0a09f2fb,0x2351df1d,0x1a2b9f0f,0x6a1f8825,
	0x8b49599f,0x1935c50f,0x42910439,0x589137f9,0x8b45a839,0xcab93d81,0x033bd13f,0x1d795a59,
	0xf1e7a807,0x592f6d89,0x51e9f5df,0x76950eff,0x5507b88b,0x430b02c5,0xaac36ea3,0x1b5328a7,
	0x515dc48f,0x84ebd05b,0x3959c9d9,0x2dc5da21,0x838f5727,0x5a978bf7,0xa1a5cc97,0x4ba38339,
	0x2129d0af,0x9ffdaacd,0x690737bd,0x3f539dcb,0x319fbbc9,0xd2335e9d,0xff45acf3,0x50dbcab7,
	0x674f4261,0xb075b2ab,0x6793b3a7,0x36effee5,0x987bc2ab,0x7d2dc8c5,0x8185de11,0xa7e9d04b,
	0xd84f8421,0xdee7363f,0xf21d0e31,0x8acbe2dd,0x2fe38c89,0x615b80f7,0xacc5dacd,0xc841759f,
	0xf72f94e9,0x9665bc53,0x1c4b1475,0xbb9d0f9b,0xce191e99,0xd70b463d,0xebe96a7f,0x43d74cdf,
	0x356da831,0xa47da42f,0x703d300b,0x7493cb87,0xc7e10297,0xa9118023,0xb0514101,0xe71b38b5,
	0x130dc5f5,0x5945c59d,0x0e95070f,0xab617d8f,0x107be6bd,0x34c1deaf,0x91e19ead,0xd8ff0c47,
	0x3e916aad,0xa74f10eb,0xce751c1b,0xc0394d19,0x59a93dc7,0x89e9fa6f,0x6efbf05f,0xbaf72b45,
	0xb4fb2755,0x43ab2edf,0x5d816e49,0x9dcbc211,0x33addeeb,0x8addf469,0x8c7f6f6f,0xc8f129d3,
	0xe1cd4165,0xc5ed20c5,0x5fd71931,0xd94b64e1,0x2d4ba5e7,0x0c6f162b,0xb5d1c1b7,0xf9636c9f,
	0xbf0752d9,0xc825e065,0x901bf4ef,0xd26b5e73,0xf3c512f1,0xf5f171bd,0x5cd19991,0x1d3dc8d1,
	0xf52fea29,0x06e5000b,0xdf71361d,0xd35b1831,0x72d9eac5,0x613581a9,0xb9e355d9,0xfff12415,
	0xfb432a51,0x81414a7f,0x95770dd5,0x30d1dc05,0xf4cdd69f,0xba8dc8fb,0xebe7a1e7,0x87731493,
	0x36c76ac9,0x98c9630f,0x705349af,0x69f97459,0x42630435,0xe0cb7339,0x18411595,0xd43180f7,
	0x1bbdd78d,0x3191657f,0xc4a5f3c7,0x488bcc15,0xc2d9c5c5,0x4541f471,0x8ad3d53f,0x61214067,
	0x4ca51115,0xd229861f,0x9d8df2b7,0x00b58ea7,0x9bf53205,0x0bc1a929,0xd5fd31bb,0x23b3ba93,
	0xba85cc5d,0xc3a5b1b5,0xdcb1a999,0x512bc7f5,0xd1f7c433,0x2a9d766f,0xf2a34867,0xabd9879f,
	0xc4db72df,0x31952d8d,0x5a319807,0xa31f846b,0x67a3fc05,0x8aa769cb,0x6025a31d,0x44071039,
	0x59abc293,0x4a0d376f,0x04affa19,0x2a4170f3,0x7e39fdb9,0x272f5947,0x4467d833,0x112b2d8b,
	0x15776df3,0x5d9da5a7,0x014d686b,0x04c57af7,0x757b3205,0x2e0b836d,0x8bc92a87,0x32bbc93d,
	0x6341bbfb,0xff5786ff,0xcbad7817,0x5b5d7061,0x0bade627,0x1f8b2f49,0x092f2971,0xe2a77d79,
	0x9c892823,0x24cfc2bf,0x55f15ab5,0x813b9f9b,0x7d8febd5,0xee7f4c61,0x95fb50cb,0x956134eb,
	0x29550267,0x4617b8b3,0x28bd7e63,0x140f778f,0xa663394d,0x203d12c3,0x320da8f1,0x19ddcabb,
	0xa0230f41,0x7dbfe125,0x832f2db7,0x1c0d27a5,0x1feb8945,0xec93a2f7,0x23c966bb,0xb989aa93,
	0xe5f727a9,0xa8d96cdd,0x7aed2fcd,0x2be53fcb,0x626bfafb,0x5dd7a607,0x18118b83,0x585b709f,
	0x4e53d919,0x86f9e527,0x1c15683d,0x80cd5067,0xe4a3b227,0x70d7ed7d,0x42438525,0x94c38987,
	0xbb39058d,0xda2fcbcd,0x894d7725,0x22738a65,0x3bd77701,0x34e71363,0x7c47cdf7,0xe7b3d275,
	0xbd2b837f,0x870f3b17,0x1bb3591b,0x03095f31,0x3bc75647,0xebdb1a45,0x667b8cd7,0xc49f3915,
	0xb329bde7,0xb4a985d1,0x82ed073b,0x1f4520b1,0x16b54131,0x2a010d29,0x87c3351d,0xb9755b91,
	0xeab7543f,0xec8fd743,0xe51b171f,0x9e55a14f,0x7d65ad77,0xf62d9f9d,0x6d7f26a5,0x8eab288f,
	0xbfd7ba83,0x3ad7d339,0xfedf5adf,0xf1edd3f9,0xbf153557,0xe9b1cda9,0xcb934dc7,0x67317f3f,
	0xbd0bd92d,0x4e0d35fd,0x435b8117,0xf63d6c17,0xe98d3789,0x505f7bd5,0x9c5fc35d,0xe07bcf45,
	0xbb55ad35,0x97477457,0xfc31b4e1,0x11f97d93,0xe9097745,0x48891731,0x40c76cc1,0x3277b8cf,
	0x0235e817,0x6a155b93,0x69833dd7,0x56531cd5,0xa84fbc49,0xe3013541,0xa02d9bcd,0x4f9bac85,
	0x67b18fcb,0x1c8bb17b,0xe1f32013,0x9efdfec9,0x309f72cd,0x43193411,0x4871aedd,0x04d78b93,
	0x70479ecb,0x273bd457,0xf2a5bc2d,0xb22718db,0xc9bd4b8b,0xbea3da2d,0x8df7b0c9,0x199d47a1,
	0x6efba415,0x45335af3,0x7f376f41,0x608540f1,0x19e7dbbd,0xfdf1f69b,0xab9ff8ed,0x6fdf82d9,
	0xa54f631d,0x940bb499,0xe1cf32e9,0xa549cd77,0x45e33d1b,0x1bd500e9,0xe2cdcb1f,0x240f2fe7,
	0x634573e1,0xb3cfc911,0x0b0b3d3f,0xc6253557,0x10f3ade3,0xc5a1b91f,0x9b61f7bd,0xad2131f5,
	0x275de2db,0xe71598a7,0xa211a0db,0x7349affb,0xfcd730cd,0x5b25c7c7,0x83bf7b9f,0xfc85fca9,
	0xbe9bd103,0x32efdc25,0x247fecd9,0xe769d54b,0x69d12d13,0x0eb75deb,0xb0c9201f,0x9e2d3431,
	0x648313d5,0x7eeda4d3,0x067bccd3,0x07b53db5,0xb6a30e6f,0x0527d517,0xbddf1b19,0xd88b4d37,
	0xe313d549,0xb521fc7d,0xd2a5a8e3,0x83e1221f,0x6091e51b,0x75c54f51,0xece5aee5,0xcc932ce1,
	0xb2cd33db,0xe21f856b,0x4a1f45a1,0xf61ffbf7,0x235b05d1,0xca675727,0x463bca5d,0x95b3c8df,
	0x1ab7e283,0x54f91a69,0x848b6429,0x03212523,0x1945a9c9,0xbf5b7fa1,0xb8c5a8dd,0x69e1c755,
	0x504fc8bd,0xbf3f6ec1,0x100b6215,0x7a17780f,0xdb0d8ec1,0x83770447,0x39e5723b,0xb98d1ef1,
	0x979ba283,0x5503ae3b,0x1141d97f,0x74b5efa5,0x9ffb96f1,0xd8096927,0xe57bdad5,0x4fabb6dd,
	0x6319a04b,0xecd91d23,0x635140ff,0x772d474f,0x5dcb6913,0x30e71acb,0x1debc385,0x71a906bf,
	0x73cd0715,0x1fd1b843,0xb7d98bb3,0x90319af7,0xe8c31061,0xd45f0e39,0xac15d9a1,0xff7db6c5,
	0xf939d057,0x697fd4e3,0xb6fdc931,0x78f10707,0x13a39c95,0xfb4560ff,0xdf5d3707,0x93973f99,
	0xb15d4a0b,0x47f3c0cf,0x1f61c595,0xb5214867,0xcfadc1e9,0xf0ebf923,0xada3020f,0xa2e98a63,
	0x08bfb6ad,0x5bbf6251,0xe623a977,0xb2f15c85,0x4ca57917,0x33232533,0xd34b0d93,0x9ce590cd,
	0x3a5ded35,0x87f7d831,0x56e999f3,0xeb172147,0x18cb9f59,0x92413c37,0xf33778ef,0x0b7ffd03,
	0x6fbbf91f,0x122d19bb,0x33d358a3,0x00c1f519,0x40e19669,0x51133db9,0xb6c74ffb,0xb325c9ad,
	0xe0dbba65,0xc27196b7,0xd583e3a1,0xe1a156e7,0x702be481,0x44ed71c3,0xeddd2b11,0xb2cde1f7,
	0xf43f857f,0x0355d771,0x4b191587,0xe5ed8617,0x1069d45d,0xf5a108df,0xaedfcf0b,0xa3e7c187,
	0x5ee7c367,0x01ed1cb3,0x7a3b456d,0xf0532295,0x69df1533,0xbd81bc19,0x76abcd45,0xba67148d,
	0x44599199,0xcdc9ffc5,0x3f09e6ef,0x8e07ccc9,0xc34b5abf,0xe95d6cf7,0x48a32397,0xe4bb57ad,
	0x5693620f,0x78fd1273,0x8c272a27,0x16b9c5a1,0x81f3fd3b,0xd88bc587,0xceabdc5b,0xebd97815,
	0xf6199b41,0x38197f07,0x8ab39baf,0xcc9d8e85,0x49999961,0x1cdbd851,0x7925ae6b,0x9331736f,
	0x51ed3829,0x8231a849,0xba51c4a1,0xfc65895d,0x1c7bb06b,0x9a9fc05f,0x9ef19d23,0xb8b5f7e3,
	0x87916843,0x30d5c985,0x1123ca95,0x1d439897,0x7b5f4813,0xa8a9413b,0x9d73985b,0x74d7041b,
	0xc3052f89,0xa0179685,0x1bcd0fa7,0xf0e7bf19,0x85878a95,0x304966ef,0xf88b1c6d,0x3a8b8743,
	0x5ecf0673,0xce8bdb91,0x1d6dd26f,0xa385c04f,0x18b166a7,0xcd552607,0x7a9dd235,0xf7410103,
	0x03ed79fb,0x7d431d75,0x2fa9ce0b,0xebcfc023,0xf1232f85,0xee1bfb8b,0x54892f0b,0x32eb2185,
	0xc9e3cb9f,0x4fcf397b,0x629fda11,0x2af5e2ff,0xc99f3ce9,0xf3718d03,0x3db314c9,0x2ffb6975,
	0x56b39153,0xec41056b,0xdcf58a9d,0x8cabedcd,0x7b638b0f,0x50a5487d,0x93fd71c9,0x0b63c9fb,
	0xfedf5595,0x1b2def91,0xfbcbd049,0x2723e5f7,0x1e355aad,0xab8d0481,0x7bc7e0e5,0xdc9744c3,
	0xe567375f,0xe7a39eb5,0x72c3982f,0x1b0fb167,0x2857d0ff,0xfc77a019,0xfff54979,0xd5858bf5,
	0x1bd18a29,0xbf379223,0x6bff6be7,0xb39fb685,0x8e8797bf,0xae37a2d1,0x31e77f5d,0x62a3a23b,
	0xc21b75ef,0x91f9c1a5,0xa821118d,0x86877c3f,0xe40b7d29,0xbe21dcaf,0x4981e2ed,0x4ae37ac1,
	0x26c99729,0xf27d3d83,0x9e4b2bbb,0x93f949fb,0x7aa513f3,0xdc030641,0xc52500ff,0xcfb3992f,
	0xe6dd9ed3,0x35d3ce89,0x9c1fd98b,0x66a5c7a5,0x8293535b,0x8a31608d,0x89b332f1,0xcd09b1af,
	0x0dd7f265,0x938d9601,0xe5c15695,0x33bf9da7,0x2a9b3717,0x3d7d5521,0x028f3e9b,0xd95348ed,
	0x35bd4bdb,0x45bfadb3,0xd5cf9af5,0xfaf914eb,0xbfff5f63,0x7d391605,0x4199f659,0x65875413,
	0xa70d59ad,0xa8fbc7eb,0xfd6dfb45,0xa683b6db,0xce7db0fb,0x03373dc3,0x1f35d903,0xdd17d8c7,
	0x78cb5ed7,0x5c51cf73,0x443fc89f,0x2b11ed61,0x405bf515,0xdbc96f67,0x5a43b1f3,0xc5f18d37,
	0xb079d2d1,0x61538793,0x0863f09b,0xa7d5a2e5,0x7e59796f,0x85c1f677,0xb8273903,0xe089780d,
	0x62190197,0x3c152c17,0x3e7f9d55,0x8681e255,0x8fbbb03f,0x127166ff,0x24c3b28d,0x47d39071,
	0xd02daba1,0x13271147,0x91b3d567,0x9b457717,0x3a41d041,0x45ab3d8b,0xd2778f6d,0x913f5e0d,
	0x8bb5a5eb,0xcf9d43f1,0x83a11beb,0x44d58d19,0x222d74b1,0xb5c17f23,0x5a270cfb,0xecbf990d,
	0x943579ed,0x3d072959,0x8c6b107b,0x8c6350c1,0xea433d45,0xeb855951,0xdb33d511,0x44c7ca19,
	0x77b105a3,0x29771f4f,0x3ab30f2f,0x459f8efb,0x53c36e3b,0x8247c21f,0x1b7f9e0b,0x5e45ea5b,
	0x72a51b87,0x85811c19,0x539bd0a3,0x2ebd5531,0x5e6f9049,0x47dd1817,0xa76dcac1,0xf8af037f,
	0x90192291,0x84374e81,0xf2c509f1,0x106f914d,0x688b10ad,0x5c97c245,0xf1dd0a8d,0xedf5cfad,
	0xc98db63b,0xbb29bdd5,0xaa530cb3,0xdde5b1b9,0x4ed5e11f,0x5345d02f,0x7431f949,0x528b5991,
	0x27014681,0x4269e9db,0xa2e76701,0xd4d5455d,0x8c9517d7,0x513d99e3,0xce4dbf51,0x955f9c53,
	0xdefbb7dd,0xd48b6add,0xbba58377,0x9d6d9ba7,0x5b878f93,0x2e4d5fe9,0xe693b17d,0x9fe7239d,
	0x76790345,0xeea191a9,0xaa2b492f,0x6a5f647f,0xd3f18789,0x94cbeb4b,0x09e5f127,0xf611ab9b,
	0xe0ffd639,0xf0390785,0x1a9fbbc3,0x18df504d,0x0c934377,0x21852d93,0x0ba30c29,0xd653c0f5,
	0xa08d32af,0x3b6b6e3b,0xcf9f9b4b,0x509faffd,0x3ab1ab95,0x83cfe0cb,0x65af9cdf,0x599f60d7,
	0xe5a90f21,0x54c30017,0xc2510463,0xa3d114f9,0xd20bec9b,0x9d7d277d,0x586dea21,0x936398e9,
	0xaf51f68d,0x03572fe3,0x42551025,0xaf27f12b,0xa4e317c7,0xa2dd2cb5,0x0abf8749,0xb1952755,
	0xeb0ba867,0x70b948e9,0x15cd742b,0x39d136fd,0x03fbc2d1,0x3ac3c3fb,0xaa05f431,0x1ca51ac7,
	0x94d5b8ad,0x48f90ef1,0x995b228d,0x5581f959,0xde97a7f1,0x9e810957,0x8a233d35,0x97857267,
	0xd7312fd9,0xdaab5e45,0xe021e9e9,0x7e6d0ba9,0xe27745e5,0xb9e90157,0x45799b2d,0x5fa7bddf,
	0x2b252ae3,0x36ddcbb3,0xd3c11555,0xbb43a1d5,0x9bdf7fe5,0x4b4d3903,0xdceb1373,0x4cfdbd5b,
	0x78317b45,0x51274481,0x545d0c6b,0xbd37f04b,0x958f3dab,0x037f65e7,0xd7db17e3,0xf1fb0183,
	0x345546fd,0x1f97ae7b,0x5897f349,0xfffbcbf1,0x78c90b6f,0xa5d10609,0x642926d5,0xbb918b83,
	0x8415a87f,0xbabf87e9,0x0d914a85,0xe9bf4a33,0x2d4fb9ef,0x2815fff7,0x76396b23,0x11316d03,
	0x5a734ec9,0x7db38797,0xf6ef8f3b,0xeb3760fb,0xf965fe63,0xd29d42b7,0xe8eb5c27,0x74cd682f,
	0x98f11d55,0x26033ccd,0x0ecfdb05,0x9f9586b3,0xa1cb1285,0x603b65d7,0x9da35dbd,0xa2d98faf,
	0x2f91cc1b,0xf3c3af59,0xe5d783fd,0xec895245,0x89c5548d,0x1e41495f,0x9c43603d,0xb243e6ad,
	0x3cd38797,0xc983ff81,0xc325bcbb,0x22471b1b,0xd313e739,0x0c7fb5d9,0x332b8081,0x348100d3,
	0x2dbd90c1,0x4c55060f,0xc45f345b,0x1b81991f,0x7df751c1,0xfd4bfc4f,0x173da7e3,0x5583a24d,
	0xddcddd15,0x03cdf44f,0xfda5b677,0x5d6984bb,0x89331fdf,0xb575964d,0x83dd2c3f,0xfbbb5fc5,
	0xb707b68b,0x79fdf40b,0x9999cb29,0x37af36d7,0x120b81cd,0x0c4dc5d9,0x5aed6fed,0xe81d3e63,
	0xd1ed5b9f,0x5b75c78b,0xf95d5709,0xe48748df,0x743fec45,0x0ba93581,0x44cf81c7,0xd61953d1,
	0x157f9f49,0x9747699d,0xd4933b33,0xa8a334bf,0x6a13b881,0x0fd7984b,0xd061bd27,0x9ba16639,
	0x57438905,0x7f07ad85,0x595df541,0xf333f4dd,0x2c45c43b,0xe7ad49c5,0x930b69e9,0x49278c47,
	0x7b37f4cb,0xe6c5df13,0x4c5d3f4d,0x7deba425,0x921b11ad,0xf479edf7,0x48ab5c65,0x499dcd25,
	0x93df3317,0x4515628d,0x28b5aff1,0x6cfd1e01,0x31576791,0x4a11116d,0xf3a59575,0x8275c07b,
	0x023da8e3,0xd30754bd,0x40095a45,0x6f199e5b,0x7e39f121,0xcec3c92d,0xfcd9e275,0x73a32e73,
	0x95d36fa5,0xac2f2af1,0xda776de5,0xdd75619b,0xeb83de17,0x5b6352c3,0x53ab7d3d,0x5797afb7,
	0xaca3f55d,0xee9d52ed,0x56a3d6eb,0xdbbd44af,0x0a7702ad,0xdb43b43b,0x8dfbac27,0x43434d73,
	0x532d9c81,0xdae5d301,0x49b1ddef,0x782964fd,0xaad9779d,0x6c355c1d,0x082d620d,0x46192151,
	0x64755c0b,0xf417e9f3,0x9f41c80d,0xcb67c073,0xfae93a21,0x7e8dc173,0x0523de49,0x8a0df577,
	0xa9ff5f77,0x1fc5af0f,0xb97376e1,0x18abd577,0xa769cbf3,0xf51903c7,0xce3d4cb7,0x738fe493,
	0xfbc7a6bd,0xc603b21f,0x90ed087f,0xeda742f5,0xfb9dd34d,0x452d8b23,0xd35f65af,0xc191f9cf,
	0x6055a659,0xf1619b6b,0xd4cf7787,0x428b6857,0x0145bae9,0x969ba811,0xcae90e0d,0xad85d0d3,
	0x2ca9e745,0x6ef3cbbd,0x0abb3b0f,0x9a0d0587,0xa0a55201,0xe3b5339d,0xd1bff727,0x0b5d35c9,
	0x2443a6f9,0xee4bfc63,0xaed3e6b5,0x2159daef,0xc07b6c4f,0x194b2f4d,0x8b413edb,0x698dc55d,
	0x9929776f,0x2177df23,0x53b9ca8d,0xd0274979,0x660d820d,0x36b3652f,0x41530f83,0x31038cb7,
	0x8bd9df23,0xdd0fbe49,0xc28f9337,0x88a5f28f,0xd51d4ff5,0x6dbd07cb,0x04573ff5,0xc535a981,
	0xcb55f90f,0x381f1c9d,0x1af9e9cb,0x37875819,0xafe97743,0x42bb522b,0xcb2df38f,0xa413e9e7,
	0x152314ab,0xac3d556b,0xf31513e1,0xf3ff7c83,0x17371dad,0xac7f27d9,0x93393a29,0x86116c91,
	0x354355f3,0x357b3c7b,0x77879395,0x1fbd82b9,0xca498d6f,0x3459b4df,0x805bb01d,0x7e1d40ab,
	0x2635555f,0x7269be1b,0x8b73c781,0x86f54e21,0x46ddd543,0x161f0dc9,0xfcf71e45,0x19ad05dd,
	0x30fdbfe9,0xc4197f11,0xe8778abd,0x805922a7,0xe9396863,0x601fcf9d,0xd9ed19fd,0x80b18c51,
	0x0d1df70d,0x6e1f7ca7,0x3eb9d4e5,0x0d1944b5,0x0c1fbe8b,0x132fbfe9,0x6ea3a51d,0x959b74b3,
	0x0097b0c5,0xb68daca9,0x54d95a13,0xf8e99935,0x28cdf3f1,0x429d6cb5,0xb8f5cdff,0x155dd02b,
	0xffed9789,0x05f19d61,0x27f92ae1,0xf9fb4591,0xf7096951,0x343fcc8b,0x7d494f7f,0xb76bc065,
	0xce21ea55,0x07631599,0x0bbb5469,0xd1014fb1,0x8d1563e7,0x8063de75,0x668130f5,0x4db51789,
	0x1cb31ca1,0xc86fb499,0xca418043,0x692b3e03,0x7fafad69,0x31dd49ff,0x25ff663b,0xe4adf841,
	0xaba77669,0xd92b922b,0xc42d948b,0xf82db76d,0x021d3413,0xe601ff2f,0x93a36fab,0xe34575b9,
	0x697fb425,0x6c29de9d,0x10a153db,0x1e37235d,0x0621aa9f,0xec9dd693,0xcdcffa21,0x2aef3399,
	0x933da6d1,0x767982b5,0x9d3ffd4d,0x05ff49b9,0x5bf92849,0x68053131,0x59677ef5,0x379f060d,
	0xd463d3e5,0xcfafbfbd,0x4e29ec79,0x84b3f2ed,0xd26bc8c7,0x6d0b9897,0x41cde401,0x3fc591bb,
	0x66f1155d,0x51dbcf83,0x1e03397b,0x3a0787e3,0x56b74c57,0x23015ecd,0x38e11b9f,0x5453ebd3,
	0x336b39b1,0xf98f844d,0x3deb58ed,0xb02bb205,0x14a1b7af,0xe3b93e5d,0xb707c4ab,0x80bb39f9,
	0xf0d5a3dd,0x05dfe8e5,0x3587bbe9,0x7bd3fb3d,0x9669f40b,0x5b85fa51,0x1b21ca7d,0xeaef525d,
	0x44adeb59,0x185be097,0x02f57007,0x5c316df3,0xe4d16f27,0xa937fe35,0xca8f04ef,0xf3635ba3,
	0xe2f57c21,0x5517c72d,0x3adbbf65,0x5af73515,0xa71dbb39,0x7e21fe0f,0x5133d85d,0x55076cf9,
	0xae3336ad,0x82a310f1,0x2859d099,0xec553c09,0x430d2eff,0x3e15966d,0x8171d59f,0x454d2e07,
	0xd7650ff9,0x2a13eaab,0xed0f46bd,0x0effcebb,0xfce385af,0x1f65ec57,0x942b5a0f,0x942776f9,
	0xfe11b17d,0xb6f7d9a7,0xa123e16f,0x6c253997,0x17637f07,0x4ae34d57,0x48c12f87,0xcc07f077,
	0x50351935,0x97635bad,0x73351cc5,0x777d6983,0xf3cd7f3d,0xfbdfcf77,0x05172c61,0x51e1b3ab,
	0xaa55399b,0x5be78709,0xc867d15b,0x8f358beb,0x31e32f0f,0xa02ff141,0xf58fd379,0x8525ea41,
	0xb77399a7,0xd795aa85,0x5c5bd44b,0x1c01aeb9,0xcfe71bb3,0xf82339c1,0x2d09f427,0xdfc56e61,
	0x110ff4d3,0x4001ed69,0x6135972f,0xb1116057,0x4a9d56e7,0x368bd87d,0xc4e74a47,0x16336ab7,
	0x5f2fdb1b,0x4d3def81,0x9f93c81f,0x2c194fad,0xbd4716e1,0x20bd4583,0xfd0f1e2f,0x3761fa6b,
	0x785150f7,0x59d96917,0x9699f1b7,0xd54bec29,0x01a3565f,0x2e87e15b,0x5bdde4bd,0xccc3c927,
	0x81796f63,0x82e7caf3,0x9beb1b11,0x7f5905b1,0xcff77499,0xaa3f950f,0xce39df49,0xfa49b317,
	0x0e2903d9,0xc7fbde61,0xfba767c7,0xa7736cb3,0xdf03d547,0xd0b37229,0xc781bbaf,0x9e6564e3,
	0x40633051,0x2b25652b,0x1873b7f1,0x954d9215,0x040b80a7,0xf13752b3,0x61973445,0x7209fbb7,
	0xe8a70b45,0xd0f9b999,0x8b6f482b,0x7b192743,0x52cfc371,0x8d9f7937,0x7cdfafe9,0x28a7a53b,
	0xa5fb3fb1,0x20876e77,0x443b518f,0x9587be27,0x3d91cedd,0x7a3930c1,0xe03be1f3,0x90333f99,
	0x05ddad0f,0xe363ef0d,0xa8fda9b7,0x4bcb692b,0xb51358a9,0xfdd96cd9,0x590b6a3f,0xb11df97d,
	0xa4510757,0x659d1f27,0xb65562bb,0x4f975b39,0x48993b0d,0xf1d16987,0xdb337525,0xee57f20f,
	0x4bd97705,0x95c7fb0f,0x1f656b39,0xbd1d87b9,0x45e314c1,0xe1f34b59,0xa1155b7f,0x2553d8f9,
	0x15773911,0x24f5378d,0x6dcf2e47,0x3b0d4299,0xd935e903,0x2c91bf57,0x4b9142a7,0xce058e67,
	0x88ab3ef5,0xa6b7e1ed,0x21b5337f,0x1a9be03f,0x2d4fbf8b,0x227d9b0d,0x0209bc77,0x1adbc303,
	0xbb7bcead,0xb121fff9,0xd1bbbeff,0x77795599,0x8b734493,0x27097c81,0x9261674b,0x18cb97f3,
	0x726522b3,0xfcc52ff9,0x4aff715d,0x57d7d80d,0x7b6368d3,0xd0076a41,0x90fb8dfb,0xcf453ee5,
	0x406d09ff,0x84b148b9,0xb125e7b5,0xcc697d87,0xe3630189,0x05c97353,0x78b7c7e3,0x603b9a03,
	0xa715880d,0xa67df983,0x9e515ba1,0x1061dc71,0x2833686d,0x23214f45,0xcaf998d9,0x2821dbf5,
	0x365d74d5,0x42356a1f,0x4321433b,0xa96fabb5,0x4d171bb9,0x1561fe1f,0x2fa3113b,0xdde727e5,
	0xaccb1cd3,0xda6fdad9,0x86bbf11b,0x87c762bd,0x13cf5e27,0x7c59686b,0x95156de1,0xb2fd317f,
	0x175de0ff,0xb43d447b,0x26bf345d,0x261bd973,0x1c9dd6f1,0xca5fff33,0x5031b827,0x7359dceb,
	0xf197d6d5,0xf72ff84d,0xd74ff89b,0xa99de83f,0x064331cf,0x64435c03,0x3c5d65e3,0xa56dded3,
	0x457b684d,0xcd574019,0x630be5ef,0x01fd080f,0x8e05beff,0xc155e0e1,0xdb75f973,0xaa275c63,
	0xcb8bf3e3,0x8349fe2d,0xcb1900f1,0x096ff249,0xafa31339,0x8b6b585b,0x75e1a1af,0xdcfd8b43,
	0x0ac96c8f,0xa8174d4f,0x67194abd,0xa4a540d9,0xc55fa7b7,0xbed39577,0x3a7fd9f3,0xb3df519f,
	0x78b5f9cd,0x2d5120cb,0x052d60ed,0xe2cf0e2b,0xa7fd7a33,0xca6313c3,0x5eb10a17,0xdf3fe61f,
	0x99559795,0x8709e469,0x09f91d9b,0x1da19525,0xcebdace7,0xaf699747,0x3e5b2675,0x6a0f6fed,
	0x1f27b663,0xcbd31c75,0x909b3761,0x194dd133,0x6f63268d,0x21bbcc8f,0x7bdf4fe7,0xd9c3a6b5,
	0x0b2fdb2f,0xd4bf05b9,0x8ab7e157,0x24831e3d,0x9e2f325f,0xa7a7e8a1,0x201d73c7,0x4e49729f,
	0xcced3f75,0x5d61357d,0xe0716b19,0x3877d8b1,0x6de32017,0xba014909,0xba79ebf1,0xa2178c55,
	0x6267712f,0x23c9398d,0x9067e0c1,0x18dbfd77,0x0fc1e3ef,0xe41b13d3,0x80d31ebd,0x8a1d1d03,
	0x781df2d5,0x08893831,0xcfbfaae7,0x73e1c9f7,0xf38db6a1,0xe3c7d787,0x6f8f1f05,0xb5cf5e53,
	0x890fdb61,0x2eb59037,0x2a172ea9,0x02395c1f,0xe787b567,0xc9592b2f,0x698f4c25,0xef1b3a6b,
	0xfec1764f,0x1bdf78e3,0xa1956d9d,0xa7175255,0x387181fb,0x179f4e55,0x5833f1f5,0x3a77ebfb,
	0x5135e397,0xd817a205,0xced9a5df,0x902d6b85,0xd18fe297,0xe3edc903,0x4b5fe8cf,0xf6d39e27,
	0x26edb7b5,0x0defd3e3,0x0105f207,0x55ab2719,0x5ca161f5,0xf6150bc3,0x9973358d,0xfda10c9d,
	0x74e99ba3,0x2a7b8f49,0x5dbbe933,0x1a4564fb,0x61e9ef4f,0xe8690fa1,0xff53a98b,0xc2d32385,
	0x9eafecd9,0x7d4bad7f,0x011d3ef9,0xab2d0595,0x682b7e5f,0x47b9f623,0xc05f82a1,0x74dd9f8b,
	0x963d5d51,0x58730051,0x1dcd6375,0xa01589d1,0x14a7a761,0xb35ba957,0xc67b0b29,0x1cafadd7,
	0xfc179387,0x3083f209,0x1ced233f,0x7b2db317,0x4b21470b,0xfd1f7bc5,0xc20939ff,0xbdb98c13,
	0x3f3fca75,0xbc8f256f,0xbe1f4775,0xc9292355,0x4dd71e99,0x4957c877,0x49e95279,0x75f3286b,
	0xbd377193,0x162715cf,0x378735ad,0x4139fcf1,0xdd8f73c5,0x2ed592f7,0xfb7f8475,0x9dc9c187,
	0xe1ffccdb,0xd95db6f3,0x55c39003,0xe51382d7,0x598bb0c9,0xd6e9274f,0x9aab8c4b,0xe82f8693,
	0x481d94c9,0x44c51523,0x9bf9d511,0x20e5b873,0xdf890461,0x1d69ba0b,0x31d152d7,0x82993737,
	0xd88f9657,0x5971f52b,0x63c7ffef,0xeb6101ab,0x6bcf01c3,0xb0a30831,0x31d38d71,0x34f7c39d,
	0xead952fd,0xfaf17455,0xfd532839,0xe5bdc2eb,0xf91f40ab,0x316df74f,0x92115df3,0x81bbec71,
	0x64fda0b7,0x0f57a869,0xcf3d2209,0x7ba7011d,0xa0b7fd53,0x5315356d,0xf06df2b7,0xc5d9e2db,
	0xdb7b49fd,0x9f373fb3,0x76a51df9,0x035301a9,0xba5db877,0xfb71d915,0xb14d2699,0x58bfe887,
	0xb159adcb,0xf5a120fb,0xe7314923,0xdd71ea7d,0xfc53d74d,0x62cf0151,0x1f8d20ef,0xac63ef9d,
	0x38155f99,0xc0290b8d,0x8b016d1f,0x95376201,0x9b574391,0x340375ab,0x8c95f599,0x6d353ac7,
	0xcfb3c761,0x2edf3733,0x62b79009,0x00512f1d,0x6aaf0b7d,0xac61462f,0x704344eb,0xa227fd31,
	0x06b5c1a1,0x1457f435,0x2575947b,0x5ef7d93d,0xfc1b01cd,0xbbb76b63,0x88f9dbc3,0xccadfa83,
	0xba1d3f4d,0x05a14b5f,0x60dfd98f,0x7bd7484b,0xbfdf5db7,0x24596655,0xfb9b5377,0x08b526e9,
	0x356de5e5,0x7a4f9dfb,0x9913dadd,0xcc2764b3,0x24bb5af9,0x9b19e08d,0x738bb1e7,0x2cb5470b,
	0x52a7af5d,0xec7545d1,0x68b5d081,0x8f93b75b,0xb7f1d9c9,0xe7494c15,0x42a90967,0xe99d9013,
	0x9a4b8a35,0xf8a5352d,0xa0e94f15,0xf05309ad,0x4545fee3,0x02bb8377,0x815918d5,0xeadf47ad,
	0x635df961,0x7def96d9,0x694de7b3,0x23150597,0xf6f7d383,0x39c169bd,0x2e7deb89,0xf66d6401,
	0xf35fb461,0xbde56e1d,0x6007c7f3,0x870dd581,0x75c9e55f,0x4b2d8a73,0x4f75795d,0x0cbb2bb9,
	0x9e53472b,0x7c9b36c5,0xb9b559f3,0xc5ebc453,0x08ffe6b5,0x8851b99f,0x102346ab,0x88b9d601,
	0xe6b9b239,0x20a18519,0x617de449,0xf3e5dd7b,0xb6594e3b,0xf4ffb3cf,0xe2eb044f,0x3fd92a81,
	0x9d970a87,0xd30ba5e5,0x18ff2a0f,0xafa98cdf,0x6219f72f,0x6789be0b,0xa0af2fa1,0xa20d2165,
	0x026b198d,0x9f693e73,0x985d0ae3,0x42693eeb,0xef03c147,0xa8c145dd,0xa8cfb27b,0xd9c78355,
	0xe339fd47,0x93cdec8d,0xae3922db,0xbfdb008b,0x5e5530c1,0x93f7814f,0x012f8339,0xebfb897b,
	0xbc83c82d,0xe0cbe67b,0x5fb56a93,0x262d1f25,0xefd70e53,0x37010eeb,0x763144b3,0xd8197d83,
	0xd94b213b,0xf9759b07,0x0873d725,0x7e11c8a3,0x41c5073b,0xf22f95bd,0xbab5e643,0xb8135997,
	0x7313e3eb,0xb35b517f,0x7a95fa2b,0xfabdab73,0x70e54d2f,0x9851654b,0x881f43c3,0xe05b685d,
	0xd1dbc035,0x668fc9a9,0x1ebfa1bd,0x19df967d,0x3877366d,0x8ebd15a3,0xbe4fc58f,0xffe3e503,
	0x6c27da93,0x0da5dbcf,0x140f7877,0xc3ab1929,0x123fddab,0xed41274d,0x83a9007f,0x401f9b33,
	0x06f96c01,0x65af18bf,0x5029a573,0x6ad32365,0x567dc227,0x9e33a353,0x650d55ed,0x64ff8713,
	0xd5d361f9,0x0e3b69bd,0xbf316c4b,0x2c87a597,0x5bf36799,0x7e61bb3f,0x75df93b3,0xecf57551,
	0x9ab7fe73,0xa961b099,0x63c7cd17,0xf07b30ab,0x97e5f639,0x7d1f691b,0x6fff942d,0x30f3a317,
	0xc62777e9,0xfbad6799,0x770b2473,0x88e1960d,0xbe11dac5,0xbc410f71,0xd3d3de33,0x846d5e0d,
	0x97239957,0x0c354189,0x88a3cb79,0xd26987a3,0xe0bf6675,0xb015194d,0x0837451f,0x5551a45d,
	0x3b2f6237,0x448bc9b3,0x9eafb7c3,0xd44737d9,0x90ab6f01,0x3f6f9a37,0x7a9188cd,0x4c15c4b3,
	0xee4da681,0x90bf03df,0x55d11b69,0xe02df997,0xfd1beea7,0xe3a1ee37,0xbec3f593,0x6ba9fe37,
	0x1affaeaf,0x7f650c57,0x012b0509,0xb24de04b,0x13cfa41f,0xc87d59db,0xaf2f044f,0x317f2095,
	0x7a47d7bd,0x618db7e9,0xca5fffb9,0x91575fdd,0xa10bb2a1,0xec55aa2b,0x8cb5fa5b,0xb58b2bf5,
	0x33a73325,0x6ac933db,0xd18fb313,0x6e7fecb5,0x6f8f41eb,0x3ffbd4b3,0x1eb7898d,0xca3bf101,
	0xfd1f26df,0xd12da5f7,0x4d5d8335,0x05759bbf,0x689d1e35,0xc6c19779,0xd3197043,0x1c85b0e5,
	0x3b330d67,0xed49cc8b,0xaaed30b5,0xfc6fc267,0xb3f75839,0xb6791909,0xde3d1955,0x53d9bd49,
	0x20e5d5b5,0x5a319e5d,0xaddd78af,0x041b9693,0xd7e1e52f,0x9775886f,0x5b033c1d,0x322b1857,
	0xcfb7a345,0x1575eab7,0x9053b4bd,0xf7abceaf,0xd91b3ed5,0x6487bd33,0x6acf7c77,0xb3e914bb,
	0x77ab6e0f,0x9f29f967,0x22ed7af9,0xfcd541a5,0x5ae90363,0xab01d75f,0x55830abb,0x3009f59d,
	0x7741a28f,0x19dd2ab1,0xecd13dfb,0xa3c786df,0xbf099593,0xaab3df7d,0xa97f43c3,0x77fb8ea9,
	0x7b7fc1bd,0x6aa39765,0x4b9decdf,0x07359645,0x45c3bc9f,0x75f36697,0x5ba550e9,0xf7b1e407,
	0x9fe30115,0x590fb0c9,0x9377933f,0xec4f6845,0x2dd34441,0x11912637,0xe75bc809,0xd59dca61,
	0x8e71ea8f,0xaf33e0a9,0x2efff935,0xe2cb95c5,0xd47f9cb3,0x94dda069,0x6e7d4b7b,0x12b186e3,
	0x9fabfca7,0x599f294d,0xbf574359,0x64d7f833,0xd5877aad,0x49adbfb5,0xd9732a19,0xaa616f35,
	0xfa914a55,0x8765c581,0x3c2192c9,0xf7254975,0x2b2d776d,0xcc4f7723,0xf71bff3d,0xb29d8983,
	0xb4a91b15,0xca19c88f,0x137fa519,0x48ebc3f7,0x4e35b0ab,0x2b996241,0x9cd752c3,0x7bd72c75,
	0xf1f18adf,0x35cbbe3f,0x4a137469,0x53d7c2a3,0x55df68a1,0x08d96517,0xc68b3903,0xb1019f35,
	0x04ed2a2f,0x810f4add,0x9b01d751,0x7c1b60e3,0x17efa609,0xb7e54c31,0xb699f2d7,0x778fb96f,
	0x8e9f9dfd,0x24f5cb33,0x97e720e9,0xb06d1aa1,0x48a3d41d,0x5f0b6c95,0x15e18d9b,0x8f71834b,
	0x9e893fc5,0x7d11f489,0xc8e9c0cd,0x89fb6c47,0x9ac36297,0x171f43cf,0x13c78327,0x7319d575,
	0xd2abbd7f,0xe77374ab,0xccabe317,0x6c7972bd,0xdf8b65b1,0x0b7317eb,0x862b59d5,0x7779f915,
	0x778bb9a7,0xe4af91e3,0x784b105f,0xa6198b71,0x26c13625,0x99d99771,0x0971447f,0xec0347d5,
	0xa8276b37,0x37d5caf9,0xf76fcdc3,0x8f8bf449,0xdea5112d,0x72a5796b,0x207bc281,0x3aa9cbe1,
	0x6e033da7,0x06777739,0xec373cd9,0xac036bb3,0xf3f9b883,0xb8a51d63,0x54a93fb1,0x07dfdfe1,
	0xe12170f1,0xf8a9666b,0x8f43bbbd,0xc933d095,0xf2011261,0x212d2b63,0x55dfb46f,0x5295ceff,
	0x4803b991,0x58fd80dd,0xcfb98507,0x1f4bc25b,0x227dc983,0x140f33f5,0x1a7d458f,0x943d74e7,
	0x37abe081,0x34816753,0x73394fd5,0x70ff40ef,0xadafed1f,0xcb9d5025,0xff67e46f,0xe0cbddc1,
	0xb3996339,0x7acd131d,0x35e5efbd,0x2b814cbb,0xba5b90f1,0x74a7c179,0xe7fdeee7,0x06ade639,
	0x4dd113b3,0x1ded7601,0xea5ff4db,0x868186a7,0x8dc16d33,0x4e8391ff,0x5e23cf51,0xaed9db77,
	0x46d5b86b,0x32791a49,0x99cb4bc7,0xa435d021,0xaba37e9f,0xcb01343f,0xb23b9c87,0x7cbf1b27,
	0xada7ac5b,0x0f7dc2c3,0xa3c7dd9f,0xb149eb0f,0xf645a66f,0xae732343,0x1b25b9e5,0x2e51b36f,
	0x7fc97efb,0x6e8f0ab5,0xde772ff9,0x04f519df,0xce674a5d,0x2fab8295,0xd6457743,0xbc0102ff,
	0xc93d9445,0x8bc105e9,0xb67f04f1,0x40e7bf77,0x334bf4a5,0x17f9be3f,0x477bb0fb,0x78c358fb,
	0xc483c4b5,0x45a3e0ad,0x4efdfb21,0x7153ff43,0xe2b5f3fd,0xe3332acd,0x192b6fe9,0x32079511,
	0xfa9ffd45,0x3d477fc7,0xa1972da1,0x2ceb5d2d,0x78e5fba1,0xdfa7a545,0x5c378963,0x4fbdc76b,
	0x6313df6d,0xf6412081,0x9e6bd40d,0xb4e15d9f,0x909dc34b,0x4e2b3335,0xa7ff3f47,0xf45dd0af,
	0x83e16129,0xf6a3f8a7,0x4c1fe281,0x14e52583,0xe321a737,0x820da2a5,0x3a65dfef,0x1cd3020d,
	0x918b6cf1,0xe6fbd683,0xe7d3a991,0x432b1a43,0x6831481b,0x01232a1f,0x17cf6631,0xc095bd29,
	0x8f1181bf,0xb261c0dd,0x0529765d,0x406381c9,0x760f2b33,0xa3bb08ad,0x2b1b196b,0xf1911431,
	0x6df95311,0xa6619703,0xae43327b,0x37c1227d,0xe17f5a39,0xb4a925d9,0x65ab2d75,0xfc3d69cf,
	0x2e4168db,0x9313b0b9,0x83c30407,0x9ef7e34d,0x1dc10369,0x1141b1af,0xdf6362a9,0x87891129,
	0xfe6dbf9d,0xeb037e4f,0xdccbed9b,0x56376b9f,0x5c971979,0x4951c4b5,0xf6a3a5e3,0xb4e9eded,
	0x5b7f684b,0xe347288b,0xe6fd6e51,0xc831c35f,0xae45f3a5,0xbf2dfff9,0x7051b07b,0x404b1445,
	0x30f72863,0x937130b7,0xc67b21c1,0x0a19f2f7,0x218beda9,0xc7a72d03,0x97c9a84b,0xa02568d9,
	0xf8db19df,0x159110a1,0xb5e96007,0xfba1a351,0xe3ab07bb,0xca11dddd,0x5ef3bfaf,0x256740d3,
	0xdba94b39,0xa639da8f,0x2665ddbd,0x66fbbdd7,0x60698699,0x603d0d11,0x7e2bd57d,0x1b8301df,
	0xd0655f67,0xc47dd94b,0xdf954bfd,0x20d70c73,0x62059379,0x767dbda9,0x94591513,0xe86dc225,
	0xbc912de9,0x51ed3021,0x1f97f861,0x2869d98f,0x3141dc19,0x6ba39b31,0x46db9649,0x2c93e84f,
	0x942f62b3,0xb29d7adb,0xbb116d01,0xc7619013,0xb56132af,0x310199af,0x6193fd7b,0xe2ebcb89,
	0x79c11e45,0xed1d6dc3,0x3d231079,0xb1f35b6d,0x94252df7,0x6a6995b1,0xf6e71b81,0x80e5537d,
	0xde479595,0xca8175a1,0x076fc5e1,0x26d1c783,0x51cfc92d,0x8e2df43f,0x7fb38db5,0x16739851,
	0xa147b21d,0xf65957c1,0x72178cd7,0x0f2d60c1,0x71210407,0x051f42e3,0xfb5f5df1,0x6e0982b3,
	0x30bfb1d9,0x1eb9d1eb,0xebbd2171,0x1eb75411,0x935f82c3,0x4a8fd7a7,0x0fc9a291,0x2c956bcd,
	0xa933c741,0x14313a6b,0x19839c4b,0xf3a30edd,0x984b2e17,0x0c537115,0x29531e6b,0xf18dbd47,
	0xf5a3b951,0xe9d5200b,0xf70b127f,0x36a3df0f,0xbe23d341,0x4abbd639,0x9ae1e0dd,0x76e1914b,
	0xef958383,0x1533ea13,0xf67735a7,0xbae99311,0xc1adc3f9,0x78977699,0xbdd5e5c1,0xb1035283,
	0x7f07f5cf,0x8e63784f,0x2069f3db,0x9e2519cd,0xfe297677,0x9b3d0a43,0x120fb56d,0xeee75c1b,
	0xba7f54af,0xeff3c309,0x340517b7,0x688b22ab,0x8d5b2579,0x6a7b31bf,0x5df304bf,0xf9fb99bd,
	0x06fbf91f,0x96f57b09,0xc6e9e855,0x2ccbbd99,0x67837035,0x70a71617,0xce61550f,0x3635278f,
	0x37fff097,0xc2fda99b,0x653bc94f,0xa81bfafd,0x8363fa69,0x2a8f08d5,0x16bd9439,0xc205f241,
	0xaf8b9d13,0xb61b5087,0xb199dabd,0x62298bc3,0xf63d0c4d,0x27872403,0x90e9bc93,0x965d56f7,
	0x7e25550d,0xd4e30a1b,0x8529993b,0xcd276155,0x13d53299,0x2963ea2b,0x5d4574fb,0xa6b1c35f,
	0x82cb037d,0xc665a91d,0x0f8b7de3,0x65cb4d9d,0x8e6dde8b,0x4471e659,0x82b3b0cb,0x00f155a1,
	0x8b03c7df,0x9435d8d7,0xf6e19e4f,0xd343a305,0x96c305db,0xff854c15,0x0e994fd9,0xed8d7c69,
	0x72cb962b,0xca63bd15,0x77cb4c99,0x0743d477,0xfc1dc2c1,0x73f19767,0x34d3be83,0x0f7b96df,
	0x44a7d6db,0x97819221,0x856fb759,0x5dfb155d,0x4c3bf3fb,0x6d872cdd,0x6fc995a1,0x842d94af,
	0x599706eb,0xeca34cc3,0xe96f89ab,0xbe21f99f,0xf361dcc1,0x8a99f97f,0xa0593a8d,0x03919601,
	0x792157d5,0x9d593a47,0x63e98b29,0xb8e115ab,0x5c4dc4cb,0x5bf912d9,0x2de57f23,0x001d8b7f,
	0xf9434f91,0x7fb7a077,0xcb813feb,0xa9f39e67,0x10479857,0x84f956f1,0x265341b9,0xc6c1d655,
	0xde81689b,0x8c4f5d9b,0x2d59888d,0xd785093f,0xd70b881d,0xdb6b0c53,0x5dff0d2f,0x9eefe82b,
	0xfbdfb1eb,0xfe2f887f,0xed154229,0x924bac1f,0xd6dfa957,0x87a1820b,0x8fd1b8d9,0xea99e32b,
	0x12d96efd,0x72ef106d,0xe4d3e659,0x55775d6d,0xb48395bf,0x246dafa1,0x7d250893,0x46313a01,
	0xf377b7c9,0x0a9b5d2d,0x85392b37,0xe6bb1415,0xb33b0b8d,0xdf21d51f,0x0de34cb9,0xa8ab4fd5,
	0x9c3918c9,0x87c9ef0b,0xf565a35b,0x7647877f,0xd4c58d7f,0x978d1b0f,0x70690223,0x83771853,
	0x5a1f32fb,0x6f8bfecf,0x32fd5de1,0xbecfcf99,0xf96702cd,0x0007327b,0x399b722d,0xe287b7a3,
	0xe8ad5bd3,0x29711dc7,0x32218663,0x258304cb,0xffe35731,0xbd5ff4ed,0x84d952ad,0x8c4d226f,
	0x91e53d51,0x1f8dd5b7,0xfd7304fb,0xda17dffd,0xe5791ae5,0x86e50471,0x14076601,0x21bdbde3,
	0x4e4975e9,0xde7348ef,0xd6151e41,0xf6bd5a9b,0xe5eb22a3,0x466f6b8f,0x6f851b03,0x3e45ffa7,
	0xe4db389b,0x3535d235,0x53a91353,0xa0274e91,0x9b7b27a5,0x384b3d4f,0x06372d09,0x97db0de7,
	0x0b1becdd,0x5563a4d5,0x8451c1c7,0x25851645,0x1eed67a5,0x0b4f353f,0x4d7d43f1,0x1eef5f4b,
	0x850dcea9,0xf30f6c97,0x0caf43b7,0x208b2ca3,0x278144dd,0x00c95767,0xe13b9413,0x1e755afd,
	0x45358e7b,0x64cdedc7,0x47e58fc1,0x956bcd15,0x2afbe607,0x0c8f9053,0xa3d37e49,0x5bdbf8a9,
	0x8c8ff14b,0xc3ada52f,0x679518fb,0x12d79385,0x7d99d65d,0xf4ef5509,0xde252fef,0x37176077,
	0x0aa37095,0x0b436817,0x93e36f01,0xd1ff1c5b,0x7221a599,0x72bd4315,0x5f9542db,0xca998b13,
	0xfd71da51,0x399f044b,0x0b6ddded,0xd697a485,0x79d587f5,0x514bc083,0x9e055d6b,0x0b53e1a5,
	0x5179f0fb,0x6f53e013,0x43590e57,0x0ecfa96b,0x4475f62b,0x8e6d9bdb,0xd5d5d279,0xe8b7ddd7,
	0xc1c10b8d,0x0f739a3d,0x0747a55d,0x735d88f5,0xe0434d75,0x7a71ac27,0x29e7415b,0x6cb9a9d5,
	0xf7c7b57d,0xdf91aa0d,0x9957e495,0x276f218f,0xda016f8d,0xd82b70f1,0xc39f35ef,0xdbc7c047,
	0xab8f4ecb,0x27bdff53,0xd22f4a1b,0x98b77223,0x5cf362ad,0xfcedb243,0xf2dfc88d,0xd4d78c57,
	0xc399abed,0xd289a255,0x40ef3087,0x9f6b3a1d,0x52d9f18f,0xf08920a7,0x4e073e11,0x715909b1,
	0x74ebb5dd,0x8d0953df,0x4b396ef7,0x9e399961,0x83f54b6d,0x8d51f529,0xd1fba7d1,0x6541647f,
	0x63030a17,0xe6cd2d39,0x4d2ff901,0xa255b05f,0xb70ba401,0xa017914f,0x021d83ab,0x1efd9967,
	0xbfe79a95,0x71e9402f,0xb9737ec1,0x836f3fff,0xd15bd385,0x082b1f27,0x084d5bf7,0xe7831597,
	0x6c154dcf,0xe2ed370b,0x39270ccf,0x03bb49ab,0xf6a7f6b3,0xd7633139,0xd4ed6791,0x024356b9,
	0x16919ebf,0x30edf495,0xcbefac49,0xefebaf4b,0xa9330ec7,0x720f628f,0x3ee129cf,0xcd2f8af5,
	0x5cdb3ce1,0xb5793419,0xe7e902c5,0x3f31d34d,0xe9bfa177,0xaf01f6b3,0x238b128f,0xe0b930f5,
	0xeaf9ac2f,0x4ca32961,0x99b9f25f,0x333d3897,0x578d58ff,0xf78979af,0x86cb1e2b,0x2fd5b7e3,
	0x9b69e521,0x74ff20b5,0xa48339b1,0x78432295,0x5061a419,0x677d600f,0xb3057579,0x27f31f6b,
	0x9731f4b3,0x6f9f1ee1,0xa1e513d3,0x44f53531,0x107b55ff,0xed2ba6d9,0x591b0dd7,0xd10597b7,
	0x75cf9c5d,0x6013812d,0x2205d863,0x7a8314d5,0xd29d466d,0x6969739b,0xb06d491d,0xed7d216f,
	0x5d45f219,0x6c6d9d67,0xcb839b77,0xc4a1066b,0xf00bf199,0xcf85b45d,0x96df95a5,0x1a4d2dbd,
	0x22190065,0xdd4161d3,0x7b81cda9,0xb9818f5d,0x0085183f,0x4555bfa9,0xb0d10e4b,0xeee93e4b,
	0x674b6635,0x3d9ff541,0x65a1dc17,0xf9d51593,0xfa4d5f99,0x4327f489,0x89271a67,0x1d418545,
	0xbe5bf707,0x7b1b56f7,0x3403d057,0x50cd7f7b,0x5227f163,0xb3cf5a87,0xb1410dd3,0x91c78555,
	0xc74d5ad5,0x05c5fec1,0x274ff085,0xd41dd3fb,0x1b531bd3,0x14a141af,0xe103c8e9,0x936db1a1,
	0x50a3ae17,0xf0317ce7,0x36a15f3b,0x03f7da81,0x2793f1a5,0x956be287,0x16cf5885,0xe3a50dd9,
	0x775f21c9,0x0f6f1a35,0x2f9dbb93,0xeb0bbaf3,0x272bea15,0x3881fe1d,0xb78595ff,0xde63ce21,
	0xc7039b63,0x1b1177f5,0xd665c125,0x3e8d9dbd,0xc8db80d9,0xf2b57df9,0xae87c731,0x9a15f727,
	0x598f54e1,0xcd2b2fef,0x059de80d,0x7e2f4bc9,0xd9e5d62f,0xcb591425,0x8dbb3e75,0x07b1fe13,
	0xf7897cbb,0x024f746f,0xce6304e5,0x1421ce81,0x660d4ecd,0xfc3fdb2b,0xad7ffaa7,0x12a96891,
	0x37efd5ed,0xd98db03f,0x985be8c7,0x75170fcf,0xd79333ef,0x11b9f615,0x4cb5471f,0xc0eb6cc9,
	0xa04557ef,0xd47726a7,0x41a9014d,0x40437a1b,0x17395351,0x0a99306f,0xb0c15bb7,0x52ed9167,
	0xc48dcebd,0xf7219373,0x3eedf88f,0x5f579853,0xac439f29,0x78319e3f,0x4585fccb,0x639d4d91,
	0x67477ad1,0xe81bcaeb,0xbb475529,0x2683b5dd,0xdc71ce35,0x9e533c13,0xbd611b31,0x0871a8f7,
	0x9979b121,0x107959db,0xb85d1a35,0x747b7ea7,0xcc05fbab,0x93518ef3,0x31377447,0xf15bdbbd,
	0xdaa17b2d,0xbbcb258d,0x2e4f674b,0xd2719f17,0x9dc14749,0x5ffd4469,0x406d31e7,0x88c9ee91,
	0x38c336eb,0x38230bcb,0x2bbf1887,0x94156419,0x92e97545,0x1fa7d27f,0x30e18a67,0x13b15a9d,
	0x706136d5,0xf61782dd,0xf5cf6683,0xf79b5b17,0x2b3f8e5d,0x202517bf,0x0ef560a5,0xd181a989,
	0x0c7d61e7,0xa8b3398d,0x28218659,0x45b5f1fb,0x45017fc7,0x01c7fb35,0xcd8de3f9,0x1c2f157f,
	0x8697d399,0x658db729,0xd4d949a3,0xf195172f,0x3cf5bb41,0xd75d0c67,0x660b303d,0x882d292b,
	0x66b57be7,0xc4b5fb77,0xa495be79,0xb8ebd99b,0x0e5bd701,0x463d2363,0xf84fedcd,0x04695fb5,
	0x6355bf4b,0x00bf1ec1,0xf679cf77,0xc3eb08ad,0x72f72dc5,0xa63500b1,0xeabdf181,0xfa59c4c7,
	0x817b16bd,0x16bdf1d3,0x0029e3b7,0xc545d44b,0x03097ec5,0x219bed5b,0x0a35dcb3,0x6deb948d,
	0x34a9afb7,0xe63d9df7,0xedc37ed3,0x1a2d6ce3,0x55538db9,0xd53d5aeb,0xaa1bbd3d,0x1d95dbaf,
	0x7ee10c35,0x515744f7,0x01ede0e3,0xea57a35b,0x1f17c2df,0xf06f836b,0xc451ad7b,0xa2491757,
	0x10a3a2b1,0x5c97a11b,0xb5c7a683,0x47ef891f,0x5419caef,0xd5050965,0x19377445,0x8f75d531,
	0x68f57e23,0x4f13a52f,0xd8f168cd,0x4fad1019,0x46993721,0x374d97e5,0x4faf24f5,0x930f5367,
	0xf555de05,0xd25d1c7b,0xb1915d5b,0x48bfaab3,0xc75b1d33,0x3e1b8271,0x151fbf67,0x9587209f,
	0x31c7d653,0x12854acd,0x1c47f647,0xc4d9ebd7,0x459fb75d,0xa2c16517,0x3d65cff1,0xd9cfbc09,
	0xc8cdef87,0xde1f8c69,0xac358229,0xc02b26ed,0xef270457,0xd111c45f,0xe2e30f71,0x1d593549,
	0xb369c699,0xc63bf61f,0xcafdcc1d,0xc1690fe3,0xd035675f,0x075dad53,0x867d0341,0xb817cc8d,
	0x591bad05,0x3e6bf535,0xd8c1bbbd,0xf9c55b1f,0xf38d482d,0x7677557f,0x2f959d37,0xbc7d927d,
	0xafe948c3,0xbcc3ef75,0x4c25f521,0x64f15d8f,0x826fb2fb,0x61b1bae9,0x8c0bdbb1,0x177b0845,
	0x5c51344f,0xd9d3e32d,0xd24778e5,0xe91dac99,0xe49ff881,0x3edd441d,0x10416987,0xb083bf8d,
	0xd1579ea1,0x70af0723,0x6ecb4425,0x76fdbe29,0xe05d4dfd,0xd64d6027,0x171d3e13,0x8987fa7f,
	0x707deb33,0xbee76aa1,0x9bd5f075,0x29c388a9,0xba6b6d27,0x62d3268f,0x01fd3d31,0xdefb4bc7,
	0xa9c35203,0x848f9573,0x6a0353f5,0x671f2303,0x560b3439,0xb1c1f75f,0x58c3d739,0x47cd368f,
	0x1baf7f85,0x243727e3,0xa07b213b,0xff4764a1,0x550145ed,0x42e71b21,0xe9d3a905,0xd573ce7d,
	0xb33f34b7,0xc2f17abb,0xdcdd8763,0x4ce7856d,0x378da97b,0x689b62df,0xea0f1bef,0x33dd57bf,
	0xcbf7e713,0x68533f43,0xb349d207,0x5537bdcf,0x7c736aa1,0x67adc823,0x14d705d3,0xc97fe6ff,
	0x4fd96091,0x1e691f47,0xce650941,0xe7e5e6b5,0xc0f33997,0x976d0cf9,0xcc0f4909,0xd7470163,
	0xd7675fad,0x11c95d0f,0x0f5191a9,0xbf251985,0xe0cf0b17,0x81b15be9,0x3817746b,0x98ab3c9b,
	0xc9a33761,0xb1837367,0xadafcc5d,0x9fa9502b,0x1649b85b,0x02c7e7fb,0x67d36355,0x639bdecb,
	0x7c0d6f23,0xcf2bb599,0x57a1b6f3,0x78a10513,0x1a259f1d,0x69858cbd,0x70a5dd9d,0xc8897ea1,
	0x52ab62f3,0xbed1ef6d,0x51cb8b85,0x83c1d323,0x43a34197,0x97396e37,0x8e6d37a1,0xb267a347,
	0xdffbe347,0x7709052f,0x974b60b1,0x653b15c7,0xa885e683,0x1fb998f3,0x438df23b,0x86a76463,
	0x0501d519,0xb0e393a9,0xf9c5c98d,0x4bbf88e7,0x3d0f391b,0x6953a1fd,0x78eb5ac1,0x453d0a25,
	0x113fd1e5,0x07f39023,0x415d75b5,0x1083e8f1,0xf401e919,0xccdb46db,0x9de32b11,0xa899ad31,
	0xe2b5c7a3,0x1a49e869,0x4cb1d143,0x573592cd,0xde9f4ab7,0xb5a30d9b,0xc85d2983,0x45add6b5,
	0x05e998cf,0xa87922c5,0x30e7a4cf,0xae0723e3,0x4ca7f6af,0xc17fe4c5,0xd4b7c8f1,0xabeb2059,
	0xd5d9bc61,0xb593fdff,0x599db577,0xadad1a21,0xec616a3b,0xe0bdc363,0x85d3c8b7,0x8547d449,
	0x9c09ddd5,0xa7291163,0xa8f964d1,0x195973ed,0xea89a715,0x763148ff,0xa515d4ad,0xb6318d2d,
	0xb07b7d25,0x654f6cb9,0x979b50f9,0xfebd5033,0x1265d377,0x772d5da3,0x225f252d,0x7d9bd631,
	0x99b18ec9,0x7a97384d,0x54a5f487,0xd6098e5d,0xedb5da1b,0x8b83d1d9,0x34111f11,0x94f7cafd,
	0x2cab1bbb,0x340f54e9,0xe5b94699,0xa1f36e55,0xe4bb0a3b,0x2d85fead,0x770ff3b5,0x5037b7bb,
	0xacefe177,0xc14ffbd7,0x46f95ac5,0x0fa73085,0x5e3bb791,0xca0565a5,0x0ebb40f1,0xbdcfb915,
	0xec7bf1f7,0x54635edf,0x8b070127,0x96ddb5d7,0xdf75da59,0xe05350cf,0xc4f5b11f,0xc6ad5c39,
	0x6bd353b3,0x41e3484b,0xfb056657,0x99c31fb3,0x2c2baf49,0x224572b3,0x2a1f9b19,0x4e473ecb,
	0x79f9a1a5,0x20dbbae9,0x3695b373,0x850d7007,0x66a1579d,0x942b865b,0xb51fa23b,0x528daef9,
	0x546fab49,0xeae191ff,0x53dbae11,0xefed2939,0x2f97790f,0xacd7ef51,0xe351565d,0x0bf34b6b,
	0x47351499,0x1c072157,0xff75584d,0xbc13ee37,0xc64fddd9,0x7599599f,0x589dd3d9,0x0d67a34d,
	0xccd1f60d,0xd2ddd53f,0x9c8790c1,0x35b32267,0x288d14b7,0xaa4759d1,0xff61638b,0x645fd647,
	0xae417ca1,0xf075d27b,0x64b5b285,0x337f89b5,0x329110df,0xd92f0ced,0x287f1ac9,0xb8cb3483,
	0x230989cd,0x3863965b,0x881f3537,0x36a7e88b,0xbf1dca0d,0x8327b881,0xab5b7b73,0x6d1ddead,
	0xf12b538b,0x70b996a5,0x4d654ced,0x8adfa3d3,0xc775dc7b,0x3b7d6a95,0x05d713dd,0xbe4765ed,
	0x8d290457,0x8205e1a5,0x31ad8a41,0x665960f5,0x835928e5,0xc80799b3,0x7c531ee3,0xe3bd6bef,
	0x3a035b2b,0x975fbe23,0x08977a51,0x09c7a5df,0x890b7481,0x4113c4e5,0x39b323e1,0x2f6f42db,
	0x293d4b7f,0x3e534b6b,0x1c4546b3,0xe05978f9,0xed4f090b,0x317513b5,0x6f5796af,0x2dcf8d5b,
	0x9adb9d4f,0x86f92147,0x4d595585,0x9fc3012b,0x636554bd,0xb681f62f,0x752377a9,0xc5cfde9b,
	0xfd5b8d13,0x23ddf001,0x32f5e95b,0x683525e1,0x5d0f8a53,0xa005c4d9,0xe979f3a5,0x58e15a43,
	0x0dc16bc7,0x8a152061,0x3abbc155,0xe4652f07,0x2a914103,0x905560c1,0xd1390401,0xe2f9547d,
	0xf78d3ee3,0x113373b1,0xc8cfb909,0x69816503,0x1aab148b,0x1c43d36f,0xb7c70e95,0x1a87f1f5,
	0x74c56063,0x1347a3bf,0x57cf6895,0x173db0c1,0x9a9f4521,0xeb21eeed,0xcf0385bd,0x907dc7d5,
	0xede71ebf,0x0ce302cf,0x98e1c48f,0xf7c93bab,0x56315781,0xd6c1edc5,0x0f51884f,0xd04d7bc3,
	0x99f75cf3,0xbd1b1bb1,0x93a3be11,0x1fd90fa9,0x57a1b4e7,0x0b751301,0x579181a9,0x7fe963ed,
	0x9e773277,0x457f51ab,0xc63be2b9,0xce9fb729,0x27b14b09,0x280f4a2d,0x8d27c9a5,0x7fc526fd,
	0x2f698b47,0x4a238089,0x4547fc9d,0x8dcddd13,0xeda32c25,0x5de1c74f,0xbbf54499,0x0ad15c1b,
	0xaf4fc7db,0x11979c95,0xdbedb259,0x5193eccf,0x8f3b2ef1,0x90bda6f5,0x365b0363,0xd67f2af1,
	0xcf295d2f,0xa4ef5297,0x2bcd2707,0x98a5b249,0xd0bb8eab,0x76f58e27,0xb53de35b,0x32c1ebab,
	0xae7b74bd,0xefbba7db,0xcd099a3f,0x8c35f9ed,0x74e18b09,0xb95b4a6f,0x77fb2e5b,0x2a09c6f1,
	0xfb478c7d,0xe00f9a29,0x6e43081d,0x1ff330a1,0x5cf30849,0x133f71d7,0x64793abf,0xa14b55ed,
	0x120f16e9,0x867bbfcd,0xf49dc93d,0x321303d1,0xa8b12f21,0x727702e9,0x27170b5f,0x77f7424b,
	0x1dd51afd,0x3613e791,0x9bb932b3,0xab470167,0xd65f0ccf,0x175304b1,0x52b9ef95,0xa7ffe633,
	0x381bd431,0xa467b8bd,0x15b9361f,0x9ebf37cb,0xe2bd3309,0xb4a326b5,0x80c1233b,0x65d5ec51,
	0x88e15281,0x0989531d,0xab410197,0x6a2fd5eb,0x690d580d,0x8fbd6103,0x710f6ead,0x406befcd,
	0x66ad1a67,0x400deefb,0x5b6f9fb7,0xd5c9cb2f,0xc313f691,0xa06f9423,0x2a07c6c1,0x41351c51,
	0x767dc4db,0xe5037d1f,0xfbe79799,0x343f677f,0x290fedd3,0xb10f291f,0x1889ecd7,0x0c23ce09,
	0xcbd59f57,0x77ff46d5,0x58cd8cd7,0x82c1fb47,0xd1c3218b,0x7e6bb181,0x2ff90ec3,0xffa7319d,
	0x08b54bd7,0x7b118de5,0x54c1df89,0x89037773,0x127119f1,0xd7d78753,0x0a3966e3,0x54b3e439,
	0x7da360d5,0x92cd2c9d,0x08e34c4d,0xf9370d69,0x7edda3c3,0xbf276d1f,0x07a9dc0f,0x3eb99385,
	0x499d0949,0xa64335c1,0xe4d98c37,0x900dcf15,0x09477039,0x88a92df1,0x6f2da1a1,0x0bad9dab,
	0x7a27a4ad,0xff0794a1,0xcec3f4e7,0x34b94ee1,0x2273b50b,0xfb313d4f,0x8e25d773,0x43ffb157,
	0x2b4566fd,0x6929ad03,0x43431875,0x18ed3fb5,0xd9a1cc77,0x70115747,0xd87529e1,0xcaa16db1,
	0xa773f8b3,0x533bfb33,0x757b6579,0xd8db14ff,0xfc93d535,0xf31b2061,0x087d71c3,0xfd050263,
	0x87b916c7,0xee51b3f9,0x6f0dc70f,0x9b33a2a7,0x378b527d,0x62a1c5a7,0x3f215473,0xd31fcf99,
	0xd39732b5,0x4dfb64a1,0x301b44d1,0x3129bd15,0x354dcc0d,0x8f759ca3,0x23c3e3cd,0xff5d05fb,
	0x210d1275,0x884d92f5,0xcf47a2d7,0x366fd937,0xbf196e1d,0x5ce9c361,0x04433e29,0x0eb546b5,
	0xb49f7081,0xd5d95d3d,0x99b501bf,0x3135ac73,0xdcb3a967,0xe0cfc067,0xf5052e61,0x8897436f,
	0xa14f9bd7,0xb1ad1a45,0x33037e9f,0xb22fccb5,0xf45bd323,0x837922c3,0xf0e9cbcf,0x0ef55e55,
	0xe89f17eb,0xf961f957,0xb555d311,0x748f5067,0xead3c50f,0x1fb921fd,0xf9531a4f,0x7e434a0f,
	0x9a913cbb,0x0d01a23b,0xd14ff533,0x7e056e73,0x435d7d63,0x22e13e1f,0x3623aa37,0x0d71a9c7,
	0xf5a5d6c1,0xef23d53d,0xee11b79b,0x3ec51e43,0x3fbdbed9,0xacc1dfb3,0x15bd3867,0x6defb127,
	0x86e1c6f5,0x64d90b25,0x493b6967,0xb181b7bf,0x0033b0ab,0xafaff7c3,0x6d034e33,0xebb5c45b,
	0x49c3a2d3,0x15b3153f,0x16f3762b,0x7b6b9355,0xa3837e93,0x107b9fd9,0x9755e179,0x8d2f180d,
	0xc84f5453,0xabc5bd55,0xa1d90607,0x0c33a9ed,0x66ebf8cb,0xc675ba01,0x9697f491,0x33515165,
	0x3b07b9f1,0xf39d65b1,0x6b0f9d93,0xbe0d34ef,0xc633340b,0xfb7390c1,0x33293655,0xb98f260d,
	0xa8eb46a5,0xfc53a91b,0x4a37bde7,0xf5ab4e47,0x9b972991,0x2bc37727,0x1befa21f,0x15d9fc2f,
	0x0781a1eb,0x3775fadd,0x8d73849f,0x423d905f,0x3fdd5715,0x463b68bb,0x064b1fcb,0x78a18a77,
	0x5ac747bb,0x991546c5,0x19654bd3,0x7d77b621,0xaa455ed1,0xcc29a987,0xce1d23b1,0x6cd9780f,
	0xd5412891,0xb7c79119,0x892f4a21,0xeb8b3af7,0x9091a77f,0xf1636615,0x95c74eab,0xf7f5fc9f,
	0xf7f14967,0xec9b96a3,0x4e75329f,0x5b29facb,0x8705fc59,0xbc375371,0xe62f0e15,0xb9e38051,
	0xb25963b5,0x73256cb1,0xd155d4e9,0x4585d207,0x20612d19,0x25794f21,0xceb13bc5,0x0d193bcf,
	0x827b8575,0x89752109,0x9075bd19,0xee513d93,0x0de9adf9,0x387bff33,0x0535be19,0x2687d845,
	0x94d7b123,0x901d59f5,0x40f3d3c9,0x83bffadd,0x3f5b37b3,0x3311722f,0x061927eb,0x35a10f5d,
	0xe4717db7,0x2a31f641,0xee75fe11,0x3e7fa7cb,0x02fd6781,0xa589bf1d,0x343f5891,0x84554b3d,

// 1 * 16384

	0x5acdb6ad,0x5d43ad37,0x1b1bbd8d,0x81c562cb,0x25915f1d,0x92b7a58d,0xf90d1be9,0x97194693,
	0xefe7fbff,0xb163aea1,0xdf85d057,0xfb436ac3,0x125764c1,0x8fed2d83,0xe45fca4b,0x4cddac89,
	0xca476225,0x512342c7,0x0ad9d107,0xc329bf1f,0xf3118329,0xe4fd478b,0xcc9de893,0xff13b8c7,
	0x5eed1219,0x29976a75,0x42b7d6bb,0x7c2bbfc9,0xd001298b,0xac396caf,0xeea3c817,0xa1add777,
	0x9159e957,0x0a4f7ef3,0x23411509,0x737bcd2b,0xafebcba3,0xf2733e7b,0x0dd926b5,0xe31f4545,
	0xd38f19d9,0xc55fd20d,0x5f197c0d,0xc0cbe82d,0xb80f81ab,0xd6fb26f7,0x941dcec5,0x4c59af59,
	0x4613ca17,0x4f574e0d,0xdf635861,0x664b523d,0x4c2fa85d,0xaba7f8ad,0xb1d13723,0x60cdd35d,
	0xd7e1b50b,0xdf4b15bb,0xe3bdf31d,0x70af2d43,0x2e8f80f3,0x14c78ea7,0x7ddb2327,0xbe6d1f7d,
	0x6681ca31,0x0ecb2463,0x224b31dd,0x17271ba7,0x9fefd127,0x292d6c6f,0x159742ab,0x3dab5261,
	0xddf3cd83,0xf9e9edcf,0xe7b136bb,0xdb69e055,0x7f918335,0x92295e0f,0xbcedd209,0x117b1b35,
	0x58b7f779,0x5f39fe47,0x370d0051,0xa9a3feb7,0x6b3945d3,0xab911813,0xfe3b3a1b,0xe74bb9a1,
	0x3fd1950d,0xbfcd9a97,0xea0509b7,0xf8875ab9,0xdf272c3d,0xa3b3d781,0xca63b03d,0x07119dcf,
	0x6ac3a7bb,0x7f356007,0xd0b7ea8b,0xe94bd8c1,0x561d4e2d,0x9b6501e7,0x98c9d647,0x733d086b,
	0x3f8f857d,0x0383e465,0xd1c9f6e3,0x679dfdb9,0x695f67df,0xc5f5c54d,0x874f5a93,0x08c3aa9d,
	0xd2b778cb,0xd54b55f5,0x0a5bdf5b,0x49b18f0f,0xf0ad7a09,0x8939b83d,0x7a5597fd,0x9f114611,
	0x073b60a1,0xbf9d1b87,0xee0f510b,0x703732ab,0x224969e7,0x9d7f79c1,0x3cbf35dd,0x281d4cef,
	0xaea15077,0xf00d7461,0x6707958f,0xe6650ef5,0xb2f7a133,0x2d9b5163,0x9fedc80d,0xd05781e1,
	0xa8e73049,0x16ab184f,0xf5e53303,0x01e96adb,0xf5f7ae29,0xf6e1cf2f,0x9bc36ee7,0x1eb19813,
	0x04915c8f,0x860bd799,0xd1cb8bfb,0x82f54dc3,0xfd0be37f,0x691f6bab,0x6ea37747,0x149fd32d,
	0x1ea14645,0x533d3b0b,0x085b7f97,0xb43f1f99,0xb877f871,0xc6a927e5,0xbd6dfa85,0x4e0fa75b,
	0xc29912e3,0x75d323ef,0x9db7096d,0x8af548c7,0x16fba8bb,0x44512d65,0xb3857e7b,0x21775943,
	0x4a793c65,0xe7e16c0d,0xac83e19b,0xc6c9d237,0x25d95493,0x29696e35,0x22cb9583,0xbfc79e15,
	0xbec53143,0xc5f985b1,0x85dd1cb7,0x11f10553,0x30d5a0b7,0xefc344df,0xa3a37e79,0x54713b75,
	0xf681f479,0x6f2b1ba5,0xd16bcbdb,0x211b0c05,0xe22d165d,0x63b1146d,0xb4edc4b5,0x2567a793,
	0xb72bbd7f,0xa509b131,0xad4b9ca5,0xd37b90b7,0x62a9c341,0xc405e86b,0xdc0de011,0xb31da913,
	0xd4c59851,0xaba74221,0xce23792b,0x52c15e51,0x7985d99f,0xe21114df,0xc4e5d4e9,0xd883f723,
	0x51d50567,0x6995e2bd,0x9f132809,0x33230041,0xac87502d,0x41a7d657,0x61d5d413,0xeb0bd96b,
	0x7f5999bd,0x87e75fd1,0x61bdec59,0x934f626d,0x5ff18229,0x3919f1db,0x0bc1daed,0xdaa7c817,
	0x1cd79ecb,0x922ddea7,0x4e4325b3,0x3c777141,0xf681cf49,0x113954f5,0xa2095351,0x51c90bcf,
	0x784db28d,0x16797d07,0xb345f035,0xc251b9a7,0xf17d3bcb,0x2557b5af,0xaa91b395,0xd5655dbd,
	0x8e3f677d,0xc561f13d,0x15ebc475,0xa30b0909,0x10a51065,0x03493293,0x71b91e97,0xe4eb878d,
	0x29afe493,0x91f12a13,0x51d1178d,0x67590d51,0x723d7a55,0x8b5ff2ab,0x2a6503af,0x1a4d0367,
	0x041d8549,0xd1bfeed3,0xb91bfb1b,0xc26bf4e9,0xb3052b53,0x1069c583,0x0df7beb9,0x49fd9bf7,
	0xe58f799b,0x5cdb7f45,0x346bbd35,0xb1f50ebb,0x0e3ff997,0x77bdc323,0x7c4f380b,0xa2ef0c65,
	0xc4836601,0xadd933b3,0x62e58877,0x9e296a2f,0x7daf7fdf,0x5929ec15,0x1bd18483,0xce91a05b,
	0xe5fd0377,0x01cb1ce9,0xba2703fb,0x79b97733,0xd993bd61,0x1f03c961,0xf95d8579,0x10d9d405,
	0xfd7fbf77,0x783fa431,0xa657f35b,0xe1d5a62d,0xf8b3b5db,0x26190c97,0xa85788c9,0x6837f40b,
	0x4d0b5bf9,0x334d2b55,0xaa13d6af,0x3e310809,0xd04b1185,0xddbf2fbb,0x62a1e8c9,0xad9dbd99,
	0xc5218f77,0x7781ac9d,0x7e818a95,0xe0ffee31,0x9421bd17,0xe7c91559,0x289bac57,0xb47ffe57,
	0x24c7a4ed,0xcbf15ad5,0x3341e823,0x26ef8a8f,0xd67589cf,0x3885a87d,0xe12926cb,0x6acb346f,
	0x197b1bd5,0x1a2f4145,0x4e7364f3,0x97358f8d,0xa80bcd65,0x36c77cad,0x79ab9801,0xf8f72e8d,
	0x5f414827,0xce4be3b9,0xecbdb323,0x0383d015,0xb8230211,0xdbe16df7,0x0605cc51,0xe1f3abd9,
	0xe09bf25f,0xf6d9de7b,0xe13f6149,0xa80bdf91,0x747f6691,0xd3a540e3,0xe097bc95,0x2331fbfd,
	0xd68bf775,0x64e98655,0xd59d7a81,0x4b7db1e9,0x29619e1d,0x9c65427b,0xca452e27,0x54a59f25,
	0xe891e8e3,0xcc0d888f,0x69f52665,0x5f0d3b8b,0x218d506d,0xa6f3e849,0x0a7152e1,0xc8bfe5fb,
	0x4cb1aca7,0xe2598af3,0x54eb490d,0x1e6b115d,0xc643c9bf,0x76a17059,0x8efb691f,0xac6f91a5,
	0xe76f1d35,0x805dcbcf,0x83a12317,0xafcd08cd,0xbf479acb,0xc1418131,0x0c475bb9,0x272b73d1,
	0x6bc9a98b,0xc12dc1e9,0x39bbf199,0x43e1d7c1,0x12d938cb,0x8f25c9df,0x1d35620b,0x7ae50ea9,
	0x7b43f523,0x2259bc8b,0x31578e2f,0x35d9b4a5,0x45bb9d79,0x5b1fa1eb,0x63299feb,0x240b34d5,
	0xc5dd77f5,0xa3f58381,0xbb1b0ef1,0x2b6bf663,0x7b2fe70d,0x3281a95f,0xa603c5b7,0xf993a97f,
	0x2a1d1e7d,0xe891f715,0xde25667b,0x34c5b463,0x94f9f845,0xd51b68c5,0xf427b047,0x4cedc053,
	0xd501e9b3,0x5541b011,0x781b03e9,0xec9b6693,0x53591859,0xd543f127,0xc27708f7,0x0a0bfd79,
	0x620d8f13,0x31959fbd,0x5d1d72d1,0x981d855b,0x75139303,0xb7c97c0f,0x0c53e59d,0xd75fb59b,
	0xfb431895,0xc79fafe5,0x77cdfb4d,0x470129a3,0xd765587d,0x13fd0b89,0x739f6897,0x35ddade5,
	0x792584b5,0x83f362d1,0xe94d41fb,0xf375acd9,0x96159d81,0xb3b50a1b,0x60bb60bd,0xa0f3bbff,
	0x82b5666b,0x15a1734d,0x293fe7f1,0xa22b48e3,0x2b657b49,0xb33fead3,0x228be96b,0xae976615,
	0xad738533,0x8e3d74a3,0x25c52acb,0x8259b82d,0x90158f8f,0xa171c939,0x0e710a77,0x2f3982cf,
	0x9d657d05,0x81d9729b,0x638184a3,0x0dadd5a1,0x5b679c8d,0x9f990957,0xa04d583f,0x4dcdd957,
	0x25095e5d,0x27039181,0x1d954c11,0x285b3ca9,0xe31d28fd,0x818df7b7,0x9a83939d,0xafc1c159,
	0x65634e35,0x76d1ae1f,0x65a35431,0x4113e92f,0x5b7b2019,0xed9b6965,0x25f349e7,0x950bc2fd,
	0xedf32603,0x4cd5fdbd,0x43cf8c9d,0x7109d79d,0xf741719b,0x7c975be7,0xf20174fb,0xf81b36ed,
	0xdcbf13c7,0x871fae27,0xd6b7a16f,0x9befa4db,0x07b1b1bd,0xd9d3954b,0x548d1b31,0xade3e655,
	0xfe4739f7,0x264385a7,0x73819b41,0x8ff72e57,0x1c8fb939,0xe3234419,0x69fbef63,0x85d5aadf,
	0xed8b4f8d,0x6d518305,0xc5cd7f2b,0x25d131f7,0x241b4549,0xc8d59f59,0x352df0ed,0x69e50eb1,
	0x340f4005,0x01db7d8d,0xefbbeec9,0x60b1ee27,0x8b1997a7,0x2dbd8699,0xbf830ba7,0x7e81ec7b,
	0x69d5cb57,0x0bf5c507,0xa9f1c835,0x8e49c1d3,0x5cc7168d,0x472d21e3,0x38dfb7eb,0x429f0f61,
	0x555f25ff,0x5631c1bf,0x638fc609,0x66c9cc61,0x62ebecb5,0xfcf781bd,0x17a79a93,0xafafd311,
	0x0bad98f7,0x6d9d947f,0x62371f5d,0x2ce58dbd,0x45c7a959,0x096d3f33,0x38b924fb,0x59a5c3b3,
	0x104521b7,0xc1d1b691,0xe20b27cd,0xcdcf864f,0xac1be033,0x19611bd1,0xff7734fb,0x8eef3df3,
	0x75251239,0xc4d999bd,0x35adef73,0x0137d705,0x5b29c97d,0xec23a19f,0x75c5b4ed,0x78830ef9,
	0xfad1b0f9,0x0b4d484d,0xe63fe2e9,0x6953e147,0x56b3e1f1,0x7389c327,0x6c053bab,0x39d1146f,
	0x304bd8f1,0x6c39050f,0xd3636b47,0xb2d1e6fd,0x00fd8acb,0xf3e37b73,0x9917ac91,0x10cbdc81,
	0x93159999,0x2133eb49,0x533d8e29,0xb4e3aa95,0x3ac7a9c1,0x24036e0d,0xba5fd777,0x75e345d7,
	0xaf2fd6ed,0xe64d8ec5,0x526b8da9,0x913d0ef5,0x8353490f,0x4d3986ff,0xb3bd18b7,0x3c0d1f9d,
	0x3f1fe965,0x1a179bcf,0x74138861,0xd411b789,0x1865376f,0x6b5b9ad5,0xaf95f92d,0xb0b9c97b,
	0x4be33dfb,0xdda37731,0x31d3196b,0x9411a83b,0x163da81b,0x4cb70695,0x3ec7ce31,0xbbd9d39b,
	0x4cfff62b,0x3485de35,0xfbd1f85f,0x926fe575,0x979dd2cf,0xb2234fcd,0x78b7599d,0xffdf9ea9,
	0x487587ef,0x24cf86a3,0x58ad9959,0x5adb1421,0xd5c993c1,0x6eedc485,0x1b4769cb,0xf9bdfbcd,
	0xf2c55dbf,0xd70fbec7,0x0589ccf3,0x638919a9,0x48810bad,0x88eb1b47,0xaad77997,0x20e7ccb3,
	0xcef57697,0xb65d0d69,0x16056045,0x2d29bbf7,0xc6073fcd,0x586b131d,0x924b5057,0x074ba383,
	0x4e8305ef,0x9045d1d5,0x1447bced,0x62ef4173,0xa31fb9dd,0xa8411391,0x4303a1e9,0x795f62e7,
	0xf17313c3,0xb4dfe3d5,0x20ef8901,0xfa8d1109,0xd3092813,0xd5c1ccaf,0x54e3aea7,0x9e13de0b,
	0x66471c8b,0x16b733b1,0x1321471d,0x54355225,0x0787fd2b,0xf0b9d6fd,0xa64de367,0x16db7897,
	0xaa01b143,0x6ae36a35,0x987bf659,0x5a978cad,0xd0dd1061,0xdb7d5389,0x7c217987,0x1fa5c6b7,
	0x28231763,0x48f588ab,0x5521b253,0xa2e7490d,0xbdcb3d6b,0x6adf8bdb,0xa1c316df,0xaee72d13,
	0xdaade8e7,0x4afd88db,0x03b55321,0x8cd7b02f,0x7b930487,0x863191fd,0x89136dcb,0x959180d5,
	0x6a25b447,0x2d8dfd11,0x955b0d5f,0x62992b7d,0xf5f72a6b,0x4745e079,0x6a75dd23,0x9f15a7a9,
	0x4d899c7f,0xefb9b017,0x51b11225,0x78dd04e1,0x773b5853,0x1a6dfa59,0x64c91041,0xb16737b7,
	0xea5df907,0xf3114535,0xf6dd2f11,0x4ed706c3,0xc821bbfb,0xde7b0b29,0x9d739eff,0xecf517a9,
	0xb4a3f5db,0x1ba9d837,0xd97f6e39,0xae371c11,0x4fe7a799,0x04c186ef,0x6055adb7,0xccb51eab,
	0x4edb3373,0xf0139d67,0x04b7b639,0xcb31f031,0x345331eb,0xb111ca39,0x3fcf8d45,0x4617b465,
	0xaa0b66cb,0xb95d818d,0x5a2b6a2b,0x64778f11,0x79a5d627,0xd9bdba0f,0x34c55b01,0xe90d7103,
	0x25b1f95b,0xa31dc9f3,0xb1fb09a7,0xe33b0517,0x22a1140b,0x679763fb,0xbe97a0c5,0x000bbd2d,
	0xafd1a91f,0xdb65b467,0xfac9d0cb,0x7b2dff2f,0x50870fcd,0x55ef9e07,0x0329f4ed,0xafff720d,
	0xe4ed2891,0xb2c5172f,0x59b7582d,0x4a836ac3,0x6319322b,0xd29ba6bd,0xeedd9a51,0x185f794f,
	0x3007bea7,0xbc510117,0x4a6734e7,0x79e915bd,0x189bc85b,0x5debc527,0x5493204b,0x731b6d1d,
	0xeaa1e6e1,0xed995967,0xbefd9897,0x5c974e87,0xadcda41b,0xeaafe8d1,0x0dad02b5,0x34a5381d,
	0x7cbbf135,0xbeaf7feb,0x4017f153,0x903b8409,0xfdf1bba1,0xfe3d49c3,0x1a0f49eb,0x2bf1b57d,
	0x7cd9a21d,0x4a27eced,0x0cd989b9,0x1d09e5b1,0xa2c9c9ab,0xd0630885,0xc01b2ac5,0xa26d50e7,
	0xcffdd295,0x6d11d135,0x3ae728dd,0x95b10365,0x1499ed71,0x6b77ce25,0xacb3a69d,0x7c0fa681,
	0xc9a91017,0xe701b60f,0xd65fb25f,0x37696d93,0xca234aab,0xcc476c2d,0x13372b4d,0x574722f9,
	0x4bdf3c9b,0x7a071d43,0x01e7c655,0x09df5521,0x58a5a997,0x02277ca3,0xcd893331,0xad09a379,
	0xe7212e9b,0x0ab7211d,0x169f615d,0xff472b7b,0x93e516ed,0x4eeb0213,0x7c0de521,0xf0c315a9,
	0xfa6f5113,0xc0211467,0xc4277c8d,0x1451428b,0xae2383e5,0x46e10789,0xa5a5b477,0xb06b17b3,
	0xd34d437d,0x23d9226b,0x30a5ad7f,0x70316cbb,0x5823663d,0xf0dd408b,0xd7b1010d,0xb46f9843,
	0xcdbd79d1,0x41efeef1,0x18b9c651,0x84999cf5,0xe123582d,0xe631a927,0xc615b73f,0x1fc57681,
	0x7441dc8b,0xc8f53645,0xef857599,0x2db986a3,0x56ebb86d,0x72af25e5,0x6b31efe5,0x8fdf2219,
	0x9fdb68a3,0x29ff6d2f,0xfeabe673,0xd2473dad,0xa5b74a3b,0xb4a923cf,0x27e99059,0x3cab3b33,
	0x980bcf93,0xb89f60fb,0x864d6079,0x8371d681,0xb84dd54f,0xbcf1386f,0xe39fea77,0x189f3279,
	0x32d71757,0xcae3d773,0xdd0fe7c3,0x1ce90605,0x97edc5e3,0xaed9c1d1,0x2c335c97,0xf0abe917,
	0xf4bd3a69,0xd9632edf,0x900fdcef,0x64e3c1a5,0x8c5bccaf,0xe033867b,0x5609f193,0x8c4150b5,
	0x30c1c7c1,0x9f2bfe0b,0x82f19d13,0x2c13df4b,0x3bd57ef1,0xf951557b,0x9c0100c5,0xcd530b7d,
	0x286582db,0x39d3b441,0x0fd921cb,0x6da5b561,0xcb23f661,0x1505a659,0x3f7fce09,0xd0530c1b,
	0x2bab03af,0x49673949,0x2765a12f,0x6f51bad1,0xfd817139,0xe0a1391f,0xa86529b7,0x0c3535b7,
	0xb91356b9,0x107d8d6f,0x70bb2ddd,0xe1452705,0x54b5f233,0xbbf7b657,0x851310a9,0x7269fbfd,
	0x9da19cf1,0x9427697b,0x697b56eb,0xfe3591e7,0x30ffe087,0xd9574f0b,0xea6b4c39,0x8ee10315,
	0x14d9abd3,0xbbf5deb9,0x85c5c7f5,0xab5193df,0xf121a7f3,0x5d975cc5,0x73d11243,0xa80fbfa9,
	0xe8b9ad57,0x71fbf6f3,0x503fe913,0x984d65db,0x125f58af,0x80050191,0x6327a51f,0xdee716e5,
	0x91c3bff9,0xc2c75473,0x8a097ee3,0x5f5b8141,0x50794775,0xaa77c7f5,0xc0cdf3a7,0x4ed9fe71,
	0x56fd96b1,0xfd71d201,0x4ac54a7b,0xa52d3fff,0xc5b3ad7f,0x993b42ff,0x7ba73935,0x2dd51c79,
	0x6de718fb,0xd38722e7,0x2095a977,0x38f37c7b,0x0acd4887,0x7b27ae37,0x89179da5,0xec5167a5,
	0x1a8102cf,0x791b72f3,0x301b35f1,0x346331a1,0x5709fac7,0x11898da7,0x04fdd54f,0x553fc71f,
	0xcf4f84a9,0xc4c1066b,0x547b6681,0x1ba91adb,0xa0296af9,0xd0374dd9,0x51bdc10d,0xae0db293,
	0x4d53e381,0x4f89da19,0x3f532e43,0xfd7d5413,0xba71a457,0xfd7fe3d9,0x38370e3b,0xd6b1d229,
	0xc40f18d3,0x9507434b,0x98c79cd1,0x930df9b1,0x78a1b69b,0xd2356d2d,0x07cfd6b1,0x699b9e8d,
	0xf1837299,0x134b8fc7,0x1f7b7e45,0x600dc8a3,0xcbfb55ff,0x99abcfe3,0xb66540c9,0xdbbd00e7,
	0x42353349,0x6ae7a5d7,0xc88ffb39,0xd2adbe4f,0xe4437b3d,0xd1b55a81,0x005d1f5d,0x9c89f2e1,
	0xf12331e3,0x7eefa447,0xdfa338c5,0x63a3b8a3,0x4fb9038f,0x4aa16415,0x889991c9,0x35f31ea7,
	0x27d179dd,0x94f58261,0x26ddf885,0xb61d1605,0x1b2150af,0x4743ec27,0xf879a3e3,0x6c6b7ee1,
	0x1e41eb31,0x7509afef,0xf6dd3893,0xb7cd5561,0xf1b9e8d7,0x9ced3ac3,0x1fe1ee09,0x5ee1feb9,
	0x3af5da5b,0x89bdb539,0x5ec5d389,0xc0e9b621,0x3d4716c1,0xd371806f,0x15313515,0xa6cd19db,
	0x32efb055,0x0025d30b,0x4437207f,0xb41fd82f,0x460d89a7,0x45217637,0x554d0a5f,0x781b7c6f,
	0x29af8a97,0xe7d1a2ad,0x83559311,0x1ea35bf5,0x52c9f543,0x3ecffda7,0xe3956bbf,0xc13fa321,
	0xd139db1b,0x52d5b5eb,0x0ec15b59,0x5825825d,0xc8c1b1d1,0x1fcbc0c7,0x69ed6395,0x4b2d7b19,
	0x8a0f085d,0x75c1370f,0x0f9d05f1,0xa2d9cccf,0x4bb75c07,0x79ebd221,0x58b7a8b5,0xd9550203,
	0x83330d57,0xc7a988e1,0x058b1bf1,0x4b719d39,0xddeb7521,0x317f4cbf,0x06d33e7d,0x49a9e605,
	0xda271981,0x221de6ad,0xe6adc2f5,0xc91fd601,0x001f02d9,0x9d59f42b,0xd1a514c5,0xb49d25cf,
	0xbaed30d5,0xe12f043d,0x3fa75d17,0xdd937a15,0xd1952f69,0xa6c9d46f,0x3d0da7e7,0x8d1fb085,
	0x8005cbcf,0x0373add9,0x539728f1,0xb5014cdb,0x3011e98b,0xe9a5e217,0x136fa0bd,0xc0a505d5,
	0xd2737769,0x49fb684d,0x3c23e19d,0x061b723f,0xd7d3847b,0xd43b9a29,0x85ab74a3,0xd71fd5e9,
	0xc9b9751b,0x585710e1,0x096b5eb3,0x32110eab,0x839d57ef,0xc761a233,0x4b270571,0x12ffa167,
	0x0bd95ae1,0xd4997d61,0xe20f344f,0x6499e709,0x0cb36023,0x3665683d,0xc1bf4183,0x9137597f,
	0xed55b333,0x87551c17,0x2335530b,0xb3df00c3,0x8ad5ddd3,0xc71dc2d1,0x0dd9c3af,0x693bffd5,
	0x912d9d0d,0x7b9b93cd,0x807da7ff,0x409b41c1,0x7445f635,0x71d790f9,0x3a577353,0xccfb4697,
	0x08e76be7,0x1eff63cb,0x2409bcc9,0x55fb1071,0xbdc75305,0xa1695a3f,0x589b2447,0x28e9306f,
	0x748147bb,0x619183dd,0xce7b577f,0x89b3f3b9,0xfa9bc27d,0x5321eeaf,0xa08536e5,0x43f7b083,
	0x227fcd07,0xd5e5044b,0xf6f51abd,0xdbf53305,0x7c83d759,0x36d306cf,0x90773809,0x5f974a81,
	0xafe3acbf,0xd10bade1,0xeb19259b,0xd7717641,0x73c188cf,0xced1e3ad,0x0d55810b,0x57bdb293,
	0x282d4c63,0x8a95a1e9,0xef0bb3b7,0xb15b65d3,0x0f19d29d,0x8fedeed1,0x8281d7c5,0xc2d76d61,
	0x256365e7,0x3c97fa2b,0x5d69bd27,0x69654aa7,0x9bcd54f9,0x01795a45,0x01db0e91,0x11db7015,
	0xf003a7cb,0x43a368f3,0xc7599687,0xe9bfae27,0xa59bf49f,0xdd47c093,0x63c7a44b,0xb03bc05b,
	0x9f115503,0x3ec9d909,0x147990ef,0x271dfa3b,0x16c97acb,0x2fa9c4c5,0x6725644b,0x23e5145b,
	0x380fe50f,0x2f9b0dbb,0xa2ef99fd,0x40b11951,0x58193533,0x7771b267,0xd15b066b,0x2d4f72bf,
	0xceffa3e5,0x9a2d42cd,0x6759dbc7,0xa02d1651,0x70c99615,0xc5f11d7f,0x8e45cf07,0xe767d2b3,
	0xa66351ff,0xa50fcc8f,0x0cdd5ce9,0x19c1bca3,0x269fd427,0xdefb829b,0xd0492ef7,0xe7a3bbe1,
	0x4f3bc459,0x3955b7c7,0x151ba07d,0x0c213833,0x1ddb8aa7,0x58e1e6c3,0x30496395,0x5df5e66f,
	0xc90d846b,0x228f69c1,0xf835461b,0x807fb56d,0xf941594b,0xbc757781,0xcda516bb,0x34cbdb0b,
	0xa1d77031,0x2ed14045,0x44cda9e1,0x4a8b0137,0x7a118451,0xa5072adf,0x6e41fec3,0x311b92df,
	0x161d5a23,0x4eab319f,0xc0058465,0x287928fd,0xa00d946f,0xe06d5f67,0x9e7f7e89,0x12531793,
	0x30dfa93d,0xb52f6c99,0x857f8ac3,0xe2fb1aa9,0xc979f6e3,0x8ef77c23,0xd13f4565,0xb2692351,
	0xeba3f8f9,0xf7f1f87b,0x275d0e93,0x6d4344a3,0xd3159d63,0x4375909f,0x7fe3ef33,0x25cfc0c3,
	0x4e67b94f,0x2f015511,0xce419df3,0x050135d9,0x38239e2d,0x233df4e3,0x4a51a449,0xdb73eb15,
	0x8fb1ceb9,0x14f31aa5,0x594fa379,0x52693db3,0x3265d3f7,0x061de977,0x16e5b985,0xbccb2df1,
	0x347f3233,0x26d999ff,0x7e250641,0x882b0c19,0xda1f7dff,0x966b3769,0x3287503f,0x4dc7457f,
	0x30559137,0xc4417c6b,0xe8e9c9e3,0x837d5177,0x4611dffd,0x70f5d041,0x7095f653,0xccd9be69,
	0x0533edbd,0x4f4363b3,0x5c39ae7d,0xec0d5eb9,0xab7fe229,0x450f6e0b,0x4af14617,0x52f395d9,
	0xe39f3e3f,0x4c6b8a1f,0xd13bd0a5,0x540dc545,0x7e29b141,0xf48d334d,0x01ff8669,0xf387d97b,
	0xca970db9,0x82d1627b,0x978f4977,0x5833f707,0x90515e7d,0xb3bd4b15,0xbca14aa3,0xdc894779,
	0xa7a11ba5,0x1c01380f,0x7557ce8b,0xbfade669,0x32bb7f95,0x297388e9,0xa837129b,0x7669ee79,
	0x76bbfbfb,0xc411cea7,0xc73551ff,0x9c2fa655,0x54a5cec7,0x8f0108d7,0x18a5eaaf,0x8419cda9,
	0x6269b735,0xc993028d,0xa04ba269,0x69e90a33,0xa3d7cacb,0xd039cf67,0xa84d0bb7,0x430b74b3,
	0xe3ab6a4f,0x3d976889,0xea3b0ae5,0x2f8f45f1,0xac8d56d9,0xab6d69a3,0x580f7b0d,0x8b31a3bf,
	0xe207e6c3,0x13afede9,0x8527f30d,0x9e538df5,0xf98d5aaf,0xd16f8d15,0xaf4daa8d,0xeeffeb77,
	0xd37b5289,0x41ef7871,0x67b17ef9,0x31e7b72d,0x34176285,0x0591b7c9,0xdbeb188d,0xdb654d07,
	0xdc8bc81d,0xe0e78671,0xbefb2f47,0x507bd6ff,0x43ef3f15,0x3da5d045,0xd24befeb,0xb7d5da17,
	0xf039f677,0x4babcead,0x0ea9810d,0x6ac3e357,0x6f53a597,0xc1fdc597,0x6d4da801,0x064154d1,
	0xf007c113,0x3fcbe075,0x50d98de7,0x1bf1529f,0x7b0bcfc9,0x4d6b2f47,0x8e55a4a5,0x831dcfe1,
	0xcbf7dfe9,0xfd5bc38f,0x1631abed,0x49b5bbc1,0xca531be3,0x2d41ed5f,0x3d45d635,0x45574e6f,
	0xa28b7f75,0x66eb9847,0xa5d10dbd,0x44457627,0x7ef1ac9f,0x6151c869,0xc87d5989,0xde656427,
	0xe0c3e0af,0x218f3767,0x1d59626d,0xe64d39bb,0x99250937,0xbbeb116f,0xe4df17fd,0x7a37d531,
	0x6223f913,0xb4d7d237,0x90ef7599,0xb505bee5,0x17b1bd65,0x01e541fb,0xcdd16767,0xff413637,
	0x90ad1299,0xaad59283,0x2b33cf59,0x001b5e93,0x17d9f963,0x0a8d9c19,0x652faa25,0x2e718c65,
	0x84e36bbd,0xb01d3a93,0x4d47544b,0x01c3b22b,0xf55d31e9,0xdfb9ca4f,0x5361ef0f,0xc33ded63,
	0x25c7d777,0xb3bfc533,0xaecde585,0xfeaf3399,0x6a81c035,0xddb77fab,0x27459181,0x93951f5d,
	0x48d95d43,0x074f05ad,0x7de700a3,0x660fdd47,0xb00381ff,0xd35d17b5,0x763dd953,0xafeb38fb,
	0xd21dd919,0x7edf47c9,0x7f375fbf,0xf197ca1f,0x9d2b7981,0x21f93677,0xfc2d9adf,0x83314167,
	0xd4159b75,0x90fdefd3,0x2ddf9971,0xc579d58b,0xc7b56d75,0xdd61687b,0xbb77d6ff,0xf2dbd04d,
	0xafc3094f,0x76bf1a95,0xdb83c0d5,0x90673b75,0xa3e78915,0xebe3c2cd,0x1cfb5b0d,0x7ed7add5,
	0x34a93c23,0x4bb73d57,0xd0410585,0xab913847,0xa481fc1b,0x265382f3,0x101d60e5,0x619b72ab,
	0xc0c9a1e9,0x2df5c5e5,0x6abf539b,0x3aaba8eb,0x5ac59ac1,0x7803aefb,0x2abd2edf,0xb01727f7,
	0x60a39d1d,0x5e0dba89,0x401bf3b1,0x4be5aac9,0x96777dc1,0xfec7b56b,0xc93fb7d7,0x79bfe763,
	0xef3d24b9,0x5f0f5a0b,0x3bfb2adf,0xf7f33bcd,0x85d7a255,0x2aed0d51,0x2e853b23,0xe8817b1b,
	0x36156435,0x168dbbb7,0xc07fdac1,0x8207da63,0xd5a78a37,0xdf49d635,0xa3efe4a1,0x60d3fdc7,
	0x0d2f5b8b,0xec9b6f55,0xc6472171,0x77d32571,0xd12bdba1,0x912d7823,0x99616ca9,0xa1a57a91,
	0x7b0b7f37,0xebcb1d31,0xfc79f989,0xd1897c63,0x8223014f,0x686b43a1,0xc53bb815,0xe4698d25,
	0xd4af5833,0xe12b2615,0xe8b5da21,0x11d99f23,0xd0d3ca77,0x5f5511bb,0x44617841,0xfd1101ad,
	0xdd9923f7,0x7c534349,0x071d56d5,0x65f54e1b,0xa3f90ad5,0x62bde3fd,0xba33cb05,0x7a1174cf,
	0xe7cf747d,0x6f4f2699,0xea53bfbf,0xc593ea35,0x00db3aa3,0x71f3846f,0x7095dabb,0xc457f3b9,
	0xf3cfd041,0x8eb71a4f,0x5b79c179,0x12e114d9,0x2b3b169b,0xbecd259b,0x77e97e3f,0x3f599c15,
	0xd09d523d,0xf197a135,0x7a33051b,0x3a934ff5,0xc5573ff7,0xcd9b028b,0xc70fd8e7,0x69073c0b,
	0x3bb949e9,0x11851691,0xdc9fd041,0x53db9def,0xeff5dc71,0x952ffec9,0x5b6bfa91,0xf9d5f245,
	0x0129db3f,0xea934e33,0xaf63a505,0xc06921b3,0x6a573645,0x9ed9465f,0x58dd7f97,0x04b1cded,
	0x1b6b9ebb,0x1b513461,0xd59de201,0x4c71bead,0xb23b5c29,0x266fedd9,0x29c930cf,0x17116eaf,
	0xd3854157,0x04d16de7,0x08f3624f,0x4ea5b8c3,0x23e9c159,0x3a3f923d,0x9f11a397,0x58e5a4b5,
	0xe0f5248b,0xeaa7f80f,0xf9831d87,0xc8355461,0x1a1ddd8f,0xdb1ff919,0x1015d9c7,0xac9f10a7,
	0x89bdfe53,0x12e5c8a1,0x6df3c7c5,0x84d57671,0x0e1bcd07,0x1c5db075,0x7ab7e1b9,0xcf33c3af,
	0xc2637927,0xe6196de9,0x636371a3,0x3ab7445b,0xb7a7f077,0x43cfaedb,0xa35d7649,0x780fdf77,
	0x4de7d401,0x0f5baeaf,0x2d752839,0xaa8dc40d,0x2d038d1b,0xe9c3f355,0x34e39ecf,0x7929362b,
	0xddc9825f,0x9c372a3f,0x964b9525,0xbf877bed,0x02ed6cad,0x190f256d,0xe0b14f25,0xdef1ea75,
	0x320dcc35,0x1cc5f863,0xfe879e7d,0xaf5912e9,0x6cab7d69,0x6f01352f,0x7ea507a5,0x10590f7b,
	0x39356e01,0xc3914963,0x7d4b06dd,0x1a33f067,0x5bff7205,0x3b6dfb21,0x2d21752b,0xeed348ed,
	0x304338bd,0x85b1060b,0x00390d5d,0x2acbdc53,0xa12761bd,0xa0a5d851,0x7109110d,0xf6536aef,
	0xc2b9b1e1,0x3ab76fa5,0x6b730d9b,0xb64f9f17,0x0ae9684d,0xb37b5647,0x55bfc12b,0x5d491a2f,
	0x2a97b369,0xbcb3bff9,0xb99d1fad,0x5c73a19d,0x868745eb,0x9b41c70d,0x8d2377d9,0x34a76bd5,
	0x50630bcd,0x0837c953,0x1bd5b82f,0xa7678d4f,0x3fbfff55,0xb1c9e52d,0x8f99d3f5,0x87df858d,
	0xeb1b1e09,0x5c57967d,0x19c1483b,0x2bdfec17,0xc0d77dc1,0xa36573b1,0xbc03c0d7,0x7ce33d7f,
	0xa0438197,0x5aa50abf,0xb17fdd69,0xa90dc85f,0x128f2eeb,0x8ee7de23,0x77c11659,0x7427ba57,
	0x23dda26d,0x272f81e5,0x77b5c1d5,0x28a34d0f,0xdc2ba50f,0x25a1d88f,0x4eb538d5,0x289b133d,
	0x5869610b,0x888d7037,0xb7831c19,0x1ed16595,0x836b36e3,0xcb65ff7d,0x1343b927,0xcfb1efdb,
	0x6eedb267,0x07cb0283,0x928b8f4f,0x8a4b5dd7,0x4c919fa5,0xb68577f7,0xfe4df4a7,0x395b285b,
	0x06e73ffb,0x107fbe0d,0x20eddb0f,0x14438241,0x7a619f0b,0x0fd38f87,0xcf33b52f,0xf00b6569,
	0x4e5b07c3,0x10bb20a5,0x914f7b77,0x3069bfbd,0x6e1b9953,0x129f5c37,0xebd9d11b,0x58b5c02f,
	0x21cbfc37,0x990f4091,0x48d1491d,0x3cf143b5,0xc7813733,0x2cbf5c91,0x80a1cb43,0xd2c96255,
	0x2c39a453,0x7c8f6c9d,0x0317191d,0xa28d1c13,0x84d705e9,0x1e83179f,0xa06b7301,0xd8392605,
	0x0725bb91,0xf0cbcc11,0xf23f5d0f,0xf46dd741,0x22db172d,0x1abbbced,0x649b842f,0x1d7735eb,
	0x5a95d1e7,0xadd5feb9,0xdeedc311,0x10472429,0xbcd5a137,0xe6bdc483,0x0d114729,0xb175ad2f,
	0xfd07ebd5,0x0e41bcdd,0x4845d5b9,0x3e477233,0x2c819ec5,0xfa578ee9,0x203130c7,0x1da7377b,
	0x137f2251,0x2f1f774b,0x83e59c23,0x5125914d,0x2a256f0d,0x9fdf052d,0x8adb8263,0x85fdb0fb,
	0x317f42d5,0x1003f749,0xddf339e7,0xc60f51dd,0x6c8175cd,0x142338d7,0xc073e9d7,0xc8e9c657,
	0x79096f5d,0xb2fdfea1,0xb90d8f23,0xe4b924cf,0xc8d9bb3d,0xa67703f3,0xdad9217f,0x9f5d94b9,
	0xba9dbe63,0x3ca1e79f,0xae59d86d,0xdf55bb8f,0x52ed8c15,0xd8afa907,0xba719033,0xbccb49cd,
	0x9541dadf,0x13ff450d,0xad774ee1,0xf293a803,0x7cff1993,0x7f197321,0x261de94d,0xef27c3bd,
	0x9673a44d,0x02ab8235,0x1c87c817,0x85a9fc95,0x37d1196f,0xe08955c7,0xeb3dcca9,0x3ee1312f,
	0x5a37cea5,0x54b582df,0xf82f562d,0x4a43ec33,0x12a765e1,0xd6518d07,0xfdb5669d,0x0eebb153,
	0xab0f8261,0xf8af4357,0xf38fe7b9,0x5c996a45,0x5b419da7,0xec433d69,0x97e71007,0x3cb7f3cd,
	0xa1fdfc7d,0x9fad7865,0x9849e7d7,0x6359cab5,0x3de3c3f9,0x80b113f7,0x5ab3ee41,0x4039d8cb,
	0xc6812e73,0xdd412f55,0x6681de21,0xafb761eb,0xe54de08f,0xe46de63b,0x6d7b9321,0x4bdf10f5,
	0x2ea15e3b,0x47796df1,0xf4d50eb1,0x5d6524d3,0x9ac19fa7,0x7ac95241,0x9e239d05,0x6c9fbd77,
	0x9edbc651,0x96edd281,0x10691a1f,0x729348d9,0xe601f1f9,0xd9975e8f,0x810d56c5,0xa9e90ff9,
	0xaa3335ad,0xc6a933d1,0xdce19d87,0xfff5e3e3,0xad51acbf,0xe9291a33,0x911957bb,0x25b1eaa5,
	0xd22bafcb,0x3445412b,0xf45bd283,0x40bd8c5d,0x557129b3,0x04513cb5,0x4fab23c3,0x3c658027,
	0xa6c30ca3,0xbfcd2257,0x877d2f2b,0xba9bf931,0xe1a5e70d,0x1861c61f,0x64a5cb35,0xa4fbf3a9,
	0xe68198af,0xebd717a1,0x7d65061d,0x5dc3a1c9,0x13ad278b,0xc52b9efb,0xbe678aeb,0x90e3f8d1,
	0x9e63b4ed,0xfd7519d1,0x93b9266f,0xa4e75e0d,0x8bcb9265,0x7cff3853,0xb1d36c3f,0xcc0f73cd,
	0x49ed76d1,0x1c377a33,0x7e997bbd,0xb539066b,0xe8c1d355,0xa4b32bb1,0x1a4fe50d,0xdcf11947,
	0xf321485b,0x72318291,0x08a7ae1f,0x7e6913c9,0xe7d33a95,0xb395db21,0x79b777ad,0x247b0e65,
	0x528187ff,0x4bf31535,0x3303c233,0xdaab3f95,0x84c15cdf,0x537b1129,0x187352f9,0xfe2188d7,
	0xef0f28bd,0x388f4ce7,0x5553b90f,0xaeb123b5,0x19cfb36d,0x80b3a0d7,0x2561f24b,0xdfd36ec1,
	0x3e4b5209,0x29991cf1,0x3db9304f,0x09abda95,0x7fbb3bf9,0xaa1305b3,0xd5e3bd7f,0x7a03f6d1,
	0xc43bffe3,0x9321f121,0x50d3020d,0x454d9f1f,0x2dcb18bd,0xd0e903c7,0x85dda8ed,0xd7a34831,
	0x335da2c1,0x8bbb4dbd,0xa9c5e4e1,0x25c96cbd,0x59c13073,0xa90b479d,0xd7b1d56f,0x7e271a87,
	0x8cb5bf9d,0xec776f8f,0x3a310be7,0xf9cf9f59,0x17ddce55,0xb8c70641,0xd43f3061,0x8d7d5603,
	0x3fc58ff3,0x70e9ebe5,0xea3bc6bb,0xba93935d,0x7ae1421d,0x78f19d39,0x0aeb139b,0xe01bb349,
	0x4a8da1bb,0xd7215085,0xb8812171,0x2bc745b1,0xb40f8005,0x74db3293,0xb195e577,0x2af35b87,
	0x59937771,0xffb1c3b9,0xda2984a9,0xfb9df3c3,0x332bc0c7,0x6a5954d5,0xc4a1b8cf,0x1d738865,
	0xe7d5280f,0x0dada44d,0xdad15579,0xe2c5bb79,0xc675219d,0x69b99b0d,0x26f1ecff,0x818f240f,
	0x5ed7ff0b,0x86a7298b,0xbc9f957d,0xc4733b3f,0xbaaf4441,0xf5cf44c3,0xc1e5cddf,0x5bbb692d,
	0x369b1c65,0x72af033d,0x183382cf,0xce593201,0xfb1deeed,0x23edda03,0xa56133c9,0x0ae782eb,
	0x15a31493,0x7c57f9ab,0x3caf3809,0x98a71f25,0x317fac5b,0xbbe5cb53,0x27c52397,0x68852cf1,
	0xf0ef908f,0x10b38d9f,0x4fb54c43,0x4611e297,0xe6196bc5,0x580911bf,0x05f56ea5,0xe8875369,
	0x2c05edd5,0x7f539867,0x6d677319,0xa3c95cc1,0x9fa920e5,0x852bced3,0x835152cb,0xb961b2fd,
	0xb8e3de5f,0x1a4bebc9,0xc8671ca5,0x49810e8b,0x037563f5,0xe29bec97,0x89bd1a63,0xe40378db,
	0x380d08a5,0x562bf211,0xc9d71581,0xb969b963,0xf53f11af,0x422fbd95,0xc99bbc47,0x6bdfe2a7,
	0x1885a7a1,0xea074e07,0x315926c5,0x8035ff2f,0xb745eb4f,0xc8379cd7,0xd9cb7bd3,0x6ee7de8f,
	0xb7cd2acf,0xef6f7af7,0x3511b60f,0x5515025d,0x0a4d368b,0x0b858de7,0x57b188df,0x458dab3b,
	0x81e5d629,0x02756cab,0xa19d6575,0x39bf05d3,0x4d995d9f,0x3569dccf,0x072d9fc5,0xa2c577d7,
	0x11536227,0x61ad2f6b,0xfa23b391,0x9a610cfd,0x9ee78f45,0x21b9be19,0xf2a3a961,0xb3fd040b,
	0x4f159bc5,0x0e298803,0x98419b81,0x6daf7bc5,0xfa7d5eb7,0x7ec3eed1,0x8af55b09,0x412b4001,
	0x92af047b,0xeb7993bb,0xcc1d34db,0x54d9b695,0x5b1d63b1,0xed5d547f,0xc783d69b,0xccbfec65,
	0xc2237243,0xdfaf685f,0xfc5753bb,0xbb93c257,0xda05da69,0x20d59d2d,0x462f4a71,0xb3ad3a5f,
	0x71f3af9b,0xf35fb439,0xc60f28bb,0xf80fe475,0xcefb439b,0xff01df65,0x6b5f9161,0x4d636b9b,
	0x051f1b77,0x71995e13,0x1cebe0f3,0x6afd42d9,0xf0410481,0xc02f3a31,0x81f1d2c9,0x0bd77241,
	0xcd2b4955,0x07f12535,0x6b0b4601,0x9f9383eb,0x729506d7,0x0f35751b,0xdb472281,0x9b7990fb,
	0x2a1ba12f,0xe6774169,0xb1115dfb,0x6b7f6e99,0x293d58d3,0x2961a02f,0xef4520e5,0x033bfaf5,
	0xaa6dff7d,0xdfbf02fd,0xa61f0b7d,0x0ef38a49,0xa5fbcd31,0xfe87b3f3,0x7c4b9acb,0xc49173d7,
	0x2b23553b,0x88d972b7,0xd7d9ad9f,0x54a5bee7,0x590d9b2d,0x50f93175,0xa73f2991,0xfb69efcb,
	0xf7c347e1,0x5957f1e3,0xca5dbfff,0xb1c3f4dd,0xb139fe7d,0xd589c23d,0x1b7dd30f,0x7e39337d,
	0xea4dd16b,0xcb4dda49,0x184f7ab3,0x65ffb515,0x3bc1d75f,0x5389d855,0x2aeba9a1,0xfdf17417,
	0x8b41e051,0x7b4d1e35,0x92d37257,0x9b8fc8f9,0xc4634a89,0xc4cb4e47,0xedeb6c1d,0x2603f73f,
	0x31a3f78f,0x4867e86f,0x61873805,0x8721da73,0x75656137,0x75a1071d,0x635f25e1,0xbc63b323,
	0x22f5ce9d,0x742d3c45,0x2291f955,0x87e913eb,0xf787a925,0x24dd8e61,0x90a7cec7,0xc17fee6d,
	0xb339f177,0xc2b3957b,0x0a912063,0x4797c04f,0x920dd489,0x23d1b81f,0xa1a5eb25,0x904de045,
	0x64f16097,0x9a898861,0x04a7f3c9,0xda61eb05,0x4ab75a21,0x764f40df,0x08bf2bd9,0xfe3d5055,
	0x091d30f3,0x24c361bd,0xd27936a1,0xdef5fffb,0x05c71523,0xf2a96dab,0x9ed10e3b,0x7b4136c9,
	0xdf412c0b,0x6cf1c6db,0x2c27c885,0x9e856b97,0xa601e54d,0x61b1ac0d,0xc3437c25,0x31cd5c49,
	0xb55f6fd5,0x81275583,0xe053458d,0x2cc73ac5,0x2ca54ed5,0x9eb7320f,0x7bf36bf3,0x26cff9ff,
	0x07f90ecb,0x91f54401,0xf41fa655,0x87e9baef,0xd9751a79,0xb7919e3b,0x9543807b,0x59bd5997,
	0x2211afe9,0x126d011f,0xc32ddff7,0xb89f19ff,0x4ab3f56f,0x0c8f979b,0xc217a91b,0xe4877539,
	0x3d292ea7,0xd823d425,0x1f9f840b,0xf219065f,0x9d231175,0x70816dbb,0xbbd1c1ad,0x1b9f9791,
	0xa1413b01,0x3b297cdf,0x721960af,0xb20b4ef9,0x8c07c4c1,0x48bdb8a1,0x62513287,0xadf9fbc7,
	0xc4ddf971,0x360dd397,0xd9b92079,0xe0a78335,0x911d2a11,0xad11f8db,0xdbfb9087,0xc5036d85,
	0x6d01a2ef,0x85e76915,0x4c25ea85,0xf09f9301,0x04abc09d,0x87d33771,0xb5af3d05,0x24b3e8f7,
	0xcd2924f5,0xca4326a5,0xb57b026b,0xff236ec3,0x3d710c1d,0xb5d1a5ed,0x02d105dd,0x4b793ac5,
	0xa75dc17f,0xa539ee11,0x18616849,0xf3e7a767,0xb0b334cf,0x265f3e5b,0x7d43c567,0x9247a01b,
	0x6c1daf07,0xdb5539a1,0xadf578b5,0xa11d0e57,0x1231a76b,0xfb516341,0xa565027b,0x4c9166a1,
	0x5a69b885,0x73afbc21,0x05dd8ccb,0xe375557d,0x742db529,0xa8f57fad,0xe2199079,0xe8458c81,
	0x9fc5dd73,0xd7d300d9,0x26399a25,0xc223af43,0x676933c7,0x161fa725,0xa0c52f35,0x0dd96067,
	0x7835f1cd,0xf3d70b95,0xababd2db,0x8ed96e93,0x1b291d7d,0xbc2135b7,0x75452b0d,0xc03d217b,
	0x4e353e0d,0x564df89f,0xe9554589,0x05c9a6d7,0x7d2d3103,0xc6cd6feb,0x3a01fcd9,0x7ce39f67,
	0xdacd1f2b,0x50459cbf,0x08d97d49,0x6da3cbf7,0x59b99197,0x347522cb,0x2fd7e9f3,0x5bbfda57,
	0x457da6a3,0x15512541,0x2a5921b5,0xb79b5261,0x7b8d66f1,0xf5eb43e1,0x1e29a437,0x2f41a2f3,
	0x44453a6d,0xdb85b7ef,0x847796e7,0x9f614efb,0xcbeb7d4b,0x0e819139,0x72dde9fb,0xa4593a67,
	0x3ba93505,0xfb711311,0x84579d77,0xcb2b1731,0x7295e55d,0xb4093159,0x624f261f,0x627ff25b,
	0x5eab8563,0x10292d73,0xed97f281,0xeba7e0ed,0xf5cf9465,0x6ed5534f,0x07670ff7,0x2b9fccfb,
	0xcecd4f01,0x173dd65f,0xfa5def9f,0xdc09629b,0x5a59041b,0x39b7cea3,0x83814b5f,0xfc2d1cef,
	0xbc1189dd,0x90c1559d,0x7b472ae9,0xc201731f,0x4377d2b9,0xa201c35d,0x1e8508b3,0x2b1d2561,
	0x84f7a26b,0x9f450b79,0xf77b16fd,0x2dc3a9e9,0x12e962f9,0xe7853a0d,0x66d1a4cb,0x89dfb9fb,
	0xd68519a9,0x27dd10bd,0xcc99a2f1,0x3a01fee1,0x08f17c13,0x1c93c3b7,0x51494903,0x8465dee9,
	0xcc392511,0xf219d6b1,0x4ec1da61,0xabed6a71,0x6451e9c5,0x460119e7,0x594d8b33,0x412168d5,
	0x10174e9b,0xc80bc721,0xe8998567,0x13378581,0x824d1c47,0x7b1dbea9,0xa0c10db3,0xc1079ce7,
	0xfaa114c3,0x9647e455,0x3b41c89b,0xea13297d,0xfea5c853,0x05bd9c83,0x10051f63,0xff85d0c9,
	0xb2d78a83,0x8bdd6919,0x3e5bc519,0xb5311051,0xd39d8723,0x822fa683,0x75fd5b97,0x12910aa5,
	0x4e3ff751,0x3a6168b7,0x6009387b,0x23c77463,0x79f37671,0xff497831,0xa8094a2d,0x4a9ba127,
	0xf0d7772d,0xb5e56ef7,0xa4ed1cdb,0x2f83b09f,0x08edd877,0x1e59f597,0xa20dff7d,0x5297db79,
	0xed239a8b,0xb4f72025,0xc82b48d1,0x3c99e06f,0x564db3ef,0x3335eb3f,0xa66bbc61,0x4ff39143,
	0xe425066b,0xb0afd90b,0x5b610f7b,0x39b97fbd,0x16537413,0x642bae35,0x5e038e35,0x02a5caaf,
	0xe55f1443,0x04994ef1,0xe6b3e06f,0xc0170af1,0xfbc1889d,0xca0fbbff,0xf839eecf,0xe51d6067,
	0x8ed3720d,0x0ecb2fa3,0x08c5e7c7,0x33659ef9,0xd7d905c7,0x90335aab,0x4aef648d,0x4c4d9b97,
	0x2d01c245,0x4fd7c16b,0x96b5ae21,0xe1d5993d,0xba5f444b,0x146b38bf,0xf2852249,0x87a7d5e9,
	0xdaed3be3,0x8acd8311,0xbc29b893,0x241737a5,0x11938163,0x07050d49,0x71dda759,0x011f1983,
	0xa2194a63,0xe53fcbe1,0x1b4128b9,0x7d5f389d,0xca377ec9,0x8ad537d1,0x525b5f9b,0x5d23c113,
	0x9a872dbf,0x07416ba3,0xec9f5cad,0xbb5f7b0f,0x6f8f22b7,0x552d6061,0x43e14367,0x9aa917c3,
	0x0ab99a6f,0x3b654aa3,0x1f638f09,0x16479e65,0x4b5b17e7,0xcddf1785,0x3ccf7799,0x3321f93b,
	0x87b1596d,0x8eb909ab,0x793376e5,0x50cba289,0x85dd6d93,0x2f3d7643,0x9a09ed87,0x3a7f71a5,
	0x14efe835,0xf0d5a203,0xb62fe7dd,0xd81d87e5,0x45d93775,0xa619be29,0x3ef1030f,0x7f315dad,
	0x447718c1,0x53c50577,0xa8fb720b,0xe3edef63,0xd08f2dc9,0x71c3f93f,0xb5672289,0xaa2d0a7b,
	0x56cbb189,0xcc21be51,0x5ab50209,0x9671ba6d,0xa9c34d45,0x04119a0d,0x4dcd62d1,0x5ee3d5b9,
	0x5aed0d87,0xb0f58f59,0x2b0180ef,0x1c57aaeb,0xb3b37725,0x21531ba3,0x3f07273d,0x5b45cd93,
	0x4e5fbc37,0xbbd713db,0xf001745b,0xccd1034b,0x4f251123,0x005ba185,0xc677bfab,0x97c550b1,
	0x3d232193,0x28d95fa1,0x16599e63,0x49952673,0x7b5ba579,0x6a7997bf,0x47fd0875,0x6757ae3f,
	0x61b91613,0xd68b9ef3,0xc1279da1,0x9ed137cf,0xf61382e1,0xdb8352db,0x6dfd0a71,0x976bc5e5,
	0x452586b3,0x65ffb69d,0xea118d33,0x6337bb49,0x5b935c97,0xa1c7afe5,0x49599afd,0x8ff3a7cd,
	0xdee914eb,0x5ac9e3e9,0x8137a4af,0xd7fd354b,0x469dea51,0xfe1bb465,0x7171fbf1,0x736134a3,
	0xb507b6b5,0x3afb5c9f,0x8d39d831,0x08d1cabf,0x706f884b,0x43cd2e65,0x24297ba7,0x3ea7bd8f,
	0xfc01568d,0xaf23ef0b,0x4b3d7853,0xebe7e10f,0xd0cfd73f,0xf8b3546f,0x65e114fb,0xe939a43d,
	0xb6d7736d,0xa259a1f5,0x4ee3d22f,0x81efbe23,0xbdff5c69,0xf51b658d,0x217d0f45,0x8505fad5,
	0xd70fc0cd,0x622954a9,0xa24dcf5d,0xf61d2869,0x0cbd217f,0x83db4949,0x485d9e5f,0x5e812401,
	0x5ca7c6a9,0xbeab5ef1,0xe61d95f9,0xbe2306c7,0x304f54bd,0x82412fad,0xf26582a3,0x1c9f72ed,
	0x76238179,0x2a6b3115,0x7175289d,0xba3300ab,0x5a77e8df,0x80213145,0x7df7a8ed,0xe0cdcb41,
	0xa0850239,0xda7ff3e1,0x71f70661,0x54fd1dfb,0x9b73351b,0xdfcdef19,0xaff3ca95,0x66ff4129,
	0xc74f0e61,0xe679289f,0x0bc7cae3,0xa3b56723,0x0209952d,0xf61732b3,0xd3bb0d75,0x25a9b94b,
	0x6481bfed,0x68694917,0x7983ce39,0x860d850d,0xbb790951,0x2a518e1d,0xdb35a3e7,0x6dbb88d7,
	0xa09f2555,0x9ce16795,0x2c4fc4ff,0xc6376123,0x3387d63d,0x164dfbe1,0x7ebd6cc7,0x8aa71571,
	0x72ade195,0x02f5cee3,0xebcf604f,0x38e3c54f,0x3473252f,0xa65d7f09,0x5d3b936d,0xe2617549,
	0xc027cc25,0x7c37a249,0xf623edc1,0xdd45fbf9,0x06ffa3dd,0x3953c31f,0x1c0d2fb3,0x15570f03,
	0x7d159101,0x6cb57d93,0x1febf771,0xfd0d700f,0x926f2485,0xc081bc2f,0x8717e5f5,0x1e7f39cd,
	0xcbf750a1,0xdb071509,0xf44de3f9,0x4c6f4cf7,0x7c833ddd,0xdfb946c1,0xb0b98709,0x7349dd4f,
	0x1dcd4001,0x9039d577,0xd4e99673,0x0a1d1e9f,0x497deb23,0x0d4dc7dd,0x11d5b04d,0x23a711b5,
	0x521d489b,0x37e18427,0x19e10e79,0x1f49716d,0x7c212c0d,0xb20fcd11,0xa9d16b9b,0xfa0dbfa7,
	0xd6e5a865,0x8011dee3,0x31d70823,0x3fa5724d,0xb5afa4d9,0x494fac67,0x1e8bcf49,0x9b69404f,
	0xc8a991df,0x39593bf3,0xc1ed9c0d,0x09618ea9,0xd5e93e3d,0x80e32465,0xdc659e35,0xa731fd59,
	0x126bcbff,0x76cd2a21,0xc5c5df51,0x252f146b,0x1b11c577,0x591bfc17,0x3643e7b7,0xd75510ed,
	0x8dab523f,0xadfd10bb,0xaf818387,0x6645d1fd,0x41eb8c3d,0x44c7a309,0x8587a7a9,0x2047e5b7,
	0x226ff49b,0xd6fbcf87,0x87c376cd,0xea51b647,0xa5b708cd,0x493dd141,0x4a116667,0xd0fbd6df,
	0xe735f78d,0x8c5b5ecf,0x0daf83b9,0x398770b7,0x603975dd,0x1e4b274d,0x4a45d8c9,0xb2dfd00f,
	0x4101b40d,0x2b2d6f61,0xd6e3f167,0x66991133,0x69b172ab,0x4e47ce35,0xb3038029,0x29e9ed73,
	0x03553795,0xf3050a83,0x6f85236f,0x2eb7a829,0xb8e1a2ef,0x55ff1783,0x37af4a61,0x54891bb3,
	0x9033e421,0x25f331ff,0x7a3339ef,0x1995e67f,0x630d4ee1,0xc4c71d43,0x322b31cd,0x2bb3b7fb,
	0xf81b102b,0x288b8021,0xd013b17d,0x9965bda1,0xbbf3033f,0x5c7361fb,0xc2d7dd45,0xa2d52ff3,
	0x1a13a6ab,0xa1ddc7b3,0xa0c50335,0x2ad7ff79,0x75db3141,0x315170b7,0xf0954023,0xc7e5a1c5,
	0xc399c71b,0x9b7db3ff,0x926b44b1,0x751ffe71,0xc181ce9f,0xca357d03,0xc8cb3a43,0xe3517c1d,
	0xd0b16577,0xa17b68cd,0xe1a7c809,0x69ef2d73,0x6e2bf597,0x407102e7,0x7f5737fb,0x98111e23,
	0x4bddea39,0xe2692267,0x819bbbd9,0x6577bfe7,0x099984e1,0x5fd766ed,0x8e9bd229,0x03917781,
	0x8e1dd259,0x4f5bd59b,0x3be9cb3b,0x4e6d49bb,0x000fbfb5,0xc6b9961f,0xd77b6e27,0xddc5a863,
	0x5ef74f53,0xbbe3cfaf,0xd0b3bdc9,0xb5ff5f55,0xbc4dedd1,0x05eba607,0xc159ddcb,0x9921a173,
	0x1469e71f,0xfe0f566f,0x169b179d,0xf7df35a3,0xc795fb6d,0xc0b974b1,0x5a15ff73,0x8295c3d7,
	0xb2f91437,0x0e774823,0x1ac3b94f,0x5a43420b,0xe9a91943,0xccfb48a3,0x76115df7,0xe193813d,
	0x0da5e597,0x2829bb97,0x40cf7ffb,0x2dd9da79,0x48cd5c8b,0x530170eb,0xd033d0b1,0x180dfbcf,
	0xe5f19eb9,0xe8b7a013,0x62dde53b,0xedd3d557,0x89c15f03,0xed9de511,0x29d91b7d,0xc277a635,
	0x0bdd5795,0x70335d65,0xf1939f29,0x5fe7298f,0xefc9dee3,0xca21e51d,0x6ae58eb3,0xd7bfe399,
	0x7def9ca7,0x813373d3,0x140f405d,0xb4438e8b,0x7ca35ee5,0xc85f999f,0xc1bba72d,0xc95ba7a7,
	0x89250ee7,0xa0c31c27,0xc7f7d7f3,0xa59b1c35,0x1097c643,0x9aa7b39b,0xc33dae45,0xa33b1687,
	0xe90303d1,0x3679e7ad,0x016b9185,0x991feaf5,0x8a6100b7,0xe5cf0c9d,0x8acb59d7,0x2bd124e3,
	0xe78b255d,0xac67602f,0xcb0d552d,0xbe85b3b9,0xe7479e7b,0x612546b1,0xda496c3b,0x041137e7,
	0x7d3f1207,0x8f1da7f5,0x65ff6783,0x2ffb6fe7,0x63097447,0xf67f6c5d,0x3a17544b,0xc76bc53b,
	0x7121fcc7,0xadad19cb,0x69e309a3,0x1233f96b,0x97e93b59,0xe22b90af,0x1919cd63,0x2bcff30b,
	0x78b14d19,0x39abe8fb,0xe4db1927,0xb463aab1,0x9eab3169,0xd2ff6f2f,0xecaf7f59,0x21b537ff,
	0x57f33ef5,0xe727c14f,0x7b89b029,0xb039fe9f,0x2e8fb8b1,0x0a490be7,0x50bf9e8b,0xf409fb41,
	0x016b82d7,0x0cb5670f,0x890fc541,0x09e730a1,0xbd59f7eb,0x7bdf5361,0x27a58bd3,0x683f347d,
	0xb617ddb9,0xc3655705,0x3f11cb8d,0x5023dc9f,0x9f477a51,0xee0fbaa7,0xba477487,0xde4b0bdb,
	0x2579c913,0x06cb667d,0xc5ad52a3,0xbc1b9f07,0x2721cf9d,0x19addf45,0xd807f285,0x709d7a05,
	0x8d9712df,0xd4f76341,0x5b89a69d,0x5183b4c1,0xc6232c09,0xca0b2743,0xf6c7ac25,0x1427e827,
	0xdaef7d99,0x4e7bb39b,0x75c37019,0xfe8b9b35,0x2c13084f,0xfcfd6129,0x52e7f441,0xb85bcfeb,
	0xc8876039,0xd66bf653,0xe001542d,0xbbe9b051,0x6731c1a9,0x02d16405,0x0f496a35,0x672d5b77,
	0xffdd463b,0x3259a2b5,0xdc619475,0xaccbd27b,0x043f39d1,0x9e5baf5f,0x555199d9,0x650d057b,
	0x38f58f99,0xaa55a88b,0x4389af0b,0x3ee3009f,0x2e817701,0x24ed0b41,0x74e19b87,0x50eb391b,
	0x5a5110cb,0x28f1101d,0xa499fe89,0x4a67fa27,0xcfb743f5,0x9e592837,0x0459b419,0x443ff205,
	0x98f1b2cb,0x5b419a35,0x65335a07,0x3205defd,0xb023cfe3,0xe4f13f47,0x009df4eb,0xf2f55c61,
	0x985b1315,0xd0d56021,0xe179b521,0x02f1cf8b,0x96894e87,0xc587b1ff,0xed0fdbd5,0xcb8174db,
	0x8a8d23a1,0x1bc173a7,0x8c0dbff1,0x94db8cbb,0x6829981b,0x1f6baa67,0xf38ff331,0x16d7a89b,
	0x500bcaed,0xf0957f13,0x0e118711,0xa9f717f5,0x48c5c959,0x0473bb07,0x047f71d9,0x1867754b,
	0x97d783ed,0x4665652d,0x67291399,0x0ef75327,0xbaa1e37b,0xd8ef7eed,0xf6c5db29,0x2e230917,
	0xff73fe1f,0x76c1e141,0x0d730b27,0xbb0da0b7,0xbe7d6c3b,0x73b139a3,0xa7bd9ef9,0xf07fe2a7,
	0x32dfbd7d,0x5dbb2717,0x0d934fd1,0xefe98393,0xf39b0dd5,0x3e09772f,0x1b4fb9a3,0x52697127,
	0x0c9fba7f,0x79e782fd,0x2aada031,0x59bf3f21,0xb7bf36ff,0x53cdac1d,0x9bd95403,0xc157b43f,
	0xb5b7021f,0x0c57f9b9,0xfe613765,0x2f41774d,0x4729baf5,0xa34dd579,0xda3d6371,0x4539dc19,
	0xc5a555d9,0x389be895,0x18cf6d03,0x519fd081,0xdc9d7171,0x0d5918cb,0x0ddf49c7,0xa081e961,
	0x626dcba7,0x24c5a55d,0x209d5527,0x6c8f8fa7,0xd159d6af,0x8545641d,0x14a1755f,0x70214d3f,
	0x608f6e01,0x19691e5b,0xf2eb606b,0x163d3a27,0xbd23ab65,0x30e50df9,0x92e30113,0x4b8d895f,
	0x6311dbe3,0xa1977a59,0xc35bfbe9,0xef6135ef,0x963b94cf,0x88877569,0x1389543f,0xe4b5cfe9,
	0xfb71e8c5,0xaae3b89f,0x3c0f3139,0xc3296967,0xd165bca7,0x7701a1f7,0x27f3c2bb,0x280ba387,
	0xc9b33ca3,0xa55d50f7,0x9da94677,0xa749db77,0x81e17129,0x79a1e3ad,0x88052ce3,0x5c817765,
	0x9c59f3f5,0xa399d3af,0xdf4b5e3d,0x1bf3538b,0x7971c50b,0xc03b7317,0x32219f8d,0x43894f2b,
	0x90653fb7,0x7aa7898d,0xce9717a5,0x2bd7f98f,0x68592f89,0x4d21113d,0x8b27f417,0x39175f05,
	0x31590561,0xe21913db,0x2faf2e47,0x8c29f5e9,0xfd592c5f,0x1525a7a9,0x7e797059,0x539bab9b,
	0x99357eef,0x94030c67,0xdd371a3f,0xbc9b1185,0x05b3dbc3,0x1f99e865,0x9dfd66af,0x8407aa17,
	0x907fdad9,0x6cf7a577,0xe84db027,0x275d55cb,0x8d2ba273,0xa651edfb,0x4211d5ef,0xb5cde025,
	0xae35dc1b,0x8c0549d5,0xb897c119,0x4125aca9,0xfe01c9a5,0x359bdb75,0xa9970977,0xeedf83ed,
	0x77db7a2d,0x72bf3ccd,0x2c33baad,0xa91f8087,0x40f71f15,0xcc497c5d,0x19f33921,0x6fb11c19,
	0x8173810b,0x25393a29,0xb7c746ff,0x49035c4d,0xdd5194ff,0xfbb1e4bf,0xff072943,0xd3311fd5,
	0x8d7d312d,0x4a031633,0x8673eca9,0x74ff8b69,0x18cfe219,0x07a31123,0x0b33cabb,0x2ed596c9,
	0xacffdf8f,0x4a315db3,0x99d7aec5,0x0bc7b9c1,0x17b321a1,0x06718691,0x575bdae1,0x328fb921,
	0x5f7795a9,0x7153f5f5,0xea19aced,0x968d93c1,0xfcbf734d,0x00edf297,0x82df838f,0x48cd8f85,
	0xb2e9b177,0x0d7dbcc1,0x85d9c339,0x69016655,0x09379b5b,0x1267cb3f,0xd3a3fb21,0xb6859321,
	0x63d78573,0x8f3f2863,0xb2392a45,0xc157bee3,0xbcdda281,0x88b5ef0f,0x5607246f,0xbb254d9b,
	0xfd43f895,0xa9abe7a5,0x0add172b,0xe8410b55,0xf5ef75fd,0x04274513,0xfcef2ed3,0xb0a3f923,
	0xf8af2657,0x725581cf,0xa1e35b83,0x50f13a19,0x11338787,0x978d5cd7,0xc1bd3627,0x2b71205d,
	0xde1bfeb5,0x814ff6ad,0x1fef056b,0xb9175a17,0x09e96d57,0xe83d0e61,0xc451e2c7,0x1a7d3e77,
	0x640be627,0x11275e89,0xe423ff79,0x48e73ab7,0x99d5822b,0x4e051a3f,0x6b0f0989,0xe73d5f1b,
	0x8f8155a9,0x1ef58a2b,0x2423b0c9,0xb3110be7,0x59378539,0xf33bc979,0x82d74bcd,0x95a1be6f,
	0xd3ff7ab5,0x8a47a2df,0x0c0d9cf3,0x54cbfe0d,0xded13a3f,0xf4ad8d99,0x5f0db767,0xe41b6921,
	0x3387d743,0x352fca6f,0xde870415,0x55c3e217,0xdfe70975,0x81afa0ab,0xf99366b5,0x6b9ddc5b,
	0x5e9be1cd,0x243fbb23,0x14b182c5,0xc82bc96b,0x50379f93,0xfc15a535,0x12c9208f,0xbf99a5c5,
	0xd43ba54f,0x9e8d67c7,0x7e2bb21f,0xc8b9a5f5,0x82098dd7,0x182d4643,0x5193f84f,0x8e030389,
	0x01eb6143,0x4da59ba3,0x611bc7bd,0x9e9bea1f,0x4619e9f9,0xfccbd761,0x6351edcf,0xbf4b8453,
	0x63ad29a1,0x5d9d9a83,0x9a2135b7,0xdb8528d1,0x0badee31,0x6341f497,0x1be78d6b,0x9663a74b,
	0xa40386e5,0x9d07c0b1,0xbc5f4aa9,0x7ba7b579,0x0085993d,0xb761226f,0x95b58ffb,0xd0bd7c1d,
	0xbbef1607,0x9cf322f5,0x3177d1ad,0x05b543ff,0x30e54e55,0x377f6df3,0x519f7ad9,0xc64b42f1,
	0x12f12881,0xd0f32e9b,0x598db25d,0xaae188cb,0xa78b7531,0x14690cad,0x57073fe1,0x89810c71,
	0x9f0f6451,0xaf1b496d,0xab3f90d3,0x66ddd8c9,0x8dbf1a0f,0x9171fca9,0x53cddd6b,0x074f59c9,
	0x04c763eb,0xcffb71b3,0xd3b16da7,0x1fd9c965,0x4b3d8da7,0x246da46d,0xbc55fe51,0x2727bca1,
	0xb71d564d,0x0ea7de39,0xd68545f5,0xc689d085,0xa64b0533,0x95ad7307,0xeb7f99ed,0xeafb7723,
	0x17939ef1,0xa8af9e49,0x2ddfb357,0x761fe495,0xe3a93a6d,0x20037ffd,0x42af941b,0x8f3f1bfb,
	0x962b75cf,0x5e2739ab,0xea5d8be7,0x944d1c7f,0xe69b0b8d,0x90c12b5d,0x49c55d31,0xaae12e51,
	0xd1658763,0x919f50ab,0xd325823d,0xf1434fad,0x50df1b51,0x67b9bdaf,0xcf25920f,0x4f57c1d1,
	0xb64594a5,0x682b3c11,0x85d7c575,0xe7b5b607,0xa2bb70f1,0xf73b07ff,0x07b19c09,0x28911aa3,
	0xa04f1311,0xe95bad2b,0x9695a129,0x7cd387fb,0x5af11827,0x841d03d3,0xaec950fd,0x9d034d71,
	0x7981cc9f,0x1f414dbd,0xafff1d73,0x80519e6f,0x16c1c12d,0x65ad7339,0x26519343,0xed9bdf67,
	0xda5d7fcb,0x36716017,0xb33b9eeb,0xac6112d1,0xb1ed60bd,0x25c180b7,0x96a9f1b5,0x55cf662d,
	0x29e97f8d,0x9dfb5eff,0xd7e986ad,0xc5b5df07,0x66b7d011,0xa0a95f5b,0x0eb547ad,0x2b8f27ef,
	0xbda55361,0x27739dc1,0xcc2bd253,0xbb7d7d7d,0xede36ce3,0x2535eaad,0xa3d75d07,0xff4dbb55,
	0xf991573f,0x26ebe825,0xd4a5bbf7,0xc76d891d,0x9eb1b96d,0x94b946b7,0x91ef861b,0xbbfba789,
	0x70315ba3,0x92f12277,0xec755a31,0x8db75d51,0x8ee5fc69,0x83098003,0x5b5f43c3,0xc70d0437,
	0x02874585,0x249de981,0xe53f401f,0x3d0db603,0xb2bde111,0x56732b9b,0xe90de35b,0x20711987,
	0x0015ae61,0x777b328b,0x87271d57,0xae9f4f9d,0xfcff171f,0x67cb070b,0xaa551eb9,0x829d0025,
	0x46db8431,0x29a1eb61,0xb0cb5df5,0x86218707,0x7eedf2cd,0x2263985b,0xb51fbc3d,0x82814139,
	0x635fa96d,0xfba19a4b,0x7751ca91,0x51c3f9af,0x88470cd5,0x240fce13,0xe5c92ebb,0xaf91766d,
	0xb09f950f,0xf08bfe17,0x46572847,0xaa3b257b,0xc74fe271,0x5d1d9f41,0xff35358f,0xb3bbe9ed,
	0x781ff293,0x6df1ae09,0x0003d8b3,0x52b708d9,0x68c7755b,0x3061ab6d,0xcac97c95,0x73753661,
	0x11e141f1,0x5be7b9f1,0x1cf579e9,0x58e9c2af,0x37f3ebcd,0x932ddaa1,0x38613c25,0x2dafe6f3,
	0x046777a5,0x44ff4a15,0xcc4f8689,0x35073269,0xbe933081,0x2d53fd69,0x7e65d91b,0x9bdb174f,
	0x24b39ca9,0x76473f41,0x13b3f5a9,0xe9bf97f1,0x64e992b1,0x79256ccb,0x39b184cd,0x11eb139d,
	0xb6456e75,0x1f57d2bd,0xef43dae7,0x244533b1,0x91b96617,0xe375aa55,0x8daddd19,0x9e53f889,
	0x8b21ff03,0x723d3655,0x71a10657,0x5c49e691,0xca43a2ed,0xeb93000f,0x44378c57,0x2a01533b,
	0x23c954cf,0xc38b3453,0xe3efa499,0xf3ffd1ff,0xd24985ed,0x43552081,0xedb1e963,0x986bc15f,
	0xcf3f0ad3,0xaa53cf7f,0xe5cfdec5,0x5819f7e3,0xcc0f3053,0xef0bc6b9,0x01019795,0xe783911b,
	0xcb05f087,0x2029e325,0x8d657a73,0x1fc9daa5,0x585547d5,0x65875641,0xfb8326c7,0x4fb7611f,
	0x631ba9e5,0xa11fc30f,0x874f79bf,0x2cbf1d31,0xb65d96af,0xb0197b1f,0x811fb353,0x63fbc08f,
	0x12074f6b,0x4bc5db85,0x36b3bb41,0xcb2f22f1,0xe3ebab9b,0x8a97c9df,0x7c338613,0x31c3cf19,
	0xa0c70e0d,0x012d5153,0xd52f9a17,0xd1cbafd1,0xbd3f79d3,0x83515f8d,0x3da1b463,0x60ffdce7,
	0x46dfc749,0x84eba1c3,0x92e98dd7,0xc1c38835,0x1d1bf913,0x1b1781b1,0x9ccdc01b,0x54210a9f,
	0xca51b119,0x9d11429d,0xb681ca9d,0xe6cb110d,0xfcc3c591,0xe53d3e53,0x17993795,0x481de971,
	0x9f9ff5f5,0x322f422d,0xbd17e103,0x7715efc1,0x93f7c009,0xa7970c03,0xf26555ad,0x74611b01,
	0x09c954d9,0x6f57e73b,0x7a515e23,0xb353aa3b,0x78f9adb5,0x7a7369c5,0x5815a1bb,0x2ae3f17d,
	0x3a55c13d,0xe21b5113,0x384f6b95,0x06b546e3,0xc08dd851,0xe8a77f25,0x7a098f99,0xf8130f8f,
	0x7141031d,0x9a91177f,0xd7b36f75,0x26efeca7,0x1df3ae13,0x0f81bc2d,0xb0251fa1,0xc2e3085d,
	0x1d1156f1,0x4b45eac7,0xef9fac5d,0x343382ed,0x02ed61b7,0xbed57969,0x98cb7eaf,0xecc5ff95,
	0xfac70db5,0x694d33b7,0xedb7e167,0xd93151a1,0xbfbf8a79,0x98f597e1,0x38dba61b,0x71ad4961,
	0x35e32ce1,0x4c3bb399,0x3619ea2b,0x6b1da12d,0xa329c40f,0x32b3211d,0x1bb9fbbf,0x080b0a69,
	0x886b0e71,0x4e1f2435,0x43695ec5,0x09a95a7b,0x1a6d4eb7,0x3361e72b,0x7345f1f5,0x40d1d7d7,
	0x5add00dd,0xeb8bd7d7,0xc6cb33cf,0xbf05a6f5,0xd14faf27,0x74d32495,0x37e3a799,0xa7715757,
	0xe43de721,0xe3935949,0xc7dd5a63,0x9fe59085,0xd20f4e9b,0x23571c61,0x48738803,0xe1dddf11,
	0x4a0dd8b5,0x57c90bd3,0xc4c56019,0xeb7ba195,0xa56f1acf,0xddbfba1b,0x8a59eb0d,0xd08915af,
	0xc04fc195,0xec3bcb41,0xd2210f0f,0x2b79850d,0x72b325f9,0xd56131cf,0x0977b513,0xae65925d,
	0xa9850239,0xe7818bdb,0xbb170ddb,0x540fa65b,0x1f9b46d7,0xee0da005,0x182df6eb,0x30e37cc5,
	0xb6af0f9d,0x52a7fa6d,0x21477f97,0xe3f1d165,0x7069b89f,0xde15a9c5,0x6f5f8df3,0xa7f52d0d,
	0x07511339,0x19431c41,0x9cd3a3e1,0x0451d297,0x27dfbb0f,0x4e4b1c9d,0x4e6dc405,0x1e0dcbe3,
	0x496f8b09,0x2967ef21,0xdc5d76cf,0xa8df16db,0x2741325d,0xf9ff8e95,0x9b3bef77,0x781ff271,
	0xd987e987,0x93a30955,0xc50750fd,0xafcf4b9b,0x8e514747,0xcf07fe39,0x02291327,0x959b4a5f,
	0xe29b35a9,0xab0b39a7,0x92738785,0x01d3fec1,0xdb4d0703,0x0db3728f,0x161b7e6d,0x70732dd7,
	0x7e31aaef,0x252f2765,0xf6c30c01,0xb21b3eb7,0x0afb034f,0x68d39b25,0x70736d25,0x3d194783,
	0xd447594f,0x3a21f255,0x3a9b0c89,0x1e5d3a67,0xb89bf261,0x25bd7001,0xd111a7a5,0x8a7f328f,
	0x3b63c543,0xc475d2c1,0x5d1993b9,0x0ec5e139,0x3df14ef7,0x3c3fd1b1,0x3e5922cb,0x62191aa5,
	0x588387c7,0x613bb977,0x33e328ab,0xd60b831b,0xd33df849,0x76af293d,0x252b9fef,0x67d75bed,
	0x3f2bee55,0x9007efbb,0x8b176ef9,0x715d7073,0xaf41d20f,0x91db082f,0x78eb4ced,0xfa2b2311,
	0x915b9ae5,0xd2e9b75d,0x455bc6bb,0xa86f9a2d,0x273f6487,0x5d17c891,0xd37b641b,0x52070d3b,
	0x9f9923f1,0xce75eaa3,0x7bcdec8d,0x2d7331b3,0xcefb7c69,0xda372cef,0x953bcc57,0xa2dfc817,
	0x88e3b475,0x69bb9c59,0x9e139989,0xbd1b48ef,0x98b5caed,0x5d89004f,0x050fb8f9,0x3aa1b1cf,
	0x5abfabeb,0xee4fb7c9,0x924d2349,0x3e97724b,0xf53185d1,0xade1b63f,0x705749dd,0xa1c37909,
	0x312b3e4b,0x2841a0bb,0xd51d1be5,0xe39960b1,0xf3af074d,0x24910ac7,0x4af72b5b,0xbb35bcf3,
	0x56ab140f,0x8623d379,0x99a5f1fb,0x4857878b,0x61f16e19,0xcd6ba271,0x4f4f364d,0xe469ad37,
	0x643fea35,0x390984d1,0xe98790a1,0x937fbac1,0xec3b3d73,0x86c3aa47,0x9e43100d,0x1553a9fd,
	0x616d3231,0x54854209,0xc4e5ff71,0x9645cec1,0x3d4bfd13,0x216777d3,0xdf35ca75,0x0061e3ef,
	0xe433b201,0xeea590eb,0x42610289,0xec5b3871,0x1e69d933,0x80a9291f,0x600583e1,0x3289fc39,
	0x3115241f,0x40018fc5,0xaf1fba7f,0x1bf1ad3d,0x9751428b,0xba5f44b7,0x35170729,0x333ba483,
	0x5b15d783,0xc3a7955d,0xaebd446f,0xb5bbc311,0x0e498e59,0x36d959a3,0x594b6ba9,0xa46b3ef7,
	0x63b54fa9,0x5729d0fd,0x5b6159f3,0x74eb9053,0x68119655,0xd0e99f6b,0xce05b537,0x62877e41,
	0x5af7e489,0x5a99ea73,0x65a9f125,0x5f314bef,0x27eb58b9,0xf5e1961d,0xbb257431,0xa4850589,
	0x7f5b629f,0xd08da203,0x34bbdc9d,0xe4c1ed4d,0x8f9b983f,0xc593a641,0x8f0f656f,0x1bd5087b,
	0x5de7aae3,0x7e11707d,0x06356b77,0x004dcc5b,0xbf617c1f,0x324fc0e3,0x1ea5124d,0x1469eb3f,
	0xf21952d1,0x0abb2727,0x0e3d094d,0x57074181,0xd6013017,0x20ebff89,0xc54770a1,0x94b3e27f,
	0xc5f54461,0x209d8fcd,0x9773de39,0x589f45a7,0x10bb845f,0x88b5443f,0x84d982c9,0x7da59367,
	0x11fd5e0f,0x8c470cb7,0x22f96ed3,0x5f49123b,0xeb518db1,0x9383d991,0x25bbf79d,0xaab3b39f,
	0xdd3112d3,0x5ccb38b1,0x88713c37,0xcfb7c123,0x40054547,0xbda51287,0x56d1ca79,0x11cda953,
	0x1d170a29,0x03bd8705,0x15fd63ff,0x3919eccb,0x679b28db,0xf5ebeaab,0xcd7de335,0xe3652b2b,
	0xd5adc009,0x752de37b,0xb03f4045,0x7523501d,0x5953daa7,0xbda9a607,0x659fb62b,0xaa6de051,
	0x397724ef,0x47af525f,0xf25b07a3,0xc8076683,0xcaefc165,0x48b37125,0x419be435,0x6c590071,
	0xc9773dd3,0xd453907b,0x4def6d31,0x00750be7,0x50b3a84f,0x9d57010f,0xea51daad,0xc919f3b3,
	0x752fc431,0x56adb317,0x2b1f408b,0x97a31cb3,0x7d5f5f1f,0xb4693351,0x6f25736f,0x1b1df2c3,
	0xbaa1c603,0x0ccdc7ff,0x088f0dcb,0xd13d15cf,0x02375a0f,0x993dadf1,0x85f794d3,0x975da6c9,
	0xc64d45bf,0x5745757d,0x9b5dbd89,0xdb7bb4a9,0xcef951d9,0x89a17f7d,0xab2bd1b3,0x6d45c96f,
	0x9339da65,0xd9299a59,0xef2f34e1,0xef0b9727,0x31ede3b7,0x15e9befd,0x41a3096b,0xe6c9c4e1,
	0x0ae34f6b,0x980beddf,0x8625f56f,0x6f21dbb5,0xf7cf3163,0x40e72bfb,0xb2bf07d3,0x885d53c7,
	0x254f44cb,0x1bfb9fd7,0x78e1bd47,0x096fc13d,0x8be58117,0x9fedce81,0x8e612545,0x30f1214b,
	0x08fdcf01,0x8f8bf88f,0x96832709,0xd625472b,0x17efdd8d,0x7acd971b,0xaaefe69b,0x39f76919,
	0x2af31707,0xdfcff8cb,0x84b149cb,0x77f7cd63,0xa42fb5ff,0xebd9fecf,0x45479d31,0x9761975b,
	0x6eaffa55,0xdc57f9db,0xdf8b592b,0x3c17b455,0x37697e27,0xffe3a72b,0x20cb06df,0xf7a3e8b7,
	0x4637aae5,0x57374d85,0x59b3453f,0x3a37fce9,0xf6dd4e41,0xd63dfa35,0xa75fedff,0xe3ad0a5b,
	0xd2094f33,0x44ffde13,0xdc4d5aa1,0x7487e889,0x464d8303,0xc0b7ca7b,0x0965c96d,0xdef1b9f1,
	0x0129a239,0xdcc3ce53,0xa6f7e26f,0xf7bb991d,0xe7fd5da9,0x63a7f305,0x5dbd5c7f,0x876165a1,
	0xb117936f,0xb813198b,0x6fd5c23f,0xfb05b113,0x1cada3ed,0xd5ddf75f,0xc1cb5713,0xb56fcc15,
	0xcdd9e6cf,0xf3013385,0x838b1c2d,0x0015f351,0xc39f4009,0xc0a9a38f,0x796ff581,0x9c0f9c77,
	0x71edd4d5,0x4c21a88f,0xe537eed3,0xf31fe343,0x7a97e0b7,0x7fe1ac21,0x0f0da0a5,0xe8af1673,
	0x0657aa7b,0x4485bd6d,0x6e7fb549,0x4ad564d3,0xbdd59933,0x41d54e21,0x73858dd7,0xe345aa33,
	0x629b6939,0x3fbd0f6f,0xef81072b,0x28675c6b,0x081b8133,0x2755ef17,0x1e3b5ef1,0x8e43985f,
	0xecb5670b,0xa3db345b,0x4ee33893,0x77894ef5,0xf2ad54f3,0x63b7bd0b,0x2d11c24d,0xc6979221,
	0xb92dee69,0xf9735a7d,0xa9c5fa1b,0x0e6d01db,0x554b152d,0x5cc94e8b,0x846712c7,0x63b55923,
	0xab03de4f,0x0b95e89d,0x73c9f8dd,0xcdc31b05,0x6637a71d,0xcadf42a1,0xef21f7b5,0x57915f91,
	0x93b74a35,0x07d51e09,0x97117e71,0xc0c1c0e1,0xda357479,0xd8cde0d3,0x3e9f04f5,0xce9b6815,
	0x534d1a15,0x9e43b285,0x943f10f3,0x3d153a55,0x04850b7d,0x43e1b92d,0x6ac55ae1,0x4fc525d7,
	0xf847aa6d,0x21737661,0xa27512fd,0x02f18ecf,0xf6e9bee5,0x7bef443b,0xb1f5464f,0xdc83dc81,
	0xdfa76c31,0xa675f263,0xcf5563a9,0x5d0b2635,0xa1a545e7,0xc3498305,0xb90fe09d,0x10c3003d,
	0xd4ef84e1,0x24db07d5,0x1f03fe8f,0x409168f3,0xf3795c3f,0x4ec19f13,0xab77afa5,0x42fbd5b7,
	0x321f6e71,0x96b99085,0xac1d9bcb,0x6d355ff3,0xf9a76229,0x65ab8a73,0x5b0d45bd,0xa41b1217,
	0xffbd9761,0x18a1feb9,0xc7c74ff7,0x8d2d549f,0xfff3fc5b,0x81d59faf,0x6035e1c3,0x5f957b09,
	0x14c702a5,0x09a3fd3b,0x19a52c2d,0x552770e1,0xb09db413,0x6f9341cd,0x39cf0f0f,0xbb5d86b5,
	0x36c1e7bd,0x2b510f57,0xbfd5de05,0xa4575f21,0x34679707,0x6db57c59,0x6d3f457b,0x37e1fbc7,
	0x39ab529f,0xc1bf30d7,0x6efd4f9d,0xa46fea4d,0x5293d775,0x4d91a35f,0xa6678961,0xb0179167,
	0x200bc3c5,0xb37d7605,0x923d478b,0xe99f9dcb,0x90e56c13,0x92f7f367,0xd7a70b9d,0x796f8f3f,
	0x3ae1d02b,0xa99faba9,0x6b3708e9,0x929b6589,0x539fb01f,0x94393179,0x59e3c987,0x83db6d79,
	0x49adc149,0x2fb5f70f,0x320df355,0x68932ded,0xfd7f034f,0x9a294b23,0x0c7b2cf9,0x79cf74c1,
	0x9a73351b,0xd3d375ff,0x356122e5,0xff3d83e3,0x0fcb69e1,0x0019f66d,0x7553ac4f,0xe0395e41,
	0x29b5be19,0x4689dec5,0xfa551035,0xd4c734d5,0x4a432c8b,0x53d951e3,0xe0cd6a61,0x368ff3a1,
	0xc275833f,0x7ae9202b,0x5c8b305f,0x71e5eead,0xcb2b788b,0x75bf848b,0x81c9d689,0x16c1af0b,
	0x1e33e007,0xc6870179,0xae2594fd,0x89c7dfd5,0x2f43ff97,0xb8995df3,0x91a94ca1,0x55415b2b,
	0x04f50469,0x0175c27b,0xd7c58c27,0x1a215735,0xb1cd97ed,0x01bdf621,0x7051b505,0x2103b329,
	0x6d3994df,0xa641bb7b,0x788f4079,0x8b25643b,0x4c8ddc43,0xe8f94da3,0xc423248d,0x237502af,
	0x9c034a65,0xf203fd41,0x0621590d,0xcf8576cd,0xd7c3cbd7,0xd8a3ed81,0x9a017c93,0xa08dc5e9,
	0x44d59275,0x0449f119,0xeca1997d,0x8471ff59,0x2a316a61,0x2d898745,0x854b0af1,0x96bb497f,
	0xa9b12f07,0xff25f8cb,0xaead81e1,0x119d0ec5,0x39196019,0x570194f9,0xbfe32a03,0xdef14a9b,
	0xbb17d695,0x27290ea5,0x056beed5,0xc93bf67d,0x383f99bd,0xf6d9f929,0x4a2de0a1,0x4ca396e9,
	0x380dd41b,0x036b656b,0x007bb973,0x07fbe86b,0xb9e3e885,0x01659edb,0x0b0b8225,0xcdbfac93,
	0xce11a713,0x7d77086d,0x25ff5755,0x551196f9,0xcec9a229,0xdd77199d,0xefdd4e69,0x8abb5a3f,
	0x3927a375,0x01637b71,0x92997a93,0x822fd511,0x263140e7,0x84614577,0x0c8711c9,0x06875f1d,
	0x63d191bb,0x9dc15ac3,0x196bb1cb,0xcb87361b,0x2ddd0377,0xa1f5e6f3,0xbb69c51d,0x3e970ad1,
	0x87114ee1,0x23a1fb2b,0x64170813,0xf7c9ae05,0x320f8d11,0xb4874b1b,0xbd672dbf,0xcad9dd89,
	0x4a676c61,0x469509f5,0x12bfa505,0x78293137,0x7d8b8573,0x2ce5e779,0x59e37d8b,0xfdc327ed,
	0xe3d9d033,0xbcb12ceb,0xdc056cbf,0x88595499,0x799138d5,0x8e63fa17,0x7ebdf2d9,0x0445ab29,
	0x37e554d3,0x5e85a255,0xad0b9fd7,0x4e89ed97,0xcde537f1,0x8ed12981,0xe0597883,0x05d138e5,
	0xf98f6939,0x4725e0ff,0xc9757b69,0xfb6db21b,0x80c7f7ff,0x368524bf,0x199745e3,0x4459534d,
	0xca59b0e1,0xf4213833,0xeb61d90f,0xea37d88f,0x16f972bd,0x004f4359,0xcbdb7ed5,0x3c4fcd07,
	0x5a43a3c3,0x658d6fb9,0x6375cee3,0xc097b7dd,0xb3bdc663,0xf981255d,0xbf05d3b1,0xc4a76943,
	0x87d32e5b,0x3df967dd,0x38cf4f7d,0x8ec1676f,0x38d7d5ab,0xe1ed5353,0x017b2151,0x2ed17ba5,
	0x800751a1,0xe279b967,0x4915c9f9,0xef675f2f,0x6687e7cf,0x4be3de47,0x0819110f,0x66bf885b,
	0xde63c311,0x9a9d55a5,0x6867c9f1,0x27bb1785,0xfb914889,0xbc39ffbf,0xce45b8c7,0x12e3e40f,
	0xcce98ca3,0xb077265b,0x8167977f,0x476da95f,0xd535e813,0xca3fb9c7,0xf5e13ad1,0xb43153e7,
	0x241bacd3,0x909badd9,0xb537d73b,0x48b16e23,0x0f35fb25,0x3fc576eb,0xe74d6607,0xc617ad93,
	0x8afbb699,0xea19a6e5,0x7b792a41,0x30379fbf,0x23d39afd,0x3921aa33,0xf16d55c3,0xde8b7737,
	0x97097171,0xce85a4cb,0xc24fce2b,0x2d35f899,0x0bd36553,0x45216f29,0x69a311e1,0xcdfd8781,
	0xec4b7953,0xd1f1b353,0x0e5b3d13,0xb959539d,0x5e751c61,0x851929d7,0xcbcf2eb9,0xbf61a59b,
	0x5d3fdebb,0x2aebf6c9,0x9abfcd93,0xb8d74c35,0x717b46e1,0xccdd26c7,0xda556d25,0x5825292b,
	0x0ae9c6a1,0xd28b4bf7,0x791f52c3,0x9a5fde49,0x7929d00d,0xc2bb3b03,0xbe155a81,0xd83f9a61,
	0x84cb0a81,0xa45de825,0xb199bc3f,0x77250647,0xa83fa79f,0xff876417,0x2673f0a5,0x3a1f51e1,
	0xe8e5d853,0x7e77f91f,0x62d1b621,0x32db6117,0x500161d1,0x2e956809,0x694f35eb,0x52b718d9,
	0x03bd5293,0x616b452d,0xe1eb4901,0x9bb3cc21,0x002dd75d,0x2db37567,0xa30ddd2d,0xf179c8f1,
	0x7051303b,0x9049cb1d,0xda8779fd,0x8a5d0553,0xa709c57d,0x2d35c339,0xd68fe5c7,0x0059ec55,
	0xb8255cc3,0xb0a36233,0x6ec5eaab,0x020d4b13,0xb1576deb,0xcfed3109,0x0d353b8f,0xa3c55dad,
	0x733b9825,0xea8d5a3f,0x574b7927,0x5075fc4d,0x2a5736e1,0x4b2de6e1,0x76e356e5,0x5ab3e825,
	0x681516dd,0x08991b87,0x0339e009,0x2dc5386b,0xdbcb4b19,0x86c7f54d,0x89f9dc9d,0x1e93e765,
	0xabb321e3,0x97d7c6d7,0xb831566f,0xdcb17f57,0x6df539cf,0x3d0df553,0x235b3e15,0x8359e797,
	0xc19bb6b3,0x07d9d577,0xb2552fef,0x4a6b517b,0x879996b9,0x1ad1a881,0xa6695923,0xd7734565,
	0xbbcb2747,0xcab3b933,0x44477ca5,0x2ea5cfc1,0xedf79a13,0xdf6598dd,0x1d071827,0x43d7cdfd,
	0x5ac7ba17,0x74f57c55,0xf729a929,0x2b8f5b91,0xa4d1c097,0x7c99b8f5,0x579711f5,0xebf55f03,
	0x2d914a1f,0xddb161a5,0xaa9f1e99,0xeddd36d9,0x0e6b6b7f,0x36c303d1,0x0cf929eb,0x0dbf86a5,
	0xb1abe6d7,0x3e7b846f,0xb4c7e28b,0x4cbf23ff,0x0b858085,0xc4b31cfb,0xfa912fe1,0x21a7238b,
	0x73157439,0x5365787d,0x0245371b,0x69eb05f1,0x1b6109e5,0x6fb9f07f,0x043f8031,0xfaa104e1,
	0x2c554ac1,0x7affea17,0x363d3ae3,0xd18f8015,0x7bc3d655,0x33ab52e3,0x5467a3b5,0xe61d8a4f,
	0xe669d769,0xd65b3e09,0xca4d88fb,0x9a5d9657,0x48eb1911,0xded9a135,0x7be9efc9,0xcc0d43ff,
	0x18d53ba9,0x690d319b,0x2e9bd8ff,0x858b4d21,0x9d9b09d3,0x321360fd,0x922b2645,0x4ee3929d,
	0xc99bed7d,0x39277a9b,0xe9c79f09,0x1ec7495d,0xb31784d7,0x00afe043,0x55091585,0xeb914751,
	0xad3b575d,0x6f39674d,0xb8f3abb3,0xdc457073,0x011faad3,0x507bd595,0x48e9385f,0x198b43c7,
	0x46bb7843,0x76557e81,0xafc1cc17,0x3eb58851,0x5df58103,0x79cbfffd,0xd8ad5631,0x6abf1a27,
	0x079983ad,0x1c0f1f7d,0x585369cd,0xf14bd75f,0x1e5d9121,0x4773c701,0x75b722d3,0xaba3ad1b,
	0x6fdb818f,0xb077220d,0xd34b2af1,0xe9b9c485,0x35978969,0x16c1daad,0xb7e7de9f,0x0329cfcf,
	0x2dffee67,0x261f7679,0xf7cb921d,0x8831772f,0x5565dc91,0xf789d38d,0x7d9ff671,0x12bfe5eb,
	0x3f075b2f,0x321bc58d,0x73759e6b,0xb7637749,0x0e0b61d5,0xcc1dd2a9,0x0bc3a3a1,0x165b8399,
	0x0e790d5f,0x6bfd1093,0xea6b6b73,0x0c834d39,0xee49f4f1,0x694f2189,0x2db58c09,0x046b0d85,
	0x96559ef3,0x6dd55153,0x1751d151,0xe74321eb,0xa361161b,0xb673d23b,0x55556205,0xade558d9,
	0x7f1b9e63,0xf4351a19,0xeb45049f,0x91d55ec9,0x19178a11,0xcd575f49,0xbb07846b,0xde394b3b,
	0x3fcf2eab,0xfe3135af,0xaded3677,0x60e94dbb,0x99abfa09,0x1a4f4bb9,0x7dab9e99,0x7b5b7ad9,
	0x3df3a745,0xed5b475d,0x1d673471,0xd3b3b92f,0xeddf93bf,0x7c2bc317,0xc2a54867,0xa5b9ce5d,
	0xed893427,0xa5c16aef,0x8e5908ab,0xb3e38c0d,0x7cf5a96f,0x6441396f,0xd5d7a631,0xd8491cef,
	0xf11175d1,0xadfbd4ad,0x0be399bb,0x35af71bd,0x6cb151cf,0xf6610b47,0x49a108cf,0x087bce39,
	0x39912139,0x4f157163,0x77a54abb,0x17c5762b,0xc155081d,0x28dd1dad,0x16e78d9b,0xc6417a67,
	0x26879fd9,0xb4a7865b,0xa9c59b49,0xc357a5c3,0x7d9f4c0f,0xe4877e29,0xbd09be6f,0x5c0f8a21,
	0xa5f7afad,0x0cbd515f,0x90e3c77b,0x6c1bad6b,0xc2d541e3,0x24b102c5,0x61eb31a5,0xeed3d691,
	0x5463032d,0xa7eda8b7,0x522167ed,0x303f7a8f,0xf0b7524f,0x172bea0d,0xf1ef2a19,0x9e034963,
	0x9ccde155,0x19499b2d,0x692111b9,0x3875db19,0xc589ca91,0x3c4b7b07,0x3ff53723,0xa38f7cbf,
	0xd8b7c59f,0x5661100f,0xc807f679,0xd7f31d71,0x7e0b7c5f,0x86dfa541,0x255fd49f,0x73eb5b51,
	0x70210001,0xd7476723,0xf7718445,0xac67b085,0xf57f5df7,0x7c3da0c1,0xa2130ae3,0xde05c041,
	0xf98f54fb,0xb68f18b3,0x368305b9,0xbe05c3bd,0xc5a92a11,0x54338e15,0xfc6d0ecd,0x2b531739,
	0x5a059d83,0xd149558b,0x9ae141ef,0x9f7fe701,0x66c7ffe5,0x19171645,0xe155e1b5,0x3fc3fc65,
	0xe4ff6713,0xe709a6f5,0x30a91c81,0x8e05aabd,0x4fa10331,0xc7b70adb,0x8429f177,0xb9cbdc6d,
	0x7c8593a7,0xb9df8ebb,0x1a813587,0x914b3fdd,0x1573fc2d,0x6f6905e1,0xbecbb869,0x125d947d,
	0xb117f9b9,0x2e5f2725,0xb189899d,0x9b8317c7,0x8c03f791,0x51fb09e3,0x319f5d69,0xbce7123d,
	0xe1b50441,0x6b99c2ff,0xa56111dd,0xa95d8467,0xe591e69b,0x03c121e7,0x638753d1,0x475ff3d7,
	0x5be352bb,0xfb218d91,0x1c2f63e1,0xe20d5827,0xd2e13f03,0x8b8d017b,0xe1e3fb77,0x7a3527f7,
	0x7ba3591f,0xe9072aa9,0xd29351c1,0xb74585ef,0xa3339b01,0x82b1a4a7,0x609740b9,0x785b8dc5,
	0xcb77ffe7,0xe3dd568b,0x3baf8a1b,0x0535c12d,0x64495953,0x3501eff5,0xda053c6f,0xdf4394eb,
	0x2461440f,0x5cb78607,0xa1253805,0x32931dc9,0x02653d31,0xc0cb506f,0xaf0dd3f3,0xe6dfdd95,
	0xcde3d711,0xa7278663,0x4317a319,0x508db02b,0x684b0e53,0x36e35b9f,0xc7115921,0x81a3d86b,
	0x9dfdbee5,0x193b1d69,0x7829cf75,0x3ad52d41,0x9f3b38f7,0xba9b6f8f,0xaff52a4f,0x7c7f6699,
	0x1933f607,0x2b8ba967,0xcd791daf,0xb7a18a71,0xeef96dd5,0xa1c352cb,0xbe1b525b,0x9ee579c7,
	0x92870b6f,0x9925c123,0x26abeae3,0x979f9da7,0xfdc54227,0x94b1d45b,0x2c63289f,0xcac7b421,
	0x4b7bc297,0x7f9bd3e7,0xdde330ab,0xd601bd4d,0xf061cfa7,0xae356bc7,0x3c31f0f1,0x1c99084f,
	0x9411b37d,0x7effc97f,0xe3bf2521,0xb87d604d,0x8a0f548d,0x9ba1d91d,0x55677baf,0x0b49597b,
	0xeac9ea95,0xd9e7a235,0xdf65dadd,0xef41be11,0x4c93d397,0xbcc7c4e5,0x2665c5b1,0x884d1b4f,
	0x1ca988df,0x955f16d3,0x4e75e0fb,0xb5016e81,0x982db3fd,0x43f7602b,0xc40d9853,0x1f95f1f7,
	0x652f63cf,0x98fd38a1,0xa511e315,0xeeed0a0b,0xcba16179,0x56070475,0xc9c3296b,0x1793521d,
	0x8e5fa565,0xced3116b,0x6dd94945,0x4cbbc997,0x642dec45,0x2a47d3cf,0x7969bb57,0x913b20e9,
	0x10bb6c15,0x43714379,0x69f3d823,0x6899268d,0x1d99a91b,0x2a8758c5,0xdb613cf1,0xa7fd5405,
	0x33436adf,0x45e9a997,0xb0ff50cd,0xe7397ad9,0x1221d135,0x131d265f,0xde8be98f,0x91cb919b,
	0x2b7d8937,0x87cff70f,0xd11f10d7,0x97d1a0e5,0xda8b224d,0x12d77827,0x7849e90f,0xbf17d057,
	0x3d67831d,0x3d3357a9,0xeef7b261,0x940f939b,0xae177e9d,0xeb09d227,0xc47fefc9,0xfad3f763,
	0xdb858907,0x3ca90fb1,0xe5a5ac03,0x60250e65,0x82878cdf,0x0f87a0e9,0x258fde97,0x8a717e67,
	0xc6d9dfef,0x1f411bf1,0x66cdf0d5,0x0ac92d2d,0x2c1f584d,0xc69fd977,0x645962d3,0x4de50d8d,
	0x2ee58151,0x608fd1b1,0x1a939073,0x4d290c5d,0x7d9ff0a1,0x4925995d,0xd0419659,0xdf9f1d7f,
	0xd1abbb25,0x7ea37ebd,0xbf9556f7,0xaaf968df,0x684b0a15,0xe26dc6a1,0x5f279f81,0xb4919769,
	0x1babcfe7,0x1a0f095f,0x4af96cf9,0x926b401b,0x1be19d63,0x1045afd1,0xcd6f5127,0x3c2d74f5,
	0x47e99691,0x15e7905f,0x085df797,0x7c2f6ffd,0x26a787c5,0xa301abf5,0xbdfbcaa1,0x00676049,
	0x7fe71a99,0xb7bd0b09,0xb9e7b867,0x0b7956f1,0x955f2af5,0xdd73ba97,0xda2b17cd,0xc5af5413,
	0xfba73bff,0xc7a1e925,0xb837ad85,0x2dfb73dd,0x13470d2d,0x94ed23c1,0xf1e3d103,0xaaf73b7d,
	0x21ab4f39,0xb025b2ff,0x126fb189,0x3be5062d,0x0a257927,0x514117ff,0x1b83bb1d,0x49b1922f,
	0xa6f5bd41,0x9e5da961,0xae311b91,0x17ebadcb,0xc23b1e1d,0x6cc15057,0xd3ef6777,0xd5cf0453,
	0xaf05a393,0xa1d96595,0x679f5f33,0x4f3f0b21,0x8249afc9,0x343fae57,0x1e87d3e9,0x3dc50e95,
	0xebdf7429,0xccad7963,0x315bac8b,0x39915f17,0xaf918665,0x070ddc05,0xa52f0acd,0x4a819e1d,
	0xbe05957b,0x53690f15,0x34879031,0x19172b1b,0xedd53eab,0x76fbebef,0xd849c2ff,0xbf79b095,
	0x54790283,0xad218979,0xf0c59343,0x3a7dd115,0x3f5959d7,0x685ff91d,0x0eb5ffd5,0x7a9df429,
	0xccbdeabd,0xb36523d5,0x5c39db57,0x14fb336d,0x24dddd9f,0x3209c719,0xa5d7b12d,0x94616781,
	0x52d35223,0xc24991f3,0x0381ca89,0x6a3f550f,0xbda3f43f,0xbd4961ef,0x218f5361,0x7fb3f9c9,
	0x413bb12d,0xd85da021,0x29c39f73,0x667df967,0xe76f8c71,0xa5f5be25,0x4c418f47,0x2a092aa9,
	0x40f994d7,0xb6b3d323,0xe89d152d,0xc067445b,0x5e81f96f,0x5a5d58c9,0x56cfda3d,0x1b53aa4b,
	0x698f3e99,0x00df0849,0x50350355,0xd92f5a57,0xdd9b92f5,0x3b51d761,0xf899161b,0x9603f95b,
	0x60ff446d,0x5cf11559,0x8729fe01,0xdc850043,0x3e015539,0xbc27a7fb,0x8f81313b,0xb70b0901,
	0x7bcb30d1,0x937d689f,0xea9ff5cb,0xe09b3b8d,0x977380f7,0x82ada11f,0x3fedc679,0x95dfdae9,
	0xdcf322b9,0xaf93a8e3,0x2e37d7d1,0x0627f21d,0x60333b69,0x8737a1d9,0x14b9bd2d,0x646f213b,
	0x95fd6da3,0x1ec75571,0x7c132da9,0x98578a5b,0x8d052e4b,0x349931af,0x1f4de931,0x8f2ddea1,
	0xc6e73989,0xd1296613,0x94d5bd6f,0x2cdf8b35,0xb12927d3,0x882120ad,0x9787aadf,0xdd0b0647,
	0xbe3522e3,0x594deb13,0xef9f29bd,0xc3f13c11,0x1e61babd,0x31a3275f,0xfbc98f13,0x8f7b1bd5,
	0x18e9daad,0x0c43ad39,0xda1591ad,0xe83d44db,0x04f1de45,0xb37186cd,0x30f7ef25,0x8271d377,
	0xe283c65f,0x219dcdcf,0x985530d7,0xcef74dfd,0x93998e21,0x825da87f,0xa27390ef,0x4c5db1d3,
	0xb5099ff5,0xd36f66a3,0x8503ff57,0x77d1a061,0x179b6a8f,0x25bbbe83,0x621d46cb,0x5e31ac19,
	0xd8f915e7,0x7e4b29f9,0x314351c7,0xccfbc571,0x1cb95845,0x57596361,0x48598f95,0x235fc7ed,
	0x65576b31,0xc14102a1,0x84b37941,0xc32b2717,0x8d37207f,0x238b3a25,0x140936a5,0x21d9bb7f,
	0x5fa5174b,0x9de3b3e1,0xdd79635f,0x798dafbd,0xd1d710f9,0x09238e55,0x8a8df3d5,0x1a138d73,
	0xdbe56631,0x98457985,0x30333a39,0x59d96a4b,0xf1d79be9,0x1971f3ff,0x97c70b7f,0x26fd34f7,
	0x1c99185d,0xd6f7a7d7,0x2807046b,0x383d222f,0xb2fdf80d,0x184be7a9,0x6e1bee7f,0xde0939b3,
	0xb2c102c5,0x430d4b9f,0x4695450f,0x736d034f,0xb989c09b,0x9c016e61,0xa66bda2d,0x6f2953d3,
	0x9de3aee9,0xa817ca29,0x03ff9bbd,0x149b3a17,0xa83f9551,0x2d65b5af,0x60177865,0xc4cf0bff,
	0x6bfdfabf,0xd429813d,0xeee76491,0xef779371,0x405fba65,0x67c9b39d,0x61037f7d,0xa3ef5b61,
	0x5993b8c1,0xb7d36727,0xcc6f5825,0xc2351cc7,0x81abb895,0x18fdc6b7,0x35915253,0xcbf94ba5,
	0x71a74feb,0x8627aab1,0xb8392b93,0x5587c403,0xca67fd17,0x61575603,0x50a1a03f,0x16df96f3,
	0xadb95bb5,0xd4b95323,0x44673075,0x9c9ff78f,0xf75379a9,0xd3a5710f,0x2b97051b,0x991347f7,
	0x15cf4c1b,0xbb9be049,0x999df4e3,0xd52d4655,0x83b14481,0x953d6fe1,0x6653a943,0xc18759d9,
	0xe0670597,0xf55bea6d,0x96f9e379,0xa765ffbd,0xa943385d,0x7ded9307,0xe739e18f,0x79af5843,
	0x92858121,0xff11c257,0xf21fe351,0x45f7d3b5,0x804d9475,0x380ba389,0xfb29cf59,0x457bff61,
	0x1fab6c33,0x384b1153,0x5733f805,0x8e1972a3,0x1f919c81,0x606592f1,0x7587007b,0x635ddbdb,
	0x09dbc8c9,0x031b7929,0x88d5e1ad,0x27792d73,0xbc4d38bf,0xa6511b49,0xd0330f51,0xec47eadd,
	0x81958d5d,0xe4153427,0x8025bce5,0xa449958f,0xca4795e7,0xeb9d5f1d,0x4b9142b3,0xf3ab3a0f,
	0x85df44e7,0xa249b511,0x8cc9a2c7,0xa13f1ce1,0x1bbfc531,0x649d8973,0x0e832dfb,0xa77d879b,
	0x0437aee1,0x67494737,0x74e148ed,0xe589b5d3,0x01795c5b,0xb8236dd9,0x46695105,0x702de22d,
	0xf8a15f47,0xdf29ae5f,0x950fa171,0x82db734f,0x6ab3159d,0x1f812857,0x4727b827,0x10ad48ed,
	0x8d9f5e93,0x587bc6d5,0x00757aeb,0xf56528bf,0x05356faf,0x868bbd77,0xab1f9c3f,0xc66f4b85,
	0x3c31c9bd,0xe44f2561,0xa0b52077,0x43db0a0b,0x5d3b4dcf,0xab8fba43,0x733102a7,0x6967aa21,
	0xebdd7241,0x7637b74f,0x55f1f9af,0x1f6f4ba1,0xfd8b97b5,0x3f61d445,0x26bf5d35,0x8c03f56b,
	0x12a17e17,0x04476269,0x16cb2aab,0x03d3c267,0x8f65d99b,0x05538987,0xf3ad2a47,0x9b392e89,
	0xd50307b9,0xa70fa4f7,0x10673407,0x573783cb,0xfa8de439,0xf335c095,0xce5d94b5,0xfe796729,
	0x2601be25,0xb9a335c5,0xc66392dd,0x8a4f85b3,0x85416ccd,0x515d6875,0x91af13d9,0x37b56175,
	0xe71d84cf,0xf993a41d,0x32e360c7,0x384d3e8b,0xf449ad0f,0xda9b18b5,0x1f070b8f,0x03613015,
	0x085d13b7,0xa6f3f7c7,0xe68bf3df,0x46e3453d,0xaae10339,0xdc41b15d,0x7e476c2f,0x786dd633,
	0xa8419751,0xa453510f,0x287b7ebd,0x0641f131,0xcacf9205,0x5621faf7,0xfdcf5293,0x2849e77b,
	0x33c9509b,0x96c788bd,0x1653b07d,0x511bfa55,0x5453e0ab,0x1a8b468d,0x5281a815,0x3eeb2815,
	0x8679350f,0x05dfd01d,0xc43954b9,0xaca11911,0x46317ae9,0xee550dab,0xb7c3c291,0xa2c52cab,
	0x0a538ea5,0x7bad50f9,0x5ccdf38b,0x6887a64d,0xbda790f7,0xa8cf9257,0x0f71045f,0x14c5fa69,
	0xd7d99bd9,0xa4c5cd9b,0x4131718b,0xbeff3b77,0x167b978f,0x53c97f1f,0x01f37c59,0x5061a6f7,
	0xd60d2fa3,0x703940cb,0x2907afd7,0xf4bb5275,0x0aefe7eb,0x4b99870b,0x1e2785db,0x2b89f881,
	0xda6f517f,0x2f977dd3,0x42712c05,0x78ebe5b3,0xd3c35fc5,0x5f0d05a5,0xf96f68bb,0xb6af05af,
	0xc903dd67,0xb6f7d081,0x5211a02f,0x0543101b,0x48390157,0xef799ef7,0x4faff957,0x5cc5d5ab,
	0xb44d23d1,0x7ce59d1b,0xd309a2f3,0xbdf5ad17,0xfe13935b,0x10b1df8b,0x23493889,0x033f0021,
	0xfd4b89bd,0xba79006b,0x16fd4767,0x51b3f891,0x6995410b,0xa903dc6b,0xdd1df3a7,0x2a0b4d39,
	0x737f28a1,0x8b3f6fbf,0x660bbd27,0x19ad2ef3,0xfd7f3a21,0x9143d323,0x6c8f648f,0x0b9f559d,
	0x74ef6e77,0x0d4d58dd,0x1ed9f04d,0x39972d25,0x4b1352d7,0xb4c5c9b9,0x677fd199,0xbceb2279,
	0x0e19bdbb,0x8135c20f,0xd6852971,0xbfa11095,0x2215a3e7,0x31572ebb,0x2a512d9f,0x4d63cd77,
	0x1a030d65,0x6a07ea21,0x78b5adb1,0xc481d729,0xb0c52a8b,0x774d7931,0xf7e7b7fd,0xe6f520bd,
	0x622b88f1,0xad55e85d,0x67895ea3,0x8b65ff4d,0xa3e7687d,0x6979c8a5,0x19a19c8b,0xee1736fb,
	0xbe953059,0xb3334c8d,0x9ba15a63,0xa1ff27ed,0x46b903f7,0x7d2d8521,0xff6393a3,0x21b91b55,
	0x35c37815,0x8633bef9,0xc4239b89,0x0085b06f,0xa30167b3,0xda3bff31,0x5f8d821f,0xbb4d6979,
	0x1cb5e91f,0xf365a06d,0x66af9933,0x29a558bf,0xa10162eb,0x7af50fdb,0x5703195b,0x8ec5ed8f,
	0x36f1c0f3,0xaa5baa31,0xff67e6f7,0x4a93e145,0x2777c959,0x4c2db8ad,0x8925772f,0x2a954443,
	0xd675918b,0x5d298e11,0x20edd4f1,0x5affaaef,0x3bab1339,0x4d35c3ad,0x3fd7c5f5,0xf7ad7abd,
	0xfbc5e15f,0xe05f9657,0x94650fb9,0x3d1d5725,0x2159fd41,0xafdd6369,0x8b7bdc87,0x597daea7,
	0x75e3cb69,0x4b0f45cb,0x796d406d,0xdd9f67cf,0x7ac728ad,0xf87bd2e9,0x62f1de41,0xcdfdae2d,
	0x024f9f25,0x16cdf7b9,0x6629aca3,0x53b7df5b,0x68b5bb37,0x1ddff5b7,0xc39ddafb,0x0d9997f7,
	0x6d0f808d,0x3fab7feb,0x873dd677,0x0115e0af,0xaa65ff19,0xa959f7df,0xd15f6f0f,0x2b457b31,
	0xb0a10819,0x6439caa9,0xbfc71c83,0xb1ed4f37,0xbd9b030d,0xd6bfede7,0xf69b6359,0xb475f783,
	0x160be2c3,0xe5897cbf,0xc96d59df,0xbcf16edd,0xfe973a4f,0xb46174dd,0x04334d2f,0xd119dd19,
	0x54cb7209,0x072f9375,0x544d8629,0x2351840b,0xc81b1c95,0x430f5247,0x51872e6f,0x63a3cc99,
	0xb2e56bdf,0x0f3d0499,0x270d5577,0xb0c173ab,0x936bc61b,0x961f1433,0xdc791573,0x2907d731,
	0x24d97ac3,0x66435e6f,0x3ecdd863,0x1b736327,0x1847979b,0xf35fb129,0x696fbd11,0xd8b31e8b,
	0x6dadddaf,0xb75367c7,0xef2f1c0b,0x24195869,0x6cf1d651,0xf3232833,0xa3452ca7,0x449d74cf,
	0x3edf081b,0x1001bfe7,0x0255ca05,0xb5e3d9d9,0x262d4bf3,0xa03f20dd,0x3b63580d,0x7935fca7,
	0x58734203,0x005d7e9b,0xd8e1c86d,0x06858e65,0x773be6bd,0x98018b2d,0x09a7bf9f,0xdd6dc93f,
	0xa8eb47df,0xbaf9d42b,0x89f5d9dd,0xb631dd73,0x51dd596b,0x2a3d3fb1,0x2c731033,0x52b97e3f,
	0x6d49eaab,0x34e9a963,0x03333d6f,0xef978eef,0x8655bb33,0x79459f6f,0x28adc327,0x5507efd3,
	0x510fafdf,0x45bf3f8d,0x28bd4ebb,0x87eb6b43,0xe36727d1,0x99eb33f5,0x09b1be53,0x1acdc2a3,
	0x8e3d7177,0xc78bd071,0xf53725df,0x1edfdb59,0x56555f81,0xb3834f4b,0x8165f413,0xb4fb0bd9,
	0x0d59fdeb,0xb6df2e5b,0x99bf376f,0x3ea3889b,0x0add66f9,0x1fdbabfb,0x082b033d,0x2f03f121,
	0x8561b837,0x52cf6413,0x9dfbf48b,0x7bebfcf3,0x8b452777,0x8b470d11,0xfce5d72f,0xaed748a3,
	0x9bd937d3,0x3ced54e7,0x00096acb,0x95e942c9,0xe04f0eb1,0x1499de13,0xc4f347c3,0x94eb3909,
	0x04c3e8bb,0x99475c9d,0x548fe447,0x964f850b,0xb139aee5,0x6d21d30f,0xec37b94f,0x9c2fd97f,
	0xa29fab67,0x2e75ef7f,0xe6ad879b,0xf14daf1f,0x63c95ec9,0xf8b5888b,0x4517bcb1,0xfa15d1ad,
	0xa67374d3,0x85833a59,0xd805f7e1,0xa5970cf3,0x3c3fd99b,0xeda52395,0x086faf41,0x7e8ff9bf,
	0xafbdee79,0x0a09c275,0x40b9f4b1,0x5c5feaed,0x7d5fdf11,0x74c3f1b5,0xf5a75ad9,0xb40ffa5d,
	0xec81164f,0x2a13059b,0x4f6bfa27,0x895535f9,0x8869d369,0xc96108f5,0x729b95d5,0xff89ecb3,
	0x3941ded5,0x76371a17,0x693de0dd,0x8aad1b81,0xfd1f5f59,0x594fe7e1,0xabb3e30b,0xc06dfa67,
	0x40ffcf01,0xc1874eb3,0x49d17ded,0xc919a96f,0xd9c5101f,0xe4e3157f,0xb3cd11db,0x70adfda9,
	0x9d3da24d,0x4193cab9,0x234942f1,0xd7c96e2d,0x9b1bf771,0x9eebc15b,0xa44dde19,0xc4bb211d,
	0xf5fbe8b5,0xae6d2def,0xbe47de01,0x947318a3,0x5c634b8d,0x4cbd6381,0xbd139021,0xcb897ff1,
	0x21bda6b3,0x62a930a5,0x99efd9b9,0x4745183f,0xf75f0729,0x66275c79,0x84839ccf,0x0e8bc5cf,
	0x4585f53f,0x7b5743a1,0x0bdf3d33,0xc2f13ce7,0x24538983,0x357f954d,0xe77d457d,0xb1b1cedd,
	0xf4d5a1d3,0xf80b302f,0x603d2c09,0x84ab5709,0x99ff3653,0xf7931f87,0x59653801,0x936d47c9,
	0x51afce6b,0xdad5b819,0xf9a78653,0xd425d78b,0x2da715d1,0xfbb9d531,0xf41d2eb9,0x6cb14dbd,
	0x2c959181,0x484935a7,0x714388ad,0xe3916fd9,0xf30b74bb,0xc3bff8d7,0x9805907d,0xf0f10e61,
	0x2487960d,0xa7773ba5,0xb6b16c31,0xefa1b1dd,0x5c6d8449,0x23f9d57f,0x0bff10a7,0xee1b67df,
	0xc709bb89,0xc1f3355b,0x30130679,0x5f85b001,0x5a91fa33,0x63395eb7,0x1d714f11,0x6ca588e3,
	0xb01db5f1,0xe3cd0695,0xda09699f,0xe4f19d2f,0x7cb5b0b7,0x5ad1d087,0xc0377817,0xcf7f9095,
	0xaa45adbf,0xfb97ab9d,0x67b9843b,0x9c156cd1,0x10a1468d,0x96954f79,0x2eb9e491,0xf41b2ea1,
	0xce83dfeb,0xba65d93d,0x62c5c169,0x2ba572cf,0x4291beed,0x74d38897,0x09d5b9d9,0x526d432f,
	0xa4573df1,0xb3c99cbd,0x4b4ba8c3,0xe4d30397,0x3d4b2195,0x465f516b,0x78ed89cb,0x1ce37ee9,
	0x41c70dc9,0x7dd3fbe7,0xb7ef7e61,0xe351140f,0x4a0f1abd,0x6e8b47ff,0x49e7f2bf,0x607302fb,
	0x6b5189ed,0xd1159509,0x75d3e2df,0x2d4fd9a3,0xf0a19b1f,0x832772df,0x111f3f8f,0x248d010d,
	0xb3f98159,0xa8a33ee9,0xa89b7359,0xd3816a3d,0x173f77f3,0x6c89e111,0x497d0795,0x8b255b49,
	0x9d41f787,0x620da8d1,0xea656963,0x11195c47,0x22b10af7,0x85814a23,0x745dcead,0xf0a9445b,
	0xb72bc46f,0xdd65fa8d,0x6bd73b1d,0x6bc766ab,0x1633d263,0xbb61ae1d,0x39a7a52d,0x0c0fdf6b,
	0xc037348d,0x9d417467,0x140f3b1d,0xd3bf00d3,0xb38b10f1,0xadfbf589,0x87b9c7f5,0x0ec7e025,
	0xc569a8d9,0xe6ad0f29,0xa0b3387f,0xc3b302a9,0x9af96ddb,0xcf9f9171,0xb3774059,0xc4c32ab1,
	0x424536cf,0xe13f1c1b,0xc5e31edd,0x60d54495,0x6b3f94db,0x85231b61,0x98418437,0xb47573b9,
	0x40c94867,0xb709e509,0x4e419651,0x9ad53f85,0xe1a1d62b,0x45d7f55f,0xb7fb15e5,0x3ecfe069,
	0x79773c1d,0xb49b4c3b,0x3aefa373,0x4be7acdf,0xf9dfc683,0xbb8be9f9,0x5b052443,0xbf45a669,
	0x735504e9,0x69076c7d,0xe38f4761,0x58bd2691,0x0e3ddf21,0xe295cc37,0xb0432aa5,0xabc7abe5,
	0xa3e3ca47,0xc5e13919,0x16431fb1,0xd087c701,0xf77b1dbd,0x29c317a3,0xed1590e9,0xb4c72785,
	0x8f21882f,0x3f391dd7,0x37ad067d,0x0cf9c91b,0x2cdba491,0x92699047,0x6d5f4b67,0xe5374073,
	0xe793af1d,0xeba39f03,0x62efb263,0xd2452849,0xe41f5a57,0xd05be2ad,0xd3837af9,0xc28bae5b,
	0xae3bc40b,0xa42ff967,0x89ab5679,0x6f1b4075,0x318b8a49,0x69e743df,0x28610cfb,0x6cb35965,
	0x529b006f,0x2471c24b,0x9405425b,0xdcb16e07,0x27df8421,0xd7e11169,0xfb5d5b43,0xbe21fa3d,
	0xd2b3f249,0x2a79877b,0x809b8223,0xdeb3aded,0xf85d3c19,0xa59d7151,0x8259cc2f,0x6bc7ba0b,
	0xdb091c0f,0x96d96f41,0x84937e69,0x23593d8d,0x12c9eaeb,0x90e9f225,0xb9b57299,0x2517d279,
	0xe69b94bb,0x8ca5d865,0x2b8d9c4b,0x63513ad5,0x4563add1,0xaa192aed,0x8453add7,0xb4032db3,
	0x5eeda7c9,0x916ffa33,0x77a9dd5f,0x81cf442b,0xdced2685,0x73ff5b33,0xcb97c9c7,0x1cff0661,
	0xbc017533,0xad478473,0x018d7fc1,0xac85187b,0xc4ab1b41,0x03ed0b01,0x9f639ec1,0xbefb87ad,
	0xa459916f,0x8abf3f71,0x18599e09,0x7ba3372f,0xa65d16bf,0x21b5aae1,0x561731a1,0x73696d43,
	0x0cf5a57d,0x96ebabf7,0xe1afcf55,0x11df8031,0x0a47083b,0x67a933df,0xac9753bd,0xae3da34b,
	0x595b0ed3,0x215ba34f,0x79b1c73b,0x3c65d3eb,0x7727e36b,0x629bc783,0xe64542f3,0x9de5e671,
	0x7b897f6b,0x7c23f741,0x1301f5d7,0x92edb347,0x9243408b,0xb1dd4fd5,0xed01499b,0x4b5763dd,
	0x14039dc1,0x1bd31217,0x16c127c1,0x97a5dfaf,0x3f5dfc55,0x273f1f63,0x712d5e91,0xba03593b,
	0x91cba4cf,0xb77f969f,0x44952617,0xd741fb0b,0xc0b3d803,0xe7179135,0x09adc52d,0x07dbb4b1,
	0x5263040d,0x68b7001f,0xd29b566f,0x08f327c7,0xd70b194f,0x8835a8d5,0x53e3ad47,0x8d51b4ef,
	0xc1cbff77,0xcb8f4261,0x8d775ae5,0x2e6ba8cf,0xe1a72a75,0x33e9b24f,0x13afd33f,0xfd598919,
	0x7a894f85,0x1e9769b1,0xf84db213,0xb3dd8189,0xfe473a2b,0xc609e229,0x53751fe9,0x8561f0dd,
	0x659bc131,0x62e13ad9,0x6cbb5711,0x8ffb15e1,0x292ddbad,0xece5f571,0x841748a3,0xed5fdc65,
	0xda85d5f7,0x7c01d323,0x3ae7617d,0x63f5ca41,0x5d1ba6b5,0x494dd1ad,0x9cf56f45,0xb7c50c57,
	0xbf4963d1,0x50074857,0xc971a56d,0x9b7fa393,0xb355d77f,0x8e9724eb,0x3bf3c229,0x4181b1e3,
	0xa8693537,0xe78748c1,0xb57b537d,0x8ccbe741,0x839beec1,0xa29105b3,0xc5711c2b,0xe2090ead,
	0xf8e5a925,0x8d91bb29,0xf2a598c5,0x988bbb33,0x842f51b7,0xbd8f930f,0x8453a4a3,0x0b4b14e3,
	0x02435313,0xefb95edb,0xeb153ee1,0x49efc5d7,0xe9d3ea1b,0x8a65948b,0xc9f96f6b,0x69bd072f,
	0x24819afd,0x3e0f6ba1,0x9f6b4bed,0x76abce13,0x87cbc629,0x46611a2d,0x0e471cdd,0x044f18b7,
	0xee235d5b,0x4b2731c3,0xc6cba27d,0x5eef5b55,0xefd9b897,0xe1571c83,0x0f9f79d5,0x5c750d29,
	0x3c2b8b29,0xac11ba0d,0xeed3a1b1,0xcd715583,0x923bf8a1,0x1d991c93,0xf2e11fab,0x8e1dd8af,
	0x5a19c9df,0xd85f65c9,0x9ba7c51f,0x375fa509,0xddb7c203,0xaff9c3eb,0x636f1439,0x6fbd3ff1,
	0x21f31379,0x4a258ebf,0x67e944e5,0xdc6dd2d1,0x5f8ff4f3,0x5fcb8493,0xb32f69d9,0xb2457819,
	0x1c37566f,0x9df5273b,0x24bdb599,0xe6cba845,0xe381b62f,0x26dd3915,0xfa7ddf67,0x0127c6d3,
	0x9fe915bd,0xb2df5a07,0xf9c1a855,0x8b2dcf4d,0x93d30eed,0x5183c47d,0x3841803b,0x22572247,
	0xf28b08db,0xca752a6b,0x851b4ab7,0x28c57257,0x19458ce9,0x9e8fb251,0x71d9442f,0x1643d11f,
	0x681fbbc5,0xa8cb1433,0xfb6b06d5,0x6945dc4b,0xbb1be25f,0x5f51d69f,0xd329af9f,0x37e10a87,
	0x83272ef3,0xb471aba9,0x47d1234b,0x60dd1891,0x7f158605,0x979feded,0xce917361,0x5ca19629,
	0x14a37761,0x167b3d95,0x2bf36333,0xae419315,0x49755319,0x1dc93d49,0x3cf30cd3,0xf4756c2b,
	0x5c175e87,0xda796f41,0x5ff1a625,0x9aa1b843,0xfcff2951,0xbaa1323b,0x7db565cf,0x29d1553b,
	0x27870261,0x0e7fde7b,0xb26d883d,0x39b39501,0x9af38ceb,0x497902cd,0x96b574ab,0x01a38a83,
	0xf3717569,0xe31dc189,0x28890217,0x89a576bb,0x6313469d,0xd8214d8b,0x5455dc45,0x7b6155ab,
	0x0ad75e97,0xcb658737,0x1de708c7,0x932b8b5b,0xf3a303a5,0xc6efb97b,0x69798bf5,0xb0fbb0dd,
	0xa73f9965,0x9ceb76cd,0x64ab2ded,0x89758149,0x6961f5b9,0xe8b19629,0x8f835f95,0xf6e3e6c3,
	0x10a7d5cf,0xafc15017,0x65733f9f,0xea372773,0x7f957317,0xa2bd7ba1,0xa653bf81,0xfc0d3289,
	0xbd95384d,0xfe77eb5f,0x3f63e879,0x9da30d41,0xaffb9677,0x0ce1ea6b,0xd44d4091,0xe9e75fd9,
	0x7307f9db,0x461fd96d,0xe81f4f95,0x166b229b,0x52d9df11,0x1173eb91,0xa651441f,0x84676adb,
	0x648107f3,0x264d038d,0x4bc5b88d,0x71bf57ef,0xbeefd0a3,0x8d41b09d,0x2fc39805,0x49fd2039,
	0x5403a48d,0x41114b87,0x6cfb2379,0x97533e23,0x69819365,0x6fa13399,0x2a85169f,0x939bbd1d,
	0xb2130623,0x5aff2ba7,0x84e1ecf7,0x5959a6a3,0x064f940f,0xda61d711,0x16f746c5,0xb4b58f33,
	0xbdaff7b1,0x7b2756b7,0x23176e1b,0x94814359,0xa79b23df,0x41d5060b,0x5bfbfbd1,0x1b3994a5,
	0xa45d78b1,0x0b1b5801,0x4dc39c85,0x4fff46af,0xde27188d,0x8ccfd415,0x66f7f59f,0x6f9d1c19,
	0xa21b5d1b,0xf6ef334d,0xa185aa4d,0xdd85038f,0xd9376c51,0x34a19d37,0xcbc98087,0xb4d164bd,
	0x216ded6b,0xcd3504e7,0x717fa60b,0xf9458d61,0x868bdde9,0x651fa5fb,0x64d31563,0x68493e3b,
	0xdb538699,0xdefda197,0xe7531adb,0xe9ef5813,0xb267908d,0x1c97bb6b,0x72f9f98d,0xa1f3a8bb,
	0xf7533a1f,0x5fd936a9,0x2323b057,0xa0b7d80b,0x278babf5,0x4bddd311,0xbd9ddedf,0x344574e7,
	0x2b6b6df9,0x85dde9e7,0x5b93ca97,0xd94f2237,0xcf39fc5f,0xf643aaf7,0xb29f83b5,0xcc2fe3eb,
	0xdc1f7ca1,0xa9997999,0xfdc12a39,0x39e78bfd,0xd1339283,0x519969a9,0x866152e7,0x1123476f,
	0x3c71550f,0x6621dc8b,0xcd518c53,0x73334b49,0xb3bd639b,0xe6353e2d,0x53c903d1,0xc513a19d,
	0x6de31abf,0xb905e207,0x04674a7f,0x60651685,0x7b97e961,0xaee70011,0x3c353a49,0xe4714521,
	0xa077c5a9,0x2259d1d5,0x73a1fadb,0x272dc49b,0xcc05c20d,0x3901cf5d,0x878726ad,0xc6317523,
	0x32adc249,0xc4ad0c41,0xa2250ffd,0x57bfecf5,0x06c7505d,0xc455b49b,0xc42325d5,0x3bc3054f,
	0xd18b9197,0x8515aa13,0xed937903,0x0ccd877d,0x6c1f5b89,0x633340d5,0xe6eb611b,0xb119f9cd,
	0x988f690f,0x2b211c97,0xaa0b4181,0x0b898c9b,0x3acfaf4b,0x1a712d97,0x6b3f6e5b,0x4ca52747,
	0x31bdd2a9,0x80e3cd97,0x42333197,0xe3a3953d,0xd01bbbdd,0x015ffce7,0x7303efed,0x0f5bd2e9,
	0xf5974ce1,0x72efbf5d,0x572b6ddd,0x0f4f7ac9,0xc7c335f9,0x61cd9953,0xe69734ab,0xf4a9525d,
	0x0b1deaaf,0x30572cb1,0xe095176b,0x133ff72b,0x1c0bb6d9,0xd811f5e3,0x94dfd7f1,0x1285abc9,
	0x87d5f38f,0x4aa928dd,0x4c93ebdd,0x9ea344cd,0x45b15c37,0x72f9ae21,0x533b6195,0xb95f35db,
	0x8fbd8379,0xd5fd3faf,0x9fc9e54b,0xab2fbe9b,0x5bfd684d,0xd3d9a617,0x1d91e5f5,0x942b37bb,
	0x75592ae9,0x88df156d,0x9555da53,0x9d157ff9,0x34abe1d5,0x4e85aa4f,0x363da5eb,0xc8578915,
	0xd9ab8ed7,0xdc6706e1,0xbedb1e0b,0x630504d7,0x84013407,0x094b0fd3,0x4625aecd,0x15d93211,
	0xcc3508bf,0x2c21c959,0xa47f200f,0x9633c99d,0xfcbfcea1,0x1cff542f,0x7cab7a79,0xf7210b5b,
	0xeaf9469b,0xd6230a9b,0xe4df0c79,0x9a51eb35,0x7027c5dd,0xb4f5bd69,0xafb18f47,0xc1215e1b,
	0x8277eae3,0x5aff10f1,0x55216be3,0xbd91c707,0xedfd7271,0x2efbfa0f,0x7b972011,0xc34b83fb,
	0xadb32c91,0x7dc55b27,0x20e3c365,0x58a39b01,0xe4811199,0x3b65c129,0x633fac33,0x67938727,
	0x76317721,0x64074087,0xea4b349b,0xeebb2589,0x4075650f,0xfd057241,0xf00d9f85,0x5267c247,
	0xf3ef0a8b,0xb5d990db,0xe9f91d9f,0x4d8b458b,0x8d1d530d,0x292db561,0xd1e3f261,0x82bd8085,
	0x6d6f9b4b,0xbdcd346b,0x0f0fb909,0xad439a71,0x1439864d,0x27af1b13,0xff21c9a1,0x72059d8d,
	0x77b7f25b,0x88f3cc03,0x1f2fbdf7,0xd0972425,0xfe0d0e09,0x32ddbc63,0xd4ab16a1,0x34332589,
	0x16458d33,0x06dd50eb,0xd67b0000,0x24b9e311,0x7157fdfb,0x7789dad7,0x35e33739,0x97b5f51f,
	0xdb1f3dcd,0x299fb4ef,0x07950f3d,0xe15b781f,0xb35d0e5d,0x3505807d,0xaca995c3,0x4581597d,
	0x06c3caa5,0x05c98259,0xbb9fd84b,0x28adc4b7,0x47e13be9,0xdd211fdd,0x895f4919,0xe107b04d,
	0xa8358eb5,0xf26d7bf1,0x523b4441,0x27638ac7,0x112167d9,0x34333401,0x02ebb497,0x283907b7,
	0xbcf51975,0xa9213d03,0xa18dd8bb,0x34ad0cb5,0x6fe3f7e9,0x710be073,0x56a92815,0x1389be65,
	0x5109cedf,0x65f1d959,0x163357d3,0xf241ad6d,0x6369764f,0x5cf9913f,0xe8817fed,0xf5eb2381,
	0x9eef8771,0x07737d3b,0xd3516023,0x6c4d905b,0xa97131c7,0x73d39aeb,0x62d1c4fb,0x9ccf16b9,
	0x2fab301f,0x2eb90d75,0xd28b0cc3,0x39833965,0xde41dd8b,0x03e9da85,0xd67bcc97,0x7027a831,
	0xfabf6a67,0x5f51c74f,0x04019551,0x9b192cf7,0x9c9b3157,0x4e0b5593,0xdae3d89b,0x9265b897,
	0x862d2c43,0x1f53e095,0x6e53ede3,0x9cbd8ffb,0x9dbd8961,0xa58fda23,0xadeb3761,0x007b9913,
	0x0677602b,0x174d2791,0x4ea76715,0x34a3c7d9,0xd96d8665,0x90439ebd,0x53f3e3c3,0xb1ddab4f,
	0x7e9f851b,0x3251a30d,0x389d4dff,0x637b1a7f,0xa5edad9d,0xe67be26b,0xb7df251d,0xb87b0177,
	0xe0254e8b,0xbdf33251,0x36578c3d,0x547b4e53,0xd7fb08c5,0xf30b8cb9,0xcb0f2f47,0x60c7fe35,
	0x2b0d4477,0x8a432d29,0xe87747eb,0x7d4f4a43,0xe2ddc613,0x9341cdad,0xa567c29d,0x51b3f4b1,
	0x8dd96357,0x09d303dd,0xa61f839d,0xbe2fb5b5,0xf855d843,0x56f1bdd5,0xa549cbf5,0xacb1c895,
	0x858bbc27,0x71b7df39,0x9cf1be73,0x81c99895,0x28a19691,0xa06dfe37,0x8f9504ad,0x2db58e0b,
	0xfda5145f,0xd9814087,0xf1119405,0xdd53fb4f,0x82875cb3,0xc4875861,0xafad929d,0x4b2d29bf,
	0x702785f9,0x5b41a18f,0xdd1d5c6b,0xb07986c9,0x33492ae7,0x2a935e5b,0xf777a821,0x560ff0d9,
	0x05951f73,0x3389149d,0xd23bcc41,0xc573246d,0xa6a545e3,0x6c5f0aaf,0x1f512411,0x99cd4905,
	0xb4f383c3,0xe16de479,0x9809949f,0xf0ef9e29,0xa6e1d6e3,0x763f6069,0xc61d31c5,0x7c55486b,
	0x63bf8a63,0x467f3471,0x6cad0323,0x32213e65,0x7cbd8ba3,0xa7050b0f,0x913fe91d,0x9e1d55b7,
	0x05fbdf4f,0xc6cda049,0x24c5a1e3,0xd2b97009,0x0f7d3659,0xf001feaf,0x4c99ee6d,0xfa13c811,
	0xbe2da2ff,0x68efdc51,0x4b77d77b,0x86ed5e83,0x04e16dc3,0xf50917cf,0x0a8b1293,0x05ad8723,
	0xfd550a6f,0xf5f1554f,0x42638705,0x8d6b95b9,0xe12b2d17,0x2c6dbb7d,0x43f9f2e7,0xd0ddab17,
	0xa2f3ff17,0x196bd08f,0x61abb019,0xcf65a217,0x271f7413,0xfeff7741,0xf8439943,0x26111c9b,
	0x1d0bbef3,0x81690bd9,0x17f10ed5,0x0091b087,0x77fde6ed,0xe811a125,0xcd4d1c03,0xaa3f34d3,
	0x881f7c7b,0xfe815d79,0x0a57bbcf,0xbf1d2e73,0xb3876e63,0x9573f7b3,0x2f773dff,0xfcd55d6d,
	0xcf31feab,0xa3c55439,0x347fcc21,0xb3bd69c5,0x17ffd7ab,0x077b41f7,0x71a50e91,0xd7c9b091,
	0xcbc140fd,0xe6c55761,0x088bf169,0xb1a130e7,0x62297483,0xb0f7ef77,0xed398993,0x2f8d98eb,
	0x65d51369,0xbf9346bd,0x8f1f19bd,0xd67d72c3,0xed47bb21,0x973db841,0x22133761,0x530f71a3,
	0xb3ebba69,0xc8c31a97,0x87590fb9,0xaa83dec1,0xd317e643,0x721b3cdd,0xd697ccd3,0x0bc52663,
	0x1b078ef9,0x5f6583b7,0x86dd1a77,0x406584cf,0x0bdf9521,0xcbe7a655,0x37a5cb43,0xbd9dd357,
	0x6eab9e93,0xc30d8b69,0x19cf9d91,0x55537553,0x8e5f6b73,0x216f4633,0xf8a1208b,0x870d6527,
	0x10d94b2f,0x35cb3377,0xe2cfb91f,0x71016139,0x6fdbb177,0x02093681,0x736dc707,0x610738fd,
	0x1211eb47,0x1c331629,0xbafde9bf,0x05a139ed,0x0413f3e3,0x2f83f9cb,0xc869658f,0x3ef9bc85,
	0x515969d7,0x1d55064b,0xd1ffa887,0x8fe3d155,0xfd49a3f5,0xbe311b17,0xfe79ef7d,0x2ed90de9,
	0x9c2fe659,0x42c5af25,0xcdf50b11,0xb6fb79dd,0x8c3fb765,0x34e5cdf3,0x22fd44ab,0x79179bcf,
	0xce9754c5,0x18933483,0xeb81637b,0x6c9ba66d,0x8039486d,0xacf18e67,0x69d9d175,0xc0a5c567,
	0xf3131d95,0xcd51d2af,0x1dc5e05b,0x0cf58a73,0x66f735c5,0xf229c0fd,0x4d6d2eb3,0x22f57a55,
	0x62a5bdc7,0x52137e71,0x2e632ccd,0x7eb9b9d7,0xacbdc2ab,0xa2db52bf,0xae9dc1bf,0x57f9dac7,
	0xe4cd66cf,0x7a6b8517,0xdd7d106b,0x531bc901,0xbc4b36d7,0x4fdb5937,0xf4cb5c75,0xd225d765,
	0xcf919eab,0x1c692c65,0x01b50f4d,0xe5cbecdd,0x1ee37e83,0x9c7bb26f,0x2dd7dd2d,0xde69d15b,
	0x276fdfd5,0x309f52a9,0xa82f0a11,0x7cff9ad7,0x9c47ca67,0x5e8da4f3,0x2e25cec1,0xc4373a51,
	0xbf6b3945,0xf2210ead,0x3489ddcd,0x696528d5,0x5abb2fc1,0xbe617fc9,0xb095088b,0xe5813473,
	0x5907ee77,0xfe7f4fbb,0x80e7041d,0x262f6d43,0xfeff4849,0x56cd3a7f,0x768b4e67,0xdebb3267,
	0xc4431763,0x75cd7d9b,0xfded3319,0x79135f0b,0xcc57d239,0x5521151d,0x67e7f0ad,0xa6d3975d,
	0xffa54085,0x1a9b1899,0xd2bbfd5f,0x923fb597,0xc483504b,0x992f382d,0xb30d6c37,0xaf3f56f9,
	0x582b0ad5,0x71fb597f,0xfcf17205,0x2c6788cf,0xc7c5a9b7,0xd54754b9,0xecdf0a5f,0x03ef9569,
	0x8959cbcf,0xe381d195,0x70b5bca7,0xacbbf121,0xb4dfca3b,0xae3f444d,0x30bd8101,0x6b574757,
	0xdd312d6b,0xd93f0aa7,0x38a7c55d,0x42f1a773,0x8915420f,0xdb67a8ef,0x408b9275,0x8665d1eb,
	0x4c35ce25,0xdfc526fd,0x95e9d0c5,0x0937a533,0x8027e5ed,0x468f8d2d,0xa4a9ad95,0xf08faacf,
	0x9d67e0f5,0xc6258163,0x201d1ff5,0x243fc447,0x34596f0f,0x2c0d040f,0xcbfb8dbb,0x5fc5f82d,
	0x8647cd57,0xbdf34d23,0xe5659089,0xe33f5f1b,0xbe691b2f,0x3aafc91f,0x2be3dac3,0xc47930b1,
	0xcadbcf43,0x7b3f3605,0x8a633c9b,0xdfe5f099,0xd59d4c87,0xb3c9e067,0x6041c905,0x699dbb85,
	0x5da19735,0x549d0055,0x6a391ac3,0x1e63b42b,0xefb729d1,0x8b2f3671,0x4b77b95b,0x14a3904f,
	0x7f9dea25,0x631d28dd,0xb68b9e1d,0x2d6f45bb,0x60f73e47,0x872f4047,0x366bd921,0x257fd73f,
	0xe051418f,0xa25384e5,0x97775643,0x463741b3,0x7c1f19a3,0x609d9b75,0xf079c22f,0xb6a188f9,
	0xbdbd6b6d,0x104fe239,0x4ba38f4f,0x6c6fe4fb,0xb271f01f,0xe2cdae01,0xef891adf,0xbcfb0eab,
	0x04672a35,0xcda3a723,0x482df1db,0x8e49ad01,0xb3b13a75,0x0b8d4679,0x6ff9360b,0x27ffe1fd,
	0x6f4dd4e7,0x3d65726b,0x58bb22ff,0xa475f7ab,0x8e1f55df,0x2b313be5,0x94abb30d,0x01a12d1b,
	0xa7f3f6f9,0x2521bb5d,0xbf6d6457,0xd227a367,0xce7d2417,0x048b0dcf,0x87051dc1,0x8e516aad,
	0x665bf065,0xcced71c1,0x54e333fd,0x8511af1b,0xa00fab57,0xeced8441,0x96e38e7f,0x6d0105df,
	0x910795a7,0x1f599de3,0xa843ec8b,0x9563da33,0xec95b659,0xec294fc5,0x5aad4a23,0xb723fa59,
	0x5cf7cfb9,0xc979008d,0x1f2d6519,0x65d14499,0x7c517457,0xdc91a967,0xcf3f6203,0x20a97445,
	0x6db13c13,0x5addb307,0x15c39143,0x038d0eb7,0x1607190b,0x8af7f2ad,0x780153fd,0x1807704f,
	0xf533ccaf,0x6599c71d,0xfea72123,0x4647f975,0x9ef77cb1,0xd6ad55a5,0x7ed1aa6b,0xe62b5b9f,
	0xd4016809,0x9e3de719,0x82fd2153,0xf0350641,0x3ae5bbff,0xd18364d7,0xd4119c23,0xce8bb3df,
	0xb91d891b,0xfbddf5c3,0xa2639aeb,0xce031701,0x6c0fd831,0xdfcfbb4d,0x4ea7ac83,0x2f17a73b,
	0x4209df5d,0xd809ae67,0xd2fd3387,0xd6e98e23,0x333b5701,0xd8619c91,0xcbef4b63,0xa043b45b,
	0x1ac5eec9,0x0ed544cf,0x216fcd41,0x4c95ee8d,0x2fabe2a9,0x248994af,0x4fd1751d,0x14fd4a6b,
	0x1dd7afdb,0x1ed10543,0x50d726b3,0xdb3b7bab,0xbf1de9e3,0xe01d182d,0x24ab528b,0xfabb6913,
	0x743d2f8d,0x490ff48f,0xfadb7af7,0xb98dd967,0x1dd73feb,0xf96d2419,0xfb5fd909,0x596d407d,
	0xb57b2f57,0xb1236ffd,0xaf9921a5,0xc8bdac2b,0x869bbc77,0x5149ddf9,0x0b516a6f,0xf385d155,
	0x0793c535,0x7d1dcd55,0x15b72ed9,0xb47b38e1,0x52a7dbc3,0xdb0733db,0x32637517,0x65f58cc3,
	0x3f05fb9f,0xf591fae3,0x0a55132d,0x12fb04f3,0x19c15e89,0xbc757c47,0x14f513dd,0x4831f473,
	0xfed77191,0xa58f1f6f,0xc1153bb9,0x84ed764b,0xd22bea05,0x6de71647,0x3debae19,0x4c293a8d,
	0xd887fa83,0x7aab3a45,0xe419b21b,0xd5857351,0xf0a3a7ed,0xda310967,0x3ea597a5,0x5e4fe1bb,
	0x6c1b3e6f,0xe4f5c32f,0xb403bc69,0x1a7502f3,0x886fe67d,0x7ea1a5ad,0xcf07b0db,0xc5955d29,
	0x881159d3,0xf7014a75,0x27f57d3f,0xd3efec97,0x6b51b871,0x8b0b23a7,0xed730697,0x436db07f,
	0x496b7da3,0x85df18e3,0x0d9193b5,0x0ca35829,0x498794ff,0x01c1445b,0xfec97231,0x33cb0fe7,
	0x3baf8f5f,0x4923cfc3,0x28f9bb69,0x79c56e13,0xd1d7f7e3,0xd797f157,0xee6d3983,0xad1f800d,
	0x78ddc8fb,0xfadd08dd,0x54d16c71,0x9b07f73f,0xd1810159,0x13dbdca3,0x4e3faee7,0xa05b761b,
	0xc97558f7,0x779ff67d,0xa2377b69,0xda9bfd17,0x54491617,0xf06120c9,0x76a3d139,0xf8f177b7,
	0xc47b0247,0xde7d036d,0x78d1b969,0xad316985,0xc46f7f5b,0xf97be0d5,0xa679ebd1,0xbcd3bb0f,
	0xef71bc6b,0xb10772f5,0xb6bd940f,0xb1fda6f3,0x0ab50adb,0x2dfbe84d,0x23253689,0x2c75c6cd,
	0xde595359,0xf35100e1,0xd0a1b571,0xd2af4049,0xae5faad5,0x1f314b3f,0x588975bd,0xe2c71219,
	0x53b3078b,0x4beb8179,0xf19da42b,0x637b80f5,0xf52d15ff,0x10f30631,0xf9059a45,0xf53ba49d,
	0x60852dfd,0x23e9818b,0x1b536357,0x431314dd,0x03616795,0x19919e31,0x1d7d617b,0x13c3b685,
	0x844dd027,0xc6dbe65b,0x45e3128d,0xfaa9a86d,0xfbbfbf53,0x41ddc0c7,0x6551f539,0xa8d15079,
	0xcd0f4c05,0x82d58db9,0x7ff38deb,0xdded888f,0x1f87e171,0xa529e3fd,0x16658bd9,0xf959eba3,
	0xf74df40f,0xc867edeb,0x0ea50e07,0x2b1342ad,0xee7bd6a7,0x9145e65d,0x3d190837,0x44cb11af,
	0x8e09af41,0x4aa3b5bd,0x8d97c7fd,0x2acd44b1,0x46dd8c33,0xa687aef3,0xcc5199ab,0xe519fcc5,
	0x0ac59915,0x1f1d6c77,0x0eed8d65,0x504d7d05,0x857173cb,0xf7bdcd45,0xbd6f5c11,0x6eb53791,
	0xf581a183,0xdde711e5,0x3b496c5b,0x5943fa93,0xa57723ad,0x2a3d1961,0x3053f7bf,0xd0913d3b,
	0x04c12d05,0xc191be4f,0x71cf4f7b,0x6de38cc3,0x60b3f68f,0x95d553cf,0x8b614193,0x7421196d,
	0x3d87b497,0xc72d4283,0xe81d9dd9,0x40dd6383,0x4f65abaf,0x64dbc599,0x9b79dae5,0x5d550853,
	0x135565b3,0xce4fc7c7,0xca59db15,0x2f67af39,0x084f06c5,0xb41de049,0xb3ffd191,0x4a9f1695,
	0x882dc251,0xb9076fe5,0x5b214747,0x612f40d1,0x40b57009,0xb2f1dde9,0xced53fed,0xd4f1c15f,
	0x4c9140eb,0x8be9f529,0x139b7f07,0xe86729b5,0xec559439,0xc3256105,0xac5becd7,0x8fbd9659,
	0xdf81ec7d,0x8e054a5d,0xc3671b71,0xe1c55bcf,0x5d77048b,0x990d14a3,0xf375eba7,0x28f7d3ad,
	0xae810481,0x68ed3acb,0xb0a5521d,0x94774989,0x64d7d6bd,0x5b7b4c51,0x51833c39,0x890f0807,
	0x35939cef,0x48b50a3b,0xb7fb9529,0x923185cd,0x71bb4507,0xc3c1a417,0x9a696ae5,0xf2f7b28f,
	0x1f393e41,0xfbef14f9,0x6c89332b,0xd7236405,0xb1e34e23,0x3db3a07d,0xe8873085,0x2421e2ef,
	0x64758573,0x13ab6fcd,0x37f1f73f,0xea039819,0x31935549,0x079f4e93,0xbcc11273,0x7481d953,
	0x6cc9c3ff,0x037b8803,0x7a57c8ff,0xfbfdd677,0xfb8bc237,0x5259e3dd,0x1e790289,0xf685a665,
	0x2e359fdd,0x4173c365,0xaa594c83,0x08c97405,0x390da125,0x61335e67,0xbb8fff23,0x9723cb4b,
	0x4d3db389,0x6623203b,0x751b8269,0xf695062f,0x51db42cd,0xa9ff24bd,0x0867b319,0x3dcbd9b3,
	0x3ce32dfb,0x4c9fd551,0xde4167c7,0xb61502e1,0x0c39dc67,0xf50da5e5,0x5fe115c7,0xec6f13c7,
	0x5ea972af,0x3277f1ef,0x5fe99639,0x627b6081,0xace727b1,0x7d33f96d,0x23610b03,0xdf830c2f,
	0x2291b99d,0xd7bffde3,0x0ab9e3d7,0x617935f9,0x172902e3,0x0fc17f5d,0xdac7032b,0xadf74615,
	0x271baf41,0x9f079973,0xa5cf033f,0x833f5ab7,0xecbd10b7,0x2c89803f,0x54779b17,0x693bd523,
	0x594d1493,0xad631d69,0xced12387,0x228106a3,0xadeb5867,0x25dbcd1d,0xc5533c23,0xbd47fd85,
	0x14a55f0d,0x0a633b11,0x19df904b,0x446f7227,0xd96fe5ad,0x408d5f83,0xe8bbbc25,0x1087d3e5,
	0x432758ad,0xc0199c35,0x319b51a3,0xb8bd762b,0x0c8f68c1,0xd3eff977,0x2093fd7b,0xa3efdd6b,
	0x7d55bfe9,0xfb19831f,0xf727cc2d,0x399d2c1b,0x230bd661,0x69d1c587,0x953b8efd,0xb2f3afc1,
	0x2a2fe7bb,0x2a756a97,0xa22560ff,0x8bc18de3,0x572507c5,0xde89f6bb,0x55974c07,0x93839113,
	0x9f3b579f,0x1fbba5e7,0xe0b70db5,0x9e5915e9,0x61a15aa7,0x80e5689b,0x7709fc71,0xd6111807,
	0x40776b8d,0x2f0300dd,0xf77f0c69,0xab195f19,0x99bf5141,0x32393f37,0x3571f495,0x658fcbcd,
	0xa067f401,0x4ed95fbf,0xe19f73b3,0x5633c4dd,0x1543324d,0x86598713,0x1333b54d,0xa771c40b,
	0xa00dd5f3,0x38555f57,0x70b9d6af,0xce59031f,0xc86ba905,0xe393d53b,0xf92f8bf3,0x9ba548eb,
	0x8eebaadf,0x8703f4f3,0x6cf1e4f7,0xecbbd647,0xa5ff6523,0xa2bbe73b,0x56c93263,0xfca17317,
	0x4b0360bd,0xd8f90e57,0xb4e50aa5,0x550d9b43,0xbf3bbae1,0x2f254319,0x41e16ef5,0x5f55cbbb,
	0x60d5da09,0xeec931d3,0x5dbb1053,0x957fef7b,0x63e542f9,0x269fd763,0x96dbb483,0x5335ec81,
	0x2b658dbd,0xcb831e2d,0xd311bb19,0x46c750d7,0x423d7aa5,0x797d9b21,0x1899c269,0x822f1f8f,
	0xf4352751,0xd4b96ab1,0xf70d6c93,0x2c13bdc3,0x8705639f,0x8a912ddd,0x907b447f,0xd0b9ff93,
	0x134726bf,0xf27f2729,0x424fc2db,0x53155529,0xfd812421,0x4f2d77a1,0xee63731f,0x7dc317b7,
	0x0f1d8083,0xaf677bdd,0xe3f9388b,0x3403f673,0x2f71a6e5,0x6f2348f7,0x68b7b323,0x42bf83a3,
	0xbcb93d95,0x58814997,0xe1adc4bb,0xd18be18b,0x85173b27,0x64c5faeb,0x9c5535e7,0x739f8f81,
	0x5f9b1b71,0x1d5fc9a5,0x378d7b07,0xd8e156db,0x6537349d,0x9ce50f03,0xac9f9943,0x1ed757fd,
	0xc9c72c11,0x30152dcd,0xf83b2b89,0xc1b5374d,0x55118b83,0x96d5cf4d,0x63798791,0x2d576a3f,
	0x7bbf75ed,0xe533405b,0x6cd902db,0xee3ba44b,0x18677c93,0x0465ee51,0x514557ad,0x829163f1,
	0xc4859401,0xd3cb0417,0x35092a15,0xcb259fbd,0xd17d2907,0xe9eb2719,0xece3aced,0x1c77933f,
	0xe19b55c5,0xf573544d,0x66ef66d3,0xefa5ac11,0x21133699,0xbe37dd2f,0xb3b7172f,0x337b96d1,
	0x1f035f33,0xc63784c7,0xaf29bb2f,0x3d6b6c2d,0x466d6f85,0x8a99bc9d,0x49a1b2cb,0x5a91fdd3,
	0xf73dc8c7,0x64ad01cd,0x70dd05c3,0x00ab437d,0x3f496281,0x0ae759ef,0x9905c89d,0x9f27e7ed,
	0x334dbf7b,0xb1e7f02b,0xe5a9a1a9,0x1017f5eb,0xe7ed02c9,0xcd71d22d,0xf2c36dfd,0xa933a549,
	0x0ab524c7,0x7173cd29,0x3db30679,0xecdf47e1,0x1b1b4817,0x53076adf,0x2e3f24c5,0xdb255693,
	0x43772ea7,0x69690e93,0xbf9b684f,0xe2b79e49,0xd211cea5,0x2eff3213,0xc95b7b4f,0x71f18cf3,
	0x52150793,0x8257c2b3,0xe88357c5,0x27d19e8d,0x4495772f,0x27279e51,0x0877ac77,0xa505ea15,
	0x798f6e85,0xe74f3053,0x8c0b61f3,0xfcdfce95,0x08e706eb,0x53d32ea3,0x16773f93,0xc657c021,
	0xeb6b56fb,0x25e576bb,0xf459b077,0xcd1134cf,0x33cbc795,0x3fd70a95,0x24bba883,0x6257b1c1,
	0xe7a788e9,0x4e292db5,0x020da967,0x4e1bf821,0x78812769,0x0881a22d,0x8b27e79b,0x5ff75221,
	0xdcc740cd,0x12ad058f,0x4c4b8f5f,0xa02ffff9,0x48cb591d,0x7da54df9,0xe81d29b9,0x20abc4e9,
	0x87cdcfa1,0xe887670f,0x40b12177,0x6dfd943d,0xf4edf3ed,0x4195eeff,0x407d6833,0xa0615e45,
	0x14393add,0x2743137f,0x43633b4d,0x0cb9fd59,0xcba79395,0xe9258ecd,0x1fab08e9,0x958f42dd,
	0x3c11dc7d,0x28f7c4ad,0xcf0374f7,0x9c152437,0x3a3b784b,0x1ba3ff6b,0xb7877e2f,0x912507db,
	0x67d302f9,0x6a33ccdf,0x94b5c311,0x26413241,0xec6d26cd,0xb2e37b63,0x0075e6e3,0x1e9552eb,
	0xce83914d,0xaa0bb6df,0x9c1716b3,0xbff13161,0xec7d0851,0xdb3745c1,0xd955ae5d,0xe3d17a35,
	0x95a39ef3,0x0a11e5fb,0x634ffd7b,0xa857abff,0xc32d0a93,0x33714a0b,0x278b2c77,0xc14d2463,
	0xf13517e1,0x2e5335f7,0xfefd417f,0x69254d09,0x97c13fcf,0xece1bc4d,0xf6f9458b,0xf1f9e8a1,
	0x43bb5c97,0x5d699b23,0x3a41895b,0xf68b7fe5,0x4ff97ebb,0xeb5db913,0x99ff0a75,0x2b47ee97,
	0x3e35e20b,0xa05fc245,0xb6c1f829,0xcf3d1081,0xb0170295,0xe535e565,0xc981588d,0xbd298e71,
	0x0029d1b7,0xe2cdb0a9,0x0c9dcd81,0x1c6dcb43,0x7add0b13,0x833b0ecd,0xc4df79ad,0xb211f0d7,
	0x3795a997,0x12bf6417,0xea770581,0xd1cb1d17,0x918f7c73,0x80c1cb55,0x71fdc431,0xeef3aef3,
	0x40fddc23,0x40cb72db,0x3571f8bf,0xcd8bb367,0x13ef7f6b,0xcb971987,0x7d3d3af1,0x533f7271,
	0x47617057,0xc003abbf,0x292dfc57,0xf85f1c1d,0x803b2139,0xa413006f,0x797f2d47,0xd8e79579,
	0x6447a1ab,0x45f7b60b,0x77cf01e1,0x657965a3,0xd339f393,0xbd032f93,0x0025d70d,0xb45dc2b7,
	0xbfad801b,0x0ab9b18b,0x69f5377b,0x7289bee1,0xa829acb7,0x5bbd9f01,0xd113009f,0x74959553,
	0xb0199021,0xe8ddd689,0xfec3a7bb,0xe7c31745,0x58cfc75d,0x780f2f41,0xf2ab9ed5,0x22fd38f7,
	0xda896ab5,0x7d7315cd,0x0bddd9bd,0x17d7beb5,0x1d6b22bd,0xdc4f495d,0xd1cf7309,0x638b09cf,
	0x52815d51,0x480fb8a3,0x5d617119,0xfffb059f,0x2cbfa295,0x454b7edf,0x61dfab15,0x94af3483,
	0xba0309f1,0xcac100d5,0xd5f5cded,0x67dddce9,0xdc0fcf1b,0x825929d1,0x3cbd8155,0xef5b563f,
	0x618f070f,0xaa1dc8ab,0x8eb7accf,0x01af75ff,0xbf19750d,0x95470cbd,0xc2cddca1,0xa7031cab,
	0x682b7fa3,0xcd3322f1,0xf74dc6db,0x8a27e2cb,0xc82545a3,0xd269f2af,0x3af1f053,0x0995e5f1,
	0xdb55d327,0x7d97faef,0xf5d771a9,0xe873b5b7,0x67ef7697,0x00914f2f,0xf289dc47,0x9f8760bd,
	0xd7113599,0x8759b471,0x06f73f57,0x4e47a1ad,0xadbd6221,0x7911de45,0x5d794cd3,0x4bc92c37,
	0xa5e14f6d,0x590bcbc1,0x5dcf9e7b,0x57d31a15,0x674f26ff,0x47bd447f,0x36211ad5,0x6bcd780b,
	0xe0c5dda1,0x23c175a7,0x04017a31,0x2bcbf2dd,0x40e94869,0x4ae3aee7,0x9d65eba7,0xf787a45f,
	0x8f4351af,0xfb0d3f6f,0xf9afda13,0x9b61006b,0xe5494e17,0x53577303,0x3aa7d11f,0xa167e1e3,
	0x4759718f,0xf4ffaee3,0x557d8239,0x4247b7ad,0x1db76447,0x446baedf,0x5bc7e99b,0xf65dd1bb,
	0x4d8df7bd,0x4a29e24b,0x64899341,0xa6adce09,0xf1effbb1,0x33f1e907,0x1529fff3,0x7ddf2595,
	0xb4dd3331,0x759f3073,0xca772a41,0x5947d96b,0xc837698f,0x8a39b081,0x61ad2b81,0xd9df3f9b,
	0x7ecba765,0x54f1c8a5,0xa16b00d5,0x1547f03d,0x854f879b,0x22193cdb,0x42b77021,0xe6cbd275,
	0xbb5dac57,0x483352a9,0x9a030d15,0xe05d4969,0xac7b540d,0x68e10e1d,0xe0275e2b,0xdb99814d,
	0xa9130e7b,0x51f58ecb,0x1b65219f,0x2abfdc59,0x7f7991a3,0x7e638cd1,0xa863b279,0x69b97fcf,
	0xd4edaed1,0x3749f5d5,0x63318d89,0xef1900f7,0x1e8f6795,0x54efaa01,0x7047f665,0xdd1d3223,
	0x3a6f22cd,0x9fc3590f,0xa587bc6f,0xd2a30fab,0xa87f019d,0xd15b7f39,0x93391fcb,0x3c37ccf3,
	0x639b546f,0x35758245,0x2d0dd669,0x450b0163,0x5a892ff5,0xeaf7ee7f,0x131b3103,0x67fbf56b,
	0x88f3222b,0xc4efd3bf,0x7ae36015,0xa0850f85,0xb06f0757,0xcb934261,0xb84dd8e7,0x3bd76133,
	0xb179ff01,0x5d43e849,0x66abda89,0x49c353fd,0x847380fd,0xef85cde5,0x31b312d1,0xadc17677,
	0xd2ad9265,0x7005332d,0x3e876361,0xcff56937,0x2f591aa1,0x459b8c99,0x34afc69d,0xee29ebdf,
	0xf0935857,0xf145a033,0xe71954b7,0x0ccf0a19,0xa861767d,0x4f29c285,0x9d2168a3,0x88016895,
	0x3daf414d,0x779733a7,0xfb85e523,0x4483b20f,0xa54ffb4b,0x40039c35,0x8d6d99bd,0x80bd2445,
	0x3aff5241,0x5c0baa53,0xed69c7c1,0x45c13d01,0xba617443,0x1e77ceaf,0x8e73c747,0x784d8717,
	0xd80544af,0xda35197f,0x24e9cc2b,0x89bf875d,0x7a5db123,0xe359377f,0xaf97cb19,0xc923c9b7,
	0x92c7268f,0x30258ef7,0x20a97e7b,0x542b0e0b,0x96852623,0x99fd7cb1,0xa6b98b8d,0xa831954b,
	0x97c3fa5d,0xbe6fb105,0x95c7c74b,0xd3378e73,0xfe998bff,0x8031accd,0xf03d9b7d,0x44e9a383,
	0xe1ff5711,0x28235e71,0x8fe98bb3,0x3f97a683,0x00db7fed,0x2649dedd,0xef05da45,0xe93f5e83,
	0x5af90827,0x72d34e87,0x912f4d4f,0xfc7d74a1,0x6a0d23a9,0x8f17d26b,0x0c7113bb,0x19a180fb,
	0xfab5ad99,0x2693b10f,0xb23bca39,0xb79b37b9,0xa573bd6d,0x4fed8f81,0xd865a03f,0xb505b60f,
	0xe7b35bdf,0x6df3ce55,0xc22f9d0b,0x8921ef35,0xdccd57f3,0xb09d06a9,0x294104a5,0x14db396d,
	0x96f93bf3,0x3607a723,0x66abdcdd,0x13c5faff,0x185d6275,0xcb79b0ef,0x3be9924b,0x2d17773d,
	0xec052b51,0x4e5f94c1,0x3bd7bd4b,0xa4b3bb81,0x5ee750ad,0xad532fd9,0xd3bd0709,0xac27ac2b,
	0x58dd5bf3,0x890fe8fb,0xf44f2e6f,0x53a331a5,0xd5ab3ad5,0x757ded75,0x5aa12d39,0x1b01855f,
	0xfdfff451,0xdaa78e1b,0x79377ce3,0x22c39ed3,0xe06b7da7,0x75c7bc4b,0x00f77bb5,0xfd15c083,
	0xca6faf65,0x7a3ba6e9,0x0a31f1bf,0x1ec724f9,0x416b5a5d,0x52877765,0xdd9fb5d9,0xf055cbc3,
	0x9bad7cab,0x015b2eb1,0x5d5f729f,0x7ee1667d,0x396b96b3,0x228da24d,0x0dfd8b7d,0xcd3365c7,
	0x5dbf201d,0x8c1b993d,0xbf65219d,0xc4c1264d,0xa7ad1cdf,0x8f2b090d,0xd5f138fb,0xc6a33dbb,
	0x2b23d233,0xd90b72d5,0x3361fd53,0xdc9be7cf,0x29f59b9d,0xf4316031,0xbfdf272f,0x8a159347,
	0x6cdfdfe9,0x693d0045,0x92f980db,0x3d218eef,0x3c832627,0x7ff5e4bf,0xbca78b6f,0x5f7bd697,
	0xfa714ab7,0xa045ded7,0xae4d43cd,0x07830017,0x5a19d439,0x5345fc45,0x43af0799,0x49474851,
	0x39dd6897,0xe433a453,0x6bfd9a45,0x2775c031,0x1bfb6209,0xa177d4cb,0x72d34a07,0x246b99a3,
	0x3fa38407,0xbd9b7f05,0xe92f34dd,0x732994a5,0x59e9d053,0xd05904db,0x2e79ad8f,0xc85b8c37,
	0xeec97bfb,0xf78dd5b5,0x9983c0ad,0xcb512361,0x4a250451,0x983f2b7f,0x4183d98f,0x27059235,
	0x18cd63f1,0xbf9de7af,0x671b8753,0x3b1d92cd,0xa17367bf,0x23fd9043,0x7d5361df,0x6cdf6e47,
	0x9db323e3,0xc5db6cbd,0xd2990ee5,0x184129d1,0xb31388d3,0x30e1c32d,0xd9c966d9,0x20d9d399,
	0x8bfd1849,0x5cdb3527,0x131fb9ff,0x22edefd9,0x90c7ba49,0x2ebf3ccb,0x95473559,0x446705d3,
	0x40adb21f,0x99adc9b9,0x364f67b9,0xa5d74cd1,0x2ad3b35d,0x5fe9fe23,0x54b1e6b7,0x73777921,
	0x874516dd,0x73e50bbd,0x404d13b1,0x962da91f,0x6ff72fc5,0xf93330c3,0x436900cd,0x047f722b,
	0xb9c5c07f,0xe593d4fb,0x4bb775fd,0xb3a30daf,0x6d758fbd,0x41ebc6b3,0x334f15f7,0x286fa61b,
	0xe0b31d7d,0x0b4997bf,0xa9b1a339,0xa869c3eb,0x6f117801,0xb3e51a7d,0xbcc7650b,0x0ab9da9d,
	0xd30d30d3,0x441bfed3,0x01dfac7f,0x2933f5bb,0x1f0b71c7,0x1b738f2b,0x5eb17967,0xf15185d9,
	0x565731f9,0x51998d7f,0x72613f67,0x15334d8d,0xa6258acd,0xb7673049,0x9e71cae3,0x5ca56e79,
	0x3e932ceb,0x77d73f8f,0xafd7460d,0x961b9647,0xcba3f549,0x591351dd,0x27e95ddb,0x27ab4ba9,
	0x8e41a221,0x9d65294b,0x2567870b,0x401b5b57,0x1545a7f9,0x84473075,0xed796327,0xa7d36511,
	0x96672697,0x6b57177f,0x14b1457b,0x31e788a3,0xe74dfe13,0x8f599119,0x4805d821,0xcd0f32dd,
	0x168303c7,0x6d3d2f75,0xb5d7e0f5,0x34b10a97,0xa47d5755,0xc3196153,0x16ed26a3,0x41d3fdb5,
	0x5c99d7a9,0x312b8ef7,0x577b7597,0xdc296e1f,0xce19b7f5,0x7ad9572d,0xe015c509,0x8b0d7ec5,
	0x652b34b7,0x67b1ec4d,0x7ebf7bf7,0xa68380a1,0x23e368b1,0x44699131,0xefdfd629,0x28337fb3,
	0xfb3b41ed,0x03e13641,0x07456931,0x1c71f007,0xc41996bf,0x001f366b,0x792bc961,0xb3357aaf,
	0xd8495ac3,0x5b4f3421,0x432f4edd,0xf123eabf,0x4b81f3dd,0x00c91661,0xb55bfa8b,0x00853a5d,
	0xc45baf35,0x460d25b3,0x1b1f7b19,0x224dbfb1,0xf55b5641,0x2bbd4921,0x045551fd,0x3f1779eb,
	0xb5efe3bd,0x3eab6341,0x2e39187b,0x18217e47,0xbb6b58a9,0x18c9cf33,0x0c75e495,0x18598503,
	0xf209b153,0x823bfd99,0xf21bce1f,0xc5519669,0x75f1fa4d,0x324331a1,0xdaa393ab,0xd041d7cb,
	0x2c2b8571,0x30515e01,0xd2eb5f9d,0xc70d7883,0xfbaf3ee5,0xd4f921f5,0x023dad1b,0x653fbef3,
	0xa6572213,0x6afde643,0x53474d13,0x85093581,0x41e7ceaf,0x70411a39,0xbd258b3b,0xb045f79f,
	0x510d3db3,0x76d390ab,0x2c557317,0x51771ec9,0x7c5d9661,0xa5e9fcf7,0x0bbf34e9,0x84c74f7d,
	0xeb532349,0xdae39003,0x6db5aac5,0x89076647,0x3d516739,0x6a45b53b,0xd4edfd7f,0xd0b544b5,
	0x22a7524f,0x80bfef95,0x9d8969b7,0xb2efbe65,0x958796ef,0x2427d68d,0x060f24d3,0xbc7fa5f3,
	0xb30d1ec1,0xd47b3329,0xd8736205,0xa0dbfa0b,0x343f9fbd,0xcce33cf5,0xb3097743,0xcb1b325f,
	0x87075119,0xe4a9f709,0xf195224b,0x8f03aca7,0x873bc05b,0x1047ad01,0x363deda7,0xf9fb39a5,
	0xd797c64f,0x82599003,0x9291b5a3,0x4415ca21,0xdabf9c07,0x6ca773b9,0x508b4d59,0xe10d3bed,
	0x4c3d0fdf,0x611dab5d,0x5b8943a7,0x314546e1,0x7989da79,0x52d506a9,0x4955c835,0xd2c789e1,
	0x1aff13c1,0x3709eee3,0x031fb071,0x9245b7d5,0xcce1c7e9,0x4623a3d7,0x0e7f9c91,0xfc19e4ad,
	0x285bac6f,0xdcad98dd,0x76753c99,0x8d45f263,0x7c83f515,0xfc63f1d1,0x546bb54b,0x84751df9,
	0x275548e7,0x6d1d2017,0xf92f253b,0x52f9ac77,0x8eb5d735,0x7de59f9d,0xb5f949bd,0xadcdb7ef,
	0xb96f8c9d,0x65e9d3d9,0x456b43f1,0x3e931c7b,0x88376803,0x457f04c9,0xd48d7dbd,0xf493853b,
	0x8ea9ef8f,0xc7257bf1,0xabcfaed3,0xf5c39959,0x8c4bc5b9,0x6081c15d,0x780901a9,0x2fbb4905,
	0x85895e37,0x3361f8a5,0x337b587f,0x88bd3a7b,0x7cb5d311,0x8ebd5de3,0xaecdb259,0xb0b556f9,
	0xcb0dd98d,0x0fb1e2bf,0xba0fb00b,0x923377c9,0x19b5d743,0x6283eb65,0xedbb3929,0x6373333f,
	0xfabb170d,0xa3a52b8b,0x13b14113,0x5757c9b1,0x220f1e0d,0x60a9a36f,0x3037abef,0xee673281,
	0x3e9120af,0x394fbcd3,0x2b0153af,0xe7d94919,0x730397a7,0x207f8807,0x18232d09,0xd28519eb,
	0x6f11f4ef,0x3d4318df,0x21218c7d,0x3ded4f6f,0x285378cb,0x6bd503bb,0x0de18b51,0x8b3bbf25,
	0x334126c5,0x5e93fa7b,0x6db38c93,0x5e451699,0xbc41dab3,0x5f018991,0x6051e21d,0xae7fa85b,
	0x209f7dad,0xaecdf4f1,0xfed9918d,0x78115903,0x27915b19,0x88d13517,0x64d5394b,0x0cc1ac35,
	0xdb3195a1,0xc209140b,0x59351585,0x0505f197,0x0183bc37,0x0a9b6a55,0x97512533,0xd0f591dd,
	0x35757f17,0xced57c11,0xb7e96f13,0xe9537bbf,0x9fd984c7,0xb82d75d7,0xba2766af,0xa089b0ff,
	0x506f5f0f,0xce4309cd,0x2c997155,0x93abf365,0x36d7a003,0x37db2ca3,0xf6378b19,0xbb7391c3,
	0xbba10eff,0x9be5f28b,0xbf630be1,0x1d4154f3,0xf93dfda5,0x22778c45,0xfae58c4d,0x1c238cd5,
	0x950bbce1,0x15cf6415,0x8eedead1,0x69c73d51,0x384f31e7,0x23555ac9,0x1e1170a3,0x978b6b5d,
	0xa9338b31,0x3c9324b5,0xf05516c3,0x476f89ed,0x83cb1583,0x1843c6b7,0x7c1feaf7,0xfd1d0705,
	0x931730e7,0x53413333,0x8f4194cd,0x8ee9f8ad,0xc9f965b3,0x31950719,0x17f1fa9f,0x36cde9f9,
	0xdc3b997f,0xff6d66db,0x8dcf068b,0x4369c7ff,0x77956431,0x121dfb79,0xfae78b79,0x6909eee1,
	0x1ca184f3,0x69250f75,0xa4a54a17,0xb2a156c9,0x97e57737,0xef2dcbe1,0x54e515dd,0x12c7e0e7,
	0x1acb27bb,0x5b01954f,0x42e31a0b,0x94c1c477,0xf4a9c97f,0xb09788db,0x9c4b3ea7,0x2d791bb7,
	0xebb9cad1,0x620f192d,0xae2bad7f,0x2c7d90f3,0x3623ea43,0x10adcb73,0xadfd772d,0x4d0d2b79,
	0x12f16bb1,0xede1145f,0x229f580f,0x67073ca7,0x03176d3d,0xbc41552f,0xed5b9d4d,0xbff76cd9,
	0xa2715c55,0x708bf8ab,0xf2e129d5,0xfc11e87b,0x20c58aa7,0x72a5b01d,0x64499b5f,0xaf2bacff,
	0x5abde335,0x7e9dd05d,0xa8138f6b,0x8dcbf5dd,0x92efbf3d,0x25a9cec5,0xe329083f,0x3e19c997,
	0xcad7db4b,0xef29de3d,0x21d9f1e9,0xc8e9a6b5,0xbbd96c35,0x19a3ac31,0x20dbc743,0xaab350c7,
	0x70415413,0xfbc53d97,0xb65156ed,0x849bbd6b,0x7c43774b,0x0563ebeb,0xdac3a849,0x6d6d213f,
	0xd6fb3187,0x607d8233,0x521f008d,0xe2971ceb,0x536feab9,0x323b79fd,0xf4c107ab,0x59350a23,
	0xb98bcc1f,0x7be7585f,0x98670d63,0x6f0b689f,0x7f219539,0x9bfb2af3,0x99396e3f,0xbb816b21,
	0x20ef90d5,0x6f1524e1,0x02c9188d,0x40a9a473,0x1b99aa07,0x10f95bd3,0x590d3163,0x7c41d463,
	0x84aba127,0x3d95a503,0x0165d9a1,0x18a7d4cd,0x439960d9,0x5203922b,0x4b9d12ef,0x3de7a691,
	0xeac17309,0xed7f8e91,0x1ae1c4bb,0x82b39e97,0x306595eb,0x326f1c03,0x2ecbe13d,0x7d65b2d5,
	0x07b370f9,0xa7612fd5,0x0c5daa75,0xf501e73f,0x59bd69f7,0xb80bafe5,0x86fd1729,0xb22fdad9,
	0x5e8199f1,0xd64d0f99,0xe97b57e7,0xf04174ad,0x95e3e239,0x3b2b0cdb,0xbf0f7c0b,0x6e35b0c9,
	0x60af2169,0x47d78d25,0x3c5d36af,0x1fa98d49,0x399b8867,0x86a39a6f,0x4869c3bd,0x7de9174f,
	0x8e410f5d,0x4c0f8043,0x25a5ece3,0x78e79801,0x38250abd,0xf7c108ad,0xbae92e99,0x083de191,
	0x95b5e045,0xd587d941,0x7c75fd1f,0x5c2dbc3b,0x4343dbf7,0x9e59f01b,0xf4f1297b,0xaea3733d,
	0x740f251d,0x995540e5,0xee6f667b,0xb43181e3,0xeb39d34b,0x5cbd71c7,0x3b65edbb,0xad0f607d,
	0x94cf235d,0x2f05b879,0x1fb54495,0x16217163,0xbec7cc75,0x07c1d739,0x59a72133,0xf9ef0df9,
	0xf1fb7501,0x30ad39cb,0xcaeb6f83,0xe1afb3a5,0x6b2f47b1,0x86b3327b,0xc197763d,0x663950db,
	0x3411a881,0x5add5721,0xe12f1be1,0x6111b213,0xdc3509b5,0xf367fe17,0xab994bb5,0xbd5f0ecf,
	0xd215e0d9,0xaca9db45,0xaa277ac9,0xe8f5b697,0x5c19bbbf,0xba2fbd17,0x368f4cf3,0xe54fddfd,
	0x31897581,0x87a36983,0xe3f159d3,0xf88f8b9b,0xb39d8b85,0xb9dd9b07,0x87d911d1,0xfe7fa50f,
	0xc66f9275,0xcfdb1da5,0xe333c31b,0x598f1c07,0x4a05cb45,0x63c30bed,0xeb59beab,0x83dd3b31,
	0x3349d82d,0x0be32bf5,0xb30d9d3b,0x402b1349,0x450f91b5,0xdbb16c57,0xf373a457,0x6adf080d,
	0x6917fba5,0x84cd813b,0x351f4b4d,0x6b117d47,0xa9035a11,0x17fda14d,0x9909e033,0x4377a3c9,
	0xc75d6657,0x662f62c3,0x418f4ceb,0x4373666d,0x789da415,0x0177b859,0x5b7bfc19,0x58137713,
	0x3c1fd639,0xde150e55,0xc6fdde2d,0xfd077ba5,0xd52393f7,0x93718785,0x60ad8e5f,0xcda95b15,
	0x63d9fdcb,0x3d155a3d,0xea8b97af,0xb5fbaa59,0x1e559275,0xfbbb4d5b,0x9501d9e3,0xc3a73977,
	0xa9932403,0x16415545,0x27dd0e8b,0x9703c073,0x1277ecc7,0xbaab50e7,0xcb576dfd,0x7403ac63,
	0x66cdc45b,0x5f29e6b5,0x71117459,0xf34f0c5d,0xee4974a5,0xc31181af,0xdd13c687,0x532f9e83,
	0x03872ecf,0x8fdf6e59,0x4ecb3737,0x6893fd01,0x8d0d204d,0x9a3d17c1,0xca15ebdd,0x3019eb03,
	0x164727d9,0xc2f7647b,0x002da1bb,0xff01c1c7,0x8887aa75,0x780533a5,0xd8c112d7,0x5437fd8d,
	0x840b8871,0xd581f9e3,0x9adb7b01,0x494bea9d,0x58f7325b,0x66b77e65,0xb5f73ccf,0xa3777249,
	0xa057de11,0x8711b7dd,0x2af3a6a1,0x84a107e9,0x751fdbb7,0x6327c98b,0x951bd79f,0xbc51b5e1,
	0x4d2b0ab5,0x99b72033,0xd31bc4b9,0xb8b74a97,0x72416ec1,0x7ca9af21,0x500d5da3,0x17b1a57f,
	0x1b0de4d7,0xf2074d2d,0xec73d1df,0xd7bf2411,0x2421f837,0xf50b31b1,0x8731f5b3,0x290b2ecf,
	0x68fbd76f,0xb7119197,0x269dc72f,0xde69e641,0xbcff694f,0x60a15c47,0xc1691329,0x7e53effb,
	0x847b81f7,0x726918b9,0xa7b93a43,0xf3e96391,0xed9f37c7,0xc63de26b,0x8c1515e1,0xdff9d7a9,
	0xc98b586b,0x301f865f,0x2c6dfd33,0x89f18eeb,0x0541fdd7,0xbf33c025,0x9b19ea31,0x70efc507,
	0xc2ad4345,0x9ec596d3,0x27d9be9b,0x7cb31bb9,0x11a71a39,0x9751da03,0xe8d7a8f7,0xcea727bf,
	0x48e73f7d,0x2f6fbedd,0xe39fa995,0x32df1de3,0xff135025,0x6ceb9d0d,0xd62f378d,0x31139ff9,
	0xa3b9fe8d,0x35afcbc9,0x9fe305bb,0xbda9a9d7,0xb8496759,0x50d39ecf,0x4a83e7c9,0x8aa79e5f,
	0xa9238673,0x07958361,0xb343d727,0xf8c1747b,0x4689cc0d,0x665b3d4f,0xd3b71809,0xa853041d,
	0xdda9d1a3,0x1db343ed,0xaae37e71,0xaa5d733b,0xf1972efb,0x03553f1b,0xc62dd325,0x5189c2db,
	0x944d6f1b,0x331da439,0x6a6558b5,0xa32b7c03,0x5fb3255b,0xd0117339,0x5cc57077,0x683b7cc3,
	0x0e912255,0x6563138f,0x4bed5f8d,0xde5fe539,0xb59fc8eb,0xe7655137,0xd8e333db,0x08dd2481,
	0x9c778349,0x549979b7,0x401bc911,0xa1a925c9,0xb69d57e3,0xf6a1991d,0xa269eda9,0xaa5d9d3d,
	0xbc7f9e73,0x434fd6fd,0xee0fa7df,0x9d3d751b,0xe471d4fd,0x5d97f375,0x67b79abb,0x3e315aa3,
	0x3baf94cb,0x3697e429,0xd36f8b0d,0x0bcd6b1d,0x9f5ba773,0x4e979149,0x3daf046b,0x504900db,
	0x55853bcd,0x1605b289,0x645b1e37,0xd289a037,0x461f3aff,0xee77cc25,0xbfb76095,0x27190491,
	0xd405bd71,0xcbab4be1,0x2b73c977,0xa1274d51,0x55fd9fd9,0x7487c60f,0x2fabf191,0xe38f4aeb,
	0x2fb13833,0x64195281,0xe9dd5165,0x11d5ebd9,0x8ab72abf,0x4a970995,0x95f3a639,0xa121c999,
	0xaf895f0b,0x2e61a12f,0xb739771d,0xc945d5b5,0xfe8f14e9,0x2cfd29bd,0xe16db9e9,0x95bf26bf,
	0x89131975,0xdc17eb37,0x21ab9839,0x96ade551,0x4a491c11,0x4a876215,0x077b5477,0x31db590b,
	0x004d2369,0xa14b5c61,0x4dd14ed3,0x93bb1597,0xa5252271,0x648b36a5,0x24012a41,0x406747a5,
	0x87bbad63,0x549138f9,0x16cf1183,0x44a321f1,0x04e5cec3,0xeed713f9,0x99611c21,0x06d76a39,
	0xe05ffc5d,0x8ef97dc9,0x2e47d367,0xb8152649,0x3dcd2c41,0x2fbfef17,0x307bd76d,0x651968ef,
	0x39bb09cd,0xcc178019,0x3c5da415,0xa7453f09,0x229d4aa5,0x6015e58b,0x38b37603,0xf5a3bc73,
	0x51d123b3,0x89fb8db5,0xffaf4fa7,0x95e52919,0xa499de29,0xcb2ddd61,0xa7e91e3b,0x2d654ded,
	0x95218c85,0x69398ce5,0x6d63febb,0xf227e1e7,0xf37fdf87,0xeed52521,0x3a81a2ef,0x7bd31707,
	0x3eaf1b3d,0x4ce19c77,0xd117d667,0x34bb4759,0x9d952bf9,0x9b6113d5,0x935d237b,0x6adbc1ed,
	0x77ffdb57,0x7a85b3af,0xecf19847,0x00d5b7db,0xaf9d2539,0x13a3a907,0x5bddabb7,0xbef34947,
	0x790daccd,0xba39425d,0x19914275,0x4427b259,0xd4d75181,0x2ced2cc1,0x63e5d3fd,0x970b983f,
	0xa861e415,0x768dd0c7,0x6619af8b,0x56e17639,0x7705fb8b,0x6f11cf8d,0xc1d56127,0x8c952a81,
	0xbafbea2f,0xdc959fb9,0xb82b36a1,0x1bb7a367,0xde69d293,0x34614a77,0xf291e491,0xd383ac37,
	0xd45bdc91,0xfbe1487b,0xebe94b53,0x1fdbda4b,0x51c78a4f,0xc9af7f05,0xf9795c13,0x5a499a07,
	0xa6872d35,0xe6855cd9,0xf3f51dbb,0xbafd5bd3,0x365f7afb,0x8e4d1745,0x8071d207,0xe9d5e11f,
	0x91fd4297,0xd111071d,0xf9713a73,0x2f53a967,0x2ff34151,0x140b25bf,0xf7dbfd47,0x459d7f29,
	0xc5bf17b1,0x3299aa0f,0x7bff2a93,0xc98b24ef,0x40c75e8b,0x3f3fc57d,0xb697e12f,0x4b91224d,
	0x5f53dbfb,0xe4ad80fb,0x71c313b9,0x00d7b0d9,0xe99bd863,0x66b9ba09,0x1a096d97,0x1425c935,
	0x8ab99371,0x43613fab,0x675b57fb,0x96eb500b,0x49b1d915,0x73cb0f6d,0xa6111ed9,0x1247630d,
	0xa271b68b,0x4d45b267,0x9fed35f3,0xb7f9c5f1,0x3ecd4f57,0x0245ba35,0x25139dd1,0x336d6f7d,
	0x4f7fd243,0xc36b5dfb,0x351768bf,0x1ab33675,0x852f8e65,0x807d3767,0xc7f15fd5,0xff879eaf,
	0xa9652815,0x49671fb1,0x36ffc7f5,0x204bc601,0xd799edf9,0x4f412c91,0x460b46c3,0xb907714f,
	0x56254dfb,0x8549cd51,0xcc45e7b1,0xf471397f,0x0f4f6a4d,0xe1e707bb,0xfd4340f5,0x7ce1d885,
	0xaa41ce6d,0x3fa5d527,0x5209b88d,0xad599659,0x4411441d,0xde3d9f6f,0x11ffe941,0x6283d5fb,
	0xc8bbc867,0x838bddfb,0x7bf127a3,0x6bb3c277,0xec21a09f,0x3c97d2b7,0x8f1b2705,0x9be31bdd,
	0xc3138f61,0xbe8f6719,0x741dbe8b,0x7ab32447,0xfc43298f,0x67c9291d,0x85ffce19,0x9571acd5,
	0xb94d4b57,0xe0c1684b,0xfb2f4361,0x700b42af,0x07b7ad29,0x5d2172ad,0x2e893ed9,0x161f7c0b,
	0xf9eb98c1,0x7cb5f1d9,0x884958bf,0x4bed651d,0x603fbe23,0xcc7367ed,0x071b061b,0x5f5f0d29,
	0x21ef289b,0xe77bcc8f,0x690f1dbd,0x99093377,0x361f53b9,0x381149eb,0xf4997d3d,0x4d251459,
	0x3cdb605d,0x58a719b7,0xe19fcdf9,0x8c935629,0xb81769a7,0x14cf822f,0x62656a17,0x75e11647,
	0xe4affa03,0x0a49f319,0x4c9d6189,0x263d161d,0x3369a023,0xe9fb42c3,0x625f9f05,0x4a85081b,
	0x61efa405,0x58f30b01,0x3b2d2d09,0x5039fcbd,0x33d9dbeb,0x71692631,0xcceb9add,0x3683ef81,
	0xcb9fa15f,0xe3b94c39,0x94ed8193,0xff3773f3,0xa3a7e635,0xb76bcf83,0x60eb28fd,0xbfcd82a1,
	0x273d6989,0xac2b7a09,0xb8034cbf,0x526b6627,0xeb950cbd,0x3ad38a45,0xe3bf013f,0xa6d7c827,
	0x88cb487f,0x365dd03d,0x990fb8a9,0xb385de47,0x12e5c1bf,0x0cf3ea7d,0x414967f9,0x0691b73b,
	0x32cffeb9,0xa8dfa31d,0xe331cbeb,0xf6b9a7b9,0xdf5b3bf1,0xf19b6cb9,0xabefce09,0x746dd787,
	0xb6476133,0xecc5ff75,0x180f099f,0x7ab9ee6b,0xf5391691,0x7f211601,0xbc8d70c7,0x205de135,
	0x12b9f965,0xcd9f4a8f,0xafc9115f,0x48b7dec3,0xf73df155,0x3e5513df,0x928bfa0d,0xf4d35cf3,
	0xd623a54b,0x1981e235,0x39013f43,0x346345ad,0xa6ad107b,0xca895c5d,0xf3c52037,0xb6c343e5,
	0x3d09375f,0xc0fbbcaf,0x78d94be7,0xfbf33093,0x0349fcb9,0xf18d4e05,0x6ca3461b,0x259d9fb9,
	0x526d1699,0xf71f08c7,0x8af3ec65,0x68138d5f,0x6b55234d,0xd3b74fe3,0x70031b19,0x1b532a97,
	0x0fcfde73,0x5181cdcb,0x01717255,0x6bfbca7b,0xbb9175ed,0x03d7717d,0x77493b05,0xac57ef2b,
	0x7d35fee9,0xe8338b81,0x04f76bd5,0x455976cf,0x6f3f0ad7,0xa73d0ae1,0x2255ce3d,0x479be89d,
	0xd11d5c73,0x75c5da33,0x74a3437b,0x9c61e1c9,0xc023bcc3,0x95bf5c97,0x578b2997,0xd693a297,
	0x908bf00d,0x77490aaf,0x061be063,0xa3c5bb4f,0xc67bcae9,0x79ab2fa9,0x63cb6e73,0xdd2fd945,
	0xaf016731,0x4c53c639,0x657d4625,0x38b5b3cf,0x990f7907,0xefd575a1,0x1a792aa5,0x99e1194f,
	0xae81c3d7,0x56f3aea1,0x556f34df,0x02e51c2f,0x6d1baf53,0xa791e889,0xf575f88b,0x259b5fdf,
	0xbf8bfc79,0x1bbdfe2d,0xcf0fc927,0x948785db,0xb6659a8b,0x82adaaeb,0x35251efd,0x93cfbaa1,
	0xe1259c13,0x61c127a9,0x22031c19,0x8a4b62bd,0x472d4be7,0xb57de7d3,0x00653155,0x1271e7bf,
	0x00cd621f,0x5291765d,0x146be34f,0xab65a53f,0x7037591f,0xe6d372c9,0x849daf6d,0x09f1f5df,
	0x1a87e295,0x9a41ae17,0x02e910e1,0x0987604b,0x20c37c71,0x500367d5,0x15a9a5a1,0x3d41e431,
	0x58d525f1,0x8763ab1b,0x009f736b,0x20e1674b,0x06933495,0xdcdbcb85,0x4df14cc9,0xe9d34259,
	0x34b9492b,0x2b070239,0xf72f5607,0xf829ee27,0xade964c5,0x4baf2ae1,0x2e53aa3f,0xe79bd085,
	0x95b31dbd,0x78bfa0b7,0xc6bb204f,0x408d294d,0xa189f4b9,0x4d513b75,0x3e312fdf,0xc9071f5d,
	0xf1c7c9a3,0x669f6c5f,0x65e5f65d,0x75bfeda3,0x8ab370af,0xa5137b47,0xab715c01,0xfb0d300d,
	0x6d796757,0x0d37e37f,0x01d158c9,0xfdf35095,0x512ba95f,0x48c7d0e3,0x6a6f597f,0xe51d143d,
	0xfbc7a5d1,0xc79bbcdd,0x1e1dc4af,0x49dd480d,0x3b315403,0x80bd2b55,0x56139fb3,0x09298e19,
	0x7e35688d,0x535b87c3,0xb4ef53a9,0xf4a94a75,0x0d87aa55,0x07cb2225,0x4fb99279,0x23a5b047,
	0xe4c36783,0xf08b4bff,0x56e55bd1,0xe40feeb7,0x2b6f0a8d,0x2b41955d,0x5f492227,0x4b817df7,
	0x4df7cf2f,0x81bb29d5,0x4b250fbf,0x683d8c3d,0xb6ad9769,0xeaf14d87,0xd3216b9d,0x122f8acd,
	0x26cfe089,0xabfffa15,0xaf4d1e8f,0x5be7daf1,0xaf81d821,0x192b9bad,0x6025582f,0xa3a19af7,
	0x4acf910d,0xf6e7ee05,0x978353db,0x443d933b,0x14af586f,0x7ac5f959,0x41b53dbb,0xe649431f,
	0x23f92ab3,0xec852f71,0x2e6737bd,0x70f50e09,0x0375488d,0xe70fa897,0x59b57e99,0x9b19886d,
	0xcacfebf7,0x396d80a1,0xd51baecd,0x1c3be4c1,0xd79b1d35,0x67d953ef,0x508529a3,0x7d85808b,
	0x2653a7d1,0xccb1dc61,0x43419a27,0x8ac79151,0x4b5d2fa1,0x5979ae69,0xb5099a33,0x637df1a3,
	0x0c0565bd,0xf7df15fb,0xa6fb7765,0x2bc70e1f,0x97815d8b,0x8abd1393,0x1ca11825,0x5d73f261,
	0x5feb01b3,0x8f0f7937,0xc4eb00a1,0xb8f17617,0x9347a92d,0x5cfb2775,0x433177d1,0xd65989ef,
	0x3483cc2f,0x08cf6a61,0x1835cc73,0x5671a4a3,0xd471d93f,0xe401769b,0x2b1bba11,0xb3a34ff3,
	0xead12a29,0x9e310643,0xf277edf9,0xb2ffd5ad,0xcf4318ff,0x0623160b,0x3d3fac41,0x753f0c9d,
	0x5255351d,0x6ac7c225,0x9bd594c9,0x27c9459d,0xf67d9825,0x9c334351,0x69018837,0x55a35891,
	0xc9155b05,0x8ca70bd3,0x72f3acfd,0xd883d161,0xdb632aeb,0x91850479,0x44439451,0x69bf3cfd,
	0x5b91fe59,0x445de997,0x0cef7f33,0xd35d965f,0x4db3ea0d,0x03e7c80b,0x2b65c369,0xc107d389,
	0xe4c91613,0x14ff9a39,0x556f5081,0x310d9285,0x7bb3d2c1,0x63ad0511,0x614954d5,0x8569e661,
	0x2e41cdaf,0xe41f3505,0xae930283,0x34c14439,0x122566c3,0x93a9db15,0x2f537473,0x1b5b902d,
	0x0ffb2525,0x19cb49c3,0x10fdb353,0x6c2b4a67,0x5c474c4d,0x092db221,0x0565da9b,0x41cddc19,
	0x907990f1,0xc09b80c1,0x2bcd5d8b,0xcf810479,0x63e1ee19,0xec0bdabf,0x99df6c29,0x323165cd,
	0x04bb9a0d,0xa59d3ac3,0x84a97843,0xe1713259,0x112f1b61,0x36952dfb,0x09a5da73,0xc079f973,
	0x30477df1,0x78633119,0x97b19717,0xcf2f9471,0x4af7a7df,0xd59dad5b,0xf8194357,0x7b1933b7,
	0x651bce97,0xeb011589,0xf7890a21,0x906b8bab,0x16790bcd,0xc87522ed,0xaf1bd12d,0xcb0121c1,
	0xa3bb127b,0xd207325d,0x6d4f7dfb,0x0759b96f,0xb77703e5,0x40edc139,0x3f0d5ad1,0x13a3e13b,
	0xbb296497,0x44890a63,0x18a79bbd,0x20ab9fab,0xd0353161,0xc35bc349,0x9ed3039b,0xd2f14051,
	0x68e71463,0xbc17f8e1,0x8fb3a905,0xf39340c5,0x8173b9fd,0x468f0ca7,0xcbcfdb65,0xc15d5dab,
	0x78f545d9,0x34c3d1a1,0xff1727e9,0xe1c1bfab,0x8a73e7ef,0x53dbc95d,0xe9e17e89,0xf1db4875,
	0xe5d99177,0x4d2180f1,0x49f17703,0xb769ffc3,0x68f9c9f3,0x270f0df7,0x636db5e1,0xf1d9a057,
	0xf891a431,0x6643ab95,0x29e77171,0xcb3d44f9,0x7945d343,0xce81777b,0x095516c9,0xe94d357b,
	0x68a1df85,0xc3b94edd,0x4f190ec9,0x1e6dd3b7,0x16197b9b,0x4affcb77,0x32f9a319,0xbaa7a88d,
	0x7c0bf96d,0xab95608f,0x80270327,0x7caf90e7,0xb8b9df31,0xafdf97f3,0xde3d692b,0x22db0ab5,
	0x274f9c61,0x866b6ef7,0xba375f25,0x9c2fa1f3,0x18e55ec1,0x42efd379,0xcf8123db,0xd9577d9f,
	0x2d73075d,0xff4b40dd,0x50e92fdd,0x3da50cc3,0x4cdf3f85,0x9c837d13,0xb1a9da81,0xb011d373,
	0x3ff5add9,0x23c9758f,0x0e5f1ee7,0x4c3f57c5,0xe96b4b39,0xc76f3c4b,0x361580f7,0xb3792edb,
	0x1ed9d7d1,0x83f524d1,0x533b125f,0xfdb129df,0x21c97013,0x6101012d,0x34a99797,0x4a81a303,
	0xb8a141bd,0x52617ef3,0x369fccdf,0xf22dea7d,0xe7bb60cf,0xb90da43f,0xcbc7cb3d,0x569dd393,
	0x4a4fbc97,0x84236cbb,0xa62d8d81,0x5463618b,0x0b8534a9,0xf1e5868f,0x804f9541,0x53bb94b5,
	0x7f65cddd,0xf0c72f73,0x8609afdd,0xf987576f,0x5be70757,0x205d31a5,0x5da3db7d,0x78518b15,
	0x91e34f83,0x726300e9,0xd0d14c0f,0x814b3515,0xc6239915,0x6bc3f78b,0x15a9904b,0xd54fcbdd,
	0x6a4f1009,0x0589b363,0xb7a9d6b1,0x75dfa3e7,0x75fbee9f,0x2deb92cb,0x20bd5287,0x76277cb3,
	0xbfa77265,0xe94751ab,0xc235c0dd,0x6bf92dcd,0xf5b3f12b,0x1327c66f,0xddc70d89,0x80cd73c5,
	0x376f0e11,0xbf35bf0d,0xee95182b,0x22c5dd35,0x4e0d0e77,0x3a49fe03,0xb225992b,0x55afd7bd,
	0x85a94f09,0xab615753,0xd16926b7,0xa3fbdd07,0x2647d8b9,0x54a3ed8d,0x29b959c9,0xafc3bfc3,
	0x8cd515c5,0x745d8ec7,0xb5d7131b,0x63c918ab,0xe427a6af,0xc605319b,0x16e9e039,0xc479d381,
	0x7df95741,0xa33d9231,0xbd7f8071,0x60e3dc0d,0xcbed338f,0xc4c5ef35,0xb29189d9,0x63c3eb23,
	0xf893bcf5,0xa391e6dd,0x00832e53,0x447b7399,0x205d3f17,0x79b373e5,0xbc192083,0x1815af51,
	0x2aa744dd,0xe36b0a93,0xad8598d9,0x8241cc35,0x42b72d7d,0x2021d5b5,0x995f7a8d,0x465d3935,
	0xf0b7e171,0xf35f139f,0x29a7989f,0x7869134d,0xd2bda77f,0x25df932f,0x76c51ad5,0x4e11b27b,
	0xf5c519ad,0xa67f50cb,0x308b02bf,0x8fa556cb,0xceb33a53,0x4b43335f,0x672fd0b3,0xa921f54b,
	0xd353a90b,0x325be95f,0xf45348d1,0x5b272517,0xb359f7b7,0xc31de5cb,0x83ff5803,0x0bff2c51,
	0x31611f83,0x4f057d27,0x3da118f3,0xb89f2d1f,0x9bf115e1,0x52bd2281,0x0d15f91b,0x859f72b5,
	0xe673818f,0x5711c46d,0x8b99fdbb,0xf041de4b,0x623d8f8f,0x71f94a09,0x88d528d9,0x9f6f7421,
	0x178be82b,0x678f2ff9,0x33d9fe45,0xd4bd0883,0xbe81c3f9,0x6b1f456d,0xe41f2895,0x7d650cc1,
	0x582b20d1,0x80138917,0x82873e29,0xe3497c33,0x677f16d7,0x7b032637,0x9257a62b,0xfdf1e93d,
	0xca554d79,0xa2ad918f,0xda419d85,0x6393aa47,0x32759067,0xf0f9c671,0xad5f5bf1,0xda0526c1,
	0x3e8b849d,0xf3f1a3af,0xd42d58ef,0x87cd4425,0x33297d5f,0x4ecf68a5,0x1597b0c5,0xc515f2f5,
	0x53cd7139,0xdaef523b,0x5feba983,0x8caddbb9,0xdbdb0efd,0x68d957df,0x91e157ff,0x8d0f2c03,
	0x979ff2c7,0x213b0883,0xe39d64db,0xd961836d,0x1d4ffaf9,0x85e987a5,0xefa3f17b,0x3a690097,
	0xa603bd3f,0x12e5aa4d,0x5be59d0f,0x1f9d6e2b,0x86c51b8d,0x7f533405,0x22bba991,0x30138fd9,
	0x497bf91b,0x9e7f33e5,0x7be540bb,0x7b918f5b,0x65ff0f71,0xe0e58187,0x658bd91b,0x4b7f8973,
	0x9b09e359,0x751d5a13,0xcd3fbaf9,0x93f13aeb,0xe73fd9e3,0x08f31d35,0x58f7a573,0x04a1cd91,
	0x222f6d6d,0x2a512a23,0xd0159363,0xb9efc541,0x3549829b,0x484fdc9b,0x2461a073,0x8de90cdd,
	0xf4eddd55,0x542ba9df,0x1b090e13,0x093d234b,0x995db5d1,0x024b5dbf,0x95a96877,0xf447687d,
	0xd7c76d8b,0xab3d778f,0x7b3dcba1,0x880b8a6f,0x9b3f6443,0xccb9a72d,0x41314857,0x3f31121f,
	0x5dbfed07,0x2a9b69ff,0x14556929,0x470d1099,0x212f6329,0x8fe9c7f1,0xa1dfd76f,0x9099ebed,
	0x08575f45,0x2fd53079,0x806f2045,0x81754c33,0x8fef0c3d,0xa6b17793,0x39119995,0x44ed288f,
	0x67919c3d,0x9afff2c5,0xf031670f,0xbcf3f427,0xeac1ddb9,0xfe61b61d,0xaea99f27,0x1323eb2f,
	0x39edf06b,0xeea9f12f,0x4ab9901f,0xe9bd7fdf,0xf3691a57,0x36cb6c19,0xf10b24fd,0x2cabe777,
	0x8c71bcc7,0x6fe5247f,0x4dad6a91,0x827fc745,0x4a27694f,0xc23f0a91,0x55193473,0x5d770195,
	0xda9b16cd,0x4647de03,0xad2de1ff,0xac71a2c1,0x8dbf765f,0x05932b0f,0xb633435f,0x2bf9ee2d,
	0x2e6f6875,0x9be1677f,0x33db9e83,0x57418b41,0x7b6f91bf,0x78172f9f,0x963dd41f,0xf925d26d,
	0x406f103b,0xbd43a343,0xe2d9a4b5,0x5d233a2b,0x0efd5029,0xc39be2c9,0x3d97158b,0x2069e3fd,
	0x979b0117,0x397fac15,0x11c9f5b1,0xa2c9496b,0xa2ab2ad7,0xe4751795,0xdb2582ff,0x17bb0909,
	0xa9796285,0x02297541,0x8ecd2f11,0x3763d36b,0x0f391f83,0x49734991,0xa4478451,0x8f8b7837,
	0xfa07307d,0x8b516a8f,0xbe872aef,0x74a51315,0xcbe95067,0xf3eb3cc5,0xf4e30ddf,0x92cd58b7,
	0x3bc9db7b,0xeb8b104b,0xbc199fe3,0x1ec103d3,0x0e7da43d,0x97ab9dbb,0x6f554083,0xa6ef622f,
	0x6fc1e877,0xfbe7a33f,0x7927c10b,0x8469018f,0xeb39663f,0xbb07a17f,0x1c830993,0xebe77cc9,
	0x057190ed,0x77f9b8b3,0xddcfddfd,0x9ecd68b3,0x74dde627,0xd6d1a597,0x8bcfc2ed,0x3c25612f,
	0xfad962d5,0x1dd1de73,0xe8b502d5,0x31a13629,0xdcab182f,0x765dd011,0xf31bd2e9,0x4c9b388d,
	0xfc7fe0ab,0xce033ac7,0xcefd982b,0xeb15a759,0x92673511,0x5779af75,0x4ec74c61,0xccbb3c8d,
	0x85612169,0xab9f2c7d,0x1c47031b,0x83ddda2f,0x64515a07,0x8a79dacd,0x81b58eb1,0x86795755,
	0xff037087,0x3c37ead9,0xd2b34541,0xdf2b6d17,0x9f2d28cb,0x922f91a3,0x7549e5b1,0x7e43c393,
	0xe167edff,0x87df25ab,0x8ae79cb1,0x2ab11ef7,0x2e396797,0x83ed5c01,0x396529bb,0x130fac71,
	0xd30f2e4d,0x3927a539,0x9403240b,0xfea16f3b,0xbb3ba125,0x2785aa71,0x24695fa9,0x1e4dcd97,
	0xc8fdda6b,0xbd23ea4f,0x13a97265,0x7dab3dcd,0xce75c4af,0x174975ff,0xf33958d7,0x13f1132f,
	0x26b14fd1,0x6363ce35,0x25fb3b5d,0x75016b17,0xeea5c5ef,0xe00be031,0xe937531d,0x226939e5,
	0xde2f4079,0x7dfb22b7,0xfd9bef07,0x7c597803,0xc1133d1f,0x211dd315,0xf04398d5,0x52ab6ee1,
	0x8ff952df,0x817b521f,0x03ab5a03,0x15e125f9,0x297b06fb,0xac4fa133,0xb8bf20d9,0xa827efcd,
	0xab11c1fd,0x24f7ff35,0xf7cf4569,0xce4d16e7,0x6a23e4b9,0xa5f7a595,0xd98f2e85,0x40cfaad5,
	0x8cf9fd4b,0x81ffa545,0x102516d1,0x5ccf6d33,0x43cb1c15,0xa4e5e3c5,0xf015f1b1,0x7515dea1,
	0xa1b348c3,0x34a73819,0x19517057,0xc3176bc9,0x15b51749,0xd26ba7cd,0xc03326b7,0xf7edba5d,
	0x83bf5ce1,0x7b7fc3f9,0x9677d095,0x6d591615,0xfda5050f,0x0a592639,0x5449b673,0xf6c7fdb1,
	0x1c21069f,0x57990db1,0xe13532a3,0x5247cffd,0xf7db78a3,0xfb051c0f,0x1d39563d,0x399598c7,
	0xc25bc775,0xac893289,0x49b1ae1d,0x1311fded,0xff1909bb,0x453d6edd,0x126727ef,0x42c94c4b,
	0x5c6f755f,0x605f484f,0x368b171d,0x1b6ba4cd,0x2ca3f493,0x9c57ccab,0xd1b559e3,0x6f554965,
	0x7edfdad5,0x7baffd47,0x44e59e3d,0xc1870a0b,0xd839b9e5,0xe6214c03,0xbf83c6f5,0x16add1c1,
	0x8cab56d1,0x49893841,0x68617097,0x6617538f,0xb81dbeed,0x5aef0bef,0x26b5967b,0xaabfd787,
	0xd7597cd1,0x7781b883,0x0b2157c3,0x944b27c1,0x0113ed61,0xa595d3f9,0x58abdc53,0xd8019d61,
	0xbee7b4c9,0x35a7b5d9,0x2dc759dd,0x21d74d8f,0x865b537d,0x0361b42d,0xcd4938d7,0xa565567b,
	0xd1d9db39,0x568f808b,0x8775597f,0x4eed4c5f,0xd9b7c3fd,0x6427a511,0x42f178dd,0x9459c67d,
	0xed31e115,0x6f492165,0xa5cdb5c3,0xe63d0c1d,0x6b6b7617,0x8a3927b3,0xde8335c3,0xc0d1e193,
	0x5c6f6bdd,0xf769f9b1,0x0cf1ea41,0x5cfb7533,0xaa35a587,0x2a6be59b,0x4b617561,0x01416c65,
	0xf9997585,0x68ff6337,0x57852f15,0xf2d9108b,0x235d3289,0x0c0b50d3,0xdb714a13,0x06999c1d,
	0x4d2dec8d,0x609d5043,0x56a718d9,0xd207a78f,0xa29f41d3,0x28ed43e5,0xa71172b1,0x7c4bb667,
	0xae2f53e9,0xbd57eb9f,0x31fd38a7,0x2f39e429,0x5241dca3,0xcd63a1db,0xad23fa95,0x284bb16b,
	0x62216319,0xc0bd3893,0x87a5bc17,0x69a1f0c3,0xdb0590af,0xb83ff641,0xf30bd999,0x0b07d3d3,
	0xbd05a611,0x2ee3b2eb,0x8c450d47,0x2af11845,0x84291035,0x3ad3151d,0xa4ab9417,0x7f7554cb,
	0x415d1d51,0x6e59eeef,0x2afd72cd,0x8759661d,0x5373d1eb,0x58efbafd,0x3463daeb,0x5b05fbfb,
	0xc029ddcf,0xa833396b,0x256dafc3,0x1d8d4631,0x2d23b10d,0xe8e92ce9,0x7b172b6d,0x0da9c18f,
	0x78efb105,0xe80137a9,0x33bba3c7,0x36bf24ed,0xf3fd8d57,0xb391d86b,0xd8276f77,0xc1d56e2f,
	0x39adb4ef,0x3bd78771,0x2487eaef,0xe69f0f3b,0xa941eaff,0x9439f38d,0x51779d65,0x7c773b05,
	0x7ee7fc05,0xd4455f11,0xfcf37dd7,0x2b615285,0x8cb192c3,0x98b11cd9,0xb367580f,0x3d0571bd,
	0x939d2d43,0x245d2d4d,0x18a35199,0x0db71cb5,0x3c9131db,0x214ffb5b,0xb0db8ecf,0x1d6f0c7f,
	0xb1552423,0x01b33975,0x49b5f7cf,0xc0d11c35,0xd5a1f9ff,0x00e3de99,0x03351d7f,0x722755f7,
	0x200d909d,0xc459434f,0xf8cd3e91,0xc2651fef,0x1323416d,0x9cbd5ea1,0x8a556c7b,0xea21894d,
	0x564b972b,0x66df2325,0x450dd07b,0xfa9fb74b,0x6ed922db,0x0cb3fbfb,0x6c9f109b,0xaecb722b,
	0x190d70c9,0xa65769c3,0x2419d4a7,0xdc37d237,0x41071d87,0x3b13bfb1,0x36f36b39,0x841b0cbd,
	0x9bd70aef,0x22550073,0x820f8eaf,0x845b6119,0xe06db527,0x04b1db4d,0xfcb54a2f,0xe88125ab,
	0xa0a9a79b,0x7ce9c8ff,0x6195feab,0xdabff4dd,0xc24f11f9,0x58e148d9,0x77c787d9,0x34f1fa21,
	0x98097d41,0x7aa73daf,0xfbcb8137,0xb1955eed,0x9a6da0b5,0x59716adf,0x2889ab0f,0xbcd9d7c7,
	0xc0f556df,0x229f114f,0xe0516f6d,0xe58d5135,0x7b09b293,0x7ab5ac6b,0x75df872b,0xee2fbcc7,
	0x48f333ef,0xde63cf27,0x154dbee7,0x7dddfe19,0xf4e71d51,0xa37f2103,0xcd29dc07,0x7161f7cd,
	0x6c01e869,0x9a077b05,0x375fa1bd,0xcc31b889,0x3745db27,0x4d2324b5,0xc24bf5ff,0x4967c801,
	0x94a3bcc7,0xe41d312d,0x99a9268d,0x8cc193ed,0x2febaacf,0xa36ffc09,0x2fa54deb,0xf3adfd0f,
	0x7bd90e05,0x0db5c66f,0x65cdd86d,0x063b042d,0xab15af81,0xa4b77409,0x561b2925,0x8827971d,
	0x4929ed9d,0x4a616811,0xbbed5ef7,0x29d37db7,0x738910fb,0x41cd823f,0xfd0f3989,0xd94966db,
	0xb291c187,0xd0353bdd,0xd2ad1e49,0xb33b1571,0x72879b75,0x7e03e4b7,0x92613d6f,0x9403ad6d,
	0x1c95e43f,0xf7c10021,0x172bd6f9,0x48a320c9,0xcfd35fa9,0x8f2bc1f7,0x4a759fb1,0x5fc7bc81,
	0xba3944bd,0x5c19aba3,0x4d0b4623,0x9abfd5a5,0x11ab52cf,0xfd95490d,0x402b17a9,0xfe879641,
	0xacf9067d,0xfacd0dad,0xae71c561,0x84c1ea71,0x3cd7eea5,0xc4175181,0x94e74933,0x6cb58d55,
	0x24dd2177,0x53f16e0b,0x0bfbeacd,0x2c593617,0xf493d163,0x7001fb5d,0x908964a7,0x0145e4e7,
	0x80650225,0x8a152d07,0xeccf28ff,0x21bb5001,0x9aa55dc3,0x41254f2b,0xc175c6df,0x8da770a3,
	0x6c912985,0x824d636b,0xae8d6f13,0x7f993017,0x6f4d5aff,0x49d3ddf5,0x1c8d9935,0x7dcd34b1,
	0x04e5cd0b,0x0429827f,0xa557c8a3,0x0b25cec7,0xb14d94d1,0x8ee16145,0x1d317185,0xf82905bb,
	0xf36376b7,0xd9bbf40f,0x3bcdfdc9,0x540fc4f7,0xbde97b71,0x279f5b27,0xe545f227,0xfdaf28ed,
	0x908da4fd,0xef97ba63,0x1315331d,0xd48bec15,0x30e1c39d,0x5dddb621,0x5d2969f5,0x89cff3ef,
	0x03656add,0x74cf1047,0x22cf89bb,0x114bfe07,0x0479068d,0xcdf16541,0x53c17449,0xb2796ced,
	0x616b0fcd,0xfaf30905,0xd91dbf3d,0xb97f3539,0xb17161fb,0x86a9040f,0x9e6f98ff,0xc825ea8f,
	0xcea3afc7,0x96153065,0x3aa3cdbd,0xc6dbec95,0x4f0b1821,0x295b7695,0x3913ec6f,0x75bfb3ff,
	0x9d8fdb47,0xfcc92ab3,0x027f8bd5,0x9d913f85,0xb3092fb9,0x09d5895d,0x660faf73,0xe0bba0e9,
	0x6f313745,0xa81f54b9,0xc2554c9d,0x2c51a9f3,0x91af13fd,0x4e6b9173,0xce49ef67,0xc90db975,
	0x530b1d3d,0xf3a963bf,0x02497fb1,0x0c51a849,0x9dbd34a7,0x0fef0c5d,0xa11d2623,0xa925d64f,
	0xe71f3b27,0x3d7d0591,0x60f9512b,0xa13d576f,0xa875a5f1,0x79b54029,0xb473da01,0xd5f5409d,
	0x77ed337f,0x06278079,0xb38b49a3,0x394d14d3,0xc19bc095,0xe98bdb5f,0xa4a93ddb,0x9eef520f,
	0x207b3d3f,0x10bd533f,0x259dee37,0x2d2f1e5b,0x576fc1cd,0x0fc59509,0xf4a1d10d,0x6e0714c9,
	0xea47c3df,0x82d1d52f,0x5955607d,0x00173273,0x56b56b53,0x0f35ccb1,0x2dc1ff6d,0xe7ade37b,
	0xed550759,0x0473d611,0x8753fe8f,0x7fb73007,0x4aaba361,0x9d2d2a61,0xffe5c159,0x0ad10949,
	0x7025bc29,0xe0353e31,0x9eb9030b,0xe43fb67d,0x7d1714b1,0x217f3ea3,0x61753bab,0x50eb61e1,
	0x07bdab47,0x232bae59,0x65292507,0xf063c5c1,0x163bce7f,0xd67d2283,0xaf4d5fb9,0xcde7f96b,
	0xb79b522f,0xbce51fd3,0x96c53821,0x11555e3b,0x3cd5e481,0xe8f91787,0xccd58b61,0x5039ac93,
	0x11c582db,0x9f778467,0x062fcc6f,0x7ec720d9,0x362b0ef3,0x984527bd,0x43eb28fd,0x80d5c881,
	0x56b903c3,0xdf71665f,0xbc89ce8b,0x5ae9ef03,0x85ff4a8f,0x5631c5ad,0x64f14f63,0x032baadf,
	0x957b2fe1,0xd3e78889,0x19752793,0xd26f8aa1,0x0e8f788f,0xe7136c61,0x66cd61f1,0x952d61d9,
	0xcb8b96b3,0x3669862b,0xf3175d1d,0x3c893621,0x30a3fead,0x81bb3f63,0x86dbb07f,0x2f4f4c19,
	0x04ef9c2d,0x4309730f,0xb60d3145,0x3aed5469,0xeb776725,0xef7baabd,0x29031767,0x247fb8c5,
	0x7c2518cd,0xd85b7b81,0x857d42a5,0xd9c908e5,0xfcd100ad,0xac2302fb,0xf7a39f83,0x4233878b,
	0xba33f98d,0x9771844b,0x5b05ac55,0xafd1d77f,0x00f17e81,0x06092523,0x039d1e2f,0xf05bc895,
	0xb697dfe5,0x03dbcab7,0x26cba5f1,0xfe3544a1,0x9299985b,0x3dfb16c3,0xe455d543,0x51695c89,
	0xf753c1d1,0xa3ab848d,0xef6f2393,0xd0a97535,0x6b0daa75,0xa74fa5e3,0xd7ad131b,0x624f9497,
	0xb0ed89c9,0x1f758019,0xf21175d5,0x1d5fcea5,0x820d558b,0xc7d3090d,0xe205d28d,0x1a81d263,
	0xe665b6c7,0x6249c423,0xc257e9d1,0xe50796db,0x2ddb1ed3,0x77db7f4b,0xee415af7,0x8bef281b,
	0x893bfc49,0xb9bb2ff7,0x6a61691f,0x52d7943f,0x43391009,0x023bf027,0xedc1e031,0x030bf867,
	0x9973e243,0xf5db1b5f,0x8ad119db,0xdc7dadbf,0x356b5769,0x44418bad,0xf8692295,0x26c79673,
	0x458f6533,0x893df6a5,0x7ac9fe9f,0x622b8ac1,0x3633e7a9,0xcdc16a63,0x6c9b0eff,0x1895e5e7,
	0x0a919613,0xa8f1ea91,0x67ed9685,0x4e973331,0x55cf1805,0x010d2d57,0x0f375ec7,0x9469faef,
	0xd3fb3a5b,0x6c89786d,0x765b7d25,0xb6efaf79,0xa3054439,0x32f99e11,0x2ba137c7,0x10b3ba33,
	0x1bcd6c07,0xee191a07,0xe0b70a9b,0x7ae5a883,0x4b176c7b,0xcad34e9b,0xb3b9cc59,0xde6378dd,
	0x0a8d398f,0x6a33e1a3,0x1825f381,0x64af07b9,0xb9c3d589,0x626f397f,0x5fe3fb59,0x48f19c99,
	0x973945ef,0x5fe51a11,0xe443e8f1,0x48fb9705,0xb94fa899,0xe61f61c7,0xcefff01f,0xb6493b8f,
	0xa755689f,0xb0c7e697,0x83373883,0x26fda0cf,0x927b9367,0xb4b572ff,0xa671c285,0xc6e1bc69,
	0x2ee34d9b,0xc0e7e301,0xc99f6c55,0x48659005,0x2c8b682f,0xbf83612d,0xb21b16e7,0x75a77653,
	0x5063155d,0x96d7c399,0x42a1eafd,0x6169900d,0x2d3fbda7,0xaa5908df,0x045dbe1d,0x381150f5,
	0x7cdbf4db,0xfbabf527,0x4fdd9795,0xb0b72cd5,0x18d98f0d,0xeb8dcf1d,0x161b5581,0x1e11647b,
	0x93c9d595,0x9af33cf7,0x497571bb,0x1f81f2c3,0x721ddc17,0xebef4171,0xe6b5e6ed,0xf215998d,
	0x0331f581,0x22c158d1,0x9e0b3585,0x617d0ec3,0xda4b4903,0x26d1b5e5,0x1c0f88bb,0x59134957,
	0xe7958719,0x63a99f01,0xf2c1fb8f,0x14d9ee3f,0x3125be87,0x4a03eb03,0x2289fdc7,0xf279dd7f,
	0x2bf75159,0x70bd9e51,0x4339d8f3,0xe249df21,0xb4ef09e1,0x55dba7d5,0x4d075569,0x783d7035,
	0xa9d74fb9,0xbf8dbe09,0x01957f4b,0x9cfdafd3,0x22677cc7,0xbd295be7,0xf4eb8b7d,0xded16c1d,
	0x493b5235,0x482bddf5,0x3679dcaf,0x62a94f3d,0xd4d58d77,0x853dbf41,0x9a152859,0x75232c65,
	0x20a19d47,0xa52bf65f,0xa103bbbb,0xbb7f6ccd,0xe5f576a9,0x65ed726d,0x02e9e0db,0x04a99cb7,
	0x950d89e7,0x339db80f,0xd6d76389,0xba311869,0x4e0dd795,0xe9879e73,0x5c47365b,0xf153d939,
	0x7a01258f,0x33152c51,0x641937b3,0x1bef627f,0x03dd53f9,0x8cdf94e3,0x599316b5,0x5993ce9b,
	0x317fd23b,0xe5a354ed,0xeb695851,0x686dfbf5,0x1ca9340b,0xdf496fc1,0x54af7c3f,0x365bda01,
	0xcc07e665,0xafdbcc31,0x45e741ff,0x11ddd637,0xec310489,0xa293b199,0x6dfb0dd7,0x7b1d6919,
	0x289f4d05,0x38cd64e1,0xa3396dd7,0x94efc32f,0x24b736ab,0xeb11e577,0xac5bbed7,0x35cd9a0b,
	0x14c52595,0x8a0dca4d,0xa97ff173,0x98d71547,0xf6fdc029,0x3f953ee1,0x1d2f6f15,0xaedbdb83,
	0x6c7d6413,0x2fab203b,0x955b1eeb,0x0f473f69,0x3247bb41,0xb97339e5,0xf45b8aef,0x89398ca9,
	0x3a4970f3,0x5839a2f7,0x59ef24dd,0x547174ff,0x645506ab,0x24793b0b,0xac3fab3d,0xe2599d29,
	0xd72bc933,0xf4cb4749,0xc0ddae5f,0x4f0549f1,0xf96be5a1,0x1efb2f5d,0x25bf3559,0x722d2d2b,
	0x0aa39e4d,0xd8f35a7d,0x8a47830b,0x903752ad,0x5c499fdb,0x39cb2c65,0xc83dfb1f,0xab292d59,
	0x2ab77639,0xdac1225d,0x8ccf26ff,0x73b7c419,0x16312197,0x183b102f,0xa199dae5,0xda3dfedf,
	0x3be5cb73,0xf2c77d31,0xd5997ad1,0x3fbb13a1,0xeee59b8d,0x901d2141,0x86375f89,0x46db1365,
	0x1131acf3,0x5c1981c5,0xc8435b9d,0x44f1972f,0x0ca922f7,0xc9c1aea9,0x30f76065,0x52f58d15,
	0x6c1d5e33,0xb4471f63,0x3ef342fd,0xfe8d252d,0x143d518f,0x5ffdafef,0x633da14f,0x9affde9b,
	0x1ca9f731,0x1b65bdd3,0xaa47e70b,0x323fb485,0x48e5e58d,0x8021651d,0x04e972a5,0x15e76b1f,
	0x215b0461,0x5403dd61,0x3165da5f,0x103bfca1,0xac6161af,0x09fff6bd,0x445f513f,0x3523264d,
	0xc73126c3,0xe333b6d5,0xd1eb2c15,0x5333156b,0x1ef3ad2d,0xafe715d9,0xb6818679,0x04a3344d,
	0xc9afb3cb,0x3089db7b,0x7fff07c7,0x6059174d,0x7f5db3c1,0x16af9bfb,0x76afc829,0x4adb89c9,
	0x72d75579,0xa617d51d,0x4641558f,0x675dbb2f,0xcae305a5,0xf5a72b2f,0x46cdd8ad,0xa8b98bed,
	0xbb2baa41,0xd06dc605,0x65d35a05,0x8273fa7d,0x3d457793,0x369fcdfb,0xaf3b26dd,0xb9b3b061,
	0x69ade523,0x7e9d08fb,0x76575645,0xd64baf23,0x70c7c2c5,0x15ed976d,0x1edd6e15,0x33b91d51,
	0x33dd6d93,0xe23bd149,0x85ef27e9,0xb21b3387,0x7e2724f5,0x425f430d,0x0b15562d,0x073d4965,
	0xddc17f91,0xaf57cabd,0x393de90b,0xaf910295,0x1cad005d,0xfd4bd4e5,0x0fc3137f,0x7f319bc7,
	0x59d7cb93,0x3c85b99d,0xeb659045,0xd2e157b7,0xc2157bb5,0x3a7f397f,0x0f4b06e5,0x61090c23,
	0xe9231693,0xa2d51ab3,0xce0590af,0xaabbced7,0xc2a5223b,0xc04fe5e7,0x528d5db9,0x0cb3c2a1,
	0x3b27da0d,0xdddbc34d,0x094179e5,0x7053045d,0x711d83a7,0x478f77a3,0xa8edb1d7,0x9ca5b7ed,
	0x8de3e3f9,0xeba78131,0xdbbd9801,0x275b3537,0x3ebfd433,0x9b8d54c1,0x884ba997,0x05cf552f,
	0xcdddf6d3,0xeccdbaa9,0xba97939b,0xbe05decb,0xdb4f8c99,0xba1d4bc9,0x2d0b97d5,0x37a51411,
	0xb6136993,0x445d0e81,0x717511d1,0x2d015f07,0x550d0a15,0xf39133c3,0xba0f1be7,0x3c151ebf,
	0xf009c7b5,0xb7e9f403,0x42775439,0x97839451,0x38bb2e5d,0x0abb8c3d,0x58b7c1ab,0x5795efe1,
	0x33c17133,0x8f855af9,0x063dd8ef,0x6b3d7d95,0xb19dffad,0x54ed1d41,0x58e5a179,0x2915f2a1,
	0x67bd3a85,0xb5c14bab,0x4bedfa8b,0x805fda3d,0xa97348bf,0xd9f99755,0x50ff002b,0xca0722ab,
	0xc0fd0ca5,0xd7b186e5,0x7927902b,0x399dca33,0xe88138cd,0x74313385,0x3de3ef1d,0xee5dac27,
	0xe307850f,0x84e725ef,0xea0d8d65,0xa4296de1,0x35850391,0xf067535d,0xa2f3ec27,0x048b8bc1,
	0xffd995bd,0x4f713a95,0x1141a255,0x97b38631,0x75c58145,0x2ded20e5,0xaa1381a3,0x557f2ea1,
	0xf7f72527,0xebe56f21,0x97e7db93,0xd671148d,0xcd03cea3,0x3e952ea7,0x43a5e66d,0x24af1273,
	0x7a63ae47,0x5155a65b,0x7d9d423d,0x2d11fadd,0xbd7dece5,0x86af17ad,0x46899ddb,0xd00d655d,
	0x249fe099,0xd9519b8f,0x38877be9,0x92c59b8d,0x47f961c7,0xdd111f81,0x902317cb,0xf007a60f,
	0xa2ab4017,0x5fed8287,0xd5496ab3,0x49437989,0x0bb9d77f,0xab0bd22d,0x24535097,0x779143ad,
	0xcf0dc539,0x63b9a78b,0x1701cd35,0xfcb9d837,0x667bbcc9,0x0c6da43d,0x4d7d7115,0xd41f3de5,
	0xd2c37cfb,0x25c70f67,0x9755de87,0xe3d95b83,0x9485e4df,0xef8d92b7,0xbc816ea3,0x0da1c4e1,
	0x455128d5,0xc9ab1763,0xe663f645,0xdfd9a7d7,0xd099277d,0x3539c329,0xa8c3ab19,0xe689d949,
	0x4cb9dec1,0x7575154d,0xaad12889,0x9c67021d,0x73f500d9,0xd0c7239b,0xf02594d1,0xfbcbec47,
	0xbd7da93b,0x71b9f769,0xc1bfe5ed,0xafb7efbf,0x165f31af,0xe8050a97,0x370746a7,0xe4d57f85,
	0x3a9d273d,0x4989e487,0x5ecf9b8b,0xba79d6a5,0xae195f39,0xf349d727,0x084d27f1,0x539dc52f,
	0x559d2c3f,0xea73dbed,0x2c2352fb,0x87e19d3d,0xafe1b333,0xdd6190d5,0xf5578c8f,0x34933fef,
	0xae81603d,0xc48d5567,0x6a5d5259,0x2da14a6d,0x2efd7bd3,0x23a187ad,0xb60954d5,0xcea962eb,
	0x13c7dfaf,0xea69e13d,0x109fbc3f,0x2beba5a3,0xfd2fcbd5,0xf5dbf435,0x48c58da1,0xe35131d1,
	0xa271db91,0x3117c83b,0xec8b2fc7,0x8d6fd6c5,0xcab51a75,0x5663977b,0x126b1049,0xce7fe0cb,
	0xe605395b,0x502babab,0xc2456889,0x0761063f,0x4655e369,0x3a075b07,0xfe5f22ad,0xa6a37481,
	0xf8833309,0x01b52555,0x6c6bdea1,0x1973fcfb,0x3d5146ed,0xa81bf0e3,0x9e811721,0x5caf621d,
	0xa26bf713,0x22476785,0xfc2166a9,0x2dd7c463,0xbb67a9bd,0xda717399,0x4b35ec83,0xdc152f4b,
	0x7ac14875,0xd0f5dd03,0xd90bd1bb,0xb93d465f,0x2add550f,0x5d5b0633,0x435bee2b,0x2ac71233,
	0x07071ea7,0x8f4fc91d,0xe1478d6f,0x5ad9ed5d,0x747316a1,0x2fab743d,0xcc5753f3,0x89399181,
	0xdb3f45a5,0x6169e799,0x897b43e3,0xfc5b4445,0x1f6de0a9,0xe2b3d1bd,0x520be235,0x925b245b,
	0xb9ebfde7,0xedd30cc1,0xfcc77bad,0xf1f9967f,0x718b69e5,0xba431b41,0x86d789cd,0x5b9fd271,
	0xb40b9c69,0x9da1c561,0x3ccd37e7,0x1a5f8ff7,0x8f0fcd8b,0xccb1d5d1,0x839f0813,0x94f7d3e7,
	0x49232aa5,0xbc63f6c3,0x41af982f,0xfec5dd19,0x9abd2b59,0x22cdaef7,0xe7c386e1,0xa8d5316b,
	0x87350693,0x982d7eaf,0x1a0f789b,0xf2dbcacb,0xd5d54785,0xd7e91cbd,0xf9273c93,0xdc2d6427,
	0x2ac382ad,0xa18fd371,0x0b0f11c7,0x34d1e679,0xc0192acd,0x39d5fdad,0xc42d0c01,0x6e6ff5c3,
	0xbecf85ef,0x8b9ba3d3,0xb05198cd,0x0d599e0d,0x37cbc267,0xe8e738d1,0x3bb52485,0xb98d2069,
	0xbcdb2bd1,0x6be5771f,0x1bf7df47,0xefa9dfef,0x99af8011,0xf7ef5db5,0x5921a1f9,0x51f96ec3,
	0xace7644f,0xda7f4d1b,0xf6a3f34d,0x996fbb0d,0xe107fa01,0x0c3d4461,0x3c552cb9,0x26a55bfd,
	0x457793e3,0x11f93e17,0x9f79bf7b,0x32dffecf,0xc7918af5,0x7da7ad5d,0x4bb3999d,0xa105f3c1,
	0x8b8f3385,0x0f651ad9,0x4c17aaeb,0x6eabdb1d,0xe593f225,0x767be1b7,0x541d89ff,0xc5097237,
	0xf2ad70af,0xb2570cad,0x28a33937,0xaa038065,0xd1cdf349,0x138d52f9,0xa8f30bb9,0x5123e409,
	0x7cd3cd5d,0xdcdf355d,0x77bbaa77,0x0c9bbf8d,0x4183f69f,0x84313b29,0x44173927,0xde45c661,
	0xda87c009,0x93914f31,0xb2859b47,0xa8a5aa01,0x2875a8dd,0x2a353cd3,0xe5edd921,0xffe3a6eb,
	0x8ac753ab,0x1d7d4cf5,0xa8a1a4c1,0x9ad131ab,0xd8e59b41,0xb9ed0303,0x3557ff01,0x63ebc3d1,
	0xfb17c7bd,0x2435f9f1,0xa031fc7f,0x2a53c8f5,0x2395e383,0x5a2be13f,0xdfb5aaa3,0xf2d3abb9,
	0xa77b303b,0xd3cd99f1,0x75d71499,0xe8dd02c9,0x77c9bbdb,0xc4437395,0xb8eb685d,0xef8bddd1,
	0x3a6f159f,0xfad7893f,0xbcb53bad,0xd29f328f,0x03412307,0x64033e8d,0xdb59f10d,0x178569c3,
	0xacfb14e1,0x2a63dca5,0xde6d3cd1,0x6e4f0c35,0xd2417c3f,0x77bf4f31,0xc7e3ca0d,0xc2b58fb7,
	0x669f7f7d,0xd603016b,0x3b21ff9f,0xed1b4421,0xef892f3d,0x3049db0b,0x85ebe533,0x03896057,
	0x5d5bfb6b,0x73cb5d5b,0x49732835,0x4ab52f41,0x845b4839,0xd0f3e027,0xc35140dd,0xc6f75ccf,
	0x35b32325,0x9c4deec3,0xb685b729,0x6d5362fb,0xf87917f1,0xcf8fc50b,0xf47987e3,0xf46f16c7,
	0x62a925a9,0x2a97ec69,0x85fba997,0x45a3553b,0x1227d39d,0xf46ff8c5,0x7443b19f,0x8de5d069,
	0x45bf666b,0x5c3f6597,0x31f39919,0xeed7fc6b,0x162534f7,0x7a6392dd,0xa413a1ed,0xcfc71c61,
	0x4ef71d69,0xf157e219,0xcb135bc9,0xcea56f75,0xe7b71a39,0x2ec1f35d,0x0bc9c925,0x510b7dd7,
	0x1cd1f71d,0x4c6f0239,0x1879a43f,0xb53b85c3,0x289d261d,0x915962cf,0x79cbc421,0x23210877,
	0x9c53b47f,0x929b1ec1,0xb7cba197,0xfd4d773f,0x59195fdb,0xf47db23d,0x22f5fc3b,0xf1fb0069,
	0x28fbcb0b,0xcb6be8f9,0x3d299f6b,0xac0b7c51,0xf7edd331,0x9cfddb31,0xc2ad474f,0x240b7a59,
	0xaccd04b9,0x00f10aad,0x5335a5d5,0x912b6de7,0xa25d3057,0xe22f9fb7,0xbad587b5,0xfa43fb6d,
	0xc04b2005,0x5fc1c625,0xdb11196d,0x66db6567,0x34296c07,0x4de12a55,0x33cd4c47,0xb0171955,
	0xca756fe7,0x56ed962d,0x0c5f5b51,0xf1cd5cbd,0xe7955f7b,0xbc69ae19,0x3c79705f,0x9b771a35,
	0x20d17bdb,0xb805ce0f,0x95416915,0x2137ce55,0x755f686d,0x7c95068b,0xea3bbbd9,0x4cd594bb,
	0x275d9fdb,0xd71b3993,0xba597cd9,0x2ec75515,0x34cd0917,0x6fbb57b5,0x78f3830d,0xaf23100f,
	0x709dac5d,0xaac3bd05,0x76c9ad35,0xbeaf4c67,0x3ba18833,0x29a9ae21,0x6b0546d5,0x27d5a3dd,
	0xdd938661,0xec0df52f,0x9c358d41,0xffa57039,0x7e1b90fb,0x10b39edb,0xa951548d,0xb6db984d,
	0xbdc1c75d,0x368bd759,0xf2bbcc99,0xcad77cf3,0xeefdd329,0x7dade769,0xa33b660d,0x16a5060b,
	0xef295d4b,0x2853514f,0x58ffd757,0xc3f9cf7f,0x9f89a2f7,0xdbe50dd9,0x6ea341af,0xdc2b763f,
	0xfe4b2aa7,0x81f1e95b,0xe4257613,0x793b0545,0xdf83991f,0xc92f00b3,0xe7ed5a4d,0x96d98293,
	0x462ba669,0x467b5e45,0xffcd6deb,0x83539c33,0x5d2b32db,0x35ddb6ff,0xd1fb6f43,0xf0a37533,
	0x104b7c0d,0xdb834759,0x8e172075,0xa56f92af,0x454371e5,0x84c1d04b,0xf62d2c69,0xcdfde8c7,
	0xb4ad2b8d,0x2919b45f,0x07a92bcd,0xed4107a5,0x630f7c77,0xab2d34a1,0x4465ca19,0x6dd7687b,
	0xb9d3a961,0xb9cfcda3,0x9ba30a8b,0xd2ffda7f,0x404f3d4b,0x50f3b487,0xf309ad2d,0x89a30ff5,
	0xf4bffe83,0xdab973ef,0x4fa7b3cd,0x59574b27,0x4545039b,0xf065a909,0x9ef70701,0x75532b65,
	0xa8f1e86f,0xbb67e08d,0x1fd73b29,0x2d7d9a07,0xd8b52321,0xf65593b3,0x6b91756d,0x3f5bd76f,
	0xa86d791f,0x8ded4545,0x1ed570bb,0xc721a809,0x7fdf9417,0xe215be8d,0x22bba2cb,0xd0aba141,
	0x73b7b70b,0xa6db6c61,0x95c3811b,0x88779695,0xfe879339,0x6577dc21,0x54d7e5f5,0x0cb52685,
	0x59cb3d2d,0x9d4558af,0x24459567,0xde316799,0x76eb41bd,0x84cba779,0x78c5e247,0xf16bb563,
	0x9831db01,0x6abbe575,0xe0797335,0x5f819d7b,0x89d1455f,0xb6e7841f,0x0be92799,0xb73fec85,
	0x7ae93481,0x8b4f667d,0x77031ca1,0xee17db27,0x767b6859,0x051b1e1d,0xb223d245,0xf1255b17,
	0x7c736225,0x1d954813,0x4b077045,0xd6278409,0x3aa73965,0x2b3709ff,0x55d72b27,0xac8b20c1,
	0x65d390e7,0x029faf01,0x9623c939,0xee635c07,0xb29babbf,0xb79164cb,0x47e54795,0x91678dad,
	0x6e8ba245,0xfdfd1891,0x887d9f1b,0xb7fb278d,0xb919b71d,0x2af7740f,0x5fb1a96d,0x022bc287,
	0x5c9dcc33,0xd5c1fa8b,0x68b52601,0x7ea54b85,0x475ff7bb,0x18bf45d3,0x1b1ddf09,0x3bc55077,
	0xa48b392f,0x727f633b,0xb3edee85,0x788d6d57,0x95334e53,0x46b750a1,0xbe89233f,0x75a9d927,
	0x8955a833,0xff479969,0x3dc785c5,0xe66b12f1,0x38d78021,0xcd351383,0x74d9fd6d,0x01cbaec3,
	0x3c810cb7,0x09adbc61,0x50631557,0x336d42bb,0x4709d6db,0x3707b603,0x6f6fe16b,0x6c9b73f5,
	0xfe0d2eb7,0xa1c163ed,0xcc690357,0x1547239d,0x730fc0bd,0xa181a82d,0x062bcf95,0x9d0bbbe5,
	0x3c7d4aab,0x7a174055,0x48f5925f,0xac2b9d03,0x2eab7083,0xdc754287,0xd76ff4c1,0xf48faa3d,
	0xb4d3b18f,0x07bfba65,0x33ab8189,0xa2c9f6d7,0xca1b7d63,0x8a37661f,0xe81f4a4d,0x6f159327,
	0x929168db,0xa24b9367,0xf0adac6d,0x4e557985,0x94258319,0x3f951c7d,0xc39d3611,0xc3139b4f,
	0x8fb7ca8b,0xa3cf8523,0xfa9fab27,0xce810df3,0xfa09c1e1,0xa3e337ab,0x9bc92a69,0x817957dd,
	0x14c92517,0x88dde1e5,0x029f7251,0x2d7ddd8b,0xa78bbe71,0x90f3f233,0x6907462b,0x35b96e7d,
	0x58cb5b7b,0x10833477,0x1051f305,0x7ffff23b,0xa6ebe207,0x33178f1f,0x0a37f4b5,0x85c73557,
	0x813b852f,0x5c59e021,0xa1d9badd,0x0533d66b,0x80eb1a59,0x2921f9fb,0x64bd8ddf,0x52115317,
	0xc21b8e2f,0x106dc0af,0xcbd793f1,0x46d13503,0x5ccf79a3,0xa46366cd,0x847bf605,0xd58d5ee5,
	0x7df1d6f3,0x7351ca6b,0x596b24dd,0x39077971,0x2057d6a1,0x88adf223,0xbbd13dff,0xc5ab806b,
	0x65bbd477,0x8e19aa1d,0xec3b90bb,0x5a896f9b,0x8fc56c89,0x8c554105,0xc3a34327,0x725d0fd3,
	0x98ffb035,0x4c55650f,0x1c671723,0xd489e3ed,0x6ddd7b19,0x582b20fd,0xdb514f57,0xe61735cb,
	0xc5bbe823,0x9c17f90f,0x9891b431,0x9ab74353,0x9bdfe687,0xa7812815,0xe8bfb8eb,0x05c78b77,
	0x4873eec1,0x8df3fc63,0x45dbc07f,0x8b473b33,0x398dd791,0x682754d7,0x984f82b9,0xb0e3ba85,
	0x4c29cb05,0x74fb3dd7,0x5fe79127,0x8eeb5977,0xc5295b6f,0xda73ae4d,0x7ce1fc1f,0xe15b1d1d,
	0xea5db869,0x06bf64b3,0x98d917c3,0xb8d5ac8d,0x3b7703d9,0xb135e403,0x2fd760f7,0xcba15deb,
	0x4b15c6e9,0x7b5190c3,0x394f826b,0x66b5635d,0x37b7870d,0x31bdee01,0x71177997,0xfea91817,
	0xc4cf7aff,0xad45fa51,0x406ddbbb,0x60bf6d4f,0x13ad5fc1,0x53e1accf,0x46fd3add,0x83e1774b,
	0xfc8f6da1,0x39ad9225,0x83d7aacd,0xf9a31a51,0x07996d33,0xe1ef897b,0x1e716621,0xff3fd7b3,
	0x05d7ec4f,0xa017a18b,0xcfab933b,0x2e97bac9,0x4a3d9319,0x98bb158d,0xead1293f,0xcf3365f7,
	0x82a998ff,0x629b6a4b,0x068ff51d,0xc7493fa3,0x30dd59b1,0x4799ab11,0x45ffbe8f,0x2cafbf41,
	0xc3850a2d,0x25c5c6b1,0x41a38d0f,0x75ebda4b,0x4f398db3,0xf0570c8d,0x905f0ce9,0x4b27913d,
	0xe7716ad1,0xd0abc987,0xf087142b,0xf7339ca7,0x9793e057,0xe749050f,0x10d347ad,0x78893a15,
	0xfbeb1a65,0xacdf5e17,0xf961e00b,0x324f1923,0x7aad875b,0xf341081d,0x14bb8eaf,0x3d4b6871,
	0x1cf74ce5,0x8671e829,0xd8d182c9,0x58f302a7,0x07cbdcf7,0x6d93d1c5,0x0ffb8e4d,0x7c5dbb7b,
	0x9517aacb,0xcbf3e409,0xc1f96afd,0x074fcca1,0x0cadffe5,0x620d068f,0xbcf31f5f,0x933362dd,
	0xfd4df10f,0xae79867f,0xbe7b83c3,0x64174af9,0x3597735d,0xaf03d385,0x3c87e73f,0x79bbbec3,
	0x5d19912b,0x41955cd7,0xce79d4b5,0x407d5217,0x2d49bf1d,0x25478e31,0x3619f7c9,0xe26bffd5,
	0x4a7f511d,0x9b57ecdb,0x089721eb,0x383356e7,0xbd050f5d,0xa82b549f,0xf7896f53,0x5a33c73f,
	0x0a03eb59,0xf45154d3,0xb9f38c01,0xd1690ed5,0xec8dd4d7,0x4d81ad55,0x953b18bd,0x6885c6a9,
	0xaea3aedd,0xc797eb8b,0x86313011,0x9cd30fc7,0x222564c3,0x7d9b2761,0x0a0f0b5b,0xaf53603f,
	0x39e31f23,0xf2b9e04d,0x8775c7b5,0x55a37029,0x428d98df,0x1349fa4b,0x57694b09,0x0b0f46a7,
	0xbbc39423,0xd5cbdae1,0x6e5d4907,0x018b66e5,0xd1096f63,0x7be1a61d,0xa52b6823,0xb2ad1d11,
	0x72c9da59,0x735d9b93,0xa20f869f,0x10bbeb65,0x0f57ab09,0xd7339361,0x61b51f81,0x579d1721,
	0xebf3d2bd,0x90819b2b,0x602bcf99,0x7de75591,0x1dbf730b,0x1791b321,0x61e9fa7f,0x45d19905,
	0x22c512cb,0xd4cbaaf5,0xdcd18f8f,0xee3ffdd7,0x1afdf323,0x21cb1ee7,0x012beef3,0x83bbd767,
	0xa141847b,0xea4d94bb,0x62a7ee9b,0xd177dd1d,0x4457fb89,0xed37b8bf,0x415dff3b,0xf24f776f,
	0x9fe90649,0x9d97bac7,0x72cd7155,0x81c12cd1,0x158da0fb,0xa3a3cb2f,0xeae1da31,0x6cfb2ec7,
	0x25bf0b2d,0xfdbbb7e1,0xe4e598db,0x63cf06d9,0x68e1dcb1,0xc165a945,0xac977b2b,0xe9b56399,
	0x28433aa3,0x7c4dff53,0x071182c3,0x06d105a1,0x97172c65,0x354b4e89,0x3be1ca07,0x98edcc91,
	0xab7b10a3,0x0d5d7ceb,0xbdf58927,0x447be413,0x976f3251,0x80abff05,0x74a33b1d,0x059710d9,
	0xe1e57da9,0x477f34ef,0xa4afe2a5,0x60ff1d99,0x1fad552f,0xd753e743,0x793f6f47,0x35216817,
	0x4c8586af,0x83c3e429,0x2ce34253,0x2b0f8e1d,0xc40f6039,0x3f97bc4f,0xd295d3e1,0xc7813a7b,
	0xdadbe52b,0xfdbd9fe7,0xbeb577cd,0x1bdb1209,0x175d2329,0xb24b5baf,0x900942c1,0x1727c0a9,
	0x0aeda71d,0xf37d75ef,0xd8c30f2d,0x77172645,0xcad31239,0x3abd6b71,0x677ba245,0x5905a3cf,
	0x0939cefb,0xc5970c8b,0x3033f10b,0x6af3883f,0xce37e623,0x16c1fa1b,0xd54f8547,0xbc8d9d95,
	0xd0c5f3bf,0x171b4287,0xd0a30285,0x3025d5dd,0x6fc93c21,0xd6a91ebb,0x3c67cb1d,0x8bb31827,
	0x4b0fe0e5,0xed9bcf2d,0x3c39c531,0x29db2d8d,0x7c4b35ed,0x7d4798d9,0x06233fa5,0x4ae5ce2d,
	0x701b3665,0xd12be247,0x8b95f72b,0x05c7ce35,0x5f0119c1,0x9fed7081,0xc2673b37,0xd9196ad3,
	0x666b08bb,0xec5bc41d,0x8dd9330b,0xdc1fb741,0x41abf257,0x866d9639,0x479342af,0x8fbf29c1,
	0xa2ff80e1,0x2c3f757b,0xe8a78fef,0x4f91489b,0x2c8b2eeb,0x4b19830d,0xd28ba763,0x62cb7721,
	0x095d7c4f,0x60694fa9,0x3821416d,0xad51e2ad,0x26654333,0xfac3d889,0x26af2731,0x00ab8f9f,
	0x0b832cff,0x5ae7a473,0x2ee937a1,0x0d0f865f,0x5479476b,0xb4bd00b5,0xade38c71,0xf2552063,
	0xc9f5b96d,0x104f5e23,0xb621bf23,0x70ff751f,0x1a89984d,0xcad9ce1b,0x98894dff,0xbb39e717,
	0x33b5dc93,0xb7b39f81,0x0d6b2111,0xe5d3d0d3,0x3ad97713,0xe1671bc5,0xfd812f31,0xf94951e7,
	0x264585e9,0xeaa363d9,0xeaeb4301,0xa2bd3be9,0xf629a977,0x0f3d6d3d,0xfa2fdfe5,0x84f71f7b,
	0x8da5796b,0xc5331ef5,0x9b3f470f,0x296d7947,0x2bbd19b3,0xfdab8e8d,0xd2739c75,0x9137feff,
	0x845bef91,0x05f35d1d,0x218b2bd5,0x66170c59,0x79537683,0x08813441,0x10b1cdb7,0xcb79301b,
	0x73653555,0x2df5631d,0x57736c6b,0xcf6dd909,0x5b31d31d,0x5e159b5f,0xa5cba909,0x7baf22f9,
	0x32474c33,0xa0cdce3d,0x0d17a06f,0x869fc3c1,0x4c19473d,0x1f352975,0x0921d043,0xa44b1845,
	0x27038a25,0xc48b3449,0x29171bf7,0x7761516b,0xe5498f1d,0x7f370c8b,0x5895f1bf,0x223fc127,
	0x661939a3,0x21c3c38b,0xc8998f9d,0x77e54771,0xfe87ab79,0xe3e9db2b,0x788d6859,0xccffdf4b,
	0xd28f39a9,0x8387e2cd,0x5f3da87f,0x68dd4bbd,0xce158187,0x05a1345f,0x33e5db69,0x9679e4d9,
	0x3de39daf,0x1765d157,0xd725b033,0x557984b7,0x08b17b03,0x0f2d5fb1,0x5c05dec9,0xab23947b,
	0x88194db1,0x8d7346f5,0xb0f32cd5,0x936d394d,0x01a12629,0xbde1ed2d,0xe8cb92d3,0x91efa15d,
	0xbfb3a627,0x384313ef,0x23c980ff,0xe2eb70e5,0xcaa5d5af,0x818f5559,0x18994463,0x4c4b4f27,
	0x41b3180d,0x2ce5c111,0x3d4b8bcb,0x8ea3936b,0x540140d1,0x9c8b9943,0x90530cd1,0x762d1203,
	0xd99bc8db,0x62ed2fa5,0x019748d1,0x8bc90949,0x8c75234b,0x43a3e273,0x7b5b71f7,0x66032e9d,
	0xe16b328d,0xd46b3973,0x8b51702f,0x9a0fdb69,0x8143dd53,0xbe2b22f3,0xab91062f,0x4cc35a1f,
	0x61a9c39b,0x9df150c7,0x2b9d1679,0x63a55335,0x7e2f13a7,0x85f5b54d,0xb9590855,0x55dd5a2f,
	0x31537f01,0x1e932069,0x8a194ccf,0x9d3f9a97,0x2d794f7d,0x6753fc8b,0x239503c1,0xc745a4fb,
	0x15ed9c37,0x17e12ba7,0xc4ebc0c9,0x260f5bf9,0xb7e39e91,0xa1170439,0x6fa5704d,0x2169012d,
	0xe3792739,0xcdef6e45,0x90b15c7f,0x27c76243,0xe4b1331f,0x0493205d,0x496b5255,0x3f3f25ed,
	0x9c77a07f,0x274dfc93,0x5891e68d,0x369738e3,0x39a303dd,0x15978d85,0xa34bdaaf,0x76375ae5,
	0x91ed9d05,0xcd0fa357,0x5e2ba20d,0x7133cbbf,0x1afb6c09,0x2a7910b9,0xd62706b9,0xb6431841,
	0x83596643,0x4ac587dd,0xd9a1ee97,0xa0cd0743,0xeb7dcb59,0x8c099783,0xc15f404d,0xa9d7a6a9,
	0xbebf9a35,0x2e83c7ed,0x1995e847,0x59157859,0x2c67260b,0x9599d7ed,0xead7fdc1,0xd5e1bf47,
	0x40a1cb55,0x28d919d3,0xa32907b7,0x183fec6b,0x9d81c4d5,0xd4f9f081,0x9ef161f3,0xb9d72bc7,
	0xd401209b,0x2cd96c59,0x51ffc201,0x66fd1163,0x5d07d4f5,0x2a7f0849,0x108ddc3b,0xefa96651,
	0x3261f581,0x901786c7,0x783928bf,0xf87f15ab,0x07bf0821,0xe8fbeed1,0x790dc873,0x4bc93991,
	0x23c17a03,0x2aa5a8e9,0xfe7b8a09,0xca7b482d,0xd8e93497,0xf5bdbc21,0x38570ef7,0xfd2b60af,
	0x9ea55299,0x77132b09,0x83e3107b,0x451fb851,0xca49f50f,0xe89b70c1,0xf4c7c49f,0xad3f2755,
	0xe80f383f,0xb2731def,0x7e15632f,0x5b1dd605,0xb41f48c1,0x2be395bf,0xbb45cac5,0x9ff509af,
	0xb381986f,0xfc59eae7,0x593545bf,0xa9a911af,0x6d2d336b,0x1c69dca3,0x1f2f6f43,0xd3c35465,
	0x42fd3521,0x76d5f3bb,0x97e33843,0x98757c3b,0xeab75d43,0x2981bf79,0x5a670c75,0x219bc4a3,
	0x8705c4cf,0x667b32b3,0xf33f1757,0x79b36713,0x607bb307,0xf4f920c7,0x6d51a933,0x5ceb2811,
	0x3e999275,0x525bda9b,0x7aefbc15,0xaa150421,0x60c105ef,0x7325eb9b,0x3ecf98d7,0x73a9fcd9,
	0x173d1d8d,0x2407f6bb,0xb5139c17,0xb0cb05cf,0xfc45abb3,0x0ad7b37b,0xbc411b3d,0x8e4511a7,
	0xccf3ba0f,0x47950adf,0xbe4d6977,0x5f873f07,0xe24d1e91,0xb5635475,0xf98bfcbb,0x2fb125a3,
	0x4a3d3077,0xcb91b351,0x69bfb2cd,0xf27f4333,0x80999d41,0x1e979311,0x510f362f,0x555f8877,
	0xc81d5dbd,0x811144d9,0x610b8335,0x3061063b,0x236dcafd,0xc4c7bc59,0x83ad8cf3,0x9741ba4f,
	0xee13d35b,0x1ba56cc3,0x44530249,0x8a617c8d,0x15874f7d,0x18c545d7,0xd8c732dd,0x47cb0bd5,
	0xf225774d,0x5161d0d9,0xca391421,0x3c313b0f,0xc02f76ff,0x9de36d97,0x3e41664b,0x93ed3e2f,
	0xb8d1240d,0xfad7af63,0xdfe1f959,0x6c01172d,0xcb21d23b,0x09f3da1f,0x687d1215,0xa319230b,
	0xf51b4893,0x33157f2d,0xc8e9ef0d,0x4a85c6d3,0x3ca3d66b,0x65473a7d,0xf25b6d95,0xb7413c93,
	0x4885885b,0x77b38f81,0x3f75ced1,0x32ef8067,0x99757d47,0x2aafe639,0x7d3f9ca7,0x4cd95d6f,
	0x63115b5d,0xc8bda827,0x9429aec5,0xcaef9ad3,0x04dbe50d,0x67817d5d,0xd10b4fa3,0x3acf48c9,
	0x233fae15,0xc8c9a96b,0xce25817f,0x22b92d85,0x6093f075,0xdb8d8873,0xfc1f6363,0xd299524b,
	0xb613817b,0xdce92c17,0xcb09b61b,0xd4ffb065,0x6ce5e6b9,0x19251885,0x735d8141,0x0027fe23,
	0xb7118b0b,0x4cad2173,0x5efbd833,0x26f39bdd,0xe88d1393,0xa519671d,0x322bbf19,0x69eba0f5,
	0x5037d4bd,0x6227734b,0x749b2fe1,0x284508d5,0xb0d1673d,0x16bf7647,0xda653f43,0x90d9ffef,
	0x5a075d0d,0x89eba3e7,0x2d0b61bd,0xd32950b9,0xe1711671,0x37e5b089,0xd473d099,0xf061f0b9,
	0x7b87b6f3,0x730b6e13,0xffed0ee5,0x2c51ad75,0xf4af3a69,0x24e188f1,0x6f338e77,0x1e73f97f,
	0x4a37a9eb,0x2f176519,0xdb6374ef,0x62edd96f,0xe34f70df,0x6c811b07,0x000780b3,0xeb87f0e9,
	0x6a17d1ed,0x522194c1,0x440f0df5,0xf0b1af93,0x44917c0b,0x301bcad5,0x02d33bab,0x82899e21,
	0xadab3f75,0x12bd2157,0x75133095,0xb9cfcb4b,0x6e39e2ab,0x437de4e5,0x39f98039,0x88ed58d3,
	0x35f5177b,0x69fbe7a5,0x8013afe5,0x2cf72881,0x94858ff7,0x4cfb3e43,0xce59dbb3,0x3ea7a927,
	0x9277337b,0x336d1cf3,0x6d2d7b81,0x635fc39d,0xea3b73a9,0xe569d475,0x6f5747f7,0x9e27e7c7,
	0xe131c16f,0x4d29ef0d,0x5b073f83,0x40b3398d,0xc09d21fb,0xb8156d89,0x72d3cb5d,0x7c5fdddf,
	0xeea9e3cf,0xb7bb243d,0x9ebf0485,0x932b67b9,0xa76b73a7,0xa2d33805,0xf53118bf,0xa8c16519,
	0x55dd5195,0xb639bb4b,0xe3fbcf9f,0x33750c09,0x8ce725e9,0xd5f56af7,0xf9532f79,0x0d41079b,
	0xa051f63d,0xee358b83,0x4cdb426d,0x24c564e9,0xddd37a77,0xf44de5e7,0x8899fb63,0xce4fa013,
	0x660791bf,0x87bfe4ad,0x91ff3b09,0xb4cdd143,0xa573d78d,0x332dd0e1,0xd2e7f4d7,0x6addf9ab,
	0x6d815897,0x4d692f15,0x228d740b,0x9bbd7081,0xad8767e5,0x7a673c6b,0x4e9dc0af,0xdc5d700b,
	0xcbc193bf,0xcc478b85,0x44252491,0x1c49c28d,0x9e51bab9,0x844dc191,0xd89fd047,0xb6c18f5d,
	0x044740af,0x73e97345,0x32e9a031,0x23a347d1,0x1e9563c3,0xfdb121df,0xd44d0177,0x487db44d,
	0x2917b161,0xb6635821,0x417bf707,0x697d2137,0xf3939b3d,0xa5e5e75d,0x4b8b3e99,0xba7fac03,
	0xfab32c51,0x28454463,0xf8ff95ad,0x9007b029,0x210ddde1,0x6ebb0495,0x0ebb1e87,0x303d5429,
	0x081d8c79,0xa0a37ad3,0x3913e53b,0x43f5368f,0x09478ce9,0x9c837491,0xd4bd849d,0xe7a73aeb,
	0xced7e151,0x590d16bd,0x57dbeb4d,0x5c7976d7,0x8d018e11,0xe613dadb,0x5af540b3,0x59313ef1,
	0xdae30ed3,0x0d95abeb,0x41fbe9fd,0xfb4353e7,0x2b7deb8f,0x94bb237d,0x8543af23,0x57c92f67,
	0xe6c16d7b,0x1ccfe6a5,0x9a91ffe5,0xac87712b,0x227f741f,0xa44b2301,0x7e0b58c9,0x30e56bf5,
	0xfb756a43,0xa7cd2bb7,0xdb43c81d,0x86f7d28d,0x8e475afb,0xe3193673,0xd62f92fd,0xcc7584c5,
	0x908126a3,0xb21f386b,0x742ffa43,0x4bc37c77,0x8997d7df,0x11f3e35b,0xa50f1f99,0xccebda83,
	0xabe71897,0x41d7c289,0xebfb0a6d,0x869f13d3,0x4db3c701,0x042f77c3,0xa88dccf7,0xaf393e57,
	0x0229aa97,0x7f89185d,0xffc7c937,0xadbd7e0b,0x525b491d,0xbf9baa35,0x650f15f1,0xead391ed,
	0x1647db9f,0xd645c0af,0xc33503b9,0x41cf8107,0x6dd1636d,0x9c8d39bb,0x4571c1e3,0x11a9676d,
	0x59c7df27,0x139f1acb,0xc067238f,0xee056335,0xf4d99fad,0x65d38ddf,0xbb1b84a5,0xf02da181,
	0x4ca7bd2b,0x87a7fe7b,0x17ffced5,0xa8138b7b,0xdab3ac13,0x78c156ad,0x5deb9e93,0xad511355,
	0x9d6bf223,0x24f15c07,0xa11f881f,0xd0292147,0xd121fb5b,0xe5292cab,0x0c437c83,0xea872091,
	0x49150f09,0xa08ddc3b,0x09694e8d,0x50fdac7f,0x686764c1,0x8d5f30e7,0x0b0757d3,0xe3c35d61,
	0xbb25595b,0x920d8061,0xf4ff3db5,0xbfbdb58f,0x2f45c3fb,0x4631ace9,0x2599d65b,0x8f752e6d,
	0xeda16b0d,0x93854241,0x1e852db5,0x7c1b6561,0xd2fd9945,0xf6f3b2bb,0xcdd9aa77,0xbe8f68df,
	0x8907d29f,0x6187b427,0x77195323,0xd04d255f,0x3f53a95b,0xb977bce7,0x3c2b32fd,0x3c83f263,
	0x045bb305,0xfb23a0dd,0x4661df19,0x11013f73,0xbe879d73,0xfa0f4e77,0x8f711b4b,0xef436121,
	0xc51f63bf,0xc1ebabab,0x4a7b9f35,0xbd6b7e05,0x195ba34b,0x978d92f5,0xed0bfb3b,0xf7439bc3,
	0x3f5510c3,0x99f3f05d,0xd80d9d8d,0x9f3dcc03,0xb7130d19,0x0343fe6d,0xa0dbf723,0xcf737975,
	0x157f5a8b,0x09cba33b,0xfa37c0bd,0xeaa7d4d3,0xbd6ff19b,0x6103ed67,0x3d455fe1,0x6d4561df,
	0x389df613,0x5a87b113,0x929b6bdf,0x5e5da463,0x30b1cc07,0xa71d44ed,0xbb2b52cd,0x60abed2d,
	0x08354cd3,0xb7b75f29,0x795b1e8b,0x638f4719,0x139b1c1b,0xbe671289,0x99ef59c1,0xf4178407,
	0x72451cc7,0x4f6deb4d,0x9d1914dd,0x2df369e1,0x8771060d,0xa2312c45,0xff6f0b19,0x4c7dff97,
	0x13511867,0x723d2bc5,0x22f7e771,0xdbb7fa25,0xebf5f29b,0x804bd0ab,0xd813a9ad,0x894d4989,
	0x565986af,0xb3392f5d,0x86972b5b,0x958fc5cf,0xff652efb,0xd90b46c5,0xf6b9c4d7,0xe479fc05,
	0x94e3e319,0x07f1dd5d,0xba1b123b,0xaeab1b49,0xfe878ceb,0x9f417e1f,0x34c5d871,0xd27301b7,
	0x36ed7d9d,0xe8779591,0x46250a27,0xc4bf697b,0xc49b02a1,0x583daec1,0x9217ecd7,0x222d35c7,
	0xd2fd1ab5,0x6f5fd041,0x69d95dbb,0xdffddfd3,0xeb654adb,0x3bd5f933,0x551336df,0x1d1b03df,
	0x4e11935d,0x79bbbe3b,0x3ad5d411,0x93170e37,0xeb2584d1,0x54570683,0x2a99b7e9,0xa72d082b,
	0xfbad750f,0xc719e8c5,0xc53f50c3,0x1b3d8515,0x3a9dd43b,0x9e97a839,0x460dddc9,0x5ed5af53,
	0xbdd1a1c3,0x1991d1a9,0x2bb573e9,0x80237553,0x6f0f0157,0x29e97861,0x814f22dd,0xbd05d683,
	0x2503eff3,0x55af9333,0xc75d3a21,0xb3fb505d,0x5c3f18db,0x381b7981,0x7cc5adfd,0x352f6b63,
	0x9041ca9b,0xa289802d,0x47d79c81,0xb375681d,0x346d0c05,0x5d81b6a7,0xbf4bf283,0x55470c1d,
	0x4d11d135,0x89b1c3e1,0xd34530a3,0xa5c58efd,0xa85d508d,0xa0efe359,0xd6495049,0xe5bda75d,
	0xb77177b9,0x17370217,0x2647c8a5,0xfc9db7e7,0x074f80ab,0x9bb3fba5,0x759bb3ab,0x09831c4b,
	0x59e5a6a1,0xf9aff71b,0xb403131d,0x942f9643,0x5f05fb1d,0x99a1e413,0x97a93581,0x5e0bda93,
	0x0d6d5aeb,0xa22717b5,0xc61b3b27,0xd32b3dff,0x9bc3831b,0xb90b09ad,0x9d51bb25,0x1b49825b,
	0x198f460b,0x64373131,0x9cad885d,0xcac5c381,0xa847e05f,0x0ac301fd,0x6df59673,0x33ab8453,
	0x54496dff,0x95ed0959,0x8e5dfed7,0x56afdbb7,0x8dd97f21,0xb21b2b0f,0x977925c3,0x7427c19f,
	0x421fcd41,0xafdbfe75,0x284dff33,0x3d197c07,0x9435101f,0x04e54b69,0x6e3f73ef,0xa42d2bed,
	0x3613f2c9,0x6d15a751,0x4e21e687,0x4eb77a5d,0x61a12891,0xab733219,0x2d29d851,0xa5af6567,
	0x71a7a213,0xeb2b7335,0x59f7ae6d,0x86bb2d23,0x1adde231,0xc09556a7,0x159596c5,0x952160b5,
	0x44dd7317,0xca3149ef,0x3c758d03,0x2ad50b43,0x832b7b39,0xf1a1791d,0x8f6b7fa1,0xe9710101,
	0x2e377251,0x4cb72bc5,0x9cb994df,0xeb394c27,0x1c4ff661,0x9e674205,0x49098fc5,0x9415b9f7,
	0xfab5c0b9,0x77cfd181,0xf869551f,0x029987b9,0x4689bae7,0xf939e269,0x57539085,0x20fd2fbf,
	0xe5db33cb,0x330d4c6f,0xc3a57957,0x56275661,0x609d3483,0x26e7b3d3,0x55a9b7bf,0xd69dd703,
	0xb9abf57f,0x6883a659,0x890f69a7,0x9593f10d,0xe7cb736f,0x5ec7d84f,0x85ef47cb,0xd5e394ef,
	0xeea72451,0x24c18187,0x09c9eaa7,0x5b11d123,0x97d5cc65,0x0aa7da63,0xf0852f83,0x3a455f2b,
	0xcbd17339,0xb6d9b8c7,0x5d75bd6f,0x4b51508f,0x8afd789f,0xe6dd4d1d,0x844faa41,0x39b3dbe3,
	0x86a9c9b3,0xd05fff5d,0x12353f9b,0x358949bd,0x5a0735d7,0x22376c05,0x36addfe1,0x449f01bf,
	0x6333e3b7,0xa5638119,0x4cab0b43,0x3367b793,0x3c33e647,0x7e0bbb25,0x238384bb,0x25fbb7e9,
	0xd3f1f1c1,0x0c798241,0xe7f99705,0xc91f557d,0x274530a9,0x6e27a707,0xad3379a9,0x233b760d,
	0x99e538c9,0x9eb1ff9f,0x95c1d5f7,0x05613f63,0xef7b2037,0x38df24b7,0x9c9d6c07,0x1c4de453,
	0xe491b24b,0xd79f4e81,0xfe27d7b5,0xa16191b3,0x679bc4ab,0x170751bb,0x412575ab,0xaba77b67,
	0x71f7ac3f,0x3553bcab,0xdfc96859,0x20d10955,0x80e7d23f,0x53ed1421,0x90adbcf5,0x4639246f,
	0xae976921,0x5861306d,0x2fcdb07d,0xf1e3a3b1,0x6b1f41ad,0x6d65ba6f,0x479514b9,0x5b77d91b,
	0xd577bfeb,0x23d9c88d,0x39d3d539,0x8d473eb5,0xb485f02f,0x33c19bb3,0x08bf9c53,0x754f4391,
	0x1015bc15,0xdd4d7c57,0xbffb9829,0x963138c7,0x69db3f7f,0xe9d3b775,0x7d8f5f9f,0x58375e7b,
	0x96753d99,0x4cd1bb95,0x1aebf767,0xfa5310d3,0x3665b5d7,0x64ed55bf,0x75e7f6f5,0x231f1503,
	0xcf1798f3,0xdcf50e8f,0x59c3cd8b,0x11dd0643,0x83e39df1,0x2ce1a71d,0x08272731,0x6f79e2d5,
	0x6f01371d,0xbacdb60f,0x622571b3,0xbf83b901,0x9a97a707,0x9c016495,0xb13381a9,0x71377419,
	0x99b1358f,0xf5eb4b63,0x10335775,0x9077c977,0xc14584d3,0xff1f6fb5,0x746d043b,0x16cd457b,
	0x012d0643,0xa05d6051,0x568faeed,0xdc6b788f,0x5d2d8f8f,0xb58d7285,0xfbb5b93f,0x292b4423,
	0x05f30fb5,0xeeb91f25,0x5e5b04b5,0xe58f47b1,0x121163f7,0x511d7f8d,0xb76d5791,0x6bc16dbb,
	0xd7074cdf,0x5811eaa7,0xa739e1e5,0xf89798cb,0xe2358341,0xb61fb1dd,0xfe79e289,0xbc87706f,
	0x91e9ed39,0xb5f5fe23,0x274d6c19,0x8cb34e43,0x4e59f329,0x3b69ccf9,0x2e3b4a01,0x33e94ae9,
	0x629ff4bd,0x64790d63,0x6b35056b,0x63996b07,0x75bfdde9,0xca4bdced,0xca930a53,0x44dbec4f,
	0xa3a7dbe7,0x622de4af,0xb617ec75,0xa977b27d,0x362b323b,0xfe95d643,0x9de5cc59,0xdcd1d44f,
	0xfe072fb1,0x702308d3,0x2191dc4f,0x14ff4891,0x4bdd435b,0x469d3607,0xd913056f,0x83bbb313,
	0x893d3193,0x31ef5717,0xbdc9ac97,0x076751ad,0x719768ff,0x0331a1c1,0x337d976d,0x7c0b0941,
	0xeb4b7789,0x4da1a547,0xb15ff163,0xac5d92bb,0x809d9f63,0xa7a7877b,0x0b0770ad,0xe2b5c809,
	0x78b78c0b,0x8bcd61ad,0x59759b4f,0x1a151123,0x90af2741,0xd9cdbdbf,0x84112c0b,0xcf27f10f,
	0x54818e13,0xf7853313,0x69ab9773,0x713fb2d3,0x180f25d5,0x91f92397,0xa97fb0df,0x73573681,
	0x9029d11f,0xfe5798c1,0x0c276f6d,0xfd11de33,0x0b8144d5,0x3af9408d,0x8cb1d303,0x3bb59b07,
	0x4bb37d23,0x90598a81,0x0189e953,0x53371a2b,0xfe45527d,0xd221e4ab,0x658bf2d1,0xef3311cd,
	0xd5a12e9f,0x401d18a1,0xc0f5a7bf,0x73e9ae27,0x421de189,0x0743c87d,0xb26d9d25,0xcf431e7b,
	0xcaf59687,0x62b30be7,0x9809c9cf,0xe9d54213,0x074de92f,0x5cb32d0b,0x583d2b57,0xb7d9753d,
	0x37311a5b,0x2faf859d,0xcae98b1b,0xea2f7e55,0x7c95652b,0x473f7bdf,0xc2576341,0x3f659abb,
	0xb455740f,0xe1219f91,0xb437e3bb,0x74a9abd9,0xef37f5b9,0x4e3be703,0x02a3173d,0xd6d9841f,
	0x8ae75223,0xd39b0c09,0xe517284b,0x73755409,0xeaf77f8f,0x2b790901,0xf17dc627,0xe9a73715,
	0xd1e5f78b,0xa631b5cf,0x4527a9e3,0xdb43e0cd,0x5a15cbeb,0xeb4b84e3,0x4dcd3b57,0xfdc169c5,
	0x8ed3dbc7,0x5a736031,0x328d5621,0xcb473c93,0xa5532883,0x0c83a633,0xdcf12ea7,0xd39b22d9,
	0xd5b14acb,0x747546f3,0xa1e9571b,0xad317243,0xd3f50793,0xa07300fd,0x8acbe473,0x8625597d,
	0xe9050517,0x1ac7be65,0x3e5bb36d,0x55374d45,0xabb99fd7,0x6aed11c9,0x89c1cd91,0xaad19559,
	0x59cfdfa1,0x367dd34d,0x8989ee31,0x2207f985,0xd0e78c85,0x0241dda1,0x72af275f,0x71918e99,
	0x278f63e3,0x9327eaf7,0xfb93a6ff,0x1cd3a36f,0xe63b6d5b,0xef45920d,0x64fd9bb7,0xc4d7cde5,
	0xe0496fd9,0xfed9632b,0x231b39f5,0x195117e9,0xacfb868f,0xcd49251d,0x2689e0ef,0x69974c69,
	0xc07fd5fb,0x6a233235,0xc5435fa9,0xd5af645f,0x24e760df,0x6a1df555,0x43b559e5,0x1f4113cb,
	0xd333fd45,0x081786df,0xfdadcd35,0x1a9f76bb,0xac436983,0xe61769c1,0x2f65b5f1,0xbfc7de3b,
	0x11e58131,0x6e496871,0x5e7dd437,0xdb57bd65,0x1fcf9233,0xd40791ed,0x62fb90ef,0x5f9bb65d,
	0x849bd1b7,0xb4cb56b7,0x105102c5,0x5585c74b,0xfacdf12d,0x593dc5df,0x7e571335,0x6daf975f,
	0x61d3d351,0x962de9fb,0xf24dc37d,0x315de3d5,0x77016127,0x4d8f4625,0x67dd91a1,0xd3770ceb,
	0x2e917efb,0x8f817305,0xba15fd73,0xa191c2eb,0xacab215f,0x5b4bdbc7,0x6c6d2d8b,0x14e3d327,
	0xde57822d,0x005b9b21,0x13c7b447,0x835114f9,0xb28d758b,0x1f45784f,0x5f6b74cf,0x706576c3,
	0xf327dee3,0x4acb0419,0xc209a80f,0x7e512aeb,0xbde945e9,0x48d1d5c9,0xbab901c3,0xfeeff4e3,
	0x9d818b97,0xf365e835,0xbdfbf569,0x24c39627,0x4283bf31,0xb9bd16bb,0xbeb71b45,0xd3f55b35,
	0xdc6b1341,0xc139ba41,0x573db56b,0x1357c899,0x129bf29b,0xa65d6631,0x924754ad,0x1d6567e1,
	0x9d63355d,0xddd9c585,0x53f59daf,0x1141b4ab,0x7ef575e5,0xb58597b7,0x62cf2dd7,0x43b52993,
	0xdc6d85e3,0xf55bcdcd,0x10c3a053,0x30336d45,0x76d10347,0x2083c755,0x842db31b,0x09d59f73,
	0xc40b0d4d,0x564baf63,0xa0c98bed,0xec5fc5d5,0xa7f1197b,0xd32bf995,0x90c31d53,0xad37592d,
	0xcd3fe897,0x11bfff0f,0xeda9ab99,0x4c75f243,0x9e979bb9,0x8bcfbb81,0x897571d9,0x05cf16e9,
	0xdf89e93b,0x1b47aa1d,0xd78566f1,0x01a926f7,0xe58771bf,0xfb41c2a3,0xf5a32287,0xa60b6951,
	0x70ef3531,0x68f79657,0x5501e20d,0x87ab38df,0x260127c5,0xe4d38d07,0x0333adb9,0xfae15191,
	0xa5efe6f5,0x13614205,0x933b9d8b,0x44b13d61,0x47c98e85,0x3e570133,0xa6813e47,0x6bc1e151,
	0x718dad7f,0x759363f3,0x15d71681,0xa9692a69,0x911f5b37,0x501f0e35,0xba754b8d,0x7a9fdabb,
	0xb54b6c4b,0x4d258b6b,0xd6f9668b,0x51057661,0xc6c5c799,0xd4fb4b95,0x206d3961,0xe3e9507b,
	0x6129db51,0xda23c035,0x673fe3c1,0x213bb833,0x4bfd31e3,0x1a41995b,0xe04bf821,0xbe9545b9,
	0x93ad270b,0xff23229d,0x0dcfc0c1,0x6a394749,0x428bbccf,0x1fc1c017,0x4873a4a5,0x9c134e21,
	0xb9d59077,0x61378b6d,0xe849aca1,0x06b3db8b,0xaaafef97,0xb7cd10cd,0x0dc72849,0xa8552ddb,
	0xaf250d09,0x87ef2bed,0x0acd72fd,0x7bd92d67,0x832d55f5,0xa7350509,0x6ba7d8e3,0xc9cd7991,
	0xdd9fe6c1,0xfd5d2de9,0xa0019bed,0x196195c5,0xe9452021,0xc54fded7,0x43f718d1,0xc16d366f,
	0x5dc55c13,0x6e1553a9,0x09050c0f,0x1979ae0d,0x38b9c2d9,0x1be948bd,0x3f17f6eb,0x4aa97a1d,
	0x16993fff,0xc92997f9,0xfd7ba479,0xc0d3f02b,0x2bcb9755,0x0759f5c9,0xebebce8d,0x3b710ac7,
	0xdd9b99fb,0x6029ce23,0xab85e2c7,0x7ea55689,0xfb3f7b4f,0x566d4183,0xdfd3e78f,0xa437ff15,
	0x96d14601,0x072741ef,0xd7c58113,0x0c9dfc11,0x7e557101,0x6a7bcff5,0xd6b5164b,0xefed5e31,
	0x54b9948d,0x34b757a9,0xfd5f15f5,0x8eedbc2d,0x4acf3f25,0x57512da9,0xd2ed5b9b,0x0407bfc7,
	0x7857ea97,0x21e92c1b,0x6df1b489,0xb44bd2c7,0xd4f110f5,0x03436fa9,0x3d6184d9,0x6075ebff,
	0xd12d619b,0xea51348d,0x719f8c69,0xd5e57c49,0x8f7b162b,0x4725d381,0x0573cbe1,0x3fa97b85,
	0xbd3b6791,0xabffdecb,0x670d89af,0x176f959b,0x0bb12301,0x0e455f39,0xc105770b,0xb6957781,
	0x49075ef5,0xa785311d,0xe35bf4f5,0x871b3c2b,0x19515031,0x76778159,0xcc777931,0xd4abf99d,
	0x4f8f3ec1,0x5ff76a51,0xd2291353,0x3d996ddf,0xe6a19af5,0xf00db0ef,0x6aab11af,0xc3ddcc05,
	0x9a57326d,0xbae7a1ad,0x959dc665,0x7e1da925,0x20638507,0x5dd90d83,0xe5056c5d,0xe89f0961,
	0x016139f3,0x206566fb,0x26572c45,0xd6598ce3,0x11d7b4a1,0x352dff1f,0xab674195,0x01e1bcdb,
	0x8b2fc9cf,0x9b036287,0x33793f8d,0x3e7d7885,0xc4bf947d,0x9ddbd64f,0x74317631,0x4915821f,
	0x8cc16af9,0xf7d5f51b,0x42a57755,0x393d2bf5,0x215df3d7,0x92356c19,0x5c47bb8d,0x922f2555,
	0xc99d5aed,0xe66bd7ff,0xcffd6739,0xf3cb679d,0x0e75a665,0xff0dc20b,0x070b2f81,0x6b9d4329,
	0x93c12ba5,0x18d9bcff,0x6e235f53,0x65d78c65,0x91472463,0xe3b5a22d,0xbe5dfc67,0x3e55e8c3,
	0xebb16399,0x63afee65,0xe6390c3d,0x71973bbb,0xed952a8b,0x71ff3f07,0x929ff919,0x6dc733cf,
	0xa06f1dc3,0xde01eef9,0x57e1170f,0x03b7f787,0xc5a35a17,0x2e3bd3a7,0x7ab548f3,0x77e5f273,
	0x6f7da99f,0x015f1a07,0x593dc565,0x336fc231,0x3a31d8c1,0x0f3f4397,0x7401fbcd,0x1521435f,
	0x24db2b27,0xc9db4359,0x16f19959,0x626dbea5,0x0a81f0c3,0x9e5bbadd,0xa265ae01,0x586f35b7,
	0xbb0f3ad3,0xd6095737,0x741bf185,0x5ce5d04d,0xb457b0d9,0x175f4e05,0x703f286b,0xcf3d6929,
	0x7b17859f,0x86fbfa6d,0x2a61a903,0x79893b15,0x93f38c39,0x88a19a1b,0xae770063,0xa181addf,
	0x1c776d03,0x20412a45,0xe9e3b76b,0xb98b4363,0x0417fa9f,0xf2ef64a7,0xb46b37c3,0xb1ada481,
	0xe531a6f9,0xe7eddc87,0x7941d0d9,0xe89bce21,0x7e071845,0x699f3bb3,0x7fffdce5,0xbcaf5e39,
	0xc9c7ddff,0x46939f7f,0xd5a105e7,0xbceb00bd,0xb98345e7,0x327f15c9,0xd593aaa5,0x79fbfcb1,
	0x8d395109,0xe74339f5,0x52a363ad,0xf731e11f,0xcccdc8bb,0xe5e5f1f3,0x600ba859,0xbb855215,
	0xe10b7395,0xd7914b35,0xba6993c9,0x829bf5af,0x4ca96a7d,0x8e9f77bb,0xd0c7c9df,0x8dbd810f,
	0x85418d9d,0xa78deb09,0x6d957c51,0x94dde55b,0x6c571969,0xca01972b,0xffab8f91,0x57959cc5,
	0x68595b99,0x89cb49b9,0x8349dfe1,0xce291789,0x1d998835,0xe7dd28cf,0x0b19a645,0xfa8148e7,
	0xc755ae85,0x735b5011,0xe927fd91,0x592f5425,0x30b3ce1d,0x0a878daf,0x77f18759,0xf26f5999,
	0x4dbb0bd9,0x3bcf3f5b,0x835330ff,0x0b236399,0x746506dd,0x46cd4f55,0x519518a7,0x75d57389,
	0x358b4d91,0xbd3b515f,0x4c6b9241,0x83b7aecf,0xd5f1f2ab,0xc403bfcb,0x49eb4c85,0x95a3abdf,
	0x67454225,0xf4315869,0x759595f3,0x4d1bdf31,0x811b9645,0xdbfb999b,0xd951c1d1,0x5d4b2847,
	0x99ed4c91,0x1fc15f43,0x866fad2d,0xfc057ea9,0x0023dae1,0x3b079fcf,0x5ea963e3,0xf2c1bee9,
	0x7305044d,0xe17d4935,0x7d1fe58d,0x4fa197a1,0x5bcb2e3b,0xfff93df1,0x3f570a95,0xb6739671,
	0xa68fd555,0x5d79720b,0xee438929,0x51a75501,0x3b55228f,0xdc23280d,0x073d1a41,0x6357c605,
	0x170da023,0x5a454e0d,0x2501be9d,0x7645a237,0x04850e93,0x3357faab,0x88bb23c3,0x2eddf555,
	0xf57f59ad,0x60f50a07,0x42f92903,0xbc2fcb29,0xfb9dad85,0x3be5dad3,0xfcb58473,0xe8f7fc85,
	0xe169ab73,0xdd192b43,0x604d87f3,0xcc971c43,0x635bbf1b,0x1ea31613,0x228b062b,0x1c198443,
	0x08cd936b,0x3cc32f8b,0xab9f578b,0x1b2d826f,0x9d05a793,0x16e1c275,0x60217f47,0x2d31a5b9,
	0x482d040f,0x10872d27,0x8a117061,0x06252b17,0x485b0fa3,0x926f5e7f,0xe1d7729f,0x7bb58a8f,
	0x4a8b845b,0x2b7772e1,0xb745a791,0xf6312425,0x63a18489,0x51a3713d,0xba91af8d,0x81950cef,
	0xa969cfc7,0xc3232807,0x655d6eb3,0x7e83fc03,0x6b9717fb,0x874d2a3b,0x03b1f1eb,0xf3435783,
	0x0cc7764f,0x8f9dec5f,0x5cfd73e3,0x7ccb619b,0x7b7f0037,0xf8bd017f,0xfd178215,0xdfb38577,
	0x4b297c6d,0xeb797833,0x1d4341bd,0x393dc455,0x6d1d37f5,0x1dc95797,0x2d27d4e3,0xd0534275,
	0x8993fb19,0xf3c93c51,0xfbd3df55,0x8689f41f,0xf8af1e6d,0x40bf158b,0x80c12baf,0xe9196aa5,
	0x5b81bfcd,0xa81b01ff,0x44d1704b,0xe1e5c15f,0xd4fd175d,0x9e734ce5,0x6b493453,0x0875aab1,
	0xe2fbec85,0x0a878b07,0x5adbd4b7,0x92ff9d01,0xd7432afb,0x8639d7b1,0x06a1a92b,0xe7591fc3,
	0xf08197bb,0x3f9931b5,0xd7174931,0xcc09386f,0x1347a605,0x79dff875,0x3329f10f,0x3939f787,
	0x23136c67,0xae6788d3,0xa92506d5,0xc9b92593,0xfb49b9b3,0x4db9fa3d,0xb7c5bf59,0xcc031027,
	0x08354a03,0x2083fbab,0x3727e33b,0xf33d76d7,0x800d1bbd,0x489bd095,0x61d5b3e3,0xa82d9849,
	0x3be9e48b,0xe1fd6e05,0x7dbff081,0xfa495f25,0x30d3a661,0x43d3b785,0x253dfb09,0x30a7af1b,
	0x88b16479,0xe169dc2b,0x300f1d3d,0xfb0dd1e7,0x5b5df857,0xcb35d397,0x3c5deda3,0x42e50447,
	0x078f06c5,0xcfd7faeb,0xd7b9d48b,0x9c3d2305,0x2bed14d9,0x3d13d1d5,0x4819b10b,0x56d577f5,
	0x4005bceb,0x40d9d78b,0xf4df9e05,0x2f0ba6ed,0xcd47039f,0xea3f87c9,0x6fd3d71d,0x9eedbacf,
	0x4813cce3,0xca8377d7,0x1e23bdc3,0xcf295285,0x88ab70e7,0x360b937f,0x816bfe31,0x281dee01,
	0xe43d7129,0x25657a17,0x20a9d463,0x82c75b3b,0xe5dd4d69,0xb649fb7d,0x11457121,0xf9d74333,
	0xa78578b5,0x4c93b517,0x200f7efb,0x5a99d6f5,0xcb1d6e5f,0x534bced1,0x9a41c747,0x360d9c8f,
	0x136de701,0x9d9dd81f,0xb679f727,0x91d15c1f,0x9d2d2d81,0x67e1c501,0x9dc3847f,0x39312cc1,
	0xb7f7940b,0xf8970afd,0x148bb2ff,0xae21a1a3,0x5f4f090d,0xe161de1b,0xc3abb921,0xba3716f1,
	0x53a3cc47,0xe0118df5,0x21650521,0x9fb91ee9,0xd34743bb,0x5f9b02a7,0xfa5da207,0xea8f0ecb,
	0xf377f0b5,0x991d59d7,0x9aa7bca3,0xe14dabdf,0x995584c5,0x54e1a3b1,0x96bb488b,0x962bf877,
	0x12f116c9,0x4b4fbfe9,0x3477c521,0x980d20ed,0x503d77e5,0x26035abf,0x74252289,0x437d88a1,
	0xbc15a883,0x20b909f7,0xb975c6b3,0xb3adf6fb,0xb53d6d55,0x4a5789df,0x147fb259,0x5379e46f,
	0xa7650457,0x65eb1a49,0x2ac3c5f7,0x0e5fe777,0xc41df9cf,0x6babfb97,0xc02926d5,0x218d4191,
	0x5be11d45,0xa9f70bab,0xe003c403,0x8cd58c47,0xd719968d,0x865582f5,0xa607fb57,0x23af862b,
	0x4f0f1ac1,0xde71d167,0xa7575e73,0x3e3fffd7,0xc6f74149,0x09239b81,0xfb7b97bb,0x0a4fe8eb,
	0x04edf8cb,0x7769d747,0xe5616f61,0x7c517d11,0x0af71c3b,0xf56b0945,0x1c65f059,0xe06190f9,
	0x2fff27d9,0x8b73a193,0xb543ad65,0x0b3dff5f,0xd8db0e21,0xfefb78cb,0xab27260b,0x2b533601,
	0xd1472ce5,0xf39f6d15,0x08a14b9b,0x39b5e2ab,0x44e76233,0xac271f1d,0xb0a7262d,0x0b1bc02b,
	0x5847416b,0x6b81cf19,0xc799999d,0x00e9835f,0x61db682b,0x75c359c7,0xbc414a97,0x5a29e823,
	0xc301f363,0xb1295569,0xf0d1a385,0x248dde63,0x60fb1443,0xe71d4ed1,0x03ddf9a3,0xcd6fd711,
	0xbdf5c549,0xa52b264f,0xb967d1ed,0x52d13125,0xb2059f35,0xbe098cc3,0x83d9462b,0x145fc69f,
	0xc427ce15,0x6a97a093,0xad0189ed,0x446b998b,0x233f263d,0x0ad9aaab,0x1f178f8b,0xf8eda0f9,
	0x3f195943,0x86fffb81,0xcdbfcd21,0xdc89b601,0x016b4b11,0x505fe811,0xbefb2199,0x7f87a0c7,
	0xa6cd86cd,0x0277e6e1,0xb441d9a3,0x48dd4573,0x37c7d3ed,0xa3edccff,0x7367d4b5,0x0723f135,
	0xa1c5eb2b,0x878f2b01,0xafadca0d,0x219dc747,0x701b4b8b,0xcd55ca01,0x92bbadb3,0x69314de9,
	0x25032f57,0x835b48a5,0xe5a33577,0x89771b69,0x32a3a125,0x66e9d81d,0xd9db7df1,0x19a5a313,
	0x9407b0cd,0x456d191d,0x7245cf7d,0x4d9f2241,0x0625c875,0xfd7b18e1,0x8c298345,0x46edad57,
	0xe0d52187,0x1fd36e2f,0x88350839,0x05c55cbd,0x8fe159b5,0x305d7655,0x9385080f,0xf9ff99e3,
	0xabef27fd,0x8725b227,0x9095ac45,0x341d8c45,0xb399319f,0xd1614301,0xa0510323,0x364ba661,
	0x6457ff29,0x326f87cd,0x4b0984b9,0x655952c1,0xb391116d,0x04d7d9f3,0x4973b7df,0x19c3c0f9,
	0x678f1687,0x3b476a6d,0xedaff731,0x50abd29f,0x50893edb,0x61953eb5,0x2c47561b,0xfcd92855,
	0x2199b211,0x3dbf4dcf,0x452da5c7,0xf7c34ec5,0xe9c3241f,0x10ebbd4d,0x0cb59a31,0x92810ba1,
	0x2cf58a3f,0x78673e41,0xd4a10f15,0xc6d5ca9f,0x9d03eff5,0xeea98a47,0xf51b6cfb,0x082b2a85,
	0x72a76c0d,0xec510089,0xf5b12e35,0xb493aa17,0x66893597,0xa92562af,0x565b83d5,0x25c9752b,
	0x4a31d8f3,0x7d11b1f1,0xf87b1abf,0x622d5197,0x41178cbf,0xe12d2c0d,0x27d90097,0x6dcdac3f,
	0x9995a6eb,0x10b96845,0x43a5a8cf,0x3b57c609,0x45f131a9,0x4a17946b,0x0777119d,0x3d2900e9,
	0xf555a071,0xafd7d1cf,0x744f08ff,0x96434cd7,0xccd7a50b,0xc9b1b253,0x599591bd,0xeb51b4d5,
	0xc071247f,0xa583d559,0x7e1b6867,0xd3a30be9,0x8c0b4c21,0x9851a4cf,0x6917a855,0xea35ba29,
	0x4c6fc68d,0x9f49322b,0xcb2b90a5,0x7ea7a9ad,0xb85110a7,0x60c53369,0x875d693d,0xe6455395,
	0xf94dee97,0xcd3f200f,0x5c2187cf,0x6d03ed09,0x24e900d3,0x60616e2b,0x2c4b74cf,0xe679b43f,
	0x558f7915,0x01f7ef53,0xe81f3081,0xdee95d6b,0x6395ef61,0x86f74da1,0x164397e7,0x6c3d9fd1,
	0x3e375703,0xd281a8bd,0xfcc7e9d3,0x9f09e2b9,0xe499138d,0x96db52d3,0x6a256bdd,0x93870a75,
	0xfec72dd9,0xb671ad97,0x1e3b2f63,0x2297655f,0x16b5a90d,0x44db274b,0xd355f68b,0x32c5b8d7,
	0x713ff793,0x27d757af,0xe71f3947,0xa9456e47,0x872b901d,0x584b3d13,0xa3b34a4d,0xfaede01f,
	0x1e23a2a9,0xc345994b,0x28919c1b,0x5d43c6db,0x01bded79,0xcafd6eb5,0xf3a325f9,0x9771c5f9,
	0x5c75b217,0x67cf9d35,0x0a37e8f7,0x73451905,0xb0afca57,0xe9439f3b,0xc20594ed,0xce3f608d,
	0x71b7dd55,0x570566b9,0x2a2f4d79,0x4a7d8f2d,0x3cc3b475,0x71ef5a2f,0x143d8f01,0x9fcdf687,
	0xb1ebb05f,0x54fb71a1,0xbd1f33b7,0x8c9d7441,0xed375e09,0xb653739d,0x162d9891,0x6709bf0f,
	0x9f932bad,0xc8415237,0xae27e24d,0x4dd5d3a7,0xc7d13dd1,0xba41a80d,0x3a356275,0xf96981cf,
	0x0baf643b,0xd9eb5543,0xbee91c55,0x2cd9194d,0xb0d12f03,0x54093c87,0x59396a07,0xc6df36f3,
	0x35c52383,0x95892011,0xa785c167,0x72dbb199,0x8afb115d,0x4c819e99,0xd2999921,0xf9d9a723,
	0xebd3877d,0x092f5069,0x36a16da1,0x338ba977,0x578f6915,0x7ef9044d,0xac39e61d,0x974d0b89,
	0xaa5da2a3,0x656d1c97,0x715d1999,0x6d1d4e51,0x564ffee9,0xf9410c29,0xb279f3d7,0x9ea9add1,
	0xbc651bf1,0x1d55f365,0xb35dba6b,0x2843ce11,0x257f800f,0x1baf5d39,0x983db1a7,0x29e38823,
	0x5b6bcedf,0x067b1c1b,0xcebfe1af,0x982dd721,0xe1df1e45,0xb9134709,0x16e7fb69,0x8d6de52b,
	0xcf756b69,0x78f15685,0x2c275d83,0x3a913869,0x46b12fc1,0x36bd619f,0x0e573973,0x78350011,
	0x8f011609,0x6f477aed,0xeab9d87d,0xf79d8157,0xcdb7cf41,0xac832d89,0xa4f100a3,0x13b1a47f,
	0x5f1307b7,0xa68f1a1b,0x001379b9,0x4203a1d1,0xcf357bfd,0x04b3b3cf,0x6795b251,0x23cfcea1,
	0x732d2ded,0xbe5d1d5b,0x585b84cf,0x36f78a45,0xa1edb9ad,0x1c2125fb,0x69a71c59,0x27054b1f,
	0x8d51caa7,0x58c16677,0xf62ff9dd,0xbe2bcb99,0xbb1db08f,0xe2217e17,0x65091911,0x76455725,
	0x1dff145f,0x3a4f6fb7,0x12b53579,0xa9d13739,0xce8bcd59,0x78811eaf,0xda1b2f57,0x64fd4059,
	0x643dd60d,0x6a17ebe7,0x3d8d90bf,0xd69b7f0f,0xee776149,0x539572c9,0x2fc13285,0x612304eb,
	0x8d890f2b,0x51ad664f,0x7cd70147,0x4bb9d585,0xaba54217,0x5a318df3,0xd35be271,0x1327f381,
	0xd5e793b5,0xdd21e2bb,0x6d39b92f,0x5adf8d85,0x355569fb,0x05a3cc35,0x58cd8b79,0x7dfb4b45,
	0xa7d9ac25,0x9b057d75,0x61d3c70d,0xc03dba79,0x794997b3,0x81bf7219,0x9a77a675,0x1f11dbe1,
	0xbc5fb573,0xdc6d0b45,0x8447b5fd,0xc287d049,0x43c3ee77,0xccd74ca9,0xd93d78bf,0x0e5ba581,
	0x3affc11b,0xd4e9b977,0xf4b92d99,0x52ef4363,0x5f879601,0xd7bd516f,0xdc81b433,0x1e4d78cd,
	0xd9b73515,0xba8dadd5,0xe9c791f9,0x2d2728ad,0xb5d55a89,0xa5c33e75,0x12231727,0xfbd796f1,
	0xfd0d6bdb,0xe5eba6a7,0xd095a3bb,0xf75fd593,0x6e714ccd,0x6cbb3a47,0xae870c79,0x4e6b5195,
	0xd7ff546b,0xf2119ab9,0x6cc71ff5,0x624b7fff,0x0f9b6205,0xb4f773ed,0xcc8d4b83,0xd7fbaae5,
	0x8c0f1239,0xdc975955,0xf87b6043,0x491dde5b,0x9e1513eb,0x7947c2ef,0x8d99781b,0x94fbf587,
	0x49439d43,0x25892a43,0x4457fabd,0xd185c791,0xbd2100b9,0x4701475b,0x398bc29f,0xdc5974ab,
	0x6e1b6203,0xef7d6dcf,0xd7796201,0x8bb9d30b,0xce838b27,0x5df509b9,0x5ec787e7,0x7f8bfbf5,
	0xa797e171,0x1f853cc1,0x0f878525,0x9265f8b3,0x127b7a73,0xd0759b15,0xf22ff14f,0xea818f93,
	0x113b5109,0x7d310867,0x40a16fc5,0xaac130f1,0xc7cd9a55,0xa351b4f5,0x6f2394ad,0x43af042f,
	0x55093ac3,0xd2933a85,0xd569e9f9,0x647b14b3,0x4bb75b07,0xeddfd965,0xf787145f,0x8c039ef1,
	0xcb831d1b,0x0c3fd56b,0x6eff185f,0x39c77d5f,0x39ff7143,0xf9edf2f1,0x73bbbf3d,0xbef3b583,
	0x9bab0b09,0x594713df,0x05091c0d,0xaf5724e3,0x8ce77643,0x63d1f4a1,0xb2a330a3,0xf26f4e0f,
	0xdb014c09,0x4b3b092d,0x05a9b29f,0x745b45a5,0xbd2f87c1,0x3a5979ff,0x89a1f069,0x76e9bf41,
	0xad89fc15,0xf62d411d,0x757dd62f,0x82873a91,0xe219e7f7,0x1edb6715,0xf49512e9,0xf7535043,
	0x65c7aba3,0x10b15ffb,0x0fa95d55,0x3e0d1f11,0xd1679d9f,0x6525886d,0x35e1d8fd,0x991fd8bb,
	0xa4b9ffb3,0x13d7c291,0x65cf9b2d,0x959d6f0f,0x3f5d13f3,0x338b3311,0xf66b4fff,0x1c4160d9,
	0x79e151bb,0x5b331e27,0x0013ff51,0x226da6f3,0xdebbbaad,0xa2e1e48d,0x6591f1cb,0xfb29c141,
	0x83454fb5,0x44d52089,0x7d13b5db,0x482be3ab,0x80c3a607,0xde75e2e7,0x593544b9,0x8ac94321,
	0x0d639c1d,0x514f0fff,0xb1f54765,0x5509829d,0x35392ebb,0x441bdcad,0x6dbb7ba5,0x1a934021,
	0x33416deb,0x43b56b57,0xca573907,0xa1bbc1b7,0x6a5d9203,0x842588e7,0x260315e5,0x147bc26d,
	0xfe5d309b,0x419989d5,0x685fac5d,0xb1735f5f,0x0cf39199,0xc165471f,0x0b737f57,0x1cf124ad,
	0x86bb2427,0xf30b3b49,0xc4adff81,0x51e33a81,0xa83913b7,0xb12dbf5f,0xcde7b053,0x32e7b20d,
	0x12ddfd07,0xa29d67f9,0xce636d0d,0xbb3bf287,0x85f5c317,0xbb4f8233,0x63c7cdb3,0xcfcf4635,
	0x37c38435,0x5d63b0b1,0x4b23ac19,0xb031875b,0xce69aef3,0x1a1da8a1,0x29efc8d3,0x079bed4f,
	0xf8f3372d,0x12ed0eb9,0xf70f9041,0x9df1f967,0xa855eb05,0xfa697437,0x03c7ff8b,0xa8bf8407,
	0xe86be7e9,0xb54f73dd,0xa4c9a99f,0xbc33e995,0x58fb2f87,0x9b85eefb,0x7b2ddc35,0x5c295785,
	0x46af5ce1,0x59196a67,0x5d73e4cd,0x2d25394d,0x641d7935,0x6f438b7b,0xe08575ad,0xc54fc573,
	0x22c1f10f,0x555fb51f,0x80af2ae3,0x1d7baa7d,0xabffa945,0x39f3c4bf,0x6aaf2f49,0xa221dbfd,
	0x7a2333ef,0x63b1ef51,0xe4a1017d,0xe4677f8b,0x91612573,0x326bbe53,0x570f58e7,0xeb13f9cb,
	0x58d5897b,0xc0212cc7,0xf5e72ab5,0x23991b65,0x138577f9,0x21fbe43d,0x0985cee1,0xf3136e09,
	0xf95bca2b,0x494399c9,0xd7a74525,0xe745a171,0xf02fef91,0x84738b09,0x2c759a0d,0x8797185f,
	0xe4b9e2f9,0xa0291b23,0x837f6be7,0xc61d959b,0xc39f3f77,0xa8298fc3,0xd0bf8fc9,0x108f08f7,
	0x126d7563,0x4863ee1f,0xe995d693,0x01517c4d,0x28971f61,0xcdebf7f3,0x8dc7f1ed,0xb06d207d,
	0x087b775d,0xc8034885,0x10897945,0xa4957a71,0xd85beb8b,0x490f91a1,0xa16f0ed3,0x6423b019,
	0xfb63d365,0xc79df8a1,0x357ba497,0xa61bf571,0xcaab44af,0x9f63935b,0x1017e157,0x23251977,
	0xee2b0875,0x3241053b,0xec11a5a1,0x06953335,0x55c9b009,0xa93d3c2b,0xc4a3b0d1,0xff636ebf,
	0xd251ca05,0x55834d9f,0x3e6b6601,0xf133fa2b,0x4e79374f,0xb16b7397,0xb073b11b,0x454f129b,
	0xa7d9a011,0x01732997,0xcd2b0bcd,0xdba93139,0x27fb08bd,0x954169ab,0xeb6ba28f,0x9bdb5837,
	0x9d458711,0xa8a5096b,0xef7599a1,0xa6277fcb,0x1411170f,0xe49136f3,0xd3ed7209,0x2479233b,
	0x2f979001,0x802915e7,0xd2e78e95,0xbb63edcd,0x22ffb97b,0x01af7c77,0x2ed9d8e1,0x9b1d87d1,
	0x4a518059,0x9f91d055,0x9ba58647,0x308b83a5,0x63834bbd,0x416903bf,0x4793fcf1,0x76376aa5,
	0x67737215,0x20f1b27d,0x8451d8cd,0xe553ea3f,0x02e5ce11,0x0b135ed9,0x0ffb1093,0x06b920e1,
	0xaf8373ad,0x40dbceab,0xfe0f3ac3,0xa3eb0b05,0x6ce1852d,0xf87f884f,0x4075f2a3,0x9815102b,
	0x197f281d,0x7e5f6fa9,0xd07d5d43,0x4107afdf,0x6bbd9a4f,0xf5ff8327,0x77e1ce79,0x903d4eb1,
	0x8aeb66dd,0xbb0fb8bf,0x39c18de5,0xbbd9233b,0x483bbb2d,0x6265faed,0x5ba3bbef,0x8fa5431d,
	0xf7c9dbe9,0x5aff45b9,0x0e7b56c5,0x5e13d001,0xe999ba03,0x2f03e3ad,0xb79d5f5f,0x913d4497,
	0x8299a7b9,0x64bfcadf,0xd9cb1e7d,0xdbe5e199,0xf59d2d8d,0xffab19ef,0x9e2f89a5,0x0a773ac9,
	0x9c61ff49,0xa163b4fd,0xfd57c827,0x7403e3ef,0xf0871101,0x4aad02bb,0x883dd819,0x0b453ddf,
	0x249fcc11,0xbc7bc95d,0xd13f535d,0x0f9f636f,0x5d1b641d,0x78df2b9f,0x75275495,0x5e193681,
	0x89574c0d,0x6419c5c9,0xc4257c37,0x62698cff,0xdc99cb17,0x0591eaa3,0x0ad11575,0xa7e77dd9,
	0xe70bb1b7,0x68d10089,0x7b2b5b51,0x0a95ce0b,0x4ec32ead,0x9e95fe53,0xb59ddd91,0x881f7d93,
	0x28bdc407,0xddb50867,0xf1f305c5,0xb0d5747d,0xf1dd5c15,0x443b2db5,0xc86bbc43,0xb8b34fd7,
	0x27ef7e77,0x385544b1,0x9a9f2d2b,0x28594ebd,0x82a7a50d,0x6959e857,0x9c9dad65,0x2e155f51,
	0xcca1b103,0x70c3952d,0x7dd3bfa1,0x8ed54bb9,0x5c637fcd,0x133de63f,0xb2173953,0x37370729,
	0x2d57a023,0x2193f225,0x5aad87bd,0x6c7b1ad9,0x98d3270d,0xf9bdc7fb,0xcf3b14e5,0x9d8d3309,
	0xaf13a4d3,0xa7d70c67,0xc6d3cc9b,0xd3fdcc05,0x303b3a0b,0xa727b693,0x20ebc175,0xc507ff1d,
	0x2557cc8d,0x431ded37,0x4e63f1d3,0x828b6fa9,0x195b5c7d,0x98510391,0x5a872cdd,0xcc17580d,
	0xf2257949,0x357d9665,0x94031783,0xffd9b6b1,0x6977d6a1,0x5c89c8ff,0xd5f15179,0xabaf9b05,
	0x25ff0181,0xe383a237,0x70d1ba41,0xbe199283,0x744f352f,0xb5a38969,0xb38dd621,0x574135ad,
	0x9fe55033,0xf445e379,0x14735329,0x39fbd50b,0xec25e95f,0xb7f1cfd5,0xfa3dae2f,0xdcc1462f,
	0x2d5b84d3,0x71550573,0x2509f7d5,0x1ab3d0b3,0x01bde8ef,0xea47cfd1,0xb761b97f,0x849f3b37,
	0xaa63935f,0xe6c32bf3,0xdf35fa5d,0x51f3f865,0x84554e17,0x65f30565,0x1edd6467,0xf1cd73ed,
	0x217fe451,0x8323933d,0x3619895d,0x3bed7f89,0x01b5f791,0xf6c9d51b,0xab1147c5,0x41bddffb,
	0xebb1f4a1,0x37853021,0xf3574fef,0xbf51fa0d,0xe6192895,0x3b1b2bfd,0x3ce1c8f3,0x2c639f8d,
	0xd079f5c9,0xd77b4fe5,0xd71115ad,0x6d53fc57,0x9c4728e1,0xc3bb1f95,0x3bafb9c7,0x242da34d,
	0x25dd6dc7,0x39193853,0xb7e95eb1,0xa1a5bb55,0xad7fe4ad,0x33fb8ded,0xb55bf89f,0x76114c61,
	0xf05bd70f,0x54efc7b9,0xa3030b93,0xa277ac6d,0xe1858cb3,0x61adbd91,0x7e491053,0x697f0c77,
	0x02f7409f,0x661114dd,0xfbfdf96f,0xc07d258b,0x5e97362b,0x7523fd89,0x5159d83d,0x606905b9,
	0x1f33edf1,0x0a0f0f09,0x9cfda1df,0x76e9fd19,0xc97d7ad3,0x092d455d,0xefef1439,0xf743aacf,
	0x1511f6fd,0x60fd1e0b,0xf6a1bafb,0x8b6b2a01,0x657318e3,0x4b21d51b,0x41eb149f,0x24fd5ee3,
	0xe311e83f,0x2d6bc227,0x300fd761,0x2e3763ad,0x343f9315,0x1acfd54b,0x75b15649,0x5b0715a1,
	0xd63762af,0xf46b342d,0x46e70627,0x19ffc207,0x1621d0a3,0x2a89f6f9,0x20232291,0xa557f331,
	0xaa07bbc9,0x1d930563,0x2f4972e9,0xb3f55d77,0xe9dbbd47,0x1f1f13ab,0x5ca12f53,0xca5fec3d,
	0xa87f9d85,0x12efbf95,0xf3db05bf,0x2bc9eeeb,0xacb1e939,0xafe7cd6d,0xed0f3ee7,0x6b0d65f1,
	0xca21a65f,0x6115850b,0xd5bd0347,0x9baf6fc9,0x9a632937,0xc6af2ecb,0x59cdc027,0x22d7d5f5,
	0xd5f3094f,0xd715b091,0x6c91ac97,0x2859b9fd,0x4d353679,0x9fcd4acd,0x11bf6e6f,0xa7ad6275,
	0x81752dd1,0xa6837571,0xc679df4b,0x20f727f1,0xdde74eb9,0xea0fdcfd,0x8a47f195,0xea018219,
	0x90a74fdd,0x836f7f73,0x8817b57d,0x1f3d348f,0x03bbd431,0xe6cbe965,0x5f457df7,0x34c59c0b,
	0xf60d1fef,0xc46d92e3,0x0c8f25c5,0x275d1b41,0x3473ed9b,0x89cf5c8f,0x731d746d,0x4d6da7f7,
	0xf2a96301,0x828d2c8b,0x857fa341,0xc80777f1,0xc4532631,0x996fab85,0x0eaf0253,0x93e7ce05,
	0x35fd9289,0xb96321b3,0x1b0bbd87,0x3a6fe709,0x061b0dad,0xce7f73d3,0x015fc181,0x22a906df,
	0xfe097c87,0x66ff4027,0x0bd7c0b1,0x8247a573,0x6b0dd849,0xf44d1b7f,0xc10d5851,0xeea3bbb1,
	0x3753e371,0xabf5ee31,0xcd01555d,0x8dc13097,0xa2edfebf,0x08ad7117,0x8a1d199d,0xe7496625,
	0x9cd91e41,0xeb55ca99,0x2a2f20a1,0x558de661,0xbbfbde49,0x5bf14ba3,0x7f71a4c1,0x16893061,
	0xd81fb873,0xeab14cab,0x65816419,0xfcdfa53d,0x42fb58a1,0xb0eb2aad,0xca698595,0xc0d99513,
	0xa12711ff,0xf21d642f,0x57999ddf,0xf1696c11,0x632b7401,0x5cedd63f,0xbae7d473,0x8529ff65,
	0xde73ff61,0xec2b1973,0x8f97288d,0x0b5bfa49,0x0651fb23,0x67c9fee5,0xe751d635,0x7ceb6aff,
	0xc5056993,0x85e92d3b,0x7321db3b,0xad696fcf,0xf4af1d41,0xabd1dda5,0x4c859c37,0x5c11040b,
	0xf85dee0d,0x4eefb8d7,0x5e57a985,0xe4c5ed0d,0xf5030e17,0xf5d7d40d,0x6de5a451,0x910fc735,
	0xaa7f7ec9,0xd949ce0d,0xc3dd4385,0x892132ed,0xec93a5db,0x252d0c23,0x755578dd,0x64d521a5,
	0xbbed0243,0xd98f1727,0x4cd1b5d5,0x5cad42d7,0xff210149,0x4ba51875,0x533750b5,0x1ad59105,
	0xdba9f375,0x46cd76f3,0xf8d7098d,0x2c1dfeb9,0xaeeb219b,0xcd8f940b,0xde6baf35,0x11014381,
	0xa73501d7,0x7a99a8b7,0x3e11e44b,0xeea1c8f9,0xfcb98c8b,0x81c1c26f,0xf4550435,0xdfcbb7c1,
	0xca91b165,0x5105e03d,0x29232825,0xe5ef2483,0x87c7ec53,0xd18b2fad,0x98d54c0f,0x7a275cf1,
	0x2043fa97,0x48a169d3,0x7d2b93b5,0xbe3554c3,0xaddbafaf,0xd8bd504b,0x164faf9f,0x4d8332b9,
	0xd149ea67,0xa27f4a3d,0xd3cf6219,0xae25fd9f,0xab35a9d5,0x85ad2157,0x1da3243b,0x61d56943,
	0x75274251,0x8233decb,0xbd2feae7,0x96f5c383,0xba97b281,0xb929c859,0xe6350bc1,0x798d013b,
	0x31df184f,0x0dcf7d43,0xdfeb423b,0x2453eb59,0x354545ed,0x66873359,0x4de7d48b,0x319f6bc9,
	0xdbf376d9,0x8de113f1,0x1929d8af,0xec73fa89,0xb2ff24d5,0xb395b8e5,0xf919996f,0x21792a99,
	0x1663fceb,0x8d81c99d,0x9c891b5b,0x90055701,0x2a07f46f,0x18a9b807,0x72afc1cb,0xfb116fd3,
	0x72b57dfd,0xfa3b9d95,0x142d13dd,0xda3fe727,0x0f21de77,0x80913845,0x4c0ba177,0xaad7be21,
	0x90e7a20b,0x4427079d,0xc0b7084b,0xe0cfb1e9,0x758b3129,0x68a189ab,0x3d0d18cf,0x77bd88af,
	0x3f7d858d,0x7dd19805,0x99491b41,0x23e77ead,0x2f0dff3b,0x00abe4c5,0x441734a9,0x2337d325,
	0x9b79597f,0x7c4f9793,0x6b85ebd7,0xae3d755f,0xebe3bfe9,0x4b030a9b,0xc60dce63,0x0933d1af,
	0x305b0359,0xf733a791,0xfb8f35ab,0x34ffbe69,0x5ad3eeef,0x3c77e4b5,0xae512bd5,0x402788f5,
	0x1829bd17,0xa88d61cd,0x240570d3,0x37df22b5,0x491fac83,0xdc5b2521,0x8ec39f5b,0xb9036e21,
	0x1b61b531,0x6ceff88d,0xf60b71eb,0x2113abad,0xc2855d61,0x6481e669,0xbfc727cb,0x5f3906df,
	0xd107aea3,0x636dd69b,0xd9450a0d,0x6549433b,0x314b4ac5,0x613b4b93,0x803d1083,0x38bb8957,
	0xbe9da0e5,0x0d973f43,0xabd3a6d1,0xa3b553c9,0x7e314265,0xd15b202b,0x1589915d,0x85fd7c33,
	0x782557f3,0x6f81ee4f,0xe255f253,0xc607683f,0x307b367f,0x4633783d,0xeb8d6eaf,0xe1ef569f,
	0xc0211445,0x2fbbb809,0xa7f1732d,0x2075cc0b,0x8de9ddc9,0x0395504f,0xb4a99957,0x62032043,
	0xa7912ad7,0xb7592939,0xfe472c79,0x91ad2b13,0xbabd5381,0x1fd12d6f,0x89c1cead,0xb62b114b,
	0xadf9a521,0x51eb272b,0xdd793dd1,0xa2e131c3,0xd9bbb75d,0xa3bdbd25,0x0a35388b,0x48d9325f,
	0xe15de11f,0x4d858fa7,0x5429834d,0xa7c72d05,0x2c23cd9b,0xaaa9757b,0x7be90d4d,0x5f01fca9,
	0xfe3b314b,0x1ab7d8f9,0xa7793589,0xde8daa43,0x31b79ef1,0x826734fd,0xeb3f2fc9,0x3813f9d5,
	0x8f957c9b,0x6c95b1eb,0x730b899f,0x8fe71767,0xc8bb189d,0xcb47e2b1,0x4b17cf5f,0x2e01640b,
	0x0ef1de8f,0x58ada1c5,0xc9015127,0x2f0562db,0x4dedac55,0x981f0e25,0x94d307e3,0xd53dc5f7,
	0x044d471d,0x7717a853,0x51fd9a3f,0x799b9b89,0xbc95f057,0x8e3d8f5f,0xe85981b1,0x1cbb9ac1,
	0x262f1abf,0x0261dddf,0x6d234f7d,0x97db90d9,0xce6f3f5b,0x057726ed,0xac0511a5,0x6de9ee13,
	0x7995d271,0xf79d1331,0x5011d7fd,0x3c7772b9,0x1bc15899,0x281b1dd7,0xacbf5917,0xccbdfc19,
	0x72039bad,0x365f7195,0x26edb757,0xc49f718f,0x3b4bffcf,0x12ffe5a7,0x3de565e3,0xf7a7d17b,
	0x1179f86b,0xa0b71ad3,0x34552da9,0x58075e47,0xe2519d33,0xf571b867,0x59595261,0x8799eb65,
	0x087d5f25,0x3b39c939,0xf16fd789,0x08e14a4d,0x0493dd83,0x314538a3,0xbf7fe56b,0x1007d77f,
	0xd60ddad7,0x4cf56f8b,0x2ddb4e13,0xf3dd2787,0xf45351f7,0x7acd1161,0x1739325b,0x3edfd3f3,
	0xe7afaafb,0x7f7fd919,0x2fbbc6e1,0x602f685f,0x82531047,0xf8dd962f,0x0de7390b,0xfc976f6d,
	0xb961e389,0xfee749a9,0xd3b1b40b,0xdf899fc3,0x1dd752b1,0x64c36315,0x776d85d7,0x8c1f2915,
	0xf5a70cfd,0x99bf1d87,0xacdf642d,0x6e1d211b,0xf49f17ed,0x2a53fc9d,0x6e2bd197,0xaae91097,
	0x9581c44f,0xe11b697b,0x24e7a261,0x929ba051,0x12efc335,0x87df6fd1,0x7305a1a5,0xb0e96619,
	0x00755af9,0x488b9ad1,0x9beb5641,0x7e37d1cd,0x8387bc41,0xae39f23b,0x8d5de7dd,0xb08f3a4b,
	0x2c8176f7,0x46231753,0x888d23e7,0x2ca10a7b,0x6fa90f4f,0xe0b381e5,0x6b13a297,0x96cb0e51,
	0xbe29b2c3,0x7275dd49,0x97ef0beb,0x840fdfc7,0x3f170d17,0x951f855b,0x808b7cad,0x4b1373db,
	0x286f3d55,0xa88f237f,0xcdb50b69,0x752fc797,0xb815ead3,0x93cf6ba5,0x28a56d79,0xcf59ad0d,
	0xccd57a29,0x2609f93f,0xa3fdbbfb,0x1b33b857,0x1f63623b,0x17934c4b,0xc4c558d7,0x600b4c95,
	0x1b5da137,0xaaefe651,0x2b6df3b9,0xdbd1c8f1,0x5845518d,0xedc1875b,0xdccdaf1d,0x941fd59b,
	0xb2875efb,0x99d78b01,0x2b236541,0x8737d0cf,0x047b5b81,0x9629655d,0x3f1d0d29,0x7d055bcb,
	0x7f59746d,0x17d34017,0x40c53fa9,0x781907d9,0xa4478751,0x631db75d,0x2097dc55,0xc6af234d,
	0xdd515709,0x2c73b6e1,0x0073ce8d,0xb3a7a67d,0xb66be0b7,0x996d76e1,0x3c9ff279,0xd78f40cb,
	0xb673d0c7,0xe1cb9923,0x14cf1a07,0x099785a1,0xd82b17ed,0x906f65f5,0xf51731ed,0xf0993971,
	0xa341a023,0x6469292d,0x5efb86af,0x3417beb3,0xe54721ad,0xd1f1af25,0x72612991,0x4d3ba2e7,
	0x0abb1815,0x2365e1c5,0x169975a1,0xf7d94b99,0x1803d731,0x3a498579,0xc35db4b9,0x436bc359,
	0x4267c019,0xf04d1637,0xe9cbe477,0x4413a6bf,0x291d9633,0x1845c47b,0xfd6d9b43,0x6399316f,
	0xae43f427,0x1f33924b,0x1d330d4b,0x52736b0f,0x6fdde0eb,0x4d3b9035,0x5c753187,0x98b77453,
	0xe0d384bb,0xa6ab3a4d,0xabf306b5,0xc72df3f3,0x01fffe17,0x6cf9f531,0x62d7f85f,0x4839a3b1,
	0xbb1956cd,0x3fc5ab07,0x67af63d3,0xd0f1fd55,0xd3c998ef,0xddd38879,0xf9733d27,0x720f07b1,
	0x8c9703d9,0x8615d9c1,0x1885d43b,0x48f3439f,0xd7fb612d,0xf89d0799,0x8fadb9b5,0xd0abb8ff,
	0x334f79d9,0x17abb447,0x9d1bc407,0xd2e523b9,0x1fd7ab0b,0x28a5f897,0x3b653467,0xf8ff40c1,
	0x3bc19b43,0xb519c0e1,0x0a8ffbd5,0xfcf93b11,0xfb210f43,0x0bbf4a01,0xd8ff2017,0x7a7d38a7,
	0x00f3df17,0x6173be5d,0xcc8740bb,0x5fdf078d,0x18190b0f,0x923df2df,0x2b5d3c1b,0xff17ead7,
	0xcc63f0cb,0x824b43ff,0xc521f455,0xbecb8799,0xa381a02b,0x1ef192bb,0xfbdf3451,0x6b41f1fb,
	0xf6155059,0xffb16197,0x6d03b4bd,0x276fda21,0x689df4cd,0xa72d119f,0x3a694111,0xfdebd93d,
	0x0489f23d,0x64373f6b,0xf34dfc8d,0x11fbde8b,0xf12df3b1,0xd2c34017,0x1d5bc737,0x7087bc49,
	0xccc5df71,0xfcf1be47,0x5da1c2dd,0x8123d4c3,0xa575ec11,0x1c057729,0x4199f819,0x1709e747,
	0x9247d56d,0xf96f1773,0xa8211b49,0x2219fd33,0xec3331a7,0xefc53863,0xca837195,0xffdf76e3,
	0x2715e62b,0x8bc57cbb,0xe56fd5eb,0x6c8d38c3,0x4aadbcad,0xcd55cdcb,0x81fdde03,0x13fff845,
	0x0bad1827,0x0883b869,0x5ead1f5d,0xc2b5a8e1,0x84a5c9dd,0x6687e9ef,0xf869943f,0x36d90917,
	0x8f13065b,0x06bdcd45,0xb37f20b7,0x913f4f73,0xbc597a71,0xbfab47d7,0xa4a737a1,0x665ff785,
	0xeec7803f,0x8003969b,0xfa039f97,0x6f5daee7,0x928f7425,0x4f974b0d,0x041b5801,0xdb036239,
	0x76cf29cd,0xf0676835,0xdedd9e13,0x3ec36a23,0x4689812f,0x1f9b9f9d,0xbaa511bf,0x27b9d859,
	0xa1a91b81,0x767dae5b,0xc531fac5,0x4ba3e493,0xd605304b,0xeb87da0d,0xb2a9adaf,0x59f17993,
	0x38598255,0xf3578dd9,0xe69f10cb,0x6cafe221,0x1d4974b3,0x41b1176b,0x3d09412f,0x199b9611,
	0x72633fc1,0x2a8583f7,0x734757bb,0x23192737,0xf7174621,0xa2e79d3f,0x31254e17,0xc92f4e79,
	0x15c389c1,0xe2190683,0xb1cf03b1,0xba9118bf,0x5cad40d1,0xa27f7991,0x0cdf62c1,0xa59933fb,
	0x97018acd,0x02a723c1,0x1f57a547,0x694b5c23,0x85d14579,0x064722ef,0x149bba09,0xe64fe83b,
	0x391d01e1,0xb73f2281,0x8f81c997,0x6ff7774d,0x08c51955,0xe6951863,0x733bdb47,0xdd3fbd67,
	0x2d97e275,0x8d752209,0x4c6f9a39,0x39c970a5,0xfa470621,0xce378173,0x5a213a55,0x16df5627,
	0xb473f483,0x9559ba25,0x36c37d49,0x7c736f19,0x0d9d7a13,0xda81ce2b,0x212dd78d,0x7a1f45a7,
	0x3c337489,0x817f9b1d,0xe59fb561,0x58275a0f,0xb489a7e7,0xdb455717,0x66c1dfcb,0x6873af8f,
	0x81d9b37b,0xc6f72dbd,0xc6a5019b,0x77957973,0x3f4926d9,0x72d7fd3f,0x2fc14c67,0xddc9e80b,
	0xb0e7b6d9,0xbd53334f,0x3df73d8f,0x2ff115af,0xfca3929f,0x3605ca2b,0x078f833b,0x909713c3,
	0x835dd897,0xbea7659b,0xc6390159,0xa0ed17ad,0x59d92b75,0xcc238fe9,0x200bf6a1,0x11cdc7e1,
	0x61c16735,0x478516ed,0x10894193,0xd4bba8d7,0x02a97617,0x0f038901,0x7199c575,0xecddaa11,
	0x831145a7,0x16fdd20f,0x248def57,0xe00bd317,0x0159dbbb,0x2af7f87f,0xdb1b5b0f,0xc7bb107b,
	0x0cd18b6d,0x4ea1fa49,0x8063983d,0x021120d5,0xdea94a1f,0xbed1c9e9,0x41f10f49,0x82d5a1c9,
	0x3301247d,0x92856b67,0x38b10661,0xc47d3cff,0xc1ddd379,0xfbe3314d,0xb1fdc67f,0x5921f527,
	0x58277151,0x293919b1,0x1897e05d,0x1b8392fb,0x90b54e87,0xc5ff4b31,0x7da39187,0x000f323d,
	0x2d43e6e5,0x1bd1b1f3,0xc1b5494b,0x85d5eeb7,0x0f73f67f,0xd375bca3,0x5dc54dbf,0xc791b137,
	0xd1d5aeb1,0x55dd3977,0xcc3180c5,0x2ca51c99,0x00db0b1f,0xcd1b532b,0x91c34501,0xba1b9abd,
	0xf3e146b1,0xc56fae05,0xe6ab82e3,0x03a3898d,0x462d709d,0x6e41a4d3,0xff81cda3,0xbc9b87fb,
	0xefe9215d,0x7b1da5eb,0xf645a841,0xe905e2fd,0xff2b4fb7,0xa4b9b027,0x5361ea83,0xae872297,
	0xf0ef45b1,0xc9f3efed,0x36a345f9,0xc577b6d3,0xaa17b5a3,0xb0d37c2d,0x2043eaf9,0x89cfc4c1,
	0x1073ef27,0x6787335b,0x59e34da3,0xac311379,0x43b5341f,0x4565b873,0xff890adf,0x82e5191d,
	0x767b2db7,0x8be98ffb,0xa8a9ed5d,0xfae127d7,0x67478161,0xa7bd5cff,0xb1191291,0x28bdbad9,
	0x798585db,0x11ad3e17,0x22172fbd,0x79bbe35b,0x6e8b1827,0xcfb14a5f,0x3b4ff6e7,0x84c5d59f,
	0xbe95908f,0x95e52e7b,0x9bd19bdf,0x7b6f95ed,0x91c7d7a7,0x878fe99b,0x0b13793b,0x3af3c595,
	0x592d9b4d,0x981faa71,0xe1f5d55b,0xfd338ff5,0x07bba39f,0x8c2dcc3d,0x13c3c767,0xa9b7b76b,
	0xeb4f480d,0x9a73f3c3,0xd7293c4f,0xc6b5c25f,0x25ab0447,0xacd94c4f,0xef411bc7,0x0a034845,
	0xc57b2d49,0x416de4b9,0x948d8d51,0x8a275e95,0x7f57c657,0xeb672c5d,0xfdf15d33,0x8f4b25d1,
	0x06b775fd,0x7423901f,0x89c3817d,0x043f7681,0x07019b0d,0x9c29376d,0x86b5bf05,0x877fae37,
	0xbc8181a3,0x7c27e13d,0x9ceb6e6d,0x1c2b9c8d,0x2d6bb821,0x85f3e10d,0xd6ed6119,0x7b0f9023,
	0x02dd8433,0x25893bdf,0x4aabe639,0x039f83a3,0x01d977cb,0x0213e545,0x627defc5,0x4cf16abd,
	0x244d2627,0xdedd1c4f,0xc623577d,0x56cb9f2d,0x520bf8c9,0x1c5de89f,0xe3c743e7,0x5a976db1,
	0xb9d3247b,0xd933b757,0x18f5ad53,0x3c65c313,0xca45be53,0xb3231825,0x7bab02d9,0x9beff927,
	0xcaeff0a9,0x281d9a3f,0x4345ef55,0x8599c3c3,0x15475023,0x9737c961,0xd18b3e71,0xc36f3dc9,
	0xeda750a9,0xe1af4ad1,0x5bb1e19d,0xce1f1623,0xfc53da71,0xabeb1a5d,0x334b150d,0x5e07dcc3,
	0x6679fef7,0x3e79e75b,0xaf5da4c3,0x9c256f9f,0x872bcdfb,0x071191a5,0xb54d5185,0xf32987bd,
	0x48694a8b,0xb98fc6a3,0xe1eb55e3,0x805f6621,0x1c137ff9,0x10fbbe41,0x52710b33,0x24c7a0e1,
	0x94f9b6e1,0x308117f3,0x0d7fae97,0x35ff1013,0x9fcbca25,0xa479d7b9,0x0c1b45f3,0xcf53dadb,
	0x5c299bf1,0x03638317,0xe2b7a4f9,0xc2b7a45f,0x9597aab9,0x2ee15e1b,0x0a2d921d,0x29c1d8d3,
	0xdc7fc637,0x34c5c859,0xc8b90ba1,0x96b71a6f,0x3f37e46d,0xd003b9ef,0xbb07ac8b,0xe581ce75,
	0xa2f916ab,0x89bb6083,0xfd2531ab,0xacb3ca2d,0xbced9e7f,0x7a31dc41,0xf38b1e97,0x4e851fe9,
	0xab1b22c9,0xa9d51cdd,0xb41d82b1,0xa9db0c03,0x2d7b04a7,0x123bde97,0x0f1fde1d,0x6b3f01d9,
	0x7ee7d489,0x3f25c733,0x384126cd,0xfde3d8d9,0xce25e71f,0x8f77a2fd,0x0f9fed75,0x1ca31971,
	0x56df0a67,0x163fc1cd,0x0ab7a297,0x02fd6a1b,0x1aab5aa1,0x1bb373ff,0xbd73fb79,0x3e1f1c59,
	0x3a05375b,0x3e33a777,0x031f772b,0x1ddbd9b5,0xed515867,0x3345a4a5,0xc7790385,0xc5a970bd,
	0x1dd902e1,0x2895eb7b,0x6f9dc223,0xddadc20d,0x9ed55e2b,0xc4fb3079,0xe313ed6f,0xe3b1cd45,
	0x0661e8f1,0xc97579a1,0x34cfdd99,0x1c29de0f,0x267d0e27,0x522b5b85,0xec252d95,0x232bd91b,
	0x261bda07,0xb7675635,0xedd90025,0x1d7ba925,0x3a0bcf15,0x0ea35253,0x051164d1,0x8985cbeb,
	0xfe0bdb1b,0x4b7b3e01,0x0c5ddce5,0xb05bff39,0x6dbf6c2f,0x00b7c9ed,0xb6b70079,0xb6b50ddd,
	0x7db3a5a9,0xc145464d,0xf87f436f,0x4df7bcb3,0x545bb52f,0x213b9fdf,0x107bda6b,0x052bd79d,
	0x231347a9,0x56d57ce5,0x30ddbfdd,0x3a035e81,0x9f211e4f,0x7b7d7a2f,0xc83dd8ff,0xa9d9d253,
	0x1ab1c397,0x6cbf8813,0x6a9d3acd,0xa2afa209,0x3dd56049,0x4d51676b,0x5a618f0f,0xd431b7a9,
	0x5f8bb06d,0xa613469f,0xb15d9955,0xc0b12539,0x7eb71857,0x27097e9b,0x29c9dbf7,0xce27f1cb,
	
// 2 * 16384

	0xdb25d9a3,0x08636fd5,0x87435d11,0xf7370677,0x2e896833,0x0b777f49,0x9fd58b8f,0x1c293b61,
	0x8581df33,0x1bc3337d,0x04ef441b,0xf3f384af,0xb88f9617,0x8fed717f,0x4c69f631,0x9d2d3f95,
	0x8521d599,0x0ac5d9e3,0xf983e90d,0xcf1b9f4b,0x4689acbd,0xfc3d45c9,0x05e5a0b7,0xaaa53a13,
	0x4f05e5cf,0xc27763d1,0x0aa162ff,0x2b5db635,0xe0b91b5f,0x6ab9752d,0x092ddc7d,0x387f9703,
	0xc6b3ed4d,0x12712a91,0xd46be58d,0x55ed29d7,0x8de355b7,0xe833a139,0x19a1675b,0xf52f9311,
	0x5e291e0d,0xccbf7feb,0x098360d1,0x667bfb1b,0x734773ff,0x93fd33f3,0xa1250bab,0x69a9db65,
	0x35eb9e8b,0xe5f94e29,0x930b2165,0x5f3b6b6b,0xf4a9d2f3,0xbfe9ffe9,0xd01b4047,0x195d2dab,
	0x3cfb29c1,0x952bb819,0xb0a57063,0x4cdf9caf,0xd447b3c9,0x1047e023,0xbd63c88b,0xa23df80b,
	0x50dbaf27,0x73ebb901,0x18753363,0x66993155,0x52e7dc3d,0x9bed582b,0x8661544f,0xdcbdf92f,
	0x5d8bf2b7,0x9e4bc4ab,0x17198c81,0x2e19ec43,0x4fcb3689,0x0c2b340d,0x6ef51fed,0xfbcbe041,
	0x7d912ced,0xd2db6763,0xafb77a55,0x8f9350e5,0x68b17167,0xbcd1284f,0x01839441,0xacddeced,
	0x19ebaac3,0x92ade5f3,0xbbed77fd,0x01b94325,0x19dfa013,0xdc3571ff,0x2eede6a3,0x37e38f5d,
	0x0a1d6db1,0x4155dda5,0x0be11d0f,0xa5bba76d,0xde17da43,0x8b2576a3,0x6e93b8ed,0x9f4f0839,
	0xb429cbb3,0x44e5e441,0x8633bda7,0x674d02a7,0x4e97dc33,0xfcf76449,0xde57b979,0xc01308ab,
	0x2c8f0f41,0x25eb2813,0x48030a5f,0x1ca11a3d,0x4325a69d,0x9779d179,0x629f4321,0x71a3525d,
	0x56551755,0xaf7f0fe3,0xc4f7b051,0xa6699417,0xf2031ebd,0x13015d3d,0xc647fd41,0xa5ef577b,
	0x02f9f76d,0x0f2ddafd,0xe72ff915,0x0fd596a3,0x0fefae49,0x9a5d4f21,0xdab77bb1,0x8969daaf,
	0x1281977d,0xf50d412b,0x2f4d6ac7,0xae9968c7,0xf02fe37d,0xeae1372b,0x97cddecd,0xa3038f1f,
	0x936b5405,0xb3ab12b7,0xd4736801,0x42e711f1,0xa4851115,0x745f8de9,0x3beb736b,0xf42fb87b,
	0xe2b99df9,0x601dd869,0xe445cfdd,0x176ffa07,0x1d2fee47,0x792b5461,0x6bf552e9,0x18e1cae7,
	0xcbf19ad7,0xf1f5738b,0x62e19df3,0x21658975,0x48f336cf,0x2e13b421,0x534d031f,0x67870b11,
	0xa913c499,0x6343bde9,0x6aeb8a5f,0x207bc925,0x35114ae9,0xda6b9f31,0xc3d31669,0x11172e21,
	0x829f89b9,0xd09929cd,0x4d87a9bb,0xbee10281,0x2d4dcf4b,0xf805701b,0x55ebcb9f,0x4103f9c3,
	0x2f99ed2d,0x990b6201,0xb2530d21,0xb14b5f73,0xdbe74d33,0x533389eb,0x8877ae19,0x3d39e41f,
	0x75832675,0x7e29e9cd,0xb7756229,0xd6eb8a63,0x69a1d257,0x2ac7f827,0xe0d735b7,0x862fb3e1,
	0x285f4185,0xc407bcfd,0x118d92ef,0x59734e3f,0x9dbf90f3,0x50130edd,0x0aed66cd,0xf6d3202f,
	0x4aadbedd,0x5137efdb,0x2bbb660d,0xcd13366d,0xfe017fc3,0x46e90a93,0xf91d7239,0xe49b70b9,
	0x2d733373,0xcec74f2f,0x47a51e9d,0x507f2edb,0xeea9f9fd,0x6599b057,0x04495553,0x3f791da3,
	0x902fe8c1,0xc84d0045,0x9d6b1c39,0xace923ef,0xd27b5f5f,0xf4f9edb1,0x0bd379f5,0xb1db6f9b,
	0xc0e57cc3,0xcbdb20e5,0x7baf7af9,0x7601a295,0x2ab7b41f,0x505978ab,0x9599567b,0xc0b71fcb,
	0xbc1781f1,0x8a01675b,0x6793b379,0x29fb7837,0xb71f40fb,0x058b6fd1,0xee030dbd,0xeb7bf7db,
	0x4cc71f47,0xf5d3c271,0x3cb93ad3,0x518952bf,0x95f53329,0xf4dffa29,0x47ef0f15,0xcc1d71f5,
	0x2c77b03f,0x64e1f96f,0x4d43229f,0x9fdd6097,0x63fd3c67,0x712be741,0xdcc1b65d,0x370f58c3,
	0x232764d1,0xaf3d4c21,0x81d5b8fb,0x12a7f0a7,0x5c7732ed,0x5fbd4f1f,0x0c59ebf1,0x5b3f6771,
	0x275be177,0x4f7b12d1,0x798d287d,0x121b125d,0x7927b173,0x586b3251,0x7d1bc4a9,0xe223e9a9,
	0x7e15df2d,0x82ab5e47,0xaa111841,0x90e9359f,0x924db737,0xc58319df,0x3be721df,0x0fa95b93,
	0xdad7cb6b,0x686197cf,0x7f7f4be1,0x2c47cadb,0x7eab47ef,0x03dbb753,0xdc21516d,0xe24909d9,
	0x7fa3682d,0x22ad2131,0x7c7d4375,0x4be3e2f7,0x33850bd9,0x82c184b7,0x97a9adaf,0x32efb1a5,
	0x5cfb6bed,0xf623f4bb,0x5a29db99,0x41efcf5f,0xe49befad,0xe4096497,0x6ee53d7d,0xd50f20a3,
	0x31df21a3,0x69d34531,0x2829ed67,0x6b21c1fd,0x242fc4a3,0x1c0541f9,0x48b15431,0xb69dd4fd,
	0xabd308cb,0x67511de3,0x6c9dee79,0x4ea76d3b,0x0303e079,0x9189b06b,0x127531a5,0x00099d59,
	0x86d9755d,0x5aad0297,0x442790e7,0xbe35a403,0x305bbd67,0x3de38bf5,0xe00da235,0x344538e5,
	0xad732fd3,0x52798f99,0x81e9634d,0xf5fbf9bd,0x19f79a25,0xcce79921,0x0be19eb9,0x50c3f74b,
	0x58a31529,0x1fc919b1,0xcf8570c5,0xbcad6257,0x0c1b19f1,0xbce724f9,0x56cfec8b,0xed7558b3,
	0x2febb6d9,0x762d4e2b,0xcd1de0e9,0x837dd237,0x5187e483,0x7eb5a507,0x0839bd87,0x5ccfadc7,
	0x694bfadb,0x0bb9d2d1,0x315397d3,0x861dde4b,0x537d4615,0x95a35755,0x0e035005,0xcbc1b7b3,
	0xe947bbab,0xb8ffe5eb,0xe94bd61b,0xeabd5bf9,0xb9bfcf61,0xb783e26f,0x1c8f8edf,0x61bd481f,
	0x62e16841,0x990dfe45,0x38a3d8dd,0xe211012d,0x8a91f59f,0xeca7f55b,0xcebfb16f,0x60b5e135,
	0x779ba419,0x297b6b29,0xd98179b3,0xc74b0451,0x4ab3b28d,0xafdfe7a7,0xc5f1db91,0x451d55a1,
	0xd777e72b,0x6a55f45f,0x1c83ceb7,0x401bbc4f,0x1d692463,0x0e81595b,0xca0dbd9d,0xe5e3688b,
	0x60f51df1,0xfe317a33,0x08cfca81,0x5cb74091,0xe4732ddb,0xc85dd301,0xe971346d,0x947d6d9f,
	0x411b4969,0x4a21956d,0x7c03dc2d,0xb7cb0901,0x6013162f,0x6fc565a3,0x9901e95b,0x3cdbe905,
	0x13671f07,0x95b53759,0x4a458f55,0x968f8e07,0x4f0b2919,0x89894acd,0xd41df243,0x85712f69,
	0x01dda8cb,0x2b0149c1,0x5e352c13,0x08b1e891,0x8e9f56d1,0xacff8485,0x3ca7717d,0xef2d05f1,
	0xe4ffe529,0x76934eef,0xd8f556ff,0x08657205,0x3a8fd415,0xa3f57d59,0x3b0535e3,0xf585424d,
	0x63cd6721,0x278301ab,0x3227b135,0x9a5d644f,0xcd1dba1d,0x8ac1a851,0x1e155acf,0x2e696aa1,
	0x13cdf629,0x4f5ff53f,0x57ed784f,0xedc979db,0x3f0da6a3,0xf03120f7,0x3b39e81d,0x6a4b559b,
	0x98fd2e3b,0x82393579,0xcee92667,0x7c5d8d8f,0x279f5be1,0xf59b4b55,0x0e557225,0xd41dca65,
	0xc5e11fd3,0xf6a5e69f,0xd23f1217,0x2a4b3ad7,0xdc976091,0x6ecd73f5,0x59cbb9c1,0x115320a5,
	0xbb7befe9,0xa5b3e57b,0x738d0e77,0x66457d9b,0x92339fed,0x021b6fe1,0x467b4c4d,0x61dbe089,
	0x094d77f9,0x6af7675b,0xbaf70b23,0x497b5249,0x7b3b09af,0x48593ca5,0x83c923a1,0xc02b62bb,
	0xcd59e5fb,0x24819a05,0xc721b435,0xb7a155c9,0xe8eb3211,0xecd5a047,0x67974617,0x01337063,
	0xd41f5c6b,0xd2e343c3,0xed291245,0x7ee76583,0x6b09f1cd,0xcd63c955,0x0e436689,0xf467e32b,
	0xb8a39243,0xb9316361,0xd8b52a6f,0x78013f65,0xefd5061d,0x1a55eed7,0x7ab58451,0x83b5453f,
	0x046772f9,0x7cfdd029,0xabe59e4f,0xa62121d5,0xe411b0bb,0x767df057,0xb64b8b4b,0xd3937147,
	0x4f6dbe8d,0x4657d9e5,0x1f5b4bf9,0x56f96bbf,0x530157e1,0x172df5df,0xf0e9f3cf,0x62f1326f,
	0x6037a975,0xdfd1e8dd,0xa237ee0d,0x42bb3c8d,0x06652649,0xe4370ff9,0xa0ef62b9,0x2b41e45d,
	0x4bc77cab,0xd67f1ddd,0x7a1fbba1,0xac171429,0xa67fab2d,0x97edd7b1,0xa341495f,0xc0751341,
	0x959d35ab,0x99f1f22d,0xe3330853,0x803f72fd,0xda137a49,0xdf210e8f,0x5b41859f,0x71011bbf,
	0x4fbd266f,0x9c3bd799,0x3017e437,0x76e979f3,0x6661cbd3,0x79253e9b,0xd2cf01d3,0x65d3cb05,
	0x3aa9956f,0x71edd86b,0xe9e9bbed,0x32438a73,0x4f2b1c87,0x57cb5a63,0xda4d54d1,0xc261febd,
	0xe5635da5,0xf21b376b,0xf04df88d,0x5f01e66b,0xf6b5cd9f,0xbf635cef,0x289f61f7,0xc49b450f,
	0xcd6d8e8d,0x56550fe5,0x99659faf,0xd4555041,0x3dbfc4d5,0x66c3e9c9,0x7b27f91d,0xe4f57ca5,
	0x7ec90c21,0x5aadf5a3,0xd1d5f36f,0xb3efaae3,0xa38d0c63,0x973becfd,0xb5c5769d,0xf65d74ab,
	0xb3f72ed9,0x5db794ed,0x3cbb1267,0x8a0399b7,0x65dd7305,0x4c9b3b11,0x02dd6351,0x46498cc9,
	0x75fb63b1,0x8085528f,0x53bd97af,0x6d4320a9,0xa0f52bf1,0x55393113,0xf3511495,0xbca95529,
	0x3c57cc21,0xc6a7ebd1,0x86f93ae3,0x1edf4423,0x6f976ee3,0x71e35489,0x9e814c41,0xfbef2e77,
	0x0d0dde23,0x362f1681,0x5d15701d,0x2a8ba90f,0x0b011815,0x75eff381,0xc251d8af,0x810fe9db,
	0x9c9f0435,0xf7b120e3,0x933107f7,0x067934d5,0xeaf94843,0x672bc483,0xe32134bb,0xc3776901,
	0x6e0d3d4b,0x763d91c7,0x3cefcf8b,0x335bad63,0xe5c104a3,0x9ded8699,0x6bd527bd,0x551d3e0f,
	0xf2ddbce3,0x7f67c873,0xe4713071,0x5c615921,0x5017d6f1,0xe503a14f,0xcdcd658f,0x02714bb5,
	0xab0d8af7,0x633f9cb3,0xaa59d0c5,0x773f9ef7,0x1d416d69,0x99c1c4ab,0xa0ed2e8b,0xf2656519,
	0x452123ff,0x1459fecf,0x65c93321,0xe425a651,0xfeff3ac1,0xcbf9893b,0xc395ef8d,0xc66bede5,
	0xbe1b18f7,0x47c59793,0xc463569f,0x8dc9f719,0x85951635,0x5dff1005,0x7aabe1ed,0xba777a43,
	0x817baf57,0x95156849,0x6a4b56d7,0x095919bb,0x3fc3db81,0x24a1a297,0x918bab85,0xc4f96edf,
	0x8947811b,0x965d6ab9,0x121f0be5,0xb689371d,0xdacb0adb,0x073352f9,0x7a1dfeaf,0xb6e3a0e1,
	0x7dfd1cbb,0x082f312f,0xad03aa63,0xdf89b8a9,0x427168ff,0x1f879bb5,0x6cbd3a47,0x5ba7f5f5,
	0xd6a1a533,0xe99b8673,0x829b636b,0xd90de84d,0xc0f59f29,0xd9efffd7,0x885309a5,0x99370443,
	0xf8b571fb,0x9c330dd3,0x51050495,0x22479071,0x1f19db0f,0x153daae5,0xf23d04a3,0x9007b277,
	0x583baf0f,0x040be315,0x6ce797ff,0x84e99bfd,0xc4216eef,0x42c310ed,0xf65d4f9d,0xbb07d7b9,
	0x97b5fce9,0xa7b33a83,0xe161043f,0x3523b65f,0xd5cd717f,0x86538e75,0x27193b6b,0x0fa9dbb3,
	0xa823107f,0xd03f00e9,0x9015ac6f,0xf1a9eb7d,0x585f5dfd,0xd63d088b,0x7d4de567,0x1ddf5691,
	0xe90b5351,0xa93f7b91,0x5125102d,0x23ad47c3,0x4e9bb41f,0x1b578cb7,0x7861d76b,0x301bb0fb,
	0x486b8355,0x60c5e843,0x13336b8f,0xfedf781d,0xd9bf9823,0x50f1f103,0x3e33a7d1,0x6b51c41b,
	0x62c75305,0x47671d4b,0xfb615731,0xa17369f1,0x599372bf,0xa4dd73fb,0xbb259975,0xeef1799d,
	0xa31f095d,0xf0312973,0x8551682d,0x341beb29,0x8c539131,0x976b5ca5,0xc21b3baf,0xf4ed6ba9,
	0x62f921d5,0x50b9f403,0xa325d01d,0x0a074a33,0xaec5c52f,0x1b719a8d,0x2c770a5b,0xf1b784eb,
	0x0a55ec69,0xe10fdcc7,0xdd7ffd19,0xc0edf5f7,0x9c2904f7,0xb63d65bf,0xfa190dcf,0xb441a08b,
	0x2fb32d93,0xbbc75c09,0x738339bd,0x60f91ddd,0xee430b41,0x9fa5dec3,0x71657ae9,0x85ff2a33,
	0xb817be4b,0xbdf3a291,0x7acf4d23,0x7ce351d3,0x1d53f745,0xe1f7aea3,0x3f3b5301,0x4ae1be0f,
	0xf7032c0b,0xa72139ab,0xff891ae5,0x51d9223f,0xa01becc1,0x7a09a6e9,0x96ff03f3,0xa159c8c7,
	0xce7958cf,0x3969a321,0x244f431b,0xe78fc00f,0x0bdfb3eb,0x7729619f,0x52930815,0x02592787,
	0xcef91b11,0x5957f93b,0x4247c261,0x30379ca9,0x345d5981,0x1b2be151,0x12578645,0xe153c7f5,
	0x5789ddc9,0x2e038ec5,0x091191d1,0x288109f9,0x4bddcebb,0xfa613105,0x5d2df1db,0xcc3b4841,
	0xb5a74071,0x40f98f07,0x9ecf4705,0xf7a3da69,0x031b8951,0x1b9f0449,0xc07baab3,0x8b819711,
	0x4557b705,0x9e4f9dcd,0xc023b415,0x0f4900e1,0xa95d2381,0x18335725,0xf01d9d25,0x4217938f,
	0x911b29ff,0xf4977761,0xe02f879f,0x4bab30cf,0x4c63fc03,0x3bf10e23,0xe67be20b,0x8d6fad65,
	0x71f39657,0xb4e1908d,0x4895ecb9,0x13777e1b,0xd871d611,0xa52b964d,0x04735ebf,0xa57d84bf,
	0x2f65ad89,0x32bfb699,0x39772afd,0x77e1fd2d,0x38477963,0x64b3852d,0x3167651b,0x7caf8a45,
	0x9f6f758d,0xc445af4f,0x09774689,0x549b62f1,0x75275237,0x9ddb38cd,0xfb3d537b,0xdffb9f23,
	0x4697e8df,0xe203d8fd,0x45b79ff3,0x6fd5a4d3,0xd6d31145,0xa67577b9,0xb65134b7,0x96d1b501,
	0x77db9677,0x470dca69,0xd1db9457,0x9a4398b9,0x038f4bc7,0x26d310f7,0x9d8b602b,0x83236e0b,
	0x74bd41cf,0x10f3f2dd,0x08011d4f,0xcf17950f,0x201b1b75,0x39c77c15,0xf24919ad,0xc165bce7,
	0x8d4382e5,0xdfc93a25,0xd8cf70f5,0x540110bf,0xefbbbe8d,0x8ca1791b,0x1c6d319b,0xc88784c5,
	0x3fed662d,0xf61fa08b,0xeb63a1e1,0xd9354333,0xf42d37c7,0x7f37b093,0xca5ba4cd,0x89f93949,
	0x59bb0ca5,0x5909ded9,0xbd633f2f,0x9965c453,0x8db9ee5d,0x43d95387,0x10f53c9f,0x91b37ea1,
	0x16314bc7,0xf0170657,0xc2eff479,0x79c32c8d,0x1b1b4e09,0xff57bb83,0x8b9b2ee7,0x2621c977,
	0x3f514d8b,0xa55b20d1,0x86a929d9,0x29ffb4c7,0x19996705,0xe9070a8d,0x7c31be03,0x6837fef3,
	0x4d9d306d,0x8569d08f,0xc9b3a3e7,0x444dd66f,0x44f38e0b,0x6ab7cb33,0xeb17d8cb,0x736914bf,
	0x8817a767,0xdf51f05d,0xa3af23bf,0x6d5feb6b,0xb76bfc55,0x40bd907d,0xc731ba9b,0x7da7b105,
	0x243f99ef,0x64a73385,0xa2bf06fb,0x7465ce27,0x09c56f9b,0x99e795f5,0x05df8b4b,0xf763ca71,
	0x6619c405,0x497dc5cf,0xeb85e7b5,0x7313798d,0x7341ca1b,0x378b5fa5,0xc307ff35,0xab8f482d,
	0xc029561d,0x6461eb87,0x59233c87,0xed9ba907,0xe9a3b28d,0x8d775a17,0x6105f733,0xdf9fa1df,
	0xf36d9537,0x4e69a177,0x9d3df889,0xf2ad787f,0x4129342b,0xe1ff7a55,0xa8bf209f,0x73817fb7,
	0x2f677ac9,0x83273ce7,0x5ff12b57,0x3b7d045f,0x4c995eaf,0x6df7ddeb,0xe9979555,0x01ab5a59,
	0x321d54cd,0x80ab0ba3,0x5fe3a10b,0x4bbd098f,0xfd35e653,0x7cad6adf,0x196f7bad,0xff0d1af3,
	0x680d65bf,0xe789f3f5,0x9237823d,0x919f857d,0x82bdc3d1,0x8bf56fbf,0xf4a7a681,0xdb1bbb2d,
	0x0c3d8497,0x9ad114a5,0x428df40b,0x85d3560f,0x6b73d463,0x6c214393,0x1e21352d,0x1fc3e533,
	0x482bbcd1,0xe01564ff,0x3305b80b,0xcb8dd9b3,0xc41979c5,0x6003e5e5,0x3f413389,0x917b93ad,
	0x53dbee67,0x7f6954cb,0xbc45cc57,0x507f8f4f,0x37f33a2d,0x3ced9ebf,0x27e939ef,0x4f33b1c7,
	0x95cd6dd1,0xe35f6c55,0xed6d0b8d,0x6cd9b64f,0x30c16057,0x8ab19eab,0xee790d39,0xf25dbb29,
	0xc307a409,0x3905ec67,0xac1fccc3,0x034fee9d,0xf6c59b7d,0xa3a19eb5,0x0fd53ec3,0xaeeb5bfd,
	0xff09ae8b,0x8ff36e49,0xd47d8397,0xa113d8a3,0xd0c39f59,0xd48f8063,0x8f5fcc65,0x735110ef,
	0xfbd3ff51,0xfa3583c9,0x5929601f,0x9dd7b549,0x23fbc425,0x7ccdedc3,0x16f7c079,0x087fc727,
	0x19e9fcd3,0xac63572b,0x6345eef5,0x3bcb05fd,0x942fa69b,0x2e2df95d,0x16ffd1db,0x31e77c4f,
	0x884da20b,0x1d894b3f,0x7275b937,0xc7a32ca7,0x23a3c7f5,0xccffbe3b,0xe65b03e1,0xcd7bde93,
	0x647f1e75,0x273d9b4b,0x7cd7e47b,0xb88f0baf,0x53172def,0xb019ffe7,0xe26d4669,0xf3adec9b,
	0xda85760b,0x2591fb19,0x0f0fd2dd,0xd045a601,0x41cd02bf,0xc0cbca6d,0x8f1715cb,0x17719593,
	0x44dd2145,0x171536f5,0x6c41c2f7,0x3af3bf07,0xcd893521,0x9ae51253,0xb6b71ae3,0x26355923,
	0x4c8dad1f,0xbcdbd3a9,0xae0b6fe1,0xaf4b7aab,0xb28b184f,0xacbd54a7,0x8a35cb09,0xa7efe775,
	0x09135b11,0xba77ae7f,0xe493b137,0x8e83fd57,0xab950403,0x572136ef,0xc0ef0817,0xdf0fc135,
	0x2073c115,0xb5fb9d3f,0x36791b13,0x04490bf5,0x91ebf479,0x0d672739,0xb8c9c067,0xe889d78b,
	0xe72d69a7,0x77f50e35,0x00df9e0f,0x26d1abef,0x7d4d2a67,0x755dfc0d,0x96238ed5,0xdbcb2c23,
	0x804773c1,0x0b7da829,0xf7672745,0x16cbc32f,0xe3fdcb09,0x87599475,0x63e15ab7,0xeacb7125,
	0xfd3f32db,0xde1fea67,0x4433404d,0x1f6db81d,0xbabf801b,0xae2977fd,0x3363f7ed,0x81f9a93b,
	0x7e19cef1,0xdff3ccb9,0xa7e5af43,0xd66511a7,0x94d317d3,0xe72176ab,0x3c8dc6cb,0x6847c791,
	0x5157e47b,0xa3855f67,0x999f16c1,0x3be51733,0xc3fb24ed,0xe215490d,0xfdc1542f,0xdf294fcf,
	0x13fb2475,0x7deb6b3d,0x670395e1,0xdaa370ad,0x787b9ea5,0x21533029,0x5bdff96f,0xc28df61f,
	0xd187f457,0xa6b71185,0x5433683b,0xe7cdc67f,0xe11380b1,0x19af958d,0xc2497c6b,0xa8e93f2d,
	0x23fb0e1d,0x57f96c07,0xbbd385eb,0x63156193,0x4b056b4d,0x527bab41,0x42e5af77,0x032d2023,
	0x53dd203f,0xee432d0f,0x2f01438b,0x36b1cb53,0x42154335,0x85890bcf,0xb6111171,0x3ccb9ea7,
	0x782b6db9,0x08a93f67,0x9563f235,0x574f6da9,0xb083d19f,0xbf2b5a43,0xdaaf6db1,0xdbb770e7,
	0x96696e03,0xa8bb6657,0x4d177f81,0xe42332ff,0xff116449,0x7e33e223,0x76237c11,0xa05f9d8d,
	0xc2996d19,0x528dddab,0x4ac3158d,0x46dd263d,0x35036d69,0xd3f3377d,0x744f80eb,0xa5b91bc1,
	0x3f3b2b73,0x2cb1f9ab,0x3987baef,0x53b312d1,0x181923bd,0x843dd6d7,0x0793ed1b,0x8135732d,
	0x9d557e0d,0x2035c725,0x9b03f2c1,0x695324a1,0x4c95227b,0x2561c53f,0xc8d3fdf9,0x62c55bfd,
	0xdc65ee61,0xf8afab5d,0xe75d5ca1,0x90ef8819,0x75390961,0x4035303d,0xd76f5d5f,0x34dd5ed9,
	0x8a6f5a65,0x84310423,0xad3554a5,0x9e3d0a23,0x53491ca5,0x70090ddb,0xf94bc1a9,0xbc6b74eb,
	0xe3f59499,0xb34bc7bd,0xb1ad9369,0x4f6bb829,0xe687e505,0x82afbca3,0xbac78daf,0xb8e5a7df,
	0xf3f903f3,0xb91124f7,0x1067ce07,0x6d2d8015,0x8d31cfb7,0x9877a3a1,0x8ec770cb,0x043bb1dd,
	0xb3fb43ed,0x2b132319,0x5b875619,0xeab3d051,0x240dce79,0x4437d25b,0xeead06d7,0xb2df9d91,
	0x2c01c483,0x216341ef,0xbbabb9b7,0x05b137c7,0x265bf781,0xab3da0df,0x7a59782f,0x33c56623,
	0x92896a2f,0x569519c3,0x0ff7637d,0x665905df,0xcddf258d,0xa55f4fb5,0x182f19ab,0x705b973d,
	0x6c972de9,0x47b9fb5d,0x0e0f3a85,0x3f5dea87,0x32d997d3,0xdceba7e7,0x150f0ca5,0xec97ed0b,
	0xadadbd2b,0x54639009,0x62114269,0x6ded9625,0x6c0b9211,0xeeb79aff,0x445ddef7,0xe6e9f435,
	0xd7cd19f1,0xdea3798f,0xcea33b41,0x99bd59a5,0xaeb7fc7f,0x8a11e307,0x1ffb2afd,0x7843a9e7,
	0x1b793ab5,0x6b0df23b,0x4ce541a9,0x54ffc671,0x6ea103d5,0x90cda28b,0xe849378f,0xb4191bc9,
	0x77b1aa6f,0xc0b16cd7,0x2c776ebb,0x3c634e73,0x7e0bb951,0x373d0491,0xc42b9807,0xc8590805,
	0xd9f92899,0x092334ad,0x337f7811,0x171de415,0x2db3b2ab,0x2435dca7,0xe101cc3f,0x1d797d47,
	0x3e53492f,0xf0730d85,0xbe9d4fc3,0xf6df9a41,0x6cdfaa1b,0x910346d5,0x92afe093,0x76697ab7,
	0xcf4114ab,0xc533d3ab,0xe0f3c46f,0x57db4461,0xe94f1e5f,0x697b47a5,0x73950ddb,0x109b8fff,
	0x05c5a805,0x98771be7,0x8423212b,0x40c1165d,0x2f47f2af,0x6bef6c21,0x84975973,0xc4037d4b,
	0xc95fd4b9,0x5dd1d385,0x884fcd91,0x62c544a3,0xc9850ec5,0x493169d3,0x4d173531,0x2311d345,
	0x9015c0bf,0x0b4fe04f,0xe41bedbf,0x3997a419,0x6151fed9,0xc493bec5,0xfaf51f73,0x9ab59313,
	0x7e658691,0xb989c08d,0xc4a5024b,0x2b6d4a2b,0xde6793a9,0xd3e75183,0x82934311,0x9265ce63,
	0x8753d52d,0xc38b2b0b,0xad918851,0xa8f52cc5,0x870d826d,0xbf7f1113,0xbed71765,0x8c13475f,
	0x8c619007,0xe6edaf13,0x9903996b,0x4d63c24d,0x200304df,0x422d9503,0x911f004b,0x442d10af,
	0x7d916f1d,0x63bb546d,0x17998bb3,0xfe67a1af,0x0c8b7939,0xa941bd5b,0x014dee1b,0xd1a92d7d,
	0x79639ee9,0x1c8b3b65,0x707991c1,0x0c352253,0x6e690233,0xf49152a5,0x5dc5fdaf,0xc5f73175,
	0xecdb6063,0xb66f3cc3,0xc1435ab1,0x517ffc27,0x45dd270b,0xf66da5eb,0x5b691861,0x4d09e0bf,
	0xb37da907,0xb8f789d3,0x1e19b21d,0x5377e793,0x91ab7379,0x73a530b9,0x3599940d,0x4d51d005,
	0x3747c2cd,0xae374c5f,0xb19b201f,0x61cd3d7f,0x6f1317b7,0x438f3515,0xce39d30b,0x87c30473,
	0x90bbec31,0x42bf46b1,0xdcef894f,0xb6b59759,0x39d7887f,0x6ff95d8d,0xcda9e435,0xb7cd93b1,
	0xa6dff82b,0x65a17391,0x57b5cec9,0x96df6f07,0xac391f0b,0x55395d29,0xc2cd22e5,0xb36543eb,
	0x4f33ee37,0x6871a649,0x500f6e27,0x7181bef5,0xfefdb915,0xc21d8f73,0x4307d6f7,0x8afb2bc9,
	0x6db7aa4d,0x1f3f2aa7,0x8aa12183,0x0049a20d,0x096358d7,0x17fb9875,0x0a37d4c3,0xa9835275,
	0x14ef7ce9,0x009f64f1,0x82897f77,0x676bf3b9,0x612fc50b,0x6aa104b9,0x1abf1d23,0xf46b4f9b,
	0xa5ddcb05,0x45a171f1,0x896b9b1b,0x5597efe3,0x7a9f28eb,0xa063e949,0xdd857d73,0xeba9eb63,
	0xf003ae19,0x09d9c6f5,0xe76ba40b,0x2401d2f3,0xc879b431,0x921583b1,0x41e52f8b,0xc9adbe77,
	0x5161941f,0x6b57d1c3,0xfb278661,0xf65b79d7,0xdbff3b17,0x2b05d9f7,0xddc779c5,0xa369d203,
	0xd67ddf93,0xaaad98a5,0x59c58ab5,0xdad701f7,0x84f1d657,0x89075aa9,0x0d894efb,0x884f3fb1,
	0x5a55876d,0x4aef5a67,0xeee3f625,0xea25693b,0xf191832b,0x1c6d7ccf,0x140dee89,0xa253d1a7,
	0xa66db729,0x31af2e53,0x1ca7aa47,0x67792e0f,0xcea1c34d,0xc8095ff3,0x3ab78445,0x55e3a293,
	0x92c76ec1,0xc6fda433,0xdbb1c537,0xe085ef5d,0x67653cf7,0x012d6c1f,0xf169c88f,0x61f5bd9f,
	0x25e522ad,0x156b644f,0xdb23418d,0x4d790c91,0xc59d5ae3,0xefabf1dd,0xee83a03b,0xfff9be73,
	0xb4c75be7,0xea0dcf73,0xa09f9667,0x3109458f,0xd18bec4b,0x8dd5ca39,0x4ee9bca7,0x03e37139,
	0x02f357eb,0xf4739ee7,0xa847575b,0xb8675ac7,0x71f3c4e9,0xc87df6b9,0xb5fd3ba9,0xfc21729d,
	0x6267a8b3,0xe6b18477,0x84bdd485,0xdb43ad21,0xac155cf7,0x9ef5416b,0x6d9f47a1,0x51a9cfc7,
	0xd3a7d4b7,0x9557ca6d,0xff23ba7d,0x7bd3de07,0xc3b37131,0x430fdcd7,0x8631b763,0x67eba661,
	0x25b5f6f1,0x1779f391,0x371bb261,0x86c56f61,0x5b11a2cd,0x391b0407,0xf699ae4d,0xbcd9c497,
	0x16135edd,0xe6a75b2f,0xc2c901c7,0x134b639d,0x92ef1787,0x77ef9a85,0xbc333c37,0x08e54911,
	0x70c13075,0xfef3d511,0xcecb2acb,0x8319dda1,0x2a8f1999,0x88dbcc5d,0xfae7fd7b,0x5f0342fb,
	0x30450431,0xfef14d7f,0x3e478c07,0xa263c0d9,0x9fb5b7bd,0xa7afae15,0x1d13baf5,0x4ca351fd,
	0x9d9d870b,0x47b36945,0xcadb0093,0xc7d5512f,0x4ea1652f,0xe2c1dcbb,0xf39909fb,0xf9b74641,
	0x704d1a7f,0x1cc925ab,0x24ad800b,0xf4a7d30d,0x921599a5,0x3adf1dd5,0xd5ddec6b,0x48b1c073,
	0xee577487,0xc445787d,0x125bbe89,0xf4872b5d,0xe355715b,0xc35fff71,0xc1c1709f,0xf683d1bb,
	0x0c3d3f9b,0xa6bbf005,0x910bcca7,0x7da97f89,0xfa214d0b,0xc20f7817,0x7ba5516d,0xbaa19bc5,
	0x8cffbab7,0x6f3b530d,0xf45db77f,0x50bdd579,0xecbb71f1,0xcf4586d1,0xae6d9633,0x66f9f0b9,
	0x22235953,0x2b5940dd,0x067328a9,0x58f7b39b,0x4fe7a9c3,0xf5cfd32b,0x0b7932c9,0x0801f341,
	0x8ba7636b,0x6b25d141,0x27ef0641,0xcc09c0d5,0x56e5e2bd,0xd3014d2b,0x6aada789,0x04abb689,
	0xb80f9577,0x61333481,0x6ff312e1,0x4a256495,0xf377cf9b,0xb6afcd5f,0xea6ba14f,0x3e65de39,
	0xe45dc073,0x02935369,0xcc238da3,0xfdfb66c1,0xf5e18793,0xc327b4cd,0x0f939973,0x31233e7d,
	0xbc1169d7,0x26d76f43,0x209dd21f,0xbcbf8fc5,0x2ce32661,0x0d3d8d03,0xe58975cf,0x13597bfd,
	0x79316b9f,0xa813c1d7,0x6805f871,0x2623488b,0x85bf6c41,0xbc43a809,0x1e2d28bf,0xf5f7abe3,
	0x043b9443,0x82d91d71,0xd37f7533,0xc4593a7d,0x2c395de9,0x2a0bc069,0x31e35119,0xe46ff3db,
	0x143346bf,0xf6398cd9,0xeaa9b97f,0x2c11ef85,0xaa91e497,0x02e7992f,0x7f8bda3b,0x04b52a0d,
	0x4e9b1a8b,0xa3c5f35d,0xaba9d2ed,0x1c7f720b,0x09896e01,0x65a99de1,0x6c899bfd,0xb7377523,
	0x67757ba3,0xaf91acc1,0xab1d0b9b,0x9f53ecfd,0xf0658c63,0x03a3828d,0x84bffabb,0xb6ebec49,
	0x41434a7f,0xe02d2d55,0x342b8a1f,0x28c14bc1,0xc4e39679,0x40a7e3b9,0x9a8d874d,0x39413727,
	0x0d057c1b,0xbeada1df,0x6873f193,0xb77bda45,0xcb4b4779,0x5305e673,0xe6d79f0d,0x0e2b2de9,
	0x6a3fb9ef,0xb6a18fab,0x60170195,0xf4b3e4ef,0x46595f21,0x6393d843,0x28fd0bd5,0xc01d7937,
	0x86f501f7,0x361d7481,0x49b9363b,0x541958ab,0x975341a7,0xada1cf33,0xc6e3a401,0xb405323b,
	0x3fa346ad,0xcdb166ad,0x8a7b6821,0x33e362e3,0x5df997c9,0x9f0149cd,0xece9ea67,0x495982a1,
	0x3f510f09,0x506fb4f9,0xddff6c61,0xfcbd1181,0x988feebd,0xf803cf1d,0xadf3ae65,0xfa094491,
	0x1f7f1685,0xf3eb86ad,0x7667b495,0x41dff2ef,0xc3d55841,0xeb7d8ea9,0x2363abd5,0x7a87a2b7,
	0x882ded1d,0x70357b95,0x1c57eed5,0xe0f7b615,0xfb0d0a8d,0x3ebd007f,0x8d192b0d,0xd9c7b83b,
	0x4fe19749,0x1fe14bfb,0x4eeda5bd,0x2239ca61,0x17fb0059,0x69998527,0x7179a0eb,0xa13730c7,
	0x9b992e05,0x200168a7,0x63cde067,0xd857ffb9,0xd2df98e3,0xb65f05ab,0xbd634ec7,0xf4cde887,
	0xfed97ecb,0x70239ae5,0xa71bc26d,0x8081268b,0xe27b37e1,0x61e59395,0xe43be27d,0xb2f98c23,
	0x9ba1ab93,0x125fa47f,0x7b772be7,0x626bafbd,0x1c11e591,0xbb7908ef,0xffe31663,0x94af38c7,
	0x4277cad7,0x2b41dfbd,0x7a015971,0xb0474cbb,0x9365eeab,0x44efa845,0xf0bb5157,0x4d5d1c1b,
	0x92598793,0x21e1df6b,0x925f8425,0xa6c58f6f,0xbab78467,0xd299bc9d,0x7da746b3,0xaaf91449,
	0x18cdc141,0xbfcb0ed1,0x2ab1819d,0xad198a43,0x82cb5c83,0xab4b3985,0x7407964d,0xb5f14ffd,
	0x71d12bd9,0x511551bb,0x3f9963f1,0x74f57021,0x7ae15137,0xa8535b05,0xc7bf6c83,0xd13bee5f,
	0x67e7efd7,0xc451a473,0x843919bf,0x1a893471,0xf0bb013b,0x558545a5,0xb32f222d,0xda499f1b,
	0x14154a33,0xca8fbbc1,0x82330e1d,0x448b2b21,0x109b6fcd,0x1133a675,0xd73bdca5,0x49094257,
	0xfddb2c67,0xf761a4f1,0xb9a9c8a5,0x4429a899,0x0545a4a5,0x2c2f52f9,0x5b452dc7,0x4ff188c3,
	0x3b39dc71,0xe0db65cd,0xc13d8d75,0x3515a1c1,0x17f94bfd,0x09cbe93d,0x0d2db3e9,0xfbf19383,
	0x90b394c5,0x3f8d9c9d,0x6613fd23,0x1d854c05,0xd07b568f,0x3fd96fcd,0x8157b9e9,0x547b9447,
	0x914b2461,0x0e8b202d,0xcbc9b4cb,0x0e27bd4f,0x150b9993,0xb6abf5af,0x32a3d721,0x7b816d33,
	0xbe838ebf,0xab659fc7,0x8c83ee07,0x422d8c09,0x4a6b6ec7,0xc9133271,0xa2758f67,0xcd7550f5,
	0xa85dabd7,0xf62f4333,0xd8e51ef1,0x3f4d6f1d,0x73dd5463,0x6461261b,0x78adf319,0x014b62b5,
	0x0d59c825,0x71794abd,0x980f9a21,0xf5b5ddf5,0x53258d21,0x286bb937,0xa3af3f0f,0x4873561f,
	0xfa7d44a1,0x6257af2f,0x87a12eb3,0xe019b07b,0x8883c03b,0x87815ccf,0x785d7ca5,0x6edf0f5b,
	0xeb4736c7,0xf059c1d1,0x5bc1c841,0x23a9bf17,0xb2bb996b,0xe673aa6f,0xd21721b1,0xfb014313,
	0xe9bb088f,0x4591cc6f,0xdf0f0ee5,0xb01b82b7,0x8f0d68e9,0xbc97041d,0x32c1b091,0x4dcd1673,
	0xae5b1875,0xae93b151,0x12ad0737,0x5f9bb4c1,0x193bc373,0xb3bb3467,0xe2bb581f,0xc2b3bf23,
	0xc0275971,0xba6f8b43,0x4e3db255,0x16e1ef21,0xab872241,0xc8350e55,0x10e993b1,0xcfa3234f,
	0x94a5f2ff,0x5ab94d8f,0x5fe1add5,0xe51d4c43,0x1eb5830d,0x68d30d6f,0xf2adcb25,0x2515799f,
	0xafd3e117,0x038363fd,0xac3bd3d1,0x23ff070d,0xea050811,0x96ebf5c5,0xe3e7f2d3,0xcdf5e93d,
	0xc4359435,0xcb5b52d9,0x4e6fdae7,0x97b91aeb,0x43399807,0x064b73db,0x86f92b95,0x4fb729d5,
	0xd2cd9151,0x8b5956ed,0x381bf62d,0x8f01e3c5,0x3e957e29,0x3d47bcbd,0xe4c962c5,0xca4f238f,
	0x4b1d11e7,0xff090581,0x5163753f,0x0305be09,0xeed90a31,0xb4b32df7,0x8cb5f23f,0x182d8f17,
	0x2b27a3f1,0xe481ec61,0x98eb6437,0xb779a69f,0x85493059,0xf7dded8f,0xb49f405b,0xee439595,
	0x1f6bc9e7,0x1c5331d7,0x43d12bad,0x5a8ddaef,0x71a3295b,0xc4998a13,0x58eb5ff5,0xfc0370b3,
	0xa2ed9ac3,0xc98f34ab,0xddbb30bf,0xa4f778e7,0x822d1271,0x2b399a8b,0x5c79b063,0x0b610a9d,
	0x1f316201,0x71c72c29,0x68c97503,0x79e51eed,0x03a98d55,0xae8f5e81,0xa8af7d83,0x20cd9dfb,
	0x0c353f99,0x1d0fc819,0x7d9b3695,0x07098bed,0xe1576041,0x63ed5dff,0x4d699fad,0x9b3755f7,
	0x107bc807,0x75f9d0c7,0x6b57900d,0xe4993f51,0xc4f915ef,0x1325098f,0xa10f1bbd,0x5417ee3d,
	0x2109a445,0xe993c6fd,0x579d1889,0x35431903,0x36d19d99,0x56895a3d,0x607dc309,0xbf5952f5,
	0xa15d31cb,0xc7758403,0x5e8f839f,0xc63bf96d,0xbda3eafb,0xbaeb718f,0xcf1bd36f,0x0b7140cb,
	0x837d2293,0x61abd9a5,0xb2cf416b,0x2f316179,0xfeaf964b,0xdf9d3993,0xd6c79747,0x4153e4e7,
	0x67e71d19,0x2ccd322d,0xbd811e85,0xf259128f,0xddb77c45,0x967104d1,0x27e5056d,0x646f7cf3,
	0xbd9f5c57,0xdfe73063,0x3e43e40b,0x9c65ae9d,0x9cff5e23,0x03b72e53,0x59556137,0x92b7f71b,
	0xe2254fc5,0x948f4f93,0x6b39f793,0xe4875809,0xfd47819f,0xbe45b9a3,0x087bda83,0x249f9209,
	0x417f3b5f,0xe6d78387,0x1107fb39,0xcc6f51c1,0x5dd150f3,0xef6bf2cd,0xf9372dab,0xcd157ce3,
	0x762bd79d,0x154fd887,0xb2cb6d97,0xc0519f2b,0xdc61fadb,0x72f90e57,0x35ed4385,0xb98f7757,
	0x692df179,0x2109135f,0xaa2b49c5,0xb6dfa433,0x7537128d,0xf745c94f,0x2f7dd16f,0xb1fd718f,
	0x72070a6f,0xed995159,0x4745a761,0x5149c543,0x23152fc5,0x1d1d093b,0xdd4bf941,0x38d12c31,
	0x76bbf879,0x6111a83d,0xf0bf5a81,0xfb450745,0xff3f8ebd,0x97d77c29,0xdd39e955,0xaafdd86d,
	0x0bcb860f,0x83ffc657,0x43b993bf,0x0affafa1,0x6175b031,0x4d4138a1,0x93a77c87,0x5ff5b7e7,
	0x9439122d,0xa17b926f,0x33d58039,0xe12fe445,0xfff9f957,0x75b15dad,0x4b79da2f,0xc9a9bccd,
	0x6185304b,0x6711cbd1,0x2b35e985,0x09034b99,0x0f8f53eb,0xbbf5b2d9,0x560f1627,0x948b29c7,
	0xd3b34865,0x04d9aa47,0x2a7bd5bf,0x582fac85,0x6377ce29,0x5d61482b,0x2b4dd0c9,0xc78d3201,
	0x794536f3,0x4d5f7e19,0xe8c92781,0x0ee58e75,0x8d733ac7,0x49c91631,0x8995d6f1,0xe4219923,
	0x2f3decf1,0xd5b95013,0xf3c13de5,0xf7d5d955,0xfdc7d101,0x437b9df1,0x95c7c1f7,0x063b5359,
	0x411d0fd7,0x1579817f,0xcf859483,0x8833758b,0x2333cc93,0xff4b88f9,0xfb4797b5,0x044b254b,
	0x88e599a1,0x86af6c25,0x16b96377,0xffb1ec03,0x8af90db3,0x448b4951,0x0bf56a85,0x8f414423,
	0x8f1978c7,0xc5ed0251,0x9a7b3f5b,0x887f0627,0x00ddb91d,0x0d0db983,0xe035f943,0x5295f58d,
	0xaabd3045,0xb2476ecd,0x8271b949,0x57536ddf,0xaf1fd80d,0xa523bc9b,0x76e74f47,0x14332fb1,
	0x214f7793,0x8d4fb4e1,0x6cb9fedb,0xcb594d99,0x3e81f839,0xcb9fde1f,0xd56f646b,0xd4913939,
	0x46d1daad,0x1b135059,0x8df97a29,0x8e49f03d,0xf645cbdf,0xd1d3f21d,0x27afbd09,0xee9d4951,
	0x9dc95a0b,0xc22bd57d,0xd15171cf,0xb4516133,0xdc2fc9b5,0xbb91b51b,0xe00709fd,0x37cd27a1,
	0xf7370aa9,0xaba3911b,0xf863a8e7,0xdc250c67,0xd481ccf9,0x5f296c27,0xd75bc89f,0x2013cc55,
	0x929bb5ff,0xe3112877,0xbb51ff09,0x4ef75e45,0xc1f9b561,0x857184c9,0x6d0be2cb,0xd1dd0015,
	0x3df97a09,0x76873961,0xe8bd1051,0x207763b3,0xa5dd072b,0x09b9350b,0xa6fb4ed7,0x5221fc0d,
	0x75d36941,0x9695fa1f,0x85c9d559,0x4ed96a1d,0xbfed8b0d,0xf9d31b77,0x518bafa1,0xa04d09e3,
	0x852b2a9d,0xb64fd97d,0xee17433b,0xe2cf9f6d,0xae6dee45,0xb60fdf19,0x1fa1f481,0xd65723c7,
	0xa581999d,0xab451ec3,0xf3c9eb91,0x0f8bb20b,0x8e1d6289,0x1143cf77,0xca99f951,0x48b1945d,
	0x1edb6637,0xcd8989bd,0xff819c73,0x52bd70e5,0x1a3f3e17,0x70bd849f,0x3259266d,0xa64996d3,
	0x67b7b4e5,0x17aff2b3,0x3063007d,0x94996b63,0xcc979ba7,0xec537f19,0x7d4310ad,0x1895f6d3,
	0x4519bea3,0x46c7ea73,0x7c0d3ec9,0x47cf916d,0xfd63fa71,0x6e53c7ef,0x3839196b,0x6385b083,
	0xea8370eb,0xfa655a43,0xcea59af1,0x8995d36f,0x036bde33,0xd39390ab,0x769b0e81,0x058b9093,
	0x19f70db5,0xd49923ed,0x2ac9150d,0x4199c255,0x53eb6f23,0x0b61d357,0xf24bca4b,0x5799d427,
	0x43f5cb7b,0x99f7c1bd,0xc99f09b9,0x420d2f85,0xa2a919ff,0x3791f27f,0x2badd3a1,0xad21c8ed,
	0xa7837539,0x518fe67d,0x3ac7d20f,0x67a7cceb,0x01e52fff,0xcc755929,0x89a3fddd,0x74176d0d,
	0x721f0a69,0x64f51d77,0x846363a9,0xb995ccf1,0x026386db,0xb0e11ae3,0x798d08db,0x54eb0f33,
	0xdfcd5f03,0xc0396a73,0x4313f0a1,0x898b827f,0xd36318d1,0x5e2393b3,0x8f4f40f1,0x528fee87,
	0x5b0fbb83,0xf1ede9bd,0xc9fd878f,0x93b90103,0x62a7a499,0x000f0827,0xa5491efd,0xea75dab5,
	0x9ce77ce1,0x4b25701d,0x42c3b38f,0x1ed3bc65,0x7c714d6d,0x94f74549,0xfc5fe859,0x348fd3e5,
	0xccd5b497,0xff732adf,0xcd831c3b,0x1c0b290d,0xeb853b05,0x0dad409f,0x5bf34edb,0x0351aac1,
	0xa0dfc8a1,0x44e53fcd,0xa0e125ab,0x47135be9,0x9923399f,0x6d83b835,0x31e510e1,0x03aba075,
	0x7d831379,0x74136d2f,0x29ff907b,0x461baa5f,0xad0f59f3,0xea4bd297,0xb2999943,0xdd0f06a9,
	0x95c58417,0x2809a9d1,0x2c8119c5,0xc9d74a5b,0xad89913b,0x0c57becb,0xf8ef9f5b,0x516fdf87,
	0x0b273df7,0x5e5fc4fb,0xe2851b23,0xad79f247,0x9f53592f,0xce79545f,0x264bc705,0x5d3f7dbb,
	0x0da93911,0x9721067b,0x1cb12aaf,0x16b1790d,0x25af500d,0xbe01b35b,0x828d4099,0x576d246d,
	0xfbd1e1e1,0xf4e7ce97,0x6223bb01,0x95b57617,0xa261d88d,0x1ac5e449,0x9c1968f1,0x116fa749,
	0x829db95f,0x5cbd3619,0x1081bb35,0x4531e14d,0x55a9b9e9,0xf7157833,0x67d16967,0xf7350a77,
	0xbd91f507,0x9639ae4d,0x7beb36e5,0xea5db31d,0x7e4bbfdb,0x57c128a5,0x6115d7d7,0x2f3322a1,
	0x56af1ed1,0x6b6da0fd,0x0f03f62b,0x14e7846f,0x79855a9d,0x541f77a5,0xa9c95699,0xba5734f3,
	0xa679b539,0xc8e91071,0x6aeb1d9f,0x3f032eab,0xe31f3ee9,0x35fd4fc1,0x2a4d3487,0x94179715,
	0xd3f1cb37,0xddbf3777,0x8745ce5f,0xed636bbd,0xb55505f9,0x99b1a401,0xb1850cfd,0xd2634f33,
	0xf497a847,0x3b832953,0xd233c601,0xcf37760f,0x68edcd85,0x8e090fed,0x14d367d1,0xc5adb3f5,
	0x2c716861,0xf64571d5,0x5057fe9f,0xde33a88b,0x1527d7cb,0xb45b7793,0x50175961,0x18e70c85,
	0xcdfd9c01,0xc499b543,0xbcd34ed7,0x7e891e9b,0x8fc52b83,0x6075a77d,0xa5b52287,0xf185308f,
	0x7a3fe81f,0x1f8f5067,0xa94909bf,0x9eeb5429,0x8d0b33e7,0xb8abf4b1,0xbe8dd099,0x0f75283b,
	0x40b9a637,0x62bbf88f,0x9ddd9ef3,0xd889c59f,0xbfb960b1,0xd5d1dcbb,0xca03dd75,0xed2dcc35,
	0xbf6b8443,0xec2d5b7f,0x392d3a8d,0x8f178fe7,0xf913c61b,0xe335a5a7,0x9df7cf73,0xdf9d65a5,
	0x42db24b9,0x3c77bf87,0x505f6525,0x10c51069,0x48d7bcdf,0x3eabfdfd,0xd6cdd96d,0x36394e35,
	0xe607be99,0x16ada36d,0x0f13a3d9,0xb6478511,0x1d4b8237,0x98859cc7,0xf7677abf,0x5aef9011,
	0xb273bd59,0xa0615e7d,0x1769183f,0x02cfac4b,0x6331d7df,0x1395e18f,0x89251f41,0xf23585e1,
	0xc02160f3,0x81a3c081,0xa2072073,0xc40f64fd,0xa5c7a40d,0x652d745f,0x3be9bf4d,0xfafb7acf,
	0x55935de3,0x0505b1c1,0x9e0df70d,0x32394e93,0x2ed5917d,0xf51fe5c1,0x06197fbd,0xeeb34a87,
	0x07c97d23,0x379bd307,0xd11d532b,0x0ffd68f7,0x2697af69,0xfdbd4ec1,0x449351ed,0xe14f0133,
	0xda493c2b,0x08f51da1,0xf7590863,0xca8db493,0xb3d3118b,0xabd9f0e5,0xdab993b5,0xa1437b79,
	0x5f116cf5,0x6b278355,0xe363a6d1,0x999fd24f,0x1bc9701d,0x3ec5d63b,0x526faf6f,0xd77d0687,
	0xd6a5d5fd,0x72c18e6f,0x9e5d1b0d,0x9f61a399,0xe23bc7d9,0x2853714b,0xfc17bbf5,0x27730007,
	0x5007d23d,0x76d701b7,0x87eb4e35,0x0887ea59,0xe96df9f9,0x2cd33d1f,0x0e911ca3,0x4f177621,
	0xc8b9f12d,0x30f97879,0x762bc5df,0x2c43e8f7,0x921f6c39,0x831b5d41,0xc7412151,0x46d7c77f,
	0x4cbb96c7,0xdd39067d,0xd5c14427,0xac45025f,0xdb93a8cf,0xf47b3dbb,0x8a07a659,0x61a7434b,
	0x16939b87,0x5a2bd811,0xc9d167a7,0x94c159fd,0x838dfe77,0xfcc33319,0x0147b497,0x6cfbc931,
	0xaf3fec67,0x48e1d1fb,0x4bf94b77,0x7c6973b7,0x264d206b,0xea491a61,0x3de12161,0xd0c3695b,
	0x0e432adf,0x2ceb3185,0x4c5f2735,0xa46dd3f9,0x5e95c665,0xfddbf921,0xd7392e95,0xaf710471,
	0xb9a14ceb,0x8c5b2c7b,0xd1a3eef7,0x18819fab,0xe5a94ca1,0x8acf9d61,0x0b312a8d,0x05f9eb9d,
	0xe5d93d03,0x0fc59127,0x18e7f357,0xced73c3b,0xb34953d5,0x16f33dab,0xde29101f,0xcbc98089,
	0x95f17a23,0xa2396653,0xb5cb8173,0xc821ef91,0x1db7613d,0x7a9d1909,0x3b0526a9,0x12d7d561,
	0xbb67b7c3,0x914b8b47,0xb27582e1,0x2f8f8015,0xf9b77e95,0x009b1707,0x1327a203,0x27934ccf,
	0x563f7ddd,0xad0b57cd,0xaf871dbd,0x7ad5d4b5,0xba89da13,0x864167ab,0x7e6d4289,0xb0ef39f9,
	0x94fdc8ef,0x680d3c33,0x041f54a1,0x8a2594d7,0x91ef6673,0x9b632383,0xdb3ff511,0xd05d808f,
	0xf49da9ed,0xf761613f,0xdde1a6a7,0xc82fc867,0x902d7af1,0xa24feb95,0xee7b72f9,0x41d134b5,
	0x60a7e657,0x7299483b,0x60efaf67,0x4a2777cf,0xc4037343,0xefd9896f,0x0385e219,0x7bbb3b19,
	0x531b9821,0xf3c96af5,0xc7ebc6ff,0xefbf4bf9,0x5ab34fa5,0xeb538f19,0x0c3d74cd,0xcf0de8e3,
	0xf479cdcb,0xb783dbb3,0x83f9a203,0x83272e4f,0xc00154d3,0x2e8ff71d,0xc10709eb,0x8739a3bf,
	0x3bc52a49,0x3cd7e53f,0x5cb7f193,0xd913e8bb,0xbe2bac03,0xa5dfc485,0xc0c3ccd1,0x0a3181d5,
	0x0e81851b,0x6557aae5,0x904b0347,0xf0b5c5a7,0x9df902f3,0xb015a2dd,0xb0d5d559,0xf869e9d1,
	0x60af8a37,0x9517c86f,0xf3556137,0x13bf2ffb,0x46a72bd9,0x3e83862b,0x5d1fc7d9,0x4cd132d9,
	0x54cf5a17,0xd2a7f227,0x10f571ff,0xf6615325,0x5dfbbd73,0xf4fb4afd,0xd801752f,0x7cdb449d,
	0x5be729b7,0xe71b94d5,0x4ad118b9,0xd74fbb0b,0x6837b2f7,0x49cd565b,0x9a5f7ab3,0x98793741,
	0x5575e28f,0x7e0375c5,0xf90954fd,0x9fbbf419,0xe8190c23,0xa5cf35cf,0xa399e23f,0x6a1df373,
	0xaf7dc29b,0x457352bf,0x8a3fe2e7,0x03552b39,0x7ee76d2d,0x84513f63,0x9993c22f,0x96bbd25d,
	0x8681fc53,0x0dfb820f,0xa395db11,0xa051cdd5,0x0c61bed3,0x932531a1,0xe8afdd59,0xbdc33da7,
	0xc58356b3,0xeaad927f,0x40ad5295,0x1f6129d7,0xcecbce4b,0xd29bd395,0xe3cd431d,0x99274f7b,
	0x4605cd35,0x511deb57,0xd3abfb0d,0x53b50da9,0x82e5ed53,0xb58994c5,0xe44fef4f,0x1d597283,
	0xf0072fd1,0x395d6c63,0x652dc291,0x5b036835,0x83f19221,0x413d2d3f,0x6a1b6a4d,0x994b01eb,
	0xda0dc301,0x3dfb0ded,0xb45773bd,0xbd77e8e3,0xebb1f773,0x2d8d3d8b,0x3b8d68ed,0xd671e95d,
	0x6919dfc1,0xbc0f80bd,0x56cd55ab,0x8dc99fa1,0xb269bc7f,0x04c7eeb3,0x858d6c8f,0x38bb4501,
	0x70ad938b,0xf327ce1f,0xd8adcbf5,0x89279cd5,0xcedb8503,0x43c19241,0xfb796307,0xde9b0181,
	0x52cb4057,0x2555f7dd,0xdc9df6b3,0x3745916b,0x56459937,0x79c9423f,0xf73346b3,0xc1037c07,
	0x1ff53c9f,0xb72b983f,0x3bbd5281,0x0a556ecd,0x9c6d85d3,0x68b38137,0x991fbe6b,0xd365223f,
	0xb72b735f,0x4fbf8211,0x25ad5879,0x7f0706e5,0x5393bc15,0x24d1da35,0xe81fbd89,0x23b51253,
	0xe5f10411,0xf89d609b,0x40931e35,0x3c91ac1d,0xac7b31b5,0x34f780c1,0xf19323e7,0xfa63bae9,
	0x8849e2ad,0x3ddb57a9,0xc90ff5cf,0x349fd15f,0x766500eb,0xb273f0e3,0xe95f5de1,0xfa617b2f,
	0xa8b577ad,0x4e0ba385,0xb2430ddf,0xc369aa15,0x3f130875,0x69198f29,0x49e3044f,0x412142cf,
	0xa037400d,0x1a3d38f7,0xc5d11181,0xcf9dca27,0x72c78b8b,0xf73b489b,0xf4037c8b,0x869731f1,
	0x36516d47,0x7603654b,0xc3dbc84f,0xea6fc603,0x7c45d1e7,0xedab32c5,0x4f219871,0x3d31393f,
	0xc1038553,0x37716e4b,0x8305b661,0x6f91d28f,0xe4cdc7c1,0xefbb2bad,0x691d3659,0xb1e5b9e5,
	0x44d102ad,0x5717323f,0x106dbc55,0xa5336539,0x74239dd7,0xd33d79e1,0x165be11d,0x2c23258b,
	0x94bdf44d,0x1009c7f3,0xcfb7b741,0xdc09d3e7,0x50876961,0xc0836c67,0x11bb7017,0x0ddf9e5b,
	0x72499daf,0xffd71eb1,0x9b0720bf,0x8f45f505,0x1ebbc419,0x525ffacd,0x1ca1a723,0xf3879701,
	0xad7716cb,0x46959e41,0xe2fbaeed,0x8497bf7d,0x22016c39,0xb621651b,0x1eefd697,0xd41172a5,
	0x44c7ec1d,0xa6d3c6ef,0xceb9f461,0xec33eab7,0x5c1de479,0xcb9fd3db,0x47057b53,0x20ed24f3,
	0x853fbe9d,0xa5a5d185,0x5be10039,0x80cb8ea1,0xad4f1417,0x4529f817,0x29c5deab,0xe60dd213,
	0x2a5de3c7,0xaa9b4f4b,0x7e93fe09,0xa791c3a3,0xf45be6cb,0xc78fab5b,0xe293b67d,0xe9e36eb1,
	0x7e250593,0x1fc7ca0b,0x4175d5f1,0x903542a5,0x2e7feccf,0x0a278fad,0x3351c521,0xcd615ff3,
	0x7919c27d,0x91bd6413,0xe5a7cc89,0x54eb0515,0x9781fadd,0xf6c1af9b,0xa4617971,0x2bfb1b89,
	0xe2394d7d,0xcf8d7829,0x02cb22e9,0x1a65e4d9,0xc9a3ca2f,0xc9ad1e2b,0xa4a18ec7,0xbba1c797,
	0x6f0b0e0f,0x0acb3999,0xa703b6ad,0x2fd33c5d,0xdda5987f,0x31bf96eb,0xa979acff,0x6cc5dacb,
	0xe38d402b,0xf789542b,0x76f3a1ed,0x2ee9868b,0x8ac9c807,0x704b1de3,0x4ec70871,0x8a59bc4f,
	0x3243944d,0xec558c2b,0xcdb9db47,0x1bd9fecd,0x46d17f81,0x791f9f9f,0x76ef01f7,0xd9d163c9,
	0x9c2fcf6d,0x02475e63,0xdcf9d5d1,0x8553410d,0x66014a27,0x12919125,0x6ad1c6ed,0xbb1df967,
	0xd0d36b07,0x34eba01b,0xccd72127,0xa48de9b5,0x3b19b7b3,0xf56f9001,0xf9d1f129,0x48ad75d3,
	0x0e313513,0x82571f1f,0xdbf10963,0x7d3335ad,0x375bfc5f,0xed0d023f,0x99cf2709,0x77794235,
	0x40c9f00d,0x0b1d41b7,0x7f6d371f,0xfd7da263,0x0a8b90e5,0xf73db667,0x872fbb67,0x36edd837,
	0x239ff2ef,0x324da6b1,0x82e94f73,0x1e198dbd,0xc2e9d27f,0x64518383,0xe4d34d99,0x90fd6205,
	0x6035c931,0xbd79c553,0x288b93fb,0x023bd627,0xed39a2e7,0xf71be91d,0xdc1b697d,0xca1d5a47,
	0xae8dd2cd,0xf4b58d67,0x48f382d1,0x17957a8d,0xb4b90857,0x04edaf3f,0xbceb276b,0x813d2c29,
	0xf529e43f,0xc2930739,0x7343768d,0x36573a55,0x032fcd89,0x95998673,0x1da3cc3f,0xcfcfd351,
	0x690be67f,0xd421f393,0x0d1d464d,0xc135356b,0xa0dd21b7,0x8371a7c5,0xfb27694f,0x69c57bef,
	0xadb37709,0xb8f76bbd,0x72a3e5a7,0xc5618c37,0x5483389b,0x9b4774bb,0xd8d77c79,0xbd9322a7,
	0xf52587d7,0x03218183,0x167704b7,0x1a8dffa7,0x0363ea6f,0xbc6d1763,0xe0979015,0x142934a7,
	0x1fe3ff61,0x6737df2f,0xa1bbb017,0x82e99123,0xd13f53ef,0xf8b52245,0x02c9daff,0xb0f92f99,
	0xdcef58a3,0xdc456789,0x1411f0df,0xcb292293,0x405b7651,0xb471306b,0x164de08f,0xf1f541a5,
	0xc9cb4315,0xbbe1d5dd,0xe39d6cab,0xea7d1665,0x5177d751,0xc671855f,0xf887109f,0x6f8fe975,
	0x927942b1,0xe21d5df5,0x1cfd0595,0x229bef7f,0xa3d52129,0x980bad2b,0xad576789,0x1cbb9635,
	0x11794ff3,0xcd894c19,0x83557a37,0x1fb1f14d,0x9539c293,0x450d1c5b,0x7f210e27,0x66e7478d,
	0x6fcf77d5,0xbf37a515,0xb04905a9,0x1873bfb9,0x61e38ecb,0xbbcdcff5,0x1ec7f9d5,0x56092da7,
	0x44fd7bcf,0xdabbc633,0x33f9ff89,0xee11ff2d,0x44955d87,0xdd1bed87,0xc3a98c6b,0xac91492f,
	0xb70571dd,0x4627053b,0xb5057bed,0x4c3ff493,0x9693ab03,0x9c476319,0x4ba93443,0x07730b4d,
	0x9a696477,0x4a095079,0x1093eb71,0xc92f2555,0xef9d37f9,0x1f258735,0x5b2b0c39,0xfe1df5ad,
	0x9229f297,0x7179ceb5,0x7a43bb2d,0x0591f75d,0x45f5a9a5,0xde09b8e5,0x7d117ba5,0x42853a75,
	0x2fcbefbb,0xaa037f3b,0x9c37f4bd,0xcc9b5113,0x0e5f29bd,0xc3c1ffb3,0x42bdd661,0xc11b5c55,
	0x134d03d7,0x63bfd9d5,0xb711de3d,0x33fb3963,0x5c1b067d,0x4da1abab,0x640ffcc7,0xc0d1ce73,
	0x0b334b69,0xb1396ecb,0xc1f39a41,0xbbe377b9,0x00eb52a1,0xab7df553,0xdf69fbb3,0x031b9479,
	0x347ff76b,0x678786e9,0x8a7fc7e9,0x6f0933fb,0xad13855f,0xdfa39db9,0x19afac7d,0xe3e7e291,
	0x1ab1ed55,0x3e3bc379,0xd4d922cb,0x029b9695,0x0f511a73,0xdee78e65,0xfe4354ff,0x79abbd67,
	0xd7cf6723,0xef65be43,0x7b9f2305,0xf64b6871,0xf4ed3219,0xb09b7961,0x1f054793,0xb5579a23,
	0x3457934d,0x5797a993,0x8ff79d2d,0xb44fb2f9,0x69a33107,0x8e917937,0xd4598315,0x825dfe71,
	0xc74d34cf,0x95e5f033,0x797f625d,0xb1556017,0xd7b9607b,0x051bb0f1,0x5d2152dd,0xe6b12079,
	0x16334323,0x2be1d56b,0x165de033,0x8c91da33,0x27f18e2b,0x130bec1b,0xfebdeec5,0x22c186e7,
	0xb50b8a3f,0x1d991507,0xdb2fc0c5,0x2fb3ac3b,0xe189ac53,0x49b33ebb,0x250f1b29,0xd183a8e3,
	0x66574aa3,0x11a5834f,0xf31b8aaf,0xeef12195,0x4a4771af,0xece5a55f,0x827bc8df,0x08678e17,
	0x3b17d945,0x7111ad0f,0x5fc1410b,0xa8f9e62f,0x866bf975,0x12f3a50f,0x2fe3b545,0x775f6eaf,
	0xb2d13f9f,0x87737791,0x19430371,0xe6fda66f,0xb8b96363,0xc4adeb55,0xcca70a35,0x88df5353,
	0xdb83dbad,0xa2ddc09f,0x2e43adff,0xfcb3af41,0x227173af,0x1d69ee3b,0x9eabfe05,0x81d5b52d,
	0x71b1ffe7,0x33dffe81,0xe3e3794b,0x28498e0f,0x43553317,0x6af78c4b,0xb2517393,0xa1b71de9,
	0x005b9349,0xed8de001,0xd5c59a6f,0xb273b0c3,0xf9a98ed1,0x4da7ac91,0xfa799a37,0x4275c7af,
	0x0107b14d,0xe577ec6d,0x160be309,0x0e6105c7,0xa22df89b,0xd84fde93,0x70858dcb,0xf8813d2b,
	0xfbb349e9,0xb3af238b,0x4d59612f,0xf9c79c03,0x382306ad,0xb03dfa5f,0x345bf6ab,0xb2cff985,
	0xa6e5c19d,0x92c99da5,0xdacdff7d,0x9cd742e5,0x754d13bf,0x2d47c07d,0xac57a9af,0xdacd0867,
	0x079b915f,0x7fd52b89,0xf40b250d,0xaa432a53,0xf1efdf0f,0x79bb79f7,0xa5614831,0x7471a5fd,
	0x9159e6a9,0x5a67f67d,0xc5375579,0x7f3b82bb,0x44c92c53,0xb26f9857,0x72d7e00d,0x3e2bdeef,
	0x46214377,0x048f204b,0x90f1d0d9,0x43731d03,0x231f63c9,0x06b155a7,0x0e9b8b99,0xd0ed3069,
	0xd6731e43,0x82e1633f,0xd05933cb,0x091d0a97,0x80b13229,0xd8555471,0x391111b3,0xc02b2811,
	0xc1538205,0x1c6db223,0x53151765,0xece93d61,0xafc128ab,0xdbaf3fc1,0x991b85b3,0xb9d30417,
	0x7445ae39,0x7ac7d841,0x5f45b141,0x360b27cb,0x81135d0d,0x378d6b1f,0xdc19e775,0xa65b5321,
	0x6b47b6d7,0xc9ff1961,0xd18b737d,0x76355cbf,0x63e50987,0xa5437293,0xd5efc351,0xc8b39459,
	0x50dd2459,0xd8a7d1cd,0x3d09acaf,0xa9992fa7,0x85ff2cd1,0x90a3daab,0xa0ffd221,0xde4fd769,
	0x1e0793bb,0x37d31653,0x0b6127f3,0x56e7546b,0xf39d2a29,0x37ffb06f,0xbe29993f,0x3f1d5c7d,
	0x3a4b5677,0x5b155439,0x9cb5cce3,0xaf537f79,0xb7856947,0xcc29296b,0x34cf0a85,0xfd93343d,
	0x9ba71285,0xb87bf14b,0x67a73f97,0xae8d05b7,0xfaf7f665,0x907343a5,0xb2d5244f,0x069fdfd5,
	0xe6a16261,0xe89debd1,0x195b80ad,0x3acb7c91,0x25b7223b,0xfaaf65ab,0xac9d9175,0x41b9f0ed,
	0x8e377503,0xc6897a97,0xb56f8d3b,0x44bb59f1,0xfe032207,0xd32ffe83,0x7d074953,0xb0cda9b1,
	0xf3ebade5,0x8fd1ace5,0xb607fedb,0xe7919441,0xc8a3af81,0x54c525bb,0x85772fbf,0x904f9cc7,
	0x87c34505,0x04870a89,0x2bc7abab,0x88fd426b,0x68d3a8e3,0x4cc13b5b,0x4dcfb517,0x77334d5f,
	0xe83fe6d7,0x874133c7,0xddcf4641,0xf9333bd9,0x8059b0e7,0x3af987ed,0xa46f7633,0x76e9cf1d,
	0x025f545b,0x3d0b816f,0x69bffdbb,0x92e5b875,0x8f75cec7,0x71bddc7b,0xbe39dc6f,0x3b63662f,
	0x31a70305,0x2d7ba4c7,0x63bd1dad,0x5b45f0a7,0x14e90e3b,0x35dd3291,0x5693bda1,0x2b13273f,
	0x6019bcd5,0x62a3479b,0x7669ae37,0x2203bd5d,0xadf91f81,0xdeaf4c35,0xcf59fc27,0x86ed9775,
	0x2637403f,0x0913ac33,0x82e513f1,0xa15337fd,0x3665f751,0xf60353f5,0x50f326d9,0x8a5f4c7b,
	0xeb03e043,0x8fdd4d5b,0xc0d3aff3,0x9de55a75,0xe8716ee5,0x58297cd7,0xea3f1913,0x8b5f8c7b,
	0x03fd2455,0xc8957e5d,0xde557fd9,0x06ef9f2b,0x7cdde3f7,0x53f5a269,0xb09f9aab,0x1a5dee21,
	0xd5296875,0x074b0b03,0x200dbdbb,0x161fa10b,0x4aebd8c1,0xcabbe8b3,0xdff70000,0x224df897,
	0xf10b7d19,0x4293d795,0x811d8037,0x6fa9bb7f,0x685d93fd,0x50495c41,0xfaa9c9e9,0x089dc383,
	0x389f473b,0x337d80dd,0xd3295a63,0x423daa71,0xc977c0e5,0x4af59219,0xe99545bf,0xcd439715,
	0xfb6d6057,0x759dfc27,0xde4ffbdb,0x670f2a49,0x60f90f33,0x138d47c7,0x1c1f2d5f,0x2aaf8bf1,
	0x1775b665,0xa703373d,0x8135d0b9,0x81d197f5,0x4025d321,0x15650357,0xa8274721,0xb5d32b45,
	0x19372be1,0x8841b869,0xd0f9a197,0x20b590db,0xb6bfa569,0xee4fb351,0x6a1105df,0xfe210eb9,
	0x5bb937c5,0x1c6b3e73,0x3941338d,0xdc6b92e9,0x73070345,0x8e9d4ebf,0x24bf28f5,0xad8d8079,
	0x28798587,0xc91360a7,0x9c2de837,0x78279c85,0xa1c1ee6f,0x5921752b,0xa1915c3b,0xa8851b2d,
	0xd77b9527,0x76492ecd,0x725d5daf,0x019bcc9b,0x0e2b8d21,0x432d0e9f,0xd06bd80b,0x2dff6a01,
	0xef3f5b1b,0xae9fd133,0xeaf70e8d,0xf0f70295,0x420bca15,0xf493eba5,0xe7ad013f,0xf76b889d,
	0x44cbe05d,0xbf29289d,0x0b9bf1ef,0x48ef7e5d,0xa5a3f485,0xe7a56549,0x843b0933,0x58bdc32b,
	0x1b9de269,0xd7776e5b,0xd06b1b6b,0xb6b5805d,0x9fb1602d,0x8935fd11,0xc9758dbf,0x60633657,
	0x45bb7339,0x299dd433,0x4c095b1d,0xb1fbe97f,0xb57b0543,0x5895fd0b,0x813f393d,0xf7536f49,
	0x43a39945,0x0a2b246f,0xc799dd9f,0x9cf1db2d,0xaac32083,0x079717bf,0x3bfb6287,0x00fd0bab,
	0x6459ef87,0x103561dd,0xe2b9cc09,0xe44b574f,0xa1c9d327,0x9a8d0837,0x7089acf9,0x7b5359a9,
	0xe55d457b,0x354b67c3,0xb38debf7,0x1f39e051,0x3b4fc2e9,0x884731fd,0x9c4da86b,0x9ec7f7eb,
	0x12b53f1b,0xf57f89eb,0xe6b93f83,0x2f71191f,0xb697ba03,0xda1b411b,0x63277137,0xfe4d759d,
	0x66dff4df,0x6f6534a3,0xdf5ba547,0x6121651f,0x11654731,0x4bd7ca1d,0xaf7b5039,0xa755f267,
	0xaae193c3,0x840f8cb1,0xd719785b,0x8afb883d,0x27f95da9,0x6bd1ea09,0xd22b5ac9,0x41d1be73,
	0x1639fd3f,0xf70d0f5f,0xfe11305d,0x2e3546e3,0xd515f527,0xbad9e66d,0xa29712c1,0x3033fa6d,
	0x6eeb674d,0x8e713279,0x9ae90163,0x967d05fb,0x11fda9e5,0xcc3fcd51,0x9ea1067b,0xaf6d377d,
	0x2977fc6b,0x32cf0449,0x2ac17c09,0xfa076aef,0x16715c9f,0x65d7153f,0x0aaf70d1,0xf6f3174f,
	0x88e37b8d,0x0f37cb97,0x813b2d67,0x9983fba7,0x78b3d28b,0x9ff53d41,0x119dd91f,0x58b3ec0b,
	0xbeadd831,0xb13da7b1,0xe8793f1b,0xe025be91,0x4d875565,0x05676ce1,0xe4d3b33d,0x6123585b,
	0x0ad9da51,0x28f1305b,0x411d173b,0x839fda93,0x482b5369,0xb381142b,0xdc2fff87,0xf735ef6b,
	0xdbe9be65,0x28e715e5,0x2249f861,0xa423371b,0xda67ff4d,0x7a178ba5,0x9613ead3,0x7c57d4e3,
	0xeedfd569,0x262fc115,0xf99fa1ab,0xec611c0f,0x5477f04d,0xfb77b45d,0x17636e7f,0xec7f5ced,
	0x6f3d24d5,0x785bf335,0x2b41eeb1,0xb18dd1db,0x0521c225,0xcc7597db,0xeb81f063,0xfe1bac35,
	0x170306a5,0x797f6613,0x31d3778b,0x13594169,0x59a7b50b,0x94630829,0x444de2db,0x422157e5,
	0x4eb7c951,0xa62d6bf5,0xbe7330d5,0x1bf79423,0xfdc74dbb,0x2d133fd1,0x1a2b64bf,0x440105a3,
	0x4d574fd5,0xbd758fa5,0xd8c70ba7,0xe017d3f1,0xfbc7f571,0xc2d781dd,0x4bfde169,0xa9af0b9d,
	0x3867b1a9,0xe0e9346f,0xfeed959f,0x9eed8b41,0xdc6999e3,0xf481b9d9,0xbf23b0b3,0x5399107d,
	0x43e9dac9,0xb49d361d,0x458b98d3,0xe22964fb,0xc6eb4d4f,0xf3631bcb,0x7f7fb6f7,0x7cb5ab6b,
	0xd25d2baf,0x7f2188f9,0x77c1bbdf,0x9e01cc87,0xa113e66b,0xa34fc441,0xdf750511,0xda730411,
	0x94c91951,0x4989d9cb,0x373121dd,0x51218dd1,0x2f21a075,0xba975843,0x97e77859,0xbcc5729b,
	0xaaabcd2f,0xff652ddf,0x1bfb0a65,0x24c17545,0x33d9bb23,0xe20ba55b,0xe8375aa9,0x2e1f1fb1,
	0xc207c53f,0x8ec982fd,0xd4c57195,0x0c91efc9,0x907b1ab3,0xd5014193,0xb643025d,0x136fa47d,
	0x375f73fb,0x08456f71,0x46b1b003,0xe6c1aac9,0x64c9e7db,0x81492b75,0xae73724d,0x4c2baaab,
	0x35b5e05f,0xbeebc205,0xad5d1ac9,0x9c03342f,0x2f072fd9,0x27336a0d,0x63a5f9d3,0xd2438c63,
	0xd68945e3,0x684f2201,0xbaeda385,0x3f8d9a63,0xebf38463,0x7995ace1,0x6f3dd4c9,0xda29f451,
	0x41e1b483,0x3c83af31,0xb803784d,0x2f0d0c53,0x36d59bb7,0xbdbdebff,0x911bcb8b,0xf2d17d9d,
	0xce3bb0b9,0x1615a1df,0xa3c3a3bf,0x32b77967,0x6969f08d,0xeb8107ef,0xcfa3d2f1,0x25ab53f1,
	0x209bd37d,0x921dead3,0x53cbacef,0x9d3d3187,0xbbf5621d,0xcd2f69bb,0x97b5ac55,0x16a7d379,
	0x4c836a49,0x3029d359,0x9441377d,0x6bcf851f,0x6539d425,0x1f9da2ed,0xdcb58591,0x243b28dd,
	0xf3f51719,0x724b9d3b,0x47c3a37f,0x6621651b,0xba79cedb,0xb2190d8f,0x38839901,0x8759f149,
	0x67717067,0xfd1522c1,0x8777ad93,0x3e6502e1,0x4f751efd,0x86776c2b,0x0b85cd7d,0x736fda65,
	0xc5fda12b,0xb79d76b7,0xc2fd0ecf,0xb14b705d,0x166f75c3,0xf10b89cd,0x9c97565f,0x3673425b,
	0x1d1708df,0xeb6f8465,0xe0751ccd,0xa6073ff9,0x802908e5,0xb8a3d9fd,0x391f5381,0x58d5d7d7,
	0x88c3db7f,0x64a1af97,0x5c8569ab,0x4e4b249f,0x9be732a1,0x369318c3,0x54ff713f,0xbd873a01,
	0x5383c185,0x91c57497,0x6a4d63ff,0x464791b7,0x376b11af,0x76adeaad,0xaa998871,0xc1fb9883,
	0x165977e9,0xa3eb082d,0x136ff6e5,0xb4b15b2f,0xfef32949,0x57437cc3,0x5acd3e71,0x5e235389,
	0xd8c57027,0xaea5f7a5,0x580f29f7,0x6ab7556d,0x9d450127,0xa9272491,0x0cfda51b,0x44739bbd,
	0x30cd7037,0xc807c8c9,0x4ecbc14d,0x040bf55f,0xdba1c587,0x4fab001d,0x0f0ddac7,0x01db1245,
	0x62ef3293,0x28a199e1,0x44c7dd85,0x06e3f06b,0xc1c9e721,0x60a195f3,0x755faa4f,0x1dcd68cf,
	0x822f0639,0x4b87c1b9,0xdda79bb5,0x03eddc7d,0xb601bb2f,0x445b751f,0x3ad52b0d,0x3a3b0185,
	0x900f6e9d,0x0e496f9b,0x3389b579,0xb65bcfff,0x9d091b69,0xd5abd529,0x60cd60dd,0x33998f0f,
	0x9c8fc3bf,0xd0fb4b4f,0xf71320e9,0x23e301db,0xfa25060d,0x81e1361b,0x0f2fdc17,0x40d5b497,
	0xe635d213,0x962d1521,0x8f63b0a3,0xbcb3697b,0x0f153dd3,0x68d3007f,0xb4595995,0x1365a5c9,
	0xf9ff7a97,0x22f345d9,0x3a1fb3bd,0x7b7f5ec9,0xfc1be9f5,0x7cd1255f,0x252f62b1,0xf739c6cd,
	0xd37152c5,0x1eddaec5,0x2b6795d3,0x05773a2d,0xdff9362d,0xa2abbe45,0xbd11ed47,0xf2c34c4d,
	0xfc8d4495,0x33fd19a9,0xaddd7efd,0xca51f495,0xf7f3f2b5,0xd1b7ad3d,0x7de1fbaf,0xe6f7db75,
	0xadd52e83,0x2ee7e8d5,0x42a3f3d9,0x243bc767,0xbfc93447,0x33c53ccf,0x30053cc3,0xaf4529ed,
	0xee4b8389,0x1eabb70f,0xc15b757d,0x77e7cc8f,0x11bff41d,0x4525c003,0x825babdd,0x419d9de1,
	0xb36feb1d,0x74ddf7a3,0x78272185,0x548b9e77,0x4693afef,0xf4ab3267,0x2a4530d9,0xce77edf9,
	0x0147e13f,0x258f9659,0x4ba9520b,0x93d5f80b,0x558d09fb,0xc3abd803,0x03a7400f,0xe0bfc15f,
	0x0a515663,0xc74f977d,0xd7033da7,0x79f754af,0xf46968f9,0xe5f3dd63,0x30e37a59,0x7de94fbf,
	0x4f914f89,0xb335b7d9,0x8bd79775,0xd5a79053,0xb76d9823,0x61d9f78d,0x3ad94d13,0x45e90141,
	0xc0898627,0x24cd0cb5,0xd2492f0f,0x2013875f,0x31596733,0x302b040d,0x30ed9215,0x932f0e8f,
	0xdb390837,0x5a2da3dd,0x28f7908f,0x9cefb6bd,0x136f4a63,0x5c3da8ef,0xc9012fb9,0x9aad20d5,
	0xcc27d835,0xb3e72399,0x4507a48f,0x7a6ddbd5,0x4d73fa6d,0x23e1f4bb,0x7f73b8d9,0x8bd5f1bd,
	0x8e518d19,0xd50b6ab7,0x32175027,0xf13d9495,0x2da5148b,0x1769fe7b,0xb72b0cd1,0xb09beb6d,
	0x0b3bf25f,0xc32b307b,0x724d14f3,0x6493ff63,0x80c7ba79,0x39a785b9,0xd987f777,0x8d6fc893,
	0x3ae7a801,0x065ba4b5,0x1e49b10d,0x821f5b2b,0xb21d326d,0x1fed927f,0x766bd129,0x01433459,
	0x43d7c277,0xc92d0fab,0x052dbf0f,0x6217a757,0xeb678723,0x120d1557,0x64371ec1,0x65896a67,
	0x9b0b6abb,0xf8b17229,0xcc9b5611,0xa72943d1,0x34e927d5,0x2a59874d,0xdfcf3195,0xae33d6e7,
	0x24097e49,0x64792577,0x10b5a9af,0x9e899103,0x9561883d,0x75a389e7,0xac93c783,0x89b3b685,
	0x50cf2f1b,0xde997b61,0x841daa03,0x5fe78fd7,0x3215c095,0x133d8733,0x3469aae5,0x80fdb669,
	0x41e1a3a9,0x5ba15e31,0x0ff5a3a7,0xed7781b5,0x6ec72d97,0x54f951b9,0xa7ad5291,0x1781943d,
	0xe64196ed,0x12a3f0af,0xf3dfdfb3,0x53eb888b,0x0db5107d,0xdf29c483,0x1d4581e5,0xeb31be2d,
	0x1b71f863,0x9d332e27,0xe5ff43c3,0xca7546bf,0x4fa52f03,0xc89d631b,0xb293e8b9,0xd481f2e1,
	0xcd718c05,0x17638a63,0x32f3f1f1,0xd2c57f3d,0x13d9735f,0xbaabf98b,0xab77c367,0x065fe185,
	0x16c78a4b,0x3fc391ab,0xdde1e8d7,0x590fb571,0xf80f8c4d,0x11213c5f,0x92557ac9,0x2e41c9c1,
	0x60714031,0x976588cb,0xc067a38f,0xd405cd41,0x788d8d07,0xfa55689d,0x580f443b,0x94171bbf,
	0x81f3af2f,0x81dd0d0d,0xaaabb9b1,0x64d7ab19,0x10158d47,0x9717e3d3,0x7405c195,0x3a53182b,
	0xe14f2d3f,0x653db439,0x834d7f59,0xf73bd3e3,0x57e54949,0x1ab7dc09,0x041ba133,0xfde7702d,
	0x930704dd,0xca15ac99,0x676fa521,0x615d0d07,0x27c3c1c3,0xeb09e7c9,0xecb13deb,0xb647e571,
	0x7a1b1503,0x7b775cfb,0xcab1d821,0x83f5fc73,0xb5f1dbf1,0xc061a61d,0xf8ab3f1b,0x5563ea1f,
	0x680f7129,0xa6f704a5,0x973961f7,0x6a31c88d,0xb72d018f,0xc58d5e8f,0xf969389b,0x07ad40e1,
	0x3ce7014b,0xfca55b63,0x4da7c8b9,0x69c5b843,0x7ebdc0d3,0xb7e1a12b,0xe6cf4ac5,0x54179ce3,
	0x072121e1,0xcf13317d,0x251f6f03,0x42e3d2fb,0x1e636c79,0x0731e677,0xff3dc275,0x3c1341cd,
	0x23c143e7,0x33550fbf,0x2b3f33ed,0x403b80a1,0x865dbbbd,0xf5cb2f81,0xe799b903,0x5b95a3cb,
	0x5e478cd5,0x20fdd773,0x642b1315,0x570129a1,0xa5716a55,0xb883a5d1,0xcb3fb449,0x090d0785,
	0x10b976a7,0x921b6261,0xea85c491,0x46e7d6e1,0x88e1d87d,0x96ab3b71,0x7c1746a1,0x756d2225,
	0x43956fd5,0xa34122d5,0x0f715cfd,0xba1dd1cb,0x7c6baaf1,0x0a154aeb,0x927daee7,0xcc27b957,
	0xcddf7b5b,0xb383c399,0x7a8ded71,0x6559444d,0x2a556ae7,0xdf133749,0x8d597873,0x532d4343,
	0x7519d0b1,0x8473c7f5,0x49ff238b,0x27c7d8cf,0xbb5f261d,0x54770c17,0xf2091b1f,0x8af38693,
	0x0d457bd3,0x5a1f2bb5,0x3267e961,0x2b1f5a39,0xf6cd0ec9,0x3b931d5b,0x6c6f9b47,0x4e673a73,
	0x98e5fd39,0x1b1f0321,0x9ee5058f,0x038f53f9,0x625f1ba9,0x1839a7a3,0xeef129c3,0xf2ffa68b,
	0x68f9e9df,0x707f1b05,0xd11fbb2f,0xcfcbb1f5,0x6257a7f3,0x40bb6ff7,0xd26bc3ed,0x68ad4307,
	0x3d058b3f,0xe5d598ab,0x013569d9,0x59056099,0x59791365,0xfde963e1,0xf645d39f,0x59df588f,
	0x630b7f4f,0x093399dd,0x7dc92dab,0x32edeccf,0xc9056235,0xab19396b,0xe05dcf33,0x4b8ba04d,
	0xd78d588f,0x8b29d4e3,0xcbfd7f3b,0xdbb72401,0x70bddd21,0xd61b0f1f,0xdd15d985,0xbd21e3ed,
	0x658d3df5,0x5ecb3887,0xc773d3a5,0xdc15b419,0x6ee3b15f,0x5f3f0c09,0x1f5161ed,0x48939d97,
	0xc68d8afb,0xd9a98c17,0xc24f3c81,0xe739cb81,0x603b90ad,0x995bffaf,0xe073c447,0xc25397f7,
	0xc28d6f9d,0xd3d50f59,0xa52f07eb,0xfad3b923,0x80075141,0x69bd021f,0x805be8e9,0x59538e35,
	0x50139055,0xc7e31a97,0x0f37607f,0x7f178c67,0xc8058dd9,0x683b13e1,0xa56de4b1,0xb707cbfb,
	0xb41da61b,0xf2e3be9f,0x760bed51,0x66b5b53b,0x107b45ab,0xff23bdff,0x5c8998f7,0x1f5fcd75,
	0xa22f1e69,0x746964b5,0x45c97201,0x4ee3a405,0x30297c75,0x8b4bb203,0x39135397,0x90cddf4b,
	0x5c49bb3b,0x6e856ea9,0x01176ea7,0x9f4f69b1,0x1c53da6f,0x7c0169f7,0x74ed6ee7,0xe443bea9,
	0xd2f1330b,0x25cbd6c1,0x6115bfdb,0xaa2b57ab,0x08b94c51,0x7319c865,0x1077f1c5,0xed333937,
	0xc525d0d1,0x214bcfc9,0x75633eb9,0xcc2d9fd9,0x879da359,0x64e7b859,0xf2932f89,0x9991cd1f,
	0xe06b1407,0x4a996509,0xc42760d9,0x8c83f4a5,0xa9c1353f,0xb839cd5b,0x08a7680f,0x11cd490d,
	0xe0c150a9,0x0dc51a4f,0x6a01d859,0xbce128fd,0x1e697c3b,0x6663e373,0x668f67af,0xd8d96c29,
	0xb0a94f31,0x79618bdf,0x3a1333cf,0x9977d049,0x5355b70b,0x1b37bf2f,0x66b32743,0xec27861f,
	0x8929ec97,0x5e810e89,0xddff7e57,0xe8f9de73,0x94c988e7,0x5507ad97,0xc9f16c25,0xe3ab1715,
	0x11c1ba57,0x70b74f93,0xf5e7df8b,0x1c9947e3,0x2d859989,0x84a52437,0xd7ab6831,0x11d36fbb,
	0x80719e69,0x6611f4c7,0x386f3b83,0x7009a185,0x86cb3529,0x2d636115,0x7dc759bd,0xa3955135,
	0xb9bd7347,0x17273c73,0x92b5d2dd,0x0979c0c5,0x485dec85,0x05130abd,0x70a12ba7,0xc0618d33,
	0x70a7a7ed,0x9f079d5d,0x485de2af,0x199d5b89,0x787f34d5,0x1407d03b,0x4b211549,0xaa29a5d9,
	0x46b1dfd5,0x7b4366cf,0x138b4495,0xfba7a83d,0x9bf107d3,0xd5110917,0xaea53a79,0xdd616dd5,
	0xebdd92f7,0xabed6097,0x44dd0ea7,0x5549fdcb,0xd5f783b9,0x5581555b,0x630f4b95,0x30f7a84f,
	0x3eabadcf,0xd39b6af9,0xe3793383,0x36b3739d,0x08518b3f,0x552d3d91,0x76c32575,0xf661a8f3,
	0x6c213155,0x57591ec5,0xccff223f,0x3a99819b,0xf34165a3,0x6665d2c3,0x5ea37175,0x198ff3e9,
	0x0fbdd305,0x7ebd6d41,0xd58f6677,0xa62ba033,0x55895e9d,0x0df94e7b,0x160f456b,0x40f5dddb,
	0x53839cd7,0x93d94039,0xe7cf4843,0x891de84b,0x0c6d6667,0xe33fb2c5,0x3eebc3b5,0xed812bf5,
	0x0ff58d47,0x033d19f5,0x24df6c41,0xdda1b351,0x33adb1bb,0xb0076a29,0x4197bb2b,0x9aa9b3df,
	0xec13374d,0x7bfbb541,0x04617387,0xa8693b2b,0x458d59d3,0x90a1e7af,0x6cf74729,0xde5dfbc5,
	0x7d636265,0x0fa7a567,0x74779bb1,0x18a53a45,0x3acbfc69,0x13e146e5,0x166b6f87,0x890fda4f,
	0x67e3aa87,0x5251f62f,0xf9c35ed9,0xa8098b89,0xaaad5bb7,0x5b1bebd3,0xb9d9c89f,0xc5b116a7,
	0x7e17202f,0x7a8dcbe5,0xcf691397,0x3ac7ca61,0xeaf5fe77,0x3a1d2303,0x199d134b,0x39b70879,
	0xe101e857,0x816b0353,0x07078d07,0x3f91f2b7,0x2fe3cfe3,0x573dc181,0x5e9ddce5,0x250f37ed,
	0x2023dc75,0x427fd1c1,0xa8c1bac3,0xcf9700f5,0xac39bfb5,0x4b49c4d3,0x383b1f49,0x822ffdaf,
	0x597f2a89,0x9bd964fb,0xd33b48e5,0xce8d9203,0xb1396227,0xc195f307,0xfc59e0cf,0x260722e7,
	0x5995f509,0x8e0b834b,0xdb934007,0x0aa3834f,0xcea78ff3,0x97f37aa5,0xc757d453,0xe00b813f,
	0xbb69f2ef,0x5c292b79,0x6d6fa541,0x5c8f92bf,0xf2c30653,0xfeb592b7,0x9c17f92b,0x9a29a2e3,
	0x087f0fb7,0xabc534d1,0xaaef1a2f,0xc77ffebf,0x8a4f0701,0x98ad1ac7,0x83fd3b35,0x78d7627b,
	0xd8d30b5b,0xa4efef1b,0x4cb57ceb,0x9925263b,0xa08ff837,0x9b2d3adf,0xaeeb12c9,0xfb058b31,
	0xf2ed1a53,0x1239c2a3,0xc1e3880f,0x89b72899,0xff4304af,0xee070389,0x934124c1,0x1a2578b1,
	0x6bcd8599,0x80b7d033,0x501972b3,0xdbe385c5,0x4eadbba3,0x4b8d0dd1,0x0de3e279,0x6a29b723,
	0xc6f34aa9,0x5ff99115,0x337f9073,0x7cddbe29,0x3591b0cd,0x60911b3d,0x823329c9,0x3985a333,
	0x1663bb7b,0x22137711,0xbeb1f169,0x2455f2ad,0x792f1c67,0xec65b5db,0xfa11e50b,0xb1270a09,
	0x1aa11e8b,0x5b958c71,0x7ad3022f,0x747f84bf,0x1d4b7b2d,0xe0dbd033,0x45dfab1b,0xf485c94f,
	0x62a94ed3,0xe3931403,0x47872bdd,0x1a0db645,0x84232e55,0x8245654f,0x1c815f4f,0x41916f31,
	0x6c035bcb,0xf39d290d,0x7aef740f,0xec3149ad,0x8e7d1b9b,0x877318b9,0x3b59d185,0x10b9da59,
	0xc2af296f,0x47c75f59,0x01af1cdf,0x0c9b21dd,0xbb9b4d39,0x39bbd67b,0x86495e15,0x34f1d9ed,
	0x212d1037,0x3ea16335,0x7ee544e7,0x077fe241,0x493b91e9,0x94eb7321,0x27af8ddb,0xfbadcd9b,
	0x90817d1d,0xf93d9965,0x6c378741,0xf38f8ec3,0x53a31ce7,0x67594bb1,0xb073b62f,0x4cdd458d,
	0x882d919d,0x7b2fbf39,0x39c59b85,0x91fb2bcd,0xf59525e9,0x71d5e5b9,0x37f398eb,0xcaf3a269,
	0x0e33c3b1,0xca878a77,0x6e2ff5cf,0x6e775e49,0x684f892b,0x87af8f41,0x7c130469,0xf2e3b55f,
	0xd7157dd1,0x0fd9496b,0xc69b66b9,0xff350ba1,0x23976767,0xaebbfed3,0x01337385,0x3c1b6013,
	0x65d5bef9,0xb63582dd,0x56a9bb5b,0xc4e7f9bf,0xfdafc5d9,0x3f4df379,0x3237ad95,0x389134b3,
	0x2bf3baa1,0x8b2f9619,0xa87b5d53,0x6abd6f0b,0x4b552e37,0x0433d4bd,0x807f6679,0xb4b515e7,
	0xa97378c5,0xded75ae9,0xdcb3f2b7,0xe66bd273,0xffcf4ebd,0x5ac152ab,0x83efde85,0xd779d6db,
	0x8cd775dd,0xa3c1c197,0xca73fe23,0x98234b5d,0xccdf9a27,0x52cb05c9,0x1ae98297,0x424fdb37,
	0xd32142e5,0x8efd72eb,0x1f5d7eaf,0x6a9561b5,0x42c3e7ab,0xce9f0f25,0x8a4d8c05,0x312bb727,
	0xe7d32555,0x381d702f,0x7f958ff9,0xf2f59de5,0xf0411305,0xa311b847,0x9d7da0af,0x9a7dcf53,
	0xc4edb729,0x3935b331,0xa5b90a17,0x90f528d7,0x82999c71,0xb7731339,0xc65f72e9,0x4f37f8e5,
	0x12f386d9,0x4ed7ce37,0x82ed21a5,0x8ec56bf5,0xe58f48a5,0x25979a85,0x3d516191,0x1acb1989,
	0x48e9b761,0x78138c0b,0x5ed507bb,0x4119b129,0x6363c0df,0x59cfd135,0x213517ff,0xe32bc767,
	0xcc4da039,0x167b8ff9,0xf79189f7,0x2723c2dd,0xc4d732d5,0x32ede2d5,0x976f2e0d,0xc8cbe929,
	0x11216d5d,0x0e23f5cb,0xa1c1b26f,0x0a958bf9,0x712ff0c3,0x2243436b,0xebe1c815,0x469b55fb,
	0xb9ebbf45,0xe59bf1cb,0x688b67bf,0x1f9fb7eb,0x8e2b1165,0x4ba34f85,0xb0eb36f3,0x520d7585,
	0xb7a94aed,0xe5f770c1,0x2d8f0d01,0x24f55299,0x200d0ff1,0xa55fec2b,0xdf6f97ff,0x7b13dff3,
	0x69e179cd,0x3ac7b7f9,0xc8ef21cd,0x83c9686f,0x29996c25,0x184726e7,0xf6d37513,0x0c1ffded,
	0xbe9109e1,0x121f053b,0x294de241,0x6fcba657,0xcc0f4a37,0x9fb1d5c3,0x1cf5648b,0x2a25a89f,
	0x523dada3,0xbc8f2ed3,0x73cbe6f3,0x072ff9bb,0x673112e5,0x696d3749,0x3e37a93f,0xf495c9af,
	0x8fe7ac0b,0xcd29438b,0x240bc4ff,0x72a73085,0xb9411365,0xf5cb9285,0x2d7dd289,0xa561fb4d,
	0xd10f8093,0x39812aab,0x2c2fadfd,0x0563991f,0xff031d75,0x37a1d6fd,0xc4295c43,0xb0fb281d,
	0x7dbb7b37,0x79a943ff,0x14d9100b,0x5d19a273,0x13b7274d,0xb43d3cbf,0x021b4ec9,0xe6552b4d,
	0x2c69606f,0xa82f07d1,0x1d2d35bf,0x81f77be9,0x9121eba5,0xa375e453,0x2db7def3,0x8ee37087,
	0xc21d0937,0xa22ba6e9,0x5ac9e635,0x06afb56f,0xef8189bb,0x0f9776c3,0xf3dd0e1b,0x8e9593f1,
	0x92590309,0x272baa93,0xd9d30505,0x2875df6b,0xa5992545,0xf579c599,0x87f14a1b,0x83dd023b,
	0x7f1f2fdd,0xf9419497,0xbce9324d,0xeefb2ac9,0x48ad8681,0x64696adf,0xc3d50d4f,0xe7ad9889,
	0x18ef662d,0xfcff7f43,0x5d316aa3,0x4c7308f3,0xac7dba27,0x9e3b691f,0x47e97e8f,0x2d794489,
	0xbecf10f5,0x597bbd5b,0x6a4ba723,0x3d8fcbd3,0x034bb16f,0x3743cb65,0x9b111135,0xe32fa463,
	0xbe3dcfaf,0x98417a2f,0x0a597d65,0xe97f45d3,0xfdd9e217,0x364f4537,0x4aad251d,0xd145a6c3,
	0x733d1653,0xc5675985,0xf9fdbf87,0xc1f569dd,0xeb6be657,0x34b3d2a3,0x0aa1a69d,0x1aab2ad1,
	0x6851cd5d,0x8f7f17a9,0xac591c1f,0xa327eb5b,0xd9c11ce7,0x7e415831,0xd54dae93,0x5cd3a039,
	0x767bf1c5,0x67992963,0x6b0fbe49,0xf3c3de35,0xb51f4905,0x314b42eb,0x0b952259,0xcfb1a723,
	0xe53b3505,0xa1475bff,0x7641ed9f,0xc4fd56d9,0x68453269,0x5ea3285d,0x94db53c5,0x65b3b039,
	0x8a959d19,0x929d7547,0x2491ae3b,0xf2870a2d,0xfc75454d,0x299b668d,0xfeffa135,0xebcf9ca7,
	0xeb0d247b,0xb42bd383,0x032160b5,0x4291ed9d,0xb9713269,0xe805c407,0x9e631581,0x29755e15,
	0x59a15a23,0xc1050d7f,0xf5956229,0x85cfd713,0x457d8efb,0x42330fd7,0xaded0803,0x009996ad,
	0x17d5018d,0xd6bb9285,0x560bac31,0xb7731cfb,0xc55974bb,0x52f7c185,0x6efbbc97,0x8da9391b,
	0x75a9b2b1,0x95614a5d,0x152974e5,0x1d2d3639,0xfc4921e3,0xc7a1991b,0x496f0395,0x479b2887,
	0xf1a37a0b,0x3f873553,0xda0fcee3,0x67315a3d,0x6c0d992d,0x00073f23,0xebadd9d7,0x1fdfd89d,
	0x58c17893,0xda410c2f,0x225d4941,0xd03120ef,0x74e741d3,0x2e79e4a7,0x6a9708b7,0xa267ed85,
	0xe68783c5,0x4d1fe03f,0x62398f9b,0x3d5f22b9,0x7599878d,0x77c7e331,0x618dc611,0x15a5dbe9,
	0x64f7c599,0x8233bb47,0x24430a09,0x5e6b9883,0xeb677a99,0x13475ccd,0x1273543d,0x9a8b88f5,
	0x4c935c8b,0x86113f97,0x299d7d29,0xcd89fbb9,0x92116faf,0x6ac9dc03,0x85a9a215,0x4c8dea51,
	0xe45dfb93,0xa7cb47f5,0x89e9aa11,0x2f6ba647,0x83d9a009,0x3a9df3db,0xaa13eaf3,0x619ba629,
	0x61d58a2d,0x98ef87ad,0xd349ee5d,0x53417293,0x5983c961,0xb199dfe3,0x751356b3,0x4a27b325,
	0x0901c451,0x8d952a87,0x2a5fe427,0x52bf5b89,0x4a4fcdf1,0x910b2423,0x028999ad,0xd123f86f,
	0x4c5fda7b,0x5c4974cf,0x6a4d0207,0xb2171c93,0x4c015473,0x4cc72d25,0xb4d794bb,0x3c03edb3,
	0xecf311a3,0x9e23634f,0x44b73b19,0x7ff9d19b,0x32d96821,0x2b21eff5,0x54e3f539,0x6ab73b19,
	0x1a3d6345,0xceaf4b4f,0x61bb9ef7,0x759b9709,0xd19918b5,0x64e78a19,0x3209d4ff,0xf7af594d,
	0x92431d5b,0x6c037a9b,0x7ffff9bb,0x16a929cb,0x19831a69,0x456de19f,0x42315a67,0x57e33177,
	0xc185825d,0x16b1d77b,0x94a173ff,0xd15b8749,0x3a5b65f7,0x4a85450f,0x41b9584b,0xfabfbd41,
	0xe3036945,0xb1c980bb,0xeb4732db,0x1e5f8d6b,0xc261d899,0x44810b73,0xd383ee07,0x6a37a6d7,
	0x2041dd8f,0x82dd6da5,0x4611f7eb,0xa0e99a9d,0xbe57d409,0x76333455,0xa0f32773,0x6abfe8e1,
	0xb141bf33,0x52010e03,0xfd9fc149,0x46ab2dc9,0xd981de81,0xb4ed07bf,0x79eb9ce9,0x1b476e89,
	0xfc8562ad,0x89c7ea1d,0x2117698f,0x67d58659,0x7d9f42bb,0x8881b63b,0x74cb1343,0x1541b37b,
	0xb70d30f7,0x573f42bf,0x961947d5,0xe71d4437,0xf2f3aff1,0x4b41f8d5,0x0e771bdd,0x8ca163e1,
	0x045f4789,0xc9fbb131,0x38c7cfb7,0x51af07cd,0x8041d9df,0x49ffb113,0x4a51b48f,0x6fd5fc61,
	0x9679185d,0xf40fc73f,0xfbc3314f,0xff431205,0x8ac918bb,0xe40d8903,0xd239e7b3,0x87d36a29,
	0xcddf09ef,0x0a0baf33,0x082ff937,0x3207e449,0xb64d0941,0xab3d932d,0x16916c23,0x980baae3,
	0xd9931739,0x8301cbd5,0xddafb087,0x36afe081,0x05112cab,0x83e1ea9b,0x6e3f453b,0x7e6f6cb7,
	0xd7176fb3,0x38855871,0x72617cdd,0x846de91b,0xf7d588b3,0xc4c952d7,0x369f62d3,0x5371ae4f,
	0xf26b1757,0x86a908d1,0x52ebc04d,0xdcf100fd,0xaddd4793,0x574bd7eb,0xf3994145,0x8a055ed5,
	0x861586a3,0x6bfda93d,0xc26bb977,0x6c6feb93,0x04e75807,0xd7376e63,0x6f8b896d,0x0f99fdf5,
	0x3b134a8b,0xa993be81,0xda872373,0xe999ccc7,0xb9390d45,0xb2dd9345,0xdb57b0a1,0x6c233bd9,
	0x28e9a48d,0xe2ff25e5,0xab5dd5d9,0xb59fc903,0x8595bf09,0x4b13ec1f,0xee6198bf,0xe2159929,
	0xf5992aa3,0xbe53b537,0x5b9364c5,0xfc35a531,0x4339698d,0x1327e6f9,0x068b3021,0x8e5d070f,
	0xf5a36745,0x041fdabb,0x4849c0d1,0xd38d66bb,0x09eb4d8d,0xb0ed5a5d,0x4835119d,0x886f8735,
	0x4c0d796f,0xbf753d41,0x2521d715,0x5c59f389,0x4fed903f,0x1cb92555,0xbe432491,0x023fcbc7,
	0x0a55b499,0x5de95c0f,0x1c3d312f,0xe1c9b209,0x09fddb5f,0xc159cf6b,0x7a153cd5,0x683dd76f,
	0x507f40bf,0xcf8b2ef1,0xee3f9535,0xf9912921,0xcb61fd29,0x9c2128ab,0xb38fbac5,0x815b9d53,
	0x6d0dba59,0xa6edc62f,0x1249a5c3,0xa3e1a03f,0xe5d98853,0x5ce5e99b,0xe9132b37,0x8f0da123,
	0xfd01d263,0x3923ea95,0xd5fd81f1,0x6b6fbf49,0x89a97419,0x85f35349,0xff81e789,0x6d419703,
	0x0bddee55,0xbdbfbd6d,0x7d7d655d,0x85692eab,0xe591bc37,0x8c1fcf3d,0x623db593,0xb26d03a1,
	0x33a1c82b,0x6ed1587f,0x636d481d,0xf181374f,0x46d300e3,0xf6bb8f81,0x232767b1,0xcf81dc25,
	0xbcd30e5d,0xa8eb6e17,0x18eb7ecd,0x99ed629f,0x393326d9,0x7f992e9f,0x1aa37cb9,0x2fef263b,
	0xbe7103e7,0x0b21e8ff,0x859d5a87,0x735b1a85,0xa6f1f755,0x330b4fa1,0x0791c009,0x59ab980b,
	0x3dff2041,0x97058c7f,0x07a1c8e3,0x9cff4969,0xf8cfc00d,0x8fe33e13,0xaf55e979,0x0d233841,
	0x4f7faf67,0xd0a59463,0x939df3fd,0x808bfa39,0x3611f33f,0xa7738dfb,0xfdd13d65,0x654dfe03,
	0x357171d1,0xde9954f3,0xd4b1e26f,0xf22ff85b,0x2477c7a1,0x3d8dbbe7,0x25652ca5,0xf7997101,
	0x80db3c7b,0xa9eddafb,0x4c7d1753,0x509f6fbd,0x6843d871,0xe883ccdf,0xbef5f493,0xf3f9495f,
	0x313b98dd,0xfe398bc5,0x73273243,0xa50b8cc5,0xa439c565,0x3125ee6d,0xe9e13f09,0x44e10fcb,
	0xd49564f3,0xa989c519,0xd74f8f57,0xc3291c5f,0x9997d2bb,0xb2c9169b,0x6c0dc263,0xaf3fbd6f,
	0xa76b7337,0x9c737d45,0x3e17e72b,0x69272bf5,0x48258929,0x3b3fa3f3,0xd1d9e177,0xf2895bf3,
	0xb4bf2a9f,0x0a09e30d,0xc323eed9,0x5fb9a971,0x0e1f55ed,0xead7fd7f,0x8e294ba3,0xe8afa581,
	0xf61326ab,0x87dbfdc1,0xf891f7f9,0x9a0f033d,0xc84b2abd,0x546732cb,0x1a5f9cc1,0xa623a4c3,
	0x7367d751,0x2dfb4d27,0x070590a9,0x55ddc841,0xf1e91dd7,0x9d3d9bdf,0x165bfd27,0x99d954e5,
	0x633f210b,0xb6fd6989,0xcda1237f,0x3b5547eb,0xc4bd09f1,0x9d2f7945,0x6881c1b3,0xad3f4191,
	0x4a9dfcd5,0x9ff1a3b3,0x02099797,0x7d293221,0x59072e49,0xfe8b9405,0x5db10bbd,0x644b26ef,
	0x1d031829,0x486ba4ef,0x505bf089,0xf8893751,0xc589ce97,0x5e27ddaf,0xc94f6921,0xfd6d91a9,
	0x5c7374ff,0x127b0f07,0x7b3dee73,0x5529a861,0x3f87d313,0x6b511047,0x253d7437,0x91977ee9,
	0x396f09d1,0x82b51c43,0x7bcfadeb,0x253b16bd,0x3abf687b,0x07dd4e59,0xb1db73d7,0x343dfc5b,
	0xb2f7619b,0x60293f6f,0xa1b3480d,0x056ff44f,0x8979a007,0x681fc2f1,0x960dfb61,0x134dc829,
	0xb68f3bd7,0xd46bc3d3,0xb3097273,0xbcf93381,0x7c710f6f,0x32e54195,0xff338aa9,0x973df0f9,
	0x40392c7d,0x8b8b6d3b,0x0c771f35,0x5d8be73d,0x02ed70f1,0xa183e653,0x41312e0d,0x82fd75f9,
	0x7a773c07,0xd41b17f1,0xc11d1cef,0x6357e2eb,0xcaad4345,0x9fcbb5b3,0xf6671e65,0x1401e6d3,
	0xde4b8773,0xbf2f58bf,0xba9db6bb,0xd50d5a79,0x5ff569a5,0xec0f3cbf,0x1fb9610b,0x223703af,
	0x5335e035,0x40591ced,0xd91b5433,0x63e1824d,0x4d85cbc9,0x37213101,0x448967db,0x40155d37,
	0x4f3b6c4b,0x4da94a45,0x13351971,0x8b852f55,0x3c9ff5ef,0x44531085,0x92b7b12b,0xda8bf497,
	0xf6db462f,0xffb15f15,0x960f870d,0xb22976f7,0x1505b8cf,0x0977c1d1,0xfea767db,0x590bdb77,
	0x3d191cd9,0xb1851223,0xe54d1a23,0x48814f1f,0x1cfbc9a3,0xcedf33f3,0x6339033f,0x3d87d401,
	0x0377d3c5,0x20b5f2b9,0xfb0dec4d,0xe9bf2e37,0x19416223,0x4f5dfe73,0xa1d1e733,0x4471f0e1,
	0x39f722eb,0x8d5308a3,0x67f553a3,0x7b93ab29,0x6d1be08d,0xd841015b,0xc24f0413,0x84bd3541,
	0xff1936c7,0xd9f5742b,0x732382c3,0x4e311d5f,0x3a476799,0x69610535,0x131776b7,0x8fdb34c7,
	0xbfe15051,0xaba70e1b,0x3a3d28c3,0x3c4b3cc3,0x810d7e81,0xd50d5b0b,0x490b287b,0x91bdb3a1,
	0x57d36505,0x89ff07bb,0xd163113f,0xcb13c1bd,0x4029b0ff,0xe0157c67,0x9f8b6f35,0x70d54679,
	0x30edbedb,0xff0f8ad7,0x6337c44f,0x4a39053b,0x94e12f4d,0x61cfab55,0xf87bad43,0xee17f275,
	0x63b19c4f,0xb76759b7,0x50d92691,0xf3f1a0a3,0xdaf56e25,0x640b925b,0xfc3bf17f,0xc4f1cd45,
	0xd725d059,0xa2196f27,0x51ef191b,0x0ceb0de1,0xcca7c6c1,0x4319e487,0x39af973f,0xcb599d0d,
	0x60c96275,0x10b99e71,0x949b1989,0x045d4761,0xa2bb16d9,0xcdcffd61,0x4639e661,0x11bf787b,
	0xe49d2e9b,0xd757335d,0xdd7be1f5,0x93f56809,0x347160ab,0x657b80f3,0xddb9b33d,0x031766b9,
	0x75258547,0x6c879237,0xa7b308f7,0xdfe74b45,0x178d6aef,0x1df1fbc7,0x0291fead,0x84cfff6d,
	0x7363cb71,0x0959d7c9,0x44e5a1ad,0x96e32cfd,0xc04d60df,0xdd8582e9,0x1da7960d,0x16dd0ac5,
	0xaed91a95,0xc961795b,0xfd35dbad,0x121d499f,0xa1777235,0x7d0553df,0x1e59b333,0xf3b1216b,
	0x8587e0ad,0xcaafe4b9,0x2f41a311,0x75477e13,0x4c4d732b,0xe7c574b7,0x9a899c7d,0x303d4c87,
	0x03f3802f,0x4dd5202d,0x702f4077,0xce93e7c1,0x908f7c7b,0x3b9753f9,0xee9b44c5,0xdbf3a5c3,
	0x051bf01b,0xd5e76a7f,0xab9df8f5,0x36b18497,0x9c7f8b5f,0xe8cd68ad,0x5d6feb61,0x20c7f74b,
	0x52835be7,0x4877dafb,0x43b1ae27,0xf0d5d2fb,0x1cdf2191,0xd239d263,0x306bbc2f,0x63275bc7,
	0xc42dc38d,0x0d950169,0x310b7e27,0x8ab171d9,0x5cf3e54d,0x6d2df91f,0xd76b6f87,0x6209de63,
	0x609b9b89,0x2fd38615,0x22cd638f,0xfc75c09b,0x667b4149,0xe17b2d6d,0x08d7ea45,0x56dd1ac5,
	0x7ccf6cd5,0x7c45c9c9,0x9e99d577,0xc8d57f2b,0x21b904c1,0x29754857,0xe18bddbf,0x1597dd1d,
	0xdc4974e9,0xa27b85cf,0x2091677b,0x1d036df3,0x7571036f,0x31ed4b69,0x04ef67d3,0x2ca5c20f,
	0xd10d45bf,0x54896bef,0x3b5769b5,0xf0b1eddd,0x66e3b58d,0xfa3500ab,0xbce1b2d9,0x04fdd6c9,
	0x5b9d65d3,0x66ffc673,0xb80d88bf,0x260fa051,0x39d1d7d5,0xb41f9aa7,0x19c595ad,0x020f38f5,
	0x4afbf01f,0xf0f11829,0xb6556db1,0xa9d1073d,0x907f0b81,0xe3fd5467,0x127b33a5,0xa1cdb6bb,
	0x5ca9341b,0x6befbc57,0xcc535e29,0x93272507,0x8bad764d,0x809f1175,0xa4659c9f,0x9ca96ec5,
	0x5ca955c1,0xd40d86c7,0x26a5dc3d,0x43c71c9d,0xea9d626f,0x135bfddb,0xf3696cf5,0x0597703f,
	0x457bed8d,0xc7db63c5,0xa8714687,0x87dfd165,0x2b13dea3,0xd8012e25,0x69e56d7d,0x6a075ad1,
	0x6023a879,0xa86bf81b,0x0b557825,0xb621874b,0xa94f5e23,0xdce13f59,0xd8bb3395,0xf1ebfea5,
	0x6423e7fd,0xb9514113,0xff7768ad,0xcfc382b9,0xc01358a9,0x22d1f705,0x974fc115,0x7fb5fc67,
	0x977d6215,0x409d3475,0x4b77cc3b,0xa073a899,0xe8a3ea71,0xbd1fe331,0xa3832457,0xd057653f,
	0xeeb3c139,0xa6e3608d,0xec75b369,0xde651e53,0xdabf7431,0xf19ffa67,0xc1b71837,0x9b455ad9,
	0x2cc54465,0x97338c23,0x36172b51,0x4a49e9d5,0xaca93b25,0x58a53bb1,0x9ccfa40d,0xb26faf5d,
	0x03395f11,0x1f215683,0xf27ddd8b,0xcf559187,0xf3250909,0xfcff4e99,0xe62bbbb3,0x22458575,
	0x320d5937,0xcebdd777,0x8249b033,0xa335bc51,0xe173cc13,0x7c01232b,0x75afdf83,0x51bff04d,
	0xa7c5ef55,0xd89b3f49,0xfc9d65e3,0x6621d19f,0x695536ff,0x257f91ed,0x69bdbc59,0x2249938d,
	0xa163f25f,0x31cb76c1,0x4f1d3db3,0x42c7995d,0x5b0f6109,0x1bc7fbed,0x4735cb8d,0x0fd9435f,
	0xca67e7d5,0xb1dfbf29,0x5de79341,0x0e5ddbf1,0x856165e7,0x73adeab3,0x197bf2f9,0x50dda46f,
	0x5cd7a9ab,0x32eb524d,0x239f7ea3,0x688f0247,0xd58d05d5,0x5483b049,0x926f24f7,0xf64bcbe7,
	0x41310661,0xb1810277,0xd1697475,0xdb95b5c7,0x7757458f,0x181b0739,0x2a750063,0x0b95df6d,
	0x2e7960eb,0x6cb1da71,0xeee3e5d1,0xfc1d805f,0xf4ff0e4b,0x6ac7b28d,0x406d7095,0xb6a9b52f,
	0xca3150c9,0x060dbd83,0x7a33e04f,0x895b6c77,0x5747cdc7,0x6b591dd1,0x39bb4d67,0x57fd73d7,
	0xc85b41f1,0xa1a90779,0x07f9ae0b,0x8cffa4f7,0x45731639,0xcb23fd0b,0xa241fb35,0xaa7f328d,
	0x0b7914dd,0x06152c9d,0xe355759f,0x7b3f154d,0x25433e5f,0xedf7ecc9,0x4c5f0ad5,0xe3a598fb,
	0xc48bbe89,0xbc6559b7,0x2dedda25,0x52c9095f,0x3af9016f,0x0a271213,0x70f9d9a5,0xd35f7f4d,
	0x9317e86d,0x30291411,0xffe19b37,0xbccfcd99,0xc9571f27,0x4883ba73,0xcf6f317f,0x04218e2b,
	0xa51b9085,0xcf75d979,0x87d334ed,0x2d074ee7,0x31a1fbbd,0xe461fbf3,0xcda5e8b9,0xdad9debf,
	0xd71ba949,0x2ad9c035,0x2ae57fe3,0x019fbaaf,0x13993fef,0x4b91551d,0x97fb8231,0xb6fd9ab5,
	0xd417b9b5,0x15671711,0xa4b95133,0xa3491edb,0x6d7d78f3,0x3e634cfb,0x4157cd3f,0x127d9c35,
	0x35957d43,0xc4b30555,0x27711a75,0xa53b09d9,0xbc13b887,0xefad1319,0xe31585bd,0xa1cd0deb,
	0xa39383eb,0xf0cf2acd,0x7bb189c7,0xe5232a91,0x1a9b34e1,0x24bd1f7f,0xbd1bf407,0x73db0aff,
	0xf497d227,0xf4493fc3,0x209729bf,0xab35f06b,0x62d9e8bf,0x5569d2b5,0x55cb8cf5,0x121d3f1b,
	0x4d9f80f3,0xec39b4ff,0x6bc90179,0xca232b55,0x4d0d3357,0xcbff15c9,0x9a0791e1,0xa081866b,
	0x422f5dc9,0xd82d53cd,0xa965348d,0xbf1dabb5,0x8ff97867,0xc555fa45,0xfd2db0a5,0xfd7d8d97,
	0xf4478aa1,0xba37ddf5,0x3c11a319,0xd1d7e279,0x00dfc027,0x90b95a2f,0x9925a39d,0xe20371cb,
	0x346d1df5,0xb6ebadc5,0xbceb89b3,0x34838107,0xb383574f,0xafff7813,0x4e4dd1a1,0x018160af,
	0xa19fc2c1,0x35595601,0x1b992177,0x23d1194b,0x1a276f1d,0xf77b9efd,0xe389ee0b,0x29ed386d,
	0xc963587f,0xff1341f9,0xbe3b3fff,0x06f5bdaf,0x2589bd49,0xadfbc273,0x263998b7,0x63b727b1,
	0x47b79327,0x602d5573,0xa173f763,0x8fa1a11b,0x64ef1c0b,0xacd31e83,0x0a41fdfb,0x11d14da3,
	0xe71f9b33,0x47398cbb,0x7863363f,0xda07b6fd,0x26192a21,0x7fd5d7b5,0xca0176b5,0x11ad59ed,
	0xc09bad9f,0x65479c99,0xccad67ad,0x8cd7533d,0x954beac3,0x85539b13,0x065d283f,0xdb3d2cbb,
	0x5bb1bbe5,0x4de99259,0x1e731347,0xf945ca43,0xdd4365ab,0x0e1f3e27,0xe6b7a46f,0xa0f576b5,
	0xce5f0bfd,0x973373c5,0x04577d27,0x3b0110fd,0x47494711,0x7d8b5efd,0x38ef89a3,0x6fc55907,
	0xdd29d863,0xf9b5df25,0x4b7d45e5,0x58415cd1,0x5b197fb3,0x6969041b,0x916922b3,0x4f1f0559,
	0x1b11f00f,0x7083ab45,0x17830a9d,0x61b3c3ab,0xfef9e4c9,0xba0b3c8f,0x6b0506f9,0x60f55dd7,
	0x0999567d,0x592d876f,0x028f04e9,0x9289dbf5,0x97a9d00d,0xca43bfe1,0x4727ba51,0x01bb9527,
	0x38c3e3a5,0x93c79b6b,0x3d3faae1,0x70795c99,0x286dbfb9,0x87618e1b,0xcdaf4d13,0xe85fce79,
	0x6711e403,0xa2e12785,0xaeb94f23,0xebb1bd01,0x7303f685,0x913b8fc7,0xed01fc19,0x4657bd71,
	0xa183b88f,0xcb8f2485,0x149dc0c5,0x7ee5d515,0x17b11baf,0x5a2135ef,0xf9ffd0bd,0xe793463d,
	0x639d76c5,0x3561e3b7,0x230beb63,0x4f457d43,0xb539daef,0x46e31a1d,0xd00940db,0x52851d87,
	0xb761889d,0x0a69aee5,0xa4a97717,0x4c872e71,0x08db847f,0xced79e5d,0xf103cecb,0xe8216877,
	0x55514c93,0x973b6859,0x9a976879,0x50d9a20d,0x0e59ad19,0x9bcd8d35,0xa54da967,0x03d75cb7,
	0xc46fb59f,0x6ae92adb,0x5c77c0a5,0x40ed71fd,0x1ff5cdf7,0xaa15b9b3,0x1bcb4c0b,0x1b99e071,
	0x7a3beb3d,0x7701e9b5,0xb86b1d35,0x2bf9b8ad,0x1673e4d3,0x68859f5f,0x89df1e8d,0xdfd92a51,
	0xfab9e965,0x2f9b10b5,0x13155843,0x6babb107,0x691313e7,0xd86b0243,0x4b69154b,0x5b896181,
	0xf86b2093,0xab432421,0x87992867,0xc4355675,0x4d9941ed,0xad9b8ee9,0x02cd511f,0x141b3da9,
	0x745315bf,0xc31160c3,0x0795c0bf,0x844d04e1,0xd843ba1f,0x6e697a5d,0xb8ebbf5f,0x2983a6f3,
	0xddf30265,0x32915be9,0x7b2d70e1,0xa52118b5,0x1bd7cc37,0x93a32225,0xfd27b9e9,0x76315609,
	0x334d747d,0xb7d9a359,0xe10544e7,0xea658ed9,0x49976c6f,0xa89dac4f,0x0561a715,0xaf177417,
	0x20e1ee83,0x337b5d5d,0x6e3ba56f,0x024ba4bb,0xd143d381,0x6b29a763,0xcdfd99bd,0x83a73ac5,
	0x21b58771,0xc887e8c1,0xae75f78f,0xa5837841,0x811d1ea7,0xeb99aa69,0x39ddf13d,0xbdd5943f,
	0x9f478abf,0xfc8f7ccf,0xa3d33ce3,0xb741a7d9,0xa5e7ef9b,0xacbff4ef,0x3261f96d,0x6211bb2d,
	0x119b1867,0xd7a7c951,0xe6f7b385,0x6537f269,0x2ae50c97,0xc3ed0eff,0xc76b8aa7,0xcf4ddabb,
	0x1f31c4e5,0x0461968f,0xc701760f,0x4795d75d,0xb9d70055,0xf8f5691f,0x4f61a9c5,0xdefbae91,
	0xbd0f3931,0xefcd6555,0x69971b99,0x810f369f,0xdaffba0f,0xe629fc5b,0x87212823,0x050d22d9,
	0x4eb3d2c7,0xe97d0eeb,0xead957bf,0xded7f099,0x15212d7f,0x185bea3f,0xb20d4399,0x6ff7f43f,
	0xc62343a1,0x4385651d,0x7d6b9a9b,0xf89d8633,0x0d7df2df,0x2edd1cd3,0xba094681,0x28a74feb,
	0xc3dd3237,0x7275d235,0x8a6bb0c7,0x5097b8db,0xa7d5e6e9,0xfb81e6a1,0x4f7727b5,0x32937387,
	0xb6e5d985,0x2d5ff8fb,0xd17d635b,0x73712a79,0x266dcad9,0xa299a2b3,0x09372a91,0xabab4d3f,
	0xfcbba903,0x8dd954bb,0x88c317f5,0x1863fd75,0x4a05e465,0xbaf55493,0x84ad7eed,0xec631bbb,
	0x0165e4ab,0x2fefd93f,0x7ce170ab,0x411b74bb,0x71df9dc9,0x6deb484b,0x85b9e123,0xa7a90e27,
	0x5f6144f9,0x523792cf,0x30f5ec17,0x59cd93b5,0xbbbf25bf,0x974bb267,0x16bf3a0f,0x0af3e42b,
	0xffb596e7,0xf5c34637,0xfea58557,0x592bbe4f,0x23e50f83,0xe5654fed,0xa89f3f07,0xde318df1,
	0x39df5bed,0xfe2110bf,0x36115401,0xe06758ed,0xa513f2cb,0xf90f066b,0x32bd11eb,0xa3d5cc25,
	0xf3e16a07,0x51690833,0x3dd92c31,0x5b31687f,0x588d0bd3,0x859783e9,0x52fbe10f,0xb8d1cfef,
	0xc2418bad,0xf829dadd,0xb3233e81,0x1fbd326d,0x9613db55,0x70d1def1,0x6db9874f,0x7499dafb,
	0x07ff1fd9,0x3d736f87,0x898fb80b,0x8ebbdca1,0x13e7c68d,0xf311368d,0xcddb2c07,0x491ddf71,
	0x169bba09,0xcedb8579,0x2b3f6267,0x335f0d83,0x06cdb731,0xb7255247,0xc4c3e30f,0xe2cf1ffb,
	0x4e19c231,0xdc71547f,0x98d543b1,0xe35b8c01,0x4205bb7d,0xfa61422b,0xca4f4cc3,0x48a1cfc5,
	0x3cfb14cf,0x38c72ce1,0x89733e83,0xdee1df81,0x5751a62d,0xac99febf,0x9ce735f9,0xfc05b277,
	0xc043a2dd,0x78f1176b,0x8abbb1f7,0xf0a1efef,0xb6f5ae77,0x901b0911,0x6169380f,0x18efbc3b,
	0x237311d3,0x14817567,0x20d119a5,0x8dcfa5b5,0xcfb11017,0x59bb0aa9,0xc33958dd,0x75cfb1bd,
	0x408b5bad,0x8587a09d,0xe653ada9,0xf61d89bd,0x2ec7ab49,0xd0cb7591,0x1437aabf,0xc397c827,
	0xa0116ee3,0x68958b59,0xac65029d,0x53bb6571,0x9ffba4c3,0xef1d2453,0x6cc7ec8b,0xadb9451f,
	0x9903ce71,0x9cbf6063,0x9aaba99b,0xdb5fe2bb,0x4d8d05c3,0x0103f9f9,0xcbc9299f,0xfa271ed3,
	0x70e531d1,0x63972309,0x4f45d03b,0xec372c05,0xe03f5bff,0xc54f820f,0x36a159d5,0xa9559bed,
	0x7bb924f9,0x812b4f11,0xfed3e099,0x2ff58c37,0x9f5559b3,0x8d53909b,0xd9310183,0x1633f395,
	0x3bffa869,0x5c1378c5,0x947b214f,0xbacd0ebf,0x908d759b,0x5ce1e22b,0x25d9d187,0x1633ed75,
	0x82bdd117,0x1d5becf1,0xd1dd5577,0x2b711f83,0x982f8aed,0x0a4bbbc7,0xf57d4739,0x194781b9,
	0x8f71687d,0xd09b50df,0x6f1b5cab,0xcb132aef,0x98f77967,0x5e618af9,0xa77d4c73,0x49e17909,
	0x301f8c97,0x83df4257,0x3ad7d303,0xad633ded,0x942bc53f,0x347985cb,0x41bdd791,0xacf50c8f,
	0xe1494fdd,0x67bdf7a5,0x3a33b11b,0xd095a5e7,0xc98b3733,0x9a634ac7,0x909f8b6b,0x41f385f7,
	0xedf1594b,0xef47df93,0xc8d1ec0d,0x3d5b90c7,0xd75b7c79,0xf06f80f7,0x4703575b,0x22cddf69,
	0x8f97845b,0xf00d4169,0xb8d31571,0x26e7acf7,0xda5bc6cf,0x097377e7,0x1e4b173b,0xa3f56391,
	0x0e418103,0xc221dcf3,0x72dbfb65,0x0ae9c961,0x8dcd6c6d,0x4abdc79f,0xf65d3367,0x745d4d97,
	0xe06d73c3,0x60178a7b,0x160d487f,0xd195756d,0x6b75880b,0xcc23f0a7,0xf59540b5,0xbd796925,
	0xcb1f9591,0x86ffdac9,0x980723db,0xed9ba109,0xcb9398e7,0x77f3fc0d,0xa8dba085,0x4339b267,
	0x01d9d3e7,0xd66db729,0xe4efd111,0x7c313c9b,0x04e922b7,0x2b031b5b,0x238d20ab,0x840ff605,
	0x469d70c1,0xf0710165,0xff63503f,0x6505d90f,0x8cb94db9,0xd4a14897,0x1f8d9b85,0xd8ed712b,
	0x09eba299,0x999f33c5,0x2089fdfb,0x7a4947cf,0x16c786a5,0x96a1e64d,0x1d3f97eb,0x95457181,
	0x8ac93467,0xd9070115,0xd8013361,0x98b33ac5,0xb5531eb3,0xe5575f89,0x8385e937,0x270bf531,
	0xf6b525a5,0x183df49d,0x2bede60b,0xc771e45b,0xf921eba1,0xa791c7d1,0xbfbf4f43,0x36af4ae7,
	0x89b34a51,0x43511229,0xb8ef4811,0x5837977b,0x1171e7a7,0x56a37b33,0x65d1166b,0xc723b1cb,
	0xae45eadf,0xe8d57603,0xd229680f,0x0735678f,0xec05d17d,0x1e5fbe37,0x501bb787,0x55d9f987,
	0x1d6d644d,0x59ddf4f5,0xa13dd11f,0x1b21c87f,0x551fcc61,0xfd175de7,0xbf8177f1,0xfac52247,
	0xfeabc815,0xc9fbbc47,0x464d2adb,0x85272eb9,0x1783000b,0xe39d4fcd,0x7b650985,0x8855fcb5,
	0x08057c2f,0x6f3ff1c3,0xf7fbd95d,0x00ffaf23,0x1c7138b5,0xd54351f5,0xf1a72a9b,0xab7fc9f7,
	0x9df9db17,0xa23b53b7,0x23699d3d,0x34d79f29,0x8bad8717,0x07db8ae5,0x56ab460d,0x0bb3dbbb,
	0xf38bd3c5,0xfe03d8e7,0x8c3b3397,0xd16334b7,0xeb77e06f,0x03b729ab,0xc5511335,0x6ae3342b,
	0x2a3d89b3,0x802750a3,0x6c8ff605,0xb1d52633,0x4091be75,0xc3a905cf,0x5efd35ef,0xc58325ef,
	0x720ff4df,0xa8bb02b1,0x950b7aa1,0xfbdf4a89,0x2e3dbf63,0xd5013f5b,0x6b91de91,0x7283f431,
	0x298781bd,0x9a4f4f5d,0x8ccd3403,0x3fb13921,0x163f45f3,0x7795ded9,0x796d69fb,0x4353729d,
	0xfda3b14d,0x39f54f71,0xb17b1147,0x97ffe9e9,0x38d7195f,0xbdb57553,0x7d730181,0xa3e9a55b,
	0x09e7b903,0x4f417435,0x57351e07,0xc9f95549,0xd4c9055f,0xac31bc53,0xf3073b01,0xbab76115,
	0xf85522df,0xa4452775,0xe89d225d,0x65531429,0x47557a31,0x5a5f35e5,0xfc0bb8d3,0x88abeaf7,
	0x216f6d55,0x25916b79,0x06d542e1,0xe43ffff7,0x2c3d2c8d,0x120fcc8f,0x80e1c9d1,0x093b98a9,
	0xac37ab65,0x02377b0d,0xa97fa0af,0xcb6fd299,0x7dc3b5ad,0x6f91735f,0x50670955,0x52577057,
	0xae2d2483,0xcbcb697b,0x3ebdf961,0xca13c67b,0xb4ab334b,0x81bbc5dd,0x4005ff3b,0xb471c8a9,
	0x4b57f4af,0x965dc28b,0xcb314711,0xd9df3687,0xe835e7a1,0xe9dba813,0x4b99bfdb,0xda7be8c9,
	0xd633ac5f,0x18812a89,0x09fd6057,0x5f053e27,0xee23d969,0xfbc5e68b,0xb5878c0f,0xe9e9a863,
	0xefc5f08d,0xcb47fe3f,0x8cc59851,0x48375945,0x7ab973dd,0xddcdd651,0x26af7133,0xa2a90f9f,
	0xa78f1ab5,0x0a43f2f5,0xdba75e95,0x2ea5044b,0x40b726b7,0xa8c1f4eb,0xce75e91d,0x7f31f727,
	0x9b91d8cf,0x3385b677,0x9547df3f,0x76035c21,0x11610631,0x87f58867,0x82b97a2d,0xd471a827,
	0x1851cd57,0xc79f8f0f,0x8ec9a2e7,0x6c81be35,0xfc756b05,0xd93b3f4b,0xdfdf5737,0xf1dd7c49,
	0x38cd2f45,0x89a5fb85,0xf3cd2ea9,0x6ad5686d,0x7039926d,0x4ce5d0a5,0x68c9ff97,0x41637db3,
	0x06896a15,0x9f295325,0x6673a41f,0xf42d1935,0x596f3e23,0x05c59bfd,0xa6d7df29,0x67790713,
	0x9987bdc1,0xb03b65b7,0x1f616163,0xd63baf77,0x43575461,0xb92d495f,0x49edee45,0x630f6393,
	0x3849dec1,0x076d1b87,0x0db7a10f,0x4935ca9f,0x77b37fe1,0xceef6951,0x486b51c7,0xad976edb,
	0x77cf960f,0xb1d3155f,0xf7171a3b,0x0fc96a93,0x1ec5cfdd,0x815d14df,0xff35fb05,0x5b033515,
	0x5b9f6127,0x9efd4c87,0x97a3a083,0x972b8fbd,0x5f515811,0xfd498d95,0x51ab47dd,0x39c792ed,
	0x75b71203,0xc0ffb2cd,0xc1fdc401,0x170bdb0b,0x7e97d0b3,0x8205dd7b,0xc9b1a2a7,0xf2d3d58b,
	0x069b6f1b,0x2c69d275,0x7f47714f,0xb19d2de5,0x0059367f,0x8163771b,0xb7a9223f,0x29975a99,
	0x1d4dd369,0x384f6e4f,0x2f259187,0x93934a33,0xc6db6aaf,0xbfb5d57f,0x527329fd,0x9c0b3043,
	0xb74fce69,0x9e4121a1,0xa7b5aa41,0x141f7263,0x32ddd2fd,0x73cb1c31,0xd77309bb,0x429bb531,
	0xe0a1c415,0x9a530035,0x559b7d99,0xd4f1095b,0x43a1f9a3,0x66fbb73b,0xaa899dd3,0x703d388f,
	0xd3c98ce5,0x0b153657,0x5bfbaa27,0xe23d3287,0xb6eb2d5d,0x1515fb29,0x7619ef1f,0xf25f9a05,
	0x19c515d5,0x9199a8d1,0xb4754b09,0xd2b571d1,0x28fb2161,0xcc69c501,0x4b05d2fb,0x30f7e9bd,
	0xaa19005d,0xb17394ed,0x4f2997d5,0xe7894ba3,0x34938d6b,0xcdcd1a51,0xc0ad8b3f,0x4e750863,
	0x0ac74277,0xf0b33073,0x32bd84a7,0x2c6de4e7,0x92f7cdb5,0x6c8fc921,0x14f36645,0x47cd471f,
	0x7051c6a1,0xf7ed49af,0x9c516219,0x9793a307,0x3be782fb,0x2e8307fb,0x4c3b5ee9,0x146d079d,
	0xddb70bcf,0xb231e769,0x1f877d45,0x29adcbeb,0x85a53273,0xebfd15e9,0x5167bc83,0xc64b5c05,
	0x447dc57f,0x6d13e8ed,0xc681bfc3,0x0deb2601,0x44f5e5d9,0xefcbda75,0x15d9b2ed,0xa9d7a701,
	0xa4a77bab,0xf8a3a605,0x31e14faf,0xba01982f,0xed17cb69,0x174185ab,0xb1710281,0x66033bbd,
	0x2cb32acb,0xc7758ef9,0xb8c92fa3,0x0e21c9e3,0xafcdd5d9,0xf2333011,0x8291981b,0x1c43fde1,
	0x59a3e3db,0x0e99cc95,0x88dbdeb9,0x74fbc303,0x9d5b5c65,0xe2ef7ab5,0x4e1d2d13,0x88850199,
	0x16fd6c53,0xe5a3e023,0xc639f889,0x03c38bfb,0xc481bac9,0x3e492f1f,0x5f77e743,0x213f2b8d,
	0xdec1de2f,0x66a1436b,0xab87d52f,0x9a2bcdb5,0x5281f13b,0x6b93df59,0xa87ff905,0x3761d0e7,
	0xd96f47e7,0xce2b08b9,0xa9e32945,0x0263719b,0xb31f4477,0x049f85ed,0xe1994135,0x165d5753,
	0xfe0b4c77,0x9b4f7ad7,0x88f3a5e5,0x111f4197,0xb09bddb9,0xf5bf25e5,0xa9a7eb2b,0x2425d4f9,
	0x3217c357,0xaf9fbd0d,0x86d598a7,0xc5918811,0x93b76ab7,0x9dc56acd,0xa6090ec1,0x012db083,
	0x69955883,0x6f2f6b27,0x782f8ba7,0x696baff7,0x43b5bdaf,0xee0348ab,0xa2a15053,0xa865411d,
	0xc7072c75,0xe08f396d,0xe821e57f,0xb0dde4af,0x66596d57,0x8a4b9c0d,0xb1d380b7,0x8f3f6e6f,
	0xbb6d7423,0xccd394ad,0x384b8949,0xda9bb227,0x7fe574ed,0xe8efc9fb,0x4c813d4b,0xc5ad50a5,
	0x264b190d,0xdf8b422b,0xc0d3769f,0xcfd7a4c5,0x1317d427,0x72bf5fff,0x720b8fe9,0x1621d067,
	0x75a35929,0xc6cbffb7,0xf0596999,0x4441e975,0xc1352f43,0xa311b423,0xc8558ee7,0x258f46df,
	0xc5f766f1,0x53232397,0x6bff7ad3,0xd60deda1,0x69ff6ef7,0x27b584f1,0xbbc1fd23,0x93671db9,
	0x02490961,0x97a53c97,0x2f69bf67,0x2dedff33,0x4bb96081,0x00fb9973,0x9f2fe9f5,0x199b6f1d,
	0x041b3bf1,0x09e5b1ff,0xacb5e8ef,0x1f11ec95,0x23235597,0xa1b96135,0xcc015139,0xac9da5b7,
	0xb36dce9d,0xa1f5639b,0xec87e583,0xc72fa4af,0x4b7fc477,0x0f3d943f,0xc21dbb45,0x9b5f1caf,
	0x26c305df,0xfa6549b5,0xae017fbf,0xae75d6ef,0xde91e7d7,0x015dd319,0x47dfdcf7,0xaf55bfaf,
	0xc3213aaf,0x70471515,0x86c7febd,0xe795933b,0xd4975ef5,0x026746d1,0x8a2f37a7,0x4c6faae3,
	0x5c037a87,0x432fcf07,0x02f7c617,0x2fc3ea01,0x2459cd89,0x8f3140ef,0x3c6bb931,0x911fcaf3,
	0x53712763,0xb52d7953,0xc537f5e5,0x0eb18c27,0xe3137bcb,0x3709db7f,0xb8755beb,0x76577d0b,
	0xb9eb97bd,0x2ad5ae45,0xa6a70ac3,0xf6916b19,0x648bf679,0xbbc39907,0x1eb1c6b3,0xef8b2ed3,
	0x6e71b68d,0x4b3740a7,0xd6e77dcb,0x641558c1,0x5b01aecb,0x31b30495,0x7601ece1,0x0aa9fe75,
	0x3e87a34d,0x1fe5dbc3,0xfc1d6497,0xfe6da789,0xf7399a79,0x1fa751af,0xcbc5ae51,0x10275a9d,
	0x063151f9,0x34f3a361,0x52e9113f,0xb74dca5b,0x0873d3c1,0x9ef3fc63,0x53e1775b,0xa2f5a273,
	0xcfeb2b0b,0xb8f3d3cd,0xce6db25f,0xeae5f49f,0x1c71395b,0x7b696939,0x88b7e0d9,0xe085c5a3,
	0xf4bdab7b,0x9cf561cf,0x384bf313,0x7fe9ba43,0x9f750e7f,0x535b853b,0x4b275025,0x80cbe455,
	0x3c2704c5,0xb48b9ab3,0x50a59aef,0x078bafaf,0xfc439aeb,0xb79b65f3,0x02939719,0xf635ef33,
	0xfc29bce1,0xd5c9c443,0xee1f2e13,0xdd7d09cb,0xbc1bcad7,0x4b7be96d,0xbcdf9411,0x8db94767,
	0x39474e49,0xf93fbcc7,0x1dd78d15,0x47ef3e03,0xa6c1cefd,0xe4cd562f,0x4e6dd1e5,0x8ec75e9f,
	0xc683c7fb,0x5a019b0b,0x43719511,0x9795a241,0xe275bc97,0xabe3fb47,0x721d27f1,0x5b5356ff,
	0x655f6d6b,0x959f4e59,0x3911bfa1,0x47a10cef,0x13f92d5d,0x3b8fd03d,0xe9535a0b,0x8fcba335,
	0xe5dd5697,0xcc2d3e79,0x6f55c2df,0x1dc374f7,0x7e8fdf8d,0xc121151b,0x9bf1b891,0x2325a669,
	0x467d0ff9,0xc03bebb7,0x0d633163,0x4a3191c3,0x23fb55df,0x1c6ff26b,0xb857c05b,0x86d15447,
	0xd4453a89,0xf6dd8edb,0x10db1a49,0x87977b3d,0xe47d778d,0xffc91937,0xd367bac5,0xc6c1d0f7,
	0x4ab32bc3,0xd7a3b931,0x6ddfa92b,0x3b2d49cd,0x9ed93051,0x10016309,0x08875da5,0xa9671123,
	0xf3cb8d9f,0xcc9ff483,0x2f0fc623,0x94a1b661,0x504d1065,0x046771ed,0x19936b59,0xcfb779f7,
	0xc80ffe99,0x6265631b,0x9591b5c9,0xae27ba5f,0x34a1ec83,0xc6d15069,0x8ef352b9,0xd51f811b,
	0x8e7fb1a9,0x68075fc1,0x3905b939,0xac712fb5,0xe6117de3,0x938d118b,0xd785cf21,0x6f954cbb,
	0xfca10e4b,0x0f131dbf,0x278dae0d,0xdeaf70c9,0x7d630243,0x197170db,0x68ab8869,0x8f89537f,
	0xd6735079,0x0ba148e3,0x05cdae5f,0xde95f887,0xb1d7dbdb,0x99cb7263,0xde49b2e9,0x7fedfc91,
	0x0e7928a9,0xb43da573,0x2ee3b0c9,0xb0550259,0xf92f3165,0x086f02ad,0x1ac1af81,0x06353f9d,
	0xe5b55bdb,0x21ffb039,0xd4732863,0xe29f2a27,0xa7af8e1b,0x2bb196c5,0x66f3ab85,0x825144cb,
	0x0ba96385,0x50733e83,0x1ea1a4c9,0xaea90c5f,0x101781b7,0xbc5fcc31,0x924340d3,0x0eb304c7,
	0xbe570da1,0x3daf1e17,0x4c0b7215,0x1821e5e9,0xa3ab4073,0x85cd08ff,0x129115c3,0xa04de8b9,
	0xea3f1cab,0x0a45b53f,0xd1d738df,0x0d39342d,0x12294309,0x85cd1bb5,0x24417d2f,0x26916a4b,
	0x4a65e79b,0x1945a2c7,0x7ba39e43,0x86a55519,0x69d7e6b3,0x0cb1db61,0xea351673,0xab71b3a9,
	0x884bf9ed,0x30415df9,0x8b95e3dd,0xa7972713,0x37770d2b,0xdd4bc78b,0x8dcd6d67,0x73613f7b,
	0x5bf3b39b,0x974dd69f,0xda4d87c1,0xddc1a907,0xa649bcad,0x4ceda83f,0x5eed9a65,0x1d5178eb,
	0xabdfe91d,0x38fb1501,0xf6ede48f,0x01539a5f,0xa00fbfef,0x63692e03,0xf3f5e247,0xc2b35ba5,
	0xad11836d,0xc25bd9eb,0x4717d15d,0x75031b05,0xed0b462d,0xfb1191e3,0x49c95669,0x177b13d1,
	0x03092007,0xc2ff3ea5,0x26ed41c9,0x45fd4b63,0x54018321,0xe0b7356b,0xe3c974a3,0x8a179e1b,
	0xdfcbb0e5,0xccfb54fb,0x0911e5e7,0x4bf9ec63,0xba314f05,0xf3ad42a3,0xebd9c74f,0x637d67ab,
	0x23db1c7f,0x94dfc737,0x96a5ca57,0x4925ff6d,0x435dc693,0x45c54c15,0x525b8547,0xe71dee2d,
	0x7e35ddcf,0x11bd7821,0xcf4bf831,0x0a35666f,0x71c9eb05,0x3b51eccb,0xee2f31e7,0x72e95fc7,
	0x8c61a451,0x9d2b2305,0x2927150d,0x865b83cf,0x46354217,0xab21684f,0x9cb93d07,0x9f533b29,
	0xfa5ff3ff,0x1335fbad,0xb0d70307,0xff47da7b,0x5fe375ff,0xfe8b4aab,0x61d9a301,0x5f4fef77,
	0xa2afc551,0xf2714e61,0x298180b9,0x212dadd9,0x1c97f579,0x515f0869,0x87f38cb1,0x204d7c5f,
	0xae552541,0x7bf11fed,0x2cc3c93b,0x22bfa1d5,0xb89193bf,0x91ed9e95,0xbfe9ef6f,0xea3d120b,
	0xb4d3d54d,0xd343cd99,0x4ac33429,0xe52d5ad9,0x6e93288b,0xa10b32b7,0x411b2d15,0x7f97b121,
	0xdc2beb69,0x1e7fad31,0x2a21d59d,0x142b1dcf,0x97e13019,0x7207b2d9,0xe96bb3fd,0x7d47cad1,
	0xf8df7213,0xa633acff,0xa7fd1e31,0x45eb7021,0xcc3b6b1f,0x2ab77585,0x5d3f9f03,0x7ac3e0bf,
	0xadef0845,0xf571f3cd,0xf7fd7aff,0x1b1fb7b7,0x01e37ed9,0x4369d9c5,0x2773557d,0x29f92519,
	0x8ce18177,0xf9cd80e3,0xc441f59f,0x5ef7daff,0xad9d9503,0xa6f1e723,0xd96f2b49,0x775f1a87,
	0x35b385a5,0x2357cc0b,0x4d6bd42d,0x2727e0df,0xe2a9fbd3,0xd2a1edab,0x2b1100c1,0xa9e53435,
	0x76e93147,0x84a16593,0x8a9d3943,0xf3df90c3,0x72c9c605,0xf64d25e3,0x1abbe2bb,0x82ff75cb,
	0x6d85b559,0xf2bf9641,0x497bc3fb,0xcfd51297,0x0e416ad5,0x144350d9,0x0d51aa95,0x5e9b1375,
	0xa509f753,0x2543ff61,0x4e232fed,0x70378ec1,0x63d165f9,0x21575815,0xee359e29,0x532f11db,
	0x37753131,0xd63d3abb,0x7339f535,0x54b9ce2d,0x40bbd7ad,0x24dbeda1,0x4f470fcd,0x51abe627,
	0xed4d916b,0xe23f7a9b,0xc9e1e86d,0xe78bda45,0xb0c324ad,0x58a12c07,0x88ebfe5f,0x45811605,
	0x5d95dafd,0x685d29c9,0xb9b9daaf,0x9d619cf1,0x1e27962f,0x48fb3651,0xda03b537,0x34a5d79d,
	0x0dc9055f,0xea298b93,0x20e73993,0x156d809f,0x71aff9f1,0xf4bbd809,0x87ef6c2f,0x5f85b199,
	0x91f1dc8d,0x6bb15bbd,0x7409af37,0x39611037,0x32974229,0xed33253b,0xfe91e7a1,0x61171b25,
	0xac8da0ff,0x938d6e97,0xde45c231,0x5d6d9721,0xa6a52595,0x76351a6f,0xf04d1869,0x4ecb1beb,
	0x6e9da7b1,0xcac950e7,0x613b759b,0x6045c149,0xf21bbf6b,0xa6133caf,0x7605bbdf,0xd893ec11,
	0x57a7fa1d,0x5cfde7f9,0xf50de913,0xcb1b3b1b,0x37b72f67,0x859d3985,0x2f1bfbdd,0x68e39445,
	0x75a9f639,0x98351195,0xa85df8af,0xf19f517d,0xb8bf39c5,0x302986fb,0x616d0ebf,0x44a98db1,
	0x8527ee85,0xed074407,0xc04ddd0b,0x120591db,0xf4f3e73d,0xf387039b,0x1963d75d,0xab5b61fb,
	0x1123c9f7,0x0e852e19,0xd87fcb41,0x74ff6a1f,0xca972507,0x7007966f,0x49db8511,0xf6e94b53,
	0x931da409,0x123f5713,0x031594eb,0x8dbdc8b1,0x966b64e1,0xb87fcf03,0xec3933b5,0xbbc5d45d,
	0x931b6cb7,0x9047bec1,0xe8b34821,0x19f3bc7f,0x53b13d01,0x723d855f,0x205d8ba5,0xe8e37847,
	0xc79b887b,0xc3317d6d,0xe877cf7f,0x41d314f1,0xbc2d0825,0xf5177a0b,0x4cab61b9,0xe7b142bb,
	0x35a1704d,0xa80d63df,0x3807921f,0xb80f01ef,0x681d8583,0x6b5bf615,0x3e03574b,0xbc256fdf,
	0x50af51a7,0x1e6f9b63,0x0381139b,0xd9d7b3e5,0xee4978d9,0xf1df6b05,0x47c97a35,0x24af0c63,
	0x1ac7ae85,0x086745c3,0x8d8b940b,0xcedffbbf,0x03ed4a5f,0xb7f112e7,0x63dde4d3,0xba41956b,
	0x4469fd61,0x6a891d47,0x4f43b00b,0xa959eae3,0x9ccfa6cd,0x1f659041,0x52a55dfd,0x104f98a5,
	0x4c9b4933,0x8be514bb,0x184f00b5,0x85f5733d,0x0b2f1f61,0xdc8f8e21,0xbafdf90d,0xd4c95439,
	0xa0dbd175,0x160ff767,0x2ecfbba3,0xabe70737,0x1fd1c9d3,0x163d600d,0x4a4bb5dd,0xf01f56d3,
	0xbd2daa23,0x35170917,0x6f6552ed,0xace139bb,0x49f5e05b,0x85c3a213,0xd47120c9,0xa5471f9b,
	0x4c135bb7,0xb78fa615,0x6d331531,0x85155e31,0xb75d61b7,0x96f3d8bb,0x73d1f2a9,0xb1b3be3d,
	0x468f8329,0x2e8be329,0x91dbcd85,0xbb332887,0x744bb11f,0x881f110f,0xa94bb0d7,0x6d5172e1,
	0x142171f5,0x0d9d2d9f,0x3d7f6383,0x806f4d23,0x8b83364d,0x8a198099,0x7c414d2f,0xea974e31,
	0xaacdce13,0xcad5eb41,0xe6c17b49,0xd07b20f3,0x2645fd79,0xe0332565,0x9a97c609,0x1675d159,
	0xaf1731fd,0xfec51a57,0x3ac5156d,0x9187395d,0xac555761,0x003f65f9,0x78afc63f,0xd85d8e01,
	0x93fdccaf,0x8481f1ad,0x3d292f0b,0xb4470c4d,0xe3f3793d,0xb28fb163,0x7169452b,0x3241c653,
	0xbb0301a3,0x9999808d,0x681361bd,0x53ed902d,0x11e11cc7,0x31f51f2b,0xe62926a9,0x60930cfb,
	0x942908d1,0xfe214ebf,0xcc21839d,0xd629dbe7,0x19612039,0x4bc10f5b,0x5ed1db11,0xfa47e521,
	0xbdf58eb5,0x14a9fc8f,0x30794743,0x0b2fc6e5,0x9c37264b,0x7fc9ca7d,0xa9c1ff3d,0x10cd6271,
	0x25655447,0x0243e2c7,0x32b9dbcb,0x4db1890f,0x1aa3363b,0x205d219b,0xfbdbfc87,0x5017c913,
	0x25fdcf03,0xce83b2af,0x67078ccf,0xa2e15ad3,0x13695bc1,0x724f0e3f,0x1085a8cb,0x1e972db1,
	0xa9bfc8e1,0x837b1613,0x78036269,0xda6f1519,0x23c74717,0xccef5275,0x499be661,0xbd411577,
	0x492d005d,0x4dbb4f3b,0x46cfc131,0xae8fd149,0x2783ecf7,0xba1318c3,0xcf854423,0x6783160d,
	0x6b49c86f,0x9c55d8f3,0x0b0d0a43,0xe3f3894f,0x58df269b,0x16099437,0xb1219d6b,0x7353759f,
	0x6593a893,0x40dd0685,0x72df3b39,0x69cbb795,0x709b51bd,0x2fa7a059,0x03d1ba15,0x7121cad5,
	0x9c11fcc1,0x8f63a3b9,0xc2e78e2d,0x79cbf705,0xc5f9f097,0xe83b6133,0x0379ee79,0x4be19cd9,
	0xa1419575,0x7e7b94db,0xf64919b9,0xb825a309,0x6ebb49e3,0xd399e34f,0x327bbb71,0x69010357,
	0x562757a9,0xc73576b5,0xdea370f5,0x5389778b,0x5f2508db,0x5815bbb9,0x79b76e59,0xc8774677,
	0x0a43dcd3,0x05253e8f,0x4419437d,0x252b30f5,0x89f7dd39,0xce7da7f7,0x4891c109,0x24b37ee5,
	0x9b9b12f3,0xd65bda35,0x054ffd6b,0xd0bd2c31,0x00731b37,0xa2252e17,0xb4e979db,0x12a735c9,
	0x96addc7f,0xfb6bcff1,0x37636757,0xe47106a7,0x125d5b8f,0x70df3c9f,0x9b230ba9,0x21c504cd,
	0x567fb071,0x7765de8b,0x45fb465f,0xf8f73e43,0x6df51b7b,0x2afdca9d,0xbe2135cf,0xfc01361d,
	0x248f3a45,0xafdb9d4f,0x1337fc19,0xd183d171,0x3fff5cb5,0x33517799,0xe743a423,0x85c96461,
	0x58e1f9f5,0x8ce11c05,0x17b9269f,0x7bc7df17,0x53b94577,0x7f2d2b9f,0x066d8f05,0xfe131ac3,
	0x79f7e3f7,0x990782f9,0x82a1408f,0x6ff346a1,0x32e9c07b,0xb663b735,0x51ff5b49,0x1e5174ef,
	0x5cd1014b,0x2161b2f5,0x599540ff,0xb0bb47f9,0x45d11cfb,0x53457367,0x66dd3a4d,0x3a71bf0f,
	0x44f50f67,0x557fe541,0x98b53b8d,0xeb512389,0xf331aeb1,0xc2a5e1c1,0x6867c9e7,0x60e715c9,
	0x04612045,0x67754ba9,0x52a3004f,0x9767ba39,0xc04b6dd7,0x83d54c4b,0x2083b477,0x7aa7064b,
	0x1b993a61,0xabd3b077,0xd083bbdf,0x172d2d77,0x70e19727,0x48a7658f,0x1f8d50d1,0x6b212e3f,
	0xd99ff8b5,0xb9ad1673,0xb1f3975b,0xd7577f2b,0x27374bdd,0x156de897,0xdc6b4253,0x3047dbcd,
	0x7bf52ab9,0x8a9358e9,0x0d175859,0x6f1531bd,0x840d31af,0x60f738ed,0xd47f18d5,0x028bad9f,
	0x4e9b7469,0x9a99cba3,0x8e9300f5,0xc01de819,0xc6a512d9,0x349b029b,0xaba9f0b1,0x74e132df,
	0xcc15ee3d,0x084fdae9,0x99856fc9,0x169d05ab,0xecc37e15,0x4c29da2b,0x4c4d12c1,0x94b98b39,
	0xbd67c52f,0xb4c7ab87,0x6793ffed,0x49474e59,0xd2a7669d,0x35f1dca9,0x074d9461,0x0a0506d7,
	0x5a0fdabb,0x6395bac7,0x28db28fd,0xd951868f,0x5313c42d,0x72c94f9d,0xb409f769,0x3737c661,
	0x681164db,0xdac97e71,0x24031f13,0x12691335,0x674b32fb,0x95ff4111,0xd065ca35,0x59415b01,
	0x5bed8e07,0x02f704d1,0xd62b72c9,0x2ac399b9,0x470f93c3,0x6569278f,0xa0c1479b,0xa7976661,
	0x78a9153b,0x072f94af,0x12f5b139,0x630fa003,0x88a1abc1,0xf9558221,0x5001f6f9,0x74293aad,
	0xefc3edef,0x75054d57,0x248303fb,0x26832c7b,0x40c5c4ab,0xdc977851,0x0f854c27,0x4b697a8f,
	0x013fe01f,0x5c89c693,0xeb77d12b,0x2acd660f,0x22bb4cbd,0x2c817a29,0x3731477f,0x1449b92d,
	0x1b9f2843,0x704fb0ab,0xfef35b63,0x901f3425,0xa04576b3,0xb8e7e035,0x656515dd,0x303b1a37,
	0xfbe51757,0x2567746b,0xcc9961bd,0x012fdea9,0x09a7d9c3,0x24178b7d,0x9f07b099,0x9b33f1d1,
	0xcd93b2d3,0xd365d31d,0xb88dbfd1,0xd32bae05,0xada111a9,0x02e5858b,0x6f737d8d,0x0b9f64a9,
	0x4aa954b3,0xd4598689,0x3d6d0dbb,0x25c58b23,0xf9755ea1,0xfca3a069,0x0891ef15,0x127507e7,
	0xdbad4b6f,0xa4d5e0fb,0x0c5d4015,0x03339f6d,0x98e54561,0xeb2316a1,0x62bd2407,0x3b278137,
	0xb79d7a03,0x03ed6d3d,0x2d0147f9,0x8023f4cd,0x96352f25,0xfab72b3d,0x5cdf87c1,0x2ba326c1,
	0x03fdf7e7,0x13318e97,0x1d77b2ff,0xdbc915ad,0x7a2709a9,0xca31c9c7,0xdc55721b,0xc45f9f31,
	0xf4cfb117,0x76b520d5,0xf2654b45,0x9fd5acf5,0x6bf9e723,0x8ae3264b,0xed01c771,0x404981ad,
	0xec93060b,0x7509183f,0x76ebb761,0xc07d2613,0x51719e51,0x209f5d51,0xe149989b,0x54d7f5e5,
	0x9c4f6bbf,0x174121a3,0x4cab1a6d,0xbc6f4ced,0xeecf6a69,0x41b713e3,0x7209c2f3,0x51fb53fd,
	0x23810bab,0x48ed4245,0x0bc7b407,0xbcddedef,0x06d78b29,0x96fb1789,0xdea99053,0x4223c4a3,
	0x302d63cb,0xf82177f5,0x62e18045,0xb57d7603,0x7ac9e4c7,0xdbc1fe53,0x0d075715,0x0a45e101,
	0x1ed5e699,0x356d58f9,0x371bd7c3,0x847d9293,0x6a67a001,0xfdd9c6c5,0xa9851a15,0x89cf52bf,
	0x1a7b9b0d,0x53e3b41b,0xc4170f9b,0x1291d189,0x53f5ca0d,0x3d9377eb,0x470728ab,0xbab77407,
	0x3ca1bca1,0x091730a9,0xbbf71967,0x72e9414f,0x3433f4a9,0x4dc5c151,0x7eefbeb3,0xd16fef83,
	0xad475b51,0x8d1bee69,0x675d233f,0x033910cf,0xa663d60d,0x73bd9afd,0x111da483,0x5ce5605f,
	0xc2f1fb95,0xba7f25a5,0xc56d37bf,0x8bb32f71,0x0447e8f1,0xa751e57d,0x03f5cef9,0x668ff245,
	0x22a13669,0x2e55c72b,0xabc5de01,0x5f09ed23,0x86230c93,0xb2cf09d9,0xc457ff6d,0x925b015d,
	0xdfd95947,0x68311c41,0xe68bb99f,0x7a6b9a4b,0x62b724a9,0x530d999b,0x45a763bb,0x3ebfba51,
	0x9c9b0627,0xea2366b1,0x585d2ab1,0xa58d27d5,0xef47b971,0x5759eecf,0x21c73639,0xa4adba4b,
	0xa969d383,0x58bf80c7,0x1a61edd3,0x92a1c72b,0xbf9397a3,0xc187cbfb,0xb9175dc5,0xf793aef7,
	0x2543ec57,0x9b157d4d,0x9c37bc1f,0xfe578a37,0xc5dd7077,0xe5ebfc2d,0x52790db9,0x8567f67f,
	0x1dadb01d,0xfab7478d,0xc401eb2f,0xcfe30363,0x72e979ab,0x8b53f2eb,0x3b5365eb,0xd6993f89,
	0xaea952cd,0x43b9434f,0x0e610d1b,0x38f7e599,0xd5f50d77,0x0b136c43,0xe78112b9,0xce1b2945,
	0x22b97ce3,0xe4adecdd,0xae799081,0xd5c5a443,0xbcc94a93,0x70fd0cbd,0x116becfb,0xc95fe357,
	0x12dfeb57,0x0ea37905,0xadeb6077,0xccfd1349,0xd3a1b43d,0x9b630163,0xd9ef9a0b,0xc057cded,
	0x869b0fa3,0xd52d750d,0x0cd98497,0xefd30719,0xc543d22d,0x5b179fbf,0xe86f2bc5,0x657719af,
	0x13f3afc3,0x4e5f66c1,0xe1e5c0ff,0xd9f7f499,0x5aefd09d,0x936b05dd,0x8ad1c07f,0x45af67c9,
	0xff658631,0xb2c96c69,0x7a313645,0x119f9137,0x9c692045,0x5a31ba43,0xd5712317,0xe87169e3,
	0x5bf5e1e5,0x7d7fdcd1,0x79610185,0x277972d9,0xefef1663,0x17bb4bff,0xc3376ae7,0xefaf8227,
	0x2b25465b,0x8c11e741,0xf993dc59,0xd6b7afeb,0x3a498caf,0xa6dbf299,0x55819bc5,0x37dd6341,
	0x7cf70b8b,0x3e933387,0xab6dbcdb,0x250f7f57,0xfeb38163,0x74e12e19,0xb431460f,0xf7e9b05b,
	0x8febfdf1,0x979581e9,0xf60d75a3,0x82afd885,0x7ef3b739,0xa1a3670f,0x4dab269d,0xe1499d1b,
	0xf105fe85,0x5c2b4b31,0x171955cd,0xea4b1363,0xdb49556b,0x1f718e7f,0xf6d1c6cb,0x3fed8daf,
	0x9bc9a2c3,0x33e560ab,0x42b1c8f3,0x01138859,0x327787b1,0xd31dbdf5,0x0b031c6f,0x1a49b6c1,
	0x1a35d4a3,0xc8d58c21,0xc377f72f,0x36bd304f,0xc1c11e49,0xb3f7d77d,0x8c2529e7,0x514bbd77,
	0xa4cb72a1,0xe78f2fdb,0x1a8d6519,0xe57744b3,0x04e72deb,0xebd5259d,0x42979e0b,0xc0695781,
	0x4291efb5,0x9f25e6a7,0x1f9593cd,0x71f3df6b,0xd62dafd1,0xf705fb63,0xdd3d7437,0x5d93eb03,
	0xe907f35b,0x612523c9,0x20b1a0e5,0x6b679ae3,0x8e5321b5,0xc45d5457,0x11779443,0x593b2eab,
	0x9c2df98b,0x21a7d311,0x0283e67b,0xab813205,0x249b25d1,0xd52b7483,0xbb297289,0x3e53c9a3,
	0x8e87f2c1,0x7737f8c5,0x602d9b29,0x7675203b,0x4ec722df,0x5d438871,0xfcb5afe3,0x124df391,
	0x4117e3f5,0xbaed51af,0xab537207,0x9af3416f,0xa11be419,0x62f9452b,0x5efbb9ab,0x751d14a3,
	0xa35f86a3,0x2855f31d,0x4c133ab1,0x922f720b,0xae573939,0xdf1b883d,0xf15f69bd,0xc1336583,
	0x335fe8c5,0xfd85ead3,0xc1118141,0x9fdb2ef7,0x27bd9679,0xdcfdf7af,0x69c3a671,0x2b818f59,
	0x1d9d0cd3,0x9b0fdf21,0xbf712e4f,0xf22935a1,0xfd11b493,0x9a71a209,0x448702a3,0xe37b4bcf,
	0x5d1789c7,0xa403aecd,0x52d326f9,0xc1c923ef,0x7c9330c1,0xa7c99e59,0xe48d5da9,0x330f0511,
	0xdb512b1d,0x1df51123,0xfd57ecd5,0x71ef184d,0x73072cbd,0x07d7ac27,0xb3398361,0x9eb375c7,
	0x904d90cd,0x90f335ed,0xd7a33dff,0xb04d51a7,0x4babeec1,0x4fefd37d,0x406dcc23,0x0557491d,
	0xa28dcf53,0x27956573,0xb0d7b50f,0x9513cf63,0x30458187,0xc7dd04e7,0x6289bcc9,0xc06dbab9,
	0x87130fa9,0xcee9a07f,0x2e956923,0xc2f5f16d,0x29175449,0x89f9b96b,0x5671a6af,0xc3e736cb,
	0x215f2f47,0x5681405f,0xecff8dd1,0x8725182d,0x3cdfdac3,0xa3139297,0xdf8747ad,0xbe39f9f7,
	0xe3756027,0x907196d9,0x9eb71335,0xf9534491,0x90e32d2b,0x327dfa73,0x67ab6a1d,0x3851b16b,
	0xedd7c8c5,0x71498e39,0x2cdf45e7,0x1bb5b801,0x88e5a83d,0x8a09c387,0x1f3f84db,0xb5a51ad1,
	0x2f87241b,0x301b4947,0xd71b6f05,0xfaf99465,0xe7258d33,0x4e09c8e1,0x1d275b3d,0xd425a451,
	0x860761a1,0x667dc34f,0x53897425,0xce517c2b,0xec65a1c7,0x954d8e0b,0x7ec59d21,0x6c450c95,
	0xdd574551,0x307b7019,0xeecd7763,0x17713239,0x77e7d033,0x092bdf0b,0x87fb86e1,0xb0f302c9,
	0x4ffd07a9,0x4cabdbf3,0xac0b7759,0xc28b39fb,0x276fc733,0x0573706d,0xc3278153,0x4fa5c695,
	0x46f7f59d,0x3c1f4ba3,0x64e1ef1f,0x4651775b,0x773d99fd,0xb8757f3d,0x2131c1d5,0x904bc823,
	0x99c910ab,0x62655c73,0xe9757651,0xc3f5cec3,0xe213604d,0x43077103,0x1977ea3f,0x7557481f,
	0xae75aecd,0x2595a42f,0x2067610b,0x2727c51d,0x0135d65d,0xd87773c9,0xc9dda8eb,0xdbbdf7b1,
	0x997d1a7b,0x0e3d5121,0x26d95fe1,0x461b1fd3,0xac63fce9,0xde9b1e19,0x16c358b5,0x9aeb9885,
	0x3de132b1,0xe76fca13,0x706d1ff3,0x018184cf,0x19dfb927,0x0dc10efd,0xcb0da0f5,0xa4d79cc3,
	0x6d270ae7,0xdebf4e4d,0xe745ead7,0x648d1a79,0xfe6d74d3,0x90bd8dff,0xb81b1585,0x25f1c715,
	0x074d8b19,0xa43d9599,0x0c0346a9,0xc4f127bf,0xad4dbe29,0x24e32b29,0xd5d1d6bf,0xa52bcaa7,
	0x1ad70fbf,0x8a7b7045,0x15c99603,0xe2dfb407,0x3841e7df,0x3a015f07,0x6291317f,0x23f7eb21,
	0x04c709d3,0xa68f6717,0x1239b7ff,0x0907273d,0x8f8ba931,0x126b2aa1,0x033b3f1d,0x3e499cad,
	0x909d9ed3,0xf0055b59,0x0575a835,0x2c9de9cb,0xa1efbddb,0xe2f3b781,0xe3318573,0x4a9123f7,
	0x185f48b3,0x60f326d9,0x0a211ec1,0x0d53049b,0x7caf8613,0xf2ebf7b1,0xd45996db,0x79c13629,
	0xa48b75f3,0x15e93bdd,0x715b303d,0x555bc117,0x6b89a695,0xbc2545bb,0x6f11b231,0xf74b98e9,
	0x0c252989,0x6dfb452f,0xe2c7edc3,0xb9654929,0x18c3a89d,0x0af304a9,0x323b62cd,0x0921c265,
	0x14af9aef,0x2abbc61b,0x7c8904eb,0x18a54739,0xad1f99e1,0x1e274005,0xa33b2089,0x2fb77947,
	0x922bd621,0x9039ba6b,0xf3415fd3,0x9ccb8635,0xefdbac9f,0xc7134bdb,0x6df3efbf,0x45fd74b7,
	0x871b5b97,0x85073669,0xb211c511,0xda0b9183,0x66bdd78d,0x898964b3,0x84c3014b,0xa165fc5f,
	0x447fc04d,0xb23706dd,0xfa9977bf,0xef175511,0x760575e9,0xbbdb4f95,0x408d5285,0x31e1886b,
	0x89db4dbb,0xa35f5113,0x04ffd77b,0xa521bd45,0x8077e769,0xa6d9fa0f,0x80b74d47,0xa1e36183,
	0xa533a1dd,0xe68b32d3,0x1fe3005b,0x8fd9570b,0x0753304b,0xa5d91a2b,0xcb1f67ed,0x765f40d1,
	0x93054f2b,0x2c516269,0xd0676afb,0x2d75efcd,0xca5b9945,0x46abce6f,0x6c27c54f,0x2ec5f001,
	0x1e537ca1,0x67c3ce9f,0xf22d8c75,0x06a13575,0xe7d34f95,0x699f3de7,0x96b3d4c7,0x6507e93b,
	0x00a385b9,0xee713ebd,0xd7597663,0xce95566d,0xfc7b04f1,0x618b381f,0x8425f22f,0xed97f72b,
	0x01f39a6b,0x986df28f,0x688976dd,0x82ffa19d,0x43958f97,0x13bfd51d,0x945d05e3,0xf767d4f9,
	0x18c95f31,0xe04b425f,0x44e1b87f,0x8c132673,0xb6e38a3d,0x180b156f,0x6dbf24bb,0x2bebce4f,
	0x8a238d07,0x031b3ef5,0xe205e263,0xdc8154d5,0x2ea9f421,0xd8c3821d,0x1d2b3011,0xcf135f59,
	0x09859167,0x2071519d,0xac13b823,0x117f9d31,0x81a7d0fb,0xb2bbccb1,0x360575bf,0xdf51d4bf,
	0xd8ef2e49,0x5a5ddc21,0x25b1b9d7,0x92bb106d,0xa521c903,0x15416f37,0xf22f5021,0x3597ebad,
	0xe8e71a27,0xf573d8c9,0x07ffc41b,0xb267fff5,0xccd7c8f7,0xa2294c35,0x5209c60f,0xa55771cb,
	0xf86b9ffd,0x78c37a61,0x629db009,0xcd399db3,0x8b0ba20f,0x4dc74eb7,0x3c772ae3,0x1c85e543,
	0xb5013f45,0xcde1cc31,0xbbb1f33b,0x6a5f9c11,0xf07faa03,0x7ee90a49,0x9ed9be79,0xc39114c1,
	0xdaa74bf7,0x60dd5205,0x2fdb3fc9,0x5b8dcdf9,0xac775b11,0x2ee35af3,0x8d134d27,0x1d6dbf6d,
	0x53e18e8d,0x4049a827,0x923d2451,0xdcf3c6d5,0x2cb5f3f1,0x0987053f,0x6185cfcb,0x278b34f1,
	0x59afe405,0x3d39235f,0x8c79abe9,0xb5477a8d,0xbd7717db,0x8d275637,0xdd130bbf,0x79dff579,
	0x9397ddd3,0x0b3f70f9,0xbeb1fe2d,0x55b5dd8f,0xa9836e8d,0x2a95c365,0x471f32d9,0x66d751ad,
	0x379761f5,0x606b36bf,0xdf89ff35,0xf9f584c1,0x5a19443f,0x65238ad5,0x8d898377,0x1b690ab9,
	0x2a334ae5,0x154fb2f9,0xdc1fef9d,0xc835458f,0x76fd29ab,0xf2a3530d,0x64b3e871,0xbf05f245,
	0x1e6d079b,0x44ff5c73,0xf8170c7f,0xf129d5e3,0x066d940b,0xdb67cb1b,0x67839921,0x939d8a7d,
	0xb5c73b93,0x6d0b8277,0xed952f75,0xd0036c27,0x8d2f7d17,0x9a414a85,0x3757b963,0x15a5a607,
	0xa0435ec5,0x8d87eccd,0x0d376e99,0x0a755f45,0x2e85030d,0x3c837159,0x9c11f98f,0x1c0d0813,
	0xbc635dad,0x49037bc1,0x5e23bc83,0xb0afc6a7,0xcc2f08a5,0x81fdc81f,0xa415367f,0xf8450445,
	0x37273943,0x0491c81d,0xbdf9884f,0x5d651a37,0x266fd519,0xfd055fe3,0xc445198d,0x96451ecb,
	0xac13a703,0x07c5c329,0x00d95d97,0x55c7d25d,0xfc07b423,0x326b722b,0xf801b895,0x9c79ac4f,
	0x4529b0e5,0x9cb156af,0x11698475,0xa9890807,0x2a3b95fd,0xb97f0105,0xe12d35ef,0x8bd571f9,
	0xdaeb5565,0x2fe504fd,0x10c9a181,0x52dd149b,0xcccbaf61,0x5c1776f7,0xe8296075,0xdfcd4573,
	0x1459277b,0x707388d9,0x769b55d9,0x56753207,0x5dfb1987,0x3681470f,0x5bd95383,0x2e51ace7,
	0x86f9eea3,0x6fef758f,0x3101df13,0xe3811ab1,0xd689722d,0xd7938cd5,0x919f16ef,0x47d37f01,
	0xd6c946d5,0xc269d6e7,0xc49fb749,0x73b7a985,0xcdbd7b8b,0x609bac53,0x055b3f17,0x574582eb,
	0xd64d408d,0x9e75d12d,0x6c933519,0xeb4379ed,0x9953bc5b,0xa56df213,0x796f8cd3,0x021b104d,
	0xa68700c3,0xfd23412b,0x3a812b99,0xb8dd87d3,0x6d911fd7,0x4c5d331f,0x16c18d7f,0x8843af51,
	0xd6f960f3,0xba075c29,0x368d8a65,0xf5b3cf9f,0x7d3795b9,0xee396d03,0x8cad3af3,0xe433b8a1,
	0x85a58f17,0xb3314ff3,0x7f55fd97,0x8579ee3f,0x1987b23b,0x365565c7,0x311b9b89,0xeadbf569,
	0x7f0bada5,0xe935e2d1,0x69ff8dc7,0x365fc119,0xd2454e17,0x02834bf3,0x2069621b,0x6baf3f51,
	0x5e31739d,0x9f231391,0xa2294013,0xe11b061b,0x95b12687,0x83155695,0x5d798e05,0x509d2085,
	0xac95cc75,0x7a8db979,0x49f9b611,0x88dbfbab,0xd08d7d45,0x5add6535,0xf1af0b1f,0xbe1b73ad,
	0x023b7827,0xa3872453,0x1a0fcddd,0x7b5100b5,0x8e1db88d,0xbf2f9fdd,0x0ced51c3,0x331903f5,
	0x25a3ab2f,0xe4a1bc6b,0x818d420f,0x70b334a3,0x98210315,0x97d71719,0x259306cb,0xa9092d05,
	0x2bd3ae87,0xcaefa28b,0xc61549c5,0xabaf175f,0x96ddec19,0x9f2d63ef,0x18859b93,0xb3dd7b07,
	0x98497fa7,0xc6014ffb,0x23c93895,0x19792953,0x310f0753,0x820147ed,0x4925edf3,0xa2094aa7,
	0x7d0b7089,0x47eb3687,0xed4b1e9b,0x71c18b69,0x2bfd8cfd,0xffa54d1b,0xc153e845,0x9c7d690d,
	0x9a97c7a9,0xe53d6079,0xabbd686f,0x56bb9f0b,0x8b69f9d1,0x09eb6601,0x51712163,0xc6abb3e3,
	0x7ff16001,0x750b1099,0x3ec17f2f,0x7519a621,0xb191af09,0xe5258dad,0xb0657ca9,0x5e85b955,
	0xaa994909,0x30e56233,0xfc7b6871,0xa40d6317,0x7f3b925f,0x482367a9,0x9b8bc9ef,0xdc7d580b,
	0xa69566bb,0xd4dfe911,0xd1896651,0x0547b8d9,0x73a9ae0f,0x7c3bdffb,0xf6cb658f,0x13875f31,
	0x2e631193,0xbf89517b,0x610f9769,0x24fb4acd,0xcc99d0cf,0x7d3dcb2f,0xec83d865,0x51112e6f,
	0x4b07b68b,0x11f5003d,0x24b196d1,0x19db1cdf,0xa6512ddb,0x19798651,0x0d9577c7,0x7d1155ef,
	0x7405771b,0xcfb7b2a1,0x8c8f1c27,0xa5173379,0x1b93fced,0x11c596e9,0x71650593,0x39f7365d,
	0xaf59c93f,0xfedf1e6f,0x1f499b81,0x52653385,0x659d1a41,0x396f4b01,0xd5d55023,0x04b7a0e1,
	0xb18b176f,0xc80191f3,0x9a05e579,0x97f1026d,0xfc35a68d,0x964d5923,0xbf45d24d,0x54bf7727,
	0xfd9b60a7,0x962d93f5,0x1063c72d,0xf6736619,0xb59da70d,0x80ad8059,0x9899536f,0xbc054b57,
	0x0509d85f,0x36f783c1,0x0c85aa33,0x1919a4f7,0xe693a57d,0xc363282d,0xd3318761,0x06f9001b,
	0x47d98691,0xfa6f3921,0xaf0d34a7,0xf59725ed,0x825d5013,0xbbc300a9,0x06f1ae7f,0x5c8d689f,
	0x748de7bb,0xd329a45d,0xcf1de923,0xec1f1069,0x3abd198b,0x799ba259,0x123b359f,0x5e35e88b,
	0x88278cd1,0x76356e41,0x1a59c6c1,0xe761ec51,0x9ff1d921,0xdf3f2e45,0x39ef561f,0x47df1409,
	0xee29bb53,0x7b279817,0x34dfe919,0x7c914211,0x40bf6a8b,0xc181edf7,0x4971b5d7,0x10014fc5,
	0xa0930d35,0x7c0f1ba7,0xd9532847,0x0b613a93,0xca694e05,0x07b3f379,0xb2a10723,0x878b70e9,
	0x47eb10f7,0x357f8b3d,0xf8d9b8e5,0xde013f41,0x28ad484b,0xcba7b955,0xade3a8d9,0x79ef5d1b,
	0x5b2fe98d,0xa68bb1a3,0xdb0fcc0d,0x49259a03,0xa5d10293,0x79afc295,0x5a174657,0xcd21aa8b,
	0x3fe3ee77,0x30c33221,0x3e1b2f59,0xcbff1547,0x0a95aa9b,0xf09d3ac3,0xdca17777,0xa18f3fdd,
	0x6a074ba9,0xb83b2883,0x769bece1,0x30419bf5,0xbe3d9299,0xa1c395eb,0x8163608f,0x722ff43f,
	0x7c21a1a3,0xc383c911,0x8fb5eb41,0xaa1bd975,0xe689d149,0xb0f33095,0xdabd527d,0x34712f59,
	0x6731a55b,0x9baf0097,0x6b098d93,0xf841d9b3,0x87bbe1e7,0x147fefc9,0xe1936a99,0x78478957,
	0x8ab7c04b,0x6c4f145f,0xe0b9536f,0x83e5a91b,0xa4974429,0xb537e115,0x154532bd,0x88236ae1,
	0xd4b7b06f,0x63774233,0xdf6778f1,0x80b7f493,0x5e5d1c4d,0x8e71da83,0x9bb74145,0x88f9ad21,
	0xe1b3283f,0xd1b7605b,0x8c3596b3,0x0ceba987,0x14cfd30b,0xcdfd1a99,0x6149d907,0x9a3939c3,
	0x1cad6eb7,0x4a217da1,0x62c541cf,0x513395e1,0x862fb59b,0xf42be863,0x38df8963,0xf5d5aaef,
	0xdf25ff51,0xc2498153,0x5539abdf,0xa0c10809,0xef4195bb,0xf3d1336d,0xfbdbce2d,0x103feb51,
	0x91212a05,0xb241cb37,0xec3542fb,0x99456eed,0x2b4769a1,0x523f33bd,0xaa1dafc1,0xb86bd611,
	0xc91fb34d,0x3499d397,0x66d751bf,0x42f3f9f5,0xd3ffec0b,0x474509e1,0x8a0962fb,0x37c7d6d9,
	0x6c237425,0x2663cb41,0xdac39f45,0x307b3909,0x61af3c2f,0xdd375ee1,0x487fe933,0x724989d5,
	0xcdaffa07,0x47333b7b,0x541d0f27,0x9f13bc97,0x4b177dcb,0x10e90447,0x18e3b045,0x06615bad,
	0xcfc526eb,0x5919a60f,0xf585417d,0x9669b585,0x257b7917,0xf1a9941f,0xd5173289,0x6d01298d,
	0x02e5d14b,0x40a92549,0x181b32e3,0x08af953f,0xc49b3acb,0xc14b10ef,0x1d7b96d7,0x199de11d,
	0xc6156423,0x24f30bf3,0x6b85dc73,0xf29badaf,0x5ab9b425,0x142385c3,0x78f3508f,0x9a232087,
	0x66d37eed,0x8f898557,0x15e3d3c7,0x7b5bd13f,0x98975add,0xf0ffa627,0x74dfbf85,0xb709d677,
	0x412395a1,0x8c7f353d,0xd3d7eaf9,0x14a3f2d9,0xcd79c92b,0xf1336e23,0xc523d017,0x933fe215,
	0xdf8790b9,0xca67d7ef,0x1883d0a1,0x9aa3c5e5,0x071f5dcd,0x6091c241,0x641f9b1d,0xcc37b30b,
	0x1b016d31,0xba51e23b,0x2d89afdb,0x740f5e51,0x31cddbfb,0x5d6b0f8b,0xb2b705f1,0x99e5e985,
	0x3b11dc83,0xafcf2167,0x530bd041,0xb219d083,0x38430b6f,0xf893eb8b,0x984d626f,0xeeb9f62d,
	0x15bde4a7,0x00f55b3d,0xdfab35eb,0x3073d169,0x23c35861,0x555bb44d,0xa2c10eef,0x97a3ba29,
	0x2f838019,0x2653ee0b,0x608d4175,0xb54d5669,0x3c0f738f,0xc9953057,0x2677164b,0x5c192727,
	0xdb673dd1,0xdafd7097,0xb94f4ffb,0x115b356f,0x276bf231,0xfd932eb7,0x5e4fcfdd,0x1e0ddf51,
	0x5aebe14b,0x3c83522b,0x44155b11,0x3fcfc4e5,0x0a97ee01,0x0c2726f3,0x8bad7f7f,0xf9edd54f,
	0xfe0f027f,0xeaf97a95,0xf18398d7,0x86597bb5,0xa8d7a539,0xa2a3d919,0x1671f58d,0x66afec4b,
	0x4359ade9,0x28efea19,0x68b91be3,0x952f9149,0x83eb1a91,0x20d7edb1,0xacff2edf,0x55c397f1,
	0xf7c70481,0xfb795987,0x27577351,0xa6fd9d8b,0xfc15b547,0xb91995c7,0x6439f4d1,0x531b7c69,
	0x56dddbc1,0x4a27da25,0xa1834abb,0xa0fb38e3,0x7017e113,0x90392ae1,0xd77f7d3b,0xa5290e5d,
	0x2a9d5da7,0xff0b75bf,0x61dd0a3b,0x32d79c3f,0x5d35ae2f,0xdd87cf0b,0x48b50a75,0x6ce132f9,
	0xeb89a8a7,0x26b9ce9d,0x29877669,0xf6c54105,0x7f2f7155,0x0ad90cd1,0xc03b8b5f,0xc5b1dfe5,
	0xe0a36fc1,0x1043bf8b,0x10235063,0x91778121,0xf04963bf,0xd47d773b,0x2cf53b4d,0xe58fbb4d,
	0x3f6b9a6b,0x6d37fbd3,0xa3d3f5bf,0xd21d36fd,0x49414327,0x694949d3,0x8445421d,0x3cebbbd9,
	0x4be7e49f,0x71adaf3f,0x09390097,0xd26b5d85,0xc15df1c7,0x8a8b08a3,0xe20b5427,0x96b9c8b3,
	0x78957ed9,0xf4331e17,0x1b77e789,0x1693b01d,0x4e5f1659,0xac172035,0xa8a95245,0x38675987,
	0x8679ae11,0x8ddb4525,0x8c319dab,0xad474ab5,0xc487bc17,0x14418593,0xa105e9d3,0x01eb167d,
	0xa5156bc3,0xba3779b5,0x03853299,0x4fb749b5,0xf697f2bb,0xfbd75649,0x1a7d34a7,0x8db5783f,
	0x926905e7,0xf75b0991,0x4019726d,0x81976a07,0xd5d16e7f,0xae2d785d,0x0af3591f,0x50b767f9,
	0xbafbbef9,0xe5d9db03,0x370b85bf,0xb117a913,0x91f9281d,0xa9153a5d,0x2ecb2a15,0xba63df55,
	0x59c96df3,0x68c10cd3,0x340191ad,0x56ebe4c7,0xb94ffccf,0xbce1f351,0x28e5c6df,0x54ad8879,
	0x98571e4d,0xc5a7964d,0xf91b57cd,0x16457b89,0x58954e4f,0x2c65a2c3,0xa2a73b5b,0xe4035e13,
	0xaea7b001,0xc499e739,0xdef9d63b,0xdcd7ec45,0x1b0fa2d7,0xccef90bd,0x6bed1fe1,0x875b4b4d,
	0x033b778b,0xd02f87e5,0xf4c1e78f,0x02d37665,0x6a7d4521,0x2653edcb,0x9b1f394d,0xd825cbcf,
	0x4b13dde3,0x1577b915,0x2013e2e7,0x6ae9b9d3,0x8f23e467,0x92e172f3,0xad1918f5,0x0a558bc3,
	0xa9b50085,0xa4031419,0x3d113bd9,0xa24b56f9,0xcfbf3463,0x5f6f01c3,0xa543bcb7,0x0c5907d5,
	0xd11f516b,0x8de72ab7,0x3e5d2281,0x00af8ec1,0x91978d4f,0xeb4d4441,0x2d7b2eeb,0xa7272d2d,
	0x21d5370d,0x07b32739,0x4d1b2377,0xc843e293,0x786d8be5,0xc84d4cfb,0xb625266d,0x9e2ff975,
	0xcad9ac65,0x887b6c6d,0xe8e9c7d9,0x45bbb45d,0x867fb161,0xdac136f9,0x9621a693,0xcf631ad9,
	0xe9ade0f1,0xe9cf3599,0x07eb353d,0xf049e685,0x3c930379,0x7979c5c7,0x2ad19f3b,0x53359001,
	0xaa51d8a5,0x87c13687,0x36c5cdbf,0x899d7bf7,0xb9ebac69,0x8dcb056b,0xf81b8cbf,0x9c994819,
	0x674b0bff,0x60e53b85,0xb895cff9,0x3deb381f,0xdc459aeb,0xb387ea71,0xc85d17f5,0x98ffc2c9,
	0xc99907f9,0x364dc959,0xa701f703,0xc3e53ee3,0x5fe72239,0x58fdf1e5,0xcc79b63b,0xd059b03b,
	0xe8bf0e0b,0xab89bd4d,0x12271a7b,0x7cbbb4af,0xff939a0f,0xdf03c14f,0xbbd34969,0x8519911b,
	0x6abfb431,0x66abed2d,0x20adce77,0x94215e6d,0x9487fea3,0xb8e7c6b7,0xf44dbfd9,0xd4315691,
	0xa41b84e3,0x3047c743,0x2fb30391,0x20494185,0x368990b1,0x8c7fd8ab,0x9a47b467,0xd5150249,
	0xb7d39f1b,0x136df257,0xf2dba6e7,0x41e543e5,0x5bdb7575,0x5219d635,0xb8a50e6b,0xb9b3466b,
	0xb76b5657,0x7db1edb7,0x9447420f,0x4425cbf5,0xf93b56a5,0x748946db,0x60c7a1bf,0xee8125a1,
	0xc2e7d28b,0x5f23b127,0xd4999b25,0xbcbd609d,0xa1ef027d,0xf123faa9,0xca91cebd,0x3a6f9317,
	0x28c5b035,0x4a554cf7,0x2af354c3,0xabdd4949,0xa7b90bb9,0x77b5aa2b,0x74652241,0xdef11275,
	0x8607a04f,0x945d89ed,0xe4f78e03,0x9c3b2de3,0x3ad7698f,0x8a939669,0x4323f5a3,0xb7f557e7,
	0xe6330851,0x74c78953,0x46c7827d,0xc305b6d7,0x8a0f17bb,0x9e8f28eb,0xa22f0ebd,0x5bf1e815,
	0xe349a237,0x25a964f7,0xab072a4f,0x1fef2d0b,0xe2a1b679,0x3afb93bf,0xa3693fe9,0x3bd5b829,
	0xc5c91c79,0x0395cf1f,0xa2d5da0d,0x9d2919e9,0xd0512a7f,0x19a9716f,0x1f350803,0xc313cdcf,
	0xa4b7ba13,0xad99b295,0x15d7e2d7,0x2f67e75f,0x3d5f3d09,0x46eb6501,0xd4733263,0x779fdf2f,
	0x8595f27d,0x254dd2a5,0x622b3245,0xf5db7fd5,0x928d3bd3,0x4193ba01,0x888776e3,0x19e7f2f3,
	0x7c6511b3,0xeebf6b19,0x7c77f26f,0x5a37ee33,0xd71f9913,0x1af3047b,0x275319df,0xc4e10047,
	0xcba9d82f,0x3081d03b,0x0fdb29f1,0x30abfde7,0xd0d58b87,0x96ddc0f7,0xe3378c2d,0x0dfd8ed3,
	0x04611ae7,0xd3a50ed3,0x9df95be5,0xd7ebdad7,0x23f1ae65,0x4ba3f47d,0x55170b2b,0x252d56c3,
	0x2611635b,0xa3c18c2d,0x9ef327e3,0x5929b16f,0x7337a16b,0xc215cc9b,0x9c5340b3,0xf4e5e0bf,
	0xbebb8f81,0x6ee1a611,0xa16bea07,0x88154e99,0x7fe7a8cf,0x95893f59,0x7ecfe31b,0x421325f1,
	0x0ae171d3,0x259b52cb,0x6a835aeb,0x22e3bfc1,0x49c34d4f,0x93cfab43,0x88eb5541,0xcc2d3005,
	0x1585714d,0xfb01c125,0x15dd2fa9,0xf245f2cb,0x2f0dfc21,0xdd37775f,0x2d8d467d,0x6d23b923,
	0xd8292967,0x84a3f867,0x359bb9db,0xe96b5627,0x0c89a703,0x0497b33b,0xe61152a9,0x3967cbf7,
	0x5acd0a1d,0xda93785d,0xf25f8799,0x460b78bd,0x5d79642d,0x2f3fb6dd,0x525da221,0x9fed63a9,
	0xd3f5f7e9,0xb765d951,0x2b4d037f,0xb051a9f5,0x5b9b0e57,0x34ffc2d3,0x58d389bd,0x8a230be3,
	0xc8a5ebc3,0x98296c0b,0x960314a7,0x5af599bd,0x1f35e4bf,0xc02ba025,0x46552ad7,0x7bff80d1,
	0x2c599325,0xdc73d9d7,0xdea7beab,0x2325f87b,0xbf072b1b,0x6d97405d,0xee411349,0xb3f14f1b,
	0x8119f00b,0xe653c47f,0xc7d7c1a3,0xb095171b,0x7055c9a9,0xec915d85,0xca7fdd6f,0x4aed73ed,
	0xf765f8ef,0x3a5d664b,0x4ab93a2d,0x95778709,0xa6dfed21,0x1eed1a29,0x1b6dd021,0x5461fcef,
	0x8e3d38c9,0x9fa13207,0xb6ed415d,0x6e7bba2b,0x34e7a6bb,0x38ffa14f,0x07ef7eb9,0xfe43a84b,
	0x33256f13,0x3fb372fb,0xd2958cd3,0x02d7a2ed,0x6b2f8c35,0xe195c685,0xbd656913,0xb10184ad,
	0xe21f2fcb,0xc6a3ecf3,0xfa510ea7,0x64375437,0x38fb57c7,0x5203a5d3,0x8fb39b85,0x2f91913d,
	0xc5ad8365,0x83037c39,0x41479571,0x0ed3a177,0x4c0b8829,0x761b43c3,0x19394eed,0xb7655da7,
	0x56d186df,0x85e7b595,0x91196c4d,0x0959be95,0x30a30099,0x0c2f2d5f,0x5adb88a5,0x206baa13,
	0x7d0d0bb3,0xc2e18653,0xc9e5fad5,0x04fddff9,0x7183a8cf,0xc5111831,0xdbfbba83,0xfd19072b,
	0xae6137d9,0x3001d43d,0xe24f6521,0x7d71da8f,0xb7ed0d05,0x64138243,0xca7962e5,0xba5f761b,
	0x0f5125cd,0xe5d91d9b,0x07792bcf,0xd8e5c3c3,0xeba3fdf3,0xdf075221,0x1ab9aca3,0xbfaf088b,
	0x92df8487,0x3f7d1939,0xbd07cbf5,0x880d917b,0x52e930d7,0x7e3f76d3,0xa79b0f17,0x8efb80a5,
	0x1a8d3781,0xfa7d5661,0xfd175f2d,0x261bba23,0xb27fdf69,0xfc8d87e1,0x5283ee1d,0xe4b5f115,
	0x965df6b9,0x56eddcdb,0x584f3b95,0x98bfd4a5,0x6da967e3,0xa7436559,0x23513a0d,0xd7d15d03,
	0x24cfeea3,0x375dccf3,0x15cd93c3,0x302d386b,0xa627ecff,0x7e31d7c3,0x68690fc1,0xf9bf581b,
	0x32e9603f,0x40dfff71,0x533716d5,0xc7179d5d,0x5c3bf5f7,0x53ad302b,0xd6ad5893,0x7671a685,
	0x9c294101,0xfb07a5a3,0x24ad905f,0xe2afbbe9,0x8ea70e83,0xec87e817,0xa97d6a5f,0x3459dceb,
	0xca93dae9,0xefe7e94d,0xb4d18881,0xd2a5ecf5,0x5aaf66e1,0x200f4193,0xc2bda77d,0xf46b0079,
	0xd6a96c6b,0xcc0f8cbf,0x64c5e3d3,0xd12dc9ef,0x1c1373c9,0xf81be72b,0xcacd1ec7,0x721726d7,
	0xa76bc887,0x7e918abf,0xec2b836d,0x22f9ccbd,0x8d158e75,0xd0f98be7,0x50912b99,0x834d1631,
	0x125ff6b1,0x5901b699,0x7925e4eb,0x3739efcb,0xe679949f,0x797f8b51,0xe96b15c9,0x3883e52f,
	0xfb83d2e9,0x2f6f5c15,0xd055c265,0xc7a14e03,0xff7f8881,0x52fb8973,0x513bb1b5,0xfcab9afb,
	0x755bada5,0x786fdf7f,0x6cddb279,0xf863c2cf,0x6deb30d5,0x714112d7,0x8a650037,0xb533cf41,
	0xe0e9ebdf,0x6d115da1,0xa05fc83d,0x782f8a19,0xa5fdb8d5,0xbaa53c87,0xfdc9cea5,0xe2114a29,
	0x0dafa713,0x28e94bc3,0xb2ff334d,0xa039e04b,0x1a77503b,0x07f5440f,0x9acb56dd,0xbdb5a45f,
	0x59af4d39,0xca0717b1,0x035bdfc3,0x9433a24d,0x5c9bcb41,0x44852f75,0xf74bdf37,0x5d11e70b,
	0xd16940cd,0x90ffc7b3,0x26991639,0x624fed8d,0x3c2d42a1,0x8e276d47,0x6fad5a8d,0xcf972bd7,
	0x4fe178c7,0x00e19a97,0x08591bc7,0x233dbff1,0xe76db395,0x552d748d,0x46d3083b,0x3f3b3cef,
	0x9e9920a3,0xff3fa7a1,0x0abbd209,0x1a3197e7,0x0b1d9fd7,0x7c6b64d1,0xc61d1419,0x106d34fb,
	0x9593385b,0xf42d7ea1,0x26655719,0xd4dd1455,0xf281ada1,0x792fa61d,0x5d6d3681,0x021d1f25,
	0x3b513467,0xea3bc7dd,0x0a77a58f,0x4b7194a7,0xa75947ad,0x734d88fd,0xc329544d,0x4dc39719,
	0xe4d59dc1,0xae7de421,0x3c933489,0x00a1d8c7,0x11e73d35,0x6515e677,0x142f1ed9,0xc74b68ff,
	0x559fb1e5,0xf0838cb5,0x38db979d,0x219fa11f,0x18ef61f5,0x3b5dc019,0xf3e1b3fd,0xfd293183,
	0xdfb302cd,0x62617365,0x91f11ee7,0xa61d4e97,0xc1b12e23,0xf575dfe9,0xac233e13,0x5851fdcd,
	0x839316f1,0xd8a7e27b,0x10f77701,0x704b829d,0x4ff15e7b,0xc52f7875,0x4d5793f5,0x3c33eb89,
	0x1041094b,0x6a695cbf,0xd5914903,0x6cddbf17,0x65ed9437,0x2eddc4c5,0xce5dd8ff,0x26c1c8dd,
	0x433f2957,0x91373d7d,0x75ddda89,0xb3030673,0x246bf511,0x294fa865,0x2c991d09,0xd06fb479,
	0xe88f9b0f,0x4925587f,0x1e7fadad,0xa4737b97,0x4aadcb43,0x3ddb4f5b,0x8bebfc6d,0x4c2bbd81,
	0xfab1f6eb,0x30c39a0d,0xb29b2109,0x0d5b01ef,0x56712589,0xa851ce33,0x56b74007,0x276b83a3,
	0xc2a9e9e7,0xa923a6f3,0xebcf0fb5,0x446ddd65,0xa3fd7719,0x7701c1f9,0x5ddd7d2f,0x8a1fd709,
	0xf7f9d57b,0xf5d97c79,0x7a41714f,0x4adf5263,0x8e1337af,0xaac1f035,0xf8c1b5bf,0x56b95859,
	0xe0a36fa1,0x5cf5106d,0x2491f9ed,0xec5f45d3,0x8df18385,0x56dfe6ef,0x2545f811,0x4a2b18c3,
	0x712962d7,0x470bf113,0xe7e1ba2b,0xdf21dd1f,0x5b5dbb57,0xc1319cb5,0xa7c9feff,0x1be939eb,
	0x6c8bee11,0x5f2be53b,0x17d1bf21,0xe3d51e31,0x0c99245b,0x82051091,0x2b31d1e5,0x9de38dff,
	0x844f84cd,0xb2e98c2b,0x7e87b26b,0xe5b18f71,0x3663884d,0xa42fea09,0x60df649b,0xdc8b37a7,
	0x78736f05,0xd255fdaf,0x7ca37a25,0x1a63d7cd,0x0c01d569,0xc5031929,0x20b1377d,0x3ed34a0f,
	0x377b6931,0xf0036a0f,0x2949d8e3,0x221d5eab,0x7f33be65,0x344f767d,0x890ff761,0xa62d68df,
	0xfe69444d,0x0103ba17,0x72170dc5,0x2795ebf7,0x603d5a7d,0x1467630d,0x1ed71da5,0x8e8d6843,
	0x78bd85d1,0xdce92f11,0x3b317461,0xfff9481b,0x7ddfc56d,0x7a1d6861,0xed6d9021,0x2e61ece3,
	0xe07d07b9,0x5dc502c5,0x7f3924d5,0x4afbdc01,0xc55bbf6b,0x8cc3d887,0xa6b14131,0x969f0be9,
	0x1e27987d,0x8029077f,0x6f5393b7,0x92d15113,0x62754d33,0xa62b6e09,0xc307cfad,0xd2b9eb01,
	0xe8bf9b19,0x83294809,0x931d3221,0x6c29313b,0xdf6d5801,0x72a7ebed,0xa14f26ed,0x089d6053,
	0xe5c7a705,0x0855a7ab,0xe8bd0db1,0x963786e3,0x45054d8b,0x1109bdbf,0xa6ed1ed1,0x98c19289,
	0xc941283d,0x33c18231,0x04d3707d,0x1aab7cf3,0x3a81c00f,0x32a3978b,0x5fc31bad,0x3e1398cf,
	0x75afff39,0xcbfd4be3,0x327f8121,0x6dbbfed9,0x25a10643,0x3b4715d7,0x9e31ae5f,0x2e091acf,
	0x1c1120f5,0x5a1d318d,0x9367e2b7,0x8e15587b,0x4aa7db65,0x61475db1,0x9b1b343f,0x3895f0af,
	0x5bed36eb,0x49b1b879,0x3fab54d7,0x24ebd645,0xec57ff2b,0xcd73bca1,0x15e17727,0xe825c31d,
	0x63413f13,0x08cd5e71,0x65ed539f,0xa5f36521,0x6befd5d3,0xbb2148b1,0x74674d73,0xa1afab43,
	0x0e912be7,0x280139bd,0x6b4fb7a5,0x6f5b3279,0x69370813,0x9821806d,0xe30f39fb,0xc4a1d2c7,
	0x08df8463,0x7a5f9927,0x0b735603,0xe9d74c37,0xe26b2329,0x24c3eadb,0x74b90c19,0xcaf113d9,
	0xebab03ff,0x357ba3fd,0x787da057,0xa89740c5,0x545138cb,0x93ddb789,0x42c77fa7,0x6911991d,
	0x5efb3ab7,0x1167fa05,0x7b0b44b7,0x894fbf0d,0xda297f37,0xaabf5e7d,0x8d1fdd01,0xadef7dc1,
	0x394d2d05,0x68b35389,0x9241cdbf,0xd4313677,0x4db7f123,0xe1394045,0xda1d98fd,0x23016d6f,
	0x9fa5f3e1,0x58712157,0x13c34289,0x5bef76f1,0x673bedcd,0x819f45e9,0x16a9f4fb,0xec37444d,
	0x25855cc5,0xe0352cb3,0x4bafc6af,0x9db950e1,0xdd77d8ed,0xc8c580f3,0xb6219ecf,0xe803af0b,
	0xecef89ad,0x020f376d,0x9cab3a49,0xe1433533,0x85afbabb,0x05f9cb6d,0xd26750d7,0xcf57cacd,
	0xc6639113,0xe2939bcb,0x9fd7d9f5,0x58bfd551,0x73a1dff5,0xbb0f67e3,0x4bdf71eb,0x55a5c541,
	0x50e71def,0xe8d1ec99,0x44d3dec9,0x40ddc325,0x199579d3,0xbc5ba15b,0xe96bb565,0x48e17c8f,
	0x19f90fbb,0xde5b951f,0xf1c51e5f,0x00d11119,0x68473e0d,0x50ab6b63,0x786bbb1f,0xb17b1f63,
	0xbd9d1a73,0x0f45792b,0xa34daad5,0x4a4df217,0xeefd06e1,0x51530203,0xecc3af75,0xf265cce5,
	0x06556691,0x6a219501,0x0c8d72c1,0x39835989,0xfb777307,0x4a2589c5,0x80d3eb3f,0xe91134c1,
	0x0d21310d,0x9fff9d71,0xb727e13f,0x75239b57,0xb9f985b7,0x9973afb3,0xd57f93d7,0x0d71371f,
	0x59876b63,0x44719fc1,0x233d7de9,0x4e610bef,0x554346af,0x900f4957,0x12293b19,0x91f984a9,
	0x01855b8b,0xed8ba1bb,0xe7738cd7,0xe0eda037,0x16976227,0x914bf4bb,0x04b17f5d,0x83993e8b,
	0xc9a13bff,0x53dd41ad,0xd0e7aea7,0x32fd8d9b,0x85b7c8d9,0x32f9b86b,0x417bab7d,0xe9c3966d,
	0x44d9dbbd,0x727b565d,0x033d806f,0x553fea07,0x88e74fff,0x5d6ba36f,0x436756d3,0xe6696e79,
	0xf4af3e39,0xa6f58f15,0x18993bcb,0x82e74be1,0x84e75151,0x6b736d4f,0x8bd9053b,0xd5fff95b,
	0x69293b71,0xd15f13a1,0x419956d3,0x41a56a13,0x7cfb4b0d,0x4a631619,0xc2b3c70d,0x6f735a3b,
	0x60c71fdf,0x7449244b,0x65632423,0x81adbc0b,0x32e17feb,0x9a0b8655,0xd655d923,0xe43b44c5,
	0xe8894c7b,0xd4c7b9dd,0x419772d7,0xbdb119b1,0x46e19725,0xccc12f0f,0x1ba144d7,0x00479d21,
	0x7bf3d6c1,0x1a69259f,0x8a552e85,0x1ae35b6f,0x57b73c75,0x4755a9cd,0x6dfb8005,0x4a0b17f9,
	0x250728a9,0x6f41b15d,0x0a43ff47,0x88f3fa2d,0x22a9c015,0x8117589b,0x4f450d05,0x2275da79,
	0x9c47a0af,0x1fe33f5f,0xc281e9bb,0xe215af57,0xa377b6bf,0x23dd0605,0x07e11ab1,0xe4fb1a49,
	0x68b531cb,0xbb61ea71,0x0ab1eef7,0x0af914d9,0x346399ab,0x2bf58513,0xc6ad2463,0x078dbd95,
	0xffd10379,0x334ba5dd,0xb0f5ac97,0x12d54519,0xae316697,0x0835514f,0xc11191f7,0x3a9dfb05,
	0xe59f11b3,0xfbb3dd6b,0x19f1fcb3,0x53577b03,0x88213fbb,0xb9eb2ec3,0x52eb57c5,0x891df9c3,
	0xcca3ccef,0x2b2d1567,0x60c395e9,0x90b3b201,0xf7f70bd1,0xf4ebc9f9,0x1e9f96a7,0x7881717b,
	0xb5dbba2d,0x9ac98a9b,0x770fab4f,0x199945fd,0x11f11613,0x3f8957fb,0x2d0d3bf9,0x28b74a55,
	0x10c912e3,0x0619d24f,0x44f78c81,0xe73d935f,0xe8d7ae3b,0x12933655,0x0d99a193,0x74353cfd,
	0xdb73650b,0x2b337a4f,0xc91f4599,0xbd519715,0xade5c883,0xf95d8b0d,0xf6232dcf,0x0feb729b,
	0xc2573321,0xeaa3a8e5,0x38a73f31,0x4a078e87,0xd0e19da5,0xb1b9e4b1,0xe30ff387,0xab4d24d9,
	0x407b941d,0x677fbcd9,0x1f2fde61,0x460f979d,0x200b4adb,0x4bf9da49,0xb73f5215,0x10493de3,
	0xbf5dd37b,0x2759ed77,0x7edd24c5,0x949d50c3,0xe82571df,0x4af1ab5f,0x5c139555,0x4355f861,
	0xb7011135,0x323fea87,0xf0515077,0x636378e3,0x1473d8ed,0xc3efdffd,0xe16f959f,0xa3617f7d,
	0xcde9e1c3,0x32c97c55,0xc2ad7c0f,0x4a918f67,0x4eb50abb,0x7ec7e8af,0x9db357cf,0x09df8ee3,
	0xf915ee1f,0x960523ab,0x1b933eab,0x6cdb7439,0x1f2df685,0x15c9be7b,0x4dc3ad3b,0xeac112bd,
	0x9c0b93c5,0xab85b9d3,0x17254be1,0x977307c3,0x0c9f9005,0x15cb82ef,0x34ffd3c1,0x747bc7b1,
	0xa8c984af,0xc55d1095,0xe80513cd,0x6209caef,0xbc4b6f75,0x1e1d2011,0x3d4b15bb,0xaffbdaed,
	0xbfd36755,0x581d923b,0xf7556309,0x4ed37f27,0x11f3718f,0x0091e86f,0x170969ff,0xa0b78a1b,
	0x502b76b1,0x1ad9e193,0x04b702ad,0xea7fc653,0x4fdb578d,0xe1793711,0x591913eb,0x649fc363,
	0xb751223f,0x272179e3,0x464d5855,0xec3fc2e1,0x36c36729,0x57a50f81,0xa0df4357,0x5427c56f,
	0x614badf9,0x19074ef5,0x88bb061b,0x55c9b7b7,0x25ed0a9f,0x8c6bbdcb,0xb23bb49d,0x223dbf69,
	0xe897d257,0x2f1f6d17,0x4f1f8a99,0x934ba841,0x3b1d70a5,0x5b9b7675,0x97915097,0xfc5770fd,
	0x363b5c53,0x6a7b990d,0xf31fe0e9,0x9b77f869,0x72932c77,0x7385f68d,0xc1c3cca1,0xaa65ca55,
	0xa1b5cd6b,0xaeabf027,0xc4db20a3,0x0f830c99,0xc711d5cf,0x74ff239b,0x28314a93,0xaed98c19,
	0x1109fb93,0xe1c1882b,0x2af31de3,0x5b1de9bb,0x51dba8e9,0x1357aba7,0x68bdf8c7,0x66a7e773,
	0x18b7b149,0x0c510f65,0xc28d0943,0xd479d539,0x6ab1267b,0x3463a53f,0xe7cbb219,0x293d1e0d,
	0x1bc54d87,0x796b6c9d,0x7f490fdb,0xdc47f4fb,0xc7d5b3c1,0x10712f6d,0xf03d9de1,0x68912213,
	0x6bb163c5,0xd6a35f1f,0xcb49fb49,0xfdbbef6f,0x9e0b3a77,0x525511b7,0xd375cff9,0xd113362f,
	0x687f5bff,0x54091eb5,0xa72fd1a3,0x0e878b7b,0xc093c8d3,0x37635c29,0x0953e8bb,0x69b58d87,
	0xa0b112ad,0xc42ffba9,0xca1d7585,0x4edd508d,0xc12f3191,0xaf69074f,0x5039b503,0xb3e9ebcb,
	0xf14978cb,0xbc2bfec3,0xc1b54607,0x896d268b,0x1023abed,0x7cbb9431,0xcd0bce29,0xcba3451f,
	0xa5c933d1,0xb389894d,0x121bbec7,0x336bf5e1,0x1c2f739d,0x542bac57,0x2b2b3a07,0x87535e31,
	0x98313dbb,0x245ff515,0x55ed17db,0x8c894779,0x729568dd,0xfd0bc1cf,0xbc790af7,0x97eb6c29,
	0x51078501,0xab3f345f,0x5e51e5df,0xbef9e4bd,0xdf19b069,0x712daf23,0x9959ffd5,0xa8ddb4b3,
	0x27498c9f,0x273771fb,0x52e5b9eb,0xff6b7797,0x8bfb5377,0xfce35759,0xc0ad23f9,0x801b2df7,
	0x607b0c0d,0xd9dfb12f,0xd1cfc19d,0xad132a6f,0x21fddfc5,0x5eff45fd,0x37d56f3d,0x1e191ea1,
	0x509f8f47,0x87456dc7,0x0fad670b,0x71a14833,0xe8630789,0xe8d34f1b,0x2ab365fd,0xddc7bdd7,
	0x7a3516c5,0x95fb3c0d,0xf7a5f0d1,0x6149dc49,0xe4ed417f,0x9e312f39,0x0babb90f,0x9497d349,
	0xae43b783,0x2f1568c9,0x4b572209,0x1abd529f,0xfbdd68e3,0x556b2b65,0xb39fe5d3,0xb27b571b,
	0x2c473afb,0x5e239947,0xc2e5da4b,0xe72f179b,0x0ff55d6b,0xd751b127,0x81efd61d,0x61e511fb,
	0xc245bf23,0x31376b4f,0x2cf1b5b5,0xda4f3829,0x2279a355,0xff39f689,0x7c7f8049,0xa7c93d13,
	0xecbf567b,0xd8e5152d,0x8e9dacdd,0xf25301b3,0x732b0357,0xdaf39a17,0x6fb18733,0x8397220b,
	0xf6b7a7f9,0xc83f05ab,0x438bb4dd,0x37e7a223,0xa0492aaf,0xcacf42d7,0x0e65da33,0x0f41bb0d,
	0x19af8f17,0xd4d58411,0x1ddd5f53,0xde43c7e3,0xc6994b15,0xa1a34057,0x11fd5525,0x9f3952c3,
	0x9da7bbd1,0x56b9502b,0x86377a55,0x631541db,0xa15bbac1,0xc4bf2a9d,0x5a5f605f,0xe2712459,
	0xf92352a1,0x487f4243,0x9bb7b081,0xae919f79,0xaa539471,0x4bf38237,0x0de790bf,0x025dfb79,
	0xf1258c7f,0x6737eb21,0x540128eb,0x3369d0a3,0x39c1575b,0x2193502d,0xb97d479d,0xc2edd44b,
	0xb92f56e5,0x52753411,0x9b392733,0x0ecdc5c7,0xa667873d,0x2273c609,0x707f52d5,0xa2937b79,
	0x1343f3cf,0xac49fedb,0x73ffab6f,0x28710fcb,0x65874c4f,0x3de1ddd5,0xeccf8cbd,0xfa412e2d,
	0x6fe399b7,0x3947c5cd,0x1773123d,0x5287801b,0x2ae51349,0x95b1fa1d,0xaed17c33,0x1d693a13,
	0x0e0f1395,0x007f3bab,0x153bb4b3,0x69bfc8a1,0x08c32d69,0x9e3785e7,0x1d67f48f,0x79ff9d55,
	0x1b4b60e3,0x6b85ebc5,0x7377886b,0x754d1bc7,0x8fdf7067,0x3e4194c1,0xa5f1b5ad,0xb873a699,
	0xd399559d,0x6669d9e1,0xcec9bf83,0xc6e3cc77,0xef7fd67b,0xef2382b3,0xdc530be5,0xdbb7950f,
	0xa17b3a3d,0x7fbd224b,0x7a536891,0x1ab1ee19,0x15631e63,0xdcaf9447,0x9aef7011,0x613d385b,
	0x3df36bbb,0x089599cb,0x9fb70eb1,0xb76df49b,0xcdcf6b57,0x05379687,0x22a5278b,0x60f990ab,
	0xd081fb91,0x34836dad,0x5f17597d,0x8e455463,0xe381e511,0x598d7efd,0x3ad7e42d,0xad596ea7,
	0x0f2b4fbd,0x3997c3bb,0xef15ad0d,0x5aeb225f,0x3fc157c9,0xdd030bb3,0x51696453,0xf353137b,
	0x5e6fc2b3,0x70635a3d,0xbcd5c9ff,0xc395b3f5,0x0a4bd43d,0xc56b6335,0x9abd12d5,0xda57d0cf,
	0xf1514371,0x73fb27ff,0x8bf56d69,0x78f13f11,0xc9654fa5,0x9b17b48b,0x31b3a70f,0x2459a8cd,
	0xe953f571,0x41effc4b,0x9699f0e7,0x56317a1d,0x81cf43bb,0x58d9d73d,0x37afc4d7,0xcdc7ee21,
	0x7677d0ab,0x5a531ee9,0xad65ea91,0x810b3c03,0xd6cd4eb9,0x8c03eb59,0xf4939c8b,0x2d97e3f5,
	0xf73d419b,0xdfb7f025,0x5779cd05,0x89ad1c2d,0x2a1dd357,0x7465f967,0xf6bf8b03,0x15395def,
	0x18a9c939,0xb72d88c7,0xf2758759,0x8acb1285,0xbc0598d3,0x24559273,0x3315b99b,0xf09f603d,
	0xf63f9d01,0xa8495a1b,0xd27f2529,0x49951773,0xcb476ae5,0xa0a37003,0x24fbbe29,0xe63bbf89,
	0x39fd46eb,0x7d1dcdeb,0x62376e8d,0x55c1c3e5,0xb523b9c7,0x009f1423,0xee4d3b0b,0xf6ffc0f9,
	0x3c654573,0x2239e681,0x42bf8823,0x297bf141,0x155b3a33,0x8e1f695f,0x77737f19,0x1e5fba3d,
	0x247dab91,0xc6afdea5,0x6bb99301,0x497b5973,0xe6318563,0xe57162bf,0x8f4b25af,0x724bb179,
	0x07c5c0c1,0xfc13c9a3,0x4b474cc3,0x64f136e7,0xa069b911,0x156b9bcd,0x0b37b6a5,0x4335fd5b,
	0x0a3da0fb,0xd6753343,0xe60baf83,0x758de483,0x5b431777,0xbf5bf893,0xe71b4655,0x3c0fe50d,
	0x7e69dcbb,0x0c69bfd1,0xf72791d9,0xdf817db3,0xec83a74f,0x3715459b,0x65591599,0x824d4035,
	0x054b18fb,0x16ffcc17,0x103f46e1,0x91837e5f,0x0867d3d3,0xa2edd7ef,0x2ed131cb,0xd5df1701,
	0xae65af31,0x51cb0d5d,0xb9713e35,0x24c162f5,0x61b50cbd,0x1bb12d1b,0x72e714c7,0xb135421b,
	0x17b74d5d,0x1add316f,0x9163a3ef,0xfcef485d,0xc9af6647,0xccb58b25,0x077b44e5,0x69470aab,
	0x8dc795f5,0xf2c97e95,0x6d3300a9,0x683d8bff,0x5015392b,0x13cba09b,0x88f1f4ff,0x4d81ca5b,
	0x2b93bff3,0x9c9f739b,0x7887d97b,0xbf616bc9,0x6329c2a3,0xa1452485,0x7a2ba471,0xc7d78b57,
	0xfa9f36d3,0x3df167cb,0x557f5001,0x8589a621,0xefadc469,0x97f7766d,0x6489bf13,0x7cbda847,
	0x12ed3a8d,0x7ed32aef,0x3cbbc255,0x886719f3,0x80e524b7,0xad2f3e5d,0xf7ef3d3f,0x6b236c57,
	0xbaff7f9d,0xa9d5a54f,0x1d616b11,0x003166a9,0x60918e47,0x48c10ce1,0x2abd43cf,0x0c7bb32d,
	0x87d7cefd,0xcc0b77b7,0xbd11014d,0xaf958c2d,0xb6f31053,0xa4fdfaff,0x59d7c41f,0x74b788f9,
	0x7cf5a625,0xd5059b6f,0xd7ed58a5,0x03c78ae9,0xaacfbe95,0xeeb94a45,0x689d1c07,0x724bca5f,
	0x2c5dd70f,0xb6d70243,0x40970133,0x347703c7,0x81655147,0x654504b9,0xe0f3b5e1,0xae27c48d,
	0xd6912837,0x8611367d,0x0033e791,0x63d9d82f,0xbe77c523,0x7a739ce9,0x133ba889,0xcbbdd52d,
	0x8a93f497,0x99c7fae5,0x765ff4d7,0xbe9fca0f,0x4449fb65,0xf2958ddd,0x36555755,0x88ff0a67,
	0x45e5cba7,0xab89eac7,0x793faea1,0x9bfb1bcd,0x739b59c3,0x047bfb1f,0x87a51223,0xde5fc2e5,
	0x14871163,0xf76b19ed,0x7577d709,0x9d9d3057,0x4baf6a79,0x797b50bb,0x6b0bb54b,0x1ed14dd3,
	0x30ff9e43,0x5bfdb49f,0x8e250ca9,0xcfb92b13,0x8a497c41,0xcd65e337,0x8aeb49a9,0x17c38ad9,
	0x244b5f41,0x7a519fa9,0xbcef6a9b,0xc9018fed,0xcba94255,0x4e898fa1,0xf827a495,0x312b8a21,
	0xe5eff5d9,0xd5fb1853,0xf1f32877,0xcaa5e34f,0xaa917471,0x3dbd5b7f,0x4a1f07e9,0x8d792c57,
	0xfbed5805,0xf50b546b,0x33d73a59,0xe05b4a23,0xe0456ecb,0xee4f14df,0xbeb5c1ff,0x29a1c2a3,
	0x9ac7703d,0x80152235,0xbfbbf0db,0x004f29d1,0x6485d21f,0xe615f249,0x5a4fcdb3,0xfd11aeb1,
	0xc57dbd7d,0x62298881,0x29419915,0x2b39c847,0x8d9323a9,0xfd5d32c7,0x07c9725b,0x19bf02a9,
	0x6d95f33d,0xe8db6695,0x7a8b1ca5,0x8c47ebed,0x30336d1f,0x7efbbde5,0xb88be3d7,0xcc1b2135,
	0x930d9979,0xe43b143d,0x543ba1a1,0x992d7bab,0xbfa5dcbd,0x4843c3a9,0x8473e27b,0xbb175d81,
	0x6469aca9,0xc6dd01c1,0x0d732aa5,0x321d1eed,0x6dab653f,0xe9035ca1,0xc9e35b25,0x08279b35,
	0x5eab3dc9,0xc5d157ed,0xd3d536c9,0xc1c7dd9f,0x4a895ddb,0xc38f29d3,0x4dbf072b,0x6f39ee7b,
	0x6d531251,0xf8ab980b,0xcb8361ab,0x5d5fc027,0x64ff224d,0x2cb9f4cd,0x5b690c6d,0x66c33bff,
	0x0a67443d,0x797b3be3,0x2f210361,0xe4976f71,0xea4fb2d1,0x8bd34f97,0xe4c19d3f,0x3fb5d8eb,
	0x5e65e205,0x84d355c1,0x6fcdd087,0x219fd4e7,0x463d541d,0x7aaf34bb,0xa22b987f,0x45812ae5,
	0x60518ea5,0x99c7306f,0x552d7a35,0xe92dba71,0x43092f6d,0xe59fa745,0x32892985,0xde1b481b,
	0xf5ad2195,0x99e7ef35,0x1d5f4e09,0x3a6d6a7d,0x2975f27d,0x2b7552bb,0x3b3b682b,0xa9f19737,
	0x127b46d1,0xe9472ddf,0x9d09d619,0x5f174ff3,0xe0c56f83,0x3d832b2b,0x8823f8cb,0xa3f96f61,
	0xd93d1ed1,0x8e77a0b5,0x5f4b7901,0x0b59963b,0x0eb93d3d,0xbf9b0d1b,0x2ba5ac41,0x41a3b843,
	0xbaf3de91,0x528bb483,0xc5c719db,0x7de7c941,0x379356e1,0x280f5d99,0x9ea31fe5,0x92e18a09,
	0x97216f89,0xe1132e93,0x289db83f,0x9ff3756f,0xde15bc2d,0xdfb1aa2d,0xe07d5d91,0x6227cd5b,
	0xdbcb0fb5,0xe823ccad,0xf673104b,0x252dc7b1,0xa3831157,0x61d148e1,0x97177ba1,0x5463db63,
	0xa56ff18f,0x384be51f,0xd46b3a95,0xabc92d6d,0x679d3f1d,0x5c45f841,0x2ed33ced,0x090b1dcd,
	0xdf0fdc0f,0xe49d06ad,0xbe234c39,0xdc79f48f,0x68a712b5,0xcf5b7f53,0xfa91b0cf,0x3a0faec1,
	0x6231caaf,0x62ad98a7,0x25bff6cf,0x8a6feb7f,0x6361dddd,0x2de94da5,0x53b5d321,0xdbe1f8eb,
	0x16d38d6b,0xaa8d7ad3,0x13e12873,0xd35b012b,0xb30d16cd,0x7d3f1b3d,0xba1f2c3f,0x3d755773,
	0x137b68bb,0x56cda57b,0x47adabc1,0x3f71e4fb,0x716ff83d,0x752d88a9,0xf4337101,0x2839b603,
	0xbd27b59b,0xc47fc96b,0x56c1c7cd,0xe161a6d7,0x96c7216b,0xa007bef1,0x2ed122c1,0x002330c7,
	0xe75b8185,0x3337efed,0xcd43e037,0x7661572b,0x19d7360d,0x7aa10f9f,0x1d5d2f59,0xe3a3b467,
	0xf4172e71,0xe5051acb,0x4dd11517,0x861fa6e3,0x0fe17e61,0x944994bd,0x19b79125,0xcbab9e0f,
	0xf3e112d9,0x3e7de44d,0xb191e305,0x82cd8765,0xcca9871f,0xaed5d0d7,0x4445eefd,0xabaf5b67,
	0xc5b719b9,0xe6af1f3f,0x2823c31d,0xe921ca9d,0x026fc17f,0xde934ef3,0xa3e33c3b,0x919d0a99,
	0x371f628b,0xe72d76e9,0x57a7caf7,0x6049c2f5,0xe1f7233f,0xaa57429f,0x45f758b9,0xc5eb1a51,
	0x2417e147,0xcc0b0f17,0x7cc34cb1,0xd9f9e355,0x3a81c697,0x2b7327e3,0x5e63b0d3,0xeb89e9b7,
	0x9723fe69,0xc3db2413,0x8a9776e1,0xb2615f2b,0x99cf8a3f,0x2db96349,0x6789dd61,0x1feb6875,
	0xe94336e9,0xbfadaaa7,0x4ac5f4a3,0xd035ca5f,0x6c23b175,0x4f7be1db,0x424943bd,0x1affb6b7,
	0xe1fdbc41,0x9313f01b,0x7d718d91,0xc4a7b959,0x1c4183f1,0x218bb923,0x5605b5c3,0x4f3bc525,
	0xd74f146d,0x14213a39,0xf939c5c3,0xeb696107,0x3369eded,0x473bc72b,0xb0a111cb,0x098df4eb,
	0xcdbdb9e7,0x3b67674f,0xcb417dd7,0x8aab36cf,0x795f2021,0x965d527f,0x267fe2af,0x916db7b1,
	0x9849bba7,0x43f98e23,0x572d92e3,0xf321909d,0x14632fcb,0x3743aa25,0x727fffc9,0x48c72fa3,
	0xf8755d29,0xcb679dff,0x771b7e83,0x9ffd44db,0xa937b6a3,0xc4bfc5ab,0x56052cf5,0xcc0fcf69,
	0xbe43b665,0xf1c5feaf,0x9bb1f6cf,0x56f14a73,0x7b1d72e3,0x6c23e519,0xb8f3ba8b,0x1239fa2d,
	0xe83353d7,0x79a3307d,0xec0d8e65,0x482d58cf,0x8bd9e745,0x0d3f30f9,0xc9a92565,0x8cb5a399,
	0xc34bd677,0xe8156c33,0x65d5545b,0x2e6387d7,0xbbabfb03,0x5a695a55,0x1d09b6dd,0x4775efd9,
	0x0b0993c1,0xa4ab4319,0xfd29744d,0x6ec9eff9,0xe95799d5,0xf8713ab9,0xce7924cf,0x08ebd397,
	0x097135ad,0x19773efb,0xbcabd653,0x390d4a1b,0x121d53f9,0x9ea7742b,0x9fd53193,0x720bb3fb,
	0xb7055ab7,0xd30d8221,0xe57bbf0b,0xa7638fab,0x71bffe27,0x36e11139,0x19854c03,0x1e4306af,
	0xdac535d7,0xa07f6757,0x0f416f8b,0xde7d9a8f,0xa27f5199,0xfd6d24eb,0xaa672f79,0xc389f1dd,
	0x2a372e89,0xb35d21e7,0x4819c56f,0x2d8bc533,0xbd218c09,0xa1216acb,0xc7dd83d1,0x524dec31,
	0x695980c5,0xbfb95d99,0x34a7dad1,0x2e418a81,0x78e50fb1,0x634be6e3,0x0dcb7d63,0x15835cd5,
	0x8aafdd07,0x1c27deb9,0x300da649,0xe4d125e3,0x4b8d034b,0x37bf85bd,0x5e937d09,0xd2993b71,
	0xcf3b0847,0xe1b72211,0x6bed9af3,0xdfed3343,0x895df211,0xe4d1bc63,0x0315b01f,0xe985b02f,
	0xe67f7c01,0x0bfbfce9,0x106b4869,0x58c54f0b,0x85156bbd,0x234f2861,0xcab5b07d,0x74b7b3b9,
	0x0e7d062f,0x99093d0d,0x5c25fac5,0x530db623,0xaff9a489,0xbe8d2fbd,0x2b53247d,0x6921af3b,
	0x33b56949,0xa96d48c7,0xc4415aa1,0xbcf5e5f9,0xb9c7152f,0xb45da105,0x61535ef9,0xb6351c5d,
	0x112bfc49,0xa03dbedf,0x145d0d15,0x8f333c73,0xb0c71ae9,0x55135341,0x8f97ff4d,0x65e7254b,
	0x50634aab,0x430b16a1,0x8e9f53bd,0xecf597ff,0x21b59771,0x637dc5fb,0xdf7f914f,0xbca544ad,
	0xa95bb467,0xd9e73fd5,0x0ba7acb3,0x43edf783,0x37d79101,0x34efc13d,0xa0ef2d5f,0x5965e5af,
	0x02950df9,0x4f6342c7,0x1a977291,0x6c511a6b,0xdcedd253,0xd13bf591,0x6a471851,0x559703f9,
	0x9117405b,0x5093e041,0x21117c6f,0xc8cf20a1,0xd9398aa1,0x12b39c03,0x386b6383,0x652fcbb5,
	0xf85fe905,0x6d07318d,0x7b37bde9,0x66992a8f,0xf37feda5,0xc627161b,0x8ebb8ccb,0xf69b398f,
	0x6a73f9f1,0x36d34873,0x9babe719,0x1d65f91d,0x10ffd39b,0xcaed8de1,0x971b1e89,0x52d1baaf,
	0xc7d1599b,0x6287cf3d,0x2b8f0499,0xaf618db9,0x557b5939,0x32d595e3,0x41ed4f91,0xbd41ccbf,
	0xbf7d82fd,0xe737a8b9,0x2a851f81,0xe941ca4b,0x43377fbb,0x6231c929,0x6611a341,0x93dd9deb,
	0xeef7258f,0x1e73902d,0x0eb1dd6d,0xc237113b,0xdaf3ccdb,0x2fd16b3d,0xe0eb8971,0x6f17acdb,
	0x0245c54b,0xe44db963,0xe4b12077,0x7bf3e575,0xbbf1ead3,0x050b082b,0xb65bfe7b,0x41e368bb,
	0xd3e55aaf,0xb75970a7,0x6faba739,0xc2a98a63,0x43f5485f,0xfdaf1479,0x30c52b3b,0x79b1d133,
	0x8cdbf2af,0xd8a9bac3,0x493daccd,0xcd0ba3f1,0xaf3fb8b5,0x080d8d35,0x010b0507,0x1e73166d,
	0xc4a94ec9,0x6bcdf501,0x018d88cb,0x7c49d685,0x38911391,0x04fb97e5,0x5e8dedbd,0xf29b3915,
	0xa15184f7,0x96d77529,0x3f3b4f4f,0x7c176709,0x392fd52d,0xe7c72297,0x272f53b7,0x931baa53,
	0xf7559fb1,0xa25b2987,0xdf6770f3,0x62a7daeb,0x48d9be45,0xd64783d3,0xff5151cb,0x9767ebd3,
	0x69b73df3,0x196938e3,0x15b75acf,0xd0ab9813,0x5dd1740f,0x48c91aa3,0x71d74f57,0xb16d2fbd,
	0x89f73335,0xe995a289,0x8c4b1681,0x915384e9,0xecdb2047,0x2a21ee93,0x1021a033,0xcda3f8bb,
	0xf8192773,0x82efde43,0x83c5ea1f,0xba53a85b,0x09371129,0xf7a34fa9,0x921324b9,0x32fbb9f9,
	0x829f3725,0xf80b7c59,0xf349f845,0xcbddc9cf,0x84a7596b,0xe11d7673,0xf60de9c5,0xa2e3771f,
	0x468b9345,0x1df9c599,0xa875e00b,0xd0a11131,0x0f6f7049,0xe8e323f7,0xa0f5c8af,0x79516459,
	0xcf5f2151,0xac4b5b47,0x676d5d0f,0x7dd3a6eb,0x584fd17f,0x03c741c3,0x7e270751,0xccb3864d,
	0x371b1b3d,0x5d15d731,0x0ad3e767,0x532553e7,0x2c899d43,0x391b81df,0x1f8bf807,0x8dff522b,
	0x4643af89,0x0ce96ba1,0xa3cb53af,0xbac7218f,0x97e13851,0xc2b1fed5,0xdd7d99a7,0xa8a54d97,
	0x93dba12b,0xdad58361,0x99f372ff,0x296df9cd,0x0497ebe5,0x2cdbdbb1,0xf6e5378f,0x2299aec1,
	0xa561e79d,0x487161b9,0xcb71b2f5,0x3e49470b,0x5b6d85b5,0x766be3f9,0xb1210997,0x3c49fc4d,
	0x0ed74edb,0x59cbc275,0xace5bda7,0xe30d9431,0x23a5f7ff,0x30b32bbb,0x7813d41b,0x90abad69,
	0x92c3175d,0xb57579df,0x696f19b1,0x6be92cad,0xa303f979,0x9f85af7d,0xfe2187f3,0x352fc9bd,
	0x4225961f,0xc48314bf,0x02b5ca2d,0xb791bc65,0xfdc9a561,0xd933f44d,0x5c27e279,0xd9c78975,
	0x9c7dd499,0xd285785f,0x70d7eeb3,0x4f37efc5,0x56b51b6d,0xe68fa7b3,0x318d0d87,0xe8e7f539,
	0xafcf30c7,0x2d8d828d,0xc2776361,0x868b13b7,0xef0d1fdb,0xe2e93fb9,0xc4313f77,0xa77d8633,
	0x389dfd21,0x462fa98f,0x3cb760cd,0x9bc1b5a5,0x4691bb61,0x1c179aeb,0x20755b25,0x54ffc60f,
	0xc1e920a3,0xcf7d9c31,0x7b391c13,0xd78b4379,0x3b85db3d,0x3269a04f,0x393d8fe9,0x4b5deef5,
	0xc533b6c7,0xdf07e1bb,0x902166cb,0xad19ab9d,0x2aa9f125,0x38afdf71,0x07ebf99f,0x1f098b91,
	0xca81af85,0x0cdf79f9,0x240d4f13,0xda21fcfb,0x0f3f9357,0xd43f305d,0xac5f409d,0xbef7170b,
	0x88516f57,0x93997d35,0x9621bf81,0x86cf06fb,0xa30b1c89,0x5ce7539b,0x8cfd39c1,0x94959d0d,
	0x03a76f39,0x7045bc37,0x1c011f31,0x65dbf98b,0x7e4d4bf9,0xfcfd9235,0x76a58663,0xa3d959c3,
	0xb005dca5,0x8277604b,0xe1cbf1bb,0xd4730511,0x37c7e55f,0xd14f5db5,0xbcbb345f,0xab3359d5,
	0x8f6d3993,0xac418b39,0x2a25773d,0xfa4bfa79,0x84bb50f3,0x0931f025,0x59215e0b,0x43971a6f,
	0x525ffc7d,0xf231f74f,0x6e2d4c4d,0xe995eb2d,0x58ed3b73,0x0677ec11,0x0c37ca45,0x00732939,
	0x77e1305f,0x9b5d9751,0x7d890a07,0xbf01c917,0x069d3617,0x7d6ffc7f,0x7cdf8c67,0x8fbdc45d,
	0x6d7114b3,0x5157368f,0x9e59e603,0xc1c506a1,0x5e8f5697,0x94ed74fd,0x587fa447,0xd9e37a87,
	0xaf13bd71,0x402f18cf,0xad3f525f,0x838d36b5,0xd003d731,0x0643f193,0x72f39e43,0x21ddcadf,
	0xe749b313,0x36779a5d,0x3d5d9db1,0x0091acbd,0x88bbb69d,0x3d43f6cb,0xe6a33333,0x2517c50f,
	0x0f159297,0xc543d001,0xb8559315,0xbf7f1ca1,0x94f95813,0x783f91af,0x346de871,0x3b85a943,
	0x8df7ad71,0x60252707,0x7e491a25,0xf18b3acf,0xff812351,0xe809f7c9,0x63b3afd9,0x779b8825,
	0x59f5a99f,0x7d2d0539,0x05dbd6fb,0x92675c2d,0xf193248f,0xcff32723,0x225b87c1,0xc649e2db,
	0x178d219b,0xb4ed68df,0xfc2fca2f,0x88431627,0xd2f3ac87,0xa5cf8649,0xe4c11b07,0x0f014b13,
	0x39c3445d,0xe27988c5,0x64e3f0dd,0xc3d3dea9,0x69e1f073,0x31ef8441,0x05cd6105,0x53b502f7,
	0x22197561,0x43617435,0xba1de49f,0x6049ac19,0xfb1faa0b,0xaf253899,0xe6db3d91,0xd0d99d2f,
	0x408fec9f,0x97b9b2f7,0x0c7b7b8d,0xc3559563,0x69efb78d,0xeac30359,0x0fd32109,0x1d5b9ce5,
	0x33ab5693,0x4211e557,0x23236845,0xbd2b71ef,0x5815bbb1,0x64992d0b,0x4f13a845,0x4ab115c5,
	0xe86b7435,0x677b641d,0x9bb5d9dd,0xa87d79ab,0x45d1bdb1,0x6efd86b9,0xd97f3ca1,0x04cb4bf7,
	0xba53bb01,0x0f8be095,0x0a511bf1,0x8a7de4ff,0xb1e7c947,0x4ebf09ef,0x6a77b3f3,0xb21b5425,
	0x9365f4ef,0x44530489,0x199d3699,0x32db8cd3,0x39958ead,0x5b2f78b3,0x63dff099,0x9395b37b,
	0x0c23e07b,0x32631243,0xaab98e73,0x5bcb8a95,0xb8a3029d,0x1e23fd93,0xee17816d,0xe4a9ffa1,
	0x8b8fd09d,0x48cd848b,0xf5478495,0xc9ffd82b,0x694dfe4f,0x73e9cb97,0x180341c5,0xfb477ec3,
	0x67294cd1,0x5925aeab,0xa769169b,0x6ca7f001,0x0459df81,0xab57be49,0xf703f97f,0x67e7c789,
	0x02f7b10f,0xb77b5c71,0x05c17e9f,0x7d776d01,0xe107286b,0xa5bbf9b3,0xc6fbfcf3,0x1575611d,
	0xf177cdd3,0x5a637223,0x0b73d339,0xa0a1aa95,0x15191fc7,0xf6e98a5f,0x0a4dccfb,0x6965632b,
	0x13ad8815,0xfaed8c8b,0x8a1da785,0x04d564a7,0x94d370cf,0x05350557,0xa9d9b6f1,0x63ab15db,
	0xb91b7951,0x34ada0f7,0x49e3ab1f,0x834957a1,0x52f5cb3d,0x296d2827,0x150374b1,0xbeb791d7,
	0xbfc18f7f,0xa5b39d2d,0x29694a1b,0xbfa9e06b,0x60c3834b,0xcee578d5,0x61adcc93,0x0f7b604b,
	0xb425ad1b,0x0e930777,0x3dcd4d19,0x482d9c73,0x0dfb31b3,0x936fe5ef,0x6c373173,0xe5691ae1,
	0xf145491f,0x725d9ea1,0xf2b5792f,0xb583099f,0x08e353af,0x675f667d,0xf78362a7,0xea750bbf,
	0xc0a50f03,0x36a3f9f5,0x2a412ff9,0xcadf265b,0x7e3deaf9,0xad839a09,0xccf50c0d,0x030fcd95,
	0x7a477ec1,0x4379293d,0x5d130f91,0x95f31193,0x39491dcb,0x5b2f689d,0xdc6f65fd,0x6e29eb87,
	0xa4ad8cd5,0x236f54c1,0xba4d9291,0x8eefaaad,0xc3c9d6e1,0x1835a2c3,0x5c51d553,0xe5358143,
	0x14d74239,0x23995d4d,0x478fb011,0xb8873195,0x85ff6571,0x5ee7a187,0xe97f8b65,0xbc25daf1,
	0x0e4b5c65,0x73897c29,0x00ff7bad,0xbfede6b3,0xe6af1d37,0x9c15e671,0xa75b2611,0x016b153d,
	0x6307ed53,0x454de321,0xf93fc57f,0x1cd3aaf5,0x6b19f66d,0x4f15bb89,0x5fc54faf,0x9dfbbd4f,
	0x938ffb7f,0xed7b5c7f,0x796dba21,0x31699fc3,0xd6ff2dcd,0x29b7d35d,0xa31f5f1b,0x754570d1,
	0xeee521e3,0x0325eb0b,0x212d82ab,0x6a63c705,0x4ca5e491,0x304de8f5,0xe84df7ab,0x853b7def,
	0xb28b2ff7,0x7fdb6a11,0x06a1e4bb,0x5ef1a329,0x6ccbc073,0xd9a75fdb,0xacb1a93d,0x06518351,
	0x2a81c9b5,0xdfb12d5b,0xd66de265,0xf0c9d715,0x76b38baf,0x2f1be41b,0x942d902b,0x8b751023,
	0xd14d0799,0x4137a131,0xf3af5a49,0x6c19c635,0x6821d4fb,0xec790a3b,0x891ff54b,0x221d440d,
	0x6fed169d,0x857fea5f,0x980da77f,0xa7953473,0x1d558f93,0xa011ef49,0xdc6fedfb,0x72396f39,
	0x3de5d839,0x701d862d,0xf3a7419f,0x246de639,0x7111b331,0xcab9d8cb,0x657bfc13,0xde3bb253,
	0x01378269,0xc721ea67,0x4d1d5cc5,0x2e554071,0x5c99dc11,0xffbfd4cf,0xa227aded,0xa3159e83,
	0x2e633fa5,0x731f2557,0x2195898b,0xfb7fe885,0x17adeae9,0x04f959dd,0xd6d33e65,0xf83bd575,
	0x086fcee7,0x9f297dc7,0x44af5509,0xcc9b645d,0x388fa4f5,0xf2b5e6ff,0x2e6334d3,0x2f9da951,
	0xc0d923ad,0xd8cd12ff,0x008de8dd,0x0cdfba67,0xd40353f1,0x53c7a3c1,0xda370511,0xd5adbcc1,
	0x97a705eb,0x30217ccb,0x35d1ab1d,0x71f91189,0x9d496613,0x45830029,0x3233af79,0xd15da2f1,
	0xfb57b221,0x57b76b73,0x7b9dde65,0x1c1b5131,0x06230e17,0x97b754c5,0xd4b960e7,0x841f7f89,
	0xa8eb7943,0xc49f47c3,0x3f9341cd,0xb5fbc145,0x5ed5e339,0xecb7829b,0xc6a912b3,0xe9e7a6b5,
	0xcbe960d1,0xce6dd305,0xe5d7b0f3,0x94c7aa31,0xf61f812f,0xd9559339,0x93652ab7,0xb9253d1d,
	0x1e51c2bf,0xcf31c701,0xe907c3ed,0xd831f4df,0x39432835,0x04e358a7,0x6cd31b4d,0x82cbd7eb,
	0x08a3ed8d,0x437d7603,0xfa476f57,0x8a6fcab9,0xd4055d07,0x49330d6f,0x4b510351,0xd24b1ccb,
	0xc1e3c42f,0xea656ad3,0x213ba44b,0xc02f35a9,0xd0a388db,0xd297f49d,0x0dc14e1b,0x4d9761e5,
	0x6f935e25,0xe57908bf,0xdc03f061,0xb8a5c017,0xb7e5996f,0x3fe1f9b7,0x99875385,0xd5234de3,
	0x45b5a763,0xd8cd2b8d,0x3f3f1db5,0xfd8114f1,0xb107a0f9,0xc26350cb,0xfa85f7e9,0xa3dd77f1,
	0xa6c90069,0x0af1c787,0x1615d2e1,0x82f99f9d,0xa1cf7635,0x3def165f,0x831b4c23,0x6f3b07b7,
	0x43d5de2d,0x84f98979,0x022532ff,0xc7bb2c09,0x4e7f545f,0x68d7ef81,0xec2b2d8b,0x872f5561,
	0x3c576a29,0x327576ad,0x9b917da9,0xf4f9869b,0x79d57b2d,0xebeda9b9,0x751be5fd,0xf6278997,
	0x3e532259,0x01798ceb,0x90fbaef7,0xfe691c3f,0x0517cedd,0x8281db11,0x03c9cbcf,0xa1193d83,
	0xa64b7935,0x0295627f,0xc7851f85,0xc2399a5f,0x10057825,0x1a698213,0x4497e1df,0x67731ad1,
	0x9f4175b9,0x88dbc633,0x7ad1246d,0x291d8ee5,0x18e38443,0xf3f5a5cb,0xca697785,0x432d7bab,
	0x42b7535f,0x49df5f4f,0x5d01af47,0x4645083b,0x1c7184ef,0xc1f5f5bf,0x2ea1c89b,0x68b30ab7,
	0xb8ad221f,0x7db34d9f,0xb6b7ee31,0x77653549,0xb5f13061,0xc9bf69fd,0x311f9d7d,0x66f96323,
	0x57a76673,0xfee7c96d,0x8717ebc1,0x84af057d,0x3f270157,0x0321e30d,0xd847eb03,0x4773b097,
	0xc4a7b957,0x6a8dc381,0xa3bf2f13,0xc0d5c8bd,0xf051d707,0x3871c9f9,0x90f97287,0xae114f3f,
	0x132f6843,0x40398527,0xd8d55bbf,0x2907cf77,0x0037952f,0x267db04b,0x4e9961e3,0xf9456bc3,
	0xe5411533,0x01fb5029,0x08f7d1e3,0x84f90a91,0xc415c407,0x9c99f00d,0xab09f373,0x6201a34f,
	0x8b5f56a1,0x5467fecf,0x4d4b4e15,0x86ddab77,0xcfb13047,0x9c994bcb,0x06a90e0f,0x1bb7a38b,
	0x24895785,0x1e8da3e5,0x15718971,0xeb63c413,0x154b8b2d,0x7acb8e8b,0xa85be511,0x745bcaa1,
	0xbe43775b,0xa9ff2ab3,0x478bd991,0x99bfe6cf,0x05a70a71,0xfe032bdb,0xdd859855,0xf45dc73d,
	0x748fea1b,0xc2d1f705,0x603bd08d,0xc3a3c695,0xb005084b,0x7f93dfc3,0x1a05d431,0x7eaf3887,
	0x91ef583f,0xd7958525,0x92a3dd01,0x0541d6cf,0xe227a379,0x0b4d4ecd,0x183d7183,0x70c34e2b,
	0xaf657ec3,0x195b09dd,0xe865ea07,0x8549eb65,0x484f5f33,0x7f83a603,0xf91115a5,0xc28b6851,
	0xd473cf21,0x9bb51275,0x61a3ff39,0x14efd8c5,0x8d41c333,0xad073aef,0x63e3d26d,0x267bb7a3,
	0x97190f51,0x74b724b7,0x14ffe0b1,0x4fe313d5,0x7a3dfbb1,0x772b2b9b,0xa693c639,0x2983dd4d,
	0x3bdbf9cf,0xdcf35ef1,0x4f9baf07,0xbc5b5201,0x1707796b,0xf3c1fe93,0xd583bbe1,0x53158af7,
	0xd5bbdd93,0x4f7717e7,0xb51b8757,0xeb052933,0xc9df9199,0x8b1b42dd,0xeb99cabf,0x452322cb,
	0x663b3e19,0xa9db7ee9,0x5f9d233b,0x9715afd5,0x77871df5,0x180b3007,0xea33f6af,0xdc215775,
	0xfd5d7359,0x4c2b3bbd,0xffc778cb,0xc63b1cd1,0xa3411cb7,0x07e34619,0xf933d009,0x4efdcc1d,
	0xd9a149cd,0x38fd0eaf,0xfcb75aa5,0xe8ab6791,0x8ed1509d,0x7a73ed9d,0x86fd13a7,0x4f2db46f,
	0x880da273,0x35637089,0x941317df,0xf917e7ff,0x5a77e0df,0x6211179d,0x68734ae3,0x28a17493,
	0x041f12bf,0xe8ed3293,0xf9fb1c15,0x9cb1f683,0x24f7f937,0xa38ddda5,0xf8f56b99,0xe1cd4133,
	0xd7db84b1,0xfdad1e99,0x79118f5f,0x43298c0b,0x2b8f69df,0x363721bb,0x3a677821,0x5b9fbf7b,
	0x3bc3d6bd,0x403796e3,0x9277f65b,0x46b3e1fd,0xea054791,0x43e52e6d,0xf5291f55,0x718da513,
	0x36d77be3,0xbf9d363d,0x1dcfd21f,0x0bff1247,0x3a9b8b87,0x48e556c3,0xd81f5c91,0x19875827,
	0xbe9d1b99,0xed6f6ff1,0x693b4047,0x2243b74f,0x7611b37b,0x340d9647,0x98ab17ab,0x83ff8f5f,
	0xd71331d9,0xbdbf2fc7,0x595d9aed,0x632d8c01,0x93a961a7,0x86ab3103,0x12adc501,0x3be7f1e5,
	0xb2bdaf1f,0xc7217a0b,0x895718a9,0x12f10bc7,0x4925fcc5,0x74935381,0x6887056d,0x46b3b765,
	0xd29d9863,0x62a50b87,0x6acd6c99,0x003f128b,0x2ac9500f,0x0419b2cb,0x231f4645,0x44514807,
	0x2635a721,0xcbddf983,0x65dd6653,0xa44b7cb5,0xcb552b3f,0x2e0b2c6d,0x51d16167,0x8f37dc77,
	0x2b87e951,0x40df51cb,0xf92d91f1,0x42c7c733,0xdc0b028f,0xfdbd666d,0xaa853d2b,0x5c551ddd,
	0x0f13616f,0x2237baa9,0xd9dbd811,0x09e5af6b,0x4caf8eb9,0xb1016f59,0xa9996c6b,0xdb1fc5e3,
	0xcbdda675,0x12fb12e5,0x138d1dc9,0x3255d34b,0x6b816cf7,0xd82b5e39,0xb1efce83,0x55833eb5,
	0x4b6783db,0x18bd11cb,0x2861e4b5,0x1f4b5139,0x0545bf03,0x7609f297,0x2ceb2f4b,0x4ff742fb,
	0x85b3999b,0xbb8de723,0x30fdeaef,0x7e796821,0x8539cb17,0x1fef347d,0xaa6fe71d,0xa96b7ddf,
	0xa143fc31,0x25fddb39,0xfc81cb11,0x680f176d,0x15239bed,0x1daf1475,0x00db7ad3,0xbb512b0d,
	0x1319d495,0x4521eed7,0x308f9c33,0x7ec1bf07,0xbd45a0bf,0x899b0b8b,0x6d133bc9,0x799bb6ad,
	0xbeb50043,0xe8897b45,0x694991f1,0x0fc1bf59,0x845f4d47,0x7083bb45,0xb279e7d7,0x92bd5d6b,
	0x161bb135,0xe249d251,0x59519c65,0x32c1194d,0x8fb3b9bf,0xf1bd8db1,0x3aed4957,0x8fa5cc6f,
	0x39cd0de3,0x26f1de3f,0xe9c90829,0xe9f10e4b,0x430342e1,0x5f195557,0x36d1d723,0xf3c9c165,
	0x18cdd147,0xed95c1df,0x5a551e55,0x4205c041,0x609329e9,0x5ce9ed41,0xbd0b5497,0x5d1baa73,
	0x909deadf,0xcfc57875,0x6113c487,0x722dd195,0x2923348d,0x01fdd8f9,0xeaf7718b,0xa4094649,
	0x8d3f1e9f,0xe99375d1,0x4aa71cd5,0xfc1f0535,0x7bf54d09,0xf7abe48b,0x047d6a59,0xfb87440b,
	0x2933a505,0xf9934639,0x1a3525d9,0xcc09de87,0xf6cd2217,0x99c3c47d,0x93fba7dd,0x1109e367,
	0xcd7dcb0b,0x80d72e79,0xa95d5ab1,0x589d4177,0x15ebc6f1,0x1695b5dd,0x8a535f6d,0x2c7f9487,
	0x519f9229,0xe2efcbdb,0xc83f52f3,0xc311126f,0x54115353,0x8ef71e31,0x5ee932e7,0x505b9811,
	0x1b9b505b,0x85edb427,0x5d8162bb,0xf713d659,0x4a838373,0x36372b87,0x2f9fd0a5,0x59919f35,
	0x3ff35019,0xf26515a9,0x86433aa3,0xcad7529f,0xd101580d,0x722b7467,0xe0d5937d,0x1f8f6b97,
	0xa1a7705d,0xf3675729,0xb62787c5,0x1f0d2d29,0x1dcdb65d,0xfb2197db,0x3d6f22cd,0x944b6f65,
	0x123dc4a3,0xb687b7f3,0xd74f93b9,0xfee98c65,0xe5ab0819,0xfbeddd6f,0x16cd126d,0xe4356d49,
	0x71b334e5,0xebd5efd1,0x6a5de49b,0xc01db739,0x7bdbdb7d,0x31e3d529,0x64d382b9,0x963f1869,
	0xce8d1d9b,0xe5e5cf0b,0xa673dd05,0x22dbb511,0xf21f8343,0x0cd1f797,0x65e3c087,0xabdbb473,
	0x85cdefc1,0xb9c7de6d,0x99335c0f,0x71d3edd9,0x38bbb6a7,0xcf0b45bf,0xbedde535,0xc0fdb591,
	0x62f3d0cf,0x5f0dff41,0x46bf5d57,0xa239c9f7,0x3e6f315f,0xad63e92f,0x9b25769b,0x2c15606b,
	0xc0053ac1,0xcfcb0b4f,0xc9bb98f3,0x73bf5257,0x107d53a9,0xef2bd3ef,0xcc9b0715,0x1e156a2b,
	0xa5819c0f,0x289374e3,0x7345237f,0x9097d063,0xfaa7c23b,0x0e356089,0xeba3d579,0xc26f987d,
	0xea6bf7b5,0xc873e6c7,0xeb030e15,0xad716e03,0xa7310651,0xd6d3f209,0x771d6d25,0x5f156189,
	0x5445852b,0x7103e443,0x4f13064d,0xa981d5a5,0x3edd2da7,0x87d793f5,0xf46d45f3,0x747b8bf9,
	0xb711506d,0x66516923,0x541bf643,0xae77d231,0x88e96a73,0xf2939a5b,0x0f756439,0xdd91cef9,
	0x1551d9f5,0x8eef89af,0x653ba491,0x5089ef0f,0x0b1bb373,0x9ad941c1,0xba95f8d5,0xefc97233,
	0xc005b6b9,0x93f112b5,0xc4135451,0xae65182b,0x29b363dd,0xd6fb4f35,0x4eb1011f,0x9b15edcd,
	0x76b33039,0x00e72979,0xa8c9651d,0x913d39f1,0x4775db6f,0xefcbb03f,0xab29e6f1,0x89e78a75,
	0x8759e46b,0x63e3ebcb,0x61fdf30d,0x8cc7e147,0xe5a11e5f,0x40991ae9,0x55e120a7,0x41330155,
	0xee7b65c9,0x6d790ff1,0x74d176bd,0x1f31db99,0xc3f9756b,0x573badbd,0x9b39d117,0x40691c13,
	0x7719db4f,0x10bb84b7,0xbce96547,0xd12dd6d1,0x00c10dc9,0x14018fc7,0xae1567a1,0x217b54df,
	0xdab9a075,0xa3391165,0x8c63d043,0x55f10157,0x38b99937,0xc9bb908d,0xc7d74019,0xb8db765d,
	0xe15be537,0xfd05f5c7,0xcbe305cf,0xab2baa19,0xa723edeb,0x5dbfc81d,0x485f42dd,0x357b3bbb,
	0x817f4e0f,0x98b38a27,0x1a8b3081,0x390fe07f,0x45c1a6a3,0x67db36ff,0xd61184c3,0x40cff0a3,
	0x002993f5,0xb355df4d,0xedfff775,0xf24f1471,0xecd7c297,0x5265663d,0x7dcde72b,0x1ec7113b,
	0x10db2463,0x6c795e85,0xb25d1e43,0x741bb65b,0x7325457f,0x7a2b0761,0xd2f7b7e9,0xcdd5ea33,
	0xf597c155,0xe6376997,0xea4b2509,0x2627d729,0xcdefd799,0x4e819475,0x0f71515b,0x26eb38af,
	0x9edd2145,0x651bfacf,0x4ee9e85d,0x5aa5c841,0x30f5659d,0x713bf005,0x339bba59,0xfd7dca5d,
	0xcbb38f2b,0x703b44f7,0xefd9415b,0x6e45bb8f,0x2e79c0c3,0xd6a70517,0x2659463d,0x3f791d65,
	0x29978a81,0xf1295359,0x533ba59d,0xe83b637d,0xd73f3ec9,0xe5996739,0xd50b34e1,0x15550073,
	0x748d6743,0x53f5a9bd,0x95b5c73b,0x9a3992f5,0xda8559e7,0x9763f273,0x539552a1,0x020132af,
	0x9717edeb,0xa733e46f,0x8a6734d1,0xc06fdd5f,0xa61350d5,0x97d76b4d,0xfc579855,0x02ef03c5,
	0xca35fb71,0xbbf15837,0xdaf3f979,0x219336a9,0x8625c6d1,0x65471ed7,0x9035cb57,0xb013f3dd,
	0xb56d2151,0x45c7b261,0x277d3ccd,0x2ed39339,0xc5816393,0x70858295,0x56911d83,0x5bdb53a1,
	0x8ebd4583,0xfac398b7,0x26a3e2e7,0x23e187fd,0xcd677355,0x3ce3d493,0x3d4bcd31,0x333de43d,
	0x3aab4283,0xb3774981,0xc5892c5f,0x26f3ea5b,0x459b86cf,0x8033bb5d,0xf8c7c53b,0x5da97759,
	0x6c358749,0x8af73b8b,0x47d15651,0x68b7703f,0x345b133f,0x42c7e5f9,0x23e53cfb,0x1d138f1f,
	0xc4ddb74f,0xfed3be1f,0x679f3a57,0x445f5013,0x1e6f125d,0xff71abf5,0x6009584d,0xede9fe3b,
	0xf4a94a93,0x0f1f9905,0x7591ee89,0x5fa1e0c1,0x2713a263,0xc383ad59,0x7513c787,0xa72187d5,
	0xda192d89,0x5e6bac89,0x78cd6585,0xcaab39b3,0x300da60b,0x4ecd72af,0x71676789,0x9a2b7f99,
	0xa22d6131,0x51c99173,0x4ef30e61,0x2031d2d3,0xf99d648f,0x33a50d01,0xc9e7e1a7,0xb2f969af,
	0xe8699aff,0x30cd390f,0xcc2574b9,0xa5632489,0x428529a7,0xf6dbb5db,0x79f34bbf,0x97fd9ac1,
	0xd6cfe4f3,0x45898d27,0xdb03e0a7,0x69f747c3,0xe809e591,0x2fbf6f43,0x236fc827,0xca29d7fb,
	0x45e13d81,0xfc8d1005,0x9cb3f6c3,0x681b95e7,0x05e9cd05,0xa827a3c7,0x2ebb25bf,0xc4f1f705,
	0xdca137a9,0x04eb7c71,0x88d55829,0xa48148e1,0x1669f93d,0x7c61c66f,0xeabb7fdb,0x1e457e0b,
	0x308f9adf,0x703765b5,0x8d8d4273,0x4e5f1b1b,0x124907f3,0x3b43f2c3,0xacd1de59,0xa69743b5,
	0xe5af0323,0xd281d79f,0x2f792fbb,0xdf63e77f,0x90cbbb61,0x061b8cd3,0xf0ddd591,0x88d90f2d,
	0xce8580eb,0x625df675,0xa9bd7699,0x3bbf4977,0xe7b19a41,0xb0bde123,0x7941265d,0x6a7f381f,
	0x0c0f3931,0x18db9f01,0x0dfbea2b,0xd2293ced,0x4b3f8fcd,0xe17dc4bf,0x6ee35e19,0x8b7946b3,
	0x2dcf0571,0xd18f0691,0x64577a07,0xbbcfbe4b,0xee358bbf,0x31293533,0x811f769b,0xe6379395,
	0x51cb13a3,0x6a895aeb,0xcb6fd247,0xdc656a7b,0x21d52251,0x4b15f885,0x05dd7641,0x4fb1e7ed,
	0x44818643,0xe45d6259,0x9869fb89,0x021d1ee5,0x75e32c3d,0x0d133d43,0x197b0fe5,0x97531d65,
	0xa0f71449,0x821b1ba7,0x76e3fae3,0x05a79975,0xd89f66bd,0xa7773a75,0xbedb42dd,0xa711be29,
	0xf0aba931,0xe9555e1f,0x890371f1,0xea371897,0xb6cd138b,0xbd0fcfa5,0xff63fb07,0xa35fa4e1,
	0xcba104f5,0x421f798b,0x87693ecd,0xfd7dfb31,0x1bab98e1,0x832f24dd,0x0aefb0bb,0x0b2d9cb7,
	0xf8595c0d,0x5709d633,0xe1371c11,0xf7af60af,0xd0ff2179,0xe1a94aa7,0x57e708d5,0xd7ed0157,
	0x8bd9f773,0xb52794e3,0xdc0f40d5,0x1b7bc8fb,0x7f0b3c8d,0x92cfda0f,0xc32774ab,0x9d915eeb,
	0x099fd4a3,0xcc0b2ee3,0xb41300b5,0x5615b47f,0xcc8d7dd7,0x4371949b,0xb017d21b,0xaa8d1219,
	0x83b14597,0x0dc315ff,0xbbe56bcb,0x5f2d4425,0x7ecb1d93,0xb2e50459,0x28950b7d,0x27d1e80f,
	0xba8d90c7,0x0ee55481,0x7ca7eeb1,0xd8f7d955,0x99879877,0xd2fb1bd1,0xfd05b7ad,0x38cfbe77,
	0x3d37912d,0xa6832d31,0xd5fbf27f,0x7025b5fd,0x7f014fbf,0xe805d60d,0xe447ba03,0x1b792379,
	0x892f5645,0x0e2dbb5b,0x1e057cd3,0xfbe99c83,0x0ffb2925,0xa8d3d697,0x9bbde259,0x4841f5bf,
	0x2a7bc409,0x01f792c9,0x4163cfc3,0x9df36fd3,0xcbb72ee3,0x5ebb097b,0x074d8d09,0x921b0473,
	0xdb9932f1,0xe0715fc3,0xe33b09e9,0xe277d359,0xeff92fb5,0x058d433f,0x515542ed,0x4675af41,
	0xa58f0ff9,0xcaad8715,0x7d2bc663,0xe027cafb,0x99015ed1,0x6b99e0f1,0x0ab75961,0x4d458653,
	0xffdb7c99,0xc43fc607,0x7f59bcc7,0x58355b25,0xe191f3f3,0x51b56817,0x4ad7923d,0x48fdea51,
	0xf081eecb,0xd337d265,0x70656131,0xd65128bf,0x02edcb55,0x8b2f26bf,0xcf97bbdb,0xb68bac65,
	0x2c01d10b,0x2029fa79,0x0d6f843b,0xd0ad1937,0x74d505b3,0x1dddd371,0x1d575117,0x0d63ae39,
	0x35612253,0x1627c50d,0x6a1df2ff,0xc7fff275,0x0d8ba843,0x620d2d37,0x9efb1949,0xdf7981f9,
	0x7e1f161b,0x82bf9169,0x108f1715,0x6775fae1,0x21d33cc1,0x22939b9d,0xc5e3c84b,0xf93d0a4f,
	0x863fb45f,0xb6073757,0x21679699,0xa4c39969,0xa4ed7167,0xbcc3cea9,0x29f39e77,0x81a11a61,
	0xfc437997,0xa291a725,0x73c7f425,0xe01bf573,0x489bb8f1,0x406b5ee9,0xa98d08a9,0x1a1915df,
	0xdd2df6bf,0xfd6d8999,0xb5532ed3,0x042d96eb,0x9d1fea95,0x8fdf6d63,0x89914039,0xfe9390ed,
	0x947f714f,0x5e2fdfff,0x8a29623b,0xa62d063b,0x313de211,0x7ff143a5,0x9563eb01,0x2585f039,
	0x1c398343,0x5ee7a41f,0xaced6679,0x25cd6c4d,0xb2371f9b,0xf7f3f3b7,0x3ee3bb5b,0x5fdf08eb,
	0x1ce1bb13,0xbc276845,0x0ec37027,0xcd3d328b,0x0bcb67ef,0x11b7f823,0xbe751023,0x7913c0af,
	0x0d753bbb,0x7503f739,0xf749b05f,0xf133a2df,0x883f6449,0x398fd3f5,0x32f994b1,0x5715adad,
	0x53795cb3,0xeb0bf449,0x24a5f4b9,0x10db87b3,0xf055425f,0x4e4db2b3,0xc1d3e0df,0x1a53b691,
	0x62ef49f7,0x02537b39,0xeb774751,0xf5edcbef,0xab4b546f,0xc143086b,0xb6e51909,0x3dc3b281,
	0xde57a3ff,0x416bc059,0x56df8ec1,0xd4971b01,0xdee7b12f,0xb64331a3,0xa48f8e05,0xb6d5092d,
	0xb6b71fc7,0xf167b06f,0x48832e23,0x6b8d80cf,0x8f69d3dd,0x239f1369,0x83b55d31,0x157b52b9,
	0x4b8d26c9,0x3dd790c7,0x9883a511,0x240109c5,0xbf953c2f,0xf229bb45,0xd3b71067,0xa429f7d3,
	0x8add76fd,0x54cf9f29,0x35812fa3,0x31a362cd,0x90ab0e63,0x1d31ff41,0xba793dfd,0x87cdd1a5,
	0x1129c2dd,0x86dfb1e1,0x449f6675,0xb2a77951,0x626db32f,0xd28d1de7,0x245b28d1,0xdfddc9d7,
	0x49735165,0x6719d7b9,0x417fdea1,0xcfbf1b3b,0xf31f77d1,0x928d5e43,0xe441603b,0xe6497a93,
	0x8d3b9e0d,0xeb11f7f9,0x1e43c9bf,0xdc1d96f5,0x7f812dff,0x5001afdb,0xd38d6015,0x0f83ce85,
	0x4487f8d1,0x8ad9726d,0x638f95ed,0x75715b69,0xe2d5cbf7,0x903f4abd,0xf21f30bb,0x2a7fa0d5,
	0x05d5262b,0x6101bf5f,0x50818dc1,0xa3ef97ff,0xb6dd0c6f,0x8b154f71,0x865b0705,0x80ab5d2d,
	0xb629ff13,0x4a9b0f97,0xfabf7857,0xfa47dca5,0x73dd0ea5,0x4ad96701,0x3d23e44d,0xf5fd9fb9,
	0xa9051103,0x073bec61,0x6e673947,0xb5afb9c1,0x9095f651,0xcc5962f7,0x49d5366f,0x28e5d521,
	0xc06b3df7,0x58f1d787,0xce1f70af,0xddd5603f,0xa2498bab,0x1ee9dd5d,0x865977c1,0x9255da8f,
	0x8cdd5c69,0x2451eb51,0x73051b25,0x64eb418b,0x7cb9db71,0x845dd8bf,0x930dcf21,0xa5c19daf,
	0x6d5bd751,0x906b7a8b,0x0cbf31c5,0x47a7af8b,0x5227d6db,0x91036023,0xf6d5afe7,0xf117bcab,
	0xaf694e29,0x26d1b07d,0xc16d4a29,0xad377ca9,0xd357f3a1,0x4baf2717,0x3f1179ef,0x3ccd2629,
	0xaf0934ed,0xf39930f3,0x4db13669,0x074f9bd3,0x4f87cc01,0x4db329a3,0x1fa51991,0xabd3b959,
	0xf6bd7417,0xa54fb837,0x24ada521,0x321fc071,0xd47fbeb3,0xe2e14c4f,0x92f1a7a7,0xdb9de5df,
	0x5f87089f,0xad09bb11,0x9003c16b,0x945bfe6d,0x4e7b8eef,0x298bfc2b,0xf9d9098b,0x04194be9,
	0x30e7a401,0x5e5706cd,0xcfd5d2e1,0x3f356a2f,0xa8410473,0x3283cebb,0x3bbf9117,0x17bd5c1f,
	0x40e34c35,0x0f4d6135,0x3ac5dd9d,0x0e5fb8a3,0xeb118b77,0x211b220b,0xe6839ca7,0xe379f7ad,
	0x13f9fbb5,0x387d2891,0x5df74237,0xc809df35,0x5eafd4b5,0x4b25bca7,0x4e893713,0x2ebf103b,
	0xfd2d417f,0x94f5f3ad,0x1d095dcb,0x3ce7b3cb,0xa9597567,0x58f36d95,0xaeb1b7b7,0xdb8147f3,
	0x3e01e107,0x424d31d3,0xd22129f3,0x682b8cd1,0xefd58745,0x6557ac63,0x485f6269,0x06319181,
	0x2677724b,0xe091cacb,0x6ddddcc9,0x8f87e131,0xf565488d,0x1da33919,0x83730787,0x25c3d00f,
	0x350f01c5,0xb257bee1,0x976388e5,0x632be855,0x3bc9bbf7,0xe1a7bc41,0x0e51a3e9,0x2ba77743,
	0x36cdb06d,0xbcb1c6df,0xcc51bd63,0x1dcb3a25,0x234348bd,0xe3b966e5,0xfddb00e9,0xa3cf2b4b,
	0x673553bf,0xe72ff40d,0x80cd25dd,0xa4976f0f,0x0a955a99,0x48a99291,0xed715463,0xd4ad60d1,
	0x904515b3,0x1be35037,0x3f772a6d,0xa743bff9,0x6f0301c5,0x47c7614b,0x1ef7e0af,0xdf35fcfb,
	0x2a7f14c5,0x67617da5,0xc9718fab,0xc001a651,0x0c4d92fb,0x4ae95da1,0x9acd94a7,0xded5f579,
	0x7ce903ed,0x18bb5723,0x365d16b3,0x93837bfd,0xfcb74773,0x0e5d1a9b,0x4fd7aba7,0x0983f06f,
	0xbd01caa7,0xe1818ffb,0x145d1d1f,0xf0f91b69,0xd8ffdceb,0xc0f9d3c1,0x33774d85,0xcfafe48b,
	0x2ecd24ed,0xf5c553f5,0x88133d09,0xf2177f7f,0xd86d359b,0x240b0d21,0x618d2e9f,0xfc4db8f7,
	0x44cb4335,0x2c1be75d,0x6ca3ed09,0x1b0f63a9,0xf0bdf83d,0xab693345,0x3c7d2fcf,0xd4cbe559,
	0xbfff6a7f,0x1d9346fd,0x73ab203d,0x7a93e3d1,0xf635300b,0x9d613b33,0x8d27fe6b,0x391f11df,
	0xcfeb9441,0x45c1c81d,0x454fe63b,0xc9d31c61,0xbb95ecbf,0x32c74279,0xa2efb451,0xc3b9b733,
	0x328f0e75,0x22b5b889,0xa0330b1f,0x8c83ca41,0x321fe293,0xb6ed2f1d,0x73b577d9,0xe98bbe7d,
	0x54711b97,0x5501fe8b,0x7975b781,0x30d3eadf,0x89970a41,0xa7a54fad,0xbbdd1bdd,0x1a072167,
	0x708f929f,0xbfb9b8eb,0x1cbb107d,0x2f795c21,0x503d4103,0xd543fb31,0x1e49bfb9,0xdf218a1d,
	0xb06d7f09,0xa86fdef5,0x4c25d7ad,0x2ba37c73,0x92d3e893,0x82953133,0x44596f45,0xfd47f347,
	0x4c0dc0cf,0xd733e071,0x60550b2b,0x1303cac1,0xfc9d872b,0x84ef39bd,0xfdefc2db,0x936f4811,
	0xa9f1ac69,0xb69745ab,0x686b8591,0x3dcf8671,0xf75b6787,0x64234559,0x61717f55,0x3b090421,
	0x7f19aad1,0x73af4f6d,0x4a0d9df7,0x8eb54f6f,0xcb5138dd,0x7a830d13,0xebbd360f,0x2809d3a7,
	0xef0bd983,0x1e0b96ff,0xe15bc7f9,0x92e9c623,0xbf3daee9,0x14df7271,0xa035e4e1,0x48dd3347,
	0xabc5aa79,0xc7bfae2d,0x20f933b1,0xa21b2b7b,0x386521e5,0x928d1f81,0x28bd9625,0x667b102f,
	0x15cb842b,0xa55bbf41,0x32056db9,0xfe7f00df,0xda8b2e8b,0x855d26cb,0xf5b700b5,0x44536809,
	0x5c1f6193,0x2df32d03,0x9423ff2b,0xf4c7a837,0xa7ed5615,0xd1a1a359,0x5e0327ed,0xc057e8fd,
	0x9c43722d,0x3b1732bf,0x3d750d9f,0xfc2503f1,0x21519e3d,0xce2b58b5,0xbf05fba5,0xf2f991b5,
	0x0237b9f3,0x28d9843f,0xba9ffb31,0xd64916f3,0x65f9313f,0x644b52e9,0x9c9df837,0x4f2d515d,
	0xe881b15d,0xf5cdedcb,0x4ebf0679,0xaf67a4a9,0x53a3fdd1,0x2fd78681,0xc12fc67f,0xc263a79d,
	0xf81fe565,0x6305f42f,0x137bea95,0x3e31d0fd,0xa695572f,0x9f1d7085,0x5d9bdbd5,0xd48d449f,
	0x48959789,0x141174b5,0x18f17f1b,0xe3d7c059,0x19919513,0x12f3b67d,0x29451a13,0xc81da90f,
	0x7fe55dbd,0xaf034525,0x85c75827,0xcc0d37a7,0x85d5b3b9,0xfea7c677,0x820f6f93,0xba05c615,
	0xf291c27f,0xfc6fd3cb,0xb71d6653,0x0d053c51,0x0327f3d7,0x080f76fb,0x8c59772f,0xc1b99d5d,
	0xc399e4c9,0x0765c76f,0x609596b9,0xc771b441,0x07c97aa9,0x2779a713,0x53071843,0x1127e10f,
	0x04831813,0x3d799f5d,0xac5172f1,0x468105df,0x8879f1e9,0xc7b9de4b,0xe77926a7,0x14c593d5,
	0xd54d8459,0x8ebb535f,0x5af3c117,0x1fe9b819,0x187d27d3,0xe623eca9,0x819302b7,0x9385a8db,
	0x847bc613,0x8dbff3bd,0xe39d23c5,0x53db1255,0x0997af1d,0x32858abb,0x9fb73949,0xced5a3c9,
	0xaf0f8e3d,0x8f954943,0x93f1ba15,0x6d07bc7f,0x8c057f05,0x2f33f987,0x26c523bb,0xa2ab38c9,
	0x6089424f,0xcbcf753b,0xb013bf9f,0xa0a15f01,0xce8d9341,0x50ffa29b,0x822187e5,0xa575ec87,
	0x32ef9c45,0x7c81916d,0x92a12c7f,0xee5b42c5,0x1e718c0d,0x1f3bb7ff,0xc3ab3823,0x4829b42d,
	0x6ebf4a97,0xfe3d5025,0xccbf554f,0x4065f135,0x076f4e25,0x53b9d43d,0xc3c7b34d,0xf6399561,
	0x2afd9041,0xf0139c2d,0x46118b29,0x8b73d43b,0x73cda2bf,0xfacb9a61,0x4155c4bd,0x35934651,
	0x6d2be4bb,0x539538cd,0x5cb5bba5,0xeeb7d63f,0xcc4bd799,0x934355f1,0x01b9244d,0xc6abcda7,
	0x494b9401,0xacd761d1,0x055110df,0xd3e3022f,0x182d5ee9,0x2e739af9,0xf0d51657,0xc475228b,
	0x01df5e8b,0x22696b81,0xeb059171,0x0f272371,0x1d336f6b,0x902de605,0x41090bb7,0xc461cca7,
	0x27e71955,0x9d5f62ab,0x8f73c075,0xff3765f3,0x7f9fa45b,0x4ec33c1d,0x8b3941c5,0xf6618427,
	0xbae74dd7,0xe949ac93,0x6abd3d85,0xad45f61b,0xe2359d6f,0xf307cacb,0xeec5625b,0x44e9d1b3,
	0x48e3da0d,0xd439a709,0x0b8564b9,0xed01a0d5,0x06359ee5,0x18498819,0x319123d5,0x74e7ae75,
	0x0e579071,0x4ec34853,0x36edeead,0x7c9f738b,0xeb613173,0x8c5fd291,0xdfffe90b,0x45d12419,
	0x164bd7fb,0x8bf9bf3b,0x0897907b,0x24d15c27,0xeffdc257,0x6f99113f,0x6cef6157,0x9197ecc7,
	0x5a3f4c25,0x216b130f,0x12a59bbd,0xd8c7c913,0xf0c74349,0x54c753a9,0x51c32893,0x6cad132b,
	0xe2335ceb,0x272bc395,0x7db99e8b,0xd6374937,0x6907ca81,0x613ff1dd,0x2e5f671b,0x4601926d,
	0xe4adeec7,0x57cd6917,0x28f70381,0xc54f2c01,0x927932bd,0x6ccf2c63,0xe92571c7,0x0709f637,
	0xe6abfaaf,0x30635463,0xc9fdb1b9,0xd8c12159,0x8563bb33,0x21cdcc45,0xcef769f1,0x33b3fab5,
	0xdbb12e23,0x107b2ebf,0x0cf1accd,0xedc1d9a7,0x5885a7a1,0x1d07c30d,0xb335dd73,0x0a752c8f,
	0x45bf8b19,0x5a2d99f5,0xb471b4d5,0xac01a5d7,0x4123e03f,0x0dd1cac5,0x0fc166a9,0xa44188f1,
	0x555b080b,0x9205d051,0xb9a3e66d,0xa5b31753,0xb2fd91c5,0xd5ff05f7,0x24ff4c6b,0x14851d83,
	0x09832ff7,0x7f19449d,0x6c275aaf,0x7789a005,0x8055cd71,0xa9df9faf,0x19d12213,0x8937a86f,
	0x4fbdc251,0x4afb4223,0x921fc735,0xe8b33257,0xf9ed28fb,0x30456b75,0x1b97677b,0x6ac73861,
	0x24075317,0xa1bb8cab,0x882d1e17,0x0ae3e133,0x0f095e9b,0xa2838551,0x7e3528ff,0x7c27cc81,
	0xb0e3eac3,0xd1ed007f,0x61732df3,0x5a4f8003,0x6d69ed0f,0xec6bf1d1,0xdc0b9f77,0xfac9f479,
	0x6f57a64d,0xec9f326d,0x079341df,0xdda542af,0xa151b78f,0xcc4f3dfd,0x35fdd03d,0xbe9f7075,
	0x46e3572f,0xe5690fbb,0x5aafc175,0x46195da5,0x3581a5d5,0xf3011f61,0x136d2d2d,0x5a1dd11d,
	0xad872367,0xb2597e35,0x5169d0d3,0x0f5da5cb,0xd33b4419,0x23d31403,0xa23b349f,0x3a33179d,
	0xc7c72569,0x6c01fc23,0x18e3f08f,0x9fa1308d,0x62416319,0x54970271,0xd6cb116d,0xc653559d,
	0x88a50c33,0x6d754051,0x34c19dc5,0x6799f3d5,0x28d7b80d,0xcd9fd9b1,0x8bfd3af1,0x806f4d49,
	0xd1a3bb3f,0x7445da07,0x9f21f20f,0x0277660d,0xebbd7caf,0x49bd3151,0xa3351507,0x24fb1149,
	0x92c3ea85,0xc085d113,0xe8a94387,0x55eb1e1f,0x0e370f37,0x1643e959,0x24559007,0xcae5a4c7,
	0xea85c681,0x34c545bb,0x5877c4c5,0xb2297375,0xb2059263,0x3301ca53,0x5dbdc8cb,0x03a39b6d,
	0x45ef902b,0x761710c9,0x0c3124e5,0xf1e31df9,0xd7698d6b,0x724d2549,0x044fa8ad,0xfb25b967,
	0x807f3cff,0x0c0f6389,0x17f72f81,0x9a4bd615,0x7d258c09,0x98f773c7,0x536f8589,0x97dd935f,
	0x043916f5,0x80bf67c5,0xa66b6cb3,0xfb11f4b1,0xc07dbe77,0x7e4ff7d3,0x2cffc1b7,0x9abf2e7d,
	0xe99f5c89,0x80b7dfc5,0x18afc113,0x4e691339,0xfd31996f,0x2c2b5bfb,0x39616c11,0xbf3ba06b,
	0x17b1e0b3,0xfb09c657,0x26650dbd,0xd905ab99,0xed85762b,0xfed95345,0x0773dff1,0xdb43af53,
	0x63f5aaef,0x4149eebf,0xfdafd04b,0x0a15b837,0xca373265,0xc52f393f,0x2c9d6533,0xff4971e1,
	0xb2699735,0x2787a4cd,0x632fc2d7,0x9b4d53ff,0x6a8dd057,0xe07bb1f1,0x64bdd02f,0x963fef3f,
	0x1591f601,0x24574cc7,0xd2077bfb,0xb0df5a5b,0x644916bb,0x649349e7,0xb23721bf,0x8597bf15,
	0xee6f2c4d,0x70c90377,0x9bdb0ecf,0xf97b0735,0x2bab30cb,0x37c51627,0x7deb273f,0x4d45a98d,
	0x0c85538f,0x28713e2b,0x08c9aaef,0xce5796f5,0x33754e41,0x32e5543d,0xb73d1a87,0x27b94751,
	0xcdd5d9c7,0x695f6aa7,0x77753c75,0x531fe689,0x0ce94357,0x41450a35,0xf40d41f1,0x29e5a18d,
	0x3edf216b,0x74278f3b,0x7d030bf9,0x960b1357,0x87cb28c7,0x80b7a697,0x90bf9057,0x633bd1eb,
	0x3aa72175,0xcbd9eaad,0x05135e97,0xafc91b4d,0xd25bfbcb,0x618fa06d,0xd0354513,0xfdafa291,
	0x8ab10561,0x56079449,0x71c515eb,0xe38d7cd1,0x995b3e1d,0xc69b1741,0xfbcf8c01,0x5db12e2d,
	0x06f9cd27,0x7ac51bd9,0xbbbf5009,0xbf09d6cf,0x280f95f7,0x252f731d,0x83711d79,0x42337fe9,
	0xb607ed43,0x44a329a5,0x92210791,0x3a6d88b1,0x88376e13,0xa51d048b,0x1d7bde57,0xe4a7336d,
	0xecdbeeaf,0x80b51e77,0x7a8db399,0xd86f5261,0xa21795ab,0x40b7a497,0xe6d17ff1,0x18ff14e3,
	0x6ef50ee3,0xde8db39d,0xf125e7bf,0xc63bf449,0x5c6de079,0xe4cd54c7,0x82d32025,0x6dafc0f7,
	0x8e5bdfd9,0x10399add,0x888bf417,0xfb89cf53,0xbc7fc6b7,0x90b5df29,0x3b65e94d,0x4ba544d1,
	0x4b8be80d,0xea511e83,0x09e18541,0x5a8784e9,0x060f051f,0x763f7645,0x20e9b23f,0x1657be1b,
	0x75874279,0x83e1c157,0x94cb4455,0xcfe996f3,0xdb5b3ced,0x19bd5525,0x2a3f9e59,0x4bb5fb01,
	0xc9d53e95,0x567fdea5,0xbf6776eb,0x72e107dd,0x5d2993d7,0x72015f53,0x54cbbd73,0xa4331a2b,
	0x1475005d,0x5e3d4a35,0xb6599f1f,0xa51ffa93,0x4abb5419,0x085bc0d9,0xc46dabe7,0x32bf2ac5,
	0x4fe72049,0x39abf055,0x5cc51b8b,0x32d7527b,0x21cf8c6d,0x18a18e43,0xe389328f,0x84cfcc77,
	0xc52f4b53,0x49db75cb,0x6c49c747,0x72bb5381,0x3eabb00d,0xb1216497,0x82ffe6c7,0xc253cf6b,
	0x2bcfe2f7,0xd261d7e1,0x950b99ef,0x65fb420f,0xfc1136b5,0xd2b10963,0xfa35ca67,0xcdbdd44d,
	0xc9c99d2f,0x194f0c63,0x9dab479d,0xd84b030f,0xd33f3c9b,0x909f0aaf,0x4707ebc9,0x63ffec45,
	0x939f2473,0x8733a19b,0x834be0eb,0x7fddbbeb,0x7bfb227b,0x30c15f05,0x2ddb05c9,0x3c8d38ff,
	0x4c53b7bf,0xc7255e53,0x998d72f3,0x1d63728b,0x0c872d91,0x4b65056f,0x59931fbf,0x29578ca3,
	0xa565ca8b,0xe6b1e1d3,0xaa93a74d,0x9c0dad5d,0x19a12793,0xeb5fa579,0x7b912d85,0x36cf09db,
	0x5ed9a4d3,0x75ed43e5,0x16ff6415,0x318f1347,0xd68ffebd,0xae032f29,0x6bb5af75,0xcbe7c3d3,
	0x6731030f,0xa76bb4d7,0xf5f36be5,0x7e190bb7,0x351365c9,0xe31f7b0d,0x4861526b,0xca115e33,
	0xfb6fb63b,0x703b1d6f,0x3511fdd7,0xac615e93,0x056b73f3,0xad07ea2b,0x96798fbf,0xad41ad27,
	0xc71543cf,0xa7f1bef7,0xb87b7583,0x9195d447,0x165d44f1,0x208d0611,0x615f4d4b,0xabe75555,
	0x042385c7,0x289dd33d,0x7ad5eb05,0xcd69d5bd,0x55299901,0x650320c7,0x5af37d69,0xd6f56bed,
	0x9b1d4a9b,0xeed12c87,0xad3dd2f7,0xea0d0c5f,0xed9374d9,0xd43bf4d7,0xfb99bef5,0x39dd1693,
	0x4307f547,0x39a1d59f,0xd7599e73,0x7c350217,0x69dbc1b5,0x1a87454b,0xa233fd47,0xfa912b77,
	0xa15f1d43,0xaa9db1d1,0xf7475b11,0x4313c14d,0xd2c3ed51,0x56b97daf,0xb4211039,0x7985d13d,
	0x6a272e8b,0x65d91ce7,0xa1ad52ef,0x485974ef,0xcf8f89e3,0x3a235209,0xbd455c27,0x71a91f13,
	0x7fe50997,0x31e58b2b,0x21abaca3,0x00370863,0xc5ffee29,0x28975ee7,0x900371e9,0x186fbca1,
	0x1397a363,0x97d52965,0x98e10b47,0x6961c795,0xfa55d559,0x5867c951,0x653daed9,0x3dc98213,
	0xc4c3a567,0x03397ce1,0x1f752e79,0x2d07fef1,0xaf55ff31,0xf265ded1,0xfc53dcd1,0x6c291811,
	0xc1670d9f,0xe2250367,0xe407924f,0xbedf9b5d,0x463fcfe7,0x31e1b571,0xbb29d22b,0x088397c5,
	0xe607ce85,0xc529d343,0x4bb90f65,0x7d17ca45,0x5ed5f039,0x84b1cbbb,0xce2111c3,0x72472adb,
	0xdda56f11,0x7f573b3f,0x122d7ad5,0xd0639993,0xf759ed5d,0xab25a8bb,0x481b6af1,0x2367ab7b,
	0x41c1aabd,0x464362a3,0x69874639,0x4bf397b1,0x8c8fd911,0xd80d7bf7,0x42799991,0xd0554451,
	0xba611185,0xd1ffe93b,0x1a651fa9,0xcd7b7387,0x39b9e98b,0xd0bfbd7d,0xfd21e5f9,0x88031085,
	0x1e03a7e1,0x7d1b8751,0xa3eb91c1,0x9d2d9c83,0xd8951989,0x0d09cdd5,0xfe6fc507,0xd3e5bbc1,
	0x91ab86cd,0x64a9adad,0x5bbda39b,0x8dbbe28b,0x2169c843,0xd7419609,0x334b7813,0xd7eb2231,
	0xa8db7bc3,0x883d259b,0x8df978d1,0x1c55160d,0xcaf55971,0x6c3527a3,0x0f13acf9,0x7287f07d,
	0x8595a8bb,0xe9e7b0e5,0x9d45f17b,0x90afa7ef,0xaa7dd551,0x1b395cad,0xaba91e0f,0x5cab43d1,
	0xf859242f,0xae3ba9d3,0x22c14a35,0x1cfb499d,0xd3c1889b,0x662177b1,0xe9713233,0x49c949d5,
	0xa02d991b,0x3c49a331,0x0e0dbc19,0xfde98d01,0xb903a487,0x213bc3bb,0x8f4d9cbd,0x07d5e0b3,
	0x0a8fe6f9,0x5da50847,0xc54f1cc1,0x9aad8485,0x4b05ded3,0x935b3453,0x6a9dfd89,0x9f3f3717,
	0xd383c1c1,0x5e5fbce1,0x45277e45,0xa4f96313,0x190b11b7,0x95d30581,0x6f4580ef,0x72f96c29,
	0xc58b51ef,0x2d09bd49,0x40b7cf43,0x38ff1c13,0x70d5dbeb,0xb4755bd3,0xd7a77fc9,0x60752f93,
	0xf9a9d47b,0x7ab7be47,0x41a17ad1,0xfd6f0373,0x7ea740ad,0x4d93e451,0x44a31f71,0xdfa76181,
	0xf75d3adf,0xdaf9cd27,0xc8070889,0x437d6d99,0x6d4147b5,0xb1ff7487,0xdd9bf1c1,0x22fdb29d,
	0xd4adcb17,0xe3e3efb3,0x6a8dbc89,0x26db4f73,0x85e59d3d,0x450baa7b,0x70739515,0x376d440d,
	0x5617bf9d,0x4e07c433,0xf6513767,0xadb9de67,0x505531fd,0x9c898cbb,0x918d5445,0x2467477f,
	0x0e9fe769,0x14732173,0x8ef7163f,0xe8cb3061,0xb2d5db33,0xa0cb2a4d,0xbbc9c6ad,0x0bdd9f1d,
	0x7fc745f7,0x94bfb6bd,0xcea392ab,0x1343dbcb,0x1225f297,0xaca33abf,0x708b7023,0x4a437d8f,
	0x398fb33f,0xaef7abd9,0xe5f322c5,0xb2d1978f,0x7189f663,0xad63be19,0x57b56105,0x968905ff,
	0xfa7d7bbd,0xe5b14113,0xbc0d1925,0xb7a9db17,0x92c12951,0x42db9ce5,0x5fa7d62b,0x221fec19,
	0xcf8f0069,0x7dff6f35,0x0e9144e7,0x9c7d7e4d,0x160f329b,0xdf61482d,0xdd43d8f1,0xb8fb1405,
	0x344956bf,0x9f718787,0x91a191a5,0x867f5999,0x9a35bdf9,0xe7c5597d,0xabefdf2d,0xe18f326d,
	0x32ade8b7,0x7419d3d3,0x0fdda779,0x655fe5e9,0xdc771ba9,0xd35732db,0x4d876b3d,0xfcc96c7d,
	0x833d14cd,0x488b3667,0x8a6b8afb,0x1351dca3,0xd895e063,0x4bed9ed5,0x0a73abf9,0x661ff7dd,
	0xacfbcdf9,0xabd9ca09,0x58eb3d47,0x7507d7b3,0xe8d18561,0x4dd57071,0x11911cbd,0x9381bab9,
	0x25673bb7,0x8f938205,0x497f5bf7,0x99b1f185,0xe5ef085d,0x47e5233d,0x98432561,0x3561ebb9,
	0x708759ff,0x67cbca23,0xc0cbc125,0xdb0364ff,0x472f8b91,0x3b6b7b41,0xfa6dba3f,0x56b1b207,
	0x40d9994d,0x4b1526af,0xd9ed236b,0xfd2f2d8d,0x4255f5b7,0xdc3d2509,0xda71fc31,0x7ce5c54f,
	0x97617e99,0x1281d473,0x8689b5e1,0x4ee5a717,0xeba19209,0xb0a9559b,0x412fd891,0xc7eb0db9,
	0xe39f435f,0x79a368b7,0xaec3c823,0xc9592e0b,0x55d5b041,0x31836a83,0xbe0ba93b,0x123943ef,
	0x23997599,0x3e8b7147,0x5139664b,0x303dbf51,0xb2334499,0xea1d89cd,0x86e5d487,0x10bf911d,
	0x03cf97bf,0x41cb146b,0xa311f8f1,0x31c39851,0x707f87cb,0x98494201,0x98216d4f,0x72f12eed,
	0xff41c0cb,0xa677b0f1,0x2fe9e533,0x869bd6f9,0x5ef99711,0x4c5b2a29,0xd4a1d2ef,0x02bd0785,
	0x7f733c39,0xf2217e1d,0xf9e72ca7,0x11f919af,0xca631425,0x892181cf,0x25c5513f,0xc4995595,
	0xfc672a01,0x2cd92bbf,0x99ab0d69,0x018f1f5f,0x9e01c541,0x63efd0fd,0x9b71c099,0x17754441,
	0x1c9f1e9f,0x0131821d,0x5e57a211,0xed8d6773,0x8393351f,0xa497883d,0x8c0525d7,0xd4c38f37,
	0xd51bc30d,0xdc3d0203,0x6d8d81bd,0xf8a7d1d5,0x035b52f9,0xe56ba09b,0xb4655255,0x7075229f,
	0x896174c3,0x0d8d84b9,0xe36f6003,0xf00f3eef,0xa41d1289,0xb33b3b9d,0x57f183eb,0x18ffbb25,
	0x2b6fe5bb,0xe735dc0b,0xf29facff,0x6b772fab,0x0b190c0b,0xad5d4351,0x608d04f3,0xd75185f1,
	0x5bc9bc71,0xddc57243,0x043f3549,0xed0f6571,0x1c131c35,0xa5a10a3f,0x7e9bcc49,0xaedbc0ad,
	0x897133df,0xa851ea29,0xd7f1c1ff,0x018b822f,0x19490443,0xc059eb71,0x48fb1d43,0xbd955985,
	0x11e9bb7d,0x6069bf09,0xa3d9b8b7,0x601ba84b,0xc38109ef,0x9457ea71,0x5d1127bf,0x5beb8f21,
	0x61319745,0xa21fe4ad,0x3495bb8d,0x0a751ab1,0x79fd9773,0x4aeb5349,0x7ebda815,0x3cd190ad,
	0x11cf7fb3,0xac07675d,0x0d4b491b,0x6cc7dccd,0x5a7bdb8b,0xbfeb5a85,0xb8638721,0x8dbb1dd1,
	0x0cc141c1,0x7f330be5,0x87995c79,0x7dc35285,0x6141696d,0xa1a5bd2b,0x7ae57a3b,0x169926b7,
	0xa98b5ee7,0xff33ef8f,0xf3a50d43,0xde9fe045,0x8911d8d5,0x90ef60c9,0xbda3a33d,0x59dd6c0b,
	0xce2fad21,0x12192823,0xb80f2f93,0xfb098af7,0xeb2965fd,0x4117f367,0x1e7f3081,0xb47b1ef5,
	0x0f2df6e7,0xc07963ed,0x71f7f403,0x29359803,0xdf4f91a1,0x97f38b8f,0x01dffce3,0x7de18121,
	0xcf8b9b35,0x556389b5,0x150387ad,0xc9d32d57,0x1bc5c0f7,0xcdd1484b,0xb29f2fb9,0x280584b7,
	0x60c72d83,0x7e6b58c7,0x0b53b429,0x6819f15b,0xd549ddbb,0x8d85f125,0x8227dce3,0x5f576c61,
	0x22e515cb,0x6ba108ed,0x55897f93,0xd9b3aaf7,0xdf21f627,0x14639629,0xe855a4b5,0x2ac96b4b,
	0xa467308b,0xef99ea6f,0xaac7cc85,0x5ed9e197,0xcb0ddcf7,0x52392fdd,0xa38b540d,0x0bcf451d,
	0xc24f6eb7,0x9f630619,0x98b1fa19,0xc2397d25,0x0951c961,0x095b3f4f,0xd8ad8441,0x1e57ee03,
	0xc81f75cf,0xf291bd35,0xa36583e7,0x7909660d,0x08adf723,0xee9b6e07,0x331d3b31,0x38d72aa5,
	0x8fd93fc7,0x6337698b,0x6587a20b,0xc2f52535,0x56634673,0xc94b2e0f,0x04bb8b31,0x0c3f302d,
	0xa1fdbb1f,0x8de7fd67,0xb03be91f,0xca358407,0xbe37dc0d,0x933d59f1,0x65eb331f,0x44014447,
	0x558f6acb,0x51b1a393,0xab1fea3d,0xc3772c71,0x6a69c12d,0x98c3d4b7,0x558f3e53,0xa60f5d1b,
	0xf011064b,0xf0275f57,0xf459d2fd,0x0def48db,0x03bb8389,0x98af29ed,0xd907a4a7,0x32ddc153,
	0xc5851995,0x2d5dac7f,0xc0870d7d,0x534d242d,0xd171d55f,0xe4532d99,0x1c35ea75,0x455ba81b,
	0x586ba523,0x6fe31f53,0xfacfe053,0xa7c7c9d5,0xd94b2d65,0x7f819c49,0x917dc099,0xb2fbd91b,
	0x79c9bdf1,0xe0cd049f,0x64d10e99,0xaa0ba5b9,0xff8b66d9,0x408bbb05,0x11c1a46b,0xebaf4c7f,
	0x691d2d77,0x8bab01ad,0xb6af77ed,0xa34b2445,0x26f56171,0xf043f757,0xfc617fc5,0x19e9caef,
	0xf46b11b1,0x7e8fb447,0xbf0bb865,0xa73d5265,0x50c7a16b,0x69f98749,0x57414903,0x429d8d95,
	0x98357d17,0xea0d52b5,0x8307c89d,0xb40f7d7f,0xbcc9ef7d,0xbb830965,0xeec3a2fd,0x653bde1d,
	0x9f7d16a5,0x41374bc1,0x5e459daf,0xd273d37d,0x0937f8e5,0x453124b7,0x75c77d0d,0x9bb5b6b1,
	0x43c5b9d5,0x599de6b9,0x22e7c935,0x359f02cd,0x52d7ef59,0xd9d328c5,0xa5b1b30d,0x3a7d61f7,
	0xcd0d169f,0x8b51e363,0x39911947,0x5b41da57,0x54e92917,0xdebfad9d,0x5e61ad59,0xf0851b1d,
	0xb1d9517d,0xd0e71a09,0xc1613881,0x2b8de983,0x8931c0d5,0x6bc333c7,0xc63b00c9,0xe741adcd,
	0xb72ba36b,0xe7711b79,0xaffb4dfd,0x1935203f,0x47ef35d1,0x6b35c44d,0x6a1f0eb7,0xe2a1162d,
	0x1085f9e3,0x6e7dd0f7,0xf1839d55,0x41696ef1,0xe7e50bc3,0xb9e390b9,0x5d71a4fd,0x611720eb,
	0x7fe996dd,0x08231c53,0x889926a1,0x8bdd6685,0xde576ae3,0x47219315,0x5a119df7,0xbb950b31,
	0x75d9b0d3,0x78ef77d3,0xae5d467d,0xcac3d867,0xdf03bfef,0x34c32deb,0xe065807d,0x458f22a7,
	0x315512c1,0xc7f79643,0xf2755603,0xdacb767d,0xfc315c1f,0xf717cc47,0x57491fe9,0x6cf36577,
	0xdfe1bc21,0x5ecd02ed,0x5b014acd,0xc3297333,0xc69d152b,0x74f181b1,0x2c233c17,0xda37224d,
	0xbd7f80eb,0x2981c199,0x84a356f3,0xd58f2171,0x6d8de551,0x27a3aa31,0xf2d5215d,0x904b9851,
	0x34b1a999,0xb6a7ee91,0xc27d8913,0xce2f94a5,0xdec18b49,0x3aff8a55,0x85c14899,0x0ca1972f,
	0xfe799327,0x574f5ea3,0x3e316c43,0xf3b940b7,0xe67d2a4b,0xad57ef25,0x25c7f725,0x672d1f0f,
	0x42594f0f,0x3f0b3f15,0x17e1a81d,0x37619a0f,0x4f81ea15,0x6f7dce2d,0x9a49ded7,0x725d009b,
	0xb6514349,0xa3efb5b1,0x862fa0bf,0x54d7b599,0x030f96df,0x84c3e573,0x512bbe0d,0xdb277cff,
	0xbee5ca51,0xde8b80c5,0xf63f16bf,0xf251e8c1,0x28e94163,0x22fb5b83,0x7ecfff9f,0x48fbe5e3,
	0x8f17d31f,0x89f39717,0x2bafc739,0xc07d696d,0x4753ded9,0xd2775f69,0x3e155ae7,0x7dcd3d71,
	0x4869812f,0xa3b7c7f1,0x60a50bc7,0x9a8dee09,0x630de8ff,0x8e09c8ad,0xb06173c1,0x760bd655,
	0x1addcc79,0xabeb5b21,0x65bf7a83,0xa6374d7f,0x1f5bfe0d,0xe303b759,0x1d957a85,0x88abf3b7,
	0x64f32179,0xc51fb0eb,0xc2238605,0x73a91f39,0xddfb80bd,0x113533f7,0x1411cc0d,0x871d6943,
	0xd3b10127,0xd465e21f,0xd36f1d69,0x1d975b1f,0xdf353849,0x2af5cf91,0x88b791b3,0xdd533b21,
	0x8295a0ff,0xa1516003,0xedc94c49,0x6931f99f,0x61c5f06b,0x351343b1,0xf6ed6153,0xb1bf3dfb,
	0x1ba38af9,0xf5f59463,0x7bd1dabf,0xe62d939f,0xc2f1195d,0x46df1263,0x808fdd45,0x0553b6fd,
	0xf75d3d91,0xbee18187,0x1ea9ed63,0x0eb9028d,0x9e7967d7,0xaa2f262f,0x0e055463,0xd383fbcf,
	0x3cc3cbbf,0x2b27623b,0xcdf3a553,0x6787004f,0xee9f7517,0xfb51721d,0x6e2d6207,0x323f129d,
	0x015b7cff,0xcc5b49c9,0xf7d1c023,0x9fcdc751,0x2c275ed5,0x491b91bb,0x76698e0d,0x71f9520f,
	0x69236d49,0xb68dc3f9,0xa0e537f3,0xb139b27d,0x6e51674b,0x34db6911,0x229deccd,0x3da3014f,
	0xc69f2d19,0xa0517517,0x8453e35b,0xfffddd3d,0x8ae19533,0x1267c4ab,0xb52bbf21,0xbab1f809,
	0xbad16167,0x02b7b9ed,0x33b91573,0x7acfc37b,0x361553c7,0x080df98f,0xd6f31265,0xa9133e65,
	0x553b63af,0x395347c3,0x373b3dd7,0xbadde1a1,0x22b512c1,0x2ea18549,0xb7596071,0x833bad0f,
	0x33dde1e9,0xa235cc65,0x2d7d88a1,0x23db5497,0x21fde65b,0xb175ade5,0x2c3d2f9f,0x9e1b8d2f,
	0xa33d7e91,0xbdf18e1d,0xeb9d7e69,0x03fb79cb,0x43b3274f,0xee5b21eb,0xd203b2c9,0x4925386f,
	0xbe5970a1,0x4f970bb3,0x9d41a44d,0xb3ed8f23,0xf61712d7,0x95a79865,0x2b8d694b,0xee4bb8fb,
	0x8eb52391,0x7cb99c73,0xe4891be3,0xb6e5530d,0x25eb6aad,0xca2770dd,0xc23bbefb,0x3201697b,
	0x2c53d75b,0xed6b1025,0xfa154347,0xda95a46f,0x5e73150b,0x412f535d,0x45f1ac39,0x13379519,
	0xddb5407b,0xec3f4f17,0xcd0b5511,0x572d22b5,0xe96fbcad,0x6291d06f,0xad0f55d9,0x0b5f1781,
	0x37dd27eb,0x8643fa0d,0x230b085f,0xef61cdc9,0xef2170c9,0x689f011f,0x5479ad39,0x2e6dfcdb,
	0x3e4b0b23,0xab0f0a57,0xb83730c7,0x1063a615,0x964d451b,0x802926f3,0x1f8f1031,0x4acf21d3,
	0x8303bc1d,0x4caf71bb,0x5f315e65,0xf1e34c81,0x2433f1dd,0xe8854bf9,0x9835e91b,0x097bd391,
	0x46870155,0x7fbbba83,0x211d7dd1,0xb617a27b,0x1c9573c9,0x1383e2b9,0x0ecd4ed1,0x0de16fc1,
	0x97d935c5,0x9b3fa77d,0x5d997829,0x89ab69e9,0x61b7ac19,0xc575663d,0xba37a4af,0x15f30489,
	0x747be8e5,0x58d1d3ef,0xeac9d303,0xc3d7e539,0x54590087,0x352dfa0f,0xd7d73a8d,0x1a23f099,
	0xe86f7eaf,0xf48353a3,0x3551507b,0x06497751,0xf3bdfb4f,0x2bfb0a39,0xcb8decc5,0x6d658315,
	0x2e35cf9f,0x4ce552e7,0x604f8f2b,0x5d35439d,0xfda7eb27,0x25b5eb47,0x3fbdc433,0xdd299bab,
	0xced1c8af,0x0309b681,0x6569aa2b,0x5f4dce07,0x0e57834b,0x70a97a3f,0x4549962d,0xd15f4a85,
	0xc1c50b57,0x9a83bbbb,0x34bdd917,0x4dc39af9,0xc08f7b75,0x4dadbcaf,0x7391a491,0x6c7f7049,
	0x8d138d93,0x99659861,0xd4f1100b,0x3447cf5d,0xcd932fe1,0x100f809f,0x08773db9,0xab755e27,
	0x653d39db,0xa83d1abd,0x83259f9b,0x090dd09d,0x2d234145,0x3da5fc99,0x08615c7b,0x85b775c3,
	0x4d438f29,0xb2234997,0xd2fbd4e7,0xccc5e4a3,0x358134dd,0xaebd6fa7,0x5e2d4835,0x0d33c94b,
	0x36ab40fb,0x04a3043d,0xce959985,0xaaa3d1d7,0xbb711463,0xae2bc153,0xfb3d34bf,0x8e5fbb69,
	0x2173d745,0x6fd5a273,0x16951391,0x18597f27,0x32330e13,0x194321a9,0xf775e273,0xb02b9f43,
	0x3c1f4e87,0x66459489,0x021d45a5,0xf61993f9,0xcb8914a3,0x7fd3a92f,0xb1353e2d,0x940b5887,
	0x03b1b7b5,0x1d090345,0xbecfaedb,0xae931839,0x97b77f4f,0x442ff8f3,0xed630145,0xf5edfb5f,
	0x63a9d84d,0xabb36ff1,0x70cdeacb,0x56fb1451,0xa57da9d3,0xbb29da7d,0xf75b5195,0x4c476c73,
	0xd60dca49,0x2c53545b,0x52bb5191,0xcf03312b,0x221d9465,0x4c13dfd7,0xc1056179,0xe80900ed,
	0x835b9c23,0xdb7bc2c9,0xd5b797c7,0xe0dd5831,0x795b83c3,0x90bf038b,0x02bd0fc7,0x14a51e79,
	0x6297f0d1,0x383f0605,0xc1676e87,0x6139534d,0x7577a123,0x757f48a3,0x5b6b87dd,0x380fdb3f,
	0x59439fd3,0x242f415b,0x53e9236b,0x4f4b6ce9,0x5f339a43,0x59255aab,0x706de193,0xf2b59de9,
	0x5b61551d,0x035f1095,0x61e3408b,0xf4c30fed,0x1dd34159,0x2d032da9,0x0da5c145,0x3f8dbda3,
	0x8b73312f,0xdc5f27fd,0x76752c83,0x05d567c7,0x57172d21,0x94eb9e2b,0x4579f7cb,0x94072217,
	0x5a7968ff,0x7843f45b,0xf341ca6b,0xc133005d,0x8f4158d7,0x072f1139,0x90c5227f,0x0015e36b,
	0xa7f9e607,0x829b3afb,0x306919e1,0x100f661b,0x4913c431,0xeca1145d,0xeef14b3b,0x4e2bea4d,
	0xe1f1e643,0xa97bb9a5,0x9c8fd6fb,0xa619c5eb,0x25d1136d,0xc091fda1,0x05db885b,0x23378fe7,
	0x24e59c2b,0xbd73c6a5,0xdcd51a55,0x21858d37,0x053d2f41,0x30d58b8f,0x41e59cb5,0x1eaf3de1,
	0x5bd5cebb,0xd197f0c5,0xecddf909,0x2b0509e9,0x2595e4eb,0x3dbd8533,0xf5f397a7,0xfa830e65,
	0x6047796d,0x5b759f4d,0x3ec924b1,0x95cb0a6b,0x439f8623,0x5a195a13,0x7b67750b,0xab256c1d,
	0x1a396c39,0x5325b209,0xdb3b8b65,0x7f877da7,0xba9b8921,0x8b3fc23d,0x5221bd37,0x7f89b235,
	0xa031eb99,0x53352143,0x8157f7c1,0x706d1305,0xa44d28a3,0x88fd5e39,0x40852509,0x411dcc57,
	0x572d5089,0xb8b79dc3,0xc6bbb0df,0x7b2dda73,0xf8f503df,0xdda95711,0x73732dd9,0x53d7d6a9,
	0x12b1a881,0xc33f30d5,0x378d1a59,0x5cfde457,0xaf55be93,0x0611fe4f,0x9e4fc583,0xd627bddb,
	0x34bd557d,0xb4dddc41,0x766b5447,0x9d8be19d,0xdcafa0f7,0x91896dfd,0x1afbe65d,0xc0ffdf11,
	0xcdd7adf7,0xf2253a55,0x5c7bdb45,0xaf09c3af,0xd4c737c3,0x41e528a5,0x09d73745,0x07d3a7f9,
	0xbcfd9ce7,0x22271dd7,0x195d286d,0x0e2d5c77,0x49dff435,0x2b73b953,0x71c5ab95,0xb89336bb,
	0xcfb541c9,0x4e773211,0x53335159,0x6225fe5f,0x6cb5cc05,0xd507538f,0x602b2323,0x1baffa03,
	0xe1fd9095,0x03259acf,0x469da823,0x9ca51c51,0x0c8fd96b,0x57f37361,0x08e50a4d,0xd41d50f9,
	0xfe59f1c5,0x6ec3945b,0xe6c15b63,0x19dde9b7,0xb72dfb25,0x80097d57,0xe65bf9eb,0xff4f2b49,
	0x7dc9e255,0x8265137d,0xfd411635,0xc083fa79,0xd8d3746b,0xeb9b5e79,0xd96b5757,0x5533a91b,
	0x27d393bf,0x119b6581,0x4a3ba033,0x21c3e305,0xdc3f8cf5,0x2b7b2c53,0x4977f46d,0x483fbb19,
	0x52758bfb,0xf279d031,0xa4537d75,0x9955d841,0x4ab93101,0xe2fbc4eb,0x4465af83,0x2563c26f,
	0x02334585,0x1d9131d5,0x18ab8e97,0x6d674f99,0xebfd9147,0xe7ed6ecd,0x9e911379,0x341130c5,
	0x0a11cf55,0xcdf1a139,0x0ae7b0b3,0xeead9ef9,0xe651c301,0x62a37905,0x12e3f7a3,0xd63b2845,
	0x2b8b6ce7,0xa1310da7,0x55255d63,0x98599cc7,0xde755fe9,0xedefdb1b,0x62b71fdd,0xa8531b9b,
	0x36a93633,0xb75ddee7,0x680b4ac1,0x301d3fef,0x17ad2637,0xb723d519,0x75f5dc83,0xa14d6def,
	0x29ebb7b3,0xd30b9545,0x6ab70b65,0xe6293fd9,0x93b798a9,0x9e0f8f89,0x7afbaa6d,0x329912ed,
	0x52519265,0x794d6989,0x5acfae6b,0x7531b473,0x32d99e77,0x5509bb75,0x06add2f7,0x68292ebd,
	0x6b5f1bbd,0x11b3ed01,0x2c735f6d,0x4265b625,0xd3d5235b,0x80e13267,0x346b0bf7,0x086fb609,
	0xbf17fdbb,0x064fa971,0xea450685,0x7d79fdd7,0x73ebb78f,0xd8e7966b,0xc61917cb,0xb45f0dfd,
	0x45fbd6d3,0xe3b5c129,0xd567e84b,0x409f84f5,0x4edd2fcd,0x46f1f209,0x4417654d,0x0767ac41,
	0xc70dda05,0x78f78eef,0x857b45dd,0xb089256b,0xfeed454f,0x074d5849,0x1d49afd3,0xb77db701,
	0xf7cd6ec7,0xf7a5460f,0x08a3fcd1,0x1c67399f,0x9cdf35cf,0xc8d184b9,0xc70f9f3b,0xb511a4e5,
	0x9c3fd113,0x13d19251,0x03812741,0x1ded3c7d,0xdff36387,0xcccb7b61,0xdd4d67dd,0x4b17dd17,
	0xa6e7b165,0x240f3801,0xd137bbcb,0xb94d696f,0x3dedf531,0x071128cd,0x42656a93,0x3efd5743,
	0x58c1d4b5,0x416fb3e9,0xa3672d85,0x7d395c5f,0x0b0b7607,0x3df10203,0x3f37d4b9,0xf0b93b91,
	0x6155b47f,0x6785db51,0xa2350c0b,0xa2e1b1b5,0x9a1375c3,0x2a3fa48f,0xa3274025,0x7abb82ad,
	0xfea31ebb,0x94617c05,0x0c3fa377,0x2df9a65f,0x5c47289f,0x974d767d,0xe4175335,0xd1f595bf,
	0x1d2bd5e5,0xe895fc4d,0x56ab9c61,0x0cb1b7c5,0x01670755,0x82ef4655,0x3e6760c3,0xe5d9ee71,
	0x77f330f7,0xc735faf7,0x4d199be7,0x37bf43cf,0x97b56f1f,0x3d73eb21,0xd4f90825,0xc05bb6ef,
	0xb879bb67,0xf5d3ef47,0x31a9e39f,0xd25128e9,0xabf341b7,0x89ade46b,0xd131d539,0xa5e969e1,
	0x96c1d535,0xbc7fc90d,0xdd01f1a5,0x4a1965fd,0x69658557,0xbceffa3d,0x82f1e057,0x35797271,
	0xf94b52d7,0x05cb908f,0xde412091,0x774dba77,0xb9cb04b9,0xdf0bdd21,0x80996e5b,0x887bcc4b,
	0x151d1d47,0x7ecb0699,0x9b0b4781,0xbc9b463b,0x6567ef17,0xca53c623,0xc70d909b,0x52e3a399,
	0x8db5d201,0xb70f4473,0x6f815a0b,0x273729b9,0x32fd782b,0x4b9916c9,0xd9afc4f5,0x031ff501,
	0x951962ff,0x40ab5be9,0xce45084b,0x8ed125d9,0x07cd782f,0x422df921,0xe25f95c1,0xe2252db1,
	0x0bc7b6b9,0xd02ff745,0x60795ed9,0xb59d3c05,0x07990bdd,0xbfe5ffb3,0xd17f39db,0x3365cb53,
	0xa0c34829,0x5caff94f,0x25c166d3,0x684d4e25,0xb4a53471,0x2911c589,0x7df33499,0x54d1fc0f,
	0xf18dc6cb,0x3fbb1d53,0x943bc5cf,0x9e13bea7,0x0fb177a1,0x54838e2d,0xc51df5d9,0xdedb3e8f,
	0xaa2bb699,0x5565971b,0xb88b5de9,0x989f1071,0xb7ff7fa9,0xab8be5a9,0xaadd79f5,0xc47701fd,
	0xa51b100b,0x1c41b2ef,0x55d5edbb,0x042586ef,0x0b53bb43,0x49ff4089,0x7997e9c3,0x73154605,
	0x0b63e01d,0xd561759b,0x05b7b05d,0x1757c60b,0x45edfda9,0x1e2d9bd3,0xe22d3aa1,0xf2a73ad1,
	0x7481e847,0xa4553c67,0x5857fd6d,0xb365722f,0xa28f1e97,0x08eb1d15,0x1bffce67,0x059fe109,
	0x06773e83,0xaf2f5d21,0xf455e901,0x8403d045,0x7a7d9a43,0xfd87b257,0x04f1136f,0x48efa9d7,
	0x95cbed4f,0x3e83c60d,0xb6d3e3b3,0x1f6365b7,0x65773169,0x21d7b223,0x41632495,0x540b16e5,
	0xc57d939f,0xdd619dfb,0xd3735aa1,0x2637986d,0x59bf8943,0xee297b83,0x5c396931,0xd8e35a5f,
	0x270d04f1,0x795de431,0xf4555761,0x63af4ed5,0xcc19cb8d,0x4d511601,0xe6d3351d,0xc3e9f6ef,
	0x5a7fe93f,0x8287107b,0x5a21200f,0xed7f8fd5,0xcfc5467d,0xbca3d1a9,0x991568b3,0x5c0f5fbb,
	0x2e555d01,0x0b73b321,0xfbf3d745,0x43d922db,0x36850ccf,0x6bede701,0x716110cf,0x62c79873,
	0xbf919133,0xe93114ef,0xa76f1c1d,0x716d2fcd,0xb09d95bf,0x5d831717,0xd49706c9,0x3405d53b,
	0x99b56b4d,0xd353d72f,0x20b7aa2f,0x2b6fdf17,0xeccd5d03,0x86374b73,0xae19907b,0xe6371ac1,
	0xd6c1254b,0x83ed93a9,0x426ff997,0xf191f9a3,0xb85782d9,0xed5b361f,0x8fcd003f,0x6a53de2d,
	0x3f3beda5,0xd7917ca9,0x1db5deef,0x2e0388db,0x1eff6bf7,0xccc1f1a5,0xd21154f1,0xabcba52b,
	0x6a218757,0xed4ffcf9,0x1a2d2b51,0x557976a9,0x8b056199,0xb0bba10f,0xb3c7d9e9,0xb08da5e3,
	0xdcf7e9d9,0x46b957e1,0x15fb4c57,0x07252d75,0xe52b317b,0x981b0fe9,0x7a53c701,0xb90f6701,
	0x2bbfe127,0xe7e3492d,0x85bfec19,0x2cb9382d,0xb4b5cdd3,0x14335239,0x9197e095,0x603f5fab,
	0x18f9adbb,0x775da525,0x94999133,0x1a65e237,0x3f63ed5f,0x68d5648d,0xabf3177b,0xbb939791,
	0xb5aba48b,0x5e3bf895,0x442f3ebf,0xaeddd781,0xa977ab55,0xac53cbed,0xe2492911,0x7afd46d7,
	0x8153cf17,0xe80d28c7,0x8ca11455,0x7353c471,0x15b32773,0xe77f35e3,0xd3ff3f31,0x08eb762b,
	0x89f58b55,0x62e51385,0x7c91ee11,0xbb77f5f3,0xc55b25ef,0x35a91879,0xc6f39031,0xaa539eb7,
	0x8c132bbf,0x3f592f17,0x5921048d,0xc57df971,0x3831af87,0xe4a75239,0xc787feef,0x9ea34a23,
	0x12af9751,0x30752a47,0xbdf38ce3,0xda173cd5,0x4c73b171,0x94c9ca2f,0xc89fbac3,0x3fd1b299,
	0x9749e983,0x4bcf8c63,0xbd2b58ad,0x6c77ae89,0x5ee79d6b,0x58df0fe1,0xc39ddf87,0x224f62c5,
	0xa1e71251,0x29775531,0xff677603,0x3a4d5d75,0x6acd09ab,0xd63ffb5d,0xd8611597,0x350bd5cf,
	0xe9077635,0x04019cfb,0xe3cbcf81,0x6bcd1907,0x29e950ef,0x64b74d2b,0x6d4f31cb,0xe17b1761,
	0x71ad8e27,0xd87f348d,0x9ffbcc41,0xb3a71125,0x347b326f,0x2e9d4e55,0x4f47d57d,0x2b8d63a7,
	0xaf5b87a1,0x867f4531,0x6015efdd,0x6f0f763d,0x214571e3,0x50bf7065,0xd1ad0e87,0xd1b7c749,
	0xa413e49f,0xf019f0b1,0x66bf7a6d,0xc5b91935,0xa5897789,0xfa71ed65,0xee63f745,0x6cebbf71,
	0x00551b9b,0x19d9f155,0x2d19088d,0xc9d10b79,0xb50bf019,0x8d8767df,0x65c9568f,0x9097d9cb,
	0x4327378d,0x4ad539e9,0x82c33357,0x980f3ef3,0xa20b6ccb,0xbe4f8adf,0xdec13fbf,0xeab15481,
	0xda0777ef,0x2c9f95b5,0xade33065,0x77a1260d,0x3d4d035d,0xb39da9eb,0x06b1b2b1,0x63a9be39,
	0x40f9f0bd,0xeb474887,0x8b1971d1,0xfa3b53b1,0xf611ee07,0x26c36111,0xb1773bbb,0x3e719623,
	0x227f2a71,0x5561aea3,0xad874633,0x1c0d1b47,0xfa192b81,0x839334d9,0xf97593bb,0x387bebe3,
	0x779bc203,0xfbfddcd9,0x7ecf78a7,0x63cb30bd,0x55a71f09,0x085f324d,0x5f8f400b,0xa9b9ffa7,
	0xa7cd08ef,0x52ad406f,0x5f13f0c7,0x02a74879,0x137f3057,0xe5f98ef9,0xeb273281,0xa49fe217,
	0xa91ba52d,0xcf853f2f,0xc4f752ab,0xf453b769,0x5ce16ba5,0x5fb348e3,0x4a1d697b,0x161d145f,
	0x20033139,0x0b15d767,0x5d999eef,0x1eff12f3,0x999121ab,0xeb5fc697,0xf0d38fd1,0xe5a52827,
	0x7f89dc0b,0xe0713fdd,0x2c9dd2af,0x735fd103,0x8fcf87a7,0x514f7721,0x3a2f9cdd,0x15295f99,
	0x292f091d,0x8d2987db,0xac27877f,0x0ca5e803,0x845d5751,0xcc557209,0x878f747b,0xe11d4d61,
	0x8cf5f06d,0xd151372d,0xecd5937f,0x50816edd,0x5a7d6ee3,0x29c31759,0x60d58703,0xe06f74a9,
	0x49613e6f,0x0f79ee1d,0xb5cda945,0x0f293cfb,0xb3f37117,0xe969af9b,0x9465714f,0x2495e917,
	0x4b71b421,0x6cb30575,0xa4aff7ed,0xa3498a47,0x10ff6525,0x5d9d0bd9,0x57219cb9,0x597feed9,
	0xeea9c6fd,0xf0952e7d,0x4d9bcb11,0x12198f29,0xf06556cb,0xcb2f259d,0x6469df1d,0xe5a19a99,
	0x1d0b40fb,0xa52b1301,0x5b372acb,0x2b47248f,0xef65f641,0x896fbef3,0x1e211ad3,0x09e9717d,
	0x6f19e097,0xb70bf549,0xaea37bb3,0xa90763df,0xe9c13841,0x22330263,0xaca9deb5,0x01cd0935,
	0x4bd5f8cb,0x95455021,0x7f811ee7,0x500b4705,0x19bbf605,0x71c922f5,0x1ee5061f,0x233da7e5,
	0x08bf110d,0x116d76d3,0x7bf311fd,0x0f83486d,0x38178d47,0xc707fc37,0x8a3758e7,0xfeabe43b,
	0x09dd855d,0x7f933527,0xe89d8f0f,0x212302fd,0x9c158041,0x033bb231,0x2a7f2b6b,0x7f094561,
	0xe1ad2631,0xd64b6f69,0xc09dacbb,0x291dd221,0x5b7715ad,0xba3b516d,0x821ffe85,0x09c9e2fd,
	0x7133d883,0xcea5c263,0xd597fe17,0x562171c1,0x6a81f8c5,0x52556ef7,0x79fd1f8b,0x9edf053f,
	0x07f135cf,0x0435235d,0xefaf32bf,0x81659e4b,0xbbf3d943,0x245dc855,0x8175485b,0xf8bbc4cb,
	0x83e72c0d,0x150b8023,0xed83b6cd,0x4e97b4a7,0x61110b61,0x9ba5e395,0xae6f3f4d,0xac4faacf,
	0x719b9db9,0xc1bb5eff,0xe43952d9,0x4be9523d,0xa99927d9,0x5601af3f,0xdd49773b,0x490d50f3,
	0x2c0b01cb,0x0d557eb9,0x3f6fcc01,0x120ff4fb,0x43d3abe5,0x43bf225d,0xd0e5af81,0x78e90163,
	0xfcbb03bf,0x5d6b769d,0xe14b83db,0x643b9b47,0x5c7b993f,0xc7b3dc79,0x52a793f7,0x205356c7,
	0x3bad238f,0x9a115673,0x426d1883,0x501f640d,0xbed71621,0xd72fc59d,0x52715cf7,0x7e3ddc4b,
	0x6f6355b3,0x4dd94687,0x91f70491,0x4deb2eb7,0xf4a70d45,0x1a05ae53,0x06a36f5b,0x4c19ad97,
	0x6cdda325,0xc5d127a3,0xd58b3f23,0x60553b2f,0x662dcde5,0x0a87efa7,0x0c21fc7f,0xddd916d5,
	0x77a1c961,0x31913311,0x094bdbcf,0x3489c9df,0x7a2dabbb,0x15870b1f,0x864da23b,0x41f134af,
	0x61adda61,0xc3259a99,0x3fd9aab1,0x423fbbb1,0xb5e79f03,0xba554ac9,0x3f070ae9,0x614f9453,
	0xab85dc9d,0xcf252885,0xc257d861,0xeba5320d,0xdd1de473,0xaac7612d,0xc6b18d63,0x1f69d365,
	0xa42b6b0f,0xec9ddfa3,0x30678dfd,0x9d6f2ee1,0x12139d47,0xeb2d0955,0x9431cd05,0x7a2f4013,
	0x89215533,0x15239b39,0xa02d911b,0xeecf3493,0xf5896f39,0xf259a6cb,0x24e359a7,0xaa157905,
	0xa6673f03,0xc4c9af11,0xbe47e3d7,0xc175e611,0xc6c12483,0xc99be599,0x1caf4fa3,0x42090d67,
	0x768340f7,0x1a1f8779,0xedd964cb,0x6195a6c1,0x837f4be1,0x2cc95a4b,0x65f3f7d5,0x4f811ce1,
	0xc273880b,0xf6374935,0x68876f0f,0xa5e13a8f,0x0803d889,0xaa3121e7,0x51916793,0x7a6df79d,
	0xc1bbf5b7,0x1ca57195,0x5e717a41,0x0f8965e5,0x2f0fc237,0xc2a981fb,0xb6ed20bd,0x253fbe47,
	0x3a5dbff5,0x537b765f,0x1637ba77,0xea418dad,0xf1e7a525,0x097f888f,0x13e9b1a7,0x8ce90207,
	0xa0db1141,0x834765df,0x0cffc04b,0x6c3b574f,0x884b620f,0x4489ac2d,0xace5552d,0xe8df6489,
	0x3835a895,0xd72186dd,0x166918db,0xd62948b9,0x887dbe2b,0x8c156bdf,0xacc592ab,0x8b1137f5,
	0x31ef7969,0xdc95f8a5,0x7c97edbd,0x933b6853,0x07410335,0x6af7ef2f,0x44e9ddf9,0xfff11ef5,
	0xce0d4bb9,0xa3bb5301,0x202ba50f,0x5925dd05,0xb7d79f67,0xfe83a629,0xcd353773,0x2e71acb5,
	0x7b0d5bfd,0xdf1f463b,0x98478165,0x48178e3b,0x0c01c57d,0x1687e953,0xe40bcbef,0x780304dd,
	0xf5f3fb31,0x03d73b1b,0x528d41df,0x0ac7c3e1,0x54030cad,0x555799bb,0x8e4b94cb,0xd89b7b97,
	0x6a3f2ecd,0x6975f2eb,0xb321c213,0xf663c65d,0xde9d10b5,0x4fc5c0e9,0x5759f7df,0x06a9358f,
	0x91f750cd,0x6a092779,0x34a19a1f,0x2a9f7e9b,0x191111cb,0xad2330e7,0x71156787,0x931fc7ef,
	0xd599afa9,0x82252b09,0x8833be99,0xb1ab1605,0xaf2394ab,0x4743243f,0xd3e30299,0x096fd85d,
	0x6c292e5d,0x70dd886b,0xb575209b,0xa03b9683,0xab130291,0x4a77ddfb,0x5ea33473,0x0f8bbd07,
	0x7b29e461,0x57c1a2e5,0x3a8d4dc3,0x35818a83,0x95a34933,0x559149a7,0xf6b954ef,0x85e71c97,
	0x369bbdb1,0xdae55643,0x2c191027,0xfb2f9ced,0x96157acf,0x99e39b49,0xa8074863,0xa7738e35,
	0x01011ac5,0x40d996cf,0x553f0e63,0xe5753929,0x922d6e1b,0xfb3fef6f,0xc4ed1fad,0x29a1398b,
	0x8b5b7099,0x92b11151,0x579f6b91,0x73072b23,0x4e2d5e55,0x2ff7eb21,0x064fb825,0x5c6376c5,
	0xf52de8a7,0xbbfdcb15,0xcb5b6749,0xcd173f47,0x8cd38b33,0xe0dd5be9,0xab8d5ba5,0x4a2b6e8b,
	0xec7900e7,0xaad1c1e3,0x5f15fda7,0xe755e27b,0x2f65d8f3,0xc941d7d1,0x9a8b6089,0xd7edba07,
	0xcdc12bd3,0x6fbd8c07,0xf7ef8747,0x9ff5c22b,0x55a3704b,0xd6f95d63,0x7fa9c9a9,0xe51902e5,
	0xc4077067,0x5dd5f84b,0xd18b593d,0xdfa96c41,0x7dd15e79,0x4a55f3ab,0xedcbe65f,0x6ba1a34d,
	0xe8cd0a1b,0x2aa9adf7,0x9e0b6529,0xb9a1ef25,0xa4af3533,0xd6254a2f,0x7e53f285,0x9ff745eb,
	0x641308eb,0x0e4bccd7,0xa613d921,0x8b9179c5,0x657faab7,0xbfbf58fd,0xf121b677,0x110d85e7,
	0x8c5ff151,0xe34f8d35,0xe8c1bfc1,0x1dabfb89,0x1a0539bb,0xfef1009d,0x4c99270b,0xc8578eeb,
	0x06af5c45,0x46c5dfd9,0x3bb9a023,0xc2a1c459,0xfa81c17d,0x5e11aa19,0xfd9b05a1,0x69c5bd23,
	0xe6879741,0xb8410e0f,0x6b1f1de1,0x77a324a1,0x3db525b5,0x99ede6fb,0xf78b800d,0x53c93d37,
	0xcde74441,0xb9d3599f,0x59939913,0x04650d4d,0x38e3ee9b,0x81d9114d,0xd44bd0ad,0xbf55ac53,
	0x0d55f9bf,0xf00f9cd7,0x2035ce57,0x1b19afc3,0x7fcfe8ed,0x17a9eb99,0xf43bde59,0xdfdbb81f,
	0xc3cfe2b3,0x4205ea7b,0x2eab76c1,0x786f1def,0x04b9c5e3,0xafab40eb,0x9e3fdc6b,0x034fbec5,
	0xfed95e97,0xf9492ddb,0x6b15e7f1,0x039bea3b,0x3865bb35,0x10b384c9,0x1fb7eabd,0xb2216ef1,
	0xda77a167,0xe1ebcabd,0x5215b3ff,0xee4fc78f,0x2a132321,0x94137341,0xec87b5ab,0xcf4367cb,
	0xa125539d,0x6a7d3d6d,0x16cd4983,0xd4bd2959,0xa7851c5f,0x459db0db,0xbf0f160d,0xb827d8fd,
	0xebeb3231,0xc413bab3,0xc2df9399,0xdd95e381,0x5cfd2a27,0x03a36aa1,0xb833b13d,0x64c122b3,
	0xc249ae9f,0x023dcfdb,0x566d99db,0xda0bca6f,0xf53fd437,0x9ef7f61d,0x7f559917,0x877f7595,
	0xba3f8edf,0x3b0f02af,0xe8192061,0x65d15311,0x398b46c7,0xfaeb715b,0x6255ebf3,0xad5772cf,
	0x18518d6b,0xa71b7177,0xc50747c9,0x071732cd,0x31a5f291,0x2d5162e1,0x759774ab,0x5db9cc09,
	0xef81f941,0xc16f72ff,0x90d52d29,0x4e91ff8f,0x43cd2ccd,0x9e7b59bd,0xb3fb4a99,0x3a97e36f,
	0x415155d5,0x67a33691,0x65a78a1b,0xf771cfc1,0x54c5cf39,0x293b8d77,0x1ee57199,0x20656ba9,
	0x1dc3fb25,0xf9c363f5,0xf42154bd,0x0767da4d,0xe7cfd80d,0x3ae37e19,0xde357a01,0x461307e1,
	0xc357b5ab,0x7a65bb77,0xa3635fa5,0xeea7169d,0x3eaf0a03,0xf343942d,0x604f20b1,0x5d11ebc1,
	0xbf13665f,0xae9bb5df,0xb10df9f1,0xa7e3dc99,0x79a58c55,0x44b1c0bd,0x7a15eefd,0xb1577b75,
	0x0c75a2bd,0x3df52479,0x51458f35,0xd84d84af,0xb7758abd,0x13fd1d53,0x86e7dac3,0x4951eba7,
	0x358154bd,0xd287d10f,0xceab4791,0xef9507c7,0x355dd575,0x58778bfb,0x88a9e65b,0x05f3e17f,
	0x72b95adb,0x38df1deb,0xaa61a79d,0x47ef9f49,0x6f258135,0x3bf5573b,0x47bbc09f,0xc2b112a7,
	0xcb1d280f,0x8015a5d5,0xbc093071,0x460d6521,0x3f09873b,0x3ac5d221,0x730164e9,0x757be549,
	0x343363d5,0x19b7dc17,0x51c5ffa9,0x791ff3b9,0xfdcf653f,0x43bdf835,0xbfddbb15,0x4ec31011,
	0xb1f98a25,0xf9d7ac7f,0x50376f5d,0xbad905fb,0xa2b7bd7b,0xd82b0d81,0x0a2f377b,0xd97b3a29,
	0x76f38b7b,0xb7091b53,0x5281b62b,0x4f6d1751,0xe383f6a9,0x2be53e8f,0x74597af5,0x1b179b39,
	0x04236cd1,0xaa5de55d,0xca478729,0x058b03a5,0x5477dc03,0x4539406b,0x8741f2df,0xb3859b6b,
	0x490be79f,0x0f671feb,0x1fa7b1f3,0x5667a761,0x88533d43,0x1cfbf09b,0x5243790f,0xfd3b7369,
	0xc3ad09df,0x2437d8c3,0xd147c2a3,0x85b37f6d,0x305b8ea3,0xbe7df52d,0x8b47f3e3,0x2d29cc5f,
	0xa089d60d,0x495fb62f,0x9445a1d3,0xc1a14937,0x3c4d88dd,0x67935ca9,0xaeabf635,0x72c35ff7,
	0xdaa3e321,0x21f396fb,0x7447349b,0x42e1a2a5,0xfa6fc92b,0xa88b3e17,0x1f515f5b,0x17f79857,

// 3 * 16384

	0x5b7ffc97,0xb3853271,0xf36dfc97,0x6ca7aa25,0x37837147,0x84395907,0x469ffb33,0xa13b302d,
	0x1b19c269,0x8625b85b,0x2a57b7e1,0xeca59e9d,0x5ec9c76b,0x8fefb57d,0xb4712215,0xed7fd2a3,
	0x3ff9490f,0xc4657101,0xe82b0111,0xdb0b7f79,0x9a03d653,0x137f4405,0x3f2f58dd,0x5635bb61,
	0x3f1fb983,0x5b595d2f,0xd289ef45,0xda8daca3,0xf1730d35,0x293b7da9,0x23b5f0e1,0xcf4f5691,
	0xfc0bf141,0x1a91d62d,0x8593b613,0x385d8685,0x6bdddfcd,0xddf503f5,0x256ba7ff,0x0741e0df,
	0xe8c12243,0xd4212dc7,0xb3eb4597,0x0c2d0e07,0x2e816655,0x50fd40f1,0xae2f488f,0x86fb0773,
	0x25c57301,0x7c994e47,0x46b5ea6b,0x582d8497,0x9d21fd87,0xd4290727,0xee63496d,0xd1ef87f7,
	0xa2139e75,0x4b0d5a75,0x7d8feda7,0x29110c1d,0x7a01e69d,0x0bc931a1,0xfced6df1,0x860fd097,
	0x3b33941b,0xd90d4d9d,0x0e9d34e7,0xb6094701,0x05e1e751,0x0eaf43e9,0xf72965f5,0x7bcd9ffb,
	0xdd2517ed,0x42ab9b89,0x4683e245,0x80cbf82f,0x2003e9df,0x862b0a09,0x20ff6dd3,0xe61da54f,
	0xa2696263,0x467bd081,0x285ff45b,0x7585a311,0x662b9cfd,0xce13388d,0x04cdee65,0x726d203b,
	0xf403c077,0x658f3151,0x8dd7e641,0x0ae92b93,0x549913e7,0x14b50c7b,0x93751d07,0x68b380e9,
	0xa97533a5,0x03775b41,0x47094f95,0x622d761b,0x660f6657,0x7ae7eb61,0x445b9b91,0xcb5f0805,
	0x28c111e7,0x8645e41f,0x3a9b846d,0x66ff0793,0x33d15089,0x33f70347,0x3561185d,0x776566b7,
	0x8669a5b5,0x768dfa2f,0x85ad3565,0xef93a569,0x959fd333,0xa5bbeab7,0x4ae7ee47,0x44335eab,
	0xa56dce0b,0x9f5f0441,0x9be10f95,0xdc99f585,0xc1bbd391,0x888140bb,0x4fd1c4a7,0x23bf6209,
	0x57539e61,0x2e4f419b,0x67595c99,0x39471e4f,0x6ce9bb5d,0x071d4cdd,0x157f2f57,0x4279337b,
	0x7c19feb3,0xd36d6a09,0x68b7a28d,0x5b4b66b5,0xea6918d3,0xdee39f29,0x93d54eb1,0x2753862d,
	0x22434b79,0xe14d4dd3,0xd71d4405,0x02d7d61d,0x4bfd3ea9,0x7fa1b025,0x09356f91,0xd3c19dc7,
	0xa6d3f5af,0x6cff75c5,0xc02d2021,0x7aa1d473,0x81e9e41b,0x2bab80df,0x1a7fab4f,0xe3b1ee75,
	0xd54b22cd,0x6e15c329,0x28093277,0xb7d7ca21,0x7aedc4e5,0x17d33adf,0xf31787c5,0xad99bcdd,
	0x07ab4ccf,0xdea30fc7,0x29553325,0x7a2bc011,0x444b413d,0x8b6bd02f,0x64dd974d,0x6269be2f,
	0x4677e22d,0xdb3bcdeb,0x152f36c1,0x6bd3ffad,0x29c7fde1,0x00459b59,0x083518c3,0x2d93b80f,
	0x68b3e5e3,0xc2eda85f,0x933d4e65,0x417db2df,0xd59f8407,0x42b3ff67,0x5bff977f,0x550920ad,
	0x33dd8f69,0x574b226b,0xc19d27af,0xda5d8411,0x709be16b,0x918707e5,0xe59f8b5b,0x593fbead,
	0x7bf7eabb,0xdc6937db,0x54f5acb5,0x60233e2b,0xc1f74849,0xbe1308d9,0x50f7f8b3,0x1525493d,
	0x43877851,0x38d7fcf7,0xb865a413,0x67056c9b,0x4f79af57,0x4c293ed1,0x9067105d,0xde2d0805,
	0xdb8bcd27,0x15a93e8b,0x2d8f50e3,0x0db1fb47,0x7d6371d3,0x921b6ed5,0xfcd3cfb7,0xa4497331,
	0x038932b5,0xfe6f21e1,0xec9512bd,0x1d59d69b,0xae73ef73,0xd8bb866f,0x759ba09b,0x11ebd369,
	0x097f46f7,0x813bc4c1,0x441705bf,0x29b38b81,0x63ef2c75,0x7b593ba9,0x80a3f95f,0xac07e1d7,
	0xe9f19c67,0x4ea3dd77,0xb93da27f,0xb0ede763,0x5d97718f,0x07cbad0d,0x6a4bfce1,0xf20d6827,
	0x6fe159fd,0x59b35acd,0x27a35e17,0x3bbb982b,0xb9afebff,0x5e6101a5,0x65771a79,0x7defe081,
	0x54cfdb33,0xf801040d,0xe16d4a25,0x7d4dcc43,0x14f74d7d,0xd1eb08fd,0xab89ae03,0x241f1591,
	0x60c15005,0x019d18ff,0xcf3db4bf,0x7357d295,0xaab16c41,0x47bfdb1d,0x9c619fd5,0x1391c27f,
	0x8a355ceb,0xf11bf1ed,0x9037c881,0x860bba89,0x74a1e309,0x57ab788f,0xde6304cd,0xf5b332f5,
	0x162fbae1,0x038d9fa3,0x99f92c85,0xa81bf40d,0x4b05b10b,0x6c056a5b,0x7e6fbe43,0x0e7be31f,
	0xb831d761,0x58818b6b,0x58a9a465,0x76b7ef87,0x04a5da05,0xe19b6211,0x0fe91a13,0x5c591fa5,
	0xb23d7463,0x120f170f,0x4ee5b039,0x5993bde3,0x96bd062f,0x27c1d9b5,0xccb37293,0xb83fa5b3,
	0xf4d34861,0x74c33cd7,0x35d32c9f,0xa2e1b08b,0x35132241,0xe04bb3d3,0xb52dcea1,0xf5a142f1,
	0x3ef99e57,0x07b32f8f,0x1d13f2ad,0xaf51f969,0x71e7ff79,0xff87db77,0xb03b8195,0x026d7589,
	0x3e2df5bf,0xb471fa7f,0x8ac577fd,0x06174ae7,0x5dfdf38f,0xec49e427,0xab3dcb4b,0x07190c27,
	0xae73a291,0xe70d2173,0x9b8f6ead,0x78e577ef,0xa89578bb,0x9fe3a9f1,0xba17781b,0x8695c5f3,
	0x7a4d6d49,0xae1b40b5,0x22916553,0x43ed13eb,0xbf71cdbb,0xc627f15d,0x372980df,0x7e53f297,
	0xdabd32df,0xdaabad0f,0xc96f670b,0x2ddf12c3,0xeed395c7,0xdd670775,0xe357aaf1,0x8647123f,
	0x774384cd,0x204f13c9,0x30479b6f,0xa7ef68e5,0x817f7897,0x567561c3,0x0603282b,0xf0e17595,
	0x85e34911,0x351b1aad,0x0dbde697,0xedcdab37,0xe0b5c269,0xb4a33e53,0x8d0d36e9,0xeb11ddbf,
	0xeb215a1f,0xf19f0009,0x4ef38921,0x25afaf27,0xb43903f5,0xadc343ab,0x2cd9c203,0x9c4d1c6b,
	0x59fb26f5,0x70ef3aa3,0x378dc023,0x80432a9b,0x024bb275,0x4a2720d9,0x804700d5,0x4687b3c3,
	0x73f5530d,0x309b19c5,0x81a96539,0x58bb53ff,0x4fadc7a3,0x04a12d65,0x28bb1735,0x662d766f,
	0xe90f565f,0x30b7653b,0x7ded8e7b,0x54cd823d,0xbfa161b7,0xea830959,0xee15b581,0xd2352799,
	0x97cf1d67,0x13d3fd4f,0x33772e85,0x84a7ccbd,0x33eb636f,0xbb9d3d3f,0xdeb9b891,0xdc0f1aed,
	0xad33a91d,0x3f037acb,0x7fedb473,0x82fdab6d,0x6ccb1403,0x0a45da21,0x6f89c9c1,0x6fadd493,
	0xc4bfaefd,0xf9d7cef7,0x376fabdb,0x94ff96b5,0x2905bf2d,0x5b4b1989,0x9be5fee7,0x3381a935,
	0x087538ff,0x8e61e39f,0x449f5cd7,0xca63a77d,0x45d75527,0x45fffd83,0x05b17a61,0xa87f5dff,
	0x50d7459f,0x69353b0b,0xc89f6c05,0x1d573733,0xdf070aab,0x9437f095,0x154d0b07,0x4a15c899,
	0x44e767d5,0x39639007,0x3b117a7b,0x928d7fbd,0x6ed7f8f3,0x624165cd,0x199dcc35,0xae396f2f,
	0x7a25671d,0x107f75dd,0x8a17c5d5,0x593b3b87,0xee07bdb9,0x3ef378b3,0x6803c5c1,0xa55b2869,
	0x9497df6f,0x829bf855,0x3a53c82d,0xeb0f457b,0xf3d91b37,0x4b9b8d51,0x7c5f8c09,0x5a6fbb71,
	0x66bbe147,0xc6453bbb,0x86e7d81b,0x2c3d3903,0xd60f9827,0x5c0ff031,0x1915dfe7,0x72e37ff3,
	0x1195919f,0xd4931cd9,0x8175c8bb,0x8b751209,0xc8ed1fc3,0x169d765f,0x67054eb1,0x2eadfe17,
	0x24a5c9ed,0x8917d0f7,0x322189a7,0x21ebccf7,0xff33a1c5,0x14191d61,0x1593d245,0x883d8e87,
	0xbdf1b831,0xc1e185e1,0xb789c6f9,0xd35106b5,0xca23b267,0xffd5ab45,0x7a9f70fb,0x5485fa6f,
	0xa9f97ee1,0x7f8501e1,0x66d3894b,0x6dd99cb1,0xb9812a63,0xb7a54e93,0xb28dddad,0x62f71b79,
	0x83bdd4f7,0x051343bf,0xeb9fd5b5,0xca334cd1,0xbb8dc6f3,0x6bd73e53,0xc03f17b7,0x9d877bcb,
	0xd4c1a5ef,0xf81d22c7,0x680d4dd3,0xeb935581,0x3d0bc9d1,0xbf3f5a13,0xad150af1,0x28a3f615,
	0x3507b1c1,0x80b7eec1,0x94c3cfbf,0x1fab15ad,0x49399937,0xe72fc9dd,0xa8f12fb5,0x8341557b,
	0x6b112ce9,0x69730ff9,0xe0e11613,0x1eabacbb,0xa9dd5fdf,0xcb799e37,0x2a392add,0xa6d1f5ab,
	0x8bdf6061,0x3f5fa739,0x920957e7,0x2b479a97,0x0739ad03,0x266f702d,0x0dcb6dc5,0x274762cd,
	0x1af749a1,0x72132dcb,0xe45de8d7,0x32b15fa9,0x080d145d,0xa4e3014b,0xb709d645,0x5311f98d,
	0x2a573aa3,0x739b1577,0x2a7fd8fd,0xec991cdf,0x719bce27,0x0625db99,0x2fd74eb7,0x53258713,
	0x7a8379e3,0xd88f6887,0xed9194f3,0xfb3533a1,0x47a5571b,0x3c0bf1a1,0x48976df5,0x4af3e909,
	0x9a7de25b,0x77fb69c9,0x0d3585d1,0x0b33e5d7,0xec6f1075,0x8ae53e6d,0xb829175b,0x786dad9b,
	0x07c78383,0x8b753483,0xdf8fb133,0xf3c5f5ef,0x40b9dfeb,0xa9856587,0x3bf11ac1,0x5405b371,
	0x4e614157,0xcf0f5c7f,0x513d5933,0xd69f46cf,0xc3c5cfb9,0xe13b52f9,0xb7cfd481,0xb0afc9b7,
	0x28d1744f,0xa1598e09,0x05659c6b,0x3ff37be3,0xb357ae99,0x2ddddb4f,0x5627cd77,0xdbdb5015,
	0xa0158965,0x23652deb,0x75a515f5,0x46739915,0x2bafafc5,0x5db95b8f,0xa7d95afb,0xbd7bd6b5,
	0x2bb1a215,0x58c7f96f,0x12237d69,0xab51a2cf,0x478f0af9,0x31a55947,0xc4493ee7,0xf801be43,
	0xd1a73459,0x4791a65d,0x617f46e3,0xfa3d3dfb,0x403b9c6b,0x7cef227f,0x69594795,0x085fd7e7,
	0x4677aaa9,0x18518301,0x20db42fd,0xa96b5003,0x8d7384d7,0x456d6dc1,0x1b69efe1,0x6609054d,
	0x0d270401,0x361f1623,0x63d73ecf,0x398b9ed1,0x0579c977,0xe36dfa17,0x455dff21,0xa2edd89d,
	0x973573d9,0x6e87bf0f,0xb499a3f7,0x55d170cd,0xfd11f407,0x21c32f0b,0x58952933,0x8b813481,
	0x64a5022d,0x11a1558f,0x33c1188b,0xf3ef2ce3,0x677bb2bd,0x5dc3bca9,0xecf5ae71,0x46b5ec25,
	0x23f92b75,0x11f9c9eb,0xb8731f27,0x7417fa7f,0xf6797855,0xa73b3b77,0xe0dffbb1,0x75fd6331,
	0xd23380ad,0x24a5c4ef,0xf04db6e3,0xc0f96187,0x3a4f1c0b,0xe07fcc83,0x79334a51,0x55472dd1,
	0xdad5474d,0xe13747e5,0x7f73fb5d,0x6fc9ea67,0xc1bd7995,0xde61b955,0x81554029,0xdb09b0ad,
	0x37df1951,0xe1bf4c95,0x2087c4ab,0xe039be09,0x3a051131,0x883313f7,0x6b258f95,0xd833c0ef,
	0x91d78531,0xe2cf654b,0xc4ad4769,0x5c7b45d7,0x8ee9a795,0xf7c756f3,0x6f07976d,0x18374443,
	0x5fbbade9,0xe37b5cd1,0xb383b4af,0x393fcbbb,0x0aade5fd,0x996f0553,0xabdb030b,0x8109d0d1,
	0x070feaf1,0x4553d66f,0xab2fda1b,0xf5b91a1d,0x7613fa25,0x4bfd4aa3,0x47056a49,0x33174d43,
	0xfbd56845,0xec6bedf1,0x0051c1c3,0x5b991beb,0x38593643,0x80c39ae9,0x8c67f181,0xa95790c5,
	0xe08dc65d,0x5f55d7a1,0xbe095243,0x9f137c8b,0x7745b115,0x5b9352b3,0x0e61e98f,0xd93902ff,
	0xa63dba35,0xe71f8047,0xc5fdeeb5,0x7ed947eb,0x3717e5d1,0xd2bf5709,0xc5d76fcb,0x52af3c1d,
	0xac63ad45,0xaf5f2d2d,0xf04d16b1,0x641d8a71,0x7a935435,0xcf19b575,0x32290e0f,0x602da4c7,
	0xe1035d89,0xe6271c21,0x2b9b0655,0x828ff109,0x62f92077,0x4bf14401,0x793b5ab7,0x26a11627,
	0xe09f7d7b,0xdc072369,0x9d095637,0xf865691d,0x500bb355,0x771d4137,0x876f989b,0xc58179e9,
	0x16395411,0x241351d1,0xc0399b71,0xee4bc097,0x000d5a05,0xd0edf421,0x2fa55715,0x76bd6a37,
	0xdb535ccb,0xb3db8ea1,0x874f07a1,0xb77945e1,0xafbfe645,0x4c314c4b,0x4b3f11ff,0xaec7d1b7,
	0x97ede79f,0x037139a5,0x7ae908dd,0xf19d67e3,0x3a634e4b,0x6e3f81bd,0xda21d1b5,0x3c938b97,
	0xe28bb907,0x2d69cb27,0xda2be9c3,0xa4eb560b,0x39bb4cd5,0x6ee5b4ff,0x22adcb0f,0x698f0381,
	0xa02fa9ff,0x0ed373ef,0xbab97167,0x6413a03f,0x260b011b,0x58798f1f,0xd1c5ff67,0x19b1d59b,
	0x245b4801,0x6743bd49,0x28b18369,0x6c4bd6ed,0x76158ed5,0x27c9e1a7,0x1ac9dc97,0xeb696e93,
	0x51117505,0xf8c928fd,0x46b9bfdf,0xc5412afb,0xbf17be41,0xec29469d,0xd79bdcfb,0x57abab93,
	0xb6d30785,0xa7f9d157,0x6df12367,0x61290dd5,0xd4d79c17,0xe76dc08d,0xa89f276b,0xd1e57a43,
	0xb4a16a7d,0x9be30921,0x4df9a717,0x3cb3d165,0xe995198f,0xade35a83,0x14b72f41,0xe80d78cd,
	0x97ff3d67,0x5e1bfba5,0x0cf7e089,0x7f134815,0xae15ac67,0x465fc805,0xa9435457,0x629195dd,
	0xbceff43b,0xfab14cab,0x678ba1db,0x99fb64cf,0x7195eed7,0x4a330521,0x1a278309,0x6467b09b,
	0xadf37775,0x2037b87f,0xd0d799a3,0x699bdafd,0x41dd3f97,0x0531f65f,0x61c3d42f,0x8b0138b3,
	0x440dc40d,0x3fc1b3e9,0x927df2fd,0x54a9be87,0x0b2961e5,0x95ab08c9,0xe0fb2d23,0x0e4dce4d,
	0xc6bd8b7d,0xace10c35,0xec9ff583,0x6c5323db,0xb83f1d79,0x0c73d1e9,0x7f31dfc1,0xe0c1e213,
	0x0c09d3c1,0xbda5872d,0x35e1a54d,0x8c4bbfdf,0x525fde8d,0x8cdbafcb,0xca454a61,0xcf4d5531,
	0x986f9753,0xeaa58319,0xfb6162f9,0x7ac587ff,0x214d55d9,0x6cb568f5,0x169b77dd,0xa163194f,
	0xbef3652b,0xeeed96c5,0x20c38b9d,0x08755225,0xcb47189b,0x5453cc75,0x9f13bf8f,0x38f5d097,
	0xc11700c5,0xe815317b,0x002b18d5,0x308774bb,0x7515408b,0x5e8751d3,0xa5116553,0xb2756db5,
	0xeedd0219,0x76293b03,0x8a3740b9,0x38b366ab,0xe1f30be3,0x38a3b919,0x90773981,0x84d7d3d1,
	0xc6c575a3,0xdbbfb3a9,0x660d15e7,0xd1275f5f,0x93a77d5d,0x4279aad1,0x0fa538f3,0xa18b7697,
	0x15d37c5b,0x1de95435,0x114d2775,0x3497f6c1,0xea71fc31,0xae595805,0x377d2d03,0x9483fa2f,
	0x178bebbd,0x24372df3,0x001720ff,0x4833c539,0x4513f41d,0xa1191a3f,0xa3634b8d,0xa431d343,
	0x95ebedc1,0xd8bd4aad,0xbd116a9d,0xbbaf03b5,0x20d17559,0x5207138b,0x9539d6e9,0xf189e6ff,
	0x0975a0e3,0x48094cad,0x095bc8ed,0x293d2b9b,0x396bd49f,0x2af9ce6f,0x155fbdf1,0x97fb2b0b,
	0xb92fb81b,0xc1330ebb,0xfc97fd05,0x358f96d9,0xa9254b29,0xe83dddf9,0x12b93bff,0xcd774593,
	0xda991ae5,0xf5c94421,0x24e76481,0xafd51fd5,0x08bf96b1,0xb8a97db1,0x82a978ef,0x02732d3f,
	0xb1b38539,0x19dd18ad,0xa6ed997b,0xb1c5c17b,0x8f7b9971,0x5d8b31a1,0x810f2919,0x01e1c939,
	0xb1012793,0x0403d0a5,0x5dcd128b,0xbf8b3735,0x331bfa23,0x4ab96653,0x704f2d57,0x112f912d,
	0x998546eb,0x4d4b68d3,0xfb25c2cd,0xe7df9ced,0xc7e3c401,0xc68110d3,0x19493305,0x10532d43,
	0x9ac1dcbd,0x71493685,0x2719b9db,0xe3ef0f0b,0x209306c5,0x09b74ea7,0xcb6153fb,0x99bd1627,
	0x72b53703,0xee0d8781,0xa04dc3cf,0x376f4a7d,0x2e6d76a9,0x5fad05dd,0x7c77b693,0x225f3501,
	0x8de79833,0x64294211,0x5be10943,0x508f4ca9,0x21350c67,0x463784fb,0xe8ef2da7,0x19ab837b,
	0x2755d74d,0xb6b18501,0xa575af4f,0xa805f37d,0x872ba539,0x8da3230f,0xb3abd893,0x0995abc1,
	0x6883ffc7,0x2b37479b,0x3f2f778f,0xe0ff9d5f,0x6d13a2d9,0x78c5dfa1,0x860bc32d,0xb68da87b,
	0x8973f19b,0x89cbf9a9,0x81af601d,0xe92fc93b,0x7e2b8b81,0xdcef02bd,0x2ff385d3,0x3f8364d3,
	0xf0a70145,0x3cff2373,0x7c174393,0x18cbb67b,0x2439a9eb,0x41f3bce9,0xc7c3e55f,0x3def5c75,
	0x532197bf,0x71e705c5,0x14097909,0x52810509,0xa77fad51,0x0223c731,0xca5f7329,0xe5bd3b89,
	0xd461d281,0x381339e7,0x25a7741b,0x2385554f,0x4ebb496d,0x6a510321,0x3b272d09,0x25617ebb,
	0x266b2385,0xa19751a5,0xa39364e3,0xe387e837,0x7f33d67b,0xd9cd1ac1,0xc3ff1d5f,0xc5cf1333,
	0xa9c1f147,0xe3037749,0xb6efd7fb,0xd4bb3f29,0xdca9f131,0xe26d209b,0xd549faff,0x8a77f69d,
	0x8d6536c1,0x736b0d9b,0xdf5d567b,0x43d3bc13,0x695d1acb,0x68812fb9,0xc5e5c947,0x514bd71f,
	0xeed9236b,0x2c5f4fe7,0x12ff05ff,0xa801415b,0xa6115903,0xc2db0ba5,0xf337780f,0x32bfb369,
	0xfa1fbb3f,0x69f1f1f7,0xde7948a1,0xc2f5d1ef,0xb207d613,0xdacbc069,0xe11f83b1,0xa1c17a9f,
	0x09b776b9,0x2ab5c013,0x84e95cfb,0xc0e33135,0x6b0380b5,0x4c274291,0x5a019507,0x8bc7ac6f,
	0xc6a5e2d3,0x2fbd3f07,0x1ff5fe27,0x587d8319,0x8d45ac25,0x853d0f23,0x8ebd216d,0x78c1f903,
	0x486b4105,0x1c994c1b,0xbfbd03bd,0xeaf3ec05,0xd38fb019,0xe6e3cbad,0x36b90abb,0xab21e101,
	0x350b274b,0x975bbd1b,0x8ae101d9,0xa3fb30e3,0x172588cd,0xe467e637,0xafd13f4d,0x3fd95599,
	0xe107201d,0x68970051,0xde87e915,0x99c1571d,0x6fc776fd,0x239f354b,0x1e6b59f9,0x4e5d586f,
	0x6f5f4a77,0x9b5dbc87,0x6e4fa689,0xecfd449b,0x53b79fdf,0x9cd997f3,0x8d69421d,0x089d9bb1,
	0xf199f9d1,0x9d417105,0x645bc3d3,0xe8dd5fcb,0xb7b9ad2f,0xbaeb95b9,0x0e2dcb91,0xdb0b2209,
	0x87b35625,0x5e531597,0x814d0709,0x23152f93,0x2f0d6d27,0x7b23fea9,0xd89756af,0x8c99de9d,
	0x8031fbf1,0x7127ba85,0x3c4712c7,0x9bd7fb5f,0x0b757283,0x8d558b49,0x6b097053,0x5eb9551b,
	0x78159c29,0x2acd289b,0xe2eb0625,0xddd36b1b,0x7d33b479,0x73d37ca7,0xaa6771d5,0x2d5f39ad,
	0x7adf9c4d,0xc2d78123,0xb95d1cc1,0x1e3d272d,0xb30b2ec7,0xa36f3c4b,0x0213210f,0x8ef910fb,
	0x2295b651,0x7359dde5,0x1a3b4eb1,0x5cc77881,0xfa3f81a3,0xa37bfc3f,0x83ed505b,0xf47dd02f,
	0xb7b598b5,0x98e5f12d,0x96abf091,0x83a1e881,0xde8d91c9,0x2dc9570d,0x08597e95,0xc95d7cf5,
	0x5143866d,0xd28ba5c3,0x164b5379,0x877fe115,0x4a3b2875,0x4eabefbf,0x4e377715,0x9387cd75,
	0xf4c1f6f9,0x21ddbef5,0xf7416507,0x87934cab,0xa60b935d,0x84f311e1,0x1aedf1b5,0x1371c859,
	0xb631364f,0x0aef7887,0x2e2b4f51,0xed8f362b,0xf93b44bf,0xe1f35179,0x5a5732d1,0x640964cd,
	0xd81504e9,0xb45126c9,0x662f18f3,0x8da368fd,0x09917351,0x297d2b15,0x3edbab41,0x1ac52a7b,
	0xeb6d37c3,0x0717d681,0x20ed4507,0xc683110d,0x7b4dba51,0xf1e3a3bd,0x615b985f,0x6797d189,
	0xefbf5855,0xced1ecfb,0xd6877325,0xa1615ac7,0xf133b975,0xc3f7e8fb,0xe137a405,0x34ede2a5,
	0x7309449b,0xd993c7ff,0x159fff6b,0xf1ed1311,0x2c83b4fb,0x3b09f0d9,0x8453848d,0x47bd56f9,
	0xb1cfcf0d,0x17ed5dd9,0xa357a26f,0x765b4757,0x2cff3599,0x24ef19e1,0xd7119cd3,0x5f75382d,
	0xb7115ea7,0xbcf1dd53,0x9b51114d,0xf75de583,0x50eba88d,0xa1f9cb1d,0x4c519c2f,0x560b406b,
	0x7c558ee3,0x5e334db5,0x8faf9d9d,0x68255bfd,0x7507ff8d,0x44f71419,0x5d751e7d,0x3ff17a5d,
	0x0999cfb9,0x13c32ecb,0xa913d57d,0x066339b3,0x149550d7,0x333f4cdd,0xaa634c13,0x8c15e12f,
	0x956305a3,0x983518df,0xc6a12383,0x7a4bce0d,0x69577721,0x449fb5f1,0x197779cf,0x23ed008b,
	0xa4b1299d,0x689b5cb9,0x9df76ecb,0xf68dc8f3,0x8b91b1a9,0x236d1863,0xf799c909,0x8b699499,
	0x2b07e921,0xe483a3a5,0xdb3bbaed,0x585fdad1,0x92034427,0x6c7765bb,0x1827c79d,0x00fb2a03,
	0xaa654627,0x6e058f6d,0x410bc807,0x476f5493,0xb1f116d3,0xcf115805,0xf5030fe1,0x9d95bdf3,
	0x53513729,0x89ad5a59,0xc88db2af,0x55efc79f,0x5f1b566b,0x2d0f11c7,0xce91e8b3,0x74a95e15,
	0x24c94723,0xfe937735,0xc1619401,0x2095a5e1,0x6bc31427,0xbabfbe0f,0xcbb3e56d,0xb42bc893,
	0x0c53358f,0xf6433149,0xf1a92195,0x6e8fe1c3,0x28ade5bf,0x1ef53063,0x19c985e5,0xc48b0c13,
	0x05ed9665,0x1cd34c61,0xb6074d89,0x51918e2f,0x85178571,0x930384d1,0x0cb7d679,0x68bb27c3,
	0x3c1b721f,0xc0d5a4c7,0x219de673,0x45cb7e8d,0x2ec971f5,0x02bbbfe1,0x3edf1001,0xde2dab4d,
	0x27dde5b9,0xf359cf43,0x1e0d376f,0x51f1e6cb,0xb1ff8e83,0x2c6f6e9d,0xb12137d7,0xfcd356d9,
	0xb0b9c2ad,0xa7f1b923,0x8b79a817,0x2735fb4f,0x997fc2d9,0xc0f1468f,0xeadfbfd7,0x5721bb11,
	0x4cad2ef3,0xd4b1482b,0x60835c83,0x41499107,0x8e899b2f,0x8393c5c3,0x19fd2657,0x5a07d921,
	0x203d4507,0x9229faab,0xca4dd551,0x065dbd59,0x78e1e83f,0x6a27d2bf,0x32dd9635,0x6cf7c2b1,
	0x1e6bb3e1,0x3b6d8767,0x4c7b8f97,0xe7257631,0x9ec55f41,0xbcff5c91,0x105f86cb,0x11e339eb,
	0x28b95efd,0x8e0d7daf,0xe12ba4f1,0x7ed331f9,0xc4fd39f3,0x36edfac1,0x93e75bef,0x053f517b,
	0x2f29fe53,0xca1de549,0x19036b77,0xb317879b,0x4ec5d68d,0x25438d59,0xc55705ff,0x5df90c89,
	0x503dbe5f,0xd22dde81,0x3b2315c7,0xd427ce81,0x5de357c9,0x87d3dce3,0xf30fa1d3,0xad87fec1,
	0xf8f5e019,0x4b514221,0x652b52f7,0xbcafbe95,0xf29744e1,0x30ed3a69,0xd1f118c7,0x1fd9ec4b,
	0x04d558fd,0xbd194171,0xab41eea3,0xf1e7103f,0x0ba3298f,0xe5671f75,0x9d63c0b1,0x9b6369d1,
	0xdddf7303,0xb197063d,0x380570e3,0xc37d1c6d,0xc64b360d,0x7c8fce13,0x3741fbef,0xe1137c7f,
	0x9c956ca7,0xd55f52cd,0x6c99be55,0x6ba57c85,0x7e4fdf13,0x003bf0c9,0x47f3d959,0xac5f39fd,
	0x27f918e1,0x178121ed,0x009fb80f,0x2f11aa73,0xedf37ddf,0xccb93aa5,0x5e57b44b,0xd3376877,
	0x558b7f2d,0xc99146e7,0x2239dbad,0x7cf1a0a1,0x4df5f029,0xb0df072f,0x0fcfd49d,0x660d1e95,
	0x094f7b83,0xbfa10d83,0x9609e349,0x0ef979f9,0x759d382b,0x0dfbfa71,0x183f0ea9,0xcfd36381,
	0x55c75e5f,0x703fda0d,0xd731657b,0x095b11e5,0xfaa71c9f,0xf7e3a0f5,0x7a096349,0xf5fdcee7,
	0x9bf58cb9,0x1481c94f,0x3755755f,0x1ac9a44f,0x5159c8bf,0x54e50fc7,0x9e0d9fd7,0x587928ef,
	0xab5b200d,0xc7f95091,0xfe93428f,0x9c736da1,0xec736c45,0xfdd5846d,0x73affe2f,0x31bd0a45,
	0xe1fb8653,0xa8b7dd9f,0x8b91b925,0xb20d4ac5,0x5d37db6b,0xde0504f5,0x90cfc4a9,0x96b97c11,
	0x4c552207,0xf74f76c3,0x736d21bb,0x69c75923,0x73692eeb,0x1349ffe5,0x51d1e621,0x96e197fd,
	0xc56fea23,0x36d15ac5,0xa1cdc169,0xdc5596a7,0x5d4963ff,0x0defec4b,0xf997a1ed,0x5c232835,
	0x16c70a1f,0x4ccfa0f1,0x78d179cb,0x4ce981bd,0xc799fc61,0xb0cbe9af,0xd18123eb,0x4af54761,
	0x186181f5,0xa15dd90f,0xf11968fb,0x4935b94b,0xfd9d9e4b,0x712f601d,0x49732473,0x224700ab,
	0xd0bdc621,0x3f0dab6b,0xb9cb8993,0xc96b9cbd,0x0915b479,0x76eda01b,0x17cd885f,0x1b8befbf,
	0x94e15f9d,0xf2ed78cf,0x588752ab,0x503bebfd,0xd2450e21,0xbc5782b5,0x5973010b,0x0ab3e0c7,
	0x284b8be1,0x6c95fa83,0x496f57df,0x0ad76775,0x3feb7eff,0x2e3f0977,0xb1c5ac4f,0x7e337069,
	0xdd01dce7,0x5e11e253,0x1f25e949,0xf0f5700f,0x574d7f4d,0xcbf5fe69,0x6aa7b485,0xdef9abd3,
	0xb381d92b,0x9bf97a89,0xa2cbb383,0xe4c3a733,0x5c2dcbc5,0xc74f9415,0x947bf089,0x907bb0af,
	0x7acf9ba7,0x3d5945ef,0xf4055fa5,0xd2f58ecf,0xf0c905a1,0xa49d0585,0x262183b1,0x10a94d25,
	0xf06b73d3,0xbbc79fcb,0xa8f1334b,0xd2bd2949,0x35e7529b,0x5ab13643,0x1cfd7ddb,0x17f79fdf,
	0xe05b85a9,0x13555bed,0xee35b08f,0x45cb998d,0xeac9fcef,0x72db5259,0x9cef7b61,0xb953b807,
	0x451d69a5,0xe293669b,0xa6ef360b,0xf853c307,0x8d2d1353,0x28f16e53,0x105b4519,0x82333549,
	0x67b7ccc1,0x8a9364a1,0x8cc59ed9,0x4107e99d,0x795b0903,0x8b412737,0x48237061,0x9a87e7cf,
	0xffa71075,0x4ee95349,0x4fd5e291,0x211751bb,0x0a0f55b9,0x9aa14293,0x9ba7ff11,0xe4c17041,
	0x52efeabd,0x75a7285b,0xb6c5b54f,0x6437e04b,0xb88d15b1,0x6a5f4e6f,0x08c9ff83,0x1dd5dfc9,
	0x56150611,0x675b7223,0xbeb527ad,0xc099bab5,0x3c99a9a1,0x40514155,0x53ef2c93,0xfd315811,
	0xcc19a16b,0xcf1df769,0xbb4746c3,0xf6efe6e7,0xac7556c5,0xb4c51a4f,0x27f58d99,0x54cbab45,
	0x667b3049,0xba795779,0x769dbc2f,0xf269eb47,0x9cdfe6d7,0xd29180e7,0x3643166f,0x3113fc0f,
	0xe53ffa9f,0xb987aa1d,0x51596e07,0xe8bb6ec3,0x411d4813,0x37036529,0x56b7476f,0xf8fb5d95,
	0x36e7bceb,0xfed31f9d,0x629d1ee7,0x7a15d8c1,0x8af12d2f,0x31ef9f9b,0xa7b3cd75,0x8df57387,
	0x98754827,0x7f73a0c5,0x980b0de7,0xd12df12d,0x4a99ad67,0xe5a7914b,0xae1b21d7,0x6bf51209,
	0xb56b21cb,0x12f96edf,0xd5c596a5,0xc3318071,0x4edbe477,0x66fdc3c1,0x75512a75,0xc96bddc9,
	0xc7c923d3,0x9375c3b3,0x166fd137,0xefd5ef77,0x84f99295,0xdd438907,0xaf35d9a3,0xb749ebef,
	0xb8151cb7,0xfd79718d,0x8b273239,0xe149e7a9,0x18b1bc7f,0xa24b9ba7,0xd42bce3f,0x41016227,
	0x3d4d6f73,0x90198337,0xbb932ac5,0x2c41f2f1,0x94494b6b,0x6267beab,0x4315f3a1,0x8c851699,
	0xfcf5b381,0xece7dbf9,0xa5d1c873,0x8fef1bb9,0x0081ad15,0x3c695d9d,0x615321a3,0xfa492ff1,
	0xab0f54d7,0x37f1d79f,0xde87555f,0x16058ce9,0x049d73b9,0xe1a32c89,0xbac7bc9f,0x453dc557,
	0x2a1b33f5,0x37cfea71,0xb0d5f823,0x32b331ef,0x065df60d,0xb5e7c7f7,0x21d55571,0xa2d37e75,
	0xab1f45d1,0x758d413d,0x3e5d53d9,0xe4ad56b1,0x4a03ef4f,0xef8754f1,0xcf5f4971,0xe2fd3375,
	0xcd9933e5,0x5cc16147,0x9f3f2819,0xd525479b,0x12531f35,0xb7552101,0x82c56279,0x902d8d03,
	0xbf8dfc2d,0x5b7dc85f,0x0221f101,0x77cbf197,0xc08de9fd,0x48a14231,0xa1eb76e5,0x0f57a449,
	0x5d7d9121,0x02518ccb,0xcc238727,0x2ad3820f,0xf473f85d,0x1141370b,0x5933098d,0xbfeba2ef,
	0x526b79bd,0x2451fd57,0xb8e9bfa7,0x56ef06ed,0xac49d793,0xd1858699,0xbb7de9cb,0x1bdb631f,
	0x37d7717b,0xf70d414b,0xfa910c19,0x8f4f0e9b,0x64cd9957,0xbc3d6067,0xe22dd379,0xd7990f85,
	0xb5c70851,0x3297f873,0x59bf1a9b,0xb1a94803,0x394773e1,0x96bf3c7d,0x0d230ef3,0x0217c349,
	0xa2b942bf,0x3183db17,0x559775c3,0x0629228d,0x037361ef,0xd8d97b63,0xc2c31111,0x24c92a15,
	0x23b139bb,0x10e15a05,0x43b724ad,0x5f876e27,0x7b97c2b7,0xcce10627,0xefed1b2d,0x639f2015,
	0xcc31babf,0xd0453e83,0x70454af1,0x3af1fb37,0x5873f9f7,0xafa5ee51,0x0805db21,0x9d0b51f1,
	0xbe3be7c7,0x71bf4a5b,0x3ddfc8ad,0xe01b3aa9,0x6f4b0fe7,0xd0790ded,0x24eb0b49,0x89ffdcd3,
	0xca4fd74d,0x19e3d7d9,0x45abda77,0x8137dde9,0xd3df513f,0xb131a781,0x2703127d,0xddedee67,
	0x8f733449,0x2fc179c7,0x7749b96b,0x5af576dd,0xf871ef3d,0x261b061b,0xd52fa417,0x66c964d7,
	0x9b25de37,0x7ced9b6f,0x38d93b21,0xd48b17ef,0xcdc39f99,0x760b1d41,0xfccf5ff3,0x2d036ec9,
	0x8969890f,0x4d772099,0x870171b7,0x9fa5f40d,0xe3193c8b,0x7a532901,0x91c77267,0x938d2b6d,
	0x24c15d4b,0x8ff10591,0x14e14bc3,0xd87bfe9f,0x863364d1,0xbec54de3,0xce793451,0x77d94a67,
	0x862f97e7,0xf56fff1f,0x6c1b3461,0x25bb8b8f,0xe3551ba3,0xa1b338f1,0x53c5cb0b,0x51dbabe5,
	0x35332a5d,0x11831a8f,0x0cd3b32b,0xd899ef45,0x253f68b9,0x73efbfb5,0x490dc86b,0x5401008f,
	0x47d35aa5,0x7a3b5dab,0x8da70c3b,0x0cc71ead,0x9533f851,0x98cb803b,0x7c35cacf,0x8b416991,
	0x828d633b,0xe82f66bb,0xbbbbe029,0xc8754f33,0xbaf3bb23,0xa6198109,0x819f1d0f,0xff0b1893,
	0x78651317,0x566b0c8b,0xbab3cc11,0x1c5796bd,0x7cc38669,0x842bd12d,0xd42b5685,0xd153efbf,
	0xaadd6db5,0x2287fe65,0x24ad098d,0x439f8bb7,0x3f63b3dd,0x8dd3282f,0xf53dfb0d,0x5e8721c1,
	0xa9f54b0d,0x2c8f6411,0x2a4f0eb5,0xc3fde50b,0x0617c1b7,0xb0638619,0x8cb71aff,0x5d9dd1c3,
	0x3433f799,0xf7197ddb,0xb2b72e27,0x8da51a23,0x929ff2b5,0x8badd375,0x88f9f335,0x0005b36b,
	0x5695d457,0xc737448b,0x7b8b36f9,0x1b4902e7,0x853dee0f,0x9201814d,0x3ee58d09,0x11b1aae7,
	0x8c9ff6bb,0xc479096d,0x38eb14c7,0x921b77c5,0x7cb35f7f,0x2835292b,0x89e15e57,0x19136ce1,
	0xe053c8c5,0x18f3164b,0xb5796fa9,0xe1cbf1a3,0x3645973f,0xc5972d1b,0xebc9e977,0x771d1e7f,
	0x0a33a8e9,0x11354d6f,0xf2554c3d,0xe48d29ef,0xadb32a09,0x13fd57a3,0xad055d43,0x8743f571,
	0x91418a27,0x3c51c9a1,0x4725ab99,0x7f13ba8f,0x3d419117,0x0fb57bd1,0xfc733515,0xbf75d7db,
	0xeafd93f3,0x8bdb7e2b,0x820b2b59,0xc08dbdef,0xbdadca23,0x2795152d,0x0f75d8c9,0xd025fc6b,
	0x9b6dc24d,0x73e3d6db,0x07a5a597,0x02af6ef9,0xa63df767,0x5cebe7c1,0x41ef3cb7,0xc4458a4b,
	0x550f85ab,0x0afd57f7,0xf317d0eb,0x09abc917,0x2cb3ff9d,0x638da017,0x364381b9,0x21493921,
	0x18e76307,0x2a393e49,0x3603e071,0x24312833,0x654f2dff,0xc1c9733b,0xf551952b,0x071ff11d,
	0x567793dd,0x8d2b1f1f,0xb88d23c5,0x4b75e8b7,0x62d3d247,0xf073beb3,0x0e7dd0e5,0x503d6ae3,
	0x0bbfa625,0xf1e3883f,0x7953a6fb,0x4329078b,0x5681e0af,0x7adda88d,0xb7a79b41,0xb195cfa1,
	0xe5451c5b,0x38f39ff3,0xad7bd2b3,0xb97fc21d,0xb01d91f1,0x1edbbf4f,0xed330719,0xda9558ff,
	0x5e070d79,0x856fc507,0xe0a30c03,0x67273653,0x3de70347,0xecbb9a07,0x920373c9,0x9531f129,
	0xdf89c4f5,0x5ce92ec5,0x14f15487,0x2f550299,0x4ca1d66b,0x6751783d,0x8f772d29,0xe5ddd2c7,
	0xe1cd62cf,0xc7718cf7,0xe305ea59,0x3fbbe5db,0xc78fd197,0xa3efe1fd,0xf5730b93,0x2b892905,
	0x0b557b7d,0x6f99a7e5,0x9a01e813,0x30895f7f,0x58717f85,0x6a6747cd,0x1a5713e1,0x3fa7af8b,
	0x5121b7f9,0xc2750059,0x5f87e4cd,0x24734f71,0x878bcf6f,0x550ba2b9,0xbb07176f,0x96295283,
	0x16b775bf,0x0f956fa1,0x4fb99423,0xe8ab961b,0xdb9bb50f,0xf0ad144d,0x1ae35415,0x5d83ce97,
	0x4e1566c9,0xa90dc783,0x9d39662f,0x14e3b465,0xf9e7c89f,0xdc9d8691,0x23cf142d,0x9ea550f5,
	0x97bf318f,0x036d724b,0xb129278b,0x2b4b6bbd,0xc631e6d9,0xeab14c0f,0x862d4e91,0x5d011741,
	0x62b7110b,0xd5c912c1,0x4b2ba14f,0xb8975e09,0x82b7d0f9,0x3f39bfd1,0xd8dd469d,0xb6890fa9,
	0x0c7f74b9,0x39b12431,0xa1633919,0x73f7adb7,0xf03fccb5,0x7107e561,0xb9432c29,0x03af78d5,
	0x0117a093,0xcb379a65,0x806f90ff,0x5f219dad,0x6e0b4449,0xa96b08c9,0xeb3fbb8f,0xf76781f1,
	0xdb054d11,0xc8ef81a5,0x6b75279b,0xe6433157,0x19d9666f,0xc43b5e93,0x7935ddab,0xbf1feaa5,
	0x8347472f,0x33eb9ebd,0xbc13f80b,0x0011cc9f,0xefefc661,0x6fc5a3cb,0xd40747d3,0x22cda31b,
	0x51611065,0xefbb0ef5,0xc26f19e5,0x4dbbd3ef,0xeb0ffbdb,0x4cdfbdf9,0xf3151be5,0xa4e16bff,
	0x2b557ead,0xe271e819,0xe5296145,0x3af54c31,0x24774313,0x0ed75b27,0x7441883b,0xa24f7679,
	0xa5a55c85,0x14a1d873,0xc161fec5,0x1df17acf,0xf3ed1cc5,0x9b8391df,0xbbf167ab,0x72850435,
	0x235108e1,0xd15bc6cd,0x4abd1f7d,0x575f85b3,0x0fb3ee2b,0x2b31812b,0x1503e193,0x8779075b,
	0xf5dd173f,0xc633726f,0xeb5d8d0b,0x72751345,0xac87a101,0x68b7f095,0xd0d909cb,0x8d9bc295,
	0x7d4def99,0x23391323,0xa3e34d85,0x44e1ea73,0x9daf437d,0x9163f029,0x675780af,0x8bdd690f,
	0x481f6e67,0xbb01f937,0x2b714387,0x0ed592a3,0x74eda85b,0x9509786d,0x96dd1315,0x03b3be71,
	0x335584a5,0x229b2d71,0x0fabce29,0x9b07f3c1,0xa27f06d7,0x35fb0a6f,0x84515a5b,0x110bb6e5,
	0x8a75d7cb,0xd199111d,0xd4af6909,0x5ea5f637,0x952b9aa7,0x290b4fb7,0xdb0f5c59,0x8a5b1717,
	0x277f61d5,0x420ffe03,0x15214c3d,0x996122ef,0xda334409,0x358bba4f,0xecfd2b6b,0x20931431,
	0x92f3113b,0x108fe66f,0xa2250c61,0x75714353,0x3d5527b3,0x554d24c1,0xd27d8667,0x7f25f3d9,
	0x23d568f9,0x1c29f529,0xa3593a8f,0x2783014d,0xe8d74ee1,0xd4a37217,0x8a7178ab,0x6c05ac3d,
	0x1fa72087,0xa66f2d7f,0xb6e3045f,0x0ecb8745,0x8579474f,0x725f2ddb,0x1a39fa11,0xe7a18407,
	0xda6bc3e1,0x73750b35,0x1163d3ed,0xd4f92029,0x5a7fc333,0x7fd32c19,0xadb78eef,0x4cefb25f,
	0xd6a35381,0xe9cb229b,0x9df9efd3,0x8e43d75f,0x6da9394b,0x00d12959,0xb751e823,0x715ffeef,
	0xe54fe45d,0x3285c077,0x1e4b1b2b,0xd95718d5,0xa33984cd,0xcbab6aa5,0x0fe38305,0xc4e361e3,
	0x45f33ff5,0x59338a15,0x4a79358f,0xff6750f1,0xddf38577,0xa9335d87,0x16d5496f,0x71efa3e3,
	0xc691843f,0x6be91d3d,0xf125db17,0x14298c9f,0x1f17bf7f,0x74b93809,0xd20531bd,0x7d71fe19,
	0xe3abc3b5,0x9b37b03b,0x1771045f,0x15cb1949,0xa667fba3,0x3c1398b5,0x0dd5dec5,0xe6dfba31,
	0xe843a553,0x5a2fb1d9,0x18ffa681,0x0d0124d9,0x1225e719,0x5f912695,0x7d293fe5,0xc829d253,
	0x0ddb0491,0x7e65695f,0xc7f15315,0x2cfb5db9,0x7f15b39f,0xb2033135,0xd96330f7,0x75c1912b,
	0x9c73916b,0x5feb9699,0x8cebd839,0xf36d92d3,0xa879b76b,0x98bf509b,0x02631a51,0x9e9b31e1,
	0x0a8f705b,0xf94f11d1,0x870be083,0x4889538f,0x080f0d3b,0x2b930555,0x1e8d90d1,0x6c25801f,
	0x1d33da59,0x07a96bcf,0xabf7930f,0x9f018fdb,0xf61d3447,0x54d5586b,0xbac1f5cf,0xa2557811,
	0x07dbbcdf,0x2a858ddf,0xe7cd3375,0x1405381d,0xc963b047,0xf1537b67,0xea631727,0xbf9be65f,
	0x8c8f59e9,0x03fb59cb,0x3d33c1d3,0x8f49dd41,0xf725a979,0xf0616855,0x6755cf31,0x1ce90835,
	0x1bcfe7f1,0x589749db,0xe5479abf,0xe2ff50b1,0x33238c95,0x73d381bb,0xb1f7a4c5,0x0db32b3b,
	0xf49b31ef,0x2f7110db,0x6faf1755,0xebd74457,0x8f9faad3,0xeff732a7,0x312b6b43,0xffe74d9b,
	0x4477375d,0xf2153a13,0xe28b2d2f,0xb105ea9d,0x9d5bd9f1,0x4ba18e9f,0x5257e27f,0x9bfbbe01,
	0x4767cc37,0x8c99c94f,0xda7d0e65,0x843b966d,0x8b9b1427,0x0023f1b1,0xa95756d7,0xe4dfbb95,
	0x67e738f7,0x8d8fdad9,0xaaa7c993,0x21ab5b31,0x481f182d,0x394fa065,0x10934123,0x58051601,
	0x5effda95,0x46074379,0x7cabe9d3,0xd005acd1,0x9f2b0941,0xf57767c5,0xc8e9e6bd,0x0d61cd71,
	0x542fc28d,0xe993307b,0x70ab16bf,0x807dffbb,0x5b7f0f1b,0x256d3d5b,0x99bbf981,0xd763b28d,
	0xfd7756d7,0xae47c7a9,0xbd49b471,0xeec368d5,0x665df5f5,0xcc83df33,0xf0ef37c5,0x62fb0681,
	0xbf5bf1ef,0xecb3c74b,0xcfa98381,0xc10d3d8b,0xe787ce87,0x208b73d3,0x02e10c69,0x57a11af5,
	0xccdd82cd,0x3feb262d,0x6b69410b,0xa809b3c7,0x65418e0f,0xa9d72a49,0xea792ec1,0x7741f215,
	0x477f2ceb,0xa57fb399,0xcaaf46a9,0x7eeb81f5,0xe44bae45,0x6339da1d,0xc91342a9,0xbe4fde89,
	0x5f43e847,0x9d83b757,0xbe192a73,0x6b637ef9,0x07e9cd63,0xda03a357,0xe697787d,0x83bf237b,
	0x72a92155,0x4a8791b3,0xcccd5f07,0xfda54243,0x31db4e23,0x4e078e87,0xd1632d15,0x99019495,
	0x2eb75913,0x919f5b77,0x546bd37b,0x5063c3bb,0xa263f7bd,0xd1952cb1,0x7e5b89cd,0x6a073603,
	0xaeebc4fb,0x3a5b85eb,0xa913936b,0x28cffbcb,0x984395ef,0x69833761,0x68df247d,0x1d43dc6f,
	0x9d49ef05,0x0ecd7adb,0x356b66f1,0x1699835b,0x70bf98f1,0x2d1f30a3,0xb2d39f7d,0xb3a9cd01,
	0x525355ad,0xfb893c8f,0x9a9372a5,0x93f533d7,0xc797b57d,0x663f02fd,0x449749ad,0x28a75d63,
	0xf5090bed,0x2f9f05d3,0xd02dd7a3,0x2593c72b,0x970f84cd,0xb131a17d,0xed0fbe61,0x923393bf,
	0x9af1593b,0x3ca3e9f1,0x445b5385,0x7aa977bd,0x57e5249b,0x1ccba7ab,0x819b8577,0x40bdc6c1,
	0x68095997,0x36a774b1,0xfbbfe065,0x8ce5a079,0x215fd721,0x4a5bf991,0xfe1fb347,0xdf393d93,
	0xaed59d75,0xd4394a5f,0xb17d54db,0xc07b5cc9,0xc93fa319,0x8db763b9,0xa4fd88ab,0x9315cfdd,
	0x1057c9d5,0x8e71c7c5,0xf7330405,0x041b2897,0x03c5f3bd,0x0d2d3b2f,0x1f1512ff,0x1c4785c9,
	0x9c11382d,0xc0dba22b,0x55055d79,0xf0f9804b,0x83b338c7,0xe191fd79,0x9bcbcc19,0xf53f3801,
	0xf0059677,0xc98d875d,0x69978d51,0xeac780d3,0x1a4b8671,0x3635f0a5,0xf1013a57,0x72ef2fb1,
	0x58b3872f,0x2919bda5,0x0a071c2b,0x3fb78797,0xd7513575,0x68edc339,0xbb179093,0xe4c9c683,
	0xf11f414d,0xa28fc3cb,0x61fb8f1d,0x4879d27f,0x2905830d,0x2a072c43,0x7cef4e23,0xb4c1069d,
	0xc2cb304d,0x5b81f11b,0x139307c3,0x88411ff7,0xfc2930f3,0x9c578b4b,0xbfeddee5,0x87454aad,
	0xe5b99429,0xfc03155d,0x5771e437,0xccc14ee9,0xdc012561,0x752f885b,0x33f33b31,0x5b4bdddd,
	0xa06b2159,0xcea718dd,0x1cb55f13,0x4e29febf,0x124d0b11,0x1c61b3ff,0xcf6187e3,0xaa439bd5,
	0x87e3a0d7,0xe07b9c65,0x29052f6f,0xcf2d2f63,0xc74ff13d,0xcc3f273d,0xef1bb651,0x882190bf,
	0x9fa1901f,0x2117993d,0x388128e7,0xbcffe13f,0x21cbeb9f,0xb19b23a3,0x76832459,0xc3539947,
	0x79a9c12b,0x82870131,0x1dcddb95,0x4f4fb53d,0x6701b273,0x0bc5b339,0xef793c53,0x04cf0295,
	0x567dfa73,0x19635e8b,0xe2073413,0xa8538cc7,0x1ab5426f,0x4c934887,0xaa5f151b,0xf0052a53,
	0x451f96f1,0x3cb77413,0xe4d31b79,0xf4b929c5,0x1f257ccf,0x38555e9d,0xde191207,0x42e71ead,
	0x43112621,0xa619dd15,0xfc531765,0x8bb3cea5,0xd517c74d,0x05dd18ff,0xc80982f5,0xf5e73e4b,
	0x5c550bfd,0x919bad5b,0x952be9ed,0x0ef7de4d,0x3bcdac23,0x7e7be3b9,0xcc0f443f,0x5bf9d859,
	0xcb6b20fd,0xddcd112d,0xd27931ab,0x8ab37c29,0x11057a0b,0x1e051355,0x948f5ebb,0x428dcc7f,
	0x1957521d,0x2bc1ed57,0xade309bd,0x95992c23,0xf105e441,0x32c984df,0x326ba7c7,0x11952ae7,
	0x3d9b40d5,0xff0b7f23,0x1789a9b9,0x70df72a5,0x768fa27b,0xfd9d3ddf,0x3d03613b,0xeb83d43d,
	0xbe39e31f,0xddbdfc59,0x160b05bb,0x28337499,0x5ae110f5,0xd1cf0c5f,0xf23bd971,0xcd4919a9,
	0xcfb32377,0x70653345,0xe68f6e5d,0xb1c99769,0x95c1d069,0x353526e9,0x56730b45,0xae5b5cd7,
	0x750980d7,0xa21b2aaf,0x1cb530b9,0x0e5120fd,0x7d716613,0x001dcc87,0x548f3e0f,0xa0a7afef,
	0x9fc1aeb7,0xc06bc1e3,0xc29f3667,0x68ffd7c3,0xe6afdba9,0x7d5de4c3,0xddefa5a9,0xf0a3759b,
	0x4fd93513,0x9b6d50ab,0x78efa583,0x3785a2a1,0x44c15f67,0x8a439fa7,0x0a77026d,0x45410107,
	0xb3d51063,0xa5ad474f,0x96c780a7,0x5a152905,0xc969e409,0xb6a315bf,0x38894137,0xbfef35db,
	0x48b751a3,0x1441ce9b,0x49c946eb,0x3b5f72d5,0x84e5c0c5,0x64cfe813,0x2d051b5f,0x1ca12843,
	0xfa01be4b,0xfebb67d9,0xb61993ed,0xf097887d,0x85fb5157,0xe999e02d,0x334db6bf,0xd1cbbce5,
	0x41b37057,0x7f2b8cd1,0x1655bfc3,0x596f12e7,0xf9eb95fb,0xac539017,0x3d4745b1,0x305d48f1,
	0x4851763f,0xd2234fcf,0xdba17f09,0x4019fb7d,0x4c79d367,0x46cff25b,0x034fa711,0x83c9320b,
	0x04df72ff,0x76b7fb9d,0xcda182d9,0x79450c29,0x47e532d9,0xa55f0a03,0x244d0637,0x32038e63,
	0x5cd93e0f,0x4e79b383,0x2a7518cb,0x04278f53,0x34f16207,0x26d58299,0x459f7afd,0xdb79c49d,
	0x4447836b,0xbd77134d,0xc6bdcafb,0x2a6fefe9,0xfae1332f,0xbc835029,0x3329a9bf,0x7b212be7,
	0xdda9638b,0xca49cf43,0x2d9f0003,0xa0515951,0x3f753d07,0x0a3b4f3b,0xff4b6353,0x866babe9,
	0x99ff136b,0x3dfb5431,0xc0bb9afd,0xa47f5779,0x86ef7acd,0x864fe4d7,0x22e74517,0x0d495ccf,
	0x58cf7c85,0xc4236761,0xd8339b83,0x202b76c7,0x5413ec37,0x99919e8b,0x9d6358e5,0xda2f2741,
	0x8817dccf,0x0ad3c69d,0xe2a9bdad,0xc707e427,0x48213583,0xbf51d261,0x149db513,0x920b6469,
	0x445b66c9,0xe29bc82d,0x853f1a17,0x37430d03,0x42db3f67,0xa5653edf,0xf4f71c7f,0xd4537df3,
	0x789de169,0x5e8ffadb,0xbb97c5db,0x19913f45,0x8283d721,0x4c1dab11,0x91559e81,0x5af78e07,
	0xfe5d4829,0xf43fc5f5,0xf7d37291,0x41274957,0xc3dd4e67,0x26498683,0x431936f3,0x1a69ff51,
	0xbda16b05,0x9bbd0941,0x42950e57,0xcbb31a21,0x62291b77,0x393f893b,0x8a236e31,0x619d2cf9,
	0xcce78e77,0xef9dbd09,0x5b0163c3,0x41696111,0x772b7907,0x3ccd53c7,0x2cd7f913,0xfa0102a9,
	0x91330b77,0x4cef921b,0xd6b5b9f1,0xb4fb2e0d,0xfb230655,0xbb490f2f,0x581558f3,0x478b9c8d,
	0xde07ef7f,0xf34791bd,0x41d77479,0xe3999183,0xe4d36719,0x31810cfd,0xbf417bab,0x68abe74d,
	0x15659c8b,0x24b5bdb9,0x3f05b379,0x54f73c59,0x497fe38b,0x2ec9673d,0xbc3d5b97,0x56554015,
	0x47cd6915,0x45cdb05b,0xa765f387,0x7b471ffb,0x7ce50869,0x74f5a075,0x6f699f8f,0x03f7148d,
	0x54454015,0xfd9f3c6d,0xaa97adbf,0xd3390e53,0x314d46eb,0x185343b1,0xdfa73aed,0x7f8782df,
	0x084b4105,0x55bf0d39,0xeebdf7bb,0x040159cb,0x977394c9,0x9fb7847d,0x1a5d0d8d,0x1173f9b7,
	0x3fe35fe1,0xda3d4687,0xb0792393,0xff51754d,0x7e9d0c41,0x2473dee1,0x536983c5,0x5cb3d83d,
	0x058f0523,0xb9ab24a1,0xe2ed5fe3,0x21599441,0x748b8c0b,0x7259b767,0x052d3673,0x7eb30e1b,
	0xb24fadc3,0xe51d9c55,0x4fbb57c5,0x50cf4a95,0xe581575f,0x27bbfb19,0x108d8af1,0x2f67bb7d,
	0x0da98b3d,0x3025fae9,0xb705d2d3,0x1ee12caf,0x3c3fb5fb,0xd56dbf81,0xdceb5315,0xe143d10d,
	0x6d9b2389,0x70d18629,0xef6d5527,0xe7416f7d,0x02079417,0x1ebbe2ab,0x78276d3d,0xe137aff1,
	0xd6abf121,0x9fb91c5d,0x0615bf59,0xf0258865,0xfe9b226d,0xd97dab1d,0xb6a36441,0x76b5c9d7,
	0x1bd70301,0xf7ebd451,0x5ea1ee85,0x8a3bcd53,0x583f7635,0x2e0367e5,0x53450f7b,0x03af40e9,
	0xfea39ca3,0x16f99d4d,0xd32f5c45,0x30b514b1,0xb3b3292d,0xb71f108b,0x0f6b32c7,0x249987cf,
	0x4f0fd5ff,0x1cf5df1f,0xd465beb3,0xa9495569,0x543bf98d,0xa223e517,0xd2f71e7d,0xd06101b3,
	0x0ba13b91,0xcc751a0d,0x8961a867,0x242546e5,0x3b956a0f,0xcee10e19,0xcc4d4f77,0x787da241,
	0x81576e51,0xaa8586e1,0xefc9287d,0x5bfd010f,0x4a0961ed,0xefa93c95,0x904f0f0f,0x28dd8da1,
	0x6bb5c3bb,0x1ebbb6e7,0xfbbd6a8f,0xb6019c4f,0x5e53cce1,0xa9514a17,0x3a5d1321,0xa7f3b87d,
	0x14bde5c7,0x932933e9,0xb7df56b7,0x61e7d193,0x75b93b25,0xb327d8ab,0x8c5b1e05,0x96b38801,
	0x74f172f1,0x945f202f,0x6551318d,0x79dd9a41,0xcbfb8171,0xf701f2d7,0x0ea99e95,0x908d71d5,
	0x53539e31,0xf16fd685,0x9bb53c2d,0x2295d045,0xfb5b5903,0xb12daba9,0x302b502d,0x4b719c25,
	0x6563cf03,0xdbed8a35,0x692d5431,0xab45ce0b,0x1c9dff93,0x9081bea9,0x6641daa3,0xb7d77d99,
	0x6f25415f,0x07e9e709,0x725b93b3,0xad9b0e79,0xe701d75b,0xd64b2fe1,0x4cd17255,0x20ab7d5b,
	0x631da5c1,0xcbf7b149,0x1261f14b,0x2dc9ccfb,0xd04b0715,0x7661ebdb,0xc637781d,0x4b619317,
	0x8249c123,0x412765bf,0x7ae3e017,0xba85a579,0x2cb919fb,0x371167a1,0x1b591951,0x97ede6f5,
	0x7c2b0cfd,0x630dd9b7,0xd3ffefad,0x8cfd3461,0x4f139fc7,0xd12f40bf,0x1b99efcf,0x20bf719f,
	0x8ec95749,0x2fb9dafb,0x5c5b6c27,0xa8e5b69b,0xa895ccb3,0x100ddd3d,0x3cd9a1ef,0xdac99c41,
	0xa6a16283,0xc7bdcfd5,0x8915fe23,0xfc6da98f,0xe9051979,0xf17f0ba3,0xbb79828b,0xb57de085,
	0x7eb985a3,0x8e2d570d,0x25d34ab7,0x804b6b2b,0x1ea3e353,0xc5d3a2ff,0xba5b30ff,0xbacf6891,
	0xc08f4c25,0x489be7ef,0x74b3937f,0x57add9d5,0xd6310bfb,0x4fdd22d9,0x62e33923,0x2f2faf15,
	0x24271603,0x3f177245,0x4e5b5695,0xf045f479,0x3af399ab,0xe4ef533b,0x04f3b351,0xb18d1f35,
	0x9003b7b5,0x5c33fe57,0x41ebee93,0x22497a81,0x36a9571f,0x8cdbe4b1,0x36ebe463,0x5b61b49f,
	0x39231a35,0x4d034cef,0xb5053291,0x50678bd7,0x9195738d,0x21f31041,0xf5afddb5,0xe0979b7b,
	0xc30ddaff,0xa117775b,0x03cb162b,0x87d348e5,0x127b22b1,0x71093779,0xc4a11d1f,0xafa3d075,
	0x5fbfec0b,0xea838f61,0xa0df497b,0xa03d7295,0x9e9b3cc5,0x596d8461,0xcda12cfb,0x1179c0b5,
	0xefbd33d7,0xddd73f4d,0x3563d91b,0x5bd90a4f,0x59b7de83,0xecf58981,0x01114423,0x4989e9e5,
	0x22092d57,0x722769e7,0xc0fbce23,0x8759f201,0xc6130925,0x8ff1e1e7,0x35d7e5f3,0xb5c57a31,
	0x94258809,0x0103ca7b,0xb9c5ce31,0x19ef8c11,0xe46f4265,0x1933d11d,0x494f8243,0xeea1f041,
	0xf211c7e7,0x667d94d1,0x2c65bb5b,0x554b5b6d,0x540d347f,0xf20be329,0x3f61156d,0xe70bbb41,
	0x1651e569,0x21291537,0xdbff543b,0xe5a1a37b,0x72b14e29,0x364f8c97,0x626bc84d,0x0c79dad9,
	0x29e9ed89,0x72195073,0x6233d3ef,0x01a30827,0x7c9b629f,0xd44fca73,0x634f903b,0x66db7f33,
	0xc457a1c3,0x7cdda3cf,0x4f21920d,0x8a812ddb,0xac8f499b,0xacdbc245,0x7971cf11,0xb8a3a8fb,
	0x0b9f1811,0x67876517,0x496fa2b1,0x2bf15981,0x5bcb7f59,0xb3476217,0x82b3f329,0x9ec3c959,
	0xd4415aeb,0x7aab8295,0x2e3d7675,0x7c1f1081,0x2215c48f,0x0d670073,0x2375175d,0xb0af61f9,
	0xc143094d,0x41592313,0x312d7a73,0x1bc3b8c9,0xf5adbe79,0x3389fc63,0xe69ba309,0xa057a503,
	0x6423f6af,0xa92545d9,0xfc61b843,0xd60b38c1,0x4b5796d1,0x10835d71,0x5d85ea05,0x5a2d1521,
	0x5ce5cb0d,0x221f62b1,0xd07b7601,0xc0ab9751,0x36539bd3,0x21a373a7,0x4017ccad,0x2523257f,
	0x7a0ba2df,0xbedb09e9,0xa49dd647,0x5bd59be5,0x8863e035,0x96bd7791,0x8cb357d7,0xc2abd9c5,
	0xd897af21,0x54698447,0x4669782f,0xb2396e69,0xf1cbdb33,0x72232a37,0xa83964e1,0x8eb9661f,
	0x040bd54b,0x9a5b7315,0x7a011751,0x790b3743,0x214b0889,0xa8a77523,0x7e0b39a3,0x9fbdcf35,
	0x16674f59,0x4ac57021,0x1a092bc9,0x2ffdbf5f,0xe425886d,0x419b0a5f,0xa00f2879,0xe6a98a31,
	0xd8314bc3,0x4239adb1,0x379f8a31,0x413f1025,0x461dbf9d,0x76d30475,0x66a33039,0x4eef1cbf,
	0xe0678d85,0x9fc7968f,0x3a6903a3,0x21871383,0xb173f74f,0xd49d866f,0x10a99c41,0xde81bd07,
	0xb48d0c17,0xe5016e07,0x008505b7,0x700133e1,0x0ee9fd3f,0x59cb5bd7,0xe385a46b,0xd5d3f1b3,
	0xe8a59375,0x15fbefe3,0xfe993a89,0x1665fc27,0xe5c3c3a9,0x97b398b9,0x4b190d0d,0xcfd331ef,
	0x3f2f6417,0xd945f06d,0x5fc528b3,0x68e1b7c3,0x7bc10143,0xd225399d,0xf9c5c705,0xe1f78563,
	0xc931d2f9,0x97f3fc6d,0x25a9d34f,0x4629129b,0xf525d14b,0x1f73c38b,0x086d8fab,0xbc31243b,
	0x0629e993,0x9d95f92f,0x486b59f7,0x376fb91b,0x74b15377,0x886fe411,0x167190d9,0xc8ef171f,
	0x041b05e1,0x383fc47b,0xd6ab98c3,0x9063f82f,0x3ba94c05,0x28691139,0x69b500eb,0x4d27d73b,
	0x7f897a5d,0xd881d49d,0x158bc84f,0x8f395d3d,0xc9cfc3ab,0x4d372989,0x0e99c2b9,0x8847ee35,
	0x03752dff,0x316dd85f,0xa0af1db5,0x7ca3562f,0xfd61a7a7,0x9729140d,0xf801059d,0xd445963d,
	0x09613c41,0x58975709,0x8a356a8d,0xcbd3d173,0x332569b1,0x190f6051,0x1f4fe571,0xc59359f7,
	0x194d951f,0xe6115067,0x7ac1bcf5,0x3a79ddf1,0x665ba001,0x783fe65b,0xa4630a91,0x4b1fb491,
	0xe9bd9d11,0x1469dcc3,0xd175ff83,0xf0c94b11,0x50c7a555,0x0c8766b9,0xeda149d3,0xce5fb1b5,
	0x7fb3cd13,0xe0b7cce5,0xc3f59953,0xa17348c1,0x8aa938e3,0x003d2a73,0xc7e94497,0x53438d89,
	0x4eb1529f,0x2a894a19,0x7e5f0dfd,0xa9ad0767,0xaac31e69,0x702fa313,0x869f08b1,0x983d54bb,
	0x58b9afad,0xd3f17629,0x43599d9f,0x312557f1,0x6659be1f,0x8bb10aa5,0x23a5b07f,0x363f8475,
	0x4e4d5ab7,0xe1810b5d,0x8c03e4cf,0x4a0d4bc5,0xb129c4bd,0xb49703af,0x5f5b02d9,0xc0bbaa5f,
	0xae6d5eb9,0x9a4ffc81,0x27fd7ca9,0x111bd4cf,0xdd7bc381,0x9f2f393d,0xe0a51319,0xe5a504a3,
	0xe69dfb2d,0xa7e714dd,0x5d6d9ac7,0xcd7d6579,0xbc0bd023,0x724dfedb,0x54e3e119,0x8d6d21ed,
	0x72df440b,0x365f983d,0x08f3b141,0x10e790ab,0xbc1f24db,0xe743f091,0x8ff9f935,0xfb058165,
	0xfdb5c1cf,0x1449e2eb,0xbdb10eb3,0xd789a9d3,0x0b77c067,0x69e392e9,0xac471445,0xebdf32b7,
	0x80211171,0xd2b509af,0xe5497e37,0xa81764d9,0xb65705ff,0x3881f2ed,0x2ab1b7a3,0xb7ed760b,
	0x61a3846b,0xe53579d5,0xdfdfe767,0xb3c37625,0xc77d5d5b,0x83eb4627,0x1299d52b,0x71a35c0b,
	0x9841c0bb,0xc1dd9927,0x2411ee5d,0xf63f32a3,0x6831d2b9,0x8f738aa3,0x11df6b35,0x05f165e3,
	0xc87960d5,0x013d65ed,0x5f0393b1,0x55bb2fbf,0x002fb6d1,0xd0ef26e7,0x9ce7249b,0x5c49253b,
	0x654f93b7,0x7e6916f3,0x9457d47f,0xc2ebe35f,0x55bd3edd,0x10af8a01,0x0e91f8b7,0x769ddc3d,
	0xd045bcdb,0x76f1bb83,0x3e314a61,0x590143ef,0xad9b2497,0x8985cb77,0xc841cb65,0x91611d95,
	0x795d1439,0xaae9db65,0x6d2fcb71,0x7daf6859,0xeb0d4637,0x08c34b57,0x51d70cfb,0x43836c6b,
	0xff17464d,0x7ce116e5,0xe8770a47,0x01252807,0xafd1467b,0x0e3b5229,0x79b75a59,0x9e79dc6b,
	0x4e77140f,0x11edc6cb,0x4da935ff,0x3e17bae1,0x7c2d2c9b,0xec3db0f9,0x74c31cd3,0x4e33b1bd,
	0xc301f2fb,0x719d9c65,0x30e79a33,0x39b55955,0xcee30451,0xe79f614d,0xfe5b2a47,0xb925010b,
	0x46b3ad09,0xa6034177,0x3cd13efd,0xc3b3dc49,0x45337dd7,0x57af2533,0x7863650d,0x203d4f81,
	0x720f00b5,0xdbb3f851,0x528d88f5,0x96435d2b,0xbadf8de7,0xc6432731,0x0b3b5bff,0xbef132c7,
	0xac1b40f7,0x81bd3bb9,0xa9bbd937,0x7617d5e1,0x6a290dbb,0x0fab9a55,0xc5c7ea77,0xeb31f109,
	0x4a57f54b,0x69b55efb,0xf07d2d5d,0x525fc0d7,0x0bd55b0d,0x82b75a27,0xbd69d851,0x356f20ef,
	0xb0c379a9,0xe7ad2ddf,0x6b77bf81,0x64cfb8f7,0xf723f817,0x00bb8ab1,0x2e0179e5,0x889d49a3,
	0x71e39e8d,0xf2338cb1,0x15c7a63b,0x519919ab,0x41d72b93,0x1d8b387d,0x99f1500d,0x4a2f82d1,
	0x6eb948ef,0x425f183b,0xc11174a9,0x476f9edd,0xe02fa0bb,0x3f75f895,0xea1fa825,0x7a1314a1,
	0xf6c7124b,0x73bdc5c5,0x3579da61,0x1f8104f7,0xc4f10749,0xbf4d8885,0x8de73c03,0xd2bf17bf,
	0xe80de89b,0x2463831b,0x519d437f,0x7d83a8e1,0x015fb377,0x08656e55,0x9b31d207,0xe9231553,
	0xcf11ae57,0x14e3d685,0x2aa3789b,0xefa52809,0xe5393dff,0xb891988d,0xee5bdd05,0x4cb3a707,
	0x06d1da79,0x484d7ed1,0x2c293ed1,0x0e9d0055,0x1ec1241b,0xc01ffe3b,0x4a471c59,0xa75d1707,
	0xd8d1187d,0x24331343,0x3855f7bd,0x9d993033,0xdab96785,0x81e33ee7,0x785b3bdf,0xdd97fffb,
	0x9d13e85b,0x90a9a3ab,0xc7c74173,0xaa4bd689,0xe4652e77,0xf32f429b,0x687373ef,0x2e51ed0d,
	0xda193e8f,0x1841584f,0x09a19693,0xace9d2c3,0xc58563ab,0xbbd5d9e3,0x50f72965,0x52fdf9e9,
	0x64e52413,0x080911fb,0x0385ee33,0xa82164cb,0xe65b565b,0x56275dc5,0xcec38d97,0x9f8d72b7,
	0x80f7565f,0x8f9909f7,0xb1955bf1,0x4927cd0b,0xadab5a41,0x2ef74fcf,0x053f3e63,0x22757423,
	0x0053e76d,0xe0ff720f,0x2673afe1,0x07abec6b,0xa0b56797,0xc595fa09,0xbe49e621,0xc4a38b55,
	0x637bddb9,0x50cd148d,0xab4116a3,0x45e1e459,0x833bbb17,0xcbd70efb,0x8a43dbad,0x698d55f9,
	0xf971d43d,0x7615f439,0xdfa1b94f,0x707bb6bd,0x778175fd,0x460d49b3,0xe013c25f,0x0f252235,
	0xffb79a71,0x4a6bec5f,0xd9b75d7d,0x1eabe5ff,0x1e473dff,0xab090dbb,0x3d152a11,0xedd98eb9,
	0xc24dd44f,0x49e150c9,0x46210549,0x3221150b,0xb6cfdd59,0x041b0719,0x45312f1d,0x989d2aa9,
	0xbbb99a55,0x93078dbf,0x88058f4b,0xf711a74b,0x3edde2c5,0x0d19ca59,0xe2c51a5d,0x1ce515b3,
	0xb4f91977,0x06efc80d,0xd90156a1,0x442d60ab,0x92b1417d,0x54537487,0x66b3012d,0x22a1a001,
	0xe5913333,0x692d7cfd,0x693bd2e1,0x9aa5058f,0x8d0df13d,0x5a994b2b,0xa85f6565,0x0c43ea39,
	0x13831d83,0x7fd32257,0x7f533827,0x462dfae7,0x27358e3b,0xb33f5c4d,0x25abd55f,0x16bf858b,
	0xb35102df,0x3371c667,0x9869170d,0x7cf7e61b,0x98e9f933,0x24191e7d,0x22f78bf7,0x7983139b,
	0x07fba243,0xaf19aff5,0x8823fcad,0x7fb54d15,0x786bf75f,0xc57510bf,0xcb271085,0x8685e697,
	0x4307ef27,0x805dfe4d,0x98a1129f,0xb997363d,0xda7fd27b,0x22295a9f,0x4f9bd6e3,0xca35a129,
	0xa473b187,0xb7534939,0xaa85beff,0xe051c881,0x7265f8bd,0x57836c27,0x0837df6b,0x2b85d677,
	0x9ac325db,0x06874101,0x54f14467,0x1415eb47,0xb1df9ce1,0x35579de3,0x935d56f9,0x0be7aa2f,
	0xe2f99d1f,0xe30f4e71,0x058961f1,0xff93e67b,0xe9315623,0x5df7d0db,0xf5ed36e5,0x674f707b,
	0xa8951ccb,0xa47d32d3,0x206bf335,0xf7ff0287,0x671bc039,0x66350e97,0xbb4be509,0xf42d4e03,
	0xa59dfedb,0xa4e1a7ef,0x203b904f,0x1d0b2855,0x98df1b61,0xf5632925,0x1557d3bf,0x4373d7f1,
	0x428f91c7,0x60cd0011,0xb61d2dd9,0x78e7814f,0x2a41ec51,0xe5555b0f,0xfc7521e3,0xe093b3f1,
	0xb66fb88b,0x9755c603,0xe9afbced,0x2047175f,0x25819c45,0x6259e75b,0x4f853acd,0x717f382b,
	0x26bf8a9f,0x6a0b5d0d,0x3917cb23,0x525d74ef,0x136118f9,0x0b41b995,0xf3eb7657,0xd6ab0b49,
	0xc781f3ff,0x7cfda0fb,0xb8f32299,0x98db44e7,0x1b2574a3,0x116305c9,0xf589b8dd,0x4b07c477,
	0xfb375523,0x16c38615,0x346969e5,0xe7f1f2b5,0x228d8601,0x588fe87f,0xa6bf1335,0x84058b5f,
	0x72e12307,0x4069b927,0x4d19c421,0xbe534a3f,0xeddb8849,0x971706bf,0xc07162bd,0xd197b827,
	0x4e038723,0xe5853f7b,0x9b2570eb,0x453317f1,0x3fd1bb39,0x75cd2e17,0x81fff14f,0x3e2f737d,
	0x3aa1ff73,0xf42916db,0xcd2f6c59,0x7041c8b5,0xf9b30307,0xb001f48f,0xd14d1541,0xaec1568b,
	0x9539fe71,0x7ce5d58f,0xc8590f07,0x1db109f5,0x3b438871,0x338958b3,0x5abbd171,0x02bd0af9,
	0x88cd8b13,0xd2cd4a61,0xc845ae0f,0x3635699b,0x82bf58ad,0x40b56189,0xb12d7537,0x3415eaf1,
	0x2ee3e0d9,0xab711c9f,0x7f153b0b,0xccfdf611,0xcced0579,0x8a55be9f,0x6e053c6f,0x773ba11d,
	0xaf790fb9,0x3ee36c0f,0x356de413,0x3fbfde41,0xb50d450b,0x55bf67fb,0x5123ef6f,0x5b21c8a9,
	0x61159c2d,0x67b770fb,0xea6bb3c3,0x56a71193,0x94e39221,0x9ac13e2b,0x60eb8315,0xe93b8d3f,
	0xe8b51f31,0xc2fd1c31,0x73b53135,0x646ddff5,0xa4afcbf3,0x23b1aa37,0x0a3db8b9,0xc5794b07,
	0x59dde63f,0xd049b6f5,0x9d690003,0x663f99cd,0x1b33d639,0xad5d3da9,0x407dbe37,0x4e4d2eab,
	0x568d934f,0x11ab8317,0x4a2d8045,0x23d13007,0x4db13931,0x0719528b,0x9d8dcde5,0xbca9d555,
	0x2f4bbcdb,0x2bb75add,0x931f6e97,0x4f55d40d,0xcfedc193,0x32b9ab69,0x81cdcea1,0x4401ecb1,
	0x03158ddf,0x057d5113,0xe7e58413,0xa57d97c9,0x94272097,0x848b1349,0x3421f3c3,0x3243d2e9,
	0xdf7165d5,0xe8915103,0x2e9f1653,0x0d790da5,0x0b238bfb,0xc363fdb9,0x01e95d27,0x0fe536a3,
	0xe05d78b5,0xa103be75,0xe3efb76f,0xb8fbe88b,0x44215df7,0x489326c1,0x5f09b725,0xbfd7b70d,
	0x505d6ef9,0x9d6515b3,0x3af7d605,0x44399be5,0x0ce3b543,0x1fed32eb,0x05e1da97,0x9f8b83d1,
	0xc871059f,0x0ecb8b8b,0x3d595d2b,0xd5e1fb9b,0x11ad151d,0x27c54f41,0x17556cd7,0xa6f5fd17,
	0x501fae1b,0x08c7ad43,0xeb37547b,0x3f27dc1b,0xfd3d053d,0x30e9d14d,0x3ac77fbf,0x88835389,
	0x7d652e6b,0xa16700a5,0x5b338013,0x1bbdb24b,0x98dbb1dd,0x1eabd719,0xbe1731ab,0xd12b2853,
	0x94c74109,0x1143a3ff,0xda710089,0xf1d33397,0xec438bb5,0x06e1e731,0xb5a94d73,0x085d2d1d,
	0xa94734ed,0xd369ee17,0x0c8ff2f9,0x521df5eb,0x5dbbe803,0x51db909d,0x1c5dea73,0xd00dc411,
	0xbc678d93,0xc56b0e37,0x0bb310fd,0xf7cd0fad,0xd203a07f,0xda6b0ae5,0xf3970c81,0x04a99fdb,
	0xde29a2f3,0x475bac2d,0x887b50af,0xe893b7c9,0xcc5db363,0x0de3d617,0x633743fb,0xdd2763a3,
	0x4d0d4189,0x5bcf883d,0xea0d84a7,0x94a3e5a7,0x8e8de369,0x0c155abb,0xd9a14db9,0x0af74315,
	0x96194a4d,0xc7d31b37,0x6e07fc01,0xf6aff135,0x38d357c9,0xc75189dd,0x2bb7b317,0xda0ba259,
	0xb4cb52bb,0x32fd3661,0x488f2257,0xb3e932db,0xe9f33c41,0x246d7d03,0xb4d969eb,0x50d5b619,
	0x332744cb,0x475fa387,0xc4451fc3,0x3c01a381,0xdf2d6109,0x1ab71639,0x76eb7493,0x50472381,
	0x49affef9,0xd189c4f1,0x624b78dd,0xe92b7c95,0x9443dadb,0xd405a00b,0x3a4d81e7,0xb3d5a039,
	0xff63f43d,0xe08d356b,0xfa43aec1,0x2019d7fd,0xe377a2f1,0xcca76d81,0xade38d43,0x716f926d,
	0x49c9cc13,0xe5ff683f,0xda4fdf09,0x6ffb5025,0x258d3705,0xf36d7a25,0x870f7e7f,0xb987b0c5,
	0x2cdf0273,0xd5ef4935,0xe71163cf,0xb2859ff7,0x51c53951,0xc9ab0a01,0xa1b1c9f5,0x170fa26b,
	0xdb2987d9,0x46f1dc99,0xbbad73ad,0x2be942dd,0x1de1108f,0x8335499f,0x202d107f,0x8f7b9f0b,
	0xd5a9613d,0x9215df35,0xc9c1c1bb,0xaad714c1,0x1e2587f9,0x2659ee09,0x8b63bf77,0xc2bb0ecd,
	0x0be1481b,0xf2ef6651,0x79711d95,0xa885f20d,0xe5516f49,0xabebd4cb,0xf2b7b0b9,0x0b3f2a5d,
	0xfbd34a6d,0xa78f7fb9,0x49611355,0x689f57a9,0x24a93ab9,0x1f3fa3eb,0x0c09ca9d,0x9dff9ae3,
	0xd1ff6aa9,0x1087d1b7,0xeeaf8b93,0x195d0303,0xcbeba303,0xbe2369f7,0x53bd9ffd,0xaa671a09,
	0x896b3fcf,0xd0eb3b13,0x75016b6b,0xf36d9201,0x295f4561,0x18eb3df7,0x2cb51035,0x7a6b11fb,
	0x0b959555,0xee4d7319,0x5e773479,0x5a03230f,0x09c1438d,0x3269df75,0x0051e71d,0x927f3d61,
	0x50810b35,0xf0bda991,0xc3b3a4d1,0xfad1f517,0xd857e3c1,0x9fef567b,0x5e737d0f,0xd1934765,
	0x7eafb5eb,0x02cd26c9,0x73d55713,0xee070785,0xbee130b7,0xa94f9395,0x1d8156e5,0x91196bb3,
	0x0b25be71,0x1191eb85,0x14836255,0xd659ba3d,0xc5a199a9,0x68db0fc9,0x7a59c5fb,0xc5031675,
	0xd961023f,0xec995115,0x41ddfa35,0x00f96daf,0xf35b9251,0xeb656ca5,0x385d8829,0x1bc58451,
	0x5b69b34f,0x65f9a93f,0xae850ec9,0x859922c3,0x6d4f32eb,0x503f142f,0xc17167c9,0x1e4f6275,
	0xb1bbf81d,0x7241de4d,0x439fecab,0x66691ae3,0x973fd82d,0xe939d8f5,0x45f7dbb7,0x50136e8b,
	0xcb5b8ba3,0x4885130d,0x40c9dcf9,0xb01d77f7,0x336fc353,0x5aa995ff,0xdccfa749,0x4f0316bb,
	0x85c95d59,0x825542c5,0x5c27c549,0x99e7dc6d,0x829fba17,0xbb5fced9,0xa35d7a5d,0xf39119af,
	0xcd0b3139,0x3bc3e13f,0xe25dc7b7,0xa5770b2b,0x6411a6b3,0xb4ab4f89,0xdd81914b,0x70b12691,
	0xbb9f3fbf,0x33637ac9,0xd689e2dd,0xbf01879d,0x758937e1,0xa263cc9b,0x159f54ef,0x73d17d0d,
	0xba89d5e5,0xea475427,0x125191d3,0x5d3735ad,0x334780dd,0xb2d7831b,0x3c97faa1,0x44e78d4d,
	0xa14df523,0xc3ff0aa9,0x65d36c35,0xa149f9c5,0x180d995d,0x06d7d891,0xc9cd243b,0xe66597f9,
	0xd5e7f375,0x269d3415,0xb7b5c61d,0x76eb58cf,0xbd1f3d9d,0xd1b9fb05,0xdb238017,0x35394e3b,
	0x6cdf1b53,0x9ab5feb7,0x25175025,0xb44f1835,0xfa3d6e57,0x794b8105,0x54f96911,0x08d771bd,
	0x49354bb9,0xeb57d157,0x219bb767,0x3a25dddf,0x05a910c7,0xb5e1099b,0x0233867f,0x533374ab,
	0x3c69981f,0x4617eb43,0x9763457b,0x13a3d03b,0x94278ea3,0xb24fdc4d,0xb4316c3f,0x40bd19af,
	0x267fe87f,0x5b05043f,0x0711807d,0x9677362f,0xf8f77627,0x2be38927,0x62d73aab,0x586713f1,
	0x15f99957,0x7cb5ec9b,0xa7c7cb07,0x82d31729,0x45db1a0f,0x927188b5,0x4c873e99,0x9ba5a71b,
	0x67d91b9b,0xc0372d1d,0x87270433,0x236ddb0f,0x6b173191,0x284bdbff,0x16219167,0xa6654757,
	0xe7a194cb,0x1d1da70f,0xa9552799,0x6d73ea4d,0x576b7869,0x2243ac8d,0xeb09b8ef,0xcf1d3951,
	0xef517edb,0x8d7b343f,0x28efed55,0x20974dcd,0x18194ed3,0xc7adec6d,0x9d1f4787,0x46bd3231,
	0x876f484b,0x2de346f3,0x57196a01,0xe70f4ef9,0xf8e55985,0x9257f629,0xc4c77c0d,0x38b7f7a3,
	0x86f9f40f,0x5d6589f5,0xdb77aeb7,0x758917bb,0xa40f21bd,0x4e952cc7,0xe0e1e1d9,0xeaffffcf,
	0xb373b9a7,0xdd938091,0xd427690f,0xab39527b,0x4259b531,0x3b379bd3,0x76d1f0c5,0xde031161,
	0xe0dda509,0xf2812691,0xf5cf8327,0xb1d1ca27,0x9b05461f,0x29939759,0x3279ad2b,0xecb9e381,
	0x11bd36af,0x82bf903f,0xab8fc395,0x1d810a25,0x33d7cb3d,0x9d795be1,0x063947e7,0x6c91bdd9,
	0x97130395,0x37618a63,0x37096d73,0x0cfdfe63,0x71119fc9,0xed3bae73,0x4af5be51,0x4d7d1893,
	0x305f5533,0x9bf73a49,0xd05fe05f,0x49759347,0xb5712379,0x61ab7c9d,0xe00d7a43,0x39f13c5b,
	0x2ba5c985,0x3e95bdb9,0xc633386f,0x669f55bd,0x823d5a8b,0x561b7c67,0x4b65f219,0xb6dbe25b,
	0x8567f303,0xcfcbcaff,0x9da7ee3f,0xe2a9132f,0x97358db5,0x585bcc5d,0xd95f48ab,0x43b1d43b,
	0x08a7f8a9,0x42ab50e5,0x325d76e9,0x46477987,0x129dea35,0x48c19385,0xbcdbed53,0x7a638c25,
	0x6ee535f1,0xecc916b3,0xd677e407,0x44a9b72f,0x913521c1,0x7a1ba16d,0x2f3b3beb,0x2f63d4c5,
	0x8027dad3,0xa6375c35,0x729783b1,0xdb831b0f,0x4e3f0a97,0xd1bf0e1b,0x90631ccf,0x91a56943,
	0x32eb8bc9,0xe98379b5,0xa5e18083,0x7307b495,0x437f3f6d,0xe77bda1d,0x86b5a4d7,0x4a979549,
	0xcc3501cf,0xf3c57ffb,0xe5f38197,0xfde7f3a7,0x4935bf81,0x25a58e7b,0x1f13b55d,0x9e2fd503,
	0xff87aa5f,0xe48bd853,0x9ef34a87,0x195348b3,0x36238e8b,0xe90bdcbf,0xecdd9c3b,0x8add7519,
	0x0ee34771,0xdde7e485,0x537f5b6b,0x2cffc49f,0xff8b54c3,0xa1033ef3,0x29f5b3cd,0xe99332b5,
	0xeac98f7f,0x246b9edf,0xbcbd90df,0x8b1db8d7,0xd931fee7,0xef5b97a3,0xd6bf02eb,0x8dc5db83,
	0x523fcd85,0x3f2d3a25,0xea4dc3fd,0x905d5745,0x55555e2f,0xc867d1d5,0xda1ddcef,0x6561edad,
	0xf2c380fd,0x17b9c1a7,0x62516a5f,0xc3f35253,0x84bbc853,0x92f98117,0x216f81b3,0x98dd37d9,
	0x8859fddf,0x1a25b92b,0x416b361d,0xf7917ceb,0x16a3b791,0x48638171,0xc099bd93,0xab297937,
	0xfd830ca5,0x5503bcfd,0x5abdb5d5,0x67696a75,0x78cf6aa1,0x9477976d,0x11fb8967,0x99b9016b,
	0x8b438a4b,0x996321e5,0x57e9f49d,0xda2b0edf,0xf78184bb,0xf5891015,0xd679aa89,0xfc7b50a3,
	0xd919084b,0x9ad7952f,0xd9111a0f,0xc10b5e91,0xdd7dad9d,0xdc6760f3,0x557552d5,0x25e5b787,
	0x1d0b6c9d,0x0f73bca5,0x94d70a49,0x57bbee73,0x9403317f,0xcc65c811,0x7ccfc0a3,0x42e7f743,
	0x3b9791bd,0xcfc7d68f,0x785d05e1,0xc46b93f1,0xc2d7a11b,0x7b53ebfb,0x00ebdecd,0x7af3e17f,
	0xe7c1e6a3,0xf6e759b9,0xc74749f3,0x37cf04f5,0x703971a9,0xf1877bb9,0x7ca9e4ad,0x0ffbf867,
	0xc30b0ecb,0x0263956d,0x3bb3b019,0x0d1977e9,0x20eb9ce7,0xa9d1ced3,0x916df61f,0x7e710ea1,
	0x7d75822d,0xf24f5173,0x26474e6d,0xe9f943b7,0xf82f410d,0xb1838557,0x0717c37b,0x9d49e75d,
	0xf5852d45,0x693b6e17,0x8e211787,0xdea37fc9,0xd7c940d5,0xc86f27cd,0xec0d299b,0xbdf3d63f,
	0x5839110b,0xcc3b8421,0x50e77a83,0x85c9a409,0x7ff9e379,0x80e5c741,0xb52bd1d9,0xcc615f75,
	0x4115e2fb,0x62df84df,0x42b902fb,0x249d28df,0xaf8374b3,0x5fbb9d39,0x5dd7d211,0x6f05d7a9,
	0xda1bad0d,0x77395a15,0x4e39f909,0xcacf2739,0x43a7e4bd,0xfc41abc1,0x87f34c9b,0x26d30401,
	0xfbcd6dbd,0x75dd8613,0x94890145,0x7293f87d,0x5827684f,0x20475d65,0x9bdf1051,0x6f39ba2d,
	0x4d2db803,0x0ddbc39f,0x8d4bbccb,0x2099d699,0x674518a7,0xe823252d,0xe87f388d,0xde2d8051,
	0x63bb535b,0x50c7a605,0x26a16935,0x04177bf3,0x69c5937d,0xe2a31ea3,0xc335cd2b,0x441f2d1b,
	0xe37ddbbd,0xd2b3390d,0xe52d809d,0x96bbc377,0xf6e79b0b,0x311badd1,0xa7e16283,0xcc0387b5,
	0x9ef161a5,0xca2da103,0x0411599d,0xbcb9488f,0x646db60b,0xa75f1f41,0x58e7b96f,0x1b47e7c5,
	0xb71b0a0b,0x304dbab1,0x94f1c74d,0xe4c10723,0xe69bcfb7,0xebbd47fd,0xff275f4b,0x71e1d57b,
	0xbb7dae6b,0xe09fbb5f,0x9febb949,0x2807fba1,0xb031d7c9,0x97092591,0x4a054def,0xca41a97b,
	0xca177cbd,0xb939d0d9,0x43a3dbab,0x6a3dc2f1,0x1273627b,0x54977e03,0x8f618bb5,0xf9592cf3,
	0xaf6f977d,0xbaadc167,0xd53d370b,0x79953a7b,0x9d1f4887,0x02357fe1,0xeb9fcb77,0xce9b398b,
	0x0683b5a5,0x280b8bd7,0x0059d087,0x2ebf202d,0x3e7b4727,0xd0376233,0x61a10c91,0x33fb596f,
	0x58d7c2ad,0xa6e5076d,0xe71749b5,0x8cefb26d,0x6349a015,0x616f0483,0xfac73ad9,0x4de76747,
	0x3e6d7e8f,0x5f4f83f9,0x421d80b1,0xe1d75027,0x16c9b98b,0xeb2f8edb,0xe6f5ceaf,0x9b552e3f,
	0x7dc71dc7,0x1bdb69c1,0x808b3013,0xe5a718c5,0x22bdbe43,0x554911c7,0x9c8b6ce7,0x15b509ff,
	0x2be5e94d,0x6999d991,0xe8038ef9,0xdb138c31,0x2f673d79,0x5a0f264d,0xf86d86df,0x50fb86b1,
	0xcc4dde9d,0xb81b4cb1,0xb4a7f0f9,0xaf4d2ad5,0xe38bcae3,0xa6538dfb,0x5dfbfa6d,0x9b9500ff,
	0x70fd4fb1,0x797534ed,0x3919662f,0x1a07159b,0x04699ebd,0xf967d2d7,0xd719b1f1,0x1e794617,
	0xda798301,0x42379c8f,0xfe7b5b33,0xbd71adeb,0x95c335c1,0x451be76f,0x3429443f,0xfd17339d,
	0x97c35389,0xe973c65f,0xe4713923,0x463f35b3,0xf9ddf129,0xcdc5c6cb,0x2c0b94b5,0x756157bf,
	0x265dd0c1,0xa8bdcda9,0x41190595,0x8ba16f59,0x1177b6af,0x4a351475,0x7c23732b,0xffc99125,
	0x1247dea3,0x3c274637,0x011702a5,0xaf4d3dcb,0x5bd3908f,0x03bbbc79,0x08513bfb,0x6f43aefb,
	0x1607d5ab,0x0241dc51,0xc78f4eed,0x3d71446f,0x16b54d7f,0xf62d935d,0xfaf977ff,0x113f10e9,
	0x3a9b22d3,0x1c1df4c3,0x0e1f8585,0x4cbf8731,0x5e5d20bb,0xefdbf62f,0xe4fb7c93,0xcdaf4719,
	0xf787e793,0x8d4f4cd5,0x44ed5e09,0x9e6d0a7b,0x4d8d41fd,0xb1956a77,0xddbd0b8f,0x4705b237,
	0x52cd99e7,0x5be99a55,0xf2994c93,0xbe297337,0x1d898d81,0x0eb13e3d,0xa31bf34f,0xfa33236b,
	0x00eda447,0xb07b2b87,0xd44521bd,0x2227a6cd,0x461123fd,0x0cfd280f,0xb97baea9,0x5ead7c61,
	0x84ed05ad,0xf617873b,0xfd93aaa1,0x4b176b2b,0x9d670aad,0x04cde6f7,0x8bbf04fb,0x06614f41,
	0x504bf197,0xfa510cb7,0xf8a550d7,0xe42d06b9,0x784fcb4b,0xc0f5e27b,0x8b49aa1d,0xbdc57eb5,
	0xe30d6ff9,0x0d3993c7,0xe61dba7b,0xe31be05f,0xca091413,0x9ec3caa7,0x4ff9de69,0xabcbdde9,
	0xebb1fd51,0x21610cb3,0x9d1d6a27,0xa8131f89,0x445757bb,0xae0b3807,0xb8310ebb,0x71e1d085,
	0x67392a99,0xebdd2047,0xcb475ef5,0x1dc54c23,0x777d6d7f,0xd11f4ba3,0x08d5746b,0x4bfdeab3,
	0xc12b3d49,0x043fcfcd,0x14bdb47d,0xd965ee93,0xf23b311b,0xdcd14f03,0x0d47b553,0x308d911f,
	0xf387cf5d,0x0497150d,0x342342db,0x3aa52fc5,0x61d322c5,0xb8755435,0x376783cf,0xf08798f3,
	0xa6cd6f4d,0xa9778253,0x1a973ea9,0x8bb77923,0xb209073b,0x7dd9d5c3,0xbf993eb5,0x575be7d5,
	0x52014015,0xf1f3e269,0x0fbfd901,0x214b1495,0x2d1d87b3,0x995156b3,0xc4bd9163,0x4afd13f3,
	0x5aa5992f,0x3f9dd897,0xd1b9df7b,0x7a95cc89,0x9bd1d1e9,0xe9ad0291,0x6c3713b1,0xebdb03f7,
	0x34bba691,0x768380a9,0xb52b5c35,0x61458be7,0x65673819,0xe0434d69,0x01e9e9fb,0xb4eb8f09,
	0x82c308bb,0x1d3d0ee7,0xc53535c5,0x0991fe17,0xafa3d0f9,0xa0e393c1,0x18336519,0x9b9d1cd3,
	0x35c374a3,0x7cd7701d,0xe377cf45,0x32272f05,0x7ec717c7,0x21dfbaa7,0xa7f9a265,0x2fe34581,
	0xad3953c3,0xc0e9e995,0xe817a853,0x44392b1d,0xd5918c39,0x4c09cfa3,0x309b2bb9,0xbc3171bb,
	0xd7296417,0x177fb919,0xc1b5fd05,0x737d9f45,0xd547528d,0x1ab3a8bf,0xd7fd976f,0x65757aab,
	0x50155817,0xd12fb4f1,0x957365f7,0xde2178e9,0xdda9d379,0xbbad8487,0x8a812863,0x4b2549fd,
	0x82ff76bf,0x810bebe7,0xdef37843,0xacd785f3,0xacfb5c3b,0xaf4daa01,0x1b076ded,0xa73179d9,
	0xc9693b89,0x1ca34549,0x90596583,0x32d514cb,0x7ffdbe89,0xe86108bb,0x62f1e3e9,0xee0df4eb,
	0x8b53f66b,0x1c0920dd,0x32439bcf,0x0dc9945f,0x31f1f0a1,0xec3fd8bb,0x622592ad,0xeea7965b,
	0x5f416be5,0x99d1f6ed,0x03d565c3,0x45e73417,0x5c9bad3b,0xf2b53a8f,0x5effaf17,0xf275c9d3,
	0x2a3774ed,0x730bf845,0x1ab38a79,0x6de183db,0x7839138f,0x0619d73f,0x06673a7f,0xdd652b7f,
	0x3fb19efd,0x674bae2f,0x82fbed8b,0xc2e71417,0xfb93475b,0x23398055,0x8bbba2c1,0x4ded2807,
	0x81b7cc11,0x38a19a75,0x5f532f11,0x4cad15b7,0x7be510d7,0x596bcfdb,0xc8dd6233,0xbcff9c97,
	0x80c9d2a3,0xcba1d75f,0x08db4ba7,0xfd65fa21,0xccf57cbb,0xea7dc85d,0x5e319fb3,0x9e0976d7,
	0x9be71dab,0x475bb7b9,0x2f333c67,0xd1bf1341,0x21037c45,0x6ac374e1,0xd299ce9b,0x7f0154f1,
	0x20954ca5,0x356366cb,0xf88196eb,0xf0ef3381,0x28d3852d,0xe10f88f5,0xb3754ec1,0x28572591,
	0x6ad5d389,0xa1c98863,0x21652d4b,0xcca74dc9,0x33a531ab,0xe6b300a1,0xb4a90c83,0xbcfdc7df,
	0x05299ad1,0x3b1fd8c5,0x1d01ae25,0x41171587,0x4f3be07d,0xc783c06f,0xd09720b9,0xda65ab85,
	0xc8939f79,0x7279ccc1,0x34f7448f,0xb4f59ea3,0x67d754db,0xa1cd3569,0x681f70bd,0xb88170af,
	0xfc9592fb,0x9b69319d,0xa9693823,0x396ffd85,0x683d567d,0x8665f519,0x62a34e6b,0x49c58805,
	0x772f7b4f,0x0bfdcd23,0xd0fb8cff,0xaa37e71b,0x59ad51a1,0x989d5d89,0x4e071819,0x5b21d2b3,
	0xbce552f1,0x3ccdfda1,0x38cba3b9,0xcd8350cb,0x83ebf6ff,0x2e453545,0x7eadd8a5,0xb4074261,
	0x20b9a8d9,0xe8e759dd,0xc47dd96d,0x74011081,0x8d37dbd1,0xefb34b55,0x2f75e769,0x3669793b,
	0xe42d4081,0x2ddd5121,0xce3527b5,0x98e37ca7,0x9a5319d1,0xf7b71741,0xa1c3883b,0xfebb69e9,
	0x5743b1e7,0xabc1cb39,0x4691c4ab,0x81df0c27,0x6e81ef37,0xf3a35917,0x3d798b79,0x83ebf795,
	0xf87b097f,0xa529c86f,0xd4b7c2e7,0xdf23f66b,0x8b855ec1,0x4349b95f,0xb0f7edfb,0xb76f95e9,
	0x94db6849,0x1f21018d,0xf647b185,0xeb63d35b,0x519fcfa7,0x18f96925,0x111f791d,0x2537e911,
	0x67e1a3b9,0x013f87db,0x1f633c1f,0x8bcf3b65,0x1f93ada3,0x9989c1ef,0xf95562b5,0x13b565b7,
	0x3b91e5cf,0x35956525,0xdaabcacf,0x701d6771,0x729f08ef,0xfc49e5c9,0xab7bed21,0xa3ddf103,
	0x886d4cff,0xc8b33bb3,0xe945222d,0x327bd0e7,0x068b3645,0xab095f3f,0x2ff3073b,0xf11f809f,
	0x95758c49,0x09abe651,0x62d10357,0x779bd1b3,0xf5936edf,0x621fc159,0x759dec59,0x316dbab5,
	0x982f8b21,0xaa111849,0xd571cbe1,0x0eb3443f,0xd87d7077,0x505947a1,0x71dbc459,0xd53995f1,
	0xd4990587,0xddf5fd63,0x65c915eb,0x11712375,0xe6891d47,0x370b7621,0x40914393,0xa775f97d,
	0xbd372bf1,0x7bebd9eb,0xeef7580d,0x04072abf,0x15791c09,0x8a09b963,0x44214ae1,0xed935d01,
	0x130b4359,0x1d03aaab,0x229f855f,0xf52b7607,0x399177f7,0x8fa10671,0x456b879d,0x878768a7,
	0x0597453b,0x3cd1c4eb,0xa8e5ad7d,0x9e0b21b7,0x259140cb,0x80a77ad7,0x93d313a3,0x0fc19519,
	0x52dd7f8f,0x59657677,0x40679c81,0x825beab9,0xcabd2abf,0xa86ffc9b,0x2539154b,0xfb33cb83,
	0x675d34d1,0x1351a599,0xde4b7b03,0x104dce75,0x58d32e8d,0x84c7da4b,0xb6015f71,0xb94f058f,
	0x7e1b3bfb,0x4da97119,0xce2f6e21,0xc091aad7,0x5e19296f,0xe6036aef,0xe90d116b,0xd409ed63,
	0xc099a083,0x4dffd043,0xd2393771,0x365bde4b,0xe7517d1f,0x0ef5ae11,0x67bd3717,0x0fd17dad,
	0x66d94269,0xdc6332df,0x4309d50f,0x5f5de7b7,0x9fb9afd7,0xd4efebbb,0x01f568cd,0x8b99a197,
	0xd75d7623,0x63672139,0x2fc12193,0x93c70687,0xf1170c51,0xbfc35479,0xce156b67,0xe0d3d4c9,
	0xc727a4ab,0x101fdc1b,0x7e03741b,0xb64ddaa5,0x23ad41c7,0x29c3a151,0x4901d041,0x4371c36d,
	0x59b7eb7d,0xf21bfccf,0x09f1403d,0x5421047b,0x7e3b03f3,0x5fc1b3d1,0x76199533,0xa1e7ea2f,
	0x4111bc93,0x1b6f151d,0xc62db615,0xc4f3c4f1,0x6603ab0f,0xc10f35ff,0xff41c497,0xc5233637,
	0xddb77e65,0xc0ab4f4f,0xdbd9623b,0x4af99d75,0x7ec7d3d5,0xdf7d3a69,0x54db1549,0x709ba52f,
	0x5eab2bed,0x58e30e33,0xca97cdcd,0x32dfefef,0xcacbff81,0x9f61dc17,0xcdc78a9f,0x823fe543,
	0xe16ff4a7,0xbda78d0f,0x888b1e61,0xf3dd9ec7,0xcacf33c9,0x578bde93,0xc7691477,0x1283f51b,
	0x9205dc8d,0x4b0b7fad,0xa253b613,0x4fa1ace9,0x9e159ae9,0xf14b4de9,0xc5a12f2b,0x9455c3e3,
	0xcaed5c17,0xff9fb25b,0x5b15d37d,0x725fddc1,0x2261239b,0x08771e9f,0x92d38391,0xf52bd143,
	0x352b0041,0x9c75a9dd,0xcc6f31b7,0x12c95535,0x13f32119,0x0b5fcdc3,0x5fe18707,0xbcf5cd65,
	0xe8410a83,0xc5214383,0x0687a85f,0x921137b1,0x2d8deb1f,0x5ad300db,0xe42b1b65,0x2e2538f5,
	0x8a3110d7,0x1fb35513,0x2ffbcb8b,0x1be74a1d,0x48737de3,0x6a2925f5,0x7d932f05,0x65ad051b,
	0x6f7d9dbb,0x74bf4cd9,0xa5f18bd5,0xc67d91e7,0x7c651a21,0xdf2f1399,0x507f5cc3,0x7b013383,
	0xbb25d023,0xcf55d19d,0x1c09d65b,0xb289f4f7,0x3fa5e513,0xb239a8d3,0x67cb8bf7,0xa0117655,
	0x7eaffb8d,0x9d0962ab,0xbc6534b3,0x2b39d9b5,0x86f78875,0x4e1b6d29,0xd4df907b,0x414fd03b,
	0xda1947f3,0xcdebf7cd,0x47a76cf9,0xc641c70f,0xe59bd27d,0xb02330a7,0xcf99caa9,0x25ad3461,
	0x1be751cd,0xf48fa14d,0x34f121c7,0x83d3046b,0xad5355e7,0x8825abd9,0xd65bc75d,0x8e9d266f,
	0xe11bca17,0x660527f3,0xd1e77237,0xee9f39b5,0x0e6309ef,0x58731fc7,0xce09dfef,0x58135a91,
	0x35351649,0x59dfad09,0x62a799e1,0x3bd90f57,0x378bea4b,0x95dff5f9,0x2205da39,0x187f556d,
	0xb23bf05f,0x0a314a5d,0x41d590e1,0x6b33ce3b,0x760d9739,0xc7bd607d,0xe42f8895,0x40d30c33,
	0xa0ab06d1,0xd38db233,0x0095abd1,0x66ddffcb,0x55abf56f,0xa7dbf9db,0xeceb69df,0x3c818487,
	0x17899c9b,0x5503cf5b,0x86853bcb,0x238d0df1,0xc0a9ce29,0x428d651f,0xfb1b496f,0x917b7499,
	0x1c572935,0x9025651b,0x31cb2e69,0xc06fe317,0x1fc96f23,0x16a5edcf,0xd41fdf1f,0x0035e30d,
	0xc317f89b,0x0907af3f,0xf705adc3,0xa73b8a25,0x7a494a93,0x357327f9,0x63d96f49,0xa39fc711,
	0x4e4bcb47,0xe6390211,0x8159c075,0xac1fce89,0x95ef9737,0x62cd9023,0xdcad6ac9,0x112ba84d,
	0x4ef3762f,0x10cf6a59,0x5267e999,0x2dcfdc29,0x16fbf045,0x35032b5b,0xd77d0ef7,0x78cb3eed,
	0xc49582d3,0x54594d63,0xe251c8c7,0x357ddf71,0xa031f57b,0x34e72729,0x73a905af,0xc4f11399,
	0x3d2fcf29,0x7eeb08f7,0xbfb9ba1b,0x96d9a54b,0xf2d1eb0f,0xfdcb7997,0x77150547,0xba911f7b,
	0xf5452dab,0x81159361,0xafc1762f,0x10173b21,0x0e9d59bf,0x5d7f8131,0x6e23709d,0x191b6c3f,
	0xf7d90555,0x8de91b6b,0xce0bb21d,0x69e98edd,0x51d9aec1,0x7459a4fd,0xcbb3f709,0xba81b40d,
	0x3e6bf19f,0x3afba85d,0xacb9bf7f,0x97810ee9,0x9945dbd3,0xd527f489,0x09293465,0xb3350191,
	0xd1016285,0xa05dba03,0x746f2c6d,0xd68f4a2f,0x6023f72b,0xa53fc7db,0xc665510d,0x72294ff3,
	0xe6193c81,0x789de8a7,0x044b6383,0xcf479017,0xe035db87,0xbc6f5f81,0xe9cba1d9,0xe0d12add,
	0x02b7788b,0x40d38511,0x11f14bdb,0xb459908f,0x31bfc81f,0xc50d8483,0xc03b4823,0x831d4e7b,
	0x1a5dc41d,0x588d388d,0x4985e90f,0x62fbfbfd,0x6b8300ab,0x5be7286b,0x1d19d1c5,0x977f4775,
	0xaf0d2133,0x21dda4e3,0x6da7fb37,0x82db234d,0xc2bf6d69,0x30530543,0x7a45d91b,0x36e912f7,
	0xf1478647,0x21570461,0x77779eef,0xa62b97e9,0xab393b11,0x241f3d97,0x1823a4fd,0x74cdbea9,
	0xe0117e51,0x1e0bc9cb,0xb69bed51,0x69a1cbbb,0xf7317adb,0x6b9ffc6d,0x1d95c8c5,0x7f1f08b5,
	0x68e9c8cb,0x418b4071,0xf1339bf7,0x946bb12d,0xf76bc285,0xada51553,0xb7fbc44f,0xbe4fffc7,
	0x87d3f9b1,0x37eb2c19,0x83e19cfb,0x383d5b29,0x9b25cc47,0x2383a451,0x3b39a3f1,0xf54fa307,
	0x6751197d,0x4fbd690f,0x81c7bef5,0xd1479d19,0x902716d9,0xb90dadf1,0x41b1a089,0x6191821f,
	0x80634527,0x9a118c1b,0xd4874d01,0x663daae5,0x62ad8579,0x2c91bf3d,0xcc43bf71,0xdb095d3b,
	0xba8f4e2b,0x0a798289,0x5c43aeb9,0xa851b8fb,0x9d7dffdf,0x2ee38dbf,0x6251727f,0xf425c505,
	0x8bd35a81,0x97093223,0x0f9d0835,0x13359c41,0xe9d71245,0x83559781,0x31bf3811,0x19dbbaa3,
	0x18b584a3,0x58511931,0x1bb9da11,0x0d196a25,0x2f7f8d63,0x1fb7c30f,0x2eef3aff,0xb39b4fc3,
	0x54337b8f,0xa965ee7f,0x0435a167,0x06b1188d,0xb4b32677,0x4c5fff6f,0x34c1f2a3,0x4357468f,
	0x1fcf22b9,0x47d54157,0xc33577d1,0x9b2f1de5,0x3e3b1739,0xc41de42f,0x2499c2d9,0x8583b1af,
	0x6b8f3221,0x73b51981,0xe95db369,0xb0451117,0x2f53bde3,0xd4435157,0x06599bf9,0x910f944d,
	0x55f3d63b,0x0f959749,0xbdcd86c7,0x9623498b,0xa9c13d2f,0x7ca30f71,0x28619add,0xf76b8215,
	0x4bfb5005,0xc0899377,0x5e25a107,0x277d7f2f,0xadc51c55,0x8f8d6f87,0x3f93a8df,0xe48d3f2f,
	0x292b94f9,0x0e213f57,0xde8bcdc3,0xe9836a6b,0x3a23e713,0xd1d7eb25,0x87551bdb,0x3ee76045,
	0x5785ef0f,0x826fc4b3,0x699f9515,0x2be96427,0x6c19cda1,0x1ad1c451,0xe1835629,0xc767ea83,
	0xef8b9cc3,0xca07e5d5,0x6083db95,0x28e105d1,0x9f6d44b9,0x744ba599,0xf68566a3,0x3983f391,
	0xd83f710d,0xd3fb9d85,0x7ad98261,0x251dc94f,0x8e61a595,0x3a9b4205,0x5539a8a5,0x6b2b419b,
	0xe7217369,0xf1d9bf0d,0xe6c3070f,0x8fcda90d,0x71b5cdef,0x3c8ff51f,0x93016405,0x6cd1eb49,
	0x00357fd1,0xf7b9963b,0x68e323b9,0x22a5bff5,0x20abc001,0xdb7b62f1,0x6bc16d21,0xa967f7c5,
	0x35ffe6bb,0x5c278755,0x7c5b6efd,0x01d7e971,0x31054285,0x2b331805,0xe1dbc4d3,0x0661febb,
	0xe97d0d27,0x583baf25,0x72cffbf1,0xdc15616b,0x170780b5,0x12052965,0x5e2f3871,0x03adc853,
	0xea310c8b,0x078182f9,0x945dfa31,0x0a8f644d,0x4571aa4b,0x68c5d49d,0xd02101d9,0xdbc1ed37,
	0x962152e1,0x880f7097,0x3fab55d7,0xb0f9ceff,0x4d859381,0x1ac71fb3,0xcd916763,0xa38d7693,
	0xf9cb42a5,0x1a777e49,0x09d7577b,0xdd83beef,0xff075511,0x45d97935,0xb2e35be9,0x6a857e11,
	0xf035d2cf,0x41c9eadb,0xde87443b,0xa8e33203,0x8837ec35,0x5a4f582b,0xc2f91ec7,0x5a97cdd7,
	0x42dd2edb,0xe397cd97,0x1fdbfdad,0x5647a6a7,0x95d9daa7,0x3afbdc1f,0x4733dbd5,0xd8398095,
	0xc9c756c3,0x67f5b647,0xc673a1ed,0x7361bbc7,0x732bc6a1,0x5d2f6d1b,0xaf754b6d,0xa25ba16f,
	0x8b75beff,0xd9754d33,0x81752b93,0xf867d0c9,0x29f31add,0xe8bd5bab,0xb21f5269,0xf26fcc13,
	0xdce7f089,0x0527f327,0xd68111bd,0x6807a599,0xa273a695,0xd7f780d5,0x6c15a225,0x9c67cca9,
	0x81a328dd,0x9a9d616b,0x41b9e801,0xef75fa9f,0xc3693d83,0x17afde27,0x80b75879,0x2eb73fdd,
	0xcba7f9f5,0x4beb49cb,0x55bffe7b,0x866130c9,0x921d57e3,0xa7373da7,0x39e99fbf,0x124f32d7,
	0xbb77ea49,0xeda1f691,0xdbb701c3,0x0effe97f,0x524bb26b,0xb85fd1e3,0xa80d4ed1,0xaa9fc341,
	0x201514d3,0x96d1ea85,0xf33f9af7,0x7601a6a9,0xa639ee57,0xcf7dd5e3,0xc203890b,0x759fbf47,
	0xb701c90f,0xc10f80f3,0x327b0fad,0xd2996ab5,0xaea73161,0xe3612d31,0x852f5e45,0x2bbb4591,
	0x4c412af7,0x686d8da5,0xc60fe201,0x86775889,0x2ad7c5c3,0x7d5b03d9,0x15716ad9,0xdfe7654b,
	0xda53d303,0x2b7bfce3,0x9119708d,0x5dcf5391,0x988dba37,0xd9416e61,0xdd2d77a3,0x1f97be1d,
	0xaa3d6e2d,0x6b4b7379,0x4d3f9669,0xaf539fb7,0x540981f9,0x056309d7,0xad4519f9,0x12bb2033,
	0x737d5df3,0x6b71eeaf,0xaa9f4b33,0x7c338165,0xb80d94bf,0x02919bc1,0xdd1953b9,0x9bc52c33,
	0x7c175849,0x71ff6453,0x6fdf4301,0x9023dd85,0x3ddd0ec5,0xe421b22d,0x6a8b333d,0x77a9f34b,
	0xb88b07ad,0xe78562a9,0x9a1f8e6d,0xa155d981,0x9d3950c5,0xefe143a3,0x1a01735b,0x5dd59725,
	0xebdfab19,0x7715b081,0x7d013a95,0x707b7b43,0xec639ffb,0xbe254f2d,0x96571b71,0x203fe9e9,
	0xc791b605,0x2e43ed21,0xe2a7f10f,0xe8c54933,0xc01fc61d,0x59c17c57,0x90f51f57,0xcb570e41,
	0x0ba5706d,0x9d1f3055,0x2bb397f7,0x3fe7ea3f,0x4badb167,0x6003bb27,0xe1b9ff69,0xc60f1759,
	0xa69d96c9,0xf63baa65,0x6f47f1e7,0x1613c5cd,0x80cf1495,0x20bfe42b,0xa705687d,0xf1dba8d9,
	0xd57bfa15,0x2eab441d,0x9b053df9,0x95f9a3c9,0x2fc706dd,0xbe475869,0x65bfd3f1,0xcaa996ed,
	0x43c11fc9,0x1e013ec7,0x930fd7c5,0x94cd4c9d,0x2759a3fb,0x4d6da16f,0x2943279d,0x86ef863d,
	0x2b6fe1e1,0x9e4dd42b,0x5209d769,0xb2412933,0x54c7ac2b,0xf5851145,0xa37755dd,0x379d8bf3,
	0x750b0ed5,0xac21d695,0x0911b179,0x7885e2f5,0xe3cf2423,0x105d6275,0x4cbdfd87,0xe825cdbb,
	0xd79309a1,0x869150cd,0x3fcdd715,0x7c4d03cd,0x5eb7f521,0x4a49580b,0x83f709f9,0xbe7921bd,
	0xf88b69bd,0xcf2f2621,0xf45b55d5,0x7ccb9623,0xce418cdb,0xc21b5d8d,0xae85530d,0x1b0daea3,
	0x8bf59b25,0xaa09b257,0xbb6177d1,0x83b1c4e5,0xd9ab7d8f,0x29232709,0x58493d19,0xb8d18b99,
	0x74517e51,0xddb769b9,0xdfff63a5,0x052f7b79,0xe6bb1df3,0xe3375105,0x53a958fb,0xcd376047,
	0xe2a5083d,0xf3457913,0x83d7bc6b,0xfff905cd,0x39b12945,0x26a7008f,0xd981040b,0x283104d9,
	0x766fe263,0x564b65af,0xbf0b41bb,0x1d41b047,0x15515f3b,0x1c45832f,0xa9390823,0x543121f7,
	0x5db30ab9,0x74d5ad55,0xc03d6fb1,0xd0b767d3,0xdadb2413,0xff63eeef,0x28ad3b9f,0xb62bd0cd,
	0x74f373bf,0xdf796651,0xec8f1ee7,0x788f59db,0x2a112083,0x3dd1c25b,0x84452155,0xad8f3b01,
	0x6731a46b,0x6949df6d,0xffa32477,0x7d7b9449,0x0137e1c9,0x97e58479,0xcedf88a5,0xb44f3ac3,
	0xcdef5837,0x47d53ff3,0x2b9bf1fb,0x72aba587,0xdd0d799b,0x406d64d5,0x21df2d63,0x7eddfab7,
	0x512d1f1f,0x332f27a9,0x3919358b,0x35d53c7d,0xd8d51e37,0xfcbfdb7b,0xbd2557eb,0x1c2b960b,
	0xc76ffd9d,0x85eb4edf,0xa74179c3,0x0f27c899,0xce51ca53,0x44a948f3,0x27157d19,0x15adb869,
	0x55b70ca9,0x5d19265b,0xcbb1c5bd,0xd15319c1,0x75c5dd2d,0x62819647,0x4c8fde47,0x8f533df7,
	0x8f8719bd,0xb84d7769,0xf28f3d13,0xf98d0063,0x85f1ba7d,0x9315d501,0xa0f7294b,0x678fd363,
	0x96e146d5,0x999703d3,0x7e79bfdd,0xcf87ed65,0xd4196a7b,0x25bbdf2b,0x3e2f1883,0x575395d7,
	0x3c47aa6b,0x258b25e1,0x08958ab7,0x85739233,0x73fd39e5,0x9c41f751,0x049712c7,0x1213b2fb,
	0x1eb9ef77,0xc339705f,0x8083d6bb,0x580380b7,0xd7df59f3,0xcafb6879,0xbb11cb71,0x65bd08f9,
	0xcbbbf573,0x3c354e95,0x4c657983,0xae67cb5b,0xf083805d,0xf8bb2631,0x2f03e25b,0x5ac7c67d,
	0xdf4f705b,0xdc8fa44f,0x68db8529,0x3a53a509,0x4d278761,0xfed36c81,0x544983e1,0x54210aaf,
	0x23f788a9,0x92d96dd7,0x890be845,0x17f7012b,0x3b930db7,0x69175ff3,0x654b08db,0x2f3d853b,
	0xb2b57b55,0x10275ff7,0x36970df3,0xee0733a9,0xe8031697,0x95d5ad91,0x02e796a3,0x640f1649,
	0x130939db,0xe80b87f7,0xf19d7dcd,0x0db590f1,0x7d3da9bf,0xd5e12ae5,0x547fbf15,0x25056e83,
	0x5af90a33,0xb095eba1,0x50c17beb,0x92b30de9,0x44817367,0x8c8d75f9,0x27f92089,0x7f15af15,
	0x4f0326d7,0x22572943,0x2125a8e9,0x8331dffd,0xc5936449,0x4fa99559,0x11b105d9,0x79af09a7,
	0x822b5ec3,0x386517a3,0x866da1e3,0xefe31d17,0xe6b1519d,0x078b980b,0x8c8f065f,0x36c76063,
	0x75f3b571,0x504f660b,0x1ab7a06d,0x13fb5ba1,0x0ca39521,0x0f03359d,0x19efa5f7,0x12cbe5f5,
	0xba5d02d9,0x4a273c47,0x0ea91aa7,0x75295285,0x3aa5ad0d,0x53636e17,0x61b9f4f7,0xc4b1bd85,
	0x0de99377,0xa883daa1,0x49616327,0x03a1792d,0x327ddc1b,0x747d2a03,0x524b303f,0x7de99abf,
	0x7d9bc843,0xb06f39e3,0x88854909,0x3a15a783,0x946bc985,0xe4a1da6b,0x40896123,0x0a6561cb,
	0x84f7b6b9,0x8981ab55,0x8035b7e7,0x3db7b5ef,0xff312105,0x08a518db,0x07d3fd81,0xf097c753,
	0x2dfbc8d1,0x5dcb78c3,0xfb1357db,0xfe371d5f,0x301332d5,0x57d94759,0x2a0d87af,0x9171f083,
	0x31295d07,0x79dd8475,0xfa412d7d,0x55c99739,0x22d193ad,0x7c0d3073,0xef972e8d,0x48671303,
	0x15876653,0x6cc9e937,0xd56139eb,0x291fbd6b,0x31afbccb,0x7197a731,0x87556d6f,0x8b6914ff,
	0x50950c31,0x28239a53,0x5a951abb,0x8769aa5b,0x356dabe7,0xa745271d,0x26a7ac33,0x0ae92d1f,
	0x66534a99,0x1ffb0391,0xee7faa07,0xca5b98f5,0xa54d833b,0x1e6b7441,0x2971df31,0xd1d9828d,
	0x09459207,0x6ae5a93d,0xac419e6d,0xb62784a3,0xb7112981,0x8add3b27,0x32152743,0x65adccf5,
	0x3a6d6775,0xe1f1c821,0x857d2b03,0x997dc94f,0x7efde9f3,0x72e9b0d9,0x497371c5,0xe655f47f,
	0x694d0459,0x40b3f585,0x62579f65,0x6d93c361,0x0fd1144b,0x4f6332e3,0xfeef188d,0x2e43b1d7,
	0x93e5f6b3,0x453bbf35,0x416d07ad,0xf6156fc7,0x9acf9cc3,0xab9fe74b,0x886b81f9,0xf2692e25,
	0x66bbc0f9,0xd01b4b7b,0x57e5cc73,0xe13b0be7,0x8fbbbc15,0x456b5c9f,0xe247c0e3,0xe239a313,
	0x5ccd7a25,0x0467f91f,0x315f52d5,0xe7b3b5af,0xbcd58f7b,0x2d1b29e7,0xef6534a1,0xc7a5facd,
	0xdf9f6db3,0x67b1ff6d,0xcffb9c69,0xecb10b85,0x6edfb8af,0xe5818ead,0x99292911,0xa7216ffb,
	0x6733bb9d,0x02090e2d,0xcc5fe74b,0x1de7cc55,0x911dfdeb,0x83ef12fb,0xef75768b,0xdf9d2dc7,
	0x9a0bf859,0x7e01edab,0x75ab4e13,0x13857789,0xcd4fe9e9,0xd037275b,0x48a921eb,0x4a8befdd,
	0x6d27cce7,0x48ad1eb1,0xf18167df,0xf041ed0b,0xabb96be5,0x64abc4d9,0x61a9fc87,0x5bdfa265,
	0x440d96bd,0xb19d7a89,0x5c03e845,0x81470d45,0xb3197795,0xce1d0cfd,0x7dd7443d,0x4207020b,
	0x10bb07d5,0x0ae5d2fb,0xe7d33f61,0x5e4f5921,0x88b5a535,0xabdfe9cf,0x87134365,0x05f93bf7,
	0x73b5c6ab,0xc9159251,0xfe1339cb,0x09879209,0x104fd17f,0xcfc1addd,0x2dbff0db,0xab258dd5,
	0xdbfd0e39,0xa3415b59,0x5e67a0a1,0x0fa359e5,0x8c25bdad,0x5e19b42f,0x08bf8ff7,0x4f7de5cb,
	0xa7154df7,0xb2f9a959,0x3eedd979,0x27d5d321,0xbcfdaf79,0xedb7004f,0xb5755091,0x4b738289,
	0x40fdc9e1,0x9451701b,0x6c49866f,0x53cd40a9,0x0219111f,0xa7ebde49,0xf7c1ef09,0x51fb9333,
	0x443b3a6f,0x85d9bbeb,0x699f261d,0xffbfa5e3,0x79391155,0x688b82a3,0xda075433,0x9083d777,
	0x99cd6c9b,0x88a35193,0x908db39b,0x225d66bb,0x1e9f4357,0xdde7aa6b,0xcd29356d,0xcf013f7f,
	0x9937e1e1,0x80434e5d,0x31394687,0x5cd7e79b,0xed0d3edf,0xa8cf3b27,0xc887b48f,0x8fe78bf1,
	0x287b703b,0x52c9c811,0xb243b2f7,0x1ae12d6d,0xfdc74029,0x7c99e2e5,0x6a05fff3,0x3023edfd,
	0xdc1be221,0x08c96cfb,0xb0cd2987,0xb2ad7d9b,0xa88dc7eb,0x3f13b82d,0x1603f275,0x072ba747,
	0x1717968f,0xed5323e3,0x2077d74f,0x84edfe0d,0xa3a13b61,0x2891da09,0x1765b36d,0x86eda9fd,
	0x2af520fd,0xadfbac15,0x6b6785eb,0x1cd15531,0x23c58445,0xe3e71005,0xbf8b56b5,0x5bdf38c9,
	0x77b3e967,0x7ad13d5b,0x923d3b77,0x500d49ed,0xfc3db0d3,0xae636a27,0x86597ca7,0x8cf186d1,
	0x8bd5cc45,0x266927fd,0x4c1dda87,0x5ed163af,0xbecb93c1,0x77d9e0fd,0x2a31f21f,0x9b9757c3,
	0x445dba93,0x45d374c7,0x26a5c23b,0x13d38a5d,0xdbad644b,0x029bf58d,0xcff35075,0xa3bf9fc9,
	0xeccb59c9,0x50a18503,0xa5f96e29,0xe441a663,0xc1a95e2d,0x037b5165,0x23019d83,0x7bdf238b,
	0x5f25a3e3,0xc0e7b279,0x64bb166f,0x0fcf40ab,0xfe01619d,0x41cd668d,0x7541eba3,0xd4e71833,
	0x23e98759,0x3337ef75,0x340f4fa3,0xc0ad229f,0x5c739359,0xb75f0f8f,0xdf0ff9b1,0x5a49c36d,
	0x921b8727,0x86a166c1,0x3b93aadf,0x2b8ff627,0x0745fc97,0xb0852f77,0x5f53d305,0xd1f91b61,
	0xef3d5ac5,0xfcb71ba5,0x196d55c1,0xafa7e5b1,0xa7372b13,0xec1151cb,0xfb6b6f79,0x3c6566b9,
	0x8f518e2f,0x598d89ed,0x023dba5f,0xf6a73c25,0x838dd109,0xbb534a99,0xdf3b5369,0xf483dca1,
	0xf4d921dd,0x03b345e3,0xe1231f55,0x14bf04eb,0xa207652f,0x2221d667,0x7d232fab,0xcfc344c3,
	0xf0d52acb,0x243d9c4f,0x77c547bd,0xa8a3abef,0xe6e7c2c3,0xf6cb3a43,0xae05819d,0x3e179745,
	0xc2c97271,0xc6bb327b,0x7e43132f,0xfb839d9d,0x34f1c97b,0x0223e3b5,0xd1473319,0x69f39cd5,
	0x38b916cb,0xf941a635,0xc33f1dc7,0x2115e6db,0x8d65fd95,0x1f7b08c7,0xecc73a75,0x58458e9d,
	0xcf232a53,0xec5f2dc3,0x4bdb6021,0x1787d515,0x300527c7,0x5ca34805,0xcce73a8f,0x0883b645,
	0xd1095401,0x132737f1,0x73b9cf51,0xe78d9635,0xbb15f54f,0x19f14875,0x248b22bf,0x949d0df7,
	0x77f16f4f,0x432d0c07,0x0cfdfcf7,0xc457d8a3,0x4b5397e3,0x2a3359a3,0xad15cedf,0x5105e05d,
	0x0bd92c39,0xd48369d1,0x8045b729,0x2b996b4d,0x9c0765c1,0xf2bf139b,0x4665a74b,0xecaf68a3,
	0x0347af37,0xc1b92999,0xecb5a883,0x0585dd9b,0x26ed79a1,0x8b63f6e5,0x16df40db,0x91097273,
	0x23393145,0xc7e1dc27,0x47f1f81f,0xc4cd1f75,0x444b52bb,0xde750c8b,0xab63fce9,0x0209f9f5,
	0x9f339fdd,0x868f6ac7,0x7e17e997,0x86a12149,0x4ae174cd,0xc8c38617,0x1755a94f,0xbe1fcbd3,
	0x39353cf7,0x9fd3b741,0x91cd7d03,0x32b573fd,0xaff3080f,0x39a35d93,0x14972069,0x1e3d2537,
	0x61c53f0d,0xd8413be1,0xbc330f01,0x9b3be8fd,0x27417939,0x52e3f58b,0x2389e90f,0x75d753cd,
	0x57e1711b,0x36e9ab71,0x8ce9f8a5,0x9ce33233,0xc30d1989,0x88d7b905,0xab0dd69b,0x32db55bf,
	0x490fd29b,0x255d913b,0x0a152f8f,0x3ee18209,0x1419beb7,0xc251bb8f,0x1889a8e9,0xfdbf79b3,
	0x714d3785,0x8fb1f107,0xd057e5d7,0xd2e72b69,0x49a962fb,0x78a35931,0xffdbac51,0xd973fed7,
	0x3b1fe855,0x0477e721,0x32d12a15,0x152741bb,0x517dc513,0xd7a1d675,0x3b6559ad,0x436bb4d5,
	0x5f854203,0xd4bf4851,0x5b258765,0x4c5138ed,0xf7d90837,0xdd990065,0x0c0bf657,0x53959bd5,
	0x06055609,0x341b41e3,0x6975a561,0x69998565,0x077d541f,0x7b5fcc8b,0x392f3429,0xdc678481,
	0xe49d8a63,0x589ff9a1,0x9465e821,0x28b13c11,0x69ab7509,0xb445f8f1,0x30b1d17f,0x8ad1b005,
	0x5fd1398b,0x9adb2dd3,0x49131043,0x2fc9b257,0x46257bad,0xbe1bac23,0x26f33931,0x06457009,
	0xaaa35279,0x95e3d545,0x4b23dadd,0x2f951e23,0x232f5d45,0x21371527,0x36db229b,0x10b5c6b7,
	0xe695f8a9,0x4747bf41,0xd4b9a189,0x034735df,0x0589938b,0xd8690b8b,0x81c73193,0xa69306bb,
	0x43a92413,0x2f1b338f,0xb673fa65,0xd08fd075,0x9077bcb7,0x7103af57,0x4f999677,0x1ed3733d,
	0x205f4133,0x6fef927b,0x77775807,0x27a1854f,0x25b93b87,0x2ad70915,0x2eb5ae1f,0x4ae5dfe9,
	0x29bdd101,0xeed7f4cd,0x7565a98d,0x232f4c57,0x0591d733,0x1835a9cf,0x13fda1e5,0x96bb50e7,
	0x7b4108f9,0x7363cbd1,0x045dfa8b,0x886b1df5,0x6ec15b75,0x3df34b11,0x7ad107a5,0x28c79ae1,
	0xbeef7313,0xc7a58151,0x8f051321,0xe7059317,0xbe8d3887,0xb3616ee1,0x851581b7,0x01fd0303,
	0x4d498dcb,0xd8311797,0xb67d17e7,0xb9318523,0x90b52323,0xc24fffcd,0x1b295ef5,0x1dcbdef7,
	0x4d4f6c19,0xd419c96b,0x726729f5,0x83a1ae05,0xdf7db483,0x0713f0dd,0x0bf13abb,0x922734e3,
	0xd4875579,0x4cebaa17,0x30e506e7,0xf5854827,0x23a30a61,0x907bdd9b,0x2ccd9cdf,0xaf815b75,
	0x06ef65e3,0x56bf4569,0xf69ba8d5,0x0891ae75,0x746f66f7,0xffdbaa11,0x79a399bf,0x20cd99d5,
	0x370b2dd3,0xa8213fa7,0x7ea7e65d,0x20f7fc53,0xa79dd0ff,0xa90722c9,0x34cf7235,0x0b79c7af,
	0x05dd5241,0xba29f59b,0x5aad1295,0x2d67adb1,0x7173b3b1,0xb24d9ccd,0x07373397,0x2f7bed2b,
	0x82e72ca9,0xe8631c93,0x12d19d19,0xc7153ef7,0x84b17ecb,0x348195a9,0x203d57c3,0x0743e2f5,
	0x4c2b6b05,0x90e56255,0x45b1b203,0x51b3cd0f,0xb2994687,0x5af75363,0x55c36511,0xe7c3f235,
	0xae29afcd,0x34410d2b,0xc873d9ed,0x1b73b561,0x0aef639b,0x837d8489,0x44298e5b,0x206d7495,
	0xc3e531fb,0x95879be1,0xc6b599ef,0x7d0535db,0xfbf31343,0x5e67e023,0x6e5152fd,0x1b357441,
	0x96e35d0b,0xda4965c1,0xe29d13a5,0xf99d0ce3,0x72671739,0x0e87c5bb,0x5d9f1ecf,0x7c894be1,
	0x3f2170f5,0xaa9b3a95,0x54cba529,0x5eed1965,0xf98f55b7,0x492fdd5b,0xc1f5ea2b,0x435f469f,
	0x03212235,0x510f02a5,0x0c618913,0xe525facb,0xdb2b7977,0x7631b78d,0x91b3d9eb,0xe9274027,
	0x77e939c5,0xdab55ebd,0xcf017681,0x4ef9b0ff,0x3f7f91b3,0xcfdf6d5d,0x29bddf6b,0x81d544a3,
	0xa0f7351d,0x371f4825,0x58cd4109,0x099b3c6b,0x4d49b225,0x830b4051,0x6d755883,0xdbd730b9,
	0x1051e637,0x5861b0a9,0x7c6778c7,0x4cbd3df9,0x49cf9307,0xcf073a77,0xe6bbaf8d,0xa0235197,
	0x0675138f,0x530b2293,0x42f10a55,0x3a8f9711,0xb8d33113,0x25a3ce57,0xe5f1fb63,0x722904e7,
	0x9267181f,0x7e2f60ab,0x0c0ddecb,0xffc509a1,0x7c936d83,0x4b3576fb,0xa1fd9f61,0x0fdb58d1,
	0xb1a7835f,0x9363063d,0xaddf7bc5,0xf38fd80f,0xf5d5ae13,0x768d57ed,0x583beb5f,0x71ababff,
	0x703bb949,0xceb32713,0x9505a35d,0xb7a36547,0x23db7cf9,0x70fbdd39,0x6c93bbb7,0xea8d4d9b,
	0x08a1925b,0x0eb5ef75,0xe4a3f42d,0x582fd4b5,0xc46328f1,0xb6555b65,0x89631945,0x47f11d53,
	0x03ddfb89,0xf47b442f,0x965d894d,0x6be5aa3f,0x73b36535,0x94ebaf7f,0xbf8dd961,0xf1c92b4b,
	0x59719651,0x03936289,0x9a539a5b,0x33fb6a51,0xcc8de981,0x4d8ddf0d,0xa6753de5,0x0a875831,
	0x8f5f58ad,0xc215804f,0xf7251b6d,0xbc1f39d5,0x882f120b,0x3391b81d,0x7bfd952b,0x8f1df52d,
	0xda292d15,0xd88f6bcb,0xe9f95d1f,0xfa857e33,0x9e5f7f8f,0xccc57137,0x4485da0d,0x76ff63e9,
	0x3cd19285,0x32132bc7,0x066fac89,0xefdd7d59,0x655fb747,0xf17d4965,0xeaf153e7,0xd41db691,
	0xa8d73c75,0x1c359f8b,0x56a9f347,0xc75dfdad,0xb1edc2ef,0xec8d2833,0x60a13691,0xf2e94fcf,
	0x1e3fb2e1,0x67051ee3,0x7b495775,0xf6b1e61d,0xf74fd0bd,0x9b433da7,0xbd794267,0x7a5582cb,
	0xcb8bf241,0x85151a17,0xcb71dba7,0x5e11de0f,0x6747d36d,0x8d73a24f,0x5fdb643f,0x8bd3332f,
	0x2dbd0b91,0xab79b9f3,0x74c3fefd,0x682bed6f,0x1213223b,0x256ff731,0x0ca75577,0xe3577525,
	0x3057c449,0xf1c37fc1,0x9b635d0f,0x2a351ca9,0x067918dd,0xb80905db,0x0f3f3be7,0xf74f2d59,
	0x4d593663,0x7203e549,0x79ef4df5,0x83db14a3,0x71bbb791,0xac956055,0x598949eb,0x18b1b0f3,
	0xad47705d,0x68cbfcd7,0x818d864b,0x3f55bec7,0xbf97430d,0x9ce10129,0xa3e35e5b,0x92ef659f,
	0x4725152d,0x552f1133,0x79dbb729,0x3151e503,0xba53e48d,0x7541eb63,0x8d2fa48f,0xcbf76185,
	0x0071fc4d,0x18c145ab,0xa0ff2e2d,0x5903d1bf,0xaaaf49cd,0x9487ca89,0xbad13467,0x643f0b51,
	0xcd2dd1b9,0x178f3603,0xcb97756d,0x001befe3,0x77ef4503,0xec0392a9,0xf8abb237,0x56b5ba2b,
	0xcfdfb5e9,0x5831968b,0x84c9f385,0xdacf6add,0xc7d36ced,0x1f8b2049,0x591deedd,0x18cf55bd,
	0x7987ddd9,0xa3b3d409,0x2e358b8f,0x27cdce93,0x1e9dbcc1,0xa56fd877,0x550b87b1,0xba7ff631,
	0xa9a53301,0xa5adb3c9,0x1ffd3d23,0xd047a771,0xff11343d,0xe68148bb,0xebd5868d,0x06338435,
	0xce3df35d,0x0c2bf393,0xc8c3c45f,0x87f32261,0x0a6f7797,0x5e13c71f,0xc35f01cd,0xa0e158ed,
	0x03d15165,0xa7c3e9b3,0xcda939d9,0xecffaccd,0x20796f8d,0xb9f5122d,0x4809bc49,0x29f7de07,
	0x35631415,0x8b8724f3,0x2a51b2ab,0xa81f949f,0x7f71e955,0xfa7df0f1,0xccb7c55b,0x5b6b2dab,
	0x3c7336e7,0x2d070c9b,0x50dde073,0x8c83a841,0xe41b36ad,0x9279d2f1,0xaacb18dd,0x29afb285,
	0x010789d3,0x84558077,0x49f1b147,0xb7dfd69d,0xa9b9cdcb,0x873f703b,0x62253f2b,0xe3b1c7bd,
	0x999d5153,0x2c0578d1,0xd4abefc3,0xb265cf1b,0xea09e96d,0x909d6957,0xb929ed1d,0x52e758fd,
	0x6b39e663,0x8127a671,0x86afe301,0x8ec7a1a9,0x9d5128cb,0x38e9e74f,0xdcb7a40d,0xdb3f8271,
	0x495d567d,0xc34f12a3,0xec21ee9b,0x0a355ead,0xba512f9d,0xfcf13bad,0x803351d5,0x9b2f30c1,
	0x960b0399,0x348dbf31,0xa7a132a9,0xac63b713,0x564d4621,0x6c0b807b,0xfd7ff0d1,0x8ba9c117,
	0x61c34431,0x39754663,0x924f2bc9,0xe7839c47,0xc505f90d,0x48053845,0x74fb27d9,0xa01ba11f,
	0x8b8b0341,0x79177b05,0xdbd15311,0x3845e02f,0xb8bbb99f,0xa533ee11,0xed8bea47,0xe67bef03,
	0xe0e16043,0xfd07085f,0x2a47be1b,0x45ddd537,0x62317d8f,0x0a67d56d,0x748f17f5,0xa7391969,
	0x3dc94f2f,0x5155123d,0xba53bf05,0x01fdee47,0x90ab5f17,0x90f36a61,0x3deb1d3f,0x85477f81,
	0xacc5387f,0xa493d4e9,0x7f178465,0xc8d75ecd,0xd1e93cef,0x04ab1177,0xc3ff92fd,0x9e1710ef,
	0x86d79931,0xe7d5452b,0x4235b957,0x811bbab1,0x922f5a55,0x03ddb7b9,0xe7afde89,0xa99bede1,
	0x937fa2b9,0xeeadb051,0xc3cf2575,0xbbfd965b,0x3c3dff01,0x1f5d72b1,0x105dd1bf,0x1a4706ff,
	0x28c3db15,0x8f2b5c1f,0xda874cd7,0xd52d26b7,0x5955172d,0xfa7d2069,0x4be94af7,0x3d0bbd75,
	0x4b21bcbf,0xc1e126e3,0x9381101b,0x12e1e131,0xb139d391,0x6b0f076d,0x6eb7d50b,0x595982eb,
	0xcd9d56af,0xc1e32767,0x525b4c57,0xc5c71baf,0x6a2d496b,0x996376c3,0x33a74755,0xd123798d,
	0x71b9ec61,0x2cc14cf5,0xf1397b27,0x6911ac9d,0x28f11273,0x204f65f9,0x5c1d65b1,0x40dd1401,
	0x077595cd,0x228fff55,0xe0bf52a3,0xc2758ae5,0x30c9ece3,0x2d231517,0xcff98077,0x9f75b577,
	0x8d57df6f,0x65ddbed3,0x480d6569,0x02216df1,0x83755b75,0x9fb1aca7,0xbd9f1481,0x5e615193,
	0x505d6a3f,0x7bbdc439,0x24c3c28f,0xe2c96da9,0x01374561,0x2a49ddb3,0xb9f16b29,0x89910c83,
	0x0c0b8bb9,0xcbc3a0cf,0x6b0795b1,0xc99da27b,0x88d19665,0x71c181c7,0xe04f3a4b,0xe779daf1,
	0x0a63edd5,0xc001de61,0x2579c6e7,0xe653c54d,0x1787deb9,0x2d693ae9,0xf29d443f,0x19072205,
	0x43e72f0f,0xe5079f37,0x953b9acf,0x5319cf8d,0xe919f317,0x471113a7,0x793bf7df,0xb9b15769,
	0x7f99825f,0x09e73e1d,0x51ef527f,0x34a19b21,0x97cb8cb9,0xfb0f1f09,0xe30d1085,0x7f67a147,
	0x72f94f41,0x6035ee5d,0x69b7cb93,0xda218275,0x3c5be959,0xf8311899,0xa575360d,0x5a9b764b,
	0xe20dd1ad,0x9c015bbf,0x81352025,0xdd470073,0x8e0f6b31,0x7fcb0461,0x5c539ccf,0x963f3d9f,
	0xbf53ba1f,0x13df4a8f,0xf38b46cd,0x42455085,0x02a938fb,0x85b1ceeb,0xea09a5a5,0xf7c5eee9,
	0x4bcfcd8f,0xe0df3797,0xf25db2a7,0x97d10e95,0xee69ddf1,0xd031ed41,0x977d7deb,0xdf21b259,
	0x37038579,0xfe95f81f,0xa5c9f34d,0x1719d70d,0xa411e9cd,0x181ffcef,0x340bbf79,0x66c38093,
	0xbeefafd7,0x6b1159f3,0x4c7554d9,0xc3d1e6d5,0x94e390c9,0x28cf63fb,0x359b10a9,0x839dc2c5,
	0xd0190f1f,0x46e5c35d,0x5b7f7fe5,0x8c2bbb5b,0x70a34b9f,0x000ff0f3,0xd88bc455,0x2521f297,
	0x257ffa51,0xf527d325,0x9e8d1989,0x68d7b285,0x45917789,0xee337adf,0x3fbd79d7,0x55433a35,
	0x68a5fce3,0x3b630097,0x57bf6361,0x7d09aac1,0xa06ff641,0xb60d8149,0x9497bd0b,0x58731447,
	0x518d76cf,0x61af3b7b,0x5fb5db87,0x3673a2f5,0xac81ce01,0xacefcc3b,0x26f5a649,0xcda3ebf9,
	0xc6b93c91,0x529b8c1d,0x4595dc95,0x6d455a8d,0x5387c983,0xdaab0c3f,0x8d3f7a6d,0xce45bcf3,
	0xfd293723,0xbb3bb347,0x6eff3da3,0x8433f173,0x5dc31801,0x19937a61,0xc4514acd,0x0e4bb35f,
	0x986303fd,0x2b1fca41,0x3815f24d,0x886f8811,0x91f9ed35,0x36797827,0x4f939547,0xfc29cbe9,
	0xca659519,0x345be2d7,0x1379aaad,0x51a9df4f,0xd569215b,0x10af2f9f,0x58e3e435,0xe0cd73b9,
	0x73b3d0f3,0x8b7fa753,0xaa4f735d,0xa217f89b,0x4bd7d129,0xba053351,0xd0a36e6d,0xffad2879,
	0x434f3285,0x279ffa7d,0xfc355575,0x4665b5db,0x7781fddb,0x96d11e47,0x8db9b74d,0xb6b91855,
	0xd6bb6947,0x624b97a1,0x7f4ff691,0x35cb797d,0x592d2d2b,0x7de3340b,0x6d812ead,0x9e65c1f5,
	0xd9f7f933,0x1797b289,0x404138cb,0xb1f7c667,0x901d0953,0xd88b00a9,0x73e3d0e7,0xa99f9485,
	0x2789dac5,0xc613977d,0x0229dabd,0x671de005,0x7a0f010d,0xc29ff8a7,0xeb3dc6d5,0x45dd8fad,
	0xe86f1af7,0xaed14b49,0x5ead1781,0x8bef6a41,0x5349e795,0x2a6f1913,0x847105d3,0x7b0fe397,
	0xb42d7b41,0xf5652b37,0xe5eb46af,0x019f0985,0x568d94a1,0xf0cb8773,0x76e3efb9,0x0ba790ef,
	0xb0c5119f,0xbfdf8d0f,0x3e897c63,0x73dd02bb,0xdd19846d,0x090931d5,0xa075f2e1,0x949708dd,
	0xb2b7e889,0x56d35f1d,0x45a72937,0x78dddb4d,0x7eb377b3,0x98f76ec1,0xa5872a27,0xad53cd0d,
	0x5d099efb,0x4551c829,0x2ee7ba43,0xb14ff925,0x319d13af,0x18e99d41,0x10fdfce3,0x07cb0fa7,
	0x4139086d,0x78edc77f,0xa46b3925,0xe86742ab,0x6a958217,0x73b3c4e1,0x7437beef,0x90715355,
	0xff4dccd9,0x61b7d4e9,0xe6d5ebf3,0x33d7becd,0x3ce11127,0x26a335a7,0x871950a5,0x8e370b43,
	0x65c308bd,0x124380af,0xed47f549,0x13d134f1,0x7a43d39b,0x618d2821,0x4805bee1,0xc28f3b19,
	0x919ded0d,0x5fa1139d,0x8563f43f,0x9305cd03,0xd2f940a9,0x26c35d55,0x1bdbe2fb,0x896d1701,
	0x0e615f49,0x01652efd,0x734ba473,0x66a7af6d,0xf5c9d40d,0x6b19bed1,0xedff02cd,0xf941a3a7,
	0xf60f9965,0xb19f6c97,0x91a37dfb,0x0e69a519,0xaff3ae03,0x35ddfe9d,0x505170b1,0x02fd5635,
	0x1127c9e1,0x4ce1feb7,0xf1895573,0xf47db771,0x0d3b3341,0xc0e33743,0x9b352b83,0x9213b451,
	0xf6adb3b1,0xf23f5027,0xfaa3fbf3,0x8d93d05f,0x77e1ad05,0x987d8bcf,0x0d8b7e9b,0xac75f429,
	0x2c234e55,0x2349a42f,0x8b0fdf19,0x78df5a4d,0xd8a7e905,0xbb7dc7c7,0xecb7a1d3,0x92979c67,
	0x458b65c3,0xe413b69b,0x1773a8fb,0xa011e023,0xb6d1d97f,0xbb33ff39,0xa49b5987,0xdf692433,
	0x05653a75,0xdb2d5bb3,0xcaefe035,0x575dad4f,0x581f3529,0xdb752eab,0xe797968f,0xa85d9337,
	0x7cb72167,0x71ab2045,0xa72587e1,0x7d756db7,0xe0d3173f,0x3293db2b,0xce8f1645,0x9d65219f,
	0x2aff2411,0xf31de995,0xa435bf97,0x9b8bcdc7,0x73b19f7d,0xc95fb241,0xf8e30283,0x28f3d813,
	0x1e41a06f,0xad979573,0xd0c56375,0x054f1a69,0x51f9921b,0xbb2b29f7,0xac7791a3,0x8ffb2fbd,
	0x12ffe8f9,0x11a99a25,0x71f7ac11,0xf8f5e107,0xfb6df7d1,0x55c720d7,0xf5aba681,0x11edb249,
	0x943be4ab,0xd265a677,0x2369ce87,0xbf2f8f8b,0x4e4fbddd,0x39897ded,0xc7637075,0x08bb99df,
	0x1b77aeff,0x055f41b1,0xf73f9c6f,0xcb2f145f,0xa76355f5,0x793fd0bf,0x1b010b5b,0x08d7712b,
	0x30b337ed,0x42a96b9f,0x961b23e5,0xdaa57e6d,0x01e95657,0xba3ff15b,0x10651f89,0x0133b355,
	0x8a73e3ef,0xc4d33c89,0x5f214f85,0x15c59d1d,0x17a519b9,0x5457a049,0x0df381dd,0x5b436c07,
	0x2db92c01,0x88ef853d,0x87ef8663,0x2f3fa05d,0x80d75f59,0x71dd2693,0xe08bd3af,0x1af7d76d,
	0x8e073d9d,0x6e916f01,0x3cab4c1f,0x8449b893,0xd441eaef,0x2f9ff5c3,0xdb9122db,0xfec1022f,
	0xad5f9abb,0x57c91b9f,0xbff3e0d1,0x3c91b6ab,0xc72724b3,0xbcf347e3,0xf8e789b7,0x9f936979,
	0x3c43b9d5,0x492b4563,0x8aede111,0x6a49ac0f,0x4d47b963,0x7ba7bf7f,0xf8edcf21,0x90df9af3,
	0xb9b3a5e7,0x89c7df17,0x6d39e5fb,0x2a278aa9,0xb8e93a35,0x200f079d,0x82870671,0x8099d4c7,
	0x93339e6b,0xc32fb405,0xacf72527,0xc359c4e3,0xdac9bce7,0xd0fd73cb,0x43152f83,0x5731a5a1,
	0x44c5b759,0x217707f5,0x26cd10b3,0xc793eda7,0x222d7bb1,0x47c3a011,0x0e7bd6af,0x57998ca9,
	0x78eb792b,0x73313733,0x6ddbf735,0x3305585f,0xbcd5754d,0xf03510f7,0xff19b4cf,0x3f439989,
	0x28a780dd,0x496d5687,0xebc3a3c9,0x8c65b8f3,0xb7050cf3,0x08a1d38d,0x95d34f3d,0x66230c6d,
	0xbb7b1fe9,0x17bdd33d,0x00a9fe09,0x04dfc3d1,0x1b7daa61,0xc1db1d57,0xda0b97d3,0xdea7f5ff,
	0x2767fc47,0x5435131f,0x232baa0d,0x982bcddf,0x137f59cf,0x5f35ec61,0x79a18ced,0x95c5d765,
	0x10efb073,0x97651475,0x006da873,0x2c776c89,0x06cd6bf7,0x5681a737,0xe8f9d963,0x72ed424d,
	0xeb156b65,0xbc610e0b,0x9c13f651,0xb27715bb,0xbbab1611,0x700fbcdf,0x82f37491,0x781178e1,
	0x175b9099,0x00b90f29,0x703b2d43,0x455dbfdb,0x76d911db,0xe6b544e7,0xa8f3424d,0xe1a50dc9,
	0x05c35807,0x24819f9d,0x8d8b2361,0x4adb81d3,0x1b9b3d8d,0x87c39f57,0xe2d9b2f5,0x4699842f,
	0x54cd6e2b,0x8a495fad,0xbb218b49,0x93213311,0x4baf3be1,0xd30b14b9,0xff096361,0xb85defbd,
	0xf17f93fd,0x5725a823,0x96a39411,0x78e30b7d,0x875d1411,0x1add7617,0x3265bced,0xe2e9949f,
	0x37573ef7,0x92a52a4b,0xb4318955,0x01514381,0x4d61d1d7,0xa40fbcfd,0x384d956f,0x2ca9877f,
	0x10593917,0x46db8fef,0xbe6d732d,0xfc1fb405,0x3b01256b,0xc5f1ab71,0x72a5cf45,0xd6914d85,
	0x150740d3,0xa05b1b59,0x9679b637,0x237f7675,0x2bfd038b,0x0a536c01,0x09cdf947,0x1c157c5b,
	0xac61a925,0x0e374751,0x73f7b389,0x3c2384bd,0x5a97456f,0x4d8b31b5,0x0ca9eed1,0x53255a2d,
	0x2bedf989,0x61fd6721,0x050968bf,0x353b5943,0x7f9348d1,0xde67d815,0x909b77bb,0x0c337da1,
	0xf7a98df7,0xefc54697,0x8e510ff3,0x487b8ef3,0xf2318feb,0x9e3b8331,0xd183e85f,0x32316de7,
	0xa21936eb,0xae1bc9f9,0x0af1bfbd,0x1a158137,0xc8356177,0x20db3f8d,0x51c5c197,0x2a9342a5,
	0x0c3fd95d,0x56178e11,0x4c8b0b39,0xd8bbebf9,0xf5dd68af,0xcc95a235,0xfa4150bd,0xf5474405,
	0x859d0ec9,0x8345882d,0x1b43a201,0x5d9d8ba1,0x6df1554d,0xfa3d68b5,0x3a5b4fad,0x4cc38ab1,
	0xec35c527,0xd3bba611,0x55b7f02f,0x4c6fbd1d,0x41ad7b8b,0x15271913,0x27f384bf,0xc5f79fd5,
	0xcc87def3,0x080b6e0d,0x110dbe5d,0x33611dd5,0xc0d77423,0xbb21a1dd,0x9f6d62cd,0xf0571d1b,
	0x8197d327,0x23459ee7,0xb8e3d1a3,0xab292bb1,0x99afbc4f,0xdc7ffa1b,0x63aba933,0x75d14ca9,
	0x54e74d3b,0x8afbcfeb,0x2f5f8b9d,0x76f5e51d,0xf8f755c9,0xdc13c157,0x3e0d03c9,0x3adbc92d,
	0x9e79cd29,0x274110e3,0xed218a65,0xa4776903,0xa9f366cb,0xaf2fdf9b,0x1e75aae9,0x7e651dd1,
	0xe4cf476d,0x82a98a17,0x214b4895,0xabe596cd,0x3663da0f,0xfda52571,0x3b49036d,0xf9e1663d,
	0xfcebc4ff,0xea431c51,0xd17fbd45,0x8fedae65,0x0689fed1,0x41c7ebe5,0x31673eb1,0x0141ee9b,
	0x2a4d035b,0x8da100df,0xf9dffc11,0xfdc3f035,0x812928c7,0xe867b47d,0x2431fa8d,0xa2f9d397,
	0x3ef9147b,0x9ed76987,0xad0dd513,0x6d173d27,0x2b83502d,0x70d7c947,0xdd8be15b,0xc7f9a259,
	0xbb71fed7,0x72752095,0x342b74e5,0x401db6a5,0xc959b1bd,0x8ce7dccb,0xedd749f7,0x53b3f88b,
	0xeeb75d6b,0x9f8d28d1,0x2edb049f,0xe3875e97,0x7cef6eb1,0x40edaa13,0xcbf5d7b7,0x44192459,
	0x164dffaf,0x1fb55d87,0xb34149dd,0xee87b76b,0xe7052cc3,0x03b994a9,0xf5491a79,0xd19dc46b,
	0x7e35899d,0x6ef91281,0x6dfb46b9,0x42cd6407,0x46dfb62f,0xde9b4897,0x0db32e95,0x8f3367ed,
	0xa0ef13b1,0xabefb407,0xc22fd9cd,0x2c8dc7d7,0x9a3b99ab,0x8d695a69,0xff975ce7,0x8a492e87,
	0x477fcae5,0xb7a966e5,0xe97b5e33,0x8279a6c5,0xbd5fca73,0x9e73e727,0x1bd5bac7,0x6ad56863,
	0xa96790b1,0x55b5a863,0x14054b83,0xc5c1c53b,0x8b0d4041,0x92893459,0x39d1ca0f,0x9347362d,
	0x8ca99b11,0x4c2bee4d,0x886dd5d9,0x42198823,0xfc83974f,0xfd01500d,0xd76d1919,0x4093290d,
	0x65c7147d,0x839946ed,0xc3d58dcf,0x2db394e7,0x4987b059,0xa3a9b0cb,0x3909e2c1,0xaa27e2af,
	0x77c1bbef,0x2711f90d,0x99dd007d,0xc941716f,0x08595095,0x9ed5d59d,0x8989ae5d,0x21f9b53b,
	0xf41d84e5,0xc42723f5,0x54ab5781,0x7ff32429,0x4dbdc1bf,0x7959e60f,0xfa4defcd,0x3479435b,
	0x1ad93753,0x6aeb5f6f,0xd4dff8f1,0x077dd3fb,0xccf37213,0x50835227,0xe339a765,0xc899203b,
	0x5a790fb7,0xcdef5bc9,0xb19d2769,0x80116853,0xf7bd9447,0xf4277273,0xe2af0203,0x3fcd6f83,
	0x6fff5f0b,0x624981c9,0x5883a201,0x945f2917,0x1e5fbf97,0x069727f9,0xfd8ff8fd,0x9603855f,
	0x86eb2ac7,0x7f8592b9,0x2db54457,0x999b5eb3,0x8f998fbf,0x1ca77c47,0xbf3df233,0x81b18677,
	0x5943cce7,0x7fb94867,0xabd5a681,0xaf77f211,0xb8ad44f5,0xdda54165,0x59995ff9,0x93c707f5,
	0x4f8593e3,0xdf75f519,0x8407bd1b,0xe0230c9b,0x455f63f7,0x2365b1dd,0xc507612d,0x57b7af85,
	0xa0b562b7,0x5dcd2399,0xbde9793d,0x4053b83b,0x3fef55fb,0x1a3910bb,0xe0676127,0x7373d34f,
	0x725550dd,0x1c533735,0xd7a16885,0x0f397f59,0x311f08bd,0x60f34985,0x911db7c1,0xc76f19fd,
	0xf8674a4b,0xbf150bb1,0xe5cf5509,0xd6870ce3,0x40338e79,0x28e39047,0xe30b4955,0x8e9b1abb,
	0x956daf81,0x8cab955d,0xb393e565,0x8a6dcc3f,0x52ebbde5,0x55df018d,0x289126bf,0x7e69fd31,
	0xfa67f575,0x8e2180ff,0xe2933cb3,0xa99f895b,0x2d89d23f,0x9e37425f,0x1a932d57,0xe6cb198b,
	0x46db45a1,0xaf0fd3e3,0x0aef9a8b,0x5d4f109d,0x92cf0b3d,0xaabd2047,0xf871a6f7,0xd2339871,
	0x28c71e01,0xdd818bd1,0xdb49fb0b,0x992dcef1,0x64014d1d,0x36c3314f,0xa80fe9fb,0x2595130d,
	0xfcaff10d,0x2a0d3f15,0x38c3b6c9,0x3b6d71c1,0xc0e1c095,0x30197401,0xd5cff93b,0xc061330b,
	0xed93c5c1,0xe7c5bc79,0x5eff22e1,0x2cc186f7,0x27ad72e3,0xd715ef69,0x14912411,0x9c895293,
	0x14f9d795,0xcc39ab45,0x002130eb,0x805b1cfd,0x952bf5bd,0xde85530d,0xfdb7a657,0xee7f1c51,
	0x9adf3685,0x0f7b2b45,0x64c70f05,0x93eb62bb,0xa49bff61,0x8bbf96fb,0x51254869,0x45372b6d,
	0xd5cb670b,0x8c1f74c3,0x8c15c7c5,0x2fa5479f,0xafc10a87,0xd6919bbb,0x153dff1f,0xaa1fab91,
	0x6abb021f,0xdf357887,0x4bafe247,0xa6391b8f,0xeeddf667,0x8951ca57,0xb6e18bd3,0xc12df8e9,
	0x6d33553b,0x88517fdd,0x6fb30223,0xf4dd2ef9,0x98b1a6bf,0x60cdb459,0x29711c5f,0xe8d1401d,
	0x7f35025b,0x0983cc8f,0xdac78777,0xe33f72c3,0x0281a3c5,0x2c5bb3cb,0x06cfeb1f,0x59fd1e59,
	0xf1419ff9,0x075f38e5,0xa6092ed9,0x23911859,0xc00bba37,0xedc98b37,0xaf5fdeeb,0x48254145,
	0xe25d590d,0x68f5d7ab,0x411fb165,0x728931a5,0xc3979b4d,0xf96b05a9,0x6a032b1d,0x0137070b,
	0x60078d11,0x77d99429,0x922964b3,0xb7555111,0x7de17cc1,0x161396a9,0x841bef91,0x0da91e57,
	0x86437003,0x001bd22b,0x15c9dae1,0x23a92987,0xfe2fb8cb,0x9d13fa3f,0x718bd89d,0x506b2651,
	0x9f93aa57,0x704d0dfb,0xff218285,0x53b52e6f,0x12416e29,0x9a3fd4f9,0xecb3bf1f,0x26ef4ea5,
	0x44f7f90b,0xf9837c61,0x57d346bb,0x6e2d33b7,0x665b2013,0xebe553e1,0x16774871,0x8929f779,
	0x7df5cd99,0xaf4faaa9,0x20012f1d,0x44430dc5,0xa53b5641,0x62d9cc7d,0x96398669,0x2989517d,
	0xe08bedf9,0xa7c11e9d,0x6e4fffc3,0x71a93187,0x98293cf1,0xe26d5cd9,0xb9d99765,0x94fffdd5,
	0xb13f14a7,0x1b6bf685,0x8fdbd94b,0x7c8f5463,0x46e144db,0x80738b81,0x95bb463d,0x5301ae2f,
	0x030f909b,0x8561892d,0x2849d8cb,0xf5a90c45,0x17a9c339,0xa53be77b,0x24bfaa4b,0x0581c4b5,
	0xd77de54f,0xc33305df,0x51bdb7df,0x98296f97,0xef4191c5,0x2b9ba855,0x6849c76b,0x88edf40f,
	0x3e8f6ac1,0x34f51463,0xbcd56c9f,0x69bfb543,0x50edaeb7,0x80e34e17,0x88392df5,0x143bdf67,
	0x76c5ed65,0xdd377505,0xd0b7c9a9,0xdaa1d4b3,0x7e6bdccd,0xc4e5414b,0xf2f59ac3,0x58dbba69,
	0x0d1f4e3b,0x810ba08f,0xcb031e13,0xe57b25d1,0x9801433f,0xe9f172fb,0x7d59972f,0xa2bfe93d,
	0xfd2122b7,0xc8056849,0xdfd9d579,0x2f850105,0xbc710dc7,0xd4ddfcb3,0x82cb1915,0xf859a08d,
	0xd0cd54d9,0x5c3795ff,0x59df17f3,0x286d5f3d,0x28fb0c9f,0x7cf9c079,0x052d22cd,0x3a9d8585,
	0xc0a5c315,0x0a318bf9,0xba356a1f,0x2a6779df,0x59615481,0x0c1508db,0xccdf6331,0x44f94dcd,
	0xd3abe06b,0xe105e503,0xd87d4d13,0x9a256ad7,0x27e5dea7,0xfe8728df,0x88c5d59b,0x0d635f91,
	0xff5f544f,0x52471467,0x02d9de6b,0x06d7cc91,0xed4b28cb,0x431d1c13,0xee4161e7,0xc44b7179,
	0x47c59ac1,0x520705ed,0x1deb7841,0x4a3159f3,0xa0d3d527,0x5b2b267f,0xd9337c6d,0xf4a32aaf,
	0xdf61a437,0x76d9bde1,0xc4d7512d,0xa8658e69,0xf8414a75,0x7a8574af,0x6bffc607,0xa3dfc2df,
	0x473175ab,0x19cdf90d,0x693b1c4b,0xf02345db,0x87d353ed,0xa779bba9,0x2f85ac11,0x71efa231,
	0x6eb7c899,0x7677ccb9,0x733ba935,0x9aa15cb7,0xe24fc14d,0xdadbd8f9,0x33290863,0xb9450151,
	0xd3f9aaf9,0xcae746b1,0x617b8405,0xeb8d4fe5,0xb8f706cd,0x1fff72ab,0x2ccbc157,0xaed38965,
	0xa3751f47,0x77b10d3f,0xe9199555,0x1119dccd,0xfb8bdd29,0xb4b39747,0x98cf69c7,0x820bf41d,
	0xd831bc7b,0x1fe5ff2b,0x15bbc23d,0x43f9a15d,0xf84de197,0x294b5dd7,0xda17e10f,0x7ce1ab9d,
	0x5bab4e11,0xc915d3c1,0x69818c59,0xe75fbbfb,0x7bff35d3,0x809985e5,0x5a03f305,0x23c36a95,
	0x25e77403,0xfb55bac9,0xfd0db1c3,0xa8fd6b93,0xf1e52017,0x4fef177b,0xa877f809,0x55a7dc29,
	0x5d6542c9,0xe135fc8f,0x9f81cd15,0xa103af8f,0x83bfab1d,0xdf1f0323,0x9bd374ef,0x6bfd3c07,
	0x772be35d,0x67c999dd,0xf67df567,0x7227e7d9,0x39cf461f,0x487bc1e9,0x70fbbb15,0x5ab9f657,
	0x56b7333b,0x5ea1ebfb,0x9e295e55,0x699574db,0x1ad964d7,0x98d5f553,0xeb4f8853,0xd04947c5,
	0x6e0f645d,0x97d144b5,0x4921f7f9,0x9f05577f,0x4c1d1f7f,0xef7f076f,0x74b3a703,0x55a3dd79,
	0xddb19d3b,0x07e98e55,0xe0890eed,0x14a5d12d,0x315dd2d1,0x9e49cac5,0x3d898dff,0x6e37751d,
	0x94a198cf,0xe5fdeba3,0xa403ec49,0xd72903d3,0x8cddc007,0x49891a5f,0x5cb100a3,0xb7f77cdd,
	0x705f4695,0xcb9d57eb,0x49b175a9,0x1dc391d7,0x9f5dacdd,0x080f79c7,0xef8faec7,0x0b55b361,
	0x5cf16a87,0xd4dd46f7,0x1e37cd27,0x6a233e27,0x481f8389,0x832db507,0x3a03d4c5,0x9b45c7d5,
	0x74d53d1d,0xc04d450f,0x24b3f15d,0xa87d8c29,0x24e7f2c7,0x16b380ab,0xc671db79,0x1537f9e1,
	0x21110b53,0x0eff96ff,0x36cb5d65,0x4f835fc9,0xb1f50dd1,0xf0f719b9,0x85b9f839,0xc11db9b1,
	0x3923d6a1,0x2487da11,0x249fa8d7,0x80659d71,0x6a0bec63,0x32c7e5bf,0xef41cce3,0xa16947eb,
	0x230ff501,0x66f5a40d,0xd4cf27cf,0x26d7ca0b,0xe66d4ab3,0x0f7912c5,0x20e507d1,0x930d55bd,
	0xf355b0f1,0x5edd233f,0x64818ae7,0x190baaff,0xfedb297d,0xecdb3755,0xff0b03d9,0x6d7da4d1,
	0x8cfbe965,0xd74fbe6f,0x47557f37,0x37b3e63b,0xe9976dfb,0x8341f279,0x54956859,0x22a7a74f,
	0xc17fb1db,0xfddfb4e9,0x676d4e5d,0x8dffa227,0x5b6581e9,0xfd7f8bbd,0xf2e5c929,0xdf011fe1,
	0x70e5f24d,0x829dbe77,0x456b7e6f,0x71a325ab,0xa785f37d,0x18e39327,0xd1db46a3,0x297bc1b3,
	0xa9af0733,0xb81dab61,0x18717209,0xa2cf7833,0xdfb91573,0x45418145,0x2fd92da3,0x0389d06d,
	0xc8df6189,0xb36f0473,0xee210843,0x6c3901ab,0xf4459f07,0xc4eb571d,0xb1c39781,0x0919c03b,
	0x99f726c7,0x6c27aaf7,0xca9f3cbb,0xc30f2a79,0xd3e94bef,0xccb53e3d,0x82fb0a17,0x90a1d5c5,
	0x76f7d0e9,0xdc5578b5,0xc889c787,0x6705fb89,0x8be77c67,0xa3ed28ad,0x756117c1,0xcb11c635,
	0x6865ce67,0x208bdff9,0x3903bd43,0x024bbe45,0x6803d52b,0xc46770f7,0x2159ff55,0xe3db5737,
	0x453f223d,0x97dd8b8d,0xc3b12f09,0x49959c95,0x127ddf71,0xfa757a25,0x05c34c31,0x20f3fef3,
	0xd30903e3,0x03dbfeb9,0x86b3ca71,0x1c1540e7,0xb417a8f7,0x84e94fc3,0xa803762d,0x02c78413,
	0xe5c57f55,0xa8993549,0x36a97997,0xa37d7621,0x141563f3,0x351545d7,0xb3fb81a5,0x644d9dc3,
	0x7ff3150b,0x6ca74385,0x3eb90315,0x73fdc7b1,0xb8370723,0x8ec998ef,0x1c0b9f71,0x9af593ab,
	0xf2995a01,0xf919f639,0xe083aa05,0xac49217d,0x04bfedbd,0xe85b0e13,0x3917cceb,0x96b1ddf7,
	0xfd3597b1,0xd97f72af,0x5429cdff,0x15936ff1,0x5c6f777f,0x8a9b92cd,0xea7f73ed,0x01f5c54f,
	0xedcb6c13,0x9bedd6b1,0xe84d8b21,0x438b3ff9,0x408ba89f,0xd0dbdd27,0xb6270ad3,0x61af02df,
	0xc0dd69a1,0xf0f3d887,0x22115a01,0xb4655efb,0x70d5c9db,0x48eb0bab,0xe871b473,0x3555604d,
	0x416db757,0xcba366fb,0xdd17afbb,0xf0d37ae1,0x0b8b0869,0xd3214565,0xb43de02b,0x16d757c9,
	0x28fbb0ad,0x8191495b,0x6b819de7,0xac05c219,0xad731607,0xc24b59db,0x52ede9d5,0xdaa7b3f7,
	0x3f8d859f,0xeacfbf6d,0xb5f172a3,0xe3af838b,0x91cdc8eb,0xfbbf611b,0x2467b9c7,0xafb93005,
	0x7ba1daa7,0x81ed217b,0x5b8b5885,0x0003cea1,0xb25dbbd3,0x174b5bad,0xcf0764df,0x3f7b179d,
	0x223b68bd,0x83fd8053,0xd1edf6a9,0xf3b31343,0xe763edf7,0x7f45d29b,0x5fb5cc75,0xcde3e6e5,
	0xe6dd9d5b,0x1093453b,0x853d10a7,0x5befc1dd,0x07a1630f,0x907b776f,0x69cf3e65,0x5961ea8d,
	0x0b893a7d,0x49bfd1fd,0xf819269d,0xa06beb5b,0x0859c359,0xba43c433,0x27371505,0xbae7dfb9,
	0x80bff69d,0x741520e5,0xe3a71521,0x1359e123,0x1d4ffb8b,0x9e6b9b71,0x98515733,0xc5e99417,
	0x05851cb3,0x16a564bd,0x5787b54f,0x1169d521,0xd8c3dce3,0x3147e835,0xa3ff5849,0x685785cf,
	0x47592c39,0x1b01a8cf,0xd9db7cc1,0x21d179bf,0x4b79bd19,0xd9a93e07,0x37a1581d,0xcaa1838d,
	0x023f792b,0xed3d70e3,0x87451d8f,0x163da1e5,0x24b11667,0x90e578ef,0x671b230d,0x6fbd4c79,
	0x20b9cc03,0x9beb5943,0x32e72655,0x2ae5e101,0xd22d2785,0x02c95d7b,0x8ccfb1f1,0x551d303f,
	0xdbc901b9,0xf81bb6bd,0x8663a22d,0x26772afb,0xa03193b1,0xada938b3,0x699dca23,0x12afaf07,
	0xdaefabc9,0xb55f3697,0x21dbb8b1,0x7a27743b,0xd97b02a3,0x02578023,0x44e79d7f,0xfae9197b,
	0x5431b02b,0x89cb7e9d,0xbbf14dfb,0x61a751af,0xe753c093,0x842571d1,0x0c916a5b,0x3abb30c7,
	0x2c0de959,0x4defcd17,0x41c7a2a3,0x032798bd,0x71755e3f,0xe8e5b44b,0x74fd1b95,0xf997c693,
	0x1587c651,0x1cdf98d1,0xf701f3c5,0x8f5bff51,0x7e2750df,0x38e7f697,0x190be887,0x796f5d09,
	0xb221ea87,0x742b3113,0x95bd1afb,0x6175bbd5,0x9229922d,0xef019043,0x9a1ff507,0x36b5c6d5,
	0xb1dbcdf9,0x53e75dab,0x6ea12e5d,0x1f252533,0xd0bd4063,0x18832157,0xc01bf173,0x085dc71f,
	0xf33b5d21,0x5ea3fedf,0x88cd2089,0xd89f52d5,0x1ba73e3b,0x753f325d,0x995fbaa3,0x3fd7b193,
	0xa33f98f7,0xf973ad79,0xc1e16095,0x2895bca3,0x3327d2ed,0x9785d45f,0x9acdf9f3,0xc9150a59,
	0x5d6d36f7,0x6be75ac5,0xee037a1d,0x5439db0b,0xd6014a37,0x042b40e9,0xbfc9c539,0x4a89261b,
	0x4bc34119,0x0011f08d,0xf7d3b539,0x6b3bc6f3,0xe1759451,0x52817a01,0xaa353ed3,0x4527ca05,
	0x46c3b5d9,0x2285f119,0x0073b687,0x67cfd9c9,0x7145e5f5,0x4c57ea35,0xc273359b,0x345dcbbf,
	0xf573282f,0x82551735,0x7f851f1d,0x4ea74d73,0xffb3585d,0x0e03048b,0x5763c4e7,0xae21b175,
	0xed515f97,0x310ff62b,0x632b2c97,0x4ef3dc5d,0x85838943,0x2653e491,0xbe67f495,0x82e351cf,
	0xd263f80b,0xc2cb99c5,0x3007590f,0xe2676171,0x99f53ae1,0xb69dee4f,0x736358fd,0xdd9773f7,
	0x77270201,0x6e17264b,0x213bfb1d,0xed357819,0x92cbf3f1,0x92af6e51,0x38b9b2f9,0x63ab6f99,
	0xfca1a279,0x2c057887,0x486be5df,0xde0d1c3f,0xa4499fad,0x60dd399d,0x37498fe3,0x5515ccdd,
	0xf253b2e9,0xd827c5c5,0xadb508eb,0xce234a4d,0x012f2dcf,0xb9f94dbf,0x1e77e997,0xac45e46f,
	0x763d614b,0x50913bcf,0x6fbf105b,0xa1299f2b,0xfac13291,0x495770c3,0x4423c66d,0x3e2d7f77,
	0x54e5d01b,0x95d5a0ef,0xe3a704cd,0x2551f847,0x20bd86ad,0xecc5d131,0xc4b1d941,0xda3f779f,
	0x2949b651,0xeb03f3ed,0xb513eb57,0x334b1387,0x616be75d,0xd497a613,0xa3032169,0x6a6f5713,
	0x7cedff69,0xf5af0c15,0x06216595,0xce4b2f59,0x2987965b,0xa39fcef3,0xe8798ac3,0x132bf87b,
	0xe7d36b5d,0xdde7392f,0x8f7751a1,0x4403aaa3,0x8457f9e1,0x8f2f73db,0xc4f78da7,0x53692701,
	0x307d2ea5,0x6e43e389,0xc0356a15,0x4ca3a4d1,0x3b9b3ca9,0x7f19a555,0xaeddcef1,0x249b3e51,
	0x6beb923b,0x33d12be7,0xddfde609,0x2adf9dcd,0xf795eded,0x2daffc6d,0x830fbff7,0x1aafca93,
	0x1da3939b,0x9e238b99,0x24f11919,0xcbe91601,0x5f09a167,0x47c33aa9,0xa4ed3e97,0x84192873,
	0x57a384bf,0x1f4d7465,0xe7b3135f,0xe7732e55,0x37378f51,0x8ca7ea17,0x1e5b3529,0x89cd2519,
	0xda6fac1f,0x4bdff097,0xaf654175,0x1fad4837,0x83e13467,0xee2bfd3f,0xbfbb3a89,0x4f3b9e31,
	0x3509e4b5,0xfaeb42f7,0x5bab0c73,0x214ba58f,0xa74bf1df,0xb0a56f2b,0x3fed320d,0x125521e1,
	0xe4f33dfd,0x660786d1,0x42a379f7,0xc37d08c5,0x8235ad75,0x8ae5e365,0x5c55eb93,0x4b8f8ed9,
	0x762d9bf1,0x493f4fed,0x50f1cc17,0x27f954c5,0x93e17163,0xc63d45f7,0xf8d3c375,0xcdd7b43d,
	0xa33d5709,0x03294a99,0x29b9216d,0xdaed2cf9,0x1a130c63,0x5e7d6b6d,0x3fcb4289,0xe6a3f1bb,
	0x7521dc3f,0xb4d7db9b,0x469b1517,0xf30b954d,0x310bb1b1,0x21fbb0cd,0xc21fbe2d,0x7de3d77d,
	0x635d4d11,0x61d7c03d,0x17b75eab,0x31899227,0xf38b9903,0xd1859ba5,0x972ff839,0x3609c62b,
	0x73f31f73,0x1041ae4b,0x23b37245,0x2215c871,0x9ad79e95,0x407179fd,0x7cddbf07,0x8c078eef,
	0x5b65bde3,0xe8a3f40f,0x27af207f,0x3ae31d99,0x9eafe321,0x748d025f,0xf78f8d73,0xf7511373,
	0x9cb3275b,0x560f1853,0x374d3671,0xfca35787,0xd5556be3,0xc62df3d5,0x72212ad5,0x09d7e5e3,
	0xa9618f53,0x26197a5f,0xdcaf1db9,0x128bbca3,0x938dc291,0x0025b5e9,0x5dfb4b07,0x900be8e9,
	0x0173fdc7,0xa8d1f1fd,0x38777c6d,0x7249b3db,0xcc979567,0x7fc3f8a7,0x52fb2e63,0xb0dfefab,
	0x5367ef2f,0xd0c96f7b,0x21c7d529,0x7c0f6495,0x32355721,0x54db5495,0x2f8341c5,0x0dc55dd7,
	0x9c41f487,0x53179b9f,0x46412705,0x1a9356bd,0x54abdef5,0x61bfeac1,0x3877be85,0xe2b1c797,
	0x47815347,0xc74777b3,0x4a078d9f,0xe30312bd,0xc2b9089f,0x7b4304b3,0x39394a7d,0x26119193,
	0x4f2da56b,0xc76ffd85,0xe7bde10d,0x3511c17f,0x29a1545b,0x88b5b475,0xa3a99807,0xa8db90f5,
	0x5bc3796b,0x101fbf5b,0x108155eb,0x5af3cc6d,0x752786df,0xa3e97491,0xb02b05ff,0x3681ab69,
	0xe447f243,0xa06b87ff,0x0bf91d53,0xa9577d71,0xef8b4969,0x3931c811,0x7da13fbd,0xb4f17717,
	0x4e3b676b,0xd9e5fabd,0x984304dd,0x9f719ef5,0x618fc9af,0x275fda81,0x316bdd1b,0x44a1daa9,
	0x0da104df,0xa09d335f,0x0a0516a5,0x06f11be1,0x327759ef,0xdfc51fe7,0x176b0275,0x607fad4b,
	0xc4fb6b17,0x7b25662f,0x6c5f3945,0x140d9fa3,0x880110df,0x8633f4d1,0xc20500a1,0xfe0156a7,
	0x65494f0f,0xb28f7ff5,0xa0f1cfd7,0x85733621,0x667569bb,0x10ff3e47,0x2a1bf4fd,0xad196ee3,
	0x4e0f1a41,0x7271c5fd,0x7fe159f5,0xc455ebc7,0xd08fe43f,0x68f909d3,0xcf0d6963,0xb8355ead,
	0x6d518aa3,0xe8d7760f,0xf7cf13b7,0x04696d7f,0xe795a4a1,0x89732d7f,0xd6bff429,0x444bff2f,
	0x5f8b52b5,0x66576677,0x2ddd95b9,0x63dda8b3,0x0b47139f,0xa03de7d5,0x2d93d82d,0x70c93a11,
	0x8fc5b96d,0x7e03a5ff,0x9daf7515,0x0b656b4d,0xf9e97e71,0x2dad7fe1,0xa669a4c7,0x77a5a97d,
	0x577f3a45,0x256b1bef,0x3963e363,0x4e3103b7,0xf03bb6cf,0x2493e529,0x1aa5d5d1,0xcd51381d,
	0x1eb92539,0xd4a12813,0x899d4ec1,0xc9f5e0db,0xc97fb2f7,0x0a3f4fbb,0x8a2773a7,0x40bbc11d,
	0x7bf93ec3,0xa63942b5,0xcd7f01c5,0x86e33221,0x1f792d9f,0x1687e01f,0x3b53b321,0x1b59b027,
	0x543d5fdb,0x77439c9d,0x1aadc38b,0x17ad8777,0x6a694605,0x53b93f5f,0xdb099599,0x4119a163,
	0xfb0915fb,0x0753bf17,0x7d4577ab,0xb9837143,0x21111fe1,0xbea93f05,0x9cad88e9,0x5073017b,
	0x525d431f,0x18792bed,0x17edbe43,0x74192071,0xd8b3836b,0x66ab791b,0x5a1f076d,0xc253ad99,
	0xeabfbdc1,0x8f49fd67,0x43c593e9,0x39a1066b,0x65137d61,0x8d8df02b,0xb3c337fd,0x0a2d9369,
	0x232df0d9,0x92d38651,0xb06ff1b9,0x06cb751b,0xf871fef9,0xc7a3af41,0x307b8df3,0xb5f55115,
	0x492d7be1,0xacabf1f3,0x840b6d4d,0x02cb3eeb,0x43917df1,0x1bbf69e5,0x5da7692b,0x8e1bd543,
	0xb8bdd2d5,0xe8e1e419,0x7b3fd8bd,0x9f5356c5,0x95b39481,0x23351c1f,0xef2bb5fb,0xb591ff21,
	0xfc5fde2f,0xf607190d,0x092be2a5,0xb8957013,0xfc99a163,0x29d3aa7d,0xdf698d41,0xc9c93e59,
	0xed199ae7,0x45310597,0x7771b61f,0xb5419ebd,0x648567cf,0x4ded8207,0x8f41d457,0x02b53313,
	0xd26bba77,0x29f17703,0x06359ac5,0xa68bf731,0xb83baf83,0xa0553849,0xe615dd13,0x52c94df9,
	0x825542dd,0xfa57331b,0x0c1594b1,0x68232e55,0x00fbe4b7,0x445d2b49,0x71c905d3,0x86f57037,
	0x815b2e8d,0x2ef59827,0x1635047b,0xc03f3995,0x8689b825,0x8fd72195,0x86bf596f,0x66ab8b75,
	0x227f0c85,0x82df3cf3,0x0837473f,0x7f8deedd,0xef25bf05,0x2b13ea33,0x5fd72f41,0xd3dd41dd,
	0xa743a03f,0x13a590c9,0x3c3f5697,0xa141a493,0x5f911315,0x30e7fcb1,0x3e75cb25,0xeaff861b,
	0x5fa981b3,0x815b7b71,0xa2ed689b,0x6b0bd1a3,0x9b0ff28d,0x4ea31917,0x8a7bfd73,0x22ff3b57,
	0xca31bd5d,0x0e91fd37,0xe3618fe9,0x8d1fad75,0x23636027,0xe419e7ef,0xf249c305,0x6d53d53d,
	0xb3e17435,0xc059cee3,0x7b415b97,0x422fcff7,0x58cdc31d,0x23999a43,0x8ac1e535,0x55ebf7f5,
	0x58377bb7,0x7e4701c3,0xdead7741,0x6f6bd191,0x9a118729,0x31f9899f,0xef4999df,0x233b182b,
	0x8137fddb,0x326d9f9b,0x98454b01,0xc489eb2b,0x646fbc83,0x4689d809,0x61bd235b,0xf6311b05,
	0xa763191d,0xe95b4abb,0x692f9b6f,0xdbb79633,0x73a9b7e9,0xcb19100f,0xea857083,0xea43f633,
	0x11bb8075,0xf223dde9,0x690b29a7,0x59a72c8f,0xe201b293,0x7bffc4b7,0x787fbcb3,0x35614fd9,
	0xf5c51b5f,0xfe590c71,0x25fd5343,0x0d8f88ab,0x483b6a3b,0x8809318f,0x010d2fc1,0x47fd1ea5,
	0x977fa5d3,0x420d021b,0xc4a3b25d,0x111da571,0xdd97c11b,0xb08dda9f,0xa0137e0b,0xed0949bf,
	0x696d504d,0x93d30333,0x2021bd8d,0xe8853e4b,0x97d75ded,0x69592c73,0xb7f3886b,0x69f948d3,
	0x2c915fc7,0x8cbb0c83,0xea1967f1,0xa2776f23,0x4b3f4beb,0xf8c11c11,0x118dfc37,0x9ebbc409,
	0x106dcdb7,0xa8597353,0xcaafc11f,0xf8275463,0xca8f9acf,0x9797c705,0xfc45f34d,0x25c5340d,
	0xd303e81d,0x64bd856f,0x80819531,0x6d47aaf3,0x070bfed3,0x912f135b,0x6dfb9405,0x74078207,
	0xe0d3f16f,0x627b291f,0x00b50cc5,0x70097041,0x307170b1,0x63574f9b,0x2313b139,0xf8f5a7a1,
	0x74e1c0a7,0x84a37d31,0x96e94cf1,0x791d8233,0xd507cda3,0xde63d2cf,0xbe6f6a45,0x3e7d4f07,
	0xb8b16141,0x10c778e9,0x05431751,0x2bb73f35,0x018f7763,0x45259c81,0xe96fcb01,0x091572e1,
	0xe43fb337,0xcefb8c17,0xa46369ff,0x75892633,0x6149f42b,0x6ceff4bb,0x73f76bc7,0x77adfe59,
	0x5e130aff,0x29cf3f01,0x836b1f95,0xaec37693,0x5df78eb5,0xdd930c07,0x74671171,0x23b76d1b,
	0xdb2dd199,0x4e57d273,0x87fd8f2b,0xba19d041,0x3fdbf63d,0xf1639b71,0x67a34d5b,0x41256b51,
	0x7f0d247b,0x4c23dfb5,0x8e3b2c5d,0x24bdd3a5,0x4db9de79,0xf531847f,0x510b1d5d,0xbe6b75a1,
	0xfbb9759f,0x3547f893,0x88c72745,0x465fc1ad,0xecd19fa5,0x484f713f,0xda838bd1,0x64777939,
	0xb1af2b81,0x3e534757,0xa0c30c7d,0x61351bc1,0xc0e5d67b,0x7c8d7439,0x746d4f91,0xf6bf73c3,
	0xcff1411b,0xde5b2ec9,0x55d1651d,0xc1ed43c9,0xcc390435,0x7641a877,0x75a96bf9,0x53331367,
	0x7405e5e5,0xeeefea35,0x9e1556c3,0xdfb91c33,0x8f8d2e8d,0x8c3bd183,0x3b9bd0e1,0x924756cf,
	0xc9eb1ddb,0xcc232d65,0x062d4385,0x7c4da7e5,0x2a237fbf,0xa7cdfb67,0x4a23faa3,0x26e92d27,
	0x2c236175,0x7487c4a1,0xd13f69fd,0xc3dbaa4b,0x79bfe681,0x64c71aaf,0x6ba5921b,0xfe8f1617,
	0x43b13dad,0xa92d34b5,0x18e98549,0x6d15474f,0x3aa1b60f,0x317fac61,0xd1030c9f,0xa129c1c9,
	0x2817f3ff,0x0da95aeb,0xed516cff,0xd92da35b,0x278b4623,0x6ec3560b,0x319d4c0d,0x5129b0e9,
	0x7f571a65,0x480b0d0b,0x7517b53b,0x33d38359,0x19c192f7,0x8fe985b5,0xeb553ebf,0x2b83d49f,
	0x9df33b57,0x20e7b961,0x0d5b4e97,0x933becb3,0x2903dd47,0x3abf11e9,0x22917f8b,0x47a52e95,
	0xa6ed75d1,0xa34d06b5,0x69c3262d,0x1815c551,0xcb934a49,0x6799d9b1,0xe22df5cf,0xd78570f7,
	0xabc51d4b,0x3cd17453,0xb46fc595,0x0d9573a1,0xf63583b9,0x814b6497,0x3b917563,0x47939e6f,
	0xcc7f59c1,0xdd83fa05,0xae01f2eb,0x096d7e89,0x3c2957d3,0x852382a7,0x669b5ea3,0x5ec1aa25,
	0x579dc7ab,0x17f7a813,0xcd9b50c9,0x0bcf2d77,0xef31594d,0x22f5ec67,0xe1ad3e65,0x5e8117c3,
	0xea211805,0x413d4749,0x60e1fe47,0x9f6b2851,0x3f917f63,0xdd13e2e5,0x91ab6e07,0x22c79b73,
	0x8f8db047,0x90e9f8f1,0xabf13703,0xf9751783,0x5c09c5d1,0x2851cfa9,0xe1f7b361,0x4203b9e1,
	0xe1e14a6d,0x410bd6d3,0x096ff313,0x199f43f7,0x91dbcccd,0x8bfde4bd,0xe471e0cf,0x2d276835,
	0x29a194ef,0xae35933b,0x0a7f8713,0xea1b3717,0x6ccb7915,0xc1ebbcab,0x717d7527,0x4fa5ac1b,
	0x7dd1d2c9,0x777b18f3,0x96bf441d,0x5f995acd,0xd71993df,0xd66dfa7d,0x47fd3bc7,0x2f6f3bbb,
	0xe3ef7b73,0x9e6d2b43,0x0c5517c9,0x994d9981,0x39876ae7,0x4855e9bf,0x2d51ec89,0x8cf91dc1,
	0x6ffddae9,0xa71f05f7,0x5fe12c33,0x00e7fe21,0x9b577069,0x28f51e77,0x0d5bcbc3,0x83334955,
	0x6481b1a3,0xb821fd57,0x3c8387f5,0x6a9b5413,0xc24ddb1b,0x3c1d1533,0x1a814a53,0xa78f4621,
	0x5279d49d,0xba871e2f,0x23e1ae29,0x351bc745,0x52ab463b,0x1823d2fb,0xed9fa591,0x29ffcc4f,
	0x396bcd4f,0x79e1cdc9,0x8e1b3e69,0x6999841d,0xef2f517f,0x45d78559,0xa61d8757,0xf4f5648d,
	0xa75579b5,0xc44369ef,0x09d394cd,0xdbc55787,0x591f4125,0x608b2257,0x09d7a601,0xcd6507ff,
	0xd8bbac49,0x8a3de8e9,0x5c2b69f1,0x49d54eed,0x903b9de3,0x360f087f,0xa5356465,0x72bfc053,
	0xd89fcc03,0xfee17981,0xa0c572ef,0x7c755839,0xf2c7d4f7,0xe6b99edd,0xeb1571e3,0xbef547b1,
	0xa081745d,0xb7c32305,0x69c3015f,0x66dde1d5,0x5d83d817,0x0559f4f7,0x54db6a4f,0xc679a8c5,
	0x38671553,0xccf5653b,0xdfc9a35f,0x46bb7aa9,0x4bb1bd81,0xb73f62db,0x82677607,0xf83ddeb7,
	0xd6cf935d,0xf907d86d,0xe1f5c385,0xc4437223,0xf7155fed,0xd4412911,0x5a1de9e1,0x3db57531,
	0x00bde777,0xb90bcd69,0x25ed48ed,0x12277829,0x77edfe93,0x06ad10a3,0x28dde73d,0x1ad1285f,
	0xa9b3bf1b,0x6c95ed73,0x57cf372f,0x0d973d29,0xe501dd31,0xeb570b1b,0xc20bfbef,0xce0384e9,
	0x53b31c41,0x75b5da5b,0x3a414e69,0x5e471209,0x738de3fd,0x3193d283,0x9f87c255,0x703d87f9,
	0x2f3df563,0x58ffce67,0xc661ab31,0x96698835,0x97573fb5,0xbb2f8965,0x01b78147,0x14f13f3b,
	0x3b57d57d,0xdd833c63,0x4bd566a3,0x52ad1197,0x229f0191,0xbc7f5acd,0x0f77cc1f,0xea1368d9,
	0x657f7c09,0x2cd36f97,0x90bd3659,0x5a47a099,0x6629bf49,0xdc551a43,0xf62f22b7,0x58131379,
	0xa9b97cff,0xf3032bd1,0xf1bb0c6b,0xbee94825,0x5135331b,0x5405e3cf,0x09bb916b,0x21e33e4b,
	0x3287e0db,0x7ea54d55,0x81f1b775,0xfcc3dba5,0x9185dbbf,0x0f5dbbff,0xe4835113,0x84f578f3,
	0x78ebc495,0xe0c968f3,0x2b018291,0x1a8b8f01,0xb35b9c6f,0xccb12fdb,0x87656709,0x593d839f,
	0x6465f9a7,0x0d016bf1,0xcd0dd559,0xc96f96a7,0x417b5ce3,0x3cd3f4ef,0x79c34529,0x3129eef7,
	0x6af9a60d,0xf9613c19,0x5eb7d3e7,0x8521c77d,0xe525a959,0x23158941,0xe98369cb,0x79afbc27,
	0xb12be441,0xbe7957b9,0x0d23fed3,0xb3d536ef,0x861d5289,0x7549d35d,0xcb01ffc9,0x9a3ffcd7,
	0x29f9633b,0xb75d7597,0x5befd339,0xc63fdae7,0x6aa30dad,0x7bbfc24f,0xf9257e7d,0x14cb7333,
	0xb6e70677,0xa19d24fd,0x45416ab3,0x578b29cf,0x5779147f,0xf14ded9f,0x554b49c3,0xa5c731e1,
	0x47f585ed,0xbd4d6db9,0x59b71b5b,0x4d71ba91,0xafe1c537,0x23433557,0xe75b51f1,0x64233c11,
	0xfba90e19,0xecfd700f,0xe07717c9,0xf81fe497,0x959f4293,0x11736201,0xfdb3b3e7,0xe1512567,
	0x3f01dff3,0xd5c104cf,0xf71f0f19,0x32495fcb,0x08f313cb,0x8e2dc4a7,0x4d3758f9,0x4943b211,
	0xed81f0f7,0xff295d3f,0xb1d5cce5,0x811fe495,0x08a1c499,0x5e47d6d3,0x11479705,0x826b76b9,
	0x712b8b1d,0xf347a32b,0x3b39d947,0x3457cbe3,0xb1e78537,0x5911da91,0x2bc7d063,0x4dbb7887,
	0xe281ece1,0x5eaf98db,0xf46d18d7,0x861daf1b,0x608dca5f,0x885b7a69,0x451713ed,0x66a7cd25,
	0x2885e93b,0x3073391b,0x95136cb1,0xbb29082b,0xcecfed4b,0x487b6963,0xec1bbcfd,0xa31f3abd,
	0x18b787a7,0xba215735,0x4b4d526f,0x42a9d179,0x3573cbb5,0x683f030d,0xb633136f,0x1395d7fb,
	0x971da41d,0xcfd13ef1,0xdbbd842b,0xd65325f1,0x6bb967d7,0x48fdeb6f,0x5f43eb9b,0x22fbac09,
	0xb6358f19,0xe811549b,0xc187987d,0x9a53e0fd,0x07638869,0xfe83af15,0xe9ad465b,0xb6c54e8d,
	0xd703ad93,0x3bf3b4fd,0x4e49a283,0x3d613e87,0x7cb558a9,0x6f256305,0xbe51f10b,0x4ee187b7,
	0xc9071907,0xe709d55f,0xca27d1d3,0x18ab7af7,0x3e6f084f,0x73b544cb,0xcc932581,0x25c5f02b,
	0xea473f6f,0x0769238d,0x93c51287,0x4fe5733b,0xddd56b95,0xf7875a73,0xaa552a1b,0x50619117,
	0x47438343,0xdd9fa5d1,0x4041ad3d,0xf13f44b9,0x2aa59b37,0x18691285,0xb3f7f1b3,0xde298423,
	0xbafbdb7d,0xecc19af3,0xbb41e70b,0x156fed5f,0x5325946b,0x46afe40b,0x2c5bbb9f,0xf90b937b,
	0x0ef37399,0x1a611a3f,0x66e5a18d,0xffa3eb93,0x0417d8ed,0x652bee8f,0x5ce5b3bd,0x057dd9c7,
	0x1b2d4b8f,0xce8db37d,0x3bcffadd,0x3d8dde41,0x88b90ef7,0xe92f9a1b,0xb5779265,0xc26f6233,
	0xe62bd7db,0x13dd0efb,0xe91fed95,0xc76324d3,0xead3a143,0xfa8d3739,0xec713c73,0x6953c867,
	0xc4eda177,0xb75f8d7d,0xf47bf0cd,0x1fd37f33,0x12a15f0b,0x93979ef5,0x1eb7633d,0xce1bd88d,
	0x7af9e5db,0x68a5e853,0xda039821,0x7411adcb,0xe6e91c09,0xa11fd2d5,0xefab24a1,0x7f3b2f51,
	0x5a4d3701,0xd9c3d143,0x2c5b33ab,0xbbcd1185,0x6ceb5077,0x22779ce7,0xa92daaf7,0xe5a3d9db,
	0x636d1b65,0xdf499297,0xb4a17005,0xd93b4bc9,0xe869b90f,0x496f2fb3,0x5b9fcd1b,0x64c5f5d5,
	0x655bae01,0x904baf1d,0x9279f647,0xb90dde85,0xfba7f70b,0x9a5dc643,0xfde5ae65,0x7a93516b,
	0x1d993e4d,0x6659821b,0x5c050c0f,0x7275cc1f,0xc7653027,0x0c114421,0x8d615eaf,0xdf7f0b45,
	0x5827f043,0x5d85df5b,0x3de93373,0x67233785,0x0ae5ae99,0x27ddd557,0x2df37a53,0xa67d328f,
	0x0f8b5c61,0x1463b32b,0x1b43cb0d,0x634b041d,0x43eb811d,0x29918e71,0x49ffca2b,0x5cfb66f1,
	0x8cc32f9b,0xec05a24f,0xadb9adfb,0xbd9f75d3,0xceb71aed,0x1f830c75,0xb267e393,0x2aef7895,
	0x8753cb6f,0x27fbaa17,0xa56bd3d3,0x774fd111,0x060bf3c5,0x0a8114f1,0xbe8bc863,0xf2c90827,
	0x453de5d7,0x0e57c049,0xc8f9f0b1,0x5c11fac1,0x632b27db,0xfde135ed,0x6c4f86f5,0x717d26cf,
	0xbb01294b,0x07ad7331,0x1589152f,0x2211184d,0x9dd717eb,0x3f7165f3,0x8013da25,0x5e79f639,
	0xaba5d4c7,0xbf0d8997,0xdebb4e67,0x8a072f9d,0xcc51092f,0x6785a40d,0xa4bbc94b,0x8bb3488d,
	0xc8a75bc3,0x420ba2c9,0xeeb145f1,0x7f21c71f,0x835dc563,0x80f197c5,0x8ba74841,0x059b4075,
	0xd20b063b,0x20b7d68b,0xa60de1e9,0x371385b9,0xf63b3abd,0x29033127,0x0cbbd761,0x3323f11d,
	0xb65390a7,0x8da3552d,0x1bf1e4e9,0x520fd2d7,0x16ad1bf9,0xaf8f48b9,0x46592387,0xf5bffe2d,
	0xb281cc01,0x7de50775,0x3dff8e0b,0xfac57665,0xb4f78053,0x36e73f89,0xbd61a60b,0xc95d3bcf,
	0x72173dc7,0xc9092ead,0xf05b38e7,0x066938c9,0x9fd98381,0xd3df9f1f,0x7d3544c7,0xe4734eaf,
	0x2f15bfed,0x492504a3,0x2da3fd99,0x14ad82ef,0xc495e5bf,0xadc5b985,0x37bbf215,0x57f14bf7,
	0xd20120f3,0xfacb5b9d,0x26fb50bb,0xafc1fe41,0x4eedabc9,0x1e6d4945,0x654f4cd1,0x2f49594d,
	0x11d9c3cf,0x1d093e65,0x6407a367,0x6c5b34a7,0xc925bed5,0xd2291169,0x64d94053,0x906f4cdf,
	0x94213ffb,0x51779047,0xe2e70335,0x09a7308f,0x3bff8ca1,0xe7cb7d7d,0x9bb7a475,0xdbd14d57,
	0x0cdb0173,0xbc23ad0d,0x383bba41,0x915d1ce1,0x4eb9a763,0x10a54187,0x95cbdd93,0xcc6571dd,
	0x5e87e8af,0x239f0901,0xaf29ef25,0x77abe505,0x671965d9,0xb087fa15,0x257b7c83,0x979b621b,
	0xba2beaab,0x10ffd0eb,0x695144fb,0xbb45d4e7,0xc95f8339,0xfdc7cc2f,0x83a3dea3,0x0d65f63d,
	0xbf45b0df,0xefd38a17,0x7ed57b5d,0x055d38f3,0xb84fbf41,0x2135055f,0x6fabcdcd,0xb837d6eb,
	0x9bd93947,0x2e2db24d,0x1e570e63,0xc9a3fe0f,0x95297e27,0x5623bbaf,0x4f712057,0xfcff1d4f,
	0x2c69765b,0x5ca15fd9,0xacf9d6a9,0x664b51a7,0xffaf68a9,0x0a616da9,0x4f57591f,0x3b33f315,
	0x1bf7ef17,0x4e41e185,0xe65da949,0x440741a5,0xf6250bfd,0xfe45a259,0x8241477d,0xecc33265,
	0x04055ef5,0x389d5e99,0xfca5f7db,0xf6095c71,0xf54b79e1,0x649f8945,0x0191a74d,0xc62105eb,
	0x8c9355ed,0xd3c776e1,0xb873707d,0x5a0150f9,0x1863e88b,0x02bf9a7b,0x0d27c0e5,0xd64188cf,
	0x8c25d879,0x7a53e2a7,0x98eb9dc5,0xb8238ea5,0x392f52b9,0x507b3683,0x2b670923,0xa69166bb,
	0x27bdff95,0x495112b3,0xf3ab86cf,0xe31fe55d,0x0ff317a3,0x98214667,0x4931c15f,0x5b077bdb,
	0xf2dd98bb,0x4055d051,0x14d94f33,0x582b258d,0x53719b01,0x1685dbb1,0xd9e99775,0xd21374d7,
	0x0f87c5e3,0x616fdd49,0x5f13d70f,0x5ef5c021,0xd8e7e511,0x1afbd06b,0xf77145bb,0xc4a76edb,
	0x4e3d9d87,0xd13393e9,0x6b7f5af9,0x29af667f,0xb41b4289,0x2751671f,0x8229330f,0xe637978f,
	0x4dffcaa3,0xf6b186f5,0x29bd140d,0xf50faa93,0x574de4a7,0x0fdbead9,0x40f312c9,0x04b1cd1d,
	0x9c512cb1,0x9b7d21bd,0xffefd7e5,0x28439ec7,0xb3418123,0x1b6b4f1f,0x013584c5,0x288b3e31,
	0xd53577a9,0x0ba74807,0xeab7b899,0x74ff7605,0x5737f237,0x2355cfff,0xb6cdb55b,0xb4b509f3,
	0xc32dd405,0x35c1f61f,0x9d37a4c5,0xf77323b5,0x90f1d69b,0xb3679201,0x9c1dfd65,0x86a1e00d,
	0x7f3b7ec3,0xcadfe0cd,0xa1110783,0x5653fbc5,0x8cb1318d,0x29f5422f,0x5209823d,0x1643a0ab,
	0x90e16957,0x5e93155d,0x7667686d,0xe2d1529b,0x753b0ac5,0xd7d1b615,0xfff3d5bd,0x960bfc77,
	0x0e1fd9bf,0x86ed9999,0xb3db0b9d,0xb89f1d25,0x93cf0e7b,0x204d8bb9,0x73bb9641,0x12e91497,
	0xbb790a75,0xfc7f0bc9,0x268f91ab,0xdded90c9,0x70312d6d,0x993bc9a7,0x41c30ea1,0x94531ab9,
	0x2bf1ca71,0xba5d42b9,0xf22797b3,0x636fc373,0xf0a13cd3,0x2aeb7eeb,0xe4f1d639,0x3c3bf107,
	0xe1091d2f,0x1e17edb3,0xb0c1574f,0x84574b8d,0x79e19667,0x3033630d,0xdea370df,0x670fca29,
	0x6ac3daa7,0x07c1347f,0x93034699,0xc655e001,0x0f33b863,0x96637617,0xd6bbeef1,0xcbc5c949,
	0x879f4f55,0xf9eb5769,0x800bb829,0x199ff839,0x725be581,0xfd4da093,0xbb9d8d47,0x9bcda211,
	0x44a3dc31,0x39a74f39,0x357f7b1b,0xf8e16c1f,0x4399c4f9,0xd741538b,0xe22b553d,0xa31938af,
	0x1d4d96b7,0xee896d3d,0x677f7b09,0x8953141b,0x21b10289,0x89152889,0x25c5bca9,0x681b41c7,
	0x1ba1e8df,0x42a3fb39,0xe0ad600d,0xbaa3691b,0xc9e1ee69,0x8a198199,0x084f45e9,0x4bc7e287,
	0xf8213125,0x8285db7d,0xa22b2ebf,0x67052485,0x37ef1d53,0x841d2943,0xd2291fd5,0xa98b5097,
	0x39cd6281,0x3d4128cf,0x039be83b,0x732be045,0xc61d0881,0x7377f28f,0xb237c5c9,0xf75d7223,
	0x562ba46f,0x646bd67b,0xd31f2a1b,0xee45b6c5,0x4d2badad,0xc6f5590b,0xddd99f9b,0xe5ad7dd1,
	0xd139f2e7,0x6c135049,0x7559ce79,0x3207e2ef,0x445b2f11,0x7fed20bf,0xb0f5a1a9,0x7f6f9ad1,
	0x5d7bbe65,0x6acd1a85,0x056b8bed,0x02a3602d,0xe16f7367,0x522df635,0xcde7eccd,0x4a1180c9,
	0xfbf38be1,0x39a971f9,0x74f99595,0xaecb8a69,0x38abc5e9,0xc4090e79,0x3d956e5d,0x658917e3,
	0x1c2394d7,0x943bebed,0xac213b07,0x2fafbe0d,0x5ccf7651,0x4e53c711,0x8f618037,0xac4718c9,
	0xbc0b673f,0x3893162d,0xa987885f,0x4903f803,0x7f1d78d9,0x7c5f460b,0xf92d88b3,0xd33daca7,
	0x88318595,0x07451701,0xa24fe635,0xa8f775b3,0x0f59063b,0x0bfb19ef,0x77599aab,0x89dd0d27,
	0xfb9306d3,0x23614d37,0x2219b9a5,0x083f5509,0xdbc33bb1,0x0d7bd9c7,0xecc7157b,0x9a1b246f,
	0x7fb53671,0x1279f013,0x2b05044b,0x4a0d3471,0x311fbaf5,0x03b1c51d,0x42db44fb,0x08652d2d,
	0x8c993469,0xdca1af65,0x55b9043b,0x9c13d2d1,0xfaab4a41,0x03ef63fb,0x89770185,0x33b1528b,
	0xc8c19537,0x2c695373,0xf155d415,0x9683af95,0xe22d744f,0xd60726eb,0x16fb4ff3,0xf56f5031,
	0x292f01d5,0x6ee55d09,0x237b0aef,0x5c0daaa7,0x6fe72859,0x144b06f9,0xa84b01a1,0xc1931249,
	0x1163d7bb,0xf3a5a56f,0x084d5c67,0xb9e3a471,0x2a975a19,0x4b8d25ab,0x80c95467,0xc68b557f,
	0x7361c8e3,0x0cbdfe71,0xd26d3891,0x47bb1ddd,0xb785a1c9,0x1b1f6d0f,0x8a55929f,0x0d4d46fb,
	0xefab7bc9,0x2ebdd259,0xeafd6c0d,0x87c3d853,0xfa6ddc25,0x54d12fad,0x7551b323,0x99492467,
	0xf5432b67,0x10b9c3ef,0x11a1bff3,0x06af75c1,0x3595ca63,0x1cf9c88f,0xd8a1f94f,0x8871dbef,
	0xe1ab4735,0xcc414e7f,0x7c7799db,0x7bb1188d,0x29bdb23f,0x0a673b3f,0x51a794fb,0x3337ac3b,
	0x20e5132d,0xfd6965d3,0xf8239be1,0xe87903a3,0x3627fdf3,0x466dd3c7,0xa4454281,0x4c8fc477,
	0x4d7147cb,0xe2c11633,0x07c9449f,0xb93b3a6f,0x7897dc39,0xacdbc6b3,0xdadbeabd,0x01e9e44b,
	0x5053b209,0x7d5b246b,0x05078f2d,0xe4a920d7,0xed4de04d,0xec07d109,0x664b4307,0x1b37fbe1,
	0x810dd35f,0xb0cbadc3,0x40039327,0x0bf31b47,0x8f0ba1e5,0xa4bfd857,0x3df96d39,0x1aebcbe5,
	0xc5a181c9,0x6321c809,0x1f5d24a7,0x9acd2ea7,0x77155d3d,0x8a598aa5,0xffc797ad,0x5df7857f,
	0xb29187bf,0x9cf12181,0x40377447,0xe769a065,0xfd2b930f,0x82a3fe7d,0x10159d3f,0x3bcf6a5b,
	0xaadd443b,0xa94ba0fb,0x9633af21,0x52799669,0xd78fa897,0xc5f152e9,0xb9c7a545,0x26616ca1,
	0x000b4abb,0x35c305bd,0x8b739ecd,0x672db71b,0x3b05878b,0xff174f73,0x4e3dc39d,0xca23cefb,
	0x12190333,0x72698793,0x20994967,0xfb39c969,0xfacd3e27,0x6b630427,0x455b98a1,0x2e07c495,
	0x6f8b4a23,0x31d176c5,0x0cc79189,0x4ecf54b9,0xa8a99f27,0xfaa9698b,0x5d83f127,0xd37b1117,
	0xf563107f,0x090bdc1f,0xdd9fd64d,0x2c9f40f7,0xb4dde1c1,0x6f3b00ad,0xbb95668d,0xd673a8ad,
	0xef21fbc7,0x6fab18eb,0x1743934b,0x09dd768d,0x8e2741b1,0x7ded7315,0x0af3feab,0x0d634fff,
	0x36cb05ef,0xdfc186f1,0x5457009f,0x263b7e65,0xc1cf9f33,0xee0d32cd,0x9d83cbdd,0x293b3c37,
	0x54df1d77,0xf5df187d,0x65f9b2e3,0xabe921e9,0x1b911efd,0xb96f1a5f,0x8ba38cfb,0xd56db301,
	0xa061c553,0x9119f859,0x73cf3b31,0xcf9b0b03,0xc5b3ca4d,0x2c650cd5,0xd4354d5f,0xd7edaa85,
	0x5ed3b503,0xf2ff29cd,0x1bf7c721,0xf083641d,0x68f72ed9,0x05c195bb,0x7c9d04e3,0x3129696d,
	0xe437787b,0xdfa528a5,0x9317c0d1,0xb853781f,0x4c9bfedf,0x96d58917,0xb0bd37e1,0x3c1726e5,
	0xb30f103b,0xbd9b8929,0xc44f6ed7,0x3b3b5277,0x7665b115,0xe371a377,0xe2f59735,0xce27aa95,
	0x9c5b9139,0xb5f59825,0x713f944d,0x17ef5f0b,0xca9520b7,0xc1eb29e3,0xec29a037,0x574beca9,
	0xdfa1c4ef,0xd443fae3,0x520d10d1,0x97a10a47,0x2bef2d81,0xfb1389e5,0x2bb93cc1,0x01f7b5c9,
	0x4adfc959,0x26994f2b,0x35598079,0xce016115,0x9bb35ba9,0x6a3bf987,0xa789632f,0xd3193f1f,
	0x5a99b0ef,0xdd87cb4b,0x2045dbe1,0xb943b0df,0x59a373ed,0x1d331753,0x2bf9b659,0xca27d257,
	0x59cf22ad,0x6c1fde07,0x6e751823,0x6219278f,0x04032385,0x74518a55,0x6bed2599,0x01116999,
	0x8207fa0d,0xa7f5ceaf,0xf207c6d9,0xfbb3738f,0xb7939c29,0x4265a213,0x20c78cc9,0xcc494f91,
	0x1b3fe707,0xe91b5d09,0x139fb61b,0x03c763c9,0x2f953417,0xecbff69b,0x2a675445,0xdac3bf67,
	0x9bfd0e15,0x2a21615f,0xf25f9085,0x628187a5,0xe5cb0605,0x8b350875,0xaf3110e5,0x55ed84c5,
	0xc93fa833,0x28196c7d,0x83eb7d31,0x8a99cf11,0x32799131,0x0815e0ab,0x3c052403,0x01bd9bd7,
	0xd689a2d9,0x829767ad,0xb461bfb9,0x993d2a73,0x6c5f5951,0x4033b0c7,0xe4475b79,0x5ca3d145,
	0x85db4005,0xdbab34b9,0x86675835,0x76212ab7,0x08c186a3,0x22e372d3,0x61d991a3,0xbf93623b,
	0x47bbb62b,0xf7e94de9,0x331da341,0xf377a147,0xbb5f85df,0xd1f38959,0x351b4d59,0x7dfb9c61,
	0x5b27d049,0xde616609,0x4a23f9f7,0xedef400f,0x967ba83d,0xc1b75f65,0xc4f161f5,0x05d17de1,
	0xeda58dd9,0xf8a50861,0xd19f51f1,0x6cbf3973,0x2ad9c37b,0xd901087d,0x7ebb8f51,0xff835567,
	0x3b33c2d3,0x32c938bf,0x6631dd47,0xc193e063,0xa7b7d1d1,0x9125e0af,0xf65d21c9,0x6e09621b,
	0xae55b7b1,0x1b5f1367,0x5afbaa97,0xa8a34847,0xfadd91f9,0x15f12c83,0x06379235,0xcecf73a9,
	0x000bc96f,0x03776d29,0xd99f44f7,0x689de507,0xf087272b,0x65b9b903,0xef2d25ef,0x39c98a37,
	0x57db0987,0x1ea3734b,0x023f5401,0xf2b52b11,0x537bb925,0x714f7bb9,0x78a18ed3,0x816b7675,
	0x6bc3ddf1,0xa2f74b97,0x0b7f3bd3,0x029d2f4b,0x0cf9141f,0x3c0532b1,0x10738b39,0x52a57987,
	0xa047a129,0xe903b45b,0x627dbd03,0x3e854723,0x44c548d3,0xfbad0471,0xeb0785fb,0x54e9e51b,
	0x286b4227,0x8bdba45d,0xcadd94ad,0x5721a87f,0x811d4c79,0x38972007,0x233d3673,0x4a29bb5b,
	0x25abe467,0x890feae7,0x7ec31c6b,0x27a309cb,0xc6c998cf,0xed995cfb,0xda79407d,0x2ed74eef,
	0xc80f7fe1,0x60b3cfc5,0x4ecdea57,0xd5bb41f1,0xb905cc0d,0xa803db57,0x589bd471,0x59e7e301,
	0x6e17810f,0x3557b341,0xc2217109,0xf19de85b,0xb99748ed,0xa7a7a3a5,0x2c074f29,0x9cc94b3d,
	0xc4c368ef,0xec0fae25,0x365f9f9d,0x95fbf4f1,0x08bfd6a9,0xfed546ef,0x499fd9ff,0x636f8bcb,
	0xe7976cf5,0x4c6b31b9,0xffa981ad,0x88076021,0xe53f40fb,0xb2637ebf,0x2cc30acf,0xd44b7955,
	0x80951721,0x207da7c9,0x889fdf53,0x5771c2d1,0xac5bf81b,0xd9a1cd21,0xf75783f1,0xf0515907,
	0xe83fe5e7,0x54d9129d,0x7267dd27,0x7e6df66f,0xf9d3b0c7,0xbe5f1c9b,0x91bb943f,0xb2f18089,
	0x4597ec47,0x1891ad01,0xb4a19c45,0x81adb4e1,0xc7eb0437,0xfcf3603b,0xcad3d713,0x321bf607,
	0xae1d71b7,0xfd358a3f,0xbd6fda47,0x10613893,0x8f631025,0xa42b3389,0x7801d449,0xbe471029,
	0x45d59231,0x16d7361f,0x91759147,0x243ddc6f,0x677d16cb,0x555d7a8f,0x9525a039,0x02611619,
	0x5f41de31,0x1c0b54ed,0xebd197df,0x2173bbdf,0x25fb1ee3,0x645701d7,0x64a17bbd,0x23dddf83,
	0x9b63faaf,0x85e14373,0x5e274127,0xf6b352cd,0x7f2193a7,0xf76d1e6d,0x8f5b7431,0xe2af748f,
	0x09bd4127,0xafebb6f9,0x709bfcbb,0x3d331da3,0x25afe4d1,0x27714dd7,0x44af036d,0xb947ade9,
	0x48515f91,0xf83f5d4b,0xc1cbf6b5,0x589f3949,0xeae7269b,0x1fb7d623,0x5a85afcb,0xfc97d4b7,
	0xa39ff869,0xdf697cb3,0x26ddb7ad,0x972f032d,0xde8db1bf,0x3e0d65d9,0x6d3bac25,0xfc1142a9,
	0x36ad42a9,0x287f93f9,0xcb6fc4c1,0x5191b935,0x6ee1c377,0x32c7b403,0xffb377d7,0x21a901e3,
	0x0af9a9c9,0xf913fa69,0x51a73f87,0x0af919cd,0x88a71d7d,0x20b7202b,0x9b537eb7,0x11cf6d15,
	0x38876dc3,0xf9357fcb,0xf2258619,0x911903e1,0xb71da60b,0xbd2f525b,0xeff7b923,0xcb73cf63,
	0x05d74313,0x73770c6b,0x9c0bd315,0x1c2116d7,0x440907db,0x7001db1d,0xf4074bf5,0xc80d047b,
	0x07eff2b1,0x74ed4113,0x14fbdd91,0x6ec5529b,0x57ad5229,0x737fd37d,0x045f2883,0x1b891885,
	0x424dfa19,0xed27170d,0x1917792b,0xf637b795,0x18c798ab,0xf47b7d01,0x0467acab,0x945be82d,
	0x46f72b45,0xce398021,0x7b0135f9,0xea29e6b3,0xcc9d939d,0x3247e1b7,0x7dfd42c7,0xdb77c09b,
	0x566b4cad,0x2cb30699,0x43db0095,0x6ccbc15d,0xf6f13fb9,0x9eb37427,0xc18301ad,0x944dff79,
	0x7fadb94b,0x5fa96d43,0xd347c21d,0xaad1097b,0x7a017e39,0xfe15af5b,0x05df4cbb,0x7ccfb2f3,
	0xc03d009d,0x20ab4f65,0xff690027,0xfb6b017b,0xb695b4d7,0x873db6dd,0x886d73c9,0x8d7139b3,
	0x24218697,0xabcbc0c9,0x34df7ccf,0x004f0c43,0xabe96dcf,0x037df6b7,0xad155331,0x1921e2df,
	0xe5d723b7,0xdf9dedbb,0x96cfd6af,0xc5ab4d3f,0x17c3f7d7,0xeea5c375,0x1e35f3cd,0xed558e25,
	0x8e65c4f7,0x5d33bb05,0x1ed728df,0xe2334859,0x9663062b,0x970bfa1d,0xecaf2af9,0x71fd4baf,
	0x15490bcf,0xa81d65f1,0xbd1daafb,0x971781fb,0xc28b5085,0x3d7da03d,0xafe73a8d,0xc98bfc23,
	0x0085ee3b,0x466d2447,0x7841511d,0xf00b1f0f,0x557f331f,0x355183dd,0xa5bf70e5,0xf0f1f0b1,
	0x849f56b3,0xe0b7c453,0x8d636bdf,0xe34184ff,0x46ff4eb5,0x0455db87,0xd297c8d7,0xdfa38afd,
	0xa497c431,0x620b4cdd,0x9029485b,0x7169f9b5,0xed4d287d,0x82dde645,0x215389c1,0xa791dd35,
	0x51edea33,0x17fd9d31,0x8ab3d029,0xc5b94399,0x1d2bca33,0xfbbd8ba1,0x8353e77b,0x952d4a01,
	0x8ca550ad,0xd29d0d19,0x1da32965,0x55df4999,0x49dd6213,0x4c43fba7,0x107ba25f,0x4f69248d,
	0x8341f41d,0x047f0cdf,0xa01b56a9,0x020db31b,0xa525e2d3,0x04434edd,0x272da749,0xf7b75081,
	0xb2c3e57d,0xe2b3c54b,0x3fbfd70f,0x34f9880b,0x3f41a3af,0x860f2651,0x8c49af91,0x4a0be209,
	0x06adea45,0x84cbb7a7,0x20ad462f,0x03d1d0d3,0x26f70063,0x267b4b8b,0x8b33e111,0xbcd5bdcd,
	0xf8ff1c71,0x04db5dc1,0x7d89fc25,0x4e47365d,0x8989f925,0x4cd55095,0x15cb6e23,0xa10538f7,
	0xb23f8a79,0x9f75c9dd,0xc777ad8b,0xde91a213,0xd2b5d2b3,0x92f12ff9,0xe47535a3,0x4213b933,
	0x296bd759,0xd3a746cb,0xc6150b7b,0x895ddddf,0xccc1b643,0xe521ecc1,0x961162e9,0x05eb54a9,
	0x4407da89,0x8309f7d1,0xb789638d,0x4ddf3429,0xc06d5191,0xa2373279,0xd0030dcf,0x8d037203,
	0xf6154005,0x11a978bb,0x70713fdf,0x75c70fdf,0x94fd76d9,0xbb85f527,0x5e2ddab1,0xd249686d,
	0x62152847,0x86197dd3,0x7bf30707,0xb54b9c67,0xf031bcd1,0xd4db1159,0x52ef9a67,0x4b331f8f,
	0xf90dc845,0xa96d73e1,0x3baf9c1f,0x4b1965af,0x564b1eb7,0x648fec17,0x272dea4b,0x07b3af95,
	0x9a7b097f,0x27352031,0x07c7fec5,0x2063f81d,0x4a0f9c41,0xd37112eb,0xda47d437,0xd2370127,
	0xb46329eb,0xad83408b,0x4eddeb0f,0xe8df809d,0x6cbdd9ad,0x9cd3dbdf,0x12216e85,0x4fb56d71,
	0x63475c03,0x0ceb2b3b,0xb6137999,0x42bb6c99,0x9e17bfb1,0x6e85057d,0x3b1b7c11,0x1f9b5e19,
	0x922966c3,0x587f6f0b,0x390bbf7d,0xd6ab09fb,0x1c611b8b,0x48dd56cf,0xa8190c33,0xfbdfed4f,
	0x1a8945a3,0x05cf7343,0x49e76e55,0x77df272d,0xa4593ef1,0x9eab3f61,0xb27d1ac7,0xd8f385b7,
	0xe46dc89f,0x0ced17af,0xf14b7439,0x440bb317,0x9147a021,0x753f773b,0xda273023,0x05c5827f,
	0x06533431,0x086d5499,0xee559bc5,0xc3615d27,0xfce779d3,0x846f9ee7,0xe57b0125,0x4bcbcf51,
	0xe53fe151,0x555fdac9,0xd6a92c13,0x08933543,0xdf7f6b3f,0x5689df6d,0x01590f25,0x0ef58853,
	0x54b3dd79,0x3357b38b,0x366b88bd,0xd0d14bd9,0x2fcf1823,0x68618a5d,0xe12547ff,0x6db59a35,
	0xb6b18aa5,0xe465e0a7,0xb03bd1db,0xa3cf51cf,0x031bc8b5,0x494bb9bb,0xdec1a609,0x60fd621b,
	0x1bb93f4f,0xcd1dfc6b,0x1d398409,0xf3bf3891,0xad2309b3,0xbb15f013,0x1a8dd021,0xdc3f4db3,
	0x62d1e66f,0x948fd99b,0xad0b1861,0x3d51d209,0xe0294c55,0xd213b871,0x9b6db9a1,0xed6f7b25,
	0x59779f7f,0x444f2387,0x05d1a47d,0x27b970a1,0xccef8653,0x1517465b,0x6ec1425f,0xdcfd591d,
	0xdbaf5e7d,0x686dfdf5,0x642d7a75,0xa4a98743,0x42b9d1eb,0x9d7515df,0xc86dd6b9,0x4ddb46c3,
	0xf3fb8bdd,0x2f7ba531,0xbb41c8e7,0x10534959,0xcf470dd5,0x36fb8b85,0x22d10f87,0x5d7b33c3,
	0xfb5da49d,0x8a8d0e03,0xd4af3ae9,0x51674acb,0xdedd7d4b,0x7ffd9457,0x5ed15223,0xc3cf4045,
	0xb955da37,0x4d3585b7,0x70999815,0xf9192007,0xdc3b6805,0x094d45df,0xe3cf7069,0xf34b5cf3,
	0x83e9b2a3,0x4d835217,0x65a16489,0x6319fdf3,0x50a3ba41,0x763d7e29,0xbfab48af,0x38dfeaf9,
	0x5f97a85d,0x8409516b,0xc0eb80db,0xd59d59fb,0x03d7a4b7,0x9c9f83bb,0xc6c965d3,0xdbfd5bff,
	0x1f63ca5d,0x2bdb9a7f,0xe615ca27,0xa1538a09,0x1c1b3ca1,0xa4c3a5a3,0xb4099f2f,0x3e97d22f,
	0x84cf5c1d,0xe2891c9d,0xaf45ba07,0x416f6487,0x3e2f1bb9,0x297fdb69,0x48cfb899,0xfd21c035,
	0x5fdb759b,0xc8273f8d,0x8d190695,0x7ba1e05f,0xad570037,0x58236517,0x6cfb026f,0x0e898939,
	0xaf0da34b,0x9f45839b,0xa6b74269,0x801db4fb,0x6b536cd9,0x10816b37,0x4ef1f989,0xe44520e7,
	0xbf63862d,0xecf5218f,0xf9bd7c9f,0x0995fa45,0x586548d7,0x04e99ed3,0x8393e743,0x8a45ab67,
	0x4c6173b5,0x18cbaab5,0x7a51e0d1,0x7d3bc8a7,0x534f7feb,0xda31d975,0x26418173,0xc6fd1d63,
	0xa00915e3,0x8cd9a8d7,0x33135719,0x0abfd909,0x5955a24f,0x47a9bd29,0xf8df8a77,0x3b5bdc07,
	0xb2dd0b2b,0xd5af3e3f,0x6525240f,0xcc5524d7,0xa63784bd,0x37215475,0x83cd7127,0x82d55cfb,
	0x4bdf868d,0xc25fc5b5,0xa82988cf,0xe6ad85fd,0xd439e06f,0xe4efb267,0x35eff0df,0x535bc66b,
	0x208fef7d,0x847d7283,0x0a4162f3,0xa8fd56e1,0xfc19f31f,0xffe19287,0x84a7b177,0x9d5f8eff,
	0xf4f381fb,0xd019f077,0x300fcc95,0xacf3126f,0xd51f1f07,0xc94df8df,0x0bd5e749,0xabd31de1,
	0xbb89ee7d,0xfbc703d7,0x74b7bc4f,0xf6c3f411,0xd5078adf,0x3501d1f9,0xadddf32f,0x442b6abd,
	0xb555f9fd,0x2097296d,0x09d7a539,0x151d97b1,0x5017c1e5,0x095192e1,0xb39f0283,0xc6559dbb,
	0x91d91df7,0x3a1d3687,0x179316ef,0x413599b7,0x990f53d1,0xff11d91d,0xec7faf21,0x4cc7af87,
	0x8f152863,0x4669f8eb,0xdc8f5d8b,0x7ebd3711,0x213174dd,0xe18f0abb,0xce5d9f61,0xcc710949,
	0x998fdbbd,0x660fd6e3,0xcde921a5,0xbbe7ed25,0x98419dc3,0xae9ff643,0x959d261f,0x34c724ab,
	0x6c458efd,0xfc1f6f3b,0xb747085b,0xf16319e1,0x0c7f2bbf,0xb69372bd,0x6521e2b1,0x8fb72bd9,
	0xb0bbcd9f,0xce2b393d,0xdac95343,0x42659bab,0x0aad0087,0xbc3dffb7,0x664960f5,0x21b7997b,
	0x1ef3f79d,0x244724b3,0x110f8079,0x1c9f716f,0xbe0f2257,0x14ef653b,0xe8f7b943,0x89b7d8bb,
	0x9d6fe16f,0xe90339e5,0xe93fea95,0x58415a97,0x10655be9,0xc87b53cf,0x83913075,0xe129e545,
	0x612f740f,0xc973399f,0xc8f968b5,0x57ff770d,0xc9f3dc77,0xb133047f,0x32f5d7e7,0xdbffeb41,
	0x0db94cf9,0x55293d29,0x0c5fee6f,0x290be73b,0xb177d7bb,0x9be9d8d7,0x7a852d71,0xe8ade75b,
	0xd50b5e27,0x1e33564f,0x26132bdf,0xa3156c0b,0xac3725ef,0x67effadf,0x8425bb6d,0x502146bb,
	0x97a98e11,0xd9272f5b,0xbf392d9d,0x885306e7,0xddf5e3cd,0x2717fd21,0x4037b8b7,0x55d1870d,
	0x049557b1,0x7d17ab15,0xd76ffcc7,0xa57399b7,0xc8ef128f,0x3db17aa7,0x859ba8a5,0x57afd677,
	0xb9516a83,0x639384c9,0xe4d93ef3,0xf1a786e7,0x6deb37f1,0x8293b6fb,0x31b5fb15,0xee29b3a9,
	0x61dd4a81,0x68aff041,0xf41bd63d,0xaea55163,0x6c2bfe29,0x5f0d3e27,0x4865ac61,0x0c338dc7,
	0xd8bff023,0x0afb39c5,0xc853813f,0x889b3c91,0x216dd3f3,0xeeef84b7,0x140fe55f,0x1f41647f,
	0x46f56865,0x8b896621,0xfb277b11,0xb63bec5d,0xc9f78c89,0x208f87b1,0x45939b6d,0x2f4367fb,
	0x440374bf,0x0dedd29d,0x1cb51b4f,0x18bb0531,0xa08bffa7,0xd4bb6ca3,0x14553063,0xfeab98e3,
	0xf5eb2b2b,0xb837d507,0xd3a37613,0x5bc9cbf7,0xfe67a983,0xfec92195,0x5e37129b,0x2a6d6861,
	0x312f9625,0xd2fb5ba3,0xfd11fbf7,0x1599c619,0x7b514ad9,0xc487fd11,0xc7995cf1,0x49f7581f,
	0x98cf54a7,0xe94b8d41,0xcca11a15,0xe6db597f,0x0d8b88e3,0x9e4b5e21,0xdb5f76bb,0x0f3f9a49,
	0xbe4f3a29,0xe8b56927,0xec75da05,0x9ac36c97,0x29d38d5d,0x76e34c4f,0x2ae9b3d9,0x66b5b189,
	0x41b3eea7,0x414f6721,0x9d2f81e3,0x47030647,0xe36fa67d,0xcba317a7,0x6e1bf49f,0x974b1105,
	0xf1798e99,0x05ab1777,0xd5f13449,0x6bcdedfd,0x0c21e6ff,0xcc5df8af,0xa35745eb,0x6273bc6b,
	0xeaa34afb,0x0ad9c2f5,0x645d9051,0x13d14b9f,0x5427c61f,0x7b65b075,0x2f7d8113,0x2421e7e5,
	0xb8b70945,0x086d0ae5,0x0c975193,0xf4434799,0x6a47bf93,0xcd892881,0xfdf1ebf7,0xf2c5981b,
	0x75b50373,0xb877890f,0xa93df02b,0x8cd5aad5,0x1bc3f397,0xca1d12dd,0xa093d8eb,0xbf514237,
	0xea1d67fd,0xf7896fbf,0x4b7340b3,0x47b97ebd,0x7459c6e7,0xaaf38a13,0x6fc746cd,0x75376be5,
	0xacf3f9df,0xe4b729bd,0x5add1445,0x999fad39,0xde4f82b9,0xfc5db12d,0xaa6d80f5,0x1a694b4d,
	0x43b9b091,0x0191fa57,0xb599d879,0x21bba0b7,0x4265f4cb,0xbd2d53b7,0x95e9bf3d,0xef5b671b,
	0x4271580f,0x522b9d53,0xd04d376d,0xc9bde41f,0x27df0f53,0x7eb585b7,0x9e1dc5ff,0x8efd3675,
	0x6b9d30d1,0x7d15e6fb,0xd619b7b7,0xe5dbc2d9,0xd47d890f,0x84c543bb,0x75698617,0x0ec1c10b,
	0xd03d8fd3,0xeb63641b,0xc89f5c71,0x54c1e8d1,0x6c817d35,0xe5b312cb,0x34b1bcdd,0x1e993f01,
	0xefd57e8f,0xe8a5f9fd,0xa0014539,0x9fa70273,0x12af0b83,0xaa4fa071,0x7b55942b,0x28f7b905,
	0xd8675afd,0xc2ef8669,0x6ae14e25,0x1a3d5ca5,0x0847f82f,0xedeb62b7,0x8f39425d,0x72cfa841,
	0x46757797,0xead17fab,0x6e61afd1,0x02b384d3,0xcd0b4bf7,0xfe573827,0x7cbfaa4b,0x3b91965d,
	0xc501bb59,0x135d948d,0x46239f57,0xa1bbe8e7,0x3f3df411,0x7be907cb,0x36c7fb4f,0xdd2fbd83,
	0xcd8d41bb,0x52274c59,0x0449ee51,0x6a8b7749,0xbba1623b,0x7971612f,0xb6b35143,0xec1ba85d,
	0xe819fab9,0x3f41a6d5,0x5175aad7,0x1ad13ee7,0x3d792cab,0x9c3f1c5b,0x1c675483,0x5747d217,
	0xcb294acd,0x153bbc51,0x8ccbbf85,0xdac10f29,0x7e83ae1f,0x3c29f9d7,0xce45d9e7,0x8827465b,
	0x7bc1aaef,0xd1275d93,0xebe99375,0x5d0d17f7,0x1705a5cf,0x837d42b1,0x992f82c9,0x82ab4151,
	0x6d5f4899,0x5299b3e7,0x9af5aa41,0xfee589bf,0x9dbfd773,0x8f0f6873,0xd0855d03,0x0545cfa3,
	0xa205a5c7,0x7ba1e117,0xdc8d4401,0xe7fd3567,0xc7f5ab49,0x8e33a523,0x6e2982f1,0xa8e76e7b,
	0xca3938f3,0x50d39f6b,0x29d7fd51,0x2a872c5b,0x8967ce07,0xe2b79b4d,0x327fbb6b,0x0105ab85,
	0x64f90d15,0x193fe1af,0x52736f4b,0xe3336085,0x3457d0eb,0x40eff5fd,0xc46919cb,0xbb8dc4eb,
	0xdfc961a7,0x7e77732b,0x9c83cf89,0x5935444f,0x9987c9ad,0xcfad08b9,0xd1479ded,0xc0f54953,
	0xb6ad4aa5,0xac8f97ab,0xe4a99023,0x1e3f6aa3,0x283bf285,0x48456f8f,0x2cfdd427,0x542db7eb,
	0x94215089,0x7219ab79,0xbe07ffb7,0x2e8126e9,0x0e334a31,0x1685af07,0xf1eb7557,0x32a7205d,
	0x712d104b,0x6025c35f,0x923fe95b,0x10b12d0f,0x57b333e9,0x78c1d42b,0xa0f506d7,0xb457c2d1,
	0xb551db67,0xea454ca5,0xc17334a9,0xf5fd317b,0x0f7b1767,0x9fcb1485,0x417d7a7d,0xebabaff1,
	0x568d57d5,0x868dad15,0xc24585bf,0xda17891b,0x5ecd00e3,0xcef56e21,0x8163cea7,0xc59968e9,
	0xf965200f,0xcd8fe2fd,0x41d7dd33,0xa335c955,0xad6b411b,0x7c114785,0xd50bae2d,0x29917f61,
	0x10db6313,0x9a592523,0x43cd3821,0x42056815,0xc1990d47,0x6f710fbf,0x97551069,0x19873583,
	0xfe718455,0x2a8182d1,0x42453023,0xd1b95bc5,0xe0171f21,0xe3e5de57,0x29a5d937,0xd1e91dfb,
	0x3229bbd3,0x3e1983d3,0x4de59b53,0xb807bb4f,0xec2954e3,0xa6c31357,0x13db78ef,0xe9adbbf1,
	0x4a83b607,0x37b1c873,0x2dcb2c49,0xc51d5e1d,0x878f5147,0x37dbf749,0x245d8c6b,0x72432311,
	0x348533e9,0x3c5da97b,0x7f9d1221,0x53af7c19,0x328b1b85,0xe97f5b37,0x90077d05,0x179d9783,
	0x4badaaf5,0x53add833,0xd77b9875,0x68ed4dab,0x6bdfbf5b,0x007f38ab,0x123f2099,0x402d2df3,
	0x79ffe523,0x87b3fe67,0xe007c75f,0xd48dabc1,0xd0cfed01,0xd43151b1,0x0ce7597f,0x2ce56b87,
	0x57fda0ef,0x05035e5f,0x7a630377,0x50bdafc1,0x3d1b9931,0xee63d0cf,0xa85fb691,0x1939e5ef,
	0x4ca73151,0x3aaf72e7,0xde31addb,0xa22f5397,0xeb079d25,0x2b6be913,0xf38b1329,0x5b19e34f,
	0xad831dc5,0xfa478f49,0xb993c41f,0xb81911af,0x93515697,0xda177605,0x03cd3723,0x82f7fa55,
	0xde8fc245,0x97dd7f4d,0x512b8063,0xcc2984ef,0x8d3f47c1,0xdbbd9baf,0x150576d7,0x7bc5b229,
	0x724fef47,0x0a05273f,0xa01bf93f,0x829108c1,0xee93b75d,0xc42b669b,0xa997531f,0xaaf72277,
	0x49c589cb,0x09cf23e9,0x7807c1cb,0x0a075913,0xab8d50a5,0xf9b56bd5,0xaa631957,0x107d9367,
	0xb4732b47,0x32cd6a93,0xa10d89a3,0x3bb9324d,0xb6efc353,0xd52f68e3,0x86cd8357,0x66c71da5,
	0x905bc1b5,0x2315e909,0xf9d1bce1,0xbb5bf159,0x21fb63a1,0xc1e7e3d3,0x54b55779,0x42cd4a59,
	0x69fd2f91,0x9b332595,0x9777241d,0x171d339f,0x3c75ca49,0x5db1cb2d,0xf07f0897,0x33fbb32d,
	0x9c5debd3,0x9e3ddeff,0xe59f8475,0xe7b5770d,0xb49d7485,0x98df15f9,0x1d0d560d,0xe445a24d,
	0x70fda1f7,0x91c5ac93,0xc6693f7f,0xf051ba09,0xb735640f,0xd64363c5,0xa3bfebb3,0x381fb261,
	0x3fdfd1f7,0x5ddb9e19,0xb27bf357,0x3ea31b7f,0x0f81bf21,0x0b2f9c9b,0x747701e3,0x6e796e95,
	0x8f85704b,0x8d11dbdd,0xd8f51a95,0x4ae17ad9,0x47417075,0xdf759101,0xc59bfd77,0x40c5f28f,
	0x34f185ed,0x6c7b46a9,0x3f79ac57,0x17b91801,0xc6b7c745,0xcd679a03,0x34090fcb,0x02f58a7f,
	0x73a3d059,0x2ba917c7,0xe229bc33,0x525f3361,0xf4a7174b,0x41d7392d,0xe323d6b7,0xc37d5309,
	0x1d9f6189,0xfcaf80ff,0xd3a71a45,0x7283ade3,0x565158c1,0xbc17b887,0x9ccdfc95,0x6b4dd95b,
	0xb3693ff5,0x341d4c9b,0x5d15f325,0xda59a8ef,0xaf79c863,0xedf9ca9b,0xf169d83f,0xddd7bb1f,
	0x83fd0697,0x69077d69,0x1e176ff1,0xf6932673,0x225d8767,0xdbcd2a73,0x57d70d11,0x190d467d,
	0xcce384eb,0x94fdeeaf,0x2ccb563f,0x5e63a8d5,0x4fc33b89,0xfc693b99,0x4d7b2ae3,0x55611a1f,
	0xda1b5eeb,0x3411f437,0x35d5a82b,0xf379d301,0x76edaf03,0x591daa17,0x76354e0f,0x25c7c531,
	0x2625ad0f,0x64d7fa4d,0x9c59444f,0x02090863,0x9599708f,0xadb90a79,0xbc69bf71,0x97ad675b,
	0x7a059c51,0x086125bb,0x99f585c3,0x60c50ce1,0x880d7369,0x889379c5,0x70f7945f,0x530950c7,
	0x0d3d0e2f,0xe23ff3cb,0x5ecfe425,0x90dda4e7,0x290baf47,0x6a793d89,0x6b434eb7,0xba4da221,
	0xa5cf389d,0xb883da45,0x3187938b,0xde07355f,0x71d1c065,0xe6c163cd,0x292f7cd3,0x0a67ec91,
	0xb83d4619,0x73c1e775,0x8f3f248f,0x7e6f63b1,0x9a25877d,0xc339631b,0xef1b5989,0x7acbd1c1,
	0x8787f59d,0x3f096223,0x4b99244f,0xb2cdb5cb,0x3849c9cb,0x1837ba7d,0xe7eb6c37,0x5d6da3dd,
	0x45333aa1,0xa7ef699b,0xb0b5bc61,0xe64f3215,0x60fbd105,0x7089917d,0x450128b5,0x3ebd058f,
	0x313fdd21,0xbe8395a7,0x9f3b52e1,0xcea9ff77,0xc7810b67,0xe9835827,0x5e3d8f5f,0x05ad89ff,
	0xba2f1995,0x3559968f,0xae472a69,0x8c0d055d,0xdd9dabad,0x52f76701,0xd201cd0b,0x13b154d7,
	0x9d0540f9,0x8181d51f,0x4b7d0213,0xc92b8bb1,0xf38d490d,0x4f399f19,0xa531db17,0x64b7ba41,
	0x054358c5,0xfa8d12a1,0xdaffb577,0xdb37dadf,0x58177f43,0x731709f7,0x632f1f5b,0xaf35dee9,
	0xace9baf5,0xfa9108dd,0xd771dcb1,0xe1e3dbcd,0x787b8e8b,0x65e579a5,0x3ddb0c33,0x841b57f7,
	0xfc7bb601,0xfe1f0a1f,0xf1f16c5b,0xe75fb7e5,0x007dfb9b,0x017528ad,0x2d99c075,0x6edbcb17,
	0x2afd2ce5,0xc445a131,0x3223558f,0x00617915,0xfa5d2fb1,0x72195a19,0x1149a77f,0x15698e71,
	0x5ded3719,0x6e9b315b,0x162b25e7,0x6c15a9c5,0xeedd1883,0x56a3f975,0xce4f1929,0x583348b1,
	0xc94dc099,0xa12f9669,0xb2a9a77b,0xb433f4dd,0x0541c84d,0xe0653ac7,0x708df9cf,0x722f90ff,
	0xcfa329dd,0xa293c4a5,0xd2bd80e7,0xcce9c5cb,0x234915cb,0xf32f3a9d,0x4a635a49,0x18cd8f05,
	0x21ede7e1,0x7bdb68d7,0x180dd545,0x34ebe875,0x0d373c33,0x45579dff,0x14b517f1,0x9bff9aed,
	0xdfb1241f,0x18978849,0x1ab9e42d,0x156b2947,0x85cf7b43,0x7fad3277,0x0ee37ca1,0x0639dd65,
	0xb6ed5c8d,0x66d920c9,0x8963a9bb,0x6219f52d,0x6e51b731,0x5d838e0f,0x1ed1deb5,0x3c69ef91,
	0x042503ab,0x7735c89d,0x492d7e89,0xf929f98d,0xe67f18bb,0xcca9af51,0xf0e14103,0x1e057b1f,
	0xf25b206f,0x9cbd4e91,0x95b9b7b1,0xc34dc451,0x6c9bad19,0x0d759d47,0x17f3f2e9,0xa4fdda37,
	0x9b0fee53,0x8d0159ed,0x212b46cd,0xd3b763e7,0xfd690603,0xd2b7077d,0x2d693041,0x05c3b785,
	0x26477d53,0x80130a7d,0x342159f5,0x88170737,0x3429d9b7,0x61bfe5fb,0xf129c161,0xcf4bae31,
	0xea8151e9,0x5087988b,0xcdbffbc5,0xa8a19da9,0x6a9fa2eb,0xb2631949,0x698f9b27,0x0b03e9e5,
	0x8cc1050b,0x9b6ff4df,0xc3a9b357,0x8805772b,0xd90b40dd,0x8ef10a75,0x03837eeb,0x5ce1c6cd,
	0x2089e439,0xe05968c5,0xe1fd2445,0x2379e423,0xb62f9743,0xb43d4b07,0xb2639a89,0x23557191,
	0x47db9169,0xa15d3605,0x0b61aea7,0x42abd57d,0x574f2e5b,0xf19b350b,0x10112859,0x9751875b,
	0x5337a317,0x830736eb,0x58f50f19,0x97cd7ca5,0x502bd2dd,0x48d98b07,0x7cf10f33,0xec49b5d7,
	0x61a3443b,0x6c6d7e41,0x3a59feb5,0xdf95eb81,0x93053601,0x0e4b1809,0x3fe58277,0x702b5b2f,
	0x809dd44f,0xa721f751,0x95b3d315,0x0131b47d,0x909f8d85,0x08c34f97,0xa64da1f9,0xab6d260b,
	0xcc29874f,0xff3305e3,0xe7a31e53,0x2e558a81,0x583d33a1,0x9195edbf,0x240d1a17,0x80ffb595,
	0x8ec905b5,0xe3352643,0x634b4f07,0x0331e0fb,0xb79f470f,0xb48f9709,0x7385c3a9,0x4e553977,
	0x617f0c79,0x843b8d39,0x124d504d,0xa6798bd3,0x5b094b07,0x5005787f,0xb5994409,0x0b5d11dd,
	0x4bcb0d15,0xf5d7c811,0xf4cb29bf,0xe95f5f71,0xed3bc747,0x34c9e7ab,0x91abad13,0x6a8d6f6f,
	0xe3b1cd87,0x4e195c95,0x21699f75,0x6795d0c1,0x3777e807,0x462d0299,0x559b1d1d,0xf8d5f359,
	0x6db50843,0xc593690d,0xe545d20b,0xa74b952f,0x417f1e01,0x9a034fcf,0x15cd5f07,0x3da74f43,
	0xfcd50c47,0xd7594445,0xe403de9b,0x393542a1,0x7197be6d,0x989d5e5b,0xcd218a25,0xdaf5e559,
	0x92955d0d,0x60fb1d87,0x37c77ebf,0xd885ef83,0xac7fa309,0x1ccb65c5,0x7cfba253,0xad316841,
	0x3ef5528d,0xc28d9c9b,0x912fa891,0x8aedd2bf,0x757bca0d,0x93e3e617,0x4d3d37ed,0xeb4f7b2b,
	0x407bb943,0xfe9f81cd,0x57612ea9,0xc09de3bf,0x0e49f633,0x1db547db,0xac4707cb,0x46bf51bb,
	0x24257227,0xda4345e5,0xc7fd6023,0x74497a6b,0x97314eb5,0xac937c1b,0x6efb9b49,0x0b73501f,
	0xe57712b5,0xfd0dba2f,0x1723a899,0x4b21ef31,0x2eefff4d,0x254d9c61,0xf0bde83d,0x3fddab01,
	0x0e7384e5,0x110fa875,0x8f793025,0xb4d93af7,0x12c9d833,0x7f398ab9,0x336ff105,0xc4f10789,
	0xd79ba733,0xe2d97301,0xb21f7b5f,0x0ba3972b,0xbe7fee25,0xe42591a9,0xff73647b,0x761d1b61,
	0x47f1ec97,0x817db49b,0x56b70b65,0xb4311db3,0x0c533a5b,0xd067043f,0x03a93df5,0x49574cb3,
	0x54f5fc8d,0x5e8fe08d,0xcb63fdcd,0x3db368fb,0x55093a8f,0x32cdde03,0xf5736551,0x6f0f522b,
	0x02ad530d,0x6e1fe2a5,0xf4c7acb1,0x81dd33ed,0x8fe190fb,0x8cad62ff,0xb0b54ee7,0x7239d2f3,
	0x8397e093,0x46c1bf29,0x6e014eaf,0xc4e1f9f3,0x729fa459,0x11d5bfbd,0x57d19b91,0x584306b1,
	0x58b7aa19,0x418532e3,0xa8b596dd,0xd57196f7,0x91813fe3,0xc899a949,0x73a7b8ab,0xc1235595,
	0x718d6915,0x99ff5321,0x0d0754d7,0x2cbde763,0x7f4f3353,0xa9cdfd29,0x139b800b,0x0749f843,
	0x4c1f2b87,0x8e3f2da9,0x199514b7,0x0e79681f,0xed45f2e3,0xc0bf616b,0xed8dd80f,0x5fa797e9,
	0x14ebf3e5,0x7ed968c5,0x8385bf15,0xa8d5d699,0xcb29374d,0x4b43e495,0x7de15391,0xf9afee2f,
	0xc6f75929,0x0edde341,0x5675390f,0x3487d0b7,0x673b9dcb,0xd9ab9db5,0x2779d1e7,0x1f556541,
	0x4bc126cf,0x43dd5467,0x148b043b,0x14bd74e7,0x8e3d4817,0x6ec94c53,0x53b51eef,0x5507b7c7,
	0x9b4dfccf,0xa5edec01,0xd667deb5,0xf729020f,0xab737c6b,0x9feff87b,0x92799301,0x79bb90ed,
	0xdc1defa5,0x5f9df257,0x6b2b6315,0xf401779b,0xe89d4581,0xb4ef92b3,0xba25b2f9,0xe6e12c5b,
	0x8331284b,0x5e016835,0x7879a879,0xadf33575,0x4dfd1295,0xc81b9407,0x079dd02d,0x906df63b,
	0x740f8439,0x70aba6e3,0x9a73e277,0x72339c07,0xe257575d,0xe6459e03,0x3e41a87b,0x24cd2b39,
	0x20b53569,0x69a9002d,0x83bb012b,0x5871ac39,0xcaeb2c15,0x2ebf1aaf,0xc7f5063b,0x2cf7787d,
	0xa9a76257,0x3d915e5d,0x1d73512d,0x62e1a779,0x6b7bed77,0xf35bdc95,0xd51b6049,0x2c5b9bb1,
	0xfde7c5fd,0x2375e43b,0xa73d1b9b,0x9e35afad,0x864bdcbd,0xd869bebf,0x7c9379fb,0xc0eb0301,
	0xfaf74fd3,0xb4e58d13,0xd73d460b,0x419f6743,0x5c1bbfa1,0xf4bf44b7,0xdbc1032f,0xc3196d15,
	0x8cd7c3d5,0x0df5ccaf,0xfa11f299,0xcecf9121,0xcc2f805d,0xf1ad3a87,0x3685383f,0x65d98919,
	0xce0d5a7b,0xed352f57,0x12dd1fdf,0x31f9b0b3,0x7445cdad,0x2b0354bb,0x17438201,0x569b96b5,
	0x279760bf,0xd3b7f9d7,0xfb4548f5,0xe1cfa9e3,0xd0a3bac7,0xcf17d059,0x6edd15d3,0xdd510613,
	0x70f9d81d,0x250fc977,0x83690579,0xff81611b,0x5c0b5f67,0xfeb712ef,0xb4b3958d,0xfc6d17df,
	0x1035168f,0x474d3403,0x91e9a981,0x76c35b45,0xafbb77c7,0xed394a85,0x06a7af89,0x90e17d41,
	0x19cb668d,0xc30567c5,0x43ebe5a7,0x1dc75dcb,0xa37904a3,0x006b0da5,0x491fbea3,0x7221f7e5,
	0x70c1a713,0x6349cb87,0x0d0f6709,0xd53f0e97,0x6d87eb31,0xf0a3fb59,0x46f76a33,0x921bf9f3,
	0xe695eb99,0x55a79e91,0xd777773d,0xa85b9411,0xc2a3952d,0xe8af5b2b,0xd1974613,0x1d454615,
	0x5b4b1c1b,0x4a3598af,0x23c59c5f,0xeccf3527,0xf61390d3,0xa5e3bd27,0xe0dd729d,0x9a918f77,
	0xdd659511,0x93858a29,0x291b3909,0x62cdf93f,0x199730d9,0x981199d3,0xb32b3cad,0x0b6d19c1,
	0xc9e5c777,0x46a7fbcb,0xf51d2c55,0x55054845,0x1d732c7b,0x018df23d,0xed65bd9b,0x0bcf591d,
	0xec4dd8c5,0x5b2fcedf,0x8be971db,0xb8ab8aa3,0xf0673f75,0x1725efed,0xbaed7b41,0xf2259237,
	0x9e9d42f7,0xcb2ddd2d,0x0823c1b9,0x4d71c943,0x9fb5c9fd,0x202d84ed,0xeda307f9,0xef657a39,
	0xe95b7485,0xb3339901,0xbaef3083,0xbd874d8f,0x772170d1,0x96770bc7,0x1deba29f,0x2effd6c9,
	0xa385706b,0x7255ad23,0x4bebcf59,0xbda14171,0x20ebbd27,0x4655e785,0xcaa7d68b,0xf6e71e15,
	0x929f6e21,0xca239ce1,0xd93d4bd3,0x2cf14f53,0xc5d5bcbb,0x6e9923b3,0x79371b97,0xc78b16c7,
	0x8aab79a3,0xfeb163ff,0x17839009,0x3529421d,0x2d23a1c9,0xe0951457,0xd57d761f,0x7be17807,
	0x8e291369,0xf68f16cd,0x71e36297,0x6a79a53d,0xdc956307,0x2019f5ff,0xd1dd16f9,0x6959897f,
	0xee1fd06f,0x5ad18211,0x29fd0697,0xeb956499,0x386d5bb3,0x837b8db3,0xc739fb83,0x7fe5c35b,
	0x6a0bfa2d,0xb707cb17,0x77f3dba1,0x81af6c9d,0xa36feb83,0x538bc8fd,0x94f18d97,0x69f96e43,
	0x4ff12e9f,0x99450fa7,0xaa67fdd1,0xc0774a33,0x9ed916b5,0xeb9b5de7,0xc0e9438b,0xac834361,
	0x9c53003f,0xb21b060d,0x467be5c1,0x2621cac5,0xea7325ff,0xd97b6afb,0x9783403d,0xc6f90c61,
	0x1a339605,0xf49b9d13,0x27d1088b,0x3b5f9c3d,0xa479469f,0xfd811743,0x4b9ff305,0x534b436b,
	0x83134b6b,0xb6599c01,0xa08b77c9,0xb361ed05,0x69b12a4b,0xaa7d324b,0x169fb7bd,0x25ebb32b,
	0x9ef3506d,0xcf6742a3,0x994d8193,0x8bdd0c07,0x755ba741,0xc5bfd41b,0x586976c1,0x6dcd16c9,
	0x64574983,0xba55e943,0xb1355085,0x2d0108ab,0xc13b5839,0xe71dfd3b,0xb75944e9,0xd461b9ef,
	0x1841efa9,0xb435a0a9,0x5de78bb9,0x897f52df,0x25913c6b,0x78e536b9,0x4057038f,0x9d9718c9,
	0x6e33b059,0xdc9bd221,0x0b87f6c9,0x3e8b5b09,0x791f5795,0xd7eb321d,0x86c1008d,0xc7e57fff,
	0xa82f4d8b,0x5597df75,0x3cb511cd,0xb3d73215,0xb12951ed,0x73836973,0xc479963f,0x2c3dacbd,
	0xb6b77db9,0x63bdc2ed,0xaa91b961,0x3b95296d,0x016d1831,0xed7bbf41,0xf9e3cb7d,0x9e0d6cab,
	0x58cb8bdf,0x8e1daf55,0x64c1c69f,0x327772fb,0xfc337b99,0x3a271e95,0x0de1f3a1,0x0b4b3df3,
	0x3beff777,0xbe49aff5,0xf165af21,0x1fadc129,0xb237d1dd,0xc0591af5,0xedd34e87,0x9c67ef41,
	0x1c251479,0x60574899,0x6d1f2501,0xd4e9e6e1,0xd2bf953b,0x7965906f,0xad9da885,0xd4533fbd,
	0xe3efab61,0x82d3158b,0xab11b6d7,0x8e61778d,0xcb8b046b,0x1119438b,0xa7a1fa79,0xb0817f11,
	0xcc4f9927,0xf6d36b93,0x54dd6fbf,0x12c36715,0xe8dfc2a7,0x05c98153,0x9cbf09bd,0xc8e32d69,
	0x7cc56f45,0x6fe7f7fd,0x0aa57753,0xd343a9e7,0x757977a7,0xc847bf51,0xd4590827,0x6fed9b6f,
	0x2b5713b7,0xa4236093,0x830bb1ab,0x0b93d4e9,0xdaa16fa9,0xdbe53b91,0x3c533415,0xd28f8a49,
	0xbc8360f7,0x6c19e39d,0xab335f63,0xe1e3bd87,0xc0133b65,0xf6759c99,0x890f785f,0x183bcba5,
	0xe34dc5fd,0xe2d7f7e7,0xc6bbbd97,0x86e719ad,0x2c155015,0x20499177,0x556d0c5f,0x82e3e1ad,
	0x4137e645,0x85f5ecbb,0x8fc7a5db,0x55d11fc1,0xa367a771,0xd43171b3,0x42d113f1,0x8efb9f09,
	0x864339c7,0x557f89e1,0x56fb2e4f,0xf45126ad,0x494d5fb7,0x1f83dd57,0x191d3f6d,0x1371c6e3,
	0x90f1acff,0xf40bafa5,0x23774989,0x729b45df,0xff855b9f,0xc20f5ced,0xe6b16bad,0x61bbace5,
	0x8e4540e5,0xc6abf6d1,0xd2db66a5,0x6b61f53f,0x8657e263,0x4e27017f,0x206f420b,0x65c9d53d,
	0x19c3aaf5,0x14ef50ad,0x394d113d,0x23d5ad37,0x9c7f3fbd,0x489b0497,0xc1bdd863,0xc60d948f,
	0x5d69f527,0x28e9a705,0x416d916b,0xaba786af,0x1f4363e7,0x48c16841,0x6c77510d,0x037bb009,
	0x31b91df7,0x6f2d7c21,0x0c5d8bc7,0xfd0bdb13,0x2a63839b,0x18679703,0x89057ae3,0x9983fd53,
	0x3db9b85d,0x96cd8acd,0x11bfa16f,0x1cb3e44f,0x3821b813,0xd3e303eb,0x66457141,0x1e150299,
	0x16e98bd5,0xb1596653,0x3fb50ff9,0x39cf5cc9,0x41419f09,0x0a03ca81,0x59993bfd,0x61a99683,
	0x61493457,0x52e31a7b,0x1ae1517f,0xce131f6d,0xdd03fab5,0xdc1d4ecf,0xdee56f75,0x8f2b803b,
	0xef5dc25f,0xb1ffcb91,0xde65bc9f,0xbdb1c7a5,0x612b51d5,0x1dffdd5f,0xb88bcc83,0x4c0f176d,
	0xe2275ae5,0xc7bd565f,0x9be5246f,0x7759515b,0x01f78fa1,0x75fd4b3d,0x0f6be07d,0xd849e441,
	0xc929d765,0x6faff02d,0x5b7f788b,0x1441b8f7,0xf22da3d3,0x7ceb95ef,0x92e9a541,0x2e493f61,
	0xc26365d9,0x87ebc6c7,0x3bd9650d,0x78159b67,0x830f22a5,0xde178383,0x98e52127,0x2301f1f9,
	0x9a5b28b9,0x10fda077,0x9211f28f,0x710dd613,0x445de4d1,0x7755427f,0x3dc30709,0x85e3d5b3,
	0xec0fd6ff,0x4dfb7c05,0x09cd2629,0xd7d726e3,0x2459a793,0x78f709f1,0x84655643,0x40e374b5,
	0x41035c27,0xe47730bd,0xc52da177,0xafa7cc43,0x8fc5aca1,0x85cfb961,0x762bfaad,0x7871a9ad,
	0x31397829,0xfc810e67,0x7cd14293,0x462f251d,0x91e55a37,0xd32f78db,0x42f96ca1,0xab7f3fc5,
	0x83335f81,0x60ab7d4f,0x9fdfc415,0x539f50db,0xf479db0f,0x48e958e5,0x612f50f9,0xd37f92a5,
	0x4bf35b29,0x9e099e3f,0x73f75d1b,0x1aabcf67,0x5fc3be63,0xa14ff28b,0xadb11911,0x84632e77,
	0x0ef96899,0x242bea7f,0x353b613b,0x8885212b,0x7a8797ed,0x89330759,0x8bdfa2c1,0x0c9f6fe7,
	0xde49d9cb,0x6525d3db,0x364de091,0x54df6711,0x0a059fe7,0xbfe72157,0x059dd863,0x9521241d,
	0x7a65f53b,0xf587649d,0x005147b7,0x21e90283,0x11ff530b,0x373d330f,0xeb4d50d1,0x415f28c3,
	0x724f95e3,0xac65df8d,0x72e5ffc5,0x9c573569,0xf4b91293,0x3385378b,0xf3cfef67,0x4f490c05,
	0x4389cb3b,0xc34f5ff7,0xe42d0e57,0x9b5bc231,0x92f3c43b,0x6b95d255,0xdc8783fd,0x3753ac8b,
	0x7a15793d,0xf65779a5,0x40cdb587,0x40a58bc1,0x6bef7239,0x28bdef77,0x89556aed,0xcc6bd981,
	0xd073f865,0xa411d8df,0x2be313ef,0x18693585,0xbd71eb49,0x66cd637b,0x249d2d13,0x5c07f28f,
	0x4fa7b5ad,0xed8fe271,0x1f15c4a7,0x3959c367,0xa3b962a5,0xf41b8b6d,0x3f411fc7,0xce1787df,
	0x6f33d28d,0xd66153a5,0x8a817f4d,0x64a539d1,0x39891009,0x9175ecd5,0xf0a104e3,0xc50dfa1d,
	0x3519c501,0x6499e243,0xf4cdb7f7,0x26013dad,0xb825cfab,0x1231d5bd,0xf69faac1,0xbddb1a71,
	0x55dbf781,0xc0cbdc97,0x1b193f41,0xf39fb465,0x974dc247,0x7c1dfcaf,0xd5a18c3b,0x2ff5ca87,
	0x54796909,0x5607c969,0x1107e243,0x4e3163e1,0xad43ed17,0x278f20b5,0xf88370ad,0xad4b9c87,
	0xa2794d11,0xf1e10805,0x60b90a99,0xe0e7928f,0x4ecbd9d7,0xdf55a959,0xd0ad0bef,0x024f731b,
	0xbfd9ab95,0xe4697035,0x2ad15e5f,0xa175a755,0x6f2536bd,0x00c346a7,0xf5fd9e5d,0x55f3216f,
	0x5b1d010d,0x2033f241,0x46716029,0xf00bc9a1,0xc0137685,0x9bab9125,0x46d594cd,0x49a90b2b,
	0x7147de73,0x5a4f36f5,0x613b0f17,0xb75f8159,0xd1d9706b,0x9261a9e1,0x0819289d,0x1965c47b,
	0x6dd78945,0x2a4f3f9b,0x1f5186bf,0x8c9f56e9,0x33370025,0xb9b3da63,0x052bffa5,0xbb97b207,
	0x4ad39b77,0x2a4705fb,0x3b579f3f,0xcf7d733b,0x916fa5ef,0xf8f534b5,0xafebcc41,0x0131a8f9,
	0xb0b9a389,0x16c91c61,0xa66b8d2d,0xca2f3fb9,0xd8452685,0x69f93361,0x40bded47,0xb5a58efd,
	0x168dc46f,0xeee54d97,0xa83381a3,0xd163064d,0x51f92b1d,0x79115971,0xd6830e15,0xbee5fa3b,
	0xe1d155a9,0x142d3ce5,0xfecd4a3f,0x644d915f,0xc74de175,0x050fd26f,0x969dc685,0x3d65d15d,
	0x8687832d,0x6ab50617,0xfedff117,0x4c9fcbdd,0x9f859bc3,0x7f451267,0xcced3aed,0xac15eb8f,
	0xa731ed75,0x790ddd75,0xb3895cc7,0xbe89612d,0x006170c5,0x0b8575e1,0x0bd7bc2b,0x0067b079,
	0x34cf497d,0x8849afcd,0xfe6df069,0x78bf5d3d,0xee23dbb1,0xa01fe1e7,0x4c3d6797,0xca4db847,
	0x8ee700bd,0xc3f9c263,0xb7ad2b95,0xe471cc73,0x6b8d5c45,0x25e96403,0x0d81c70b,0x54396ba1,
	0xa377d131,0x5a2f5307,0xcdeb4a67,0x35555bbb,0x99e316b7,0x9833d23f,0x758170e3,0xc31fa3b1,
	0x0f036d51,0x9b7f37ff,0x6649e57b,0x8999f87f,0xd8e773c5,0x24cd6b25,0x70a5a7f7,0x366f4a23,
	0x3c8b1c19,0x1afb8017,0xfc6991e5,0x09f170a9,0xe6d7c0a5,0x4c0d75bf,0xd1cbfba1,0xe81bf91f,
	0x85955903,0xce331297,0x826d8145,0x098d12a3,0x0079cf15,0x00c3e199,0x7257e7bb,0x4c959b51,
	0x521f7407,0x2d394f4b,0x80f721b1,0x26214d55,0x010d954b,0xc83fe6bb,0x522974a1,0x32cf0be1,
	0x38af319f,0x52a1ae7b,0x372bbdc5,0x67df502d,0x8257ce05,0xda57a5ad,0xb7a5d729,0xe43db679,
	0x1e436ac7,0x1b7d60f5,0xbaa71c9b,0x6179ab11,0xfc97987b,0x4159c77d,0x4fab10b3,0x44cf3745,
	0x565facf9,0x475befff,0x179121cd,0x501fee6f,0xe68f1865,0xfa191db3,0x4d9f8f13,0xf2f7faed,
	0xc303da2d,0x9853dd63,0x70876d73,0x3b854b2d,0xd5811601,0x13eb425b,0x8b61cca7,0x67a7de9d,
	0xf4b5c8dd,0xf2f1436d,0x1eaffc2b,0x15dd32b7,0x9d319e05,0xd09d37fb,0xa957f047,0x1651cffd,
	0x4a73e405,0x7e4b74e7,0xd1a9c70b,0xdbd7f6f7,0x6fdfa1af,0xc48309a1,0x2e5d6d4d,0x8ce96d37,
	0x11c3cb1f,0xc3f39d1b,0xaf9763ad,0xb4a76a57,0xfe4f96b7,0xf6716ad3,0xa7dba393,0x93dfa4f7,
	0xa6a3f223,0xcff95fd1,0x7519a42f,0x11ff7fc1,0x97c11755,0xffb5579f,0xc9ad7f75,0x4e255665,
	0x9397418b,0x50f17955,0x95553727,0xd011ea9d,0x49f78247,0x2c23b48d,0x8e3b19cb,0x592df12d,
	0xb19fb655,0xb7e95e6f,0x59ed47b1,0x558dbed9,0x01359ac5,0x9a0deea7,0x566357ef,0xeceb1575,
	0x484101f5,0x5879dc6b,0x02ff1d67,0xb3a710db,0xa8392889,0x5a459b77,0x09878bbd,0xfbcd33ed,
	0x2d7b2a69,0x88afb913,0xe72fbc61,0xc6119591,0x484b97cb,0x901d1909,0x358b138d,0x52c92db9,
	0xe5d12a2b,0xc11d52af,0x939f853d,0x52fb4261,0x29279949,0x91672de3,0x2ed1fa39,0xb94ff487,
	0xc4459033,0xbcd7400b,0xebf3d511,0x2b19ed37,0xf113c23b,0x0675a913,0x303b971b,0x11512a81,
	0x0a591ffd,0x996df06f,0x4a49a577,0x499dec7d,0xc4cf2c5b,0x0a170221,0x7b272e0f,0x7743c24f,
	0x080f7181,0xf6f34ba9,0x9f472c8d,0xf437b71d,0x679d15e3,0x49a3f917,0x777d8f6b,0x62139f1b,
	0x3be9913b,0x17f951ff,0x920b7ce9,0xdb1b8481,0x5b41818b,0x24e9367f,0xd39bb80f,0xc3373491,
	0x72e7a023,0x0191bc3b,0xa03b25a9,0x38fbec93,0xfffbd691,0xce3beb63,0xa465714f,0x269f26d9,
	0xe88d73b5,0x9b4f9ba9,0x3df7d261,0xf30987bb,0xb48f80ad,0x6a69714d,0x853bf109,0xd2bfea9d,
	0x66dd35e9,0xcf45fa13,0xf5e1eb31,0xb8f58ee7,0xf63d9019,0x30c9ea49,0xb8017995,0xe8856509,
	0x6659053b,0xaa0379c1,0x891b34b1,0x24f37b7d,0x80c7598f,0x8b29e0dd,0x4517f9cd,0x83678bc5,
	0x2e0394a3,0x7a9bf581,0x0f476ff9,0xdbb3a769,0x6e6f1649,0x35dfe817,0x1b61ad0b,0xd95504fd,
	0xf35bcb9d,0xf2a12097,0x1687faa5,0xac6bed17,0x57f98401,0x5fb93b7f,0x303fbb2b,0x5ac1c759,
	0xfa656621,0x462526d3,0xc37d6ecd,0xb0c9476d,0x74a584f1,0xca0d5f1f,0x9f95d885,0xd29dba03,
	0xb5a394ab,0x4bbb4c7b,0xf14b430f,0x6d0171d7,0xba37bfd3,0xe8a9bf81,0xcbc5e5f3,0x865d54a7,
	0xe6179c33,0x9c738e59,0x51936a81,0xefc3883d,0xfced3fe1,0x01e151b1,0x7daf90d1,0x55ef3f6d,
	0xbb437635,0xb3e141bb,0x8c79f4bf,0xf243a70d,0x0f8d14d5,0x4e893335,0x04b7f2f5,0xdbc9f301,
	0xf32970a9,0x1015b465,0x609bade3,0xf8338b2f,0xe359f2e9,0x19ef4a1b,0x56bf32bf,0x8cdb5889,
	0xfa49ce0b,0x51a3cca7,0xc31fbe87,0x6fc5320b,0xa811d2d7,0xe1e7e4e9,0x30272303,0xd89969b5,
	0x0ba96555,0x5b9ba947,0xffa54bc3,0xd1a9798f,0xebf791d9,0x76c35aad,0x33d1e31d,0x48f1d0ab,
	0x50c741ff,0x738f4191,0xd84d1733,0xc113c021,0xbbcd91a9,0x1b55aaef,0x0b217ee9,0xa2598815,
	0x01a74403,0x6193054f,0xa5bd1ef1,0x2bb584ad,0xc2d75881,0xa4ef1db9,0x85f98ebf,0x03c17b1d,
	0x84c9bfdd,0x90377cc9,0x77153d95,0x69bf069d,0x6ad5311b,0x9b63e397,0xbab9d77b,0x069b256f,
	0x8f331e87,0x2c8fe8c9,0x31f7ca3d,0x5de5e5db,0xfc09cab1,0x5903b58f,0x2645ea73,0xded93333,
	0x44637d79,0x462de29d,0xb285387f,0x9559c2d1,0xbd37d8fd,0x2aa1752f,0xcbffc585,0x7aef2115,
	0x565f4ead,0xef1ffc0b,0xeb61b877,0x67cdde69,0x139fb439,0x6f8fcc7f,0x55c77309,0xa3cddc3d,
	0x25a5f89f,0x5bfb5f5f,0x05add6bf,0x1771ba0b,0xa303f921,0xb99fce07,0x33ffa9db,0x1ce36255,
	0xe1397649,0x03d36f61,0x810b1c6f,0xf0f9b7a5,0x6da728eb,0xed2194d7,0xbd8b6d53,0xc4296189,
	0xa69bf723,0xc037675d,0x539faf23,0x6b95b99d,0xf44b4953,0x60ebe473,0x4fcdad4b,0xb20bd883,
	0xa1d17f27,0xed3bfb1d,0x0a07f0f5,0x48fbc2e1,0x56318493,0xfe4dc8e7,0x6ea5e61d,0x597db669,
	0x2d5986d1,0x896ff6e9,0xe769207f,0xb55996d7,0x711dc965,0x611736bd,0xe477c0a3,0xa7f37ae9,
	0xf2399b1b,0x55e5df8d,0x0563f8d9,0x6761596b,0x014f6b05,0xf79fab01,0xe225b239,0x255dd62d,
	0x07effd7d,0xf6319251,0x741b51a1,0xc0492f07,0xc189c129,0x22b3cb3b,0x1f0f9cb7,0x142d48db,
	0x147d43f3,0x1063e501,0x5a31beed,0xebbfdc95,0x8b0fc80d,0x55a90575,0xf9196e77,0x9157c423,
	0x6c69f8f5,0x6d0f45e7,0x14c73159,0xfff7677d,0x75a1c06b,0x364f3039,0x94a3c255,0xb44949a9,
	0x32b33b7d,0x17475bcd,0x577d95fd,0x1da1b5ad,0xf781cf7f,0xbcfb2a91,0xfc917fa9,0xaef98b9b,
	0x78db5f09,0x7c99a5fb,0x4c797677,0x8ff32d8d,0x05739eff,0x547b7c07,0x42437a4d,0xedd78ca1,
	0x5ee58b8d,0x8d1b1c3b,0xb45b98dd,0xec995605,0x32b7fd27,0xfa23f4a5,0x9d9d129b,0x37d53fe7,
	0x33535d89,0xdb5fcedb,0x06479fc9,0x33cb7681,0xd10f7cb3,0x5dc54cf7,0x8cffd56f,0xce652915,
	0x932785f1,0xbc7586a1,0x8fdbaa59,0xf03736ed,0x10bf14d9,0x01b5c605,0xf54f1c21,0x8d7bfc57,
	0x89e36a45,0x67f164d7,0x953bf425,0x57113faf,0x2087c155,0x5ac1c959,0x41e9ac8b,0x0b873e55,
	0xb187c479,0x17e3834b,0x71097545,0x680bd9b3,0x4da92263,0xf03d88fd,0x84b55907,0xb97be439,
	0x5299430d,0x28dd9443,0xb4698255,0x0d578e63,0x23e91cb9,0x7bfb9f7b,0x960fa071,0x02c9f3af,
	0x841728f5,0x39f38289,0x46f96c6d,0x3ba5c7a7,0x8d877995,0x0a4dafdd,0x34df4e21,0x6d6322df,
	0x4b85edb1,0x4cb5116b,0x86df212b,0x12296fed,0xf34586ad,0x1a0505ad,0x268319f1,0xb9bd7873,
	0xbce3dd35,0xe5377cad,0x68bbcaa5,0xfa93921d,0x5c67b63d,0xbc7534f7,0x56dd483d,0x02c7eb97,
	0x1ab7b801,0x2a09189f,0x97ad6f77,0xc919f99f,0x8eab3f01,0xb56fba43,0xf85349db,0xddf303f3,
	0xf601530b,0x043ff207,0x955b92bb,0xdc69d25f,0x2e59bc2f,0x9b439a9b,0xa3c15c29,0x7b3379b3,
	0x4e4137cd,0x3f696e31,0xd9e5d409,0x3db548c9,0xde2dcd85,0xf6c70387,0x788f2901,0xc4f9d57f,
	0xb17b4443,0xa99beae5,0xf3ed8f7f,0xc0b329c3,0x5f6db739,0x634beb17,0x3c9b66b9,0x80391083,
	0x5c314ae5,0x33655e6f,0xa8957db3,0x239182b9,0xb1d90209,0xae9fafcf,0x7c47782f,0x6c633465,
	0x5965b2af,0x0fd9f799,0x137f53bf,0x2f014195,0x33b51b2d,0xf919b8bb,0xaa770cbb,0x6369fb55,
	0xa297171b,0xd48bbdab,0xc6cf6341,0xd639d4bf,0xc1c1f45d,0xd5891567,0x408dc039,0x79bd6ff7,
	0x3fcde821,0x998d3071,0xeb233a4f,0x56e7cb25,0xd73fa3d7,0x693f1dd9,0xde69baff,0x1e518d79,
	0x67850a3b,0x196fe835,0x5f9f4387,0x593f742f,0xadf30451,0x8c11129f,0x6a6f51eb,0x3a99df85,
	0x9ec37665,0xd14335bf,0xd9e765fd,0x0ff37fc5,0x5e1d5509,0xe84dbcc1,0x317fa655,0x52852241,
	0xd909da17,0x209dc25b,0x0619a551,0x58339e53,0xfe7fd9b5,0x1ac70dc9,0x06fd4619,0xa487e25d,
	0x9859374d,0x698d2fd3,0xa6dbc199,0xd9b320c5,0xc45b7a93,0xd2d3bfc3,0x64cbcb8d,0x49911cfd,
	0x0d338481,0x30a7b86f,0xb54dd773,0x26a59881,0x2375645b,0xf23ff535,0x8b497d8f,0x5517dfcf,
	0x369d4cab,0x3cfbcefb,0x810ffff5,0xdbb97773,0xee0da845,0xad5fd92b,0xa159ef77,0xf507e8fb,
	0x02154f47,0xb81bbebf,0xd047f0b9,0xc023b005,0x74e7dc0f,0xab073f31,0xd461a121,0x91d7472d,
	0x6b9f204d,0x4e1d4b87,0xff959bdd,0xe595551f,0xa743b9f1,0x2485434f,0x783f9ee5,0xee77f98d,
	0x9dbdc837,0x4d8d519d,0x221bcff7,0xc8413a2f,0x32e3c0a5,0x05adea0f,0x2755219d,0x48598fc7,
	0x11716401,0xc78165c9,0x217bd823,0x6ed7931d,0xa409d363,0x0cd1c07b,0xe2872ea3,0x7771ca03,
	0xae3bc525,0xaf897557,0xddd71bfb,0x8a8b9451,0x8579d9e9,0xeac37c1d,0x313537d1,0x0e2d38eb,
	0xea21119b,0xfbb96611,0x4dd3bf97,0x970d12b9,0x8073606f,0x62d59b01,0x4145bb83,0x7983ddab,
	0xe9a163df,0xc4a3b63f,0x9e8d4395,0xfa9323bb,0x7cbb37af,0x6ad903ad,0x0713e491,0x20e3c9eb,
	0x9fbf6ae9,0x65551cad,0x53a9250b,0x25cbbd43,0xc09114e1,0x4b21a52f,0x5d872a57,0x8641bfd5,
	0xedfd0a35,0x9b6728a5,0x674b7d95,0xb3e755bb,0x10b731c3,0xbe7d170f,0x25fff0ab,0x660bd215,
	0xc45bf9bb,0xa6e5e1ef,0x6a11a34b,0x8a9d840d,0xd06fec8d,0x12433955,0x685d27eb,0xd73703d3,
	0x415f65f5,0x6a6568d7,0xa321c8cb,0xfa1b9fa3,0x217d67f9,0x4643d491,0x7305ecef,0x6b35e8bb,
	0xd2078fe1,0x8af99627,0x301b9d2b,0xdd156065,0x04212b41,0x2ccf39c7,0xfad92913,0x4df744f5,
	0x51d76cf3,0x90319b27,0x251fec07,0xb8bb7ec1,0x771fc21f,0x8ab7e283,0x3b39322d,0x65efad2b,
	0x2ad1472b,0x041fa1a3,0xacd33d77,0xdcc3539f,0x97b75ccb,0x375110d1,0x16096a9b,0x740f2689,
	0x75775cfd,0x93576be3,0x28577619,0x835b7867,0xc1ab7003,0x3c6b6f37,0x33a9e135,0x33cbc6b7,
	0x18cb8169,0x2cebf4b3,0x4f4d7703,0xf1356705,0xaf3d54ff,0xf65bb0c3,0x22fdf157,0x7b1353e1,
	0xea4dbbe5,0x226b0f5d,0x4fd7bdd1,0x958719e3,0x9931e979,0x33ef30fd,0x7965e2d9,0x5a59e4af,
	0xce03e86b,0x47e907a9,0xee97049d,0x29ffabeb,0x56c72fab,0x567d93ef,0xf2c78a15,0x3c8f804b,
	0xd66b5777,0x13f941e3,0xa6b1e1ff,0xd2cff887,0x7dc1ee4f,0x71d36623,0x917fe7e5,0x0729be61,
	0x64896e01,0xbfabdad5,0xc9c36913,0x3ead3ba1,0x8263509f,0x6c45bca3,0xbe73c9a3,0x3a176719,
	0x47df4585,0x669347c7,0x9ff1c973,0xc6c7b1a3,0xd76d8655,0x1ea7d4fb,0x6905692b,0x0fcb131f,
	0xde6d4bfb,0x26c1f685,0x87dfef39,0x8ed13775,0x0e2363ab,0x7447b533,0x27170cd5,0x9d37cb9b,
	0x34b9e3df,0x40c7ed57,0x16ad22ff,0xa4fdea85,0xf643015b,0x8af9cbd3,0x5509a77b,0xf1cdaa37,
	0x25c1042b,0x37b96b0b,0x37fba9dd,0x21fbc8b9,0xbe135c9f,0xd30f8fe9,0x35bd7879,0x377f791f,
	0x7b09d857,0xf12986e7,0x4def656f,0x48ff507f,0x1255f731,0x2f5b20fd,0x1297aba7,0xd2c152fb,
	0x0c93605d,0xd527d0b5,0x512973cf,0xa7bb20bd,0x3e49774b,0x152fe719,0x5b79f95f,0x828342f5,
	0xe0e110b9,0xee45f0c1,0xf0cbcf97,0x365f98df,0x4bb147a7,0xac5d32c9,0xc6c3467b,0x8037e4b9,
	0x4cf37263,0x099747d5,0xb277efdf,0x779f78cf,0x22cf3781,0xef37dd13,0x71594457,0x9fd1046f,
	0x144fc2d7,0xd6ad8f39,0x124f6843,0x98ad80f7,0xaa671a8f,0xca8fe785,0xfe9d10cb,0x6fbf3ec3,
	0x88f3940f,0x079b78b9,0xa2f588dd,0x9139123f,0xe7b9690d,0x3db71c27,0xb86fd631,0x58f7a0dd,
	0xab636c83,0x70f14e9f,0x2d8bfe47,0x4379ce15,0x1e87dfb5,0x7a81ad81,0xaf316b63,0xbee94869,
	0x4aa1672d,0x29c393b3,0xd1b37199,0x9c193661,0xf1151fc1,0x053dd6a1,0xd9c7f3bd,0x1f87038d,
	0x242fd389,0xaba1a341,0x258f286f,0xb2514d8b,0x80234eeb,0xd4c17b11,0x35937f17,0x3343f0f9,
	0x040dd591,0xf29d5113,0x55c3a4e3,0xe7cf367f,0x8af3b76d,0x725dc6d7,0xe677a9cb,0x0d111fd1,
	0xe4c105bd,0x9d4b8971,0x456d458f,0x08c7d4a7,0x8f496803,0x19e1ce7f,0x56d13cb5,0x3a5f2fc3,
	0x0f491109,0x0cbdf127,0xae33e58d,0x6beb6bef,0xe965d3e3,0xd9a32f15,0x5789cd2d,0xe323f0f9,
	0x3b2958ed,0x8483857f,0x40357c75,0x126d40bd,0xf40972c9,0xb271ae21,0x3ffd5d0d,0xe9cf041b,
	0xae639363,0x4aaf3c41,0xc213be63,0xc7fd37fb,0x287960ef,0xb7a1d9ad,0x0e11faaf,0x0b517a53,
	0x5d796ae9,0xc7d5a3b9,0x30f3bbf1,0x42cd7717,0x3e75ff11,0x2f01a843,0x862560ef,0xff1d754b,
	0x0b6b1e73,0xa70582af,0xe0758237,0x439303f9,0x4c3f9265,0xb0e718ed,0x531d9723,0x9727c72f,
	0x69bd217f,0xf5d3786f,0x9abbbad3,0xb57d6509,0xe69be4a7,0x4821d335,0x26599129,0xdfdf92a9,
	0x3873bc07,0x444f9cc3,0xc0674bdb,0xce3f4135,0x40c9e413,0x9203c725,0xd7bdcf5b,0x4037eadf,
	0x660baa83,0xc50d1ff3,0x689bf7eb,0x2e0bffe3,0x4c8b435f,0xde5fcd49,0x85abfe8f,0x99a37381,
	0x2f87bdef,0x6d1deacb,0x80f9fe1b,0xff9168ff,0xda2519c7,0x4f8946a9,0xb5039823,0x681100b3,
	0x406d7bc3,0x14113e95,0xeda5ba09,0x180544f3,0xb8578307,0xfa4fbccf,0x712781f1,0xe1f73723,
	0xd2bdbdfb,0x93fd5519,0xa93d43cb,0x1719fca9,0xd4633f55,0x060581c5,0x6bfdae4f,0x18452bf9,
	0xcef7530f,0xe97300a3,0xe4e70ffd,0x86fd398b,0x5a0d536f,0xcc7d5015,0x1de3bc1b,0x166d04e1,
	0xec1f9dfb,0x53834bfd,0x28418fb7,0xfc678583,0xd395a88b,0xfa09eac9,0xe5bb96ad,0x02639803,
	0xcfb73637,0x73bf1a6f,0x7171d097,0x3683eafb,0x49bdac65,0xad7bbd6b,0x28e915df,0x3c950c0b,
	0x2dc187bf,0x6e3bc7c5,0x55151cb3,0x3f0994db,0x63c7f139,0x98257c07,0x734f9e0b,0x7ff9781f,
	0xe8bf730d,0x0987c847,0x1e539aa7,0x8a276e91,0x8777cdbd,0x1dd9c325,0x974dc00d,0x01ff83ef,
	0x31b1ed17,0xceb748c1,0xeecbed8d,0x1691c403,0xf90ffd2f,0x74e7b7cd,0xcdc7d93d,0x9299079f,
	0xa81b9f5d,0x295bce7d,0xde9fd4fd,0x8d79e19d,0xfb4d3f45,0xc625a78d,0xd61db375,0xbc3babdd,
	0x79ff87d5,0x8785d745,0x1c71cd15,0x628fb449,0xef77f83d,0x4ce3a86f,0x16332511,0xe3d389d3,
	0x83df98f9,0x79c97961,0x0d63ae6b,0xf4076971,0x754dd0cd,0x76f138f9,0xba69b0e9,0x68d7cb29,
	0x70bd59c5,0xd339039b,0x6d174e1b,0xaa930eff,0x8b135633,0x04a5e037,0xd5a32657,0xc5374a09,
	0xda1b85b1,0xc9659d41,0x6daf1dbd,0x1965335d,0xad899a25,0x28cfcdb5,0x81434135,0xad65311d,
	0x67f9acb9,0x145fe619,0xd7cfcb6d,0x1e2d8575,0xf7f1d2e1,0xa8bf7979,0xfd2949df,0x30559b91,
	0xf0dbd357,0x0ebb966d,0x2a95e1c7,0x011f74af,0x440ffb1f,0xfc4b4411,0xcfb9b52d,0xd775350f,
	0x99c51283,0xd58b1f0b,0xbba567df,0x94ebd0f9,0x4a217217,0x6dc11685,0xe5d3c479,0xc6bbd9bf,
	0xf63337b7,0x685d4939,0xd7238155,0x56c76ab9,0xc0ef9b87,0x39f5025f,0xb2db259d,0xdc97364b,
	0x282d64ef,0xc949d6c1,0xdfad0e41,0x8e61b2db,0x7db57fa5,0xb03be1ab,0x50b392f5,0xd1fb67dd,
	0x0033b0a5,0x1cdb21ef,0x6e694b3b,0x6deb5ac9,0x94396b2f,0x5261f6ef,0x9fbb7359,0x5a5b9c21,
	0x1d45c5d1,0xca29bd8d,0x72f7715f,0x321bf46d,0x76bb8f5d,0xf4bb8d37,0x66d77a23,0x43a5b141,
	0x0ce783ed,0x9ac514e5,0x53795645,0x421f9231,0x15ffa1e7,0xde1d980f,0x7367472d,0x964fd5e3,
	0x6b1b9ef5,0xdabf0bbf,0x0c910c0b,0x4fab66ff,0x01457d0b,0xe7d5537f,0xb94f06d3,0xb5492935,
	0x02633f63,0x78ab9e65,0x51618147,0x76ef6641,0x864fbf81,0x9db7e411,0x72ef11ed,0x7e075ae1,
	0xebc1a22f,0x259981a5,0xab8b2115,0x5e9fe3df,0xd15f6c83,0x5e15f6cf,0x412b8dd5,0x68774b0f,
	0xaeb7b8d5,0x751bc2c5,0x9b31730f,0x57ed3447,0x0d398bc9,0x79c16143,0x4b650c67,0xa70faa69,
	0x6145c94d,0xfd456791,0xb6f5bb4d,0x7e8b4c5f,0x831dc991,0x540dc179,0x5f7d2bfb,0x46bf9a1b,
	0xc7ef0e13,0x76a70e51,0xcbfb9a6d,0xd8a96195,0xbacf1693,0x82cb1df7,0x11d7376b,0x4ef94bcd,
	0x75b7561f,0xdc558dd1,0xfde1ad85,0x76fb89cf,0x9a8f4809,0xee4d85cb,0xdd53c611,0xe1afa1a9,
	0xec1fa4eb,0x8bdf9559,0xe6cb2e31,0x94b35b79,0x871fb7ab,0xf163b07b,0x43555bc9,0x5b53ce5b,
	0xbb29d275,0x65594cb7,0xb75d9289,0xb7838d7d,0x83c1e3b7,0x79639e15,0xebbd08eb,0x72d9f50b,
	0xa1552b31,0xeb53f42f,0x56b72d2b,0xcf9b9743,0x52390ee5,0x261d3721,0xc4ef0a51,0x59b1c965,
	0xaba9101f,0x62df8491,0x8279cd2d,0x57af50b9,0x92c7e06f,0x69e3ecab,0x23cd6955,0xdbcd2f91,
	0x55a396b3,0xf3914f23,0xeec95e2b,0x74ef9247,0xe42f040f,0xa9855839,0xe3b79bd3,0x7f9fdc3b,
	0xa94728ed,0xc77b9db1,0x6647883d,0x170fd4d5,0x03afc9ff,0x5c59dbd9,0x86912423,0xa61bf489,
	0x5f172541,0x2b2d5283,0xea155001,0x1841d1d1,0xed0fc6f9,0x2c2d4211,0x54bb311f,0xaaafae2b,
	0xfe137eaf,0xadb98865,0xd1d5b68d,0x5d372321,0xfa8b7437,0x15575def,0x7d193e21,0x0351ef45,
	0xfbc15cab,0x40b332a1,0xeba9597d,0xf521e331,0x04e9cf73,0x86a5aafb,0x350db305,0x6071ee85,
	0xdc1fbb35,0x582bbd01,0x9c3312eb,0x39b34ceb,0x8369fae5,0x816ded3f,0xd8778423,0xcd03d313,
	0x51b10ac3,0x0ab5abcd,0xfe95996f,0xef1f5bb9,0xabcddd4b,0xb97dd145,0x09b9d255,0xce75549b,
	0x5d79d04f,0x31613bcf,0x04732025,0x64176b85,0x9259c1dd,0xb5298c17,0xd1b98af7,0x84bd5b45,
	0x6ef94555,0x87c30253,0x95ebf6a7,0x91cbd8b9,0x49cdf855,0xed457b41,0xbfd307e1,0xca4b9fbd,
	0x8433f7cd,0xcbeb8d23,0xb1a3290f,0x3befa03d,0x036d74ed,0xed1fc4cb,0x09efaf6d,0x54114b2b,
	0x49a76a33,0xde6d0289,0x8cb91ff7,0x10b3ff7f,0x2ef7705f,0x728bf73d,0xac6b9475,0xd1819739,
	0x3a59b37f,0xe259c14d,0xb2d34077,0xc8cd1465,0x9ab107e7,0x8ddba9a5,0x8a291655,0x0c8f6e13,
	0xbfcb1f2d,0x5d4100bb,0x26118c2b,0x476b7d5b,0x935ddd3b,0xc1e11b8b,0x8c8d80e3,0x09a90a61,
	0x51ffcd37,0x5739709b,0x7f13412d,0xba3ff94d,0x0439b697,0x23efd4f9,0xc379ac7f,0x27c5974f,
	0x97775215,0x7ad1d93b,0x0cff7a17,0xb97f07a1,0x970d1eb5,0x7bd7467b,0x854d9dfd,0x4053d083,
	0x853556c1,0x351dbb5f,0xf575ce01,0x67d98843,0xd41504cf,0x63eb6917,0x8eed26bb,0xc747a22d,
	0x7eb938b7,0xd5aff057,0x5497f087,0x92815b9b,0x42175c9f,0x68fd5e5b,0x23bb848f,0xeb0fc8f1,
	0x7607a9f1,0xae9549e9,0x5d0751c3,0xd1270297,0x8653be5f,0x2a5f104f,0x2d9701d9,0xb4a171fd,
	0x0ba150e7,0x34673261,0x77e7be4f,0xa5ff3e9f,0x848b06c9,0x79e3d17b,0x5ce3956d,0x276ddafb,
	0xae896893,0x1e314c87,0x64dbff43,0x9dbbb19b,0x7f03f717,0x7bd9fced,0x488582a9,0x6165f213,
	0xbc416071,0x858913a7,0x5a017a3b,0x6f8d7df9,0x367bd505,0xc717962f,0x8dd9f965,0xbafbf5ef,
	0xa0cb7c7b,0x06817b89,0x23ffd151,0x1d25e69f,0x0a350ac9,0x84ede947,0xf0c7b5fb,0xe72315bb,
	0xf6a77529,0xdfa9907b,0x45f3831f,0x12b7eef9,0x17f5c71f,0x912b2ac1,0x7bada145,0x134d111f,
	0xa6d91777,0x12131743,0x19838abf,0x46f5faf1,0x5bfb9d41,0x9a2717a9,0x9f6d709f,0x076bd845,
	0x08e3e4dd,0x81532d2b,0xeecdffc9,0x5b0f6ef1,0xd10924e9,0x40af9587,0x536b45e1,0x45ef2bd9,
	0x02c7b355,0x137be7ff,0x2c77b659,0xbab94fe3,0x90639a53,0x38195265,0x35894f67,0x2bcb3d03,
	0x29074d5b,0xd119f609,0x6fa1df09,0xbc25e331,0xf1c97e35,0x663364cd,0xaa276807,0x10734d6f,
	0xdea311e9,0x05453e13,0xabeda6f1,0xc0054ec3,0xab7d35cb,0x0353ebc9,0xfc29b71f,0x65d74f43,
	0x75219477,0x5d8b7f65,0x4b7dd7af,0x51893907,0xf243aad1,0xba47aee3,0x7cef5087,0xd867852f,
	0x4c7f3d01,0x0a01f1c9,0x4ef37759,0x466568e3,0x995beb7d,0xc863be25,0xa45dd499,0x6f1b2259,
	0xf341e7ff,0xdd39e58d,0x6d71688b,0xdecb65c5,0x3287ca8b,0x1d79121b,0x30d51031,0xab5fea6b,
	0x4669866d,0x6c436377,0x34990a5d,0xe56b1793,0x2e0b7f37,0x7bdd2bcd,0x47379ca7,0xa929d18f,
	0x9179bdc3,0x2eb3ccd1,0x288dd86d,0xcf7966b9,0xfaa74537,0x985db4c5,0x92e77fd5,0x3ee79c71,
	0xae7187fd,0x9e997b69,0xe3f10ad1,0xdca7dc21,0x259dfcc7,0x3a4d1f0d,0x65c5cc17,0x1d8f8039,
	0x25d5d393,0x58876185,0x37e33625,0x37254135,0x7aafcaa3,0x5b7f452f,0xd8354043,0xf093c293,
	0x4ea72381,0x3b91a9ef,0x4c09eb81,0x13a73fdf,0x2421b801,0x48450a35,0xe917e7b7,0x7de159a7,
	0x6e692f3f,0x894757f3,0xbe815883,0xd15f0287,0xcab5529f,0xbf71f9a9,0x9dcfba4b,0xc5ef8c21,
	0xd91d82c9,0x05bde75b,0xc3f1e741,0x19ffd41b,0xb5a94cb3,0x1255e797,0x223f3c5b,0x23ab9129,
	0x11451e97,0x1783ec71,0x4779de57,0x01b7c001,0xeac31cfb,0x44c39087,0xe8c71ebf,0x6c8b3069,
	0xe7e117a5,0xe7adb3fd,0x0abb00df,0x273b3227,0x4e439ead,0x2d0b3981,0xca4bded1,0x1081620d,
	0x9c77376d,0x81cbe34b,0xc5d72e71,0xd3bd96f3,0xc2edb187,0x94035013,0x262b666b,0x39fbeebd,
	0xfd059be7,0xf3f11823,0x4773032b,0x1aedfb51,0x4a01d9bf,0x54fb0a47,0x024babe7,0xedef0fa3,
	0x860f578d,0x6eaf88d1,0x94af77a3,0xfaffacab,0x2341e013,0x7dc306a3,0x2b0b5221,0x2bcb0e6b,
	0x8297115b,0x6517a41f,0x092f80f5,0x7ca5d8eb,0xecf171b9,0x6eb1ec33,0x534f4871,0x0d85e53d,
	0x2c1da4c9,0xacbdb155,0x7711b0b9,0xd30f2e7b,0xc3d1c06f,0xfa950a83,0x34796ab3,0xe78fdec5,
	0xcaa7c1d3,0x9db3703f,0x46f9d50d,0x7bf37c43,0x6323226b,0x86bff999,0xae69213d,0x68d7362b,
	0xd4b38cf3,0x3289b927,0x980b9887,0x5f7f51b1,0x44a9b26b,0x2b053a03,0xe78300ed,0xbad3b719,
	0x0f453f21,0x28511cd5,0x5fe52243,0xf0659eab,0xc0a7efa7,0xd1b5d4c9,0x6ca76b1b,0xa1715dbb,
	0xaddfc5d7,0x1e9f8495,0x8aadb5d9,0x4bd9539f,0x2ddf5dd7,0x57a3fb75,0x51392da3,0x9b27f6b9,
	0x72836311,0xb783d231,0x1b015367,0x598d0173,0x018f2539,0xac23a811,0x4f1b22db,0x00e7bf3f,
	0xcdb14d49,0xb7917ff1,0x4a075783,0xebb37993,0xef7db283,0xf1033d29,0xe6add1a1,0x261f04f3,
	0xfe6f4f77,0x25d940a1,0xa75f1b49,0xdefd6de9,0x09e956f3,0x9a9725c3,0x7ed30d4f,0x78c5c605,
	0x323b6915,0x6bef9f89,0x39299451,0x3a9b10df,0xe197e841,0x8fb3756d,0x84ed95bb,0xa149511b,
	0xa5196e1f,0x75e3a075,0x9c0bf4b9,0x5041b55f,0xa5c760a5,0x49a5882f,0x8cdfb743,0xa29de55f,
	0xc18ba70f,0xd2475faf,0x23254b17,0xdc1f6ed3,0x443b7edd,0xf441a293,0x7109eabf,0xfa33527b,
	0x409170dd,0xd22fb1ff,0xf8192287,0x24e9b123,0x89356621,0x8dd991a3,0x724f7589,0xbffd989b,
	0x49b1dd05,0xa92bc4b1,0x3b0b22a3,0x1bd1f0bd,0x3f793e2b,0x073f4ae9,0x5813097d,0xc66f8867,
	0x92e9517f,0x8d4fbd8f,0x2299af83,0x7c894287,0x5047d333,0x63c58c6f,0x903564f1,0xba79630b,
	0x80bf28c5,0xd72d5ae1,0x1be789c5,0xed41fbed,0xe36335f7,0xd93d7cc1,0x4f19f2c3,0x438d7a2f,
	0x463151d5,0x21d39373,0xea996e7f,0x1ead52d9,0x7f0d5baf,0xeff94ae7,0xaf9f6a4d,0x239dcfff,
	0x04c1f023,0x6ad9368f,0xc8cdb74d,0xebfffdb5,0x2807be15,0xa2c9ce69,0xd32b6f65,0x571db721,
	0xec75fbad,0x324b8bfd,0x8729fa47,0x7ae7d36b,0x8193fb63,0x7f032755,0x019d3269,0x34fb72c5,
	0x5bcde0ed,0x9abff409,0xaccbaa0b,0x5b9b6b65,0xed757651,0xc4775e33,0xc9591031,0x8eadd68f,
	0xffc920db,0x8947877b,0x9759b5af,0xa8c7bd8d,0xabedf61d,0x8577040f,0x1f413219,0xd023e6ad,
	0xf3edf0f3,0xc573b7a1,0x9af328cf,0x27a3c24b,0xfbbf467f,0xc6d3d26f,0x7eb52df7,0x1fd177c9,
	0xe23bdb2d,0x1955ee3f,0x223bcb83,0x67dd128d,0x3a29d7b1,0x9fe14b5f,0x0999a629,0x7ea5cf0b,
	0x23355e05,0x71812da5,0xce51c269,0xe3a987b9,0x02f15e6d,0x5a6f596b,0xa84de987,0xe815421d,
	0xdddd8c73,0xfd09b099,0x96db2e97,0x1fb9dbbd,0x505973ed,0x92d3ef9b,0x29b5936d,0x7211d729,
	0x27b3adf3,0x4d7d8a67,0xe9fbcda9,0xcb3d48ff,0x9b2135eb,0x57dba979,0x63332bb3,0x6d0be4db,
	0x24bbde7f,0x76ef46d7,0xcc4f99b9,0xdfe92a6b,0xfa8be6a1,0x4add6b0f,0x50a7c6b3,0x83f5b25d,
	0x2779ae8d,0x2ff38a35,0xf8fb695f,0xc1ef9b6b,0x44598cc9,0xbfa700e7,0x3473a547,0xdc411755,
	0xd0ebc31d,0xf199b14b,0x01a18fb7,0x5fff17e9,0x2ccf939d,0xdc8dc00b,0xb77dd4c9,0x35e31bf3,
	0x309375a5,0x17757161,0x6e657c5b,0x534f1c4d,0x66ad6ad7,0xba632607,0x0923cf15,0x0b4b98db,
	0xe477741f,0xff977843,0xdde55b65,0xff8dc585,0xc33526b1,0x847778e1,0xff471a83,0xb16bd73b,
	0x39156107,0x2a910c39,0x2547b56f,0xb2eb70f7,0x522b1fe5,0x989d6727,0x364de9ef,0x77b530bb,
	0x49737355,0x5b77ac11,0x70290f91,0xc61d5c91,0x81cf93ad,0xa727a7e1,0x3115bcaf,0xc81daf87,
	0x1f0f1685,0xb7dbaf0f,0x60b18b67,0xbc5546b9,0x3ee543c3,0xd2e79a99,0x7905fea1,0x4713ae47,
	0xd1ed8a91,0xe7cde503,0x2f7f870b,0x63450e5b,0x14ab1661,0xd12fe759,0xbdf9a81d,0xf3897827,
	0xa88f83f1,0x35df3633,0xcbb53d17,0xf31d52e1,0x4ce7b641,0x09d11ead,0xf659ddfd,0x46f1e8cf,
	0x37f5cb9f,0xaf25436b,0xfaf564a3,0x2e931435,0x0fdb329d,0xb71f599b,0x7f01919d,0x553d0c69,
	0x83a5df17,0x432f05f3,0x7961d14b,0x82d352c1,0x84479f2f,0x05ebd9b1,0x3b5920d5,0xece1bfa1,
	0x1d9d9053,0xe4116f97,0x199b1329,0x2795af6f,0xef6db431,0x3587a8f5,0xb53ff5ff,0xb6cb4f9f,
	0x4661a5cb,0xa65b0aa1,0xe4c516d7,0x3f070ba7,0xd50f6e5f,0xb7c539f5,0x3d1727f7,0x56711a0d,
	0x0cf37a79,0xe12199d9,0x3a81c56d,0xf5dd2957,0x1771aeef,0x50f507b9,0x09c11a13,0x89c32d17,
	0x6ed59dd9,0x4df3b88b,0xf0f3a487,0xa3494ae5,0x1753db9d,0x37ed35cd,0x58a11c31,0x4935e765,
	0x780773e5,0x28e37a81,0x74b9763f,0xe8fbd33f,0xd3f77ea3,0x35fd3037,0x8d970aab,0xe7b59823,
	0x630dd515,0x50850c03,0xe8f9d92f,0xd327e5cb,0x0b21e6bb,0xc6f54b83,0x5307ee57,0x32b91ef9,
	0xb8ebae63,0x65eb51dd,0x4751e871,0xf87f0675,0x5911c721,0x392b64bd,0xb9d19c93,0x92318c11,
	0x711fa14d,0xeca58959,0x7fe7db9d,0x9a33b9a7,0x5889d78b,0xcd6d816d,0x59595737,0x288fc017,
	0x11ada3c7,0x6ac5e83f,0x995ba6cf,0xc3f7244b,0xc2cd7435,0xd7116f9b,0x6f816c9d,0xf2c50c33,
	0xcf15a04f,0x88df3cdb,0xd0cd9aa1,0x6bfdabcb,0x8f9d3dd9,0xdbe565d5,0x00a9d7a1,0xe847d211,
	0xac5d15df,0x32038df5,0xb9e3042b,0x92f7960f,0x153bb9b3,0xb43fa325,0xf7b5df9b,0x1b0523d9,
	0x9b03b7ef,0xb3c5bad9,0x5ebdcd0b,0x6415a985,0x286bf179,0xaaed0f11,0x4605b865,0xd7716435,
	0x9b0b0e7b,0xde351b51,0x5ffd1b57,0x550bcd13,0x3c6d1367,0x9d43d9a5,0x037d2259,0xc47de651,
	0xdaf715fb,0x23e71fa5,0x14c7f1ab,0x4609a825,0x83031239,0x1b131b6d,0x8e7f0a53,0x039b8dd5,
	0xd7c9df6b,0xb9ebf0a1,0xaab9cf1f,0xa1c542a7,0x0c714525,0x86b17571,0xabeb29ab,0x50bf6eeb,
	0x7d033043,0xb7d30f8f,0x45f74f51,0x7d6da4ff,0xe77507e7,0x34ebb139,0xa725a63b,0x22596e3f,
	0x44a5227f,0x37b3f637,0x2123ca57,0xb8b57819,0x41575abb,0x8d1560d3,0x720db25d,0xc95be0fb,
	0x5735c497,0x761db6e5,0xad61f4cd,0x1dcda55f,0x85d38257,0x29017ec9,0xc5072ced,0x91372cc5,
	0xabb1b987,0xf2219c63,0xb24f7fcd,0x8169f6b9,0x7f2fa7f9,0xf5010e21,0x3ef34143,0xdfdf67cb,
	0x279dd8c7,0x8d51c9f9,0x6e13b8ef,0xe2bbb695,0x762d7957,0x4fe7ba67,0x85350739,0x55c7f8b7,
	0xbefbce53,0xabc1db73,0xb54d2a4f,0x8b754fdb,0x520bc8ad,0x2b0577a7,0x63af2329,0xeddf36b1,
	0x944bbaa3,0x54018519,0x131d3a87,0x2fc7edf3,0xb88f2cb7,0x2a2d2269,0xecc165ef,0x1d990963,
	0x1893d2b3,0x4f2533b7,0xe929ccb1,0x0e651cc9,0x2df9a0ab,0xc3af1fb5,0x994f6ce3,0xf4e788f9,
	0x2b51fffb,0x48bdac97,0x8f91e067,0x108168c9,0x350d2447,0x6061fd19,0x68b941df,0x3e3b9e1b,
	0x3a898077,0xeedbad83,0x74f731c1,0xe9cbfed9,0x6f0b5bc1,0x7b93109d,0x00e3fb3f,0x9e89a1f3,
	0x62bd86a1,0x12138cc3,0x3e7dd95b,0x38774c65,0xbbb52fd7,0xc31718cd,0xce2f5bdb,0xb541fe2d,
	0x8eefd971,0xc577d921,0xe7c5ec4f,0xa5379f57,0x594f6dbf,0x373ddcaf,0x237d730d,0x3c55ccf1,
	0x98a17461,0x7e97f9eb,0xe2f11c35,0x033bc617,0x04996737,0x4adbcbd1,0x5a2f3caf,0x283778eb,
	0x67d3276d,0x3585cee7,0x38a5572b,0x7037af93,0x18d59277,0x033f9e39,0xf229411d,0xc7d95d43,
	0x1309370d,0x84d5505f,0xa7ff67c7,0x745d0b33,0xafc52a37,0x183ff475,0xb1cd352f,0xe4af65a3,
	0xff45fc3d,0xc9992f21,0xc6a59525,0x225fe8df,0xc1adcdb5,0x1429f78d,0xc5fd9a3f,0xe2a9ae37,
	0x00098477,0x435f7471,0x20b542dd,0x376d5903,0x454d20a7,0x73d3f90b,0xe2195e27,0xe03923a7,
	0x775731b3,0x343f221f,0x58d5910d,0x3b3b0c8b,0x4fe96b4b,0xc68b12f9,0x60037b43,0xd651231f,
	0x75b15a6b,0x00c5d271,0x4823fc4b,0x9ffbf4dd,0x35413a59,0xce25c7e3,0x601f986b,0xb8631a47,
	0xda17e99d,0x50075833,0x1e45fdb3,0xe25de3e5,0xa797ff09,0x9ef3a2cf,0xe94fa8f9,0x94632749,
	0x720dfebd,0x2b975ead,0x815baadf,0xa9952c0d,0xd7afaf19,0xbfc9d74b,0x08f38cc9,0xb2c1b8d1,
	0x19958dc9,0x1f8509ad,0xae0755e7,0xe755403f,0x94c764c1,0x49f5e15f,0xf2efb031,0xb66f2e07,
	0xdb31ff3b,0x5a659577,0x976b2d67,0xf7cf53e3,0x6ca7febb,0x094b2595,0x21a3ac0f,0xbcdf7695,
	0x0fe3d00b,0xcd47f6db,0x0729dc79,0xc1b3fae7,0xcb8bc03f,0x9c1d90f7,0x75f3e5bd,0x7e05b2a7,
	0x7f2b31b3,0x4bbd7b1f,0xbd632ab7,0xd635c9b1,0x1c39f10b,0x933d390f,0x57412f11,0x6c4fd2e7,
	0x7f0faa31,0xabdb680d,0x90bb9c3b,0x9107f52f,0xe7f17d57,0x91fdfbe7,0xd36d6669,0xd4b3387b,
	0x140db3f9,0xe6319bf3,0x8e55119d,0x3859f2c7,0xf67795dd,0x6e2f200b,0xbedb169d,0xfea15511,
	0x11295e09,0x35d32d97,0x19cf67f9,0x1cdf1865,0x6e094fd5,0x5025f483,0xd46b1707,0x4c0b4ad3,
	0x37e5ebdb,0x38510c43,0x0d4f18e9,0xb9cb3c73,0xf36f44fd,0xd2af70d7,0xd5812b83,0x59658c69,
	0x58437567,0x0dbf9fc5,0xd973da85,0xd4cd55db,0xc9e5338d,0x2323d515,0xa9fda469,0x1d9f7cfd,
	0x70c38729,0x78ad6861,0xa5613f6b,0x9e191c07,0xf3319e3f,0x215149c5,0x8043fe93,0x0a29103b,
	0xce69c219,0xfe2d9ee7,0x6eb956b1,0xd061a6e1,0x4f936c4d,0x7f8b7ff3,0xed35835b,0x2af96a4b,
	0x2cb97bb3,0x05d5d49d,0x299b4bf3,0xd0d70ed1,0xbdcd8971,0xe2a15125,0x0c33e89d,0x46817fd7,
	0xd5b15def,0xf9b1934f,0xe0ad0749,0xcf2b0cc5,0x3b2385e3,0x01e95f67,0x9f21f0b1,0xfdafb60b,
	0xc1d30749,0x6657fd45,0xd50fcd51,0xe5919a23,0x03553661,0xc731b545,0x2e5f0a71,0xebf9828f,
	0xb825aab9,0x1ad76d4b,0x9e63df21,0x38bb90d7,0xb0a75423,0x6ecf65c7,0x28d1f139,0xc74f0b8f,
	0x6e27afbb,0x48c516ab,0x4acb1a55,0x17d94b4b,0x5bd91ce3,0xa7912c77,0x03d94cdf,0x8023c7b3,
	0xa7d95247,0xa431a52d,0x7ee99907,0x1c9f4469,0xbc2df2db,0xb2cd0d5f,0x5b5751c1,0x61671e25,
	0x57bf42d9,0x83afdd1d,0x95e151cf,0x4b3fb79b,0x4765fcc5,0x8451f509,0x11af60b7,0x308f0691,
	0xbedb466b,0x004f3b45,0xc151b7cb,0x326940cb,0x51c5c5db,0xe271587f,0x6fc1a71d,0x4d89a91f,
	0x8cafd673,0x15a594ed,0x295d5a91,0x0b517c63,0x2e0dddd7,0x8601d54d,0x44f1becb,0xd2cbfe79,
	0xff3bc0f1,0xc1c1b7e1,0x0ca9863b,0xd9a9a74d,0x4d7f78f3,0x3a4fd179,0x071f4e1b,0xb5456fcb,
	0x0305c85b,0x25370a6b,0xe053e367,0x8ba33ef1,0x5fdf0fe9,0xfd2f1b91,0xf2afa7e7,0xe46b76bf,
	0x530b43ab,0xa3172b53,0x7001172b,0x19efa13b,0x736dfff3,0x1ef38a9d,0x2a836b8b,0x6a2b3d7b,
	0x98d1be5d,0x00f391e5,0xfdd36323,0xa7c1ac97,0x14ed2acb,0x626d9e27,0xd7fb24df,0x8afb3ead,
	0x8c599869,0x86df2de9,0x626b4569,0xa2cb5feb,0x6f9d96ab,0x1cef1e39,0x4af9ec3d,0xe5cbe57f,
	0x1425a64b,0x1f6d07ad,0x2ce91897,0xe33d7aa3,0x6d430e4d,0x564bbb5f,0x19e3067f,0x940d2d99,
	0x6537d0fd,0x77abdff5,0xc2f3b3c5,0xcbcb1ca9,0xd621c0eb,0xe8d3ae9f,0x41978501,0x49b34325,
	0x230fb5f7,0x1f31d011,0x80a90a8f,0x69a76667,0x70f5e241,0xa1595987,0x4577e59b,0x753122cf,
	0x7fb14733,0xa80be9c7,0xd8afcd0f,0x948318c7,0x23054a85,0x5f2fe61d,0x4f67b2a7,0x5f7739bf,
	0x5b9f6b2d,0xc6d1d761,0x742307df,0x0e8f3531,0x10131673,0x3427e6ef,0x4fc922ff,0x4bf7059f,
	0x65db9cdf,0x728f7bad,0x52a9c417,0xa47f9d93,0xba5d4745,0x8491f705,0x1d7db9ff,0x98a3b49b,
	0x3be78bc1,0x04db91f1,0xea63a755,0x4d83b453,0x22ab62b5,0x274359e9,0x95e7e77f,0xddedc55b,
	0x89c3bbcf,0x59c74df7,0x47f593af,0x4b51fc5d,0xe83912fd,0x858d9ba7,0xbce7a7d9,0x0ec9a70b,
	0x29f52581,0xefe3fc0d,0x2e7d47bf,0x4a17b91d,0x68cdc6d9,0xbb3f30c5,0xdce123e9,0x98a55953,
	0x457bd5d1,0x0841a0f7,0x37a1fea3,0x80878e79,0xe0a7517f,0xb6af1651,0xa6b55105,0x83770c5d,
	0x73d98e3b,0xc6759a05,0xf3810ff1,0xcfd720dd,0x8a898aab,0x58ab71d3,0x51c7910b,0x91afc0d5,
	0xdb1164b9,0x50913cfd,0x08bd8fc5,0xe3b5b533,0xbfb7ee97,0x94893153,0xbbf95255,0x6041e7e3,
	0x4fa563c3,0xef23782b,0x547beeb9,0x5255d0e3,0x17f13dff,0x9017ab5f,0x89abafb9,0x869b0333,
	0x74952a55,0x2d437257,0x0a5b99e5,0xbc67d9db,0x89791e19,0xc3ab3f01,0x45c11095,0xb6b344ed,
	0xdb678be7,0xf87d2acf,0xd47f9ae7,0xed21b681,0x8913b8a1,0x1a13f3bf,0x819dc8c1,0xdcf92fbb,
	0x24193075,0xc0e91957,0xf38937d5,0xfa316dc3,0x29fd5bd3,0x10a319a5,0xf51fb899,0x405f36c9,
	0x1d2f3477,0x9913ce3f,0x5e9b934b,0x63c9c707,0x3dff1a65,0xd72de93f,0x9ea9ecf3,0xa2595dbf,
	0xe3abc8e9,0x5611924d,0xe3574c61,0x349fea39,0x75556b93,0x70052395,0xe31f3f2d,0x5ed5d8c9,
	0x030dd343,0xaf7506cb,0x45e11eb5,0x21e1ffc3,0x7ec5cb19,0xcff9b22f,0xade3f51f,0x8c49ac8f,
	0x955b8d81,0x5f4fc587,0x60d7825d,0xab41d08f,0x2791592d,0xfe5d471b,0x90d56125,0x1ba54e3b,
	0x6313261b,0x423100c7,0x455d4bf5,0x3af56607,0x7b777a8b,0x3503fce3,0xe4598215,0xf85b4379,
	0x0339600d,0x772f2355,0x5b174c97,0x45abaa15,0xe4bd786f,0x003df68d,0xe74fa34d,0x285dc271,
	0xfb4f32cf,0x7fd9707d,0x8025f1db,0x6a970723,0x4c23208f,0x5eddffa5,0xdf1bfca7,0xec1f51cd,
	0xdf576a5d,0x6043a409,0x2927e5dd,0x93690819,0x38ed6529,0xe2352c37,0x379f5279,0xde9168b9,
	0x71d3472f,0xbefd9243,0x8143af37,0x1457f865,0xf0dbfcf3,0xce1778c9,0xa33b95a1,0x15250edd,
	0xc3c31e41,0x051bc7f3,0x8a195103,0xcc0f83ed,0x982f032b,0x38d36a69,0x3ad38377,0x3fcd7c65,
	0x54abf90b,0x7e2d2a65,0x3bcbeadb,0x43c3571d,0x51ad9787,0x2b3fae9f,0x9dc745d5,0xc8fbb9f9,
	0x328f3589,0x78479761,0xa4fb58d7,0xcf29bedf,0x5e957e45,0xc0abbb75,0x11fb1317,0xf5a340c3,
	0x19ed2635,0x63f98533,0x0acbd393,0xac6f489d,0x3ea9c01b,0x46e96f77,0xa3d1ce13,0x05359a6f,
	0x95c7b205,0xf457a2a5,0x08dd9029,0x24496241,0xd02d4a47,0x5e49b1ab,0x4629a629,0x51a30125,
	0x1fa3f479,0x3eef76ff,0xb1536031,0xa9e7fa35,0x6fdf8e7f,0x19a1119f,0xf265b72d,0x6f5fff91,
	0x3f7fdd87,0xdbd9020d,0xaccf51c9,0xfafd1f63,0x19072301,0x1e3f6759,0xc86ba97b,0x4d5d10db,
	0xabe1d1a9,0x05a35c19,0x5a754f87,0x3fbda133,0x85616285,0xc3f97367,0x2e9751ef,0x550b40ad,
	0x69c749db,0xb95f55eb,0xefe3c087,0x2ad9af93,0x4d330c43,0x351d7ed1,0xf1d151e1,0x8a5fcb33,
	0xecb57397,0xd6a118cf,0x993f2861,0x19817ae9,0x073de3f9,0x8e81fb21,0x6577b72d,0xabc9bd15,
	0x36abd0d5,0x3f79c68d,0x9927c733,0x3369d421,0x68c351dd,0xff732261,0x836b9c2b,0x523b937f,
	0xf82fd80f,0xf87b1973,0x68c13993,0x8ac3cca7,0x658502ad,0xe9c7971d,0x0c11c7b5,0x1129dc19,
	0xb03f9441,0x48b70445,0xd7ad189d,0x3c3f5661,0x4fc587a1,0x01cf045b,0xa64b4d25,0x9681d50d,
	0xcc6144e5,0xd9c15253,0x2c0d99eb,0x8f11e3b9,0xf845f671,0x6e5fbda9,0xff792c55,0xcab90d07,
	0xc893fdf3,0xd7a94763,0x42832f95,0x14eb079d,0xce49895b,0xe8c55f0f,0xeb7ff1a1,0xf0c1032f,
	0x4f5947e7,0x11013fc1,0xae312837,0xc9ff1575,0xff913f17,0xdcd56d17,0x84bd55e1,0xc60bc731,
	0x59b3bfb9,0x16dd5035,0xd8b94eeb,0x34fdc12b,0x98617adf,0x88e1f4cb,0x4c17de6f,0xa28b9933,
	0x4f27b6e3,0x5ccde60b,0x223d8b4b,0x8719bf27,0xa379a46b,0x1dbb2bb5,0x48ef7d27,0x98b189e5,
	0x25b3d361,0x58e5670d,0x015f8171,0xbc036455,0x4a1bc7f9,0xdeb50fdf,0x29253061,0x956d1a6b,
	0x81dbafad,0xa3b7d183,0x234131f5,0xb9f14621,0xf4093641,0x41a107d5,0x611da2f7,0x8035dc75,
	0xd6a17abf,0x18515c39,0x8b8799f3,0x7191da71,0x6787247d,0x0ed1829f,0x4bb7cc43,0x5afb1227,
	0x85879813,0xf44b1679,0xb44f5305,0xfe1517b1,0xe9554c65,0x811597c5,0x4a579021,0x622d4e2f,
	0xfe8f3fa1,0xf7b1880b,0xae3f3343,0xc53314cb,0x5cb78c37,0x65c3a755,0xe4df5ee7,0x2cc113b5,
	0xe0391de5,0x8519513b,0x4075ed4b,0x9719a929,0x636d86ab,0x3cabf9d7,0xe9afd573,0xcc277665,
	0x178bf3d7,0xc195cad1,0x0897b033,0xce7b0cb3,0x7db942fb,0x581f6057,0x8da95d1f,0xec51ba67,
	0x000336f3,0xb4b5a61b,0x9ac5c797,0x708977d7,0x2a5dcce1,0xfcefd45b,0x8c31cbc3,0xf3b1f465,
	0x83a5b131,0x688d8cdd,0xa1a13b91,0x4cf9c37b,0x069dd497,0x827117ef,0x472903b7,0x233ba98b,
	0x3af3210d,0x09abc167,0xfe4d70b9,0x1df9090d,0xee394ed7,0x7273559f,0xe6f393db,0xb65d6f81,
	0x8cedd97f,0x0727be7f,0xe86bc82b,0xa83b4273,0x1b7514db,0xa94bc073,0x7a6f5783,0x030d8c73,
	0xcf196203,0x328fd771,0x0e1d3f81,0xdaf5ea19,0x470f845d,0x75c733f5,0x16ff168d,0x99bb9709,
	0x65751691,0xdff5d805,0xb40510d5,0xefd59ae9,0xc84f1f95,0xb93dd42f,0xf8872551,0x6559166d,
	0xe285c7a5,0x05eda487,0xd54552bf,0x8b0fb04d,0xb4f12d41,0x077badab,0xa16904a9,0xcb5b224b,
	0x274b5a37,0x5d87d9c1,0x4381985d,0xdb53e62f,0x013b5899,0xc6d55573,0xfa8501f1,0xcbb102cb,
	0x834967c3,0x82576cfb,0xc6d79145,0xb9d5f8f9,0x9fed5157,0x501f8913,0x733fd6ff,0x20cdd099,
	0xd481de43,0x126d4c01,0x3deda991,0xca474593,0xa2496bb5,0x0ea7ce91,0x21774a31,0x5fa114db,
	0xa773a02d,0xce5bfd1b,0xbde1a9df,0x9adb696b,0x5813406d,0xa041147b,0xe191ce61,0x179f6941,
	0x57252481,0xb9353f17,0xb2595745,0xc441e267,0x6f8b4cb9,0xf53f51d9,0x766f22e5,0xf2b917f1,
	0x2d1516b5,0x388da939,0xfd73135f,0x09adaef3,0x15739255,0x70732635,0xa971f39b,0xd563bb95,
	0x8147f6c3,0x34734b51,0x17d57c47,0x78d1edfb,0x150f3777,0x072f7999,0x6a7b78db,0xfe8ddf57,
	0xda3bb927,0x37794da5,0x309f0c97,0x89dd7ee5,0xf81f26db,0x61451c91,0xefed1781,0x27a99ee3,
	0x0cf766db,0x8eb39101,0x4d73bb67,0x3f85a19d,0x26e7afbb,0xf9076823,0xd6ab00e3,0xa4ab4661,
	0x5cf9bd57,0x69b14ead,0x6a739c53,0x46fb968d,0x082525d1,0x3b47dddd,0x4215d2df,0x8401f27d,
	0x9c47ce95,0xfa87b875,0x9a417f75,0x17ef3e9d,0x211f8157,0xa757c7c5,0xfc0f37cd,0xaea1305f,
	0x4b5fa111,0x95c598a3,0x25ff9167,0x1497bb3b,0x3597ff07,0xef09d869,0x94fb8689,0x07fb9db1,
	0xb945cfc5,0xd27ff1ff,0xad51fb41,0xa9a10e4d,0x67cbc01b,0x16adcad1,0x83b9626b,0x8e01889f,
	0x23792a29,0xaa459fd5,0x465582a1,0x6e3fba41,0x58816a4f,0x95190287,0x45ad5b4b,0x79258fd3,
	0xd6015437,0x9929f5ef,0x9daf299d,0x442561fd,0x46fbc7d9,0x739d2b97,0x7eb78d89,0x5c5b4273,
	0x4b5b666b,0xbdbf6095,0x1683cecf,0x778568ed,0x30f76775,0x6e09da87,0x193b41f9,0x4513c02d,
	0x4c8b8dbf,0xf9190493,0xea71cd55,0xdf1192fb,0xf2bb3c5d,0x12b32c65,0x661b8df9,0xdb3d592b,
	0x1115abab,0x0ec75f31,0x49999cc5,0xfbfba491,0x67093e4b,0xe26966b9,0x3cb7f361,0x81512e13,
	0x5ef5f62b,0xc4dbe63d,0x7aa1713b,0x19f30299,0x871f097b,0x7081978b,0x1af1008b,0x743bd015,
	0xaab397b7,0x03e9a7fb,0xfaa9db51,0x6f2d527d,0x8ac37ea3,0x82c93569,0x452df053,0xeb71e0d5,
	0x374f4f4b,0xf701eb3b,0x9d536821,0x3c591a27,0x083762ff,0x3197bf5d,0xe64d4a11,0x38e1b281,
	0x3649105f,0x2bb7cf43,0xacc14143,0xecab5fff,0x1439004b,0x07b95ced,0x2fb3819f,0xe901e7c1,
	0xe7a5a2ed,0xb21bebdf,0x0995ccd3,0x35d54af3,0x620fc4bd,0x22837e25,0x793f9757,0xe2c113c1,
	0xb9e54373,0x3cc1f157,0x4af14d6b,0x3809c269,0x637be311,0x51c77b91,0x6153b815,0x87955a29,
	0x6a0b42e5,0x40b94877,0xde778225,0x9df70e4d,0x68bbf283,0x37d93639,0xecd3dd31,0xd36b0f25,
	0x2399a6c3,0x1595b289,0x28494699,0xbcd37709,0xc0958ec9,0x6987b7a5,0xa7216c85,0x7cb9575d,
	0xa08fc901,0x1569e955,0xa30b32e3,0xb44fe587,0xd84bf81f,0x8e25d1e3,0xc21dd86b,0x146fc7fb,
	0x4973f81f,0xbcc73f27,0xffdb3b9d,0x8e9d8331,0x5b9bb341,0x7f85bf7b,0x362b3fbf,0x25ff06ab,
	0x55431711,0xcabf3ec9,0x465f51e1,0x606d59f1,0x54cb2965,0x69f9c379,0xe22d0dd9,0x575d6995,
	0xe9833d57,0x60e34b83,0xf4b50347,0x68f3f42f,0x4c9b4849,0xec53c963,0xab839a93,0x88f79763,
	0x3a3356e7,0x23474121,0x1f8319eb,0x31dffcd9,0x6a4f2223,0x37e50547,0x9e0fca49,0xf5c32741,
	0xa9d9c43b,0x587b13eb,0x91e93c67,0xaf65df55,0x93a78db1,0x308193ab,0x0c35add1,0x533140d7,
	0xe975fa4f,0x099370ad,0xed878dd5,0x60376791,0x8ce5c629,0x8c77199d,0xaed72289,0xf1333c51,
	0x1887229b,0x221f5cb1,0xca834dcf,0x6d8761f3,0x18cd0b49,0xf49d64a5,0xc555724b,0xda3d4257,
	0xe513bb1b,0x9031d5bf,0xd77d786d,0xcb053b67,0x189f4147,0x24430acd,0x3593f36d,0xf33dec15,
	0xab9b3647,0x645f7225,0xf997664b,0x56e7a157,0xac1d90e1,0x093b0aa1,0xabf3a8cd,0x1ba9e331,
	0x97219b1b,0xf1b500a7,0x6c756c83,0xf9d921ad,0x5189074d,0xe3d56b27,0xbb55e1c3,0x4d7181db,
	0xc1252511,0xedc92895,0xe2357cad,0xc713cad3,0x05a73649,0x66e7dbed,0xfd1bda29,0xbd0772b7,
	0x51ade421,0x90ab09b5,0xa37bc4e7,0x1c43cbb1,0x63b9d40b,0xd7bf54f9,0x312b5a5b,0xf95f50f3,
	0x9f375cc5,0xb4efdc51,0xaf694fc7,0xc19d13b5,0xc57d5b51,0x2e33b6d9,0x5de15731,0x0be74839,
	0x4ec727f9,0xf7a79135,0xdba3a469,0x09d1f2c7,0x6339ab51,0x34916a95,0xf0259205,0x9895b4af,
	0x73df9337,0xd86171ab,0xf4476665,0xf215b94f,0x73ada7c9,0xa7af01b7,0xdb5538b1,0xfdd9c305,
	0xb0814077,0xd935bf7d,0xdbfbf5d9,0x42175839,0x4c1dd8f1,0x56dbd649,0xb9538591,0x74a5105f,
	0x552dc633,0x9eaf54f3,0xabdf0f5b,0xac0900ef,0x80490b81,0x43e9aad7,0xea835f7d,0x306d4a6b,
	0x80e94f67,0x0fe544d9,0xd3956c07,0xeca1c55b,0x0273f0b7,0xc32b4a67,0xb5c7f9cf,0x7f21cf51,
	0x41333b8d,0x76697a77,0x393d6177,0xeb0d37e7,0x435dbe4b,0x9b752887,0x687f7463,0xe9314dbd,
	0xb20fbe9d,0x9e4b5999,0x597d81c3,0xd9010b7d,0x524bce75,0x2615013f,0x768f7b8f,0x519364d7,
	0x1dff8111,0xf61f5e89,0x67753b87,0x52adb387,0xfcfd3ff3,0x6edf7919,0x9a59e831,0x15b9444b,
	0x1e053fe5,0xaef5be11,0x6cc779dd,0x7ec703ed,0xefb795fd,0x5425bd1f,0xf4bd5fa3,0x2d914c41,
	0xb9a16c93,0xdc5f0579,0x6997445f,0x2e7bd11d,0xd539584d,0xa6b922db,0x2d1df3bb,0x4b91ad63,
	0x86d9cd13,0x9471ba8b,0x74835f27,0xfd818ffd,0x76c5b31b,0x49edc857,0x915dc2d7,0xfca908dd,
	0xca2b1be1,0x0fbbfb95,0xdaafeacd,0x7207f5f9,0xdc1d1725,0x5393341f,0x35df97cf,0xc84b1057,
	0x969ba7f5,0xc9511f5d,0x3fbd046d,0x1cc198fb,0x6b85d9a3,0x2bfdf53b,0x158389fd,0x506925fb,
	0xedabf4cb,0x9ec3552d,0xbdd165a1,0xb8e18f6d,0x09bdd44f,0xadfb4333,0x31ad9d3d,0x7175fc75,
	0xdf5b5a5b,0xf02544d1,0x05890483,0x4c191039,0x3a090563,0x46e39e15,0xb23f61e7,0x626336ed,
	0xaa31a521,0xc007ae93,0x7e0bb3ab,0x469912c9,0x3e292f97,0x16856e69,0x059994d5,0xd4a3090f,
	0xdb2bb615,0xd37d0b3d,0x64f7c235,0xa315ef07,0x365f7a29,0x0f33a53b,0x009dbf61,0x1427d703,
	0x6dcd22b3,0xd2172c17,0xee6f9bbb,0x06bdfd5d,0x416d10d1,0x15bd5c11,0xfeb1d767,0x2761d573,
	0xec19d4f3,0x65e7daed,0x65136857,0xe14536b3,0x9c97c3c9,0x217974f7,0x01b1df3f,0xef45a98b,
	0x8e91ab51,0x5b817a07,0x4a09aca1,0x8cdfd475,0xc39da7cb,0x5c353a79,0xd20585c3,0x474108f3,
	0x5c3718c5,0xc1f5a431,0x74f1e9b5,0x6e3df08f,0x90c3b611,0x4247ff9f,0x1e8bc64f,0x254b59d7,
	0x4a8bc4cb,0x0ad7ccb5,0x33ef3d2d,0x148f2567,0x5cc76c55,0xc27dbff3,0x9ca588b9,0xb9d352df,
	0x5d932b5b,0x2a37df5b,0x6ba10123,0x598b2de9,0x1eef6cd1,0x5e2dbf7f,0x2837415f,0x8fcd9b35,
	0xc7cd3cf1,0xb6a9e06f,0xb72b6c2f,0x815d857f,0x8cfd1e3f,0x49252acd,0xe3a3911b,0xaca76a85,
	0x0a3dfe85,0x093d8cbb,0x882f316f,0x5abd0813,0x3b314bd9,0x89b9b6e7,0x57c9e543,0xb05728f7,
	0x14652993,0x5d87f987,0x46d12079,0x5ed9920d,0xbc4dc559,0x18bd4159,0x940d17b5,0xf54d0f37,
	0x6445cc13,0xf197349f,0x71afc567,0xd165a05b,0xc193fef9,0x017f7029,0x4e4f0ec9,0xb07bc66d,
	0x2663e881,0x2601e44d,0xbdef08d7,0xe091f063,0x3ac7b173,0x81d351e5,0x02f35d59,0x11530843,
	0x55bd15d7,0x9dd5e759,0x372fcfdf,0xc5132013,0x76297a01,0x2a0bfd95,0x14dbe2c1,0x61c93ee5,

// 4 * 16384

	0xdbd71f8d,0x5ea5f50f,0x5f959c1b,0xe2194dd1,0x407b7a5d,0xfcf932c3,0xed676ad9,0x264b24fb,
	0xb0b3a59d,0xf0853d37,0x4fc12ba5,0xe555b889,0x0501f8c1,0x8feff979,0x1c7b4dfb,0x3dcf65af,
	0xfad3bc83,0x7e07081d,0xd6d51917,0xe6fd5fa5,0xed7bffe7,0x2abf4243,0x78771101,0x01c73cad,
	0x2f378d39,0xf439568b,0x9a737b89,0x89bfa30f,0x022bff09,0xe7bb8627,0x3e3f0547,0x6621161d,
	0x3165f537,0x22b381cb,0x36bd8697,0x1acfe331,0x49d569e1,0xd3b566b3,0x3133e8a5,0x19512eab,
	0x735b2677,0xdb81dba5,0x5e552a5b,0xb1dd20f5,0xe9b958a9,0x0dff4ded,0xbb378575,0xa44b337f,
	0x159d4775,0x133b4e63,0xfa5db36f,0x511d9dc5,0x459b281d,0xe86b0e63,0x0cad5291,0x8a7fe245,
	0x072d132b,0x00edfcd3,0x4a776aed,0x05417b89,0x1fb91973,0x0749831d,0x3c751355,0x69dfa925,
	0x258d7911,0x3e2de23b,0x04c7366d,0x057b5caf,0xb8d9f267,0x816f2fa5,0x67f37799,0x1adf46c9,
	0x5cbd3d21,0xe70d7265,0x75eb380b,0xd37b041d,0xf03d9d33,0x002de007,0xd307bbb7,0xd06d6a5b,
	0xc74397d7,0xba1d399d,0xa1096e5f,0x5b75f53f,0x63a3c891,0xdf5348c9,0x0815488b,0x37ff5387,
	0xce1dd62d,0x386f7cad,0x5fbf5487,0x141b13ff,0x8f5187bd,0x4d37a6f9,0xf7ff536d,0x99857277,
	0x48cff99b,0xc597d8df,0x82338219,0x1e9d44c7,0xee09f26d,0x6aa7601d,0x1a257e37,0xf77107d3,
	0x9d5b581d,0xc7a7e3fb,0xef054b31,0x66af0c81,0x1909c4dd,0x6af9a243,0x8c697743,0x2eb5c4c5,
	0xe0413c2b,0xc72dcc4d,0xc3556069,0xc2833097,0xe817ffc7,0xb3fb03f3,0x3331996b,0x16c56af7,
	0xf48784bf,0x8f41f89d,0x72c96edb,0x12cb56f1,0x91758867,0xfe032437,0xd9598c0b,0xa1916c95,
	0xabab4557,0x4d6fa837,0xe781c01f,0x62b7a5fd,0xc9e1c873,0x73df4a9b,0x5049e2fb,0xfb8b8c49,
	0xe5b365e7,0xb1cf92e5,0xa21fda51,0x07fb64a1,0xe4a14e27,0xd2e30725,0x8fdfbe97,0xaba57d39,
	0xb11d42ef,0x0eed88f1,0xd9c5200b,0xc2c99a4b,0xf3776c3f,0x8ae1d263,0xd67d6bb5,0xb3518315,
	0x6aeb4d63,0x79df1323,0x9c177067,0xddd1aee1,0xe6a1d9f1,0xde2dad5b,0xc90703b3,0xae831201,
	0xdea3aac1,0xea3712c5,0xed33c6fd,0x4e470acf,0xace552f9,0x0195c19b,0x92df0c69,0xf3a96eab,
	0x6645d503,0x5a0561a3,0xe7bddbe9,0xd3ddb6ff,0x53833793,0x3c6d012b,0x05e51833,0xb3b94e3b,
	0x0a513aa3,0xe5db7207,0xdcd9c3c5,0x18c3fcdb,0x263f2c75,0x0887c695,0xba7d65e9,0x1a25765d,
	0xa1cbde97,0xeccdeebb,0x74258fab,0xd1ad064d,0xcf59badd,0x323574e5,0x2f8980e3,0x6cdb5d39,
	0xf235f85f,0x306b5b07,0xcbc7ed33,0xddcd7dbd,0x7793f081,0xf84917a1,0xea69e101,0x2c51c97b,
	0xcf9193ef,0xf4c9b2b7,0x985fc679,0x66d52e19,0xe631ff9d,0x2c1502d7,0x96ff8a97,0x33757249,
	0x3c5f31c7,0x20790a15,0x450de217,0x00f5a2c7,0xa0f3deed,0x516b730d,0x27afae83,0xd7bd9f53,
	0x89a566dd,0x5c892de9,0x13778327,0xcae1c7b5,0x0c1be9a7,0xbe9b2d51,0xf55b4a1d,0x091bc8bd,
	0x76e17cab,0x348f437f,0x3bbd0943,0x8dcb8949,0x8a6d7f89,0xbc7b1f2b,0xdf65c73f,0x71fd3735,
	0x5217112d,0x369d689f,0x0c819083,0xdd63746f,0x9d29a4c9,0xa65bfea5,0x6bab9c45,0x9759a3e5,
	0x17c9b6db,0x13435395,0x0ae59183,0x37dd5691,0x0411a225,0x0a0dea4b,0xe695ec07,0xf89dd875,
	0x92f994b1,0xbd95f32b,0x128b815d,0x25ebdd99,0xdd67a4d3,0xc7e10923,0x830125df,0x2fbf4f0f,
	0x7d290629,0x8b230ea9,0x759571a9,0x5abf37f1,0xc5ef5e91,0x32ad2abb,0x7a53a5a7,0x1131d25d,
	0x9e593b3b,0x53ffe5db,0x1ca7b085,0xd409b481,0xf8e9a597,0x2fbf6719,0x2c6b53bb,0xcbe11d8b,
	0xed0dd861,0x92bdd10b,0xa6df6887,0xf9fd62b7,0x7019149d,0x56edbecb,0x3fad44f3,0x09457c43,
	0xae479697,0x846de101,0x89e340cb,0xbf4bb279,0x03bfaae1,0x1285bad9,0xc0f95aa9,0x0d4b6aad,
	0x9589e355,0x48a37f09,0x31d1fceb,0xc1291435,0x8a9d6c19,0xbf5d0ccd,0x43b3e2b7,0xd66b3573,
	0xe4d58097,0x016f0ceb,0x214f1cff,0x674598d1,0xf9f70083,0xccc32eb1,0x01bb3779,0x3d9199bf,
	0x8cad24d7,0xf36584f5,0x117b7da3,0x03d191b9,0x858d54d7,0xdc8b0311,0xfb775fc7,0x1631653d,
	0x4c111b0d,0xa59519eb,0x11fbf7f1,0xf38330d7,0xbfa13a4d,0xe30774f3,0x17c3aefb,0x4e3f1617,
	0xd085e2b5,0x0193d71d,0xa8ef0183,0xbd892895,0xb8f506a3,0x470b17e5,0x440764ef,0x0e2b7af3,
	0xd60bcfc7,0x736f4051,0xf2f94c71,0x33974bdd,0x20cd3411,0x01e5c7ef,0x941f4dff,0xd8e752ff,
	0x4725aabd,0x09bbf1d3,0xc33b6757,0x91dd2e17,0x64e9014f,0xbf69499b,0x62736303,0xabe5ede5,
	0x5cd55093,0x958b406b,0xc3575d4f,0x9f0fc331,0xd18d119b,0xfde9e9f3,0x6fe16955,0x1f17cbcd,
	0xbe9d52c3,0xca6fd965,0x936f55f3,0xcc5fff91,0xb1790cad,0x2e371e81,0x03cb92d1,0x84f13d61,
	0xa27d9745,0x5e7b628b,0xea25355d,0x557f7825,0x6def3ebf,0xd3a5254f,0x0c151dcf,0x0a6303cd,
	0xecf9f895,0x2a411a25,0xb49d3c25,0x609f0253,0xaeb1388b,0xa405a4e9,0x3d21f529,0xd6dff0b9,
	0x5113e5ab,0x48cf76ff,0x3675a767,0x1e735407,0x7a036f49,0xa7a94c55,0x31d15039,0x2c57864f,
	0x704d0203,0x37bdc863,0x29d350bd,0xea2da3ab,0x54a5dcb7,0x59617321,0x8b8352db,0x873f973b,
	0xfaa9c595,0xf717d619,0xdf554e41,0x697d4829,0x61db9f0d,0xc683b955,0x121fad67,0xbe85e6a5,
	0xcea71cdb,0x2973806d,0x5e21928b,0xac9958eb,0x83659905,0xaedfa77b,0xd4033cb7,0x239fc839,
	0x194d08d3,0x33e36027,0x83d58cb7,0x4e2d4ddb,0x798511d9,0xa4c74e9d,0x4613aa25,0xa27dc01f,
	0x76193ef1,0x5df76693,0x2497c85f,0x93719f61,0x02fd5543,0x2d0be847,0x63af0b8d,0xe1932303,
	0x0f0fc935,0xf1c37d7b,0x2b078d9d,0x8c13666b,0xfd11537b,0xdf01767f,0xceb98347,0x61cfb60b,
	0xbcb1a613,0x5bd52729,0xb8478109,0x3247fc5f,0x8381413f,0x847763d3,0xef97e02d,0x9ea74ee7,
	0x25ff688b,0x4b451e65,0x43f943bf,0x8abf9b29,0x108f37c7,0x39c3234b,0x15273d99,0x2e0b73bb,
	0xe07fd813,0xd1a1f679,0xbc3f1359,0xc4abfd35,0x9cffd4cd,0x8db3d071,0x94cba367,0xe06dfb35,
	0x902f90a5,0x82fbbb33,0xa5bb69f1,0x59bffd69,0xc011da8b,0xa19dcf4f,0xea67a5ef,0xe0bfac7f,
	0x0793a2bd,0x95e790d9,0x3b919e21,0x2e2d3731,0xcf89cfbb,0x494f6c6f,0xd85d060b,0xd475df3f,
	0x67ad3353,0x03755435,0x8f5f8301,0xb0a7a675,0xffa59f97,0x2b1d7cdb,0x878d5117,0xfb7d1ba3,
	0x3fff1be3,0xa7393a95,0xa949082d,0xfa5d47a3,0x832d39d9,0xdfdbfe1f,0xa75b80eb,0x504dba55,
	0xae8b8a65,0x5f4371bf,0xa7f3d9bf,0xef03b7a3,0xab5d32bb,0x12d7b641,0x8da99be1,0xa7d5847d,
	0x7fd1a155,0x2c25bffd,0xe07b004f,0x5cc9d3dd,0x07fb62f7,0xa1e5d3cf,0x56d554d3,0xd18953c5,
	0x4ed517ad,0x50f3241b,0xfe8780f9,0x1c635a3f,0x874787c7,0xbd578dd1,0x05c7ab1b,0xb757b259,
	0xa519d8e3,0x733f7563,0x2437fd59,0x3103892f,0x9603e2e5,0x07ffc3d1,0xa3dd8a95,0x7db57ae1,
	0x1a9fa4f7,0xbb19039f,0x0a2d5383,0xe85bbf99,0x3f73da8b,0xb72f9dd9,0x60fb6b99,0xa3937889,
	0x75e9b05f,0xf3133717,0x1f893e17,0xfa9d1ce7,0x4d579973,0xb2b92c73,0xb381f303,0x226306f7,
	0xcbf94415,0xa8413097,0xa9f1f42b,0xaa792103,0x67f1aed7,0xb4ef08ab,0x78539229,0x8e17b25b,
	0xa04f5d95,0x4a336967,0xe585c95d,0xe5214c57,0x3605ae73,0x6aa3f409,0x12d326e9,0x3523d759,
	0x04ef4ed9,0x4afd5353,0x24e9cdc1,0x624bbfcd,0x7cd3d07d,0x93277895,0x8ce19b9d,0x4075431f,
	0xba5b5e59,0x3f2ff8a5,0xf13b6df7,0xc425dccd,0x401d91b1,0x204d88dd,0xb6df871b,0xd383d357,
	0x4f95670f,0xfddd9c25,0x2a1f1317,0xb763e545,0xe2275349,0x56651fe9,0x47b1ccc1,0x2c3d1629,
	0x421f7877,0xc097591f,0x25b7c2b9,0x13379b9b,0x43b1faff,0xec45e143,0xfcb93c67,0xc317ea3f,
	0x1dfb768b,0x436fc35d,0xd0a7bef9,0xf951e2bd,0xe3ff930d,0x2b3db8f7,0xb9d73267,0x6aff1ec5,
	0x9da9b9c3,0xe4f98727,0xce0d2671,0xf5e55e11,0x00cfea2f,0x0f1d7b8b,0xa96f379b,0x716b1363,
	0xca2daf1b,0xc6470949,0x978f9439,0x1fa51183,0xb667339b,0x663b860d,0x5c63a15f,0xbe4b5843,
	0x1b09780b,0xeae9070b,0x9d4bbfed,0x37c1017d,0x1f89a70d,0xf1655e03,0xea13318b,0xf4114e11,
	0x963f8a8d,0x58f1363b,0x65e71da7,0xc9edd2e9,0x757320bf,0x83f1517b,0x1063b679,0x8fb1c5f5,
	0xf051511f,0x38f3e51d,0xae837e01,0x4c5b6b2f,0x2febc16d,0x23ad16fd,0x53b3ab05,0x0899a19b,
	0xac3fcab5,0xf5ff9a81,0x8ac1ae15,0x3fbd903d,0x25338e4d,0x28ef6d93,0x1ee7d687,0xf0bf7329,
	0x3b8f2acd,0x5da9b5ad,0x84c3177b,0x4f43887b,0xaa09111b,0x5e85bcc9,0xe35fecd9,0x14931d4f,
	0x1e3f7961,0xc0010e6d,0xbd2b604f,0x70a1bad1,0xb1b3f813,0x21c3b4a5,0x38ff2e55,0x9b077333,
	0x02d332e9,0x0f9b9509,0x0b1b0b2b,0x04074eab,0xedf1b5eb,0x827bedb5,0xfe2707d7,0x258dd87f,
	0xe64de861,0x0187f24d,0x1c351729,0xf42bcbf3,0xef0721df,0x630188ff,0x77bdb2b7,0xf019e15d,
	0x342ddf41,0x2d572783,0x949d9fe1,0xd63bbb15,0x43b517ab,0x9823d011,0x711dd4cf,0xf11bf279,
	0xe679b185,0x2d1f2e73,0x2ef17d6f,0x09eb44f7,0x993d1785,0x0935d4f3,0x5c2f2079,0xf985e0fb,
	0xa5afeda5,0xbd719969,0xdc55e46d,0xd96bd303,0xdb63e629,0xd009122f,0x714ff491,0xd4c9928f,
	0xe8d3b69d,0xdd5d332d,0xe46d05f5,0x996faf27,0x54672cd3,0x58f10ad1,0xcf65fc6f,0x68d99d5d,
	0x156763e5,0xee759f0d,0x0557af9f,0xc929a3cb,0xcd0b1939,0x82bfea5f,0x9bcfcfed,0xd629e811,
	0x9f6d2179,0xd4cdf8cf,0x93b9eb89,0x324b9bd7,0xac93fd99,0xbec524e7,0x226f9367,0x97a949d3,
	0x29678fd3,0x16f574bd,0x9ab3a049,0x090542b9,0x18bff0a9,0x30d516ef,0xf5ab97b5,0xa2cb2a4d,
	0xa45563e9,0xfe01ffa3,0xfbe730f9,0x0c0ba457,0x15d16da7,0xcf3fa585,0x0e5ffa31,0x878121ab,
	0x6fbd073b,0xb581decb,0x8f771d37,0xa48fcd1d,0xa68df449,0x82d9de31,0xebf344b5,0x903d9895,
	0x799d37bf,0x6b874ffd,0x4405a119,0x064169f7,0xec31a8cd,0x46f396fd,0xb4450d9b,0xe1f36835,
	0x5e79a7ef,0x70a92985,0x3eb3553b,0x4f55684b,0x4685f3e9,0x495f0e75,0x53b797bf,0x9c137a37,
	0x89519ec7,0x57f37a2d,0xfb23ceb7,0xa87d9603,0x73c522db,0x0a6d8b9f,0x9d2d7279,0xf88f68c3,
	0x53ab97bf,0x16fb293d,0x6b773f27,0x64e9418d,0xb0b70759,0x7cf3fe07,0x6a0919a5,0x6bd91e85,
	0x2587e2d3,0x25d19681,0x185114a3,0x224fd9d1,0xd89b97a1,0x263f9db9,0xba2b9599,0xc4e376a5,
	0x9565447d,0x9f093a43,0x40d599c7,0xe8db8e37,0x85358e6b,0x3e278b3d,0xd3f71b33,0x4d21dccd,
	0x884995b5,0x5fb5454b,0xfaa195ad,0x4b45eead,0x2ec50aef,0xcef96f9d,0x644dabcb,0xe883ed29,
	0x51b563f5,0x276340e5,0x51dbebef,0x86bb8b99,0x4c0d30eb,0xd58b1c63,0x9e91b53d,0x357b1461,
	0xd3ab9139,0xb82baedb,0x69213ca5,0xa2f195e9,0x7251c895,0x612b2b99,0x5ca5b1df,0xacfb2fa1,
	0x9eabf3fb,0xf699a975,0x9999846b,0x92197f03,0x754fdeab,0xb3ad9fcb,0x3ee9c88f,0xc2752c8f,
	0x11bbf733,0x09c5837f,0x92e3bc5b,0x50e398d3,0x874f6465,0x616383ff,0xcc3f6ca5,0x03dda95b,
	0x7a593a5b,0x7b3b6841,0x7b217a0f,0x0685b5c3,0x590dcf7b,0x71218bc3,0x920dfdfd,0x39a394ab,
	0x3489316f,0x5711fb87,0x0ef58f9f,0x24abc8bb,0x39cfba2b,0x7c35b31f,0x442f68ef,0x86b9cda9,
	0xcacdc4e9,0x4bd9f99b,0xc181aba9,0x878d8529,0x3755832d,0xce73de9d,0xdd0dc655,0x8891c3ff,
	0x1625f1c1,0xcaa3d747,0xdc67f943,0x95d9fef5,0x3de3edbb,0x862d7b47,0xbd85fb89,0x771f17d9,
	0x5e176973,0x270161d3,0x9fc9c007,0x60c34a87,0x3839c18d,0xb4351ea7,0xccf95a65,0x44d139df,
	0x78a131f7,0xb7075f09,0x62490413,0xc3fd1ccb,0x2f996ae1,0x7bdd26c7,0x994f4145,0xbe9d0b3d,
	0xea4945c9,0xf3452d37,0xb10925fd,0x85b76b2d,0x6bc59a6f,0x32f75a33,0x76e3bb01,0xabf37d9b,
	0x060d33e1,0x96cf6323,0x6fad82e1,0x76a50b93,0x9301e571,0x81d587f1,0xa09d1ef5,0xeec53325,
	0x0d6fbfb9,0xbf357017,0xf8531459,0x91f95469,0xca0d659f,0x8349278f,0x57dbb0f7,0xa3871e81,
	0x5075814f,0x0c8b3bdf,0x3ba1107f,0x1d63bc99,0xd42d5937,0xe4a3f915,0x047f4165,0x412922df,
	0x4d9f8517,0xc161c6c5,0xe0b589eb,0xc9177b8d,0x331fc2f1,0x05b9a50d,0x54edcd17,0xb91bb3e3,
	0xd1edec0f,0xe2cbc993,0x65350fb9,0xcfc7292d,0x472b0a07,0x18db5c81,0x5e071d69,0x975575bb,
	0x18e38bb1,0x58595591,0x3d414d83,0x16a55de7,0x6f0d9a33,0x42d978fd,0xbb2d6831,0x2243dd11,
	0xec838df5,0x0c1d748b,0xf37bab63,0x4d6152a1,0x280b83af,0xbb091c87,0xae43efcd,0x7ad9cf0d,
	0xc54f1157,0x0aabc8c9,0x4905edf1,0x0e2f80c9,0x2de51b35,0xeb39d1ad,0x3fa9a315,0xbc8b4159,
	0xea49c8d1,0xa3132d17,0x5581d649,0xfdc14245,0x9add99ff,0x8fbf2b77,0x5e43bd65,0x1d49da1f,
	0x90f19bd9,0x86e954bf,0xa711c205,0xeb477181,0x07b7bdc5,0xd769656f,0xff716695,0x0d85900b,
	0xfd4b466f,0xea3f6b89,0x62574b3f,0xf0750967,0xabb368c5,0x838d039f,0x3f1952ff,0x58314a47,
	0xa1dbf907,0xa3a3b5c1,0x6275e891,0x917dc561,0x7c9541b7,0x07f97291,0x7f97637d,0x42c18079,
	0x3f9ff8a1,0x4c2b3031,0x590f8d13,0xdd0fc159,0x4e9b53d5,0xab01a74f,0x89d14569,0xad23dad1,
	0x06193eb3,0x5f693021,0xee434861,0x8c5f19b9,0xf48baed9,0xa579bf65,0xad29129f,0x31cdd1f3,
	0xb34f1937,0x5b6d035d,0xe0b5e695,0x231f8b69,0x5fa706fd,0x42afa0d9,0xdf81f177,0x45af4f0d,
	0xb3bfcaa9,0xe0cb902f,0x25899047,0x0f8113d7,0xbfaf54fb,0x00779a39,0xdd39b4cb,0x583d4bc7,
	0x426f2a01,0xd293f55f,0x085f6a95,0xca3590e9,0xa2e5760d,0xaf23028d,0x49337bf7,0xf365724d,
	0x88dd42bb,0x76572a39,0x4b573715,0xf66f610d,0x160bcbef,0x9185d95f,0xccd352d3,0xdb9dbd47,
	0xbf0df4d1,0x942b9e85,0x4717f3e1,0x81e10329,0xc465dcd7,0x7cef66b9,0x37fbd1b9,0x2fd517e1,
	0x4b7f94bb,0x96a1da8f,0x0abf7b97,0xc4bbb6a9,0x17b3f381,0xf933db25,0xa10bbd83,0x897ffdc3,
	0xe3398b73,0xaac71f21,0x7bf1254d,0xa1b11b77,0x5837bf27,0x60a3efaf,0x84e7a78d,0x1c8d1b17,
	0xa9bbf675,0xe0350583,0x76cf64a1,0xa5f5d1fd,0xccb5f383,0x001185dd,0xe6f18daf,0xd773ec89,
	0x510547bb,0x48f71f83,0xedfb69a9,0x29391b23,0xda6de8cf,0x36cf47bd,0x71097a43,0x83215f41,
	0x399be5bd,0x19a59765,0x0a97c0ff,0x6dad7857,0x25213bc5,0x96af47d7,0x93912425,0xe30970e9,
	0x927fcb75,0xc94bcff9,0x4c47f3c1,0xc0054b81,0xaf156d9f,0x0401a135,0xa56d8eab,0xd51dcfad,
	0x7931285f,0x317f0485,0xa9292785,0x97717709,0xf9098419,0xd59b1761,0x03ffa9b3,0x71cf7a35,
	0x19b70075,0xae53e8d3,0xade1be67,0xb5a7fddb,0x223fa969,0xf4cdb667,0x3329f195,0x2c135fad,
	0xce8fcc2f,0x3e57492f,0x9d93f701,0x46d5a361,0x087bcc4b,0xfd6772cd,0xfd490f2d,0xf157ffbd,
	0x40bf1889,0xa29daa63,0x91dd8c6b,0x01ad8b85,0x67fd3ff9,0x5dbfc9a1,0x934777d3,0x49910a8f,
	0x87c526fb,0x7eb9e9b9,0x9ae55641,0x4765dab1,0xfb875c2d,0x76a36069,0xac810d61,0x773100cf,
	0x49a58d7f,0x78bddcf9,0xdf4be89d,0x43ab55cf,0x9c5d1d23,0xbb69a533,0xa6dbbe31,0x972bd3a5,
	0xdadfd691,0x5937f26f,0xbc313419,0x0cb30249,0x623fc391,0xd1df6e87,0xa6b5251f,0xc0ed84bd,
	0x5e79212b,0x2b3fd0e3,0xe53925cf,0xc32dc609,0xc36f74b3,0xb25b9b6f,0xb6f32981,0x266dc63f,
	0xe5f1c0c5,0x5c61f7a1,0x84854757,0xb24f0777,0xb4b1da45,0xc7abb377,0xe8f59f37,0x341b9ad5,
	0x914bdd5b,0xdcb55e73,0x5ab75ecd,0x6fc74d81,0xc945c27d,0x0f2386a5,0x749fe695,0xb0e9f5ab,
	0xaf091365,0x3ec715a1,0xdef10ecb,0xfbc7df8d,0x52edc017,0x3897cd87,0xd8538c79,0xde4b5a69,
	0xdc2d13df,0xd7ade5f7,0x5ed5766b,0xe1056587,0x81edca4f,0xc655c923,0xf8f1ea39,0x982f7d39,
	0x24394441,0xdef9f0bf,0x1e85d145,0x54af87d9,0x8505dcdb,0x2d31e307,0x41dbc5b5,0x750be2c7,
	0x212d5e87,0x8ebb4fc1,0x78a51775,0x56778f6d,0xa97797f7,0xf47d4d3b,0xc4f7f141,0xe5cf803d,
	0x1b8f1129,0x4385b549,0xfe539d95,0xd09305ad,0x7b07e05f,0xd60ba249,0x5aa3ebbb,0x55ed5b41,
	0x2a5d9f23,0x9c6b0c21,0x9735b4bf,0xb7b15483,0xe3f57f49,0xde2d853d,0xc1c1807b,0x4b592a01,
	0x531b7fed,0x9afd1791,0xa1694a8b,0x2b056659,0x4d03c273,0x8bb5419d,0xbfb5675b,0x8681f327,
	0xa9cbff83,0xc34f1365,0x11958917,0x943f4617,0xbd751c13,0xeff56b77,0x4061e4b5,0x225baddb,
	0x70edde5d,0x3bf353e5,0x92d976f9,0xc795bf2b,0xfb0bc2e7,0xcebf7f51,0x76256965,0xb457e1c7,
	0x3987f177,0xedf7e5df,0xa6d5974b,0x23b5fd7b,0xaa075225,0xbe638239,0xf9e532c3,0x6c674717,
	0x0317c24b,0xa4f12e97,0xc5af89ab,0xb1d12d73,0x6d2b698b,0x47b7a1b7,0xeb01eaa9,0x34ff6673,
	0x5ba12ecf,0x2ef38bdd,0x7e07aa2f,0x459f1bfd,0x05bb4d4f,0x060bd3d5,0x0f5d4773,0xd30d3905,
	0x7fa70983,0x7c8df3f7,0x94ffb173,0x9d4dd683,0x7379862f,0xc731771d,0xf359abf9,0x0607c879,
	0x7a2bb95d,0xc0d395b1,0x26395491,0x818f4aef,0x14a38161,0xab79f29b,0x09d9c795,0xa7ddcef7,
	0x44add9d7,0x91557853,0xc3d9e523,0xe595e7ab,0xc5ff30a3,0x45b955d5,0xcc3f3621,0xcd01572b,
	0xe733daed,0x06251ba9,0x967df141,0x07133ba1,0x02cdaa2b,0xbb3ff8d9,0xda6b1ff9,0xe4675c3d,
	0x983ba119,0xd9d717fd,0x7d49e387,0x8e3b9639,0x04d1c8b7,0xe3e11c2f,0x1ac1d9f5,0xd77d69d7,
	0xdcc92553,0x897bbe17,0x2de1a30f,0xadbfa761,0xe44bcb7d,0x69ed88e1,0xda21856f,0x2a393c25,
	0xa85f1515,0x74a5b743,0x54633373,0x42cf1f7f,0xb7fdf63b,0xea393079,0xebefb041,0x1b0b5fcf,
	0x7cff725b,0xfd65a549,0xb37554cb,0xf51f4f7f,0xb5293129,0x1413cd01,0xca0df4c7,0xc2e5d201,
	0x8b2b339f,0xa84fc275,0x443723b3,0x56e1c8cb,0x4f93a8ff,0xc94f8105,0xb4db99d9,0x353ba063,
	0xd1e3e3d9,0x3c738191,0x5649b945,0x04c5fd4d,0x597d6efb,0x3e3f778b,0xd33d32d1,0x9ffb891f,
	0x3eab4283,0xe3652de7,0xafd1cb1b,0xc5ffdf6f,0x23a518d5,0x19b78421,0x52933f89,0x6b9b9ae1,
	0xcd85e399,0x49358b3f,0xad6f4b4d,0xac41821b,0x9d5160c5,0x9505c2cf,0x86c1cc5d,0x5b0bd4d1,
	0xa8f3cf95,0xbc7575e5,0x62450879,0x33bdb8bb,0x7441c589,0x9bfd381f,0x0a271225,0xabbdc699,
	0x49f7236f,0x4e3982a1,0xb7f54db5,0x6323b737,0x34b92a59,0xecf1711b,0xdda9163d,0x35a53065,
	0x9811b0a3,0xf2139ebf,0x8ea1829b,0xeba7b1fd,0x697776ef,0x38b3234d,0x88a94a7b,0x8b33a2df,
	0x09479d29,0x9e11b009,0xdcedcb49,0x48f97df3,0xbbc33783,0x4295ccbf,0x39072d3d,0x19571f2d,
	0xc217037b,0x6acb34c7,0xcff7a855,0xe14f3085,0x13593cd3,0x006953fd,0xe325e95b,0x4787b6fd,
	0xb5859297,0xb34de3c5,0xeb6396db,0x2557bf9f,0xb67f3c17,0xba81a80d,0x61e9f62f,0x97b52c79,
	0xc5132df1,0x352f4c4d,0x2955b075,0xb045a1a7,0x69f56f09,0x2baf607d,0x96b1b795,0xc64f9249,
	0xe0c38d87,0x307d7627,0x1a6b4b3d,0x67c96d89,0x90fd33e3,0xa1435d55,0x895f1de5,0xea4beb97,
	0x2715ddd3,0x87cd819f,0x05cb99cb,0x9c177aad,0x4d5bad5d,0x1b13671f,0x885745f9,0x9519cc0f,
	0x050d5fcd,0xe031477d,0x09154b3b,0x27e18101,0x9f4f62b5,0x6b6fcee5,0x487b192b,0xf2abf7d9,
	0x562f08f1,0xc139f90d,0x386b2b27,0x905938ed,0x859ddfa3,0x57270e33,0x052bed57,0xe973039f,
	0x84792337,0xb4f9c019,0xbe6dc1a9,0x252ffb59,0x1d855461,0xb591670f,0xa04b24d5,0x3a65f48d,
	0xa86ded1b,0x68015eeb,0xfc41f359,0x209761b3,0xc2c935a9,0x907b8407,0xc23bce7f,0xa0efe04b,
	0xa9113995,0xc963d04b,0xa987a153,0xc741e5e1,0x2fabdcb5,0x443b1823,0xf9df45af,0xf3078d05,
	0x5be51021,0x2ab3e783,0xf4614931,0x8863824f,0x9cef273f,0x9f9f7eed,0xdc99d241,0x411d1163,
	0xa4e94cb7,0x6001f061,0xa173a50d,0x1dab51e7,0xe1d51781,0x03fd5c6f,0x2649488d,0xf625748f,
	0x96a13fd3,0xdfe14f2b,0x2bdb4b81,0xab4d3013,0x94217435,0x85233d33,0xd951a96d,0xf78d4e35,
	0x920f4e6f,0xe36320ab,0xe53d4fa5,0xdff958bd,0x28116895,0x09653643,0x5e97c23d,0xc54b667d,
	0x66b59203,0x861bda2f,0x15bde115,0x14e3084d,0x106b245b,0x6997852b,0xa577ccd5,0x99cf5611,
	0x72937889,0xe619e97d,0x1bf9ebeb,0x6dbd1bb1,0xde717bc1,0x91072ff1,0x43d90f8f,0x8a0b261d,
	0xc22f647d,0x43ef54df,0x8d17b8bf,0xf8b9b051,0x61e38781,0x9d89a523,0x961b7d45,0xa571f04b,
	0x30874cd7,0x22b15b21,0x54b58caf,0xce87c415,0xc90344d5,0xff6f5bc9,0xdf1f5553,0x15f57ec1,
	0x871f5d13,0x67f1138d,0xd4f94951,0x325bd569,0xc0933577,0x998b736d,0x6849c38f,0x4005ec2d,
	0x9df9952b,0x7bbf0ded,0x06830cc1,0xb1e78337,0x93d7ffa1,0xe12f5419,0xa17b8059,0xe29743b9,
	0x7b976997,0x68adf289,0x9875d197,0x455b2ceb,0x4c8f0e0d,0xfe2d4e57,0x41157085,0x371b210d,
	0x74f96351,0xfbcf222d,0x10710ef1,0x6f6b9269,0xd2fd2ff5,0xead73b33,0x63fb4571,0x11855053,
	0x4da5bfd5,0xe4b55621,0xea995865,0x5d497421,0x0de53913,0x93ff1c33,0xad8f1cf3,0x00436e37,
	0x5799111d,0xd5734031,0xb98ffe0f,0x06a532fb,0x0287a1a1,0xf8f7bb65,0x67b1216b,0x6c4b87e1,
	0x9359dda1,0xa2992aa7,0x4675ac87,0x4db57061,0xf4a5265b,0x4b914b51,0xa2c329ad,0xb90dbafb,
	0xcfe7405b,0x633b984b,0xb0ed0ceb,0x1f27ae3b,0x86836877,0x101d0701,0x55ab5917,0x647bd5b1,
	0xcac588c7,0x90e9e469,0x8f1b64d1,0x922deef7,0xd8e18db1,0x3d71d1ff,0x7dc5bf81,0x2707f6ab,
	0x4ff3dadf,0x27b5e2cb,0x0d9d3655,0x087b557b,0xab01e043,0x5cddd857,0x3ef9f945,0x13a52d15,
	0x59f7cf1b,0xc6337fb9,0x0f99e011,0x4e45c533,0x7aa76ee7,0xaa312e8f,0x03a5cf3f,0xb7c51897,
	0x31cf1275,0xcd755fff,0x4ead3d1d,0xba378209,0xa413acd9,0x33c371b5,0x9cabd6c5,0x3b59895b,
	0x8eff0669,0x810b80e5,0x7aff4515,0x4d89d067,0x820711cf,0xfa61674f,0x616f11b5,0x80d3200d,
	0xb78960f1,0x2707d837,0x5b2dac13,0xd3e99537,0x8dc7ba05,0x11619d6b,0x4fd38e69,0x4525edd5,
	0x9fefcc85,0x27fdf43f,0xec5d82b1,0x038bf5e3,0x7f130635,0xbe910a91,0x2c3707b7,0x3fc3145f,
	0x0b318821,0x2efd9bc7,0x822fd609,0x9d1ff853,0x6c2d3b9b,0x9a47adcb,0xa17f84fd,0x429b65d3,
	0xaad5073d,0x499b6e17,0xe6c54fb3,0x8bd922f5,0xe9d923ed,0xaf512ea5,0x610bfa13,0x5a2304db,
	0x3ed991d5,0x07e782fb,0x7ac1d5cb,0x056b1caf,0x2b57ad67,0x9b037d25,0x42bfe753,0xed4d04a3,
	0xb5c1e461,0x9c750abb,0x55452aeb,0xaa074cef,0x22698ac5,0xad3171d9,0x64fdf999,0xdd8708d3,
	0x4c8fcfdd,0xfc55ee23,0x63f58e2d,0xa45d7b9b,0x9f53d33d,0x08296dc7,0x4ca5aa3d,0xa6c5e597,
	0xaec3d9c1,0xff196e7d,0x8aef5b29,0xc9a1711f,0x70d5a28b,0xc0bffa7d,0x051bdf19,0x7f7b3f97,
	0x1663dc09,0x7ed5c591,0xc4d7a9fb,0xb9859665,0x8431b8eb,0xfe456a03,0x403f8a89,0x78992bfd,
	0x6beda52d,0x781bc5ab,0x42d1ef3d,0xfe3b94d7,0x052b1b13,0x1a8d76e3,0x76754b63,0x9d91d075,
	0x66659829,0x29fb7993,0x8c7b9c09,0x2c73f65f,0x7e03b241,0xc1e9e429,0x069d0d05,0x14570327,
	0xab4d4c75,0x3607c497,0x9ffbbdf7,0x0361c565,0xf77bec2b,0x132b1d5b,0x561ba747,0x3d59eabd,
	0xeea72e0d,0xc053027b,0x11ef9f25,0x8cb52cd7,0x18d75b0d,0xbfa5d687,0xf0d17e85,0xd38d9e63,
	0x12f51d69,0x8f6fa78f,0x2d7d6629,0x3ca3181b,0x47d555a3,0x2b29ac33,0xa91f2397,0x0c63c5c1,
	0x49370f85,0x2c6fe099,0x1445b61d,0x11ddd31f,0xc8bd9723,0x8c07c36d,0xb7e9f3d7,0xb7cd3903,
	0x30f1add9,0x02e332e5,0xde694e9f,0xb595aa49,0xde4bdf4b,0x0b1569bd,0xdc8fb91f,0x603fa0d1,
	0xf827f661,0x80df1c3b,0xba8babc5,0x9b7b8a85,0xe9c59251,0xe3a3b52d,0x7cf549cb,0x6aa71655,
	0x7b55db97,0x36f3b2e7,0x0dcda62b,0x21c5a13d,0x8aeb58f3,0x83832447,0xc57b28b1,0x367bc33b,
	0x6583e473,0xf83145b3,0x93d112eb,0xb11ffc5b,0xc001c067,0xab053e17,0xc905252f,0x3dab81ab,
	0x5031cc6f,0xfa2dfbe7,0x7eb9639f,0xdcc12a49,0x05c7da6b,0x8cff3223,0xa0f5fb1f,0x34a97c51,
	0xe35f2387,0xf4f7754f,0x9729465f,0x8259d9ef,0x777fdd37,0xeebf7879,0x8d2bf2d7,0x2a69ce55,
	0xf593ee33,0x43236a35,0x5c3f45c7,0xea1b7abb,0xeeedc383,0x481b71a1,0x140b8135,0xa8592361,
	0xabcb456f,0x01c34b61,0x239f68f1,0xe6b9dc93,0x2451ec8d,0xe36106a5,0x2275e791,0xd26f57a1,
	0x998bf6b5,0x3065e21f,0x396dd377,0xf563cfe5,0xce6dbc0b,0xfd67490f,0x2bcdd3c7,0x871b17bd,
	0xe0d323fd,0xd121f039,0x00496571,0x5dcdc597,0xc2833a3b,0xe57b12e9,0x49f5002d,0x7f5180e1,
	0x5229e3c1,0x0883cff7,0x11535b7b,0x52296f15,0x1457b3d5,0x1d71a6bf,0x5d4dd3a1,0x6e7fc0b5,
	0x8c8be0fd,0x3da31425,0x5c31eeaf,0x0f275e49,0x36295a11,0x799b4f97,0x2cb9017d,0x229bb563,
	0x1d7ffb2b,0x3a0d280b,0x4703f4a7,0xfbfba59d,0x18bde2ad,0x40cd00ff,0x85992997,0xa4138d97,
	0xa103e643,0x49d7ef75,0xce6b7f7b,0xca5777fb,0x4b5327e1,0x4c55f6ff,0x5bd1784d,0x55dd6879,
	0xe199cac1,0x5b9366ad,0xa58b7dc9,0x966bc8cb,0x1badc865,0x2807561f,0xe9c14677,0x156bf5b5,
	0xf847e59d,0x2051427b,0x56055aa7,0x06edebfb,0xb60dc777,0x3235cb6f,0xd04db96f,0x5aab1571,
	0x6c8d2851,0x2ba3902b,0x5ffb9daf,0x6d0b35f3,0x45372ccf,0xbbb12c73,0x36d76311,0x5813785d,
	0x546bd8db,0x139d5587,0x5a0f8aff,0xe4779b9b,0x126ba4a7,0x27cd1737,0xeb3fe1b3,0x1a933f9d,
	0x746531af,0x90cf30d7,0x1165c32d,0x7367525f,0xa56d1fb9,0x0c5b9247,0x81e98033,0xa99d9ce1,
	0x5f7d01cb,0x9e4df8e7,0xa99be355,0x2a897029,0xe47d733d,0x51adaca9,0x75b5d5eb,0x2723724d,
	0x97354ca9,0x99a75d01,0xbcd52511,0x450f8b63,0x345df8f1,0x52951deb,0x480766b1,0xef97f28f,
	0xab8fea41,0x62f184ed,0x7bb7fe7b,0x48af5af7,0x984f2f0d,0xfc63e615,0xa0bf42e3,0xb9ed40cf,
	0x5b0b270f,0x7cbbb0f7,0xcd61c22b,0x2597564f,0xd217584b,0xeeededb1,0x6e41a759,0xb79510b9,
	0xb2af640b,0x2c19d9e9,0x6f733f3d,0x567b5555,0x81f51be5,0x9c83a5c9,0x056f9d6f,0xb4814675,
	0x2df9b6b1,0x989b510b,0x1613614b,0x008b3071,0x46ad2595,0x69f5a7e9,0x41a99afb,0x372396ad,
	0xd6ed88f9,0xec536029,0x8be1d06f,0x137d6091,0xdd7fc593,0xce995617,0xa4d3225b,0xa06f268d,
	0x660d395f,0x73d5e98b,0xd1ff9141,0x697d9f1b,0x422d909d,0x743d7ae1,0x774d6269,0x4bd52bbd,
	0x6259badb,0xbe3107fd,0x400fa4df,0xe74385fb,0xcef9ffeb,0x5737e94f,0xe7fbd67b,0xaf458c69,
	0x415734e9,0xbcfbaec9,0xa433a8df,0x9bff2f9d,0x5ca71137,0xe6551ce9,0x2c3fe66f,0x7b377f39,
	0x8705a381,0xe44549b7,0x630d775b,0xe161d6e7,0x6277e6bb,0x22edd9bf,0x9ff9869d,0xba972b57,
	0xe5e7771f,0x4a9d5d13,0x97c1c6f1,0x7b9b7745,0x162b6731,0xc0cdcc55,0xe58bd7df,0xf2d9486f,
	0x5eff34bb,0xc91b25a7,0x33edcab7,0xb9636c9f,0x8c07ddd3,0x464929b7,0x05dbc78f,0x43f1bea9,
	0x61cf15d1,0x1b4b38bb,0x1fb5d249,0x93e71363,0xd6cb9a5b,0x2c354f71,0x9047af89,0x884f46b1,
	0xec59a85b,0xff43241b,0x59bde9c1,0xcedb6879,0x27bb9103,0xfddf6389,0xbab1f625,0x74e509af,
	0xab1d6ed1,0x55950e11,0x172379b7,0x186fa949,0xee95fa85,0x791bf48d,0x817dae3f,0xb925414d,
	0x191f802d,0x41515565,0xe38de749,0x2959f3c1,0xf99ff41b,0xae3b9985,0xc78b372d,0x1f03d7b7,
	0x9fe327eb,0x48093163,0xc11b340d,0xe4c7e647,0x959b1f7f,0x201191fb,0x7641dccd,0xaaef0795,
	0xb7678603,0x71d151d3,0x486d9e1f,0x786b3fc7,0xadc942eb,0xe3ef65f9,0x9d7b7777,0xbbd9fc11,
	0x062d2ef1,0x693b7f01,0xc8a94017,0x7c7b7fab,0xebebe919,0xc1a78609,0x93a10c07,0x2b3970d7,
	0x813bcbaf,0x9b5539b7,0x676fb113,0x13a585dd,0xd8430143,0x538beb37,0x158f6bd3,0x6cfb520f,
	0x8c0fb9b5,0x57b75b3d,0x40e1a4a9,0x0b1d32c7,0xf9957f25,0x266db709,0x66add4b9,0xaf935c65,
	0x18afaafd,0xf06db55f,0x87a18af5,0xfa930753,0xf521faf5,0xd99fd38d,0x70d99111,0xfbf5bd01,
	0xc7994603,0xda0fb267,0xa4d3308f,0x643bc4e9,0xaea9516f,0x3ef3934b,0xe47797b7,0x5591b18d,
	0x07d1c5c1,0xcba9f51d,0x58155e95,0xd4c70d77,0x687143cd,0x7ab9514d,0x58672c01,0xda592835,
	0x36d799af,0xded1f8cd,0xd78b7a9d,0x03690363,0xe33917c9,0x23c7111d,0x6a0d7dcd,0xe2c15fa3,
	0xc0b105c9,0xaf99b141,0xefd926c3,0xf1d1e99b,0x7e43379d,0x636d1ec7,0xdd494975,0x21b786fd,
	0x3fddc287,0x7c912ac1,0x241de1a1,0x0c33c385,0x5753d205,0x157baed1,0xbc7f77cf,0xc4b15df1,
	0x9d5f9ce3,0x46cb2a19,0xcdfda64f,0x4941f50d,0x6aa97a37,0xe8477e49,0x788fbe39,0x939fd4a9,
	0x30b91659,0xf1dbcc93,0x3d978c6b,0x4a2be29d,0xb307c7ef,0x7c9f72b5,0x08dd3e8b,0x10f3abcb,
	0xdfed04e3,0x63d327f7,0xd991680b,0x7aa7911f,0x49b1f767,0x85d93a23,0x0b4b271f,0x999f1487,
	0x3f7d32f9,0xa541ea91,0x3f0b69c9,0x30e145fb,0x8667895b,0xe9c3eb1b,0xe43952d1,0x85175081,
	0xb26bff97,0x013dfb29,0x61a7bec3,0xcd91271f,0x1f6be301,0xe0b3a4a7,0xde8be8f9,0x454b51e7,
	0x8a37fe35,0x2553190b,0xab87308f,0xdbe5daf3,0x4981ee15,0x15772e53,0x4ba1fd71,0x86ad5b61,
	0x26e596cf,0x419b7c01,0x1d4dc549,0x3191285f,0xd7e9b8d3,0xc5639825,0xa35f3093,0x502fa01b,
	0x16f7a5dd,0x28a17453,0x6e1b5f8b,0x0ec796cf,0x5c6515f1,0xe04bdaab,0xa4274f3b,0x2343e3bd,
	0x376f1c5b,0x6f7b0acd,0x2b935e6f,0x3e370e2f,0x47393cab,0x287d76eb,0x72d9f2c1,0x1bdd1a73,
	0xd3cf9fc1,0x8dbba0b9,0xd9d73d8d,0x351576e5,0x072568bd,0x52cd1673,0xbad920ff,0x106d08e5,
	0xc6172a0b,0xfd718fdf,0x138b3501,0x331359dd,0x296b7a5d,0x268d2b4b,0xce07ec4f,0xb1e3e43d,
	0x96cba9b1,0x5b2fca8b,0xa9cdd965,0x62618081,0x79cf9647,0x9d8f8ffd,0xc4c7138d,0xabb7f227,
	0x9cefa1af,0x86097b87,0xc443bbd3,0xf7b594b9,0x2291c5b7,0x04252795,0x9df9a211,0xc3d528cb,
	0x1e01c97d,0xbf91a61b,0x010b09e5,0x523bc0f3,0xcc739663,0x19217d99,0x5f018fb5,0xfab3ced3,
	0x6e03ad17,0xcbd5c613,0x94cb2db3,0x1bab5017,0xbeb7ba89,0x2dd56617,0x33c160d3,0xab3f1b6b,
	0x0f7b4cf5,0x116d6fb7,0x6aa36dd9,0x68334d8d,0xff21a8df,0x46139d95,0x8e99c647,0xaaefd63b,
	0xd369be13,0xb965efd5,0x44358d71,0xd6872541,0x71f33ca3,0x382b6921,0x486d3d69,0x69b5f76f,
	0xf94dc9e9,0xcf53ebb1,0xd9a36c13,0xafd9439f,0xf9eb558b,0xccf33643,0xc09db015,0x11ff47af,
	0x4f2b8e73,0x6149011b,0xf98fa5db,0x07d9b58d,0x984f77d5,0xdfbb3b05,0xfd0d14a1,0xa8c30027,
	0x51851e2b,0x9fd76659,0xa91b3363,0xdcbbc877,0x8cdf6c37,0x7e5515f1,0xca1d0deb,0x2d6f6a7d,
	0x4b5d2007,0xfe118a37,0x43e909c5,0x3731aa47,0x75dfdfef,0x09116e13,0xdab38b4b,0xb9f980e1,
	0x76336f87,0x5187b3fd,0x9c1bba9b,0x4a6d0965,0x700f04b3,0x52c592f1,0xe82b689b,0xa2d38df7,
	0x1a0dbca1,0xf24ba377,0x1a5313fd,0x941fb4bf,0x36b130c1,0xc0bf1c99,0xd26b0e37,0x96ebcced,
	0xad692bcf,0xdaf130ed,0xddb5c087,0xfc7b3bbd,0x43897ed1,0x6ad58b93,0xbfd510f7,0xbfb7096d,
	0xf54bf60d,0xc889ed2d,0xdbdfe753,0xf6318e47,0xeed56e1b,0x3b55e8e9,0x3d4bd235,0xe1273f9d,
	0x253508d5,0x5aa7c17d,0x00f7cbfb,0x9e779cc9,0x8f5d825d,0x0f156625,0x5e2d1fcb,0x79ad3c2d,
	0xff29a61f,0x335b8fa7,0x4f9b6e97,0xdcfbf82f,0x9a5de3cd,0xd563fd51,0xdc5dd415,0xe23b3c41,
	0xf3a70465,0x1739d1f7,0x00f12bc3,0x83ef71df,0xc39bff29,0xb01310f9,0x383f75eb,0x6e438d87,
	0x41b5eea3,0x0d513b37,0xa4995c99,0x7009bbc5,0x1d5725a9,0x13770c23,0xd8b5d8a7,0x8bb92e27,
	0x16d16453,0x7f3756b1,0x40b5f6b3,0xa877084b,0x38552d05,0xe663025d,0x2b1fbc25,0xe30d6ccd,
	0xaeff396d,0x58fb282d,0x71e52c2b,0x7eedaa59,0x43d50f7b,0xa2254fad,0xc3616cbb,0x773188a1,
	0x74c1b66d,0x292fcbf7,0x8b4f0b99,0xaf9bb55d,0x2d998bc3,0x729138a1,0x7bdb6347,0xc597514f,
	0x2119384b,0x40e716d7,0xb6952019,0x81359d3f,0xc1e3c517,0x55f98a43,0x9571e523,0xe631c6ff,
	0xdb87d081,0xd3b53619,0x13d51145,0xe4edd667,0xcb77e32f,0x3d2f3a19,0xd785a425,0xab73ba5b,
	0x5a11e50b,0x17a74f87,0xd9b34335,0x967575c3,0x3395b249,0x2b85062f,0xaff75eab,0xc24d6c8f,
	0x0135d063,0x65552169,0x75517685,0x3bfdd0b9,0x2201431d,0x56cd1511,0x532b7f8d,0xd2312f43,
	0x03f78181,0x57cba28b,0xaa53684f,0x86391d35,0x1cfb8ae5,0x475995c5,0xdc01be25,0x9d1104a1,
	0x83d91be1,0xeca1a235,0xb2d7722d,0x505b11a1,0x29450359,0xf7fb5fd9,0x6bddbe4f,0x1f613f55,
	0xb0db977b,0xa3e36835,0x5f832a39,0xc01384e7,0xea214ab7,0xf6039355,0x4a9fb063,0xb00f2287,
	0xe98360cb,0xa02954d1,0x3775030b,0x65970e71,0xc153c3b7,0x814738c3,0x06abf13b,0x209181e3,
	0xdacff8c9,0xc67f80d3,0x9853ebbf,0x5b93a627,0xef1b3593,0xac17e12d,0x94e3aa31,0xdcd76191,
	0xa04394f1,0xde7b5d87,0xd63defef,0x673f4477,0xb23d6c05,0x7b43461f,0x70a77121,0x0b55963b,
	0xe3e1bf3b,0xb22f54b7,0x5bd5d7b5,0x18498249,0x67f7d747,0x0621e99f,0xbbdbe863,0xacf9650d,
	0xfe2bf623,0x2e2b68ab,0xca3dc7a9,0xe8e53905,0xac112c13,0x967fb63b,0x5edf5ed1,0xbd3923af,
	0x16234ca1,0x8181d431,0x1917e0e9,0x5dc52297,0x78c703a3,0xc8b39efb,0x28976fc7,0x5205d84d,
	0x41490a31,0x3dc5aa8d,0xb685e10b,0x26197969,0x46df7baf,0xab8b3f67,0xee65a31b,0xbbcfd98f,
	0xa3a34acb,0x7707778f,0xa729c229,0x3b959865,0x2d99d675,0xe05d7b8d,0xac290d2b,0xa5896e9f,
	0x8faf9eeb,0xe3dbdf7d,0xa6255ae1,0x026b9af5,0x02b71aad,0xbaf71ff7,0xa447eed1,0x34a76f29,
	0xa671ab89,0xfd513f21,0x451bfe49,0x694dfd03,0x7a7db391,0x61ad81ab,0x7f9f5563,0x2917e355,
	0xf76bca21,0x1efd4bc9,0x0c2f1bfd,0x096b3af9,0x47ab10db,0xed531e35,0x6d95babf,0xfd4fa3cf,
	0x209da8ad,0xa6efb339,0x99ffe017,0x467971c1,0x3b8546c5,0x89373ba1,0x4409a53d,0x063ff9bf,
	0x6e8de9a3,0x15b9bbc1,0xc3b1d32f,0x6ea7fec3,0x65c9ae09,0x932d8877,0x9f5f47b7,0x935b3ecf,
	0xfc39c403,0x2e6fe427,0xb4e57a63,0xdaa91feb,0x34bd83e1,0xbb87bbc1,0x02792189,0x0e917d2b,
	0xd325a343,0x16a383b7,0x0fbbf749,0x0db193a5,0x95238a09,0x25173509,0xf6b79e8b,0x1c570f7b,
	0x0b53c75d,0x76656a3b,0x0cd9a7fd,0xd57138d7,0x1239a6b7,0x852f9c59,0x2bfbb717,0xbb9d40e9,
	0xeb45e4cd,0x98477ffb,0x9b5fc717,0x6a1baeed,0xf5c784a7,0x43a1823b,0x98ab9007,0x65d5ed21,
	0x07fbc48d,0x895d65c1,0x80ef0bb5,0x8e5ff5d1,0x68093313,0x9abfffbb,0x99a51ab7,0x2ef1204d,
	0x64fbe415,0x393714db,0x79ab496d,0xaf6f0ded,0x8fc5c5b5,0xb75b565f,0x124bb4ff,0xe565b713,
	0x9443155f,0x99e97f0f,0x5835105b,0x05019829,0xb23bf4c7,0xd8c79035,0x8c81c939,0x321ffea1,
	0xd6571ee7,0xc0032ea9,0x25af4d17,0xb14375f3,0x532dbd03,0x70d51fc5,0x58a96e3f,0xb89554a1,
	0x3a395ba7,0x0299e671,0x41bde8bf,0xe0e96933,0x54dfffa3,0x43d58019,0xada3076d,0x36b9c73b,
	0xbd6b5b17,0x1b3b41b3,0x827d68e9,0xeb25b451,0x18112263,0x889dd4bb,0xc8d3e49b,0xa4f9b519,
	0x6bed8131,0x45fb5437,0x54938fb1,0x71a7ba39,0x9c05af79,0x087d89b5,0x0e19e223,0x56496d65,
	0x8045a671,0x616d4a4b,0xdb23fbb1,0x80a39e57,0x9e7ff5a1,0x3f45f393,0x27d908e1,0x181dcfcb,
	0x8371b7d1,0x0ea308b5,0x0fcbc801,0xaecbe491,0xbbbfa815,0x7b4bef5b,0x26f32e2b,0x5265ec75,
	0x6cf556c9,0xd12dccbf,0xe2b12c3f,0x3d4f1153,0x8e877e8f,0xfd5d829b,0xa2cb93df,0x2793a40b,
	0xc2d37955,0x2f1dcc35,0x5a751c81,0x37e34985,0xd01bd54b,0x18d17b5b,0xd9438857,0x949b47b7,
	0xb98b09ed,0xd107d561,0xb439e961,0x94b9f295,0x783b4cff,0x53751025,0xcebb0669,0x90eb3923,
	0x5423878d,0xa1fbef0d,0x839ddffd,0x5483526b,0xdd296ae7,0x859f8003,0x6e175573,0x2e798a7b,
	0x8419a5ad,0xef8df881,0xd2c7e9eb,0xa2712f6f,0xd3a938bf,0xfa1db281,0xa8b9a94d,0xb9b59e69,
	0x4971ec47,0x89cd4987,0x42592d47,0xf437708f,0xcefbe4bd,0x8e43d7a5,0x967fc253,0xd991c813,
	0xd2af57d9,0xe34f526d,0x2971acab,0x2a07bd31,0x00e1619d,0xd1e507fd,0x95d18d5b,0xaf7feb29,
	0x9ccff957,0x31233bf9,0xb5b3e731,0xae911d41,0x799f069b,0x2751e48f,0x6b8dc3c3,0xf7731bcf,
	0x93599641,0x8adb8775,0x0b417871,0x97099929,0x47f52f6d,0xe35b36e9,0x63178b63,0x27dd3eb3,
	0x304d488b,0x0a8baeaf,0x64bdb889,0xc321d9d3,0x9925dc4f,0x6d559113,0x6e4f1697,0x91afa8fd,
	0x9c2b1eb5,0xecc5c3ed,0x334b5c0d,0xfd09c8a9,0xd8f351fd,0x5f11ed97,0x45994435,0x805bc059,
	0xcdf7bbb3,0xb09911f9,0x3e89141d,0x19752f95,0xd19db9ad,0xa4e14f7f,0x87d53f9b,0x59d39aef,
	0xab33f705,0x3799bc1f,0xc49d2e51,0x17975901,0xcbebc11d,0x9d976257,0xda6720a3,0xbe8b9f6b,
	0x27e17ca1,0xe5d95e29,0x9a2734c1,0x4121afd5,0xaf193a83,0x3a851a25,0x09318ba3,0xa97324f3,
	0x66816d01,0xc1e9ac61,0x4a478e09,0x4a435f7f,0x20edbc9d,0x1f7d5377,0x26935179,0x8ffd1337,
	0xd819fd21,0x94dd138f,0x36a31d43,0x71b1f3e5,0xa5a942a1,0xc2cf7355,0xab710f7d,0x821b825b,
	0x5c271679,0x0a4558ff,0xb75be207,0xa09df973,0xc00bcc4d,0x8d510749,0x972bcf89,0x4a3f5b0d,
	0x60aff705,0xd0353a79,0x3b119871,0x8ab79d13,0x1159fdd7,0xfa53655d,0x8fa5a7f9,0x8d5df677,
	0x0233d13d,0xb73d0e49,0x66e7591b,0xce334c2f,0x7953bffd,0xb7a74c1b,0x01415ba3,0xeae5be41,
	0x2bb56c1d,0xd26f6339,0x367f391f,0x13c354b1,0x363ddff5,0xc59d828f,0x3edff9e7,0x1cc9cc95,
	0xb6b7c31f,0x975fa091,0x1bfdea17,0x2e978503,0x04d7af7d,0x970b783f,0xa1e17e99,0x177b8c1d,
	0x8b39a63b,0xfe1fa61d,0x1fff5a1b,0x3c65cc0f,0x4063a4cb,0x313fe539,0xaa2d7217,0x29ed5805,
	0xbfbf59eb,0xa13d6c27,0x01a953c7,0xc559d93d,0x02a3fa9d,0x4c0f6a05,0x1e1f8937,0x1d931bf7,
	0xb94b372b,0xddd1a377,0x569f1e35,0xdc2bbc7b,0x43db5029,0x71c92fad,0x2a9f4559,0x565df41b,
	0x4b5f4b75,0xf3695559,0xaaff1cff,0x3e09862f,0xfacd492d,0x1f4387bb,0x830b9451,0xf2bdcd1b,
	0xd7fdf8c1,0x24178397,0xa16f703d,0x72a7e745,0x3cb72de1,0xe3cb8c39,0x8145707d,0xeba50421,
	0x6fa79589,0xd46dc879,0x130f948b,0xec37d127,0x5d5f8afd,0x8135bfb1,0x45b180b5,0x348706d9,
	0xf15d0cc9,0xab81f6cb,0x2f7f0303,0x276915bf,0x0f05d1bf,0x0bd3ad2f,0xd731b853,0xdb57f36d,
	0x2aa37dfb,0xb2dfb9d5,0x9ce5d13f,0xcb730777,0x826df7df,0x0a79883b,0x4325f731,0x28853883,
	0xf77bdd17,0x769d3563,0x97e15159,0xca011939,0x86d71795,0x9675ccdd,0xbd71a9ab,0xbf033549,
	0x62679297,0x254da5bf,0x1395b1e9,0x7f4b7e6f,0xaa050f9f,0x7b9bdfa3,0xc0756899,0xbc43d969,
	0xc4691b77,0xafffffb1,0xd9a39e0b,0xd1ffcb01,0x58392335,0x583dad95,0x2d159955,0xd839450b,
	0xe503a931,0xea459085,0xaa2ddd59,0x5351935d,0xfc379a11,0xbd2d4c3f,0x6ab30dbb,0x855368d9,
	0x1a35c1bd,0xaa339e05,0x5bd7f3eb,0x5ef30c69,0x1f3f606b,0x4dbd99a7,0x872fa423,0x1087a5ff,
	0x6883df97,0xe8590679,0xfbbfc25f,0x3b15ab93,0x8915a701,0xdfbfdc5b,0x56ede767,0xc1456e25,
	0xa2ef11b7,0xdfcbe0ad,0xed8925cb,0x386bc6c1,0x5ff9830b,0x9b856361,0x94cdaee1,0xf981e375,
	0x8afb9b99,0x2e191beb,0x0b5997c9,0xd227345f,0x48ad8e43,0x1be12647,0x0233be6d,0x55a9789b,
	0xf0a99535,0xf3571ffb,0xc5cdce77,0xcdf9eb57,0x867386e3,0x8e236515,0x87016661,0xccb390bf,
	0xd2798b07,0xf2156d29,0x440b5c6b,0x5c15a311,0x1b0fefa3,0xd2214855,0x5197239d,0xd00f1f8d,
	0x7d711e07,0xaf673c3f,0x83b350c3,0x372d737b,0xe6c1afc1,0x9a2b8111,0xf6d73f75,0x6baf492d,
	0xad0fa3b1,0x92dd1e85,0x78e5d713,0xc47374fd,0xc84db2f5,0x8b11e8d5,0x92256fc7,0x6605024b,
	0xab57c5fd,0x06899dc5,0x2e47d77b,0x3397607f,0xbcf18979,0x5c2921a7,0xe56376eb,0x6003b00d,
	0x70cb2367,0x96ffdc4d,0xe4f99693,0x9ecd2f6f,0x00730807,0xf7433615,0x78f3c3bb,0xf51dc823,
	0xc46beee7,0x134f34e3,0x349d5573,0x2ac7bbb3,0x2d15e7d9,0x98af3925,0xbbb31191,0xdb4370b1,
	0x5bbd8ff9,0xad0ddad3,0x2b55f1b7,0x26b55fb7,0x5b9766a9,0xef41e665,0x230b0849,0x02e72065,
	0xfabf4295,0x184b79e5,0x6dc58577,0x2c4b9665,0x433be6b1,0x3c4d41dd,0x4ad9dc3b,0xb6fb3e69,
	0x93f5b737,0xab97d665,0x570b0751,0x3fbb9b27,0x59c38eab,0x73a13819,0x1581ee41,0xbcf3c263,
	0x6861b2d7,0x80096d1d,0x18cbea5b,0xefb509e7,0xf373e9d1,0x5b933e1f,0xcbe36bb7,0x74bfd481,
	0x2785aef1,0x912d1355,0xdb29be31,0x756f7f0f,0x630b87dd,0xacf1f17b,0x3d63ee73,0xf8cf6d6d,
	0x0f63797d,0xdd1996d9,0xdcc3ceed,0xd4953787,0x19cd9d09,0x330fb839,0xdfe11cd3,0x3e1bf64f,
	0x0c7bd4f7,0x845f5df1,0x92bfc529,0xfb5fb0bd,0xc77da20f,0xebbf60e1,0xefc149b1,0x340fe8d1,
	0xd9d11859,0xea0f076b,0xc8bb45fd,0xe27b4897,0x7a5bf429,0x2753c27d,0x8fe51463,0xe49f6f1f,
	0x20e7cf1b,0xd3bb0a8d,0xc0dd9305,0xad1ddd81,0xbf2b7511,0xa89d5c97,0xe9ad08c7,0x943f03e1,
	0x99bf5937,0x89775721,0x53c52a5b,0xc8f76e67,0xc12b2b01,0xc4eff739,0x4cfd3f35,0xe1df1243,
	0x2adb8b29,0xf5d5f573,0x10956697,0x0e39baaf,0x6a21e0b3,0x841b42ed,0x5035fc89,0xe6f195eb,
	0x093d4de9,0xc5e3a64d,0x5cef1ed7,0xdf97e245,0x824fc561,0xc07378bf,0xf0395219,0x5767bb09,
	0xd8653ef3,0x893982f7,0x94f546b1,0x4a430591,0xd0750cc5,0x46c9fa35,0xb069bdc3,0xa1b57e41,
	0xca575041,0xd1e39d3d,0x2b498e41,0x25efe581,0x39d58f19,0xf66ff15d,0xbaa9c9df,0x0ecb4cc1,
	0xbf95684b,0x54799f69,0xc90d0221,0x34cb837d,0xe2316919,0xe137f0bf,0xff5bad49,0xe21ba433,
	0x6721020d,0x08076c43,0x6de3ab69,0x438bc16d,0x4bcd9bfb,0x6b739365,0x555feb59,0x7997b2bf,
	0x5e7dccff,0x4623bf17,0x8fef2fb5,0x495f01bf,0x7769ad7b,0x6bf31cd9,0x9a19f3e9,0x6db1f70f,
	0x51ab4d1b,0xeadfcbaf,0x3bcf711f,0x87fdc759,0x044747d3,0x4c0d1925,0xd169c353,0xb15de04f,
	0x1b2b7add,0x74cbde53,0x34a72e41,0xab9355a7,0x502bd9bd,0x278ffcd5,0x45b38271,0xb2096e27,
	0xe401633f,0x24f9fbcf,0x141ba233,0xead55093,0x97553675,0xeccfc4ef,0xa7d9269f,0x77abd0c1,
	0x43afc7b9,0x1efd816d,0x6a4b2493,0x26f35c87,0x148735b1,0x7c9d9701,0x2f3b11b5,0xc4b308c9,
	0x6037be47,0x88e9c4f5,0xddd7c977,0x0ba1be6d,0x210553ad,0xca496113,0xb9bbb20d,0x36158767,
	0x0e1b5161,0xab4bb4b3,0x4be5017b,0x2f11fbaf,0x548f5123,0xfba779af,0xebbd2283,0x633fce47,
	0xf05b2001,0x113b776f,0xe81539b7,0x31f37a37,0xa567d34f,0x890b3fdf,0x5023ca6f,0xfe270f8f,
	0x987dfda5,0xa8450c75,0x5c897bc7,0xdf7d206d,0x885103e7,0x5d43bb2d,0x784ffdab,0xf33dcdef,
	0xa67f9241,0xe081eb8f,0xe9e30dc7,0x4d5df53d,0x108d3127,0xf5a33ba5,0x1c219c91,0x89737c8d,
	0xe8e5fa53,0xcc7ba505,0x8745124b,0xfbc5c013,0x0fdd6dcb,0x81fff9cd,0x39fbb3fd,0x823d1f13,
	0x7cb166d5,0x414981a3,0x02512873,0xf56ba8d5,0x36853109,0x04a5b6b3,0x36c11d47,0x3989e9ab,
	0xed63bd3f,0xf67d22b3,0x1f2b0bd5,0xef7dd7ef,0x3343f69d,0x72695bdf,0xfdd51e49,0xc5cde101,
	0x5501378d,0xa62721fd,0xb871348f,0x69ad164b,0xd35fdec3,0xd29d9b5b,0x2117095d,0x17f97a3d,
	0x7c090437,0x2cd9b1cd,0xdf497737,0xce316d53,0x22954e31,0x5f138fb1,0xf8ebdd5f,0x1b7f3b0b,
	0xf97fe639,0xa9a73ced,0xfb51a4e7,0x91b7c6f1,0x8b2b8e25,0xa41d5beb,0xc433e5a7,0xd6535993,
	0x52e5d50d,0x9e2306a5,0xeaaf2b3d,0x53738d8d,0xf5e36c55,0xa08dcb95,0xc84f5a0f,0x88e35c81,
	0x1c3d9ca9,0x0e5bcac1,0x2201b44f,0xfd154c15,0xe9fbdafd,0xe5b5f2b5,0x7121fef3,0xce25bafd,
	0x18097d8d,0xa0e75d89,0xcc6dc6b9,0xe2d34def,0xad3990d9,0xb767cdd9,0x710dc529,0xbb897cb1,
	0x5749ccaf,0xbed34bc9,0xeb936595,0xe35b3f09,0x63dda91f,0x2bf5e209,0xe0f56a0f,0x0101d9c9,
	0x59839389,0xb3b57acb,0x7795b07b,0x87dfcbc9,0x30ab438d,0x4c2fdccf,0x6039177f,0x0901daed,
	0x2cb53017,0xcd9fc859,0x7f158389,0x2415411b,0x54e32459,0x336b3435,0x34bd03cf,0x1877f947,
	0x8d63f4d1,0x7d21aabb,0x47351755,0xf62b2c69,0x50475441,0x2f79c6c5,0x6ae311dd,0x6ed9be83,
	0x068dc8b3,0x754fd0bb,0x6b97a0f9,0x46d5fb9d,0x011bc07b,0xe0a97b8b,0xf58b7101,0x661764c9,
	0x11b9c737,0xcbb9c1a7,0xfe5df213,0x89439d21,0xc41fdac5,0x59d1e20d,0xce173d15,0x92a376c5,
	0x36e5e053,0x18717d45,0xa82b18b9,0x7b291fdd,0x94953957,0x403fd259,0x146d1e75,0xe3716f9f,
	0x2c977887,0x960b1bdf,0xc81fff87,0x44b9533f,0x2c3f36e9,0xebc90cf7,0x2ee9e9f9,0xc1ef5b01,
	0xf7cd08c9,0x41976e43,0x93dd0d97,0x98a5672d,0x236192b9,0x86bddaf1,0xea7340fb,0x32137517,
	0x0c0bbe93,0xfaa99db7,0x3789c683,0xd41d8c15,0x10bb107d,0x2df1add1,0x9a693157,0xf24dca89,
	0x6b531be1,0xa351cc05,0xf5c36a63,0x1ed592dd,0xa9911873,0x10b3bfa1,0x38add563,0x9b8fd883,
	0xc625972d,0x4023b379,0x47ab95d5,0x8aff8cf1,0xe1a35753,0x90d7b2eb,0x85a3f3fd,0xc14d2cab,
	0x9b853b6f,0x182f46dd,0xfce7e1ef,0x354b6c3b,0x0b335e55,0x62b132bb,0x282da07d,0x11750531,
	0x58f74823,0xd509517b,0x5b97844b,0x64eda325,0xf7054337,0xad0f9299,0xcdabdabf,0x747df0bb,
	0x7a79d141,0xa2c1171b,0x405def07,0xab97c499,0x14574031,0x29456e8d,0x4a012f1b,0x2d556e73,
	0xaa8f5f43,0x4fe9f407,0x3e5b70b9,0x057b2401,0x90f153fb,0x43254b25,0xb791566b,0xf9718e03,
	0xe2398f25,0x6d95fd0d,0xbf33d47d,0xf9497545,0x790fe1d3,0x39013569,0x973bd609,0x30bf8f97,
	0x88fdb261,0x6f579f73,0x230701ed,0xb8356cd3,0xd7775171,0x3bab62e5,0xf0619fcf,0xe5b583d7,
	0x94d96eef,0xcb3d4105,0xe0799d21,0x3def5f91,0xd569af0f,0x8e75d19f,0x70e7b219,0x0541ebef,
	0xaa535f4b,0x19dfe00b,0xa4ada6b7,0x70ade2eb,0xdaa94b65,0xa731e825,0x8d2fb7bf,0x76db5987,
	0x3c69b26d,0x364bb351,0x73411bc5,0x411d6ccb,0xad755bb1,0x4e31157d,0xa019a81d,0x3c6f0ecb,
	0xac9dcbcf,0x5e13ca1f,0xc65995e5,0xca73f39b,0x929599ab,0xbe477135,0x0b096709,0x92719e61,
	0x6af5e36f,0x5149ac43,0xae99eb35,0x725f8e45,0x6d45e38d,0xc4c35b55,0x55e164e1,0x0fd58b79,
	0x15f1a5c1,0x7283fa01,0xf321ce4b,0x09151433,0xdf4bdc11,0xe17b1c67,0x4f013e7d,0xc60be9b7,
	0x9a91d3c5,0xe6cd0c29,0x31916e45,0xe947bd4f,0x68e78a71,0x66bf8575,0x2b4b5d39,0x6105fd49,
	0x5459e2ef,0xb5bd9401,0xfe0f16b7,0x1827c201,0x88dbfa65,0x995f900b,0xa62596eb,0x4735dad9,
	0x2d4b9d3f,0xe9653b55,0x033bcfc1,0x6565fb37,0xdc6bdc2b,0xd0b1fe2f,0x216bcdf1,0xb98f078f,
	0xbde9c129,0xae55446d,0x2237fdfb,0x8b358257,0x3f57247b,0x9685fa6f,0xc5859123,0xf3811915,
	0x6d35a1ad,0x739f2a15,0x92a5027d,0x4e47514f,0xebe3ac8f,0xc72bb7d1,0xa151bbdd,0x4b015595,
	0x90afc63f,0x0ad73f97,0x02a7dae3,0x9dd1e285,0x9acfd221,0xb17711e3,0xca3115f5,0x507f53bb,
	0x8c5b8adf,0xc80d50bd,0xb6dfc145,0xb381d0e5,0xa35d176b,0x36bd2cad,0x7c09f3c9,0xeeef9ab1,
	0xf2bdc003,0xa1d541cf,0xaa6fcc41,0x338b77d9,0x1b4fc327,0xeacb14bb,0x393bd633,0x8bbf421d,
	0xa4d14aa5,0x513faf97,0xaefb8eed,0x4c9f934b,0xf6e9808f,0x33f75f13,0xeaa70a89,0x26e5922f,
	0xf21fc441,0x71df8f61,0x8ca1b8e5,0xd7f1dfa3,0x28ebff5d,0x6b0fc941,0xffb14aa9,0x7ad1a38b,
	0xb8a71acf,0xa1c5cef7,0x2207b643,0x7933b9cf,0xc29793cb,0xfb67d951,0x8e395ceb,0x1c75ff5f,
	0x84e930cb,0xa183f4a3,0x844b4fa1,0xbe97bf35,0x13b1d693,0x82d17dcb,0x72a3b429,0x9b433f53,
	0xb1eb7d2f,0x742dbf2d,0x1f134a17,0x40cd6dc3,0xca7944ef,0xf19fadb9,0x6fd10fbf,0xa12fad93,
	0x892bab71,0x7f55c5e1,0xd47f0741,0xc309c3df,0x13b3e099,0xaaa308a5,0x4f231b85,0x12a7e4c7,
	0x62ad3b91,0xab0b1887,0x1d2f2539,0x52fde075,0xba9dcfcb,0xa32f7699,0x007d0fd5,0x2ea1701b,
	0xc4f12205,0x81e1df6d,0x28491e97,0x68d9a2ef,0x48fdfd3f,0x8315c81f,0xba3f5189,0xae8d6b37,
	0x84fd67c7,0x50ebfb57,0xfb6dea79,0x07514b37,0x2715b82f,0xc4a75643,0x194d11fd,0xe65f2245,
	0xe64fca53,0x47b9a595,0x92bd9c75,0xdb9719b7,0xbba35457,0xd4b7a28b,0x4107ef09,0xe485b1f1,
	0xbaed5ba3,0x985f0fed,0x00db04a7,0x5d5def59,0x8bedc9ed,0x3297f705,0xfb519307,0x91f5a763,
	0x8355222f,0x976d04a9,0x8eeb4fa9,0xeed3ed87,0x5bb555ad,0x90190639,0xd88d54d1,0xd21fa045,
	0x8e8bb8f1,0xdbf78697,0xdc8ba693,0xfcad1629,0x4d3b18d1,0xf18f8b31,0x4f9bd7c3,0xa2f5eac3,
	0x1a0fef65,0x5f8d70fd,0xffdfcf01,0x1e1bebab,0x0141b913,0xcdc9e977,0xdddfabb5,0x3ce92585,
	0x71e76985,0x9e4117a5,0xa58bcb0d,0x34d310f9,0xb70900ad,0x2e1dcd15,0x2739ed01,0x32efdfb7,
	0x10913fc9,0xb6a7e6dd,0x30ad7951,0x8d03e979,0x6c577e5b,0xce59ca97,0x160de483,0x92773901,
	0xbf139f2d,0x89d1036b,0xdaeb34e5,0xfd5d3917,0xfd6b2553,0x3cd3ff03,0xfb3da793,0x0373818d,
	0xb4eb6929,0xdb4fea99,0xd4637567,0x0717c43d,0x4507ed51,0xfa5bafe7,0xae29b80b,0xe855da07,
	0xb81dd3b7,0x71331233,0x63bb6eed,0xf5dfefd5,0x3c6f728f,0x9a41eb4b,0xacb3a445,0x7e0fd397,
	0x3d290955,0x34118883,0x0613b213,0xffe96149,0x1b6395c9,0xe25927b9,0x3b41a71b,0xfc150fe9,
	0x8715c8f7,0x4ef99451,0x8f0dcbf1,0x65e59e81,0x78251c35,0xeaf7e43b,0x84af47e9,0xb455e125,
	0xc75f061b,0x4f7f54eb,0x48cbe625,0x9307adeb,0x67794f8f,0x3ee9485b,0xba65fa87,0x3345e9f5,
	0x3e0b88bb,0x45b36215,0x13ef66c5,0x3d01b66d,0x9c9d9e13,0xfb83c425,0x3441bf51,0x5fd7bd85,
	0x599b8d4f,0xe4296c1f,0x879b906b,0x84059f75,0x89593a77,0xf099b01f,0x90a5c31d,0x9b797f7d,
	0xd71164d3,0x9ff1dbcf,0x11712235,0x12c3b0e9,0x7de9bbf7,0xc079ed57,0xd475ff49,0xe2218407,
	0xe1ef14bf,0xd09d726f,0x1593f7bb,0x3e6f3335,0xc913be4f,0xfff78555,0x8b13d9ad,0xea3defcf,
	0x3435f70f,0xd041e9cd,0x0ea5a915,0x26bb0f43,0xd81981b5,0x56654a23,0xe65fc4a5,0x44c357ff,
	0x36695a3b,0x1b6f942f,0xadc52adf,0xd5d96e7d,0x56b98ae5,0x9d95764b,0xdebddf09,0x7d23623d,
	0x1f89213f,0x7137fc5f,0xfa996e31,0x60795acb,0x4f39431b,0x01d94cd7,0x530f9433,0x395164b7,
	0x15196393,0xf32b85a9,0x733f00a9,0x05cf5e9b,0x4a5b980d,0x2203b953,0x28b53bfd,0x59bb0617,
	0x4b1b0d33,0x455f0bd7,0x2c5dac5d,0x4f8b24d5,0x6f5d9bf9,0x2f65efc5,0x6b91bac1,0x1957dd85,
	0x240f7e99,0xae638333,0xf11317e9,0x31e318e1,0xa4052595,0x0dd10cbb,0x6e07215b,0x2d9512ab,
	0x50fb2cbb,0x374b9885,0x63036667,0x2b8306ab,0xac93701f,0x7399b53d,0xe8f94d23,0xe667fdb5,
	0xf15d4119,0xcba75119,0x1a4dd76f,0x65a3ba9f,0x4bcbbb4d,0x098db6d5,0x1bc987f3,0x4e41c74b,
	0xb33939a9,0x598baab7,0xc597671f,0xd3f3a1a3,0x62edeb5d,0x8b03a78d,0xec552827,0x4a110897,
	0xf31188e5,0xf1873bab,0x4a036e0d,0x54a36923,0x11bb2905,0xe5cb85ef,0x07053097,0xb94d6b45,
	0xdbe735c9,0xe6add2bf,0xe32f4153,0xd0659f09,0xd6798183,0x5a355907,0xfeb7f09d,0x95e5497d,
	0x873b7bcd,0xee91173b,0x433fd28f,0x5a6f51bd,0xade5868d,0x9b17d05b,0x6ccfa413,0x144b4deb,
	0x1d136aed,0x414528eb,0xb2d54fd7,0x506fb02d,0x3347ee61,0xedbfe3f9,0x112d1355,0xc37313b7,
	0xf3ed87a3,0xb9574019,0x3115c3c9,0x7a99a9c1,0xc05b33b7,0x4a037469,0xf235333b,0xaccdc68b,
	0xb0cd6ae7,0xf3df4d8d,0x939db579,0x2b9f8e61,0x8d6735c7,0x7a31eab5,0x7cc7c51f,0x7449c293,
	0x67356233,0x706b9a93,0xa693c887,0x60b1ae79,0xd12bd84f,0x3b1fd867,0xa447f6db,0x785d3477,
	0xb9270f83,0xb10d68f5,0x4c955d09,0xe183faf5,0xe0eba385,0x5c1b9789,0x029502cb,0xf1fbb963,
	0xf7230951,0x5a5792fb,0x9ec92f9d,0x6047a53b,0x50676427,0xdef9eaa5,0xf817cfc7,0x1491feff,
	0x402f7a95,0x535f2b71,0x0ccff959,0x99adbf37,0x11e1cb6d,0x180d9cc7,0xcba99129,0x2e156375,
	0xa1c9c2c9,0xe5b11d9f,0x7cc70fd7,0x74e9db53,0x961b0f0f,0xce252177,0xcab166cb,0xc6f79571,
	0x37f515e9,0xdd63cd51,0x6b570535,0x23adac79,0xec59894b,0x5a9534bd,0x6911fd09,0xc229341b,
	0x4d351c6f,0xa907b6d1,0x0b9f4809,0x4229a611,0xe25d58d9,0xc92f7b27,0x612b2cbb,0x7d1d6f1d,
	0x7a8b9353,0x79ad0ee7,0x6741c36f,0xf7139c09,0x246500f3,0xf84521bd,0xd3df9b3b,0xefc5a6a3,
	0xc777ec11,0x62e762df,0x7e617f01,0x139962c7,0x5d370951,0xb8a97e0b,0x688f5a65,0xcc950b57,
	0xc9ffeca1,0x7ac93883,0x679d3ed7,0x336d6f39,0x56139e31,0xedadae17,0x6d1f8891,0xa07d3e5f,
	0xc6a14f7d,0xf9e3ae1b,0x7019238f,0xdcc576c5,0x16bb304b,0xad23386d,0xf5f1f099,0xf2eff169,
	0xd06163a3,0x5b491a73,0x3b794a3f,0xa04f0f57,0x057314d9,0x5f5dac19,0xfde7a9d7,0x65dd869f,
	0xe8c1ac87,0x7c8bacd5,0xe3db6c83,0x393d4f59,0x06fb2593,0xdf2d40a3,0x865fb827,0xd5bbb0a9,
	0x1fc18229,0xbdbd0d09,0x19e58073,0xad456db5,0x9e9760b7,0x99e37615,0xb741abe1,0x797712b1,
	0xb3e7b0fd,0x216ffb5b,0x44b558ad,0x6c9561d5,0x0e0788fd,0xaf55b4f9,0xfeeb41df,0x0287e063,
	0x32311a01,0x6cb5f093,0xa1f14447,0x71e183a3,0x758dc59f,0x11d3ee59,0x3241037b,0xbcdb7de7,
	0x962352af,0x471fbdff,0x65b9aedd,0x62592b87,0xf3eb4257,0xa62d3bbf,0xaca3e691,0xaee51fe7,
	0x69bf44ff,0x5abf2d63,0xdaafc087,0xadb3526f,0xc665cf5f,0x63b97f37,0x6ff3ed79,0xb9996b8f,
	0xe587cf6d,0x7429a10f,0x81f5fde3,0xae1d31c1,0x68bb8171,0x74470349,0x4497c70d,0xb8671687,
	0x107d64f3,0xa26db3c9,0x332de807,0xc849e369,0xb53151c7,0x54271afd,0xd96d6ea7,0xa13f86fb,
	0xe021ad07,0x571fd8dd,0x3c799c8f,0x8b6d01d1,0x0485be19,0xf22dc1e1,0xe3d7cc23,0xa4997393,
	0x587923a9,0x8651fc13,0x827b7595,0xd13747e5,0x4dff68a5,0xcfad3bfd,0x3fb953d9,0x4d618379,
	0xac03b94d,0xc69121b7,0xa055a9b1,0xddd93109,0x475bb823,0x2075b5dd,0x0f75a6a3,0xa10bee59,
	0x5bc372f3,0x70f70693,0x07a9ebff,0x8009992d,0x84df77cd,0xeadbe487,0xdbeb31dd,0x3f8b1c5b,
	0x573b0a11,0xc10fbfef,0x209b0c19,0x30f55cb9,0x994b775d,0x27ada587,0xb47fcf5f,0x83514629,
	0x1c6b8ca1,0xf4ef5b97,0x69c99619,0x3451f897,0x35e12b0d,0xe23f9ee9,0x4f136583,0xa14f14ef,
	0xd7d9fd1f,0x6d297fd3,0x98597299,0xb84f2a2f,0x4a654b97,0x5863df35,0x28058723,0xc8f74257,
	0x8483f283,0xcccd0b71,0xb7e986b1,0xf59f8f6f,0x25177635,0x1a6b7d75,0xa23d139b,0x443d3887,
	0x0bed3849,0x196db5b5,0x4a9f53fd,0x4f7546bd,0x92b9cca3,0x2b293933,0x2719d6c1,0x9791b22d,
	0x66196e6b,0xdb1dae6f,0x691b9897,0x73818f05,0xfe8f9517,0x1fef1a79,0x467d28f3,0xa1e55a73,
	0xb989a961,0x3c6f3de5,0xe27fef19,0x79f967b1,0x9259da4d,0x408f11d1,0xd6c98f0b,0xbcab6d01,
	0x7b3d1225,0x2a7364e3,0x5c6d6e9b,0x058b30ab,0x565b0b7f,0xa75b9847,0x14e15a5f,0xdbd55601,
	0x8ebb8633,0x74bb7cb1,0x73074ab9,0x636b4a5d,0x51539c67,0x61254f61,0xc42548cd,0xadd5521f,
	0x66013785,0xed5bd71b,0xd8ef738d,0xab49b5b1,0xa887a53f,0x8d3fa12d,0x4e7b24af,0xbb9f0e83,
	0x21934c93,0x88e35e6b,0x774735b1,0xdf59b40f,0xbfb982c1,0x7d7b6033,0xe43f64db,0x88a348d7,
	0xb0738057,0x7e653569,0x8db1da3d,0x0c4d6765,0x59277627,0xd62b677d,0x9c57ccaf,0xb2d36f47,
	0xf023c24d,0x67755761,0xd25146cd,0x69577219,0xb597452d,0xae1f3a95,0x94250c03,0x12a3407b,
	0xcca3d66f,0x6025381d,0x91c59d7b,0x78279717,0xb44bda09,0xaeada585,0x0f895f31,0xdb016b9f,
	0x6079f535,0x270563e5,0xcf33dce1,0x24f159cb,0xf301e377,0x33a35cd9,0x98e72f13,0xb963305b,
	0x14a36b9b,0x3d271f85,0x64398019,0xe6679e1b,0xedff74b1,0x6b579d97,0x2121b105,0xf5b9fed9,
	0xc0a53b19,0x061f0847,0x20fd1ebb,0xddb94873,0x2007a571,0x7699cd4d,0x1f9786df,0x927517c5,
	0xca81b9a9,0xe7ffb3f3,0xec1f0ce3,0xf69dddbd,0x225731f3,0x88b91a03,0xb22d5efd,0x6c892c47,
	0x46b931c7,0x6b5750d3,0xe2c1fb2b,0x073f2361,0xccb51aed,0x078b1a43,0xbd439435,0x5b69fe0b,
	0x184d826d,0x5b3945b5,0x788396ab,0xf057bf4d,0x5563459b,0xab636d17,0x0bbdcde5,0x5105ff39,
	0x10c1bf13,0xe539d1df,0x978b2901,0xbd13d7e7,0x711f1bb9,0x9f0f5a09,0x6efb9fe5,0x79cff27b,
	0x1019cfb5,0xb967ad1d,0xc0793843,0xc327b41d,0x732f2b7d,0x9fe37125,0xdee12a8f,0x5cb98afd,
	0x24d310cb,0x2a55a7b7,0x2a71270d,0xc2c55b55,0x6d55c7a3,0x1db32af1,0x99cfbabf,0xfb350c67,
	0xabf3f351,0x4d174a79,0xe311d477,0x069d357b,0x4fcfa767,0x5acd887b,0x44ab69cd,0xf137eae5,
	0x70f99cbf,0x193f76ad,0xee7d3c1f,0x83e3aafb,0x0963867f,0x8c05b34b,0x0ad1bd93,0x952f6b1f,
	0xcdeb8711,0x88dd061b,0x6757161b,0xfa49c4bb,0xa753c527,0xf8ad9d6b,0xbe29486b,0x180f423f,
	0xcb4720bf,0xb8836b0f,0x9ec37707,0x13ffcc25,0x755d081b,0x1a97a165,0xf70f4931,0xa54935f1,
	0x40116cc5,0x07455053,0x3c5f6ffb,0x85bbeb27,0x1dc7d891,0xbe152243,0x346b4b3d,0x82cfbc5d,
	0xf1cba29b,0x36b5392f,0x5e51ae95,0x2ea9cc29,0xc9514447,0x21f92b91,0xfb9bc669,0x31159c2d,
	0xb477ce3d,0x8ae1216f,0xb9391ceb,0x38813a13,0x3f3f7d73,0x17951155,0xf881bf11,0x8b098c8d,
	0x8a977023,0xea611d5b,0xb8378199,0x3771c053,0x05517ad3,0x22bb101d,0x1d83660d,0xe621d525,
	0xc52b1d49,0xfe41f9bf,0x9cf11fb9,0x4a2d4acf,0x7fc9979d,0x99bdecf1,0xc37db8b7,0x324fee21,
	0x23b71f29,0x5217dbe5,0x9f8756e3,0x39e7c5f3,0x116b338f,0xc56b955b,0xc9d720e9,0x1a012029,
	0xf43d13b9,0x73f5e197,0x0e9b4335,0x9a4fbea9,0x3b7752df,0x011bbf65,0xb66f14fd,0x222d2467,
	0x333f8d79,0x146bc11d,0x6f4f5d45,0xe999025b,0xbdaf3e4b,0xda9d8999,0xd5a7b7cf,0xca43c487,
	0xabbfb35f,0x268d6941,0x9d451a2f,0xb0773ef3,0xb6552309,0x32411b03,0x5a6378b7,0xac357ab1,
	0x173fe0e5,0xffeba151,0xeaa18b8b,0xa21ba2db,0xc22db2d7,0x5add4329,0x7e05b391,0x9c751191,
	0x3dbf4607,0x7897a913,0x4001ff75,0xbc357cfd,0x1c79c3eb,0x39bf1a19,0xa06d50b3,0xc9f5444f,
	0x15c5873f,0x0b25d8d1,0x3c89a089,0x66f9dcc1,0xbef7f103,0x66bda05b,0x67ff64fb,0xde295e95,
	0xe44f5d85,0xf4a54159,0x55dd15db,0x95173215,0x81ed3955,0x4c255ef9,0xe19bd1c1,0x1d01dc8f,
	0x5ce13653,0x54ab4bef,0xf81b230b,0xe3c5ed5f,0x3c1ba09f,0x46cd077d,0xa0a5e4e1,0x84ef0ae5,
	0xc17bd3a5,0x4d475a63,0xa5e94831,0xbab11f8b,0xe2c5cf19,0xc60313f1,0xdefff8b1,0xeee5a6c3,
	0x02a3ebf5,0x230d66fb,0x186761e5,0x6c0d1a05,0xa9abb17b,0x6b9b66df,0x9d09140f,0x2e557dd1,
	0xdf57ca3b,0x5d0da483,0x5f354943,0x548f0eb3,0x230f1903,0x2be9eb53,0xc1a58a53,0x31330e39,
	0x051dedf1,0xe4db1e43,0x007973e3,0xfb65afff,0x5fb35b69,0x6dbb34d5,0x3a399b59,0x1fef26a7,
	0x2ff3ab13,0x26875809,0x18d393e3,0x3243d0d7,0x0edbf2e5,0x2a651f6d,0x1aa11379,0x7d7b8643,
	0x4a5bca1b,0x30a3ee19,0x7b6537d9,0x355904a3,0x9e471e35,0x0db96fa9,0xbd45eb8d,0x47497cb9,
	0x8d5b2801,0xd4433543,0xd1d16ae1,0xcb5b3f4d,0x5a3b8091,0x96097291,0xe303e8ef,0x154d8a2f,
	0xa0735641,0xc4f9dacd,0xbc395495,0x657b753d,0x8d77c1b3,0x34279db1,0xd33d3d7b,0x39f5ff55,
	0xb9a33ad3,0xb8d38481,0xf141d90d,0x3f6b3b5f,0xa13d2dd3,0x6b652f0f,0x7bd92787,0xe2379d4f,
	0xbd6fb031,0x886970ad,0x5e0738e7,0x7f5b671f,0x3d4f55af,0xf195cd37,0x913391f1,0x358335cd,
	0x5ed92557,0x4ec91617,0x462fb139,0x55ffae63,0x67f1ae7f,0xcf092735,0xae33b413,0x75cb4af3,
	0x3f633dbf,0x8985c409,0x63dd1b9f,0x1e894797,0xa5e331fd,0x7e939491,0x7437b1c3,0x1f83af6f,
	0x0f0f7161,0x38af4251,0x07af8e31,0x7eab89a5,0x1a69fe63,0x0d83b555,0xab213b5f,0x09992669,
	0xac5dacb9,0xfedd7133,0x38cbfb8d,0x86958bf7,0xa743f669,0x3baf120b,0x61552dbf,0x8583038d,
	0x4453f0bf,0x411be97f,0xd4d1d2c9,0xd0fbc675,0x0cb3614d,0x9b67bbbd,0x0bb5323f,0x7f31cb03,
	0x726ff2ef,0x46ff9c7b,0xafe19f81,0xa30db18d,0x097b8ac7,0xb17bebf5,0xa5a15eb5,0x9d17d175,
	0x60b5bd41,0x5a9b73f3,0xb4a1a9cd,0x0c7f6625,0x7adf6311,0x1541a4bf,0xd0fdd57f,0x6023dc0f,
	0xe7a74e31,0xe87ff22f,0x0431964b,0x07833dab,0x7c9f1ee5,0x908950a3,0xf6296575,0x43cbc079,
	0xae4538b7,0x9fbdd1fb,0x16330611,0x98cb7205,0x88ffd77d,0x3fa362a9,0x640929f3,0xddff04df,
	0x4a15444f,0x91e9a6a1,0xd8c936bb,0xef87bd9f,0x98bd2a93,0xb163f65f,0x6ffd2ad1,0xff317fe9,
	0x5f150cf1,0x53137be9,0xd095a263,0x856bfb63,0x431fda61,0x071d6fcd,0x95ebfc69,0xd253f8c1,
	0xbfc9a319,0x19cf761f,0x38bb9fa1,0x3ea9c6bb,0xdde76da1,0x149f1b7d,0x982f5f95,0xfcd9c713,
	0x8d332bc1,0xdf2d720d,0x22d90191,0x89f31b91,0x9d55cf8d,0x803fce7b,0x9fafe1af,0xbeb17307,
	0x56d5805f,0x7ec1a4fb,0x9713b7cd,0x8079f64f,0xb42befdf,0xe2cb864d,0x5bcd7c93,0x12515549,
	0x3ab1cef3,0xd69b3cb5,0xb40d6e6f,0x05eff3dd,0x73ab62d1,0xe7970901,0x226b3699,0xcca93701,
	0x054739f3,0xe74dff85,0xcee52e11,0xe885f1a9,0x6b99011d,0x6c75851f,0x0fe9c29d,0xbd2df1d9,
	0x519b7859,0xf3ebec33,0x9341fbcb,0x00f1ad99,0x8a3587fd,0xa1b731b1,0x27291ff5,0xcdcb0ffd,
	0xa93175a1,0xa207da0b,0x23417939,0x52616619,0x3c41392b,0x2a2fee41,0x718f3a7f,0x22f96c15,
	0xa405f1c5,0x19b118d5,0x37878475,0x2a877a15,0x8d017ae1,0x3b2fe2d9,0x1efd8a93,0x3ba7d14b,
	0x089f213d,0x257b10dd,0x3f35d819,0x419908f3,0x463577d9,0xbc892003,0xa5d3b50b,0x11479b4b,
	0xebff4d03,0x5279e2ed,0x7febab3d,0xda45929f,0x101fbf4d,0x688f3ecb,0xe2f52b43,0x37cb563d,
	0xd1a57293,0x103b084f,0x35d1517d,0xe1bf9783,0x9183e4f7,0xec1300b7,0x39c5cb13,0xfda75ecd,
	0xcb95e3e5,0xd0d5f2cb,0xb383daf3,0x0fb73887,0x8fa12111,0x0667efd5,0xb4237ed5,0x8bc98223,
	0x9a53e775,0x28d7acab,0x8225b439,0x0661d719,0x0e3df057,0xa95dfead,0x2271dd65,0x05a79de9,
	0xccdb583d,0xef5578bd,0x81594667,0x726fb51f,0x6f95b3ff,0x19472849,0x3b93ca19,0xa933404b,
	0xe0b545b5,0x5ddf7247,0x07419719,0x2b139507,0x946f51c5,0x0cf51033,0xbceb14cf,0xeedb47f3,
	0x61e193d9,0x30892d13,0x0081e869,0x51fd59b7,0xfc0dd3e3,0xcdbda275,0x8a5b19df,0xa9938407,
	0x0adf9b21,0xc5e3556f,0x103758f1,0x7361a69b,0xe42d0913,0x576db39b,0xce416225,0x26cf5435,
	0xe4b3c887,0x3eff501f,0xb00983cb,0xa5f17f9d,0x69152491,0x785ba0ab,0x198542f9,0x4e7f48a7,
	0x66df3d87,0x9f71da73,0x5017208f,0xaadde927,0xa5875e13,0xf157ef33,0x83857e35,0xc315c203,
	0x9765701b,0xed49aa31,0x7701a359,0x0dd98823,0xd2c191d5,0x95b1ed3b,0xca25e233,0x01859179,
	0x2ac7cabb,0x511b0da5,0xe1eddcc3,0x451741fb,0x6889e091,0x6b3d514d,0x71c5e9cf,0x813d98ad,
	0xa4074c63,0x35f78b97,0xa47b99e5,0xd149dc99,0x3d214f83,0xca4fda73,0xe5495c5f,0xd43369cd,
	0x74a5288b,0x69718353,0x48cd445d,0x5d9f9e65,0xa5476861,0x7db5f037,0x9611edc3,0xc6d7e781,
	0x1ca5672f,0x3b99cca3,0xef858241,0xdfcdee4d,0x9441d967,0xe2c342a5,0x1c01de4f,0x801be4f5,
	0x4a8984c7,0x9f0357d1,0x6fc5d62d,0xb805f3b7,0xbbd11551,0x094d6a43,0x557b9ae1,0xa171c5d1,
	0xfb53124f,0x48bfcda5,0x772f3f39,0xd0f7368f,0xac35f355,0xd3a1881f,0x875f5ccf,0x66cd1e41,
	0x9a85553f,0xd05f2f69,0xa9e7d903,0xbfd73f3f,0xf4334f2f,0x1693e5c1,0x7d0fc9f9,0xc69f52ed,
	0x221fe793,0xcff776eb,0xc28b7ba1,0xe45736b1,0x410ba91b,0xb9759533,0xa87194b3,0x91d938ff,
	0x3aa557c3,0x04193671,0xb23f5baf,0x88a7864f,0x7e81c5cf,0xd61910ff,0x41e31bdb,0x93edb623,
	0x5b1bc8cb,0x6bd538c5,0xc0a7aa45,0x017b7803,0xf6d54e89,0xd8d1dc2f,0x68470ac9,0xb2cd6081,
	0xe8ff9223,0x68bd2133,0xabe33501,0xce05d637,0x72c970ff,0xa06f224f,0x4101f957,0x0eed1ec3,
	0x5853dfc7,0xdee50b85,0xc89305f9,0xb7f78bd3,0x59a17f6d,0x9e455765,0x17f30bdf,0x233dc815,
	0x4b9d522f,0x54dd2c05,0x21dd03c9,0xf3814445,0xd11d908f,0xf625d7ff,0x7f7d933d,0xe52fc41f,
	0xb3db9e57,0x13b96f7b,0x9961918b,0x3f570b73,0xdd7f1f9b,0x9e618925,0x7081acc9,0xe4b5ab0d,
	0xf0932db7,0x47091b33,0x07412ed7,0x04abedc9,0x818bac4f,0x7fc97861,0x6a65e25d,0x6c41e587,
	0xefc3be4b,0x1ce16cf5,0x5a1f17cb,0x772d9831,0xde815ae1,0x95b37bbd,0x9307ca55,0xa0c74cb9,
	0x4def028d,0xe5d13b0d,0xb71de4fd,0xb511f815,0x5423940f,0x0defd1c3,0xd6c9a789,0xa1b7ca49,
	0x76194175,0x34eb9445,0x99dd2b89,0xe709db5f,0xa0b3a50f,0x68cdc17f,0x088f0953,0xa903f867,
	0xc1c1f67d,0xffc35fe5,0xf4811d07,0x60459079,0x00f55f9f,0x99233a77,0x01bb6b8d,0x2b1dc1b7,
	0x98ed71a1,0xbe6bfdb9,0x4fab2795,0xbe7b864d,0x5029b9f7,0x243f74b9,0xc22dd693,0xf6f70167,
	0x921b7759,0x8b71e60b,0xea7f95c9,0x09d9ec43,0x28136ecf,0x41f790cd,0x90497f3d,0x56052321,
	0x924fe0a1,0x43ed49a3,0xda9b2ebf,0xd5115249,0x00f39d65,0xfc9937bd,0x18ef66e5,0x2c37c30b,
	0xed0b3af3,0xa76db1cd,0x2c25d60f,0x5d5748c5,0x518b696f,0x50fb3b13,0x8f83fb65,0x17ff4dd5,
	0x84516847,0x7803a051,0x01bb2bd7,0xaa5d00a3,0xaf1f9b2b,0x4e6b34d9,0xcde7b719,0x924fa0a3,
	0xe8a13f17,0x9a412f7d,0xb4832cad,0xae55eb4d,0xed6f3f51,0x36bd2799,0x747bc0d9,0x0e9ba923,
	0x79012a5f,0x353db215,0xf41dd1ad,0x65f15aad,0x3ebd4719,0x9e451e5f,0x0a238bff,0x1ad1057d,
	0x82efc999,0xd2835369,0xe6abb06f,0xf861212d,0x53cb2841,0x8bd1ccb1,0x1c3f7867,0x7f67a45d,
	0x626f90bd,0x7e29b73f,0x48cf9b11,0xd75731b7,0x7bdd7d01,0x98b52e9d,0x5eb37267,0x5f4d64eb,
	0xa2036847,0xe6c199e3,0x8dab4029,0xdf093fb5,0xc4b3a411,0x10c328ab,0xcbdf92dd,0x57f5b6d3,
	0x1aad4d2f,0x7d5b701d,0xfee1cad3,0x76255f0f,0x1a9160af,0x124d27e5,0xc4a7bf23,0xa1533a3d,
	0x13edf0ef,0x95890739,0xdc9382a9,0xaddfa433,0x68377a93,0xae25c1d7,0x306d490f,0x2dd55fd3,
	0x63c75983,0x855f2501,0x7d636bc5,0x61e9c407,0xb6e75df7,0x079d5487,0x9d118eff,0xca7108c1,
	0x8ebf8165,0xc56d27bd,0x6e73e6bf,0x5873b3f7,0x4e63bb93,0x7487a681,0x5ef59bcb,0x3e9726af,
	0xe7d3f78d,0x10c7a639,0x936750b3,0x623149ed,0xd4ef28a5,0x9d3586d1,0xb0ffc6cd,0x6c3b5bc7,
	0xb0877f77,0x84fd0fbf,0x465da33b,0x7a55dc55,0x6f4bbee5,0x9c796cff,0xd48d53e1,0x6fcb9ab5,
	0x38dbb11b,0xc2234c17,0x77fb146f,0xe68fe213,0xe0bbbc8d,0x1fa31915,0x3181135f,0xc03dc6a1,
	0xff5598f5,0x0ac95b8d,0xcf61b6ed,0x57139297,0xaaff2457,0x8689339d,0x763f0221,0x4f015337,
	0xd0f357fd,0x6403f6e9,0xca2f19cb,0x069385c9,0x2e595d7d,0x037beda1,0xb7a9e981,0xa809e49f,
	0xe939c3af,0xb5612f79,0xdc8be8a5,0xda415413,0xc98bd3b7,0xbb49a0ab,0x911fff5b,0x11c7ef83,
	0x12290603,0xe8f50f01,0x91158b93,0x81cd365d,0xf9d99743,0xe5496ec7,0x44858607,0xad2d590f,
	0xc4453d75,0x0b5337d1,0xa8efc733,0x976ba613,0x7b03fcd9,0xeb4be27d,0xda3b6c5f,0x95af16eb,
	0x468f1cfd,0x6b8d84af,0x3bbb5c9b,0xbfcdfd21,0x674b3db3,0x899f8ed5,0x4125edbd,0x013dcf43,
	0xce878c17,0xbb31a8e7,0xd79ba967,0xca2315ed,0x5775178b,0xef1baf5d,0x6ea531fd,0x604978bf,
	0xa03346bb,0x2e57d041,0xa13147b1,0xd021eb63,0x82c16c9b,0xdd0dc81d,0x7e9bed77,0x7dc5fa89,
	0x2e117d65,0x9b8b3f09,0x739fae11,0x55f938ed,0xdef3e39d,0xc749459f,0xd3690105,0x9f25cc4d,
	0x3925750d,0x9be5f209,0x0089cfa3,0x6a5b1a75,0x404b87cb,0xf4231cef,0x35f51a03,0xa4599633,
	0xf0ef272f,0xaaf13e89,0xf00dbc01,0xc67dac63,0x798b68df,0x9c696b93,0xf59b5249,0x27d1d0e7,
	0x1375e1c5,0x46c57255,0x00d13f45,0xee0baba5,0x7bf53b13,0x0b6f1799,0x0843d031,0x9e856591,
	0x0d37e747,0x0ff373b5,0x27f38209,0x4f3d15a3,0x774df721,0xbf076f89,0x2a4b6695,0x77e14ddb,
	0x19350eaf,0xe98b6175,0xb119a965,0x62c1c845,0xf9d37a43,0x8783ca6d,0xfe9534d1,0x3dd933f1,
	0x60f36379,0x191f32df,0x5e6376f5,0xcbcb21f7,0x10492633,0xa7b527cf,0x2e8546bd,0xb4e1127b,
	0x1c73c59d,0x66c357bd,0x8871e8d3,0x780da1a3,0x65f3812b,0xf4efcfb9,0x89fd34b3,0xfbe9d4a3,
	0xb2378997,0x3d095857,0x3e69d999,0xbfb786b3,0x6491d5e5,0xf703f2b5,0x275dc38d,0xac63f615,
	0xd73f1861,0xc9017579,0x65eba05f,0x857f7111,0x5465d39b,0x084349cf,0x838984a7,0xfa4322fb,
	0xaf118f73,0x1a3d486b,0xdb19b0c1,0x56910127,0x7c332e09,0x7581b68d,0xa1e375d9,0xd3f7d7fb,
	0xebab60c7,0x42d162f9,0x90953ad9,0x8aa577df,0x413b3d65,0x9e0fe2fd,0x2c4ba17d,0x02750243,
	0xed91f2d9,0x774def6d,0xaf81cb41,0x63e956a3,0x473f9e6b,0x13bfe1a7,0x9323be6d,0x492d9f7d,
	0xe3c540a3,0x2ec3508f,0xb781eb11,0x2f11ff5b,0x9083d255,0xbae3cd95,0x2d51d005,0x86115dd1,
	0xebc9799d,0x42c7c1ab,0x9eb3bfe7,0x634f5475,0x9dc7dedd,0xea4b6a51,0x5831c61d,0xd1933be9,
	0x319da1c1,0x0f6bf68b,0xf1bdabd7,0xc25358d7,0x8e4fee3d,0x8b4dc3e5,0x97ab1d0f,0x9ea728ef,
	0x0fc7318d,0x933fbb77,0xf3bded81,0x7851cfed,0x3fd9ef31,0x39b9cedd,0xb61d7db7,0xdabba48f,
	0x2f45b5f5,0x8f55953b,0xbe593ffd,0x3bfbdda1,0x6eab34ef,0x63df083f,0xe4695d6b,0x0dc55ef3,
	0xa79b7077,0xa741611f,0x61af7ae3,0x6e81a65d,0xd5871733,0x6a951599,0xd9f39e09,0x7a37d8c3,
	0x1ecbf70d,0x8115f4f1,0x0465324f,0x3b97ef0b,0x4dab9237,0xc12964f3,0xf49d2deb,0x3cff0329,
	0xe955d42f,0xe561bef5,0x039b56db,0xb96fbd15,0xeedde6b7,0x0d6fccd7,0x58c7a7e7,0x6d91dfcf,
	0x2a3f26d9,0xdf3765fb,0x12f3d59f,0x08bbf663,0x2f5f39e9,0x47bb2c4f,0x1155f35b,0x3de120e1,
	0xf3074283,0xdc2b6949,0x5c8f3839,0x74ab0163,0x03ef3589,0xdadb0ae5,0x2fa7e41f,0x1a5fc909,
	0x63b14f29,0xcc4dc0ab,0xa11144bf,0x92f364fb,0xffd3a7d3,0xc42338a5,0xeba1da8f,0xc9fdcb6d,
	0xcabfe943,0x422f7c69,0x579b9dcd,0x63c36899,0x74cb237d,0xb3676e15,0xc3a56381,0x8e2fabbd,
	0xc533c1cd,0x92e5654f,0xcdcf627b,0x71d1b423,0x931b9fc3,0x2af5ec43,0x9c93d853,0x42e31e1d,
	0x5e8f3e3f,0xf6019ca7,0x47cfce67,0xf24bf005,0x89831861,0x9fa11cb7,0xe1cffedd,0x7e8fa73b,
	0x30d31895,0xa5933c39,0x203fd9a7,0xe4e36529,0xa5452d8d,0x98bd317b,0xa539a97b,0xb2233c3f,
	0x8485ff47,0xfe2df651,0xe83dd8d7,0x33cf9cf9,0x7225c403,0xd01bc519,0xbf355703,0x4911e2d5,
	0x70a33551,0x9ee3b5b9,0x876f1d11,0xd3bd015f,0xda63a4ff,0x520d7a9b,0xeea3d2d3,0xc94d5125,
	0xfab1322b,0x89473db9,0x5bf393ed,0xe3e17cc3,0x46c11e37,0x9d659d8d,0xf8e7d4c3,0xf3458ddb,
	0x36b141d1,0x4167ca1d,0x5a6f6787,0xcded1a13,0xbe83a1e9,0xc375c1f5,0xc9e3a12f,0xe1ef901d,
	0x672324bb,0xeddbaf2d,0x2e039e79,0x6611a4b5,0x076966cb,0x880f6461,0x93f7a8ef,0x2abbdf9b,
	0x1d0dafe5,0x77aff9b5,0x584fbbdd,0x0b014897,0xc5b5081b,0x818589d9,0xf007295d,0xfd9b3479,
	0x57ed6cc7,0xaa7b0eff,0x51795f4d,0xc5ed321f,0x9c2b258f,0x38a75fe7,0xfd73cc53,0x45031765,
	0xa5c7395d,0x544b4cd3,0xa821e4e1,0x6a8b2e39,0x4c090365,0x48cbdc95,0x821f482d,0xc5e18189,
	0x431de821,0x65b5a97f,0x21690535,0xb7094a4f,0xd5172a53,0x7fc15e6d,0x0a6bffc1,0x3fab7c8d,
	0x3af1e009,0x11cb53c7,0xd8f57563,0x741b744b,0x95910797,0xfdd94c79,0x093ba26d,0x8c51c29b,
	0x86c5bc95,0xee1d52fb,0x60e38703,0x94f11a97,0x6a3d8ce7,0x55e9b645,0xf7f1cc0b,0xc0455e5d,
	0x2e99edbb,0x12bd26e1,0xe1d7c833,0x573fcc1b,0xce5bd081,0xad3ff3d9,0x766da4f1,0x4a7b4aff,
	0x68f157f5,0x3a3f67c3,0x3af3a389,0x6337d845,0xfbafad1b,0xdbb145bf,0x6b1381fd,0x1461142b,
	0xbacff43f,0xe1b3666d,0x21db0021,0xeb8beefb,0x0a7961f3,0x8b8d74ff,0x22c38487,0xa1ed7609,
	0x17b57013,0x68adcc29,0x42ade193,0xcd6bc0ab,0x117b32c1,0x59a97329,0x70e13a6b,0x318ffd43,
	0x01a5cd69,0x313d3ac1,0x600f07fd,0xb08b9e3b,0x45f907bd,0xf553fa41,0xcf4f3e01,0xdc39a703,
	0xa92102bb,0xbff7ec7d,0x73218ff5,0x271d1917,0x1bb10da5,0x405f2cd3,0x7e6dd621,0xb55f80f5,
	0x0d299b05,0xdbeb5429,0xcb859297,0xcdd1a329,0x64eb55b1,0x6f2135eb,0xa51f962b,0xeaef4943,
	0x1b4155c1,0xaeadbd0d,0x2f5bc57d,0x6bdb2edb,0x72637599,0x2867e90f,0x70c5fdf3,0xe55f0e93,
	0xcf6bc6e7,0xe44deaf5,0xfb491abf,0x12edcf17,0x335f279b,0xa585624d,0x354319d7,0x679fd013,
	0x5429f6f1,0xcb5dba2b,0x426f60f9,0x3f395745,0x559fea6f,0xd24da62d,0x8cf922af,0xaf231d6d,
	0x227d02dd,0x74f1bf79,0xee6fe345,0xf76ffb53,0x6567a14f,0x6d1141b9,0x78cb1dd5,0x93d9b6c9,
	0x21e7bc1f,0xd49be827,0xdf6d093d,0xecc3efa7,0xed7733f3,0x26a3ea7b,0x801b7d25,0xa8372cd1,
	0xc86d48b5,0xe06b19ff,0x0c07f6fb,0x9ae7092f,0x97112e99,0xc2551e7f,0xd0c9bef5,0x592d80b1,
	0x3a8dc319,0xb0f3d34f,0xa1612d17,0x680b5d51,0x49f761f9,0x35f9c44b,0x5f390e25,0x0e2dc411,
	0x6b4bda43,0xa147cadd,0x231f28ad,0xc4e3e1f9,0x4c6d834d,0xc9e1caed,0x064be209,0x4929b91b,
	0x3c2971af,0x6ef78ff3,0x8b5f0357,0x4ca10d91,0x6333cc4d,0x38dfc9ed,0xa7639e7d,0xc693727b,
	0x9d294155,0x5a152a5d,0x6ac7132d,0xe4f57703,0xf18d9b37,0xd043a155,0x4a6133dd,0x9d5ff35b,
	0xaccb75b1,0x4537ba65,0x08758acd,0xde1375b9,0x193912c3,0x8fe319af,0x3da9bf01,0x5efdcf61,
	0xd8134fbb,0xd56918d5,0x820f194d,0x12adc19d,0xda7fba2b,0x4a0f8405,0x361d2945,0x375fcabb,
	0xfa85c4ef,0x924176f5,0xebb58a49,0x07f51317,0x341b1d29,0xc39759e1,0x6f1dc87f,0x0cf77a13,
	0x7e1f1f45,0x05d1fe91,0x700965d9,0x0d9bc315,0x43536bf7,0xd3d1dd4f,0xca8dff0d,0xa0b9e28f,
	0x7b639d39,0xdca971f1,0x702b909b,0x5dd36afd,0x63e71b4f,0x848db8d5,0xf0cddbc9,0xae1319df,
	0xd95711c3,0x05dbcbe1,0xa3c1eba5,0x3d4d84bb,0x5019846b,0x321b9f81,0x70c1ba09,0x0afbe627,
	0x6d7b845f,0xd2fbdfab,0x38edf493,0x1b3f0abb,0x40ad8503,0xab51ecdb,0xdfcbe1ab,0xc7e15e15,
	0x1bcfd105,0x1819f917,0xf44d657f,0xb15717e3,0x0ce31f55,0x517d44ed,0xf9cb2707,0x4fb988d3,
	0xf6d74831,0x4bc97c71,0x5105d501,0x23c9879f,0x4a7f1a19,0x38733441,0xc1238af7,0x87f1fe07,
	0x5f954edb,0xa71b8683,0xa0b75637,0x214595d7,0x6dbfa089,0x4687cfe3,0x9eb9dad7,0xf07f85df,
	0x258bfe7f,0x45a38c95,0x2b8718b7,0x02ff7ef9,0xe969e25f,0x54875559,0x81eb507d,0xc3d3b905,
	0xa6b9c517,0x4571fc73,0x5013089b,0xeca91fed,0x4ebfb3d5,0x4dc7cab1,0x009b3247,0x16dfa0a1,
	0xefa50519,0xe717dc67,0xa3816e81,0xec75961b,0x6d812da5,0x50199e73,0x772d730f,0xf915565d,
	0xdb4db585,0xada96b39,0x116f8f7f,0x1b13df71,0x73f14d09,0xcbcf47a7,0x2881522b,0x9469a465,
	0x333501d1,0x7eb9c035,0xfc034d31,0xbbb77a55,0x0ed193bb,0xa3bbe5dd,0x5dfdfb79,0x4d49a561,
	0xcf5fe9f7,0xc2576b23,0x5bddc5b1,0x5c1305b3,0x8965a7f7,0x4d2fe119,0x877d2751,0xe2ab647d,
	0xb64de273,0x8315144f,0xe01ff399,0xf457e0f5,0xed6df473,0xeffd89e7,0x5b69ba8f,0x8dff7d5f,
	0x3d01743f,0x8e071c83,0x0e6b4e01,0x0737cc05,0x232b486b,0x8677b951,0xf69d6689,0x2339bc37,
	0x26fbdcd3,0x92bd3d09,0x62e36885,0xc1e5874d,0x11637799,0xfd6f70e3,0xfc81491d,0x30c7bda9,
	0xc63fae29,0x434b27a9,0x7029933f,0x1c1373b7,0xbd55fa37,0x54377aa5,0xb6f38ca3,0x1f9f8ee3,
	0x1b4f6ebd,0x744126ad,0xff5f7ac9,0xf7f132ab,0x6ac38cff,0xbca10921,0x365707f7,0x53314d8f,
	0xf52d3989,0x3cb3bce3,0x3027c83b,0x42334617,0xbbf1d12b,0xbaff5761,0x718dde6f,0x496fc7d5,
	0x115b5e05,0x16314591,0x98a5c133,0x1209b061,0xd19fec77,0x462148ef,0x65f71fe9,0xbacb1c5f,
	0x3bdb002b,0xfccf9481,0x6577e7c7,0xc9299477,0x6b0f2919,0xe75d09d5,0x377b68bf,0xba395a59,
	0x6f2db877,0x8f1d95ff,0x79c39a91,0x33c1d5bf,0x060595cd,0xda83ae9f,0x507781c7,0xd529216b,
	0xf45533e3,0x2e2deed5,0x8f27b4af,0xa883b825,0xfec1a5cd,0x2de3d453,0x81cd005f,0x338d41bf,
	0x82d5d3e7,0x1d939c4d,0x55c92db7,0x28a58013,0xb005d0d3,0xe253407f,0x22e1e65f,0xb7d75c01,
	0x60af4e7f,0xa35f942f,0x9449b9c5,0x7fd51273,0x9315331b,0x0b21812b,0x31954221,0x1ef98159,
	0x82654e23,0x282564c7,0x47c76973,0x644794ad,0x5fb12d5b,0xee218ce1,0x7249ce81,0x2067d373,
	0xaaf711cf,0x56f5d4dd,0xc3e949db,0x96ab0caf,0x2c1b04cf,0x23a762ab,0x8fe192d7,0x8e112477,
	0x8beb0cfb,0x3d6383bd,0xd2cf0495,0x023700e1,0x8d178333,0xb681aa13,0x3bbd82fd,0x7467970f,
	0xe53f87a1,0x6b7f8931,0xd51b7fbd,0xdc97182b,0xb5e596bd,0x44035325,0x4dc11f4d,0x3a613e67,
	0xa5773e3f,0x13dd1583,0xe1ef7ded,0xc603b9f9,0x9847f229,0x1c013667,0xe44f14a3,0xc16bbe27,
	0x099501c9,0x2b8d117b,0xe6ef3e3d,0xe929ae37,0x0481acb3,0x60c9b4e7,0x8447dc57,0x857bea79,
	0xbd1957bf,0x8a21be63,0xc8391c4b,0x1b3fbd4b,0xc953e211,0x272f582d,0x390d5c43,0xbcff6809,
	0xfa091a15,0x09ad5607,0x8071302d,0xfbf15021,0xd3ff527f,0x96857243,0xb48186c1,0x78ed4c01,
	0xa8e3174b,0xa6c3aab1,0x40bbee7f,0x15771021,0x504902b9,0x089dbdb3,0x6f07faad,0xc4b7bc07,
	0x80abb255,0xa073c72b,0x90b5c85b,0xfc7f8739,0xc871dbf5,0x29c9fd87,0xc77fa35f,0xc64b8e49,
	0x26e382b3,0x984f8ebd,0x6e85cb59,0x703dbfd1,0x45394bf1,0x18db9d4b,0x234d58b1,0xde1fe971,
	0x4f8df45b,0xb26b5d33,0x6ecb4195,0x7a61e4d1,0x6de5e4e3,0x87255105,0x0e537eff,0xc721e4a7,
	0xdd2be7c7,0xb557a6d7,0xdca751a9,0x8f21e1a7,0xa835fd89,0xd879b543,0x5af1a71f,0xb6c72795,
	0x00bd51f3,0x2a279871,0xd9bf9eaf,0xad2b0239,0x386b5119,0x4329ef0d,0x420b2e6f,0x7d018a67,
	0x59c9dc57,0x7c6bb74b,0x7e33e841,0x7db192f3,0x61499f51,0xf0054bed,0x8301dec9,0xa443b5c5,
	0x164d84ef,0x1a378133,0xf8a5aa77,0x746980c1,0x84134c67,0x1a63e1ed,0x83b78e83,0x917bc2d9,
	0x12cd3e33,0x941b0c6f,0xae37bded,0xef81f909,0x408b0119,0x30132f97,0x708dc07b,0xa41fdb4f,
	0xfa498f1f,0xbd29a7cb,0x5a8bf7bd,0x57ab09b5,0x94ef4a9d,0xf165bbf5,0x5c694409,0x561fd94f,
	0x6647332d,0xcaf57a8f,0x2fc3c97f,0x401d4133,0xfe053ab1,0x912fb693,0x60a7d507,0x5befe785,
	0xfec5ba55,0x75912487,0xf683e151,0x86854e6b,0x970d078b,0xd4bf9779,0xbd2dbbd1,0xc47d2119,
	0x9a492911,0x178b5dfd,0x2de9c9c9,0x7317a0c5,0x39cbabe9,0x33ebbf2f,0xf85d6d3f,0x193f31b5,
	0x5dd1985d,0xcdfb97b9,0x2b9b8a03,0xd885082f,0x9e7f8701,0xf90116c3,0xff192aab,0x7e23f585,
	0xdce1d5b3,0x986f9b07,0x3bb74597,0x33ff550f,0x7bebfc91,0x60d7afbf,0x44bfa1ef,0xd19f1931,
	0x3979030b,0x78f929af,0xc0e3dca3,0xcd39f853,0xa75114d1,0xbabb6429,0xe3378d67,0xcca5b9e5,
	0x441f36df,0x942d9dff,0x543d8bbd,0xd665a361,0x34751c79,0x8881768d,0xbadf53eb,0x22a30549,
	0x9bd11c2b,0x511b8abb,0xe56b8c01,0x8c33e825,0x959944c7,0x9e7d31f7,0x929ba8d5,0xa18fd987,
	0xce159269,0x79555b33,0xda8db309,0x55d7d909,0xbb7b4373,0x437d89ed,0x37cb2c01,0x51d9654b,
	0x76e94d91,0x58eff32d,0x304512ed,0xe503a8f5,0x3561f2b5,0x50d5ba7d,0x9e5309c5,0x9673c7bd,
	0x60d1761d,0xde7b4ef5,0x99b59a49,0x55e94b57,0x510bf14b,0x5257e82f,0x00939aff,0x4ccfb087,
	0xa4cd4909,0xbb092353,0xa07fb437,0x4f391417,0x3abd426d,0xa655c00d,0xff6f0509,0xecdfffd5,
	0xca63b7cf,0x822b7d93,0xc4c5e851,0x2227579d,0x1d35edd5,0x9da117a1,0xc249d9b9,0xa917664f,
	0xe7910867,0xc9f5637f,0x9d297ab1,0xea630ad7,0x41bb9fbb,0x9b8d8cf7,0x1701b76d,0x8e670521,
	0xc0db754d,0x4af7735f,0xf6cf0bef,0xae23632b,0x300b48dd,0x35eb2695,0x91fbe8fd,0xa4410df3,
	0xe943cd79,0x004583ff,0xf5553927,0x7e157685,0xce6bbe73,0x550df389,0xae1705c3,0x0c9762f1,
	0xe24b1467,0x476f44a9,0x32e13bf3,0x956bdb4f,0x819b5a37,0x53c5ab5b,0xecb9919b,0x23dd36c1,
	0x3bf5220f,0x0089dd25,0xe0118a6b,0x79db4873,0x4cdf9a63,0x1f634e15,0xf5c19cdd,0xa101ac93,
	0xb4c342ed,0xae238dbf,0xe40b772d,0x1b93355b,0xf1f5c1af,0x57bdc441,0xb7936463,0xb579780b,
	0x59b5d7f9,0x95514f3f,0xfc6fd14f,0xf54779ef,0x11237759,0x6f237ee9,0x8711f187,0x2d357d57,
	0xa64ff6af,0xdda372f1,0xdd5d846d,0x2c27ee9d,0x492b6719,0xca651797,0x3f9bba25,0x8ea77121,
	0xa4930907,0xb12b429f,0x517b38a1,0xafe90c4b,0x574de129,0xe0d9f057,0x63154095,0x3ac37891,
	0x0d036d7d,0x5c7da093,0x59e9f283,0x5abb8c67,0x374b7a43,0x5c4fd3af,0x39dfb3b1,0x8cf9c951,
	0x66a11709,0x6eaba795,0x4e49b32f,0x114f08d7,0x4367aba1,0x391794ad,0xf2dd8ed5,0xfb3b498b,
	0x26ed2d27,0xd9434aef,0xfcbd183f,0xe2db9c07,0x546572fd,0xe607aed9,0xc37139d7,0x35fb2feb,
	0xd1ebabcf,0x105df66f,0xc9e7fbcd,0x290d80e1,0xe185f291,0x646de63d,0x077ba915,0x482ba39b,
	0x1a1d037d,0x2a852e5b,0xd0eb1471,0xa817b2cf,0x208b1117,0x681de763,0x615ffd69,0xb73d5c43,
	0x0085b929,0x00d32f7d,0x03679549,0xaeaf8dbb,0x25b519c9,0x776be757,0xd9fd2429,0xa325420d,
	0xf4a5064f,0x4ed38f23,0x497fcdeb,0x36036e0f,0x03c95c61,0x0b25439f,0x00b97733,0xe6530da3,
	0xf47f78e7,0xd29bdb13,0xa1d7ca71,0x01c750b3,0xec09cd19,0xae9f2249,0x0b735cdf,0x35b9e831,
	0xac93936d,0x6cbd3997,0x418df379,0xc02d7315,0x4e35a4ab,0x1fab11dd,0xf68fe807,0x40c90b5f,
	0x97e76cdb,0x4049097b,0xb447ae19,0x29e5f31b,0xf88f0051,0x6e9ba963,0xa4ef7807,0xd1776159,
	0x1ff950a9,0xd2d18209,0xfc25fbed,0x22236f33,0x37d981c5,0x1e412869,0xfff358b7,0xec3324c7,
	0xbccd5ed1,0x2c69530b,0xb1c91b0f,0xd699a643,0xf757ef41,0x43ef16f9,0x177d6271,0xefef80d5,
	0x14e32bcf,0xf7a344c9,0x24532619,0xdf7717b7,0xe0c9d37f,0xa777e599,0x41f39a0f,0xb61d312b,
	0x1d41609b,0xa18fd80f,0x7969b423,0x5f71a379,0x7c711db9,0xe32b8d55,0x3c33d0ed,0xb2af21f3,
	0x39655ab1,0x79bfe625,0xcd2b78c9,0x23b929f3,0x5113c1a9,0x83dd2fb9,0x499f44e3,0x14190fd9,
	0x5b55cc0b,0xd24740d7,0x523de425,0xc3ff2c0d,0x03ef5789,0x28dfb6cd,0x541b404b,0xe3492805,
	0x238f5b21,0x1fb7526f,0x71bdc2d1,0xc2796b35,0x78c7bc13,0xa403751b,0x0c09b9ff,0x23b5a821,
	0x011742ef,0x1921bdb5,0xeb4fdde5,0xabd38953,0xf1dfb083,0x199bc5ad,0x0849f55b,0xf34d7e59,
	0x516df2ed,0xd81bfdf5,0xf5159aff,0x3745a8cf,0x2ff77a8f,0x2077ac0d,0xe63f2237,0xaa85e955,
	0x8097af15,0xf8b106f9,0x5bb39c35,0x667d0c95,0x92518473,0xe1ed7445,0x69cbfced,0xfc4b1841,
	0x29132fe3,0xb979e509,0xa2476021,0xa5afb80f,0x36b1fce9,0x39cd52e1,0x9d516e59,0x1615cac5,
	0x33e74251,0x1b855cf1,0x2277e1e1,0xeb8d0f29,0x1957772d,0xd66704e7,0xf1b12bd1,0xbfd3f10b,
	0xf89167d7,0x02638bf9,0x2c63390b,0xd9497647,0x35058af5,0x58916fe5,0x5e4f5735,0x7bf74bbf,
	0x5d137671,0x542b87ed,0x26ab39bb,0xda93f259,0xa2ff747d,0x739941e3,0x810d1ed9,0xa7730c09,
	0xf5f33897,0x196bff17,0xae75148b,0x459fc8c7,0xbb05b47f,0x0d53916b,0xbe4b5d99,0x99bb7395,
	0x26310d43,0x9d35d841,0xb761f695,0x7b1d1f7b,0x3359b037,0x5e137d87,0x60ed3ad1,0xc4bf748b,
	0x3f4d87f3,0x8d1dd2b3,0xab91a971,0x06419cdd,0x40bf515b,0x10a7cdc1,0xba55ca59,0xd4f15195,
	0xa14b109b,0x19332639,0x8ba7333b,0xbcbd07db,0xb677a627,0x62639225,0x4261ac8d,0xd1433ddf,
	0xdaad83b9,0x1409231b,0x0ec5768d,0xdec3e7db,0x26438157,0x431bc339,0xb779ae43,0x3b27fd11,
	0xc875d247,0x12b3d225,0xc28dd281,0x370324c9,0x00671a21,0x751de20b,0x3e7b68d9,0x2e918355,
	0xb625a1bd,0x8cc394a1,0x2b23c2af,0x3ab1a70f,0xb3a3ac41,0xad3d9823,0x82cbe227,0x81f19557,
	0x7dbdec17,0xfc49c457,0xe3257f33,0x297ff797,0xcd3917f3,0xb2cd578b,0xd6492c89,0xe6396841,
	0xa7c39fcd,0xfdd75393,0xbbb79ca7,0x2d9ddfcb,0x18ed81ed,0x7f9ffacd,0x515906d5,0x06db41b9,
	0x8b353fdb,0x70816d1d,0xdc7dac25,0x7bc10995,0xc0fff36d,0x600564f3,0xf2db7c69,0xa9c917ed,
	0x6d9783bb,0x95d91443,0xe397db45,0x73199f5f,0x6e31fa29,0x12d12189,0xc033851f,0xcf773187,
	0xa2ebf763,0x31edc4cb,0x05a59423,0xbd57ec11,0x67c7485d,0xe9550495,0xe543a54d,0xd2d5c5af,
	0xadb19b53,0xab5512ff,0x2dcd1d59,0x6eaffb19,0xb37f54c5,0xe763caa5,0xd46b8dd1,0x89559c0f,
	0x5eef8481,0x2b1d4bab,0x1daf3a01,0x25d3385d,0x35a1fa97,0xe34db8c1,0x668fbc03,0x62e9acd3,
	0xf6237c67,0xbcdd1419,0x8d6dc9b5,0x2bf51049,0xd0e91991,0xa5e33c73,0xfb0f19bd,0x8a03c0a3,
	0x4151a101,0x6ea10a11,0x4ba9688d,0x94c58fc7,0x869d35e9,0x0a7b8bc5,0x97cf9d5b,0x039710a9,
	0xbcfb04c7,0x70ff63df,0x5d850f25,0x5e770441,0x967d185d,0x1ee54541,0x0931e9b5,0xcf15e691,
	0xb4234eb5,0x3709904d,0x1ea3b297,0x91bd9ba1,0x9ecd6e23,0x43710ff1,0x0215ee25,0x066f3c83,
	0x60495a45,0x964fd6a3,0x6125e47b,0x61c90451,0xbc4d68f9,0x4af53b61,0x3bdd8685,0xfe175d2b,
	0x0973d76d,0xe6e3f6ad,0x8dad72ef,0x4c4b0d3b,0xaa3f5f17,0x9abf5f99,0x966f1b31,0x64ff83b1,
	0x261feaad,0x2359c8b5,0xc35f0889,0x397745c7,0xe2676b35,0x4aa5fd21,0x382740ff,0x649b7bbf,
	0x7b51ccfb,0x08c1dd83,0xf7d9cc65,0x9bfd9de3,0xbd050c91,0x44f51d07,0xaded594f,0xc0db4181,
	0x3c8b6bd1,0x36af1e63,0x1741021b,0x911305f5,0x90dbc6e1,0x6685f0d5,0x0b1f31f5,0xf831a19f,
	0x2bcf092b,0x4f336d1f,0x2435a9c9,0x00670ee9,0xd32bc263,0x9ea37291,0x099fa54f,0x638fd945,
	0xb99ddb83,0x16e143ff,0x57db2005,0xbc2b8a29,0x37b96bcf,0x0f2304c7,0x29d13a35,0x5667361b,
	0x24fbadd1,0x94c955cf,0x41d3bdeb,0xa115299f,0xd0c5145d,0x2c591283,0xd297c401,0x3eadb64b,
	0x9b677f8f,0x327f2dd7,0xe83f7915,0xb6531fb5,0x2f1391cb,0xdd13af4b,0x7151028d,0xc4d1a881,
	0x58e524bb,0xdc13cfe3,0xe7c1839b,0x4d99bf55,0x81e3de51,0x9aa5372d,0x99e34235,0xebc54be5,
	0xc7f7e5c9,0x2017583d,0x937bec19,0x23171be9,0xb6f7b8a7,0x90e1eeb1,0x26adfbd1,0x30fb7021,
	0xa19f1fb7,0x4f9f9baf,0x150f3da9,0x7d83a959,0x9a91440b,0xbe19a2e1,0x589374bb,0xac671561,
	0x0d5de3ff,0x9e3dc781,0x8c9f1fe5,0x4e09dc13,0xf775a835,0x131f4947,0xf6f75ecf,0x30770c4f,
	0xc1379899,0x4201017d,0x30cdf6e7,0x5061c8fd,0xb6e3b15f,0x93459fef,0x6fb97865,0x6a219611,
	0x21ab9801,0x937d07f1,0x6ebb8347,0x2ab9c583,0x009f7041,0x745dcd5f,0xf73d2c57,0x00d50455,
	0x61bdd12f,0x2dc5d1a1,0x0a0d8221,0x8dc50791,0x5ae9da19,0x3eb900a5,0xa86331ff,0xb6855945,
	0xa2ef679d,0x0e692ddd,0x3ce14d0f,0x54b7458d,0xca83689f,0xed2b1149,0xa48f2d39,0x87a5e789,
	0x15415349,0xb57d646b,0xd7dd7a2b,0xa5415663,0xf2afba0d,0x0d031f55,0x33a34e5b,0xcb25f24b,
	0x173900a7,0x4591d597,0x621f7c0d,0x0f93d17b,0x3531311d,0xde173353,0xe3fff245,0x52754d37,
	0x55d5f0b7,0xa3b79a2b,0x394d41d1,0xae61aec3,0xd2499509,0x72b7de4d,0xaa85424b,0x898bfc75,
	0xec9958ed,0x9783236f,0xb187d711,0x46dbe6a3,0x08bbb189,0xcfb3d9cd,0x0299d44b,0x96d9d4af,
	0x8587c349,0xeb07db2f,0x356f03e7,0x68b51203,0x35c7f6db,0x0c61a7df,0x0e1d4a9d,0x7b4d1b11,
	0x7921ae3f,0x8ad3c3b3,0x6627eceb,0x8e210a51,0xf52f19b7,0x72913309,0xb573f41b,0x325d2543,
	0xee692ccf,0xa5f917c7,0x3b51b339,0x3bd18973,0x4135b357,0x9e936e59,0xc7796c1f,0xd1f9f971,
	0xfadf866d,0xce0deab5,0x230f146b,0x20f5c9d5,0x929de175,0x9f3df557,0x19973a85,0xaa93ee43,
	0xc289d719,0x171fc845,0x22030a9b,0x37412661,0x00a7e64b,0x15ddac0d,0xa7ab73a5,0x671d4ae3,
	0x97e5af49,0x37c354c3,0xf34f6c61,0xe2e7ba81,0x6115c893,0x56475f05,0xb4195859,0x2d0be6fd,
	0x1bf7b3f7,0xa909ecf9,0x28978cdb,0x1299021f,0x682bf387,0x86cf634b,0xe7c1f5fd,0xbc4bcab9,
	0x5e413e9f,0xc685462f,0x49f9db9f,0x5f8779a5,0xc8a9d6e1,0xc0433665,0x7207c667,0x8f53cec1,
	0xfcc3fd39,0xee470e31,0xf61984c9,0x2d653dfb,0x53d386db,0x2df71e61,0x28cb4ff7,0xfb133c41,
	0x44039241,0xa0e18b49,0x021b10f1,0xca63ac8f,0x19675c2f,0x2dbdc9c5,0xa871c581,0x4eff6ce3,
	0x4eff34af,0xa1673c3f,0x999f0533,0x8f370347,0x87ab9417,0x6fe7ef9f,0x73dba661,0xf5056acd,
	0x273b4fff,0x156b785f,0x5ec58329,0xff0f008f,0x8b61f04d,0x1747ef77,0x14695e73,0x919b90ad,
	0xe4b9242b,0xa4fd0f71,0x8a33e8ed,0xe79d8351,0xafc9570b,0xd92f7159,0x39ffe60f,0x23b129ad,
	0xcdfb65ab,0x9aafe9c1,0x0b097119,0x81172af9,0x3ea5730b,0x1d7105cb,0xdafd6211,0x24b91175,
	0x7801dd79,0x0395a819,0xa6e9d2c5,0x8e2bf76d,0x60375387,0x1e5fc5d9,0x5447c3cf,0xa8a5542f,
	0xe6510911,0xcf3f43c1,0x19f5e18d,0x7c0de917,0x3b430c3b,0x08cbf30f,0x893d6927,0x7de9ce87,
	0xaae9ba6d,0xefc1ae87,0x36cf2d8b,0x826da0e5,0x1509555d,0x1c079775,0x03c3bc71,0x4d75cda5,
	0x064db805,0x79ab72af,0x0699a359,0xc37f003f,0x714b2ba9,0xc9e52595,0x143bd489,0xbab9af33,
	0x077f5cd3,0xc4115309,0xe8f72c11,0x6bf5c90d,0x324d7059,0xd6b71879,0xf18514c7,0x83ad815d,
	0xac013853,0x8883eadb,0xb4074d4b,0xd3013dbd,0xb8cf8927,0x794d93ab,0xd905cd05,0xa0bda2cb,
	0xffd3ae7f,0x03154def,0xd46dc923,0x9a53c135,0x0413004d,0x7afd0335,0x2e9bd99d,0x64df62a9,
	0x3d7b97cf,0x1257a891,0x6d4d3e31,0xce1f76e1,0xd1dd2487,0x5797bba3,0x9cab4369,0x9d81a09f,
	0xedf7e13f,0x575bdf8b,0x7847c793,0x0517e2ab,0xbe6da90b,0x5d6b99fb,0x3417dfc5,0xb2996cd7,
	0x08cb2c47,0x55b53027,0xe57b9cdf,0x806b88fd,0x64854595,0xcd4fa3cb,0x8c3ff089,0xc697a7fd,
	0x13f96ee1,0x9375d02d,0xbb8fb231,0x4bcf8ec1,0x7d69565f,0xfa91a71b,0xe305c40f,0xd66fa339,
	0x4403938b,0xb92f8de9,0x37a35823,0x5d755961,0x00d97c25,0x6b05da75,0x3ccd5533,0xd98fc037,
	0x9be91939,0xb1f37023,0xed59dbcf,0xb60f2ec5,0x45173c1d,0xf6ff7ce3,0x8479eb4d,0xe1ed111f,
	0x0d2fb369,0xcb555627,0xe6d326cd,0x80cdd55b,0x1ee7a003,0xe94d75ef,0xab6bba37,0x3bf9f89b,
	0x97d9ea15,0xd56597bf,0xc4b35f39,0x33633409,0x0189d613,0x1f43f5a5,0xc983824b,0x8ea5c9d7,
	0x6a65b9b5,0x42b7a533,0xde1b87ad,0xae03f23d,0x1ebfd103,0x28b5148b,0x3d233065,0xfb65687b,
	0x01d53345,0x485ba74f,0x60ad1f43,0x5b5d17dd,0x86cde80f,0x67f173af,0xcb2f7ddd,0x3e27e8b3,
	0x49af1c3d,0xfde51f5d,0x708bc193,0x50a5ad55,0x487376f3,0x31cbdc99,0xbf09908d,0xcd612f27,
	0xbbf38e99,0x7d638725,0x4859c6b9,0x6d8d5b8f,0x90f37de5,0xed95e153,0x0a919acf,0xfa039101,
	0x812198d1,0x036df0f3,0x5935e34f,0x7c450bf5,0xcc1141a1,0x35217c67,0x662b7b7f,0x0f7f73ed,
	0x903ddde1,0x0f11a791,0x6ac5c86f,0x51818871,0xc40deb63,0xf4c1b0df,0x70b95df5,0x73c7ee13,
	0xcec93541,0x81e1ce47,0xbb27c3b1,0xec731b6b,0xc1a928e1,0x8b472a47,0xcf9b5a0b,0xc74f661d,
	0x30c74aed,0xbff100e1,0x1f015f31,0x96cd2fd1,0xac27cc59,0xea05dca5,0x4eb3141d,0x05073337,
	0xd8b93f5f,0xcfd1f3a7,0x21730189,0x04bff109,0x294b6c81,0xb4cda487,0x00655d01,0xa2613d09,
	0x379f478d,0x7a951367,0x241d8dd3,0x74fdeb01,0xbd570497,0x61f1e6f5,0x5d93d215,0xaf4f9bbf,
	0x2cfd4cf7,0x6bcd2565,0x7f2503a9,0xd0b9aa1f,0xeb099451,0x5a413179,0x659d7d33,0xf6433801,
	0x26d58d93,0x518de771,0xa12b1f23,0xcba35b4f,0x53a7bfed,0x1913da1d,0xbe6774b1,0x1c316af9,
	0x41a93bdb,0xfc65afd1,0x2f51f8dd,0x03ef6bfb,0xd6f17021,0x4c379f6b,0xd4537b6d,0xc0899e53,
	0x687b1ecb,0x7f670d51,0x253ba5f1,0x224f2a0d,0xb32b722b,0xf3fd486d,0xfa41a0bf,0x9d3dec37,
	0x74cd31db,0x50276739,0xf507d7f9,0xf9f363ef,0xa51517c1,0x833b44af,0x8993e083,0xa6bfbf51,
	0x4e9f4507,0x66b79d55,0xa7597d0d,0xa8910889,0x07f1d721,0xff3f4c39,0x022fc30f,0x2c0172c9,
	0x0c759cc9,0x5da7a7ef,0xfb535fc9,0xb657c749,0xf583eb01,0x1fdfff93,0x2a71fd41,0xf677f249,
	0x13539219,0x920937cf,0x8699c747,0x35f7b015,0x6609f29f,0x6f6987cb,0x2f411071,0x6a1159fd,
	0x36b53271,0x43715641,0xd5491721,0xe4a5d35b,0x504b91b3,0x6ab33669,0xc3fdea7b,0xa541968d,
	0xd8a3dfcd,0xb3ef050d,0x8a096f6f,0x4a13e201,0xc9851075,0xa10b2579,0x428785b5,0xa0f90525,
	0x099df0a7,0x4817de7f,0x7df94ccd,0xd873cd73,0x257dfba3,0xd445d781,0xcb4388fd,0x50ad136d,
	0xa8a34ff7,0xa6f9b561,0xe0b92855,0x0c77679b,0x1673c475,0x18b5d78f,0x6513e7ab,0xc24bdf8f,
	0x83391d37,0xda2734fd,0x586f17a1,0x8d4f02e3,0xcd2b60a3,0xf5295929,0x1d57819b,0x3e49d837,
	0x75634c63,0x6db5811b,0x21bb6cc9,0x4caf1235,0x18e5ea6b,0x82f5d85d,0x27f3c325,0x67975c8d,
	0x899d45f5,0x9035d607,0x2fbf5669,0xa6c7c8f9,0x87634085,0x8debb9b3,0xff494523,0x5ba75c3d,
	0x18ef86e5,0x32b72889,0x4c1d7f9d,0x824bbb1d,0x84e7a629,0xb45dea35,0x84396cef,0xd26df76f,
	0xead940af,0x28cdc5ed,0x36f7aff9,0x706d7d09,0x7c356315,0x871d7f6d,0x1e250c63,0x3e571ecd,
	0x555bf94b,0x488bf3fd,0xc6f16b9d,0xccdf43a5,0xf68d6381,0xa97d5767,0xdaf101db,0xec5b3381,
	0x5cf92b33,0x8a819101,0x0929931f,0xddd1845d,0xbbb3d827,0xf14fb8a9,0x8effd82f,0x23e9a739,
	0xd4b5e565,0x29c3b3c5,0x6143039b,0xf3f7951b,0xf1e7d641,0x86e5f241,0xf52f66bb,0x46f59c19,
	0x7e116b55,0xc3e14b93,0xa96336ab,0x8a834c49,0x3debf787,0x0511fbb7,0xcee57155,0xf1ed84cf,
	0x290fd501,0x78efc033,0x5227e269,0x6725a0d1,0xe301fa37,0x99231515,0x0403485b,0x1bc7c483,
	0xd42faee3,0x0b7d91f1,0x82b5996d,0xba134a1d,0xe2ed6109,0x22f166e5,0xc2e968a5,0x35f34ee1,
	0xcc7799f3,0x009ff995,0x38ad6ad3,0x3df96017,0x1def1337,0x54cba231,0xa0791b8f,0x4c634811,
	0xcd65ebad,0xbfe5886b,0x68318235,0x580ffb27,0x72cbfc7b,0xd383a083,0xb81916ef,0x2589a4bd,
	0x20fd4e09,0xb361c83d,0x1be1c7ad,0x3803d43b,0xdebfad0f,0x566903e7,0xcba51d23,0x6259ca11,
	0xbfc15f83,0x67a7db55,0x94e37fd3,0xf809e4b9,0x9d93f9ad,0xc753d6e3,0x63859d03,0x9e412db5,
	0x70b15313,0xabc91c7b,0x6ad7ebc3,0xbcd3068f,0x49839b8d,0x628f2c85,0xee9751eb,0x8f37f5d5,
	0xe9539035,0xb155bef9,0xabdfe917,0xd5919423,0xfb55d06d,0xd6f3c055,0xe23de3b3,0x25ab9919,
	0xeda552e3,0x2c636e9d,0xfc9f91e9,0xdbf70861,0x6a49fa85,0x65cd965d,0xda5b86b3,0xac8f7eab,
	0x702b4b93,0x737fefad,0xb835dcd3,0xd4379eb3,0x0c21408f,0x02f19b27,0xb9539bcb,0xe9579e37,
	0xb1e73f45,0x9fc1bef3,0x10453ced,0x4d01f301,0x35212dc5,0x74b343bf,0xc805504f,0x3bf31fe5,
	0x625ba76f,0xacb5b1bd,0x2cf341d3,0x7f8ba1b9,0x380951e1,0x73e12dab,0xd5d53e1d,0xbed5fc61,
	0xbf89520b,0x987195d1,0x4cdd379f,0x6f83e7c3,0x861de11d,0xcbcfbef9,0x58a30b8d,0x66ef9cd3,
	0xb5f10195,0x8387d179,0xe529c6e9,0x0b1b4287,0xcf1b5433,0x7a4fc62f,0x8cd30b79,0x23b37ae5,
	0x00970d05,0xd1070381,0xc17594cd,0x4b070ff3,0x2149085d,0xcfb31a5b,0x9547dd3d,0xff13c0c3,
	0x48fdffd7,0x4683a333,0x23e7e2e7,0x52792e6d,0x0969df55,0x8ecd3b05,0x9b5f0cb1,0x3d83e915,
	0x47253a05,0x2c0fa059,0xe51f2f4b,0x8f239ce1,0xb2bbdf57,0x0ceff039,0xeeffb22f,0x7df35f05,
	0xe1919007,0x6c3d033b,0x943fd499,0xd9351ab9,0x0701d319,0x51ebea7d,0x26871291,0xd9d51e3f,
	0x4d43ead7,0xb41d8ca5,0x96e9a9e7,0x9365c7df,0xce7de9d7,0x381362dd,0x3edb3f33,0x051d52eb,
	0x2dbbe7f1,0x934155df,0x493fa2d3,0xcadfc4bd,0xcff3574b,0x8c39bae5,0xbb5bb5ed,0x6e39f9b5,
	0xb4fd794f,0x9bbd70b5,0x1de36f71,0x575bd23d,0xf0a3f3af,0x2daf1c9d,0xc5eb0119,0x5e1f7fc5,
	0xc38d8569,0x82218771,0xbdf71c61,0xfb07f1c7,0x544fdbbd,0x2e471a8f,0x4eed5791,0x183f62c7,
	0x08678739,0x3d7f7cdb,0x291db2bb,0x82970549,0x7d3b10af,0xf2534fc5,0x2d413cb1,0xfa8bd0e1,
	0x21132e3b,0x276d0c3f,0xd579d817,0xe53d6f29,0x6c271841,0x50a3ffc9,0x3e4b2051,0x9d7548c3,
	0xb991fe69,0x1bf76967,0xcfa96e91,0x64a9b255,0xc0559ca9,0xb28db6a5,0x85ebfecb,0xf3f13991,
	0xac61f03b,0x99b3e09b,0xdad334c3,0xad0f1233,0xd7890ca3,0x33e1e8e3,0x4e8500fb,0x6b6fa2f9,
	0x228710ab,0xe1b376a7,0x909565c5,0xf52132af,0xee033b69,0xc2ef938f,0x48fb1c39,0x0bdfb525,
	0xb3852137,0x178588d3,0x81155933,0x1e0fb833,0x3e8500b5,0x408ddc31,0xacadb25f,0x97b970bb,
	0x855d37d3,0x61416ceb,0x52f32327,0xd38de7a9,0x2253d8c3,0xa009b0d3,0x577d31c7,0xabe946eb,
	0x6c915efd,0x07751139,0xe34f343b,0xabcd467b,0x312d8449,0x073967ff,0xedd1b54d,0xdfe5b959,
	0x0c2135af,0x95339c87,0x65cff989,0x47813a91,0x6155a883,0xee6b60bf,0xfa85a447,0xe59bfa33,
	0xf5938f61,0xf80f0e1d,0x84937ca9,0x71d9aa59,0x278f6f2d,0x4073a29d,0x0f015293,0xa9818c21,
	0xc8e5140f,0xa019ddc5,0x803d03b7,0x40899cb9,0x971b267d,0x7aa37da5,0xe323a08b,0x7287e24f,
	0x549be031,0x9fe39bcd,0x4fefb14d,0x33c1d91d,0x81bbe12f,0xcccf2a5d,0x754d9b05,0x02210065,
	0xb5b724c3,0xcc8190fb,0xc14d2485,0x56378771,0x97b3167f,0x394569d3,0x2a631b5f,0xb43d1a8f,
	0x77bbc73d,0xdd855e9b,0x987518f7,0x5d19d01b,0x87c34223,0xb4d9258f,0xedc76773,0x9f513575,
	0xb4a7019b,0x8cff9e75,0xb00b06bf,0xc81b7c07,0x1f2d8457,0x46dd0f9b,0x5159d197,0xb44dc641,
	0x34ff0255,0xb78182d5,0x1933c277,0x016d949f,0x69b541d7,0x29234281,0xad7d58a9,0xdea3529f,
	0x8fc78c67,0x7c1f7683,0x3b8b1d39,0x7dc303cb,0xd199c3d9,0xe7fde14b,0x41154801,0x244710b7,
	0x4a7b9749,0x5c6bbccd,0xf539849d,0xdc4f33f9,0x3fa1d81b,0x823db783,0x5181d779,0xc5a78733,
	0xf923eef7,0x5c731177,0xbadba2c1,0x06c3b011,0x3b0970d3,0x8935d935,0x4aa3cb6b,0x5db92d3f,
	0x5e3fd3e9,0x22cf48d1,0xb797fe3b,0x514fc37b,0x099744bf,0x40b742e9,0xdedf14b3,0x01ed0a85,
	0x8acf9b1b,0x188befa1,0xed0d9a25,0x9aa71a23,0xcf8d6f15,0xbf1579a9,0x271770a9,0x6235572b,
	0xfe594e07,0x893feb33,0x535f961d,0x6bfd6075,0xafa90f91,0x0d1f2aff,0xc2ad0927,0xe9051bdf,
	0xc6db4aa3,0xc2f7194f,0xf92fce39,0x1901e357,0xeb31ea6f,0x462bccf5,0xf77f1489,0xdb4bd1cb,
	0xa0d9e36f,0x3649f041,0x239f7b15,0xdfe73035,0x01e50867,0xb8093e15,0xd1f575a7,0x787d0295,
	0x1755ff61,0x96471ed3,0x6e51d1cb,0x0961b4f9,0xd20956b1,0x03096569,0x44ed5bdb,0x1a8be86d,
	0xa3cfb9f3,0xf8812c4d,0xeb67a3f5,0x089f600b,0xb85d470b,0x3a01d27d,0x49cbe2ff,0x55e70df7,
	0xce4d0321,0xf509187b,0x4385ffab,0x9b554059,0xb0236fab,0x023f5d59,0x006fb36f,0x1985ee61,
	0x4d4d3f65,0xc673fba7,0xd5c9cf89,0xe9b5254b,0x731f2b4f,0xb399c685,0xcf3da203,0xced39555,
	0x25d3e7b7,0x69cfa699,0xd7d97aa9,0xa6713ec9,0x998f392d,0x785d570f,0x83155015,0x79c73ef9,
	0xcb612991,0xbeb1429d,0x75d384a5,0x2eb9bd3f,0xba3b5d03,0x6d61807f,0x6f5bcb7f,0xd8d1f7fd,
	0x3ff986ef,0xa729f17d,0xf25d2d95,0xaa417199,0x8a5fff09,0xc1f37ce1,0x8def2e9d,0x84e33d85,
	0x341b764b,0x27cb6d81,0xc6951215,0x2b3b6d3d,0xfdc1cbf7,0xd7e7eebb,0x9f374047,0x11719d3f,
	0x26cd029d,0x87a7a975,0xc221cb3f,0xce57a217,0x66a1550b,0x6391811b,0x4a0f13d7,0x2c6b5553,
	0x858d6b5f,0x705170a1,0x2b218ead,0xdac98291,0x95c3affd,0x8bbf8787,0x3bdda927,0xbe41f46d,
	0xcc5fc48d,0x0dd906d1,0xde37ce77,0xe243a195,0xfa671705,0x09c59e0d,0x48838c93,0x09e9f9b5,
	0xa5c596a1,0x2ed1c84f,0x6e85d93b,0xe0f7528b,0xc24f88e1,0x49754935,0x8a6376f3,0xccd574d7,
	0x0ac17e93,0x644dc9e3,0x45ad7a0f,0x5d954961,0xf9bd68c9,0x89219609,0x825deda1,0x5ef3a5fb,
	0x62d3cddf,0x21df78d9,0xc3d1988d,0x89513a7d,0xab751e77,0xf99bba13,0x37d3e279,0xd2b99dcb,
	0xa3ff2a7d,0xdd973afb,0x5f93d8d3,0x5fdd7acd,0x00b7b623,0xde35b35f,0x58a953d3,0x1517dd73,
	0x72c92ee7,0x30070e91,0xc6173b77,0xc7699fb7,0x6147808b,0xacc1e873,0x5941ec89,0x0d7ff69b,
	0x422f0a19,0xf4432a67,0xfafbbd95,0xb0a91f27,0x9365b2e7,0x2d91c85d,0x947ba3f5,0xbde32b6d,
	0x73b51f8d,0x67db9dc7,0x7865f8c7,0x36cfef87,0xdbd306f1,0x9b776aa5,0x6bbb5df3,0x62b50e95,
	0x775ba73b,0x4ae3f079,0x4ef3c327,0xbf8b27c1,0x1dd35ae3,0xc3c32f55,0x66e38adb,0x92e9233b,
	0xeba74d9f,0xffebc2c9,0x45cbcf4d,0x1b119f3f,0xfb295175,0x264b5ef7,0x5453c787,0x5fef7d0b,
	0xbd97d3b1,0xac056d81,0xfa8b4c55,0xa4138de9,0xf415f1e5,0x155fca95,0x68ed7d51,0x75b9602d,
	0x48afaeed,0x56c5a1e9,0x015985d9,0x5fc32c2d,0x875b47eb,0xd5d16bb9,0x60178215,0x3ab9e14b,
	0x76f1a94b,0x0a3d09cd,0x04d583f3,0x1dd152f3,0x523903c1,0xbef1046f,0x9badb82b,0xefe38591,
	0xe0df8147,0xf2fde775,0xe621ab3b,0x98711ba3,0x30751a21,0x5a95bf3d,0x4417ae6d,0xd0a5e2a7,
	0xed7b89d9,0x8017b5ad,0xdcdf5ccd,0x94558029,0x5c516445,0x850bcf31,0x68334035,0x32f53eb9,
	0xf2454a7d,0x831fc7bf,0x97319643,0x00adfaef,0x8e8d3fe7,0x8d290fd3,0x1d63355f,0xa743306f,
	0x53431f2b,0x5025e973,0x59b991b7,0x172d26df,0x1e6b2f41,0x543da52d,0x9f8be243,0x18833ef3,
	0xa2f3d85f,0xddbdff15,0x1f9b65c3,0x7c075f63,0x21ad790d,0x6e1b9bc9,0x710dc7bb,0xec2381f1,
	0xc2595b13,0xe4f7a56f,0xba75a57f,0x5deb6065,0x8c97c885,0x411788b3,0x7ac93323,0x22194191,
	0x00f540bd,0x0167d1c9,0xf26b0087,0x960de64f,0x51e9cd63,0x25ff2971,0x2c23de53,0x74d5967f,
	0x3ccd775d,0xd11d71ef,0xa621e2f5,0xc81f4e0b,0x82e5dbe1,0x88270411,0x9afb8fa5,0x794909e3,
	0x025fe169,0x14ad0c2b,0xeab51561,0x82533501,0x6f4f8cb9,0x05610719,0xa3b5b9f3,0xbee73567,
	0xacb1f5db,0xcf275f45,0x2bcd5ce9,0x5d59191d,0xc5675d25,0x8dff2997,0x09331c99,0xefa36337,
	0x8541602f,0x661d0289,0x4b891b23,0x1c65f8cb,0xb1f14edf,0x84d30b13,0x94d5636d,0xefeb2dfb,
	0xe413a05f,0xc1a305bf,0xc28bee29,0xcd29f2f1,0x002b8821,0xdf2f9399,0x367fc6cf,0xfeb520dd,
	0x4fa9aae1,0x6c499133,0xbff35099,0xe7d5e6fb,0x39dbf3a5,0x44e593af,0x2491ab93,0xd5735789,
	0x9d0388b5,0xb32385af,0x49673989,0x6f1d14d3,0xc743e0a5,0x30476461,0xfbef4317,0xc8131e29,
	0x0fa7f751,0xc5c11c7b,0x5b07bc97,0x1033bce3,0x0f23a2db,0x0e27873b,0xdff92b31,0xe5099163,
	0x799308af,0xd6378763,0x0775a9d9,0x42c9c013,0x96bd3281,0x5dd74645,0x9a950e41,0x15493e65,
	0x5b4bc34b,0x391590b1,0x97d52de9,0x690f3fd1,0x21d3cc51,0xd1295409,0xbc1f431b,0x3c43c2d9,
	0x03d1c21f,0x856f3b2d,0xabc571e5,0xefb93e05,0xd2a99187,0x6c6f6b91,0xbb7d6d1d,0x57e96ce7,
	0xb0a7d4a3,0xb4d56223,0x59693b63,0x6df73d17,0x49ff27d9,0xa679f067,0x16111c1f,0xa0addb39,
	0xadcd9ed3,0x435b595d,0x4d658c7f,0xc57fdff3,0xc7175983,0x889d8e95,0x6fbb6c7b,0xa9839cf9,
	0x75c73927,0x4f918d23,0xead743d3,0x427f8a05,0x47b5b53f,0xceabdaa5,0xb2dfa70b,0x7fdbd1d3,
	0xd199d099,0xba892241,0x6b65bc77,0xbba9ff33,0xa8192e47,0x06f3f1a3,0x305fe12b,0xcba7c9f1,
	0xf8c146a5,0x47d79601,0xff2d6e07,0xb23303e9,0xc305bc57,0xb24b1917,0xbf9b9cb3,0xef59a5fb,
	0xb143d145,0xbd8b5e2b,0xecd58c9d,0x71cbfd0f,0x91bdfba5,0x64015f0b,0xde7767ff,0x27e3f71b,
	0x6f9f9af1,0x0439890b,0xb17da8d3,0x30a59013,0x4c01cced,0xe1eb3a09,0xd1537de5,0xacb95efb,
	0x76db62a5,0x46f15d69,0x20c74fc3,0x2f7142dd,0x8813f56b,0x4457291b,0xc31365c3,0xcfcb2fc7,
	0xf8751bd9,0x1347fa91,0x84d5ab05,0xd9651bd5,0x5ab7bed5,0x161953cb,0xe5179371,0x1d8b0c29,
	0x34718e89,0x794bf84d,0xbe4920b5,0xe42f41e9,0x772d9767,0x74832a23,0x8f430749,0x7ceb8747,
	0x9951f72d,0x2b9106e5,0x6445f36d,0x70019c7f,0x4f37b1dd,0x2f6904af,0x5ff7ee27,0x4f5dc4d1,
	0xe417a6c1,0x9f298f25,0xe46be247,0x27917383,0x3319a56d,0xe919c477,0x5c194163,0x90d518eb,
	0x4045a2bd,0x2ba75257,0xa2dfc8db,0x600d0f5f,0x71930dd3,0x36677305,0x0f0566d7,0xf7c1a843,
	0x67db451d,0x2b1b0a43,0x1a3f3f45,0x392758fd,0x77e72b4b,0xbea5e263,0xaaa3d0df,0x15170801,
	0xc35fdc59,0x1a170935,0xfbaf3a1f,0xbd1579c7,0xf1d7828b,0x5ba54d1b,0x274f9e51,0x7449ddd1,
	0x89cf4b6d,0xb7afd9f7,0x4ed3aa83,0x00857ba7,0xe9a77ccf,0x39b9f637,0x63f13a8b,0xbb457fdb,
	0xe0afa9d1,0x2573dfd1,0x91c91e09,0x42abe907,0xe81907d3,0xf7b3c941,0x45e7fd65,0xca8194cb,
	0xfc01e381,0x0777f68f,0xd9375ecf,0x0d376ccf,0x146b35cd,0xc6e5fa45,0xd913cb3b,0xdcebb3c7,
	0x3e4558f5,0xa44b1279,0xf03d136b,0x545f726d,0x5463dd7b,0x8b21a5cb,0x6fdbb4e5,0xa7f9047f,
	0x58817f29,0x0503e05d,0x787d5ef7,0x96d1c5c7,0x6c413a13,0xfab970dd,0xc31b97bd,0x7b9ddf17,
	0x6a337f95,0x152f657f,0x0a198111,0xfdbf3349,0x1ec98b53,0xbe7d2903,0x123bbd9d,0x62456c3d,
	0x215fd835,0xc2e39faf,0x53b375cf,0x7cdf27dd,0x4d3bb571,0x91c3644d,0x43197cdf,0x40e7451b,
	0xda87fb83,0x1eaf2533,0x3a6d95cd,0xf25f50ed,0x1759e12b,0x625b213f,0x0217d85f,0xf6f11359,
	0xc0adf077,0x7ba5c4d5,0xf9e93625,0x46f33c63,0xfb671bb7,0x709566e5,0xe2191f75,0x7e593121,
	0xed53f28b,0x8f5925e3,0x44494871,0x8dcbf8a9,0xf625f6d3,0x6f47e4cb,0x7c818dfd,0x0b91491d,
	0x887911bb,0x91dd6823,0x622ffac9,0x249bb4a9,0xa2d528b7,0xa3bf92f7,0x912fec4d,0x2d87f679,
	0xe8a3d27f,0x5dc1c3df,0x52bf57c9,0xd3955fcb,0x5b392c1b,0x05d351f7,0x26872f43,0xedb164df,
	0xb2d3cdd3,0x901729e5,0xeb97e68b,0xed6b49fd,0x5795e03d,0x5fd18ad3,0xa9691837,0xeffdf077,
	0xfa8b5131,0xa873e37b,0xf8dd4aa9,0x6f4dc3a5,0xcea928d3,0x6e8fcf15,0x0d39d505,0x92e1c5eb,
	0x61cdfe91,0x28e5326b,0x5d2fe43b,0x20efbdaf,0x15b98e1b,0x015b78c9,0xebd9a003,0x0f4f8265,
	0x391b6c6d,0xb601f101,0x31b36fdd,0xb4836985,0xc085dccd,0x1a094a75,0xa5a9600f,0x98b5d391,
	0x9f75c5c1,0x36d73207,0xe609a6a9,0xe6b9d911,0xc14fc621,0x0ced0f27,0x818b4883,0x7d091799,
	0xa25f6a07,0xf4f9e0c7,0x6053de39,0x9ec59ebd,0x88db7fd5,0xa0d53a65,0xcce57935,0x44bbfd23,
	0x5ddb8d37,0xbc7b6109,0x1d33a8a5,0x0e596d73,0x26676421,0x2f15883d,0xfb939e83,0xd2bd235f,
	0x1c6bd7cd,0xfbef2f17,0x4fcb748b,0xd1a7b89d,0x67bb91bd,0xc37f9d37,0xc7fd9145,0x8481b9f1,
	0x771106c1,0xe4657fbf,0x01bd2d01,0x0f5f5423,0xf9138be7,0x3c65a65d,0x5301f6d5,0x51f92107,
	0x754d8b8d,0x896fe047,0x332bd9a1,0x98b51473,0x8535da57,0x6a99f939,0x4401e10f,0xed998949,
	0xad252c2d,0x0121d67b,0xfab73e89,0x09596e73,0xd561a947,0x316db3d7,0xe8e36e49,0xe45193e3,
	0x6317a31b,0x840b80a3,0xa5837c4f,0xe7811791,0xf15b696f,0xa6b35cbd,0x56036961,0xbd93f27d,
	0xaa273f4f,0x8d41358b,0xd733b00f,0xc3dba5b3,0x3f61700d,0x32bd82f9,0x8649e9b1,0x1b510741,
	0x83d78445,0xfa53247b,0xa9e59363,0x59992f45,0xa43b96d9,0xb05d5e13,0x7b13f30f,0xd9ff84db,
	0x0029c9f5,0x2b55f541,0xce3f1c65,0xae71eb31,0xa325dc0d,0x8ce36e13,0x5c4315d9,0x308b0e75,
	0x5d9ddcdb,0x22d76823,0xab5f1dad,0x3291d0df,0x7de50263,0xe8251b89,0x983d0ee7,0xd06bd7b5,
	0x29379def,0xa5edf5eb,0x7eebe657,0xe0ad383d,0x54bb3115,0xb4735779,0x03e36795,0x058f44c9,
	0x5e7ba2ad,0x5c276fe5,0x7d03e1fd,0x5df579b3,0x466993db,0xd69f3b6f,0xfa9515b9,0xd66b8a5b,
	0x8767d50d,0xef979fdb,0xf04938b9,0x1a1f8e29,0x9033faf3,0x45f9a977,0x7e371bb1,0x23ed4d91,
	0xdc7d138b,0x2cd1e815,0x59df6f23,0x6f59af0d,0xadd97b15,0x2c57ec17,0x57292855,0xc98b441b,
	0x64c3d11f,0x22e7e361,0x91670657,0xc255f645,0x799f0d7b,0x0607565d,0x344f3701,0xbd35d41d,
	0x15b9b545,0x43670503,0xe5031bef,0xa249fe3d,0x4c452fdf,0xc1dfe3d1,0xcb092f8d,0x2f5db445,
	0xf35f3bf5,0x826938cb,0x39550a05,0xe8e381df,0x1d0d847b,0xe12dd87d,0xf73b8653,0xaaf58bbd,
	0x303955ab,0x767982ff,0x297f0733,0xda57fc95,0xa1b97209,0x97c560eb,0xdb47dc2d,0x356f922b,
	0x4d49075f,0x78afa069,0x2725c691,0x45554a49,0x6e8dc3c3,0xebfb3225,0x000d9e75,0x6ebf2fbd,
	0x3a110a8d,0xc497a657,0x9a6517bb,0xa3114765,0x16494963,0xd69d29b7,0x74f1a707,0xb1559d1d,
	0x74916d2f,0x9847a28d,0x01e386cb,0x373d70d1,0x4a2f7723,0x62ffeda9,0xefd5dc3b,0x32238373,
	0x294f31bd,0x54513b5b,0x12c3fc59,0x300b83fb,0xfa0305bd,0xcef38c83,0xed19d0ed,0x209d9c69,
	0x5349ef31,0x9bc54f87,0xd8a55d83,0xc62b1ec9,0x7405926b,0xaacb1d53,0xcf9f6473,0xc6b1522b,
	0xdc037107,0x7437965d,0xd5a92bdf,0x5cd15fa7,0x84f93ee7,0xf9595fa1,0x00cb62ab,0xa8d55f61,
	0xbb7f5737,0x65b53fa7,0x22752589,0xa1af8581,0x981d516b,0x4ff15b77,0x107f23ed,0xa5f96f37,
	0x183fb63d,0x9ad793ad,0x8e29e519,0xacf58fbd,0xd737d4b1,0xf65f0161,0xd51b2d13,0x178fbd53,
	0x6745b713,0x00ab9339,0xbe6781ad,0x2157de47,0x4a8937f3,0x06fbca65,0x8b83cf79,0xf189b5e5,
	0x8c113731,0x66c39799,0x4f512edb,0x4c07d187,0xf8d1eeed,0x8e955811,0xf719c8f7,0xe25b9591,
	0xf8a76891,0x9f33f293,0xf389dcbf,0x44b56a6b,0x075511d5,0xac7f146d,0x81bde3e7,0x72f30985,
	0xcd8971af,0x9e8b8e73,0x9431d7f1,0x0d97ea5b,0xd9d7fd67,0xb28bd201,0x5bd19725,0x26c7cf6b,
	0xf9b90d85,0x9bdd8e01,0x70ed698f,0xb35b733f,0x3297f2dd,0x450b6bdb,0x9c39a607,0x9bc7556b,
	0x5ab92b8b,0x30bfec89,0x3fdb772f,0x6d33a785,0x5257b7f1,0x7acf6585,0x6057c06b,0xaa675a2f,
	0xdc898fbb,0x793d1dd3,0x4d9f22ed,0xbcd34a13,0x185936dd,0xfd2d8b05,0xec0d22ab,0x85958ce3,
	0x99af7293,0x33edae2d,0x9d5d6b63,0x8e6dde55,0x22611e5d,0x27f590e7,0xc9b9359d,0xdac72d2f,
	0xfb292107,0xe1e1e25d,0x08b3cba9,0x58b34835,0xecaf81a7,0x2977b437,0xea432e9f,0xf1edab3d,
	0xd87b9c95,0xe6a757ad,0x5fc7db5b,0x3cd76c1d,0xf2057877,0x22895a7d,0xc509af89,0xcd7947b9,
	0x97a73b37,0xa857a3e9,0x8939ee95,0x2689cef7,0xcba7bf07,0x4679b1c3,0x77ef66b5,0x4a5fb3cb,
	0x4d2f4765,0xaf7ff55b,0xa22bb5eb,0xebfd362d,0x51555613,0xfb1d5093,0xe755aeff,0x400db11f,
	0xdc13a01b,0xc731b2cd,0x1e3fde7d,0x6de347a9,0xb95122d1,0xf8c3d5f7,0xde1f2fbf,0xa079b1dd,
	0x15d958d1,0x1d011b87,0xe797b1e1,0xb76f29d3,0xb85f8efd,0x6a3f8979,0x2dad7ccf,0x981378af,
	0xda7f5983,0x60ffe753,0x7ed5b633,0x1e532399,0xa1bf28d3,0x0ce5fb23,0xcde3b689,0xadcdb8c1,
	0x3889fea9,0xe5bde67f,0x1b1b4e0d,0x62c13c61,0x87334309,0x5083a381,0xfd2329c9,0xe319b5bb,
	0x8cf9b93d,0xc051a1d1,0xca0b5889,0xcf69dc17,0x58fd94db,0x776d839b,0x604defe7,0xd3ebe3c7,
	0xa34faebd,0xe847fa93,0x8fc7d13f,0x597f6b25,0x05e1da05,0xb675c4fb,0x22c38ebd,0xd6b38791,
	0xd591591d,0x57b5ca93,0x86f3704b,0xc0b5f275,0x9b2172bd,0x54ed59ab,0x166b98a5,0x1c635643,
	0x2c3d26dd,0x2b2b8417,0x00ad4a47,0xaf3dbb71,0x647b03bf,0xcca79c35,0xd3a34c7b,0xd06d1583,
	0x7e571af3,0xc1bdd1e9,0xa499704d,0xd9c7f003,0x0c351647,0xe9f5efa3,0xd94d3597,0x38c33b7f,
	0x91616cd9,0xdcfd3755,0x90db8ff5,0x1f873a93,0xbb11b80b,0xeba95f7f,0xaccdcbd3,0xd5d98ee1,
	0x395d288b,0xc0fbb025,0x7a13935d,0xaa2d660f,0x384d1b49,0xa3153fd5,0xfa051389,0x829fc6d1,
	0x78cdce81,0x544950a3,0xcb63411b,0x0dedfddd,0x09af36b7,0x940bcd2d,0xb3553d95,0x94872af9,
	0xa0b1f3b7,0x3ff9e597,0xc66bdc49,0x6979edeb,0x93776593,0x14ddcc8f,0x319f474f,0xfb833385,
	0x708de1a5,0x0fa1944d,0xa351c485,0x8603229f,0x38690793,0x6e5b2b89,0x54499a91,0x6205291d,
	0x36653647,0x514d7a8d,0xb0b515e5,0xf73b28e5,0x79c520f5,0xfbdba025,0xa131adb7,0x4d01c4eb,
	0xeeb78415,0xb5934ea3,0x73b94905,0x3b57ce27,0x174dfa6f,0x4b2d48e9,0x64b9a399,0x3be7d09b,
	0x6485f20b,0x2f85ff59,0xc7ffd2ff,0xdb03c04f,0x2f45c13f,0x3ca14ce1,0xd1c5eb91,0xc8a9c655,
	0x5155dba3,0x14b353f7,0xffabc56d,0x89772dc7,0x5e6d271b,0x230d7b99,0x21b7e179,0xc7b970c5,
	0x7d2570d5,0x3d2f8c49,0x035b6e67,0x44616577,0xe0070241,0xe3c1ed17,0xb46f6dad,0x68098b13,
	0xde7b561b,0x238d0099,0x7233f889,0x73f576cd,0xadd5ed67,0x168da1e9,0x3051a505,0x530d60e9,
	0xba554471,0x04ddc1af,0xc1d70aed,0x0ae3d1af,0xa01be7cb,0x25c52317,0xa23d68db,0xccb56e73,
	0xc437a951,0x00b338d7,0x5e65692d,0xa661e68b,0x8d99f525,0x6e3d222b,0x9d970709,0xd3730059,
	0x3e2146b3,0x391fc7db,0xca839361,0xae1dc647,0x6b93bdad,0x5f431931,0x5c41d9eb,0x4039d3c7,
	0x1899d311,0xf2b56903,0xbf516625,0x7449c24f,0x6dc92e21,0x9aabeaaf,0xde9be859,0xe679b665,
	0x129d9967,0xb4854f1b,0x4c6fba93,0x559b0c8d,0x267d17b9,0x14c981b1,0x0b8985ad,0xb427265d,
	0xd9b3192f,0x6823856b,0xf8030645,0xd941576b,0xa671d02d,0x346b71c3,0xd06bf1c3,0xd1b3f25b,
	0x29d9a661,0x799f8fbf,0xdeadfb53,0xd0ef75d3,0x9ce9d1bb,0xf2e596ed,0x4125f8f1,0xc20fd987,
	0xed930977,0xf78b0a61,0xd38f285b,0x78d5fb2f,0x77a75b1b,0xfc09b5b9,0xb8179415,0x82ad2b8b,
	0x5de11f6f,0xb2fb4a19,0x804b9873,0x97a9db67,0x82e90f85,0xce291b31,0xf6258889,0xab816893,
	0x224979bd,0x5f81fc33,0x85037337,0x9e970ae9,0x097596b7,0xda173cdf,0x42b10823,0x8ef9e147,
	0x70c9fe5f,0xb32dc679,0x985b9cbf,0xc9571e9b,0x748b3ce9,0xa32558cf,0x8b9b5141,0x5a0b56d3,
	0x2de587cf,0x8691e733,0xa77155a7,0x3e17ebe9,0x6bef92d5,0xdf251587,0x85454ebb,0x34279adf,
	0x0c9f8505,0xf4c1d52d,0xf5e9db09,0x2d8b28bd,0xf5df0db5,0x96692215,0xca9537eb,0x5f3f2f97,
	0xae79997d,0x7b4ddfb1,0x3de7067f,0xf2e50b81,0x9721a741,0x43c3d5ff,0xfce930ad,0x57c7e7a1,
	0xc3753d2f,0x1a49ce87,0xd009ee23,0x33d7eb1f,0x72f77db7,0xf485d153,0xe423e959,0xf4af862d,
	0x2a155c97,0x744581fb,0xb375848d,0x0091df01,0x6b2173cf,0x687f9c99,0x8ea73ec9,0x87675edf,
	0x0f59f8ad,0xee5392d7,0xc5cb38d9,0xf3c75f11,0x3fe1d0c3,0x320748dd,0x7157da57,0xfbe7f5e5,
	0x0ec5c6ed,0xd007f263,0xdb2b96a1,0x52a9e3b7,0xaff9e04d,0xd5ed0fa5,0x8793d1df,0xf89b9fe9,
	0x525bd14f,0x63738a69,0xde3be5ff,0x2ceb85e1,0x98ad92a7,0xeb81f2ff,0x733f47b9,0xfe772213,
	0xb29d164f,0x1527dd37,0xf01bcb8b,0x7cbf9ef5,0x15bd1c8b,0x3c995d71,0x9cbb0abf,0x88ef520d,
	0xd68b28e5,0x9435a593,0x886de863,0x46d768e1,0xa16d9731,0xe583c209,0x52eb364d,0x2df3b601,
	0x53abd08d,0xf23176c9,0x95537a1d,0xba639e0b,0x347ba057,0x75153c4f,0xeb31d239,0xbdf5249b,
	0xcdfba93f,0xc32b5ca1,0x9b71fad3,0x5119195f,0x662ffa35,0x0c9d304d,0xe16d72e1,0x63e76505,
	0x17ffc377,0x3db77b67,0xd5e5c123,0xef257647,0x8c452b85,0x7fefea8d,0xf801d91d,0xc53dcee7,
	0x52b9442d,0x5ae5afe5,0x5653a023,0x033fb0ad,0xdb031f81,0x755f4019,0x57d39249,0x21e5ea6b,
	0x0dab04dd,0xf6492f63,0x24df876f,0xa695c4f9,0x8529c5e3,0x85bb2e7d,0xb03f983d,0x7455103b,
	0x66d73381,0xedf327ad,0x60272321,0xbcdb5019,0xdbf9b2e5,0x5c577bc1,0x572df153,0x917d0983,
	0x2abdf28f,0x42775f0b,0x5d517bd1,0x14412f73,0x6f37bf41,0xd705566d,0x68fb5065,0x48d1afeb,
	0xf463f907,0x36e5d44b,0xc7fb969d,0x857d20f5,0x2d23a831,0x2617f58f,0xe88bb4cf,0x843f8d9f,
	0x4d47325f,0x70cf5eb3,0xc24b151b,0x13bd6305,0x827faf6f,0xec5f38af,0xdf410a69,0x683d7d47,
	0xcd6d5e91,0x18494e0d,0x04e1d567,0x0cb3548f,0x7a8f3b37,0x5f3147d7,0x7cffc98d,0x73bb4a0f,
	0x3b55b219,0xf7e30aa5,0xfedf9219,0x289514fd,0xdf13763f,0x66593393,0x38259715,0xa02b4f9f,
	0xac0575f1,0x9cb1b545,0xf5e7824f,0xaa112439,0x584fefc3,0xbc2f94e9,0xed97e45d,0x817f1a21,
	0xa2fba791,0x7643c735,0x261bf99f,0x7e5b02ad,0x8d013b7d,0x0d832d67,0x00b78f3d,0x662b0641,
	0x323d98f3,0xf6adb241,0xe21d0825,0x5d23d143,0x426f91a7,0x19a78715,0x7b65820f,0x771fe127,
	0x1a499093,0xb27f80b3,0xb30f1a79,0xe89df165,0x7c5b6efb,0xd26d947b,0x2e0353ad,0xd7cd887d,
	0xea23696b,0x80cd7553,0x789399b9,0xcd7ba4fb,0x9d0334b3,0x7c2750a7,0xcf77e773,0xc6278a6f,
	0x1f4b32f3,0x9b27ab6d,0x88cd8b7b,0xe2efae71,0x852dc889,0xcda55f23,0x1d1d0d39,0xba9fc5a5,
	0x45c7d125,0xbda1b6cb,0xd05b31db,0x4aa9f0b3,0xb41b34b9,0x103dabf5,0xfadd2159,0x8829094b,
	0x18159c7d,0x46cb43b5,0xf261ab73,0x90dd0f27,0x678b47f9,0x3fbf0ba9,0x9315acaf,0x7c33b509,
	0x9f3901f5,0x57b7b6f7,0x6883935b,0xcc3d0db9,0xbbc33585,0x2a7bdb4b,0x76a70491,0x7eb35909,
	0x52b72305,0xf3f9cddb,0xa2e1a131,0xbdf9f0d3,0xcb853517,0x9147a063,0xbcf7eadd,0x321955f7,
	0x388b75a9,0x21a13e29,0x281b490b,0xf1c75d5f,0xd00f22eb,0x4771a8fb,0x23e72ded,0x13597cfb,
	0x053d6459,0x0943562d,0xb5575b83,0xddd338c7,0x41271fb7,0x52cfab9d,0x2fd74897,0x99e1afc1,
	0x3bcdee11,0x15ef9caf,0x5e35a5b7,0x02d548f3,0xf50f30b7,0x0baf6753,0x4bab0239,0x57a78071,
	0x4dbb4649,0x153970fb,0xacd7913d,0x0bfbd451,0x4085dfa7,0x3ce543a7,0xe8c30eab,0x191bd1b5,
	0xbb0b74fb,0x5731aadb,0xc1dfc431,0xeef941c7,0x16cfdabd,0x43c5f0a3,0x9f03ae49,0x052f76b9,
	0x323ff6a5,0xce6b3a97,0x746fc12d,0x0c01b8c3,0x29af94b5,0x301d06d3,0x4ccd4de9,0xbd57d325,
	0xb0595c3b,0x2ff7c8fb,0x722b874b,0x4dc3c12b,0x0963e4cb,0xe441a73f,0x370126e9,0x7d817b23,
	0xa0dbeb3d,0x13695751,0x5f313223,0x4973e36b,0x44b1a6b5,0x35031b71,0x2903df21,0x3c23d35f,
	0xfdc53d9f,0x12d1df61,0xf62599d1,0x5ec3486d,0x88db5aaf,0x09b57573,0x94b328ed,0xca2db103,
	0x6f9de1e1,0xeac1f377,0x282bf2ef,0xd7e3599b,0xc19fc575,0x7c292fcf,0xb2756323,0xf311f9b5,
	0x6d61faf7,0x9a4d5e5d,0x3ce16e97,0x098760dd,0x3943903d,0xf8b1cd8f,0xa1293921,0x9cc343a5,
	0x5c95e061,0x8305c35b,0xf26dda63,0x72e128a1,0xb887e8c5,0x5e1f7a3d,0x863342c1,0xe7b17577,
	0xb139be13,0x88fd3e3d,0x9d6d406b,0xdda39bcf,0xa6af2143,0x1dc5a9e5,0xad75a459,0x4ed16659,
	0x0dd3348d,0x32c5034b,0x4907874b,0x7dfd65cf,0x297b5073,0x5b75b90f,0xa94faec7,0xc7937df3,
	0x6363f8c5,0xc971ff51,0xd6db121d,0x12a3928d,0x452df191,0x0d818cc3,0x72a57f63,0xe1e95471,
	0x11697435,0x78917799,0x1f0b6079,0x04c72e75,0xfc898453,0x1cb9328f,0x88d7a007,0xe845527b,
	0x05e964d9,0x6e39a9ed,0x1039ae7b,0x8819e66d,0x70cf2cf7,0x8473807d,0x11c9a70f,0xff9b513b,
	0xdd657d29,0xfaf96c95,0xcf8794bd,0xbacda7e1,0x01c15435,0x727fb513,0xf9dbd751,0x475b3a5d,
	0x02df0421,0xb1e3ce5b,0xd897a859,0xc59540bb,0x6da14745,0x672d175d,0x13f1c02d,0xf977a809,
	0xcfd7753b,0x888bb68d,0x1d8b1ae9,0xfba3ff63,0xf133d7e5,0x555396e7,0x396ddd77,0x8a6184eb,
	0xac53206f,0xf70384f1,0x27075a85,0xfaa752c7,0x67b9fc4b,0xc2416bb7,0x6a2f378b,0xc90dac2b,
	0x2ed1ca37,0x17dbb1d1,0x3429b1c9,0xcad56a4f,0x6af16f35,0xe5c7b65b,0xec9b0345,0xfee98973,
	0x3c554b8f,0xc8256dfb,0x5a95e7cf,0xfeddd5e3,0x73214fd9,0xca391fdb,0x6d9141fd,0x0febb8ef,
	0x286131f1,0xc77542b5,0xa66fe031,0xd3f525f1,0xf709c1f5,0x6c6b79c1,0x2075618f,0x9a83a747,
	0xd4f75f55,0xd7dbb1c9,0x3a573b07,0x51cb8b5f,0x8bed8dc1,0xdbab5e19,0xdf29dc53,0x17a331a7,
	0xd297aa35,0xddebd583,0x6f6df4ed,0x6a917799,0x058dbff5,0x59cdcf69,0x4a0dd921,0xfabf45b7,
	0x80477d8d,0x00b500ad,0xf55706fd,0x1afd3c89,0x962b49cf,0x7b25d8bd,0xe805cb59,0xd1c581a1,
	0x2b8578d7,0xc9cb5e91,0xf23506d1,0x8a3dac99,0xee89a107,0x46812da1,0x467112cf,0x652bd411,
	0x3055100b,0x454192f7,0x22a9c683,0x2a05bab3,0x5deb5fd5,0x5535ca1d,0x19359be1,0xd7e11c2f,
	0x19392ba3,0x21a95a29,0xf9d5f4ab,0xd6851a3f,0xf211e4f7,0xf31392bb,0x5ab17f67,0xc759c9a5,
	0xbf33c89b,0xd01328f5,0xc15bbc65,0xf671df2b,0x973ff3a5,0x3e6df485,0x6bc9a2bb,0x6b877c9f,
	0x69c3986d,0xa411cca1,0xb95d654b,0x9afb1ddd,0x38355399,0x48158505,0x33df57b9,0xb6dba5c7,
	0xeeefa111,0xf3b70af7,0x387df375,0x9fd58b43,0xde35710b,0x335da247,0x40d3fcb9,0x76452643,
	0xd335dd03,0x37954245,0xcbdfc77f,0xcb2f1cc3,0xd101fcb9,0x561712d1,0xe7099c95,0x713befc1,
	0x6999db3b,0x2abf0951,0x57213e85,0xedbda849,0xb6dd8bdb,0x5895a5b1,0x61618ea7,0x89afa46b,
	0xf39d5f35,0xeac5cf65,0x3467521b,0x02b1843f,0xb489382b,0x55a9d26d,0xf13f16c9,0xdc0f36e9,
	0xc14100e9,0x17bb7c4f,0x54553861,0x4fbb278f,0x8d493fe3,0xfaa55913,0xfe830557,0xdf518a65,
	0x510bccd3,0xf4311053,0x5e0b03ed,0x8511c9a3,0xc2dda5bb,0xa759e22b,0x37915729,0x84e5128b,
	0x6ff9e3eb,0x853b4441,0xcf2943db,0xdd5f0265,0xb587d0f1,0x8e1b9ec1,0xb14bd59b,0x58bd7383,
	0x598f1bab,0xb269295f,0x1bd5a3c5,0x3ddd6a3d,0xc4092d3d,0xd3bbe85b,0x0711b685,0xa14b21f7,
	0xd7cf9e11,0x65cdc979,0xceaf8bc5,0x56393a19,0x6ba7cad9,0xaf89e105,0x7ac73c3f,0x7f830313,
	0x633b8991,0xabfbc6d7,0xa8d9c073,0xc0a7eb5f,0x6821fe7f,0x8b5b134b,0x14cd55a9,0x0ed30c7f,
	0x42d5912b,0xd405fc45,0xc1f502ed,0x21d9d7fb,0xd3bb0169,0x237f1235,0xc4073e17,0x8531e467,
	0xac1d9c55,0x8f791d0d,0xa825b0c9,0x48ffda57,0x47339151,0xa6cb194d,0x7dd71d67,0x530d8173,
	0xe3196709,0x126f54f9,0x800b6421,0x4fcded5f,0xf9cf9071,0xd68dac9d,0x5e1da7f1,0x435bcacd,
	0x5a4721c3,0x3375e851,0x24c99393,0xba75cc77,0xe151a583,0x269938af,0xc73bbe8f,0x9b893821,
	0xd2ab117b,0x8b9dd3df,0x48033235,0x97a9938f,0xd1f9dbc1,0xdd43b28d,0x82170e9d,0x3b8d7197,
	0x7bc72fad,0x96796cef,0x91d74fa3,0xa0995f0f,0x9e8942e5,0x335937c3,0xde0fb1f1,0xbdd7efd9,
	0x139bca51,0xd21d014b,0xc0ebb7f7,0x58f9ebe1,0x38438f29,0x742fae57,0xd105cee9,0x97599c13,
	0x06ad23e3,0xdf1b773d,0xca5d93c9,0x2ef9376d,0xceebb947,0x1d9764d7,0x175d385f,0x37856fef,
	0x8ffb135d,0xa083ed8d,0xf9d30837,0x9b4d1fa1,0xf0c19e79,0xffe3b24b,0x53f70da9,0x284f1593,
	0xd909a437,0x5be95b87,0x116dd6d7,0x412702e3,0xaa87a079,0x5de7963d,0x30395aa5,0x2e2587ad,
	0x19d9b66b,0xd95b30f3,0x69cbfdc5,0x0e39601f,0xa7814581,0x0cf158b7,0x7bffb7ab,0x67fdb167,
	0xb8ed9e75,0x8371f61f,0x12135799,0x5ab576bf,0x516fd84b,0x94d52a45,0x4db1e997,0x6f470e69,
	0x6b45c54d,0x8739ebcf,0xefe53b71,0x094be6ad,0xf0950811,0x4fe3c3ed,0x222b81bf,0x77f74add,
	0x5467486f,0xf445ab53,0xdf631ce3,0xa72d5053,0xcbb1888d,0x8af1073d,0xfcd57e01,0x707be36f,
	0x265199d5,0xdca9c671,0xd32f2c0b,0x8c11f49b,0x4809b1f9,0xa54f9e3b,0x878de8b5,0x21c9c547,
	0x41871ff7,0x74f56773,0xf46df581,0xfa2554ed,0x095f210f,0x30cf9b75,0x32b778b7,0x4f51ee0f,
	0xd50bd5cf,0x343df127,0xc2bb0263,0x3e1dd337,0x11f1570b,0x11c319f3,0x5533315d,0xd7050bf3,
	0xfe5feadb,0xf4119ed3,0x343d7847,0xcf2b51df,0xe28559a3,0x9efbdd41,0x4c630285,0xd1571d9b,
	0xe983630f,0x10832441,0xd597b949,0x6effd3d1,0x9a5d5313,0xc1cdf165,0x9c2d6889,0xb13b1233,
	0xf0fdb6e9,0x88274dbf,0xe9e70403,0x49cd1c79,0x17373215,0x16094aeb,0x0eef0c3f,0x64216963,
	0xbdcb7363,0x1c0fa013,0x8ad3138d,0x16474fbd,0x155949e3,0x09ff66df,0xd58b6305,0x71fbd355,
	0x6771d9f5,0x6fcbf887,0xc879bf85,0x359d9209,0x4f85f239,0xfe85eac9,0xa7654eb3,0x1d3bd0b5,
	0x93f1809b,0x296d2ce7,0xc97f9c01,0xd383a847,0x9ef9274d,0x66e944b1,0xe25fbda3,0x82d352ab,
	0x97cdf1cd,0x1189ab7d,0xeb05999b,0x062b97df,0x1b7b29db,0xe9014b25,0xaad94ab1,0xba375ae3,
	0x96054c85,0x332f1b11,0xe0ada571,0xee4746bf,0x3b4d1f1f,0x7d1bdd2f,0x0bb7dd35,0xf5559b85,
	0xa01de441,0xfbf3faf1,0xd4994919,0xd7071b4f,0xf32db0cf,0x8e0b8255,0x16594909,0xa0a3173b,
	0xd619e0f5,0x5be542e1,0x876b4aaf,0x561f9c77,0xd661ad27,0x19250aa3,0x02a3ee87,0x8311c131,
	0x8677df1f,0xe5970331,0x70454ccd,0x6bbf11a3,0x36aba6e3,0xce372ea5,0x4ef75a8b,0xde131d0f,
	0x4e398fb9,0xee1f04a7,0xdcc96e8d,0xa29d22bd,0x44499539,0x2f952f63,0xe035e66d,0x8d97df01,
	0x38e5583b,0xad09688d,0x1119eb87,0x2fe77831,0x2e0173e5,0xb2117665,0x21c15807,0x28138baf,
	0xe07bf2a1,0x5c6b48b1,0x67d9bbd9,0x13515ae5,0x4113e323,0xdcfd35b9,0x257b81b3,0x1e771843,
	0x8d7b0d63,0x58d75759,0x72273417,0x370b5443,0x0943c7a9,0x6a2b07e9,0xc3c7e24d,0xdc358a69,
	0x56e9eb7d,0x415b7f4f,0x17a9a561,0x8fc9ce39,0x70d1eab3,0x65ed8ffb,0xbb85452d,0xe7419849,
	0x42470467,0x178f83df,0xb67dfd4f,0x3cbdb32f,0xe07f99fd,0x4f15197b,0xd219622d,0x0009488d,
	0x6397a41d,0x5f81a0d3,0x434965f9,0xa7990e0d,0x5f9147bd,0x36f53875,0xf3657da9,0x41839261,
	0xfd5b8b19,0x3fc32a75,0x692de5fb,0xa48daa41,0xb3c72ab1,0xe15f6971,0x51c90877,0x411ffd6d,
	0xa0938e51,0xa1672d8d,0xa9cb006f,0x924db3b1,0x8163de0f,0xe4a5b177,0x86293ff5,0x2ecf41dd,
	0x4cc33745,0x50030f67,0x7d4554ed,0x7a0b56c9,0x6b290195,0xc9973e15,0xafe5cdfd,0xf507e859,
	0x8fed63eb,0x19a32dcb,0x723d3f91,0x2f776073,0x3259d979,0x2b8b0553,0x94e168e5,0x58b5ea0b,
	0xa693e6bd,0xeedd7f05,0x4dd578f5,0x70c5de1b,0xd6b5ee79,0xd85165bd,0xc17d738b,0x194f509f,
	0x9bb726b7,0x02c331df,0x2bafb633,0x06a7bda5,0xb67fadcb,0xf039c659,0xa89f9d47,0x10c5d63d,
	0x68dbbf51,0xeae54da1,0x9ded48e5,0xe44d6d81,0xae7b092d,0x061936b5,0xc3a381f3,0x53898591,
	0x15ff2087,0xbf555217,0xcd31bf23,0x476d7c97,0x39eb16d7,0x3f410ed7,0xb26f49eb,0x508f59c3,
	0xd9a72ed3,0x3aa7d78b,0x989f8389,0xd8333a4f,0x928db181,0x73818f4d,0x5b654a07,0xf145de7d,
	0x38d7e32d,0xd9eb2ec5,0xb5d57d31,0xc9575697,0xd0a71869,0x4d2d811f,0x0b67a3a1,0xb9a1cfeb,
	0x270beb0f,0xfcb50111,0xd0f9afb5,0xf80781d5,0x0af98f45,0x6919d5d7,0x95d3e493,0xe813bab5,
	0x264b4875,0x0515f039,0xaca9db2d,0x0bf70cf5,0x76c7fe53,0x7693477f,0x7491a739,0x958f9c07,
	0x6717f1d9,0x779f3685,0x420b1c37,0x97598963,0x87d1924b,0x576ff8a3,0xe7ff326b,0xd5838189,
	0xe86f7233,0x1b6346c1,0xe0bf8be7,0x36dd6905,0x10595c65,0x40011449,0x17011983,0xd5e52965,
	0x97d788fd,0x19f56c35,0x4ee7dfdd,0xb1b99e47,0x6121f25f,0xd7176dff,0x2ef7dc5d,0xff23a247,
	0x7151ca35,0x1f656aad,0xe9230a31,0x19993c11,0x696d0e71,0x560521cd,0x83c5874f,0x1433eb57,
	0x9f5f3e4f,0x7a451e73,0xc299d97b,0xeab515d1,0xd6fd2f53,0xa89d343d,0xafcb5337,0x52879441,
	0x9b030249,0x3ba91c4f,0xc4eb98d7,0x2bbb5f6f,0x36153843,0x8d313259,0xb3ed456f,0x920d5d2d,
	0x4bbfe79d,0x5723518d,0xd037afdf,0x8ddf4d53,0x117510f9,0xb493d1ab,0x178dcfcd,0x653bd6c5,
	0x27931443,0xc2c3a3f7,0xdb2142ab,0x8cd3b469,0x125f45af,0xe215903d,0x088b70af,0x39010235,
	0x5303a2b7,0x971b91d5,0x12cbd1d9,0x8ec7aa1d,0x2095a71d,0x0b89549b,0x7b4b52ed,0x74d1f125,
	0xc11141f1,0x2f3fd1f3,0xfad9da7f,0x046f2455,0x825bea81,0x79410dcd,0x4aadede1,0x9a9d65bf,
	0x533fd56b,0x48bff39b,0x8d697637,0x88fd997d,0xfc714993,0xe60f535b,0x5815a567,0x66d772af,
	0xf98f1523,0x23affe95,0x5b21fb1f,0x0221a07f,0xf21b228d,0x9f450553,0xab6369d7,0xf0731b1d,
	0xd2812d8d,0xa29f132d,0xab1f9bcd,0xc00f90c5,0x85199829,0xa4b3ec3d,0x92fb580b,0xc8e1f2b5,
	0x4b1b5fa9,0x6aa10a2b,0x9b09075f,0x9d792237,0xb5ad31a1,0xc8af5925,0xc3bf595d,0x1c13bd9f,
	0x3edba0eb,0x034914dd,0x3eff0969,0x1f910d43,0x82997aad,0xd009c591,0x790fc3a9,0xd07b1085,
	0x17c53b53,0xf6a95d07,0xc1a32a0b,0x9607aacf,0x0921a38b,0x9211738d,0x94cff947,0xa70df093,
	0xee5b6d55,0xf151a4f9,0x84174ddd,0x3b0f9449,0xa50520f3,0x189d0da5,0xbf5f0911,0x5b397371,
	0xa99d09f1,0xe253e779,0x3dfd55f7,0x535b4397,0x10874c1f,0xbffb46e1,0x87a34e63,0xc2ef5f4b,
	0x1f11189b,0x1b43f7d3,0x1d77bff5,0x4e1bb325,0x846b02c9,0x57017acb,0x82fd1113,0xeea5cac9,
	0x32b57553,0x703121cf,0xe72745ef,0xe503fddd,0xd7f1472b,0x3efd4d6d,0x6d4d257f,0x494dbd15,
	0xf70d708f,0x57b1c9b9,0x162f7e83,0x3c45ff29,0xa0dddfff,0x8bc34b51,0x48f78c81,0xb855cddb,
	0xcd1b6f49,0x0ad30c5b,0xfc317cc7,0x0291f2f3,0x536ff87f,0x23a78981,0x7edb136f,0xbbb3c543,
	0x84618afd,0xa52b5efd,0xe1517057,0x911b15a5,0x6269c065,0xdf774589,0xfe5df427,0x8dd73bf9,
	0x7ae131a3,0x44c92f6b,0x242d454d,0x0b954427,0x5f0d0beb,0xaa87856f,0x5d5d7501,0x43b33b25,
	0xbd1bc5b7,0x2a4183ed,0x59eb4443,0x80319be7,0x191ff3cb,0xa2a9b7c1,0xf83f88d7,0xecb9dc71,
	0x26133e31,0xd8a39b51,0x6e2bb251,0x079f1acb,0xbedf753f,0x382f5387,0x11e56f05,0xb2ddea09,
	0x7f4bc68d,0x35818cdb,0xc30d7113,0xe5133f41,0xfd0f1201,0x4ded784b,0xf3af5363,0xfa8f7e95,
	0xa0c55ec5,0xa8efe85b,0x51379ea3,0xa63fa82f,0x1ef3704b,0x59318e17,0x0d7fee4b,0x82bfa53f,
	0x91037b51,0x3d7d5617,0xc7c93599,0x4353b501,0x2e4bfad7,0x81cfe577,0x15bb2497,0x84e5f9b3,
	0xa507a52b,0xc03f36db,0xac65ad13,0x3f0325a1,0x135980df,0xc2175771,0x2941a7a3,0xd4ed4819,
	0xa05119cf,0xe0c543ef,0x7b2d98a7,0xc681ba79,0xb4e1d61f,0x06dfe593,0xeb739547,0x014b2d1d,
	0xd4e56b37,0x51232f1f,0xc6c34871,0xd17fd471,0x182372cd,0x4f7759e3,0xa63517dd,0x72f3b5e7,
	0x43451fdb,0xe5e942b5,0x5849690b,0x422d14f7,0x80e313a5,0xcdb1e6ef,0x69e9063f,0x8d550023,
	0xba7352b5,0xb62b0179,0x4f63a38d,0x053ffdf1,0x915f59e1,0x05dfc7bf,0x2d6f83c9,0xce63d9f7,
	0xf7f15341,0x3b79c6b7,0x422f3d93,0x31e591cd,0x6a5d6b3b,0xeed1dfdf,0xee2ba053,0xee916213,
	0xc7c14579,0x71e76639,0x5d51b937,0x29d5f371,0xcb1f91ed,0x11dd5b55,0xcffdf837,0x00cda79b,
	0x2463c1d5,0xf805cc47,0x83ed7513,0xb93d0649,0x3163dcb3,0xaad34ead,0x3d495451,0x928d4a3d,
	0x56db7551,0x2ee59dad,0x6fa14c3f,0x36cf0e3f,0xf96fbec3,0xc80356f3,0x06ef49f9,0xcbc11a23,
	0x16abc165,0x5a1bd7b3,0xd0933659,0xa3c14fbd,0x7e05afd9,0x6a4339af,0x8453db09,0x8edbb7f3,
	0xa9d55c0b,0xbfb77027,0x6d63e777,0xcbc1afad,0x3863cc2f,0xa4e184e9,0xb35715db,0x98cd34dd,
	0x04dbefc1,0xc84df54d,0x43337035,0x65035379,0xe04f7481,0xbdb32f2f,0x585bb549,0xa10bb285,
	0xeabdbb7b,0x1eed2df5,0xa5a3ddab,0x3037410b,0x8c0bee05,0x4d07378b,0x1e43c0af,0x79850319,
	0x0d0132b7,0xd12bb965,0x5ed9d975,0x1893fecb,0xd0550277,0x5db14583,0xb6712be5,0x2ead4941,
	0x2ba59d6f,0x6f17af69,0xcf7549af,0x53c533a7,0xe073a013,0x8d054923,0xf8c37747,0x27759829,
	0x352db81b,0x2b454049,0x0e9bf0ed,0x81ff4705,0xae25798f,0x2ad11af7,0x03a14fab,0x454f9379,
	0x669b53b7,0xfac554d1,0x09e90e4f,0xcdf700d1,0x09afa627,0x59691c07,0x5be92e6f,0x042f0f5d,
	0x6b6ff5bb,0xb52b2e4b,0xa583fd6b,0x0cdb2975,0xc1d14197,0x2d9fd5db,0x0cfff96b,0x9a83b07d,
	0x7daf7823,0x3487067f,0xdc0bd65f,0xde5d29db,0xc3cd0c15,0xcec59a81,0xc8c3a2fb,0x19418c03,
	0x85d9a967,0x756bafb9,0xdea50dc1,0xccb3ab6d,0x3b670a5d,0x96ad2483,0x0799c9f7,0x8bdbc79b,
	0x3af1ec83,0xb6eb34c3,0x34ef14ab,0x6c8b3815,0xb2df25ab,0x31a936e7,0x286159b7,0x183f396d,
	0x4279d8ef,0x9a9778e5,0xdd0ff8bb,0x7d19da3d,0x32f7cbb5,0xbe8b3d39,0x907f2a1b,0x1ee30823,
	0x5073daa7,0x4483d7eb,0x6ba50407,0x080dbccd,0x62f38eb9,0xeea5eb85,0xcbd59f77,0x5ab54ae9,
	0x4761d223,0x7b3fc61d,0x2bd15d2b,0x819dcb33,0xa893c56d,0x25c9de51,0xacc34aa9,0x012ba969,
	0x5843b45f,0xc7df7047,0x3f39a741,0xe8775155,0x48192b0f,0x9a493aab,0x6c2d8909,0xe237fbc9,
	0x229f2ad5,0x95f35bb3,0xbdfda1e1,0xe5cd9b9f,0x84497f55,0x74f54e1b,0xc9732471,0x8847eab7,
	0xd473337d,0x538f062b,0xd6bfc929,0xed5596fb,0xbe61267d,0xf1232eab,0x2a79f33d,0x58518f5d,
	0x4a43c0d1,0x914385f7,0xeea1f5af,0x5d3d70d3,0x9629c93d,0x7ca35ae7,0xbba17845,0xb1c31361,
	0x2f1159cd,0x222129e1,0xc145fc8d,0x9e393711,0x09ddf4d3,0xd7c559d5,0x8fcb82e3,0x0e9350f3,
	0x1c5db9e9,0x3bbd1937,0x80cf4f61,0x4379781f,0x9643baf5,0x355f5b03,0xc059cef1,0x233372b7,
	0xba2d7121,0x9629f3bf,0xf5dd9c41,0x2ab1e2e7,0x569b51e1,0x5ac1d677,0x8d31a4cb,0xfe9193db,
	0xdeff83ef,0x8bf571c3,0x9f936dc9,0x9c13e6d1,0x24a9b44d,0xbfbb2cbf,0x7caf7947,0x2a236009,
	0xafd70b4b,0x3a330411,0xd395cb13,0x6a5153cb,0xb8ad4177,0xaea146e3,0x7bbb8dc5,0xc9d9b367,
	0xc037d4af,0xa07773ed,0xde01d7b9,0x129bfa3b,0xc9695d17,0x6447366d,0xfdb39019,0xbc253aa5,
	0x32210217,0xc0d18327,0x217d73d3,0xdca54b0d,0x2c210f65,0x2ffbd567,0x1c793aa1,0xb9f912e7,
	0xd615a9fd,0xbfd58c05,0x3729dbff,0xfaa1f7ab,0xf493a51f,0x9391665d,0xb871f435,0x76c769db,
	0x4b197759,0x04932153,0x0ea54953,0xa93f91ff,0x95074f7d,0x635d3455,0x987d702f,0xc0831da9,
	0x1eab49a5,0x589dae59,0x0e179169,0x4fb32c73,0xfe39c437,0xe62d32dd,0x89fd4e69,0x9f9d5cfd,
	0xeccfd4dd,0x080716e5,0x321fc65f,0x9faff9f1,0xbf6fdd8b,0xf5559dfd,0x80d5bb3f,0x770746ff,
	0x8007417b,0x0163573b,0x2ddfd6cb,0xb565ede3,0x26693a31,0x1ca79a3f,0xb7650f89,0x24338b5b,
	0xf153cc77,0xf5c1242b,0x8af92dc9,0x37855c31,0x5f6bdd61,0xba75d4ad,0xce9170a1,0x1f130a39,
	0xc839674d,0x78b38afb,0xc98f52f3,0x77439949,0x9535ced9,0x1f9122d1,0xedbb7063,0x9a1b7443,
	0x1ab757f5,0x204d9175,0x80458a61,0x904f9a11,0x1109bad1,0xaf4d22b5,0xe2c3ad27,0xa23beaa5,
	0xad53d8e9,0xa51fd5e7,0x7c3974b1,0x88df93f5,0x5aa99203,0xff7bdae5,0x420d71c7,0x3ee59f07,
	0x130bb927,0x023d2f17,0xe10faef9,0x71a19ce1,0x585929a9,0xf86d5a69,0x8679559d,0x920b7393,
	0xcd61fc23,0x95374c4f,0x48eb72d5,0x85c94b3b,0x6ed9db7b,0xf4f558c9,0x316bdc85,0xf8219af5,
	0x6c5b79db,0x3e21555b,0xe46b365d,0x4b0755ed,0xa16d25b7,0xe265d613,0xeac516d7,0x28153855,
	0xae797ec9,0x7f8b8a85,0x9ab54c2d,0xb18f3465,0xb1d34b15,0x608dbacf,0xa0e7416d,0x535dff5f,
	0xa0bb6be5,0x9e89e497,0x29698361,0x3413be8b,0x4053f2cf,0xe1c37809,0xa8b365a1,0x45e9d43b,
	0xbea556ab,0xc2abb4d9,0x44a7c78f,0xf7c5ccc9,0xeba9c89f,0xcad7a747,0xdd8df94f,0x862d6b93,
	0x1239a913,0x16034517,0xb715c0d1,0xec55d807,0x711b1cbf,0x9319aa95,0xc1577ecf,0x7517ea93,
	0x53f9c199,0xe5257799,0x81d373c5,0xebf799b1,0xcc6983e9,0xe45f4c7f,0x9c7324fb,0x6e1d86e3,
	0x0ae79335,0xbf23672b,0xfc83e181,0xdb5babb3,0x57d57755,0xbaf7600d,0x9dbf672d,0xe72f26af,
	0xac834563,0x958d0717,0xf547a7a1,0xc9b72873,0xec23f4c1,0x85b760c9,0xfaa3ad41,0x90bf009f,
	0xbcd1d41d,0xdc75c325,0xd0c3a03d,0x10b94add,0x00931e65,0x45ed12bd,0x0efdeb8f,0x75bf3bdd,
	0xee55afd9,0xaa6f1fa1,0xaa1581f3,0x74950e5b,0xcae9dafb,0xaf6d2273,0x7d3142f1,0x1ba39015,
	0x420d5d97,0xd88b5955,0x72e17fd9,0x43fbced7,0x5f6375bd,0x488bc4f5,0x4e1fa0c3,0xa259e56f,
	0x277b16cd,0x225b0589,0x1349e98b,0x781fe8b9,0xd0c93e65,0x8a1557cf,0x112b5edd,0xe457f497,
	0x9ca56975,0x45f5b209,0x89f1cb23,0xd4b358ef,0x5057292d,0xff5f0107,0xfc35e399,0x968de6b5,
	0x4e09d80b,0x23e5851f,0x0bf98d3b,0x07e95ce1,0x4dd36ecf,0x663b4f2b,0x0ba141d1,0x686ff573,
	0xb6ad7987,0xdf41dd93,0x250194eb,0xca711277,0x977d2c85,0xcefbd943,0x2251d8df,0x23eb0afd,
	0x400f9965,0xfd9bf2b1,0xd72fe3cf,0xff7f181d,0x7a170409,0xbc73ded9,0x29a5f49f,0xcd7761fb,
	0x6233579f,0x87017441,0xbb23b801,0xd4c52cbd,0xe0e5bb97,0x43f1e7f7,0x31816d69,0xc4032597,
	0xc39b48ad,0x260b2a8f,0x1fff2c19,0xe273cfc1,0x75a7dde5,0x2d496529,0x90454819,0xe101117d,
	0x59471589,0x47c79665,0x2b65d735,0x4b3de113,0xc09f5a2f,0x12cb4f75,0x02d55605,0x986311d7,
	0x86bd1baf,0x3bc7910d,0xf9776ceb,0xdc55411d,0x4891242f,0x814dc869,0xcc91d50b,0x189de34b,
	0x3dfb0d19,0x541fec4f,0xbcd75d57,0x2d6b70c9,0xb2bdd41f,0x181fba0b,0xd75d0f85,0x6a9db307,
	0x1f85903f,0x055f1275,0xdea77513,0xc0b53181,0xe2e546b9,0xa91376e9,0xd39bfc49,0x91d9beb5,
	0x9a5de01b,0x069ba64d,0x1e897d37,0x22e1252d,0x1b4d3d37,0x587b5a0b,0x582bdeb5,0xac41f47d,
	0x0c036c29,0x7163231d,0xb29fdb5f,0x0b216e3b,0x1cb5fd53,0xbd2766fb,0x0271e6a1,0x12499309,
	0xe07d7863,0xe1c97caf,0x678d31a5,0x7b2b4f91,0x465ff149,0x006de9c5,0x964dd067,0x76dfc983,
	0xb249bd41,0x9661bf51,0xc071fea3,0xdf2dcc9b,0xb60f47cf,0xfe1d16ef,0x1e2384e1,0x07795797,
	0x6a6d07bd,0x903dafc7,0x16f13d73,0x2dd94943,0x68059421,0x6487ab87,0x0ad5b96b,0x8c072d6f,
	0x6067d955,0xb2ed6b61,0xbb2d05ad,0x086529f3,0x57036df9,0xd4818d15,0x53c38fdd,0x86fb0bb3,
	0x7a3b07fd,0xe48307e5,0x13c52b6d,0xda7f7395,0x9c4d1193,0x015969a1,0x96cf3691,0x5549238d,
	0x4c695e33,0x2d93339f,0xbddfdf4d,0xfa5b6b93,0x8fa3ffa5,0xd0e557b9,0x385d8863,0x4e5fb6a7,
	0x39f73af1,0xd92dd557,0xad1b4e65,0xc8a937d5,0xe7479d6b,0x7b737667,0x834facab,0xe433b72d,
	0x946331af,0x94e5ac59,0x4b9b4253,0xd09d7ec9,0xd7fdd4a1,0xabd78d31,0xc907b743,0xc33567c9,
	0xbbb1aa69,0x90cbf06f,0x9a01c12d,0xe7e90755,0x3505b37d,0x9f65ac23,0x81654885,0xf257fba1,
	0x3e638197,0x9f71f1e3,0x4f6fad8f,0x4ebf58e7,0x90210cbb,0x45ebcbc9,0x6acb2d4d,0xf30b3665,
	0xf97ba835,0x55edb97d,0xf9876691,0xcfcf5b65,0x59951797,0x61bd6d2b,0xaa1dfef3,0xe1450c39,
	0x387bc3bb,0x2bcba887,0x1c6d67d1,0xe04df73b,0x00210fc7,0xa7ad39d1,0xeabdc351,0x937541cb,
	0xd563ce25,0x9b2118cf,0x52bfe965,0xbfebb553,0x1107d587,0xdf0da3c9,0x7e8b8cc1,0xba8d0c43,
	0x58b9b5eb,0x4081fc99,0x6da37fe9,0x98db5f17,0x580b8d93,0x01af859d,0x7deb1a1f,0x01ffb14d,
	0x197bfe09,0xfaf97eb5,0x94b7bc75,0x9fcd9e71,0xff6d4121,0x5be5c253,0xe7bf76c3,0x2fbd2711,
	0x5d2d5df7,0x0c21a269,0x6621cca7,0x33f59dc9,0xafef7def,0xac81e577,0xc1679a87,0x443bb43b,
	0x77d161b1,0x3807e381,0x167f1a95,0xff03a80d,0xb0d5f633,0x44d5c315,0x36c509c7,0x9a698ff1,
	0xebe709af,0xe53dd647,0x90f7ecdb,0x152bc8a3,0x07df20a9,0x28b317b3,0xba3d7559,0x07b981e3,
	0x8a756aed,0x3cd7c783,0x97290693,0x151f6b79,0x994fd88d,0x2e6d285f,0x24b15a9d,0xfc1d8235,
	0x92f94ee5,0x4a655c81,0xe1374755,0x4811fcf5,0x47e7fd95,0x1ed362a1,0xd581a367,0xa2075995,
	0xd377d38d,0x1bf93309,0x3dc34b3f,0xc1b18a03,0x14eb13ff,0xd53bfc83,0xd2914613,0xfe6b412d,
	0xc8710b65,0xe2278167,0xb1ef0ae7,0x8035600d,0x401de481,0x5f759491,0xe843e57d,0x10b982a5,
	0xbce99d63,0x1001b665,0x995d7b67,0x8c49acfd,0x67bb1c59,0x1dd1d1d1,0xc97770fd,0xf2e31827,
	0xea616501,0x7b17194b,0xc62f2e5d,0x19251f3d,0xa88bed3f,0xe32503d1,0x2f8fc46f,0xf95b4c5d,
	0x98d9123b,0x7b7b69e5,0xa109f1df,0xa47785b5,0xbdcdad6b,0x14c1c297,0xfa714829,0xd3135a73,
	0x3ed5c98b,0x0bc1807d,0x4909708b,0x16736fd3,0x2145779b,0xca758eb1,0x50799109,0xa97f0e13,
	0xa157c3e9,0xe8f9eddb,0xb3d3d175,0xe1cbcd7d,0x2b33cb05,0xee957127,0xbe8f0067,0x408f6365,
	0xf3e1eecf,0xb2b79b4b,0xcd8b583d,0x23af8f21,0x32592b67,0x5df59b83,0x5811641f,0x16b52713,
	0xf8758c39,0x0b0b6a95,0x98d104f9,0xc3d345a5,0xabf9c0f9,0x07e307cf,0xd6e19687,0x84e39647,
	0x1f95d2a1,0xb689d607,0x4ec53447,0x9469c275,0x4bd7f873,0x0e331897,0xbb631e7d,0xde8bfead,
	0xa8418cff,0xbc419065,0x7f0d3f3d,0x7221b77b,0x24352313,0xe53938e1,0x6c79cf59,0x91a15e6f,
	0xbffdbacd,0x85c724ff,0x2fc91b75,0x642f5721,0xc5d11691,0x73c37c3b,0x578368f7,0x46950433,
	0xa2cb3007,0xff2b979b,0xfd9bfb0d,0xbc45f451,0x5ff1cd25,0x33253ead,0x106537af,0x00592f29,
	0xbb2d3527,0xb6ff0485,0x3ba5ec9b,0x3693a273,0xe055058d,0x4f31c4c1,0x7181b45b,0x3c5faef5,
	0xc2252725,0xfe574085,0x13897b3b,0x19cfd575,0x1341e301,0xc639db81,0xbbb72455,0x129b83c5,
	0xdf33177b,0x08c578e7,0xa5694e87,0x572701bd,0xc3738d3b,0x890f7877,0xb6693977,0x557b7e41,
	0xc85d6c27,0x0c59d375,0x27e7ca97,0xaa4d3c39,0xda33d073,0x9b0559ad,0xcf7bb21d,0xb1f5df95,
	0xe2217f9d,0x61a50e77,0x0827b009,0xb977da4f,0x7f3dbd67,0x31eda5af,0x3b4ff91f,0xcf79f969,
	0x5f8340db,0xa3bd20b9,0x09c7bbf3,0x355311eb,0x38d7494f,0xd6198b85,0x14c5c5d9,0x6ffbcde7,
	0x6205d35b,0xd031d985,0x66eb47f1,0xf9139977,0x0bc1ede5,0x825be2b7,0x7d41bc21,0x8fe9afbb,
	0x19a92f15,0x671580a3,0xf037ea1b,0x2a6d47dd,0x9b3f4963,0xc405cb53,0xbca50c55,0x8639e20f,
	0xe4efc085,0x8af9765f,0x2ccb150f,0x598fb487,0x490fbe81,0xdae74de1,0x6151134d,0x245b3889,
	0x70db08a3,0x20efd381,0x7a47b7e3,0xa12dd75f,0x5577147d,0xd957fb6d,0x6027fa65,0xd641b757,
	0xd8f13ceb,0xf08b0955,0x2cd1de33,0xc677a8cd,0xff39170f,0xc4258d7d,0x348d5773,0xc25d3323,
	0xc72fe755,0xc3df81a5,0xaf095017,0x5923c1bf,0xa3953671,0xb2a1861d,0x005fccd5,0xe9a1f113,
	0x9417865d,0x877b3ebb,0xa211322d,0xd35dfb9b,0xde4d275d,0xeea1cfd9,0xac05a963,0x478146d7,
	0x66af2cfb,0x6a717b5f,0xfd8ba58b,0xb9dd104d,0xa9a3830d,0x14735db9,0x065d8879,0xf1ed3a93,
	0x547722ab,0xfe554add,0x2f9967cd,0xbbd33a41,0x7e5b673b,0x32edcb47,0xe4c9f1ef,0x395722f5,
	0x816f8365,0x573738fd,0x3cdd730d,0xd2efd45d,0x73b51621,0xeb5dfc8d,0x432dfa1f,0xc8b14727,
	0x401bdfa5,0x2babea0b,0xe0799de3,0x6363fa0d,0x5f759679,0x9197be15,0x63ebe1e3,0xc56f7ecf,
	0x317ddc65,0xf4c1bad1,0xac113b6b,0x5be52739,0xf5d9537d,0x4bef64e9,0xefe3b695,0xef81d21b,
	0x6517d31b,0x0e0d6097,0x27c3bb3f,0x55a3d84f,0xe9a7bce7,0x33336e95,0x1679f211,0xc15719b5,
	0x78e971c7,0xd59f8929,0xf2354979,0xb4512a37,0x0c21e6f1,0x72b7211f,0xad8d1aaf,0x8fe99ec5,
	0xb9795adf,0xcc0b7acf,0xe0856eb3,0xc61f7a59,0x6d072a55,0x684d2b15,0x51836349,0xaaa3baf5,
	0x41c5c55d,0xb461b455,0x1e59b005,0xe3c306a3,0x7a9bc44d,0xc447437f,0x853d4b3b,0x7b797871,
	0x1b511cbd,0xb4338d05,0x4dd12f0b,0x906b8d7b,0x219f7693,0xa979c9e7,0xd21b3e5d,0xa6df31e1,
	0x5e1fa0f7,0x7395d4a9,0xa78d49df,0x99c9edcd,0xed572761,0xcd316657,0xe8013509,0x2bc53271,
	0x50b10687,0x3d177389,0x1ab33b1b,0x3813c703,0x27838171,0x9743a95b,0xbd4f5419,0x839d55c7,
	0x88091667,0x1dcd0a71,0x6ce3b9d7,0x2df71907,0xf86593fd,0x41ffabf9,0xaee98ce9,0xc259a813,
	0x07a74e0f,0x054792a9,0x5a3f99af,0xe8a9e443,0x86c172bf,0xfa3bafbf,0xa02f3d51,0xb66d05f9,
	0x618f7f79,0xe599fdfd,0xb5696abd,0x9fd9c9a1,0x17d7d5f1,0xff47beb3,0x1b05cfab,0x08c9bca7,
	0xd6437121,0xd353d6b7,0x8785199b,0x75bbaa89,0x2f69ba4d,0xc2f54b63,0x6fcd5ad3,0x5cdf29c7,
	0x74c57e01,0x2589df9f,0x30318f61,0x970148e9,0xafbb010f,0x0997d0d7,0xd567421f,0x70a15b81,
	0x3a973591,0x95cbb401,0x859151ab,0x5adde727,0xf98d0fed,0x09fd7299,0x8937d56d,0x3c81b07f,
	0x33b9fbcd,0x602d67a7,0xf4492293,0x62ffe831,0x0c217123,0x8d7d9cb5,0xef1df115,0x137377ed,
	0x9ab1a92d,0x633f26d9,0x9f77a0b3,0xbb9b6f6d,0xa53b736b,0x0fe7a3b1,0xb17d9df3,0xc2e59173,
	0xf87d2aab,0x4013d663,0x80c1e725,0xfb6300c7,0x611bc9ff,0xdf8b649b,0xe139b15f,0xb2cd0d3b,
	0x44a121c3,0x7a3db38d,0x88452d81,0x638720a9,0xda832c9b,0x3d3fe4f9,0x15b16d33,0x059bcbf1,
	0x051f846f,0x97cdf425,0xbca967e3,0xffbdf3fd,0xcab7f775,0x7c51f2d9,0x8cc71fc9,0xb8431ebd,
	0x6e793d27,0x4157666f,0x5b0de6e5,0xc631e02b,0x2977cb49,0x2297c4c3,0x4ae1c3fd,0xc233674b,
	0x83afcae7,0x61eb113b,0xf713f79f,0xb79b2b21,0x4d052d53,0x085f99c1,0x3adba125,0x3561b7c3,
	0x3647e127,0x471dd3cf,0x9add83af,0xff299b47,0x0a252749,0x787d595f,0x4e1deb21,0x5e3d72cf,
	0x863f07e3,0xc0fd05f7,0xe70db12b,0x128f1785,0xd417e767,0x504533a3,0x9c856245,0xe3b9eb9b,
	0xa21b3b93,0x421f17fb,0x32c582af,0xd1ff4747,0xdc9d6069,0x1f85411b,0x8475f36f,0xe74905cf,
	0x06dd8d33,0xff9332a7,0xaba77753,0xa8293279,0x33fbe985,0x489122cd,0xcad157f5,0x24dbd595,
	0xa005c23b,0x10edd745,0x75d52ab5,0xaa41e181,0xe8f1de77,0x203ba247,0xbafbb5b7,0x12e53f99,
	0xe799f4a7,0x903d7f9d,0xcbf3f4eb,0xb7f9fd4b,0x28c13f7b,0x0dd55191,0x46d33f09,0x02579905,
	0x061732ef,0xba153dfb,0x1f1f8a91,0x9b816f41,0x5f2f5147,0xab312b35,0x26bdd2c9,0x3ea3477f,
	0xf283200f,0x0d895d29,0x36ff9cbf,0x298f014b,0x567b3d17,0xe4a1323f,0xf99b9c4f,0x2dbd6135,
	0x925f937f,0x6c29006f,0x51b17913,0x614ffdd7,0x5767b0a7,0x18f71235,0x64cdb375,0x70134cd1,
	0xd9ad393b,0x3a09c399,0x43dba9a3,0x8c79cfcd,0x49377e2d,0x3985bf25,0x3435bc95,0x009b617b,
	0xeaef31bb,0x7db95aef,0x989d950b,0x5f3ba295,0xd1ab3c67,0xea1d1595,0x7a37888b,0x54c586dd,
	0x3725b1fb,0x004d333d,0xb1991e65,0x1849021b,0x7505e68b,0xa1117a93,0xafb5b4af,0x7c83d523,
	0x9dd3a373,0x6d5511cd,0xe6ef4549,0xa0d57ac9,0xb6077c57,0xc7337ba7,0xd40f4adb,0x424934f5,
	0x8cfd441f,0x72e5b467,0xa745c5d5,0xac8f398b,0x35f5a201,0xd7d36edb,0x8d29616b,0x4b05ff7d,
	0x2121c679,0xe18d7159,0x97bdb89f,0xd9ababc7,0xd48f4047,0x80c712bb,0x4765bb37,0x362d9e67,
	0x4541f179,0xcc5fd767,0xb3f532c3,0xd0db1f69,0xd019245f,0xc25d2e4d,0x55a36799,0xbdb12bdb,
	0xd2e3c099,0xa8ef4de1,0x6e11e5d9,0x655162d9,0xe553a007,0x0f6b311f,0x1147626b,0xd6031285,
	0xb20503d5,0x6f4fb48d,0xceb3bffd,0xb4bd6505,0x6f7f2977,0x6d41d337,0xfa313409,0xce17ad8d,
	0xf92dffa5,0xba0f03b5,0x94ff8bcb,0x4753d555,0x8861fb67,0x93afb523,0xd6c5914b,0x6f5be89d,
	0x0d590d05,0xe641ec25,0x56939057,0x2fc3c3b1,0x2839b515,0x0d09ffeb,0xd3e3fb8b,0x1dc5dfe1,
	0xc20d396f,0x33797727,0x9f953141,0x2b434085,0x45c9fa37,0x56230519,0xa4ef60a3,0xf7c58001,
	0x7949e6db,0xe3c7a685,0x12a38ea1,0xc181fcbd,0xf653130b,0xfe4bdeb7,0xa3c9baef,0xf64d2629,
	0x43936bc3,0x5bbf1487,0x88e3250f,0x64afe9bf,0x8d9b8c49,0xc7570f51,0xf0d7b147,0x0cd14001,
	0xffe9b323,0x427193f9,0x31f56da7,0x9183d977,0xbde1d729,0xc59521ed,0x92f53705,0x493febb3,
	0x7bd1dc75,0xa16fd023,0xb3f97e01,0xef2b1e4f,0xb7e9e969,0x7fd94a19,0x97892c03,0xf40d97eb,
	0x9349dbb1,0x04cdecd1,0x4b95a83b,0x6f5b2b2f,0x4af3dd41,0x0f7503dd,0x3275fc9d,0xb02ba3d1,
	0x50d51953,0x9b1d264d,0xebe91aeb,0x6e433385,0x04c19169,0x403bb3c3,0xde1b41ab,0x9b0dff0f,
	0x0d751253,0x556f7161,0x5e97812d,0xd297cb39,0x5195491f,0xb07d46d5,0x7b5b6087,0x6ca1c9d1,
	0x90aff82b,0x07551b55,0x63c3a29b,0x2d8986b3,0x9c334c1b,0xf10dd29d,0x71972b0d,0x975df4bf,
	0x308150d7,0x86e369f3,0xd20b034d,0xdacb9ae1,0x6ddb8697,0xa53d3525,0xceb37f95,0x682fe105,
	0xf16f96d1,0xcca93b89,0xb69383e1,0x208d7d29,0x8e51294b,0xa2dfb4f9,0x6711e8f9,0x268f004b,
	0xa67bd911,0x13bba6dd,0x74ff016d,0x4f838377,0x23d54975,0x1245a11f,0xf5913e93,0x346974bd,
	0x11275b13,0xf9a99b39,0xe76df58d,0xe2df8435,0xd32980cd,0x8e41f125,0x3b97443f,0x2e31b103,
	0x017534cf,0x9e878069,0x7e831659,0xa053764d,0xdf8f8d8d,0x4425e513,0x21054a55,0x0adb1847,
	0x75e5f2c1,0xc4e5d6b7,0x615ff66f,0xb80f1129,0x4acbf26f,0x13c1a573,0xd43bcdaf,0x3bd79e33,
	0xbb7d35e1,0xf1d7d6ed,0x8da7a4e5,0xe4c56cb1,0xf51d96ad,0xaf6be34f,0xea1b17a7,0xcd1766f3,
	0x8dbb53ab,0x8ced1253,0xf77b4d57,0x8baba153,0xbd4965ff,0xbbf37833,0x7e0bde19,0x850d6731,
	0x36a3f617,0x003912b5,0xa97dd7dd,0xdc6f67f5,0xa08ff0a3,0xf0a90625,0x51e7e35d,0x04ad0415,
	0xaeb7bba1,0xd84ffa5b,0xe4cd8915,0xf145ba05,0xdab10b51,0x376397b3,0xee17964d,0xe765b349,
	0xbcf7d741,0xe4412411,0x4113a215,0xeedf7169,0x05f16f43,0xcc6f3fe5,0xc179b243,0xe32b9af7,
	0x16e9b073,0x559fc321,0xcc6b0079,0x246de88d,0x3b135a33,0x5ea3ba45,0x416fdf1b,0xe86f31cb,
	0x808b832f,0xe07b8353,0x2b79be5b,0x2ba39a5b,0x31572e5b,0x2f4d0add,0x09dd512d,0x4225deef,
	0xec61fff1,0xdb6928f3,0xb95fd253,0x08b3c23d,0x5e7f1275,0x32411e37,0xfd256953,0xb5bb9a0b,
	0x9b6debb1,0x5f7930cb,0xa7bfaf7d,0x4a4ffc1d,0x16cf91bb,0x2dd3695d,0x642754e9,0xa3278b49,
	0x3d31bfeb,0x683d7023,0x1ebde573,0x29a7e465,0xad073be7,0xdad189db,0x0e47adc7,0x24d9ab53,
	0x0faf4a99,0xf3cbb4c7,0x5cf7c04f,0xaa6fb7fd,0x926b4533,0x048fe5b7,0x71651a47,0x2fc36355,
	0xff674e33,0x22af6501,0xd793e8ab,0xbad7f453,0x76b92659,0xa8df4b7f,0xc9e5ed43,0xb3572cf7,
	0xc75d21b3,0x57ff1f99,0x5a2f039f,0x5395f74d,0x68393c93,0x1815923b,0x3aa9c617,0xb9893265,
	0x11155095,0x594d5bdb,0x26f152c7,0x97d79f59,0xf3a7699b,0x14ff3975,0xed113099,0x86c7ee47,
	0x948d3ad1,0x6ea9098f,0x1679543d,0xf54feb5d,0x4449b3ab,0xf4f10937,0x31014529,0xba07cbc9,
	0x3847b4e3,0x82a53101,0xb7e9629b,0x44339ac5,0x43dfe57d,0xbfbdb20b,0x9cd9489b,0x6cb9c693,
	0x3149a7c5,0x425592fb,0x70e354f9,0xe731cd7b,0xbaab2e4b,0x4fb56cfd,0x2d7d4c4d,0x52d10acf,
	0x2311b0ef,0x3d4948c7,0x9d891ef3,0xeb7ba3e9,0x6f71c1cf,0x71a99b95,0x664dce15,0xdabd9529,
	0x3fa5c25b,0x0595642d,0xb07d70a3,0x28c7def7,0x47717845,0x04ef67db,0x712d5853,0x4d73d2c9,
	0x6783c285,0x4fc98f77,0x52e156a3,0x61438013,0x666d6e63,0x1b57645d,0x3e7f21db,0xee634159,
	0x49af2c67,0x12f9ad73,0x8457da0b,0x61a36925,0x4ea9a565,0x19332c23,0xa523ae0b,0x1b7f0f05,
	0x83a9af79,0xa8b57967,0xbb03a077,0x2119fc95,0x00e5a305,0xd55302b7,0x827d6cbb,0x6d39ba75,
	0xc177cfb5,0xed0f271d,0x03838c01,0xe155bd4f,0x1c63117d,0xb90d7425,0xda6d5a45,0xd685b2d5,
	0xdd978599,0x5e9b02e1,0x20fd5b43,0x4e8beebd,0xfee75f89,0xe031f4f3,0xf7579f85,0xc4d3f7cd,
	0x010dde19,0x3e6b117d,0xad0f4957,0x9f6d34cb,0xe4b1605f,0x390f822f,0x8a1d31d1,0x4015b987,
	0xc35b9ab3,0xb00fb03b,0x37dfadd5,0xb52b33df,0x0883ebbb,0xa47d415f,0xca1f7307,0x0abdf8af,
	0x4a83d161,0xd99934e3,0x680d9cd9,0x3b7930e3,0xc3a17dd7,0x15c92091,0x9541d181,0xc1bd266d,
	0x6b078c9b,0x039d8dc1,0x1ab986fd,0xc889b145,0xadcbd76f,0xb2c9764d,0x8fe36815,0xfc89c46d,
	0xc7e96b5d,0xb92be19d,0x8389d959,0xfd0d1aed,0xbd439db9,0xf3cba19d,0x44e99e21,0x6d0f04d7,
	0xf2a9411f,0xe7d72fc3,0x4c9d9d8b,0xa4355443,0x66cdfa71,0xc3a3aa0d,0x45b3c77d,0xffc56a55,
	0x8b4bb5dd,0xffb1effd,0xb69719a9,0xd3b56435,0xbda93bd3,0x9fa5dfa3,0x4a25c483,0xfb9d6813,
	0x6051e60f,0x134db293,0xb89b704f,0x0bbf1229,0x93997495,0xb79f7aed,0x509fa20f,0x220501b9,
	0x8ebd02af,0xf7bbc053,0x20474095,0x5703860b,0x98e11bf3,0x0de53cf1,0xbe073979,0xcef36b73,
	0xa211f13b,0x648dba81,0xb1bf4619,0x6ab5e845,0x7c41ada9,0x97490f3d,0x7db9d09b,0x18d5a9e7,
	0xb44deba7,0x13d73aeb,0x47a5f8f1,0xc68701c1,0x0afb49ed,0x5b1da3d9,0x219db9d1,0xf0a13245,
	0x8df52073,0xe22b73db,0xf31d2db9,0xd4a9dbe9,0x50d3557b,0x9333154f,0x020ff3f1,0x41c78a31,
	0xc60d5295,0xee97d01b,0x1bc5b589,0x09cf60a7,0xb809198f,0xcbdd86ab,0x5df7ca59,0x123be7db,
	0xe2137987,0xbab392f3,0x9fc3fdff,0x052bfa65,0x295f63df,0x03edc373,0x7ab374e1,0xa26bd1e7,
	0x76096145,0x4a8d782f,0xf3b7b131,0xb06f340b,0x2c1726a9,0xccb5dfb5,0xc425b7e5,0x8d4dbf83,
	0x44754a47,0x44b75419,0x42c155bb,0x5fcb5907,0x05f518a3,0x6a07d7f7,0xecb3843d,0xe851b857,
	0x5e578989,0x1245b379,0x8e87eeb7,0xf1f3153f,0xdb3b550b,0xf2353147,0x0d399743,0x6369f48f,
	0x432f2883,0xfec77b99,0xcf299bbd,0xf019151f,0xcea7fb97,0x6e11992d,0xc51f1ad1,0x69097cd3,
	0x01018531,0x584f8a47,0x134938eb,0xadeda591,0x217fd085,0xf8eb85b3,0x5a434541,0x3e1fca4d,
	0x544ff20b,0x8f7155c9,0xa009fed7,0x69a353ff,0x5383dc8b,0xe099d565,0xd907f96f,0x222166a9,
	0xc81b560d,0x573f8ceb,0x110b229d,0x6bed8e53,0x42f70ce7,0xc56b6f49,0x344f66b3,0x6eff8c0f,
	0xd5e5ccb1,0xc549b6f5,0x787375d5,0x27fb42f7,0x4c9bd34f,0xba31e2eb,0x657da8e9,0xb92bc52b,
	0x05b345ef,0x71a1d3b3,0x7edf069d,0x5b8380d5,0x6bb1c601,0x64410857,0x8c716867,0xef998d25,
	0x0e032641,0x96dbfb6f,0x8373bf8b,0x2eb11755,0x59fd3fb3,0x1b69a015,0x0f8f7a0b,0x7bb7efa7,
	0xf3d9e6a3,0x3207fef1,0xbbd307bb,0x543d3665,0xafbfffa3,0x09fff32f,0xbbb77f2d,0x617b28dd,
	0x2ab7b48f,0x22b90785,0x541d62c5,0x29550e6b,0x03b9c989,0x4cd1732f,0xe44d85a9,0x5f55456f,
	0xb49f11fd,0x4b0336f3,0x8ef710c7,0xd5ad7053,0x0b2d059d,0x13335a1f,0x8333a7d5,0x0e39c289,
	0x42117567,0xaf734789,0xe57fae57,0x6b776d87,0xb9df609d,0xbef94a8b,0x58c9ac8f,0x01952dd3,
	0x5213e9c9,0x971f2c0b,0x275bd491,0x0763f7f1,0x620f6bc1,0x0471ef79,0x0bf1a731,0xe75fc577,
	0x5223ae9d,0xab99afc9,0x9aabb90d,0xf0a781fb,0xd4813cc1,0x0a6f9c77,0x4a119791,0xa8051821,
	0xbe45d7db,0x18f11689,0x1c11cde9,0xb8ef9e8f,0x80750ddb,0x8a45ed8d,0xe7050a0d,0x867fa4f9,
	0x40fbedfd,0xadb9bc97,0x3eaf61bb,0x5c73a117,0x93adddc7,0xefc56745,0xfd35b77d,0x40397ba9,
	0xd3478e01,0xfb05b6bb,0x6c273f9f,0x61e13d7b,0x1a6b0fbd,0x794116a9,0x0d7f253b,0x2d27dc5d,
	0xdca9095b,0x74677241,0x049b4f2f,0xfa6d2829,0x1f730b7b,0x578b3143,0x1f454523,0x5fbdd7bf,
	0x53270609,0x8fef54f3,0x7ead3485,0x21c9b607,0xcc05dd39,0xcdf5b51d,0xe06d158b,0xc4ebeef5,
	0xdb3f1e85,0xe62f5d19,0x8781f039,0xbe257c81,0x87e5d5b1,0x525108c3,0xc5534151,0x4423b3ad,
	0xe7f581c7,0x523bc17f,0x22b57f67,0xc035f183,0x19532a1d,0xacf19b3b,0x28dfbfcf,0xdf576811,
	0xdacb934b,0x11a3916f,0xca6f7ba9,0x432b0b73,0xc5119435,0x18a78413,0x6c6d74db,0xd2fb9ec9,
	0x23c18b09,0xe47b54b1,0x8f4dbb17,0xacb7e13d,0x6e61f237,0x62c52353,0x17e5d0d3,0xb5fddaff,
	0x615d157d,0x2d53ab91,0x3875f04f,0xcd0d4a49,0xb707e6db,0x0b1bc185,0xf9a5708f,0x99d3305f,
	0x809df39f,0x113deed7,0x63874a67,0xfedf7e85,0x1f43795b,0x63ff2fb3,0x4691bd6b,0x2a6de311,
	0xdd059aeb,0x97cdcfcf,0xa4a314fb,0x475fb659,0x25d9b571,0xb2416769,0xba098d3d,0xce3d07bf,
	0x6097d559,0xcb15f843,0xa66f5823,0x763dcaad,0x68074b57,0x4d312aad,0xb5f1c263,0xc6372395,
	0xa3d56165,0xd7a5aa7d,0x4a0b787d,0x45add4ef,0xc1952fc7,0xbea5a40d,0x62a9ebb7,0x4dcbcc3b,
	0x0dc19207,0x2c8f6145,0xc719d71f,0x7a61cf05,0x6cbf3bf9,0xe2eb0691,0xcf15e48f,0xbae947dd,
	0xf3dbeebb,0x9b676fe5,0xcbbb71a5,0x0389335b,0x224bcdab,0x08d92dc3,0x109574c9,0x9e092d23,
	0xba29d379,0x783da22b,0x9c938229,0x1ad99cdb,0x39796715,0x11bd3dad,0x630df0bd,0xe2170337,
	0xf32910bd,0xb9a5dc5d,0x34c51f43,0x648366ef,0xc80b4ef1,0x916b42d9,0x48dfd945,0xec87e1c5,
	0x7fdf8b7f,0x18afbb45,0x65efdc0f,0x0f374d81,0xc2453079,0xee37d251,0xaaeb7bbb,0xbd4d10f5,
	0xafcddd3b,0x30ef3431,0xf8356829,0xf42b0cfb,0x1ae7bb67,0x80efa9a1,0xf89591fb,0x0ed9a971,
	0x60f3f3e9,0xa07534e7,0xca3b2fa5,0xb70b0245,0xe33543f5,0xb4e74ecf,0x47bfe25d,0x761d3465,
	0x1fd7b205,0x27d543b1,0xf11ffb23,0xe60fcacd,0x6aed62dd,0x27f1b069,0x74c9dfbd,0x828b4b7b,
	0x47778e89,0xca1f1f5b,0xd8878fb9,0x19e5e479,0x60559559,0xca61c577,0x42954971,0xde1738d9,
	0x215734ed,0xece55f2f,0x62934f03,0x15c14db5,0xf02fdd23,0xff052d83,0x7a87cb57,0x6d31972f,
	0x0579252b,0x783b12f7,0x07e5d71b,0xe755256d,0xe5bb6075,0xbb31d097,0x0c819dc7,0x6ecbf1a1,
	0x7a5f53bf,0xf6b162fb,0xf79fa29b,0x06d14b07,0xcabb0a0b,0xa6b77f3d,0x2ee3259d,0x9c5763dd,
	0x5509c9a3,0xb55b3007,0x3761a89b,0x76e9fe6f,0x0771291b,0x3be99281,0x7e91942f,0x49c73a0b,
	0xd8fd444f,0xe3cbb363,0xc351fcb7,0xe4cf800d,0x02a11161,0xe7978beb,0x1eed875b,0x858d90d7,
	0xd839d5bd,0xb40f1edb,0xae116f09,0xc835b0cf,0x418bbb17,0x2917b583,0xd9d7a979,0x389df569,
	0xd3418469,0x7abd3cb9,0x40bf2c2b,0x834bb21d,0x87f162f7,0xb239c1d7,0x3fb15165,0x4667056b,
	0x1917eb4d,0xcee70fc5,0x1aff5d35,0x82c585df,0xf8172a3b,0x874f6bef,0xc75f2275,0xacdd0f09,
	0xe73dd9e1,0xaa1d734b,0x52f3c7c5,0x5dd3ae83,0x32bdb69d,0x1f291755,0xee43ac87,0xa473b0eb,
	0x89b3f41f,0x8873bb15,0x953f6def,0xf62bceef,0x7725d259,0x831d7015,0x583f0bf5,0xc0177a3d,
	0x7aff5283,0x8879536b,0x45012e53,0x97fb4a8f,0xc3130c25,0x6efb0ab5,0xefb18995,0x0d3f8aa7,
	0x841f2207,0x8b416119,0x9bdf6409,0x19f7e54d,0xf2c7573d,0x71130443,0x05813ac5,0x33db3253,
	0xdc974423,0x545f6167,0xc9f986a9,0xfd4f6393,0xe103ab5b,0x0a3ba245,0x710da15d,0x965d91ed,
	0x4a69eed3,0xa9e3ca21,0x15efca4f,0x8db72a4b,0x870ba4bb,0xcdc1f2c9,0xb0394bb7,0x71b73a9d,
	0x42154c8f,0x7461a991,0xfce7bf95,0x0161dedf,0x1c9f2413,0x817b6c57,0x076574af,0xfd5dce0f,
	0x06a11c51,0xdeeb4681,0x5281f393,0x98fd0737,0x3801ee9f,0x3db78df9,0xa175a39d,0x8b3f9e6b,
	0xc98b5197,0x770fc039,0x60df8fe7,0xbfc1a9c1,0xedf54e1b,0x8d497f3b,0xafc94c5b,0xa7cf4e5b,
	0xcad9b455,0x4ce3ae85,0x08a3faa7,0x2b5bed63,0xf1bbb0bd,0x8d85b023,0x8a456f43,0x39ff710b,
	0x7909810b,0x12f9c1ad,0xe0ef766f,0xfbfdb98b,0xb5154941,0x0e39793f,0xcf4b3931,0xa3412a23,
	0x911d08ad,0x3e61627d,0x5765c257,0xdc5d561f,0x8847aee3,0xb1b9bb95,0x83bba37d,0xdf89cdcf,
	0x3e9b50bb,0x26af523f,0xd029b9fd,0x21a90b8b,0xba117d59,0x0cd780b3,0x32f71401,0xa54780b7,
	0x3b83b329,0x25f34abb,0xc5d9f577,0xeb93c2b9,0xb7b5f4df,0xc6e59aa1,0x0ee5fd17,0x856dd805,
	0xf0557e77,0xb8bf9e3d,0xe9996961,0x4451a513,0x2cf79a31,0xb9b543e9,0x0fe37d9b,0x0b6d7965,
	0x94159599,0x9e27d78d,0x430d06d5,0x4091bc83,0x2415d685,0x1199bf97,0x14d300e5,0xdd39baff,
	0x4c45100f,0xf7bb59f9,0x50555b6b,0x1f879371,0x25d79799,0x6d63f931,0x0319decf,0xdb45437d,
	0x4ce7d9cd,0x698f0147,0x2611313f,0x6ae3d4cb,0x5979efa3,0xfe6524c5,0xe697fbb3,0x407faa0b,
	0xf87b5353,0x3a33c1c1,0x8f672eeb,0x16dbebf7,0xa4c1b55f,0xa8715ed9,0x11ad686d,0xc25d1651,
	0x0007f197,0x72bb4833,0x2df77789,0xa21da4e3,0xcbf12409,0x21d94c7b,0x3d3d0255,0xb0d1e07b,
	0x8309de13,0xfeb799e7,0x99e34ab3,0x35dbcbf5,0x91c77b57,0x136fbb33,0xa8ad1347,0x16493131,
	0x2f8596c3,0xcc3bb4a5,0x81cda481,0xc5cbce19,0xd7899f87,0x3883410b,0x39dbf199,0xd7bba19d,
	0x61fd8e1f,0xebd72eb9,0xcad7dd8f,0x301b58b9,0xbcf7b94f,0x7eebdc8d,0x9d29a029,0xd495db6b,
	0x4573cb23,0xb09dd6ed,0xb0a34af7,0x5d7ff9bf,0xc055d5ed,0x26f794c5,0x657b6e4f,0x06cf38c5,
	0xf3698949,0xd0215489,0xe553de51,0x6127bf95,0xde638719,0xe3771939,0x2c3397e5,0xa2d56451,
	0x93dfd889,0x8275c759,0xb189c5bb,0x98c7d923,0xb263830b,0xf9c161f7,0xb131e547,0x379bf93d,
	0x7d593d5d,0xa22967a7,0x14690bcb,0xcc9135d7,0x96194481,0x61a34f87,0xfad94b4d,0xce952331,
	0x54d950c1,0xcc4f263b,0xe391379d,0x4f372597,0xc1c3aab1,0xe5734af3,0x760b8b51,0x0bb33e59,
	0x2de1602d,0x807b4c61,0xeb27ecc9,0x1de9f8d1,0x6c299959,0x41ffe5c5,0x162bd32d,0x4d67775d,
	0xaa730d9d,0x40bd1be3,0x0dc98b6d,0x005ba06b,0xea8798b1,0x469b7a07,0x751b5d3d,0xcca36b69,
	0x1b11ef8b,0xb1a96f09,0x649dd01f,0xa8bf4dd1,0xd0a37571,0xf51bca45,0xf33b1059,0xbcd9c825,
	0x9ebb30ef,0xba4f589f,0x5f4373fb,0xd3c512ed,0x10bde0d7,0xa1cda185,0xd76d1fdb,0x6bfdebbb,
	0x42f53145,0xa441c3ed,0xe3ddcc9b,0x68a18229,0x1b99109b,0x13857355,0x6f17ab9f,0x627f84d7,
	0x23c12485,0x3b9314bf,0x6f0d6c17,0x99054e6f,0x00775ef5,0xa395fbbd,0x2e175ffb,0x835132a1,
	0x8ba1b329,0xeed7c75f,0x33f5c10b,0x0123eb29,0x8d19eaa3,0x5dcfdf47,0xcecf15cd,0x2be524c5,
	0x13979a2d,0xef1d1097,0x3c37b691,0xc7ab2c3f,0x6dc136dd,0x20854afd,0x7223726f,0x542dbb6b,
	0xc3254b0b,0x4ff77daf,0x87f55443,0xbdd1e61f,0x4d33cb5d,0xbc899469,0xbf7587b7,0xae9d273d,
	0x304b8bbb,0x27799471,0x2dd15e3b,0x7f458daf,0xf4afd45b,0x152dd995,0x04a57403,0xc8250967,
	0x9f8d16b9,0xae35732b,0x7aedf511,0x923dd85b,0x6bf9c295,0x4043a10d,0x5615022b,0x28371391,
	0x23ed3afd,0x5f3970a1,0x12ed35e1,0x87675c0d,0x1951eb43,0xa61d79d7,0xaeab4989,0x70c5a7e5,
	0xbeed7c03,0x181dbc23,0x0fefda45,0x19f72f2f,0xe179281f,0x218d9b81,0x0fc54df9,0x7e43790f,
	0x808f31c3,0x38edfd77,0x2299d855,0x4f9d88ab,0x47b37761,0x1fe58613,0xa1459fd3,0x879f2a37,
	0xa75328b7,0xc43ff4e9,0xb20902af,0x988d5feb,0x8dc39bc7,0xc0f5a217,0xd18ffbf1,0x3e4fef09,
	0xc03f41dd,0x7f251b43,0xfbe5a869,0xef790cd9,0xd3e9bc89,0xf713e097,0x7585ebad,0xee432bad,
	0xc6d112a9,0x112f41cd,0x344d351f,0xf993e7dd,0x38e90561,0xa70f5b1f,0xe88764e3,0x9def14cd,
	0x450d851b,0x246f3253,0xa5e3d0e9,0x268be9e5,0xfa014689,0xc839f3b5,0x2c7969eb,0x2e414f95,
	0x737577a7,0x85794f1d,0xd1c90065,0xd0954c57,0x92f794bb,0x8467f4e7,0x09bba99f,0x7aaf91ad,
	0x59095d4d,0x435f32f7,0x8fa144a9,0x5c612921,0xde0de931,0x57e7b1bd,0x2f311f5b,0x79294141,
	0xeb4fdd83,0xcfb1512b,0x2d8dbb51,0x59251aa9,0x3403c1a5,0x318f25c1,0x523db2f5,0x5a2114f9,
	0x2e457443,0x1e819581,0x902fbe77,0xa08fdbdb,0x8c1bc051,0x92ad94fd,0x4ebfd8cb,0xa889b3ff,
	0x546f1209,0xc6630445,0x52a984b3,0x76d3e821,0x9c174bef,0xaf152bfb,0x471931b7,0x69d555ff,
	0xdecfbbcd,0x20675a41,0xe69fc123,0xaaa11b65,0xf83b2fb9,0x8d1b9fc5,0xc4312b0f,0x3df36321,
	0xbce72b0b,0x681facbd,0xb42f435d,0xb52d520f,0x33473b69,0x258dcde7,0xd5639eb1,0x7f591411,
	0x6cb96dbb,0xdba10985,0x39ff977b,0xda29090d,0xfe7de339,0x83bf5c67,0x309772f5,0x62f711f7,
	0x1ac58659,0xdb7916e3,0x2d2da61b,0x47c7fdc5,0x49a1dfe3,0xe58359d3,0x522b3ab5,0x1841167d,
	0xc20f0bdf,0x0abdb39f,0x995f5453,0x36b7ce25,0x62f3cea1,0xdb2ddd33,0x9d01d54d,0xe9258bcf,
	0x4c19c9c5,0x6eff9705,0x00b323bf,0x0a2d9893,0x1737d12d,0x678ba611,0x7a7d0e95,0x5a192c95,
	0xb0e56005,0x904ff0dd,0x7bcfd279,0x6fdb9bfb,0xd1ab2dc1,0x1ff1bc77,0x7a813ee7,0x4a0da3f9,
	0x16f5e31b,0x993f0973,0xd9d3fb1b,0x7ff1d7c7,0xbc15ef17,0x4c3110ef,0x736deb1d,0x12732da7,
	0xf34b7bff,0x76e3e191,0xc061b4bd,0xdd23abe1,0xdeb78469,0x069d1c85,0xa2256493,0xa73d35c7,
	0x2967082d,0xf8cbd27f,0xcb9b32fb,0xd4a378b3,0x40516171,0x5c0580bf,0xca0b6921,0xb6dff905,
	0x2b4db99f,0xf10b2e0b,0xae2365ef,0x7e233f27,0x06259e69,0x6bbfa7ab,0x54ffc321,0xca472489,
	0x197fb6cd,0x5433de79,0x511b9a33,0xdbd340a5,0x93f5980b,0x879b63d1,0x7363e96d,0x64eb75ff,
	0xe2ffbab1,0x59570699,0xf42718df,0xfa679f1b,0xac058f93,0x53eb903b,0x3c1d9f61,0x24bd5b8d,
	0x654fb4c9,0x9a07a1af,0x4d65c791,0x110ffcef,0x8f154ab7,0xe77fb073,0xcc8994d5,0xe22b93e3,
	0x8c716909,0x3255238b,0xa979c85f,0xa1811d0f,0x1c67b3b3,0xebad9085,0x688f0623,0xd029ce25,
	0x72e50fef,0xe0d51873,0x0b8719e3,0x97eb82e1,0xf1bf7941,0xbc45e4f7,0x9a8d5c27,0x9c2b4a01,
	0x81aff675,0x2699c533,0x4d2f373b,0x6aff1251,0x8b5dae9b,0x8797ead7,0x5365cc37,0x8e2177a1,
	0x90511e13,0x6731c715,0x3e91b7fd,0x3bf3afc9,0x64036b7d,0x6e7907ab,0x0a7bf831,0xa87d97ab,
	0x04cddcc5,0x08afb3e1,0xc653f045,0xf675e033,0x14f56c1d,0xa4396981,0xddb18e6f,0xc8335b4f,
	0xf3a57d03,0x93a7b9e3,0x019590ad,0x70b968f9,0x75f3b137,0x8eada6e1,0xb167e9c7,0xc4b18431,
	0x3fd9ddc7,0xd3293fe3,0x63f9464f,0x8b6ff003,0xbd3f2007,0xe6235ed5,0x5081b197,0x8fed847f,
	0xbaef128d,0xf4c9852d,0xd7a15ac3,0x51cb9bbf,0x9f9d2243,0xd56fd8e9,0x8c5f79b7,0x56571ee3,
	0x44e5034f,0xa897418b,0xdd2f5425,0x197fb313,0x704d4627,0x19e5a523,0x5ce56283,0x9ee10683,
	0xec3f0c85,0x41274545,0xabc5950f,0xa2bd3d6b,0x4111de6d,0x23533c11,0x0075b8d1,0x6afd7f0d,
	0x0dff9f2b,0xd3891927,0x5105fc99,0x3835a2b3,0x022da251,0x340d9eb9,0x1bef95ff,0x569ffcab,
	0x75a5e0b9,0x574f9e7b,0xd1118661,0xcf1b4b51,0xa2614d89,0x80e5f6a9,0xdab77fe5,0xb837c405,
	0x7d374b2b,0xc68daf09,0x468dea7d,0x27214031,0x2eef4053,0x512d35e9,0x0ead08df,0xc0b78a45,
	0x2d334cf9,0x3dd5bd1d,0x02973d89,0xea79cabd,0xf3991f65,0x1eb7b703,0x50356fc3,0x9b911517,
	0x5c9de91f,0x1c357381,0xacd5909f,0xcdd314dd,0x9aa373fb,0xb5d5dd03,0x1e2f3fef,0x8eb7daa3,
	0xd0f75715,0x2345557d,0x63659157,0xb063c8ff,0x4ccf4bd1,0x5559b36f,0xfdfff13d,0x1a9da193,
	0x5e43a2d7,0x97135edd,0xdaed29cd,0xbbd9b20b,0xd15bd91d,0xce958e55,0x9b878803,0x1a332113,
	0x07034cdf,0x5e31a3e9,0x7e8d209b,0x846b5b69,0xae0d129d,0xa55baa3b,0xe927351f,0xe2eba0cd,
	0x1c37ea23,0x21b3f16f,0x8fe5b8db,0x28c7b105,0x47255387,0x2ffdcc2f,0x3fc3f5e9,0x64b798e7,
	0x5d65c423,0x6d296cb3,0x471b5227,0x721f9f4b,0xff67fb99,0xb74de1b9,0x7ebb343b,0x4a09520f,
	0x188b78d5,0xcea53385,0xf2cf0897,0xf429b321,0x58130f09,0x969ba0e3,0x2bf36671,0x17d5856f,
	0x4a2d9ab3,0xf6bbfc2b,0x182354c7,0x2d13b9f3,0x10ebd695,0x5bbd2837,0x93cbaf61,0x4d8bfcad,
	0xbd4b50b9,0xd87db571,0x92bbabd1,0xa58f61ab,0x48337f73,0xe7039ec1,0xe9277e6b,0x851d31f9,
	0x2b6bf65f,0xc97b269f,0xb4b51f4d,0x10d3d8b1,0x9aabbb61,0x8b3dd407,0x65692f63,0x92fdeff7,
	0x5c8dbba1,0xa1c78f81,0x66b5fd59,0x6c8d6df3,0x43956095,0x2dc1e017,0x6871aaa7,0xa61df1d5,
	0x473144f9,0xdbf54861,0x47dd708b,0x20f130d9,0x3cb309cd,0x665dc379,0x98a3050d,0x67f1833d,
	0x305b4b5f,0xb5176207,0xcdd11fff,0x20b1914b,0x5e49b641,0x9f670737,0x02df1ff5,0x1c692055,
	0xcb8d3c4d,0x4cbb45bf,0x64afcf4d,0x08fdffb5,0x7f1769a9,0x35ad5cdb,0x3a894933,0xc1f715cd,
	0x5ac9d9bf,0xc4f95551,0x8f1dfe93,0x41898d03,0x9461cc43,0x98833e6f,0x7983db25,0x318d20c9,
	0xce8fda2f,0x625d8b09,0x063b8a67,0x1c878a9b,0xd1e7cac7,0x69bd8e7f,0xc02ddca3,0x3e9f0ef7,
	0xe5e58895,0xabfd19b1,0xd9ab4be5,0xf6a72a69,0xc9eb366d,0x9da93811,0xf56ba107,0xd71b5e7f,
	0x4e49646b,0x8b6b0c93,0x8f8db8a7,0x571d1ed7,0x8d3164f3,0x9b1bceb3,0x069d682b,0x2377de0d,
	0xc3bfc1ad,0x6cb7e777,0x448782c5,0x0f9b3acf,0xcaf7d091,0x5b652e6d,0x07a7fe6b,0xa6a34cc9,
	0x30c968d5,0x5e7546a9,0xcbb938db,0x5c5111b9,0xf105b7ff,0x8a591bc7,0x52e95c9f,0x5e11fa5f,
	0xce6736db,0x31b37ef1,0xcec5e603,0x03f59783,0x4b97be7b,0xa649e3d1,0xa9474821,0xe1b566f7,
	0x441fbd3b,0x9a093d9b,0xedcfb1d7,0x77b5c093,0x25738bbd,0x2007fc0f,0x5223f2cd,0x83fde33b,
	0xc7efe1ed,0x4d852871,0xdf758071,0xf34321d7,0xe7d96bff,0x7ae5a28d,0x3b5d9afb,0x71df3057,
	0x3e5d7f6d,0x24b97dbb,0x90db9269,0x9cd590b5,0x3a8deff9,0x6cb57dd7,0x19592b85,0xd2cb1ff3,
	0x5a6704b3,0x3ab9b445,0x45a324db,0xa519c319,0x23cd8ce9,0xfdc93cf3,0x86f7dbc5,0xe8b53439,
	0xbd8f1539,0x0d151b59,0xb7f11161,0x6741ef6d,0x28613c87,0xa8f3376f,0x259bcf97,0x300b3fd5,
	0x17db28fd,0x9be17abf,0x38636e13,0x89036c9b,0x6b851d0d,0x7b850d53,0xbd25b751,0x7fc305ef,
	0x47cb2c73,0x89adb2c3,0xce1f2d8f,0x1a8d520d,0xceff1135,0x354f4729,0x5bf96fd3,0x294dda33,
	0x7a5f209b,0x3b8b5c2d,0x56c5beeb,0xb69317ad,0x130f6039,0x68a7f5fb,0x76f9a271,0x189b40c9,
	0x4b1bbae9,0xf90f6849,0xa677adc3,0xa24535e3,0xf67755d1,0x9a5d5355,0x09856509,0xf41f8e5b,
	0xe401055d,0x0c4bc0e1,0xa7d54231,0xed59c59d,0x567be23b,0x61c1613d,0xb581d9f1,0x3ccb8815,
	0x1d93fe6b,0xe1cfe83f,0x7c0520cd,0x91fd2041,0x4edb3a2f,0x88a98a41,0xe34dd009,0x6e13039f,
	0x9ed33913,0x28ad992b,0x9aa7eab3,0x94e37fbb,0x59db76e7,0x2b634169,0xe1cd62a5,0x1de78725,
	0xfd417cc9,0xf27966ef,0xf1dfdd7d,0x25419e75,0x703b361d,0xd8c5a23d,0x066399a3,0x1cb9e94f,
	0xdce1658d,0xd3435d59,0x064b7345,0xbcc55759,0x293d3a0b,0xb21d10cd,0xccef095b,0x957bf147,
	0x103703d5,0x019fa0af,0x130f02a3,0x3fa145d1,0xdaa3096b,0x8b3fd99d,0xf7d372a7,0x2da1f6b9,
	0xb8417c9b,0x769d0dbb,0x29cd5eb5,0x1c8b65c7,0xb8b18f77,0x0a7fd1b9,0xaff562e3,0x251b81cd,
	0x6481a95b,0x0dd1d9cb,0x52a97711,0x6cb1b3a5,0xf627bbe9,0xc8abf6ad,0xa4b1d3e5,0x7659eb2f,
	0x32fdb80d,0xa54b32a5,0xac41f7d1,0x13c7cc55,0xe44722fb,0x71170e7f,0x2befcc0b,0xf653fc07,
	0xf033cb2d,0x3d9fde93,0x8bbbe993,0xdfff8d3f,0x12d59d67,0xe19547bd,0x620dfe2f,0x74758dff,
	0x372999b3,0x19dddc61,0x9cb5516d,0xaa09b44f,0x7011e867,0x4a79d96f,0x49ed69a7,0xdab32b43,
	0x915d0f1b,0xdf970359,0x0155d0fb,0x75197ff1,0x68bf45b5,0x4e91a31f,0xecf5fa51,0x4d81ae7b,
	0x96d3eb5f,0xb6e1a345,0x723b4657,0x8edf4f0b,0x081d1b8b,0x2331ccd7,0x7b012885,0x4bcfe2d1,
	0x0e0b62f7,0x6a4b246d,0x5e896c1b,0xaf914109,0x17f194a3,0xb02b6721,0x6a79991f,0xcf0f23f1,
	0x0c0bbedd,0x86e9a79d,0x0be1795f,0x19ddd5d5,0x407d4037,0xafd10b09,0x9839bd75,0x6b33fe05,
	0x1451fc8d,0x7c4da61d,0xb665c1bf,0xbaf78dd9,0x287fb201,0xcef37a15,0x67a97365,0x6eafcdb3,
	0x38e36e01,0xbc8591b9,0xb0b75555,0x4a8f89ff,0x953d223d,0xcce73e53,0xe2a7a547,0x02736029,
	0x3a3f59b1,0xdc2774bb,0x83f9a0bb,0x6ad92baf,0x8a790da1,0x9b7d4a4b,0xd997e9f7,0x49f19311,
	0xa7699a97,0xb24591eb,0x0fcd0d09,0xc887b4d7,0x6a73d569,0x7f079907,0x035924cd,0x831bf493,
	0xfde1402f,0x786f0495,0xaa579fdd,0x3acbe7dd,0x15ed5f4f,0x2e55ce11,0x1d4f25a3,0x26636359,
	0xc9ad2e73,0xeab96083,0x40359b4d,0xe355a7ad,0x0c29b58d,0xf2bdd575,0x0b5f48d3,0x06bdae8d,
	0xc54bbddb,0x67b351fd,0x748d1df3,0x4e5997b3,0x8aeba6df,0xc80f83b9,0xf7e71737,0x719735db,
	0xf9c15b63,0x106f3dcf,0xc0fdc2ed,0x9289bbd5,0xae73667b,0x7c9b35eb,0x73c9e62b,0x4ee7896d,
	0xde8d2883,0xe881e141,0x95ab41d1,0x7117187f,0x91832c1d,0xd1377191,0x96697787,0x411f09eb,
	0x79b39b35,0xf5f9f21f,0x79370ebb,0x75b35299,0x6d5fd3ff,0x993184b9,0x1da999a5,0xc52d887f,
	0x7fb31df5,0x616bbeb3,0x28c1fa45,0x168f4f91,0xb9c77edd,0xda5f25eb,0x8de9c761,0x5285e6d3,
	0x7393afbd,0x95e9cdc7,0xb7efd189,0xd461d54f,0x4cfd31ed,0xed0f1431,0x520dc813,0x7b1bb713,
	0xc6d18405,0x61017ea3,0xb0e1fe1f,0x5a572a3b,0x7bc576eb,0x9c15b717,0xdb754f95,0x0b5fdbe9,
	0xf971a2c9,0x12c9a911,0x34392623,0x9e25b543,0x395ffc11,0x44c5bea3,0xc2059e41,0x2a43287b,
	0xb9f58881,0x9dd33d5f,0x1919cc2f,0xfffd9dcd,0x378d341b,0xf6edc363,0xe41f20f3,0x793b0079,
	0x055fc629,0xb72fe453,0x0d25ef5d,0x6a8f6bc5,0x0691f63f,0x94e1e65d,0x86a31103,0x3435f807,
	0x4731a139,0xf6719f39,0xb47bab45,0x730fa795,0x352f1e3b,0xf373711f,0x74f5144b,0x51a773d3,
	0x796bb3ad,0xf5a967d9,0xc9bfd803,0x792f7a27,0x70a92c45,0xf9f575b1,0x20f5dd25,0xa2814905,
	0x44938bfd,0x7169d07f,0x3e15aa31,0xc71f4ce5,0xa4bde519,0xc2396e9d,0xc307ca6d,0xf2355d49,
	0x1fa74d25,0x68c5a3f3,0x591b52e9,0xb19569b9,0x1bb1f1f3,0xb891deef,0x7a0b877b,0x26b746c7,
	0x702b4e9d,0x3d4d8583,0xd8f79fc3,0xb7bd9b0d,0x9e478089,0xbbcff22d,0x6b65ac29,0x6075ec2b,
	0xaa21bc61,0xd31590f3,0x12499adb,0xa34fcbc9,0x93bde319,0x3d451c65,0xe2f75cd3,0x1a65249b,
	0x700936e9,0xb0adfa93,0x10312acb,0xa879a75b,0x21d93059,0x60c5ba1d,0x7321ea4f,0x49f757c7,
	0xb2e97331,0x1f29af29,0xb455b2ad,0x85ef39a9,0x4cdbe387,0x1ca1b063,0x14c771fb,0x7f1d1dd3,
	0xd23fdab3,0x4a19f401,0xd6d5b21b,0xa4e38f1f,0x17877c59,0x59ab0cbf,0x47497db1,0x044bdf6d,
	0xbc0f2b67,0x5f9106e3,0x6653652d,0x390554a7,0xa31d1f0d,0x1333a53b,0x308ba3c7,0xfe6f75bf,
	0x0cdb17c7,0xb021be1b,0x87f1647f,0x608977ab,0x4f5f3459,0x770fb861,0xbced271b,0x8cffca71,
	0x2fa5e6cf,0xcedb2873,0xb751452b,0x4421c615,0xda91097b,0x058f8d3d,0xbf539705,0xe9eb77ad,
	0x7ded13f7,0xb1532d33,0xe69538c9,0x36ff8e4f,0x81737029,0xb1831355,0x111f6f5f,0x89a5681f,
	0x5fb9ef3b,0xcf9b2c27,0x9e61ad77,0xd6d33f43,0x1f475ea1,0x004182b7,0xb231b885,0x3b2176ef,
	0x6b873d15,0x44439d99,0x1dd3edcb,0x2bd10859,0x4dcf8f99,0x2997fbeb,0xe8eda74f,0x47cd0fc7,
	0x865bd67d,0xec5db251,0x7a91c0e1,0xc8a9797f,0x854f224f,0x37db27fb,0x62353d17,0x939fced3,
	0x03b748ed,0x877df39b,0xc0b90a51,0xea91231b,0x3c873a7b,0x27dbd871,0x5167e7b9,0xbd0720bb,
	0xc59d7661,0xd7b3e341,0x12f16a39,0x99373619,0x08bba055,0x08eba757,0x906b218b,0x3cf7e2a9,
	0x5c8f3553,0xc1939b8b,0xca57dd2f,0xc6cd23e5,0xbdab609b,0x1cdf9739,0xbf9f116b,0x86e30249,
	0x278df0bb,0x6c2d6f45,0x96915c4f,0x70093e65,0x8d996c85,0xf805b31d,0x65e72ab1,0x28b91dc5,
	0x741b4813,0x611389b7,0x9dbf7d33,0xbc195803,0x294939cb,0xa131ae91,0x10a3cd39,0xeaef23c3,
	0x9e3baf57,0xac5b8ead,0x9c8311f3,0x1cb163ad,0xdff962ab,0xb1b5859d,0x73b7e55b,0xf075f373,
	0x306f0f01,0xfc913a71,0x05ffc92b,0x6e0114cb,0xbf7145dd,0x75631cc9,0x89838bf1,0xd6bffc79,
	0x03b96409,0xc2cb01cb,0x23d5cdf5,0x16bd7f47,0xb3eda699,0x0a8de125,0xb2eba655,0xd5bbdf03,
	0x5f995feb,0x5299b207,0x362767eb,0x2817b789,0xa8334c9d,0x82056835,0xd7518661,0xdfdf0bb9,
	0x1a15089f,0x020f10ef,0x93979b27,0x7dc1727d,0xa583a421,0xff1d1005,0x84958a71,0xc21b63c7,
	0xb7ab589f,0x49bf7ccb,0xc949c841,0xddeba58f,0xf3a15ddf,0xd7a79f21,0x0f1bbd5d,0x43e1d8d5,
	0x8b5fdee9,0xe4b78c67,0xbadb4c55,0x194926a5,0x38cb0f11,0xb3f5e48f,0xb1c37681,0x47230d0d,
	0xd6b35ef1,0xf08faf0d,0xc27320fd,0x2b0d4c2b,0x99c7d16f,0xaed957dd,0xadf1f9b3,0xe853f31b,
	0xe9a970b5,0x0d53cc85,0xd0af7c53,0x58e98d0b,0xd9d7e337,0x75a5b913,0x6b851751,0x9e656e29,
	0x42c120af,0x7d99e51b,0x8cb570ef,0x530d20af,0x7abb4721,0x6829b0bb,0x98e3cc33,0x5ac9f1dd,
	0xaeff8fd7,0x4673b199,0x74238ded,0x542d9eff,0xdcb56467,0xb8bb6fdf,0x4aede1b3,0xa9712265,
	0x69e793a9,0x4f714347,0xfb1f7ee7,0x4179a069,0x5e87a6c3,0x8c2b500b,0x1d038dad,0xd0cf746b,
	0x3d77561d,0x82a5a3f1,0xac49abf7,0xcaa55dd3,0x7d751e6f,0x19c97345,0x51091279,0xf1d7cd15,
	0xa231f5af,0xeca375df,0x48c3d9b5,0x89e350ab,0xf53f2025,0xcb6b641b,0xef5f5ef1,0x27f72213,
	0xdf1b2557,0xdc7d93dd,0xe82fc93d,0x23e5d2d7,0xe029e51d,0x5d5fb595,0xe6e9ae71,0xa9251989,
	0x29b3cc91,0x03c3b135,0x18afd829,0x67dbbec3,0xd6f12b15,0xfe7ba33b,0x2d0928cf,0xe5d1aa25,
	0xc5ffa757,0x9687f9af,0xfee5a093,0x6f790f59,0x10dfd445,0x700db11b,0xdd9f8269,0xa8efbb11,
	0x267de61f,0x6b5db197,0x75f59913,0xbef18003,0x83af8767,0x25eb4bbf,0x5b0f9c19,0x37edc3f3,
	0x0c31cde9,0x1b55d5b7,0x2f7db4c7,0x64f52cab,0x03a74fb5,0x6663682d,0x6e392335,0x72c16cf9,
	0xa69d582b,0x2203bb57,0xd3a10345,0x1ab531bb,0x63873ce9,0x6a4923f3,0x6681319b,0xf3db2ecd,
	0xb3c1d2df,0xfd77b043,0x210550a9,0x63e54c1b,0x9491033d,0x7cef6517,0x39c7eda3,0x302df297,
	0xa0238081,0x4e439ac5,0x0cc7c58b,0xaeb57939,0xc6899b6b,0x1c277a27,0xa46f2a27,0x9729b201,
	0xa6c13809,0xf77b99a5,0xe28d8707,0x73db96fb,0x87afe2ad,0x1845ba2b,0x495b0683,0xb2c31737,
	0xf11f04f3,0x3eb1a42f,0x647756b7,0x568503cd,0xe4c53abd,0xb41724ad,0xd1eb8e8f,0x47691ce1,
	0xb73fc739,0xebf52a2b,0xeb2732b5,0x44653e9b,0x890f29d5,0xc4f101b7,0x0e015aa5,0x7411ae2b,
	0x5fa3d353,0x69d9b3e5,0x85bdf59b,0x95b186cb,0xde4dfab1,0xd2a581d3,0x14032f9f,0xd22b46bb,
	0x9f4b923b,0xe5718227,0x19dff681,0x2d177c49,0x2cc35c87,0x37855e0d,0x60cf9ed9,0x95ab92c1,
	0x99bd216d,0x6e4d2e39,0x83ada903,0x97cbbf7d,0xbb2f0313,0x406177eb,0xf7c7a62b,0xacff0ee1,
	0x00f7f2e3,0x168149e7,0xb5cb3d3b,0x2d7d9155,0xeed7468f,0x4c8f797b,0x82cf4fef,0xe11da849,
	0x357d6d15,0x129dff7b,0xd9573fc3,0x30617339,0x6b7dc3b5,0xeddf7545,0x724952ff,0xf5755ca3,
	0x66518afd,0xd9b5b1bd,0x6df539b5,0xed29c711,0x335ffbbf,0x08a38653,0x1d15b2b7,0xc7f9da17,
	0xb0f57c17,0x45599bf9,0x69c750a9,0xdb076f4b,0xc743f467,0xf3ad702f,0xe0975eef,0x711b1f4f,
	0x4169445d,0xb19b71f9,0x5971e6bb,0xbbab6ecd,0x466bd7e9,0x984d3ee3,0x40afd401,0x63cf1b77,
	0x72335c47,0x1d0f0005,0x80113a83,0xbb498903,0x8e9594fb,0x9259e6fb,0x07c1bac9,0x8d854e37,
	0xec5150cf,0x48c7cae9,0xf74d071f,0x9093e1d7,0x5c077ed9,0x501fe57f,0x66ad889f,0x762f67b9,
	0xc7476373,0xd853afef,0xcf432425,0x9cb99db3,0x6983ed3d,0x3275dff7,0x14d71f5d,0x603fe8a9,
	0xa9172a27,0x71c584df,0x2e9925b1,0x0b6f8181,0x9047dc63,0xaca94471,0x70216d5d,0x68a7c22f,
	0xe6432f69,0xddb1b805,0x726ffc5d,0xf2e792ab,0xe8198d01,0x6491e975,0x9ceb0d79,0xa6dbf5f7,
	0xa1cb9233,0x2727f029,0x4e679543,0x73d3b71b,0xe73b2453,0x527bae0d,0xa619e70d,0x4cc93629,
	0xed35a5fd,0xbbbbac97,0xeca379fb,0xd9635539,0x826b4c13,0xe13b19c5,0x9d0bcdf1,0xc6e7856f,
	0xe87f92c3,0x8b7de519,0x0dc570a1,0xb94bf3f3,0x4cefd27d,0x0e25fca3,0xb9a52281,0xdc27d6f5,
	0xe22df4fd,0x2901a9f7,0x28ef1bcf,0x13bddaaf,0x98894a47,0x89070f35,0x7a497193,0xcdf7ae63,
	0x77417da7,0xe957c3fd,0x8bc39a9f,0x7369b159,0x9577aaaf,0xd4359281,0xc3d71485,0x784dbfe3,
	0xb33b9239,0x04115475,0x7a6528a9,0x0d83205b,0x727fef6b,0x6481f015,0x01b3d12f,0x71979021,
	0x3021ecaf,0xb3437527,0x4f73be09,0xe1bd709f,0x7ce3b8b7,0xc13d59f9,0x45bd79ed,0x2acb1447,
	0x36713b81,0x537fd85f,0x9c11af59,0xda472b8f,0x4061eb4f,0xa43b6ab7,0x68598d97,0x0f5b51fb,
	0xdd2fc1ab,0x83d568e7,0x47e34db3,0xebd5bb15,0xa73f5069,0x19cdc55b,0x2867d787,0xa535ff6b,
	0x29ddf6a5,0x45d7ea07,0xb10786af,0x35990999,0x1a3d35c3,0xa0c5b56b,0x4b4b0f97,0xaccd2341,
	0x307d266b,0x1d99978b,0xcc238469,0x21452209,0xa09f0d93,0x4a75cef3,0xbce77a21,0x4117b4a5,
	0x33911175,0x31abc5bb,0x44574d7b,0x8309cfcb,0x00250e95,0xdaaf8e7f,0xaf9b8801,0xf7833b41,
	0xc4198cbf,0x6b218165,0x9b4564ff,0xb9993ecd,0xdd11d405,0xe7c5f917,0xbc4b768f,0x00036f41,
	0xe19921c1,0x958b2fcd,0x490f6a8f,0xce279b75,0xda27fd99,0xfa893c45,0x0257efa5,0x450bd94d,
	0x1a15ae77,0x7efb2ec3,0xdc57ba43,0x9463b2af,0xb8a7cf8f,0xae4b4e13,0x47a3a99f,0x8b89728f,
	0xaa09055b,0x1805748d,0x1a3f0cb7,0xca8191e5,0x7853d29d,0xd0e18d0b,0x18910755,0x92f344b3,
	0x9c7d8d65,0x93bb2ff5,0x1e691705,0x39332701,0x776f7401,0x829b6039,0xe801b821,0x353909e1,
	0xeaf1e20f,0x87ad6849,0x7af72ac7,0xd3a9e06d,0x92b9a573,0x5649d723,0x2f5557dd,0x86cfccc5,
	0x9d657355,0x0bed9d4f,0x588bd615,0xd7994d11,0x45797d2b,0x714149d7,0x8e710ee5,0xf6a38887,
	0xea5f25b1,0xdb0f6751,0x9649838b,0xed31bc5b,0xc96bd5e7,0xab51f8dd,0xebb73211,0x6e2bc8d1,
	0x56ddf219,0x7225171d,0xe9cf1a43,0x4723de33,0x36d5eedd,0xaecfad3f,0x9409e2bb,0x715549cf,
	0xd663860d,0x30bd55f9,0xff439dd7,0xc2a36301,0xa4770bcb,0x18895887,0x5ac7aebd,0x3e979829,
	0xeaf1e383,0x78efc5af,0x9943ce5f,0x07639bb1,0x479514e9,0x97d3b4bf,0xb9d33073,0xeee3b10b,
	0xc50d00f5,0xcf47a08b,0xb0f5c877,0xa79519ad,0x93ef36ef,0x0e81e471,0xf191aeb5,0x95a7a21d,
	0x63b56961,0xfadb5957,0x95f9a539,0x3feb4edf,0x5bc7831b,0xb0e112a9,0x28e3bcdd,0x60d92989,
	0xb46fdc3b,0x253d3b5d,0x0e711a3f,0x97952db1,0xefdf8f25,0x25c712ef,0x8d29dac5,0xb8e955fb,
	0xb339ed81,0xfa7d0a65,0x76ff19a1,0xc045c90d,0x3f7b1545,0xa685014b,0x724714c9,0x60c9269b,
	0x8a95a5ad,0xc92fa2b9,0xe2c571fd,0x3631f45d,0xf85b9439,0x1eede24b,0x729da3c1,0x95eb2b13,
	0xb38921b7,0xa2619927,0x3b656e69,0x0007e389,0xa6c3ef39,0x4d5142f7,0x8f0f8d07,0x3041238f,
	0x15953319,0x79abdaf5,0x6101767f,0xcefbcaff,0xd5730dff,0xe283d8db,0x4eff4277,0xc23fa0b7,
	0x26b9ffd1,0x451b4def,0x4a3bae5d,0x1ebf7fa5,0x2dad7cc3,0xa1d521fd,0xe04d4269,0xb8d5a3b7,
	0x0b79a253,0x1d43705d,0x24359699,0x558316e7,0x97330c43,0x811904eb,0x375db7b7,0x7b753e37,
	0xb6d7c99d,0x5d37f90b,0x7293ac4f,0xe3fb86af,0x584971b7,0xc8a170ab,0x2f0f19bb,0x8c113263,
	0x0a555929,0xc2877741,0x2f730919,0x65594567,0x35afe6d9,0x333ffccb,0xa8c7cc51,0xa71d92e3,
	0xf5f508ef,0x8d47f2cd,0xeb7b0311,0xbf4de9f9,0x92a9c9e1,0x0e458953,0xac67bfd1,0xe38762e1,
	0x9837056b,0xa0078bf5,0xedc9cccf,0x420bcbcf,0x90f73d8d,0x5983decd,0x884f1115,0xd2c53607,
	0x5e218f95,0x9fd91b83,0x5403156f,0xc845a2d3,0x30dbc915,0xe74f4e43,0xf161a977,0xa0c7d081,
	0x23319ce9,0x1451d2c3,0x3249a88b,0xd72d276f,0x7117f833,0x7c795141,0x2301ded3,0x33ffc6f9,
	0x516b775f,0x8781db7f,0xb33d0e3d,0xbe73b28b,0x6eeffb21,0xf05129cd,0xff111381,0x4d611e97,
	0x01515d73,0xa5f9f7ff,0x38012b1d,0xb84bdd93,0x86234699,0x4cad8275,0x2df3565b,0xa85ded05,
	0x19e3221d,0x5ecb2311,0x7837e047,0x09672273,0x70f733d5,0xeddb0e3f,0x3e8502bb,0x1ae5f86d,
	0x70a7ccd9,0x038b2ff9,0xa201ab55,0x20f77b91,0x6829a08f,0xa2b128b9,0xc62f607d,0xb56b577b,
	0xe99b399f,0x68496a87,0x7a014661,0xb8af03d9,0x42ff8f01,0xcc7d75eb,0x80cf43f9,0xe2e11159,
	0x9743b8eb,0x03993701,0x7b594805,0xf4c196b5,0x973bc5e5,0x7f158261,0x70c9ae09,0x88b9bdaf,
	0xdaa1afb7,0x0e8bb231,0xf7adc359,0x83dd700f,0xd91d7075,0xa0c76321,0xfefd6c09,0x26e724a7,
	0x83373779,0xa4b35165,0x371be7f9,0xbf39cc4f,0x7b67be6b,0x0a6755b7,0x1acfb7d1,0xf7dbdeeb,
	0xef07be31,0xe4218261,0x9847a1ff,0xca818863,0x0f5b8401,0xa747602f,0x5a1fd7bb,0x1087f5a7,
	0x2a91a655,0x0d694b75,0xb0553a03,0xb3edc1b1,0x64bdd9f1,0x9539f111,0x1951bea1,0x805d8285,
	0x10d9e6df,0xa39beb67,0x6ae5f521,0x942b7627,0xa9cdbd75,0x44917f67,0x9b47abdd,0x71514fab,
	0x6b63ab4b,0x8c497983,0x2a17b4f5,0xae6f242b,0x8b4db047,0x981d2abb,0x2961cb4b,0x47d377c7,
	0x122bf391,0x2f878593,0xe6919793,0x906b6aa9,0x548158a1,0x05315b17,0x3383d543,0xc2d50603,
	0x0bb9342d,0x97e5b7df,0x4f73979b,0x324fa90b,0x0f29213d,0xb39f6105,0x700daea1,0x1bc99607,
	0xad0df619,0x92777131,0xea5f2c23,0x16d19f3b,0xa389d955,0x9db91591,0xfbe308bb,0x26a1f3fd,
	0xb9a776cd,0xcecf6ad7,0x3377e8c9,0x6b1d0da3,0xf85f54a3,0xb04f7a41,0x7a65016f,0x71d1bc91,
	0x838d4843,0xfefb5697,0xbd5d1da1,0x26eb552d,0x12f10b61,0xeab75923,0x3577c317,0x6647fceb,
	0x0b3df0f7,0xf7937ebd,0x5133774b,0x2c691743,0x3701ba49,0x7ec1e4bf,0x3d7b2489,0x6779d2b5,
	0x1fb98be3,0xcfa36611,0x0e9d9edf,0x684bd5cd,0x06cd0297,0xf0bf581f,0x89514923,0xf3570c1b,
	0x7e87687f,0x00c167df,0x8bb9d9f5,0xf1c39337,0xa31b0a01,0x378396cd,0x165d40bd,0xc255c7c5,
	0xf3a7aac7,0x86ff57ef,0xf52baaa9,0x2a81726d,0xcb2d1ac3,0xdc5dccd3,0x087fa7b1,0xe76114df,
	0x7999eb33,0x00ed228f,0x2e176f95,0xdeb956d5,0xfcc14397,0x1b230ebd,0xca1b46d9,0xeff19311,
	0x5961d6bd,0xcf9d6c85,0xf01b03d1,0x651d845b,0x941df7b7,0x0223f991,0x2c11b391,0x03f51285,
	0x4a81cee1,0x36a3331b,0xeb5d5ef9,0xbedd3f69,0xec03aedf,0x923352dd,0x85c7efb1,0x05df33e7,
	0x92fb8999,0x7c116c1d,0xe67d3527,0xb7ad6ce9,0x7db18545,0xdea1a8a9,0xd5190993,0xb2a1085f,
	0x2751b15d,0x0875a5d5,0xde9d96f5,0x05bf3245,0x00eddba5,0x2d43f17f,0xde6dbc13,0xc1afb199,
	0xca858529,0x86e7a70d,0x275f917d,0x69c59565,0x8bf9f73b,0x16672c69,0x4ca50e89,0x04f901bd,
	0x2e177875,0x04f30f0d,0x8ae5ce57,0xceef1cb7,0xb393a1bd,0xa4e100f3,0xd123f4cf,0x88f11b75,
	0x120bd33d,0x12aff59f,0x69d1339f,0x6af16f21,0xab01c967,0x76055f23,0x43c7ef3f,0xb48911ed,
	0x64e351f9,0xe2ad8b11,0xdb4583ef,0xddfbf411,0x640520f3,0xd9a11f87,0xc2f3aab5,0x693388cd,
	0x63a1c5a5,0x69fdb829,0xcce3fe61,0x52c3736d,0xaeddbf9d,0xf209a325,0xd38ba089,0x22e35441,
	0xb9c7b3b9,0x8033be31,0x22cdfe8d,0x9e77b5a1,0x5a4fc11b,0xd40f738b,0x80f1b695,0x180918ef,
	0xa155f631,0xff5fd6f7,0xd7a79c8f,0x60cb2397,0x539be5ab,0xa705e2c1,0x7d05df33,0x5997ec07,
	0x02cf5b85,0xe413d4c1,0x1c8f4d01,0x23ef66b9,0xc6853203,0xc4bdab51,0x402bb93f,0xf2fff32d,
	0x953946b1,0x6d63c259,0x792b80fd,0x7c9708f1,0x3d4d8f5f,0xd9899045,0x29453011,0x0a330491,
	0xfe114f2d,0x3cdf830b,0xeb99461b,0x29f514a7,0xc0b56b7b,0x043bfd29,0x9db31b83,0xffa746d7,
	0xf159e0f5,0x769b72a1,0x087fe679,0x35bbb4c9,0xf801588d,0xf625a603,0x2957dff1,0x8e4bd12d,
	0x5197dc81,0xe1270565,0x1afd88ad,0x1419d4bd,0x48f1ad53,0x13192761,0x9e950e33,0xeb914b3b,
	0x4fc936cd,0x0597681f,0x44b3cfd1,0xc3c3c06f,0xf7c72503,0x9169a64b,0x364f03a3,0xe76b8d2d,
	0x8b759951,0x4f7b201b,0x9dc77b83,0xede9c44b,0x47477f5b,0x99e7704b,0xafe58a1b,0x0c4b3fab,
	0x32990209,0x2ce7ab21,0x54d907d9,0x0641cd37,0x98b12091,0x67e39b6b,0x713b77f5,0xbf257bdf,
	0x21b9636f,0x2e6b1f7d,0xcf0b4d6f,0x6af9089f,0x8bc7b163,0x6933a635,0xa6b3500d,0x5f696b75,
	0x03d7447b,0x2719cbf9,0xc7ff215f,0x84c5846d,0x1ecbbf07,0x5e2717b5,0x632de1bb,0x6709e895,
	0x727360a7,0x4c85d7dd,0x71d9f543,0xe6d5cf0b,0xce815b3b,0x798f1f71,0xc00be8db,0x8a771deb,
	0x159347ef,0x56c1e2f5,0x95377733,0x6edd9761,0xb62bbc35,0x80c13577,0xfd33adc3,0xd8a5269f,
	0xc3b5fecb,0xa05da58b,0xb13d31cb,0x650f4cdd,0xaf87dcb3,0xeb8bba4f,0xa101a551,0xdb07ae5b,
	0xa1dd9e37,0x466b9067,0x1b8f2c25,0x9c1dbf65,0x72db1bed,0x04439703,0x985d10dd,0xb58d914b,
	0x438df3ad,0x487f6cd5,0x204b89db,0x9137bf67,0xb6e7dd9b,0x07b7dd1d,0x56a59e43,0x46a97c17,
	0xcac72125,0xa8a9fc9f,0x22172b05,0x8c11bdc9,0x50ef29fb,0x453b66a7,0xf5bb07d9,0x474d8beb,
	0x080b3d19,0x8b7d9a0d,0xba134c3f,0xbedd6bf7,0x54b34dc5,0x3ea3762b,0x5603b47d,0x6aebee6f,
	0x9a5ff285,0x580bd7eb,0xd7df26a3,0x664b5bdb,0x34757a31,0xc83d56b5,0x3e5f5787,0x7f7781cd,
	0x0f4120e3,0xd7e72181,0xe1a18fcb,0xe98f9fdf,0xe0f764fd,0x28ddfbcd,0x7c2f90d3,0x8d6174b1,
	0x02b57c2b,0x57215a9b,0xd3f999cf,0xfa5b6aed,0xe97de861,0x39d5a17b,0x03578cb9,0xf79be643,
	0x3f3d2cd9,0xc44b7f83,0x6209334d,0xb4e1b06d,0x9bc7a315,0x86f76c4d,0x0e39a413,0x9b97862d,
	0xdddb6fe5,0xd0794501,0x1573c75b,0xbfd1c44d,0x24199857,0x6e95094b,0x3db5fc3b,0xf149349b,
	0x660f36c9,0x0f3bb861,0x6e59dd93,0x6c5ffaf3,0xad33cfdf,0x41814e01,0xb92d270b,0x2b1fa237,
	0xeddfc781,0x16a5df6d,0x035fba13,0xd63d494d,0x8057f5e7,0x630dd875,0x4e85c2df,0x560ff027,
	0x39c95c87,0x9f49586d,0xa1a3fd71,0x039be4c1,0x2547fb27,0x690baf35,0x921f1a8f,0x79895019,
	0xdcd1c4d3,0xa435fa2d,0x6cc944c9,0x052de33b,0x8247b4dd,0x3bcde147,0xfedbc577,0xb77fa437,
	0x587903e1,0x830173f7,0xfef5c9b5,0x1625db25,0xfc177cc1,0x36252639,0x161d476d,0x6c651f29,
	0x3cc1f1a9,0x1bb9ed93,0x88c5024f,0xbc338369,0x95fbd10d,0x45657e13,0x7fc7b0cf,0x4f2be419,
	0x482fdaa7,0xf0f3a74d,0xf15f412f,0xe78b5371,0x11b3f47b,0x095dd15f,0x2a393e75,0x9141a6b3,
	0x87c11fd3,0x47c199ef,0xf6635571,0x12df2327,0x0f818e45,0xf4639127,0x6a55f9bb,0xfe9d4b1f,
	0x76fbd6a9,0x47b316c1,0x4bf32aaf,0x6361caf3,0x2e274a23,0x6b4756f7,0x1b815877,0x1db18607,
	0x1fdf6921,0x1adb678d,0xbcaf6903,0xc8c1c3c3,0x2ae97853,0xe55984d5,0xbf99dd07,0x4f6b7c97,
	0x3aef35b7,0x0dcd6ea1,0x49bd1505,0x1d33c6fd,0x0187ad8d,0x0c6fe54f,0x9f05b643,0xef416477,
	0x4f2d2f63,0xaf9b46c3,0x4abd2fd1,0x45696e8d,0x0c43630b,0xdcd74b6b,0xe8a35f87,0x732323d3,
	0xd2197da1,0xf1d5e33f,0x8dd15701,0x5093d4df,0x23e19687,0xc56732b7,0xd1d540ab,0x8b83f153,
	0x47b91c69,0x488dafdd,0x779d64af,0x986534d9,0xbfa16a3b,0xc76d5f3b,0xb67f4e09,0x4353f421,
	0x628b7c37,0xca5730e9,0x233f0f75,0xe11189e7,0x1547c4e1,0x96bf7d83,0x3903a87b,0x2007e3e9,
	0x23932203,0x5043a32d,0x825b8a6b,0x79472ff1,0x3913f1b3,0xb9abc295,0x62413d5b,0x418da8d3,
	0xfa514749,0x95e59bf1,0x7d15252d,0x5a3b8365,0x3dc7406b,0xa9058bfd,0xc19d6685,0x825bfb89,
	0xe4cb7a03,0x594da901,0x120bebd5,0x479f812b,0x54a5a543,0xf01fffc7,0x8cf78a51,0x97610537,
	0x8f813ca9,0x7b0df0a5,0x766346fb,0xefa566ab,0xed7158f5,0x4ccbac7b,0xc0b3bb99,0x3013ff87,
	0x7573a635,0x1e39d1ab,0x35bb9bbd,0x0afd51d3,0xd66b78bb,0xcf5d2923,0x3fb359b9,0x165fd49f,
	0x00250223,0xc8638357,0x5239ebb1,0x7cdbe109,0x5c55a64f,0xfaa3b549,0xf357b089,0x4ebbbf2f,
	0xa799706b,0x819bb579,0x647d74f3,0x72f1d339,0x6a73a7eb,0xe3f1d8f7,0xeb839863,0x3817ea5b,
	0x12518589,0xf4733057,0xbba9521b,0x856fa7cd,0xaa850849,0x531904b7,0x7e971621,0xabe511d1,
	0x354dea77,0x8dff74bd,0x7d5f1a47,0xd7093eaf,0xa4cdb6a3,0xe26d3195,0x6977fb1f,0x1e1721b9,
	0x7413fcad,0x9dcf5bf3,0xc5c1810d,0x34f17849,0xe00fa6b3,0x1ebd8117,0xef838535,0xbd21d6bf,
	0xc0a16e25,0x75f7b7c5,0xc771f689,0x36d9d585,0x018b70b5,0xa75fdd4b,0xfa9ffebd,0x91f35e0b,
	0xbb7be55b,0x8b07f27d,0xeb914753,0x5ef117cb,0xed05f15f,0x4e2398b9,0x3b2d5e93,0x9ffdf547,
	0xd3a39d49,0x9413aee3,0xf1c33c89,0x39ede109,0xe4bbe9ed,0x375b0e6b,0x480de80d,0x05378a9f,
	0x669b0567,0xaaab6843,0x102b3bc1,0x7efd53a5,0xa973a019,0xf9d941eb,0xbea3cb09,0x1a0d5cbb,
	0xe06361af,0x6ae11267,0x1367e717,0x2fd7b28b,0x9a6f7e1d,0xbeed7f43,0x62cfc3df,0x91739ac7,
	0xdb816a9d,0x1349b997,0x7e9dbd25,0xb8a90127,0xd56db2b5,0x626dfaff,0x3ef5bb6b,0x98dd046b,
	0x40f3ed2b,0xa4f5229f,0xab6bb903,0x1025a35f,0x56b3d117,0x92a77225,0xc3f76705,0xf83b89d1,
	0x683d6ad1,0x03756ac9,0xe9f7f24d,0xd781fd9f,0x190370ff,0xf071ca43,0xe935e887,0x31ffeba5,
	0x3761b98b,0x14dba7dd,0xa0e13d1d,0x7a6b14d1,0x359bcea7,0x2f19b161,0x4c916e4b,0xa31d5b0f,
	0x42dfa3d1,0xe1bb8827,0x6d49ca0d,0x4f172e5d,0x04416acb,0x34753e09,0x5271d32d,0xa30319bb,
	0xedbd889f,0xb525f26f,0x42d5c637,0xb6357031,0x3b37aaa1,0x38d38f45,0x45b13e83,0xa3a719d1,
	0x8979fb6d,0x3cada601,0x8ba5fb33,0x3afb80b5,0x0f3b77e5,0xe7076c9f,0x77b9c42d,0x51799dfb,
	0x76176435,0xa863daa7,0x485b6f1d,0xb31526d1,0x5393e0d1,0x7c65e623,0x6067047f,0xb36bd965,
	0x42199f75,0xcadbe0a9,0x3019048f,0x5ebbe9f1,0x99ffb821,0xe8bbf457,0xbe1dcc57,0x4af18fb7,
	0xca819e21,0x3925c0d3,0xd0831aa3,0x089bb1ff,0x52c3350b,0xee5d1849,0xb5bfb50b,0x33f9b51d,
	0x5ad105b9,0x6ad3dc6f,0xadb72cf1,0x25eb6767,0xec9f934d,0x421dfb81,0xf2afc47b,0x44f90e3f,
	0xcd0bd031,0xd9f98d45,0x62597395,0xf657930f,0xf4d5b31d,0xab4d1009,0xc6cd0cfb,0x2ee1d047,
	0xa9afec09,0x2329c5a1,0xbf8d8329,0xa417fe61,0x3729b937,0x23bf306b,0x4a7d4d69,0x9d2340e1,
	0x47c1dc35,0x2573b04d,0xecf1ecc7,0x63d9534b,0xdddbaed7,0xf7c53fb1,0x7ca1911d,0x55b15635,
	0xecc35835,0x22695091,0x88abde07,0x94d1bc35,0x91ad21b3,0xe631c967,0x6299cff1,0x58ff56ed,
	0xecb7ebff,0xde1f2239,0xc759c107,0xe0af8407,0x99e3c409,0x4055a193,0x28478e3f,0x01fd7a35,
	0xca1d980d,0xbf25b98d,0x9421dc5d,0x5ba9b62f,0xfc3d0c8f,0x0a0384c3,0x400f7ce3,0x261d87b5,
	0x55fb715b,0xee8f6359,0xb0a3f323,0xa46dbe93,0x9cfdd683,0x198db7ff,0x82d31935,0x35517799,
	0xcfcf4161,0x77edc4e7,0xd501e4f7,0x042d099f,0x5ee7019b,0x37c5a8d1,0x4ff34d0f,0x5a0b1289,
	0x059d261b,0x69517c01,0xcfdd4def,0x8e9fa43f,0x43391215,0x3ffb8d43,0xad530ecd,0x993f91af,
	0x73e73201,0xf34fbeef,0xa65926a7,0x41f1dbd9,0x89bbd0a7,0x400503df,0x67550147,0xf25d3eb7,
	0x65af0c0f,0x88f9fc7b,0xb4176439,0x26d5de57,0xd0a9ea8f,0x9833b3b1,0x30d913d7,0x7f5713cb,
	0x14778fbf,0xffdf7bf3,0xcb39983f,0x70815a27,0x34c99183,0x1b55ec3f,0xc3432257,0x949f5b91,
	0xc83f6d09,0xb013fd1d,0x546390d1,0x9ca31e31,0x715b1bc1,0x2ec14597,0xfe739523,0xe1275137,
	0xf78bc867,0x94295843,0x6eb3f88b,0x936fb9dd,0x0023a3ff,0xea454041,0x08cd0113,0x8e63c067,
	0x675ddad5,0x69331e33,0x0fcdf687,0xc7971d19,0x3961a97b,0x3837e547,0x6f31c781,0x6043a547,
	0x4b3791cd,0xcebf3831,0x23d5ce5f,0x564b384b,0x73d7afed,0xf5656633,0x4503b647,0xd539cc85,
	0x651b2f47,0x66e5880d,0xad6b802b,0x273f9c5f,0x24c9df8d,0x1123bd0f,0x4423a7c1,0x4637734b,
	0x258be9bd,0xf631880d,0xe5af6887,0x0ca51ac1,0xfff5a519,0xad454c65,0xecf722c7,0x06b1e741,
	0xcb878c2b,0x83b9eafd,0x5c47e08d,0xe32d6557,0x17a351c9,0x3e197f41,0xa65bfab3,0x84952691,
	0x8493160b,0x790f3c27,0x1753ddd7,0xb20bae8d,0xfc8fbb55,0xaa73692b,0xddb5ef61,0x68597fe7,
	0x8cb15b55,0xc2437f53,0xb375927d,0xcaf1494b,0xddffdbfb,0x6ba5662b,0x26e74d27,0xb4ed326b,
	0x4e63a483,0xede9d0cb,0x83cf0d1d,0xea1148ff,0xa9b37273,0xad81bacf,0x5c538ce3,0xe7c30dc9,
	0x82ab4e91,0x4d11055d,0xb203d8cd,0x561b2191,0x2befa1f5,0x6e59341f,0xbed9f3ef,0x18cf1229,
	0x510b6af9,0x134d4a4f,0x5e339d27,0x00434769,0x2f73923f,0x9effc7a7,0x15db3421,0x1a7f1035,
	0x6f835fb3,0x76b1c56b,0xbf01be49,0xa439cf73,0x9d810f89,0x42c5336d,0xcf3d0bd7,0x99c94919,
	0x4297873b,0xcfcd34ff,0x4191fcc9,0xe8330f1b,0x9ddb2a8d,0x8f7d9dfd,0x1f61e5e9,0x3e1d0e7d,
	0xfd49d089,0xb9b58fd1,0xa98115c3,0x7cdf3c47,0xb6c5d883,0x0d793663,0x212779b1,0xc96f628b,
	0xc11b5f19,0x31f9a52b,0x30f762d1,0x3d6f0d63,0xecff9329,0xb78bd427,0xf5f36b0b,0x382d97ef,
	0xbe0f2ae3,0xb8adbcdb,0xa8917a0d,0x4f995959,0xe3cdf8b7,0x1b059753,0xe5a7ea4f,0xe14df1d1,
	0x52a5a063,0x70613725,0x9775ce0f,0x438bb793,0xfced6be7,0x77b78871,0x7ea35457,0x963f43dd,
	0x2be34091,0x3e272cd9,0x5b414df3,0x33f91ff9,0x78a7b3f3,0xdff7388b,0xb5c9d27d,0xc2f5923b,
	0x654740e9,0xe9930f3d,0x481b0553,0xe6138af9,0x95b79c95,0x5895612b,0x067ffa9d,0x8de1b195,
	0xa8d52b63,0x3cb7481d,0xc8a3bc49,0xe98f9179,0xb1639607,0xf8e1845d,0x92a16f0f,0xf7f5e717,
	0x4f0f7e7b,0x2423d9c1,0x7dfb976d,0xb89b0ce7,0x676b5501,0x0ab18ca9,0x42977ead,0xfca58869,
	0x7ef54d29,0xcee9fef5,0x5fc5b7dd,0xd7e9b729,0xb21172c1,0x2a536d17,0xe53fc4d1,0xb1e19bb7,
	0x4e0ddee9,0xce9dcb03,0xdc23db2d,0xf6afcaab,0x0a190cff,0x669dc135,0x4ffbc957,0x681b77a9,
	0xe0554fb3,0x374fc9b3,0xf7b7fb7d,0x0e9ba257,0x86c365f5,0x60dd6d0b,0x7eafa097,0xca456369,
	0x88513003,0xbf939f51,0x6da5ef65,0x83df5997,0xfdd3845d,0x6ce93d25,0xb3bd8b6b,0xfdd336a3,
	0xe70324d1,0xe079a8a7,0xcf8b09fd,0x45316c55,0x2387d371,0xb10f8689,0x9805972f,0xc2b5f97f,
	0x0bed8799,0xf5959afd,0xa58dbae1,0xebbf56fb,0xaaa7c2eb,0x4623c6c3,0x5aeb3dbb,0x935d84a9,
	0x950f0653,0x5cf7241f,0x8e4f2e2b,0xdb3d3671,0x646f6705,0x577743df,0xd24f0569,0xc4bd2149,
	0xceef437b,0x97338a57,0x5eefec73,0x61dd6825,0x60a51879,0x42ddac65,0x9a952113,0xa6472909,
	0xd48b760b,0x67594c6d,0x43137ad7,0xd84f29fd,0x0d891481,0xb8a9b75f,0x369f1015,0xa1eda615,
	0xaf67097b,0xf2fbc1ad,0xdcdbfaed,0xc1c73a67,0x57dd1cd7,0xdba9c457,0x2fcd3e45,0x5c23f315,
	0x77853dc5,0xe22db9df,0x64e7cad1,0xebf77849,0xcae517b5,0x61317b57,0x3603a403,0xd3d95b33,
	0x7367c765,0x7f811d51,0xca5d251b,0x8f0f830f,0xb061afd7,0xb1136ce9,0x3fa16623,0x8281ba1b,
	0x380f6f55,0xd8058cc7,0xd2ddc0e9,0x6dc35aa3,0x3093f473,0x05a1b219,0xa98b7603,0x7c0f1bf5,
	0xc8fdb30d,0xdb510191,0x3a8971d1,0xf545ff6f,0x723ff945,0x8bab8c6d,0x5721317b,0x8ef15d6d,
	0xb8356487,0x7b716d75,0xd403c7ef,0x5d45125b,0xbaa57687,0x828705f3,0xd24702e5,0x641dcbab,
	0x46394a3f,0xccfd5abd,0xa86fafdb,0xc7f974d5,0x8d8768f3,0x5c059133,0x6b5f011b,0x9f03c45b,
	0x820bbf2f,0x27018c37,0x176b12b3,0x620de8c3,0xcd29b1c3,0xdc77a937,0x59498f79,0xfd9555a3,
	0x692d52cf,0x43139d29,0xf71b760d,0x82b9b093,0xda4bb6b1,0x3aaf7189,0xd969fdd7,0x7845de33,
	0x07a16919,0x5d45a15d,0xb4239c05,0xcbab2f2b,0xb42f01f9,0x3ffd5633,0x4f9f288f,0x6207ad2f,
	0x97e7da89,0x5427c521,0x71a12335,0x491787f7,0x1899e251,0x6837abc1,0x664f187d,0x884ba245,
	0xa3039419,0xc8cbed3b,0x293b26b5,0x91af3ee1,0xa3c90af5,0x01ab4f39,0x2e5ba2f7,0x5301cd9f,
	0x20773741,0x3ec556f5,0xcb0fde21,0xe6a5d853,0xf081339f,0x4d2f4629,0x3f2309db,0xe4a10fe3,
	0x9645b9fd,0x3c27381b,0x5dc33d95,0x53a97937,0xb805b88b,0x9e115e99,0xd6899b83,0x3a17ba41,
	0x38ef06c5,0x697f5ef7,0x1e7795a5,0xceef86f7,0xf2153a6f,0x7a27cf13,0xf8f352c5,0x4ad92e5d,
	0x0b759c93,0xb1e5d251,0xa0cd3371,0x5927477d,0xf4f33e87,0xb9bfd6a1,0x913f76ff,0x28d57e65,
	0xff5d2ee5,0x62e57177,0xeee7008f,0x1d858131,0x9563ce8d,0xa7ad5ccd,0x90cf3c09,0x20810d03,
	0x14a545af,0x4c97942d,0xa967231b,0x91bb1b01,0x46a518bd,0x214591a3,0x0f87623d,0xd8cd2d5d,
	0x79d1dd71,0xe187aac3,0x276f9daf,0x95fbbc53,0x3a7b0fcd,0xb6558da9,0x6bc7d677,0x732dc321,
	0xabe3071f,0x56cbddff,0x96a1ef65,0x94f56d13,0x81290af9,0xc931f1ed,0x6a75520f,0xab8fe279,
	0x965b8837,0xc3f5af2b,0x1b1fb3d5,0xa3dd35ab,0x296f65fd,0xaeab87f7,0x56edfadf,0xf869700d,
	0xb33f7ab3,0x43159815,0xef8d431b,0xa265bf05,0x608f210f,0xce15e1d1,0x23170343,0xaaabc107,
	0x2b0ded0d,0x10bdab03,0x850951d1,0x5abff28b,0x924d80ed,0xc141fa05,0x874f4a11,0x0dc73b13,
	0xf4c9823b,0xac0132bf,0xa3399111,0xa19b9a27,0x88e9aecd,0x7481d39d,0x227dfaa7,0x87b1f459,
	0xf5f511bd,0xf6715295,0x883b4e75,0x762d0043,0x8d25586d,0x46a71a25,0x99ff2cdd,0xb8d75383,
	0x22934787,0x5421a64f,0x08b51415,0x22258fc7,0x86455003,0x2905c1a3,0xb9b7850f,0x9c2fafbd,
	0x9d254419,0xcba1e237,0xafc7488d,0x59b77421,0x1a092c4b,0xbf6da6a5,0x940bd415,0xa729f0b1,
	0xd6ab3c69,0x26057315,0xdf13cef5,0x5b953937,0xccb3e881,0x80312e33,0xa1d7b749,0xe9b72e85,
	0xaeab19f1,0x0edd1e35,0xeebba6eb,0x10f16b75,0x2105845b,0xd423e5d7,0xe2833885,0x2e4d51e7,
	0x93231aad,0x343da15f,0x4d618c85,0x2d7b37c5,0xb843a417,0x3693239b,0xfbed6e25,0x19d9b401,
	0xa0977115,0x66b552df,0xa027985f,0x4f670b91,0x722f306b,0x5557a609,0x5a771aff,0x4bd1be7b,
	0xc207e425,0xb959c17f,0xe2afdf93,0x1f6734c3,0x8d07f695,0x30bf342d,0x51054e71,0x7e258b7f,
	0xd0f96f57,0xa1b75487,0x871b13bb,0x70ad81c5,0xc591484d,0x3b9b3d8d,0x38f90455,0xa54785b7,
	0xb56be2a3,0x17e7ebc3,0x960d22ef,0x60e9e181,0x770d9bcb,0x7b417a37,0x9233c501,0x102b084f,
	0x85e38283,0xb6777f7d,0xcea9d7cb,0x784f035f,0xbb3f2bcd,0xa77f8ab3,0x23174553,0x883ffef1,
	0xa75fa7f3,0xda79c07d,0xc68d7969,0xc98ff74d,0x8a679789,0x4aab980b,0x188506a3,0x717985c3,
	0xed63606b,0xc381b80f,0x09df6b63,0x11dfcdb1,0xdb4782bd,0xe193f3c9,0x25e1f6cd,0xea498975,
	0xb9ef0de7,0xb39f67fb,0x3b3dcdd1,0xd8ed3777,0xc32135a1,0xfb8bb7f7,0xa50d1027,0xeba1672b,
	0x1d8906e1,0x0f676a8f,0x33cd1d4f,0x90eb2609,0x95b93ced,0x5a67671f,0xb669f98f,0x68f58c93,
	0xf72f3651,0x7de99291,0x232fd2f7,0xb68f6b51,0x055109df,0x12758c4d,0x60d7a65f,0x703517d5,
	0x1467bbb3,0x08b98b4b,0xaf850463,0xf10759b9,0x42a7922f,0xaa895b09,0xb1bdf66d,0x49d1779d,
	0x512f8aff,0x3be77889,0x156f03ad,0x3207642b,0x1d01f015,0x3bf54f5b,0xdcf75617,0x98bf0b13,
	0xb80b0caf,0x46059695,0x4813ff6d,0xd5bfbe11,0x221f024f,0x928bcdd1,0x5ced5e35,0x7a71c1e3,
	0xa1fbbdbf,0x1827da37,0x1113a2bf,0xc2e5fb53,0xbe450c15,0x4c9dc373,0x127d7421,0xa6d5bc35,
	0xd685cfa9,0x85dd90bb,0x308db53d,0x8aa5b05f,0x5c31551f,0xfafd45cd,0x650969b7,0x9061eab3,
	0xaba7c865,0x653bffeb,0x7d25baff,0x88b7121b,0x852bc9ab,0x40fd32e5,0x62771d4d,0x8405ae89,
	0x25e5226f,0xaed3060f,0x03fd94a1,0x034995f3,0x00ef9a71,0xf46fd147,0xdf2319c3,0xc933795f,
	0x1843ecbf,0x9db3b9f3,0x28b91f3d,0x4b0f91d3,0xf5c3dcab,0x3da56fff,0x95f5366d,0xc1dd6d5f,
	0x443d6ad1,0xcf730ae1,0xc577d46d,0xdb3bdc21,0x08672a13,0xb7710695,0x48493727,0x0a75fd35,
	0x79dbb49d,0x641f60a1,0x4add6a4b,0x797f6bc9,0x7c1f40e1,0x8f25d513,0xde076c4d,0x99ef8c09,
	0xb79d569d,0x1e4d3b7f,0xe009736f,0x560bf833,0x52a9a3d3,0xa4910403,0x858d52b7,0xe1bb0d87,
	0x4a83f1cf,0x830fd443,0x82a1fef5,0x2b93994d,0x6c4b3a21,0xaa0b446f,0xd3bf33c1,0xedcba5d7,
	0xee11dba7,0xf9f5bc3b,0x26c53877,0x5f47677f,0xa7c7ef85,0x44636fe1,0xe3fdc541,0x849149a3,
	0xec49be25,0xed117d2b,0xd717080f,0x20db1bb1,0x025d5439,0x2ae92865,0x782bc995,0x47015e17,
	0x3dad37bd,0xe8f73963,0xd4b9b255,0x8a81af4f,0xb7cf3cf7,0x47737883,0x18a9af97,0xd08958db,
	0xa93f7b6f,0xbcb94ba9,0xb74d7867,0xc0ebfc45,0x625f62f9,0xd64f7343,0x345b329d,0xd71f601b,
	0xe47ff0b1,0x99e7e749,0x8cf537db,0x13495cf9,0x1ad103f9,0x8653d433,0x40a1fa85,0x4b33ea7f,
	0xb371d37d,0x3493b80b,0xfa530acb,0x1b4f4c57,0x98658231,0x98cd9f5b,0xd95f3ba7,0x77b95f31,
	0x0899d44f,0xe351823b,0x5a89e7d5,0xdd2f05c9,0x50df045b,0x0193c147,0xe0f756dd,0x221fb5dd,
	0x24f3b81f,0xbf31c2a3,0xdf39420f,0xe79b2539,0x987d15b1,0x86f3aefd,0xa0497983,0xaa5b16ab,
	0xb807f869,0xc3c74e8b,0xb087a915,0x73c3470f,0xc20545ed,0xe1c10609,0xe6b93d6f,0x2add7a47,
	0xffd56325,0xef23f3bf,0x0d116901,0x855ba839,0x3eb9c949,0xdd4f2c77,0x2a2948ff,0x989749d9,
	0xe8ddbacf,0x61d71887,0x69fd2a6b,0x0a93c61f,0xbe59187f,0x7771f0cf,0xa6f9ef0d,0xe2fbff0b,
	0x2e255661,0x7ef75bb1,0x92eb9271,0xfc21fea9,0x4f2790c9,0x00752a1b,0x800bceef,0x13fdc409,
	0x792bc151,0x0c153481,0xc9fbe2a9,0x7d333043,0x7de513e1,0x3b2f57e5,0xdec37483,0x700b137b,
	0x81f35b9f,0x514192c7,0xe7d3992f,0xfb7b59d7,0x75d7a801,0x7cf14237,0x1303f821,0x961b588b,
	0x2efdf9c1,0x390d7ec9,0x7b93109b,0x4f2f3ad1,0x20bd17e3,0xcd8d999b,0xb32b9ea5,0x9f9d8ee5,
	0xb54f84b1,0x708db953,0xeadd200b,0xdafdf315,0x46d992c1,0x0755971d,0xbc1f7965,0x4085e2b3,
	0xb86799eb,0x87515bad,0x91d3bb15,0xac19a313,0xaeef4c55,0xf71b9c43,0xb141063f,0xe741509b,
	0x6a4b2b69,0x0f6d77a3,0xe31791d5,0x9a330bb3,0x3e3f1cd9,0x7c2fd31b,0xbc71cf8b,0xdcc745cb,
	0xab791fa3,0xbd71b77f,0x87cbb0e3,0x677f2e5f,0x188b2107,0xa867ce2d,0xce110c25,0x64873fed,
	0x2af5f193,0x8871fe09,0x7f93215d,0xe0afecff,0xc0175a1b,0xe0132883,0xbd053f63,0xdc736d29,
	0x863f50b5,0xc9fd068d,0x408d88d9,0xfcf5aa01,0x35a34dcb,0xfa0525a7,0x66afd923,0xdcfd4c29,
	0x695dc103,0x5e2704d5,0xd75dc973,0xfe01e84b,0x1871a653,0x5f8d51a3,0xceefd5bf,0x59194c17,
	0xaecd3af5,0xc3834529,0x0727a1c5,0x9007eb49,0xc645d26d,0x2c812103,0x40295e0d,0xbe376c9f,
	0x7f95cb87,0x3b23cc55,0x69894ce7,0xe9b956e5,0x7b5fa553,0x4f2f90cd,0x6b3f676b,0x1449ddeb,
	0x73333431,0xe897f7a1,0x8ea92277,0xec47cf89,0x7281f6c1,0xa86dc68f,0x879153b1,0x1dc1a0a3,
	0xafa98aed,0xf1f11cdb,0x1d27368b,0x43659a1f,0x04ef42ed,0x2b89b051,0x73039139,0x779125f1,
	0x097dda39,0x9fc52a47,0xf225f9bd,0x85453c11,0xca694a93,0xfe59a49d,0xd1f53adf,0xb92def7f,
	0x23afc109,0x7d2346b5,0x4145d92b,0x52991b47,0xb931b2ed,0x992b027d,0x2f4bb7fb,0x94852f79,
	0x8fbf12db,0x779f716b,0xb4a7de6b,0x76911e2f,0x460ba5b7,0xe6d3d17b,0x1c655c67,0xf60b6889,
	0xedb177a9,0xff492235,0x8cf34f99,0x06e14baf,0x84377127,0x64a561a3,0x5127087d,0x24b10dd5,
	0x0c070beb,0x26b5e95b,0xc1454f4f,0x83bb6b35,0x457727f9,0x426feb7b,0xcbf3c919,0xe1e9230d,
	0x07c3009d,0xc2f30fa9,0x1f417ca7,0xf7cfa4a7,0x3a0f4169,0x82853011,0xf1a97793,0x89a7dc55,
	0x6c673b37,0x8b953669,0x6b099339,0x18512071,0x10bf392d,0x19b918ed,0xadab59c5,0x32593e5b,
	0x53f3f5b5,0x3aaff763,0x7f410b21,0x64f3a77d,0x96c92f83,0x0f5d5819,0x91dfc209,0xccf5be47,
	0x86ed5e8f,0xacd384e3,0x6d07b8f9,0x47e54335,0xd7f18921,0x9d43081f,0xf6a3af3b,0x44ede1c5,
	0x9c5338c1,0x011149b3,0x9bff6ddb,0x35dbdd83,0x3e778f43,0x4fbd4c09,0x1ad96cb3,0xa02fdefd,
	0x19a97bc3,0xb8fb891b,0xea4d9761,0xce07e0cf,0xb31d0fa5,0x259def63,0x43e5324b,0x1f313c9b,
	0x92f1f391,0xd8a5fee7,0xcc91dfa3,0xfa1bd807,0xbd27fc7d,0xb0350633,0xdda9c45f,0x5ce171c5,
	0xcaabe0a5,0x069f7f5f,0x6debcd3d,0x0e470e91,0xa2550c89,0x33578d07,0x9a8513c5,0x6eb5862b,
	0xd1dd97f5,0xabfd974f,0xd0016349,0xe93f305b,0x86e95aff,0xc55508e7,0x935bdddb,0x049fb1f1,
	0x28052301,0x144f2c01,0xeaf3c15f,0x1435e9cb,0x8da5079d,0x6f01275d,0x67914c7b,0x890dfdc5,
	0xdb27dfbf,0x8da71b3f,0xcd63c39b,0xe2d987cd,0xf7cdd699,0x4bab5e73,0x5d0595fb,0x40f5e2d1,
	0xa7c520a9,0x889bdb51,0xbc73a297,0x935f97cb,0x4523d0b1,0xa9298cb3,0x80199d39,0x6bc5eabd,
	0x18e1ccbb,0xb8371b01,0x53c5936d,0x6e7987af,0x53e5e31b,0x27cb9929,0xc3b1918d,0x63734fb3,
	0xa7fbff6d,0x3211619d,0xa57d67b7,0xe75945e3,0x80d97f95,0xda61135b,0x212f8ed1,0xbc719c5f,
	0xdd19a8bb,0x8e39aeeb,0x5a392d8d,0xbbafe14f,0xc73f3c55,0x6641d357,0xb8733d61,0x65ad4be9,
	0x6eb92d1f,0x07431b35,0xd11dcf8b,0x13af2961,0xe0db7419,0x233999a5,0xefe17215,0xc89d69fb,
	0x61df0591,0x9a417747,0x3fcdb4cb,0xa2094dff,0x65ede619,0x3b9faf4f,0x9459ce47,0xe92f32c1,
	0x2a0d5f8b,0x26c1ec6b,0xd26760e7,0xc3f17f97,0xed37560d,0xcc4185df,0xf93f5fd1,0x85d9b2e3,
	0xc945bd09,0x8edb9c6b,0xcb9113f7,0xa11b8f0f,0x2bfb2c33,0x0473575f,0x1875410f,0x378d678b,
	0xf0079485,0xd71b418f,0xa46b6a97,0x4bb38dd3,0x15fd1543,0x4609c659,0xb25b38d9,0x91b9de65,
	0x1d59f0f7,0x4697cea3,0x2c95fde1,0xe0716dcd,0xfd7da275,0x45517dd9,0x6dd35a89,0x4253559b,
	0xbeb911d9,0x86e10eef,0xaa35036f,0xa683a167,0xb33fe987,0x291fd165,0xf843a5fb,0x31cb5bd3,
	0x502b0b27,0xc4094641,0xf9ebed5b,0x2f9dbb8b,0xa68324b1,0xaac55d0b,0x2589a785,0xa313703d,
	0x7c31655b,0xcca3d0dd,0xaed90a3d,0x77ef0fa1,0x050b52ab,0x3615a553,0x10071805,0x539da27d,
	0x3bcdbd6d,0x31bfc393,0x32a12531,0x062d5197,0xdb19d6b3,0x0961b747,0x38a17cd5,0x9b5b32c1,
	0xf67f64d9,0x66ef8ba9,0xe56525d1,0x0b8935d3,0x33711881,0x557bc873,0xa6b9c7cb,0x8cc131b1,
	0xa24d0197,0xe2478ee9,0x3dc9b035,0x83b51143,0x3753244f,0x5db5d6dd,0x082ff745,0x14bf2079,
	0xe3b52e23,0x3c57cba1,0xe8ebc4f9,0x54e1794d,0x4e834ad5,0x97e14911,0xd165b61b,0x1ac790c1,
	0x2dbb1975,0x50337897,0xea6f6139,0x6fc1e3dd,0x3f41c151,0xcc518e1b,0x5d41fba7,0xa0cbc4b3,
	0xe1e12707,0x5b6ba515,0xbc791e89,0xef87475d,0x4e4f417b,0x35d7bd83,0x0d21abc5,0xe33f4efb,
	0x70278ed7,0x1e13d8e7,0x6fa7d309,0x39e3bab7,0x5eefa98d,0xa1c53753,0x68e736cd,0x7911b2c3,
	0x7713fd59,0xfabbb457,0xcb1f314f,0x1f0b1555,0x12e59c41,0x8feb4415,0x3ef73999,0x73b703b1,
	0xe3a3338b,0x1675902f,0x6c816877,0xf9ab8f21,0xea7120cf,0x529fb4d3,0xc4331d83,0x7f2185f3,
	0x115ba6e7,0x78d71db7,0xe7edc41b,0xcefb6083,0x645742f5,0x2eb18317,0xb3fbb867,0x01c34e33,
	0xea3d2165,0x2bed06bb,0xe8094c55,0x6ea96269,0x1dd7b2eb,0x7b7170ed,0x7033ec9d,0x3c8be197,
	0x06cb6181,0x5c4d8d83,0x4df565bd,0x92e9ae39,0xf2b3656b,0xc2b5a8dd,0x213b48ff,0x6aefd5cf,
	0xce07ba35,0x79072cdb,0x51537171,0x006d3ddf,0x1d2d33af,0xe0cb5def,0xd5f7a8e9,0xe2df70ff,
	0x9571b2f7,0x53af380d,0xa0456d07,0xa6658bc7,0x56097b71,0x24896bb1,0xa3c9d431,0x34cd49d5,
	0xc10fa7c7,0x40557ae1,0x7f6f9299,0xbe8532d7,0xf487beeb,0x6f3df62b,0xc6911f35,0x4babe77b,
	0xe35f691b,0x358dd9a3,0xe9eff8c5,0xecff8e7b,0x0e6944d7,0x54bd09e7,0xc0b10acf,0x8ceb6197,
	0xdd65dbed,0xec67f11d,0xb16932a1,0x60835a9b,0x97f3b86f,0x3b573bf1,0x7b0fe455,0xf8810059,
	0xfea399b9,0x0077b697,0x9e01efc9,0xf24753a5,0x83e5c96d,0x7bdf49cf,0x650765a5,0x48dddc65,
	0x25199077,0x0fcd17dd,0x8e559c57,0x45f9d681,0xe383cc0b,0x81a7b98f,0x94815517,0x12f17ee9,
	0xdd4da2a3,0xdafd9b39,0x978b00e3,0xe9cb8097,0x068b5903,0xea8379b9,0xe5db2585,0xe62f818d,
	0x823d4735,0x6517ff73,0x2541e28b,0x7671cfd5,0x9b45ed8f,0xa6c18157,0x1bf7964b,0x6c8b2e7d,
	0x5d6d29a9,0x13addbd7,0x199da2e5,0xaf1dc2a1,0xce6d8b69,0x19356ff3,0x00395341,0x8a752061,
	0xc6dfc9f9,0xced3402d,0xed3fe00d,0xa18177e7,0x6b4958cb,0x37312d97,0x828394c1,0x7edfe265,
	0x45151c9d,0x211b54c1,0xcf49149b,0xc5cdcf11,0xfb99406f,0xa8878acd,0xd935bfa5,0x033b9031,
	0xad0f2a8f,0x5793fa5d,0xc55d37ad,0x1eb70809,0xe79f918f,0xe789e0a1,0xa1330549,0x6b7b75ef,
	0x4253b14b,0xa1d36a4b,0xcb9d5cd9,0x596b6339,0x961f9fe5,0x6109b099,0xfddf0385,0xc613b049,
	0xd6dfc2cb,0x31e7d653,0xf4ab543b,0xeda1c18b,0x8c5963ad,0x945744c3,0xb91964b3,0xfbf1cc6d,
	0xeb376587,0x5c6708bf,0x89a94a6b,0x3d874467,0x8e0f199d,0x33494fa7,0x63437fad,0xf08b67ff,
	0xce5d3479,0xb85f045d,0x2a396887,0xb5d1edbb,0xbd85e2f1,0x422f8c4f,0x7343f7cf,0xa1d1d12d,
	0xbdd3ff1d,0x3f65a473,0xec7f7425,0xedb13fed,0xbb7b6563,0x37db5e45,0x66755cf1,0x4837a69f,
	0x0599696d,0x6d8b3ccb,0x7d196f61,0xc6d7ddeb,0xc7336b2d,0x1d9d7193,0xe0c1cb6d,0x76ab7781,
	0x20358be1,0x616139b3,0x3f2b38d5,0x8d772b1b,0xde71830b,0xaf4b5ac5,0xcc858c1f,0x3aa3637b,
	0xd6a59375,0xfbf9bfef,0x6c592b99,0x1843eb69,0xdd75a033,0x7b3336e1,0x7aa3b45d,0x3c0fbab7,
	0x606d61a1,0x00e74ccf,0x34c3bf4b,0xe86be33f,0x9f01ba61,0x022b4b75,0xc27fc607,0xdd619de1,
	0x838f2c5f,0x363d5619,0xdf092801,0x49a37787,0x1c596dcf,0xd781a689,0x21fb4f71,0x5b8b9e21,
	0xb48d1e2b,0x8489ea19,0xe851f655,0x721d4da9,0x8d3d9b39,0xc10bbea7,0xdd778b77,0xee015d23,
	0x3667f5ff,0x16e34f97,0x243bb765,0xa28beb93,0x87ef07d5,0xd71712d9,0x1fd70175,0xe6b32d0f,
	0x3aa1a753,0x7ad7a5df,0xdce994c7,0x461d57ad,0x2133fd5f,0xa479caa9,0x1a7b2543,0xd213b08f,
	0x013ffa23,0xc07d84bb,0xf2fdf499,0x1287b8df,0x0c49ea11,0x46855623,0x2547f73d,0x97137acf,
	0xf8bf2ae7,0x9a619c75,0xfd99196f,0x27f9f695,0xbaf300a7,0x8d090dcd,0xde9da439,0x9725af77,
	0xde258a9b,0x7d9955d5,0x6a5fc269,0x312958bb,0x7d75d857,0x1a59d2b5,0x4b5d2595,0xce3da2b1,
	0xdcf11eb7,0xc1b77225,0x9d73cb1d,0x834527b7,0xa28f0cdf,0x8347ae63,0xf6ebe129,0xf2cb7929,
	0xaf294137,0xc0cbab33,0x1173cba9,0x3e014c75,0x9783de75,0x6f2572e1,0x13274951,0x95c1c809,
	0xbd4b4093,0xf7675343,0x7785b8a3,0x6b8df05f,0x0815d1d5,0xb7c55ab9,0x98757ce3,0x429134f7,
	0x3e5bffc7,0x249ff525,0xd7478325,0x209d1d5d,0xfe85503b,0x8979a8f5,0x65b5e73d,0x9f2d1621,
	0x57db964b,0x6a03f41f,0xaedfb8cd,0x9c635ddd,0x0395475d,0x83134921,0x604be039,0x8c091231,
	0x3dcdf01b,0x6ba72bfd,0x12eb23b1,0x68915cc7,0x3e87c979,0xd5e56f43,0x94194c2d,0x4415c04f,
	0x52b36daf,0x701b9109,0xce916a6d,0x79578583,0x951fad45,0x65c137e9,0x537f3bf7,0x7cc34825,
	0x478d8403,0x8073d00b,0x8371b01b,0x4d69a3fd,0xcb9f2dff,0xe8f9481b,0x57618cef,0x860501df,
	0x3bdf5c91,0x883fee4f,0xc9ad3453,0x0df984a1,0xa4c58b5d,0x085f6d63,0xdf1f88ef,0x6a4d1625,
	0xddab7551,0x7593e99d,0x4fe7f331,0xaeb79455,0x01d7a99d,0x7f433dcb,0xd09d8653,0x0e8f1e21,
	0x897340bd,0x58ff5841,0xfb414551,0x0dd78085,0x0295b175,0x3b7bb7dd,0xd83b87f3,0x523bc37f,
	0x6a39c5d1,0x85970905,0x075d7fc7,0x140bd71b,0x2543b023,0x7d57e2a5,0x88dddd29,0x2f436067,
	0x997f4005,0xb0eba331,0x265d9433,0xd483a67f,0x66a1375d,0xf7a76da9,0x7be5c1cf,0xda199f85,
	0x3f45bf55,0x130d4691,0xa0e5b0ab,0xacf31d9f,0x61f1fd61,0xefc150f7,0x7133fe41,0xe1af1c01,
	0xb211c83b,0x86912b6f,0x7613dfcb,0x658d2be3,0x70f77ce5,0x5d736d17,0x6f2b8755,0x4f790185,
	0x96e1f3af,0xa8874293,0x7b8ba8ad,0x51032133,0xcbf39527,0x0b132b13,0xe2ad1e6b,0xc767ac3d,
	0x01398f2b,0xf883d549,0x7d71aeeb,0x6c854dfb,0xa9a729df,0xb56f1c75,0xbf1df157,0xa7eb48d1,
	0x93193cab,0xf8952559,0x5e65529d,0x7fc7a327,0x5f55c345,0x2bdb9b47,0x9e5d3a77,0x29f7746d,
	0x9d0792a9,0x4d510d11,0x37875061,0x3cfb521d,0x80c12e17,0x702b6a13,0xe0cde0a3,0x80fddcb9,
	0x3e01bc1d,0xddc79f35,0x787d614b,0x60d16cc9,0x002b1b8d,0xd6ad53e5,0xcd511735,0xfaf1dfdf,
	0x838b1881,0xf38bc715,0x0767dafb,0xd27d8595,0x4e57c15f,0x2635cc43,0xb149fe07,0x20432c8b,
	0x89a9dbd1,0x5aade877,0x60e74f89,0xc3b14f69,0x7a8579cb,0xb8158f3b,0x00994175,0xd3e561e5,
	0x9ad7ae87,0x81bf7fa7,0xb81f2d8d,0xd09f3db3,0x52776389,0x981f4155,0x75a1ba57,0x7349af97,
	0x501d4d9b,0x99d5c16d,0x16b16023,0x1ff7245b,0x826f01d1,0xa4a50f9b,0x31450e07,0xf66375cd,
	0xb0fb2a89,0xb67f3b15,0x7cbfeee5,0x82edd7c9,0xb531dc61,0xae794f97,0xdae74e61,0x0fa1e52f,
	0x53710b49,0xedd17269,0x00eb9deb,0x9533cceb,0xb3fd1f71,0x98ed1f55,0xc06799bd,0x4bf99ee9,
	0x7c03aa55,0x785d85b1,0xf0598dd3,0xdcf9b927,0x86973bbb,0x79d3055b,0xf629baf5,0x32db54a3,
	0x3db356ab,0xd131cbb9,0xeea7dbb3,0xeaf33269,0x933f8677,0xb97d90b7,0x770dc963,0x66396889,
	0x9a0393bf,0xd5e573cb,0x15f94125,0x7a534f1b,0xbeb7d963,0x32bdf8f1,0x4477c8e3,0xc2878d43,
	0xa0f5b98f,0xe68525af,0x16f3b447,0x90c94627,0x8c4132b7,0x52e5be13,0x864749cb,0x7eb565fb,
	0x91099495,0x05a7a1b1,0x58b507af,0x9e890ef7,0x3da1552d,0x39c548a7,0xaae108fb,0x4c33265b,
	0xf74505c9,0xf85d6099,0x18df8a7b,0x9e450173,0xf31767ff,0xd9b389b7,0x87278fc7,0x76f9328f,
	0xcf27a2a7,0x663733b3,0x8b97a83f,0x352f7609,0xcb6796e7,0x177f9acd,0x7679d40d,0x0573bf41,
	0xa2b35527,0xf949e4c9,0xfb7d891b,0xd2f765a1,0x03cfb21f,0xea795df5,0x7abbd825,0xd8957199,
	0xaa6bfbc5,0x7e21d625,0xe9b3b1a7,0xd1d109a3,0x1817ce5f,0x7c771db5,0x5c4d4ae9,0xcbd3ff41,
	0xed4f0979,0x03d7a28f,0x2ddba2fb,0x966f7bfb,0xe27be4e5,0x49c72d1b,0xca1327b3,0xd51dce63,
	0x60e525bf,0xfbf9bd51,0x16177ab3,0xb0015713,0xbbc17369,0x413f87af,0x796f565f,0x24e595ab,
	0x092bcc8f,0x5a991239,0x870992e7,0xf83b55d5,0x9b291c25,0xe42d717b,0x46414b45,0x461dfc43,
	0x18a5ee65,0xb64ba58d,0x1bd32235,0xb34ff3ab,0x367545d3,0x66671709,0x52eba73f,0x3e3939d3,
	0x1055903b,0x681f3417,0x4619dbb3,0xafed0c7f,0x21e9bbad,0xce3b2d65,0x2853d7a9,0xad27b685,
	0xdfbd6b89,0xaba9d325,0x6df98efd,0x67497cbb,0xf0454d6d,0x147d9215,0xd5d5b659,0xed5dab03,
	0x04df8e49,0xbef9907d,0x1219c82d,0x1d15c147,0x52cd6f4d,0x447feb27,0x115929ad,0x33cbc079,
	0xac3bfaf7,0x02a11269,0xe7976fdd,0xff839791,0x393fda07,0x9c154723,0x573dc47f,0xafe5b091,
	0xd0d5488b,0x19b537b5,0xfa196b25,0x47439d7f,0xf1e12ad5,0xab8dbd11,0x0a636625,0xab99e571,

// 5 * 16384

	0x5c314281,0x09c7b7ab,0xcbbf3ba1,0x5789f17f,0x49758371,0x75bb0c81,0x9431da7d,0xab5d19c7,
	0x464b88d3,0x5ae7c215,0x75299f6b,0xde07d277,0xab3b2a15,0x8ff13d77,0x848379df,0x8e21f8bd,
	0xb5ab2ff9,0x37a79f3b,0xc57d311b,0xf2ed3fd3,0x40f5297d,0x4201407f,0xb1c1c927,0xad57bdfb,
	0x1f5160ed,0x8d1b4fe9,0x625b07cf,0x38ef997d,0x12e5f0df,0xa63d8ea3,0x58c719ab,0xfcf1d5ab,
	0x66bdf92b,0x2ad32d67,0xe7e5571d,0xfd3f3fdf,0x27cff3f7,0xc977c96f,0x3cfd2949,0x2b637c79,
	0xfdf32aad,0xe2e38981,0x08bd0f21,0x578f33e1,0xa4f34aff,0xcaff5aeb,0xc841c259,0xc19d5f8d,
	0x05771beb,0xa9db4e81,0xae077c75,0x4a0fb6f1,0xee1352b1,0xfcab15a1,0x2af55bb7,0x43113c91,
	0x6c4587df,0xb6cf9f2f,0x1761e831,0xe173eaf7,0xc5734c47,0x02cbd49b,0x7bffb8bb,0x4db181b1,
	0x0fe55e05,0xa34f76d7,0xfaef37f1,0x54eb725b,0x6bd3fd7b,0xf4311b63,0xd8bb893f,0xb9efed95,
	0xdc576257,0x8b6d4943,0xa5558dcf,0x262d1009,0xc0755089,0x7a2db603,0x8511099d,0xbabf2f69,
	0xec1bcd4d,0x2dbda2bb,0x19b1e865,0x4167476b,0x611df427,0xf0955907,0x0b5fa2af,0xfd8f86d5,
	0xa835ebe1,0x0b51c80b,0x31a9c2cb,0x1d4bfc6d,0xca0bfb91,0x85b74175,0x5c8789d1,0xca556403,
	0xe827bf8f,0x87b9567b,0xbd5bb49f,0xdb0f1375,0x76017e81,0x5a69d4db,0xefed60db,0x2381079f,
	0x11f39e51,0x0907e3d9,0xa36d11f7,0x6661116d,0xfe433933,0xa1f94141,0xe373d627,0xe60722d1,
	0x3a1bd29f,0x17cf9e69,0x00ff8b6f,0x9575bbc3,0x3a912c5d,0xc23d1d31,0x1b794491,0xe9557745,
	0x439f3b75,0x7f21ecfb,0x49b3ce1f,0x48fbb85f,0x612d3d3b,0x738307b5,0x62e35371,0x1f617723,
	0x0005ec4b,0x6c910ed5,0x67ab23a3,0x8c292da9,0x26dbd587,0xe09f4857,0x8b1196a1,0xb49be515,
	0x4f4bcd1d,0x902fbbc3,0xdb891217,0xb4ad628f,0xdedb837d,0xc6e56f23,0x8be72e7b,0x2ff57447,
	0x3ff53a63,0x3c8fc40d,0xdc6ffc0f,0x82b95e77,0x9aef99d3,0x9623f49f,0xa3c767db,0x92e36861,
	0x2f05a519,0x86c1b07f,0x77ffc0ab,0x4103894d,0x4b5bcfc5,0x90add9d9,0x77915c19,0x7953358f,
	0xe7fd32b7,0x66576263,0xb25b5b81,0xe4b94b7b,0xdedfe10f,0xeb554859,0x32a9910f,0x39bb2077,
	0xc4dd5d39,0xd565b381,0xa62784af,0x2d8dadeb,0x62bd2de7,0xed6d3229,0xa6ef9917,0x050bde49,
	0xce299317,0xf07d1625,0xa48150cb,0xc5b5fa07,0x22b95b0b,0x10c7f1d3,0x6cc7b30d,0x06b534a9,
	0xdae5d74d,0x16af3519,0x550fd0ef,0x61df59b9,0xc911f1b1,0x21b5ea61,0x03116a49,0x84ab99c7,
	0xb08f6153,0x098d93a5,0xd5efb2b9,0xe13f776b,0x7e8dff95,0x5f09275f,0xef3136a5,0xff61d447,
	0x23293d25,0x0d2b2d95,0xdbc7e03f,0x6d851e05,0x0a69b6f3,0x9a15fcd3,0xdd091c7d,0x51c79b57,
	0x3539eb3b,0x08191731,0xd1b7201d,0x9ae7d8f5,0xf26b0e81,0x56aba74b,0xbef94ca7,0xd14f369f,
	0x37bd0091,0xa36b1d45,0xf961b56d,0x88139421,0x9ad5617d,0xeb1debcf,0xede5c481,0x6deb1e4b,
	0xea3bc69f,0x6ab1651b,0x8ae7ffc7,0xfe3b3bf5,0x66650f9d,0xa03db7e9,0x492dede5,0xd20d9b03,
	0x9ab1db61,0xebfd0c7b,0xd4e91b49,0x91155d5b,0xd6611d1f,0xd15bc1a3,0x56b53f29,0x82a965f1,
	0x45a3d151,0xd7e5c9b1,0x5c8f8089,0xbecfc5bd,0xaa89d2b9,0x0c4d2787,0x62dddb2b,0xff2f48c1,
	0xb613cf67,0x21758b87,0xfd75a4a1,0x101d2305,0x01215da9,0x3163109f,0xa0893143,0xe191bd9b,
	0xa581311d,0x1e431947,0x09bf992f,0x382fa39d,0x76e96fa7,0x936d4c77,0x491b9d4d,0xfe418f2b,
	0xdbf3266f,0xa65fb2b9,0x6a0fac49,0x34b9966f,0x4723deeb,0x17c1f317,0xbc73079f,0x84337899,
	0x4fe753d5,0x345db027,0xbd89088b,0x6ded0ae3,0x6b934633,0x562d0509,0xa0f58517,0x1cd5c58f,
	0x4661724b,0x054f225d,0x79cb550f,0xd67d70e7,0xbc77a4b5,0xb9070b55,0x0381f70d,0x0c1df239,
	0x72e3ef4b,0x38c372a5,0x0afb556f,0x0b9938e1,0x1097fe2f,0x9d1db78b,0x777bab5d,0x507b4b3f,
	0x176f8ccd,0xf0d102c9,0xf3b789c3,0x74f573bd,0x5d2ffad9,0x71c383af,0x36c5fc5d,0xc2e18dcd,
	0x2485014b,0x7205cd11,0xed25cea9,0x64c372e5,0xd605876b,0xd8cd524d,0x41bff0eb,0x36c3878b,
	0x592b97c1,0x43750449,0x06e5fd37,0x37b36843,0x0d597523,0xc6890e71,0x7f4ddc5f,0x9a0fb6a3,
	0x62dfcfa9,0x4eb3b3b9,0xc7178b07,0x74f90641,0x13ef19b9,0xa1cb4ba1,0xdccffe95,0x153be9c1,
	0xfda5fcfb,0xffcf5f2d,0x4a612a37,0xee471fc9,0x9907ef65,0x63e5e5eb,0x6e2923e5,0x2b37e00d,
	0x13ffe833,0x655da2ef,0x63e3695d,0xdfcf4845,0x0a6334e5,0xb8a9a1d7,0x8dbb4529,0xd975e931,
	0xdeef6e49,0x506dd3c9,0xbd415395,0x1041739d,0xb4458d71,0x1e69cc6f,0xfc6927bb,0xb7e98559,
	0x05f520b7,0x74919f03,0xf6991079,0xf0d1963f,0xe171a0c1,0x05f7db3d,0x0195fd75,0x1903052f,
	0xbf15e57b,0x87ddaa67,0xc68f8421,0xbd2f4511,0xfb27bb13,0xf2a50c4d,0x8b1f04b3,0x29b329d9,
	0xeed39709,0x62e13443,0x1a45ef2b,0x9b915581,0xa92b6d1f,0x9a450625,0x4d6b284d,0x116fc505,
	0x482da45f,0x20b1b35d,0x355f8ead,0xbca57d75,0xf1bd2c1f,0x052977d3,0xe3599f9f,0x122958dd,
	0x6ca7b0f7,0x3edd76ff,0xd1fb3c43,0x7b9df359,0x599ff1cd,0xae23b8df,0xee4d8e7f,0xa84fb809,
	0x0c4134c9,0xbd7946f5,0x40bf0e05,0x7e2f0e17,0x0413dc61,0xa2856953,0x3627a54b,0xaad7a5b3,
	0x05811c51,0x3f150389,0x88c9f68f,0xd489e517,0xd2ddce99,0xa21f11b9,0xc94bc0db,0x6b317587,
	0x85656887,0x28c54585,0x87bf64fd,0x195ff047,0x863d0fad,0x3f47c31b,0x1c9b8a8b,0xd54fabad,
	0x2771cee7,0xc219fe31,0x11c1e4e5,0x91e1a80f,0xdcf7eb57,0xfecdb703,0x2b771831,0x8fa39ccf,
	0x15a75969,0x55231759,0x1171be61,0x4dc52557,0xb44951d1,0x7801ef7d,0x97c38c2b,0x1b210e19,
	0x28890689,0x4e771345,0xa7f1960f,0x4739c18d,0x27f977d5,0x74b9d70f,0xc9dfb551,0xf337d533,
	0x0719693f,0x5d25acc1,0x4ce30d05,0x82efb697,0xb249769d,0x1143e0c7,0x10afaeff,0xaddb7849,
	0x46d74907,0x92c17717,0xee6960df,0x301dbee1,0x4bf9ebe3,0xdc75282d,0xc195810b,0x1b7dce03,
	0x8bc941d9,0x835d7e0f,0x11250bb7,0xc871b555,0x8c4b99e1,0xf79d114b,0x5871bfd3,0x67119d8b,
	0xa86d6431,0x6587e5f5,0xf0396425,0x301f355d,0xc9010751,0x3691e8ab,0x97a72c31,0x36053e8d,
	0xbdc7d509,0x32558b93,0x9d473d45,0xd5d73ae3,0x365f1f6d,0x3f9f8359,0xa817537b,0xc84f3931,
	0x5b576dd7,0xc559a431,0x207386b1,0xd2cdc251,0x0725d1ef,0xab9bdedb,0x39252f8f,0x185fe621,
	0x9f235c9b,0xfca35d9b,0x985bec83,0x0ab3688f,0x8c95b311,0x25d7c13f,0xa0b1c6c5,0xfb270e89,
	0x55abc3cb,0xd8c77e1b,0x5a257755,0x4bbb0b0b,0x56739b8d,0x8c27590d,0xfb1fcbf7,0x40198c13,
	0x19ef5a61,0x9cd50479,0x11712c3f,0x6e9567ab,0x52ff489d,0x0ed9dd4d,0x4b513e81,0xd129e8e5,
	0x75730bd9,0xee5fc801,0xe05facdd,0x7675bcdb,0xeefdfbfb,0x50c12d8d,0x9aa70a3b,0xd2c5ffaf,
	0x0039982b,0xf579187b,0x7f95d749,0xb10d6987,0x35ab1be1,0x873171d7,0x1903a77f,0xc3e39b95,
	0x80c333d3,0x7cb55e33,0x5e33661d,0xd68d8d15,0xf0cfd309,0x99fbbab1,0x3ccbbb27,0x9df31845,
	0x0c1127cb,0x1121b9f3,0xc1db9071,0x29a9a771,0xc8abb0ad,0x4371a127,0xe2ddb68f,0xf4e901e7,
	0x25a9718b,0x2255a505,0xe6afa9e1,0x97933903,0x63ff4887,0x3065e6c5,0x6e9b778f,0x1733b527,
	0xdf89630d,0x225d9131,0x1f51c287,0xd7fb62b9,0x880dd2d1,0x20271593,0xe9e9e881,0x2dc7ff2d,
	0xfa3542cd,0xa5d188c1,0xf4e346fd,0x8d1785fb,0x3897cc45,0x048d201b,0x2529a03f,0x5c15bda3,
	0x04afebc5,0x83bdce83,0x4707a05b,0x6395e4b1,0xd7e1961f,0x21e70167,0xd73b8225,0xe00f7eb5,
	0x7c796d6d,0xf5b77dbd,0x6be1d43d,0x32a74149,0x46ab1615,0x2f075d01,0xbd835e0b,0x3227210b,
	0xed93abc1,0xb7d12a39,0x500f24bd,0x1c017ea9,0x04375663,0x753d1ef3,0xbbe1904b,0x255173d1,
	0x1283ff39,0x289b8043,0x96b7b075,0xabd5403d,0x4e4925c3,0xf05f1bc9,0xfcb9a1c1,0x06fdd6af,
	0xf447d4cf,0x6927e4a5,0xb977127f,0xf8d589ef,0x4121b76f,0x6ebbb089,0x10ebe7c5,0xbf1dd9cf,
	0x0a634dff,0x7d0914a9,0x28750273,0xc4336029,0xf7814323,0xb12762c1,0x0fdb2431,0xf023dddd,
	0x5ad9e0c3,0x6a53c617,0x6a51f46d,0x999f67d5,0xaaada515,0x8af18079,0xb76b255f,0x1701b401,
	0x9a29f793,0x5993473b,0x3c2db907,0xef4d865d,0xd265fe01,0x01efc03b,0x8bfb662b,0xab2b3de7,
	0x4b59916b,0xb5e11edd,0xb1a91d59,0x45ed81ab,0x44eb5321,0x6e6fe111,0xf86fadeb,0x3e8f0db7,
	0xdfe7e1c3,0x4cc9ac49,0x54eb8b01,0x48b3a027,0x57032e31,0x9b454a85,0x6e27b07d,0x9da3061b,
	0xd7d7f097,0x6e63c749,0x4693a815,0xed5148bd,0xfbed3d67,0xe5c5aca3,0x8507ae3b,0xef57fa3f,
	0xe1ab3a5f,0x0d3b6025,0x5dc5f731,0x93f9a2d9,0xe56bf37f,0x5dbd9ff1,0x1b7113fb,0xd51f4dcb,
	0xfa655017,0xde671fa9,0x481f776d,0x275b3661,0xa3c127b5,0xe581457d,0x76451b1b,0x8ae994eb,
	0x8d877737,0x7979071f,0xa9c54467,0x3cab8bc1,0xc5afb5bf,0x51e3e6cf,0x60e76973,0x072b3447,
	0x951149bb,0x7881104f,0x3d593635,0x339bcbe3,0xf8771ddb,0x8a3595f1,0x4d37b15f,0x1ad50109,
	0xb989561b,0x9811cd85,0xf3ff8173,0x565d6031,0x27db24bf,0xa849cd6d,0x739951b7,0x9159e0dd,
	0x71edbf53,0xd73d098b,0x15555739,0xf9a19295,0x9e1f73a7,0x1871104d,0xf2edf5d5,0x50ab69eb,
	0x23c1dcdb,0x979567a9,0x5f818525,0x9c9b2d77,0x2405384f,0xb97f8a1d,0xf0973593,0x793982dd,
	0x4307daaf,0xbd2d03ab,0x2723154d,0x08fb1bc5,0x20cbc4ed,0xfcc5aee3,0xb879354b,0x85f902df,
	0x723f5947,0xce9711db,0x775bee4d,0x72f508e5,0xba37303f,0x0615db2d,0xdcf345d9,0x6c5b5199,
	0xa26f0d9f,0x14e17f01,0x31cf733f,0x993b00c5,0xf489f57b,0xcbc1f403,0x56e98495,0xbc510737,
	0x3315612f,0xbba19067,0x2e9f23bb,0xe4ff0fcb,0xd285945f,0x369b06ef,0xa5bb7b59,0xc04f8c61,
	0x123511f3,0xf0e983db,0x5c6d3bdf,0x89f1e2e3,0x756b3121,0x41f3e9fb,0xef4dc081,0x9d43ba41,
	0xdc51d265,0x05492fa3,0xe05b5441,0xa6476777,0x3cfd347f,0x1b9fdbb1,0x200196e5,0x72a37a83,
	0xfc6be97b,0x8bd5a28b,0x360b01fb,0x62ad6b71,0xe77febaf,0x43ef231b,0x0ab78ddf,0x7a5f6751,
	0xcc05d2b5,0x7a1dc3db,0x4fa176ab,0x125b3d3b,0xb1b1286f,0xadb3afc5,0x88d12149,0x28e96b51,
	0xb31fde09,0x4833f35f,0xb5bb2067,0x52ff4bbd,0x76d5e0f5,0xde41b9b7,0x9a33597f,0x4d3561b1,
	0x483dcff1,0x10aba961,0xa77d49cd,0x2ccdc665,0xd0adcfff,0x0d676179,0x853f6b59,0x30b1b61b,
	0x70618169,0xb09516a9,0x3a8bb9f1,0x32753d19,0x377d14c5,0x457b5019,0xf6d75831,0xb75304b5,
	0x7f0d7feb,0xe785c483,0x7b035473,0xa12d4047,0x2207d2ff,0x834b5721,0x225b8de1,0x7f8bba2d,
	0x5643ad6f,0x778b34b7,0x8b8bb969,0x80a300d5,0x2589d2eb,0xd62b1097,0xe1ad86c5,0x024db3ad,
	0x8685e06f,0x453b8191,0xc543e571,0xc30bf02f,0x15c92141,0x7fef7f07,0xd53169b5,0xb307dedd,
	0x6ed383e7,0x77a5fddb,0xd7cbd1a1,0x6515603f,0x2507af39,0x14e5ad7d,0x83c9aa0b,0x1fafd9e7,
	0x5cb13751,0x985dd4df,0xe9491393,0x8df5236f,0x0407f291,0x9be14f7f,0x7ad5a7a1,0x10b39377,
	0xac216ea5,0xb373aa65,0xb65d7d65,0xaf5d2ca9,0x02078581,0xae35611b,0x6e394ed3,0xa909eab5,
	0xe7a5125f,0x77793ab9,0xb229bdad,0xa57d2f57,0x2ccfc6c1,0x97b3c6d9,0x5855b879,0x86234f4d,
	0xe83f1f77,0x5583faa3,0x264fff87,0xd70b3f61,0x709b798f,0x76adedc3,0x9a0dc9ed,0xdfef6167,
	0xf56f4767,0xa123b76f,0x52f18a8d,0x55357135,0xb83165a3,0x5bf56b63,0x1ac3d50b,0xa8e391ad,
	0xe53b902b,0xb06736e7,0x8eb362d7,0xfbad79b9,0x0cd1f737,0x6add9dc5,0x6857382b,0xadefc14b,
	0x3c21f43d,0xfbe7d753,0x66b3e903,0x90a74e59,0xb63fdf03,0xf9374b6f,0xd72dfe27,0xb685e1e9,
	0x4d250295,0x3eaf2f7f,0xbe957a27,0xe4d7c4ff,0x5ab9b245,0xaf55436f,0xa2257e59,0xa49795b1,
	0x59c97eaf,0x9657aeb5,0xf07d0fdf,0xf3693415,0x1f078ab5,0xa809fd4d,0x0aa3fc9d,0x9497cf4f,
	0xb20f0083,0xa2eb3cbd,0xed09e043,0x02151285,0xc665a68d,0x90a53913,0x7889494b,0xfd7971eb,
	0xd477948d,0xa701d9e3,0x5b5ffdf1,0xc10997b9,0xd2990887,0xc8fb9f4b,0x9a37613d,0xd0adf131,
	0x8e055bc5,0xa7ab3eef,0xb91ff7ff,0x6af95b9b,0xa3e317db,0x835b60ff,0x848f0dcd,0x9a25f149,
	0x1a3d2ba7,0x8c797d2d,0x7a697a09,0xe515f693,0x99054047,0xe49bd7b9,0xd2f584d7,0xa053e6dd,
	0x431d2e2b,0x3f7f9e67,0x29e3ec27,0xdf11a18f,0x2f439203,0x24092585,0xc74b08b3,0x042bb719,
	0x812781cd,0xcd4b44e7,0x88ad12f7,0xf31fd5f5,0x225d61c9,0xab7bd4e9,0x69f1883b,0xe11d57a5,
	0x1b61d985,0x84f54b75,0xae69af8f,0xc5f1edb3,0x8c97e8d3,0x373f78f3,0xa9cb3ec9,0x6d196ead,
	0x474b1ccf,0x180b655b,0x29391f8b,0x26b7c32f,0x06b1e4db,0xf62b4d2b,0x7c3b5439,0x1895f2d9,
	0x48e507a3,0xba9fbe67,0x1dbffd05,0x2f275155,0xc7ed381b,0xa98dd59b,0xfd217ce3,0xae83cb53,
	0x92b3ca7d,0x43459adf,0x671fbe95,0x636d538f,0xc60d894d,0xc53b7ecd,0x8ee199a1,0x74516fc7,
	0xe5b7aa55,0x4b0df78d,0xb6f75757,0xd241e5c7,0xd555e3ab,0x8f833dcd,0xfa5b57cf,0x49f5885d,
	0x7173a0a7,0x4d8b29bf,0xb56bd6e5,0x34d12465,0xc88556ef,0x41393021,0x8ef3d145,0xc9df8dc1,
	0xf3e7fb6d,0xc8cf7f3b,0x211f0959,0x0ed1cc57,0x90df9753,0x25af3bd7,0x42892c5d,0x6901691b,
	0xd999fd1d,0x5d6bde4b,0xef33174d,0xce71db03,0x5e279d91,0xbab9af75,0xd1813bf1,0x96cd1415,
	0x5d877cb7,0xee7365bb,0x6b4725d9,0xec672e57,0xbe9d46e3,0xd0a5e209,0xdebd1f5d,0xdd3738db,
	0xa93585b1,0xc1790cd5,0x5781f699,0x0be124b9,0xbf05f503,0xaa47d31b,0x139de277,0x00afd215,
	0xf4a5f805,0x9e8d4363,0x0c8187a7,0x1a913d15,0x0a9d2e2b,0x1cf1cab7,0x40051d9d,0x2025caed,
	0xa659282f,0xf04191ad,0x9969b39d,0x70adb6d5,0x0b2b3d15,0xb075f963,0x7a5595a9,0xd5119f0f,
	0x73537f29,0xe3a9387f,0xe3dbd193,0xf0e331e3,0x08f1d0fb,0xbf25182b,0x3f71dbf3,0x535ffaa3,
	0x7f131a6b,0x8855d121,0xc7f95525,0x28674ea9,0x4aad9d97,0x95d3089b,0x92b9ee53,0x89835a55,
	0x7b9d6bef,0xf059ed5f,0x38656e6d,0x6ee94e11,0x35a5fb25,0x93cf74bb,0x1e11d729,0x4071ab4d,
	0xc973da31,0x5045b783,0x5e41aa05,0x069db183,0x6d9b865b,0x4aef6f15,0x51db4d49,0x3b99eb37,
	0x9797602b,0x1f2d9255,0xb92f9105,0x3c35daed,0xf4cfc075,0x9f8312b3,0x84f75411,0x58edc839,
	0x038b2d55,0x36a1b921,0x3f514909,0x86e3acb5,0x4c03af2d,0xe85d231f,0x14c9db59,0xb0e14103,
	0x395145a9,0xf2b3dfb1,0x7d4b342b,0xa85729c9,0x92797cbd,0x0ecdac63,0x85315f7b,0xb66344b9,
	0x936921a3,0x51f7d24d,0xb63b9105,0xccc5158f,0xa5f517df,0xaea9a30b,0xa0938951,0x56e95309,
	0xbad74e3d,0x157f15c1,0x03c71ab1,0xaadf93f3,0x42b7d3cf,0x363f841d,0x97cfce37,0x1a631c1d,
	0xc71d0cef,0xe0db8755,0x760fa8c7,0xa3d5c95f,0x23810843,0x0665f527,0x224b1005,0x4343209b,
	0x5e3df3b5,0x5a1dfcd5,0x33b3cf63,0xe35d7abd,0x2197b177,0x92696431,0x9de33d17,0xee7b51b3,
	0xd4b98d07,0x49d9e48b,0x99d97f1f,0x7fa3ad77,0x54b91027,0x8021a7c5,0x2efdf043,0x337fb109,
	0x4d91f7e1,0xbb1fe541,0x5c21a513,0x995f4775,0x33294989,0xc7db9eed,0xe07b10e7,0x443ff0cb,
	0xda4b87bb,0x1b837e3f,0xa4adcadd,0x7bbfaf25,0xb1ab0759,0xd46dd133,0xc3bf72db,0x8d2d13a3,
	0x9ae5648f,0x5b15a751,0x341fb693,0xbc776b6d,0x637f17d1,0xa3250ea3,0x10a97679,0xd53b0cb7,
	0xdde32adb,0x0c6970bf,0x81990ad1,0x5bb9c3b9,0x9a670dad,0xe3d70fc3,0x459ba89d,0x5ddb5fb5,
	0x40478b93,0x848fa355,0xdabde6af,0xe4355ff5,0x86a5e023,0x18d515a1,0x4779629f,0x0301c0c7,
	0xcd91ec37,0xfb19605d,0x83af85cb,0x8b1fe887,0x56fd8af1,0xb6f189c5,0x81a56a59,0x5b1bb495,
	0x1fc706bb,0xaa1bc19f,0xd70de03b,0x5029a65b,0x58b1ae4d,0x457d9e39,0x05ff9225,0xd71f3049,
	0x7f67899f,0xee277967,0x65fd4a9b,0x1d8322db,0x177f2ef3,0x7e4bed87,0xaceb58df,0xe27f398f,
	0x0375b7d7,0x664d727d,0x181d1603,0xe7e1c7ef,0x7dadd61f,0x6dad1ab9,0x354989df,0x0329868f,
	0xb17308e3,0x141f702f,0x4b933011,0xce758005,0xf3fdf187,0x9275715b,0x647fdcff,0xf9931df3,
	0x9d63c8b9,0x7bb1ae41,0xf4fdc2db,0x3af15605,0x81adf369,0xfdf58573,0x2669969b,0xe0abf6e7,
	0x09c7b7d3,0xc3938103,0xbf81d4fd,0x01851557,0xec83127b,0x73ffd38f,0xad6d278b,0x4de79915,
	0x879fab2d,0xd4d9f53b,0x2cbfe991,0x80e5e9e7,0xd8bfe9fb,0x8ae560b7,0x926dcd29,0x7139bca3,
	0x16712c3f,0x7b137035,0xb4d9a02f,0xc2430021,0xe925199f,0xcb795a75,0xf4c9314f,0x350fea3f,
	0x443b1905,0x84554fb9,0xe67154f5,0x994f24eb,0xdef5e5a5,0xd10bb6d3,0x9a650a57,0x5e5f1b13,
	0x4d8143f7,0xe12f8a13,0x86a9c079,0xc43d65b1,0xb9f1d6c3,0x6971d45b,0x0fa3bb1d,0xac9758c7,
	0x3d431411,0xc4b34e0d,0xb12397d7,0x0bbfb05d,0xd85d5a37,0xb4fb1a17,0xc763f2f9,0xf9ad5d85,
	0x0d0724cd,0xc475a2ef,0xf8012ca7,0x63077357,0x16f961b7,0x46799793,0x3b074dc7,0x5a1333f7,
	0xc4cbe623,0xf8850885,0x83e50d07,0x07c53d8d,0xf1070381,0x4341a4d7,0x0a75f3dd,0x3cb7d749,
	0x9b153c8d,0x1b771719,0x33f3a38d,0xa22d5e67,0xa0491a4b,0x8321826b,0x1c093a19,0x8b0fd325,
	0x14e32107,0xaa5d1f73,0xbdc9d755,0x64ef85cd,0x3d03e553,0xb06ff95d,0xbcab41d3,0xc90be3b3,
	0x25b9410b,0x04c5cadf,0xcd8dabf7,0x2d41642b,0xddf5a851,0x67f9fb35,0xbfb998e7,0x351d959d,
	0x4f979e91,0x8cc7bb27,0x25dde191,0xa2d14a6d,0xb8634b7d,0x591341ff,0x9f15d9ab,0xe837e60d,
	0xc3033013,0xc6ef2a93,0xbfdf94b9,0x57d1c9f9,0x400dfb95,0x6591f041,0x9b234afd,0xf5cbe2af,
	0x7efb808d,0x7a558bef,0xeb33de8b,0xe8f754bb,0x4735c9d1,0xc1c13109,0xdac58037,0x8bcd49ad,
	0x71054f79,0xd0852a83,0x6dfb749f,0x1d71dd1d,0x1e9f4be9,0x1477d7dd,0x8b5bf92f,0x12ad29ad,
	0x951f30cf,0x7595ca1b,0xa4d94913,0x06f37609,0xb5893c1b,0x970500cb,0x00c9c243,0x4d5d81dd,
	0x15cd2d09,0xb8174701,0xa2ef2a7d,0x21adf2e7,0xb9bb191f,0x353db05b,0xd571144b,0x794fe1e7,
	0x6c0f6123,0xa91b35fd,0x51df63f9,0x745387a5,0xb771c62d,0xad717397,0x0a33f4a1,0x6e7509f3,
	0x7f6b9e97,0x3c33845d,0x91cb5d21,0xb01768a9,0x39712b03,0xb0730009,0x2671d521,0xbf438aab,
	0xc5df0b5d,0x677317e5,0x59553a0d,0x50ab6ae1,0xe8fbd3d9,0x0195d3bd,0x580f3421,0xd8a9653b,
	0x63efc1f1,0x436b6ee5,0xd59f7b5b,0xbc3fa3b3,0xadd39169,0x96a9d539,0x936f3c7f,0x2219ab4b,
	0x4c9d714b,0x2b2f4021,0x8a4d9e21,0x6387090b,0xce3718eb,0xb801f38b,0xb3716595,0x1d851f05,
	0x616bfce7,0xdc4f1ae9,0x717dbbfb,0xe1b51153,0x0eefa41d,0x206fc63b,0x99791339,0x8761d315,
	0x925b1cbd,0x96df0703,0x1bd52b01,0x1c795375,0xd3379137,0x1d452d53,0x4d6935c9,0x769bcaa3,
	0xfdeffd49,0x3d6f24bb,0xd0751dd1,0x640926db,0x3cd502f3,0xae55f15d,0x1da1ea1d,0x7ca9995b,
	0x1127df83,0x75134cdb,0xacfd4381,0x9311436f,0x4c09808b,0xa5ef6363,0xbf031991,0xc57b0365,
	0xa787b8e7,0xc55bb0ab,0xc59367ad,0x2ec96199,0xff9595b9,0xc8e9fcef,0x6cf519fb,0x37859d6b,
	0x2b11d36d,0xb85979f7,0x44d7126d,0x86dfda47,0x74bd72b7,0xee91000d,0x09534db9,0x93b56c99,
	0xb4476d91,0xfaa16b07,0x8beb285f,0xd58746df,0x07418c3d,0x20bd1743,0x3c85c3a3,0x95818697,
	0x2a2b5a4b,0x7b437ea7,0x52718a99,0x5f73214d,0x71653b89,0xbbbbf59f,0x9569d715,0x12d9b191,
	0x623da117,0x8bd38821,0xc68bb6b7,0x93d363fb,0xebe75e53,0x8e61f6a9,0xa961cfe7,0x1c2f042f,
	0x40811ded,0x0063d33d,0xacdb66d3,0x2c5b29d3,0x4e0ff6d5,0xf9fdbe6b,0x34518273,0x1c75859b,
	0xd7792149,0x4f81c447,0x80833185,0x4d3d4e3f,0x2d99cbc9,0x1265d96f,0x389bef93,0xf91fcd81,
	0x88271023,0xb2437809,0x932729e9,0xa52b0d29,0xfecb0869,0xbde75cc1,0x1f1fe4a1,0x321ba409,
	0x220d03f7,0x443b63cb,0x2ce57f99,0x8d55a2fb,0x3465dc6f,0xd55785e7,0xd7419b79,0x01dfa1df,
	0x032d6abd,0x2379f559,0xac631eaf,0x296fec9f,0x5fa91c15,0x44075aef,0xf6e15a73,0x7d5bd02b,
	0x3807a6f1,0x909132fd,0xa6bf4fc5,0x87a9077d,0x505be015,0x27cb4a5f,0xda63146b,0xb4034897,
	0x9ba1af8d,0x0e935b7f,0x079f57f3,0xc0b7f181,0x34bb25a9,0xf0f1cb45,0xc4a908b7,0xcfc5d54f,
	0xf779b009,0x8311862b,0x312318d5,0x17cb2917,0xb98b6e8b,0x824dfd29,0xff136335,0x351790fb,
	0x2393a85f,0x561f42c9,0x1bebb085,0x1a974d25,0x2a0f60f5,0x51314817,0xf985dc3d,0xa2e986c5,
	0x266f0d0b,0x924f39a5,0x771d199d,0xc14dbd17,0x900767a3,0x856ffc95,0x6a5f58a9,0x52ad5259,
	0x55136707,0x04afcb89,0xc859cb35,0x8e9d38d7,0xd3b751cb,0x1959f3af,0x6e8589d5,0x1855bfe1,
	0x72fdf3cb,0x5cd7b1bd,0x8bc158e9,0xafb980cf,0xdbddf329,0xf9c12ef1,0xa9578d99,0x82556c03,
	0xd2334551,0x4cd39e0d,0x53f712d3,0x1c57f5e9,0xadbfc3f7,0x25f77863,0x64b98e4f,0xf99b63ed,
	0x7333e215,0xa93bdac3,0xea1da58d,0xb6a5398d,0x8d1f80ef,0xcfd1028f,0xb10d62d3,0xe19dc549,
	0x2501e511,0x891beaa9,0x6dd7ba2f,0x6b57cda9,0x1c3bcb4b,0x7b9f087f,0x85332e7b,0xb84b5e3f,
	0xa51d9dbd,0x66092905,0x75439655,0x519fb4a3,0x7bd9c8c5,0x20336dbd,0xde8f0125,0x36194d79,
	0xbf8d3013,0x3c1769a7,0x2d07bc19,0xcb2d1167,0x6b3bc399,0x46dd5e53,0xe101772b,0x6df5a221,
	0x6ecf348f,0xa9d598d5,0x78418a15,0xa435c761,0x681fca7d,0x2b73eecd,0xf6ed5963,0xed55fbe3,
	0xfbe9582b,0x10555b5b,0x1097db63,0x33691a77,0xcecd50ad,0xdc43bc31,0xf1353d2b,0xdc292ae9,
	0x1e59fc5f,0xb32bae83,0xa627a79b,0x79f94f15,0xfa01cde3,0x5a238c0d,0x2739245b,0x1ce3cfdb,
	0x1c21d727,0xd8698815,0xff97a2d9,0x43994a25,0x62ff5e5b,0xb861ec69,0x96db1d4d,0x6c77fbe3,
	0xe9c792fb,0xe89d765d,0x1a07ddb7,0x467b310f,0xc18b62cb,0x3cd3d3cf,0x0481e2dd,0x8253d0ab,
	0x4a4b6ed5,0x8edf4023,0x4919654d,0x435109c1,0x2be7206f,0x7fc74149,0x1b077c63,0x306d205f,
	0xef2dde33,0xd8bb84b3,0x56efe339,0x254b5aa1,0x36d16101,0x8c13dc61,0x8bd5ddb9,0x83350da9,
	0x98712909,0x56495bd7,0xa42b3d91,0x221dca9d,0x158f12bd,0xff059523,0x2ec98739,0xe19dabaf,
	0x34990bd5,0x3a15f5d7,0x47ef36f1,0xd9f7c11b,0xb9e3e859,0x28714415,0x224525bf,0x2d179e21,
	0x00a75791,0x79353b7f,0x2fdd0e71,0x778f0607,0xf40bf911,0x2aa94a45,0xeb2d32a1,0xe197b923,
	0xa81d91b5,0xeb3b6e19,0x40171faf,0xd01361cb,0x92cd60a1,0x1a7f313b,0x94e393bf,0x358da163,
	0x64fb943d,0x6a37c76d,0x734182c1,0x83373d51,0x836bdf3f,0x1f454b01,0xd1473b6d,0x39eb6c09,
	0x1fc72da1,0xf2bb19c7,0xfa79ac43,0x1b2b4203,0xf1a379a9,0x92cd5221,0x18bdc889,0xfa233ec1,
	0x8f7fc0dd,0xc3db6ff1,0x5d650d4f,0x2ca3f9cb,0x67bb1915,0x216909a5,0xca27266b,0x9c27efb3,
	0x59a7e56b,0x7f29ad33,0x9a23b37d,0x76d16f13,0xee732b3f,0xe9ebdd17,0x4ae52ced,0x806ba58b,
	0x32410741,0x48b32d59,0x4559e8e9,0x0367ccc3,0x2d0f4263,0x9da58083,0x26d94069,0x61df7771,
	0xfbcd06df,0xe71164ab,0xaa27d42d,0x4695fe49,0x894fb537,0xa0699071,0x3067f1bb,0x75f50d0f,
	0xe751d93b,0xe34f7ff7,0xea2f1863,0x3f0f4f8b,0x47753ef9,0x288931eb,0xa0719e3b,0x8c9f3e8f,
	0x944b27cf,0xa9030481,0x1d917523,0x96070cf5,0xaa459f5f,0x5ed7b27b,0x36570fc3,0x304fb49d,
	0x30bff097,0xa63f7019,0x72f3668b,0xbf2d2371,0x12ff3aa7,0x7ea3282b,0x57fd1caf,0xc5f98863,
	0x992f260b,0x6b93d905,0x4f75c531,0x18b5c069,0x2165b987,0xf5c31185,0x31c547d7,0xad0de389,
	0x789d4f27,0xcc138e11,0x6ebb6631,0x0b51f1c7,0xd3bba93d,0x8487f593,0xd68f6095,0x5f7da039,
	0x68892765,0xfd4fb685,0x02e3bb23,0x2a3145f5,0xa6bf1b81,0x5dbf03e1,0x5fbf22c3,0x91bbe91f,
	0x10f93ebb,0xb759f22d,0xd4917225,0x530b6bdd,0xb5b9468b,0x46c1b477,0x0d35d6bd,0x52b9d963,
	0x486b99a9,0x54c5f951,0x62e915cd,0xce0bd2e7,0xda652519,0xb75b67dd,0x6555f15b,0x2beb1caf,
	0x33e35125,0xf2a33cbf,0x0389ad37,0x6de94b01,0xcd091661,0xf9e30721,0x54ffb3f7,0x41418f2f,
	0x66e332a9,0x908785bd,0x02975bfb,0xafd3a491,0x44657e21,0x4b27a3cb,0x4f97cc6b,0x712ddd8b,
	0x036d6031,0x30819615,0xc2b10237,0xdb7d5083,0x15bd6491,0xfa7b17e7,0x6efdf513,0x74a124ed,
	0xda01f037,0xf725c813,0xdcfddc81,0x23190043,0x54d11669,0x89b3a5fb,0x939594c7,0xff0f9301,
	0x89a58db3,0x4b83ae81,0x411b23f5,0xc35745b7,0x73e3c4e7,0xcd1d9915,0x84415ee1,0xde6b05f1,
	0x9fd71821,0xf72fb4a9,0x552bae2b,0x236d3349,0x63b525c3,0x0b8de4bb,0x0e61f33d,0x1b25ac63,
	0xb89b4379,0x4639be53,0x15d38d41,0xf507fbe7,0xb38b1335,0x1e55c4fb,0x25d97e31,0x182fa587,
	0x9e733835,0x2733c7cb,0x3633afcd,0x545d92f9,0xb1252bfb,0x91475e5d,0x050b589b,0xb2fba101,
	0x6a613351,0x4b3185d9,0x3fed80eb,0xe81d4c69,0x88c7734d,0xc2b55deb,0x4cd7a7d5,0x637d7eff,
	0xa3e52647,0x45c505c9,0xb3258835,0x017b7c9f,0x6531f0e3,0x0371992f,0x249ffdb5,0x5c23f029,
	0x6105570f,0xacfd4d65,0x267909c5,0xbc291887,0x8fa550fb,0xb6cdae35,0x5a47f899,0xa9e315ab,
	0x663f0025,0x3971faf5,0x670da633,0x1e57558d,0x8fe5844d,0x729ba383,0x8231e359,0x542d212d,
	0x4697f081,0xe62de545,0x9885fa9b,0x38b94997,0x4c356013,0x1f2d8827,0x173d554f,0x7cf5f4d9,
	0x838f2b9f,0x10c9bb9f,0x54ff4097,0x46818b11,0x29553e07,0x175513a9,0x9acfd257,0x80a9c35b,
	0xad278977,0x9951a5cb,0xcd21ee3f,0xcd5fd0e5,0x2a899c61,0x48654613,0xb4c96ac9,0x163fafdd,
	0x81e55683,0x025be415,0xe8095631,0xbd87927d,0x1191bddf,0x522f07ef,0x538b5b7f,0x6f276e05,
	0x0ec7f3c1,0x90f96f45,0x635d4783,0x91aba7c1,0x7eaf49b9,0xa703ca47,0xcbf7add3,0x5753e201,
	0xcf5176a5,0x6cbb98a7,0xf33dadd1,0x6efde91f,0x10a5eba9,0xabb726a5,0xf973d7a1,0x5535c07b,
	0xcd85492f,0xbfb5aa05,0x624b3133,0x452dcf7d,0x84b7f3e9,0xd7997f15,0x5ddb5b41,0xc9bf2e99,
	0xc1e5c9d3,0xd67785a9,0xb1a7d647,0xee6f1449,0xd6a5f733,0xd47f9e1d,0x4197678d,0x1065620b,
	0x3373eb91,0x4013465b,0x38f79e23,0x4f755169,0x60b36ec1,0x9eb756cb,0xd38577df,0x9f1740f5,
	0x97afd5dd,0xee1ddf65,0xc65d2663,0x776fa149,0xfb9f584d,0xa51724a7,0x4907f413,0x26470205,
	0x729f84b7,0x54a5bc95,0xbe774921,0xc0113ed3,0x1eafd611,0xe8edcbbb,0xfe01d081,0xb0e7cc65,
	0x76c16895,0x8a3f6231,0x3c69bcf5,0xed8d2571,0xffa5cec7,0x1e0ff891,0x94d52e03,0xc46b57bb,
	0xa5190671,0x67fb0d03,0x31d5b4fb,0x4e93b10d,0xb2c18da9,0xcacbe035,0x1663f9f5,0x80c18c37,
	0x6d2997c7,0xa96d5259,0x86df80cf,0xdc573e11,0x4ac56271,0x67f5e02d,0x120f8e2f,0xc05f227d,
	0xccf1aa8f,0x0ca5bff9,0x3a252c85,0x5a8bc965,0xf8f34159,0x80df1e87,0xbdb9510b,0x383743bb,
	0x70f7c145,0x72357c2d,0x80cd20bd,0x77619077,0x2d0f631b,0xd35d29c9,0x15c55563,0x97b72999,
	0xd439f2e3,0xfd31e5c1,0xe675c28d,0xeb89b12d,0xb559e4f1,0x6fbd9901,0xfd15fa93,0xa8d3be43,
	0x603b8adf,0x332b33ff,0x6d431391,0x9a37c9f3,0xde936895,0xd8d3abb7,0x5d098c73,0x6fff3c61,
	0x8cffa939,0x1c3316b1,0xadd751e3,0xb11d99b5,0x9401b441,0x23f1e9f7,0x4585e35d,0x4c2bcf1f,
	0x0107e267,0x62db561f,0xf753981d,0xc86b9fd9,0x7f6352af,0x18e9c447,0x0ce9042b,0x16c93225,
	0xb153df63,0x74377313,0x6f597d57,0x02d5bc4b,0x28fd3319,0x520d33b3,0x7019c039,0x43cb519d,
	0x0169fda9,0x9fd746db,0x320bb52d,0x2d8dcf75,0x178d4939,0x5c2f59c7,0xb275555f,0x01a5ea31,
	0xe347ef33,0x37cfa33d,0x720bafb9,0xe0455a3f,0xf0592d49,0xd69f208b,0xbde10df7,0x5947290f,
	0xf7715a79,0xb0aff285,0x987b3995,0x9d2d1e17,0x9723bc03,0x9333da89,0x42bfe0db,0x4e234bdb,
	0xace97a75,0xc18bd77b,0x64fd1bd9,0xf0f9bce3,0x4e29b6a3,0xb63be2cb,0xd7ef1167,0xfe2b40c3,
	0x6131bea3,0x83f3cd6b,0x0db5bc23,0x92d95911,0xd63162df,0xd6893cdb,0x1ad5cf73,0xc1d1466f,
	0x80496afd,0x93f9c81f,0x5f41bc89,0x84833587,0x8e7d2af3,0x1d6d34c3,0xcf51d759,0x4c098c0b,
	0xa4b737fb,0x3031d3df,0xdcc79ba5,0x322555b1,0x94cb3d99,0x66bdff0d,0xffc711f5,0xca41d13f,
	0xb779f299,0x59adb577,0xdfe55495,0x92731d79,0xe5612e0b,0x60c758c5,0x1d19349d,0x046f0635,
	0x10131c4f,0xf3fd8a2f,0xb8c1feef,0x469df149,0x7b019405,0xac612773,0x1ea7612f,0x7d03eb99,
	0x94878b17,0xe53367d3,0xcdfb6ecf,0xba57d60b,0x6ee9abbd,0xfcd91921,0xa253c605,0x90f1b293,
	0xd957096f,0x35e3fcad,0xbcb3d4cf,0x43d31129,0x18dff5ef,0x38054459,0x0c833df5,0x97a79ccf,
	0x4183f64b,0x311d2f87,0x788f5e07,0x43c1c88d,0x2f25d7d5,0x9633c825,0xa815f05d,0x031b9c75,
	0x1e8fe529,0x8475bfa9,0x6bafd415,0x4557a29f,0xe6793b2b,0xc2396c0f,0xc66bf115,0x7fbdf42f,
	0xd07f3e03,0x5ffbe4dd,0x96b53d0f,0x1e43664d,0x12212e27,0xf9654023,0xdf69e079,0x147fd729,
	0xe5d1dd51,0x9643ef71,0xb0c37b91,0x0eb79afd,0x43df8385,0x2b8b3ce7,0xb16f8b5f,0x42d5090b,
	0x3b87b40f,0xbc5de82b,0x477deeb3,0xe169289b,0xebf17281,0x1afde369,0x61638b25,0x26ad7dff,
	0x1d2767b5,0x49db3057,0xdf011213,0x0b87f791,0x791d36d1,0x7c8ddd31,0x9aa1e5a3,0x967dfab1,
	0x64b1f23f,0xb8d121bd,0x11f31dc7,0xccc390c9,0x78a5b0b3,0x178d9c49,0xaf0fad35,0x4335b44b,
	0x9aa54225,0xa5d1aea9,0xb177a66b,0x4f53bdad,0xb64704dd,0xe5cffb3b,0xb70fa0b1,0xd847f073,
	0x1607da63,0xefeb01e3,0xe52b3d19,0xc7e52827,0x5c493c8b,0x33a5dd11,0xb183cb75,0x1ba7a557,
	0x1c597271,0xd8b11eb9,0x4b350f69,0x95adfa9f,0x136be579,0xbfe1cd55,0xa3cb255b,0x0dc319a1,
	0x019d964b,0x243780ef,0x18358777,0x625b8003,0x22f1b1dd,0xdbd5a013,0xb9c932b9,0x09918479,
	0x4855466b,0x390dbcd5,0x374bebdd,0x4225c3b9,0x909b1875,0x8b5311d3,0x65e3a46d,0xe481ad89,
	0xc18197c7,0x40471f31,0x6a1dffb5,0xd3b931af,0x40abf477,0xa4ad679f,0x80f5f7cf,0x0e858cfd,
	0xaca553df,0x45754d4f,0x68cba299,0x6049364b,0x15e525a1,0xf0b50f01,0x6a6716b9,0xb211eb7d,
	0xd7c398a9,0x56abe4f7,0x01f770a1,0xfb8bde79,0x11893029,0x4abb3e03,0x2817f787,0xd4130233,
	0xbf5d789f,0xa4791c75,0x3ac36269,0xa3ad77a3,0x7359dccd,0xc095932f,0x86673d0f,0x74011acb,
	0xae759abd,0xa1f16293,0x6ed16d0b,0x61632fb3,0xd997d8c3,0xb293b58f,0x383bd6af,0xabcb2f6d,
	0xde8dda7b,0x24a7fe99,0x7043221f,0x67ddb513,0x610755c9,0xf385f4af,0xf6f5a041,0xcfe38ac5,
	0x97a5e7d5,0x84adb053,0xa7bd4fc3,0x34cfd6ad,0xc4ebaa15,0xe8c1e895,0xa275021b,0x8f3d67fb,
	0x5041e745,0xbc91500b,0x345da08d,0xb06b23e9,0x7f01f065,0xaa1511cf,0x611f911b,0x134792b9,
	0xcd6511c3,0x896b6e89,0x0bc93b99,0x4d638cb5,0xe78fa7f1,0x21d77965,0xbfd3ae99,0x1ff7072b,
	0x428d54c9,0x8ac7f519,0x1a1f647f,0x28e70177,0x55555471,0x2cd550e1,0xd1f52871,0x33bd91f9,
	0x71c1f253,0x62bdc585,0x62051b5d,0x2aab131b,0x3d971e23,0xba63924f,0x5167d8fb,0xa78b704f,
	0xcb8120db,0xd5d95a15,0x1c99bcc9,0x24e1930b,0x541571bf,0xec55a035,0xbe89470f,0xced5efd5,
	0x8ecdab59,0xeb336595,0xd981a1df,0xf4393331,0xab11a07d,0x36f9e5a1,0x803d460d,0x17890eb5,
	0xe9299147,0x0c57734d,0x9eddc039,0x9fe725f7,0xd34d801b,0x81237619,0x03e995c9,0x2a1d1b9b,
	0x1699a6a1,0x255b8709,0x094f49ef,0x799dbe47,0xfc0d0ad1,0x4425adab,0xdd6982a1,0x098155af,
	0x819933e1,0xc4d1bd13,0x6bf94d9d,0x3d8d0f8b,0x1311ff57,0xabd1d0df,0xe725856d,0x33278c9b,
	0xe33195ff,0x3bc9ea33,0xf07d565d,0x32678dab,0xe49d80eb,0xb679acbf,0x61fbe387,0xbf03c08b,
	0x62e1de77,0xbdd53bb5,0xb6fd0bc9,0x495fad15,0x3b71b745,0x54ef36d5,0x154d4ecb,0x7f85c227,
	0xb6a97341,0x8109d763,0xf61bd1fb,0x3e2582af,0x00cf6e9f,0x8a852d2d,0x6f01858f,0x219dd29b,
	0x430daed9,0xddf57b85,0x1afb698b,0xb6ef63e5,0x5c79b7b1,0x8d0db64d,0xa373f2b3,0x4cc3438f,
	0x3b0f8037,0x6fad1ee7,0xe93b8f95,0x646b86a1,0xd4b387b9,0xe4d90143,0xcd8b4d8b,0xc2e3172f,
	0xc0310ad5,0x33c190d3,0x9b019db3,0x21cda14f,0x6e3d586f,0x8cbbe597,0x0ea539f3,0x8071a023,
	0x027546b1,0xaa451911,0x00eb29fd,0x14c58ad3,0xcc5bc80d,0x12058351,0xaea9e847,0xdc612195,
	0x605ba03f,0xf5c917ed,0xa21fa711,0xcd87da9d,0x50cd394d,0xb489e301,0x3bf5b55f,0xa8236f2f,
	0x86e9987d,0xfb61a631,0xdc3d0405,0x66c58895,0x3bd57367,0x869795ab,0xab6dca97,0x4fa98d1d,
	0x919d64e5,0x829d3525,0x03654c75,0xa5b18d25,0xcc354219,0x8d0554db,0x7871bdc7,0xf9655009,
	0x2a7b8f6f,0x558f2e95,0x823d487b,0x19fb8135,0x5f31159b,0xdf21a29d,0xc4e53147,0xa64bfd1b,
	0xaa059697,0x60cb94c9,0xf9e51caf,0x3dd73e31,0x9089a2a7,0xc6c16977,0x792973f7,0x51c9e9fd,
	0x373b8d57,0xd361a28d,0x61ffea2d,0x95f57e05,0x5a818277,0xe0339c77,0x6421212b,0x11d51cd9,
	0xe7a3bb25,0x3ee56b2b,0x28ad6e8f,0xd18b7b17,0x35d7d2c5,0x3a4dd725,0x5b2dc0c1,0x36dfec5b,
	0xdf3b3c01,0xb7697a6b,0x5291a3ef,0xea479053,0x39d1d5cb,0x765dfd8b,0x5a316711,0x6bdb9fad,
	0x7087a05f,0xf37b7499,0x9acf60e5,0x445dd923,0x3c319243,0xe839dc33,0xa38f54f5,0xd6370e77,
	0x3c898d3f,0x6c33b67f,0x9305f88f,0xce7dd171,0xf1377367,0xb62fc829,0xe02797c9,0x35e940e3,
	0x52c35c17,0x7d1df565,0xc357da83,0x21dbf5a5,0x0ba5e8f1,0xf9133ef3,0x3f5da963,0x05610f9b,
	0x5137bae1,0x844fdf17,0xca6932db,0xa22962ad,0x5cbd071b,0xdc37869f,0x97131021,0x9991c3cb,
	0x84654c19,0x025bb9df,0x7d598a35,0x9d9975f1,0xf443269f,0xbd6f4db3,0x83a9fedd,0x41ebb71d,
	0x075146b7,0xba510485,0x07cd65a7,0x6cdb6d59,0x407784b7,0x4d094b3d,0x8801f4ed,0x6863f3b7,
	0xe37d1637,0xd1c31655,0x0be5e6cd,0x93230751,0x2e1be31d,0xadd9dec5,0x2d7f5e2f,0xb167d447,
	0x30ebfa93,0xf0c5bf17,0xc2436bc1,0xde2322c3,0x4873280b,0x9531b055,0x240532fb,0x1beda3f7,
	0x361da843,0x61e9e717,0x1a072f1d,0x860b5f19,0xd93ffe3b,0x6ae35079,0x61f3982d,0x21653e6f,
	0x8815e841,0x323d2f1f,0xd8d7e7f9,0x4d8fbc3d,0x08c174e7,0x6941d837,0x442d7f1b,0xd5c3afd9,
	0x2a533809,0x51599077,0xbad369f1,0xa1e13a99,0xfdbd9fc9,0xbd1d891d,0xae1545a3,0x0775d4e1,
	0xaedb6995,0xb149fceb,0x929f451f,0xbab17b17,0xfd73371d,0xa5c76d33,0x298b561d,0x5f71faaf,
	0x562f435d,0x66a5fec5,0x6959661d,0xba355f21,0x8ba73799,0x9515f701,0x06f1c765,0x81277eed,
	0x2f51205b,0xc87958cd,0x9ea5b603,0xcd1ba89f,0x8a978279,0x4f57a197,0x7d2bfcd1,0x2a896fc7,
	0x37c3900b,0x905ba64f,0x08a5ba6f,0x4a9599ff,0x5b097d77,0x0b5f9079,0xc99b463f,0x54092be5,
	0x7b87f667,0xfa5dfb15,0x13fd3577,0xd4599627,0xfc3fb2cd,0x927d2fb3,0x50218009,0x509b0273,
	0x351d2be7,0xe50f8367,0xe3cbc5b5,0x7695c083,0x2bf77135,0x6087d3cf,0xbb21b305,0xedafd319,
	0xed891d87,0xf1832411,0x71b58647,0xc7fb9cfd,0x86776beb,0xc3cb59d9,0x1b7db491,0x9337ae01,
	0x9c4d6cbf,0xa34d1a5d,0xaddbaec3,0x09c1afff,0xa6815aa5,0xfd1fc759,0x0895c685,0x63a573d7,
	0xc76b0f89,0x807f9c13,0x9edd3345,0x47951e73,0x4553999f,0x5fd1ea59,0xc04d373b,0x5beb75c3,
	0xa365f061,0x31a7777f,0x81e16467,0x77ab4dc3,0x5ab3c993,0x71b7f963,0x4705018f,0x737d1571,
	0x333b8e41,0xa1ddb369,0xea878f43,0x9ab383d7,0x3ce36fbd,0x0b1f3381,0x87a16cd9,0xbc496509,
	0x68739ca1,0x1ead2f1d,0xe2f19d71,0xdbe1871d,0xc0a195d3,0x76df803d,0x7381acf3,0x82c5c735,
	0x430ba37d,0x782f4265,0x0bc1b50d,0xb0e73e7b,0x59336a11,0x92450fa1,0x22898237,0x6de38f21,
	0xf1879f4d,0x20ef5d89,0xbc19d8b1,0xf9f7515f,0x385bdf33,0xed25fa39,0xf31bd981,0x9f11a075,
	0xf0e9a10d,0x4e03a955,0x219b8775,0x21c1c7af,0x6e574c6f,0xe9d1e10d,0xaa176c29,0xd2430f5d,
	0x2cb36e35,0x16fda713,0x606b5cf7,0x3d79a9d7,0x09ed0d81,0xdd1b8da7,0x92df6009,0x7dedc07f,
	0x1ee520c1,0x95edd08b,0xb327b14d,0x2cd1a0c1,0x385d22a5,0x2e559211,0x9f59e77b,0xf2ff090b,
	0xf003c729,0x07653809,0x8af33913,0xb9fb95d7,0x656bd091,0x7751e8d5,0x87e1e15b,0x7ceb4ea5,
	0x97110469,0xea792857,0xaf73a563,0xb9a75303,0x5b574083,0xa46194fd,0xeb5f7901,0x81a5a77d,
	0xf98baff9,0x20bbc4bd,0x5ec743d5,0x2b0922ad,0x62e32031,0x14574213,0x6f31c647,0xa19b7a37,
	0x0b7975d5,0x0e39a907,0x6d8f9e85,0x57d16fc3,0x635341d9,0xb885e423,0xdf3b6d89,0xd7c31e01,
	0xef5b7675,0xb98b897d,0x66f11c0d,0xf43365ab,0x02673c31,0x34bd57b5,0x4ddd3f9d,0x998d7a83,
	0x1631e6d5,0xebbdd2eb,0xac8d9f87,0x3ee19053,0xc4610a77,0xff5101d1,0x33f9d9e1,0xf6eba7e9,
	0x5f81b06f,0x50654a9b,0x9685288d,0x210d7c21,0x2c05ac61,0x81137005,0x90f5462f,0xba518edb,
	0x39491139,0x9595ae57,0x937b7337,0x4e695601,0xda93c62d,0x3553f85b,0x0aaf9add,0x88ad8883,
	0xc00d3bb3,0x8bdd5467,0x48919821,0x65258b5d,0xafcd4091,0xc9e75959,0x0d899ac9,0x0175fe8d,
	0xdecff6d3,0x4651cb95,0xb169ac65,0x0df36a1f,0xe9f5e8cb,0x3f1f5a0b,0xec67554b,0xde990b21,
	0x6f0f3e13,0x3a817b2f,0x4025619b,0x1c09c0b1,0x45cf1091,0x07cb69fd,0x00abc63d,0x148b18eb,
	0x58d3e16f,0x607f42fb,0xfd67a5e1,0xad157dfb,0x1e9b2e21,0x29414135,0xca3575fb,0xf23f8313,
	0xb2992561,0x52df1b43,0xa85343cd,0x494b516b,0x8e1d7c31,0x5b4f8041,0x0f69195d,0x41233543,
	0xe16562e1,0x6eb1b4d5,0xd687827b,0x035d4ae7,0x8c9599ff,0x284b5029,0xfd2731bd,0x652d4ba7,
	0xb8b9a769,0xf38918f7,0x1429c583,0x987b7add,0x10c52b43,0x0d030277,0x46d3acf5,0x7ccdb2e7,
	0x9a9754f5,0x23774973,0x03d72d03,0x90599233,0x2ff17835,0x98cbb137,0x464f8561,0x80f7c82f,
	0x977fc1ff,0x630fe095,0x7eb73591,0x5d298255,0x3dd70d93,0x8d77deef,0x1bfb61d9,0x6519f927,
	0x8e77d97f,0x5961b127,0xb4695849,0x7b9b1d2d,0xecbf5c95,0xff5516ab,0xceb935b7,0x372963f9,
	0x4cfdbaef,0x10016673,0x4b0faac5,0x92e3b525,0x6d655af3,0x75398bf7,0x6befe0d7,0x3f957751,
	0xaf155a4b,0x12ff2441,0x7f4b7f1d,0x94b3bd27,0x8f0f22eb,0x0875badb,0x277bcf8f,0x21559257,
	0xbf41200d,0x90ed26db,0x443f03ed,0xdd3b689b,0xdf7d9335,0x84db07e1,0x7bbf9abd,0xf9d5a4b5,
	0xd681892d,0x7adf630f,0x638de44f,0x53314b6f,0xcaf3ef09,0x88bd6013,0x499fa7bb,0x8109ce97,
	0xbc5bc727,0xa4672623,0x9d57e7dd,0x87c3fa09,0xbc317e25,0xa4efd8fb,0xf87dc85f,0x296500a7,
	0xc6cd5ff3,0xe393b5e3,0xc83f92b1,0xd6a3a957,0x3c792cc1,0x7cbd50a5,0x9639db07,0x3fd99c0b,
	0xfa5dce0b,0x30fbf097,0xf167c563,0x8607cebf,0x138d2b97,0xe5ff0d97,0xf7356a8b,0x0bd71271,
	0x2a09206b,0xc7aded0b,0x7c735d0f,0xe69dc02d,0x67b18fdf,0x09055edf,0xd6574e45,0xef518603,
	0x17559a8d,0x453b9a87,0x4381d34f,0x7397540b,0xdda5f357,0x80a13c05,0xf4fd4a11,0x86bb6969,
	0x92415469,0xc9b760d9,0xb737de3d,0xf2ab8143,0xb8ad1437,0x7a25e511,0x3b09ae47,0xc9031fcd,
	0x9953da7b,0x17b7c047,0xfeb31071,0x9407ff3f,0xfa877539,0xd5638293,0xd6dff7c1,0x279f9cdb,
	0x7989cdbb,0xb447f19b,0x179b7907,0x125fe5e9,0x837bfd97,0x44abc58f,0x5d616fd9,0xae7f04bb,
	0xee6783a5,0x06fd8621,0xf60f4399,0xd2e34da9,0x3245990b,0x6cd38791,0xe9efcc6b,0x24154c17,
	0x41efa631,0x79eb07a3,0xa4b15841,0x0549ef6d,0x042bd7cf,0x05296aa5,0x3e6dcfcf,0x2955d81b,
	0x6ca3d3db,0x99a19869,0x64a3fb97,0xc3bfc49b,0x34ed8e9b,0xf7837951,0xe33be8df,0x59af1e6f,
	0x35853f9b,0x3531933f,0xcd876eb7,0x32f7a71f,0x5ecd76ad,0x802fc6a3,0x473dd2f7,0x6b13453f,
	0x521550ed,0x7e2f2b6f,0xed7f8f3b,0xa227f165,0x9a8fcdbd,0x4e030e23,0xdfd335ed,0x4df9c333,
	0x865743c9,0x28ab0cc3,0x692d773d,0xaafd1e53,0x9f73f605,0xa24d53db,0x48e3461f,0x4d4dff75,
	0xc4cfc8ab,0x8b39fb83,0x9bb31d55,0x51ab6955,0xe33d163f,0x70e38455,0x64c96467,0x2e83f1b1,
	0x4e7ba48d,0xbee97479,0xb6b5f4a1,0x24e76e53,0xba2bb9a5,0x8013149b,0x7c6bbe1b,0x518fc20f,
	0xd2dd50e7,0xbf4f4cf1,0xe2518cb7,0x5ddfc9bb,0x77056ff1,0x88b1a239,0x5f2bed19,0xd0e16939,
	0x8ffb9bb3,0x8a7b52b5,0x5d2d31b1,0x0047b875,0x8b076d5d,0x560f9337,0x82eb97b9,0xa16b505b,
	0x7253476d,0x40ffec0f,0x9c678c2d,0xfa4fb7e9,0xa5f72aa3,0xe601b61d,0x240b10d5,0xb29ff11f,
	0x34ebab0d,0x45efb7c7,0x6ba54141,0x44ad2605,0xd61504fd,0x88d5e1f9,0x656df7c9,0x0e7175ab,
	0x8141520f,0x5edd2d29,0x0d059289,0x028fe12f,0xa823de25,0x015f9653,0x7075d86d,0xf95158af,
	0x0f599c6d,0xd3d93bff,0x592dfe1f,0xa1a7e853,0x4765bc55,0xa4f19b35,0x9505cb1b,0x122f054f,
	0xc5b55e9f,0x8f75ec91,0xdf3dde9d,0xfa2bfadb,0x9d9b6a49,0x7b5da12b,0x697d14ad,0x72837739,
	0xd955819f,0x3ec5ffa9,0x04d70b1b,0x6ec938b1,0x73071737,0x5ef5e13b,0xeac1c67f,0xce39da95,
	0xedbfa2e9,0x71598e95,0x261d7735,0x0cb5c23f,0x8e6df6db,0x1c8bbcf3,0x9c335e69,0x93c52c0f,
	0x34f1b475,0xb945ab1b,0xb5b1d305,0xab9f586f,0xd50de16f,0x936f5e5b,0xa7b366c5,0x0c1bd8cf,
	0x8f6f9cc1,0xcb19ff87,0x5cb52b25,0x0dbbfca9,0x6aa9f3ad,0xd57757fb,0xfda3166d,0x7aab5e7f,
	0xac3bd6c1,0x9de96ea1,0x1acd88ad,0xffbb90db,0xd1852ecf,0x46f344e1,0x74e9f0bd,0x3d67eb4b,
	0x28d711f3,0x8b45b3b5,0x6617913b,0x78d1776b,0x0a61188f,0xbeb56897,0xeae1658d,0xecc3fddb,
	0xb143d251,0x6f3f028b,0x4b3726e5,0xbaad3347,0xb47f5b29,0xa60d4f23,0x63737137,0x7bad055b,
	0x20031053,0xc86ba771,0x8d510845,0x718307d5,0x2da36553,0x18d16d11,0x28fd3c97,0x579b0173,
	0x9e1bd8f3,0xd7dba72d,0xc6057079,0xd4059901,0xb20d0a49,0x0551bf6d,0xec61bd05,0x887d224d,
	0xc309edad,0xc11f5f09,0x8573b717,0xc3638b35,0x7c8121c5,0x4c5d6bbf,0xe503545b,0xd0c56895,
	0xb4d1647b,0xaa4924d1,0x7241f03b,0xeb53235b,0xe63d2803,0xe1496011,0xf0c570f3,0xcd654573,
	0x47f347d5,0xdbede6cf,0x698f8c7f,0xe201e6db,0x8707ddb9,0xe9e9f2ed,0xb4072da7,0x15d13a93,
	0x1f7536b7,0xe11bcbcd,0x9efff8fd,0x48253ba3,0x551fe823,0xde8b835d,0xb9adf1d3,0x5bf97a1d,
	0xccd50499,0xa767d313,0xbcb33f4d,0xe8ed081b,0xc54970fb,0xaa0518eb,0x9317114f,0x8c4f86bb,
	0xf0175977,0x9ee1746b,0x034da58b,0xda0d532b,0xeac5c67d,0xc9a503a1,0xf8296c77,0xedc5d399,
	0x57bd51c9,0xda1d4023,0x69ef4e51,0x9bb7e43f,0x9755fb5f,0x6d3f7c0b,0xe7451021,0x41cd645f,
	0x20c91e8b,0x2e2b7f01,0xbe3bd8b9,0x389be343,0x7b3d86dd,0x97254331,0xc54bd5ab,0xe45b6d39,
	0xd6bda535,0x529dd24f,0xc453005b,0x65ed789d,0x453de4b3,0x3c29429d,0x7d9d02ed,0xebdff2cf,
	0x93991fc3,0x0187d3db,0x56db3d53,0xa35f6d39,0xc2973517,0x639d2c59,0xa221ea43,0x494b6a4b,
	0x1fe3bcad,0x177bb5eb,0x86f1643b,0x5b21ca7f,0xff0fdcc7,0x47551aef,0x8b358a83,0xe8115959,
	0x12993eef,0xb389e349,0xbc3b462d,0x01e97a5d,0x64e524f9,0x739f3169,0x77bb2f0b,0xce23f621,
	0xf13f9e01,0x57439f41,0xd4d750c1,0x36e3e73b,0xdcdbdb69,0xe74d3b51,0xad170fb5,0x3bf5c74d,
	0x4fd7a5df,0x06bda59d,0x456b2e13,0xe3c79c01,0xee35f253,0x33b54cb3,0x972bf0d7,0xcc754409,
	0xf0e19701,0x6887caa7,0x391764bd,0x5cc3e41d,0xdeb3206d,0x9ca76217,0xe857c34f,0x951973fd,
	0xe563c663,0xe5b59b27,0xb17bf7d9,0x808b6b75,0xd29780f5,0x38750085,0xb97f4475,0x45d38f55,
	0xacdb3d7d,0xc9d7fc69,0xa6bd0701,0xd851de75,0xeca333a1,0x0ff1d58b,0xaa039e23,0x49119eb9,
	0x554d5a4b,0x6301cc35,0x277d6e4d,0xb7c58a09,0x6e1bfcaf,0x3e6b5733,0xffc706b5,0xe3c91b55,
	0x9b3b6f47,0x21c380d7,0x78dd6659,0x5d1bfb97,0xd6c1e4d5,0x11b96403,0xc72b6103,0x55698ecf,
	0x09a76369,0xb92fc919,0x3681243f,0x1105a109,0x04d3d951,0x2a2be307,0xf313dc67,0xf7e73357,
	0x1a13522b,0x3ed92c43,0x72877997,0x46b568cd,0x55174bdb,0x9a9163cb,0x7ce194bb,0x5fb59391,
	0x547f2b89,0x4ad3aa21,0xd593747f,0xbbdb61cb,0xc2cdd2ab,0x0841be55,0x8475325b,0x7bc12aab,
	0x6f6f53fb,0x17ab5afd,0xbec7ff8d,0x98ab5b6b,0x07b9c87f,0xcb09b333,0x70338a1d,0xb581044f,
	0x6fe5447d,0xa2790f9f,0x63c781dd,0x8fd5859b,0xbc1bec8d,0x0d3f8b6d,0x0cfb3d61,0x10e55ca3,
	0xc9632a89,0xcacbf153,0xf0b17f07,0xfe8f10c1,0x76b50293,0xebb1b88d,0xae3159fb,0x4c5f4055,
	0x7deb8817,0x72b321e3,0xa82b3729,0x0c87cdcb,0xeccb72c9,0x95b3749f,0x4db7fa49,0x00e12c8f,
	0x3dffd3a1,0x9ec35b97,0x035546d9,0xcbefce1f,0x121be9e7,0x6d196229,0xabede523,0xc1ddaef9,
	0x889f1823,0x9611913b,0xd1cf4733,0x597d03a9,0x38edf92b,0x26312c37,0x6fb72de3,0x3d4705bd,
	0xcb4f9517,0x02298e17,0x59bf6dd1,0xfc5fe0d3,0x31fdb64d,0xe7cf2655,0x4675d463,0x5b8fbf87,
	0x82115e75,0x0f2195f7,0x77c52ccb,0x4649f885,0x6c915b85,0x6b45ec8b,0x040b64ff,0x5fa75b7f,
	0x5767fcb9,0x8b8b0525,0xbf03d2bd,0x336b9e2d,0x1669e791,0x1c650363,0xc2d9988f,0x0701e951,
	0x44530cdb,0x0877f069,0x991b2ac1,0x4a7985b3,0x3bc9bda9,0x398377e7,0x03c3f46d,0xa98fa925,
	0xb055e055,0xf977c50f,0x66311c71,0xbca5637f,0xe76f4585,0xf36d7fa1,0xce2b6a75,0x59c5aba5,
	0x91731d25,0xd49fe8e1,0x9ce34be7,0x85a18c7d,0x42a38b63,0x8d75189d,0xcff1f8ff,0x049371fd,
	0x8c2b5dbf,0x327f5a27,0xea55b9bb,0x8b9d9619,0xb521dffb,0x7d71a961,0x7d794ae5,0x916b8dd5,
	0x1381d121,0xee2b4fad,0x52296309,0xbf4df639,0x052f7887,0x8bb1a0fb,0x31a35781,0x023f4157,
	0x88f7dac5,0x4533d8bd,0x4e83e16b,0x3be3a349,0x778d0ec1,0xf30716f1,0x4dd302af,0x93831f2f,
	0x5c8fb2a3,0xf7ab7d1f,0xf0010afb,0x6711b433,0xef7f80e1,0x80c56b51,0x59e9bcc5,0xdc25aa85,
	0x2cc90537,0x6823dd1f,0xfdc99251,0x11070061,0x0ec371a5,0xb4bde6a3,0x244922a3,0xed9bf705,
	0xe6a99379,0xbbaf5185,0x157ba689,0x9479bfbb,0x559fe845,0xe13f59f3,0xe1d59d9d,0x73d548d7,
	0xe5b3d2e5,0xf9df8b9f,0xcb39933d,0xf6972aaf,0x42d5f07b,0x4b21bec7,0x4ded0391,0xd547b4a5,
	0x13e58d73,0x2cc53531,0xc9a36087,0x07151a23,0x73a53a81,0x49b1d72d,0xca7536d7,0x52dfbf9b,
	0x09c1819f,0x80f5908b,0xf1df72ff,0x8025a785,0xc3d1bb11,0x66c5cdab,0x7fcdc649,0x2813ff61,
	0x2e4d0261,0x657f1873,0x7b8d2bc1,0x2679ccbb,0x6d9b4b65,0x7eadd54f,0x7cd98d41,0xaad3ba23,
	0xd7099735,0xabf72035,0x14cf8867,0xe9410431,0x29c74937,0xe039c9a1,0xd6fb539b,0x6b918689,
	0x67f59c13,0xa86f7399,0x0249c30b,0x0231e8d1,0x4f9536c1,0x6cbdceab,0xca136daf,0x553febbd,
	0x7395e177,0x5175f6eb,0x3f19f245,0x157bd605,0xf4c95abd,0xb80df0f7,0xd8835c57,0xcd51016b,
	0xdaeb4c59,0x602146f5,0x9ce3a933,0x51d187b7,0x0da16065,0x2877c58f,0xeb316cef,0xd3b50fbb,
	0xed797635,0x6fff58ff,0xe3cb976b,0x9063ba51,0x8ce3f773,0x16cf09ff,0x7179594d,0x22e12f59,
	0x893f4d05,0x1f251ad5,0xf26f2909,0x74e5cabb,0x83d17421,0xee67444f,0x8143e7d1,0x4fc5e96d,
	0x3ac3b341,0x2e2512bf,0xddf526a5,0x8d875663,0x422b6f29,0x4d136307,0xf6ed8b4f,0xe9d5d7a1,
	0x5d031fe3,0xa00fff8b,0x11fb555b,0x72ffdb2f,0x763365c5,0x23215d35,0x95590323,0x9aff4421,
	0x39833e67,0xda75787d,0x70a716c7,0xe87b578d,0x4cab59af,0xd365d261,0x25edfb29,0x47b9c995,
	0x28458ec5,0xc56b8d65,0x729908fd,0xfbadea63,0x90d77121,0x5331aa95,0x9885abb9,0x2ef3f327,
	0xafcb0579,0xeb836689,0x46f3a69d,0x24cb731d,0xcc7796d5,0x4a57b65d,0x238979af,0x0a1fdc83,
	0xa517ab7d,0x99cbe4b5,0xf357e6bd,0x668331a5,0x67cd1a05,0x33294ebf,0x63d59661,0x2d2fd1d1,
	0x4ba93e49,0xffdb4131,0x73e7dcfb,0x6e096665,0xc99d4e6b,0x7a79f549,0x7cd19fad,0xa697efbd,
	0x7585cfd7,0x4fc1adc9,0xdb45596b,0xb30df245,0x77272c41,0x9f97f403,0x385b3feb,0x5f45c36f,
	0xa32d66a3,0xde0ff4c7,0x729388ad,0x97c3f6b3,0x342df041,0x5459fd75,0x26d5cdf7,0x3aafea93,
	0x23a39da7,0x41d718f3,0xd97393d9,0x88dd7597,0x22f3bba7,0x9d0fccad,0xbf25ed29,0x36c7b34f,
	0x3469445b,0x74adf599,0x26094087,0x1d8df159,0xe4393429,0xf08bc535,0x7ea72d5b,0x8bfbbc53,
	0x217ffeb9,0xf2a3de83,0x04f390d3,0x37830ce5,0xb7412403,0x581d9313,0x0943aae7,0xcd3f94c3,
	0x656be53f,0xda493ff9,0xd9576355,0x22f32ba5,0x99cf19ef,0x8f9bcad3,0x4957aea7,0x08075c4d,
	0xc92b24e1,0x0cb13ec7,0xdcd3132b,0xb68f1185,0x68230927,0x25558981,0x8fc54df7,0xe443631b,
	0x84439f1d,0x4d6f5837,0x3f8d17eb,0x738782e9,0xfcffe967,0x9a1b14a5,0xb3f10aaf,0xc465c9d3,
	0x5cb589ed,0x62950211,0x4825a5b1,0xa58fe4c1,0x51a756e5,0x81417a47,0x33bd7329,0xe56121a5,
	0xc7030fc9,0x34b34aa1,0x73bb4d17,0x82d9dc75,0x9ddb325d,0xa09b30f7,0x5389c241,0x7ea50c35,
	0x062defad,0xeedb78af,0x95f59b37,0x4c17efef,0x77dd4109,0x1077b7b9,0x3e397f4f,0xe227dbb1,
	0x4bb91d11,0x1e9fab87,0xf8f3b9a9,0x6c792597,0xf471cca5,0x5bab3619,0x252d1e2d,0x9c5732c3,
	0xd7a55ff1,0xd4157af3,0x7d570e89,0x99b3a45b,0xc6d74367,0x9f851c21,0x60499f35,0x9427a491,
	0x1875f4c5,0xc1c9973b,0xba43dc71,0xf3f753a1,0x60d1d80b,0xabd9c25d,0x8def2f43,0x2b0954c9,
	0xcb2b2c89,0x5cd1692b,0x1d5be27b,0x25f57b55,0x12a321cd,0x22f909d5,0xb2ffc7af,0x5cf19795,
	0x1b470cb5,0xfcbfb20d,0x0abdfc3f,0x84e163e1,0x2b0dbc63,0x99b7fc11,0x5addce53,0xe04f919d,
	0xc2cfef45,0xfba32ba9,0xfd0dc1d9,0x306df62f,0x1751e80b,0xb7656b1f,0xb769b589,0x4615d80b,
	0x2a4122b1,0xd60f284b,0xa56f27e3,0x32c95ba9,0x8333297b,0x55d79189,0xc1079c2d,0x19b5108b,
	0x88a189f5,0x4b1732bd,0x0b811f77,0xa0a99e39,0x78f3e9ef,0xa15bb255,0x5697ed97,0x01219145,
	0x03713c89,0x7c4dae47,0xad69362d,0xb93f4849,0x81531723,0x38c3b90f,0x5d7d01a1,0xdccd00e3,
	0xceb32669,0x0dbf76b5,0x9fc53623,0x063d04c1,0xc397c34d,0x4d65d9c3,0xe19bbca7,0xe7a9f691,
	0x4ce9a80d,0x4605804f,0xadbbc5ef,0x7bd33f0f,0x257fc52b,0xc31130f9,0x35512f7f,0xd72799f9,
	0x2f133671,0x2e2b77e1,0x78eb08ab,0x98b5c319,0x6b4d57f3,0x501963b9,0x11833787,0xfb394341,
	0x94b5fb0d,0xb1c762b5,0x99773df5,0x86155d4b,0x57c3bb63,0x9d4f3f91,0xb5911e99,0x5e511b17,
	0x2bd373dd,0xbeeb3e95,0xbe0161e3,0x37a37a8f,0xcc25d3b1,0x66035a89,0x075f3b0b,0xe563baa5,
	0x50eb135b,0x6627a1c9,0xcbabcd11,0x8b93c84f,0xe835c99b,0x980bb32d,0xb34d8fbb,0x6fdfcb93,
	0x2effe07d,0xfa8f5b1b,0xfe17d499,0x6a97d475,0x2a31aa57,0x73b75083,0x4c3f6c01,0xf7b7a80b,
	0xdf9516c3,0x31b311d9,0x07676a15,0xe7dfad6b,0x8edf07a3,0xabd7e219,0x6b970bb9,0xb15dfab7,
	0x8aabc623,0x43a5e5c9,0x303fbb9d,0x6121821b,0xb17f97b5,0x85c15ff5,0xd1353739,0x2bc35ec3,
	0x86c77317,0x0af90f35,0x77bdd3cd,0x9e8941ed,0xebd5d54b,0xf943aaa5,0x837de35f,0x705dffd9,
	0x78e7b69b,0x24bf7eeb,0xb38739bf,0xf2cf3ccf,0x76219f9d,0xd0b32b31,0xef4fd183,0x231b3a21,
	0x748fde29,0x108b7e2f,0xafbb910d,0x5b21c327,0x8725da63,0xc8df7323,0x080f2f81,0xa26f3a45,
	0x1bbf8bb9,0x506d4ed1,0x4eff39cf,0x9f33c5e1,0x74230ddb,0xb11bdc85,0x679f37af,0x274b9d6f,
	0xbefd55c5,0x88f9cb17,0xaa71f0a1,0x71377667,0xd0df06bd,0x8b3b29e3,0x6e5fd0eb,0xe523114b,
	0x7d476749,0xa13f05cd,0x31b76e9d,0x8ddfe6a3,0x8f997641,0xab8d2643,0x63332e8d,0x29e5f403,
	0x64231fbf,0xe2d3ea3d,0xcaf1095d,0xdc5ba8ff,0x21159225,0xd8e54533,0x937b7071,0x7e07f43d,
	0x8f8fb31f,0x19c5dc2f,0xf2c152f9,0x8e5d7065,0x9493b4a1,0x6c9542bb,0x731b42ef,0xc479b127,
	0x4a0fc9e3,0xb4a757ed,0xdc49ba0f,0x401bb03f,0xb7d5fc6d,0x726fc365,0xbc737ee1,0x5aad5a6b,
	0x2ca32109,0xe48d9245,0x912b29b5,0x18433c75,0x371fecc7,0xc8c7f43b,0x9067c9a1,0x38975031,
	0x3ed12a05,0xbd09187d,0x1189a985,0xe809e975,0xbd2f0d67,0x406b2ac7,0x96593509,0x10a5c323,
	0x1697aad5,0x5429705f,0x7405fd9d,0x4b1f2c25,0x134d8a87,0xbcad8513,0x1c29df75,0x6fcd546d,
	0xf8795df3,0xe285b839,0x05c34693,0xc7b5b9f1,0x4135d4df,0x536389ab,0x363b93bd,0xdd7fb5b7,
	0xf7799257,0xe32b46d1,0x6a61a183,0xee7f28c5,0xad2d41ad,0x6cddc797,0xdf6f693d,0xfbaf492b,
	0x1519cb7d,0x33ad4b71,0xbc05c807,0x7aaf8f07,0x3bf5aaa9,0xe3ed765f,0x192963cb,0xa6cbc175,
	0x615b615d,0x341d6de7,0xab4db039,0x71f523a3,0x70cf0e0d,0x25e51611,0x0b4913c5,0x15c9c1bd,
	0x1abf2073,0xe7116e77,0x9f5f2cb1,0x4485de01,0x8d7f2e93,0x52970f35,0x24333603,0xfa197daf,
	0xce4be9b7,0x1195c5f1,0xd5d98c8b,0xed11160f,0xb2453373,0x5c5352d7,0x38c953e1,0x9fad5973,
	0x777d52a5,0x5b3f459b,0x82e13b61,0x10cb2435,0xfde5486b,0x27effa7d,0xa46b6335,0x0cf789b3,
	0xa0594535,0x6e21b741,0xf117614d,0x1f63015b,0xad9f3db3,0xacb9e833,0x68fd665d,0x22e9b39b,
	0x81619fe3,0x16cb7d2b,0xa19d82e7,0x730de6ef,0x3d352805,0x14876685,0x4edf0c31,0xbcf78cd3,
	0x2195d5a7,0x644f3225,0x6c15214b,0x707beed7,0x86e9009b,0xdba9c87b,0x04f5500d,0xd1117b87,
	0x767b8dfd,0xc8414979,0x9ea15a13,0xa6ddb37f,0xe37f452f,0xf0ef099f,0x40a119c9,0x8fa9365f,
	0x841144dd,0x36b1aeef,0x1de38759,0xefe7efd1,0x4a3797fb,0xd5ad6dfb,0xddc3ddbf,0x83b16485,
	0x7cdbeac3,0x463366d3,0x84ffdfb7,0x8fcb1f37,0x70d35fb9,0xbdb72219,0xfebf3cc9,0xb29d3da5,
	0xe1db84a7,0x4fd72def,0x45931645,0x55391d9b,0xeb9767a3,0xaf5bdb03,0x2c75a441,0xbc5d29e7,
	0xa293cc05,0x8f31198b,0xc7c3fa9f,0xb967c767,0x4d437f73,0xa36d7645,0x7649ee03,0xfb6161f7,
	0x3d05ced7,0x42513773,0x8a3318df,0x00019983,0x471b1b63,0xa54199e5,0x921b0067,0xa4a18efd,
	0xddb18f93,0xc9c92df1,0x4201599d,0x573f515d,0xc8ddf42d,0xf2a55471,0xfc4f6e47,0xe7896aa3,
	0x7f9da539,0xc8addbcd,0xfad3a1f5,0xf7cf8cdb,0x20d1a70b,0x1bedbcf1,0x17c716ff,0x0e0d5f15,
	0x0c47db3f,0x448ff853,0x36c97383,0x44e56a69,0x1bb355b7,0x23eb92ef,0x4de3c667,0x9ca126fb,
	0x7bb3d19f,0xc57fb34b,0x0e858c5b,0xec3328f1,0x24c9466b,0x9ff1de75,0x2e85d4d9,0x72356d7f,
	0xf4619cd5,0x760f5503,0x5127871d,0x05e9c7df,0x65d383e1,0xd7d1900f,0x9013c72f,0xe83b6e4d,
	0xeb5765db,0x4353de3f,0xa4557adf,0x34bba717,0xe7137d53,0xe5dd20c3,0xaf6beec5,0xf2a5958f,
	0x44130a29,0xfcdba84f,0xa42f9b3f,0xc5db2709,0xaf4da67b,0xd6e7321f,0x4fef0973,0x3fe71feb,
	0x709bbbb9,0x74bb04f9,0x0357d853,0xd0fb489d,0xe3c11795,0xca412e29,0xdb83e193,0x58f1ba8f,
	0x916da107,0x9f83de87,0xaaf17eb5,0x584b4d3d,0xe8312d57,0x11bbe76f,0x8289ee01,0xc1352325,
	0x958d750d,0xb44757c7,0xda9bd783,0x687f56d1,0x7ee128fd,0x51ab38f9,0x5be1f213,0x16a5c7d5,
	0x5a7b2743,0x4c976bff,0x4879c853,0x38c907c7,0xe891d041,0xa0e1a653,0x84ef9da7,0x31b36749,
	0xcc3d7ba3,0x84858ef9,0x412f7341,0x4ad92305,0x04830d5d,0xa8adfb83,0x41932d15,0x4553b0ab,
	0x0551aaa9,0x1aa54d03,0xc7dbd6e7,0x8ae32bf7,0x707b8f0b,0xc4e5ed15,0x1c310939,0xfef3e3a7,
	0x6ebb014f,0x9009eae1,0xb6236e5d,0x6f990687,0xa8b96887,0x23d9b815,0x05a9676b,0xa6897067,
	0xdfff810d,0x484105e3,0xdc25d13f,0x1a2b971f,0x27ffb187,0xe659c20b,0x755fe985,0x3e879793,
	0xbf197fdf,0xa95f33cf,0x208753a7,0x764d62a9,0x87912647,0x3fbb38ff,0x89353de1,0xa3db0a55,
	0x2091483d,0x3bf7a2f1,0xa069a62f,0x5a312e8f,0x9f2fc781,0x95cdb37f,0x258bbf5b,0xadf98a57,
	0xe767b923,0xcb19ba11,0xcf6d75f1,0xa687a0b9,0xa51b7a71,0xa0e3d095,0x15451549,0x4ed589c5,
	0xe51be609,0x8459b87d,0x97b50c85,0x6685df95,0x4e19a8cd,0x8bd1d7c7,0x29c3d389,0xb2dfcb49,
	0xf9b1b6e9,0x17c755f9,0x79e3f007,0xefd93209,0xed69e0d1,0x13e55921,0x5ae91a75,0x6109020b,
	0x33ab8841,0xd7f762d5,0xad198311,0x02b59f83,0x94cd7539,0xa8f3cd2f,0xe71936e3,0x5ac771b5,
	0xf00bcb05,0xd9f967d7,0x3ef9a4bd,0xe9cf8fe9,0x34891d3b,0x8d4d34f9,0x73334231,0x3c078e71,
	0xfa53a4b5,0x155f4649,0x33a750a3,0x9a556ba7,0xbb5d9493,0xf5c5ba07,0x2a9bc239,0x5b3f9ceb,
	0xac838f45,0x843dd7f9,0xa5c13edf,0xd3f93ba7,0x368b3b7d,0x29af4e67,0xdf314951,0xe95f524b,
	0x0f21f935,0x43258f2d,0xe66b840b,0x40f14953,0xf1d7b6af,0xa2d94ca3,0x29591657,0x11d9743d,
	0xf92be579,0xb12716af,0x9d493141,0x95ebbe95,0x97818f67,0x2d9717c1,0x87f3b4a3,0x1aa178e9,
	0x30258b91,0x8fd5f1cb,0xe879f419,0xb21b45d5,0x504bd35b,0x08b9bb4d,0x80639c0f,0x842526fb,
	0x880ff773,0x23431c4b,0x7ca1b6b1,0xbf33aa01,0xe377b4c9,0x05958b53,0xbe8bd0f5,0x295b359b,
	0x036fa999,0x5201aa79,0xc4e13f9f,0x5163767f,0xd6c92a67,0xa7fbc45b,0x34cb8431,0x5fb3ec73,
	0xf34536ff,0xc523691d,0x02dbd1fd,0x875f973d,0x8e838f73,0x463d2b6d,0x3c07b31b,0x171fc3ad,
	0x1711e91d,0x08397d83,0x6eb1cd69,0x2a57f8a1,0x6d6343a3,0x292dae17,0xb39fc78d,0xfa1303f5,
	0xbcd75def,0xa9570573,0x57054df9,0xce012797,0xf4af4b35,0xac1d0261,0x217737e3,0x8d7d6675,
	0xe11927ed,0x590db739,0x40f9cc49,0xf08bf189,0xe427eedf,0x5cdd46d7,0xd1f126f5,0x50d3b4d5,
	0x4ed96e13,0x0a6d819f,0x082fbd73,0x1aa90461,0x5a0f5bdf,0x1bc3a27f,0xf7ed041d,0xde05693f,
	0xbf978bdb,0x130b2bed,0xfec93311,0xff8b8e89,0xf32743eb,0x3b9de4e7,0xcccd2b35,0x09854e5f,
	0xfb59b13d,0x4af9f5ef,0x0d697b3b,0x9ce5dee9,0xeab17d41,0xa1c12615,0xb0758499,0x02471f5d,
	0xf89d82b3,0x2cc537ef,0xd333c08d,0x5ae904ef,0x3a71a297,0xe5fd6697,0x49472521,0x71b927e3,
	0xfc67b939,0xf58702b5,0xc5c5aa21,0x2c497081,0xbaa7b32b,0x72a72f75,0xa425ee27,0x9bd1e41d,
	0xba39c249,0xc4cdbf8d,0x5145fb91,0xae35920d,0x4215b2b5,0xa48d3239,0x546f2d85,0x7effa0b3,
	0x74155fdb,0xbca9d03f,0xf85134f5,0x48617a79,0xc5fd496d,0xeb05e8ed,0x94073d97,0xf4351acf,
	0x1a7b4869,0x21ad2f19,0x740f32e9,0x4cff7b31,0x7a236411,0xe7dd361d,0x63512535,0xcee7201d,
	0x6c71c6ef,0x7aef0edf,0xd41fce87,0x18bfc61f,0xf0c7d3d9,0x8f6904cf,0xa92f37b9,0xfd032ec7,
	0x17755ae7,0xb1fb7ae1,0x9ea37d69,0x32d50dad,0x3aadee7d,0x487be891,0x5301b4fd,0xa6ff1573,
	0xd78b5849,0x32e7f6e5,0xf03df1a7,0x6cf324c5,0x07152e3b,0x0c65bd6b,0x74ab695d,0x4fcb9351,
	0x9735878f,0x0c451f37,0x9c0fb9df,0x034b9ecf,0xc3c1d1cb,0x86f947e7,0x688d4db1,0xf4dbf805,
	0x8f75c5b5,0x0f25489f,0x4bbbe127,0xbc8d6fb9,0xbcf37c65,0x368bd50f,0xef8b2753,0x2e1dc3bd,
	0x67cba435,0xef192069,0x9f638f19,0x09ed8beb,0x3d6fd5c7,0x8be9da6d,0x5107281f,0x4e074721,
	0x563d0907,0x62354c5f,0x4da9a7d3,0x271d884d,0xae752a29,0x0a67960b,0x7ae18e6d,0x8189435d,
	0x3f49cea7,0x41090ac9,0x43af6beb,0x3a4d3a4b,0xb7c90a45,0x67d5ae75,0x217d4517,0xf0158a19,
	0xd5f3640d,0xa6a9d273,0xc519187d,0x743157cf,0x5fabeb53,0xac89d2b3,0xdfbb8377,0xdb9d9d81,
	0xbbbd6cb5,0x10a5f2a7,0x8c058723,0x2ffb1743,0x2addc711,0x53535a4d,0x56ff6d69,0xc093503b,
	0xa0a76097,0x7f11332d,0xe919cdf7,0x135bcf91,0x3ca1bbb7,0x6985e551,0x4f29b345,0x75eb6577,
	0x63372c2f,0x947d7451,0xe373df91,0x2e859823,0x76bbabff,0xaef1fc47,0xd69f31e5,0x4d1530d9,
	0x306bd075,0xb5fd4edb,0x58b92b0d,0x1c2be8e3,0x996bdf23,0xb5e7b03b,0x623d92a3,0x3203368f,
	0xa3c702e5,0x2b21b419,0x1d0b3c05,0x217f3a39,0x6375a0dd,0x033d3ab3,0xed69eb5b,0xcb27cb43,
	0xe74dcd77,0x3dfb8dcf,0x1b0b5a93,0x4e31a513,0xb219e167,0x2e439dbb,0x1a055e65,0x9975b41b,
	0xd37f2ea7,0x5b1f5e4d,0x73db2b4f,0x9c7582d7,0xa119d579,0x00c943df,0x5071ba9b,0x185bc6c7,
	0x0f5fb96d,0x319de059,0x9f1d4f55,0x10fb0d73,0xaab79651,0x9725a027,0xdf911b57,0xddcf896b,
	0x306d3545,0xd309a73f,0x8af3043f,0xdaf9ff4d,0xc7b7c1a7,0x8025ce1d,0x1cc78875,0xba41d2b5,
	0xdaaf3e27,0xd375bec7,0xbbffc427,0x741d3351,0x8f5919b5,0xdd1d31cb,0x83f3964d,0xd8a569cf,
	0xe0a3e48f,0x696f4b3d,0x6d63e5a7,0xc09b44e9,0x575f2535,0x81e117bb,0xd77905b9,0xde69a65f,
	0x634d4d75,0x8e0f296b,0xb0c33bd7,0x2f232ffd,0x540dcf61,0x14bf54f7,0x40396415,0x0b831095,
	0xf22f5255,0x1ce18e99,0x8e3db653,0xd8e9f0fb,0xb82307f3,0x2e8be70b,0x6d97ab39,0x5a630115,
	0xab492127,0xf3fba893,0x24750135,0xa19f24cb,0xd4e56325,0x7a9993fd,0xb573e17f,0x9ffb410d,
	0x5b21dc67,0x13ef3da1,0xc88f2515,0x5777a8d5,0x3a11b9b1,0xd6b78a5b,0x3431b9c1,0xabbdaa25,
	0x9cb53b0f,0xbfcd4c91,0x262b2711,0xd3213b07,0xd5edc8d1,0x7339012d,0xecb3335b,0x679dc689,
	0xf9892897,0x9d27aca7,0x5f69a8bf,0x17d119c7,0x153bd23f,0xf2f1d7fd,0xe8593a23,0xf80970e1,
	0x099f64f9,0xd411adb3,0x2cef883b,0x7339a401,0x033b3c35,0x8b3136d5,0x57074679,0xdbf77459,
	0x937924b1,0x2f1db7fb,0xfddd801d,0x9d89f91f,0x69af316d,0x23cb2e41,0xaf1dfd31,0x0cd72c99,
	0xac17b0b7,0x3b5bec4b,0x17d5c783,0xd975990b,0xf0d94123,0x77115747,0xcd7fcfa9,0x1e9d25cb,
	0xd6ff0687,0x685dc3eb,0xb6f9b203,0x142f042f,0x3f7dff0d,0x31d57375,0x158d9bb7,0x5fb7bc99,
	0x262f781b,0x2837b0a7,0x2deb4fb9,0x05695b75,0x1adba367,0x13690cd1,0x912b4bbb,0xf91bbe31,
	0x5a2b4beb,0x0f79bcc9,0x05cd0d3d,0x4f530045,0x86b5aaeb,0x0d9d15e9,0x10bb7689,0x0e390837,
	0x01f55cf3,0xf5352b19,0x1e4353ad,0x9ea1348d,0xe54f76d3,0x64c789c5,0x4b1dff7f,0xdd0328d9,
	0x9b0fbaab,0x12ff16e3,0xcd6b289f,0xca83bab3,0x1769ecd9,0xcfb70bef,0xfdb5b675,0xddebfebf,
	0xb179490d,0x24e913f1,0xffe9ce2f,0xf4af75a5,0x9c451739,0x97bd8873,0x0c63f7c5,0xe3e55915,
	0xffb96095,0x8983ce8b,0x58e162f7,0xa95308c9,0xb1a7c4a9,0xb8afd3d7,0xa18b4c49,0x3c619783,
	0x8ecd6e3d,0x61dfab7d,0x51f1820f,0xff21780b,0x73cf2865,0x00dd4b29,0x4e0d095d,0xcf514a33,
	0xd639937d,0xb191680f,0x5b3fe313,0xb74fc7d5,0xfd7f7a27,0x311773f1,0x294ff0d9,0x3f27d1d1,
	0xdbff4651,0x7eabba0f,0xfb6bfa1d,0x5d8b9d11,0x87fb962b,0x1cb39c37,0xf12dd119,0x08d5ff85,
	0x549ff131,0xf1bdefc1,0xef9797c7,0x6809dd27,0x8b039d27,0xc97f7a89,0x2a0d24f3,0xa3cfb4fb,
	0xc31f9317,0x75d98ff5,0x4b65892b,0x57794e05,0xdcd99457,0x8fcfcdf1,0x3ed1b3c5,0xa203845b,
	0x98fd5f81,0xd893f9f1,0x98f737e1,0xd70f3613,0xd2410575,0x3a77fdf5,0xa0db3167,0xcfe7504f,
	0x563f5e63,0x69fb0581,0xf8ef4a05,0xdc7dfc39,0x5e7b9ebd,0x26c5baa1,0xe80bde33,0x546dec03,
	0xa9630c3b,0x1ca3a2ed,0x426f4231,0xc7f5c7e3,0x3349d2e5,0x648d9c81,0xf2c32705,0xd103bb1f,
	0x8f6bfa03,0xa59f7b01,0x23191f7f,0x842720fd,0xe0ef7929,0xd621c49d,0x05e74535,0x819f51cd,
	0x73dd6d33,0x9c818f07,0x3f0ffd87,0xa6478fed,0xf62d6d45,0x50537c7d,0xecd9de9d,0x5caf14b9,
	0x50b9ffc7,0x9b59d8c7,0x50f5b465,0x8e073d9f,0x20452f6f,0xba77d62f,0x1979a599,0x3329d90d,
	0xce7f4037,0x5eb9ea8d,0x49e978b3,0x8599937d,0x4afb8465,0x2e5b4c3d,0xc42bf8ff,0xd07d846f,
	0x6433517f,0xe5b58f23,0x71917b8b,0xe1addb6f,0xc08f155d,0x185361ad,0x0bcf842d,0x1a9fad0d,
	0x77578b19,0x91df69d1,0x860b8a85,0x2177dfe3,0x49c31013,0x572f420b,0x15c9defb,0x31fd3991,
	0x7bed18fb,0x47459663,0xdbfdafbf,0x0ea78bc1,0x4dd9c6c3,0x5c456163,0x2dfb2dc5,0x918d0123,
	0x14759ba5,0x8c7f4921,0x7e87d1cf,0xdd738a71,0xf2955023,0x4b651c3b,0xe6c5c163,0x2ebf6b6d,
	0x31f5c80d,0xaa996ed7,0x4f4953cf,0x4c89e7df,0x3c392771,0x1ae157a1,0x390bb72f,0x9985109b,
	0x33eb07ad,0xcd2b4ccf,0x2669b55d,0xc51bb077,0x2d83cc63,0xb38b211d,0xa42d9903,0x1c535955,
	0x085b1881,0x224120d3,0xf287328f,0x7adf911f,0xe7b96337,0x10b54eb9,0x4e0ffd39,0xdc171ec5,
	0x4bc7ad01,0xfa71c12b,0xd8c56401,0x8c037743,0xca9b54a3,0x602f1f01,0x231326ad,0xf8474a97,
	0x69310c29,0xe8cd3ca1,0x54c5decd,0x213930cd,0x946dede5,0x224fd8fb,0xf619a4b7,0xaad376f3,
	0xba1bb173,0xe2e57a83,0x58abd48d,0x8db70c25,0x81ef00b3,0x49e36c35,0xa083f333,0x682f8e85,
	0xa685ecd5,0x60cbda97,0x6d15b359,0x6f2b7839,0x6e63834b,0x5c4110b5,0x22371a77,0xff496c75,
	0xc4f382cf,0x7d13d527,0xd127c5cd,0xcdc9a471,0xf38d3065,0x9137e709,0xc1914f61,0xb9977c6d,
	0xfa694c57,0x14cd9aff,0x9a85d303,0x3c4320b5,0x89ab2739,0xf31b9839,0x2b799349,0x7b075a99,
	0x9a63d6e7,0xe78db569,0xd54dbe95,0xf7c97d71,0xa7858b85,0x7ebbf5cf,0x934d540b,0xe20f73a1,
	0x86e9047b,0xb763a62f,0xa425289b,0x080feb91,0xe2572581,0x436d99d5,0xd2ef0bfd,0x67a1a4b1,
	0x507bab8d,0x68e38799,0x602d0db1,0x5f47dc7b,0x0de701e5,0x82ff86d7,0x8ac3e1fd,0x7f2bdb71,
	0x56193715,0x231dac73,0xb90566f1,0xfa21a21b,0x5c7511ef,0xd1c5c7db,0x41ab4965,0xb6a3b60b,
	0xe547468f,0x6fa54005,0xd4d3c9f5,0xffd10edb,0x7ec5cb57,0x3691106f,0x8507a20b,0xd679232b,
	0x5a074df3,0x5a8be61d,0x703708d5,0xe20915a3,0xc417c855,0x4ab55c9b,0x08bbd84d,0x019f01f9,
	0x3edb35bb,0x92615aff,0xfe53d22f,0x7cf969e1,0x3a2d67a7,0x5a0590e9,0xc7290503,0xd587c21f,
	0x6cc5fae3,0x883b137b,0xc8c95119,0x37571f7d,0xcd496c85,0x82cf1a63,0x21310d87,0x8a2303c9,
	0x2b474ee5,0x8fabdcd7,0x0fbbcd2d,0x22514adf,0x682f9ea7,0xd5e78e93,0xfe3543b5,0x11e7379f,
	0x506137b9,0xfebf7cdd,0x29cd4a89,0x1999a0f5,0x141f6a4b,0x769f4b83,0xec1905e3,0x39c33ecd,
	0x6097afdb,0x4e0f51db,0xa41d29c3,0xe3651725,0x18dd8029,0xbac717bf,0x3f3f5eef,0xc9290afb,
	0xaeeb4643,0x38a9f297,0x624fc7f7,0x5063835b,0x1ca9757b,0x4ab5c24f,0x3287a633,0xa20b3e55,
	0x7cdfbe6b,0xdc1fce5b,0xbe871ebf,0x5bc53c01,0x444563fb,0x4139c2bb,0x07551f85,0xe0ddcb83,
	0x1a75b051,0xd883ccf3,0xa9636435,0x4b41b801,0x52f389e1,0x4ba5d911,0x258b9b43,0xfc8d95af,
	0x062d2869,0x706beea9,0xca09aaf1,0xcf052ec5,0xca77e9eb,0xc9cbadd9,0x3b891645,0xe6911083,
	0x0d0d47b3,0xa8e3ec47,0x9e19820f,0x21c53835,0x0b11eb51,0xedfb721f,0x5e3159e7,0x2ad9e02b,
	0x6a93e3a3,0x6981d715,0x99b59529,0x28b16cbf,0x7385f9cd,0xdd0b7f69,0x28e79bff,0x0fd77951,
	0xe8c32639,0x9c57b8df,0x477d4c59,0x937f054b,0x81112599,0xce4bf7c3,0xdd8d1eeb,0xb67fc11d,
	0x001f2de9,0x4df533ed,0x68976c37,0xfc5d7b41,0xef7dc36f,0x2b8b65b9,0x8485d185,0x3a41ad39,
	0xf7a7adb3,0xcd6d230b,0x14a3b5e1,0x07fd288d,0xd9050c89,0xb1215c53,0x0cafef23,0xd10fe3cf,
	0x04e18d0b,0xcc533983,0xd9c386eb,0x8595e799,0xd66fbea1,0x8ddb171b,0x6b6d9fa3,0xeb5b5b8b,
	0x6bcb87f1,0x7eb7a31d,0xdc9b7975,0x8ed3b34f,0x1efbbbf1,0x830d1a1b,0xbca3975d,0x5417fb97,
	0x9ee9cedb,0xbb2da425,0xf8490417,0xa7e94719,0xa86bab33,0x048bd1dd,0x62b3b72b,0x50b53b9b,
	0x5f3da6c3,0x1ac53965,0xde7119e9,0xdf8dbee1,0x470397a1,0x58a3336b,0x267dac67,0xc129c3c1,
	0xdc490925,0x1913b825,0x3737ca87,0xeeed3711,0xcd8390f5,0xb8295c51,0x576590ed,0x3fe30cb3,
	0xd40f43f9,0x34276e31,0xc139e20b,0x59bd6c93,0x2d2f4b69,0x6e713295,0xeb4b8b15,0x41d5ff9d,
	0xb30f99bb,0x0c9341d3,0x719d890d,0x8e2f5ccf,0x95c5bfb7,0xf94904c5,0x9e936dbb,0x36719629,
	0xb44de165,0x856b51d3,0x9401e4ab,0x04f3e5b1,0x958bcb19,0x290529e9,0x141f5835,0xa7ab7a7d,
	0x014b266d,0xe441957d,0xea8bb67b,0x613d65a5,0x3943cf49,0x4077a18b,0xf54f5661,0x59f3a747,
	0xd20b48d3,0xf1257c99,0xcddbfc99,0x90bf5b91,0x2c2b5281,0x14f1b3b5,0x12070097,0x6c3b07b1,
	0x8d0f9d0d,0x16a98f73,0x4d13919d,0xeba906e1,0xd8099f7b,0x2e4590f3,0x80a71bb1,0x77f51763,
	0xe7598c15,0x81e10ed5,0x4dd5cca5,0x54af077f,0x851f6571,0xe6c5f24b,0xbe13390b,0xb1138287,
	0x04693367,0x425d9409,0xac432147,0x5903fdd5,0x7a2d581d,0x8b43b94b,0xcdab567d,0x0609c5c9,
	0x964304fd,0x6a31b0d7,0x5affbf9f,0x50552acb,0x1c75cfb9,0x7b118ff9,0x59537e61,0x3fc5ce51,
	0xfd69674f,0x2ded8f89,0x832b3445,0x7cdb0fcf,0x0fb968ff,0x47ff88e3,0xd16d6793,0x21bd99c9,
	0x68dd5557,0x04a592ed,0xa4690857,0x2b410ec9,0x563da52b,0xd663bf11,0x8cd91569,0x89e1d65d,
	0xf621fe91,0xc7e9f649,0xb4dd616b,0xd2bf0a21,0x70c189f3,0x7d0df60d,0xe8fb77c1,0x90a582b5,
	0xd13766f7,0xd3cd6d67,0x4125a19d,0x350304c3,0x7e874193,0x254d39e3,0x69b30af5,0xa8f78dfd,
	0x549f0701,0x26e1c495,0x8c670787,0x7e41c21b,0x5d53bac5,0x6af97f19,0xd96577db,0xc04d77dd,
	0x295d6bab,0x82378097,0xb0414e41,0x652b660f,0xc96548c3,0xbc6142bd,0x68f333d1,0x5e97f07f,
	0x66f3d66d,0x89637ebd,0xbcd94d69,0x4af3150b,0x7d7f4349,0x7a552a55,0xcfbd20af,0xc647788f,
	0xb363dd41,0xe27594cd,0xd8cd9915,0x5b4993f7,0x52e5a68d,0x182ba3ef,0x6ba52ccf,0x144f0135,
	0x632f0aa5,0x56013113,0x614321df,0xac5fe841,0x6157b34b,0x3bb18613,0x6111f30d,0x60238c1d,
	0x99577d8d,0xef17fa57,0x09dbd4e5,0x5eebf7d1,0x1f178ebd,0xdd3bafcd,0xbadd5ac1,0xdbb3cb6f,
	0x67618977,0x1b4b6fe5,0xfcb73bbd,0xbe1b290f,0x80e9e29f,0x679da8a3,0x8a7137c5,0xf371c1d5,
	0xed4b565d,0xcaad8987,0xfa791c83,0x5fa302e9,0x1a0d7d27,0xd82540a1,0x07abea73,0x6e4f627b,
	0x799980b7,0x8fd15787,0x7a4319d1,0x43b5ccc5,0x3c45f111,0xdea73053,0xb0edffa7,0x8dbf3109,
	0xa94db981,0xbfc7a2ad,0xc9b952c1,0xf5012e8f,0x17d53599,0xfd75b8c1,0x6b1bd0b9,0x2db5e1ab,
	0x87e76633,0x92218c43,0x2cf902eb,0xa8bbd0b1,0xdb7d4675,0xa9614373,0xa1972383,0xe4a1f907,
	0xaf6d40c9,0x40f32e17,0xfea7226b,0x5e95fc15,0xd47fc3e3,0x69bf0277,0x6641ca5f,0x23756c4d,
	0x685df7bb,0x28cf3a6d,0xcfe705db,0x00bf3a25,0x8e9d9299,0xf85d9055,0x917d4429,0x55a34121,
	0xc9bbce05,0xe8c59c15,0x8857fe55,0x83eff4cb,0xf41b7bd3,0x618f9019,0xe22d5c39,0x011d2db3,
	0xd9093b1f,0x82671655,0x861df973,0x07511671,0x6dbbcd4d,0x24274d49,0x1db1ca69,0xe65738a7,
	0xaa498b05,0x79c9e4f9,0xbdd7214d,0xf49da9ff,0x02bbf93d,0x51755bf3,0x2febd313,0x2041592b,
	0x7ffd7e31,0xf57b5c4b,0xdaab7c7f,0x20017ae3,0x78e13661,0xad4f389d,0x4b3fe713,0x444d16e7,
	0xeb25e999,0xde918913,0x5e398e23,0xe831b503,0x746d1fef,0xce05e855,0x088f43c1,0x826d2a07,
	0xeb4756bd,0x009bd09d,0xc0a3f5d1,0x565f84cb,0x982355a5,0x3c6998a3,0x873b92f9,0xc5131b33,
	0x0e61a393,0x29ad90b1,0x908b0fa5,0x3e3bb725,0xa5431bb9,0x93cd3f91,0x8d278b11,0xd133e395,
	0x90f7a295,0x4a57bf9b,0x93139439,0x5df9597b,0x9b8ffae9,0xa2013bab,0xa6b58ee7,0x663d8cd9,
	0x7e0bbabf,0x95ab8c25,0xe3dd38a7,0x7e4b59b7,0xd94b606b,0x875bf3f7,0x46c54dd3,0x5e23d127,
	0xcf1d8789,0xa13dfd97,0x150b4e89,0x92632643,0x3b373dfd,0xd6a97803,0xe6bb63af,0xcd57bb2b,
	0x8c3378ef,0x851f93bd,0x4f4163f7,0xd7f14e09,0x3c95a9d5,0xb5411fd5,0x2677f8d7,0x22cb460d,
	0xebcb736b,0xfbdfe6e1,0x719de38d,0xf7292071,0x17277eb1,0xfaf12bfb,0xec5d6223,0x47f3fd77,
	0x72e96ff5,0x829547cb,0x31c3b465,0x22bb4d69,0xe331fbc9,0x520f657d,0x854dc0ed,0xc0bf9d95,
	0x150f1c07,0x78cf5fc7,0x3bd7da19,0x37dd8557,0xb77564d5,0x5769bde5,0xc4aba30f,0xcba1b30f,
	0x543f799d,0x409fd09d,0x527914c1,0xde3d1927,0xc931a213,0xba55ef3d,0x2457a2e5,0x818b3b11,
	0x60f97f31,0x5e99d49b,0x6ec980f9,0xa80d9a43,0x8c2be03b,0x5ca11c11,0xe4b50747,0xf5ef4343,
	0x3a43b7bb,0x99cdde85,0xe06d37db,0x32037a95,0xd2a33085,0x72a16f67,0x2ca7638f,0x56c189cf,
	0xcd9be2b5,0x1bcd39ab,0x6d85ef01,0x434dac87,0xed5d28af,0xa327bccd,0x298d3799,0x0c711d61,
	0x1705941b,0x90ada9d3,0x72b39885,0xed9f4303,0xcb9782f1,0x2785204b,0x2f4b8fbb,0xd9f1fd21,
	0x4103d467,0x46ff0b49,0x031902ff,0xad291173,0x1b19be03,0xeb8f9e6b,0xd843a4d3,0xfcb3b8b9,
	0xc495c091,0x4fd3f2d5,0x0859798b,0x889f4bbf,0x681fbd23,0xad93c437,0x25557c3b,0x4cab1055,
	0x89412a15,0x9ebb4dc3,0x629563c3,0x31332655,0x3d6f6809,0x1e654739,0x9de387c9,0x5c47949f,
	0x050536eb,0x29cb01dd,0x086fe5bf,0x2297761b,0x44494aef,0x0157a57b,0x6fd145db,0x987d46bd,
	0x5c67018d,0x09938d6b,0x270b801b,0xc2fb507f,0x6471368d,0x4c39c589,0x8f81e149,0x68bd385d,
	0x826538f9,0x9927a739,0x4207aff1,0x8313ab67,0xe425e021,0x47619669,0xd7d3d16d,0x4ef92ba9,
	0x5881c0a3,0x9617de91,0x53878edb,0xfe11fd3f,0x882d8163,0xad9fafa9,0x2a2b7a23,0x07a53349,
	0xcec1508b,0x40773b3b,0xec2f72f3,0x19a7dcf1,0xb3c5788d,0xcc45f151,0x8e6bcbc3,0xa9b15267,
	0x03a51525,0x7ad7dd83,0x531f8ed1,0x2605a1e5,0x88b3e859,0xa32523eb,0x52f3e327,0xc68d1caf,
	0x642d4f6f,0xea4b9e31,0xa5f79191,0xfddf0409,0x073757ff,0x048f9881,0x2ca5a9a9,0x8a2f5649,
	0xcbddf4e3,0x1663ae91,0xf8dd46cd,0x2665bbc5,0x2e15533d,0xb559c89f,0x56e77525,0xdb0993df,
	0xa4b74f79,0x8931386d,0x7671369f,0xef4b2201,0x1a8b0a4b,0x8cd3f64b,0xb395a7f3,0x7a09da9d,
	0x073d9dad,0xef49fe0f,0x7fd5459f,0x92c3d02b,0x285ff1e3,0x94cdcc13,0xeb1750ed,0x22a5402b,
	0xda71b277,0x37bdfa3f,0xccab54eb,0x557f4029,0x11d3633f,0x299dfcff,0x8c4bcb6f,0xaacd8ab5,
	0xf3d39553,0xb41b0047,0x8b15e219,0xa6af6c67,0x0fa73c19,0x1a11e499,0x2c935f4f,0x22f3d0e3,
	0x3767223b,0x387b5bf5,0x7fb5a743,0x40076fcf,0xf91d7eab,0xc77d26eb,0x87d3e0eb,0xf60919df,
	0xb7b1a9a5,0x3b69718f,0x25ad3b07,0x45b925cb,0x63f7f1af,0x45b5507f,0xa06d511d,0x0983fd55,
	0xd5af9091,0xf5fd5ddf,0xcea1b07b,0x6677ca45,0xc479c05f,0x7b07765f,0xdf417d3b,0xdd4f436d,
	0x60e3f075,0x83c39633,0xc2af373b,0xfb7199a7,0x8d631a75,0x4047d617,0x33b39f23,0xabe384d1,
	0xb753374b,0x02d18851,0x607dbb61,0x285b70d9,0x4ff7d42b,0x80c975ad,0x33a3fd2d,0x8a2fcaad,
	0xe57dc78f,0xb3b93a83,0x3d298585,0xfb656d49,0xdbf9063b,0x5a5bc3af,0x3b758a33,0x87a72eab,
	0xc6679839,0x198beb95,0x4459dac5,0x8d458cdd,0x5fa9addf,0x3d513725,0x8e0b8591,0xce397af1,
	0x238fd4c5,0x19d9b2d1,0xd82d9cb7,0x21294e01,0x87cb4cd1,0x0c7def99,0x74c51b1f,0xc25bca2f,
	0xd4f97d2d,0x1cb72001,0xf145e977,0x44c34fa1,0x9f9d894b,0x3d315515,0x5f870337,0x22fd2789,
	0xe12705e9,0x2cb7db6d,0x3ec7bb9d,0xf049f123,0xb0e5ce07,0xf73fb825,0x04b122b3,0x29912ead,
	0x9d19f7f3,0x16e945e1,0x46538a47,0xa669f273,0xa3e5ea3f,0x34f9f1cf,0x81272aef,0xaa09abc3,
	0xcc5590c7,0x8adf18a5,0x840be90b,0x945713f9,0x5f5bb1ad,0xe33103a1,0x784939c3,0x32d93b77,
	0xc0d9625f,0x3aad0585,0x8a912805,0xb1c3b6a3,0xe88f9c8d,0x0139b7a1,0x33fb7989,0x2cf1eaf1,
	0x7b29f333,0xfae356cb,0x2309f3cd,0xe0e17bd9,0x833d6795,0xc0e1405d,0xc49fc11b,0xfbc1d7db,
	0xca475e3d,0xe2938f3f,0x6d11f581,0x0e63e583,0xd1abb401,0xa67fd8dd,0x211533d5,0x1d41d061,
	0x6bb3f2f9,0x6b510a2d,0xfecd72b7,0x517bf60f,0xf499a78b,0xa8e364ab,0x46c1e18f,0x49ddf32b,
	0x2b73d561,0x912f9b5f,0x04e1ed8b,0x0bd9d063,0xab498c6d,0x515d0fd3,0x598366a3,0x94894f65,
	0x04059ded,0xf2bd2f1d,0x626bc497,0x09b157eb,0x737f7161,0xdbc3eedb,0xc3bf8bed,0x8ab984b7,
	0x3e6ff997,0xf10d6a33,0xd111d2f3,0xa1b5d091,0xa97bc9a3,0x56659ed1,0x5657e6c3,0x545d634d,
	0x922f49dd,0xcfb349e9,0x00f1103d,0xd5157ebf,0xa7ff0ce9,0xc213e53b,0x68ab7903,0xd3e78bcd,
	0x454944b3,0xd4c1c40d,0xb8b1308b,0x6f85475f,0xe84f576f,0x32235027,0xf89d5107,0xc64b0f65,
	0x4c3d9497,0x68c766e3,0xf5714477,0x27374fdb,0x222b09ef,0xec63d61d,0xca9329a5,0xe2f70fbf,
	0x6a117883,0x36d7f93b,0x0ad3591f,0xbcdd9e1d,0x6bd569a5,0x89277627,0x89690a3b,0xfbe15f03,
	0x504363ef,0x4c851a5b,0xc2f91819,0x1ba7b88d,0x5a114047,0x1343d7d1,0xe687e6a1,0x1d791fdb,
	0xbed79ed7,0x39e1e20f,0x7e856781,0x79494619,0x201f7c11,0x2805eb21,0xb9cb3f33,0xaeb16573,
	0xa44fe5b3,0x317d809f,0x549909f1,0x75f5ae27,0xafc1cfbf,0x174188a5,0x2197c0c7,0x90fdd373,
	0x3dad097f,0x286dded7,0x32d73e83,0x3c5bb8a3,0xd9395287,0x03491163,0xa2d1e4bb,0x404b3e07,
	0x36738fb3,0xf6433e01,0xfd6160cf,0xa1af2df7,0x6b4b2025,0x00ef0ee9,0x48d590e7,0xf31149d7,
	0xc8a1524b,0x750fd7e5,0xaedb88f3,0x45a3770d,0x5339f8d5,0x3787d33f,0xc589b7a7,0xba3f0c0d,
	0xdcbd1fbf,0xa1637ecf,0x78632b83,0xb2673d4f,0xbcc1e14d,0x00df18ef,0x914ff7d1,0xa147aa55,
	0x29c55b0b,0xba533d87,0xe19fb99f,0x7caf0aa7,0x3229c2cb,0x094ba305,0x0b093cc3,0xce1bfad7,
	0x553d9ba7,0x6171f75b,0xe8ad40df,0x63ade97d,0xbc330b05,0x6f9ddd07,0x98175e57,0xa12f243d,
	0x13274d8f,0xbacb0811,0x22330b5b,0x711304bf,0x021d4c39,0xe5257b03,0xc45bc0e3,0xd5733db3,
	0x4603513b,0x8cf9e3f3,0xd9513faf,0x191147d3,0x69addd1d,0xcdb9197f,0x623bf545,0xa059eee1,
	0x1ed79ba7,0x6107b7cd,0x2fa980f5,0x5a5bfea7,0x372378ef,0x5fa9dd89,0xaa9358d5,0xd1d30ff3,
	0x3d21d64d,0xa28d08e9,0x3d5d8ec5,0xde2375a1,0xad43df65,0xc3c714a9,0x5ccbb56d,0xf4534991,
	0xcee5ff23,0xbf97550f,0x310fe53b,0x181999ad,0x2d4d74bd,0x3565d4e9,0xdebfe169,0x6ccdb4e7,
	0xb0a508a9,0x48bbb28b,0x6fe15cf1,0x66719835,0x5703e1ad,0x22539cd5,0x5cd75f9f,0x9ab17b9b,
	0x8d6379d5,0x110b7027,0xb575cb01,0x31dd7f23,0x28a9b373,0x4ae7f373,0xe9f1ff6f,0xf7f177dd,
	0xfea10e21,0x4e17b52d,0x33eda105,0x0d8ddce1,0x1efffbc5,0xe1ef084f,0x9f717cad,0x38ffd451,
	0xac5f5589,0xb7f12163,0xb3eb8d15,0xd7376057,0x5547f0e1,0xacc15375,0xbd371fb5,0x6ccdac25,
	0x6d215487,0xa92d6d19,0xb49319cd,0xd70978f3,0xa5438d7d,0x232b356d,0xc9a75d63,0x1ccfab03,
	0x65e92413,0x3edb0915,0x8b834e47,0xdfb5f69b,0xc73730d7,0x8f839741,0xb1a17711,0x6cf5ad11,
	0x2a3991a7,0x788fbea3,0x84e14e1d,0x6e6fa9bd,0x71e33ea7,0x2e978a7b,0xe8891a95,0x3bb15efd,
	0xdc13bf3f,0x58594f8d,0x034bf967,0xcae9033f,0x7a8bbf25,0x4fbde925,0x8841024d,0x41f5ddf1,
	0x4bf9c355,0x02cd161b,0x9fe78cc1,0x2755b48d,0xf4efff0f,0x74c3f5cb,0x71299511,0x33355795,
	0x18eb48e1,0xdefba519,0x4a554145,0xc0654f91,0x53512f9d,0x71fdfb73,0x6a23863b,0xdd5faa13,
	0xd06d2f5d,0xb67767cf,0x68b7ec8d,0xfd49e6b5,0x86750687,0x8e3dedab,0x409575a5,0x48e90417,
	0x0e812ac5,0xd5514209,0xf7ada0b3,0x8fb5ace3,0x1d995e0b,0xa2d5087b,0xe85b8fab,0xd8c384c9,
	0x9da96393,0x2a1b3011,0xaa5d4c4f,0x93d99585,0x6685d4e1,0x3b99706d,0x9bdd2d25,0x6a5fdbd5,
	0x96e716bf,0x65e9e6b1,0x0a695a7d,0xb069f483,0x8d756e41,0xb6d7d28b,0xfbf9736d,0x75b1e963,
	0x81bb35c5,0x1c4d7331,0x97ef52d7,0x36971e4b,0xbd2f31e9,0x6563045f,0x3011f45f,0x2d275e1d,
	0x742b069d,0xe357db5b,0xe9937975,0x421507c3,0x3ef3cc11,0xaa8fa3f3,0x060b4e53,0x9db75b2f,
	0x32b5c3c1,0x7399bd7d,0xcc776ef3,0xd913e657,0x9a852d73,0x1c2bb7d3,0x1243cc23,0xced11241,
	0x505d3c2d,0xc827f05d,0x643fd06d,0x0c45cff1,0xb6232b47,0xa28d4f05,0xcfa10529,0xe269657d,
	0x4ea5735b,0x3e912345,0x4b09d777,0x16dd5afb,0xf6951f4b,0x98852117,0xbf817d41,0x34ed878f,
	0xbd8f4143,0xb6e97e01,0xb17bfa31,0x7e8b3e5f,0x5f1787b7,0xeb652e11,0x89cb44c1,0x7d539b9f,
	0x5b9bf261,0xb3c540db,0x7eb38b31,0x3383f187,0xb16fa745,0x3aff5e7d,0x1cdd9889,0xed0b5559,
	0x35cde7ad,0x7a31649d,0x70575993,0xb0774c5d,0x8ddd252f,0xf9a32365,0xcd9b81ed,0x500798e5,
	0xc7a936a3,0x31c33a8f,0x3a8750f1,0x1a992749,0x9323ad2f,0x8c271655,0x776576cb,0x2cb91aed,
	0x1b2d493b,0x048d0c7d,0xa7e51965,0x6199fb39,0x7e858f7f,0x69db9953,0x9c1ff979,0xe413009d,
	0xe8db7df1,0x3f1fbcaf,0xb993b787,0x5fab8193,0x4bc360d7,0x3c8f76ed,0x842938d7,0xd1897f9d,
	0xb7b9c7bd,0x708b65f1,0xc7332c75,0xf9815445,0x55219a75,0x0099822b,0x5e67b039,0x6b0b7e19,
	0xfd474e1b,0x8a65fb8d,0x9ee715c5,0x3e4b8db5,0x735f3a11,0x24c73697,0x6039c77d,0x610b32b9,
	0x3d850d03,0x00bde94b,0xa5514d91,0x87bd68cf,0x1dbf61e5,0xaa6d583b,0xe58372fb,0xbe7bc4a7,
	0x2af774f1,0xea27b377,0xf5938a77,0x9a09e0fd,0x8a03f8ab,0x455f93a1,0x90a7d38d,0x08cfeb8f,
	0xc69f0adf,0x1fb396db,0x814fff8d,0xc3df5229,0xcc6f499d,0x7beb1dd3,0x6a85d68f,0x5ff78f99,
	0x7fff0843,0x5cf528bf,0x30a9fc6f,0xfe7518bb,0xf7c3a475,0xc6e5545d,0x0281d5d7,0x9e656971,
	0x5517fb1d,0x5ffdf6ef,0x023f8d37,0x0d7731a1,0x3d41fd6d,0xb1a15d45,0x8e7d37c3,0x790ba23f,
	0xf26d65e3,0x095d27b5,0x2b371a7d,0x9f1dda41,0x0cad8d3f,0xf9edc719,0x0ad90f2d,0x9f5b73ad,
	0xd2ff5f8f,0x7c2919d9,0x3731095f,0x6c153089,0x34477125,0xb01d28e1,0x5a77bb6b,0xdb47c7e7,
	0x6051339d,0x3df304a7,0x284d5b73,0x5793d2df,0x00d14ad9,0x5703c227,0x66bb885b,0x3143d995,
	0x12650207,0x56cb97e7,0x97314ed5,0x8f49802f,0x5d8fe095,0x03f11af5,0x3f874e55,0x003fd3e1,
	0x8fbd5f43,0x71439be5,0xd2fdfe1d,0xab67b7e3,0xf441bd13,0x7eb9a3d5,0x3b3b1235,0x21ad7277,
	0xcd59f451,0xfa6f916b,0x01530069,0xcea359e5,0x4d2bcf8f,0x61ad55d3,0x16bba551,0x0981a17f,
	0x2ebf1ea7,0x41df51c3,0x3e55094f,0xc629469f,0xef0b0bbf,0x399f5277,0x15694587,0xe6291da5,
	0xa5ed903f,0x99a7aeb5,0xbca588eb,0x29b1fefb,0x7f2709df,0xa5e183c9,0x21253d2f,0xc09b1411,
	0xd367ef95,0x7657128b,0xe5654bd5,0x7b694463,0xe141a6a9,0x78433c57,0xea518325,0x9c47c26f,
	0x262f77a3,0x8f032013,0x78391b2b,0x4805b8bf,0x5797a357,0xd51bd729,0x07d15ac1,0x971f16e5,
	0xfbc797e1,0xfd3b5293,0xab3f5c83,0x46b77e7b,0xa2ef45a3,0x533957c9,0x1707f3db,0x09955023,
	0xc02f944b,0x5d139dd5,0x4b1bb1f9,0x792fd883,0x228bf7c9,0x1bed0a43,0xdbd30ad3,0xa69d9d4d,
	0x0ded2559,0xed1b0e25,0xdaf19a27,0x4ba1ca3d,0xf42be87f,0x0b0d231d,0x6099887d,0x9ba5be11,
	0xcdff1805,0xae65684d,0xb45f1025,0xb4bfb795,0x1411ab01,0xcee95f65,0x163b2237,0xb0a3a299,
	0x57e9edcb,0x8485c997,0x278b2b91,0x55b904f5,0x7cffd709,0x0851a4a1,0xf419f9d9,0x68090b8b,
	0x91ad7ca5,0x558b47cb,0x9b15c081,0x9a43b747,0x4839a8d3,0x6a9ba0df,0x98173dbd,0x1ec52a17,
	0x0fcd8f0b,0x2a0b9135,0xac1fff91,0xd88f13f5,0xcd7fa115,0xdb956aa7,0x6695c8bf,0x2c4d3fe1,
	0x354983f9,0x4d158c9d,0x4e4915d9,0x714f40e7,0xc313250b,0x93932103,0xaa77c237,0x028f3f17,
	0x53a7eee7,0x6c3df94f,0xebb9ccf5,0xefb3e48b,0x5db71e6f,0x3d698b7f,0xb51d3dff,0x4e016a63,
	0xcae537d1,0xb7930f15,0x850f2b01,0x296fc5c7,0x70af9b7d,0x1665ba21,0xfe6bdc71,0x1593f4eb,
	0x29873b2f,0x01ab1e37,0xd16f1291,0x5eb36c09,0x8dbd6eeb,0x0e5ba577,0x44c36a69,0xdab9a25d,
	0x4c8fe9fd,0xdf952f81,0x5e77e2c5,0x5a35bf37,0x251fcff5,0xe79dce87,0xad05813f,0xb96166e3,
	0x7f7de9b3,0xc8e3a43d,0xb04b1733,0x9123a7bd,0xa59bfa57,0x56fddedf,0xe29326cd,0x88010725,
	0x9c57344d,0x37a9d633,0x618de7f9,0x4331ae85,0x9c73ce47,0x23cf4887,0x37536d6d,0xf789b84d,
	0x2b9bb843,0xc879b7af,0x4361e9ad,0x9a8f9cf9,0xd5657083,0x47e1e609,0xc3a113fb,0xb36bc007,
	0x844df891,0x5a63737b,0x7d65ad69,0xcbf11d01,0x7ab7ea41,0x0f879a71,0x866525cf,0x819b147b,
	0xebefacaf,0x2ef90cdf,0xadbf60cb,0x3689590b,0x3529c93d,0x3993f145,0x84fd9ac3,0x6287fc53,
	0xb6836099,0x0a4fffa7,0x090f6de9,0x84099bff,0x4bffbfb3,0x1755be93,0xeb4df733,0xb125aebb,
	0x668b14c7,0x52f5e01d,0x7a751b5f,0xc8a1f145,0xc4f94459,0xaca3bee1,0x2bb5ebf5,0x42e5f35d,
	0xcd07de35,0x31fffb09,0xc3972c47,0xa305c4c9,0x8459326d,0xcfcd373d,0x1f17f667,0x87b9c25f,
	0x297b865b,0xb2fdf5b5,0x9c958039,0x5c6582f7,0x6ce369a5,0x49a5952f,0x24d90063,0xaa15e46f,
	0x49eb2b35,0xe4036def,0xd411b351,0x087738b5,0x7fd76e3f,0xf57d0ec1,0x42d9003f,0xaee792b7,
	0xaad5df3d,0xf5a199fd,0x6f2dbe2b,0xa569336f,0xfcf708f1,0xe125427f,0x457998d9,0x95a516df,
	0x973b496b,0x5ae9e8ab,0xc98b95db,0x3befa10f,0x8287e6f9,0x6cf3d76f,0xdf9db989,0x783f6b11,
	0x48a34539,0xe96fa141,0xb54fcc01,0xff392ffd,0x2d453a0d,0x6bb51d1d,0xcaa73e29,0xab27d9f7,
	0x070b82a3,0xf945838b,0x9b172eb3,0x6cfbaf27,0xb879586b,0x42c1ab95,0xe6778f15,0xdd519ebd,
	0x48f92621,0x84fb67d3,0x9a07688d,0x6d67adf5,0x9ddf5ccb,0x09e5035f,0x59714125,0x382b850d,
	0xd36b68af,0x49a3dee1,0xa7c3a0a9,0x732f1c4f,0x35bdc665,0xab772d85,0xb075b5b3,0x7fab890f,
	0xd9e537c7,0xe6d1d201,0xb0691aa1,0x9b83eaa3,0xd6d318f7,0x04455b91,0xfee7ba99,0x3241776d,
	0x1e67d561,0xfe9522fb,0xb69fd68d,0xce17a9d7,0xf6657cb9,0x03a5878d,0xfea92a33,0xa8df8d51,
	0x117777f7,0x55834c1b,0xf385310b,0xdd1d2b57,0x48335e63,0xcb651405,0x301b8b59,0x36f91867,
	0xf213ea85,0xf2ab002b,0xf6bb832f,0xa545210d,0xde7f0f33,0xcfd96bff,0xfa1fb165,0x4a7d16d9,
	0xedc12c85,0x3f9fca75,0xc667c299,0x2dc3bd63,0x4a0b64e1,0xf7d3a309,0xca1b5c33,0x8be1d74d,
	0x407f11ef,0x2873aec1,0xff292161,0xc8495343,0xba1b59a5,0xbca5152b,0x33edd81b,0xfe1598f1,
	0x54d1e33f,0x3bb9c95b,0xf423ae1f,0x3109f615,0x1c6fac3d,0x4a2306ef,0x11f79df7,0x1e8d2b6f,
	0xe3b7fd6d,0xca81ef0b,0xcef7f3ef,0xaeb319c7,0x3d4b7fe1,0x9e9b455f,0xa51df321,0x05378eef,
	0x14b771f3,0x085d4d1d,0xafc79a6b,0x327b32bf,0xe76ffc49,0xaae1c605,0xb4c18973,0x8489941b,
	0x9dcfa6cd,0x2b61095b,0xcd3705ab,0x781355eb,0x041dedb3,0x724746eb,0xaec31f49,0x49737c1f,
	0xe383f675,0x8c1de20d,0x9465f64d,0x25abd8b1,0xbb1764d7,0x2a9dee9d,0xc7851f7b,0xfb6798a3,
	0x18d54fe3,0xc5a5cdff,0xc8f52967,0xebf7f0fd,0x92a156ef,0x5c39ec21,0x19ed4165,0x5c57ebd1,
	0x5f47d693,0xd5899c7b,0xa50bf893,0xa6295539,0x8f7b3db5,0x01eb1705,0xc75928dd,0x68b5c855,
	0xe6db827d,0x3bdd9549,0xf945f9ef,0x79f1dc4f,0x54e9b761,0xa9058f51,0x17ab0641,0x77757157,
	0x0e11c01d,0x1b3118b5,0x4cc9a011,0xf7831da9,0x44ab26b1,0x91595d8f,0x99473669,0x5a07ba83,
	0x81ef106b,0x58993f87,0xfd37da17,0x39911131,0x9f0352dd,0xcd3712c9,0x410fe2af,0x7c5da801,
	0x5df3a8e3,0xbba57b0b,0x5eafb395,0x054daf4f,0xa2b3079f,0x6175688b,0x8a63a0ef,0x04e90e7b,
	0x4c21137d,0x0e67350b,0xdbd7f4ab,0xea6790f1,0xacffb531,0x6563e0db,0x97271381,0xf49f331d,
	0xa4fbceb5,0x3d736fd1,0x15cfc1f1,0x63138f7d,0x59a7104d,0x22d16647,0x4fbb893f,0x46ed6b91,
	0x8f81ed83,0x77db6625,0x04393c7f,0xf40364df,0xa2efb22d,0x3615ebd7,0x83039d85,0x11c9bdfd,
	0x2139b763,0x4f2d2b51,0x153721f1,0x4c674b81,0x0195b88b,0xadfd0d15,0x065fd829,0xa5a3810f,
	0x7e21484d,0xd7814b23,0x4d6d6c5f,0x65f39e4f,0x8ce165a1,0x2bddae0b,0xd5b54d89,0xad6ffbef,
	0xf8bd30bd,0xc76369e1,0x67f9f267,0xa4d978ad,0x1a8fc029,0x03899b43,0x33613e7f,0x4e9b0649,
	0x320f15ab,0x97ebe455,0xf67f071f,0xf7c9568b,0x5ee5335b,0x5b4f29c7,0xc849b861,0x491da845,
	0x39995093,0xa4a56fcd,0x81231a23,0xf7f7b451,0x0ca32ef5,0x4c03d723,0xc3cf350d,0x1765ba8f,
	0xad5d8f6f,0x4ba7ba0f,0xa683578d,0x0915aee9,0xf50bc731,0x00f9e95d,0xfbd53adb,0x0e65864f,
	0xd9db74b7,0x0d830965,0x3bc547f7,0x7955a3bb,0x27e154c5,0xd7ff0f03,0x0cbbfca5,0x7d8f652f,
	0xda173765,0xad49dc9b,0x6c877079,0xa167d0b5,0x136514ed,0x8169ff1d,0x7963f9c7,0xced7615b,
	0xb79542f5,0x508b8afb,0xdaeff2af,0x047ff43d,0xa459c963,0x20091935,0xcb319e19,0xa6abd57b,
	0x8a53d75f,0x9f5de44f,0xbf9d2cb3,0x704fed3f,0x66015861,0x69310555,0xb207e1f5,0x04010cb9,
	0x98d3a91f,0xe451d0df,0x09b3591d,0x1d075b25,0xa21d6ca1,0xc4b35407,0x2445ea35,0x6049e2c1,
	0x781b812f,0x2c77f177,0x7ed32f0b,0xcd5b3dd9,0x80f1155d,0x6ce11e57,0x7ecfa835,0xcf7763bd,
	0x2ba9dd07,0x67613f5f,0xdb1f8213,0xee7d95c5,0x293b664f,0x8e8da5cb,0xa50779cd,0x1ff96c53,
	0x45838ea1,0x8723ac63,0xf139e251,0xb81f03d3,0xe04117b1,0x6909f471,0x20cdc957,0xfac549b1,
	0x06275c79,0xa04dc2cd,0xca433c5f,0x4c71696b,0x29c5263d,0x6e257cd1,0x4283adad,0x034b5981,
	0x7c99a189,0x09f14565,0xc5df7955,0xd827887b,0xe805732d,0x6237b9f5,0x410f8a2b,0xf77da9eb,
	0xa659ed49,0x7da5cf77,0xba311ecf,0xb271a369,0x7bc7643d,0x7c0fcf67,0x59cdaea9,0xcfcd9999,
	0x8f6da3b3,0x377574cd,0x13d7eee7,0x7d051d21,0xe44d83a3,0x84fd2933,0xf0a5f781,0xdf2f77b5,
	0x72539d45,0x15f761af,0xf5f58837,0x4411190f,0xdf55201b,0xf8d71bdf,0xaff56d8f,0xf31323ed,
	0xd80fc6f3,0xba3d7ae9,0x5a2f05d7,0x9e471b19,0x0925ecdf,0x25ed8479,0xa89fe62b,0x736bae65,
	0xb823c23b,0xa7d5fdc3,0x30a59f65,0xccdda7ab,0xfc7fa1ab,0x4d0f6887,0x7207a32f,0x82a9f7cb,
	0x98918517,0x64d72009,0x7ff748f7,0xdb81e3af,0x72a19ab5,0xc1939617,0x4a0ff2f5,0x1dbf5147,
	0xaddbf9ff,0x99d1b005,0x854b5329,0xc067348d,0x635178b9,0x094743b1,0x3517d057,0x3c211c83,
	0xfb039fef,0x31d5b481,0xd4410b13,0x7c3fe033,0x24d1c0f1,0xfc7fb05f,0x1e0382b1,0xefbf6bab,
	0x71892a5f,0x7a770cc5,0x76fb5a51,0x3a3fad07,0x8bdf7d19,0xe60fc3ad,0xf6333ddb,0x850ba169,
	0x1171214b,0x43c7109d,0x0e1b66ff,0x701381f7,0x0bc1db67,0xa345ada1,0xd58bc231,0xa2f710e5,
	0x093d812b,0x00573051,0xf0c333b1,0xfdf30669,0xd639ce97,0xc3f586c9,0x1a6dfc89,0x6af59dc9,
	0xd5ef5afb,0xe53b94ad,0x4c953f87,0x4e8d4249,0xfb85ade5,0xaa71f02b,0x89b9a641,0x98f95c3f,
	0x63097433,0x0a05befb,0x45b52619,0x77173e03,0x8a6bd507,0xab8bb355,0x6ed1e531,0xa37130f3,
	0x2a8be6cd,0x88c52903,0x16c13f7f,0x573da27d,0xb02d443b,0x2e97624f,0xbb9bebb5,0xdb53710d,
	0x54f9c147,0x9e0de511,0x30df4055,0xb9375921,0xd8894037,0xcd63f7a3,0x287598a5,0x8c118239,
	0xd957a697,0xc8f13ded,0x5badd9b3,0x71b32bdd,0xcdc5f237,0x7443765d,0x54411759,0x1b997a9f,
	0x9d236e37,0xeb0356e5,0xd5515937,0x7fe56519,0xd8a107f7,0x82098a03,0xe4637fb1,0x2a61c0eb,
	0x945fc423,0x6851cbbd,0x726948f7,0x2d7d6fbd,0xe06153ad,0xe80526a3,0xa4bd7601,0xb357ac45,
	0xe191c8d3,0x477350c5,0xbe1b0f8f,0x2eb17737,0x8ac56c17,0x4a0d28c3,0xa7afcb27,0x2bf12457,
	0xf5b9b143,0x517552c3,0x1a079019,0xc22f076d,0x5c0f4c6b,0x1e71f571,0x661d1c7b,0xa421414b,
	0xb05766eb,0x31ef9703,0xde4fca2d,0xd129accb,0xd703f467,0xce031a35,0xdf6773d7,0xe655ebcf,
	0x7f6f27c7,0x96eddb4d,0x799579e9,0x0f55943b,0x9ce10841,0xd415