// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Hardware Configuration Respoitory Platform Independent Layer (PIL)
// Contains the registry of UIDs allocated to the HCR component from 
// Symbian Foundation and what they are used for.
//

/**
@file hcr_uids.h
Lists UIDs allocated to the Kernel HCR component.

@internalTechnology
*/

#ifndef HCR_UIDS_H
#define HCR_UIDS_H


// -- CONSTNATS ---------------------------------------------------------------


// Block of 64 UIDs allocated to HCR Component
#define KHCRUID_ALLOCATED_MIN       0x10286AB7
#define KHCRUID_ALLOCATED_MAX       0x10286AF6

#define KHCRUID_DLLUID3             0x10286AB7
#define KHCRUID_SMRPayloadUID       0x10286AB8
#define KHCRUID_02                  0x10286AB9
#define KHCRUID_03                  0x10286ABA
#define KHCRUID_04                  0x10286ABB
#define KHCRUID_05                  0x10286ABC
#define KHCRUID_06                  0x10286ABD
#define KHCRUID_07                  0x10286ABE

#define KHCRUID_08                  0x10286ABF
#define KHCRUID_09                  0x10286AC0
#define KHCRUID_10                  0x10286AC1
#define KHCRUID_11                  0x10286AC2
#define KHCRUID_12                  0x10286AC3
#define KHCRUID_13                  0x10286AC4
#define KHCRUID_14                  0x10286AC5
#define KHCRUID_15                  0x10286AC6

#define KHCRUID_16                  0x10286AC7
#define KHCRUID_17                  0x10286AC8
#define KHCRUID_18                  0x10286AC9
#define KHCRUID_19                  0x10286ACA
#define KHCRUID_20                  0x10286ACB
#define KHCRUID_21                  0x10286ACC
#define KHCRUID_22                  0x10286ACD
#define KHCRUID_23                  0x10286ACE

#define KHCRUID_24                  0x10286ACF
#define KHCRUID_25                  0x10286AD0
#define KHCRUID_26                  0x10286AD1
#define KHCRUID_27                  0x10286AD2
#define KHCRUID_28                  0x10286AD3
#define KHCRUID_29                  0x10286AD4
#define KHCRUID_30                  0x10286AD5
#define KHCRUID_31                  0x10286AD6

#define KHCRUID_32                  0x10286AD7
#define KHCRUID_33                  0x10286AD8
#define KHCRUID_34                  0x10286AD9
#define KHCRUID_35                  0x10286ADA
#define KHCRUID_36                  0x10286ADB
#define KHCRUID_37                  0x10286ADC
#define KHCRUID_38                  0x10286ADD
#define KHCRUID_39                  0x10286ADE

#define KHCRUID_40                  0x10286ADF
#define KHCRUID_41                  0x10286AE0
#define KHCRUID_42                  0x10286AE1
#define KHCRUID_43                  0x10286AE2
#define KHCRUID_44                  0x10286AE3
#define KHCRUID_45                  0x10286AE4
#define KHCRUID_46                  0x10286AE5
#define KHCRUID_47                  0x10286AE6

#define KHCRUID_48                  0x10286AE7
#define KHCRUID_49                  0x10286AE8
#define KHCRUID_50                  0x10286AE9
#define KHCRUID_51                  0x10286AEA
#define KHCRUID_52                  0x10286AEB
#define KHCRUID_53                  0x10286AEC
#define KHCRUID_54                  0x10286AED
#define KHCRUID_55                  0x10286AEE

#define KHCRUID_56                  0x10286AEF
#define KHCRUID_57                  0x10286AF0
#define KHCRUID_58                  0x10286AF1
#define KHCRUID_59                  0x10286AF2
#define KHCRUID_60                  0x10286AF3
#define KHCRUID_61                  0x10286AF4
#define KHCRUID_62                  0x10286AF5
#define KHCRUID_TestCategory1       0x10286AF6


#endif // HCR_UIDS_H

