// Copyright (c) 2004-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Symbian Foundation License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// e32utils\nandloader\coreldr\CoreLdr.h
// 
//

#ifndef __CORELDR_H__
#define __CORELDR_H__

#include "nand_plat.h"
#define _DEBUG_CORELDR_


// Define this macro to print out diagnostics to the serial port
//#define _DEBUG_CORELDR_

// Data structure for storing the info. about BMF (Block Map Field)
class TBlockMapField
	{
public:
	TUint16     iSbn;			// Semi physical Block Number
	TUint16     iRbn;			// Replaced Block Number
	};

const TInt KTableEntries	= 127 * 2;		// BMFS_PER_BMS * 2;
const TInt KSectorSize		= 512;			// SECTORSIZE				512

extern TBlockMapField gBBTable[KTableEntries];			//current locked area bad block table


void Read8ECC(const TNandDeviceInfo& aDevice, TUint8 * aSectorBuf, TUint32 aSectorAddr);
void Read16ECC(const TNandDeviceInfo& aDevice, TUint8 * aSectorBuf, TUint32 aSectorAddr);
void FatalError();

 
void PrintStr(const char* aString);
void PrintVal(const char* aString, TUint32 aVal);
#ifdef _DEBUG_CORELDR_
#define PRINTSTR(a)	PrintStr(a) 
#define PRINTVAL(a,b)	PrintVal(a,b) 
void DumpMem(const char* aString, TUint8 *aAddr, TInt aLen);
#else
#define PRINTSTR(a)
#define PRINTVAL(a,b)
#endif


//functions from the assembler file
#ifdef __cplusplus
extern "C" {
#endif
extern void readExtPIB8(TUint8 * aPageBuf, TUint32 aSectorAddr, TUint8 aShifter);
extern void readExtPIB16(TUint8 * aPageBuf, TUint32 aSectorAddr, TUint8 aShifter);

extern void readpage8(TUint8 * aPageBuf, TUint32 aSectorAddr, TUint32 aBytes, TDeviceFlags aDevFlags);

extern void readpage16(TUint8 * aPageBuf, TUint32 aSectorAddr, TUint32 aBytes, TDeviceFlags aDevFlags);

extern void readspare8(TUint8 * aPageBuf, TUint32 aSectorAddr, TUint32 aBytes, TDeviceFlags aDevFlags);

extern void readspare16(TUint8 * aPageBuf, TUint32 aSectorAddr, TUint32 aBytes, TDeviceFlags aDevFlags);

extern TUint32 isblockbad8(TUint aBlock, TUint8 aShifter);
extern TUint32 isblockbad16(TUint aBlock, TUint8 aShifter);

extern void readIDs(TInt *aManId, TUint *aDevId);
extern void bootos(TUint32 aBootAddress);
extern void LEDOut(TUint32 aVal);
extern void charout(TUint8 aChar);
extern void countout(void);

extern TUint32 GetRomTargetAddress();
#ifdef SUPPORTS_SMR
extern TUint32 GetSMRIBTargetAddress();
extern TUint32 GetSMRTargetStartAddress();
#endif

/**
The bootloader is resident on Nand and the core loader decides to 
load the bootloader or the os depending on the restart reason.
*/

#ifdef CFG_LABRADOR
extern TUint32 CheckRestartFromNand();
#endif

#ifdef __cplusplus
}
#endif


void NandRead(const TNandDeviceInfo&, TUint8*& aAddr,TUint aLen, TNandReadInfo& gReadInfo);



// Nand Device Commands
const TUint32 KNandReadMain			= 0x00;
const TUint32 KNandReadSpare		= 0x50;
const TUint32 KNandReadID			= 0x90;


const TUint32 KGBBMTableEntryWidth		= 2; 	//equates to 4 bytes
const TUint   KEntriesPerBBT			= 127 + 2;	//for the entries off set
const TUint32 KLBMPGpageIndex			= 0x03;

const TUint32 KTransitionLo				= 0;
const TUint32 KTransitionHi				= 1;

//sub partition table
typedef struct
	{
	TUint32				iPartitionType;		
	TUint32				iPartitionIndex;	
	TUint32				iPartitionAddress;	//pages not bytes
	TUint32				iPartitionLength;	//pages not bytes
	TUint32				iPartitionStatus;	
	TUint32				iVersion;
	} TSubPartitionTable;

//PIB extension
typedef struct
	{
	TUint32				iExtID;
	TUint32				iPIBSize;
	TUint32				iNextExtPIB;
	TUint32				iReserved;
	TSubPartitionTable	iPartitions[8];
	} TPIBExtension;

//PIB specific constants
const TUint32 KPartitionCoreOS		= 0x02;
const TUint32 KPIBPointerOffset		= 0x04; 
const TUint32 KPIBExtHeaderSize		= 0x10;
const TUint32 KPIBExtPartitionSize	= 0x20;	
const TUint32 KExtOffsetPointer		= 0x34;
const TUint32 KArmWordSize			= 0x20;
const TUint32 KVerificationA		= 0x69616E31;
const TUint32 KVerificationB		= 0x53796D62;
const TUint32 KPIBExtensionID		= 0x38534f53;
const TUint32 KPIBPointerRead		= 0x14;
const TInt KMaxNumBytesSpare		= 16;

typedef enum {
	ECC_NO_ERROR			= 0,		/* no error */
	ECC_CORRECTABLE_ERROR	= 1,		/* one bit data error */
	ECC_ECC_ERROR			= 2,		/* one bit ECC error */
	ECC_UNCORRECTABLE_ERROR	= 3			/* uncorrectable error */
} TECCError;


#ifdef SYMBIAN_SUPPORT_UNISTORE2
TBool CheckForPchSignature(TUint8* aSectorBuffer);
void ReadPartitionInfoXsr(const TNandDeviceInfo& aDevice, TUint32 aLPchSectorAddr, TNandReadInfo& aReadInfo);
void ReadBadBlockTableXsr(const TNandDeviceInfo& aDevice, TUint32 aLPchSectorAddr);
#endif

#endif
