/*
* Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
// Auto-generated by the cp54936_4byte_tounicode.pl tool - Do not edit!!!


#include <e32std.h>
#include <e32def.h>
#include "cp54936.h"


// mapping table of: CP54936 4-byte in-BMP ---> Unicode
// To calculate index: index=(b1-144)*12600+(b2-48)*1260+(b3-129)*10+(b4-48), in which,
// b1,b2,b3,b4 is byte1,2,3,4 of CP54936 code.
// For example, CP54936 code 0x8232EA38, the index=(0x82-144)*12600+(0x32-48)*1260+(0xEA-129)*10+(0x38-48)=16178
// So we get the Unicode 0x42AB.
// Generated with: "perl -w ..\group\cp54936_4byte_tounicode.pl cp54936_4byte.txt cp54936_4byte_tounicode.cpp".

const TUint16 KMappingTable4ByteBmp2Unicode[39420] =
	{
	0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 	// 0x81308139
	0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F, 0x0090, 0x0091, 0x0092, 0x0093, 	// 0x81308239
	0x0094, 0x0095, 0x0096, 0x0097, 0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 	// 0x81308339
	0x009E, 0x009F, 0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A5, 0x00A6, 0x00A9, 0x00AA, 	// 0x81308439
	0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 	// 0x81308539
	0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x00C1, 	// 0x81308639
	0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 	// 0x81308739
	0x00CC, 0x00CD, 0x00CE, 0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 	// 0x81308839
	0x00D6, 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E2, 	// 0x81308939
	0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00EB, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 	// 0x81308A39
	0x00F4, 0x00F5, 0x00F6, 0x00F8, 0x00FB, 0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0102, 	// 0x81308B39
	0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 	// 0x81308C39
	0x010D, 0x010E, 0x010F, 0x0110, 0x0111, 0x0112, 0x0114, 0x0115, 0x0116, 0x0117, 	// 0x81308D39
	0x0118, 0x0119, 0x011A, 0x011C, 0x011D, 0x011E, 0x011F, 0x0120, 0x0121, 0x0122, 	// 0x81308E39
	0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128, 0x0129, 0x012A, 0x012C, 0x012D, 	// 0x81308F39
	0x012E, 0x012F, 0x0130, 0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 	// 0x81309039
	0x0138, 0x0139, 0x013A, 0x013B, 0x013C, 0x013D, 0x013E, 0x013F, 0x0140, 0x0141, 	// 0x81309139
	0x0142, 0x0143, 0x0145, 0x0146, 0x0147, 0x0149, 0x014A, 0x014B, 0x014C, 0x014E, 	// 0x81309239
	0x014F, 0x0150, 0x0151, 0x0152, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157, 0x0158, 	// 0x81309339
	0x0159, 0x015A, 0x015B, 0x015C, 0x015D, 0x015E, 0x015F, 0x0160, 0x0161, 0x0162, 	// 0x81309439
	0x0163, 0x0164, 0x0165, 0x0166, 0x0167, 0x0168, 0x0169, 0x016A, 0x016C, 0x016D, 	// 0x81309539
	0x016E, 0x016F, 0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177, 	// 0x81309639
	0x0178, 0x0179, 0x017A, 0x017B, 0x017C, 0x017D, 0x017E, 0x017F, 0x0180, 0x0181, 	// 0x81309739
	0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0187, 0x0188, 0x0189, 0x018A, 0x018B, 	// 0x81309839
	0x018C, 0x018D, 0x018E, 0x018F, 0x0190, 0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 	// 0x81309939
	0x0196, 0x0197, 0x0198, 0x0199, 0x019A, 0x019B, 0x019C, 0x019D, 0x019E, 0x019F, 	// 0x81309A39
	0x01A0, 0x01A1, 0x01A2, 0x01A3, 0x01A4, 0x01A5, 0x01A6, 0x01A7, 0x01A8, 0x01A9, 	// 0x81309B39
	0x01AA, 0x01AB, 0x01AC, 0x01AD, 0x01AE, 0x01AF, 0x01B0, 0x01B1, 0x01B2, 0x01B3, 	// 0x81309C39
	0x01B4, 0x01B5, 0x01B6, 0x01B7, 0x01B8, 0x01B9, 0x01BA, 0x01BB, 0x01BC, 0x01BD, 	// 0x81309D39
	0x01BE, 0x01BF, 0x01C0, 0x01C1, 0x01C2, 0x01C3, 0x01C4, 0x01C5, 0x01C6, 0x01C7, 	// 0x81309E39
	0x01C8, 0x01C9, 0x01CA, 0x01CB, 0x01CC, 0x01CD, 0x01CF, 0x01D1, 0x01D3, 0x01D5, 	// 0x81309F39
	0x01D7, 0x01D9, 0x01DB, 0x01DD, 0x01DE, 0x01DF, 0x01E0, 0x01E1, 0x01E2, 0x01E3, 	// 0x8130A039
	0x01E4, 0x01E5, 0x01E6, 0x01E7, 0x01E8, 0x01E9, 0x01EA, 0x01EB, 0x01EC, 0x01ED, 	// 0x8130A139
	0x01EE, 0x01EF, 0x01F0, 0x01F1, 0x01F2, 0x01F3, 0x01F4, 0x01F5, 0x01F6, 0x01F7, 	// 0x8130A239
	0x01F8, 0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF, 0x0200, 0x0201, 0x0202, 	// 0x8130A339
	0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208, 0x0209, 0x020A, 0x020B, 0x020C, 	// 0x8130A439
	0x020D, 0x020E, 0x020F, 0x0210, 0x0211, 0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 	// 0x8130A539
	0x0217, 0x0218, 0x0219, 0x021A, 0x021B, 0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 	// 0x8130A639
	0x0221, 0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 	// 0x8130A739
	0x022B, 0x022C, 0x022D, 0x022E, 0x022F, 0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 	// 0x8130A839
	0x0235, 0x0236, 0x0237, 0x0238, 0x0239, 0x023A, 0x023B, 0x023C, 0x023D, 0x023E, 	// 0x8130A939
	0x023F, 0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247, 0x0248, 	// 0x8130AA39
	0x0249, 0x024A, 0x024B, 0x024C, 0x024D, 0x024E, 0x024F, 0x0250, 0x0252, 0x0253, 	// 0x8130AB39
	0x0254, 0x0255, 0x0256, 0x0257, 0x0258, 0x0259, 0x025A, 0x025B, 0x025C, 0x025D, 	// 0x8130AC39
	0x025E, 0x025F, 0x0260, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 0x0267, 0x0268, 	// 0x8130AD39
	0x0269, 0x026A, 0x026B, 0x026C, 0x026D, 0x026E, 0x026F, 0x0270, 0x0271, 0x0272, 	// 0x8130AE39
	0x0273, 0x0274, 0x0275, 0x0276, 0x0277, 0x0278, 0x0279, 0x027A, 0x027B, 0x027C, 	// 0x8130AF39
	0x027D, 0x027E, 0x027F, 0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 	// 0x8130B039
	0x0287, 0x0288, 0x0289, 0x028A, 0x028B, 0x028C, 0x028D, 0x028E, 0x028F, 0x0290, 	// 0x8130B139
	0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 0x0298, 0x0299, 0x029A, 	// 0x8130B239
	0x029B, 0x029C, 0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1, 0x02A2, 0x02A3, 0x02A4, 	// 0x8130B339
	0x02A5, 0x02A6, 0x02A7, 0x02A8, 0x02A9, 0x02AA, 0x02AB, 0x02AC, 0x02AD, 0x02AE, 	// 0x8130B439
	0x02AF, 0x02B0, 0x02B1, 0x02B2, 0x02B3, 0x02B4, 0x02B5, 0x02B6, 0x02B7, 0x02B8, 	// 0x8130B539
	0x02B9, 0x02BA, 0x02BB, 0x02BC, 0x02BD, 0x02BE, 0x02BF, 0x02C0, 0x02C1, 0x02C2, 	// 0x8130B639
	0x02C3, 0x02C4, 0x02C5, 0x02C6, 0x02C8, 0x02CC, 0x02CD, 0x02CE, 0x02CF, 0x02D0, 	// 0x8130B739
	0x02D1, 0x02D2, 0x02D3, 0x02D4, 0x02D5, 0x02D6, 0x02D7, 0x02D8, 0x02DA, 0x02DB, 	// 0x8130B839
	0x02DC, 0x02DD, 0x02DE, 0x02DF, 0x02E0, 0x02E1, 0x02E2, 0x02E3, 0x02E4, 0x02E5, 	// 0x8130B939
	0x02E6, 0x02E7, 0x02E8, 0x02E9, 0x02EA, 0x02EB, 0x02EC, 0x02ED, 0x02EE, 0x02EF, 	// 0x8130BA39
	0x02F0, 0x02F1, 0x02F2, 0x02F3, 0x02F4, 0x02F5, 0x02F6, 0x02F7, 0x02F8, 0x02F9, 	// 0x8130BB39
	0x02FA, 0x02FB, 0x02FC, 0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302, 0x0303, 	// 0x8130BC39
	0x0304, 0x0305, 0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 	// 0x8130BD39
	0x030E, 0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317, 	// 0x8130BE39
	0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F, 0x0320, 0x0321, 	// 0x8130BF39
	0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327, 0x0328, 0x0329, 0x032A, 0x032B, 	// 0x8130C039
	0x032C, 0x032D, 0x032E, 0x032F, 0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 	// 0x8130C139
	0x0336, 0x0337, 0x0338, 0x0339, 0x033A, 0x033B, 0x033C, 0x033D, 0x033E, 0x033F, 	// 0x8130C239
	0x0340, 0x0341, 0x0342, 0x0343, 0x0344, 0x0345, 0x0346, 0x0347, 0x0348, 0x0349, 	// 0x8130C339
	0x034A, 0x034B, 0x034C, 0x034D, 0x034E, 0x034F, 0x0350, 0x0351, 0x0352, 0x0353, 	// 0x8130C439
	0x0354, 0x0355, 0x0356, 0x0357, 0x0358, 0x0359, 0x035A, 0x035B, 0x035C, 0x035D, 	// 0x8130C539
	0x035E, 0x035F, 0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367, 	// 0x8130C639
	0x0368, 0x0369, 0x036A, 0x036B, 0x036C, 0x036D, 0x036E, 0x036F, 0x0370, 0x0371, 	// 0x8130C739
	0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377, 0x0378, 0x0379, 0x037A, 0x037B, 	// 0x8130C839
	0x037C, 0x037D, 0x037E, 0x037F, 0x0380, 0x0381, 0x0382, 0x0383, 0x0384, 0x0385, 	// 0x8130C939
	0x0386, 0x0387, 0x0388, 0x0389, 0x038A, 0x038B, 0x038C, 0x038D, 0x038E, 0x038F, 	// 0x8130CA39
	0x0390, 0x03A2, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF, 0x03B0, 0x03C2, 	// 0x8130CB39
	0x03CA, 0x03CB, 0x03CC, 0x03CD, 0x03CE, 0x03CF, 0x03D0, 0x03D1, 0x03D2, 0x03D3, 	// 0x8130CC39
	0x03D4, 0x03D5, 0x03D6, 0x03D7, 0x03D8, 0x03D9, 0x03DA, 0x03DB, 0x03DC, 0x03DD, 	// 0x8130CD39
	0x03DE, 0x03DF, 0x03E0, 0x03E1, 0x03E2, 0x03E3, 0x03E4, 0x03E5, 0x03E6, 0x03E7, 	// 0x8130CE39
	0x03E8, 0x03E9, 0x03EA, 0x03EB, 0x03EC, 0x03ED, 0x03EE, 0x03EF, 0x03F0, 0x03F1, 	// 0x8130CF39
	0x03F2, 0x03F3, 0x03F4, 0x03F5, 0x03F6, 0x03F7, 0x03F8, 0x03F9, 0x03FA, 0x03FB, 	// 0x8130D039
	0x03FC, 0x03FD, 0x03FE, 0x03FF, 0x0400, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 	// 0x8130D139
	0x0407, 0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x040D, 0x040E, 0x040F, 0x0450, 	// 0x8130D239
	0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459, 0x045A, 0x045B, 	// 0x8130D339
	0x045C, 0x045D, 0x045E, 0x045F, 0x0460, 0x0461, 0x0462, 0x0463, 0x0464, 0x0465, 	// 0x8130D439
	0x0466, 0x0467, 0x0468, 0x0469, 0x046A, 0x046B, 0x046C, 0x046D, 0x046E, 0x046F, 	// 0x8130D539
	0x0470, 0x0471, 0x0472, 0x0473, 0x0474, 0x0475, 0x0476, 0x0477, 0x0478, 0x0479, 	// 0x8130D639
	0x047A, 0x047B, 0x047C, 0x047D, 0x047E, 0x047F, 0x0480, 0x0481, 0x0482, 0x0483, 	// 0x8130D739
	0x0484, 0x0485, 0x0486, 0x0487, 0x0488, 0x0489, 0x048A, 0x048B, 0x048C, 0x048D, 	// 0x8130D839
	0x048E, 0x048F, 0x0490, 0x0491, 0x0492, 0x0493, 0x0494, 0x0495, 0x0496, 0x0497, 	// 0x8130D939
	0x0498, 0x0499, 0x049A, 0x049B, 0x049C, 0x049D, 0x049E, 0x049F, 0x04A0, 0x04A1, 	// 0x8130DA39
	0x04A2, 0x04A3, 0x04A4, 0x04A5, 0x04A6, 0x04A7, 0x04A8, 0x04A9, 0x04AA, 0x04AB, 	// 0x8130DB39
	0x04AC, 0x04AD, 0x04AE, 0x04AF, 0x04B0, 0x04B1, 0x04B2, 0x04B3, 0x04B4, 0x04B5, 	// 0x8130DC39
	0x04B6, 0x04B7, 0x04B8, 0x04B9, 0x04BA, 0x04BB, 0x04BC, 0x04BD, 0x04BE, 0x04BF, 	// 0x8130DD39
	0x04C0, 0x04C1, 0x04C2, 0x04C3, 0x04C4, 0x04C5, 0x04C6, 0x04C7, 0x04C8, 0x04C9, 	// 0x8130DE39
	0x04CA, 0x04CB, 0x04CC, 0x04CD, 0x04CE, 0x04CF, 0x04D0, 0x04D1, 0x04D2, 0x04D3, 	// 0x8130DF39
	0x04D4, 0x04D5, 0x04D6, 0x04D7, 0x04D8, 0x04D9, 0x04DA, 0x04DB, 0x04DC, 0x04DD, 	// 0x8130E039
	0x04DE, 0x04DF, 0x04E0, 0x04E1, 0x04E2, 0x04E3, 0x04E4, 0x04E5, 0x04E6, 0x04E7, 	// 0x8130E139
	0x04E8, 0x04E9, 0x04EA, 0x04EB, 0x04EC, 0x04ED, 0x04EE, 0x04EF, 0x04F0, 0x04F1, 	// 0x8130E239
	0x04F2, 0x04F3, 0x04F4, 0x04F5, 0x04F6, 0x04F7, 0x04F8, 0x04F9, 0x04FA, 0x04FB, 	// 0x8130E339
	0x04FC, 0x04FD, 0x04FE, 0x04FF, 0x0500, 0x0501, 0x0502, 0x0503, 0x0504, 0x0505, 	// 0x8130E439
	0x0506, 0x0507, 0x0508, 0x0509, 0x050A, 0x050B, 0x050C, 0x050D, 0x050E, 0x050F, 	// 0x8130E539
	0x0510, 0x0511, 0x0512, 0x0513, 0x0514, 0x0515, 0x0516, 0x0517, 0x0518, 0x0519, 	// 0x8130E639
	0x051A, 0x051B, 0x051C, 0x051D, 0x051E, 0x051F, 0x0520, 0x0521, 0x0522, 0x0523, 	// 0x8130E739
	0x0524, 0x0525, 0x0526, 0x0527, 0x0528, 0x0529, 0x052A, 0x052B, 0x052C, 0x052D, 	// 0x8130E839
	0x052E, 0x052F, 0x0530, 0x0531, 0x0532, 0x0533, 0x0534, 0x0535, 0x0536, 0x0537, 	// 0x8130E939
	0x0538, 0x0539, 0x053A, 0x053B, 0x053C, 0x053D, 0x053E, 0x053F, 0x0540, 0x0541, 	// 0x8130EA39
	0x0542, 0x0543, 0x0544, 0x0545, 0x0546, 0x0547, 0x0548, 0x0549, 0x054A, 0x054B, 	// 0x8130EB39
	0x054C, 0x054D, 0x054E, 0x054F, 0x0550, 0x0551, 0x0552, 0x0553, 0x0554, 0x0555, 	// 0x8130EC39
	0x0556, 0x0557, 0x0558, 0x0559, 0x055A, 0x055B, 0x055C, 0x055D, 0x055E, 0x055F, 	// 0x8130ED39
	0x0560, 0x0561, 0x0562, 0x0563, 0x0564, 0x0565, 0x0566, 0x0567, 0x0568, 0x0569, 	// 0x8130EE39
	0x056A, 0x056B, 0x056C, 0x056D, 0x056E, 0x056F, 0x0570, 0x0571, 0x0572, 0x0573, 	// 0x8130EF39
	0x0574, 0x0575, 0x0576, 0x0577, 0x0578, 0x0579, 0x057A, 0x057B, 0x057C, 0x057D, 	// 0x8130F039
	0x057E, 0x057F, 0x0580, 0x0581, 0x0582, 0x0583, 0x0584, 0x0585, 0x0586, 0x0587, 	// 0x8130F139
	0x0588, 0x0589, 0x058A, 0x058B, 0x058C, 0x058D, 0x058E, 0x058F, 0x0590, 0x0591, 	// 0x8130F239
	0x0592, 0x0593, 0x0594, 0x0595, 0x0596, 0x0597, 0x0598, 0x0599, 0x059A, 0x059B, 	// 0x8130F339
	0x059C, 0x059D, 0x059E, 0x059F, 0x05A0, 0x05A1, 0x05A2, 0x05A3, 0x05A4, 0x05A5, 	// 0x8130F439
	0x05A6, 0x05A7, 0x05A8, 0x05A9, 0x05AA, 0x05AB, 0x05AC, 0x05AD, 0x05AE, 0x05AF, 	// 0x8130F539
	0x05B0, 0x05B1, 0x05B2, 0x05B3, 0x05B4, 0x05B5, 0x05B6, 0x05B7, 0x05B8, 0x05B9, 	// 0x8130F639
	0x05BA, 0x05BB, 0x05BC, 0x05BD, 0x05BE, 0x05BF, 0x05C0, 0x05C1, 0x05C2, 0x05C3, 	// 0x8130F739
	0x05C4, 0x05C5, 0x05C6, 0x05C7, 0x05C8, 0x05C9, 0x05CA, 0x05CB, 0x05CC, 0x05CD, 	// 0x8130F839
	0x05CE, 0x05CF, 0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5, 0x05D6, 0x05D7, 	// 0x8130F939
	0x05D8, 0x05D9, 0x05DA, 0x05DB, 0x05DC, 0x05DD, 0x05DE, 0x05DF, 0x05E0, 0x05E1, 	// 0x8130FA39
	0x05E2, 0x05E3, 0x05E4, 0x05E5, 0x05E6, 0x05E7, 0x05E8, 0x05E9, 0x05EA, 0x05EB, 	// 0x8130FB39
	0x05EC, 0x05ED, 0x05EE, 0x05EF, 0x05F0, 0x05F1, 0x05F2, 0x05F3, 0x05F4, 0x05F5, 	// 0x8130FC39
	0x05F6, 0x05F7, 0x05F8, 0x05F9, 0x05FA, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF, 	// 0x8130FD39
	0x0600, 0x0601, 0x0602, 0x0603, 0x0604, 0x0605, 0x0606, 0x0607, 0x0608, 0x0609, 	// 0x8130FE39
	0x060A, 0x060B, 0x060C, 0x060D, 0x060E, 0x060F, 0x0610, 0x0611, 0x0612, 0x0613, 	// 0x81318139
	0x0614, 0x0615, 0x0616, 0x0617, 0x0618, 0x0619, 0x061A, 0x061B, 0x061C, 0x061D, 	// 0x81318239
	0x061E, 0x061F, 0x0620, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 	// 0x81318339
	0x0628, 0x0629, 0x062A, 0x062B, 0x062C, 0x062D, 0x062E, 0x062F, 0x0630, 0x0631, 	// 0x81318439
	0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 0x0639, 0x063A, 0x063B, 	// 0x81318539
	0x063C, 0x063D, 0x063E, 0x063F, 0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 	// 0x81318639
	0x0646, 0x0647, 0x0648, 0x0649, 0x064A, 0x064B, 0x064C, 0x064D, 0x064E, 0x064F, 	// 0x81318739
	0x0650, 0x0651, 0x0652, 0x0653, 0x0654, 0x0655, 0x0656, 0x0657, 0x0658, 0x0659, 	// 0x81318839
	0x065A, 0x065B, 0x065C, 0x065D, 0x065E, 0x065F, 0x0660, 0x0661, 0x0662, 0x0663, 	// 0x81318939
	0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 0x0669, 0x066A, 0x066B, 0x066C, 0x066D, 	// 0x81318A39
	0x066E, 0x066F, 0x0670, 0x0671, 0x0672, 0x0673, 0x0674, 0x0675, 0x0676, 0x0677, 	// 0x81318B39
	0x0678, 0x0679, 0x067A, 0x067B, 0x067C, 0x067D, 0x067E, 0x067F, 0x0680, 0x0681, 	// 0x81318C39
	0x0682, 0x0683, 0x0684, 0x0685, 0x0686, 0x0687, 0x0688, 0x0689, 0x068A, 0x068B, 	// 0x81318D39
	0x068C, 0x068D, 0x068E, 0x068F, 0x0690, 0x0691, 0x0692, 0x0693, 0x0694, 0x0695, 	// 0x81318E39
	0x0696, 0x0697, 0x0698, 0x0699, 0x069A, 0x069B, 0x069C, 0x069D, 0x069E, 0x069F, 	// 0x81318F39
	0x06A0, 0x06A1, 0x06A2, 0x06A3, 0x06A4, 0x06A5, 0x06A6, 0x06A7, 0x06A8, 0x06A9, 	// 0x81319039
	0x06AA, 0x06AB, 0x06AC, 0x06AD, 0x06AE, 0x06AF, 0x06B0, 0x06B1, 0x06B2, 0x06B3, 	// 0x81319139
	0x06B4, 0x06B5, 0x06B6, 0x06B7, 0x06B8, 0x06B9, 0x06BA, 0x06BB, 0x06BC, 0x06BD, 	// 0x81319239
	0x06BE, 0x06BF, 0x06C0, 0x06C1, 0x06C2, 0x06C3, 0x06C4, 0x06C5, 0x06C6, 0x06C7, 	// 0x81319339
	0x06C8, 0x06C9, 0x06CA, 0x06CB, 0x06CC, 0x06CD, 0x06CE, 0x06CF, 0x06D0, 0x06D1, 	// 0x81319439
	0x06D2, 0x06D3, 0x06D4, 0x06D5, 0x06D6, 0x06D7, 0x06D8, 0x06D9, 0x06DA, 0x06DB, 	// 0x81319539
	0x06DC, 0x06DD, 0x06DE, 0x06DF, 0x06E0, 0x06E1, 0x06E2, 0x06E3, 0x06E4, 0x06E5, 	// 0x81319639
	0x06E6, 0x06E7, 0x06E8, 0x06E9, 0x06EA, 0x06EB, 0x06EC, 0x06ED, 0x06EE, 0x06EF, 	// 0x81319739
	0x06F0, 0x06F1, 0x06F2, 0x06F3, 0x06F4, 0x06F5, 0x06F6, 0x06F7, 0x06F8, 0x06F9, 	// 0x81319839
	0x06FA, 0x06FB, 0x06FC, 0x06FD, 0x06FE, 0x06FF, 0x0700, 0x0701, 0x0702, 0x0703, 	// 0x81319939
	0x0704, 0x0705, 0x0706, 0x0707, 0x0708, 0x0709, 0x070A, 0x070B, 0x070C, 0x070D, 	// 0x81319A39
	0x070E, 0x070F, 0x0710, 0x0711, 0x0712, 0x0713, 0x0714, 0x0715, 0x0716, 0x0717, 	// 0x81319B39
	0x0718, 0x0719, 0x071A, 0x071B, 0x071C, 0x071D, 0x071E, 0x071F, 0x0720, 0x0721, 	// 0x81319C39
	0x0722, 0x0723, 0x0724, 0x0725, 0x0726, 0x0727, 0x0728, 0x0729, 0x072A, 0x072B, 	// 0x81319D39
	0x072C, 0x072D, 0x072E, 0x072F, 0x0730, 0x0731, 0x0732, 0x0733, 0x0734, 0x0735, 	// 0x81319E39
	0x0736, 0x0737, 0x0738, 0x0739, 0x073A, 0x073B, 0x073C, 0x073D, 0x073E, 0x073F, 	// 0x81319F39
	0x0740, 0x0741, 0x0742, 0x0743, 0x0744, 0x0745, 0x0746, 0x0747, 0x0748, 0x0749, 	// 0x8131A039
	0x074A, 0x074B, 0x074C, 0x074D, 0x074E, 0x074F, 0x0750, 0x0751, 0x0752, 0x0753, 	// 0x8131A139
	0x0754, 0x0755, 0x0756, 0x0757, 0x0758, 0x0759, 0x075A, 0x075B, 0x075C, 0x075D, 	// 0x8131A239
	0x075E, 0x075F, 0x0760, 0x0761, 0x0762, 0x0763, 0x0764, 0x0765, 0x0766, 0x0767, 	// 0x8131A339
	0x0768, 0x0769, 0x076A, 0x076B, 0x076C, 0x076D, 0x076E, 0x076F, 0x0770, 0x0771, 	// 0x8131A439
	0x0772, 0x0773, 0x0774, 0x0775, 0x0776, 0x0777, 0x0778, 0x0779, 0x077A, 0x077B, 	// 0x8131A539
	0x077C, 0x077D, 0x077E, 0x077F, 0x0780, 0x0781, 0x0782, 0x0783, 0x0784, 0x0785, 	// 0x8131A639
	0x0786, 0x0787, 0x0788, 0x0789, 0x078A, 0x078B, 0x078C, 0x078D, 0x078E, 0x078F, 	// 0x8131A739
	0x0790, 0x0791, 0x0792, 0x0793, 0x0794, 0x0795, 0x0796, 0x0797, 0x0798, 0x0799, 	// 0x8131A839
	0x079A, 0x079B, 0x079C, 0x079D, 0x079E, 0x079F, 0x07A0, 0x07A1, 0x07A2, 0x07A3, 	// 0x8131A939
	0x07A4, 0x07A5, 0x07A6, 0x07A7, 0x07A8, 0x07A9, 0x07AA, 0x07AB, 0x07AC, 0x07AD, 	// 0x8131AA39
	0x07AE, 0x07AF, 0x07B0, 0x07B1, 0x07B2, 0x07B3, 0x07B4, 0x07B5, 0x07B6, 0x07B7, 	// 0x8131AB39
	0x07B8, 0x07B9, 0x07BA, 0x07BB, 0x07BC, 0x07BD, 0x07BE, 0x07BF, 0x07C0, 0x07C1, 	// 0x8131AC39
	0x07C2, 0x07C3, 0x07C4, 0x07C5, 0x07C6, 0x07C7, 0x07C8, 0x07C9, 0x07CA, 0x07CB, 	// 0x8131AD39
	0x07CC, 0x07CD, 0x07CE, 0x07CF, 0x07D0, 0x07D1, 0x07D2, 0x07D3, 0x07D4, 0x07D5, 	// 0x8131AE39
	0x07D6, 0x07D7, 0x07D8, 0x07D9, 0x07DA, 0x07DB, 0x07DC, 0x07DD, 0x07DE, 0x07DF, 	// 0x8131AF39
	0x07E0, 0x07E1, 0x07E2, 0x07E3, 0x07E4, 0x07E5, 0x07E6, 0x07E7, 0x07E8, 0x07E9, 	// 0x8131B039
	0x07EA, 0x07EB, 0x07EC, 0x07ED, 0x07EE, 0x07EF, 0x07F0, 0x07F1, 0x07F2, 0x07F3, 	// 0x8131B139
	0x07F4, 0x07F5, 0x07F6, 0x07F7, 0x07F8, 0x07F9, 0x07FA, 0x07FB, 0x07FC, 0x07FD, 	// 0x8131B239
	0x07FE, 0x07FF, 0x0800, 0x0801, 0x0802, 0x0803, 0x0804, 0x0805, 0x0806, 0x0807, 	// 0x8131B339
	0x0808, 0x0809, 0x080A, 0x080B, 0x080C, 0x080D, 0x080E, 0x080F, 0x0810, 0x0811, 	// 0x8131B439
	0x0812, 0x0813, 0x0814, 0x0815, 0x0816, 0x0817, 0x0818, 0x0819, 0x081A, 0x081B, 	// 0x8131B539
	0x081C, 0x081D, 0x081E, 0x081F, 0x0820, 0x0821, 0x0822, 0x0823, 0x0824, 0x0825, 	// 0x8131B639
	0x0826, 0x0827, 0x0828, 0x0829, 0x082A, 0x082B, 0x082C, 0x082D, 0x082E, 0x082F, 	// 0x8131B739
	0x0830, 0x0831, 0x0832, 0x0833, 0x0834, 0x0835, 0x0836, 0x0837, 0x0838, 0x0839, 	// 0x8131B839
	0x083A, 0x083B, 0x083C, 0x083D, 0x083E, 0x083F, 0x0840, 0x0841, 0x0842, 0x0843, 	// 0x8131B939
	0x0844, 0x0845, 0x0846, 0x0847, 0x0848, 0x0849, 0x084A, 0x084B, 0x084C, 0x084D, 	// 0x8131BA39
	0x084E, 0x084F, 0x0850, 0x0851, 0x0852, 0x0853, 0x0854, 0x0855, 0x0856, 0x0857, 	// 0x8131BB39
	0x0858, 0x0859, 0x085A, 0x085B, 0x085C, 0x085D, 0x085E, 0x085F, 0x0860, 0x0861, 	// 0x8131BC39
	0x0862, 0x0863, 0x0864, 0x0865, 0x0866, 0x0867, 0x0868, 0x0869, 0x086A, 0x086B, 	// 0x8131BD39
	0x086C, 0x086D, 0x086E, 0x086F, 0x0870, 0x0871, 0x0872, 0x0873, 0x0874, 0x0875, 	// 0x8131BE39
	0x0876, 0x0877, 0x0878, 0x0879, 0x087A, 0x087B, 0x087C, 0x087D, 0x087E, 0x087F, 	// 0x8131BF39
	0x0880, 0x0881, 0x0882, 0x0883, 0x0884, 0x0885, 0x0886, 0x0887, 0x0888, 0x0889, 	// 0x8131C039
	0x088A, 0x088B, 0x088C, 0x088D, 0x088E, 0x088F, 0x0890, 0x0891, 0x0892, 0x0893, 	// 0x8131C139
	0x0894, 0x0895, 0x0896, 0x0897, 0x0898, 0x0899, 0x089A, 0x089B, 0x089C, 0x089D, 	// 0x8131C239
	0x089E, 0x089F, 0x08A0, 0x08A1, 0x08A2, 0x08A3, 0x08A4, 0x08A5, 0x08A6, 0x08A7, 	// 0x8131C339
	0x08A8, 0x08A9, 0x08AA, 0x08AB, 0x08AC, 0x08AD, 0x08AE, 0x08AF, 0x08B0, 0x08B1, 	// 0x8131C439
	0x08B2, 0x08B3, 0x08B4, 0x08B5, 0x08B6, 0x08B7, 0x08B8, 0x08B9, 0x08BA, 0x08BB, 	// 0x8131C539
	0x08BC, 0x08BD, 0x08BE, 0x08BF, 0x08C0, 0x08C1, 0x08C2, 0x08C3, 0x08C4, 0x08C5, 	// 0x8131C639
	0x08C6, 0x08C7, 0x08C8, 0x08C9, 0x08CA, 0x08CB, 0x08CC, 0x08CD, 0x08CE, 0x08CF, 	// 0x8131C739
	0x08D0, 0x08D1, 0x08D2, 0x08D3, 0x08D4, 0x08D5, 0x08D6, 0x08D7, 0x08D8, 0x08D9, 	// 0x8131C839
	0x08DA, 0x08DB, 0x08DC, 0x08DD, 0x08DE, 0x08DF, 0x08E0, 0x08E1, 0x08E2, 0x08E3, 	// 0x8131C939
	0x08E4, 0x08E5, 0x08E6, 0x08E7, 0x08E8, 0x08E9, 0x08EA, 0x08EB, 0x08EC, 0x08ED, 	// 0x8131CA39
	0x08EE, 0x08EF, 0x08F0, 0x08F1, 0x08F2, 0x08F3, 0x08F4, 0x08F5, 0x08F6, 0x08F7, 	// 0x8131CB39
	0x08F8, 0x08F9, 0x08FA, 0x08FB, 0x08FC, 0x08FD, 0x08FE, 0x08FF, 0x0900, 0x0901, 	// 0x8131CC39
	0x0902, 0x0903, 0x0904, 0x0905, 0x0906, 0x0907, 0x0908, 0x0909, 0x090A, 0x090B, 	// 0x8131CD39
	0x090C, 0x090D, 0x090E, 0x090F, 0x0910, 0x0911, 0x0912, 0x0913, 0x0914, 0x0915, 	// 0x8131CE39
	0x0916, 0x0917, 0x0918, 0x0919, 0x091A, 0x091B, 0x091C, 0x091D, 0x091E, 0x091F, 	// 0x8131CF39
	0x0920, 0x0921, 0x0922, 0x0923, 0x0924, 0x0925, 0x0926, 0x0927, 0x0928, 0x0929, 	// 0x8131D039
	0x092A, 0x092B, 0x092C, 0x092D, 0x092E, 0x092F, 0x0930, 0x0931, 0x0932, 0x0933, 	// 0x8131D139
	0x0934, 0x0935, 0x0936, 0x0937, 0x0938, 0x0939, 0x093A, 0x093B, 0x093C, 0x093D, 	// 0x8131D239
	0x093E, 0x093F, 0x0940, 0x0941, 0x0942, 0x0943, 0x0944, 0x0945, 0x0946, 0x0947, 	// 0x8131D339
	0x0948, 0x0949, 0x094A, 0x094B, 0x094C, 0x094D, 0x094E, 0x094F, 0x0950, 0x0951, 	// 0x8131D439
	0x0952, 0x0953, 0x0954, 0x0955, 0x0956, 0x0957, 0x0958, 0x0959, 0x095A, 0x095B, 	// 0x8131D539
	0x095C, 0x095D, 0x095E, 0x095F, 0x0960, 0x0961, 0x0962, 0x0963, 0x0964, 0x0965, 	// 0x8131D639
	0x0966, 0x0967, 0x0968, 0x0969, 0x096A, 0x096B, 0x096C, 0x096D, 0x096E, 0x096F, 	// 0x8131D739
	0x0970, 0x0971, 0x0972, 0x0973, 0x0974, 0x0975, 0x0976, 0x0977, 0x0978, 0x0979, 	// 0x8131D839
	0x097A, 0x097B, 0x097C, 0x097D, 0x097E, 0x097F, 0x0980, 0x0981, 0x0982, 0x0983, 	// 0x8131D939
	0x0984, 0x0985, 0x0986, 0x0987, 0x0988, 0x0989, 0x098A, 0x098B, 0x098C, 0x098D, 	// 0x8131DA39
	0x098E, 0x098F, 0x0990, 0x0991, 0x0992, 0x0993, 0x0994, 0x0995, 0x0996, 0x0997, 	// 0x8131DB39
	0x0998, 0x0999, 0x099A, 0x099B, 0x099C, 0x099D, 0x099E, 0x099F, 0x09A0, 0x09A1, 	// 0x8131DC39
	0x09A2, 0x09A3, 0x09A4, 0x09A5, 0x09A6, 0x09A7, 0x09A8, 0x09A9, 0x09AA, 0x09AB, 	// 0x8131DD39
	0x09AC, 0x09AD, 0x09AE, 0x09AF, 0x09B0, 0x09B1, 0x09B2, 0x09B3, 0x09B4, 0x09B5, 	// 0x8131DE39
	0x09B6, 0x09B7, 0x09B8, 0x09B9, 0x09BA, 0x09BB, 0x09BC, 0x09BD, 0x09BE, 0x09BF, 	// 0x8131DF39
	0x09C0, 0x09C1, 0x09C2, 0x09C3, 0x09C4, 0x09C5, 0x09C6, 0x09C7, 0x09C8, 0x09C9, 	// 0x8131E039
	0x09CA, 0x09CB, 0x09CC, 0x09CD, 0x09CE, 0x09CF, 0x09D0, 0x09D1, 0x09D2, 0x09D3, 	// 0x8131E139
	0x09D4, 0x09D5, 0x09D6, 0x09D7, 0x09D8, 0x09D9, 0x09DA, 0x09DB, 0x09DC, 0x09DD, 	// 0x8131E239
	0x09DE, 0x09DF, 0x09E0, 0x09E1, 0x09E2, 0x09E3, 0x09E4, 0x09E5, 0x09E6, 0x09E7, 	// 0x8131E339
	0x09E8, 0x09E9, 0x09EA, 0x09EB, 0x09EC, 0x09ED, 0x09EE, 0x09EF, 0x09F0, 0x09F1, 	// 0x8131E439
	0x09F2, 0x09F3, 0x09F4, 0x09F5, 0x09F6, 0x09F7, 0x09F8, 0x09F9, 0x09FA, 0x09FB, 	// 0x8131E539
	0x09FC, 0x09FD, 0x09FE, 0x09FF, 0x0A00, 0x0A01, 0x0A02, 0x0A03, 0x0A04, 0x0A05, 	// 0x8131E639
	0x0A06, 0x0A07, 0x0A08, 0x0A09, 0x0A0A, 0x0A0B, 0x0A0C, 0x0A0D, 0x0A0E, 0x0A0F, 	// 0x8131E739
	0x0A10, 0x0A11, 0x0A12, 0x0A13, 0x0A14, 0x0A15, 0x0A16, 0x0A17, 0x0A18, 0x0A19, 	// 0x8131E839
	0x0A1A, 0x0A1B, 0x0A1C, 0x0A1D, 0x0A1E, 0x0A1F, 0x0A20, 0x0A21, 0x0A22, 0x0A23, 	// 0x8131E939
	0x0A24, 0x0A25, 0x0A26, 0x0A27, 0x0A28, 0x0A29, 0x0A2A, 0x0A2B, 0x0A2C, 0x0A2D, 	// 0x8131EA39
	0x0A2E, 0x0A2F, 0x0A30, 0x0A31, 0x0A32, 0x0A33, 0x0A34, 0x0A35, 0x0A36, 0x0A37, 	// 0x8131EB39
	0x0A38, 0x0A39, 0x0A3A, 0x0A3B, 0x0A3C, 0x0A3D, 0x0A3E, 0x0A3F, 0x0A40, 0x0A41, 	// 0x8131EC39
	0x0A42, 0x0A43, 0x0A44, 0x0A45, 0x0A46, 0x0A47, 0x0A48, 0x0A49, 0x0A4A, 0x0A4B, 	// 0x8131ED39
	0x0A4C, 0x0A4D, 0x0A4E, 0x0A4F, 0x0A50, 0x0A51, 0x0A52, 0x0A53, 0x0A54, 0x0A55, 	// 0x8131EE39
	0x0A56, 0x0A57, 0x0A58, 0x0A59, 0x0A5A, 0x0A5B, 0x0A5C, 0x0A5D, 0x0A5E, 0x0A5F, 	// 0x8131EF39
	0x0A60, 0x0A61, 0x0A62, 0x0A63, 0x0A64, 0x0A65, 0x0A66, 0x0A67, 0x0A68, 0x0A69, 	// 0x8131F039
	0x0A6A, 0x0A6B, 0x0A6C, 0x0A6D, 0x0A6E, 0x0A6F, 0x0A70, 0x0A71, 0x0A72, 0x0A73, 	// 0x8131F139
	0x0A74, 0x0A75, 0x0A76, 0x0A77, 0x0A78, 0x0A79, 0x0A7A, 0x0A7B, 0x0A7C, 0x0A7D, 	// 0x8131F239
	0x0A7E, 0x0A7F, 0x0A80, 0x0A81, 0x0A82, 0x0A83, 0x0A84, 0x0A85, 0x0A86, 0x0A87, 	// 0x8131F339
	0x0A88, 0x0A89, 0x0A8A, 0x0A8B, 0x0A8C, 0x0A8D, 0x0A8E, 0x0A8F, 0x0A90, 0x0A91, 	// 0x8131F439
	0x0A92, 0x0A93, 0x0A94, 0x0A95, 0x0A96, 0x0A97, 0x0A98, 0x0A99, 0x0A9A, 0x0A9B, 	// 0x8131F539
	0x0A9C, 0x0A9D, 0x0A9E, 0x0A9F, 0x0AA0, 0x0AA1, 0x0AA2, 0x0AA3, 0x0AA4, 0x0AA5, 	// 0x8131F639
	0x0AA6, 0x0AA7, 0x0AA8, 0x0AA9, 0x0AAA, 0x0AAB, 0x0AAC, 0x0AAD, 0x0AAE, 0x0AAF, 	// 0x8131F739
	0x0AB0, 0x0AB1, 0x0AB2, 0x0AB3, 0x0AB4, 0x0AB5, 0x0AB6, 0x0AB7, 0x0AB8, 0x0AB9, 	// 0x8131F839
	0x0ABA, 0x0ABB, 0x0ABC, 0x0ABD, 0x0ABE, 0x0ABF, 0x0AC0, 0x0AC1, 0x0AC2, 0x0AC3, 	// 0x8131F939
	0x0AC4, 0x0AC5, 0x0AC6, 0x0AC7, 0x0AC8, 0x0AC9, 0x0ACA, 0x0ACB, 0x0ACC, 0x0ACD, 	// 0x8131FA39
	0x0ACE, 0x0ACF, 0x0AD0, 0x0AD1, 0x0AD2, 0x0AD3, 0x0AD4, 0x0AD5, 0x0AD6, 0x0AD7, 	// 0x8131FB39
	0x0AD8, 0x0AD9, 0x0ADA, 0x0ADB, 0x0ADC, 0x0ADD, 0x0ADE, 0x0ADF, 0x0AE0, 0x0AE1, 	// 0x8131FC39
	0x0AE2, 0x0AE3, 0x0AE4, 0x0AE5, 0x0AE6, 0x0AE7, 0x0AE8, 0x0AE9, 0x0AEA, 0x0AEB, 	// 0x8131FD39
	0x0AEC, 0x0AED, 0x0AEE, 0x0AEF, 0x0AF0, 0x0AF1, 0x0AF2, 0x0AF3, 0x0AF4, 0x0AF5, 	// 0x8131FE39
	0x0AF6, 0x0AF7, 0x0AF8, 0x0AF9, 0x0AFA, 0x0AFB, 0x0AFC, 0x0AFD, 0x0AFE, 0x0AFF, 	// 0x81328139
	0x0B00, 0x0B01, 0x0B02, 0x0B03, 0x0B04, 0x0B05, 0x0B06, 0x0B07, 0x0B08, 0x0B09, 	// 0x81328239
	0x0B0A, 0x0B0B, 0x0B0C, 0x0B0D, 0x0B0E, 0x0B0F, 0x0B10, 0x0B11, 0x0B12, 0x0B13, 	// 0x81328339
	0x0B14, 0x0B15, 0x0B16, 0x0B17, 0x0B18, 0x0B19, 0x0B1A, 0x0B1B, 0x0B1C, 0x0B1D, 	// 0x81328439
	0x0B1E, 0x0B1F, 0x0B20, 0x0B21, 0x0B22, 0x0B23, 0x0B24, 0x0B25, 0x0B26, 0x0B27, 	// 0x81328539
	0x0B28, 0x0B29, 0x0B2A, 0x0B2B, 0x0B2C, 0x0B2D, 0x0B2E, 0x0B2F, 0x0B30, 0x0B31, 	// 0x81328639
	0x0B32, 0x0B33, 0x0B34, 0x0B35, 0x0B36, 0x0B37, 0x0B38, 0x0B39, 0x0B3A, 0x0B3B, 	// 0x81328739
	0x0B3C, 0x0B3D, 0x0B3E, 0x0B3F, 0x0B40, 0x0B41, 0x0B42, 0x0B43, 0x0B44, 0x0B45, 	// 0x81328839
	0x0B46, 0x0B47, 0x0B48, 0x0B49, 0x0B4A, 0x0B4B, 0x0B4C, 0x0B4D, 0x0B4E, 0x0B4F, 	// 0x81328939
	0x0B50, 0x0B51, 0x0B52, 0x0B53, 0x0B54, 0x0B55, 0x0B56, 0x0B57, 0x0B58, 0x0B59, 	// 0x81328A39
	0x0B5A, 0x0B5B, 0x0B5C, 0x0B5D, 0x0B5E, 0x0B5F, 0x0B60, 0x0B61, 0x0B62, 0x0B63, 	// 0x81328B39
	0x0B64, 0x0B65, 0x0B66, 0x0B67, 0x0B68, 0x0B69, 0x0B6A, 0x0B6B, 0x0B6C, 0x0B6D, 	// 0x81328C39
	0x0B6E, 0x0B6F, 0x0B70, 0x0B71, 0x0B72, 0x0B73, 0x0B74, 0x0B75, 0x0B76, 0x0B77, 	// 0x81328D39
	0x0B78, 0x0B79, 0x0B7A, 0x0B7B, 0x0B7C, 0x0B7D, 0x0B7E, 0x0B7F, 0x0B80, 0x0B81, 	// 0x81328E39
	0x0B82, 0x0B83, 0x0B84, 0x0B85, 0x0B86, 0x0B87, 0x0B88, 0x0B89, 0x0B8A, 0x0B8B, 	// 0x81328F39
	0x0B8C, 0x0B8D, 0x0B8E, 0x0B8F, 0x0B90, 0x0B91, 0x0B92, 0x0B93, 0x0B94, 0x0B95, 	// 0x81329039
	0x0B96, 0x0B97, 0x0B98, 0x0B99, 0x0B9A, 0x0B9B, 0x0B9C, 0x0B9D, 0x0B9E, 0x0B9F, 	// 0x81329139
	0x0BA0, 0x0BA1, 0x0BA2, 0x0BA3, 0x0BA4, 0x0BA5, 0x0BA6, 0x0BA7, 0x0BA8, 0x0BA9, 	// 0x81329239
	0x0BAA, 0x0BAB, 0x0BAC, 0x0BAD, 0x0BAE, 0x0BAF, 0x0BB0, 0x0BB1, 0x0BB2, 0x0BB3, 	// 0x81329339
	0x0BB4, 0x0BB5, 0x0BB6, 0x0BB7, 0x0BB8, 0x0BB9, 0x0BBA, 0x0BBB, 0x0BBC, 0x0BBD, 	// 0x81329439
	0x0BBE, 0x0BBF, 0x0BC0, 0x0BC1, 0x0BC2, 0x0BC3, 0x0BC4, 0x0BC5, 0x0BC6, 0x0BC7, 	// 0x81329539
	0x0BC8, 0x0BC9, 0x0BCA, 0x0BCB, 0x0BCC, 0x0BCD, 0x0BCE, 0x0BCF, 0x0BD0, 0x0BD1, 	// 0x81329639
	0x0BD2, 0x0BD3, 0x0BD4, 0x0BD5, 0x0BD6, 0x0BD7, 0x0BD8, 0x0BD9, 0x0BDA, 0x0BDB, 	// 0x81329739
	0x0BDC, 0x0BDD, 0x0BDE, 0x0BDF, 0x0BE0, 0x0BE1, 0x0BE2, 0x0BE3, 0x0BE4, 0x0BE5, 	// 0x81329839
	0x0BE6, 0x0BE7, 0x0BE8, 0x0BE9, 0x0BEA, 0x0BEB, 0x0BEC, 0x0BED, 0x0BEE, 0x0BEF, 	// 0x81329939
	0x0BF0, 0x0BF1, 0x0BF2, 0x0BF3, 0x0BF4, 0x0BF5, 0x0BF6, 0x0BF7, 0x0BF8, 0x0BF9, 	// 0x81329A39
	0x0BFA, 0x0BFB, 0x0BFC, 0x0BFD, 0x0BFE, 0x0BFF, 0x0C00, 0x0C01, 0x0C02, 0x0C03, 	// 0x81329B39
	0x0C04, 0x0C05, 0x0C06, 0x0C07, 0x0C08, 0x0C09, 0x0C0A, 0x0C0B, 0x0C0C, 0x0C0D, 	// 0x81329C39
	0x0C0E, 0x0C0F, 0x0C10, 0x0C11, 0x0C12, 0x0C13, 0x0C14, 0x0C15, 0x0C16, 0x0C17, 	// 0x81329D39
	0x0C18, 0x0C19, 0x0C1A, 0x0C1B, 0x0C1C, 0x0C1D, 0x0C1E, 0x0C1F, 0x0C20, 0x0C21, 	// 0x81329E39
	0x0C22, 0x0C23, 0x0C24, 0x0C25, 0x0C26, 0x0C27, 0x0C28, 0x0C29, 0x0C2A, 0x0C2B, 	// 0x81329F39
	0x0C2C, 0x0C2D, 0x0C2E, 0x0C2F, 0x0C30, 0x0C31, 0x0C32, 0x0C33, 0x0C34, 0x0C35, 	// 0x8132A039
	0x0C36, 0x0C37, 0x0C38, 0x0C39, 0x0C3A, 0x0C3B, 0x0C3C, 0x0C3D, 0x0C3E, 0x0C3F, 	// 0x8132A139
	0x0C40, 0x0C41, 0x0C42, 0x0C43, 0x0C44, 0x0C45, 0x0C46, 0x0C47, 0x0C48, 0x0C49, 	// 0x8132A239
	0x0C4A, 0x0C4B, 0x0C4C, 0x0C4D, 0x0C4E, 0x0C4F, 0x0C50, 0x0C51, 0x0C52, 0x0C53, 	// 0x8132A339
	0x0C54, 0x0C55, 0x0C56, 0x0C57, 0x0C58, 0x0C59, 0x0C5A, 0x0C5B, 0x0C5C, 0x0C5D, 	// 0x8132A439
	0x0C5E, 0x0C5F, 0x0C60, 0x0C61, 0x0C62, 0x0C63, 0x0C64, 0x0C65, 0x0C66, 0x0C67, 	// 0x8132A539
	0x0C68, 0x0C69, 0x0C6A, 0x0C6B, 0x0C6C, 0x0C6D, 0x0C6E, 0x0C6F, 0x0C70, 0x0C71, 	// 0x8132A639
	0x0C72, 0x0C73, 0x0C74, 0x0C75, 0x0C76, 0x0C77, 0x0C78, 0x0C79, 0x0C7A, 0x0C7B, 	// 0x8132A739
	0x0C7C, 0x0C7D, 0x0C7E, 0x0C7F, 0x0C80, 0x0C81, 0x0C82, 0x0C83, 0x0C84, 0x0C85, 	// 0x8132A839
	0x0C86, 0x0C87, 0x0C88, 0x0C89, 0x0C8A, 0x0C8B, 0x0C8C, 0x0C8D, 0x0C8E, 0x0C8F, 	// 0x8132A939
	0x0C90, 0x0C91, 0x0C92, 0x0C93, 0x0C94, 0x0C95, 0x0C96, 0x0C97, 0x0C98, 0x0C99, 	// 0x8132AA39
	0x0C9A, 0x0C9B, 0x0C9C, 0x0C9D, 0x0C9E, 0x0C9F, 0x0CA0, 0x0CA1, 0x0CA2, 0x0CA3, 	// 0x8132AB39
	0x0CA4, 0x0CA5, 0x0CA6, 0x0CA7, 0x0CA8, 0x0CA9, 0x0CAA, 0x0CAB, 0x0CAC, 0x0CAD, 	// 0x8132AC39
	0x0CAE, 0x0CAF, 0x0CB0, 0x0CB1, 0x0CB2, 0x0CB3, 0x0CB4, 0x0CB5, 0x0CB6, 0x0CB7, 	// 0x8132AD39
	0x0CB8, 0x0CB9, 0x0CBA, 0x0CBB, 0x0CBC, 0x0CBD, 0x0CBE, 0x0CBF, 0x0CC0, 0x0CC1, 	// 0x8132AE39
	0x0CC2, 0x0CC3, 0x0CC4, 0x0CC5, 0x0CC6, 0x0CC7, 0x0CC8, 0x0CC9, 0x0CCA, 0x0CCB, 	// 0x8132AF39
	0x0CCC, 0x0CCD, 0x0CCE, 0x0CCF, 0x0CD0, 0x0CD1, 0x0CD2, 0x0CD3, 0x0CD4, 0x0CD5, 	// 0x8132B039
	0x0CD6, 0x0CD7, 0x0CD8, 0x0CD9, 0x0CDA, 0x0CDB, 0x0CDC, 0x0CDD, 0x0CDE, 0x0CDF, 	// 0x8132B139
	0x0CE0, 0x0CE1, 0x0CE2, 0x0CE3, 0x0CE4, 0x0CE5, 0x0CE6, 0x0CE7, 0x0CE8, 0x0CE9, 	// 0x8132B239
	0x0CEA, 0x0CEB, 0x0CEC, 0x0CED, 0x0CEE, 0x0CEF, 0x0CF0, 0x0CF1, 0x0CF2, 0x0CF3, 	// 0x8132B339
	0x0CF4, 0x0CF5, 0x0CF6, 0x0CF7, 0x0CF8, 0x0CF9, 0x0CFA, 0x0CFB, 0x0CFC, 0x0CFD, 	// 0x8132B439
	0x0CFE, 0x0CFF, 0x0D00, 0x0D01, 0x0D02, 0x0D03, 0x0D04, 0x0D05, 0x0D06, 0x0D07, 	// 0x8132B539
	0x0D08, 0x0D09, 0x0D0A, 0x0D0B, 0x0D0C, 0x0D0D, 0x0D0E, 0x0D0F, 0x0D10, 0x0D11, 	// 0x8132B639
	0x0D12, 0x0D13, 0x0D14, 0x0D15, 0x0D16, 0x0D17, 0x0D18, 0x0D19, 0x0D1A, 0x0D1B, 	// 0x8132B739
	0x0D1C, 0x0D1D, 0x0D1E, 0x0D1F, 0x0D20, 0x0D21, 0x0D22, 0x0D23, 0x0D24, 0x0D25, 	// 0x8132B839
	0x0D26, 0x0D27, 0x0D28, 0x0D29, 0x0D2A, 0x0D2B, 0x0D2C, 0x0D2D, 0x0D2E, 0x0D2F, 	// 0x8132B939
	0x0D30, 0x0D31, 0x0D32, 0x0D33, 0x0D34, 0x0D35, 0x0D36, 0x0D37, 0x0D38, 0x0D39, 	// 0x8132BA39
	0x0D3A, 0x0D3B, 0x0D3C, 0x0D3D, 0x0D3E, 0x0D3F, 0x0D40, 0x0D41, 0x0D42, 0x0D43, 	// 0x8132BB39
	0x0D44, 0x0D45, 0x0D46, 0x0D47, 0x0D48, 0x0D49, 0x0D4A, 0x0D4B, 0x0D4C, 0x0D4D, 	// 0x8132BC39
	0x0D4E, 0x0D4F, 0x0D50, 0x0D51, 0x0D52, 0x0D53, 0x0D54, 0x0D55, 0x0D56, 0x0D57, 	// 0x8132BD39
	0x0D58, 0x0D59, 0x0D5A, 0x0D5B, 0x0D5C, 0x0D5D, 0x0D5E, 0x0D5F, 0x0D60, 0x0D61, 	// 0x8132BE39
	0x0D62, 0x0D63, 0x0D64, 0x0D65, 0x0D66, 0x0D67, 0x0D68, 0x0D69, 0x0D6A, 0x0D6B, 	// 0x8132BF39
	0x0D6C, 0x0D6D, 0x0D6E, 0x0D6F, 0x0D70, 0x0D71, 0x0D72, 0x0D73, 0x0D74, 0x0D75, 	// 0x8132C039
	0x0D76, 0x0D77, 0x0D78, 0x0D79, 0x0D7A, 0x0D7B, 0x0D7C, 0x0D7D, 0x0D7E, 0x0D7F, 	// 0x8132C139
	0x0D80, 0x0D81, 0x0D82, 0x0D83, 0x0D84, 0x0D85, 0x0D86, 0x0D87, 0x0D88, 0x0D89, 	// 0x8132C239
	0x0D8A, 0x0D8B, 0x0D8C, 0x0D8D, 0x0D8E, 0x0D8F, 0x0D90, 0x0D91, 0x0D92, 0x0D93, 	// 0x8132C339
	0x0D94, 0x0D95, 0x0D96, 0x0D97, 0x0D98, 0x0D99, 0x0D9A, 0x0D9B, 0x0D9C, 0x0D9D, 	// 0x8132C439
	0x0D9E, 0x0D9F, 0x0DA0, 0x0DA1, 0x0DA2, 0x0DA3, 0x0DA4, 0x0DA5, 0x0DA6, 0x0DA7, 	// 0x8132C539
	0x0DA8, 0x0DA9, 0x0DAA, 0x0DAB, 0x0DAC, 0x0DAD, 0x0DAE, 0x0DAF, 0x0DB0, 0x0DB1, 	// 0x8132C639
	0x0DB2, 0x0DB3, 0x0DB4, 0x0DB5, 0x0DB6, 0x0DB7, 0x0DB8, 0x0DB9, 0x0DBA, 0x0DBB, 	// 0x8132C739
	0x0DBC, 0x0DBD, 0x0DBE, 0x0DBF, 0x0DC0, 0x0DC1, 0x0DC2, 0x0DC3, 0x0DC4, 0x0DC5, 	// 0x8132C839
	0x0DC6, 0x0DC7, 0x0DC8, 0x0DC9, 0x0DCA, 0x0DCB, 0x0DCC, 0x0DCD, 0x0DCE, 0x0DCF, 	// 0x8132C939
	0x0DD0, 0x0DD1, 0x0DD2, 0x0DD3, 0x0DD4, 0x0DD5, 0x0DD6, 0x0DD7, 0x0DD8, 0x0DD9, 	// 0x8132CA39
	0x0DDA, 0x0DDB, 0x0DDC, 0x0DDD, 0x0DDE, 0x0DDF, 0x0DE0, 0x0DE1, 0x0DE2, 0x0DE3, 	// 0x8132CB39
	0x0DE4, 0x0DE5, 0x0DE6, 0x0DE7, 0x0DE8, 0x0DE9, 0x0DEA, 0x0DEB, 0x0DEC, 0x0DED, 	// 0x8132CC39
	0x0DEE, 0x0DEF, 0x0DF0, 0x0DF1, 0x0DF2, 0x0DF3, 0x0DF4, 0x0DF5, 0x0DF6, 0x0DF7, 	// 0x8132CD39
	0x0DF8, 0x0DF9, 0x0DFA, 0x0DFB, 0x0DFC, 0x0DFD, 0x0DFE, 0x0DFF, 0x0E00, 0x0E01, 	// 0x8132CE39
	0x0E02, 0x0E03, 0x0E04, 0x0E05, 0x0E06, 0x0E07, 0x0E08, 0x0E09, 0x0E0A, 0x0E0B, 	// 0x8132CF39
	0x0E0C, 0x0E0D, 0x0E0E, 0x0E0F, 0x0E10, 0x0E11, 0x0E12, 0x0E13, 0x0E14, 0x0E15, 	// 0x8132D039
	0x0E16, 0x0E17, 0x0E18, 0x0E19, 0x0E1A, 0x0E1B, 0x0E1C, 0x0E1D, 0x0E1E, 0x0E1F, 	// 0x8132D139
	0x0E20, 0x0E21, 0x0E22, 0x0E23, 0x0E24, 0x0E25, 0x0E26, 0x0E27, 0x0E28, 0x0E29, 	// 0x8132D239
	0x0E2A, 0x0E2B, 0x0E2C, 0x0E2D, 0x0E2E, 0x0E2F, 0x0E30, 0x0E31, 0x0E32, 0x0E33, 	// 0x8132D339
	0x0E34, 0x0E35, 0x0E36, 0x0E37, 0x0E38, 0x0E39, 0x0E3A, 0x0E3B, 0x0E3C, 0x0E3D, 	// 0x8132D439
	0x0E3E, 0x0E3F, 0x0E40, 0x0E41, 0x0E42, 0x0E43, 0x0E44, 0x0E45, 0x0E46, 0x0E47, 	// 0x8132D539
	0x0E48, 0x0E49, 0x0E4A, 0x0E4B, 0x0E4C, 0x0E4D, 0x0E4E, 0x0E4F, 0x0E50, 0x0E51, 	// 0x8132D639
	0x0E52, 0x0E53, 0x0E54, 0x0E55, 0x0E56, 0x0E57, 0x0E58, 0x0E59, 0x0E5A, 0x0E5B, 	// 0x8132D739
	0x0E5C, 0x0E5D, 0x0E5E, 0x0E5F, 0x0E60, 0x0E61, 0x0E62, 0x0E63, 0x0E64, 0x0E65, 	// 0x8132D839
	0x0E66, 0x0E67, 0x0E68, 0x0E69, 0x0E6A, 0x0E6B, 0x0E6C, 0x0E6D, 0x0E6E, 0x0E6F, 	// 0x8132D939
	0x0E70, 0x0E71, 0x0E72, 0x0E73, 0x0E74, 0x0E75, 0x0E76, 0x0E77, 0x0E78, 0x0E79, 	// 0x8132DA39
	0x0E7A, 0x0E7B, 0x0E7C, 0x0E7D, 0x0E7E, 0x0E7F, 0x0E80, 0x0E81, 0x0E82, 0x0E83, 	// 0x8132DB39
	0x0E84, 0x0E85, 0x0E86, 0x0E87, 0x0E88, 0x0E89, 0x0E8A, 0x0E8B, 0x0E8C, 0x0E8D, 	// 0x8132DC39
	0x0E8E, 0x0E8F, 0x0E90, 0x0E91, 0x0E92, 0x0E93, 0x0E94, 0x0E95, 0x0E96, 0x0E97, 	// 0x8132DD39
	0x0E98, 0x0E99, 0x0E9A, 0x0E9B, 0x0E9C, 0x0E9D, 0x0E9E, 0x0E9F, 0x0EA0, 0x0EA1, 	// 0x8132DE39
	0x0EA2, 0x0EA3, 0x0EA4, 0x0EA5, 0x0EA6, 0x0EA7, 0x0EA8, 0x0EA9, 0x0EAA, 0x0EAB, 	// 0x8132DF39
	0x0EAC, 0x0EAD, 0x0EAE, 0x0EAF, 0x0EB0, 0x0EB1, 0x0EB2, 0x0EB3, 0x0EB4, 0x0EB5, 	// 0x8132E039
	0x0EB6, 0x0EB7, 0x0EB8, 0x0EB9, 0x0EBA, 0x0EBB, 0x0EBC, 0x0EBD, 0x0EBE, 0x0EBF, 	// 0x8132E139
	0x0EC0, 0x0EC1, 0x0EC2, 0x0EC3, 0x0EC4, 0x0EC5, 0x0EC6, 0x0EC7, 0x0EC8, 0x0EC9, 	// 0x8132E239
	0x0ECA, 0x0ECB, 0x0ECC, 0x0ECD, 0x0ECE, 0x0ECF, 0x0ED0, 0x0ED1, 0x0ED2, 0x0ED3, 	// 0x8132E339
	0x0ED4, 0x0ED5, 0x0ED6, 0x0ED7, 0x0ED8, 0x0ED9, 0x0EDA, 0x0EDB, 0x0EDC, 0x0EDD, 	// 0x8132E439
	0x0EDE, 0x0EDF, 0x0EE0, 0x0EE1, 0x0EE2, 0x0EE3, 0x0EE4, 0x0EE5, 0x0EE6, 0x0EE7, 	// 0x8132E539
	0x0EE8, 0x0EE9, 0x0EEA, 0x0EEB, 0x0EEC, 0x0EED, 0x0EEE, 0x0EEF, 0x0EF0, 0x0EF1, 	// 0x8132E639
	0x0EF2, 0x0EF3, 0x0EF4, 0x0EF5, 0x0EF6, 0x0EF7, 0x0EF8, 0x0EF9, 0x0EFA, 0x0EFB, 	// 0x8132E739
	0x0EFC, 0x0EFD, 0x0EFE, 0x0EFF, 0x0F00, 0x0F01, 0x0F02, 0x0F03, 0x0F04, 0x0F05, 	// 0x8132E839
	0x0F06, 0x0F07, 0x0F08, 0x0F09, 0x0F0A, 0x0F0B, 0x0F0C, 0x0F0D, 0x0F0E, 0x0F0F, 	// 0x8132E939
	0x0F10, 0x0F11, 0x0F12, 0x0F13, 0x0F14, 0x0F15, 0x0F16, 0x0F17, 0x0F18, 0x0F19, 	// 0x8132EA39
	0x0F1A, 0x0F1B, 0x0F1C, 0x0F1D, 0x0F1E, 0x0F1F, 0x0F20, 0x0F21, 0x0F22, 0x0F23, 	// 0x8132EB39
	0x0F24, 0x0F25, 0x0F26, 0x0F27, 0x0F28, 0x0F29, 0x0F2A, 0x0F2B, 0x0F2C, 0x0F2D, 	// 0x8132EC39
	0x0F2E, 0x0F2F, 0x0F30, 0x0F31, 0x0F32, 0x0F33, 0x0F34, 0x0F35, 0x0F36, 0x0F37, 	// 0x8132ED39
	0x0F38, 0x0F39, 0x0F3A, 0x0F3B, 0x0F3C, 0x0F3D, 0x0F3E, 0x0F3F, 0x0F40, 0x0F41, 	// 0x8132EE39
	0x0F42, 0x0F43, 0x0F44, 0x0F45, 0x0F46, 0x0F47, 0x0F48, 0x0F49, 0x0F4A, 0x0F4B, 	// 0x8132EF39
	0x0F4C, 0x0F4D, 0x0F4E, 0x0F4F, 0x0F50, 0x0F51, 0x0F52, 0x0F53, 0x0F54, 0x0F55, 	// 0x8132F039
	0x0F56, 0x0F57, 0x0F58, 0x0F59, 0x0F5A, 0x0F5B, 0x0F5C, 0x0F5D, 0x0F5E, 0x0F5F, 	// 0x8132F139
	0x0F60, 0x0F61, 0x0F62, 0x0F63, 0x0F64, 0x0F65, 0x0F66, 0x0F67, 0x0F68, 0x0F69, 	// 0x8132F239
	0x0F6A, 0x0F6B, 0x0F6C, 0x0F6D, 0x0F6E, 0x0F6F, 0x0F70, 0x0F71, 0x0F72, 0x0F73, 	// 0x8132F339
	0x0F74, 0x0F75, 0x0F76, 0x0F77, 0x0F78, 0x0F79, 0x0F7A, 0x0F7B, 0x0F7C, 0x0F7D, 	// 0x8132F439
	0x0F7E, 0x0F7F, 0x0F80, 0x0F81, 0x0F82, 0x0F83, 0x0F84, 0x0F85, 0x0F86, 0x0F87, 	// 0x8132F539
	0x0F88, 0x0F89, 0x0F8A, 0x0F8B, 0x0F8C, 0x0F8D, 0x0F8E, 0x0F8F, 0x0F90, 0x0F91, 	// 0x8132F639
	0x0F92, 0x0F93, 0x0F94, 0x0F95, 0x0F96, 0x0F97, 0x0F98, 0x0F99, 0x0F9A, 0x0F9B, 	// 0x8132F739
	0x0F9C, 0x0F9D, 0x0F9E, 0x0F9F, 0x0FA0, 0x0FA1, 0x0FA2, 0x0FA3, 0x0FA4, 0x0FA5, 	// 0x8132F839
	0x0FA6, 0x0FA7, 0x0FA8, 0x0FA9, 0x0FAA, 0x0FAB, 0x0FAC, 0x0FAD, 0x0FAE, 0x0FAF, 	// 0x8132F939
	0x0FB0, 0x0FB1, 0x0FB2, 0x0FB3, 0x0FB4, 0x0FB5, 0x0FB6, 0x0FB7, 0x0FB8, 0x0FB9, 	// 0x8132FA39
	0x0FBA, 0x0FBB, 0x0FBC, 0x0FBD, 0x0FBE, 0x0FBF, 0x0FC0, 0x0FC1, 0x0FC2, 0x0FC3, 	// 0x8132FB39
	0x0FC4, 0x0FC5, 0x0FC6, 0x0FC7, 0x0FC8, 0x0FC9, 0x0FCA, 0x0FCB, 0x0FCC, 0x0FCD, 	// 0x8132FC39
	0x0FCE, 0x0FCF, 0x0FD0, 0x0FD1, 0x0FD2, 0x0FD3, 0x0FD4, 0x0FD5, 0x0FD6, 0x0FD7, 	// 0x8132FD39
	0x0FD8, 0x0FD9, 0x0FDA, 0x0FDB, 0x0FDC, 0x0FDD, 0x0FDE, 0x0FDF, 0x0FE0, 0x0FE1, 	// 0x8132FE39
	0x0FE2, 0x0FE3, 0x0FE4, 0x0FE5, 0x0FE6, 0x0FE7, 0x0FE8, 0x0FE9, 0x0FEA, 0x0FEB, 	// 0x81338139
	0x0FEC, 0x0FED, 0x0FEE, 0x0FEF, 0x0FF0, 0x0FF1, 0x0FF2, 0x0FF3, 0x0FF4, 0x0FF5, 	// 0x81338239
	0x0FF6, 0x0FF7, 0x0FF8, 0x0FF9, 0x0FFA, 0x0FFB, 0x0FFC, 0x0FFD, 0x0FFE, 0x0FFF, 	// 0x81338339
	0x1000, 0x1001, 0x1002, 0x1003, 0x1004, 0x1005, 0x1006, 0x1007, 0x1008, 0x1009, 	// 0x81338439
	0x100A, 0x100B, 0x100C, 0x100D, 0x100E, 0x100F, 0x1010, 0x1011, 0x1012, 0x1013, 	// 0x81338539
	0x1014, 0x1015, 0x1016, 0x1017, 0x1018, 0x1019, 0x101A, 0x101B, 0x101C, 0x101D, 	// 0x81338639
	0x101E, 0x101F, 0x1020, 0x1021, 0x1022, 0x1023, 0x1024, 0x1025, 0x1026, 0x1027, 	// 0x81338739
	0x1028, 0x1029, 0x102A, 0x102B, 0x102C, 0x102D, 0x102E, 0x102F, 0x1030, 0x1031, 	// 0x81338839
	0x1032, 0x1033, 0x1034, 0x1035, 0x1036, 0x1037, 0x1038, 0x1039, 0x103A, 0x103B, 	// 0x81338939
	0x103C, 0x103D, 0x103E, 0x103F, 0x1040, 0x1041, 0x1042, 0x1043, 0x1044, 0x1045, 	// 0x81338A39
	0x1046, 0x1047, 0x1048, 0x1049, 0x104A, 0x104B, 0x104C, 0x104D, 0x104E, 0x104F, 	// 0x81338B39
	0x1050, 0x1051, 0x1052, 0x1053, 0x1054, 0x1055, 0x1056, 0x1057, 0x1058, 0x1059, 	// 0x81338C39
	0x105A, 0x105B, 0x105C, 0x105D, 0x105E, 0x105F, 0x1060, 0x1061, 0x1062, 0x1063, 	// 0x81338D39
	0x1064, 0x1065, 0x1066, 0x1067, 0x1068, 0x1069, 0x106A, 0x106B, 0x106C, 0x106D, 	// 0x81338E39
	0x106E, 0x106F, 0x1070, 0x1071, 0x1072, 0x1073, 0x1074, 0x1075, 0x1076, 0x1077, 	// 0x81338F39
	0x1078, 0x1079, 0x107A, 0x107B, 0x107C, 0x107D, 0x107E, 0x107F, 0x1080, 0x1081, 	// 0x81339039
	0x1082, 0x1083, 0x1084, 0x1085, 0x1086, 0x1087, 0x1088, 0x1089, 0x108A, 0x108B, 	// 0x81339139
	0x108C, 0x108D, 0x108E, 0x108F, 0x1090, 0x1091, 0x1092, 0x1093, 0x1094, 0x1095, 	// 0x81339239
	0x1096, 0x1097, 0x1098, 0x1099, 0x109A, 0x109B, 0x109C, 0x109D, 0x109E, 0x109F, 	// 0x81339339
	0x10A0, 0x10A1, 0x10A2, 0x10A3, 0x10A4, 0x10A5, 0x10A6, 0x10A7, 0x10A8, 0x10A9, 	// 0x81339439
	0x10AA, 0x10AB, 0x10AC, 0x10AD, 0x10AE, 0x10AF, 0x10B0, 0x10B1, 0x10B2, 0x10B3, 	// 0x81339539
	0x10B4, 0x10B5, 0x10B6, 0x10B7, 0x10B8, 0x10B9, 0x10BA, 0x10BB, 0x10BC, 0x10BD, 	// 0x81339639
	0x10BE, 0x10BF, 0x10C0, 0x10C1, 0x10C2, 0x10C3, 0x10C4, 0x10C5, 0x10C6, 0x10C7, 	// 0x81339739
	0x10C8, 0x10C9, 0x10CA, 0x10CB, 0x10CC, 0x10CD, 0x10CE, 0x10CF, 0x10D0, 0x10D1, 	// 0x81339839
	0x10D2, 0x10D3, 0x10D4, 0x10D5, 0x10D6, 0x10D7, 0x10D8, 0x10D9, 0x10DA, 0x10DB, 	// 0x81339939
	0x10DC, 0x10DD, 0x10DE, 0x10DF, 0x10E0, 0x10E1, 0x10E2, 0x10E3, 0x10E4, 0x10E5, 	// 0x81339A39
	0x10E6, 0x10E7, 0x10E8, 0x10E9, 0x10EA, 0x10EB, 0x10EC, 0x10ED, 0x10EE, 0x10EF, 	// 0x81339B39
	0x10F0, 0x10F1, 0x10F2, 0x10F3, 0x10F4, 0x10F5, 0x10F6, 0x10F7, 0x10F8, 0x10F9, 	// 0x81339C39
	0x10FA, 0x10FB, 0x10FC, 0x10FD, 0x10FE, 0x10FF, 0x1100, 0x1101, 0x1102, 0x1103, 	// 0x81339D39
	0x1104, 0x1105, 0x1106, 0x1107, 0x1108, 0x1109, 0x110A, 0x110B, 0x110C, 0x110D, 	// 0x81339E39
	0x110E, 0x110F, 0x1110, 0x1111, 0x1112, 0x1113, 0x1114, 0x1115, 0x1116, 0x1117, 	// 0x81339F39
	0x1118, 0x1119, 0x111A, 0x111B, 0x111C, 0x111D, 0x111E, 0x111F, 0x1120, 0x1121, 	// 0x8133A039
	0x1122, 0x1123, 0x1124, 0x1125, 0x1126, 0x1127, 0x1128, 0x1129, 0x112A, 0x112B, 	// 0x8133A139
	0x112C, 0x112D, 0x112E, 0x112F, 0x1130, 0x1131, 0x1132, 0x1133, 0x1134, 0x1135, 	// 0x8133A239
	0x1136, 0x1137, 0x1138, 0x1139, 0x113A, 0x113B, 0x113C, 0x113D, 0x113E, 0x113F, 	// 0x8133A339
	0x1140, 0x1141, 0x1142, 0x1143, 0x1144, 0x1145, 0x1146, 0x1147, 0x1148, 0x1149, 	// 0x8133A439
	0x114A, 0x114B, 0x114C, 0x114D, 0x114E, 0x114F, 0x1150, 0x1151, 0x1152, 0x1153, 	// 0x8133A539
	0x1154, 0x1155, 0x1156, 0x1157, 0x1158, 0x1159, 0x115A, 0x115B, 0x115C, 0x115D, 	// 0x8133A639
	0x115E, 0x115F, 0x1160, 0x1161, 0x1162, 0x1163, 0x1164, 0x1165, 0x1166, 0x1167, 	// 0x8133A739
	0x1168, 0x1169, 0x116A, 0x116B, 0x116C, 0x116D, 0x116E, 0x116F, 0x1170, 0x1171, 	// 0x8133A839
	0x1172, 0x1173, 0x1174, 0x1175, 0x1176, 0x1177, 0x1178, 0x1179, 0x117A, 0x117B, 	// 0x8133A939
	0x117C, 0x117D, 0x117E, 0x117F, 0x1180, 0x1181, 0x1182, 0x1183, 0x1184, 0x1185, 	// 0x8133AA39
	0x1186, 0x1187, 0x1188, 0x1189, 0x118A, 0x118B, 0x118C, 0x118D, 0x118E, 0x118F, 	// 0x8133AB39
	0x1190, 0x1191, 0x1192, 0x1193, 0x1194, 0x1195, 0x1196, 0x1197, 0x1198, 0x1199, 	// 0x8133AC39
	0x119A, 0x119B, 0x119C, 0x119D, 0x119E, 0x119F, 0x11A0, 0x11A1, 0x11A2, 0x11A3, 	// 0x8133AD39
	0x11A4, 0x11A5, 0x11A6, 0x11A7, 0x11A8, 0x11A9, 0x11AA, 0x11AB, 0x11AC, 0x11AD, 	// 0x8133AE39
	0x11AE, 0x11AF, 0x11B0, 0x11B1, 0x11B2, 0x11B3, 0x11B4, 0x11B5, 0x11B6, 0x11B7, 	// 0x8133AF39
	0x11B8, 0x11B9, 0x11BA, 0x11BB, 0x11BC, 0x11BD, 0x11BE, 0x11BF, 0x11C0, 0x11C1, 	// 0x8133B039
	0x11C2, 0x11C3, 0x11C4, 0x11C5, 0x11C6, 0x11C7, 0x11C8, 0x11C9, 0x11CA, 0x11CB, 	// 0x8133B139
	0x11CC, 0x11CD, 0x11CE, 0x11CF, 0x11D0, 0x11D1, 0x11D2, 0x11D3, 0x11D4, 0x11D5, 	// 0x8133B239
	0x11D6, 0x11D7, 0x11D8, 0x11D9, 0x11DA, 0x11DB, 0x11DC, 0x11DD, 0x11DE, 0x11DF, 	// 0x8133B339
	0x11E0, 0x11E1, 0x11E2, 0x11E3, 0x11E4, 0x11E5, 0x11E6, 0x11E7, 0x11E8, 0x11E9, 	// 0x8133B439
	0x11EA, 0x11EB, 0x11EC, 0x11ED, 0x11EE, 0x11EF, 0x11F0, 0x11F1, 0x11F2, 0x11F3, 	// 0x8133B539
	0x11F4, 0x11F5, 0x11F6, 0x11F7, 0x11F8, 0x11F9, 0x11FA, 0x11FB, 0x11FC, 0x11FD, 	// 0x8133B639
	0x11FE, 0x11FF, 0x1200, 0x1201, 0x1202, 0x1203, 0x1204, 0x1205, 0x1206, 0x1207, 	// 0x8133B739
	0x1208, 0x1209, 0x120A, 0x120B, 0x120C, 0x120D, 0x120E, 0x120F, 0x1210, 0x1211, 	// 0x8133B839
	0x1212, 0x1213, 0x1214, 0x1215, 0x1216, 0x1217, 0x1218, 0x1219, 0x121A, 0x121B, 	// 0x8133B939
	0x121C, 0x121D, 0x121E, 0x121F, 0x1220, 0x1221, 0x1222, 0x1223, 0x1224, 0x1225, 	// 0x8133BA39
	0x1226, 0x1227, 0x1228, 0x1229, 0x122A, 0x122B, 0x122C, 0x122D, 0x122E, 0x122F, 	// 0x8133BB39
	0x1230, 0x1231, 0x1232, 0x1233, 0x1234, 0x1235, 0x1236, 0x1237, 0x1238, 0x1239, 	// 0x8133BC39
	0x123A, 0x123B, 0x123C, 0x123D, 0x123E, 0x123F, 0x1240, 0x1241, 0x1242, 0x1243, 	// 0x8133BD39
	0x1244, 0x1245, 0x1246, 0x1247, 0x1248, 0x1249, 0x124A, 0x124B, 0x124C, 0x124D, 	// 0x8133BE39
	0x124E, 0x124F, 0x1250, 0x1251, 0x1252, 0x1253, 0x1254, 0x1255, 0x1256, 0x1257, 	// 0x8133BF39
	0x1258, 0x1259, 0x125A, 0x125B, 0x125C, 0x125D, 0x125E, 0x125F, 0x1260, 0x1261, 	// 0x8133C039
	0x1262, 0x1263, 0x1264, 0x1265, 0x1266, 0x1267, 0x1268, 0x1269, 0x126A, 0x126B, 	// 0x8133C139
	0x126C, 0x126D, 0x126E, 0x126F, 0x1270, 0x1271, 0x1272, 0x1273, 0x1274, 0x1275, 	// 0x8133C239
	0x1276, 0x1277, 0x1278, 0x1279, 0x127A, 0x127B, 0x127C, 0x127D, 0x127E, 0x127F, 	// 0x8133C339
	0x1280, 0x1281, 0x1282, 0x1283, 0x1284, 0x1285, 0x1286, 0x1287, 0x1288, 0x1289, 	// 0x8133C439
	0x128A, 0x128B, 0x128C, 0x128D, 0x128E, 0x128F, 0x1290, 0x1291, 0x1292, 0x1293, 	// 0x8133C539
	0x1294, 0x1295, 0x1296, 0x1297, 0x1298, 0x1299, 0x129A, 0x129B, 0x129C, 0x129D, 	// 0x8133C639
	0x129E, 0x129F, 0x12A0, 0x12A1, 0x12A2, 0x12A3, 0x12A4, 0x12A5, 0x12A6, 0x12A7, 	// 0x8133C739
	0x12A8, 0x12A9, 0x12AA, 0x12AB, 0x12AC, 0x12AD, 0x12AE, 0x12AF, 0x12B0, 0x12B1, 	// 0x8133C839
	0x12B2, 0x12B3, 0x12B4, 0x12B5, 0x12B6, 0x12B7, 0x12B8, 0x12B9, 0x12BA, 0x12BB, 	// 0x8133C939
	0x12BC, 0x12BD, 0x12BE, 0x12BF, 0x12C0, 0x12C1, 0x12C2, 0x12C3, 0x12C4, 0x12C5, 	// 0x8133CA39
	0x12C6, 0x12C7, 0x12C8, 0x12C9, 0x12CA, 0x12CB, 0x12CC, 0x12CD, 0x12CE, 0x12CF, 	// 0x8133CB39
	0x12D0, 0x12D1, 0x12D2, 0x12D3, 0x12D4, 0x12D5, 0x12D6, 0x12D7, 0x12D8, 0x12D9, 	// 0x8133CC39
	0x12DA, 0x12DB, 0x12DC, 0x12DD, 0x12DE, 0x12DF, 0x12E0, 0x12E1, 0x12E2, 0x12E3, 	// 0x8133CD39
	0x12E4, 0x12E5, 0x12E6, 0x12E7, 0x12E8, 0x12E9, 0x12EA, 0x12EB, 0x12EC, 0x12ED, 	// 0x8133CE39
	0x12EE, 0x12EF, 0x12F0, 0x12F1, 0x12F2, 0x12F3, 0x12F4, 0x12F5, 0x12F6, 0x12F7, 	// 0x8133CF39
	0x12F8, 0x12F9, 0x12FA, 0x12FB, 0x12FC, 0x12FD, 0x12FE, 0x12FF, 0x1300, 0x1301, 	// 0x8133D039
	0x1302, 0x1303, 0x1304, 0x1305, 0x1306, 0x1307, 0x1308, 0x1309, 0x130A, 0x130B, 	// 0x8133D139
	0x130C, 0x130D, 0x130E, 0x130F, 0x1310, 0x1311, 0x1312, 0x1313, 0x1314, 0x1315, 	// 0x8133D239
	0x1316, 0x1317, 0x1318, 0x1319, 0x131A, 0x131B, 0x131C, 0x131D, 0x131E, 0x131F, 	// 0x8133D339
	0x1320, 0x1321, 0x1322, 0x1323, 0x1324, 0x1325, 0x1326, 0x1327, 0x1328, 0x1329, 	// 0x8133D439
	0x132A, 0x132B, 0x132C, 0x132D, 0x132E, 0x132F, 0x1330, 0x1331, 0x1332, 0x1333, 	// 0x8133D539
	0x1334, 0x1335, 0x1336, 0x1337, 0x1338, 0x1339, 0x133A, 0x133B, 0x133C, 0x133D, 	// 0x8133D639
	0x133E, 0x133F, 0x1340, 0x1341, 0x1342, 0x1343, 0x1344, 0x1345, 0x1346, 0x1347, 	// 0x8133D739
	0x1348, 0x1349, 0x134A, 0x134B, 0x134C, 0x134D, 0x134E, 0x134F, 0x1350, 0x1351, 	// 0x8133D839
	0x1352, 0x1353, 0x1354, 0x1355, 0x1356, 0x1357, 0x1358, 0x1359, 0x135A, 0x135B, 	// 0x8133D939
	0x135C, 0x135D, 0x135E, 0x135F, 0x1360, 0x1361, 0x1362, 0x1363, 0x1364, 0x1365, 	// 0x8133DA39
	0x1366, 0x1367, 0x1368, 0x1369, 0x136A, 0x136B, 0x136C, 0x136D, 0x136E, 0x136F, 	// 0x8133DB39
	0x1370, 0x1371, 0x1372, 0x1373, 0x1374, 0x1375, 0x1376, 0x1377, 0x1378, 0x1379, 	// 0x8133DC39
	0x137A, 0x137B, 0x137C, 0x137D, 0x137E, 0x137F, 0x1380, 0x1381, 0x1382, 0x1383, 	// 0x8133DD39
	0x1384, 0x1385, 0x1386, 0x1387, 0x1388, 0x1389, 0x138A, 0x138B, 0x138C, 0x138D, 	// 0x8133DE39
	0x138E, 0x138F, 0x1390, 0x1391, 0x1392, 0x1393, 0x1394, 0x1395, 0x1396, 0x1397, 	// 0x8133DF39
	0x1398, 0x1399, 0x139A, 0x139B, 0x139C, 0x139D, 0x139E, 0x139F, 0x13A0, 0x13A1, 	// 0x8133E039
	0x13A2, 0x13A3, 0x13A4, 0x13A5, 0x13A6, 0x13A7, 0x13A8, 0x13A9, 0x13AA, 0x13AB, 	// 0x8133E139
	0x13AC, 0x13AD, 0x13AE, 0x13AF, 0x13B0, 0x13B1, 0x13B2, 0x13B3, 0x13B4, 0x13B5, 	// 0x8133E239
	0x13B6, 0x13B7, 0x13B8, 0x13B9, 0x13BA, 0x13BB, 0x13BC, 0x13BD, 0x13BE, 0x13BF, 	// 0x8133E339
	0x13C0, 0x13C1, 0x13C2, 0x13C3, 0x13C4, 0x13C5, 0x13C6, 0x13C7, 0x13C8, 0x13C9, 	// 0x8133E439
	0x13CA, 0x13CB, 0x13CC, 0x13CD, 0x13CE, 0x13CF, 0x13D0, 0x13D1, 0x13D2, 0x13D3, 	// 0x8133E539
	0x13D4, 0x13D5, 0x13D6, 0x13D7, 0x13D8, 0x13D9, 0x13DA, 0x13DB, 0x13DC, 0x13DD, 	// 0x8133E639
	0x13DE, 0x13DF, 0x13E0, 0x13E1, 0x13E2, 0x13E3, 0x13E4, 0x13E5, 0x13E6, 0x13E7, 	// 0x8133E739
	0x13E8, 0x13E9, 0x13EA, 0x13EB, 0x13EC, 0x13ED, 0x13EE, 0x13EF, 0x13F0, 0x13F1, 	// 0x8133E839
	0x13F2, 0x13F3, 0x13F4, 0x13F5, 0x13F6, 0x13F7, 0x13F8, 0x13F9, 0x13FA, 0x13FB, 	// 0x8133E939
	0x13FC, 0x13FD, 0x13FE, 0x13FF, 0x1400, 0x1401, 0x1402, 0x1403, 0x1404, 0x1405, 	// 0x8133EA39
	0x1406, 0x1407, 0x1408, 0x1409, 0x140A, 0x140B, 0x140C, 0x140D, 0x140E, 0x140F, 	// 0x8133EB39
	0x1410, 0x1411, 0x1412, 0x1413, 0x1414, 0x1415, 0x1416, 0x1417, 0x1418, 0x1419, 	// 0x8133EC39
	0x141A, 0x141B, 0x141C, 0x141D, 0x141E, 0x141F, 0x1420, 0x1421, 0x1422, 0x1423, 	// 0x8133ED39
	0x1424, 0x1425, 0x1426, 0x1427, 0x1428, 0x1429, 0x142A, 0x142B, 0x142C, 0x142D, 	// 0x8133EE39
	0x142E, 0x142F, 0x1430, 0x1431, 0x1432, 0x1433, 0x1434, 0x1435, 0x1436, 0x1437, 	// 0x8133EF39
	0x1438, 0x1439, 0x143A, 0x143B, 0x143C, 0x143D, 0x143E, 0x143F, 0x1440, 0x1441, 	// 0x8133F039
	0x1442, 0x1443, 0x1444, 0x1445, 0x1446, 0x1447, 0x1448, 0x1449, 0x144A, 0x144B, 	// 0x8133F139
	0x144C, 0x144D, 0x144E, 0x144F, 0x1450, 0x1451, 0x1452, 0x1453, 0x1454, 0x1455, 	// 0x8133F239
	0x1456, 0x1457, 0x1458, 0x1459, 0x145A, 0x145B, 0x145C, 0x145D, 0x145E, 0x145F, 	// 0x8133F339
	0x1460, 0x1461, 0x1462, 0x1463, 0x1464, 0x1465, 0x1466, 0x1467, 0x1468, 0x1469, 	// 0x8133F439
	0x146A, 0x146B, 0x146C, 0x146D, 0x146E, 0x146F, 0x1470, 0x1471, 0x1472, 0x1473, 	// 0x8133F539
	0x1474, 0x1475, 0x1476, 0x1477, 0x1478, 0x1479, 0x147A, 0x147B, 0x147C, 0x147D, 	// 0x8133F639
	0x147E, 0x147F, 0x1480, 0x1481, 0x1482, 0x1483, 0x1484, 0x1485, 0x1486, 0x1487, 	// 0x8133F739
	0x1488, 0x1489, 0x148A, 0x148B, 0x148C, 0x148D, 0x148E, 0x148F, 0x1490, 0x1491, 	// 0x8133F839
	0x1492, 0x1493, 0x1494, 0x1495, 0x1496, 0x1497, 0x1498, 0x1499, 0x149A, 0x149B, 	// 0x8133F939
	0x149C, 0x149D, 0x149E, 0x149F, 0x14A0, 0x14A1, 0x14A2, 0x14A3, 0x14A4, 0x14A5, 	// 0x8133FA39
	0x14A6, 0x14A7, 0x14A8, 0x14A9, 0x14AA, 0x14AB, 0x14AC, 0x14AD, 0x14AE, 0x14AF, 	// 0x8133FB39
	0x14B0, 0x14B1, 0x14B2, 0x14B3, 0x14B4, 0x14B5, 0x14B6, 0x14B7, 0x14B8, 0x14B9, 	// 0x8133FC39
	0x14BA, 0x14BB, 0x14BC, 0x14BD, 0x14BE, 0x14BF, 0x14C0, 0x14C1, 0x14C2, 0x14C3, 	// 0x8133FD39
	0x14C4, 0x14C5, 0x14C6, 0x14C7, 0x14C8, 0x14C9, 0x14CA, 0x14CB, 0x14CC, 0x14CD, 	// 0x8133FE39
	0x14CE, 0x14CF, 0x14D0, 0x14D1, 0x14D2, 0x14D3, 0x14D4, 0x14D5, 0x14D6, 0x14D7, 	// 0x81348139
	0x14D8, 0x14D9, 0x14DA, 0x14DB, 0x14DC, 0x14DD, 0x14DE, 0x14DF, 0x14E0, 0x14E1, 	// 0x81348239
	0x14E2, 0x14E3, 0x14E4, 0x14E5, 0x14E6, 0x14E7, 0x14E8, 0x14E9, 0x14EA, 0x14EB, 	// 0x81348339
	0x14EC, 0x14ED, 0x14EE, 0x14EF, 0x14F0, 0x14F1, 0x14F2, 0x14F3, 0x14F4, 0x14F5, 	// 0x81348439
	0x14F6, 0x14F7, 0x14F8, 0x14F9, 0x14FA, 0x14FB, 0x14FC, 0x14FD, 0x14FE, 0x14FF, 	// 0x81348539
	0x1500, 0x1501, 0x1502, 0x1503, 0x1504, 0x1505, 0x1506, 0x1507, 0x1508, 0x1509, 	// 0x81348639
	0x150A, 0x150B, 0x150C, 0x150D, 0x150E, 0x150F, 0x1510, 0x1511, 0x1512, 0x1513, 	// 0x81348739
	0x1514, 0x1515, 0x1516, 0x1517, 0x1518, 0x1519, 0x151A, 0x151B, 0x151C, 0x151D, 	// 0x81348839
	0x151E, 0x151F, 0x1520, 0x1521, 0x1522, 0x1523, 0x1524, 0x1525, 0x1526, 0x1527, 	// 0x81348939
	0x1528, 0x1529, 0x152A, 0x152B, 0x152C, 0x152D, 0x152E, 0x152F, 0x1530, 0x1531, 	// 0x81348A39
	0x1532, 0x1533, 0x1534, 0x1535, 0x1536, 0x1537, 0x1538, 0x1539, 0x153A, 0x153B, 	// 0x81348B39
	0x153C, 0x153D, 0x153E, 0x153F, 0x1540, 0x1541, 0x1542, 0x1543, 0x1544, 0x1545, 	// 0x81348C39
	0x1546, 0x1547, 0x1548, 0x1549, 0x154A, 0x154B, 0x154C, 0x154D, 0x154E, 0x154F, 	// 0x81348D39
	0x1550, 0x1551, 0x1552, 0x1553, 0x1554, 0x1555, 0x1556, 0x1557, 0x1558, 0x1559, 	// 0x81348E39
	0x155A, 0x155B, 0x155C, 0x155D, 0x155E, 0x155F, 0x1560, 0x1561, 0x1562, 0x1563, 	// 0x81348F39
	0x1564, 0x1565, 0x1566, 0x1567, 0x1568, 0x1569, 0x156A, 0x156B, 0x156C, 0x156D, 	// 0x81349039
	0x156E, 0x156F, 0x1570, 0x1571, 0x1572, 0x1573, 0x1574, 0x1575, 0x1576, 0x1577, 	// 0x81349139
	0x1578, 0x1579, 0x157A, 0x157B, 0x157C, 0x157D, 0x157E, 0x157F, 0x1580, 0x1581, 	// 0x81349239
	0x1582, 0x1583, 0x1584, 0x1585, 0x1586, 0x1587, 0x1588, 0x1589, 0x158A, 0x158B, 	// 0x81349339
	0x158C, 0x158D, 0x158E, 0x158F, 0x1590, 0x1591, 0x1592, 0x1593, 0x1594, 0x1595, 	// 0x81349439
	0x1596, 0x1597, 0x1598, 0x1599, 0x159A, 0x159B, 0x159C, 0x159D, 0x159E, 0x159F, 	// 0x81349539
	0x15A0, 0x15A1, 0x15A2, 0x15A3, 0x15A4, 0x15A5, 0x15A6, 0x15A7, 0x15A8, 0x15A9, 	// 0x81349639
	0x15AA, 0x15AB, 0x15AC, 0x15AD, 0x15AE, 0x15AF, 0x15B0, 0x15B1, 0x15B2, 0x15B3, 	// 0x81349739
	0x15B4, 0x15B5, 0x15B6, 0x15B7, 0x15B8, 0x15B9, 0x15BA, 0x15BB, 0x15BC, 0x15BD, 	// 0x81349839
	0x15BE, 0x15BF, 0x15C0, 0x15C1, 0x15C2, 0x15C3, 0x15C4, 0x15C5, 0x15C6, 0x15C7, 	// 0x81349939
	0x15C8, 0x15C9, 0x15CA, 0x15CB, 0x15CC, 0x15CD, 0x15CE, 0x15CF, 0x15D0, 0x15D1, 	// 0x81349A39
	0x15D2, 0x15D3, 0x15D4, 0x15D5, 0x15D6, 0x15D7, 0x15D8, 0x15D9, 0x15DA, 0x15DB, 	// 0x81349B39
	0x15DC, 0x15DD, 0x15DE, 0x15DF, 0x15E0, 0x15E1, 0x15E2, 0x15E3, 0x15E4, 0x15E5, 	// 0x81349C39
	0x15E6, 0x15E7, 0x15E8, 0x15E9, 0x15EA, 0x15EB, 0x15EC, 0x15ED, 0x15EE, 0x15EF, 	// 0x81349D39
	0x15F0, 0x15F1, 0x15F2, 0x15F3, 0x15F4, 0x15F5, 0x15F6, 0x15F7, 0x15F8, 0x15F9, 	// 0x81349E39
	0x15FA, 0x15FB, 0x15FC, 0x15FD, 0x15FE, 0x15FF, 0x1600, 0x1601, 0x1602, 0x1603, 	// 0x81349F39
	0x1604, 0x1605, 0x1606, 0x1607, 0x1608, 0x1609, 0x160A, 0x160B, 0x160C, 0x160D, 	// 0x8134A039
	0x160E, 0x160F, 0x1610, 0x1611, 0x1612, 0x1613, 0x1614, 0x1615, 0x1616, 0x1617, 	// 0x8134A139
	0x1618, 0x1619, 0x161A, 0x161B, 0x161C, 0x161D, 0x161E, 0x161F, 0x1620, 0x1621, 	// 0x8134A239
	0x1622, 0x1623, 0x1624, 0x1625, 0x1626, 0x1627, 0x1628, 0x1629, 0x162A, 0x162B, 	// 0x8134A339
	0x162C, 0x162D, 0x162E, 0x162F, 0x1630, 0x1631, 0x1632, 0x1633, 0x1634, 0x1635, 	// 0x8134A439
	0x1636, 0x1637, 0x1638, 0x1639, 0x163A, 0x163B, 0x163C, 0x163D, 0x163E, 0x163F, 	// 0x8134A539
	0x1640, 0x1641, 0x1642, 0x1643, 0x1644, 0x1645, 0x1646, 0x1647, 0x1648, 0x1649, 	// 0x8134A639
	0x164A, 0x164B, 0x164C, 0x164D, 0x164E, 0x164F, 0x1650, 0x1651, 0x1652, 0x1653, 	// 0x8134A739
	0x1654, 0x1655, 0x1656, 0x1657, 0x1658, 0x1659, 0x165A, 0x165B, 0x165C, 0x165D, 	// 0x8134A839
	0x165E, 0x165F, 0x1660, 0x1661, 0x1662, 0x1663, 0x1664, 0x1665, 0x1666, 0x1667, 	// 0x8134A939
	0x1668, 0x1669, 0x166A, 0x166B, 0x166C, 0x166D, 0x166E, 0x166F, 0x1670, 0x1671, 	// 0x8134AA39
	0x1672, 0x1673, 0x1674, 0x1675, 0x1676, 0x1677, 0x1678, 0x1679, 0x167A, 0x167B, 	// 0x8134AB39
	0x167C, 0x167D, 0x167E, 0x167F, 0x1680, 0x1681, 0x1682, 0x1683, 0x1684, 0x1685, 	// 0x8134AC39
	0x1686, 0x1687, 0x1688, 0x1689, 0x168A, 0x168B, 0x168C, 0x168D, 0x168E, 0x168F, 	// 0x8134AD39
	0x1690, 0x1691, 0x1692, 0x1693, 0x1694, 0x1695, 0x1696, 0x1697, 0x1698, 0x1699, 	// 0x8134AE39
	0x169A, 0x169B, 0x169C, 0x169D, 0x169E, 0x169F, 0x16A0, 0x16A1, 0x16A2, 0x16A3, 	// 0x8134AF39
	0x16A4, 0x16A5, 0x16A6, 0x16A7, 0x16A8, 0x16A9, 0x16AA, 0x16AB, 0x16AC, 0x16AD, 	// 0x8134B039
	0x16AE, 0x16AF, 0x16B0, 0x16B1, 0x16B2, 0x16B3, 0x16B4, 0x16B5, 0x16B6, 0x16B7, 	// 0x8134B139
	0x16B8, 0x16B9, 0x16BA, 0x16BB, 0x16BC, 0x16BD, 0x16BE, 0x16BF, 0x16C0, 0x16C1, 	// 0x8134B239
	0x16C2, 0x16C3, 0x16C4, 0x16C5, 0x16C6, 0x16C7, 0x16C8, 0x16C9, 0x16CA, 0x16CB, 	// 0x8134B339
	0x16CC, 0x16CD, 0x16CE, 0x16CF, 0x16D0, 0x16D1, 0x16D2, 0x16D3, 0x16D4, 0x16D5, 	// 0x8134B439
	0x16D6, 0x16D7, 0x16D8, 0x16D9, 0x16DA, 0x16DB, 0x16DC, 0x16DD, 0x16DE, 0x16DF, 	// 0x8134B539
	0x16E0, 0x16E1, 0x16E2, 0x16E3, 0x16E4, 0x16E5, 0x16E6, 0x16E7, 0x16E8, 0x16E9, 	// 0x8134B639
	0x16EA, 0x16EB, 0x16EC, 0x16ED, 0x16EE, 0x16EF, 0x16F0, 0x16F1, 0x16F2, 0x16F3, 	// 0x8134B739
	0x16F4, 0x16F5, 0x16F6, 0x16F7, 0x16F8, 0x16F9, 0x16FA, 0x16FB, 0x16FC, 0x16FD, 	// 0x8134B839
	0x16FE, 0x16FF, 0x1700, 0x1701, 0x1702, 0x1703, 0x1704, 0x1705, 0x1706, 0x1707, 	// 0x8134B939
	0x1708, 0x1709, 0x170A, 0x170B, 0x170C, 0x170D, 0x170E, 0x170F, 0x1710, 0x1711, 	// 0x8134BA39
	0x1712, 0x1713, 0x1714, 0x1715, 0x1716, 0x1717, 0x1718, 0x1719, 0x171A, 0x171B, 	// 0x8134BB39
	0x171C, 0x171D, 0x171E, 0x171F, 0x1720, 0x1721, 0x1722, 0x1723, 0x1724, 0x1725, 	// 0x8134BC39
	0x1726, 0x1727, 0x1728, 0x1729, 0x172A, 0x172B, 0x172C, 0x172D, 0x172E, 0x172F, 	// 0x8134BD39
	0x1730, 0x1731, 0x1732, 0x1733, 0x1734, 0x1735, 0x1736, 0x1737, 0x1738, 0x1739, 	// 0x8134BE39
	0x173A, 0x173B, 0x173C, 0x173D, 0x173E, 0x173F, 0x1740, 0x1741, 0x1742, 0x1743, 	// 0x8134BF39
	0x1744, 0x1745, 0x1746, 0x1747, 0x1748, 0x1749, 0x174A, 0x174B, 0x174C, 0x174D, 	// 0x8134C039
	0x174E, 0x174F, 0x1750, 0x1751, 0x1752, 0x1753, 0x1754, 0x1755, 0x1756, 0x1757, 	// 0x8134C139
	0x1758, 0x1759, 0x175A, 0x175B, 0x175C, 0x175D, 0x175E, 0x175F, 0x1760, 0x1761, 	// 0x8134C239
	0x1762, 0x1763, 0x1764, 0x1765, 0x1766, 0x1767, 0x1768, 0x1769, 0x176A, 0x176B, 	// 0x8134C339
	0x176C, 0x176D, 0x176E, 0x176F, 0x1770, 0x1771, 0x1772, 0x1773, 0x1774, 0x1775, 	// 0x8134C439
	0x1776, 0x1777, 0x1778, 0x1779, 0x177A, 0x177B, 0x177C, 0x177D, 0x177E, 0x177F, 	// 0x8134C539
	0x1780, 0x1781, 0x1782, 0x1783, 0x1784, 0x1785, 0x1786, 0x1787, 0x1788, 0x1789, 	// 0x8134C639
	0x178A, 0x178B, 0x178C, 0x178D, 0x178E, 0x178F, 0x1790, 0x1791, 0x1792, 0x1793, 	// 0x8134C739
	0x1794, 0x1795, 0x1796, 0x1797, 0x1798, 0x1799, 0x179A, 0x179B, 0x179C, 0x179D, 	// 0x8134C839
	0x179E, 0x179F, 0x17A0, 0x17A1, 0x17A2, 0x17A3, 0x17A4, 0x17A5, 0x17A6, 0x17A7, 	// 0x8134C939
	0x17A8, 0x17A9, 0x17AA, 0x17AB, 0x17AC, 0x17AD, 0x17AE, 0x17AF, 0x17B0, 0x17B1, 	// 0x8134CA39
	0x17B2, 0x17B3, 0x17B4, 0x17B5, 0x17B6, 0x17B7, 0x17B8, 0x17B9, 0x17BA, 0x17BB, 	// 0x8134CB39
	0x17BC, 0x17BD, 0x17BE, 0x17BF, 0x17C0, 0x17C1, 0x17C2, 0x17C3, 0x17C4, 0x17C5, 	// 0x8134CC39
	0x17C6, 0x17C7, 0x17C8, 0x17C9, 0x17CA, 0x17CB, 0x17CC, 0x17CD, 0x17CE, 0x17CF, 	// 0x8134CD39
	0x17D0, 0x17D1, 0x17D2, 0x17D3, 0x17D4, 0x17D5, 0x17D6, 0x17D7, 0x17D8, 0x17D9, 	// 0x8134CE39
	0x17DA, 0x17DB, 0x17DC, 0x17DD, 0x17DE, 0x17DF, 0x17E0, 0x17E1, 0x17E2, 0x17E3, 	// 0x8134CF39
	0x17E4, 0x17E5, 0x17E6, 0x17E7, 0x17E8, 0x17E9, 0x17EA, 0x17EB, 0x17EC, 0x17ED, 	// 0x8134D039
	0x17EE, 0x17EF, 0x17F0, 0x17F1, 0x17F2, 0x17F3, 0x17F4, 0x17F5, 0x17F6, 0x17F7, 	// 0x8134D139
	0x17F8, 0x17F9, 0x17FA, 0x17FB, 0x17FC, 0x17FD, 0x17FE, 0x17FF, 0x1800, 0x1801, 	// 0x8134D239
	0x1802, 0x1803, 0x1804, 0x1805, 0x1806, 0x1807, 0x1808, 0x1809, 0x180A, 0x180B, 	// 0x8134D339
	0x180C, 0x180D, 0x180E, 0x180F, 0x1810, 0x1811, 0x1812, 0x1813, 0x1814, 0x1815, 	// 0x8134D439
	0x1816, 0x1817, 0x1818, 0x1819, 0x181A, 0x181B, 0x181C, 0x181D, 0x181E, 0x181F, 	// 0x8134D539
	0x1820, 0x1821, 0x1822, 0x1823, 0x1824, 0x1825, 0x1826, 0x1827, 0x1828, 0x1829, 	// 0x8134D639
	0x182A, 0x182B, 0x182C, 0x182D, 0x182E, 0x182F, 0x1830, 0x1831, 0x1832, 0x1833, 	// 0x8134D739
	0x1834, 0x1835, 0x1836, 0x1837, 0x1838, 0x1839, 0x183A, 0x183B, 0x183C, 0x183D, 	// 0x8134D839
	0x183E, 0x183F, 0x1840, 0x1841, 0x1842, 0x1843, 0x1844, 0x1845, 0x1846, 0x1847, 	// 0x8134D939
	0x1848, 0x1849, 0x184A, 0x184B, 0x184C, 0x184D, 0x184E, 0x184F, 0x1850, 0x1851, 	// 0x8134DA39
	0x1852, 0x1853, 0x1854, 0x1855, 0x1856, 0x1857, 0x1858, 0x1859, 0x185A, 0x185B, 	// 0x8134DB39
	0x185C, 0x185D, 0x185E, 0x185F, 0x1860, 0x1861, 0x1862, 0x1863, 0x1864, 0x1865, 	// 0x8134DC39
	0x1866, 0x1867, 0x1868, 0x1869, 0x186A, 0x186B, 0x186C, 0x186D, 0x186E, 0x186F, 	// 0x8134DD39
	0x1870, 0x1871, 0x1872, 0x1873, 0x1874, 0x1875, 0x1876, 0x1877, 0x1878, 0x1879, 	// 0x8134DE39
	0x187A, 0x187B, 0x187C, 0x187D, 0x187E, 0x187F, 0x1880, 0x1881, 0x1882, 0x1883, 	// 0x8134DF39
	0x1884, 0x1885, 0x1886, 0x1887, 0x1888, 0x1889, 0x188A, 0x188B, 0x188C, 0x188D, 	// 0x8134E039
	0x188E, 0x188F, 0x1890, 0x1891, 0x1892, 0x1893, 0x1894, 0x1895, 0x1896, 0x1897, 	// 0x8134E139
	0x1898, 0x1899, 0x189A, 0x189B, 0x189C, 0x189D, 0x189E, 0x189F, 0x18A0, 0x18A1, 	// 0x8134E239
	0x18A2, 0x18A3, 0x18A4, 0x18A5, 0x18A6, 0x18A7, 0x18A8, 0x18A9, 0x18AA, 0x18AB, 	// 0x8134E339
	0x18AC, 0x18AD, 0x18AE, 0x18AF, 0x18B0, 0x18B1, 0x18B2, 0x18B3, 0x18B4, 0x18B5, 	// 0x8134E439
	0x18B6, 0x18B7, 0x18B8, 0x18B9, 0x18BA, 0x18BB, 0x18BC, 0x18BD, 0x18BE, 0x18BF, 	// 0x8134E539
	0x18C0, 0x18C1, 0x18C2, 0x18C3, 0x18C4, 0x18C5, 0x18C6, 0x18C7, 0x18C8, 0x18C9, 	// 0x8134E639
	0x18CA, 0x18CB, 0x18CC, 0x18CD, 0x18CE, 0x18CF, 0x18D0, 0x18D1, 0x18D2, 0x18D3, 	// 0x8134E739
	0x18D4, 0x18D5, 0x18D6, 0x18D7, 0x18D8, 0x18D9, 0x18DA, 0x18DB, 0x18DC, 0x18DD, 	// 0x8134E839
	0x18DE, 0x18DF, 0x18E0, 0x18E1, 0x18E2, 0x18E3, 0x18E4, 0x18E5, 0x18E6, 0x18E7, 	// 0x8134E939
	0x18E8, 0x18E9, 0x18EA, 0x18EB, 0x18EC, 0x18ED, 0x18EE, 0x18EF, 0x18F0, 0x18F1, 	// 0x8134EA39
	0x18F2, 0x18F3, 0x18F4, 0x18F5, 0x18F6, 0x18F7, 0x18F8, 0x18F9, 0x18FA, 0x18FB, 	// 0x8134EB39
	0x18FC, 0x18FD, 0x18FE, 0x18FF, 0x1900, 0x1901, 0x1902, 0x1903, 0x1904, 0x1905, 	// 0x8134EC39
	0x1906, 0x1907, 0x1908, 0x1909, 0x190A, 0x190B, 0x190C, 0x190D, 0x190E, 0x190F, 	// 0x8134ED39
	0x1910, 0x1911, 0x1912, 0x1913, 0x1914, 0x1915, 0x1916, 0x1917, 0x1918, 0x1919, 	// 0x8134EE39
	0x191A, 0x191B, 0x191C, 0x191D, 0x191E, 0x191F, 0x1920, 0x1921, 0x1922, 0x1923, 	// 0x8134EF39
	0x1924, 0x1925, 0x1926, 0x1927, 0x1928, 0x1929, 0x192A, 0x192B, 0x192C, 0x192D, 	// 0x8134F039
	0x192E, 0x192F, 0x1930, 0x1931, 0x1932, 0x1933, 0x1934, 0x1935, 0x1936, 0x1937, 	// 0x8134F139
	0x1938, 0x1939, 0x193A, 0x193B, 0x193C, 0x193D, 0x193E, 0x193F, 0x1940, 0x1941, 	// 0x8134F239
	0x1942, 0x1943, 0x1944, 0x1945, 0x1946, 0x1947, 0x1948, 0x1949, 0x194A, 0x194B, 	// 0x8134F339
	0x194C, 0x194D, 0x194E, 0x194F, 0x1950, 0x1951, 0x1952, 0x1953, 0x1954, 0x1955, 	// 0x8134F439
	0x1956, 0x1957, 0x1958, 0x1959, 0x195A, 0x195B, 0x195C, 0x195D, 0x195E, 0x195F, 	// 0x8134F539
	0x1960, 0x1961, 0x1962, 0x1963, 0x1964, 0x1965, 0x1966, 0x1967, 0x1968, 0x1969, 	// 0x8134F639
	0x196A, 0x196B, 0x196C, 0x196D, 0x196E, 0x196F, 0x1970, 0x1971, 0x1972, 0x1973, 	// 0x8134F739
	0x1974, 0x1975, 0x1976, 0x1977, 0x1978, 0x1979, 0x197A, 0x197B, 0x197C, 0x197D, 	// 0x8134F839
	0x197E, 0x197F, 0x1980, 0x1981, 0x1982, 0x1983, 0x1984, 0x1985, 0x1986, 0x1987, 	// 0x8134F939
	0x1988, 0x1989, 0x198A, 0x198B, 0x198C, 0x198D, 0x198E, 0x198F, 0x1990, 0x1991, 	// 0x8134FA39
	0x1992, 0x1993, 0x1994, 0x1995, 0x1996, 0x1997, 0x1998, 0x1999, 0x199A, 0x199B, 	// 0x8134FB39
	0x199C, 0x199D, 0x199E, 0x199F, 0x19A0, 0x19A1, 0x19A2, 0x19A3, 0x19A4, 0x19A5, 	// 0x8134FC39
	0x19A6, 0x19A7, 0x19A8, 0x19A9, 0x19AA, 0x19AB, 0x19AC, 0x19AD, 0x19AE, 0x19AF, 	// 0x8134FD39
	0x19B0, 0x19B1, 0x19B2, 0x19B3, 0x19B4, 0x19B5, 0x19B6, 0x19B7, 0x19B8, 0x19B9, 	// 0x8134FE39
	0x19BA, 0x19BB, 0x19BC, 0x19BD, 0x19BE, 0x19BF, 0x19C0, 0x19C1, 0x19C2, 0x19C3, 	// 0x81358139
	0x19C4, 0x19C5, 0x19C6, 0x19C7, 0x19C8, 0x19C9, 0x19CA, 0x19CB, 0x19CC, 0x19CD, 	// 0x81358239
	0x19CE, 0x19CF, 0x19D0, 0x19D1, 0x19D2, 0x19D3, 0x19D4, 0x19D5, 0x19D6, 0x19D7, 	// 0x81358339
	0x19D8, 0x19D9, 0x19DA, 0x19DB, 0x19DC, 0x19DD, 0x19DE, 0x19DF, 0x19E0, 0x19E1, 	// 0x81358439
	0x19E2, 0x19E3, 0x19E4, 0x19E5, 0x19E6, 0x19E7, 0x19E8, 0x19E9, 0x19EA, 0x19EB, 	// 0x81358539
	0x19EC, 0x19ED, 0x19EE, 0x19EF, 0x19F0, 0x19F1, 0x19F2, 0x19F3, 0x19F4, 0x19F5, 	// 0x81358639
	0x19F6, 0x19F7, 0x19F8, 0x19F9, 0x19FA, 0x19FB, 0x19FC, 0x19FD, 0x19FE, 0x19FF, 	// 0x81358739
	0x1A00, 0x1A01, 0x1A02, 0x1A03, 0x1A04, 0x1A05, 0x1A06, 0x1A07, 0x1A08, 0x1A09, 	// 0x81358839
	0x1A0A, 0x1A0B, 0x1A0C, 0x1A0D, 0x1A0E, 0x1A0F, 0x1A10, 0x1A11, 0x1A12, 0x1A13, 	// 0x81358939
	0x1A14, 0x1A15, 0x1A16, 0x1A17, 0x1A18, 0x1A19, 0x1A1A, 0x1A1B, 0x1A1C, 0x1A1D, 	// 0x81358A39
	0x1A1E, 0x1A1F, 0x1A20, 0x1A21, 0x1A22, 0x1A23, 0x1A24, 0x1A25, 0x1A26, 0x1A27, 	// 0x81358B39
	0x1A28, 0x1A29, 0x1A2A, 0x1A2B, 0x1A2C, 0x1A2D, 0x1A2E, 0x1A2F, 0x1A30, 0x1A31, 	// 0x81358C39
	0x1A32, 0x1A33, 0x1A34, 0x1A35, 0x1A36, 0x1A37, 0x1A38, 0x1A39, 0x1A3A, 0x1A3B, 	// 0x81358D39
	0x1A3C, 0x1A3D, 0x1A3E, 0x1A3F, 0x1A40, 0x1A41, 0x1A42, 0x1A43, 0x1A44, 0x1A45, 	// 0x81358E39
	0x1A46, 0x1A47, 0x1A48, 0x1A49, 0x1A4A, 0x1A4B, 0x1A4C, 0x1A4D, 0x1A4E, 0x1A4F, 	// 0x81358F39
	0x1A50, 0x1A51, 0x1A52, 0x1A53, 0x1A54, 0x1A55, 0x1A56, 0x1A57, 0x1A58, 0x1A59, 	// 0x81359039
	0x1A5A, 0x1A5B, 0x1A5C, 0x1A5D, 0x1A5E, 0x1A5F, 0x1A60, 0x1A61, 0x1A62, 0x1A63, 	// 0x81359139
	0x1A64, 0x1A65, 0x1A66, 0x1A67, 0x1A68, 0x1A69, 0x1A6A, 0x1A6B, 0x1A6C, 0x1A6D, 	// 0x81359239
	0x1A6E, 0x1A6F, 0x1A70, 0x1A71, 0x1A72, 0x1A73, 0x1A74, 0x1A75, 0x1A76, 0x1A77, 	// 0x81359339
	0x1A78, 0x1A79, 0x1A7A, 0x1A7B, 0x1A7C, 0x1A7D, 0x1A7E, 0x1A7F, 0x1A80, 0x1A81, 	// 0x81359439
	0x1A82, 0x1A83, 0x1A84, 0x1A85, 0x1A86, 0x1A87, 0x1A88, 0x1A89, 0x1A8A, 0x1A8B, 	// 0x81359539
	0x1A8C, 0x1A8D, 0x1A8E, 0x1A8F, 0x1A90, 0x1A91, 0x1A92, 0x1A93, 0x1A94, 0x1A95, 	// 0x81359639
	0x1A96, 0x1A97, 0x1A98, 0x1A99, 0x1A9A, 0x1A9B, 0x1A9C, 0x1A9D, 0x1A9E, 0x1A9F, 	// 0x81359739
	0x1AA0, 0x1AA1, 0x1AA2, 0x1AA3, 0x1AA4, 0x1AA5, 0x1AA6, 0x1AA7, 0x1AA8, 0x1AA9, 	// 0x81359839
	0x1AAA, 0x1AAB, 0x1AAC, 0x1AAD, 0x1AAE, 0x1AAF, 0x1AB0, 0x1AB1, 0x1AB2, 0x1AB3, 	// 0x81359939
	0x1AB4, 0x1AB5, 0x1AB6, 0x1AB7, 0x1AB8, 0x1AB9, 0x1ABA, 0x1ABB, 0x1ABC, 0x1ABD, 	// 0x81359A39
	0x1ABE, 0x1ABF, 0x1AC0, 0x1AC1, 0x1AC2, 0x1AC3, 0x1AC4, 0x1AC5, 0x1AC6, 0x1AC7, 	// 0x81359B39
	0x1AC8, 0x1AC9, 0x1ACA, 0x1ACB, 0x1ACC, 0x1ACD, 0x1ACE, 0x1ACF, 0x1AD0, 0x1AD1, 	// 0x81359C39
	0x1AD2, 0x1AD3, 0x1AD4, 0x1AD5, 0x1AD6, 0x1AD7, 0x1AD8, 0x1AD9, 0x1ADA, 0x1ADB, 	// 0x81359D39
	0x1ADC, 0x1ADD, 0x1ADE, 0x1ADF, 0x1AE0, 0x1AE1, 0x1AE2, 0x1AE3, 0x1AE4, 0x1AE5, 	// 0x81359E39
	0x1AE6, 0x1AE7, 0x1AE8, 0x1AE9, 0x1AEA, 0x1AEB, 0x1AEC, 0x1AED, 0x1AEE, 0x1AEF, 	// 0x81359F39
	0x1AF0, 0x1AF1, 0x1AF2, 0x1AF3, 0x1AF4, 0x1AF5, 0x1AF6, 0x1AF7, 0x1AF8, 0x1AF9, 	// 0x8135A039
	0x1AFA, 0x1AFB, 0x1AFC, 0x1AFD, 0x1AFE, 0x1AFF, 0x1B00, 0x1B01, 0x1B02, 0x1B03, 	// 0x8135A139
	0x1B04, 0x1B05, 0x1B06, 0x1B07, 0x1B08, 0x1B09, 0x1B0A, 0x1B0B, 0x1B0C, 0x1B0D, 	// 0x8135A239
	0x1B0E, 0x1B0F, 0x1B10, 0x1B11, 0x1B12, 0x1B13, 0x1B14, 0x1B15, 0x1B16, 0x1B17, 	// 0x8135A339
	0x1B18, 0x1B19, 0x1B1A, 0x1B1B, 0x1B1C, 0x1B1D, 0x1B1E, 0x1B1F, 0x1B20, 0x1B21, 	// 0x8135A439
	0x1B22, 0x1B23, 0x1B24, 0x1B25, 0x1B26, 0x1B27, 0x1B28, 0x1B29, 0x1B2A, 0x1B2B, 	// 0x8135A539
	0x1B2C, 0x1B2D, 0x1B2E, 0x1B2F, 0x1B30, 0x1B31, 0x1B32, 0x1B33, 0x1B34, 0x1B35, 	// 0x8135A639
	0x1B36, 0x1B37, 0x1B38, 0x1B39, 0x1B3A, 0x1B3B, 0x1B3C, 0x1B3D, 0x1B3E, 0x1B3F, 	// 0x8135A739
	0x1B40, 0x1B41, 0x1B42, 0x1B43, 0x1B44, 0x1B45, 0x1B46, 0x1B47, 0x1B48, 0x1B49, 	// 0x8135A839
	0x1B4A, 0x1B4B, 0x1B4C, 0x1B4D, 0x1B4E, 0x1B4F, 0x1B50, 0x1B51, 0x1B52, 0x1B53, 	// 0x8135A939
	0x1B54, 0x1B55, 0x1B56, 0x1B57, 0x1B58, 0x1B59, 0x1B5A, 0x1B5B, 0x1B5C, 0x1B5D, 	// 0x8135AA39
	0x1B5E, 0x1B5F, 0x1B60, 0x1B61, 0x1B62, 0x1B63, 0x1B64, 0x1B65, 0x1B66, 0x1B67, 	// 0x8135AB39
	0x1B68, 0x1B69, 0x1B6A, 0x1B6B, 0x1B6C, 0x1B6D, 0x1B6E, 0x1B6F, 0x1B70, 0x1B71, 	// 0x8135AC39
	0x1B72, 0x1B73, 0x1B74, 0x1B75, 0x1B76, 0x1B77, 0x1B78, 0x1B79, 0x1B7A, 0x1B7B, 	// 0x8135AD39
	0x1B7C, 0x1B7D, 0x1B7E, 0x1B7F, 0x1B80, 0x1B81, 0x1B82, 0x1B83, 0x1B84, 0x1B85, 	// 0x8135AE39
	0x1B86, 0x1B87, 0x1B88, 0x1B89, 0x1B8A, 0x1B8B, 0x1B8C, 0x1B8D, 0x1B8E, 0x1B8F, 	// 0x8135AF39
	0x1B90, 0x1B91, 0x1B92, 0x1B93, 0x1B94, 0x1B95, 0x1B96, 0x1B97, 0x1B98, 0x1B99, 	// 0x8135B039
	0x1B9A, 0x1B9B, 0x1B9C, 0x1B9D, 0x1B9E, 0x1B9F, 0x1BA0, 0x1BA1, 0x1BA2, 0x1BA3, 	// 0x8135B139
	0x1BA4, 0x1BA5, 0x1BA6, 0x1BA7, 0x1BA8, 0x1BA9, 0x1BAA, 0x1BAB, 0x1BAC, 0x1BAD, 	// 0x8135B239
	0x1BAE, 0x1BAF, 0x1BB0, 0x1BB1, 0x1BB2, 0x1BB3, 0x1BB4, 0x1BB5, 0x1BB6, 0x1BB7, 	// 0x8135B339
	0x1BB8, 0x1BB9, 0x1BBA, 0x1BBB, 0x1BBC, 0x1BBD, 0x1BBE, 0x1BBF, 0x1BC0, 0x1BC1, 	// 0x8135B439
	0x1BC2, 0x1BC3, 0x1BC4, 0x1BC5, 0x1BC6, 0x1BC7, 0x1BC8, 0x1BC9, 0x1BCA, 0x1BCB, 	// 0x8135B539
	0x1BCC, 0x1BCD, 0x1BCE, 0x1BCF, 0x1BD0, 0x1BD1, 0x1BD2, 0x1BD3, 0x1BD4, 0x1BD5, 	// 0x8135B639
	0x1BD6, 0x1BD7, 0x1BD8, 0x1BD9, 0x1BDA, 0x1BDB, 0x1BDC, 0x1BDD, 0x1BDE, 0x1BDF, 	// 0x8135B739
	0x1BE0, 0x1BE1, 0x1BE2, 0x1BE3, 0x1BE4, 0x1BE5, 0x1BE6, 0x1BE7, 0x1BE8, 0x1BE9, 	// 0x8135B839
	0x1BEA, 0x1BEB, 0x1BEC, 0x1BED, 0x1BEE, 0x1BEF, 0x1BF0, 0x1BF1, 0x1BF2, 0x1BF3, 	// 0x8135B939
	0x1BF4, 0x1BF5, 0x1BF6, 0x1BF7, 0x1BF8, 0x1BF9, 0x1BFA, 0x1BFB, 0x1BFC, 0x1BFD, 	// 0x8135BA39
	0x1BFE, 0x1BFF, 0x1C00, 0x1C01, 0x1C02, 0x1C03, 0x1C04, 0x1C05, 0x1C06, 0x1C07, 	// 0x8135BB39
	0x1C08, 0x1C09, 0x1C0A, 0x1C0B, 0x1C0C, 0x1C0D, 0x1C0E, 0x1C0F, 0x1C10, 0x1C11, 	// 0x8135BC39
	0x1C12, 0x1C13, 0x1C14, 0x1C15, 0x1C16, 0x1C17, 0x1C18, 0x1C19, 0x1C1A, 0x1C1B, 	// 0x8135BD39
	0x1C1C, 0x1C1D, 0x1C1E, 0x1C1F, 0x1C20, 0x1C21, 0x1C22, 0x1C23, 0x1C24, 0x1C25, 	// 0x8135BE39
	0x1C26, 0x1C27, 0x1C28, 0x1C29, 0x1C2A, 0x1C2B, 0x1C2C, 0x1C2D, 0x1C2E, 0x1C2F, 	// 0x8135BF39
	0x1C30, 0x1C31, 0x1C32, 0x1C33, 0x1C34, 0x1C35, 0x1C36, 0x1C37, 0x1C38, 0x1C39, 	// 0x8135C039
	0x1C3A, 0x1C3B, 0x1C3C, 0x1C3D, 0x1C3E, 0x1C3F, 0x1C40, 0x1C41, 0x1C42, 0x1C43, 	// 0x8135C139
	0x1C44, 0x1C45, 0x1C46, 0x1C47, 0x1C48, 0x1C49, 0x1C4A, 0x1C4B, 0x1C4C, 0x1C4D, 	// 0x8135C239
	0x1C4E, 0x1C4F, 0x1C50, 0x1C51, 0x1C52, 0x1C53, 0x1C54, 0x1C55, 0x1C56, 0x1C57, 	// 0x8135C339
	0x1C58, 0x1C59, 0x1C5A, 0x1C5B, 0x1C5C, 0x1C5D, 0x1C5E, 0x1C5F, 0x1C60, 0x1C61, 	// 0x8135C439
	0x1C62, 0x1C63, 0x1C64, 0x1C65, 0x1C66, 0x1C67, 0x1C68, 0x1C69, 0x1C6A, 0x1C6B, 	// 0x8135C539
	0x1C6C, 0x1C6D, 0x1C6E, 0x1C6F, 0x1C70, 0x1C71, 0x1C72, 0x1C73, 0x1C74, 0x1C75, 	// 0x8135C639
	0x1C76, 0x1C77, 0x1C78, 0x1C79, 0x1C7A, 0x1C7B, 0x1C7C, 0x1C7D, 0x1C7E, 0x1C7F, 	// 0x8135C739
	0x1C80, 0x1C81, 0x1C82, 0x1C83, 0x1C84, 0x1C85, 0x1C86, 0x1C87, 0x1C88, 0x1C89, 	// 0x8135C839
	0x1C8A, 0x1C8B, 0x1C8C, 0x1C8D, 0x1C8E, 0x1C8F, 0x1C90, 0x1C91, 0x1C92, 0x1C93, 	// 0x8135C939
	0x1C94, 0x1C95, 0x1C96, 0x1C97, 0x1C98, 0x1C99, 0x1C9A, 0x1C9B, 0x1C9C, 0x1C9D, 	// 0x8135CA39
	0x1C9E, 0x1C9F, 0x1CA0, 0x1CA1, 0x1CA2, 0x1CA3, 0x1CA4, 0x1CA5, 0x1CA6, 0x1CA7, 	// 0x8135CB39
	0x1CA8, 0x1CA9, 0x1CAA, 0x1CAB, 0x1CAC, 0x1CAD, 0x1CAE, 0x1CAF, 0x1CB0, 0x1CB1, 	// 0x8135CC39
	0x1CB2, 0x1CB3, 0x1CB4, 0x1CB5, 0x1CB6, 0x1CB7, 0x1CB8, 0x1CB9, 0x1CBA, 0x1CBB, 	// 0x8135CD39
	0x1CBC, 0x1CBD, 0x1CBE, 0x1CBF, 0x1CC0, 0x1CC1, 0x1CC2, 0x1CC3, 0x1CC4, 0x1CC5, 	// 0x8135CE39
	0x1CC6, 0x1CC7, 0x1CC8, 0x1CC9, 0x1CCA, 0x1CCB, 0x1CCC, 0x1CCD, 0x1CCE, 0x1CCF, 	// 0x8135CF39
	0x1CD0, 0x1CD1, 0x1CD2, 0x1CD3, 0x1CD4, 0x1CD5, 0x1CD6, 0x1CD7, 0x1CD8, 0x1CD9, 	// 0x8135D039
	0x1CDA, 0x1CDB, 0x1CDC, 0x1CDD, 0x1CDE, 0x1CDF, 0x1CE0, 0x1CE1, 0x1CE2, 0x1CE3, 	// 0x8135D139
	0x1CE4, 0x1CE5, 0x1CE6, 0x1CE7, 0x1CE8, 0x1CE9, 0x1CEA, 0x1CEB, 0x1CEC, 0x1CED, 	// 0x8135D239
	0x1CEE, 0x1CEF, 0x1CF0, 0x1CF1, 0x1CF2, 0x1CF3, 0x1CF4, 0x1CF5, 0x1CF6, 0x1CF7, 	// 0x8135D339
	0x1CF8, 0x1CF9, 0x1CFA, 0x1CFB, 0x1CFC, 0x1CFD, 0x1CFE, 0x1CFF, 0x1D00, 0x1D01, 	// 0x8135D439
	0x1D02, 0x1D03, 0x1D04, 0x1D05, 0x1D06, 0x1D07, 0x1D08, 0x1D09, 0x1D0A, 0x1D0B, 	// 0x8135D539
	0x1D0C, 0x1D0D, 0x1D0E, 0x1D0F, 0x1D10, 0x1D11, 0x1D12, 0x1D13, 0x1D14, 0x1D15, 	// 0x8135D639
	0x1D16, 0x1D17, 0x1D18, 0x1D19, 0x1D1A, 0x1D1B, 0x1D1C, 0x1D1D, 0x1D1E, 0x1D1F, 	// 0x8135D739
	0x1D20, 0x1D21, 0x1D22, 0x1D23, 0x1D24, 0x1D25, 0x1D26, 0x1D27, 0x1D28, 0x1D29, 	// 0x8135D839
	0x1D2A, 0x1D2B, 0x1D2C, 0x1D2D, 0x1D2E, 0x1D2F, 0x1D30, 0x1D31, 0x1D32, 0x1D33, 	// 0x8135D939
	0x1D34, 0x1D35, 0x1D36, 0x1D37, 0x1D38, 0x1D39, 0x1D3A, 0x1D3B, 0x1D3C, 0x1D3D, 	// 0x8135DA39
	0x1D3E, 0x1D3F, 0x1D40, 0x1D41, 0x1D42, 0x1D43, 0x1D44, 0x1D45, 0x1D46, 0x1D47, 	// 0x8135DB39
	0x1D48, 0x1D49, 0x1D4A, 0x1D4B, 0x1D4C, 0x1D4D, 0x1D4E, 0x1D4F, 0x1D50, 0x1D51, 	// 0x8135DC39
	0x1D52, 0x1D53, 0x1D54, 0x1D55, 0x1D56, 0x1D57, 0x1D58, 0x1D59, 0x1D5A, 0x1D5B, 	// 0x8135DD39
	0x1D5C, 0x1D5D, 0x1D5E, 0x1D5F, 0x1D60, 0x1D61, 0x1D62, 0x1D63, 0x1D64, 0x1D65, 	// 0x8135DE39
	0x1D66, 0x1D67, 0x1D68, 0x1D69, 0x1D6A, 0x1D6B, 0x1D6C, 0x1D6D, 0x1D6E, 0x1D6F, 	// 0x8135DF39
	0x1D70, 0x1D71, 0x1D72, 0x1D73, 0x1D74, 0x1D75, 0x1D76, 0x1D77, 0x1D78, 0x1D79, 	// 0x8135E039
	0x1D7A, 0x1D7B, 0x1D7C, 0x1D7D, 0x1D7E, 0x1D7F, 0x1D80, 0x1D81, 0x1D82, 0x1D83, 	// 0x8135E139
	0x1D84, 0x1D85, 0x1D86, 0x1D87, 0x1D88, 0x1D89, 0x1D8A, 0x1D8B, 0x1D8C, 0x1D8D, 	// 0x8135E239
	0x1D8E, 0x1D8F, 0x1D90, 0x1D91, 0x1D92, 0x1D93, 0x1D94, 0x1D95, 0x1D96, 0x1D97, 	// 0x8135E339
	0x1D98, 0x1D99, 0x1D9A, 0x1D9B, 0x1D9C, 0x1D9D, 0x1D9E, 0x1D9F, 0x1DA0, 0x1DA1, 	// 0x8135E439
	0x1DA2, 0x1DA3, 0x1DA4, 0x1DA5, 0x1DA6, 0x1DA7, 0x1DA8, 0x1DA9, 0x1DAA, 0x1DAB, 	// 0x8135E539
	0x1DAC, 0x1DAD, 0x1DAE, 0x1DAF, 0x1DB0, 0x1DB1, 0x1DB2, 0x1DB3, 0x1DB4, 0x1DB5, 	// 0x8135E639
	0x1DB6, 0x1DB7, 0x1DB8, 0x1DB9, 0x1DBA, 0x1DBB, 0x1DBC, 0x1DBD, 0x1DBE, 0x1DBF, 	// 0x8135E739
	0x1DC0, 0x1DC1, 0x1DC2, 0x1DC3, 0x1DC4, 0x1DC5, 0x1DC6, 0x1DC7, 0x1DC8, 0x1DC9, 	// 0x8135E839
	0x1DCA, 0x1DCB, 0x1DCC, 0x1DCD, 0x1DCE, 0x1DCF, 0x1DD0, 0x1DD1, 0x1DD2, 0x1DD3, 	// 0x8135E939
	0x1DD4, 0x1DD5, 0x1DD6, 0x1DD7, 0x1DD8, 0x1DD9, 0x1DDA, 0x1DDB, 0x1DDC, 0x1DDD, 	// 0x8135EA39
	0x1DDE, 0x1DDF, 0x1DE0, 0x1DE1, 0x1DE2, 0x1DE3, 0x1DE4, 0x1DE5, 0x1DE6, 0x1DE7, 	// 0x8135EB39
	0x1DE8, 0x1DE9, 0x1DEA, 0x1DEB, 0x1DEC, 0x1DED, 0x1DEE, 0x1DEF, 0x1DF0, 0x1DF1, 	// 0x8135EC39
	0x1DF2, 0x1DF3, 0x1DF4, 0x1DF5, 0x1DF6, 0x1DF7, 0x1DF8, 0x1DF9, 0x1DFA, 0x1DFB, 	// 0x8135ED39
	0x1DFC, 0x1DFD, 0x1DFE, 0x1DFF, 0x1E00, 0x1E01, 0x1E02, 0x1E03, 0x1E04, 0x1E05, 	// 0x8135EE39
	0x1E06, 0x1E07, 0x1E08, 0x1E09, 0x1E0A, 0x1E0B, 0x1E0C, 0x1E0D, 0x1E0E, 0x1E0F, 	// 0x8135EF39
	0x1E10, 0x1E11, 0x1E12, 0x1E13, 0x1E14, 0x1E15, 0x1E16, 0x1E17, 0x1E18, 0x1E19, 	// 0x8135F039
	0x1E1A, 0x1E1B, 0x1E1C, 0x1E1D, 0x1E1E, 0x1E1F, 0x1E20, 0x1E21, 0x1E22, 0x1E23, 	// 0x8135F139
	0x1E24, 0x1E25, 0x1E26, 0x1E27, 0x1E28, 0x1E29, 0x1E2A, 0x1E2B, 0x1E2C, 0x1E2D, 	// 0x8135F239
	0x1E2E, 0x1E2F, 0x1E30, 0x1E31, 0x1E32, 0x1E33, 0x1E34, 0x1E35, 0x1E36, 0x1E37, 	// 0x8135F339
	0x1E38, 0x1E39, 0x1E3A, 0x1E3B, 0x1E3C, 0x1E3D, 0x1E3E, 0xE7C7, 0x1E40, 0x1E41, 	// 0x8135F439
	0x1E42, 0x1E43, 0x1E44, 0x1E45, 0x1E46, 0x1E47, 0x1E48, 0x1E49, 0x1E4A, 0x1E4B, 	// 0x8135F539
	0x1E4C, 0x1E4D, 0x1E4E, 0x1E4F, 0x1E50, 0x1E51, 0x1E52, 0x1E53, 0x1E54, 0x1E55, 	// 0x8135F639
	0x1E56, 0x1E57, 0x1E58, 0x1E59, 0x1E5A, 0x1E5B, 0x1E5C, 0x1E5D, 0x1E5E, 0x1E5F, 	// 0x8135F739
	0x1E60, 0x1E61, 0x1E62, 0x1E63, 0x1E64, 0x1E65, 0x1E66, 0x1E67, 0x1E68, 0x1E69, 	// 0x8135F839
	0x1E6A, 0x1E6B, 0x1E6C, 0x1E6D, 0x1E6E, 0x1E6F, 0x1E70, 0x1E71, 0x1E72, 0x1E73, 	// 0x8135F939
	0x1E74, 0x1E75, 0x1E76, 0x1E77, 0x1E78, 0x1E79, 0x1E7A, 0x1E7B, 0x1E7C, 0x1E7D, 	// 0x8135FA39
	0x1E7E, 0x1E7F, 0x1E80, 0x1E81, 0x1E82, 0x1E83, 0x1E84, 0x1E85, 0x1E86, 0x1E87, 	// 0x8135FB39
	0x1E88, 0x1E89, 0x1E8A, 0x1E8B, 0x1E8C, 0x1E8D, 0x1E8E, 0x1E8F, 0x1E90, 0x1E91, 	// 0x8135FC39
	0x1E92, 0x1E93, 0x1E94, 0x1E95, 0x1E96, 0x1E97, 0x1E98, 0x1E99, 0x1E9A, 0x1E9B, 	// 0x8135FD39
	0x1E9C, 0x1E9D, 0x1E9E, 0x1E9F, 0x1EA0, 0x1EA1, 0x1EA2, 0x1EA3, 0x1EA4, 0x1EA5, 	// 0x8135FE39
	0x1EA6, 0x1EA7, 0x1EA8, 0x1EA9, 0x1EAA, 0x1EAB, 0x1EAC, 0x1EAD, 0x1EAE, 0x1EAF, 	// 0x81368139
	0x1EB0, 0x1EB1, 0x1EB2, 0x1EB3, 0x1EB4, 0x1EB5, 0x1EB6, 0x1EB7, 0x1EB8, 0x1EB9, 	// 0x81368239
	0x1EBA, 0x1EBB, 0x1EBC, 0x1EBD, 0x1EBE, 0x1EBF, 0x1EC0, 0x1EC1, 0x1EC2, 0x1EC3, 	// 0x81368339
	0x1EC4, 0x1EC5, 0x1EC6, 0x1EC7, 0x1EC8, 0x1EC9, 0x1ECA, 0x1ECB, 0x1ECC, 0x1ECD, 	// 0x81368439
	0x1ECE, 0x1ECF, 0x1ED0, 0x1ED1, 0x1ED2, 0x1ED3, 0x1ED4, 0x1ED5, 0x1ED6, 0x1ED7, 	// 0x81368539
	0x1ED8, 0x1ED9, 0x1EDA, 0x1EDB, 0x1EDC, 0x1EDD, 0x1EDE, 0x1EDF, 0x1EE0, 0x1EE1, 	// 0x81368639
	0x1EE2, 0x1EE3, 0x1EE4, 0x1EE5, 0x1EE6, 0x1EE7, 0x1EE8, 0x1EE9, 0x1EEA, 0x1EEB, 	// 0x81368739
	0x1EEC, 0x1EED, 0x1EEE, 0x1EEF, 0x1EF0, 0x1EF1, 0x1EF2, 0x1EF3, 0x1EF4, 0x1EF5, 	// 0x81368839
	0x1EF6, 0x1EF7, 0x1EF8, 0x1EF9, 0x1EFA, 0x1EFB, 0x1EFC, 0x1EFD, 0x1EFE, 0x1EFF, 	// 0x81368939
	0x1F00, 0x1F01, 0x1F02, 0x1F03, 0x1F04, 0x1F05, 0x1F06, 0x1F07, 0x1F08, 0x1F09, 	// 0x81368A39
	0x1F0A, 0x1F0B, 0x1F0C, 0x1F0D, 0x1F0E, 0x1F0F, 0x1F10, 0x1F11, 0x1F12, 0x1F13, 	// 0x81368B39
	0x1F14, 0x1F15, 0x1F16, 0x1F17, 0x1F18, 0x1F19, 0x1F1A, 0x1F1B, 0x1F1C, 0x1F1D, 	// 0x81368C39
	0x1F1E, 0x1F1F, 0x1F20, 0x1F21, 0x1F22, 0x1F23, 0x1F24, 0x1F25, 0x1F26, 0x1F27, 	// 0x81368D39
	0x1F28, 0x1F29, 0x1F2A, 0x1F2B, 0x1F2C, 0x1F2D, 0x1F2E, 0x1F2F, 0x1F30, 0x1F31, 	// 0x81368E39
	0x1F32, 0x1F33, 0x1F34, 0x1F35, 0x1F36, 0x1F37, 0x1F38, 0x1F39, 0x1F3A, 0x1F3B, 	// 0x81368F39
	0x1F3C, 0x1F3D, 0x1F3E, 0x1F3F, 0x1F40, 0x1F41, 0x1F42, 0x1F43, 0x1F44, 0x1F45, 	// 0x81369039
	0x1F46, 0x1F47, 0x1F48, 0x1F49, 0x1F4A, 0x1F4B, 0x1F4C, 0x1F4D, 0x1F4E, 0x1F4F, 	// 0x81369139
	0x1F50, 0x1F51, 0x1F52, 0x1F53, 0x1F54, 0x1F55, 0x1F56, 0x1F57, 0x1F58, 0x1F59, 	// 0x81369239
	0x1F5A, 0x1F5B, 0x1F5C, 0x1F5D, 0x1F5E, 0x1F5F, 0x1F60, 0x1F61, 0x1F62, 0x1F63, 	// 0x81369339
	0x1F64, 0x1F65, 0x1F66, 0x1F67, 0x1F68, 0x1F69, 0x1F6A, 0x1F6B, 0x1F6C, 0x1F6D, 	// 0x81369439
	0x1F6E, 0x1F6F, 0x1F70, 0x1F71, 0x1F72, 0x1F73, 0x1F74, 0x1F75, 0x1F76, 0x1F77, 	// 0x81369539
	0x1F78, 0x1F79, 0x1F7A, 0x1F7B, 0x1F7C, 0x1F7D, 0x1F7E, 0x1F7F, 0x1F80, 0x1F81, 	// 0x81369639
	0x1F82, 0x1F83, 0x1F84, 0x1F85, 0x1F86, 0x1F87, 0x1F88, 0x1F89, 0x1F8A, 0x1F8B, 	// 0x81369739
	0x1F8C, 0x1F8D, 0x1F8E, 0x1F8F, 0x1F90, 0x1F91, 0x1F92, 0x1F93, 0x1F94, 0x1F95, 	// 0x81369839
	0x1F96, 0x1F97, 0x1F98, 0x1F99, 0x1F9A, 0x1F9B, 0x1F9C, 0x1F9D, 0x1F9E, 0x1F9F, 	// 0x81369939
	0x1FA0, 0x1FA1, 0x1FA2, 0x1FA3, 0x1FA4, 0x1FA5, 0x1FA6, 0x1FA7, 0x1FA8, 0x1FA9, 	// 0x81369A39
	0x1FAA, 0x1FAB, 0x1FAC, 0x1FAD, 0x1FAE, 0x1FAF, 0x1FB0, 0x1FB1, 0x1FB2, 0x1FB3, 	// 0x81369B39
	0x1FB4, 0x1FB5, 0x1FB6, 0x1FB7, 0x1FB8, 0x1FB9, 0x1FBA, 0x1FBB, 0x1FBC, 0x1FBD, 	// 0x81369C39
	0x1FBE, 0x1FBF, 0x1FC0, 0x1FC1, 0x1FC2, 0x1FC3, 0x1FC4, 0x1FC5, 0x1FC6, 0x1FC7, 	// 0x81369D39
	0x1FC8, 0x1FC9, 0x1FCA, 0x1FCB, 0x1FCC, 0x1FCD, 0x1FCE, 0x1FCF, 0x1FD0, 0x1FD1, 	// 0x81369E39
	0x1FD2, 0x1FD3, 0x1FD4, 0x1FD5, 0x1FD6, 0x1FD7, 0x1FD8, 0x1FD9, 0x1FDA, 0x1FDB, 	// 0x81369F39
	0x1FDC, 0x1FDD, 0x1FDE, 0x1FDF, 0x1FE0, 0x1FE1, 0x1FE2, 0x1FE3, 0x1FE4, 0x1FE5, 	// 0x8136A039
	0x1FE6, 0x1FE7, 0x1FE8, 0x1FE9, 0x1FEA, 0x1FEB, 0x1FEC, 0x1FED, 0x1FEE, 0x1FEF, 	// 0x8136A139
	0x1FF0, 0x1FF1, 0x1FF2, 0x1FF3, 0x1FF4, 0x1FF5, 0x1FF6, 0x1FF7, 0x1FF8, 0x1FF9, 	// 0x8136A239
	0x1FFA, 0x1FFB, 0x1FFC, 0x1FFD, 0x1FFE, 0x1FFF, 0x2000, 0x2001, 0x2002, 0x2003, 	// 0x8136A339
	0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x200B, 0x200C, 0x200D, 	// 0x8136A439
	0x200E, 0x200F, 0x2011, 0x2012, 0x2017, 0x201A, 0x201B, 0x201E, 0x201F, 0x2020, 	// 0x8136A539
	0x2021, 0x2022, 0x2023, 0x2024, 0x2027, 0x2028, 0x2029, 0x202A, 0x202B, 0x202C, 	// 0x8136A639
	0x202D, 0x202E, 0x202F, 0x2031, 0x2034, 0x2036, 0x2037, 0x2038, 0x2039, 0x203A, 	// 0x8136A739
	0x203C, 0x203D, 0x203E, 0x203F, 0x2040, 0x2041, 0x2042, 0x2043, 0x2044, 0x2045, 	// 0x8136A839
	0x2046, 0x2047, 0x2048, 0x2049, 0x204A, 0x204B, 0x204C, 0x204D, 0x204E, 0x204F, 	// 0x8136A939
	0x2050, 0x2051, 0x2052, 0x2053, 0x2054, 0x2055, 0x2056, 0x2057, 0x2058, 0x2059, 	// 0x8136AA39
	0x205A, 0x205B, 0x205C, 0x205D, 0x205E, 0x205F, 0x2060, 0x2061, 0x2062, 0x2063, 	// 0x8136AB39
	0x2064, 0x2065, 0x2066, 0x2067, 0x2068, 0x2069, 0x206A, 0x206B, 0x206C, 0x206D, 	// 0x8136AC39
	0x206E, 0x206F, 0x2070, 0x2071, 0x2072, 0x2073, 0x2074, 0x2075, 0x2076, 0x2077, 	// 0x8136AD39
	0x2078, 0x2079, 0x207A, 0x207B, 0x207C, 0x207D, 0x207E, 0x207F, 0x2080, 0x2081, 	// 0x8136AE39
	0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087, 0x2088, 0x2089, 0x208A, 0x208B, 	// 0x8136AF39
	0x208C, 0x208D, 0x208E, 0x208F, 0x2090, 0x2091, 0x2092, 0x2093, 0x2094, 0x2095, 	// 0x8136B039
	0x2096, 0x2097, 0x2098, 0x2099, 0x209A, 0x209B, 0x209C, 0x209D, 0x209E, 0x209F, 	// 0x8136B139
	0x20A0, 0x20A1, 0x20A2, 0x20A3, 0x20A4, 0x20A5, 0x20A6, 0x20A7, 0x20A8, 0x20A9, 	// 0x8136B239
	0x20AA, 0x20AB, 0x20AD, 0x20AE, 0x20AF, 0x20B0, 0x20B1, 0x20B2, 0x20B3, 0x20B4, 	// 0x8136B339
	0x20B5, 0x20B6, 0x20B7, 0x20B8, 0x20B9, 0x20BA, 0x20BB, 0x20BC, 0x20BD, 0x20BE, 	// 0x8136B439
	0x20BF, 0x20C0, 0x20C1, 0x20C2, 0x20C3, 0x20C4, 0x20C5, 0x20C6, 0x20C7, 0x20C8, 	// 0x8136B539
	0x20C9, 0x20CA, 0x20CB, 0x20CC, 0x20CD, 0x20CE, 0x20CF, 0x20D0, 0x20D1, 0x20D2, 	// 0x8136B639
	0x20D3, 0x20D4, 0x20D5, 0x20D6, 0x20D7, 0x20D8, 0x20D9, 0x20DA, 0x20DB, 0x20DC, 	// 0x8136B739
	0x20DD, 0x20DE, 0x20DF, 0x20E0, 0x20E1, 0x20E2, 0x20E3, 0x20E4, 0x20E5, 0x20E6, 	// 0x8136B839
	0x20E7, 0x20E8, 0x20E9, 0x20EA, 0x20EB, 0x20EC, 0x20ED, 0x20EE, 0x20EF, 0x20F0, 	// 0x8136B939
	0x20F1, 0x20F2, 0x20F3, 0x20F4, 0x20F5, 0x20F6, 0x20F7, 0x20F8, 0x20F9, 0x20FA, 	// 0x8136BA39
	0x20FB, 0x20FC, 0x20FD, 0x20FE, 0x20FF, 0x2100, 0x2101, 0x2102, 0x2104, 0x2106, 	// 0x8136BB39
	0x2107, 0x2108, 0x210A, 0x210B, 0x210C, 0x210D, 0x210E, 0x210F, 0x2110, 0x2111, 	// 0x8136BC39
	0x2112, 0x2113, 0x2114, 0x2115, 0x2117, 0x2118, 0x2119, 0x211A, 0x211B, 0x211C, 	// 0x8136BD39
	0x211D, 0x211E, 0x211F, 0x2120, 0x2122, 0x2123, 0x2124, 0x2125, 0x2126, 0x2127, 	// 0x8136BE39
	0x2128, 0x2129, 0x212A, 0x212B, 0x212C, 0x212D, 0x212E, 0x212F, 0x2130, 0x2131, 	// 0x8136BF39
	0x2132, 0x2133, 0x2134, 0x2135, 0x2136, 0x2137, 0x2138, 0x2139, 0x213A, 0x213B, 	// 0x8136C039
	0x213C, 0x213D, 0x213E, 0x213F, 0x2140, 0x2141, 0x2142, 0x2143, 0x2144, 0x2145, 	// 0x8136C139
	0x2146, 0x2147, 0x2148, 0x2149, 0x214A, 0x214B, 0x214C, 0x214D, 0x214E, 0x214F, 	// 0x8136C239
	0x2150, 0x2151, 0x2152, 0x2153, 0x2154, 0x2155, 0x2156, 0x2157, 0x2158, 0x2159, 	// 0x8136C339
	0x215A, 0x215B, 0x215C, 0x215D, 0x215E, 0x215F, 0x216C, 0x216D, 0x216E, 0x216F, 	// 0x8136C439
	0x217A, 0x217B, 0x217C, 0x217D, 0x217E, 0x217F, 0x2180, 0x2181, 0x2182, 0x2183, 	// 0x8136C539
	0x2184, 0x2185, 0x2186, 0x2187, 0x2188, 0x2189, 0x218A, 0x218B, 0x218C, 0x218D, 	// 0x8136C639
	0x218E, 0x218F, 0x2194, 0x2195, 0x219A, 0x219B, 0x219C, 0x219D, 0x219E, 0x219F, 	// 0x8136C739
	0x21A0, 0x21A1, 0x21A2, 0x21A3, 0x21A4, 0x21A5, 0x21A6, 0x21A7, 0x21A8, 0x21A9, 	// 0x8136C839
	0x21AA, 0x21AB, 0x21AC, 0x21AD, 0x21AE, 0x21AF, 0x21B0, 0x21B1, 0x21B2, 0x21B3, 	// 0x8136C939
	0x21B4, 0x21B5, 0x21B6, 0x21B7, 0x21B8, 0x21B9, 0x21BA, 0x21BB, 0x21BC, 0x21BD, 	// 0x8136CA39
	0x21BE, 0x21BF, 0x21C0, 0x21C1, 0x21C2, 0x21C3, 0x21C4, 0x21C5, 0x21C6, 0x21C7, 	// 0x8136CB39
	0x21C8, 0x21C9, 0x21CA, 0x21CB, 0x21CC, 0x21CD, 0x21CE, 0x21CF, 0x21D0, 0x21D1, 	// 0x8136CC39
	0x21D2, 0x21D3, 0x21D4, 0x21D5, 0x21D6, 0x21D7, 0x21D8, 0x21D9, 0x21DA, 0x21DB, 	// 0x8136CD39
	0x21DC, 0x21DD, 0x21DE, 0x21DF, 0x21E0, 0x21E1, 0x21E2, 0x21E3, 0x21E4, 0x21E5, 	// 0x8136CE39
	0x21E6, 0x21E7, 0x21E8, 0x21E9, 0x21EA, 0x21EB, 0x21EC, 0x21ED, 0x21EE, 0x21EF, 	// 0x8136CF39
	0x21F0, 0x21F1, 0x21F2, 0x21F3, 0x21F4, 0x21F5, 0x21F6, 0x21F7, 0x21F8, 0x21F9, 	// 0x8136D039
	0x21FA, 0x21FB, 0x21FC, 0x21FD, 0x21FE, 0x21FF, 0x2200, 0x2201, 0x2202, 0x2203, 	// 0x8136D139
	0x2204, 0x2205, 0x2206, 0x2207, 0x2209, 0x220A, 0x220B, 0x220C, 0x220D, 0x220E, 	// 0x8136D239
	0x2210, 0x2212, 0x2213, 0x2214, 0x2216, 0x2217, 0x2218, 0x2219, 0x221B, 0x221C, 	// 0x8136D339
	0x2221, 0x2222, 0x2224, 0x2226, 0x222C, 0x222D, 0x222F, 0x2230, 0x2231, 0x2232, 	// 0x8136D439
	0x2233, 0x2238, 0x2239, 0x223A, 0x223B, 0x223C, 0x223E, 0x223F, 0x2240, 0x2241, 	// 0x8136D539
	0x2242, 0x2243, 0x2244, 0x2245, 0x2246, 0x2247, 0x2249, 0x224A, 0x224B, 0x224D, 	// 0x8136D639
	0x224E, 0x224F, 0x2250, 0x2251, 0x2253, 0x2254, 0x2255, 0x2256, 0x2257, 0x2258, 	// 0x8136D739
	0x2259, 0x225A, 0x225B, 0x225C, 0x225D, 0x225E, 0x225F, 0x2262, 0x2263, 0x2268, 	// 0x8136D839
	0x2269, 0x226A, 0x226B, 0x226C, 0x226D, 0x2270, 0x2271, 0x2272, 0x2273, 0x2274, 	// 0x8136D939
	0x2275, 0x2276, 0x2277, 0x2278, 0x2279, 0x227A, 0x227B, 0x227C, 0x227D, 0x227E, 	// 0x8136DA39
	0x227F, 0x2280, 0x2281, 0x2282, 0x2283, 0x2284, 0x2285, 0x2286, 0x2287, 0x2288, 	// 0x8136DB39
	0x2289, 0x228A, 0x228B, 0x228C, 0x228D, 0x228E, 0x228F, 0x2290, 0x2291, 0x2292, 	// 0x8136DC39
	0x2293, 0x2294, 0x2296, 0x2297, 0x2298, 0x229A, 0x229B, 0x229C, 0x229D, 0x229E, 	// 0x8136DD39
	0x229F, 0x22A0, 0x22A1, 0x22A2, 0x22A3, 0x22A4, 0x22A6, 0x22A7, 0x22A8, 0x22A9, 	// 0x8136DE39
	0x22AA, 0x22AB, 0x22AC, 0x22AD, 0x22AE, 0x22AF, 0x22B0, 0x22B1, 0x22B2, 0x22B3, 	// 0x8136DF39
	0x22B4, 0x22B5, 0x22B6, 0x22B7, 0x22B8, 0x22B9, 0x22BA, 0x22BB, 0x22BC, 0x22BD, 	// 0x8136E039
	0x22BE, 0x22C0, 0x22C1, 0x22C2, 0x22C3, 0x22C4, 0x22C5, 0x22C6, 0x22C7, 0x22C8, 	// 0x8136E139
	0x22C9, 0x22CA, 0x22CB, 0x22CC, 0x22CD, 0x22CE, 0x22CF, 0x22D0, 0x22D1, 0x22D2, 	// 0x8136E239
	0x22D3, 0x22D4, 0x22D5, 0x22D6, 0x22D7, 0x22D8, 0x22D9, 0x22DA, 0x22DB, 0x22DC, 	// 0x8136E339
	0x22DD, 0x22DE, 0x22DF, 0x22E0, 0x22E1, 0x22E2, 0x22E3, 0x22E4, 0x22E5, 0x22E6, 	// 0x8136E439
	0x22E7, 0x22E8, 0x22E9, 0x22EA, 0x22EB, 0x22EC, 0x22ED, 0x22EE, 0x22EF, 0x22F0, 	// 0x8136E539
	0x22F1, 0x22F2, 0x22F3, 0x22F4, 0x22F5, 0x22F6, 0x22F7, 0x22F8, 0x22F9, 0x22FA, 	// 0x8136E639
	0x22FB, 0x22FC, 0x22FD, 0x22FE, 0x22FF, 0x2300, 0x2301, 0x2302, 0x2303, 0x2304, 	// 0x8136E739
	0x2305, 0x2306, 0x2307, 0x2308, 0x2309, 0x230A, 0x230B, 0x230C, 0x230D, 0x230E, 	// 0x8136E839
	0x230F, 0x2310, 0x2311, 0x2313, 0x2314, 0x2315, 0x2316, 0x2317, 0x2318, 0x2319, 	// 0x8136E939
	0x231A, 0x231B, 0x231C, 0x231D, 0x231E, 0x231F, 0x2320, 0x2321, 0x2322, 0x2323, 	// 0x8136EA39
	0x2324, 0x2325, 0x2326, 0x2327, 0x2328, 0x2329, 0x232A, 0x232B, 0x232C, 0x232D, 	// 0x8136EB39
	0x232E, 0x232F, 0x2330, 0x2331, 0x2332, 0x2333, 0x2334, 0x2335, 0x2336, 0x2337, 	// 0x8136EC39
	0x2338, 0x2339, 0x233A, 0x233B, 0x233C, 0x233D, 0x233E, 0x233F, 0x2340, 0x2341, 	// 0x8136ED39
	0x2342, 0x2343, 0x2344, 0x2345, 0x2346, 0x2347, 0x2348, 0x2349, 0x234A, 0x234B, 	// 0x8136EE39
	0x234C, 0x234D, 0x234E, 0x234F, 0x2350, 0x2351, 0x2352, 0x2353, 0x2354, 0x2355, 	// 0x8136EF39
	0x2356, 0x2357, 0x2358, 0x2359, 0x235A, 0x235B, 0x235C, 0x235D, 0x235E, 0x235F, 	// 0x8136F039
	0x2360, 0x2361, 0x2362, 0x2363, 0x2364, 0x2365, 0x2366, 0x2367, 0x2368, 0x2369, 	// 0x8136F139
	0x236A, 0x236B, 0x236C, 0x236D, 0x236E, 0x236F, 0x2370, 0x2371, 0x2372, 0x2373, 	// 0x8136F239
	0x2374, 0x2375, 0x2376, 0x2377, 0x2378, 0x2379, 0x237A, 0x237B, 0x237C, 0x237D, 	// 0x8136F339
	0x237E, 0x237F, 0x2380, 0x2381, 0x2382, 0x2383, 0x2384, 0x2385, 0x2386, 0x2387, 	// 0x8136F439
	0x2388, 0x2389, 0x238A, 0x238B, 0x238C, 0x238D, 0x238E, 0x238F, 0x2390, 0x2391, 	// 0x8136F539
	0x2392, 0x2393, 0x2394, 0x2395, 0x2396, 0x2397, 0x2398, 0x2399, 0x239A, 0x239B, 	// 0x8136F639
	0x239C, 0x239D, 0x239E, 0x239F, 0x23A0, 0x23A1, 0x23A2, 0x23A3, 0x23A4, 0x23A5, 	// 0x8136F739
	0x23A6, 0x23A7, 0x23A8, 0x23A9, 0x23AA, 0x23AB, 0x23AC, 0x23AD, 0x23AE, 0x23AF, 	// 0x8136F839
	0x23B0, 0x23B1, 0x23B2, 0x23B3, 0x23B4, 0x23B5, 0x23B6, 0x23B7, 0x23B8, 0x23B9, 	// 0x8136F939
	0x23BA, 0x23BB, 0x23BC, 0x23BD, 0x23BE, 0x23BF, 0x23C0, 0x23C1, 0x23C2, 0x23C3, 	// 0x8136FA39
	0x23C4, 0x23C5, 0x23C6, 0x23C7, 0x23C8, 0x23C9, 0x23CA, 0x23CB, 0x23CC, 0x23CD, 	// 0x8136FB39
	0x23CE, 0x23CF, 0x23D0, 0x23D1, 0x23D2, 0x23D3, 0x23D4, 0x23D5, 0x23D6, 0x23D7, 	// 0x8136FC39
	0x23D8, 0x23D9, 0x23DA, 0x23DB, 0x23DC, 0x23DD, 0x23DE, 0x23DF, 0x23E0, 0x23E1, 	// 0x8136FD39
	0x23E2, 0x23E3, 0x23E4, 0x23E5, 0x23E6, 0x23E7, 0x23E8, 0x23E9, 0x23EA, 0x23EB, 	// 0x8136FE39
	0x23EC, 0x23ED, 0x23EE, 0x23EF, 0x23F0, 0x23F1, 0x23F2, 0x23F3, 0x23F4, 0x23F5, 	// 0x81378139
	0x23F6, 0x23F7, 0x23F8, 0x23F9, 0x23FA, 0x23FB, 0x23FC, 0x23FD, 0x23FE, 0x23FF, 	// 0x81378239
	0x2400, 0x2401, 0x2402, 0x2403, 0x2404, 0x2405, 0x2406, 0x2407, 0x2408, 0x2409, 	// 0x81378339
	0x240A, 0x240B, 0x240C, 0x240D, 0x240E, 0x240F, 0x2410, 0x2411, 0x2412, 0x2413, 	// 0x81378439
	0x2414, 0x2415, 0x2416, 0x2417, 0x2418, 0x2419, 0x241A, 0x241B, 0x241C, 0x241D, 	// 0x81378539
	0x241E, 0x241F, 0x2420, 0x2421, 0x2422, 0x2423, 0x2424, 0x2425, 0x2426, 0x2427, 	// 0x81378639
	0x2428, 0x2429, 0x242A, 0x242B, 0x242C, 0x242D, 0x242E, 0x242F, 0x2430, 0x2431, 	// 0x81378739
	0x2432, 0x2433, 0x2434, 0x2435, 0x2436, 0x2437, 0x2438, 0x2439, 0x243A, 0x243B, 	// 0x81378839
	0x243C, 0x243D, 0x243E, 0x243F, 0x2440, 0x2441, 0x2442, 0x2443, 0x2444, 0x2445, 	// 0x81378939
	0x2446, 0x2447, 0x2448, 0x2449, 0x244A, 0x244B, 0x244C, 0x244D, 0x244E, 0x244F, 	// 0x81378A39
	0x2450, 0x2451, 0x2452, 0x2453, 0x2454, 0x2455, 0x2456, 0x2457, 0x2458, 0x2459, 	// 0x81378B39
	0x245A, 0x245B, 0x245C, 0x245D, 0x245E, 0x245F, 0x246A, 0x246B, 0x246C, 0x246D, 	// 0x81378C39
	0x246E, 0x246F, 0x2470, 0x2471, 0x2472, 0x2473, 0x249C, 0x249D, 0x249E, 0x249F, 	// 0x81378D39
	0x24A0, 0x24A1, 0x24A2, 0x24A3, 0x24A4, 0x24A5, 0x24A6, 0x24A7, 0x24A8, 0x24A9, 	// 0x81378E39
	0x24AA, 0x24AB, 0x24AC, 0x24AD, 0x24AE, 0x24AF, 0x24B0, 0x24B1, 0x24B2, 0x24B3, 	// 0x81378F39
	0x24B4, 0x24B5, 0x24B6, 0x24B7, 0x24B8, 0x24B9, 0x24BA, 0x24BB, 0x24BC, 0x24BD, 	// 0x81379039
	0x24BE, 0x24BF, 0x24C0, 0x24C1, 0x24C2, 0x24C3, 0x24C4, 0x24C5, 0x24C6, 0x24C7, 	// 0x81379139
	0x24C8, 0x24C9, 0x24CA, 0x24CB, 0x24CC, 0x24CD, 0x24CE, 0x24CF, 0x24D0, 0x24D1, 	// 0x81379239
	0x24D2, 0x24D3, 0x24D4, 0x24D5, 0x24D6, 0x24D7, 0x24D8, 0x24D9, 0x24DA, 0x24DB, 	// 0x81379339
	0x24DC, 0x24DD, 0x24DE, 0x24DF, 0x24E0, 0x24E1, 0x24E2, 0x24E3, 0x24E4, 0x24E5, 	// 0x81379439
	0x24E6, 0x24E7, 0x24E8, 0x24E9, 0x24EA, 0x24EB, 0x24EC, 0x24ED, 0x24EE, 0x24EF, 	// 0x81379539
	0x24F0, 0x24F1, 0x24F2, 0x24F3, 0x24F4, 0x24F5, 0x24F6, 0x24F7, 0x24F8, 0x24F9, 	// 0x81379639
	0x24FA, 0x24FB, 0x24FC, 0x24FD, 0x24FE, 0x24FF, 0x254C, 0x254D, 0x254E, 0x254F, 	// 0x81379739
	0x2574, 0x2575, 0x2576, 0x2577, 0x2578, 0x2579, 0x257A, 0x257B, 0x257C, 0x257D, 	// 0x81379839
	0x257E, 0x257F, 0x2580, 0x2590, 0x2591, 0x2592, 0x2596, 0x2597, 0x2598, 0x2599, 	// 0x81379939
	0x259A, 0x259B, 0x259C, 0x259D, 0x259E, 0x259F, 0x25A2, 0x25A3, 0x25A4, 0x25A5, 	// 0x81379A39
	0x25A6, 0x25A7, 0x25A8, 0x25A9, 0x25AA, 0x25AB, 0x25AC, 0x25AD, 0x25AE, 0x25AF, 	// 0x81379B39
	0x25B0, 0x25B1, 0x25B4, 0x25B5, 0x25B6, 0x25B7, 0x25B8, 0x25B9, 0x25BA, 0x25BB, 	// 0x81379C39
	0x25BE, 0x25BF, 0x25C0, 0x25C1, 0x25C2, 0x25C3, 0x25C4, 0x25C5, 0x25C8, 0x25C9, 	// 0x81379D39
	0x25CA, 0x25CC, 0x25CD, 0x25D0, 0x25D1, 0x25D2, 0x25D3, 0x25D4, 0x25D5, 0x25D6, 	// 0x81379E39
	0x25D7, 0x25D8, 0x25D9, 0x25DA, 0x25DB, 0x25DC, 0x25DD, 0x25DE, 0x25DF, 0x25E0, 	// 0x81379F39
	0x25E1, 0x25E6, 0x25E7, 0x25E8, 0x25E9, 0x25EA, 0x25EB, 0x25EC, 0x25ED, 0x25EE, 	// 0x8137A039
	0x25EF, 0x25F0, 0x25F1, 0x25F2, 0x25F3, 0x25F4, 0x25F5, 0x25F6, 0x25F7, 0x25F8, 	// 0x8137A139
	0x25F9, 0x25FA, 0x25FB, 0x25FC, 0x25FD, 0x25FE, 0x25FF, 0x2600, 0x2601, 0x2602, 	// 0x8137A239
	0x2603, 0x2604, 0x2607, 0x2608, 0x260A, 0x260B, 0x260C, 0x260D, 0x260E, 0x260F, 	// 0x8137A339
	0x2610, 0x2611, 0x2612, 0x2613, 0x2614, 0x2615, 0x2616, 0x2617, 0x2618, 0x2619, 	// 0x8137A439
	0x261A, 0x261B, 0x261C, 0x261D, 0x261E, 0x261F, 0x2620, 0x2621, 0x2622, 0x2623, 	// 0x8137A539
	0x2624, 0x2625, 0x2626, 0x2627, 0x2628, 0x2629, 0x262A, 0x262B, 0x262C, 0x262D, 	// 0x8137A639
	0x262E, 0x262F, 0x2630, 0x2631, 0x2632, 0x2633, 0x2634, 0x2635, 0x2636, 0x2637, 	// 0x8137A739
	0x2638, 0x2639, 0x263A, 0x263B, 0x263C, 0x263D, 0x263E, 0x263F, 0x2641, 0x2643, 	// 0x8137A839
	0x2644, 0x2645, 0x2646, 0x2647, 0x2648, 0x2649, 0x264A, 0x264B, 0x264C, 0x264D, 	// 0x8137A939
	0x264E, 0x264F, 0x2650, 0x2651, 0x2652, 0x2653, 0x2654, 0x2655, 0x2656, 0x2657, 	// 0x8137AA39
	0x2658, 0x2659, 0x265A, 0x265B, 0x265C, 0x265D, 0x265E, 0x265F, 0x2660, 0x2661, 	// 0x8137AB39
	0x2662, 0x2663, 0x2664, 0x2665, 0x2666, 0x2667, 0x2668, 0x2669, 0x266A, 0x266B, 	// 0x8137AC39
	0x266C, 0x266D, 0x266E, 0x266F, 0x2670, 0x2671, 0x2672, 0x2673, 0x2674, 0x2675, 	// 0x8137AD39
	0x2676, 0x2677, 0x2678, 0x2679, 0x267A, 0x267B, 0x267C, 0x267D, 0x267E, 0x267F, 	// 0x8137AE39
	0x2680, 0x2681, 0x2682, 0x2683, 0x2684, 0x2685, 0x2686, 0x2687, 0x2688, 0x2689, 	// 0x8137AF39
	0x268A, 0x268B, 0x268C, 0x268D, 0x268E, 0x268F, 0x2690, 0x2691, 0x2692, 0x2693, 	// 0x8137B039
	0x2694, 0x2695, 0x2696, 0x2697, 0x2698, 0x2699, 0x269A, 0x269B, 0x269C, 0x269D, 	// 0x8137B139
	0x269E, 0x269F, 0x26A0, 0x26A1, 0x26A2, 0x26A3, 0x26A4, 0x26A5, 0x26A6, 0x26A7, 	// 0x8137B239
	0x26A8, 0x26A9, 0x26AA, 0x26AB, 0x26AC, 0x26AD, 0x26AE, 0x26AF, 0x26B0, 0x26B1, 	// 0x8137B339
	0x26B2, 0x26B3, 0x26B4, 0x26B5, 0x26B6, 0x26B7, 0x26B8, 0x26B9, 0x26BA, 0x26BB, 	// 0x8137B439
	0x26BC, 0x26BD, 0x26BE, 0x26BF, 0x26C0, 0x26C1, 0x26C2, 0x26C3, 0x26C4, 0x26C5, 	// 0x8137B539
	0x26C6, 0x26C7, 0x26C8, 0x26C9, 0x26CA, 0x26CB, 0x26CC, 0x26CD, 0x26CE, 0x26CF, 	// 0x8137B639
	0x26D0, 0x26D1, 0x26D2, 0x26D3, 0x26D4, 0x26D5, 0x26D6, 0x26D7, 0x26D8, 0x26D9, 	// 0x8137B739
	0x26DA, 0x26DB, 0x26DC, 0x26DD, 0x26DE, 0x26DF, 0x26E0, 0x26E1, 0x26E2, 0x26E3, 	// 0x8137B839
	0x26E4, 0x26E5, 0x26E6, 0x26E7, 0x26E8, 0x26E9, 0x26EA, 0x26EB, 0x26EC, 0x26ED, 	// 0x8137B939
	0x26EE, 0x26EF, 0x26F0, 0x26F1, 0x26F2, 0x26F3, 0x26F4, 0x26F5, 0x26F6, 0x26F7, 	// 0x8137BA39
	0x26F8, 0x26F9, 0x26FA, 0x26FB, 0x26FC, 0x26FD, 0x26FE, 0x26FF, 0x2700, 0x2701, 	// 0x8137BB39
	0x2702, 0x2703, 0x2704, 0x2705, 0x2706, 0x2707, 0x2708, 0x2709, 0x270A, 0x270B, 	// 0x8137BC39
	0x270C, 0x270D, 0x270E, 0x270F, 0x2710, 0x2711, 0x2712, 0x2713, 0x2714, 0x2715, 	// 0x8137BD39
	0x2716, 0x2717, 0x2718, 0x2719, 0x271A, 0x271B, 0x271C, 0x271D, 0x271E, 0x271F, 	// 0x8137BE39
	0x2720, 0x2721, 0x2722, 0x2723, 0x2724, 0x2725, 0x2726, 0x2727, 0x2728, 0x2729, 	// 0x8137BF39
	0x272A, 0x272B, 0x272C, 0x272D, 0x272E, 0x272F, 0x2730, 0x2731, 0x2732, 0x2733, 	// 0x8137C039
	0x2734, 0x2735, 0x2736, 0x2737, 0x2738, 0x2739, 0x273A, 0x273B, 0x273C, 0x273D, 	// 0x8137C139
	0x273E, 0x273F, 0x2740, 0x2741, 0x2742, 0x2743, 0x2744, 0x2745, 0x2746, 0x2747, 	// 0x8137C239
	0x2748, 0x2749, 0x274A, 0x274B, 0x274C, 0x274D, 0x274E, 0x274F, 0x2750, 0x2751, 	// 0x8137C339
	0x2752, 0x2753, 0x2754, 0x2755, 0x2756, 0x2757, 0x2758, 0x2759, 0x275A, 0x275B, 	// 0x8137C439
	0x275C, 0x275D, 0x275E, 0x275F, 0x2760, 0x2761, 0x2762, 0x2763, 0x2764, 0x2765, 	// 0x8137C539
	0x2766, 0x2767, 0x2768, 0x2769, 0x276A, 0x276B, 0x276C, 0x276D, 0x276E, 0x276F, 	// 0x8137C639
	0x2770, 0x2771, 0x2772, 0x2773, 0x2774, 0x2775, 0x2776, 0x2777, 0x2778, 0x2779, 	// 0x8137C739
	0x277A, 0x277B, 0x277C, 0x277D, 0x277E, 0x277F, 0x2780, 0x2781, 0x2782, 0x2783, 	// 0x8137C839
	0x2784, 0x2785, 0x2786, 0x2787, 0x2788, 0x2789, 0x278A, 0x278B, 0x278C, 0x278D, 	// 0x8137C939
	0x278E, 0x278F, 0x2790, 0x2791, 0x2792, 0x2793, 0x2794, 0x2795, 0x2796, 0x2797, 	// 0x8137CA39
	0x2798, 0x2799, 0x279A, 0x279B, 0x279C, 0x279D, 0x279E, 0x279F, 0x27A0, 0x27A1, 	// 0x8137CB39
	0x27A2, 0x27A3, 0x27A4, 0x27A5, 0x27A6, 0x27A7, 0x27A8, 0x27A9, 0x27AA, 0x27AB, 	// 0x8137CC39
	0x27AC, 0x27AD, 0x27AE, 0x27AF, 0x27B0, 0x27B1, 0x27B2, 0x27B3, 0x27B4, 0x27B5, 	// 0x8137CD39
	0x27B6, 0x27B7, 0x27B8, 0x27B9, 0x27BA, 0x27BB, 0x27BC, 0x27BD, 0x27BE, 0x27BF, 	// 0x8137CE39
	0x27C0, 0x27C1, 0x27C2, 0x27C3, 0x27C4, 0x27C5, 0x27C6, 0x27C7, 0x27C8, 0x27C9, 	// 0x8137CF39
	0x27CA, 0x27CB, 0x27CC, 0x27CD, 0x27CE, 0x27CF, 0x27D0, 0x27D1, 0x27D2, 0x27D3, 	// 0x8137D039
	0x27D4, 0x27D5, 0x27D6, 0x27D7, 0x27D8, 0x27D9, 0x27DA, 0x27DB, 0x27DC, 0x27DD, 	// 0x8137D139
	0x27DE, 0x27DF, 0x27E0, 0x27E1, 0x27E2, 0x27E3, 0x27E4, 0x27E5, 0x27E6, 0x27E7, 	// 0x8137D239
	0x27E8, 0x27E9, 0x27EA, 0x27EB, 0x27EC, 0x27ED, 0x27EE, 0x27EF, 0x27F0, 0x27F1, 	// 0x8137D339
	0x27F2, 0x27F3, 0x27F4, 0x27F5, 0x27F6, 0x27F7, 0x27F8, 0x27F9, 0x27FA, 0x27FB, 	// 0x8137D439
	0x27FC, 0x27FD, 0x27FE, 0x27FF, 0x2800, 0x2801, 0x2802, 0x2803, 0x2804, 0x2805, 	// 0x8137D539
	0x2806, 0x2807, 0x2808, 0x2809, 0x280A, 0x280B, 0x280C, 0x280D, 0x280E, 0x280F, 	// 0x8137D639
	0x2810, 0x2811, 0x2812, 0x2813, 0x2814, 0x2815, 0x2816, 0x2817, 0x2818, 0x2819, 	// 0x8137D739
	0x281A, 0x281B, 0x281C, 0x281D, 0x281E, 0x281F, 0x2820, 0x2821, 0x2822, 0x2823, 	// 0x8137D839
	0x2824, 0x2825, 0x2826, 0x2827, 0x2828, 0x2829, 0x282A, 0x282B, 0x282C, 0x282D, 	// 0x8137D939
	0x282E, 0x282F, 0x2830, 0x2831, 0x2832, 0x2833, 0x2834, 0x2835, 0x2836, 0x2837, 	// 0x8137DA39
	0x2838, 0x2839, 0x283A, 0x283B, 0x283C, 0x283D, 0x283E, 0x283F, 0x2840, 0x2841, 	// 0x8137DB39
	0x2842, 0x2843, 0x2844, 0x2845, 0x2846, 0x2847, 0x2848, 0x2849, 0x284A, 0x284B, 	// 0x8137DC39
	0x284C, 0x284D, 0x284E, 0x284F, 0x2850, 0x2851, 0x2852, 0x2853, 0x2854, 0x2855, 	// 0x8137DD39
	0x2856, 0x2857, 0x2858, 0x2859, 0x285A, 0x285B, 0x285C, 0x285D, 0x285E, 0x285F, 	// 0x8137DE39
	0x2860, 0x2861, 0x2862, 0x2863, 0x2864, 0x2865, 0x2866, 0x2867, 0x2868, 0x2869, 	// 0x8137DF39
	0x286A, 0x286B, 0x286C, 0x286D, 0x286E, 0x286F, 0x2870, 0x2871, 0x2872, 0x2873, 	// 0x8137E039
	0x2874, 0x2875, 0x2876, 0x2877, 0x2878, 0x2879, 0x287A, 0x287B, 0x287C, 0x287D, 	// 0x8137E139
	0x287E, 0x287F, 0x2880, 0x2881, 0x2882, 0x2883, 0x2884, 0x2885, 0x2886, 0x2887, 	// 0x8137E239
	0x2888, 0x2889, 0x288A, 0x288B, 0x288C, 0x288D, 0x288E, 0x288F, 0x2890, 0x2891, 	// 0x8137E339
	0x2892, 0x2893, 0x2894, 0x2895, 0x2896, 0x2897, 0x2898, 0x2899, 0x289A, 0x289B, 	// 0x8137E439
	0x289C, 0x289D, 0x289E, 0x289F, 0x28A0, 0x28A1, 0x28A2, 0x28A3, 0x28A4, 0x28A5, 	// 0x8137E539
	0x28A6, 0x28A7, 0x28A8, 0x28A9, 0x28AA, 0x28AB, 0x28AC, 0x28AD, 0x28AE, 0x28AF, 	// 0x8137E639
	0x28B0, 0x28B1, 0x28B2, 0x28B3, 0x28B4, 0x28B5, 0x28B6, 0x28B7, 0x28B8, 0x28B9, 	// 0x8137E739
	0x28BA, 0x28BB, 0x28BC, 0x28BD, 0x28BE, 0x28BF, 0x28C0, 0x28C1, 0x28C2, 0x28C3, 	// 0x8137E839
	0x28C4, 0x28C5, 0x28C6, 0x28C7, 0x28C8, 0x28C9, 0x28CA, 0x28CB, 0x28CC, 0x28CD, 	// 0x8137E939
	0x28CE, 0x28CF, 0x28D0, 0x28D1, 0x28D2, 0x28D3, 0x28D4, 0x28D5, 0x28D6, 0x28D7, 	// 0x8137EA39
	0x28D8, 0x28D9, 0x28DA, 0x28DB, 0x28DC, 0x28DD, 0x28DE, 0x28DF, 0x28E0, 0x28E1, 	// 0x8137EB39
	0x28E2, 0x28E3, 0x28E4, 0x28E5, 0x28E6, 0x28E7, 0x28E8, 0x28E9, 0x28EA, 0x28EB, 	// 0x8137EC39
	0x28EC, 0x28ED, 0x28EE, 0x28EF, 0x28F0, 0x28F1, 0x28F2, 0x28F3, 0x28F4, 0x28F5, 	// 0x8137ED39
	0x28F6, 0x28F7, 0x28F8, 0x28F9, 0x28FA, 0x28FB, 0x28FC, 0x28FD, 0x28FE, 0x28FF, 	// 0x8137EE39
	0x2900, 0x2901, 0x2902, 0x2903, 0x2904, 0x2905, 0x2906, 0x2907, 0x2908, 0x2909, 	// 0x8137EF39
	0x290A, 0x290B, 0x290C, 0x290D, 0x290E, 0x290F, 0x2910, 0x2911, 0x2912, 0x2913, 	// 0x8137F039
	0x2914, 0x2915, 0x2916, 0x2917, 0x2918, 0x2919, 0x291A, 0x291B, 0x291C, 0x291D, 	// 0x8137F139
	0x291E, 0x291F, 0x2920, 0x2921, 0x2922, 0x2923, 0x2924, 0x2925, 0x2926, 0x2927, 	// 0x8137F239
	0x2928, 0x2929, 0x292A, 0x292B, 0x292C, 0x292D, 0x292E, 0x292F, 0x2930, 0x2931, 	// 0x8137F339
	0x2932, 0x2933, 0x2934, 0x2935, 0x2936, 0x2937, 0x2938, 0x2939, 0x293A, 0x293B, 	// 0x8137F439
	0x293C, 0x293D, 0x293E, 0x293F, 0x2940, 0x2941, 0x2942, 0x2943, 0x2944, 0x2945, 	// 0x8137F539
	0x2946, 0x2947, 0x2948, 0x2949, 0x294A, 0x294B, 0x294C, 0x294D, 0x294E, 0x294F, 	// 0x8137F639
	0x2950, 0x2951, 0x2952, 0x2953, 0x2954, 0x2955, 0x2956, 0x2957, 0x2958, 0x2959, 	// 0x8137F739
	0x295A, 0x295B, 0x295C, 0x295D, 0x295E, 0x295F, 0x2960, 0x2961, 0x2962, 0x2963, 	// 0x8137F839
	0x2964, 0x2965, 0x2966, 0x2967, 0x2968, 0x2969, 0x296A, 0x296B, 0x296C, 0x296D, 	// 0x8137F939
	0x296E, 0x296F, 0x2970, 0x2971, 0x2972, 0x2973, 0x2974, 0x2975, 0x2976, 0x2977, 	// 0x8137FA39
	0x2978, 0x2979, 0x297A, 0x297B, 0x297C, 0x297D, 0x297E, 0x297F, 0x2980, 0x2981, 	// 0x8137FB39
	0x2982, 0x2983, 0x2984, 0x2985, 0x2986, 0x2987, 0x2988, 0x2989, 0x298A, 0x298B, 	// 0x8137FC39
	0x298C, 0x298D, 0x298E, 0x298F, 0x2990, 0x2991, 0x2992, 0x2993, 0x2994, 0x2995, 	// 0x8137FD39
	0x2996, 0x2997, 0x2998, 0x2999, 0x299A, 0x299B, 0x299C, 0x299D, 0x299E, 0x299F, 	// 0x8137FE39
	0x29A0, 0x29A1, 0x29A2, 0x29A3, 0x29A4, 0x29A5, 0x29A6, 0x29A7, 0x29A8, 0x29A9, 	// 0x81388139
	0x29AA, 0x29AB, 0x29AC, 0x29AD, 0x29AE, 0x29AF, 0x29B0, 0x29B1, 0x29B2, 0x29B3, 	// 0x81388239
	0x29B4, 0x29B5, 0x29B6, 0x29B7, 0x29B8, 0x29B9, 0x29BA, 0x29BB, 0x29BC, 0x29BD, 	// 0x81388339
	0x29BE, 0x29BF, 0x29C0, 0x29C1, 0x29C2, 0x29C3, 0x29C4, 0x29C5, 0x29C6, 0x29C7, 	// 0x81388439
	0x29C8, 0x29C9, 0x29CA, 0x29CB, 0x29CC, 0x29CD, 0x29CE, 0x29CF, 0x29D0, 0x29D1, 	// 0x81388539
	0x29D2, 0x29D3, 0x29D4, 0x29D5, 0x29D6, 0x29D7, 0x29D8, 0x29D9, 0x29DA, 0x29DB, 	// 0x81388639
	0x29DC, 0x29DD, 0x29DE, 0x29DF, 0x29E0, 0x29E1, 0x29E2, 0x29E3, 0x29E4, 0x29E5, 	// 0x81388739
	0x29E6, 0x29E7, 0x29E8, 0x29E9, 0x29EA, 0x29EB, 0x29EC, 0x29ED, 0x29EE, 0x29EF, 	// 0x81388839
	0x29F0, 0x29F1, 0x29F2, 0x29F3, 0x29F4, 0x29F5, 0x29F6, 0x29F7, 0x29F8, 0x29F9, 	// 0x81388939
	0x29FA, 0x29FB, 0x29FC, 0x29FD, 0x29FE, 0x29FF, 0x2A00, 0x2A01, 0x2A02, 0x2A03, 	// 0x81388A39
	0x2A04, 0x2A05, 0x2A06, 0x2A07, 0x2A08, 0x2A09, 0x2A0A, 0x2A0B, 0x2A0C, 0x2A0D, 	// 0x81388B39
	0x2A0E, 0x2A0F, 0x2A10, 0x2A11, 0x2A12, 0x2A13, 0x2A14, 0x2A15, 0x2A16, 0x2A17, 	// 0x81388C39
	0x2A18, 0x2A19, 0x2A1A, 0x2A1B, 0x2A1C, 0x2A1D, 0x2A1E, 0x2A1F, 0x2A20, 0x2A21, 	// 0x81388D39
	0x2A22, 0x2A23, 0x2A24, 0x2A25, 0x2A26, 0x2A27, 0x2A28, 0x2A29, 0x2A2A, 0x2A2B, 	// 0x81388E39
	0x2A2C, 0x2A2D, 0x2A2E, 0x2A2F, 0x2A30, 0x2A31, 0x2A32, 0x2A33, 0x2A34, 0x2A35, 	// 0x81388F39
	0x2A36, 0x2A37, 0x2A38, 0x2A39, 0x2A3A, 0x2A3B, 0x2A3C, 0x2A3D, 0x2A3E, 0x2A3F, 	// 0x81389039
	0x2A40, 0x2A41, 0x2A42, 0x2A43, 0x2A44, 0x2A45, 0x2A46, 0x2A47, 0x2A48, 0x2A49, 	// 0x81389139
	0x2A4A, 0x2A4B, 0x2A4C, 0x2A4D, 0x2A4E, 0x2A4F, 0x2A50, 0x2A51, 0x2A52, 0x2A53, 	// 0x81389239
	0x2A54, 0x2A55, 0x2A56, 0x2A57, 0x2A58, 0x2A59, 0x2A5A, 0x2A5B, 0x2A5C, 0x2A5D, 	// 0x81389339
	0x2A5E, 0x2A5F, 0x2A60, 0x2A61, 0x2A62, 0x2A63, 0x2A64, 0x2A65, 0x2A66, 0x2A67, 	// 0x81389439
	0x2A68, 0x2A69, 0x2A6A, 0x2A6B, 0x2A6C, 0x2A6D, 0x2A6E, 0x2A6F, 0x2A70, 0x2A71, 	// 0x81389539
	0x2A72, 0x2A73, 0x2A74, 0x2A75, 0x2A76, 0x2A77, 0x2A78, 0x2A79, 0x2A7A, 0x2A7B, 	// 0x81389639
	0x2A7C, 0x2A7D, 0x2A7E, 0x2A7F, 0x2A80, 0x2A81, 0x2A82, 0x2A83, 0x2A84, 0x2A85, 	// 0x81389739
	0x2A86, 0x2A87, 0x2A88, 0x2A89, 0x2A8A, 0x2A8B, 0x2A8C, 0x2A8D, 0x2A8E, 0x2A8F, 	// 0x81389839
	0x2A90, 0x2A91, 0x2A92, 0x2A93, 0x2A94, 0x2A95, 0x2A96, 0x2A97, 0x2A98, 0x2A99, 	// 0x81389939
	0x2A9A, 0x2A9B, 0x2A9C, 0x2A9D, 0x2A9E, 0x2A9F, 0x2AA0, 0x2AA1, 0x2AA2, 0x2AA3, 	// 0x81389A39
	0x2AA4, 0x2AA5, 0x2AA6, 0x2AA7, 0x2AA8, 0x2AA9, 0x2AAA, 0x2AAB, 0x2AAC, 0x2AAD, 	// 0x81389B39
	0x2AAE, 0x2AAF, 0x2AB0, 0x2AB1, 0x2AB2, 0x2AB3, 0x2AB4, 0x2AB5, 0x2AB6, 0x2AB7, 	// 0x81389C39
	0x2AB8, 0x2AB9, 0x2ABA, 0x2ABB, 0x2ABC, 0x2ABD, 0x2ABE, 0x2ABF, 0x2AC0, 0x2AC1, 	// 0x81389D39
	0x2AC2, 0x2AC3, 0x2AC4, 0x2AC5, 0x2AC6, 0x2AC7, 0x2AC8, 0x2AC9, 0x2ACA, 0x2ACB, 	// 0x81389E39
	0x2ACC, 0x2ACD, 0x2ACE, 0x2ACF, 0x2AD0, 0x2AD1, 0x2AD2, 0x2AD3, 0x2AD4, 0x2AD5, 	// 0x81389F39
	0x2AD6, 0x2AD7, 0x2AD8, 0x2AD9, 0x2ADA, 0x2ADB, 0x2ADC, 0x2ADD, 0x2ADE, 0x2ADF, 	// 0x8138A039
	0x2AE0, 0x2AE1, 0x2AE2, 0x2AE3, 0x2AE4, 0x2AE5, 0x2AE6, 0x2AE7, 0x2AE8, 0x2AE9, 	// 0x8138A139
	0x2AEA, 0x2AEB, 0x2AEC, 0x2AED, 0x2AEE, 0x2AEF, 0x2AF0, 0x2AF1, 0x2AF2, 0x2AF3, 	// 0x8138A239
	0x2AF4, 0x2AF5, 0x2AF6, 0x2AF7, 0x2AF8, 0x2AF9, 0x2AFA, 0x2AFB, 0x2AFC, 0x2AFD, 	// 0x8138A339
	0x2AFE, 0x2AFF, 0x2B00, 0x2B01, 0x2B02, 0x2B03, 0x2B04, 0x2B05, 0x2B06, 0x2B07, 	// 0x8138A439
	0x2B08, 0x2B09, 0x2B0A, 0x2B0B, 0x2B0C, 0x2B0D, 0x2B0E, 0x2B0F, 0x2B10, 0x2B11, 	// 0x8138A539
	0x2B12, 0x2B13, 0x2B14, 0x2B15, 0x2B16, 0x2B17, 0x2B18, 0x2B19, 0x2B1A, 0x2B1B, 	// 0x8138A639
	0x2B1C, 0x2B1D, 0x2B1E, 0x2B1F, 0x2B20, 0x2B21, 0x2B22, 0x2B23, 0x2B24, 0x2B25, 	// 0x8138A739
	0x2B26, 0x2B27, 0x2B28, 0x2B29, 0x2B2A, 0x2B2B, 0x2B2C, 0x2B2D, 0x2B2E, 0x2B2F, 	// 0x8138A839
	0x2B30, 0x2B31, 0x2B32, 0x2B33, 0x2B34, 0x2B35, 0x2B36, 0x2B37, 0x2B38, 0x2B39, 	// 0x8138A939
	0x2B3A, 0x2B3B, 0x2B3C, 0x2B3D, 0x2B3E, 0x2B3F, 0x2B40, 0x2B41, 0x2B42, 0x2B43, 	// 0x8138AA39
	0x2B44, 0x2B45, 0x2B46, 0x2B47, 0x2B48, 0x2B49, 0x2B4A, 0x2B4B, 0x2B4C, 0x2B4D, 	// 0x8138AB39
	0x2B4E, 0x2B4F, 0x2B50, 0x2B51, 0x2B52, 0x2B53, 0x2B54, 0x2B55, 0x2B56, 0x2B57, 	// 0x8138AC39
	0x2B58, 0x2B59, 0x2B5A, 0x2B5B, 0x2B5C, 0x2B5D, 0x2B5E, 0x2B5F, 0x2B60, 0x2B61, 	// 0x8138AD39
	0x2B62, 0x2B63, 0x2B64, 0x2B65, 0x2B66, 0x2B67, 0x2B68, 0x2B69, 0x2B6A, 0x2B6B, 	// 0x8138AE39
	0x2B6C, 0x2B6D, 0x2B6E, 0x2B6F, 0x2B70, 0x2B71, 0x2B72, 0x2B73, 0x2B74, 0x2B75, 	// 0x8138AF39
	0x2B76, 0x2B77, 0x2B78, 0x2B79, 0x2B7A, 0x2B7B, 0x2B7C, 0x2B7D, 0x2B7E, 0x2B7F, 	// 0x8138B039
	0x2B80, 0x2B81, 0x2B82, 0x2B83, 0x2B84, 0x2B85, 0x2B86, 0x2B87, 0x2B88, 0x2B89, 	// 0x8138B139
	0x2B8A, 0x2B8B, 0x2B8C, 0x2B8D, 0x2B8E, 0x2B8F, 0x2B90, 0x2B91, 0x2B92, 0x2B93, 	// 0x8138B239
	0x2B94, 0x2B95, 0x2B96, 0x2B97, 0x2B98, 0x2B99, 0x2B9A, 0x2B9B, 0x2B9C, 0x2B9D, 	// 0x8138B339
	0x2B9E, 0x2B9F, 0x2BA0, 0x2BA1, 0x2BA2, 0x2BA3, 0x2BA4, 0x2BA5, 0x2BA6, 0x2BA7, 	// 0x8138B439
	0x2BA8, 0x2BA9, 0x2BAA, 0x2BAB, 0x2BAC, 0x2BAD, 0x2BAE, 0x2BAF, 0x2BB0, 0x2BB1, 	// 0x8138B539
	0x2BB2, 0x2BB3, 0x2BB4, 0x2BB5, 0x2BB6, 0x2BB7, 0x2BB8, 0x2BB9, 0x2BBA, 0x2BBB, 	// 0x8138B639
	0x2BBC, 0x2BBD, 0x2BBE, 0x2BBF, 0x2BC0, 0x2BC1, 0x2BC2, 0x2BC3, 0x2BC4, 0x2BC5, 	// 0x8138B739
	0x2BC6, 0x2BC7, 0x2BC8, 0x2BC9, 0x2BCA, 0x2BCB, 0x2BCC, 0x2BCD, 0x2BCE, 0x2BCF, 	// 0x8138B839
	0x2BD0, 0x2BD1, 0x2BD2, 0x2BD3, 0x2BD4, 0x2BD5, 0x2BD6, 0x2BD7, 0x2BD8, 0x2BD9, 	// 0x8138B939
	0x2BDA, 0x2BDB, 0x2BDC, 0x2BDD, 0x2BDE, 0x2BDF, 0x2BE0, 0x2BE1, 0x2BE2, 0x2BE3, 	// 0x8138BA39
	0x2BE4, 0x2BE5, 0x2BE6, 0x2BE7, 0x2BE8, 0x2BE9, 0x2BEA, 0x2BEB, 0x2BEC, 0x2BED, 	// 0x8138BB39
	0x2BEE, 0x2BEF, 0x2BF0, 0x2BF1, 0x2BF2, 0x2BF3, 0x2BF4, 0x2BF5, 0x2BF6, 0x2BF7, 	// 0x8138BC39
	0x2BF8, 0x2BF9, 0x2BFA, 0x2BFB, 0x2BFC, 0x2BFD, 0x2BFE, 0x2BFF, 0x2C00, 0x2C01, 	// 0x8138BD39
	0x2C02, 0x2C03, 0x2C04, 0x2C05, 0x2C06, 0x2C07, 0x2C08, 0x2C09, 0x2C0A, 0x2C0B, 	// 0x8138BE39
	0x2C0C, 0x2C0D, 0x2C0E, 0x2C0F, 0x2C10, 0x2C11, 0x2C12, 0x2C13, 0x2C14, 0x2C15, 	// 0x8138BF39
	0x2C16, 0x2C17, 0x2C18, 0x2C19, 0x2C1A, 0x2C1B, 0x2C1C, 0x2C1D, 0x2C1E, 0x2C1F, 	// 0x8138C039
	0x2C20, 0x2C21, 0x2C22, 0x2C23, 0x2C24, 0x2C25, 0x2C26, 0x2C27, 0x2C28, 0x2C29, 	// 0x8138C139
	0x2C2A, 0x2C2B, 0x2C2C, 0x2C2D, 0x2C2E, 0x2C2F, 0x2C30, 0x2C31, 0x2C32, 0x2C33, 	// 0x8138C239
	0x2C34, 0x2C35, 0x2C36, 0x2C37, 0x2C38, 0x2C39, 0x2C3A, 0x2C3B, 0x2C3C, 0x2C3D, 	// 0x8138C339
	0x2C3E, 0x2C3F, 0x2C40, 0x2C41, 0x2C42, 0x2C43, 0x2C44, 0x2C45, 0x2C46, 0x2C47, 	// 0x8138C439
	0x2C48, 0x2C49, 0x2C4A, 0x2C4B, 0x2C4C, 0x2C4D, 0x2C4E, 0x2C4F, 0x2C50, 0x2C51, 	// 0x8138C539
	0x2C52, 0x2C53, 0x2C54, 0x2C55, 0x2C56, 0x2C57, 0x2C58, 0x2C59, 0x2C5A, 0x2C5B, 	// 0x8138C639
	0x2C5C, 0x2C5D, 0x2C5E, 0x2C5F, 0x2C60, 0x2C61, 0x2C62, 0x2C63, 0x2C64, 0x2C65, 	// 0x8138C739
	0x2C66, 0x2C67, 0x2C68, 0x2C69, 0x2C6A, 0x2C6B, 0x2C6C, 0x2C6D, 0x2C6E, 0x2C6F, 	// 0x8138C839
	0x2C70, 0x2C71, 0x2C72, 0x2C73, 0x2C74, 0x2C75, 0x2C76, 0x2C77, 0x2C78, 0x2C79, 	// 0x8138C939
	0x2C7A, 0x2C7B, 0x2C7C, 0x2C7D, 0x2C7E, 0x2C7F, 0x2C80, 0x2C81, 0x2C82, 0x2C83, 	// 0x8138CA39
	0x2C84, 0x2C85, 0x2C86, 0x2C87, 0x2C88, 0x2C89, 0x2C8A, 0x2C8B, 0x2C8C, 0x2C8D, 	// 0x8138CB39
	0x2C8E, 0x2C8F, 0x2C90, 0x2C91, 0x2C92, 0x2C93, 0x2C94, 0x2C95, 0x2C96, 0x2C97, 	// 0x8138CC39
	0x2C98, 0x2C99, 0x2C9A, 0x2C9B, 0x2C9C, 0x2C9D, 0x2C9E, 0x2C9F, 0x2CA0, 0x2CA1, 	// 0x8138CD39
	0x2CA2, 0x2CA3, 0x2CA4, 0x2CA5, 0x2CA6, 0x2CA7, 0x2CA8, 0x2CA9, 0x2CAA, 0x2CAB, 	// 0x8138CE39
	0x2CAC, 0x2CAD, 0x2CAE, 0x2CAF, 0x2CB0, 0x2CB1, 0x2CB2, 0x2CB3, 0x2CB4, 0x2CB5, 	// 0x8138CF39
	0x2CB6, 0x2CB7, 0x2CB8, 0x2CB9, 0x2CBA, 0x2CBB, 0x2CBC, 0x2CBD, 0x2CBE, 0x2CBF, 	// 0x8138D039
	0x2CC0, 0x2CC1, 0x2CC2, 0x2CC3, 0x2CC4, 0x2CC5, 0x2CC6, 0x2CC7, 0x2CC8, 0x2CC9, 	// 0x8138D139
	0x2CCA, 0x2CCB, 0x2CCC, 0x2CCD, 0x2CCE, 0x2CCF, 0x2CD0, 0x2CD1, 0x2CD2, 0x2CD3, 	// 0x8138D239
	0x2CD4, 0x2CD5, 0x2CD6, 0x2CD7, 0x2CD8, 0x2CD9, 0x2CDA, 0x2CDB, 0x2CDC, 0x2CDD, 	// 0x8138D339
	0x2CDE, 0x2CDF, 0x2CE0, 0x2CE1, 0x2CE2, 0x2CE3, 0x2CE4, 0x2CE5, 0x2CE6, 0x2CE7, 	// 0x8138D439
	0x2CE8, 0x2CE9, 0x2CEA, 0x2CEB, 0x2CEC, 0x2CED, 0x2CEE, 0x2CEF, 0x2CF0, 0x2CF1, 	// 0x8138D539
	0x2CF2, 0x2CF3, 0x2CF4, 0x2CF5, 0x2CF6, 0x2CF7, 0x2CF8, 0x2CF9, 0x2CFA, 0x2CFB, 	// 0x8138D639
	0x2CFC, 0x2CFD, 0x2CFE, 0x2CFF, 0x2D00, 0x2D01, 0x2D02, 0x2D03, 0x2D04, 0x2D05, 	// 0x8138D739
	0x2D06, 0x2D07, 0x2D08, 0x2D09, 0x2D0A, 0x2D0B, 0x2D0C, 0x2D0D, 0x2D0E, 0x2D0F, 	// 0x8138D839
	0x2D10, 0x2D11, 0x2D12, 0x2D13, 0x2D14, 0x2D15, 0x2D16, 0x2D17, 0x2D18, 0x2D19, 	// 0x8138D939
	0x2D1A, 0x2D1B, 0x2D1C, 0x2D1D, 0x2D1E, 0x2D1F, 0x2D20, 0x2D21, 0x2D22, 0x2D23, 	// 0x8138DA39
	0x2D24, 0x2D25, 0x2D26, 0x2D27, 0x2D28, 0x2D29, 0x2D2A, 0x2D2B, 0x2D2C, 0x2D2D, 	// 0x8138DB39
	0x2D2E, 0x2D2F, 0x2D30, 0x2D31, 0x2D32, 0x2D33, 0x2D34, 0x2D35, 0x2D36, 0x2D37, 	// 0x8138DC39
	0x2D38, 0x2D39, 0x2D3A, 0x2D3B, 0x2D3C, 0x2D3D, 0x2D3E, 0x2D3F, 0x2D40, 0x2D41, 	// 0x8138DD39
	0x2D42, 0x2D43, 0x2D44, 0x2D45, 0x2D46, 0x2D47, 0x2D48, 0x2D49, 0x2D4A, 0x2D4B, 	// 0x8138DE39
	0x2D4C, 0x2D4D, 0x2D4E, 0x2D4F, 0x2D50, 0x2D51, 0x2D52, 0x2D53, 0x2D54, 0x2D55, 	// 0x8138DF39
	0x2D56, 0x2D57, 0x2D58, 0x2D59, 0x2D5A, 0x2D5B, 0x2D5C, 0x2D5D, 0x2D5E, 0x2D5F, 	// 0x8138E039
	0x2D60, 0x2D61, 0x2D62, 0x2D63, 0x2D64, 0x2D65, 0x2D66, 0x2D67, 0x2D68, 0x2D69, 	// 0x8138E139
	0x2D6A, 0x2D6B, 0x2D6C, 0x2D6D, 0x2D6E, 0x2D6F, 0x2D70, 0x2D71, 0x2D72, 0x2D73, 	// 0x8138E239
	0x2D74, 0x2D75, 0x2D76, 0x2D77, 0x2D78, 0x2D79, 0x2D7A, 0x2D7B, 0x2D7C, 0x2D7D, 	// 0x8138E339
	0x2D7E, 0x2D7F, 0x2D80, 0x2D81, 0x2D82, 0x2D83, 0x2D84, 0x2D85, 0x2D86, 0x2D87, 	// 0x8138E439
	0x2D88, 0x2D89, 0x2D8A, 0x2D8B, 0x2D8C, 0x2D8D, 0x2D8E, 0x2D8F, 0x2D90, 0x2D91, 	// 0x8138E539
	0x2D92, 0x2D93, 0x2D94, 0x2D95, 0x2D96, 0x2D97, 0x2D98, 0x2D99, 0x2D9A, 0x2D9B, 	// 0x8138E639
	0x2D9C, 0x2D9D, 0x2D9E, 0x2D9F, 0x2DA0, 0x2DA1, 0x2DA2, 0x2DA3, 0x2DA4, 0x2DA5, 	// 0x8138E739
	0x2DA6, 0x2DA7, 0x2DA8, 0x2DA9, 0x2DAA, 0x2DAB, 0x2DAC, 0x2DAD, 0x2DAE, 0x2DAF, 	// 0x8138E839
	0x2DB0, 0x2DB1, 0x2DB2, 0x2DB3, 0x2DB4, 0x2DB5, 0x2DB6, 0x2DB7, 0x2DB8, 0x2DB9, 	// 0x8138E939
	0x2DBA, 0x2DBB, 0x2DBC, 0x2DBD, 0x2DBE, 0x2DBF, 0x2DC0, 0x2DC1, 0x2DC2, 0x2DC3, 	// 0x8138EA39
	0x2DC4, 0x2DC5, 0x2DC6, 0x2DC7, 0x2DC8, 0x2DC9, 0x2DCA, 0x2DCB, 0x2DCC, 0x2DCD, 	// 0x8138EB39
	0x2DCE, 0x2DCF, 0x2DD0, 0x2DD1, 0x2DD2, 0x2DD3, 0x2DD4, 0x2DD5, 0x2DD6, 0x2DD7, 	// 0x8138EC39
	0x2DD8, 0x2DD9, 0x2DDA, 0x2DDB, 0x2DDC, 0x2DDD, 0x2DDE, 0x2DDF, 0x2DE0, 0x2DE1, 	// 0x8138ED39
	0x2DE2, 0x2DE3, 0x2DE4, 0x2DE5, 0x2DE6, 0x2DE7, 0x2DE8, 0x2DE9, 0x2DEA, 0x2DEB, 	// 0x8138EE39
	0x2DEC, 0x2DED, 0x2DEE, 0x2DEF, 0x2DF0, 0x2DF1, 0x2DF2, 0x2DF3, 0x2DF4, 0x2DF5, 	// 0x8138EF39
	0x2DF6, 0x2DF7, 0x2DF8, 0x2DF9, 0x2DFA, 0x2DFB, 0x2DFC, 0x2DFD, 0x2DFE, 0x2DFF, 	// 0x8138F039
	0x2E00, 0x2E01, 0x2E02, 0x2E03, 0x2E04, 0x2E05, 0x2E06, 0x2E07, 0x2E08, 0x2E09, 	// 0x8138F139
	0x2E0A, 0x2E0B, 0x2E0C, 0x2E0D, 0x2E0E, 0x2E0F, 0x2E10, 0x2E11, 0x2E12, 0x2E13, 	// 0x8138F239
	0x2E14, 0x2E15, 0x2E16, 0x2E17, 0x2E18, 0x2E19, 0x2E1A, 0x2E1B, 0x2E1C, 0x2E1D, 	// 0x8138F339
	0x2E1E, 0x2E1F, 0x2E20, 0x2E21, 0x2E22, 0x2E23, 0x2E24, 0x2E25, 0x2E26, 0x2E27, 	// 0x8138F439
	0x2E28, 0x2E29, 0x2E2A, 0x2E2B, 0x2E2C, 0x2E2D, 0x2E2E, 0x2E2F, 0x2E30, 0x2E31, 	// 0x8138F539
	0x2E32, 0x2E33, 0x2E34, 0x2E35, 0x2E36, 0x2E37, 0x2E38, 0x2E39, 0x2E3A, 0x2E3B, 	// 0x8138F639
	0x2E3C, 0x2E3D, 0x2E3E, 0x2E3F, 0x2E40, 0x2E41, 0x2E42, 0x2E43, 0x2E44, 0x2E45, 	// 0x8138F739
	0x2E46, 0x2E47, 0x2E48, 0x2E49, 0x2E4A, 0x2E4B, 0x2E4C, 0x2E4D, 0x2E4E, 0x2E4F, 	// 0x8138F839
	0x2E50, 0x2E51, 0x2E52, 0x2E53, 0x2E54, 0x2E55, 0x2E56, 0x2E57, 0x2E58, 0x2E59, 	// 0x8138F939
	0x2E5A, 0x2E5B, 0x2E5C, 0x2E5D, 0x2E5E, 0x2E5F, 0x2E60, 0x2E61, 0x2E62, 0x2E63, 	// 0x8138FA39
	0x2E64, 0x2E65, 0x2E66, 0x2E67, 0x2E68, 0x2E69, 0x2E6A, 0x2E6B, 0x2E6C, 0x2E6D, 	// 0x8138FB39
	0x2E6E, 0x2E6F, 0x2E70, 0x2E71, 0x2E72, 0x2E73, 0x2E74, 0x2E75, 0x2E76, 0x2E77, 	// 0x8138FC39
	0x2E78, 0x2E79, 0x2E7A, 0x2E7B, 0x2E7C, 0x2E7D, 0x2E7E, 0x2E7F, 0x2E80, 0x2E82, 	// 0x8138FD39
	0x2E83, 0x2E85, 0x2E86, 0x2E87, 0x2E89, 0x2E8A, 0x2E8D, 0x2E8E, 0x2E8F, 0x2E90, 	// 0x8138FE39
	0x2E91, 0x2E92, 0x2E93, 0x2E94, 0x2E95, 0x2E96, 0x2E98, 0x2E99, 0x2E9A, 0x2E9B, 	// 0x81398139
	0x2E9C, 0x2E9D, 0x2E9E, 0x2E9F, 0x2EA0, 0x2EA1, 0x2EA2, 0x2EA3, 0x2EA4, 0x2EA5, 	// 0x81398239
	0x2EA6, 0x2EA8, 0x2EA9, 0x2EAB, 0x2EAC, 0x2EAD, 0x2EAF, 0x2EB0, 0x2EB1, 0x2EB2, 	// 0x81398339
	0x2EB4, 0x2EB5, 0x2EB8, 0x2EB9, 0x2EBA, 0x2EBC, 0x2EBD, 0x2EBE, 0x2EBF, 0x2EC0, 	// 0x81398439
	0x2EC1, 0x2EC2, 0x2EC3, 0x2EC4, 0x2EC5, 0x2EC6, 0x2EC7, 0x2EC8, 0x2EC9, 0x2ECB, 	// 0x81398539
	0x2ECC, 0x2ECD, 0x2ECE, 0x2ECF, 0x2ED0, 0x2ED1, 0x2ED2, 0x2ED3, 0x2ED4, 0x2ED5, 	// 0x81398639
	0x2ED6, 0x2ED7, 0x2ED8, 0x2ED9, 0x2EDA, 0x2EDB, 0x2EDC, 0x2EDD, 0x2EDE, 0x2EDF, 	// 0x81398739
	0x2EE0, 0x2EE1, 0x2EE2, 0x2EE3, 0x2EE4, 0x2EE5, 0x2EE6, 0x2EE7, 0x2EE8, 0x2EE9, 	// 0x81398839
	0x2EEA, 0x2EEB, 0x2EEC, 0x2EED, 0x2EEE, 0x2EEF, 0x2EF0, 0x2EF1, 0x2EF2, 0x2EF3, 	// 0x81398939
	0x2EF4, 0x2EF5, 0x2EF6, 0x2EF7, 0x2EF8, 0x2EF9, 0x2EFA, 0x2EFB, 0x2EFC, 0x2EFD, 	// 0x81398A39
	0x2EFE, 0x2EFF, 0x2F00, 0x2F01, 0x2F02, 0x2F03, 0x2F04, 0x2F05, 0x2F06, 0x2F07, 	// 0x81398B39
	0x2F08, 0x2F09, 0x2F0A, 0x2F0B, 0x2F0C, 0x2F0D, 0x2F0E, 0x2F0F, 0x2F10, 0x2F11, 	// 0x81398C39
	0x2F12, 0x2F13, 0x2F14, 0x2F15, 0x2F16, 0x2F17, 0x2F18, 0x2F19, 0x2F1A, 0x2F1B, 	// 0x81398D39
	0x2F1C, 0x2F1D, 0x2F1E, 0x2F1F, 0x2F20, 0x2F21, 0x2F22, 0x2F23, 0x2F24, 0x2F25, 	// 0x81398E39
	0x2F26, 0x2F27, 0x2F28, 0x2F29, 0x2F2A, 0x2F2B, 0x2F2C, 0x2F2D, 0x2F2E, 0x2F2F, 	// 0x81398F39
	0x2F30, 0x2F31, 0x2F32, 0x2F33, 0x2F34, 0x2F35, 0x2F36, 0x2F37, 0x2F38, 0x2F39, 	// 0x81399039
	0x2F3A, 0x2F3B, 0x2F3C, 0x2F3D, 0x2F3E, 0x2F3F, 0x2F40, 0x2F41, 0x2F42, 0x2F43, 	// 0x81399139
	0x2F44, 0x2F45, 0x2F46, 0x2F47, 0x2F48, 0x2F49, 0x2F4A, 0x2F4B, 0x2F4C, 0x2F4D, 	// 0x81399239
	0x2F4E, 0x2F4F, 0x2F50, 0x2F51, 0x2F52, 0x2F53, 0x2F54, 0x2F55, 0x2F56, 0x2F57, 	// 0x81399339
	0x2F58, 0x2F59, 0x2F5A, 0x2F5B, 0x2F5C, 0x2F5D, 0x2F5E, 0x2F5F, 0x2F60, 0x2F61, 	// 0x81399439
	0x2F62, 0x2F63, 0x2F64, 0x2F65, 0x2F66, 0x2F67, 0x2F68, 0x2F69, 0x2F6A, 0x2F6B, 	// 0x81399539
	0x2F6C, 0x2F6D, 0x2F6E, 0x2F6F, 0x2F70, 0x2F71, 0x2F72, 0x2F73, 0x2F74, 0x2F75, 	// 0x81399639
	0x2F76, 0x2F77, 0x2F78, 0x2F79, 0x2F7A, 0x2F7B, 0x2F7C, 0x2F7D, 0x2F7E, 0x2F7F, 	// 0x81399739
	0x2F80, 0x2F81, 0x2F82, 0x2F83, 0x2F84, 0x2F85, 0x2F86, 0x2F87, 0x2F88, 0x2F89, 	// 0x81399839
	0x2F8A, 0x2F8B, 0x2F8C, 0x2F8D, 0x2F8E, 0x2F8F, 0x2F90, 0x2F91, 0x2F92, 0x2F93, 	// 0x81399939
	0x2F94, 0x2F95, 0x2F96, 0x2F97, 0x2F98, 0x2F99, 0x2F9A, 0x2F9B, 0x2F9C, 0x2F9D, 	// 0x81399A39
	0x2F9E, 0x2F9F, 0x2FA0, 0x2FA1, 0x2FA2, 0x2FA3, 0x2FA4, 0x2FA5, 0x2FA6, 0x2FA7, 	// 0x81399B39
	0x2FA8, 0x2FA9, 0x2FAA, 0x2FAB, 0x2FAC, 0x2FAD, 0x2FAE, 0x2FAF, 0x2FB0, 0x2FB1, 	// 0x81399C39
	0x2FB2, 0x2FB3, 0x2FB4, 0x2FB5, 0x2FB6, 0x2FB7, 0x2FB8, 0x2FB9, 0x2FBA, 0x2FBB, 	// 0x81399D39
	0x2FBC, 0x2FBD, 0x2FBE, 0x2FBF, 0x2FC0, 0x2FC1, 0x2FC2, 0x2FC3, 0x2FC4, 0x2FC5, 	// 0x81399E39
	0x2FC6, 0x2FC7, 0x2FC8, 0x2FC9, 0x2FCA, 0x2FCB, 0x2FCC, 0x2FCD, 0x2FCE, 0x2FCF, 	// 0x81399F39
	0x2FD0, 0x2FD1, 0x2FD2, 0x2FD3, 0x2FD4, 0x2FD5, 0x2FD6, 0x2FD7, 0x2FD8, 0x2FD9, 	// 0x8139A039
	0x2FDA, 0x2FDB, 0x2FDC, 0x2FDD, 0x2FDE, 0x2FDF, 0x2FE0, 0x2FE1, 0x2FE2, 0x2FE3, 	// 0x8139A139
	0x2FE4, 0x2FE5, 0x2FE6, 0x2FE7, 0x2FE8, 0x2FE9, 0x2FEA, 0x2FEB, 0x2FEC, 0x2FED, 	// 0x8139A239
	0x2FEE, 0x2FEF, 0x2FFC, 0x2FFD, 0x2FFE, 0x2FFF, 0x3004, 0x3018, 0x3019, 0x301A, 	// 0x8139A339
	0x301B, 0x301C, 0x301F, 0x3020, 0x302A, 0x302B, 0x302C, 0x302D, 0x302E, 0x302F, 	// 0x8139A439
	0x3030, 0x3031, 0x3032, 0x3033, 0x3034, 0x3035, 0x3036, 0x3037, 0x3038, 0x3039, 	// 0x8139A539
	0x303A, 0x303B, 0x303C, 0x303D, 0x303F, 0x3040, 0x3094, 0x3095, 0x3096, 0x3097, 	// 0x8139A639
	0x3098, 0x3099, 0x309A, 0x309F, 0x30A0, 0x30F7, 0x30F8, 0x30F9, 0x30FA, 0x30FB, 	// 0x8139A739
	0x30FF, 0x3100, 0x3101, 0x3102, 0x3103, 0x3104, 0x312A, 0x312B, 0x312C, 0x312D, 	// 0x8139A839
	0x312E, 0x312F, 0x3130, 0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136, 0x3137, 	// 0x8139A939
	0x3138, 0x3139, 0x313A, 0x313B, 0x313C, 0x313D, 0x313E, 0x313F, 0x3140, 0x3141, 	// 0x8139AA39
	0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148, 0x3149, 0x314A, 0x314B, 	// 0x8139AB39
	0x314C, 0x314D, 0x314E, 0x314F, 0x3150, 0x3151, 0x3152, 0x3153, 0x3154, 0x3155, 	// 0x8139AC39
	0x3156, 0x3157, 0x3158, 0x3159, 0x315A, 0x315B, 0x315C, 0x315D, 0x315E, 0x315F, 	// 0x8139AD39
	0x3160, 0x3161, 0x3162, 0x3163, 0x3164, 0x3165, 0x3166, 0x3167, 0x3168, 0x3169, 	// 0x8139AE39
	0x316A, 0x316B, 0x316C, 0x316D, 0x316E, 0x316F, 0x3170, 0x3171, 0x3172, 0x3173, 	// 0x8139AF39
	0x3174, 0x3175, 0x3176, 0x3177, 0x3178, 0x3179, 0x317A, 0x317B, 0x317C, 0x317D, 	// 0x8139B039
	0x317E, 0x317F, 0x3180, 0x3181, 0x3182, 0x3183, 0x3184, 0x3185, 0x3186, 0x3187, 	// 0x8139B139
	0x3188, 0x3189, 0x318A, 0x318B, 0x318C, 0x318D, 0x318E, 0x318F, 0x3190, 0x3191, 	// 0x8139B239
	0x3192, 0x3193, 0x3194, 0x3195, 0x3196, 0x3197, 0x3198, 0x3199, 0x319A, 0x319B, 	// 0x8139B339
	0x319C, 0x319D, 0x319E, 0x319F, 0x31A0, 0x31A1, 0x31A2, 0x31A3, 0x31A4, 0x31A5, 	// 0x8139B439
	0x31A6, 0x31A7, 0x31A8, 0x31A9, 0x31AA, 0x31AB, 0x31AC, 0x31AD, 0x31AE, 0x31AF, 	// 0x8139B539
	0x31B0, 0x31B1, 0x31B2, 0x31B3, 0x31B4, 0x31B5, 0x31B6, 0x31B7, 0x31B8, 0x31B9, 	// 0x8139B639
	0x31BA, 0x31BB, 0x31BC, 0x31BD, 0x31BE, 0x31BF, 0x31C0, 0x31C1, 0x31C2, 0x31C3, 	// 0x8139B739
	0x31C4, 0x31C5, 0x31C6, 0x31C7, 0x31C8, 0x31C9, 0x31CA, 0x31CB, 0x31CC, 0x31CD, 	// 0x8139B839
	0x31CE, 0x31CF, 0x31D0, 0x31D1, 0x31D2, 0x31D3, 0x31D4, 0x31D5, 0x31D6, 0x31D7, 	// 0x8139B939
	0x31D8, 0x31D9, 0x31DA, 0x31DB, 0x31DC, 0x31DD, 0x31DE, 0x31DF, 0x31E0, 0x31E1, 	// 0x8139BA39
	0x31E2, 0x31E3, 0x31E4, 0x31E5, 0x31E6, 0x31E7, 0x31E8, 0x31E9, 0x31EA, 0x31EB, 	// 0x8139BB39
	0x31EC, 0x31ED, 0x31EE, 0x31EF, 0x31F0, 0x31F1, 0x31F2, 0x31F3, 0x31F4, 0x31F5, 	// 0x8139BC39
	0x31F6, 0x31F7, 0x31F8, 0x31F9, 0x31FA, 0x31FB, 0x31FC, 0x31FD, 0x31FE, 0x31FF, 	// 0x8139BD39
	0x3200, 0x3201, 0x3202, 0x3203, 0x3204, 0x3205, 0x3206, 0x3207, 0x3208, 0x3209, 	// 0x8139BE39
	0x320A, 0x320B, 0x320C, 0x320D, 0x320E, 0x320F, 0x3210, 0x3211, 0x3212, 0x3213, 	// 0x8139BF39
	0x3214, 0x3215, 0x3216, 0x3217, 0x3218, 0x3219, 0x321A, 0x321B, 0x321C, 0x321D, 	// 0x8139C039
	0x321E, 0x321F, 0x322A, 0x322B, 0x322C, 0x322D, 0x322E, 0x322F, 0x3230, 0x3232, 	// 0x8139C139
	0x3233, 0x3234, 0x3235, 0x3236, 0x3237, 0x3238, 0x3239, 0x323A, 0x323B, 0x323C, 	// 0x8139C239
	0x323D, 0x323E, 0x323F, 0x3240, 0x3241, 0x3242, 0x3243, 0x3244, 0x3245, 0x3246, 	// 0x8139C339
	0x3247, 0x3248, 0x3249, 0x324A, 0x324B, 0x324C, 0x324D, 0x324E, 0x324F, 0x3250, 	// 0x8139C439
	0x3251, 0x3252, 0x3253, 0x3254, 0x3255, 0x3256, 0x3257, 0x3258, 0x3259, 0x325A, 	// 0x8139C539
	0x325B, 0x325C, 0x325D, 0x325E, 0x325F, 0x3260, 0x3261, 0x3262, 0x3263, 0x3264, 	// 0x8139C639
	0x3265, 0x3266, 0x3267, 0x3268, 0x3269, 0x326A, 0x326B, 0x326C, 0x326D, 0x326E, 	// 0x8139C739
	0x326F, 0x3270, 0x3271, 0x3272, 0x3273, 0x3274, 0x3275, 0x3276, 0x3277, 0x3278, 	// 0x8139C839
	0x3279, 0x327A, 0x327B, 0x327C, 0x327D, 0x327E, 0x327F, 0x3280, 0x3281, 0x3282, 	// 0x8139C939
	0x3283, 0x3284, 0x3285, 0x3286, 0x3287, 0x3288, 0x3289, 0x328A, 0x328B, 0x328C, 	// 0x8139CA39
	0x328D, 0x328E, 0x328F, 0x3290, 0x3291, 0x3292, 0x3293, 0x3294, 0x3295, 0x3296, 	// 0x8139CB39
	0x3297, 0x3298, 0x3299, 0x329A, 0x329B, 0x329C, 0x329D, 0x329E, 0x329F, 0x32A0, 	// 0x8139CC39
	0x32A1, 0x32A2, 0x32A4, 0x32A5, 0x32A6, 0x32A7, 0x32A8, 0x32A9, 0x32AA, 0x32AB, 	// 0x8139CD39
	0x32AC, 0x32AD, 0x32AE, 0x32AF, 0x32B0, 0x32B1, 0x32B2, 0x32B3, 0x32B4, 0x32B5, 	// 0x8139CE39
	0x32B6, 0x32B7, 0x32B8, 0x32B9, 0x32BA, 0x32BB, 0x32BC, 0x32BD, 0x32BE, 0x32BF, 	// 0x8139CF39
	0x32C0, 0x32C1, 0x32C2, 0x32C3, 0x32C4, 0x32C5, 0x32C6, 0x32C7, 0x32C8, 0x32C9, 	// 0x8139D039
	0x32CA, 0x32CB, 0x32CC, 0x32CD, 0x32CE, 0x32CF, 0x32D0, 0x32D1, 0x32D2, 0x32D3, 	// 0x8139D139
	0x32D4, 0x32D5, 0x32D6, 0x32D7, 0x32D8, 0x32D9, 0x32DA, 0x32DB, 0x32DC, 0x32DD, 	// 0x8139D239
	0x32DE, 0x32DF, 0x32E0, 0x32E1, 0x32E2, 0x32E3, 0x32E4, 0x32E5, 0x32E6, 0x32E7, 	// 0x8139D339
	0x32E8, 0x32E9, 0x32EA, 0x32EB, 0x32EC, 0x32ED, 0x32EE, 0x32EF, 0x32F0, 0x32F1, 	// 0x8139D439
	0x32F2, 0x32F3, 0x32F4, 0x32F5, 0x32F6, 0x32F7, 0x32F8, 0x32F9, 0x32FA, 0x32FB, 	// 0x8139D539
	0x32FC, 0x32FD, 0x32FE, 0x32FF, 0x3300, 0x3301, 0x3302, 0x3303, 0x3304, 0x3305, 	// 0x8139D639
	0x3306, 0x3307, 0x3308, 0x3309, 0x330A, 0x330B, 0x330C, 0x330D, 0x330E, 0x330F, 	// 0x8139D739
	0x3310, 0x3311, 0x3312, 0x3313, 0x3314, 0x3315, 0x3316, 0x3317, 0x3318, 0x3319, 	// 0x8139D839
	0x331A, 0x331B, 0x331C, 0x331D, 0x331E, 0x331F, 0x3320, 0x3321, 0x3322, 0x3323, 	// 0x8139D939
	0x3324, 0x3325, 0x3326, 0x3327, 0x3328, 0x3329, 0x332A, 0x332B, 0x332C, 0x332D, 	// 0x8139DA39
	0x332E, 0x332F, 0x3330, 0x3331, 0x3332, 0x3333, 0x3334, 0x3335, 0x3336, 0x3337, 	// 0x8139DB39
	0x3338, 0x3339, 0x333A, 0x333B, 0x333C, 0x333D, 0x333E, 0x333F, 0x3340, 0x3341, 	// 0x8139DC39
	0x3342, 0x3343, 0x3344, 0x3345, 0x3346, 0x3347, 0x3348, 0x3349, 0x334A, 0x334B, 	// 0x8139DD39
	0x334C, 0x334D, 0x334E, 0x334F, 0x3350, 0x3351, 0x3352, 0x3353, 0x3354, 0x3355, 	// 0x8139DE39
	0x3356, 0x3357, 0x3358, 0x3359, 0x335A, 0x335B, 0x335C, 0x335D, 0x335E, 0x335F, 	// 0x8139DF39
	0x3360, 0x3361, 0x3362, 0x3363, 0x3364, 0x3365, 0x3366, 0x3367, 0x3368, 0x3369, 	// 0x8139E039
	0x336A, 0x336B, 0x336C, 0x336D, 0x336E, 0x336F, 0x3370, 0x3371, 0x3372, 0x3373, 	// 0x8139E139
	0x3374, 0x3375, 0x3376, 0x3377, 0x3378, 0x3379, 0x337A, 0x337B, 0x337C, 0x337D, 	// 0x8139E239
	0x337E, 0x337F, 0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x3385, 0x3386, 0x3387, 	// 0x8139E339
	0x3388, 0x3389, 0x338A, 0x338B, 0x338C, 0x338D, 0x3390, 0x3391, 0x3392, 0x3393, 	// 0x8139E439
	0x3394, 0x3395, 0x3396, 0x3397, 0x3398, 0x3399, 0x339A, 0x339B, 0x339F, 0x33A0, 	// 0x8139E539
	0x33A2, 0x33A3, 0x33A4, 0x33A5, 0x33A6, 0x33A7, 0x33A8, 0x33A9, 0x33AA, 0x33AB, 	// 0x8139E639
	0x33AC, 0x33AD, 0x33AE, 0x33AF, 0x33B0, 0x33B1, 0x33B2, 0x33B3, 0x33B4, 0x33B5, 	// 0x8139E739
	0x33B6, 0x33B7, 0x33B8, 0x33B9, 0x33BA, 0x33BB, 0x33BC, 0x33BD, 0x33BE, 0x33BF, 	// 0x8139E839
	0x33C0, 0x33C1, 0x33C2, 0x33C3, 0x33C5, 0x33C6, 0x33C7, 0x33C8, 0x33C9, 0x33CA, 	// 0x8139E939
	0x33CB, 0x33CC, 0x33CD, 0x33CF, 0x33D0, 0x33D3, 0x33D4, 0x33D6, 0x33D7, 0x33D8, 	// 0x8139EA39
	0x33D9, 0x33DA, 0x33DB, 0x33DC, 0x33DD, 0x33DE, 0x33DF, 0x33E0, 0x33E1, 0x33E2, 	// 0x8139EB39
	0x33E3, 0x33E4, 0x33E5, 0x33E6, 0x33E7, 0x33E8, 0x33E9, 0x33EA, 0x33EB, 0x33EC, 	// 0x8139EC39
	0x33ED, 0x33EE, 0x33EF, 0x33F0, 0x33F1, 0x33F2, 0x33F3, 0x33F4, 0x33F5, 0x33F6, 	// 0x8139ED39
	0x33F7, 0x33F8, 0x33F9, 0x33FA, 0x33FB, 0x33FC, 0x33FD, 0x33FE, 0x33FF, 0x3400, 	// 0x8139EE39
	0x3401, 0x3402, 0x3403, 0x3404, 0x3405, 0x3406, 0x3407, 0x3408, 0x3409, 0x340A, 	// 0x8139EF39
	0x340B, 0x340C, 0x340D, 0x340E, 0x340F, 0x3410, 0x3411, 0x3412, 0x3413, 0x3414, 	// 0x8139F039
	0x3415, 0x3416, 0x3417, 0x3418, 0x3419, 0x341A, 0x341B, 0x341C, 0x341D, 0x341E, 	// 0x8139F139
	0x341F, 0x3420, 0x3421, 0x3422, 0x3423, 0x3424, 0x3425, 0x3426, 0x3427, 0x3428, 	// 0x8139F239
	0x3429, 0x342A, 0x342B, 0x342C, 0x342D, 0x342E, 0x342F, 0x3430, 0x3431, 0x3432, 	// 0x8139F339
	0x3433, 0x3434, 0x3435, 0x3436, 0x3437, 0x3438, 0x3439, 0x343A, 0x343B, 0x343C, 	// 0x8139F439
	0x343D, 0x343E, 0x343F, 0x3440, 0x3441, 0x3442, 0x3443, 0x3444, 0x3445, 0x3446, 	// 0x8139F539
	0x3448, 0x3449, 0x344A, 0x344B, 0x344C, 0x344D, 0x344E, 0x344F, 0x3450, 0x3451, 	// 0x8139F639
	0x3452, 0x3453, 0x3454, 0x3455, 0x3456, 0x3457, 0x3458, 0x3459, 0x345A, 0x345B, 	// 0x8139F739
	0x345C, 0x345D, 0x345E, 0x345F, 0x3460, 0x3461, 0x3462, 0x3463, 0x3464, 0x3465, 	// 0x8139F839
	0x3466, 0x3467, 0x3468, 0x3469, 0x346A, 0x346B, 0x346C, 0x346D, 0x346E, 0x346F, 	// 0x8139F939
	0x3470, 0x3471, 0x3472, 0x3474, 0x3475, 0x3476, 0x3477, 0x3478, 0x3479, 0x347A, 	// 0x8139FA39
	0x347B, 0x347C, 0x347D, 0x347E, 0x347F, 0x3480, 0x3481, 0x3482, 0x3483, 0x3484, 	// 0x8139FB39
	0x3485, 0x3486, 0x3487, 0x3488, 0x3489, 0x348A, 0x348B, 0x348C, 0x348D, 0x348E, 	// 0x8139FC39
	0x348F, 0x3490, 0x3491, 0x3492, 0x3493, 0x3494, 0x3495, 0x3496, 0x3497, 0x3498, 	// 0x8139FD39
	0x3499, 0x349A, 0x349B, 0x349C, 0x349D, 0x349E, 0x349F, 0x34A0, 0x34A1, 0x34A2, 	// 0x8139FE39
	0x34A3, 0x34A4, 0x34A5, 0x34A6, 0x34A7, 0x34A8, 0x34A9, 0x34AA, 0x34AB, 0x34AC, 	// 0x82308139
	0x34AD, 0x34AE, 0x34AF, 0x34B0, 0x34B1, 0x34B2, 0x34B3, 0x34B4, 0x34B5, 0x34B6, 	// 0x82308239
	0x34B7, 0x34B8, 0x34B9, 0x34BA, 0x34BB, 0x34BC, 0x34BD, 0x34BE, 0x34BF, 0x34C0, 	// 0x82308339
	0x34C1, 0x34C2, 0x34C3, 0x34C4, 0x34C5, 0x34C6, 0x34C7, 0x34C8, 0x34C9, 0x34CA, 	// 0x82308439
	0x34CB, 0x34CC, 0x34CD, 0x34CE, 0x34CF, 0x34D0, 0x34D1, 0x34D2, 0x34D3, 0x34D4, 	// 0x82308539
	0x34D5, 0x34D6, 0x34D7, 0x34D8, 0x34D9, 0x34DA, 0x34DB, 0x34DC, 0x34DD, 0x34DE, 	// 0x82308639
	0x34DF, 0x34E0, 0x34E1, 0x34E2, 0x34E3, 0x34E4, 0x34E5, 0x34E6, 0x34E7, 0x34E8, 	// 0x82308739
	0x34E9, 0x34EA, 0x34EB, 0x34EC, 0x34ED, 0x34EE, 0x34EF, 0x34F0, 0x34F1, 0x34F2, 	// 0x82308839
	0x34F3, 0x34F4, 0x34F5, 0x34F6, 0x34F7, 0x34F8, 0x34F9, 0x34FA, 0x34FB, 0x34FC, 	// 0x82308939
	0x34FD, 0x34FE, 0x34FF, 0x3500, 0x3501, 0x3502, 0x3503, 0x3504, 0x3505, 0x3506, 	// 0x82308A39
	0x3507, 0x3508, 0x3509, 0x350A, 0x350B, 0x350C, 0x350D, 0x350E, 0x350F, 0x3510, 	// 0x82308B39
	0x3511, 0x3512, 0x3513, 0x3514, 0x3515, 0x3516, 0x3517, 0x3518, 0x3519, 0x351A, 	// 0x82308C39
	0x351B, 0x351C, 0x351D, 0x351E, 0x351F, 0x3520, 0x3521, 0x3522, 0x3523, 0x3524, 	// 0x82308D39
	0x3525, 0x3526, 0x3527, 0x3528, 0x3529, 0x352A, 0x352B, 0x352C, 0x352D, 0x352E, 	// 0x82308E39
	0x352F, 0x3530, 0x3531, 0x3532, 0x3533, 0x3534, 0x3535, 0x3536, 0x3537, 0x3538, 	// 0x82308F39
	0x3539, 0x353A, 0x353B, 0x353C, 0x353D, 0x353E, 0x353F, 0x3540, 0x3541, 0x3542, 	// 0x82309039
	0x3543, 0x3544, 0x3545, 0x3546, 0x3547, 0x3548, 0x3549, 0x354A, 0x354B, 0x354C, 	// 0x82309139
	0x354D, 0x354E, 0x354F, 0x3550, 0x3551, 0x3552, 0x3553, 0x3554, 0x3555, 0x3556, 	// 0x82309239
	0x3557, 0x3558, 0x3559, 0x355A, 0x355B, 0x355C, 0x355D, 0x355E, 0x355F, 0x3560, 	// 0x82309339
	0x3561, 0x3562, 0x3563, 0x3564, 0x3565, 0x3566, 0x3567, 0x3568, 0x3569, 0x356A, 	// 0x82309439
	0x356B, 0x356C, 0x356D, 0x356E, 0x356F, 0x3570, 0x3571, 0x3572, 0x3573, 0x3574, 	// 0x82309539
	0x3575, 0x3576, 0x3577, 0x3578, 0x3579, 0x357A, 0x357B, 0x357C, 0x357D, 0x357E, 	// 0x82309639
	0x357F, 0x3580, 0x3581, 0x3582, 0x3583, 0x3584, 0x3585, 0x3586, 0x3587, 0x3588, 	// 0x82309739
	0x3589, 0x358A, 0x358B, 0x358C, 0x358D, 0x358E, 0x358F, 0x3590, 0x3591, 0x3592, 	// 0x82309839
	0x3593, 0x3594, 0x3595, 0x3596, 0x3597, 0x3598, 0x3599, 0x359A, 0x359B, 0x359C, 	// 0x82309939
	0x359D, 0x359F, 0x35A0, 0x35A1, 0x35A2, 0x35A3, 0x35A4, 0x35A5, 0x35A6, 0x35A7, 	// 0x82309A39
	0x35A8, 0x35A9, 0x35AA, 0x35AB, 0x35AC, 0x35AD, 0x35AE, 0x35AF, 0x35B0, 0x35B1, 	// 0x82309B39
	0x35B2, 0x35B3, 0x35B4, 0x35B5, 0x35B6, 0x35B7, 0x35B8, 0x35B9, 0x35BA, 0x35BB, 	// 0x82309C39
	0x35BC, 0x35BD, 0x35BE, 0x35BF, 0x35C0, 0x35C1, 0x35C2, 0x35C3, 0x35C4, 0x35C5, 	// 0x82309D39
	0x35C6, 0x35C7, 0x35C8, 0x35C9, 0x35CA, 0x35CB, 0x35CC, 0x35CD, 0x35CE, 0x35CF, 	// 0x82309E39
	0x35D0, 0x35D1, 0x35D2, 0x35D3, 0x35D4, 0x35D5, 0x35D6, 0x35D7, 0x35D8, 0x35D9, 	// 0x82309F39
	0x35DA, 0x35DB, 0x35DC, 0x35DD, 0x35DE, 0x35DF, 0x35E0, 0x35E1, 0x35E2, 0x35E3, 	// 0x8230A039
	0x35E4, 0x35E5, 0x35E6, 0x35E7, 0x35E8, 0x35E9, 0x35EA, 0x35EB, 0x35EC, 0x35ED, 	// 0x8230A139
	0x35EE, 0x35EF, 0x35F0, 0x35F1, 0x35F2, 0x35F3, 0x35F4, 0x35F5, 0x35F6, 0x35F7, 	// 0x8230A239
	0x35F8, 0x35F9, 0x35FA, 0x35FB, 0x35FC, 0x35FD, 0x35FE, 0x35FF, 0x3600, 0x3601, 	// 0x8230A339
	0x3602, 0x3603, 0x3604, 0x3605, 0x3606, 0x3607, 0x3608, 0x3609, 0x360A, 0x360B, 	// 0x8230A439
	0x360C, 0x360D, 0x360F, 0x3610, 0x3611, 0x3612, 0x3613, 0x3614, 0x3615, 0x3616, 	// 0x8230A539
	0x3617, 0x3618, 0x3619, 0x361B, 0x361C, 0x361D, 0x361E, 0x361F, 0x3620, 0x3621, 	// 0x8230A639
	0x3622, 0x3623, 0x3624, 0x3625, 0x3626, 0x3627, 0x3628, 0x3629, 0x362A, 0x362B, 	// 0x8230A739
	0x362C, 0x362D, 0x362E, 0x362F, 0x3630, 0x3631, 0x3632, 0x3633, 0x3634, 0x3635, 	// 0x8230A839
	0x3636, 0x3637, 0x3638, 0x3639, 0x363A, 0x363B, 0x363C, 0x363D, 0x363E, 0x363F, 	// 0x8230A939
	0x3640, 0x3641, 0x3642, 0x3643, 0x3644, 0x3645, 0x3646, 0x3647, 0x3648, 0x3649, 	// 0x8230AA39
	0x364A, 0x364B, 0x364C, 0x364D, 0x364E, 0x364F, 0x3650, 0x3651, 0x3652, 0x3653, 	// 0x8230AB39
	0x3654, 0x3655, 0x3656, 0x3657, 0x3658, 0x3659, 0x365A, 0x365B, 0x365C, 0x365D, 	// 0x8230AC39
	0x365E, 0x365F, 0x3660, 0x3661, 0x3662, 0x3663, 0x3664, 0x3665, 0x3666, 0x3667, 	// 0x8230AD39
	0x3668, 0x3669, 0x366A, 0x366B, 0x366C, 0x366D, 0x366E, 0x366F, 0x3670, 0x3671, 	// 0x8230AE39
	0x3672, 0x3673, 0x3674, 0x3675, 0x3676, 0x3677, 0x3678, 0x3679, 0x367A, 0x367B, 	// 0x8230AF39
	0x367C, 0x367D, 0x367E, 0x367F, 0x3680, 0x3681, 0x3682, 0x3683, 0x3684, 0x3685, 	// 0x8230B039
	0x3686, 0x3687, 0x3688, 0x3689, 0x368A, 0x368B, 0x368C, 0x368D, 0x368E, 0x368F, 	// 0x8230B139
	0x3690, 0x3691, 0x3692, 0x3693, 0x3694, 0x3695, 0x3696, 0x3697, 0x3698, 0x3699, 	// 0x8230B239
	0x369A, 0x369B, 0x369C, 0x369D, 0x369E, 0x369F, 0x36A0, 0x36A1, 0x36A2, 0x36A3, 	// 0x8230B339
	0x36A4, 0x36A5, 0x36A6, 0x36A7, 0x36A8, 0x36A9, 0x36AA, 0x36AB, 0x36AC, 0x36AD, 	// 0x8230B439
	0x36AE, 0x36AF, 0x36B0, 0x36B1, 0x36B2, 0x36B3, 0x36B4, 0x36B5, 0x36B6, 0x36B7, 	// 0x8230B539
	0x36B8, 0x36B9, 0x36BA, 0x36BB, 0x36BC, 0x36BD, 0x36BE, 0x36BF, 0x36C0, 0x36C1, 	// 0x8230B639
	0x36C2, 0x36C3, 0x36C4, 0x36C5, 0x36C6, 0x36C7, 0x36C8, 0x36C9, 0x36CA, 0x36CB, 	// 0x8230B739
	0x36CC, 0x36CD, 0x36CE, 0x36CF, 0x36D0, 0x36D1, 0x36D2, 0x36D3, 0x36D4, 0x36D5, 	// 0x8230B839
	0x36D6, 0x36D7, 0x36D8, 0x36D9, 0x36DA, 0x36DB, 0x36DC, 0x36DD, 0x36DE, 0x36DF, 	// 0x8230B939
	0x36E0, 0x36E1, 0x36E2, 0x36E3, 0x36E4, 0x36E5, 0x36E6, 0x36E7, 0x36E8, 0x36E9, 	// 0x8230BA39
	0x36EA, 0x36EB, 0x36EC, 0x36ED, 0x36EE, 0x36EF, 0x36F0, 0x36F1, 0x36F2, 0x36F3, 	// 0x8230BB39
	0x36F4, 0x36F5, 0x36F6, 0x36F7, 0x36F8, 0x36F9, 0x36FA, 0x36FB, 0x36FC, 0x36FD, 	// 0x8230BC39
	0x36FE, 0x36FF, 0x3700, 0x3701, 0x3702, 0x3703, 0x3704, 0x3705, 0x3706, 0x3707, 	// 0x8230BD39
	0x3708, 0x3709, 0x370A, 0x370B, 0x370C, 0x370D, 0x370E, 0x370F, 0x3710, 0x3711, 	// 0x8230BE39
	0x3712, 0x3713, 0x3714, 0x3715, 0x3716, 0x3717, 0x3718, 0x3719, 0x371A, 0x371B, 	// 0x8230BF39
	0x371C, 0x371D, 0x371E, 0x371F, 0x3720, 0x3721, 0x3722, 0x3723, 0x3724, 0x3725, 	// 0x8230C039
	0x3726, 0x3727, 0x3728, 0x3729, 0x372A, 0x372B, 0x372C, 0x372D, 0x372E, 0x372F, 	// 0x8230C139
	0x3730, 0x3731, 0x3732, 0x3733, 0x3734, 0x3735, 0x3736, 0x3737, 0x3738, 0x3739, 	// 0x8230C239
	0x373A, 0x373B, 0x373C, 0x373D, 0x373E, 0x373F, 0x3740, 0x3741, 0x3742, 0x3743, 	// 0x8230C339
	0x3744, 0x3745, 0x3746, 0x3747, 0x3748, 0x3749, 0x374A, 0x374B, 0x374C, 0x374D, 	// 0x8230C439
	0x374E, 0x374F, 0x3750, 0x3751, 0x3752, 0x3753, 0x3754, 0x3755, 0x3756, 0x3757, 	// 0x8230C539
	0x3758, 0x3759, 0x375A, 0x375B, 0x375C, 0x375D, 0x375E, 0x375F, 0x3760, 0x3761, 	// 0x8230C639
	0x3762, 0x3763, 0x3764, 0x3765, 0x3766, 0x3767, 0x3768, 0x3769, 0x376A, 0x376B, 	// 0x8230C739
	0x376C, 0x376D, 0x376E, 0x376F, 0x3770, 0x3771, 0x3772, 0x3773, 0x3774, 0x3775, 	// 0x8230C839
	0x3776, 0x3777, 0x3778, 0x3779, 0x377A, 0x377B, 0x377C, 0x377D, 0x377E, 0x377F, 	// 0x8230C939
	0x3780, 0x3781, 0x3782, 0x3783, 0x3784, 0x3785, 0x3786, 0x3787, 0x3788, 0x3789, 	// 0x8230CA39
	0x378A, 0x378B, 0x378C, 0x378D, 0x378E, 0x378F, 0x3790, 0x3791, 0x3792, 0x3793, 	// 0x8230CB39
	0x3794, 0x3795, 0x3796, 0x3797, 0x3798, 0x3799, 0x379A, 0x379B, 0x379C, 0x379D, 	// 0x8230CC39
	0x379E, 0x379F, 0x37A0, 0x37A1, 0x37A2, 0x37A3, 0x37A4, 0x37A5, 0x37A6, 0x37A7, 	// 0x8230CD39
	0x37A8, 0x37A9, 0x37AA, 0x37AB, 0x37AC, 0x37AD, 0x37AE, 0x37AF, 0x37B0, 0x37B1, 	// 0x8230CE39
	0x37B2, 0x37B3, 0x37B4, 0x37B5, 0x37B6, 0x37B7, 0x37B8, 0x37B9, 0x37BA, 0x37BB, 	// 0x8230CF39
	0x37BC, 0x37BD, 0x37BE, 0x37BF, 0x37C0, 0x37C1, 0x37C2, 0x37C3, 0x37C4, 0x37C5, 	// 0x8230D039
	0x37C6, 0x37C7, 0x37C8, 0x37C9, 0x37CA, 0x37CB, 0x37CC, 0x37CD, 0x37CE, 0x37CF, 	// 0x8230D139
	0x37D0, 0x37D1, 0x37D2, 0x37D3, 0x37D4, 0x37D5, 0x37D6, 0x37D7, 0x37D8, 0x37D9, 	// 0x8230D239
	0x37DA, 0x37DB, 0x37DC, 0x37DD, 0x37DE, 0x37DF, 0x37E0, 0x37E1, 0x37E2, 0x37E3, 	// 0x8230D339
	0x37E4, 0x37E5, 0x37E6, 0x37E7, 0x37E8, 0x37E9, 0x37EA, 0x37EB, 0x37EC, 0x37ED, 	// 0x8230D439
	0x37EE, 0x37EF, 0x37F0, 0x37F1, 0x37F2, 0x37F3, 0x37F4, 0x37F5, 0x37F6, 0x37F7, 	// 0x8230D539
	0x37F8, 0x37F9, 0x37FA, 0x37FB, 0x37FC, 0x37FD, 0x37FE, 0x37FF, 0x3800, 0x3801, 	// 0x8230D639
	0x3802, 0x3803, 0x3804, 0x3805, 0x3806, 0x3807, 0x3808, 0x3809, 0x380A, 0x380B, 	// 0x8230D739
	0x380C, 0x380D, 0x380E, 0x380F, 0x3810, 0x3811, 0x3812, 0x3813, 0x3814, 0x3815, 	// 0x8230D839
	0x3816, 0x3817, 0x3818, 0x3819, 0x381A, 0x381B, 0x381C, 0x381D, 0x381E, 0x381F, 	// 0x8230D939
	0x3820, 0x3821, 0x3822, 0x3823, 0x3824, 0x3825, 0x3826, 0x3827, 0x3828, 0x3829, 	// 0x8230DA39
	0x382A, 0x382B, 0x382C, 0x382D, 0x382E, 0x382F, 0x3830, 0x3831, 0x3832, 0x3833, 	// 0x8230DB39
	0x3834, 0x3835, 0x3836, 0x3837, 0x3838, 0x3839, 0x383A, 0x383B, 0x383C, 0x383D, 	// 0x8230DC39
	0x383E, 0x383F, 0x3840, 0x3841, 0x3842, 0x3843, 0x3844, 0x3845, 0x3846, 0x3847, 	// 0x8230DD39
	0x3848, 0x3849, 0x384A, 0x384B, 0x384C, 0x384D, 0x384E, 0x384F, 0x3850, 0x3851, 	// 0x8230DE39
	0x3852, 0x3853, 0x3854, 0x3855, 0x3856, 0x3857, 0x3858, 0x3859, 0x385A, 0x385B, 	// 0x8230DF39
	0x385C, 0x385D, 0x385E, 0x385F, 0x3860, 0x3861, 0x3862, 0x3863, 0x3864, 0x3865, 	// 0x8230E039
	0x3866, 0x3867, 0x3868, 0x3869, 0x386A, 0x386B, 0x386C, 0x386D, 0x386E, 0x386F, 	// 0x8230E139
	0x3870, 0x3871, 0x3872, 0x3873, 0x3874, 0x3875, 0x3876, 0x3877, 0x3878, 0x3879, 	// 0x8230E239
	0x387A, 0x387B, 0x387C, 0x387D, 0x387E, 0x387F, 0x3880, 0x3881, 0x3882, 0x3883, 	// 0x8230E339
	0x3884, 0x3885, 0x3886, 0x3887, 0x3888, 0x3889, 0x388A, 0x388B, 0x388C, 0x388D, 	// 0x8230E439
	0x388E, 0x388F, 0x3890, 0x3891, 0x3892, 0x3893, 0x3894, 0x3895, 0x3896, 0x3897, 	// 0x8230E539
	0x3898, 0x3899, 0x389A, 0x389B, 0x389C, 0x389D, 0x389E, 0x389F, 0x38A0, 0x38A1, 	// 0x8230E639
	0x38A2, 0x38A3, 0x38A4, 0x38A5, 0x38A6, 0x38A7, 0x38A8, 0x38A9, 0x38AA, 0x38AB, 	// 0x8230E739
	0x38AC, 0x38AD, 0x38AE, 0x38AF, 0x38B0, 0x38B1, 0x38B2, 0x38B3, 0x38B4, 0x38B5, 	// 0x8230E839
	0x38B6, 0x38B7, 0x38B8, 0x38B9, 0x38BA, 0x38BB, 0x38BC, 0x38BD, 0x38BE, 0x38BF, 	// 0x8230E939
	0x38C0, 0x38C1, 0x38C2, 0x38C3, 0x38C4, 0x38C5, 0x38C6, 0x38C7, 0x38C8, 0x38C9, 	// 0x8230EA39
	0x38CA, 0x38CB, 0x38CC, 0x38CD, 0x38CE, 0x38CF, 0x38D0, 0x38D1, 0x38D2, 0x38D3, 	// 0x8230EB39
	0x38D4, 0x38D5, 0x38D6, 0x38D7, 0x38D8, 0x38D9, 0x38DA, 0x38DB, 0x38DC, 0x38DD, 	// 0x8230EC39
	0x38DE, 0x38DF, 0x38E0, 0x38E1, 0x38E2, 0x38E3, 0x38E4, 0x38E5, 0x38E6, 0x38E7, 	// 0x8230ED39
	0x38E8, 0x38E9, 0x38EA, 0x38EB, 0x38EC, 0x38ED, 0x38EE, 0x38EF, 0x38F0, 0x38F1, 	// 0x8230EE39
	0x38F2, 0x38F3, 0x38F4, 0x38F5, 0x38F6, 0x38F7, 0x38F8, 0x38F9, 0x38FA, 0x38FB, 	// 0x8230EF39
	0x38FC, 0x38FD, 0x38FE, 0x38FF, 0x3900, 0x3901, 0x3902, 0x3903, 0x3904, 0x3905, 	// 0x8230F039
	0x3906, 0x3907, 0x3908, 0x3909, 0x390A, 0x390B, 0x390C, 0x390D, 0x390E, 0x390F, 	// 0x8230F139
	0x3910, 0x3911, 0x3912, 0x3913, 0x3914, 0x3915, 0x3916, 0x3917, 0x3919, 0x391A, 	// 0x8230F239
	0x391B, 0x391C, 0x391D, 0x391E, 0x391F, 0x3920, 0x3921, 0x3922, 0x3923, 0x3924, 	// 0x8230F339
	0x3925, 0x3926, 0x3927, 0x3928, 0x3929, 0x392A, 0x392B, 0x392C, 0x392D, 0x392E, 	// 0x8230F439
	0x392F, 0x3930, 0x3931, 0x3932, 0x3933, 0x3934, 0x3935, 0x3936, 0x3937, 0x3938, 	// 0x8230F539
	0x3939, 0x393A, 0x393B, 0x393C, 0x393D, 0x393E, 0x393F, 0x3940, 0x3941, 0x3942, 	// 0x8230F639
	0x3943, 0x3944, 0x3945, 0x3946, 0x3947, 0x3948, 0x3949, 0x394A, 0x394B, 0x394C, 	// 0x8230F739
	0x394D, 0x394E, 0x394F, 0x3950, 0x3951, 0x3952, 0x3953, 0x3954, 0x3955, 0x3956, 	// 0x8230F839
	0x3957, 0x3958, 0x3959, 0x395A, 0x395B, 0x395C, 0x395D, 0x395E, 0x395F, 0x3960, 	// 0x8230F939
	0x3961, 0x3962, 0x3963, 0x3964, 0x3965, 0x3966, 0x3967, 0x3968, 0x3969, 0x396A, 	// 0x8230FA39
	0x396B, 0x396C, 0x396D, 0x396F, 0x3970, 0x3971, 0x3972, 0x3973, 0x3974, 0x3975, 	// 0x8230FB39
	0x3976, 0x3977, 0x3978, 0x3979, 0x397A, 0x397B, 0x397C, 0x397D, 0x397E, 0x397F, 	// 0x8230FC39
	0x3980, 0x3981, 0x3982, 0x3983, 0x3984, 0x3985, 0x3986, 0x3987, 0x3988, 0x3989, 	// 0x8230FD39
	0x398A, 0x398B, 0x398C, 0x398D, 0x398E, 0x398F, 0x3990, 0x3991, 0x3992, 0x3993, 	// 0x8230FE39
	0x3994, 0x3995, 0x3996, 0x3997, 0x3998, 0x3999, 0x399A, 0x399B, 0x399C, 0x399D, 	// 0x82318139
	0x399E, 0x399F, 0x39A0, 0x39A1, 0x39A2, 0x39A3, 0x39A4, 0x39A5, 0x39A6, 0x39A7, 	// 0x82318239
	0x39A8, 0x39A9, 0x39AA, 0x39AB, 0x39AC, 0x39AD, 0x39AE, 0x39AF, 0x39B0, 0x39B1, 	// 0x82318339
	0x39B2, 0x39B3, 0x39B4, 0x39B5, 0x39B6, 0x39B7, 0x39B8, 0x39B9, 0x39BA, 0x39BB, 	// 0x82318439
	0x39BC, 0x39BD, 0x39BE, 0x39BF, 0x39C0, 0x39C1, 0x39C2, 0x39C3, 0x39C4, 0x39C5, 	// 0x82318539
	0x39C6, 0x39C7, 0x39C8, 0x39C9, 0x39CA, 0x39CB, 0x39CC, 0x39CD, 0x39CE, 0x39D1, 	// 0x82318639
	0x39D2, 0x39D3, 0x39D4, 0x39D5, 0x39D6, 0x39D7, 0x39D8, 0x39D9, 0x39DA, 0x39DB, 	// 0x82318739
	0x39DC, 0x39DD, 0x39DE, 0x39E0, 0x39E1, 0x39E2, 0x39E3, 0x39E4, 0x39E5, 0x39E6, 	// 0x82318839
	0x39E7, 0x39E8, 0x39E9, 0x39EA, 0x39EB, 0x39EC, 0x39ED, 0x39EE, 0x39EF, 0x39F0, 	// 0x82318939
	0x39F1, 0x39F2, 0x39F3, 0x39F4, 0x39F5, 0x39F6, 0x39F7, 0x39F8, 0x39F9, 0x39FA, 	// 0x82318A39
	0x39FB, 0x39FC, 0x39FD, 0x39FE, 0x39FF, 0x3A00, 0x3A01, 0x3A02, 0x3A03, 0x3A04, 	// 0x82318B39
	0x3A05, 0x3A06, 0x3A07, 0x3A08, 0x3A09, 0x3A0A, 0x3A0B, 0x3A0C, 0x3A0D, 0x3A0E, 	// 0x82318C39
	0x3A0F, 0x3A10, 0x3A11, 0x3A12, 0x3A13, 0x3A14, 0x3A15, 0x3A16, 0x3A17, 0x3A18, 	// 0x82318D39
	0x3A19, 0x3A1A, 0x3A1B, 0x3A1C, 0x3A1D, 0x3A1E, 0x3A1F, 0x3A20, 0x3A21, 0x3A22, 	// 0x82318E39
	0x3A23, 0x3A24, 0x3A25, 0x3A26, 0x3A27, 0x3A28, 0x3A29, 0x3A2A, 0x3A2B, 0x3A2C, 	// 0x82318F39
	0x3A2D, 0x3A2E, 0x3A2F, 0x3A30, 0x3A31, 0x3A32, 0x3A33, 0x3A34, 0x3A35, 0x3A36, 	// 0x82319039
	0x3A37, 0x3A38, 0x3A39, 0x3A3A, 0x3A3B, 0x3A3C, 0x3A3D, 0x3A3E, 0x3A3F, 0x3A40, 	// 0x82319139
	0x3A41, 0x3A42, 0x3A43, 0x3A44, 0x3A45, 0x3A46, 0x3A47, 0x3A48, 0x3A49, 0x3A4A, 	// 0x82319239
	0x3A4B, 0x3A4C, 0x3A4D, 0x3A4E, 0x3A4F, 0x3A50, 0x3A51, 0x3A52, 0x3A53, 0x3A54, 	// 0x82319339
	0x3A55, 0x3A56, 0x3A57, 0x3A58, 0x3A59, 0x3A5A, 0x3A5B, 0x3A5C, 0x3A5D, 0x3A5E, 	// 0x82319439
	0x3A5F, 0x3A60, 0x3A61, 0x3A62, 0x3A63, 0x3A64, 0x3A65, 0x3A66, 0x3A67, 0x3A68, 	// 0x82319539
	0x3A69, 0x3A6A, 0x3A6B, 0x3A6C, 0x3A6D, 0x3A6E, 0x3A6F, 0x3A70, 0x3A71, 0x3A72, 	// 0x82319639
	0x3A74, 0x3A75, 0x3A76, 0x3A77, 0x3A78, 0x3A79, 0x3A7A, 0x3A7B, 0x3A7C, 0x3A7D, 	// 0x82319739
	0x3A7E, 0x3A7F, 0x3A80, 0x3A81, 0x3A82, 0x3A83, 0x3A84, 0x3A85, 0x3A86, 0x3A87, 	// 0x82319839
	0x3A88, 0x3A89, 0x3A8A, 0x3A8B, 0x3A8C, 0x3A8D, 0x3A8E, 0x3A8F, 0x3A90, 0x3A91, 	// 0x82319939
	0x3A92, 0x3A93, 0x3A94, 0x3A95, 0x3A96, 0x3A97, 0x3A98, 0x3A99, 0x3A9A, 0x3A9B, 	// 0x82319A39
	0x3A9C, 0x3A9D, 0x3A9E, 0x3A9F, 0x3AA0, 0x3AA1, 0x3AA2, 0x3AA3, 0x3AA4, 0x3AA5, 	// 0x82319B39
	0x3AA6, 0x3AA7, 0x3AA8, 0x3AA9, 0x3AAA, 0x3AAB, 0x3AAC, 0x3AAD, 0x3AAE, 0x3AAF, 	// 0x82319C39
	0x3AB0, 0x3AB1, 0x3AB2, 0x3AB3, 0x3AB4, 0x3AB5, 0x3AB6, 0x3AB7, 0x3AB8, 0x3AB9, 	// 0x82319D39
	0x3ABA, 0x3ABB, 0x3ABC, 0x3ABD, 0x3ABE, 0x3ABF, 0x3AC0, 0x3AC1, 0x3AC2, 0x3AC3, 	// 0x82319E39
	0x3AC4, 0x3AC5, 0x3AC6, 0x3AC7, 0x3AC8, 0x3AC9, 0x3ACA, 0x3ACB, 0x3ACC, 0x3ACD, 	// 0x82319F39
	0x3ACE, 0x3ACF, 0x3AD0, 0x3AD1, 0x3AD2, 0x3AD3, 0x3AD4, 0x3AD5, 0x3AD6, 0x3AD7, 	// 0x8231A039
	0x3AD8, 0x3AD9, 0x3ADA, 0x3ADB, 0x3ADC, 0x3ADD, 0x3ADE, 0x3ADF, 0x3AE0, 0x3AE1, 	// 0x8231A139
	0x3AE2, 0x3AE3, 0x3AE4, 0x3AE5, 0x3AE6, 0x3AE7, 0x3AE8, 0x3AE9, 0x3AEA, 0x3AEB, 	// 0x8231A239
	0x3AEC, 0x3AED, 0x3AEE, 0x3AEF, 0x3AF0, 0x3AF1, 0x3AF2, 0x3AF3, 0x3AF4, 0x3AF5, 	// 0x8231A339
	0x3AF6, 0x3AF7, 0x3AF8, 0x3AF9, 0x3AFA, 0x3AFB, 0x3AFC, 0x3AFD, 0x3AFE, 0x3AFF, 	// 0x8231A439
	0x3B00, 0x3B01, 0x3B02, 0x3B03, 0x3B04, 0x3B05, 0x3B06, 0x3B07, 0x3B08, 0x3B09, 	// 0x8231A539
	0x3B0A, 0x3B0B, 0x3B0C, 0x3B0D, 0x3B0E, 0x3B0F, 0x3B10, 0x3B11, 0x3B12, 0x3B13, 	// 0x8231A639
	0x3B14, 0x3B15, 0x3B16, 0x3B17, 0x3B18, 0x3B19, 0x3B1A, 0x3B1B, 0x3B1C, 0x3B1D, 	// 0x8231A739
	0x3B1E, 0x3B1F, 0x3B20, 0x3B21, 0x3B22, 0x3B23, 0x3B24, 0x3B25, 0x3B26, 0x3B27, 	// 0x8231A839
	0x3B28, 0x3B29, 0x3B2A, 0x3B2B, 0x3B2C, 0x3B2D, 0x3B2E, 0x3B2F, 0x3B30, 0x3B31, 	// 0x8231A939
	0x3B32, 0x3B33, 0x3B34, 0x3B35, 0x3B36, 0x3B37, 0x3B38, 0x3B39, 0x3B3A, 0x3B3B, 	// 0x8231AA39
	0x3B3C, 0x3B3D, 0x3B3E, 0x3B3F, 0x3B40, 0x3B41, 0x3B42, 0x3B43, 0x3B44, 0x3B45, 	// 0x8231AB39
	0x3B46, 0x3B47, 0x3B48, 0x3B49, 0x3B4A, 0x3B4B, 0x3B4C, 0x3B4D, 0x3B4F, 0x3B50, 	// 0x8231AC39
	0x3B51, 0x3B52, 0x3B53, 0x3B54, 0x3B55, 0x3B56, 0x3B57, 0x3B58, 0x3B59, 0x3B5A, 	// 0x8231AD39
	0x3B5B, 0x3B5C, 0x3B5D, 0x3B5E, 0x3B5F, 0x3B60, 0x3B61, 0x3B62, 0x3B63, 0x3B64, 	// 0x8231AE39
	0x3B65, 0x3B66, 0x3B67, 0x3B68, 0x3B69, 0x3B6A, 0x3B6B, 0x3B6C, 0x3B6D, 0x3B6E, 	// 0x8231AF39
	0x3B6F, 0x3B70, 0x3B71, 0x3B72, 0x3B73, 0x3B74, 0x3B75, 0x3B76, 0x3B77, 0x3B78, 	// 0x8231B039
	0x3B79, 0x3B7A, 0x3B7B, 0x3B7C, 0x3B7D, 0x3B7E, 0x3B7F, 0x3B80, 0x3B81, 0x3B82, 	// 0x8231B139
	0x3B83, 0x3B84, 0x3B85, 0x3B86, 0x3B87, 0x3B88, 0x3B89, 0x3B8A, 0x3B8B, 0x3B8C, 	// 0x8231B239
	0x3B8D, 0x3B8E, 0x3B8F, 0x3B90, 0x3B91, 0x3B92, 0x3B93, 0x3B94, 0x3B95, 0x3B96, 	// 0x8231B339
	0x3B97, 0x3B98, 0x3B99, 0x3B9A, 0x3B9B, 0x3B9C, 0x3B9D, 0x3B9E, 0x3B9F, 0x3BA0, 	// 0x8231B439
	0x3BA1, 0x3BA2, 0x3BA3, 0x3BA4, 0x3BA5, 0x3BA6, 0x3BA7, 0x3BA8, 0x3BA9, 0x3BAA, 	// 0x8231B539
	0x3BAB, 0x3BAC, 0x3BAD, 0x3BAE, 0x3BAF, 0x3BB0, 0x3BB1, 0x3BB2, 0x3BB3, 0x3BB4, 	// 0x8231B639
	0x3BB5, 0x3BB6, 0x3BB7, 0x3BB8, 0x3BB9, 0x3BBA, 0x3BBB, 0x3BBC, 0x3BBD, 0x3BBE, 	// 0x8231B739
	0x3BBF, 0x3BC0, 0x3BC1, 0x3BC2, 0x3BC3, 0x3BC4, 0x3BC5, 0x3BC6, 0x3BC7, 0x3BC8, 	// 0x8231B839
	0x3BC9, 0x3BCA, 0x3BCB, 0x3BCC, 0x3BCD, 0x3BCE, 0x3BCF, 0x3BD0, 0x3BD1, 0x3BD2, 	// 0x8231B939
	0x3BD3, 0x3BD4, 0x3BD5, 0x3BD6, 0x3BD7, 0x3BD8, 0x3BD9, 0x3BDA, 0x3BDB, 0x3BDC, 	// 0x8231BA39
	0x3BDD, 0x3BDE, 0x3BDF, 0x3BE0, 0x3BE1, 0x3BE2, 0x3BE3, 0x3BE4, 0x3BE5, 0x3BE6, 	// 0x8231BB39
	0x3BE7, 0x3BE8, 0x3BE9, 0x3BEA, 0x3BEB, 0x3BEC, 0x3BED, 0x3BEE, 0x3BEF, 0x3BF0, 	// 0x8231BC39
	0x3BF1, 0x3BF2, 0x3BF3, 0x3BF4, 0x3BF5, 0x3BF6, 0x3BF7, 0x3BF8, 0x3BF9, 0x3BFA, 	// 0x8231BD39
	0x3BFB, 0x3BFC, 0x3BFD, 0x3BFE, 0x3BFF, 0x3C00, 0x3C01, 0x3C02, 0x3C03, 0x3C04, 	// 0x8231BE39
	0x3C05, 0x3C06, 0x3C07, 0x3C08, 0x3C09, 0x3C0A, 0x3C0B, 0x3C0C, 0x3C0D, 0x3C0E, 	// 0x8231BF39
	0x3C0F, 0x3C10, 0x3C11, 0x3C12, 0x3C13, 0x3C14, 0x3C15, 0x3C16, 0x3C17, 0x3C18, 	// 0x8231C039
	0x3C19, 0x3C1A, 0x3C1B, 0x3C1C, 0x3C1D, 0x3C1E, 0x3C1F, 0x3C20, 0x3C21, 0x3C22, 	// 0x8231C139
	0x3C23, 0x3C24, 0x3C25, 0x3C26, 0x3C27, 0x3C28, 0x3C29, 0x3C2A, 0x3C2B, 0x3C2C, 	// 0x8231C239
	0x3C2D, 0x3C2E, 0x3C2F, 0x3C30, 0x3C31, 0x3C32, 0x3C33, 0x3C34, 0x3C35, 0x3C36, 	// 0x8231C339
	0x3C37, 0x3C38, 0x3C39, 0x3C3A, 0x3C3B, 0x3C3C, 0x3C3D, 0x3C3E, 0x3C3F, 0x3C40, 	// 0x8231C439
	0x3C41, 0x3C42, 0x3C43, 0x3C44, 0x3C45, 0x3C46, 0x3C47, 0x3C48, 0x3C49, 0x3C4A, 	// 0x8231C539
	0x3C4B, 0x3C4C, 0x3C4D, 0x3C4E, 0x3C4F, 0x3C50, 0x3C51, 0x3C52, 0x3C53, 0x3C54, 	// 0x8231C639
	0x3C55, 0x3C56, 0x3C57, 0x3C58, 0x3C59, 0x3C5A, 0x3C5B, 0x3C5C, 0x3C5D, 0x3C5E, 	// 0x8231C739
	0x3C5F, 0x3C60, 0x3C61, 0x3C62, 0x3C63, 0x3C64, 0x3C65, 0x3C66, 0x3C67, 0x3C68, 	// 0x8231C839
	0x3C69, 0x3C6A, 0x3C6B, 0x3C6C, 0x3C6D, 0x3C6F, 0x3C70, 0x3C71, 0x3C72, 0x3C73, 	// 0x8231C939
	0x3C74, 0x3C75, 0x3C76, 0x3C77, 0x3C78, 0x3C79, 0x3C7A, 0x3C7B, 0x3C7C, 0x3C7D, 	// 0x8231CA39
	0x3C7E, 0x3C7F, 0x3C80, 0x3C81, 0x3C82, 0x3C83, 0x3C84, 0x3C85, 0x3C86, 0x3C87, 	// 0x8231CB39
	0x3C88, 0x3C89, 0x3C8A, 0x3C8B, 0x3C8C, 0x3C8D, 0x3C8E, 0x3C8F, 0x3C90, 0x3C91, 	// 0x8231CC39
	0x3C92, 0x3C93, 0x3C94, 0x3C95, 0x3C96, 0x3C97, 0x3C98, 0x3C99, 0x3C9A, 0x3C9B, 	// 0x8231CD39
	0x3C9C, 0x3C9D, 0x3C9E, 0x3C9F, 0x3CA0, 0x3CA1, 0x3CA2, 0x3CA3, 0x3CA4, 0x3CA5, 	// 0x8231CE39
	0x3CA6, 0x3CA7, 0x3CA8, 0x3CA9, 0x3CAA, 0x3CAB, 0x3CAC, 0x3CAD, 0x3CAE, 0x3CAF, 	// 0x8231CF39
	0x3CB0, 0x3CB1, 0x3CB2, 0x3CB3, 0x3CB4, 0x3CB5, 0x3CB6, 0x3CB7, 0x3CB8, 0x3CB9, 	// 0x8231D039
	0x3CBA, 0x3CBB, 0x3CBC, 0x3CBD, 0x3CBE, 0x3CBF, 0x3CC0, 0x3CC1, 0x3CC2, 0x3CC3, 	// 0x8231D139
	0x3CC4, 0x3CC5, 0x3CC6, 0x3CC7, 0x3CC8, 0x3CC9, 0x3CCA, 0x3CCB, 0x3CCC, 0x3CCD, 	// 0x8231D239
	0x3CCE, 0x3CCF, 0x3CD0, 0x3CD1, 0x3CD2, 0x3CD3, 0x3CD4, 0x3CD5, 0x3CD6, 0x3CD7, 	// 0x8231D339
	0x3CD8, 0x3CD9, 0x3CDA, 0x3CDB, 0x3CDC, 0x3CDD, 0x3CDE, 0x3CDF, 0x3CE1, 0x3CE2, 	// 0x8231D439
	0x3CE3, 0x3CE4, 0x3CE5, 0x3CE6, 0x3CE7, 0x3CE8, 0x3CE9, 0x3CEA, 0x3CEB, 0x3CEC, 	// 0x8231D539
	0x3CED, 0x3CEE, 0x3CEF, 0x3CF0, 0x3CF1, 0x3CF2, 0x3CF3, 0x3CF4, 0x3CF5, 0x3CF6, 	// 0x8231D639
	0x3CF7, 0x3CF8, 0x3CF9, 0x3CFA, 0x3CFB, 0x3CFC, 0x3CFD, 0x3CFE, 0x3CFF, 0x3D00, 	// 0x8231D739
	0x3D01, 0x3D02, 0x3D03, 0x3D04, 0x3D05, 0x3D06, 0x3D07, 0x3D08, 0x3D09, 0x3D0A, 	// 0x8231D839
	0x3D0B, 0x3D0C, 0x3D0D, 0x3D0E, 0x3D0F, 0x3D10, 0x3D11, 0x3D12, 0x3D13, 0x3D14, 	// 0x8231D939
	0x3D15, 0x3D16, 0x3D17, 0x3D18, 0x3D19, 0x3D1A, 0x3D1B, 0x3D1C, 0x3D1D, 0x3D1E, 	// 0x8231DA39
	0x3D1F, 0x3D20, 0x3D21, 0x3D22, 0x3D23, 0x3D24, 0x3D25, 0x3D26, 0x3D27, 0x3D28, 	// 0x8231DB39
	0x3D29, 0x3D2A, 0x3D2B, 0x3D2C, 0x3D2D, 0x3D2E, 0x3D2F, 0x3D30, 0x3D31, 0x3D32, 	// 0x8231DC39
	0x3D33, 0x3D34, 0x3D35, 0x3D36, 0x3D37, 0x3D38, 0x3D39, 0x3D3A, 0x3D3B, 0x3D3C, 	// 0x8231DD39
	0x3D3D, 0x3D3E, 0x3D3F, 0x3D40, 0x3D41, 0x3D42, 0x3D43, 0x3D44, 0x3D45, 0x3D46, 	// 0x8231DE39
	0x3D47, 0x3D48, 0x3D49, 0x3D4A, 0x3D4B, 0x3D4C, 0x3D4D, 0x3D4E, 0x3D4F, 0x3D50, 	// 0x8231DF39
	0x3D51, 0x3D52, 0x3D53, 0x3D54, 0x3D55, 0x3D56, 0x3D57, 0x3D58, 0x3D59, 0x3D5A, 	// 0x8231E039
	0x3D5B, 0x3D5C, 0x3D5D, 0x3D5E, 0x3D5F, 0x3D60, 0x3D61, 0x3D62, 0x3D63, 0x3D64, 	// 0x8231E139
	0x3D65, 0x3D66, 0x3D67, 0x3D68, 0x3D69, 0x3D6A, 0x3D6B, 0x3D6C, 0x3D6D, 0x3D6E, 	// 0x8231E239
	0x3D6F, 0x3D70, 0x3D71, 0x3D72, 0x3D73, 0x3D74, 0x3D75, 0x3D76, 0x3D77, 0x3D78, 	// 0x8231E339
	0x3D79, 0x3D7A, 0x3D7B, 0x3D7C, 0x3D7D, 0x3D7E, 0x3D7F, 0x3D80, 0x3D81, 0x3D82, 	// 0x8231E439
	0x3D83, 0x3D84, 0x3D85, 0x3D86, 0x3D87, 0x3D88, 0x3D89, 0x3D8A, 0x3D8B, 0x3D8C, 	// 0x8231E539
	0x3D8D, 0x3D8E, 0x3D8F, 0x3D90, 0x3D91, 0x3D92, 0x3D93, 0x3D94, 0x3D95, 0x3D96, 	// 0x8231E639
	0x3D97, 0x3D98, 0x3D99, 0x3D9A, 0x3D9B, 0x3D9C, 0x3D9D, 0x3D9E, 0x3D9F, 0x3DA0, 	// 0x8231E739
	0x3DA1, 0x3DA2, 0x3DA3, 0x3DA4, 0x3DA5, 0x3DA6, 0x3DA7, 0x3DA8, 0x3DA9, 0x3DAA, 	// 0x8231E839
	0x3DAB, 0x3DAC, 0x3DAD, 0x3DAE, 0x3DAF, 0x3DB0, 0x3DB1, 0x3DB2, 0x3DB3, 0x3DB4, 	// 0x8231E939
	0x3DB5, 0x3DB6, 0x3DB7, 0x3DB8, 0x3DB9, 0x3DBA, 0x3DBB, 0x3DBC, 0x3DBD, 0x3DBE, 	// 0x8231EA39
	0x3DBF, 0x3DC0, 0x3DC1, 0x3DC2, 0x3DC3, 0x3DC4, 0x3DC5, 0x3DC6, 0x3DC7, 0x3DC8, 	// 0x8231EB39
	0x3DC9, 0x3DCA, 0x3DCB, 0x3DCC, 0x3DCD, 0x3DCE, 0x3DCF, 0x3DD0, 0x3DD1, 0x3DD2, 	// 0x8231EC39
	0x3DD3, 0x3DD4, 0x3DD5, 0x3DD6, 0x3DD7, 0x3DD8, 0x3DD9, 0x3DDA, 0x3DDB, 0x3DDC, 	// 0x8231ED39
	0x3DDD, 0x3DDE, 0x3DDF, 0x3DE0, 0x3DE1, 0x3DE2, 0x3DE3, 0x3DE4, 0x3DE5, 0x3DE6, 	// 0x8231EE39
	0x3DE7, 0x3DE8, 0x3DE9, 0x3DEA, 0x3DEB, 0x3DEC, 0x3DED, 0x3DEE, 0x3DEF, 0x3DF0, 	// 0x8231EF39
	0x3DF1, 0x3DF2, 0x3DF3, 0x3DF4, 0x3DF5, 0x3DF6, 0x3DF7, 0x3DF8, 0x3DF9, 0x3DFA, 	// 0x8231F039
	0x3DFB, 0x3DFC, 0x3DFD, 0x3DFE, 0x3DFF, 0x3E00, 0x3E01, 0x3E02, 0x3E03, 0x3E04, 	// 0x8231F139
	0x3E05, 0x3E06, 0x3E07, 0x3E08, 0x3E09, 0x3E0A, 0x3E0B, 0x3E0C, 0x3E0D, 0x3E0E, 	// 0x8231F239
	0x3E0F, 0x3E10, 0x3E11, 0x3E12, 0x3E13, 0x3E14, 0x3E15, 0x3E16, 0x3E17, 0x3E18, 	// 0x8231F339
	0x3E19, 0x3E1A, 0x3E1B, 0x3E1C, 0x3E1D, 0x3E1E, 0x3E1F, 0x3E20, 0x3E21, 0x3E22, 	// 0x8231F439
	0x3E23, 0x3E24, 0x3E25, 0x3E26, 0x3E27, 0x3E28, 0x3E29, 0x3E2A, 0x3E2B, 0x3E2C, 	// 0x8231F539
	0x3E2D, 0x3E2E, 0x3E2F, 0x3E30, 0x3E31, 0x3E32, 0x3E33, 0x3E34, 0x3E35, 0x3E36, 	// 0x8231F639
	0x3E37, 0x3E38, 0x3E39, 0x3E3A, 0x3E3B, 0x3E3C, 0x3E3D, 0x3E3E, 0x3E3F, 0x3E40, 	// 0x8231F739
	0x3E41, 0x3E42, 0x3E43, 0x3E44, 0x3E45, 0x3E46, 0x3E47, 0x3E48, 0x3E49, 0x3E4A, 	// 0x8231F839
	0x3E4B, 0x3E4C, 0x3E4D, 0x3E4E, 0x3E4F, 0x3E50, 0x3E51, 0x3E52, 0x3E53, 0x3E54, 	// 0x8231F939
	0x3E55, 0x3E56, 0x3E57, 0x3E58, 0x3E59, 0x3E5A, 0x3E5B, 0x3E5C, 0x3E5D, 0x3E5E, 	// 0x8231FA39
	0x3E5F, 0x3E60, 0x3E61, 0x3E62, 0x3E63, 0x3E64, 0x3E65, 0x3E66, 0x3E67, 0x3E68, 	// 0x8231FB39
	0x3E69, 0x3E6A, 0x3E6B, 0x3E6C, 0x3E6D, 0x3E6E, 0x3E6F, 0x3E70, 0x3E71, 0x3E72, 	// 0x8231FC39
	0x3E73, 0x3E74, 0x3E75, 0x3E76, 0x3E77, 0x3E78, 0x3E79, 0x3E7A, 0x3E7B, 0x3E7C, 	// 0x8231FD39
	0x3E7D, 0x3E7E, 0x3E7F, 0x3E80, 0x3E81, 0x3E82, 0x3E83, 0x3E84, 0x3E85, 0x3E86, 	// 0x8231FE39
	0x3E87, 0x3E88, 0x3E89, 0x3E8A, 0x3E8B, 0x3E8C, 0x3E8D, 0x3E8E, 0x3E8F, 0x3E90, 	// 0x82328139
	0x3E91, 0x3E92, 0x3E93, 0x3E94, 0x3E95, 0x3E96, 0x3E97, 0x3E98, 0x3E99, 0x3E9A, 	// 0x82328239
	0x3E9B, 0x3E9C, 0x3E9D, 0x3E9E, 0x3E9F, 0x3EA0, 0x3EA1, 0x3EA2, 0x3EA3, 0x3EA4, 	// 0x82328339
	0x3EA5, 0x3EA6, 0x3EA7, 0x3EA8, 0x3EA9, 0x3EAA, 0x3EAB, 0x3EAC, 0x3EAD, 0x3EAE, 	// 0x82328439
	0x3EAF, 0x3EB0, 0x3EB1, 0x3EB2, 0x3EB3, 0x3EB4, 0x3EB5, 0x3EB6, 0x3EB7, 0x3EB8, 	// 0x82328539
	0x3EB9, 0x3EBA, 0x3EBB, 0x3EBC, 0x3EBD, 0x3EBE, 0x3EBF, 0x3EC0, 0x3EC1, 0x3EC2, 	// 0x82328639
	0x3EC3, 0x3EC4, 0x3EC5, 0x3EC6, 0x3EC7, 0x3EC8, 0x3EC9, 0x3ECA, 0x3ECB, 0x3ECC, 	// 0x82328739
	0x3ECD, 0x3ECE, 0x3ECF, 0x3ED0, 0x3ED1, 0x3ED2, 0x3ED3, 0x3ED4, 0x3ED5, 0x3ED6, 	// 0x82328839
	0x3ED7, 0x3ED8, 0x3ED9, 0x3EDA, 0x3EDB, 0x3EDC, 0x3EDD, 0x3EDE, 0x3EDF, 0x3EE0, 	// 0x82328939
	0x3EE1, 0x3EE2, 0x3EE3, 0x3EE4, 0x3EE5, 0x3EE6, 0x3EE7, 0x3EE8, 0x3EE9, 0x3EEA, 	// 0x82328A39
	0x3EEB, 0x3EEC, 0x3EED, 0x3EEE, 0x3EEF, 0x3EF0, 0x3EF1, 0x3EF2, 0x3EF3, 0x3EF4, 	// 0x82328B39
	0x3EF5, 0x3EF6, 0x3EF7, 0x3EF8, 0x3EF9, 0x3EFA, 0x3EFB, 0x3EFC, 0x3EFD, 0x3EFE, 	// 0x82328C39
	0x3EFF, 0x3F00, 0x3F01, 0x3F02, 0x3F03, 0x3F04, 0x3F05, 0x3F06, 0x3F07, 0x3F08, 	// 0x82328D39
	0x3F09, 0x3F0A, 0x3F0B, 0x3F0C, 0x3F0D, 0x3F0E, 0x3F0F, 0x3F10, 0x3F11, 0x3F12, 	// 0x82328E39
	0x3F13, 0x3F14, 0x3F15, 0x3F16, 0x3F17, 0x3F18, 0x3F19, 0x3F1A, 0x3F1B, 0x3F1C, 	// 0x82328F39
	0x3F1D, 0x3F1E, 0x3F1F, 0x3F20, 0x3F21, 0x3F22, 0x3F23, 0x3F24, 0x3F25, 0x3F26, 	// 0x82329039
	0x3F27, 0x3F28, 0x3F29, 0x3F2A, 0x3F2B, 0x3F2C, 0x3F2D, 0x3F2E, 0x3F2F, 0x3F30, 	// 0x82329139
	0x3F31, 0x3F32, 0x3F33, 0x3F34, 0x3F35, 0x3F36, 0x3F37, 0x3F38, 0x3F39, 0x3F3A, 	// 0x82329239
	0x3F3B, 0x3F3C, 0x3F3D, 0x3F3E, 0x3F3F, 0x3F40, 0x3F41, 0x3F42, 0x3F43, 0x3F44, 	// 0x82329339
	0x3F45, 0x3F46, 0x3F47, 0x3F48, 0x3F49, 0x3F4A, 0x3F4B, 0x3F4C, 0x3F4D, 0x3F4E, 	// 0x82329439
	0x3F4F, 0x3F50, 0x3F51, 0x3F52, 0x3F53, 0x3F54, 0x3F55, 0x3F56, 0x3F57, 0x3F58, 	// 0x82329539
	0x3F59, 0x3F5A, 0x3F5B, 0x3F5C, 0x3F5D, 0x3F5E, 0x3F5F, 0x3F60, 0x3F61, 0x3F62, 	// 0x82329639
	0x3F63, 0x3F64, 0x3F65, 0x3F66, 0x3F67, 0x3F68, 0x3F69, 0x3F6A, 0x3F6B, 0x3F6C, 	// 0x82329739
	0x3F6D, 0x3F6E, 0x3F6F, 0x3F70, 0x3F71, 0x3F72, 0x3F73, 0x3F74, 0x3F75, 0x3F76, 	// 0x82329839
	0x3F77, 0x3F78, 0x3F79, 0x3F7A, 0x3F7B, 0x3F7C, 0x3F7D, 0x3F7E, 0x3F7F, 0x3F80, 	// 0x82329939
	0x3F81, 0x3F82, 0x3F83, 0x3F84, 0x3F85, 0x3F86, 0x3F87, 0x3F88, 0x3F89, 0x3F8A, 	// 0x82329A39
	0x3F8B, 0x3F8C, 0x3F8D, 0x3F8E, 0x3F8F, 0x3F90, 0x3F91, 0x3F92, 0x3F93, 0x3F94, 	// 0x82329B39
	0x3F95, 0x3F96, 0x3F97, 0x3F98, 0x3F99, 0x3F9A, 0x3F9B, 0x3F9C, 0x3F9D, 0x3F9E, 	// 0x82329C39
	0x3F9F, 0x3FA0, 0x3FA1, 0x3FA2, 0x3FA3, 0x3FA4, 0x3FA5, 0x3FA6, 0x3FA7, 0x3FA8, 	// 0x82329D39
	0x3FA9, 0x3FAA, 0x3FAB, 0x3FAC, 0x3FAD, 0x3FAE, 0x3FAF, 0x3FB0, 0x3FB1, 0x3FB2, 	// 0x82329E39
	0x3FB3, 0x3FB4, 0x3FB5, 0x3FB6, 0x3FB7, 0x3FB8, 0x3FB9, 0x3FBA, 0x3FBB, 0x3FBC, 	// 0x82329F39
	0x3FBD, 0x3FBE, 0x3FBF, 0x3FC0, 0x3FC1, 0x3FC2, 0x3FC3, 0x3FC4, 0x3FC5, 0x3FC6, 	// 0x8232A039
	0x3FC7, 0x3FC8, 0x3FC9, 0x3FCA, 0x3FCB, 0x3FCC, 0x3FCD, 0x3FCE, 0x3FCF, 0x3FD0, 	// 0x8232A139
	0x3FD1, 0x3FD2, 0x3FD3, 0x3FD4, 0x3FD5, 0x3FD6, 0x3FD7, 0x3FD8, 0x3FD9, 0x3FDA, 	// 0x8232A239
	0x3FDB, 0x3FDC, 0x3FDD, 0x3FDE, 0x3FDF, 0x3FE0, 0x3FE1, 0x3FE2, 0x3FE3, 0x3FE4, 	// 0x8232A339
	0x3FE5, 0x3FE6, 0x3FE7, 0x3FE8, 0x3FE9, 0x3FEA, 0x3FEB, 0x3FEC, 0x3FED, 0x3FEE, 	// 0x8232A439
	0x3FEF, 0x3FF0, 0x3FF1, 0x3FF2, 0x3FF3, 0x3FF4, 0x3FF5, 0x3FF6, 0x3FF7, 0x3FF8, 	// 0x8232A539
	0x3FF9, 0x3FFA, 0x3FFB, 0x3FFC, 0x3FFD, 0x3FFE, 0x3FFF, 0x4000, 0x4001, 0x4002, 	// 0x8232A639
	0x4003, 0x4004, 0x4005, 0x4006, 0x4007, 0x4008, 0x4009, 0x400A, 0x400B, 0x400C, 	// 0x8232A739
	0x400D, 0x400E, 0x400F, 0x4010, 0x4011, 0x4012, 0x4013, 0x4014, 0x4015, 0x4016, 	// 0x8232A839
	0x4017, 0x4018, 0x4019, 0x401A, 0x401B, 0x401C, 0x401D, 0x401E, 0x401F, 0x4020, 	// 0x8232A939
	0x4021, 0x4022, 0x4023, 0x4024, 0x4025, 0x4026, 0x4027, 0x4028, 0x4029, 0x402A, 	// 0x8232AA39
	0x402B, 0x402C, 0x402D, 0x402E, 0x402F, 0x4030, 0x4031, 0x4032, 0x4033, 0x4034, 	// 0x8232AB39
	0x4035, 0x4036, 0x4037, 0x4038, 0x4039, 0x403A, 0x403B, 0x403C, 0x403D, 0x403E, 	// 0x8232AC39
	0x403F, 0x4040, 0x4041, 0x4042, 0x4043, 0x4044, 0x4045, 0x4046, 0x4047, 0x4048, 	// 0x8232AD39
	0x4049, 0x404A, 0x404B, 0x404C, 0x404D, 0x404E, 0x404F, 0x4050, 0x4051, 0x4052, 	// 0x8232AE39
	0x4053, 0x4054, 0x4055, 0x4057, 0x4058, 0x4059, 0x405A, 0x405B, 0x405C, 0x405D, 	// 0x8232AF39
	0x405E, 0x405F, 0x4060, 0x4061, 0x4062, 0x4063, 0x4064, 0x4065, 0x4066, 0x4067, 	// 0x8232B039
	0x4068, 0x4069, 0x406A, 0x406B, 0x406C, 0x406D, 0x406E, 0x406F, 0x4070, 0x4071, 	// 0x8232B139
	0x4072, 0x4073, 0x4074, 0x4075, 0x4076, 0x4077, 0x4078, 0x4079, 0x407A, 0x407B, 	// 0x8232B239
	0x407C, 0x407D, 0x407E, 0x407F, 0x4080, 0x4081, 0x4082, 0x4083, 0x4084, 0x4085, 	// 0x8232B339
	0x4086, 0x4087, 0x4088, 0x4089, 0x408A, 0x408B, 0x408C, 0x408D, 0x408E, 0x408F, 	// 0x8232B439
	0x4090, 0x4091, 0x4092, 0x4093, 0x4094, 0x4095, 0x4096, 0x4097, 0x4098, 0x4099, 	// 0x8232B539
	0x409A, 0x409B, 0x409C, 0x409D, 0x409E, 0x409F, 0x40A0, 0x40A1, 0x40A2, 0x40A3, 	// 0x8232B639
	0x40A4, 0x40A5, 0x40A6, 0x40A7, 0x40A8, 0x40A9, 0x40AA, 0x40AB, 0x40AC, 0x40AD, 	// 0x8232B739
	0x40AE, 0x40AF, 0x40B0, 0x40B1, 0x40B2, 0x40B3, 0x40B4, 0x40B5, 0x40B6, 0x40B7, 	// 0x8232B839
	0x40B8, 0x40B9, 0x40BA, 0x40BB, 0x40BC, 0x40BD, 0x40BE, 0x40BF, 0x40C0, 0x40C1, 	// 0x8232B939
	0x40C2, 0x40C3, 0x40C4, 0x40C5, 0x40C6, 0x40C7, 0x40C8, 0x40C9, 0x40CA, 0x40CB, 	// 0x8232BA39
	0x40CC, 0x40CD, 0x40CE, 0x40CF, 0x40D0, 0x40D1, 0x40D2, 0x40D3, 0x40D4, 0x40D5, 	// 0x8232BB39
	0x40D6, 0x40D7, 0x40D8, 0x40D9, 0x40DA, 0x40DB, 0x40DC, 0x40DD, 0x40DE, 0x40DF, 	// 0x8232BC39
	0x40E0, 0x40E1, 0x40E2, 0x40E3, 0x40E4, 0x40E5, 0x40E6, 0x40E7, 0x40E8, 0x40E9, 	// 0x8232BD39
	0x40EA, 0x40EB, 0x40EC, 0x40ED, 0x40EE, 0x40EF, 0x40F0, 0x40F1, 0x40F2, 0x40F3, 	// 0x8232BE39
	0x40F4, 0x40F5, 0x40F6, 0x40F7, 0x40F8, 0x40F9, 0x40FA, 0x40FB, 0x40FC, 0x40FD, 	// 0x8232BF39
	0x40FE, 0x40FF, 0x4100, 0x4101, 0x4102, 0x4103, 0x4104, 0x4105, 0x4106, 0x4107, 	// 0x8232C039
	0x4108, 0x4109, 0x410A, 0x410B, 0x410C, 0x410D, 0x410E, 0x410F, 0x4110, 0x4111, 	// 0x8232C139
	0x4112, 0x4113, 0x4114, 0x4115, 0x4116, 0x4117, 0x4118, 0x4119, 0x411A, 0x411B, 	// 0x8232C239
	0x411C, 0x411D, 0x411E, 0x411F, 0x4120, 0x4121, 0x4122, 0x4123, 0x4124, 0x4125, 	// 0x8232C339
	0x4126, 0x4127, 0x4128, 0x4129, 0x412A, 0x412B, 0x412C, 0x412D, 0x412E, 0x412F, 	// 0x8232C439
	0x4130, 0x4131, 0x4132, 0x4133, 0x4134, 0x4135, 0x4136, 0x4137, 0x4138, 0x4139, 	// 0x8232C539
	0x413A, 0x413B, 0x413C, 0x413D, 0x413E, 0x413F, 0x4140, 0x4141, 0x4142, 0x4143, 	// 0x8232C639
	0x4144, 0x4145, 0x4146, 0x4147, 0x4148, 0x4149, 0x414A, 0x414B, 0x414C, 0x414D, 	// 0x8232C739
	0x414E, 0x414F, 0x4150, 0x4151, 0x4152, 0x4153, 0x4154, 0x4155, 0x4156, 0x4157, 	// 0x8232C839
	0x4158, 0x4159, 0x415A, 0x415B, 0x415C, 0x415D, 0x415E, 0x4160, 0x4161, 0x4162, 	// 0x8232C939
	0x4163, 0x4164, 0x4165, 0x4166, 0x4167, 0x4168, 0x4169, 0x416A, 0x416B, 0x416C, 	// 0x8232CA39
	0x416D, 0x416E, 0x416F, 0x4170, 0x4171, 0x4172, 0x4173, 0x4174, 0x4175, 0x4176, 	// 0x8232CB39
	0x4177, 0x4178, 0x4179, 0x417A, 0x417B, 0x417C, 0x417D, 0x417E, 0x417F, 0x4180, 	// 0x8232CC39
	0x4181, 0x4182, 0x4183, 0x4184, 0x4185, 0x4186, 0x4187, 0x4188, 0x4189, 0x418A, 	// 0x8232CD39
	0x418B, 0x418C, 0x418D, 0x418E, 0x418F, 0x4190, 0x4191, 0x4192, 0x4193, 0x4194, 	// 0x8232CE39
	0x4195, 0x4196, 0x4197, 0x4198, 0x4199, 0x419A, 0x419B, 0x419C, 0x419D, 0x419E, 	// 0x8232CF39
	0x419F, 0x41A0, 0x41A1, 0x41A2, 0x41A3, 0x41A4, 0x41A5, 0x41A6, 0x41A7, 0x41A8, 	// 0x8232D039
	0x41A9, 0x41AA, 0x41AB, 0x41AC, 0x41AD, 0x41AE, 0x41AF, 0x41B0, 0x41B1, 0x41B2, 	// 0x8232D139
	0x41B3, 0x41B4, 0x41B5, 0x41B6, 0x41B7, 0x41B8, 0x41B9, 0x41BA, 0x41BB, 0x41BC, 	// 0x8232D239
	0x41BD, 0x41BE, 0x41BF, 0x41C0, 0x41C1, 0x41C2, 0x41C3, 0x41C4, 0x41C5, 0x41C6, 	// 0x8232D339
	0x41C7, 0x41C8, 0x41C9, 0x41CA, 0x41CB, 0x41CC, 0x41CD, 0x41CE, 0x41CF, 0x41D0, 	// 0x8232D439
	0x41D1, 0x41D2, 0x41D3, 0x41D4, 0x41D5, 0x41D6, 0x41D7, 0x41D8, 0x41D9, 0x41DA, 	// 0x8232D539
	0x41DB, 0x41DC, 0x41DD, 0x41DE, 0x41DF, 0x41E0, 0x41E1, 0x41E2, 0x41E3, 0x41E4, 	// 0x8232D639
	0x41E5, 0x41E6, 0x41E7, 0x41E8, 0x41E9, 0x41EA, 0x41EB, 0x41EC, 0x41ED, 0x41EE, 	// 0x8232D739
	0x41EF, 0x41F0, 0x41F1, 0x41F2, 0x41F3, 0x41F4, 0x41F5, 0x41F6, 0x41F7, 0x41F8, 	// 0x8232D839
	0x41F9, 0x41FA, 0x41FB, 0x41FC, 0x41FD, 0x41FE, 0x41FF, 0x4200, 0x4201, 0x4202, 	// 0x8232D939
	0x4203, 0x4204, 0x4205, 0x4206, 0x4207, 0x4208, 0x4209, 0x420A, 0x420B, 0x420C, 	// 0x8232DA39
	0x420D, 0x420E, 0x420F, 0x4210, 0x4211, 0x4212, 0x4213, 0x4214, 0x4215, 0x4216, 	// 0x8232DB39
	0x4217, 0x4218, 0x4219, 0x421A, 0x421B, 0x421C, 0x421D, 0x421E, 0x421F, 0x4220, 	// 0x8232DC39
	0x4221, 0x4222, 0x4223, 0x4224, 0x4225, 0x4226, 0x4227, 0x4228, 0x4229, 0x422A, 	// 0x8232DD39
	0x422B, 0x422C, 0x422D, 0x422E, 0x422F, 0x4230, 0x4231, 0x4232, 0x4233, 0x4234, 	// 0x8232DE39
	0x4235, 0x4236, 0x4237, 0x4238, 0x4239, 0x423A, 0x423B, 0x423C, 0x423D, 0x423E, 	// 0x8232DF39
	0x423F, 0x4240, 0x4241, 0x4242, 0x4243, 0x4244, 0x4245, 0x4246, 0x4247, 0x4248, 	// 0x8232E039
	0x4249, 0x424A, 0x424B, 0x424C, 0x424D, 0x424E, 0x424F, 0x4250, 0x4251, 0x4252, 	// 0x8232E139
	0x4253, 0x4254, 0x4255, 0x4256, 0x4257, 0x4258, 0x4259, 0x425A, 0x425B, 0x425C, 	// 0x8232E239
	0x425D, 0x425E, 0x425F, 0x4260, 0x4261, 0x4262, 0x4263, 0x4264, 0x4265, 0x4266, 	// 0x8232E339
	0x4267, 0x4268, 0x4269, 0x426A, 0x426B, 0x426C, 0x426D, 0x426E, 0x426F, 0x4270, 	// 0x8232E439
	0x4271, 0x4272, 0x4273, 0x4274, 0x4275, 0x4276, 0x4277, 0x4278, 0x4279, 0x427A, 	// 0x8232E539
	0x427B, 0x427C, 0x427D, 0x427E, 0x427F, 0x4280, 0x4281, 0x4282, 0x4283, 0x4284, 	// 0x8232E639
	0x4285, 0x4286, 0x4287, 0x4288, 0x4289, 0x428A, 0x428B, 0x428C, 0x428D, 0x428E, 	// 0x8232E739
	0x428F, 0x4290, 0x4291, 0x4292, 0x4293, 0x4294, 0x4295, 0x4296, 0x4297, 0x4298, 	// 0x8232E839
	0x4299, 0x429A, 0x429B, 0x429C, 0x429D, 0x429E, 0x429F, 0x42A0, 0x42A1, 0x42A2, 	// 0x8232E939
	0x42A3, 0x42A4, 0x42A5, 0x42A6, 0x42A7, 0x42A8, 0x42A9, 0x42AA, 0x42AB, 0x42AC, 	// 0x8232EA39
	0x42AD, 0x42AE, 0x42AF, 0x42B0, 0x42B1, 0x42B2, 0x42B3, 0x42B4, 0x42B5, 0x42B6, 	// 0x8232EB39
	0x42B7, 0x42B8, 0x42B9, 0x42BA, 0x42BB, 0x42BC, 0x42BD, 0x42BE, 0x42BF, 0x42C0, 	// 0x8232EC39
	0x42C1, 0x42C2, 0x42C3, 0x42C4, 0x42C5, 0x42C6, 0x42C7, 0x42C8, 0x42C9, 0x42CA, 	// 0x8232ED39
	0x42CB, 0x42CC, 0x42CD, 0x42CE, 0x42CF, 0x42D0, 0x42D1, 0x42D2, 0x42D3, 0x42D4, 	// 0x8232EE39
	0x42D5, 0x42D6, 0x42D7, 0x42D8, 0x42D9, 0x42DA, 0x42DB, 0x42DC, 0x42DD, 0x42DE, 	// 0x8232EF39
	0x42DF, 0x42E0, 0x42E1, 0x42E2, 0x42E3, 0x42E4, 0x42E5, 0x42E6, 0x42E7, 0x42E8, 	// 0x8232F039
	0x42E9, 0x42EA, 0x42EB, 0x42EC, 0x42ED, 0x42EE, 0x42EF, 0x42F0, 0x42F1, 0x42F2, 	// 0x8232F139
	0x42F3, 0x42F4, 0x42F5, 0x42F6, 0x42F7, 0x42F8, 0x42F9, 0x42FA, 0x42FB, 0x42FC, 	// 0x8232F239
	0x42FD, 0x42FE, 0x42FF, 0x4300, 0x4301, 0x4302, 0x4303, 0x4304, 0x4305, 0x4306, 	// 0x8232F339
	0x4307, 0x4308, 0x4309, 0x430A, 0x430B, 0x430C, 0x430D, 0x430E, 0x430F, 0x4310, 	// 0x8232F439
	0x4311, 0x4312, 0x4313, 0x4314, 0x4315, 0x4316, 0x4317, 0x4318, 0x4319, 0x431A, 	// 0x8232F539
	0x431B, 0x431C, 0x431D, 0x431E, 0x431F, 0x4320, 0x4321, 0x4322, 0x4323, 0x4324, 	// 0x8232F639
	0x4325, 0x4326, 0x4327, 0x4328, 0x4329, 0x432A, 0x432B, 0x432C, 0x432D, 0x432E, 	// 0x8232F739
	0x432F, 0x4330, 0x4331, 0x4332, 0x4333, 0x4334, 0x4335, 0x4336, 0x4338, 0x4339, 	// 0x8232F839
	0x433A, 0x433B, 0x433C, 0x433D, 0x433E, 0x433F, 0x4340, 0x4341, 0x4342, 0x4343, 	// 0x8232F939
	0x4344, 0x4345, 0x4346, 0x4347, 0x4348, 0x4349, 0x434A, 0x434B, 0x434C, 0x434D, 	// 0x8232FA39
	0x434E, 0x434F, 0x4350, 0x4351, 0x4352, 0x4353, 0x4354, 0x4355, 0x4356, 0x4357, 	// 0x8232FB39
	0x4358, 0x4359, 0x435A, 0x435B, 0x435C, 0x435D, 0x435E, 0x435F, 0x4360, 0x4361, 	// 0x8232FC39
	0x4362, 0x4363, 0x4364, 0x4365, 0x4366, 0x4367, 0x4368, 0x4369, 0x436A, 0x436B, 	// 0x8232FD39
	0x436C, 0x436D, 0x436E, 0x436F, 0x4370, 0x4371, 0x4372, 0x4373, 0x4374, 0x4375, 	// 0x8232FE39
	0x4376, 0x4377, 0x4378, 0x4379, 0x437A, 0x437B, 0x437C, 0x437D, 0x437E, 0x437F, 	// 0x82338139
	0x4380, 0x4381, 0x4382, 0x4383, 0x4384, 0x4385, 0x4386, 0x4387, 0x4388, 0x4389, 	// 0x82338239
	0x438A, 0x438B, 0x438C, 0x438D, 0x438E, 0x438F, 0x4390, 0x4391, 0x4392, 0x4393, 	// 0x82338339
	0x4394, 0x4395, 0x4396, 0x4397, 0x4398, 0x4399, 0x439A, 0x439B, 0x439C, 0x439D, 	// 0x82338439
	0x439E, 0x439F, 0x43A0, 0x43A1, 0x43A2, 0x43A3, 0x43A4, 0x43A5, 0x43A6, 0x43A7, 	// 0x82338539
	0x43A8, 0x43A9, 0x43AA, 0x43AB, 0x43AD, 0x43AE, 0x43AF, 0x43B0, 0x43B2, 0x43B3, 	// 0x82338639
	0x43B4, 0x43B5, 0x43B6, 0x43B7, 0x43B8, 0x43B9, 0x43BA, 0x43BB, 0x43BC, 0x43BD, 	// 0x82338739
	0x43BE, 0x43BF, 0x43C0, 0x43C1, 0x43C2, 0x43C3, 0x43C4, 0x43C5, 0x43C6, 0x43C7, 	// 0x82338839
	0x43C8, 0x43C9, 0x43CA, 0x43CB, 0x43CC, 0x43CD, 0x43CE, 0x43CF, 0x43D0, 0x43D1, 	// 0x82338939
	0x43D2, 0x43D3, 0x43D4, 0x43D5, 0x43D6, 0x43D7, 0x43D8, 0x43D9, 0x43DA, 0x43DB, 	// 0x82338A39
	0x43DC, 0x43DE, 0x43DF, 0x43E0, 0x43E1, 0x43E2, 0x43E3, 0x43E4, 0x43E5, 0x43E6, 	// 0x82338B39
	0x43E7, 0x43E8, 0x43E9, 0x43EA, 0x43EB, 0x43EC, 0x43ED, 0x43EE, 0x43EF, 0x43F0, 	// 0x82338C39
	0x43F1, 0x43F2, 0x43F3, 0x43F4, 0x43F5, 0x43F6, 0x43F7, 0x43F8, 0x43F9, 0x43FA, 	// 0x82338D39
	0x43FB, 0x43FC, 0x43FD, 0x43FE, 0x43FF, 0x4400, 0x4401, 0x4402, 0x4403, 0x4404, 	// 0x82338E39
	0x4405, 0x4406, 0x4407, 0x4408, 0x4409, 0x440A, 0x440B, 0x440C, 0x440D, 0x440E, 	// 0x82338F39
	0x440F, 0x4410, 0x4411, 0x4412, 0x4413, 0x4414, 0x4415, 0x4416, 0x4417, 0x4418, 	// 0x82339039
	0x4419, 0x441A, 0x441B, 0x441C, 0x441D, 0x441E, 0x441F, 0x4420, 0x4421, 0x4422, 	// 0x82339139
	0x4423, 0x4424, 0x4425, 0x4426, 0x4427, 0x4428, 0x4429, 0x442A, 0x442B, 0x442C, 	// 0x82339239
	0x442D, 0x442E, 0x442F, 0x4430, 0x4431, 0x4432, 0x4433, 0x4434, 0x4435, 0x4436, 	// 0x82339339
	0x4437, 0x4438, 0x4439, 0x443A, 0x443B, 0x443C, 0x443D, 0x443E, 0x443F, 0x4440, 	// 0x82339439
	0x4441, 0x4442, 0x4443, 0x4444, 0x4445, 0x4446, 0x4447, 0x4448, 0x4449, 0x444A, 	// 0x82339539
	0x444B, 0x444C, 0x444D, 0x444E, 0x444F, 0x4450, 0x4451, 0x4452, 0x4453, 0x4454, 	// 0x82339639
	0x4455, 0x4456, 0x4457, 0x4458, 0x4459, 0x445A, 0x445B, 0x445C, 0x445D, 0x445E, 	// 0x82339739
	0x445F, 0x4460, 0x4461, 0x4462, 0x4463, 0x4464, 0x4465, 0x4466, 0x4467, 0x4468, 	// 0x82339839
	0x4469, 0x446A, 0x446B, 0x446C, 0x446D, 0x446E, 0x446F, 0x4470, 0x4471, 0x4472, 	// 0x82339939
	0x4473, 0x4474, 0x4475, 0x4476, 0x4477, 0x4478, 0x4479, 0x447A, 0x447B, 0x447C, 	// 0x82339A39
	0x447D, 0x447E, 0x447F, 0x4480, 0x4481, 0x4482, 0x4483, 0x4484, 0x4485, 0x4486, 	// 0x82339B39
	0x4487, 0x4488, 0x4489, 0x448A, 0x448B, 0x448C, 0x448D, 0x448E, 0x448F, 0x4490, 	// 0x82339C39
	0x4491, 0x4492, 0x4493, 0x4494, 0x4495, 0x4496, 0x4497, 0x4498, 0x4499, 0x449A, 	// 0x82339D39
	0x449B, 0x449C, 0x449D, 0x449E, 0x449F, 0x44A0, 0x44A1, 0x44A2, 0x44A3, 0x44A4, 	// 0x82339E39
	0x44A5, 0x44A6, 0x44A7, 0x44A8, 0x44A9, 0x44AA, 0x44AB, 0x44AC, 0x44AD, 0x44AE, 	// 0x82339F39
	0x44AF, 0x44B0, 0x44B1, 0x44B2, 0x44B3, 0x44B4, 0x44B5, 0x44B6, 0x44B7, 0x44B8, 	// 0x8233A039
	0x44B9, 0x44BA, 0x44BB, 0x44BC, 0x44BD, 0x44BE, 0x44BF, 0x44C0, 0x44C1, 0x44C2, 	// 0x8233A139
	0x44C3, 0x44C4, 0x44C5, 0x44C6, 0x44C7, 0x44C8, 0x44C9, 0x44CA, 0x44CB, 0x44CC, 	// 0x8233A239
	0x44CD, 0x44CE, 0x44CF, 0x44D0, 0x44D1, 0x44D2, 0x44D3, 0x44D4, 0x44D5, 0x44D7, 	// 0x8233A339
	0x44D8, 0x44D9, 0x44DA, 0x44DB, 0x44DC, 0x44DD, 0x44DE, 0x44DF, 0x44E0, 0x44E1, 	// 0x8233A439
	0x44E2, 0x44E3, 0x44E4, 0x44E5, 0x44E6, 0x44E7, 0x44E8, 0x44E9, 0x44EA, 0x44EB, 	// 0x8233A539
	0x44EC, 0x44ED, 0x44EE, 0x44EF, 0x44F0, 0x44F1, 0x44F2, 0x44F3, 0x44F4, 0x44F5, 	// 0x8233A639
	0x44F6, 0x44F7, 0x44F8, 0x44F9, 0x44FA, 0x44FB, 0x44FC, 0x44FD, 0x44FE, 0x44FF, 	// 0x8233A739
	0x4500, 0x4501, 0x4502, 0x4503, 0x4504, 0x4505, 0x4506, 0x4507, 0x4508, 0x4509, 	// 0x8233A839
	0x450A, 0x450B, 0x450C, 0x450D, 0x450E, 0x450F, 0x4510, 0x4511, 0x4512, 0x4513, 	// 0x8233A939
	0x4514, 0x4515, 0x4516, 0x4517, 0x4518, 0x4519, 0x451A, 0x451B, 0x451C, 0x451D, 	// 0x8233AA39
	0x451E, 0x451F, 0x4520, 0x4521, 0x4522, 0x4523, 0x4524, 0x4525, 0x4526, 0x4527, 	// 0x8233AB39
	0x4528, 0x4529, 0x452A, 0x452B, 0x452C, 0x452D, 0x452E, 0x452F, 0x4530, 0x4531, 	// 0x8233AC39
	0x4532, 0x4533, 0x4534, 0x4535, 0x4536, 0x4537, 0x4538, 0x4539, 0x453A, 0x453B, 	// 0x8233AD39
	0x453C, 0x453D, 0x453E, 0x453F, 0x4540, 0x4541, 0x4542, 0x4543, 0x4544, 0x4545, 	// 0x8233AE39
	0x4546, 0x4547, 0x4548, 0x4549, 0x454A, 0x454B, 0x454C, 0x454D, 0x454E, 0x454F, 	// 0x8233AF39
	0x4550, 0x4551, 0x4552, 0x4553, 0x4554, 0x4555, 0x4556, 0x4557, 0x4558, 0x4559, 	// 0x8233B039
	0x455A, 0x455B, 0x455C, 0x455D, 0x455E, 0x455F, 0x4560, 0x4561, 0x4562, 0x4563, 	// 0x8233B139
	0x4564, 0x4565, 0x4566, 0x4567, 0x4568, 0x4569, 0x456A, 0x456B, 0x456C, 0x456D, 	// 0x8233B239
	0x456E, 0x456F, 0x4570, 0x4571, 0x4572, 0x4573, 0x4574, 0x4575, 0x4576, 0x4577, 	// 0x8233B339
	0x4578, 0x4579, 0x457A, 0x457B, 0x457C, 0x457D, 0x457E, 0x457F, 0x4580, 0x4581, 	// 0x8233B439
	0x4582, 0x4583, 0x4584, 0x4585, 0x4586, 0x4587, 0x4588, 0x4589, 0x458A, 0x458B, 	// 0x8233B539
	0x458C, 0x458D, 0x458E, 0x458F, 0x4590, 0x4591, 0x4592, 0x4593, 0x4594, 0x4595, 	// 0x8233B639
	0x4596, 0x4597, 0x4598, 0x4599, 0x459A, 0x459B, 0x459C, 0x459D, 0x459E, 0x459F, 	// 0x8233B739
	0x45A0, 0x45A1, 0x45A2, 0x45A3, 0x45A4, 0x45A5, 0x45A6, 0x45A7, 0x45A8, 0x45A9, 	// 0x8233B839
	0x45AA, 0x45AB, 0x45AC, 0x45AD, 0x45AE, 0x45AF, 0x45B0, 0x45B1, 0x45B2, 0x45B3, 	// 0x8233B939
	0x45B4, 0x45B5, 0x45B6, 0x45B7, 0x45B8, 0x45B9, 0x45BA, 0x45BB, 0x45BC, 0x45BD, 	// 0x8233BA39
	0x45BE, 0x45BF, 0x45C0, 0x45C1, 0x45C2, 0x45C3, 0x45C4, 0x45C5, 0x45C6, 0x45C7, 	// 0x8233BB39
	0x45C8, 0x45C9, 0x45CA, 0x45CB, 0x45CC, 0x45CD, 0x45CE, 0x45CF, 0x45D0, 0x45D1, 	// 0x8233BC39
	0x45D2, 0x45D3, 0x45D4, 0x45D5, 0x45D6, 0x45D7, 0x45D8, 0x45D9, 0x45DA, 0x45DB, 	// 0x8233BD39
	0x45DC, 0x45DD, 0x45DE, 0x45DF, 0x45E0, 0x45E1, 0x45E2, 0x45E3, 0x45E4, 0x45E5, 	// 0x8233BE39
	0x45E6, 0x45E7, 0x45E8, 0x45E9, 0x45EA, 0x45EB, 0x45EC, 0x45ED, 0x45EE, 0x45EF, 	// 0x8233BF39
	0x45F0, 0x45F1, 0x45F2, 0x45F3, 0x45F4, 0x45F5, 0x45F6, 0x45F7, 0x45F8, 0x45F9, 	// 0x8233C039
	0x45FA, 0x45FB, 0x45FC, 0x45FD, 0x45FE, 0x45FF, 0x4600, 0x4601, 0x4602, 0x4603, 	// 0x8233C139
	0x4604, 0x4605, 0x4606, 0x4607, 0x4608, 0x4609, 0x460A, 0x460B, 0x460C, 0x460D, 	// 0x8233C239
	0x460E, 0x460F, 0x4610, 0x4611, 0x4612, 0x4613, 0x4614, 0x4615, 0x4616, 0x4617, 	// 0x8233C339
	0x4618, 0x4619, 0x461A, 0x461B, 0x461C, 0x461D, 0x461E, 0x461F, 0x4620, 0x4621, 	// 0x8233C439
	0x4622, 0x4623, 0x4624, 0x4625, 0x4626, 0x4627, 0x4628, 0x4629, 0x462A, 0x462B, 	// 0x8233C539
	0x462C, 0x462D, 0x462E, 0x462F, 0x4630, 0x4631, 0x4632, 0x4633, 0x4634, 0x4635, 	// 0x8233C639
	0x4636, 0x4637, 0x4638, 0x4639, 0x463A, 0x463B, 0x463C, 0x463D, 0x463E, 0x463F, 	// 0x8233C739
	0x4640, 0x4641, 0x4642, 0x4643, 0x4644, 0x4645, 0x4646, 0x4647, 0x4648, 0x4649, 	// 0x8233C839
	0x464A, 0x464B, 0x464D, 0x464E, 0x464F, 0x4650, 0x4651, 0x4652, 0x4653, 0x4654, 	// 0x8233C939
	0x4655, 0x4656, 0x4657, 0x4658, 0x4659, 0x465A, 0x465B, 0x465C, 0x465D, 0x465E, 	// 0x8233CA39
	0x465F, 0x4660, 0x4662, 0x4663, 0x4664, 0x4665, 0x4666, 0x4667, 0x4668, 0x4669, 	// 0x8233CB39
	0x466A, 0x466B, 0x466C, 0x466D, 0x466E, 0x466F, 0x4670, 0x4671, 0x4672, 0x4673, 	// 0x8233CC39
	0x4674, 0x4675, 0x4676, 0x4677, 0x4678, 0x4679, 0x467A, 0x467B, 0x467C, 0x467D, 	// 0x8233CD39
	0x467E, 0x467F, 0x4680, 0x4681, 0x4682, 0x4683, 0x4684, 0x4685, 0x4686, 0x4687, 	// 0x8233CE39
	0x4688, 0x4689, 0x468A, 0x468B, 0x468C, 0x468D, 0x468E, 0x468F, 0x4690, 0x4691, 	// 0x8233CF39
	0x4692, 0x4693, 0x4694, 0x4695, 0x4696, 0x4697, 0x4698, 0x4699, 0x469A, 0x469B, 	// 0x8233D039
	0x469C, 0x469D, 0x469E, 0x469F, 0x46A0, 0x46A1, 0x46A2, 0x46A3, 0x46A4, 0x46A5, 	// 0x8233D139
	0x46A6, 0x46A7, 0x46A8, 0x46A9, 0x46AA, 0x46AB, 0x46AC, 0x46AD, 0x46AE, 0x46AF, 	// 0x8233D239
	0x46B0, 0x46B1, 0x46B2, 0x46B3, 0x46B4, 0x46B5, 0x46B6, 0x46B7, 0x46B8, 0x46B9, 	// 0x8233D339
	0x46BA, 0x46BB, 0x46BC, 0x46BD, 0x46BE, 0x46BF, 0x46C0, 0x46C1, 0x46C2, 0x46C3, 	// 0x8233D439
	0x46C4, 0x46C5, 0x46C6, 0x46C7, 0x46C8, 0x46C9, 0x46CA, 0x46CB, 0x46CC, 0x46CD, 	// 0x8233D539
	0x46CE, 0x46CF, 0x46D0, 0x46D1, 0x46D2, 0x46D3, 0x46D4, 0x46D5, 0x46D6, 0x46D7, 	// 0x8233D639
	0x46D8, 0x46D9, 0x46DA, 0x46DB, 0x46DC, 0x46DD, 0x46DE, 0x46DF, 0x46E0, 0x46E1, 	// 0x8233D739
	0x46E2, 0x46E3, 0x46E4, 0x46E5, 0x46E6, 0x46E7, 0x46E8, 0x46E9, 0x46EA, 0x46EB, 	// 0x8233D839
	0x46EC, 0x46ED, 0x46EE, 0x46EF, 0x46F0, 0x46F1, 0x46F2, 0x46F3, 0x46F4, 0x46F5, 	// 0x8233D939
	0x46F6, 0x46F7, 0x46F8, 0x46F9, 0x46FA, 0x46FB, 0x46FC, 0x46FD, 0x46FE, 0x46FF, 	// 0x8233DA39
	0x4700, 0x4701, 0x4702, 0x4703, 0x4704, 0x4705, 0x4706, 0x4707, 0x4708, 0x4709, 	// 0x8233DB39
	0x470A, 0x470B, 0x470C, 0x470D, 0x470E, 0x470F, 0x4710, 0x4711, 0x4712, 0x4713, 	// 0x8233DC39
	0x4714, 0x4715, 0x4716, 0x4717, 0x4718, 0x4719, 0x471A, 0x471B, 0x471C, 0x471D, 	// 0x8233DD39
	0x471E, 0x471F, 0x4720, 0x4721, 0x4722, 0x4724, 0x4725, 0x4726, 0x4727, 0x4728, 	// 0x8233DE39
	0x472A, 0x472B, 0x472C, 0x472D, 0x472E, 0x472F, 0x4730, 0x4731, 0x4732, 0x4733, 	// 0x8233DF39
	0x4734, 0x4735, 0x4736, 0x4737, 0x4738, 0x4739, 0x473A, 0x473B, 0x473C, 0x473D, 	// 0x8233E039
	0x473E, 0x473F, 0x4740, 0x4741, 0x4742, 0x4743, 0x4744, 0x4745, 0x4746, 0x4747, 	// 0x8233E139
	0x4748, 0x4749, 0x474A, 0x474B, 0x474C, 0x474D, 0x474E, 0x474F, 0x4750, 0x4751, 	// 0x8233E239
	0x4752, 0x4753, 0x4754, 0x4755, 0x4756, 0x4757, 0x4758, 0x4759, 0x475A, 0x475B, 	// 0x8233E339
	0x475C, 0x475D, 0x475E, 0x475F, 0x4760, 0x4761, 0x4762, 0x4763, 0x4764, 0x4765, 	// 0x8233E439
	0x4766, 0x4767, 0x4768, 0x4769, 0x476A, 0x476B, 0x476C, 0x476D, 0x476E, 0x476F, 	// 0x8233E539
	0x4770, 0x4771, 0x4772, 0x4773, 0x4774, 0x4775, 0x4776, 0x4777, 0x4778, 0x4779, 	// 0x8233E639
	0x477A, 0x477B, 0x477D, 0x477E, 0x477F, 0x4780, 0x4781, 0x4782, 0x4783, 0x4784, 	// 0x8233E739
	0x4785, 0x4786, 0x4787, 0x4788, 0x4789, 0x478A, 0x478B, 0x478C, 0x478E, 0x478F, 	// 0x8233E839
	0x4790, 0x4791, 0x4792, 0x4793, 0x4794, 0x4795, 0x4796, 0x4797, 0x4798, 0x4799, 	// 0x8233E939
	0x479A, 0x479B, 0x479C, 0x479D, 0x479E, 0x479F, 0x47A0, 0x47A1, 0x47A2, 0x47A3, 	// 0x8233EA39
	0x47A4, 0x47A5, 0x47A6, 0x47A7, 0x47A8, 0x47A9, 0x47AA, 0x47AB, 0x47AC, 0x47AD, 	// 0x8233EB39
	0x47AE, 0x47AF, 0x47B0, 0x47B1, 0x47B2, 0x47B3, 0x47B4, 0x47B5, 0x47B6, 0x47B7, 	// 0x8233EC39
	0x47B8, 0x47B9, 0x47BA, 0x47BB, 0x47BC, 0x47BD, 0x47BE, 0x47BF, 0x47C0, 0x47C1, 	// 0x8233ED39
	0x47C2, 0x47C3, 0x47C4, 0x47C5, 0x47C6, 0x47C7, 0x47C8, 0x47C9, 0x47CA, 0x47CB, 	// 0x8233EE39
	0x47CC, 0x47CD, 0x47CE, 0x47CF, 0x47D0, 0x47D1, 0x47D2, 0x47D3, 0x47D4, 0x47D5, 	// 0x8233EF39
	0x47D6, 0x47D7, 0x47D8, 0x47D9, 0x47DA, 0x47DB, 0x47DC, 0x47DD, 0x47DE, 0x47DF, 	// 0x8233F039
	0x47E0, 0x47E1, 0x47E2, 0x47E3, 0x47E4, 0x47E5, 0x47E6, 0x47E7, 0x47E8, 0x47E9, 	// 0x8233F139
	0x47EA, 0x47EB, 0x47EC, 0x47ED, 0x47EE, 0x47EF, 0x47F0, 0x47F1, 0x47F2, 0x47F3, 	// 0x8233F239
	0x47F4, 0x47F5, 0x47F6, 0x47F7, 0x47F8, 0x47F9, 0x47FA, 0x47FB, 0x47FC, 0x47FD, 	// 0x8233F339
	0x47FE, 0x47FF, 0x4800, 0x4801, 0x4802, 0x4803, 0x4804, 0x4805, 0x4806, 0x4807, 	// 0x8233F439
	0x4808, 0x4809, 0x480A, 0x480B, 0x480C, 0x480D, 0x480E, 0x480F, 0x4810, 0x4811, 	// 0x8233F539
	0x4812, 0x4813, 0x4814, 0x4815, 0x4816, 0x4817, 0x4818, 0x4819, 0x481A, 0x481B, 	// 0x8233F639
	0x481C, 0x481D, 0x481E, 0x481F, 0x4820, 0x4821, 0x4822, 0x4823, 0x4824, 0x4825, 	// 0x8233F739
	0x4826, 0x4827, 0x4828, 0x4829, 0x482A, 0x482B, 0x482C, 0x482D, 0x482E, 0x482F, 	// 0x8233F839
	0x4830, 0x4831, 0x4832, 0x4833, 0x4834, 0x4835, 0x4836, 0x4837, 0x4838, 0x4839, 	// 0x8233F939
	0x483A, 0x483B, 0x483C, 0x483D, 0x483E, 0x483F, 0x4840, 0x4841, 0x4842, 0x4843, 	// 0x8233FA39
	0x4844, 0x4845, 0x4846, 0x4847, 0x4848, 0x4849, 0x484A, 0x484B, 0x484C, 0x484D, 	// 0x8233FB39
	0x484E, 0x484F, 0x4850, 0x4851, 0x4852, 0x4853, 0x4854, 0x4855, 0x4856, 0x4857, 	// 0x8233FC39
	0x4858, 0x4859, 0x485A, 0x485B, 0x485C, 0x485D, 0x485E, 0x485F, 0x4860, 0x4861, 	// 0x8233FD39
	0x4862, 0x4863, 0x4864, 0x4865, 0x4866, 0x4867, 0x4868, 0x4869, 0x486A, 0x486B, 	// 0x8233FE39
	0x486C, 0x486D, 0x486E, 0x486F, 0x4870, 0x4871, 0x4872, 0x4873, 0x4874, 0x4875, 	// 0x82348139
	0x4876, 0x4877, 0x4878, 0x4879, 0x487A, 0x487B, 0x487C, 0x487D, 0x487E, 0x487F, 	// 0x82348239
	0x4880, 0x4881, 0x4882, 0x4883, 0x4884, 0x4885, 0x4886, 0x4887, 0x4888, 0x4889, 	// 0x82348339
	0x488A, 0x488B, 0x488C, 0x488D, 0x488E, 0x488F, 0x4890, 0x4891, 0x4892, 0x4893, 	// 0x82348439
	0x4894, 0x4895, 0x4896, 0x4897, 0x4898, 0x4899, 0x489A, 0x489B, 0x489C, 0x489D, 	// 0x82348539
	0x489E, 0x489F, 0x48A0, 0x48A1, 0x48A2, 0x48A3, 0x48A4, 0x48A5, 0x48A6, 0x48A7, 	// 0x82348639
	0x48A8, 0x48A9, 0x48AA, 0x48AB, 0x48AC, 0x48AD, 0x48AE, 0x48AF, 0x48B0, 0x48B1, 	// 0x82348739
	0x48B2, 0x48B3, 0x48B4, 0x48B5, 0x48B6, 0x48B7, 0x48B8, 0x48B9, 0x48BA, 0x48BB, 	// 0x82348839
	0x48BC, 0x48BD, 0x48BE, 0x48BF, 0x48C0, 0x48C1, 0x48C2, 0x48C3, 0x48C4, 0x48C5, 	// 0x82348939
	0x48C6, 0x48C7, 0x48C8, 0x48C9, 0x48CA, 0x48CB, 0x48CC, 0x48CD, 0x48CE, 0x48CF, 	// 0x82348A39
	0x48D0, 0x48D1, 0x48D2, 0x48D3, 0x48D4, 0x48D5, 0x48D6, 0x48D7, 0x48D8, 0x48D9, 	// 0x82348B39
	0x48DA, 0x48DB, 0x48DC, 0x48DD, 0x48DE, 0x48DF, 0x48E0, 0x48E1, 0x48E2, 0x48E3, 	// 0x82348C39
	0x48E4, 0x48E5, 0x48E6, 0x48E7, 0x48E8, 0x48E9, 0x48EA, 0x48EB, 0x48EC, 0x48ED, 	// 0x82348D39
	0x48EE, 0x48EF, 0x48F0, 0x48F1, 0x48F2, 0x48F3, 0x48F4, 0x48F5, 0x48F6, 0x48F7, 	// 0x82348E39
	0x48F8, 0x48F9, 0x48FA, 0x48FB, 0x48FC, 0x48FD, 0x48FE, 0x48FF, 0x4900, 0x4901, 	// 0x82348F39
	0x4902, 0x4903, 0x4904, 0x4905, 0x4906, 0x4907, 0x4908, 0x4909, 0x490A, 0x490B, 	// 0x82349039
	0x490C, 0x490D, 0x490E, 0x490F, 0x4910, 0x4911, 0x4912, 0x4913, 0x4914, 0x4915, 	// 0x82349139
	0x4916, 0x4917, 0x4918, 0x4919, 0x491A, 0x491B, 0x491C, 0x491D, 0x491E, 0x491F, 	// 0x82349239
	0x4920, 0x4921, 0x4922, 0x4923, 0x4924, 0x4925, 0x4926, 0x4927, 0x4928, 0x4929, 	// 0x82349339
	0x492A, 0x492B, 0x492C, 0x492D, 0x492E, 0x492F, 0x4930, 0x4931, 0x4932, 0x4933, 	// 0x82349439
	0x4934, 0x4935, 0x4936, 0x4937, 0x4938, 0x4939, 0x493A, 0x493B, 0x493C, 0x493D, 	// 0x82349539
	0x493E, 0x493F, 0x4940, 0x4941, 0x4942, 0x4943, 0x4944, 0x4945, 0x4946, 0x4948, 	// 0x82349639
	0x4949, 0x494A, 0x494B, 0x494C, 0x494D, 0x494E, 0x494F, 0x4950, 0x4951, 0x4952, 	// 0x82349739
	0x4953, 0x4954, 0x4955, 0x4956, 0x4957, 0x4958, 0x4959, 0x495A, 0x495B, 0x495C, 	// 0x82349839
	0x495D, 0x495E, 0x495F, 0x4960, 0x4961, 0x4962, 0x4963, 0x4964, 0x4965, 0x4966, 	// 0x82349939
	0x4967, 0x4968, 0x4969, 0x496A, 0x496B, 0x496C, 0x496D, 0x496E, 0x496F, 0x4970, 	// 0x82349A39
	0x4971, 0x4972, 0x4973, 0x4974, 0x4975, 0x4976, 0x4977, 0x4978, 0x4979, 0x497B, 	// 0x82349B39
	0x497C, 0x497E, 0x497F, 0x4980, 0x4981, 0x4984, 0x4987, 0x4988, 0x4989, 0x498A, 	// 0x82349C39
	0x498B, 0x498C, 0x498D, 0x498E, 0x498F, 0x4990, 0x4991, 0x4992, 0x4993, 0x4994, 	// 0x82349D39
	0x4995, 0x4996, 0x4997, 0x4998, 0x4999, 0x499A, 0x499C, 0x499D, 0x499E, 0x49A0, 	// 0x82349E39
	0x49A1, 0x49A2, 0x49A3, 0x49A4, 0x49A5, 0x49A6, 0x49A7, 0x49A8, 0x49A9, 0x49AA, 	// 0x82349F39
	0x49AB, 0x49AC, 0x49AD, 0x49AE, 0x49AF, 0x49B0, 0x49B1, 0x49B2, 0x49B3, 0x49B4, 	// 0x8234A039
	0x49B5, 0x49B8, 0x49B9, 0x49BA, 0x49BB, 0x49BC, 0x49BD, 0x49BE, 0x49BF, 0x49C0, 	// 0x8234A139
	0x49C1, 0x49C2, 0x49C3, 0x49C4, 0x49C5, 0x49C6, 0x49C7, 0x49C8, 0x49C9, 0x49CA, 	// 0x8234A239
	0x49CB, 0x49CC, 0x49CD, 0x49CE, 0x49CF, 0x49D0, 0x49D1, 0x49D2, 0x49D3, 0x49D4, 	// 0x8234A339
	0x49D5, 0x49D6, 0x49D7, 0x49D8, 0x49D9, 0x49DA, 0x49DB, 0x49DC, 0x49DD, 0x49DE, 	// 0x8234A439
	0x49DF, 0x49E0, 0x49E1, 0x49E2, 0x49E3, 0x49E4, 0x49E5, 0x49E6, 0x49E7, 0x49E8, 	// 0x8234A539
	0x49E9, 0x49EA, 0x49EB, 0x49EC, 0x49ED, 0x49EE, 0x49EF, 0x49F0, 0x49F1, 0x49F2, 	// 0x8234A639
	0x49F3, 0x49F4, 0x49F5, 0x49F6, 0x49F7, 0x49F8, 0x49F9, 0x49FA, 0x49FB, 0x49FC, 	// 0x8234A739
	0x49FD, 0x49FE, 0x49FF, 0x4A00, 0x4A01, 0x4A02, 0x4A03, 0x4A04, 0x4A05, 0x4A06, 	// 0x8234A839
	0x4A07, 0x4A08, 0x4A09, 0x4A0A, 0x4A0B, 0x4A0C, 0x4A0D, 0x4A0E, 0x4A0F, 0x4A10, 	// 0x8234A939
	0x4A11, 0x4A12, 0x4A13, 0x4A14, 0x4A15, 0x4A16, 0x4A17, 0x4A18, 0x4A19, 0x4A1A, 	// 0x8234AA39
	0x4A1B, 0x4A1C, 0x4A1D, 0x4A1E, 0x4A1F, 0x4A20, 0x4A21, 0x4A22, 0x4A23, 0x4A24, 	// 0x8234AB39
	0x4A25, 0x4A26, 0x4A27, 0x4A28, 0x4A29, 0x4A2A, 0x4A2B, 0x4A2C, 0x4A2D, 0x4A2E, 	// 0x8234AC39
	0x4A2F, 0x4A30, 0x4A31, 0x4A32, 0x4A33, 0x4A34, 0x4A35, 0x4A36, 0x4A37, 0x4A38, 	// 0x8234AD39
	0x4A39, 0x4A3A, 0x4A3B, 0x4A3C, 0x4A3D, 0x4A3E, 0x4A3F, 0x4A40, 0x4A41, 0x4A42, 	// 0x8234AE39
	0x4A43, 0x4A44, 0x4A45, 0x4A46, 0x4A47, 0x4A48, 0x4A49, 0x4A4A, 0x4A4B, 0x4A4C, 	// 0x8234AF39
	0x4A4D, 0x4A4E, 0x4A4F, 0x4A50, 0x4A51, 0x4A52, 0x4A53, 0x4A54, 0x4A55, 0x4A56, 	// 0x8234B039
	0x4A57, 0x4A58, 0x4A59, 0x4A5A, 0x4A5B, 0x4A5C, 0x4A5D, 0x4A5E, 0x4A5F, 0x4A60, 	// 0x8234B139
	0x4A61, 0x4A62, 0x4A63, 0x4A64, 0x4A65, 0x4A66, 0x4A67, 0x4A68, 0x4A69, 0x4A6A, 	// 0x8234B239
	0x4A6B, 0x4A6C, 0x4A6D, 0x4A6E, 0x4A6F, 0x4A70, 0x4A71, 0x4A72, 0x4A73, 0x4A74, 	// 0x8234B339
	0x4A75, 0x4A76, 0x4A77, 0x4A78, 0x4A79, 0x4A7A, 0x4A7B, 0x4A7C, 0x4A7D, 0x4A7E, 	// 0x8234B439
	0x4A7F, 0x4A80, 0x4A81, 0x4A82, 0x4A83, 0x4A84, 0x4A85, 0x4A86, 0x4A87, 0x4A88, 	// 0x8234B539
	0x4A89, 0x4A8A, 0x4A8B, 0x4A8C, 0x4A8D, 0x4A8E, 0x4A8F, 0x4A90, 0x4A91, 0x4A92, 	// 0x8234B639
	0x4A93, 0x4A94, 0x4A95, 0x4A96, 0x4A97, 0x4A98, 0x4A99, 0x4A9A, 0x4A9B, 0x4A9C, 	// 0x8234B739
	0x4A9D, 0x4A9E, 0x4A9F, 0x4AA0, 0x4AA1, 0x4AA2, 0x4AA3, 0x4AA4, 0x4AA5, 0x4AA6, 	// 0x8234B839
	0x4AA7, 0x4AA8, 0x4AA9, 0x4AAA, 0x4AAB, 0x4AAC, 0x4AAD, 0x4AAE, 0x4AAF, 0x4AB0, 	// 0x8234B939
	0x4AB1, 0x4AB2, 0x4AB3, 0x4AB4, 0x4AB5, 0x4AB6, 0x4AB7, 0x4AB8, 0x4AB9, 0x4ABA, 	// 0x8234BA39
	0x4ABB, 0x4ABC, 0x4ABD, 0x4ABE, 0x4ABF, 0x4AC0, 0x4AC1, 0x4AC2, 0x4AC3, 0x4AC4, 	// 0x8234BB39
	0x4AC5, 0x4AC6, 0x4AC7, 0x4AC8, 0x4AC9, 0x4ACA, 0x4ACB, 0x4ACC, 0x4ACD, 0x4ACE, 	// 0x8234BC39
	0x4ACF, 0x4AD0, 0x4AD1, 0x4AD2, 0x4AD3, 0x4AD4, 0x4AD5, 0x4AD6, 0x4AD7, 0x4AD8, 	// 0x8234BD39
	0x4AD9, 0x4ADA, 0x4ADB, 0x4ADC, 0x4ADD, 0x4ADE, 0x4ADF, 0x4AE0, 0x4AE1, 0x4AE2, 	// 0x8234BE39
	0x4AE3, 0x4AE4, 0x4AE5, 0x4AE6, 0x4AE7, 0x4AE8, 0x4AE9, 0x4AEA, 0x4AEB, 0x4AEC, 	// 0x8234BF39
	0x4AED, 0x4AEE, 0x4AEF, 0x4AF0, 0x4AF1, 0x4AF2, 0x4AF3, 0x4AF4, 0x4AF5, 0x4AF6, 	// 0x8234C039
	0x4AF7, 0x4AF8, 0x4AF9, 0x4AFA, 0x4AFB, 0x4AFC, 0x4AFD, 0x4AFE, 0x4AFF, 0x4B00, 	// 0x8234C139
	0x4B01, 0x4B02, 0x4B03, 0x4B04, 0x4B05, 0x4B06, 0x4B07, 0x4B08, 0x4B09, 0x4B0A, 	// 0x8234C239
	0x4B0B, 0x4B0C, 0x4B0D, 0x4B0E, 0x4B0F, 0x4B10, 0x4B11, 0x4B12, 0x4B13, 0x4B14, 	// 0x8234C339
	0x4B15, 0x4B16, 0x4B17, 0x4B18, 0x4B19, 0x4B1A, 0x4B1B, 0x4B1C, 0x4B1D, 0x4B1E, 	// 0x8234C439
	0x4B1F, 0x4B20, 0x4B21, 0x4B22, 0x4B23, 0x4B24, 0x4B25, 0x4B26, 0x4B27, 0x4B28, 	// 0x8234C539
	0x4B29, 0x4B2A, 0x4B2B, 0x4B2C, 0x4B2D, 0x4B2E, 0x4B2F, 0x4B30, 0x4B31, 0x4B32, 	// 0x8234C639
	0x4B33, 0x4B34, 0x4B35, 0x4B36, 0x4B37, 0x4B38, 0x4B39, 0x4B3A, 0x4B3B, 0x4B3C, 	// 0x8234C739
	0x4B3D, 0x4B3E, 0x4B3F, 0x4B40, 0x4B41, 0x4B42, 0x4B43, 0x4B44, 0x4B45, 0x4B46, 	// 0x8234C839
	0x4B47, 0x4B48, 0x4B49, 0x4B4A, 0x4B4B, 0x4B4C, 0x4B4D, 0x4B4E, 0x4B4F, 0x4B50, 	// 0x8234C939
	0x4B51, 0x4B52, 0x4B53, 0x4B54, 0x4B55, 0x4B56, 0x4B57, 0x4B58, 0x4B59, 0x4B5A, 	// 0x8234CA39
	0x4B5B, 0x4B5C, 0x4B5D, 0x4B5E, 0x4B5F, 0x4B60, 0x4B61, 0x4B62, 0x4B63, 0x4B64, 	// 0x8234CB39
	0x4B65, 0x4B66, 0x4B67, 0x4B68, 0x4B69, 0x4B6A, 0x4B6B, 0x4B6C, 0x4B6D, 0x4B6E, 	// 0x8234CC39
	0x4B6F, 0x4B70, 0x4B71, 0x4B72, 0x4B73, 0x4B74, 0x4B75, 0x4B76, 0x4B77, 0x4B78, 	// 0x8234CD39
	0x4B79, 0x4B7A, 0x4B7B, 0x4B7C, 0x4B7D, 0x4B7E, 0x4B7F, 0x4B80, 0x4B81, 0x4B82, 	// 0x8234CE39
	0x4B83, 0x4B84, 0x4B85, 0x4B86, 0x4B87, 0x4B88, 0x4B89, 0x4B8A, 0x4B8B, 0x4B8C, 	// 0x8234CF39
	0x4B8D, 0x4B8E, 0x4B8F, 0x4B90, 0x4B91, 0x4B92, 0x4B93, 0x4B94, 0x4B95, 0x4B96, 	// 0x8234D039
	0x4B97, 0x4B98, 0x4B99, 0x4B9A, 0x4B9B, 0x4B9C, 0x4B9D, 0x4B9E, 0x4B9F, 0x4BA0, 	// 0x8234D139
	0x4BA1, 0x4BA2, 0x4BA3, 0x4BA4, 0x4BA5, 0x4BA6, 0x4BA7, 0x4BA8, 0x4BA9, 0x4BAA, 	// 0x8234D239
	0x4BAB, 0x4BAC, 0x4BAD, 0x4BAE, 0x4BAF, 0x4BB0, 0x4BB1, 0x4BB2, 0x4BB3, 0x4BB4, 	// 0x8234D339
	0x4BB5, 0x4BB6, 0x4BB7, 0x4BB8, 0x4BB9, 0x4BBA, 0x4BBB, 0x4BBC, 0x4BBD, 0x4BBE, 	// 0x8234D439
	0x4BBF, 0x4BC0, 0x4BC1, 0x4BC2, 0x4BC3, 0x4BC4, 0x4BC5, 0x4BC6, 0x4BC7, 0x4BC8, 	// 0x8234D539
	0x4BC9, 0x4BCA, 0x4BCB, 0x4BCC, 0x4BCD, 0x4BCE, 0x4BCF, 0x4BD0, 0x4BD1, 0x4BD2, 	// 0x8234D639
	0x4BD3, 0x4BD4, 0x4BD5, 0x4BD6, 0x4BD7, 0x4BD8, 0x4BD9, 0x4BDA, 0x4BDB, 0x4BDC, 	// 0x8234D739
	0x4BDD, 0x4BDE, 0x4BDF, 0x4BE0, 0x4BE1, 0x4BE2, 0x4BE3, 0x4BE4, 0x4BE5, 0x4BE6, 	// 0x8234D839
	0x4BE7, 0x4BE8, 0x4BE9, 0x4BEA, 0x4BEB, 0x4BEC, 0x4BED, 0x4BEE, 0x4BEF, 0x4BF0, 	// 0x8234D939
	0x4BF1, 0x4BF2, 0x4BF3, 0x4BF4, 0x4BF5, 0x4BF6, 0x4BF7, 0x4BF8, 0x4BF9, 0x4BFA, 	// 0x8234DA39
	0x4BFB, 0x4BFC, 0x4BFD, 0x4BFE, 0x4BFF, 0x4C00, 0x4C01, 0x4C02, 0x4C03, 0x4C04, 	// 0x8234DB39
	0x4C05, 0x4C06, 0x4C07, 0x4C08, 0x4C09, 0x4C0A, 0x4C0B, 0x4C0C, 0x4C0D, 0x4C0E, 	// 0x8234DC39
	0x4C0F, 0x4C10, 0x4C11, 0x4C12, 0x4C13, 0x4C14, 0x4C15, 0x4C16, 0x4C17, 0x4C18, 	// 0x8234DD39
	0x4C19, 0x4C1A, 0x4C1B, 0x4C1C, 0x4C1D, 0x4C1E, 0x4C1F, 0x4C20, 0x4C21, 0x4C22, 	// 0x8234DE39
	0x4C23, 0x4C24, 0x4C25, 0x4C26, 0x4C27, 0x4C28, 0x4C29, 0x4C2A, 0x4C2B, 0x4C2C, 	// 0x8234DF39
	0x4C2D, 0x4C2E, 0x4C2F, 0x4C30, 0x4C31, 0x4C32, 0x4C33, 0x4C34, 0x4C35, 0x4C36, 	// 0x8234E039
	0x4C37, 0x4C38, 0x4C39, 0x4C3A, 0x4C3B, 0x4C3C, 0x4C3D, 0x4C3E, 0x4C3F, 0x4C40, 	// 0x8234E139
	0x4C41, 0x4C42, 0x4C43, 0x4C44, 0x4C45, 0x4C46, 0x4C47, 0x4C48, 0x4C49, 0x4C4A, 	// 0x8234E239
	0x4C4B, 0x4C4C, 0x4C4D, 0x4C4E, 0x4C4F, 0x4C50, 0x4C51, 0x4C52, 0x4C53, 0x4C54, 	// 0x8234E339
	0x4C55, 0x4C56, 0x4C57, 0x4C58, 0x4C59, 0x4C5A, 0x4C5B, 0x4C5C, 0x4C5D, 0x4C5E, 	// 0x8234E439
	0x4C5F, 0x4C60, 0x4C61, 0x4C62, 0x4C63, 0x4C64, 0x4C65, 0x4C66, 0x4C67, 0x4C68, 	// 0x8234E539
	0x4C69, 0x4C6A, 0x4C6B, 0x4C6C, 0x4C6D, 0x4C6E, 0x4C6F, 0x4C70, 0x4C71, 0x4C72, 	// 0x8234E639
	0x4C73, 0x4C74, 0x4C75, 0x4C76, 0x4C78, 0x4C79, 0x4C7A, 0x4C7B, 0x4C7C, 0x4C7D, 	// 0x8234E739
	0x4C7E, 0x4C7F, 0x4C80, 0x4C81, 0x4C82, 0x4C83, 0x4C84, 0x4C85, 0x4C86, 0x4C87, 	// 0x8234E839
	0x4C88, 0x4C89, 0x4C8A, 0x4C8B, 0x4C8C, 0x4C8D, 0x4C8E, 0x4C8F, 0x4C90, 0x4C91, 	// 0x8234E939
	0x4C92, 0x4C93, 0x4C94, 0x4C95, 0x4C96, 0x4C97, 0x4C98, 0x4C99, 0x4C9A, 0x4C9B, 	// 0x8234EA39
	0x4C9C, 0x4C9D, 0x4C9E, 0x4CA4, 0x4CA5, 0x4CA6, 0x4CA7, 0x4CA8, 0x4CA9, 0x4CAA, 	// 0x8234EB39
	0x4CAB, 0x4CAC, 0x4CAD, 0x4CAE, 0x4CAF, 0x4CB0, 0x4CB1, 0x4CB2, 0x4CB3, 0x4CB4, 	// 0x8234EC39
	0x4CB5, 0x4CB6, 0x4CB7, 0x4CB8, 0x4CB9, 0x4CBA, 0x4CBB, 0x4CBC, 0x4CBD, 0x4CBE, 	// 0x8234ED39
	0x4CBF, 0x4CC0, 0x4CC1, 0x4CC2, 0x4CC3, 0x4CC4, 0x4CC5, 0x4CC6, 0x4CC7, 0x4CC8, 	// 0x8234EE39
	0x4CC9, 0x4CCA, 0x4CCB, 0x4CCC, 0x4CCD, 0x4CCE, 0x4CCF, 0x4CD0, 0x4CD1, 0x4CD2, 	// 0x8234EF39
	0x4CD3, 0x4CD4, 0x4CD5, 0x4CD6, 0x4CD7, 0x4CD8, 0x4CD9, 0x4CDA, 0x4CDB, 0x4CDC, 	// 0x8234F039
	0x4CDD, 0x4CDE, 0x4CDF, 0x4CE0, 0x4CE1, 0x4CE2, 0x4CE3, 0x4CE4, 0x4CE5, 0x4CE6, 	// 0x8234F139
	0x4CE7, 0x4CE8, 0x4CE9, 0x4CEA, 0x4CEB, 0x4CEC, 0x4CED, 0x4CEE, 0x4CEF, 0x4CF0, 	// 0x8234F239
	0x4CF1, 0x4CF2, 0x4CF3, 0x4CF4, 0x4CF5, 0x4CF6, 0x4CF7, 0x4CF8, 0x4CF9, 0x4CFA, 	// 0x8234F339
	0x4CFB, 0x4CFC, 0x4CFD, 0x4CFE, 0x4CFF, 0x4D00, 0x4D01, 0x4D02, 0x4D03, 0x4D04, 	// 0x8234F439
	0x4D05, 0x4D06, 0x4D07, 0x4D08, 0x4D09, 0x4D0A, 0x4D0B, 0x4D0C, 0x4D0D, 0x4D0E, 	// 0x8234F539
	0x4D0F, 0x4D10, 0x4D11, 0x4D12, 0x4D1A, 0x4D1B, 0x4D1C, 0x4D1D, 0x4D1E, 0x4D1F, 	// 0x8234F639
	0x4D20, 0x4D21, 0x4D22, 0x4D23, 0x4D24, 0x4D25, 0x4D26, 0x4D27, 0x4D28, 0x4D29, 	// 0x8234F739
	0x4D2A, 0x4D2B, 0x4D2C, 0x4D2D, 0x4D2E, 0x4D2F, 0x4D30, 0x4D31, 0x4D32, 0x4D33, 	// 0x8234F839
	0x4D34, 0x4D35, 0x4D36, 0x4D37, 0x4D38, 0x4D39, 0x4D3A, 0x4D3B, 0x4D3C, 0x4D3D, 	// 0x8234F939
	0x4D3E, 0x4D3F, 0x4D40, 0x4D41, 0x4D42, 0x4D43, 0x4D44, 0x4D45, 0x4D46, 0x4D47, 	// 0x8234FA39
	0x4D48, 0x4D49, 0x4D4A, 0x4D4B, 0x4D4C, 0x4D4D, 0x4D4E, 0x4D4F, 0x4D50, 0x4D51, 	// 0x8234FB39
	0x4D52, 0x4D53, 0x4D54, 0x4D55, 0x4D56, 0x4D57, 0x4D58, 0x4D59, 0x4D5A, 0x4D5B, 	// 0x8234FC39
	0x4D5C, 0x4D5D, 0x4D5E, 0x4D5F, 0x4D60, 0x4D61, 0x4D62, 0x4D63, 0x4D64, 0x4D65, 	// 0x8234FD39
	0x4D66, 0x4D67, 0x4D68, 0x4D69, 0x4D6A, 0x4D6B, 0x4D6C, 0x4D6D, 0x4D6E, 0x4D6F, 	// 0x8234FE39
	0x4D70, 0x4D71, 0x4D72, 0x4D73, 0x4D74, 0x4D75, 0x4D76, 0x4D77, 0x4D78, 0x4D79, 	// 0x82358139
	0x4D7A, 0x4D7B, 0x4D7C, 0x4D7D, 0x4D7E, 0x4D7F, 0x4D80, 0x4D81, 0x4D82, 0x4D83, 	// 0x82358239
	0x4D84, 0x4D85, 0x4D86, 0x4D87, 0x4D88, 0x4D89, 0x4D8A, 0x4D8B, 0x4D8C, 0x4D8D, 	// 0x82358339
	0x4D8E, 0x4D8F, 0x4D90, 0x4D91, 0x4D92, 0x4D93, 0x4D94, 0x4D95, 0x4D96, 0x4D97, 	// 0x82358439
	0x4D98, 0x4D99, 0x4D9A, 0x4D9B, 0x4D9C, 0x4D9D, 0x4D9E, 0x4D9F, 0x4DA0, 0x4DA1, 	// 0x82358539
	0x4DA2, 0x4DA3, 0x4DA4, 0x4DA5, 0x4DA6, 0x4DA7, 0x4DA8, 0x4DA9, 0x4DAA, 0x4DAB, 	// 0x82358639
	0x4DAC, 0x4DAD, 0x4DAF, 0x4DB0, 0x4DB1, 0x4DB2, 0x4DB3, 0x4DB4, 0x4DB5, 0x4DB6, 	// 0x82358739
	0x4DB7, 0x4DB8, 0x4DB9, 0x4DBA, 0x4DBB, 0x4DBC, 0x4DBD, 0x4DBE, 0x4DBF, 0x4DC0, 	// 0x82358839
	0x4DC1, 0x4DC2, 0x4DC3, 0x4DC4, 0x4DC5, 0x4DC6, 0x4DC7, 0x4DC8, 0x4DC9, 0x4DCA, 	// 0x82358939
	0x4DCB, 0x4DCC, 0x4DCD, 0x4DCE, 0x4DCF, 0x4DD0, 0x4DD1, 0x4DD2, 0x4DD3, 0x4DD4, 	// 0x82358A39
	0x4DD5, 0x4DD6, 0x4DD7, 0x4DD8, 0x4DD9, 0x4DDA, 0x4DDB, 0x4DDC, 0x4DDD, 0x4DDE, 	// 0x82358B39
	0x4DDF, 0x4DE0, 0x4DE1, 0x4DE2, 0x4DE3, 0x4DE4, 0x4DE5, 0x4DE6, 0x4DE7, 0x4DE8, 	// 0x82358C39
	0x4DE9, 0x4DEA, 0x4DEB, 0x4DEC, 0x4DED, 0x4DEE, 0x4DEF, 0x4DF0, 0x4DF1, 0x4DF2, 	// 0x82358D39
	0x4DF3, 0x4DF4, 0x4DF5, 0x4DF6, 0x4DF7, 0x4DF8, 0x4DF9, 0x4DFA, 0x4DFB, 0x4DFC, 	// 0x82358E39
	0x4DFD, 0x4DFE, 0x4DFF, 0x9FA6, 0x9FA7, 0x9FA8, 0x9FA9, 0x9FAA, 0x9FAB, 0x9FAC, 	// 0x82358F39
	0x9FAD, 0x9FAE, 0x9FAF, 0x9FB0, 0x9FB1, 0x9FB2, 0x9FB3, 0x9FB4, 0x9FB5, 0x9FB6, 	// 0x82359039
	0x9FB7, 0x9FB8, 0x9FB9, 0x9FBA, 0x9FBB, 0x9FBC, 0x9FBD, 0x9FBE, 0x9FBF, 0x9FC0, 	// 0x82359139
	0x9FC1, 0x9FC2, 0x9FC3, 0x9FC4, 0x9FC5, 0x9FC6, 0x9FC7, 0x9FC8, 0x9FC9, 0x9FCA, 	// 0x82359239
	0x9FCB, 0x9FCC, 0x9FCD, 0x9FCE, 0x9FCF, 0x9FD0, 0x9FD1, 0x9FD2, 0x9FD3, 0x9FD4, 	// 0x82359339
	0x9FD5, 0x9FD6, 0x9FD7, 0x9FD8, 0x9FD9, 0x9FDA, 0x9FDB, 0x9FDC, 0x9FDD, 0x9FDE, 	// 0x82359439
	0x9FDF, 0x9FE0, 0x9FE1, 0x9FE2, 0x9FE3, 0x9FE4, 0x9FE5, 0x9FE6, 0x9FE7, 0x9FE8, 	// 0x82359539
	0x9FE9, 0x9FEA, 0x9FEB, 0x9FEC, 0x9FED, 0x9FEE, 0x9FEF, 0x9FF0, 0x9FF1, 0x9FF2, 	// 0x82359639
	0x9FF3, 0x9FF4, 0x9FF5, 0x9FF6, 0x9FF7, 0x9FF8, 0x9FF9, 0x9FFA, 0x9FFB, 0x9FFC, 	// 0x82359739
	0x9FFD, 0x9FFE, 0x9FFF, 0xA000, 0xA001, 0xA002, 0xA003, 0xA004, 0xA005, 0xA006, 	// 0x82359839
	0xA007, 0xA008, 0xA009, 0xA00A, 0xA00B, 0xA00C, 0xA00D, 0xA00E, 0xA00F, 0xA010, 	// 0x82359939
	0xA011, 0xA012, 0xA013, 0xA014, 0xA015, 0xA016, 0xA017, 0xA018, 0xA019, 0xA01A, 	// 0x82359A39
	0xA01B, 0xA01C, 0xA01D, 0xA01E, 0xA01F, 0xA020, 0xA021, 0xA022, 0xA023, 0xA024, 	// 0x82359B39
	0xA025, 0xA026, 0xA027, 0xA028, 0xA029, 0xA02A, 0xA02B, 0xA02C, 0xA02D, 0xA02E, 	// 0x82359C39
	0xA02F, 0xA030, 0xA031, 0xA032, 0xA033, 0xA034, 0xA035, 0xA036, 0xA037, 0xA038, 	// 0x82359D39
	0xA039, 0xA03A, 0xA03B, 0xA03C, 0xA03D, 0xA03E, 0xA03F, 0xA040, 0xA041, 0xA042, 	// 0x82359E39
	0xA043, 0xA044, 0xA045, 0xA046, 0xA047, 0xA048, 0xA049, 0xA04A, 0xA04B, 0xA04C, 	// 0x82359F39
	0xA04D, 0xA04E, 0xA04F, 0xA050, 0xA051, 0xA052, 0xA053, 0xA054, 0xA055, 0xA056, 	// 0x8235A039
	0xA057, 0xA058, 0xA059, 0xA05A, 0xA05B, 0xA05C, 0xA05D, 0xA05E, 0xA05F, 0xA060, 	// 0x8235A139
	0xA061, 0xA062, 0xA063, 0xA064, 0xA065, 0xA066, 0xA067, 0xA068, 0xA069, 0xA06A, 	// 0x8235A239
	0xA06B, 0xA06C, 0xA06D, 0xA06E, 0xA06F, 0xA070, 0xA071, 0xA072, 0xA073, 0xA074, 	// 0x8235A339
	0xA075, 0xA076, 0xA077, 0xA078, 0xA079, 0xA07A, 0xA07B, 0xA07C, 0xA07D, 0xA07E, 	// 0x8235A439
	0xA07F, 0xA080, 0xA081, 0xA082, 0xA083, 0xA084, 0xA085, 0xA086, 0xA087, 0xA088, 	// 0x8235A539
	0xA089, 0xA08A, 0xA08B, 0xA08C, 0xA08D, 0xA08E, 0xA08F, 0xA090, 0xA091, 0xA092, 	// 0x8235A639
	0xA093, 0xA094, 0xA095, 0xA096, 0xA097, 0xA098, 0xA099, 0xA09A, 0xA09B, 0xA09C, 	// 0x8235A739
	0xA09D, 0xA09E, 0xA09F, 0xA0A0, 0xA0A1, 0xA0A2, 0xA0A3, 0xA0A4, 0xA0A5, 0xA0A6, 	// 0x8235A839
	0xA0A7, 0xA0A8, 0xA0A9, 0xA0AA, 0xA0AB, 0xA0AC, 0xA0AD, 0xA0AE, 0xA0AF, 0xA0B0, 	// 0x8235A939
	0xA0B1, 0xA0B2, 0xA0B3, 0xA0B4, 0xA0B5, 0xA0B6, 0xA0B7, 0xA0B8, 0xA0B9, 0xA0BA, 	// 0x8235AA39
	0xA0BB, 0xA0BC, 0xA0BD, 0xA0BE, 0xA0BF, 0xA0C0, 0xA0C1, 0xA0C2, 0xA0C3, 0xA0C4, 	// 0x8235AB39
	0xA0C5, 0xA0C6, 0xA0C7, 0xA0C8, 0xA0C9, 0xA0CA, 0xA0CB, 0xA0CC, 0xA0CD, 0xA0CE, 	// 0x8235AC39
	0xA0CF, 0xA0D0, 0xA0D1, 0xA0D2, 0xA0D3, 0xA0D4, 0xA0D5, 0xA0D6, 0xA0D7, 0xA0D8, 	// 0x8235AD39
	0xA0D9, 0xA0DA, 0xA0DB, 0xA0DC, 0xA0DD, 0xA0DE, 0xA0DF, 0xA0E0, 0xA0E1, 0xA0E2, 	// 0x8235AE39
	0xA0E3, 0xA0E4, 0xA0E5, 0xA0E6, 0xA0E7, 0xA0E8, 0xA0E9, 0xA0EA, 0xA0EB, 0xA0EC, 	// 0x8235AF39
	0xA0ED, 0xA0EE, 0xA0EF, 0xA0F0, 0xA0F1, 0xA0F2, 0xA0F3, 0xA0F4, 0xA0F5, 0xA0F6, 	// 0x8235B039
	0xA0F7, 0xA0F8, 0xA0F9, 0xA0FA, 0xA0FB, 0xA0FC, 0xA0FD, 0xA0FE, 0xA0FF, 0xA100, 	// 0x8235B139
	0xA101, 0xA102, 0xA103, 0xA104, 0xA105, 0xA106, 0xA107, 0xA108, 0xA109, 0xA10A, 	// 0x8235B239
	0xA10B, 0xA10C, 0xA10D, 0xA10E, 0xA10F, 0xA110, 0xA111, 0xA112, 0xA113, 0xA114, 	// 0x8235B339
	0xA115, 0xA116, 0xA117, 0xA118, 0xA119, 0xA11A, 0xA11B, 0xA11C, 0xA11D, 0xA11E, 	// 0x8235B439
	0xA11F, 0xA120, 0xA121, 0xA122, 0xA123, 0xA124, 0xA125, 0xA126, 0xA127, 0xA128, 	// 0x8235B539
	0xA129, 0xA12A, 0xA12B, 0xA12C, 0xA12D, 0xA12E, 0xA12F, 0xA130, 0xA131, 0xA132, 	// 0x8235B639
	0xA133, 0xA134, 0xA135, 0xA136, 0xA137, 0xA138, 0xA139, 0xA13A, 0xA13B, 0xA13C, 	// 0x8235B739
	0xA13D, 0xA13E, 0xA13F, 0xA140, 0xA141, 0xA142, 0xA143, 0xA144, 0xA145, 0xA146, 	// 0x8235B839
	0xA147, 0xA148, 0xA149, 0xA14A, 0xA14B, 0xA14C, 0xA14D, 0xA14E, 0xA14F, 0xA150, 	// 0x8235B939
	0xA151, 0xA152, 0xA153, 0xA154, 0xA155, 0xA156, 0xA157, 0xA158, 0xA159, 0xA15A, 	// 0x8235BA39
	0xA15B, 0xA15C, 0xA15D, 0xA15E, 0xA15F, 0xA160, 0xA161, 0xA162, 0xA163, 0xA164, 	// 0x8235BB39
	0xA165, 0xA166, 0xA167, 0xA168, 0xA169, 0xA16A, 0xA16B, 0xA16C, 0xA16D, 0xA16E, 	// 0x8235BC39
	0xA16F, 0xA170, 0xA171, 0xA172, 0xA173, 0xA174, 0xA175, 0xA176, 0xA177, 0xA178, 	// 0x8235BD39
	0xA179, 0xA17A, 0xA17B, 0xA17C, 0xA17D, 0xA17E, 0xA17F, 0xA180, 0xA181, 0xA182, 	// 0x8235BE39
	0xA183, 0xA184, 0xA185, 0xA186, 0xA187, 0xA188, 0xA189, 0xA18A, 0xA18B, 0xA18C, 	// 0x8235BF39
	0xA18D, 0xA18E, 0xA18F, 0xA190, 0xA191, 0xA192, 0xA193, 0xA194, 0xA195, 0xA196, 	// 0x8235C039
	0xA197, 0xA198, 0xA199, 0xA19A, 0xA19B, 0xA19C, 0xA19D, 0xA19E, 0xA19F, 0xA1A0, 	// 0x8235C139
	0xA1A1, 0xA1A2, 0xA1A3, 0xA1A4, 0xA1A5, 0xA1A6, 0xA1A7, 0xA1A8, 0xA1A9, 0xA1AA, 	// 0x8235C239
	0xA1AB, 0xA1AC, 0xA1AD, 0xA1AE, 0xA1AF, 0xA1B0, 0xA1B1, 0xA1B2, 0xA1B3, 0xA1B4, 	// 0x8235C339
	0xA1B5, 0xA1B6, 0xA1B7, 0xA1B8, 0xA1B9, 0xA1BA, 0xA1BB, 0xA1BC, 0xA1BD, 0xA1BE, 	// 0x8235C439
	0xA1BF, 0xA1C0, 0xA1C1, 0xA1C2, 0xA1C3, 0xA1C4, 0xA1C5, 0xA1C6, 0xA1C7, 0xA1C8, 	// 0x8235C539
	0xA1C9, 0xA1CA, 0xA1CB, 0xA1CC, 0xA1CD, 0xA1CE, 0xA1CF, 0xA1D0, 0xA1D1, 0xA1D2, 	// 0x8235C639
	0xA1D3, 0xA1D4, 0xA1D5, 0xA1D6, 0xA1D7, 0xA1D8, 0xA1D9, 0xA1DA, 0xA1DB, 0xA1DC, 	// 0x8235C739
	0xA1DD, 0xA1DE, 0xA1DF, 0xA1E0, 0xA1E1, 0xA1E2, 0xA1E3, 0xA1E4, 0xA1E5, 0xA1E6, 	// 0x8235C839
	0xA1E7, 0xA1E8, 0xA1E9, 0xA1EA, 0xA1EB, 0xA1EC, 0xA1ED, 0xA1EE, 0xA1EF, 0xA1F0, 	// 0x8235C939
	0xA1F1, 0xA1F2, 0xA1F3, 0xA1F4, 0xA1F5, 0xA1F6, 0xA1F7, 0xA1F8, 0xA1F9, 0xA1FA, 	// 0x8235CA39
	0xA1FB, 0xA1FC, 0xA1FD, 0xA1FE, 0xA1FF, 0xA200, 0xA201, 0xA202, 0xA203, 0xA204, 	// 0x8235CB39
	0xA205, 0xA206, 0xA207, 0xA208, 0xA209, 0xA20A, 0xA20B, 0xA20C, 0xA20D, 0xA20E, 	// 0x8235CC39
	0xA20F, 0xA210, 0xA211, 0xA212, 0xA213, 0xA214, 0xA215, 0xA216, 0xA217, 0xA218, 	// 0x8235CD39
	0xA219, 0xA21A, 0xA21B, 0xA21C, 0xA21D, 0xA21E, 0xA21F, 0xA220, 0xA221, 0xA222, 	// 0x8235CE39
	0xA223, 0xA224, 0xA225, 0xA226, 0xA227, 0xA228, 0xA229, 0xA22A, 0xA22B, 0xA22C, 	// 0x8235CF39
	0xA22D, 0xA22E, 0xA22F, 0xA230, 0xA231, 0xA232, 0xA233, 0xA234, 0xA235, 0xA236, 	// 0x8235D039
	0xA237, 0xA238, 0xA239, 0xA23A, 0xA23B, 0xA23C, 0xA23D, 0xA23E, 0xA23F, 0xA240, 	// 0x8235D139
	0xA241, 0xA242, 0xA243, 0xA244, 0xA245, 0xA246, 0xA247, 0xA248, 0xA249, 0xA24A, 	// 0x8235D239
	0xA24B, 0xA24C, 0xA24D, 0xA24E, 0xA24F, 0xA250, 0xA251, 0xA252, 0xA253, 0xA254, 	// 0x8235D339
	0xA255, 0xA256, 0xA257, 0xA258, 0xA259, 0xA25A, 0xA25B, 0xA25C, 0xA25D, 0xA25E, 	// 0x8235D439
	0xA25F, 0xA260, 0xA261, 0xA262, 0xA263, 0xA264, 0xA265, 0xA266, 0xA267, 0xA268, 	// 0x8235D539
	0xA269, 0xA26A, 0xA26B, 0xA26C, 0xA26D, 0xA26E, 0xA26F, 0xA270, 0xA271, 0xA272, 	// 0x8235D639
	0xA273, 0xA274, 0xA275, 0xA276, 0xA277, 0xA278, 0xA279, 0xA27A, 0xA27B, 0xA27C, 	// 0x8235D739
	0xA27D, 0xA27E, 0xA27F, 0xA280, 0xA281, 0xA282, 0xA283, 0xA284, 0xA285, 0xA286, 	// 0x8235D839
	0xA287, 0xA288, 0xA289, 0xA28A, 0xA28B, 0xA28C, 0xA28D, 0xA28E, 0xA28F, 0xA290, 	// 0x8235D939
	0xA291, 0xA292, 0xA293, 0xA294, 0xA295, 0xA296, 0xA297, 0xA298, 0xA299, 0xA29A, 	// 0x8235DA39
	0xA29B, 0xA29C, 0xA29D, 0xA29E, 0xA29F, 0xA2A0, 0xA2A1, 0xA2A2, 0xA2A3, 0xA2A4, 	// 0x8235DB39
	0xA2A5, 0xA2A6, 0xA2A7, 0xA2A8, 0xA2A9, 0xA2AA, 0xA2AB, 0xA2AC, 0xA2AD, 0xA2AE, 	// 0x8235DC39
	0xA2AF, 0xA2B0, 0xA2B1, 0xA2B2, 0xA2B3, 0xA2B4, 0xA2B5, 0xA2B6, 0xA2B7, 0xA2B8, 	// 0x8235DD39
	0xA2B9, 0xA2BA, 0xA2BB, 0xA2BC, 0xA2BD, 0xA2BE, 0xA2BF, 0xA2C0, 0xA2C1, 0xA2C2, 	// 0x8235DE39
	0xA2C3, 0xA2C4, 0xA2C5, 0xA2C6, 0xA2C7, 0xA2C8, 0xA2C9, 0xA2CA, 0xA2CB, 0xA2CC, 	// 0x8235DF39
	0xA2CD, 0xA2CE, 0xA2CF, 0xA2D0, 0xA2D1, 0xA2D2, 0xA2D3, 0xA2D4, 0xA2D5, 0xA2D6, 	// 0x8235E039
	0xA2D7, 0xA2D8, 0xA2D9, 0xA2DA, 0xA2DB, 0xA2DC, 0xA2DD, 0xA2DE, 0xA2DF, 0xA2E0, 	// 0x8235E139
	0xA2E1, 0xA2E2, 0xA2E3, 0xA2E4, 0xA2E5, 0xA2E6, 0xA2E7, 0xA2E8, 0xA2E9, 0xA2EA, 	// 0x8235E239
	0xA2EB, 0xA2EC, 0xA2ED, 0xA2EE, 0xA2EF, 0xA2F0, 0xA2F1, 0xA2F2, 0xA2F3, 0xA2F4, 	// 0x8235E339
	0xA2F5, 0xA2F6, 0xA2F7, 0xA2F8, 0xA2F9, 0xA2FA, 0xA2FB, 0xA2FC, 0xA2FD, 0xA2FE, 	// 0x8235E439
	0xA2FF, 0xA300, 0xA301, 0xA302, 0xA303, 0xA304, 0xA305, 0xA306, 0xA307, 0xA308, 	// 0x8235E539
	0xA309, 0xA30A, 0xA30B, 0xA30C, 0xA30D, 0xA30E, 0xA30F, 0xA310, 0xA311, 0xA312, 	// 0x8235E639
	0xA313, 0xA314, 0xA315, 0xA316, 0xA317, 0xA318, 0xA319, 0xA31A, 0xA31B, 0xA31C, 	// 0x8235E739
	0xA31D, 0xA31E, 0xA31F, 0xA320, 0xA321, 0xA322, 0xA323, 0xA324, 0xA325, 0xA326, 	// 0x8235E839
	0xA327, 0xA328, 0xA329, 0xA32A, 0xA32B, 0xA32C, 0xA32D, 0xA32E, 0xA32F, 0xA330, 	// 0x8235E939
	0xA331, 0xA332, 0xA333, 0xA334, 0xA335, 0xA336, 0xA337, 0xA338, 0xA339, 0xA33A, 	// 0x8235EA39
	0xA33B, 0xA33C, 0xA33D, 0xA33E, 0xA33F, 0xA340, 0xA341, 0xA342, 0xA343, 0xA344, 	// 0x8235EB39
	0xA345, 0xA346, 0xA347, 0xA348, 0xA349, 0xA34A, 0xA34B, 0xA34C, 0xA34D, 0xA34E, 	// 0x8235EC39
	0xA34F, 0xA350, 0xA351, 0xA352, 0xA353, 0xA354, 0xA355, 0xA356, 0xA357, 0xA358, 	// 0x8235ED39
	0xA359, 0xA35A, 0xA35B, 0xA35C, 0xA35D, 0xA35E, 0xA35F, 0xA360, 0xA361, 0xA362, 	// 0x8235EE39
	0xA363, 0xA364, 0xA365, 0xA366, 0xA367, 0xA368, 0xA369, 0xA36A, 0xA36B, 0xA36C, 	// 0x8235EF39
	0xA36D, 0xA36E, 0xA36F, 0xA370, 0xA371, 0xA372, 0xA373, 0xA374, 0xA375, 0xA376, 	// 0x8235F039
	0xA377, 0xA378, 0xA379, 0xA37A, 0xA37B, 0xA37C, 0xA37D, 0xA37E, 0xA37F, 0xA380, 	// 0x8235F139
	0xA381, 0xA382, 0xA383, 0xA384, 0xA385, 0xA386, 0xA387, 0xA388, 0xA389, 0xA38A, 	// 0x8235F239
	0xA38B, 0xA38C, 0xA38D, 0xA38E, 0xA38F, 0xA390, 0xA391, 0xA392, 0xA393, 0xA394, 	// 0x8235F339
	0xA395, 0xA396, 0xA397, 0xA398, 0xA399, 0xA39A, 0xA39B, 0xA39C, 0xA39D, 0xA39E, 	// 0x8235F439
	0xA39F, 0xA3A0, 0xA3A1, 0xA3A2, 0xA3A3, 0xA3A4, 0xA3A5, 0xA3A6, 0xA3A7, 0xA3A8, 	// 0x8235F539
	0xA3A9, 0xA3AA, 0xA3AB, 0xA3AC, 0xA3AD, 0xA3AE, 0xA3AF, 0xA3B0, 0xA3B1, 0xA3B2, 	// 0x8235F639
	0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7, 0xA3B8, 0xA3B9, 0xA3BA, 0xA3BB, 0xA3BC, 	// 0x8235F739
	0xA3BD, 0xA3BE, 0xA3BF, 0xA3C0, 0xA3C1, 0xA3C2, 0xA3C3, 0xA3C4, 0xA3C5, 0xA3C6, 	// 0x8235F839
	0xA3C7, 0xA3C8, 0xA3C9, 0xA3CA, 0xA3CB, 0xA3CC, 0xA3CD, 0xA3CE, 0xA3CF, 0xA3D0, 	// 0x8235F939
	0xA3D1, 0xA3D2, 0xA3D3, 0xA3D4, 0xA3D5, 0xA3D6, 0xA3D7, 0xA3D8, 0xA3D9, 0xA3DA, 	// 0x8235FA39
	0xA3DB, 0xA3DC, 0xA3DD, 0xA3DE, 0xA3DF, 0xA3E0, 0xA3E1, 0xA3E2, 0xA3E3, 0xA3E4, 	// 0x8235FB39
	0xA3E5, 0xA3E6, 0xA3E7, 0xA3E8, 0xA3E9, 0xA3EA, 0xA3EB, 0xA3EC, 0xA3ED, 0xA3EE, 	// 0x8235FC39
	0xA3EF, 0xA3F0, 0xA3F1, 0xA3F2, 0xA3F3, 0xA3F4, 0xA3F5, 0xA3F6, 0xA3F7, 0xA3F8, 	// 0x8235FD39
	0xA3F9, 0xA3FA, 0xA3FB, 0xA3FC, 0xA3FD, 0xA3FE, 0xA3FF, 0xA400, 0xA401, 0xA402, 	// 0x8235FE39
	0xA403, 0xA404, 0xA405, 0xA406, 0xA407, 0xA408, 0xA409, 0xA40A, 0xA40B, 0xA40C, 	// 0x82368139
	0xA40D, 0xA40E, 0xA40F, 0xA410, 0xA411, 0xA412, 0xA413, 0xA414, 0xA415, 0xA416, 	// 0x82368239
	0xA417, 0xA418, 0xA419, 0xA41A, 0xA41B, 0xA41C, 0xA41D, 0xA41E, 0xA41F, 0xA420, 	// 0x82368339
	0xA421, 0xA422, 0xA423, 0xA424, 0xA425, 0xA426, 0xA427, 0xA428, 0xA429, 0xA42A, 	// 0x82368439
	0xA42B, 0xA42C, 0xA42D, 0xA42E, 0xA42F, 0xA430, 0xA431, 0xA432, 0xA433, 0xA434, 	// 0x82368539
	0xA435, 0xA436, 0xA437, 0xA438, 0xA439, 0xA43A, 0xA43B, 0xA43C, 0xA43D, 0xA43E, 	// 0x82368639
	0xA43F, 0xA440, 0xA441, 0xA442, 0xA443, 0xA444, 0xA445, 0xA446, 0xA447, 0xA448, 	// 0x82368739
	0xA449, 0xA44A, 0xA44B, 0xA44C, 0xA44D, 0xA44E, 0xA44F, 0xA450, 0xA451, 0xA452, 	// 0x82368839
	0xA453, 0xA454, 0xA455, 0xA456, 0xA457, 0xA458, 0xA459, 0xA45A, 0xA45B, 0xA45C, 	// 0x82368939
	0xA45D, 0xA45E, 0xA45F, 0xA460, 0xA461, 0xA462, 0xA463, 0xA464, 0xA465, 0xA466, 	// 0x82368A39
	0xA467, 0xA468, 0xA469, 0xA46A, 0xA46B, 0xA46C, 0xA46D, 0xA46E, 0xA46F, 0xA470, 	// 0x82368B39
	0xA471, 0xA472, 0xA473, 0xA474, 0xA475, 0xA476, 0xA477, 0xA478, 0xA479, 0xA47A, 	// 0x82368C39
	0xA47B, 0xA47C, 0xA47D, 0xA47E, 0xA47F, 0xA480, 0xA481, 0xA482, 0xA483, 0xA484, 	// 0x82368D39
	0xA485, 0xA486, 0xA487, 0xA488, 0xA489, 0xA48A, 0xA48B, 0xA48C, 0xA48D, 0xA48E, 	// 0x82368E39
	0xA48F, 0xA490, 0xA491, 0xA492, 0xA493, 0xA494, 0xA495, 0xA496, 0xA497, 0xA498, 	// 0x82368F39
	0xA499, 0xA49A, 0xA49B, 0xA49C, 0xA49D, 0xA49E, 0xA49F, 0xA4A0, 0xA4A1, 0xA4A2, 	// 0x82369039
	0xA4A3, 0xA4A4, 0xA4A5, 0xA4A6, 0xA4A7, 0xA4A8, 0xA4A9, 0xA4AA, 0xA4AB, 0xA4AC, 	// 0x82369139
	0xA4AD, 0xA4AE, 0xA4AF, 0xA4B0, 0xA4B1, 0xA4B2, 0xA4B3, 0xA4B4, 0xA4B5, 0xA4B6, 	// 0x82369239
	0xA4B7, 0xA4B8, 0xA4B9, 0xA4BA, 0xA4BB, 0xA4BC, 0xA4BD, 0xA4BE, 0xA4BF, 0xA4C0, 	// 0x82369339
	0xA4C1, 0xA4C2, 0xA4C3, 0xA4C4, 0xA4C5, 0xA4C6, 0xA4C7, 0xA4C8, 0xA4C9, 0xA4CA, 	// 0x82369439
	0xA4CB, 0xA4CC, 0xA4CD, 0xA4CE, 0xA4CF, 0xA4D0, 0xA4D1, 0xA4D2, 0xA4D3, 0xA4D4, 	// 0x82369539
	0xA4D5, 0xA4D6, 0xA4D7, 0xA4D8, 0xA4D9, 0xA4DA, 0xA4DB, 0xA4DC, 0xA4DD, 0xA4DE, 	// 0x82369639
	0xA4DF, 0xA4E0, 0xA4E1, 0xA4E2, 0xA4E3, 0xA4E4, 0xA4E5, 0xA4E6, 0xA4E7, 0xA4E8, 	// 0x82369739
	0xA4E9, 0xA4EA, 0xA4EB, 0xA4EC, 0xA4ED, 0xA4EE, 0xA4EF, 0xA4F0, 0xA4F1, 0xA4F2, 	// 0x82369839
	0xA4F3, 0xA4F4, 0xA4F5, 0xA4F6, 0xA4F7, 0xA4F8, 0xA4F9, 0xA4FA, 0xA4FB, 0xA4FC, 	// 0x82369939
	0xA4FD, 0xA4FE, 0xA4FF, 0xA500, 0xA501, 0xA502, 0xA503, 0xA504, 0xA505, 0xA506, 	// 0x82369A39
	0xA507, 0xA508, 0xA509, 0xA50A, 0xA50B, 0xA50C, 0xA50D, 0xA50E, 0xA50F, 0xA510, 	// 0x82369B39
	0xA511, 0xA512, 0xA513, 0xA514, 0xA515, 0xA516, 0xA517, 0xA518, 0xA519, 0xA51A, 	// 0x82369C39
	0xA51B, 0xA51C, 0xA51D, 0xA51E, 0xA51F, 0xA520, 0xA521, 0xA522, 0xA523, 0xA524, 	// 0x82369D39
	0xA525, 0xA526, 0xA527, 0xA528, 0xA529, 0xA52A, 0xA52B, 0xA52C, 0xA52D, 0xA52E, 	// 0x82369E39
	0xA52F, 0xA530, 0xA531, 0xA532, 0xA533, 0xA534, 0xA535, 0xA536, 0xA537, 0xA538, 	// 0x82369F39
	0xA539, 0xA53A, 0xA53B, 0xA53C, 0xA53D, 0xA53E, 0xA53F, 0xA540, 0xA541, 0xA542, 	// 0x8236A039
	0xA543, 0xA544, 0xA545, 0xA546, 0xA547, 0xA548, 0xA549, 0xA54A, 0xA54B, 0xA54C, 	// 0x8236A139
	0xA54D, 0xA54E, 0xA54F, 0xA550, 0xA551, 0xA552, 0xA553, 0xA554, 0xA555, 0xA556, 	// 0x8236A239
	0xA557, 0xA558, 0xA559, 0xA55A, 0xA55B, 0xA55C, 0xA55D, 0xA55E, 0xA55F, 0xA560, 	// 0x8236A339
	0xA561, 0xA562, 0xA563, 0xA564, 0xA565, 0xA566, 0xA567, 0xA568, 0xA569, 0xA56A, 	// 0x8236A439
	0xA56B, 0xA56C, 0xA56D, 0xA56E, 0xA56F, 0xA570, 0xA571, 0xA572, 0xA573, 0xA574, 	// 0x8236A539
	0xA575, 0xA576, 0xA577, 0xA578, 0xA579, 0xA57A, 0xA57B, 0xA57C, 0xA57D, 0xA57E, 	// 0x8236A639
	0xA57F, 0xA580, 0xA581, 0xA582, 0xA583, 0xA584, 0xA585, 0xA586, 0xA587, 0xA588, 	// 0x8236A739
	0xA589, 0xA58A, 0xA58B, 0xA58C, 0xA58D, 0xA58E, 0xA58F, 0xA590, 0xA591, 0xA592, 	// 0x8236A839
	0xA593, 0xA594, 0xA595, 0xA596, 0xA597, 0xA598, 0xA599, 0xA59A, 0xA59B, 0xA59C, 	// 0x8236A939
	0xA59D, 0xA59E, 0xA59F, 0xA5A0, 0xA5A1, 0xA5A2, 0xA5A3, 0xA5A4, 0xA5A5, 0xA5A6, 	// 0x8236AA39
	0xA5A7, 0xA5A8, 0xA5A9, 0xA5AA, 0xA5AB, 0xA5AC, 0xA5AD, 0xA5AE, 0xA5AF, 0xA5B0, 	// 0x8236AB39
	0xA5B1, 0xA5B2, 0xA5B3, 0xA5B4, 0xA5B5, 0xA5B6, 0xA5B7, 0xA5B8, 0xA5B9, 0xA5BA, 	// 0x8236AC39
	0xA5BB, 0xA5BC, 0xA5BD, 0xA5BE, 0xA5BF, 0xA5C0, 0xA5C1, 0xA5C2, 0xA5C3, 0xA5C4, 	// 0x8236AD39
	0xA5C5, 0xA5C6, 0xA5C7, 0xA5C8, 0xA5C9, 0xA5CA, 0xA5CB, 0xA5CC, 0xA5CD, 0xA5CE, 	// 0x8236AE39
	0xA5CF, 0xA5D0, 0xA5D1, 0xA5D2, 0xA5D3, 0xA5D4, 0xA5D5, 0xA5D6, 0xA5D7, 0xA5D8, 	// 0x8236AF39
	0xA5D9, 0xA5DA, 0xA5DB, 0xA5DC, 0xA5DD, 0xA5DE, 0xA5DF, 0xA5E0, 0xA5E1, 0xA5E2, 	// 0x8236B039
	0xA5E3, 0xA5E4, 0xA5E5, 0xA5E6, 0xA5E7, 0xA5E8, 0xA5E9, 0xA5EA, 0xA5EB, 0xA5EC, 	// 0x8236B139
	0xA5ED, 0xA5EE, 0xA5EF, 0xA5F0, 0xA5F1, 0xA5F2, 0xA5F3, 0xA5F4, 0xA5F5, 0xA5F6, 	// 0x8236B239
	0xA5F7, 0xA5F8, 0xA5F9, 0xA5FA, 0xA5FB, 0xA5FC, 0xA5FD, 0xA5FE, 0xA5FF, 0xA600, 	// 0x8236B339
	0xA601, 0xA602, 0xA603, 0xA604, 0xA605, 0xA606, 0xA607, 0xA608, 0xA609, 0xA60A, 	// 0x8236B439
	0xA60B, 0xA60C, 0xA60D, 0xA60E, 0xA60F, 0xA610, 0xA611, 0xA612, 0xA613, 0xA614, 	// 0x8236B539
	0xA615, 0xA616, 0xA617, 0xA618, 0xA619, 0xA61A, 0xA61B, 0xA61C, 0xA61D, 0xA61E, 	// 0x8236B639
	0xA61F, 0xA620, 0xA621, 0xA622, 0xA623, 0xA624, 0xA625, 0xA626, 0xA627, 0xA628, 	// 0x8236B739
	0xA629, 0xA62A, 0xA62B, 0xA62C, 0xA62D, 0xA62E, 0xA62F, 0xA630, 0xA631, 0xA632, 	// 0x8236B839
	0xA633, 0xA634, 0xA635, 0xA636, 0xA637, 0xA638, 0xA639, 0xA63A, 0xA63B, 0xA63C, 	// 0x8236B939
	0xA63D, 0xA63E, 0xA63F, 0xA640, 0xA641, 0xA642, 0xA643, 0xA644, 0xA645, 0xA646, 	// 0x8236BA39
	0xA647, 0xA648, 0xA649, 0xA64A, 0xA64B, 0xA64C, 0xA64D, 0xA64E, 0xA64F, 0xA650, 	// 0x8236BB39
	0xA651, 0xA652, 0xA653, 0xA654, 0xA655, 0xA656, 0xA657, 0xA658, 0xA659, 0xA65A, 	// 0x8236BC39
	0xA65B, 0xA65C, 0xA65D, 0xA65E, 0xA65F, 0xA660, 0xA661, 0xA662, 0xA663, 0xA664, 	// 0x8236BD39
	0xA665, 0xA666, 0xA667, 0xA668, 0xA669, 0xA66A, 0xA66B, 0xA66C, 0xA66D, 0xA66E, 	// 0x8236BE39
	0xA66F, 0xA670, 0xA671, 0xA672, 0xA673, 0xA674, 0xA675, 0xA676, 0xA677, 0xA678, 	// 0x8236BF39
	0xA679, 0xA67A, 0xA67B, 0xA67C, 0xA67D, 0xA67E, 0xA67F, 0xA680, 0xA681, 0xA682, 	// 0x8236C039
	0xA683, 0xA684, 0xA685, 0xA686, 0xA687, 0xA688, 0xA689, 0xA68A, 0xA68B, 0xA68C, 	// 0x8236C139
	0xA68D, 0xA68E, 0xA68F, 0xA690, 0xA691, 0xA692, 0xA693, 0xA694, 0xA695, 0xA696, 	// 0x8236C239
	0xA697, 0xA698, 0xA699, 0xA69A, 0xA69B, 0xA69C, 0xA69D, 0xA69E, 0xA69F, 0xA6A0, 	// 0x8236C339
	0xA6A1, 0xA6A2, 0xA6A3, 0xA6A4, 0xA6A5, 0xA6A6, 0xA6A7, 0xA6A8, 0xA6A9, 0xA6AA, 	// 0x8236C439
	0xA6AB, 0xA6AC, 0xA6AD, 0xA6AE, 0xA6AF, 0xA6B0, 0xA6B1, 0xA6B2, 0xA6B3, 0xA6B4, 	// 0x8236C539
	0xA6B5, 0xA6B6, 0xA6B7, 0xA6B8, 0xA6B9, 0xA6BA, 0xA6BB, 0xA6BC, 0xA6BD, 0xA6BE, 	// 0x8236C639
	0xA6BF, 0xA6C0, 0xA6C1, 0xA6C2, 0xA6C3, 0xA6C4, 0xA6C5, 0xA6C6, 0xA6C7, 0xA6C8, 	// 0x8236C739
	0xA6C9, 0xA6CA, 0xA6CB, 0xA6CC, 0xA6CD, 0xA6CE, 0xA6CF, 0xA6D0, 0xA6D1, 0xA6D2, 	// 0x8236C839
	0xA6D3, 0xA6D4, 0xA6D5, 0xA6D6, 0xA6D7, 0xA6D8, 0xA6D9, 0xA6DA, 0xA6DB, 0xA6DC, 	// 0x8236C939
	0xA6DD, 0xA6DE, 0xA6DF, 0xA6E0, 0xA6E1, 0xA6E2, 0xA6E3, 0xA6E4, 0xA6E5, 0xA6E6, 	// 0x8236CA39
	0xA6E7, 0xA6E8, 0xA6E9, 0xA6EA, 0xA6EB, 0xA6EC, 0xA6ED, 0xA6EE, 0xA6EF, 0xA6F0, 	// 0x8236CB39
	0xA6F1, 0xA6F2, 0xA6F3, 0xA6F4, 0xA6F5, 0xA6F6, 0xA6F7, 0xA6F8, 0xA6F9, 0xA6FA, 	// 0x8236CC39
	0xA6FB, 0xA6FC, 0xA6FD, 0xA6FE, 0xA6FF, 0xA700, 0xA701, 0xA702, 0xA703, 0xA704, 	// 0x8236CD39
	0xA705, 0xA706, 0xA707, 0xA708, 0xA709, 0xA70A, 0xA70B, 0xA70C, 0xA70D, 0xA70E, 	// 0x8236CE39
	0xA70F, 0xA710, 0xA711, 0xA712, 0xA713, 0xA714, 0xA715, 0xA716, 0xA717, 0xA718, 	// 0x8236CF39
	0xA719, 0xA71A, 0xA71B, 0xA71C, 0xA71D, 0xA71E, 0xA71F, 0xA720, 0xA721, 0xA722, 	// 0x8236D039
	0xA723, 0xA724, 0xA725, 0xA726, 0xA727, 0xA728, 0xA729, 0xA72A, 0xA72B, 0xA72C, 	// 0x8236D139
	0xA72D, 0xA72E, 0xA72F, 0xA730, 0xA731, 0xA732, 0xA733, 0xA734, 0xA735, 0xA736, 	// 0x8236D239
	0xA737, 0xA738, 0xA739, 0xA73A, 0xA73B, 0xA73C, 0xA73D, 0xA73E, 0xA73F, 0xA740, 	// 0x8236D339
	0xA741, 0xA742, 0xA743, 0xA744, 0xA745, 0xA746, 0xA747, 0xA748, 0xA749, 0xA74A, 	// 0x8236D439
	0xA74B, 0xA74C, 0xA74D, 0xA74E, 0xA74F, 0xA750, 0xA751, 0xA752, 0xA753, 0xA754, 	// 0x8236D539
	0xA755, 0xA756, 0xA757, 0xA758, 0xA759, 0xA75A, 0xA75B, 0xA75C, 0xA75D, 0xA75E, 	// 0x8236D639
	0xA75F, 0xA760, 0xA761, 0xA762, 0xA763, 0xA764, 0xA765, 0xA766, 0xA767, 0xA768, 	// 0x8236D739
	0xA769, 0xA76A, 0xA76B, 0xA76C, 0xA76D, 0xA76E, 0xA76F, 0xA770, 0xA771, 0xA772, 	// 0x8236D839
	0xA773, 0xA774, 0xA775, 0xA776, 0xA777, 0xA778, 0xA779, 0xA77A, 0xA77B, 0xA77C, 	// 0x8236D939
	0xA77D, 0xA77E, 0xA77F, 0xA780, 0xA781, 0xA782, 0xA783, 0xA784, 0xA785, 0xA786, 	// 0x8236DA39
	0xA787, 0xA788, 0xA789, 0xA78A, 0xA78B, 0xA78C, 0xA78D, 0xA78E, 0xA78F, 0xA790, 	// 0x8236DB39
	0xA791, 0xA792, 0xA793, 0xA794, 0xA795, 0xA796, 0xA797, 0xA798, 0xA799, 0xA79A, 	// 0x8236DC39
	0xA79B, 0xA79C, 0xA79D, 0xA79E, 0xA79F, 0xA7A0, 0xA7A1, 0xA7A2, 0xA7A3, 0xA7A4, 	// 0x8236DD39
	0xA7A5, 0xA7A6, 0xA7A7, 0xA7A8, 0xA7A9, 0xA7AA, 0xA7AB, 0xA7AC, 0xA7AD, 0xA7AE, 	// 0x8236DE39
	0xA7AF, 0xA7B0, 0xA7B1, 0xA7B2, 0xA7B3, 0xA7B4, 0xA7B5, 0xA7B6, 0xA7B7, 0xA7B8, 	// 0x8236DF39
	0xA7B9, 0xA7BA, 0xA7BB, 0xA7BC, 0xA7BD, 0xA7BE, 0xA7BF, 0xA7C0, 0xA7C1, 0xA7C2, 	// 0x8236E039
	0xA7C3, 0xA7C4, 0xA7C5, 0xA7C6, 0xA7C7, 0xA7C8, 0xA7C9, 0xA7CA, 0xA7CB, 0xA7CC, 	// 0x8236E139
	0xA7CD, 0xA7CE, 0xA7CF, 0xA7D0, 0xA7D1, 0xA7D2, 0xA7D3, 0xA7D4, 0xA7D5, 0xA7D6, 	// 0x8236E239
	0xA7D7, 0xA7D8, 0xA7D9, 0xA7DA, 0xA7DB, 0xA7DC, 0xA7DD, 0xA7DE, 0xA7DF, 0xA7E0, 	// 0x8236E339
	0xA7E1, 0xA7E2, 0xA7E3, 0xA7E4, 0xA7E5, 0xA7E6, 0xA7E7, 0xA7E8, 0xA7E9, 0xA7EA, 	// 0x8236E439
	0xA7EB, 0xA7EC, 0xA7ED, 0xA7EE, 0xA7EF, 0xA7F0, 0xA7F1, 0xA7F2, 0xA7F3, 0xA7F4, 	// 0x8236E539
	0xA7F5, 0xA7F6, 0xA7F7, 0xA7F8, 0xA7F9, 0xA7FA, 0xA7FB, 0xA7FC, 0xA7FD, 0xA7FE, 	// 0x8236E639
	0xA7FF, 0xA800, 0xA801, 0xA802, 0xA803, 0xA804, 0xA805, 0xA806, 0xA807, 0xA808, 	// 0x8236E739
	0xA809, 0xA80A, 0xA80B, 0xA80C, 0xA80D, 0xA80E, 0xA80F, 0xA810, 0xA811, 0xA812, 	// 0x8236E839
	0xA813, 0xA814, 0xA815, 0xA816, 0xA817, 0xA818, 0xA819, 0xA81A, 0xA81B, 0xA81C, 	// 0x8236E939
	0xA81D, 0xA81E, 0xA81F, 0xA820, 0xA821, 0xA822, 0xA823, 0xA824, 0xA825, 0xA826, 	// 0x8236EA39
	0xA827, 0xA828, 0xA829, 0xA82A, 0xA82B, 0xA82C, 0xA82D, 0xA82E, 0xA82F, 0xA830, 	// 0x8236EB39
	0xA831, 0xA832, 0xA833, 0xA834, 0xA835, 0xA836, 0xA837, 0xA838, 0xA839, 0xA83A, 	// 0x8236EC39
	0xA83B, 0xA83C, 0xA83D, 0xA83E, 0xA83F, 0xA840, 0xA841, 0xA842, 0xA843, 0xA844, 	// 0x8236ED39
	0xA845, 0xA846, 0xA847, 0xA848, 0xA849, 0xA84A, 0xA84B, 0xA84C, 0xA84D, 0xA84E, 	// 0x8236EE39
	0xA84F, 0xA850, 0xA851, 0xA852, 0xA853, 0xA854, 0xA855, 0xA856, 0xA857, 0xA858, 	// 0x8236EF39
	0xA859, 0xA85A, 0xA85B, 0xA85C, 0xA85D, 0xA85E, 0xA85F, 0xA860, 0xA861, 0xA862, 	// 0x8236F039
	0xA863, 0xA864, 0xA865, 0xA866, 0xA867, 0xA868, 0xA869, 0xA86A, 0xA86B, 0xA86C, 	// 0x8236F139
	0xA86D, 0xA86E, 0xA86F, 0xA870, 0xA871, 0xA872, 0xA873, 0xA874, 0xA875, 0xA876, 	// 0x8236F239
	0xA877, 0xA878, 0xA879, 0xA87A, 0xA87B, 0xA87C, 0xA87D, 0xA87E, 0xA87F, 0xA880, 	// 0x8236F339
	0xA881, 0xA882, 0xA883, 0xA884, 0xA885, 0xA886, 0xA887, 0xA888, 0xA889, 0xA88A, 	// 0x8236F439
	0xA88B, 0xA88C, 0xA88D, 0xA88E, 0xA88F, 0xA890, 0xA891, 0xA892, 0xA893, 0xA894, 	// 0x8236F539
	0xA895, 0xA896, 0xA897, 0xA898, 0xA899, 0xA89A, 0xA89B, 0xA89C, 0xA89D, 0xA89E, 	// 0x8236F639
	0xA89F, 0xA8A0, 0xA8A1, 0xA8A2, 0xA8A3, 0xA8A4, 0xA8A5, 0xA8A6, 0xA8A7, 0xA8A8, 	// 0x8236F739
	0xA8A9, 0xA8AA, 0xA8AB, 0xA8AC, 0xA8AD, 0xA8AE, 0xA8AF, 0xA8B0, 0xA8B1, 0xA8B2, 	// 0x8236F839
	0xA8B3, 0xA8B4, 0xA8B5, 0xA8B6, 0xA8B7, 0xA8B8, 0xA8B9, 0xA8BA, 0xA8BB, 0xA8BC, 	// 0x8236F939
	0xA8BD, 0xA8BE, 0xA8BF, 0xA8C0, 0xA8C1, 0xA8C2, 0xA8C3, 0xA8C4, 0xA8C5, 0xA8C6, 	// 0x8236FA39
	0xA8C7, 0xA8C8, 0xA8C9, 0xA8CA, 0xA8CB, 0xA8CC, 0xA8CD, 0xA8CE, 0xA8CF, 0xA8D0, 	// 0x8236FB39
	0xA8D1, 0xA8D2, 0xA8D3, 0xA8D4, 0xA8D5, 0xA8D6, 0xA8D7, 0xA8D8, 0xA8D9, 0xA8DA, 	// 0x8236FC39
	0xA8DB, 0xA8DC, 0xA8DD, 0xA8DE, 0xA8DF, 0xA8E0, 0xA8E1, 0xA8E2, 0xA8E3, 0xA8E4, 	// 0x8236FD39
	0xA8E5, 0xA8E6, 0xA8E7, 0xA8E8, 0xA8E9, 0xA8EA, 0xA8EB, 0xA8EC, 0xA8ED, 0xA8EE, 	// 0x8236FE39
	0xA8EF, 0xA8F0, 0xA8F1, 0xA8F2, 0xA8F3, 0xA8F4, 0xA8F5, 0xA8F6, 0xA8F7, 0xA8F8, 	// 0x82378139
	0xA8F9, 0xA8FA, 0xA8FB, 0xA8FC, 0xA8FD, 0xA8FE, 0xA8FF, 0xA900, 0xA901, 0xA902, 	// 0x82378239
	0xA903, 0xA904, 0xA905, 0xA906, 0xA907, 0xA908, 0xA909, 0xA90A, 0xA90B, 0xA90C, 	// 0x82378339
	0xA90D, 0xA90E, 0xA90F, 0xA910, 0xA911, 0xA912, 0xA913, 0xA914, 0xA915, 0xA916, 	// 0x82378439
	0xA917, 0xA918, 0xA919, 0xA91A, 0xA91B, 0xA91C, 0xA91D, 0xA91E, 0xA91F, 0xA920, 	// 0x82378539
	0xA921, 0xA922, 0xA923, 0xA924, 0xA925, 0xA926, 0xA927, 0xA928, 0xA929, 0xA92A, 	// 0x82378639
	0xA92B, 0xA92C, 0xA92D, 0xA92E, 0xA92F, 0xA930, 0xA931, 0xA932, 0xA933, 0xA934, 	// 0x82378739
	0xA935, 0xA936, 0xA937, 0xA938, 0xA939, 0xA93A, 0xA93B, 0xA93C, 0xA93D, 0xA93E, 	// 0x82378839
	0xA93F, 0xA940, 0xA941, 0xA942, 0xA943, 0xA944, 0xA945, 0xA946, 0xA947, 0xA948, 	// 0x82378939
	0xA949, 0xA94A, 0xA94B, 0xA94C, 0xA94D, 0xA94E, 0xA94F, 0xA950, 0xA951, 0xA952, 	// 0x82378A39
	0xA953, 0xA954, 0xA955, 0xA956, 0xA957, 0xA958, 0xA959, 0xA95A, 0xA95B, 0xA95C, 	// 0x82378B39
	0xA95D, 0xA95E, 0xA95F, 0xA960, 0xA961, 0xA962, 0xA963, 0xA964, 0xA965, 0xA966, 	// 0x82378C39
	0xA967, 0xA968, 0xA969, 0xA96A, 0xA96B, 0xA96C, 0xA96D, 0xA96E, 0xA96F, 0xA970, 	// 0x82378D39
	0xA971, 0xA972, 0xA973, 0xA974, 0xA975, 0xA976, 0xA977, 0xA978, 0xA979, 0xA97A, 	// 0x82378E39
	0xA97B, 0xA97C, 0xA97D, 0xA97E, 0xA97F, 0xA980, 0xA981, 0xA982, 0xA983, 0xA984, 	// 0x82378F39
	0xA985, 0xA986, 0xA987, 0xA988, 0xA989, 0xA98A, 0xA98B, 0xA98C, 0xA98D, 0xA98E, 	// 0x82379039
	0xA98F, 0xA990, 0xA991, 0xA992, 0xA993, 0xA994, 0xA995, 0xA996, 0xA997, 0xA998, 	// 0x82379139
	0xA999, 0xA99A, 0xA99B, 0xA99C, 0xA99D, 0xA99E, 0xA99F, 0xA9A0, 0xA9A1, 0xA9A2, 	// 0x82379239
	0xA9A3, 0xA9A4, 0xA9A5, 0xA9A6, 0xA9A7, 0xA9A8, 0xA9A9, 0xA9AA, 0xA9AB, 0xA9AC, 	// 0x82379339
	0xA9AD, 0xA9AE, 0xA9AF, 0xA9B0, 0xA9B1, 0xA9B2, 0xA9B3, 0xA9B4, 0xA9B5, 0xA9B6, 	// 0x82379439
	0xA9B7, 0xA9B8, 0xA9B9, 0xA9BA, 0xA9BB, 0xA9BC, 0xA9BD, 0xA9BE, 0xA9BF, 0xA9C0, 	// 0x82379539
	0xA9C1, 0xA9C2, 0xA9C3, 0xA9C4, 0xA9C5, 0xA9C6, 0xA9C7, 0xA9C8, 0xA9C9, 0xA9CA, 	// 0x82379639
	0xA9CB, 0xA9CC, 0xA9CD, 0xA9CE, 0xA9CF, 0xA9D0, 0xA9D1, 0xA9D2, 0xA9D3, 0xA9D4, 	// 0x82379739
	0xA9D5, 0xA9D6, 0xA9D7, 0xA9D8, 0xA9D9, 0xA9DA, 0xA9DB, 0xA9DC, 0xA9DD, 0xA9DE, 	// 0x82379839
	0xA9DF, 0xA9E0, 0xA9E1, 0xA9E2, 0xA9E3, 0xA9E4, 0xA9E5, 0xA9E6, 0xA9E7, 0xA9E8, 	// 0x82379939
	0xA9E9, 0xA9EA, 0xA9EB, 0xA9EC, 0xA9ED, 0xA9EE, 0xA9EF, 0xA9F0, 0xA9F1, 0xA9F2, 	// 0x82379A39
	0xA9F3, 0xA9F4, 0xA9F5, 0xA9F6, 0xA9F7, 0xA9F8, 0xA9F9, 0xA9FA, 0xA9FB, 0xA9FC, 	// 0x82379B39
	0xA9FD, 0xA9FE, 0xA9FF, 0xAA00, 0xAA01, 0xAA02, 0xAA03, 0xAA04, 0xAA05, 0xAA06, 	// 0x82379C39
	0xAA07, 0xAA08, 0xAA09, 0xAA0A, 0xAA0B, 0xAA0C, 0xAA0D, 0xAA0E, 0xAA0F, 0xAA10, 	// 0x82379D39
	0xAA11, 0xAA12, 0xAA13, 0xAA14, 0xAA15, 0xAA16, 0xAA17, 0xAA18, 0xAA19, 0xAA1A, 	// 0x82379E39
	0xAA1B, 0xAA1C, 0xAA1D, 0xAA1E, 0xAA1F, 0xAA20, 0xAA21, 0xAA22, 0xAA23, 0xAA24, 	// 0x82379F39
	0xAA25, 0xAA26, 0xAA27, 0xAA28, 0xAA29, 0xAA2A, 0xAA2B, 0xAA2C, 0xAA2D, 0xAA2E, 	// 0x8237A039
	0xAA2F, 0xAA30, 0xAA31, 0xAA32, 0xAA33, 0xAA34, 0xAA35, 0xAA36, 0xAA37, 0xAA38, 	// 0x8237A139
	0xAA39, 0xAA3A, 0xAA3B, 0xAA3C, 0xAA3D, 0xAA3E, 0xAA3F, 0xAA40, 0xAA41, 0xAA42, 	// 0x8237A239
	0xAA43, 0xAA44, 0xAA45, 0xAA46, 0xAA47, 0xAA48, 0xAA49, 0xAA4A, 0xAA4B, 0xAA4C, 	// 0x8237A339
	0xAA4D, 0xAA4E, 0xAA4F, 0xAA50, 0xAA51, 0xAA52, 0xAA53, 0xAA54, 0xAA55, 0xAA56, 	// 0x8237A439
	0xAA57, 0xAA58, 0xAA59, 0xAA5A, 0xAA5B, 0xAA5C, 0xAA5D, 0xAA5E, 0xAA5F, 0xAA60, 	// 0x8237A539
	0xAA61, 0xAA62, 0xAA63, 0xAA64, 0xAA65, 0xAA66, 0xAA67, 0xAA68, 0xAA69, 0xAA6A, 	// 0x8237A639
	0xAA6B, 0xAA6C, 0xAA6D, 0xAA6E, 0xAA6F, 0xAA70, 0xAA71, 0xAA72, 0xAA73, 0xAA74, 	// 0x8237A739
	0xAA75, 0xAA76, 0xAA77, 0xAA78, 0xAA79, 0xAA7A, 0xAA7B, 0xAA7C, 0xAA7D, 0xAA7E, 	// 0x8237A839
	0xAA7F, 0xAA80, 0xAA81, 0xAA82, 0xAA83, 0xAA84, 0xAA85, 0xAA86, 0xAA87, 0xAA88, 	// 0x8237A939
	0xAA89, 0xAA8A, 0xAA8B, 0xAA8C, 0xAA8D, 0xAA8E, 0xAA8F, 0xAA90, 0xAA91, 0xAA92, 	// 0x8237AA39
	0xAA93, 0xAA94, 0xAA95, 0xAA96, 0xAA97, 0xAA98, 0xAA99, 0xAA9A, 0xAA9B, 0xAA9C, 	// 0x8237AB39
	0xAA9D, 0xAA9E, 0xAA9F, 0xAAA0, 0xAAA1, 0xAAA2, 0xAAA3, 0xAAA4, 0xAAA5, 0xAAA6, 	// 0x8237AC39
	0xAAA7, 0xAAA8, 0xAAA9, 0xAAAA, 0xAAAB, 0xAAAC, 0xAAAD, 0xAAAE, 0xAAAF, 0xAAB0, 	// 0x8237AD39
	0xAAB1, 0xAAB2, 0xAAB3, 0xAAB4, 0xAAB5, 0xAAB6, 0xAAB7, 0xAAB8, 0xAAB9, 0xAABA, 	// 0x8237AE39
	0xAABB, 0xAABC, 0xAABD, 0xAABE, 0xAABF, 0xAAC0, 0xAAC1, 0xAAC2, 0xAAC3, 0xAAC4, 	// 0x8237AF39
	0xAAC5, 0xAAC6, 0xAAC7, 0xAAC8, 0xAAC9, 0xAACA, 0xAACB, 0xAACC, 0xAACD, 0xAACE, 	// 0x8237B039
	0xAACF, 0xAAD0, 0xAAD1, 0xAAD2, 0xAAD3, 0xAAD4, 0xAAD5, 0xAAD6, 0xAAD7, 0xAAD8, 	// 0x8237B139
	0xAAD9, 0xAADA, 0xAADB, 0xAADC, 0xAADD, 0xAADE, 0xAADF, 0xAAE0, 0xAAE1, 0xAAE2, 	// 0x8237B239
	0xAAE3, 0xAAE4, 0xAAE5, 0xAAE6, 0xAAE7, 0xAAE8, 0xAAE9, 0xAAEA, 0xAAEB, 0xAAEC, 	// 0x8237B339
	0xAAED, 0xAAEE, 0xAAEF, 0xAAF0, 0xAAF1, 0xAAF2, 0xAAF3, 0xAAF4, 0xAAF5, 0xAAF6, 	// 0x8237B439
	0xAAF7, 0xAAF8, 0xAAF9, 0xAAFA, 0xAAFB, 0xAAFC, 0xAAFD, 0xAAFE, 0xAAFF, 0xAB00, 	// 0x8237B539
	0xAB01, 0xAB02, 0xAB03, 0xAB04, 0xAB05, 0xAB06, 0xAB07, 0xAB08, 0xAB09, 0xAB0A, 	// 0x8237B639
	0xAB0B, 0xAB0C, 0xAB0D, 0xAB0E, 0xAB0F, 0xAB10, 0xAB11, 0xAB12, 0xAB13, 0xAB14, 	// 0x8237B739
	0xAB15, 0xAB16, 0xAB17, 0xAB18, 0xAB19, 0xAB1A, 0xAB1B, 0xAB1C, 0xAB1D, 0xAB1E, 	// 0x8237B839
	0xAB1F, 0xAB20, 0xAB21, 0xAB22, 0xAB23, 0xAB24, 0xAB25, 0xAB26, 0xAB27, 0xAB28, 	// 0x8237B939
	0xAB29, 0xAB2A, 0xAB2B, 0xAB2C, 0xAB2D, 0xAB2E, 0xAB2F, 0xAB30, 0xAB31, 0xAB32, 	// 0x8237BA39
	0xAB33, 0xAB34, 0xAB35, 0xAB36, 0xAB37, 0xAB38, 0xAB39, 0xAB3A, 0xAB3B, 0xAB3C, 	// 0x8237BB39
	0xAB3D, 0xAB3E, 0xAB3F, 0xAB40, 0xAB41, 0xAB42, 0xAB43, 0xAB44, 0xAB45, 0xAB46, 	// 0x8237BC39
	0xAB47, 0xAB48, 0xAB49, 0xAB4A, 0xAB4B, 0xAB4C, 0xAB4D, 0xAB4E, 0xAB4F, 0xAB50, 	// 0x8237BD39
	0xAB51, 0xAB52, 0xAB53, 0xAB54, 0xAB55, 0xAB56, 0xAB57, 0xAB58, 0xAB59, 0xAB5A, 	// 0x8237BE39
	0xAB5B, 0xAB5C, 0xAB5D, 0xAB5E, 0xAB5F, 0xAB60, 0xAB61, 0xAB62, 0xAB63, 0xAB64, 	// 0x8237BF39
	0xAB65, 0xAB66, 0xAB67, 0xAB68, 0xAB69, 0xAB6A, 0xAB6B, 0xAB6C, 0xAB6D, 0xAB6E, 	// 0x8237C039
	0xAB6F, 0xAB70, 0xAB71, 0xAB72, 0xAB73, 0xAB74, 0xAB75, 0xAB76, 0xAB77, 0xAB78, 	// 0x8237C139
	0xAB79, 0xAB7A, 0xAB7B, 0xAB7C, 0xAB7D, 0xAB7E, 0xAB7F, 0xAB80, 0xAB81, 0xAB82, 	// 0x8237C239
	0xAB83, 0xAB84, 0xAB85, 0xAB86, 0xAB87, 0xAB88, 0xAB89, 0xAB8A, 0xAB8B, 0xAB8C, 	// 0x8237C339
	0xAB8D, 0xAB8E, 0xAB8F, 0xAB90, 0xAB91, 0xAB92, 0xAB93, 0xAB94, 0xAB95, 0xAB96, 	// 0x8237C439
	0xAB97, 0xAB98, 0xAB99, 0xAB9A, 0xAB9B, 0xAB9C, 0xAB9D, 0xAB9E, 0xAB9F, 0xABA0, 	// 0x8237C539
	0xABA1, 0xABA2, 0xABA3, 0xABA4, 0xABA5, 0xABA6, 0xABA7, 0xABA8, 0xABA9, 0xABAA, 	// 0x8237C639
	0xABAB, 0xABAC, 0xABAD, 0xABAE, 0xABAF, 0xABB0, 0xABB1, 0xABB2, 0xABB3, 0xABB4, 	// 0x8237C739
	0xABB5, 0xABB6, 0xABB7, 0xABB8, 0xABB9, 0xABBA, 0xABBB, 0xABBC, 0xABBD, 0xABBE, 	// 0x8237C839
	0xABBF, 0xABC0, 0xABC1, 0xABC2, 0xABC3, 0xABC4, 0xABC5, 0xABC6, 0xABC7, 0xABC8, 	// 0x8237C939
	0xABC9, 0xABCA, 0xABCB, 0xABCC, 0xABCD, 0xABCE, 0xABCF, 0xABD0, 0xABD1, 0xABD2, 	// 0x8237CA39
	0xABD3, 0xABD4, 0xABD5, 0xABD6, 0xABD7, 0xABD8, 0xABD9, 0xABDA, 0xABDB, 0xABDC, 	// 0x8237CB39
	0xABDD, 0xABDE, 0xABDF, 0xABE0, 0xABE1, 0xABE2, 0xABE3, 0xABE4, 0xABE5, 0xABE6, 	// 0x8237CC39
	0xABE7, 0xABE8, 0xABE9, 0xABEA, 0xABEB, 0xABEC, 0xABED, 0xABEE, 0xABEF, 0xABF0, 	// 0x8237CD39
	0xABF1, 0xABF2, 0xABF3, 0xABF4, 0xABF5, 0xABF6, 0xABF7, 0xABF8, 0xABF9, 0xABFA, 	// 0x8237CE39
	0xABFB, 0xABFC, 0xABFD, 0xABFE, 0xABFF, 0xAC00, 0xAC01, 0xAC02, 0xAC03, 0xAC04, 	// 0x8237CF39
	0xAC05, 0xAC06, 0xAC07, 0xAC08, 0xAC09, 0xAC0A, 0xAC0B, 0xAC0C, 0xAC0D, 0xAC0E, 	// 0x8237D039
	0xAC0F, 0xAC10, 0xAC11, 0xAC12, 0xAC13, 0xAC14, 0xAC15, 0xAC16, 0xAC17, 0xAC18, 	// 0x8237D139
	0xAC19, 0xAC1A, 0xAC1B, 0xAC1C, 0xAC1D, 0xAC1E, 0xAC1F, 0xAC20, 0xAC21, 0xAC22, 	// 0x8237D239
	0xAC23, 0xAC24, 0xAC25, 0xAC26, 0xAC27, 0xAC28, 0xAC29, 0xAC2A, 0xAC2B, 0xAC2C, 	// 0x8237D339
	0xAC2D, 0xAC2E, 0xAC2F, 0xAC30, 0xAC31, 0xAC32, 0xAC33, 0xAC34, 0xAC35, 0xAC36, 	// 0x8237D439
	0xAC37, 0xAC38, 0xAC39, 0xAC3A, 0xAC3B, 0xAC3C, 0xAC3D, 0xAC3E, 0xAC3F, 0xAC40, 	// 0x8237D539
	0xAC41, 0xAC42, 0xAC43, 0xAC44, 0xAC45, 0xAC46, 0xAC47, 0xAC48, 0xAC49, 0xAC4A, 	// 0x8237D639
	0xAC4B, 0xAC4C, 0xAC4D, 0xAC4E, 0xAC4F, 0xAC50, 0xAC51, 0xAC52, 0xAC53, 0xAC54, 	// 0x8237D739
	0xAC55, 0xAC56, 0xAC57, 0xAC58, 0xAC59, 0xAC5A, 0xAC5B, 0xAC5C, 0xAC5D, 0xAC5E, 	// 0x8237D839
	0xAC5F, 0xAC60, 0xAC61, 0xAC62, 0xAC63, 0xAC64, 0xAC65, 0xAC66, 0xAC67, 0xAC68, 	// 0x8237D939
	0xAC69, 0xAC6A, 0xAC6B, 0xAC6C, 0xAC6D, 0xAC6E, 0xAC6F, 0xAC70, 0xAC71, 0xAC72, 	// 0x8237DA39
	0xAC73, 0xAC74, 0xAC75, 0xAC76, 0xAC77, 0xAC78, 0xAC79, 0xAC7A, 0xAC7B, 0xAC7C, 	// 0x8237DB39
	0xAC7D, 0xAC7E, 0xAC7F, 0xAC80, 0xAC81, 0xAC82, 0xAC83, 0xAC84, 0xAC85, 0xAC86, 	// 0x8237DC39
	0xAC87, 0xAC88, 0xAC89, 0xAC8A, 0xAC8B, 0xAC8C, 0xAC8D, 0xAC8E, 0xAC8F, 0xAC90, 	// 0x8237DD39
	0xAC91, 0xAC92, 0xAC93, 0xAC94, 0xAC95, 0xAC96, 0xAC97, 0xAC98, 0xAC99, 0xAC9A, 	// 0x8237DE39
	0xAC9B, 0xAC9C, 0xAC9D, 0xAC9E, 0xAC9F, 0xACA0, 0xACA1, 0xACA2, 0xACA3, 0xACA4, 	// 0x8237DF39
	0xACA5, 0xACA6, 0xACA7, 0xACA8, 0xACA9, 0xACAA, 0xACAB, 0xACAC, 0xACAD, 0xACAE, 	// 0x8237E039
	0xACAF, 0xACB0, 0xACB1, 0xACB2, 0xACB3, 0xACB4, 0xACB5, 0xACB6, 0xACB7, 0xACB8, 	// 0x8237E139
	0xACB9, 0xACBA, 0xACBB, 0xACBC, 0xACBD, 0xACBE, 0xACBF, 0xACC0, 0xACC1, 0xACC2, 	// 0x8237E239
	0xACC3, 0xACC4, 0xACC5, 0xACC6, 0xACC7, 0xACC8, 0xACC9, 0xACCA, 0xACCB, 0xACCC, 	// 0x8237E339
	0xACCD, 0xACCE, 0xACCF, 0xACD0, 0xACD1, 0xACD2, 0xACD3, 0xACD4, 0xACD5, 0xACD6, 	// 0x8237E439
	0xACD7, 0xACD8, 0xACD9, 0xACDA, 0xACDB, 0xACDC, 0xACDD, 0xACDE, 0xACDF, 0xACE0, 	// 0x8237E539
	0xACE1, 0xACE2, 0xACE3, 0xACE4, 0xACE5, 0xACE6, 0xACE7, 0xACE8, 0xACE9, 0xACEA, 	// 0x8237E639
	0xACEB, 0xACEC, 0xACED, 0xACEE, 0xACEF, 0xACF0, 0xACF1, 0xACF2, 0xACF3, 0xACF4, 	// 0x8237E739
	0xACF5, 0xACF6, 0xACF7, 0xACF8, 0xACF9, 0xACFA, 0xACFB, 0xACFC, 0xACFD, 0xACFE, 	// 0x8237E839
	0xACFF, 0xAD00, 0xAD01, 0xAD02, 0xAD03, 0xAD04, 0xAD05, 0xAD06, 0xAD07, 0xAD08, 	// 0x8237E939
	0xAD09, 0xAD0A, 0xAD0B, 0xAD0C, 0xAD0D, 0xAD0E, 0xAD0F, 0xAD10, 0xAD11, 0xAD12, 	// 0x8237EA39
	0xAD13, 0xAD14, 0xAD15, 0xAD16, 0xAD17, 0xAD18, 0xAD19, 0xAD1A, 0xAD1B, 0xAD1C, 	// 0x8237EB39
	0xAD1D, 0xAD1E, 0xAD1F, 0xAD20, 0xAD21, 0xAD22, 0xAD23, 0xAD24, 0xAD25, 0xAD26, 	// 0x8237EC39
	0xAD27, 0xAD28, 0xAD29, 0xAD2A, 0xAD2B, 0xAD2C, 0xAD2D, 0xAD2E, 0xAD2F, 0xAD30, 	// 0x8237ED39
	0xAD31, 0xAD32, 0xAD33, 0xAD34, 0xAD35, 0xAD36, 0xAD37, 0xAD38, 0xAD39, 0xAD3A, 	// 0x8237EE39
	0xAD3B, 0xAD3C, 0xAD3D, 0xAD3E, 0xAD3F, 0xAD40, 0xAD41, 0xAD42, 0xAD43, 0xAD44, 	// 0x8237EF39
	0xAD45, 0xAD46, 0xAD47, 0xAD48, 0xAD49, 0xAD4A, 0xAD4B, 0xAD4C, 0xAD4D, 0xAD4E, 	// 0x8237F039
	0xAD4F, 0xAD50, 0xAD51, 0xAD52, 0xAD53, 0xAD54, 0xAD55, 0xAD56, 0xAD57, 0xAD58, 	// 0x8237F139
	0xAD59, 0xAD5A, 0xAD5B, 0xAD5C, 0xAD5D, 0xAD5E, 0xAD5F, 0xAD60, 0xAD61, 0xAD62, 	// 0x8237F239
	0xAD63, 0xAD64, 0xAD65, 0xAD66, 0xAD67, 0xAD68, 0xAD69, 0xAD6A, 0xAD6B, 0xAD6C, 	// 0x8237F339
	0xAD6D, 0xAD6E, 0xAD6F, 0xAD70, 0xAD71, 0xAD72, 0xAD73, 0xAD74, 0xAD75, 0xAD76, 	// 0x8237F439
	0xAD77, 0xAD78, 0xAD79, 0xAD7A, 0xAD7B, 0xAD7C, 0xAD7D, 0xAD7E, 0xAD7F, 0xAD80, 	// 0x8237F539
	0xAD81, 0xAD82, 0xAD83, 0xAD84, 0xAD85, 0xAD86, 0xAD87, 0xAD88, 0xAD89, 0xAD8A, 	// 0x8237F639
	0xAD8B, 0xAD8C, 0xAD8D, 0xAD8E, 0xAD8F, 0xAD90, 0xAD91, 0xAD92, 0xAD93, 0xAD94, 	// 0x8237F739
	0xAD95, 0xAD96, 0xAD97, 0xAD98, 0xAD99, 0xAD9A, 0xAD9B, 0xAD9C, 0xAD9D, 0xAD9E, 	// 0x8237F839
	0xAD9F, 0xADA0, 0xADA1, 0xADA2, 0xADA3, 0xADA4, 0xADA5, 0xADA6, 0xADA7, 0xADA8, 	// 0x8237F939
	0xADA9, 0xADAA, 0xADAB, 0xADAC, 0xADAD, 0xADAE, 0xADAF, 0xADB0, 0xADB1, 0xADB2, 	// 0x8237FA39
	0xADB3, 0xADB4, 0xADB5, 0xADB6, 0xADB7, 0xADB8, 0xADB9, 0xADBA, 0xADBB, 0xADBC, 	// 0x8237FB39
	0xADBD, 0xADBE, 0xADBF, 0xADC0, 0xADC1, 0xADC2, 0xADC3, 0xADC4, 0xADC5, 0xADC6, 	// 0x8237FC39
	0xADC7, 0xADC8, 0xADC9, 0xADCA, 0xADCB, 0xADCC, 0xADCD, 0xADCE, 0xADCF, 0xADD0, 	// 0x8237FD39
	0xADD1, 0xADD2, 0xADD3, 0xADD4, 0xADD5, 0xADD6, 0xADD7, 0xADD8, 0xADD9, 0xADDA, 	// 0x8237FE39
	0xADDB, 0xADDC, 0xADDD, 0xADDE, 0xADDF, 0xADE0, 0xADE1, 0xADE2, 0xADE3, 0xADE4, 	// 0x82388139
	0xADE5, 0xADE6, 0xADE7, 0xADE8, 0xADE9, 0xADEA, 0xADEB, 0xADEC, 0xADED, 0xADEE, 	// 0x82388239
	0xADEF, 0xADF0, 0xADF1, 0xADF2, 0xADF3, 0xADF4, 0xADF5, 0xADF6, 0xADF7, 0xADF8, 	// 0x82388339
	0xADF9, 0xADFA, 0xADFB, 0xADFC, 0xADFD, 0xADFE, 0xADFF, 0xAE00, 0xAE01, 0xAE02, 	// 0x82388439
	0xAE03, 0xAE04, 0xAE05, 0xAE06, 0xAE07, 0xAE08, 0xAE09, 0xAE0A, 0xAE0B, 0xAE0C, 	// 0x82388539
	0xAE0D, 0xAE0E, 0xAE0F, 0xAE10, 0xAE11, 0xAE12, 0xAE13, 0xAE14, 0xAE15, 0xAE16, 	// 0x82388639
	0xAE17, 0xAE18, 0xAE19, 0xAE1A, 0xAE1B, 0xAE1C, 0xAE1D, 0xAE1E, 0xAE1F, 0xAE20, 	// 0x82388739
	0xAE21, 0xAE22, 0xAE23, 0xAE24, 0xAE25, 0xAE26, 0xAE27, 0xAE28, 0xAE29, 0xAE2A, 	// 0x82388839
	0xAE2B, 0xAE2C, 0xAE2D, 0xAE2E, 0xAE2F, 0xAE30, 0xAE31, 0xAE32, 0xAE33, 0xAE34, 	// 0x82388939
	0xAE35, 0xAE36, 0xAE37, 0xAE38, 0xAE39, 0xAE3A, 0xAE3B, 0xAE3C, 0xAE3D, 0xAE3E, 	// 0x82388A39
	0xAE3F, 0xAE40, 0xAE41, 0xAE42, 0xAE43, 0xAE44, 0xAE45, 0xAE46, 0xAE47, 0xAE48, 	// 0x82388B39
	0xAE49, 0xAE4A, 0xAE4B, 0xAE4C, 0xAE4D, 0xAE4E, 0xAE4F, 0xAE50, 0xAE51, 0xAE52, 	// 0x82388C39
	0xAE53, 0xAE54, 0xAE55, 0xAE56, 0xAE57, 0xAE58, 0xAE59, 0xAE5A, 0xAE5B, 0xAE5C, 	// 0x82388D39
	0xAE5D, 0xAE5E, 0xAE5F, 0xAE60, 0xAE61, 0xAE62, 0xAE63, 0xAE64, 0xAE65, 0xAE66, 	// 0x82388E39
	0xAE67, 0xAE68, 0xAE69, 0xAE6A, 0xAE6B, 0xAE6C, 0xAE6D, 0xAE6E, 0xAE6F, 0xAE70, 	// 0x82388F39
	0xAE71, 0xAE72, 0xAE73, 0xAE74, 0xAE75, 0xAE76, 0xAE77, 0xAE78, 0xAE79, 0xAE7A, 	// 0x82389039
	0xAE7B, 0xAE7C, 0xAE7D, 0xAE7E, 0xAE7F, 0xAE80, 0xAE81, 0xAE82, 0xAE83, 0xAE84, 	// 0x82389139
	0xAE85, 0xAE86, 0xAE87, 0xAE88, 0xAE89, 0xAE8A, 0xAE8B, 0xAE8C, 0xAE8D, 0xAE8E, 	// 0x82389239
	0xAE8F, 0xAE90, 0xAE91, 0xAE92, 0xAE93, 0xAE94, 0xAE95, 0xAE96, 0xAE97, 0xAE98, 	// 0x82389339
	0xAE99, 0xAE9A, 0xAE9B, 0xAE9C, 0xAE9D, 0xAE9E, 0xAE9F, 0xAEA0, 0xAEA1, 0xAEA2, 	// 0x82389439
	0xAEA3, 0xAEA4, 0xAEA5, 0xAEA6, 0xAEA7, 0xAEA8, 0xAEA9, 0xAEAA, 0xAEAB, 0xAEAC, 	// 0x82389539
	0xAEAD, 0xAEAE, 0xAEAF, 0xAEB0, 0xAEB1, 0xAEB2, 0xAEB3, 0xAEB4, 0xAEB5, 0xAEB6, 	// 0x82389639
	0xAEB7, 0xAEB8, 0xAEB9, 0xAEBA, 0xAEBB, 0xAEBC, 0xAEBD, 0xAEBE, 0xAEBF, 0xAEC0, 	// 0x82389739
	0xAEC1, 0xAEC2, 0xAEC3, 0xAEC4, 0xAEC5, 0xAEC6, 0xAEC7, 0xAEC8, 0xAEC9, 0xAECA, 	// 0x82389839
	0xAECB, 0xAECC, 0xAECD, 0xAECE, 0xAECF, 0xAED0, 0xAED1, 0xAED2, 0xAED3, 0xAED4, 	// 0x82389939
	0xAED5, 0xAED6, 0xAED7, 0xAED8, 0xAED9, 0xAEDA, 0xAEDB, 0xAEDC, 0xAEDD, 0xAEDE, 	// 0x82389A39
	0xAEDF, 0xAEE0, 0xAEE1, 0xAEE2, 0xAEE3, 0xAEE4, 0xAEE5, 0xAEE6, 0xAEE7, 0xAEE8, 	// 0x82389B39
	0xAEE9, 0xAEEA, 0xAEEB, 0xAEEC, 0xAEED, 0xAEEE, 0xAEEF, 0xAEF0, 0xAEF1, 0xAEF2, 	// 0x82389C39
	0xAEF3, 0xAEF4, 0xAEF5, 0xAEF6, 0xAEF7, 0xAEF8, 0xAEF9, 0xAEFA, 0xAEFB, 0xAEFC, 	// 0x82389D39
	0xAEFD, 0xAEFE, 0xAEFF, 0xAF00, 0xAF01, 0xAF02, 0xAF03, 0xAF04, 0xAF05, 0xAF06, 	// 0x82389E39
	0xAF07, 0xAF08, 0xAF09, 0xAF0A, 0xAF0B, 0xAF0C, 0xAF0D, 0xAF0E, 0xAF0F, 0xAF10, 	// 0x82389F39
	0xAF11, 0xAF12, 0xAF13, 0xAF14, 0xAF15, 0xAF16, 0xAF17, 0xAF18, 0xAF19, 0xAF1A, 	// 0x8238A039
	0xAF1B, 0xAF1C, 0xAF1D, 0xAF1E, 0xAF1F, 0xAF20, 0xAF21, 0xAF22, 0xAF23, 0xAF24, 	// 0x8238A139
	0xAF25, 0xAF26, 0xAF27, 0xAF28, 0xAF29, 0xAF2A, 0xAF2B, 0xAF2C, 0xAF2D, 0xAF2E, 	// 0x8238A239
	0xAF2F, 0xAF30, 0xAF31, 0xAF32, 0xAF33, 0xAF34, 0xAF35, 0xAF36, 0xAF37, 0xAF38, 	// 0x8238A339
	0xAF39, 0xAF3A, 0xAF3B, 0xAF3C, 0xAF3D, 0xAF3E, 0xAF3F, 0xAF40, 0xAF41, 0xAF42, 	// 0x8238A439
	0xAF43, 0xAF44, 0xAF45, 0xAF46, 0xAF47, 0xAF48, 0xAF49, 0xAF4A, 0xAF4B, 0xAF4C, 	// 0x8238A539
	0xAF4D, 0xAF4E, 0xAF4F, 0xAF50, 0xAF51, 0xAF52, 0xAF53, 0xAF54, 0xAF55, 0xAF56, 	// 0x8238A639
	0xAF57, 0xAF58, 0xAF59, 0xAF5A, 0xAF5B, 0xAF5C, 0xAF5D, 0xAF5E, 0xAF5F, 0xAF60, 	// 0x8238A739
	0xAF61, 0xAF62, 0xAF63, 0xAF64, 0xAF65, 0xAF66, 0xAF67, 0xAF68, 0xAF69, 0xAF6A, 	// 0x8238A839
	0xAF6B, 0xAF6C, 0xAF6D, 0xAF6E, 0xAF6F, 0xAF70, 0xAF71, 0xAF72, 0xAF73, 0xAF74, 	// 0x8238A939
	0xAF75, 0xAF76, 0xAF77, 0xAF78, 0xAF79, 0xAF7A, 0xAF7B, 0xAF7C, 0xAF7D, 0xAF7E, 	// 0x8238AA39
	0xAF7F, 0xAF80, 0xAF81, 0xAF82, 0xAF83, 0xAF84, 0xAF85, 0xAF86, 0xAF87, 0xAF88, 	// 0x8238AB39
	0xAF89, 0xAF8A, 0xAF8B, 0xAF8C, 0xAF8D, 0xAF8E, 0xAF8F, 0xAF90, 0xAF91, 0xAF92, 	// 0x8238AC39
	0xAF93, 0xAF94, 0xAF95, 0xAF96, 0xAF97, 0xAF98, 0xAF99, 0xAF9A, 0xAF9B, 0xAF9C, 	// 0x8238AD39
	0xAF9D, 0xAF9E, 0xAF9F, 0xAFA0, 0xAFA1, 0xAFA2, 0xAFA3, 0xAFA4, 0xAFA5, 0xAFA6, 	// 0x8238AE39
	0xAFA7, 0xAFA8, 0xAFA9, 0xAFAA, 0xAFAB, 0xAFAC, 0xAFAD, 0xAFAE, 0xAFAF, 0xAFB0, 	// 0x8238AF39
	0xAFB1, 0xAFB2, 0xAFB3, 0xAFB4, 0xAFB5, 0xAFB6, 0xAFB7, 0xAFB8, 0xAFB9, 0xAFBA, 	// 0x8238B039
	0xAFBB, 0xAFBC, 0xAFBD, 0xAFBE, 0xAFBF, 0xAFC0, 0xAFC1, 0xAFC2, 0xAFC3, 0xAFC4, 	// 0x8238B139
	0xAFC5, 0xAFC6, 0xAFC7, 0xAFC8, 0xAFC9, 0xAFCA, 0xAFCB, 0xAFCC, 0xAFCD, 0xAFCE, 	// 0x8238B239
	0xAFCF, 0xAFD0, 0xAFD1, 0xAFD2, 0xAFD3, 0xAFD4, 0xAFD5, 0xAFD6, 0xAFD7, 0xAFD8, 	// 0x8238B339
	0xAFD9, 0xAFDA, 0xAFDB, 0xAFDC, 0xAFDD, 0xAFDE, 0xAFDF, 0xAFE0, 0xAFE1, 0xAFE2, 	// 0x8238B439
	0xAFE3, 0xAFE4, 0xAFE5, 0xAFE6, 0xAFE7, 0xAFE8, 0xAFE9, 0xAFEA, 0xAFEB, 0xAFEC, 	// 0x8238B539
	0xAFED, 0xAFEE, 0xAFEF, 0xAFF0, 0xAFF1, 0xAFF2, 0xAFF3, 0xAFF4, 0xAFF5, 0xAFF6, 	// 0x8238B639
	0xAFF7, 0xAFF8, 0xAFF9, 0xAFFA, 0xAFFB, 0xAFFC, 0xAFFD, 0xAFFE, 0xAFFF, 0xB000, 	// 0x8238B739
	0xB001, 0xB002, 0xB003, 0xB004, 0xB005, 0xB006, 0xB007, 0xB008, 0xB009, 0xB00A, 	// 0x8238B839
	0xB00B, 0xB00C, 0xB00D, 0xB00E, 0xB00F, 0xB010, 0xB011, 0xB012, 0xB013, 0xB014, 	// 0x8238B939
	0xB015, 0xB016, 0xB017, 0xB018, 0xB019, 0xB01A, 0xB01B, 0xB01C, 0xB01D, 0xB01E, 	// 0x8238BA39
	0xB01F, 0xB020, 0xB021, 0xB022, 0xB023, 0xB024, 0xB025, 0xB026, 0xB027, 0xB028, 	// 0x8238BB39
	0xB029, 0xB02A, 0xB02B, 0xB02C, 0xB02D, 0xB02E, 0xB02F, 0xB030, 0xB031, 0xB032, 	// 0x8238BC39
	0xB033, 0xB034, 0xB035, 0xB036, 0xB037, 0xB038, 0xB039, 0xB03A, 0xB03B, 0xB03C, 	// 0x8238BD39
	0xB03D, 0xB03E, 0xB03F, 0xB040, 0xB041, 0xB042, 0xB043, 0xB044, 0xB045, 0xB046, 	// 0x8238BE39
	0xB047, 0xB048, 0xB049, 0xB04A, 0xB04B, 0xB04C, 0xB04D, 0xB04E, 0xB04F, 0xB050, 	// 0x8238BF39
	0xB051, 0xB052, 0xB053, 0xB054, 0xB055, 0xB056, 0xB057, 0xB058, 0xB059, 0xB05A, 	// 0x8238C039
	0xB05B, 0xB05C, 0xB05D, 0xB05E, 0xB05F, 0xB060, 0xB061, 0xB062, 0xB063, 0xB064, 	// 0x8238C139
	0xB065, 0xB066, 0xB067, 0xB068, 0xB069, 0xB06A, 0xB06B, 0xB06C, 0xB06D, 0xB06E, 	// 0x8238C239
	0xB06F, 0xB070, 0xB071, 0xB072, 0xB073, 0xB074, 0xB075, 0xB076, 0xB077, 0xB078, 	// 0x8238C339
	0xB079, 0xB07A, 0xB07B, 0xB07C, 0xB07D, 0xB07E, 0xB07F, 0xB080, 0xB081, 0xB082, 	// 0x8238C439
	0xB083, 0xB084, 0xB085, 0xB086, 0xB087, 0xB088, 0xB089, 0xB08A, 0xB08B, 0xB08C, 	// 0x8238C539
	0xB08D, 0xB08E, 0xB08F, 0xB090, 0xB091, 0xB092, 0xB093, 0xB094, 0xB095, 0xB096, 	// 0x8238C639
	0xB097, 0xB098, 0xB099, 0xB09A, 0xB09B, 0xB09C, 0xB09D, 0xB09E, 0xB09F, 0xB0A0, 	// 0x8238C739
	0xB0A1, 0xB0A2, 0xB0A3, 0xB0A4, 0xB0A5, 0xB0A6, 0xB0A7, 0xB0A8, 0xB0A9, 0xB0AA, 	// 0x8238C839
	0xB0AB, 0xB0AC, 0xB0AD, 0xB0AE, 0xB0AF, 0xB0B0, 0xB0B1, 0xB0B2, 0xB0B3, 0xB0B4, 	// 0x8238C939
	0xB0B5, 0xB0B6, 0xB0B7, 0xB0B8, 0xB0B9, 0xB0BA, 0xB0BB, 0xB0BC, 0xB0BD, 0xB0BE, 	// 0x8238CA39
	0xB0BF, 0xB0C0, 0xB0C1, 0xB0C2, 0xB0C3, 0xB0C4, 0xB0C5, 0xB0C6, 0xB0C7, 0xB0C8, 	// 0x8238CB39
	0xB0C9, 0xB0CA, 0xB0CB, 0xB0CC, 0xB0CD, 0xB0CE, 0xB0CF, 0xB0D0, 0xB0D1, 0xB0D2, 	// 0x8238CC39
	0xB0D3, 0xB0D4, 0xB0D5, 0xB0D6, 0xB0D7, 0xB0D8, 0xB0D9, 0xB0DA, 0xB0DB, 0xB0DC, 	// 0x8238CD39
	0xB0DD, 0xB0DE, 0xB0DF, 0xB0E0, 0xB0E1, 0xB0E2, 0xB0E3, 0xB0E4, 0xB0E5, 0xB0E6, 	// 0x8238CE39
	0xB0E7, 0xB0E8, 0xB0E9, 0xB0EA, 0xB0EB, 0xB0EC, 0xB0ED, 0xB0EE, 0xB0EF, 0xB0F0, 	// 0x8238CF39
	0xB0F1, 0xB0F2, 0xB0F3, 0xB0F4, 0xB0F5, 0xB0F6, 0xB0F7, 0xB0F8, 0xB0F9, 0xB0FA, 	// 0x8238D039
	0xB0FB, 0xB0FC, 0xB0FD, 0xB0FE, 0xB0FF, 0xB100, 0xB101, 0xB102, 0xB103, 0xB104, 	// 0x8238D139
	0xB105, 0xB106, 0xB107, 0xB108, 0xB109, 0xB10A, 0xB10B, 0xB10C, 0xB10D, 0xB10E, 	// 0x8238D239
	0xB10F, 0xB110, 0xB111, 0xB112, 0xB113, 0xB114, 0xB115, 0xB116, 0xB117, 0xB118, 	// 0x8238D339
	0xB119, 0xB11A, 0xB11B, 0xB11C, 0xB11D, 0xB11E, 0xB11F, 0xB120, 0xB121, 0xB122, 	// 0x8238D439
	0xB123, 0xB124, 0xB125, 0xB126, 0xB127, 0xB128, 0xB129, 0xB12A, 0xB12B, 0xB12C, 	// 0x8238D539
	0xB12D, 0xB12E, 0xB12F, 0xB130, 0xB131, 0xB132, 0xB133, 0xB134, 0xB135, 0xB136, 	// 0x8238D639
	0xB137, 0xB138, 0xB139, 0xB13A, 0xB13B, 0xB13C, 0xB13D, 0xB13E, 0xB13F, 0xB140, 	// 0x8238D739
	0xB141, 0xB142, 0xB143, 0xB144, 0xB145, 0xB146, 0xB147, 0xB148, 0xB149, 0xB14A, 	// 0x8238D839
	0xB14B, 0xB14C, 0xB14D, 0xB14E, 0xB14F, 0xB150, 0xB151, 0xB152, 0xB153, 0xB154, 	// 0x8238D939
	0xB155, 0xB156, 0xB157, 0xB158, 0xB159, 0xB15A, 0xB15B, 0xB15C, 0xB15D, 0xB15E, 	// 0x8238DA39
	0xB15F, 0xB160, 0xB161, 0xB162, 0xB163, 0xB164, 0xB165, 0xB166, 0xB167, 0xB168, 	// 0x8238DB39
	0xB169, 0xB16A, 0xB16B, 0xB16C, 0xB16D, 0xB16E, 0xB16F, 0xB170, 0xB171, 0xB172, 	// 0x8238DC39
	0xB173, 0xB174, 0xB175, 0xB176, 0xB177, 0xB178, 0xB179, 0xB17A, 0xB17B, 0xB17C, 	// 0x8238DD39
	0xB17D, 0xB17E, 0xB17F, 0xB180, 0xB181, 0xB182, 0xB183, 0xB184, 0xB185, 0xB186, 	// 0x8238DE39
	0xB187, 0xB188, 0xB189, 0xB18A, 0xB18B, 0xB18C, 0xB18D, 0xB18E, 0xB18F, 0xB190, 	// 0x8238DF39
	0xB191, 0xB192, 0xB193, 0xB194, 0xB195, 0xB196, 0xB197, 0xB198, 0xB199, 0xB19A, 	// 0x8238E039
	0xB19B, 0xB19C, 0xB19D, 0xB19E, 0xB19F, 0xB1A0, 0xB1A1, 0xB1A2, 0xB1A3, 0xB1A4, 	// 0x8238E139
	0xB1A5, 0xB1A6, 0xB1A7, 0xB1A8, 0xB1A9, 0xB1AA, 0xB1AB, 0xB1AC, 0xB1AD, 0xB1AE, 	// 0x8238E239
	0xB1AF, 0xB1B0, 0xB1B1, 0xB1B2, 0xB1B3, 0xB1B4, 0xB1B5, 0xB1B6, 0xB1B7, 0xB1B8, 	// 0x8238E339
	0xB1B9, 0xB1BA, 0xB1BB, 0xB1BC, 0xB1BD, 0xB1BE, 0xB1BF, 0xB1C0, 0xB1C1, 0xB1C2, 	// 0x8238E439
	0xB1C3, 0xB1C4, 0xB1C5, 0xB1C6, 0xB1C7, 0xB1C8, 0xB1C9, 0xB1CA, 0xB1CB, 0xB1CC, 	// 0x8238E539
	0xB1CD, 0xB1CE, 0xB1CF, 0xB1D0, 0xB1D1, 0xB1D2, 0xB1D3, 0xB1D4, 0xB1D5, 0xB1D6, 	// 0x8238E639
	0xB1D7, 0xB1D8, 0xB1D9, 0xB1DA, 0xB1DB, 0xB1DC, 0xB1DD, 0xB1DE, 0xB1DF, 0xB1E0, 	// 0x8238E739
	0xB1E1, 0xB1E2, 0xB1E3, 0xB1E4, 0xB1E5, 0xB1E6, 0xB1E7, 0xB1E8, 0xB1E9, 0xB1EA, 	// 0x8238E839
	0xB1EB, 0xB1EC, 0xB1ED, 0xB1EE, 0xB1EF, 0xB1F0, 0xB1F1, 0xB1F2, 0xB1F3, 0xB1F4, 	// 0x8238E939
	0xB1F5, 0xB1F6, 0xB1F7, 0xB1F8, 0xB1F9, 0xB1FA, 0xB1FB, 0xB1FC, 0xB1FD, 0xB1FE, 	// 0x8238EA39
	0xB1FF, 0xB200, 0xB201, 0xB202, 0xB203, 0xB204, 0xB205, 0xB206, 0xB207, 0xB208, 	// 0x8238EB39
	0xB209, 0xB20A, 0xB20B, 0xB20C, 0xB20D, 0xB20E, 0xB20F, 0xB210, 0xB211, 0xB212, 	// 0x8238EC39
	0xB213, 0xB214, 0xB215, 0xB216, 0xB217, 0xB218, 0xB219, 0xB21A, 0xB21B, 0xB21C, 	// 0x8238ED39
	0xB21D, 0xB21E, 0xB21F, 0xB220, 0xB221, 0xB222, 0xB223, 0xB224, 0xB225, 0xB226, 	// 0x8238EE39
	0xB227, 0xB228, 0xB229, 0xB22A, 0xB22B, 0xB22C, 0xB22D, 0xB22E, 0xB22F, 0xB230, 	// 0x8238EF39
	0xB231, 0xB232, 0xB233, 0xB234, 0xB235, 0xB236, 0xB237, 0xB238, 0xB239, 0xB23A, 	// 0x8238F039
	0xB23B, 0xB23C, 0xB23D, 0xB23E, 0xB23F, 0xB240, 0xB241, 0xB242, 0xB243, 0xB244, 	// 0x8238F139
	0xB245, 0xB246, 0xB247, 0xB248, 0xB249, 0xB24A, 0xB24B, 0xB24C, 0xB24D, 0xB24E, 	// 0x8238F239
	0xB24F, 0xB250, 0xB251, 0xB252, 0xB253, 0xB254, 0xB255, 0xB256, 0xB257, 0xB258, 	// 0x8238F339
	0xB259, 0xB25A, 0xB25B, 0xB25C, 0xB25D, 0xB25E, 0xB25F, 0xB260, 0xB261, 0xB262, 	// 0x8238F439
	0xB263, 0xB264, 0xB265, 0xB266, 0xB267, 0xB268, 0xB269, 0xB26A, 0xB26B, 0xB26C, 	// 0x8238F539
	0xB26D, 0xB26E, 0xB26F, 0xB270, 0xB271, 0xB272, 0xB273, 0xB274, 0xB275, 0xB276, 	// 0x8238F639
	0xB277, 0xB278, 0xB279, 0xB27A, 0xB27B, 0xB27C, 0xB27D, 0xB27E, 0xB27F, 0xB280, 	// 0x8238F739
	0xB281, 0xB282, 0xB283, 0xB284, 0xB285, 0xB286, 0xB287, 0xB288, 0xB289, 0xB28A, 	// 0x8238F839
	0xB28B, 0xB28C, 0xB28D, 0xB28E, 0xB28F, 0xB290, 0xB291, 0xB292, 0xB293, 0xB294, 	// 0x8238F939
	0xB295, 0xB296, 0xB297, 0xB298, 0xB299, 0xB29A, 0xB29B, 0xB29C, 0xB29D, 0xB29E, 	// 0x8238FA39
	0xB29F, 0xB2A0, 0xB2A1, 0xB2A2, 0xB2A3, 0xB2A4, 0xB2A5, 0xB2A6, 0xB2A7, 0xB2A8, 	// 0x8238FB39
	0xB2A9, 0xB2AA, 0xB2AB, 0xB2AC, 0xB2AD, 0xB2AE, 0xB2AF, 0xB2B0, 0xB2B1, 0xB2B2, 	// 0x8238FC39
	0xB2B3, 0xB2B4, 0xB2B5, 0xB2B6, 0xB2B7, 0xB2B8, 0xB2B9, 0xB2BA, 0xB2BB, 0xB2BC, 	// 0x8238FD39
	0xB2BD, 0xB2BE, 0xB2BF, 0xB2C0, 0xB2C1, 0xB2C2, 0xB2C3, 0xB2C4, 0xB2C5, 0xB2C6, 	// 0x8238FE39
	0xB2C7, 0xB2C8, 0xB2C9, 0xB2CA, 0xB2CB, 0xB2CC, 0xB2CD, 0xB2CE, 0xB2CF, 0xB2D0, 	// 0x82398139
	0xB2D1, 0xB2D2, 0xB2D3, 0xB2D4, 0xB2D5, 0xB2D6, 0xB2D7, 0xB2D8, 0xB2D9, 0xB2DA, 	// 0x82398239
	0xB2DB, 0xB2DC, 0xB2DD, 0xB2DE, 0xB2DF, 0xB2E0, 0xB2E1, 0xB2E2, 0xB2E3, 0xB2E4, 	// 0x82398339
	0xB2E5, 0xB2E6, 0xB2E7, 0xB2E8, 0xB2E9, 0xB2EA, 0xB2EB, 0xB2EC, 0xB2ED, 0xB2EE, 	// 0x82398439
	0xB2EF, 0xB2F0, 0xB2F1, 0xB2F2, 0xB2F3, 0xB2F4, 0xB2F5, 0xB2F6, 0xB2F7, 0xB2F8, 	// 0x82398539
	0xB2F9, 0xB2FA, 0xB2FB, 0xB2FC, 0xB2FD, 0xB2FE, 0xB2FF, 0xB300, 0xB301, 0xB302, 	// 0x82398639
	0xB303, 0xB304, 0xB305, 0xB306, 0xB307, 0xB308, 0xB309, 0xB30A, 0xB30B, 0xB30C, 	// 0x82398739
	0xB30D, 0xB30E, 0xB30F, 0xB310, 0xB311, 0xB312, 0xB313, 0xB314, 0xB315, 0xB316, 	// 0x82398839
	0xB317, 0xB318, 0xB319, 0xB31A, 0xB31B, 0xB31C, 0xB31D, 0xB31E, 0xB31F, 0xB320, 	// 0x82398939
	0xB321, 0xB322, 0xB323, 0xB324, 0xB325, 0xB326, 0xB327, 0xB328, 0xB329, 0xB32A, 	// 0x82398A39
	0xB32B, 0xB32C, 0xB32D, 0xB32E, 0xB32F, 0xB330, 0xB331, 0xB332, 0xB333, 0xB334, 	// 0x82398B39
	0xB335, 0xB336, 0xB337, 0xB338, 0xB339, 0xB33A, 0xB33B, 0xB33C, 0xB33D, 0xB33E, 	// 0x82398C39
	0xB33F, 0xB340, 0xB341, 0xB342, 0xB343, 0xB344, 0xB345, 0xB346, 0xB347, 0xB348, 	// 0x82398D39
	0xB349, 0xB34A, 0xB34B, 0xB34C, 0xB34D, 0xB34E, 0xB34F, 0xB350, 0xB351, 0xB352, 	// 0x82398E39
	0xB353, 0xB354, 0xB355, 0xB356, 0xB357, 0xB358, 0xB359, 0xB35A, 0xB35B, 0xB35C, 	// 0x82398F39
	0xB35D, 0xB35E, 0xB35F, 0xB360, 0xB361, 0xB362, 0xB363, 0xB364, 0xB365, 0xB366, 	// 0x82399039
	0xB367, 0xB368, 0xB369, 0xB36A, 0xB36B, 0xB36C, 0xB36D, 0xB36E, 0xB36F, 0xB370, 	// 0x82399139
	0xB371, 0xB372, 0xB373, 0xB374, 0xB375, 0xB376, 0xB377, 0xB378, 0xB379, 0xB37A, 	// 0x82399239
	0xB37B, 0xB37C, 0xB37D, 0xB37E, 0xB37F, 0xB380, 0xB381, 0xB382, 0xB383, 0xB384, 	// 0x82399339
	0xB385, 0xB386, 0xB387, 0xB388, 0xB389, 0xB38A, 0xB38B, 0xB38C, 0xB38D, 0xB38E, 	// 0x82399439
	0xB38F, 0xB390, 0xB391, 0xB392, 0xB393, 0xB394, 0xB395, 0xB396, 0xB397, 0xB398, 	// 0x82399539
	0xB399, 0xB39A, 0xB39B, 0xB39C, 0xB39D, 0xB39E, 0xB39F, 0xB3A0, 0xB3A1, 0xB3A2, 	// 0x82399639
	0xB3A3, 0xB3A4, 0xB3A5, 0xB3A6, 0xB3A7, 0xB3A8, 0xB3A9, 0xB3AA, 0xB3AB, 0xB3AC, 	// 0x82399739
	0xB3AD, 0xB3AE, 0xB3AF, 0xB3B0, 0xB3B1, 0xB3B2, 0xB3B3, 0xB3B4, 0xB3B5, 0xB3B6, 	// 0x82399839
	0xB3B7, 0xB3B8, 0xB3B9, 0xB3BA, 0xB3BB, 0xB3BC, 0xB3BD, 0xB3BE, 0xB3BF, 0xB3C0, 	// 0x82399939
	0xB3C1, 0xB3C2, 0xB3C3, 0xB3C4, 0xB3C5, 0xB3C6, 0xB3C7, 0xB3C8, 0xB3C9, 0xB3CA, 	// 0x82399A39
	0xB3CB, 0xB3CC, 0xB3CD, 0xB3CE, 0xB3CF, 0xB3D0, 0xB3D1, 0xB3D2, 0xB3D3, 0xB3D4, 	// 0x82399B39
	0xB3D5, 0xB3D6, 0xB3D7, 0xB3D8, 0xB3D9, 0xB3DA, 0xB3DB, 0xB3DC, 0xB3DD, 0xB3DE, 	// 0x82399C39
	0xB3DF, 0xB3E0, 0xB3E1, 0xB3E2, 0xB3E3, 0xB3E4, 0xB3E5, 0xB3E6, 0xB3E7, 0xB3E8, 	// 0x82399D39
	0xB3E9, 0xB3EA, 0xB3EB, 0xB3EC, 0xB3ED, 0xB3EE, 0xB3EF, 0xB3F0, 0xB3F1, 0xB3F2, 	// 0x82399E39
	0xB3F3, 0xB3F4, 0xB3F5, 0xB3F6, 0xB3F7, 0xB3F8, 0xB3F9, 0xB3FA, 0xB3FB, 0xB3FC, 	// 0x82399F39
	0xB3FD, 0xB3FE, 0xB3FF, 0xB400, 0xB401, 0xB402, 0xB403, 0xB404, 0xB405, 0xB406, 	// 0x8239A039
	0xB407, 0xB408, 0xB409, 0xB40A, 0xB40B, 0xB40C, 0xB40D, 0xB40E, 0xB40F, 0xB410, 	// 0x8239A139
	0xB411, 0xB412, 0xB413, 0xB414, 0xB415, 0xB416, 0xB417, 0xB418, 0xB419, 0xB41A, 	// 0x8239A239
	0xB41B, 0xB41C, 0xB41D, 0xB41E, 0xB41F, 0xB420, 0xB421, 0xB422, 0xB423, 0xB424, 	// 0x8239A339
	0xB425, 0xB426, 0xB427, 0xB428, 0xB429, 0xB42A, 0xB42B, 0xB42C, 0xB42D, 0xB42E, 	// 0x8239A439
	0xB42F, 0xB430, 0xB431, 0xB432, 0xB433, 0xB434, 0xB435, 0xB436, 0xB437, 0xB438, 	// 0x8239A539
	0xB439, 0xB43A, 0xB43B, 0xB43C, 0xB43D, 0xB43E, 0xB43F, 0xB440, 0xB441, 0xB442, 	// 0x8239A639
	0xB443, 0xB444, 0xB445, 0xB446, 0xB447, 0xB448, 0xB449, 0xB44A, 0xB44B, 0xB44C, 	// 0x8239A739
	0xB44D, 0xB44E, 0xB44F, 0xB450, 0xB451, 0xB452, 0xB453, 0xB454, 0xB455, 0xB456, 	// 0x8239A839
	0xB457, 0xB458, 0xB459, 0xB45A, 0xB45B, 0xB45C, 0xB45D, 0xB45E, 0xB45F, 0xB460, 	// 0x8239A939
	0xB461, 0xB462, 0xB463, 0xB464, 0xB465, 0xB466, 0xB467, 0xB468, 0xB469, 0xB46A, 	// 0x8239AA39
	0xB46B, 0xB46C, 0xB46D, 0xB46E, 0xB46F, 0xB470, 0xB471, 0xB472, 0xB473, 0xB474, 	// 0x8239AB39
	0xB475, 0xB476, 0xB477, 0xB478, 0xB479, 0xB47A, 0xB47B, 0xB47C, 0xB47D, 0xB47E, 	// 0x8239AC39
	0xB47F, 0xB480, 0xB481, 0xB482, 0xB483, 0xB484, 0xB485, 0xB486, 0xB487, 0xB488, 	// 0x8239AD39
	0xB489, 0xB48A, 0xB48B, 0xB48C, 0xB48D, 0xB48E, 0xB48F, 0xB490, 0xB491, 0xB492, 	// 0x8239AE39
	0xB493, 0xB494, 0xB495, 0xB496, 0xB497, 0xB498, 0xB499, 0xB49A, 0xB49B, 0xB49C, 	// 0x8239AF39
	0xB49D, 0xB49E, 0xB49F, 0xB4A0, 0xB4A1, 0xB4A2, 0xB4A3, 0xB4A4, 0xB4A5, 0xB4A6, 	// 0x8239B039
	0xB4A7, 0xB4A8, 0xB4A9, 0xB4AA, 0xB4AB, 0xB4AC, 0xB4AD, 0xB4AE, 0xB4AF, 0xB4B0, 	// 0x8239B139
	0xB4B1, 0xB4B2, 0xB4B3, 0xB4B4, 0xB4B5, 0xB4B6, 0xB4B7, 0xB4B8, 0xB4B9, 0xB4BA, 	// 0x8239B239
	0xB4BB, 0xB4BC, 0xB4BD, 0xB4BE, 0xB4BF, 0xB4C0, 0xB4C1, 0xB4C2, 0xB4C3, 0xB4C4, 	// 0x8239B339
	0xB4C5, 0xB4C6, 0xB4C7, 0xB4C8, 0xB4C9, 0xB4CA, 0xB4CB, 0xB4CC, 0xB4CD, 0xB4CE, 	// 0x8239B439
	0xB4CF, 0xB4D0, 0xB4D1, 0xB4D2, 0xB4D3, 0xB4D4, 0xB4D5, 0xB4D6, 0xB4D7, 0xB4D8, 	// 0x8239B539
	0xB4D9, 0xB4DA, 0xB4DB, 0xB4DC, 0xB4DD, 0xB4DE, 0xB4DF, 0xB4E0, 0xB4E1, 0xB4E2, 	// 0x8239B639
	0xB4E3, 0xB4E4, 0xB4E5, 0xB4E6, 0xB4E7, 0xB4E8, 0xB4E9, 0xB4EA, 0xB4EB, 0xB4EC, 	// 0x8239B739
	0xB4ED, 0xB4EE, 0xB4EF, 0xB4F0, 0xB4F1, 0xB4F2, 0xB4F3, 0xB4F4, 0xB4F5, 0xB4F6, 	// 0x8239B839
	0xB4F7, 0xB4F8, 0xB4F9, 0xB4FA, 0xB4FB, 0xB4FC, 0xB4FD, 0xB4FE, 0xB4FF, 0xB500, 	// 0x8239B939
	0xB501, 0xB502, 0xB503, 0xB504, 0xB505, 0xB506, 0xB507, 0xB508, 0xB509, 0xB50A, 	// 0x8239BA39
	0xB50B, 0xB50C, 0xB50D, 0xB50E, 0xB50F, 0xB510, 0xB511, 0xB512, 0xB513, 0xB514, 	// 0x8239BB39
	0xB515, 0xB516, 0xB517, 0xB518, 0xB519, 0xB51A, 0xB51B, 0xB51C, 0xB51D, 0xB51E, 	// 0x8239BC39
	0xB51F, 0xB520, 0xB521, 0xB522, 0xB523, 0xB524, 0xB525, 0xB526, 0xB527, 0xB528, 	// 0x8239BD39
	0xB529, 0xB52A, 0xB52B, 0xB52C, 0xB52D, 0xB52E, 0xB52F, 0xB530, 0xB531, 0xB532, 	// 0x8239BE39
	0xB533, 0xB534, 0xB535, 0xB536, 0xB537, 0xB538, 0xB539, 0xB53A, 0xB53B, 0xB53C, 	// 0x8239BF39
	0xB53D, 0xB53E, 0xB53F, 0xB540, 0xB541, 0xB542, 0xB543, 0xB544, 0xB545, 0xB546, 	// 0x8239C039
	0xB547, 0xB548, 0xB549, 0xB54A, 0xB54B, 0xB54C, 0xB54D, 0xB54E, 0xB54F, 0xB550, 	// 0x8239C139
	0xB551, 0xB552, 0xB553, 0xB554, 0xB555, 0xB556, 0xB557, 0xB558, 0xB559, 0xB55A, 	// 0x8239C239
	0xB55B, 0xB55C, 0xB55D, 0xB55E, 0xB55F, 0xB560, 0xB561, 0xB562, 0xB563, 0xB564, 	// 0x8239C339
	0xB565, 0xB566, 0xB567, 0xB568, 0xB569, 0xB56A, 0xB56B, 0xB56C, 0xB56D, 0xB56E, 	// 0x8239C439
	0xB56F, 0xB570, 0xB571, 0xB572, 0xB573, 0xB574, 0xB575, 0xB576, 0xB577, 0xB578, 	// 0x8239C539
	0xB579, 0xB57A, 0xB57B, 0xB57C, 0xB57D, 0xB57E, 0xB57F, 0xB580, 0xB581, 0xB582, 	// 0x8239C639
	0xB583, 0xB584, 0xB585, 0xB586, 0xB587, 0xB588, 0xB589, 0xB58A, 0xB58B, 0xB58C, 	// 0x8239C739
	0xB58D, 0xB58E, 0xB58F, 0xB590, 0xB591, 0xB592, 0xB593, 0xB594, 0xB595, 0xB596, 	// 0x8239C839
	0xB597, 0xB598, 0xB599, 0xB59A, 0xB59B, 0xB59C, 0xB59D, 0xB59E, 0xB59F, 0xB5A0, 	// 0x8239C939
	0xB5A1, 0xB5A2, 0xB5A3, 0xB5A4, 0xB5A5, 0xB5A6, 0xB5A7, 0xB5A8, 0xB5A9, 0xB5AA, 	// 0x8239CA39
	0xB5AB, 0xB5AC, 0xB5AD, 0xB5AE, 0xB5AF, 0xB5B0, 0xB5B1, 0xB5B2, 0xB5B3, 0xB5B4, 	// 0x8239CB39
	0xB5B5, 0xB5B6, 0xB5B7, 0xB5B8, 0xB5B9, 0xB5BA, 0xB5BB, 0xB5BC, 0xB5BD, 0xB5BE, 	// 0x8239CC39
	0xB5BF, 0xB5C0, 0xB5C1, 0xB5C2, 0xB5C3, 0xB5C4, 0xB5C5, 0xB5C6, 0xB5C7, 0xB5C8, 	// 0x8239CD39
	0xB5C9, 0xB5CA, 0xB5CB, 0xB5CC, 0xB5CD, 0xB5CE, 0xB5CF, 0xB5D0, 0xB5D1, 0xB5D2, 	// 0x8239CE39
	0xB5D3, 0xB5D4, 0xB5D5, 0xB5D6, 0xB5D7, 0xB5D8, 0xB5D9, 0xB5DA, 0xB5DB, 0xB5DC, 	// 0x8239CF39
	0xB5DD, 0xB5DE, 0xB5DF, 0xB5E0, 0xB5E1, 0xB5E2, 0xB5E3, 0xB5E4, 0xB5E5, 0xB5E6, 	// 0x8239D039
	0xB5E7, 0xB5E8, 0xB5E9, 0xB5EA, 0xB5EB, 0xB5EC, 0xB5ED, 0xB5EE, 0xB5EF, 0xB5F0, 	// 0x8239D139
	0xB5F1, 0xB5F2, 0xB5F3, 0xB5F4, 0xB5F5, 0xB5F6, 0xB5F7, 0xB5F8, 0xB5F9, 0xB5FA, 	// 0x8239D239
	0xB5FB, 0xB5FC, 0xB5FD, 0xB5FE, 0xB5FF, 0xB600, 0xB601, 0xB602, 0xB603, 0xB604, 	// 0x8239D339
	0xB605, 0xB606, 0xB607, 0xB608, 0xB609, 0xB60A, 0xB60B, 0xB60C, 0xB60D, 0xB60E, 	// 0x8239D439
	0xB60F, 0xB610, 0xB611, 0xB612, 0xB613, 0xB614, 0xB615, 0xB616, 0xB617, 0xB618, 	// 0x8239D539
	0xB619, 0xB61A, 0xB61B, 0xB61C, 0xB61D, 0xB61E, 0xB61F, 0xB620, 0xB621, 0xB622, 	// 0x8239D639
	0xB623, 0xB624, 0xB625, 0xB626, 0xB627, 0xB628, 0xB629, 0xB62A, 0xB62B, 0xB62C, 	// 0x8239D739
	0xB62D, 0xB62E, 0xB62F, 0xB630, 0xB631, 0xB632, 0xB633, 0xB634, 0xB635, 0xB636, 	// 0x8239D839
	0xB637, 0xB638, 0xB639, 0xB63A, 0xB63B, 0xB63C, 0xB63D, 0xB63E, 0xB63F, 0xB640, 	// 0x8239D939
	0xB641, 0xB642, 0xB643, 0xB644, 0xB645, 0xB646, 0xB647, 0xB648, 0xB649, 0xB64A, 	// 0x8239DA39
	0xB64B, 0xB64C, 0xB64D, 0xB64E, 0xB64F, 0xB650, 0xB651, 0xB652, 0xB653, 0xB654, 	// 0x8239DB39
	0xB655, 0xB656, 0xB657, 0xB658, 0xB659, 0xB65A, 0xB65B, 0xB65C, 0xB65D, 0xB65E, 	// 0x8239DC39
	0xB65F, 0xB660, 0xB661, 0xB662, 0xB663, 0xB664, 0xB665, 0xB666, 0xB667, 0xB668, 	// 0x8239DD39
	0xB669, 0xB66A, 0xB66B, 0xB66C, 0xB66D, 0xB66E, 0xB66F, 0xB670, 0xB671, 0xB672, 	// 0x8239DE39
	0xB673, 0xB674, 0xB675, 0xB676, 0xB677, 0xB678, 0xB679, 0xB67A, 0xB67B, 0xB67C, 	// 0x8239DF39
	0xB67D, 0xB67E, 0xB67F, 0xB680, 0xB681, 0xB682, 0xB683, 0xB684, 0xB685, 0xB686, 	// 0x8239E039
	0xB687, 0xB688, 0xB689, 0xB68A, 0xB68B, 0xB68C, 0xB68D, 0xB68E, 0xB68F, 0xB690, 	// 0x8239E139
	0xB691, 0xB692, 0xB693, 0xB694, 0xB695, 0xB696, 0xB697, 0xB698, 0xB699, 0xB69A, 	// 0x8239E239
	0xB69B, 0xB69C, 0xB69D, 0xB69E, 0xB69F, 0xB6A0, 0xB6A1, 0xB6A2, 0xB6A3, 0xB6A4, 	// 0x8239E339
	0xB6A5, 0xB6A6, 0xB6A7, 0xB6A8, 0xB6A9, 0xB6AA, 0xB6AB, 0xB6AC, 0xB6AD, 0xB6AE, 	// 0x8239E439
	0xB6AF, 0xB6B0, 0xB6B1, 0xB6B2, 0xB6B3, 0xB6B4, 0xB6B5, 0xB6B6, 0xB6B7, 0xB6B8, 	// 0x8239E539
	0xB6B9, 0xB6BA, 0xB6BB, 0xB6BC, 0xB6BD, 0xB6BE, 0xB6BF, 0xB6C0, 0xB6C1, 0xB6C2, 	// 0x8239E639
	0xB6C3, 0xB6C4, 0xB6C5, 0xB6C6, 0xB6C7, 0xB6C8, 0xB6C9, 0xB6CA, 0xB6CB, 0xB6CC, 	// 0x8239E739
	0xB6CD, 0xB6CE, 0xB6CF, 0xB6D0, 0xB6D1, 0xB6D2, 0xB6D3, 0xB6D4, 0xB6D5, 0xB6D6, 	// 0x8239E839
	0xB6D7, 0xB6D8, 0xB6D9, 0xB6DA, 0xB6DB, 0xB6DC, 0xB6DD, 0xB6DE, 0xB6DF, 0xB6E0, 	// 0x8239E939
	0xB6E1, 0xB6E2, 0xB6E3, 0xB6E4, 0xB6E5, 0xB6E6, 0xB6E7, 0xB6E8, 0xB6E9, 0xB6EA, 	// 0x8239EA39
	0xB6EB, 0xB6EC, 0xB6ED, 0xB6EE, 0xB6EF, 0xB6F0, 0xB6F1, 0xB6F2, 0xB6F3, 0xB6F4, 	// 0x8239EB39
	0xB6F5, 0xB6F6, 0xB6F7, 0xB6F8, 0xB6F9, 0xB6FA, 0xB6FB, 0xB6FC, 0xB6FD, 0xB6FE, 	// 0x8239EC39
	0xB6FF, 0xB700, 0xB701, 0xB702, 0xB703, 0xB704, 0xB705, 0xB706, 0xB707, 0xB708, 	// 0x8239ED39
	0xB709, 0xB70A, 0xB70B, 0xB70C, 0xB70D, 0xB70E, 0xB70F, 0xB710, 0xB711, 0xB712, 	// 0x8239EE39
	0xB713, 0xB714, 0xB715, 0xB716, 0xB717, 0xB718, 0xB719, 0xB71A, 0xB71B, 0xB71C, 	// 0x8239EF39
	0xB71D, 0xB71E, 0xB71F, 0xB720, 0xB721, 0xB722, 0xB723, 0xB724, 0xB725, 0xB726, 	// 0x8239F039
	0xB727, 0xB728, 0xB729, 0xB72A, 0xB72B, 0xB72C, 0xB72D, 0xB72E, 0xB72F, 0xB730, 	// 0x8239F139
	0xB731, 0xB732, 0xB733, 0xB734, 0xB735, 0xB736, 0xB737, 0xB738, 0xB739, 0xB73A, 	// 0x8239F239
	0xB73B, 0xB73C, 0xB73D, 0xB73E, 0xB73F, 0xB740, 0xB741, 0xB742, 0xB743, 0xB744, 	// 0x8239F339
	0xB745, 0xB746, 0xB747, 0xB748, 0xB749, 0xB74A, 0xB74B, 0xB74C, 0xB74D, 0xB74E, 	// 0x8239F439
	0xB74F, 0xB750, 0xB751, 0xB752, 0xB753, 0xB754, 0xB755, 0xB756, 0xB757, 0xB758, 	// 0x8239F539
	0xB759, 0xB75A, 0xB75B, 0xB75C, 0xB75D, 0xB75E, 0xB75F, 0xB760, 0xB761, 0xB762, 	// 0x8239F639
	0xB763, 0xB764, 0xB765, 0xB766, 0xB767, 0xB768, 0xB769, 0xB76A, 0xB76B, 0xB76C, 	// 0x8239F739
	0xB76D, 0xB76E, 0xB76F, 0xB770, 0xB771, 0xB772, 0xB773, 0xB774, 0xB775, 0xB776, 	// 0x8239F839
	0xB777, 0xB778, 0xB779, 0xB77A, 0xB77B, 0xB77C, 0xB77D, 0xB77E, 0xB77F, 0xB780, 	// 0x8239F939
	0xB781, 0xB782, 0xB783, 0xB784, 0xB785, 0xB786, 0xB787, 0xB788, 0xB789, 0xB78A, 	// 0x8239FA39
	0xB78B, 0xB78C, 0xB78D, 0xB78E, 0xB78F, 0xB790, 0xB791, 0xB792, 0xB793, 0xB794, 	// 0x8239FB39
	0xB795, 0xB796, 0xB797, 0xB798, 0xB799, 0xB79A, 0xB79B, 0xB79C, 0xB79D, 0xB79E, 	// 0x8239FC39
	0xB79F, 0xB7A0, 0xB7A1, 0xB7A2, 0xB7A3, 0xB7A4, 0xB7A5, 0xB7A6, 0xB7A7, 0xB7A8, 	// 0x8239FD39
	0xB7A9, 0xB7AA, 0xB7AB, 0xB7AC, 0xB7AD, 0xB7AE, 0xB7AF, 0xB7B0, 0xB7B1, 0xB7B2, 	// 0x8239FE39
	0xB7B3, 0xB7B4, 0xB7B5, 0xB7B6, 0xB7B7, 0xB7B8, 0xB7B9, 0xB7BA, 0xB7BB, 0xB7BC, 	// 0x83308139
	0xB7BD, 0xB7BE, 0xB7BF, 0xB7C0, 0xB7C1, 0xB7C2, 0xB7C3, 0xB7C4, 0xB7C5, 0xB7C6, 	// 0x83308239
	0xB7C7, 0xB7C8, 0xB7C9, 0xB7CA, 0xB7CB, 0xB7CC, 0xB7CD, 0xB7CE, 0xB7CF, 0xB7D0, 	// 0x83308339
	0xB7D1, 0xB7D2, 0xB7D3, 0xB7D4, 0xB7D5, 0xB7D6, 0xB7D7, 0xB7D8, 0xB7D9, 0xB7DA, 	// 0x83308439
	0xB7DB, 0xB7DC, 0xB7DD, 0xB7DE, 0xB7DF, 0xB7E0, 0xB7E1, 0xB7E2, 0xB7E3, 0xB7E4, 	// 0x83308539
	0xB7E5, 0xB7E6, 0xB7E7, 0xB7E8, 0xB7E9, 0xB7EA, 0xB7EB, 0xB7EC, 0xB7ED, 0xB7EE, 	// 0x83308639
	0xB7EF, 0xB7F0, 0xB7F1, 0xB7F2, 0xB7F3, 0xB7F4, 0xB7F5, 0xB7F6, 0xB7F7, 0xB7F8, 	// 0x83308739
	0xB7F9, 0xB7FA, 0xB7FB, 0xB7FC, 0xB7FD, 0xB7FE, 0xB7FF, 0xB800, 0xB801, 0xB802, 	// 0x83308839
	0xB803, 0xB804, 0xB805, 0xB806, 0xB807, 0xB808, 0xB809, 0xB80A, 0xB80B, 0xB80C, 	// 0x83308939
	0xB80D, 0xB80E, 0xB80F, 0xB810, 0xB811, 0xB812, 0xB813, 0xB814, 0xB815, 0xB816, 	// 0x83308A39
	0xB817, 0xB818, 0xB819, 0xB81A, 0xB81B, 0xB81C, 0xB81D, 0xB81E, 0xB81F, 0xB820, 	// 0x83308B39
	0xB821, 0xB822, 0xB823, 0xB824, 0xB825, 0xB826, 0xB827, 0xB828, 0xB829, 0xB82A, 	// 0x83308C39
	0xB82B, 0xB82C, 0xB82D, 0xB82E, 0xB82F, 0xB830, 0xB831, 0xB832, 0xB833, 0xB834, 	// 0x83308D39
	0xB835, 0xB836, 0xB837, 0xB838, 0xB839, 0xB83A, 0xB83B, 0xB83C, 0xB83D, 0xB83E, 	// 0x83308E39
	0xB83F, 0xB840, 0xB841, 0xB842, 0xB843, 0xB844, 0xB845, 0xB846, 0xB847, 0xB848, 	// 0x83308F39
	0xB849, 0xB84A, 0xB84B, 0xB84C, 0xB84D, 0xB84E, 0xB84F, 0xB850, 0xB851, 0xB852, 	// 0x83309039
	0xB853, 0xB854, 0xB855, 0xB856, 0xB857, 0xB858, 0xB859, 0xB85A, 0xB85B, 0xB85C, 	// 0x83309139
	0xB85D, 0xB85E, 0xB85F, 0xB860, 0xB861, 0xB862, 0xB863, 0xB864, 0xB865, 0xB866, 	// 0x83309239
	0xB867, 0xB868, 0xB869, 0xB86A, 0xB86B, 0xB86C, 0xB86D, 0xB86E, 0xB86F, 0xB870, 	// 0x83309339
	0xB871, 0xB872, 0xB873, 0xB874, 0xB875, 0xB876, 0xB877, 0xB878, 0xB879, 0xB87A, 	// 0x83309439
	0xB87B, 0xB87C, 0xB87D, 0xB87E, 0xB87F, 0xB880, 0xB881, 0xB882, 0xB883, 0xB884, 	// 0x83309539
	0xB885, 0xB886, 0xB887, 0xB888, 0xB889, 0xB88A, 0xB88B, 0xB88C, 0xB88D, 0xB88E, 	// 0x83309639
	0xB88F, 0xB890, 0xB891, 0xB892, 0xB893, 0xB894, 0xB895, 0xB896, 0xB897, 0xB898, 	// 0x83309739
	0xB899, 0xB89A, 0xB89B, 0xB89C, 0xB89D, 0xB89E, 0xB89F, 0xB8A0, 0xB8A1, 0xB8A2, 	// 0x83309839
	0xB8A3, 0xB8A4, 0xB8A5, 0xB8A6, 0xB8A7, 0xB8A8, 0xB8A9, 0xB8AA, 0xB8AB, 0xB8AC, 	// 0x83309939
	0xB8AD, 0xB8AE, 0xB8AF, 0xB8B0, 0xB8B1, 0xB8B2, 0xB8B3, 0xB8B4, 0xB8B5, 0xB8B6, 	// 0x83309A39
	0xB8B7, 0xB8B8, 0xB8B9, 0xB8BA, 0xB8BB, 0xB8BC, 0xB8BD, 0xB8BE, 0xB8BF, 0xB8C0, 	// 0x83309B39
	0xB8C1, 0xB8C2, 0xB8C3, 0xB8C4, 0xB8C5, 0xB8C6, 0xB8C7, 0xB8C8, 0xB8C9, 0xB8CA, 	// 0x83309C39
	0xB8CB, 0xB8CC, 0xB8CD, 0xB8CE, 0xB8CF, 0xB8D0, 0xB8D1, 0xB8D2, 0xB8D3, 0xB8D4, 	// 0x83309D39
	0xB8D5, 0xB8D6, 0xB8D7, 0xB8D8, 0xB8D9, 0xB8DA, 0xB8DB, 0xB8DC, 0xB8DD, 0xB8DE, 	// 0x83309E39
	0xB8DF, 0xB8E0, 0xB8E1, 0xB8E2, 0xB8E3, 0xB8E4, 0xB8E5, 0xB8E6, 0xB8E7, 0xB8E8, 	// 0x83309F39
	0xB8E9, 0xB8EA, 0xB8EB, 0xB8EC, 0xB8ED, 0xB8EE, 0xB8EF, 0xB8F0, 0xB8F1, 0xB8F2, 	// 0x8330A039
	0xB8F3, 0xB8F4, 0xB8F5, 0xB8F6, 0xB8F7, 0xB8F8, 0xB8F9, 0xB8FA, 0xB8FB, 0xB8FC, 	// 0x8330A139
	0xB8FD, 0xB8FE, 0xB8FF, 0xB900, 0xB901, 0xB902, 0xB903, 0xB904, 0xB905, 0xB906, 	// 0x8330A239
	0xB907, 0xB908, 0xB909, 0xB90A, 0xB90B, 0xB90C, 0xB90D, 0xB90E, 0xB90F, 0xB910, 	// 0x8330A339
	0xB911, 0xB912, 0xB913, 0xB914, 0xB915, 0xB916, 0xB917, 0xB918, 0xB919, 0xB91A, 	// 0x8330A439
	0xB91B, 0xB91C, 0xB91D, 0xB91E, 0xB91F, 0xB920, 0xB921, 0xB922, 0xB923, 0xB924, 	// 0x8330A539
	0xB925, 0xB926, 0xB927, 0xB928, 0xB929, 0xB92A, 0xB92B, 0xB92C, 0xB92D, 0xB92E, 	// 0x8330A639
	0xB92F, 0xB930, 0xB931, 0xB932, 0xB933, 0xB934, 0xB935, 0xB936, 0xB937, 0xB938, 	// 0x8330A739
	0xB939, 0xB93A, 0xB93B, 0xB93C, 0xB93D, 0xB93E, 0xB93F, 0xB940, 0xB941, 0xB942, 	// 0x8330A839
	0xB943, 0xB944, 0xB945, 0xB946, 0xB947, 0xB948, 0xB949, 0xB94A, 0xB94B, 0xB94C, 	// 0x8330A939
	0xB94D, 0xB94E, 0xB94F, 0xB950, 0xB951, 0xB952, 0xB953, 0xB954, 0xB955, 0xB956, 	// 0x8330AA39
	0xB957, 0xB958, 0xB959, 0xB95A, 0xB95B, 0xB95C, 0xB95D, 0xB95E, 0xB95F, 0xB960, 	// 0x8330AB39
	0xB961, 0xB962, 0xB963, 0xB964, 0xB965, 0xB966, 0xB967, 0xB968, 0xB969, 0xB96A, 	// 0x8330AC39
	0xB96B, 0xB96C, 0xB96D, 0xB96E, 0xB96F, 0xB970, 0xB971, 0xB972, 0xB973, 0xB974, 	// 0x8330AD39
	0xB975, 0xB976, 0xB977, 0xB978, 0xB979, 0xB97A, 0xB97B, 0xB97C, 0xB97D, 0xB97E, 	// 0x8330AE39
	0xB97F, 0xB980, 0xB981, 0xB982, 0xB983, 0xB984, 0xB985, 0xB986, 0xB987, 0xB988, 	// 0x8330AF39
	0xB989, 0xB98A, 0xB98B, 0xB98C, 0xB98D, 0xB98E, 0xB98F, 0xB990, 0xB991, 0xB992, 	// 0x8330B039
	0xB993, 0xB994, 0xB995, 0xB996, 0xB997, 0xB998, 0xB999, 0xB99A, 0xB99B, 0xB99C, 	// 0x8330B139
	0xB99D, 0xB99E, 0xB99F, 0xB9A0, 0xB9A1, 0xB9A2, 0xB9A3, 0xB9A4, 0xB9A5, 0xB9A6, 	// 0x8330B239
	0xB9A7, 0xB9A8, 0xB9A9, 0xB9AA, 0xB9AB, 0xB9AC, 0xB9AD, 0xB9AE, 0xB9AF, 0xB9B0, 	// 0x8330B339
	0xB9B1, 0xB9B2, 0xB9B3, 0xB9B4, 0xB9B5, 0xB9B6, 0xB9B7, 0xB9B8, 0xB9B9, 0xB9BA, 	// 0x8330B439
	0xB9BB, 0xB9BC, 0xB9BD, 0xB9BE, 0xB9BF, 0xB9C0, 0xB9C1, 0xB9C2, 0xB9C3, 0xB9C4, 	// 0x8330B539
	0xB9C5, 0xB9C6, 0xB9C7, 0xB9C8, 0xB9C9, 0xB9CA, 0xB9CB, 0xB9CC, 0xB9CD, 0xB9CE, 	// 0x8330B639
	0xB9CF, 0xB9D0, 0xB9D1, 0xB9D2, 0xB9D3, 0xB9D4, 0xB9D5, 0xB9D6, 0xB9D7, 0xB9D8, 	// 0x8330B739
	0xB9D9, 0xB9DA, 0xB9DB, 0xB9DC, 0xB9DD, 0xB9DE, 0xB9DF, 0xB9E0, 0xB9E1, 0xB9E2, 	// 0x8330B839
	0xB9E3, 0xB9E4, 0xB9E5, 0xB9E6, 0xB9E7, 0xB9E8, 0xB9E9, 0xB9EA, 0xB9EB, 0xB9EC, 	// 0x8330B939
	0xB9ED, 0xB9EE, 0xB9EF, 0xB9F0, 0xB9F1, 0xB9F2, 0xB9F3, 0xB9F4, 0xB9F5, 0xB9F6, 	// 0x8330BA39
	0xB9F7, 0xB9F8, 0xB9F9, 0xB9FA, 0xB9FB, 0xB9FC, 0xB9FD, 0xB9FE, 0xB9FF, 0xBA00, 	// 0x8330BB39
	0xBA01, 0xBA02, 0xBA03, 0xBA04, 0xBA05, 0xBA06, 0xBA07, 0xBA08, 0xBA09, 0xBA0A, 	// 0x8330BC39
	0xBA0B, 0xBA0C, 0xBA0D, 0xBA0E, 0xBA0F, 0xBA10, 0xBA11, 0xBA12, 0xBA13, 0xBA14, 	// 0x8330BD39
	0xBA15, 0xBA16, 0xBA17, 0xBA18, 0xBA19, 0xBA1A, 0xBA1B, 0xBA1C, 0xBA1D, 0xBA1E, 	// 0x8330BE39
	0xBA1F, 0xBA20, 0xBA21, 0xBA22, 0xBA23, 0xBA24, 0xBA25, 0xBA26, 0xBA27, 0xBA28, 	// 0x8330BF39
	0xBA29, 0xBA2A, 0xBA2B, 0xBA2C, 0xBA2D, 0xBA2E, 0xBA2F, 0xBA30, 0xBA31, 0xBA32, 	// 0x8330C039
	0xBA33, 0xBA34, 0xBA35, 0xBA36, 0xBA37, 0xBA38, 0xBA39, 0xBA3A, 0xBA3B, 0xBA3C, 	// 0x8330C139
	0xBA3D, 0xBA3E, 0xBA3F, 0xBA40, 0xBA41, 0xBA42, 0xBA43, 0xBA44, 0xBA45, 0xBA46, 	// 0x8330C239
	0xBA47, 0xBA48, 0xBA49, 0xBA4A, 0xBA4B, 0xBA4C, 0xBA4D, 0xBA4E, 0xBA4F, 0xBA50, 	// 0x8330C339
	0xBA51, 0xBA52, 0xBA53, 0xBA54, 0xBA55, 0xBA56, 0xBA57, 0xBA58, 0xBA59, 0xBA5A, 	// 0x8330C439
	0xBA5B, 0xBA5C, 0xBA5D, 0xBA5E, 0xBA5F, 0xBA60, 0xBA61, 0xBA62, 0xBA63, 0xBA64, 	// 0x8330C539
	0xBA65, 0xBA66, 0xBA67, 0xBA68, 0xBA69, 0xBA6A, 0xBA6B, 0xBA6C, 0xBA6D, 0xBA6E, 	// 0x8330C639
	0xBA6F, 0xBA70, 0xBA71, 0xBA72, 0xBA73, 0xBA74, 0xBA75, 0xBA76, 0xBA77, 0xBA78, 	// 0x8330C739
	0xBA79, 0xBA7A, 0xBA7B, 0xBA7C, 0xBA7D, 0xBA7E, 0xBA7F, 0xBA80, 0xBA81, 0xBA82, 	// 0x8330C839
	0xBA83, 0xBA84, 0xBA85, 0xBA86, 0xBA87, 0xBA88, 0xBA89, 0xBA8A, 0xBA8B, 0xBA8C, 	// 0x8330C939
	0xBA8D, 0xBA8E, 0xBA8F, 0xBA90, 0xBA91, 0xBA92, 0xBA93, 0xBA94, 0xBA95, 0xBA96, 	// 0x8330CA39
	0xBA97, 0xBA98, 0xBA99, 0xBA9A, 0xBA9B, 0xBA9C, 0xBA9D, 0xBA9E, 0xBA9F, 0xBAA0, 	// 0x8330CB39
	0xBAA1, 0xBAA2, 0xBAA3, 0xBAA4, 0xBAA5, 0xBAA6, 0xBAA7, 0xBAA8, 0xBAA9, 0xBAAA, 	// 0x8330CC39
	0xBAAB, 0xBAAC, 0xBAAD, 0xBAAE, 0xBAAF, 0xBAB0, 0xBAB1, 0xBAB2, 0xBAB3, 0xBAB4, 	// 0x8330CD39
	0xBAB5, 0xBAB6, 0xBAB7, 0xBAB8, 0xBAB9, 0xBABA, 0xBABB, 0xBABC, 0xBABD, 0xBABE, 	// 0x8330CE39
	0xBABF, 0xBAC0, 0xBAC1, 0xBAC2, 0xBAC3, 0xBAC4, 0xBAC5, 0xBAC6, 0xBAC7, 0xBAC8, 	// 0x8330CF39
	0xBAC9, 0xBACA, 0xBACB, 0xBACC, 0xBACD, 0xBACE, 0xBACF, 0xBAD0, 0xBAD1, 0xBAD2, 	// 0x8330D039
	0xBAD3, 0xBAD4, 0xBAD5, 0xBAD6, 0xBAD7, 0xBAD8, 0xBAD9, 0xBADA, 0xBADB, 0xBADC, 	// 0x8330D139
	0xBADD, 0xBADE, 0xBADF, 0xBAE0, 0xBAE1, 0xBAE2, 0xBAE3, 0xBAE4, 0xBAE5, 0xBAE6, 	// 0x8330D239
	0xBAE7, 0xBAE8, 0xBAE9, 0xBAEA, 0xBAEB, 0xBAEC, 0xBAED, 0xBAEE, 0xBAEF, 0xBAF0, 	// 0x8330D339
	0xBAF1, 0xBAF2, 0xBAF3, 0xBAF4, 0xBAF5, 0xBAF6, 0xBAF7, 0xBAF8, 0xBAF9, 0xBAFA, 	// 0x8330D439
	0xBAFB, 0xBAFC, 0xBAFD, 0xBAFE, 0xBAFF, 0xBB00, 0xBB01, 0xBB02, 0xBB03, 0xBB04, 	// 0x8330D539
	0xBB05, 0xBB06, 0xBB07, 0xBB08, 0xBB09, 0xBB0A, 0xBB0B, 0xBB0C, 0xBB0D, 0xBB0E, 	// 0x8330D639
	0xBB0F, 0xBB10, 0xBB11, 0xBB12, 0xBB13, 0xBB14, 0xBB15, 0xBB16, 0xBB17, 0xBB18, 	// 0x8330D739
	0xBB19, 0xBB1A, 0xBB1B, 0xBB1C, 0xBB1D, 0xBB1E, 0xBB1F, 0xBB20, 0xBB21, 0xBB22, 	// 0x8330D839
	0xBB23, 0xBB24, 0xBB25, 0xBB26, 0xBB27, 0xBB28, 0xBB29, 0xBB2A, 0xBB2B, 0xBB2C, 	// 0x8330D939
	0xBB2D, 0xBB2E, 0xBB2F, 0xBB30, 0xBB31, 0xBB32, 0xBB33, 0xBB34, 0xBB35, 0xBB36, 	// 0x8330DA39
	0xBB37, 0xBB38, 0xBB39, 0xBB3A, 0xBB3B, 0xBB3C, 0xBB3D, 0xBB3E, 0xBB3F, 0xBB40, 	// 0x8330DB39
	0xBB41, 0xBB42, 0xBB43, 0xBB44, 0xBB45, 0xBB46, 0xBB47, 0xBB48, 0xBB49, 0xBB4A, 	// 0x8330DC39
	0xBB4B, 0xBB4C, 0xBB4D, 0xBB4E, 0xBB4F, 0xBB50, 0xBB51, 0xBB52, 0xBB53, 0xBB54, 	// 0x8330DD39
	0xBB55, 0xBB56, 0xBB57, 0xBB58, 0xBB59, 0xBB5A, 0xBB5B, 0xBB5C, 0xBB5D, 0xBB5E, 	// 0x8330DE39
	0xBB5F, 0xBB60, 0xBB61, 0xBB62, 0xBB63, 0xBB64, 0xBB65, 0xBB66, 0xBB67, 0xBB68, 	// 0x8330DF39
	0xBB69, 0xBB6A, 0xBB6B, 0xBB6C, 0xBB6D, 0xBB6E, 0xBB6F, 0xBB70, 0xBB71, 0xBB72, 	// 0x8330E039
	0xBB73, 0xBB74, 0xBB75, 0xBB76, 0xBB77, 0xBB78, 0xBB79, 0xBB7A, 0xBB7B, 0xBB7C, 	// 0x8330E139
	0xBB7D, 0xBB7E, 0xBB7F, 0xBB80, 0xBB81, 0xBB82, 0xBB83, 0xBB84, 0xBB85, 0xBB86, 	// 0x8330E239
	0xBB87, 0xBB88, 0xBB89, 0xBB8A, 0xBB8B, 0xBB8C, 0xBB8D, 0xBB8E, 0xBB8F, 0xBB90, 	// 0x8330E339
	0xBB91, 0xBB92, 0xBB93, 0xBB94, 0xBB95, 0xBB96, 0xBB97, 0xBB98, 0xBB99, 0xBB9A, 	// 0x8330E439
	0xBB9B, 0xBB9C, 0xBB9D, 0xBB9E, 0xBB9F, 0xBBA0, 0xBBA1, 0xBBA2, 0xBBA3, 0xBBA4, 	// 0x8330E539
	0xBBA5, 0xBBA6, 0xBBA7, 0xBBA8, 0xBBA9, 0xBBAA, 0xBBAB, 0xBBAC, 0xBBAD, 0xBBAE, 	// 0x8330E639
	0xBBAF, 0xBBB0, 0xBBB1, 0xBBB2, 0xBBB3, 0xBBB4, 0xBBB5, 0xBBB6, 0xBBB7, 0xBBB8, 	// 0x8330E739
	0xBBB9, 0xBBBA, 0xBBBB, 0xBBBC, 0xBBBD, 0xBBBE, 0xBBBF, 0xBBC0, 0xBBC1, 0xBBC2, 	// 0x8330E839
	0xBBC3, 0xBBC4, 0xBBC5, 0xBBC6, 0xBBC7, 0xBBC8, 0xBBC9, 0xBBCA, 0xBBCB, 0xBBCC, 	// 0x8330E939
	0xBBCD, 0xBBCE, 0xBBCF, 0xBBD0, 0xBBD1, 0xBBD2, 0xBBD3, 0xBBD4, 0xBBD5, 0xBBD6, 	// 0x8330EA39
	0xBBD7, 0xBBD8, 0xBBD9, 0xBBDA, 0xBBDB, 0xBBDC, 0xBBDD, 0xBBDE, 0xBBDF, 0xBBE0, 	// 0x8330EB39
	0xBBE1, 0xBBE2, 0xBBE3, 0xBBE4, 0xBBE5, 0xBBE6, 0xBBE7, 0xBBE8, 0xBBE9, 0xBBEA, 	// 0x8330EC39
	0xBBEB, 0xBBEC, 0xBBED, 0xBBEE, 0xBBEF, 0xBBF0, 0xBBF1, 0xBBF2, 0xBBF3, 0xBBF4, 	// 0x8330ED39
	0xBBF5, 0xBBF6, 0xBBF7, 0xBBF8, 0xBBF9, 0xBBFA, 0xBBFB, 0xBBFC, 0xBBFD, 0xBBFE, 	// 0x8330EE39
	0xBBFF, 0xBC00, 0xBC01, 0xBC02, 0xBC03, 0xBC04, 0xBC05, 0xBC06, 0xBC07, 0xBC08, 	// 0x8330EF39
	0xBC09, 0xBC0A, 0xBC0B, 0xBC0C, 0xBC0D, 0xBC0E, 0xBC0F, 0xBC10, 0xBC11, 0xBC12, 	// 0x8330F039
	0xBC13, 0xBC14, 0xBC15, 0xBC16, 0xBC17, 0xBC18, 0xBC19, 0xBC1A, 0xBC1B, 0xBC1C, 	// 0x8330F139
	0xBC1D, 0xBC1E, 0xBC1F, 0xBC20, 0xBC21, 0xBC22, 0xBC23, 0xBC24, 0xBC25, 0xBC26, 	// 0x8330F239
	0xBC27, 0xBC28, 0xBC29, 0xBC2A, 0xBC2B, 0xBC2C, 0xBC2D, 0xBC2E, 0xBC2F, 0xBC30, 	// 0x8330F339
	0xBC31, 0xBC32, 0xBC33, 0xBC34, 0xBC35, 0xBC36, 0xBC37, 0xBC38, 0xBC39, 0xBC3A, 	// 0x8330F439
	0xBC3B, 0xBC3C, 0xBC3D, 0xBC3E, 0xBC3F, 0xBC40, 0xBC41, 0xBC42, 0xBC43, 0xBC44, 	// 0x8330F539
	0xBC45, 0xBC46, 0xBC47, 0xBC48, 0xBC49, 0xBC4A, 0xBC4B, 0xBC4C, 0xBC4D, 0xBC4E, 	// 0x8330F639
	0xBC4F, 0xBC50, 0xBC51, 0xBC52, 0xBC53, 0xBC54, 0xBC55, 0xBC56, 0xBC57, 0xBC58, 	// 0x8330F739
	0xBC59, 0xBC5A, 0xBC5B, 0xBC5C, 0xBC5D, 0xBC5E, 0xBC5F, 0xBC60, 0xBC61, 0xBC62, 	// 0x8330F839
	0xBC63, 0xBC64, 0xBC65, 0xBC66, 0xBC67, 0xBC68, 0xBC69, 0xBC6A, 0xBC6B, 0xBC6C, 	// 0x8330F939
	0xBC6D, 0xBC6E, 0xBC6F, 0xBC70, 0xBC71, 0xBC72, 0xBC73, 0xBC74, 0xBC75, 0xBC76, 	// 0x8330FA39
	0xBC77, 0xBC78, 0xBC79, 0xBC7A, 0xBC7B, 0xBC7C, 0xBC7D, 0xBC7E, 0xBC7F, 0xBC80, 	// 0x8330FB39
	0xBC81, 0xBC82, 0xBC83, 0xBC84, 0xBC85, 0xBC86, 0xBC87, 0xBC88, 0xBC89, 0xBC8A, 	// 0x8330FC39
	0xBC8B, 0xBC8C, 0xBC8D, 0xBC8E, 0xBC8F, 0xBC90, 0xBC91, 0xBC92, 0xBC93, 0xBC94, 	// 0x8330FD39
	0xBC95, 0xBC96, 0xBC97, 0xBC98, 0xBC99, 0xBC9A, 0xBC9B, 0xBC9C, 0xBC9D, 0xBC9E, 	// 0x8330FE39
	0xBC9F, 0xBCA0, 0xBCA1, 0xBCA2, 0xBCA3, 0xBCA4, 0xBCA5, 0xBCA6, 0xBCA7, 0xBCA8, 	// 0x83318139
	0xBCA9, 0xBCAA, 0xBCAB, 0xBCAC, 0xBCAD, 0xBCAE, 0xBCAF, 0xBCB0, 0xBCB1, 0xBCB2, 	// 0x83318239
	0xBCB3, 0xBCB4, 0xBCB5, 0xBCB6, 0xBCB7, 0xBCB8, 0xBCB9, 0xBCBA, 0xBCBB, 0xBCBC, 	// 0x83318339
	0xBCBD, 0xBCBE, 0xBCBF, 0xBCC0, 0xBCC1, 0xBCC2, 0xBCC3, 0xBCC4, 0xBCC5, 0xBCC6, 	// 0x83318439
	0xBCC7, 0xBCC8, 0xBCC9, 0xBCCA, 0xBCCB, 0xBCCC, 0xBCCD, 0xBCCE, 0xBCCF, 0xBCD0, 	// 0x83318539
	0xBCD1, 0xBCD2, 0xBCD3, 0xBCD4, 0xBCD5, 0xBCD6, 0xBCD7, 0xBCD8, 0xBCD9, 0xBCDA, 	// 0x83318639
	0xBCDB, 0xBCDC, 0xBCDD, 0xBCDE, 0xBCDF, 0xBCE0, 0xBCE1, 0xBCE2, 0xBCE3, 0xBCE4, 	// 0x83318739
	0xBCE5, 0xBCE6, 0xBCE7, 0xBCE8, 0xBCE9, 0xBCEA, 0xBCEB, 0xBCEC, 0xBCED, 0xBCEE, 	// 0x83318839
	0xBCEF, 0xBCF0, 0xBCF1, 0xBCF2, 0xBCF3, 0xBCF4, 0xBCF5, 0xBCF6, 0xBCF7, 0xBCF8, 	// 0x83318939
	0xBCF9, 0xBCFA, 0xBCFB, 0xBCFC, 0xBCFD, 0xBCFE, 0xBCFF, 0xBD00, 0xBD01, 0xBD02, 	// 0x83318A39
	0xBD03, 0xBD04, 0xBD05, 0xBD06, 0xBD07, 0xBD08, 0xBD09, 0xBD0A, 0xBD0B, 0xBD0C, 	// 0x83318B39
	0xBD0D, 0xBD0E, 0xBD0F, 0xBD10, 0xBD11, 0xBD12, 0xBD13, 0xBD14, 0xBD15, 0xBD16, 	// 0x83318C39
	0xBD17, 0xBD18, 0xBD19, 0xBD1A, 0xBD1B, 0xBD1C, 0xBD1D, 0xBD1E, 0xBD1F, 0xBD20, 	// 0x83318D39
	0xBD21, 0xBD22, 0xBD23, 0xBD24, 0xBD25, 0xBD26, 0xBD27, 0xBD28, 0xBD29, 0xBD2A, 	// 0x83318E39
	0xBD2B, 0xBD2C, 0xBD2D, 0xBD2E, 0xBD2F, 0xBD30, 0xBD31, 0xBD32, 0xBD33, 0xBD34, 	// 0x83318F39
	0xBD35, 0xBD36, 0xBD37, 0xBD38, 0xBD39, 0xBD3A, 0xBD3B, 0xBD3C, 0xBD3D, 0xBD3E, 	// 0x83319039
	0xBD3F, 0xBD40, 0xBD41, 0xBD42, 0xBD43, 0xBD44, 0xBD45, 0xBD46, 0xBD47, 0xBD48, 	// 0x83319139
	0xBD49, 0xBD4A, 0xBD4B, 0xBD4C, 0xBD4D, 0xBD4E, 0xBD4F, 0xBD50, 0xBD51, 0xBD52, 	// 0x83319239
	0xBD53, 0xBD54, 0xBD55, 0xBD56, 0xBD57, 0xBD58, 0xBD59, 0xBD5A, 0xBD5B, 0xBD5C, 	// 0x83319339
	0xBD5D, 0xBD5E, 0xBD5F, 0xBD60, 0xBD61, 0xBD62, 0xBD63, 0xBD64, 0xBD65, 0xBD66, 	// 0x83319439
	0xBD67, 0xBD68, 0xBD69, 0xBD6A, 0xBD6B, 0xBD6C, 0xBD6D, 0xBD6E, 0xBD6F, 0xBD70, 	// 0x83319539
	0xBD71, 0xBD72, 0xBD73, 0xBD74, 0xBD75, 0xBD76, 0xBD77, 0xBD78, 0xBD79, 0xBD7A, 	// 0x83319639
	0xBD7B, 0xBD7C, 0xBD7D, 0xBD7E, 0xBD7F, 0xBD80, 0xBD81, 0xBD82, 0xBD83, 0xBD84, 	// 0x83319739
	0xBD85, 0xBD86, 0xBD87, 0xBD88, 0xBD89, 0xBD8A, 0xBD8B, 0xBD8C, 0xBD8D, 0xBD8E, 	// 0x83319839
	0xBD8F, 0xBD90, 0xBD91, 0xBD92, 0xBD93, 0xBD94, 0xBD95, 0xBD96, 0xBD97, 0xBD98, 	// 0x83319939
	0xBD99, 0xBD9A, 0xBD9B, 0xBD9C, 0xBD9D, 0xBD9E, 0xBD9F, 0xBDA0, 0xBDA1, 0xBDA2, 	// 0x83319A39
	0xBDA3, 0xBDA4, 0xBDA5, 0xBDA6, 0xBDA7, 0xBDA8, 0xBDA9, 0xBDAA, 0xBDAB, 0xBDAC, 	// 0x83319B39
	0xBDAD, 0xBDAE, 0xBDAF, 0xBDB0, 0xBDB1, 0xBDB2, 0xBDB3, 0xBDB4, 0xBDB5, 0xBDB6, 	// 0x83319C39
	0xBDB7, 0xBDB8, 0xBDB9, 0xBDBA, 0xBDBB, 0xBDBC, 0xBDBD, 0xBDBE, 0xBDBF, 0xBDC0, 	// 0x83319D39
	0xBDC1, 0xBDC2, 0xBDC3, 0xBDC4, 0xBDC5, 0xBDC6, 0xBDC7, 0xBDC8, 0xBDC9, 0xBDCA, 	// 0x83319E39
	0xBDCB, 0xBDCC, 0xBDCD, 0xBDCE, 0xBDCF, 0xBDD0, 0xBDD1, 0xBDD2, 0xBDD3, 0xBDD4, 	// 0x83319F39
	0xBDD5, 0xBDD6, 0xBDD7, 0xBDD8, 0xBDD9, 0xBDDA, 0xBDDB, 0xBDDC, 0xBDDD, 0xBDDE, 	// 0x8331A039
	0xBDDF, 0xBDE0, 0xBDE1, 0xBDE2, 0xBDE3, 0xBDE4, 0xBDE5, 0xBDE6, 0xBDE7, 0xBDE8, 	// 0x8331A139
	0xBDE9, 0xBDEA, 0xBDEB, 0xBDEC, 0xBDED, 0xBDEE, 0xBDEF, 0xBDF0, 0xBDF1, 0xBDF2, 	// 0x8331A239
	0xBDF3, 0xBDF4, 0xBDF5, 0xBDF6, 0xBDF7, 0xBDF8, 0xBDF9, 0xBDFA, 0xBDFB, 0xBDFC, 	// 0x8331A339
	0xBDFD, 0xBDFE, 0xBDFF, 0xBE00, 0xBE01, 0xBE02, 0xBE03, 0xBE04, 0xBE05, 0xBE06, 	// 0x8331A439
	0xBE07, 0xBE08, 0xBE09, 0xBE0A, 0xBE0B, 0xBE0C, 0xBE0D, 0xBE0E, 0xBE0F, 0xBE10, 	// 0x8331A539
	0xBE11, 0xBE12, 0xBE13, 0xBE14, 0xBE15, 0xBE16, 0xBE17, 0xBE18, 0xBE19, 0xBE1A, 	// 0x8331A639
	0xBE1B, 0xBE1C, 0xBE1D, 0xBE1E, 0xBE1F, 0xBE20, 0xBE21, 0xBE22, 0xBE23, 0xBE24, 	// 0x8331A739
	0xBE25, 0xBE26, 0xBE27, 0xBE28, 0xBE29, 0xBE2A, 0xBE2B, 0xBE2C, 0xBE2D, 0xBE2E, 	// 0x8331A839
	0xBE2F, 0xBE30, 0xBE31, 0xBE32, 0xBE33, 0xBE34, 0xBE35, 0xBE36, 0xBE37, 0xBE38, 	// 0x8331A939
	0xBE39, 0xBE3A, 0xBE3B, 0xBE3C, 0xBE3D, 0xBE3E, 0xBE3F, 0xBE40, 0xBE41, 0xBE42, 	// 0x8331AA39
	0xBE43, 0xBE44, 0xBE45, 0xBE46, 0xBE47, 0xBE48, 0xBE49, 0xBE4A, 0xBE4B, 0xBE4C, 	// 0x8331AB39
	0xBE4D, 0xBE4E, 0xBE4F, 0xBE50, 0xBE51, 0xBE52, 0xBE53, 0xBE54, 0xBE55, 0xBE56, 	// 0x8331AC39
	0xBE57, 0xBE58, 0xBE59, 0xBE5A, 0xBE5B, 0xBE5C, 0xBE5D, 0xBE5E, 0xBE5F, 0xBE60, 	// 0x8331AD39
	0xBE61, 0xBE62, 0xBE63, 0xBE64, 0xBE65, 0xBE66, 0xBE67, 0xBE68, 0xBE69, 0xBE6A, 	// 0x8331AE39
	0xBE6B, 0xBE6C, 0xBE6D, 0xBE6E, 0xBE6F, 0xBE70, 0xBE71, 0xBE72, 0xBE73, 0xBE74, 	// 0x8331AF39
	0xBE75, 0xBE76, 0xBE77, 0xBE78, 0xBE79, 0xBE7A, 0xBE7B, 0xBE7C, 0xBE7D, 0xBE7E, 	// 0x8331B039
	0xBE7F, 0xBE80, 0xBE81, 0xBE82, 0xBE83, 0xBE84, 0xBE85, 0xBE86, 0xBE87, 0xBE88, 	// 0x8331B139
	0xBE89, 0xBE8A, 0xBE8B, 0xBE8C, 0xBE8D, 0xBE8E, 0xBE8F, 0xBE90, 0xBE91, 0xBE92, 	// 0x8331B239
	0xBE93, 0xBE94, 0xBE95, 0xBE96, 0xBE97, 0xBE98, 0xBE99, 0xBE9A, 0xBE9B, 0xBE9C, 	// 0x8331B339
	0xBE9D, 0xBE9E, 0xBE9F, 0xBEA0, 0xBEA1, 0xBEA2, 0xBEA3, 0xBEA4, 0xBEA5, 0xBEA6, 	// 0x8331B439
	0xBEA7, 0xBEA8, 0xBEA9, 0xBEAA, 0xBEAB, 0xBEAC, 0xBEAD, 0xBEAE, 0xBEAF, 0xBEB0, 	// 0x8331B539
	0xBEB1, 0xBEB2, 0xBEB3, 0xBEB4, 0xBEB5, 0xBEB6, 0xBEB7, 0xBEB8, 0xBEB9, 0xBEBA, 	// 0x8331B639
	0xBEBB, 0xBEBC, 0xBEBD, 0xBEBE, 0xBEBF, 0xBEC0, 0xBEC1, 0xBEC2, 0xBEC3, 0xBEC4, 	// 0x8331B739
	0xBEC5, 0xBEC6, 0xBEC7, 0xBEC8, 0xBEC9, 0xBECA, 0xBECB, 0xBECC, 0xBECD, 0xBECE, 	// 0x8331B839
	0xBECF, 0xBED0, 0xBED1, 0xBED2, 0xBED3, 0xBED4, 0xBED5, 0xBED6, 0xBED7, 0xBED8, 	// 0x8331B939
	0xBED9, 0xBEDA, 0xBEDB, 0xBEDC, 0xBEDD, 0xBEDE, 0xBEDF, 0xBEE0, 0xBEE1, 0xBEE2, 	// 0x8331BA39
	0xBEE3, 0xBEE4, 0xBEE5, 0xBEE6, 0xBEE7, 0xBEE8, 0xBEE9, 0xBEEA, 0xBEEB, 0xBEEC, 	// 0x8331BB39
	0xBEED, 0xBEEE, 0xBEEF, 0xBEF0, 0xBEF1, 0xBEF2, 0xBEF3, 0xBEF4, 0xBEF5, 0xBEF6, 	// 0x8331BC39
	0xBEF7, 0xBEF8, 0xBEF9, 0xBEFA, 0xBEFB, 0xBEFC, 0xBEFD, 0xBEFE, 0xBEFF, 0xBF00, 	// 0x8331BD39
	0xBF01, 0xBF02, 0xBF03, 0xBF04, 0xBF05, 0xBF06, 0xBF07, 0xBF08, 0xBF09, 0xBF0A, 	// 0x8331BE39
	0xBF0B, 0xBF0C, 0xBF0D, 0xBF0E, 0xBF0F, 0xBF10, 0xBF11, 0xBF12, 0xBF13, 0xBF14, 	// 0x8331BF39
	0xBF15, 0xBF16, 0xBF17, 0xBF18, 0xBF19, 0xBF1A, 0xBF1B, 0xBF1C, 0xBF1D, 0xBF1E, 	// 0x8331C039
	0xBF1F, 0xBF20, 0xBF21, 0xBF22, 0xBF23, 0xBF24, 0xBF25, 0xBF26, 0xBF27, 0xBF28, 	// 0x8331C139
	0xBF29, 0xBF2A, 0xBF2B, 0xBF2C, 0xBF2D, 0xBF2E, 0xBF2F, 0xBF30, 0xBF31, 0xBF32, 	// 0x8331C239
	0xBF33, 0xBF34, 0xBF35, 0xBF36, 0xBF37, 0xBF38, 0xBF39, 0xBF3A, 0xBF3B, 0xBF3C, 	// 0x8331C339
	0xBF3D, 0xBF3E, 0xBF3F, 0xBF40, 0xBF41, 0xBF42, 0xBF43, 0xBF44, 0xBF45, 0xBF46, 	// 0x8331C439
	0xBF47, 0xBF48, 0xBF49, 0xBF4A, 0xBF4B, 0xBF4C, 0xBF4D, 0xBF4E, 0xBF4F, 0xBF50, 	// 0x8331C539
	0xBF51, 0xBF52, 0xBF53, 0xBF54, 0xBF55, 0xBF56, 0xBF57, 0xBF58, 0xBF59, 0xBF5A, 	// 0x8331C639
	0xBF5B, 0xBF5C, 0xBF5D, 0xBF5E, 0xBF5F, 0xBF60, 0xBF61, 0xBF62, 0xBF63, 0xBF64, 	// 0x8331C739
	0xBF65, 0xBF66, 0xBF67, 0xBF68, 0xBF69, 0xBF6A, 0xBF6B, 0xBF6C, 0xBF6D, 0xBF6E, 	// 0x8331C839
	0xBF6F, 0xBF70, 0xBF71, 0xBF72, 0xBF73, 0xBF74, 0xBF75, 0xBF76, 0xBF77, 0xBF78, 	// 0x8331C939
	0xBF79, 0xBF7A, 0xBF7B, 0xBF7C, 0xBF7D, 0xBF7E, 0xBF7F, 0xBF80, 0xBF81, 0xBF82, 	// 0x8331CA39
	0xBF83, 0xBF84, 0xBF85, 0xBF86, 0xBF87, 0xBF88, 0xBF89, 0xBF8A, 0xBF8B, 0xBF8C, 	// 0x8331CB39
	0xBF8D, 0xBF8E, 0xBF8F, 0xBF90, 0xBF91, 0xBF92, 0xBF93, 0xBF94, 0xBF95, 0xBF96, 	// 0x8331CC39
	0xBF97, 0xBF98, 0xBF99, 0xBF9A, 0xBF9B, 0xBF9C, 0xBF9D, 0xBF9E, 0xBF9F, 0xBFA0, 	// 0x8331CD39
	0xBFA1, 0xBFA2, 0xBFA3, 0xBFA4, 0xBFA5, 0xBFA6, 0xBFA7, 0xBFA8, 0xBFA9, 0xBFAA, 	// 0x8331CE39
	0xBFAB, 0xBFAC, 0xBFAD, 0xBFAE, 0xBFAF, 0xBFB0, 0xBFB1, 0xBFB2, 0xBFB3, 0xBFB4, 	// 0x8331CF39
	0xBFB5, 0xBFB6, 0xBFB7, 0xBFB8, 0xBFB9, 0xBFBA, 0xBFBB, 0xBFBC, 0xBFBD, 0xBFBE, 	// 0x8331D039
	0xBFBF, 0xBFC0, 0xBFC1, 0xBFC2, 0xBFC3, 0xBFC4, 0xBFC5, 0xBFC6, 0xBFC7, 0xBFC8, 	// 0x8331D139
	0xBFC9, 0xBFCA, 0xBFCB, 0xBFCC, 0xBFCD, 0xBFCE, 0xBFCF, 0xBFD0, 0xBFD1, 0xBFD2, 	// 0x8331D239
	0xBFD3, 0xBFD4, 0xBFD5, 0xBFD6, 0xBFD7, 0xBFD8, 0xBFD9, 0xBFDA, 0xBFDB, 0xBFDC, 	// 0x8331D339
	0xBFDD, 0xBFDE, 0xBFDF, 0xBFE0, 0xBFE1, 0xBFE2, 0xBFE3, 0xBFE4, 0xBFE5, 0xBFE6, 	// 0x8331D439
	0xBFE7, 0xBFE8, 0xBFE9, 0xBFEA, 0xBFEB, 0xBFEC, 0xBFED, 0xBFEE, 0xBFEF, 0xBFF0, 	// 0x8331D539
	0xBFF1, 0xBFF2, 0xBFF3, 0xBFF4, 0xBFF5, 0xBFF6, 0xBFF7, 0xBFF8, 0xBFF9, 0xBFFA, 	// 0x8331D639
	0xBFFB, 0xBFFC, 0xBFFD, 0xBFFE, 0xBFFF, 0xC000, 0xC001, 0xC002, 0xC003, 0xC004, 	// 0x8331D739
	0xC005, 0xC006, 0xC007, 0xC008, 0xC009, 0xC00A, 0xC00B, 0xC00C, 0xC00D, 0xC00E, 	// 0x8331D839
	0xC00F, 0xC010, 0xC011, 0xC012, 0xC013, 0xC014, 0xC015, 0xC016, 0xC017, 0xC018, 	// 0x8331D939
	0xC019, 0xC01A, 0xC01B, 0xC01C, 0xC01D, 0xC01E, 0xC01F, 0xC020, 0xC021, 0xC022, 	// 0x8331DA39
	0xC023, 0xC024, 0xC025, 0xC026, 0xC027, 0xC028, 0xC029, 0xC02A, 0xC02B, 0xC02C, 	// 0x8331DB39
	0xC02D, 0xC02E, 0xC02F, 0xC030, 0xC031, 0xC032, 0xC033, 0xC034, 0xC035, 0xC036, 	// 0x8331DC39
	0xC037, 0xC038, 0xC039, 0xC03A, 0xC03B, 0xC03C, 0xC03D, 0xC03E, 0xC03F, 0xC040, 	// 0x8331DD39
	0xC041, 0xC042, 0xC043, 0xC044, 0xC045, 0xC046, 0xC047, 0xC048, 0xC049, 0xC04A, 	// 0x8331DE39
	0xC04B, 0xC04C, 0xC04D, 0xC04E, 0xC04F, 0xC050, 0xC051, 0xC052, 0xC053, 0xC054, 	// 0x8331DF39
	0xC055, 0xC056, 0xC057, 0xC058, 0xC059, 0xC05A, 0xC05B, 0xC05C, 0xC05D, 0xC05E, 	// 0x8331E039
	0xC05F, 0xC060, 0xC061, 0xC062, 0xC063, 0xC064, 0xC065, 0xC066, 0xC067, 0xC068, 	// 0x8331E139
	0xC069, 0xC06A, 0xC06B, 0xC06C, 0xC06D, 0xC06E, 0xC06F, 0xC070, 0xC071, 0xC072, 	// 0x8331E239
	0xC073, 0xC074, 0xC075, 0xC076, 0xC077, 0xC078, 0xC079, 0xC07A, 0xC07B, 0xC07C, 	// 0x8331E339
	0xC07D, 0xC07E, 0xC07F, 0xC080, 0xC081, 0xC082, 0xC083, 0xC084, 0xC085, 0xC086, 	// 0x8331E439
	0xC087, 0xC088, 0xC089, 0xC08A, 0xC08B, 0xC08C, 0xC08D, 0xC08E, 0xC08F, 0xC090, 	// 0x8331E539
	0xC091, 0xC092, 0xC093, 0xC094, 0xC095, 0xC096, 0xC097, 0xC098, 0xC099, 0xC09A, 	// 0x8331E639
	0xC09B, 0xC09C, 0xC09D, 0xC09E, 0xC09F, 0xC0A0, 0xC0A1, 0xC0A2, 0xC0A3, 0xC0A4, 	// 0x8331E739
	0xC0A5, 0xC0A6, 0xC0A7, 0xC0A8, 0xC0A9, 0xC0AA, 0xC0AB, 0xC0AC, 0xC0AD, 0xC0AE, 	// 0x8331E839
	0xC0AF, 0xC0B0, 0xC0B1, 0xC0B2, 0xC0B3, 0xC0B4, 0xC0B5, 0xC0B6, 0xC0B7, 0xC0B8, 	// 0x8331E939
	0xC0B9, 0xC0BA, 0xC0BB, 0xC0BC, 0xC0BD, 0xC0BE, 0xC0BF, 0xC0C0, 0xC0C1, 0xC0C2, 	// 0x8331EA39
	0xC0C3, 0xC0C4, 0xC0C5, 0xC0C6, 0xC0C7, 0xC0C8, 0xC0C9, 0xC0CA, 0xC0CB, 0xC0CC, 	// 0x8331EB39
	0xC0CD, 0xC0CE, 0xC0CF, 0xC0D0, 0xC0D1, 0xC0D2, 0xC0D3, 0xC0D4, 0xC0D5, 0xC0D6, 	// 0x8331EC39
	0xC0D7, 0xC0D8, 0xC0D9, 0xC0DA, 0xC0DB, 0xC0DC, 0xC0DD, 0xC0DE, 0xC0DF, 0xC0E0, 	// 0x8331ED39
	0xC0E1, 0xC0E2, 0xC0E3, 0xC0E4, 0xC0E5, 0xC0E6, 0xC0E7, 0xC0E8, 0xC0E9, 0xC0EA, 	// 0x8331EE39
	0xC0EB, 0xC0EC, 0xC0ED, 0xC0EE, 0xC0EF, 0xC0F0, 0xC0F1, 0xC0F2, 0xC0F3, 0xC0F4, 	// 0x8331EF39
	0xC0F5, 0xC0F6, 0xC0F7, 0xC0F8, 0xC0F9, 0xC0FA, 0xC0FB, 0xC0FC, 0xC0FD, 0xC0FE, 	// 0x8331F039
	0xC0FF, 0xC100, 0xC101, 0xC102, 0xC103, 0xC104, 0xC105, 0xC106, 0xC107, 0xC108, 	// 0x8331F139
	0xC109, 0xC10A, 0xC10B, 0xC10C, 0xC10D, 0xC10E, 0xC10F, 0xC110, 0xC111, 0xC112, 	// 0x8331F239
	0xC113, 0xC114, 0xC115, 0xC116, 0xC117, 0xC118, 0xC119, 0xC11A, 0xC11B, 0xC11C, 	// 0x8331F339
	0xC11D, 0xC11E, 0xC11F, 0xC120, 0xC121, 0xC122, 0xC123, 0xC124, 0xC125, 0xC126, 	// 0x8331F439
	0xC127, 0xC128, 0xC129, 0xC12A, 0xC12B, 0xC12C, 0xC12D, 0xC12E, 0xC12F, 0xC130, 	// 0x8331F539
	0xC131, 0xC132, 0xC133, 0xC134, 0xC135, 0xC136, 0xC137, 0xC138, 0xC139, 0xC13A, 	// 0x8331F639
	0xC13B, 0xC13C, 0xC13D, 0xC13E, 0xC13F, 0xC140, 0xC141, 0xC142, 0xC143, 0xC144, 	// 0x8331F739
	0xC145, 0xC146, 0xC147, 0xC148, 0xC149, 0xC14A, 0xC14B, 0xC14C, 0xC14D, 0xC14E, 	// 0x8331F839
	0xC14F, 0xC150, 0xC151, 0xC152, 0xC153, 0xC154, 0xC155, 0xC156, 0xC157, 0xC158, 	// 0x8331F939
	0xC159, 0xC15A, 0xC15B, 0xC15C, 0xC15D, 0xC15E, 0xC15F, 0xC160, 0xC161, 0xC162, 	// 0x8331FA39
	0xC163, 0xC164, 0xC165, 0xC166, 0xC167, 0xC168, 0xC169, 0xC16A, 0xC16B, 0xC16C, 	// 0x8331FB39
	0xC16D, 0xC16E, 0xC16F, 0xC170, 0xC171, 0xC172, 0xC173, 0xC174, 0xC175, 0xC176, 	// 0x8331FC39
	0xC177, 0xC178, 0xC179, 0xC17A, 0xC17B, 0xC17C, 0xC17D, 0xC17E, 0xC17F, 0xC180, 	// 0x8331FD39
	0xC181, 0xC182, 0xC183, 0xC184, 0xC185, 0xC186, 0xC187, 0xC188, 0xC189, 0xC18A, 	// 0x8331FE39
	0xC18B, 0xC18C, 0xC18D, 0xC18E, 0xC18F, 0xC190, 0xC191, 0xC192, 0xC193, 0xC194, 	// 0x83328139
	0xC195, 0xC196, 0xC197, 0xC198, 0xC199, 0xC19A, 0xC19B, 0xC19C, 0xC19D, 0xC19E, 	// 0x83328239
	0xC19F, 0xC1A0, 0xC1A1, 0xC1A2, 0xC1A3, 0xC1A4, 0xC1A5, 0xC1A6, 0xC1A7, 0xC1A8, 	// 0x83328339
	0xC1A9, 0xC1AA, 0xC1AB, 0xC1AC, 0xC1AD, 0xC1AE, 0xC1AF, 0xC1B0, 0xC1B1, 0xC1B2, 	// 0x83328439
	0xC1B3, 0xC1B4, 0xC1B5, 0xC1B6, 0xC1B7, 0xC1B8, 0xC1B9, 0xC1BA, 0xC1BB, 0xC1BC, 	// 0x83328539
	0xC1BD, 0xC1BE, 0xC1BF, 0xC1C0, 0xC1C1, 0xC1C2, 0xC1C3, 0xC1C4, 0xC1C5, 0xC1C6, 	// 0x83328639
	0xC1C7, 0xC1C8, 0xC1C9, 0xC1CA, 0xC1CB, 0xC1CC, 0xC1CD, 0xC1CE, 0xC1CF, 0xC1D0, 	// 0x83328739
	0xC1D1, 0xC1D2, 0xC1D3, 0xC1D4, 0xC1D5, 0xC1D6, 0xC1D7, 0xC1D8, 0xC1D9, 0xC1DA, 	// 0x83328839
	0xC1DB, 0xC1DC, 0xC1DD, 0xC1DE, 0xC1DF, 0xC1E0, 0xC1E1, 0xC1E2, 0xC1E3, 0xC1E4, 	// 0x83328939
	0xC1E5, 0xC1E6, 0xC1E7, 0xC1E8, 0xC1E9, 0xC1EA, 0xC1EB, 0xC1EC, 0xC1ED, 0xC1EE, 	// 0x83328A39
	0xC1EF, 0xC1F0, 0xC1F1, 0xC1F2, 0xC1F3, 0xC1F4, 0xC1F5, 0xC1F6, 0xC1F7, 0xC1F8, 	// 0x83328B39
	0xC1F9, 0xC1FA, 0xC1FB, 0xC1FC, 0xC1FD, 0xC1FE, 0xC1FF, 0xC200, 0xC201, 0xC202, 	// 0x83328C39
	0xC203, 0xC204, 0xC205, 0xC206, 0xC207, 0xC208, 0xC209, 0xC20A, 0xC20B, 0xC20C, 	// 0x83328D39
	0xC20D, 0xC20E, 0xC20F, 0xC210, 0xC211, 0xC212, 0xC213, 0xC214, 0xC215, 0xC216, 	// 0x83328E39
	0xC217, 0xC218, 0xC219, 0xC21A, 0xC21B, 0xC21C, 0xC21D, 0xC21E, 0xC21F, 0xC220, 	// 0x83328F39
	0xC221, 0xC222, 0xC223, 0xC224, 0xC225, 0xC226, 0xC227, 0xC228, 0xC229, 0xC22A, 	// 0x83329039
	0xC22B, 0xC22C, 0xC22D, 0xC22E, 0xC22F, 0xC230, 0xC231, 0xC232, 0xC233, 0xC234, 	// 0x83329139
	0xC235, 0xC236, 0xC237, 0xC238, 0xC239, 0xC23A, 0xC23B, 0xC23C, 0xC23D, 0xC23E, 	// 0x83329239
	0xC23F, 0xC240, 0xC241, 0xC242, 0xC243, 0xC244, 0xC245, 0xC246, 0xC247, 0xC248, 	// 0x83329339
	0xC249, 0xC24A, 0xC24B, 0xC24C, 0xC24D, 0xC24E, 0xC24F, 0xC250, 0xC251, 0xC252, 	// 0x83329439
	0xC253, 0xC254, 0xC255, 0xC256, 0xC257, 0xC258, 0xC259, 0xC25A, 0xC25B, 0xC25C, 	// 0x83329539
	0xC25D, 0xC25E, 0xC25F, 0xC260, 0xC261, 0xC262, 0xC263, 0xC264, 0xC265, 0xC266, 	// 0x83329639
	0xC267, 0xC268, 0xC269, 0xC26A, 0xC26B, 0xC26C, 0xC26D, 0xC26E, 0xC26F, 0xC270, 	// 0x83329739
	0xC271, 0xC272, 0xC273, 0xC274, 0xC275, 0xC276, 0xC277, 0xC278, 0xC279, 0xC27A, 	// 0x83329839
	0xC27B, 0xC27C, 0xC27D, 0xC27E, 0xC27F, 0xC280, 0xC281, 0xC282, 0xC283, 0xC284, 	// 0x83329939
	0xC285, 0xC286, 0xC287, 0xC288, 0xC289, 0xC28A, 0xC28B, 0xC28C, 0xC28D, 0xC28E, 	// 0x83329A39
	0xC28F, 0xC290, 0xC291, 0xC292, 0xC293, 0xC294, 0xC295, 0xC296, 0xC297, 0xC298, 	// 0x83329B39
	0xC299, 0xC29A, 0xC29B, 0xC29C, 0xC29D, 0xC29E, 0xC29F, 0xC2A0, 0xC2A1, 0xC2A2, 	// 0x83329C39
	0xC2A3, 0xC2A4, 0xC2A5, 0xC2A6, 0xC2A7, 0xC2A8, 0xC2A9, 0xC2AA, 0xC2AB, 0xC2AC, 	// 0x83329D39
	0xC2AD, 0xC2AE, 0xC2AF, 0xC2B0, 0xC2B1, 0xC2B2, 0xC2B3, 0xC2B4, 0xC2B5, 0xC2B6, 	// 0x83329E39
	0xC2B7, 0xC2B8, 0xC2B9, 0xC2BA, 0xC2BB, 0xC2BC, 0xC2BD, 0xC2BE, 0xC2BF, 0xC2C0, 	// 0x83329F39
	0xC2C1, 0xC2C2, 0xC2C3, 0xC2C4, 0xC2C5, 0xC2C6, 0xC2C7, 0xC2C8, 0xC2C9, 0xC2CA, 	// 0x8332A039
	0xC2CB, 0xC2CC, 0xC2CD, 0xC2CE, 0xC2CF, 0xC2D0, 0xC2D1, 0xC2D2, 0xC2D3, 0xC2D4, 	// 0x8332A139
	0xC2D5, 0xC2D6, 0xC2D7, 0xC2D8, 0xC2D9, 0xC2DA, 0xC2DB, 0xC2DC, 0xC2DD, 0xC2DE, 	// 0x8332A239
	0xC2DF, 0xC2E0, 0xC2E1, 0xC2E2, 0xC2E3, 0xC2E4, 0xC2E5, 0xC2E6, 0xC2E7, 0xC2E8, 	// 0x8332A339
	0xC2E9, 0xC2EA, 0xC2EB, 0xC2EC, 0xC2ED, 0xC2EE, 0xC2EF, 0xC2F0, 0xC2F1, 0xC2F2, 	// 0x8332A439
	0xC2F3, 0xC2F4, 0xC2F5, 0xC2F6, 0xC2F7, 0xC2F8, 0xC2F9, 0xC2FA, 0xC2FB, 0xC2FC, 	// 0x8332A539
	0xC2FD, 0xC2FE, 0xC2FF, 0xC300, 0xC301, 0xC302, 0xC303, 0xC304, 0xC305, 0xC306, 	// 0x8332A639
	0xC307, 0xC308, 0xC309, 0xC30A, 0xC30B, 0xC30C, 0xC30D, 0xC30E, 0xC30F, 0xC310, 	// 0x8332A739
	0xC311, 0xC312, 0xC313, 0xC314, 0xC315, 0xC316, 0xC317, 0xC318, 0xC319, 0xC31A, 	// 0x8332A839
	0xC31B, 0xC31C, 0xC31D, 0xC31E, 0xC31F, 0xC320, 0xC321, 0xC322, 0xC323, 0xC324, 	// 0x8332A939
	0xC325, 0xC326, 0xC327, 0xC328, 0xC329, 0xC32A, 0xC32B, 0xC32C, 0xC32D, 0xC32E, 	// 0x8332AA39
	0xC32F, 0xC330, 0xC331, 0xC332, 0xC333, 0xC334, 0xC335, 0xC336, 0xC337, 0xC338, 	// 0x8332AB39
	0xC339, 0xC33A, 0xC33B, 0xC33C, 0xC33D, 0xC33E, 0xC33F, 0xC340, 0xC341, 0xC342, 	// 0x8332AC39
	0xC343, 0xC344, 0xC345, 0xC346, 0xC347, 0xC348, 0xC349, 0xC34A, 0xC34B, 0xC34C, 	// 0x8332AD39
	0xC34D, 0xC34E, 0xC34F, 0xC350, 0xC351, 0xC352, 0xC353, 0xC354, 0xC355, 0xC356, 	// 0x8332AE39
	0xC357, 0xC358, 0xC359, 0xC35A, 0xC35B, 0xC35C, 0xC35D, 0xC35E, 0xC35F, 0xC360, 	// 0x8332AF39
	0xC361, 0xC362, 0xC363, 0xC364, 0xC365, 0xC366, 0xC367, 0xC368, 0xC369, 0xC36A, 	// 0x8332B039
	0xC36B, 0xC36C, 0xC36D, 0xC36E, 0xC36F, 0xC370, 0xC371, 0xC372, 0xC373, 0xC374, 	// 0x8332B139
	0xC375, 0xC376, 0xC377, 0xC378, 0xC379, 0xC37A, 0xC37B, 0xC37C, 0xC37D, 0xC37E, 	// 0x8332B239
	0xC37F, 0xC380, 0xC381, 0xC382, 0xC383, 0xC384, 0xC385, 0xC386, 0xC387, 0xC388, 	// 0x8332B339
	0xC389, 0xC38A, 0xC38B, 0xC38C, 0xC38D, 0xC38E, 0xC38F, 0xC390, 0xC391, 0xC392, 	// 0x8332B439
	0xC393, 0xC394, 0xC395, 0xC396, 0xC397, 0xC398, 0xC399, 0xC39A, 0xC39B, 0xC39C, 	// 0x8332B539
	0xC39D, 0xC39E, 0xC39F, 0xC3A0, 0xC3A1, 0xC3A2, 0xC3A3, 0xC3A4, 0xC3A5, 0xC3A6, 	// 0x8332B639
	0xC3A7, 0xC3A8, 0xC3A9, 0xC3AA, 0xC3AB, 0xC3AC, 0xC3AD, 0xC3AE, 0xC3AF, 0xC3B0, 	// 0x8332B739
	0xC3B1, 0xC3B2, 0xC3B3, 0xC3B4, 0xC3B5, 0xC3B6, 0xC3B7, 0xC3B8, 0xC3B9, 0xC3BA, 	// 0x8332B839
	0xC3BB, 0xC3BC, 0xC3BD, 0xC3BE, 0xC3BF, 0xC3C0, 0xC3C1, 0xC3C2, 0xC3C3, 0xC3C4, 	// 0x8332B939
	0xC3C5, 0xC3C6, 0xC3C7, 0xC3C8, 0xC3C9, 0xC3CA, 0xC3CB, 0xC3CC, 0xC3CD, 0xC3CE, 	// 0x8332BA39
	0xC3CF, 0xC3D0, 0xC3D1, 0xC3D2, 0xC3D3, 0xC3D4, 0xC3D5, 0xC3D6, 0xC3D7, 0xC3D8, 	// 0x8332BB39
	0xC3D9, 0xC3DA, 0xC3DB, 0xC3DC, 0xC3DD, 0xC3DE, 0xC3DF, 0xC3E0, 0xC3E1, 0xC3E2, 	// 0x8332BC39
	0xC3E3, 0xC3E4, 0xC3E5, 0xC3E6, 0xC3E7, 0xC3E8, 0xC3E9, 0xC3EA, 0xC3EB, 0xC3EC, 	// 0x8332BD39
	0xC3ED, 0xC3EE, 0xC3EF, 0xC3F0, 0xC3F1, 0xC3F2, 0xC3F3, 0xC3F4, 0xC3F5, 0xC3F6, 	// 0x8332BE39
	0xC3F7, 0xC3F8, 0xC3F9, 0xC3FA, 0xC3FB, 0xC3FC, 0xC3FD, 0xC3FE, 0xC3FF, 0xC400, 	// 0x8332BF39
	0xC401, 0xC402, 0xC403, 0xC404, 0xC405, 0xC406, 0xC407, 0xC408, 0xC409, 0xC40A, 	// 0x8332C039
	0xC40B, 0xC40C, 0xC40D, 0xC40E, 0xC40F, 0xC410, 0xC411, 0xC412, 0xC413, 0xC414, 	// 0x8332C139
	0xC415, 0xC416, 0xC417, 0xC418, 0xC419, 0xC41A, 0xC41B, 0xC41C, 0xC41D, 0xC41E, 	// 0x8332C239
	0xC41F, 0xC420, 0xC421, 0xC422, 0xC423, 0xC424, 0xC425, 0xC426, 0xC427, 0xC428, 	// 0x8332C339
	0xC429, 0xC42A, 0xC42B, 0xC42C, 0xC42D, 0xC42E, 0xC42F, 0xC430, 0xC431, 0xC432, 	// 0x8332C439
	0xC433, 0xC434, 0xC435, 0xC436, 0xC437, 0xC438, 0xC439, 0xC43A, 0xC43B, 0xC43C, 	// 0x8332C539
	0xC43D, 0xC43E, 0xC43F, 0xC440, 0xC441, 0xC442, 0xC443, 0xC444, 0xC445, 0xC446, 	// 0x8332C639
	0xC447, 0xC448, 0xC449, 0xC44A, 0xC44B, 0xC44C, 0xC44D, 0xC44E, 0xC44F, 0xC450, 	// 0x8332C739
	0xC451, 0xC452, 0xC453, 0xC454, 0xC455, 0xC456, 0xC457, 0xC458, 0xC459, 0xC45A, 	// 0x8332C839
	0xC45B, 0xC45C, 0xC45D, 0xC45E, 0xC45F, 0xC460, 0xC461, 0xC462, 0xC463, 0xC464, 	// 0x8332C939
	0xC465, 0xC466, 0xC467, 0xC468, 0xC469, 0xC46A, 0xC46B, 0xC46C, 0xC46D, 0xC46E, 	// 0x8332CA39
	0xC46F, 0xC470, 0xC471, 0xC472, 0xC473, 0xC474, 0xC475, 0xC476, 0xC477, 0xC478, 	// 0x8332CB39
	0xC479, 0xC47A, 0xC47B, 0xC47C, 0xC47D, 0xC47E, 0xC47F, 0xC480, 0xC481, 0xC482, 	// 0x8332CC39
	0xC483, 0xC484, 0xC485, 0xC486, 0xC487, 0xC488, 0xC489, 0xC48A, 0xC48B, 0xC48C, 	// 0x8332CD39
	0xC48D, 0xC48E, 0xC48F, 0xC490, 0xC491, 0xC492, 0xC493, 0xC494, 0xC495, 0xC496, 	// 0x8332CE39
	0xC497, 0xC498, 0xC499, 0xC49A, 0xC49B, 0xC49C, 0xC49D, 0xC49E, 0xC49F, 0xC4A0, 	// 0x8332CF39
	0xC4A1, 0xC4A2, 0xC4A3, 0xC4A4, 0xC4A5, 0xC4A6, 0xC4A7, 0xC4A8, 0xC4A9, 0xC4AA, 	// 0x8332D039
	0xC4AB, 0xC4AC, 0xC4AD, 0xC4AE, 0xC4AF, 0xC4B0, 0xC4B1, 0xC4B2, 0xC4B3, 0xC4B4, 	// 0x8332D139
	0xC4B5, 0xC4B6, 0xC4B7, 0xC4B8, 0xC4B9, 0xC4BA, 0xC4BB, 0xC4BC, 0xC4BD, 0xC4BE, 	// 0x8332D239
	0xC4BF, 0xC4C0, 0xC4C1, 0xC4C2, 0xC4C3, 0xC4C4, 0xC4C5, 0xC4C6, 0xC4C7, 0xC4C8, 	// 0x8332D339
	0xC4C9, 0xC4CA, 0xC4CB, 0xC4CC, 0xC4CD, 0xC4CE, 0xC4CF, 0xC4D0, 0xC4D1, 0xC4D2, 	// 0x8332D439
	0xC4D3, 0xC4D4, 0xC4D5, 0xC4D6, 0xC4D7, 0xC4D8, 0xC4D9, 0xC4DA, 0xC4DB, 0xC4DC, 	// 0x8332D539
	0xC4DD, 0xC4DE, 0xC4DF, 0xC4E0, 0xC4E1, 0xC4E2, 0xC4E3, 0xC4E4, 0xC4E5, 0xC4E6, 	// 0x8332D639
	0xC4E7, 0xC4E8, 0xC4E9, 0xC4EA, 0xC4EB, 0xC4EC, 0xC4ED, 0xC4EE, 0xC4EF, 0xC4F0, 	// 0x8332D739
	0xC4F1, 0xC4F2, 0xC4F3, 0xC4F4, 0xC4F5, 0xC4F6, 0xC4F7, 0xC4F8, 0xC4F9, 0xC4FA, 	// 0x8332D839
	0xC4FB, 0xC4FC, 0xC4FD, 0xC4FE, 0xC4FF, 0xC500, 0xC501, 0xC502, 0xC503, 0xC504, 	// 0x8332D939
	0xC505, 0xC506, 0xC507, 0xC508, 0xC509, 0xC50A, 0xC50B, 0xC50C, 0xC50D, 0xC50E, 	// 0x8332DA39
	0xC50F, 0xC510, 0xC511, 0xC512, 0xC513, 0xC514, 0xC515, 0xC516, 0xC517, 0xC518, 	// 0x8332DB39
	0xC519, 0xC51A, 0xC51B, 0xC51C, 0xC51D, 0xC51E, 0xC51F, 0xC520, 0xC521, 0xC522, 	// 0x8332DC39
	0xC523, 0xC524, 0xC525, 0xC526, 0xC527, 0xC528, 0xC529, 0xC52A, 0xC52B, 0xC52C, 	// 0x8332DD39
	0xC52D, 0xC52E, 0xC52F, 0xC530, 0xC531, 0xC532, 0xC533, 0xC534, 0xC535, 0xC536, 	// 0x8332DE39
	0xC537, 0xC538, 0xC539, 0xC53A, 0xC53B, 0xC53C, 0xC53D, 0xC53E, 0xC53F, 0xC540, 	// 0x8332DF39
	0xC541, 0xC542, 0xC543, 0xC544, 0xC545, 0xC546, 0xC547, 0xC548, 0xC549, 0xC54A, 	// 0x8332E039
	0xC54B, 0xC54C, 0xC54D, 0xC54E, 0xC54F, 0xC550, 0xC551, 0xC552, 0xC553, 0xC554, 	// 0x8332E139
	0xC555, 0xC556, 0xC557, 0xC558, 0xC559, 0xC55A, 0xC55B, 0xC55C, 0xC55D, 0xC55E, 	// 0x8332E239
	0xC55F, 0xC560, 0xC561, 0xC562, 0xC563, 0xC564, 0xC565, 0xC566, 0xC567, 0xC568, 	// 0x8332E339
	0xC569, 0xC56A, 0xC56B, 0xC56C, 0xC56D, 0xC56E, 0xC56F, 0xC570, 0xC571, 0xC572, 	// 0x8332E439
	0xC573, 0xC574, 0xC575, 0xC576, 0xC577, 0xC578, 0xC579, 0xC57A, 0xC57B, 0xC57C, 	// 0x8332E539
	0xC57D, 0xC57E, 0xC57F, 0xC580, 0xC581, 0xC582, 0xC583, 0xC584, 0xC585, 0xC586, 	// 0x8332E639
	0xC587, 0xC588, 0xC589, 0xC58A, 0xC58B, 0xC58C, 0xC58D, 0xC58E, 0xC58F, 0xC590, 	// 0x8332E739
	0xC591, 0xC592, 0xC593, 0xC594, 0xC595, 0xC596, 0xC597, 0xC598, 0xC599, 0xC59A, 	// 0x8332E839
	0xC59B, 0xC59C, 0xC59D, 0xC59E, 0xC59F, 0xC5A0, 0xC5A1, 0xC5A2, 0xC5A3, 0xC5A4, 	// 0x8332E939
	0xC5A5, 0xC5A6, 0xC5A7, 0xC5A8, 0xC5A9, 0xC5AA, 0xC5AB, 0xC5AC, 0xC5AD, 0xC5AE, 	// 0x8332EA39
	0xC5AF, 0xC5B0, 0xC5B1, 0xC5B2, 0xC5B3, 0xC5B4, 0xC5B5, 0xC5B6, 0xC5B7, 0xC5B8, 	// 0x8332EB39
	0xC5B9, 0xC5BA, 0xC5BB, 0xC5BC, 0xC5BD, 0xC5BE, 0xC5BF, 0xC5C0, 0xC5C1, 0xC5C2, 	// 0x8332EC39
	0xC5C3, 0xC5C4, 0xC5C5, 0xC5C6, 0xC5C7, 0xC5C8, 0xC5C9, 0xC5CA, 0xC5CB, 0xC5CC, 	// 0x8332ED39
	0xC5CD, 0xC5CE, 0xC5CF, 0xC5D0, 0xC5D1, 0xC5D2, 0xC5D3, 0xC5D4, 0xC5D5, 0xC5D6, 	// 0x8332EE39
	0xC5D7, 0xC5D8, 0xC5D9, 0xC5DA, 0xC5DB, 0xC5DC, 0xC5DD, 0xC5DE, 0xC5DF, 0xC5E0, 	// 0x8332EF39
	0xC5E1, 0xC5E2, 0xC5E3, 0xC5E4, 0xC5E5, 0xC5E6, 0xC5E7, 0xC5E8, 0xC5E9, 0xC5EA, 	// 0x8332F039
	0xC5EB, 0xC5EC, 0xC5ED, 0xC5EE, 0xC5EF, 0xC5F0, 0xC5F1, 0xC5F2, 0xC5F3, 0xC5F4, 	// 0x8332F139
	0xC5F5, 0xC5F6, 0xC5F7, 0xC5F8, 0xC5F9, 0xC5FA, 0xC5FB, 0xC5FC, 0xC5FD, 0xC5FE, 	// 0x8332F239
	0xC5FF, 0xC600, 0xC601, 0xC602, 0xC603, 0xC604, 0xC605, 0xC606, 0xC607, 0xC608, 	// 0x8332F339
	0xC609, 0xC60A, 0xC60B, 0xC60C, 0xC60D, 0xC60E, 0xC60F, 0xC610, 0xC611, 0xC612, 	// 0x8332F439
	0xC613, 0xC614, 0xC615, 0xC616, 0xC617, 0xC618, 0xC619, 0xC61A, 0xC61B, 0xC61C, 	// 0x8332F539
	0xC61D, 0xC61E, 0xC61F, 0xC620, 0xC621, 0xC622, 0xC623, 0xC624, 0xC625, 0xC626, 	// 0x8332F639
	0xC627, 0xC628, 0xC629, 0xC62A, 0xC62B, 0xC62C, 0xC62D, 0xC62E, 0xC62F, 0xC630, 	// 0x8332F739
	0xC631, 0xC632, 0xC633, 0xC634, 0xC635, 0xC636, 0xC637, 0xC638, 0xC639, 0xC63A, 	// 0x8332F839
	0xC63B, 0xC63C, 0xC63D, 0xC63E, 0xC63F, 0xC640, 0xC641, 0xC642, 0xC643, 0xC644, 	// 0x8332F939
	0xC645, 0xC646, 0xC647, 0xC648, 0xC649, 0xC64A, 0xC64B, 0xC64C, 0xC64D, 0xC64E, 	// 0x8332FA39
	0xC64F, 0xC650, 0xC651, 0xC652, 0xC653, 0xC654, 0xC655, 0xC656, 0xC657, 0xC658, 	// 0x8332FB39
	0xC659, 0xC65A, 0xC65B, 0xC65C, 0xC65D, 0xC65E, 0xC65F, 0xC660, 0xC661, 0xC662, 	// 0x8332FC39
	0xC663, 0xC664, 0xC665, 0xC666, 0xC667, 0xC668, 0xC669, 0xC66A, 0xC66B, 0xC66C, 	// 0x8332FD39
	0xC66D, 0xC66E, 0xC66F, 0xC670, 0xC671, 0xC672, 0xC673, 0xC674, 0xC675, 0xC676, 	// 0x8332FE39
	0xC677, 0xC678, 0xC679, 0xC67A, 0xC67B, 0xC67C, 0xC67D, 0xC67E, 0xC67F, 0xC680, 	// 0x83338139
	0xC681, 0xC682, 0xC683, 0xC684, 0xC685, 0xC686, 0xC687, 0xC688, 0xC689, 0xC68A, 	// 0x83338239
	0xC68B, 0xC68C, 0xC68D, 0xC68E, 0xC68F, 0xC690, 0xC691, 0xC692, 0xC693, 0xC694, 	// 0x83338339
	0xC695, 0xC696, 0xC697, 0xC698, 0xC699, 0xC69A, 0xC69B, 0xC69C, 0xC69D, 0xC69E, 	// 0x83338439
	0xC69F, 0xC6A0, 0xC6A1, 0xC6A2, 0xC6A3, 0xC6A4, 0xC6A5, 0xC6A6, 0xC6A7, 0xC6A8, 	// 0x83338539
	0xC6A9, 0xC6AA, 0xC6AB, 0xC6AC, 0xC6AD, 0xC6AE, 0xC6AF, 0xC6B0, 0xC6B1, 0xC6B2, 	// 0x83338639
	0xC6B3, 0xC6B4, 0xC6B5, 0xC6B6, 0xC6B7, 0xC6B8, 0xC6B9, 0xC6BA, 0xC6BB, 0xC6BC, 	// 0x83338739
	0xC6BD, 0xC6BE, 0xC6BF, 0xC6C0, 0xC6C1, 0xC6C2, 0xC6C3, 0xC6C4, 0xC6C5, 0xC6C6, 	// 0x83338839
	0xC6C7, 0xC6C8, 0xC6C9, 0xC6CA, 0xC6CB, 0xC6CC, 0xC6CD, 0xC6CE, 0xC6CF, 0xC6D0, 	// 0x83338939
	0xC6D1, 0xC6D2, 0xC6D3, 0xC6D4, 0xC6D5, 0xC6D6, 0xC6D7, 0xC6D8, 0xC6D9, 0xC6DA, 	// 0x83338A39
	0xC6DB, 0xC6DC, 0xC6DD, 0xC6DE, 0xC6DF, 0xC6E0, 0xC6E1, 0xC6E2, 0xC6E3, 0xC6E4, 	// 0x83338B39
	0xC6E5, 0xC6E6, 0xC6E7, 0xC6E8, 0xC6E9, 0xC6EA, 0xC6EB, 0xC6EC, 0xC6ED, 0xC6EE, 	// 0x83338C39
	0xC6EF, 0xC6F0, 0xC6F1, 0xC6F2, 0xC6F3, 0xC6F4, 0xC6F5, 0xC6F6, 0xC6F7, 0xC6F8, 	// 0x83338D39
	0xC6F9, 0xC6FA, 0xC6FB, 0xC6FC, 0xC6FD, 0xC6FE, 0xC6FF, 0xC700, 0xC701, 0xC702, 	// 0x83338E39
	0xC703, 0xC704, 0xC705, 0xC706, 0xC707, 0xC708, 0xC709, 0xC70A, 0xC70B, 0xC70C, 	// 0x83338F39
	0xC70D, 0xC70E, 0xC70F, 0xC710, 0xC711, 0xC712, 0xC713, 0xC714, 0xC715, 0xC716, 	// 0x83339039
	0xC717, 0xC718, 0xC719, 0xC71A, 0xC71B, 0xC71C, 0xC71D, 0xC71E, 0xC71F, 0xC720, 	// 0x83339139
	0xC721, 0xC722, 0xC723, 0xC724, 0xC725, 0xC726, 0xC727, 0xC728, 0xC729, 0xC72A, 	// 0x83339239
	0xC72B, 0xC72C, 0xC72D, 0xC72E, 0xC72F, 0xC730, 0xC731, 0xC732, 0xC733, 0xC734, 	// 0x83339339
	0xC735, 0xC736, 0xC737, 0xC738, 0xC739, 0xC73A, 0xC73B, 0xC73C, 0xC73D, 0xC73E, 	// 0x83339439
	0xC73F, 0xC740, 0xC741, 0xC742, 0xC743, 0xC744, 0xC745, 0xC746, 0xC747, 0xC748, 	// 0x83339539
	0xC749, 0xC74A, 0xC74B, 0xC74C, 0xC74D, 0xC74E, 0xC74F, 0xC750, 0xC751, 0xC752, 	// 0x83339639
	0xC753, 0xC754, 0xC755, 0xC756, 0xC757, 0xC758, 0xC759, 0xC75A, 0xC75B, 0xC75C, 	// 0x83339739
	0xC75D, 0xC75E, 0xC75F, 0xC760, 0xC761, 0xC762, 0xC763, 0xC764, 0xC765, 0xC766, 	// 0x83339839
	0xC767, 0xC768, 0xC769, 0xC76A, 0xC76B, 0xC76C, 0xC76D, 0xC76E, 0xC76F, 0xC770, 	// 0x83339939
	0xC771, 0xC772, 0xC773, 0xC774, 0xC775, 0xC776, 0xC777, 0xC778, 0xC779, 0xC77A, 	// 0x83339A39
	0xC77B, 0xC77C, 0xC77D, 0xC77E, 0xC77F, 0xC780, 0xC781, 0xC782, 0xC783, 0xC784, 	// 0x83339B39
	0xC785, 0xC786, 0xC787, 0xC788, 0xC789, 0xC78A, 0xC78B, 0xC78C, 0xC78D, 0xC78E, 	// 0x83339C39
	0xC78F, 0xC790, 0xC791, 0xC792, 0xC793, 0xC794, 0xC795, 0xC796, 0xC797, 0xC798, 	// 0x83339D39
	0xC799, 0xC79A, 0xC79B, 0xC79C, 0xC79D, 0xC79E, 0xC79F, 0xC7A0, 0xC7A1, 0xC7A2, 	// 0x83339E39
	0xC7A3, 0xC7A4, 0xC7A5, 0xC7A6, 0xC7A7, 0xC7A8, 0xC7A9, 0xC7AA, 0xC7AB, 0xC7AC, 	// 0x83339F39
	0xC7AD, 0xC7AE, 0xC7AF, 0xC7B0, 0xC7B1, 0xC7B2, 0xC7B3, 0xC7B4, 0xC7B5, 0xC7B6, 	// 0x8333A039
	0xC7B7, 0xC7B8, 0xC7B9, 0xC7BA, 0xC7BB, 0xC7BC, 0xC7BD, 0xC7BE, 0xC7BF, 0xC7C0, 	// 0x8333A139
	0xC7C1, 0xC7C2, 0xC7C3, 0xC7C4, 0xC7C5, 0xC7C6, 0xC7C7, 0xC7C8, 0xC7C9, 0xC7CA, 	// 0x8333A239
	0xC7CB, 0xC7CC, 0xC7CD, 0xC7CE, 0xC7CF, 0xC7D0, 0xC7D1, 0xC7D2, 0xC7D3, 0xC7D4, 	// 0x8333A339
	0xC7D5, 0xC7D6, 0xC7D7, 0xC7D8, 0xC7D9, 0xC7DA, 0xC7DB, 0xC7DC, 0xC7DD, 0xC7DE, 	// 0x8333A439
	0xC7DF, 0xC7E0, 0xC7E1, 0xC7E2, 0xC7E3, 0xC7E4, 0xC7E5, 0xC7E6, 0xC7E7, 0xC7E8, 	// 0x8333A539
	0xC7E9, 0xC7EA, 0xC7EB, 0xC7EC, 0xC7ED, 0xC7EE, 0xC7EF, 0xC7F0, 0xC7F1, 0xC7F2, 	// 0x8333A639
	0xC7F3, 0xC7F4, 0xC7F5, 0xC7F6, 0xC7F7, 0xC7F8, 0xC7F9, 0xC7FA, 0xC7FB, 0xC7FC, 	// 0x8333A739
	0xC7FD, 0xC7FE, 0xC7FF, 0xC800, 0xC801, 0xC802, 0xC803, 0xC804, 0xC805, 0xC806, 	// 0x8333A839
	0xC807, 0xC808, 0xC809, 0xC80A, 0xC80B, 0xC80C, 0xC80D, 0xC80E, 0xC80F, 0xC810, 	// 0x8333A939
	0xC811, 0xC812, 0xC813, 0xC814, 0xC815, 0xC816, 0xC817, 0xC818, 0xC819, 0xC81A, 	// 0x8333AA39
	0xC81B, 0xC81C, 0xC81D, 0xC81E, 0xC81F, 0xC820, 0xC821, 0xC822, 0xC823, 0xC824, 	// 0x8333AB39
	0xC825, 0xC826, 0xC827, 0xC828, 0xC829, 0xC82A, 0xC82B, 0xC82C, 0xC82D, 0xC82E, 	// 0x8333AC39
	0xC82F, 0xC830, 0xC831, 0xC832, 0xC833, 0xC834, 0xC835, 0xC836, 0xC837, 0xC838, 	// 0x8333AD39
	0xC839, 0xC83A, 0xC83B, 0xC83C, 0xC83D, 0xC83E, 0xC83F, 0xC840, 0xC841, 0xC842, 	// 0x8333AE39
	0xC843, 0xC844, 0xC845, 0xC846, 0xC847, 0xC848, 0xC849, 0xC84A, 0xC84B, 0xC84C, 	// 0x8333AF39
	0xC84D, 0xC84E, 0xC84F, 0xC850, 0xC851, 0xC852, 0xC853, 0xC854, 0xC855, 0xC856, 	// 0x8333B039
	0xC857, 0xC858, 0xC859, 0xC85A, 0xC85B, 0xC85C, 0xC85D, 0xC85E, 0xC85F, 0xC860, 	// 0x8333B139
	0xC861, 0xC862, 0xC863, 0xC864, 0xC865, 0xC866, 0xC867, 0xC868, 0xC869, 0xC86A, 	// 0x8333B239
	0xC86B, 0xC86C, 0xC86D, 0xC86E, 0xC86F, 0xC870, 0xC871, 0xC872, 0xC873, 0xC874, 	// 0x8333B339
	0xC875, 0xC876, 0xC877, 0xC878, 0xC879, 0xC87A, 0xC87B, 0xC87C, 0xC87D, 0xC87E, 	// 0x8333B439
	0xC87F, 0xC880, 0xC881, 0xC882, 0xC883, 0xC884, 0xC885, 0xC886, 0xC887, 0xC888, 	// 0x8333B539
	0xC889, 0xC88A, 0xC88B, 0xC88C, 0xC88D, 0xC88E, 0xC88F, 0xC890, 0xC891, 0xC892, 	// 0x8333B639
	0xC893, 0xC894, 0xC895, 0xC896, 0xC897, 0xC898, 0xC899, 0xC89A, 0xC89B, 0xC89C, 	// 0x8333B739
	0xC89D, 0xC89E, 0xC89F, 0xC8A0, 0xC8A1, 0xC8A2, 0xC8A3, 0xC8A4, 0xC8A5, 0xC8A6, 	// 0x8333B839
	0xC8A7, 0xC8A8, 0xC8A9, 0xC8AA, 0xC8AB, 0xC8AC, 0xC8AD, 0xC8AE, 0xC8AF, 0xC8B0, 	// 0x8333B939
	0xC8B1, 0xC8B2, 0xC8B3, 0xC8B4, 0xC8B5, 0xC8B6, 0xC8B7, 0xC8B8, 0xC8B9, 0xC8BA, 	// 0x8333BA39
	0xC8BB, 0xC8BC, 0xC8BD, 0xC8BE, 0xC8BF, 0xC8C0, 0xC8C1, 0xC8C2, 0xC8C3, 0xC8C4, 	// 0x8333BB39
	0xC8C5, 0xC8C6, 0xC8C7, 0xC8C8, 0xC8C9, 0xC8CA, 0xC8CB, 0xC8CC, 0xC8CD, 0xC8CE, 	// 0x8333BC39
	0xC8CF, 0xC8D0, 0xC8D1, 0xC8D2, 0xC8D3, 0xC8D4, 0xC8D5, 0xC8D6, 0xC8D7, 0xC8D8, 	// 0x8333BD39
	0xC8D9, 0xC8DA, 0xC8DB, 0xC8DC, 0xC8DD, 0xC8DE, 0xC8DF, 0xC8E0, 0xC8E1, 0xC8E2, 	// 0x8333BE39
	0xC8E3, 0xC8E4, 0xC8E5, 0xC8E6, 0xC8E7, 0xC8E8, 0xC8E9, 0xC8EA, 0xC8EB, 0xC8EC, 	// 0x8333BF39
	0xC8ED, 0xC8EE, 0xC8EF, 0xC8F0, 0xC8F1, 0xC8F2, 0xC8F3, 0xC8F4, 0xC8F5, 0xC8F6, 	// 0x8333C039
	0xC8F7, 0xC8F8, 0xC8F9, 0xC8FA, 0xC8FB, 0xC8FC, 0xC8FD, 0xC8FE, 0xC8FF, 0xC900, 	// 0x8333C139
	0xC901, 0xC902, 0xC903, 0xC904, 0xC905, 0xC906, 0xC907, 0xC908, 0xC909, 0xC90A, 	// 0x8333C239
	0xC90B, 0xC90C, 0xC90D, 0xC90E, 0xC90F, 0xC910, 0xC911, 0xC912, 0xC913, 0xC914, 	// 0x8333C339
	0xC915, 0xC916, 0xC917, 0xC918, 0xC919, 0xC91A, 0xC91B, 0xC91C, 0xC91D, 0xC91E, 	// 0x8333C439
	0xC91F, 0xC920, 0xC921, 0xC922, 0xC923, 0xC924, 0xC925, 0xC926, 0xC927, 0xC928, 	// 0x8333C539
	0xC929, 0xC92A, 0xC92B, 0xC92C, 0xC92D, 0xC92E, 0xC92F, 0xC930, 0xC931, 0xC932, 	// 0x8333C639
	0xC933, 0xC934, 0xC935, 0xC936, 0xC937, 0xC938, 0xC939, 0xC93A, 0xC93B, 0xC93C, 	// 0x8333C739
	0xC93D, 0xC93E, 0xC93F, 0xC940, 0xC941, 0xC942, 0xC943, 0xC944, 0xC945, 0xC946, 	// 0x8333C839
	0xC947, 0xC948, 0xC949, 0xC94A, 0xC94B, 0xC94C, 0xC94D, 0xC94E, 0xC94F, 0xC950, 	// 0x8333C939
	0xC951, 0xC952, 0xC953, 0xC954, 0xC955, 0xC956, 0xC957, 0xC958, 0xC959, 0xC95A, 	// 0x8333CA39
	0xC95B, 0xC95C, 0xC95D, 0xC95E, 0xC95F, 0xC960, 0xC961, 0xC962, 0xC963, 0xC964, 	// 0x8333CB39
	0xC965, 0xC966, 0xC967, 0xC968, 0xC969, 0xC96A, 0xC96B, 0xC96C, 0xC96D, 0xC96E, 	// 0x8333CC39
	0xC96F, 0xC970, 0xC971, 0xC972, 0xC973, 0xC974, 0xC975, 0xC976, 0xC977, 0xC978, 	// 0x8333CD39
	0xC979, 0xC97A, 0xC97B, 0xC97C, 0xC97D, 0xC97E, 0xC97F, 0xC980, 0xC981, 0xC982, 	// 0x8333CE39
	0xC983, 0xC984, 0xC985, 0xC986, 0xC987, 0xC988, 0xC989, 0xC98A, 0xC98B, 0xC98C, 	// 0x8333CF39
	0xC98D, 0xC98E, 0xC98F, 0xC990, 0xC991, 0xC992, 0xC993, 0xC994, 0xC995, 0xC996, 	// 0x8333D039
	0xC997, 0xC998, 0xC999, 0xC99A, 0xC99B, 0xC99C, 0xC99D, 0xC99E, 0xC99F, 0xC9A0, 	// 0x8333D139
	0xC9A1, 0xC9A2, 0xC9A3, 0xC9A4, 0xC9A5, 0xC9A6, 0xC9A7, 0xC9A8, 0xC9A9, 0xC9AA, 	// 0x8333D239
	0xC9AB, 0xC9AC, 0xC9AD, 0xC9AE, 0xC9AF, 0xC9B0, 0xC9B1, 0xC9B2, 0xC9B3, 0xC9B4, 	// 0x8333D339
	0xC9B5, 0xC9B6, 0xC9B7, 0xC9B8, 0xC9B9, 0xC9BA, 0xC9BB, 0xC9BC, 0xC9BD, 0xC9BE, 	// 0x8333D439
	0xC9BF, 0xC9C0, 0xC9C1, 0xC9C2, 0xC9C3, 0xC9C4, 0xC9C5, 0xC9C6, 0xC9C7, 0xC9C8, 	// 0x8333D539
	0xC9C9, 0xC9CA, 0xC9CB, 0xC9CC, 0xC9CD, 0xC9CE, 0xC9CF, 0xC9D0, 0xC9D1, 0xC9D2, 	// 0x8333D639
	0xC9D3, 0xC9D4, 0xC9D5, 0xC9D6, 0xC9D7, 0xC9D8, 0xC9D9, 0xC9DA, 0xC9DB, 0xC9DC, 	// 0x8333D739
	0xC9DD, 0xC9DE, 0xC9DF, 0xC9E0, 0xC9E1, 0xC9E2, 0xC9E3, 0xC9E4, 0xC9E5, 0xC9E6, 	// 0x8333D839
	0xC9E7, 0xC9E8, 0xC9E9, 0xC9EA, 0xC9EB, 0xC9EC, 0xC9ED, 0xC9EE, 0xC9EF, 0xC9F0, 	// 0x8333D939
	0xC9F1, 0xC9F2, 0xC9F3, 0xC9F4, 0xC9F5, 0xC9F6, 0xC9F7, 0xC9F8, 0xC9F9, 0xC9FA, 	// 0x8333DA39
	0xC9FB, 0xC9FC, 0xC9FD, 0xC9FE, 0xC9FF, 0xCA00, 0xCA01, 0xCA02, 0xCA03, 0xCA04, 	// 0x8333DB39
	0xCA05, 0xCA06, 0xCA07, 0xCA08, 0xCA09, 0xCA0A, 0xCA0B, 0xCA0C, 0xCA0D, 0xCA0E, 	// 0x8333DC39
	0xCA0F, 0xCA10, 0xCA11, 0xCA12, 0xCA13, 0xCA14, 0xCA15, 0xCA16, 0xCA17, 0xCA18, 	// 0x8333DD39
	0xCA19, 0xCA1A, 0xCA1B, 0xCA1C, 0xCA1D, 0xCA1E, 0xCA1F, 0xCA20, 0xCA21, 0xCA22, 	// 0x8333DE39
	0xCA23, 0xCA24, 0xCA25, 0xCA26, 0xCA27, 0xCA28, 0xCA29, 0xCA2A, 0xCA2B, 0xCA2C, 	// 0x8333DF39
	0xCA2D, 0xCA2E, 0xCA2F, 0xCA30, 0xCA31, 0xCA32, 0xCA33, 0xCA34, 0xCA35, 0xCA36, 	// 0x8333E039
	0xCA37, 0xCA38, 0xCA39, 0xCA3A, 0xCA3B, 0xCA3C, 0xCA3D, 0xCA3E, 0xCA3F, 0xCA40, 	// 0x8333E139
	0xCA41, 0xCA42, 0xCA43, 0xCA44, 0xCA45, 0xCA46, 0xCA47, 0xCA48, 0xCA49, 0xCA4A, 	// 0x8333E239
	0xCA4B, 0xCA4C, 0xCA4D, 0xCA4E, 0xCA4F, 0xCA50, 0xCA51, 0xCA52, 0xCA53, 0xCA54, 	// 0x8333E339
	0xCA55, 0xCA56, 0xCA57, 0xCA58, 0xCA59, 0xCA5A, 0xCA5B, 0xCA5C, 0xCA5D, 0xCA5E, 	// 0x8333E439
	0xCA5F, 0xCA60, 0xCA61, 0xCA62, 0xCA63, 0xCA64, 0xCA65, 0xCA66, 0xCA67, 0xCA68, 	// 0x8333E539
	0xCA69, 0xCA6A, 0xCA6B, 0xCA6C, 0xCA6D, 0xCA6E, 0xCA6F, 0xCA70, 0xCA71, 0xCA72, 	// 0x8333E639
	0xCA73, 0xCA74, 0xCA75, 0xCA76, 0xCA77, 0xCA78, 0xCA79, 0xCA7A, 0xCA7B, 0xCA7C, 	// 0x8333E739
	0xCA7D, 0xCA7E, 0xCA7F, 0xCA80, 0xCA81, 0xCA82, 0xCA83, 0xCA84, 0xCA85, 0xCA86, 	// 0x8333E839
	0xCA87, 0xCA88, 0xCA89, 0xCA8A, 0xCA8B, 0xCA8C, 0xCA8D, 0xCA8E, 0xCA8F, 0xCA90, 	// 0x8333E939
	0xCA91, 0xCA92, 0xCA93, 0xCA94, 0xCA95, 0xCA96, 0xCA97, 0xCA98, 0xCA99, 0xCA9A, 	// 0x8333EA39
	0xCA9B, 0xCA9C, 0xCA9D, 0xCA9E, 0xCA9F, 0xCAA0, 0xCAA1, 0xCAA2, 0xCAA3, 0xCAA4, 	// 0x8333EB39
	0xCAA5, 0xCAA6, 0xCAA7, 0xCAA8, 0xCAA9, 0xCAAA, 0xCAAB, 0xCAAC, 0xCAAD, 0xCAAE, 	// 0x8333EC39
	0xCAAF, 0xCAB0, 0xCAB1, 0xCAB2, 0xCAB3, 0xCAB4, 0xCAB5, 0xCAB6, 0xCAB7, 0xCAB8, 	// 0x8333ED39
	0xCAB9, 0xCABA, 0xCABB, 0xCABC, 0xCABD, 0xCABE, 0xCABF, 0xCAC0, 0xCAC1, 0xCAC2, 	// 0x8333EE39
	0xCAC3, 0xCAC4, 0xCAC5, 0xCAC6, 0xCAC7, 0xCAC8, 0xCAC9, 0xCACA, 0xCACB, 0xCACC, 	// 0x8333EF39
	0xCACD, 0xCACE, 0xCACF, 0xCAD0, 0xCAD1, 0xCAD2, 0xCAD3, 0xCAD4, 0xCAD5, 0xCAD6, 	// 0x8333F039
	0xCAD7, 0xCAD8, 0xCAD9, 0xCADA, 0xCADB, 0xCADC, 0xCADD, 0xCADE, 0xCADF, 0xCAE0, 	// 0x8333F139
	0xCAE1, 0xCAE2, 0xCAE3, 0xCAE4, 0xCAE5, 0xCAE6, 0xCAE7, 0xCAE8, 0xCAE9, 0xCAEA, 	// 0x8333F239
	0xCAEB, 0xCAEC, 0xCAED, 0xCAEE, 0xCAEF, 0xCAF0, 0xCAF1, 0xCAF2, 0xCAF3, 0xCAF4, 	// 0x8333F339
	0xCAF5, 0xCAF6, 0xCAF7, 0xCAF8, 0xCAF9, 0xCAFA, 0xCAFB, 0xCAFC, 0xCAFD, 0xCAFE, 	// 0x8333F439
	0xCAFF, 0xCB00, 0xCB01, 0xCB02, 0xCB03, 0xCB04, 0xCB05, 0xCB06, 0xCB07, 0xCB08, 	// 0x8333F539
	0xCB09, 0xCB0A, 0xCB0B, 0xCB0C, 0xCB0D, 0xCB0E, 0xCB0F, 0xCB10, 0xCB11, 0xCB12, 	// 0x8333F639
	0xCB13, 0xCB14, 0xCB15, 0xCB16, 0xCB17, 0xCB18, 0xCB19, 0xCB1A, 0xCB1B, 0xCB1C, 	// 0x8333F739
	0xCB1D, 0xCB1E, 0xCB1F, 0xCB20, 0xCB21, 0xCB22, 0xCB23, 0xCB24, 0xCB25, 0xCB26, 	// 0x8333F839
	0xCB27, 0xCB28, 0xCB29, 0xCB2A, 0xCB2B, 0xCB2C, 0xCB2D, 0xCB2E, 0xCB2F, 0xCB30, 	// 0x8333F939
	0xCB31, 0xCB32, 0xCB33, 0xCB34, 0xCB35, 0xCB36, 0xCB37, 0xCB38, 0xCB39, 0xCB3A, 	// 0x8333FA39
	0xCB3B, 0xCB3C, 0xCB3D, 0xCB3E, 0xCB3F, 0xCB40, 0xCB41, 0xCB42, 0xCB43, 0xCB44, 	// 0x8333FB39
	0xCB45, 0xCB46, 0xCB47, 0xCB48, 0xCB49, 0xCB4A, 0xCB4B, 0xCB4C, 0xCB4D, 0xCB4E, 	// 0x8333FC39
	0xCB4F, 0xCB50, 0xCB51, 0xCB52, 0xCB53, 0xCB54, 0xCB55, 0xCB56, 0xCB57, 0xCB58, 	// 0x8333FD39
	0xCB59, 0xCB5A, 0xCB5B, 0xCB5C, 0xCB5D, 0xCB5E, 0xCB5F, 0xCB60, 0xCB61, 0xCB62, 	// 0x8333FE39
	0xCB63, 0xCB64, 0xCB65, 0xCB66, 0xCB67, 0xCB68, 0xCB69, 0xCB6A, 0xCB6B, 0xCB6C, 	// 0x83348139
	0xCB6D, 0xCB6E, 0xCB6F, 0xCB70, 0xCB71, 0xCB72, 0xCB73, 0xCB74, 0xCB75, 0xCB76, 	// 0x83348239
	0xCB77, 0xCB78, 0xCB79, 0xCB7A, 0xCB7B, 0xCB7C, 0xCB7D, 0xCB7E, 0xCB7F, 0xCB80, 	// 0x83348339
	0xCB81, 0xCB82, 0xCB83, 0xCB84, 0xCB85, 0xCB86, 0xCB87, 0xCB88, 0xCB89, 0xCB8A, 	// 0x83348439
	0xCB8B, 0xCB8C, 0xCB8D, 0xCB8E, 0xCB8F, 0xCB90, 0xCB91, 0xCB92, 0xCB93, 0xCB94, 	// 0x83348539
	0xCB95, 0xCB96, 0xCB97, 0xCB98, 0xCB99, 0xCB9A, 0xCB9B, 0xCB9C, 0xCB9D, 0xCB9E, 	// 0x83348639
	0xCB9F, 0xCBA0, 0xCBA1, 0xCBA2, 0xCBA3, 0xCBA4, 0xCBA5, 0xCBA6, 0xCBA7, 0xCBA8, 	// 0x83348739
	0xCBA9, 0xCBAA, 0xCBAB, 0xCBAC, 0xCBAD, 0xCBAE, 0xCBAF, 0xCBB0, 0xCBB1, 0xCBB2, 	// 0x83348839
	0xCBB3, 0xCBB4, 0xCBB5, 0xCBB6, 0xCBB7, 0xCBB8, 0xCBB9, 0xCBBA, 0xCBBB, 0xCBBC, 	// 0x83348939
	0xCBBD, 0xCBBE, 0xCBBF, 0xCBC0, 0xCBC1, 0xCBC2, 0xCBC3, 0xCBC4, 0xCBC5, 0xCBC6, 	// 0x83348A39
	0xCBC7, 0xCBC8, 0xCBC9, 0xCBCA, 0xCBCB, 0xCBCC, 0xCBCD, 0xCBCE, 0xCBCF, 0xCBD0, 	// 0x83348B39
	0xCBD1, 0xCBD2, 0xCBD3, 0xCBD4, 0xCBD5, 0xCBD6, 0xCBD7, 0xCBD8, 0xCBD9, 0xCBDA, 	// 0x83348C39
	0xCBDB, 0xCBDC, 0xCBDD, 0xCBDE, 0xCBDF, 0xCBE0, 0xCBE1, 0xCBE2, 0xCBE3, 0xCBE4, 	// 0x83348D39
	0xCBE5, 0xCBE6, 0xCBE7, 0xCBE8, 0xCBE9, 0xCBEA, 0xCBEB, 0xCBEC, 0xCBED, 0xCBEE, 	// 0x83348E39
	0xCBEF, 0xCBF0, 0xCBF1, 0xCBF2, 0xCBF3, 0xCBF4, 0xCBF5, 0xCBF6, 0xCBF7, 0xCBF8, 	// 0x83348F39
	0xCBF9, 0xCBFA, 0xCBFB, 0xCBFC, 0xCBFD, 0xCBFE, 0xCBFF, 0xCC00, 0xCC01, 0xCC02, 	// 0x83349039
	0xCC03, 0xCC04, 0xCC05, 0xCC06, 0xCC07, 0xCC08, 0xCC09, 0xCC0A, 0xCC0B, 0xCC0C, 	// 0x83349139
	0xCC0D, 0xCC0E, 0xCC0F, 0xCC10, 0xCC11, 0xCC12, 0xCC13, 0xCC14, 0xCC15, 0xCC16, 	// 0x83349239
	0xCC17, 0xCC18, 0xCC19, 0xCC1A, 0xCC1B, 0xCC1C, 0xCC1D, 0xCC1E, 0xCC1F, 0xCC20, 	// 0x83349339
	0xCC21, 0xCC22, 0xCC23, 0xCC24, 0xCC25, 0xCC26, 0xCC27, 0xCC28, 0xCC29, 0xCC2A, 	// 0x83349439
	0xCC2B, 0xCC2C, 0xCC2D, 0xCC2E, 0xCC2F, 0xCC30, 0xCC31, 0xCC32, 0xCC33, 0xCC34, 	// 0x83349539
	0xCC35, 0xCC36, 0xCC37, 0xCC38, 0xCC39, 0xCC3A, 0xCC3B, 0xCC3C, 0xCC3D, 0xCC3E, 	// 0x83349639
	0xCC3F, 0xCC40, 0xCC41, 0xCC42, 0xCC43, 0xCC44, 0xCC45, 0xCC46, 0xCC47, 0xCC48, 	// 0x83349739
	0xCC49, 0xCC4A, 0xCC4B, 0xCC4C, 0xCC4D, 0xCC4E, 0xCC4F, 0xCC50, 0xCC51, 0xCC52, 	// 0x83349839
	0xCC53, 0xCC54, 0xCC55, 0xCC56, 0xCC57, 0xCC58, 0xCC59, 0xCC5A, 0xCC5B, 0xCC5C, 	// 0x83349939
	0xCC5D, 0xCC5E, 0xCC5F, 0xCC60, 0xCC61, 0xCC62, 0xCC63, 0xCC64, 0xCC65, 0xCC66, 	// 0x83349A39
	0xCC67, 0xCC68, 0xCC69, 0xCC6A, 0xCC6B, 0xCC6C, 0xCC6D, 0xCC6E, 0xCC6F, 0xCC70, 	// 0x83349B39
	0xCC71, 0xCC72, 0xCC73, 0xCC74, 0xCC75, 0xCC76, 0xCC77, 0xCC78, 0xCC79, 0xCC7A, 	// 0x83349C39
	0xCC7B, 0xCC7C, 0xCC7D, 0xCC7E, 0xCC7F, 0xCC80, 0xCC81, 0xCC82, 0xCC83, 0xCC84, 	// 0x83349D39
	0xCC85, 0xCC86, 0xCC87, 0xCC88, 0xCC89, 0xCC8A, 0xCC8B, 0xCC8C, 0xCC8D, 0xCC8E, 	// 0x83349E39
	0xCC8F, 0xCC90, 0xCC91, 0xCC92, 0xCC93, 0xCC94, 0xCC95, 0xCC96, 0xCC97, 0xCC98, 	// 0x83349F39
	0xCC99, 0xCC9A, 0xCC9B, 0xCC9C, 0xCC9D, 0xCC9E, 0xCC9F, 0xCCA0, 0xCCA1, 0xCCA2, 	// 0x8334A039
	0xCCA3, 0xCCA4, 0xCCA5, 0xCCA6, 0xCCA7, 0xCCA8, 0xCCA9, 0xCCAA, 0xCCAB, 0xCCAC, 	// 0x8334A139
	0xCCAD, 0xCCAE, 0xCCAF, 0xCCB0, 0xCCB1, 0xCCB2, 0xCCB3, 0xCCB4, 0xCCB5, 0xCCB6, 	// 0x8334A239
	0xCCB7, 0xCCB8, 0xCCB9, 0xCCBA, 0xCCBB, 0xCCBC, 0xCCBD, 0xCCBE, 0xCCBF, 0xCCC0, 	// 0x8334A339
	0xCCC1, 0xCCC2, 0xCCC3, 0xCCC4, 0xCCC5, 0xCCC6, 0xCCC7, 0xCCC8, 0xCCC9, 0xCCCA, 	// 0x8334A439
	0xCCCB, 0xCCCC, 0xCCCD, 0xCCCE, 0xCCCF, 0xCCD0, 0xCCD1, 0xCCD2, 0xCCD3, 0xCCD4, 	// 0x8334A539
	0xCCD5, 0xCCD6, 0xCCD7, 0xCCD8, 0xCCD9, 0xCCDA, 0xCCDB, 0xCCDC, 0xCCDD, 0xCCDE, 	// 0x8334A639
	0xCCDF, 0xCCE0, 0xCCE1, 0xCCE2, 0xCCE3, 0xCCE4, 0xCCE5, 0xCCE6, 0xCCE7, 0xCCE8, 	// 0x8334A739
	0xCCE9, 0xCCEA, 0xCCEB, 0xCCEC, 0xCCED, 0xCCEE, 0xCCEF, 0xCCF0, 0xCCF1, 0xCCF2, 	// 0x8334A839
	0xCCF3, 0xCCF4, 0xCCF5, 0xCCF6, 0xCCF7, 0xCCF8, 0xCCF9, 0xCCFA, 0xCCFB, 0xCCFC, 	// 0x8334A939
	0xCCFD, 0xCCFE, 0xCCFF, 0xCD00, 0xCD01, 0xCD02, 0xCD03, 0xCD04, 0xCD05, 0xCD06, 	// 0x8334AA39
	0xCD07, 0xCD08, 0xCD09, 0xCD0A, 0xCD0B, 0xCD0C, 0xCD0D, 0xCD0E, 0xCD0F, 0xCD10, 	// 0x8334AB39
	0xCD11, 0xCD12, 0xCD13, 0xCD14, 0xCD15, 0xCD16, 0xCD17, 0xCD18, 0xCD19, 0xCD1A, 	// 0x8334AC39
	0xCD1B, 0xCD1C, 0xCD1D, 0xCD1E, 0xCD1F, 0xCD20, 0xCD21, 0xCD22, 0xCD23, 0xCD24, 	// 0x8334AD39
	0xCD25, 0xCD26, 0xCD27, 0xCD28, 0xCD29, 0xCD2A, 0xCD2B, 0xCD2C, 0xCD2D, 0xCD2E, 	// 0x8334AE39
	0xCD2F, 0xCD30, 0xCD31, 0xCD32, 0xCD33, 0xCD34, 0xCD35, 0xCD36, 0xCD37, 0xCD38, 	// 0x8334AF39
	0xCD39, 0xCD3A, 0xCD3B, 0xCD3C, 0xCD3D, 0xCD3E, 0xCD3F, 0xCD40, 0xCD41, 0xCD42, 	// 0x8334B039
	0xCD43, 0xCD44, 0xCD45, 0xCD46, 0xCD47, 0xCD48, 0xCD49, 0xCD4A, 0xCD4B, 0xCD4C, 	// 0x8334B139
	0xCD4D, 0xCD4E, 0xCD4F, 0xCD50, 0xCD51, 0xCD52, 0xCD53, 0xCD54, 0xCD55, 0xCD56, 	// 0x8334B239
	0xCD57, 0xCD58, 0xCD59, 0xCD5A, 0xCD5B, 0xCD5C, 0xCD5D, 0xCD5E, 0xCD5F, 0xCD60, 	// 0x8334B339
	0xCD61, 0xCD62, 0xCD63, 0xCD64, 0xCD65, 0xCD66, 0xCD67, 0xCD68, 0xCD69, 0xCD6A, 	// 0x8334B439
	0xCD6B, 0xCD6C, 0xCD6D, 0xCD6E, 0xCD6F, 0xCD70, 0xCD71, 0xCD72, 0xCD73, 0xCD74, 	// 0x8334B539
	0xCD75, 0xCD76, 0xCD77, 0xCD78, 0xCD79, 0xCD7A, 0xCD7B, 0xCD7C, 0xCD7D, 0xCD7E, 	// 0x8334B639
	0xCD7F, 0xCD80, 0xCD81, 0xCD82, 0xCD83, 0xCD84, 0xCD85, 0xCD86, 0xCD87, 0xCD88, 	// 0x8334B739
	0xCD89, 0xCD8A, 0xCD8B, 0xCD8C, 0xCD8D, 0xCD8E, 0xCD8F, 0xCD90, 0xCD91, 0xCD92, 	// 0x8334B839
	0xCD93, 0xCD94, 0xCD95, 0xCD96, 0xCD97, 0xCD98, 0xCD99, 0xCD9A, 0xCD9B, 0xCD9C, 	// 0x8334B939
	0xCD9D, 0xCD9E, 0xCD9F, 0xCDA0, 0xCDA1, 0xCDA2, 0xCDA3, 0xCDA4, 0xCDA5, 0xCDA6, 	// 0x8334BA39
	0xCDA7, 0xCDA8, 0xCDA9, 0xCDAA, 0xCDAB, 0xCDAC, 0xCDAD, 0xCDAE, 0xCDAF, 0xCDB0, 	// 0x8334BB39
	0xCDB1, 0xCDB2, 0xCDB3, 0xCDB4, 0xCDB5, 0xCDB6, 0xCDB7, 0xCDB8, 0xCDB9, 0xCDBA, 	// 0x8334BC39
	0xCDBB, 0xCDBC, 0xCDBD, 0xCDBE, 0xCDBF, 0xCDC0, 0xCDC1, 0xCDC2, 0xCDC3, 0xCDC4, 	// 0x8334BD39
	0xCDC5, 0xCDC6, 0xCDC7, 0xCDC8, 0xCDC9, 0xCDCA, 0xCDCB, 0xCDCC, 0xCDCD, 0xCDCE, 	// 0x8334BE39
	0xCDCF, 0xCDD0, 0xCDD1, 0xCDD2, 0xCDD3, 0xCDD4, 0xCDD5, 0xCDD6, 0xCDD7, 0xCDD8, 	// 0x8334BF39
	0xCDD9, 0xCDDA, 0xCDDB, 0xCDDC, 0xCDDD, 0xCDDE, 0xCDDF, 0xCDE0, 0xCDE1, 0xCDE2, 	// 0x8334C039
	0xCDE3, 0xCDE4, 0xCDE5, 0xCDE6, 0xCDE7, 0xCDE8, 0xCDE9, 0xCDEA, 0xCDEB, 0xCDEC, 	// 0x8334C139
	0xCDED, 0xCDEE, 0xCDEF, 0xCDF0, 0xCDF1, 0xCDF2, 0xCDF3, 0xCDF4, 0xCDF5, 0xCDF6, 	// 0x8334C239
	0xCDF7, 0xCDF8, 0xCDF9, 0xCDFA, 0xCDFB, 0xCDFC, 0xCDFD, 0xCDFE, 0xCDFF, 0xCE00, 	// 0x8334C339
	0xCE01, 0xCE02, 0xCE03, 0xCE04, 0xCE05, 0xCE06, 0xCE07, 0xCE08, 0xCE09, 0xCE0A, 	// 0x8334C439
	0xCE0B, 0xCE0C, 0xCE0D, 0xCE0E, 0xCE0F, 0xCE10, 0xCE11, 0xCE12, 0xCE13, 0xCE14, 	// 0x8334C539
	0xCE15, 0xCE16, 0xCE17, 0xCE18, 0xCE19, 0xCE1A, 0xCE1B, 0xCE1C, 0xCE1D, 0xCE1E, 	// 0x8334C639
	0xCE1F, 0xCE20, 0xCE21, 0xCE22, 0xCE23, 0xCE24, 0xCE25, 0xCE26, 0xCE27, 0xCE28, 	// 0x8334C739
	0xCE29, 0xCE2A, 0xCE2B, 0xCE2C, 0xCE2D, 0xCE2E, 0xCE2F, 0xCE30, 0xCE31, 0xCE32, 	// 0x8334C839
	0xCE33, 0xCE34, 0xCE35, 0xCE36, 0xCE37, 0xCE38, 0xCE39, 0xCE3A, 0xCE3B, 0xCE3C, 	// 0x8334C939
	0xCE3D, 0xCE3E, 0xCE3F, 0xCE40, 0xCE41, 0xCE42, 0xCE43, 0xCE44, 0xCE45, 0xCE46, 	// 0x8334CA39
	0xCE47, 0xCE48, 0xCE49, 0xCE4A, 0xCE4B, 0xCE4C, 0xCE4D, 0xCE4E, 0xCE4F, 0xCE50, 	// 0x8334CB39
	0xCE51, 0xCE52, 0xCE53, 0xCE54, 0xCE55, 0xCE56, 0xCE57, 0xCE58, 0xCE59, 0xCE5A, 	// 0x8334CC39
	0xCE5B, 0xCE5C, 0xCE5D, 0xCE5E, 0xCE5F, 0xCE60, 0xCE61, 0xCE62, 0xCE63, 0xCE64, 	// 0x8334CD39
	0xCE65, 0xCE66, 0xCE67, 0xCE68, 0xCE69, 0xCE6A, 0xCE6B, 0xCE6C, 0xCE6D, 0xCE6E, 	// 0x8334CE39
	0xCE6F, 0xCE70, 0xCE71, 0xCE72, 0xCE73, 0xCE74, 0xCE75, 0xCE76, 0xCE77, 0xCE78, 	// 0x8334CF39
	0xCE79, 0xCE7A, 0xCE7B, 0xCE7C, 0xCE7D, 0xCE7E, 0xCE7F, 0xCE80, 0xCE81, 0xCE82, 	// 0x8334D039
	0xCE83, 0xCE84, 0xCE85, 0xCE86, 0xCE87, 0xCE88, 0xCE89, 0xCE8A, 0xCE8B, 0xCE8C, 	// 0x8334D139
	0xCE8D, 0xCE8E, 0xCE8F, 0xCE90, 0xCE91, 0xCE92, 0xCE93, 0xCE94, 0xCE95, 0xCE96, 	// 0x8334D239
	0xCE97, 0xCE98, 0xCE99, 0xCE9A, 0xCE9B, 0xCE9C, 0xCE9D, 0xCE9E, 0xCE9F, 0xCEA0, 	// 0x8334D339
	0xCEA1, 0xCEA2, 0xCEA3, 0xCEA4, 0xCEA5, 0xCEA6, 0xCEA7, 0xCEA8, 0xCEA9, 0xCEAA, 	// 0x8334D439
	0xCEAB, 0xCEAC, 0xCEAD, 0xCEAE, 0xCEAF, 0xCEB0, 0xCEB1, 0xCEB2, 0xCEB3, 0xCEB4, 	// 0x8334D539
	0xCEB5, 0xCEB6, 0xCEB7, 0xCEB8, 0xCEB9, 0xCEBA, 0xCEBB, 0xCEBC, 0xCEBD, 0xCEBE, 	// 0x8334D639
	0xCEBF, 0xCEC0, 0xCEC1, 0xCEC2, 0xCEC3, 0xCEC4, 0xCEC5, 0xCEC6, 0xCEC7, 0xCEC8, 	// 0x8334D739
	0xCEC9, 0xCECA, 0xCECB, 0xCECC, 0xCECD, 0xCECE, 0xCECF, 0xCED0, 0xCED1, 0xCED2, 	// 0x8334D839
	0xCED3, 0xCED4, 0xCED5, 0xCED6, 0xCED7, 0xCED8, 0xCED9, 0xCEDA, 0xCEDB, 0xCEDC, 	// 0x8334D939
	0xCEDD, 0xCEDE, 0xCEDF, 0xCEE0, 0xCEE1, 0xCEE2, 0xCEE3, 0xCEE4, 0xCEE5, 0xCEE6, 	// 0x8334DA39
	0xCEE7, 0xCEE8, 0xCEE9, 0xCEEA, 0xCEEB, 0xCEEC, 0xCEED, 0xCEEE, 0xCEEF, 0xCEF0, 	// 0x8334DB39
	0xCEF1, 0xCEF2, 0xCEF3, 0xCEF4, 0xCEF5, 0xCEF6, 0xCEF7, 0xCEF8, 0xCEF9, 0xCEFA, 	// 0x8334DC39
	0xCEFB, 0xCEFC, 0xCEFD, 0xCEFE, 0xCEFF, 0xCF00, 0xCF01, 0xCF02, 0xCF03, 0xCF04, 	// 0x8334DD39
	0xCF05, 0xCF06, 0xCF07, 0xCF08, 0xCF09, 0xCF0A, 0xCF0B, 0xCF0C, 0xCF0D, 0xCF0E, 	// 0x8334DE39
	0xCF0F, 0xCF10, 0xCF11, 0xCF12, 0xCF13, 0xCF14, 0xCF15, 0xCF16, 0xCF17, 0xCF18, 	// 0x8334DF39
	0xCF19, 0xCF1A, 0xCF1B, 0xCF1C, 0xCF1D, 0xCF1E, 0xCF1F, 0xCF20, 0xCF21, 0xCF22, 	// 0x8334E039
	0xCF23, 0xCF24, 0xCF25, 0xCF26, 0xCF27, 0xCF28, 0xCF29, 0xCF2A, 0xCF2B, 0xCF2C, 	// 0x8334E139
	0xCF2D, 0xCF2E, 0xCF2F, 0xCF30, 0xCF31, 0xCF32, 0xCF33, 0xCF34, 0xCF35, 0xCF36, 	// 0x8334E239
	0xCF37, 0xCF38, 0xCF39, 0xCF3A, 0xCF3B, 0xCF3C, 0xCF3D, 0xCF3E, 0xCF3F, 0xCF40, 	// 0x8334E339
	0xCF41, 0xCF42, 0xCF43, 0xCF44, 0xCF45, 0xCF46, 0xCF47, 0xCF48, 0xCF49, 0xCF4A, 	// 0x8334E439
	0xCF4B, 0xCF4C, 0xCF4D, 0xCF4E, 0xCF4F, 0xCF50, 0xCF51, 0xCF52, 0xCF53, 0xCF54, 	// 0x8334E539
	0xCF55, 0xCF56, 0xCF57, 0xCF58, 0xCF59, 0xCF5A, 0xCF5B, 0xCF5C, 0xCF5D, 0xCF5E, 	// 0x8334E639
	0xCF5F, 0xCF60, 0xCF61, 0xCF62, 0xCF63, 0xCF64, 0xCF65, 0xCF66, 0xCF67, 0xCF68, 	// 0x8334E739
	0xCF69, 0xCF6A, 0xCF6B, 0xCF6C, 0xCF6D, 0xCF6E, 0xCF6F, 0xCF70, 0xCF71, 0xCF72, 	// 0x8334E839
	0xCF73, 0xCF74, 0xCF75, 0xCF76, 0xCF77, 0xCF78, 0xCF79, 0xCF7A, 0xCF7B, 0xCF7C, 	// 0x8334E939
	0xCF7D, 0xCF7E, 0xCF7F, 0xCF80, 0xCF81, 0xCF82, 0xCF83, 0xCF84, 0xCF85, 0xCF86, 	// 0x8334EA39
	0xCF87, 0xCF88, 0xCF89, 0xCF8A, 0xCF8B, 0xCF8C, 0xCF8D, 0xCF8E, 0xCF8F, 0xCF90, 	// 0x8334EB39
	0xCF91, 0xCF92, 0xCF93, 0xCF94, 0xCF95, 0xCF96, 0xCF97, 0xCF98, 0xCF99, 0xCF9A, 	// 0x8334EC39
	0xCF9B, 0xCF9C, 0xCF9D, 0xCF9E, 0xCF9F, 0xCFA0, 0xCFA1, 0xCFA2, 0xCFA3, 0xCFA4, 	// 0x8334ED39
	0xCFA5, 0xCFA6, 0xCFA7, 0xCFA8, 0xCFA9, 0xCFAA, 0xCFAB, 0xCFAC, 0xCFAD, 0xCFAE, 	// 0x8334EE39
	0xCFAF, 0xCFB0, 0xCFB1, 0xCFB2, 0xCFB3, 0xCFB4, 0xCFB5, 0xCFB6, 0xCFB7, 0xCFB8, 	// 0x8334EF39
	0xCFB9, 0xCFBA, 0xCFBB, 0xCFBC, 0xCFBD, 0xCFBE, 0xCFBF, 0xCFC0, 0xCFC1, 0xCFC2, 	// 0x8334F039
	0xCFC3, 0xCFC4, 0xCFC5, 0xCFC6, 0xCFC7, 0xCFC8, 0xCFC9, 0xCFCA, 0xCFCB, 0xCFCC, 	// 0x8334F139
	0xCFCD, 0xCFCE, 0xCFCF, 0xCFD0, 0xCFD1, 0xCFD2, 0xCFD3, 0xCFD4, 0xCFD5, 0xCFD6, 	// 0x8334F239
	0xCFD7, 0xCFD8, 0xCFD9, 0xCFDA, 0xCFDB, 0xCFDC, 0xCFDD, 0xCFDE, 0xCFDF, 0xCFE0, 	// 0x8334F339
	0xCFE1, 0xCFE2, 0xCFE3, 0xCFE4, 0xCFE5, 0xCFE6, 0xCFE7, 0xCFE8, 0xCFE9, 0xCFEA, 	// 0x8334F439
	0xCFEB, 0xCFEC, 0xCFED, 0xCFEE, 0xCFEF, 0xCFF0, 0xCFF1, 0xCFF2, 0xCFF3, 0xCFF4, 	// 0x8334F539
	0xCFF5, 0xCFF6, 0xCFF7, 0xCFF8, 0xCFF9, 0xCFFA, 0xCFFB, 0xCFFC, 0xCFFD, 0xCFFE, 	// 0x8334F639
	0xCFFF, 0xD000, 0xD001, 0xD002, 0xD003, 0xD004, 0xD005, 0xD006, 0xD007, 0xD008, 	// 0x8334F739
	0xD009, 0xD00A, 0xD00B, 0xD00C, 0xD00D, 0xD00E, 0xD00F, 0xD010, 0xD011, 0xD012, 	// 0x8334F839
	0xD013, 0xD014, 0xD015, 0xD016, 0xD017, 0xD018, 0xD019, 0xD01A, 0xD01B, 0xD01C, 	// 0x8334F939
	0xD01D, 0xD01E, 0xD01F, 0xD020, 0xD021, 0xD022, 0xD023, 0xD024, 0xD025, 0xD026, 	// 0x8334FA39
	0xD027, 0xD028, 0xD029, 0xD02A, 0xD02B, 0xD02C, 0xD02D, 0xD02E, 0xD02F, 0xD030, 	// 0x8334FB39
	0xD031, 0xD032, 0xD033, 0xD034, 0xD035, 0xD036, 0xD037, 0xD038, 0xD039, 0xD03A, 	// 0x8334FC39
	0xD03B, 0xD03C, 0xD03D, 0xD03E, 0xD03F, 0xD040, 0xD041, 0xD042, 0xD043, 0xD044, 	// 0x8334FD39
	0xD045, 0xD046, 0xD047, 0xD048, 0xD049, 0xD04A, 0xD04B, 0xD04C, 0xD04D, 0xD04E, 	// 0x8334FE39
	0xD04F, 0xD050, 0xD051, 0xD052, 0xD053, 0xD054, 0xD055, 0xD056, 0xD057, 0xD058, 	// 0x83358139
	0xD059, 0xD05A, 0xD05B, 0xD05C, 0xD05D, 0xD05E, 0xD05F, 0xD060, 0xD061, 0xD062, 	// 0x83358239
	0xD063, 0xD064, 0xD065, 0xD066, 0xD067, 0xD068, 0xD069, 0xD06A, 0xD06B, 0xD06C, 	// 0x83358339
	0xD06D, 0xD06E, 0xD06F, 0xD070, 0xD071, 0xD072, 0xD073, 0xD074, 0xD075, 0xD076, 	// 0x83358439
	0xD077, 0xD078, 0xD079, 0xD07A, 0xD07B, 0xD07C, 0xD07D, 0xD07E, 0xD07F, 0xD080, 	// 0x83358539
	0xD081, 0xD082, 0xD083, 0xD084, 0xD085, 0xD086, 0xD087, 0xD088, 0xD089, 0xD08A, 	// 0x83358639
	0xD08B, 0xD08C, 0xD08D, 0xD08E, 0xD08F, 0xD090, 0xD091, 0xD092, 0xD093, 0xD094, 	// 0x83358739
	0xD095, 0xD096, 0xD097, 0xD098, 0xD099, 0xD09A, 0xD09B, 0xD09C, 0xD09D, 0xD09E, 	// 0x83358839
	0xD09F, 0xD0A0, 0xD0A1, 0xD0A2, 0xD0A3, 0xD0A4, 0xD0A5, 0xD0A6, 0xD0A7, 0xD0A8, 	// 0x83358939
	0xD0A9, 0xD0AA, 0xD0AB, 0xD0AC, 0xD0AD, 0xD0AE, 0xD0AF, 0xD0B0, 0xD0B1, 0xD0B2, 	// 0x83358A39
	0xD0B3, 0xD0B4, 0xD0B5, 0xD0B6, 0xD0B7, 0xD0B8, 0xD0B9, 0xD0BA, 0xD0BB, 0xD0BC, 	// 0x83358B39
	0xD0BD, 0xD0BE, 0xD0BF, 0xD0C0, 0xD0C1, 0xD0C2, 0xD0C3, 0xD0C4, 0xD0C5, 0xD0C6, 	// 0x83358C39
	0xD0C7, 0xD0C8, 0xD0C9, 0xD0CA, 0xD0CB, 0xD0CC, 0xD0CD, 0xD0CE, 0xD0CF, 0xD0D0, 	// 0x83358D39
	0xD0D1, 0xD0D2, 0xD0D3, 0xD0D4, 0xD0D5, 0xD0D6, 0xD0D7, 0xD0D8, 0xD0D9, 0xD0DA, 	// 0x83358E39
	0xD0DB, 0xD0DC, 0xD0DD, 0xD0DE, 0xD0DF, 0xD0E0, 0xD0E1, 0xD0E2, 0xD0E3, 0xD0E4, 	// 0x83358F39
	0xD0E5, 0xD0E6, 0xD0E7, 0xD0E8, 0xD0E9, 0xD0EA, 0xD0EB, 0xD0EC, 0xD0ED, 0xD0EE, 	// 0x83359039
	0xD0EF, 0xD0F0, 0xD0F1, 0xD0F2, 0xD0F3, 0xD0F4, 0xD0F5, 0xD0F6, 0xD0F7, 0xD0F8, 	// 0x83359139
	0xD0F9, 0xD0FA, 0xD0FB, 0xD0FC, 0xD0FD, 0xD0FE, 0xD0FF, 0xD100, 0xD101, 0xD102, 	// 0x83359239
	0xD103, 0xD104, 0xD105, 0xD106, 0xD107, 0xD108, 0xD109, 0xD10A, 0xD10B, 0xD10C, 	// 0x83359339
	0xD10D, 0xD10E, 0xD10F, 0xD110, 0xD111, 0xD112, 0xD113, 0xD114, 0xD115, 0xD116, 	// 0x83359439
	0xD117, 0xD118, 0xD119, 0xD11A, 0xD11B, 0xD11C, 0xD11D, 0xD11E, 0xD11F, 0xD120, 	// 0x83359539
	0xD121, 0xD122, 0xD123, 0xD124, 0xD125, 0xD126, 0xD127, 0xD128, 0xD129, 0xD12A, 	// 0x83359639
	0xD12B, 0xD12C, 0xD12D, 0xD12E, 0xD12F, 0xD130, 0xD131, 0xD132, 0xD133, 0xD134, 	// 0x83359739
	0xD135, 0xD136, 0xD137, 0xD138, 0xD139, 0xD13A, 0xD13B, 0xD13C, 0xD13D, 0xD13E, 	// 0x83359839
	0xD13F, 0xD140, 0xD141, 0xD142, 0xD143, 0xD144, 0xD145, 0xD146, 0xD147, 0xD148, 	// 0x83359939
	0xD149, 0xD14A, 0xD14B, 0xD14C, 0xD14D, 0xD14E, 0xD14F, 0xD150, 0xD151, 0xD152, 	// 0x83359A39
	0xD153, 0xD154, 0xD155, 0xD156, 0xD157, 0xD158, 0xD159, 0xD15A, 0xD15B, 0xD15C, 	// 0x83359B39
	0xD15D, 0xD15E, 0xD15F, 0xD160, 0xD161, 0xD162, 0xD163, 0xD164, 0xD165, 0xD166, 	// 0x83359C39
	0xD167, 0xD168, 0xD169, 0xD16A, 0xD16B, 0xD16C, 0xD16D, 0xD16E, 0xD16F, 0xD170, 	// 0x83359D39
	0xD171, 0xD172, 0xD173, 0xD174, 0xD175, 0xD176, 0xD177, 0xD178, 0xD179, 0xD17A, 	// 0x83359E39
	0xD17B, 0xD17C, 0xD17D, 0xD17E, 0xD17F, 0xD180, 0xD181, 0xD182, 0xD183, 0xD184, 	// 0x83359F39
	0xD185, 0xD186, 0xD187, 0xD188, 0xD189, 0xD18A, 0xD18B, 0xD18C, 0xD18D, 0xD18E, 	// 0x8335A039
	0xD18F, 0xD190, 0xD191, 0xD192, 0xD193, 0xD194, 0xD195, 0xD196, 0xD197, 0xD198, 	// 0x8335A139
	0xD199, 0xD19A, 0xD19B, 0xD19C, 0xD19D, 0xD19E, 0xD19F, 0xD1A0, 0xD1A1, 0xD1A2, 	// 0x8335A239
	0xD1A3, 0xD1A4, 0xD1A5, 0xD1A6, 0xD1A7, 0xD1A8, 0xD1A9, 0xD1AA, 0xD1AB, 0xD1AC, 	// 0x8335A339
	0xD1AD, 0xD1AE, 0xD1AF, 0xD1B0, 0xD1B1, 0xD1B2, 0xD1B3, 0xD1B4, 0xD1B5, 0xD1B6, 	// 0x8335A439
	0xD1B7, 0xD1B8, 0xD1B9, 0xD1BA, 0xD1BB, 0xD1BC, 0xD1BD, 0xD1BE, 0xD1BF, 0xD1C0, 	// 0x8335A539
	0xD1C1, 0xD1C2, 0xD1C3, 0xD1C4, 0xD1C5, 0xD1C6, 0xD1C7, 0xD1C8, 0xD1C9, 0xD1CA, 	// 0x8335A639
	0xD1CB, 0xD1CC, 0xD1CD, 0xD1CE, 0xD1CF, 0xD1D0, 0xD1D1, 0xD1D2, 0xD1D3, 0xD1D4, 	// 0x8335A739
	0xD1D5, 0xD1D6, 0xD1D7, 0xD1D8, 0xD1D9, 0xD1DA, 0xD1DB, 0xD1DC, 0xD1DD, 0xD1DE, 	// 0x8335A839
	0xD1DF, 0xD1E0, 0xD1E1, 0xD1E2, 0xD1E3, 0xD1E4, 0xD1E5, 0xD1E6, 0xD1E7, 0xD1E8, 	// 0x8335A939
	0xD1E9, 0xD1EA, 0xD1EB, 0xD1EC, 0xD1ED, 0xD1EE, 0xD1EF, 0xD1F0, 0xD1F1, 0xD1F2, 	// 0x8335AA39
	0xD1F3, 0xD1F4, 0xD1F5, 0xD1F6, 0xD1F7, 0xD1F8, 0xD1F9, 0xD1FA, 0xD1FB, 0xD1FC, 	// 0x8335AB39
	0xD1FD, 0xD1FE, 0xD1FF, 0xD200, 0xD201, 0xD202, 0xD203, 0xD204, 0xD205, 0xD206, 	// 0x8335AC39
	0xD207, 0xD208, 0xD209, 0xD20A, 0xD20B, 0xD20C, 0xD20D, 0xD20E, 0xD20F, 0xD210, 	// 0x8335AD39
	0xD211, 0xD212, 0xD213, 0xD214, 0xD215, 0xD216, 0xD217, 0xD218, 0xD219, 0xD21A, 	// 0x8335AE39
	0xD21B, 0xD21C, 0xD21D, 0xD21E, 0xD21F, 0xD220, 0xD221, 0xD222, 0xD223, 0xD224, 	// 0x8335AF39
	0xD225, 0xD226, 0xD227, 0xD228, 0xD229, 0xD22A, 0xD22B, 0xD22C, 0xD22D, 0xD22E, 	// 0x8335B039
	0xD22F, 0xD230, 0xD231, 0xD232, 0xD233, 0xD234, 0xD235, 0xD236, 0xD237, 0xD238, 	// 0x8335B139
	0xD239, 0xD23A, 0xD23B, 0xD23C, 0xD23D, 0xD23E, 0xD23F, 0xD240, 0xD241, 0xD242, 	// 0x8335B239
	0xD243, 0xD244, 0xD245, 0xD246, 0xD247, 0xD248, 0xD249, 0xD24A, 0xD24B, 0xD24C, 	// 0x8335B339
	0xD24D, 0xD24E, 0xD24F, 0xD250, 0xD251, 0xD252, 0xD253, 0xD254, 0xD255, 0xD256, 	// 0x8335B439
	0xD257, 0xD258, 0xD259, 0xD25A, 0xD25B, 0xD25C, 0xD25D, 0xD25E, 0xD25F, 0xD260, 	// 0x8335B539
	0xD261, 0xD262, 0xD263, 0xD264, 0xD265, 0xD266, 0xD267, 0xD268, 0xD269, 0xD26A, 	// 0x8335B639
	0xD26B, 0xD26C, 0xD26D, 0xD26E, 0xD26F, 0xD270, 0xD271, 0xD272, 0xD273, 0xD274, 	// 0x8335B739
	0xD275, 0xD276, 0xD277, 0xD278, 0xD279, 0xD27A, 0xD27B, 0xD27C, 0xD27D, 0xD27E, 	// 0x8335B839
	0xD27F, 0xD280, 0xD281, 0xD282, 0xD283, 0xD284, 0xD285, 0xD286, 0xD287, 0xD288, 	// 0x8335B939
	0xD289, 0xD28A, 0xD28B, 0xD28C, 0xD28D, 0xD28E, 0xD28F, 0xD290, 0xD291, 0xD292, 	// 0x8335BA39
	0xD293, 0xD294, 0xD295, 0xD296, 0xD297, 0xD298, 0xD299, 0xD29A, 0xD29B, 0xD29C, 	// 0x8335BB39
	0xD29D, 0xD29E, 0xD29F, 0xD2A0, 0xD2A1, 0xD2A2, 0xD2A3, 0xD2A4, 0xD2A5, 0xD2A6, 	// 0x8335BC39
	0xD2A7, 0xD2A8, 0xD2A9, 0xD2AA, 0xD2AB, 0xD2AC, 0xD2AD, 0xD2AE, 0xD2AF, 0xD2B0, 	// 0x8335BD39
	0xD2B1, 0xD2B2, 0xD2B3, 0xD2B4, 0xD2B5, 0xD2B6, 0xD2B7, 0xD2B8, 0xD2B9, 0xD2BA, 	// 0x8335BE39
	0xD2BB, 0xD2BC, 0xD2BD, 0xD2BE, 0xD2BF, 0xD2C0, 0xD2C1, 0xD2C2, 0xD2C3, 0xD2C4, 	// 0x8335BF39
	0xD2C5, 0xD2C6, 0xD2C7, 0xD2C8, 0xD2C9, 0xD2CA, 0xD2CB, 0xD2CC, 0xD2CD, 0xD2CE, 	// 0x8335C039
	0xD2CF, 0xD2D0, 0xD2D1, 0xD2D2, 0xD2D3, 0xD2D4, 0xD2D5, 0xD2D6, 0xD2D7, 0xD2D8, 	// 0x8335C139
	0xD2D9, 0xD2DA, 0xD2DB, 0xD2DC, 0xD2DD, 0xD2DE, 0xD2DF, 0xD2E0, 0xD2E1, 0xD2E2, 	// 0x8335C239
	0xD2E3, 0xD2E4, 0xD2E5, 0xD2E6, 0xD2E7, 0xD2E8, 0xD2E9, 0xD2EA, 0xD2EB, 0xD2EC, 	// 0x8335C339
	0xD2ED, 0xD2EE, 0xD2EF, 0xD2F0, 0xD2F1, 0xD2F2, 0xD2F3, 0xD2F4, 0xD2F5, 0xD2F6, 	// 0x8335C439
	0xD2F7, 0xD2F8, 0xD2F9, 0xD2FA, 0xD2FB, 0xD2FC, 0xD2FD, 0xD2FE, 0xD2FF, 0xD300, 	// 0x8335C539
	0xD301, 0xD302, 0xD303, 0xD304, 0xD305, 0xD306, 0xD307, 0xD308, 0xD309, 0xD30A, 	// 0x8335C639
	0xD30B, 0xD30C, 0xD30D, 0xD30E, 0xD30F, 0xD310, 0xD311, 0xD312, 0xD313, 0xD314, 	// 0x8335C739
	0xD315, 0xD316, 0xD317, 0xD318, 0xD319, 0xD31A, 0xD31B, 0xD31C, 0xD31D, 0xD31E, 	// 0x8335C839
	0xD31F, 0xD320, 0xD321, 0xD322, 0xD323, 0xD324, 0xD325, 0xD326, 0xD327, 0xD328, 	// 0x8335C939
	0xD329, 0xD32A, 0xD32B, 0xD32C, 0xD32D, 0xD32E, 0xD32F, 0xD330, 0xD331, 0xD332, 	// 0x8335CA39
	0xD333, 0xD334, 0xD335, 0xD336, 0xD337, 0xD338, 0xD339, 0xD33A, 0xD33B, 0xD33C, 	// 0x8335CB39
	0xD33D, 0xD33E, 0xD33F, 0xD340, 0xD341, 0xD342, 0xD343, 0xD344, 0xD345, 0xD346, 	// 0x8335CC39
	0xD347, 0xD348, 0xD349, 0xD34A, 0xD34B, 0xD34C, 0xD34D, 0xD34E, 0xD34F, 0xD350, 	// 0x8335CD39
	0xD351, 0xD352, 0xD353, 0xD354, 0xD355, 0xD356, 0xD357, 0xD358, 0xD359, 0xD35A, 	// 0x8335CE39
	0xD35B, 0xD35C, 0xD35D, 0xD35E, 0xD35F, 0xD360, 0xD361, 0xD362, 0xD363, 0xD364, 	// 0x8335CF39
	0xD365, 0xD366, 0xD367, 0xD368, 0xD369, 0xD36A, 0xD36B, 0xD36C, 0xD36D, 0xD36E, 	// 0x8335D039
	0xD36F, 0xD370, 0xD371, 0xD372, 0xD373, 0xD374, 0xD375, 0xD376, 0xD377, 0xD378, 	// 0x8335D139
	0xD379, 0xD37A, 0xD37B, 0xD37C, 0xD37D, 0xD37E, 0xD37F, 0xD380, 0xD381, 0xD382, 	// 0x8335D239
	0xD383, 0xD384, 0xD385, 0xD386, 0xD387, 0xD388, 0xD389, 0xD38A, 0xD38B, 0xD38C, 	// 0x8335D339
	0xD38D, 0xD38E, 0xD38F, 0xD390, 0xD391, 0xD392, 0xD393, 0xD394, 0xD395, 0xD396, 	// 0x8335D439
	0xD397, 0xD398, 0xD399, 0xD39A, 0xD39B, 0xD39C, 0xD39D, 0xD39E, 0xD39F, 0xD3A0, 	// 0x8335D539
	0xD3A1, 0xD3A2, 0xD3A3, 0xD3A4, 0xD3A5, 0xD3A6, 0xD3A7, 0xD3A8, 0xD3A9, 0xD3AA, 	// 0x8335D639
	0xD3AB, 0xD3AC, 0xD3AD, 0xD3AE, 0xD3AF, 0xD3B0, 0xD3B1, 0xD3B2, 0xD3B3, 0xD3B4, 	// 0x8335D739
	0xD3B5, 0xD3B6, 0xD3B7, 0xD3B8, 0xD3B9, 0xD3BA, 0xD3BB, 0xD3BC, 0xD3BD, 0xD3BE, 	// 0x8335D839
	0xD3BF, 0xD3C0, 0xD3C1, 0xD3C2, 0xD3C3, 0xD3C4, 0xD3C5, 0xD3C6, 0xD3C7, 0xD3C8, 	// 0x8335D939
	0xD3C9, 0xD3CA, 0xD3CB, 0xD3CC, 0xD3CD, 0xD3CE, 0xD3CF, 0xD3D0, 0xD3D1, 0xD3D2, 	// 0x8335DA39
	0xD3D3, 0xD3D4, 0xD3D5, 0xD3D6, 0xD3D7, 0xD3D8, 0xD3D9, 0xD3DA, 0xD3DB, 0xD3DC, 	// 0x8335DB39
	0xD3DD, 0xD3DE, 0xD3DF, 0xD3E0, 0xD3E1, 0xD3E2, 0xD3E3, 0xD3E4, 0xD3E5, 0xD3E6, 	// 0x8335DC39
	0xD3E7, 0xD3E8, 0xD3E9, 0xD3EA, 0xD3EB, 0xD3EC, 0xD3ED, 0xD3EE, 0xD3EF, 0xD3F0, 	// 0x8335DD39
	0xD3F1, 0xD3F2, 0xD3F3, 0xD3F4, 0xD3F5, 0xD3F6, 0xD3F7, 0xD3F8, 0xD3F9, 0xD3FA, 	// 0x8335DE39
	0xD3FB, 0xD3FC, 0xD3FD, 0xD3FE, 0xD3FF, 0xD400, 0xD401, 0xD402, 0xD403, 0xD404, 	// 0x8335DF39
	0xD405, 0xD406, 0xD407, 0xD408, 0xD409, 0xD40A, 0xD40B, 0xD40C, 0xD40D, 0xD40E, 	// 0x8335E039
	0xD40F, 0xD410, 0xD411, 0xD412, 0xD413, 0xD414, 0xD415, 0xD416, 0xD417, 0xD418, 	// 0x8335E139
	0xD419, 0xD41A, 0xD41B, 0xD41C, 0xD41D, 0xD41E, 0xD41F, 0xD420, 0xD421, 0xD422, 	// 0x8335E239
	0xD423, 0xD424, 0xD425, 0xD426, 0xD427, 0xD428, 0xD429, 0xD42A, 0xD42B, 0xD42C, 	// 0x8335E339
	0xD42D, 0xD42E, 0xD42F, 0xD430, 0xD431, 0xD432, 0xD433, 0xD434, 0xD435, 0xD436, 	// 0x8335E439
	0xD437, 0xD438, 0xD439, 0xD43A, 0xD43B, 0xD43C, 0xD43D, 0xD43E, 0xD43F, 0xD440, 	// 0x8335E539
	0xD441, 0xD442, 0xD443, 0xD444, 0xD445, 0xD446, 0xD447, 0xD448, 0xD449, 0xD44A, 	// 0x8335E639
	0xD44B, 0xD44C, 0xD44D, 0xD44E, 0xD44F, 0xD450, 0xD451, 0xD452, 0xD453, 0xD454, 	// 0x8335E739
	0xD455, 0xD456, 0xD457, 0xD458, 0xD459, 0xD45A, 0xD45B, 0xD45C, 0xD45D, 0xD45E, 	// 0x8335E839
	0xD45F, 0xD460, 0xD461, 0xD462, 0xD463, 0xD464, 0xD465, 0xD466, 0xD467, 0xD468, 	// 0x8335E939
	0xD469, 0xD46A, 0xD46B, 0xD46C, 0xD46D, 0xD46E, 0xD46F, 0xD470, 0xD471, 0xD472, 	// 0x8335EA39
	0xD473, 0xD474, 0xD475, 0xD476, 0xD477, 0xD478, 0xD479, 0xD47A, 0xD47B, 0xD47C, 	// 0x8335EB39
	0xD47D, 0xD47E, 0xD47F, 0xD480, 0xD481, 0xD482, 0xD483, 0xD484, 0xD485, 0xD486, 	// 0x8335EC39
	0xD487, 0xD488, 0xD489, 0xD48A, 0xD48B, 0xD48C, 0xD48D, 0xD48E, 0xD48F, 0xD490, 	// 0x8335ED39
	0xD491, 0xD492, 0xD493, 0xD494, 0xD495, 0xD496, 0xD497, 0xD498, 0xD499, 0xD49A, 	// 0x8335EE39
	0xD49B, 0xD49C, 0xD49D, 0xD49E, 0xD49F, 0xD4A0, 0xD4A1, 0xD4A2, 0xD4A3, 0xD4A4, 	// 0x8335EF39
	0xD4A5, 0xD4A6, 0xD4A7, 0xD4A8, 0xD4A9, 0xD4AA, 0xD4AB, 0xD4AC, 0xD4AD, 0xD4AE, 	// 0x8335F039
	0xD4AF, 0xD4B0, 0xD4B1, 0xD4B2, 0xD4B3, 0xD4B4, 0xD4B5, 0xD4B6, 0xD4B7, 0xD4B8, 	// 0x8335F139
	0xD4B9, 0xD4BA, 0xD4BB, 0xD4BC, 0xD4BD, 0xD4BE, 0xD4BF, 0xD4C0, 0xD4C1, 0xD4C2, 	// 0x8335F239
	0xD4C3, 0xD4C4, 0xD4C5, 0xD4C6, 0xD4C7, 0xD4C8, 0xD4C9, 0xD4CA, 0xD4CB, 0xD4CC, 	// 0x8335F339
	0xD4CD, 0xD4CE, 0xD4CF, 0xD4D0, 0xD4D1, 0xD4D2, 0xD4D3, 0xD4D4, 0xD4D5, 0xD4D6, 	// 0x8335F439
	0xD4D7, 0xD4D8, 0xD4D9, 0xD4DA, 0xD4DB, 0xD4DC, 0xD4DD, 0xD4DE, 0xD4DF, 0xD4E0, 	// 0x8335F539
	0xD4E1, 0xD4E2, 0xD4E3, 0xD4E4, 0xD4E5, 0xD4E6, 0xD4E7, 0xD4E8, 0xD4E9, 0xD4EA, 	// 0x8335F639
	0xD4EB, 0xD4EC, 0xD4ED, 0xD4EE, 0xD4EF, 0xD4F0, 0xD4F1, 0xD4F2, 0xD4F3, 0xD4F4, 	// 0x8335F739
	0xD4F5, 0xD4F6, 0xD4F7, 0xD4F8, 0xD4F9, 0xD4FA, 0xD4FB, 0xD4FC, 0xD4FD, 0xD4FE, 	// 0x8335F839
	0xD4FF, 0xD500, 0xD501, 0xD502, 0xD503, 0xD504, 0xD505, 0xD506, 0xD507, 0xD508, 	// 0x8335F939
	0xD509, 0xD50A, 0xD50B, 0xD50C, 0xD50D, 0xD50E, 0xD50F, 0xD510, 0xD511, 0xD512, 	// 0x8335FA39
	0xD513, 0xD514, 0xD515, 0xD516, 0xD517, 0xD518, 0xD519, 0xD51A, 0xD51B, 0xD51C, 	// 0x8335FB39
	0xD51D, 0xD51E, 0xD51F, 0xD520, 0xD521, 0xD522, 0xD523, 0xD524, 0xD525, 0xD526, 	// 0x8335FC39
	0xD527, 0xD528, 0xD529, 0xD52A, 0xD52B, 0xD52C, 0xD52D, 0xD52E, 0xD52F, 0xD530, 	// 0x8335FD39
	0xD531, 0xD532, 0xD533, 0xD534, 0xD535, 0xD536, 0xD537, 0xD538, 0xD539, 0xD53A, 	// 0x8335FE39
	0xD53B, 0xD53C, 0xD53D, 0xD53E, 0xD53F, 0xD540, 0xD541, 0xD542, 0xD543, 0xD544, 	// 0x83368139
	0xD545, 0xD546, 0xD547, 0xD548, 0xD549, 0xD54A, 0xD54B, 0xD54C, 0xD54D, 0xD54E, 	// 0x83368239
	0xD54F, 0xD550, 0xD551, 0xD552, 0xD553, 0xD554, 0xD555, 0xD556, 0xD557, 0xD558, 	// 0x83368339
	0xD559, 0xD55A, 0xD55B, 0xD55C, 0xD55D, 0xD55E, 0xD55F, 0xD560, 0xD561, 0xD562, 	// 0x83368439
	0xD563, 0xD564, 0xD565, 0xD566, 0xD567, 0xD568, 0xD569, 0xD56A, 0xD56B, 0xD56C, 	// 0x83368539
	0xD56D, 0xD56E, 0xD56F, 0xD570, 0xD571, 0xD572, 0xD573, 0xD574, 0xD575, 0xD576, 	// 0x83368639
	0xD577, 0xD578, 0xD579, 0xD57A, 0xD57B, 0xD57C, 0xD57D, 0xD57E, 0xD57F, 0xD580, 	// 0x83368739
	0xD581, 0xD582, 0xD583, 0xD584, 0xD585, 0xD586, 0xD587, 0xD588, 0xD589, 0xD58A, 	// 0x83368839
	0xD58B, 0xD58C, 0xD58D, 0xD58E, 0xD58F, 0xD590, 0xD591, 0xD592, 0xD593, 0xD594, 	// 0x83368939
	0xD595, 0xD596, 0xD597, 0xD598, 0xD599, 0xD59A, 0xD59B, 0xD59C, 0xD59D, 0xD59E, 	// 0x83368A39
	0xD59F, 0xD5A0, 0xD5A1, 0xD5A2, 0xD5A3, 0xD5A4, 0xD5A5, 0xD5A6, 0xD5A7, 0xD5A8, 	// 0x83368B39
	0xD5A9, 0xD5AA, 0xD5AB, 0xD5AC, 0xD5AD, 0xD5AE, 0xD5AF, 0xD5B0, 0xD5B1, 0xD5B2, 	// 0x83368C39
	0xD5B3, 0xD5B4, 0xD5B5, 0xD5B6, 0xD5B7, 0xD5B8, 0xD5B9, 0xD5BA, 0xD5BB, 0xD5BC, 	// 0x83368D39
	0xD5BD, 0xD5BE, 0xD5BF, 0xD5C0, 0xD5C1, 0xD5C2, 0xD5C3, 0xD5C4, 0xD5C5, 0xD5C6, 	// 0x83368E39
	0xD5C7, 0xD5C8, 0xD5C9, 0xD5CA, 0xD5CB, 0xD5CC, 0xD5CD, 0xD5CE, 0xD5CF, 0xD5D0, 	// 0x83368F39
	0xD5D1, 0xD5D2, 0xD5D3, 0xD5D4, 0xD5D5, 0xD5D6, 0xD5D7, 0xD5D8, 0xD5D9, 0xD5DA, 	// 0x83369039
	0xD5DB, 0xD5DC, 0xD5DD, 0xD5DE, 0xD5DF, 0xD5E0, 0xD5E1, 0xD5E2, 0xD5E3, 0xD5E4, 	// 0x83369139
	0xD5E5, 0xD5E6, 0xD5E7, 0xD5E8, 0xD5E9, 0xD5EA, 0xD5EB, 0xD5EC, 0xD5ED, 0xD5EE, 	// 0x83369239
	0xD5EF, 0xD5F0, 0xD5F1, 0xD5F2, 0xD5F3, 0xD5F4, 0xD5F5, 0xD5F6, 0xD5F7, 0xD5F8, 	// 0x83369339
	0xD5F9, 0xD5FA, 0xD5FB, 0xD5FC, 0xD5FD, 0xD5FE, 0xD5FF, 0xD600, 0xD601, 0xD602, 	// 0x83369439
	0xD603, 0xD604, 0xD605, 0xD606, 0xD607, 0xD608, 0xD609, 0xD60A, 0xD60B, 0xD60C, 	// 0x83369539
	0xD60D, 0xD60E, 0xD60F, 0xD610, 0xD611, 0xD612, 0xD613, 0xD614, 0xD615, 0xD616, 	// 0x83369639
	0xD617, 0xD618, 0xD619, 0xD61A, 0xD61B, 0xD61C, 0xD61D, 0xD61E, 0xD61F, 0xD620, 	// 0x83369739
	0xD621, 0xD622, 0xD623, 0xD624, 0xD625, 0xD626, 0xD627, 0xD628, 0xD629, 0xD62A, 	// 0x83369839
	0xD62B, 0xD62C, 0xD62D, 0xD62E, 0xD62F, 0xD630, 0xD631, 0xD632, 0xD633, 0xD634, 	// 0x83369939
	0xD635, 0xD636, 0xD637, 0xD638, 0xD639, 0xD63A, 0xD63B, 0xD63C, 0xD63D, 0xD63E, 	// 0x83369A39
	0xD63F, 0xD640, 0xD641, 0xD642, 0xD643, 0xD644, 0xD645, 0xD646, 0xD647, 0xD648, 	// 0x83369B39
	0xD649, 0xD64A, 0xD64B, 0xD64C, 0xD64D, 0xD64E, 0xD64F, 0xD650, 0xD651, 0xD652, 	// 0x83369C39
	0xD653, 0xD654, 0xD655, 0xD656, 0xD657, 0xD658, 0xD659, 0xD65A, 0xD65B, 0xD65C, 	// 0x83369D39
	0xD65D, 0xD65E, 0xD65F, 0xD660, 0xD661, 0xD662, 0xD663, 0xD664, 0xD665, 0xD666, 	// 0x83369E39
	0xD667, 0xD668, 0xD669, 0xD66A, 0xD66B, 0xD66C, 0xD66D, 0xD66E, 0xD66F, 0xD670, 	// 0x83369F39
	0xD671, 0xD672, 0xD673, 0xD674, 0xD675, 0xD676, 0xD677, 0xD678, 0xD679, 0xD67A, 	// 0x8336A039
	0xD67B, 0xD67C, 0xD67D, 0xD67E, 0xD67F, 0xD680, 0xD681, 0xD682, 0xD683, 0xD684, 	// 0x8336A139
	0xD685, 0xD686, 0xD687, 0xD688, 0xD689, 0xD68A, 0xD68B, 0xD68C, 0xD68D, 0xD68E, 	// 0x8336A239
	0xD68F, 0xD690, 0xD691, 0xD692, 0xD693, 0xD694, 0xD695, 0xD696, 0xD697, 0xD698, 	// 0x8336A339
	0xD699, 0xD69A, 0xD69B, 0xD69C, 0xD69D, 0xD69E, 0xD69F, 0xD6A0, 0xD6A1, 0xD6A2, 	// 0x8336A439
	0xD6A3, 0xD6A4, 0xD6A5, 0xD6A6, 0xD6A7, 0xD6A8, 0xD6A9, 0xD6AA, 0xD6AB, 0xD6AC, 	// 0x8336A539
	0xD6AD, 0xD6AE, 0xD6AF, 0xD6B0, 0xD6B1, 0xD6B2, 0xD6B3, 0xD6B4, 0xD6B5, 0xD6B6, 	// 0x8336A639
	0xD6B7, 0xD6B8, 0xD6B9, 0xD6BA, 0xD6BB, 0xD6BC, 0xD6BD, 0xD6BE, 0xD6BF, 0xD6C0, 	// 0x8336A739
	0xD6C1, 0xD6C2, 0xD6C3, 0xD6C4, 0xD6C5, 0xD6C6, 0xD6C7, 0xD6C8, 0xD6C9, 0xD6CA, 	// 0x8336A839
	0xD6CB, 0xD6CC, 0xD6CD, 0xD6CE, 0xD6CF, 0xD6D0, 0xD6D1, 0xD6D2, 0xD6D3, 0xD6D4, 	// 0x8336A939
	0xD6D5, 0xD6D6, 0xD6D7, 0xD6D8, 0xD6D9, 0xD6DA, 0xD6DB, 0xD6DC, 0xD6DD, 0xD6DE, 	// 0x8336AA39
	0xD6DF, 0xD6E0, 0xD6E1, 0xD6E2, 0xD6E3, 0xD6E4, 0xD6E5, 0xD6E6, 0xD6E7, 0xD6E8, 	// 0x8336AB39
	0xD6E9, 0xD6EA, 0xD6EB, 0xD6EC, 0xD6ED, 0xD6EE, 0xD6EF, 0xD6F0, 0xD6F1, 0xD6F2, 	// 0x8336AC39
	0xD6F3, 0xD6F4, 0xD6F5, 0xD6F6, 0xD6F7, 0xD6F8, 0xD6F9, 0xD6FA, 0xD6FB, 0xD6FC, 	// 0x8336AD39
	0xD6FD, 0xD6FE, 0xD6FF, 0xD700, 0xD701, 0xD702, 0xD703, 0xD704, 0xD705, 0xD706, 	// 0x8336AE39
	0xD707, 0xD708, 0xD709, 0xD70A, 0xD70B, 0xD70C, 0xD70D, 0xD70E, 0xD70F, 0xD710, 	// 0x8336AF39
	0xD711, 0xD712, 0xD713, 0xD714, 0xD715, 0xD716, 0xD717, 0xD718, 0xD719, 0xD71A, 	// 0x8336B039
	0xD71B, 0xD71C, 0xD71D, 0xD71E, 0xD71F, 0xD720, 0xD721, 0xD722, 0xD723, 0xD724, 	// 0x8336B139
	0xD725, 0xD726, 0xD727, 0xD728, 0xD729, 0xD72A, 0xD72B, 0xD72C, 0xD72D, 0xD72E, 	// 0x8336B239
	0xD72F, 0xD730, 0xD731, 0xD732, 0xD733, 0xD734, 0xD735, 0xD736, 0xD737, 0xD738, 	// 0x8336B339
	0xD739, 0xD73A, 0xD73B, 0xD73C, 0xD73D, 0xD73E, 0xD73F, 0xD740, 0xD741, 0xD742, 	// 0x8336B439
	0xD743, 0xD744, 0xD745, 0xD746, 0xD747, 0xD748, 0xD749, 0xD74A, 0xD74B, 0xD74C, 	// 0x8336B539
	0xD74D, 0xD74E, 0xD74F, 0xD750, 0xD751, 0xD752, 0xD753, 0xD754, 0xD755, 0xD756, 	// 0x8336B639
	0xD757, 0xD758, 0xD759, 0xD75A, 0xD75B, 0xD75C, 0xD75D, 0xD75E, 0xD75F, 0xD760, 	// 0x8336B739
	0xD761, 0xD762, 0xD763, 0xD764, 0xD765, 0xD766, 0xD767, 0xD768, 0xD769, 0xD76A, 	// 0x8336B839
	0xD76B, 0xD76C, 0xD76D, 0xD76E, 0xD76F, 0xD770, 0xD771, 0xD772, 0xD773, 0xD774, 	// 0x8336B939
	0xD775, 0xD776, 0xD777, 0xD778, 0xD779, 0xD77A, 0xD77B, 0xD77C, 0xD77D, 0xD77E, 	// 0x8336BA39
	0xD77F, 0xD780, 0xD781, 0xD782, 0xD783, 0xD784, 0xD785, 0xD786, 0xD787, 0xD788, 	// 0x8336BB39
	0xD789, 0xD78A, 0xD78B, 0xD78C, 0xD78D, 0xD78E, 0xD78F, 0xD790, 0xD791, 0xD792, 	// 0x8336BC39
	0xD793, 0xD794, 0xD795, 0xD796, 0xD797, 0xD798, 0xD799, 0xD79A, 0xD79B, 0xD79C, 	// 0x8336BD39
	0xD79D, 0xD79E, 0xD79F, 0xD7A0, 0xD7A1, 0xD7A2, 0xD7A3, 0xD7A4, 0xD7A5, 0xD7A6, 	// 0x8336BE39
	0xD7A7, 0xD7A8, 0xD7A9, 0xD7AA, 0xD7AB, 0xD7AC, 0xD7AD, 0xD7AE, 0xD7AF, 0xD7B0, 	// 0x8336BF39
	0xD7B1, 0xD7B2, 0xD7B3, 0xD7B4, 0xD7B5, 0xD7B6, 0xD7B7, 0xD7B8, 0xD7B9, 0xD7BA, 	// 0x8336C039
	0xD7BB, 0xD7BC, 0xD7BD, 0xD7BE, 0xD7BF, 0xD7C0, 0xD7C1, 0xD7C2, 0xD7C3, 0xD7C4, 	// 0x8336C139
	0xD7C5, 0xD7C6, 0xD7C7, 0xD7C8, 0xD7C9, 0xD7CA, 0xD7CB, 0xD7CC, 0xD7CD, 0xD7CE, 	// 0x8336C239
	0xD7CF, 0xD7D0, 0xD7D1, 0xD7D2, 0xD7D3, 0xD7D4, 0xD7D5, 0xD7D6, 0xD7D7, 0xD7D8, 	// 0x8336C339
	0xD7D9, 0xD7DA, 0xD7DB, 0xD7DC, 0xD7DD, 0xD7DE, 0xD7DF, 0xD7E0, 0xD7E1, 0xD7E2, 	// 0x8336C439
	0xD7E3, 0xD7E4, 0xD7E5, 0xD7E6, 0xD7E7, 0xD7E8, 0xD7E9, 0xD7EA, 0xD7EB, 0xD7EC, 	// 0x8336C539
	0xD7ED, 0xD7EE, 0xD7EF, 0xD7F0, 0xD7F1, 0xD7F2, 0xD7F3, 0xD7F4, 0xD7F5, 0xD7F6, 	// 0x8336C639
	0xD7F7, 0xD7F8, 0xD7F9, 0xD7FA, 0xD7FB, 0xD7FC, 0xD7FD, 0xD7FE, 0xD7FF, 0xE76C, 	// 0x8336C739
	0xE7C8, 0xE7E7, 0xE7E8, 0xE7E9, 0xE7EA, 0xE7EB, 0xE7EC, 0xE7ED, 0xE7EE, 0xE7EF, 	// 0x8336C839
	0xE7F0, 0xE7F1, 0xE7F2, 0xE7F3, 0xE815, 0xE819, 0xE81A, 0xE81B, 0xE81C, 0xE81D, 	// 0x8336C939
	0xE81F, 0xE820, 0xE821, 0xE822, 0xE823, 0xE824, 0xE825, 0xE827, 0xE828, 0xE829, 	// 0x8336CA39
	0xE82A, 0xE82D, 0xE82E, 0xE82F, 0xE830, 0xE833, 0xE834, 0xE835, 0xE836, 0xE837, 	// 0x8336CB39
	0xE838, 0xE839, 0xE83A, 0xE83C, 0xE83D, 0xE83E, 0xE83F, 0xE840, 0xE841, 0xE842, 	// 0x8336CC39
	0xE844, 0xE845, 0xE846, 0xE847, 0xE848, 0xE849, 0xE84A, 0xE84B, 0xE84C, 0xE84D, 	// 0x8336CD39
	0xE84E, 0xE84F, 0xE850, 0xE851, 0xE852, 0xE853, 0xE856, 0xE857, 0xE858, 0xE859, 	// 0x8336CE39
	0xE85A, 0xE85B, 0xE85C, 0xE85D, 0xE85E, 0xE85F, 0xE860, 0xE861, 0xE862, 0xE863, 	// 0x8336CF39
	0xE865, 0xE866, 0xE867, 0xE868, 0xE869, 0xE86A, 0xE86B, 0xE86C, 0xE86D, 0xE86E, 	// 0x8336D039
	0xE86F, 0xE870, 0xE871, 0xE872, 0xE873, 0xE874, 0xE875, 0xE876, 0xE877, 0xE878, 	// 0x8336D139
	0xE879, 0xE87A, 0xE87B, 0xE87C, 0xE87D, 0xE87E, 0xE87F, 0xE880, 0xE881, 0xE882, 	// 0x8336D239
	0xE883, 0xE884, 0xE885, 0xE886, 0xE887, 0xE888, 0xE889, 0xE88A, 0xE88B, 0xE88C, 	// 0x8336D339
	0xE88D, 0xE88E, 0xE88F, 0xE890, 0xE891, 0xE892, 0xE893, 0xE894, 0xE895, 0xE896, 	// 0x8336D439
	0xE897, 0xE898, 0xE899, 0xE89A, 0xE89B, 0xE89C, 0xE89D, 0xE89E, 0xE89F, 0xE8A0, 	// 0x8336D539
	0xE8A1, 0xE8A2, 0xE8A3, 0xE8A4, 0xE8A5, 0xE8A6, 0xE8A7, 0xE8A8, 0xE8A9, 0xE8AA, 	// 0x8336D639
	0xE8AB, 0xE8AC, 0xE8AD, 0xE8AE, 0xE8AF, 0xE8B0, 0xE8B1, 0xE8B2, 0xE8B3, 0xE8B4, 	// 0x8336D739
	0xE8B5, 0xE8B6, 0xE8B7, 0xE8B8, 0xE8B9, 0xE8BA, 0xE8BB, 0xE8BC, 0xE8BD, 0xE8BE, 	// 0x8336D839
	0xE8BF, 0xE8C0, 0xE8C1, 0xE8C2, 0xE8C3, 0xE8C4, 0xE8C5, 0xE8C6, 0xE8C7, 0xE8C8, 	// 0x8336D939
	0xE8C9, 0xE8CA, 0xE8CB, 0xE8CC, 0xE8CD, 0xE8CE, 0xE8CF, 0xE8D0, 0xE8D1, 0xE8D2, 	// 0x8336DA39
	0xE8D3, 0xE8D4, 0xE8D5, 0xE8D6, 0xE8D7, 0xE8D8, 0xE8D9, 0xE8DA, 0xE8DB, 0xE8DC, 	// 0x8336DB39
	0xE8DD, 0xE8DE, 0xE8DF, 0xE8E0, 0xE8E1, 0xE8E2, 0xE8E3, 0xE8E4, 0xE8E5, 0xE8E6, 	// 0x8336DC39
	0xE8E7, 0xE8E8, 0xE8E9, 0xE8EA, 0xE8EB, 0xE8EC, 0xE8ED, 0xE8EE, 0xE8EF, 0xE8F0, 	// 0x8336DD39
	0xE8F1, 0xE8F2, 0xE8F3, 0xE8F4, 0xE8F5, 0xE8F6, 0xE8F7, 0xE8F8, 0xE8F9, 0xE8FA, 	// 0x8336DE39
	0xE8FB, 0xE8FC, 0xE8FD, 0xE8FE, 0xE8FF, 0xE900, 0xE901, 0xE902, 0xE903, 0xE904, 	// 0x8336DF39
	0xE905, 0xE906, 0xE907, 0xE908, 0xE909, 0xE90A, 0xE90B, 0xE90C, 0xE90D, 0xE90E, 	// 0x8336E039
	0xE90F, 0xE910, 0xE911, 0xE912, 0xE913, 0xE914, 0xE915, 0xE916, 0xE917, 0xE918, 	// 0x8336E139
	0xE919, 0xE91A, 0xE91B, 0xE91C, 0xE91D, 0xE91E, 0xE91F, 0xE920, 0xE921, 0xE922, 	// 0x8336E239
	0xE923, 0xE924, 0xE925, 0xE926, 0xE927, 0xE928, 0xE929, 0xE92A, 0xE92B, 0xE92C, 	// 0x8336E339
	0xE92D, 0xE92E, 0xE92F, 0xE930, 0xE931, 0xE932, 0xE933, 0xE934, 0xE935, 0xE936, 	// 0x8336E439
	0xE937, 0xE938, 0xE939, 0xE93A, 0xE93B, 0xE93C, 0xE93D, 0xE93E, 0xE93F, 0xE940, 	// 0x8336E539
	0xE941, 0xE942, 0xE943, 0xE944, 0xE945, 0xE946, 0xE947, 0xE948, 0xE949, 0xE94A, 	// 0x8336E639
	0xE94B, 0xE94C, 0xE94D, 0xE94E, 0xE94F, 0xE950, 0xE951, 0xE952, 0xE953, 0xE954, 	// 0x8336E739
	0xE955, 0xE956, 0xE957, 0xE958, 0xE959, 0xE95A, 0xE95B, 0xE95C, 0xE95D, 0xE95E, 	// 0x8336E839
	0xE95F, 0xE960, 0xE961, 0xE962, 0xE963, 0xE964, 0xE965, 0xE966, 0xE967, 0xE968, 	// 0x8336E939
	0xE969, 0xE96A, 0xE96B, 0xE96C, 0xE96D, 0xE96E, 0xE96F, 0xE970, 0xE971, 0xE972, 	// 0x8336EA39
	0xE973, 0xE974, 0xE975, 0xE976, 0xE977, 0xE978, 0xE979, 0xE97A, 0xE97B, 0xE97C, 	// 0x8336EB39
	0xE97D, 0xE97E, 0xE97F, 0xE980, 0xE981, 0xE982, 0xE983, 0xE984, 0xE985, 0xE986, 	// 0x8336EC39
	0xE987, 0xE988, 0xE989, 0xE98A, 0xE98B, 0xE98C, 0xE98D, 0xE98E, 0xE98F, 0xE990, 	// 0x8336ED39
	0xE991, 0xE992, 0xE993, 0xE994, 0xE995, 0xE996, 0xE997, 0xE998, 0xE999, 0xE99A, 	// 0x8336EE39
	0xE99B, 0xE99C, 0xE99D, 0xE99E, 0xE99F, 0xE9A0, 0xE9A1, 0xE9A2, 0xE9A3, 0xE9A4, 	// 0x8336EF39
	0xE9A5, 0xE9A6, 0xE9A7, 0xE9A8, 0xE9A9, 0xE9AA, 0xE9AB, 0xE9AC, 0xE9AD, 0xE9AE, 	// 0x8336F039
	0xE9AF, 0xE9B0, 0xE9B1, 0xE9B2, 0xE9B3, 0xE9B4, 0xE9B5, 0xE9B6, 0xE9B7, 0xE9B8, 	// 0x8336F139
	0xE9B9, 0xE9BA, 0xE9BB, 0xE9BC, 0xE9BD, 0xE9BE, 0xE9BF, 0xE9C0, 0xE9C1, 0xE9C2, 	// 0x8336F239
	0xE9C3, 0xE9C4, 0xE9C5, 0xE9C6, 0xE9C7, 0xE9C8, 0xE9C9, 0xE9CA, 0xE9CB, 0xE9CC, 	// 0x8336F339
	0xE9CD, 0xE9CE, 0xE9CF, 0xE9D0, 0xE9D1, 0xE9D2, 0xE9D3, 0xE9D4, 0xE9D5, 0xE9D6, 	// 0x8336F439
	0xE9D7, 0xE9D8, 0xE9D9, 0xE9DA, 0xE9DB, 0xE9DC, 0xE9DD, 0xE9DE, 0xE9DF, 0xE9E0, 	// 0x8336F539
	0xE9E1, 0xE9E2, 0xE9E3, 0xE9E4, 0xE9E5, 0xE9E6, 0xE9E7, 0xE9E8, 0xE9E9, 0xE9EA, 	// 0x8336F639
	0xE9EB, 0xE9EC, 0xE9ED, 0xE9EE, 0xE9EF, 0xE9F0, 0xE9F1, 0xE9F2, 0xE9F3, 0xE9F4, 	// 0x8336F739
	0xE9F5, 0xE9F6, 0xE9F7, 0xE9F8, 0xE9F9, 0xE9FA, 0xE9FB, 0xE9FC, 0xE9FD, 0xE9FE, 	// 0x8336F839
	0xE9FF, 0xEA00, 0xEA01, 0xEA02, 0xEA03, 0xEA04, 0xEA05, 0xEA06, 0xEA07, 0xEA08, 	// 0x8336F939
	0xEA09, 0xEA0A, 0xEA0B, 0xEA0C, 0xEA0D, 0xEA0E, 0xEA0F, 0xEA10, 0xEA11, 0xEA12, 	// 0x8336FA39
	0xEA13, 0xEA14, 0xEA15, 0xEA16, 0xEA17, 0xEA18, 0xEA19, 0xEA1A, 0xEA1B, 0xEA1C, 	// 0x8336FB39
	0xEA1D, 0xEA1E, 0xEA1F, 0xEA20, 0xEA21, 0xEA22, 0xEA23, 0xEA24, 0xEA25, 0xEA26, 	// 0x8336FC39
	0xEA27, 0xEA28, 0xEA29, 0xEA2A, 0xEA2B, 0xEA2C, 0xEA2D, 0xEA2E, 0xEA2F, 0xEA30, 	// 0x8336FD39
	0xEA31, 0xEA32, 0xEA33, 0xEA34, 0xEA35, 0xEA36, 0xEA37, 0xEA38, 0xEA39, 0xEA3A, 	// 0x8336FE39
	0xEA3B, 0xEA3C, 0xEA3D, 0xEA3E, 0xEA3F, 0xEA40, 0xEA41, 0xEA42, 0xEA43, 0xEA44, 	// 0x83378139
	0xEA45, 0xEA46, 0xEA47, 0xEA48, 0xEA49, 0xEA4A, 0xEA4B, 0xEA4C, 0xEA4D, 0xEA4E, 	// 0x83378239
	0xEA4F, 0xEA50, 0xEA51, 0xEA52, 0xEA53, 0xEA54, 0xEA55, 0xEA56, 0xEA57, 0xEA58, 	// 0x83378339
	0xEA59, 0xEA5A, 0xEA5B, 0xEA5C, 0xEA5D, 0xEA5E, 0xEA5F, 0xEA60, 0xEA61, 0xEA62, 	// 0x83378439
	0xEA63, 0xEA64, 0xEA65, 0xEA66, 0xEA67, 0xEA68, 0xEA69, 0xEA6A, 0xEA6B, 0xEA6C, 	// 0x83378539
	0xEA6D, 0xEA6E, 0xEA6F, 0xEA70, 0xEA71, 0xEA72, 0xEA73, 0xEA74, 0xEA75, 0xEA76, 	// 0x83378639
	0xEA77, 0xEA78, 0xEA79, 0xEA7A, 0xEA7B, 0xEA7C, 0xEA7D, 0xEA7E, 0xEA7F, 0xEA80, 	// 0x83378739
	0xEA81, 0xEA82, 0xEA83, 0xEA84, 0xEA85, 0xEA86, 0xEA87, 0xEA88, 0xEA89, 0xEA8A, 	// 0x83378839
	0xEA8B, 0xEA8C, 0xEA8D, 0xEA8E, 0xEA8F, 0xEA90, 0xEA91, 0xEA92, 0xEA93, 0xEA94, 	// 0x83378939
	0xEA95, 0xEA96, 0xEA97, 0xEA98, 0xEA99, 0xEA9A, 0xEA9B, 0xEA9C, 0xEA9D, 0xEA9E, 	// 0x83378A39
	0xEA9F, 0xEAA0, 0xEAA1, 0xEAA2, 0xEAA3, 0xEAA4, 0xEAA5, 0xEAA6, 0xEAA7, 0xEAA8, 	// 0x83378B39
	0xEAA9, 0xEAAA, 0xEAAB, 0xEAAC, 0xEAAD, 0xEAAE, 0xEAAF, 0xEAB0, 0xEAB1, 0xEAB2, 	// 0x83378C39
	0xEAB3, 0xEAB4, 0xEAB5, 0xEAB6, 0xEAB7, 0xEAB8, 0xEAB9, 0xEABA, 0xEABB, 0xEABC, 	// 0x83378D39
	0xEABD, 0xEABE, 0xEABF, 0xEAC0, 0xEAC1, 0xEAC2, 0xEAC3, 0xEAC4, 0xEAC5, 0xEAC6, 	// 0x83378E39
	0xEAC7, 0xEAC8, 0xEAC9, 0xEACA, 0xEACB, 0xEACC, 0xEACD, 0xEACE, 0xEACF, 0xEAD0, 	// 0x83378F39
	0xEAD1, 0xEAD2, 0xEAD3, 0xEAD4, 0xEAD5, 0xEAD6, 0xEAD7, 0xEAD8, 0xEAD9, 0xEADA, 	// 0x83379039
	0xEADB, 0xEADC, 0xEADD, 0xEADE, 0xEADF, 0xEAE0, 0xEAE1, 0xEAE2, 0xEAE3, 0xEAE4, 	// 0x83379139
	0xEAE5, 0xEAE6, 0xEAE7, 0xEAE8, 0xEAE9, 0xEAEA, 0xEAEB, 0xEAEC, 0xEAED, 0xEAEE, 	// 0x83379239
	0xEAEF, 0xEAF0, 0xEAF1, 0xEAF2, 0xEAF3, 0xEAF4, 0xEAF5, 0xEAF6, 0xEAF7, 0xEAF8, 	// 0x83379339
	0xEAF9, 0xEAFA, 0xEAFB, 0xEAFC, 0xEAFD, 0xEAFE, 0xEAFF, 0xEB00, 0xEB01, 0xEB02, 	// 0x83379439
	0xEB03, 0xEB04, 0xEB05, 0xEB06, 0xEB07, 0xEB08, 0xEB09, 0xEB0A, 0xEB0B, 0xEB0C, 	// 0x83379539
	0xEB0D, 0xEB0E, 0xEB0F, 0xEB10, 0xEB11, 0xEB12, 0xEB13, 0xEB14, 0xEB15, 0xEB16, 	// 0x83379639
	0xEB17, 0xEB18, 0xEB19, 0xEB1A, 0xEB1B, 0xEB1C, 0xEB1D, 0xEB1E, 0xEB1F, 0xEB20, 	// 0x83379739
	0xEB21, 0xEB22, 0xEB23, 0xEB24, 0xEB25, 0xEB26, 0xEB27, 0xEB28, 0xEB29, 0xEB2A, 	// 0x83379839
	0xEB2B, 0xEB2C, 0xEB2D, 0xEB2E, 0xEB2F, 0xEB30, 0xEB31, 0xEB32, 0xEB33, 0xEB34, 	// 0x83379939
	0xEB35, 0xEB36, 0xEB37, 0xEB38, 0xEB39, 0xEB3A, 0xEB3B, 0xEB3C, 0xEB3D, 0xEB3E, 	// 0x83379A39
	0xEB3F, 0xEB40, 0xEB41, 0xEB42, 0xEB43, 0xEB44, 0xEB45, 0xEB46, 0xEB47, 0xEB48, 	// 0x83379B39
	0xEB49, 0xEB4A, 0xEB4B, 0xEB4C, 0xEB4D, 0xEB4E, 0xEB4F, 0xEB50, 0xEB51, 0xEB52, 	// 0x83379C39
	0xEB53, 0xEB54, 0xEB55, 0xEB56, 0xEB57, 0xEB58, 0xEB59, 0xEB5A, 0xEB5B, 0xEB5C, 	// 0x83379D39
	0xEB5D, 0xEB5E, 0xEB5F, 0xEB60, 0xEB61, 0xEB62, 0xEB63, 0xEB64, 0xEB65, 0xEB66, 	// 0x83379E39
	0xEB67, 0xEB68, 0xEB69, 0xEB6A, 0xEB6B, 0xEB6C, 0xEB6D, 0xEB6E, 0xEB6F, 0xEB70, 	// 0x83379F39
	0xEB71, 0xEB72, 0xEB73, 0xEB74, 0xEB75, 0xEB76, 0xEB77, 0xEB78, 0xEB79, 0xEB7A, 	// 0x8337A039
	0xEB7B, 0xEB7C, 0xEB7D, 0xEB7E, 0xEB7F, 0xEB80, 0xEB81, 0xEB82, 0xEB83, 0xEB84, 	// 0x8337A139
	0xEB85, 0xEB86, 0xEB87, 0xEB88, 0xEB89, 0xEB8A, 0xEB8B, 0xEB8C, 0xEB8D, 0xEB8E, 	// 0x8337A239
	0xEB8F, 0xEB90, 0xEB91, 0xEB92, 0xEB93, 0xEB94, 0xEB95, 0xEB96, 0xEB97, 0xEB98, 	// 0x8337A339
	0xEB99, 0xEB9A, 0xEB9B, 0xEB9C, 0xEB9D, 0xEB9E, 0xEB9F, 0xEBA0, 0xEBA1, 0xEBA2, 	// 0x8337A439
	0xEBA3, 0xEBA4, 0xEBA5, 0xEBA6, 0xEBA7, 0xEBA8, 0xEBA9, 0xEBAA, 0xEBAB, 0xEBAC, 	// 0x8337A539
	0xEBAD, 0xEBAE, 0xEBAF, 0xEBB0, 0xEBB1, 0xEBB2, 0xEBB3, 0xEBB4, 0xEBB5, 0xEBB6, 	// 0x8337A639
	0xEBB7, 0xEBB8, 0xEBB9, 0xEBBA, 0xEBBB, 0xEBBC, 0xEBBD, 0xEBBE, 0xEBBF, 0xEBC0, 	// 0x8337A739
	0xEBC1, 0xEBC2, 0xEBC3, 0xEBC4, 0xEBC5, 0xEBC6, 0xEBC7, 0xEBC8, 0xEBC9, 0xEBCA, 	// 0x8337A839
	0xEBCB, 0xEBCC, 0xEBCD, 0xEBCE, 0xEBCF, 0xEBD0, 0xEBD1, 0xEBD2, 0xEBD3, 0xEBD4, 	// 0x8337A939
	0xEBD5, 0xEBD6, 0xEBD7, 0xEBD8, 0xEBD9, 0xEBDA, 0xEBDB, 0xEBDC, 0xEBDD, 0xEBDE, 	// 0x8337AA39
	0xEBDF, 0xEBE0, 0xEBE1, 0xEBE2, 0xEBE3, 0xEBE4, 0xEBE5, 0xEBE6, 0xEBE7, 0xEBE8, 	// 0x8337AB39
	0xEBE9, 0xEBEA, 0xEBEB, 0xEBEC, 0xEBED, 0xEBEE, 0xEBEF, 0xEBF0, 0xEBF1, 0xEBF2, 	// 0x8337AC39
	0xEBF3, 0xEBF4, 0xEBF5, 0xEBF6, 0xEBF7, 0xEBF8, 0xEBF9, 0xEBFA, 0xEBFB, 0xEBFC, 	// 0x8337AD39
	0xEBFD, 0xEBFE, 0xEBFF, 0xEC00, 0xEC01, 0xEC02, 0xEC03, 0xEC04, 0xEC05, 0xEC06, 	// 0x8337AE39
	0xEC07, 0xEC08, 0xEC09, 0xEC0A, 0xEC0B, 0xEC0C, 0xEC0D, 0xEC0E, 0xEC0F, 0xEC10, 	// 0x8337AF39
	0xEC11, 0xEC12, 0xEC13, 0xEC14, 0xEC15, 0xEC16, 0xEC17, 0xEC18, 0xEC19, 0xEC1A, 	// 0x8337B039
	0xEC1B, 0xEC1C, 0xEC1D, 0xEC1E, 0xEC1F, 0xEC20, 0xEC21, 0xEC22, 0xEC23, 0xEC24, 	// 0x8337B139
	0xEC25, 0xEC26, 0xEC27, 0xEC28, 0xEC29, 0xEC2A, 0xEC2B, 0xEC2C, 0xEC2D, 0xEC2E, 	// 0x8337B239
	0xEC2F, 0xEC30, 0xEC31, 0xEC32, 0xEC33, 0xEC34, 0xEC35, 0xEC36, 0xEC37, 0xEC38, 	// 0x8337B339
	0xEC39, 0xEC3A, 0xEC3B, 0xEC3C, 0xEC3D, 0xEC3E, 0xEC3F, 0xEC40, 0xEC41, 0xEC42, 	// 0x8337B439
	0xEC43, 0xEC44, 0xEC45, 0xEC46, 0xEC47, 0xEC48, 0xEC49, 0xEC4A, 0xEC4B, 0xEC4C, 	// 0x8337B539
	0xEC4D, 0xEC4E, 0xEC4F, 0xEC50, 0xEC51, 0xEC52, 0xEC53, 0xEC54, 0xEC55, 0xEC56, 	// 0x8337B639
	0xEC57, 0xEC58, 0xEC59, 0xEC5A, 0xEC5B, 0xEC5C, 0xEC5D, 0xEC5E, 0xEC5F, 0xEC60, 	// 0x8337B739
	0xEC61, 0xEC62, 0xEC63, 0xEC64, 0xEC65, 0xEC66, 0xEC67, 0xEC68, 0xEC69, 0xEC6A, 	// 0x8337B839
	0xEC6B, 0xEC6C, 0xEC6D, 0xEC6E, 0xEC6F, 0xEC70, 0xEC71, 0xEC72, 0xEC73, 0xEC74, 	// 0x8337B939
	0xEC75, 0xEC76, 0xEC77, 0xEC78, 0xEC79, 0xEC7A, 0xEC7B, 0xEC7C, 0xEC7D, 0xEC7E, 	// 0x8337BA39
	0xEC7F, 0xEC80, 0xEC81, 0xEC82, 0xEC83, 0xEC84, 0xEC85, 0xEC86, 0xEC87, 0xEC88, 	// 0x8337BB39
	0xEC89, 0xEC8A, 0xEC8B, 0xEC8C, 0xEC8D, 0xEC8E, 0xEC8F, 0xEC90, 0xEC91, 0xEC92, 	// 0x8337BC39
	0xEC93, 0xEC94, 0xEC95, 0xEC96, 0xEC97, 0xEC98, 0xEC99, 0xEC9A, 0xEC9B, 0xEC9C, 	// 0x8337BD39
	0xEC9D, 0xEC9E, 0xEC9F, 0xECA0, 0xECA1, 0xECA2, 0xECA3, 0xECA4, 0xECA5, 0xECA6, 	// 0x8337BE39
	0xECA7, 0xECA8, 0xECA9, 0xECAA, 0xECAB, 0xECAC, 0xECAD, 0xECAE, 0xECAF, 0xECB0, 	// 0x8337BF39
	0xECB1, 0xECB2, 0xECB3, 0xECB4, 0xECB5, 0xECB6, 0xECB7, 0xECB8, 0xECB9, 0xECBA, 	// 0x8337C039
	0xECBB, 0xECBC, 0xECBD, 0xECBE, 0xECBF, 0xECC0, 0xECC1, 0xECC2, 0xECC3, 0xECC4, 	// 0x8337C139
	0xECC5, 0xECC6, 0xECC7, 0xECC8, 0xECC9, 0xECCA, 0xECCB, 0xECCC, 0xECCD, 0xECCE, 	// 0x8337C239
	0xECCF, 0xECD0, 0xECD1, 0xECD2, 0xECD3, 0xECD4, 0xECD5, 0xECD6, 0xECD7, 0xECD8, 	// 0x8337C339
	0xECD9, 0xECDA, 0xECDB, 0xECDC, 0xECDD, 0xECDE, 0xECDF, 0xECE0, 0xECE1, 0xECE2, 	// 0x8337C439
	0xECE3, 0xECE4, 0xECE5, 0xECE6, 0xECE7, 0xECE8, 0xECE9, 0xECEA, 0xECEB, 0xECEC, 	// 0x8337C539
	0xECED, 0xECEE, 0xECEF, 0xECF0, 0xECF1, 0xECF2, 0xECF3, 0xECF4, 0xECF5, 0xECF6, 	// 0x8337C639
	0xECF7, 0xECF8, 0xECF9, 0xECFA, 0xECFB, 0xECFC, 0xECFD, 0xECFE, 0xECFF, 0xED00, 	// 0x8337C739
	0xED01, 0xED02, 0xED03, 0xED04, 0xED05, 0xED06, 0xED07, 0xED08, 0xED09, 0xED0A, 	// 0x8337C839
	0xED0B, 0xED0C, 0xED0D, 0xED0E, 0xED0F, 0xED10, 0xED11, 0xED12, 0xED13, 0xED14, 	// 0x8337C939
	0xED15, 0xED16, 0xED17, 0xED18, 0xED19, 0xED1A, 0xED1B, 0xED1C, 0xED1D, 0xED1E, 	// 0x8337CA39
	0xED1F, 0xED20, 0xED21, 0xED22, 0xED23, 0xED24, 0xED25, 0xED26, 0xED27, 0xED28, 	// 0x8337CB39
	0xED29, 0xED2A, 0xED2B, 0xED2C, 0xED2D, 0xED2E, 0xED2F, 0xED30, 0xED31, 0xED32, 	// 0x8337CC39
	0xED33, 0xED34, 0xED35, 0xED36, 0xED37, 0xED38, 0xED39, 0xED3A, 0xED3B, 0xED3C, 	// 0x8337CD39
	0xED3D, 0xED3E, 0xED3F, 0xED40, 0xED41, 0xED42, 0xED43, 0xED44, 0xED45, 0xED46, 	// 0x8337CE39
	0xED47, 0xED48, 0xED49, 0xED4A, 0xED4B, 0xED4C, 0xED4D, 0xED4E, 0xED4F, 0xED50, 	// 0x8337CF39
	0xED51, 0xED52, 0xED53, 0xED54, 0xED55, 0xED56, 0xED57, 0xED58, 0xED59, 0xED5A, 	// 0x8337D039
	0xED5B, 0xED5C, 0xED5D, 0xED5E, 0xED5F, 0xED60, 0xED61, 0xED62, 0xED63, 0xED64, 	// 0x8337D139
	0xED65, 0xED66, 0xED67, 0xED68, 0xED69, 0xED6A, 0xED6B, 0xED6C, 0xED6D, 0xED6E, 	// 0x8337D239
	0xED6F, 0xED70, 0xED71, 0xED72, 0xED73, 0xED74, 0xED75, 0xED76, 0xED77, 0xED78, 	// 0x8337D339
	0xED79, 0xED7A, 0xED7B, 0xED7C, 0xED7D, 0xED7E, 0xED7F, 0xED80, 0xED81, 0xED82, 	// 0x8337D439
	0xED83, 0xED84, 0xED85, 0xED86, 0xED87, 0xED88, 0xED89, 0xED8A, 0xED8B, 0xED8C, 	// 0x8337D539
	0xED8D, 0xED8E, 0xED8F, 0xED90, 0xED91, 0xED92, 0xED93, 0xED94, 0xED95, 0xED96, 	// 0x8337D639
	0xED97, 0xED98, 0xED99, 0xED9A, 0xED9B, 0xED9C, 0xED9D, 0xED9E, 0xED9F, 0xEDA0, 	// 0x8337D739
	0xEDA1, 0xEDA2, 0xEDA3, 0xEDA4, 0xEDA5, 0xEDA6, 0xEDA7, 0xEDA8, 0xEDA9, 0xEDAA, 	// 0x8337D839
	0xEDAB, 0xEDAC, 0xEDAD, 0xEDAE, 0xEDAF, 0xEDB0, 0xEDB1, 0xEDB2, 0xEDB3, 0xEDB4, 	// 0x8337D939
	0xEDB5, 0xEDB6, 0xEDB7, 0xEDB8, 0xEDB9, 0xEDBA, 0xEDBB, 0xEDBC, 0xEDBD, 0xEDBE, 	// 0x8337DA39
	0xEDBF, 0xEDC0, 0xEDC1, 0xEDC2, 0xEDC3, 0xEDC4, 0xEDC5, 0xEDC6, 0xEDC7, 0xEDC8, 	// 0x8337DB39
	0xEDC9, 0xEDCA, 0xEDCB, 0xEDCC, 0xEDCD, 0xEDCE, 0xEDCF, 0xEDD0, 0xEDD1, 0xEDD2, 	// 0x8337DC39
	0xEDD3, 0xEDD4, 0xEDD5, 0xEDD6, 0xEDD7, 0xEDD8, 0xEDD9, 0xEDDA, 0xEDDB, 0xEDDC, 	// 0x8337DD39
	0xEDDD, 0xEDDE, 0xEDDF, 0xEDE0, 0xEDE1, 0xEDE2, 0xEDE3, 0xEDE4, 0xEDE5, 0xEDE6, 	// 0x8337DE39
	0xEDE7, 0xEDE8, 0xEDE9, 0xEDEA, 0xEDEB, 0xEDEC, 0xEDED, 0xEDEE, 0xEDEF, 0xEDF0, 	// 0x8337DF39
	0xEDF1, 0xEDF2, 0xEDF3, 0xEDF4, 0xEDF5, 0xEDF6, 0xEDF7, 0xEDF8, 0xEDF9, 0xEDFA, 	// 0x8337E039
	0xEDFB, 0xEDFC, 0xEDFD, 0xEDFE, 0xEDFF, 0xEE00, 0xEE01, 0xEE02, 0xEE03, 0xEE04, 	// 0x8337E139
	0xEE05, 0xEE06, 0xEE07, 0xEE08, 0xEE09, 0xEE0A, 0xEE0B, 0xEE0C, 0xEE0D, 0xEE0E, 	// 0x8337E239
	0xEE0F, 0xEE10, 0xEE11, 0xEE12, 0xEE13, 0xEE14, 0xEE15, 0xEE16, 0xEE17, 0xEE18, 	// 0x8337E339
	0xEE19, 0xEE1A, 0xEE1B, 0xEE1C, 0xEE1D, 0xEE1E, 0xEE1F, 0xEE20, 0xEE21, 0xEE22, 	// 0x8337E439
	0xEE23, 0xEE24, 0xEE25, 0xEE26, 0xEE27, 0xEE28, 0xEE29, 0xEE2A, 0xEE2B, 0xEE2C, 	// 0x8337E539
	0xEE2D, 0xEE2E, 0xEE2F, 0xEE30, 0xEE31, 0xEE32, 0xEE33, 0xEE34, 0xEE35, 0xEE36, 	// 0x8337E639
	0xEE37, 0xEE38, 0xEE39, 0xEE3A, 0xEE3B, 0xEE3C, 0xEE3D, 0xEE3E, 0xEE3F, 0xEE40, 	// 0x8337E739
	0xEE41, 0xEE42, 0xEE43, 0xEE44, 0xEE45, 0xEE46, 0xEE47, 0xEE48, 0xEE49, 0xEE4A, 	// 0x8337E839
	0xEE4B, 0xEE4C, 0xEE4D, 0xEE4E, 0xEE4F, 0xEE50, 0xEE51, 0xEE52, 0xEE53, 0xEE54, 	// 0x8337E939
	0xEE55, 0xEE56, 0xEE57, 0xEE58, 0xEE59, 0xEE5A, 0xEE5B, 0xEE5C, 0xEE5D, 0xEE5E, 	// 0x8337EA39
	0xEE5F, 0xEE60, 0xEE61, 0xEE62, 0xEE63, 0xEE64, 0xEE65, 0xEE66, 0xEE67, 0xEE68, 	// 0x8337EB39
	0xEE69, 0xEE6A, 0xEE6B, 0xEE6C, 0xEE6D, 0xEE6E, 0xEE6F, 0xEE70, 0xEE71, 0xEE72, 	// 0x8337EC39
	0xEE73, 0xEE74, 0xEE75, 0xEE76, 0xEE77, 0xEE78, 0xEE79, 0xEE7A, 0xEE7B, 0xEE7C, 	// 0x8337ED39
	0xEE7D, 0xEE7E, 0xEE7F, 0xEE80, 0xEE81, 0xEE82, 0xEE83, 0xEE84, 0xEE85, 0xEE86, 	// 0x8337EE39
	0xEE87, 0xEE88, 0xEE89, 0xEE8A, 0xEE8B, 0xEE8C, 0xEE8D, 0xEE8E, 0xEE8F, 0xEE90, 	// 0x8337EF39
	0xEE91, 0xEE92, 0xEE93, 0xEE94, 0xEE95, 0xEE96, 0xEE97, 0xEE98, 0xEE99, 0xEE9A, 	// 0x8337F039
	0xEE9B, 0xEE9C, 0xEE9D, 0xEE9E, 0xEE9F, 0xEEA0, 0xEEA1, 0xEEA2, 0xEEA3, 0xEEA4, 	// 0x8337F139
	0xEEA5, 0xEEA6, 0xEEA7, 0xEEA8, 0xEEA9, 0xEEAA, 0xEEAB, 0xEEAC, 0xEEAD, 0xEEAE, 	// 0x8337F239
	0xEEAF, 0xEEB0, 0xEEB1, 0xEEB2, 0xEEB3, 0xEEB4, 0xEEB5, 0xEEB6, 0xEEB7, 0xEEB8, 	// 0x8337F339
	0xEEB9, 0xEEBA, 0xEEBB, 0xEEBC, 0xEEBD, 0xEEBE, 0xEEBF, 0xEEC0, 0xEEC1, 0xEEC2, 	// 0x8337F439
	0xEEC3, 0xEEC4, 0xEEC5, 0xEEC6, 0xEEC7, 0xEEC8, 0xEEC9, 0xEECA, 0xEECB, 0xEECC, 	// 0x8337F539
	0xEECD, 0xEECE, 0xEECF, 0xEED0, 0xEED1, 0xEED2, 0xEED3, 0xEED4, 0xEED5, 0xEED6, 	// 0x8337F639
	0xEED7, 0xEED8, 0xEED9, 0xEEDA, 0xEEDB, 0xEEDC, 0xEEDD, 0xEEDE, 0xEEDF, 0xEEE0, 	// 0x8337F739
	0xEEE1, 0xEEE2, 0xEEE3, 0xEEE4, 0xEEE5, 0xEEE6, 0xEEE7, 0xEEE8, 0xEEE9, 0xEEEA, 	// 0x8337F839
	0xEEEB, 0xEEEC, 0xEEED, 0xEEEE, 0xEEEF, 0xEEF0, 0xEEF1, 0xEEF2, 0xEEF3, 0xEEF4, 	// 0x8337F939
	0xEEF5, 0xEEF6, 0xEEF7, 0xEEF8, 0xEEF9, 0xEEFA, 0xEEFB, 0xEEFC, 0xEEFD, 0xEEFE, 	// 0x8337FA39
	0xEEFF, 0xEF00, 0xEF01, 0xEF02, 0xEF03, 0xEF04, 0xEF05, 0xEF06, 0xEF07, 0xEF08, 	// 0x8337FB39
	0xEF09, 0xEF0A, 0xEF0B, 0xEF0C, 0xEF0D, 0xEF0E, 0xEF0F, 0xEF10, 0xEF11, 0xEF12, 	// 0x8337FC39
	0xEF13, 0xEF14, 0xEF15, 0xEF16, 0xEF17, 0xEF18, 0xEF19, 0xEF1A, 0xEF1B, 0xEF1C, 	// 0x8337FD39
	0xEF1D, 0xEF1E, 0xEF1F, 0xEF20, 0xEF21, 0xEF22, 0xEF23, 0xEF24, 0xEF25, 0xEF26, 	// 0x8337FE39
	0xEF27, 0xEF28, 0xEF29, 0xEF2A, 0xEF2B, 0xEF2C, 0xEF2D, 0xEF2E, 0xEF2F, 0xEF30, 	// 0x83388139
	0xEF31, 0xEF32, 0xEF33, 0xEF34, 0xEF35, 0xEF36, 0xEF37, 0xEF38, 0xEF39, 0xEF3A, 	// 0x83388239
	0xEF3B, 0xEF3C, 0xEF3D, 0xEF3E, 0xEF3F, 0xEF40, 0xEF41, 0xEF42, 0xEF43, 0xEF44, 	// 0x83388339
	0xEF45, 0xEF46, 0xEF47, 0xEF48, 0xEF49, 0xEF4A, 0xEF4B, 0xEF4C, 0xEF4D, 0xEF4E, 	// 0x83388439
	0xEF4F, 0xEF50, 0xEF51, 0xEF52, 0xEF53, 0xEF54, 0xEF55, 0xEF56, 0xEF57, 0xEF58, 	// 0x83388539
	0xEF59, 0xEF5A, 0xEF5B, 0xEF5C, 0xEF5D, 0xEF5E, 0xEF5F, 0xEF60, 0xEF61, 0xEF62, 	// 0x83388639
	0xEF63, 0xEF64, 0xEF65, 0xEF66, 0xEF67, 0xEF68, 0xEF69, 0xEF6A, 0xEF6B, 0xEF6C, 	// 0x83388739
	0xEF6D, 0xEF6E, 0xEF6F, 0xEF70, 0xEF71, 0xEF72, 0xEF73, 0xEF74, 0xEF75, 0xEF76, 	// 0x83388839
	0xEF77, 0xEF78, 0xEF79, 0xEF7A, 0xEF7B, 0xEF7C, 0xEF7D, 0xEF7E, 0xEF7F, 0xEF80, 	// 0x83388939
	0xEF81, 0xEF82, 0xEF83, 0xEF84, 0xEF85, 0xEF86, 0xEF87, 0xEF88, 0xEF89, 0xEF8A, 	// 0x83388A39
	0xEF8B, 0xEF8C, 0xEF8D, 0xEF8E, 0xEF8F, 0xEF90, 0xEF91, 0xEF92, 0xEF93, 0xEF94, 	// 0x83388B39
	0xEF95, 0xEF96, 0xEF97, 0xEF98, 0xEF99, 0xEF9A, 0xEF9B, 0xEF9C, 0xEF9D, 0xEF9E, 	// 0x83388C39
	0xEF9F, 0xEFA0, 0xEFA1, 0xEFA2, 0xEFA3, 0xEFA4, 0xEFA5, 0xEFA6, 0xEFA7, 0xEFA8, 	// 0x83388D39
	0xEFA9, 0xEFAA, 0xEFAB, 0xEFAC, 0xEFAD, 0xEFAE, 0xEFAF, 0xEFB0, 0xEFB1, 0xEFB2, 	// 0x83388E39
	0xEFB3, 0xEFB4, 0xEFB5, 0xEFB6, 0xEFB7, 0xEFB8, 0xEFB9, 0xEFBA, 0xEFBB, 0xEFBC, 	// 0x83388F39
	0xEFBD, 0xEFBE, 0xEFBF, 0xEFC0, 0xEFC1, 0xEFC2, 0xEFC3, 0xEFC4, 0xEFC5, 0xEFC6, 	// 0x83389039
	0xEFC7, 0xEFC8, 0xEFC9, 0xEFCA, 0xEFCB, 0xEFCC, 0xEFCD, 0xEFCE, 0xEFCF, 0xEFD0, 	// 0x83389139
	0xEFD1, 0xEFD2, 0xEFD3, 0xEFD4, 0xEFD5, 0xEFD6, 0xEFD7, 0xEFD8, 0xEFD9, 0xEFDA, 	// 0x83389239
	0xEFDB, 0xEFDC, 0xEFDD, 0xEFDE, 0xEFDF, 0xEFE0, 0xEFE1, 0xEFE2, 0xEFE3, 0xEFE4, 	// 0x83389339
	0xEFE5, 0xEFE6, 0xEFE7, 0xEFE8, 0xEFE9, 0xEFEA, 0xEFEB, 0xEFEC, 0xEFED, 0xEFEE, 	// 0x83389439
	0xEFEF, 0xEFF0, 0xEFF1, 0xEFF2, 0xEFF3, 0xEFF4, 0xEFF5, 0xEFF6, 0xEFF7, 0xEFF8, 	// 0x83389539
	0xEFF9, 0xEFFA, 0xEFFB, 0xEFFC, 0xEFFD, 0xEFFE, 0xEFFF, 0xF000, 0xF001, 0xF002, 	// 0x83389639
	0xF003, 0xF004, 0xF005, 0xF006, 0xF007, 0xF008, 0xF009, 0xF00A, 0xF00B, 0xF00C, 	// 0x83389739
	0xF00D, 0xF00E, 0xF00F, 0xF010, 0xF011, 0xF012, 0xF013, 0xF014, 0xF015, 0xF016, 	// 0x83389839
	0xF017, 0xF018, 0xF019, 0xF01A, 0xF01B, 0xF01C, 0xF01D, 0xF01E, 0xF01F, 0xF020, 	// 0x83389939
	0xF021, 0xF022, 0xF023, 0xF024, 0xF025, 0xF026, 0xF027, 0xF028, 0xF029, 0xF02A, 	// 0x83389A39
	0xF02B, 0xF02C, 0xF02D, 0xF02E, 0xF02F, 0xF030, 0xF031, 0xF032, 0xF033, 0xF034, 	// 0x83389B39
	0xF035, 0xF036, 0xF037, 0xF038, 0xF039, 0xF03A, 0xF03B, 0xF03C, 0xF03D, 0xF03E, 	// 0x83389C39
	0xF03F, 0xF040, 0xF041, 0xF042, 0xF043, 0xF044, 0xF045, 0xF046, 0xF047, 0xF048, 	// 0x83389D39
	0xF049, 0xF04A, 0xF04B, 0xF04C, 0xF04D, 0xF04E, 0xF04F, 0xF050, 0xF051, 0xF052, 	// 0x83389E39
	0xF053, 0xF054, 0xF055, 0xF056, 0xF057, 0xF058, 0xF059, 0xF05A, 0xF05B, 0xF05C, 	// 0x83389F39
	0xF05D, 0xF05E, 0xF05F, 0xF060, 0xF061, 0xF062, 0xF063, 0xF064, 0xF065, 0xF066, 	// 0x8338A039
	0xF067, 0xF068, 0xF069, 0xF06A, 0xF06B, 0xF06C, 0xF06D, 0xF06E, 0xF06F, 0xF070, 	// 0x8338A139
	0xF071, 0xF072, 0xF073, 0xF074, 0xF075, 0xF076, 0xF077, 0xF078, 0xF079, 0xF07A, 	// 0x8338A239
	0xF07B, 0xF07C, 0xF07D, 0xF07E, 0xF07F, 0xF080, 0xF081, 0xF082, 0xF083, 0xF084, 	// 0x8338A339
	0xF085, 0xF086, 0xF087, 0xF088, 0xF089, 0xF08A, 0xF08B, 0xF08C, 0xF08D, 0xF08E, 	// 0x8338A439
	0xF08F, 0xF090, 0xF091, 0xF092, 0xF093, 0xF094, 0xF095, 0xF096, 0xF097, 0xF098, 	// 0x8338A539
	0xF099, 0xF09A, 0xF09B, 0xF09C, 0xF09D, 0xF09E, 0xF09F, 0xF0A0, 0xF0A1, 0xF0A2, 	// 0x8338A639
	0xF0A3, 0xF0A4, 0xF0A5, 0xF0A6, 0xF0A7, 0xF0A8, 0xF0A9, 0xF0AA, 0xF0AB, 0xF0AC, 	// 0x8338A739
	0xF0AD, 0xF0AE, 0xF0AF, 0xF0B0, 0xF0B1, 0xF0B2, 0xF0B3, 0xF0B4, 0xF0B5, 0xF0B6, 	// 0x8338A839
	0xF0B7, 0xF0B8, 0xF0B9, 0xF0BA, 0xF0BB, 0xF0BC, 0xF0BD, 0xF0BE, 0xF0BF, 0xF0C0, 	// 0x8338A939
	0xF0C1, 0xF0C2, 0xF0C3, 0xF0C4, 0xF0C5, 0xF0C6, 0xF0C7, 0xF0C8, 0xF0C9, 0xF0CA, 	// 0x8338AA39
	0xF0CB, 0xF0CC, 0xF0CD, 0xF0CE, 0xF0CF, 0xF0D0, 0xF0D1, 0xF0D2, 0xF0D3, 0xF0D4, 	// 0x8338AB39
	0xF0D5, 0xF0D6, 0xF0D7, 0xF0D8, 0xF0D9, 0xF0DA, 0xF0DB, 0xF0DC, 0xF0DD, 0xF0DE, 	// 0x8338AC39
	0xF0DF, 0xF0E0, 0xF0E1, 0xF0E2, 0xF0E3, 0xF0E4, 0xF0E5, 0xF0E6, 0xF0E7, 0xF0E8, 	// 0x8338AD39
	0xF0E9, 0xF0EA, 0xF0EB, 0xF0EC, 0xF0ED, 0xF0EE, 0xF0EF, 0xF0F0, 0xF0F1, 0xF0F2, 	// 0x8338AE39
	0xF0F3, 0xF0F4, 0xF0F5, 0xF0F6, 0xF0F7, 0xF0F8, 0xF0F9, 0xF0FA, 0xF0FB, 0xF0FC, 	// 0x8338AF39
	0xF0FD, 0xF0FE, 0xF0FF, 0xF100, 0xF101, 0xF102, 0xF103, 0xF104, 0xF105, 0xF106, 	// 0x8338B039
	0xF107, 0xF108, 0xF109, 0xF10A, 0xF10B, 0xF10C, 0xF10D, 0xF10E, 0xF10F, 0xF110, 	// 0x8338B139
	0xF111, 0xF112, 0xF113, 0xF114, 0xF115, 0xF116, 0xF117, 0xF118, 0xF119, 0xF11A, 	// 0x8338B239
	0xF11B, 0xF11C, 0xF11D, 0xF11E, 0xF11F, 0xF120, 0xF121, 0xF122, 0xF123, 0xF124, 	// 0x8338B339
	0xF125, 0xF126, 0xF127, 0xF128, 0xF129, 0xF12A, 0xF12B, 0xF12C, 0xF12D, 0xF12E, 	// 0x8338B439
	0xF12F, 0xF130, 0xF131, 0xF132, 0xF133, 0xF134, 0xF135, 0xF136, 0xF137, 0xF138, 	// 0x8338B539
	0xF139, 0xF13A, 0xF13B, 0xF13C, 0xF13D, 0xF13E, 0xF13F, 0xF140, 0xF141, 0xF142, 	// 0x8338B639
	0xF143, 0xF144, 0xF145, 0xF146, 0xF147, 0xF148, 0xF149, 0xF14A, 0xF14B, 0xF14C, 	// 0x8338B739
	0xF14D, 0xF14E, 0xF14F, 0xF150, 0xF151, 0xF152, 0xF153, 0xF154, 0xF155, 0xF156, 	// 0x8338B839
	0xF157, 0xF158, 0xF159, 0xF15A, 0xF15B, 0xF15C, 0xF15D, 0xF15E, 0xF15F, 0xF160, 	// 0x8338B939
	0xF161, 0xF162, 0xF163, 0xF164, 0xF165, 0xF166, 0xF167, 0xF168, 0xF169, 0xF16A, 	// 0x8338BA39
	0xF16B, 0xF16C, 0xF16D, 0xF16E, 0xF16F, 0xF170, 0xF171, 0xF172, 0xF173, 0xF174, 	// 0x8338BB39
	0xF175, 0xF176, 0xF177, 0xF178, 0xF179, 0xF17A, 0xF17B, 0xF17C, 0xF17D, 0xF17E, 	// 0x8338BC39
	0xF17F, 0xF180, 0xF181, 0xF182, 0xF183, 0xF184, 0xF185, 0xF186, 0xF187, 0xF188, 	// 0x8338BD39
	0xF189, 0xF18A, 0xF18B, 0xF18C, 0xF18D, 0xF18E, 0xF18F, 0xF190, 0xF191, 0xF192, 	// 0x8338BE39
	0xF193, 0xF194, 0xF195, 0xF196, 0xF197, 0xF198, 0xF199, 0xF19A, 0xF19B, 0xF19C, 	// 0x8338BF39
	0xF19D, 0xF19E, 0xF19F, 0xF1A0, 0xF1A1, 0xF1A2, 0xF1A3, 0xF1A4, 0xF1A5, 0xF1A6, 	// 0x8338C039
	0xF1A7, 0xF1A8, 0xF1A9, 0xF1AA, 0xF1AB, 0xF1AC, 0xF1AD, 0xF1AE, 0xF1AF, 0xF1B0, 	// 0x8338C139
	0xF1B1, 0xF1B2, 0xF1B3, 0xF1B4, 0xF1B5, 0xF1B6, 0xF1B7, 0xF1B8, 0xF1B9, 0xF1BA, 	// 0x8338C239
	0xF1BB, 0xF1BC, 0xF1BD, 0xF1BE, 0xF1BF, 0xF1C0, 0xF1C1, 0xF1C2, 0xF1C3, 0xF1C4, 	// 0x8338C339
	0xF1C5, 0xF1C6, 0xF1C7, 0xF1C8, 0xF1C9, 0xF1CA, 0xF1CB, 0xF1CC, 0xF1CD, 0xF1CE, 	// 0x8338C439
	0xF1CF, 0xF1D0, 0xF1D1, 0xF1D2, 0xF1D3, 0xF1D4, 0xF1D5, 0xF1D6, 0xF1D7, 0xF1D8, 	// 0x8338C539
	0xF1D9, 0xF1DA, 0xF1DB, 0xF1DC, 0xF1DD, 0xF1DE, 0xF1DF, 0xF1E0, 0xF1E1, 0xF1E2, 	// 0x8338C639
	0xF1E3, 0xF1E4, 0xF1E5, 0xF1E6, 0xF1E7, 0xF1E8, 0xF1E9, 0xF1EA, 0xF1EB, 0xF1EC, 	// 0x8338C739
	0xF1ED, 0xF1EE, 0xF1EF, 0xF1F0, 0xF1F1, 0xF1F2, 0xF1F3, 0xF1F4, 0xF1F5, 0xF1F6, 	// 0x8338C839
	0xF1F7, 0xF1F8, 0xF1F9, 0xF1FA, 0xF1FB, 0xF1FC, 0xF1FD, 0xF1FE, 0xF1FF, 0xF200, 	// 0x8338C939
	0xF201, 0xF202, 0xF203, 0xF204, 0xF205, 0xF206, 0xF207, 0xF208, 0xF209, 0xF20A, 	// 0x8338CA39
	0xF20B, 0xF20C, 0xF20D, 0xF20E, 0xF20F, 0xF210, 0xF211, 0xF212, 0xF213, 0xF214, 	// 0x8338CB39
	0xF215, 0xF216, 0xF217, 0xF218, 0xF219, 0xF21A, 0xF21B, 0xF21C, 0xF21D, 0xF21E, 	// 0x8338CC39
	0xF21F, 0xF220, 0xF221, 0xF222, 0xF223, 0xF224, 0xF225, 0xF226, 0xF227, 0xF228, 	// 0x8338CD39
	0xF229, 0xF22A, 0xF22B, 0xF22C, 0xF22D, 0xF22E, 0xF22F, 0xF230, 0xF231, 0xF232, 	// 0x8338CE39
	0xF233, 0xF234, 0xF235, 0xF236, 0xF237, 0xF238, 0xF239, 0xF23A, 0xF23B, 0xF23C, 	// 0x8338CF39
	0xF23D, 0xF23E, 0xF23F, 0xF240, 0xF241, 0xF242, 0xF243, 0xF244, 0xF245, 0xF246, 	// 0x8338D039
	0xF247, 0xF248, 0xF249, 0xF24A, 0xF24B, 0xF24C, 0xF24D, 0xF24E, 0xF24F, 0xF250, 	// 0x8338D139
	0xF251, 0xF252, 0xF253, 0xF254, 0xF255, 0xF256, 0xF257, 0xF258, 0xF259, 0xF25A, 	// 0x8338D239
	0xF25B, 0xF25C, 0xF25D, 0xF25E, 0xF25F, 0xF260, 0xF261, 0xF262, 0xF263, 0xF264, 	// 0x8338D339
	0xF265, 0xF266, 0xF267, 0xF268, 0xF269, 0xF26A, 0xF26B, 0xF26C, 0xF26D, 0xF26E, 	// 0x8338D439
	0xF26F, 0xF270, 0xF271, 0xF272, 0xF273, 0xF274, 0xF275, 0xF276, 0xF277, 0xF278, 	// 0x8338D539
	0xF279, 0xF27A, 0xF27B, 0xF27C, 0xF27D, 0xF27E, 0xF27F, 0xF280, 0xF281, 0xF282, 	// 0x8338D639
	0xF283, 0xF284, 0xF285, 0xF286, 0xF287, 0xF288, 0xF289, 0xF28A, 0xF28B, 0xF28C, 	// 0x8338D739
	0xF28D, 0xF28E, 0xF28F, 0xF290, 0xF291, 0xF292, 0xF293, 0xF294, 0xF295, 0xF296, 	// 0x8338D839
	0xF297, 0xF298, 0xF299, 0xF29A, 0xF29B, 0xF29C, 0xF29D, 0xF29E, 0xF29F, 0xF2A0, 	// 0x8338D939
	0xF2A1, 0xF2A2, 0xF2A3, 0xF2A4, 0xF2A5, 0xF2A6, 0xF2A7, 0xF2A8, 0xF2A9, 0xF2AA, 	// 0x8338DA39
	0xF2AB, 0xF2AC, 0xF2AD, 0xF2AE, 0xF2AF, 0xF2B0, 0xF2B1, 0xF2B2, 0xF2B3, 0xF2B4, 	// 0x8338DB39
	0xF2B5, 0xF2B6, 0xF2B7, 0xF2B8, 0xF2B9, 0xF2BA, 0xF2BB, 0xF2BC, 0xF2BD, 0xF2BE, 	// 0x8338DC39
	0xF2BF, 0xF2C0, 0xF2C1, 0xF2C2, 0xF2C3, 0xF2C4, 0xF2C5, 0xF2C6, 0xF2C7, 0xF2C8, 	// 0x8338DD39
	0xF2C9, 0xF2CA, 0xF2CB, 0xF2CC, 0xF2CD, 0xF2CE, 0xF2CF, 0xF2D0, 0xF2D1, 0xF2D2, 	// 0x8338DE39
	0xF2D3, 0xF2D4, 0xF2D5, 0xF2D6, 0xF2D7, 0xF2D8, 0xF2D9, 0xF2DA, 0xF2DB, 0xF2DC, 	// 0x8338DF39
	0xF2DD, 0xF2DE, 0xF2DF, 0xF2E0, 0xF2E1, 0xF2E2, 0xF2E3, 0xF2E4, 0xF2E5, 0xF2E6, 	// 0x8338E039
	0xF2E7, 0xF2E8, 0xF2E9, 0xF2EA, 0xF2EB, 0xF2EC, 0xF2ED, 0xF2EE, 0xF2EF, 0xF2F0, 	// 0x8338E139
	0xF2F1, 0xF2F2, 0xF2F3, 0xF2F4, 0xF2F5, 0xF2F6, 0xF2F7, 0xF2F8, 0xF2F9, 0xF2FA, 	// 0x8338E239
	0xF2FB, 0xF2FC, 0xF2FD, 0xF2FE, 0xF2FF, 0xF300, 0xF301, 0xF302, 0xF303, 0xF304, 	// 0x8338E339
	0xF305, 0xF306, 0xF307, 0xF308, 0xF309, 0xF30A, 0xF30B, 0xF30C, 0xF30D, 0xF30E, 	// 0x8338E439
	0xF30F, 0xF310, 0xF311, 0xF312, 0xF313, 0xF314, 0xF315, 0xF316, 0xF317, 0xF318, 	// 0x8338E539
	0xF319, 0xF31A, 0xF31B, 0xF31C, 0xF31D, 0xF31E, 0xF31F, 0xF320, 0xF321, 0xF322, 	// 0x8338E639
	0xF323, 0xF324, 0xF325, 0xF326, 0xF327, 0xF328, 0xF329, 0xF32A, 0xF32B, 0xF32C, 	// 0x8338E739
	0xF32D, 0xF32E, 0xF32F, 0xF330, 0xF331, 0xF332, 0xF333, 0xF334, 0xF335, 0xF336, 	// 0x8338E839
	0xF337, 0xF338, 0xF339, 0xF33A, 0xF33B, 0xF33C, 0xF33D, 0xF33E, 0xF33F, 0xF340, 	// 0x8338E939
	0xF341, 0xF342, 0xF343, 0xF344, 0xF345, 0xF346, 0xF347, 0xF348, 0xF349, 0xF34A, 	// 0x8338EA39
	0xF34B, 0xF34C, 0xF34D, 0xF34E, 0xF34F, 0xF350, 0xF351, 0xF352, 0xF353, 0xF354, 	// 0x8338EB39
	0xF355, 0xF356, 0xF357, 0xF358, 0xF359, 0xF35A, 0xF35B, 0xF35C, 0xF35D, 0xF35E, 	// 0x8338EC39
	0xF35F, 0xF360, 0xF361, 0xF362, 0xF363, 0xF364, 0xF365, 0xF366, 0xF367, 0xF368, 	// 0x8338ED39
	0xF369, 0xF36A, 0xF36B, 0xF36C, 0xF36D, 0xF36E, 0xF36F, 0xF370, 0xF371, 0xF372, 	// 0x8338EE39
	0xF373, 0xF374, 0xF375, 0xF376, 0xF377, 0xF378, 0xF379, 0xF37A, 0xF37B, 0xF37C, 	// 0x8338EF39
	0xF37D, 0xF37E, 0xF37F, 0xF380, 0xF381, 0xF382, 0xF383, 0xF384, 0xF385, 0xF386, 	// 0x8338F039
	0xF387, 0xF388, 0xF389, 0xF38A, 0xF38B, 0xF38C, 0xF38D, 0xF38E, 0xF38F, 0xF390, 	// 0x8338F139
	0xF391, 0xF392, 0xF393, 0xF394, 0xF395, 0xF396, 0xF397, 0xF398, 0xF399, 0xF39A, 	// 0x8338F239
	0xF39B, 0xF39C, 0xF39D, 0xF39E, 0xF39F, 0xF3A0, 0xF3A1, 0xF3A2, 0xF3A3, 0xF3A4, 	// 0x8338F339
	0xF3A5, 0xF3A6, 0xF3A7, 0xF3A8, 0xF3A9, 0xF3AA, 0xF3AB, 0xF3AC, 0xF3AD, 0xF3AE, 	// 0x8338F439
	0xF3AF, 0xF3B0, 0xF3B1, 0xF3B2, 0xF3B3, 0xF3B4, 0xF3B5, 0xF3B6, 0xF3B7, 0xF3B8, 	// 0x8338F539
	0xF3B9, 0xF3BA, 0xF3BB, 0xF3BC, 0xF3BD, 0xF3BE, 0xF3BF, 0xF3C0, 0xF3C1, 0xF3C2, 	// 0x8338F639
	0xF3C3, 0xF3C4, 0xF3C5, 0xF3C6, 0xF3C7, 0xF3C8, 0xF3C9, 0xF3CA, 0xF3CB, 0xF3CC, 	// 0x8338F739
	0xF3CD, 0xF3CE, 0xF3CF, 0xF3D0, 0xF3D1, 0xF3D2, 0xF3D3, 0xF3D4, 0xF3D5, 0xF3D6, 	// 0x8338F839
	0xF3D7, 0xF3D8, 0xF3D9, 0xF3DA, 0xF3DB, 0xF3DC, 0xF3DD, 0xF3DE, 0xF3DF, 0xF3E0, 	// 0x8338F939
	0xF3E1, 0xF3E2, 0xF3E3, 0xF3E4, 0xF3E5, 0xF3E6, 0xF3E7, 0xF3E8, 0xF3E9, 0xF3EA, 	// 0x8338FA39
	0xF3EB, 0xF3EC, 0xF3ED, 0xF3EE, 0xF3EF, 0xF3F0, 0xF3F1, 0xF3F2, 0xF3F3, 0xF3F4, 	// 0x8338FB39
	0xF3F5, 0xF3F6, 0xF3F7, 0xF3F8, 0xF3F9, 0xF3FA, 0xF3FB, 0xF3FC, 0xF3FD, 0xF3FE, 	// 0x8338FC39
	0xF3FF, 0xF400, 0xF401, 0xF402, 0xF403, 0xF404, 0xF405, 0xF406, 0xF407, 0xF408, 	// 0x8338FD39
	0xF409, 0xF40A, 0xF40B, 0xF40C, 0xF40D, 0xF40E, 0xF40F, 0xF410, 0xF411, 0xF412, 	// 0x8338FE39
	0xF413, 0xF414, 0xF415, 0xF416, 0xF417, 0xF418, 0xF419, 0xF41A, 0xF41B, 0xF41C, 	// 0x83398139
	0xF41D, 0xF41E, 0xF41F, 0xF420, 0xF421, 0xF422, 0xF423, 0xF424, 0xF425, 0xF426, 	// 0x83398239
	0xF427, 0xF428, 0xF429, 0xF42A, 0xF42B, 0xF42C, 0xF42D, 0xF42E, 0xF42F, 0xF430, 	// 0x83398339
	0xF431, 0xF432, 0xF433, 0xF434, 0xF435, 0xF436, 0xF437, 0xF438, 0xF439, 0xF43A, 	// 0x83398439
	0xF43B, 0xF43C, 0xF43D, 0xF43E, 0xF43F, 0xF440, 0xF441, 0xF442, 0xF443, 0xF444, 	// 0x83398539
	0xF445, 0xF446, 0xF447, 0xF448, 0xF449, 0xF44A, 0xF44B, 0xF44C, 0xF44D, 0xF44E, 	// 0x83398639
	0xF44F, 0xF450, 0xF451, 0xF452, 0xF453, 0xF454, 0xF455, 0xF456, 0xF457, 0xF458, 	// 0x83398739
	0xF459, 0xF45A, 0xF45B, 0xF45C, 0xF45D, 0xF45E, 0xF45F, 0xF460, 0xF461, 0xF462, 	// 0x83398839
	0xF463, 0xF464, 0xF465, 0xF466, 0xF467, 0xF468, 0xF469, 0xF46A, 0xF46B, 0xF46C, 	// 0x83398939
	0xF46D, 0xF46E, 0xF46F, 0xF470, 0xF471, 0xF472, 0xF473, 0xF474, 0xF475, 0xF476, 	// 0x83398A39
	0xF477, 0xF478, 0xF479, 0xF47A, 0xF47B, 0xF47C, 0xF47D, 0xF47E, 0xF47F, 0xF480, 	// 0x83398B39
	0xF481, 0xF482, 0xF483, 0xF484, 0xF485, 0xF486, 0xF487, 0xF488, 0xF489, 0xF48A, 	// 0x83398C39
	0xF48B, 0xF48C, 0xF48D, 0xF48E, 0xF48F, 0xF490, 0xF491, 0xF492, 0xF493, 0xF494, 	// 0x83398D39
	0xF495, 0xF496, 0xF497, 0xF498, 0xF499, 0xF49A, 0xF49B, 0xF49C, 0xF49D, 0xF49E, 	// 0x83398E39
	0xF49F, 0xF4A0, 0xF4A1, 0xF4A2, 0xF4A3, 0xF4A4, 0xF4A5, 0xF4A6, 0xF4A7, 0xF4A8, 	// 0x83398F39
	0xF4A9, 0xF4AA, 0xF4AB, 0xF4AC, 0xF4AD, 0xF4AE, 0xF4AF, 0xF4B0, 0xF4B1, 0xF4B2, 	// 0x83399039
	0xF4B3, 0xF4B4, 0xF4B5, 0xF4B6, 0xF4B7, 0xF4B8, 0xF4B9, 0xF4BA, 0xF4BB, 0xF4BC, 	// 0x83399139
	0xF4BD, 0xF4BE, 0xF4BF, 0xF4C0, 0xF4C1, 0xF4C2, 0xF4C3, 0xF4C4, 0xF4C5, 0xF4C6, 	// 0x83399239
	0xF4C7, 0xF4C8, 0xF4C9, 0xF4CA, 0xF4CB, 0xF4CC, 0xF4CD, 0xF4CE, 0xF4CF, 0xF4D0, 	// 0x83399339
	0xF4D1, 0xF4D2, 0xF4D3, 0xF4D4, 0xF4D5, 0xF4D6, 0xF4D7, 0xF4D8, 0xF4D9, 0xF4DA, 	// 0x83399439
	0xF4DB, 0xF4DC, 0xF4DD, 0xF4DE, 0xF4DF, 0xF4E0, 0xF4E1, 0xF4E2, 0xF4E3, 0xF4E4, 	// 0x83399539
	0xF4E5, 0xF4E6, 0xF4E7, 0xF4E8, 0xF4E9, 0xF4EA, 0xF4EB, 0xF4EC, 0xF4ED, 0xF4EE, 	// 0x83399639
	0xF4EF, 0xF4F0, 0xF4F1, 0xF4F2, 0xF4F3, 0xF4F4, 0xF4F5, 0xF4F6, 0xF4F7, 0xF4F8, 	// 0x83399739
	0xF4F9, 0xF4FA, 0xF4FB, 0xF4FC, 0xF4FD, 0xF4FE, 0xF4FF, 0xF500, 0xF501, 0xF502, 	// 0x83399839
	0xF503, 0xF504, 0xF505, 0xF506, 0xF507, 0xF508, 0xF509, 0xF50A, 0xF50B, 0xF50C, 	// 0x83399939
	0xF50D, 0xF50E, 0xF50F, 0xF510, 0xF511, 0xF512, 0xF513, 0xF514, 0xF515, 0xF516, 	// 0x83399A39
	0xF517, 0xF518, 0xF519, 0xF51A, 0xF51B, 0xF51C, 0xF51D, 0xF51E, 0xF51F, 0xF520, 	// 0x83399B39
	0xF521, 0xF522, 0xF523, 0xF524, 0xF525, 0xF526, 0xF527, 0xF528, 0xF529, 0xF52A, 	// 0x83399C39
	0xF52B, 0xF52C, 0xF52D, 0xF52E, 0xF52F, 0xF530, 0xF531, 0xF532, 0xF533, 0xF534, 	// 0x83399D39
	0xF535, 0xF536, 0xF537, 0xF538, 0xF539, 0xF53A, 0xF53B, 0xF53C, 0xF53D, 0xF53E, 	// 0x83399E39
	0xF53F, 0xF540, 0xF541, 0xF542, 0xF543, 0xF544, 0xF545, 0xF546, 0xF547, 0xF548, 	// 0x83399F39
	0xF549, 0xF54A, 0xF54B, 0xF54C, 0xF54D, 0xF54E, 0xF54F, 0xF550, 0xF551, 0xF552, 	// 0x8339A039
	0xF553, 0xF554, 0xF555, 0xF556, 0xF557, 0xF558, 0xF559, 0xF55A, 0xF55B, 0xF55C, 	// 0x8339A139
	0xF55D, 0xF55E, 0xF55F, 0xF560, 0xF561, 0xF562, 0xF563, 0xF564, 0xF565, 0xF566, 	// 0x8339A239
	0xF567, 0xF568, 0xF569, 0xF56A, 0xF56B, 0xF56C, 0xF56D, 0xF56E, 0xF56F, 0xF570, 	// 0x8339A339
	0xF571, 0xF572, 0xF573, 0xF574, 0xF575, 0xF576, 0xF577, 0xF578, 0xF579, 0xF57A, 	// 0x8339A439
	0xF57B, 0xF57C, 0xF57D, 0xF57E, 0xF57F, 0xF580, 0xF581, 0xF582, 0xF583, 0xF584, 	// 0x8339A539
	0xF585, 0xF586, 0xF587, 0xF588, 0xF589, 0xF58A, 0xF58B, 0xF58C, 0xF58D, 0xF58E, 	// 0x8339A639
	0xF58F, 0xF590, 0xF591, 0xF592, 0xF593, 0xF594, 0xF595, 0xF596, 0xF597, 0xF598, 	// 0x8339A739
	0xF599, 0xF59A, 0xF59B, 0xF59C, 0xF59D, 0xF59E, 0xF59F, 0xF5A0, 0xF5A1, 0xF5A2, 	// 0x8339A839
	0xF5A3, 0xF5A4, 0xF5A5, 0xF5A6, 0xF5A7, 0xF5A8, 0xF5A9, 0xF5AA, 0xF5AB, 0xF5AC, 	// 0x8339A939
	0xF5AD, 0xF5AE, 0xF5AF, 0xF5B0, 0xF5B1, 0xF5B2, 0xF5B3, 0xF5B4, 0xF5B5, 0xF5B6, 	// 0x8339AA39
	0xF5B7, 0xF5B8, 0xF5B9, 0xF5BA, 0xF5BB, 0xF5BC, 0xF5BD, 0xF5BE, 0xF5BF, 0xF5C0, 	// 0x8339AB39
	0xF5C1, 0xF5C2, 0xF5C3, 0xF5C4, 0xF5C5, 0xF5C6, 0xF5C7, 0xF5C8, 0xF5C9, 0xF5CA, 	// 0x8339AC39
	0xF5CB, 0xF5CC, 0xF5CD, 0xF5CE, 0xF5CF, 0xF5D0, 0xF5D1, 0xF5D2, 0xF5D3, 0xF5D4, 	// 0x8339AD39
	0xF5D5, 0xF5D6, 0xF5D7, 0xF5D8, 0xF5D9, 0xF5DA, 0xF5DB, 0xF5DC, 0xF5DD, 0xF5DE, 	// 0x8339AE39
	0xF5DF, 0xF5E0, 0xF5E1, 0xF5E2, 0xF5E3, 0xF5E4, 0xF5E5, 0xF5E6, 0xF5E7, 0xF5E8, 	// 0x8339AF39
	0xF5E9, 0xF5EA, 0xF5EB, 0xF5EC, 0xF5ED, 0xF5EE, 0xF5EF, 0xF5F0, 0xF5F1, 0xF5F2, 	// 0x8339B039
	0xF5F3, 0xF5F4, 0xF5F5, 0xF5F6, 0xF5F7, 0xF5F8, 0xF5F9, 0xF5FA, 0xF5FB, 0xF5FC, 	// 0x8339B139
	0xF5FD, 0xF5FE, 0xF5FF, 0xF600, 0xF601, 0xF602, 0xF603, 0xF604, 0xF605, 0xF606, 	// 0x8339B239
	0xF607, 0xF608, 0xF609, 0xF60A, 0xF60B, 0xF60C, 0xF60D, 0xF60E, 0xF60F, 0xF610, 	// 0x8339B339
	0xF611, 0xF612, 0xF613, 0xF614, 0xF615, 0xF616, 0xF617, 0xF618, 0xF619, 0xF61A, 	// 0x8339B439
	0xF61B, 0xF61C, 0xF61D, 0xF61E, 0xF61F, 0xF620, 0xF621, 0xF622, 0xF623, 0xF624, 	// 0x8339B539
	0xF625, 0xF626, 0xF627, 0xF628, 0xF629, 0xF62A, 0xF62B, 0xF62C, 0xF62D, 0xF62E, 	// 0x8339B639
	0xF62F, 0xF630, 0xF631, 0xF632, 0xF633, 0xF634, 0xF635, 0xF636, 0xF637, 0xF638, 	// 0x8339B739
	0xF639, 0xF63A, 0xF63B, 0xF63C, 0xF63D, 0xF63E, 0xF63F, 0xF640, 0xF641, 0xF642, 	// 0x8339B839
	0xF643, 0xF644, 0xF645, 0xF646, 0xF647, 0xF648, 0xF649, 0xF64A, 0xF64B, 0xF64C, 	// 0x8339B939
	0xF64D, 0xF64E, 0xF64F, 0xF650, 0xF651, 0xF652, 0xF653, 0xF654, 0xF655, 0xF656, 	// 0x8339BA39
	0xF657, 0xF658, 0xF659, 0xF65A, 0xF65B, 0xF65C, 0xF65D, 0xF65E, 0xF65F, 0xF660, 	// 0x8339BB39
	0xF661, 0xF662, 0xF663, 0xF664, 0xF665, 0xF666, 0xF667, 0xF668, 0xF669, 0xF66A, 	// 0x8339BC39
	0xF66B, 0xF66C, 0xF66D, 0xF66E, 0xF66F, 0xF670, 0xF671, 0xF672, 0xF673, 0xF674, 	// 0x8339BD39
	0xF675, 0xF676, 0xF677, 0xF678, 0xF679, 0xF67A, 0xF67B, 0xF67C, 0xF67D, 0xF67E, 	// 0x8339BE39
	0xF67F, 0xF680, 0xF681, 0xF682, 0xF683, 0xF684, 0xF685, 0xF686, 0xF687, 0xF688, 	// 0x8339BF39
	0xF689, 0xF68A, 0xF68B, 0xF68C, 0xF68D, 0xF68E, 0xF68F, 0xF690, 0xF691, 0xF692, 	// 0x8339C039
	0xF693, 0xF694, 0xF695, 0xF696, 0xF697, 0xF698, 0xF699, 0xF69A, 0xF69B, 0xF69C, 	// 0x8339C139
	0xF69D, 0xF69E, 0xF69F, 0xF6A0, 0xF6A1, 0xF6A2, 0xF6A3, 0xF6A4, 0xF6A5, 0xF6A6, 	// 0x8339C239
	0xF6A7, 0xF6A8, 0xF6A9, 0xF6AA, 0xF6AB, 0xF6AC, 0xF6AD, 0xF6AE, 0xF6AF, 0xF6B0, 	// 0x8339C339
	0xF6B1, 0xF6B2, 0xF6B3, 0xF6B4, 0xF6B5, 0xF6B6, 0xF6B7, 0xF6B8, 0xF6B9, 0xF6BA, 	// 0x8339C439
	0xF6BB, 0xF6BC, 0xF6BD, 0xF6BE, 0xF6BF, 0xF6C0, 0xF6C1, 0xF6C2, 0xF6C3, 0xF6C4, 	// 0x8339C539
	0xF6C5, 0xF6C6, 0xF6C7, 0xF6C8, 0xF6C9, 0xF6CA, 0xF6CB, 0xF6CC, 0xF6CD, 0xF6CE, 	// 0x8339C639
	0xF6CF, 0xF6D0, 0xF6D1, 0xF6D2, 0xF6D3, 0xF6D4, 0xF6D5, 0xF6D6, 0xF6D7, 0xF6D8, 	// 0x8339C739
	0xF6D9, 0xF6DA, 0xF6DB, 0xF6DC, 0xF6DD, 0xF6DE, 0xF6DF, 0xF6E0, 0xF6E1, 0xF6E2, 	// 0x8339C839
	0xF6E3, 0xF6E4, 0xF6E5, 0xF6E6, 0xF6E7, 0xF6E8, 0xF6E9, 0xF6EA, 0xF6EB, 0xF6EC, 	// 0x8339C939
	0xF6ED, 0xF6EE, 0xF6EF, 0xF6F0, 0xF6F1, 0xF6F2, 0xF6F3, 0xF6F4, 0xF6F5, 0xF6F6, 	// 0x8339CA39
	0xF6F7, 0xF6F8, 0xF6F9, 0xF6FA, 0xF6FB, 0xF6FC, 0xF6FD, 0xF6FE, 0xF6FF, 0xF700, 	// 0x8339CB39
	0xF701, 0xF702, 0xF703, 0xF704, 0xF705, 0xF706, 0xF707, 0xF708, 0xF709, 0xF70A, 	// 0x8339CC39
	0xF70B, 0xF70C, 0xF70D, 0xF70E, 0xF70F, 0xF710, 0xF711, 0xF712, 0xF713, 0xF714, 	// 0x8339CD39
	0xF715, 0xF716, 0xF717, 0xF718, 0xF719, 0xF71A, 0xF71B, 0xF71C, 0xF71D, 0xF71E, 	// 0x8339CE39
	0xF71F, 0xF720, 0xF721, 0xF722, 0xF723, 0xF724, 0xF725, 0xF726, 0xF727, 0xF728, 	// 0x8339CF39
	0xF729, 0xF72A, 0xF72B, 0xF72C, 0xF72D, 0xF72E, 0xF72F, 0xF730, 0xF731, 0xF732, 	// 0x8339D039
	0xF733, 0xF734, 0xF735, 0xF736, 0xF737, 0xF738, 0xF739, 0xF73A, 0xF73B, 0xF73C, 	// 0x8339D139
	0xF73D, 0xF73E, 0xF73F, 0xF740, 0xF741, 0xF742, 0xF743, 0xF744, 0xF745, 0xF746, 	// 0x8339D239
	0xF747, 0xF748, 0xF749, 0xF74A, 0xF74B, 0xF74C, 0xF74D, 0xF74E, 0xF74F, 0xF750, 	// 0x8339D339
	0xF751, 0xF752, 0xF753, 0xF754, 0xF755, 0xF756, 0xF757, 0xF758, 0xF759, 0xF75A, 	// 0x8339D439
	0xF75B, 0xF75C, 0xF75D, 0xF75E, 0xF75F, 0xF760, 0xF761, 0xF762, 0xF763, 0xF764, 	// 0x8339D539
	0xF765, 0xF766, 0xF767, 0xF768, 0xF769, 0xF76A, 0xF76B, 0xF76C, 0xF76D, 0xF76E, 	// 0x8339D639
	0xF76F, 0xF770, 0xF771, 0xF772, 0xF773, 0xF774, 0xF775, 0xF776, 0xF777, 0xF778, 	// 0x8339D739
	0xF779, 0xF77A, 0xF77B, 0xF77C, 0xF77D, 0xF77E, 0xF77F, 0xF780, 0xF781, 0xF782, 	// 0x8339D839
	0xF783, 0xF784, 0xF785, 0xF786, 0xF787, 0xF788, 0xF789, 0xF78A, 0xF78B, 0xF78C, 	// 0x8339D939
	0xF78D, 0xF78E, 0xF78F, 0xF790, 0xF791, 0xF792, 0xF793, 0xF794, 0xF795, 0xF796, 	// 0x8339DA39
	0xF797, 0xF798, 0xF799, 0xF79A, 0xF79B, 0xF79C, 0xF79D, 0xF79E, 0xF79F, 0xF7A0, 	// 0x8339DB39
	0xF7A1, 0xF7A2, 0xF7A3, 0xF7A4, 0xF7A5, 0xF7A6, 0xF7A7, 0xF7A8, 0xF7A9, 0xF7AA, 	// 0x8339DC39
	0xF7AB, 0xF7AC, 0xF7AD, 0xF7AE, 0xF7AF, 0xF7B0, 0xF7B1, 0xF7B2, 0xF7B3, 0xF7B4, 	// 0x8339DD39
	0xF7B5, 0xF7B6, 0xF7B7, 0xF7B8, 0xF7B9, 0xF7BA, 0xF7BB, 0xF7BC, 0xF7BD, 0xF7BE, 	// 0x8339DE39
	0xF7BF, 0xF7C0, 0xF7C1, 0xF7C2, 0xF7C3, 0xF7C4, 0xF7C5, 0xF7C6, 0xF7C7, 0xF7C8, 	// 0x8339DF39
	0xF7C9, 0xF7CA, 0xF7CB, 0xF7CC, 0xF7CD, 0xF7CE, 0xF7CF, 0xF7D0, 0xF7D1, 0xF7D2, 	// 0x8339E039
	0xF7D3, 0xF7D4, 0xF7D5, 0xF7D6, 0xF7D7, 0xF7D8, 0xF7D9, 0xF7DA, 0xF7DB, 0xF7DC, 	// 0x8339E139
	0xF7DD, 0xF7DE, 0xF7DF, 0xF7E0, 0xF7E1, 0xF7E2, 0xF7E3, 0xF7E4, 0xF7E5, 0xF7E6, 	// 0x8339E239
	0xF7E7, 0xF7E8, 0xF7E9, 0xF7EA, 0xF7EB, 0xF7EC, 0xF7ED, 0xF7EE, 0xF7EF, 0xF7F0, 	// 0x8339E339
	0xF7F1, 0xF7F2, 0xF7F3, 0xF7F4, 0xF7F5, 0xF7F6, 0xF7F7, 0xF7F8, 0xF7F9, 0xF7FA, 	// 0x8339E439
	0xF7FB, 0xF7FC, 0xF7FD, 0xF7FE, 0xF7FF, 0xF800, 0xF801, 0xF802, 0xF803, 0xF804, 	// 0x8339E539
	0xF805, 0xF806, 0xF807, 0xF808, 0xF809, 0xF80A, 0xF80B, 0xF80C, 0xF80D, 0xF80E, 	// 0x8339E639
	0xF80F, 0xF810, 0xF811, 0xF812, 0xF813, 0xF814, 0xF815, 0xF816, 0xF817, 0xF818, 	// 0x8339E739
	0xF819, 0xF81A, 0xF81B, 0xF81C, 0xF81D, 0xF81E, 0xF81F, 0xF820, 0xF821, 0xF822, 	// 0x8339E839
	0xF823, 0xF824, 0xF825, 0xF826, 0xF827, 0xF828, 0xF829, 0xF82A, 0xF82B, 0xF82C, 	// 0x8339E939
	0xF82D, 0xF82E, 0xF82F, 0xF830, 0xF831, 0xF832, 0xF833, 0xF834, 0xF835, 0xF836, 	// 0x8339EA39
	0xF837, 0xF838, 0xF839, 0xF83A, 0xF83B, 0xF83C, 0xF83D, 0xF83E, 0xF83F, 0xF840, 	// 0x8339EB39
	0xF841, 0xF842, 0xF843, 0xF844, 0xF845, 0xF846, 0xF847, 0xF848, 0xF849, 0xF84A, 	// 0x8339EC39
	0xF84B, 0xF84C, 0xF84D, 0xF84E, 0xF84F, 0xF850, 0xF851, 0xF852, 0xF853, 0xF854, 	// 0x8339ED39
	0xF855, 0xF856, 0xF857, 0xF858, 0xF859, 0xF85A, 0xF85B, 0xF85C, 0xF85D, 0xF85E, 	// 0x8339EE39
	0xF85F, 0xF860, 0xF861, 0xF862, 0xF863, 0xF864, 0xF865, 0xF866, 0xF867, 0xF868, 	// 0x8339EF39
	0xF869, 0xF86A, 0xF86B, 0xF86C, 0xF86D, 0xF86E, 0xF86F, 0xF870, 0xF871, 0xF872, 	// 0x8339F039
	0xF873, 0xF874, 0xF875, 0xF876, 0xF877, 0xF878, 0xF879, 0xF87A, 0xF87B, 0xF87C, 	// 0x8339F139
	0xF87D, 0xF87E, 0xF87F, 0xF880, 0xF881, 0xF882, 0xF883, 0xF884, 0xF885, 0xF886, 	// 0x8339F239
	0xF887, 0xF888, 0xF889, 0xF88A, 0xF88B, 0xF88C, 0xF88D, 0xF88E, 0xF88F, 0xF890, 	// 0x8339F339
	0xF891, 0xF892, 0xF893, 0xF894, 0xF895, 0xF896, 0xF897, 0xF898, 0xF899, 0xF89A, 	// 0x8339F439
	0xF89B, 0xF89C, 0xF89D, 0xF89E, 0xF89F, 0xF8A0, 0xF8A1, 0xF8A2, 0xF8A3, 0xF8A4, 	// 0x8339F539
	0xF8A5, 0xF8A6, 0xF8A7, 0xF8A8, 0xF8A9, 0xF8AA, 0xF8AB, 0xF8AC, 0xF8AD, 0xF8AE, 	// 0x8339F639
	0xF8AF, 0xF8B0, 0xF8B1, 0xF8B2, 0xF8B3, 0xF8B4, 0xF8B5, 0xF8B6, 0xF8B7, 0xF8B8, 	// 0x8339F739
	0xF8B9, 0xF8BA, 0xF8BB, 0xF8BC, 0xF8BD, 0xF8BE, 0xF8BF, 0xF8C0, 0xF8C1, 0xF8C2, 	// 0x8339F839
	0xF8C3, 0xF8C4, 0xF8C5, 0xF8C6, 0xF8C7, 0xF8C8, 0xF8C9, 0xF8CA, 0xF8CB, 0xF8CC, 	// 0x8339F939
	0xF8CD, 0xF8CE, 0xF8CF, 0xF8D0, 0xF8D1, 0xF8D2, 0xF8D3, 0xF8D4, 0xF8D5, 0xF8D6, 	// 0x8339FA39
	0xF8D7, 0xF8D8, 0xF8D9, 0xF8DA, 0xF8DB, 0xF8DC, 0xF8DD, 0xF8DE, 0xF8DF, 0xF8E0, 	// 0x8339FB39
	0xF8E1, 0xF8E2, 0xF8E3, 0xF8E4, 0xF8E5, 0xF8E6, 0xF8E7, 0xF8E8, 0xF8E9, 0xF8EA, 	// 0x8339FC39
	0xF8EB, 0xF8EC, 0xF8ED, 0xF8EE, 0xF8EF, 0xF8F0, 0xF8F1, 0xF8F2, 0xF8F3, 0xF8F4, 	// 0x8339FD39
	0xF8F5, 0xF8F6, 0xF8F7, 0xF8F8, 0xF8F9, 0xF8FA, 0xF8FB, 0xF8FC, 0xF8FD, 0xF8FE, 	// 0x8339FE39
	0xF8FF, 0xF900, 0xF901, 0xF902, 0xF903, 0xF904, 0xF905, 0xF906, 0xF907, 0xF908, 	// 0x84308139
	0xF909, 0xF90A, 0xF90B, 0xF90C, 0xF90D, 0xF90E, 0xF90F, 0xF910, 0xF911, 0xF912, 	// 0x84308239
	0xF913, 0xF914, 0xF915, 0xF916, 0xF917, 0xF918, 0xF919, 0xF91A, 0xF91B, 0xF91C, 	// 0x84308339
	0xF91D, 0xF91E, 0xF91F, 0xF920, 0xF921, 0xF922, 0xF923, 0xF924, 0xF925, 0xF926, 	// 0x84308439
	0xF927, 0xF928, 0xF929, 0xF92A, 0xF92B, 0xF92D, 0xF92E, 0xF92F, 0xF930, 0xF931, 	// 0x84308539
	0xF932, 0xF933, 0xF934, 0xF935, 0xF936, 0xF937, 0xF938, 0xF939, 0xF93A, 0xF93B, 	// 0x84308639
	0xF93C, 0xF93D, 0xF93E, 0xF93F, 0xF940, 0xF941, 0xF942, 0xF943, 0xF944, 0xF945, 	// 0x84308739
	0xF946, 0xF947, 0xF948, 0xF949, 0xF94A, 0xF94B, 0xF94C, 0xF94D, 0xF94E, 0xF94F, 	// 0x84308839
	0xF950, 0xF951, 0xF952, 0xF953, 0xF954, 0xF955, 0xF956, 0xF957, 0xF958, 0xF959, 	// 0x84308939
	0xF95A, 0xF95B, 0xF95C, 0xF95D, 0xF95E, 0xF95F, 0xF960, 0xF961, 0xF962, 0xF963, 	// 0x84308A39
	0xF964, 0xF965, 0xF966, 0xF967, 0xF968, 0xF969, 0xF96A, 0xF96B, 0xF96C, 0xF96D, 	// 0x84308B39
	0xF96E, 0xF96F, 0xF970, 0xF971, 0xF972, 0xF973, 0xF974, 0xF975, 0xF976, 0xF977, 	// 0x84308C39
	0xF978, 0xF97A, 0xF97B, 0xF97C, 0xF97D, 0xF97E, 0xF97F, 0xF980, 0xF981, 0xF982, 	// 0x84308D39
	0xF983, 0xF984, 0xF985, 0xF986, 0xF987, 0xF988, 0xF989, 0xF98A, 0xF98B, 0xF98C, 	// 0x84308E39
	0xF98D, 0xF98E, 0xF98F, 0xF990, 0xF991, 0xF992, 0xF993, 0xF994, 0xF996, 0xF997, 	// 0x84308F39
	0xF998, 0xF999, 0xF99A, 0xF99B, 0xF99C, 0xF99D, 0xF99E, 0xF99F, 0xF9A0, 0xF9A1, 	// 0x84309039
	0xF9A2, 0xF9A3, 0xF9A4, 0xF9A5, 0xF9A6, 0xF9A7, 0xF9A8, 0xF9A9, 0xF9AA, 0xF9AB, 	// 0x84309139
	0xF9AC, 0xF9AD, 0xF9AE, 0xF9AF, 0xF9B0, 0xF9B1, 0xF9B2, 0xF9B3, 0xF9B4, 0xF9B5, 	// 0x84309239
	0xF9B6, 0xF9B7, 0xF9B8, 0xF9B9, 0xF9BA, 0xF9BB, 0xF9BC, 0xF9BD, 0xF9BE, 0xF9BF, 	// 0x84309339
	0xF9C0, 0xF9C1, 0xF9C2, 0xF9C3, 0xF9C4, 0xF9C5, 0xF9C6, 0xF9C7, 0xF9C8, 0xF9C9, 	// 0x84309439
	0xF9CA, 0xF9CB, 0xF9CC, 0xF9CD, 0xF9CE, 0xF9CF, 0xF9D0, 0xF9D1, 0xF9D2, 0xF9D3, 	// 0x84309539
	0xF9D4, 0xF9D5, 0xF9D6, 0xF9D7, 0xF9D8, 0xF9D9, 0xF9DA, 0xF9DB, 0xF9DC, 0xF9DD, 	// 0x84309639
	0xF9DE, 0xF9DF, 0xF9E0, 0xF9E1, 0xF9E2, 0xF9E3, 0xF9E4, 0xF9E5, 0xF9E6, 0xF9E8, 	// 0x84309739
	0xF9E9, 0xF9EA, 0xF9EB, 0xF9EC, 0xF9ED, 0xF9EE, 0xF9EF, 0xF9F0, 0xF9F2, 0xF9F3, 	// 0x84309839
	0xF9F4, 0xF9F5, 0xF9F6, 0xF9F7, 0xF9F8, 0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC, 0xF9FD, 	// 0x84309939
	0xF9FE, 0xF9FF, 0xFA00, 0xFA01, 0xFA02, 0xFA03, 0xFA04, 0xFA05, 0xFA06, 0xFA07, 	// 0x84309A39
	0xFA08, 0xFA09, 0xFA0A, 0xFA0B, 0xFA10, 0xFA12, 0xFA15, 0xFA16, 0xFA17, 0xFA19, 	// 0x84309B39
	0xFA1A, 0xFA1B, 0xFA1C, 0xFA1D, 0xFA1E, 0xFA22, 0xFA25, 0xFA26, 0xFA2A, 0xFA2B, 	// 0x84309C39
	0xFA2C, 0xFA2D, 0xFA2E, 0xFA2F, 0xFA30, 0xFA31, 0xFA32, 0xFA33, 0xFA34, 0xFA35, 	// 0x84309D39
	0xFA36, 0xFA37, 0xFA38, 0xFA39, 0xFA3A, 0xFA3B, 0xFA3C, 0xFA3D, 0xFA3E, 0xFA3F, 	// 0x84309E39
	0xFA40, 0xFA41, 0xFA42, 0xFA43, 0xFA44, 0xFA45, 0xFA46, 0xFA47, 0xFA48, 0xFA49, 	// 0x84309F39
	0xFA4A, 0xFA4B, 0xFA4C, 0xFA4D, 0xFA4E, 0xFA4F, 0xFA50, 0xFA51, 0xFA52, 0xFA53, 	// 0x8430A039
	0xFA54, 0xFA55, 0xFA56, 0xFA57, 0xFA58, 0xFA59, 0xFA5A, 0xFA5B, 0xFA5C, 0xFA5D, 	// 0x8430A139
	0xFA5E, 0xFA5F, 0xFA60, 0xFA61, 0xFA62, 0xFA63, 0xFA64, 0xFA65, 0xFA66, 0xFA67, 	// 0x8430A239
	0xFA68, 0xFA69, 0xFA6A, 0xFA6B, 0xFA6C, 0xFA6D, 0xFA6E, 0xFA6F, 0xFA70, 0xFA71, 	// 0x8430A339
	0xFA72, 0xFA73, 0xFA74, 0xFA75, 0xFA76, 0xFA77, 0xFA78, 0xFA79, 0xFA7A, 0xFA7B, 	// 0x8430A439
	0xFA7C, 0xFA7D, 0xFA7E, 0xFA7F, 0xFA80, 0xFA81, 0xFA82, 0xFA83, 0xFA84, 0xFA85, 	// 0x8430A539
	0xFA86, 0xFA87, 0xFA88, 0xFA89, 0xFA8A, 0xFA8B, 0xFA8C, 0xFA8D, 0xFA8E, 0xFA8F, 	// 0x8430A639
	0xFA90, 0xFA91, 0xFA92, 0xFA93, 0xFA94, 0xFA95, 0xFA96, 0xFA97, 0xFA98, 0xFA99, 	// 0x8430A739
	0xFA9A, 0xFA9B, 0xFA9C, 0xFA9D, 0xFA9E, 0xFA9F, 0xFAA0, 0xFAA1, 0xFAA2, 0xFAA3, 	// 0x8430A839
	0xFAA4, 0xFAA5, 0xFAA6, 0xFAA7, 0xFAA8, 0xFAA9, 0xFAAA, 0xFAAB, 0xFAAC, 0xFAAD, 	// 0x8430A939
	0xFAAE, 0xFAAF, 0xFAB0, 0xFAB1, 0xFAB2, 0xFAB3, 0xFAB4, 0xFAB5, 0xFAB6, 0xFAB7, 	// 0x8430AA39
	0xFAB8, 0xFAB9, 0xFABA, 0xFABB, 0xFABC, 0xFABD, 0xFABE, 0xFABF, 0xFAC0, 0xFAC1, 	// 0x8430AB39
	0xFAC2, 0xFAC3, 0xFAC4, 0xFAC5, 0xFAC6, 0xFAC7, 0xFAC8, 0xFAC9, 0xFACA, 0xFACB, 	// 0x8430AC39
	0xFACC, 0xFACD, 0xFACE, 0xFACF, 0xFAD0, 0xFAD1, 0xFAD2, 0xFAD3, 0xFAD4, 0xFAD5, 	// 0x8430AD39
	0xFAD6, 0xFAD7, 0xFAD8, 0xFAD9, 0xFADA, 0xFADB, 0xFADC, 0xFADD, 0xFADE, 0xFADF, 	// 0x8430AE39
	0xFAE0, 0xFAE1, 0xFAE2, 0xFAE3, 0xFAE4, 0xFAE5, 0xFAE6, 0xFAE7, 0xFAE8, 0xFAE9, 	// 0x8430AF39
	0xFAEA, 0xFAEB, 0xFAEC, 0xFAED, 0xFAEE, 0xFAEF, 0xFAF0, 0xFAF1, 0xFAF2, 0xFAF3, 	// 0x8430B039
	0xFAF4, 0xFAF5, 0xFAF6, 0xFAF7, 0xFAF8, 0xFAF9, 0xFAFA, 0xFAFB, 0xFAFC, 0xFAFD, 	// 0x8430B139
	0xFAFE, 0xFAFF, 0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04, 0xFB05, 0xFB06, 0xFB07, 	// 0x8430B239
	0xFB08, 0xFB09, 0xFB0A, 0xFB0B, 0xFB0C, 0xFB0D, 0xFB0E, 0xFB0F, 0xFB10, 0xFB11, 	// 0x8430B339
	0xFB12, 0xFB13, 0xFB14, 0xFB15, 0xFB16, 0xFB17, 0xFB18, 0xFB19, 0xFB1A, 0xFB1B, 	// 0x8430B439
	0xFB1C, 0xFB1D, 0xFB1E, 0xFB1F, 0xFB20, 0xFB21, 0xFB22, 0xFB23, 0xFB24, 0xFB25, 	// 0x8430B539
	0xFB26, 0xFB27, 0xFB28, 0xFB29, 0xFB2A, 0xFB2B, 0xFB2C, 0xFB2D, 0xFB2E, 0xFB2F, 	// 0x8430B639
	0xFB30, 0xFB31, 0xFB32, 0xFB33, 0xFB34, 0xFB35, 0xFB36, 0xFB37, 0xFB38, 0xFB39, 	// 0x8430B739
	0xFB3A, 0xFB3B, 0xFB3C, 0xFB3D, 0xFB3E, 0xFB3F, 0xFB40, 0xFB41, 0xFB42, 0xFB43, 	// 0x8430B839
	0xFB44, 0xFB45, 0xFB46, 0xFB47, 0xFB48, 0xFB49, 0xFB4A, 0xFB4B, 0xFB4C, 0xFB4D, 	// 0x8430B939
	0xFB4E, 0xFB4F, 0xFB50, 0xFB51, 0xFB52, 0xFB53, 0xFB54, 0xFB55, 0xFB56, 0xFB57, 	// 0x8430BA39
	0xFB58, 0xFB59, 0xFB5A, 0xFB5B, 0xFB5C, 0xFB5D, 0xFB5E, 0xFB5F, 0xFB60, 0xFB61, 	// 0x8430BB39
	0xFB62, 0xFB63, 0xFB64, 0xFB65, 0xFB66, 0xFB67, 0xFB68, 0xFB69, 0xFB6A, 0xFB6B, 	// 0x8430BC39
	0xFB6C, 0xFB6D, 0xFB6E, 0xFB6F, 0xFB70, 0xFB71, 0xFB72, 0xFB73, 0xFB74, 0xFB75, 	// 0x8430BD39
	0xFB76, 0xFB77, 0xFB78, 0xFB79, 0xFB7A, 0xFB7B, 0xFB7C, 0xFB7D, 0xFB7E, 0xFB7F, 	// 0x8430BE39
	0xFB80, 0xFB81, 0xFB82, 0xFB83, 0xFB84, 0xFB85, 0xFB86, 0xFB87, 0xFB88, 0xFB89, 	// 0x8430BF39
	0xFB8A, 0xFB8B, 0xFB8C, 0xFB8D, 0xFB8E, 0xFB8F, 0xFB90, 0xFB91, 0xFB92, 0xFB93, 	// 0x8430C039
	0xFB94, 0xFB95, 0xFB96, 0xFB97, 0xFB98, 0xFB99, 0xFB9A, 0xFB9B, 0xFB9C, 0xFB9D, 	// 0x8430C139
	0xFB9E, 0xFB9F, 0xFBA0, 0xFBA1, 0xFBA2, 0xFBA3, 0xFBA4, 0xFBA5, 0xFBA6, 0xFBA7, 	// 0x8430C239
	0xFBA8, 0xFBA9, 0xFBAA, 0xFBAB, 0xFBAC, 0xFBAD, 0xFBAE, 0xFBAF, 0xFBB0, 0xFBB1, 	// 0x8430C339
	0xFBB2, 0xFBB3, 0xFBB4, 0xFBB5, 0xFBB6, 0xFBB7, 0xFBB8, 0xFBB9, 0xFBBA, 0xFBBB, 	// 0x8430C439
	0xFBBC, 0xFBBD, 0xFBBE, 0xFBBF, 0xFBC0, 0xFBC1, 0xFBC2, 0xFBC3, 0xFBC4, 0xFBC5, 	// 0x8430C539
	0xFBC6, 0xFBC7, 0xFBC8, 0xFBC9, 0xFBCA, 0xFBCB, 0xFBCC, 0xFBCD, 0xFBCE, 0xFBCF, 	// 0x8430C639
	0xFBD0, 0xFBD1, 0xFBD2, 0xFBD3, 0xFBD4, 0xFBD5, 0xFBD6, 0xFBD7, 0xFBD8, 0xFBD9, 	// 0x8430C739
	0xFBDA, 0xFBDB, 0xFBDC, 0xFBDD, 0xFBDE, 0xFBDF, 0xFBE0, 0xFBE1, 0xFBE2, 0xFBE3, 	// 0x8430C839
	0xFBE4, 0xFBE5, 0xFBE6, 0xFBE7, 0xFBE8, 0xFBE9, 0xFBEA, 0xFBEB, 0xFBEC, 0xFBED, 	// 0x8430C939
	0xFBEE, 0xFBEF, 0xFBF0, 0xFBF1, 0xFBF2, 0xFBF3, 0xFBF4, 0xFBF5, 0xFBF6, 0xFBF7, 	// 0x8430CA39
	0xFBF8, 0xFBF9, 0xFBFA, 0xFBFB, 0xFBFC, 0xFBFD, 0xFBFE, 0xFBFF, 0xFC00, 0xFC01, 	// 0x8430CB39
	0xFC02, 0xFC03, 0xFC04, 0xFC05, 0xFC06, 0xFC07, 0xFC08, 0xFC09, 0xFC0A, 0xFC0B, 	// 0x8430CC39
	0xFC0C, 0xFC0D, 0xFC0E, 0xFC0F, 0xFC10, 0xFC11, 0xFC12, 0xFC13, 0xFC14, 0xFC15, 	// 0x8430CD39
	0xFC16, 0xFC17, 0xFC18, 0xFC19, 0xFC1A, 0xFC1B, 0xFC1C, 0xFC1D, 0xFC1E, 0xFC1F, 	// 0x8430CE39
	0xFC20, 0xFC21, 0xFC22, 0xFC23, 0xFC24, 0xFC25, 0xFC26, 0xFC27, 0xFC28, 0xFC29, 	// 0x8430CF39
	0xFC2A, 0xFC2B, 0xFC2C, 0xFC2D, 0xFC2E, 0xFC2F, 0xFC30, 0xFC31, 0xFC32, 0xFC33, 	// 0x8430D039
	0xFC34, 0xFC35, 0xFC36, 0xFC37, 0xFC38, 0xFC39, 0xFC3A, 0xFC3B, 0xFC3C, 0xFC3D, 	// 0x8430D139
	0xFC3E, 0xFC3F, 0xFC40, 0xFC41, 0xFC42, 0xFC43, 0xFC44, 0xFC45, 0xFC46, 0xFC47, 	// 0x8430D239
	0xFC48, 0xFC49, 0xFC4A, 0xFC4B, 0xFC4C, 0xFC4D, 0xFC4E, 0xFC4F, 0xFC50, 0xFC51, 	// 0x8430D339
	0xFC52, 0xFC53, 0xFC54, 0xFC55, 0xFC56, 0xFC57, 0xFC58, 0xFC59, 0xFC5A, 0xFC5B, 	// 0x8430D439
	0xFC5C, 0xFC5D, 0xFC5E, 0xFC5F, 0xFC60, 0xFC61, 0xFC62, 0xFC63, 0xFC64, 0xFC65, 	// 0x8430D539
	0xFC66, 0xFC67, 0xFC68, 0xFC69, 0xFC6A, 0xFC6B, 0xFC6C, 0xFC6D, 0xFC6E, 0xFC6F, 	// 0x8430D639
	0xFC70, 0xFC71, 0xFC72, 0xFC73, 0xFC74, 0xFC75, 0xFC76, 0xFC77, 0xFC78, 0xFC79, 	// 0x8430D739
	0xFC7A, 0xFC7B, 0xFC7C, 0xFC7D, 0xFC7E, 0xFC7F, 0xFC80, 0xFC81, 0xFC82, 0xFC83, 	// 0x8430D839
	0xFC84, 0xFC85, 0xFC86, 0xFC87, 0xFC88, 0xFC89, 0xFC8A, 0xFC8B, 0xFC8C, 0xFC8D, 	// 0x8430D939
	0xFC8E, 0xFC8F, 0xFC90, 0xFC91, 0xFC92, 0xFC93, 0xFC94, 0xFC95, 0xFC96, 0xFC97, 	// 0x8430DA39
	0xFC98, 0xFC99, 0xFC9A, 0xFC9B, 0xFC9C, 0xFC9D, 0xFC9E, 0xFC9F, 0xFCA0, 0xFCA1, 	// 0x8430DB39
	0xFCA2, 0xFCA3, 0xFCA4, 0xFCA5, 0xFCA6, 0xFCA7, 0xFCA8, 0xFCA9, 0xFCAA, 0xFCAB, 	// 0x8430DC39
	0xFCAC, 0xFCAD, 0xFCAE, 0xFCAF, 0xFCB0, 0xFCB1, 0xFCB2, 0xFCB3, 0xFCB4, 0xFCB5, 	// 0x8430DD39
	0xFCB6, 0xFCB7, 0xFCB8, 0xFCB9, 0xFCBA, 0xFCBB, 0xFCBC, 0xFCBD, 0xFCBE, 0xFCBF, 	// 0x8430DE39
	0xFCC0, 0xFCC1, 0xFCC2, 0xFCC3, 0xFCC4, 0xFCC5, 0xFCC6, 0xFCC7, 0xFCC8, 0xFCC9, 	// 0x8430DF39
	0xFCCA, 0xFCCB, 0xFCCC, 0xFCCD, 0xFCCE, 0xFCCF, 0xFCD0, 0xFCD1, 0xFCD2, 0xFCD3, 	// 0x8430E039
	0xFCD4, 0xFCD5, 0xFCD6, 0xFCD7, 0xFCD8, 0xFCD9, 0xFCDA, 0xFCDB, 0xFCDC, 0xFCDD, 	// 0x8430E139
	0xFCDE, 0xFCDF, 0xFCE0, 0xFCE1, 0xFCE2, 0xFCE3, 0xFCE4, 0xFCE5, 0xFCE6, 0xFCE7, 	// 0x8430E239
	0xFCE8, 0xFCE9, 0xFCEA, 0xFCEB, 0xFCEC, 0xFCED, 0xFCEE, 0xFCEF, 0xFCF0, 0xFCF1, 	// 0x8430E339
	0xFCF2, 0xFCF3, 0xFCF4, 0xFCF5, 0xFCF6, 0xFCF7, 0xFCF8, 0xFCF9, 0xFCFA, 0xFCFB, 	// 0x8430E439
	0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF, 0xFD00, 0xFD01, 0xFD02, 0xFD03, 0xFD04, 0xFD05, 	// 0x8430E539
	0xFD06, 0xFD07, 0xFD08, 0xFD09, 0xFD0A, 0xFD0B, 0xFD0C, 0xFD0D, 0xFD0E, 0xFD0F, 	// 0x8430E639
	0xFD10, 0xFD11, 0xFD12, 0xFD13, 0xFD14, 0xFD15, 0xFD16, 0xFD17, 0xFD18, 0xFD19, 	// 0x8430E739
	0xFD1A, 0xFD1B, 0xFD1C, 0xFD1D, 0xFD1E, 0xFD1F, 0xFD20, 0xFD21, 0xFD22, 0xFD23, 	// 0x8430E839
	0xFD24, 0xFD25, 0xFD26, 0xFD27, 0xFD28, 0xFD29, 0xFD2A, 0xFD2B, 0xFD2C, 0xFD2D, 	// 0x8430E939
	0xFD2E, 0xFD2F, 0xFD30, 0xFD31, 0xFD32, 0xFD33, 0xFD34, 0xFD35, 0xFD36, 0xFD37, 	// 0x8430EA39
	0xFD38, 0xFD39, 0xFD3A, 0xFD3B, 0xFD3C, 0xFD3D, 0xFD3E, 0xFD3F, 0xFD40, 0xFD41, 	// 0x8430EB39
	0xFD42, 0xFD43, 0xFD44, 0xFD45, 0xFD46, 0xFD47, 0xFD48, 0xFD49, 0xFD4A, 0xFD4B, 	// 0x8430EC39
	0xFD4C, 0xFD4D, 0xFD4E, 0xFD4F, 0xFD50, 0xFD51, 0xFD52, 0xFD53, 0xFD54, 0xFD55, 	// 0x8430ED39
	0xFD56, 0xFD57, 0xFD58, 0xFD59, 0xFD5A, 0xFD5B, 0xFD5C, 0xFD5D, 0xFD5E, 0xFD5F, 	// 0x8430EE39
	0xFD60, 0xFD61, 0xFD62, 0xFD63, 0xFD64, 0xFD65, 0xFD66, 0xFD67, 0xFD68, 0xFD69, 	// 0x8430EF39
	0xFD6A, 0xFD6B, 0xFD6C, 0xFD6D, 0xFD6E, 0xFD6F, 0xFD70, 0xFD71, 0xFD72, 0xFD73, 	// 0x8430F039
	0xFD74, 0xFD75, 0xFD76, 0xFD77, 0xFD78, 0xFD79, 0xFD7A, 0xFD7B, 0xFD7C, 0xFD7D, 	// 0x8430F139
	0xFD7E, 0xFD7F, 0xFD80, 0xFD81, 0xFD82, 0xFD83, 0xFD84, 0xFD85, 0xFD86, 0xFD87, 	// 0x8430F239
	0xFD88, 0xFD89, 0xFD8A, 0xFD8B, 0xFD8C, 0xFD8D, 0xFD8E, 0xFD8F, 0xFD90, 0xFD91, 	// 0x8430F339
	0xFD92, 0xFD93, 0xFD94, 0xFD95, 0xFD96, 0xFD97, 0xFD98, 0xFD99, 0xFD9A, 0xFD9B, 	// 0x8430F439
	0xFD9C, 0xFD9D, 0xFD9E, 0xFD9F, 0xFDA0, 0xFDA1, 0xFDA2, 0xFDA3, 0xFDA4, 0xFDA5, 	// 0x8430F539
	0xFDA6, 0xFDA7, 0xFDA8, 0xFDA9, 0xFDAA, 0xFDAB, 0xFDAC, 0xFDAD, 0xFDAE, 0xFDAF, 	// 0x8430F639
	0xFDB0, 0xFDB1, 0xFDB2, 0xFDB3, 0xFDB4, 0xFDB5, 0xFDB6, 0xFDB7, 0xFDB8, 0xFDB9, 	// 0x8430F739
	0xFDBA, 0xFDBB, 0xFDBC, 0xFDBD, 0xFDBE, 0xFDBF, 0xFDC0, 0xFDC1, 0xFDC2, 0xFDC3, 	// 0x8430F839
	0xFDC4, 0xFDC5, 0xFDC6, 0xFDC7, 0xFDC8, 0xFDC9, 0xFDCA, 0xFDCB, 0xFDCC, 0xFDCD, 	// 0x8430F939
	0xFDCE, 0xFDCF, 0xFDD0, 0xFDD1, 0xFDD2, 0xFDD3, 0xFDD4, 0xFDD5, 0xFDD6, 0xFDD7, 	// 0x8430FA39
	0xFDD8, 0xFDD9, 0xFDDA, 0xFDDB, 0xFDDC, 0xFDDD, 0xFDDE, 0xFDDF, 0xFDE0, 0xFDE1, 	// 0x8430FB39
	0xFDE2, 0xFDE3, 0xFDE4, 0xFDE5, 0xFDE6, 0xFDE7, 0xFDE8, 0xFDE9, 0xFDEA, 0xFDEB, 	// 0x8430FC39
	0xFDEC, 0xFDED, 0xFDEE, 0xFDEF, 0xFDF0, 0xFDF1, 0xFDF2, 0xFDF3, 0xFDF4, 0xFDF5, 	// 0x8430FD39
	0xFDF6, 0xFDF7, 0xFDF8, 0xFDF9, 0xFDFA, 0xFDFB, 0xFDFC, 0xFDFD, 0xFDFE, 0xFDFF, 	// 0x8430FE39
	0xFE00, 0xFE01, 0xFE02, 0xFE03, 0xFE04, 0xFE05, 0xFE06, 0xFE07, 0xFE08, 0xFE09, 	// 0x84318139
	0xFE0A, 0xFE0B, 0xFE0C, 0xFE0D, 0xFE0E, 0xFE0F, 0xFE10, 0xFE11, 0xFE12, 0xFE13, 	// 0x84318239
	0xFE14, 0xFE15, 0xFE16, 0xFE17, 0xFE18, 0xFE19, 0xFE1A, 0xFE1B, 0xFE1C, 0xFE1D, 	// 0x84318339
	0xFE1E, 0xFE1F, 0xFE20, 0xFE21, 0xFE22, 0xFE23, 0xFE24, 0xFE25, 0xFE26, 0xFE27, 	// 0x84318439
	0xFE28, 0xFE29, 0xFE2A, 0xFE2B, 0xFE2C, 0xFE2D, 0xFE2E, 0xFE2F, 0xFE32, 0xFE45, 	// 0x84318539
	0xFE46, 0xFE47, 0xFE48, 0xFE53, 0xFE58, 0xFE67, 0xFE6C, 0xFE6D, 0xFE6E, 0xFE6F, 	// 0x84318639
	0xFE70, 0xFE71, 0xFE72, 0xFE73, 0xFE74, 0xFE75, 0xFE76, 0xFE77, 0xFE78, 0xFE79, 	// 0x84318739
	0xFE7A, 0xFE7B, 0xFE7C, 0xFE7D, 0xFE7E, 0xFE7F, 0xFE80, 0xFE81, 0xFE82, 0xFE83, 	// 0x84318839
	0xFE84, 0xFE85, 0xFE86, 0xFE87, 0xFE88, 0xFE89, 0xFE8A, 0xFE8B, 0xFE8C, 0xFE8D, 	// 0x84318939
	0xFE8E, 0xFE8F, 0xFE90, 0xFE91, 0xFE92, 0xFE93, 0xFE94, 0xFE95, 0xFE96, 0xFE97, 	// 0x84318A39
	0xFE98, 0xFE99, 0xFE9A, 0xFE9B, 0xFE9C, 0xFE9D, 0xFE9E, 0xFE9F, 0xFEA0, 0xFEA1, 	// 0x84318B39
	0xFEA2, 0xFEA3, 0xFEA4, 0xFEA5, 0xFEA6, 0xFEA7, 0xFEA8, 0xFEA9, 0xFEAA, 0xFEAB, 	// 0x84318C39
	0xFEAC, 0xFEAD, 0xFEAE, 0xFEAF, 0xFEB0, 0xFEB1, 0xFEB2, 0xFEB3, 0xFEB4, 0xFEB5, 	// 0x84318D39
	0xFEB6, 0xFEB7, 0xFEB8, 0xFEB9, 0xFEBA, 0xFEBB, 0xFEBC, 0xFEBD, 0xFEBE, 0xFEBF, 	// 0x84318E39
	0xFEC0, 0xFEC1, 0xFEC2, 0xFEC3, 0xFEC4, 0xFEC5, 0xFEC6, 0xFEC7, 0xFEC8, 0xFEC9, 	// 0x84318F39
	0xFECA, 0xFECB, 0xFECC, 0xFECD, 0xFECE, 0xFECF, 0xFED0, 0xFED1, 0xFED2, 0xFED3, 	// 0x84319039
	0xFED4, 0xFED5, 0xFED6, 0xFED7, 0xFED8, 0xFED9, 0xFEDA, 0xFEDB, 0xFEDC, 0xFEDD, 	// 0x84319139
	0xFEDE, 0xFEDF, 0xFEE0, 0xFEE1, 0xFEE2, 0xFEE3, 0xFEE4, 0xFEE5, 0xFEE6, 0xFEE7, 	// 0x84319239
	0xFEE8, 0xFEE9, 0xFEEA, 0xFEEB, 0xFEEC, 0xFEED, 0xFEEE, 0xFEEF, 0xFEF0, 0xFEF1, 	// 0x84319339
	0xFEF2, 0xFEF3, 0xFEF4, 0xFEF5, 0xFEF6, 0xFEF7, 0xFEF8, 0xFEF9, 0xFEFA, 0xFEFB, 	// 0x84319439
	0xFEFC, 0xFEFD, 0xFEFE, 0xFEFF, 0xFF00, 0xFF5F, 0xFF60, 0xFF61, 0xFF62, 0xFF63, 	// 0x84319539
	0xFF64, 0xFF65, 0xFF66, 0xFF67, 0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C, 0xFF6D, 	// 0x84319639
	0xFF6E, 0xFF6F, 0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74, 0xFF75, 0xFF76, 0xFF77, 	// 0x84319739
	0xFF78, 0xFF79, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D, 0xFF7E, 0xFF7F, 0xFF80, 0xFF81, 	// 0x84319839
	0xFF82, 0xFF83, 0xFF84, 0xFF85, 0xFF86, 0xFF87, 0xFF88, 0xFF89, 0xFF8A, 0xFF8B, 	// 0x84319939
	0xFF8C, 0xFF8D, 0xFF8E, 0xFF8F, 0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF94, 0xFF95, 	// 0x84319A39
	0xFF96, 0xFF97, 0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C, 0xFF9D, 0xFF9E, 0xFF9F, 	// 0x84319B39
	0xFFA0, 0xFFA1, 0xFFA2, 0xFFA3, 0xFFA4, 0xFFA5, 0xFFA6, 0xFFA7, 0xFFA8, 0xFFA9, 	// 0x84319C39
	0xFFAA, 0xFFAB, 0xFFAC, 0xFFAD, 0xFFAE, 0xFFAF, 0xFFB0, 0xFFB1, 0xFFB2, 0xFFB3, 	// 0x84319D39
	0xFFB4, 0xFFB5, 0xFFB6, 0xFFB7, 0xFFB8, 0xFFB9, 0xFFBA, 0xFFBB, 0xFFBC, 0xFFBD, 	// 0x84319E39
	0xFFBE, 0xFFBF, 0xFFC0, 0xFFC1, 0xFFC2, 0xFFC3, 0xFFC4, 0xFFC5, 0xFFC6, 0xFFC7, 	// 0x84319F39
	0xFFC8, 0xFFC9, 0xFFCA, 0xFFCB, 0xFFCC, 0xFFCD, 0xFFCE, 0xFFCF, 0xFFD0, 0xFFD1, 	// 0x8431A039
	0xFFD2, 0xFFD3, 0xFFD4, 0xFFD5, 0xFFD6, 0xFFD7, 0xFFD8, 0xFFD9, 0xFFDA, 0xFFDB, 	// 0x8431A139
	0xFFDC, 0xFFDD, 0xFFDE, 0xFFDF, 0xFFE6, 0xFFE7, 0xFFE8, 0xFFE9, 0xFFEA, 0xFFEB, 	// 0x8431A239
	0xFFEC, 0xFFED, 0xFFEE, 0xFFEF, 0xFFF0, 0xFFF1, 0xFFF2, 0xFFF3, 0xFFF4, 0xFFF5, 	// 0x8431A339
	0xFFF6, 0xFFF7, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFF, 	// 0x8431A439
	};
// total byte count = 78840
