// Copyright (c) 1996-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// e32test\math\t_real64.h
// Generated by \E32\TMATH\T_GEN.MAK for checking results against MSDEV
// 
//


#if defined __DOUBLE_WORDS_SWAPPED__

// for ARM (big-endian doubles)

const TInt64 addArray[] = 
	{
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0x0,0x0),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0xffffffff,0xffdfffff),
	TInt64(0x0,0x80200000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x200000),
	TInt64(0x0,0x280000),
	TInt64(0x0,0x100000),
	TInt64(0x0,0x80100000),
	TInt64(0x0,0x0),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0x0,0x0),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x40080000),
	TInt64(0x0,0x40100000),
	TInt64(0x0,0x3cb00000),
	TInt64(0x0,0xc0100000),
	TInt64(0x898b2e9d,0xbfff87cd),
	TInt64(0x9d3458cd,0x3fae0c9d),
	TInt64(0x4b00dfd,0x622265ce),
	TInt64(0x4b00dfd,0x623265ce),
	TInt64(0x4b00f51,0x622265ce),
	TInt64(0x488db800,0x5f754023),
	TInt64(0x0,0x0),
	TInt64(0x488db800,0xdf754023),
	TInt64(0x488db15a,0xdf654023),
	TInt64(0x0,0x0),
	TInt64(0xc0c33ec0,0xdcca98a9),
	TInt64(0x0,0x41778ce8),
	TInt64(0x6b5,0x41678ce8),
	TInt64(0x0,0x0),
	TInt64(0xf7411773,0xbecad4c4),
	TInt64(0x43f18d65,0x3c04a131),
	TInt64(0x4b00dfd,0x622265ce),
	TInt64(0x4b00dfd,0x623265ce),
	TInt64(0x4b00e1f,0x622265ce),
	TInt64(0x3a0af99a,0x5f41001c),
	TInt64(0x0,0x0),
	TInt64(0x3a0af99a,0xdf41001c),
	TInt64(0x3a0af98c,0xdf31001c),
	TInt64(0x0,0x0),
	TInt64(0x2dd6445b,0xdc2b3c12),
	TInt64(0x0,0x41778ce8),
	TInt64(0xac,0x41678ce8),
	TInt64(0xf900e097,0x3ea57703),
	TInt64(0xf900e0b1,0x3e957703),
	TInt64(0x23c48c06,0x3b9a67ed),
	TInt64(0x28c60e18,0xf5d6fc),
	TInt64(0x0,0x0),
	};

const TInt64 subArray[] = 
	{
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffdfffff),
	TInt64(0x0,0x0),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0x0),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xddf6c814,0x74517571),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0x0,0x0),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0x0),
	TInt64(0x0,0x200000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x80100000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x80200000),
	TInt64(0x0,0x100000),
	TInt64(0x0,0x280000),
	TInt64(0x0,0x80100000),
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0xc00c0000),
	TInt64(0x0,0x40040000),
	TInt64(0x0,0xbcb00000),
	TInt64(0x0,0x40100000),
	TInt64(0x0,0x3cb00000),
	TInt64(0x3b3a68b2,0xc0003c19),
	TInt64(0x0,0x0),
	TInt64(0x4b00dfd,0xe22265ce),
	TInt64(0x0,0x0),
	TInt64(0x4b00ca9,0x622265ce),
	TInt64(0x0,0x0),
	TInt64(0x488db800,0x5f754023),
	TInt64(0x0,0x0),
	TInt64(0x488dbea6,0xdf654023),
	TInt64(0xc0c33ec0,0x5cda98a9),
	TInt64(0xc0c33ec0,0xdcca98a9),
	TInt64(0x0,0x0),
	TInt64(0xfffff94b,0x41678ce7),
	TInt64(0xf74118bd,0x3edad4c4),
	TInt64(0xf7411a07,0xbecad4c4),
	TInt64(0x43f18d65,0x3c04a131),
	TInt64(0x4b00dfd,0xe22265ce),
	TInt64(0x0,0x0),
	TInt64(0x4b00ddb,0x622265ce),
	TInt64(0x0,0x0),
	TInt64(0x3a0af99a,0x5f41001c),
	TInt64(0x0,0x0),
	TInt64(0x3a0af9a8,0xdf31001c),
	TInt64(0x2dd6445b,0x5c3b3c12),
	TInt64(0x2dd6445b,0xdc2b3c12),
	TInt64(0x0,0x0),
	TInt64(0xffffff54,0x41678ce7),
	TInt64(0x0,0x0),
	TInt64(0xf900e07d,0x3e957703),
	TInt64(0x23c48c06,0x3b9a67ed),
	TInt64(0x28c60e18,0xf5d6fc),
	TInt64(0x0,0x0),
	};

const TInt64 multArray[] = 
	{
	TInt64(0x4,0x46720000),
	TInt64(0x4,0x43300000),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x0),
	TInt64(0x0,0x0),
	TInt64(0xffb38c0a,0x7fefffff),
	TInt64(0xffb38c0a,0xffefffff),
	TInt64(0xffb38c0a,0x7fefffff),
	TInt64(0xffd9c605,0xbfffffff),
	TInt64(0x0,0x100000),
	TInt64(0x0,0x80100000),
	TInt64(0x0,0x100000),
	TInt64(0x0,0xa0000000),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0x0,0x0),
	TInt64(0x0,0x0),
	TInt64(0x0,0x100000),
	TInt64(0x0,0x40120000),
	TInt64(0x0,0x320000),
	TInt64(0xffffffff,0x400fffff),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xfffffffd,0x3fefffff),
	TInt64(0xfffffffd,0xbfefffff),
	TInt64(0xfffffffd,0x3fefffff),
	TInt64(0x9d3458ca,0xbf9e0c9d),
	TInt64(0x80005f59,0x3f4c37ac),
	TInt64(0x5d3ac136,0x43ac5412),
	TInt64(0xceceb438,0x480c7094),
	TInt64(0xceceb438,0xc80c7094),
	TInt64(0xceceb438,0x480c7094),
	TInt64(0x69817e7c,0x43fddbc6),
	TInt64(0x3ab7b376,0x3fef5916),
	TInt64(0x9aabbdd8,0x7b35d0a8),
	TInt64(0x10e23793,0x40257be8),
	TInt64(0xda9279fc,0x8b04b4d6),
	TInt64(0x46ad2194,0x4031b439),
	TInt64(0xcf18ad70,0xe411ece5),
	TInt64(0x3513ae1c,0xc01bc198),
	TInt64(0xd4eef683,0x17392ed6),
	TInt64(0xdc750da6,0x7f997240),
	TInt64(0x76c75fc4,0x7d85dbb3),
	TInt64(0x9b05ea71,0x891898),
	TInt64(0x4a56452d,0x27ce1ab1),
	TInt64(0x4b9a4d4b,0x7fb7e4bc),
	TInt64(0x645f1052,0x3351417a),
	TInt64(0xa66ddc8c,0xa7908c),
	TInt64(0x0,0x0),
	TInt64(0x0,0x80000000),
	TInt64(0x0,0x80000000),
	TInt64(0x0,0x0),
	};

const TInt64 divArray[] = 
	{
	TInt64(0x0,0x0),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0x3ff00000),
	TInt64(0xffffffff,0xffcfffff),
	TInt64(0x1,0x100000),
	TInt64(0x0,0x0),
	TInt64(0x0,0xffd00000),
	TInt64(0x0,0x80100000),
	TInt64(0x0,0x7fd00000),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x3ff00000),
	TInt64(0x2,0x3ff00000),
	TInt64(0xfffffffd,0xbfefffff),
	TInt64(0x2,0x3ff00000),
	TInt64(0xfffffffd,0xbfefffff),
	TInt64(0x0,0xbff00000),
	TInt64(0xc9c81497,0xc04109e6),
	TInt64(0x0,0x3ff00000),
	TInt64(0xdd4164a6,0xfcc6538c),
	TInt64(0xff97a694,0x3fefffff),
	TInt64(0x342cb6,0xbff00000),
	TInt64(0xff97a694,0x3fefffff),
	TInt64(0xef8b67e1,0x82c5c1e1),
	TInt64(0x0,0x3ff00000),
	TInt64(0x7f5747dc,0xbbe0cc54),
	TInt64(0x0,0x3ff00000),
	TInt64(0x8808b024,0x465f8def),
	TInt64(0xfffff5e2,0x3fefffff),
	TInt64(0x8a24be97,0xb271e18f),
	TInt64(0x0,0x3ff00000),
	TInt64(0xe48e052f,0x2b2bff2e),
	TInt64(0xca239029,0x7f76c8e5),
	TInt64(0xba8b1922,0x9a208c91),
	TInt64(0xf19d6058,0x4bf97d4d),
	TInt64(0xa556e1ce,0xb3e41633),
	TInt64(0xf19d6058,0x4bf97d4d),
	TInt64(0xeae7b308,0x29c2c1af),
	TInt64(0x8b9f52f4,0xe052a556),
	TInt64(0x8f1c67e4,0x30c2a203),
	TInt64(0xd325f502,0x79b5f1),
	TInt64(0x4ea6cda8,0x7d511b1b),
	TInt64(0x37a87d6b,0x7f8a11cc),
	TInt64(0x71c1db82,0x278a6451),
	TInt64(0xd4ae4aa,0x687151),
	TInt64(0x4def66fb,0x330e4172),
	TInt64(0xb1023059,0x7f78c8a3),
	TInt64(0x0,0x80000000),
	};

const TInt64 unaryArray[] = 
	{
	TInt64(0x0,0x80000000),
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0x3ff00000),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0x0,0x80100000),
	TInt64(0x0,0x100000),
	};

const TInt64 preIncArray1[] = 
	{
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x40000000),
	TInt64(0x0,0x40080000),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x3ff00000),
	TInt64(0xe37d420f,0xc09a1f07),
	TInt64(0xb9a6a077,0x40993748),
	TInt64(0xa2620008,0x4309945c),
	TInt64(0xa261fff8,0xc309945c),
	TInt64(0x195,0x3ff00000),
	TInt64(0xfffffcd5,0x3fefffff),
	TInt64(0x5edc9000,0x4373fbe8),
	TInt64(0x5edc9000,0xc373fbe8),
	TInt64(0x4,0x3ff00000),
	TInt64(0xfffffff8,0x3fefffff),
	};

const TInt64 preIncArray2[] = 
	{
	TInt64(0x0,0x40000000),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x40080000),
	TInt64(0x0,0x40100000),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0x40000000),
	TInt64(0x0,0x40000000),
	TInt64(0xe37d420f,0xc09a1b07),
	TInt64(0xb9a6a077,0x40993b48),
	TInt64(0xa2620010,0x4309945c),
	TInt64(0xa261fff0,0xc309945c),
	TInt64(0xca,0x40000000),
	TInt64(0xfffffe6a,0x3fffffff),
	TInt64(0x5edc9000,0x4373fbe8),
	TInt64(0x5edc9000,0xc373fbe8),
	TInt64(0x2,0x40000000),
	TInt64(0xfffffffc,0x3fffffff),
	};

const TInt64 preDecArray1[] = 
	{
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0xc0000000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x3ff00000),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0xbff00000),
	TInt64(0xe37d420f,0xc09a2707),
	TInt64(0xb9a6a077,0x40992f48),
	TInt64(0xa261fff8,0x4309945c),
	TInt64(0xa2620008,0xc309945c),
	TInt64(0xfffffcd5,0xbfefffff),
	TInt64(0x195,0xbff00000),
	TInt64(0x5edc9000,0x4373fbe8),
	TInt64(0x5edc9000,0xc373fbe8),
	TInt64(0xfffffff8,0xbfefffff),
	TInt64(0x4,0xbff00000),
	};
	
const TInt64 preDecArray2[] = 
	{
	TInt64(0x0,0xc0000000),
	TInt64(0x0,0xc0080000),
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0x0),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0xc0000000),
	TInt64(0x0,0xc0000000),
	TInt64(0xe37d420f,0xc09a2b07),
	TInt64(0xb9a6a077,0x40992b48),
	TInt64(0xa261fff0,0x4309945c),
	TInt64(0xa2620010,0xc309945c),
	TInt64(0xfffffe6a,0xbfffffff),
	TInt64(0xca,0xc0000000),
	TInt64(0x5edc9000,0x4373fbe8),
	TInt64(0x5edc9000,0xc373fbe8),
	TInt64(0xfffffffc,0xbfffffff),
	TInt64(0x2,0xc0000000),
	};

const TInt64 postIncArray1[] = 
	{
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x40000000),
	TInt64(0x0,0x40080000),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x3ff00000),
	TInt64(0xe37d420f,0xc09a1f07),
	TInt64(0xb9a6a077,0x40993748),
	TInt64(0xa2620008,0x4309945c),
	TInt64(0xa261fff8,0xc309945c),
	TInt64(0x195,0x3ff00000),
	TInt64(0xfffffcd5,0x3fefffff),
	TInt64(0x5edc9000,0x4373fbe8),
	TInt64(0x5edc9000,0xc373fbe8),
	TInt64(0x4,0x3ff00000),
	TInt64(0xfffffff8,0x3fefffff),
	};

const TInt64 postIncArray2[] = 
	{
	TInt64(0x0,0x40000000),
	TInt64(0x0,0x3ff00000),
	TInt64(0x0,0x40080000),
	TInt64(0x0,0x40100000),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0x40000000),
	TInt64(0x0,0x40000000),
	TInt64(0xe37d420f,0xc09a1b07),
	TInt64(0xb9a6a077,0x40993b48),
	TInt64(0xa2620010,0x4309945c),
	TInt64(0xa261fff0,0xc309945c),
	TInt64(0xca,0x40000000),
	TInt64(0xfffffe6a,0x3fffffff),
	TInt64(0x5edc9000,0x4373fbe8),
	TInt64(0x5edc9000,0xc373fbe8),
	TInt64(0x2,0x40000000),
	TInt64(0xfffffffc,0x3fffffff),
	};

const TInt64 postDecArray1[] = 
	{
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0xc0000000),
	TInt64(0x0,0x0),
	TInt64(0x0,0x3ff00000),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0xbff00000),
	TInt64(0xe37d420f,0xc09a2707),
	TInt64(0xb9a6a077,0x40992f48),
	TInt64(0xa261fff8,0x4309945c),
	TInt64(0xa2620008,0xc309945c),
	TInt64(0xfffffcd5,0xbfefffff),
	TInt64(0x195,0xbff00000),
	TInt64(0x5edc9000,0x4373fbe8),
	TInt64(0x5edc9000,0xc373fbe8),
	TInt64(0xfffffff8,0xbfefffff),
	TInt64(0x4,0xbff00000),
	};

const TInt64 postDecArray2[] = 
	{
	TInt64(0x0,0xc0000000),
	TInt64(0x0,0xc0080000),
	TInt64(0x0,0xbff00000),
	TInt64(0x0,0x0),
	TInt64(0xffffffff,0x7fefffff),
	TInt64(0xffffffff,0xffefffff),
	TInt64(0x0,0xc0000000),
	TInt64(0x0,0xc0000000),
	TInt64(0xe37d420f,0xc09a2b07),
	TInt64(0xb9a6a077,0x40992b48),
	TInt64(0xa261fff0,0x4309945c),
	TInt64(0xa2620010,0xc309945c),
	TInt64(0xfffffe6a,0xbfffffff),
	TInt64(0xca,0xc0000000),
	TInt64(0x5edc9000,0x4373fbe8),
	TInt64(0x5edc9000,0xc373fbe8),
	TInt64(0xfffffffc,0xbfffffff),
	TInt64(0x2,0xc0000000),
	};

#else	// not #if defined __DOUBLE_WORDS_SWAPPED__

// for WINS and X86 (little-endian doubles)

const TInt64 addArray[] = 
	{
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0x0,0x0),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0xffdfffff,0xffffffff),
	TInt64(0x80200000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x200000,0x0),
	TInt64(0x280000,0x0),
	TInt64(0x100000,0x0),
	TInt64(0x80100000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0x0,0x0),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0x3ff00000,0x0),
	TInt64(0x40080000,0x0),
	TInt64(0x40100000,0x0),
	TInt64(0x3cb00000,0x0),
	TInt64(0xc0100000,0x0),
	TInt64(0xbfff87cd,0x898b2e9d),
	TInt64(0x3fae0c9d,0x9d3458cd),
	TInt64(0x622265ce,0x4b00dfd),
	TInt64(0x623265ce,0x4b00dfd),
	TInt64(0x622265ce,0x4b00f51),
	TInt64(0x5f754023,0x488db800),
	TInt64(0x0,0x0),
	TInt64(0xdf754023,0x488db800),
	TInt64(0xdf654023,0x488db15a),
	TInt64(0x0,0x0),
	TInt64(0xdcca98a9,0xc0c33ec0),
	TInt64(0x41778ce8,0x0),
	TInt64(0x41678ce8,0x6b5),
	TInt64(0x0,0x0),
	TInt64(0xbecad4c4,0xf7411773),
	TInt64(0x3c04a131,0x43f18d65),
	TInt64(0x622265ce,0x4b00dfd),
	TInt64(0x623265ce,0x4b00dfd),
	TInt64(0x622265ce,0x4b00e1f),
	TInt64(0x5f41001c,0x3a0af99a),
	TInt64(0x0,0x0),
	TInt64(0xdf41001c,0x3a0af99a),
	TInt64(0xdf31001c,0x3a0af98c),
	TInt64(0x0,0x0),
	TInt64(0xdc2b3c12,0x2dd6445b),
	TInt64(0x41778ce8,0x0),
	TInt64(0x41678ce8,0xac),
	TInt64(0x3ea57703,0xf900e097),
	TInt64(0x3e957703,0xf900e0b1),
	TInt64(0x3b9a67ed,0x23c48c06),
	TInt64(0xf5d6fc,0x28c60e18),
	TInt64(0x0,0x0),
	};

const TInt64 subArray[] = 
	{
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffdfffff,0xffffffff),
	TInt64(0x0,0x0),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0x0,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0x74517571,0xddf6c814),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0x0,0x0),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0x0,0x0),
	TInt64(0x200000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x80100000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x80200000,0x0),
	TInt64(0x100000,0x0),
	TInt64(0x280000,0x0),
	TInt64(0x80100000,0x0),
	TInt64(0xbff00000,0x0),
	TInt64(0xc00c0000,0x0),
	TInt64(0x40040000,0x0),
	TInt64(0xbcb00000,0x0),
	TInt64(0x40100000,0x0),
	TInt64(0x3cb00000,0x0),
	TInt64(0xc0003c19,0x3b3a68b2),
	TInt64(0x0,0x0),
	TInt64(0xe22265ce,0x4b00dfd),
	TInt64(0x0,0x0),
	TInt64(0x622265ce,0x4b00ca9),
	TInt64(0x0,0x0),
	TInt64(0x5f754023,0x488db800),
	TInt64(0x0,0x0),
	TInt64(0xdf654023,0x488dbea6),
	TInt64(0x5cda98a9,0xc0c33ec0),
	TInt64(0xdcca98a9,0xc0c33ec0),
	TInt64(0x0,0x0),
	TInt64(0x41678ce7,0xfffff94b),
	TInt64(0x3edad4c4,0xf74118bd),
	TInt64(0xbecad4c4,0xf7411a07),
	TInt64(0x3c04a131,0x43f18d65),
	TInt64(0xe22265ce,0x4b00dfd),
	TInt64(0x0,0x0),
	TInt64(0x622265ce,0x4b00ddb),
	TInt64(0x0,0x0),
	TInt64(0x5f41001c,0x3a0af99a),
	TInt64(0x0,0x0),
	TInt64(0xdf31001c,0x3a0af9a8),
	TInt64(0x5c3b3c12,0x2dd6445b),
	TInt64(0xdc2b3c12,0x2dd6445b),
	TInt64(0x0,0x0),
	TInt64(0x41678ce7,0xffffff54),
	TInt64(0x0,0x0),
	TInt64(0x3e957703,0xf900e07d),
	TInt64(0x3b9a67ed,0x23c48c06),
	TInt64(0xf5d6fc,0x28c60e18),
	TInt64(0x0,0x0),
	};

const TInt64 multArray[] = 
	{
	TInt64(0x46720000,0x4),
	TInt64(0x43300000,0x4),
	TInt64(0x3ff00000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x0,0x0),
	TInt64(0x0,0x0),
	TInt64(0x7fefffff,0xffb38c0a),
	TInt64(0xffefffff,0xffb38c0a),
	TInt64(0x7fefffff,0xffb38c0a),
	TInt64(0xbfffffff,0xffd9c605),
	TInt64(0x100000,0x0),
	TInt64(0x80100000,0x0),
	TInt64(0x100000,0x0),
	TInt64(0xa0000000,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0x0,0x0),
	TInt64(0x0,0x0),
	TInt64(0x100000,0x0),
	TInt64(0x40120000,0x0),
	TInt64(0x320000,0x0),
	TInt64(0x400fffff,0xffffffff),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0x3fefffff,0xfffffffd),
	TInt64(0xbfefffff,0xfffffffd),
	TInt64(0x3fefffff,0xfffffffd),
	TInt64(0xbf9e0c9d,0x9d3458ca),
	TInt64(0x3f4c37ac,0x80005f59),
	TInt64(0x43ac5412,0x5d3ac136),
	TInt64(0x480c7094,0xceceb438),
	TInt64(0xc80c7094,0xceceb438),
	TInt64(0x480c7094,0xceceb438),
	TInt64(0x43fddbc6,0x69817e7c),
	TInt64(0x3fef5916,0x3ab7b376),
	TInt64(0x7b35d0a8,0x9aabbdd8),
	TInt64(0x40257be8,0x10e23793),
	TInt64(0x8b04b4d6,0xda9279fc),
	TInt64(0x4031b439,0x46ad2194),
	TInt64(0xe411ece5,0xcf18ad70),
	TInt64(0xc01bc198,0x3513ae1c),
	TInt64(0x17392ed6,0xd4eef683),
	TInt64(0x7f997240,0xdc750da6),
	TInt64(0x7d85dbb3,0x76c75fc4),
	TInt64(0x891898,0x9b05ea71),
	TInt64(0x27ce1ab1,0x4a56452d),
	TInt64(0x7fb7e4bc,0x4b9a4d4b),
	TInt64(0x3351417a,0x645f1052),
	TInt64(0xa7908c,0xa66ddc8c),
	TInt64(0x0,0x0),
	TInt64(0x80000000,0x0),
	TInt64(0x80000000,0x0),
	TInt64(0x0,0x0),
	};

const TInt64 divArray[] = 
	{
	TInt64(0x0,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0xbff00000,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0xffcfffff,0xffffffff),
	TInt64(0x100000,0x1),
	TInt64(0x0,0x0),
	TInt64(0xffd00000,0x0),
	TInt64(0x80100000,0x0),
	TInt64(0x7fd00000,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0xbff00000,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0x3ff00000,0x2),
	TInt64(0xbfefffff,0xfffffffd),
	TInt64(0x3ff00000,0x2),
	TInt64(0xbfefffff,0xfffffffd),
	TInt64(0xbff00000,0x0),
	TInt64(0xc04109e6,0xc9c81497),
	TInt64(0x3ff00000,0x0),
	TInt64(0xfcc6538c,0xdd4164a6),
	TInt64(0x3fefffff,0xff97a694),
	TInt64(0xbff00000,0x342cb6),
	TInt64(0x3fefffff,0xff97a694),
	TInt64(0x82c5c1e1,0xef8b67e1),
	TInt64(0x3ff00000,0x0),
	TInt64(0xbbe0cc54,0x7f5747dc),
	TInt64(0x3ff00000,0x0),
	TInt64(0x465f8def,0x8808b024),
	TInt64(0x3fefffff,0xfffff5e2),
	TInt64(0xb271e18f,0x8a24be97),
	TInt64(0x3ff00000,0x0),
	TInt64(0x2b2bff2e,0xe48e052f),
	TInt64(0x7f76c8e5,0xca239029),
	TInt64(0x9a208c91,0xba8b1922),
	TInt64(0x4bf97d4d,0xf19d6058),
	TInt64(0xb3e41633,0xa556e1ce),
	TInt64(0x4bf97d4d,0xf19d6058),
	TInt64(0x29c2c1af,0xeae7b308),
	TInt64(0xe052a556,0x8b9f52f4),
	TInt64(0x30c2a203,0x8f1c67e4),
	TInt64(0x79b5f1,0xd325f502),
	TInt64(0x7d511b1b,0x4ea6cda8),
	TInt64(0x7f8a11cc,0x37a87d6b),
	TInt64(0x278a6451,0x71c1db82),
	TInt64(0x687151,0xd4ae4aa),
	TInt64(0x330e4172,0x4def66fb),
	TInt64(0x7f78c8a3,0xb1023059),
	TInt64(0x80000000,0x0),
	};

const TInt64 unaryArray[] = 
	{
	TInt64(0x80000000,0x0),
	TInt64(0xbff00000,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0x80100000,0x0),
	TInt64(0x100000,0x0),
	};

const TInt64 preIncArray1[] = 
	{
	TInt64(0x3ff00000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x40000000,0x0),
	TInt64(0x40080000,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0x3ff00000,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0xc09a1f07,0xe37d420f),
	TInt64(0x40993748,0xb9a6a077),
	TInt64(0x4309945c,0xa2620008),
	TInt64(0xc309945c,0xa261fff8),
	TInt64(0x3ff00000,0x195),
	TInt64(0x3fefffff,0xfffffcd5),
	TInt64(0x4373fbe8,0x5edc9000),
	TInt64(0xc373fbe8,0x5edc9000),
	TInt64(0x3ff00000,0x4),
	TInt64(0x3fefffff,0xfffffff8),
	};

const TInt64 preIncArray2[] = 
	{
	TInt64(0x40000000,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0x40080000,0x0),
	TInt64(0x40100000,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0x40000000,0x0),
	TInt64(0x40000000,0x0),
	TInt64(0xc09a1b07,0xe37d420f),
	TInt64(0x40993b48,0xb9a6a077),
	TInt64(0x4309945c,0xa2620010),
	TInt64(0xc309945c,0xa261fff0),
	TInt64(0x40000000,0xca),
	TInt64(0x3fffffff,0xfffffe6a),
	TInt64(0x4373fbe8,0x5edc9000),
	TInt64(0xc373fbe8,0x5edc9000),
	TInt64(0x40000000,0x2),
	TInt64(0x3fffffff,0xfffffffc),
	};

const TInt64 preDecArray1[] = 
	{
	TInt64(0xbff00000,0x0),
	TInt64(0xc0000000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0xbff00000,0x0),
	TInt64(0xbff00000,0x0),
	TInt64(0xc09a2707,0xe37d420f),
	TInt64(0x40992f48,0xb9a6a077),
	TInt64(0x4309945c,0xa261fff8),
	TInt64(0xc309945c,0xa2620008),
	TInt64(0xbfefffff,0xfffffcd5),
	TInt64(0xbff00000,0x195),
	TInt64(0x4373fbe8,0x5edc9000),
	TInt64(0xc373fbe8,0x5edc9000),
	TInt64(0xbfefffff,0xfffffff8),
	TInt64(0xbff00000,0x4),
	};

const TInt64 preDecArray2[] = 
	{
	TInt64(0xc0000000,0x0),
	TInt64(0xc0080000,0x0),
	TInt64(0xbff00000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0xc0000000,0x0),
	TInt64(0xc0000000,0x0),
	TInt64(0xc09a2b07,0xe37d420f),
	TInt64(0x40992b48,0xb9a6a077),
	TInt64(0x4309945c,0xa261fff0),
	TInt64(0xc309945c,0xa2620010),
	TInt64(0xbfffffff,0xfffffe6a),
	TInt64(0xc0000000,0xca),
	TInt64(0x4373fbe8,0x5edc9000),
	TInt64(0xc373fbe8,0x5edc9000),
	TInt64(0xbfffffff,0xfffffffc),
	TInt64(0xc0000000,0x2),
	};

const TInt64 postIncArray1[] = 
	{
	TInt64(0x3ff00000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x40000000,0x0),
	TInt64(0x40080000,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0x3ff00000,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0xc09a1f07,0xe37d420f),
	TInt64(0x40993748,0xb9a6a077),
	TInt64(0x4309945c,0xa2620008),
	TInt64(0xc309945c,0xa261fff8),
	TInt64(0x3ff00000,0x195),
	TInt64(0x3fefffff,0xfffffcd5),
	TInt64(0x4373fbe8,0x5edc9000),
	TInt64(0xc373fbe8,0x5edc9000),
	TInt64(0x3ff00000,0x4),
	TInt64(0x3fefffff,0xfffffff8),
	};

const TInt64 postIncArray2[] = 
	{
	TInt64(0x40000000,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0x40080000,0x0),
	TInt64(0x40100000,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0x40000000,0x0),
	TInt64(0x40000000,0x0),
	TInt64(0xc09a1b07,0xe37d420f),
	TInt64(0x40993b48,0xb9a6a077),
	TInt64(0x4309945c,0xa2620010),
	TInt64(0xc309945c,0xa261fff0),
	TInt64(0x40000000,0xca),
	TInt64(0x3fffffff,0xfffffe6a),
	TInt64(0x4373fbe8,0x5edc9000),
	TInt64(0xc373fbe8,0x5edc9000),
	TInt64(0x40000000,0x2),
	TInt64(0x3fffffff,0xfffffffc),
	};

const TInt64 postDecArray1[] = 
	{
	TInt64(0xbff00000,0x0),
	TInt64(0xc0000000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x3ff00000,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0xbff00000,0x0),
	TInt64(0xbff00000,0x0),
	TInt64(0xc09a2707,0xe37d420f),
	TInt64(0x40992f48,0xb9a6a077),
	TInt64(0x4309945c,0xa261fff8),
	TInt64(0xc309945c,0xa2620008),
	TInt64(0xbfefffff,0xfffffcd5),
	TInt64(0xbff00000,0x195),
	TInt64(0x4373fbe8,0x5edc9000),
	TInt64(0xc373fbe8,0x5edc9000),
	TInt64(0xbfefffff,0xfffffff8),
	TInt64(0xbff00000,0x4),
	};

const TInt64 postDecArray2[] = 
	{
	TInt64(0xc0000000,0x0),
	TInt64(0xc0080000,0x0),
	TInt64(0xbff00000,0x0),
	TInt64(0x0,0x0),
	TInt64(0x7fefffff,0xffffffff),
	TInt64(0xffefffff,0xffffffff),
	TInt64(0xc0000000,0x0),
	TInt64(0xc0000000,0x0),
	TInt64(0xc09a2b07,0xe37d420f),
	TInt64(0x40992b48,0xb9a6a077),
	TInt64(0x4309945c,0xa261fff0),
	TInt64(0xc309945c,0xa2620010),
	TInt64(0xbfffffff,0xfffffe6a),
	TInt64(0xc0000000,0xca),
	TInt64(0x4373fbe8,0x5edc9000),
	TInt64(0xc373fbe8,0x5edc9000),
	TInt64(0xbfffffff,0xfffffffc),
	TInt64(0xc0000000,0x2),
	};

#endif
