// Copyright (c) 2001-2009 Objective Systems, Inc. (http://www.obj-sys.com) 
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available 
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//

/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).
 */
#ifndef ULP_COMPONENTS_H
#define ULP_COMPONENTS_H

#include <stdio.h>
#include <stdlib.h>
#include "rtkey.h"
#include "rtpersrc/asn1PerCppTypes.h"
#include "ASN1CBitStr.h"
#include "ASN1CSeqOfList.h"

/**
 * Header file for ASN.1 module ULP-Components
 */
/**************************************************************/
/*                                                            */
/*  Version                                                   */
/*                                                            */
/**************************************************************/

#define TV_Version	(TM_UNIV|TM_CONS|16)

struct ASN1T_Version {
   OSUINT8 maj;
   OSUINT8 min;
   OSUINT8 servind;
   IMPORT_C ASN1T_Version ();
} ;

IMPORT_C int asn1PE_Version (OSCTXT* pctxt, ASN1T_Version* pvalue);

IMPORT_C int asn1PD_Version (OSCTXT* pctxt, ASN1T_Version* pvalue);

IMPORT_C void asn1Print_Version
   (const char* name, ASN1T_Version* pvalue);

/**************************************************************/
/*                                                            */
/*  SETId_msisdn                                              */
/*                                                            */
/**************************************************************/

#define TV_SETId_msisdn	(TM_UNIV|TM_PRIM|4)

struct ASN1T_SETId_msisdn {
   OSUINT32 numocts;
   OSOCTET data[8];
   // ctors
   ASN1T_SETId_msisdn () : numocts(0) {}
   ASN1T_SETId_msisdn (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_SETId_msisdn (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_SETId_msisdn& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_SETId_msisdn (OSCTXT* pctxt, ASN1T_SETId_msisdn* pvalue);

IMPORT_C int asn1PD_SETId_msisdn (OSCTXT* pctxt, ASN1T_SETId_msisdn* pvalue);

IMPORT_C void asn1Print_SETId_msisdn
   (const char* name, ASN1T_SETId_msisdn* pvalue);

/**************************************************************/
/*                                                            */
/*  SETId_mdn                                                 */
/*                                                            */
/**************************************************************/

#define TV_SETId_mdn	(TM_UNIV|TM_PRIM|4)

struct ASN1T_SETId_mdn {
   OSUINT32 numocts;
   OSOCTET data[8];
   // ctors
   ASN1T_SETId_mdn () : numocts(0) {}
   ASN1T_SETId_mdn (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_SETId_mdn (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_SETId_mdn& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_SETId_mdn (OSCTXT* pctxt, ASN1T_SETId_mdn* pvalue);

IMPORT_C int asn1PD_SETId_mdn (OSCTXT* pctxt, ASN1T_SETId_mdn* pvalue);

IMPORT_C void asn1Print_SETId_mdn
   (const char* name, ASN1T_SETId_mdn* pvalue);

/**************************************************************/
/*                                                            */
/*  SETId_min                                                 */
/*                                                            */
/**************************************************************/

#define TV_SETId_min	(TM_UNIV|TM_PRIM|3)

struct ASN1T_SETId_min {
   OSUINT32  numbits;
   OSOCTET data[5];
   // ctors
   ASN1T_SETId_min () : numbits(0) {}
   ASN1T_SETId_min (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_SETId_min (OSCTXT* pctxt, ASN1T_SETId_min* pvalue);

IMPORT_C int asn1PD_SETId_min (OSCTXT* pctxt, ASN1T_SETId_min* pvalue);

IMPORT_C void asn1Print_SETId_min
   (const char* name, ASN1T_SETId_min* pvalue);

/**************************************************************/
/*                                                            */
/*  SETId_imsi                                                */
/*                                                            */
/**************************************************************/

#define TV_SETId_imsi	(TM_UNIV|TM_PRIM|4)

struct ASN1T_SETId_imsi {
   OSUINT32 numocts;
   OSOCTET data[8];
   // ctors
   ASN1T_SETId_imsi () : numocts(0) {}
   ASN1T_SETId_imsi (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_SETId_imsi (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_SETId_imsi& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_SETId_imsi (OSCTXT* pctxt, ASN1T_SETId_imsi* pvalue);

IMPORT_C int asn1PD_SETId_imsi (OSCTXT* pctxt, ASN1T_SETId_imsi* pvalue);

IMPORT_C void asn1Print_SETId_imsi
   (const char* name, ASN1T_SETId_imsi* pvalue);

/**************************************************************/
/*                                                            */
/*  IPAddress_ipv4Address                                     */
/*                                                            */
/**************************************************************/

#define TV_IPAddress_ipv4Address	(TM_UNIV|TM_PRIM|4)

struct ASN1T_IPAddress_ipv4Address {
   OSUINT32 numocts;
   OSOCTET data[4];
   // ctors
   ASN1T_IPAddress_ipv4Address () : numocts(0) {}
   ASN1T_IPAddress_ipv4Address (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_IPAddress_ipv4Address (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_IPAddress_ipv4Address& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_IPAddress_ipv4Address (OSCTXT* pctxt, ASN1T_IPAddress_ipv4Address* pvalue);

IMPORT_C int asn1PD_IPAddress_ipv4Address (OSCTXT* pctxt, ASN1T_IPAddress_ipv4Address* pvalue);

IMPORT_C void asn1Print_IPAddress_ipv4Address
   (const char* name, ASN1T_IPAddress_ipv4Address* pvalue);

/**************************************************************/
/*                                                            */
/*  IPAddress_ipv6Address                                     */
/*                                                            */
/**************************************************************/

#define TV_IPAddress_ipv6Address	(TM_UNIV|TM_PRIM|4)

struct ASN1T_IPAddress_ipv6Address {
   OSUINT32 numocts;
   OSOCTET data[16];
   // ctors
   ASN1T_IPAddress_ipv6Address () : numocts(0) {}
   ASN1T_IPAddress_ipv6Address (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_IPAddress_ipv6Address (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_IPAddress_ipv6Address& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_IPAddress_ipv6Address (OSCTXT* pctxt, ASN1T_IPAddress_ipv6Address* pvalue);

IMPORT_C int asn1PD_IPAddress_ipv6Address (OSCTXT* pctxt, ASN1T_IPAddress_ipv6Address* pvalue);

IMPORT_C void asn1Print_IPAddress_ipv6Address
   (const char* name, ASN1T_IPAddress_ipv6Address* pvalue);

/**************************************************************/
/*                                                            */
/*  IPAddress                                                 */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_IPAddress_ipv4Address         1
#define T_IPAddress_ipv6Address         2

struct ASN1T_IPAddress {
   int t;
   union {
      /* t = 1 */
      ASN1T_IPAddress_ipv4Address *ipv4Address;
      /* t = 2 */
      ASN1T_IPAddress_ipv6Address *ipv6Address;
   } u;
} ;

IMPORT_C int asn1PE_IPAddress (OSCTXT* pctxt, ASN1T_IPAddress* pvalue);

IMPORT_C int asn1PD_IPAddress (OSCTXT* pctxt, ASN1T_IPAddress* pvalue);

IMPORT_C void asn1Print_IPAddress
   (const char* name, ASN1T_IPAddress* pvalue);

IMPORT_C void asn1Free_IPAddress (OSCTXT *pctxt, ASN1T_IPAddress* pvalue);

/**************************************************************/
/*                                                            */
/*  SETId                                                     */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_SETId_msisdn                  1
#define T_SETId_mdn                     2
#define T_SETId_min                     3
#define T_SETId_imsi                    4
#define T_SETId_nai                     5
#define T_SETId_iPAddress               6
#define T_SETId_extElem1                7

struct ASN1T_SETId {
   int t;
   union {
      /* t = 1 */
      ASN1T_SETId_msisdn *msisdn;
      /* t = 2 */
      ASN1T_SETId_mdn *mdn;
      /* t = 3 */
      ASN1T_SETId_min *min;
      /* t = 4 */
      ASN1T_SETId_imsi *imsi;
      /* t = 5 */
      const char* nai;
      /* t = 6 */
      ASN1T_IPAddress *iPAddress;
      /* t = 7 */
   } u;
} ;

IMPORT_C int asn1PE_SETId (OSCTXT* pctxt, ASN1T_SETId* pvalue);

IMPORT_C int asn1PD_SETId (OSCTXT* pctxt, ASN1T_SETId* pvalue);

IMPORT_C void asn1Print_SETId
   (const char* name, ASN1T_SETId* pvalue);

IMPORT_C void asn1Free_SETId (OSCTXT *pctxt, ASN1T_SETId* pvalue);

/**************************************************************/
/*                                                            */
/*  SetSessionID                                              */
/*                                                            */
/**************************************************************/

#define TV_SetSessionID	(TM_UNIV|TM_CONS|16)

struct ASN1T_SetSessionID {
   OSUINT16 sessionId;
   ASN1T_SETId setId;
   IMPORT_C ASN1T_SetSessionID ();
} ;

IMPORT_C int asn1PE_SetSessionID (OSCTXT* pctxt, ASN1T_SetSessionID* pvalue);

IMPORT_C int asn1PD_SetSessionID (OSCTXT* pctxt, ASN1T_SetSessionID* pvalue);

IMPORT_C void asn1Print_SetSessionID
   (const char* name, ASN1T_SetSessionID* pvalue);

IMPORT_C void asn1Free_SetSessionID (OSCTXT *pctxt, ASN1T_SetSessionID* pvalue);

/**************************************************************/
/*                                                            */
/*  SlpSessionID_sessionID                                    */
/*                                                            */
/**************************************************************/

#define TV_SlpSessionID_sessionID	(TM_UNIV|TM_PRIM|4)

struct ASN1T_SlpSessionID_sessionID {
   OSUINT32 numocts;
   OSOCTET data[4];
   // ctors
   ASN1T_SlpSessionID_sessionID () : numocts(0) {}
   ASN1T_SlpSessionID_sessionID (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_SlpSessionID_sessionID (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_SlpSessionID_sessionID& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_SlpSessionID_sessionID (OSCTXT* pctxt, ASN1T_SlpSessionID_sessionID* pvalue);

IMPORT_C int asn1PD_SlpSessionID_sessionID (OSCTXT* pctxt, ASN1T_SlpSessionID_sessionID* pvalue);

IMPORT_C void asn1Print_SlpSessionID_sessionID
   (const char* name, ASN1T_SlpSessionID_sessionID* pvalue);

/**************************************************************/
/*                                                            */
/*  FQDN                                                      */
/*                                                            */
/**************************************************************/

#define TV_FQDN	(TM_UNIV|TM_PRIM|26)

typedef const char* ASN1T_FQDN;

IMPORT_C int asn1PE_FQDN (OSCTXT* pctxt, ASN1T_FQDN value);

IMPORT_C int asn1PD_FQDN (OSCTXT* pctxt, ASN1T_FQDN* pvalue);

IMPORT_C void asn1Print_FQDN
   (const char* name, ASN1T_FQDN pvalue);

IMPORT_C void asn1Free_FQDN (OSCTXT *pctxt, ASN1T_FQDN pvalue);

/**************************************************************/
/*                                                            */
/*  SLPAddress                                                */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_SLPAddress_iPAddress          1
#define T_SLPAddress_fQDN               2
#define T_SLPAddress_extElem1           3

struct ASN1T_SLPAddress {
   int t;
   union {
      /* t = 1 */
      ASN1T_IPAddress *iPAddress;
      /* t = 2 */
      ASN1T_FQDN fQDN;
      /* t = 3 */
   } u;
} ;

IMPORT_C int asn1PE_SLPAddress (OSCTXT* pctxt, ASN1T_SLPAddress* pvalue);

IMPORT_C int asn1PD_SLPAddress (OSCTXT* pctxt, ASN1T_SLPAddress* pvalue);

IMPORT_C void asn1Print_SLPAddress
   (const char* name, ASN1T_SLPAddress* pvalue);

IMPORT_C void asn1Free_SLPAddress (OSCTXT *pctxt, ASN1T_SLPAddress* pvalue);

/**************************************************************/
/*                                                            */
/*  SlpSessionID                                              */
/*                                                            */
/**************************************************************/

#define TV_SlpSessionID	(TM_UNIV|TM_CONS|16)

struct ASN1T_SlpSessionID {
   ASN1T_SlpSessionID_sessionID sessionID;
   ASN1T_SLPAddress slpId;
   IMPORT_C ASN1T_SlpSessionID ();
} ;

IMPORT_C int asn1PE_SlpSessionID (OSCTXT* pctxt, ASN1T_SlpSessionID* pvalue);

IMPORT_C int asn1PD_SlpSessionID (OSCTXT* pctxt, ASN1T_SlpSessionID* pvalue);

IMPORT_C void asn1Print_SlpSessionID
   (const char* name, ASN1T_SlpSessionID* pvalue);

IMPORT_C void asn1Free_SlpSessionID (OSCTXT *pctxt, ASN1T_SlpSessionID* pvalue);

/**************************************************************/
/*                                                            */
/*  SessionID                                                 */
/*                                                            */
/**************************************************************/

#define TV_SessionID	(TM_UNIV|TM_CONS|16)

struct ASN1T_SessionID {
   struct {
      unsigned setSessionIDPresent : 1;
      unsigned slpSessionIDPresent : 1;
   } m;
   ASN1T_SetSessionID setSessionID;
   ASN1T_SlpSessionID slpSessionID;
   IMPORT_C ASN1T_SessionID ();
} ;

IMPORT_C int asn1PE_SessionID (OSCTXT* pctxt, ASN1T_SessionID* pvalue);

IMPORT_C int asn1PD_SessionID (OSCTXT* pctxt, ASN1T_SessionID* pvalue);

IMPORT_C void asn1Print_SessionID
   (const char* name, ASN1T_SessionID* pvalue);

IMPORT_C void asn1Free_SessionID (OSCTXT *pctxt, ASN1T_SessionID* pvalue);

/**************************************************************/
/*                                                            */
/*  PosMethod                                                 */
/*                                                            */
/**************************************************************/

#define TV_PosMethod	(TM_UNIV|TM_PRIM|10)

struct PosMethod {
   enum Root {
      agpsSETassisted = 0,
      agpsSETbased = 1,
      agpsSETassistedpref = 2,
      agpsSETbasedpref = 3,
      autonomousGPS = 4,
      aFLT = 5,
      eCID = 6,
      eOTD = 7,
      oTDOA = 8,
      noPosition = 9
   } ;
} ;

typedef OSUINT32 ASN1T_PosMethod;

IMPORT_C int asn1PE_PosMethod (OSCTXT* pctxt, ASN1T_PosMethod value);

IMPORT_C int asn1PD_PosMethod (OSCTXT* pctxt, ASN1T_PosMethod* pvalue);

IMPORT_C void asn1Print_PosMethod
   (const char* name, ASN1T_PosMethod* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_PosMethod_ToString (OSINT32 value);

IMPORT_C int ASN1T_PosMethod_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_PosMethod* pvalue);

/**************************************************************/
/*                                                            */
/*  QoP                                                       */
/*                                                            */
/**************************************************************/

#define TV_QoP	(TM_UNIV|TM_CONS|16)

struct ASN1T_QoP {
   struct {
      unsigned veraccPresent : 1;
      unsigned maxLocAgePresent : 1;
      unsigned delayPresent : 1;
   } m;
   OSUINT8 horacc;
   OSUINT8 veracc;
   OSUINT16 maxLocAge;
   OSUINT8 delay;
   IMPORT_C ASN1T_QoP ();
} ;

IMPORT_C int asn1PE_QoP (OSCTXT* pctxt, ASN1T_QoP* pvalue);

IMPORT_C int asn1PD_QoP (OSCTXT* pctxt, ASN1T_QoP* pvalue);

IMPORT_C void asn1Print_QoP
   (const char* name, ASN1T_QoP* pvalue);

/**************************************************************/
/*                                                            */
/*  NMRelement                                                */
/*                                                            */
/**************************************************************/

#define TV_NMRelement	(TM_UNIV|TM_CONS|16)

struct ASN1T_NMRelement {
   OSUINT16 aRFCN;
   OSUINT8 bSIC;
   OSUINT8 rxLev;
   IMPORT_C ASN1T_NMRelement ();
} ;

IMPORT_C int asn1PE_NMRelement (OSCTXT* pctxt, ASN1T_NMRelement* pvalue);

IMPORT_C int asn1PD_NMRelement (OSCTXT* pctxt, ASN1T_NMRelement* pvalue);

IMPORT_C void asn1Print_NMRelement
   (const char* name, ASN1T_NMRelement* pvalue);

/**************************************************************/
/*                                                            */
/*  NMR                                                       */
/*                                                            */
/**************************************************************/

#define TV_NMR	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_NMRelement */
typedef ASN1TSeqOfList ASN1T_NMR;

class ASN1C_NMR :
public ASN1CSeqOfList
{
protected:
   ASN1T_NMR& msgData;
public:
   IMPORT_C ASN1C_NMR (ASN1T_NMR& data);
   IMPORT_C ASN1C_NMR (OSRTMessageBufferIF& msgBuf, ASN1T_NMR& data);
   IMPORT_C ASN1C_NMR (ASN1CType& ccobj, ASN1T_NMR& data);
   IMPORT_C ASN1C_NMR (OSRTContext &context, ASN1T_NMR& data);
   IMPORT_C void Append (ASN1T_NMRelement* elem);
   IMPORT_C ASN1T_NMRelement* NewElement ();
} ;

IMPORT_C int asn1PE_NMR (OSCTXT* pctxt, ASN1T_NMR* pvalue);

IMPORT_C int asn1PD_NMR (OSCTXT* pctxt, ASN1T_NMR* pvalue);

IMPORT_C void asn1Print_NMR
   (const char* name, ASN1T_NMR* pvalue);

IMPORT_C void asn1Free_NMR (OSCTXT *pctxt, ASN1T_NMR* pvalue);

/**************************************************************/
/*                                                            */
/*  GsmCellInformation                                        */
/*                                                            */
/**************************************************************/

#define TV_GsmCellInformation	(TM_UNIV|TM_CONS|16)

struct ASN1T_GsmCellInformation {
   struct {
      unsigned nMRPresent : 1;
      unsigned tAPresent : 1;
   } m;
   OSUINT16 refMCC;
   OSUINT16 refMNC;
   OSUINT16 refLAC;
   OSUINT16 refCI;
   ASN1T_NMR nMR;
   OSUINT8 tA;
   IMPORT_C ASN1T_GsmCellInformation ();
} ;

IMPORT_C int asn1PE_GsmCellInformation (OSCTXT* pctxt, ASN1T_GsmCellInformation* pvalue);

IMPORT_C int asn1PD_GsmCellInformation (OSCTXT* pctxt, ASN1T_GsmCellInformation* pvalue);

IMPORT_C void asn1Print_GsmCellInformation
   (const char* name, ASN1T_GsmCellInformation* pvalue);

IMPORT_C void asn1Free_GsmCellInformation (OSCTXT *pctxt, ASN1T_GsmCellInformation* pvalue);

/**************************************************************/
/*                                                            */
/*  UARFCN                                                    */
/*                                                            */
/**************************************************************/

#define TV_UARFCN	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_UARFCN;

IMPORT_C int asn1PE_UARFCN (OSCTXT* pctxt, ASN1T_UARFCN value);

IMPORT_C int asn1PD_UARFCN (OSCTXT* pctxt, ASN1T_UARFCN* pvalue);

IMPORT_C void asn1Print_UARFCN
   (const char* name, ASN1T_UARFCN* pvalue);

/**************************************************************/
/*                                                            */
/*  FrequencyInfoFDD                                          */
/*                                                            */
/**************************************************************/

#define TV_FrequencyInfoFDD	(TM_UNIV|TM_CONS|16)

struct ASN1T_FrequencyInfoFDD {
   struct {
      unsigned uarfcn_ULPresent : 1;
   } m;
   ASN1T_UARFCN uarfcn_UL;
   ASN1T_UARFCN uarfcn_DL;
   IMPORT_C ASN1T_FrequencyInfoFDD ();
} ;

IMPORT_C int asn1PE_FrequencyInfoFDD (OSCTXT* pctxt, ASN1T_FrequencyInfoFDD* pvalue);

IMPORT_C int asn1PD_FrequencyInfoFDD (OSCTXT* pctxt, ASN1T_FrequencyInfoFDD* pvalue);

IMPORT_C void asn1Print_FrequencyInfoFDD
   (const char* name, ASN1T_FrequencyInfoFDD* pvalue);

/**************************************************************/
/*                                                            */
/*  FrequencyInfoTDD                                          */
/*                                                            */
/**************************************************************/

#define TV_FrequencyInfoTDD	(TM_UNIV|TM_CONS|16)

struct ASN1T_FrequencyInfoTDD {
   ASN1T_UARFCN uarfcn_Nt;
   IMPORT_C ASN1T_FrequencyInfoTDD ();
} ;

IMPORT_C int asn1PE_FrequencyInfoTDD (OSCTXT* pctxt, ASN1T_FrequencyInfoTDD* pvalue);

IMPORT_C int asn1PD_FrequencyInfoTDD (OSCTXT* pctxt, ASN1T_FrequencyInfoTDD* pvalue);

IMPORT_C void asn1Print_FrequencyInfoTDD
   (const char* name, ASN1T_FrequencyInfoTDD* pvalue);

/**************************************************************/
/*                                                            */
/*  FrequencyInfo_modeSpecificInfo                            */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_FrequencyInfo_modeSpecificInfo_fdd 1
#define T_FrequencyInfo_modeSpecificInfo_tdd 2
#define T_FrequencyInfo_modeSpecificInfo_extElem1 3

struct ASN1T_FrequencyInfo_modeSpecificInfo {
   int t;
   union {
      /* t = 1 */
      ASN1T_FrequencyInfoFDD *fdd;
      /* t = 2 */
      ASN1T_FrequencyInfoTDD *tdd;
      /* t = 3 */
   } u;
} ;

IMPORT_C int asn1PE_FrequencyInfo_modeSpecificInfo (OSCTXT* pctxt, ASN1T_FrequencyInfo_modeSpecificInfo* pvalue);

IMPORT_C int asn1PD_FrequencyInfo_modeSpecificInfo (OSCTXT* pctxt, ASN1T_FrequencyInfo_modeSpecificInfo* pvalue);

IMPORT_C void asn1Print_FrequencyInfo_modeSpecificInfo
   (const char* name, ASN1T_FrequencyInfo_modeSpecificInfo* pvalue);

IMPORT_C void asn1Free_FrequencyInfo_modeSpecificInfo (OSCTXT *pctxt, ASN1T_FrequencyInfo_modeSpecificInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  FrequencyInfo                                             */
/*                                                            */
/**************************************************************/

#define TV_FrequencyInfo	(TM_UNIV|TM_CONS|16)

struct ASN1T_FrequencyInfo {
   ASN1T_FrequencyInfo_modeSpecificInfo modeSpecificInfo;
   IMPORT_C ASN1T_FrequencyInfo ();
} ;

IMPORT_C int asn1PE_FrequencyInfo (OSCTXT* pctxt, ASN1T_FrequencyInfo* pvalue);

IMPORT_C int asn1PD_FrequencyInfo (OSCTXT* pctxt, ASN1T_FrequencyInfo* pvalue);

IMPORT_C void asn1Print_FrequencyInfo
   (const char* name, ASN1T_FrequencyInfo* pvalue);

IMPORT_C void asn1Free_FrequencyInfo (OSCTXT *pctxt, ASN1T_FrequencyInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  UTRA_CarrierRSSI                                          */
/*                                                            */
/**************************************************************/

#define TV_UTRA_CarrierRSSI	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_UTRA_CarrierRSSI;

IMPORT_C int asn1PE_UTRA_CarrierRSSI (OSCTXT* pctxt, ASN1T_UTRA_CarrierRSSI value);

IMPORT_C int asn1PD_UTRA_CarrierRSSI (OSCTXT* pctxt, ASN1T_UTRA_CarrierRSSI* pvalue);

IMPORT_C void asn1Print_UTRA_CarrierRSSI
   (const char* name, ASN1T_UTRA_CarrierRSSI* pvalue);

/**************************************************************/
/*                                                            */
/*  PrimaryCPICH_Info                                         */
/*                                                            */
/**************************************************************/

#define TV_PrimaryCPICH_Info	(TM_UNIV|TM_CONS|16)

struct ASN1T_PrimaryCPICH_Info {
   OSUINT16 primaryScramblingCode;
   IMPORT_C ASN1T_PrimaryCPICH_Info ();
} ;

IMPORT_C int asn1PE_PrimaryCPICH_Info (OSCTXT* pctxt, ASN1T_PrimaryCPICH_Info* pvalue);

IMPORT_C int asn1PD_PrimaryCPICH_Info (OSCTXT* pctxt, ASN1T_PrimaryCPICH_Info* pvalue);

IMPORT_C void asn1Print_PrimaryCPICH_Info
   (const char* name, ASN1T_PrimaryCPICH_Info* pvalue);

/**************************************************************/
/*                                                            */
/*  CPICH_Ec_N0                                               */
/*                                                            */
/**************************************************************/

#define TV_CPICH_Ec_N0	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_CPICH_Ec_N0;

IMPORT_C int asn1PE_CPICH_Ec_N0 (OSCTXT* pctxt, ASN1T_CPICH_Ec_N0 value);

IMPORT_C int asn1PD_CPICH_Ec_N0 (OSCTXT* pctxt, ASN1T_CPICH_Ec_N0* pvalue);

IMPORT_C void asn1Print_CPICH_Ec_N0
   (const char* name, ASN1T_CPICH_Ec_N0* pvalue);

/**************************************************************/
/*                                                            */
/*  CPICH_RSCP                                                */
/*                                                            */
/**************************************************************/

#define TV_CPICH_RSCP	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_CPICH_RSCP;

IMPORT_C int asn1PE_CPICH_RSCP (OSCTXT* pctxt, ASN1T_CPICH_RSCP value);

IMPORT_C int asn1PD_CPICH_RSCP (OSCTXT* pctxt, ASN1T_CPICH_RSCP* pvalue);

IMPORT_C void asn1Print_CPICH_RSCP
   (const char* name, ASN1T_CPICH_RSCP* pvalue);

/**************************************************************/
/*                                                            */
/*  Pathloss                                                  */
/*                                                            */
/**************************************************************/

#define TV_Pathloss	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_Pathloss;

IMPORT_C int asn1PE_Pathloss (OSCTXT* pctxt, ASN1T_Pathloss value);

IMPORT_C int asn1PD_Pathloss (OSCTXT* pctxt, ASN1T_Pathloss* pvalue);

IMPORT_C void asn1Print_Pathloss
   (const char* name, ASN1T_Pathloss* pvalue);

/**************************************************************/
/*                                                            */
/*  CellMeasuredResults_modeSpecificInfo_fdd                  */
/*                                                            */
/**************************************************************/

#define TV_CellMeasuredResults_modeSpecificInfo_fdd	(TM_UNIV|TM_CONS|16)

struct ASN1T_CellMeasuredResults_modeSpecificInfo_fdd {
   struct {
      unsigned cpich_Ec_N0Present : 1;
      unsigned cpich_RSCPPresent : 1;
      unsigned pathlossPresent : 1;
   } m;
   ASN1T_PrimaryCPICH_Info primaryCPICH_Info;
   ASN1T_CPICH_Ec_N0 cpich_Ec_N0;
   ASN1T_CPICH_RSCP cpich_RSCP;
   ASN1T_Pathloss pathloss;
   IMPORT_C ASN1T_CellMeasuredResults_modeSpecificInfo_fdd ();
} ;

IMPORT_C int asn1PE_CellMeasuredResults_modeSpecificInfo_fdd (OSCTXT* pctxt, ASN1T_CellMeasuredResults_modeSpecificInfo_fdd* pvalue);

IMPORT_C int asn1PD_CellMeasuredResults_modeSpecificInfo_fdd (OSCTXT* pctxt, ASN1T_CellMeasuredResults_modeSpecificInfo_fdd* pvalue);

IMPORT_C void asn1Print_CellMeasuredResults_modeSpecificInfo_fdd
   (const char* name, ASN1T_CellMeasuredResults_modeSpecificInfo_fdd* pvalue);

/**************************************************************/
/*                                                            */
/*  CellParametersID                                          */
/*                                                            */
/**************************************************************/

#define TV_CellParametersID	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_CellParametersID;

IMPORT_C int asn1PE_CellParametersID (OSCTXT* pctxt, ASN1T_CellParametersID value);

IMPORT_C int asn1PD_CellParametersID (OSCTXT* pctxt, ASN1T_CellParametersID* pvalue);

IMPORT_C void asn1Print_CellParametersID
   (const char* name, ASN1T_CellParametersID* pvalue);

/**************************************************************/
/*                                                            */
/*  TGSN                                                      */
/*                                                            */
/**************************************************************/

#define TV_TGSN	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_TGSN;

IMPORT_C int asn1PE_TGSN (OSCTXT* pctxt, ASN1T_TGSN value);

IMPORT_C int asn1PD_TGSN (OSCTXT* pctxt, ASN1T_TGSN* pvalue);

IMPORT_C void asn1Print_TGSN
   (const char* name, ASN1T_TGSN* pvalue);

/**************************************************************/
/*                                                            */
/*  PrimaryCCPCH_RSCP                                         */
/*                                                            */
/**************************************************************/

#define TV_PrimaryCCPCH_RSCP	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_PrimaryCCPCH_RSCP;

IMPORT_C int asn1PE_PrimaryCCPCH_RSCP (OSCTXT* pctxt, ASN1T_PrimaryCCPCH_RSCP value);

IMPORT_C int asn1PD_PrimaryCCPCH_RSCP (OSCTXT* pctxt, ASN1T_PrimaryCCPCH_RSCP* pvalue);

IMPORT_C void asn1Print_PrimaryCCPCH_RSCP
   (const char* name, ASN1T_PrimaryCCPCH_RSCP* pvalue);

/**************************************************************/
/*                                                            */
/*  TimeslotISCP                                              */
/*                                                            */
/**************************************************************/

#define TV_TimeslotISCP	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_TimeslotISCP;

IMPORT_C int asn1PE_TimeslotISCP (OSCTXT* pctxt, ASN1T_TimeslotISCP value);

IMPORT_C int asn1PD_TimeslotISCP (OSCTXT* pctxt, ASN1T_TimeslotISCP* pvalue);

IMPORT_C void asn1Print_TimeslotISCP
   (const char* name, ASN1T_TimeslotISCP* pvalue);

/**************************************************************/
/*                                                            */
/*  TimeslotISCP_List                                         */
/*                                                            */
/**************************************************************/

#define TV_TimeslotISCP_List	(TM_UNIV|TM_CONS|16)

typedef struct ASN1T_TimeslotISCP_List {
   OSUINT32 n;
   ASN1T_TimeslotISCP elem[14];
   ASN1T_TimeslotISCP_List () : n (0) {}
} ASN1T_TimeslotISCP_List;

IMPORT_C int asn1PE_TimeslotISCP_List (OSCTXT* pctxt, ASN1T_TimeslotISCP_List* pvalue);

IMPORT_C int asn1PD_TimeslotISCP_List (OSCTXT* pctxt, ASN1T_TimeslotISCP_List* pvalue);

IMPORT_C void asn1Print_TimeslotISCP_List
   (const char* name, ASN1T_TimeslotISCP_List* pvalue);

/**************************************************************/
/*                                                            */
/*  CellMeasuredResults_modeSpecificInfo_tdd                  */
/*                                                            */
/**************************************************************/

#define TV_CellMeasuredResults_modeSpecificInfo_tdd	(TM_UNIV|TM_CONS|16)

struct ASN1T_CellMeasuredResults_modeSpecificInfo_tdd {
   struct {
      unsigned proposedTGSNPresent : 1;
      unsigned primaryCCPCH_RSCPPresent : 1;
      unsigned pathlossPresent : 1;
      unsigned timeslotISCP_ListPresent : 1;
   } m;
   ASN1T_CellParametersID cellParametersID;
   ASN1T_TGSN proposedTGSN;
   ASN1T_PrimaryCCPCH_RSCP primaryCCPCH_RSCP;
   ASN1T_Pathloss pathloss;
   ASN1T_TimeslotISCP_List timeslotISCP_List;
   IMPORT_C ASN1T_CellMeasuredResults_modeSpecificInfo_tdd ();
} ;

IMPORT_C int asn1PE_CellMeasuredResults_modeSpecificInfo_tdd (OSCTXT* pctxt, ASN1T_CellMeasuredResults_modeSpecificInfo_tdd* pvalue);

IMPORT_C int asn1PD_CellMeasuredResults_modeSpecificInfo_tdd (OSCTXT* pctxt, ASN1T_CellMeasuredResults_modeSpecificInfo_tdd* pvalue);

IMPORT_C void asn1Print_CellMeasuredResults_modeSpecificInfo_tdd
   (const char* name, ASN1T_CellMeasuredResults_modeSpecificInfo_tdd* pvalue);

/**************************************************************/
/*                                                            */
/*  CellMeasuredResults_modeSpecificInfo                      */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_CellMeasuredResults_modeSpecificInfo_fdd 1
#define T_CellMeasuredResults_modeSpecificInfo_tdd 2

struct ASN1T_CellMeasuredResults_modeSpecificInfo {
   int t;
   union {
      /* t = 1 */
      ASN1T_CellMeasuredResults_modeSpecificInfo_fdd *fdd;
      /* t = 2 */
      ASN1T_CellMeasuredResults_modeSpecificInfo_tdd *tdd;
   } u;
} ;

IMPORT_C int asn1PE_CellMeasuredResults_modeSpecificInfo (OSCTXT* pctxt, ASN1T_CellMeasuredResults_modeSpecificInfo* pvalue);

IMPORT_C int asn1PD_CellMeasuredResults_modeSpecificInfo (OSCTXT* pctxt, ASN1T_CellMeasuredResults_modeSpecificInfo* pvalue);

IMPORT_C void asn1Print_CellMeasuredResults_modeSpecificInfo
   (const char* name, ASN1T_CellMeasuredResults_modeSpecificInfo* pvalue);

IMPORT_C void asn1Free_CellMeasuredResults_modeSpecificInfo (OSCTXT *pctxt, ASN1T_CellMeasuredResults_modeSpecificInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  CellMeasuredResults                                       */
/*                                                            */
/**************************************************************/

#define TV_CellMeasuredResults	(TM_UNIV|TM_CONS|16)

struct ASN1T_CellMeasuredResults {
   struct {
      unsigned cellIdentityPresent : 1;
   } m;
   OSUINT32 cellIdentity;
   ASN1T_CellMeasuredResults_modeSpecificInfo modeSpecificInfo;
   IMPORT_C ASN1T_CellMeasuredResults ();
} ;

IMPORT_C int asn1PE_CellMeasuredResults (OSCTXT* pctxt, ASN1T_CellMeasuredResults* pvalue);

IMPORT_C int asn1PD_CellMeasuredResults (OSCTXT* pctxt, ASN1T_CellMeasuredResults* pvalue);

IMPORT_C void asn1Print_CellMeasuredResults
   (const char* name, ASN1T_CellMeasuredResults* pvalue);

IMPORT_C void asn1Free_CellMeasuredResults (OSCTXT *pctxt, ASN1T_CellMeasuredResults* pvalue);

/**************************************************************/
/*                                                            */
/*  CellMeasuredResultsList                                   */
/*                                                            */
/**************************************************************/

#define TV_CellMeasuredResultsList	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_CellMeasuredResults */
typedef ASN1TSeqOfList ASN1T_CellMeasuredResultsList;

class ASN1C_CellMeasuredResultsList :
public ASN1CSeqOfList
{
protected:
   ASN1T_CellMeasuredResultsList& msgData;
public:
   IMPORT_C ASN1C_CellMeasuredResultsList (ASN1T_CellMeasuredResultsList& data);
   IMPORT_C ASN1C_CellMeasuredResultsList (OSRTMessageBufferIF& msgBuf
      , ASN1T_CellMeasuredResultsList& data);
   ASN1C_CellMeasuredResultsList (ASN1CType& ccobj, ASN1T_CellMeasuredResultsList& data);
   IMPORT_C ASN1C_CellMeasuredResultsList (OSRTContext &context
      , ASN1T_CellMeasuredResultsList& data);
   void Append (ASN1T_CellMeasuredResults* elem);
   ASN1T_CellMeasuredResults* NewElement ();
} ;

IMPORT_C int asn1PE_CellMeasuredResultsList (OSCTXT* pctxt, ASN1T_CellMeasuredResultsList* pvalue);

IMPORT_C int asn1PD_CellMeasuredResultsList (OSCTXT* pctxt, ASN1T_CellMeasuredResultsList* pvalue);

IMPORT_C void asn1Print_CellMeasuredResultsList
   (const char* name, ASN1T_CellMeasuredResultsList* pvalue);

IMPORT_C void asn1Free_CellMeasuredResultsList (OSCTXT *pctxt, ASN1T_CellMeasuredResultsList* pvalue);

/**************************************************************/
/*                                                            */
/*  MeasuredResults                                           */
/*                                                            */
/**************************************************************/

#define TV_MeasuredResults	(TM_UNIV|TM_CONS|16)

struct ASN1T_MeasuredResults {
   struct {
      unsigned frequencyInfoPresent : 1;
      unsigned utra_CarrierRSSIPresent : 1;
      unsigned cellMeasuredResultsListPresent : 1;
   } m;
   ASN1T_FrequencyInfo frequencyInfo;
   ASN1T_UTRA_CarrierRSSI utra_CarrierRSSI;
   ASN1T_CellMeasuredResultsList cellMeasuredResultsList;
   IMPORT_C ASN1T_MeasuredResults ();
} ;

IMPORT_C int asn1PE_MeasuredResults (OSCTXT* pctxt, ASN1T_MeasuredResults* pvalue);

IMPORT_C int asn1PD_MeasuredResults (OSCTXT* pctxt, ASN1T_MeasuredResults* pvalue);

IMPORT_C void asn1Print_MeasuredResults
   (const char* name, ASN1T_MeasuredResults* pvalue);

IMPORT_C void asn1Free_MeasuredResults (OSCTXT *pctxt, ASN1T_MeasuredResults* pvalue);

/**************************************************************/
/*                                                            */
/*  MeasuredResultsList                                       */
/*                                                            */
/**************************************************************/

#define TV_MeasuredResultsList	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_MeasuredResults */
typedef ASN1TSeqOfList ASN1T_MeasuredResultsList;

class ASN1C_MeasuredResultsList :
public ASN1CSeqOfList
{
protected:
   ASN1T_MeasuredResultsList& msgData;
public:
   IMPORT_C ASN1C_MeasuredResultsList (ASN1T_MeasuredResultsList& data);
   IMPORT_C ASN1C_MeasuredResultsList (OSRTMessageBufferIF& msgBuf
      , ASN1T_MeasuredResultsList& data);
   ASN1C_MeasuredResultsList (ASN1CType& ccobj, ASN1T_MeasuredResultsList& data);
   IMPORT_C ASN1C_MeasuredResultsList (OSRTContext &context
      , ASN1T_MeasuredResultsList& data);
   void Append (ASN1T_MeasuredResults* elem);
   ASN1T_MeasuredResults* NewElement ();
} ;

IMPORT_C int asn1PE_MeasuredResultsList (OSCTXT* pctxt, ASN1T_MeasuredResultsList* pvalue);

IMPORT_C int asn1PD_MeasuredResultsList (OSCTXT* pctxt, ASN1T_MeasuredResultsList* pvalue);

IMPORT_C void asn1Print_MeasuredResultsList
   (const char* name, ASN1T_MeasuredResultsList* pvalue);

IMPORT_C void asn1Free_MeasuredResultsList (OSCTXT *pctxt, ASN1T_MeasuredResultsList* pvalue);

/**************************************************************/
/*                                                            */
/*  WcdmaCellInformation                                      */
/*                                                            */
/**************************************************************/

#define TV_WcdmaCellInformation	(TM_UNIV|TM_CONS|16)

struct ASN1T_WcdmaCellInformation {
   struct {
      unsigned frequencyInfoPresent : 1;
      unsigned primaryScramblingCodePresent : 1;
      unsigned measuredResultsListPresent : 1;
   } m;
   OSUINT16 refMCC;
   OSUINT16 refMNC;
   OSUINT32 refUC;
   ASN1T_FrequencyInfo frequencyInfo;
   OSUINT16 primaryScramblingCode;
   ASN1T_MeasuredResultsList measuredResultsList;
   IMPORT_C ASN1T_WcdmaCellInformation ();
} ;

IMPORT_C int asn1PE_WcdmaCellInformation (OSCTXT* pctxt, ASN1T_WcdmaCellInformation* pvalue);

IMPORT_C int asn1PD_WcdmaCellInformation (OSCTXT* pctxt, ASN1T_WcdmaCellInformation* pvalue);

IMPORT_C void asn1Print_WcdmaCellInformation
   (const char* name, ASN1T_WcdmaCellInformation* pvalue);

IMPORT_C void asn1Free_WcdmaCellInformation (OSCTXT *pctxt, ASN1T_WcdmaCellInformation* pvalue);

/**************************************************************/
/*                                                            */
/*  CdmaCellInformation                                       */
/*                                                            */
/**************************************************************/

#define TV_CdmaCellInformation	(TM_UNIV|TM_CONS|16)

struct ASN1T_CdmaCellInformation {
   OSUINT16 refNID;
   OSUINT16 refSID;
   OSUINT16 refBASEID;
   OSUINT32 refBASELAT;
   OSUINT32 reBASELONG;
   OSUINT16 refREFPN;
   OSUINT16 refWeekNumber;
   OSUINT32 refSeconds;
   IMPORT_C ASN1T_CdmaCellInformation ();
} ;

IMPORT_C int asn1PE_CdmaCellInformation (OSCTXT* pctxt, ASN1T_CdmaCellInformation* pvalue);

IMPORT_C int asn1PD_CdmaCellInformation (OSCTXT* pctxt, ASN1T_CdmaCellInformation* pvalue);

IMPORT_C void asn1Print_CdmaCellInformation
   (const char* name, ASN1T_CdmaCellInformation* pvalue);

/**************************************************************/
/*                                                            */
/*  CellInfo                                                  */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_CellInfo_gsmCell              1
#define T_CellInfo_wcdmaCell            2
#define T_CellInfo_cdmaCell             3
#define T_CellInfo_extElem1             4

struct ASN1T_CellInfo {
   int t;
   union {
      /* t = 1 */
      ASN1T_GsmCellInformation *gsmCell;
      /* t = 2 */
      ASN1T_WcdmaCellInformation *wcdmaCell;
      /* t = 3 */
      ASN1T_CdmaCellInformation *cdmaCell;
      /* t = 4 */
   } u;
} ;

IMPORT_C int asn1PE_CellInfo (OSCTXT* pctxt, ASN1T_CellInfo* pvalue);

IMPORT_C int asn1PD_CellInfo (OSCTXT* pctxt, ASN1T_CellInfo* pvalue);

IMPORT_C void asn1Print_CellInfo
   (const char* name, ASN1T_CellInfo* pvalue);

IMPORT_C void asn1Free_CellInfo (OSCTXT *pctxt, ASN1T_CellInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  Status                                                    */
/*                                                            */
/**************************************************************/

#define TV_Status	(TM_UNIV|TM_PRIM|10)

struct Status {
   enum Root {
      stale = 0,
      current = 1,
      unknown = 2
   } ;
} ;

typedef OSUINT32 ASN1T_Status;

IMPORT_C int asn1PE_Status (OSCTXT* pctxt, ASN1T_Status value);

IMPORT_C int asn1PD_Status (OSCTXT* pctxt, ASN1T_Status* pvalue);

IMPORT_C void asn1Print_Status
   (const char* name, ASN1T_Status* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_Status_ToString (OSINT32 value);

IMPORT_C int ASN1T_Status_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_Status* pvalue);

/**************************************************************/
/*                                                            */
/*  LocationId                                                */
/*                                                            */
/**************************************************************/

#define TV_LocationId	(TM_UNIV|TM_CONS|16)

struct ASN1T_LocationId {
   ASN1T_CellInfo cellInfo;
   ASN1T_Status status;
   IMPORT_C ASN1T_LocationId ();
} ;

IMPORT_C int asn1PE_LocationId (OSCTXT* pctxt, ASN1T_LocationId* pvalue);

IMPORT_C int asn1PD_LocationId (OSCTXT* pctxt, ASN1T_LocationId* pvalue);

IMPORT_C void asn1Print_LocationId
   (const char* name, ASN1T_LocationId* pvalue);

IMPORT_C void asn1Free_LocationId (OSCTXT *pctxt, ASN1T_LocationId* pvalue);

/**************************************************************/
/*                                                            */
/*  PositionEstimate_latitudeSign                             */
/*                                                            */
/**************************************************************/

#define TV_PositionEstimate_latitudeSign	(TM_UNIV|TM_PRIM|10)

struct PositionEstimate_latitudeSign {
   enum Root {
      north = 0,
      south = 1
   } ;
} ;

typedef OSUINT32 ASN1T_PositionEstimate_latitudeSign;

IMPORT_C int asn1PE_PositionEstimate_latitudeSign (OSCTXT* pctxt, ASN1T_PositionEstimate_latitudeSign value);

IMPORT_C int asn1PD_PositionEstimate_latitudeSign (OSCTXT* pctxt, ASN1T_PositionEstimate_latitudeSign* pvalue);

IMPORT_C void asn1Print_PositionEstimate_latitudeSign
   (const char* name, ASN1T_PositionEstimate_latitudeSign* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_PositionEstimate_latitudeSign_ToString (OSINT32 value);

IMPORT_C int ASN1T_PositionEstimate_latitudeSign_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_PositionEstimate_latitudeSign* pvalue);

/**************************************************************/
/*                                                            */
/*  PositionEstimate_uncertainty                              */
/*                                                            */
/**************************************************************/

#define TV_PositionEstimate_uncertainty	(TM_UNIV|TM_CONS|16)

struct ASN1T_PositionEstimate_uncertainty {
   OSUINT8 uncertaintySemiMajor;
   OSUINT8 uncertaintySemiMinor;
   OSUINT8 orientationMajorAxis;
   IMPORT_C ASN1T_PositionEstimate_uncertainty ();
} ;

IMPORT_C int asn1PE_PositionEstimate_uncertainty (OSCTXT* pctxt, ASN1T_PositionEstimate_uncertainty* pvalue);

IMPORT_C int asn1PD_PositionEstimate_uncertainty (OSCTXT* pctxt, ASN1T_PositionEstimate_uncertainty* pvalue);

IMPORT_C void asn1Print_PositionEstimate_uncertainty
   (const char* name, ASN1T_PositionEstimate_uncertainty* pvalue);

/**************************************************************/
/*                                                            */
/*  AltitudeInfo_altitudeDirection                            */
/*                                                            */
/**************************************************************/

#define TV_AltitudeInfo_altitudeDirection	(TM_UNIV|TM_PRIM|10)

struct AltitudeInfo_altitudeDirection {
   enum Root {
      height = 0,
      depth = 1
   } ;
} ;

typedef OSUINT32 ASN1T_AltitudeInfo_altitudeDirection;

IMPORT_C int asn1PE_AltitudeInfo_altitudeDirection (OSCTXT* pctxt, ASN1T_AltitudeInfo_altitudeDirection value);

IMPORT_C int asn1PD_AltitudeInfo_altitudeDirection (OSCTXT* pctxt, ASN1T_AltitudeInfo_altitudeDirection* pvalue);

IMPORT_C void asn1Print_AltitudeInfo_altitudeDirection
   (const char* name, ASN1T_AltitudeInfo_altitudeDirection* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_AltitudeInfo_altitudeDirection_ToString (OSINT32 value);

IMPORT_C int ASN1T_AltitudeInfo_altitudeDirection_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_AltitudeInfo_altitudeDirection* pvalue);

/**************************************************************/
/*                                                            */
/*  AltitudeInfo                                              */
/*                                                            */
/**************************************************************/

#define TV_AltitudeInfo	(TM_UNIV|TM_CONS|16)

struct ASN1T_AltitudeInfo {
   ASN1T_AltitudeInfo_altitudeDirection altitudeDirection;
   OSUINT16 altitude;
   OSUINT8 altUncertainty;
   IMPORT_C ASN1T_AltitudeInfo ();
} ;

IMPORT_C int asn1PE_AltitudeInfo (OSCTXT* pctxt, ASN1T_AltitudeInfo* pvalue);

IMPORT_C int asn1PD_AltitudeInfo (OSCTXT* pctxt, ASN1T_AltitudeInfo* pvalue);

IMPORT_C void asn1Print_AltitudeInfo
   (const char* name, ASN1T_AltitudeInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  PositionEstimate                                          */
/*                                                            */
/**************************************************************/

#define TV_PositionEstimate	(TM_UNIV|TM_CONS|16)

struct ASN1T_PositionEstimate {
   struct {
      unsigned uncertaintyPresent : 1;
      unsigned confidencePresent : 1;
      unsigned altitudeInfoPresent : 1;
   } m;
   ASN1T_PositionEstimate_latitudeSign latitudeSign;
   OSUINT32 latitude;
   OSINT32 longitude;
   ASN1T_PositionEstimate_uncertainty uncertainty;
   OSUINT8 confidence;
   ASN1T_AltitudeInfo altitudeInfo;
   IMPORT_C ASN1T_PositionEstimate ();
} ;

IMPORT_C int asn1PE_PositionEstimate (OSCTXT* pctxt, ASN1T_PositionEstimate* pvalue);

IMPORT_C int asn1PD_PositionEstimate (OSCTXT* pctxt, ASN1T_PositionEstimate* pvalue);

IMPORT_C void asn1Print_PositionEstimate
   (const char* name, ASN1T_PositionEstimate* pvalue);

/**************************************************************/
/*                                                            */
/*  Horvel_bearing                                            */
/*                                                            */
/**************************************************************/

#define TV_Horvel_bearing	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horvel_bearing {
   OSUINT32  numbits;
   OSOCTET data[2];
   // ctors
   ASN1T_Horvel_bearing () : numbits(0) {}
   ASN1T_Horvel_bearing (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horvel_bearing (OSCTXT* pctxt, ASN1T_Horvel_bearing* pvalue);

IMPORT_C int asn1PD_Horvel_bearing (OSCTXT* pctxt, ASN1T_Horvel_bearing* pvalue);

IMPORT_C void asn1Print_Horvel_bearing
   (const char* name, ASN1T_Horvel_bearing* pvalue);

/**************************************************************/
/*                                                            */
/*  Horvel_horspeed                                           */
/*                                                            */
/**************************************************************/

#define TV_Horvel_horspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horvel_horspeed {
   OSUINT32  numbits;
   OSOCTET data[2];
   // ctors
   ASN1T_Horvel_horspeed () : numbits(0) {}
   ASN1T_Horvel_horspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horvel_horspeed (OSCTXT* pctxt, ASN1T_Horvel_horspeed* pvalue);

IMPORT_C int asn1PD_Horvel_horspeed (OSCTXT* pctxt, ASN1T_Horvel_horspeed* pvalue);

IMPORT_C void asn1Print_Horvel_horspeed
   (const char* name, ASN1T_Horvel_horspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horvel                                                    */
/*                                                            */
/**************************************************************/

#define TV_Horvel	(TM_UNIV|TM_CONS|16)

struct ASN1T_Horvel {
   ASN1T_Horvel_bearing bearing;
   ASN1T_Horvel_horspeed horspeed;
   IMPORT_C ASN1T_Horvel ();
} ;

IMPORT_C int asn1PE_Horvel (OSCTXT* pctxt, ASN1T_Horvel* pvalue);

IMPORT_C int asn1PD_Horvel (OSCTXT* pctxt, ASN1T_Horvel* pvalue);

IMPORT_C void asn1Print_Horvel
   (const char* name, ASN1T_Horvel* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandvervel_verdirect                                    */
/*                                                            */
/**************************************************************/

#define TV_Horandvervel_verdirect	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandvervel_verdirect {
   OSUINT32  numbits;
   OSOCTET data[1];
   // ctors
   ASN1T_Horandvervel_verdirect () : numbits(0) {}
   ASN1T_Horandvervel_verdirect (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandvervel_verdirect (OSCTXT* pctxt, ASN1T_Horandvervel_verdirect* pvalue);

IMPORT_C int asn1PD_Horandvervel_verdirect (OSCTXT* pctxt, ASN1T_Horandvervel_verdirect* pvalue);

IMPORT_C void asn1Print_Horandvervel_verdirect
   (const char* name, ASN1T_Horandvervel_verdirect* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandvervel_bearing                                      */
/*                                                            */
/**************************************************************/

#define TV_Horandvervel_bearing	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandvervel_bearing {
   OSUINT32  numbits;
   OSOCTET data[2];
   // ctors
   ASN1T_Horandvervel_bearing () : numbits(0) {}
   ASN1T_Horandvervel_bearing (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandvervel_bearing (OSCTXT* pctxt, ASN1T_Horandvervel_bearing* pvalue);

IMPORT_C int asn1PD_Horandvervel_bearing (OSCTXT* pctxt, ASN1T_Horandvervel_bearing* pvalue);

IMPORT_C void asn1Print_Horandvervel_bearing
   (const char* name, ASN1T_Horandvervel_bearing* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandvervel_horspeed                                     */
/*                                                            */
/**************************************************************/

#define TV_Horandvervel_horspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandvervel_horspeed {
   OSUINT32  numbits;
   OSOCTET data[2];
   // ctors
   ASN1T_Horandvervel_horspeed () : numbits(0) {}
   ASN1T_Horandvervel_horspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandvervel_horspeed (OSCTXT* pctxt, ASN1T_Horandvervel_horspeed* pvalue);

IMPORT_C int asn1PD_Horandvervel_horspeed (OSCTXT* pctxt, ASN1T_Horandvervel_horspeed* pvalue);

IMPORT_C void asn1Print_Horandvervel_horspeed
   (const char* name, ASN1T_Horandvervel_horspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandvervel_verspeed                                     */
/*                                                            */
/**************************************************************/

#define TV_Horandvervel_verspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandvervel_verspeed {
   OSUINT32  numbits;
   OSOCTET data[1];
   // ctors
   ASN1T_Horandvervel_verspeed () : numbits(0) {}
   ASN1T_Horandvervel_verspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandvervel_verspeed (OSCTXT* pctxt, ASN1T_Horandvervel_verspeed* pvalue);

IMPORT_C int asn1PD_Horandvervel_verspeed (OSCTXT* pctxt, ASN1T_Horandvervel_verspeed* pvalue);

IMPORT_C void asn1Print_Horandvervel_verspeed
   (const char* name, ASN1T_Horandvervel_verspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandvervel                                              */
/*                                                            */
/**************************************************************/

#define TV_Horandvervel	(TM_UNIV|TM_CONS|16)

struct ASN1T_Horandvervel {
   ASN1T_Horandvervel_verdirect verdirect;
   ASN1T_Horandvervel_bearing bearing;
   ASN1T_Horandvervel_horspeed horspeed;
   ASN1T_Horandvervel_verspeed verspeed;
   IMPORT_C ASN1T_Horandvervel ();
} ;

IMPORT_C int asn1PE_Horandvervel (OSCTXT* pctxt, ASN1T_Horandvervel* pvalue);

IMPORT_C int asn1PD_Horandvervel (OSCTXT* pctxt, ASN1T_Horandvervel* pvalue);

IMPORT_C void asn1Print_Horandvervel
   (const char* name, ASN1T_Horandvervel* pvalue);

/**************************************************************/
/*                                                            */
/*  Horveluncert_bearing                                      */
/*                                                            */
/**************************************************************/

#define TV_Horveluncert_bearing	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horveluncert_bearing {
   OSUINT32  numbits;
   OSOCTET data[2];
   // ctors
   ASN1T_Horveluncert_bearing () : numbits(0) {}
   ASN1T_Horveluncert_bearing (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horveluncert_bearing (OSCTXT* pctxt, ASN1T_Horveluncert_bearing* pvalue);

IMPORT_C int asn1PD_Horveluncert_bearing (OSCTXT* pctxt, ASN1T_Horveluncert_bearing* pvalue);

IMPORT_C void asn1Print_Horveluncert_bearing
   (const char* name, ASN1T_Horveluncert_bearing* pvalue);

/**************************************************************/
/*                                                            */
/*  Horveluncert_horspeed                                     */
/*                                                            */
/**************************************************************/

#define TV_Horveluncert_horspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horveluncert_horspeed {
   OSUINT32  numbits;
   OSOCTET data[2];
   // ctors
   ASN1T_Horveluncert_horspeed () : numbits(0) {}
   ASN1T_Horveluncert_horspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horveluncert_horspeed (OSCTXT* pctxt, ASN1T_Horveluncert_horspeed* pvalue);

IMPORT_C int asn1PD_Horveluncert_horspeed (OSCTXT* pctxt, ASN1T_Horveluncert_horspeed* pvalue);

IMPORT_C void asn1Print_Horveluncert_horspeed
   (const char* name, ASN1T_Horveluncert_horspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horveluncert_uncertspeed                                  */
/*                                                            */
/**************************************************************/

#define TV_Horveluncert_uncertspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horveluncert_uncertspeed {
   OSUINT32  numbits;
   OSOCTET data[1];
   // ctors
   ASN1T_Horveluncert_uncertspeed () : numbits(0) {}
   ASN1T_Horveluncert_uncertspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horveluncert_uncertspeed (OSCTXT* pctxt, ASN1T_Horveluncert_uncertspeed* pvalue);

IMPORT_C int asn1PD_Horveluncert_uncertspeed (OSCTXT* pctxt, ASN1T_Horveluncert_uncertspeed* pvalue);

IMPORT_C void asn1Print_Horveluncert_uncertspeed
   (const char* name, ASN1T_Horveluncert_uncertspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horveluncert                                              */
/*                                                            */
/**************************************************************/

#define TV_Horveluncert	(TM_UNIV|TM_CONS|16)

struct ASN1T_Horveluncert {
   ASN1T_Horveluncert_bearing bearing;
   ASN1T_Horveluncert_horspeed horspeed;
   ASN1T_Horveluncert_uncertspeed uncertspeed;
   IMPORT_C ASN1T_Horveluncert ();
} ;

IMPORT_C int asn1PE_Horveluncert (OSCTXT* pctxt, ASN1T_Horveluncert* pvalue);

IMPORT_C int asn1PD_Horveluncert (OSCTXT* pctxt, ASN1T_Horveluncert* pvalue);

IMPORT_C void asn1Print_Horveluncert
   (const char* name, ASN1T_Horveluncert* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandveruncert_verdirect                                 */
/*                                                            */
/**************************************************************/

#define TV_Horandveruncert_verdirect	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandveruncert_verdirect {
   OSUINT32  numbits;
   OSOCTET data[1];
   // ctors
   ASN1T_Horandveruncert_verdirect () : numbits(0) {}
   ASN1T_Horandveruncert_verdirect (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandveruncert_verdirect (OSCTXT* pctxt, ASN1T_Horandveruncert_verdirect* pvalue);

IMPORT_C int asn1PD_Horandveruncert_verdirect (OSCTXT* pctxt, ASN1T_Horandveruncert_verdirect* pvalue);

IMPORT_C void asn1Print_Horandveruncert_verdirect
   (const char* name, ASN1T_Horandveruncert_verdirect* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandveruncert_bearing                                   */
/*                                                            */
/**************************************************************/

#define TV_Horandveruncert_bearing	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandveruncert_bearing {
   OSUINT32  numbits;
   OSOCTET data[2];
   // ctors
   ASN1T_Horandveruncert_bearing () : numbits(0) {}
   ASN1T_Horandveruncert_bearing (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandveruncert_bearing (OSCTXT* pctxt, ASN1T_Horandveruncert_bearing* pvalue);

IMPORT_C int asn1PD_Horandveruncert_bearing (OSCTXT* pctxt, ASN1T_Horandveruncert_bearing* pvalue);

IMPORT_C void asn1Print_Horandveruncert_bearing
   (const char* name, ASN1T_Horandveruncert_bearing* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandveruncert_horspeed                                  */
/*                                                            */
/**************************************************************/

#define TV_Horandveruncert_horspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandveruncert_horspeed {
   OSUINT32  numbits;
   OSOCTET data[2];
   // ctors
   ASN1T_Horandveruncert_horspeed () : numbits(0) {}
   ASN1T_Horandveruncert_horspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandveruncert_horspeed (OSCTXT* pctxt, ASN1T_Horandveruncert_horspeed* pvalue);

IMPORT_C int asn1PD_Horandveruncert_horspeed (OSCTXT* pctxt, ASN1T_Horandveruncert_horspeed* pvalue);

IMPORT_C void asn1Print_Horandveruncert_horspeed
   (const char* name, ASN1T_Horandveruncert_horspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandveruncert_verspeed                                  */
/*                                                            */
/**************************************************************/

#define TV_Horandveruncert_verspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandveruncert_verspeed {
   OSUINT32  numbits;
   OSOCTET data[1];
   // ctors
   ASN1T_Horandveruncert_verspeed () : numbits(0) {}
   ASN1T_Horandveruncert_verspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandveruncert_verspeed (OSCTXT* pctxt, ASN1T_Horandveruncert_verspeed* pvalue);

IMPORT_C int asn1PD_Horandveruncert_verspeed (OSCTXT* pctxt, ASN1T_Horandveruncert_verspeed* pvalue);

IMPORT_C void asn1Print_Horandveruncert_verspeed
   (const char* name, ASN1T_Horandveruncert_verspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandveruncert_horuncertspeed                            */
/*                                                            */
/**************************************************************/

#define TV_Horandveruncert_horuncertspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandveruncert_horuncertspeed {
   OSUINT32  numbits;
   OSOCTET data[1];
   // ctors
   ASN1T_Horandveruncert_horuncertspeed () : numbits(0) {}
   ASN1T_Horandveruncert_horuncertspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandveruncert_horuncertspeed (OSCTXT* pctxt, ASN1T_Horandveruncert_horuncertspeed* pvalue);

IMPORT_C int asn1PD_Horandveruncert_horuncertspeed (OSCTXT* pctxt, ASN1T_Horandveruncert_horuncertspeed* pvalue);

IMPORT_C void asn1Print_Horandveruncert_horuncertspeed
   (const char* name, ASN1T_Horandveruncert_horuncertspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandveruncert_veruncertspeed                            */
/*                                                            */
/**************************************************************/

#define TV_Horandveruncert_veruncertspeed	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Horandveruncert_veruncertspeed {
   OSUINT32  numbits;
   OSOCTET data[1];
   // ctors
   ASN1T_Horandveruncert_veruncertspeed () : numbits(0) {}
   ASN1T_Horandveruncert_veruncertspeed (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Horandveruncert_veruncertspeed (OSCTXT* pctxt, ASN1T_Horandveruncert_veruncertspeed* pvalue);

IMPORT_C int asn1PD_Horandveruncert_veruncertspeed (OSCTXT* pctxt, ASN1T_Horandveruncert_veruncertspeed* pvalue);

IMPORT_C void asn1Print_Horandveruncert_veruncertspeed
   (const char* name, ASN1T_Horandveruncert_veruncertspeed* pvalue);

/**************************************************************/
/*                                                            */
/*  Horandveruncert                                           */
/*                                                            */
/**************************************************************/

#define TV_Horandveruncert	(TM_UNIV|TM_CONS|16)

struct ASN1T_Horandveruncert {
   ASN1T_Horandveruncert_verdirect verdirect;
   ASN1T_Horandveruncert_bearing bearing;
   ASN1T_Horandveruncert_horspeed horspeed;
   ASN1T_Horandveruncert_verspeed verspeed;
   ASN1T_Horandveruncert_horuncertspeed horuncertspeed;
   ASN1T_Horandveruncert_veruncertspeed veruncertspeed;
   IMPORT_C ASN1T_Horandveruncert ();
} ;

IMPORT_C int asn1PE_Horandveruncert (OSCTXT* pctxt, ASN1T_Horandveruncert* pvalue);

IMPORT_C int asn1PD_Horandveruncert (OSCTXT* pctxt, ASN1T_Horandveruncert* pvalue);

IMPORT_C void asn1Print_Horandveruncert
   (const char* name, ASN1T_Horandveruncert* pvalue);

/**************************************************************/
/*                                                            */
/*  Velocity                                                  */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_Velocity_horvel               1
#define T_Velocity_horandvervel         2
#define T_Velocity_horveluncert         3
#define T_Velocity_horandveruncert      4
#define T_Velocity_extElem1             5

struct ASN1T_Velocity {
   int t;
   union {
      /* t = 1 */
      ASN1T_Horvel *horvel;
      /* t = 2 */
      ASN1T_Horandvervel *horandvervel;
      /* t = 3 */
      ASN1T_Horveluncert *horveluncert;
      /* t = 4 */
      ASN1T_Horandveruncert *horandveruncert;
      /* t = 5 */
   } u;
} ;

IMPORT_C int asn1PE_Velocity (OSCTXT* pctxt, ASN1T_Velocity* pvalue);

IMPORT_C int asn1PD_Velocity (OSCTXT* pctxt, ASN1T_Velocity* pvalue);

IMPORT_C void asn1Print_Velocity
   (const char* name, ASN1T_Velocity* pvalue);

IMPORT_C void asn1Free_Velocity (OSCTXT *pctxt, ASN1T_Velocity* pvalue);

/**************************************************************/
/*                                                            */
/*  Position                                                  */
/*                                                            */
/**************************************************************/

#define TV_Position	(TM_UNIV|TM_CONS|16)

struct ASN1T_Position {
   struct {
      unsigned velocityPresent : 1;
   } m;
   const char* timestamp;
   ASN1T_PositionEstimate positionEstimate;
   ASN1T_Velocity velocity;
   IMPORT_C ASN1T_Position ();
} ;

IMPORT_C int asn1PE_Position (OSCTXT* pctxt, ASN1T_Position* pvalue);

IMPORT_C int asn1PD_Position (OSCTXT* pctxt, ASN1T_Position* pvalue);

IMPORT_C void asn1Print_Position
   (const char* name, ASN1T_Position* pvalue);

IMPORT_C void asn1Free_Position (OSCTXT *pctxt, ASN1T_Position* pvalue);

/**************************************************************/
/*                                                            */
/*  Ver                                                       */
/*                                                            */
/**************************************************************/

#define TV_Ver	(TM_UNIV|TM_PRIM|3)

struct ASN1T_Ver {
   OSUINT32  numbits;
   OSOCTET data[8];
   // ctors
   ASN1T_Ver () : numbits(0) {}
   ASN1T_Ver (OSUINT32 _numbits, const OSOCTET* _data) :
      numbits(_numbits) {
      OSCRTLMEMCPY (data, _data, sizeof(data));
   }
} ;

IMPORT_C int asn1PE_Ver (OSCTXT* pctxt, ASN1T_Ver* pvalue);

IMPORT_C int asn1PD_Ver (OSCTXT* pctxt, ASN1T_Ver* pvalue);

IMPORT_C void asn1Print_Ver
   (const char* name, ASN1T_Ver* pvalue);

/**************************************************************/
/*                                                            */
/*  StatusCode                                                */
/*                                                            */
/**************************************************************/

#define TV_StatusCode	(TM_UNIV|TM_PRIM|10)

struct StatusCode {
   enum Root {
      unspecified = 0,
      systemFailure = 1,
      unexpectedMessage = 2,
      protocolError = 3,
      dataMissing = 4,
      unexpectedDataValue = 5,
      posMethodFailure = 6,
      posMethodMismatch = 7,
      posProtocolMismatch = 8,
      targetSETnotReachable = 9,
      versionNotSupported = 10,
      resourceShortage = 11,
      invalidSessionId = 12,
      nonProxyModeNotSupported = 13,
      proxyModeNotSupported = 14,
      positioningNotPermitted = 15,
      authNetFailure = 16,
      authSuplinitFailure = 17,
      consentDeniedByUser = 100,
      consentGrantedByUser = 101
   } ;
} ;

typedef OSUINT32 ASN1T_StatusCode;

IMPORT_C int asn1PE_StatusCode (OSCTXT* pctxt, ASN1T_StatusCode value);

IMPORT_C int asn1PD_StatusCode (OSCTXT* pctxt, ASN1T_StatusCode* pvalue);

IMPORT_C void asn1Print_StatusCode
   (const char* name, ASN1T_StatusCode* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_StatusCode_ToString (OSINT32 value);

IMPORT_C int ASN1T_StatusCode_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_StatusCode* pvalue);

#endif
